(function () {
    'use strict';

    angular.module('ariaNg').config(['$translateProvider', 'ariaNgConstants', function ($translateProvider, ariaNgConstants) {
        var defaultLanguageResource = {
            'AriaNg Version': 'AriaNg Version',
            'Operation Result': 'Operation Result',
            'Operation Succeeded': 'Operation Succeeded',
            'is connected': 'is connected',
            'Error': 'Error',
            'OK': 'OK',
            'Confirm': 'Confirm',
            'Cancel': 'Cancel',
            'Close': 'Close',
            'Browse': 'Browse',
            'Clear': 'Clear',
            'True': 'True',
            'False': 'False',
            'DEBUG': 'Debug',
            'INFO': 'Info',
            'WARN': 'Warn',
            'ERROR': 'Error',
            'Connecting': 'Connecting',
            'Connected': 'Connected',
            'Disconnected': 'Disconnected',
            'Reconnecting': 'Reconnecting',
            'Waiting to reconnect': 'Waiting to reconnect',
            'Global': 'Global',
            'New': 'New',
            'Start': 'Start',
            'Pause': 'Pause',
            'Retry': 'Retry',
            'Retry Selected Tasks': 'Retry Selected Tasks',
            'Delete': 'Delete',
            'Select All': 'Select All',
            'Select None': 'Select None',
            'Select Invert': 'Select Invert',
            'Select All Failed Tasks': 'Select All Failed Tasks',
            'Select All Completed Tasks': 'Select All Completed Tasks',
            'Select All Tasks': 'Select All Tasks',
            'Display Order': 'Display Order',
            'Copy Download Url': 'Copy Download Url',
            'Copy Magnet Link': 'Copy Magnet Link',
            'Help': 'Help',
            'Search': 'Search',
            'Default': 'Default',
            'Expand': 'Expand',
            'Collapse': 'Collapse',
            'Expand All': 'Expand All',
            'Collapse All': 'Collapse All',
            'Open': 'Open',
            'Save': 'Save',
            'Import': 'Import',
            'Remove Task': 'Remove Task',
            'Remove Selected Task': 'Remove Selected Task',
            'Clear Stopped Tasks': 'Clear Stopped Tasks',
            'Click to view task detail': 'Click to view task detail',
            'By File Name': 'By File Name',
            'By File Size': 'By File Size',
            'By Progress': 'By Progress',
            'By Selected Status': 'By Selected Status',
            'By Remaining': 'By Remaining',
            'By Download Speed': 'By Download Speed',
            'By Upload Speed': 'By Upload Speed',
            'By Peer Address': 'By Peer Address',
            'By Client Name': 'By Client Name',
            'Filters': 'Filters',
            'Download': 'Download',
            'Upload': 'Upload',
            'Downloading': 'Downloading',
            'Pending Verification': 'Pending Verification',
            'Verifying': 'Verifying',
            'Seeding': 'Seeding',
            'Waiting': 'Waiting',
            'Paused': 'Paused',
            'Completed': 'Completed',
            'Error Occurred': 'Error Occurred',
            'Removed': 'Removed',
            'Finished / Stopped': 'Finished / Stopped',
            'Uncompleted': 'Uncompleted',
            'Click to pin': 'Click to pin',
            'Settings': 'Settings',
            'AriaNg Settings': 'AriaNg Settings',
            'Aria2 Settings': 'Aria2 Settings',
            'Basic Settings': 'Basic Settings',
            'HTTP/FTP/SFTP Settings': 'HTTP/FTP/SFTP Settings',
            'HTTP Settings': 'HTTP Settings',
            'FTP/SFTP Settings': 'FTP/SFTP Settings',
            'BitTorrent Settings': 'BitTorrent Settings',
            'Metalink Settings': 'Metalink Settings',
            'RPC Settings': 'RPC Settings',
            'Advanced Settings': 'Advanced Settings',
            'AriaNg Debug Console': 'AriaNg Debug Console',
            'Aria2 Status': 'Aria2 Status',
            'File Name': 'File Name',
            'File Size': 'File Size',
            'Progress': 'Progress',
            'Share Ratio': 'Share Ratio',
            'Remaining': 'Remaining',
            'Download Speed': 'Download Speed',
            'Upload Speed': 'Upload Speed',
            'Links': 'Links',
            'Torrent File': 'Torrent File',
            'Metalink File': 'Metalink File',
            'File Name:': 'File Name:',
            'Torrent Info:': 'Torrent Info:',
            'Name': 'Name',
            'Comment': 'Comment',
            'Options': 'Options',
            'Overview': 'Overview',
            'Pieces': 'Pieces',
            'Files': 'Files',
            'Peers': 'Peers',
            'Task Name': 'Task Name',
            'Task Size': 'Task Size',
            'Task Status': 'Task Status',
            'Error Description': 'Error Description',
            'Health Percentage': 'Health Percentage',
            'Info Hash': 'Info Hash',
            'Seeders': 'Seeders',
            'Connections': 'Connections',
            'Private Torrent': 'Private Torrent',
            'Seed Creation Time': 'Seed Creation Time',
            'Download Url': 'Download Url',
            'Download Dir': 'Download Dir',
            'BT Tracker Servers': 'BT Tracker Servers',
            'Copy': 'Copy',
            '(Choose Files)': '(Choose Files)',
            'All Files': 'All Files',
            'Videos': 'Videos',
            'Audios': 'Audios',
            'Pictures': 'Pictures',
            'Documents': 'Documents',
            'Applications': 'Applications',
            'Archives': 'Archives',
            'Other': 'Other',
            'Custom': 'Custom',
            'Custom Choose File': 'Custom Choose File',
            'Address': 'Address',
            'Client': 'Client',
            'Status': 'Status',
            'Speed': 'Speed',
            '(local)': '(local)',
            'No Data': 'No Data',
            'No connected peers': 'No connected peers',
            'Failed to change some tasks state.': 'Failed to change some tasks state.',
            'Confirm Retry': 'Confirm Retry',
            'Are you sure you want to retry the selected task? AriaNg will create same task after clicking OK.': 'Are you sure you want to retry the selected task? AriaNg will create same task after clicking OK.',
            'Failed to retry this task.': 'Failed to retry this task.',
            '{successCount} tasks have been retried and {failedCount} tasks are failed.': '{{successCount}} tasks have been retried and {{failedCount}} tasks are failed.',
            'Confirm Remove': 'Confirm Remove',
            'Are you sure you want to remove the selected task?': 'Are you sure you want to remove the selected task?',
            'Failed to remove some task(s).': 'Failed to remove some task(s).',
            'Confirm Clear': 'Confirm Clear',
            'Are you sure you want to clear stopped tasks?': 'Are you sure you want to clear stopped tasks?',
            'Download Links:': 'Download Links:',
            'Download Now': 'Download Now',
            'Download Later': 'Download Later',
            'Open Torrent File': 'Open Torrent File',
            'Open Metalink File': 'Open Metalink File',
            'Support multiple URLs, one URL per line.': 'Support multiple URLs, one URL per line.',
            'Your browser does not support loading file!': 'Your browser does not support loading file!',
            'The selected file type is invalid!': 'The selected file type is invalid!',
            'Failed to load file!': 'Failed to load file!',
            'Download Completed': 'Download Completed',
            'BT Download Completed': 'BT Download Completed',
            'Download Error': 'Download Error',
            'AriaNg Url': 'AriaNg Url',
            'Command API Url': 'Command API Url',
            'Export Command API': 'Export Command API',
            'Export': 'Export',
            'Copied': 'Copied',
            'Pause After Task Created': 'Pause After Task Created',
            'Based on': 'Based on',
            'Check Update': 'Check Update',
            'Latest Version': 'Latest Version',
            'You have installed the latest version!': 'You have installed the latest version!',
            'Failed to get latest version!': 'Failed to get latest version!',
            'Language': 'Language',
            'Theme': 'Theme',
            'Light': 'Light',
            'Dark': 'Dark',
            'Follow system settings': 'Follow system settings',
            'Debug Mode': 'Debug Mode',
            'Check for Updates on Startup': 'Check for Updates on Startup',
            'Daily': 'Daily',
            'Weekly': 'Weekly',
            'Monthly': 'Monthly',
            'Page Title': 'Page Title',
            'Preview': 'Preview',
            'Tips: You can use the "noprefix" tag to ignore the prefix, "nosuffix" tag to ignore the suffix, and "scale=n" tag to set the decimal precision.': 'Tips: You can use the "noprefix" tag to ignore the prefix, "nosuffix" tag to ignore the suffix, and "scale=n" tag to set the decimal precision.',
            'Example: ${downspeed:noprefix:nosuffix:scale=1}': 'Example: ${downspeed:noprefix:nosuffix:scale=1}',
            'Updating Page Title Interval': 'Updating Page Title Interval',
            'Enable Browser Notification': 'Enable Browser Notification',
            'Enable System Notification': 'Enable System Notification',
            'Browser Notification Sound': 'Browser Notification Sound',
            'System Notification Sound': 'System Notification Sound',
            'Browser Notification Frequency': 'Browser Notification Frequency',
            'System Notification Frequency': 'System Notification Frequency',
            'Unlimited': 'Unlimited',
            'High (Up to 10 Notifications / 1 Minute)': 'High (Up to 10 Notifications / 1 Minute)',
            'Middle (Up to 1 Notification / 1 Minute)': 'Middle (Up to 1 Notification / 1 Minute)',
            'Low (Up to 1 Notification / 5 Minutes)': 'Low (Up to 1 Notification / 5 Minutes)',
            'Play Sound After Download Finished': 'Play Sound After Download Finished',
            'Play Sound': 'Play Sound',
            'Stop Playing Sound': 'Stop Playing Sound',
            'This sound file type is not supported.': 'This sound file type is not supported.',
            'Sound file not exists.': 'Sound file not exists.',
            'Cannot play this sound file.': 'Cannot play this sound file.',
            'WebSocket Auto Reconnect Interval': 'WebSocket Auto Reconnect Interval',
            'Aria2 RPC Alias': 'Aria2 RPC Alias',
            'Aria2 RPC Address': 'Aria2 RPC Address',
            'Aria2 RPC Protocol': 'Aria2 RPC Protocol',
            'Aria2 RPC Http Request Method': 'Aria2 RPC Http Request Method',
            'POST method only supports aria2 v1.15.2 and above.': 'POST method only supports aria2 v1.15.2 and above.',
            'Aria2 RPC Request Headers': 'Aria2 RPC Request Headers',
            'Support multiple request headers, one header per line, each line containing "header name: header value".': 'Support multiple request headers, one header per line, each line containing "header name: header value".',
            'Aria2 RPC Secret Token': 'Aria2 RPC Secret Token',
            'Activate': 'Activate',
            'Reset Settings': 'Reset Settings',
            'Confirm Reset': 'Confirm Reset',
            'Are you sure you want to reset all settings?': 'Are you sure you want to reset all settings?',
            'Clear Settings History': 'Clear Settings History',
            'Are you sure you want to clear all settings history?': 'Are you sure you want to clear all settings history?',
            'Delete RPC Setting': 'Delete RPC Setting',
            'Add New RPC Setting': 'Add New RPC Setting',
            'Are you sure you want to remove rpc setting "{rpcName}"?': 'Are you sure you want to remove rpc setting "{{rpcName}}"?',
            'Updating Global Stat Interval': 'Updating Global Stat Interval',
            'Updating Task Information Interval': 'Updating Task Information Interval',
            'Keyboard Shortcuts': 'Keyboard Shortcuts',
            'Supported Keyboard Shortcuts': 'Supported Keyboard Shortcuts',
            'Set Focus On Search Box': 'Set Focus On Search Box',
            'Open Browser DevTools': 'Open Browser DevTools',
            'Swipe Gesture': 'Swipe Gesture',
            'Change Tasks Order by Drag-and-drop': 'Change Tasks Order by Drag-and-drop',
            'Action After Creating New Tasks': 'Action After Creating New Tasks',
            'Navigate to Task List Page': 'Navigate to Task List Page',
            'Navigate to Task Detail Page': 'Navigate to Task Detail Page',
            'Action After Retrying Task': 'Action After Retrying Task',
            'Navigate to Downloading Tasks Page': 'Navigate to Downloading Tasks Page',
            'Stay on Current Page': 'Stay on Current Page',
            'Remove Old Tasks After Retrying': 'Remove Old Tasks After Retrying',
            'Confirm Task Removal': 'Confirm Task Removal',
            'Include Prefix When Copying From Task Details': 'Include Prefix When Copying From Task Details',
            'Show Pieces Info In Task Detail Page': 'Show Pieces Info In Task Detail Page',
            'Pieces Amount is Less than or Equal to {value}': 'Pieces Amount is Less than or Equal to {{value}}',
            'Default Window Position': 'Default Window Position',
            'Last Position': 'Last Position',
            'Screen Center': 'Screen Center',
            'Execute Command on Startup': 'Execute Command on Startup',
            'Execute Command Arguments on Startup': 'Execute Command Arguments on Startup',
            'Support multiple arguments, one argument per line.': 'Support multiple arguments, one argument per line.',
            'Execute Command Options on Startup': 'Execute Command Options on Startup',
            'As Child Process': 'As Child Process',
            'As Detached Process': 'As Detached Process',
            'Action After Main Window Closed': 'Action After Main Window Closed',
            'Exit Application': 'Exit Application',
            'Minimize to Tray': 'Minimize to Tray',
            'RPC List Display Order': 'RPC List Display Order',
            'Each Task List Page Uses Independent Display Order': 'Each Task List Page Uses Independent Display Order',
            'Recently Used': 'Recently Used',
            'RPC Alias': 'RPC Alias',
            'Import / Export AriaNg Settings': 'Import / Export AriaNg Settings',
            'Import / Export AriaNg Native Settings': 'Import / Export AriaNg Native Settings',
            'Import Settings': 'Import Settings',
            'Export Settings': 'Export Settings',
            'AriaNg settings data': 'AriaNg settings data',
            'AriaNg Native settings data': 'AriaNg Native settings data',
            'Confirm Import': 'Confirm Import',
            'Are you sure you want to import all settings?': 'Are you sure you want to import all settings?',
            'Invalid settings data format!': 'Invalid settings data format!',
            'Data has been copied to clipboard.': 'Data has been copied to clipboard.',
            'Supported Placeholder': 'Supported Placeholder',
            'AriaNg Title': 'AriaNg Title',
            'Current RPC Alias': 'Current RPC Alias',
            'Downloading Count': 'Downloading Count',
            'Waiting Count': 'Waiting Count',
            'Stopped Count': 'Stopped Count',
            'You have disabled notification in your browser. You should change your browser\'s settings before you enable this function.': 'You have disabled notification in your browser. You should change your browser\'s settings before you enable this function.',
            'Language resource has been updated, please reload the page for the changes to take effect.': 'Language resource has been updated, please reload the page for the changes to take effect.',
            'Configuration has been modified, please reload the page for the changes to take effect.': 'Configuration has been modified, please reload the page for the changes to take effect.',
            'Reload AriaNg': 'Reload AriaNg',
            'Show Secret': 'Show Secret',
            'Hide Secret': 'Hide Secret',
            'Aria2 Version': 'Aria2 Version',
            'Enabled Features': 'Enabled Features',
            'Operations': 'Operations',
            'Reconnect': 'Reconnect',
            'Save Session': 'Save Session',
            'Shutdown Aria2': 'Shutdown Aria2',
            'Confirm Shutdown': 'Confirm Shutdown',
            'Are you sure you want to shutdown aria2?': 'Are you sure you want to shutdown aria2?',
            'Session has been saved successfully.': 'Session has been saved successfully.',
            'Aria2 has been shutdown successfully.': 'Aria2 has been shutdown successfully.',
            'Toggle Navigation': 'Toggle Navigation',
            'Shortcut': 'Shortcut',
            'Global Rate Limit': 'Global Rate Limit',
            'Loading': 'Loading...',
            'More Than One Day': 'More than 1 day',
            'Unknown': 'Unknown',
            'Bytes': 'Bytes',
            'Hours': 'Hours',
            'Minutes': 'Minutes',
            'Seconds': 'Seconds',
            'Milliseconds': 'Milliseconds',
            'Http': 'Http',
            'Http (Disabled)': 'Http (Disabled)',
            'Https': 'Https',
            'WebSocket': 'WebSocket',
            'WebSocket (Disabled)': 'WebSocket (Disabled)',
            'WebSocket (Security)': 'WebSocket (Security)',
            'Http and WebSocket would be disabled when accessing AriaNg via Https.': 'Http and WebSocket would be disabled when accessing AriaNg via Https.',
            'POST': 'POST',
            'GET': 'GET',
            'Enabled': 'Enabled',
            'Disabled': 'Disabled',
            'Always': 'Always',
            'Never': 'Never',
            'BitTorrent': 'BitTorrent',
            'Changes to the settings take effect after refreshing page.': 'Changes to the settings take effect after refreshing page.',
            'Logging Time': 'Logging Time',
            'Log Level': 'Log Level',
            'Auto Refresh': 'Auto Refresh',
            'Refresh Now': 'Refresh Now',
            'Clear Logs': 'Clear Logs',
            'Are you sure you want to clear debug logs?': 'Are you sure you want to clear debug logs?',
            'Show Detail': 'Show Detail',
            'Log Detail': 'Log Detail',
            'Startup Command Output': 'Startup Command Output',
            'Aria2 RPC Debug': 'Aria2 RPC Debug',
            'Aria2 RPC Request Method': 'Aria2 RPC Request Method',
            'Aria2 RPC Request Parameters': 'Aria2 RPC Request Parameters',
            'Aria2 RPC Response': 'Aria2 RPC Response',
            'Execute': 'Execute',
            'RPC method is illegal!': 'RPC method is illegal!',
            'AriaNg does not support this RPC method!': 'AriaNg does not support this RPC method!',
            'RPC request parameters are invalid!': 'RPC request parameters are invalid!',
            'Type is illegal!': 'Type is illegal!',
            'Parameter is invalid!': 'Parameter is invalid!',
            'Option value cannot be empty!': 'Option value cannot be empty!',
            'Input number is invalid!': 'Input number is invalid!',
            'Input number is below min value!': 'Input number is below min value {{value}}!',
            'Input number is above max value!': 'Input number is above max value {{value}}!',
            'Input value is invalid!': 'Input value is invalid!',
            'Protocol is invalid!': 'Protocol is invalid!',
            'RPC host cannot be empty!': 'RPC host cannot be empty!',
            'RPC secret is not base64 encoded!': 'RPC secret is not base64 encoded!',
            'URL is not base64 encoded!': 'URL is not base64 encoded!',
            'Tap to configure and get started with AriaNg.': 'Tap to configure and get started with AriaNg.',
            'Cannot initialize WebSocket!': 'Cannot initialize WebSocket!',
            'Cannot connect to aria2!': 'Cannot connect to aria2!',
            'Access Denied!': 'Access Denied!',
            'You cannot use AriaNg because this browser does not meet the minimum requirements for data storage.': 'You cannot use AriaNg because this browser does not meet the minimum requirements for data storage.',
            'AriaNg Native Updates': 'AriaNg Native Updates',
            'A new version has been released': 'A new version {{version}} has been released',
            'Minimize': 'Minimize',
            'Maximize': 'Maximize',
            'Restore Down': 'Restore Down',
            'Runtime Environment': 'Runtime Environment',
            'Reload AriaNg Native': 'Reload AriaNg Native',
            'Create New Task': 'Create New Task',
            'menu': {
                'AboutAriaNgNative': 'About AriaNg Native',
                'Services': 'Services',
                'HideAriaNgNative': 'Hide AriaNg Native',
                'HideOthers': 'Hide Others',
                'ShowAll': 'Show All',
                'QuitAriaNgNative': 'Quit AriaNg Native',
                'Edit': 'Edit',
                'Undo': 'Undo',
                'Redo': 'Redo',
                'Cut': 'Cut',
                'Copy': 'Copy',
                'Paste': 'Paste',
                'Delete': 'Delete',
                'SelectAll': 'Select All',
                'Window': 'Window',
                'Minimize': 'Minimize',
                'Zoom': 'Zoom',
                'BringAllToFront': 'Bring All to Front',
            },
            'tray': {
                'ShowAriaNgNative': '&Show AriaNg Native',
                'Exit': 'E&xit',
            },
            'error': {
                'unknown': 'Unknown error occurred.',
                'operation.timeout': 'Operation timed out.',
                'resource.notfound': 'Resource was not found.',
                'resource.notfound.max-file-not-found': 'Resource was not found. See --max-file-not-found option.',
                'download.aborted.lowest-speed-limit': 'Download is aborted because download speed was too slow. See --lowest-speed-limit option.',
                'network.problem': 'Network problem occurred.',
                'resume.notsupported': 'Remote server does not support resume.',
                'space.notenough': 'There was not enough disk space available.',
                'piece.length.different': 'Piece length was different from one in .aria2 control file. See --allow-piece-length-change option.',
                'download.sametime': 'aria2 was downloading same file at that moment.',
                'download.torrent.sametime': 'aria2 was downloading same file at that moment.',
                'file.exists': 'File already existed. See --allow-overwrite option.',
                'file.rename.failed': 'Failed to rename file. See --auto-file-renaming option.',
                'file.open.failed': 'Failed to open existing file.',
                'file.create.failed': 'Failed to create new file or truncate existing file.',
                'io.error': 'Filesystem error occurred.',
                'directory.create.failed': 'Failed to create directory.',
                'name.resolution.failed': 'Failed to resolve domain name.',
                'metalink.file.parse.failed': 'Failed to parse Metalink document.',
                'ftp.command.failed': 'FTP command failed.',
                'http.response.header.bad': 'HTTP response header was bad or unexpected.',
                'redirects.toomany': 'Too many redirects occurred.',
                'http.authorization.failed': 'HTTP authorization failed.',
                'bencoded.file.parse.failed': 'Failed to parse bencoded file (usually ".torrent" file).',
                'torrent.file.corrupted': 'The ".torrent" file was corrupted or missing information that aria2 needed.',
                'magnet.uri.bad': 'Magnet URI was bad.',
                'option.bad': 'Bad/unrecognized option was given or unexpected option argument was given.',
                'server.overload': 'The remote server was unable to handle the request due to a temporary overloading or maintenance.',
                'rpc.request.parse.failed': 'Failed to parse JSON-RPC request.',
                'checksum.failed': 'Checksum validation failed.'
            },
            'languages': {
                'English': 'English',
                'Spanish': 'Spanish',
                'French': 'French',
                'Italian': 'Italian',
                'Russian': 'Russian',
                'Simplified Chinese': 'Simplified Chinese',
                'Traditional Chinese': 'Traditional Chinese'
            },
            'format': {
                'longdate': 'MM/DD/YYYY HH:mm:ss',
                'time.millisecond': '{{value}} Millisecond',
                'time.milliseconds': '{{value}} Milliseconds',
                'time.second': '{{value}} Second',
                'time.seconds': '{{value}} Seconds',
                'time.minute': '{{value}} Minute',
                'time.minutes': '{{value}} Minutes',
                'time.hour': '{{value}} Hour',
                'time.hours': '{{value}} Hours',
                'requires.aria2-version': 'Requires aria2 v{{version}} or higher',
                'task.new.download-links': 'Download Links ({{count}} Links):',
                'task.pieceinfo': 'Completed: {{completed}}, Total: {{total}}',
                'task.error-occurred': 'Error Occurred ({{errorcode}})',
                'task.verifying-percent': 'Verifying ({{verifiedPercent}}%)',
                'settings.file-count': '({{count}} Files)',
                'settings.total-count': '(Total Count: {{count}})',
                'debug.latest-logs': 'Latest {{count}} Logs'
            },
            'native': {
                'error': {
                    'file-not-found': 'File {{filepath}} not found!'
                }
            },
            'rpc': {
                'error': {
                    'unauthorized': 'Authorization Failed!'
                }
            },
            'option': {
                'true': 'True',
                'false': 'False',
                'default': 'Default',
                'none': 'None',
                'hide': 'Hide',
                'full': 'Full',
                'http': 'Http',
                'https': 'Https',
                'ftp': 'Ftp',
                'mem': 'Memory Only',
                'get': 'GET',
                'tunnel': 'TUNNEL',
                'plain': 'Plain',
                'arc4': 'ARC4',
                'binary': 'Binary',
                'ascii': 'ASCII',
                'debug': 'Debug',
                'info': 'Info',
                'notice': 'Notice',
                'warn': 'Warn',
                'error': 'Error',
                'adaptive': 'adaptive',
                'epoll': 'epoll',
                'falloc': 'falloc',
                'feedback': 'feedback',
                'geom': 'geom',
                'inorder': 'inorder',
                'kqueue': 'kqueue',
                'poll': 'poll',
                'port': 'port',
                'prealloc': 'prealloc',
                'random': 'random',
                'select': 'select',
                'trunc': 'trunc',
                'SSLv3': 'SSLv3',
                'TLSv1': 'TLSv1',
                'TLSv1.1': 'TLSv1.1',
                'TLSv1.2': 'TLSv1.2'
            },
            'options': {
                'dir.name': 'Download Path',
                'dir.description': '',
                'log.name': 'Log File',
                'log.description': 'The file name of the log file. If - is specified, log is written to stdout. If empty string("") is specified, or this option is omitted, no log is written to disk at all.',
                'max-concurrent-downloads.name': 'Max Concurrent Downloads',
                'max-concurrent-downloads.description': '',
                'check-integrity.name': 'Check Integrity',
                'check-integrity.description': 'Check file integrity by validating piece hashes or a hash of entire file. This option has effect only in BitTorrent, Metalink downloads with checksums or HTTP(S)/FTP downloads with --checksum option.',
                'continue.name': 'Resume Download',
                'continue.description': 'Continue downloading a partially downloaded file. Use this option to resume a download started by a web browser or another program which downloads files sequentially from the beginning. Currently this option is only applicable to HTTP(S)/FTP downloads.',
                'all-proxy.name': 'Proxy Server',
                'all-proxy.description': 'Use a proxy server for all protocols. You also can override this setting and specify a proxy server for a particular protocol using --http-proxy, --https-proxy and --ftp-proxy  This affects all downloads. The format of PROXY is [http://][USER:PASSWORD@]HOST[:PORT].',
                'all-proxy-user.name': 'Proxy User Name',
                'all-proxy-user.description': '',
                'all-proxy-passwd.name': 'Proxy Password',
                'all-proxy-passwd.description': '',
                'checksum.name': 'Checksum',
                'checksum.description': 'Set checksum. The option value format is TYPE=DIGEST. TYPE is hash type. The supported hash type is listed in Hash Algorithms in aria2c -v. DIGEST is hex digest. For example, setting sha-1 digest looks like this: sha-1=0192ba11326fe2298c8cb4de616f4d4140213838 This option applies only to HTTP(S)/FTP downloads.',
                'connect-timeout.name': 'Connect Timeout',
                'connect-timeout.description': 'Set the connect timeout in seconds to establish connection to HTTP/FTP/proxy server. After the connection is established, this option makes no effect and --timeout option is used instead.',
                'dry-run.name': 'Dry Run',
                'dry-run.description': 'If true is given, aria2 just checks whether the remote file is available and doesn\'t download data. This option has effect on HTTP/FTP download. BitTorrent downloads are canceled if true is specified.',
                'lowest-speed-limit.name': 'Lowest Speed Limit',
                'lowest-speed-limit.description': 'Close connection if download speed is lower than or equal to this value(bytes per sec). 0 means aria2 does not have a lowest speed limit. You can append K or M (1K = 1024, 1M = 1024K). This option does not affect BitTorrent downloads.',
                'max-connection-per-server.name': 'Max Connection Per Server',
                'max-connection-per-server.description': '',
                'max-file-not-found.name': 'Max File Not Found Try Times',
                'max-file-not-found.description': 'If aria2 receives "file not found" status from the remote HTTP/FTP servers NUM times without getting a single byte, then force the download to fail. Specify 0 to disable this option. This options is effective only when using HTTP/FTP servers. The number of retry attempt is counted toward --max-tries, so it should be configured too.',
                'max-tries.name': 'Max Try Times',
                'max-tries.description': 'Set number of tries. 0 means unlimited.',
                'min-split-size.name': 'Min Split Size',
                'min-split-size.description': 'aria2 does not split less than 2*SIZE byte range. For example, let\'s consider downloading 20MiB file. If SIZE is 10M, aria2 can split file into 2 range [0-10MiB) and [10MiB-20MiB) and download it using 2 sources(if --split >= 2, of course). If SIZE is 15M, since 2*15M > 20MiB, aria2 does not split file and download it using 1 source. You can append K or M (1K = 1024, 1M = 1024K). Possible Values: 1M-1024M.',
                'netrc-path.name': '.netrc Path',
                'netrc-path.description': '',
                'no-netrc.name': 'Disable netrc',
                'no-netrc.description': '',
                'no-proxy.name': 'No Proxy List',
                'no-proxy.description': 'Specify a comma separated list of host names, domains and network addresses with or without a subnet mask where no proxy should be used.',
                'out.name': 'File Name',
                'out.description': 'The file name of the downloaded file. It is always relative to the directory given in --dir option. When the --force-sequential option is used, this option is ignored.',
                'proxy-method.name': 'Proxy Method',
                'proxy-method.description': 'Set the method to use in proxy request. METHOD is either GET or TUNNEL. HTTPS downloads always use TUNNEL regardless of this option.',
                'remote-time.name': 'Remote File Timestamp',
                'remote-time.description': 'Retrieve timestamp of the remote file from the remote HTTP/FTP server and if it is available, apply it to the local file.',
                'reuse-uri.name': 'Reuse Uri',
                'reuse-uri.description': 'Reuse already used URIs if no unused URIs are left.',
                'retry-wait.name': 'Retry Wait',
                'retry-wait.description': 'Set the seconds to wait between retries. When SEC > 0, aria2 will retry downloads when the HTTP server returns a 503 response.',
                'server-stat-of.name': 'Server Stat Output',
                'server-stat-of.description': 'Specify the file name to which performance profile of the servers is saved. You can load saved data using --server-stat-if option.',
                'server-stat-timeout.name': 'Server Stat Timeout',
                'server-stat-timeout.description': 'Specifies timeout in seconds to invalidate performance profile of the servers since the last contact to them.',
                'split.name': 'Split Count',
                'split.description': 'Download a file using N connections. If more than N URIs are given, first N URIs are used and remaining URIs are used for backup. If less than N URIs are given, those URIs are used more than once so that N connections total are made simultaneously. The number of connections to the same host is restricted by the --max-connection-per-server option.',
                'stream-piece-selector.name': 'Piece Selection Algorithm',
                'stream-piece-selector.description': 'Specify piece selection algorithm used in HTTP/FTP download. Piece means fixed length segment which is downloaded in parallel in segmented download. If default is given, aria2 selects piece so that it reduces the number of establishing connection. This is reasonable default behavior because establishing connection is an expensive operation. If inorder is given, aria2 selects piece which has minimum index. Index=0 means first of the file. This will be useful to view movie while downloading it. --enable-http-pipelining option may be useful to reduce re-connection overhead. Please note that aria2 honors --min-split-size option, so it will be necessary to specify a reasonable value to --min-split-size option. If random is given, aria2 selects piece randomly. Like inorder, --min-split-size option is honored. If geom is given, at the beginning aria2 selects piece which has minimum index like inorder, but it exponentially increasingly keeps space from previously selected piece. This will reduce the number of establishing connection and at the same time it will download the beginning part of the file first. This will be useful to view movie while downloading it.',
                'timeout.name': 'Timeout',
                'timeout.description': '',
                'uri-selector.name': 'URI Selection Algorithm',
                'uri-selector.description': 'Specify URI selection algorithm. The possible values are inorder, feedback and adaptive. If inorder is given, URI is tried in the order appeared in the URI list. If feedback is given, aria2 uses download speed observed in the previous downloads and choose fastest server in the URI list. This also effectively skips dead mirrors. The observed download speed is a part of performance profile of servers mentioned in --server-stat-of and --server-stat-if  If adaptive is given, selects one of the best mirrors for the first and reserved connections. For supplementary ones, it returns mirrors which has not been tested yet, and if each of them has already been tested, returns mirrors which has to be tested again. Otherwise, it doesn\'t select anymore mirrors. Like feedback, it uses a performance profile of servers.',
                'check-certificate.name': 'Check Certificate',
                'check-certificate.description': '',
                'http-accept-gzip.name': 'Accept GZip',
                'http-accept-gzip.description': 'Send Accept: deflate, gzip request header and inflate response if remote server responds with Content-Encoding: gzip or Content-Encoding: deflate.',
                'http-auth-challenge.name': 'Auth Challenge',
                'http-auth-challenge.description': 'Send HTTP authorization header only when it is requested by the server. If false is set, then authorization header is always sent to the server. There is an exception: if user name and password are embedded in URI, authorization header is always sent to the server regardless of this option.',
                'http-no-cache.name': 'No Cache',
                'http-no-cache.description': 'Send Cache-Control: no-cache and Pragma: no-cache header to avoid cached content. If false is given, these headers are not sent and you can add Cache-Control header with a directive you like using --header option.',
                'http-user.name': 'HTTP Default User Name',
                'http-user.description': '',
                'http-passwd.name': 'HTTP Default Password',
                'http-passwd.description': '',
                'http-proxy.name': 'HTTP Proxy Server',
                'http-proxy.description': '',
                'http-proxy-user.name': 'HTTP Proxy User Name',
                'http-proxy-user.description': '',
                'http-proxy-passwd.name': 'HTTP Proxy Password',
                'http-proxy-passwd.description': '',
                'https-proxy.name': 'HTTPS Proxy Server',
                'https-proxy.description': '',
                'https-proxy-user.name': 'HTTPS Proxy User Name',
                'https-proxy-user.description': '',
                'https-proxy-passwd.name': 'HTTPS Proxy Password',
                'https-proxy-passwd.description': '',
                'referer.name': 'Referer',
                'referer.description': 'Set an http referrer (Referer). This affects all http/https downloads. If * is given, the download URI is also used as the referrer. This may be useful when used together with the --parameterized-uri option.',
                'enable-http-keep-alive.name': 'Enable Persistent Connection',
                'enable-http-keep-alive.description': 'Enable HTTP/1.1 persistent connection.',
                'enable-http-pipelining.name': 'Enable HTTP Pipelining',
                'enable-http-pipelining.description': 'Enable HTTP/1.1 pipelining.',
                'header.name': 'Custom Header',
                'header.description': 'Append HEADER to HTTP request header. Put one item per line, each item containing "header name: header value".',
                'save-cookies.name': 'Cookies Path',
                'save-cookies.description': 'Save Cookies to FILE in Mozilla/Firefox(1.x/2.x)/ Netscape format. If FILE already exists, it is overwritten. Session Cookies are also saved and their expiry values are treated as 0.',
                'use-head.name': 'Use HEAD Method',
                'use-head.description': 'Use HEAD method for the first request to the HTTP server.',
                'user-agent.name': 'Custom User Agent',
                'user-agent.description': '',
                'ftp-user.name': 'FTP Default User Name',
                'ftp-user.description': '',
                'ftp-passwd.name': 'FTP Default Password',
                'ftp-passwd.description': 'If user name is embedded but password is missing in URI, aria2 tries to resolve password using .netrc. If password is found in .netrc, then use it as password. If not, use the password specified in this option.',
                'ftp-pasv.name': 'Passive Mode',
                'ftp-pasv.description': 'Use the passive mode in FTP. If false is given, the active mode will be used. This option is ignored for SFTP transfer.',
                'ftp-proxy.name': 'FTP Proxy Server',
                'ftp-proxy.description': '',
                'ftp-proxy-user.name': 'FTP Proxy User Name',
                'ftp-proxy-user.description': '',
                'ftp-proxy-passwd.name': 'FTP Proxy Password',
                'ftp-proxy-passwd.description': '',
                'ftp-type.name': 'Transfer Type',
                'ftp-type.description': '',
                'ftp-reuse-connection.name': 'Reuse Connection',
                'ftp-reuse-connection.description': '',
                'ssh-host-key-md.name': 'SSH Public Key Checksum',
                'ssh-host-key-md.description': 'Set checksum for SSH host public key. The option value format is TYPE=DIGEST. TYPE is hash type. The supported hash type is sha-1 or md5. DIGEST is hex digest. For example: sha-1=b030503d4de4539dc7885e6f0f5e256704edf4c3. This option can be used to validate server\'s public key when SFTP is used. If this option is not set, which is default, no validation takes place.',
                'bt-detach-seed-only.name': 'Detach Seed Only',
                'bt-detach-seed-only.description': 'Exclude seed only downloads when counting concurrent active downloads (See -j option). This means that if -j3 is given and this option is turned on and 3 downloads are active and one of those enters seed mode, then it is excluded from active download count (thus it becomes 2), and the next download waiting in queue gets started. But be aware that seeding item is still recognized as active download in RPC method.',
                'bt-enable-hook-after-hash-check.name': 'Enable Hook After Hash Check',
                'bt-enable-hook-after-hash-check.description': 'Allow hook command invocation after hash check (see -V option) in BitTorrent download. By default, when hash check succeeds, the command given by --on-bt-download-complete is executed. To disable this action, give false to this option.',
                'bt-enable-lpd.name': 'Enable Local Peer Discovery (LPD)',
                'bt-enable-lpd.description': 'Enable Local Peer Discovery. If a private flag is set in a torrent, aria2 doesn\'t use this feature for that download even if true is given.',
                'bt-exclude-tracker.name': 'BitTorrent Exclude Trackers',
                'bt-exclude-tracker.description': 'Comma separated list of BitTorrent tracker\'s announce URI to remove. You can use special value * which matches all URIs, thus removes all announce URIs. When specifying * in shell command-line, don\'t forget to escape or quote it.',
                'bt-external-ip.name': 'External IP',
                'bt-external-ip.description': 'Specify the external IP address to use in BitTorrent download and DHT. It may be sent to BitTorrent tracker. For DHT, this option should be set to report that local node is downloading a particular torrent. This is critical to use DHT in a private network. Although this function is named external, it can accept any kind of IP addresses.',
                'bt-force-encryption.name': 'Force Encryption',
                'bt-force-encryption.description': 'Requires BitTorrent message payload encryption with arc4. This is a shorthand of --bt-require-crypto --bt-min-crypto-level=arc4. This option does not change the option value of those options. If true is given, deny legacy BitTorrent handshake and only use Obfuscation handshake and always encrypt message payload.',
                'bt-hash-check-seed.name': 'Hash Check Before Seeding',
                'bt-hash-check-seed.description': 'If true is given, after hash check using --check-integrity option and file is complete, continue to seed file. If you want to check file and download it only when it is damaged or incomplete, set this option to false. This option has effect only on BitTorrent download.',
                'bt-load-saved-metadata.name': 'Load Saved Metadata File',
                'bt-load-saved-metadata.description': 'Before getting torrent metadata from DHT when downloading with magnet link, first try to read file saved by --bt-save-metadata option. If it is successful, then skip downloading metadata from DHT.',
                'bt-max-open-files.name': 'Max Open Files',
                'bt-max-open-files.description': 'Specify maximum number of files to open in multi-file BitTorrent/Metalink download globally.',
                'bt-max-peers.name': 'Max Peers',
                'bt-max-peers.description': 'Specify the maximum number of peers per torrent. 0 means unlimited.',
                'bt-metadata-only.name': 'Download Metadata Only',
                'bt-metadata-only.description': 'Download meta data only. The file(s) described in meta data will not be downloaded. This option has effect only when BitTorrent Magnet URI is used.',
                'bt-min-crypto-level.name': 'Min Crypto Level',
                'bt-min-crypto-level.description': 'Set minimum level of encryption method. If several encryption methods are provided by a peer, aria2 chooses the lowest one which satisfies the given level.',
                'bt-prioritize-piece.name': 'Prioritize Piece',
                'bt-prioritize-piece.description': 'Try to download first and last pieces of each file first. This is useful for previewing files. The argument can contain 2 keywords: head and tail. To include both keywords, they must be separated by comma. These keywords can take one parameter, SIZE. For example, if head=SIZE is specified, pieces in the range of first SIZE bytes of each file get higher priority. tail=SIZE means the range of last SIZE bytes of each file. SIZE can include K or M (1K = 1024, 1M = 1024K).',
                'bt-remove-unselected-file.name': 'Remove Unselected File',
                'bt-remove-unselected-file.description': 'Removes the unselected files when download is completed in BitTorrent. To select files, use --select-file option. If it is not used, all files are assumed to be selected. Please use this option with care because it will actually remove files from your disk.',
                'bt-require-crypto.name': 'Require Crypto',
                'bt-require-crypto.description': 'If true is given, aria2 doesn\'t accept and establish connection with legacy BitTorrent handshake(\\19BitTorrent protocol). Thus aria2 always uses Obfuscation handshake.',
                'bt-request-peer-speed-limit.name': 'Preferred Download Speed',
                'bt-request-peer-speed-limit.description': 'If the whole download speed of every torrent is lower than SPEED, aria2 temporarily increases the number of peers to try for more download speed. Configuring this option with your preferred download speed can increase your download speed in some cases. You can append K or M (1K = 1024, 1M = 1024K).',
                'bt-save-metadata.name': 'Save Metadata',
                'bt-save-metadata.description': 'Save meta data as ".torrent" file. This option has effect only when BitTorrent Magnet URI is used. The file name is hex encoded info hash with suffix ".torrent". The directory to be saved is the same directory where download file is saved. If the same file already exists, meta data is not saved.',
                'bt-seed-unverified.name': 'Not Verify Downloaded Fileds',
                'bt-seed-unverified.description': 'Seed previously downloaded files without verifying piece hashes.',
                'bt-stop-timeout.name': 'Stop Timeout',
                'bt-stop-timeout.description': 'Stop BitTorrent download if download speed is 0 in consecutive SEC seconds. If 0 is given, this feature is disabled.',
                'bt-tracker.name': 'BitTorrent Trackers',
                'bt-tracker.description': 'Comma separated list of additional BitTorrent tracker\'s announce URI. These URIs are not affected by --bt-exclude-tracker option because they are added after URIs in --bt-exclude-tracker option are removed.',
                'bt-tracker-connect-timeout.name': 'BitTorrent Tracker Connect Timeout',
                'bt-tracker-connect-timeout.description': 'Set the connect timeout in seconds to establish connection to tracker. After the connection is established, this option makes no effect and --bt-tracker-timeout option is used instead.',
                'bt-tracker-interval.name': 'BitTorrent Tracker Connect Interval',
                'bt-tracker-interval.description': 'Set the interval in seconds between tracker requests. This completely overrides interval value and aria2 just uses this value and ignores the min interval and interval value in the response of tracker. If 0 is set, aria2 determines interval based on the response of tracker and the download progress.',
                'bt-tracker-timeout.name': 'BitTorrent Tracker Timeout',
                'bt-tracker-timeout.description': '',
                'dht-file-path.name': 'DHT (IPv4) File',
                'dht-file-path.description': 'Change the IPv4 DHT routing table file to PATH.',
                'dht-file-path6.name': 'DHT (IPv6) File',
                'dht-file-path6.description': 'Change the IPv6 DHT routing table file to PATH.',
                'dht-listen-port.name': 'DHT Listen Port',
                'dht-listen-port.description': 'Set UDP listening port used by DHT(IPv4, IPv6) and UDP tracker. Multiple ports can be specified by using "," for example: 6881,6885. You can also use - to specify a range: 6881-6999. , and - can be used together.',
                'dht-message-timeout.name': 'DHT Message Timeout',
                'dht-message-timeout.description': '',
                'enable-dht.name': 'Enable DHT (IPv4)',
                'enable-dht.description': 'Enable IPv4 DHT functionality. It also enables UDP tracker support. If a private flag is set in a torrent, aria2 doesn\'t use DHT for that download even if true is given.',
                'enable-dht6.name': 'Enable DHT (IPv6)',
                'enable-dht6.description': 'Enable IPv6 DHT functionality. If a private flag is set in a torrent, aria2 doesn\'t use DHT for that download even if true is given. Use --dht-listen-port option to specify port number to listen on.',
                'enable-peer-exchange.name': 'Enable Peer Exchange',
                'enable-peer-exchange.description': 'Enable Peer Exchange extension. If a private flag is set in a torrent, this feature is disabled for that download even if true is given.',
                'follow-torrent.name': 'Follow Torrent',
                'follow-torrent.description': 'If true or mem is specified, when a file whose suffix is .torrent or content type is application/x-bittorrent is downloaded, aria2 parses it as a torrent file and downloads files mentioned in it. If mem is specified, a torrent file is not written to the disk, but is just kept in memory. If false is specified, the .torrent file is downloaded to the disk, but is not parsed as a torrent and its contents are not downloaded.',
                'listen-port.name': 'Listen Port',
                'listen-port.description': 'Set TCP port number for BitTorrent downloads. Multiple ports can be specified by using "," for example: 6881,6885. You can also use - to specify a range: 6881-6999. , and - can be used together: 6881-6889,6999.',
                'max-overall-upload-limit.name': 'Global Max Upload Limit',
                'max-overall-upload-limit.description': 'Set max overall upload speed in bytes/sec. 0 means unrestricted. You can append K or M (1K = 1024, 1M = 1024K).',
                'max-upload-limit.name': 'Max Upload Limit',
                'max-upload-limit.description': 'Set max upload speed per each torrent in bytes/sec. 0 means unrestricted. You can append K or M (1K = 1024, 1M = 1024K).',
                'peer-id-prefix.name': 'Peer ID Prefix',
                'peer-id-prefix.description': 'Specify the prefix of peer ID. The peer ID in BitTorrent is 20 byte length. If more than 20 bytes are specified, only first 20 bytes are used. If less than 20 bytes are specified, random byte data are added to make its length 20 bytes.',
                'peer-agent.name': 'Peer Agent',
                'peer-agent.description': 'Specify the string used during the bitorrent extended handshake for the peer’s client version.',
                'seed-ratio.name': 'Min Share Ratio',
                'seed-ratio.description': 'Specify share ratio. Seed completed torrents until share ratio reaches RATIO. You are strongly encouraged to specify equals or more than 1.0 here. Specify 0.0 if you intend to do seeding regardless of share ratio. If --seed-time option is specified along with this option, seeding ends when at least one of the conditions is satisfied.',
                'seed-time.name': 'Min Seed Time',
                'seed-time.description': 'Specify seeding time in (fractional) minutes. Specifying --seed-time=0 disables seeding after download completed.',
                'follow-metalink.name': 'Follow Metalink',
                'follow-metalink.description': 'If true or mem is specified, when a file whose suffix is .meta4 or .metalink or content type of application/metalink4+xml or application/metalink+xml is downloaded, aria2 parses it as a metalink file and downloads files mentioned in it. If mem is specified, a metalink file is not written to the disk, but is just kept in memory. If false is specified, the .metalink file is downloaded to the disk, but is not parsed as a metalink file and its contents are not downloaded.',
                'metalink-base-uri.name': 'Base URI',
                'metalink-base-uri.description': 'Specify base URI to resolve relative URI in metalink:url and metalink:metaurl element in a metalink file stored in local disk. If URI points to a directory, URI must end with /.',
                'metalink-language.name': 'Language',
                'metalink-language.description': '',
                'metalink-location.name': 'Preferred Server Location',
                'metalink-location.description': 'The location of the preferred server. A comma-delimited list of locations is acceptable, for example, jp,us.',
                'metalink-os.name': 'Operation System',
                'metalink-os.description': 'The operating system of the file to download.',
                'metalink-version.name': 'Version',
                'metalink-version.description': 'The version of the file to download.',
                'metalink-preferred-protocol.name': 'Preferred Protocol',
                'metalink-preferred-protocol.description': 'Specify preferred protocol. The possible values are http, https, ftp and none. Specify none to disable this feature.',
                'metalink-enable-unique-protocol.name': 'Enable Unique Protocol',
                'metalink-enable-unique-protocol.description': 'If true is given and several protocols are available for a mirror in a metalink file, aria2 uses one of them. Use --metalink-preferred-protocol option to specify the preference of protocol.',
                'enable-rpc.name': 'Enable JSON-RPC/XML-RPC Server',
                'enable-rpc.description': '',
                'pause-metadata.name': 'Pause After Metadata Downloaded',
                'pause-metadata.description': 'Pause downloads created as a result of metadata download. There are 3 types of metadata downloads in aria2: (1) downloading .torrent file. (2) downloading torrent metadata using magnet link. (3) downloading metalink file. These metadata downloads will generate downloads using their metadata. This option pauses these subsequent downloads. This option is effective only when --enable-rpc=true is given.',
                'rpc-allow-origin-all.name': 'Allow All Origin Request',
                'rpc-allow-origin-all.description': 'Add Access-Control-Allow-Origin header field with value * to the RPC response.',
                'rpc-listen-all.name': 'Listen on All Network Interfaces',
                'rpc-listen-all.description': 'Listen incoming JSON-RPC/XML-RPC requests on all network interfaces. If false is given, listen only on local loopback interface.',
                'rpc-listen-port.name': 'Listen Port',
                'rpc-listen-port.description': '',
                'rpc-max-request-size.name': 'Max Request Size',
                'rpc-max-request-size.description': 'Set max size of JSON-RPC/XML-RPC request. If aria2 detects the request is more than SIZE bytes, it drops connection.',
                'rpc-save-upload-metadata.name': 'Save Upload Metadata',
                'rpc-save-upload-metadata.description': 'Save the uploaded torrent or metalink meta data in the directory specified by --dir option. The file name consists of SHA-1 hash hex string of meta data plus extension. For torrent, the extension is \'.torrent\'. For metalink, it is \'.meta4\'. If false is given to this option, the downloads added by aria2.addTorrent() or aria2.addMetalink() will not be saved by --save-session option.',
                'rpc-secure.name': 'Enable SSL/TLS',
                'rpc-secure.description': 'RPC transport will be encrypted by SSL/TLS. The RPC clients must use https scheme to access the server. For WebSocket client, use wss scheme. Use --rpc-certificate and --rpc-private-key options to specify the server certificate and private key.',
                'allow-overwrite.name': 'Allow Overwrite',
                'allow-overwrite.description': 'Restart download from scratch if the corresponding control file doesn\'t exist. See also --auto-file-renaming option.',
                'allow-piece-length-change.name': 'Allow Piece Length Change',
                'allow-piece-length-change.description': 'If false is given, aria2 aborts download when a piece length is different from one in a control file. If true is given, you can proceed but some download progress will be lost.',
                'always-resume.name': 'Always Resume Download',
                'always-resume.description': 'Always resume download. If true is given, aria2 always tries to resume download and if resume is not possible, aborts download. If false is given, when all given URIs do not support resume or aria2 encounters N URIs which does not support resume (N is the value specified using --max-resume-failure-tries option), aria2 downloads file from scratch. See --max-resume-failure-tries option.',
                'async-dns.name': 'Asynchronous DNS',
                'async-dns.description': '',
                'auto-file-renaming.name': 'Auto File Renaming',
                'auto-file-renaming.description': 'Rename file name if the same file already exists. This option works only in HTTP(S)/FTP download. The new file name has a dot and a number(1..9999) appended after the name, but before the file extension, if any.',
                'auto-save-interval.name': 'Auto Save Interval',
                'auto-save-interval.description': 'Save a control file(*.aria2) every SEC seconds. If 0 is given, a control file is not saved during download. aria2 saves a control file when it stops regardless of the value. The possible values are between 0 to 600.',
                'conditional-get.name': 'Conditional Download',
                'conditional-get.description': 'Download file only when the local file is older than remote file. This function only works with HTTP(S) downloads only. It does not work if file size is specified in Metalink. It also ignores Content-Disposition header. If a control file exists, this option will be ignored. This function uses If-Modified-Since header to get only newer file conditionally. When getting modification time of local file, it uses user supplied file name (see --out option) or file name part in URI if --out is not specified. To overwrite existing file, --allow-overwrite is required.',
                'conf-path.name': 'Configuration File',
                'conf-path.description': '',
                'console-log-level.name': 'Console Log Level',
                'console-log-level.description': '',
                'content-disposition-default-utf8.name': 'Use UTF-8 to Handle Content-Disposition',
                'content-disposition-default-utf8.description': 'Handle quoted string in Content-Disposition header as UTF-8 instead of ISO-8859-1, for example, the filename parameter, but not the extended version filename.',
                'daemon.name': 'Enable Daemon',
                'daemon.description': '',
                'deferred-input.name': 'Deferred Load',
                'deferred-input.description': 'If true is given, aria2 does not read all URIs and options from file specified by --input-file option at startup, but it reads one by one when it needs later. This may reduce memory usage if input file contains a lot of URIs to download. If false is given, aria2 reads all URIs and options at startup. --deferred-input option will be disabled when --save-session is used together.',
                'disable-ipv6.name': 'Disable IPv6',
                'disable-ipv6.description': '',
                'disk-cache.name': 'Disk Cache',
                'disk-cache.description': 'Enable disk cache. If SIZE is 0, the disk cache is disabled. This feature caches the downloaded data in memory, which grows to at most SIZE bytes. The cache storage is created for aria2 instance and shared by all downloads. The one advantage of the disk cache is reduce the disk I/O because the data are written in larger unit and it is reordered by the offset of the file. If hash checking is involved and the data are cached in memory, we don\'t need to read them from the disk. SIZE can include K or M (1K = 1024, 1M = 1024K).',
                'download-result.name': 'Download Result',
                'download-result.description': 'This option changes the way Download Results is formatted. If OPT is default, print GID, status, average download speed and path/URI. If multiple files are involved, path/URI of first requested file is printed and remaining ones are omitted. If OPT is full, print GID, status, average download speed, percentage of progress and path/URI. The percentage of progress and path/URI are printed for each requested file in each row. If OPT is hide, Download Results is hidden.',
                'dscp.name': 'DSCP',
                'dscp.description': 'Set DSCP value in outgoing IP packets of BitTorrent traffic for QoS. This parameter sets only DSCP bits in TOS field of IP packets, not the whole field. If you take values from /usr/include/netinet/ip.h divide them by 4 (otherwise values would be incorrect, e.g. your CS1 class would turn into CS4). If you take commonly used values from RFC, network vendors\' documentation, Wikipedia or any other source, use them as they are.',
                'rlimit-nofile.name': 'Soft Limit of Open File Descriptors',
                'rlimit-nofile.description': 'Set the soft limit of open file descriptors. This open will only have effect when: a. The system supports it (posix). b. The limit does not exceed the hard limit. c. The specified limit is larger than the current soft limit. This is equivalent to setting nofile via ulimit, except that it will never decrease the limit. This option is only available on systems supporting the rlimit API.',
                'enable-color.name': 'Enable Color in Terminal',
                'enable-color.description': '',
                'enable-mmap.name': 'Enable MMap',
                'enable-mmap.description': 'Map files into memory. This option may not work if the file space is not pre-allocated. See --file-allocation.',
                'event-poll.name': 'Event Polling Method',
                'event-poll.description': 'Specify the method for polling events. The possible values are epoll, kqueue, port, poll and select. For each epoll, kqueue, port and poll, it is available if system supports it. epoll is available on recent Linux. kqueue is available on various *BSD systems including Mac OS X. port is available on Open Solaris. The default value may vary depending on the system you use.',
                'file-allocation.name': 'File Allocation Method',
                'file-allocation.description': 'Specify file allocation method. none doesn\'t pre-allocate file space. prealloc pre-allocates file space before download begins. This may take some time depending on the size of the file. If you are using newer file systems such as ext4 (with extents support), btrfs, xfs or NTFS(MinGW build only), falloc is your best choice. It allocates large(few GiB) files almost instantly. Don\'t use falloc with legacy file systems such as ext3 and FAT32 because it takes almost same time as prealloc and it blocks aria2 entirely until allocation finishes. falloc may not be available if your system doesn\'t have posix_fallocate(3) function. trunc uses ftruncate(2) system call or platform-specific counterpart to truncate a file to a specified length. In multi file torrent downloads, the files adjacent forward to the specified files are also allocated if they share the same piece.',
                'force-save.name': 'Force Save',
                'force-save.description': 'Save download with --save-session option even if the download is completed or removed. This option also saves control file in that situations. This may be useful to save BitTorrent seeding which is recognized as completed state.',
                'save-not-found.name': 'Save Not Found File',
                'save-not-found.description': 'Save download with --save-session option even if the file was not found on the server. This option also saves control file in that situations.',
                'hash-check-only.name': 'Hash Check Only',
                'hash-check-only.description': 'If true is given, after hash check using --check-integrity option, abort download whether or not download is complete.',
                'human-readable.name': 'Console Human Readable Output',
                'human-readable.description': 'Print sizes and speed in human readable format (e.g., 1.2Ki, 3.4Mi) in the console readout.',
                'keep-unfinished-download-result.name': 'Keep Unfinished Download Result',
                'keep-unfinished-download-result.description': 'Keep unfinished download results even if doing so exceeds --max-download-result. This is useful if all unfinished downloads must be saved in session file (see --save-session option). Please keep in mind that there is no upper bound to the number of unfinished download result to keep. If that is undesirable, turn this option off.',
                'max-download-result.name': 'Max Download Result',
                'max-download-result.description': 'Set maximum number of download result kept in memory. The download results are completed/error/removed downloads. The download results are stored in FIFO queue and it can store at most NUM download results. When queue is full and new download result is created, oldest download result is removed from the front of the queue and new one is pushed to the back. Setting big number in this option may result high memory consumption after thousands of downloads. Specifying 0 means no download result is kept. Note that unfinished downloads are kept in memory regardless of this option value. See --keep-unfinished-download-result option.',
                'max-mmap-limit.name': 'Max MMap Limit',
                'max-mmap-limit.description': 'Set the maximum file size to enable mmap (see --enable-mmap option). The file size is determined by the sum of all files contained in one download. For example, if a download contains 5 files, then file size is the total size of those files. If file size is strictly greater than the size specified in this option, mmap will be disabled.',
                'max-resume-failure-tries.name': 'Max Resume Failure Try Times',
                'max-resume-failure-tries.description': 'When used with --always-resume=false, aria2 downloads file from scratch when aria2 detects N number of URIs that does not support resume. If N is 0, aria2 downloads file from scratch when all given URIs do not support resume. See --always-resume option.',
                'min-tls-version.name': 'Min TLS Version',
                'min-tls-version.description': 'Specify minimum SSL/TLS version to enable.',
                'log-level.name': 'Log Level',
                'log-level.description': '',
                'optimize-concurrent-downloads.name': 'Optimize Concurrent Downloads',
                'optimize-concurrent-downloads.description': 'Optimizes the number of concurrent downloads according to the bandwidth available. aria2 uses the download speed observed in the previous downloads to adapt the number of downloads launched in parallel according to the rule N = A + B Log10(speed in Mbps). The coefficients A and B can be customized in the option arguments with A and B separated by a colon. The default values (A=5, B=25) lead to using typically 5 parallel downloads on 1Mbps networks and above 50 on 100Mbps networks. The number of parallel downloads remains constrained under the maximum defined by the --max-concurrent-downloads parameter.',
                'piece-length.name': 'Piece Length',
                'piece-length.description': 'Set a piece length for HTTP/FTP downloads. This is the boundary when aria2 splits a file. All splits occur at multiple of this length. This option will be ignored in BitTorrent downloads. It will be also ignored if Metalink file contains piece hashes.',
                'show-console-readout.name': 'Show Console Output',
                'show-console-readout.description': '',
                'summary-interval.name': 'Download Summary Output Interval',
                'summary-interval.description': 'Set interval in seconds to output download progress summary. Setting 0 suppresses the output.',
                'max-overall-download-limit.name': 'Global Max Download Limit',
                'max-overall-download-limit.description': 'Set max overall download speed in bytes/sec. 0 means unrestricted. You can append K or M (1K = 1024, 1M = 1024K).',
                'max-download-limit.name': 'Max Download Limit',
                'max-download-limit.description': 'Set max download speed per each download in bytes/sec. 0 means unrestricted. You can append K or M (1K = 1024, 1M = 1024K).',
                'no-conf.name': 'Disable Configuration File',
                'no-conf.description': '',
                'no-file-allocation-limit.name': 'No File Allocation Limit',
                'no-file-allocation-limit.description': 'No file allocation is made for files whose size is smaller than SIZE. You can append K or M (1K = 1024, 1M = 1024K).',
                'parameterized-uri.name': 'Enable Parameterized URI',
                'parameterized-uri.description': 'Enable parameterized URI support. You can specify set of parts: http://{sv1,sv2,sv3}/foo.iso. Also you can specify numeric sequences with step counter: http://host/image[000-100:2].img. A step counter can be omitted. If all URIs do not point to the same file, such as the second example above, -Z option is required.',
                'quiet.name': 'Disable Console Output',
                'quiet.description': '',
                'realtime-chunk-checksum.name': 'Realtime Data Chunk Validation',
                'realtime-chunk-checksum.description': 'Validate chunk of data by calculating checksum while downloading a file if chunk checksums are provided.',
                'remove-control-file.name': 'Remove Control File',
                'remove-control-file.description': 'Remove control file before download. Using with --allow-overwrite=true, download always starts from scratch. This will be useful for users behind proxy server which disables resume.',
                'save-session.name': 'Session Save File',
                'save-session.description': 'Save error/unfinished downloads to FILE on exit. You can pass this output file to aria2c with --input-file option on restart. If you like the output to be gzipped append a .gz extension to the file name. Please note that downloads added by aria2.addTorrent() and aria2.addMetalink() RPC method and whose meta data could not be saved as a file are not saved. Downloads removed using aria2.remove() and aria2.forceRemove() will not be saved.',
                'save-session-interval.name': 'Save Session Interval',
                'save-session-interval.description': 'Save error/unfinished downloads to a file specified by --save-session option every SEC seconds. If 0 is given, file will be saved only when aria2 exits.',
                'socket-recv-buffer-size.name': 'Socket Receive Buffer Size',
                'socket-recv-buffer-size.description': 'Set the maximum socket receive buffer in bytes. Specifing 0 will disable this option. This value will be set to socket file descriptor using SO_RCVBUF socket option with setsockopt() call.',
                'stop.name': 'Auto Shutdown Time',
                'stop.description': 'Stop application after SEC seconds has passed. If 0 is given, this feature is disabled.',
                'truncate-console-readout.name': 'Truncate Console Output',
                'truncate-console-readout.description': 'Truncate console readout to fit in a single line.'
            }
        };

        $translateProvider.translations(ariaNgConstants.defaultLanguage, defaultLanguageResource);
    }]);
}());
