(function () {
    'use strict';

    angular.module('ariaNg').constant('ariaNgConstants', {
        title: 'AriaNg Native',
        appPrefix: 'AriaNg',
        optionStorageKey: 'Options',
        browserNotificationHistoryStorageKey: 'Notifications',
        languageStorageKeyPrefix: 'Language',
        settingHistoryKeyPrefix: 'History',
        languagePath: 'langs',
        languageFileExtension: '.txt',
        defaultLanguage: 'en',
        defaultHost: 'localhost',
        defaultSecureProtocol: 'https',
        defaultPathSeparator: '/',
        httpRequestTimeout: 20000,
        globalStatStorageCapacity: 120,
        taskStatStorageCapacity: 300,
        lazySaveTimeout: 500,
        errorTooltipDelay: 500,
        notificationInPageTimeout: 2000,
        historyMaxStoreCount: 10,
        cachedDebugLogsLimit: 100
    }).constant('ariaNgDefaultOptions', {
        language: 'en',
        theme: 'light',
        autoCheckUpdates: 'never',
        title: '${downspeed}, ${upspeed} - ${title}',
        titleRefreshInterval: 5000,
        browserNotification: false,
        browserNotificationSound: true,
        browserNotificationFrequency: 'unlimited',
        playSoundAfterDownloadFinished: '',
        rpcAlias: '',
        rpcHost: '',
        rpcPort: '6800',
        rpcInterface: 'jsonrpc',
        protocol: 'http',
        httpMethod: 'POST',
        rpcRequestHeaders: '',
        secret: '',
        extendRpcServers: [],
        webSocketReconnectInterval: 5000,
        globalStatRefreshInterval: 1000,
        downloadTaskRefreshInterval: 1000,
        keyboardShortcuts: true,
        swipeGesture: true,
        dragAndDropTasks: true,
        rpcListDisplayOrder: 'recentlyUsed',
        afterCreatingNewTask: 'task-list',
        removeOldTaskAfterRetrying: false,
        confirmTaskRemoval: true,
        includePrefixWhenCopyingFromTaskDetails: true,
        showPiecesInfoInTaskDetailPage: 'le10240',
        afterRetryingTask: 'task-list-downloading',
        taskListIndependentDisplayOrder: false,
        displayOrder: 'default:asc',
        waitingTaskListPageDisplayOrder: 'default:asc',
        stoppedTaskListPageDisplayOrder: 'default:asc',
        fileListDisplayOrder: 'default:asc',
        peerListDisplayOrder: 'default:asc'
    });
}());
