import type { EditorThemeClasses } from "lexical"

import "./eidos_editor_theme.css"

const theme: EditorThemeClasses = {
  blockCursor: "eidos_editor_theme__blockCursor",
  characterLimit: "eidos_editor_theme__characterLimit",
  code: "not-prose eidos_editor_theme__code",
  codeHighlight: {
    atrule: "eidos_editor_theme__tokenAttr",
    attr: "eidos_editor_theme__tokenAttr",
    boolean: "eidos_editor_theme__tokenProperty",
    builtin: "eidos_editor_theme__tokenSelector",
    cdata: "eidos_editor_theme__tokenComment",
    char: "eidos_editor_theme__tokenSelector",
    class: "eidos_editor_theme__tokenFunction",
    "class-name": "eidos_editor_theme__tokenFunction",
    comment: "eidos_editor_theme__tokenComment",
    constant: "eidos_editor_theme__tokenProperty",
    deleted: "eidos_editor_theme__tokenProperty",
    doctype: "eidos_editor_theme__tokenComment",
    entity: "eidos_editor_theme__tokenOperator",
    function: "eidos_editor_theme__tokenFunction",
    important: "eidos_editor_theme__tokenVariable",
    inserted: "eidos_editor_theme__tokenSelector",
    keyword: "eidos_editor_theme__tokenAttr",
    namespace: "eidos_editor_theme__tokenVariable",
    number: "eidos_editor_theme__tokenProperty",
    operator: "eidos_editor_theme__tokenOperator",
    prolog: "eidos_editor_theme__tokenComment",
    property: "eidos_editor_theme__tokenProperty",
    punctuation: "eidos_editor_theme__tokenPunctuation",
    regex: "eidos_editor_theme__tokenVariable",
    selector: "eidos_editor_theme__tokenSelector",
    string: "eidos_editor_theme__tokenSelector",
    symbol: "eidos_editor_theme__tokenProperty",
    tag: "eidos_editor_theme__tokenProperty",
    url: "eidos_editor_theme__tokenOperator",
    variable: "eidos_editor_theme__tokenVariable",
  },
  embedBlock: {
    base: "eidos_editor_theme__embedBlock",
    focus: "eidos_editor_theme__embedBlockFocus",
  },
  hashtag: "eidos_editor_theme__hashtag",
  heading: {
    h1: "eidos_editor_theme__h1 my-0 mt-[2rem]",
    h2: "eidos_editor_theme__h2 my-0 mt-[1.8rem]",
    h3: "eidos_editor_theme__h3 my-0 mt-[1.5rem]",
    h4: "eidos_editor_theme__h4 my-0 mt-[1.2rem]",
    h5: "eidos_editor_theme__h5",
    h6: "eidos_editor_theme__h6",
  },
  image: "editor-image !my-[2px]",
  indent: "eidos_editor_theme__indent",
  inlineImage: "inline-editor-image",
  link: "eidos_editor_theme__link",
  list: {
    listitem: "eidos_editor_theme__listItem",
    listitemChecked: "eidos_editor_theme__listItemChecked",
    listitemUnchecked: "eidos_editor_theme__listItemUnchecked",
    nested: {
      listitem: "eidos_editor_theme__nestedListItem",
    },
    olDepth: [
      "eidos_editor_theme__ol1 flex flex-col gap-[2px] !my-[2px]",
      "eidos_editor_theme__ol2 flex flex-col gap-[2px] !my-[2px]",
      "eidos_editor_theme__ol3 flex flex-col gap-[2px] !my-[2px]",
      "eidos_editor_theme__ol4 flex flex-col gap-[2px] !my-[2px]",
      "eidos_editor_theme__ol5 flex flex-col gap-[2px] !my-[2px]",
    ],
    ul: "eidos_editor_theme__ul flex flex-col gap-[2px] !my-[2px]",
  },
  ltr: "eidos_editor_theme__ltr",
  mark: "eidos_editor_theme__mark",
  markOverlap: "eidos_editor_theme__markOverlap",
  paragraph: "eidos_editor_theme__paragraph",
  quote: "eidos_editor_theme__quote",
  rtl: "eidos_editor_theme__rtl",
  table: "eidos_editor_theme__table",
  tableAddColumns: "eidos_editor_theme__tableAddColumns",
  tableAddRows: "eidos_editor_theme__tableAddRows",
  tableCell: "eidos_editor_theme__tableCell",
  tableCellActionButton: "eidos_editor_theme__tableCellActionButton",
  tableCellActionButtonContainer:
    "eidos_editor_theme__tableCellActionButtonContainer",
  tableCellEditing: "eidos_editor_theme__tableCellEditing",
  tableCellHeader: "eidos_editor_theme__tableCellHeader",
  tableCellPrimarySelected: "eidos_editor_theme__tableCellPrimarySelected",
  tableCellResizer: "eidos_editor_theme__tableCellResizer",
  tableCellSelected: "eidos_editor_theme__tableCellSelected",
  tableCellSortedIndicator: "eidos_editor_theme__tableCellSortedIndicator",
  tableResizeRuler: "eidos_editor_theme__tableCellResizeRuler",
  tableSelected: "eidos_editor_theme__tableSelected",
  text: {
    bold: "eidos_editor_theme__textBold",
    code: "eidos_editor_theme__textCode",
    italic: "eidos_editor_theme__textItalic",
    strikethrough: "eidos_editor_theme__textStrikethrough",
    subscript: "eidos_editor_theme__textSubscript",
    superscript: "eidos_editor_theme__textSuperscript",
    underline: "eidos_editor_theme__textUnderline",
    underlineStrikethrough: "eidos_editor_theme__textUnderlineStrikethrough",
  },
}

export default theme
