import requests
import time

API_KEY = 'YOUR_VIRUSTOTAL_API_KEY'
FILE_PATH = 'path_to_your_file'

def get_scan_report(resource):
    url = 'https://www.virustotal.com/vtapi/v2/file/report'
    params = {'apikey': API_KEY, 'resource': resource}
    response = requests.get(url, params=params)
    return response.json()

def submit_file(file_path):
    url = 'https://www.virustotal.com/vtapi/v2/file/scan'
    files = {'file': (file_path, open(file_path, 'rb'))}
    params = {'apikey': API_KEY}
    response = requests.post(url, files=files, params=params)
    return response.json()

if __name__ == "__main__":
    response = submit_file(FILE_PATH)
    resource = response['resource']
    print(f"File submitted. Resource ID: {resource}")

    # Wait a while before fetching the report
    time.sleep(60)
    report = get_scan_report(resource)
    print(report)
