from setuptools import setup, find_packages

setup(
    name="FileAnalysis",
    version="0.0.2",
    packages=find_packages(include=["FileAnalysis"]),
    install_requires=["matplotlib"],
    author="Maurice Lambert",
    author_email="mauricelambert434@gmail.com",
    maintainer="Maurice Lambert",
    maintainer_email="mauricelambert434@gmail.com",
    description="This package analyze emergence of characters in file (for statistics decryption).",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    include_package_data=True,
    url="https://github.com/mauricelambert/FileAnalysis/",
    project_urls={
        "Executable": "https://mauricelambert.github.io/info/python/security/FileAnalysis.pyz",
        "Documentation": "https://mauricelambert.github.io/info/python/security/FileAnalysis.html",
    },
    download_url="https://mauricelambert.github.io/info/python/security/FileAnalysis.pyz",
    classifiers=[
        "Programming Language :: Python",
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Natural Language :: English",
        "Programming Language :: Python :: 3.9",
        "Operating System :: POSIX :: Linux",
        "Operating System :: Microsoft :: Windows",
        "Operating System :: MacOS",
        "Topic :: Security",
        "Topic :: Security :: Cryptography",
    ],
    keywords=["Decryption"],
    platforms=["Windows", "Linux", "MacOS"],
    license="GPL-3.0 License",
    entry_points={
        "console_scripts": ["FileAnalysis = FileAnalysis:analyze"],
    },
    python_requires=">=3.6",
)
