# Reporting Security Issues

## Security Bug Bounty Program

The Matomo Security Bug Bounty Program is designed to encourage security research in Matomo software and to reward those who help us create the safest web analytics platform. 

Critical security issues will be rewarded up to 5,000 USD. Critical issue in Matomo means an issue in our latest official release at: https://builds.matomo.org/latest.zip as installed on a typical server (and possibly using any of our official plugins by Matomo or InnoCraft from the Marketplace). If you can gain remote code execution on the server (i.e. RCE), or if you're able to delete data with an HTTPS request (i.e. SQL Injection), this may qualify as a Critical issue.

(Note: If a Remote Code Execution (RCE) is only available when logged in as a Super User, the issue will qualify as "High" and not "Critical".)

High security issues that can cause a direct attack (CSRF, XSS, Auth bypass, etc.) will be rewarded with up to 777 USD.

Other issues will typically be rewarded by 242 USD (or more or less depending on the impact.)


## Responsible disclosure by email


We encourage you to responsibly report issues via our [Matomo Bug Bounty Program on HackerOne](https://hackerone.com/matomo) or you can also 
[email us at security@matomo.org](mailto:security@matomo.org?subject=Reporting%20Vulnerability%20in%20Matomo).

If you have found a security issue in Matomo please read [our security notes](https://matomo.org/security/) regarding responsible disclosures.


## Improve your Matomo Server Security 

[Secure Matomo server](https://matomo.org/docs/security/): follow these steps to keep your Matomo data safe.

## Security announcements

Please subscribe to [the Changelog](https://matomo.org/changelog/) ([rss feed](https://matomo.org/changelog/feed/)) to be notified of new releases (including security releases).
