<div align="center">
   <img alt="podcastr" src=".github/podcastr.svg" width="40%"/>
   <h3>O melhor para você ouvir, sempre</h3>
</div>
<br/>
<div align="center">
   <a href="https://github.com/mathrb22">
      <img alt="Made by mathrb22" src="https://img.shields.io/badge/made%20by-mathrb22-yellow">
   </a>

   <img alt="GitHub Repo Size" src="https://img.shields.io/github/repo-size/mathrb22/podcastrnext">

   <img alt="GitHub Language Count" src="https://img.shields.io/github/languages/count/mathrb22/podcastrnext">

   <a aria-label="React Version" href="https://github.com/facebook/react/blob/master/CHANGELOG.md#1702-march-22-2021">
      <img src="https://img.shields.io/badge/react-17.0.2-informational?logo=react"></img>
   </a>

   <a href="https://github.com/mathrb22/podcastrnext/commits/main">
      <img alt="GitHub Last Commit" src="https://img.shields.io/github/last-commit/mathrb22/podcastrnext">
   </a>

   <a href="https://github.com/mathrb22/podcastrnext/issues">
      <img alt="GitHub Issues" src="https://img.shields.io/github/issues/mathrb22/podcastrnext">
   </a>

   <a href="https://github.com/mathrb22/podcastrnext/pulls">
      <img alt="Pull Requests Welcome" src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square">
   </a>

   <a href="https://github.com/mathrb22/podcastrnext/blob/main/LICENSE.md">
      <img alt="GitHub License" src="https://img.shields.io/github/license/mathrb22/podcastrnext">
   </a>
   </br>
   </br>
   <a href="#-tecnologias-utilizadas">
      <img alt="React" src="https://img.shields.io/badge/react%20-%2320232a.svg?&style=for-the-badge&logo=react&logoColor=%2361DAFB">
      <img alt="Next" src="https://img.shields.io/badge/next%20js%20-%23000000.svg?&style=for-the-badge&logo=next.js&logoColor=white">
      <img alt="TypeScript" src="https://img.shields.io/badge/typescript%20-%23007ACC.svg?&style=for-the-badge&logo=typescript&logoColor=white">
      <img alt="SASS" src="https://img.shields.io/badge/SASS%20-hotpink.svg?&style=for-the-badge&logo=SASS&logoColor=white"/>
   </a>
</div>

</br>
<div align="center">

[**Sobre**](#-sobre) &nbsp;&nbsp;**|**&nbsp;&nbsp;
[**Features**](#-features) &nbsp;&nbsp;**|**&nbsp;&nbsp;
[**Tecnologias e ferramentas utilizadas**](#-tecnologias-e-ferramentas-utilizadas) &nbsp;&nbsp;**|**&nbsp;&nbsp;
[**Layout**](#-layout) &nbsp;&nbsp;**|**&nbsp;&nbsp;
[**Instalação e execução**](#-instalação-e-execução) &nbsp;&nbsp;**|**&nbsp;&nbsp;
[**Como contribuir**](#-como-contribuir) &nbsp;&nbsp;**|**&nbsp;&nbsp;
[**Contato**](#-contato) &nbsp;&nbsp;**|**&nbsp;&nbsp;
[**Licença**](#-licença)

</div>

## 📃 Sobre

<img src=".github/podcastr-playing-dark.png" alt="Podcastr" />

**Podcastr** é o projeto desenvolvido durante a trilha de React da quinta edição da **Next Level Week**, um evento online produzido pela [**Rocketseat**](https://github.com/Rocketseat).

Esta é uma aplicação web que permite os usuários ouvirem seus podcasts favoritos, ver os últimos lançamentos e obter mais informações dos podcasts que estiverem ouvindo no momento.

<img src=".github/podcastr-details-dark.png" alt="Podcastr - Página de detalhes do podcast" />

<br/>

> Este projeto foi muito interessante de desenvolver, pois para o desenvolvimento do player de áudio, utilizamos a API do HTML5 para manipular o áudio sendo tocado pelo usuário, assim como os eventos e estados do player. Além disso, foi possível aprender mais sobre o Next.js, que é um framework React que permite a criação de aplicações web com SSR (Server Side Rendering).

## ✨ Features

- [x] Lista com os últimos lançamentos de podcasts
- [x] Detalhes do podcast selecionado
- [x] Exibição da data atual
- [x] Player com funções de shuffle, repetição, anterior, próximo e play/pause, além da progressão do episódio
- [x] Layout responsivo

<img src=".github/podcastr-mobile-screens.png" alt="Podcastr" />

- [x] Dark mode / Light mode (Switch)

## 🚀 Tecnologias e ferramentas utilizadas

Este projeto foi desenvolvido com as seguintes tecnologias e ferramentas:

- [**React**](https://reactjs.org/): uma biblioteca JavaScript de código aberto com foco em criar interfaces de usuário (frontend) em páginas web. É mantido pelo Facebook, Instagram, outras empresas e uma comunidade de desenvolvedores individuais. É utilizado nos sites da Netflix, Imgur, Feedly, Airbnb, SeatGeek, HelloSign, Walmart e outros;

- [**Next.js**](https://nextjs.org/): um framework de desenvolvimento web front-end que adiciona novas funcionalidades ao React, como SSR (Server-side Rendering) e SSG (Static Site Generation). Utilizamos esta ferramenta pensando na otimização de performance e uma melhor indexação em mecanismos de busca (SEO - Search Engine Optimization).

- [**TypeScript**](https://www.typescriptlang.org/): um super conjunto da linguagem JavaScript que fornece classes, interfaces e tipagem estática opcional. Utilizado em conjunto com React no frontend web;

- [**Sass**](https://sass-lang.com/): um pré-processador CSS que estende a sintaxe do CSS convencional, nos dando um controle mais profissional e dinâmico às folhas de estilo (stylesheets);

- [**Axios**](https://axios-http.com/): é um cliente HTTP baseado em Promises para fazer requisições.

- [**Git**](https://git-scm.com/downloads): o sistema de controle de versão distribuído de código aberto mais utilizado;

- [**Visual Studio Code**](https://code.visualstudio.com/): um editor de código-fonte desenvolvido pela Microsoft para Windows, Linux e macOS, recomendado para o desenvolvimento de aplicações web;

## 📟 Layout

O layout das telas da aplicação **Podcastr** foi desenvolvido pela equipe da **Rocketseat** através da ferramenta online [**Figma**](https://www.figma.com), um software de prototipação voltado para **UI Design (design de interfaces de usuário)**.
Você pode acessar o layout através deste link: [**Podcastr**](https://www.figma.com/file/UwFEntsHpHYJlHNQAQr4gA/Podcastr/duplicate).

## 🔧 Instalação e execução

Para baixar o código-fonte do projeto em sua máquina, primeiramente terá que ter instalado o [**Git**](https://git-scm.com/).

Com o Git instalado, em seu terminal execute o seguinte comando:

```bash
git clone https://github.com/mathrb22/podcastrnext.git
```

Para instalar as dependências e executar o projeto terá que ter instalado em sua máquina o [**Node.js**](https://nodejs.org/en/), que vem acompanhado do NPM. Com ele instalado:

Instale as dependências do projeto:

```bash
npm install
```

Execute o projeto:

```bash
npm run dev

# ou

yarn dev

```

## 💡 Como contribuir

- Faça um **_fork_** desse repositório;
- Crie um **branch** para a sua feature: `git checkout -b minha-feature`;
- Faça um **commit** com suas alterações: `git commit -m 'feat: Minha nova feature'`;
- Faça um **push** para o seu branch: `git push origin minha-feature`;
- Faça um **pull request** com sua feature;

Pull requests são sempre bem-vindos. Em caso de dúvidas ou sugestões, crie uma _**issue**_ ou entre em contato comigo.

## 📲 Contato

Entre em contato comigo por e-mail ou pelo meu LinkedIn:

<a href="mailto:math.ribeiro.dev@gmail.com"><img src="https://img.shields.io/badge/Gmail-D14836?style=for-the-badge&logo=gmail&logoColor=white" alt="Gmail"/></a>
<a href="https://www.linkedin.com/in/matheus-ribeiro-dev/"><img src="https://img.shields.io/badge/linkedin%20-%230077B5.svg?&style=for-the-badge&logo=linkedin&logoColor=white" alt="LinkedIn"/></a>

## 📝 Licença

<a href="https://github.com/mathrb22/podcastrnext/blob/main/LICENSE.md">
    <img alt="GitHub License" src="https://img.shields.io/github/license/mathrb22/podcastrnext">
</a>

Esse projeto está sob a licença **MIT**. Veja o arquivo _**LICENSE**_ para mais detalhes.

---

<h5 align="center">
  &copy;2021 - <a href="https://github.com/mathrb22/">Matheus Ribeiro</a>
</h5>
