#!/usr/bin/env python3
import logging, os, io, hashlib, plugins.common.General as General, plugins.common.Common as Common
from PIL import Image, ImageChops

class Plugin_Search:

    def __init__(self, Query_List: list = list(), Task_ID: str = str()):
        self.Plugin_Name: str = "Gravatar"
        self.Logging_Plugin_Name: str = General.Get_Plugin_Logging_Name(self.Plugin_Name)
        self.Task_ID = Task_ID
        self.Query_List = General.Convert_to_List(Query_List)
        self.The_File_Extension: str = ".jpg"
        self.Domain: str = "gravatar.com"
        self.Result_Type: str = "Account"
        self.Default_Avatar = b'\xff\xd8\xff\xe0\x00\x10JFIF\x00\x01\x01\x01\x00`\x00`\x00\x00\xff\xfe\x00;CREATOR: gd-jpeg v1.0 (using IJG JPEG v62), quality = 90\n\xff\xdb\x00C\x00\x03\x02\x02\x03\x02\x02\x03\x03\x03\x03\x04\x03\x03\x04\x05\x08\x05\x05\x04\x04\x05\n\x07\x07\x06\x08\x0c\n\x0c\x0c\x0b\n\x0b\x0b\r\x0e\x12\x10\r\x0e\x11\x0e\x0b\x0b\x10\x16\x10\x11\x13\x14\x15\x15\x15\x0c\x0f\x17\x18\x16\x14\x18\x12\x14\x15\x14\xff\xdb\x00C\x01\x03\x04\x04\x05\x04\x05\t\x05\x05\t\x14\r\x0b\r\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\xff\xc0\x00\x11\x08\x00P\x00P\x03\x01"\x00\x02\x11\x01\x03\x11\x01\xff\xc4\x00\x1f\x00\x00\x01\x05\x01\x01\x01\x01\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\xff\xc4\x00\xb5\x10\x00\x02\x01\x03\x03\x02\x04\x03\x05\x05\x04\x04\x00\x00\x01}\x01\x02\x03\x00\x04\x11\x05\x12!1A\x06\x13Qa\x07"q\x142\x81\x91\xa1\x08#B\xb1\xc1\x15R\xd1\xf0$3br\x82\t\n\x16\x17\x18\x19\x1a%&\'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\x83\x84\x85\x86\x87\x88\x89\x8a\x92\x93\x94\x95\x96\x97\x98\x99\x9a\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9\xaa\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8\xf9\xfa\xff\xc4\x00\x1f\x01\x00\x03\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\xff\xc4\x00\xb5\x11\x00\x02\x01\x02\x04\x04\x03\x04\x07\x05\x04\x04\x00\x01\x02w\x00\x01\x02\x03\x11\x04\x05!1\x06\x12AQ\x07aq\x13"2\x81\x08\x14B\x91\xa1\xb1\xc1\t#3R\xf0\x15br\xd1\n\x16$4\xe1%\xf1\x17\x18\x19\x1a&\'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x92\x93\x94\x95\x96\x97\x98\x99\x9a\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9\xaa\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xf2\xf3\xf4\xf5\xf6\xf7\xf8\xf9\xfa\xff\xda\x00\x0c\x03\x01\x00\x02\x11\x03\x11\x00?\x00\xf2\x1a(\xa2\xbf\xa2\x0f\xe6\x10\xa3\xf0\xa2\x8a\x00(\xf5\xaf\xa1\xff\x00f\x9f\xd9.\xe3\xe3\x8e\x99s\xafj\x9a\xa4\x9a7\x87\xe2\x98\xdb\xc4`\x8c<\xd72\x00\x0bm\xcf\n\xa3 d\x83\x93\x91\x8e\r{\x0e\xb9\xff\x00\x04\xe3\xd2\x1e\xdd\x8e\x91\xe3;\xeby\x80\xe0^\xda$\xca\x7f\xef\x92\x98\xaf\x06\xbey\x81\xc3UtjOU\xbe\x8d\xdb\xee>\x8b\x0f\xc3\xf9\x8e*\x8a\xafJ\x9f\xba\xf6\xd5+\xfd\xec\xf8^\x8a\xf6O\x8a\x9f\xb2\x87\x8f\xbe\x16C5\xe4\xf61\xebzDyf\xbe\xd2\xc9\x90F\xbe\xae\x84\x06_s\x82\x07\xadx\xd89\x19\xafV\x86&\x8e*\x1c\xf4d\xa4\xbc\x8f\x1f\x13\x85\xaf\x84\x9f\xb3\xaf\x07\x17\xe6\x1d\xe8\xf4\xa2\x8a\xe99B\x8a+\xda\xff\x00d_\x85P\xfcT\xf8\xc3c\x15\xf4"m\x1fIC\xa8\xde#\x0c\xac\x9bH\x11\xc6}C9\\\x8e\xea\x1a\xb9\xb15\xe1\x85\xa3*\xd3\xda*\xe7V\x17\x0f<]xP\xa7\xbc\x9d\x8fk\xfd\x9b\x7fbm+[\xf0\xc5\xbf\x89>!\xdb\xdcL\xf7\xc8%\xb4\xd1\xd6W\x84G\x11\xe4<\xa5Hm\xcd\xd4(#\x03\xaeI\xc0\xf3\xef\xda\xcb\xf6u\xd0>\x16\xc1\x06\xbb\xe1O:\xdfNi\xc5\xb5\xcd\x84\xd2\x99De\x81*\xe8\xcd\x96\xc7\x18 \x93\xd4b\xbfA\xf5\xfdQt\x9b\x07\x90\x9c\x1cq_\x9d\x1f\xb5\x9f\xc6\x85\xf1\x96\xb5\'\x854\xe2\x1e\xd2\xc6\xe4Iyp\x0f\x0f2\x82\x04c\xd9rr}x\xed\xcf\xe6\xf9fa\x98c\xf3\x15%\'\xcb\xd5}\x94\xbd?\xa6~\xa9\x9be\x99n[\x95\xb8J\x0b\x9bd\xfe\xd3\x97\xaf\xe6\xb6\xb1\xf5\x7f\xec:1\xfb:\xe8\x7f\xf5\xf3w\xff\x00\xa3\xde\xbd\xba\xefV\x86\xd1\xc2\xbb\x85$\xe3\x93^%\xfb\x0f\x7f\xc9\xba\xe8_\xf5\xf3w\xff\x00\xa3\xde\xb9\x0f\xdbv\xfah>\x15\xea\x9eT\xaf\x13\xa5\xcd\xb3+\xa3\x10\xcaD\xe9\x82\x08\xe8k\xc4\xc5\xd1\xfa\xc6i:7\xb74\xda\xfb\xd9\xf4\x18:\xff\x00U\xc9\xe9\xd7\xb5\xf9i\xa7oH\x9fN<q\xea\x10\x920s_\x16~\xd5\xff\x00\xb2\xcd\xb8\x82\xf3\xc5\xde\x11\xb3[k\xc8\x81\x9a\xfbM\x81p\x93\xafV\x925\x1d\x1cu*>\xf7^\xbfy\x7fd/\xda\xbe\xfe\xe7\\\xb2\xf0G\x8d/\x1a\xec]\xb0\x87M\xd5\xa7l\xc8$?v\x19O\xf1n\xe8\xacy\xce\x01\xceA\x1fe\xf8\x82\xc1n\xec\xdc\xe3\x90*\xda\xc5\xe4\x18\xb5\xdf\xf0\x92\xfe\xbe\xe3(\xcb\x05\xc4\x98\'\xa6\x9f\x8c_\xf5\xf7\x9f\x8c\x81\x83\x0c\x8a+\xd4\xbfi?\x87q\xfc9\xf8\xa7}\x05\xa4B-3Q_\xb7["\x8c*n$:\x0f\xa3\x03\x81\xd8\x15\xaf-\xaf\xd80\xd5\xe1\x8a\xa3\x1a\xd0\xdaJ\xe7\xe28\xac4\xf0u\xe7B\xa6\xf1v\n\xfb\xab\xfe\t\xc7\xa2\xc7\x1f\x86\xfcg\xabm\x06i\xee\xe0\xb5\xdd\xdc*#6?9?J\xf8V\xbe\xea\xff\x00\x82q\xebQK\xe1\xbf\x19\xe99\x02h.\xe0\xba\xdb\xdc\xab\xa3.\x7f8\xff\x00Z\xf0\xf8\x8b\x9b\xfb6\xa5\xbc\xbf4}\x07\x0b\xf2\xff\x00jS\xe6\xed+}\xcc\xf6\xbf\xda\x0f\xc4\xb2\xf8g\xc1Z\xde\xa3\x17\xdf\xb2\xb1\x9at\x07\xbb*\x12\x07\xe6\x05~T\xab\xbc\xa5\xa4\x91\x8c\x929,\xee\xc7%\x89\xe4\x93_\xab\xff\x00\x1e|\'\'\x8b|\x13\xaei\x90\x8f\xde\xde\xd8\xcdn\x84\xf6fB\x14\xfedW\xe5\t\x8d\xe1f\x8eTh\xe5BQ\xd1\x86\n\x91\xc1\x04z\xd7\x89\xc2\\\x9c\x95\x7f\x9a\xeb\xee\xfe\xae}\x07\x1as\xfbJ?\xcbg\xf7\xe9\x7f\xd0\xfd.\xfd\x86\xef`\x7f\xd9\xdbJU\x95X\xdb\xdd\xddG(\x07\xee7\x9a[\x07\xf0e?\x8dp\x7f\xb6\xe6\xa9\x04\xdf\x0cu(\xc3\x80\xd2\\\xdb\xa2\x03\xfcG\xcdV\xc0\xfc\x14\x9f\xc2\xbeH\xf8a\xf1\xbb\xc5\xbf\x08d\xba\x1e\x1e\xbeD\xb4\xbb!\xa7\xb1\xb9O2\t\x18\x0c\x06\xdb\x90Cc\x8c\xa9\x07\xd75O\xe27\xc5\x8f\x12|T\xbc\x86mz\xee6\x86\x12Z+Kd\xf2\xe1F=[\x19$\x9frMh\xf2\x1a\xff\x00\xda\x9fZ\xe6\\\x9c\xdc\xde{\xde\xd62\\G\x87YG\xd4\xf9_\xb4\xe5\xe5\xf2\xda\xd7\xbf\xa7\xe2rpM%\xb4\xb1\xcd\x0b\xb4SF\xc1\xd1\xd0\xe1\x95\x81\xc8 \xfa\xe6\xbf`\xfe\x1b\xf8\x91\xfcm\xf0\xcf\xc3z\xe4\xc0y\xda\x96\x99ou.\x06\x00v\x8dK\x0f\xcc\x9a\xfc|\x82\t.f\x8e\x18cif\x91\x82" \xc9f\'\x00\x01\xeb\x9a\xfd\x82\xf8s\xe1\xc7\xf0G\xc3/\x0ehsc\xce\xd3t\xc8-\xa5 \xf0]c\x01\xbf\xf1\xe0j8\xb7\x93\xd9\xd1\xfek\xbf\xbbK\xfe\x85\xf0_?\xb5\xado\x86\xcb\xef\xbb\xb7\xea|g\xfby\xe9Q\x88|9\xa8\x05\x02H\xae\xa6\xb7\xcf\xa8t\r\xff\x00\xb4\xff\x00Z\xf9\x1a\xbe\xb3\xfd\xbbu\xa8\xe5O\x0fi\xe1\x81\x92K\xa9n1\xec\x88\x17\xff\x00jW\xc9\x95\xecp\xe77\xf6t/\xdd\xfel\xf0\xf8\xa7\x97\xfbRv\xec\xaf\xf7 \xfck\xda\xbfd_\x8a\xd0\xfc+\xf8\xc3c-\xfc\xe2\x1d\x1fVC\xa7^;\x1c,{\xc81\xc8}\x02\xb8\\\x9e\xcaZ\xbcV\x83\xcd{\xd8\x9a\x10\xc5Q\x95\x19\xed%c\xe70\xb8\x89\xe1+\xc2\xbd=\xe2\xee~\xd2jVI}n\xc8p}+\xe1\x8f\xda\x8f\xf6O\xd5N\xb3y\xe2\xef\x07\xd95\xea\xdc1\x96\xff\x00K\x81s&\xfe\xf2\xc4\xbf\xc5\x9e\xa5G9\xe4g\'\x1dG\xec\x9b\xfb][]\xe9\xb6^\n\xf1\xb5\xe8\xb7\xbe\x81V\r;U\xb8l%\xc2\x0e\x16)\x18\xf4q\xc0\x0cxa\x80~o\xbd\xf5\xf8\x9a\xde\xe4rE~@\x9e/ \xc5\xed\xaf\xe1%\xfd}\xc7\xed\xed`\xb8\x93\x04\xb5\xd3\xf1\x8b\xfe\xbeL\xfc]\x96\'\x82g\x8aTh\xa5BU\xe3q\xb5\x94\x8e\xa0\x83\xd0\xd2\xc1\x0c\x973G\x0c(\xf2\xcb#\x05H\xe3\x05\x99\x89\xe8\x00\x1dM~\xc0\xf8\x8b\xe1\x7f\x83<a\'\x9b\xaexgH\xd5\xe6\xc6\x04\xd7\x96q\xc9 \x1f\xef\x11\x9f\xd6\x9d\xe1\xbf\x86\xfe\r\xf0D\xbev\x87\xe1\xad\x1fG\x9b\x18\xf3\xac\xec\xe3\x8eL\x7f\xbc\x06\x7fZ\xfa\x9f\xf5\xb6\x9f\'\xf0_7\xae\x9f\x97\xe8|\x7f\xfa\x97W\x9e\xde\xd9r\xfak\xf7_\xf5>O\xfd\x91\xff\x00d\x8dGO\xd6\xac\xbcq\xe3\x8b&\xb2\xfb+\t\xb4\xdd"\xe1q/\x99\xfc3J\xbf\xc3\xb7\xaa\xa9\xe78\'\x18\xe7\xeb\x7f\x19k\x89\xa6i\xce\xbb\x86\xf6\x1d3Rk^,\xb5\xd3am\xae\x19\xf1\xeb_\x0f~\xd3\xbf\xb4\xd2\xea\x02\xef\xc3^\x1a\xbb\x13\xddI\x98\xaf/\xe1l\xac\x0b\xd0\xa2\x11\xd5\xcfBG\xdd\xfa\xf4\xf9YK\x17\x9f\xe2\xd6\x9a\xfe\x11_\xd7\xde}\x8cc\x82\xe1\xcc\x13\xd7O\xc6O\xfa\xfb\x8f\x16\xfd\xa0\xfc~\x9f\x10\xbe&^\xdc[\xcb\xe6\xe9\xd6\x03\xecv\xee\x0f\x0f\xb4\x92\xee>\xacN\x0fp\x05y\xc7\xe3H\xaa\x11@\x03\x00R\xd7\xeb\xf8\\<p\xb4cF\x1bEX\xfcC\x17\x89\x9e2\xbc\xeb\xd4\xdeN\xe1E\x14WQ\xc8!\x19\x1c\xd7\xaf\xfc4\xfd\xa9\xbcy\xf0\xce\xde+(o\xd7Z\xd2c\x01R\xcbS\x06O-}\x11\xc1\x0c\xa3\xd0d\x81\xe9^CEsW\xc3Q\xc5G\x92\xb4T\x97\x99\xd7\x86\xc5W\xc2O\xdaP\x9b\x8b\xf2>\xcb\xd2\xff\x00\xe0\xa0v\xaf\x00\xfe\xd2\xf0\xb5\xed\xbc\xb8\xe7\xec\x97I*\x93\xff\x00\x02\x0b\x8a\xa9\xae~\xdf\x10K\x0b\r7\xc3W\xb3HG\x1fj\xb9H\x80\xff\x00\xbeCW\xc7\xf4W\x85\xfe\xaee\xdc\xd7\xe4\x7f{\xff\x003\xe8\xbf\xd6\x8c\xd3\x97\x97\xda/[/\xf2=7\xe2\'\xed\x17\xe3O\x88\xc9-\xb5\xc5\xea\xe9Zl\x9c5\xa6\x9f\x94\xde=\x1d\xc9,}\xc6@>\x95\xe6*\xa1F\x00\xc0\xf6\xa5\xa2\xbd\xdc>\x1a\x8e\x16\x1c\x94b\xa2\xbc\x8f\x9d\xc4\xe2\xeb\xe2\xe7\xed+\xcd\xc9\xf9\x85\x14Q]\')\xff\xd9'

    def Search(self):

        try:
            Data_to_Cache: list = list()
            Directory = General.Make_Directory(self.Plugin_Name.lower())
            logger = logging.getLogger()
            logger.setLevel(logging.INFO)
            handler = logging.FileHandler(os.path.join(Directory, General.Logging(Directory, self.Plugin_Name)), "w")
            handler.setLevel(logging.DEBUG)
            handler.setFormatter(logging.Formatter("%(levelname)s - %(message)s"))
            logger.addHandler(handler)
            Cached_Data_Object = General.Cache(Directory, self.Plugin_Name)
            Cached_Data = Cached_Data_Object.Get_Cache()

            for Query in self.Query_List:
                
                if Common.Regex_Handler(Query, Type="Email"):
                    Gravatar_Signature = hashlib.md5(Query.encode()).hexdigest()
                    Gravatar_URL = f"https://s.{self.Domain}/avatar/{Gravatar_Signature}?s=80"

                    if Gravatar_URL not in Cached_Data and Gravatar_URL not in Data_to_Cache:
                        Output_Connections = General.Connections(Query, self.Plugin_Name, self.Domain, self.Result_Type, self.Task_ID, self.Plugin_Name.lower())
                        Title = f"{self.Plugin_Name} | {Gravatar_Signature}"
                        Item_Reponse = Common.Request_Handler(url=Gravatar_URL, Full_Response=True)
                        Response_Bytes = io.BytesIO(Item_Reponse.content)
                        Resp_Image = Image.open(Response_Bytes)
                        Avatar = Image.open(io.BytesIO(self.Default_Avatar))

                        if ImageChops.difference(Avatar, Resp_Image).getbbox():
                            Output_file = General.Create_Query_Results_Output_File(Directory, Query, self.Plugin_Name, Response_Bytes, Gravatar_URL, self.The_File_Extension)

                            if Output_file:
                                Output_Connections.Output([Output_file], Gravatar_URL, Title, self.Plugin_Name.lower())
                                Data_to_Cache.append(Gravatar_URL)

                            else:
                                logging.warning(f"{Common.Date()} - {self.Logging_Plugin_Name} - Failed to create output file. File may already exist.")

                        else:
                            logging.warning(f"{Common.Date()} - {self.Logging_Plugin_Name} - Default gavatar detected, this indicates the provided email hasn't registered a gravatar.")

                else:
                    logging.warning(f"{Common.Date()} - {self.Logging_Plugin_Name} - Failed to match regex.")

            Cached_Data_Object.Write_Cache(Data_to_Cache)

        except Exception as e:
            logging.warning(f"{Common.Date()} - {self.Logging_Plugin_Name} - {str(e)}")