// @ts-nocheck
export type openapi = {
  openapi: '3.0.0';
  servers: [
    {
      url: 'https://api.zoom.us/v2';
    },
  ];
  security: [
    {
      OAuth: [];
    },
  ];
  paths: {
    '/accounts': {
      get: {
        description: 'List all the sub accounts that have been created by a master account.<br><br>Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts. Email the partner programs team at **partner-success@zoom.us** for more details.\n\n<br>**Prerequisites:**<br>\n* Pro or a higher paid account with master account option enabled. <br>\n\n**Scope**: `account:read:admin`\n<br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>\n\n';
        operationId: 'accounts';
        parameters: [
          {
            description: 'The number of records returned within a single API call.';
            in: 'query';
            name: 'page_size';
            schema: {
              default: 30;
              maximum: 300;
              type: 'integer';
            };
          },
          {
            description: '\n**Deprecated** - This field has been deprecated and we will stop supporting it completely in a future release. Please use "next_page_token" for pagination instead of this field.\n\nThe page number of the current page in the returned records.';
            in: 'query';
            name: 'page_number';
            schema: {
              default: 1;
              type: 'integer';
            };
          },
          {
            description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
            in: 'query';
            name: 'next_page_token';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      accounts: [
                        {
                          account_name: 'string';
                          account_type: 'string';
                          created_at: 'string [date-time]';
                          id: 'string [uuid]';
                          owner_email: 'string';
                          seats: 'integer';
                          subscription_end_time: 'string [date-time]';
                          subscription_start_time: 'string [date-time]';
                        },
                      ];
                      page_count: 'integer';
                      page_number: 'integer';
                      page_size: 'integer';
                      total_records: 'integer';
                    };
                  };
                };
                schema: {
                  allOf: [
                    {
                      description: 'Pagination Object.';
                      properties: {
                        next_page_token: {
                          description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                          type: 'string';
                        };
                        page_count: {
                          description: 'The number of pages returned for the request made.';
                          type: 'integer';
                        };
                        page_number: {
                          default: 1;
                          description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
                          type: 'integer';
                        };
                        page_size: {
                          default: 30;
                          description: 'The number of records returned with a single API call.';
                          maximum: 300;
                          type: 'integer';
                        };
                        total_records: {
                          description: 'The total number of all the records available across pages.';
                          type: 'integer';
                        };
                      };
                      type: 'object';
                    },
                    {
                      description: 'Account object in the account list.';
                      properties: {
                        accounts: {
                          description: 'List of Account objects.';
                          items: {
                            properties: {
                              account_name: {
                                description: 'Account name.';
                                type: 'string';
                              };
                              account_number: {
                                description: 'Account Number of the account.';
                                type: 'string';
                              };
                              account_type: {
                                description: 'Account type.';
                                type: 'string';
                              };
                              created_at: {
                                description: 'Account creation date and time.';
                                format: 'date-time';
                                type: 'string';
                              };
                              id: {
                                description: 'Account ID.';
                                type: 'string';
                              };
                              owner_email: {
                                description: 'Account owner email.';
                                example: 'john.doe@zoom.us';
                                type: 'string';
                              };
                              seats: {
                                description: 'Account seats.';
                                type: 'integer';
                              };
                              subscription_end_time: {
                                description: 'Account subscription end date and time.';
                                format: 'date-time';
                                type: 'string';
                              };
                              subscription_start_time: {
                                description: 'Account subscription start date and time.';
                                format: 'date-time';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          type: 'array';
                        };
                      };
                      type: 'object';
                    },
                  ];
                  description: 'List of Accounts.';
                  title: 'Account List';
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  allOf: [
                    {
                      description: 'Pagination Object.';
                      properties: {
                        next_page_token: {
                          description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                          type: 'string';
                        };
                        page_count: {
                          description: 'The number of pages returned for the request made.';
                          type: 'integer';
                        };
                        page_number: {
                          default: 1;
                          description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
                          type: 'integer';
                        };
                        page_size: {
                          default: 30;
                          description: 'The number of records returned with a single API call.';
                          maximum: 300;
                          type: 'integer';
                        };
                        total_records: {
                          description: 'The total number of all the records available across pages.';
                          type: 'integer';
                        };
                      };
                      type: 'object';
                    },
                    {
                      description: 'Account object in the account list.';
                      properties: {
                        accounts: {
                          description: 'List of Account objects.';
                          items: {
                            properties: {
                              account_name: {
                                description: 'Account name.';
                                type: 'string';
                              };
                              account_number: {
                                description: 'Account Number of the account.';
                                type: 'string';
                              };
                              account_type: {
                                description: 'Account type.';
                                type: 'string';
                              };
                              created_at: {
                                description: 'Account creation date and time.';
                                format: 'date-time';
                                type: 'string';
                              };
                              id: {
                                description: 'Account ID.';
                                type: 'string';
                              };
                              owner_email: {
                                description: 'Account owner email.';
                                example: 'john.doe@zoom.us';
                                type: 'string';
                              };
                              seats: {
                                description: 'Account seats.';
                                type: 'integer';
                              };
                              subscription_end_time: {
                                description: 'Account subscription end date and time.';
                                format: 'date-time';
                                type: 'string';
                              };
                              subscription_start_time: {
                                description: 'Account subscription start date and time.';
                                format: 'date-time';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          type: 'array';
                        };
                      };
                      type: 'object';
                    },
                  ];
                  description: 'List of Accounts.';
                  title: 'Account List';
                  type: 'object';
                };
              };
            };
            description: 'Account list returned.';
          };
        };
        summary: 'List sub accounts';
        tags: ['Accounts'];
      };
      post: {
        description: 'Create a sub account under a master account. Your account must be a master account in order to create sub accounts. \n<br><br>Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts. Email the partner programs team at partner-success@zoom.us. for more details. Please note that the created account user will receive a confirmation email.<br><br>\n<br>\n**Prerequisites:**<br>\n* Pro or a higher paid account with master account option enabled. <br>\n\n**Scope**: `account:write:admin`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>\n\n\n ';
        operationId: 'accountCreate';
        requestBody: {
          content: {
            'application/json': {
              schema: {
                description: "The account object represents an account on Zoom. The account owner is the user who created the account or had an account created for them. You can read more about the Zoom account structure <a href='https://medium.com/zoom-developer-blog/a-brief-look-at-zoom-account-structures-1d19c745bf8a' target='_blank'>here</a>.";
                properties: {
                  account_name: {
                    description: 'Name of the account. If you do not provide a value for this field, by default, the value will be set as a concatenation of "first_name" and "last_name". ';
                    maxLength: 64;
                    type: 'string';
                  };
                  email: {
                    description: "User's email address.";
                    maxLength: 128;
                    type: 'string';
                  };
                  first_name: {
                    description: "User's first name.";
                    maxLength: 64;
                    type: 'string';
                  };
                  last_name: {
                    description: "User's last name.";
                    maxLength: 64;
                    type: 'string';
                  };
                  options: {
                    description: 'Account options object.';
                    properties: {
                      billing_auto_renew: {
                        description: 'Toggle whether automatic billing renewal is on or off.';
                        type: 'boolean';
                      };
                      meeting_connector_list: {
                        description: 'Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_mc` is set to `true`.';
                        items: {
                          type: 'string';
                        };
                        type: 'array';
                      };
                      pay_mode: {
                        default: 'master';
                        description: 'Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.';
                        enum: ['master', 'sub'];
                        type: 'string';
                        'x-enum-descriptions': ['master account holder pays', 'Sub account holder pays'];
                      };
                      room_connector_list: {
                        description: 'Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_rc` is set to `true`.';
                        items: {
                          type: 'string';
                        };
                        type: 'array';
                      };
                      share_mc: {
                        default: false;
                        description: 'Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.';
                        type: 'boolean';
                      };
                      share_rc: {
                        default: false;
                        description: 'Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.';
                        type: 'boolean';
                      };
                    };
                    type: 'object';
                  };
                  password: {
                    description: "User's password.\n\n**Note:** If the account owner or admin has enabled [enhanced password requirements](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_fa9186e4-6818-4f7a-915c-2e25c19f0acd), the value provided in this field must meet those requirements. These requirements can be retrieved by calling the [Get Account Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) and referring to the `password_requirement` field present in the `security` object.";
                    minimum: 8;
                    type: 'string';
                  };
                };
                required: ['first_name', 'last_name', 'email', 'password'];
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                description: "The account object represents an account on Zoom. The account owner is the user who created the account or had an account created for them. You can read more about the Zoom account structure <a href='https://medium.com/zoom-developer-blog/a-brief-look-at-zoom-account-structures-1d19c745bf8a' target='_blank'>here</a>.";
                properties: {
                  account_name: {
                    description: 'Name of the account. If you do not provide a value for this field, by default, the value will be set as a concatenation of "first_name" and "last_name". ';
                    maxLength: 64;
                    type: 'string';
                  };
                  email: {
                    description: "User's email address.";
                    maxLength: 128;
                    type: 'string';
                  };
                  first_name: {
                    description: "User's first name.";
                    maxLength: 64;
                    type: 'string';
                  };
                  last_name: {
                    description: "User's last name.";
                    maxLength: 64;
                    type: 'string';
                  };
                  options: {
                    description: 'Account options object.';
                    properties: {
                      billing_auto_renew: {
                        description: 'Toggle whether automatic billing renewal is on or off.';
                        type: 'boolean';
                      };
                      meeting_connector_list: {
                        description: 'Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_mc` is set to `true`.';
                        items: {
                          type: 'string';
                        };
                        type: 'array';
                      };
                      pay_mode: {
                        default: 'master';
                        description: 'Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.';
                        enum: ['master', 'sub'];
                        type: 'string';
                        'x-enum-descriptions': ['master account holder pays', 'Sub account holder pays'];
                      };
                      room_connector_list: {
                        description: 'Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_rc` is set to `true`.';
                        items: {
                          type: 'string';
                        };
                        type: 'array';
                      };
                      share_mc: {
                        default: false;
                        description: 'Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.';
                        type: 'boolean';
                      };
                      share_rc: {
                        default: false;
                        description: 'Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.';
                        type: 'boolean';
                      };
                    };
                    type: 'object';
                  };
                  password: {
                    description: "User's password.\n\n**Note:** If the account owner or admin has enabled [enhanced password requirements](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_fa9186e4-6818-4f7a-915c-2e25c19f0acd), the value provided in this field must meet those requirements. These requirements can be retrieved by calling the [Get Account Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) and referring to the `password_requirement` field present in the `security` object.";
                    minimum: 8;
                    type: 'string';
                  };
                };
                required: ['first_name', 'last_name', 'email', 'password'];
                type: 'object';
              };
            };
          };
          description: 'Account.';
          required: true;
          'x-examples': {
            'application/json': {
              email: 'fhjdhf@djhfjdf.ff';
              first_name: 'Harry';
              last_name: 'Ghim';
              options: {
                meeting_connectors: ['100.0.0.1', '100.1.1.0'];
                pay_mode: 'master';
                room_connectors: ['127.0.0.1', '127.1.1.0'];
                share_mc: true;
                share_rc: true;
              };
              password: 'bdkfhds1e3r';
            };
          };
        };
        responses: {
          '201': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      created_at: 'string';
                      id: 'string';
                      owner_email: 'string';
                      owner_id: 'string';
                    };
                  };
                };
                schema: {
                  properties: {
                    created_at: {
                      description: 'Account created date time.';
                      type: 'string';
                    };
                    id: {
                      description: 'Account ID.';
                      type: 'string';
                    };
                    owner_email: {
                      description: 'Account owner email.';
                      type: 'string';
                    };
                    owner_id: {
                      description: 'Account owner ID.';
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    created_at: {
                      description: 'Account created date time.';
                      type: 'string';
                    };
                    id: {
                      description: 'Account ID.';
                      type: 'string';
                    };
                    owner_email: {
                      description: 'Account owner email.';
                      type: 'string';
                    };
                    owner_id: {
                      description: 'Account owner ID.';
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: 'Account created.';
            headers: {
              'Content-Location': {
                description: 'Location of the created account.';
                schema: {
                  type: 'string';
                };
              };
            };
          };
          '400': {
            description: "**HTTP Status Code:** `400`<br>\n**Error Code:**`300`<br> Your request could not be completed because the name contains an invalid word: {name}\n**Error Code:** `1107`<br>\nEmail domain is blocked.<br>\n**Error Code:** `1111`<br>\nPassword should not contain repeated characters such as 'aaaaaa'. <br>\nPassword should not contain consecutive characters such as 'abc','123'.\n\n";
          };
          '409': {
            description: '**HTTP Status Code:** `409`<br>\n**Error Code:** `1005`<br>\nEmail $email has already been used.';
          };
        };
        summary: 'Create a sub account';
        tags: ['Accounts'];
      };
    };
    '/accounts/{accountId}': {
      delete: {
        description: 'Disassociate a sub account from its master account. This will leave the sub account intact but it will no longer be associated with the master account.<br>  \n\n**Prerequisites:**\n* Pro or a higher paid account with master account option enabled. <br>\n* The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis).<br><br>\n\n\n**Scope**: `account:write:admin`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>\n\n\n ';
        operationId: 'accountDisassociate';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            description: '**HTTP Status Code**: `204`<br>Account deleted.';
          };
          '404': {
            description: '**HTTP Status Code**: `404` <br> \n**Error Code:** `2000`<br> You cannot disassociate a paid account. <br>\n**Error Code:** `2001`<br> Account does not exist: $subAccountId.';
          };
        };
        summary: 'Disassociate a sub account';
        tags: ['Accounts'];
      };
      get: {
        description: "Get details of a sub account that is listed under a master account. Your account must be a master account in order to retrieve sub accounts' details. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and create sub accounts. Email the partner programs team at **partner-success@zoom.us** for more details.\n\n**Prerequisites:**\n* Pro or a higher paid account with master account option enabled. <br>\n\n**Scope**: `account:write:admin`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>\n\n\n \n";
        operationId: 'account';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      created_at: 'string [date-time]';
                      id: 'string';
                      options: {
                        meeting_connectors: 'string';
                        pay_mode: 'string';
                        room_connectors: 'string';
                        share_mc: 'boolean';
                        share_rc: 'boolean';
                      };
                      owner_email: 'string';
                      owner_id: 'string';
                    };
                  };
                };
                schema: {
                  properties: {
                    created_at: {
                      description: 'Account creation date and time.';
                      format: 'date-time';
                      type: 'string';
                    };
                    id: {
                      description: 'Account ID.';
                      type: 'string';
                    };
                    options: {
                      description: 'Account options object.';
                      properties: {
                        billing_auto_renew: {
                          description: 'Toggle whether automatic billing renewal is on or off.';
                          type: 'boolean';
                        };
                        meeting_connector_list: {
                          description: 'Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_mc` is set to `true`.';
                          items: {
                            type: 'string';
                          };
                          type: 'array';
                        };
                        pay_mode: {
                          default: 'master';
                          description: 'Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.';
                          enum: ['master', 'sub'];
                          type: 'string';
                          'x-enum-descriptions': ['master account holder pays', 'Sub account holder pays'];
                        };
                        room_connector_list: {
                          description: 'Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_rc` is set to `true`.';
                          items: {
                            type: 'string';
                          };
                          type: 'array';
                        };
                        share_mc: {
                          default: false;
                          description: 'Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.';
                          type: 'boolean';
                        };
                        share_rc: {
                          default: false;
                          description: 'Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.';
                          type: 'boolean';
                        };
                      };
                      type: 'object';
                    };
                    owner_email: {
                      description: 'Account owner email.';
                      type: 'string';
                    };
                    owner_id: {
                      description: 'Account owner ID.';
                      type: 'string';
                    };
                    vanity_url: {
                      description: 'Account Vanity URL';
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    created_at: {
                      description: 'Account creation date and time.';
                      format: 'date-time';
                      type: 'string';
                    };
                    id: {
                      description: 'Account ID.';
                      type: 'string';
                    };
                    options: {
                      description: 'Account options object.';
                      properties: {
                        billing_auto_renew: {
                          description: 'Toggle whether automatic billing renewal is on or off.';
                          type: 'boolean';
                        };
                        meeting_connector_list: {
                          description: 'Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_mc` is set to `true`.';
                          items: {
                            type: 'string';
                          };
                          type: 'array';
                        };
                        pay_mode: {
                          default: 'master';
                          description: 'Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.';
                          enum: ['master', 'sub'];
                          type: 'string';
                          'x-enum-descriptions': ['master account holder pays', 'Sub account holder pays'];
                        };
                        room_connector_list: {
                          description: 'Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_rc` is set to `true`.';
                          items: {
                            type: 'string';
                          };
                          type: 'array';
                        };
                        share_mc: {
                          default: false;
                          description: 'Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.';
                          type: 'boolean';
                        };
                        share_rc: {
                          default: false;
                          description: 'Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.';
                          type: 'boolean';
                        };
                      };
                      type: 'object';
                    };
                    owner_email: {
                      description: 'Account owner email.';
                      type: 'string';
                    };
                    owner_id: {
                      description: 'Account owner ID.';
                      type: 'string';
                    };
                    vanity_url: {
                      description: 'Account Vanity URL';
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code**: `200`<br>\nAccount object returned.';
          };
          '404': {
            description: '**HTTP Status Code**: `404`<br>\n**Error Code:** `2001`<br> Account does not exist: $subAccountId.';
          };
        };
        summary: 'Get sub account details';
        tags: ['Accounts'];
      };
    };
    '/accounts/{accountId}/billing': {
      get: {
        description: "Get [billing information](https://support.zoom.us/hc/en-us/articles/201363263-About-Billing) of a sub account.<br><br>Only master accounts can use this API. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' billing information. Email the partner programs team at **partner-success@zoom.us** for more details.<br>\n\n**Prerequisites:**\n* Pro or a higher paid account with master account option enabled. <br>\n\n**Scope**:`billing:master`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>\n\n";
        operationId: 'accountBilling';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      address: 'string';
                      apt: 'string';
                      city: 'string';
                      country: 'string';
                      email: 'string';
                      first_name: 'string';
                      last_name: 'string';
                      phone_number: 'string';
                      state: 'string';
                      zip: 'string';
                    };
                  };
                };
                schema: {
                  description: 'Billing Contact object.';
                  properties: {
                    address: {
                      description: "Billing Contact's address.";
                      type: 'string';
                    };
                    apt: {
                      description: "Billing Contact's apartment/suite.";
                      type: 'string';
                    };
                    city: {
                      description: "Billing Contact's city.";
                      type: 'string';
                    };
                    country: {
                      description: "Billing Contact's Country [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) in abbreviated format.";
                      type: 'string';
                    };
                    email: {
                      description: "Billing Contact's email address.";
                      type: 'string';
                    };
                    first_name: {
                      description: "Billing Contact's first name.";
                      type: 'string';
                    };
                    last_name: {
                      description: "Billing Contact's last name.";
                      type: 'string';
                    };
                    phone_number: {
                      description: "Billing Contact's phone number.";
                      type: 'string';
                    };
                    state: {
                      description: "Billing Contact's state.";
                      type: 'string';
                    };
                    zip: {
                      description: "Billing Contact's zip/postal code.";
                      type: 'string';
                    };
                  };
                  required: [
                    'first_name',
                    'last_name',
                    'email',
                    'phone_number',
                    'address',
                    'city',
                    'state',
                    'zip',
                    'country',
                  ];
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  description: 'Billing Contact object.';
                  properties: {
                    address: {
                      description: "Billing Contact's address.";
                      type: 'string';
                    };
                    apt: {
                      description: "Billing Contact's apartment/suite.";
                      type: 'string';
                    };
                    city: {
                      description: "Billing Contact's city.";
                      type: 'string';
                    };
                    country: {
                      description: "Billing Contact's Country [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) in abbreviated format.";
                      type: 'string';
                    };
                    email: {
                      description: "Billing Contact's email address.";
                      type: 'string';
                    };
                    first_name: {
                      description: "Billing Contact's first name.";
                      type: 'string';
                    };
                    last_name: {
                      description: "Billing Contact's last name.";
                      type: 'string';
                    };
                    phone_number: {
                      description: "Billing Contact's phone number.";
                      type: 'string';
                    };
                    state: {
                      description: "Billing Contact's state.";
                      type: 'string';
                    };
                    zip: {
                      description: "Billing Contact's zip/postal code.";
                      type: 'string';
                    };
                  };
                  required: [
                    'first_name',
                    'last_name',
                    'email',
                    'phone_number',
                    'address',
                    'city',
                    'state',
                    'zip',
                    'country',
                  ];
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br>\nAccount billing contact information returned.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `2100`<br> \nThis sub account is on self pay mode.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `2001`<br>\nAccount does not exist: {subAccountId}.\n\n\n';
          };
        };
        summary: 'Get billing information';
        tags: ['Billing'];
      };
      patch: {
        description: "Update [billing information](https://support.zoom.us/hc/en-us/articles/201363263-About-Billing) of a sub account.<br><br>\nThis API can only be used by master accounts that pay all billiing charges of their associated sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' billing information. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>\n\n**Prerequisites:**\n* Pro or a higher paid account with master account option enabled. <br>\n\n**Scope**:`billing:master`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>\n\n";
        operationId: 'accountBillingUpdate';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                description: 'Billing Contact object.';
                properties: {
                  address: {
                    description: "Billing Contact's address.";
                    type: 'string';
                  };
                  apt: {
                    description: "Billing Contact's apartment/suite.";
                    type: 'string';
                  };
                  city: {
                    description: "Billing Contact's city.";
                    type: 'string';
                  };
                  country: {
                    description: "Billing Contact's country.";
                    type: 'string';
                  };
                  email: {
                    description: "Billing Contact's email address.";
                    type: 'string';
                  };
                  first_name: {
                    description: "Billing Contact's first name.";
                    type: 'string';
                  };
                  last_name: {
                    description: "Billing Contact's last name.";
                    type: 'string';
                  };
                  phone_number: {
                    description: "Billing Contact's phone number.";
                    type: 'string';
                  };
                  state: {
                    description: "Billing Contact's state.";
                    type: 'string';
                  };
                  zip: {
                    description: "Billing Contact's zip/postal code.";
                    type: 'string';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                description: 'Billing Contact object.';
                properties: {
                  address: {
                    description: "Billing Contact's address.";
                    type: 'string';
                  };
                  apt: {
                    description: "Billing Contact's apartment/suite.";
                    type: 'string';
                  };
                  city: {
                    description: "Billing Contact's city.";
                    type: 'string';
                  };
                  country: {
                    description: "Billing Contact's country.";
                    type: 'string';
                  };
                  email: {
                    description: "Billing Contact's email address.";
                    type: 'string';
                  };
                  first_name: {
                    description: "Billing Contact's first name.";
                    type: 'string';
                  };
                  last_name: {
                    description: "Billing Contact's last name.";
                    type: 'string';
                  };
                  phone_number: {
                    description: "Billing Contact's phone number.";
                    type: 'string';
                  };
                  state: {
                    description: "Billing Contact's state.";
                    type: 'string';
                  };
                  zip: {
                    description: "Billing Contact's zip/postal code.";
                    type: 'string';
                  };
                };
                type: 'object';
              };
            };
          };
          required: true;
          'x-examples': {
            'application/json': {
              address: 'string';
              apt: 'string';
              city: 'string';
              country: 'string';
              email: 'string';
              first_name: 'string';
              last_name: 'string';
              phone_number: 'string';
              state: 'string';
              zip: 'string';
            };
          };
        };
        responses: {
          '200': {
            description: '**Error Code:** `200`<br>\nPlease subscribe a plan for this sub account first.';
          };
          '204': {
            description: '**HTTP Status Code:** `204`<br>\nAccount billing contact information updated.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `2100`<br>\nThis sub account is on self pay mode.<br>\nInvalid country parameter: {country}.<br>\nInvalid state parameter: {state}.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `2001`<br>\nAccount does not exist: {subAccountId}.\n\n\n\n';
          };
        };
        summary: 'Update billing information';
        tags: ['Billing'];
      };
    };
    '/accounts/{accountId}/billing/invoices': {
      get: {
        description: "List [invoices](https://support.zoom.us/hc/en-us/articles/207276556-Viewing-your-invoice-history#h_6710542f-23cc-4059-9cc7-ff02bec7314e) of a Zoom account.\n\nTo list a regular Zoom account's invoices or a master account's invoices, provide `me` as the value of the `accountId` path parameter. To list a sub account's invoices, provide the account ID of the sub account in the `accountId` path parameter. \n\n**Prerequisites:**\n* Account must be enrolled in Pro or a higher plan.<br>\n\n**Scope**:`billing:master`<br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>\n**Additional Rate Limit:** You can make **one** API request per account(`accountId`) every **five** minutes until the daily limit is reached. This API has a daily limit of **6** requests per account(`accountId`).";
        operationId: 'accountBillingInvoices';
        parameters: [
          {
            description: 'Start date for the invoice query in `yyyy-mm-dd` format. The date range defined by the “from” and “to” parameters should not exceed one year. The range defined should fall within the past three years.\n';
            in: 'query';
            name: 'from';
            schema: {
              format: 'date';
              type: 'string';
            };
          },
          {
            description: 'End date for the invoice query in `yyyy-mm-dd` format';
            in: 'query';
            name: 'to';
            schema: {
              format: 'date';
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      currency: 'USD';
                      invoices: [
                        {
                          balance: 2039;
                          due_date: '2020-08-07';
                          id: '2c92c12348d07e0580';
                          invoice_date: '2020-08-07';
                          invoice_number: 'S8INsdf4534000001';
                          status: 'Draft';
                          target_date: '2020-08-07';
                          tax_amount: 0;
                          total_amount: 2039;
                        },
                      ];
                    };
                  };
                };
                schema: {
                  properties: {
                    currency: {
                      description: 'Currency used in the invoice.';
                      type: 'string';
                    };
                    invoices: {
                      items: {
                        properties: {
                          balance: {
                            description: 'The remaining balance of the invoice after all payments, adjustments, and refunds are applied.\n\n';
                            format: 'double';
                            type: 'number';
                          };
                          due_date: {
                            description: 'The date by which the payment for this invoice is due.\n\n';
                            type: 'string';
                          };
                          id: {
                            description: 'Unique identifier of the invoice.';
                            type: 'string';
                          };
                          invoice_date: {
                            description: 'The date when the invoice was generated.\n';
                            type: 'string';
                          };
                          invoice_number: {
                            description: 'Invoice number.';
                            type: 'string';
                          };
                          status: {
                            default: '"Draft"';
                            description: 'Status of the invoice.';
                            type: 'string';
                          };
                          target_date: {
                            description: 'This date is used to determine which charges are to be billed. All charges that are to be billed on this date or prior will be included in the invoice.\n';
                            type: 'string';
                          };
                          tax_amount: {
                            description: 'Tax amount.';
                            format: 'double';
                            type: 'number';
                          };
                          total_amount: {
                            description: 'Total invoice amount.';
                            format: 'double';
                            type: 'number';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    currency: {
                      description: 'Currency used in the invoice.';
                      type: 'string';
                    };
                    invoices: {
                      items: {
                        properties: {
                          balance: {
                            description: 'The remaining balance of the invoice after all payments, adjustments, and refunds are applied.\n\n';
                            format: 'double';
                            type: 'number';
                          };
                          due_date: {
                            description: 'The date by which the payment for this invoice is due.\n\n';
                            type: 'string';
                          };
                          id: {
                            description: 'Unique identifier of the invoice.';
                            type: 'string';
                          };
                          invoice_date: {
                            description: 'The date when the invoice was generated.\n';
                            type: 'string';
                          };
                          invoice_number: {
                            description: 'Invoice number.';
                            type: 'string';
                          };
                          status: {
                            default: '"Draft"';
                            description: 'Status of the invoice.';
                            type: 'string';
                          };
                          target_date: {
                            description: 'This date is used to determine which charges are to be billed. All charges that are to be billed on this date or prior will be included in the invoice.\n';
                            type: 'string';
                          };
                          tax_amount: {
                            description: 'Tax amount.';
                            format: 'double';
                            type: 'number';
                          };
                          total_amount: {
                            description: 'Total invoice amount.';
                            format: 'double';
                            type: 'number';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br>\nAccount billing invoice information returned.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `200`<br>\nOnly available for Paid account: {subAccountId}.\n**Error Code:** `2001`<br>\nAccount does not exist: {subAccountId}.';
          };
        };
        summary: 'List billing invoices';
        tags: ['Billing'];
      };
      parameters: [
        {
          description: 'The account ID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
    };
    '/accounts/{accountId}/billing/invoices/{invoiceId}': {
      get: {
        description: "Get detailed information about a specific [invoice](https://support.zoom.us/hc/en-us/articles/207276556-Viewing-your-invoice-history#h_6710542f-23cc-4059-9cc7-ff02bec7314e). <br>To retrieve a regular Zoom account's invoice details or a master account's invoice details, provide `me` as the value of `accountId` path parameter. To list a sub account's invoice details, provide the account ID of the sub account in the `accountId` path parameter. \n\n**Prerequisites:**\n* Account must be enrolled in Pro or a higher plan. <br>\n\n**Scope**:`billing:master`<br>\n<br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>\n**Additional Rate Limit:** You can make **one** API request every **thirty** minutes until the daily limit is reached. This API has a daily limit of **100** requests per **account**.";
        operationId: 'getAccountBillingInvoice';
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      balance: 2039;
                      currency: 'USD';
                      due_date: '2020-08-07';
                      id: '2c92fghvb0580';
                      invoice_date: '2020-08-07';
                      invoice_items: [
                        {
                          charge_name: 'Standard Biz Annual';
                          charge_number: 'C-00000004';
                          charge_type: 'Recurring';
                          end_date: '2021-08-06';
                          quantity: 10;
                          start_date: '2020-08-07';
                          tax_amount: 0;
                          total_amount: 1999;
                        },
                        {
                          charge_name: 'Cloud Recording 100 GB';
                          charge_number: 'C-00000005';
                          charge_type: 'Recurring';
                          end_date: '2020-09-06';
                          quantity: 1;
                          start_date: '2020-08-07';
                          tax_amount: 0;
                          total_amount: 40;
                        },
                      ];
                      invoice_number: 'Shjmr5INV00000001';
                      status: 'Draft';
                      target_date: '2020-08-07';
                      tax_amount: 0;
                      total_amount: 2039;
                    };
                  };
                };
                schema: {
                  properties: {
                    balance: {
                      description: 'The remaining balance of the invoice after all payments, adjustments, and refunds are applied.\n\n';
                      format: 'double';
                      type: 'number';
                    };
                    currency: {
                      description: 'Billing currency.';
                      type: 'string';
                    };
                    due_date: {
                      description: 'The date by which the payment for this invoice is due.\n\n';
                      type: 'string';
                    };
                    id: {
                      description: 'Unique identifier of the invoice.';
                      type: 'string';
                    };
                    invoice_date: {
                      description: 'The date when the invoice was generated.\n';
                      type: 'string';
                    };
                    invoice_items: {
                      items: {
                        properties: {
                          charge_name: {
                            description: 'Description for the charge.';
                            type: 'string';
                          };
                          charge_number: {
                            description: 'Identifier for the charge.';
                            type: 'string';
                          };
                          charge_type: {
                            description: 'Charge type.';
                            type: 'string';
                          };
                          end_date: {
                            description: 'Billing end date.';
                            format: 'date';
                            type: 'string';
                          };
                          quantity: {
                            description: 'Quantity.';
                            type: 'integer';
                          };
                          start_date: {
                            description: 'Billing start date.';
                            format: 'date';
                            type: 'string';
                          };
                          tax_amount: {
                            description: 'Tax amount.';
                            format: 'double';
                            type: 'number';
                          };
                          total_amount: {
                            description: 'Total amount.';
                            format: 'double';
                            type: 'number';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    invoice_number: {
                      description: 'Invoice number.';
                      type: 'string';
                    };
                    status: {
                      default: '"Draft"';
                      description: 'Status of the invoice.';
                      type: 'string';
                    };
                    target_date: {
                      description: 'This date is used to determine which charges are to be billed. All charges that are to be billed on this date or prior will be included in the invoice.\n';
                      type: 'string';
                    };
                    tax_amount: {
                      description: 'Tax amount.';
                      format: 'double';
                      type: 'number';
                    };
                    total_amount: {
                      description: 'Total invoice amount.';
                      format: 'double';
                      type: 'number';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    balance: {
                      description: 'The remaining balance of the invoice after all payments, adjustments, and refunds are applied.\n\n';
                      format: 'double';
                      type: 'number';
                    };
                    currency: {
                      description: 'Billing currency.';
                      type: 'string';
                    };
                    due_date: {
                      description: 'The date by which the payment for this invoice is due.\n\n';
                      type: 'string';
                    };
                    id: {
                      description: 'Unique identifier of the invoice.';
                      type: 'string';
                    };
                    invoice_date: {
                      description: 'The date when the invoice was generated.\n';
                      type: 'string';
                    };
                    invoice_items: {
                      items: {
                        properties: {
                          charge_name: {
                            description: 'Description for the charge.';
                            type: 'string';
                          };
                          charge_number: {
                            description: 'Identifier for the charge.';
                            type: 'string';
                          };
                          charge_type: {
                            description: 'Charge type.';
                            type: 'string';
                          };
                          end_date: {
                            description: 'Billing end date.';
                            format: 'date';
                            type: 'string';
                          };
                          quantity: {
                            description: 'Quantity.';
                            type: 'integer';
                          };
                          start_date: {
                            description: 'Billing start date.';
                            format: 'date';
                            type: 'string';
                          };
                          tax_amount: {
                            description: 'Tax amount.';
                            format: 'double';
                            type: 'number';
                          };
                          total_amount: {
                            description: 'Total amount.';
                            format: 'double';
                            type: 'number';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    invoice_number: {
                      description: 'Invoice number.';
                      type: 'string';
                    };
                    status: {
                      default: '"Draft"';
                      description: 'Status of the invoice.';
                      type: 'string';
                    };
                    target_date: {
                      description: 'This date is used to determine which charges are to be billed. All charges that are to be billed on this date or prior will be included in the invoice.\n';
                      type: 'string';
                    };
                    tax_amount: {
                      description: 'Tax amount.';
                      format: 'double';
                      type: 'number';
                    };
                    total_amount: {
                      description: 'Total invoice amount.';
                      format: 'double';
                      type: 'number';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br>\nAccount billing invoice information returned.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `2001`<br>\nAccount does not exist: {subAccountId}.<br>\nInvoiceId does not exist: {invoiceId}.';
          };
        };
        summary: 'Get invoice details';
        tags: ['Billing'];
      };
      parameters: [
        {
          description: 'The account ID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The invoice ID.';
          in: 'path';
          name: 'invoiceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
    };
    '/accounts/{accountId}/lock_settings': {
      get: {
        description: "[Account Locked Settings](https://support.zoom.us/hc/en-us/articles/115005269866) allow you turn settings on or off for all users in your account. No user except the account admin or account owner can change these settings. With lock settings, you force the settings on for all users.\nUse this API to retrieve an account's locked settings. \n\n**Note:** This API can be used by Zoom Accounts that are on a Pro or a higher plan as well accounts that have master and sub accounts options enabled. <br><br>\n**Prerequisites:**\n* Pro or a higher paid account. <br>\n\n**Scope**: `account:read:admin`.\n<br> **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>\n\n\n\n\n\n**Scope:** account:read:admin";
        operationId: 'getAccountLockSettings';
        parameters: [
          {
            description: 'Unique Identifier of the account. To retrieve locked settings of the master account or a regular account, provide "me" as the value of this field. <br> To retrieve locked settings of a sub account, provide the Account ID of the sub account in this field.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: '`meeting_security`: Use this query parameter to view meeting security settings applied on the account.<br>';
            in: 'query';
            name: 'option';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Provide the name of the field by which you would like to filter the response. For example, if you provide "host_video" as the value of this field, you will get a response similar to the following:<br>\n{\n    "schedule_meeting": {\n        "host_video": false\n    }\n}\n<br>You can provide multiple values by separating them with commas(example: "host_video,participant_video”).';
            in: 'query';
            name: 'custom_query_fields';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {
                  oneOf: [
                    {
                      properties: {
                        email_notification: {
                          properties: {
                            alternative_host_reminder: {
                              description: 'Notify the alternative host who is set or removed.';
                              type: 'boolean';
                            };
                            cancel_meeting_reminder: {
                              description: 'Notify host and participants when the meeting is cancelled.';
                              type: 'boolean';
                            };
                            cloud_recording_available_reminder: {
                              description: 'Notify host when cloud recording is available.';
                              type: 'boolean';
                            };
                            jbh_reminder: {
                              description: 'Notify host when participants join the meeting before them.';
                              type: 'boolean';
                            };
                            schedule_for_host_reminder: {
                              description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        in_meeting: {
                          properties: {
                            alert_guest_join: {
                              description: 'Allow participants who belong to your account to see that a guest (someone who does not belong to your account) is participating in the meeting/webinar.';
                              type: 'boolean';
                            };
                            allow_show_zoom_windows: {
                              description: 'Show Zoom windows during screen share.';
                              type: 'boolean';
                            };
                            annotation: {
                              description: 'Allow participants to use annotation tools to add information to shared screens.';
                              type: 'boolean';
                            };
                            anonymous_question_answer: {
                              description: '';
                              type: 'boolean';
                            };
                            attendee_on_hold: {
                              default: false;
                              description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
                              type: 'boolean';
                            };
                            auto_answer: {
                              description: "Enable users to see and add contacts to 'auto-answer group' in the contact list on chat. Any call from members of this group will be automatically answered.";
                              type: 'boolean';
                            };
                            auto_saving_chat: {
                              description: 'Automatically save all in-meeting chats.';
                              type: 'boolean';
                            };
                            breakout_room: {
                              description: 'Allow host to split meeting participants into separate, smaller rooms.';
                              type: 'boolean';
                            };
                            chat: {
                              description: 'Allow meeting participants to send chat message visible to all participants.';
                              type: 'boolean';
                            };
                            closed_caption: {
                              description: 'Allow host to type closed captions or assign a participant/third party device to add closed captions.';
                              type: 'boolean';
                            };
                            co_host: {
                              description: 'Allow the host to add co-hosts. Co-hosts have the same in-meeting controls as the host.';
                              type: 'boolean';
                            };
                            custom_data_center_regions: {
                              description: 'Displays whether or not custom [data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) have been selected for meetings/webinars hosted by the account.';
                              type: 'boolean';
                            };
                            dscp_marking: {
                              description: 'Enable DSCP marking for signaling and media packets. (Default is 56 for audio, 40 for video, and 40 for signaling.) ';
                              type: 'boolean';
                            };
                            e2e_encryption: {
                              description: 'Require that all meetings are encrypted using AES.';
                              type: 'boolean';
                            };
                            entry_exit_chime: {
                              description: 'Play sound when participants join or leave.';
                              type: 'string';
                            };
                            far_end_camera_control: {
                              description: 'Allow another user to take control of the camera during a meeting.';
                              type: 'boolean';
                            };
                            feedback: {
                              description: 'Enable users to provide feedback to Zoom at the end of the meeting.';
                              type: 'boolean';
                            };
                            file_transfer: {
                              description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for all users on the account or not.';
                              type: 'boolean';
                            };
                            group_hd: {
                              description: 'Enable higher quality video for host and participants. This will require more bandwidth.';
                              type: 'boolean';
                            };
                            original_audio: {
                              description: 'Allow users to select original sound during a meeting.';
                              type: 'boolean';
                            };
                            polling: {
                              description: "Add 'Polls' to the meeting controls. This allows the host to survey the attendees.";
                              type: 'boolean';
                            };
                            post_meeting_feedback: {
                              description: 'Display end-of-meeting experience feedback survey.';
                              type: 'boolean';
                            };
                            private_chat: {
                              description: 'Allow meeting participants to send a private 1:1 message to another participant.';
                              type: 'boolean';
                            };
                            remote_control: {
                              description: 'During screen sharing, allow the person who is sharing to let others control the shared content.';
                              type: 'boolean';
                            };
                            request_permission_to_unmute: {
                              description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option is enabled and locked for the account or not.';
                              type: 'boolean';
                            };
                            screen_sharing: {
                              description: 'Allow host and participants to share their screen or content during meetings.';
                              type: 'boolean';
                            };
                            sending_default_email_invites: {
                              description: 'Allow users to invite participants by email only by default.';
                              type: 'boolean';
                            };
                            show_meeting_control_toolbar: {
                              description: 'Always show meeting controls during a meeting.';
                              type: 'boolean';
                            };
                            stereo_audio: {
                              description: 'Allow users to select stereo audio during a meeting.';
                              type: 'boolean';
                            };
                            use_html_format_email: {
                              description: 'Allow  HTML formatting instead of plain text for meeting invitations scheduled with the Outlook plugin.';
                              type: 'boolean';
                            };
                            virtual_background: {
                              description: 'Enable virtual background.';
                              type: 'boolean';
                            };
                            webinar_question_answer: {
                              description: 'Allow attendees to ask questions for the host and panelists to answer in the webinar.';
                              type: 'boolean';
                            };
                            whiteboard: {
                              description: 'Allow participants to share a whiteboard that includes annotation tools.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        recording: {
                          properties: {
                            account_user_access_recording: {
                              description: 'Make cloud recordings accessible to account members only.';
                              type: 'boolean';
                            };
                            auto_delete_cmr: {
                              description: 'Allow Zoom to automatically delete recordings permanently after a specified number of days.';
                              type: 'boolean';
                            };
                            auto_recording: {
                              description: 'Record meetings automatically as they start.';
                              type: 'string';
                            };
                            cloud_recording: {
                              description: 'Allow hosts to record and save the meeting / webinar in the cloud.';
                              type: 'boolean';
                            };
                            cloud_recording_download: {
                              description: 'Allow anyone with a link to the cloud recording to download.';
                              type: 'boolean';
                            };
                            host_delete_cloud_recording: {
                              description: 'Allow the host to delete the recordings. If this option is disabled, the recordings cannot be deleted by the host and only admin can delete them.';
                              type: 'boolean';
                            };
                            ip_address_access_control: {
                              description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
                              properties: {
                                enable: {
                                  description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                                  type: 'boolean';
                                };
                                ip_addresses_or_ranges: {
                                  description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            local_recording: {
                              description: 'Allow hosts and participants to record the meeting to a local file.';
                              type: 'boolean';
                            };
                            prevent_host_access_recording: {
                              description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n\n';
                              type: 'boolean';
                            };
                            recording_authentication: {
                              description: 'Only authenticated users can view cloud recordings';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        schedule_meeting: {
                          properties: {
                            audio_type: {
                              description: 'Determine how participants can join the audio portion of the meeting.';
                              type: 'boolean';
                            };
                            embed_password_in_join_link: {
                              description: 'If the value is set to `true`, the meeting password will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the password.\n ';
                              type: 'boolean';
                            };
                            enforce_login: {
                              description: 'Allow only signed-in users to join meetings.\n';
                              type: 'boolean';
                            };
                            enforce_login_domains: {
                              description: 'Specify the domains from which users can join a meeting.\n';
                              type: 'string';
                            };
                            enforce_login_with_domains: {
                              description: 'Allow only signed-in users with specified domains to join meetings.\n';
                              type: 'boolean';
                            };
                            host_video: {
                              description: 'Start meetings with host video on.';
                              type: 'boolean';
                            };
                            join_before_host: {
                              description: 'Allow participants to join the meeting before the host arrives';
                              type: 'boolean';
                            };
                            meeting_authentication: {
                              description: 'Only authenticated users can join meetings';
                              type: 'boolean';
                            };
                            not_store_meeting_topic: {
                              description: 'Hide actual meeting topic and display "Zoom Meeting" for your scheduled meetings';
                              type: 'boolean';
                            };
                            participant_video: {
                              description: 'Start meetings with participant video on.';
                              type: 'boolean';
                            };
                            require_password_for_instant_meetings: {
                              description: 'Require password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                              type: 'boolean';
                            };
                            require_password_for_pmi_meetings: {
                              description: 'Require participants to enter password for PMI meetings. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                              type: 'boolean';
                            };
                            require_password_for_scheduling_new_meetings: {
                              description: 'This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        telephony: {
                          properties: {
                            telephony_regions: {
                              type: 'boolean';
                            };
                            third_party_audio: {
                              description: 'Allow users to join the meeting using the existing 3rd party audio configuration.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        tsp: {
                          properties: {
                            call_out: {
                              description: '';
                              type: 'boolean';
                            };
                            show_international_numbers_link: {
                              description: '';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                      };
                    },
                    {
                      properties: {
                        meeting_security: {
                          properties: {
                            auto_security: {
                              description: '`true`: Require that all meetings are secured with at least one security option.\n\nThis setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).';
                              type: 'boolean';
                            };
                            embed_password_in_join_link: {
                              description: 'If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.\n';
                              type: 'boolean';
                            };
                            encryption_type: {
                              description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                              enum: ['enhanced_encryption', 'e2ee'];
                              type: 'string';
                            };
                            end_to_end_encrypted_meetings: {
                              description: 'Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.';
                              type: 'boolean';
                            };
                            meeting_password: {
                              description: 'If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.';
                              type: 'boolean';
                            };
                            meeting_password_requirement: {
                              description: 'Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                              properties: {
                                consecutive_characters_length: {
                                  enum: [0, 4, 5, 6, 7, 8];
                                  type: 'integer';
                                };
                                have_letter: {
                                  description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                                  type: 'boolean';
                                };
                                have_number: {
                                  description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                                  type: 'boolean';
                                };
                                have_special_character: {
                                  description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                                  type: 'boolean';
                                };
                                have_upper_and_lower_characters: {
                                  description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                                  type: 'boolean';
                                };
                                length: {
                                  description: 'The minimum length that the meeting/webinar passcode needs to have.';
                                  type: 'integer';
                                };
                                only_allow_numeric: {
                                  description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                                  type: 'boolean';
                                };
                                weak_enhance_detection: {
                                  description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                                  type: 'boolean';
                                };
                              };
                              type: 'object';
                            };
                            phone_password: {
                              description: 'Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.';
                              type: 'boolean';
                            };
                            pmi_password: {
                              description: 'If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduled_meeting: {
                              description: 'Require a passcode for meetings which have already been scheduled.\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduled_webinar: {
                              description: 'Require a passcode for webinars which have already been scheduled.\n';
                              type: 'boolean';
                            };
                            waiting_room: {
                              description: 'When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.\n';
                              type: 'boolean';
                            };
                            waiting_room_settings: {
                              description: 'Specify the settings to be applied if waiting room is enabled.';
                              properties: {
                                participants_to_place_in_waiting_room: {
                                  description: '\n\nSpecify who should be admitted to the waiting room. The value of this field can be one of the following:<br>\n`0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in ';
                                  enum: [0, 1, 2];
                                  type: 'integer';
                                };
                                users_who_can_admit_participants_from_waiting_room: {
                                  description: 'Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>\n`0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).\n\n\n';
                                  type: 'integer';
                                };
                                whitelisted_domains_for_waiting_room: {
                                  description: 'If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            webinar_password: {
                              description: 'If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.\n';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                      };
                      title: 'Meeting/Webinar Security Settings';
                      type: 'object';
                    },
                  ];
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  oneOf: [
                    {
                      properties: {
                        email_notification: {
                          properties: {
                            alternative_host_reminder: {
                              description: 'Notify the alternative host who is set or removed.';
                              type: 'boolean';
                            };
                            cancel_meeting_reminder: {
                              description: 'Notify host and participants when the meeting is cancelled.';
                              type: 'boolean';
                            };
                            cloud_recording_available_reminder: {
                              description: 'Notify host when cloud recording is available.';
                              type: 'boolean';
                            };
                            jbh_reminder: {
                              description: 'Notify host when participants join the meeting before them.';
                              type: 'boolean';
                            };
                            schedule_for_host_reminder: {
                              description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        in_meeting: {
                          properties: {
                            alert_guest_join: {
                              description: 'Allow participants who belong to your account to see that a guest (someone who does not belong to your account) is participating in the meeting/webinar.';
                              type: 'boolean';
                            };
                            allow_show_zoom_windows: {
                              description: 'Show Zoom windows during screen share.';
                              type: 'boolean';
                            };
                            annotation: {
                              description: 'Allow participants to use annotation tools to add information to shared screens.';
                              type: 'boolean';
                            };
                            anonymous_question_answer: {
                              description: '';
                              type: 'boolean';
                            };
                            attendee_on_hold: {
                              default: false;
                              description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
                              type: 'boolean';
                            };
                            auto_answer: {
                              description: "Enable users to see and add contacts to 'auto-answer group' in the contact list on chat. Any call from members of this group will be automatically answered.";
                              type: 'boolean';
                            };
                            auto_saving_chat: {
                              description: 'Automatically save all in-meeting chats.';
                              type: 'boolean';
                            };
                            breakout_room: {
                              description: 'Allow host to split meeting participants into separate, smaller rooms.';
                              type: 'boolean';
                            };
                            chat: {
                              description: 'Allow meeting participants to send chat message visible to all participants.';
                              type: 'boolean';
                            };
                            closed_caption: {
                              description: 'Allow host to type closed captions or assign a participant/third party device to add closed captions.';
                              type: 'boolean';
                            };
                            co_host: {
                              description: 'Allow the host to add co-hosts. Co-hosts have the same in-meeting controls as the host.';
                              type: 'boolean';
                            };
                            custom_data_center_regions: {
                              description: 'Displays whether or not custom [data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) have been selected for meetings/webinars hosted by the account.';
                              type: 'boolean';
                            };
                            dscp_marking: {
                              description: 'Enable DSCP marking for signaling and media packets. (Default is 56 for audio, 40 for video, and 40 for signaling.) ';
                              type: 'boolean';
                            };
                            e2e_encryption: {
                              description: 'Require that all meetings are encrypted using AES.';
                              type: 'boolean';
                            };
                            entry_exit_chime: {
                              description: 'Play sound when participants join or leave.';
                              type: 'string';
                            };
                            far_end_camera_control: {
                              description: 'Allow another user to take control of the camera during a meeting.';
                              type: 'boolean';
                            };
                            feedback: {
                              description: 'Enable users to provide feedback to Zoom at the end of the meeting.';
                              type: 'boolean';
                            };
                            file_transfer: {
                              description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for all users on the account or not.';
                              type: 'boolean';
                            };
                            group_hd: {
                              description: 'Enable higher quality video for host and participants. This will require more bandwidth.';
                              type: 'boolean';
                            };
                            original_audio: {
                              description: 'Allow users to select original sound during a meeting.';
                              type: 'boolean';
                            };
                            polling: {
                              description: "Add 'Polls' to the meeting controls. This allows the host to survey the attendees.";
                              type: 'boolean';
                            };
                            post_meeting_feedback: {
                              description: 'Display end-of-meeting experience feedback survey.';
                              type: 'boolean';
                            };
                            private_chat: {
                              description: 'Allow meeting participants to send a private 1:1 message to another participant.';
                              type: 'boolean';
                            };
                            remote_control: {
                              description: 'During screen sharing, allow the person who is sharing to let others control the shared content.';
                              type: 'boolean';
                            };
                            request_permission_to_unmute: {
                              description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option is enabled and locked for the account or not.';
                              type: 'boolean';
                            };
                            screen_sharing: {
                              description: 'Allow host and participants to share their screen or content during meetings.';
                              type: 'boolean';
                            };
                            sending_default_email_invites: {
                              description: 'Allow users to invite participants by email only by default.';
                              type: 'boolean';
                            };
                            show_meeting_control_toolbar: {
                              description: 'Always show meeting controls during a meeting.';
                              type: 'boolean';
                            };
                            stereo_audio: {
                              description: 'Allow users to select stereo audio during a meeting.';
                              type: 'boolean';
                            };
                            use_html_format_email: {
                              description: 'Allow  HTML formatting instead of plain text for meeting invitations scheduled with the Outlook plugin.';
                              type: 'boolean';
                            };
                            virtual_background: {
                              description: 'Enable virtual background.';
                              type: 'boolean';
                            };
                            webinar_question_answer: {
                              description: 'Allow attendees to ask questions for the host and panelists to answer in the webinar.';
                              type: 'boolean';
                            };
                            whiteboard: {
                              description: 'Allow participants to share a whiteboard that includes annotation tools.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        recording: {
                          properties: {
                            account_user_access_recording: {
                              description: 'Make cloud recordings accessible to account members only.';
                              type: 'boolean';
                            };
                            auto_delete_cmr: {
                              description: 'Allow Zoom to automatically delete recordings permanently after a specified number of days.';
                              type: 'boolean';
                            };
                            auto_recording: {
                              description: 'Record meetings automatically as they start.';
                              type: 'string';
                            };
                            cloud_recording: {
                              description: 'Allow hosts to record and save the meeting / webinar in the cloud.';
                              type: 'boolean';
                            };
                            cloud_recording_download: {
                              description: 'Allow anyone with a link to the cloud recording to download.';
                              type: 'boolean';
                            };
                            host_delete_cloud_recording: {
                              description: 'Allow the host to delete the recordings. If this option is disabled, the recordings cannot be deleted by the host and only admin can delete them.';
                              type: 'boolean';
                            };
                            ip_address_access_control: {
                              description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
                              properties: {
                                enable: {
                                  description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                                  type: 'boolean';
                                };
                                ip_addresses_or_ranges: {
                                  description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            local_recording: {
                              description: 'Allow hosts and participants to record the meeting to a local file.';
                              type: 'boolean';
                            };
                            prevent_host_access_recording: {
                              description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n\n';
                              type: 'boolean';
                            };
                            recording_authentication: {
                              description: 'Only authenticated users can view cloud recordings';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        schedule_meeting: {
                          properties: {
                            audio_type: {
                              description: 'Determine how participants can join the audio portion of the meeting.';
                              type: 'boolean';
                            };
                            embed_password_in_join_link: {
                              description: 'If the value is set to `true`, the meeting password will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the password.\n ';
                              type: 'boolean';
                            };
                            enforce_login: {
                              description: 'Allow only signed-in users to join meetings.\n';
                              type: 'boolean';
                            };
                            enforce_login_domains: {
                              description: 'Specify the domains from which users can join a meeting.\n';
                              type: 'string';
                            };
                            enforce_login_with_domains: {
                              description: 'Allow only signed-in users with specified domains to join meetings.\n';
                              type: 'boolean';
                            };
                            host_video: {
                              description: 'Start meetings with host video on.';
                              type: 'boolean';
                            };
                            join_before_host: {
                              description: 'Allow participants to join the meeting before the host arrives';
                              type: 'boolean';
                            };
                            meeting_authentication: {
                              description: 'Only authenticated users can join meetings';
                              type: 'boolean';
                            };
                            not_store_meeting_topic: {
                              description: 'Hide actual meeting topic and display "Zoom Meeting" for your scheduled meetings';
                              type: 'boolean';
                            };
                            participant_video: {
                              description: 'Start meetings with participant video on.';
                              type: 'boolean';
                            };
                            require_password_for_instant_meetings: {
                              description: 'Require password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                              type: 'boolean';
                            };
                            require_password_for_pmi_meetings: {
                              description: 'Require participants to enter password for PMI meetings. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                              type: 'boolean';
                            };
                            require_password_for_scheduling_new_meetings: {
                              description: 'This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        telephony: {
                          properties: {
                            telephony_regions: {
                              type: 'boolean';
                            };
                            third_party_audio: {
                              description: 'Allow users to join the meeting using the existing 3rd party audio configuration.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        tsp: {
                          properties: {
                            call_out: {
                              description: '';
                              type: 'boolean';
                            };
                            show_international_numbers_link: {
                              description: '';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                      };
                    },
                    {
                      properties: {
                        meeting_security: {
                          properties: {
                            auto_security: {
                              description: '`true`: Require that all meetings are secured with at least one security option.\n\nThis setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).';
                              type: 'boolean';
                            };
                            embed_password_in_join_link: {
                              description: 'If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.\n';
                              type: 'boolean';
                            };
                            encryption_type: {
                              description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                              enum: ['enhanced_encryption', 'e2ee'];
                              type: 'string';
                            };
                            end_to_end_encrypted_meetings: {
                              description: 'Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.';
                              type: 'boolean';
                            };
                            meeting_password: {
                              description: 'If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.';
                              type: 'boolean';
                            };
                            meeting_password_requirement: {
                              description: 'Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                              properties: {
                                consecutive_characters_length: {
                                  enum: [0, 4, 5, 6, 7, 8];
                                  type: 'integer';
                                };
                                have_letter: {
                                  description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                                  type: 'boolean';
                                };
                                have_number: {
                                  description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                                  type: 'boolean';
                                };
                                have_special_character: {
                                  description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                                  type: 'boolean';
                                };
                                have_upper_and_lower_characters: {
                                  description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                                  type: 'boolean';
                                };
                                length: {
                                  description: 'The minimum length that the meeting/webinar passcode needs to have.';
                                  type: 'integer';
                                };
                                only_allow_numeric: {
                                  description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                                  type: 'boolean';
                                };
                                weak_enhance_detection: {
                                  description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                                  type: 'boolean';
                                };
                              };
                              type: 'object';
                            };
                            phone_password: {
                              description: 'Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.';
                              type: 'boolean';
                            };
                            pmi_password: {
                              description: 'If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduled_meeting: {
                              description: 'Require a passcode for meetings which have already been scheduled.\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduled_webinar: {
                              description: 'Require a passcode for webinars which have already been scheduled.\n';
                              type: 'boolean';
                            };
                            waiting_room: {
                              description: 'When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.\n';
                              type: 'boolean';
                            };
                            waiting_room_settings: {
                              description: 'Specify the settings to be applied if waiting room is enabled.';
                              properties: {
                                participants_to_place_in_waiting_room: {
                                  description: '\n\nSpecify who should be admitted to the waiting room. The value of this field can be one of the following:<br>\n`0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in ';
                                  enum: [0, 1, 2];
                                  type: 'integer';
                                };
                                users_who_can_admit_participants_from_waiting_room: {
                                  description: 'Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>\n`0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).\n\n\n';
                                  type: 'integer';
                                };
                                whitelisted_domains_for_waiting_room: {
                                  description: 'If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            webinar_password: {
                              description: 'If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.\n';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                      };
                      title: 'Meeting/Webinar Security Settings';
                      type: 'object';
                    },
                  ];
                  type: 'object';
                };
              };
            };
            description: '**Error Code:** `200`<br>\nOnly available for paid account:$accountId.\n\n**HTTP Status Code:** `200`<br>\nLocked settings for the Account returned.\n\n';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `2001`<br>\nAccount does not exist: $subAccountId.';
          };
        };
        summary: 'Get locked settings';
        tags: ['Accounts'];
      };
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      patch: {
        description: "[Account Locked Settings](https://support.zoom.us/hc/en-us/articles/115005269866) allow you turn settings on or off for all users in your account. No user except the account admin or account owner can change these settings. With lock settings, you force the settings on for all users. Use this API to update an account's locked settings.\n\n**Note:** This API can be used by Zoom Accounts that are on a Pro or a higher plan as well accounts that have master and sub accounts options enabled.<br><br>\n**Prerequisites:**<br>\n* Pro or a higher paid account. <br>\n\n**Scope:** `account:write:admin`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>\n\n\n ";
        operationId: 'updateAccountLockSettings';
        parameters: [
          {
            description: 'Unique Identifier of the account. To retrieve locked settings of the master account or a regular account, provide "me" as the value of this field. <br> To retrieve locked settings of a sub account, provide the Account ID of the sub account in this field.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                oneOf: [
                  {
                    properties: {
                      email_notification: {
                        properties: {
                          alternative_host_reminder: {
                            description: 'Notify the alternative host who is set or removed.';
                            type: 'boolean';
                          };
                          cancel_meeting_reminder: {
                            description: 'Notify host and participants when the meeting is cancelled.';
                            type: 'boolean';
                          };
                          cloud_recording_available_reminder: {
                            description: 'Notify host when cloud recording is available.';
                            type: 'boolean';
                          };
                          jbh_reminder: {
                            description: 'Notify host when participants join the meeting before them.';
                            type: 'boolean';
                          };
                          schedule_for_host_reminder: {
                            description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      in_meeting: {
                        properties: {
                          alert_guest_join: {
                            description: 'Allow participants who belong to your account to see that a guest (someone who does not belong to your account) is participating in the meeting/webinar.';
                            type: 'boolean';
                          };
                          allow_show_zoom_windows: {
                            description: 'Show Zoom windows during screen share.';
                            type: 'boolean';
                          };
                          annotation: {
                            description: 'Allow participants to use annotation tools to add information to shared screens.';
                            type: 'boolean';
                          };
                          anonymous_question_answer: {
                            description: '';
                            type: 'boolean';
                          };
                          attendee_on_hold: {
                            default: false;
                            description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
                            type: 'boolean';
                          };
                          auto_answer: {
                            description: "Enable users to see and add contacts to 'auto-answer group' in the contact list on chat. Any call from members of this group will be automatically answered.";
                            type: 'boolean';
                          };
                          auto_saving_chat: {
                            description: 'Automatically save all in-meeting chats.';
                            type: 'boolean';
                          };
                          breakout_room: {
                            description: 'Allow host to split meeting participants into separate, smaller rooms.';
                            type: 'boolean';
                          };
                          chat: {
                            description: 'Allow meeting participants to send chat message visible to all participants.';
                            type: 'boolean';
                          };
                          closed_caption: {
                            description: 'Allow host to type closed captions or assign a participant/third party device to add closed captions.';
                            type: 'boolean';
                          };
                          co_host: {
                            description: 'Allow the host to add co-hosts. Co-hosts have the same in-meeting controls as the host.';
                            type: 'boolean';
                          };
                          custom_data_center_regions: {
                            description: 'If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field in the account settings. If set to `false`, the regions cannot be customized and the default regions will be used.';
                            type: 'boolean';
                          };
                          dscp_marking: {
                            description: 'Allow users to select stereo audio during a meeting.';
                            type: 'boolean';
                          };
                          e2e_encryption: {
                            description: 'Require that all meetings are encrypted using AES.';
                            type: 'boolean';
                          };
                          entry_exit_chime: {
                            description: 'Play sound when participants join or leave.';
                            type: 'string';
                          };
                          far_end_camera_control: {
                            description: 'Allow another user to take control of the camera during a meeting.';
                            type: 'boolean';
                          };
                          feedback: {
                            description: 'Enable users to provide feedback to Zoom at the end of the meeting.';
                            type: 'boolean';
                          };
                          file_transfer: {
                            description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for all users on the account or not.';
                            type: 'boolean';
                          };
                          group_hd: {
                            description: 'Enable higher quality video for host and participants. This will require more bandwidth.';
                            type: 'boolean';
                          };
                          original_audio: {
                            description: 'Allow users to select original sound during a meeting.';
                            type: 'boolean';
                          };
                          polling: {
                            description: "Add 'Polls' to the meeting controls. This allows the host to survey the attendees.";
                            type: 'boolean';
                          };
                          post_meeting_feedback: {
                            description: 'Display end-of-meeting experience feedback survey.';
                            type: 'boolean';
                          };
                          private_chat: {
                            description: 'Allow meeting participants to send a private 1:1 message to another participant.';
                            type: 'boolean';
                          };
                          remote_control: {
                            description: 'During screen sharing, allow the person who is sharing to let others control the shared content.';
                            type: 'boolean';
                          };
                          request_permission_to_unmute: {
                            description: 'Indicate whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option should be enabled and locked for the account or not.';
                            type: 'boolean';
                          };
                          screen_sharing: {
                            description: 'Allow host and participants to share their screen or content during meetings.';
                            type: 'boolean';
                          };
                          sending_default_email_invites: {
                            description: 'Allow users to invite participants by email only by default.';
                            type: 'boolean';
                          };
                          show_meeting_control_toolbar: {
                            description: 'Always show meeting controls during a meeting.';
                            type: 'boolean';
                          };
                          stereo_audio: {
                            description: 'Allow users to select stereo audio during a meeting.';
                            type: 'boolean';
                          };
                          use_html_format_email: {
                            description: 'Allow  HTML formatting instead of plain text for meeting invitations scheduled with the Outlook plugin.';
                            type: 'boolean';
                          };
                          virtual_background: {
                            description: 'Enable virtual background.';
                            type: 'boolean';
                          };
                          webinar_question_answer: {
                            description: '';
                            type: 'boolean';
                          };
                          whiteboard: {
                            description: 'Allow participants to share a whiteboard that includes annotation tools.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      recording: {
                        properties: {
                          account_user_access_recording: {
                            description: 'Make cloud recordings accessible to account members only.';
                            type: 'boolean';
                          };
                          auto_delete_cmr: {
                            description: 'Allow Zoom to automatically delete recordings permanently after a specified number of days.';
                            type: 'boolean';
                          };
                          auto_recording: {
                            description: 'Record meetings automatically as they start.';
                            type: 'string';
                          };
                          cloud_recording: {
                            description: 'Allow hosts to record and save the meeting / webinar in the cloud.';
                            type: 'boolean';
                          };
                          cloud_recording_download: {
                            description: 'Allow anyone with a link to the cloud recording to download.';
                            type: 'boolean';
                          };
                          host_delete_cloud_recording: {
                            description: 'Allow the host to delete the recordings. If this option is disabled, the recordings cannot be deleted by the host and only admin can delete them.';
                            type: 'boolean';
                          };
                          ip_address_access_control: {
                            description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
                            properties: {
                              enable: {
                                description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                                type: 'boolean';
                              };
                              ip_addresses_or_ranges: {
                                description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          local_recording: {
                            description: 'Allow hosts and participants to record the meeting to a local file.';
                            type: 'boolean';
                          };
                          prevent_host_access_recording: {
                            description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n\n';
                            type: 'boolean';
                          };
                          recording_authentication: {
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      schedule_meeting: {
                        properties: {
                          audio_type: {
                            description: 'Determine how participants can join the audio portion of the meeting.';
                            type: 'boolean';
                          };
                          embed_password_in_join_link: {
                            description: 'If the value is set to `true`, the meeting password will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the password.\n ';
                            type: 'boolean';
                          };
                          enforce_login: {
                            description: 'Participants must always sign in before joining the scheduled meeting.';
                            type: 'boolean';
                          };
                          enforce_login_domains: {
                            type: 'string';
                          };
                          enforce_login_with_domains: {
                            type: 'boolean';
                          };
                          host_video: {
                            description: 'Start meetings with host video on.';
                            type: 'boolean';
                          };
                          join_before_host: {
                            description: 'Allow participants to join the meeting before the host arrives';
                            type: 'boolean';
                          };
                          meeting_authentication: {
                            type: 'boolean';
                          };
                          not_store_meeting_topic: {
                            type: 'boolean';
                          };
                          participant_video: {
                            description: 'Start meetings with participant video on.';
                            type: 'boolean';
                          };
                          personal_meeting: {
                            description: 'Turn the lock setting on or off for the **Enable Personal Meeting ID** setting for an entire account.<br><br>\n`true`: Turn the **"Enable Personal Meeting ID"** setting **on** for all users in the account. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Turn **off** the **"Enable Personal Meeting ID"** setting. **If this setting is [disabled](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link?flash_digest=eb7ac62d8c7fb4daf285916e3e15d87537806133#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a), meetings that were scheduled with PMI by the users in the account will be invalid. Users will have to update previously scheduled PMI meetings.**<br><br>\nFor Zoom Phone only: If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n';
                            type: 'boolean';
                          };
                          require_password_for_instant_meetings: {
                            description: 'Require password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                            type: 'boolean';
                          };
                          require_password_for_pmi_meetings: {
                            description: 'Require participants to enter password for PMI meetings. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                            type: 'boolean';
                          };
                          require_password_for_scheduling_new_meetings: {
                            description: 'This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      telephony: {
                        properties: {
                          telephony_regions: {
                            type: 'boolean';
                          };
                          third_party_audio: {
                            description: 'Allow users to join the meeting using the existing 3rd party audio configuration.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      tsp: {
                        properties: {
                          call_out: {
                            description: '';
                            type: 'boolean';
                          };
                          show_international_numbers_link: {
                            description: '';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                    };
                  },
                  {
                    properties: {
                      meeting_security: {
                        properties: {
                          auto_security: {
                            description: '`true`: Require that all meetings are secured with at least one security option.\n\nThis setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).';
                            type: 'boolean';
                          };
                          embed_password_in_join_link: {
                            description: 'If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.\n';
                            type: 'boolean';
                          };
                          encryption_type: {
                            description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                            enum: ['enhanced_encryption', 'e2ee'];
                            type: 'string';
                          };
                          end_to_end_encrypted_meetings: {
                            description: 'Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.';
                            type: 'boolean';
                          };
                          meeting_password: {
                            description: 'If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.';
                            type: 'boolean';
                          };
                          meeting_password_requirement: {
                            description: 'Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                            properties: {
                              consecutive_characters_length: {
                                enum: [0, 4, 5, 6, 7, 8];
                                type: 'integer';
                              };
                              have_letter: {
                                description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                                type: 'boolean';
                              };
                              have_number: {
                                description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                                type: 'boolean';
                              };
                              have_special_character: {
                                description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                                type: 'boolean';
                              };
                              have_upper_and_lower_characters: {
                                description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                                type: 'boolean';
                              };
                              length: {
                                description: 'The minimum length that the meeting/webinar passcode needs to have.';
                                type: 'integer';
                              };
                              only_allow_numeric: {
                                description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                                type: 'boolean';
                              };
                              weak_enhance_detection: {
                                description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                                type: 'boolean';
                              };
                            };
                            type: 'object';
                          };
                          phone_password: {
                            description: 'Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.';
                            type: 'boolean';
                          };
                          pmi_password: {
                            description: 'If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.\n';
                            type: 'boolean';
                          };
                          require_password_for_scheduled_meeting: {
                            description: 'Require a passcode for meetings which have already been scheduled.\n';
                            type: 'boolean';
                          };
                          require_password_for_scheduled_webinar: {
                            description: 'Require a passcode for webinars which have already been scheduled.\n';
                            type: 'boolean';
                          };
                          waiting_room: {
                            description: 'When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.\n';
                            type: 'boolean';
                          };
                          waiting_room_settings: {
                            description: 'Specify the settings to be applied if waiting room is enabled.';
                            properties: {
                              participants_to_place_in_waiting_room: {
                                description: '\n\nSpecify who should be admitted to the waiting room. The value of this field can be one of the following:<br>\n`0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in ';
                                enum: [0, 1, 2];
                                type: 'integer';
                              };
                              users_who_can_admit_participants_from_waiting_room: {
                                description: 'Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>\n`0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).\n\n\n';
                                type: 'integer';
                              };
                              whitelisted_domains_for_waiting_room: {
                                description: 'If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          webinar_password: {
                            description: 'If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.\n';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                    };
                    title: 'Meeting/Webinar Security Settings';
                    type: 'object';
                  },
                ];
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                oneOf: [
                  {
                    properties: {
                      email_notification: {
                        properties: {
                          alternative_host_reminder: {
                            description: 'Notify the alternative host who is set or removed.';
                            type: 'boolean';
                          };
                          cancel_meeting_reminder: {
                            description: 'Notify host and participants when the meeting is cancelled.';
                            type: 'boolean';
                          };
                          cloud_recording_available_reminder: {
                            description: 'Notify host when cloud recording is available.';
                            type: 'boolean';
                          };
                          jbh_reminder: {
                            description: 'Notify host when participants join the meeting before them.';
                            type: 'boolean';
                          };
                          schedule_for_host_reminder: {
                            description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      in_meeting: {
                        properties: {
                          alert_guest_join: {
                            description: 'Allow participants who belong to your account to see that a guest (someone who does not belong to your account) is participating in the meeting/webinar.';
                            type: 'boolean';
                          };
                          allow_show_zoom_windows: {
                            description: 'Show Zoom windows during screen share.';
                            type: 'boolean';
                          };
                          annotation: {
                            description: 'Allow participants to use annotation tools to add information to shared screens.';
                            type: 'boolean';
                          };
                          anonymous_question_answer: {
                            description: '';
                            type: 'boolean';
                          };
                          attendee_on_hold: {
                            default: false;
                            description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
                            type: 'boolean';
                          };
                          auto_answer: {
                            description: "Enable users to see and add contacts to 'auto-answer group' in the contact list on chat. Any call from members of this group will be automatically answered.";
                            type: 'boolean';
                          };
                          auto_saving_chat: {
                            description: 'Automatically save all in-meeting chats.';
                            type: 'boolean';
                          };
                          breakout_room: {
                            description: 'Allow host to split meeting participants into separate, smaller rooms.';
                            type: 'boolean';
                          };
                          chat: {
                            description: 'Allow meeting participants to send chat message visible to all participants.';
                            type: 'boolean';
                          };
                          closed_caption: {
                            description: 'Allow host to type closed captions or assign a participant/third party device to add closed captions.';
                            type: 'boolean';
                          };
                          co_host: {
                            description: 'Allow the host to add co-hosts. Co-hosts have the same in-meeting controls as the host.';
                            type: 'boolean';
                          };
                          custom_data_center_regions: {
                            description: 'If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field in the account settings. If set to `false`, the regions cannot be customized and the default regions will be used.';
                            type: 'boolean';
                          };
                          dscp_marking: {
                            description: 'Allow users to select stereo audio during a meeting.';
                            type: 'boolean';
                          };
                          e2e_encryption: {
                            description: 'Require that all meetings are encrypted using AES.';
                            type: 'boolean';
                          };
                          entry_exit_chime: {
                            description: 'Play sound when participants join or leave.';
                            type: 'string';
                          };
                          far_end_camera_control: {
                            description: 'Allow another user to take control of the camera during a meeting.';
                            type: 'boolean';
                          };
                          feedback: {
                            description: 'Enable users to provide feedback to Zoom at the end of the meeting.';
                            type: 'boolean';
                          };
                          file_transfer: {
                            description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for all users on the account or not.';
                            type: 'boolean';
                          };
                          group_hd: {
                            description: 'Enable higher quality video for host and participants. This will require more bandwidth.';
                            type: 'boolean';
                          };
                          original_audio: {
                            description: 'Allow users to select original sound during a meeting.';
                            type: 'boolean';
                          };
                          polling: {
                            description: "Add 'Polls' to the meeting controls. This allows the host to survey the attendees.";
                            type: 'boolean';
                          };
                          post_meeting_feedback: {
                            description: 'Display end-of-meeting experience feedback survey.';
                            type: 'boolean';
                          };
                          private_chat: {
                            description: 'Allow meeting participants to send a private 1:1 message to another participant.';
                            type: 'boolean';
                          };
                          remote_control: {
                            description: 'During screen sharing, allow the person who is sharing to let others control the shared content.';
                            type: 'boolean';
                          };
                          request_permission_to_unmute: {
                            description: 'Indicate whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option should be enabled and locked for the account or not.';
                            type: 'boolean';
                          };
                          screen_sharing: {
                            description: 'Allow host and participants to share their screen or content during meetings.';
                            type: 'boolean';
                          };
                          sending_default_email_invites: {
                            description: 'Allow users to invite participants by email only by default.';
                            type: 'boolean';
                          };
                          show_meeting_control_toolbar: {
                            description: 'Always show meeting controls during a meeting.';
                            type: 'boolean';
                          };
                          stereo_audio: {
                            description: 'Allow users to select stereo audio during a meeting.';
                            type: 'boolean';
                          };
                          use_html_format_email: {
                            description: 'Allow  HTML formatting instead of plain text for meeting invitations scheduled with the Outlook plugin.';
                            type: 'boolean';
                          };
                          virtual_background: {
                            description: 'Enable virtual background.';
                            type: 'boolean';
                          };
                          webinar_question_answer: {
                            description: '';
                            type: 'boolean';
                          };
                          whiteboard: {
                            description: 'Allow participants to share a whiteboard that includes annotation tools.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      recording: {
                        properties: {
                          account_user_access_recording: {
                            description: 'Make cloud recordings accessible to account members only.';
                            type: 'boolean';
                          };
                          auto_delete_cmr: {
                            description: 'Allow Zoom to automatically delete recordings permanently after a specified number of days.';
                            type: 'boolean';
                          };
                          auto_recording: {
                            description: 'Record meetings automatically as they start.';
                            type: 'string';
                          };
                          cloud_recording: {
                            description: 'Allow hosts to record and save the meeting / webinar in the cloud.';
                            type: 'boolean';
                          };
                          cloud_recording_download: {
                            description: 'Allow anyone with a link to the cloud recording to download.';
                            type: 'boolean';
                          };
                          host_delete_cloud_recording: {
                            description: 'Allow the host to delete the recordings. If this option is disabled, the recordings cannot be deleted by the host and only admin can delete them.';
                            type: 'boolean';
                          };
                          ip_address_access_control: {
                            description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
                            properties: {
                              enable: {
                                description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                                type: 'boolean';
                              };
                              ip_addresses_or_ranges: {
                                description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          local_recording: {
                            description: 'Allow hosts and participants to record the meeting to a local file.';
                            type: 'boolean';
                          };
                          prevent_host_access_recording: {
                            description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n\n';
                            type: 'boolean';
                          };
                          recording_authentication: {
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      schedule_meeting: {
                        properties: {
                          audio_type: {
                            description: 'Determine how participants can join the audio portion of the meeting.';
                            type: 'boolean';
                          };
                          embed_password_in_join_link: {
                            description: 'If the value is set to `true`, the meeting password will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the password.\n ';
                            type: 'boolean';
                          };
                          enforce_login: {
                            description: 'Participants must always sign in before joining the scheduled meeting.';
                            type: 'boolean';
                          };
                          enforce_login_domains: {
                            type: 'string';
                          };
                          enforce_login_with_domains: {
                            type: 'boolean';
                          };
                          host_video: {
                            description: 'Start meetings with host video on.';
                            type: 'boolean';
                          };
                          join_before_host: {
                            description: 'Allow participants to join the meeting before the host arrives';
                            type: 'boolean';
                          };
                          meeting_authentication: {
                            type: 'boolean';
                          };
                          not_store_meeting_topic: {
                            type: 'boolean';
                          };
                          participant_video: {
                            description: 'Start meetings with participant video on.';
                            type: 'boolean';
                          };
                          personal_meeting: {
                            description: 'Turn the lock setting on or off for the **Enable Personal Meeting ID** setting for an entire account.<br><br>\n`true`: Turn the **"Enable Personal Meeting ID"** setting **on** for all users in the account. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Turn **off** the **"Enable Personal Meeting ID"** setting. **If this setting is [disabled](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link?flash_digest=eb7ac62d8c7fb4daf285916e3e15d87537806133#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a), meetings that were scheduled with PMI by the users in the account will be invalid. Users will have to update previously scheduled PMI meetings.**<br><br>\nFor Zoom Phone only: If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n';
                            type: 'boolean';
                          };
                          require_password_for_instant_meetings: {
                            description: 'Require password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                            type: 'boolean';
                          };
                          require_password_for_pmi_meetings: {
                            description: 'Require participants to enter password for PMI meetings. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                            type: 'boolean';
                          };
                          require_password_for_scheduling_new_meetings: {
                            description: 'This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      telephony: {
                        properties: {
                          telephony_regions: {
                            type: 'boolean';
                          };
                          third_party_audio: {
                            description: 'Allow users to join the meeting using the existing 3rd party audio configuration.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      tsp: {
                        properties: {
                          call_out: {
                            description: '';
                            type: 'boolean';
                          };
                          show_international_numbers_link: {
                            description: '';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                    };
                  },
                  {
                    properties: {
                      meeting_security: {
                        properties: {
                          auto_security: {
                            description: '`true`: Require that all meetings are secured with at least one security option.\n\nThis setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).';
                            type: 'boolean';
                          };
                          embed_password_in_join_link: {
                            description: 'If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.\n';
                            type: 'boolean';
                          };
                          encryption_type: {
                            description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                            enum: ['enhanced_encryption', 'e2ee'];
                            type: 'string';
                          };
                          end_to_end_encrypted_meetings: {
                            description: 'Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.';
                            type: 'boolean';
                          };
                          meeting_password: {
                            description: 'If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.';
                            type: 'boolean';
                          };
                          meeting_password_requirement: {
                            description: 'Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                            properties: {
                              consecutive_characters_length: {
                                enum: [0, 4, 5, 6, 7, 8];
                                type: 'integer';
                              };
                              have_letter: {
                                description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                                type: 'boolean';
                              };
                              have_number: {
                                description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                                type: 'boolean';
                              };
                              have_special_character: {
                                description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                                type: 'boolean';
                              };
                              have_upper_and_lower_characters: {
                                description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                                type: 'boolean';
                              };
                              length: {
                                description: 'The minimum length that the meeting/webinar passcode needs to have.';
                                type: 'integer';
                              };
                              only_allow_numeric: {
                                description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                                type: 'boolean';
                              };
                              weak_enhance_detection: {
                                description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                                type: 'boolean';
                              };
                            };
                            type: 'object';
                          };
                          phone_password: {
                            description: 'Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.';
                            type: 'boolean';
                          };
                          pmi_password: {
                            description: 'If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.\n';
                            type: 'boolean';
                          };
                          require_password_for_scheduled_meeting: {
                            description: 'Require a passcode for meetings which have already been scheduled.\n';
                            type: 'boolean';
                          };
                          require_password_for_scheduled_webinar: {
                            description: 'Require a passcode for webinars which have already been scheduled.\n';
                            type: 'boolean';
                          };
                          waiting_room: {
                            description: 'When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.\n';
                            type: 'boolean';
                          };
                          waiting_room_settings: {
                            description: 'Specify the settings to be applied if waiting room is enabled.';
                            properties: {
                              participants_to_place_in_waiting_room: {
                                description: '\n\nSpecify who should be admitted to the waiting room. The value of this field can be one of the following:<br>\n`0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in ';
                                enum: [0, 1, 2];
                                type: 'integer';
                              };
                              users_who_can_admit_participants_from_waiting_room: {
                                description: 'Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>\n`0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).\n\n\n';
                                type: 'integer';
                              };
                              whitelisted_domains_for_waiting_room: {
                                description: 'If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          webinar_password: {
                            description: 'If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.\n';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                    };
                    title: 'Meeting/Webinar Security Settings';
                    type: 'object';
                  },
                ];
                type: 'object';
              };
            };
          };
          'x-examples': {};
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**Error Code:** `200`<br>\nOnly available for Paid account: $accountId.\n';
          };
          '204': {
            content: {
              'application/json': {
                schema: {
                  properties: {};
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {};
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `204`<br>\nAccount lock settings updated.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `2001`<br>\nTAccount does not exist: $subAccountId.\n';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Update locked settings';
        tags: ['Accounts'];
      };
    };
    '/accounts/{accountId}/managed_domains': {
      get: {
        description: "Get a sub account's [managed domains](https://support.zoom.us/hc/en-us/articles/203395207-What-is-Managed-Domain-).<br><br>\n\n**Note:** This API can be used by Zoom Accounts that are on a Pro or a higher plan as well accounts that have master and sub accounts options enabled. <br><br>\nTo get managed domains of the master account, provide `me` as the value for accountId in the path parameter. Provide the sub account's Account ID as the value of accountId path parameter to get managed domains of the sub account.<br><br>\n**Prerequisites:**<br>\n* Pro or a higher paid account with master account option enabled. <br>\n\n**Scope:** `account:read:admin`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>\n\n\n\n";
        operationId: 'accountManagedDomain';
        parameters: [
          {
            description: 'Unique Identifier of the account. To retrieve locked settings of the master account or a regular account, provide "me" as the value of this field. <br> To retrieve locked settings of a sub account, provide the Account ID of the sub account in this field.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {
                  description: 'List of managed domains.';
                  properties: {
                    domains: {
                      description: 'List of managed domain objects.';
                      items: {
                        allOf: [
                          {
                            properties: {
                              domain: {
                                description: 'Domain name.';
                                type: 'string';
                              };
                              status: {
                                description: 'Domain status.';
                                type: 'string';
                              };
                            };
                          },
                        ];
                        type: 'object';
                      };
                      type: 'array';
                    };
                    total_records: {
                      description: 'Total records.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  description: 'List of managed domains.';
                  properties: {
                    domains: {
                      description: 'List of managed domain objects.';
                      items: {
                        allOf: [
                          {
                            properties: {
                              domain: {
                                description: 'Domain name.';
                                type: 'string';
                              };
                              status: {
                                description: 'Domain status.';
                                type: 'string';
                              };
                            };
                          },
                        ];
                        type: 'object';
                      };
                      type: 'array';
                    };
                    total_records: {
                      description: 'Total records.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br>\nAccount managed domains returned.\n**Error Code:** `200`<br>\nOnly available for paid account.\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code**: `2001`<br>\nAccount does not exist: $subAccountId.\n';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Get managed domains';
        tags: ['Accounts'];
      };
    };
    '/accounts/{accountId}/options': {
      patch: {
        description: "Update a sub account's options under the master account.<br> <aside>Your account must be a master account in order to update the options for sub accounts. Zoom only assigns this privilege to trusted partners. </aside>\n\n**Prerequisites:**\n* Pro or a higher paid account with master account option enabled.\n* The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis).<br><br>\n\n**Scope**: `account:write:admin`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>\n\n\n ";
        operationId: 'accountOptionsUpdate';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                description: 'Account options object.';
                properties: {
                  billing_auto_renew: {
                    description: 'Toggle whether automatic billing renewal is on or off.';
                    type: 'boolean';
                  };
                  meeting_connector_list: {
                    description: 'Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_mc` is set to `true`.';
                    items: {
                      type: 'string';
                    };
                    type: 'array';
                  };
                  pay_mode: {
                    default: 'master';
                    description: 'Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.';
                    enum: ['master', 'sub'];
                    type: 'string';
                    'x-enum-descriptions': ['master account holder pays', 'Sub account holder pays'];
                  };
                  room_connector_list: {
                    description: 'Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_rc` is set to `true`.';
                    items: {
                      type: 'string';
                    };
                    type: 'array';
                  };
                  share_mc: {
                    default: false;
                    description: 'Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.';
                    type: 'boolean';
                  };
                  share_rc: {
                    default: false;
                    description: 'Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.';
                    type: 'boolean';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                description: 'Account options object.';
                properties: {
                  billing_auto_renew: {
                    description: 'Toggle whether automatic billing renewal is on or off.';
                    type: 'boolean';
                  };
                  meeting_connector_list: {
                    description: 'Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_mc` is set to `true`.';
                    items: {
                      type: 'string';
                    };
                    type: 'array';
                  };
                  pay_mode: {
                    default: 'master';
                    description: 'Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.';
                    enum: ['master', 'sub'];
                    type: 'string';
                    'x-enum-descriptions': ['master account holder pays', 'Sub account holder pays'];
                  };
                  room_connector_list: {
                    description: 'Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_rc` is set to `true`.';
                    items: {
                      type: 'string';
                    };
                    type: 'array';
                  };
                  share_mc: {
                    default: false;
                    description: 'Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.';
                    type: 'boolean';
                  };
                  share_rc: {
                    default: false;
                    description: 'Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.';
                    type: 'boolean';
                  };
                };
                type: 'object';
              };
            };
          };
          required: true;
          'x-examples': {};
        };
        responses: {
          '200': {
            description: '**Error Code:** `200`<br>\nThe pay mode cannot be updated for a sub account which already has an existing plan.';
          };
          '204': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      meeting_connectors: 'string';
                      pay_mode: 'string';
                      room_connectors: 'string';
                      share_mc: 'boolean';
                      share_rc: 'boolean';
                    };
                  };
                };
              };
            };
            description: '**HTTP Status Code:** `204`<br>\nAccount options updated.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `2100`<br> The collection method cannot be changed after the purchase is complete.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `2001`<br>\nAccount does not exist: $subAccountId.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Update options';
        tags: ['Accounts'];
      };
    };
    '/accounts/{accountId}/owner': {
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      put: {
        description: 'The current account owner can [change the owner of an account](https://support.zoom.us/hc/en-us/articles/115005686983-Change-Account-Owner) to another user on the same account.<br> Use this API to change the owner of a sub account.\n \n**Prerequisites**: <br>\n* Account owner or admin permissions of an account.\n* The account making this API request must be on a pro or a hiigher plan with [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) privilege.<br><br>\n\n**Scopes:**  `account:write:admin` or `account:master`<br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>\n\n\n<br> ';
        operationId: 'updateAccountOwner';
        parameters: [
          {
            description: 'Account Id of the account.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  email: {
                    description: 'Email address of the new owner.';
                    format: 'email';
                    type: 'string';
                  };
                };
                required: ['email'];
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  email: {
                    description: 'Email address of the new owner.';
                    format: 'email';
                    type: 'string';
                  };
                };
                required: ['email'];
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              email: 'AfRxe@ugAQaOgcbRq.vczy@somemailservice.com';
            };
          };
        };
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `204`<br>\nAccount owner updated.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n\n**Error Code:** `200`<br>\nUser is not an admin or is an API user or doesn’t belong to this account: {accountId}.<br>\nCannot make a user outside of your account an owner.<br>\nCannot update the role of an account owner.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `2001`<br>\nAccount does not exist: $subAccountId.<br>\n**Error Code:** `3201`<br>\nCannot find a billing account for this: $accountId.<br>\n**Error Code:** `3211`<br>\nCannot find a billing contact for this: $accountId.\n';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Update the account owner';
        tags: ['Accounts'];
      };
    };
    '/accounts/{accountId}/phone/settings': {
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      patch: {
        description: 'Only [master account owners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) can use this API to enable BYOC(Bring your own carrier) option for a sub account.<br>\n\n**Scope**:<br>\n* `phone:master` <br>\n\n**Prerequisites**: <br>\n* Business or enterprise Account.<br>';
        operationId: 'updatePhoneSettings';
        parameters: [
          {
            description: 'Unique identifier of the sub account.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  byoc: {
                    properties: {
                      enable: {
                        description: 'Set the value of this field to `true` to allow a sub account to add BYOC numbers from the Zoom web admin portal.';
                        type: 'boolean';
                      };
                    };
                    type: 'object';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  byoc: {
                    properties: {
                      enable: {
                        description: 'Set the value of this field to `true` to allow a sub account to add BYOC numbers from the Zoom web admin portal.';
                        type: 'boolean';
                      };
                    };
                    type: 'object';
                  };
                };
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              byoc: {
                enable: true;
              };
            };
          };
        };
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**Response HTTP code**: `204` **No Content.**<br>\nUpdated successfully.\n\n';
          };
          '401': {
            description: '**HTTP Status Code:** `401`<br>\n\n**Error Code:** `124`<br>\nAccount does not exist: {accountId}.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Update BYOC settings';
        tags: ['Phone'];
      };
    };
    '/accounts/{accountId}/phone/setup': {
      post: {
        description: 'After assigning a Zoom phone license to an account, an admin or account owner can proceed with the [initial Zoom phone set up](https://support.zoom.us/hc/en-us/articles/360001297663-Getting-started-with-Zoom-Phone-admin-#h_5ae26a3a-290c-4a8d-b3b0-6384ed267b13) using this API.\n\n**Scope**:<br>\n* `phone:write:admin` `phone:write`\n\n**Prerequisites**: <br>\n* Pro or a higher paid account with master account option enabled.\n\n<br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>\n\n';
        operationId: 'setUpAccount';
        parameters: [
          {
            description: 'Unique identifier of the account.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  emergency_address: {
                    description: 'Specify emergency address for the account.';
                    properties: {
                      address_line1: {
                        description: 'Specify the street address.';
                        type: 'string';
                      };
                      address_line2: {
                        description: 'Specify any building number, floor number, or unit number.';
                        type: 'string';
                      };
                      city: {
                        description: 'City of the emergency address. Required or optional dependent on different countries.';
                        type: 'string';
                      };
                      country: {
                        description: 'Specify the two letter [country code](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) (Alpha-2 code in ISO-3166).';
                        type: 'string';
                      };
                      state_code: {
                        description: 'State code of the emergency address. Required or optional dependent on the country and state.';
                        type: 'string';
                      };
                      zip: {
                        description: 'Zip code of the emergency address. Required or optional dependent on different countries.';
                        type: 'string';
                      };
                    };
                    required: ['country', 'address_line1'];
                    type: 'object';
                  };
                  extension_number: {
                    default: '800';
                    description: 'Specify extension number that will be associated with the owner of the account.';
                    type: 'string';
                  };
                };
                required: ['extension_number', 'emergency_address'];
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  emergency_address: {
                    description: 'Specify emergency address for the account.';
                    properties: {
                      address_line1: {
                        description: 'Specify the street address.';
                        type: 'string';
                      };
                      address_line2: {
                        description: 'Specify any building number, floor number, or unit number.';
                        type: 'string';
                      };
                      city: {
                        description: 'City of the emergency address. Required or optional dependent on different countries.';
                        type: 'string';
                      };
                      country: {
                        description: 'Specify the two letter [country code](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) (Alpha-2 code in ISO-3166).';
                        type: 'string';
                      };
                      state_code: {
                        description: 'State code of the emergency address. Required or optional dependent on the country and state.';
                        type: 'string';
                      };
                      zip: {
                        description: 'Zip code of the emergency address. Required or optional dependent on different countries.';
                        type: 'string';
                      };
                    };
                    required: ['country', 'address_line1'];
                    type: 'object';
                  };
                  extension_number: {
                    default: '800';
                    description: 'Specify extension number that will be associated with the owner of the account.';
                    type: 'string';
                  };
                };
                required: ['extension_number', 'emergency_address'];
                type: 'object';
              };
            };
          };
        };
        responses: {
          '201': {
            description: '**HTTP Status Codes** `201`<br>\nCreated.';
          };
          '400': {
            description: '**HTTP Response Code:** `400`<br>\n\n**Error Codes:** `300`<br>\nThe extension number {0} that you entered is a reserved number and can not be used. Provide a different number and try again.<br>\nThis account is not enrolled in a Zoom Phone plan. Subscribe to a Zoom Phone plan and try again.<br>\nThe billing information could not be retrieved at this time. Retry the request again after a few seconds.<br>\nThe country code you entered is invalid. Provide a valid country code and try again.<br>\nThe state code you entered is invalid. Provide a valid state code and try again.<br>\nThe city information you entered is invalid. Provide a valid city name and try again.<br>\nState code is required for this country.<br>\nCity is required for this country.<br>\nZip is required for this country.<br>';
          };
          '401': {
            description: '**HTTP Status Code:** `401`<br>\nUnauthorized.<br>\n\n**Error Code:** <br>\n`124` Account does not exist: {accountId}.<br>';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Set up a Zoom Phone account';
        tags: ['Phone'];
      };
    };
    '/accounts/{accountId}/phone/sip_trunk/trunks': {
      post: {
        description: 'Using this API, a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) owner can assign SIP trunk(s) to a sub account.<br>\n\n**Scope**:<br>\n* `phone:master` <br>\n\n**Prerequisites**:<br>\n* Business or enterprise Account.<br>\n<br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>\n\n';
        operationId: 'postPhoneSIPTrunk';
        parameters: [
          {
            description: 'Unique identifier of the account.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  sip_trunks: {
                    description: 'SIP trunk configurations.';
                    items: {
                      properties: {
                        carrier_account: {
                          description: 'The account associated to the carrier.';
                          type: 'string';
                        };
                        id: {
                          description: "Unique identifier of the master account's SIP trunk.";
                          type: 'string';
                        };
                        name: {
                          default: 'master SIP Trunk name';
                          description: 'The name of the SIP Trunk. If this is not used, the master SIP Trunk name will be the default.\n';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    maxItems: 3;
                    type: 'array';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  sip_trunks: {
                    description: 'SIP trunk configurations.';
                    items: {
                      properties: {
                        carrier_account: {
                          description: 'The account associated to the carrier.';
                          type: 'string';
                        };
                        id: {
                          description: "Unique identifier of the master account's SIP trunk.";
                          type: 'string';
                        };
                        name: {
                          default: 'master SIP Trunk name';
                          description: 'The name of the SIP Trunk. If this is not used, the master SIP Trunk name will be the default.\n';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    maxItems: 3;
                    type: 'array';
                  };
                };
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              sip_trunks: [
                {
                  carrier_account: '9866';
                  id: '1231';
                  name: 'test1';
                },
                {
                  carrier_account: '986677';
                  id: '1234';
                  name: 'test2';
                },
              ];
            };
          };
        };
        responses: {
          '201': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      sip_trunks: [
                        {
                          carrier_account: '9866';
                          id: '123111';
                          name: 'test1';
                        },
                        {
                          carrier_account: '986677';
                          id: '123444';
                          name: 'test2';
                        },
                      ];
                    };
                  };
                };
                schema: {
                  properties: {
                    sip_trunks: {
                      items: {
                        properties: {
                          carrier_account: {
                            description: 'Carrier account.';
                            type: 'string';
                          };
                          id: {
                            description: 'Unique identifier of the SIP trunk of the sub account.';
                            type: 'string';
                          };
                          name: {
                            description: 'Name of the SIP trunk.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    sip_trunks: {
                      items: {
                        properties: {
                          carrier_account: {
                            description: 'Carrier account.';
                            type: 'string';
                          };
                          id: {
                            description: 'Unique identifier of the SIP trunk of the sub account.';
                            type: 'string';
                          };
                          name: {
                            description: 'Name of the SIP trunk.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `201` **Created** <br>\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404` <br>\nSIP Trunk does not exist: {sipTruniId}';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Assign SIP trunks';
        tags: ['Phone'];
      };
    };
    '/accounts/{accountId}/phone/sip_trunk/trunks/{sipTrunkId}': {
      patch: {
        description: 'Update details of a SIP trunk that is assigned to a sub account.<br>\n\n**Scope**:<br>\n* `phone:master` <br>\n\n**Prerequisites**:<br>\nBusiness or Enterprise Account.<br>\n<br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>\n\n';
        operationId: 'updatePhoneSIPTrunk';
        parameters: [
          {
            description: 'Unique identifier of the SIP trunk.';
            in: 'path';
            name: 'sipTrunkId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Unique identifier of the sub account.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  carrier_account: {
                    description: 'Account associated with the carrier.';
                    type: 'string';
                  };
                  name: {
                    description: 'Name of the SIP Trunk.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  carrier_account: {
                    description: 'Account associated with the carrier.';
                    type: 'string';
                  };
                  name: {
                    description: 'Name of the SIP Trunk.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              carrier_account: 're36fshedderit';
              name: 'Test123';
            };
          };
        };
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Response Code**: `204` **No Content**<br>\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404` <br>\nSip trunk does not exist: {0}.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Update SIP trunk details';
        tags: ['Phone'];
      };
    };
    '/accounts/{accountId}/plans': {
      get: {
        description: "Get plan information of a sub account that is managed by a master account. <br><br>This API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' billing information. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>\n**Scopes:** `billing:master`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>\n\n\n ";
        operationId: 'accountPlans';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      plan_audio: {
                        callout_countries: 'string';
                        ddi_numbers: 'integer';
                        premium_countries: 'string';
                        tollfree_countries: 'string';
                        type: 'string';
                      };
                      plan_base: {
                        hosts: 'integer';
                        type: 'string';
                      };
                      plan_large_meeting: [
                        {
                          hosts: 'integer';
                          type: 'string';
                        },
                      ];
                      plan_phone: {
                        plan_base: {
                          callout_countries: 'string';
                          type: 'string';
                        };
                        plan_calling: [
                          {
                            hosts: 'integer';
                            type: 'string';
                          },
                        ];
                        plan_number: [
                          {
                            hosts: 'integer';
                            type: 'string';
                          },
                        ];
                      };
                      plan_recording: 'string';
                      plan_room_connector: {
                        hosts: 'integer';
                        type: 'string';
                      };
                      plan_webinar: [
                        {
                          hosts: 'integer';
                          type: 'string';
                        },
                      ];
                      plan_zoom_rooms: {
                        hosts: 'integer';
                        type: 'string';
                      };
                    };
                  };
                };
                schema: {
                  properties: {
                    plan_audio: {
                      description: 'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type.</a>';
                      properties: {
                        callout_countries: {
                          description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                          type: 'string';
                        };
                        ddi_numbers: {
                          description: 'Dedicated dial-In numbers.';
                          type: 'integer';
                        };
                        next_invoice_date: {
                          description: 'Next invoice date for the plan.';
                          type: 'string';
                        };
                        premium_countries: {
                          description: 'Premium countries: multiple values should be separated by commas. For a list of allowed values, refer to the "ID" field in the [Premium Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#premium-countries) table.';
                          type: 'string';
                        };
                        service_effective_date: {
                          description: 'Date at which the plan became effective on the account.';
                          type: 'string';
                        };
                        status: {
                          description: 'Status of the plan.';
                          enum: ['active', 'cancel', 'expired'];
                          type: 'string';
                        };
                        tollfree_countries: {
                          description: 'Toll-free countries: multiple values should separated by a comma. For a list of allowed values, refer to the "ID" field in the [Toll Free Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#toll-free-countries) table.';
                          type: 'string';
                        };
                        type: {
                          description: 'Additional audio conferencing <a href="/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    plan_base: {
                      properties: {
                        hosts: {
                          description: 'Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.';
                          type: 'integer';
                        };
                        next_invoice_date: {
                          description: 'Next invoice date for the plan.';
                          type: 'string';
                        };
                        service_effective_date: {
                          description: 'Date at which the plan became effective on the account.';
                          type: 'string';
                        };
                        status: {
                          description: 'Status of the plan.';
                          enum: ['active', 'cancel', 'expired'];
                          type: 'string';
                        };
                        type: {
                          description: 'Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    plan_large_meeting: {
                      items: {
                        description: 'Account plan object.';
                        properties: {
                          hosts: {
                            description: 'Account plan number of hosts.';
                            type: 'integer';
                          };
                          next_invoice_date: {
                            description: 'Next invoice date for the plan.';
                            type: 'string';
                          };
                          service_effective_date: {
                            description: 'Date at which the plan became effective on the account.';
                            type: 'string';
                          };
                          status: {
                            description: 'Status of the plan.';
                            enum: ['active', 'cancel', 'expired'];
                            type: 'string';
                          };
                          type: {
                            description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_phone: {
                      description: 'Phone Plan Object';
                      properties: {
                        plan_base: {
                          description: 'Additional phone base plans.';
                          properties: {
                            callout_countries: {
                              description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                              type: 'string';
                            };
                            next_invoice_date: {
                              description: 'Next invoice date for the plan.';
                              type: 'string';
                            };
                            service_effective_date: {
                              description: 'Date at which the plan became effective on the account.';
                              type: 'string';
                            };
                            status: {
                              description: 'Status of the plan.';
                              enum: ['active', 'cancel', 'expired'];
                              type: 'string';
                            };
                            type: {
                              description: 'Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        plan_calling: {
                          description: 'Additional phone calling plans.';
                          items: {
                            properties: {
                              hosts: {
                                type: 'integer';
                              };
                              next_invoice_date: {
                                description: 'Next invoice date for the plan.';
                                type: 'string';
                              };
                              service_effective_date: {
                                description: 'Date at which the plan became effective on the account.';
                                type: 'string';
                              };
                              status: {
                                description: 'Status of the plan.';
                                enum: ['active', 'cancel', 'expired'];
                                type: 'string';
                              };
                              type: {
                                description: 'Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          type: 'array';
                        };
                        plan_number: {
                          description: 'Additional phone number plans.';
                          items: {
                            properties: {
                              hosts: {
                                type: 'integer';
                              };
                              next_invoice_date: {
                                description: 'Next invoice date for the plan.';
                                type: 'string';
                              };
                              service_effective_date: {
                                description: 'Date at which the plan became effective on the account.';
                                type: 'string';
                              };
                              status: {
                                description: 'Status of the plan.';
                                enum: ['active', 'cancel', 'expired'];
                                type: 'string';
                              };
                              type: {
                                description: 'Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          type: 'array';
                        };
                      };
                      title: 'PhonePlan';
                      type: 'object';
                    };
                    plan_recording: {
                      description: 'Additional Cloud Recording plan.';
                      type: 'string';
                    };
                    plan_recording_next_invoice_date: {
                      description: 'Next invoice date of Additional Cloud Recording plan.';
                      type: 'string';
                    };
                    plan_recording_service_effective_date: {
                      description: 'Plan start date of Additional Cloud Recording plan.';
                      type: 'string';
                    };
                    plan_recording_status: {
                      description: 'Status of additional Cloud Recording plan.';
                      enum: ['Active', 'Cancelled'];
                      type: 'string';
                    };
                    plan_room_connector: {
                      properties: {
                        hosts: {
                          description: 'Account plan number of hosts.';
                          type: 'integer';
                        };
                        next_invoice_date: {
                          description: 'Next invoice date for the plan.';
                          type: 'string';
                        };
                        service_effective_date: {
                          description: 'Date at which the plan became effective on the account.';
                          type: 'string';
                        };
                        status: {
                          description: 'Status of the plan.';
                          enum: ['active', 'cancel', 'expired'];
                          type: 'string';
                        };
                        type: {
                          description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    plan_webinar: {
                      items: {
                        description: 'Account plan object.';
                        properties: {
                          hosts: {
                            description: 'Account plan number of hosts.';
                            type: 'integer';
                          };
                          next_invoice_date: {
                            description: 'Next invoice date for the plan.';
                            type: 'string';
                          };
                          service_effective_date: {
                            description: 'Date at which the plan became effective on the account.';
                            type: 'string';
                          };
                          status: {
                            description: 'Status of the plan.';
                            enum: ['active', 'cancel', 'expired'];
                            type: 'string';
                          };
                          type: {
                            description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_zoom_rooms: {
                      properties: {
                        hosts: {
                          description: 'Account plan number of hosts.';
                          type: 'integer';
                        };
                        next_invoice_date: {
                          description: 'Next invoice date for the plan.';
                          type: 'string';
                        };
                        service_effective_date: {
                          description: 'Date at which the plan became effective on the account.';
                          type: 'string';
                        };
                        status: {
                          description: 'Status of the plan.';
                          enum: ['active', 'cancel', 'expired'];
                          type: 'string';
                        };
                        type: {
                          description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    plan_audio: {
                      description: 'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type.</a>';
                      properties: {
                        callout_countries: {
                          description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                          type: 'string';
                        };
                        ddi_numbers: {
                          description: 'Dedicated dial-In numbers.';
                          type: 'integer';
                        };
                        next_invoice_date: {
                          description: 'Next invoice date for the plan.';
                          type: 'string';
                        };
                        premium_countries: {
                          description: 'Premium countries: multiple values should be separated by commas. For a list of allowed values, refer to the "ID" field in the [Premium Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#premium-countries) table.';
                          type: 'string';
                        };
                        service_effective_date: {
                          description: 'Date at which the plan became effective on the account.';
                          type: 'string';
                        };
                        status: {
                          description: 'Status of the plan.';
                          enum: ['active', 'cancel', 'expired'];
                          type: 'string';
                        };
                        tollfree_countries: {
                          description: 'Toll-free countries: multiple values should separated by a comma. For a list of allowed values, refer to the "ID" field in the [Toll Free Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#toll-free-countries) table.';
                          type: 'string';
                        };
                        type: {
                          description: 'Additional audio conferencing <a href="/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    plan_base: {
                      properties: {
                        hosts: {
                          description: 'Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.';
                          type: 'integer';
                        };
                        next_invoice_date: {
                          description: 'Next invoice date for the plan.';
                          type: 'string';
                        };
                        service_effective_date: {
                          description: 'Date at which the plan became effective on the account.';
                          type: 'string';
                        };
                        status: {
                          description: 'Status of the plan.';
                          enum: ['active', 'cancel', 'expired'];
                          type: 'string';
                        };
                        type: {
                          description: 'Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    plan_large_meeting: {
                      items: {
                        description: 'Account plan object.';
                        properties: {
                          hosts: {
                            description: 'Account plan number of hosts.';
                            type: 'integer';
                          };
                          next_invoice_date: {
                            description: 'Next invoice date for the plan.';
                            type: 'string';
                          };
                          service_effective_date: {
                            description: 'Date at which the plan became effective on the account.';
                            type: 'string';
                          };
                          status: {
                            description: 'Status of the plan.';
                            enum: ['active', 'cancel', 'expired'];
                            type: 'string';
                          };
                          type: {
                            description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_phone: {
                      description: 'Phone Plan Object';
                      properties: {
                        plan_base: {
                          description: 'Additional phone base plans.';
                          properties: {
                            callout_countries: {
                              description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                              type: 'string';
                            };
                            next_invoice_date: {
                              description: 'Next invoice date for the plan.';
                              type: 'string';
                            };
                            service_effective_date: {
                              description: 'Date at which the plan became effective on the account.';
                              type: 'string';
                            };
                            status: {
                              description: 'Status of the plan.';
                              enum: ['active', 'cancel', 'expired'];
                              type: 'string';
                            };
                            type: {
                              description: 'Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        plan_calling: {
                          description: 'Additional phone calling plans.';
                          items: {
                            properties: {
                              hosts: {
                                type: 'integer';
                              };
                              next_invoice_date: {
                                description: 'Next invoice date for the plan.';
                                type: 'string';
                              };
                              service_effective_date: {
                                description: 'Date at which the plan became effective on the account.';
                                type: 'string';
                              };
                              status: {
                                description: 'Status of the plan.';
                                enum: ['active', 'cancel', 'expired'];
                                type: 'string';
                              };
                              type: {
                                description: 'Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          type: 'array';
                        };
                        plan_number: {
                          description: 'Additional phone number plans.';
                          items: {
                            properties: {
                              hosts: {
                                type: 'integer';
                              };
                              next_invoice_date: {
                                description: 'Next invoice date for the plan.';
                                type: 'string';
                              };
                              service_effective_date: {
                                description: 'Date at which the plan became effective on the account.';
                                type: 'string';
                              };
                              status: {
                                description: 'Status of the plan.';
                                enum: ['active', 'cancel', 'expired'];
                                type: 'string';
                              };
                              type: {
                                description: 'Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          type: 'array';
                        };
                      };
                      title: 'PhonePlan';
                      type: 'object';
                    };
                    plan_recording: {
                      description: 'Additional Cloud Recording plan.';
                      type: 'string';
                    };
                    plan_recording_next_invoice_date: {
                      description: 'Next invoice date of Additional Cloud Recording plan.';
                      type: 'string';
                    };
                    plan_recording_service_effective_date: {
                      description: 'Plan start date of Additional Cloud Recording plan.';
                      type: 'string';
                    };
                    plan_recording_status: {
                      description: 'Status of additional Cloud Recording plan.';
                      enum: ['Active', 'Cancelled'];
                      type: 'string';
                    };
                    plan_room_connector: {
                      properties: {
                        hosts: {
                          description: 'Account plan number of hosts.';
                          type: 'integer';
                        };
                        next_invoice_date: {
                          description: 'Next invoice date for the plan.';
                          type: 'string';
                        };
                        service_effective_date: {
                          description: 'Date at which the plan became effective on the account.';
                          type: 'string';
                        };
                        status: {
                          description: 'Status of the plan.';
                          enum: ['active', 'cancel', 'expired'];
                          type: 'string';
                        };
                        type: {
                          description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    plan_webinar: {
                      items: {
                        description: 'Account plan object.';
                        properties: {
                          hosts: {
                            description: 'Account plan number of hosts.';
                            type: 'integer';
                          };
                          next_invoice_date: {
                            description: 'Next invoice date for the plan.';
                            type: 'string';
                          };
                          service_effective_date: {
                            description: 'Date at which the plan became effective on the account.';
                            type: 'string';
                          };
                          status: {
                            description: 'Status of the plan.';
                            enum: ['active', 'cancel', 'expired'];
                            type: 'string';
                          };
                          type: {
                            description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_zoom_rooms: {
                      properties: {
                        hosts: {
                          description: 'Account plan number of hosts.';
                          type: 'integer';
                        };
                        next_invoice_date: {
                          description: 'Next invoice date for the plan.';
                          type: 'string';
                        };
                        service_effective_date: {
                          description: 'Date at which the plan became effective on the account.';
                          type: 'string';
                        };
                        status: {
                          description: 'Status of the plan.';
                          enum: ['active', 'cancel', 'expired'];
                          type: 'string';
                        };
                        type: {
                          description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: "**HTTP Status Code:**`200`<br>\nAccount's plans returned.\n";
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `2100`<br> \nThis sub account is on self pay mode.';
          };
          '404': {
            description: '**HTTP Status Code:**`404`<br>\nAccount does not exist: {subAccountId}.';
          };
        };
        summary: 'Get plan Information';
        tags: ['Billing'];
      };
      post: {
        description: "Subscribe a sub account to a Zoom plan using your master account. This API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' subscriptions. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>\n**Scopes**: `billing:master`<br>\n ";
        operationId: 'accountPlanCreate';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                allOf: [
                  {
                    properties: {
                      contact: {
                        description: 'Billing Contact object.';
                        properties: {
                          address: {
                            description: "Billing Contact's address.";
                            type: 'string';
                          };
                          apt: {
                            description: "Billing Contact's apartment/suite.";
                            type: 'string';
                          };
                          city: {
                            description: "Billing Contact's city.";
                            type: 'string';
                          };
                          country: {
                            description: "Billing Contact's Country [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) in abbreviated format.";
                            type: 'string';
                          };
                          email: {
                            description: "Billing Contact's email address.";
                            type: 'string';
                          };
                          first_name: {
                            description: "Billing Contact's first name.";
                            type: 'string';
                          };
                          last_name: {
                            description: "Billing Contact's last name.";
                            type: 'string';
                          };
                          phone_number: {
                            description: "Billing Contact's phone number.";
                            type: 'string';
                          };
                          state: {
                            description: "Billing Contact's state.";
                            type: 'string';
                          };
                          zip: {
                            description: "Billing Contact's zip/postal code.";
                            type: 'string';
                          };
                        };
                        required: [
                          'first_name',
                          'last_name',
                          'email',
                          'phone_number',
                          'address',
                          'city',
                          'state',
                          'zip',
                          'country',
                        ];
                        type: 'object';
                      };
                    };
                    type: 'object';
                  },
                  {
                    description: 'Account Plans object.';
                    properties: {
                      plan_audio: {
                        description: 'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.';
                        properties: {
                          callout_countries: {
                            description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                            type: 'string';
                          };
                          ddi_numbers: {
                            description: 'Dedicated dial-In numbers.';
                            type: 'integer';
                          };
                          premium_countries: {
                            description: 'Premium countries: multiple values should be separated by commas. For a list of allowed values, refer to the "ID" field in the [Premium Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#premium-countries) table.';
                            type: 'string';
                          };
                          tollfree_countries: {
                            description: 'Toll-free countries: multiple values should separated by a comma. For a list of allowed values, refer to the "ID" field in the [Toll Free Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#toll-free-countries) table.';
                            type: 'string';
                          };
                          type: {
                            description: 'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      plan_base: {
                        description: 'Account base plan object.';
                        properties: {
                          hosts: {
                            description: 'Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.';
                            type: 'integer';
                          };
                          type: {
                            description: 'Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        required: ['type', 'hosts'];
                        type: 'object';
                      };
                      plan_large_meeting: {
                        description: 'Additional large meeting Plans.';
                        items: {
                          description: 'Account plan object.';
                          properties: {
                            hosts: {
                              description: 'Account plan number of hosts.';
                              type: 'integer';
                            };
                            type: {
                              description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        type: 'array';
                      };
                      plan_phone: {
                        description: 'Phone Plan Object';
                        properties: {
                          plan_base: {
                            description: 'Additional phone base plans.';
                            properties: {
                              callout_countries: {
                                description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                                type: 'string';
                              };
                              type: {
                                description: 'Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          plan_calling: {
                            description: 'Additional phone calling plans.';
                            items: {
                              properties: {
                                hosts: {
                                  type: 'integer';
                                };
                                type: {
                                  description: 'Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                          plan_number: {
                            description: 'Additional phone number plans.';
                            items: {
                              properties: {
                                hosts: {
                                  type: 'integer';
                                };
                                type: {
                                  description: 'Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                        };
                        title: 'PhonePlan';
                        type: 'object';
                      };
                      plan_recording: {
                        description: 'Additional cloud recording plan.';
                        type: 'string';
                      };
                      plan_room_connector: {
                        description: 'Account plan object.';
                        properties: {
                          hosts: {
                            description: 'Account plan number of hosts.';
                            type: 'integer';
                          };
                          type: {
                            description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      plan_webinar: {
                        description: 'Additional webinar plans.';
                        items: {
                          description: 'Account plan object.';
                          properties: {
                            hosts: {
                              description: 'Account plan number of hosts.';
                              type: 'integer';
                            };
                            type: {
                              description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        type: 'array';
                      };
                      plan_zoom_rooms: {
                        description: 'Account plan object.';
                        properties: {
                          hosts: {
                            description: 'Account plan number of hosts.';
                            type: 'integer';
                          };
                          type: {
                            description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                    };
                    required: ['plan_base'];
                    type: 'object';
                  },
                ];
              };
            };
            'multipart/form-data': {
              schema: {
                allOf: [
                  {
                    properties: {
                      contact: {
                        description: 'Billing Contact object.';
                        properties: {
                          address: {
                            description: "Billing Contact's address.";
                            type: 'string';
                          };
                          apt: {
                            description: "Billing Contact's apartment/suite.";
                            type: 'string';
                          };
                          city: {
                            description: "Billing Contact's city.";
                            type: 'string';
                          };
                          country: {
                            description: "Billing Contact's Country [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) in abbreviated format.";
                            type: 'string';
                          };
                          email: {
                            description: "Billing Contact's email address.";
                            type: 'string';
                          };
                          first_name: {
                            description: "Billing Contact's first name.";
                            type: 'string';
                          };
                          last_name: {
                            description: "Billing Contact's last name.";
                            type: 'string';
                          };
                          phone_number: {
                            description: "Billing Contact's phone number.";
                            type: 'string';
                          };
                          state: {
                            description: "Billing Contact's state.";
                            type: 'string';
                          };
                          zip: {
                            description: "Billing Contact's zip/postal code.";
                            type: 'string';
                          };
                        };
                        required: [
                          'first_name',
                          'last_name',
                          'email',
                          'phone_number',
                          'address',
                          'city',
                          'state',
                          'zip',
                          'country',
                        ];
                        type: 'object';
                      };
                    };
                    type: 'object';
                  },
                  {
                    description: 'Account Plans object.';
                    properties: {
                      plan_audio: {
                        description: 'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.';
                        properties: {
                          callout_countries: {
                            description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                            type: 'string';
                          };
                          ddi_numbers: {
                            description: 'Dedicated dial-In numbers.';
                            type: 'integer';
                          };
                          premium_countries: {
                            description: 'Premium countries: multiple values should be separated by commas. For a list of allowed values, refer to the "ID" field in the [Premium Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#premium-countries) table.';
                            type: 'string';
                          };
                          tollfree_countries: {
                            description: 'Toll-free countries: multiple values should separated by a comma. For a list of allowed values, refer to the "ID" field in the [Toll Free Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#toll-free-countries) table.';
                            type: 'string';
                          };
                          type: {
                            description: 'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      plan_base: {
                        description: 'Account base plan object.';
                        properties: {
                          hosts: {
                            description: 'Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.';
                            type: 'integer';
                          };
                          type: {
                            description: 'Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        required: ['type', 'hosts'];
                        type: 'object';
                      };
                      plan_large_meeting: {
                        description: 'Additional large meeting Plans.';
                        items: {
                          description: 'Account plan object.';
                          properties: {
                            hosts: {
                              description: 'Account plan number of hosts.';
                              type: 'integer';
                            };
                            type: {
                              description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        type: 'array';
                      };
                      plan_phone: {
                        description: 'Phone Plan Object';
                        properties: {
                          plan_base: {
                            description: 'Additional phone base plans.';
                            properties: {
                              callout_countries: {
                                description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                                type: 'string';
                              };
                              type: {
                                description: 'Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          plan_calling: {
                            description: 'Additional phone calling plans.';
                            items: {
                              properties: {
                                hosts: {
                                  type: 'integer';
                                };
                                type: {
                                  description: 'Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                          plan_number: {
                            description: 'Additional phone number plans.';
                            items: {
                              properties: {
                                hosts: {
                                  type: 'integer';
                                };
                                type: {
                                  description: 'Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                        };
                        title: 'PhonePlan';
                        type: 'object';
                      };
                      plan_recording: {
                        description: 'Additional cloud recording plan.';
                        type: 'string';
                      };
                      plan_room_connector: {
                        description: 'Account plan object.';
                        properties: {
                          hosts: {
                            description: 'Account plan number of hosts.';
                            type: 'integer';
                          };
                          type: {
                            description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      plan_webinar: {
                        description: 'Additional webinar plans.';
                        items: {
                          description: 'Account plan object.';
                          properties: {
                            hosts: {
                              description: 'Account plan number of hosts.';
                              type: 'integer';
                            };
                            type: {
                              description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        type: 'array';
                      };
                      plan_zoom_rooms: {
                        description: 'Account plan object.';
                        properties: {
                          hosts: {
                            description: 'Account plan number of hosts.';
                            type: 'integer';
                          };
                          type: {
                            description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                    };
                    required: ['plan_base'];
                    type: 'object';
                  },
                ];
              };
            };
          };
          required: true;
          'x-examples': {
            'application/json': {
              contact: {
                address: 'string';
                apt: 'string';
                city: 'string';
                country: 'string';
                email: 'string';
                first_name: 'string';
                last_name: 'string';
                phone_number: 'string';
                state: 'string';
                zip: 'string';
              };
              plan_audio: {
                callout_countries: 'string';
                ddi_numbers: 'integer';
                premium_countries: 'string';
                tollfree_countries: 'string';
                type: 'string';
              };
              plan_base: {
                hosts: 'integer';
                type: 'string';
              };
              plan_large_meeting: [
                {
                  hosts: 'integer';
                  type: 'string';
                },
              ];
              plan_phone: {
                plan_base: {
                  callout_countries: 'string';
                  type: 'string';
                };
                plan_calling: [
                  {
                    hosts: 'integer';
                    type: 'string';
                  },
                ];
                plan_number: [
                  {
                    hosts: 'integer';
                    type: 'string';
                  },
                ];
              };
              plan_recording: 'string';
              plan_room_connector: {
                hosts: 'integer';
                type: 'string';
              };
              plan_webinar: [
                {
                  hosts: 'integer';
                  type: 'string';
                },
              ];
              plan_zoom_rooms: {
                hosts: 'integer';
                type: 'string';
              };
            };
          };
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**Error Code:** `200`<br>\nOne zuora account only can have one active billing subscription.<br>\nCan’t subscribe 25-participants pro plan for this sub-account.<br>\nCan’t subscribe 50-participants pro plan for this sub-account.<br>\nIn order to take advantage of your account’s special pricing, please add Pro host licenses instead and they will be assigned to your Zoom Rooms automatically.';
          };
          '201': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      plan_audio: {
                        callout_countries: 'string';
                        ddi_numbers: 'integer';
                        premium_countries: 'string';
                        tollfree_countries: 'string';
                        type: 'string';
                      };
                      plan_base: {
                        hosts: 'integer';
                        type: 'string';
                      };
                      plan_large_meeting: [
                        {
                          hosts: 'integer';
                          type: 'string';
                        },
                      ];
                      plan_recording: 'string';
                      plan_room_connector: {
                        hosts: 'integer';
                        type: 'string';
                      };
                      plan_webinar: [
                        {
                          hosts: 'integer';
                          type: 'string';
                        },
                      ];
                      plan_zoom_rooms: {
                        hosts: 'integer';
                        type: 'string';
                      };
                    };
                  };
                };
                schema: {
                  description: 'Account Plans object.';
                  properties: {
                    plan_audio: {
                      description: 'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.';
                      properties: {
                        callout_countries: {
                          description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                          type: 'string';
                        };
                        ddi_numbers: {
                          description: 'Dedicated dial-In numbers.';
                          type: 'integer';
                        };
                        premium_countries: {
                          description: 'Premium countries: multiple values should be separated by commas. For a list of allowed values, refer to the "ID" field in the [Premium Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#premium-countries) table.';
                          type: 'string';
                        };
                        tollfree_countries: {
                          description: 'Toll-free countries: multiple values should separated by a comma. For a list of allowed values, refer to the "ID" field in the [Toll Free Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#toll-free-countries) table.';
                          type: 'string';
                        };
                        type: {
                          description: 'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    plan_base: {
                      description: 'Account base plan object.';
                      properties: {
                        hosts: {
                          description: 'Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.';
                          type: 'integer';
                        };
                        type: {
                          description: 'Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      required: ['type', 'hosts'];
                      type: 'object';
                    };
                    plan_large_meeting: {
                      description: 'Additional large meeting Plans.';
                      items: {
                        description: 'Account plan object.';
                        properties: {
                          hosts: {
                            description: 'Account plan number of hosts.';
                            type: 'integer';
                          };
                          type: {
                            description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_phone: {
                      description: 'Phone Plan Object';
                      properties: {
                        plan_base: {
                          description: 'Additional phone base plans.';
                          properties: {
                            callout_countries: {
                              description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                              type: 'string';
                            };
                            type: {
                              description: 'Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        plan_calling: {
                          description: 'Additional phone calling plans.';
                          items: {
                            properties: {
                              hosts: {
                                type: 'integer';
                              };
                              type: {
                                description: 'Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          type: 'array';
                        };
                        plan_number: {
                          description: 'Additional phone number plans.';
                          items: {
                            properties: {
                              hosts: {
                                type: 'integer';
                              };
                              type: {
                                description: 'Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          type: 'array';
                        };
                      };
                      title: 'PhonePlan';
                      type: 'object';
                    };
                    plan_recording: {
                      description: 'Additional cloud recording plan.';
                      type: 'string';
                    };
                    plan_room_connector: {
                      description: 'Account plan object.';
                      properties: {
                        hosts: {
                          description: 'Account plan number of hosts.';
                          type: 'integer';
                        };
                        type: {
                          description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    plan_webinar: {
                      description: 'Additional webinar plans.';
                      items: {
                        description: 'Account plan object.';
                        properties: {
                          hosts: {
                            description: 'Account plan number of hosts.';
                            type: 'integer';
                          };
                          type: {
                            description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_zoom_rooms: {
                      description: 'Account plan object.';
                      properties: {
                        hosts: {
                          description: 'Account plan number of hosts.';
                          type: 'integer';
                        };
                        type: {
                          description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                  };
                  required: ['plan_base'];
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  description: 'Account Plans object.';
                  properties: {
                    plan_audio: {
                      description: 'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.';
                      properties: {
                        callout_countries: {
                          description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                          type: 'string';
                        };
                        ddi_numbers: {
                          description: 'Dedicated dial-In numbers.';
                          type: 'integer';
                        };
                        premium_countries: {
                          description: 'Premium countries: multiple values should be separated by commas. For a list of allowed values, refer to the "ID" field in the [Premium Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#premium-countries) table.';
                          type: 'string';
                        };
                        tollfree_countries: {
                          description: 'Toll-free countries: multiple values should separated by a comma. For a list of allowed values, refer to the "ID" field in the [Toll Free Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#toll-free-countries) table.';
                          type: 'string';
                        };
                        type: {
                          description: 'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    plan_base: {
                      description: 'Account base plan object.';
                      properties: {
                        hosts: {
                          description: 'Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.';
                          type: 'integer';
                        };
                        type: {
                          description: 'Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      required: ['type', 'hosts'];
                      type: 'object';
                    };
                    plan_large_meeting: {
                      description: 'Additional large meeting Plans.';
                      items: {
                        description: 'Account plan object.';
                        properties: {
                          hosts: {
                            description: 'Account plan number of hosts.';
                            type: 'integer';
                          };
                          type: {
                            description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_phone: {
                      description: 'Phone Plan Object';
                      properties: {
                        plan_base: {
                          description: 'Additional phone base plans.';
                          properties: {
                            callout_countries: {
                              description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                              type: 'string';
                            };
                            type: {
                              description: 'Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        plan_calling: {
                          description: 'Additional phone calling plans.';
                          items: {
                            properties: {
                              hosts: {
                                type: 'integer';
                              };
                              type: {
                                description: 'Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          type: 'array';
                        };
                        plan_number: {
                          description: 'Additional phone number plans.';
                          items: {
                            properties: {
                              hosts: {
                                type: 'integer';
                              };
                              type: {
                                description: 'Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          type: 'array';
                        };
                      };
                      title: 'PhonePlan';
                      type: 'object';
                    };
                    plan_recording: {
                      description: 'Additional cloud recording plan.';
                      type: 'string';
                    };
                    plan_room_connector: {
                      description: 'Account plan object.';
                      properties: {
                        hosts: {
                          description: 'Account plan number of hosts.';
                          type: 'integer';
                        };
                        type: {
                          description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    plan_webinar: {
                      description: 'Additional webinar plans.';
                      items: {
                        description: 'Account plan object.';
                        properties: {
                          hosts: {
                            description: 'Account plan number of hosts.';
                            type: 'integer';
                          };
                          type: {
                            description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_zoom_rooms: {
                      description: 'Account plan object.';
                      properties: {
                        hosts: {
                          description: 'Account plan number of hosts.';
                          type: 'integer';
                        };
                        type: {
                          description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                  };
                  required: ['plan_base'];
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:**`201`<br>\nAccount plans updated.';
          };
          '300': {
            description: '**Error Code**: `300`<br>Account can’t buy this plan.<br>\nBuy hosts must equal or larger than {minBuyHost}.<br>\nBuy hosts must equal or smaller than {maxBuyHost}.<br>\nBuy hosts must equal or smaller than 9999.<br>\nActive hosts must be equal or larger than buy hosts.<br>\nBuy hosts/active hosts must be equal or larger than {MinActiveHost}.<br>\nThis bundle plan doesn’t support active host.<br>\nInvalid free trial end date time.<br>\nInvalid free trial start/end time.<br>\nToo long trial duration.\n\t';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br> **Error Code:** `2100`<br> Invalid parameter: first_name<br>\nInvalid parameter: last_name<br>Invalid parameter: email<br>Invalid parameter: country<br>Invalid parameter: address\nInvalid parameter: city<br>Invalid parameter: phone_number<br>Invalid parameter: state<br>Invalid parameter: zip<br>Invalid country parameter: {country}<br>Invalid state parameter: {state}<br>Invalid field: plan_bundle<br>Can’t subscribe to base plan and bundle plan at the same time.<br>Cannot add plan for a sub account which is paid by self.<br>Cannot enable free trial again for sub account.<br>You cannot add a sub account because your master account owner prevented you from adding one.<br>\nCannot add plan for Sub account which is not free plan.<br>Error getting bundle.<br>Cannot process account.<br>Invalid host number.<br>Account doesn’t have the permission to purchase this plan.<br>There was a conflict in processing this request. Zoom Room plan {planCode} is already included in the bundle plan.<br>There was a conflict in processing this request. Room Connector plan {planCode} is already included in the bundle plan.<br>There was a conflict in processing this request. Large meeting plan {planCode} is already included in bundle plan.<br>There was a conflict in processing this request. Webinar plan {planCode} is already included in the bundle plan.<br>Recording plan {planCode} conflict with bundle plan.<br>Invalid Cloud Recording Plan: {plan_recording}\nAudio conferencing plan {planCode} conflict with bundle plan.<br>Invalid Audio Conferencing Plan: {planCode}<br>At least one option from among the Toll-free, Premium and Call-out must be provided.<br>Failed to add zuora plans<br>Invalid Base Plan: {subAccountId}<br>Master accounts with bulk licenses cannot provision, update, or cancel plans for sub accounts using APIs, please use the billing portal or contact Support.\n\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br> **Error Code:** `1001`<br> User does not exist.<br> \n**Error Code:** `2001`<br> Account does not exist: {subAccountId}.<br>\n\n';
          };
        };
        summary: 'Subscribe plans';
        tags: ['Billing'];
      };
    };
    '/accounts/{accountId}/plans/addons': {
      post: {
        description: "Subscribe a sub account to a Zoom addon plan. This API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' subscriptions. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>\n<br>**Prerequisites:**<br>\n* Pro or a higher plan with master account option enabled.\n* The sub account must be a paid account. The billing charges for the sub account must be paid by its master account.<br><br>\n\n**Scopes**: `billing:master`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>\n\n";
        operationId: 'accountPlanAddonCreate';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                oneOf: [
                  {
                    description: 'Account plan object.';
                    properties: {
                      hosts: {
                        description: 'Number of hosts for this plan.';
                        type: 'integer';
                      };
                      type: {
                        description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                        type: 'string';
                      };
                    };
                    required: ['type', 'hosts'];
                    type: 'object';
                  },
                  {
                    description: 'Zoom Phone Plan Object';
                    properties: {
                      plan_details: {
                        description: 'Phone Plan Object';
                        properties: {
                          plan_base: {
                            description: 'Additional phone base plans.';
                            properties: {
                              callout_countries: {
                                description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                                type: 'string';
                              };
                              type: {
                                description: 'Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          plan_calling: {
                            description: 'Additional phone calling plans.';
                            items: {
                              properties: {
                                hosts: {
                                  type: 'integer';
                                };
                                type: {
                                  description: 'Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                          plan_number: {
                            description: 'Additional phone number plans.';
                            items: {
                              properties: {
                                hosts: {
                                  type: 'integer';
                                };
                                type: {
                                  description: 'Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                        };
                        title: 'PhonePlan';
                        type: 'object';
                      };
                      type: {
                        description: 'Zoom Phone Plan `plan_phone`';
                        type: 'string';
                      };
                    };
                    required: ['type', 'plan_details'];
                    type: 'object';
                  },
                ];
              };
            };
            'multipart/form-data': {
              schema: {
                oneOf: [
                  {
                    description: 'Account plan object.';
                    properties: {
                      hosts: {
                        description: 'Number of hosts for this plan.';
                        type: 'integer';
                      };
                      type: {
                        description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                        type: 'string';
                      };
                    };
                    required: ['type', 'hosts'];
                    type: 'object';
                  },
                  {
                    description: 'Zoom Phone Plan Object';
                    properties: {
                      plan_details: {
                        description: 'Phone Plan Object';
                        properties: {
                          plan_base: {
                            description: 'Additional phone base plans.';
                            properties: {
                              callout_countries: {
                                description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                                type: 'string';
                              };
                              type: {
                                description: 'Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          plan_calling: {
                            description: 'Additional phone calling plans.';
                            items: {
                              properties: {
                                hosts: {
                                  type: 'integer';
                                };
                                type: {
                                  description: 'Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                          plan_number: {
                            description: 'Additional phone number plans.';
                            items: {
                              properties: {
                                hosts: {
                                  type: 'integer';
                                };
                                type: {
                                  description: 'Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                        };
                        title: 'PhonePlan';
                        type: 'object';
                      };
                      type: {
                        description: 'Zoom Phone Plan `plan_phone`';
                        type: 'string';
                      };
                    };
                    required: ['type', 'plan_details'];
                    type: 'object';
                  },
                ];
              };
            };
          };
          required: true;
          'x-examples': {
            'application/json': {
              hosts: 'integer';
              type: 'string';
            };
          };
        };
        responses: {
          '201': {
            description: 'Account plans updated.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `2100`<br> \nThis sub account is on self pay mode.<br>\nCannot update Additional plan for a sub account under free plan.<br>\nAdditional Zoom Rooms plan cannot be added to a sub account that already has a Zoom Rooms base plan.<br>\nThis sub account already has the additional plan: {planCode}.<br>\nMaster accounts with bulk licenses cannot provision, update, or cancel plans for sub accounts using APIs, please use the billing portal or contact Support.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `1001`<br> \nUser does not exist.<br>\n**Error Code:** `2001`<br> \nAccount does not exist: {subAccountId}.\n';
          };
        };
        summary: 'Subscribe additional plan';
        tags: ['Billing'];
      };
      put: {
        description: "Update an additional plan for a sub account.\n\nThis API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' subscriptions. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>\n<br>**Prerequisites:**<br>\n* Pro or a higher plan with master account enabled.\n* The sub account must be a paid account. The billing charges for the sub account must be paid by the master account.<br><br>\n\n**Scopes**: `billing:master`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>\n\n\n ";
        operationId: 'accountPlanAddonUpdate';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                description: 'Account plan object.';
                properties: {
                  hosts: {
                    description: 'Number of hosts for this plan.';
                    type: 'integer';
                  };
                  type: {
                    description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                    type: 'string';
                  };
                };
                required: ['type', 'hosts'];
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                description: 'Account plan object.';
                properties: {
                  hosts: {
                    description: 'Number of hosts for this plan.';
                    type: 'integer';
                  };
                  type: {
                    description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                    type: 'string';
                  };
                };
                required: ['type', 'hosts'];
                type: 'object';
              };
            };
          };
          required: true;
          'x-examples': {
            'application/json': {
              hosts: 'integer';
              type: 'string';
            };
          };
        };
        responses: {
          '200': {
            description: "**Error Code:** `200`<br>\nFree trial and VIP accounts can't update sub plans.<br>\nYou don’t have subscription for ({oldPlanCode}) yet.\n";
          };
          '204': {
            description: '**HTTP Status Code:** `204`<br>\nAdditional plan updated for the account.';
          };
          '300': {
            description: '**Error Code:** `300`<br>\nPlan types do not match, oldPlanType: {oldPlanType} newPlanType: {newPlanType}.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `2100`\n<br>This sub account is on self pay mode.\n<br>Invalid Additional Plan Type: {newPlanCode}.\n<br>Cannot update Additional plan for a sub account under free plan.\n<br>Invalid plan type.\n<br>Account can’t buy this product.\n<br>Can not subscribe/update additional Audio Conferencing Pay As You Go Plan for a sub account whose base plan is not Business/Education plan.<br>\nMaster accounts with bulk licenses cannot provision, update, or cancel plans for sub accounts using APIs, please use the billing portal or contact Support.<br>\n**Error Code:** `3261`<br>\nFailed to change sub plan of account:{accountId}.<br>\nMust subscribe to a major plan first.\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `2001`<br>\nAccount does not exist: {subAccountId}.<br>\n**Error Code:** `3200`<br>\nCannot find Zuora subscription for account:{subAccountId}.\n';
          };
        };
        summary: 'Update an additional plan';
        tags: ['Billing'];
      };
    };
    '/accounts/{accountId}/plans/addons/status': {
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      patch: {
        description: "[Cancel additional plan](https://support.zoom.us/hc/en-us/articles/203634215-How-Do-I-Cancel-My-Subscription-) of a sub account. The cancellation does not provide refund for the current subscription. The service remains active for the current session.\n\nThis API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' subscriptions. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>\n\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>\n\n**Prerequisites:**<br>\n* Pro or a higher plan with master account option enabled.\n* The sub account must be a paid account.<br>\n**Scope:** `billing:master`<br>\n ";
        operationId: 'accountPlanAddonCancel';
        requestBody: {
          content: {
            'application/json': {
              schema: {
                description: 'Account plan object';
                properties: {
                  action: {
                    description: 'The action that needs to be taken for this sub account. Value must be set to "cancel".';
                    enum: ['cancel'];
                    type: 'string';
                  };
                  comment: {
                    description: 'Additional comments about the cancellation decision.';
                    type: 'string';
                  };
                  reason: {
                    description: 'The reason for the cancellation of plan. Reason options:<br>`1` - I am no longer working remote.<br>`2` - I had challenges getting the support I needed.<br>`3` - Features in the Basic Free Plan are sufficient.<br>`4` - The expense is too high.<br>`5` - I purchased the wrong product.<br> `6` - Paid purchase not needed right now, will repurchase in the future.';
                    enum: [1, 2, 3, 4, 5, 6];
                    type: 'integer';
                  };
                  type: {
                    description: 'Plan [type](https://marketplace.zoom.us/docs/api-reference/other-references/plans).';
                    type: 'string';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                description: 'Account plan object';
                properties: {
                  action: {
                    description: 'The action that needs to be taken for this sub account. Value must be set to "cancel".';
                    enum: ['cancel'];
                    type: 'string';
                  };
                  comment: {
                    description: 'Additional comments about the cancellation decision.';
                    type: 'string';
                  };
                  reason: {
                    description: 'The reason for the cancellation of plan. Reason options:<br>`1` - I am no longer working remote.<br>`2` - I had challenges getting the support I needed.<br>`3` - Features in the Basic Free Plan are sufficient.<br>`4` - The expense is too high.<br>`5` - I purchased the wrong product.<br> `6` - Paid purchase not needed right now, will repurchase in the future.';
                    enum: [1, 2, 3, 4, 5, 6];
                    type: 'integer';
                  };
                  type: {
                    description: 'Plan [type](https://marketplace.zoom.us/docs/api-reference/other-references/plans).';
                    type: 'string';
                  };
                };
                type: 'object';
              };
            };
          };
        };
        responses: {
          '200': {
            description: "**Error Code:** `200`<br>\nYou cannot cancel plan for a sub account that is under a free plan.<br>\nYou cannot perform this action because you do not have a Zoom Phone subscription for this account.<br>\nFree trial and VIP accounts can not cancel plans of a sub account. Contact the Zoom Support team for details.<br>\nYou don't have a plan subscription for ({planCode}) yet..";
          };
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `204`<br>\nPlan cancelled successfully. ';
          };
          '300': {
            description: '**Error Code:** `300`<br>\nPlan type is required.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br> \n**Error Code:** `2100`<br>\nThis sub account is on self pay mode.<br>\nYou cannot make cancellation requests for a bundle plan. Contact the Zoom Support team for details.<br>\nMaster accounts with bulk licenses cannot provision, update, or cancel plans for sub accounts using APIs, please use the billing portal or contact Support.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `1001`<br>\nUser does not exist.<br>\n**Error Code:** `2001`<br> \nAccount does not exist: {subAccountId}.\n\n';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Cancel additional plans';
        tags: ['Billing'];
      };
    };
    '/accounts/{accountId}/plans/base': {
      put: {
        description: "Update a base plan of a sub account. \n\nThis API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' subscriptions. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>\n**Scopes:** `billing:master`<br><br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>\n**Prerequisites:**<br>\n* The sub account must have a Pro or a higher plan.\n ";
        operationId: 'accountPlanBaseUpdate';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                description: 'Account base plan object.';
                properties: {
                  hosts: {
                    description: 'Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.';
                    type: 'integer';
                  };
                  type: {
                    description: 'Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                    type: 'string';
                  };
                };
                required: ['type', 'hosts'];
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                description: 'Account base plan object.';
                properties: {
                  hosts: {
                    description: 'Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.';
                    type: 'integer';
                  };
                  type: {
                    description: 'Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                    type: 'string';
                  };
                };
                required: ['type', 'hosts'];
                type: 'object';
              };
            };
          };
          required: true;
          'x-examples': {
            'application/json': {
              hosts: 'integer';
              type: 'string';
            };
          };
        };
        responses: {
          '200': {
            description: "**Error Code:** `200`\nFree trial and VIP account can't update sub plan.<br>\nYou do not have a subscription yet.<br>\n\n";
          };
          '204': {
            description: '**HTTPS Status Code:** `204`<br>\nBase plan updated.';
          };
          '300': {
            description: '**Error Code:** `300`<br>\nInsufficient number of hosts for business plan type.<br>\nInsufficient number of hosts for education plan type.<br>\nPlan types do not match, oldPlanType: {oldPlanType} newPlanType: {newPlanType}.<br>\n';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `2100`<br> \nThis sub account is on self pay mode.<br>\nCannot makes updates when account is subscribed to a bundle plan.<br>\nThis account is not under a free trial plan.<br>\nThe account currently has {0} paid users, you should change the user type to basic and reduce the number of paid users before performing this action.<br>\nMaster accounts with bulk licenses cannot provision, update, or cancel plans for sub accounts using APIs, please use the billing portal or contact Support.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `1001`<br>\nUser does not exist.\n**Error Code:** `2001`<br>\nAccount does not exist: {subAccountId}.';
          };
        };
        summary: 'Update a base plan';
        tags: ['Billing'];
      };
    };
    '/accounts/{accountId}/plans/base/status': {
      patch: {
        description: "[Cancel a base plan](https://support.zoom.us/hc/en-us/articles/203634215-How-Do-I-Cancel-My-Subscription-) for a sub account.\n\nThis API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' subscriptions. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>\n\n**Scopes**: `billing:master`<br> \n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>\n**Prerequisites:**<br>\n* The sub account must have a Pro or a higher plan.\n ";
        operationId: 'accountPlanBaseDelete';
        parameters: [
          {
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  action: {
                    description: 'The action that needs to be taken for this sub account. Value must be set to "cancel".';
                    type: 'string';
                  };
                  comment: {
                    description: 'Additional comments about the cancellation decision.';
                    type: 'string';
                  };
                  reason: {
                    description: 'The reason for the cancellation of plan. Reason options:<br>`1` - I am no longer working remote.<br>`2` - I had challenges getting the support I needed.<br>`3` - Features in the Basic Free Plan are sufficient.<br>`4` - The expense is too high.<br>`5` - I purchased the wrong product.<br> `6` - Paid purchase not needed right now, will repurchase in the future.';
                    enum: [1, 2, 3, 4, 5, 6];
                    type: 'integer';
                  };
                };
                required: ['action'];
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  action: {
                    description: 'The action that needs to be taken for this sub account. Value must be set to "cancel".';
                    type: 'string';
                  };
                  comment: {
                    description: 'Additional comments about the cancellation decision.';
                    type: 'string';
                  };
                  reason: {
                    description: 'The reason for the cancellation of plan. Reason options:<br>`1` - I am no longer working remote.<br>`2` - I had challenges getting the support I needed.<br>`3` - Features in the Basic Free Plan are sufficient.<br>`4` - The expense is too high.<br>`5` - I purchased the wrong product.<br> `6` - Paid purchase not needed right now, will repurchase in the future.';
                    enum: [1, 2, 3, 4, 5, 6];
                    type: 'integer';
                  };
                };
                required: ['action'];
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              action: 'cancel';
              comment: 'Amazing plan but I do not need it right now.';
              reason: 2;
            };
          };
        };
        responses: {
          '200': {
            description: "**Error Code:** `200`<br>\nCannot cancel plan for a sub account which is under free plan.<br>\nYou don’t have a major subscription yet.<br>\nYou should first cancel all additional subscriptions.<br>\nFree trial and VIP accounts can not cancel plans of a sub account. Contact the Zoom Support team for details.<br>\nYou don't have a plan subscription for ({planCode}) yet.";
          };
          '204': {
            content: {
              'application/json': {
                schema: {
                  properties: {};
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {};
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `204`<br>\nPlan cancelled successfully. ';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `2100`<br>\nThis sub account is paid by self.<br>\nYou cannot make cancellation requests for a bundle plan. Contact the Zoom Support team for details.<br>\nMaster accounts with bulk licenses cannot provision, update, or cancel plans for sub accounts using APIs, please use the billing portal or contact Support.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `1001`<br>User does not exist. <br>\n**Error Code:** `2001`<br>This account does not exist or does not belong to this master account.\n\n\n';
          };
        };
        summary: 'Cancel a base plan';
        tags: ['Billing'];
      };
    };
    '/accounts/{accountId}/plans/usage': {
      get: {
        description: 'Get information on usage of [plans](https://marketplace.zoom.us/docs/api-reference/other-references/plans) of an account. This API supports regular accounts as well as master and sub accounts. To get plan usage of a regular account, use the `account:read:admin` scope and provide “me” as the value of the  `accountId` path parameter.To get plan usage of a master account, provide the keyword "me" as the value of the `accountId` path parameter and use the `billing:master` scope. To get plan usage of a sub account, provide the actual account Id of the sub account as the value of the `accountId` path parameter and use the `billing:master` scope. \n\n**Prerequisite**:<br>\nAccount type: master account on a paid Pro, Business or Enterprise plan.<br>\n**Scope:** `billing:master` for master and sub accounts. `account:read:admin` for regular Zoom accounts.<br>\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`';
        operationId: 'getPlanUsage';
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      plan_base: {
                        hosts: 2;
                        type: 'monthly';
                        usage: 1;
                      };
                      plan_large_meeting: [
                        {
                          hosts: 1;
                          type: 'large500_monthly';
                          usage: 1;
                        },
                      ];
                      plan_recording: {
                        free_storage: '3 GB';
                        free_storage_usage: '0';
                        plan_storage: '0';
                        plan_storage_exceed: '0';
                        plan_storage_usage: '0';
                      };
                      plan_webinar: [
                        {
                          hosts: 1;
                          type: 'webinar100_monthly';
                          usage: 1;
                        },
                      ];
                      plan_zoom_rooms: {
                        hosts: 1;
                        type: 'zroom_monthly';
                        usage: 0;
                      };
                    };
                  };
                };
                schema: {
                  properties: {
                    plan_base: {
                      description: 'The base plan subscribed for the sub account.';
                      items: {
                        properties: {
                          hosts: {
                            description: 'Number of hosts under the base plan.';
                            type: 'integer';
                          };
                          type: {
                            description: 'Type of the base plan. ';
                            type: 'string';
                          };
                          usage: {
                            description: 'Total number of usage of this plan.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_large_meeting: {
                      description: 'Large Meeting Plan';
                      items: {
                        properties: {
                          hosts: {
                            description: 'Number of hosts in this plan. ';
                            type: 'integer';
                          };
                          type: {
                            description: 'Large meeting Plan Type';
                            type: 'string';
                          };
                          usage: {
                            description: 'Number of usages for this account plan.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_recording: {
                      description: 'Recording Plan';
                      properties: {
                        free_storage: {
                          description: 'Recording free storage.';
                          type: 'string';
                        };
                        free_storage_usage: {
                          description: 'Amount of free storage used.';
                          type: 'string';
                        };
                        plan_storage: {
                          description: 'Recording plan storage.';
                          type: 'string';
                        };
                        plan_storage_exceed: {
                          type: 'string';
                        };
                        plan_storage_usage: {
                          description: 'Recording storage usage.';
                          type: 'string';
                        };
                        type: {
                          description: 'Recording plan type.';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    plan_united: {
                      description: '[Zoom United](https://zoom.us/pricing/zoom-bundles) plan.';
                      properties: {
                        hosts: {
                          description: 'Number of licenses purchased.';
                          type: 'integer';
                        };
                        name: {
                          description: 'Name of the plan.';
                          type: 'string';
                        };
                        type: {
                          description: 'Plan [type](https://marketplace.zoom.us/docs/api-reference/other-references/plans#zoom-united-plans).';
                          type: 'string';
                        };
                        usage: {
                          description: 'Number of licenses that are already being used.';
                          type: 'integer';
                        };
                      };
                      type: 'object';
                    };
                    plan_webinar: {
                      description: 'Webinar Plan';
                      items: {
                        properties: {
                          hosts: {
                            description: 'The number of hosts in this plan.';
                            type: 'integer';
                          };
                          type: {
                            description: 'The type of Webinar plan for the account.';
                            type: 'string';
                          };
                          usage: {
                            description: 'The total number of plan usage.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_zoom_rooms: {
                      description: 'Zoom Rooms Plan';
                      items: {
                        properties: {
                          hosts: {
                            description: 'The number of hosts in this plan.';
                            type: 'integer';
                          };
                          type: {
                            description: 'THe plan type for Zoom room plan.';
                            type: 'string';
                          };
                          usage: {
                            description: 'The total number of usage for this plan.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    plan_base: {
                      description: 'The base plan subscribed for the sub account.';
                      items: {
                        properties: {
                          hosts: {
                            description: 'Number of hosts under the base plan.';
                            type: 'integer';
                          };
                          type: {
                            description: 'Type of the base plan. ';
                            type: 'string';
                          };
                          usage: {
                            description: 'Total number of usage of this plan.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_large_meeting: {
                      description: 'Large Meeting Plan';
                      items: {
                        properties: {
                          hosts: {
                            description: 'Number of hosts in this plan. ';
                            type: 'integer';
                          };
                          type: {
                            description: 'Large meeting Plan Type';
                            type: 'string';
                          };
                          usage: {
                            description: 'Number of usages for this account plan.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_recording: {
                      description: 'Recording Plan';
                      properties: {
                        free_storage: {
                          description: 'Recording free storage.';
                          type: 'string';
                        };
                        free_storage_usage: {
                          description: 'Amount of free storage used.';
                          type: 'string';
                        };
                        plan_storage: {
                          description: 'Recording plan storage.';
                          type: 'string';
                        };
                        plan_storage_exceed: {
                          type: 'string';
                        };
                        plan_storage_usage: {
                          description: 'Recording storage usage.';
                          type: 'string';
                        };
                        type: {
                          description: 'Recording plan type.';
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    plan_united: {
                      description: '[Zoom United](https://zoom.us/pricing/zoom-bundles) plan.';
                      properties: {
                        hosts: {
                          description: 'Number of licenses purchased.';
                          type: 'integer';
                        };
                        name: {
                          description: 'Name of the plan.';
                          type: 'string';
                        };
                        type: {
                          description: 'Plan [type](https://marketplace.zoom.us/docs/api-reference/other-references/plans#zoom-united-plans).';
                          type: 'string';
                        };
                        usage: {
                          description: 'Number of licenses that are already being used.';
                          type: 'integer';
                        };
                      };
                      type: 'object';
                    };
                    plan_webinar: {
                      description: 'Webinar Plan';
                      items: {
                        properties: {
                          hosts: {
                            description: 'The number of hosts in this plan.';
                            type: 'integer';
                          };
                          type: {
                            description: 'The type of Webinar plan for the account.';
                            type: 'string';
                          };
                          usage: {
                            description: 'The total number of plan usage.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    plan_zoom_rooms: {
                      description: 'Zoom Rooms Plan';
                      items: {
                        properties: {
                          hosts: {
                            description: 'The number of hosts in this plan.';
                            type: 'integer';
                          };
                          type: {
                            description: 'THe plan type for Zoom room plan.';
                            type: 'string';
                          };
                          usage: {
                            description: 'The total number of usage for this plan.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200` <br>\nPlan Usage returned.<br>';
          };
          '400': {
            description: '**HTTP Status Code:** `400` <br>\n**Error Code:** `200` <br>\nOnly available for paid account.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Get plan usage';
        tags: ['Billing'];
      };
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
    };
    '/accounts/{accountId}/recordings': {
      get: {
        description: 'List [Cloud Recordings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-Recording) available on an Account.\n\n> To access a password protected cloud recording, add an "access_token" parameter to the download URL and provide [JWT](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app) as the value of the "access_token".\n<br>\n**Prerequisites**:<br>\n* A Pro or a higher paid plan with Cloud Recording option enabled.<br>\n**Scopes**: `recording:read:admin` or `account:read:admin`\n\nIf the scope `recording:read:admin` is used, the Account ID of the Account must be provided in the `accountId` path parameter to list recordings that belong to the Account. This scope only works for sub accounts. \n\nTo list recordings of a master account, the scope must be `account:read:admin` and the value of `accountId` should be `me`.<br>  **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>\n';
        operationId: 'getAccountCloudRecording';
        parameters: [
          {
            description: 'The number of records returned within a single API call.';
            in: 'query';
            name: 'page_size';
            schema: {
              default: 30;
              maximum: 300;
              type: 'integer';
            };
          },
          {
            description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
            in: 'query';
            name: 'next_page_token';
            schema: {
              type: 'string';
            };
          },
          {
            description: "The start date in UTC for the monthly range for which you would like to retrieve recordings. The maximum range can be a month. If no value is provided for this field, the default will be current date. For example, if you make the API request on June 30, 2020, without providing the “from” and “to” parameters, by default the value of 'from' field will be “2020-06-30” and the value of the 'to' field will be “2020-07-01”.";
            in: 'query';
            name: 'from';
            schema: {
              format: 'date-time';
              type: 'string';
            };
          },
          {
            description: 'The end date for the monthly range for which you would like to retrieve recordings. The maximum range can be a month.';
            in: 'query';
            name: 'to';
            schema: {
              format: 'date-time';
              type: 'string';
            };
          },
          {
            description: 'Unique identifier of the account.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      from: '2019-08-19';
                      meetings: [
                        {
                          account_id: 'lq8QK_AAAAAAAAA';
                          duration: 2;
                          host_email: 'thehostemail@somemail.com';
                          host_id: 'uLoABCDEF_qQGIsQ';
                          id: 101010101;
                          recording_count: 3;
                          recording_files: [
                            {
                              download_url: 'https://zoom.us/recording/download/abcdEFgkkkkk';
                              file_size: 26966;
                              file_type: 'M4A';
                              id: '2f6bbbb-0fd7-4691-af13-aaaaaa';
                              meeting_id: 'i9zq0MR8S/abcdef==';
                              play_url: 'https://zoomdev.us/recording/play/abcdEFgkkkkk';
                              recording_end: '2019-08-20T00:53:16Z';
                              recording_start: '2019-08-20T00:51:54Z';
                              recording_type: 'audio_only';
                              status: 'completed';
                            },
                            {
                              download_url: 'https://zoom.us/recording/download/JolGd4kUpBEo44Q31BVEXrGeCdbT4-MOAAAAA';
                              file_size: 37;
                              file_type: 'CHAT';
                              id: '39362666-0fd7-4691-af13-aaaaaa';
                              meeting_id: 'i9zq0MR8S/abcdef==';
                              play_url: 'https://zoom.us/recording/play/UpBEo44Q31BVEXrGeCdbT4-MOAAAAAAA';
                              recording_end: '2019-08-20T00:53:16Z';
                              recording_start: '2019-08-20T00:51:54Z';
                              recording_type: 'chat_file';
                              status: 'completed';
                            },
                            {
                              download_url: 'https://zoom.us/recording/download/5Y2YnU-56ZY4lEA5AAAABBBBBCCCCCDDDDD';
                              file_size: 101679;
                              file_type: 'MP4';
                              id: 'K809nk-014djkfsgf-00a98c13ec783';
                              meeting_id: 'i9zq0MR8S/abcdef==';
                              play_url: 'https://zoom.us/recording/play/5Y2YnU-56ZY4lEA5AAAABBBBBCCCCCDDDDD';
                              recording_end: '2019-08-20T00:53:16Z';
                              recording_start: '2019-08-20T00:51:54Z';
                              recording_type: 'shared_screen_with_speaker_view';
                              status: 'completed';
                            },
                          ];
                          share_url: 'https://zoom.us/recording/share/SBDDBJKsbjdAAAAA';
                          start_time: '2019-08-20T00:52:13Z';
                          timezone: 'America/Los_Angeles';
                          topic: 'MyTestMeeting';
                          total_size: 128682;
                          type: 2;
                          uuid: 'i9zq0MR8S/abcdef==';
                        },
                      ];
                      next_page_token: '';
                      page_size: 30;
                      to: '2019-08-20';
                    };
                  };
                };
                schema: {
                  properties: {
                    from: {
                      description: "The start date for the monthly range for which you would like to retrieve recordings. The maximum range can be a month. If no value is provided for this field, the default will be current date. For example, if you make the API request on June 30, 2020, without providing the “from” and “to” parameters, by default the value of 'from' field will be “2020-06-30” and the value of the 'to' field will be “2020-07-01”.";
                      format: 'date-time';
                      type: 'string';
                    };
                    meetings: {
                      description: 'Meetings Object';
                      items: {
                        properties: {
                          duration: {
                            description: 'The scheduled duration of the meeting.';
                            type: 'integer';
                          };
                          host_id: {
                            description: 'User ID of the user who is set as the host of the meeting.';
                            type: 'string';
                          };
                          id: {
                            description: 'Meeting ID - Unique Identifier of a meeting, also known as Meeting Number.';
                            type: 'string';
                          };
                          recording_count: {
                            description: 'The total number of recordings retrieved from the account.';
                            type: 'integer';
                          };
                          recording_files: {
                            description: 'Recording files object';
                            items: {
                              properties: {
                                download_url: {
                                  description: 'The URL using which the recording can be downloaded';
                                  type: 'string';
                                };
                                file_size: {
                                  description: 'The size of the recording file in bytes.';
                                  type: 'number';
                                };
                                file_type: {
                                  description: 'The recording file type. The value of this field could be one of the following:<br>\n* `MP4`: Video file of the recording.<br>\n* `M4A` Audio-only file of the recording.<br>\n* `TB`: Timestamp file of the recording in JSON format.<br> \n* `TRANSCRIPT`: Transcription file of the recording in VTT format.<br> \n* `CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>\n* `CC`: File containing closed captions of the recording in VTT file format.<br>\n* `CSV`: File containing polling data in csv format.\n\nA recording file object with file type of either `CC` or `TB` **does not have** the following properties:<br>\n\t`id`, `status`, `file_size`, `recording_type`, and `play_url`.';
                                  enum: ['MP4', 'M4A', 'CHAT', 'TRANSCRIPT', 'CC', 'CSV', 'TB'];
                                  type: 'string';
                                };
                                id: {
                                  description: 'Recording ID. Identifier for the recording.';
                                  type: 'string';
                                };
                                meeting_id: {
                                  description: 'Universally unique identifier of the meeting instance that was being recorded.';
                                  type: 'string';
                                };
                                play_url: {
                                  description: 'The URL using which recording can be played.';
                                  type: 'string';
                                };
                                recording_end: {
                                  description: 'The date and time at which the recording ended.';
                                  type: 'string';
                                };
                                recording_start: {
                                  description: 'The date and time at which the recording started.';
                                  type: 'string';
                                };
                                recording_type: {
                                  description: 'The recording type. The value of this field can be one of the following:<br>\n* `shared_screen_with_speaker_view(CC)`\n* `shared_screen_with_speaker_view`\n* `shared_screen_with_gallery_view`\n* `shared_screen`\n* `active_speaker`\n* `gallery_view`\n* `audio_only`\n* `audio_transcript`\n* `chat_file`\n* `host_video`\n* `closed_caption`\n* `poll`\n* `timeline`\n* `thumbnail`\n';
                                  enum: [
                                    'shared_screen_with_speaker_view(CC)',
                                    'shared_screen_with_speaker_view',
                                    'shared_screen_with_gallery_view',
                                    'active_speaker',
                                    'gallery_view',
                                    'shared_screen',
                                    'audio_only',
                                    'audio_transcript',
                                    'chat_file',
                                    'poll',
                                    'host_video',
                                    'closed_caption',
                                    'timeline',
                                    'thumbnail',
                                  ];
                                  type: 'string';
                                };
                                status: {
                                  description: 'The status of the recording, either `completed` or `processing`. ';
                                  enum: ['completed', 'processing'];
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                          start_time: {
                            description: 'The date and time at which the meeting started.';
                            format: 'date-time';
                            type: 'string';
                          };
                          topic: {
                            description: 'Meeting topic.';
                            type: 'string';
                          };
                          total_size: {
                            description: 'The total size of the meeting in bytes.';
                            type: 'integer';
                          };
                          uuid: {
                            description: 'Universally Unique Identifier of a meeting instance. Each meeting instance will have its own meeting UUID.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      description: 'The number of records returned within a single API call.';
                      type: 'integer';
                    };
                    to: {
                      description: 'The end date for the monthly range for which you would like to retrieve recordings. The maximum range can be a month.';
                      format: 'date-time';
                      type: 'string';
                    };
                    total_records: {
                      description: 'Total number of records found for this request across all pages.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    from: {
                      description: "The start date for the monthly range for which you would like to retrieve recordings. The maximum range can be a month. If no value is provided for this field, the default will be current date. For example, if you make the API request on June 30, 2020, without providing the “from” and “to” parameters, by default the value of 'from' field will be “2020-06-30” and the value of the 'to' field will be “2020-07-01”.";
                      format: 'date-time';
                      type: 'string';
                    };
                    meetings: {
                      description: 'Meetings Object';
                      items: {
                        properties: {
                          duration: {
                            description: 'The scheduled duration of the meeting.';
                            type: 'integer';
                          };
                          host_id: {
                            description: 'User ID of the user who is set as the host of the meeting.';
                            type: 'string';
                          };
                          id: {
                            description: 'Meeting ID - Unique Identifier of a meeting, also known as Meeting Number.';
                            type: 'string';
                          };
                          recording_count: {
                            description: 'The total number of recordings retrieved from the account.';
                            type: 'integer';
                          };
                          recording_files: {
                            description: 'Recording files object';
                            items: {
                              properties: {
                                download_url: {
                                  description: 'The URL using which the recording can be downloaded';
                                  type: 'string';
                                };
                                file_size: {
                                  description: 'The size of the recording file in bytes.';
                                  type: 'number';
                                };
                                file_type: {
                                  description: 'The recording file type. The value of this field could be one of the following:<br>\n* `MP4`: Video file of the recording.<br>\n* `M4A` Audio-only file of the recording.<br>\n* `TB`: Timestamp file of the recording in JSON format.<br> \n* `TRANSCRIPT`: Transcription file of the recording in VTT format.<br> \n* `CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>\n* `CC`: File containing closed captions of the recording in VTT file format.<br>\n* `CSV`: File containing polling data in csv format.\n\nA recording file object with file type of either `CC` or `TB` **does not have** the following properties:<br>\n\t`id`, `status`, `file_size`, `recording_type`, and `play_url`.';
                                  enum: ['MP4', 'M4A', 'CHAT', 'TRANSCRIPT', 'CC', 'CSV', 'TB'];
                                  type: 'string';
                                };
                                id: {
                                  description: 'Recording ID. Identifier for the recording.';
                                  type: 'string';
                                };
                                meeting_id: {
                                  description: 'Universally unique identifier of the meeting instance that was being recorded.';
                                  type: 'string';
                                };
                                play_url: {
                                  description: 'The URL using which recording can be played.';
                                  type: 'string';
                                };
                                recording_end: {
                                  description: 'The date and time at which the recording ended.';
                                  type: 'string';
                                };
                                recording_start: {
                                  description: 'The date and time at which the recording started.';
                                  type: 'string';
                                };
                                recording_type: {
                                  description: 'The recording type. The value of this field can be one of the following:<br>\n* `shared_screen_with_speaker_view(CC)`\n* `shared_screen_with_speaker_view`\n* `shared_screen_with_gallery_view`\n* `shared_screen`\n* `active_speaker`\n* `gallery_view`\n* `audio_only`\n* `audio_transcript`\n* `chat_file`\n* `host_video`\n* `closed_caption`\n* `poll`\n* `timeline`\n* `thumbnail`\n';
                                  enum: [
                                    'shared_screen_with_speaker_view(CC)',
                                    'shared_screen_with_speaker_view',
                                    'shared_screen_with_gallery_view',
                                    'active_speaker',
                                    'gallery_view',
                                    'shared_screen',
                                    'audio_only',
                                    'audio_transcript',
                                    'chat_file',
                                    'poll',
                                    'host_video',
                                    'closed_caption',
                                    'timeline',
                                    'thumbnail',
                                  ];
                                  type: 'string';
                                };
                                status: {
                                  description: 'The status of the recording, either `completed` or `processing`. ';
                                  enum: ['completed', 'processing'];
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                          start_time: {
                            description: 'The date and time at which the meeting started.';
                            format: 'date-time';
                            type: 'string';
                          };
                          topic: {
                            description: 'Meeting topic.';
                            type: 'string';
                          };
                          total_size: {
                            description: 'The total size of the meeting in bytes.';
                            type: 'integer';
                          };
                          uuid: {
                            description: 'Universally Unique Identifier of a meeting instance. Each meeting instance will have its own meeting UUID.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      description: 'The number of records returned within a single API call.';
                      type: 'integer';
                    };
                    to: {
                      description: 'The end date for the monthly range for which you would like to retrieve recordings. The maximum range can be a month.';
                      format: 'date-time';
                      type: 'string';
                    };
                    total_records: {
                      description: 'Total number of records found for this request across all pages.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**Response Error Code:** `200` <br>\nOnly available for Paid account.\n\n**HTTP Status Code:** `200` <br>\nRecording(s) listed successfully.\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `400` <br>\nAccount not found.\n\n**Response Error Code:** `2001`<br>\nThis account does not exist or does not belong to you: {accountId}.\n';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'List recordings of an account';
        tags: ['Cloud Recording'];
      };
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
    };
    '/accounts/{accountId}/settings': {
      get: {
        description: 'Get the settings of an account.<br>\nTo get the settings of a master account, use `me` as the value for the `accountId` path parameter.<br><br>\n **Prerequisites**:\n * The account must be a paid account.<br>\n**Scopes**: `account:read:admin`\n<br> \n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`';
        operationId: 'accountSettings';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            allowEmptyValue: true;
            description: '`meeting_authentication`: Use this query parameter to view [meeting authentication configuration](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) applied on the account.<br>`recording_authentication`: Use this query parameter to view [recording authentication configuration](https://support.zoom.us/hc/en-us/articles/360037756671-Authentication-Profiles-for-Cloud-Recordings) applied on the account.<br>`security`: Use this query parameter to view security settings such as password requirements for user login, two factor authentication etc., applied on the account.<br>\n`meeting_security`: Use this query parameter to view meeting security settings applied on the account.<br>';
            in: 'query';
            name: 'option';
            schema: {
              enum: ['meeting_authentication', 'recording_authentication'];
              type: 'string';
            };
          },
          {
            description: 'Provide the name of the field by which you would like to filter the response. For example, if you provide "host_video" as the value of this field, you will get a response similar to the following:<br>\n{\n    "schedule_meeting": {\n        "host_video": false\n    }\n}\n<br>You can provide multiple values by separating them with commas(example: "host_video,participant_video”).';
            in: 'query';
            name: 'custom_query_fields';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      email_notification: {
                        alternative_host_reminder: 'boolean';
                        cancel_meeting_reminder: 'boolean';
                        cloud_recording_avaliable_reminder: 'boolean';
                        jbh_reminder: 'boolean';
                        low_host_count_reminder: 'boolean';
                        schedule_for_reminder: 'boolean';
                      };
                      feature: {
                        meeting_capacity: 'integer';
                      };
                      in_meeting: {
                        alert_guest_join: 'boolean';
                        allow_show_zoom_windows: 'boolean';
                        annotation: 'boolean';
                        anonymous_question_answer: 'boolean';
                        attendee_on_hold: 'boolean';
                        auto_answer: 'boolean';
                        auto_saving_chat: 'boolean';
                        breakout_room: 'boolean';
                        chat: 'boolean';
                        closed_caption: 'boolean';
                        co_host: 'boolean';
                        dscp_audio: 'integer';
                        dscp_marking: 'boolean';
                        dscp_video: 'integer';
                        e2e_encryption: 'boolean';
                        entry_exit_chime: 'string';
                        far_end_camera_control: 'boolean';
                        feedback: 'boolean';
                        group_hd: 'boolean';
                        original_audio: 'boolean';
                        p2p_connetion: 'boolean';
                        p2p_ports: 'boolean';
                        polling: 'boolean';
                        ports_range: 'string';
                        post_meeting_feedback: 'boolean';
                        private_chat: 'boolean';
                        record_play_own_voice: 'boolean';
                        remote_control: 'boolean';
                        screen_sharing: 'boolean';
                        sending_default_email_invites: 'boolean';
                        show_meeting_control_toolbar: 'boolean';
                        stereo_audio: 'boolean';
                        use_html_format_email: 'boolean';
                        virtual_background: 'boolean';
                        watermark: 'boolean';
                        webinar_question_answer: 'boolean';
                        whiteboard: 'boolean';
                      };
                      integration: {
                        box: 'boolean';
                        dropbox: 'boolean';
                        google_calendar: 'boolean';
                        google_drive: 'boolean';
                        kubi: 'boolean';
                        microsoft_one_drive: 'boolean';
                      };
                      recording: {
                        account_user_access_recording: 'boolean';
                        auto_delete_cmr: 'boolean';
                        auto_delete_cmr_days: 'integer';
                        auto_recording: 'string';
                        cloud_recording: 'boolean';
                        cloud_recording_download: 'boolean';
                        cloud_recording_download_host: 'boolean';
                        local_recording: 'boolean';
                        record_audio_file: 'boolean';
                        record_gallery_view: 'boolean';
                        record_speaker_view: 'boolean';
                        recording_audio_transcript: 'boolean';
                        save_chat_text: 'boolean';
                        show_timestamp: 'boolean';
                      };
                      schedule_meeting: {
                        audio_type: 'string';
                        enforce_login: 'boolean';
                        enforce_login_domains: 'string';
                        enforce_login_with_domains: 'boolean';
                        force_pmi_jbh_password: 'boolean';
                        host_video: 'boolean';
                        join_before_host: 'boolean';
                        not_store_meeting_topic: 'boolean';
                        participant_video: 'boolean';
                        require_password_for_instant_meetings: 'boolean';
                        require_password_for_pmi_meetings: 'string';
                        require_password_for_scheduled_meetings: 'boolean';
                        require_password_for_scheduling_new_meetings: 'boolean';
                        use_pmi_for_instant_meetings: 'boolean';
                        use_pmi_for_scheduled_meetings: 'boolean';
                      };
                      security: {
                        admin_change_name_pic: 'boolean';
                        hide_billing_info: 'boolean';
                        import_photos_from_devices: 'boolean';
                      };
                      telephony: {
                        audio_conference_info: 'string';
                        third_party_audio: 'boolean';
                      };
                      tsp: {
                        call_out: 'boolean';
                        call_out_countries: ['string'];
                        display_toll_free_numbers: 'boolean';
                        show_international_numbers_link: 'boolean';
                      };
                      zoom_rooms: {
                        auto_start_stop_scheduled_meetings: 'boolean';
                        cmr_for_instant_meeting: 'boolean';
                        force_private_meeting: 'boolean';
                        hide_host_information: 'boolean';
                        list_meetings_with_calendar: 'boolean';
                        start_airplay_manually: 'boolean';
                        ultrasonic: 'boolean';
                        upcoming_meeting_alert: 'boolean';
                        weekly_system_restart: 'boolean';
                        zr_post_meeting_feedback: 'boolean';
                      };
                    };
                  };
                };
                schema: {
                  oneOf: [
                    {
                      properties: {
                        email_notification: {
                          description: 'Account Settings: Notification.';
                          properties: {
                            alternative_host_reminder: {
                              description: 'Notify when an alternative host is set or removed from a meeting.';
                              type: 'boolean';
                            };
                            cancel_meeting_reminder: {
                              description: 'Notify the host and participants when a meeting is cancelled.';
                              type: 'boolean';
                            };
                            cloud_recording_avaliable_reminder: {
                              description: 'Notify host when cloud recording is available.';
                              type: 'boolean';
                            };
                            jbh_reminder: {
                              description: 'Notify the host when participants join the meeting before them.';
                              type: 'boolean';
                            };
                            low_host_count_reminder: {
                              description: 'Notify user when host licenses are running low.';
                              type: 'boolean';
                            };
                            schedule_for_reminder: {
                              description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        feature: {
                          description: 'Account Settings: Feature.';
                          properties: {
                            meeting_capacity: {
                              description: 'Set the maximum number of participants a host can have in a single meeting.';
                              type: 'integer';
                            };
                          };
                          type: 'object';
                        };
                        in_meeting: {
                          description: 'Account Settings: In Meeting.';
                          properties: {
                            alert_guest_join: {
                              description: 'Identify guest participants in a meeting or webinar.';
                              type: 'boolean';
                            };
                            allow_live_streaming: {
                              description: 'Allow live streaming.';
                              type: 'boolean';
                            };
                            allow_participants_to_rename: {
                              description: 'If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.\n';
                              type: 'boolean';
                            };
                            allow_show_zoom_windows: {
                              description: 'Show the Zoom desktop application when sharing screens. ';
                              type: 'boolean';
                            };
                            annotation: {
                              description: 'Allow participants to use annotation tools to add information to shared screens.';
                              type: 'boolean';
                            };
                            anonymous_question_answer: {
                              description: 'Allow an anonymous Q&A in a webinar.';
                              type: 'boolean';
                            };
                            attendee_on_hold: {
                              default: false;
                              description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
                              type: 'boolean';
                            };
                            auto_answer: {
                              description: 'Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.';
                              type: 'boolean';
                            };
                            auto_saving_chat: {
                              description: 'Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.';
                              type: 'boolean';
                            };
                            breakout_room: {
                              description: 'Allow host to split meeting participants into separate, smaller rooms.';
                              type: 'boolean';
                            };
                            chat: {
                              description: 'Allow meeting participants to send a message that is visible to all participants.';
                              type: 'boolean';
                            };
                            closed_caption: {
                              description: 'Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions. ';
                              type: 'boolean';
                            };
                            co_host: {
                              description: 'Allow the host to add co-hosts.';
                              type: 'boolean';
                            };
                            custom_data_center_regions: {
                              description: 'If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.';
                              type: 'boolean';
                            };
                            custom_live_streaming_service: {
                              description: 'Custom live streaming.';
                              type: 'boolean';
                            };
                            custom_service_instructions: {
                              description: 'Custom service instructions.';
                              type: 'string';
                            };
                            data_center_regions: {
                              description: 'If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).\n';
                              enum: ['EU', 'HK', 'AU', 'IN', 'TY', 'CN', 'US', 'CA'];
                              items: {
                                type: 'string';
                              };
                              type: 'array';
                            };
                            dscp_audio: {
                              description: 'DSCP audio.';
                              maximum: 63;
                              minimum: 1;
                              type: 'integer';
                            };
                            dscp_marking: {
                              description: 'DSCP marking.';
                              type: 'boolean';
                            };
                            dscp_video: {
                              description: 'DSCP video.';
                              maximum: 63;
                              minimum: 1;
                              type: 'integer';
                            };
                            e2e_encryption: {
                              description: 'Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).';
                              type: 'boolean';
                            };
                            entry_exit_chime: {
                              description: 'Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.';
                              enum: ['host', 'all', 'none'];
                              type: 'string';
                              'x-enum-descriptions': [
                                'Heard by host only',
                                'Heard by host and all attendees',
                                'Disable',
                              ];
                            };
                            far_end_camera_control: {
                              description: 'Allow another user to take control of your camera during a meeting.';
                              type: 'boolean';
                            };
                            feedback: {
                              description: 'Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.';
                              type: 'boolean';
                            };
                            file_transfer: {
                              description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.';
                              type: 'boolean';
                            };
                            group_hd: {
                              description: 'Activate higher quality video for host and participants.\nPlease note: This will use more bandwidth.';
                              type: 'boolean';
                            };
                            meeting_reactions: {
                              description: 'Enable or disable meeting reactions. <br>\n`true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>\n`false`: Do not enable meeting reactions.';
                              type: 'boolean';
                            };
                            original_audio: {
                              description: 'Allow users to select original sound in their client settings.';
                              type: 'boolean';
                            };
                            p2p_connetion: {
                              description: 'Peer to peer connection while only two people are in a meeting.';
                              type: 'boolean';
                            };
                            p2p_ports: {
                              description: 'Peer to peer listening ports range.';
                              type: 'boolean';
                            };
                            polling: {
                              description: 'Add "Polls" to the meeting controls.';
                              type: 'boolean';
                            };
                            ports_range: {
                              default: '';
                              description: 'The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.';
                              type: 'string';
                            };
                            post_meeting_feedback: {
                              description: 'Display a thumbs up or down survey at the end of each meeting.';
                              type: 'boolean';
                            };
                            private_chat: {
                              description: 'Allow a meeting participant to send a private message to another participant.';
                              type: 'boolean';
                            };
                            record_play_own_voice: {
                              description: 'Record and play their own voice.';
                              type: 'boolean';
                            };
                            remote_control: {
                              description: 'Allow users to request remote control.';
                              type: 'boolean';
                            };
                            request_permission_to_unmute: {
                              description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.';
                              type: 'boolean';
                            };
                            screen_sharing: {
                              description: 'Allow screen sharing.';
                              type: 'boolean';
                            };
                            sending_default_email_invites: {
                              description: 'Only show the default email when sending email invites.';
                              type: 'boolean';
                            };
                            show_a_join_from_your_browser_link: {
                              description: 'If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.';
                              type: 'boolean';
                            };
                            show_meeting_control_toolbar: {
                              description: 'Always show the meeting control toolbar.';
                              type: 'boolean';
                            };
                            stereo_audio: {
                              description: 'Allow users to select stereo audio in their client settings.';
                              type: 'boolean';
                            };
                            use_html_format_email: {
                              description: 'Use HTML formatted email for the Outlook plugin.';
                              type: 'boolean';
                            };
                            virtual_background: {
                              description: 'Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.';
                              type: 'boolean';
                            };
                            virtual_background_settings: {
                              description: 'Settings to manage virtual background.';
                              properties: {
                                allow_upload_custom: {
                                  description: 'Allow users to upload custom backgrounds.';
                                  type: 'boolean';
                                };
                                allow_videos: {
                                  description: 'Allow use of videos for virtual backgrounds.';
                                  type: 'boolean';
                                };
                                enable: {
                                  description: 'Enable virtual background.';
                                  type: 'boolean';
                                };
                                files: {
                                  items: {
                                    properties: {
                                      id: {
                                        description: 'Unique identifier of the file.';
                                        type: 'string';
                                      };
                                      is_default: {
                                        description: 'Indicates whether or not this file is the default virtual background file.';
                                        type: 'boolean';
                                      };
                                      name: {
                                        description: 'File name.';
                                        type: 'string';
                                      };
                                      size: {
                                        description: 'File size.';
                                        type: 'string';
                                      };
                                      type: {
                                        description: 'File type.';
                                        type: 'string';
                                      };
                                    };
                                    type: 'object';
                                  };
                                  type: 'array';
                                };
                              };
                              type: 'object';
                            };
                            watermark: {
                              description: 'Add a watermark when viewing a shared screen.';
                              type: 'boolean';
                            };
                            webinar_question_answer: {
                              description: 'Allow a Q&A in a webinar.';
                              type: 'boolean';
                            };
                            whiteboard: {
                              description: 'Allow participants to share a whiteboard that includes annotation tools.';
                              type: 'boolean';
                            };
                            who_can_share_screen: {
                              description: 'Indicates who can share their screen or content during meetings. The value can be one of the following: <br>\n`host`: Only host can share the screen.<br>\n`all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
                              enum: ['host', 'all'];
                              type: 'string';
                            };
                            who_can_share_screen_when_someone_is_sharing: {
                              description: 'Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>\n`host`: Only a host can share the screen when someone else is sharing.<br>\n`all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
                              enum: ['host', 'all'];
                              type: 'string';
                            };
                            workplace_by_facebook: {
                              description: 'Workplace by facebook.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        integration: {
                          description: 'Account Settings: Integration.';
                          properties: {
                            box: {
                              description: 'Enable users who join a meeting from their mobile device to share content from their Box account.';
                              type: 'boolean';
                            };
                            dropbox: {
                              description: 'Enable users who join a meeting from their mobile device to share content from their Dropbox account.';
                              type: 'boolean';
                            };
                            google_calendar: {
                              description: 'Enable meetings to be scheduled using Google Calendar.';
                              type: 'boolean';
                            };
                            google_drive: {
                              description: 'Enable users who join a meeting from their mobile device to share content from their Google Drive.';
                              type: 'boolean';
                            };
                            kubi: {
                              description: 'Enable users to control a connected Kubi device from within a Zoom meeting.';
                              type: 'boolean';
                            };
                            microsoft_one_drive: {
                              description: 'Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        profile: {
                          properties: {
                            recording_storage_location: {
                              properties: {
                                allowed_values: {
                                  description: 'Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.\n\nProvide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.';
                                  items: {
                                    type: 'string';
                                  };
                                  type: 'array';
                                };
                                value: {
                                  description: 'Abbreviated country code.';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                          };
                          title: 'Profile';
                          type: 'object';
                        };
                        recording: {
                          description: 'Account Settings: Recording.';
                          properties: {
                            account_user_access_recording: {
                              description: 'Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.';
                              type: 'boolean';
                            };
                            allow_recovery_deleted_cloud_recordings: {
                              description: 'Allow recovery of deleted cloud recordings from trash. \nIf the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period. ';
                              type: 'boolean';
                            };
                            archive: {
                              description: '[Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.';
                              properties: {
                                enable: {
                                  description: 'Enable the archiving feature.';
                                  type: 'boolean';
                                };
                                settings: {
                                  properties: {
                                    audio_file: {
                                      description: 'Include in-meeting and/or in-webinar audio in the archive.';
                                      type: 'boolean';
                                    };
                                    cc_transcript_file: {
                                      description: 'Include closed caption or transcript in the archive.';
                                      type: 'boolean';
                                    };
                                    chat_file: {
                                      description: 'Include in-meeting chat in the archive.';
                                      type: 'boolean';
                                    };
                                    chat_with_sender_email: {
                                      description: 'Include user email in in-meeting chat file.';
                                      type: 'boolean';
                                    };
                                    video_file: {
                                      description: 'Include in-meeting and/or in-webinar video in the archive.';
                                      type: 'boolean';
                                    };
                                  };
                                  type: 'object';
                                };
                                type: {
                                  description: 'Archive types:\n\n* `1`: Only meetings are archived.<br>\n* `2`: Only webinars are archived.<br>\n* `3`: Both meetings and webinars are archived.';
                                  enum: [1, 2, 3];
                                  type: 'integer';
                                };
                              };
                              type: 'object';
                            };
                            auto_delete_cmr: {
                              description: 'Allow Zoom to permanantly delete recordings automatically after a specified number of days.';
                              type: 'boolean';
                            };
                            auto_delete_cmr_days: {
                              description: "When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.";
                              type: 'integer';
                            };
                            auto_recording: {
                              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
                              enum: ['local', 'cloud', 'none'];
                              type: 'string';
                              'x-enum-descriptions': ['Record on local', 'Record on cloud', 'Disabled'];
                            };
                            cloud_recording: {
                              description: 'Allow hosts to record and save the meeting in the cloud.';
                              type: 'boolean';
                            };
                            cloud_recording_download: {
                              description: 'Cloud recording downloads.';
                              type: 'boolean';
                            };
                            cloud_recording_download_host: {
                              description: 'Only the host can download cloud recordings.';
                              type: 'boolean';
                            };
                            host_delete_cloud_recording: {
                              description: 'If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.\n';
                              type: 'boolean';
                            };
                            ip_address_access_control: {
                              description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
                              properties: {
                                enable: {
                                  description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                                  type: 'boolean';
                                };
                                ip_addresses_or_ranges: {
                                  description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            local_recording: {
                              description: 'Allow hosts and participants to record the meeting using a local file.';
                              type: 'boolean';
                            };
                            prevent_host_access_recording: {
                              description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n';
                              type: 'boolean';
                            };
                            record_audio_file: {
                              description: 'Record an audio only file.';
                              type: 'boolean';
                            };
                            record_gallery_view: {
                              description: 'Record the gallery view with a shared screen.';
                              type: 'boolean';
                            };
                            record_speaker_view: {
                              description: 'Record the active speaker with a shared screen.';
                              type: 'boolean';
                            };
                            recording_audio_transcript: {
                              description: 'Automatically transcribe the audio of the meeting or webinar to the cloud.';
                              type: 'boolean';
                            };
                            recording_disclaimer: {
                              description: 'Show a disclaimer to participants before a recording starts\n';
                              type: 'boolean';
                            };
                            recording_password_requirement: {
                              description: 'This object represents the minimum password requirements set for recordings via Account Recording Settings.';
                              properties: {
                                have_letter: {
                                  description: 'Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).';
                                  type: 'boolean';
                                };
                                have_number: {
                                  description: 'Indicates whether or not password must contain at least one number(1, 2, 3..).';
                                  type: 'boolean';
                                };
                                have_special_character: {
                                  description: 'Indicates whether or not password must contain at least one special character(!, @, #..).';
                                  type: 'boolean';
                                };
                                length: {
                                  description: 'Minimum required length for the password.';
                                  maximum: 10;
                                  type: 'integer';
                                };
                                only_allow_numeric: {
                                  description: 'Indicates whether or not password must contain only numeric characters.';
                                  type: 'boolean';
                                };
                              };
                              type: 'object';
                            };
                            required_password_for_existing_cloud_recordings: {
                              description: 'Require a passcode to access existing cloud recordings.';
                              type: 'boolean';
                            };
                            save_chat_text: {
                              description: 'Save the chat text from the meeting.';
                              type: 'boolean';
                            };
                            show_timestamp: {
                              description: 'Add a timestamp to the recording.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        schedule_meeting: {
                          description: 'Account Settings: Schedule Meeting.';
                          properties: {
                            audio_type: {
                              default: 'both';
                              description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.';
                              enum: ['both', 'telephony', 'voip', 'thirdParty'];
                              type: 'string';
                              'x-enum-descriptions': [
                                'Telephony and VoIP',
                                'Audio PSTN telephony only',
                                'VoIP only',
                                '3rd party audio conference',
                              ];
                            };
                            enforce_login: {
                              description: 'Only Zoom users who are signed in can join meetings.';
                              type: 'boolean';
                            };
                            enforce_login_domains: {
                              description: 'Only signed in users with a specified domain can join the meeting. ';
                              type: 'string';
                            };
                            enforce_login_with_domains: {
                              description: 'Only signed in users with a specific domain can join meetings.';
                              type: 'boolean';
                            };
                            force_pmi_jbh_password: {
                              description: 'Require a password for Personal Meetings if attendees can join before host.';
                              type: 'boolean';
                            };
                            host_video: {
                              description: 'Start meetings with the host video on.';
                              type: 'boolean';
                            };
                            join_before_host: {
                              description: 'Allow participants to join the meeting before the host arrives.';
                              type: 'boolean';
                            };
                            meeting_password_requirement: {
                              description: 'Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                              properties: {
                                consecutive_characters_length: {
                                  enum: [0, 4, 5, 6, 7, 8];
                                  type: 'integer';
                                };
                                have_letter: {
                                  description: 'If set to `true`, the password must contain at least 1 letter (such as a,b,c...).\n';
                                  type: 'boolean';
                                };
                                have_number: {
                                  description: 'If set to `true`, the password must contain at least 1 number (such as 1,2,3...).';
                                  type: 'boolean';
                                };
                                have_special_character: {
                                  description: 'If set to `true`, the password must have at least 1 special character (!,@,#...).';
                                  type: 'boolean';
                                };
                                have_upper_and_lower_characters: {
                                  description: 'If set to `true`, the password must include both uppercase and lowercase characters.';
                                  type: 'boolean';
                                };
                                length: {
                                  description: 'The minimum length that the meeting/webinar password needs to have.';
                                  type: 'integer';
                                };
                                only_allow_numeric: {
                                  description: 'If set to `true`, the password must only contain numbers and no other characters.';
                                  type: 'boolean';
                                };
                                weak_enhance_detection: {
                                  description: 'If set to `true`, users will be informed if the provided password is weak.';
                                  type: 'boolean';
                                };
                              };
                              type: 'object';
                            };
                            not_store_meeting_topic: {
                              description: 'Always display "Zoom Meeting" as the meeting topic.';
                              type: 'boolean';
                            };
                            participant_video: {
                              description: 'Start meetings with the participant video on. Participants can change this setting during the meeting.';
                              type: 'boolean';
                            };
                            personal_meeting: {
                              description: 'Personal Meeting Setting.<br><br>\n`true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.\nFor Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n';
                              type: 'boolean';
                            };
                            require_password_for_instant_meetings: {
                              description: 'Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
                              type: 'boolean';
                            };
                            require_password_for_pmi_meetings: {
                              description: 'Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
                              enum: ['jbh_only', 'all', 'none'];
                              type: 'string';
                              'x-enum-descriptions': [
                                'Only meetings with Join Before Host enabled',
                                'All meetings using PMI',
                                'Disabled',
                              ];
                            };
                            require_password_for_scheduled_meetings: {
                              description: 'Require a password for meetings which have already been scheduled\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduling_new_meetings: {
                              description: 'Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                              type: 'boolean';
                            };
                            use_pmi_for_instant_meetings: {
                              description: 'Use Personal Meeting ID (PMI) when starting an instant meeting\n';
                              type: 'boolean';
                            };
                            use_pmi_for_scheduled_meetings: {
                              description: 'Use Personal Meeting ID (PMI) when scheduling a meeting\n';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        security: {
                          description: '[Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.';
                          properties: {
                            admin_change_name_pic: {
                              description: "Only account administrators can change a user's username and picture.";
                              type: 'boolean';
                            };
                            hide_billing_info: {
                              description: 'Hide billing information.';
                              type: 'boolean';
                            };
                            import_photos_from_devices: {
                              description: 'Allow users to import photos from a photo library on a  device.';
                              type: 'boolean';
                            };
                            password_requirement: {
                              description: "This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password. ";
                              properties: {
                                consecutive_characters_length: {
                                  description: '\nSpecify the max length of consecutive characters(abcde...) that can be used in a password.\nIf you set the value of this field to `0`, no restriction will be applied on consecutive characters. \n\nIf you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.\n\nThe max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).';
                                  type: 'integer';
                                };
                                have_special_character: {
                                  description: 'If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).';
                                  type: 'boolean';
                                };
                                minimum_password_length: {
                                  description: 'Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.';
                                  maximum: 14;
                                  minimum: 8;
                                  type: 'integer';
                                };
                                weak_enhance_detection: {
                                  description: 'If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.';
                                  type: 'boolean';
                                };
                              };
                              type: 'object';
                            };
                            sign_again_period_for_inactivity_on_client: {
                              description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`45`: 45 minutes<br>\n`60`: 60 minutes<br>\n`90`: 90 minutes<br>\n`120`: 120 minutes\n';
                              type: 'integer';
                            };
                            sign_again_period_for_inactivity_on_web: {
                              description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`60`: 60 minutes<br>\n`120`: 120 minutes\n\n    \n\n';
                              type: 'integer';
                            };
                            sign_in_with_two_factor_auth: {
                              description: 'Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:\n`all`: Two factor authentication will be enabled for all users in the account.<br>\n`none`: Two factor authentication is disabled.<br>\n`group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>\n`role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the\n`sign_in_with_two_factor_auth_roles` field.\n';
                              enum: ['all', 'group', 'role', 'none'];
                              type: 'string';
                            };
                            sign_in_with_two_factor_auth_groups: {
                              description: 'This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`';
                              items: {
                                type: 'string';
                              };
                              type: 'array';
                            };
                            sign_in_with_two_factor_auth_roles: {
                              description: 'This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.';
                              items: {
                                type: 'string';
                              };
                              type: 'array';
                            };
                          };
                          type: 'object';
                        };
                        telephony: {
                          description: 'Account Settings: Telephony.';
                          properties: {
                            audio_conference_info: {
                              description: 'Third party audio conference info.';
                              type: 'string';
                            };
                            telephony_regions: {
                              description: 'Indicates where most of the participants call into or call from duriing a meeting.';
                              properties: {
                                allowed_values: {
                                  description: 'Telephony region options provided by Zoom to select from.';
                                  items: {
                                    type: 'string';
                                  };
                                  type: 'array';
                                };
                                selection_values: {
                                  description: 'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.';
                                  items: {
                                    type: 'string';
                                  };
                                  type: 'array';
                                };
                              };
                              type: 'object';
                            };
                            third_party_audio: {
                              description: 'Users can join the meeting using the existing third party audio configuration.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        tsp: {
                          description: 'Account Settings: TSP.';
                          properties: {
                            call_out: {
                              description: 'Call Out';
                              type: 'boolean';
                            };
                            call_out_countries: {
                              description: 'Call Out Countries/Regions';
                              items: {};
                              type: 'array';
                            };
                            display_toll_free_numbers: {
                              description: 'Display toll-free numbers';
                              type: 'boolean';
                            };
                            show_international_numbers_link: {
                              description: 'Show international numbers link on the invitation email';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        zoom_rooms: {
                          description: 'Account Settings: Zoom Rooms.';
                          properties: {
                            auto_start_stop_scheduled_meetings: {
                              description: 'Automatic start and stop for scheduled meetings.';
                              type: 'boolean';
                            };
                            cmr_for_instant_meeting: {
                              description: 'Cloud recording for instant meetings.';
                              type: 'boolean';
                            };
                            force_private_meeting: {
                              description: 'Shift all meetings to private.';
                              type: 'boolean';
                            };
                            hide_host_information: {
                              description: 'Hide host and meeting ID from private meetings.';
                              type: 'boolean';
                            };
                            list_meetings_with_calendar: {
                              description: 'Display meeting list with calendar integration.';
                              type: 'boolean';
                            };
                            start_airplay_manually: {
                              description: 'Start AirPlay service manually.';
                              type: 'boolean';
                            };
                            ultrasonic: {
                              description: 'Automatic direct sharing using an ultrasonic proximity signal.';
                              type: 'boolean';
                            };
                            upcoming_meeting_alert: {
                              description: 'Upcoming meeting alert.';
                              type: 'boolean';
                            };
                            weekly_system_restart: {
                              description: 'Weekly system restart.';
                              type: 'boolean';
                            };
                            zr_post_meeting_feedback: {
                              description: 'Zoom Room post meeting feedback.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                      };
                      title: 'Account settings';
                      type: 'object';
                    },
                    {
                      oneOf: [
                        {
                          properties: {
                            authentication_options: {
                              description: 'Meeting Authentication Options';
                              items: {
                                properties: {
                                  default_option: {
                                    description: 'Authentication default option';
                                    type: 'boolean';
                                  };
                                  domains: {
                                    description: 'Authentication domians';
                                    type: 'string';
                                  };
                                  id: {
                                    description: 'Authentication id';
                                    type: 'string';
                                  };
                                  name: {
                                    description: 'Authentication name';
                                    type: 'string';
                                  };
                                  type: {
                                    description: ' Authentication type. Specify one of the following authentication types for the authentication profile:<br>\n * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>\n * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.';
                                    enum: [
                                      'enforce_login',
                                      'enforce_login_with_same_account',
                                      'enforce_login_with_domains',
                                    ];
                                    type: 'string';
                                  };
                                  visible: {
                                    description: 'Authentication visible';
                                    type: 'boolean';
                                  };
                                };
                                type: 'object';
                              };
                              type: 'array';
                            };
                            meeting_authentication: {
                              description: 'Only authenticated users can join meetings';
                              type: 'boolean';
                            };
                          };
                        },
                        {
                          properties: {
                            authentication_options: {
                              items: {
                                properties: {
                                  default_option: {
                                    description: 'Authentication default option';
                                    type: 'boolean';
                                  };
                                  domains: {
                                    description: 'Authentication domians';
                                    type: 'string';
                                  };
                                  id: {
                                    description: 'Authentication id';
                                    type: 'string';
                                  };
                                  name: {
                                    description: 'Authentication name';
                                    type: 'string';
                                  };
                                  type: {
                                    description: 'Authentication type';
                                    enum: ['internally', 'enforce_login', 'enforce_login_with_domains'];
                                    type: 'string';
                                  };
                                  visible: {
                                    description: 'Authentication visible';
                                    type: 'boolean';
                                  };
                                };
                                type: 'object';
                              };
                              type: 'array';
                            };
                            recording_authentication: {
                              description: 'Only authenticated users can view cloud recordings';
                              type: 'boolean';
                            };
                          };
                        },
                      ];
                      title: 'AccountSettingsAuthentication';
                      type: 'object';
                    },
                    {
                      description: '[Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.';
                      properties: {
                        admin_change_name_pic: {
                          description: "Only account administrators can change a user's username and picture.";
                          type: 'boolean';
                        };
                        hide_billing_info: {
                          description: 'Hide billing information.';
                          type: 'boolean';
                        };
                        import_photos_from_devices: {
                          description: 'Allow users to import photos from a photo library on a  device.';
                          type: 'boolean';
                        };
                        password_requirement: {
                          description: "This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password. ";
                          properties: {
                            consecutive_characters_length: {
                              description: '\nSpecify the max length of consecutive characters(abcde...) that can be used in a password.\nIf you set the value of this field to `0`, no restriction will be applied on consecutive characters. \n\nIf you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.\n\nThe max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).';
                              type: 'integer';
                            };
                            have_special_character: {
                              description: 'If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).';
                              type: 'boolean';
                            };
                            minimum_password_length: {
                              description: 'Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.';
                              maximum: 14;
                              minimum: 8;
                              type: 'integer';
                            };
                            weak_enhance_detection: {
                              description: 'If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        sign_again_period_for_inactivity_on_client: {
                          description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`45`: 45 minutes<br>\n`60`: 60 minutes<br>\n`90`: 90 minutes<br>\n`120`: 120 minutes\n';
                          type: 'integer';
                        };
                        sign_again_period_for_inactivity_on_web: {
                          description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`60`: 60 minutes<br>\n`120`: 120 minutes\n\n    \n\n';
                          type: 'integer';
                        };
                        sign_in_with_two_factor_auth: {
                          description: 'Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:\n`all`: Two factor authentication will be enabled for all users in the account.<br>\n`none`: Two factor authentication is disabled.<br>\n`group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>\n`role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the\n`sign_in_with_two_factor_auth_roles` field.\n';
                          enum: ['all', 'group', 'role', 'none'];
                          type: 'string';
                        };
                        sign_in_with_two_factor_auth_groups: {
                          description: 'This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`';
                          items: {
                            type: 'string';
                          };
                          type: 'array';
                        };
                        sign_in_with_two_factor_auth_roles: {
                          description: 'This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.';
                          items: {
                            type: 'string';
                          };
                          type: 'array';
                        };
                      };
                      type: 'object';
                    },
                    {
                      properties: {
                        meeting_security: {
                          properties: {
                            auto_security: {
                              description: '`true`: Require that all meetings are secured with at least one security option.\n\nThis setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).';
                              type: 'boolean';
                            };
                            embed_password_in_join_link: {
                              description: 'If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.\n';
                              type: 'boolean';
                            };
                            encryption_type: {
                              description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                              enum: ['enhanced_encryption', 'e2ee'];
                              type: 'string';
                            };
                            end_to_end_encrypted_meetings: {
                              description: 'Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.';
                              type: 'boolean';
                            };
                            meeting_password: {
                              description: 'If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.';
                              type: 'boolean';
                            };
                            meeting_password_requirement: {
                              description: 'Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                              properties: {
                                consecutive_characters_length: {
                                  enum: [0, 4, 5, 6, 7, 8];
                                  type: 'integer';
                                };
                                have_letter: {
                                  description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                                  type: 'boolean';
                                };
                                have_number: {
                                  description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                                  type: 'boolean';
                                };
                                have_special_character: {
                                  description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                                  type: 'boolean';
                                };
                                have_upper_and_lower_characters: {
                                  description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                                  type: 'boolean';
                                };
                                length: {
                                  description: 'The minimum length that the meeting/webinar passcode needs to have.';
                                  type: 'integer';
                                };
                                only_allow_numeric: {
                                  description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                                  type: 'boolean';
                                };
                                weak_enhance_detection: {
                                  description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                                  type: 'boolean';
                                };
                              };
                              type: 'object';
                            };
                            phone_password: {
                              description: 'Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.';
                              type: 'boolean';
                            };
                            pmi_password: {
                              description: 'If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduled_meeting: {
                              description: 'Require a passcode for meetings which have already been scheduled.\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduled_webinar: {
                              description: 'Require a passcode for webinars which have already been scheduled.\n';
                              type: 'boolean';
                            };
                            waiting_room: {
                              description: 'When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.\n';
                              type: 'boolean';
                            };
                            waiting_room_settings: {
                              description: 'Specify the settings to be applied if waiting room is enabled.';
                              properties: {
                                participants_to_place_in_waiting_room: {
                                  description: '\n\nSpecify who should be admitted to the waiting room. The value of this field can be one of the following:<br>\n`0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in ';
                                  enum: [0, 1, 2];
                                  type: 'integer';
                                };
                                users_who_can_admit_participants_from_waiting_room: {
                                  description: 'Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>\n`0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).\n\n\n';
                                  type: 'integer';
                                };
                                whitelisted_domains_for_waiting_room: {
                                  description: 'If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            webinar_password: {
                              description: 'If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.\n';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                      };
                      title: 'Meeting/Webinar Security Settings';
                      type: 'object';
                    },
                  ];
                };
              };
              'application/xml': {
                schema: {
                  oneOf: [
                    {
                      properties: {
                        email_notification: {
                          description: 'Account Settings: Notification.';
                          properties: {
                            alternative_host_reminder: {
                              description: 'Notify when an alternative host is set or removed from a meeting.';
                              type: 'boolean';
                            };
                            cancel_meeting_reminder: {
                              description: 'Notify the host and participants when a meeting is cancelled.';
                              type: 'boolean';
                            };
                            cloud_recording_avaliable_reminder: {
                              description: 'Notify host when cloud recording is available.';
                              type: 'boolean';
                            };
                            jbh_reminder: {
                              description: 'Notify the host when participants join the meeting before them.';
                              type: 'boolean';
                            };
                            low_host_count_reminder: {
                              description: 'Notify user when host licenses are running low.';
                              type: 'boolean';
                            };
                            schedule_for_reminder: {
                              description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        feature: {
                          description: 'Account Settings: Feature.';
                          properties: {
                            meeting_capacity: {
                              description: 'Set the maximum number of participants a host can have in a single meeting.';
                              type: 'integer';
                            };
                          };
                          type: 'object';
                        };
                        in_meeting: {
                          description: 'Account Settings: In Meeting.';
                          properties: {
                            alert_guest_join: {
                              description: 'Identify guest participants in a meeting or webinar.';
                              type: 'boolean';
                            };
                            allow_live_streaming: {
                              description: 'Allow live streaming.';
                              type: 'boolean';
                            };
                            allow_participants_to_rename: {
                              description: 'If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.\n';
                              type: 'boolean';
                            };
                            allow_show_zoom_windows: {
                              description: 'Show the Zoom desktop application when sharing screens. ';
                              type: 'boolean';
                            };
                            annotation: {
                              description: 'Allow participants to use annotation tools to add information to shared screens.';
                              type: 'boolean';
                            };
                            anonymous_question_answer: {
                              description: 'Allow an anonymous Q&A in a webinar.';
                              type: 'boolean';
                            };
                            attendee_on_hold: {
                              default: false;
                              description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
                              type: 'boolean';
                            };
                            auto_answer: {
                              description: 'Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.';
                              type: 'boolean';
                            };
                            auto_saving_chat: {
                              description: 'Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.';
                              type: 'boolean';
                            };
                            breakout_room: {
                              description: 'Allow host to split meeting participants into separate, smaller rooms.';
                              type: 'boolean';
                            };
                            chat: {
                              description: 'Allow meeting participants to send a message that is visible to all participants.';
                              type: 'boolean';
                            };
                            closed_caption: {
                              description: 'Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions. ';
                              type: 'boolean';
                            };
                            co_host: {
                              description: 'Allow the host to add co-hosts.';
                              type: 'boolean';
                            };
                            custom_data_center_regions: {
                              description: 'If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.';
                              type: 'boolean';
                            };
                            custom_live_streaming_service: {
                              description: 'Custom live streaming.';
                              type: 'boolean';
                            };
                            custom_service_instructions: {
                              description: 'Custom service instructions.';
                              type: 'string';
                            };
                            data_center_regions: {
                              description: 'If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).\n';
                              enum: ['EU', 'HK', 'AU', 'IN', 'TY', 'CN', 'US', 'CA'];
                              items: {
                                type: 'string';
                              };
                              type: 'array';
                            };
                            dscp_audio: {
                              description: 'DSCP audio.';
                              maximum: 63;
                              minimum: 1;
                              type: 'integer';
                            };
                            dscp_marking: {
                              description: 'DSCP marking.';
                              type: 'boolean';
                            };
                            dscp_video: {
                              description: 'DSCP video.';
                              maximum: 63;
                              minimum: 1;
                              type: 'integer';
                            };
                            e2e_encryption: {
                              description: 'Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).';
                              type: 'boolean';
                            };
                            entry_exit_chime: {
                              description: 'Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.';
                              enum: ['host', 'all', 'none'];
                              type: 'string';
                              'x-enum-descriptions': [
                                'Heard by host only',
                                'Heard by host and all attendees',
                                'Disable',
                              ];
                            };
                            far_end_camera_control: {
                              description: 'Allow another user to take control of your camera during a meeting.';
                              type: 'boolean';
                            };
                            feedback: {
                              description: 'Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.';
                              type: 'boolean';
                            };
                            file_transfer: {
                              description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.';
                              type: 'boolean';
                            };
                            group_hd: {
                              description: 'Activate higher quality video for host and participants.\nPlease note: This will use more bandwidth.';
                              type: 'boolean';
                            };
                            meeting_reactions: {
                              description: 'Enable or disable meeting reactions. <br>\n`true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>\n`false`: Do not enable meeting reactions.';
                              type: 'boolean';
                            };
                            original_audio: {
                              description: 'Allow users to select original sound in their client settings.';
                              type: 'boolean';
                            };
                            p2p_connetion: {
                              description: 'Peer to peer connection while only two people are in a meeting.';
                              type: 'boolean';
                            };
                            p2p_ports: {
                              description: 'Peer to peer listening ports range.';
                              type: 'boolean';
                            };
                            polling: {
                              description: 'Add "Polls" to the meeting controls.';
                              type: 'boolean';
                            };
                            ports_range: {
                              default: '';
                              description: 'The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.';
                              type: 'string';
                            };
                            post_meeting_feedback: {
                              description: 'Display a thumbs up or down survey at the end of each meeting.';
                              type: 'boolean';
                            };
                            private_chat: {
                              description: 'Allow a meeting participant to send a private message to another participant.';
                              type: 'boolean';
                            };
                            record_play_own_voice: {
                              description: 'Record and play their own voice.';
                              type: 'boolean';
                            };
                            remote_control: {
                              description: 'Allow users to request remote control.';
                              type: 'boolean';
                            };
                            request_permission_to_unmute: {
                              description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.';
                              type: 'boolean';
                            };
                            screen_sharing: {
                              description: 'Allow screen sharing.';
                              type: 'boolean';
                            };
                            sending_default_email_invites: {
                              description: 'Only show the default email when sending email invites.';
                              type: 'boolean';
                            };
                            show_a_join_from_your_browser_link: {
                              description: 'If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.';
                              type: 'boolean';
                            };
                            show_meeting_control_toolbar: {
                              description: 'Always show the meeting control toolbar.';
                              type: 'boolean';
                            };
                            stereo_audio: {
                              description: 'Allow users to select stereo audio in their client settings.';
                              type: 'boolean';
                            };
                            use_html_format_email: {
                              description: 'Use HTML formatted email for the Outlook plugin.';
                              type: 'boolean';
                            };
                            virtual_background: {
                              description: 'Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.';
                              type: 'boolean';
                            };
                            virtual_background_settings: {
                              description: 'Settings to manage virtual background.';
                              properties: {
                                allow_upload_custom: {
                                  description: 'Allow users to upload custom backgrounds.';
                                  type: 'boolean';
                                };
                                allow_videos: {
                                  description: 'Allow use of videos for virtual backgrounds.';
                                  type: 'boolean';
                                };
                                enable: {
                                  description: 'Enable virtual background.';
                                  type: 'boolean';
                                };
                                files: {
                                  items: {
                                    properties: {
                                      id: {
                                        description: 'Unique identifier of the file.';
                                        type: 'string';
                                      };
                                      is_default: {
                                        description: 'Indicates whether or not this file is the default virtual background file.';
                                        type: 'boolean';
                                      };
                                      name: {
                                        description: 'File name.';
                                        type: 'string';
                                      };
                                      size: {
                                        description: 'File size.';
                                        type: 'string';
                                      };
                                      type: {
                                        description: 'File type.';
                                        type: 'string';
                                      };
                                    };
                                    type: 'object';
                                  };
                                  type: 'array';
                                };
                              };
                              type: 'object';
                            };
                            watermark: {
                              description: 'Add a watermark when viewing a shared screen.';
                              type: 'boolean';
                            };
                            webinar_question_answer: {
                              description: 'Allow a Q&A in a webinar.';
                              type: 'boolean';
                            };
                            whiteboard: {
                              description: 'Allow participants to share a whiteboard that includes annotation tools.';
                              type: 'boolean';
                            };
                            who_can_share_screen: {
                              description: 'Indicates who can share their screen or content during meetings. The value can be one of the following: <br>\n`host`: Only host can share the screen.<br>\n`all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
                              enum: ['host', 'all'];
                              type: 'string';
                            };
                            who_can_share_screen_when_someone_is_sharing: {
                              description: 'Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>\n`host`: Only a host can share the screen when someone else is sharing.<br>\n`all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
                              enum: ['host', 'all'];
                              type: 'string';
                            };
                            workplace_by_facebook: {
                              description: 'Workplace by facebook.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        integration: {
                          description: 'Account Settings: Integration.';
                          properties: {
                            box: {
                              description: 'Enable users who join a meeting from their mobile device to share content from their Box account.';
                              type: 'boolean';
                            };
                            dropbox: {
                              description: 'Enable users who join a meeting from their mobile device to share content from their Dropbox account.';
                              type: 'boolean';
                            };
                            google_calendar: {
                              description: 'Enable meetings to be scheduled using Google Calendar.';
                              type: 'boolean';
                            };
                            google_drive: {
                              description: 'Enable users who join a meeting from their mobile device to share content from their Google Drive.';
                              type: 'boolean';
                            };
                            kubi: {
                              description: 'Enable users to control a connected Kubi device from within a Zoom meeting.';
                              type: 'boolean';
                            };
                            microsoft_one_drive: {
                              description: 'Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        profile: {
                          properties: {
                            recording_storage_location: {
                              properties: {
                                allowed_values: {
                                  description: 'Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.\n\nProvide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.';
                                  items: {
                                    type: 'string';
                                  };
                                  type: 'array';
                                };
                                value: {
                                  description: 'Abbreviated country code.';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                          };
                          title: 'Profile';
                          type: 'object';
                        };
                        recording: {
                          description: 'Account Settings: Recording.';
                          properties: {
                            account_user_access_recording: {
                              description: 'Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.';
                              type: 'boolean';
                            };
                            allow_recovery_deleted_cloud_recordings: {
                              description: 'Allow recovery of deleted cloud recordings from trash. \nIf the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period. ';
                              type: 'boolean';
                            };
                            archive: {
                              description: '[Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.';
                              properties: {
                                enable: {
                                  description: 'Enable the archiving feature.';
                                  type: 'boolean';
                                };
                                settings: {
                                  properties: {
                                    audio_file: {
                                      description: 'Include in-meeting and/or in-webinar audio in the archive.';
                                      type: 'boolean';
                                    };
                                    cc_transcript_file: {
                                      description: 'Include closed caption or transcript in the archive.';
                                      type: 'boolean';
                                    };
                                    chat_file: {
                                      description: 'Include in-meeting chat in the archive.';
                                      type: 'boolean';
                                    };
                                    chat_with_sender_email: {
                                      description: 'Include user email in in-meeting chat file.';
                                      type: 'boolean';
                                    };
                                    video_file: {
                                      description: 'Include in-meeting and/or in-webinar video in the archive.';
                                      type: 'boolean';
                                    };
                                  };
                                  type: 'object';
                                };
                                type: {
                                  description: 'Archive types:\n\n* `1`: Only meetings are archived.<br>\n* `2`: Only webinars are archived.<br>\n* `3`: Both meetings and webinars are archived.';
                                  enum: [1, 2, 3];
                                  type: 'integer';
                                };
                              };
                              type: 'object';
                            };
                            auto_delete_cmr: {
                              description: 'Allow Zoom to permanantly delete recordings automatically after a specified number of days.';
                              type: 'boolean';
                            };
                            auto_delete_cmr_days: {
                              description: "When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.";
                              type: 'integer';
                            };
                            auto_recording: {
                              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
                              enum: ['local', 'cloud', 'none'];
                              type: 'string';
                              'x-enum-descriptions': ['Record on local', 'Record on cloud', 'Disabled'];
                            };
                            cloud_recording: {
                              description: 'Allow hosts to record and save the meeting in the cloud.';
                              type: 'boolean';
                            };
                            cloud_recording_download: {
                              description: 'Cloud recording downloads.';
                              type: 'boolean';
                            };
                            cloud_recording_download_host: {
                              description: 'Only the host can download cloud recordings.';
                              type: 'boolean';
                            };
                            host_delete_cloud_recording: {
                              description: 'If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.\n';
                              type: 'boolean';
                            };
                            ip_address_access_control: {
                              description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
                              properties: {
                                enable: {
                                  description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                                  type: 'boolean';
                                };
                                ip_addresses_or_ranges: {
                                  description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            local_recording: {
                              description: 'Allow hosts and participants to record the meeting using a local file.';
                              type: 'boolean';
                            };
                            prevent_host_access_recording: {
                              description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n';
                              type: 'boolean';
                            };
                            record_audio_file: {
                              description: 'Record an audio only file.';
                              type: 'boolean';
                            };
                            record_gallery_view: {
                              description: 'Record the gallery view with a shared screen.';
                              type: 'boolean';
                            };
                            record_speaker_view: {
                              description: 'Record the active speaker with a shared screen.';
                              type: 'boolean';
                            };
                            recording_audio_transcript: {
                              description: 'Automatically transcribe the audio of the meeting or webinar to the cloud.';
                              type: 'boolean';
                            };
                            recording_disclaimer: {
                              description: 'Show a disclaimer to participants before a recording starts\n';
                              type: 'boolean';
                            };
                            recording_password_requirement: {
                              description: 'This object represents the minimum password requirements set for recordings via Account Recording Settings.';
                              properties: {
                                have_letter: {
                                  description: 'Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).';
                                  type: 'boolean';
                                };
                                have_number: {
                                  description: 'Indicates whether or not password must contain at least one number(1, 2, 3..).';
                                  type: 'boolean';
                                };
                                have_special_character: {
                                  description: 'Indicates whether or not password must contain at least one special character(!, @, #..).';
                                  type: 'boolean';
                                };
                                length: {
                                  description: 'Minimum required length for the password.';
                                  maximum: 10;
                                  type: 'integer';
                                };
                                only_allow_numeric: {
                                  description: 'Indicates whether or not password must contain only numeric characters.';
                                  type: 'boolean';
                                };
                              };
                              type: 'object';
                            };
                            required_password_for_existing_cloud_recordings: {
                              description: 'Require a passcode to access existing cloud recordings.';
                              type: 'boolean';
                            };
                            save_chat_text: {
                              description: 'Save the chat text from the meeting.';
                              type: 'boolean';
                            };
                            show_timestamp: {
                              description: 'Add a timestamp to the recording.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        schedule_meeting: {
                          description: 'Account Settings: Schedule Meeting.';
                          properties: {
                            audio_type: {
                              default: 'both';
                              description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.';
                              enum: ['both', 'telephony', 'voip', 'thirdParty'];
                              type: 'string';
                              'x-enum-descriptions': [
                                'Telephony and VoIP',
                                'Audio PSTN telephony only',
                                'VoIP only',
                                '3rd party audio conference',
                              ];
                            };
                            enforce_login: {
                              description: 'Only Zoom users who are signed in can join meetings.';
                              type: 'boolean';
                            };
                            enforce_login_domains: {
                              description: 'Only signed in users with a specified domain can join the meeting. ';
                              type: 'string';
                            };
                            enforce_login_with_domains: {
                              description: 'Only signed in users with a specific domain can join meetings.';
                              type: 'boolean';
                            };
                            force_pmi_jbh_password: {
                              description: 'Require a password for Personal Meetings if attendees can join before host.';
                              type: 'boolean';
                            };
                            host_video: {
                              description: 'Start meetings with the host video on.';
                              type: 'boolean';
                            };
                            join_before_host: {
                              description: 'Allow participants to join the meeting before the host arrives.';
                              type: 'boolean';
                            };
                            meeting_password_requirement: {
                              description: 'Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                              properties: {
                                consecutive_characters_length: {
                                  enum: [0, 4, 5, 6, 7, 8];
                                  type: 'integer';
                                };
                                have_letter: {
                                  description: 'If set to `true`, the password must contain at least 1 letter (such as a,b,c...).\n';
                                  type: 'boolean';
                                };
                                have_number: {
                                  description: 'If set to `true`, the password must contain at least 1 number (such as 1,2,3...).';
                                  type: 'boolean';
                                };
                                have_special_character: {
                                  description: 'If set to `true`, the password must have at least 1 special character (!,@,#...).';
                                  type: 'boolean';
                                };
                                have_upper_and_lower_characters: {
                                  description: 'If set to `true`, the password must include both uppercase and lowercase characters.';
                                  type: 'boolean';
                                };
                                length: {
                                  description: 'The minimum length that the meeting/webinar password needs to have.';
                                  type: 'integer';
                                };
                                only_allow_numeric: {
                                  description: 'If set to `true`, the password must only contain numbers and no other characters.';
                                  type: 'boolean';
                                };
                                weak_enhance_detection: {
                                  description: 'If set to `true`, users will be informed if the provided password is weak.';
                                  type: 'boolean';
                                };
                              };
                              type: 'object';
                            };
                            not_store_meeting_topic: {
                              description: 'Always display "Zoom Meeting" as the meeting topic.';
                              type: 'boolean';
                            };
                            participant_video: {
                              description: 'Start meetings with the participant video on. Participants can change this setting during the meeting.';
                              type: 'boolean';
                            };
                            personal_meeting: {
                              description: 'Personal Meeting Setting.<br><br>\n`true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.\nFor Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n';
                              type: 'boolean';
                            };
                            require_password_for_instant_meetings: {
                              description: 'Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
                              type: 'boolean';
                            };
                            require_password_for_pmi_meetings: {
                              description: 'Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
                              enum: ['jbh_only', 'all', 'none'];
                              type: 'string';
                              'x-enum-descriptions': [
                                'Only meetings with Join Before Host enabled',
                                'All meetings using PMI',
                                'Disabled',
                              ];
                            };
                            require_password_for_scheduled_meetings: {
                              description: 'Require a password for meetings which have already been scheduled\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduling_new_meetings: {
                              description: 'Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                              type: 'boolean';
                            };
                            use_pmi_for_instant_meetings: {
                              description: 'Use Personal Meeting ID (PMI) when starting an instant meeting\n';
                              type: 'boolean';
                            };
                            use_pmi_for_scheduled_meetings: {
                              description: 'Use Personal Meeting ID (PMI) when scheduling a meeting\n';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        security: {
                          description: '[Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.';
                          properties: {
                            admin_change_name_pic: {
                              description: "Only account administrators can change a user's username and picture.";
                              type: 'boolean';
                            };
                            hide_billing_info: {
                              description: 'Hide billing information.';
                              type: 'boolean';
                            };
                            import_photos_from_devices: {
                              description: 'Allow users to import photos from a photo library on a  device.';
                              type: 'boolean';
                            };
                            password_requirement: {
                              description: "This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password. ";
                              properties: {
                                consecutive_characters_length: {
                                  description: '\nSpecify the max length of consecutive characters(abcde...) that can be used in a password.\nIf you set the value of this field to `0`, no restriction will be applied on consecutive characters. \n\nIf you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.\n\nThe max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).';
                                  type: 'integer';
                                };
                                have_special_character: {
                                  description: 'If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).';
                                  type: 'boolean';
                                };
                                minimum_password_length: {
                                  description: 'Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.';
                                  maximum: 14;
                                  minimum: 8;
                                  type: 'integer';
                                };
                                weak_enhance_detection: {
                                  description: 'If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.';
                                  type: 'boolean';
                                };
                              };
                              type: 'object';
                            };
                            sign_again_period_for_inactivity_on_client: {
                              description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`45`: 45 minutes<br>\n`60`: 60 minutes<br>\n`90`: 90 minutes<br>\n`120`: 120 minutes\n';
                              type: 'integer';
                            };
                            sign_again_period_for_inactivity_on_web: {
                              description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`60`: 60 minutes<br>\n`120`: 120 minutes\n\n    \n\n';
                              type: 'integer';
                            };
                            sign_in_with_two_factor_auth: {
                              description: 'Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:\n`all`: Two factor authentication will be enabled for all users in the account.<br>\n`none`: Two factor authentication is disabled.<br>\n`group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>\n`role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the\n`sign_in_with_two_factor_auth_roles` field.\n';
                              enum: ['all', 'group', 'role', 'none'];
                              type: 'string';
                            };
                            sign_in_with_two_factor_auth_groups: {
                              description: 'This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`';
                              items: {
                                type: 'string';
                              };
                              type: 'array';
                            };
                            sign_in_with_two_factor_auth_roles: {
                              description: 'This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.';
                              items: {
                                type: 'string';
                              };
                              type: 'array';
                            };
                          };
                          type: 'object';
                        };
                        telephony: {
                          description: 'Account Settings: Telephony.';
                          properties: {
                            audio_conference_info: {
                              description: 'Third party audio conference info.';
                              type: 'string';
                            };
                            telephony_regions: {
                              description: 'Indicates where most of the participants call into or call from duriing a meeting.';
                              properties: {
                                allowed_values: {
                                  description: 'Telephony region options provided by Zoom to select from.';
                                  items: {
                                    type: 'string';
                                  };
                                  type: 'array';
                                };
                                selection_values: {
                                  description: 'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.';
                                  items: {
                                    type: 'string';
                                  };
                                  type: 'array';
                                };
                              };
                              type: 'object';
                            };
                            third_party_audio: {
                              description: 'Users can join the meeting using the existing third party audio configuration.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        tsp: {
                          description: 'Account Settings: TSP.';
                          properties: {
                            call_out: {
                              description: 'Call Out';
                              type: 'boolean';
                            };
                            call_out_countries: {
                              description: 'Call Out Countries/Regions';
                              items: {};
                              type: 'array';
                            };
                            display_toll_free_numbers: {
                              description: 'Display toll-free numbers';
                              type: 'boolean';
                            };
                            show_international_numbers_link: {
                              description: 'Show international numbers link on the invitation email';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        zoom_rooms: {
                          description: 'Account Settings: Zoom Rooms.';
                          properties: {
                            auto_start_stop_scheduled_meetings: {
                              description: 'Automatic start and stop for scheduled meetings.';
                              type: 'boolean';
                            };
                            cmr_for_instant_meeting: {
                              description: 'Cloud recording for instant meetings.';
                              type: 'boolean';
                            };
                            force_private_meeting: {
                              description: 'Shift all meetings to private.';
                              type: 'boolean';
                            };
                            hide_host_information: {
                              description: 'Hide host and meeting ID from private meetings.';
                              type: 'boolean';
                            };
                            list_meetings_with_calendar: {
                              description: 'Display meeting list with calendar integration.';
                              type: 'boolean';
                            };
                            start_airplay_manually: {
                              description: 'Start AirPlay service manually.';
                              type: 'boolean';
                            };
                            ultrasonic: {
                              description: 'Automatic direct sharing using an ultrasonic proximity signal.';
                              type: 'boolean';
                            };
                            upcoming_meeting_alert: {
                              description: 'Upcoming meeting alert.';
                              type: 'boolean';
                            };
                            weekly_system_restart: {
                              description: 'Weekly system restart.';
                              type: 'boolean';
                            };
                            zr_post_meeting_feedback: {
                              description: 'Zoom Room post meeting feedback.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                      };
                      title: 'Account settings';
                      type: 'object';
                    },
                    {
                      oneOf: [
                        {
                          properties: {
                            authentication_options: {
                              description: 'Meeting Authentication Options';
                              items: {
                                properties: {
                                  default_option: {
                                    description: 'Authentication default option';
                                    type: 'boolean';
                                  };
                                  domains: {
                                    description: 'Authentication domians';
                                    type: 'string';
                                  };
                                  id: {
                                    description: 'Authentication id';
                                    type: 'string';
                                  };
                                  name: {
                                    description: 'Authentication name';
                                    type: 'string';
                                  };
                                  type: {
                                    description: ' Authentication type. Specify one of the following authentication types for the authentication profile:<br>\n * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>\n * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.';
                                    enum: [
                                      'enforce_login',
                                      'enforce_login_with_same_account',
                                      'enforce_login_with_domains',
                                    ];
                                    type: 'string';
                                  };
                                  visible: {
                                    description: 'Authentication visible';
                                    type: 'boolean';
                                  };
                                };
                                type: 'object';
                              };
                              type: 'array';
                            };
                            meeting_authentication: {
                              description: 'Only authenticated users can join meetings';
                              type: 'boolean';
                            };
                          };
                        },
                        {
                          properties: {
                            authentication_options: {
                              items: {
                                properties: {
                                  default_option: {
                                    description: 'Authentication default option';
                                    type: 'boolean';
                                  };
                                  domains: {
                                    description: 'Authentication domians';
                                    type: 'string';
                                  };
                                  id: {
                                    description: 'Authentication id';
                                    type: 'string';
                                  };
                                  name: {
                                    description: 'Authentication name';
                                    type: 'string';
                                  };
                                  type: {
                                    description: 'Authentication type';
                                    enum: ['internally', 'enforce_login', 'enforce_login_with_domains'];
                                    type: 'string';
                                  };
                                  visible: {
                                    description: 'Authentication visible';
                                    type: 'boolean';
                                  };
                                };
                                type: 'object';
                              };
                              type: 'array';
                            };
                            recording_authentication: {
                              description: 'Only authenticated users can view cloud recordings';
                              type: 'boolean';
                            };
                          };
                        },
                      ];
                      title: 'AccountSettingsAuthentication';
                      type: 'object';
                    },
                    {
                      description: '[Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.';
                      properties: {
                        admin_change_name_pic: {
                          description: "Only account administrators can change a user's username and picture.";
                          type: 'boolean';
                        };
                        hide_billing_info: {
                          description: 'Hide billing information.';
                          type: 'boolean';
                        };
                        import_photos_from_devices: {
                          description: 'Allow users to import photos from a photo library on a  device.';
                          type: 'boolean';
                        };
                        password_requirement: {
                          description: "This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password. ";
                          properties: {
                            consecutive_characters_length: {
                              description: '\nSpecify the max length of consecutive characters(abcde...) that can be used in a password.\nIf you set the value of this field to `0`, no restriction will be applied on consecutive characters. \n\nIf you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.\n\nThe max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).';
                              type: 'integer';
                            };
                            have_special_character: {
                              description: 'If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).';
                              type: 'boolean';
                            };
                            minimum_password_length: {
                              description: 'Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.';
                              maximum: 14;
                              minimum: 8;
                              type: 'integer';
                            };
                            weak_enhance_detection: {
                              description: 'If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        sign_again_period_for_inactivity_on_client: {
                          description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`45`: 45 minutes<br>\n`60`: 60 minutes<br>\n`90`: 90 minutes<br>\n`120`: 120 minutes\n';
                          type: 'integer';
                        };
                        sign_again_period_for_inactivity_on_web: {
                          description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`60`: 60 minutes<br>\n`120`: 120 minutes\n\n    \n\n';
                          type: 'integer';
                        };
                        sign_in_with_two_factor_auth: {
                          description: 'Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:\n`all`: Two factor authentication will be enabled for all users in the account.<br>\n`none`: Two factor authentication is disabled.<br>\n`group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>\n`role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the\n`sign_in_with_two_factor_auth_roles` field.\n';
                          enum: ['all', 'group', 'role', 'none'];
                          type: 'string';
                        };
                        sign_in_with_two_factor_auth_groups: {
                          description: 'This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`';
                          items: {
                            type: 'string';
                          };
                          type: 'array';
                        };
                        sign_in_with_two_factor_auth_roles: {
                          description: 'This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.';
                          items: {
                            type: 'string';
                          };
                          type: 'array';
                        };
                      };
                      type: 'object';
                    },
                    {
                      properties: {
                        meeting_security: {
                          properties: {
                            auto_security: {
                              description: '`true`: Require that all meetings are secured with at least one security option.\n\nThis setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).';
                              type: 'boolean';
                            };
                            embed_password_in_join_link: {
                              description: 'If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.\n';
                              type: 'boolean';
                            };
                            encryption_type: {
                              description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                              enum: ['enhanced_encryption', 'e2ee'];
                              type: 'string';
                            };
                            end_to_end_encrypted_meetings: {
                              description: 'Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.';
                              type: 'boolean';
                            };
                            meeting_password: {
                              description: 'If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.';
                              type: 'boolean';
                            };
                            meeting_password_requirement: {
                              description: 'Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                              properties: {
                                consecutive_characters_length: {
                                  enum: [0, 4, 5, 6, 7, 8];
                                  type: 'integer';
                                };
                                have_letter: {
                                  description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                                  type: 'boolean';
                                };
                                have_number: {
                                  description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                                  type: 'boolean';
                                };
                                have_special_character: {
                                  description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                                  type: 'boolean';
                                };
                                have_upper_and_lower_characters: {
                                  description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                                  type: 'boolean';
                                };
                                length: {
                                  description: 'The minimum length that the meeting/webinar passcode needs to have.';
                                  type: 'integer';
                                };
                                only_allow_numeric: {
                                  description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                                  type: 'boolean';
                                };
                                weak_enhance_detection: {
                                  description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                                  type: 'boolean';
                                };
                              };
                              type: 'object';
                            };
                            phone_password: {
                              description: 'Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.';
                              type: 'boolean';
                            };
                            pmi_password: {
                              description: 'If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduled_meeting: {
                              description: 'Require a passcode for meetings which have already been scheduled.\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduled_webinar: {
                              description: 'Require a passcode for webinars which have already been scheduled.\n';
                              type: 'boolean';
                            };
                            waiting_room: {
                              description: 'When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.\n';
                              type: 'boolean';
                            };
                            waiting_room_settings: {
                              description: 'Specify the settings to be applied if waiting room is enabled.';
                              properties: {
                                participants_to_place_in_waiting_room: {
                                  description: '\n\nSpecify who should be admitted to the waiting room. The value of this field can be one of the following:<br>\n`0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in ';
                                  enum: [0, 1, 2];
                                  type: 'integer';
                                };
                                users_who_can_admit_participants_from_waiting_room: {
                                  description: 'Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>\n`0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).\n\n\n';
                                  type: 'integer';
                                };
                                whitelisted_domains_for_waiting_room: {
                                  description: 'If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            webinar_password: {
                              description: 'If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.\n';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                      };
                      title: 'Meeting/Webinar Security Settings';
                      type: 'object';
                    },
                  ];
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br> Account settings returned. \n**Error Code:** `200`<br>\nOnly available for Paid account.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `2001`<br>\nAccount does not exist: $subAccountId.';
          };
        };
        summary: 'Get settings';
        tags: ['Accounts'];
      };
      patch: {
        description: 'Update the settings of a sub account that is under a master account.<br> To update the settings of the master account, use `me` as the value of the `accountId` path parameter.<br><br>\n**Prerequisites**:\n * The sub account must be a paid account.<br>\n**Scopes**: `account:write:admin`\n<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`';
        operationId: 'accountSettingsUpdate';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            allowEmptyValue: true;
            in: 'query';
            name: 'option';
            schema: {
              enum: ['meeting_authentication', 'recording_authentication', 'security', 'meeting_security'];
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                oneOf: [
                  {
                    properties: {
                      email_notification: {
                        description: 'Account Settings: Notification.';
                        properties: {
                          alternative_host_reminder: {
                            description: 'Notify when an alternative host is set or removed from a meeting.';
                            type: 'boolean';
                          };
                          cancel_meeting_reminder: {
                            description: 'Notify the host and participants when a meeting is cancelled.';
                            type: 'boolean';
                          };
                          cloud_recording_avaliable_reminder: {
                            description: 'Notify host when cloud recording is available.';
                            type: 'boolean';
                          };
                          jbh_reminder: {
                            description: 'Notify the host when participants join the meeting before them.';
                            type: 'boolean';
                          };
                          low_host_count_reminder: {
                            description: 'Notify user when host licenses are running low.';
                            type: 'boolean';
                          };
                          schedule_for_reminder: {
                            description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      feature: {
                        description: 'Account Settings: Feature.';
                        properties: {
                          meeting_capacity: {
                            description: 'Set the maximum number of participants a host can have in a single meeting.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      in_meeting: {
                        description: 'Account Settings: In Meeting.';
                        properties: {
                          alert_guest_join: {
                            description: 'Identify guest participants in a meeting or webinar.';
                            type: 'boolean';
                          };
                          allow_live_streaming: {
                            description: 'Allow live streaming.';
                            type: 'boolean';
                          };
                          allow_participants_to_rename: {
                            description: 'If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.\n';
                            type: 'boolean';
                          };
                          allow_show_zoom_windows: {
                            description: 'Show the Zoom desktop application when sharing screens. ';
                            type: 'boolean';
                          };
                          annotation: {
                            description: 'Allow participants to use annotation tools to add information to shared screens.';
                            type: 'boolean';
                          };
                          anonymous_question_answer: {
                            description: 'Allow an anonymous Q&A in a webinar.';
                            type: 'boolean';
                          };
                          attendee_on_hold: {
                            default: false;
                            description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
                            type: 'boolean';
                          };
                          auto_answer: {
                            description: 'Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.';
                            type: 'boolean';
                          };
                          auto_saving_chat: {
                            description: 'Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.';
                            type: 'boolean';
                          };
                          breakout_room: {
                            description: 'Allow host to split meeting participants into separate, smaller rooms.';
                            type: 'boolean';
                          };
                          chat: {
                            description: 'Allow meeting participants to send a message that is visible to all participants.';
                            type: 'boolean';
                          };
                          closed_caption: {
                            description: 'Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions. ';
                            type: 'boolean';
                          };
                          co_host: {
                            description: 'Allow the host to add co-hosts.';
                            type: 'boolean';
                          };
                          custom_data_center_regions: {
                            description: 'If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.';
                            type: 'boolean';
                          };
                          custom_live_streaming_service: {
                            description: 'Custom live streaming.';
                            type: 'boolean';
                          };
                          custom_service_instructions: {
                            description: 'Custom service instructions.';
                            type: 'string';
                          };
                          data_center_regions: {
                            description: 'If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).\n';
                            enum: ['EU', 'HK', 'AU', 'IN', 'TY', 'CN', 'US', 'CA'];
                            items: {
                              type: 'string';
                            };
                            type: 'array';
                          };
                          dscp_audio: {
                            description: 'DSCP audio.';
                            maximum: 63;
                            minimum: 1;
                            type: 'integer';
                          };
                          dscp_marking: {
                            description: 'DSCP marking.';
                            type: 'boolean';
                          };
                          dscp_video: {
                            description: 'DSCP video.';
                            maximum: 63;
                            minimum: 1;
                            type: 'integer';
                          };
                          e2e_encryption: {
                            description: 'Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).';
                            type: 'boolean';
                          };
                          entry_exit_chime: {
                            description: 'Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.';
                            enum: ['host', 'all', 'none'];
                            type: 'string';
                            'x-enum-descriptions': ['Heard by host only', 'Heard by host and all attendees', 'Disable'];
                          };
                          far_end_camera_control: {
                            description: 'Allow another user to take control of your camera during a meeting.';
                            type: 'boolean';
                          };
                          feedback: {
                            description: 'Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.';
                            type: 'boolean';
                          };
                          file_transfer: {
                            description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.';
                            type: 'boolean';
                          };
                          group_hd: {
                            description: 'Activate higher quality video for host and participants.\nPlease note: This will use more bandwidth.';
                            type: 'boolean';
                          };
                          meeting_reactions: {
                            description: 'Enable or disable meeting reactions. <br>\n`true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>\n`false`: Do not enable meeting reactions.';
                            type: 'boolean';
                          };
                          original_audio: {
                            description: 'Allow users to select original sound in their client settings.';
                            type: 'boolean';
                          };
                          p2p_connetion: {
                            description: 'Peer to peer connection while only two people are in a meeting.';
                            type: 'boolean';
                          };
                          p2p_ports: {
                            description: 'Peer to peer listening ports range.';
                            type: 'boolean';
                          };
                          polling: {
                            description: 'Add "Polls" to the meeting controls.';
                            type: 'boolean';
                          };
                          ports_range: {
                            default: '';
                            description: 'The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.';
                            type: 'string';
                          };
                          post_meeting_feedback: {
                            description: 'Display a thumbs up or down survey at the end of each meeting.';
                            type: 'boolean';
                          };
                          private_chat: {
                            description: 'Allow a meeting participant to send a private message to another participant.';
                            type: 'boolean';
                          };
                          record_play_own_voice: {
                            description: 'Record and play their own voice.';
                            type: 'boolean';
                          };
                          remote_control: {
                            description: 'Allow users to request remote control.';
                            type: 'boolean';
                          };
                          request_permission_to_unmute: {
                            description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.';
                            type: 'boolean';
                          };
                          screen_sharing: {
                            description: 'Allow screen sharing.';
                            type: 'boolean';
                          };
                          sending_default_email_invites: {
                            description: 'Only show the default email when sending email invites.';
                            type: 'boolean';
                          };
                          show_a_join_from_your_browser_link: {
                            description: 'If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.';
                            type: 'boolean';
                          };
                          show_meeting_control_toolbar: {
                            description: 'Always show the meeting control toolbar.';
                            type: 'boolean';
                          };
                          stereo_audio: {
                            description: 'Allow users to select stereo audio in their client settings.';
                            type: 'boolean';
                          };
                          use_html_format_email: {
                            description: 'Use HTML formatted email for the Outlook plugin.';
                            type: 'boolean';
                          };
                          virtual_background: {
                            description: 'Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.';
                            type: 'boolean';
                          };
                          virtual_background_settings: {
                            description: 'Settings to manage virtual background.';
                            properties: {
                              allow_upload_custom: {
                                description: 'Allow users to upload custom backgrounds.';
                                type: 'boolean';
                              };
                              allow_videos: {
                                description: 'Allow use of videos for virtual backgrounds.';
                                type: 'boolean';
                              };
                              enable: {
                                description: 'Enable virtual background.';
                                type: 'boolean';
                              };
                              files: {
                                items: {
                                  properties: {
                                    id: {
                                      description: 'Unique identifier of the file.';
                                      type: 'string';
                                    };
                                    is_default: {
                                      description: 'Indicates whether or not this file is the default virtual background file.';
                                      type: 'boolean';
                                    };
                                    name: {
                                      description: 'File name.';
                                      type: 'string';
                                    };
                                    size: {
                                      description: 'File size.';
                                      type: 'string';
                                    };
                                    type: {
                                      description: 'File type.';
                                      type: 'string';
                                    };
                                  };
                                  type: 'object';
                                };
                                type: 'array';
                              };
                            };
                            type: 'object';
                          };
                          watermark: {
                            description: 'Add a watermark when viewing a shared screen.';
                            type: 'boolean';
                          };
                          webinar_question_answer: {
                            description: 'Allow a Q&A in a webinar.';
                            type: 'boolean';
                          };
                          whiteboard: {
                            description: 'Allow participants to share a whiteboard that includes annotation tools.';
                            type: 'boolean';
                          };
                          who_can_share_screen: {
                            description: 'Indicates who can share their screen or content during meetings. The value can be one of the following: <br>\n`host`: Only host can share the screen.<br>\n`all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
                            enum: ['host', 'all'];
                            type: 'string';
                          };
                          who_can_share_screen_when_someone_is_sharing: {
                            description: 'Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>\n`host`: Only a host can share the screen when someone else is sharing.<br>\n`all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
                            enum: ['host', 'all'];
                            type: 'string';
                          };
                          workplace_by_facebook: {
                            description: 'Workplace by facebook.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      integration: {
                        description: 'Account Settings: Integration.';
                        properties: {
                          box: {
                            description: 'Enable users who join a meeting from their mobile device to share content from their Box account.';
                            type: 'boolean';
                          };
                          dropbox: {
                            description: 'Enable users who join a meeting from their mobile device to share content from their Dropbox account.';
                            type: 'boolean';
                          };
                          google_calendar: {
                            description: 'Enable meetings to be scheduled using Google Calendar.';
                            type: 'boolean';
                          };
                          google_drive: {
                            description: 'Enable users who join a meeting from their mobile device to share content from their Google Drive.';
                            type: 'boolean';
                          };
                          kubi: {
                            description: 'Enable users to control a connected Kubi device from within a Zoom meeting.';
                            type: 'boolean';
                          };
                          microsoft_one_drive: {
                            description: 'Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      profile: {
                        properties: {
                          recording_storage_location: {
                            properties: {
                              allowed_values: {
                                description: 'Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.\n\nProvide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.';
                                items: {
                                  type: 'string';
                                };
                                type: 'array';
                              };
                              value: {
                                description: 'Abbreviated country code.';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                        };
                        title: 'Profile';
                        type: 'object';
                      };
                      recording: {
                        description: 'Account Settings: Recording.';
                        properties: {
                          account_user_access_recording: {
                            description: 'Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.';
                            type: 'boolean';
                          };
                          allow_recovery_deleted_cloud_recordings: {
                            description: 'Allow recovery of deleted cloud recordings from trash. \nIf the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period. ';
                            type: 'boolean';
                          };
                          archive: {
                            description: '[Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.';
                            properties: {
                              enable: {
                                description: 'Enable the archiving feature.';
                                type: 'boolean';
                              };
                              settings: {
                                properties: {
                                  audio_file: {
                                    description: 'Include in-meeting and/or in-webinar audio in the archive.';
                                    type: 'boolean';
                                  };
                                  cc_transcript_file: {
                                    description: 'Include closed caption or transcript in the archive.';
                                    type: 'boolean';
                                  };
                                  chat_file: {
                                    description: 'Include in-meeting chat in the archive.';
                                    type: 'boolean';
                                  };
                                  chat_with_sender_email: {
                                    description: 'Include user email in in-meeting chat file.';
                                    type: 'boolean';
                                  };
                                  video_file: {
                                    description: 'Include in-meeting and/or in-webinar video in the archive.';
                                    type: 'boolean';
                                  };
                                };
                                type: 'object';
                              };
                              type: {
                                description: 'Archive types:\n\n* `1`: Only meetings are archived.<br>\n* `2`: Only webinars are archived.<br>\n* `3`: Both meetings and webinars are archived.';
                                enum: [1, 2, 3];
                                type: 'integer';
                              };
                            };
                            type: 'object';
                          };
                          auto_delete_cmr: {
                            description: 'Allow Zoom to permanantly delete recordings automatically after a specified number of days.';
                            type: 'boolean';
                          };
                          auto_delete_cmr_days: {
                            description: "When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.";
                            type: 'integer';
                          };
                          auto_recording: {
                            description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
                            enum: ['local', 'cloud', 'none'];
                            type: 'string';
                            'x-enum-descriptions': ['Record on local', 'Record on cloud', 'Disabled'];
                          };
                          cloud_recording: {
                            description: 'Allow hosts to record and save the meeting in the cloud.';
                            type: 'boolean';
                          };
                          cloud_recording_download: {
                            description: 'Cloud recording downloads.';
                            type: 'boolean';
                          };
                          cloud_recording_download_host: {
                            description: 'Only the host can download cloud recordings.';
                            type: 'boolean';
                          };
                          host_delete_cloud_recording: {
                            description: 'If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.\n';
                            type: 'boolean';
                          };
                          ip_address_access_control: {
                            description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
                            properties: {
                              enable: {
                                description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                                type: 'boolean';
                              };
                              ip_addresses_or_ranges: {
                                description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          local_recording: {
                            description: 'Allow hosts and participants to record the meeting using a local file.';
                            type: 'boolean';
                          };
                          prevent_host_access_recording: {
                            description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n';
                            type: 'boolean';
                          };
                          record_audio_file: {
                            description: 'Record an audio only file.';
                            type: 'boolean';
                          };
                          record_gallery_view: {
                            description: 'Record the gallery view with a shared screen.';
                            type: 'boolean';
                          };
                          record_speaker_view: {
                            description: 'Record the active speaker with a shared screen.';
                            type: 'boolean';
                          };
                          recording_audio_transcript: {
                            description: 'Automatically transcribe the audio of the meeting or webinar to the cloud.';
                            type: 'boolean';
                          };
                          recording_disclaimer: {
                            description: 'Show a disclaimer to participants before a recording starts\n';
                            type: 'boolean';
                          };
                          recording_password_requirement: {
                            description: 'This object represents the minimum password requirements set for recordings via Account Recording Settings.';
                            properties: {
                              have_letter: {
                                description: 'Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).';
                                type: 'boolean';
                              };
                              have_number: {
                                description: 'Indicates whether or not password must contain at least one number(1, 2, 3..).';
                                type: 'boolean';
                              };
                              have_special_character: {
                                description: 'Indicates whether or not password must contain at least one special character(!, @, #..).';
                                type: 'boolean';
                              };
                              length: {
                                description: 'Minimum required length for the password.';
                                maximum: 10;
                                type: 'integer';
                              };
                              only_allow_numeric: {
                                description: 'Indicates whether or not password must contain only numeric characters.';
                                type: 'boolean';
                              };
                            };
                            type: 'object';
                          };
                          required_password_for_existing_cloud_recordings: {
                            description: 'Require a passcode to access existing cloud recordings.';
                            type: 'boolean';
                          };
                          save_chat_text: {
                            description: 'Save the chat text from the meeting.';
                            type: 'boolean';
                          };
                          show_timestamp: {
                            description: 'Add a timestamp to the recording.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      schedule_meeting: {
                        description: 'Account Settings: Schedule Meeting.';
                        properties: {
                          audio_type: {
                            default: 'both';
                            description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.';
                            enum: ['both', 'telephony', 'voip', 'thirdParty'];
                            type: 'string';
                            'x-enum-descriptions': [
                              'Telephony and VoIP',
                              'Audio PSTN telephony only',
                              'VoIP only',
                              '3rd party audio conference',
                            ];
                          };
                          enforce_login: {
                            description: 'Only Zoom users who are signed in can join meetings.';
                            type: 'boolean';
                          };
                          enforce_login_domains: {
                            description: 'Only signed in users with a specified domain can join the meeting. ';
                            type: 'string';
                          };
                          enforce_login_with_domains: {
                            description: 'Only signed in users with a specific domain can join meetings.';
                            type: 'boolean';
                          };
                          force_pmi_jbh_password: {
                            description: 'Require a password for Personal Meetings if attendees can join before host.';
                            type: 'boolean';
                          };
                          host_video: {
                            description: 'Start meetings with the host video on.';
                            type: 'boolean';
                          };
                          join_before_host: {
                            description: 'Allow participants to join the meeting before the host arrives.';
                            type: 'boolean';
                          };
                          meeting_password_requirement: {
                            description: 'Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                            properties: {
                              consecutive_characters_length: {
                                enum: [0, 4, 5, 6, 7, 8];
                                type: 'integer';
                              };
                              have_letter: {
                                description: 'If set to `true`, the password must contain at least 1 letter (such as a,b,c...).\n';
                                type: 'boolean';
                              };
                              have_number: {
                                description: 'If set to `true`, the password must contain at least 1 number (such as 1,2,3...).';
                                type: 'boolean';
                              };
                              have_special_character: {
                                description: 'If set to `true`, the password must have at least 1 special character (!,@,#...).';
                                type: 'boolean';
                              };
                              have_upper_and_lower_characters: {
                                description: 'If set to `true`, the password must include both uppercase and lowercase characters.';
                                type: 'boolean';
                              };
                              length: {
                                description: 'The minimum length that the meeting/webinar password needs to have.';
                                type: 'integer';
                              };
                              only_allow_numeric: {
                                description: 'If set to `true`, the password must only contain numbers and no other characters.';
                                type: 'boolean';
                              };
                              weak_enhance_detection: {
                                description: 'If set to `true`, users will be informed if the provided password is weak.';
                                type: 'boolean';
                              };
                            };
                            type: 'object';
                          };
                          not_store_meeting_topic: {
                            description: 'Always display "Zoom Meeting" as the meeting topic.';
                            type: 'boolean';
                          };
                          participant_video: {
                            description: 'Start meetings with the participant video on. Participants can change this setting during the meeting.';
                            type: 'boolean';
                          };
                          personal_meeting: {
                            description: 'Personal Meeting Setting.<br><br>\n`true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.\nFor Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n';
                            type: 'boolean';
                          };
                          require_password_for_instant_meetings: {
                            description: 'Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
                            type: 'boolean';
                          };
                          require_password_for_pmi_meetings: {
                            description: 'Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
                            enum: ['jbh_only', 'all', 'none'];
                            type: 'string';
                            'x-enum-descriptions': [
                              'Only meetings with Join Before Host enabled',
                              'All meetings using PMI',
                              'Disabled',
                            ];
                          };
                          require_password_for_scheduled_meetings: {
                            description: 'Require a password for meetings which have already been scheduled\n';
                            type: 'boolean';
                          };
                          require_password_for_scheduling_new_meetings: {
                            description: 'Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                            type: 'boolean';
                          };
                          use_pmi_for_instant_meetings: {
                            description: 'Use Personal Meeting ID (PMI) when starting an instant meeting\n';
                            type: 'boolean';
                          };
                          use_pmi_for_scheduled_meetings: {
                            description: 'Use Personal Meeting ID (PMI) when scheduling a meeting\n';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      security: {
                        description: '[Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.';
                        properties: {
                          admin_change_name_pic: {
                            description: "Only account administrators can change a user's username and picture.";
                            type: 'boolean';
                          };
                          hide_billing_info: {
                            description: 'Hide billing information.';
                            type: 'boolean';
                          };
                          import_photos_from_devices: {
                            description: 'Allow users to import photos from a photo library on a  device.';
                            type: 'boolean';
                          };
                          password_requirement: {
                            description: "This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password. ";
                            properties: {
                              consecutive_characters_length: {
                                description: '\nSpecify the max length of consecutive characters(abcde...) that can be used in a password.\nIf you set the value of this field to `0`, no restriction will be applied on consecutive characters. \n\nIf you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.\n\nThe max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).';
                                type: 'integer';
                              };
                              have_special_character: {
                                description: 'If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).';
                                type: 'boolean';
                              };
                              minimum_password_length: {
                                description: 'Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.';
                                maximum: 14;
                                minimum: 8;
                                type: 'integer';
                              };
                              weak_enhance_detection: {
                                description: 'If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.';
                                type: 'boolean';
                              };
                            };
                            type: 'object';
                          };
                          sign_again_period_for_inactivity_on_client: {
                            description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`45`: 45 minutes<br>\n`60`: 60 minutes<br>\n`90`: 90 minutes<br>\n`120`: 120 minutes\n';
                            type: 'integer';
                          };
                          sign_again_period_for_inactivity_on_web: {
                            description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`60`: 60 minutes<br>\n`120`: 120 minutes\n\n    \n\n';
                            type: 'integer';
                          };
                          sign_in_with_two_factor_auth: {
                            description: 'Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:\n`all`: Two factor authentication will be enabled for all users in the account.<br>\n`none`: Two factor authentication is disabled.<br>\n`group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>\n`role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the\n`sign_in_with_two_factor_auth_roles` field.\n';
                            enum: ['all', 'group', 'role', 'none'];
                            type: 'string';
                          };
                          sign_in_with_two_factor_auth_groups: {
                            description: 'This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`';
                            items: {
                              type: 'string';
                            };
                            type: 'array';
                          };
                          sign_in_with_two_factor_auth_roles: {
                            description: 'This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.';
                            items: {
                              type: 'string';
                            };
                            type: 'array';
                          };
                        };
                        type: 'object';
                      };
                      telephony: {
                        description: 'Account Settings Update: Telephony.';
                        properties: {
                          audio_conference_info: {
                            description: 'Third party audio conference info.';
                            type: 'string';
                          };
                          telephony_regions: {
                            description: 'Indicates where most of the participants call into or call from duriing a meeting.';
                            properties: {
                              selection_values: {
                                description: 'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.';
                                items: {
                                  type: 'string';
                                };
                                type: 'array';
                              };
                            };
                            type: 'object';
                          };
                          third_party_audio: {
                            description: 'Users can join the meeting using the existing third party audio configuration.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      tsp: {
                        description: 'Account Settings: TSP.';
                        properties: {
                          call_out: {
                            description: 'Call Out';
                            type: 'boolean';
                          };
                          call_out_countries: {
                            description: 'Call Out Countries/Regions';
                            items: {};
                            type: 'array';
                          };
                          display_toll_free_numbers: {
                            description: 'Display toll-free numbers';
                            type: 'boolean';
                          };
                          show_international_numbers_link: {
                            description: 'Show international numbers link on the invitation email';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      zoom_rooms: {
                        description: 'Account Settings: Zoom Rooms.';
                        properties: {
                          auto_start_stop_scheduled_meetings: {
                            description: 'Automatic start and stop for scheduled meetings.';
                            type: 'boolean';
                          };
                          cmr_for_instant_meeting: {
                            description: 'Cloud recording for instant meetings.';
                            type: 'boolean';
                          };
                          force_private_meeting: {
                            description: 'Shift all meetings to private.';
                            type: 'boolean';
                          };
                          hide_host_information: {
                            description: 'Hide host and meeting ID from private meetings.';
                            type: 'boolean';
                          };
                          list_meetings_with_calendar: {
                            description: 'Display meeting list with calendar integration.';
                            type: 'boolean';
                          };
                          start_airplay_manually: {
                            description: 'Start AirPlay service manually.';
                            type: 'boolean';
                          };
                          ultrasonic: {
                            description: 'Automatic direct sharing using an ultrasonic proximity signal.';
                            type: 'boolean';
                          };
                          upcoming_meeting_alert: {
                            description: 'Upcoming meeting alert.';
                            type: 'boolean';
                          };
                          weekly_system_restart: {
                            description: 'Weekly system restart.';
                            type: 'boolean';
                          };
                          zr_post_meeting_feedback: {
                            description: 'Zoom Room post meeting feedback.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                    };
                    title: 'Update account settings';
                    type: 'object';
                  },
                  {
                    oneOf: [
                      {
                        description: 'Set/ update [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars).<br><br> The authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).';
                        properties: {
                          authentication_option: {
                            description: 'Meeting Authentication Options';
                            properties: {
                              action: {
                                description: 'Specify the action that you would like to take via this API request:<br>\n* `add` : Choose this value if you are adding an authentication option.\n* `update`: Choose this value if you are updating an existing authentication option.\n* `delete`: Choose this value if you are deleting an existing authentication option.';
                                enum: ['update', 'delete', 'add'];
                                type: 'string';
                              };
                              default_option: {
                                description: 'Specify whether you would like to set this authentication option as the default option or not.';
                                type: 'boolean';
                              };
                              domains: {
                                description: 'If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to join your meetings or webinars. ';
                                type: 'string';
                              };
                              id: {
                                description: ' Authentication ID. If you are creating an authentication profile, you do not need to provide this field. The id field will be generated in the response once this API request is completed successfully. You can also use the Get Account Settings API with query parameter set to `meeting_authentication` to list the authentication id.<br><br>\n Use this field or the `name` field to identify the associated authentication option that you would like to update or delete.';
                                type: 'string';
                              };
                              name: {
                                description: 'Unique name for the authentication option.';
                                type: 'string';
                              };
                              type: {
                                description: ' Authentication type. Specify one of the following authentication types for the authentication profile:<br>\n * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>\n * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.';
                                enum: [
                                  'enforce_login',
                                  'enforce_login_with_same_account',
                                  'enforce_login_with_domains',
                                ];
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          meeting_authentication: {
                            description: 'If set to "true", only authenticated users can join meetings. The method for authentication can be defined in the "authentication_option". ';
                            type: 'boolean';
                          };
                        };
                      },
                      {
                        description: 'Set/Update [authentication profile for Cloud Recordings](https://support.zoom.us/hc/en-us/articles/360037756671-Authentication-Profiles-for-Cloud-Recordings).';
                        properties: {
                          authentication_option: {
                            description: 'Specify the authentication options for this account.';
                            properties: {
                              action: {
                                description: 'Specify the action that you would like to take via this API request:<br>\n* `add` : Choose this value if you are adding an authentication option.\n* `update`: Choose this value if you are updating an existing authentication option.\n* `delete`: Choose this value if you are deleting an existing authentication option.';
                                enum: ['update', 'delete', 'add'];
                                type: 'string';
                              };
                              default_option: {
                                description: 'Specify whether you would like to set this authentication option as the default option or not.';
                                type: 'boolean';
                              };
                              domains: {
                                description: 'If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to view the recordings. ';
                                type: 'string';
                              };
                              id: {
                                description: ' Authentication ID. If you are creating an authentication profile, you do not need to provide this field. The id field will be generated in the response once this API request is completed successfully. You can also use the Get Account Settings API with query parameter set to `meeting_authentication` to list the authentication id.<br><br>\nUse this field or the `name` field to identify the associated authentication option that you would like to update or delete.';
                                type: 'string';
                              };
                              name: {
                                description: 'Unique name for the authentication option.';
                                type: 'string';
                              };
                              type: {
                                description: 'Specify one authentication type that is to be associated with this authentication configuration:<br>\n* `internally`: This option allows you specify a rule that only signed in users within your account can view the recording.<br>\n * `enforce_login`: This option allows any users to view the recording, as long as they are signed into their Zoom account.<br>\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can view the recording. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.\n\n';
                                enum: ['internally', 'enforce_login', 'enforce_login_with_domains'];
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          recording_authentication: {
                            description: 'If set to `true`, only authenticated users can view the cloud recordings.<br><br>\nThe authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).';
                            type: 'boolean';
                          };
                        };
                      },
                    ];
                    title: 'AccountSettingsAuthenticationUpdate';
                    type: 'object';
                  },
                  {
                    properties: {
                      meeting_security: {
                        properties: {
                          auto_security: {
                            description: '`true`: Require that all meetings are secured with at least one security option.\n\nThis setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).';
                            type: 'boolean';
                          };
                          embed_password_in_join_link: {
                            description: 'If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.\n';
                            type: 'boolean';
                          };
                          encryption_type: {
                            description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                            enum: ['enhanced_encryption', 'e2ee'];
                            type: 'string';
                          };
                          end_to_end_encrypted_meetings: {
                            description: 'Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.';
                            type: 'boolean';
                          };
                          meeting_password: {
                            description: 'If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.';
                            type: 'boolean';
                          };
                          meeting_password_requirement: {
                            description: 'Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                            properties: {
                              consecutive_characters_length: {
                                enum: [0, 4, 5, 6, 7, 8];
                                type: 'integer';
                              };
                              have_letter: {
                                description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                                type: 'boolean';
                              };
                              have_number: {
                                description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                                type: 'boolean';
                              };
                              have_special_character: {
                                description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                                type: 'boolean';
                              };
                              have_upper_and_lower_characters: {
                                description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                                type: 'boolean';
                              };
                              length: {
                                description: 'The minimum length that the meeting/webinar passcode needs to have.';
                                type: 'integer';
                              };
                              only_allow_numeric: {
                                description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                                type: 'boolean';
                              };
                              weak_enhance_detection: {
                                description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                                type: 'boolean';
                              };
                            };
                            type: 'object';
                          };
                          phone_password: {
                            description: 'Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.';
                            type: 'boolean';
                          };
                          pmi_password: {
                            description: 'If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.\n';
                            type: 'boolean';
                          };
                          require_password_for_scheduled_meeting: {
                            description: 'Require a passcode for meetings which have already been scheduled.\n';
                            type: 'boolean';
                          };
                          require_password_for_scheduled_webinar: {
                            description: 'Require a passcode for webinars which have already been scheduled.\n';
                            type: 'boolean';
                          };
                          waiting_room: {
                            description: 'When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.\n';
                            type: 'boolean';
                          };
                          waiting_room_settings: {
                            description: 'Specify the settings to be applied if waiting room is enabled.';
                            properties: {
                              participants_to_place_in_waiting_room: {
                                description: '\n\nSpecify who should be admitted to the waiting room. The value of this field can be one of the following:<br>\n`0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in ';
                                enum: [0, 1, 2];
                                type: 'integer';
                              };
                              users_who_can_admit_participants_from_waiting_room: {
                                description: 'Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>\n`0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).\n\n\n';
                                type: 'integer';
                              };
                              whitelisted_domains_for_waiting_room: {
                                description: 'If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          webinar_password: {
                            description: 'If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.\n';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                    };
                    title: 'Meeting/Webinar Security Settings';
                    type: 'object';
                  },
                ];
              };
            };
            'multipart/form-data': {
              schema: {
                oneOf: [
                  {
                    properties: {
                      email_notification: {
                        description: 'Account Settings: Notification.';
                        properties: {
                          alternative_host_reminder: {
                            description: 'Notify when an alternative host is set or removed from a meeting.';
                            type: 'boolean';
                          };
                          cancel_meeting_reminder: {
                            description: 'Notify the host and participants when a meeting is cancelled.';
                            type: 'boolean';
                          };
                          cloud_recording_avaliable_reminder: {
                            description: 'Notify host when cloud recording is available.';
                            type: 'boolean';
                          };
                          jbh_reminder: {
                            description: 'Notify the host when participants join the meeting before them.';
                            type: 'boolean';
                          };
                          low_host_count_reminder: {
                            description: 'Notify user when host licenses are running low.';
                            type: 'boolean';
                          };
                          schedule_for_reminder: {
                            description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      feature: {
                        description: 'Account Settings: Feature.';
                        properties: {
                          meeting_capacity: {
                            description: 'Set the maximum number of participants a host can have in a single meeting.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      in_meeting: {
                        description: 'Account Settings: In Meeting.';
                        properties: {
                          alert_guest_join: {
                            description: 'Identify guest participants in a meeting or webinar.';
                            type: 'boolean';
                          };
                          allow_live_streaming: {
                            description: 'Allow live streaming.';
                            type: 'boolean';
                          };
                          allow_participants_to_rename: {
                            description: 'If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.\n';
                            type: 'boolean';
                          };
                          allow_show_zoom_windows: {
                            description: 'Show the Zoom desktop application when sharing screens. ';
                            type: 'boolean';
                          };
                          annotation: {
                            description: 'Allow participants to use annotation tools to add information to shared screens.';
                            type: 'boolean';
                          };
                          anonymous_question_answer: {
                            description: 'Allow an anonymous Q&A in a webinar.';
                            type: 'boolean';
                          };
                          attendee_on_hold: {
                            default: false;
                            description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
                            type: 'boolean';
                          };
                          auto_answer: {
                            description: 'Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.';
                            type: 'boolean';
                          };
                          auto_saving_chat: {
                            description: 'Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.';
                            type: 'boolean';
                          };
                          breakout_room: {
                            description: 'Allow host to split meeting participants into separate, smaller rooms.';
                            type: 'boolean';
                          };
                          chat: {
                            description: 'Allow meeting participants to send a message that is visible to all participants.';
                            type: 'boolean';
                          };
                          closed_caption: {
                            description: 'Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions. ';
                            type: 'boolean';
                          };
                          co_host: {
                            description: 'Allow the host to add co-hosts.';
                            type: 'boolean';
                          };
                          custom_data_center_regions: {
                            description: 'If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.';
                            type: 'boolean';
                          };
                          custom_live_streaming_service: {
                            description: 'Custom live streaming.';
                            type: 'boolean';
                          };
                          custom_service_instructions: {
                            description: 'Custom service instructions.';
                            type: 'string';
                          };
                          data_center_regions: {
                            description: 'If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).\n';
                            enum: ['EU', 'HK', 'AU', 'IN', 'TY', 'CN', 'US', 'CA'];
                            items: {
                              type: 'string';
                            };
                            type: 'array';
                          };
                          dscp_audio: {
                            description: 'DSCP audio.';
                            maximum: 63;
                            minimum: 1;
                            type: 'integer';
                          };
                          dscp_marking: {
                            description: 'DSCP marking.';
                            type: 'boolean';
                          };
                          dscp_video: {
                            description: 'DSCP video.';
                            maximum: 63;
                            minimum: 1;
                            type: 'integer';
                          };
                          e2e_encryption: {
                            description: 'Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).';
                            type: 'boolean';
                          };
                          entry_exit_chime: {
                            description: 'Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.';
                            enum: ['host', 'all', 'none'];
                            type: 'string';
                            'x-enum-descriptions': ['Heard by host only', 'Heard by host and all attendees', 'Disable'];
                          };
                          far_end_camera_control: {
                            description: 'Allow another user to take control of your camera during a meeting.';
                            type: 'boolean';
                          };
                          feedback: {
                            description: 'Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.';
                            type: 'boolean';
                          };
                          file_transfer: {
                            description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.';
                            type: 'boolean';
                          };
                          group_hd: {
                            description: 'Activate higher quality video for host and participants.\nPlease note: This will use more bandwidth.';
                            type: 'boolean';
                          };
                          meeting_reactions: {
                            description: 'Enable or disable meeting reactions. <br>\n`true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>\n`false`: Do not enable meeting reactions.';
                            type: 'boolean';
                          };
                          original_audio: {
                            description: 'Allow users to select original sound in their client settings.';
                            type: 'boolean';
                          };
                          p2p_connetion: {
                            description: 'Peer to peer connection while only two people are in a meeting.';
                            type: 'boolean';
                          };
                          p2p_ports: {
                            description: 'Peer to peer listening ports range.';
                            type: 'boolean';
                          };
                          polling: {
                            description: 'Add "Polls" to the meeting controls.';
                            type: 'boolean';
                          };
                          ports_range: {
                            default: '';
                            description: 'The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.';
                            type: 'string';
                          };
                          post_meeting_feedback: {
                            description: 'Display a thumbs up or down survey at the end of each meeting.';
                            type: 'boolean';
                          };
                          private_chat: {
                            description: 'Allow a meeting participant to send a private message to another participant.';
                            type: 'boolean';
                          };
                          record_play_own_voice: {
                            description: 'Record and play their own voice.';
                            type: 'boolean';
                          };
                          remote_control: {
                            description: 'Allow users to request remote control.';
                            type: 'boolean';
                          };
                          request_permission_to_unmute: {
                            description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.';
                            type: 'boolean';
                          };
                          screen_sharing: {
                            description: 'Allow screen sharing.';
                            type: 'boolean';
                          };
                          sending_default_email_invites: {
                            description: 'Only show the default email when sending email invites.';
                            type: 'boolean';
                          };
                          show_a_join_from_your_browser_link: {
                            description: 'If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.';
                            type: 'boolean';
                          };
                          show_meeting_control_toolbar: {
                            description: 'Always show the meeting control toolbar.';
                            type: 'boolean';
                          };
                          stereo_audio: {
                            description: 'Allow users to select stereo audio in their client settings.';
                            type: 'boolean';
                          };
                          use_html_format_email: {
                            description: 'Use HTML formatted email for the Outlook plugin.';
                            type: 'boolean';
                          };
                          virtual_background: {
                            description: 'Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.';
                            type: 'boolean';
                          };
                          virtual_background_settings: {
                            description: 'Settings to manage virtual background.';
                            properties: {
                              allow_upload_custom: {
                                description: 'Allow users to upload custom backgrounds.';
                                type: 'boolean';
                              };
                              allow_videos: {
                                description: 'Allow use of videos for virtual backgrounds.';
                                type: 'boolean';
                              };
                              enable: {
                                description: 'Enable virtual background.';
                                type: 'boolean';
                              };
                              files: {
                                items: {
                                  properties: {
                                    id: {
                                      description: 'Unique identifier of the file.';
                                      type: 'string';
                                    };
                                    is_default: {
                                      description: 'Indicates whether or not this file is the default virtual background file.';
                                      type: 'boolean';
                                    };
                                    name: {
                                      description: 'File name.';
                                      type: 'string';
                                    };
                                    size: {
                                      description: 'File size.';
                                      type: 'string';
                                    };
                                    type: {
                                      description: 'File type.';
                                      type: 'string';
                                    };
                                  };
                                  type: 'object';
                                };
                                type: 'array';
                              };
                            };
                            type: 'object';
                          };
                          watermark: {
                            description: 'Add a watermark when viewing a shared screen.';
                            type: 'boolean';
                          };
                          webinar_question_answer: {
                            description: 'Allow a Q&A in a webinar.';
                            type: 'boolean';
                          };
                          whiteboard: {
                            description: 'Allow participants to share a whiteboard that includes annotation tools.';
                            type: 'boolean';
                          };
                          who_can_share_screen: {
                            description: 'Indicates who can share their screen or content during meetings. The value can be one of the following: <br>\n`host`: Only host can share the screen.<br>\n`all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
                            enum: ['host', 'all'];
                            type: 'string';
                          };
                          who_can_share_screen_when_someone_is_sharing: {
                            description: 'Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>\n`host`: Only a host can share the screen when someone else is sharing.<br>\n`all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
                            enum: ['host', 'all'];
                            type: 'string';
                          };
                          workplace_by_facebook: {
                            description: 'Workplace by facebook.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      integration: {
                        description: 'Account Settings: Integration.';
                        properties: {
                          box: {
                            description: 'Enable users who join a meeting from their mobile device to share content from their Box account.';
                            type: 'boolean';
                          };
                          dropbox: {
                            description: 'Enable users who join a meeting from their mobile device to share content from their Dropbox account.';
                            type: 'boolean';
                          };
                          google_calendar: {
                            description: 'Enable meetings to be scheduled using Google Calendar.';
                            type: 'boolean';
                          };
                          google_drive: {
                            description: 'Enable users who join a meeting from their mobile device to share content from their Google Drive.';
                            type: 'boolean';
                          };
                          kubi: {
                            description: 'Enable users to control a connected Kubi device from within a Zoom meeting.';
                            type: 'boolean';
                          };
                          microsoft_one_drive: {
                            description: 'Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      profile: {
                        properties: {
                          recording_storage_location: {
                            properties: {
                              allowed_values: {
                                description: 'Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.\n\nProvide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.';
                                items: {
                                  type: 'string';
                                };
                                type: 'array';
                              };
                              value: {
                                description: 'Abbreviated country code.';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                        };
                        title: 'Profile';
                        type: 'object';
                      };
                      recording: {
                        description: 'Account Settings: Recording.';
                        properties: {
                          account_user_access_recording: {
                            description: 'Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.';
                            type: 'boolean';
                          };
                          allow_recovery_deleted_cloud_recordings: {
                            description: 'Allow recovery of deleted cloud recordings from trash. \nIf the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period. ';
                            type: 'boolean';
                          };
                          archive: {
                            description: '[Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.';
                            properties: {
                              enable: {
                                description: 'Enable the archiving feature.';
                                type: 'boolean';
                              };
                              settings: {
                                properties: {
                                  audio_file: {
                                    description: 'Include in-meeting and/or in-webinar audio in the archive.';
                                    type: 'boolean';
                                  };
                                  cc_transcript_file: {
                                    description: 'Include closed caption or transcript in the archive.';
                                    type: 'boolean';
                                  };
                                  chat_file: {
                                    description: 'Include in-meeting chat in the archive.';
                                    type: 'boolean';
                                  };
                                  chat_with_sender_email: {
                                    description: 'Include user email in in-meeting chat file.';
                                    type: 'boolean';
                                  };
                                  video_file: {
                                    description: 'Include in-meeting and/or in-webinar video in the archive.';
                                    type: 'boolean';
                                  };
                                };
                                type: 'object';
                              };
                              type: {
                                description: 'Archive types:\n\n* `1`: Only meetings are archived.<br>\n* `2`: Only webinars are archived.<br>\n* `3`: Both meetings and webinars are archived.';
                                enum: [1, 2, 3];
                                type: 'integer';
                              };
                            };
                            type: 'object';
                          };
                          auto_delete_cmr: {
                            description: 'Allow Zoom to permanantly delete recordings automatically after a specified number of days.';
                            type: 'boolean';
                          };
                          auto_delete_cmr_days: {
                            description: "When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.";
                            type: 'integer';
                          };
                          auto_recording: {
                            description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
                            enum: ['local', 'cloud', 'none'];
                            type: 'string';
                            'x-enum-descriptions': ['Record on local', 'Record on cloud', 'Disabled'];
                          };
                          cloud_recording: {
                            description: 'Allow hosts to record and save the meeting in the cloud.';
                            type: 'boolean';
                          };
                          cloud_recording_download: {
                            description: 'Cloud recording downloads.';
                            type: 'boolean';
                          };
                          cloud_recording_download_host: {
                            description: 'Only the host can download cloud recordings.';
                            type: 'boolean';
                          };
                          host_delete_cloud_recording: {
                            description: 'If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.\n';
                            type: 'boolean';
                          };
                          ip_address_access_control: {
                            description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
                            properties: {
                              enable: {
                                description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                                type: 'boolean';
                              };
                              ip_addresses_or_ranges: {
                                description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          local_recording: {
                            description: 'Allow hosts and participants to record the meeting using a local file.';
                            type: 'boolean';
                          };
                          prevent_host_access_recording: {
                            description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n';
                            type: 'boolean';
                          };
                          record_audio_file: {
                            description: 'Record an audio only file.';
                            type: 'boolean';
                          };
                          record_gallery_view: {
                            description: 'Record the gallery view with a shared screen.';
                            type: 'boolean';
                          };
                          record_speaker_view: {
                            description: 'Record the active speaker with a shared screen.';
                            type: 'boolean';
                          };
                          recording_audio_transcript: {
                            description: 'Automatically transcribe the audio of the meeting or webinar to the cloud.';
                            type: 'boolean';
                          };
                          recording_disclaimer: {
                            description: 'Show a disclaimer to participants before a recording starts\n';
                            type: 'boolean';
                          };
                          recording_password_requirement: {
                            description: 'This object represents the minimum password requirements set for recordings via Account Recording Settings.';
                            properties: {
                              have_letter: {
                                description: 'Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).';
                                type: 'boolean';
                              };
                              have_number: {
                                description: 'Indicates whether or not password must contain at least one number(1, 2, 3..).';
                                type: 'boolean';
                              };
                              have_special_character: {
                                description: 'Indicates whether or not password must contain at least one special character(!, @, #..).';
                                type: 'boolean';
                              };
                              length: {
                                description: 'Minimum required length for the password.';
                                maximum: 10;
                                type: 'integer';
                              };
                              only_allow_numeric: {
                                description: 'Indicates whether or not password must contain only numeric characters.';
                                type: 'boolean';
                              };
                            };
                            type: 'object';
                          };
                          required_password_for_existing_cloud_recordings: {
                            description: 'Require a passcode to access existing cloud recordings.';
                            type: 'boolean';
                          };
                          save_chat_text: {
                            description: 'Save the chat text from the meeting.';
                            type: 'boolean';
                          };
                          show_timestamp: {
                            description: 'Add a timestamp to the recording.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      schedule_meeting: {
                        description: 'Account Settings: Schedule Meeting.';
                        properties: {
                          audio_type: {
                            default: 'both';
                            description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.';
                            enum: ['both', 'telephony', 'voip', 'thirdParty'];
                            type: 'string';
                            'x-enum-descriptions': [
                              'Telephony and VoIP',
                              'Audio PSTN telephony only',
                              'VoIP only',
                              '3rd party audio conference',
                            ];
                          };
                          enforce_login: {
                            description: 'Only Zoom users who are signed in can join meetings.';
                            type: 'boolean';
                          };
                          enforce_login_domains: {
                            description: 'Only signed in users with a specified domain can join the meeting. ';
                            type: 'string';
                          };
                          enforce_login_with_domains: {
                            description: 'Only signed in users with a specific domain can join meetings.';
                            type: 'boolean';
                          };
                          force_pmi_jbh_password: {
                            description: 'Require a password for Personal Meetings if attendees can join before host.';
                            type: 'boolean';
                          };
                          host_video: {
                            description: 'Start meetings with the host video on.';
                            type: 'boolean';
                          };
                          join_before_host: {
                            description: 'Allow participants to join the meeting before the host arrives.';
                            type: 'boolean';
                          };
                          meeting_password_requirement: {
                            description: 'Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                            properties: {
                              consecutive_characters_length: {
                                enum: [0, 4, 5, 6, 7, 8];
                                type: 'integer';
                              };
                              have_letter: {
                                description: 'If set to `true`, the password must contain at least 1 letter (such as a,b,c...).\n';
                                type: 'boolean';
                              };
                              have_number: {
                                description: 'If set to `true`, the password must contain at least 1 number (such as 1,2,3...).';
                                type: 'boolean';
                              };
                              have_special_character: {
                                description: 'If set to `true`, the password must have at least 1 special character (!,@,#...).';
                                type: 'boolean';
                              };
                              have_upper_and_lower_characters: {
                                description: 'If set to `true`, the password must include both uppercase and lowercase characters.';
                                type: 'boolean';
                              };
                              length: {
                                description: 'The minimum length that the meeting/webinar password needs to have.';
                                type: 'integer';
                              };
                              only_allow_numeric: {
                                description: 'If set to `true`, the password must only contain numbers and no other characters.';
                                type: 'boolean';
                              };
                              weak_enhance_detection: {
                                description: 'If set to `true`, users will be informed if the provided password is weak.';
                                type: 'boolean';
                              };
                            };
                            type: 'object';
                          };
                          not_store_meeting_topic: {
                            description: 'Always display "Zoom Meeting" as the meeting topic.';
                            type: 'boolean';
                          };
                          participant_video: {
                            description: 'Start meetings with the participant video on. Participants can change this setting during the meeting.';
                            type: 'boolean';
                          };
                          personal_meeting: {
                            description: 'Personal Meeting Setting.<br><br>\n`true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.\nFor Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n';
                            type: 'boolean';
                          };
                          require_password_for_instant_meetings: {
                            description: 'Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
                            type: 'boolean';
                          };
                          require_password_for_pmi_meetings: {
                            description: 'Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
                            enum: ['jbh_only', 'all', 'none'];
                            type: 'string';
                            'x-enum-descriptions': [
                              'Only meetings with Join Before Host enabled',
                              'All meetings using PMI',
                              'Disabled',
                            ];
                          };
                          require_password_for_scheduled_meetings: {
                            description: 'Require a password for meetings which have already been scheduled\n';
                            type: 'boolean';
                          };
                          require_password_for_scheduling_new_meetings: {
                            description: 'Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
                            type: 'boolean';
                          };
                          use_pmi_for_instant_meetings: {
                            description: 'Use Personal Meeting ID (PMI) when starting an instant meeting\n';
                            type: 'boolean';
                          };
                          use_pmi_for_scheduled_meetings: {
                            description: 'Use Personal Meeting ID (PMI) when scheduling a meeting\n';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      security: {
                        description: '[Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.';
                        properties: {
                          admin_change_name_pic: {
                            description: "Only account administrators can change a user's username and picture.";
                            type: 'boolean';
                          };
                          hide_billing_info: {
                            description: 'Hide billing information.';
                            type: 'boolean';
                          };
                          import_photos_from_devices: {
                            description: 'Allow users to import photos from a photo library on a  device.';
                            type: 'boolean';
                          };
                          password_requirement: {
                            description: "This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password. ";
                            properties: {
                              consecutive_characters_length: {
                                description: '\nSpecify the max length of consecutive characters(abcde...) that can be used in a password.\nIf you set the value of this field to `0`, no restriction will be applied on consecutive characters. \n\nIf you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.\n\nThe max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).';
                                type: 'integer';
                              };
                              have_special_character: {
                                description: 'If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).';
                                type: 'boolean';
                              };
                              minimum_password_length: {
                                description: 'Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.';
                                maximum: 14;
                                minimum: 8;
                                type: 'integer';
                              };
                              weak_enhance_detection: {
                                description: 'If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.';
                                type: 'boolean';
                              };
                            };
                            type: 'object';
                          };
                          sign_again_period_for_inactivity_on_client: {
                            description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`45`: 45 minutes<br>\n`60`: 60 minutes<br>\n`90`: 90 minutes<br>\n`120`: 120 minutes\n';
                            type: 'integer';
                          };
                          sign_again_period_for_inactivity_on_web: {
                            description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`60`: 60 minutes<br>\n`120`: 120 minutes\n\n    \n\n';
                            type: 'integer';
                          };
                          sign_in_with_two_factor_auth: {
                            description: 'Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:\n`all`: Two factor authentication will be enabled for all users in the account.<br>\n`none`: Two factor authentication is disabled.<br>\n`group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>\n`role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the\n`sign_in_with_two_factor_auth_roles` field.\n';
                            enum: ['all', 'group', 'role', 'none'];
                            type: 'string';
                          };
                          sign_in_with_two_factor_auth_groups: {
                            description: 'This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`';
                            items: {
                              type: 'string';
                            };
                            type: 'array';
                          };
                          sign_in_with_two_factor_auth_roles: {
                            description: 'This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.';
                            items: {
                              type: 'string';
                            };
                            type: 'array';
                          };
                        };
                        type: 'object';
                      };
                      telephony: {
                        description: 'Account Settings Update: Telephony.';
                        properties: {
                          audio_conference_info: {
                            description: 'Third party audio conference info.';
                            type: 'string';
                          };
                          telephony_regions: {
                            description: 'Indicates where most of the participants call into or call from duriing a meeting.';
                            properties: {
                              selection_values: {
                                description: 'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.';
                                items: {
                                  type: 'string';
                                };
                                type: 'array';
                              };
                            };
                            type: 'object';
                          };
                          third_party_audio: {
                            description: 'Users can join the meeting using the existing third party audio configuration.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      tsp: {
                        description: 'Account Settings: TSP.';
                        properties: {
                          call_out: {
                            description: 'Call Out';
                            type: 'boolean';
                          };
                          call_out_countries: {
                            description: 'Call Out Countries/Regions';
                            items: {};
                            type: 'array';
                          };
                          display_toll_free_numbers: {
                            description: 'Display toll-free numbers';
                            type: 'boolean';
                          };
                          show_international_numbers_link: {
                            description: 'Show international numbers link on the invitation email';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                      zoom_rooms: {
                        description: 'Account Settings: Zoom Rooms.';
                        properties: {
                          auto_start_stop_scheduled_meetings: {
                            description: 'Automatic start and stop for scheduled meetings.';
                            type: 'boolean';
                          };
                          cmr_for_instant_meeting: {
                            description: 'Cloud recording for instant meetings.';
                            type: 'boolean';
                          };
                          force_private_meeting: {
                            description: 'Shift all meetings to private.';
                            type: 'boolean';
                          };
                          hide_host_information: {
                            description: 'Hide host and meeting ID from private meetings.';
                            type: 'boolean';
                          };
                          list_meetings_with_calendar: {
                            description: 'Display meeting list with calendar integration.';
                            type: 'boolean';
                          };
                          start_airplay_manually: {
                            description: 'Start AirPlay service manually.';
                            type: 'boolean';
                          };
                          ultrasonic: {
                            description: 'Automatic direct sharing using an ultrasonic proximity signal.';
                            type: 'boolean';
                          };
                          upcoming_meeting_alert: {
                            description: 'Upcoming meeting alert.';
                            type: 'boolean';
                          };
                          weekly_system_restart: {
                            description: 'Weekly system restart.';
                            type: 'boolean';
                          };
                          zr_post_meeting_feedback: {
                            description: 'Zoom Room post meeting feedback.';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                    };
                    title: 'Update account settings';
                    type: 'object';
                  },
                  {
                    oneOf: [
                      {
                        description: 'Set/ update [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars).<br><br> The authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).';
                        properties: {
                          authentication_option: {
                            description: 'Meeting Authentication Options';
                            properties: {
                              action: {
                                description: 'Specify the action that you would like to take via this API request:<br>\n* `add` : Choose this value if you are adding an authentication option.\n* `update`: Choose this value if you are updating an existing authentication option.\n* `delete`: Choose this value if you are deleting an existing authentication option.';
                                enum: ['update', 'delete', 'add'];
                                type: 'string';
                              };
                              default_option: {
                                description: 'Specify whether you would like to set this authentication option as the default option or not.';
                                type: 'boolean';
                              };
                              domains: {
                                description: 'If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to join your meetings or webinars. ';
                                type: 'string';
                              };
                              id: {
                                description: ' Authentication ID. If you are creating an authentication profile, you do not need to provide this field. The id field will be generated in the response once this API request is completed successfully. You can also use the Get Account Settings API with query parameter set to `meeting_authentication` to list the authentication id.<br><br>\n Use this field or the `name` field to identify the associated authentication option that you would like to update or delete.';
                                type: 'string';
                              };
                              name: {
                                description: 'Unique name for the authentication option.';
                                type: 'string';
                              };
                              type: {
                                description: ' Authentication type. Specify one of the following authentication types for the authentication profile:<br>\n * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>\n * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.';
                                enum: [
                                  'enforce_login',
                                  'enforce_login_with_same_account',
                                  'enforce_login_with_domains',
                                ];
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          meeting_authentication: {
                            description: 'If set to "true", only authenticated users can join meetings. The method for authentication can be defined in the "authentication_option". ';
                            type: 'boolean';
                          };
                        };
                      },
                      {
                        description: 'Set/Update [authentication profile for Cloud Recordings](https://support.zoom.us/hc/en-us/articles/360037756671-Authentication-Profiles-for-Cloud-Recordings).';
                        properties: {
                          authentication_option: {
                            description: 'Specify the authentication options for this account.';
                            properties: {
                              action: {
                                description: 'Specify the action that you would like to take via this API request:<br>\n* `add` : Choose this value if you are adding an authentication option.\n* `update`: Choose this value if you are updating an existing authentication option.\n* `delete`: Choose this value if you are deleting an existing authentication option.';
                                enum: ['update', 'delete', 'add'];
                                type: 'string';
                              };
                              default_option: {
                                description: 'Specify whether you would like to set this authentication option as the default option or not.';
                                type: 'boolean';
                              };
                              domains: {
                                description: 'If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to view the recordings. ';
                                type: 'string';
                              };
                              id: {
                                description: ' Authentication ID. If you are creating an authentication profile, you do not need to provide this field. The id field will be generated in the response once this API request is completed successfully. You can also use the Get Account Settings API with query parameter set to `meeting_authentication` to list the authentication id.<br><br>\nUse this field or the `name` field to identify the associated authentication option that you would like to update or delete.';
                                type: 'string';
                              };
                              name: {
                                description: 'Unique name for the authentication option.';
                                type: 'string';
                              };
                              type: {
                                description: 'Specify one authentication type that is to be associated with this authentication configuration:<br>\n* `internally`: This option allows you specify a rule that only signed in users within your account can view the recording.<br>\n * `enforce_login`: This option allows any users to view the recording, as long as they are signed into their Zoom account.<br>\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can view the recording. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.\n\n';
                                enum: ['internally', 'enforce_login', 'enforce_login_with_domains'];
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          recording_authentication: {
                            description: 'If set to `true`, only authenticated users can view the cloud recordings.<br><br>\nThe authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).';
                            type: 'boolean';
                          };
                        };
                      },
                    ];
                    title: 'AccountSettingsAuthenticationUpdate';
                    type: 'object';
                  },
                  {
                    properties: {
                      meeting_security: {
                        properties: {
                          auto_security: {
                            description: '`true`: Require that all meetings are secured with at least one security option.\n\nThis setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).';
                            type: 'boolean';
                          };
                          embed_password_in_join_link: {
                            description: 'If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.\n';
                            type: 'boolean';
                          };
                          encryption_type: {
                            description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                            enum: ['enhanced_encryption', 'e2ee'];
                            type: 'string';
                          };
                          end_to_end_encrypted_meetings: {
                            description: 'Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.';
                            type: 'boolean';
                          };
                          meeting_password: {
                            description: 'If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.';
                            type: 'boolean';
                          };
                          meeting_password_requirement: {
                            description: 'Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                            properties: {
                              consecutive_characters_length: {
                                enum: [0, 4, 5, 6, 7, 8];
                                type: 'integer';
                              };
                              have_letter: {
                                description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                                type: 'boolean';
                              };
                              have_number: {
                                description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                                type: 'boolean';
                              };
                              have_special_character: {
                                description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                                type: 'boolean';
                              };
                              have_upper_and_lower_characters: {
                                description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                                type: 'boolean';
                              };
                              length: {
                                description: 'The minimum length that the meeting/webinar passcode needs to have.';
                                type: 'integer';
                              };
                              only_allow_numeric: {
                                description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                                type: 'boolean';
                              };
                              weak_enhance_detection: {
                                description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                                type: 'boolean';
                              };
                            };
                            type: 'object';
                          };
                          phone_password: {
                            description: 'Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.';
                            type: 'boolean';
                          };
                          pmi_password: {
                            description: 'If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.\n';
                            type: 'boolean';
                          };
                          require_password_for_scheduled_meeting: {
                            description: 'Require a passcode for meetings which have already been scheduled.\n';
                            type: 'boolean';
                          };
                          require_password_for_scheduled_webinar: {
                            description: 'Require a passcode for webinars which have already been scheduled.\n';
                            type: 'boolean';
                          };
                          waiting_room: {
                            description: 'When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.\n';
                            type: 'boolean';
                          };
                          waiting_room_settings: {
                            description: 'Specify the settings to be applied if waiting room is enabled.';
                            properties: {
                              participants_to_place_in_waiting_room: {
                                description: '\n\nSpecify who should be admitted to the waiting room. The value of this field can be one of the following:<br>\n`0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in ';
                                enum: [0, 1, 2];
                                type: 'integer';
                              };
                              users_who_can_admit_participants_from_waiting_room: {
                                description: 'Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>\n`0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).\n\n\n';
                                type: 'integer';
                              };
                              whitelisted_domains_for_waiting_room: {
                                description: 'If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          webinar_password: {
                            description: 'If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.\n';
                            type: 'boolean';
                          };
                        };
                        type: 'object';
                      };
                    };
                    title: 'Meeting/Webinar Security Settings';
                    type: 'object';
                  },
                ];
              };
            };
          };
          required: true;
          'x-examples': {
            'application/json': {
              email_notification: {
                alternative_host_reminder: 'boolean';
                cancel_meeting_reminder: 'boolean';
                cloud_recording_avaliable_reminder: 'boolean';
                jbh_reminder: 'boolean';
                low_host_count_reminder: 'boolean';
              };
              feature: {
                meeting_capacity: 'integer';
              };
              in_meeting: {
                alert_guest_join: 'boolean';
                allow_show_zoom_windows: 'boolean';
                annotation: 'boolean';
                anonymous_question_answer: 'boolean';
                attendee_on_hold: 'boolean';
                auto_answer: 'boolean';
                auto_saving_chat: 'boolean';
                breakout_room: 'boolean';
                chat: 'boolean';
                closed_caption: 'boolean';
                co_host: 'boolean';
                dscp_audio: 'integer';
                dscp_marking: 'boolean';
                dscp_video: 'integer';
                e2e_encryption: 'boolean';
                far_end_camera_control: 'boolean';
                feedback: 'boolean';
                group_hd: 'boolean';
                original_audio: 'boolean';
                p2p_connetion: 'boolean';
                p2p_ports: 'boolean';
                polling: 'boolean';
                ports_range: 'string';
                post_meeting_feedback: 'boolean';
                private_chat: 'boolean';
                remote_control: 'boolean';
                screen_sharing: 'boolean';
                sending_default_email_invites: 'boolean';
                show_meeting_control_toolbar: 'boolean';
                stereo_audio: 'boolean';
                use_html_format_email: 'boolean';
                virtual_background: 'boolean';
                watermark: 'boolean';
                webinar_question_answer: 'boolean';
                whiteboard: 'boolean';
              };
              integration: {
                box: 'boolean';
                dropbox: 'boolean';
                google_calendar: 'boolean';
                google_drive: 'boolean';
                kubi: 'boolean';
                microsoft_one_drive: 'boolean';
              };
              recording: {
                account_user_access_recording: 'boolean';
                auto_delete_cmr: 'boolean';
                auto_delete_cmr_days: 'integer';
                auto_recording: 'string';
                cloud_recording: 'boolean';
                cloud_recording_download: 'boolean';
                cloud_recording_download_host: 'boolean';
                local_recording: 'boolean';
                record_audio_file: 'boolean';
                record_gallery_view: 'boolean';
                record_speaker_view: 'boolean';
                recording_audio_transcript: 'boolean';
                save_chat_text: 'boolean';
                show_timestamp: 'boolean';
              };
              schedule_meeting: {
                audio_type: 'string';
                enforce_login: 'boolean';
                enforce_login_domains: 'string';
                enforce_login_with_domains: 'boolean';
                force_pmi_jbh_password: 'boolean';
                host_video: 'boolean';
                join_before_host: 'boolean';
                not_store_meeting_topic: 'boolean';
                participant_video: 'boolean';
                require_password_for_instant_meetings: 'boolean';
                require_password_for_pmi_meetings: 'string';
                require_password_for_scheduled_meetings: 'boolean';
                require_password_for_scheduling_new_meetings: 'boolean';
                use_pmi_for_instant_meetings: 'boolean';
                use_pmi_for_scheduled_meetings: 'boolean';
              };
              security: {
                admin_change_name_pic: 'boolean';
                hide_billing_info: 'boolean';
                import_photos_from_devices: 'boolean';
              };
              telephony: {
                audio_conference_info: 'string';
                third_party_audio: 'boolean';
              };
              tsp: {
                call_out: 'boolean';
                call_out_countries: ['string'];
                display_toll_free_numbers: 'boolean';
                show_international_numbers_link: 'boolean';
              };
              zoom_rooms: {
                auto_start_stop_scheduled_meetings: 'boolean';
                cmr_for_instant_meeting: 'boolean';
                force_private_meeting: 'boolean';
                hide_host_information: 'boolean';
                list_meetings_with_calendar: 'boolean';
                start_airplay_manually: 'boolean';
                ultrasonic: 'boolean';
                upcoming_meeting_alert: 'boolean';
                weekly_system_restart: 'boolean';
                zr_post_meeting_feedback: 'boolean';
              };
            };
          };
        };
        responses: {
          '200': {
            description: '**Error Code:** `200`<br> Only available for Paid account.';
          };
          '204': {
            description: '**HTTP Status Code:** `204` <br>Account settings updated.';
          };
          '300': {
            description: '**Error Code:** `300` <br>The domains provided are invalid. If you are providing multiple domains, separate each domain with a comma.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `2001`<br>Account does not exist: $subAccountId.';
          };
        };
        summary: 'Update settings';
        tags: ['Accounts'];
      };
    };
    '/accounts/{accountId}/settings/virtual_backgrounds': {
      delete: {
        description: 'Delete existing virtual background file(s) from an account. \n\n**Prerequisites:**<br>\n* Virtual background feature must be [enabled](https://support.zoom.us/hc/en-us/articles/210707503-Virtual-Background#h_2ef28080-fce9-4ac2-b567-dc958afab1b7) on the account.\n<br> **Scope:** `account:write:admin`<br> <br> \n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>\n\n';
        operationId: 'delVB';
        parameters: [
          {
            description: 'Provide the id of the file that is to be deleted. To delete multiple files, provide comma separated values for this field.';
            in: 'query';
            name: 'file_ids';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            description: '**HTTP Status Code:** `204` **No Content** <br>\nDeleted.\n';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad request** <br>\n**Error Code:** `300`<br>\nInvalid parameter: file_ids.';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found** <br>\n**Error Code:** `2001`<br>\nThis account does not exist or does not belong to you: {accountId}.';
          };
        };
        summary: 'Delete virtual background files';
        tags: ['Accounts'];
      };
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      post: {
        description: 'Use this API to [upload virtual background files](https://support.zoom.us/hc/en-us/articles/210707503-Virtual-Background#h_01EJF3YFEWGT8YA0ZJ079JEDQE) for all users on the account to use. \n\n\n**Prerequisites:**<br>\n* Virtual background feature must be [enabled](https://support.zoom.us/hc/en-us/articles/210707503-Virtual-Background#h_2ef28080-fce9-4ac2-b567-dc958afab1b7) on the account.\n<br> **Scope:** `account:write:admin`<br><br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>\n\n';
        operationId: 'uploadVB';
        parameters: [
          {
            description: 'Unique identifier of the account.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          $ref: '#/components/requestBodies/uploadVB';
        };
        responses: {
          '201': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      id: '_Tcj7354w6eHw';
                      is_default: false;
                      name: 'u=mdbhhfg3y7&fm=2fdjs0.jpg';
                      size: 53434;
                      type: 'image';
                    };
                  };
                };
                schema: {
                  properties: {
                    id: {
                      description: 'Unique identifier of the file.';
                      type: 'string';
                    };
                    is_default: {
                      description: 'Indicates whether or not this file is the default virtual background file.';
                      type: 'boolean';
                    };
                    name: {
                      description: 'File name.';
                      type: 'string';
                    };
                    size: {
                      description: 'File size.';
                      type: 'string';
                    };
                    type: {
                      description: 'File type.';
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    id: {
                      description: 'Unique identifier of the file.';
                      type: 'string';
                    };
                    is_default: {
                      description: 'Indicates whether or not this file is the default virtual background file.';
                      type: 'boolean';
                    };
                    name: {
                      description: 'File name.';
                      type: 'string';
                    };
                    size: {
                      description: 'File size.';
                      type: 'string';
                    };
                    type: {
                      description: 'File type.';
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `201` **Created** <br>\n';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request** <br>\n**Error Code:** `120`<br>\nNo file uploaded, verify that a file has been uploaded.<br>\nFile size cannot exceed 15M.<br>\nA maximum of 10 files are allowed for a user.<br>\nOnly jpg/jpeg, gif or png image file can be uploaded.\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found** <br>\n**Error Code:** `2001`<br>\nThis account does not exist or does not belong to you: {accountId}.';
          };
        };
        summary: 'Upload virtual background files';
        tags: ['Accounts'];
      };
    };
    '/accounts/{accountId}/sip_trunk/callout_countries': {
      get: {
        description: 'Retrieve the list of internal [call-out](https://support.zoom.us/hc/en-us/articles/200942859-How-To-Use-Telephone-Call-Out-) countries of a master account or a sub account. To list call-out enabled countries of a sub account, provide the account ID of the sub account in the `accountId` path parameter. To list call-out enabled countries of a master account, provide `me` as the value of the `accountId` path parameter.\n<br><b>Prerequisites:</b><br>\n* The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) with SIP Connected Audio Plan.<br><br>\n**Scope:** `sip_trunk:master`';
        operationId: 'listInternalCalloutCountries';
        parameters: [
          {
            description: 'Unique identifier of the account. To list Call-out enabled countries to a sub account, provide the account ID of the sub account in the `accountId` path parameter. To list Call-out enabled countries of a sub account, provide the account ID of the sub account in the `accountId` path parameter. To list Call-out enabled countries of a master account, provide `me` as the value of the `accountId` path parameter.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      callout_countries: [
                        {
                          code: '1';
                          id: 'US';
                          name: 'United States';
                        },
                        {
                          code: '1';
                          id: 'CA';
                          name: 'Canada';
                        },
                      ];
                      total_records: 2;
                    };
                  };
                };
                schema: {
                  properties: {
                    callout_countries: {
                      items: {
                        properties: {
                          code: {
                            description: 'Country code.';
                            type: 'string';
                          };
                          id: {
                            description: 'Two letter country Id.';
                            type: 'string';
                          };
                          name: {
                            description: 'Name of the country.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    total_records: {
                      description: 'The total number of records returned.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    callout_countries: {
                      items: {
                        properties: {
                          code: {
                            description: 'Country code.';
                            type: 'string';
                          };
                          id: {
                            description: 'Two letter country Id.';
                            type: 'string';
                          };
                          name: {
                            description: 'Name of the country.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    total_records: {
                      description: 'The total number of records returned.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200` **OK** <br>\nList of Internal Callout Countries returned.';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request**<br>\n**Error Code:** `300`<br> \n* Your account does not have the permission to make updates on this account. Only a master account can perform this action on a sub account.\n*  Request failed because this account is not enrolled in SIP Connected Audio plan.\n* This account is not a master account. To get access to this API, your account must be enrolled in the API Partner Plan and must be a master account.\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found**<br>\n**Error Code:** `2001`<br> Account does not exist: {0}.';
          };
        };
        summary: 'List internal call-out countries';
        tags: ['SIP Connected Audio'];
      };
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      post: {
        description: 'Specify the list of [call-out](https://support.zoom.us/hc/en-us/articles/200942859-How-To-Use-Telephone-Call-Out-) countries for a master account or a sub account. To add call-out enabled countries to a sub account, provide the account ID of the sub account in the `accountId` path parameter. To add call-out enabled countries to a master account, provide `me` as the value of the `accountId` path parameter.\n<br><b>Prerequisites:</b><br>\n* The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) with SIP Connected Audio Plan.<br><br>\n**Scope:** `sip_trunk:master`';
        operationId: 'addCalloutCountries';
        parameters: [
          {
            description: 'Unique identifier of the account. To add Call-out enabled countries to a sub account, provide the account ID of the sub account in the `accountId` path parameter. To add Call-out enabled countries to a master account, provide `me` as the value of the `accountId` path parameter.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  callout_countries: {
                    description: 'List of callout countries.';
                    items: {
                      properties: {
                        id: {
                          description: 'Two letter country code of the  call-out country.';
                          type: 'string';
                        };
                      };
                      required: ['id'];
                      type: 'object';
                    };
                    maxItems: 30;
                    minItems: 1;
                    type: 'array';
                  };
                };
                required: ['callout_countries'];
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  callout_countries: {
                    description: 'List of callout countries.';
                    items: {
                      properties: {
                        id: {
                          description: 'Two letter country code of the  call-out country.';
                          type: 'string';
                        };
                      };
                      required: ['id'];
                      type: 'object';
                    };
                    maxItems: 30;
                    minItems: 1;
                    type: 'array';
                  };
                };
                required: ['callout_countries'];
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              callout_countries: [
                {
                  id: 'US';
                },
                {
                  id: 'CA';
                },
              ];
            };
          };
        };
        responses: {
          '201': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      callout_countries: [
                        {
                          code: '1';
                          id: 'US';
                          name: 'United States';
                        },
                        {
                          code: '1';
                          id: 'CA';
                          name: 'Canada';
                        },
                      ];
                    };
                  };
                };
                schema: {
                  properties: {
                    callout_countries: {
                      description: 'List of Call-out countries.';
                      items: {
                        properties: {
                          code: {
                            description: 'Country code for Phone number.';
                            type: 'string';
                          };
                          id: {
                            description: 'Country ID.';
                            type: 'string';
                          };
                          name: {
                            description: 'Name of the country.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    callout_countries: {
                      description: 'List of Call-out countries.';
                      items: {
                        properties: {
                          code: {
                            description: 'Country code for Phone number.';
                            type: 'string';
                          };
                          id: {
                            description: 'Country ID.';
                            type: 'string';
                          };
                          name: {
                            description: 'Name of the country.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `201` **Created** <br>\nCall-out countries created.';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request**<br>\n**Error Code:** `300`<br> \n* Your account does not have the permission to make updates on this account. Only a master account can perform this action on a sub account.\n*  Request failed because this account is not enrolled in SIP Connected Audio plan.\n* This account is not a master account. To get access to this API, your account must be enrolled in the API Partner Plan and must be a master account.\n*  Invalid parameter: callout_countries.\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found**<br>\n**Error Code:** `2001`<br> Account does not exist: {0}.\n\n\n';
          };
        };
        summary: 'Add internal call-out countries';
        tags: ['SIP Connected Audio'];
      };
    };
    '/accounts/{accountId}/sip_trunk/callout_countries/{countryId}': {
      delete: {
        description: 'Delete a previously assigned [call-out](https://support.zoom.us/hc/en-us/articles/200942859-How-To-Use-Telephone-Call-Out-) country from a master account or a sub account. To remove call-out country from a sub account, provide the account ID of the sub account in the `accountId` path parameter. To remove call-out country from a master account, provide `me` as the value of the `accountId` path parameter.\n<br><b>Prerequisites:</b><br>\n* The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) with SIP Connected Audio Plan.<br><br>\n**Scope:** `sip_trunk:master`';
        operationId: 'deleteInternalCallOutCountry';
        parameters: [
          {
            description: 'Unique Identifier of the Account.<br>\nTo remove Call-out country from a sub account, provide the account ID of the sub account in the `accountId` path parameter. To remove Call-out country from a master account, provide `me` as the value of the `accountId` path parameter.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Two lettered Id of the country.';
            in: 'path';
            name: 'countryId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `204` **No Content** <br>\nCountry deleted. ';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request**<br>\n**Error Code:** `300`<br> \n* Your account does not have the permission to make updates on this account. Only a master account can perform this action on a sub account.\n*  Request failed because this account is not enrolled in SIP Connected Audio plan.\n* This account is not a master account. To get access to this API, your account must be enrolled in the API Partner Plan and must be a master account.\n\n\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found**<br>\n**Error Code:** `2001`<br> Account does not exist: {0}.';
          };
        };
        summary: 'Delete internal call-out country';
        tags: ['SIP Connected Audio'];
      };
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          in: 'path';
          name: 'countryId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
    };
    '/accounts/{accountId}/sip_trunk/internal_numbers': {
      get: {
        description: 'This API allows a master account with SIP Connected Audio plan to list internal phone numbers (i.e., numbers that are not provided by Zoom but are owned by the organization consuming the API) assigned to a master account or a sub account.<br><br>To list internal numbers of a sub account, provide the account ID of the sub account in the `accountId` path parameter. To list internal numbers of a  master account, provide `me` as the value of the `accountId` path parameter.\n<br><b>Prerequisites:</b><br>\n* The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) with SIP Connected Audio Plan.<br><br>\n**Scope:** `sip_trunk:master`\n\n\n';
        operationId: 'listInternalNumbers';
        parameters: [
          {
            description: 'Unique identifier of the account. To list internal numbers of a sub account, provide the account ID of the sub account in the `accountId` path parameter. To list internal numbers of a  master account, provide `me` as the value of the `accountId` path parameter.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The number of records returned within a single API call.';
            in: 'query';
            name: 'page_size';
            schema: {
              default: 30;
              maximum: 300;
              type: 'integer';
            };
          },
          {
            description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
            in: 'query';
            name: 'next_page_token';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {
                  properties: {
                    internal_numbers: {
                      items: {
                        properties: {
                          allow_for_external_meetings: {
                            description: 'Control whether the number can be used to attend 3rd party meetings.';
                            type: 'boolean';
                          };
                          allow_join: {
                            description: 'Specify whether this number can be used by users to join a meeting or not. <br>\n* `true` : This number can be used to join a meeting. <br>\n*  `false`: This number can not be used to join a meeting. \n\nNote that if the value of `visible` field is set to `true`, the value of this field will always be `true`.';
                            type: 'boolean';
                          };
                          country: {
                            description: 'Two letter country code of the country.';
                            type: 'string';
                          };
                          display_number: {
                            description: 'Phone number with display format. For instance, if the value in the number field is `+1888888000`, the value of this field could be `+1 888 888 000`. ';
                            type: 'string';
                          };
                          labels: {
                            description: 'A short description for the phone number.';
                            type: 'string';
                          };
                          languages: {
                            description: 'Specify the language in which this phone number should be displayed. Currently, the only supported languages are `en-GB`, `en-US`, `de-DE`.';
                            enum: ['en-GB', 'en-US', 'de-DE'];
                            type: 'string';
                          };
                          number: {
                            description: 'Phone number in E164 format.';
                            type: 'string';
                          };
                          type: {
                            description: 'Type of phone number. <br>\nThe value can be one of the following:<br>\n* `0` : toll <br>\n* `1` : tollfree ';
                            enum: [0, 1];
                            type: 'integer';
                          };
                          visible: {
                            description: 'Specify whether you want this number to be visible (in Zoom Client and Zoom Portal) to the account users or not. The value could be one of the following:<br>\n* `true`: Make the number visible. <br>\n* `false`: Hide the number.';
                            type: 'boolean';
                          };
                        };
                        required: ['number', 'display_number', 'country', 'type', 'labels', 'languages'];
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      default: 30;
                      description: 'The number of records that you specified to get in the response per page.';
                      type: 'integer';
                    };
                    total_records: {
                      description: 'The total number of records returned.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    internal_numbers: {
                      items: {
                        properties: {
                          allow_for_external_meetings: {
                            description: 'Control whether the number can be used to attend 3rd party meetings.';
                            type: 'boolean';
                          };
                          allow_join: {
                            description: 'Specify whether this number can be used by users to join a meeting or not. <br>\n* `true` : This number can be used to join a meeting. <br>\n*  `false`: This number can not be used to join a meeting. \n\nNote that if the value of `visible` field is set to `true`, the value of this field will always be `true`.';
                            type: 'boolean';
                          };
                          country: {
                            description: 'Two letter country code of the country.';
                            type: 'string';
                          };
                          display_number: {
                            description: 'Phone number with display format. For instance, if the value in the number field is `+1888888000`, the value of this field could be `+1 888 888 000`. ';
                            type: 'string';
                          };
                          labels: {
                            description: 'A short description for the phone number.';
                            type: 'string';
                          };
                          languages: {
                            description: 'Specify the language in which this phone number should be displayed. Currently, the only supported languages are `en-GB`, `en-US`, `de-DE`.';
                            enum: ['en-GB', 'en-US', 'de-DE'];
                            type: 'string';
                          };
                          number: {
                            description: 'Phone number in E164 format.';
                            type: 'string';
                          };
                          type: {
                            description: 'Type of phone number. <br>\nThe value can be one of the following:<br>\n* `0` : toll <br>\n* `1` : tollfree ';
                            enum: [0, 1];
                            type: 'integer';
                          };
                          visible: {
                            description: 'Specify whether you want this number to be visible (in Zoom Client and Zoom Portal) to the account users or not. The value could be one of the following:<br>\n* `true`: Make the number visible. <br>\n* `false`: Hide the number.';
                            type: 'boolean';
                          };
                        };
                        required: ['number', 'display_number', 'country', 'type', 'labels', 'languages'];
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      default: 30;
                      description: 'The number of records that you specified to get in the response per page.';
                      type: 'integer';
                    };
                    total_records: {
                      description: 'The total number of records returned.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200` **OK**<br>\nList of internal numbers returned.\n';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request**<br>\n**Error Code:** `300`<br> \n* Your account does not have the permission to make updates on this account. Only a master account can perform this action on a sub account.\n* Request failed because this account is not enrolled in SIP Connected Audio plan.\n* This account is not a master account. To get access to this API, your account must be enrolled in the API Partner Plan and must be a master account.\n\n\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found**<br>\n**Error Code:** `2001`<br> Account does not exist: {0}.';
          };
        };
        summary: 'List internal numbers';
        tags: ['SIP Connected Audio'];
      };
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      post: {
        description: 'This API allows a master account with SIP Connected Audio plan to assign internal phone numbers (i.e., numbers that are not provided by Zoom but are owned by the organization consuming the API) to a master account or a sub account.<br><br>To add internal numbers to a sub account, provide the account ID of the sub account in the `accountId` path parameter. To add internal numbers to a master account, provide `me` as the value of the `accountId` path parameter.\n<br><b>Prerequisites:</b><br>\n* The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) with SIP Connected Audio Plan.<br><br>\n**Scope:** `sip_trunk:master`\n\n';
        operationId: 'addInternalNumbers';
        parameters: [
          {
            description: 'Unique identifier of the account.<br>To add internal numbers to a sub account, provide the account ID of the sub account in the `accountId` path parameter. To add internal numbers to a master account, provide `me` as the value of the `accountId` path parameter.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  internal_numbers: {
                    items: {
                      properties: {
                        allow_for_external_meetings: {
                          description: 'Control whether the number can be used to attend 3rd party meetings.';
                          type: 'boolean';
                        };
                        allow_join: {
                          description: 'Specify whether this number can be used by users to join a meeting or not. <br>\n* `true` : This number can be used to join a meeting. <br>\n*  `false`: This number can not be used to join a meeting. \n\nNote that if the value of `visible` field is set to `true`, the value of this field will always be `true`.';
                          type: 'boolean';
                        };
                        country: {
                          description: 'Two letter country code of the country.';
                          type: 'string';
                        };
                        display_number: {
                          description: 'Phone number with display format. For instance, if the value in the number field is `+1888888000`, the value of this field could be `+1 888 888 000`. ';
                          type: 'string';
                        };
                        labels: {
                          description: 'A short description for the phone number.';
                          type: 'string';
                        };
                        languages: {
                          description: 'Specify the language in which this phone number should be displayed. Currently, the only supported languages are `en-GB`, `en-US`, `de-DE`.';
                          enum: ['en-GB', 'en-US', 'de-DE'];
                          type: 'string';
                        };
                        number: {
                          description: 'Phone number in E164 format.';
                          type: 'string';
                        };
                        type: {
                          description: 'Type of phone number. <br>\nThe value can be one of the following:<br>\n* `0` : toll <br>\n* `1` : tollfree ';
                          enum: [0, 1];
                          type: 'integer';
                        };
                        visible: {
                          description: 'Specify whether you want this number to be visible (in Zoom Client and Zoom Portal) to the account users or not. The value could be one of the following:<br>\n* `true`: Make the number visible. <br>\n* `false`: Hide the number.';
                          type: 'boolean';
                        };
                      };
                      required: ['number', 'display_number', 'country', 'type', 'labels', 'languages'];
                      type: 'object';
                    };
                    maxItems: 30;
                    minItems: 1;
                    type: 'array';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  internal_numbers: {
                    items: {
                      properties: {
                        allow_for_external_meetings: {
                          description: 'Control whether the number can be used to attend 3rd party meetings.';
                          type: 'boolean';
                        };
                        allow_join: {
                          description: 'Specify whether this number can be used by users to join a meeting or not. <br>\n* `true` : This number can be used to join a meeting. <br>\n*  `false`: This number can not be used to join a meeting. \n\nNote that if the value of `visible` field is set to `true`, the value of this field will always be `true`.';
                          type: 'boolean';
                        };
                        country: {
                          description: 'Two letter country code of the country.';
                          type: 'string';
                        };
                        display_number: {
                          description: 'Phone number with display format. For instance, if the value in the number field is `+1888888000`, the value of this field could be `+1 888 888 000`. ';
                          type: 'string';
                        };
                        labels: {
                          description: 'A short description for the phone number.';
                          type: 'string';
                        };
                        languages: {
                          description: 'Specify the language in which this phone number should be displayed. Currently, the only supported languages are `en-GB`, `en-US`, `de-DE`.';
                          enum: ['en-GB', 'en-US', 'de-DE'];
                          type: 'string';
                        };
                        number: {
                          description: 'Phone number in E164 format.';
                          type: 'string';
                        };
                        type: {
                          description: 'Type of phone number. <br>\nThe value can be one of the following:<br>\n* `0` : toll <br>\n* `1` : tollfree ';
                          enum: [0, 1];
                          type: 'integer';
                        };
                        visible: {
                          description: 'Specify whether you want this number to be visible (in Zoom Client and Zoom Portal) to the account users or not. The value could be one of the following:<br>\n* `true`: Make the number visible. <br>\n* `false`: Hide the number.';
                          type: 'boolean';
                        };
                      };
                      required: ['number', 'display_number', 'country', 'type', 'labels', 'languages'];
                      type: 'object';
                    };
                    maxItems: 30;
                    minItems: 1;
                    type: 'array';
                  };
                };
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              internal_numbers: [
                {
                  allow_join: true;
                  country: 'US';
                  display_number: '+1 646 666 1110';
                  labels: 'SIP-Internal';
                  languages: 'en-GB';
                  number: '+16466661110';
                  type: 0;
                  visible: true;
                },
              ];
            };
          };
        };
        responses: {
          '201': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      internal_numbers: [
                        {
                          allow_join: true;
                          country: 'US';
                          display_number: '+1 646 666 1110';
                          id: 'A26fhgdfg63';
                          labels: 'SIP-Internal';
                          languages: 'en-GB';
                          number: '+16466661110';
                          type: 0;
                          visible: true;
                        },
                      ];
                    };
                  };
                };
                schema: {
                  properties: {
                    internal_numbers: {
                      items: {
                        properties: {
                          allow_for_external_meetings: {
                            description: 'Control whether the number can be used to attend 3rd party meetings.';
                            type: 'boolean';
                          };
                          allow_join: {
                            description: 'Specify whether this number can be used by users to join a meeting or not. <br>\n* `true` : This number can be used to join a meeting. <br>\n*  `false`: This number can not be used to join a meeting. \n\nNote that if the value of `visible` field is set to `true`, the value of this field will always be `true`.';
                            type: 'boolean';
                          };
                          country: {
                            description: 'Two letter country code of the country.';
                            type: 'string';
                          };
                          display_number: {
                            description: 'Phone number with display format. For instance, if the value in the number field is `+1888888000`, the value of this field could be `+1 888 888 000`. ';
                            type: 'string';
                          };
                          id: {
                            description: 'Unique identifier of the internal number.';
                            type: 'string';
                          };
                          labels: {
                            description: 'A short description for the phone number.';
                            type: 'string';
                          };
                          languages: {
                            description: 'Specify the language in which this phone number should be displayed. Currently, the only supported languages are `en-GB`, `en-US`, `de-DE`.';
                            enum: ['en-GB', 'en-US', 'de-DE'];
                            type: 'string';
                          };
                          number: {
                            description: 'Phone number in E164 format.';
                            type: 'string';
                          };
                          type: {
                            description: 'Type of phone number. <br>\nThe value can be one of the following:<br>\n* `0` : toll <br>\n* `1` : tollfree ';
                            enum: [0, 1];
                            type: 'integer';
                          };
                          visible: {
                            description: 'Specify whether you want this number to be visible (in Zoom Client and Zoom Portal) to the account users or not. The value could be one of the following:<br>\n* `true`: Make the number visible. <br>\n* `false`: Hide the number.';
                            type: 'boolean';
                          };
                        };
                        required: ['number', 'display_number', 'country', 'type', 'labels', 'languages'];
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    internal_numbers: {
                      items: {
                        properties: {
                          allow_for_external_meetings: {
                            description: 'Control whether the number can be used to attend 3rd party meetings.';
                            type: 'boolean';
                          };
                          allow_join: {
                            description: 'Specify whether this number can be used by users to join a meeting or not. <br>\n* `true` : This number can be used to join a meeting. <br>\n*  `false`: This number can not be used to join a meeting. \n\nNote that if the value of `visible` field is set to `true`, the value of this field will always be `true`.';
                            type: 'boolean';
                          };
                          country: {
                            description: 'Two letter country code of the country.';
                            type: 'string';
                          };
                          display_number: {
                            description: 'Phone number with display format. For instance, if the value in the number field is `+1888888000`, the value of this field could be `+1 888 888 000`. ';
                            type: 'string';
                          };
                          id: {
                            description: 'Unique identifier of the internal number.';
                            type: 'string';
                          };
                          labels: {
                            description: 'A short description for the phone number.';
                            type: 'string';
                          };
                          languages: {
                            description: 'Specify the language in which this phone number should be displayed. Currently, the only supported languages are `en-GB`, `en-US`, `de-DE`.';
                            enum: ['en-GB', 'en-US', 'de-DE'];
                            type: 'string';
                          };
                          number: {
                            description: 'Phone number in E164 format.';
                            type: 'string';
                          };
                          type: {
                            description: 'Type of phone number. <br>\nThe value can be one of the following:<br>\n* `0` : toll <br>\n* `1` : tollfree ';
                            enum: [0, 1];
                            type: 'integer';
                          };
                          visible: {
                            description: 'Specify whether you want this number to be visible (in Zoom Client and Zoom Portal) to the account users or not. The value could be one of the following:<br>\n* `true`: Make the number visible. <br>\n* `false`: Hide the number.';
                            type: 'boolean';
                          };
                        };
                        required: ['number', 'display_number', 'country', 'type', 'labels', 'languages'];
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `201` **Created** <br>\nInternal numbers added successfully. \n';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request**<br>\n**Error Code:** `300`<br> \n* Your account does not have the permission to make updates on this account. Only a master account can perform this action on a sub account.\n* Request failed because this account is not enrolled in SIP Connected Audio plan.\n* This account is not a master account. To get access to this API, your account must be enrolled in the API Partner Plan and must be a master account.\n* You can only assign a maximum of {0} phone numbers to this account.\n* The value you provided for the ‘number’ field has already been used. Please provide a unique value for this field.\n* Invalid parameter: internal_numbers.\n\n\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found**<br>\n**Error Code:** `2001`<br> Account does not exist: {0}.\n\n\n\n\n';
          };
        };
        summary: 'Add internal numbers';
        tags: ['SIP Connected Audio'];
      };
    };
    '/accounts/{accountId}/sip_trunk/internal_numbers/{numberId}': {
      delete: {
        description: 'This API allows a master account with SIP Connected Audio plan to delete a previously assigned internal phone number from a master account or a sub account.<br><br>To delete an internal number from a sub account, provide the account ID of the sub account in the `accountId` path parameter. To delete an internal number from a master account, provide `me` as the value of the `accountId` path parameter.\n<br><b>Prerequisites:</b><br>\n* The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) with SIP Connected Audio Plan.<br><br>\n**Scope:** `sip_trunk:master`\n\n\n';
        operationId: 'deleteInternalNumber';
        parameters: [
          {
            description: 'Unique Identifier of the account. To delete an internal number from a sub account, provide the account ID of the sub account in the `accountId` path parameter. To delete an internal number from a master account, provide `me` as the value of the `accountId` path parameter.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Unique identifier of the phone number. This value can be retrieved by calling the List Internal Numbers API.';
            in: 'path';
            name: 'numberId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `204` **No Content** <br>\nNumber deleted.';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request**<br>\n**Error Code:** `300`<br> \n* Your account does not have the permission to make updates on this account. Only a master account can perform this action on a sub account.\n* Request failed because this account is not enrolled in SIP Connected Audio plan.\n* This account is not a master account. To get access to this API, your account must be enrolled in the API Partner Plan and must be a master account.\n\n\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found**<br>\n**Error Code:** `2001`<br> Account does not exist: {0}.';
          };
        };
        summary: 'Delete an internal number';
        tags: ['SIP Connected Audio'];
      };
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          in: 'path';
          name: 'numberId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
    };
    '/accounts/{accountId}/sip_trunk/numbers': {
      delete: {
        description: "With SIP-connected audio, Zoom establishes a SIP trunk (a network connection specifically designed to make and deliver phone calls) over a direct and private connection between the customer’s network and the Zoom cloud. Meeting participants that dial into a meeting or have the meeting call them, and are On-Net from the perspective of the customers' IP telephony network, will be connected over this trunk rather than over the PSTN. <br><br>Use this API to delete all internal numbers assigned to a sub account.\n**Prerequisites:**<br>\n\n* Pro or a higher account with SIP Connected Audio plan enabled.\n* The account must be a master account<br>\n**Scopes:** `sip_trunk:master`<br>\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`";
        operationId: 'deleteAllSipNumbers';
        parameters: [
          {
            description: 'Account ID of the sub account from which the numbers are to be deleted. This can be retrieved from [List sub accounts](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/account) API.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `204` **No Content**<br>\nNumbers deleted successfully.';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request**<br>\n**Error Code:** `2100`<br>\nThis sub account has no sip trunk plan.';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found**<br><br>\n**Error Code:** `2001`<br>\nThis account does not exist or does not belong to this master account.<br>\nThis account does not exist or does not belong to you.<br><br>';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Delete all numbers';
        tags: ['SIP Connected Audio'];
      };
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      post: {
        description: "With SIP-connected audio, Zoom establishes a SIP trunk (a network connection specifically designed to make and deliver phone calls) over a direct and private connection between the customer’s network and the Zoom cloud. Meeting participants that dial into a meeting or have the meeting call them, and are On-Net from the perspective of the customers' IP telephony network, will be connected over this trunk rather than over the PSTN. <br><br>Use this API to assign internal numbers to a sub account.\n\n**Prerequisites:**<br>\n* Pro or a higher account with SIP Connected Audio plan enabled.\n* The account must be a master account<br>\n**Scopes:** `sip_trunk:master`<br> \n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`\n";
        operationId: 'assignSipTrunkNumbers';
        parameters: [
          {
            description: 'Unique Identifier of the sub account.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  phone_numbers: {
                    description: 'Phone number(s) to be assigned to the sub account.';
                    items: {
                      type: 'string';
                    };
                    type: 'array';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  phone_numbers: {
                    description: 'Phone number(s) to be assigned to the sub account.';
                    items: {
                      type: 'string';
                    };
                    type: 'array';
                  };
                };
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              phone_numbers: ['34555665654', '10004350500', '000000000'];
            };
          };
        };
        responses: {
          '201': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `201` **Created**<br>\nNumbers assigned successfully.\n';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request**<br>\n**Error Code:** `2100`<br>\nThis sub account has no sip trunk plan.<br><br>\n**Error Code:** `400`<br>\nThis number does not belong to master account.\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found**<br><br>\n**Error Code:** `2001`<br>\nThis account does not exist or does not belong to this master account.<br>\nThis account does not exist or does not belong to you.\n';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Assign numbers';
        tags: ['SIP Connected Audio'];
      };
    };
    '/accounts/{accountId}/sip_trunk/settings': {
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      patch: {
        description: "With SIP-connected audio, Zoom establishes a SIP trunk (a network connection specifically designed to make and deliver phone calls) over a direct and private connection between the customer’s network and the Zoom cloud. Meeting participants that dial into a meeting or have the meeting call them, and are On-Net from the perspective of the customers' IP telephony network, will be connected over this trunk rather than over the PSTN. <br><br> Using this API, a master account owner can copy the SIP Connected Audio configurations applied on the master account and enable those configurations on a sub account. The owner can also disable the configuration in the sub account where it was previously enabled. \n**Prerequisites:**<br>\n* Pro or a higher account with SIP Connected Audio plan enabled.\n* master account Owner<br>\n**Scopes:** `sip_trunk:master`<br> \n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`";
        operationId: 'assignSIPConfig';
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  enable: {
                    description: 'Enable or delete the configuration.<br> The values can be one of the following:<br> `true`: Enable configuration.<br> `false`: Delete configuration';
                    type: 'boolean';
                  };
                  show_callout_internal_number: {
                    description: "If the value of this option is set to `true`, the call-out numbers provided by the Zoom carrier partners will be displayed in the account's list of available call-out numbers in the Zoom Web Portal and Zoom Client.";
                    type: 'boolean';
                  };
                  show_zoom_provided_callout_countries: {
                    description: "If the value of this option is set to `0`, the call-out countries list provided by Zoom will be [displayed](https://support.zoom.us/hc/en-us/articles/200942859-Using-telephone-call-out) in the account's list of available call-out countries. \n\nIf the value of this option is set to `1`, the Zoom provided call-out countries will be hidden from the user's account.<br> \n\nIf the value of this option is set to `2`, all Zoom provided countries will be deleted and only internal countries (provided by carrier partners) will be used.";
                    type: 'integer';
                  };
                  show_zoom_provided_numbers: {
                    description: "If the value of this option is set to `0`, the numbers provided by Zoom will be displayed in the account's list of available call-out and call-in numbers in the Zoom Web Portal and Zoom Client. \n\nIf the value of this option is set to `1`, the Zoom provided numbers will be shown in the Zoom Web Portal but will not be used unless specified by the user.<br> \n\nIf the value of this option is set to `2`, all Zoom provided numbers will be deleted and only internal numbers (provided by carrier partners) will be used.";
                    enum: [0, 1, 2];
                    type: 'integer';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  enable: {
                    description: 'Enable or delete the configuration.<br> The values can be one of the following:<br> `true`: Enable configuration.<br> `false`: Delete configuration';
                    type: 'boolean';
                  };
                  show_callout_internal_number: {
                    description: "If the value of this option is set to `true`, the call-out numbers provided by the Zoom carrier partners will be displayed in the account's list of available call-out numbers in the Zoom Web Portal and Zoom Client.";
                    type: 'boolean';
                  };
                  show_zoom_provided_callout_countries: {
                    description: "If the value of this option is set to `0`, the call-out countries list provided by Zoom will be [displayed](https://support.zoom.us/hc/en-us/articles/200942859-Using-telephone-call-out) in the account's list of available call-out countries. \n\nIf the value of this option is set to `1`, the Zoom provided call-out countries will be hidden from the user's account.<br> \n\nIf the value of this option is set to `2`, all Zoom provided countries will be deleted and only internal countries (provided by carrier partners) will be used.";
                    type: 'integer';
                  };
                  show_zoom_provided_numbers: {
                    description: "If the value of this option is set to `0`, the numbers provided by Zoom will be displayed in the account's list of available call-out and call-in numbers in the Zoom Web Portal and Zoom Client. \n\nIf the value of this option is set to `1`, the Zoom provided numbers will be shown in the Zoom Web Portal but will not be used unless specified by the user.<br> \n\nIf the value of this option is set to `2`, all Zoom provided numbers will be deleted and only internal numbers (provided by carrier partners) will be used.";
                    enum: [0, 1, 2];
                    type: 'integer';
                  };
                };
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              enable: true;
              show_callout_internal_number: true;
              show_zoom_provided_callout_countries: 0;
              show_zoom_provided_numbers: 2;
            };
          };
        };
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `204` **No Content**<br>\nConfiguration assigned successfully.\n';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request**<br>\n**Error Code:** `2100`<br>\nThis sub account has no sip trunk plan.';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found**<br><br>\n**Error Code:** `2001`<br>\nThis account does not exist or does not belong to this master account.<br>\nThis account does not exist or does not belong to you.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Assign SIP trunk configuration';
        tags: ['SIP Connected Audio'];
      };
    };
    '/accounts/{accountId}/sip_trunk/trunks': {
      get: {
        description: 'With SIP-connected audio, Zoom establishes a SIP trunk (a network connection specifically designed to make and deliver phone calls) over a direct and private connection between the customer’s network and the Zoom cloud. Meeting participants that dial into a meeting or have the meeting call them, and are On-Net from the perspective of the customers’ IP telephony network, will be connected over this trunk rather than over the PSTN.<br><br>\nUse this API to list all the SIP trunks assigned to a master account or a sub account of the master account. To retrieve SIP trunks assigned to a sub account, provide the account ID of the sub account in the `accountId` path parameter. To retrieve SIP trunks of a master account, provide `me` as the value of the `accountId` path parameter. <br><br> **Scope:** `sip_trunk:read:admin`\n<br><b>Prerequisites:</b><br>\n* The account must either be a master account or a sub account with [API Partner Plan](https://zoom.us/plan/api) and SIP Connected Audio Plan.';
        operationId: 'listSIPTrunks';
        parameters: [
          {
            description: 'Unique Identifier of the Account. To retrieve SIP trunks assigned to a sub account, provide the account ID of the sub account in the as the value of this field. To retrieve SIP trunks of a master account, provide `me` as the value of this field.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      sip_trunks: [
                        {
                          dnis: '90001258';
                          id: '268';
                          name: 'test1';
                          number_prefix: '0';
                          sip_server_address: '111.111.1.1';
                        },
                        {
                          dnis: '80001748';
                          id: '281';
                          name: 'test2';
                          number_prefix: '0';
                          sip_server_address: '111.111.1.34';
                        },
                      ];
                      total_records: 1;
                    };
                  };
                };
                schema: {
                  properties: {
                    sip_trunks: {
                      items: {
                        properties: {
                          dnis: {
                            description: 'DNIS of the SIP trunk.';
                            type: 'string';
                          };
                          id: {
                            description: 'Unique identifier of the sip trunk.';
                            type: 'string';
                          };
                          name: {
                            description: 'Name assigned to the SIP trunk.';
                            type: 'string';
                          };
                          number_prefix: {
                            description: 'Prefix of the SIP Connected Audio phone number.';
                            type: 'string';
                          };
                          outbound_caller_id: {
                            description: 'Outbound caller Id assigned to the trunk.';
                            type: 'string';
                          };
                          sip_server_address: {
                            description: 'IP address or domain of the SIP trunk.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    total_records: {
                      description: 'Total number of records returned. ';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    sip_trunks: {
                      items: {
                        properties: {
                          dnis: {
                            description: 'DNIS of the SIP trunk.';
                            type: 'string';
                          };
                          id: {
                            description: 'Unique identifier of the sip trunk.';
                            type: 'string';
                          };
                          name: {
                            description: 'Name assigned to the SIP trunk.';
                            type: 'string';
                          };
                          number_prefix: {
                            description: 'Prefix of the SIP Connected Audio phone number.';
                            type: 'string';
                          };
                          outbound_caller_id: {
                            description: 'Outbound caller Id assigned to the trunk.';
                            type: 'string';
                          };
                          sip_server_address: {
                            description: 'IP address or domain of the SIP trunk.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    total_records: {
                      description: 'Total number of records returned. ';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200` **OK**<br>\nList of SIP Trunks returned.';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request**<br>\n**Error Code:** `300`<br> Request failed because this account is not enrolled in SIP Connected Audio plan.\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found**<br>\n**Error Code:** `2001`<br> Account does not exist: {0}.\n\n';
          };
        };
        summary: 'List SIP trunks';
        tags: ['SIP Connected Audio'];
      };
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      post: {
        description: 'With SIP-connected audio, Zoom establishes a SIP trunk (a network connection specifically designed to make and deliver phone calls) over a direct and private connection between the customer’s network and the Zoom cloud. Meeting participants that dial into a meeting or have the meeting call them, and are On-Net from the perspective of the customers’ IP telephony network, will be connected over this trunk rather than over the PSTN.<br><br>Use this API to assign SIP trunk(s) that are available on a master account to a sub account. <br><b>Prerequisites:</b><br>\n* The account making this API request must be a master account with [API Partner Plan](https://zoom.us/plan/api) and SIP Connected Audio Plan.<br><br>\n**Scope:** `sip_trunk:master`';
        operationId: 'assignSIPTrunks';
        parameters: [
          {
            description: 'Unique Identifier of the sub account.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  sip_trunks: {
                    description: 'Array of one or more SIP Trunk objects. ';
                    items: {
                      properties: {
                        dnis: {
                          description: 'DNIS of the sub account. The prefix of the DNIS (i.e. the first five digits of the DNIS value) must match the DNIS prefix of the master account. To retrieve the DNIS prefix of a master account\'s SIP Trunk, use the List SIP Trunks API and refer to the first five digits in the `dnis` value. \n\nFor example, if the DNIS of the master account is 1888812345, the DNIS of the sub account must comprise of "18888" + "random_number". The maximum allowed length of the DNIS is 8.';
                          maxLength: 8;
                          minLength: 5;
                          type: 'string';
                        };
                        id: {
                          description: 'Unique identifier of the SIP trunk that will be assigned to the sub account. The value of this field can be retrieved by listing the SIP Trunks of a master account using List SIP Trunks API.';
                          type: 'string';
                        };
                        outbound_caller_id: {
                          description: 'Assign an outbound caller Id to the trunk.';
                          maxLength: 32;
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    maxItems: 30;
                    minItems: 1;
                    type: 'array';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  sip_trunks: {
                    description: 'Array of one or more SIP Trunk objects. ';
                    items: {
                      properties: {
                        dnis: {
                          description: 'DNIS of the sub account. The prefix of the DNIS (i.e. the first five digits of the DNIS value) must match the DNIS prefix of the master account. To retrieve the DNIS prefix of a master account\'s SIP Trunk, use the List SIP Trunks API and refer to the first five digits in the `dnis` value. \n\nFor example, if the DNIS of the master account is 1888812345, the DNIS of the sub account must comprise of "18888" + "random_number". The maximum allowed length of the DNIS is 8.';
                          maxLength: 8;
                          minLength: 5;
                          type: 'string';
                        };
                        id: {
                          description: 'Unique identifier of the SIP trunk that will be assigned to the sub account. The value of this field can be retrieved by listing the SIP Trunks of a master account using List SIP Trunks API.';
                          type: 'string';
                        };
                        outbound_caller_id: {
                          description: 'Assign an outbound caller Id to the trunk.';
                          maxLength: 32;
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    maxItems: 30;
                    minItems: 1;
                    type: 'array';
                  };
                };
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              sip_trunks: [
                {
                  dnis: '12345678';
                  id: '133';
                },
              ];
            };
          };
        };
        responses: {
          '201': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      sip_trunks: [
                        {
                          dnis: 'dolore43tr4u';
                          id: 'represdf324fe';
                          name: 'HQ-trunk';
                          number_prefix: '0';
                          sip_server_address: '1.11.123.123';
                        },
                      ];
                    };
                  };
                };
                schema: {
                  properties: {
                    sip_trunks: {
                      items: {
                        properties: {
                          dnis: {
                            description: 'DNIS - identifier for the SIP trunk enabled account.';
                            type: 'string';
                          };
                          id: {
                            description: 'Unique identifier of the SIP trunk.';
                            type: 'string';
                          };
                          name: {
                            description: 'Name of the SIP trunk.';
                            type: 'string';
                          };
                          number_prefix: {
                            description: 'If the value of this field is `"0"`, it means that all the calls will be routed through this special line. All other values indicate the prefix of the phone number.';
                            type: 'string';
                          };
                          sip_server_address: {
                            description: 'IP Address or domain of the SIP trunk.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    sip_trunks: {
                      items: {
                        properties: {
                          dnis: {
                            description: 'DNIS - identifier for the SIP trunk enabled account.';
                            type: 'string';
                          };
                          id: {
                            description: 'Unique identifier of the SIP trunk.';
                            type: 'string';
                          };
                          name: {
                            description: 'Name of the SIP trunk.';
                            type: 'string';
                          };
                          number_prefix: {
                            description: 'If the value of this field is `"0"`, it means that all the calls will be routed through this special line. All other values indicate the prefix of the phone number.';
                            type: 'string';
                          };
                          sip_server_address: {
                            description: 'IP Address or domain of the SIP trunk.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `204` **No Content**<br>\nSIP Trunk assigned successfully.';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request**<br>\n**Error Code:** `300`<br> \n* Request failed because this account is not enrolled in SIP Connected Audio plan.<br>\n* The master account has no sip trunk configs.<br>\n* Invalid parameter: sip_trunks.\n\n\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found**<br>\n**Error Code:** `2001`<br> Account does not exist: {0}.\n\n\n';
          };
        };
        summary: 'Assign SIP trunks';
        tags: ['SIP Connected Audio'];
      };
    };
    '/accounts/{accountId}/sip_trunk/trunks/{trunkId}': {
      delete: {
        description: 'Use this API to remove existing SIP trunk of a sub account.<br>\n<br><b>Prerequisites:</b><br>\n* The account making this API request must be a master account with [API Partner Plan](https://zoom.us/plan/api) and SIP Connected Audio Plan.<br><br>\n**Scope:** `sip_trunk:master`';
        operationId: 'deleteSIPTrunk';
        parameters: [
          {
            description: 'Unique identifier of the sub account.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Unique identifier of the SIP Trunk that was previously assigned to a sub account. To retrieve the value of this field, use the List SIP Trunks API.';
            in: 'path';
            name: 'trunkId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {
                  properties: {};
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {};
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `204` **No Content**<br>\nSIP Trunk deleted.';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad Request**<br>\n**Error Code:** `300`<br> \n* Request failed because this account is not enrolled in SIP Connected Audio plan.<br>\n* Your account does not have the permission to make updates on this account. Only a master account can perform this action on a sub account.';
          };
          '404': {
            description: '**HTTP Status Code:** `404` **Not Found**<br>\n**Error Code:** `2001`<br> Account does not exist: {0}.\n\n\n\n';
          };
        };
        summary: 'Delete a SIP trunk';
        tags: ['SIP Connected Audio'];
      };
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          in: 'path';
          name: 'trunkId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
    };
    '/accounts/{accountId}/trusted_domains': {
      get: {
        description: 'Get trusted domains of a sub account. To get the trusted domains of a master account, use `me` as the value for the `accountId` path parameter.\n\n**Prerequisites:**<br>\n* The sub account must be a paid account.<br>\n**Scope:** `account:read:admin`<br>\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`';
        operationId: 'accountTrustedDomain';
        parameters: [
          {
            description: 'The account ID.';
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {
                  properties: {
                    trusted_domains: {
                      description: 'List of trusted domains';
                      items: {
                        type: 'string';
                      };
                      type: 'array';
                    };
                  };
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    trusted_domains: {
                      description: 'List of trusted domains';
                      items: {
                        type: 'string';
                      };
                      type: 'array';
                    };
                  };
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br>\nAccount trusted domains returned<br>\n**Error Code:** `2001`<br> Account does not exist: $subAccountId.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `2001`<br> Account does not exist: $subAccountId.';
          };
        };
        summary: 'Get trusted domains';
        tags: ['Accounts'];
      };
    };
    '/accounts/{accountId}/users/{userId}/account': {
      parameters: [
        {
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      put: {
        description: 'Disassociate a user from one Account and move the user to another Account under the same master account. \n\nWith this API, a user under a master account or a sub account can be moved to another sub account within the same master account. To move a user from a master account to a sub account, use `me` as the value for `accountId`. In this scenario, "me" refers to the Account ID of the master account. \n\nTo move a user from one sub account to another sub account, provide the sub account\'s Account ID as the value for `accountId`. \n\n**Prerequisites**:\n* The account should have Pro or a higher plan with master account option enabled.\n* The user whose account needs to be switched should not be an admin or an owner of that account.\n* The user should not have the same [managed domain](https://support.zoom.us/hc/en-us/articles/203395207-What-is-Managed-Domain-) as the account owner.\n\n**Scope:** `user:master`<br> \n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`';
        operationId: 'switchUserAccount';
        parameters: [
          {
            in: 'path';
            name: 'accountId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  account_id: {
                    description: 'The Account ID of the account to which you would like move the user to.';
                    type: 'string';
                  };
                };
                required: ['account_id'];
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  account_id: {
                    description: 'The Account ID of the account to which you would like move the user to.';
                    type: 'string';
                  };
                };
                required: ['account_id'];
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              account_id: 'ABCDEF0G0YxBBB';
            };
          };
        };
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: "**HTTP Status Code**: `204`<br>\nUser's account switched successfully.";
          };
          '400': {
            description: '**HTTP Status Code**: `400` **Bad Request**<br>\n**Error Code:** `1117`<br> Can not disassociate Admin user';
          };
          '404': {
            description: '**HTTP Status Code**: `404` **Not Found**<br>\n\n**Error Code:** `1001`<br>\nUser {userId} does not exist or does not belong to this account.<br><br>\n\n**Error Code:** `1010`<br>\nUser not found on this account.<br>\n\n**Error Code:** `1120`<br> Invite not exist\n\t\n\n';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: "Switch a user's account";
        tags: ['Users'];
      };
    };
    '/api/download/billing/invoices/{invoiceId}': {
      get: {
        description: "Download a [billed](https://support.zoom.us/hc/en-us/articles/201363263-About-Billing) invoice file of a Zoom account in PDF format. To download a regular account's invoice or a  master account's invoice, provide `me` as the value of `accountId` path parameter. To download a sub account's invoice, provide the account ID of the sub account in the `accountId` path parameter. \n\n\n**Prerequisites:**\n* Account must be enrolled in Pro or a higher plan.<br>\n\n**Scope**:`billing:master`<br>\n**Rate Limit:** You can make **one** request to this API every **thirty** minutes until the daily limit is reached. This API has a daily limit of **100** requests per **account**.";
        operationId: 'downloadInvoicePDF';
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `200`<br>\nAccount billing invoice PDF returned.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `2001`<br>\nAccount does not exist: {subAccountId}.<br>';
          };
        };
        summary: 'Download an invoice file';
        tags: ['Billing'];
      };
      parameters: [
        {
          in: 'path';
          name: 'invoiceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
    };
    '/archive_files': {
      get: {
        description: 'Zoom’s [archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) allows account administrators to set up an automated mechanism to record, collect and archive meeting data to a 3rd party platform of their choice and hence, satisfy FINRA and/ or other compliance requirements.<br><br>\nUse this API to retrieve archived meeting or webinar files of an account.\n\n**Scope:** `recording:read:admin`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br><br>\n**Prerequisites:** <br>\n* Enable cloud recording.\n* Follow the [enablement process](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data#h_01ENPBD3WR68D7FAKTBY92SG45) to access the archiving feature.';
        operationId: 'listArchivedFiles';
        parameters: [
          {
            description: 'The number of records returned within a single API call.';
            in: 'query';
            name: 'page_size';
            schema: {
              default: 30;
              maximum: 300;
              type: 'integer';
            };
          },
          {
            description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
            in: 'query';
            name: 'next_page_token';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Start date for the query in "yyyy-MM-dd\'T\'HH:mm:ss\'Z\'" format. The duration for the query defined using the "from" and "to" parameters should not exceed 7 days as this API only provides a week\'s data at once.';
            in: 'query';
            name: 'from';
            schema: {
              type: 'string';
            };
          },
          {
            description: "End date for the query in \"yyyy-MM-dd'T'HH:mm:ss'Z'\" format. ";
            in: 'query';
            name: 'to';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Query data type for `from` and `to`.';
            in: 'query';
            name: 'query_data_type';
            schema: {
              default: 'meeting_start_time';
              enum: ['meeting_start_time', 'archive_complete_time'];
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      from: '2021-03-11T05:41:36Z';
                      meetings: [
                        {
                          archive_files: [
                            {
                              download_url: 'https://zoom.us/rec/archive/download/snGardfsw3435SKIsXAMhJ6wh';
                              file_extension: 'M4A';
                              file_size: 165743;
                              file_type: 'M4A';
                              id: '55hfgsd-sd8e2bd7255';
                              recording_type: 'audio_only';
                              status: 'completed';
                            },
                            {
                              download_url: 'https://zoom.us/rec/archive/download/eXy782Ua9dghjhPvao.bUFwLAgQrFOjfOjr';
                              file_extension: 'MP4';
                              file_size: 198720;
                              file_type: 'MP4';
                              id: '9c5daa5b-34a1-40e8-8947-a11be5e373a7';
                              recording_type: 'shared_screen_with_speaker_view';
                              status: 'completed';
                            },
                          ];
                          duration: 3;
                          host_id: 'Dhjdfgdkg8w';
                          id: 553068284;
                          recording_count: 2;
                          start_time: '2021-03-12T01:57:27Z';
                          timezone: '';
                          topic: 'Zoom Meeting';
                          total_size: 364463;
                          type: 1;
                          uuid: 'yO3dfhh3t467UkQ==';
                        },
                      ];
                      next_page_token: '';
                      page_size: 30;
                      to: '2021-03-18T05:41:36Z';
                    };
                  };
                };
                schema: {
                  properties: {
                    from: {
                      description: 'Start date for the query in "yyyy-MM-dd\'T\'HH:mm:ss\'Z\'" format. The duration for the query defined using the "from" and "to" parameters should not exceed 7 days as this API only provides a week\'s data at once.';
                      type: 'string';
                    };
                    meetings: {
                      items: {
                        properties: {
                          archive_files: {
                            items: {
                              properties: {
                                download_url: {
                                  description: 'The URL using which the archived file can be downloaded. To download the archived file of a meeting or a webinar hosted in your account, create a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the access_token query parameter and include this query parameter at the end of the URL as shown in the example.\n \nExample: `https://{{base-domain}}/rec/archive/download/xxx?access_token={{Your-JWT}}`\n\nIf a user has authorized and installed your OAuth app that supports archiving, use the user’s [OAuth access token](https://marketplace.zoom.us/docs/guides/auth/oauth) to download the file.\n\nExample: `https://{{base-domain}}/rec/archive/download/xxx?access_token={{ OAuth Access Token }}`';
                                  type: 'string';
                                };
                                file_extension: {
                                  description: 'Extension of the recording file.\n';
                                  type: 'string';
                                };
                                file_size: {
                                  description: 'The recording file size.\n';
                                  type: 'integer';
                                };
                                file_type: {
                                  description: 'Recorded file type. The value of this field could be one of the following:\n\n`MP4`: Video file of the recording.<br>\n`M4A`: Audio-only file of the recording.<br>\n`TRANSCRIPT`: Transcription file of the recording in VTT format.\nCHAT: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>\n`CC`: File containing closed captions of the recording in VTT file format.<br>\n`CSV`: File containing polling data in csv format.';
                                  type: 'string';
                                };
                                id: {
                                  description: 'Unique identifier of the archived file.\n';
                                  type: 'string';
                                };
                                recording_type: {
                                  description: 'The recording type. The value of this field can be one of the following:\n* `shared_screen_with_speaker_view(CC)`\n* `shared_screen_with_speaker_view`\n* `shared_screen_with_gallery_view`\n* `speaker_view`\n* `gallery_view`\n* `shared_screen`\n* `audio_only`\n* `audio_transcript`\n* `chat_file`,\n* `active_speaker`\n* `host_video`\n';
                                  type: 'string';
                                };
                                status: {
                                  description: 'Status of the archived file.\n';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                          duration: {
                            description: 'Scheduled duration of the meeting or the webinar.';
                            type: 'integer';
                          };
                          host_id: {
                            description: 'ID of the user set as the host of meeting or the webinar that was archived.\n';
                            type: 'string';
                          };
                          id: {
                            description: 'Unique identifier of the meeting(meetingId) or the webinar(webinarId).\n';
                            type: 'integer';
                          };
                          recording_count: {
                            description: 'Number of recording files returned in the response of this API call.\n';
                            type: 'integer';
                          };
                          start_time: {
                            description: 'The time at which the meeting or the webinar started.\n';
                            type: 'string';
                          };
                          timezone: {
                            description: 'Timezone of the host.';
                            type: 'string';
                          };
                          topic: {
                            description: 'Meeting or webinar topic.';
                            type: 'string';
                          };
                          total_size: {
                            description: 'Total size of the archive.\n';
                            type: 'integer';
                          };
                          type: {
                            description: 'Type of the meeting or the webinar that was archived.<br>\n<br>Meeting types:<br>\n`1` - Instant meeting<br>\n`2` - Scheduled meeting<br>\n`3` - Recurring meeting with no fixed time<br>\n8 - Recurring meeting with fixed time\n \nWebinar types:<br>\n`5` - Webinar<br>\n`6` - Recurring webinar with no fixed time<br>\n`9` - Recurring webinar with a fixed time\n';
                            type: 'integer';
                          };
                          uuid: {
                            description: 'Unique identifier of the meeting instance or the webinar instance during which the archiving took place. Each instance of the meeting will have its own UUID.\n';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      description: 'The number of records returned within a single API call.';
                      type: 'integer';
                    };
                    to: {
                      description: "End date for the query in \"yyyy-MM-dd'T'HH:mm:ss'Z'\" format. ";
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    from: {
                      description: 'Start date for the query in "yyyy-MM-dd\'T\'HH:mm:ss\'Z\'" format. The duration for the query defined using the "from" and "to" parameters should not exceed 7 days as this API only provides a week\'s data at once.';
                      type: 'string';
                    };
                    meetings: {
                      items: {
                        properties: {
                          archive_files: {
                            items: {
                              properties: {
                                download_url: {
                                  description: 'The URL using which the archived file can be downloaded. To download the archived file of a meeting or a webinar hosted in your account, create a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the access_token query parameter and include this query parameter at the end of the URL as shown in the example.\n \nExample: `https://{{base-domain}}/rec/archive/download/xxx?access_token={{Your-JWT}}`\n\nIf a user has authorized and installed your OAuth app that supports archiving, use the user’s [OAuth access token](https://marketplace.zoom.us/docs/guides/auth/oauth) to download the file.\n\nExample: `https://{{base-domain}}/rec/archive/download/xxx?access_token={{ OAuth Access Token }}`';
                                  type: 'string';
                                };
                                file_extension: {
                                  description: 'Extension of the recording file.\n';
                                  type: 'string';
                                };
                                file_size: {
                                  description: 'The recording file size.\n';
                                  type: 'integer';
                                };
                                file_type: {
                                  description: 'Recorded file type. The value of this field could be one of the following:\n\n`MP4`: Video file of the recording.<br>\n`M4A`: Audio-only file of the recording.<br>\n`TRANSCRIPT`: Transcription file of the recording in VTT format.\nCHAT: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>\n`CC`: File containing closed captions of the recording in VTT file format.<br>\n`CSV`: File containing polling data in csv format.';
                                  type: 'string';
                                };
                                id: {
                                  description: 'Unique identifier of the archived file.\n';
                                  type: 'string';
                                };
                                recording_type: {
                                  description: 'The recording type. The value of this field can be one of the following:\n* `shared_screen_with_speaker_view(CC)`\n* `shared_screen_with_speaker_view`\n* `shared_screen_with_gallery_view`\n* `speaker_view`\n* `gallery_view`\n* `shared_screen`\n* `audio_only`\n* `audio_transcript`\n* `chat_file`,\n* `active_speaker`\n* `host_video`\n';
                                  type: 'string';
                                };
                                status: {
                                  description: 'Status of the archived file.\n';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                          duration: {
                            description: 'Scheduled duration of the meeting or the webinar.';
                            type: 'integer';
                          };
                          host_id: {
                            description: 'ID of the user set as the host of meeting or the webinar that was archived.\n';
                            type: 'string';
                          };
                          id: {
                            description: 'Unique identifier of the meeting(meetingId) or the webinar(webinarId).\n';
                            type: 'integer';
                          };
                          recording_count: {
                            description: 'Number of recording files returned in the response of this API call.\n';
                            type: 'integer';
                          };
                          start_time: {
                            description: 'The time at which the meeting or the webinar started.\n';
                            type: 'string';
                          };
                          timezone: {
                            description: 'Timezone of the host.';
                            type: 'string';
                          };
                          topic: {
                            description: 'Meeting or webinar topic.';
                            type: 'string';
                          };
                          total_size: {
                            description: 'Total size of the archive.\n';
                            type: 'integer';
                          };
                          type: {
                            description: 'Type of the meeting or the webinar that was archived.<br>\n<br>Meeting types:<br>\n`1` - Instant meeting<br>\n`2` - Scheduled meeting<br>\n`3` - Recurring meeting with no fixed time<br>\n8 - Recurring meeting with fixed time\n \nWebinar types:<br>\n`5` - Webinar<br>\n`6` - Recurring webinar with no fixed time<br>\n`9` - Recurring webinar with a fixed time\n';
                            type: 'integer';
                          };
                          uuid: {
                            description: 'Unique identifier of the meeting instance or the webinar instance during which the archiving took place. Each instance of the meeting will have its own UUID.\n';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      description: 'The number of records returned within a single API call.';
                      type: 'integer';
                    };
                    to: {
                      description: "End date for the query in \"yyyy-MM-dd'T'HH:mm:ss'Z'\" format. ";
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200` **OK**\nArchived files returned.\n';
          };
          '400': {
            description: '**HTTP Status Code:** `400` **Bad request**<br>\n**Error Code:** `2001`<br>\nAccount does not exist: {accountId}.';
          };
        };
        summary: 'List archived files';
        tags: ['Cloud Recording'];
      };
    };
    '/chat/channels/{channelId}': {
      delete: {
        description: 'Zoom chat [channels](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) allow users to communicate via chat in private or public groups. Use this API to delete a specific channel. \n\n**Scope:** `chat_channel:write`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`\n\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>\n\n\n ';
        operationId: 'deleteUserLevelChannel';
        parameters: [
          {
            description: 'Channel ID: Unique Identifier of a channel.';
            in: 'path';
            name: 'channelId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `204`<br>\nChannel deleted.';
          };
          '400': {
            description: "**HTTP Status Code:** `400`<br> Bad request.<br>\n**Error Code:** `200`<br>\nUnauthorized request. You do not have permission to delete this user's channel.<br>\n**Error Code:** `5301`<br> Request to delete a channel failed.";
          };
        };
        summary: 'Delete a channel';
        tags: ['Chat Channels'];
      };
      get: {
        description: 'Zoom chat [channels](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) allow users to communicate via chat in private or public groups. Use this API to get information about a specific channel. \n\n**Scope:** `chat_channel:read`\t<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`\n\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>\n\n\n ';
        operationId: 'getUserLevelChannel';
        parameters: [
          {
            description: 'Channel ID: Unique Identifier of a channel.';
            in: 'path';
            name: 'channelId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      id: 'ut1234sgfsdf';
                      name: 'Leah';
                      type: 1;
                    };
                  };
                };
                schema: {
                  description: 'The channel object represents a Zoom chat [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-). ';
                  properties: {
                    id: {
                      description: 'Channel Id.';
                      type: 'string';
                    };
                    name: {
                      description: 'Name of the channel.';
                      maxLength: 128;
                      type: 'string';
                    };
                    type: {
                      description: 'Type of the channel. The value can be one of the following:<br>\n`1`: Private channel. In this type of channel, members must be invited to join a channel.<br>\n`2`: Private channel with members that belong to one Zoom account. Members in this channel should be invited and the members should be from the same organization.<br>\n`3`: Public channel. Anyone can search for this channel and join the channel.<br>';
                      enum: [1, 2, 3];
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  description: 'The channel object represents a Zoom chat [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-). ';
                  properties: {
                    id: {
                      description: 'Channel Id.';
                      type: 'string';
                    };
                    name: {
                      description: 'Name of the channel.';
                      maxLength: 128;
                      type: 'string';
                    };
                    type: {
                      description: 'Type of the channel. The value can be one of the following:<br>\n`1`: Private channel. In this type of channel, members must be invited to join a channel.<br>\n`2`: Private channel with members that belong to one Zoom account. Members in this channel should be invited and the members should be from the same organization.<br>\n`3`: Public channel. Anyone can search for this channel and join the channel.<br>';
                      enum: [1, 2, 3];
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br>\nChannel returned.<br>\n\n\n\n';
          };
          '400': {
            description: "**HTTP Status Code:** `400`<br>\nBad Request<br>\n**Error Code:** `200`<br>\nUnauthorized request. You do not have permission to access this user's channel information.";
          };
          '404': {
            description: '**Status Code:** `404`<br>\nNot found.<br>\n**Error Code:** `4130`<br>\nChannel does not exist: $channelId.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Get a channel';
        tags: ['Chat Channels'];
      };
      parameters: [
        {
          in: 'path';
          name: 'channelId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      patch: {
        description: 'Zoom chat channels allow users to communicate via chat in private or public channels. Use this API to update the name of a specific channel that you created. \n\n**Scope:** `chat_channel:write`\t<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`\n\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>\n\n';
        operationId: 'updateUserLevelChannel';
        parameters: [
          {
            description: 'Channel Id.';
            in: 'path';
            name: 'channelId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          $ref: '#/components/requestBodies/updateChannelBody';
        };
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**Status Code:** `204`\nChannel updated.';
          };
          '400': {
            description: '**Status Code:** `400`<br>\nBad request<br>\n**Error Code:** `200`<br>\nUnauthorized request. You do not have permission to update a channel for this user.<br>\n**Error Code:** `5301`<br>\nRequest to update a channel failed.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Update a channel';
        tags: ['Chat Channels'];
      };
    };
    '/chat/channels/{channelId}/members/me': {
      delete: {
        description: 'If you\'re no longer interested in being a member of an existing channel, you can leave the channel at any time. Use this API to leave a specific channel. After leaving the channel, you can no longer access information from that channel.\n\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b>This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>\n\n**Scope:** `chat_channel:write`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`';
        operationId: 'leaveChannel';
        parameters: [
          {
            description: 'Channel ID: Unique Identifier of a channel.';
            in: 'path';
            name: 'channelId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `204`<br>\nLeft channel successfully.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br> Bad Request.<br>\n**Error Code:** `5301`<br> Request to leave the channel failed.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Leave a channel';
        tags: ['Chat Channels'];
      };
      parameters: [
        {
          in: 'path';
          name: 'channelId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      post: {
        description: 'A [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) can have one or multiple members. Use this API to join a channel that is open for anyone in the same organization to join. You cannot use this API to join private channels that only allows invited members to be a part of it.\n\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b>This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>\n\n**Scope:** `chat_channel:write`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`';
        operationId: 'joinChannel';
        parameters: [
          {
            description: 'Channel Id.';
            in: 'path';
            name: 'channelId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '201': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      added_at: '2018-12-11T15:06:32.633Z';
                      id: 'lbborum-12fiasf-abaa';
                    };
                  };
                };
                schema: {
                  properties: {
                    added_at: {
                      description: 'The date and time at which a user joined the channel.';
                      format: 'date-time';
                      type: 'string';
                    };
                    id: {
                      description: 'Member Id of the user who joined the public channel.';
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    added_at: {
                      description: 'The date and time at which a user joined the channel.';
                      format: 'date-time';
                      type: 'string';
                    };
                    id: {
                      description: 'Member Id of the user who joined the public channel.';
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `201`\nSuccessfully joined the channel.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br> Bad request.<br>\n**Error Code:** `5301`<br> Request to join the channel failed.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Join a channel';
        tags: ['Chat Channels'];
      };
    };
    '/chat/channels/{channelId}/members/{memberId}': {
      delete: {
        description: ' A [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) can have one or multiple members. Use this API to remove a member from a chat channel.<br><br>\n **Scopes:** `chat_channel:write`<br>\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`\n \n <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>\n\n\n';
        operationId: 'removeAUserLevelChannelMember';
        parameters: [
          {
            description: 'Unique Identifier of the Channel from where you would like to remove a member. This can be retrieved from the [List Channels API](https://marketplace.zoom.us/docs/api-reference/zoom-api/chat-channels/getchannels).';
            in: 'path';
            name: 'channelId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Email address of the member whom you would like to be remove from the channel.';
            in: 'path';
            name: 'memberId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `204` **No Content**<br>\nMember removed.\n\n\n';
          };
          '400': {
            description: "**HTTP Status Code:** `400` <br>\nBad Request<br>\n**Error Code:** `200`<br>\nUnauthorized request. You do not have permission to remove channel members on this user's behalf.<br>\n**Error Code:** `5301`<br>\nUnable to remove channel member.\n\n";
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Remove a member';
        tags: ['Chat Channels'];
      };
      parameters: [
        {
          in: 'path';
          name: 'channelId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          in: 'path';
          name: 'memberId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
    };
    '/chat/users/me/contacts': {
      get: {
        description: 'A user under an organization’s Zoom account has internal users listed under Company Contacts in the Zoom Client. A Zoom user can also add another Zoom user as a [contact](https://support.zoom.us/hc/en-us/articles/115004055706-Managing-Contacts). Call this API to list all the contacts of a Zoom user. Zoom contacts are categorized into "company contacts" and "external contacts". You must specify the contact type in the `type` query parameter. If you do not specify, by default, the type will be set as company contact.\n\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>\n\n**Scope**: `chat_contact:read`<br>\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`';
        operationId: 'getUserContacts';
        parameters: [
          {
            description: "The type of contact. The value can be one of the following:\n`company`: Contacts from the user's organization.\n`external`: External contacts. ";
            in: 'query';
            name: 'type';
            schema: {
              default: 'company';
              type: 'string';
            };
          },
          {
            description: 'The number of records returned with a single API call.';
            in: 'query';
            name: 'page_size';
            schema: {
              default: 10;
              maximum: 50;
              type: 'integer';
            };
          },
          {
            description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
            in: 'query';
            name: 'next_page_token';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      contacts: [
                        {
                          email: 'someemail@somemail.com';
                          first_name: 'Brandon';
                          id: '44ABCDEfgjWHABBxw';
                          last_name: 'Ghimire';
                        },
                      ];
                      next_page_token: 'shdjksA4';
                      page_size: 10;
                    };
                  };
                };
                schema: {
                  properties: {
                    contacts: {
                      description: 'The contacts object.';
                      items: {
                        properties: {
                          email: {
                            description: "Contact's email address.";
                            format: 'email';
                            type: 'string';
                          };
                          first_name: {
                            description: "Contact's first name.";
                            type: 'string';
                          };
                          id: {
                            description: 'Contact Id.';
                            type: 'string';
                          };
                          last_name: {
                            description: "Contact's last name.";
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      description: 'The number of records returned with a single API call.\nDefault value: 30.';
                      maximum: 100;
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    contacts: {
                      description: 'The contacts object.';
                      items: {
                        properties: {
                          email: {
                            description: "Contact's email address.";
                            format: 'email';
                            type: 'string';
                          };
                          first_name: {
                            description: "Contact's first name.";
                            type: 'string';
                          };
                          id: {
                            description: 'Contact Id.';
                            type: 'string';
                          };
                          last_name: {
                            description: "Contact's last name.";
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      description: 'The number of records returned with a single API call.\nDefault value: 30.';
                      maximum: 100;
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: "**HTTP Status Code:** `200`<br>List of user's contacts returned.";
          };
          '300': {
            description: '**Error Code:** `300`<br>\nThe next page token is invalid or has expired.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: "List user's contacts";
        tags: ['Contacts'];
      };
    };
    '/chat/users/me/contacts/{contactId}': {
      get: {
        description: 'A user under an organization’s Zoom account has internal users listed under Company Contacts in the Zoom Client. A Zoom user can also add another Zoom user as a [contact](https://support.zoom.us/hc/en-us/articles/115004055706-Managing-Contacts). Call this API to get information on a specific contact of the Zoom user.\n\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b>This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>\n\n**Scope**: `chat_contact:read`<br>\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`';
        operationId: 'getUserContact';
        parameters: [
          {
            description: "The user's contact Id or email address. The contact can be either a company contact or an external contact.";
            in: 'path';
            name: 'contactId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The presence status of the contact. \nInclude this query parameter with a value of `true` to get the presence status of the contact in the response.';
            in: 'query';
            name: 'query_presence_status';
            schema: {
              type: 'boolean';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      email: 'dhgdj@djkfhd.dhgfdh';
                      first_name: 'Vikram';
                      id: 'u487547sic45ing';
                      last_name: 'Grg';
                      presence_status: 'Do_Not_Disturb';
                    };
                  };
                };
                schema: {
                  properties: {
                    direct_numbers: {
                      description: 'Direct number(s) assigned to the contact.';
                      items: {
                        type: 'string';
                      };
                      type: 'array';
                    };
                    email: {
                      description: "Contact's email address.";
                      format: 'email';
                      type: 'string';
                    };
                    extension_number: {
                      description: 'Extension number of the contact.';
                      type: 'string';
                    };
                    first_name: {
                      description: "Contact's first name";
                      type: 'string';
                    };
                    id: {
                      description: 'User ID of the contact.';
                      type: 'string';
                    };
                    last_name: {
                      description: "Contact's last name";
                      type: 'string';
                    };
                    phone_number: {
                      description: 'Phone number of the contact.';
                      type: 'string';
                    };
                    presence_status: {
                      description: "Contact's Presence Status in the Zoom Chat Client. The status can be one of the following: <br> `Do_Not_Disturb`<br> `Away`<br> `Available`<br> `Offline`";
                      enum: ['Do_Not_Disturb', 'Away', 'Available', 'Offline'];
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    direct_numbers: {
                      description: 'Direct number(s) assigned to the contact.';
                      items: {
                        type: 'string';
                      };
                      type: 'array';
                    };
                    email: {
                      description: "Contact's email address.";
                      format: 'email';
                      type: 'string';
                    };
                    extension_number: {
                      description: 'Extension number of the contact.';
                      type: 'string';
                    };
                    first_name: {
                      description: "Contact's first name";
                      type: 'string';
                    };
                    id: {
                      description: 'User ID of the contact.';
                      type: 'string';
                    };
                    last_name: {
                      description: "Contact's last name";
                      type: 'string';
                    };
                    phone_number: {
                      description: 'Phone number of the contact.';
                      type: 'string';
                    };
                    presence_status: {
                      description: "Contact's Presence Status in the Zoom Chat Client. The status can be one of the following: <br> `Do_Not_Disturb`<br> `Away`<br> `Available`<br> `Offline`";
                      enum: ['Do_Not_Disturb', 'Away', 'Available', 'Offline'];
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br>\nContact information returned.\n\n\n';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\nBad request<br>\n**Error Code:** `5301`<br>\nRequest to get the presence status of the chat contact failed.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code**: `1001`<br>\nUser does not exist: $contactId';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: "Get user's contact details";
        tags: ['Contacts'];
      };
      parameters: [
        {
          in: 'path';
          name: 'contactId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
    };
    '/chat/users/{userId}/channels': {
      get: {
        description: 'Zoom chat [channels](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) allow users to communicate via chat in private or public groups. Use this API to list a user\'s chat channels. \n\n**Scope**: `chat_channel:read` or `chat_channel:read:admin`<br>\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API supports both user-managed apps and account-level apps. However, in an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, to list channels of another user in the same Zoom account, the user calling this API must have a <a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit.">role</a> that has <b>View or Edit</b> permission for the Chat channels feature.</p><br>\n\n\n\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`\n ';
        operationId: 'getChannels';
        parameters: [
          {
            description: 'The number of records returned from a single API call.';
            in: 'query';
            name: 'page_size';
            schema: {
              default: 10;
              maximum: 50;
              type: 'integer';
            };
          },
          {
            description: 'The next page token is used to paginate through large result sets. The expiration period for this token is 15 minutes.';
            in: 'query';
            name: 'next_page_token';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Unique identifier of the user.';
            in: 'path';
            name: 'userId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      channels: [
                        {
                          id: 'ullamdsfjhgdsn663isi';
                          name: 'Happiness Channel';
                          type: 2;
                        },
                        {
                          id: 'dsfdfrgtre23324663isi';
                          name: 'Sales team';
                          type: 2;
                        },
                      ];
                      page_size: 10;
                      total_records: 2;
                    };
                  };
                };
                schema: {
                  properties: {
                    channels: {
                      description: 'Chat Channel object(s).';
                      items: {
                        properties: {
                          channels_settings: {
                            properties: {
                              allow_to_add_external_users: {
                                type: 'integer';
                              };
                              new_members_can_see_previous_messages_files: {
                                type: 'boolean';
                              };
                              posting_permissions: {
                                type: 'integer';
                              };
                            };
                            type: 'object';
                          };
                          id: {
                            description: 'Channel ID: Unique identifier of the Channel.';
                            type: 'string';
                          };
                          name: {
                            description: 'Name of the channel.';
                            type: 'string';
                          };
                          type: {
                            description: 'Type of the channel. The value can be one of the following:<br>\n`1`: **Private channel.** In this type of channel, members must be invited to join a channel.<br>\n`2`: **Private channel with users that belong to the same Zoom account**. Members in this channel should be invited and the members should be from the same organization.<br>\n`3`: **Public channel.** Anyone can search for this channel and join the channel. External members cannot be invited.<br>\n`4`: **New chat**. This is an instant channel which can be created by adding members to a new chat.<br>\n`5`: **Public channel**, similar to above, except members can invite members of other accounts.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      description: 'The number of records returned with a single API call.\nDefault value: 30.';
                      maximum: 100;
                      type: 'integer';
                    };
                    total_records: {
                      description: 'The total number of records found.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    channels: {
                      description: 'Chat Channel object(s).';
                      items: {
                        properties: {
                          channels_settings: {
                            properties: {
                              allow_to_add_external_users: {
                                type: 'integer';
                              };
                              new_members_can_see_previous_messages_files: {
                                type: 'boolean';
                              };
                              posting_permissions: {
                                type: 'integer';
                              };
                            };
                            type: 'object';
                          };
                          id: {
                            description: 'Channel ID: Unique identifier of the Channel.';
                            type: 'string';
                          };
                          name: {
                            description: 'Name of the channel.';
                            type: 'string';
                          };
                          type: {
                            description: 'Type of the channel. The value can be one of the following:<br>\n`1`: **Private channel.** In this type of channel, members must be invited to join a channel.<br>\n`2`: **Private channel with users that belong to the same Zoom account**. Members in this channel should be invited and the members should be from the same organization.<br>\n`3`: **Public channel.** Anyone can search for this channel and join the channel. External members cannot be invited.<br>\n`4`: **New chat**. This is an instant channel which can be created by adding members to a new chat.<br>\n`5`: **Public channel**, similar to above, except members can invite members of other accounts.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      description: 'The number of records returned with a single API call.\nDefault value: 30.';
                      maximum: 100;
                      type: 'integer';
                    };
                    total_records: {
                      description: 'The total number of records found.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: "**Status Code**: `200` <br>\nUser's channels returned.";
          };
          '400': {
            description: '**HTTP Status Code:** `400` <br>\nBad request.<br>\n**Error Code**: `300`<br>\nThe next page token is either invalid or has expired.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: "List user's channels";
        tags: ['Chat Channels'];
      };
      parameters: [
        {
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      post: {
        description: 'Zoom chat channels allow users to communicate via chat in private or public groups. Use this API to create a channel for a user.<br>\n**Scopes**:`chat_channel:write` or `chat_channel:write:admin`<br>\n\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API supports both user-managed apps and account-level apps. However, in an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, to create a channel on behalf of another user in the same Zoom account, the user calling this API must have a <a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit.">role</a> that has <b>Edit</b> permission for the Chat channels feature.</p><br>\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`\n \n';
        operationId: 'createChannel';
        parameters: [
          {
            description: 'Unique identifier of the user.';
            in: 'path';
            name: 'userId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  members: {
                    description: 'Member(s) to include in the channel. A max of 5 members can be added to the channel at once with this API.';
                    items: {
                      properties: {
                        email: {
                          description: "Member's email address.";
                          format: 'email';
                          type: 'string';
                        };
                      };
                      required: ['email'];
                      type: 'object';
                    };
                    type: 'array';
                  };
                  name: {
                    description: 'Name of the channel.';
                    maxLength: 128;
                    type: 'string';
                  };
                  type: {
                    description: 'Type of the channel. The value can be one of the following:<br>\n`1`: Private channel. In this type of channel, members must be invited to join a channel.<br>\n`2`: Private channel with members that belong to one Zoom account. Members in this channel should be invited and the members should be from the same organization.<br>\n`3`: Public channel. Anyone can search for this channel and join the channel.<br>\n`4`: New chat. This is an instant channel which can be created by adding members to a new chat. ';
                    enum: [1, 2, 3];
                    type: 'integer';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  members: {
                    description: 'Member(s) to include in the channel. A max of 5 members can be added to the channel at once with this API.';
                    items: {
                      properties: {
                        email: {
                          description: "Member's email address.";
                          format: 'email';
                          type: 'string';
                        };
                      };
                      required: ['email'];
                      type: 'object';
                    };
                    type: 'array';
                  };
                  name: {
                    description: 'Name of the channel.';
                    maxLength: 128;
                    type: 'string';
                  };
                  type: {
                    description: 'Type of the channel. The value can be one of the following:<br>\n`1`: Private channel. In this type of channel, members must be invited to join a channel.<br>\n`2`: Private channel with members that belong to one Zoom account. Members in this channel should be invited and the members should be from the same organization.<br>\n`3`: Public channel. Anyone can search for this channel and join the channel.<br>\n`4`: New chat. This is an instant channel which can be created by adding members to a new chat. ';
                    enum: [1, 2, 3];
                    type: 'integer';
                  };
                };
                type: 'object';
              };
            };
          };
        };
        responses: {
          '201': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      id: 'id8977ullamco';
                      jid: 'nisi73624365536st';
                      name: 'Happy Channel';
                      type: 1;
                    };
                  };
                };
                schema: {
                  properties: {
                    id: {
                      description: 'Channel ID: Unique Identifier of the Channel.';
                      type: 'string';
                    };
                    jid: {
                      description: 'Channel JID. ';
                      type: 'string';
                    };
                    name: {
                      description: 'Channel name.';
                      type: 'string';
                    };
                    type: {
                      description: 'Channel type.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    id: {
                      description: 'Channel ID: Unique Identifier of the Channel.';
                      type: 'string';
                    };
                    jid: {
                      description: 'Channel JID. ';
                      type: 'string';
                    };
                    name: {
                      description: 'Channel name.';
                      type: 'string';
                    };
                    type: {
                      description: 'Channel type.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**Status Code**: `201` <br>\nChannel created.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\nNot found.<br>\n**Error Code**: `5301`<br>\nRequest to create a channel failed.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code**: `1001`<br>\nUser does not exist: $userId.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Create a channel';
        tags: ['Chat Channels'];
      };
    };
    '/chat/users/{userId}/channels/{channelId}': {
      delete: {
        description: 'Zoom chat [channels](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) allow users to communicate via chat in private or public groups. Use this API to delete a specific channel. \n\n**Scope:** `chat_channel:write:admin`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`\n\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>\n\n\n ';
        operationId: 'deleteChannel';
        parameters: [
          {
            description: 'Channel ID: Unique Identifier of a channel.';
            in: 'path';
            name: 'channelId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `204`<br>\nChannel deleted.';
          };
          '400': {
            description: "**HTTP Status Code:** `400`<br> Bad request.<br>\n**Error Code:** `200`<br>\nUnauthorized request. You do not have permission to delete this user's channel.<br>\n**Error Code:** `5301`<br> Request to delete a channel failed.";
          };
        };
        summary: 'Delete a channel';
        tags: ['Chat Channels (Account-level)'];
      };
      get: {
        description: 'Zoom chat [channels](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) allow users to communicate via chat in private or public groups. Use this API to get information about a specific channel. \n\n**Scope:** `chat_channel:read:admin` <br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium` <br>\n\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b> <a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a>  that has View or Edit permission for Chat Channels</b>.</p>\n\n\n ';
        operationId: 'getChannel';
        parameters: [
          {
            description: 'Channel ID: Unique Identifier of a channel.';
            in: 'path';
            name: 'channelId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Unique identifier of the user who is the owner of the channel.';
            in: 'path';
            name: 'userId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      id: 'ut1234sgfsdf';
                      name: 'Leah';
                      type: 1;
                    };
                  };
                };
                schema: {
                  description: 'The channel object represents a Zoom chat [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-). ';
                  properties: {
                    id: {
                      description: 'Channel Id.';
                      type: 'string';
                    };
                    name: {
                      description: 'Name of the channel.';
                      maxLength: 128;
                      type: 'string';
                    };
                    type: {
                      description: 'Type of the channel. The value can be one of the following:<br>\n`1`: Private channel. In this type of channel, members must be invited to join a channel.<br>\n`2`: Private channel with members that belong to one Zoom account. Members in this channel should be invited and the members should be from the same organization.<br>\n`3`: Public channel. Anyone can search for this channel and join the channel.<br>';
                      enum: [1, 2, 3];
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  description: 'The channel object represents a Zoom chat [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-). ';
                  properties: {
                    id: {
                      description: 'Channel Id.';
                      type: 'string';
                    };
                    name: {
                      description: 'Name of the channel.';
                      maxLength: 128;
                      type: 'string';
                    };
                    type: {
                      description: 'Type of the channel. The value can be one of the following:<br>\n`1`: Private channel. In this type of channel, members must be invited to join a channel.<br>\n`2`: Private channel with members that belong to one Zoom account. Members in this channel should be invited and the members should be from the same organization.<br>\n`3`: Public channel. Anyone can search for this channel and join the channel.<br>';
                      enum: [1, 2, 3];
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br>\nChannel returned.<br>\n\n\n\n';
          };
          '400': {
            description: "**HTTP Status Code:** `400`<br>\nBad Request<br>\n**Error Code:** `200`<br>\nUnauthorized request. You do not have permission to access this user's channel information.";
          };
          '404': {
            description: '**Status Code:** `404`<br>\nNot found.<br>\n**Error Code:** `4130`<br>\nChannel does not exist: $channelId.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Get a channel';
        tags: ['Chat Channels (Account-level)'];
      };
      parameters: [
        {
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          in: 'path';
          name: 'channelId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      patch: {
        description: 'Zoom chat channels allow users to communicate via chat in private or public channels. Use this API to update the name of a specific channel created by a user. <br><br>\n**Scope:** `chat_channel:write:admin`\t<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b> <a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a>  that has Edit permission for Chat Channel</b>.</p>\n';
        operationId: 'updateChannel';
        parameters: [
          {
            description: 'Channel Id.';
            in: 'path';
            name: 'channelId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Unique Identifier of the Zoom user who is the owner of the channel.';
            in: 'path';
            name: 'userId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          $ref: '#/components/requestBodies/updateChannelBody';
        };
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**Status Code:** `204`\nChannel updated.';
          };
          '400': {
            description: '**Status Code:** `400`<br>\nBad request<br>\n**Error Code:** `200`<br>\nUnauthorized request. You do not have permission to update a channel for this user.<br>\n**Error Code:** `5301`<br>\nRequest to update a channel failed.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Update a channel';
        tags: ['Chat Channels (Account-level)'];
      };
    };
    '/chat/users/{userId}/channels/{channelId}/members': {
      get: {
        description: 'A [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) can have one or multiple members. List all the members of a channel using this API.\n\n </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b><a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a> that has View or Edit permission for Chat Channels</b>.</p>\n\n**Scopes:** `chat_channel:read:admin`<br>\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`';
        operationId: 'listChannelMembers';
        parameters: [
          {
            description: 'Channel Id.';
            in: 'path';
            name: 'channelId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The number of records returned with a single API call.';
            in: 'query';
            name: 'page_size';
            schema: {
              default: 30;
              maximum: 100;
              type: 'integer';
            };
          },
          {
            description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
            in: 'query';
            name: 'next_page_token';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Unique identifier of the user who is the owner of this channel.';
            in: 'path';
            name: 'userId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      members: [
                        {
                          email: 'IiUQCUCLs@XKmztyJAAU.di';
                          first_name: 'Harry';
                          id: 'laboris3764763ull';
                          last_name: 'King';
                          role: 'admin';
                        },
                        {
                          email: 'hJUWLsYtyw@ljXwqOlyNCvBjtkLOx.eox';
                          first_name: 'Alisha';
                          id: 'eul21dfabore';
                          last_name: 'Sapkota';
                          role: 'member';
                        },
                      ];
                      next_page_token: '';
                      page_size: 30;
                      total_records: 2;
                    };
                  };
                };
                schema: {
                  properties: {
                    members: {
                      description: 'Members in a channel.';
                      items: {
                        properties: {
                          email: {
                            description: 'Email address of the member.';
                            format: 'email';
                            type: 'string';
                          };
                          first_name: {
                            description: "Member's first name.";
                            type: 'string';
                          };
                          id: {
                            description: 'Member ID: Unique Identifier of the member.';
                            type: 'string';
                          };
                          last_name: {
                            description: "Member's last name.";
                            type: 'string';
                          };
                          role: {
                            description: 'The role of the member. The value can be one of these: `owner`, `admin`, `member`. ';
                            enum: ['admin', 'owner', 'member'];
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      default: 30;
                      description: 'The number of records returned with a single API call. ';
                      maximum: 100;
                      type: 'integer';
                    };
                    total_records: {
                      description: 'The total number of records returned.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    members: {
                      description: 'Members in a channel.';
                      items: {
                        properties: {
                          email: {
                            description: 'Email address of the member.';
                            format: 'email';
                            type: 'string';
                          };
                          first_name: {
                            description: "Member's first name.";
                            type: 'string';
                          };
                          id: {
                            description: 'Member ID: Unique Identifier of the member.';
                            type: 'string';
                          };
                          last_name: {
                            description: "Member's last name.";
                            type: 'string';
                          };
                          role: {
                            description: 'The role of the member. The value can be one of these: `owner`, `admin`, `member`. ';
                            enum: ['admin', 'owner', 'member'];
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      default: 30;
                      description: 'The number of records returned with a single API call. ';
                      maximum: 100;
                      type: 'integer';
                    };
                    total_records: {
                      description: 'The total number of records returned.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br>\nList of channel members returned.\n\n';
          };
          '400': {
            description: "**HTTP Status Code:** `400`<br> Bad Request<br>\n**Error Code:** `200`<br>\nUnauthorized request. You do not have permission to view channel members on this user's behalf..<br>\n**Error Code:** `300`<br>\nThe next page token is either invalid or has expired.";
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'List channel members';
        tags: ['Chat Channels (Account-level)'];
      };
      parameters: [
        {
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          in: 'path';
          name: 'channelId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      post: {
        description: 'A [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) can have one or multiple members. Use this API to invite members that are in a user\'s contact list to a channel. The maximum number of members that can be added at once with this API is 5. \n\n**Scope:** `chat_channel:write:admin` <br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`\n\n </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b><a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a> that has Edit permission for Chat Channels</b>.</p>';
        operationId: 'inviteChannelMembers';
        parameters: [
          {
            description: 'Channel ID: Unique Identifier of the channel.';
            in: 'path';
            name: 'channelId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Unique identifier of the user who is the owner of this channel.';
            in: 'path';
            name: 'userId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  members: {
                    description: 'Members of a channel. You can invite up to a max number of 5 members with a single API call.';
                    items: {
                      properties: {
                        email: {
                          description: 'Email adress of the member.';
                          format: 'email';
                          type: 'string';
                        };
                      };
                      required: ['email'];
                      type: 'object';
                    };
                    type: 'array';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  members: {
                    description: 'Members of a channel. You can invite up to a max number of 5 members with a single API call.';
                    items: {
                      properties: {
                        email: {
                          description: 'Email adress of the member.';
                          format: 'email';
                          type: 'string';
                        };
                      };
                      required: ['email'];
                      type: 'object';
                    };
                    type: 'array';
                  };
                };
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              members: [
                {
                  email: 'rtxbZkoL6ZVr@BKRUfQISqmtCCeuGPP.ma';
                },
                {
                  email: 'Rl7NtxV2wGf6@INybVUUu.fphl';
                },
              ];
            };
          };
        };
        responses: {
          '201': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      added_at: '2019-09-27T00:14:46Z';
                      ids: ['abc4545fdgfdhg', 'lgfdkhg123456'];
                    };
                  };
                };
                schema: {
                  properties: {
                    added_at: {
                      description: 'The date and time at which the member(s) are added to the channe.';
                      format: 'date-time';
                      type: 'string';
                    };
                    ids: {
                      description: 'Member Ids of the members.';
                      items: {
                        type: 'string';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    added_at: {
                      description: 'The date and time at which the member(s) are added to the channe.';
                      format: 'date-time';
                      type: 'string';
                    };
                    ids: {
                      description: 'Member Ids of the members.';
                      items: {
                        type: 'string';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `201`<br>\nMembers invited to the channel.';
          };
          '400': {
            description: "**Status Code:** `400`<br>\nBad request.<br>\n**Error Code:** `5301`<br>\nRequest to invite channel members failed.<br>\n**Error Code:** `200`<br>\nUnauthorized request. You do not have permission to invite channel members on this user's behalf.";
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Invite channel members';
        tags: ['Chat Channels (Account-level)'];
      };
    };
    '/chat/users/{userId}/channels/{channelId}/members/{memberId}': {
      delete: {
        description: ' A [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) can have one or multiple members. Use this API to remove a member from a chat channel.<br><br>\n \n**Scopes:** `chat_channel:write:admin`<br>\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium` <br>\n \n \n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b><a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a> that has Edit permission for Chat Channels</b>.</p>';
        operationId: 'removeAChannelMember';
        parameters: [
          {
            description: 'Unique Identifier of the Channel from where you would like to remove a member. This can be retrieved from the [List Channels API](https://marketplace.zoom.us/docs/api-reference/zoom-api/chat-channels/getchannels).';
            in: 'path';
            name: 'channelId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Email address of the member whom you would like to be remove from the channel.';
            in: 'path';
            name: 'memberId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Unique identifier of the channel owner.';
            in: 'path';
            name: 'userId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
              'application/xml': {
                schema: {};
              };
            };
            description: '**HTTP Status Code:** `204` **No Content**<br>\nMember removed.\n\n\n';
          };
          '400': {
            description: "**HTTP Status Code:** `400` <br>\nBad Request<br>\n**Error Code:** `200`<br>\nUnauthorized request. You do not have permission to remove channel members on this user's behalf.<br>\n**Error Code:** `5301`<br>\nUnable to remove channel member.\n\n";
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Remove a member';
        tags: ['Chat Channels (Account-level)'];
      };
      parameters: [
        {
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          in: 'path';
          name: 'channelId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          in: 'path';
          name: 'memberId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
    };
    '/chat/users/{userId}/messages': {
      get: {
        description: 'A Zoom user can have conversations with other Zoom users via chat. Use this API to list the current user\'s chat messages between the user and an individual contact or a chat channel.<br> In the query parameter, you must provide either of the following:<br>\n* `to_contact`: The email address of the contact with whom the user conversed by sending/receiving messages.\n* `to_channel`: The channel ID of the channel to/from which the user has sent and/or received messages.\n\n<br> **Specify a date** in the `date` query parameter to view messages from that date. If a date is not provided, the default value for the query will be the **current date**.<br>\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit.">role</a> that has <b>View or Edit</b> permission for Chat Messages.</p><br>\n\n<br>**Scopes:** `chat_message:read`, `chat_message:read:admin`<br>\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`\n\n';
        operationId: 'getChatMessages';
        parameters: [
          {
            description: 'The email address of a chat contact with whom the current user chatted. Messages that were sent and/or received between the user and the contact is displayed.\n\nNote: You must provide either `contact` or `channel` as a query parameter to retrieve messages either from an individual or a chat channel. ';
            in: 'query';
            name: 'to_contact';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The channel Id of a channel inside which the current user had chat conversations. Messages that were sent and/or received between the user and the channel is displayed.\n\nNote: You must provide either `contact` or `channel` as a query parameter to retrieve messages either from an individual or a chat channel. ';
            in: 'query';
            name: 'to_channel';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The query date for which you would like to get the chat messages.';
            in: 'query';
            name: 'date';
            schema: {
              format: 'date';
              type: 'string';
            };
          },
          {
            description: 'The number of records returned with a single API call. ';
            in: 'query';
            name: 'page_size';
            schema: {
              default: 10;
              maximum: 50;
              type: 'integer';
            };
          },
          {
            description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
            in: 'query';
            name: 'next_page_token';
            schema: {
              type: 'string';
            };
          },
          {
            description: '**Optional** <br>\nSet the value of this field to `true` to include edited and deleted messages in the response.';
            in: 'query';
            name: 'include_deleted_and_edited_message';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      date: '2019-09-17';
                      messages: [
                        {
                          date_time: '2019-09-17T20:25:21Z';
                          id: 'F3CbafdljsfjkdfgBA7';
                          message: 'And you?';
                          sender: 'myemail@someemailaddr.com';
                          timestamp: 1568751921626;
                        },
                        {
                          date_time: '2019-09-17T20:25:17Z';
                          id: 'B0DbfdgdfhAAfgf237000';
                          message: 'I am good';
                          sender: 'myemail@someemailaddr.com';
                          timestamp: 1568751917976;
                        },
                        {
                          date_time: '2019-09-17T20:24:13Z';
                          id: 'C9Bbdfgd4sad301';
                          message: 'How are you';
                          sender: 'myfriendsemail@someemailaddr.us';
                          timestamp: 1568751853297;
                        },
                        {
                          date_time: '2019-09-17T20:22:26Z';
                          id: '769fgdgdfgfd4566F7B96665';
                          message: 'hello';
                          sender: 'myfriendsemail@someemailaddr.us';
                          timestamp: 1568751746769;
                        },
                      ];
                      next_page_token: '';
                      page_size: 10;
                    };
                  };
                };
                schema: {
                  description: 'Chat message object.';
                  properties: {
                    date: {
                      description: 'The date provided in the query parameter. If a date is not provided, the default value is the **current date**.';
                      format: 'date';
                      type: 'string';
                    };
                    messages: {
                      description: 'List of message(s).';
                      items: {
                        properties: {
                          date_time: {
                            description: 'The date-time at which the message was sent.';
                            type: 'string';
                          };
                          id: {
                            description: 'Message ID: Unique Identifier of the message.';
                            type: 'string';
                          };
                          message: {
                            description: 'The message content.';
                            type: 'string';
                          };
                          reply_main_message_id: {
                            description: 'Unique identifier of a reply. This field will only be returned if the message is a reply message.';
                            type: 'string';
                          };
                          reply_main_message_timestamp: {
                            description: 'Timestamp of when the reply message was sent. This field will only be returned if the message is a reply message.\n\nThe value of this field will be in **long** format(int64). ';
                            format: 'int64';
                            type: 'integer';
                          };
                          sender: {
                            description: 'The email address of the sender of the message.';
                            type: 'string';
                          };
                          status: {
                            description: 'This field indicates whether a message is an original message(unedited), an edited message or a deleted message.\n\nThis field is only returned if you set the value of `for include_deleted_and_edited_message` query parameter to `true`.';
                            enum: ['Deleted', 'Edited', 'Normal'];
                            type: 'string';
                          };
                          timestamp: {
                            description: 'The timestamp of the message in microseconds.';
                            format: 'int64';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.\n';
                      type: 'string';
                    };
                    page_size: {
                      default: 10;
                      description: 'The number of records returned with a single API call.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  description: 'Chat message object.';
                  properties: {
                    date: {
                      description: 'The date provided in the query parameter. If a date is not provided, the default value is the **current date**.';
                      format: 'date';
                      type: 'string';
                    };
                    messages: {
                      description: 'List of message(s).';
                      items: {
                        properties: {
                          date_time: {
                            description: 'The date-time at which the message was sent.';
                            type: 'string';
                          };
                          id: {
                            description: 'Message ID: Unique Identifier of the message.';
                            type: 'string';
                          };
                          message: {
                            description: 'The message content.';
                            type: 'string';
                          };
                          reply_main_message_id: {
                            description: 'Unique identifier of a reply. This field will only be returned if the message is a reply message.';
                            type: 'string';
                          };
                          reply_main_message_timestamp: {
                            description: 'Timestamp of when the reply message was sent. This field will only be returned if the message is a reply message.\n\nThe value of this field will be in **long** format(int64). ';
                            format: 'int64';
                            type: 'integer';
                          };
                          sender: {
                            description: 'The email address of the sender of the message.';
                            type: 'string';
                          };
                          status: {
                            description: 'This field indicates whether a message is an original message(unedited), an edited message or a deleted message.\n\nThis field is only returned if you set the value of `for include_deleted_and_edited_message` query parameter to `true`.';
                            enum: ['Deleted', 'Edited', 'Normal'];
                            type: 'string';
                          };
                          timestamp: {
                            description: 'The timestamp of the message in microseconds.';
                            format: 'int64';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.\n';
                      type: 'string';
                    };
                    page_size: {
                      default: 10;
                      description: 'The number of records returned with a single API call.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:**`200`<br>\nList of chat messages returned.';
          };
          '400': {
            description: "**HTTP Status Code:** `400`<br> Bad request.<br>\n**Error Code:** `200`<br>Unauthorized request. You do not have permission to access this user's chat messages.<br>\n**Error Code:** `300` <br>The next page token is invalid or expired.<br>\n**Error Code:** `300` <br>Must provide either contact or channel parameter.<br>\n**Error Code:** `300` <br>Only provide past chat messages in recent 6 months.<br>\n";
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code**: `1001`<br>\nUser does not exist: $to_contact.<br>\n**Error Code**: `4130`<br>\nChannel does not exist: $to_channel.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: "List user's chat messages";
        tags: ['Chat Messages'];
      };
      parameters: [
        {
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      post: {
        description: 'Send chat messages on Zoom to either an individual user who is in your contact list or to a [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) of which you are a member. To send a message to a contact, provide the contact\'s email address in the `to_contact` field. Similary, to send a message to a channel, provide the Channel Id of the Channel in `to_channel` field.<br>\n<br>**Scopes:** `chat_message:write`, `chat_message:write:admin`<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br> <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b><a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a> that has Edit permission for Chat Messages</b>.</p>\n\n';
        operationId: 'sendaChatMessage';
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  at_items: {
                    description: '[Chat mentions](https://support.zoom.us/hc/en-us/articles/360037567431-Using-chat-mentions-and-slash-commands) object. Use this object to include mentions in the message that will be sent to  a channel. ';
                    items: {
                      properties: {
                        at_contact: {
                          description: 'This field is required if the value of `at_type` field is set to 1. \n\nEmail address of the contact. \n\n';
                          type: 'string';
                        };
                        at_type: {
                          description: 'Type of mention. You can use one of the following values:<br>\n* `1`: Mention a contact. \n\n* `2`: Mention "all" to notify everyone in the channel.';
                          enum: [1, 2];
                          type: 'integer';
                        };
                        end_position: {
                          description: 'End position of the mention.\n\nExample message: "@Shrijana How are you?"\nIn this case, the end position of the mention "@Shrijana" is 8. Hence, the value of this field will be 8.';
                          type: 'integer';
                        };
                        start_position: {
                          description: 'Start position of the mention("@") in the message string. \n\nFor example if you want to include the mention at the beginning of the message, the value for this field will be 0. \n\nExample message: "@Shrijana How are you?"\n\n';
                          type: 'integer';
                        };
                      };
                      type: 'object';
                    };
                    type: 'array';
                  };
                  message: {
                    description: 'The message to be sent.';
                    maxLength: 1024;
                    type: 'string';
                  };
                  to_channel: {
                    description: 'The Channel Id of the channel where you would like to send a message.';
                    type: 'string';
                  };
                  to_contact: {
                    description: 'The email address of the contact to whom you would like to send the message.';
                    type: 'string';
                  };
                };
                required: ['message'];
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  at_items: {
                    description: '[Chat mentions](https://support.zoom.us/hc/en-us/articles/360037567431-Using-chat-mentions-and-slash-commands) object. Use this object to include mentions in the message that will be sent to  a channel. ';
                    items: {
                      properties: {
                        at_contact: {
                          description: 'This field is required if the value of `at_type` field is set to 1. \n\nEmail address of the contact. \n\n';
                          type: 'string';
                        };
                        at_type: {
                          description: 'Type of mention. You can use one of the following values:<br>\n* `1`: Mention a contact. \n\n* `2`: Mention "all" to notify everyone in the channel.';
                          enum: [1, 2];
                          type: 'integer';
                        };
                        end_position: {
                          description: 'End position of the mention.\n\nExample message: "@Shrijana How are you?"\nIn this case, the end position of the mention "@Shrijana" is 8. Hence, the value of this field will be 8.';
                          type: 'integer';
                        };
                        start_position: {
                          description: 'Start position of the mention("@") in the message string. \n\nFor example if you want to include the mention at the beginning of the message, the value for this field will be 0. \n\nExample message: "@Shrijana How are you?"\n\n';
                          type: 'integer';
                        };
                      };
                      type: 'object';
                    };
                    type: 'array';
                  };
                  message: {
                    description: 'The message to be sent.';
                    maxLength: 1024;
                    type: 'string';
                  };
                  to_channel: {
                    description: 'The Channel Id of the channel where you would like to send a message.';
                    type: 'string';
                  };
                  to_contact: {
                    description: 'The email address of the contact to whom you would like to send the message.';
                    type: 'string';
                  };
                };
                required: ['message'];
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              at_items: [
                {
                  at_contact: 'mycontactsemail@somexyz23mail.com';
                  at_type: 1;
                  end_position: 8;
                  start_position: 0;
                },
              ];
              message: '@Shrijana How are you?';
              to_channel: 'e87294sdg4a42e7d2f80862';
            };
          };
        };
        responses: {
          '201': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      id: 'ex35785hgdfjgt';
                    };
                  };
                };
                schema: {
                  properties: {
                    id: {
                      description: 'Message ID: Unique Identifier of the message.';
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    id: {
                      description: 'Message ID: Unique Identifier of the message.';
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**Status Code:** `201`<br>\nMessage sent.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\nBad request.<br>\n**Error Code:** `5301`<br>\nMessage sending failed.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code**: `1001`<br>\nUser does not exist: $to_contact.<br>\n**Error Code**: `4130`<br>\nChannel does not exist: $to_channel.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Send a chat message';
        tags: ['Chat Messages'];
      };
    };
    '/chat/users/{userId}/messages/{messageId}': {
      delete: {
        description: 'Delete a chat message that you previously sent to a contact or a channel. In the query parameter, you must provide either of the following:<br>\n* `to_contact`: The email address of the contact to whom you sent the message. Use this parameter to delete a message sent to an individual contact in Zoom.\n* `to_channel`: The channel ID of the channel where you sent the message. Use this parameter to delete a message sent to a channel in Zoom.\n\n<p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b><a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a> that has Edit permission for Chat Messages</b>.</p>\n\n**Scope:** `chat_message:write`, `chat_message:write:admin`<br>\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`';
        operationId: 'deleteChatMessage';
        parameters: [
          {
            description: 'Message ID';
            in: 'path';
            name: 'messageId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The userId or email address of a chat contact to whom you previously sent the message.\n\nNote: You must provide either `to_contact` or `to_channel` as a query parameter to delete a message that was previously sent to either an individual or a chat channel respectively. ';
            in: 'query';
            name: 'to_contact';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The channel Id of the channel where you would like to send the message.\n\nYou must provide either `to_contact` or `to_channel` as a query parameter to delete a message that was previously sent to either an individual or a chat channel ';
            in: 'query';
            name: 'to_channel';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            description: '**HTTP Status Code:** `204`<br>\nMessage deleted.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\nBad request.<br>\n**Error Code:** `200`<br>\nThe contact or the channel parameter provided is invalid.<br>\nOnly the sender of this message can make updates.<br>\n**Error Code:** `300`<br>Channel does not exist: $messageId<br>Must provide either contact or channel parameter.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code**: `1001`<br>\nUser does not exist: $to_contact.<br>\n**Error Code**: `4130`<br>\nChannel does not exist: $to_channel.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Delete a message';
        tags: ['Chat Messages'];
      };
      parameters: [
        {
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          in: 'path';
          name: 'messageId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      put: {
        description: 'Each chat message has a unique identifier. Use this API to edit a chat message that you previously sent to either a contact or a channel in Zoom by providing the ID of the message as the value of the `messageId` parameter. The ID can be retrieved from List User\'s Chat Messages API. Additionally, as a query parameter, you must provide either the **email address** of the contact or the **Channel ID** of the channel where the message was sent. \n\n**Scope:** `chat_message:write`,`chat_message:write:admin`\t<br>\n**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium` \n\n</b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b><a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a> that has Edit permission for Chat Messages</b>.</p>\n**Scope:** `chat_message:write`, `chat_message:write:admin`<br>\n\n\n\n\n\n\n';
        operationId: 'editMessage';
        parameters: [
          {
            description: 'Message ID: Unique Identifier of the message.';
            in: 'path';
            name: 'messageId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  message: {
                    description: 'The edited message.';
                    type: 'string';
                  };
                  to_channel: {
                    description: "The Channel ID of the channel where you sent the message.<br>You must provide either `to_contact` or `to_channel` parameter in the API request.\n Channel ID can be retrieved from List User's Channels API. ";
                    type: 'string';
                  };
                  to_contact: {
                    description: 'The email address of the contact to whom the message was sent.<br>\nYou must provide either `to_contact` or `to_channel` parameter in the API request.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  message: {
                    description: 'The edited message.';
                    type: 'string';
                  };
                  to_channel: {
                    description: "The Channel ID of the channel where you sent the message.<br>You must provide either `to_contact` or `to_channel` parameter in the API request.\n Channel ID can be retrieved from List User's Channels API. ";
                    type: 'string';
                  };
                  to_contact: {
                    description: 'The email address of the contact to whom the message was sent.<br>\nYou must provide either `to_contact` or `to_channel` parameter in the API request.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
            };
          };
          'x-examples': {
            'application/json': {
              message: 'This is an edited message. It is a gloomy day today.';
              to_contact: 'theemailofmyfriend@sksjgsdf.fhdgfgdh';
            };
          };
        };
        responses: {
          '204': {
            description: '**HTTP Status Code:** `204`<br>\nMessage updated successfully.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\nBar request<br>\n**Error Code:** `200`<br>\nOnly the sender of this message can make updates.<br>\n**Error Code:** `300`<br>\nMessage does not exist: $messageId <br> Must provide either contact or channel parameter.\n';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code**: `1001`<br>\nUser does not exist: $to_contact.<br>\n**Error Code**: `4130`<br>\nChannel does not exist: $to_channel.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Update a message';
        tags: ['Chat Messages'];
      };
    };
    '/chat/users/{userId}/messages/{messageId}/status': {};
    '/contacts': {
      get: {
        description: "A user under an organization's Zoom account has internal users listed under Company Contacts in the Zoom Client. Use this API to search users that are in the company contacts of a Zoom account. Using the `search_key` query parameter, provide either first name, last name or the email address of the user that you would like to search for. Optionally, set `query_presence_status` to `true` in order to include the presence status of a contact. <br><br>\n\n**Scopes:** `contact:read:admin`, `contact:read`<br>\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium` ";
        operationId: 'searchCompanyContacts';
        parameters: [
          {
            description: 'Provide the keyword - either first name, last name or email of the contact whom you have to search for.';
            in: 'query';
            name: 'search_key';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Set `query_presence_status` to `true` in order to include the presence status of a contact in the response.';
            in: 'query';
            name: 'query_presence_status';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The number of records to be returned with a single API call.';
            in: 'query';
            name: 'page_size';
            schema: {
              default: 1;
              maximum: 25;
              type: 'integer';
            };
          },
          {
            description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
            in: 'query';
            name: 'next_page_token';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      contacts: [
                        {
                          direct_numbers: [111111, 222222];
                          email: 'qui@djfsd.sdfjhdf';
                          extension_number: '010';
                          first_name: 'John';
                          id: 'isds324bdfsf';
                          im_group_id: 'fhksdhfew34hjds';
                          im_group_name: 'Engineering';
                          last_name: 'Doe';
                          phone_number: '00000000';
                          presence_status: 'Offline';
                          sip_phone_number: '11111111';
                        },
                      ];
                      next_page_token: ' ';
                      page_size: 1;
                    };
                  };
                };
                schema: {
                  properties: {
                    contacts: {
                      items: {
                        properties: {
                          dept: {
                            description: "Department of the contact as provided in the user's Zoom profile.";
                            type: 'string';
                          };
                          direct_numbers: {
                            description: 'Direct Number(s) of a user who has Zoom Phone license assigned.';
                            items: {
                              type: 'string';
                            };
                            type: 'array';
                          };
                          email: {
                            description: 'Email address of the contact.';
                            type: 'string';
                          };
                          extension_number: {
                            description: 'Extension Number of a user who has Zoom Phone license assigned.';
                            type: 'string';
                          };
                          first_name: {
                            description: 'First name of the contact.';
                            type: 'string';
                          };
                          id: {
                            description: 'User ID of the contact.';
                            type: 'string';
                          };
                          im_group_id: {
                            description: 'Unique Identifier of the [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management) in which the user has been added. An IM Directory group is not the same as a channel. IM Directory allows administrators to assign users in their account to groups that display within the Contacts list on Zoom clients. ';
                            type: 'string';
                          };
                          im_group_name: {
                            description: 'Name of the [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management) in which the user has been added. An IM Directory group is not the same as a channel. IM Directory allows administrators to assign users in their account to groups that display within the Contacts list on Zoom clients. ';
                            type: 'string';
                          };
                          job_title: {
                            description: "Department of the user as provided in the user's Zoom profile.";
                            type: 'string';
                          };
                          last_name: {
                            description: 'Last name of the contact.';
                            type: 'string';
                          };
                          location: {
                            description: "Location of the user as provided in the user's Zoom profile.";
                            type: 'string';
                          };
                          phone_number: {
                            description: 'Phone number of the user.';
                            type: 'string';
                          };
                          presence_status: {
                            description: 'Presence status of the contact in Zoom Client. The value of this field can be one of the following:\n`Do_Not_Disturb`<br> `away`<br> `Available`<br> `Offline`';
                            enum: ['Do_Not_Disturb', 'Away', 'Available', 'Offline'];
                            type: 'string';
                          };
                          sip_phone_number: {
                            description: 'SIP Phone number of the user. Returned only if user has SIP phone enabled.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      description: 'The number of records returned with a single API call. Default value is `1`.';
                      maximum: 25;
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    contacts: {
                      items: {
                        properties: {
                          dept: {
                            description: "Department of the contact as provided in the user's Zoom profile.";
                            type: 'string';
                          };
                          direct_numbers: {
                            description: 'Direct Number(s) of a user who has Zoom Phone license assigned.';
                            items: {
                              type: 'string';
                            };
                            type: 'array';
                          };
                          email: {
                            description: 'Email address of the contact.';
                            type: 'string';
                          };
                          extension_number: {
                            description: 'Extension Number of a user who has Zoom Phone license assigned.';
                            type: 'string';
                          };
                          first_name: {
                            description: 'First name of the contact.';
                            type: 'string';
                          };
                          id: {
                            description: 'User ID of the contact.';
                            type: 'string';
                          };
                          im_group_id: {
                            description: 'Unique Identifier of the [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management) in which the user has been added. An IM Directory group is not the same as a channel. IM Directory allows administrators to assign users in their account to groups that display within the Contacts list on Zoom clients. ';
                            type: 'string';
                          };
                          im_group_name: {
                            description: 'Name of the [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management) in which the user has been added. An IM Directory group is not the same as a channel. IM Directory allows administrators to assign users in their account to groups that display within the Contacts list on Zoom clients. ';
                            type: 'string';
                          };
                          job_title: {
                            description: "Department of the user as provided in the user's Zoom profile.";
                            type: 'string';
                          };
                          last_name: {
                            description: 'Last name of the contact.';
                            type: 'string';
                          };
                          location: {
                            description: "Location of the user as provided in the user's Zoom profile.";
                            type: 'string';
                          };
                          phone_number: {
                            description: 'Phone number of the user.';
                            type: 'string';
                          };
                          presence_status: {
                            description: 'Presence status of the contact in Zoom Client. The value of this field can be one of the following:\n`Do_Not_Disturb`<br> `away`<br> `Available`<br> `Offline`';
                            enum: ['Do_Not_Disturb', 'Away', 'Available', 'Offline'];
                            type: 'string';
                          };
                          sip_phone_number: {
                            description: 'SIP Phone number of the user. Returned only if user has SIP phone enabled.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    next_page_token: {
                      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                      type: 'string';
                    };
                    page_size: {
                      description: 'The number of records returned with a single API call. Default value is `1`.';
                      maximum: 25;
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br>\nContact returned successfully.';
          };
        };
        summary: 'Search company contacts';
        tags: ['Contacts'];
      };
    };
    '/groups': {
      get: {
        description: 'List [groups](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) under an account.\n\n**Prerequisite**: Pro or higher account.<br>\n**Scopes**: `group:read:admin`<br>\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`';
        operationId: 'groups';
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      groups: [
                        {
                          id: 'hFK_GtF_e_TaVA808';
                          name: 'ipsum';
                          total_members: 10;
                        },
                        {
                          id: 'TaVA8QKik_123';
                          name: 'awesomegroup';
                          total_members: 0;
                        },
                      ];
                      total_records: 2;
                    };
                  };
                };
                schema: {
                  description: 'List of Groups.';
                  properties: {
                    groups: {
                      description: 'List of Group objects.';
                      items: {
                        allOf: [
                          {
                            properties: {
                              id: {
                                description: 'Group ID.';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          },
                          {
                            description: 'Group object.';
                            properties: {
                              name: {
                                description: 'Group name.';
                                type: 'string';
                              };
                              total_members: {
                                description: 'Total number of members in this group.';
                                type: 'integer';
                              };
                            };
                            type: 'object';
                          },
                        ];
                      };
                      type: 'array';
                    };
                    total_records: {
                      description: 'Total records.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  description: 'List of Groups.';
                  properties: {
                    groups: {
                      description: 'List of Group objects.';
                      items: {
                        allOf: [
                          {
                            properties: {
                              id: {
                                description: 'Group ID.';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          },
                          {
                            description: 'Group object.';
                            properties: {
                              name: {
                                description: 'Group name.';
                                type: 'string';
                              };
                              total_members: {
                                description: 'Total number of members in this group.';
                                type: 'integer';
                              };
                            };
                            type: 'object';
                          },
                        ];
                      };
                      type: 'array';
                    };
                    total_records: {
                      description: 'Total records.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br>\nList of groups returned.<br>\n**Error Code:** `200`\nOnly available for paid accounts.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\n**Error Code:** `4130`<br> A group with this {groupId} does not exist.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'List groups';
        tags: ['Groups'];
      };
      post: {
        description: 'Create a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) under an account. \n\nYou can add a maximum of 100 groups in one account per day. If you go over, you will get an error. You can add a maximum of 5000 groups in one account.\n\n**Prerequisite**: Pro or higher account.<br>\n**Scopes**: `group:write:admin`<br>\n \n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`';
        operationId: 'groupCreate';
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  name: {
                    description: 'Group name.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  name: {
                    description: 'Group name.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
            };
          };
          required: true;
          'x-examples': {
            'application/json': {
              name: 'myawesomegroup';
            };
          };
        };
        responses: {
          '200': {
            description: '**Error Code:** `200`<br>\nOnly available for Paid account,{accountId}';
          };
          '201': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      id: 'string';
                      name: 'string';
                      total_members: 'integer';
                    };
                  };
                };
                schema: {
                  properties: {
                    id: {
                      description: 'Group ID.';
                      type: 'string';
                    };
                    name: {
                      description: 'Group name.';
                      type: 'string';
                    };
                    total_members: {
                      description: 'Group member count.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    id: {
                      description: 'Group ID.';
                      type: 'string';
                    };
                    name: {
                      description: 'Group name.';
                      type: 'string';
                    };
                    total_members: {
                      description: 'Group member count.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `201`<br>\nGroup created.';
            headers: {
              'Content-Location': {
                description: 'Location of created group';
                schema: {
                  type: 'string';
                };
              };
            };
          };
          '300': {
            description: '**Error Code:** `300`<br>\nMissing field: name.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>**Error Code:** `4130`<br>A group with this {groupId} does not exist.\n\n\n\n';
          };
          '409': {
            description: '**HTTP Status Code:** `409`<br> **Error Code:** `4132`<br> Group name {groupName} is already in use.';
          };
          '429': {
            description: '**HTTP Status Code:** `429`<br>\nYou have exceeded the daily rate limit ({0}) of Create a Group API request for this account. This limit resets at GMT 00:00:00.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Create a group';
        tags: ['Groups'];
      };
    };
    '/groups/{groupId}': {
      delete: {
        description: 'Delete a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-).\n\n**Prerequisite**: Pro, Business, or Education account<br>\n**Scopes**: `group:write:admin`<br>\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`';
        operationId: 'groupDelete';
        parameters: [
          {
            description: 'The group ID.<br>\nCan be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).';
            in: 'path';
            name: 'groupId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            description: '**Error Code:** `200`<br>\nOnly available for Paid account,{accountId}.';
          };
          '204': {
            description: '**HTTP Status Code:** `204`<br>\nGroup deleted.';
          };
          '300': {
            description: '**Error Code:** `300`<br>\nGroup member not found.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\nGroup not found.<br>\n**Error Code:** `4130`<br>\nA group with this {groupId} does not exist.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Delete a group';
        tags: ['Groups'];
      };
      get: {
        description: 'Get a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) under an account.\n\n**Prerequisite**: Pro, Business, or Education account<br>\n**Scopes**: `group:read:admin`<br>\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`';
        operationId: 'group';
        parameters: [
          {
            description: 'The group ID.<br>\nCan be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).';
            in: 'path';
            name: 'groupId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      id: 'chfhfhhfh_TKikJIX0';
                      name: 'My test group';
                      total_members: 0;
                    };
                  };
                };
                schema: {
                  properties: {
                    id: {
                      description: 'Group ID.';
                      type: 'string';
                    };
                    name: {
                      description: 'Group name.';
                      type: 'string';
                    };
                    total_members: {
                      description: 'Total count of members in the group.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
              'application/xml': {
                schema: {
                  properties: {
                    id: {
                      description: 'Group ID.';
                      type: 'string';
                    };
                    name: {
                      description: 'Group name.';
                      type: 'string';
                    };
                    total_members: {
                      description: 'Total count of members in the group.';
                      type: 'integer';
                    };
                  };
                  type: 'object';
                };
              };
            };
            description: '**HTTP Status Code:** `200`<br> Group returned.<br>\n**Error Code:** `200`<br>\nOnly available for Paid account,{accountId}.';
          };
          '400': {
            description: '**HTTP Status Code:** `400`<br>\n**Error Code:** `1010`<br>\nGroup does not belong to your account.';
          };
          '404': {
            description: '**HTTP Status Code:** `404`<br>\nGroup not found.<br>\n**Error Code:** `4130`<br> A group with this {groupId} does not exist.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Get a group';
        tags: ['Groups'];
      };
      patch: {
        description: 'Update a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) under your account.\n\n**Prerequisite**: Pro, Business, or Education account<br>\n**Scopes**: `group:write:admin`<br>\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`';
        operationId: 'groupUpdate';
        parameters: [
          {
            description: 'The group ID.<br>\nCan be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).';
            in: 'path';
            name: 'groupId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                properties: {
                  name: {
                    description: 'Group name. It must be unique to one account and less than 128 characters.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
            };
            'multipart/form-data': {
              schema: {
                properties: {
                  name: {
                    description: 'Group name. It must be unique to one account and less than 128 characters.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
            };
          };
          required: true;
          'x-examples': {
            'application/json': {
              name: 'amazinggroup';
            };
          };
        };
        responses: {
          '200': {
            description: 'The group does not belong to this account:{accountId}.';
          };
          '204': {
            description: 'Group updated.';
          };
          '404': {
            description: '**Status Code:** `404`<br>\nNot found.<br>\n**Error Code:** `4130`<br>\nA group with this {groupId} does not exist.';
          };
          '409': {
            description: '**Status Code:** `409`<br>\nConflict<br>\n**Error Code:** `4132`<br>\nGroup name {groupName} is already in use.';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Update a group';
        tags: ['Groups'];
      };
    };
    '/groups/{groupId}/lock_settings': {
      get: {
        description: 'Retrieve a [group\'s](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) locked settings. If you lock a setting, the group members will not be able to modify it individually. <p style="background-color:#FEEFB3; color:#9F6000"><br>Note:</b> The `force_pmi_jbh_password` field under meeting settings is planned to be deprecated on September 22, 2019. This field will be replaced by another field that will provide the same functionality.</p>\n\n**Prerequisite**: Pro, Business, or Education account<br>\n**Scopes**: `group:read:admin`<br>\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`';
        operationId: 'getGroupLockSettings';
        parameters: [
          {
            description: 'Id of the group.';
            in: 'path';
            name: 'groupId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Specify `meeting_security` as the value of this field if you would like to view security settings applied on a meeting hosted by the users in this group.';
            in: 'query';
            name: 'option';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                examples: {
                  response: {
                    value: {
                      email_notification: {
                        alternative_host_reminder: true;
                        cancel_meeting_reminder: true;
                        cloud_recording_available_reminder: true;
                        jbh_reminder: true;
                        schedule_for_host_reminder: true;
                      };
                      in_meeting: {
                        alert_guest_join: true;
                        allow_show_zoom_windows: true;
                        annotation: true;
                        attendee_on_hold: true;
                        auto_answer: true;
                        auto_saving_chat: true;
                        breakout_room: true;
                        chat: true;
                        closed_caption: true;
                        co_host: true;
                        e2e_encryption: true;
                        entry_exit_chime: false;
                        far_end_camera_control: true;
                        feedback: true;
                        group_hd: true;
                        non_verbal_feedback: true;
                        original_audio: true;
                        polling: true;
                        post_meeting_feedback: true;
                        private_chat: true;
                        remote_control: true;
                        remote_support: true;
                        screen_sharing: true;
                        sending_default_email_invites: true;
                        show_browser_join_link: true;
                        show_meeting_control_toolbar: true;
                        stereo_audio: true;
                        use_html_format_email: true;
                        virtual_background: true;
                        waiting_room: true;
                        whiteboard: true;
                      };
                      recording: {
                        account_user_access_recording: false;
                        auto_delete_cmr: false;
                        auto_recording: false;
                        cloud_recording: false;
                        cloud_recording_download: false;
                        host_delete_cloud_recording: false;
                        local_recording: false;
                      };
                      schedule_meeting: {
                        audio_type: true;
                        force_pmi_jbh_password: true;
                        host_video: true;
                        join_before_host: true;
                        mute_upon_entry: true;
                        participant_video: true;
                        pstn_password_protected: true;
                        require_password_for_instant_meetings: false;
                        require_password_for_pmi_meetings: true;
                        require_password_for_scheduling_new_meetings: true;
                        upcoming_meeting_reminder: true;
                      };
                      telephony: {
                        third_party_audio: false;
                      };
                    };
                  };
                };
                schema: {
                  oneOf: [
                    {
                      properties: {
                        email_notification: {
                          properties: {
                            alternative_host_reminder: {
                              description: 'Notify the alternative host who is set or removed.';
                              type: 'boolean';
                            };
                            cancel_meeting_reminder: {
                              description: 'Notify host and participants when the meeting is cancelled.';
                              type: 'boolean';
                            };
                            cloud_recording_available_reminder: {
                              description: 'Notify host when cloud recording is available.';
                              type: 'boolean';
                            };
                            jbh_reminder: {
                              description: 'Notify host when participants join the meeting before them.';
                              type: 'boolean';
                            };
                            schedule_for_host_reminder: {
                              description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        in_meeting: {
                          properties: {
                            alert_guest_join: {
                              description: 'Allow participants who belong to your account to see that a guest (someone who does not belong to your account) is participating in the meeting/webinar.';
                              type: 'boolean';
                            };
                            allow_show_zoom_windows: {
                              description: 'Show Zoom windows during screen share.';
                              type: 'boolean';
                            };
                            annotation: {
                              description: 'Allow participants to use annotation tools to add information to shared screens.';
                              type: 'boolean';
                            };
                            attendee_on_hold: {
                              default: false;
                              description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
                              type: 'boolean';
                            };
                            auto_answer: {
                              description: "Enable users to see and add contacts to 'auto-answer group' in the contact list on chat. Any call from members of this group will be automatically answered.";
                              type: 'boolean';
                            };
                            auto_saving_chat: {
                              description: 'Automatically save all in-meeting chats.';
                              type: 'boolean';
                            };
                            breakout_room: {
                              description: 'Allow host to split meeting participants into separate, smaller rooms.';
                              type: 'boolean';
                            };
                            chat: {
                              description: 'Allow meeting participants to send chat message visible to all participants.';
                              type: 'boolean';
                            };
                            closed_caption: {
                              description: 'Allow host to type closed captions or assign a participant/third party device to add closed captions.';
                              type: 'boolean';
                            };
                            co_host: {
                              description: 'Allow the host to add co-hosts. Co-hosts have the same in-meeting controls as the host.';
                              type: 'boolean';
                            };
                            custom_data_center_regions: {
                              description: 'Displays whether or not custom [data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) have been selected for meetings/webinars hosted by this group.';
                              type: 'boolean';
                            };
                            e2e_encryption: {
                              description: 'Require that all meetings are encrypted using AES.';
                              type: 'boolean';
                            };
                            entry_exit_chime: {
                              description: 'Play sound when participants join or leave.';
                              type: 'string';
                            };
                            far_end_camera_control: {
                              description: 'Allow another user to take control of the camera during a meeting.';
                              type: 'boolean';
                            };
                            feedback: {
                              description: 'Enable users to provide feedback to Zoom at the end of the meeting.';
                              type: 'boolean';
                            };
                            file_transfer: {
                              description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for the users in the group or not.';
                              type: 'boolean';
                            };
                            group_hd: {
                              description: 'Enable higher quality video for host and participants. This will require more bandwidth.';
                              type: 'boolean';
                            };
                            non_verbal_feedback: {
                              description: 'Allow participants in a meeting can provide nonverbal feedback and express opinions by clicking on icons in the Participants panel.';
                              type: 'boolean';
                            };
                            original_audio: {
                              description: 'Allow users to select original sound during a meeting.';
                              type: 'boolean';
                            };
                            polling: {
                              description: "Add 'Polls' to the meeting controls. This allows the host to survey the attendees.";
                              type: 'boolean';
                            };
                            post_meeting_feedback: {
                              description: 'Display end-of-meeting experience feedback survey.';
                              type: 'boolean';
                            };
                            private_chat: {
                              description: 'Allow meeting participants to send a private 1:1 message to another participant.';
                              type: 'boolean';
                            };
                            remote_control: {
                              description: 'During screen sharing, allow the person who is sharing to let others control the shared content.';
                              type: 'boolean';
                            };
                            remote_support: {
                              description: 'Allow meeting host to provide 1:1 remote support to another participant.';
                              type: 'boolean';
                            };
                            request_permission_to_unmute: {
                              description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled and locked for the group or not.';
                              type: 'boolean';
                            };
                            screen_sharing: {
                              description: 'Allow host and participants to share their screen or content during meetings.';
                              type: 'boolean';
                            };
                            sending_default_email_invites: {
                              description: 'Allow users to invite participants by email only by default.';
                              type: 'boolean';
                            };
                            show_browser_join_link: {
                              description: 'Allow participants to join a meeting directly from their browser.';
                              type: 'boolean';
                            };
                            show_meeting_control_toolbar: {
                              description: 'Always show meeting controls during a meeting.';
                              type: 'boolean';
                            };
                            stereo_audio: {
                              description: 'Allow users to select stereo audio during a meeting.';
                              type: 'boolean';
                            };
                            use_html_format_email: {
                              description: 'Allow  HTML formatting instead of plain text for meeting invitations scheduled with the Outlook plugin.';
                              type: 'boolean';
                            };
                            virtual_background: {
                              description: 'Enable virtual background.';
                              type: 'boolean';
                            };
                            waiting_room: {
                              description: 'Attendees cannot join a meeting until a host admits them individually from the waiting room.';
                              type: 'boolean';
                            };
                            whiteboard: {
                              description: 'Allow participants to share a whiteboard that includes annotation tools.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        recording: {
                          properties: {
                            account_user_access_recording: {
                              description: 'Make cloud recordings accessible to account members only.';
                              type: 'boolean';
                            };
                            auto_delete_cmr: {
                              description: 'Allow Zoom to automatically delete recordings permanently after a specified number of days.';
                              type: 'boolean';
                            };
                            auto_recording: {
                              description: 'Record meetings automatically as they start.';
                              type: 'string';
                            };
                            cloud_recording: {
                              description: 'Allow hosts to record and save the meeting / webinar in the cloud.';
                              type: 'boolean';
                            };
                            cloud_recording_download: {
                              description: 'Allow anyone with a link to the cloud recording to download.';
                              type: 'boolean';
                            };
                            host_delete_cloud_recording: {
                              description: 'Allow the host to delete the recordings. If this option is disabled, the recordings cannot be deleted by the host and only admin can delete them.';
                              type: 'boolean';
                            };
                            ip_address_access_control: {
                              description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
                              properties: {
                                enable: {
                                  description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                                  type: 'boolean';
                                };
                                ip_addresses_or_ranges: {
                                  description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            local_recording: {
                              description: 'Allow hosts and participants to record the meeting to a local file.';
                              type: 'boolean';
                            };
                            prevent_host_access_recording: {
                              description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n\n';
                              type: 'boolean';
                            };
                            recording_authentication: {
                              description: 'Only authenticated users can view cloud recordings';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        schedule_meeting: {
                          properties: {
                            audio_type: {
                              description: 'Determine how participants can join the audio portion of the meeting.';
                              type: 'boolean';
                            };
                            embed_password_in_join_link: {
                              description: 'If the value is set to `true`, the meeting password will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the password.\n ';
                              type: 'boolean';
                            };
                            force_pmi_jbh_password: {
                              description: 'If join before host option is enabled for a personal meeting, then enforce password requirement.';
                              type: 'boolean';
                            };
                            host_video: {
                              description: 'Start meetings with host video on.';
                              type: 'boolean';
                            };
                            join_before_host: {
                              description: 'Allow participants to join the meeting before the host arrives';
                              type: 'boolean';
                            };
                            meeting_authentication: {
                              description: 'Only authenticated users can join meetings';
                              type: 'boolean';
                            };
                            mute_upon_entry: {
                              description: 'Automatically mute all participants when they join the meeting.';
                              type: 'boolean';
                            };
                            participant_video: {
                              description: 'Start meetings with participant video on.';
                              type: 'boolean';
                            };
                            pstn_password_protected: {
                              description: 'Generate and send new passwords for newly scheduled or edited meetings.';
                              type: 'boolean';
                            };
                            require_password_for_instant_meetings: {
                              description: 'Require password for instant meetings. If you use PMI for your instant meetings, this option will be disabled.';
                              type: 'boolean';
                            };
                            require_password_for_pmi_meetings: {
                              description: 'Require participants to enter password for PMI meetings.';
                              type: 'boolean';
                            };
                            require_password_for_scheduling_new_meetings: {
                              description: 'This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting.';
                              type: 'boolean';
                            };
                            upcoming_meeting_reminder: {
                              description: 'Receive desktop notification for upcoming meetings.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        telephony: {
                          properties: {
                            telephony_regions: {
                              type: 'boolean';
                            };
                            third_party_audio: {
                              description: 'Allow users to join the meeting using the existing 3rd party audio configuration.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                      };
                      type: 'object';
                    },
                    {
                      properties: {
                        meeting_security: {
                          properties: {
                            auto_security: {
                              description: '`true`: Require that all meetings are secured with at least one security option.\n\nThis setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).';
                              type: 'boolean';
                            };
                            embed_password_in_join_link: {
                              description: 'If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.\n';
                              type: 'boolean';
                            };
                            encryption_type: {
                              description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                              enum: ['enhanced_encryption', 'e2ee'];
                              type: 'string';
                            };
                            end_to_end_encrypted_meetings: {
                              description: 'Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.';
                              type: 'boolean';
                            };
                            meeting_password: {
                              description: 'If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.';
                              type: 'boolean';
                            };
                            meeting_password_requirement: {
                              description: 'Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                              properties: {
                                consecutive_characters_length: {
                                  enum: [0, 4, 5, 6, 7, 8];
                                  type: 'integer';
                                };
                                have_letter: {
                                  description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                                  type: 'boolean';
                                };
                                have_number: {
                                  description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                                  type: 'boolean';
                                };
                                have_special_character: {
                                  description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                                  type: 'boolean';
                                };
                                have_upper_and_lower_characters: {
                                  description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                                  type: 'boolean';
                                };
                                length: {
                                  description: 'The minimum length that the meeting/webinar passcode needs to have.';
                                  type: 'integer';
                                };
                                only_allow_numeric: {
                                  description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                                  type: 'boolean';
                                };
                                weak_enhance_detection: {
                                  description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                                  type: 'boolean';
                                };
                              };
                              type: 'object';
                            };
                            phone_password: {
                              description: 'Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.';
                              type: 'boolean';
                            };
                            pmi_password: {
                              description: 'If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduled_meeting: {
                              description: 'Require a passcode for meetings which have already been scheduled.\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduled_webinar: {
                              description: 'Require a passcode for webinars which have already been scheduled.\n';
                              type: 'boolean';
                            };
                            waiting_room: {
                              description: 'When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.\n';
                              type: 'boolean';
                            };
                            waiting_room_settings: {
                              description: 'Specify the settings to be applied if waiting room is enabled.';
                              properties: {
                                participants_to_place_in_waiting_room: {
                                  description: '\n\nSpecify who should be admitted to the waiting room. The value of this field can be one of the following:<br>\n`0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in ';
                                  enum: [0, 1, 2];
                                  type: 'integer';
                                };
                                users_who_can_admit_participants_from_waiting_room: {
                                  description: 'Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>\n`0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).\n\n\n';
                                  type: 'integer';
                                };
                                whitelisted_domains_for_waiting_room: {
                                  description: 'If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            webinar_password: {
                              description: 'If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.\n';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                      };
                      title: 'Meeting/Webinar Security Settings';
                      type: 'object';
                    },
                  ];
                };
              };
              'application/xml': {
                schema: {
                  oneOf: [
                    {
                      properties: {
                        email_notification: {
                          properties: {
                            alternative_host_reminder: {
                              description: 'Notify the alternative host who is set or removed.';
                              type: 'boolean';
                            };
                            cancel_meeting_reminder: {
                              description: 'Notify host and participants when the meeting is cancelled.';
                              type: 'boolean';
                            };
                            cloud_recording_available_reminder: {
                              description: 'Notify host when cloud recording is available.';
                              type: 'boolean';
                            };
                            jbh_reminder: {
                              description: 'Notify host when participants join the meeting before them.';
                              type: 'boolean';
                            };
                            schedule_for_host_reminder: {
                              description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        in_meeting: {
                          properties: {
                            alert_guest_join: {
                              description: 'Allow participants who belong to your account to see that a guest (someone who does not belong to your account) is participating in the meeting/webinar.';
                              type: 'boolean';
                            };
                            allow_show_zoom_windows: {
                              description: 'Show Zoom windows during screen share.';
                              type: 'boolean';
                            };
                            annotation: {
                              description: 'Allow participants to use annotation tools to add information to shared screens.';
                              type: 'boolean';
                            };
                            attendee_on_hold: {
                              default: false;
                              description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
                              type: 'boolean';
                            };
                            auto_answer: {
                              description: "Enable users to see and add contacts to 'auto-answer group' in the contact list on chat. Any call from members of this group will be automatically answered.";
                              type: 'boolean';
                            };
                            auto_saving_chat: {
                              description: 'Automatically save all in-meeting chats.';
                              type: 'boolean';
                            };
                            breakout_room: {
                              description: 'Allow host to split meeting participants into separate, smaller rooms.';
                              type: 'boolean';
                            };
                            chat: {
                              description: 'Allow meeting participants to send chat message visible to all participants.';
                              type: 'boolean';
                            };
                            closed_caption: {
                              description: 'Allow host to type closed captions or assign a participant/third party device to add closed captions.';
                              type: 'boolean';
                            };
                            co_host: {
                              description: 'Allow the host to add co-hosts. Co-hosts have the same in-meeting controls as the host.';
                              type: 'boolean';
                            };
                            custom_data_center_regions: {
                              description: 'Displays whether or not custom [data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) have been selected for meetings/webinars hosted by this group.';
                              type: 'boolean';
                            };
                            e2e_encryption: {
                              description: 'Require that all meetings are encrypted using AES.';
                              type: 'boolean';
                            };
                            entry_exit_chime: {
                              description: 'Play sound when participants join or leave.';
                              type: 'string';
                            };
                            far_end_camera_control: {
                              description: 'Allow another user to take control of the camera during a meeting.';
                              type: 'boolean';
                            };
                            feedback: {
                              description: 'Enable users to provide feedback to Zoom at the end of the meeting.';
                              type: 'boolean';
                            };
                            file_transfer: {
                              description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for the users in the group or not.';
                              type: 'boolean';
                            };
                            group_hd: {
                              description: 'Enable higher quality video for host and participants. This will require more bandwidth.';
                              type: 'boolean';
                            };
                            non_verbal_feedback: {
                              description: 'Allow participants in a meeting can provide nonverbal feedback and express opinions by clicking on icons in the Participants panel.';
                              type: 'boolean';
                            };
                            original_audio: {
                              description: 'Allow users to select original sound during a meeting.';
                              type: 'boolean';
                            };
                            polling: {
                              description: "Add 'Polls' to the meeting controls. This allows the host to survey the attendees.";
                              type: 'boolean';
                            };
                            post_meeting_feedback: {
                              description: 'Display end-of-meeting experience feedback survey.';
                              type: 'boolean';
                            };
                            private_chat: {
                              description: 'Allow meeting participants to send a private 1:1 message to another participant.';
                              type: 'boolean';
                            };
                            remote_control: {
                              description: 'During screen sharing, allow the person who is sharing to let others control the shared content.';
                              type: 'boolean';
                            };
                            remote_support: {
                              description: 'Allow meeting host to provide 1:1 remote support to another participant.';
                              type: 'boolean';
                            };
                            request_permission_to_unmute: {
                              description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled and locked for the group or not.';
                              type: 'boolean';
                            };
                            screen_sharing: {
                              description: 'Allow host and participants to share their screen or content during meetings.';
                              type: 'boolean';
                            };
                            sending_default_email_invites: {
                              description: 'Allow users to invite participants by email only by default.';
                              type: 'boolean';
                            };
                            show_browser_join_link: {
                              description: 'Allow participants to join a meeting directly from their browser.';
                              type: 'boolean';
                            };
                            show_meeting_control_toolbar: {
                              description: 'Always show meeting controls during a meeting.';
                              type: 'boolean';
                            };
                            stereo_audio: {
                              description: 'Allow users to select stereo audio during a meeting.';
                              type: 'boolean';
                            };
                            use_html_format_email: {
                              description: 'Allow  HTML formatting instead of plain text for meeting invitations scheduled with the Outlook plugin.';
                              type: 'boolean';
                            };
                            virtual_background: {
                              description: 'Enable virtual background.';
                              type: 'boolean';
                            };
                            waiting_room: {
                              description: 'Attendees cannot join a meeting until a host admits them individually from the waiting room.';
                              type: 'boolean';
                            };
                            whiteboard: {
                              description: 'Allow participants to share a whiteboard that includes annotation tools.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        recording: {
                          properties: {
                            account_user_access_recording: {
                              description: 'Make cloud recordings accessible to account members only.';
                              type: 'boolean';
                            };
                            auto_delete_cmr: {
                              description: 'Allow Zoom to automatically delete recordings permanently after a specified number of days.';
                              type: 'boolean';
                            };
                            auto_recording: {
                              description: 'Record meetings automatically as they start.';
                              type: 'string';
                            };
                            cloud_recording: {
                              description: 'Allow hosts to record and save the meeting / webinar in the cloud.';
                              type: 'boolean';
                            };
                            cloud_recording_download: {
                              description: 'Allow anyone with a link to the cloud recording to download.';
                              type: 'boolean';
                            };
                            host_delete_cloud_recording: {
                              description: 'Allow the host to delete the recordings. If this option is disabled, the recordings cannot be deleted by the host and only admin can delete them.';
                              type: 'boolean';
                            };
                            ip_address_access_control: {
                              description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
                              properties: {
                                enable: {
                                  description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                                  type: 'boolean';
                                };
                                ip_addresses_or_ranges: {
                                  description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            local_recording: {
                              description: 'Allow hosts and participants to record the meeting to a local file.';
                              type: 'boolean';
                            };
                            prevent_host_access_recording: {
                              description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n\n';
                              type: 'boolean';
                            };
                            recording_authentication: {
                              description: 'Only authenticated users can view cloud recordings';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        schedule_meeting: {
                          properties: {
                            audio_type: {
                              description: 'Determine how participants can join the audio portion of the meeting.';
                              type: 'boolean';
                            };
                            embed_password_in_join_link: {
                              description: 'If the value is set to `true`, the meeting password will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the password.\n ';
                              type: 'boolean';
                            };
                            force_pmi_jbh_password: {
                              description: 'If join before host option is enabled for a personal meeting, then enforce password requirement.';
                              type: 'boolean';
                            };
                            host_video: {
                              description: 'Start meetings with host video on.';
                              type: 'boolean';
                            };
                            join_before_host: {
                              description: 'Allow participants to join the meeting before the host arrives';
                              type: 'boolean';
                            };
                            meeting_authentication: {
                              description: 'Only authenticated users can join meetings';
                              type: 'boolean';
                            };
                            mute_upon_entry: {
                              description: 'Automatically mute all participants when they join the meeting.';
                              type: 'boolean';
                            };
                            participant_video: {
                              description: 'Start meetings with participant video on.';
                              type: 'boolean';
                            };
                            pstn_password_protected: {
                              description: 'Generate and send new passwords for newly scheduled or edited meetings.';
                              type: 'boolean';
                            };
                            require_password_for_instant_meetings: {
                              description: 'Require password for instant meetings. If you use PMI for your instant meetings, this option will be disabled.';
                              type: 'boolean';
                            };
                            require_password_for_pmi_meetings: {
                              description: 'Require participants to enter password for PMI meetings.';
                              type: 'boolean';
                            };
                            require_password_for_scheduling_new_meetings: {
                              description: 'This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting.';
                              type: 'boolean';
                            };
                            upcoming_meeting_reminder: {
                              description: 'Receive desktop notification for upcoming meetings.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                        telephony: {
                          properties: {
                            telephony_regions: {
                              type: 'boolean';
                            };
                            third_party_audio: {
                              description: 'Allow users to join the meeting using the existing 3rd party audio configuration.';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                      };
                      type: 'object';
                    },
                    {
                      properties: {
                        meeting_security: {
                          properties: {
                            auto_security: {
                              description: '`true`: Require that all meetings are secured with at least one security option.\n\nThis setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).';
                              type: 'boolean';
                            };
                            embed_password_in_join_link: {
                              description: 'If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.\n';
                              type: 'boolean';
                            };
                            encryption_type: {
                              description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                              enum: ['enhanced_encryption', 'e2ee'];
                              type: 'string';
                            };
                            end_to_end_encrypted_meetings: {
                              description: 'Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.';
                              type: 'boolean';
                            };
                            meeting_password: {
                              description: 'If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.';
                              type: 'boolean';
                            };
                            meeting_password_requirement: {
                              description: 'Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
                              properties: {
                                consecutive_characters_length: {
                                  enum: [0, 4, 5, 6, 7, 8];
                                  type: 'integer';
                                };
                                have_letter: {
                                  description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                                  type: 'boolean';
                                };
                                have_number: {
                                  description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                                  type: 'boolean';
                                };
                                have_special_character: {
                                  description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                                  type: 'boolean';
                                };
                                have_upper_and_lower_characters: {
                                  description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                                  type: 'boolean';
                                };
                                length: {
                                  description: 'The minimum length that the meeting/webinar passcode needs to have.';
                                  type: 'integer';
                                };
                                only_allow_numeric: {
                                  description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                                  type: 'boolean';
                                };
                                weak_enhance_detection: {
                                  description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                                  type: 'boolean';
                                };
                              };
                              type: 'object';
                            };
                            phone_password: {
                              description: 'Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.';
                              type: 'boolean';
                            };
                            pmi_password: {
                              description: 'If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduled_meeting: {
                              description: 'Require a passcode for meetings which have already been scheduled.\n';
                              type: 'boolean';
                            };
                            require_password_for_scheduled_webinar: {
                              description: 'Require a passcode for webinars which have already been scheduled.\n';
                              type: 'boolean';
                            };
                            waiting_room: {
                              description: 'When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.\n';
                              type: 'boolean';
                            };
                            waiting_room_settings: {
                              description: 'Specify the settings to be applied if waiting room is enabled.';
                              properties: {
                                participants_to_place_in_waiting_room: {
                                  description: '\n\nSpecify who should be admitted to the waiting room. The value of this field can be one of the following:<br>\n`0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in ';
                                  enum: [0, 1, 2];
                                  type: 'integer';
                                };
                                users_who_can_admit_participants_from_waiting_room: {
                                  description: 'Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>\n`0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).\n\n\n';
                                  type: 'integer';
                                };
                                whitelisted_domains_for_waiting_room: {
                                  description: 'If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").';
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            webinar_password: {
                              description: 'If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.\n';
                              type: 'boolean';
                            };
                          };
                          type: 'object';
                        };
                      };
                      title: 'Meeting/Webinar Security Settings';
                      type: 'object';
                    },
                  ];
                };
              };
            };
            description: '**Error Code:** `200`<br>\nOnly available for paid account.\n\n**Status Code:** `200`<br>\nLocked settings of group returned.\n';
          };
          '404': {
            description: '**Status Code:** `404`<br>\nNot found.<br>\n**Error Code:** `4130`<br>\nGroup does not exist: {groupId}';
          };
        };
        security: [
          {
            OAuth: [];
          },
        ];
        summary: 'Get locked settings';
        tags: ['Groups'];
      };
      parameters: [
        {
          in: 'path';
          name: 'groupId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Provide the name of the field by which you would like to filter the response. For example, if you provide "host_video" as the value of this field, you will get a response similar to the following:<br>\n{\n    "schedule_meeting": {\n        "host_video": false\n    }\n}\n<br>You can provide multiple values by separating them with commas(example: "host_video,participant_video”).';
          in: 'query';
          name: 'custom_query_fields';
          schema: {
            type: 'string';
          };
        },
      ];
      patch: {
        description: 'Update a [group\'s](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) locked settings. If you lock a setting, the group members will not be able to modify it individually. <p style="background-color:#FEEFB3; color:#9F6000"><br>Note:</b> The `force_pmi_jbh_password` field under meeting settings is planned to be deprecated on September 22, 2019. This field will be replaced by another field that will provide the same functionality.</p>\n\n**Prerequisite**: Pro, Business, or Education account<br>\n**Scopes**: `group:write:admin`<br>\n\n **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`';
        operationId: 'groupLockedSettings';
        parameters: [
          {
            description: 'The Id of the group.';
            in: 'path';
            name: 'groupId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Specify `meeting_security` as the value of this field if you would like to view security settings applied on a meeting hosted by the users in this group.';
            in: 'query';
            name: 'option';
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                oneOf: [
                  {
                    properties: {
                      email_notification: {
                        properties: {
                          alternative_host_reminder: {
                            description: 'Notify the alternative host who is set or removed.';
                            type: 'boolean';
                          };
                          cancel_meeting_reminder: {
                            description: 'Notify host and participants when the meeting is cancelled.';
                            type: 'boolean';
                          };
                          cloud_recording_available_reminder: {
                            description: 'Notify host when cloud recording is available.';
                            type: 'boolean';
    