// @ts-nocheck
export type TComponents = {
  parameters: {
    AccountId: {
      description: 'The account ID.';
      in: 'path';
      name: 'accountId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    DeviceId: {
      description: 'The device ID.';
      in: 'path';
      name: 'deviceId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    FeedbackId: {
      description: 'Feedback Detail Id';
      in: 'path';
      name: 'feedbackId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    FromDate: {
      description: 'Start date in \'yyyy-mm-dd\' format. The date range defined by the "from" and "to" parameters should only be one month as the report includes only one month worth of data at once.';
      in: 'query';
      name: 'from';
      required: true;
      schema: {
        format: 'date';
        type: 'string';
      };
    };
    GroupId: {
      description: 'The group ID.<br>\nCan be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).';
      in: 'path';
      name: 'groupId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    LoginType: {
      description: '`0` - Facebook.<br>`1` - Google.<br>`99` - API.<br>`100` - Zoom.<br>`101` - SSO.';
      in: 'query';
      name: 'login_type';
      schema: {
        enum: ['0', '1', '99', '100', '101'];
        type: 'string';
      };
      'x-enum-descriptions': ['Facebook', 'Google', 'API', 'Zoom', 'SSO'];
    };
    Mc: {
      description: 'Query Metadata of Recording if an On-Premise Meeting Connector was used for the meeting.';
      in: 'query';
      name: 'mc';
      schema: {
        default: 'false';
        type: 'string';
      };
    };
    MeetingId: {
      description: 'The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).\n\nWhile storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.';
      in: 'path';
      name: 'meetingId';
      required: true;
      schema: {
        format: 'int64';
        type: 'integer';
      };
    };
    MeetingId4Metrics: {
      description: 'The meeting ID or the meeting UUID.  If a meeting ID is provided in the request instead of a UUID, the response will be for the latest meeting instance.\n\nIf a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875==\\"), you must **double encode** the UUID before making an API request.';
      in: 'path';
      name: 'meetingId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    MeetingId4Recording: {
      description: 'To get Cloud Recordings of a meeting, provide the meeting ID or meeting UUID. If the meeting ID is provided instead of UUID,the response will be for the latest meeting instance. \n\nTo get Cloud Recordings of a webinar, provide the webinar ID or the webinar UUID. If the webinar ID is provided instead of UUID,the response will be for the latest webinar instance. \n\nIf a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875=="), you must **double encode** the UUID before making an API request. ';
      in: 'path';
      name: 'meetingId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    MeetingIdNumber: {
      description: 'The meeting ID or UUID.';
      in: 'path';
      name: 'meetingId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    MeetingType: {
      description: 'The meeting types: <br>`scheduled` - This includes all valid past meetings (unexpired), live meetings and upcoming scheduled meetings. It is equivalent to the combined list of "Previous Meetings" and "Upcoming Meetings" displayed in the user\'s [Meetings page](https://zoom.us/meeting) on the Zoom Web Portal.<br>`live` - All the ongoing meetings.<br>`upcoming` - All upcoming meetings including live meetings.';
      in: 'query';
      name: 'type';
      schema: {
        default: 'live';
        enum: ['scheduled', 'live', 'upcoming'];
        type: 'string';
      };
      'x-enum-descriptions': ['all the scheduled meetings', 'all the live meetings', 'all the upcoming meetings'];
    };
    MeetingTypePast: {
      description: 'Specify a value to get the response for the corresponding meeting type. The value of this field can be one of the following:<br> <br>`past` - Meeting that already occurred in the specified date range.<br>`pastOne` - Past meetings that were attended by only one user. <br>`live` - Live meetings.<br><br>\n\nIf you do not provide this field, the default value will be `live` and thus, the API will only query responses for live meetings.';
      in: 'query';
      name: 'type';
      schema: {
        default: 'live';
        enum: ['past', 'pastOne', 'live'];
        type: 'string';
      };
      'x-enum-descriptions': ['past meetings', 'past one user meetings', 'live meetings'];
    };
    MeetingTypePast2: {
      description: 'The meeting types: <br>`past` - Past meetings.<br>`live` - Live Meetings.';
      in: 'query';
      name: 'type';
      schema: {
        default: 'live';
        enum: ['past', 'pastOne', 'live'];
        type: 'string';
      };
      'x-enum-descriptions': ['past meeting', 'single past user meetings', 'live meeting'];
    };
    MeetingTypePast3: {
      description: 'The meeting types: <br>`past` - Past meetings.<br>`pastOne` - Past one user meetings.<br>`live` - Live meetings.';
      in: 'query';
      name: 'type';
      schema: {
        default: 'live';
        enum: ['past', 'pastOne', 'live'];
        type: 'string';
      };
      'x-enum-descriptions': ['past meeting', 'past one user meeting', 'live meeting'];
    };
    MeetingUUID: {
      description: "The meeting UUID. Each meeting instance will generate its own Meeting UUID (i.e., after a meeting ends, a new UUID will be generated for the next instance of the meeting). Please double encode your UUID when using it for other API calls if the UUID begins with a '/'or contains '//' in it.";
      in: 'path';
      name: 'meetingUUID';
      required: true;
      schema: {
        type: 'string';
      };
    };
    MemberId: {
      description: 'The member ID.';
      in: 'path';
      name: 'memberId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    NextPageToken: {
      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
      in: 'query';
      name: 'next_page_token';
      schema: {
        type: 'string';
      };
    };
    OccurrenceId: {
      description: 'The meeting occurrence ID.';
      in: 'query';
      name: 'occurrence_id';
      schema: {
        type: 'string';
      };
    };
    PageNumber: {
      description: '\n**Deprecated** - This field has been deprecated and we will stop supporting it completely in a future release. Please use "next_page_token" for pagination instead of this field.\n\nThe page number of the current page in the returned records.';
      in: 'query';
      name: 'page_number';
      schema: {
        default: 1;
        type: 'integer';
      };
    };
    PageSize: {
      description: 'The number of records returned within a single API call.';
      in: 'query';
      name: 'page_size';
      schema: {
        default: 30;
        maximum: 300;
        type: 'integer';
      };
    };
    PageSize4Qos: {
      description: 'The number of items returned per page.';
      in: 'query';
      name: 'page_size';
      schema: {
        default: 1;
        maximum: 10;
        type: 'integer';
      };
    };
    PageToken: {
      description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceed the current page size. The expiration period for this token is 15 minutes.';
      in: 'query';
      name: 'next_page_token';
      schema: {
        type: 'string';
      };
    };
    ParticipantId: {
      description: 'Participant ID.';
      in: 'path';
      name: 'participantId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    RecordingDeleteAction: {
      description: 'The recording delete actions:<br>`trash` - Move recording to trash.<br>`delete` - Delete recording permanently.';
      in: 'query';
      name: 'action';
      schema: {
        default: 'trash';
        enum: ['trash', 'delete'];
        type: 'string';
      };
      'x-enum-descriptions': ['move recording to trash', 'delete recording permanently'];
    };
    RecordingId: {
      description: 'The recording ID.';
      in: 'path';
      name: 'recordingId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    RegistrantId: {
      description: 'The registrant ID.';
      in: 'path';
      name: 'registrantId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    RegistrantStatus: {
      description: "The registrant status:<br>`pending` - Registrant's status is pending.<br>`approved` - Registrant's status is approved.<br>`denied` - Registrant's status is denied.";
      in: 'query';
      name: 'status';
      schema: {
        default: 'approved';
        enum: ['pending', 'approved', 'denied'];
        type: 'string';
      };
      'x-enum-descriptions': [
        'registrants status is pending',
        'registrants status is approved',
        'registrants status is denied',
      ];
    };
    RoleId: {
      description: 'The role ID';
      in: 'path';
      name: 'roleId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    SessionId: {
      description: 'IM chat session ID.';
      in: 'path';
      name: 'sessionId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    TSPId: {
      description: 'TSP account ID.';
      in: 'path';
      name: 'tspId';
      required: true;
      schema: {
        enum: [1, 2];
        type: 'string';
      };
    };
    ToDate: {
      description: 'End date.';
      in: 'query';
      name: 'to';
      required: true;
      schema: {
        format: 'date';
        type: 'string';
      };
    };
    TrackingSourceId: {
      description: 'The tracking source ID for the registrants. Useful if you share the webinar registration page in multiple locations. See [Creating source tracking links for webinar registration](https://support.zoom.us/hc/en-us/articles/360000315683-Creating-source-tracking-links-for-webinar-registration) for details.';
      in: 'query';
      name: 'tracking_source_id';
      schema: {
        type: 'string';
      };
    };
    TransferEmail: {
      description: 'Transfer email.';
      in: 'query';
      name: 'transfer_email';
      required: false;
      schema: {
        type: 'string';
      };
    };
    TransferMeeting: {
      description: 'Transfer meeting.';
      in: 'query';
      name: 'transfer_meeting';
      required: false;
      schema: {
        type: 'boolean';
      };
    };
    TransferRecording: {
      description: 'Transfer recording.';
      in: 'query';
      name: 'transfer_recording';
      required: false;
      schema: {
        type: 'boolean';
      };
    };
    TransferWebinar: {
      description: 'Transfer webinar.';
      in: 'query';
      name: 'transfer_webinar';
      required: false;
      schema: {
        type: 'boolean';
      };
    };
    Trash: {
      description: 'Query trash.\n`true`: List recordings from trash.<br> `false`: Do not list recordings from the trash.<br> The default value is `false`. If you set it to `true`, you can use the `trash_type` property to indicate the type of Cloud recording that you need to retrieve. ';
      in: 'query';
      name: 'trash';
      schema: {
        default: false;
        type: 'boolean';
      };
    };
    UserId: {
      description: 'The user ID or email address of the user. For user-level apps, pass `me` as the value for userId.';
      in: 'path';
      name: 'userId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    WebhookId: {
      description: 'The webhook ID.';
      in: 'path';
      name: 'webhookId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    WebinarId: {
      description: 'The webinar ID in "**long**" format(represented as int64 data type in JSON). ';
      in: 'path';
      name: 'webinarId';
      required: true;
      schema: {
        format: 'int64';
        type: 'integer';
      };
    };
    WebinarId4Metrics: {
      description: 'The webinar ID or the webinar UUID.  If a webinar ID is provided in the request instead of a UUID, the response will be for the latest webinar instance.\n\nIf a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875==\\"), you must **double encode** the UUID before making an API request.';
      in: 'path';
      name: 'webinarId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    WebinarTypePast: {
      description: 'The webinar type.';
      in: 'query';
      name: 'type';
      schema: {
        default: 'live';
        enum: ['past', 'live'];
        type: 'string';
      };
      'x-enum-descriptions': ['past webinars', 'live webinars'];
    };
    WebinarTypePast2: {
      description: 'The webinar type.';
      in: 'query';
      name: 'type';
      schema: {
        default: 'live';
        enum: ['past', 'live'];
        type: 'string';
      };
      'x-enum-descriptions': ['past webinar', 'live webinar'];
    };
    WebinarUUID: {
      description: "The Webinar UUID. Each Webinar instance will generate its own Webinar UUID (i.e., after a Webinar ends, a new UUID will be generated for the next instance of the Webinar). Please double encode your UUID when using it for API calls if the UUID begins with a '/' or contains '//' in it.";
      in: 'path';
      name: 'WebinarUUID';
      required: true;
      schema: {
        type: 'string';
      };
    };
    ZoomRoomId: {
      description: 'The Zoom room ID.';
      in: 'path';
      name: 'zoomroomId';
      required: true;
      schema: {
        type: 'string';
      };
    };
    trash_type: {
      description: 'The type of Cloud recording that you would like to retrieve from the trash. The value can be one of the following:<br>\n    `meeting_recordings`: List all meeting recordings from the trash.<br>\n    `recording_file`: List all individual recording files from the trash. ';
      in: 'query';
      name: 'trash_type';
      schema: {
        default: 'meeting_recordings';
        type: 'string';
      };
    };
  };
  requestBodies: {
    recordingStatusUpdateBody: {
      content: {
        'application/json': {
          schema: {
            properties: {
              action: {
                enum: ['recover'];
                type: 'string';
                'x-enum-descriptions': ['recover meeting recording'];
              };
            };
          };
        };
        'multipart/form-data': {
          schema: {
            properties: {
              action: {
                enum: ['recover'];
                type: 'string';
                'x-enum-descriptions': ['recover meeting recording'];
              };
            };
          };
        };
      };
      required: true;
      'x-examples': {
        'application/json': {
          action: 'recover';
        };
      };
    };
    updateChannelBody: {
      content: {
        'application/json': {
          schema: {
            properties: {
              name: {
                description: 'A new name for the channel.';
                type: 'string';
              };
            };
            required: ['name'];
            type: 'object';
          };
        };
        'multipart/form-data': {
          schema: {
            properties: {
              name: {
                description: 'A new name for the channel.';
                type: 'string';
              };
            };
            required: ['name'];
            type: 'object';
          };
        };
      };
      'x-examples': {
        'application/json': {
          name: 'Share happiness channel';
        };
      };
    };
    uploadVB: {
      content: {
        'multipart/form-data': {
          schema: {
            properties: {
              file: {
                description: "Provide the file's path here.";
                type: 'string';
              };
            };
            type: 'object';
          };
        };
      };
    };
  };
  schemas: {
    Account: {
      description: "The account object represents an account on Zoom. The account owner is the user who created the account or had an account created for them. You can read more about the Zoom account structure <a href='https://medium.com/zoom-developer-blog/a-brief-look-at-zoom-account-structures-1d19c745bf8a' target='_blank'>here</a>.";
      properties: {
        email: {
          description: "User's email address.";
          type: 'string';
        };
        first_name: {
          description: "User's first name.";
          type: 'string';
        };
        last_name: {
          description: "User's last name.";
          type: 'string';
        };
        options: {
          description: 'Account options object.';
          properties: {
            billing_auto_renew: {
              description: 'Toggle whether automatic billing renewal is on or off.';
              type: 'boolean';
            };
            meeting_connector_list: {
              description: 'Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_mc` is set to `true`.';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            pay_mode: {
              default: 'master';
              description: 'Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.';
              enum: ['master', 'sub'];
              type: 'string';
              'x-enum-descriptions': ['master account holder pays', 'Sub account holder pays'];
            };
            room_connector_list: {
              description: 'Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_rc` is set to `true`.';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            share_mc: {
              default: false;
              description: 'Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.';
              type: 'boolean';
            };
            share_rc: {
              default: false;
              description: 'Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        password: {
          description: "User's password.";
          minimum: 8;
          type: 'string';
        };
        vanity_url: {
          description: 'Account Vanity URL';
          type: 'string';
        };
      };
      required: ['first_name', 'last_name', 'email', 'password'];
      type: 'object';
    };
    AccountList: {
      allOf: [
        {
          description: 'Pagination Object.';
          properties: {
            next_page_token: {
              description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
              type: 'string';
            };
            page_count: {
              description: 'The number of pages returned for the request made.';
              type: 'integer';
            };
            page_number: {
              default: 1;
              description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
              type: 'integer';
            };
            page_size: {
              default: 30;
              description: 'The number of records returned with a single API call.';
              maximum: 300;
              type: 'integer';
            };
            total_records: {
              description: 'The total number of all the records available across pages.';
              type: 'integer';
            };
          };
          type: 'object';
        },
        {
          description: 'Account object in the account list.';
          properties: {
            accounts: {
              description: 'List of Account objects.';
              items: {
                properties: {
                  account_name: {
                    description: 'Account name.';
                    type: 'string';
                  };
                  account_number: {
                    description: 'Account Number of the account.';
                    type: 'string';
                  };
                  account_type: {
                    description: 'Account type.';
                    type: 'string';
                  };
                  created_at: {
                    description: 'Account creation date and time.';
                    format: 'date-time';
                    type: 'string';
                  };
                  id: {
                    description: 'Account ID.';
                    type: 'string';
                  };
                  owner_email: {
                    description: 'Account owner email.';
                    example: 'john.doe@zoom.us';
                    type: 'string';
                  };
                  seats: {
                    description: 'Account seats.';
                    type: 'integer';
                  };
                  subscription_end_time: {
                    description: 'Account subscription end date and time.';
                    format: 'date-time';
                    type: 'string';
                  };
                  subscription_start_time: {
                    description: 'Account subscription start date and time.';
                    format: 'date-time';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
          };
          type: 'object';
        },
      ];
      description: 'List of Accounts.';
      title: 'Account List';
      type: 'object';
    };
    AccountListItem: {
      description: 'Account object in the account list.';
      properties: {
        accounts: {
          description: 'List of Account objects.';
          items: {
            properties: {
              account_name: {
                description: 'Account name.';
                type: 'string';
              };
              account_number: {
                description: 'Account Number of the account.';
                type: 'string';
              };
              account_type: {
                description: 'Account type.';
                type: 'string';
              };
              created_at: {
                description: 'Account creation date and time.';
                format: 'date-time';
                type: 'string';
              };
              id: {
                description: 'Account ID.';
                type: 'string';
              };
              owner_email: {
                description: 'Account owner email.';
                example: 'john.doe@zoom.us';
                type: 'string';
              };
              seats: {
                description: 'Account seats.';
                type: 'integer';
              };
              subscription_end_time: {
                description: 'Account subscription end date and time.';
                format: 'date-time';
                type: 'string';
              };
              subscription_start_time: {
                description: 'Account subscription start date and time.';
                format: 'date-time';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
      };
      type: 'object';
    };
    AccountOptions: {
      description: 'Account options object.';
      properties: {
        billing_auto_renew: {
          description: 'Toggle whether automatic billing renewal is on or off.';
          type: 'boolean';
        };
        meeting_connector_list: {
          description: 'Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_mc` is set to `true`.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        pay_mode: {
          default: 'master';
          description: 'Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.';
          enum: ['master', 'sub'];
          type: 'string';
          'x-enum-descriptions': ['master account holder pays', 'Sub account holder pays'];
        };
        room_connector_list: {
          description: 'Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_rc` is set to `true`.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        share_mc: {
          default: false;
          description: 'Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.';
          type: 'boolean';
        };
        share_rc: {
          default: false;
          description: 'Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.';
          type: 'boolean';
        };
      };
      type: 'object';
    };
    AccountPlan: {
      description: 'Account plan object.';
      properties: {
        hosts: {
          description: 'Account plan number of hosts.';
          type: 'integer';
        };
        type: {
          description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
          type: 'string';
        };
      };
      type: 'object';
    };
    AccountPlanBaseRequired: {
      description: 'Account base plan object.';
      properties: {
        hosts: {
          description: 'Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.';
          type: 'integer';
        };
        type: {
          description: 'Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
          type: 'string';
        };
      };
      required: ['type', 'hosts'];
      type: 'object';
    };
    AccountPlanRequired: {
      description: 'Account plan object.';
      properties: {
        hosts: {
          description: 'Number of hosts for this plan.';
          type: 'integer';
        };
        type: {
          description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
          type: 'string';
        };
      };
      required: ['type', 'hosts'];
      type: 'object';
    };
    AccountPlans: {
      description: 'Account Plans object.';
      properties: {
        plan_audio: {
          description: 'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.';
          properties: {
            callout_countries: {
              description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
              type: 'string';
            };
            ddi_numbers: {
              description: 'Dedicated dial-In numbers.';
              type: 'integer';
            };
            premium_countries: {
              description: 'Premium countries: multiple values should be separated by commas. For a list of allowed values, refer to the "ID" field in the [Premium Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#premium-countries) table.';
              type: 'string';
            };
            tollfree_countries: {
              description: 'Toll-free countries: multiple values should separated by a comma. For a list of allowed values, refer to the "ID" field in the [Toll Free Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#toll-free-countries) table.';
              type: 'string';
            };
            type: {
              description: 'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.';
              type: 'string';
            };
          };
          type: 'object';
        };
        plan_base: {
          description: 'Account base plan object.';
          properties: {
            hosts: {
              description: 'Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.';
              type: 'integer';
            };
            type: {
              description: 'Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
              type: 'string';
            };
          };
          required: ['type', 'hosts'];
          type: 'object';
        };
        plan_large_meeting: {
          description: 'Additional large meeting Plans.';
          items: {
            description: 'Account plan object.';
            properties: {
              hosts: {
                description: 'Account plan number of hosts.';
                type: 'integer';
              };
              type: {
                description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        plan_phone: {
          description: 'Phone Plan Object';
          properties: {
            plan_base: {
              description: 'Additional phone base plans.';
              properties: {
                callout_countries: {
                  description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
                  type: 'string';
                };
                type: {
                  description: 'Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                  type: 'string';
                };
              };
              type: 'object';
            };
            plan_calling: {
              description: 'Additional phone calling plans.';
              items: {
                properties: {
                  hosts: {
                    type: 'integer';
                  };
                  type: {
                    description: 'Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            plan_number: {
              description: 'Additional phone number plans.';
              items: {
                properties: {
                  hosts: {
                    type: 'integer';
                  };
                  type: {
                    description: 'Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
          };
          title: 'PhonePlan';
          type: 'object';
        };
        plan_recording: {
          description: 'Additional cloud recording plan.';
          type: 'string';
        };
        plan_room_connector: {
          description: 'Account plan object.';
          properties: {
            hosts: {
              description: 'Account plan number of hosts.';
              type: 'integer';
            };
            type: {
              description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
              type: 'string';
            };
          };
          type: 'object';
        };
        plan_webinar: {
          description: 'Additional webinar plans.';
          items: {
            description: 'Account plan object.';
            properties: {
              hosts: {
                description: 'Account plan number of hosts.';
                type: 'integer';
              };
              type: {
                description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        plan_zoom_rooms: {
          description: 'Account plan object.';
          properties: {
            hosts: {
              description: 'Account plan number of hosts.';
              type: 'integer';
            };
            type: {
              description: 'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>';
              type: 'string';
            };
          };
          type: 'object';
        };
      };
      required: ['plan_base'];
      type: 'object';
    };
    AccountSettings: {
      properties: {
        email_notification: {
          description: 'Account Settings: Notification.';
          properties: {
            alternative_host_reminder: {
              description: 'Notify when an alternative host is set or removed from a meeting.';
              type: 'boolean';
            };
            cancel_meeting_reminder: {
              description: 'Notify the host and participants when a meeting is cancelled.';
              type: 'boolean';
            };
            cloud_recording_avaliable_reminder: {
              description: 'Notify host when cloud recording is available.';
              type: 'boolean';
            };
            jbh_reminder: {
              description: 'Notify the host when participants join the meeting before them.';
              type: 'boolean';
            };
            low_host_count_reminder: {
              description: 'Notify user when host licenses are running low.';
              type: 'boolean';
            };
            schedule_for_reminder: {
              description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        feature: {
          description: 'Account Settings: Feature.';
          properties: {
            meeting_capacity: {
              description: 'Set the maximum number of participants a host can have in a single meeting.';
              type: 'integer';
            };
          };
          type: 'object';
        };
        in_meeting: {
          description: 'Account Settings: In Meeting.';
          properties: {
            alert_guest_join: {
              description: 'Identify guest participants in a meeting or webinar.';
              type: 'boolean';
            };
            allow_live_streaming: {
              description: 'Allow live streaming.';
              type: 'boolean';
            };
            allow_participants_to_rename: {
              description: 'If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.\n';
              type: 'boolean';
            };
            allow_show_zoom_windows: {
              description: 'Show the Zoom desktop application when sharing screens. ';
              type: 'boolean';
            };
            annotation: {
              description: 'Allow participants to use annotation tools to add information to shared screens.';
              type: 'boolean';
            };
            anonymous_question_answer: {
              description: 'Allow an anonymous Q&A in a webinar.';
              type: 'boolean';
            };
            attendee_on_hold: {
              default: false;
              description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
              type: 'boolean';
            };
            auto_answer: {
              description: 'Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.';
              type: 'boolean';
            };
            auto_saving_chat: {
              description: 'Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.';
              type: 'boolean';
            };
            breakout_room: {
              description: 'Allow host to split meeting participants into separate, smaller rooms.';
              type: 'boolean';
            };
            chat: {
              description: 'Allow meeting participants to send a message that is visible to all participants.';
              type: 'boolean';
            };
            closed_caption: {
              description: 'Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions. ';
              type: 'boolean';
            };
            co_host: {
              description: 'Allow the host to add co-hosts.';
              type: 'boolean';
            };
            custom_data_center_regions: {
              description: 'If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.';
              type: 'boolean';
            };
            custom_live_streaming_service: {
              description: 'Custom live streaming.';
              type: 'boolean';
            };
            custom_service_instructions: {
              description: 'Custom service instructions.';
              type: 'string';
            };
            data_center_regions: {
              description: 'If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).\n';
              enum: ['EU', 'HK', 'AU', 'IN', 'TY', 'CN', 'US', 'CA'];
              items: {
                type: 'string';
              };
              type: 'array';
            };
            dscp_audio: {
              description: 'DSCP audio.';
              maximum: 63;
              minimum: 1;
              type: 'integer';
            };
            dscp_marking: {
              description: 'DSCP marking.';
              type: 'boolean';
            };
            dscp_video: {
              description: 'DSCP video.';
              maximum: 63;
              minimum: 1;
              type: 'integer';
            };
            e2e_encryption: {
              description: 'Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).';
              type: 'boolean';
            };
            entry_exit_chime: {
              description: 'Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.';
              enum: ['host', 'all', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Heard by host only', 'Heard by host and all attendees', 'Disable'];
            };
            far_end_camera_control: {
              description: 'Allow another user to take control of your camera during a meeting.';
              type: 'boolean';
            };
            feedback: {
              description: 'Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.';
              type: 'boolean';
            };
            file_transfer: {
              description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.';
              type: 'boolean';
            };
            group_hd: {
              description: 'Activate higher quality video for host and participants.\nPlease note: This will use more bandwidth.';
              type: 'boolean';
            };
            meeting_reactions: {
              description: 'Enable or disable meeting reactions. <br>\n`true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>\n`false`: Do not enable meeting reactions.';
              type: 'boolean';
            };
            original_audio: {
              description: 'Allow users to select original sound in their client settings.';
              type: 'boolean';
            };
            p2p_connetion: {
              description: 'Peer to peer connection while only two people are in a meeting.';
              type: 'boolean';
            };
            p2p_ports: {
              description: 'Peer to peer listening ports range.';
              type: 'boolean';
            };
            polling: {
              description: 'Add "Polls" to the meeting controls.';
              type: 'boolean';
            };
            ports_range: {
              default: '';
              description: 'The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.';
              type: 'string';
            };
            post_meeting_feedback: {
              description: 'Display a thumbs up or down survey at the end of each meeting.';
              type: 'boolean';
            };
            private_chat: {
              description: 'Allow a meeting participant to send a private message to another participant.';
              type: 'boolean';
            };
            record_play_own_voice: {
              description: 'Record and play their own voice.';
              type: 'boolean';
            };
            remote_control: {
              description: 'Allow users to request remote control.';
              type: 'boolean';
            };
            request_permission_to_unmute: {
              description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.';
              type: 'boolean';
            };
            screen_sharing: {
              description: 'Allow screen sharing.';
              type: 'boolean';
            };
            sending_default_email_invites: {
              description: 'Only show the default email when sending email invites.';
              type: 'boolean';
            };
            show_a_join_from_your_browser_link: {
              description: 'If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.';
              type: 'boolean';
            };
            show_meeting_control_toolbar: {
              description: 'Always show the meeting control toolbar.';
              type: 'boolean';
            };
            stereo_audio: {
              description: 'Allow users to select stereo audio in their client settings.';
              type: 'boolean';
            };
            use_html_format_email: {
              description: 'Use HTML formatted email for the Outlook plugin.';
              type: 'boolean';
            };
            virtual_background: {
              description: 'Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.';
              type: 'boolean';
            };
            virtual_background_settings: {
              description: 'Settings to manage virtual background.';
              properties: {
                allow_upload_custom: {
                  description: 'Allow users to upload custom backgrounds.';
                  type: 'boolean';
                };
                allow_videos: {
                  description: 'Allow use of videos for virtual backgrounds.';
                  type: 'boolean';
                };
                enable: {
                  description: 'Enable virtual background.';
                  type: 'boolean';
                };
                files: {
                  items: {
                    properties: {
                      id: {
                        description: 'Unique identifier of the file.';
                        type: 'string';
                      };
                      is_default: {
                        description: 'Indicates whether or not this file is the default virtual background file.';
                        type: 'boolean';
                      };
                      name: {
                        description: 'File name.';
                        type: 'string';
                      };
                      size: {
                        description: 'File size.';
                        type: 'string';
                      };
                      type: {
                        description: 'File type.';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            watermark: {
              description: 'Add a watermark when viewing a shared screen.';
              type: 'boolean';
            };
            webinar_question_answer: {
              description: 'Allow a Q&A in a webinar.';
              type: 'boolean';
            };
            whiteboard: {
              description: 'Allow participants to share a whiteboard that includes annotation tools.';
              type: 'boolean';
            };
            who_can_share_screen: {
              description: 'Indicates who can share their screen or content during meetings. The value can be one of the following: <br>\n`host`: Only host can share the screen.<br>\n`all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
              enum: ['host', 'all'];
              type: 'string';
            };
            who_can_share_screen_when_someone_is_sharing: {
              description: 'Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>\n`host`: Only a host can share the screen when someone else is sharing.<br>\n`all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
              enum: ['host', 'all'];
              type: 'string';
            };
            workplace_by_facebook: {
              description: 'Workplace by facebook.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        integration: {
          description: 'Account Settings: Integration.';
          properties: {
            box: {
              description: 'Enable users who join a meeting from their mobile device to share content from their Box account.';
              type: 'boolean';
            };
            dropbox: {
              description: 'Enable users who join a meeting from their mobile device to share content from their Dropbox account.';
              type: 'boolean';
            };
            google_calendar: {
              description: 'Enable meetings to be scheduled using Google Calendar.';
              type: 'boolean';
            };
            google_drive: {
              description: 'Enable users who join a meeting from their mobile device to share content from their Google Drive.';
              type: 'boolean';
            };
            kubi: {
              description: 'Enable users to control a connected Kubi device from within a Zoom meeting.';
              type: 'boolean';
            };
            microsoft_one_drive: {
              description: 'Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        profile: {
          properties: {
            recording_storage_location: {
              properties: {
                allowed_values: {
                  description: 'Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.\n\nProvide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                value: {
                  description: 'Abbreviated country code.';
                  type: 'string';
                };
              };
              type: 'object';
            };
          };
          title: 'Profile';
          type: 'object';
        };
        recording: {
          description: 'Account Settings: Recording.';
          properties: {
            account_user_access_recording: {
              description: 'Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.';
              type: 'boolean';
            };
            allow_recovery_deleted_cloud_recordings: {
              description: 'Allow recovery of deleted cloud recordings from trash. \nIf the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period. ';
              type: 'boolean';
            };
            archive: {
              description: '[Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.';
              properties: {
                enable: {
                  description: 'Enable the archiving feature.';
                  type: 'boolean';
                };
                settings: {
                  properties: {
                    audio_file: {
                      description: 'Include in-meeting and/or in-webinar audio in the archive.';
                      type: 'boolean';
                    };
                    cc_transcript_file: {
                      description: 'Include closed caption or transcript in the archive.';
                      type: 'boolean';
                    };
                    chat_file: {
                      description: 'Include in-meeting chat in the archive.';
                      type: 'boolean';
                    };
                    chat_with_sender_email: {
                      description: 'Include user email in in-meeting chat file.';
                      type: 'boolean';
                    };
                    video_file: {
                      description: 'Include in-meeting and/or in-webinar video in the archive.';
                      type: 'boolean';
                    };
                  };
                  type: 'object';
                };
                type: {
                  description: 'Archive types:\n\n* `1`: Only meetings are archived.<br>\n* `2`: Only webinars are archived.<br>\n* `3`: Both meetings and webinars are archived.';
                  enum: [1, 2, 3];
                  type: 'integer';
                };
              };
              type: 'object';
            };
            auto_delete_cmr: {
              description: 'Allow Zoom to permanantly delete recordings automatically after a specified number of days.';
              type: 'boolean';
            };
            auto_delete_cmr_days: {
              description: "When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.";
              type: 'integer';
            };
            auto_recording: {
              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
              enum: ['local', 'cloud', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Record on local', 'Record on cloud', 'Disabled'];
            };
            cloud_recording: {
              description: 'Allow hosts to record and save the meeting in the cloud.';
              type: 'boolean';
            };
            cloud_recording_download: {
              description: 'Cloud recording downloads.';
              type: 'boolean';
            };
            cloud_recording_download_host: {
              description: 'Only the host can download cloud recordings.';
              type: 'boolean';
            };
            host_delete_cloud_recording: {
              description: 'If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.\n';
              type: 'boolean';
            };
            ip_address_access_control: {
              description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
              properties: {
                enable: {
                  description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                  type: 'boolean';
                };
                ip_addresses_or_ranges: {
                  description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                  type: 'string';
                };
              };
              type: 'object';
            };
            local_recording: {
              description: 'Allow hosts and participants to record the meeting using a local file.';
              type: 'boolean';
            };
            prevent_host_access_recording: {
              description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n';
              type: 'boolean';
            };
            record_audio_file: {
              description: 'Record an audio only file.';
              type: 'boolean';
            };
            record_gallery_view: {
              description: 'Record the gallery view with a shared screen.';
              type: 'boolean';
            };
            record_speaker_view: {
              description: 'Record the active speaker with a shared screen.';
              type: 'boolean';
            };
            recording_audio_transcript: {
              description: 'Automatically transcribe the audio of the meeting or webinar to the cloud.';
              type: 'boolean';
            };
            recording_disclaimer: {
              description: 'Show a disclaimer to participants before a recording starts\n';
              type: 'boolean';
            };
            recording_password_requirement: {
              description: 'This object represents the minimum password requirements set for recordings via Account Recording Settings.';
              properties: {
                have_letter: {
                  description: 'Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).';
                  type: 'boolean';
                };
                have_number: {
                  description: 'Indicates whether or not password must contain at least one number(1, 2, 3..).';
                  type: 'boolean';
                };
                have_special_character: {
                  description: 'Indicates whether or not password must contain at least one special character(!, @, #..).';
                  type: 'boolean';
                };
                length: {
                  description: 'Minimum required length for the password.';
                  maximum: 10;
                  type: 'integer';
                };
                only_allow_numeric: {
                  description: 'Indicates whether or not password must contain only numeric characters.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            required_password_for_existing_cloud_recordings: {
              description: 'Require a passcode to access existing cloud recordings.';
              type: 'boolean';
            };
            save_chat_text: {
              description: 'Save the chat text from the meeting.';
              type: 'boolean';
            };
            show_timestamp: {
              description: 'Add a timestamp to the recording.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        schedule_meeting: {
          description: 'Account Settings: Schedule Meeting.';
          properties: {
            audio_type: {
              default: 'both';
              description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.';
              enum: ['both', 'telephony', 'voip', 'thirdParty'];
              type: 'string';
              'x-enum-descriptions': [
                'Telephony and VoIP',
                'Audio PSTN telephony only',
                'VoIP only',
                '3rd party audio conference',
              ];
            };
            enforce_login: {
              description: 'Only Zoom users who are signed in can join meetings.';
              type: 'boolean';
            };
            enforce_login_domains: {
              description: 'Only signed in users with a specified domain can join the meeting. ';
              type: 'string';
            };
            enforce_login_with_domains: {
              description: 'Only signed in users with a specific domain can join meetings.';
              type: 'boolean';
            };
            force_pmi_jbh_password: {
              description: 'Require a password for Personal Meetings if attendees can join before host.';
              type: 'boolean';
            };
            host_video: {
              description: 'Start meetings with the host video on.';
              type: 'boolean';
            };
            join_before_host: {
              description: 'Allow participants to join the meeting before the host arrives.';
              type: 'boolean';
            };
            meeting_password_requirement: {
              description: 'Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
              properties: {
                consecutive_characters_length: {
                  enum: [0, 4, 5, 6, 7, 8];
                  type: 'integer';
                };
                have_letter: {
                  description: 'If set to `true`, the password must contain at least 1 letter (such as a,b,c...).\n';
                  type: 'boolean';
                };
                have_number: {
                  description: 'If set to `true`, the password must contain at least 1 number (such as 1,2,3...).';
                  type: 'boolean';
                };
                have_special_character: {
                  description: 'If set to `true`, the password must have at least 1 special character (!,@,#...).';
                  type: 'boolean';
                };
                have_upper_and_lower_characters: {
                  description: 'If set to `true`, the password must include both uppercase and lowercase characters.';
                  type: 'boolean';
                };
                length: {
                  description: 'The minimum length that the meeting/webinar password needs to have.';
                  type: 'integer';
                };
                only_allow_numeric: {
                  description: 'If set to `true`, the password must only contain numbers and no other characters.';
                  type: 'boolean';
                };
                weak_enhance_detection: {
                  description: 'If set to `true`, users will be informed if the provided password is weak.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            not_store_meeting_topic: {
              description: 'Always display "Zoom Meeting" as the meeting topic.';
              type: 'boolean';
            };
            participant_video: {
              description: 'Start meetings with the participant video on. Participants can change this setting during the meeting.';
              type: 'boolean';
            };
            personal_meeting: {
              description: 'Personal Meeting Setting.<br><br>\n`true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.\nFor Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n';
              type: 'boolean';
            };
            require_password_for_instant_meetings: {
              description: 'Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
              type: 'boolean';
            };
            require_password_for_pmi_meetings: {
              description: 'Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
              enum: ['jbh_only', 'all', 'none'];
              type: 'string';
              'x-enum-descriptions': [
                'Only meetings with Join Before Host enabled',
                'All meetings using PMI',
                'Disabled',
              ];
            };
            require_password_for_scheduled_meetings: {
              description: 'Require a password for meetings which have already been scheduled\n';
              type: 'boolean';
            };
            require_password_for_scheduling_new_meetings: {
              description: 'Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
              type: 'boolean';
            };
            use_pmi_for_instant_meetings: {
              description: 'Use Personal Meeting ID (PMI) when starting an instant meeting\n';
              type: 'boolean';
            };
            use_pmi_for_scheduled_meetings: {
              description: 'Use Personal Meeting ID (PMI) when scheduling a meeting\n';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        security: {
          description: '[Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.';
          properties: {
            admin_change_name_pic: {
              description: "Only account administrators can change a user's username and picture.";
              type: 'boolean';
            };
            hide_billing_info: {
              description: 'Hide billing information.';
              type: 'boolean';
            };
            import_photos_from_devices: {
              description: 'Allow users to import photos from a photo library on a  device.';
              type: 'boolean';
            };
            password_requirement: {
              description: "This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password. ";
              properties: {
                consecutive_characters_length: {
                  description: '\nSpecify the max length of consecutive characters(abcde...) that can be used in a password.\nIf you set the value of this field to `0`, no restriction will be applied on consecutive characters. \n\nIf you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.\n\nThe max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).';
                  type: 'integer';
                };
                have_special_character: {
                  description: 'If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).';
                  type: 'boolean';
                };
                minimum_password_length: {
                  description: 'Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.';
                  maximum: 14;
                  minimum: 8;
                  type: 'integer';
                };
                weak_enhance_detection: {
                  description: 'If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            sign_again_period_for_inactivity_on_client: {
              description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`45`: 45 minutes<br>\n`60`: 60 minutes<br>\n`90`: 90 minutes<br>\n`120`: 120 minutes\n';
              type: 'integer';
            };
            sign_again_period_for_inactivity_on_web: {
              description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`60`: 60 minutes<br>\n`120`: 120 minutes\n\n    \n\n';
              type: 'integer';
            };
            sign_in_with_two_factor_auth: {
              description: 'Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:\n`all`: Two factor authentication will be enabled for all users in the account.<br>\n`none`: Two factor authentication is disabled.<br>\n`group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>\n`role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the\n`sign_in_with_two_factor_auth_roles` field.\n';
              enum: ['all', 'group', 'role', 'none'];
              type: 'string';
            };
            sign_in_with_two_factor_auth_groups: {
              description: 'This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            sign_in_with_two_factor_auth_roles: {
              description: 'This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.';
              items: {
                type: 'string';
              };
              type: 'array';
            };
          };
          type: 'object';
        };
        telephony: {
          description: 'Account Settings: Telephony.';
          properties: {
            audio_conference_info: {
              description: 'Third party audio conference info.';
              type: 'string';
            };
            telephony_regions: {
              description: 'Indicates where most of the participants call into or call from duriing a meeting.';
              properties: {
                allowed_values: {
                  description: 'Telephony region options provided by Zoom to select from.';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                selection_values: {
                  description: 'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            third_party_audio: {
              description: 'Users can join the meeting using the existing third party audio configuration.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        tsp: {
          description: 'Account Settings: TSP.';
          properties: {
            call_out: {
              description: 'Call Out';
              type: 'boolean';
            };
            call_out_countries: {
              description: 'Call Out Countries/Regions';
              items: {};
              type: 'array';
            };
            display_toll_free_numbers: {
              description: 'Display toll-free numbers';
              type: 'boolean';
            };
            show_international_numbers_link: {
              description: 'Show international numbers link on the invitation email';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        zoom_rooms: {
          description: 'Account Settings: Zoom Rooms.';
          properties: {
            auto_start_stop_scheduled_meetings: {
              description: 'Automatic start and stop for scheduled meetings.';
              type: 'boolean';
            };
            cmr_for_instant_meeting: {
              description: 'Cloud recording for instant meetings.';
              type: 'boolean';
            };
            force_private_meeting: {
              description: 'Shift all meetings to private.';
              type: 'boolean';
            };
            hide_host_information: {
              description: 'Hide host and meeting ID from private meetings.';
              type: 'boolean';
            };
            list_meetings_with_calendar: {
              description: 'Display meeting list with calendar integration.';
              type: 'boolean';
            };
            start_airplay_manually: {
              description: 'Start AirPlay service manually.';
              type: 'boolean';
            };
            ultrasonic: {
              description: 'Automatic direct sharing using an ultrasonic proximity signal.';
              type: 'boolean';
            };
            upcoming_meeting_alert: {
              description: 'Upcoming meeting alert.';
              type: 'boolean';
            };
            weekly_system_restart: {
              description: 'Weekly system restart.';
              type: 'boolean';
            };
            zr_post_meeting_feedback: {
              description: 'Zoom Room post meeting feedback.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
      };
      title: 'Account settings';
      type: 'object';
    };
    AccountSettingsAuthentication: {
      oneOf: [
        {
          properties: {
            authentication_options: {
              description: 'Meeting Authentication Options';
              items: {
                properties: {
                  default_option: {
                    description: 'Authentication default option';
                    type: 'boolean';
                  };
                  domains: {
                    description: 'Authentication domians';
                    type: 'string';
                  };
                  id: {
                    description: 'Authentication id';
                    type: 'string';
                  };
                  name: {
                    description: 'Authentication name';
                    type: 'string';
                  };
                  type: {
                    description: ' Authentication type. Specify one of the following authentication types for the authentication profile:<br>\n * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>\n * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.';
                    enum: ['enforce_login', 'enforce_login_with_same_account', 'enforce_login_with_domains'];
                    type: 'string';
                  };
                  visible: {
                    description: 'Authentication visible';
                    type: 'boolean';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            meeting_authentication: {
              description: 'Only authenticated users can join meetings';
              type: 'boolean';
            };
          };
        },
        {
          properties: {
            authentication_options: {
              items: {
                properties: {
                  default_option: {
                    description: 'Authentication default option';
                    type: 'boolean';
                  };
                  domains: {
                    description: 'Authentication domians';
                    type: 'string';
                  };
                  id: {
                    description: 'Authentication id';
                    type: 'string';
                  };
                  name: {
                    description: 'Authentication name';
                    type: 'string';
                  };
                  type: {
                    description: 'Authentication type';
                    enum: ['internally', 'enforce_login', 'enforce_login_with_domains'];
                    type: 'string';
                  };
                  visible: {
                    description: 'Authentication visible';
                    type: 'boolean';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            recording_authentication: {
              description: 'Only authenticated users can view cloud recordings';
              type: 'boolean';
            };
          };
        },
      ];
      title: 'AccountSettingsAuthentication';
      type: 'object';
    };
    AccountSettingsAuthenticationUpdate: {
      oneOf: [
        {
          description: 'Set/ update [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars).<br><br> The authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).';
          properties: {
            authentication_option: {
              description: 'Meeting Authentication Options';
              properties: {
                action: {
                  description: 'Specify the action that you would like to take via this API request:<br>\n* `add` : Choose this value if you are adding an authentication option.\n* `update`: Choose this value if you are updating an existing authentication option.\n* `delete`: Choose this value if you are deleting an existing authentication option.';
                  enum: ['update', 'delete', 'add'];
                  type: 'string';
                };
                default_option: {
                  description: 'Specify whether you would like to set this authentication option as the default option or not.';
                  type: 'boolean';
                };
                domains: {
                  description: 'If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to join your meetings or webinars. ';
                  type: 'string';
                };
                id: {
                  description: ' Authentication ID. If you are creating an authentication profile, you do not need to provide this field. The id field will be generated in the response once this API request is completed successfully. You can also use the Get Account Settings API with query parameter set to `meeting_authentication` to list the authentication id.<br><br>\n Use this field or the `name` field to identify the associated authentication option that you would like to update or delete.';
                  type: 'string';
                };
                name: {
                  description: 'Unique name for the authentication option.';
                  type: 'string';
                };
                type: {
                  description: ' Authentication type. Specify one of the following authentication types for the authentication profile:<br>\n * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>\n * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.';
                  enum: ['enforce_login', 'enforce_login_with_same_account', 'enforce_login_with_domains'];
                  type: 'string';
                };
              };
              type: 'object';
            };
            meeting_authentication: {
              description: 'If set to "true", only authenticated users can join meetings. The method for authentication can be defined in the "authentication_option". ';
              type: 'boolean';
            };
          };
        },
        {
          description: 'Set/Update [authentication profile for Cloud Recordings](https://support.zoom.us/hc/en-us/articles/360037756671-Authentication-Profiles-for-Cloud-Recordings).';
          properties: {
            authentication_option: {
              description: 'Specify the authentication options for this account.';
              properties: {
                action: {
                  description: 'Specify the action that you would like to take via this API request:<br>\n* `add` : Choose this value if you are adding an authentication option.\n* `update`: Choose this value if you are updating an existing authentication option.\n* `delete`: Choose this value if you are deleting an existing authentication option.';
                  enum: ['update', 'delete', 'add'];
                  type: 'string';
                };
                default_option: {
                  description: 'Specify whether you would like to set this authentication option as the default option or not.';
                  type: 'boolean';
                };
                domains: {
                  description: 'If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to view the recordings. ';
                  type: 'string';
                };
                id: {
                  description: ' Authentication ID. If you are creating an authentication profile, you do not need to provide this field. The id field will be generated in the response once this API request is completed successfully. You can also use the Get Account Settings API with query parameter set to `meeting_authentication` to list the authentication id.<br><br>\nUse this field or the `name` field to identify the associated authentication option that you would like to update or delete.';
                  type: 'string';
                };
                name: {
                  description: 'Unique name for the authentication option.';
                  type: 'string';
                };
                type: {
                  description: 'Specify one authentication type that is to be associated with this authentication configuration:<br>\n* `internally`: This option allows you specify a rule that only signed in users within your account can view the recording.<br>\n * `enforce_login`: This option allows any users to view the recording, as long as they are signed into their Zoom account.<br>\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can view the recording. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.\n\n';
                  enum: ['internally', 'enforce_login', 'enforce_login_with_domains'];
                  type: 'string';
                };
              };
              type: 'object';
            };
            recording_authentication: {
              description: 'If set to `true`, only authenticated users can view the cloud recordings.<br><br>\nThe authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).';
              type: 'boolean';
            };
          };
        },
      ];
      title: 'AccountSettingsAuthenticationUpdate';
      type: 'object';
    };
    AccountSettingsEmailNotification: {
      description: 'Account Settings: Notification.';
      properties: {
        alternative_host_reminder: {
          description: 'Notify when an alternative host is set or removed from a meeting.';
          type: 'boolean';
        };
        cancel_meeting_reminder: {
          description: 'Notify the host and participants when a meeting is cancelled.';
          type: 'boolean';
        };
        cloud_recording_avaliable_reminder: {
          description: 'Notify host when cloud recording is available.';
          type: 'boolean';
        };
        jbh_reminder: {
          description: 'Notify the host when participants join the meeting before them.';
          type: 'boolean';
        };
        low_host_count_reminder: {
          description: 'Notify user when host licenses are running low.';
          type: 'boolean';
        };
        schedule_for_reminder: {
          description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
          type: 'boolean';
        };
      };
      type: 'object';
    };
    AccountSettingsFeature: {
      description: 'Account Settings: Feature.';
      properties: {
        meeting_capacity: {
          description: 'Set the maximum number of participants a host can have in a single meeting.';
          type: 'integer';
        };
      };
      type: 'object';
    };
    AccountSettingsInMeeting: {
      description: 'Account Settings: In Meeting.';
      properties: {
        alert_guest_join: {
          description: 'Identify guest participants in a meeting or webinar.';
          type: 'boolean';
        };
        allow_live_streaming: {
          description: 'Allow live streaming.';
          type: 'boolean';
        };
        allow_participants_to_rename: {
          description: 'If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.\n';
          type: 'boolean';
        };
        allow_show_zoom_windows: {
          description: 'Show the Zoom desktop application when sharing screens. ';
          type: 'boolean';
        };
        annotation: {
          description: 'Allow participants to use annotation tools to add information to shared screens.';
          type: 'boolean';
        };
        anonymous_question_answer: {
          description: 'Allow an anonymous Q&A in a webinar.';
          type: 'boolean';
        };
        attendee_on_hold: {
          default: false;
          description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
          type: 'boolean';
        };
        auto_answer: {
          description: 'Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.';
          type: 'boolean';
        };
        auto_saving_chat: {
          description: 'Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.';
          type: 'boolean';
        };
        breakout_room: {
          description: 'Allow host to split meeting participants into separate, smaller rooms.';
          type: 'boolean';
        };
        chat: {
          description: 'Allow meeting participants to send a message that is visible to all participants.';
          type: 'boolean';
        };
        closed_caption: {
          description: 'Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions. ';
          type: 'boolean';
        };
        co_host: {
          description: 'Allow the host to add co-hosts.';
          type: 'boolean';
        };
        custom_data_center_regions: {
          description: 'If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.';
          type: 'boolean';
        };
        custom_live_streaming_service: {
          description: 'Custom live streaming.';
          type: 'boolean';
        };
        custom_service_instructions: {
          description: 'Custom service instructions.';
          type: 'string';
        };
        data_center_regions: {
          description: 'If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).\n';
          enum: ['EU', 'HK', 'AU', 'IN', 'TY', 'CN', 'US', 'CA'];
          items: {
            type: 'string';
          };
          type: 'array';
        };
        dscp_audio: {
          description: 'DSCP audio.';
          maximum: 63;
          minimum: 1;
          type: 'integer';
        };
        dscp_marking: {
          description: 'DSCP marking.';
          type: 'boolean';
        };
        dscp_video: {
          description: 'DSCP video.';
          maximum: 63;
          minimum: 1;
          type: 'integer';
        };
        e2e_encryption: {
          description: 'Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).';
          type: 'boolean';
        };
        entry_exit_chime: {
          description: 'Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.';
          enum: ['host', 'all', 'none'];
          type: 'string';
          'x-enum-descriptions': ['Heard by host only', 'Heard by host and all attendees', 'Disable'];
        };
        far_end_camera_control: {
          description: 'Allow another user to take control of your camera during a meeting.';
          type: 'boolean';
        };
        feedback: {
          description: 'Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.';
          type: 'boolean';
        };
        file_transfer: {
          description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.';
          type: 'boolean';
        };
        group_hd: {
          description: 'Activate higher quality video for host and participants.\nPlease note: This will use more bandwidth.';
          type: 'boolean';
        };
        meeting_reactions: {
          description: 'Enable or disable meeting reactions. <br>\n`true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>\n`false`: Do not enable meeting reactions.';
          type: 'boolean';
        };
        original_audio: {
          description: 'Allow users to select original sound in their client settings.';
          type: 'boolean';
        };
        p2p_connetion: {
          description: 'Peer to peer connection while only two people are in a meeting.';
          type: 'boolean';
        };
        p2p_ports: {
          description: 'Peer to peer listening ports range.';
          type: 'boolean';
        };
        polling: {
          description: 'Add "Polls" to the meeting controls.';
          type: 'boolean';
        };
        ports_range: {
          default: '';
          description: 'The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.';
          type: 'string';
        };
        post_meeting_feedback: {
          description: 'Display a thumbs up or down survey at the end of each meeting.';
          type: 'boolean';
        };
        private_chat: {
          description: 'Allow a meeting participant to send a private message to another participant.';
          type: 'boolean';
        };
        record_play_own_voice: {
          description: 'Record and play their own voice.';
          type: 'boolean';
        };
        remote_control: {
          description: 'Allow users to request remote control.';
          type: 'boolean';
        };
        request_permission_to_unmute: {
          description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.';
          type: 'boolean';
        };
        screen_sharing: {
          description: 'Allow screen sharing.';
          type: 'boolean';
        };
        sending_default_email_invites: {
          description: 'Only show the default email when sending email invites.';
          type: 'boolean';
        };
        show_a_join_from_your_browser_link: {
          description: 'If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.';
          type: 'boolean';
        };
        show_meeting_control_toolbar: {
          description: 'Always show the meeting control toolbar.';
          type: 'boolean';
        };
        stereo_audio: {
          description: 'Allow users to select stereo audio in their client settings.';
          type: 'boolean';
        };
        use_html_format_email: {
          description: 'Use HTML formatted email for the Outlook plugin.';
          type: 'boolean';
        };
        virtual_background: {
          description: 'Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.';
          type: 'boolean';
        };
        virtual_background_settings: {
          description: 'Settings to manage virtual background.';
          properties: {
            allow_upload_custom: {
              description: 'Allow users to upload custom backgrounds.';
              type: 'boolean';
            };
            allow_videos: {
              description: 'Allow use of videos for virtual backgrounds.';
              type: 'boolean';
            };
            enable: {
              description: 'Enable virtual background.';
              type: 'boolean';
            };
            files: {
              items: {
                properties: {
                  id: {
                    description: 'Unique identifier of the file.';
                    type: 'string';
                  };
                  is_default: {
                    description: 'Indicates whether or not this file is the default virtual background file.';
                    type: 'boolean';
                  };
                  name: {
                    description: 'File name.';
                    type: 'string';
                  };
                  size: {
                    description: 'File size.';
                    type: 'string';
                  };
                  type: {
                    description: 'File type.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
          };
          type: 'object';
        };
        watermark: {
          description: 'Add a watermark when viewing a shared screen.';
          type: 'boolean';
        };
        webinar_question_answer: {
          description: 'Allow a Q&A in a webinar.';
          type: 'boolean';
        };
        whiteboard: {
          description: 'Allow participants to share a whiteboard that includes annotation tools.';
          type: 'boolean';
        };
        who_can_share_screen: {
          description: 'Indicates who can share their screen or content during meetings. The value can be one of the following: <br>\n`host`: Only host can share the screen.<br>\n`all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
          enum: ['host', 'all'];
          type: 'string';
        };
        who_can_share_screen_when_someone_is_sharing: {
          description: 'Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>\n`host`: Only a host can share the screen when someone else is sharing.<br>\n`all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
          enum: ['host', 'all'];
          type: 'string';
        };
        workplace_by_facebook: {
          description: 'Workplace by facebook.';
          type: 'boolean';
        };
      };
      type: 'object';
    };
    AccountSettingsIntegration: {
      description: 'Account Settings: Integration.';
      properties: {
        box: {
          description: 'Enable users who join a meeting from their mobile device to share content from their Box account.';
          type: 'boolean';
        };
        dropbox: {
          description: 'Enable users who join a meeting from their mobile device to share content from their Dropbox account.';
          type: 'boolean';
        };
        google_calendar: {
          description: 'Enable meetings to be scheduled using Google Calendar.';
          type: 'boolean';
        };
        google_drive: {
          description: 'Enable users who join a meeting from their mobile device to share content from their Google Drive.';
          type: 'boolean';
        };
        kubi: {
          description: 'Enable users to control a connected Kubi device from within a Zoom meeting.';
          type: 'boolean';
        };
        microsoft_one_drive: {
          description: 'Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.';
          type: 'boolean';
        };
      };
      type: 'object';
    };
    AccountSettingsRecording: {
      description: 'Account Settings: Recording.';
      properties: {
        account_user_access_recording: {
          description: 'Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.';
          type: 'boolean';
        };
        allow_recovery_deleted_cloud_recordings: {
          description: 'Allow recovery of deleted cloud recordings from trash. \nIf the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period. ';
          type: 'boolean';
        };
        archive: {
          description: '[Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.';
          properties: {
            enable: {
              description: 'Enable the archiving feature.';
              type: 'boolean';
            };
            settings: {
              properties: {
                audio_file: {
                  description: 'Include in-meeting and/or in-webinar audio in the archive.';
                  type: 'boolean';
                };
                cc_transcript_file: {
                  description: 'Include closed caption or transcript in the archive.';
                  type: 'boolean';
                };
                chat_file: {
                  description: 'Include in-meeting chat in the archive.';
                  type: 'boolean';
                };
                chat_with_sender_email: {
                  description: 'Include user email in in-meeting chat file.';
                  type: 'boolean';
                };
                video_file: {
                  description: 'Include in-meeting and/or in-webinar video in the archive.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            type: {
              description: 'Archive types:\n\n* `1`: Only meetings are archived.<br>\n* `2`: Only webinars are archived.<br>\n* `3`: Both meetings and webinars are archived.';
              enum: [1, 2, 3];
              type: 'integer';
            };
          };
          type: 'object';
        };
        auto_delete_cmr: {
          description: 'Allow Zoom to permanantly delete recordings automatically after a specified number of days.';
          type: 'boolean';
        };
        auto_delete_cmr_days: {
          description: "When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.";
          type: 'integer';
        };
        auto_recording: {
          description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
          enum: ['local', 'cloud', 'none'];
          type: 'string';
          'x-enum-descriptions': ['Record on local', 'Record on cloud', 'Disabled'];
        };
        cloud_recording: {
          description: 'Allow hosts to record and save the meeting in the cloud.';
          type: 'boolean';
        };
        cloud_recording_download: {
          description: 'Cloud recording downloads.';
          type: 'boolean';
        };
        cloud_recording_download_host: {
          description: 'Only the host can download cloud recordings.';
          type: 'boolean';
        };
        host_delete_cloud_recording: {
          description: 'If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.\n';
          type: 'boolean';
        };
        ip_address_access_control: {
          description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
          properties: {
            enable: {
              description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
              type: 'boolean';
            };
            ip_addresses_or_ranges: {
              description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
              type: 'string';
            };
          };
          type: 'object';
        };
        local_recording: {
          description: 'Allow hosts and participants to record the meeting using a local file.';
          type: 'boolean';
        };
        prevent_host_access_recording: {
          description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n';
          type: 'boolean';
        };
        record_audio_file: {
          description: 'Record an audio only file.';
          type: 'boolean';
        };
        record_gallery_view: {
          description: 'Record the gallery view with a shared screen.';
          type: 'boolean';
        };
        record_speaker_view: {
          description: 'Record the active speaker with a shared screen.';
          type: 'boolean';
        };
        recording_audio_transcript: {
          description: 'Automatically transcribe the audio of the meeting or webinar to the cloud.';
          type: 'boolean';
        };
        recording_disclaimer: {
          description: 'Show a disclaimer to participants before a recording starts\n';
          type: 'boolean';
        };
        recording_password_requirement: {
          description: 'This object represents the minimum password requirements set for recordings via Account Recording Settings.';
          properties: {
            have_letter: {
              description: 'Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).';
              type: 'boolean';
            };
            have_number: {
              description: 'Indicates whether or not password must contain at least one number(1, 2, 3..).';
              type: 'boolean';
            };
            have_special_character: {
              description: 'Indicates whether or not password must contain at least one special character(!, @, #..).';
              type: 'boolean';
            };
            length: {
              description: 'Minimum required length for the password.';
              maximum: 10;
              type: 'integer';
            };
            only_allow_numeric: {
              description: 'Indicates whether or not password must contain only numeric characters.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        required_password_for_existing_cloud_recordings: {
          description: 'Require a passcode to access existing cloud recordings.';
          type: 'boolean';
        };
        save_chat_text: {
          description: 'Save the chat text from the meeting.';
          type: 'boolean';
        };
        show_timestamp: {
          description: 'Add a timestamp to the recording.';
          type: 'boolean';
        };
      };
      type: 'object';
    };
    AccountSettingsRecordingAuthenticationUpdate: {
      description: 'Only authenticated users can view cloud recordings\nThe viewers need to authenticate prior to viewing the cloud recordings, hosts can choose one of the authentication methods when sharing a cloud recording.';
      properties: {
        authentication_option: {
          properties: {
            action: {
              enum: ['update', 'add', 'delete'];
              type: 'string';
            };
            default_option: {
              type: 'boolean';
            };
            domains: {
              type: 'string';
            };
            id: {
              type: 'string';
            };
            name: {
              type: 'string';
            };
            type: {
              enum: ['internally', 'enforce_login', 'enforce_login_with_domains'];
              type: 'string';
            };
          };
          type: 'object';
        };
        recording_authentication: {
          type: 'boolean';
        };
      };
      title: 'AccountSettingsRecordingAuthenticationUpdate';
      type: 'object';
    };
    AccountSettingsScheduleMeeting: {
      description: 'Account Settings: Schedule Meeting.';
      properties: {
        audio_type: {
          default: 'both';
          description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.';
          enum: ['both', 'telephony', 'voip', 'thirdParty'];
          type: 'string';
          'x-enum-descriptions': [
            'Telephony and VoIP',
            'Audio PSTN telephony only',
            'VoIP only',
            '3rd party audio conference',
          ];
        };
        enforce_login: {
          description: 'Only Zoom users who are signed in can join meetings.';
          type: 'boolean';
        };
        enforce_login_domains: {
          description: 'Only signed in users with a specified domain can join the meeting. ';
          type: 'string';
        };
        enforce_login_with_domains: {
          description: 'Only signed in users with a specific domain can join meetings.';
          type: 'boolean';
        };
        force_pmi_jbh_password: {
          description: 'Require a password for Personal Meetings if attendees can join before host.';
          type: 'boolean';
        };
        host_video: {
          description: 'Start meetings with the host video on.';
          type: 'boolean';
        };
        join_before_host: {
          description: 'Allow participants to join the meeting before the host arrives.';
          type: 'boolean';
        };
        meeting_password_requirement: {
          description: 'Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
          properties: {
            consecutive_characters_length: {
              enum: [0, 4, 5, 6, 7, 8];
              type: 'integer';
            };
            have_letter: {
              description: 'If set to `true`, the password must contain at least 1 letter (such as a,b,c...).\n';
              type: 'boolean';
            };
            have_number: {
              description: 'If set to `true`, the password must contain at least 1 number (such as 1,2,3...).';
              type: 'boolean';
            };
            have_special_character: {
              description: 'If set to `true`, the password must have at least 1 special character (!,@,#...).';
              type: 'boolean';
            };
            have_upper_and_lower_characters: {
              description: 'If set to `true`, the password must include both uppercase and lowercase characters.';
              type: 'boolean';
            };
            length: {
              description: 'The minimum length that the meeting/webinar password needs to have.';
              type: 'integer';
            };
            only_allow_numeric: {
              description: 'If set to `true`, the password must only contain numbers and no other characters.';
              type: 'boolean';
            };
            weak_enhance_detection: {
              description: 'If set to `true`, users will be informed if the provided password is weak.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        not_store_meeting_topic: {
          description: 'Always display "Zoom Meeting" as the meeting topic.';
          type: 'boolean';
        };
        participant_video: {
          description: 'Start meetings with the participant video on. Participants can change this setting during the meeting.';
          type: 'boolean';
        };
        personal_meeting: {
          description: 'Personal Meeting Setting.<br><br>\n`true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.\nFor Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n';
          type: 'boolean';
        };
        require_password_for_instant_meetings: {
          description: 'Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
          type: 'boolean';
        };
        require_password_for_pmi_meetings: {
          description: 'Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
          enum: ['jbh_only', 'all', 'none'];
          type: 'string';
          'x-enum-descriptions': ['Only meetings with Join Before Host enabled', 'All meetings using PMI', 'Disabled'];
        };
        require_password_for_scheduled_meetings: {
          description: 'Require a password for meetings which have already been scheduled\n';
          type: 'boolean';
        };
        require_password_for_scheduling_new_meetings: {
          description: 'Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
          type: 'boolean';
        };
        use_pmi_for_instant_meetings: {
          description: 'Use Personal Meeting ID (PMI) when starting an instant meeting\n';
          type: 'boolean';
        };
        use_pmi_for_scheduled_meetings: {
          description: 'Use Personal Meeting ID (PMI) when scheduling a meeting\n';
          type: 'boolean';
        };
      };
      type: 'object';
    };
    AccountSettingsSecurity: {
      description: '[Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.';
      properties: {
        admin_change_name_pic: {
          description: "Only account administrators can change a user's username and picture.";
          type: 'boolean';
        };
        hide_billing_info: {
          description: 'Hide billing information.';
          type: 'boolean';
        };
        import_photos_from_devices: {
          description: 'Allow users to import photos from a photo library on a  device.';
          type: 'boolean';
        };
        password_requirement: {
          description: "This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password. ";
          properties: {
            consecutive_characters_length: {
              description: '\nSpecify the max length of consecutive characters(abcde...) that can be used in a password.\nIf you set the value of this field to `0`, no restriction will be applied on consecutive characters. \n\nIf you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.\n\nThe max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).';
              type: 'integer';
            };
            have_special_character: {
              description: 'If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).';
              type: 'boolean';
            };
            minimum_password_length: {
              description: 'Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.';
              maximum: 14;
              minimum: 8;
              type: 'integer';
            };
            weak_enhance_detection: {
              description: 'If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        sign_again_period_for_inactivity_on_client: {
          description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`45`: 45 minutes<br>\n`60`: 60 minutes<br>\n`90`: 90 minutes<br>\n`120`: 120 minutes\n';
          type: 'integer';
        };
        sign_again_period_for_inactivity_on_web: {
          description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`60`: 60 minutes<br>\n`120`: 120 minutes\n\n    \n\n';
          type: 'integer';
        };
        sign_in_with_two_factor_auth: {
          description: 'Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:\n`all`: Two factor authentication will be enabled for all users in the account.<br>\n`none`: Two factor authentication is disabled.<br>\n`group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>\n`role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the\n`sign_in_with_two_factor_auth_roles` field.\n';
          enum: ['all', 'group', 'role', 'none'];
          type: 'string';
        };
        sign_in_with_two_factor_auth_groups: {
          description: 'This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        sign_in_with_two_factor_auth_roles: {
          description: 'This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
    };
    AccountSettingsTSP: {
      description: 'Account Settings: TSP.';
      properties: {
        call_out: {
          description: 'Call Out';
          type: 'boolean';
        };
        call_out_countries: {
          description: 'Call Out Countries/Regions';
          items: {};
          type: 'array';
        };
        display_toll_free_numbers: {
          description: 'Display toll-free numbers';
          type: 'boolean';
        };
        show_international_numbers_link: {
          description: 'Show international numbers link on the invitation email';
          type: 'boolean';
        };
      };
      type: 'object';
    };
    AccountSettingsTelephony: {
      description: 'Account Settings: Telephony.';
      properties: {
        audio_conference_info: {
          description: 'Third party audio conference info.';
          type: 'string';
        };
        telephony_regions: {
          description: 'Indicates where most of the participants call into or call from duriing a meeting.';
          properties: {
            allowed_values: {
              description: 'Telephony region options provided by Zoom to select from.';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            selection_values: {
              description: 'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.';
              items: {
                type: 'string';
              };
              type: 'array';
            };
          };
          type: 'object';
        };
        third_party_audio: {
          description: 'Users can join the meeting using the existing third party audio configuration.';
          type: 'boolean';
        };
      };
      type: 'object';
    };
    AccountSettingsUpdateTelephony: {
      description: 'Account Settings Update: Telephony.';
      properties: {
        audio_conference_info: {
          description: 'Third party audio conference info.';
          type: 'string';
        };
        telephony_regions: {
          description: 'Indicates where most of the participants call into or call from duriing a meeting.';
          properties: {
            selection_values: {
              description: 'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.';
              items: {
                type: 'string';
              };
              type: 'array';
            };
          };
          type: 'object';
        };
        third_party_audio: {
          description: 'Users can join the meeting using the existing third party audio configuration.';
          type: 'boolean';
        };
      };
      type: 'object';
    };
    AccountSettingsZoomRooms: {
      description: 'Account Settings: Zoom Rooms.';
      properties: {
        auto_start_stop_scheduled_meetings: {
          description: 'Automatic start and stop for scheduled meetings.';
          type: 'boolean';
        };
        cmr_for_instant_meeting: {
          description: 'Cloud recording for instant meetings.';
          type: 'boolean';
        };
        force_private_meeting: {
          description: 'Shift all meetings to private.';
          type: 'boolean';
        };
        hide_host_information: {
          description: 'Hide host and meeting ID from private meetings.';
          type: 'boolean';
        };
        list_meetings_with_calendar: {
          description: 'Display meeting list with calendar integration.';
          type: 'boolean';
        };
        start_airplay_manually: {
          description: 'Start AirPlay service manually.';
          type: 'boolean';
        };
        ultrasonic: {
          description: 'Automatic direct sharing using an ultrasonic proximity signal.';
          type: 'boolean';
        };
        upcoming_meeting_alert: {
          description: 'Upcoming meeting alert.';
          type: 'boolean';
        };
        weekly_system_restart: {
          description: 'Weekly system restart.';
          type: 'boolean';
        };
        zr_post_meeting_feedback: {
          description: 'Zoom Room post meeting feedback.';
          type: 'boolean';
        };
      };
      type: 'object';
    };
    AccountUpdateSettings: {
      properties: {
        email_notification: {
          description: 'Account Settings: Notification.';
          properties: {
            alternative_host_reminder: {
              description: 'Notify when an alternative host is set or removed from a meeting.';
              type: 'boolean';
            };
            cancel_meeting_reminder: {
              description: 'Notify the host and participants when a meeting is cancelled.';
              type: 'boolean';
            };
            cloud_recording_avaliable_reminder: {
              description: 'Notify host when cloud recording is available.';
              type: 'boolean';
            };
            jbh_reminder: {
              description: 'Notify the host when participants join the meeting before them.';
              type: 'boolean';
            };
            low_host_count_reminder: {
              description: 'Notify user when host licenses are running low.';
              type: 'boolean';
            };
            schedule_for_reminder: {
              description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        feature: {
          description: 'Account Settings: Feature.';
          properties: {
            meeting_capacity: {
              description: 'Set the maximum number of participants a host can have in a single meeting.';
              type: 'integer';
            };
          };
          type: 'object';
        };
        in_meeting: {
          description: 'Account Settings: In Meeting.';
          properties: {
            alert_guest_join: {
              description: 'Identify guest participants in a meeting or webinar.';
              type: 'boolean';
            };
            allow_live_streaming: {
              description: 'Allow live streaming.';
              type: 'boolean';
            };
            allow_participants_to_rename: {
              description: 'If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.\n';
              type: 'boolean';
            };
            allow_show_zoom_windows: {
              description: 'Show the Zoom desktop application when sharing screens. ';
              type: 'boolean';
            };
            annotation: {
              description: 'Allow participants to use annotation tools to add information to shared screens.';
              type: 'boolean';
            };
            anonymous_question_answer: {
              description: 'Allow an anonymous Q&A in a webinar.';
              type: 'boolean';
            };
            attendee_on_hold: {
              default: false;
              description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
              type: 'boolean';
            };
            auto_answer: {
              description: 'Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.';
              type: 'boolean';
            };
            auto_saving_chat: {
              description: 'Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.';
              type: 'boolean';
            };
            breakout_room: {
              description: 'Allow host to split meeting participants into separate, smaller rooms.';
              type: 'boolean';
            };
            chat: {
              description: 'Allow meeting participants to send a message that is visible to all participants.';
              type: 'boolean';
            };
            closed_caption: {
              description: 'Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions. ';
              type: 'boolean';
            };
            co_host: {
              description: 'Allow the host to add co-hosts.';
              type: 'boolean';
            };
            custom_data_center_regions: {
              description: 'If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.';
              type: 'boolean';
            };
            custom_live_streaming_service: {
              description: 'Custom live streaming.';
              type: 'boolean';
            };
            custom_service_instructions: {
              description: 'Custom service instructions.';
              type: 'string';
            };
            data_center_regions: {
              description: 'If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).\n';
              enum: ['EU', 'HK', 'AU', 'IN', 'TY', 'CN', 'US', 'CA'];
              items: {
                type: 'string';
              };
              type: 'array';
            };
            dscp_audio: {
              description: 'DSCP audio.';
              maximum: 63;
              minimum: 1;
              type: 'integer';
            };
            dscp_marking: {
              description: 'DSCP marking.';
              type: 'boolean';
            };
            dscp_video: {
              description: 'DSCP video.';
              maximum: 63;
              minimum: 1;
              type: 'integer';
            };
            e2e_encryption: {
              description: 'Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).';
              type: 'boolean';
            };
            entry_exit_chime: {
              description: 'Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.';
              enum: ['host', 'all', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Heard by host only', 'Heard by host and all attendees', 'Disable'];
            };
            far_end_camera_control: {
              description: 'Allow another user to take control of your camera during a meeting.';
              type: 'boolean';
            };
            feedback: {
              description: 'Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.';
              type: 'boolean';
            };
            file_transfer: {
              description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.';
              type: 'boolean';
            };
            group_hd: {
              description: 'Activate higher quality video for host and participants.\nPlease note: This will use more bandwidth.';
              type: 'boolean';
            };
            meeting_reactions: {
              description: 'Enable or disable meeting reactions. <br>\n`true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>\n`false`: Do not enable meeting reactions.';
              type: 'boolean';
            };
            original_audio: {
              description: 'Allow users to select original sound in their client settings.';
              type: 'boolean';
            };
            p2p_connetion: {
              description: 'Peer to peer connection while only two people are in a meeting.';
              type: 'boolean';
            };
            p2p_ports: {
              description: 'Peer to peer listening ports range.';
              type: 'boolean';
            };
            polling: {
              description: 'Add "Polls" to the meeting controls.';
              type: 'boolean';
            };
            ports_range: {
              default: '';
              description: 'The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.';
              type: 'string';
            };
            post_meeting_feedback: {
              description: 'Display a thumbs up or down survey at the end of each meeting.';
              type: 'boolean';
            };
            private_chat: {
              description: 'Allow a meeting participant to send a private message to another participant.';
              type: 'boolean';
            };
            record_play_own_voice: {
              description: 'Record and play their own voice.';
              type: 'boolean';
            };
            remote_control: {
              description: 'Allow users to request remote control.';
              type: 'boolean';
            };
            request_permission_to_unmute: {
              description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.';
              type: 'boolean';
            };
            screen_sharing: {
              description: 'Allow screen sharing.';
              type: 'boolean';
            };
            sending_default_email_invites: {
              description: 'Only show the default email when sending email invites.';
              type: 'boolean';
            };
            show_a_join_from_your_browser_link: {
              description: 'If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.';
              type: 'boolean';
            };
            show_meeting_control_toolbar: {
              description: 'Always show the meeting control toolbar.';
              type: 'boolean';
            };
            stereo_audio: {
              description: 'Allow users to select stereo audio in their client settings.';
              type: 'boolean';
            };
            use_html_format_email: {
              description: 'Use HTML formatted email for the Outlook plugin.';
              type: 'boolean';
            };
            virtual_background: {
              description: 'Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.';
              type: 'boolean';
            };
            virtual_background_settings: {
              description: 'Settings to manage virtual background.';
              properties: {
                allow_upload_custom: {
                  description: 'Allow users to upload custom backgrounds.';
                  type: 'boolean';
                };
                allow_videos: {
                  description: 'Allow use of videos for virtual backgrounds.';
                  type: 'boolean';
                };
                enable: {
                  description: 'Enable virtual background.';
                  type: 'boolean';
                };
                files: {
                  items: {
                    properties: {
                      id: {
                        description: 'Unique identifier of the file.';
                        type: 'string';
                      };
                      is_default: {
                        description: 'Indicates whether or not this file is the default virtual background file.';
                        type: 'boolean';
                      };
                      name: {
                        description: 'File name.';
                        type: 'string';
                      };
                      size: {
                        description: 'File size.';
                        type: 'string';
                      };
                      type: {
                        description: 'File type.';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            watermark: {
              description: 'Add a watermark when viewing a shared screen.';
              type: 'boolean';
            };
            webinar_question_answer: {
              description: 'Allow a Q&A in a webinar.';
              type: 'boolean';
            };
            whiteboard: {
              description: 'Allow participants to share a whiteboard that includes annotation tools.';
              type: 'boolean';
            };
            who_can_share_screen: {
              description: 'Indicates who can share their screen or content during meetings. The value can be one of the following: <br>\n`host`: Only host can share the screen.<br>\n`all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
              enum: ['host', 'all'];
              type: 'string';
            };
            who_can_share_screen_when_someone_is_sharing: {
              description: 'Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>\n`host`: Only a host can share the screen when someone else is sharing.<br>\n`all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
              enum: ['host', 'all'];
              type: 'string';
            };
            workplace_by_facebook: {
              description: 'Workplace by facebook.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        integration: {
          description: 'Account Settings: Integration.';
          properties: {
            box: {
              description: 'Enable users who join a meeting from their mobile device to share content from their Box account.';
              type: 'boolean';
            };
            dropbox: {
              description: 'Enable users who join a meeting from their mobile device to share content from their Dropbox account.';
              type: 'boolean';
            };
            google_calendar: {
              description: 'Enable meetings to be scheduled using Google Calendar.';
              type: 'boolean';
            };
            google_drive: {
              description: 'Enable users who join a meeting from their mobile device to share content from their Google Drive.';
              type: 'boolean';
            };
            kubi: {
              description: 'Enable users to control a connected Kubi device from within a Zoom meeting.';
              type: 'boolean';
            };
            microsoft_one_drive: {
              description: 'Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        profile: {
          properties: {
            recording_storage_location: {
              properties: {
                allowed_values: {
                  description: 'Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.\n\nProvide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                value: {
                  description: 'Abbreviated country code.';
                  type: 'string';
                };
              };
              type: 'object';
            };
          };
          title: 'Profile';
          type: 'object';
        };
        recording: {
          description: 'Account Settings: Recording.';
          properties: {
            account_user_access_recording: {
              description: 'Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.';
              type: 'boolean';
            };
            allow_recovery_deleted_cloud_recordings: {
              description: 'Allow recovery of deleted cloud recordings from trash. \nIf the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period. ';
              type: 'boolean';
            };
            archive: {
              description: '[Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.';
              properties: {
                enable: {
                  description: 'Enable the archiving feature.';
                  type: 'boolean';
                };
                settings: {
                  properties: {
                    audio_file: {
                      description: 'Include in-meeting and/or in-webinar audio in the archive.';
                      type: 'boolean';
                    };
                    cc_transcript_file: {
                      description: 'Include closed caption or transcript in the archive.';
                      type: 'boolean';
                    };
                    chat_file: {
                      description: 'Include in-meeting chat in the archive.';
                      type: 'boolean';
                    };
                    chat_with_sender_email: {
                      description: 'Include user email in in-meeting chat file.';
                      type: 'boolean';
                    };
                    video_file: {
                      description: 'Include in-meeting and/or in-webinar video in the archive.';
                      type: 'boolean';
                    };
                  };
                  type: 'object';
                };
                type: {
                  description: 'Archive types:\n\n* `1`: Only meetings are archived.<br>\n* `2`: Only webinars are archived.<br>\n* `3`: Both meetings and webinars are archived.';
                  enum: [1, 2, 3];
                  type: 'integer';
                };
              };
              type: 'object';
            };
            auto_delete_cmr: {
              description: 'Allow Zoom to permanantly delete recordings automatically after a specified number of days.';
              type: 'boolean';
            };
            auto_delete_cmr_days: {
              description: "When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.";
              type: 'integer';
            };
            auto_recording: {
              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
              enum: ['local', 'cloud', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Record on local', 'Record on cloud', 'Disabled'];
            };
            cloud_recording: {
              description: 'Allow hosts to record and save the meeting in the cloud.';
              type: 'boolean';
            };
            cloud_recording_download: {
              description: 'Cloud recording downloads.';
              type: 'boolean';
            };
            cloud_recording_download_host: {
              description: 'Only the host can download cloud recordings.';
              type: 'boolean';
            };
            host_delete_cloud_recording: {
              description: 'If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.\n';
              type: 'boolean';
            };
            ip_address_access_control: {
              description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
              properties: {
                enable: {
                  description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                  type: 'boolean';
                };
                ip_addresses_or_ranges: {
                  description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                  type: 'string';
                };
              };
              type: 'object';
            };
            local_recording: {
              description: 'Allow hosts and participants to record the meeting using a local file.';
              type: 'boolean';
            };
            prevent_host_access_recording: {
              description: 'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n';
              type: 'boolean';
            };
            record_audio_file: {
              description: 'Record an audio only file.';
              type: 'boolean';
            };
            record_gallery_view: {
              description: 'Record the gallery view with a shared screen.';
              type: 'boolean';
            };
            record_speaker_view: {
              description: 'Record the active speaker with a shared screen.';
              type: 'boolean';
            };
            recording_audio_transcript: {
              description: 'Automatically transcribe the audio of the meeting or webinar to the cloud.';
              type: 'boolean';
            };
            recording_disclaimer: {
              description: 'Show a disclaimer to participants before a recording starts\n';
              type: 'boolean';
            };
            recording_password_requirement: {
              description: 'This object represents the minimum password requirements set for recordings via Account Recording Settings.';
              properties: {
                have_letter: {
                  description: 'Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).';
                  type: 'boolean';
                };
                have_number: {
                  description: 'Indicates whether or not password must contain at least one number(1, 2, 3..).';
                  type: 'boolean';
                };
                have_special_character: {
                  description: 'Indicates whether or not password must contain at least one special character(!, @, #..).';
                  type: 'boolean';
                };
                length: {
                  description: 'Minimum required length for the password.';
                  maximum: 10;
                  type: 'integer';
                };
                only_allow_numeric: {
                  description: 'Indicates whether or not password must contain only numeric characters.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            required_password_for_existing_cloud_recordings: {
              description: 'Require a passcode to access existing cloud recordings.';
              type: 'boolean';
            };
            save_chat_text: {
              description: 'Save the chat text from the meeting.';
              type: 'boolean';
            };
            show_timestamp: {
              description: 'Add a timestamp to the recording.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        schedule_meeting: {
          description: 'Account Settings: Schedule Meeting.';
          properties: {
            audio_type: {
              default: 'both';
              description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.';
              enum: ['both', 'telephony', 'voip', 'thirdParty'];
              type: 'string';
              'x-enum-descriptions': [
                'Telephony and VoIP',
                'Audio PSTN telephony only',
                'VoIP only',
                '3rd party audio conference',
              ];
            };
            enforce_login: {
              description: 'Only Zoom users who are signed in can join meetings.';
              type: 'boolean';
            };
            enforce_login_domains: {
              description: 'Only signed in users with a specified domain can join the meeting. ';
              type: 'string';
            };
            enforce_login_with_domains: {
              description: 'Only signed in users with a specific domain can join meetings.';
              type: 'boolean';
            };
            force_pmi_jbh_password: {
              description: 'Require a password for Personal Meetings if attendees can join before host.';
              type: 'boolean';
            };
            host_video: {
              description: 'Start meetings with the host video on.';
              type: 'boolean';
            };
            join_before_host: {
              description: 'Allow participants to join the meeting before the host arrives.';
              type: 'boolean';
            };
            meeting_password_requirement: {
              description: 'Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
              properties: {
                consecutive_characters_length: {
                  enum: [0, 4, 5, 6, 7, 8];
                  type: 'integer';
                };
                have_letter: {
                  description: 'If set to `true`, the password must contain at least 1 letter (such as a,b,c...).\n';
                  type: 'boolean';
                };
                have_number: {
                  description: 'If set to `true`, the password must contain at least 1 number (such as 1,2,3...).';
                  type: 'boolean';
                };
                have_special_character: {
                  description: 'If set to `true`, the password must have at least 1 special character (!,@,#...).';
                  type: 'boolean';
                };
                have_upper_and_lower_characters: {
                  description: 'If set to `true`, the password must include both uppercase and lowercase characters.';
                  type: 'boolean';
                };
                length: {
                  description: 'The minimum length that the meeting/webinar password needs to have.';
                  type: 'integer';
                };
                only_allow_numeric: {
                  description: 'If set to `true`, the password must only contain numbers and no other characters.';
                  type: 'boolean';
                };
                weak_enhance_detection: {
                  description: 'If set to `true`, users will be informed if the provided password is weak.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            not_store_meeting_topic: {
              description: 'Always display "Zoom Meeting" as the meeting topic.';
              type: 'boolean';
            };
            participant_video: {
              description: 'Start meetings with the participant video on. Participants can change this setting during the meeting.';
              type: 'boolean';
            };
            personal_meeting: {
              description: 'Personal Meeting Setting.<br><br>\n`true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.\nFor Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n';
              type: 'boolean';
            };
            require_password_for_instant_meetings: {
              description: 'Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
              type: 'boolean';
            };
            require_password_for_pmi_meetings: {
              description: 'Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
              enum: ['jbh_only', 'all', 'none'];
              type: 'string';
              'x-enum-descriptions': [
                'Only meetings with Join Before Host enabled',
                'All meetings using PMI',
                'Disabled',
              ];
            };
            require_password_for_scheduled_meetings: {
              description: 'Require a password for meetings which have already been scheduled\n';
              type: 'boolean';
            };
            require_password_for_scheduling_new_meetings: {
              description: 'Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.';
              type: 'boolean';
            };
            use_pmi_for_instant_meetings: {
              description: 'Use Personal Meeting ID (PMI) when starting an instant meeting\n';
              type: 'boolean';
            };
            use_pmi_for_scheduled_meetings: {
              description: 'Use Personal Meeting ID (PMI) when scheduling a meeting\n';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        security: {
          description: '[Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.';
          properties: {
            admin_change_name_pic: {
              description: "Only account administrators can change a user's username and picture.";
              type: 'boolean';
            };
            hide_billing_info: {
              description: 'Hide billing information.';
              type: 'boolean';
            };
            import_photos_from_devices: {
              description: 'Allow users to import photos from a photo library on a  device.';
              type: 'boolean';
            };
            password_requirement: {
              description: "This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password. ";
              properties: {
                consecutive_characters_length: {
                  description: '\nSpecify the max length of consecutive characters(abcde...) that can be used in a password.\nIf you set the value of this field to `0`, no restriction will be applied on consecutive characters. \n\nIf you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.\n\nThe max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).';
                  type: 'integer';
                };
                have_special_character: {
                  description: 'If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).';
                  type: 'boolean';
                };
                minimum_password_length: {
                  description: 'Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.';
                  maximum: 14;
                  minimum: 8;
                  type: 'integer';
                };
                weak_enhance_detection: {
                  description: 'If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            sign_again_period_for_inactivity_on_client: {
              description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`45`: 45 minutes<br>\n`60`: 60 minutes<br>\n`90`: 90 minutes<br>\n`120`: 120 minutes\n';
              type: 'integer';
            };
            sign_again_period_for_inactivity_on_web: {
              description: 'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`60`: 60 minutes<br>\n`120`: 120 minutes\n\n    \n\n';
              type: 'integer';
            };
            sign_in_with_two_factor_auth: {
              description: 'Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:\n`all`: Two factor authentication will be enabled for all users in the account.<br>\n`none`: Two factor authentication is disabled.<br>\n`group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>\n`role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the\n`sign_in_with_two_factor_auth_roles` field.\n';
              enum: ['all', 'group', 'role', 'none'];
              type: 'string';
            };
            sign_in_with_two_factor_auth_groups: {
              description: 'This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            sign_in_with_two_factor_auth_roles: {
              description: 'This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.';
              items: {
                type: 'string';
              };
              type: 'array';
            };
          };
          type: 'object';
        };
        telephony: {
          description: 'Account Settings Update: Telephony.';
          properties: {
            audio_conference_info: {
              description: 'Third party audio conference info.';
              type: 'string';
            };
            telephony_regions: {
              description: 'Indicates where most of the participants call into or call from duriing a meeting.';
              properties: {
                selection_values: {
                  description: 'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            third_party_audio: {
              description: 'Users can join the meeting using the existing third party audio configuration.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        tsp: {
          description: 'Account Settings: TSP.';
          properties: {
            call_out: {
              description: 'Call Out';
              type: 'boolean';
            };
            call_out_countries: {
              description: 'Call Out Countries/Regions';
              items: {};
              type: 'array';
            };
            display_toll_free_numbers: {
              description: 'Display toll-free numbers';
              type: 'boolean';
            };
            show_international_numbers_link: {
              description: 'Show international numbers link on the invitation email';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        zoom_rooms: {
          description: 'Account Settings: Zoom Rooms.';
          properties: {
            auto_start_stop_scheduled_meetings: {
              description: 'Automatic start and stop for scheduled meetings.';
              type: 'boolean';
            };
            cmr_for_instant_meeting: {
              description: 'Cloud recording for instant meetings.';
              type: 'boolean';
            };
            force_private_meeting: {
              description: 'Shift all meetings to private.';
              type: 'boolean';
            };
            hide_host_information: {
              description: 'Hide host and meeting ID from private meetings.';
              type: 'boolean';
            };
            list_meetings_with_calendar: {
              description: 'Display meeting list with calendar integration.';
              type: 'boolean';
            };
            start_airplay_manually: {
              description: 'Start AirPlay service manually.';
              type: 'boolean';
            };
            ultrasonic: {
              description: 'Automatic direct sharing using an ultrasonic proximity signal.';
              type: 'boolean';
            };
            upcoming_meeting_alert: {
              description: 'Upcoming meeting alert.';
              type: 'boolean';
            };
            weekly_system_restart: {
              description: 'Weekly system restart.';
              type: 'boolean';
            };
            zr_post_meeting_feedback: {
              description: 'Zoom Room post meeting feedback.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
      };
      title: 'Update account settings';
      type: 'object';
    };
    BillingContact: {
      description: 'Billing Contact object.';
      properties: {
        address: {
          description: "Billing Contact's address.";
          type: 'string';
        };
        apt: {
          description: "Billing Contact's apartment/suite.";
          type: 'string';
        };
        city: {
          description: "Billing Contact's city.";
          type: 'string';
        };
        country: {
          description: "Billing Contact's country.";
          type: 'string';
        };
        email: {
          description: "Billing Contact's email address.";
          type: 'string';
        };
        first_name: {
          description: "Billing Contact's first name.";
          type: 'string';
        };
        last_name: {
          description: "Billing Contact's last name.";
          type: 'string';
        };
        phone_number: {
          description: "Billing Contact's phone number.";
          type: 'string';
        };
        state: {
          description: "Billing Contact's state.";
          type: 'string';
        };
        zip: {
          description: "Billing Contact's zip/postal code.";
          type: 'string';
        };
      };
      type: 'object';
    };
    BillingContactRequired: {
      description: 'Billing Contact object.';
      properties: {
        address: {
          description: "Billing Contact's address.";
          type: 'string';
        };
        apt: {
          description: "Billing Contact's apartment/suite.";
          type: 'string';
        };
        city: {
          description: "Billing Contact's city.";
          type: 'string';
        };
        country: {
          description: "Billing Contact's Country [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) in abbreviated format.";
          type: 'string';
        };
        email: {
          description: "Billing Contact's email address.";
          type: 'string';
        };
        first_name: {
          description: "Billing Contact's first name.";
          type: 'string';
        };
        last_name: {
          description: "Billing Contact's last name.";
          type: 'string';
        };
        phone_number: {
          description: "Billing Contact's phone number.";
          type: 'string';
        };
        state: {
          description: "Billing Contact's state.";
          type: 'string';
        };
        zip: {
          description: "Billing Contact's zip/postal code.";
          type: 'string';
        };
      };
      required: ['first_name', 'last_name', 'email', 'phone_number', 'address', 'city', 'state', 'zip', 'country'];
      type: 'object';
    };
    Channel: {
      description: 'The channel object represents a Zoom chat [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-). ';
      properties: {
        id: {
          description: 'Channel Id.';
          type: 'string';
        };
        name: {
          description: 'Name of the channel.';
          maxLength: 128;
          type: 'string';
        };
        type: {
          description: 'Type of the channel. The value can be one of the following:<br>\n`1`: Private channel. In this type of channel, members must be invited to join a channel.<br>\n`2`: Private channel with members that belong to one Zoom account. Members in this channel should be invited and the members should be from the same organization.<br>\n`3`: Public channel. Anyone can search for this channel and join the channel.<br>';
          enum: [1, 2, 3];
          type: 'integer';
        };
      };
      type: 'object';
    };
    CloudArchivedFiles: {
      additionalProperties: false;
      properties: {
        archive_files: {
          description: 'An explanation about the purpose of this instance.';
          items: {
            anyOf: [
              {
                additionalProperties: false;
                properties: {
                  download_url: {
                    description: 'The URL where the archived file can be downloaded. To download the archived file of a meeting or a webinar hosted in your account, create a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the `access_token` query parameter and include this query parameter at the end of the URL as shown in the example. Example: `https://{{base-domain}}/rec/archive/download/xxx?access_token={{Your-JWT}}`.<br>If a user has authorized and installed your OAuth app that supports archiving, use the user’s [OAuth access token(https://marketplace.zoom.us/docs/guides/auth/oauth) to download the file.<br>For example: `https://{{base-domain}}/rec/archive/download/xxx?access_token={{ OAuth Access Token }}`.';
                    type: 'string';
                  };
                  file_extension: {
                    description: 'The file extension of the recording.';
                    type: 'string';
                  };
                  file_size: {
                    description: 'The file size of the recording.';
                    type: 'integer';
                  };
                  file_type: {
                    description: 'The file type of the recording. The value of this field could be one of the following:`MP4`: Video file of the recording.<br>`M4A`: Audio-only file of the recording.<br>`TRANSCRIPT`: Transcription file of the recording in VTT format.<br>`CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>`CC`: File containing closed captions of the recording in VTT file format.<br>`CSV`: File containing polling data in csv format. See [Managing and sharing cloud recordings](https://support.zoom.us/hc/en-us/articles/205347605-Managing-and-sharing-cloud-recordings#h_9898497b-e736-4980-a749-d55608f10773) for details.';
                    type: 'string';
                  };
                  id: {
                    description: 'The unique identifier of the archived file.';
                    type: 'string';
                  };
                  recording_type: {
                    description: 'The value of this field can be one of the following:* `shared_screen_with_speaker_view(CC)`* `shared_screen_with_speaker_view`* `shared_screen_with_gallery_view`* `speaker_view`* `gallery_view`* `shared_screen`* `audio_only`* `audio_transcript`* `chat_file`,* `active_speaker`* `host_video`. See [Managing and sharing cloud recordings](https://support.zoom.us/hc/en-us/articles/205347605-Managing-and-sharing-cloud-recordings#h_9898497b-e736-4980-a749-d55608f10773) for details.';
                    type: 'string';
                  };
                  status: {
                    description: 'Status of the archived file.';
                    type: 'string';
                  };
                };
                required: [
                  'id',
                  'file_type',
                  'file_extension',
                  'file_size',
                  'download_url',
                  'status',
                  'recording_type',
                ];
                type: 'object';
              },
            ];
          };
          type: 'array';
          'x-additionalItems': true;
        };
        duration: {
          description: 'The duration.';
          type: 'integer';
        };
        host_id: {
          description: 'The ID of the user who set as the host of the meeting.';
          type: 'string';
        };
        id: {
          description: 'The Meeting ID, also known as the meeting number in long (int64) format.';
          type: 'integer';
        };
        recording_count: {
          description: 'Number of recording files returned in the response of this API call.';
          type: 'integer';
        };
        start_time: {
          description: 'Meeting start time.';
          format: 'date-time';
          type: 'string';
        };
        timezone: {
          description: 'Timezone to format the meeting start time.';
          type: 'string';
        };
        topic: {
          description: 'The meeting topic.';
          type: 'string';
        };
        total_size: {
          description: 'Total size of the archive.';
          type: 'integer';
        };
        type: {
          description: 'The meeting type:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.';
          enum: [1, 2, 3, 8];
          type: 'integer';
          'x-enum-descriptions': [
            'Instant Meeting',
            'Scheduled Meeting',
            'Recurring Meeting with no fixed time',
            'Recurring Meeting with fixed time',
          ];
        };
        uuid: {
          description: 'The Unique Meeting ID. Each meeting instance will generate its own Meeting UUID.';
          type: 'string';
        };
      };
      required: [
        'uuid',
        'id',
        'host_id',
        'topic',
        'type',
        'start_time',
        'timezone',
        'duration',
        'total_size',
        'recording_count',
        'archive_files',
      ];
      type: 'object';
    };
    CreateWebinarSettings: {
      description: 'Create Webinar settings.';
      properties: {
        allow_multiple_devices: {
          description: 'Allow attendees to join from multiple devices.';
          type: 'boolean';
        };
        alternative_hosts: {
          description: 'Alternative host emails or IDs. Multiple values separated by comma.';
          type: 'string';
        };
        approval_type: {
          default: 2;
          description: 'The default value is `2`. To enable registration required, set the approval type to `0` or `1`.  Values include:<br>\n\n`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
          enum: [0, 1, 2];
          type: 'integer';
          'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
        };
        attendees_and_panelists_reminder_email_notification: {
          description: 'Send reminder email to attendees and panelists.';
          properties: {
            enable: {
              description: '* `true`: Send reminder email to attendees and panelists.\n\n* `false`: Do not send reminder email to attendees and panelists.';
              type: 'boolean';
            };
            type: {
              description: '`0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.';
              enum: [0, 1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': [
                'Send 1 hour before webinar.',
                'Send 1 day before webinar.',
                'Send 1 hour and 1 day before webinar.',
                'Send 1 week before webinar.',
                'Send 1 hour and 1 week before webinar.',
                'Send 1 day and 1 week before webinar.',
                'Send 1 hour, 1 day and 1 week before webinar.',
              ];
            };
          };
          type: 'object';
        };
        audio: {
          default: 'both';
          description: 'Determine how participants can join the audio portion of the meeting.';
          enum: ['both', 'telephony', 'voip'];
          type: 'string';
          'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
        };
        authentication_domains: {
          description: 'Meeting authentication domains. This option, allows you to specify the rule so that Zoom users, whose email address contains a certain domain, can join the Webinar. You can either provide multiple domains, using a comma in between and/or use a wildcard for listing domains.';
          type: 'string';
        };
        authentication_option: {
          description: 'Specify the authentication type for users to join a Webinar with`meeting_authentication` setting set to `true`. The value of this field can be retrieved from the `id` field within `authentication_options` array in the response of [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings).';
          type: 'string';
        };
        auto_recording: {
          default: 'none';
          description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
          enum: ['local', 'cloud', 'none'];
          type: 'string';
          'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
        };
        close_registration: {
          description: 'Close registration after event date.';
          type: 'boolean';
        };
        contact_email: {
          description: 'Contact email for registration';
          type: 'string';
        };
        contact_name: {
          description: 'Contact name for registration';
          type: 'string';
        };
        email_language: {
          description: 'Set the email language to one of the following:\n`en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.';
          type: 'string';
        };
        enforce_login: {
          description: 'Only signed-in users can join this meeting. \n\n**This field is deprecated and will not be supported in future.** <br><br> Instead of this field, use the "meeting_authentication", "authentication_option" and/or "authentication_domains" fields to establish the authentication mechanism for this Webinar. ';
          type: 'boolean';
        };
        enforce_login_domains: {
          description: 'Only signed-in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in future.** <br><br> Instead of this field, use the "authentication_domains" field for this Webinar. ';
          type: 'string';
        };
        follow_up_absentees_email_notification: {
          description: 'Send follow-up email to absentees.';
          properties: {
            enable: {
              description: '* `true`: Send follow-up email to absentees.\n\n* `false`: Do not send follow-up email to absentees.';
              type: 'boolean';
            };
            type: {
              description: '`0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
              enum: [0, 1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': [
                'Send 1 days after the scheduled end date.',
                'Send 2 days after the scheduled end date.',
                'Send 3 days after the scheduled end date.',
                'Send 4 days after the scheduled end date.',
                'Send 5 days after the scheduled end date.',
                'Send 6 days after the scheduled end date.',
                'Send 7 days after the scheduled end date.',
              ];
            };
          };
          type: 'object';
        };
        follow_up_attendees_email_notification: {
          description: 'Send follow-up email to attendees.';
          properties: {
            enable: {
              description: '* `true`: Send follow-up email to attendees.\n\n* `false`: Do not send follow-up email to attendees.';
              type: 'boolean';
            };
            type: {
              description: '`0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
              enum: [0, 1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': [
                'Send 1 day after the scheduled end date.',
                'Send 2 days after the scheduled end date.',
                'Send 3 days after the scheduled end date.',
                'Send 4 days after the scheduled end date.',
                'Send 5 days after the scheduled end date.',
                'Send 6 days after the scheduled end date.',
                'Send 7 days after the scheduled end date.',
              ];
            };
          };
          type: 'object';
        };
        global_dial_in_countries: {
          description: 'List of global dial-in countries';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        hd_video: {
          default: false;
          description: 'Default to HD video.';
          type: 'boolean';
        };
        host_video: {
          description: 'Start video when host joins webinar.';
          type: 'boolean';
        };
        meeting_authentication: {
          description: 'Only [authenticated](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) users can join meeting if the value of this field is set to `true`.';
          type: 'boolean';
        };
        on_demand: {
          default: false;
          description: 'Make the webinar on-demand';
          type: 'boolean';
        };
        panelists_invitation_email_notification: {
          description: '* `true`: Send invitation email to panelists.\n\n* `false`: Do not send invitation email to panelists.';
          type: 'boolean';
        };
        panelists_video: {
          description: 'Start video when panelists join webinar.';
          type: 'boolean';
        };
        post_webinar_survey: {
          description: "Zoom will open a survey page in attendees' browsers after leaving the webinar";
          type: 'boolean';
        };
        practice_session: {
          default: false;
          description: 'Enable practice session.';
          type: 'boolean';
        };
        question_and_answer: {
          description: "[Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.";
          properties: {
            allow_anonymous_questions: {
              description: '* `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..\n\n* `false`: Do not allow anonymous questions.';
              type: 'boolean';
            };
            answer_questions: {
              description: 'Indicate whether you want attendees to be able to view answered questions only or view all questions.\n\n* `only`: Attendees are able to view answered questions only.\n\n*  `all`: Attendees are able to view all questions submitted in the Q&A.';
              enum: ['only', 'all'];
              type: 'string';
            };
            attendees_can_comment: {
              description: '* `true`: Attendees can answer questions or leave a comment in the question thread.\n\n* `false`: Attendees can not answer questions or leave a comment in the question thread';
              type: 'boolean';
            };
            attendees_can_upvote: {
              description: '* `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.\n\n* `false`: Attendees can not click the thumbs up butoon on questions.';
              type: 'boolean';
            };
            enable: {
              description: "* `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.\n\n* `false`: Disable Q&A for webinar.";
              type: 'boolean';
            };
          };
          type: 'object';
        };
        registrants_email_notification: {
          description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
          type: 'boolean';
        };
        registrants_restrict_number: {
          default: 0;
          description: 'Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.';
          maximum: 20000;
          minimum: 0;
          type: 'integer';
        };
        registration_type: {
          default: 1;
          description: 'Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.';
          enum: [1, 2, 3];
          type: 'integer';
          'x-enum-descriptions': [
            'Attendees register once and can attend any of the occurrences',
            'Attendees need to register for each occurrence to attend',
            'Attendees register once and can choose one or more occurrences to attend',
          ];
        };
        show_share_button: {
          description: 'Show social share buttons on the registration page.';
          type: 'boolean';
        };
        survey_url: {
          description: 'Survey url for post webinar survey';
          type: 'string';
        };
      };
      type: 'object';
    };
    CustomQuestion: {
      description: 'Custom Question.';
      properties: {
        title: {
          type: 'string';
        };
        value: {
          type: 'string';
        };
      };
      type: 'object';
    };
    DateTime: {
      description: 'DateTime Object.';
      properties: {
        from: {
          description: 'Start Date.';
          format: 'date';
          type: 'string';
        };
        to: {
          description: 'End Date.';
          format: 'date';
          type: 'string';
        };
      };
      type: 'object';
    };
    Device: {
      description: 'The H.323/SIP device object.';
      properties: {
        encryption: {
          description: 'Device encryption:<br>`auto` - auto.<br>`yes` - yes.<br>`no` - no.';
          enum: ['auto', 'yes', 'no'];
          type: 'string';
          'x-enum-descriptions': ['auto', 'yes', 'no'];
        };
        ip: {
          description: 'Device IP.';
          type: 'string';
        };
        name: {
          description: 'Device name.';
          maxLength: 64;
          type: 'string';
        };
        protocol: {
          description: 'Device protocol:<br>`H.323` - H.323.<br>`SIP` - SIP.';
          enum: ['H.323', 'SIP'];
          type: 'string';
          'x-enum-descriptions': ['H.323', 'SIP'];
        };
      };
      required: ['name', 'protocol', 'ip', 'encryption'];
      title: 'The H.323/SIP device object.';
      type: 'object';
    };
    DeviceList: {
      allOf: [
        {
          description: 'Pagination Object.';
          properties: {
            next_page_token: {
              description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
              type: 'string';
            };
            page_count: {
              description: 'The number of pages returned for the request made.';
              type: 'integer';
            };
            page_number: {
              default: 1;
              description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
              type: 'integer';
            };
            page_size: {
              default: 30;
              description: 'The number of records returned with a single API call.';
              maximum: 300;
              type: 'integer';
            };
            total_records: {
              description: 'The total number of all the records available across pages.';
              type: 'integer';
            };
          };
          type: 'object';
        },
        {
          properties: {
            devices: {
              description: 'List of H.323/SIP Device objects.';
              items: {
                allOf: [
                  {
                    properties: {
                      id: {
                        description: 'Device ID.';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  },
                  {
                    description: 'The H.323/SIP device object.';
                    properties: {
                      encryption: {
                        description: 'Device encryption:<br>`auto` - auto.<br>`yes` - yes.<br>`no` - no.';
                        enum: ['auto', 'yes', 'no'];
                        type: 'string';
                        'x-enum-descriptions': ['auto', 'yes', 'no'];
                      };
                      ip: {
                        description: 'Device IP.';
                        type: 'string';
                      };
                      name: {
                        description: 'Device name.';
                        maxLength: 64;
                        type: 'string';
                      };
                      protocol: {
                        description: 'Device protocol:<br>`H.323` - H.323.<br>`SIP` - SIP.';
                        enum: ['H.323', 'SIP'];
                        type: 'string';
                        'x-enum-descriptions': ['H.323', 'SIP'];
                      };
                    };
                    required: ['name', 'protocol', 'ip', 'encryption'];
                    title: 'The H.323/SIP device object.';
                    type: 'object';
                  },
                ];
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'List of H.323/SIP Devices.';
      title: 'H.323/SIP Device List';
      type: 'object';
    };
    DomainsList: {
      description: 'List of managed domains.';
      properties: {
        domains: {
          description: 'List of managed domain objects.';
          items: {
            allOf: [
              {
                properties: {
                  domain: {
                    description: 'Domain name.';
                    type: 'string';
                  };
                  status: {
                    description: 'Domain status.';
                    type: 'string';
                  };
                };
              },
            ];
            type: 'object';
          };
          type: 'array';
        };
        total_records: {
          description: 'Total records.';
          type: 'integer';
        };
      };
      type: 'object';
    };
    Group: {
      description: 'Group object.';
      properties: {
        name: {
          description: 'Group name.';
          type: 'string';
        };
        total_members: {
          description: 'Total number of members in this group.';
          type: 'integer';
        };
      };
      type: 'object';
    };
    GroupList: {
      description: 'List of Groups.';
      properties: {
        groups: {
          description: 'List of Group objects.';
          items: {
            allOf: [
              {
                properties: {
                  id: {
                    description: 'Group ID.';
                    type: 'string';
                  };
                };
                type: 'object';
              },
              {
                description: 'Group object.';
                properties: {
                  name: {
                    description: 'Group name.';
                    type: 'string';
                  };
                  total_members: {
                    description: 'Total number of members in this group.';
                    type: 'integer';
                  };
                };
                type: 'object';
              },
            ];
          };
          type: 'array';
        };
        total_records: {
          description: 'Total records.';
          type: 'integer';
        };
      };
      type: 'object';
    };
    GroupMember: {
      description: 'Group member object.';
      properties: {
        email: {
          description: 'User email.';
          type: 'string';
        };
        first_name: {
          description: 'User first name.';
          type: 'string';
        };
        id: {
          description: 'User ID.';
          type: 'string';
        };
        last_name: {
          description: 'User last name.';
          type: 'string';
        };
        type: {
          description: 'User type.<br>\n`1` - Basic<br> `2` - Licensed<br> \n`3` - On-prem';
          type: 'integer';
        };
      };
      type: 'object';
    };
    GroupMemberList: {
      allOf: [
        {
          description: 'Pagination Object.';
          properties: {
            next_page_token: {
              description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
              type: 'string';
            };
            page_count: {
              description: 'The number of pages returned for the request made.';
              type: 'integer';
            };
            page_number: {
              default: 1;
              description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
              type: 'integer';
            };
            page_size: {
              default: 30;
              description: 'The number of records returned with a single API call.';
              maximum: 300;
              type: 'integer';
            };
            total_records: {
              description: 'The total number of all the records available across pages.';
              type: 'integer';
            };
          };
          type: 'object';
        },
        {
          properties: {
            members: {
              description: 'List of Group member objects.';
              items: {
                description: 'Group member object.';
                properties: {
                  email: {
                    description: 'User email.';
                    type: 'string';
                  };
                  first_name: {
                    description: 'User first name.';
                    type: 'string';
                  };
                  id: {
                    description: 'User ID.';
                    type: 'string';
                  };
                  last_name: {
                    description: 'User last name.';
                    type: 'string';
                  };
                  type: {
                    description: 'User type.<br>\n`1` - Basic<br> `2` - Licensed<br> \n`3` - On-prem';
                    type: 'integer';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'List of Group Members.';
      title: 'Group Member List';
      type: 'object';
    };
    GroupUserSettingsAuthentication: {
      oneOf: [
        {
          properties: {
            authentication_options: {
              description: 'Meeting Authentication Options';
              items: {
                properties: {
                  default_option: {
                    description: 'Authentication default option';
                    type: 'boolean';
                  };
                  domains: {
                    description: 'Authentication domains';
                    type: 'string';
                  };
                  id: {
                    description: 'Authentication id';
                    type: 'string';
                  };
                  name: {
                    description: 'Authentication name';
                    type: 'string';
                  };
                  type: {
                    description: ' Authentication type. Specify one of the following authentication types for the authentication profile:<br>\n * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>\n * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.';
                    enum: ['enforce_login', 'enforce_login_with_same_account', 'enforce_login_with_domains'];
                    type: 'string';
                  };
                  visible: {
                    description: 'Authentication visible';
                    type: 'boolean';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            meeting_authentication: {
              description: 'Only authenticated users can join meetings';
              type: 'boolean';
            };
          };
        },
        {
          properties: {
            authentication_options: {
              description: 'Authentication Options';
              items: {
                properties: {
                  default_option: {
                    description: 'Authentication default option';
                    type: 'boolean';
                  };
                  domains: {
                    description: 'Authentication domians';
                    type: 'string';
                  };
                  id: {
                    description: 'Authentication id';
                    type: 'string';
                  };
                  name: {
                    description: 'Authentication name';
                    type: 'string';
                  };
                  type: {
                    description: 'Authentication type';
                    enum: ['internally', 'enforce_login', 'enforce_login_with_domains'];
                    type: 'string';
                  };
                  visible: {
                    description: 'Authentication visible';
                    type: 'boolean';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            recording_authentication: {
              description: 'Only authenticated users can view cloud recordings';
              type: 'boolean';
            };
          };
        },
      ];
      type: 'object';
    };
    GroupUserSettingsAuthenticationUpdate: {
      oneOf: [
        {
          properties: {
            authentication_option: {
              description: 'Meeting Authentication Options';
              properties: {
                action: {
                  description: 'Authentication action';
                  enum: ['update', 'show', 'hide'];
                  type: 'string';
                };
                default_option: {
                  description: 'Authentication default option';
                  type: 'boolean';
                };
                domains: {
                  description: 'Authentication domains';
                  type: 'string';
                };
                id: {
                  description: 'Authentication id';
                  type: 'string';
                };
                name: {
                  description: 'Authentication name';
                  type: 'string';
                };
                type: {
                  description: ' Authentication type. Specify one of the following authentication types for the authentication profile:<br>\n * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>\n * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.';
                  enum: ['enforce_login', 'enforce_login_with_same_account', 'enforce_login_with_domains'];
                  type: 'string';
                };
              };
              type: 'object';
            };
            meeting_authentication: {
              description: 'Only authenticated users can join meetings';
              type: 'boolean';
            };
          };
        },
        {
          properties: {
            authentication_option: {
              description: 'Authentication Options';
              properties: {
                action: {
                  description: 'Authentication action';
                  enum: ['update', 'show', 'hide'];
                  type: 'string';
                };
                default_option: {
                  description: 'Authentication default option';
                  type: 'boolean';
                };
                domians: {
                  description: 'Authentication domians';
                  type: 'string';
                };
                id: {
                  description: 'Authentication id';
                  type: 'string';
                };
                name: {
                  description: 'Authentication name';
                  type: 'string';
                };
                type: {
                  description: 'Authentication type';
                  enum: ['internally', 'enforce_login', 'enforce_login_with_domains'];
                  type: 'string';
                };
              };
              type: 'object';
            };
            recording_authentication: {
              description: 'Only authenticated users can view cloud recordings';
              type: 'boolean';
            };
          };
        },
      ];
      title: 'GroupSettingsAuthenticationUpdate';
      type: 'object';
    };
    IMGroup: {
      allOf: [
        {
          description: 'Group object.';
          properties: {
            name: {
              description: 'Group name.';
              type: 'string';
            };
            total_members: {
              description: 'Total number of members in this group.';
              type: 'integer';
            };
          };
          type: 'object';
        },
        {
          properties: {
            search_by_account: {
              description: 'Members can search for others under same account.';
              type: 'boolean';
            };
            search_by_domain: {
              description: 'Members can search for others in the same email domain.';
              type: 'boolean';
            };
            search_by_ma_account: {
              description: 'Members can search for others under same master account - including all sub accounts.';
              type: 'boolean';
            };
            type: {
              default: 'normal';
              description: 'IM Group types:<br>`normal` - Only members can see the other members in the group. Other people can search for members in the group.<br>`shared` - Everyone in the account can see the group and members. <br>`restricted` - No one except group members can see the group or search for other group members. ';
              enum: ['normal', 'shared', 'restricted'];
              type: 'string';
              'x-enum-descriptions': [
                'Only members can see the group automatically. Other people can search members in the group.',
                'All people in the account can see the group and members automatically',
                'Nobody can see the group or search members except the members in the group',
              ];
            };
          };
        },
      ];
      description: 'IM group object.';
      type: 'object';
    };
    IMGroupList: {
      allOf: [
        {
          properties: {
            total_records: {
              description: 'Total number of records returned.';
              type: 'integer';
            };
          };
        },
        {
          properties: {
            groups: {
              description: 'List of group objects.';
              items: {
                allOf: [
                  {
                    properties: {
                      id: {
                        description: 'IM group ID.';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  },
                  {
                    allOf: [
                      {
                        description: 'Group object.';
                        properties: {
                          name: {
                            description: 'Group name.';
                            type: 'string';
                          };
                          total_members: {
                            description: 'Total number of members in this group.';
                            type: 'integer';
                          };
                        };
                        type: 'object';
                      },
                      {
                        properties: {
                          search_by_account: {
                            description: 'Members can search for others under same account.';
                            type: 'boolean';
                          };
                          search_by_domain: {
                            description: 'Members can search for others in the same email domain.';
                            type: 'boolean';
                          };
                          search_by_ma_account: {
                            description: 'Members can search for others under same master account - including all sub accounts.';
                            type: 'boolean';
                          };
                          type: {
                            default: 'normal';
                            description: 'IM Group types:<br>`normal` - Only members can see the other members in the group. Other people can search for members in the group.<br>`shared` - Everyone in the account can see the group and members. <br>`restricted` - No one except group members can see the group or search for other group members. ';
                            enum: ['normal', 'shared', 'restricted'];
                            type: 'string';
                            'x-enum-descriptions': [
                              'Only members can see the group automatically. Other people can search members in the group.',
                              'All people in the account can see the group and members automatically',
                              'Nobody can see the group or search members except the members in the group',
                            ];
                          };
                        };
                      },
                    ];
                    description: 'IM group object.';
                    type: 'object';
                  },
                ];
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'List of IM Groups.';
      title: 'IM Group List';
      type: 'object';
    };
    Meeting: {
      allOf: [
        {
          description: 'Base object for sessions.';
          properties: {
            agenda: {
              description: 'Meeting description.';
              type: 'string';
            };
            duration: {
              description: 'Meeting duration (minutes). Used for scheduled meetings only.';
              type: 'integer';
            };
            password: {
              description: 'Password to join the meeting. Password may only contain the following characters: [a-z A-Z 0-9 @ - _ *]. Max of 10 characters.';
              type: 'string';
            };
            recurrence: {
              description: 'Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time. ';
              properties: {
                end_date_time: {
                  description: 'Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
                  format: 'date-time';
                  type: 'string';
                };
                end_times: {
                  default: 1;
                  description: 'Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)';
                  maximum: 365;
                  type: 'integer';
                };
                monthly_day: {
                  default: 1;
                  description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
                  type: 'integer';
                };
                monthly_week: {
                  description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
                  enum: [-1, 1, 2, 3, 4];
                  type: 'integer';
                  'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
                };
                monthly_week_day: {
                  description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field. \n\n<br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
                  enum: [1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
                };
                repeat_interval: {
                  description: 'Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.\n\n';
                  type: 'integer';
                };
                type: {
                  description: 'Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
                  enum: [1, 2, 3];
                  type: 'integer';
                  'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
                };
                weekly_days: {
                  default: '1';
                  description: 'This field is required **if you\'re scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.';
                  enum: ['1', '2', '3', '4', '5', '6', '7'];
                  type: 'string';
                };
              };
              required: ['type'];
              type: 'object';
            };
            settings: {
              description: 'Meeting settings.';
              properties: {
                allow_multiple_devices: {
                  description: 'Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
                  type: 'boolean';
                };
                alternative_hosts: {
                  description: "Alternative host's emails or IDs: multiple values are separated by a semicolon.";
                  type: 'string';
                };
                alternative_hosts_email_notification: {
                  default: true;
                  description: 'Flag to determine whether to send email notifications to alternative hosts, default value is true.';
                  type: 'boolean';
                };
                approval_type: {
                  default: 2;
                  description: 'Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>\n\n`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
                  enum: [0, 1, 2];
                  type: 'integer';
                  'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
                };
                approved_or_denied_countries_or_regions: {
                  description: 'Approve or block users from specific regions/countries from joining this meeting. \n';
                  properties: {
                    approved_list: {
                      description: 'List of countries/regions from where participants can join this meeting. ';
                      items: {
                        type: 'string';
                      };
                      type: 'array';
                    };
                    denied_list: {
                      description: 'List of countries/regions from where participants can not join this meeting. ';
                      items: {
                        type: 'string';
                      };
                      type: 'array';
                    };
                    enable: {
                      description: '`true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>\n\n`false`: Setting disabled.';
                      type: 'boolean';
                    };
                    method: {
                      description: 'Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>\n`approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>\n`deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`';
                      enum: ['approve', 'deny'];
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
                audio: {
                  default: 'both';
                  description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.';
                  enum: ['both', 'telephony', 'voip'];
                  type: 'string';
                  'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
                };
                authentication_domains: {
                  description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
                  type: 'string';
                };
                authentication_exception: {
                  description: 'The participants added here will receive unique meeting invite links and bypass authentication.';
                  items: {
                    properties: {
                      email: {
                        description: 'Email address of the participant.';
                        format: 'email';
                        type: 'string';
                      };
                      name: {
                        description: 'Name of the participant.';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
                authentication_name: {
                  description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
                  type: 'string';
                };
                authentication_option: {
                  description: 'Meeting authentication option id.';
                  type: 'string';
                };
                auto_recording: {
                  default: 'none';
                  description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
                  enum: ['local', 'cloud', 'none'];
                  type: 'string';
                  'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
                };
                breakout_room: {
                  description: 'Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).';
                  properties: {
                    enable: {
                      description: 'Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.';
                      type: 'boolean';
                    };
                    rooms: {
                      description: 'Create room(s).';
                      items: {
                        properties: {
                          name: {
                            description: 'Name of the breakout room.';
                            type: 'string';
                          };
                          participants: {
                            description: 'Email addresses of the participants who are to be assigned to the breakout room.';
                            items: {
                              type: 'string';
                            };
                            type: 'array';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
                close_registration: {
                  default: false;
                  description: 'Close registration after event date';
                  type: 'boolean';
                };
                cn_meeting: {
                  default: false;
                  description: 'Host meeting in China.';
                  type: 'boolean';
                };
                contact_email: {
                  description: 'Contact email for registration';
                  type: 'string';
                };
                contact_name: {
                  description: 'Contact name for registration';
                  type: 'string';
                };
                custom_keys: {
                  description: 'Custom keys and values assigned to the meeting.';
                  items: {
                    properties: {
                      key: {
                        description: 'Custom key associated with the user.';
                        maxLength: 64;
                        type: 'string';
                      };
                      value: {
                        description: 'Value of the custom key associated with the user.';
                        maxLength: 256;
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  maxItems: 10;
                  type: 'array';
                };
                encryption_type: {
                  description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                  enum: ['enhanced_encryption', 'e2ee'];
                  type: 'string';
                };
                enforce_login: {
                  description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
                  type: 'boolean';
                };
                enforce_login_domains: {
                  description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
                  type: 'string';
                };
                global_dial_in_countries: {
                  description: 'List of global dial-in countries';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                global_dial_in_numbers: {
                  description: 'Global Dial-in Countries/Regions';
                  items: {
                    properties: {
                      city: {
                        description: 'City of the number, if any. For example, Chicago.';
                        type: 'string';
                      };
                      country: {
                        description: 'Country code. For example, BR.';
                        type: 'string';
                      };
                      country_name: {
                        description: 'Full name of country. For example, Brazil.';
                        type: 'string';
                      };
                      number: {
                        description: 'Phone number. For example, +1 2332357613.';
                        type: 'string';
                      };
                      type: {
                        description: 'Type of number. ';
                        enum: ['toll', 'tollfree'];
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
                host_video: {
                  description: 'Start video when the host joins the meeting.';
                  type: 'boolean';
                };
                in_meeting: {
                  default: false;
                  description: 'Host meeting in India.';
                  type: 'boolean';
                };
                jbh_time: {
                  description: 'If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:\n\n*  `0`: Allow participant to join anytime.\n*  `5`: Allow participant to join 5 minutes before meeting start time.\n * `10`: Allow participant to join 10 minutes before meeting start time.';
                  enum: [0, 5, 10];
                  type: 'integer';
                };
                join_before_host: {
                  default: false;
                  description: 'Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.';
                  type: 'boolean';
                };
                language_interpretation: {
                  properties: {
                    enable: {
                      type: 'boolean';
                    };
                    interpreters: {
                      description: 'Information associated with the interpreter.';
                      items: {
                        properties: {
                          email: {
                            description: 'Email address of the interpreter.';
                            format: 'email';
                            type: 'string';
                          };
                          languages: {
                            description: 'Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma. \n\nFor example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
                meeting_authentication: {
                  description: '`true`- Only authenticated users can join meetings.';
                  type: 'boolean';
                };
                mute_upon_entry: {
                  default: false;
                  description: 'Mute participants upon entry.';
                  type: 'boolean';
                };
                participant_video: {
                  description: 'Start video when participants join the meeting.';
                  type: 'boolean';
                };
                registrants_confirmation_email: {
                  description: 'Send confirmation email to registrants upon successful registration.';
                  type: 'boolean';
                };
                registrants_email_notification: {
                  description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
                  type: 'boolean';
                };
                registration_type: {
                  default: 1;
                  description: 'Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.';
                  enum: [1, 2, 3];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Attendees register once and can attend any of the occurrences',
                    'Attendees need to register for each occurrence to attend',
                    'Attendees register once and can choose one or more occurrences to attend',
                  ];
                };
                show_share_button: {
                  description: 'Show social share buttons on the meeting registration page.\nThis setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
                  type: 'boolean';
                };
                use_pmi: {
                  default: false;
                  description: 'Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.';
                  type: 'boolean';
                };
                waiting_room: {
                  default: false;
                  description: 'Enable waiting room';
                  type: 'boolean';
                };
                watermark: {
                  default: false;
                  description: 'Add watermark when viewing a shared screen.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            start_time: {
              description: "Meeting start time. When using a format like \"yyyy-MM-dd'T'HH:mm:ss'Z'\", always use GMT time. When using a format like \"yyyy-MM-dd'T'HH:mm:ss\", you should use local time and specify the time zone. This is only used for scheduled meetings and recurring meetings with a fixed time.";
              format: 'date-time';
              type: 'string';
            };
            timezone: {
              description: 'Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) list for supported time zones and their formats.';
              type: 'string';
            };
            topic: {
              description: 'Meeting topic.';
              type: 'string';
            };
            tracking_fields: {
              description: 'Tracking fields';
              items: {
                properties: {
                  field: {
                    description: 'Tracking fields type';
                    type: 'string';
                  };
                  value: {
                    description: 'Tracking fields value';
                    type: 'string';
                  };
                };
              };
              type: 'array';
            };
            type: {
              default: 2;
              description: 'Meeting Type:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.';
              enum: [1, 2, 3, 8];
              type: 'integer';
              'x-enum-descriptions': [
                'Instant Meeting',
                'Scheduled Meeting',
                'Recurring Meeting with no fixed time',
                'Recurring Meeting with fixed time',
              ];
            };
          };
          type: 'object';
        },
      ];
      description: 'Meeting object.';
      type: 'object';
    };
    MeetingCreate: {
      description: 'Base object for meeting.';
      properties: {
        agenda: {
          description: 'Meeting description.';
          maxLength: 2000;
          type: 'string';
        };
        duration: {
          description: 'Meeting duration (minutes). Used for scheduled meetings only.';
          type: 'integer';
        };
        password: {
          description: 'Passcode to join the meeting. By default, passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ *] and can have a maximum of 10 characters.\n\n**Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API. ';
          maxLength: 10;
          type: 'string';
        };
        recurrence: {
          description: 'Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time. ';
          properties: {
            end_date_time: {
              description: 'Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
              format: 'date-time';
              type: 'string';
            };
            end_times: {
              default: 1;
              description: 'Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)';
              maximum: 365;
              type: 'integer';
            };
            monthly_day: {
              default: 1;
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
              type: 'integer';
            };
            monthly_week: {
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
              enum: [-1, 1, 2, 3, 4];
              type: 'integer';
              'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
            };
            monthly_week_day: {
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field. \n\n<br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
              enum: [1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
            };
            repeat_interval: {
              description: 'Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.\n\n';
              type: 'integer';
            };
            type: {
              description: 'Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
            };
            weekly_days: {
              default: '1';
              description: 'This field is required **if you\'re scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.';
              enum: ['1', '2', '3', '4', '5', '6', '7'];
              type: 'string';
            };
          };
          required: ['type'];
          type: 'object';
        };
        schedule_for: {
          description: 'If you would like to schedule this meeting for someone else in your account, provide the Zoom user id or email address of the user here.';
          type: 'string';
        };
        settings: {
          description: 'Meeting settings.';
          properties: {
            additional_data_center_regions: {
              description: 'Enable additional [data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) for this meeting. Provide the value in the form of array of country code(s) for the countries which are available as data center regions in the [account settings](https://zoom.us/account/setting) but have been opt out of in the user settings. For instance, let\'s say that in your account settings, the data center regions that have been selected are Europe, Honkong, Australia, India, Latin America, Japan, China, United States,and Canada. The complete list of available data center regions for your account is: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]. In [user settings](https://zoom.us/profile/setting), you have opted out of India(IN) and Japan(TY) for meeting and webinar traffic routing. If you would like, you can still include India and Japan as additional data centers for this meeting using this field. To include India and Japan as additional data center regions, you would provide ["IN", "TY"] as the value.';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            allow_multiple_devices: {
              description: 'If set to `true`, attendees will be allowed to join a meeting from multiple devices.\n\n**Note:** This setting is only applied for meetings that have enabled registration.';
              type: 'boolean';
            };
            alternative_hosts: {
              description: "Alternative host's emails or IDs: multiple values separated by a comma.";
              type: 'string';
            };
            alternative_hosts_email_notification: {
              default: true;
              description: 'Flag to determine whether to send email notifications to alternative hosts, default value is true.';
              type: 'boolean';
            };
            approval_type: {
              default: 2;
              description: 'The default value is `2`. To enable registration required, set the approval type to `0` or `1`. Values include:<br>\n\n`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
              enum: [0, 1, 2];
              type: 'integer';
              'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
            };
            approved_or_denied_countries_or_regions: {
              description: 'Approve or block users from specific regions/countries from joining this meeting. \n';
              properties: {
                approved_list: {
                  description: 'List of countries/regions from where participants can join this meeting. ';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                denied_list: {
                  description: 'List of countries/regions from where participants can not join this meeting. ';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                enable: {
                  description: '`true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>\n\n`false`: Setting disabled.';
                  type: 'boolean';
                };
                method: {
                  description: 'Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>\n`approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>\n`deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`';
                  enum: ['approve', 'deny'];
                  type: 'string';
                };
              };
              type: 'object';
            };
            audio: {
              default: 'both';
              description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.';
              enum: ['both', 'telephony', 'voip'];
              type: 'string';
              'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
            };
            authentication_domains: {
              description: 'Meeting authentication domains. This option, allows you to specify the rule so that Zoom users, whose email address contains a certain domain, can join the meeting. You can either provide multiple domains, using a comma in between and/or use a wildcard for listing domains.';
              type: 'string';
            };
            authentication_option: {
              description: 'Specify the authentication type for users to join a meeting with`meeting_authentication` setting set to `true`. The value of this field can be retrieved from the `id` field within `authentication_options` array in the response of [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings).';
              type: 'string';
            };
            auto_recording: {
              default: 'none';
              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
              enum: ['local', 'cloud', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
            };
            breakout_room: {
              description: 'Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).';
              properties: {
                enable: {
                  description: 'Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.';
                  type: 'boolean';
                };
                rooms: {
                  description: 'Create room(s).';
                  items: {
                    properties: {
                      name: {
                        description: 'Name of the breakout room.';
                        type: 'string';
                      };
                      participants: {
                        description: 'Email addresses of the participants who are to be assigned to the breakout room.';
                        items: {
                          type: 'string';
                        };
                        type: 'array';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            close_registration: {
              default: false;
              description: 'Close registration after event date';
              type: 'boolean';
            };
            cn_meeting: {
              default: false;
              description: 'Host meeting in China.';
              type: 'boolean';
            };
            contact_email: {
              description: 'Contact email for registration';
              type: 'string';
            };
            contact_name: {
              description: 'Contact name for registration';
              type: 'string';
            };
            encryption_type: {
              description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
              enum: ['enhanced_encryption', 'e2ee'];
              type: 'string';
            };
            global_dial_in_countries: {
              description: 'List of global dial-in countries';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            host_video: {
              description: 'Start video when the host joins the meeting.';
              type: 'boolean';
            };
            in_meeting: {
              default: false;
              description: 'Host meeting in India.';
              type: 'boolean';
            };
            jbh_time: {
              description: 'If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:\n\n*  `0`: Allow participant to join anytime.\n*  `5`: Allow participant to join 5 minutes before meeting start time.\n * `10`: Allow participant to join 10 minutes before meeting start time.';
              enum: [0, 5, 10];
              type: 'integer';
            };
            join_before_host: {
              default: false;
              description: 'Allow participants to join the meeting before the host starts the meeting. This field can only used for scheduled or recurring meetings.\n\n**Note:** If waiting room is enabled, the **join before host** setting will be disabled.';
              type: 'boolean';
            };
            language_interpretation: {
              description: "Language interpretation [settings](https://support.zoom.us/hc/en-us/articles/360034919791-Language-interpretation-in-meetings-and-webinars#h_01EGGQFD3Q4BST3378SA762MJ1) for meetings. \n\n**Note:** This feature is only available on certain Webinar add-on, Education, Business and higher plans. If this feature is not enabled on the host's account, this setting will not be applied for the meeting.";
              properties: {
                enable: {
                  description: 'Indicate whether or not you would like to enable [language interpretation](https://support.zoom.us/hc/en-us/articles/360034919791-Language-interpretation-in-meetings-and-webinars#h_01EGGQFD3Q4BST3378SA762MJ1) for this meeting.';
                  type: 'boolean';
                };
                interpreters: {
                  description: 'Information associated with the interpreter.';
                  items: {
                    properties: {
                      email: {
                        description: 'Email address of the interpreter.';
                        format: 'email';
                        type: 'string';
                      };
                      languages: {
                        description: 'Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma. \n\nFor example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            meeting_authentication: {
              description: 'Only [authenticated](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) users can join meeting if the value of this field is set to `true`.';
              type: 'boolean';
            };
            mute_upon_entry: {
              default: false;
              description: 'Mute participants upon entry.';
              type: 'boolean';
            };
            participant_video: {
              description: 'Start video when participants join the meeting.';
              type: 'boolean';
            };
            registrants_email_notification: {
              description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
              type: 'boolean';
            };
            registration_type: {
              default: 1;
              description: 'Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': [
                'Attendees register once and can attend any of the occurrences',
                'Attendees need to register for each occurrence to attend',
                'Attendees register once and can choose one or more occurrences to attend',
              ];
            };
            show_share_button: {
              description: 'If set to `true`, the registration page for the meeting will include social share buttons.\n\n**Note:** This setting is only applied for meetings that have enabled registration.';
              type: 'boolean';
            };
            use_pmi: {
              default: false;
              description: 'Use Personal Meeting ID instead of an automatically generated meeting ID. It can only be used for scheduled meetings, instant meetings and recurring meetings with no fixed time.';
              type: 'boolean';
            };
            waiting_room: {
              description: 'Enable waiting room. Note that if the value of this field is set to `true`, it will override and disable the `join_before_host` setting.';
              type: 'boolean';
            };
            watermark: {
              default: false;
              description: 'Add watermark when viewing a shared screen.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        start_time: {
          description: 'Meeting start time. We support two formats for `start_time` - local time and GMT.<br> \n\nTo set time as GMT the format should be `yyyy-MM-dd`T`HH:mm:ssZ`. Example: "2020-03-31T12:02:00Z"\n\nTo set time using a specific timezone, use `yyyy-MM-dd`T`HH:mm:ss` format and specify the timezone [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) in the `timezone` field OR leave it blank and the timezone set on your Zoom account will be used. You can also set the time as UTC as the timezone field.\n\nThe `start_time` should only be used for scheduled and / or recurring webinars with fixed time.';
          format: 'date-time';
          type: 'string';
        };
        template_id: {
          description: 'Unique identifier of the **admin meeting template**. To create admin meeting templates, contact the Zoom support team.\n\nUse this field if you would like to [schedule the meeting from a admin meeting template](https://support.zoom.us/hc/en-us/articles/360036559151-Meeting-templates#h_86f06cff-0852-4998-81c5-c83663c176fb). You can retrieve the value of this field by calling the [List meeting templates](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/listmeetingtemplates) API.';
          type: 'string';
        };
        timezone: {
          description: 'Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) list for supported time zones and their formats.';
          type: 'string';
        };
        topic: {
          description: 'Meeting topic.';
          type: 'string';
        };
        tracking_fields: {
          description: 'Tracking fields';
          items: {
            properties: {
              field: {
                description: 'Label of the tracking field.';
                type: 'string';
              };
              value: {
                description: 'Tracking fields value';
                type: 'string';
              };
            };
            required: ['field'];
            type: 'object';
          };
          type: 'array';
        };
        type: {
          default: 2;
          description: 'Meeting Type:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.';
          enum: [1, 2, 3, 8];
          type: 'integer';
          'x-enum-descriptions': [
            'Instant Meeting',
            'Scheduled Meeting',
            'Recurring Meeting with no fixed time',
            'Recurring Meeting with fixed time',
          ];
        };
      };
      type: 'object';
    };
    MeetingInfo: {
      description: 'Meeting object';
      properties: {
        agenda: {
          description: 'Agenda';
          type: 'string';
        };
        created_at: {
          description: 'The date and time at which this meeting was created.';
          format: 'date-time';
          type: 'string';
        };
        duration: {
          description: 'Meeting duration.';
          type: 'integer';
        };
        h323_password: {
          description: 'H.323/SIP room system password';
          type: 'string';
        };
        join_url: {
          description: 'URL for participants to join the meeting. This URL should only be shared with users that you would like to invite for the meeting.';
          type: 'string';
        };
        occurrences: {
          description: 'Array of occurrence objects.';
          items: {
            description: 'Occurence object. This object is only returned for Recurring Webinars.';
            properties: {
              duration: {
                description: 'Duration.';
                type: 'integer';
              };
              occurrence_id: {
                description: 'Occurrence ID: Unique Identifier that identifies an occurrence of a recurring webinar. [Recurring webinars](https://support.zoom.us/hc/en-us/articles/216354763-How-to-Schedule-A-Recurring-Webinar) can have a maximum of 50 occurrences.';
                type: 'string';
              };
              start_time: {
                description: 'Start time.';
                format: 'date-time';
                type: 'string';
              };
              status: {
                description: 'Occurrence status.';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        password: {
          description: 'Meeting password. Password may only contain the following characters: `[a-z A-Z 0-9 @ - _ * !]`\n\nIf "Require a password when scheduling new meetings" setting has been **enabled** **and** [locked](https://support.zoom.us/hc/en-us/articles/115005269866-Using-Tiered-Settings#locked) for the user, the password field will be autogenerated in the response even if it is not provided in the API request. \n\n\n';
          type: 'string';
        };
        pmi: {
          description: 'Personal Meeting Id. Only used for scheduled meetings and recurring meetings with no fixed time.';
          format: 'int64';
          type: 'integer';
        };
        recurrence: {
          description: 'Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time. ';
          properties: {
            end_date_time: {
              description: 'Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
              format: 'date-time';
              type: 'string';
            };
            end_times: {
              default: 1;
              description: 'Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)';
              maximum: 365;
              type: 'integer';
            };
            monthly_day: {
              default: 1;
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
              type: 'integer';
            };
            monthly_week: {
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
              enum: [-1, 1, 2, 3, 4];
              type: 'integer';
              'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
            };
            monthly_week_day: {
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field. \n\n<br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
              enum: [1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
            };
            repeat_interval: {
              description: 'Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.\n\n';
              type: 'integer';
            };
            type: {
              description: 'Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
            };
            weekly_days: {
              default: '1';
              description: 'This field is required **if you\'re scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.';
              enum: ['1', '2', '3', '4', '5', '6', '7'];
              type: 'string';
            };
          };
          required: ['type'];
          type: 'object';
        };
        settings: {
          description: 'Meeting settings.';
          properties: {
            allow_multiple_devices: {
              description: 'Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
              type: 'boolean';
            };
            alternative_hosts: {
              description: "Alternative host's emails or IDs: multiple values are separated by a semicolon.";
              type: 'string';
            };
            alternative_hosts_email_notification: {
              default: true;
              description: 'Flag to determine whether to send email notifications to alternative hosts, default value is true.';
              type: 'boolean';
            };
            approval_type: {
              default: 2;
              description: 'Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>\n\n`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
              enum: [0, 1, 2];
              type: 'integer';
              'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
            };
            approved_or_denied_countries_or_regions: {
              description: 'Approve or block users from specific regions/countries from joining this meeting. \n';
              properties: {
                approved_list: {
                  description: 'List of countries/regions from where participants can join this meeting. ';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                denied_list: {
                  description: 'List of countries/regions from where participants can not join this meeting. ';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                enable: {
                  description: '`true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>\n\n`false`: Setting disabled.';
                  type: 'boolean';
                };
                method: {
                  description: 'Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>\n`approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>\n`deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`';
                  enum: ['approve', 'deny'];
                  type: 'string';
                };
              };
              type: 'object';
            };
            audio: {
              default: 'both';
              description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.';
              enum: ['both', 'telephony', 'voip'];
              type: 'string';
              'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
            };
            authentication_domains: {
              description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
              type: 'string';
            };
            authentication_exception: {
              description: 'The participants added here will receive unique meeting invite links and bypass authentication.';
              items: {
                properties: {
                  email: {
                    description: 'Email address of the participant.';
                    format: 'email';
                    type: 'string';
                  };
                  name: {
                    description: 'Name of the participant.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            authentication_name: {
              description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
              type: 'string';
            };
            authentication_option: {
              description: 'Meeting authentication option id.';
              type: 'string';
            };
            auto_recording: {
              default: 'none';
              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
              enum: ['local', 'cloud', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
            };
            breakout_room: {
              description: 'Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).';
              properties: {
                enable: {
                  description: 'Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.';
                  type: 'boolean';
                };
                rooms: {
                  description: 'Create room(s).';
                  items: {
                    properties: {
                      name: {
                        description: 'Name of the breakout room.';
                        type: 'string';
                      };
                      participants: {
                        description: 'Email addresses of the participants who are to be assigned to the breakout room.';
                        items: {
                          type: 'string';
                        };
                        type: 'array';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            close_registration: {
              default: false;
              description: 'Close registration after event date';
              type: 'boolean';
            };
            cn_meeting: {
              default: false;
              description: 'Host meeting in China.';
              type: 'boolean';
            };
            contact_email: {
              description: 'Contact email for registration';
              type: 'string';
            };
            contact_name: {
              description: 'Contact name for registration';
              type: 'string';
            };
            custom_keys: {
              description: 'Custom keys and values assigned to the meeting.';
              items: {
                properties: {
                  key: {
                    description: 'Custom key associated with the user.';
                    maxLength: 64;
                    type: 'string';
                  };
                  value: {
                    description: 'Value of the custom key associated with the user.';
                    maxLength: 256;
                    type: 'string';
                  };
                };
                type: 'object';
              };
              maxItems: 10;
              type: 'array';
            };
            encryption_type: {
              description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
              enum: ['enhanced_encryption', 'e2ee'];
              type: 'string';
            };
            enforce_login: {
              description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
              type: 'boolean';
            };
            enforce_login_domains: {
              description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
              type: 'string';
            };
            global_dial_in_countries: {
              description: 'List of global dial-in countries';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            global_dial_in_numbers: {
              description: 'Global Dial-in Countries/Regions';
              items: {
                properties: {
                  city: {
                    description: 'City of the number, if any. For example, Chicago.';
                    type: 'string';
                  };
                  country: {
                    description: 'Country code. For example, BR.';
                    type: 'string';
                  };
                  country_name: {
                    description: 'Full name of country. For example, Brazil.';
                    type: 'string';
                  };
                  number: {
                    description: 'Phone number. For example, +1 2332357613.';
                    type: 'string';
                  };
                  type: {
                    description: 'Type of number. ';
                    enum: ['toll', 'tollfree'];
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            host_video: {
              description: 'Start video when the host joins the meeting.';
              type: 'boolean';
            };
            in_meeting: {
              default: false;
              description: 'Host meeting in India.';
              type: 'boolean';
            };
            jbh_time: {
              description: 'If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:\n\n*  `0`: Allow participant to join anytime.\n*  `5`: Allow participant to join 5 minutes before meeting start time.\n * `10`: Allow participant to join 10 minutes before meeting start time.';
              enum: [0, 5, 10];
              type: 'integer';
            };
            join_before_host: {
              default: false;
              description: 'Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.';
              type: 'boolean';
            };
            language_interpretation: {
              properties: {
                enable: {
                  type: 'boolean';
                };
                interpreters: {
                  description: 'Information associated with the interpreter.';
                  items: {
                    properties: {
                      email: {
                        description: 'Email address of the interpreter.';
                        format: 'email';
                        type: 'string';
                      };
                      languages: {
                        description: 'Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma. \n\nFor example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            meeting_authentication: {
              description: '`true`- Only authenticated users can join meetings.';
              type: 'boolean';
            };
            mute_upon_entry: {
              default: false;
              description: 'Mute participants upon entry.';
              type: 'boolean';
            };
            participant_video: {
              description: 'Start video when participants join the meeting.';
              type: 'boolean';
            };
            registrants_confirmation_email: {
              description: 'Send confirmation email to registrants upon successful registration.';
              type: 'boolean';
            };
            registrants_email_notification: {
              description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
              type: 'boolean';
            };
            registration_type: {
              default: 1;
              description: 'Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': [
                'Attendees register once and can attend any of the occurrences',
                'Attendees need to register for each occurrence to attend',
                'Attendees register once and can choose one or more occurrences to attend',
              ];
            };
            show_share_button: {
              description: 'Show social share buttons on the meeting registration page.\nThis setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
              type: 'boolean';
            };
            use_pmi: {
              default: false;
              description: 'Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.';
              type: 'boolean';
            };
            waiting_room: {
              default: false;
              description: 'Enable waiting room';
              type: 'boolean';
            };
            watermark: {
              default: false;
              description: 'Add watermark when viewing a shared screen.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        start_time: {
          description: 'Meeting start date-time in UTC/GMT. Example: "2020-03-31T12:02:00Z"';
          format: 'date-time';
          type: 'string';
        };
        start_url: {
          description: 'URL to start the meeting. This URL should only be used by the host of the meeting and **should not be shared with anyone other than the host** of the meeting as anyone with this URL will be able to login to the Zoom Client as the host of the meeting.';
          type: 'string';
        };
        timezone: {
          description: 'Timezone to format start_time';
          type: 'string';
        };
        topic: {
          description: 'Meeting topic';
          maxLength: 200;
          type: 'string';
        };
        tracking_fields: {
          description: 'Tracking fields';
          items: {
            properties: {
              field: {
                description: 'Label of the tracking field.';
                type: 'string';
              };
              value: {
                description: 'Value for the field.';
                type: 'string';
              };
              visible: {
                description: 'Indicates whether the [tracking field](https://support.zoom.us/hc/en-us/articles/115000293426-Scheduling-Tracking-Fields) is visible in the meeting scheduling options in the Zoom Web Portal or not.\n\n`true`: Tracking field is visible. <br>\n\n`false`: Tracking field is not visible to the users in the meeting options in the Zoom Web Portal but the field was used while scheduling this meeting via API. An invisible tracking field can be used by users while scheduling meetings via API only. ';
                type: 'boolean';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        type: {
          default: 2;
          description: 'Meeting Type';
          enum: [1, 2, 3, 8];
          type: 'integer';
          'x-enum-descriptions': [
            'Instant Meeting',
            'Scheduled Meeting',
            'Recurring Meeting with no fixed time',
            'Recurring Meeting with fixed time',
          ];
        };
      };
      type: 'object';
    };
    MeetingInfoGet: {
      description: 'Meeting object.';
      properties: {
        agenda: {
          description: 'Meeting description';
          maxLength: 2000;
          type: 'string';
        };
        created_at: {
          description: 'Time of creation. ';
          format: 'date-time';
          type: 'string';
        };
        duration: {
          description: 'Meeting duration.';
          type: 'integer';
        };
        encrypted_password: {
          description: 'Encrypted passcode for third party endpoints (H323/SIP).';
          type: 'string';
        };
        h323_password: {
          description: 'H.323/SIP room system passcode.';
          type: 'string';
        };
        join_url: {
          description: 'URL for participants to join the meeting. This URL should only be shared with users that you would like to invite for the meeting.';
          type: 'string';
        };
        occurrences: {
          description: 'Array of occurrence objects.';
          items: {
            description: 'Occurence object. This object is only returned for Recurring Webinars.';
            properties: {
              duration: {
                description: 'Duration.';
                type: 'integer';
              };
              occurrence_id: {
                description: 'Occurrence ID: Unique Identifier that identifies an occurrence of a recurring webinar. [Recurring webinars](https://support.zoom.us/hc/en-us/articles/216354763-How-to-Schedule-A-Recurring-Webinar) can have a maximum of 50 occurrences.';
                type: 'string';
              };
              start_time: {
                description: 'Start time.';
                format: 'date-time';
                type: 'string';
              };
              status: {
                description: 'Occurrence status.';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        password: {
          description: 'Meeting passcode.';
          minimum: 8;
          type: 'string';
        };
        pmi: {
          description: 'Personal Meeting Id. Only used for scheduled meetings and recurring meetings with no fixed time.';
          format: 'int64';
          type: 'integer';
        };
        recurrence: {
          description: 'Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time. ';
          properties: {
            end_date_time: {
              description: 'Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
              format: 'date-time';
              type: 'string';
            };
            end_times: {
              default: 1;
              description: 'Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)';
              maximum: 365;
              type: 'integer';
            };
            monthly_day: {
              default: 1;
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
              type: 'integer';
            };
            monthly_week: {
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
              enum: [-1, 1, 2, 3, 4];
              type: 'integer';
              'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
            };
            monthly_week_day: {
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field. \n\n<br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
              enum: [1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
            };
            repeat_interval: {
              description: 'Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.\n\n';
              type: 'integer';
            };
            type: {
              description: 'Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
            };
            weekly_days: {
              default: '1';
              description: 'This field is required **if you\'re scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.';
              enum: ['1', '2', '3', '4', '5', '6', '7'];
              type: 'string';
            };
          };
          required: ['type'];
          type: 'object';
        };
        settings: {
          description: 'Meeting settings.';
          properties: {
            allow_multiple_devices: {
              description: 'Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
              type: 'boolean';
            };
            alternative_hosts: {
              description: "Alternative host's emails or IDs: multiple values are separated by a semicolon.";
              type: 'string';
            };
            alternative_hosts_email_notification: {
              default: true;
              description: 'Flag to determine whether to send email notifications to alternative hosts, default value is true.';
              type: 'boolean';
            };
            approval_type: {
              default: 2;
              description: 'Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>\n\n`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
              enum: [0, 1, 2];
              type: 'integer';
              'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
            };
            approved_or_denied_countries_or_regions: {
              description: 'Approve or block users from specific regions/countries from joining this meeting. \n';
              properties: {
                approved_list: {
                  description: 'List of countries/regions from where participants can join this meeting. ';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                denied_list: {
                  description: 'List of countries/regions from where participants can not join this meeting. ';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                enable: {
                  description: '`true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>\n\n`false`: Setting disabled.';
                  type: 'boolean';
                };
                method: {
                  description: 'Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>\n`approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>\n`deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`';
                  enum: ['approve', 'deny'];
                  type: 'string';
                };
              };
              type: 'object';
            };
            audio: {
              default: 'both';
              description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.';
              enum: ['both', 'telephony', 'voip'];
              type: 'string';
              'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
            };
            authentication_domains: {
              description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
              type: 'string';
            };
            authentication_exception: {
              description: 'The participants added here will receive unique meeting invite links and bypass authentication.';
              items: {
                properties: {
                  email: {
                    description: 'Email address of the participant.';
                    format: 'email';
                    type: 'string';
                  };
                  name: {
                    description: 'Name of the participant.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            authentication_name: {
              description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
              type: 'string';
            };
            authentication_option: {
              description: 'Meeting authentication option id.';
              type: 'string';
            };
            auto_recording: {
              default: 'none';
              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
              enum: ['local', 'cloud', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
            };
            breakout_room: {
              description: 'Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).';
              properties: {
                enable: {
                  description: 'Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.';
                  type: 'boolean';
                };
                rooms: {
                  description: 'Create room(s).';
                  items: {
                    properties: {
                      name: {
                        description: 'Name of the breakout room.';
                        type: 'string';
                      };
                      participants: {
                        description: 'Email addresses of the participants who are to be assigned to the breakout room.';
                        items: {
                          type: 'string';
                        };
                        type: 'array';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            close_registration: {
              default: false;
              description: 'Close registration after event date';
              type: 'boolean';
            };
            cn_meeting: {
              default: false;
              description: 'Host meeting in China.';
              type: 'boolean';
            };
            contact_email: {
              description: 'Contact email for registration';
              type: 'string';
            };
            contact_name: {
              description: 'Contact name for registration';
              type: 'string';
            };
            custom_keys: {
              description: 'Custom keys and values assigned to the meeting.';
              items: {
                properties: {
                  key: {
                    description: 'Custom key associated with the user.';
                    maxLength: 64;
                    type: 'string';
                  };
                  value: {
                    description: 'Value of the custom key associated with the user.';
                    maxLength: 256;
                    type: 'string';
                  };
                };
                type: 'object';
              };
              maxItems: 10;
              type: 'array';
            };
            encryption_type: {
              description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
              enum: ['enhanced_encryption', 'e2ee'];
              type: 'string';
            };
            enforce_login: {
              description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
              type: 'boolean';
            };
            enforce_login_domains: {
              description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
              type: 'string';
            };
            global_dial_in_countries: {
              description: 'List of global dial-in countries';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            global_dial_in_numbers: {
              description: 'Global Dial-in Countries/Regions';
              items: {
                properties: {
                  city: {
                    description: 'City of the number, if any. For example, Chicago.';
                    type: 'string';
                  };
                  country: {
                    description: 'Country code. For example, BR.';
                    type: 'string';
                  };
                  country_name: {
                    description: 'Full name of country. For example, Brazil.';
                    type: 'string';
                  };
                  number: {
                    description: 'Phone number. For example, +1 2332357613.';
                    type: 'string';
                  };
                  type: {
                    description: 'Type of number. ';
                    enum: ['toll', 'tollfree'];
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            host_video: {
              description: 'Start video when the host joins the meeting.';
              type: 'boolean';
            };
            in_meeting: {
              default: false;
              description: 'Host meeting in India.';
              type: 'boolean';
            };
            jbh_time: {
              description: 'If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:\n\n*  `0`: Allow participant to join anytime.\n*  `5`: Allow participant to join 5 minutes before meeting start time.\n * `10`: Allow participant to join 10 minutes before meeting start time.';
              enum: [0, 5, 10];
              type: 'integer';
            };
            join_before_host: {
              default: false;
              description: 'Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.';
              type: 'boolean';
            };
            language_interpretation: {
              properties: {
                enable: {
                  type: 'boolean';
                };
                interpreters: {
                  description: 'Information associated with the interpreter.';
                  items: {
                    properties: {
                      email: {
                        description: 'Email address of the interpreter.';
                        format: 'email';
                        type: 'string';
                      };
                      languages: {
                        description: 'Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma. \n\nFor example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            meeting_authentication: {
              description: '`true`- Only authenticated users can join meetings.';
              type: 'boolean';
            };
            mute_upon_entry: {
              default: false;
              description: 'Mute participants upon entry.';
              type: 'boolean';
            };
            participant_video: {
              description: 'Start video when participants join the meeting.';
              type: 'boolean';
            };
            registrants_confirmation_email: {
              description: 'Send confirmation email to registrants upon successful registration.';
              type: 'boolean';
            };
            registrants_email_notification: {
              description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
              type: 'boolean';
            };
            registration_type: {
              default: 1;
              description: 'Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': [
                'Attendees register once and can attend any of the occurrences',
                'Attendees need to register for each occurrence to attend',
                'Attendees register once and can choose one or more occurrences to attend',
              ];
            };
            show_share_button: {
              description: 'Show social share buttons on the meeting registration page.\nThis setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
              type: 'boolean';
            };
            use_pmi: {
              default: false;
              description: 'Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.';
              type: 'boolean';
            };
            waiting_room: {
              default: false;
              description: 'Enable waiting room';
              type: 'boolean';
            };
            watermark: {
              default: false;
              description: 'Add watermark when viewing a shared screen.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        start_time: {
          description: 'Meeting start time in GMT/UTC. Start time will not be returned if the meeting is an **instant** meeting. \n';
          format: 'date-time';
          type: 'string';
        };
        start_url: {
          description: '<br><aside>The <code>start_url</code> of a Meeting is a URL using which a host or an alternative host can start the Meeting. \n\nThe expiration time for the <code>start_url</code> field listed in the response of [Create a Meeting API](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meetingcreate) is two hours for all regular users. \n\t\nFor users created using the <code>custCreate</code> option via the [Create Users](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usercreate) API, the expiration time of the <code>start_url</code> field is 90 days.\n\t\nFor security reasons, to retrieve the updated value for the <code>start_url</code> field programmatically (after the expiry time), you must call the [Retrieve a Meeting API](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meeting) and refer to the value of the <code>start_url</code> field in the response.</aside><br>This URL should only be used by the host of the meeting and **should not be shared with anyone other than the host** of the meeting as anyone with this URL will be able to login to the Zoom Client as the host of the meeting.';
          type: 'string';
        };
        status: {
          description: 'Meeting status';
          enum: ['waiting', 'started'];
          type: 'string';
        };
        timezone: {
          description: 'Timezone to format the meeting start time on the .';
          type: 'string';
        };
        topic: {
          description: 'Meeting topic.';
          type: 'string';
        };
        tracking_fields: {
          description: 'Tracking fields';
          items: {
            properties: {
              field: {
                description: 'Label of the tracking field.';
                type: 'string';
              };
              value: {
                description: 'Value for the field.';
                type: 'string';
              };
              visible: {
                description: 'Indicates whether the [tracking field](https://support.zoom.us/hc/en-us/articles/115000293426-Scheduling-Tracking-Fields) is visible in the meeting scheduling options in the Zoom Web Portal or not.\n\n`true`: Tracking field is visible. <br>\n\n`false`: Tracking field is not visible to the users when they look at the meeting details in the Zoom Web Portal but the field was used while scheduling this meeting via API. An invisible tracking field can be used by users while scheduling meetings via API only. ';
                type: 'boolean';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        type: {
          default: 2;
          description: 'Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`4` - PMI Meeting<br>\n`8` - Recurring meeting with a fixed time.';
          enum: [1, 2, 3, 8];
          type: 'integer';
          'x-enum-descriptions': [
            'Instant Meeting',
            'Scheduled Meeting',
            'Recurring Meeting with no fixed time',
            'Recurring Meeting with fixed time',
          ];
        };
      };
      type: 'object';
    };
    MeetingInstances: {
      allOf: [
        {
          properties: {
            meetings: {
              description: 'List of ended meeting instances.';
              items: {
                allOf: [
                  {
                    properties: {
                      start_time: {
                        description: 'Start time';
                        format: 'date-time';
                        type: 'string';
                      };
                      uuid: {
                        description: "Meeting UUID. Unique meeting ID. Each meeting instance will generate its own Meeting UUID (i.e., after a meeting ends, a new UUID will be generated for the next instance of the meeting). Please double encode your UUID when using it for API calls if the UUID begins with a '/'or contains '//' in it.\n\n";
                        type: 'string';
                      };
                    };
                  },
                ];
                type: 'object';
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'List of Meetings';
      title: 'Meeting instances';
      type: 'object';
    };
    MeetingInvitation: {
      description: 'Meeting invitation details.';
      properties: {
        invitation: {
          description: 'Meeting invitation.';
          type: 'string';
        };
      };
      title: 'Meeting Invitation';
      type: 'object';
    };
    MeetingList: {
      allOf: [
        {
          description: 'Pagination Object.';
          properties: {
            next_page_token: {
              description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
              type: 'string';
            };
            page_count: {
              description: 'The number of pages returned for the request made.';
              type: 'integer';
            };
            page_number: {
              default: 1;
              description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
              type: 'integer';
            };
            page_size: {
              default: 30;
              description: 'The number of records returned with a single API call.';
              maximum: 300;
              type: 'integer';
            };
            total_records: {
              description: 'The total number of all the records available across pages.';
              type: 'integer';
            };
          };
          type: 'object';
        },
        {
          properties: {
            meetings: {
              description: 'List of Meeting objects.';
              items: {
                allOf: [
                  {
                    properties: {
                      agenda: {
                        description: 'Meeting description. The length of agenda gets truncated to 250 characters when you list all meetings for a user. To view the complete agenda of a meeting, retrieve details for a single meeting [here](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meeting).';
                        type: 'string';
                      };
                      created_at: {
                        description: 'Time of creation. ';
                        format: 'date-time';
                        type: 'string';
                      };
                      duration: {
                        description: 'Meeting duration.';
                        type: 'integer';
                      };
                      host_id: {
                        description: 'ID of the user who is set as the host of the meeting.';
                        type: 'string';
                      };
                      id: {
                        description: 'Meeting ID - also known as the meeting number in double (int64) format.';
                        format: 'int64';
                        type: 'integer';
                      };
                      join_url: {
                        description: 'Join URL.';
                        type: 'string';
                      };
                      start_time: {
                        description: 'Meeting start time.';
                        format: 'date-time';
                        type: 'string';
                      };
                      timezone: {
                        description: 'Timezone to format the meeting start time. ';
                        type: 'string';
                      };
                      topic: {
                        description: 'Meeting topic.';
                        type: 'string';
                      };
                      type: {
                        description: 'Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.';
                        enum: [1, 2, 3, 8];
                        type: 'integer';
                        'x-enum-descriptions': [
                          'Instant Meeting',
                          'Scheduled Meeting',
                          'Recurring Meeting with no fixed time',
                          'Recurring Meeting with fixed time',
                        ];
                      };
                      uuid: {
                        description: 'Unique Meeting ID. Each meeting instance will generate its own Meeting UUID.';
                        type: 'string';
                      };
                    };
                  },
                ];
                type: 'object';
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'List of meetings.';
      title: 'Group List';
      type: 'object';
    };
    MeetingLiveStream: {
      description: 'Meeting live stream.';
      properties: {
        page_url: {
          description: 'The livestream page URL.';
          format: 'uri';
          maxLength: 1024;
          type: 'string';
        };
        stream_key: {
          description: 'Stream name and key.';
          maxLength: 512;
          type: 'string';
        };
        stream_url: {
          description: 'Streaming URL.';
          maxLength: 1024;
          type: 'string';
        };
      };
      required: ['stream_url', 'stream_key'];
      type: 'object';
    };
    MeetingLiveStreamStatus: {
      description: 'Meeting live stream status.';
      properties: {
        action: {
          description: 'Update the status of a livestream.\n\nThe value can be one of the following:<br>\n`start`: Start a live stream. <br>\n`stop`: Stop an ongoing live stream.';
          enum: ['start', 'stop'];
          type: 'string';
          'x-enum-descriptions': ['Start a meeting live stream.', 'Stop a meeting live stream.'];
        };
        settings: {
          description: 'Update the settings of a live streaming session. The settings can only be updated for a live stream that has been stopped. You can not update the settings of an ongoing live stream.';
          properties: {
            active_speaker_name: {
              description: 'Display the name of the active speaker during a live stream.';
              type: 'boolean';
            };
            display_name: {
              description: 'Display name of the live stream.';
              maxLength: 50;
              minLength: 1;
              type: 'string';
            };
          };
          type: 'object';
        };
      };
      type: 'object';
    };
    MeetingMetric: {
      description: 'Meeting metric details.';
      properties: {
        custom_keys: {
          description: 'Custom keys and values assigned to the meeting.';
          items: {
            properties: {
              key: {
                description: 'Custom key associated with the meetinh.';
                maxLength: 64;
                type: 'string';
              };
              value: {
                description: 'Value of the custom key associated with the meeting.';
                maxLength: 256;
                type: 'string';
              };
            };
            type: 'object';
          };
          maxItems: 10;
          type: 'array';
        };
        dept: {
          description: 'Department of the host.';
          type: 'string';
        };
        duration: {
          description: 'Meeting duration.';
          type: 'string';
        };
        email: {
          description: 'Email address of the host.';
          type: 'string';
        };
        end_time: {
          description: 'Meeting end time.';
          format: 'date-time';
          type: 'string';
        };
        has_3rd_party_audio: {
          description: 'Indicates whether or not [third party audio](https://support.zoom.us/hc/en-us/articles/202470795-3rd-Party-Audio-Conference) was used in the meeting.';
          type: 'boolean';
        };
        has_pstn: {
          description: 'Indicates whether or not the PSTN was used in the meeting.';
          type: 'boolean';
        };
        has_recording: {
          description: 'Indicates whether or not the recording feature was used in the meeting. ';
          type: 'boolean';
        };
        has_screen_share: {
          description: 'Indicates whether or not screenshare feature was used in the meeting.';
          type: 'boolean';
        };
        has_sip: {
          description: 'Indicates whether or not someone joined the meeting using SIP.';
          type: 'boolean';
        };
        has_video: {
          description: 'Indicates whether or not video was used in the meeting.';
          type: 'boolean';
        };
        has_voip: {
          description: 'Indicates whether or not VoIP was used in the meeting.';
          type: 'boolean';
        };
        host: {
          description: 'Host display name.';
          type: 'string';
        };
        id: {
          description: '[Meeting ID](https://support.zoom.us/hc/en-us/articles/201362373-What-is-a-Meeting-ID-): Unique identifier of the meeting in "**long**" format(represented as int64 data type in JSON), also known as the meeting number.';
          format: 'int64';
          type: 'integer';
        };
        in_room_participants: {
          description: 'The number of Zoom Room participants in the meeting.';
          type: 'integer';
        };
        participants: {
          description: 'Meeting participant count.';
          type: 'integer';
        };
        start_time: {
          description: 'Meeting start time.';
          format: 'date-time';
          type: 'string';
        };
        topic: {
          description: 'Meeting topic.';
          type: 'string';
        };
        user_type: {
          description: 'License type of the user.';
          type: 'string';
        };
        uuid: {
          description: "Meeting UUID. Please double encode your UUID when using it for API calls if the UUID begins with a '/'or contains '//' in it.";
          format: 'uuid';
          type: 'string';
        };
      };
      title: 'Meeting Metrics';
      type: 'object';
    };
    MeetingRecordingRegistrantList: {
      allOf: [
        {
          allOf: [
            {
              description: 'Pagination Object.';
              properties: {
                next_page_token: {
                  description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                  type: 'string';
                };
                page_count: {
                  description: 'The number of pages returned for the request made.';
                  type: 'integer';
                };
                page_number: {
                  default: 1;
                  description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
                  type: 'integer';
                };
                page_size: {
                  default: 30;
                  description: 'The number of records returned with a single API call.';
                  maximum: 300;
                  type: 'integer';
                };
                total_records: {
                  description: 'The total number of all the records available across pages.';
                  type: 'integer';
                };
              };
              type: 'object';
            },
            {
              properties: {
                registrants: {
                  description: 'List of Registrant objects';
                  items: {
                    allOf: [
                      {
                        properties: {
                          id: {
                            type: 'string';
                          };
                        };
                      },
                      {
                        allOf: [
                          {
                            description: 'Registrant base object.';
                            properties: {
                              address: {
                                description: "Registrant's address.";
                                type: 'string';
                              };
                              city: {
                                description: "Registrant's city.";
                                type: 'string';
                              };
                              comments: {
                                description: 'A field that allows registrants to provide any questions or comments that they might have.';
                                type: 'string';
                              };
                              country: {
                                description: "Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.";
                                type: 'string';
                              };
                              custom_questions: {
                                description: 'Custom questions.';
                                items: {
                                  description: 'Custom Question.';
                                  properties: {
                                    title: {
                                      type: 'string';
                                    };
                                    value: {
                                      type: 'string';
                                    };
                                  };
                                  type: 'object';
                                };
                                type: 'array';
                              };
                              email: {
                                description: 'A valid email address of the registrant.';
                                maxLength: 128;
                                type: 'string';
                              };
                              first_name: {
                                description: "Registrant's first name.";
                                maxLength: 64;
                                type: 'string';
                              };
                              industry: {
                                description: "Registrant's Industry.";
                                type: 'string';
                              };
                              job_title: {
                                description: "Registrant's job title.";
                                type: 'string';
                              };
                              last_name: {
                                description: "Registrant's last name.";
                                maxLength: 64;
                                type: 'string';
                              };
                              no_of_employees: {
                                description: 'Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`';
                                type: 'string';
                              };
                              org: {
                                description: "Registrant's Organization.";
                                type: 'string';
                              };
                              phone: {
                                description: "Registrant's Phone number.";
                                type: 'string';
                              };
                              purchasing_time_frame: {
                                description: 'This field can be included to gauge interest of webinar attendees towards buying your product or service.\n\nPurchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`';
                                type: 'string';
                              };
                              role_in_purchase_process: {
                                description: 'Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved` ';
                                type: 'string';
                              };
                              state: {
                                description: "Registrant's State/Province.";
                                type: 'string';
                              };
                              zip: {
                                description: "Registrant's Zip/Postal Code.";
                                type: 'string';
                              };
                            };
                            required: ['email', 'first_name'];
                            type: 'object';
                          },
                        ];
                        description: ' Registrant.';
                        type: 'object';
                      },
                    ];
                  };
                  type: 'array';
                };
              };
            },
          ];
          description: 'List of Recording Registration';
          title: 'Recording Registration List';
          type: 'object';
        },
      ];
      description: 'List of meeting recording registrant';
      title: 'Registration List';
      type: 'object';
    };
    MeetingRegistrant: {
      allOf: [
        {
          description: 'Registrant base object.';
          properties: {
            address: {
              description: "Registrant's address.";
              type: 'string';
            };
            city: {
              description: "Registrant's city.";
              type: 'string';
            };
            comments: {
              description: 'A field that allows registrants to provide any questions or comments that they might have.';
              type: 'string';
            };
            country: {
              description: "Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.";
              type: 'string';
            };
            custom_questions: {
              description: 'Custom questions.';
              items: {
                description: 'Custom Question.';
                properties: {
                  title: {
                    type: 'string';
                  };
                  value: {
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            email: {
              description: 'A valid email address of the registrant.';
              maxLength: 128;
              type: 'string';
            };
            first_name: {
              description: "Registrant's first name.";
              maxLength: 64;
              type: 'string';
            };
            industry: {
              description: "Registrant's Industry.";
              type: 'string';
            };
            job_title: {
              description: "Registrant's job title.";
              type: 'string';
            };
            last_name: {
              description: "Registrant's last name.";
              maxLength: 64;
              type: 'string';
            };
            no_of_employees: {
              description: 'Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`';
              type: 'string';
            };
            org: {
              description: "Registrant's Organization.";
              type: 'string';
            };
            phone: {
              description: "Registrant's Phone number.";
              type: 'string';
            };
            purchasing_time_frame: {
              description: 'This field can be included to gauge interest of webinar attendees towards buying your product or service.\n\nPurchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`';
              type: 'string';
            };
            role_in_purchase_process: {
              description: 'Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved` ';
              type: 'string';
            };
            state: {
              description: "Registrant's State/Province.";
              type: 'string';
            };
            zip: {
              description: "Registrant's Zip/Postal Code.";
              type: 'string';
            };
          };
          required: ['email', 'first_name'];
          type: 'object';
        },
      ];
      description: ' Registrant.';
      type: 'object';
    };
    MeetingRegistrantList: {
      allOf: [
        {
          allOf: [
            {
              description: 'Pagination Object.';
              properties: {
                next_page_token: {
                  description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                  type: 'string';
                };
                page_count: {
                  description: 'The number of pages returned for the request made.';
                  type: 'integer';
                };
                page_number: {
                  default: 1;
                  description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
                  type: 'integer';
                };
                page_size: {
                  default: 30;
                  description: 'The number of records returned with a single API call.';
                  maximum: 300;
                  type: 'integer';
                };
                total_records: {
                  description: 'The total number of all the records available across pages.';
                  type: 'integer';
                };
              };
              type: 'object';
            },
            {
              properties: {
                registrants: {
                  description: 'List of registrant objects.';
                  items: {
                    allOf: [
                      {
                        properties: {
                          id: {
                            description: 'Registrant ID.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      },
                      {
                        allOf: [
                          {
                            description: 'Registrant base object.';
                            properties: {
                              address: {
                                description: "Registrant's address.";
                                type: 'string';
                              };
                              city: {
                                description: "Registrant's city.";
                                type: 'string';
                              };
                              comments: {
                                description: 'A field that allows registrants to provide any questions or comments that they might have.';
                                type: 'string';
                              };
                              country: {
                                description: "Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.";
                                type: 'string';
                              };
                              custom_questions: {
                                description: 'Custom questions.';
                                items: {
                                  description: 'Custom Question.';
                                  properties: {
                                    title: {
                                      type: 'string';
                                    };
                                    value: {
                                      type: 'string';
                                    };
                                  };
                                  type: 'object';
                                };
                                type: 'array';
                              };
                              email: {
                                description: 'A valid email address of the registrant.';
                                maxLength: 128;
                                type: 'string';
                              };
                              first_name: {
                                description: "Registrant's first name.";
                                maxLength: 64;
                                type: 'string';
                              };
                              industry: {
                                description: "Registrant's Industry.";
                                type: 'string';
                              };
                              job_title: {
                                description: "Registrant's job title.";
                                type: 'string';
                              };
                              last_name: {
                                description: "Registrant's last name.";
                                maxLength: 64;
                                type: 'string';
                              };
                              no_of_employees: {
                                description: 'Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`';
                                type: 'string';
                              };
                              org: {
                                description: "Registrant's Organization.";
                                type: 'string';
                              };
                              phone: {
                                description: "Registrant's Phone number.";
                                type: 'string';
                              };
                              purchasing_time_frame: {
                                description: 'This field can be included to gauge interest of webinar attendees towards buying your product or service.\n\nPurchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`';
                                type: 'string';
                              };
                              role_in_purchase_process: {
                                description: 'Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved` ';
                                type: 'string';
                              };
                              state: {
                                description: "Registrant's State/Province.";
                                type: 'string';
                              };
                              zip: {
                                description: "Registrant's Zip/Postal Code.";
                                type: 'string';
                              };
                            };
                            required: ['email', 'first_name'];
                            type: 'object';
                          },
                        ];
                        description: ' Registrant.';
                        type: 'object';
                      },
                      {
                        properties: {
                          create_time: {
                            description: 'The time at which the registrant registered.';
                            format: 'date-time';
                            type: 'string';
                          };
                          join_url: {
                            description: 'The URL using which an approved registrant can join the webinar.';
                            format: 'string';
                            type: 'string';
                          };
                          status: {
                            description: "The status of the registrant's registration. <br> `approved`: User has been successfully approved for the webinar.<br> `pending`:  The registration is still pending.<br> `denied`: User has been denied from joining the webinar.";
                            type: 'string';
                          };
                        };
                        type: 'object';
                      },
                    ];
                  };
                  type: 'array';
                };
              };
            },
          ];
          description: 'List of users.';
          title: 'Registration List';
          type: 'object';
        },
      ];
      description: 'List of users.';
      title: 'Registration List';
      type: 'object';
    };
    MeetingRegistrantQuestions: {
      description: 'Meeting Registrant Questions';
      properties: {
        custom_questions: {
          description: 'Array of Registrant Custom Questions';
          items: {
            properties: {
              answers: {
                description: 'Answer choices for the question. Can not be used for `short` question type as this type of question requires registrants to type out the answer.';
                items: {
                  type: 'string';
                };
                type: 'array';
              };
              required: {
                description: 'Indicates whether or not the custom question is required to be answered by participants or not.';
                type: 'boolean';
              };
              title: {
                description: 'Title of the custom question.';
                type: 'string';
              };
              type: {
                description: 'Type of the question being asked.';
                enum: ['short', 'single'];
                type: 'string';
                'x-enum-descriptions': ['Short Answer', 'Single Answer'];
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        questions: {
          description: 'Array of Registrant Questions';
          items: {
            properties: {
              field_name: {
                description: 'Field name of the question.';
                enum: [
                  'address',
                  'city',
                  'country',
                  'zip',
                  'state',
                  'phone',
                  'industry',
                  'org',
                  'job_title',
                  'purchasing_time_frame',
                  'role_in_purchase_process',
                  'no_of_employees',
                  'comments',
                ];
                type: 'string';
                'x-enum-descriptions': [
                  'Address',
                  'City',
                  'Country/Region',
                  'Zip/Postal Code',
                  'State/Province',
                  'Phone',
                  'Industry',
                  'Organization',
                  'Job Title',
                  'Purchasing Time Frame',
                  'Role in Purchase Process',
                  'Number of Employees',
                  'Questions & Comments',
                ];
              };
              required: {
                description: 'Indicates whether or not the displayed fields are required to be filled out by registrants.';
                type: 'boolean';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
      };
      title: 'Meeting Registrant Questions';
      type: 'object';
    };
    MeetingSecuritySettings: {
      properties: {
        meeting_security: {
          properties: {
            auto_security: {
              description: '`true`: Require that all meetings are secured with at least one security option.\n\nThis setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).';
              type: 'boolean';
            };
            embed_password_in_join_link: {
              description: 'If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.\n';
              type: 'boolean';
            };
            encryption_type: {
              description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
              enum: ['enhanced_encryption', 'e2ee'];
              type: 'string';
            };
            end_to_end_encrypted_meetings: {
              description: 'Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.';
              type: 'boolean';
            };
            meeting_password: {
              description: 'If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.';
              type: 'boolean';
            };
            meeting_password_requirement: {
              description: 'Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
              properties: {
                consecutive_characters_length: {
                  enum: [0, 4, 5, 6, 7, 8];
                  type: 'integer';
                };
                have_letter: {
                  description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                  type: 'boolean';
                };
                have_number: {
                  description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                  type: 'boolean';
                };
                have_special_character: {
                  description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                  type: 'boolean';
                };
                have_upper_and_lower_characters: {
                  description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                  type: 'boolean';
                };
                length: {
                  description: 'The minimum length that the meeting/webinar passcode needs to have.';
                  type: 'integer';
                };
                only_allow_numeric: {
                  description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                  type: 'boolean';
                };
                weak_enhance_detection: {
                  description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            phone_password: {
              description: 'Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.';
              type: 'boolean';
            };
            pmi_password: {
              description: 'If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.\n';
              type: 'boolean';
            };
            require_password_for_scheduled_meeting: {
              description: 'Require a passcode for meetings which have already been scheduled.\n';
              type: 'boolean';
            };
            require_password_for_scheduled_webinar: {
              description: 'Require a passcode for webinars which have already been scheduled.\n';
              type: 'boolean';
            };
            waiting_room: {
              description: 'When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.\n';
              type: 'boolean';
            };
            waiting_room_settings: {
              description: 'Specify the settings to be applied if waiting room is enabled.';
              properties: {
                participants_to_place_in_waiting_room: {
                  description: '\n\nSpecify who should be admitted to the waiting room. The value of this field can be one of the following:<br>\n`0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in ';
                  enum: [0, 1, 2];
                  type: 'integer';
                };
                users_who_can_admit_participants_from_waiting_room: {
                  description: 'Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>\n`0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).\n\n\n';
                  type: 'integer';
                };
                whitelisted_domains_for_waiting_room: {
                  description: 'If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").';
                  type: 'string';
                };
              };
              type: 'object';
            };
            webinar_password: {
              description: 'If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.\n';
              type: 'boolean';
            };
          };
          type: 'object';
        };
      };
      title: 'Meeting/Webinar Security Settings';
      type: 'object';
    };
    MeetingSettings: {
      description: 'Meeting settings.';
      properties: {
        allow_multiple_devices: {
          description: 'Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
          type: 'boolean';
        };
        alternative_hosts: {
          description: "Alternative host's emails or IDs: multiple values are separated by a semicolon.";
          type: 'string';
        };
        alternative_hosts_email_notification: {
          default: true;
          description: 'Flag to determine whether to send email notifications to alternative hosts, default value is true.';
          type: 'boolean';
        };
        approval_type: {
          default: 2;
          description: 'Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>\n\n`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
          enum: [0, 1, 2];
          type: 'integer';
          'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
        };
        approved_or_denied_countries_or_regions: {
          description: 'Approve or block users from specific regions/countries from joining this meeting. \n';
          properties: {
            approved_list: {
              description: 'List of countries/regions from where participants can join this meeting. ';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            denied_list: {
              description: 'List of countries/regions from where participants can not join this meeting. ';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            enable: {
              description: '`true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>\n\n`false`: Setting disabled.';
              type: 'boolean';
            };
            method: {
              description: 'Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>\n`approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>\n`deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`';
              enum: ['approve', 'deny'];
              type: 'string';
            };
          };
          type: 'object';
        };
        audio: {
          default: 'both';
          description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.';
          enum: ['both', 'telephony', 'voip'];
          type: 'string';
          'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
        };
        authentication_domains: {
          description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
          type: 'string';
        };
        authentication_exception: {
          description: 'The participants added here will receive unique meeting invite links and bypass authentication.';
          items: {
            properties: {
              email: {
                description: 'Email address of the participant.';
                format: 'email';
                type: 'string';
              };
              name: {
                description: 'Name of the participant.';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        authentication_name: {
          description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
          type: 'string';
        };
        authentication_option: {
          description: 'Meeting authentication option id.';
          type: 'string';
        };
        auto_recording: {
          default: 'none';
          description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
          enum: ['local', 'cloud', 'none'];
          type: 'string';
          'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
        };
        breakout_room: {
          description: 'Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).';
          properties: {
            enable: {
              description: 'Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.';
              type: 'boolean';
            };
            rooms: {
              description: 'Create room(s).';
              items: {
                properties: {
                  name: {
                    description: 'Name of the breakout room.';
                    type: 'string';
                  };
                  participants: {
                    description: 'Email addresses of the participants who are to be assigned to the breakout room.';
                    items: {
                      type: 'string';
                    };
                    type: 'array';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
          };
          type: 'object';
        };
        close_registration: {
          default: false;
          description: 'Close registration after event date';
          type: 'boolean';
        };
        cn_meeting: {
          default: false;
          description: 'Host meeting in China.';
          type: 'boolean';
        };
        contact_email: {
          description: 'Contact email for registration';
          type: 'string';
        };
        contact_name: {
          description: 'Contact name for registration';
          type: 'string';
        };
        custom_keys: {
          description: 'Custom keys and values assigned to the meeting.';
          items: {
            properties: {
              key: {
                description: 'Custom key associated with the user.';
                maxLength: 64;
                type: 'string';
              };
              value: {
                description: 'Value of the custom key associated with the user.';
                maxLength: 256;
                type: 'string';
              };
            };
            type: 'object';
          };
          maxItems: 10;
          type: 'array';
        };
        encryption_type: {
          description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
          enum: ['enhanced_encryption', 'e2ee'];
          type: 'string';
        };
        enforce_login: {
          description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
          type: 'boolean';
        };
        enforce_login_domains: {
          description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
          type: 'string';
        };
        global_dial_in_countries: {
          description: 'List of global dial-in countries';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        global_dial_in_numbers: {
          description: 'Global Dial-in Countries/Regions';
          items: {
            properties: {
              city: {
                description: 'City of the number, if any. For example, Chicago.';
                type: 'string';
              };
              country: {
                description: 'Country code. For example, BR.';
                type: 'string';
              };
              country_name: {
                description: 'Full name of country. For example, Brazil.';
                type: 'string';
              };
              number: {
                description: 'Phone number. For example, +1 2332357613.';
                type: 'string';
              };
              type: {
                description: 'Type of number. ';
                enum: ['toll', 'tollfree'];
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        host_video: {
          description: 'Start video when the host joins the meeting.';
          type: 'boolean';
        };
        in_meeting: {
          default: false;
          description: 'Host meeting in India.';
          type: 'boolean';
        };
        jbh_time: {
          description: 'If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:\n\n*  `0`: Allow participant to join anytime.\n*  `5`: Allow participant to join 5 minutes before meeting start time.\n * `10`: Allow participant to join 10 minutes before meeting start time.';
          enum: [0, 5, 10];
          type: 'integer';
        };
        join_before_host: {
          default: false;
          description: 'Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.';
          type: 'boolean';
        };
        language_interpretation: {
          properties: {
            enable: {
              type: 'boolean';
            };
            interpreters: {
              description: 'Information associated with the interpreter.';
              items: {
                properties: {
                  email: {
                    description: 'Email address of the interpreter.';
                    format: 'email';
                    type: 'string';
                  };
                  languages: {
                    description: 'Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma. \n\nFor example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
          };
          type: 'object';
        };
        meeting_authentication: {
          description: '`true`- Only authenticated users can join meetings.';
          type: 'boolean';
        };
        mute_upon_entry: {
          default: false;
          description: 'Mute participants upon entry.';
          type: 'boolean';
        };
        participant_video: {
          description: 'Start video when participants join the meeting.';
          type: 'boolean';
        };
        registrants_confirmation_email: {
          description: 'Send confirmation email to registrants upon successful registration.';
          type: 'boolean';
        };
        registrants_email_notification: {
          description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
          type: 'boolean';
        };
        registration_type: {
          default: 1;
          description: 'Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.';
          enum: [1, 2, 3];
          type: 'integer';
          'x-enum-descriptions': [
            'Attendees register once and can attend any of the occurrences',
            'Attendees need to register for each occurrence to attend',
            'Attendees register once and can choose one or more occurrences to attend',
          ];
        };
        show_share_button: {
          description: 'Show social share buttons on the meeting registration page.\nThis setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
          type: 'boolean';
        };
        use_pmi: {
          default: false;
          description: 'Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.';
          type: 'boolean';
        };
        waiting_room: {
          default: false;
          description: 'Enable waiting room';
          type: 'boolean';
        };
        watermark: {
          default: false;
          description: 'Add watermark when viewing a shared screen.';
          type: 'boolean';
        };
      };
      type: 'object';
    };
    MeetingUpdate: {
      allOf: [
        {
          description: 'Base object for sessions.';
          properties: {
            agenda: {
              description: 'Meeting description.';
              maxLength: 2000;
              type: 'string';
            };
            duration: {
              description: 'Meeting duration (minutes). Used for scheduled meetings only.';
              type: 'integer';
            };
            password: {
              description: 'Meeting passcode. Passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ *] and can have a maximum of 10 characters.\n\n**Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the  [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API. ';
              maxLength: 10;
              type: 'string';
            };
            recurrence: {
              description: 'Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time. ';
              properties: {
                end_date_time: {
                  description: 'Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
                  format: 'date-time';
                  type: 'string';
                };
                end_times: {
                  default: 1;
                  description: 'Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)';
                  maximum: 365;
                  type: 'integer';
                };
                monthly_day: {
                  default: 1;
                  description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
                  type: 'integer';
                };
                monthly_week: {
                  description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
                  enum: [-1, 1, 2, 3, 4];
                  type: 'integer';
                  'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
                };
                monthly_week_day: {
                  description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field. \n\n<br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
                  enum: [1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
                };
                repeat_interval: {
                  description: 'Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.\n\n';
                  type: 'integer';
                };
                type: {
                  description: 'Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
                  enum: [1, 2, 3];
                  type: 'integer';
                  'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
                };
                weekly_days: {
                  default: '1';
                  description: 'This field is required **if you\'re scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.';
                  enum: ['1', '2', '3', '4', '5', '6', '7'];
                  type: 'string';
                };
              };
              required: ['type'];
              type: 'object';
            };
            settings: {
              allOf: [
                {
                  description: 'Meeting settings.';
                  properties: {
                    allow_multiple_devices: {
                      description: 'Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
                      type: 'boolean';
                    };
                    alternative_hosts: {
                      description: "Alternative host's emails or IDs: multiple values are separated by a semicolon.";
                      type: 'string';
                    };
                    alternative_hosts_email_notification: {
                      default: true;
                      description: 'Flag to determine whether to send email notifications to alternative hosts, default value is true.';
                      type: 'boolean';
                    };
                    approval_type: {
                      default: 2;
                      description: 'Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>\n\n`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
                      enum: [0, 1, 2];
                      type: 'integer';
                      'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
                    };
                    approved_or_denied_countries_or_regions: {
                      description: 'Approve or block users from specific regions/countries from joining this meeting. \n';
                      properties: {
                        approved_list: {
                          description: 'List of countries/regions from where participants can join this meeting. ';
                          items: {
                            type: 'string';
                          };
                          type: 'array';
                        };
                        denied_list: {
                          description: 'List of countries/regions from where participants can not join this meeting. ';
                          items: {
                            type: 'string';
                          };
                          type: 'array';
                        };
                        enable: {
                          description: '`true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>\n\n`false`: Setting disabled.';
                          type: 'boolean';
                        };
                        method: {
                          description: 'Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>\n`approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>\n`deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`';
                          enum: ['approve', 'deny'];
                          type: 'string';
                        };
                      };
                      type: 'object';
                    };
                    audio: {
                      default: 'both';
                      description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.';
                      enum: ['both', 'telephony', 'voip'];
                      type: 'string';
                      'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
                    };
                    authentication_domains: {
                      description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
                      type: 'string';
                    };
                    authentication_exception: {
                      description: 'The participants added here will receive unique meeting invite links and bypass authentication.';
                      items: {
                        properties: {
                          email: {
                            description: 'Email address of the participant.';
                            format: 'email';
                            type: 'string';
                          };
                          name: {
                            description: 'Name of the participant.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    authentication_name: {
                      description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
                      type: 'string';
                    };
                    authentication_option: {
                      description: 'Meeting authentication option id.';
                      type: 'string';
                    };
                    auto_recording: {
                      default: 'none';
                      description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
                      enum: ['local', 'cloud', 'none'];
                      type: 'string';
                      'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
                    };
                    breakout_room: {
                      description: 'Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).';
                      properties: {
                        enable: {
                          description: 'Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.';
                          type: 'boolean';
                        };
                        rooms: {
                          description: 'Create room(s).';
                          items: {
                            properties: {
                              name: {
                                description: 'Name of the breakout room.';
                                type: 'string';
                              };
                              participants: {
                                description: 'Email addresses of the participants who are to be assigned to the breakout room.';
                                items: {
                                  type: 'string';
                                };
                                type: 'array';
                              };
                            };
                            type: 'object';
                          };
                          type: 'array';
                        };
                      };
                      type: 'object';
                    };
                    close_registration: {
                      default: false;
                      description: 'Close registration after event date';
                      type: 'boolean';
                    };
                    cn_meeting: {
                      default: false;
                      description: 'Host meeting in China.';
                      type: 'boolean';
                    };
                    contact_email: {
                      description: 'Contact email for registration';
                      type: 'string';
                    };
                    contact_name: {
                      description: 'Contact name for registration';
                      type: 'string';
                    };
                    custom_keys: {
                      description: 'Custom keys and values assigned to the meeting.';
                      items: {
                        properties: {
                          key: {
                            description: 'Custom key associated with the user.';
                            maxLength: 64;
                            type: 'string';
                          };
                          value: {
                            description: 'Value of the custom key associated with the user.';
                            maxLength: 256;
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      maxItems: 10;
                      type: 'array';
                    };
                    encryption_type: {
                      description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                      enum: ['enhanced_encryption', 'e2ee'];
                      type: 'string';
                    };
                    enforce_login: {
                      description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
                      type: 'boolean';
                    };
                    enforce_login_domains: {
                      description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
                      type: 'string';
                    };
                    global_dial_in_countries: {
                      description: 'List of global dial-in countries';
                      items: {
                        type: 'string';
                      };
                      type: 'array';
                    };
                    global_dial_in_numbers: {
                      description: 'Global Dial-in Countries/Regions';
                      items: {
                        properties: {
                          city: {
                            description: 'City of the number, if any. For example, Chicago.';
                            type: 'string';
                          };
                          country: {
                            description: 'Country code. For example, BR.';
                            type: 'string';
                          };
                          country_name: {
                            description: 'Full name of country. For example, Brazil.';
                            type: 'string';
                          };
                          number: {
                            description: 'Phone number. For example, +1 2332357613.';
                            type: 'string';
                          };
                          type: {
                            description: 'Type of number. ';
                            enum: ['toll', 'tollfree'];
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                    host_video: {
                      description: 'Start video when the host joins the meeting.';
                      type: 'boolean';
                    };
                    in_meeting: {
                      default: false;
                      description: 'Host meeting in India.';
                      type: 'boolean';
                    };
                    jbh_time: {
                      description: 'If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:\n\n*  `0`: Allow participant to join anytime.\n*  `5`: Allow participant to join 5 minutes before meeting start time.\n * `10`: Allow participant to join 10 minutes before meeting start time.';
                      enum: [0, 5, 10];
                      type: 'integer';
                    };
                    join_before_host: {
                      default: false;
                      description: 'Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.';
                      type: 'boolean';
                    };
                    language_interpretation: {
                      properties: {
                        enable: {
                          type: 'boolean';
                        };
                        interpreters: {
                          description: 'Information associated with the interpreter.';
                          items: {
                            properties: {
                              email: {
                                description: 'Email address of the interpreter.';
                                format: 'email';
                                type: 'string';
                              };
                              languages: {
                                description: 'Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma. \n\nFor example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".';
                                type: 'string';
                              };
                            };
                            type: 'object';
                          };
                          type: 'array';
                        };
                      };
                      type: 'object';
                    };
                    meeting_authentication: {
                      description: '`true`- Only authenticated users can join meetings.';
                      type: 'boolean';
                    };
                    mute_upon_entry: {
                      default: false;
                      description: 'Mute participants upon entry.';
                      type: 'boolean';
                    };
                    participant_video: {
                      description: 'Start video when participants join the meeting.';
                      type: 'boolean';
                    };
                    registrants_confirmation_email: {
                      description: 'Send confirmation email to registrants upon successful registration.';
                      type: 'boolean';
                    };
                    registrants_email_notification: {
                      description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
                      type: 'boolean';
                    };
                    registration_type: {
                      default: 1;
                      description: 'Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.';
                      enum: [1, 2, 3];
                      type: 'integer';
                      'x-enum-descriptions': [
                        'Attendees register once and can attend any of the occurrences',
                        'Attendees need to register for each occurrence to attend',
                        'Attendees register once and can choose one or more occurrences to attend',
                      ];
                    };
                    show_share_button: {
                      description: 'Show social share buttons on the meeting registration page.\nThis setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
                      type: 'boolean';
                    };
                    use_pmi: {
                      default: false;
                      description: 'Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.';
                      type: 'boolean';
                    };
                    waiting_room: {
                      default: false;
                      description: 'Enable waiting room';
                      type: 'boolean';
                    };
                    watermark: {
                      default: false;
                      description: 'Add watermark when viewing a shared screen.';
                      type: 'boolean';
                    };
                  };
                  type: 'object';
                },
                {
                  properties: {
                    registrants_confirmation_email: {
                      description: 'Send confirmation Email to Registrants';
                      type: 'boolean';
                    };
                  };
                  type: 'object';
                },
              ];
            };
            start_time: {
              description: "Meeting start time. When using a format like \"yyyy-MM-dd'T'HH:mm:ss'Z'\", always use GMT time. When using a format like \"yyyy-MM-dd'T'HH:mm:ss\", you should use local time and  specify the time zone. Only used for scheduled meetings and recurring meetings with a fixed time.";
              format: 'date-time';
              type: 'string';
            };
            template_id: {
              description: 'Unique identifier of the meeting template. \n\nUse this field if you would like to [schedule the meeting from a meeting template](https://support.zoom.us/hc/en-us/articles/360036559151-Meeting-templates#h_86f06cff-0852-4998-81c5-c83663c176fb). You can retrieve the value of this field by calling the [List meeting templates]() API.';
              type: 'string';
            };
            timezone: {
              description: 'Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.';
              type: 'string';
            };
            topic: {
              description: 'Meeting topic.';
              type: 'string';
            };
            tracking_fields: {
              description: 'Tracking fields';
              items: {
                properties: {
                  field: {
                    description: 'Tracking fields type';
                    type: 'string';
                  };
                  value: {
                    description: 'Tracking fields value';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            type: {
              default: 2;
              description: 'Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with a fixed time.';
              enum: [1, 2, 3, 8];
              type: 'integer';
              'x-enum-descriptions': [
                'Instant Meeting',
                'Scheduled Meeting',
                'Recurring Meeting with no fixed time',
                'Recurring Meeting with fixed time',
              ];
            };
          };
          type: 'object';
        },
      ];
      description: 'Meeting object';
      type: 'object';
    };
    Occurrence: {
      description: 'Occurence object. This object is only returned for Recurring Webinars.';
      properties: {
        duration: {
          description: 'Duration.';
          type: 'integer';
        };
        occurrence_id: {
          description: 'Occurrence ID: Unique Identifier that identifies an occurrence of a recurring webinar. [Recurring webinars](https://support.zoom.us/hc/en-us/articles/216354763-How-to-Schedule-A-Recurring-Webinar) can have a maximum of 50 occurrences.';
          type: 'string';
        };
        start_time: {
          description: 'Start time.';
          format: 'date-time';
          type: 'string';
        };
        status: {
          description: 'Occurrence status.';
          type: 'string';
        };
      };
      type: 'object';
    };
    Occurrences: {
      description: 'Array of occurrence objects.';
      items: {
        description: 'Occurence object. This object is only returned for Recurring Webinars.';
        properties: {
          duration: {
            description: 'Duration.';
            type: 'integer';
          };
          occurrence_id: {
            description: 'Occurrence ID: Unique Identifier that identifies an occurrence of a recurring webinar. [Recurring webinars](https://support.zoom.us/hc/en-us/articles/216354763-How-to-Schedule-A-Recurring-Webinar) can have a maximum of 50 occurrences.';
            type: 'string';
          };
          start_time: {
            description: 'Start time.';
            format: 'date-time';
            type: 'string';
          };
          status: {
            description: 'Occurrence status.';
            type: 'string';
          };
        };
        type: 'object';
      };
      type: 'array';
    };
    PAC: {
      description: 'List of PAC accounts.';
      properties: {
        conference_id: {
          description: 'Conference ID.';
          type: 'integer';
        };
        dedicated_dial_in_number: {
          description: 'List of dedicated dial-in numbers.';
          items: {
            properties: {
              country: {
                description: 'Country code.';
                type: 'string';
              };
              number: {
                description: 'Dial-in number: length is less than 16.';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        global_dial_in_numbers: {
          description: 'List of global dial-in numbers.';
          items: {
            properties: {
              country: {
                description: 'Country code.';
                type: 'string';
              };
              number: {
                description: 'Dial-in number: length is less than 16.';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        listen_only_password: {
          description: 'Listen-Only passcode: numeric value - length is less than 6.';
          maxLength: 6;
          type: 'string';
        };
        participant_password: {
          description: 'Participant passcode: numeric value - length is less than 6.';
          maxLength: 6;
          minLength: 1;
          type: 'string';
        };
      };
      title: 'PAC Accounts List';
      type: 'object';
    };
    Pagination: {
      description: 'Pagination Object.';
      properties: {
        next_page_token: {
          description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
          type: 'string';
        };
        page_count: {
          description: 'The number of pages returned for the request made.';
          type: 'integer';
        };
        page_number: {
          default: 1;
          description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
          type: 'integer';
        };
        page_size: {
          default: 30;
          description: 'The number of records returned with a single API call.';
          maximum: 300;
          type: 'integer';
        };
        total_records: {
          description: 'The total number of all the records available across pages.';
          type: 'integer';
        };
      };
      type: 'object';
    };
    PaginationToken: {
      description: 'Pagination object.';
      properties: {
        next_page_token: {
          description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
          type: 'string';
        };
        page_count: {
          description: 'The number of pages returned for the request made.';
          type: 'integer';
        };
        page_size: {
          default: 30;
          description: 'The number of records returned within a single API call.';
          maximum: 300;
          type: 'integer';
        };
        total_records: {
          description: 'The number of all records available across pages.';
          type: 'integer';
        };
      };
      type: 'object';
    };
    PaginationToken4IMChat: {
      description: 'Pagination object.';
      properties: {
        next_page_token: {
          description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of the available result list exceeds the page size. The expiration period is 15 minutes.';
          type: 'string';
        };
        page_size: {
          default: 30;
          description: 'The amount of records returns within a single API call. ';
          maximum: 300;
          type: 'integer';
        };
      };
      type: 'object';
    };
    PaginationToken4Qos: {
      description: 'Pagination object.';
      properties: {
        next_page_token: {
          description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceed the current page size. The expiration period for this token is 15 minutes.';
          type: 'string';
        };
        page_count: {
          description: 'The number of pages returned for the request made.';
          format: 'int64';
          type: 'integer';
        };
        page_size: {
          default: 1;
          description: 'The number of items per page.';
          maximum: 10;
          type: 'integer';
        };
        total_records: {
          description: 'The number of all records available across pages.';
          format: 'int64';
          type: 'integer';
        };
      };
      type: 'object';
    };
    Panelist: {
      description: 'Panelist base object.';
      properties: {
        email: {
          description: "Panelist's email.";
          format: 'email';
          type: 'string';
        };
        name: {
          description: "Panelist's full name.";
          type: 'string';
        };
      };
      type: 'object';
    };
    PanelistList: {
      description: 'List of panelists.';
      properties: {
        panelists: {
          description: 'List of panelist objects.';
          items: {
            allOf: [
              {
                properties: {
                  id: {
                    description: "Panelist's ID.";
                    type: 'string';
                  };
                };
                type: 'object';
              },
              {
                description: 'Panelist base object.';
                properties: {
                  email: {
                    description: "Panelist's email.";
                    format: 'email';
                    type: 'string';
                  };
                  name: {
                    description: "Panelist's full name.";
                    type: 'string';
                  };
                };
                type: 'object';
              },
              {
                properties: {
                  join_url: {
                    description: 'Join URL.';
                    type: 'string';
                  };
                };
                type: 'object';
              },
            ];
          };
          type: 'array';
        };
        total_records: {
          description: 'Total records.';
          type: 'integer';
        };
      };
      title: 'Panelist List';
      type: 'object';
    };
    PhonePlan: {
      description: 'Phone Plan Object';
      properties: {
        plan_base: {
          description: 'Additional phone base plans.';
          properties: {
            callout_countries: {
              description: 'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.';
              type: 'string';
            };
            type: {
              description: 'Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
              type: 'string';
            };
          };
          type: 'object';
        };
        plan_calling: {
          description: 'Additional phone calling plans.';
          items: {
            properties: {
              hosts: {
                type: 'integer';
              };
              type: {
                description: 'Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        plan_number: {
          description: 'Additional phone number plans.';
          items: {
            properties: {
              hosts: {
                type: 'integer';
              };
              type: {
                description: 'Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
      };
      title: 'PhonePlan';
      type: 'object';
    };
    Poll: {
      description: 'Poll';
      properties: {
        questions: {
          description: 'Array of Polls';
          items: {
            properties: {
              answers: {
                description: 'Answers to the questions';
                items: {
                  type: 'string';
                };
                type: 'array';
              };
              name: {
                description: 'Question to be asked to the attendees.';
                type: 'string';
              };
              type: {
                description: 'Poll Question & Answer type:<br>`single` - Single choice<br>`mutliple` - Multiple choice';
                enum: ['single', 'multiple'];
                type: 'string';
                'x-enum-descriptions': ['single answer', 'multiple answer'];
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        title: {
          description: 'Title for the poll.';
          type: 'string';
        };
      };
      title: 'Poll';
      type: 'object';
    };
    PollList: {
      allOf: [
        {
          properties: {
            polls: {
              description: 'Array of Polls';
              items: {
                allOf: [
                  {
                    properties: {
                      id: {
                        description: 'ID of Poll';
                        type: 'string';
                      };
                      status: {
                        description: 'Status of Poll:<br>`notstart` - Poll not started<br>`started` - Poll started<br>`ended` - Poll ended<br>`sharing` - Sharing poll results';
                        enum: ['notstart', 'started', 'ended', 'sharing'];
                        type: 'string';
                        'x-enum-descriptions': ['Poll not start', 'Poll started', 'Poll ended', 'Poll is sharing'];
                      };
                    };
                  },
                  {
                    description: 'Poll';
                    properties: {
                      questions: {
                        description: 'Array of Polls';
                        items: {
                          properties: {
                            answers: {
                              description: 'Answers to the questions';
                              items: {
                                type: 'string';
                              };
                              type: 'array';
                            };
                            name: {
                              description: 'Question to be asked to the attendees.';
                              type: 'string';
                            };
                            type: {
                              description: 'Poll Question & Answer type:<br>`single` - Single choice<br>`mutliple` - Multiple choice';
                              enum: ['single', 'multiple'];
                              type: 'string';
                              'x-enum-descriptions': ['single answer', 'multiple answer'];
                            };
                          };
                          type: 'object';
                        };
                        type: 'array';
                      };
                      title: {
                        description: 'Title for the poll.';
                        type: 'string';
                      };
                    };
                    title: 'Poll';
                    type: 'object';
                  },
                ];
              };
              type: 'array';
            };
            total_records: {
              description: 'The number of all records available across pages';
              type: 'integer';
            };
          };
        },
      ];
      description: 'Poll List';
      title: 'Poll List';
      type: 'object';
    };
    Profile: {
      properties: {
        recording_storage_location: {
          properties: {
            allowed_values: {
              description: 'Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.\n\nProvide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            value: {
              description: 'Abbreviated country code.';
              type: 'string';
            };
          };
          type: 'object';
        };
      };
      title: 'Profile';
      type: 'object';
    };
    QOSAudio: {
      description: 'Quality of Service object.';
      properties: {
        avg_loss: {
          description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
          type: 'string';
        };
        bitrate: {
          description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
          type: 'string';
        };
        jitter: {
          description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
          type: 'string';
        };
        latency: {
          description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
          type: 'string';
        };
        max_loss: {
          description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
          type: 'string';
        };
      };
      title: 'QOS Object';
      type: 'object';
    };
    QOSParticipant: {
      description: 'Participant QOS.';
      properties: {
        device: {
          description: 'The type of device using which the participant joined the meeting.';
          type: 'string';
        };
        domain: {
          description: "Participant's PC domain.";
          type: 'string';
        };
        harddisk_id: {
          description: "Participant's hard disk ID.";
          type: 'string';
        };
        ip_address: {
          description: "Participant's IP address.";
          type: 'string';
        };
        join_time: {
          description: 'The time at which participant joined the meeting.';
          format: 'date-time';
          type: 'string';
        };
        leave_time: {
          description: 'The time at which participant left the meeting.';
          format: 'date-time';
          type: 'string';
        };
        location: {
          description: "Participant's location.";
          type: 'string';
        };
        mac_addr: {
          description: "Participant's MAC address.";
          type: 'string';
        };
        pc_name: {
          description: "Participant's PC name.";
          type: 'string';
        };
        user_id: {
          description: 'Participant ID.';
          format: 'uuid';
          type: 'string';
        };
        user_name: {
          description: 'Participant display name.';
          type: 'string';
        };
        user_qos: {
          description: 'Quality of service provided to the user.';
          items: {
            properties: {
              as_device_from_crc: {
                description: 'QoS metrics on screen shares by a participant who joined the meeting via a Cloud Room Connector.';
                properties: {
                  avg_loss: {
                    description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                    type: 'string';
                  };
                  bitrate: {
                    description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                    type: 'string';
                  };
                  jitter: {
                    description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  latency: {
                    description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  max_loss: {
                    description: 'The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              as_device_to_crc: {
                description: 'QoS metrics on screen shares output being received by a participant who joined the meeting via a Cloud Room Connector.';
                properties: {
                  avg_loss: {
                    description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                    type: 'string';
                  };
                  bitrate: {
                    description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                    type: 'string';
                  };
                  jitter: {
                    description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  latency: {
                    description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  max_loss: {
                    description: 'The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              as_input: {
                allOf: [
                  {
                    description: 'Quality of Service object.';
                    properties: {
                      avg_loss: {
                        description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                        type: 'string';
                      };
                      bitrate: {
                        description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                        type: 'string';
                      };
                      jitter: {
                        description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                        type: 'string';
                      };
                      latency: {
                        description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                        type: 'string';
                      };
                      max_loss: {
                        description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                        type: 'string';
                      };
                    };
                    title: 'QOS Object';
                    type: 'object';
                  },
                  {
                    properties: {
                      frame_rate: {
                        description: 'The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.';
                        type: 'string';
                      };
                      resolution: {
                        description: 'The number of pixels in each dimension that can be displayed by your video camera.';
                        type: 'string';
                      };
                    };
                  },
                ];
                description: 'Quality of service object.';
                title: 'QOS Object';
                type: 'object';
              };
              as_output: {
                allOf: [
                  {
                    description: 'Quality of Service object.';
                    properties: {
                      avg_loss: {
                        description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                        type: 'string';
                      };
                      bitrate: {
                        description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                        type: 'string';
                      };
                      jitter: {
                        description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                        type: 'string';
                      };
                      latency: {
                        description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                        type: 'string';
                      };
                      max_loss: {
                        description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                        type: 'string';
                      };
                    };
                    title: 'QOS Object';
                    type: 'object';
                  },
                  {
                    properties: {
                      frame_rate: {
                        description: 'The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.';
                        type: 'string';
                      };
                      resolution: {
                        description: 'The number of pixels in each dimension that can be displayed by your video camera.';
                        type: 'string';
                      };
                    };
                  },
                ];
                description: 'Quality of service object.';
                title: 'QOS Object';
                type: 'object';
              };
              audio_device_from_crc: {
                description: 'QoS metrics on audio being sent by a participant who joined the meeting via a Cloud Room Connector.';
                properties: {
                  avg_loss: {
                    description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                    type: 'string';
                  };
                  bitrate: {
                    description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                    type: 'string';
                  };
                  jitter: {
                    description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  latency: {
                    description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  max_loss: {
                    description: 'The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              audio_device_to_crc: {
                description: 'QoS metrics on audio received by a participant who joined the meeting via a Cloud Room Connector.';
                properties: {
                  avg_loss: {
                    description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                    type: 'string';
                  };
                  bitrate: {
                    description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                    type: 'string';
                  };
                  jitter: {
                    description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  latency: {
                    description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  max_loss: {
                    description: 'The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              audio_input: {
                description: 'Quality of Service object.';
                properties: {
                  avg_loss: {
                    description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                    type: 'string';
                  };
                  bitrate: {
                    description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                    type: 'string';
                  };
                  jitter: {
                    description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  latency: {
                    description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  max_loss: {
                    description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                    type: 'string';
                  };
                };
                title: 'QOS Object';
                type: 'object';
              };
              audio_output: {
                description: 'Quality of Service object.';
                properties: {
                  avg_loss: {
                    description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                    type: 'string';
                  };
                  bitrate: {
                    description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                    type: 'string';
                  };
                  jitter: {
                    description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  latency: {
                    description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  max_loss: {
                    description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                    type: 'string';
                  };
                };
                title: 'QOS Object';
                type: 'object';
              };
              cpu_usage: {
                properties: {
                  system_max_cpu_usage: {
                    description: 'System Maximum CPU Usage';
                    type: 'string';
                  };
                  zoom_avg_cpu_usage: {
                    description: 'Zoom Average CPU Usage';
                    type: 'string';
                  };
                  zoom_max_cpu_usage: {
                    description: 'Zoom Maximum CPU Usage';
                    type: 'string';
                  };
                  zoom_min_cpu_usage: {
                    description: 'Zoom Minimum CPU Usage';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              date_time: {
                description: 'Date-time of QOS';
                format: 'date-time';
                type: 'string';
              };
              video_device_from_crc: {
                description: 'QoS metrics on video input being sent from a Cloud Room Connector used by the participant to join the meeting.';
                properties: {
                  avg_loss: {
                    description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                    type: 'string';
                  };
                  bitrate: {
                    description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                    type: 'string';
                  };
                  jitter: {
                    description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  latency: {
                    description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  max_loss: {
                    description: 'The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              video_device_to_crc: {
                description: 'QoS metrics on video output received by a participant who joined the meeting via a Cloud Room Connector.';
                properties: {
                  avg_loss: {
                    description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                    type: 'string';
                  };
                  bitrate: {
                    description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                    type: 'string';
                  };
                  jitter: {
                    description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  latency: {
                    description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                    type: 'string';
                  };
                  max_loss: {
                    description: 'The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              video_input: {
                allOf: [
                  {
                    description: 'Quality of Service object.';
                    properties: {
                      avg_loss: {
                        description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                        type: 'string';
                      };
                      bitrate: {
                        description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                        type: 'string';
                      };
                      jitter: {
                        description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                        type: 'string';
                      };
                      latency: {
                        description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                        type: 'string';
                      };
                      max_loss: {
                        description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                        type: 'string';
                      };
                    };
                    title: 'QOS Object';
                    type: 'object';
                  },
                  {
                    properties: {
                      frame_rate: {
                        description: 'The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.';
                        type: 'string';
                      };
                      resolution: {
                        description: 'The number of pixels in each dimension that can be displayed by your video camera.';
                        type: 'string';
                      };
                    };
                  },
                ];
                description: 'Quality of service object.';
                title: 'QOS Object';
                type: 'object';
              };
              video_output: {
                allOf: [
                  {
                    description: 'Quality of Service object.';
                    properties: {
                      avg_loss: {
                        description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                        type: 'string';
                      };
                      bitrate: {
                        description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                        type: 'string';
                      };
                      jitter: {
                        description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                        type: 'string';
                      };
                      latency: {
                        description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                        type: 'string';
                      };
                      max_loss: {
                        description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                        type: 'string';
                      };
                    };
                    title: 'QOS Object';
                    type: 'object';
                  },
                  {
                    properties: {
                      frame_rate: {
                        description: 'The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.';
                        type: 'string';
                      };
                      resolution: {
                        description: 'The number of pixels in each dimension that can be displayed by your video camera.';
                        type: 'string';
                      };
                    };
                  },
                ];
                description: 'Quality of service object.';
                title: 'QOS Object';
                type: 'object';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        version: {
          description: "Participant's Zoom Client version.";
          type: 'string';
        };
      };
      title: 'Participant QOS';
      type: 'object';
    };
    QOSParticipantList: {
      allOf: [
        {
          description: 'Pagination object.';
          properties: {
            next_page_token: {
              description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceed the current page size. The expiration period for this token is 15 minutes.';
              type: 'string';
            };
            page_count: {
              description: 'The number of pages returned for the request made.';
              format: 'int64';
              type: 'integer';
            };
            page_size: {
              default: 1;
              description: 'The number of items per page.';
              maximum: 10;
              type: 'integer';
            };
            total_records: {
              description: 'The number of all records available across pages.';
              format: 'int64';
              type: 'integer';
            };
          };
          type: 'object';
        },
        {
          properties: {
            participants: {
              description: 'Array of user objects.';
              items: {
                description: 'Participant QOS.';
                properties: {
                  device: {
                    description: 'The type of device using which the participant joined the meeting.';
                    type: 'string';
                  };
                  domain: {
                    description: "Participant's PC domain.";
                    type: 'string';
                  };
                  harddisk_id: {
                    description: "Participant's hard disk ID.";
                    type: 'string';
                  };
                  ip_address: {
                    description: "Participant's IP address.";
                    type: 'string';
                  };
                  join_time: {
                    description: 'The time at which participant joined the meeting.';
                    format: 'date-time';
                    type: 'string';
                  };
                  leave_time: {
                    description: 'The time at which participant left the meeting.';
                    format: 'date-time';
                    type: 'string';
                  };
                  location: {
                    description: "Participant's location.";
                    type: 'string';
                  };
                  mac_addr: {
                    description: "Participant's MAC address.";
                    type: 'string';
                  };
                  pc_name: {
                    description: "Participant's PC name.";
                    type: 'string';
                  };
                  user_id: {
                    description: 'Participant ID.';
                    format: 'uuid';
                    type: 'string';
                  };
                  user_name: {
                    description: 'Participant display name.';
                    type: 'string';
                  };
                  user_qos: {
                    description: 'Quality of service provided to the user.';
                    items: {
                      properties: {
                        as_device_from_crc: {
                          description: 'QoS metrics on screen shares by a participant who joined the meeting via a Cloud Room Connector.';
                          properties: {
                            avg_loss: {
                              description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                              type: 'string';
                            };
                            bitrate: {
                              description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                              type: 'string';
                            };
                            jitter: {
                              description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            latency: {
                              description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            max_loss: {
                              description: 'The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        as_device_to_crc: {
                          description: 'QoS metrics on screen shares output being received by a participant who joined the meeting via a Cloud Room Connector.';
                          properties: {
                            avg_loss: {
                              description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                              type: 'string';
                            };
                            bitrate: {
                              description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                              type: 'string';
                            };
                            jitter: {
                              description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            latency: {
                              description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            max_loss: {
                              description: 'The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        as_input: {
                          allOf: [
                            {
                              description: 'Quality of Service object.';
                              properties: {
                                avg_loss: {
                                  description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                                  type: 'string';
                                };
                                bitrate: {
                                  description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                                  type: 'string';
                                };
                                jitter: {
                                  description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                                  type: 'string';
                                };
                                latency: {
                                  description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                                  type: 'string';
                                };
                                max_loss: {
                                  description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                                  type: 'string';
                                };
                              };
                              title: 'QOS Object';
                              type: 'object';
                            },
                            {
                              properties: {
                                frame_rate: {
                                  description: 'The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.';
                                  type: 'string';
                                };
                                resolution: {
                                  description: 'The number of pixels in each dimension that can be displayed by your video camera.';
                                  type: 'string';
                                };
                              };
                            },
                          ];
                          description: 'Quality of service object.';
                          title: 'QOS Object';
                          type: 'object';
                        };
                        as_output: {
                          allOf: [
                            {
                              description: 'Quality of Service object.';
                              properties: {
                                avg_loss: {
                                  description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                                  type: 'string';
                                };
                                bitrate: {
                                  description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                                  type: 'string';
                                };
                                jitter: {
                                  description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                                  type: 'string';
                                };
                                latency: {
                                  description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                                  type: 'string';
                                };
                                max_loss: {
                                  description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                                  type: 'string';
                                };
                              };
                              title: 'QOS Object';
                              type: 'object';
                            },
                            {
                              properties: {
                                frame_rate: {
                                  description: 'The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.';
                                  type: 'string';
                                };
                                resolution: {
                                  description: 'The number of pixels in each dimension that can be displayed by your video camera.';
                                  type: 'string';
                                };
                              };
                            },
                          ];
                          description: 'Quality of service object.';
                          title: 'QOS Object';
                          type: 'object';
                        };
                        audio_device_from_crc: {
                          description: 'QoS metrics on audio being sent by a participant who joined the meeting via a Cloud Room Connector.';
                          properties: {
                            avg_loss: {
                              description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                              type: 'string';
                            };
                            bitrate: {
                              description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                              type: 'string';
                            };
                            jitter: {
                              description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            latency: {
                              description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            max_loss: {
                              description: 'The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        audio_device_to_crc: {
                          description: 'QoS metrics on audio received by a participant who joined the meeting via a Cloud Room Connector.';
                          properties: {
                            avg_loss: {
                              description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                              type: 'string';
                            };
                            bitrate: {
                              description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                              type: 'string';
                            };
                            jitter: {
                              description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            latency: {
                              description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            max_loss: {
                              description: 'The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        audio_input: {
                          description: 'Quality of Service object.';
                          properties: {
                            avg_loss: {
                              description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                              type: 'string';
                            };
                            bitrate: {
                              description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                              type: 'string';
                            };
                            jitter: {
                              description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            latency: {
                              description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            max_loss: {
                              description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                              type: 'string';
                            };
                          };
                          title: 'QOS Object';
                          type: 'object';
                        };
                        audio_output: {
                          description: 'Quality of Service object.';
                          properties: {
                            avg_loss: {
                              description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                              type: 'string';
                            };
                            bitrate: {
                              description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                              type: 'string';
                            };
                            jitter: {
                              description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            latency: {
                              description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            max_loss: {
                              description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                              type: 'string';
                            };
                          };
                          title: 'QOS Object';
                          type: 'object';
                        };
                        cpu_usage: {
                          properties: {
                            system_max_cpu_usage: {
                              description: 'System Maximum CPU Usage';
                              type: 'string';
                            };
                            zoom_avg_cpu_usage: {
                              description: 'Zoom Average CPU Usage';
                              type: 'string';
                            };
                            zoom_max_cpu_usage: {
                              description: 'Zoom Maximum CPU Usage';
                              type: 'string';
                            };
                            zoom_min_cpu_usage: {
                              description: 'Zoom Minimum CPU Usage';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        date_time: {
                          description: 'Date-time of QOS';
                          format: 'date-time';
                          type: 'string';
                        };
                        video_device_from_crc: {
                          description: 'QoS metrics on video input being sent from a Cloud Room Connector used by the participant to join the meeting.';
                          properties: {
                            avg_loss: {
                              description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                              type: 'string';
                            };
                            bitrate: {
                              description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                              type: 'string';
                            };
                            jitter: {
                              description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            latency: {
                              description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            max_loss: {
                              description: 'The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        video_device_to_crc: {
                          description: 'QoS metrics on video output received by a participant who joined the meeting via a Cloud Room Connector.';
                          properties: {
                            avg_loss: {
                              description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                              type: 'string';
                            };
                            bitrate: {
                              description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                              type: 'string';
                            };
                            jitter: {
                              description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            latency: {
                              description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                              type: 'string';
                            };
                            max_loss: {
                              description: 'The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                              type: 'string';
                            };
                          };
                          type: 'object';
                        };
                        video_input: {
                          allOf: [
                            {
                              description: 'Quality of Service object.';
                              properties: {
                                avg_loss: {
                                  description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                                  type: 'string';
                                };
                                bitrate: {
                                  description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                                  type: 'string';
                                };
                                jitter: {
                                  description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                                  type: 'string';
                                };
                                latency: {
                                  description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                                  type: 'string';
                                };
                                max_loss: {
                                  description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                                  type: 'string';
                                };
                              };
                              title: 'QOS Object';
                              type: 'object';
                            },
                            {
                              properties: {
                                frame_rate: {
                                  description: 'The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.';
                                  type: 'string';
                                };
                                resolution: {
                                  description: 'The number of pixels in each dimension that can be displayed by your video camera.';
                                  type: 'string';
                                };
                              };
                            },
                          ];
                          description: 'Quality of service object.';
                          title: 'QOS Object';
                          type: 'object';
                        };
                        video_output: {
                          allOf: [
                            {
                              description: 'Quality of Service object.';
                              properties: {
                                avg_loss: {
                                  description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
                                  type: 'string';
                                };
                                bitrate: {
                                  description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
                                  type: 'string';
                                };
                                jitter: {
                                  description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
                                  type: 'string';
                                };
                                latency: {
                                  description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
                                  type: 'string';
                                };
                                max_loss: {
                                  description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
                                  type: 'string';
                                };
                              };
                              title: 'QOS Object';
                              type: 'object';
                            },
                            {
                              properties: {
                                frame_rate: {
                                  description: 'The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.';
                                  type: 'string';
                                };
                                resolution: {
                                  description: 'The number of pixels in each dimension that can be displayed by your video camera.';
                                  type: 'string';
                                };
                              };
                            },
                          ];
                          description: 'Quality of service object.';
                          title: 'QOS Object';
                          type: 'object';
                        };
                      };
                      type: 'object';
                    };
                    type: 'array';
                  };
                  version: {
                    description: "Participant's Zoom Client version.";
                    type: 'string';
                  };
                };
                title: 'Participant QOS';
                type: 'object';
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'Participant QOS list.';
      title: 'Participant QOS List';
      type: 'object';
    };
    QOSVideo: {
      allOf: [
        {
          description: 'Quality of Service object.';
          properties: {
            avg_loss: {
              description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination. ';
              type: 'string';
            };
            bitrate: {
              description: 'The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.';
              type: 'string';
            };
            jitter: {
              description: 'The variation in the delay of received packets. The value of this field is expressed in milliseconds. ';
              type: 'string';
            };
            latency: {
              description: 'The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds. ';
              type: 'string';
            };
            max_loss: {
              description: 'Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.';
              type: 'string';
            };
          };
          title: 'QOS Object';
          type: 'object';
        },
        {
          properties: {
            frame_rate: {
              description: 'The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.';
              type: 'string';
            };
            resolution: {
              description: 'The number of pixels in each dimension that can be displayed by your video camera.';
              type: 'string';
            };
          };
        },
      ];
      description: 'Quality of service object.';
      title: 'QOS Object';
      type: 'object';
    };
    QoSPhone: {
      description: 'Quality of Service object.';
      properties: {
        avg_loss: {
          description: 'The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.';
          type: 'string';
        };
        bitrate: {
          description: 'The number of bits per second that can be transmitted along a digital network.';
          type: 'string';
        };
        jitter: {
          description: 'The variation in the delay of received packets.';
          type: 'string';
        };
        max_loss: {
          description: 'The max amount of packet loss, i.e., the max percentage of packets that fail to arrive at their destination.';
          type: 'string';
        };
        mos: {
          description: 'Mean Opinion Score(MOS) measures voice quality on a scale of 1 to 5. A MOS greater than or equal to 3.5 means good quality, while below 3.5 means poor quality.';
          type: 'string';
        };
        network_delay: {
          description: 'The amount of time it takes for a VoIP packet to travel from one point to another.';
          type: 'string';
        };
      };
      title: 'QoS Phone';
      type: 'object';
    };
    Recording: {
      description: 'Recording file object.';
      properties: {
        deleted_time: {
          description: 'The time at which recording was deleted. Returned in the response only for trash query.';
          type: 'string';
        };
        download_url: {
          description: "The URL using which the recording file can be downloaded. **To access a private or password protected cloud recording of a user in your account, you can use a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the `access_token` query parameter and include this query parameter at the end of the URL as shown in the example.**  \n<br>\nExample: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ JWT Token }}`\n\n**Similarly, if the user has installed your OAuth app that contains recording scope(s), you can also use the user's [OAuth access token](https://marketplace.zoom.us/docs/guides/auth/oauth) to download the Cloud Recording.**<br>\n\nExample: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ OAuth Access Token }}`\n\n";
          type: 'string';
        };
        file_size: {
          description: 'The recording file size.';
          type: 'number';
        };
        file_type: {
          description: 'The recording file type. The value of this field could be one of the following:<br>\n`MP4`: Video file of the recording.<br>`M4A` Audio-only file of the recording.<br>`TIMELINE`: Timestamp file of the recording in JSON file format. To get a timeline file, the "Add a timestamp to the recording" setting must be enabled in the [recording settings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-recording#h_3f14c3a4-d16b-4a3c-bbe5-ef7d24500048). The time will display in the host\'s timezone, set on their Zoom profile.\n<br> `TRANSCRIPT`: Transcription file of the recording in VTT format.<br> `CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>`CC`: File containing closed captions of the recording in VTT file format.<br>`CSV`: File containing polling data in csv format.\n\n<br>\n\nA recording file object with file type of either `CC` or `TIMELINE` **does not have** the following properties:<br>\n\t`id`, `status`, `file_size`, `recording_type`, and `play_url`.';
          type: 'string';
        };
        id: {
          description: 'The recording file ID. Included in the response of general query.';
          type: 'string';
        };
        meeting_id: {
          description: 'The meeting ID. ';
          type: 'string';
        };
        play_url: {
          description: 'The URL using which a recording file can be played.';
          type: 'string';
        };
        recording_end: {
          description: 'The recording end time. Response in general query.';
          type: 'string';
        };
        recording_start: {
          description: 'The recording start time.';
          type: 'string';
        };
        recording_type: {
          description: 'The recording type. The value of this field can be one of the following:<br>`shared_screen_with_speaker_view(CC)`<br>`shared_screen_with_speaker_view`<br>`shared_screen_with_gallery_view`<br>`speaker_view`<br>`gallery_view`<br>`shared_screen`<br>`audio_only`<br>`audio_transcript`<br>`chat_file`<br>`active_speaker`<br>`poll`';
          type: 'string';
        };
        status: {
          description: 'The recording status.';
          enum: ['completed'];
          type: 'string';
        };
      };
      type: 'object';
    };
    RecordingList: {
      allOf: [
        {
          properties: {
            recording_files: {
              description: 'List of recording file.';
              items: {
                allOf: [
                  {
                    description: 'Recording file object.';
                    properties: {
                      deleted_time: {
                        description: 'The time at which recording was deleted. Returned in the response only for trash query.';
                        type: 'string';
                      };
                      download_url: {
                        description: "The URL using which the recording file can be downloaded. **To access a private or password protected cloud recording of a user in your account, you can use a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the `access_token` query parameter and include this query parameter at the end of the URL as shown in the example.**  \n<br>\nExample: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ JWT Token }}`\n\n**Similarly, if the user has installed your OAuth app that contains recording scope(s), you can also use the user's [OAuth access token](https://marketplace.zoom.us/docs/guides/auth/oauth) to download the Cloud Recording.**<br>\n\nExample: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ OAuth Access Token }}`\n\n";
                        type: 'string';
                      };
                      file_size: {
                        description: 'The recording file size.';
                        type: 'number';
                      };
                      file_type: {
                        description: 'The recording file type. The value of this field could be one of the following:<br>\n`MP4`: Video file of the recording.<br>`M4A` Audio-only file of the recording.<br>`TIMELINE`: Timestamp file of the recording in JSON file format. To get a timeline file, the "Add a timestamp to the recording" setting must be enabled in the [recording settings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-recording#h_3f14c3a4-d16b-4a3c-bbe5-ef7d24500048). The time will display in the host\'s timezone, set on their Zoom profile.\n<br> `TRANSCRIPT`: Transcription file of the recording in VTT format.<br> `CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>`CC`: File containing closed captions of the recording in VTT file format.<br>`CSV`: File containing polling data in csv format.\n\n<br>\n\nA recording file object with file type of either `CC` or `TIMELINE` **does not have** the following properties:<br>\n\t`id`, `status`, `file_size`, `recording_type`, and `play_url`.';
                        type: 'string';
                      };
                      id: {
                        description: 'The recording file ID. Included in the response of general query.';
                        type: 'string';
                      };
                      meeting_id: {
                        description: 'The meeting ID. ';
                        type: 'string';
                      };
                      play_url: {
                        description: 'The URL using which a recording file can be played.';
                        type: 'string';
                      };
                      recording_end: {
                        description: 'The recording end time. Response in general query.';
                        type: 'string';
                      };
                      recording_start: {
                        description: 'The recording start time.';
                        type: 'string';
                      };
                      recording_type: {
                        description: 'The recording type. The value of this field can be one of the following:<br>`shared_screen_with_speaker_view(CC)`<br>`shared_screen_with_speaker_view`<br>`shared_screen_with_gallery_view`<br>`speaker_view`<br>`gallery_view`<br>`shared_screen`<br>`audio_only`<br>`audio_transcript`<br>`chat_file`<br>`active_speaker`<br>`poll`';
                        type: 'string';
                      };
                      status: {
                        description: 'The recording status.';
                        enum: ['completed'];
                        type: 'string';
                      };
                    };
                    type: 'object';
                  },
                ];
              };
              title: 'Recording file List';
              type: 'array';
            };
          };
        },
      ];
      description: 'List of recording file.';
      title: 'Recording file List';
      type: 'object';
    };
    RecordingMeeting: {
      allOf: [
        {
          properties: {
            account_id: {
              description: 'Unique Identifier of the user account.';
              type: 'string';
            };
            duration: {
              description: 'Meeting duration.';
              type: 'integer';
            };
            host_id: {
              description: 'ID of the user set as host of meeting.';
              type: 'string';
            };
            id: {
              description: 'Meeting ID - also known as the meeting number.';
              type: 'string';
            };
            recording_count: {
              description: 'Number of recording files returned in the response of this API call.';
              type: 'string';
            };
            start_time: {
              description: 'The time at which the meeting started.';
              format: 'date-time';
              type: 'string';
            };
            topic: {
              description: 'Meeting topic.';
              type: 'string';
            };
            total_size: {
              description: 'Total size of the recording.';
              type: 'string';
            };
            type: {
              description: 'Type of the meeting that was recorded.\n\nMeeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.';
              type: 'string';
            };
            uuid: {
              description: 'Unique Meeting Identifier. Each instance of the meeting will have its own UUID.';
              type: 'string';
            };
          };
        },
        {
          allOf: [
            {
              properties: {
                recording_files: {
                  description: 'List of recording file.';
                  items: {
                    allOf: [
                      {
                        description: 'Recording file object.';
                        properties: {
                          deleted_time: {
                            description: 'The time at which recording was deleted. Returned in the response only for trash query.';
                            type: 'string';
                          };
                          download_url: {
                            description: "The URL using which the recording file can be downloaded. **To access a private or password protected cloud recording of a user in your account, you can use a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the `access_token` query parameter and include this query parameter at the end of the URL as shown in the example.**  \n<br>\nExample: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ JWT Token }}`\n\n**Similarly, if the user has installed your OAuth app that contains recording scope(s), you can also use the user's [OAuth access token](https://marketplace.zoom.us/docs/guides/auth/oauth) to download the Cloud Recording.**<br>\n\nExample: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ OAuth Access Token }}`\n\n";
                            type: 'string';
                          };
                          file_size: {
                            description: 'The recording file size.';
                            type: 'number';
                          };
                          file_type: {
                            description: 'The recording file type. The value of this field could be one of the following:<br>\n`MP4`: Video file of the recording.<br>`M4A` Audio-only file of the recording.<br>`TIMELINE`: Timestamp file of the recording in JSON file format. To get a timeline file, the "Add a timestamp to the recording" setting must be enabled in the [recording settings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-recording#h_3f14c3a4-d16b-4a3c-bbe5-ef7d24500048). The time will display in the host\'s timezone, set on their Zoom profile.\n<br> `TRANSCRIPT`: Transcription file of the recording in VTT format.<br> `CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>`CC`: File containing closed captions of the recording in VTT file format.<br>`CSV`: File containing polling data in csv format.\n\n<br>\n\nA recording file object with file type of either `CC` or `TIMELINE` **does not have** the following properties:<br>\n\t`id`, `status`, `file_size`, `recording_type`, and `play_url`.';
                            type: 'string';
                          };
                          id: {
                            description: 'The recording file ID. Included in the response of general query.';
                            type: 'string';
                          };
                          meeting_id: {
                            description: 'The meeting ID. ';
                            type: 'string';
                          };
                          play_url: {
                            description: 'The URL using which a recording file can be played.';
                            type: 'string';
                          };
                          recording_end: {
                            description: 'The recording end time. Response in general query.';
                            type: 'string';
                          };
                          recording_start: {
                            description: 'The recording start time.';
                            type: 'string';
                          };
                          recording_type: {
                            description: 'The recording type. The value of this field can be one of the following:<br>`shared_screen_with_speaker_view(CC)`<br>`shared_screen_with_speaker_view`<br>`shared_screen_with_gallery_view`<br>`speaker_view`<br>`gallery_view`<br>`shared_screen`<br>`audio_only`<br>`audio_transcript`<br>`chat_file`<br>`active_speaker`<br>`poll`';
                            type: 'string';
                          };
                          status: {
                            description: 'The recording status.';
                            enum: ['completed'];
                            type: 'string';
                          };
                        };
                        type: 'object';
                      },
                    ];
                  };
                  title: 'Recording file List';
                  type: 'array';
                };
              };
            },
          ];
          description: 'List of recording file.';
          title: 'Recording file List';
          type: 'object';
        },
      ];
      description: 'The recording meeting object.';
      type: 'object';
    };
    RecordingMeetingList: {
      allOf: [
        {
          description: 'DateTime Object.';
          properties: {
            from: {
              description: 'Start Date.';
              format: 'date';
              type: 'string';
            };
            to: {
              description: 'End Date.';
              format: 'date';
              type: 'string';
            };
          };
          type: 'object';
        },
        {
          description: 'Pagination object.';
          properties: {
            next_page_token: {
              description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
              type: 'string';
            };
            page_count: {
              description: 'The number of pages returned for the request made.';
              type: 'integer';
            };
            page_size: {
              default: 30;
              description: 'The number of records returned within a single API call.';
              maximum: 300;
              type: 'integer';
            };
            total_records: {
              description: 'The number of all records available across pages.';
              type: 'integer';
            };
          };
          type: 'object';
        },
        {
          properties: {
            meetings: {
              description: 'List of recordings.';
              items: {
                allOf: [
                  {
                    allOf: [
                      {
                        properties: {
                          account_id: {
                            description: 'Unique Identifier of the user account.';
                            type: 'string';
                          };
                          duration: {
                            description: 'Meeting duration.';
                            type: 'integer';
                          };
                          host_id: {
                            description: 'ID of the user set as host of meeting.';
                            type: 'string';
                          };
                          id: {
                            description: 'Meeting ID - also known as the meeting number.';
                            type: 'string';
                          };
                          recording_count: {
                            description: 'Number of recording files returned in the response of this API call.';
                            type: 'string';
                          };
                          start_time: {
                            description: 'The time at which the meeting started.';
                            format: 'date-time';
                            type: 'string';
                          };
                          topic: {
                            description: 'Meeting topic.';
                            type: 'string';
                          };
                          total_size: {
                            description: 'Total size of the recording.';
                            type: 'string';
                          };
                          type: {
                            description: 'Type of the meeting that was recorded.\n\nMeeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.';
                            type: 'string';
                          };
                          uuid: {
                            description: 'Unique Meeting Identifier. Each instance of the meeting will have its own UUID.';
                            type: 'string';
                          };
                        };
                      },
                      {
                        allOf: [
                          {
                            properties: {
                              recording_files: {
                                description: 'List of recording file.';
                                items: {
                                  allOf: [
                                    {
                                      description: 'Recording file object.';
                                      properties: {
                                        deleted_time: {
                                          description: 'The time at which recording was deleted. Returned in the response only for trash query.';
                                          type: 'string';
                                        };
                                        download_url: {
                                          description: "The URL using which the recording file can be downloaded. **To access a private or password protected cloud recording of a user in your account, you can use a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the `access_token` query parameter and include this query parameter at the end of the URL as shown in the example.**  \n<br>\nExample: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ JWT Token }}`\n\n**Similarly, if the user has installed your OAuth app that contains recording scope(s), you can also use the user's [OAuth access token](https://marketplace.zoom.us/docs/guides/auth/oauth) to download the Cloud Recording.**<br>\n\nExample: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ OAuth Access Token }}`\n\n";
                                          type: 'string';
                                        };
                                        file_size: {
                                          description: 'The recording file size.';
                                          type: 'number';
                                        };
                                        file_type: {
                                          description: 'The recording file type. The value of this field could be one of the following:<br>\n`MP4`: Video file of the recording.<br>`M4A` Audio-only file of the recording.<br>`TIMELINE`: Timestamp file of the recording in JSON file format. To get a timeline file, the "Add a timestamp to the recording" setting must be enabled in the [recording settings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-recording#h_3f14c3a4-d16b-4a3c-bbe5-ef7d24500048). The time will display in the host\'s timezone, set on their Zoom profile.\n<br> `TRANSCRIPT`: Transcription file of the recording in VTT format.<br> `CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>`CC`: File containing closed captions of the recording in VTT file format.<br>`CSV`: File containing polling data in csv format.\n\n<br>\n\nA recording file object with file type of either `CC` or `TIMELINE` **does not have** the following properties:<br>\n\t`id`, `status`, `file_size`, `recording_type`, and `play_url`.';
                                          type: 'string';
                                        };
                                        id: {
                                          description: 'The recording file ID. Included in the response of general query.';
                                          type: 'string';
                                        };
                                        meeting_id: {
                                          description: 'The meeting ID. ';
                                          type: 'string';
                                        };
                                        play_url: {
                                          description: 'The URL using which a recording file can be played.';
                                          type: 'string';
                                        };
                                        recording_end: {
                                          description: 'The recording end time. Response in general query.';
                                          type: 'string';
                                        };
                                        recording_start: {
                                          description: 'The recording start time.';
                                          type: 'string';
                                        };
                                        recording_type: {
                                          description: 'The recording type. The value of this field can be one of the following:<br>`shared_screen_with_speaker_view(CC)`<br>`shared_screen_with_speaker_view`<br>`shared_screen_with_gallery_view`<br>`speaker_view`<br>`gallery_view`<br>`shared_screen`<br>`audio_only`<br>`audio_transcript`<br>`chat_file`<br>`active_speaker`<br>`poll`';
                                          type: 'string';
                                        };
                                        status: {
                                          description: 'The recording status.';
                                          enum: ['completed'];
                                          type: 'string';
                                        };
                                      };
                                      type: 'object';
                                    },
                                  ];
                                };
                                title: 'Recording file List';
                                type: 'array';
                              };
                            };
                          },
                        ];
                        description: 'List of recording file.';
                        title: 'Recording file List';
                        type: 'object';
                      },
                    ];
                    description: 'The recording meeting object.';
                    type: 'object';
                  },
                ];
              };
              title: 'Recording List';
              type: 'array';
            };
          };
        },
      ];
      description: 'List of recordings.';
      title: 'Recording List';
      type: 'object';
    };
    RecordingRegistrantList: {
      allOf: [
        {
          description: 'Pagination Object.';
          properties: {
            next_page_token: {
              description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
              type: 'string';
            };
            page_count: {
              description: 'The number of pages returned for the request made.';
              type: 'integer';
            };
            page_number: {
              default: 1;
              description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
              type: 'integer';
            };
            page_size: {
              default: 30;
              description: 'The number of records returned with a single API call.';
              maximum: 300;
              type: 'integer';
            };
            total_records: {
              description: 'The total number of all the records available across pages.';
              type: 'integer';
            };
          };
          type: 'object';
        },
        {
          properties: {
            registrants: {
              description: 'List of Registrant objects';
              items: {
                allOf: [
                  {
                    properties: {
                      id: {
                        type: 'string';
                      };
                    };
                  },
                  {
                    allOf: [
                      {
                        description: 'Registrant base object.';
                        properties: {
                          address: {
                            description: "Registrant's address.";
                            type: 'string';
                          };
                          city: {
                            description: "Registrant's city.";
                            type: 'string';
                          };
                          comments: {
                            description: 'A field that allows registrants to provide any questions or comments that they might have.';
                            type: 'string';
                          };
                          country: {
                            description: "Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.";
                            type: 'string';
                          };
                          custom_questions: {
                            description: 'Custom questions.';
                            items: {
                              description: 'Custom Question.';
                              properties: {
                                title: {
                                  type: 'string';
                                };
                                value: {
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                          email: {
                            description: 'A valid email address of the registrant.';
                            maxLength: 128;
                            type: 'string';
                          };
                          first_name: {
                            description: "Registrant's first name.";
                            maxLength: 64;
                            type: 'string';
                          };
                          industry: {
                            description: "Registrant's Industry.";
                            type: 'string';
                          };
                          job_title: {
                            description: "Registrant's job title.";
                            type: 'string';
                          };
                          last_name: {
                            description: "Registrant's last name.";
                            maxLength: 64;
                            type: 'string';
                          };
                          no_of_employees: {
                            description: 'Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`';
                            type: 'string';
                          };
                          org: {
                            description: "Registrant's Organization.";
                            type: 'string';
                          };
                          phone: {
                            description: "Registrant's Phone number.";
                            type: 'string';
                          };
                          purchasing_time_frame: {
                            description: 'This field can be included to gauge interest of webinar attendees towards buying your product or service.\n\nPurchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`';
                            type: 'string';
                          };
                          role_in_purchase_process: {
                            description: 'Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved` ';
                            type: 'string';
                          };
                          state: {
                            description: "Registrant's State/Province.";
                            type: 'string';
                          };
                          zip: {
                            description: "Registrant's Zip/Postal Code.";
                            type: 'string';
                          };
                        };
                        required: ['email', 'first_name'];
                        type: 'object';
                      },
                    ];
                    description: ' Registrant.';
                    type: 'object';
                  },
                ];
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'List of Recording Registration';
      title: 'Recording Registration List';
      type: 'object';
    };
    RecordingRegistrantQuestions: {
      description: 'Recording Registrant Questions';
      properties: {
        custom_questions: {
          description: 'Array of Registrant Custom Questions';
          items: {
            properties: {
              answers: {
                description: 'Answer choices for the question. Can not be used with Short answer type.';
                items: {
                  type: 'string';
                };
                type: 'array';
              };
              required: {
                description: 'State whether registrants are required to answer custom questions or not.';
                type: 'boolean';
              };
              title: {
                description: 'Title of the question.';
                type: 'string';
              };
              type: {
                description: 'The type of registration question and answers.';
                enum: ['short', 'single', 'multiple'];
                type: 'string';
                'x-enum-descriptions': ['Short Answer', 'Single Answer', 'Multiple Answer'];
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        questions: {
          description: 'Array of Registrant Questions';
          items: {
            properties: {
              field_name: {
                description: 'Field name.';
                enum: [
                  'last_name',
                  'address',
                  'city',
                  'country',
                  'zip',
                  'state',
                  'phone',
                  'industry',
                  'org',
                  'job_title',
                  'purchasing_time_frame',
                  'role_in_purchase_process',
                  'no_of_employees',
                  'comments',
                ];
                type: 'string';
                'x-enum-descriptions': [
                  'Last Name',
                  'Address',
                  'City',
                  'Country/Region',
                  'Zip/Postal Code',
                  'State/Province',
                  'Phone',
                  'Industry',
                  'Organization',
                  'Job Title',
                  'Purchasing Time Frame',
                  'Role in Purchase Process',
                  'Number of Employees',
                  'Questions & Comments',
                ];
              };
              required: {
                description: 'State whether the field is required to be answered by the registrant or not.';
                type: 'boolean';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
      };
      title: 'Recording Registrant Questions';
      type: 'object';
    };
    RecordingRegistrantStatus: {
      description: 'Registrant Status';
      properties: {
        action: {
          enum: ['approve', 'deny'];
          type: 'string';
          'x-enum-descriptions': ['Approve registrant', 'Deny registrant'];
        };
        registrants: {
          description: 'List of registrants';
          items: {
            properties: {
              id: {
                type: 'string';
              };
            };
          };
          maximum: 30;
          type: 'array';
        };
      };
      required: ['action'];
      type: 'object';
    };
    RecordingSettings: {
      properties: {
        approval_type: {
          description: 'Approval type for the registration.<br>\n`0`- Automatically approve the registration when a user registers.<br>\n`1` - Manually approve or deny the registration of a user.<br>\n`2` - No registration required to view the recording.';
          enum: [0, 1, 2];
          type: 'integer';
          'x-enum-descriptions': [
            'Registrants can watch the recording directly after registration',
            'Registrants will receive emails then watch the recording after you approve the registration',
            'Disabled',
          ];
        };
        authentication_domains: {
          description: 'Authentication domains.';
          type: 'string';
        };
        authentication_option: {
          description: 'Authentication Options.';
          type: 'string';
        };
        on_demand: {
          description: 'Determine whether registration  isrequired to view the recording.';
          type: 'boolean';
        };
        password: {
          description: 'Enable password protection for the recording by setting a password. The password must have a minimum of **eight** characters with a mix of numbers, letters and special characters.<br><br>\n**Note:** If the account owner or the admin has set minimum password strength requirements for recordings via Account Settings, the password value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API. ';
          maxLength: 10;
          minLength: 8;
          type: 'string';
        };
        recording_authentication: {
          description: 'Only authenticated users can view.';
          type: 'boolean';
        };
        send_email_to_host: {
          description: 'Send an email to host when someone registers to view the recording. This applies for On-demand recordings only.';
          type: 'boolean';
        };
        share_recording: {
          description: 'Determine how the meeting recording is shared.';
          enum: ['publicly', 'internally', 'none'];
          type: 'string';
          'x-enum-descriptions': ['Publicly', 'Internally(account members only)', 'None'];
        };
        show_social_share_buttons: {
          description: 'Show social share buttons on registration page. This applies for On-demand recordings only.';
          type: 'boolean';
        };
        topic: {
          description: 'Name of the recording.';
          type: 'string';
        };
        viewer_download: {
          description: 'Determine whether a viewer can download the recording file or not.';
          type: 'boolean';
        };
      };
      title: 'Recording settings';
      type: 'object';
    };
    Recurrence: {
      description: 'Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time. ';
      properties: {
        end_date_time: {
          description: 'Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
          format: 'date-time';
          type: 'string';
        };
        end_times: {
          default: 1;
          description: 'Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)';
          maximum: 365;
          type: 'integer';
        };
        monthly_day: {
          default: 1;
          description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
          type: 'integer';
        };
        monthly_week: {
          description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
          enum: [-1, 1, 2, 3, 4];
          type: 'integer';
          'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
        };
        monthly_week_day: {
          description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field. \n\n<br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
          enum: [1, 2, 3, 4, 5, 6, 7];
          type: 'integer';
          'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        };
        repeat_interval: {
          description: 'Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.\n\n';
          type: 'integer';
        };
        type: {
          description: 'Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
          enum: [1, 2, 3];
          type: 'integer';
          'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
        };
        weekly_days: {
          default: '1';
          description: 'This field is required **if you\'re scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.';
          enum: ['1', '2', '3', '4', '5', '6', '7'];
          type: 'string';
        };
      };
      required: ['type'];
      type: 'object';
    };
    Registrant: {
      description: 'Registrant base object.';
      properties: {
        address: {
          description: "Registrant's address.";
          type: 'string';
        };
        city: {
          description: "Registrant's city.";
          type: 'string';
        };
        comments: {
          description: 'A field that allows registrants to provide any questions or comments that they might have.';
          type: 'string';
        };
        country: {
          description: "Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.";
          type: 'string';
        };
        custom_questions: {
          description: 'Custom questions.';
          items: {
            description: 'Custom Question.';
            properties: {
              title: {
                type: 'string';
              };
              value: {
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        email: {
          description: 'A valid email address of the registrant.';
          maxLength: 128;
          type: 'string';
        };
        first_name: {
          description: "Registrant's first name.";
          maxLength: 64;
          type: 'string';
        };
        industry: {
          description: "Registrant's Industry.";
          type: 'string';
        };
        job_title: {
          description: "Registrant's job title.";
          type: 'string';
        };
        last_name: {
          description: "Registrant's last name.";
          maxLength: 64;
          type: 'string';
        };
        no_of_employees: {
          description: 'Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`';
          type: 'string';
        };
        org: {
          description: "Registrant's Organization.";
          type: 'string';
        };
        phone: {
          description: "Registrant's Phone number.";
          type: 'string';
        };
        purchasing_time_frame: {
          description: 'This field can be included to gauge interest of webinar attendees towards buying your product or service.\n\nPurchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`';
          type: 'string';
        };
        role_in_purchase_process: {
          description: 'Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved` ';
          type: 'string';
        };
        state: {
          description: "Registrant's State/Province.";
          type: 'string';
        };
        zip: {
          description: "Registrant's Zip/Postal Code.";
          type: 'string';
        };
      };
      required: ['email', 'first_name'];
      type: 'object';
    };
    RegistrantList: {
      allOf: [
        {
          description: 'Pagination Object.';
          properties: {
            next_page_token: {
              description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
              type: 'string';
            };
            page_count: {
              description: 'The number of pages returned for the request made.';
              type: 'integer';
            };
            page_number: {
              default: 1;
              description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
              type: 'integer';
            };
            page_size: {
              default: 30;
              description: 'The number of records returned with a single API call.';
              maximum: 300;
              type: 'integer';
            };
            total_records: {
              description: 'The total number of all the records available across pages.';
              type: 'integer';
            };
          };
          type: 'object';
        },
        {
          properties: {
            registrants: {
              description: 'List of registrant objects.';
              items: {
                allOf: [
                  {
                    properties: {
                      id: {
                        description: 'Registrant ID.';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  },
                  {
                    allOf: [
                      {
                        description: 'Registrant base object.';
                        properties: {
                          address: {
                            description: "Registrant's address.";
                            type: 'string';
                          };
                          city: {
                            description: "Registrant's city.";
                            type: 'string';
                          };
                          comments: {
                            description: 'A field that allows registrants to provide any questions or comments that they might have.';
                            type: 'string';
                          };
                          country: {
                            description: "Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.";
                            type: 'string';
                          };
                          custom_questions: {
                            description: 'Custom questions.';
                            items: {
                              description: 'Custom Question.';
                              properties: {
                                title: {
                                  type: 'string';
                                };
                                value: {
                                  type: 'string';
                                };
                              };
                              type: 'object';
                            };
                            type: 'array';
                          };
                          email: {
                            description: 'A valid email address of the registrant.';
                            maxLength: 128;
                            type: 'string';
                          };
                          first_name: {
                            description: "Registrant's first name.";
                            maxLength: 64;
                            type: 'string';
                          };
                          industry: {
                            description: "Registrant's Industry.";
                            type: 'string';
                          };
                          job_title: {
                            description: "Registrant's job title.";
                            type: 'string';
                          };
                          last_name: {
                            description: "Registrant's last name.";
                            maxLength: 64;
                            type: 'string';
                          };
                          no_of_employees: {
                            description: 'Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`';
                            type: 'string';
                          };
                          org: {
                            description: "Registrant's Organization.";
                            type: 'string';
                          };
                          phone: {
                            description: "Registrant's Phone number.";
                            type: 'string';
                          };
                          purchasing_time_frame: {
                            description: 'This field can be included to gauge interest of webinar attendees towards buying your product or service.\n\nPurchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`';
                            type: 'string';
                          };
                          role_in_purchase_process: {
                            description: 'Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved` ';
                            type: 'string';
                          };
                          state: {
                            description: "Registrant's State/Province.";
                            type: 'string';
                          };
                          zip: {
                            description: "Registrant's Zip/Postal Code.";
                            type: 'string';
                          };
                        };
                        required: ['email', 'first_name'];
                        type: 'object';
                      },
                    ];
                    description: ' Registrant.';
                    type: 'object';
                  },
                  {
                    properties: {
                      create_time: {
                        description: 'The time at which the registrant registered.';
                        format: 'date-time';
                        type: 'string';
                      };
                      join_url: {
                        description: 'The URL using which an approved registrant can join the webinar.';
                        format: 'string';
                        type: 'string';
                      };
                      status: {
                        description: "The status of the registrant's registration. <br> `approved`: User has been successfully approved for the webinar.<br> `pending`:  The registration is still pending.<br> `denied`: User has been denied from joining the webinar.";
                        type: 'string';
                      };
                    };
                    type: 'object';
                  },
                ];
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'List of users.';
      title: 'Registration List';
      type: 'object';
    };
    RegistrantStatus: {
      properties: {
        action: {
          description: "Registrant Status:<br>`approve` - Approve registrant.<br>`cancel` - Cancel previously approved registrant's registration.<br>`deny` - Deny registrant.";
          enum: ['approve', 'cancel', 'deny'];
          type: 'string';
          'x-enum-descriptions': ['Approve registrant', 'Cancel previously approved registrant', 'Deny registrant'];
        };
        registrants: {
          description: 'List of registrants.';
          items: {
            properties: {
              email: {
                type: 'string';
              };
              id: {
                type: 'string';
              };
            };
            type: 'object';
          };
          maximum: 30;
          type: 'array';
        };
      };
      required: ['action'];
      type: 'object';
    };
    RoleList: {
      allOf: [
        {
          properties: {
            roles: {
              description: 'List of Roles objects';
              items: {
                allOf: [
                  {
                    properties: {
                      description: {
                        description: 'Role Description';
                        type: 'string';
                      };
                      id: {
                        description: 'Role Id';
                        type: 'string';
                      };
                      name: {
                        description: 'Role Name';
                        type: 'string';
                      };
                      total_members: {
                        description: 'Total members in this role';
                        type: 'integer';
                      };
                    };
                  },
                ];
              };
              type: 'array';
            };
            total_records: {
              description: 'The number of all records available across pages';
              type: 'integer';
            };
          };
        },
      ];
      description: 'List of Roles';
      title: 'Role List';
      type: 'object';
    };
    RoleMembersAdd: {
      description: 'Add Role Members';
      properties: {
        members: {
          description: "List of Role's members";
          items: {
            properties: {
              email: {
                description: 'User email address. Must have id or email, if given id, the email is ignored.';
                type: 'string';
              };
              id: {
                description: 'User ID';
                type: 'string';
              };
            };
          };
          maximum: 30;
          type: 'array';
        };
      };
      title: 'Add Role Members';
      type: 'object';
    };
    RoleMembersList: {
      description: 'List of a Role Members';
      properties: {
        members: {
          description: 'List of a Role Members';
          items: {
            allOf: [
              {
                properties: {
                  department: {
                    description: 'Member Department';
                    type: 'string';
                  };
                  email: {
                    description: 'Member Email';
                    type: 'string';
                  };
                  first_name: {
                    description: 'Member First Name';
                    type: 'string';
                  };
                  id: {
                    description: 'Member ID';
                    type: 'string';
                  };
                  last_name: {
                    description: 'Member Last Name';
                    type: 'string';
                  };
                  type: {
                    description: 'Member Type';
                    type: 'integer';
                  };
                };
              },
            ];
            type: 'object';
          };
          type: 'array';
        };
        next_page_token: {
          description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
          type: 'string';
        };
        page_count: {
          description: 'The number of pages returned for the request made.';
          type: 'integer';
        };
        page_number: {
          default: 1;
          description: 'The page number of the current results.';
          type: 'integer';
        };
        page_size: {
          default: 30;
          description: 'The number of records returned within a single API call.';
          maximum: 300;
          type: 'integer';
        };
        total_records: {
          description: 'The total number of all the records available across pages.';
          type: 'integer';
        };
      };
      title: 'Role Members List';
      type: 'object';
    };
    Session: {
      description: 'Base object for sessions.';
      properties: {
        agenda: {
          description: 'Meeting description.';
          type: 'string';
        };
        duration: {
          description: 'Meeting duration (minutes). Used for scheduled meetings only.';
          type: 'integer';
        };
        password: {
          description: 'Password to join the meeting. Password may only contain the following characters: [a-z A-Z 0-9 @ - _ *]. Max of 10 characters.';
          type: 'string';
        };
        recurrence: {
          description: 'Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time. ';
          properties: {
            end_date_time: {
              description: 'Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
              format: 'date-time';
              type: 'string';
            };
            end_times: {
              default: 1;
              description: 'Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)';
              maximum: 365;
              type: 'integer';
            };
            monthly_day: {
              default: 1;
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
              type: 'integer';
            };
            monthly_week: {
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
              enum: [-1, 1, 2, 3, 4];
              type: 'integer';
              'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
            };
            monthly_week_day: {
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field. \n\n<br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
              enum: [1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
            };
            repeat_interval: {
              description: 'Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.\n\n';
              type: 'integer';
            };
            type: {
              description: 'Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
            };
            weekly_days: {
              default: '1';
              description: 'This field is required **if you\'re scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.';
              enum: ['1', '2', '3', '4', '5', '6', '7'];
              type: 'string';
            };
          };
          required: ['type'];
          type: 'object';
        };
        settings: {
          description: 'Meeting settings.';
          properties: {
            allow_multiple_devices: {
              description: 'Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
              type: 'boolean';
            };
            alternative_hosts: {
              description: "Alternative host's emails or IDs: multiple values are separated by a semicolon.";
              type: 'string';
            };
            alternative_hosts_email_notification: {
              default: true;
              description: 'Flag to determine whether to send email notifications to alternative hosts, default value is true.';
              type: 'boolean';
            };
            approval_type: {
              default: 2;
              description: 'Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>\n\n`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
              enum: [0, 1, 2];
              type: 'integer';
              'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
            };
            approved_or_denied_countries_or_regions: {
              description: 'Approve or block users from specific regions/countries from joining this meeting. \n';
              properties: {
                approved_list: {
                  description: 'List of countries/regions from where participants can join this meeting. ';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                denied_list: {
                  description: 'List of countries/regions from where participants can not join this meeting. ';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                enable: {
                  description: '`true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>\n\n`false`: Setting disabled.';
                  type: 'boolean';
                };
                method: {
                  description: 'Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>\n`approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>\n`deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`';
                  enum: ['approve', 'deny'];
                  type: 'string';
                };
              };
              type: 'object';
            };
            audio: {
              default: 'both';
              description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.';
              enum: ['both', 'telephony', 'voip'];
              type: 'string';
              'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
            };
            authentication_domains: {
              description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
              type: 'string';
            };
            authentication_exception: {
              description: 'The participants added here will receive unique meeting invite links and bypass authentication.';
              items: {
                properties: {
                  email: {
                    description: 'Email address of the participant.';
                    format: 'email';
                    type: 'string';
                  };
                  name: {
                    description: 'Name of the participant.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            authentication_name: {
              description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
              type: 'string';
            };
            authentication_option: {
              description: 'Meeting authentication option id.';
              type: 'string';
            };
            auto_recording: {
              default: 'none';
              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
              enum: ['local', 'cloud', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
            };
            breakout_room: {
              description: 'Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).';
              properties: {
                enable: {
                  description: 'Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.';
                  type: 'boolean';
                };
                rooms: {
                  description: 'Create room(s).';
                  items: {
                    properties: {
                      name: {
                        description: 'Name of the breakout room.';
                        type: 'string';
                      };
                      participants: {
                        description: 'Email addresses of the participants who are to be assigned to the breakout room.';
                        items: {
                          type: 'string';
                        };
                        type: 'array';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            close_registration: {
              default: false;
              description: 'Close registration after event date';
              type: 'boolean';
            };
            cn_meeting: {
              default: false;
              description: 'Host meeting in China.';
              type: 'boolean';
            };
            contact_email: {
              description: 'Contact email for registration';
              type: 'string';
            };
            contact_name: {
              description: 'Contact name for registration';
              type: 'string';
            };
            custom_keys: {
              description: 'Custom keys and values assigned to the meeting.';
              items: {
                properties: {
                  key: {
                    description: 'Custom key associated with the user.';
                    maxLength: 64;
                    type: 'string';
                  };
                  value: {
                    description: 'Value of the custom key associated with the user.';
                    maxLength: 256;
                    type: 'string';
                  };
                };
                type: 'object';
              };
              maxItems: 10;
              type: 'array';
            };
            encryption_type: {
              description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
              enum: ['enhanced_encryption', 'e2ee'];
              type: 'string';
            };
            enforce_login: {
              description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
              type: 'boolean';
            };
            enforce_login_domains: {
              description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
              type: 'string';
            };
            global_dial_in_countries: {
              description: 'List of global dial-in countries';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            global_dial_in_numbers: {
              description: 'Global Dial-in Countries/Regions';
              items: {
                properties: {
                  city: {
                    description: 'City of the number, if any. For example, Chicago.';
                    type: 'string';
                  };
                  country: {
                    description: 'Country code. For example, BR.';
                    type: 'string';
                  };
                  country_name: {
                    description: 'Full name of country. For example, Brazil.';
                    type: 'string';
                  };
                  number: {
                    description: 'Phone number. For example, +1 2332357613.';
                    type: 'string';
                  };
                  type: {
                    description: 'Type of number. ';
                    enum: ['toll', 'tollfree'];
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            host_video: {
              description: 'Start video when the host joins the meeting.';
              type: 'boolean';
            };
            in_meeting: {
              default: false;
              description: 'Host meeting in India.';
              type: 'boolean';
            };
            jbh_time: {
              description: 'If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:\n\n*  `0`: Allow participant to join anytime.\n*  `5`: Allow participant to join 5 minutes before meeting start time.\n * `10`: Allow participant to join 10 minutes before meeting start time.';
              enum: [0, 5, 10];
              type: 'integer';
            };
            join_before_host: {
              default: false;
              description: 'Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.';
              type: 'boolean';
            };
            language_interpretation: {
              properties: {
                enable: {
                  type: 'boolean';
                };
                interpreters: {
                  description: 'Information associated with the interpreter.';
                  items: {
                    properties: {
                      email: {
                        description: 'Email address of the interpreter.';
                        format: 'email';
                        type: 'string';
                      };
                      languages: {
                        description: 'Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma. \n\nFor example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            meeting_authentication: {
              description: '`true`- Only authenticated users can join meetings.';
              type: 'boolean';
            };
            mute_upon_entry: {
              default: false;
              description: 'Mute participants upon entry.';
              type: 'boolean';
            };
            participant_video: {
              description: 'Start video when participants join the meeting.';
              type: 'boolean';
            };
            registrants_confirmation_email: {
              description: 'Send confirmation email to registrants upon successful registration.';
              type: 'boolean';
            };
            registrants_email_notification: {
              description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
              type: 'boolean';
            };
            registration_type: {
              default: 1;
              description: 'Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': [
                'Attendees register once and can attend any of the occurrences',
                'Attendees need to register for each occurrence to attend',
                'Attendees register once and can choose one or more occurrences to attend',
              ];
            };
            show_share_button: {
              description: 'Show social share buttons on the meeting registration page.\nThis setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
              type: 'boolean';
            };
            use_pmi: {
              default: false;
              description: 'Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.';
              type: 'boolean';
            };
            waiting_room: {
              default: false;
              description: 'Enable waiting room';
              type: 'boolean';
            };
            watermark: {
              default: false;
              description: 'Add watermark when viewing a shared screen.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        start_time: {
          description: "Meeting start time. When using a format like \"yyyy-MM-dd'T'HH:mm:ss'Z'\", always use GMT time. When using a format like \"yyyy-MM-dd'T'HH:mm:ss\", you should use local time and specify the time zone. This is only used for scheduled meetings and recurring meetings with a fixed time.";
          format: 'date-time';
          type: 'string';
        };
        timezone: {
          description: 'Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) list for supported time zones and their formats.';
          type: 'string';
        };
        topic: {
          description: 'Meeting topic.';
          type: 'string';
        };
        tracking_fields: {
          description: 'Tracking fields';
          items: {
            properties: {
              field: {
                description: 'Tracking fields type';
                type: 'string';
              };
              value: {
                description: 'Tracking fields value';
                type: 'string';
              };
            };
          };
          type: 'array';
        };
        type: {
          default: 2;
          description: 'Meeting Type:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.';
          enum: [1, 2, 3, 8];
          type: 'integer';
          'x-enum-descriptions': [
            'Instant Meeting',
            'Scheduled Meeting',
            'Recurring Meeting with no fixed time',
            'Recurring Meeting with fixed time',
          ];
        };
      };
      type: 'object';
    };
    SessionUpdate: {
      description: 'Base object for sessions.';
      properties: {
        agenda: {
          description: 'Meeting description.';
          maxLength: 2000;
          type: 'string';
        };
        duration: {
          description: 'Meeting duration (minutes). Used for scheduled meetings only.';
          type: 'integer';
        };
        password: {
          description: 'Meeting passcode. Passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ *] and can have a maximum of 10 characters.\n\n**Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the  [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API. ';
          maxLength: 10;
          type: 'string';
        };
        recurrence: {
          description: 'Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time. ';
          properties: {
            end_date_time: {
              description: 'Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
              format: 'date-time';
              type: 'string';
            };
            end_times: {
              default: 1;
              description: 'Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)';
              maximum: 365;
              type: 'integer';
            };
            monthly_day: {
              default: 1;
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
              type: 'integer';
            };
            monthly_week: {
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
              enum: [-1, 1, 2, 3, 4];
              type: 'integer';
              'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
            };
            monthly_week_day: {
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field. \n\n<br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
              enum: [1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
            };
            repeat_interval: {
              description: 'Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.\n\n';
              type: 'integer';
            };
            type: {
              description: 'Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
            };
            weekly_days: {
              default: '1';
              description: 'This field is required **if you\'re scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.';
              enum: ['1', '2', '3', '4', '5', '6', '7'];
              type: 'string';
            };
          };
          required: ['type'];
          type: 'object';
        };
        settings: {
          allOf: [
            {
              description: 'Meeting settings.';
              properties: {
                allow_multiple_devices: {
                  description: 'Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
                  type: 'boolean';
                };
                alternative_hosts: {
                  description: "Alternative host's emails or IDs: multiple values are separated by a semicolon.";
                  type: 'string';
                };
                alternative_hosts_email_notification: {
                  default: true;
                  description: 'Flag to determine whether to send email notifications to alternative hosts, default value is true.';
                  type: 'boolean';
                };
                approval_type: {
                  default: 2;
                  description: 'Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>\n\n`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
                  enum: [0, 1, 2];
                  type: 'integer';
                  'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
                };
                approved_or_denied_countries_or_regions: {
                  description: 'Approve or block users from specific regions/countries from joining this meeting. \n';
                  properties: {
                    approved_list: {
                      description: 'List of countries/regions from where participants can join this meeting. ';
                      items: {
                        type: 'string';
                      };
                      type: 'array';
                    };
                    denied_list: {
                      description: 'List of countries/regions from where participants can not join this meeting. ';
                      items: {
                        type: 'string';
                      };
                      type: 'array';
                    };
                    enable: {
                      description: '`true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>\n\n`false`: Setting disabled.';
                      type: 'boolean';
                    };
                    method: {
                      description: 'Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>\n`approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>\n`deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`';
                      enum: ['approve', 'deny'];
                      type: 'string';
                    };
                  };
                  type: 'object';
                };
                audio: {
                  default: 'both';
                  description: 'Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.';
                  enum: ['both', 'telephony', 'voip'];
                  type: 'string';
                  'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
                };
                authentication_domains: {
                  description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
                  type: 'string';
                };
                authentication_exception: {
                  description: 'The participants added here will receive unique meeting invite links and bypass authentication.';
                  items: {
                    properties: {
                      email: {
                        description: 'Email address of the participant.';
                        format: 'email';
                        type: 'string';
                      };
                      name: {
                        description: 'Name of the participant.';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
                authentication_name: {
                  description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
                  type: 'string';
                };
                authentication_option: {
                  description: 'Meeting authentication option id.';
                  type: 'string';
                };
                auto_recording: {
                  default: 'none';
                  description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
                  enum: ['local', 'cloud', 'none'];
                  type: 'string';
                  'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
                };
                breakout_room: {
                  description: 'Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).';
                  properties: {
                    enable: {
                      description: 'Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.';
                      type: 'boolean';
                    };
                    rooms: {
                      description: 'Create room(s).';
                      items: {
                        properties: {
                          name: {
                            description: 'Name of the breakout room.';
                            type: 'string';
                          };
                          participants: {
                            description: 'Email addresses of the participants who are to be assigned to the breakout room.';
                            items: {
                              type: 'string';
                            };
                            type: 'array';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
                close_registration: {
                  default: false;
                  description: 'Close registration after event date';
                  type: 'boolean';
                };
                cn_meeting: {
                  default: false;
                  description: 'Host meeting in China.';
                  type: 'boolean';
                };
                contact_email: {
                  description: 'Contact email for registration';
                  type: 'string';
                };
                contact_name: {
                  description: 'Contact name for registration';
                  type: 'string';
                };
                custom_keys: {
                  description: 'Custom keys and values assigned to the meeting.';
                  items: {
                    properties: {
                      key: {
                        description: 'Custom key associated with the user.';
                        maxLength: 64;
                        type: 'string';
                      };
                      value: {
                        description: 'Value of the custom key associated with the user.';
                        maxLength: 256;
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  maxItems: 10;
                  type: 'array';
                };
                encryption_type: {
                  description: 'Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>\n`enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>\n\n`e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.';
                  enum: ['enhanced_encryption', 'e2ee'];
                  type: 'string';
                };
                enforce_login: {
                  description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
                  type: 'boolean';
                };
                enforce_login_domains: {
                  description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.';
                  type: 'string';
                };
                global_dial_in_countries: {
                  description: 'List of global dial-in countries';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                global_dial_in_numbers: {
                  description: 'Global Dial-in Countries/Regions';
                  items: {
                    properties: {
                      city: {
                        description: 'City of the number, if any. For example, Chicago.';
                        type: 'string';
                      };
                      country: {
                        description: 'Country code. For example, BR.';
                        type: 'string';
                      };
                      country_name: {
                        description: 'Full name of country. For example, Brazil.';
                        type: 'string';
                      };
                      number: {
                        description: 'Phone number. For example, +1 2332357613.';
                        type: 'string';
                      };
                      type: {
                        description: 'Type of number. ';
                        enum: ['toll', 'tollfree'];
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
                host_video: {
                  description: 'Start video when the host joins the meeting.';
                  type: 'boolean';
                };
                in_meeting: {
                  default: false;
                  description: 'Host meeting in India.';
                  type: 'boolean';
                };
                jbh_time: {
                  description: 'If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:\n\n*  `0`: Allow participant to join anytime.\n*  `5`: Allow participant to join 5 minutes before meeting start time.\n * `10`: Allow participant to join 10 minutes before meeting start time.';
                  enum: [0, 5, 10];
                  type: 'integer';
                };
                join_before_host: {
                  default: false;
                  description: 'Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.';
                  type: 'boolean';
                };
                language_interpretation: {
                  properties: {
                    enable: {
                      type: 'boolean';
                    };
                    interpreters: {
                      description: 'Information associated with the interpreter.';
                      items: {
                        properties: {
                          email: {
                            description: 'Email address of the interpreter.';
                            format: 'email';
                            type: 'string';
                          };
                          languages: {
                            description: 'Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma. \n\nFor example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      };
                      type: 'array';
                    };
                  };
                  type: 'object';
                };
                meeting_authentication: {
                  description: '`true`- Only authenticated users can join meetings.';
                  type: 'boolean';
                };
                mute_upon_entry: {
                  default: false;
                  description: 'Mute participants upon entry.';
                  type: 'boolean';
                };
                participant_video: {
                  description: 'Start video when participants join the meeting.';
                  type: 'boolean';
                };
                registrants_confirmation_email: {
                  description: 'Send confirmation email to registrants upon successful registration.';
                  type: 'boolean';
                };
                registrants_email_notification: {
                  description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
                  type: 'boolean';
                };
                registration_type: {
                  default: 1;
                  description: 'Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.';
                  enum: [1, 2, 3];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Attendees register once and can attend any of the occurrences',
                    'Attendees need to register for each occurrence to attend',
                    'Attendees register once and can choose one or more occurrences to attend',
                  ];
                };
                show_share_button: {
                  description: 'Show social share buttons on the meeting registration page.\nThis setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).';
                  type: 'boolean';
                };
                use_pmi: {
                  default: false;
                  description: 'Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.';
                  type: 'boolean';
                };
                waiting_room: {
                  default: false;
                  description: 'Enable waiting room';
                  type: 'boolean';
                };
                watermark: {
                  default: false;
                  description: 'Add watermark when viewing a shared screen.';
                  type: 'boolean';
                };
              };
              type: 'object';
            },
            {
              properties: {
                registrants_confirmation_email: {
                  description: 'Send confirmation Email to Registrants';
                  type: 'boolean';
                };
              };
              type: 'object';
            },
          ];
        };
        start_time: {
          description: "Meeting start time. When using a format like \"yyyy-MM-dd'T'HH:mm:ss'Z'\", always use GMT time. When using a format like \"yyyy-MM-dd'T'HH:mm:ss\", you should use local time and  specify the time zone. Only used for scheduled meetings and recurring meetings with a fixed time.";
          format: 'date-time';
          type: 'string';
        };
        template_id: {
          description: 'Unique identifier of the meeting template. \n\nUse this field if you would like to [schedule the meeting from a meeting template](https://support.zoom.us/hc/en-us/articles/360036559151-Meeting-templates#h_86f06cff-0852-4998-81c5-c83663c176fb). You can retrieve the value of this field by calling the [List meeting templates]() API.';
          type: 'string';
        };
        timezone: {
          description: 'Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.';
          type: 'string';
        };
        topic: {
          description: 'Meeting topic.';
          type: 'string';
        };
        tracking_fields: {
          description: 'Tracking fields';
          items: {
            properties: {
              field: {
                description: 'Tracking fields type';
                type: 'string';
              };
              value: {
                description: 'Tracking fields value';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        type: {
          default: 2;
          description: 'Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with a fixed time.';
          enum: [1, 2, 3, 8];
          type: 'integer';
          'x-enum-descriptions': [
            'Instant Meeting',
            'Scheduled Meeting',
            'Recurring Meeting with no fixed time',
            'Recurring Meeting with fixed time',
          ];
        };
      };
      type: 'object';
    };
    SessionWebinar: {
      description: 'Base webinar object for sessions.';
      properties: {
        agenda: {
          description: 'Webinar description.';
          type: 'string';
        };
        duration: {
          description: 'Webinar duration (minutes). Used for scheduled webinars only.';
          type: 'integer';
        };
        password: {
          description: 'Webinar Passcode. Passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ *]. Max of 10 characters.';
          type: 'string';
        };
        recurrence: {
          description: 'Recurrence object. Use this object only for a webinar of type `9` i.e., a recurring webinar with fixed time. ';
          properties: {
            end_date_time: {
              description: 'Select a date when the webinar will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
              format: 'date-time';
              type: 'string';
            };
            end_times: {
              default: 1;
              description: 'Select how many times the webinar will recur before it is canceled. (Cannot be used with "end_date_time".)';
              maximum: 365;
              type: 'integer';
            };
            monthly_day: {
              description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state which day in a month, the webinar should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the webinar to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the webinar to recur once every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
              type: 'integer';
            };
            monthly_week: {
              description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state the week of the month when the webinar should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the webinar should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
              enum: [-1, 1, 2, 3, 4];
              type: 'integer';
              'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
            };
            monthly_week_day: {
              description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state a specific day in a week when the monthly webinar should recur. To use this field, you must also use the `monthly_week` field. <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
              enum: [1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
            };
            repeat_interval: {
              description: 'Define the interval at which the webinar should recur. For instance, if you would like to schedule a Webinar that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily webinar, the maximum interval you can set is `90` days. For a weekly webinar, the maximum interval that you can set is `12` weeks. For a monthly webinar, the maximum interval that you can set is `3` months.';
              type: 'integer';
            };
            type: {
              description: 'Recurrence webinar types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
            };
            weekly_days: {
              description: 'Use this field **only if you\'re scheduling a recurring webinar of type** `2` to state which day(s) of the week the webinar should repeat. <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the Webinar should recur on Sunday, provide `"1"` as the value of this field.  <br><br> **Note:** If you would like the webinar to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the Webinar should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n<br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.\n\n';
              type: 'string';
            };
          };
          required: ['type'];
          title: 'Recurrence Webinar';
          type: 'object';
        };
        settings: {
          description: 'Webinar settings.';
          properties: {
            allow_multiple_devices: {
              description: 'Allow attendees to join from multiple devices.';
              type: 'boolean';
            };
            alternative_hosts: {
              description: 'Alternative host emails or IDs. Multiple values separated by comma.';
              type: 'string';
            };
            approval_type: {
              default: 2;
              description: '`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
              enum: [0, 1, 2];
              type: 'integer';
              'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
            };
            attendees_and_panelists_reminder_email_notification: {
              description: 'Send reminder email to attendees and panelists.';
              properties: {
                enable: {
                  description: '* `true`: Send reminder email to attendees and panelists.\n\n* `false`: Do not send reminder email to attendees and panelists.';
                  type: 'boolean';
                };
                type: {
                  description: '`0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.';
                  enum: [0, 1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Send 1 hour before webinar.',
                    'Send 1 day before webinar.',
                    'Send 1 hour and 1 day before webinar.',
                    'Send 1 week before webinar.',
                    'Send 1 hour and 1 week before webinar.',
                    'Send 1 day and 1 week before webinar.',
                    'Send 1 hour, 1 day and 1 week before webinar.',
                  ];
                };
              };
              type: 'object';
            };
            audio: {
              default: 'both';
              description: 'Determine how participants can join the audio portion of the webinar.';
              enum: ['both', 'telephony', 'voip'];
              type: 'string';
              'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
            };
            authentication_domains: {
              description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
              type: 'string';
            };
            authentication_name: {
              description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
              type: 'string';
            };
            authentication_option: {
              description: 'Webinar authentication option id.';
              type: 'string';
            };
            auto_recording: {
              default: 'none';
              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
              enum: ['local', 'cloud', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
            };
            close_registration: {
              description: 'Close registration after event date.';
              type: 'boolean';
            };
            contact_email: {
              description: 'Contact email for registration';
              type: 'string';
            };
            contact_name: {
              description: 'Contact name for registration';
              type: 'string';
            };
            email_language: {
              description: 'Set the email language to one of the following:\n`en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.';
              type: 'string';
            };
            enforce_login: {
              description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.';
              type: 'boolean';
            };
            enforce_login_domains: {
              description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.';
              type: 'string';
            };
            follow_up_absentees_email_notification: {
              description: 'Send follow-up email to absentees.';
              properties: {
                enable: {
                  description: '* `true`: Send follow-up email to absentees.\n\n* `false`: Do not send follow-up email to absentees.';
                  type: 'boolean';
                };
                type: {
                  description: '`0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
                  enum: [0, 1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Send 1 days after the scheduled end date.',
                    'Send 2 days after the scheduled end date.',
                    'Send 3 days after the scheduled end date.',
                    'Send 4 days after the scheduled end date.',
                    'Send 5 days after the scheduled end date.',
                    'Send 6 days after the scheduled end date.',
                    'Send 7 days after the scheduled end date.',
                  ];
                };
              };
              type: 'object';
            };
            follow_up_attendees_email_notification: {
              description: 'Send follow-up email to attendees.';
              properties: {
                enable: {
                  description: '* `true`: Send follow-up email to attendees.\n\n* `false`: Do not send follow-up email to attendees.';
                  type: 'boolean';
                };
                type: {
                  description: '`0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
                  enum: [0, 1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Send 1 day after the scheduled end date.',
                    'Send 2 days after the scheduled end date.',
                    'Send 3 days after the scheduled end date.',
                    'Send 4 days after the scheduled end date.',
                    'Send 5 days after the scheduled end date.',
                    'Send 6 days after the scheduled end date.',
                    'Send 7 days after the scheduled end date.',
                  ];
                };
              };
              type: 'object';
            };
            global_dial_in_countries: {
              description: 'List of global dial-in countries';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            hd_video: {
              default: false;
              description: 'Default to HD video.';
              type: 'boolean';
            };
            host_video: {
              description: 'Start video when host joins webinar.';
              type: 'boolean';
            };
            meeting_authentication: {
              description: '`true`- Only authenticated users can join Webinar.';
              type: 'boolean';
            };
            notify_registrants: {
              description: 'Send notification email to registrants when the host updates a webinar.';
              type: 'boolean';
            };
            on_demand: {
              default: false;
              description: 'Make the webinar on-demand';
              type: 'boolean';
            };
            panelists_invitation_email_notification: {
              description: '* `true`: Send invitation email to panelists.\n\n* `false`: Do not send invitation email to panelists.';
              type: 'boolean';
            };
            panelists_video: {
              description: 'Start video when panelists join webinar.';
              type: 'boolean';
            };
            post_webinar_survey: {
              description: "Zoom will open a survey page in attendees' browsers after leaving the webinar";
              type: 'boolean';
            };
            practice_session: {
              default: false;
              description: 'Enable practice session.';
              type: 'boolean';
            };
            question_and_answer: {
              description: "[Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.";
              properties: {
                allow_anonymous_questions: {
                  description: '* `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..\n\n* `false`: Do not allow anonymous questions.';
                  type: 'boolean';
                };
                answer_questions: {
                  description: 'Indicate whether you want attendees to be able to view answered questions only or view all questions.\n\n* `only`: Attendees are able to view answered questions only.\n\n*  `all`: Attendees are able to view all questions submitted in the Q&A.';
                  enum: ['only', 'all'];
                  type: 'string';
                };
                attendees_can_comment: {
                  description: '* `true`: Attendees can answer questions or leave a comment in the question thread.\n\n* `false`: Attendees can not answer questions or leave a comment in the question thread';
                  type: 'boolean';
                };
                attendees_can_upvote: {
                  description: '* `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.\n\n* `false`: Attendees can not click the thumbs up butoon on questions.';
                  type: 'boolean';
                };
                enable: {
                  description: "* `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.\n\n* `false`: Disable Q&A for webinar.";
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            registrants_confirmation_email: {
              description: 'Send confirmation email to registrants';
              type: 'boolean';
            };
            registrants_email_notification: {
              description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
              type: 'boolean';
            };
            registrants_restrict_number: {
              default: 0;
              description: 'Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.';
              maximum: 20000;
              minimum: 0;
              type: 'integer';
            };
            registration_type: {
              default: 1;
              description: 'Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': [
                'Attendees register once and can attend any of the occurrences',
                'Attendees need to register for each occurrence to attend',
                'Attendees register once and can choose one or more occurrences to attend',
              ];
            };
            show_share_button: {
              description: 'Show social share buttons on the registration page.';
              type: 'boolean';
            };
            survey_url: {
              description: 'Survey url for post webinar survey';
              type: 'string';
            };
          };
          type: 'object';
        };
        start_time: {
          description: 'Webinar start time. We support two formats for `start_time` - local time and GMT.<br> \n\nTo set time as GMT the format should be `yyyy-MM-dd`T`HH:mm:ssZ`.\n\nTo set time using a specific timezone, use `yyyy-MM-dd`T`HH:mm:ss` format and specify the timezone [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) in the `timezone` field OR leave it blank and the timezone set on your Zoom account will be used. You can also set the time as UTC as the timezone field.\n\nThe `start_time` should only be used for scheduled and / or recurring webinars with fixed time.';
          format: 'date-time';
          type: 'string';
        };
        timezone: {
          description: 'Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.';
          type: 'string';
        };
        topic: {
          description: 'Webinar topic.';
          type: 'string';
        };
        tracking_fields: {
          description: 'Tracking fields';
          items: {
            properties: {
              field: {
                description: 'Tracking fields type';
                type: 'string';
              };
              value: {
                description: 'Tracking fields value';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        type: {
          default: 5;
          description: 'Webinar Types:<br>`5` - Webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.';
          enum: [5, 6, 9];
          type: 'integer';
          'x-enum-descriptions': [
            'Webinar',
            'Recurring Webinar with no fixed time',
            'Recurring Webinar with fixed time',
          ];
        };
      };
      type: 'object';
    };
    SessionWebinarUpdate: {
      description: 'Base webinar object for sessions.';
      properties: {
        agenda: {
          description: 'Webinar description.';
          type: 'string';
        };
        duration: {
          description: 'Webinar duration (minutes). Used for scheduled webinar only.';
          type: 'integer';
        };
        password: {
          description: '[Webinar passcode](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords). By default, passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ * !] and can have a maximum of 10 characters.\n\n**Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the  [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API. \n\nIf "**Require a passcode when scheduling new meetings**" setting has been **enabled** **and** [locked](https://support.zoom.us/hc/en-us/articles/115005269866-Using-Tiered-Settings#locked) for the user, the passcode field will be autogenerated for the Webinar in the response even if it is not provided in the API request. <br><br>\n\n\n\n\n\n\n\n';
          maxLength: 10;
          type: 'string';
        };
        recurrence: {
          description: 'Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time. ';
          properties: {
            end_date_time: {
              description: 'Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
              format: 'date-time';
              type: 'string';
            };
            end_times: {
              default: 1;
              description: 'Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)';
              maximum: 365;
              type: 'integer';
            };
            monthly_day: {
              default: 1;
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
              type: 'integer';
            };
            monthly_week: {
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
              enum: [-1, 1, 2, 3, 4];
              type: 'integer';
              'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
            };
            monthly_week_day: {
              description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field. \n\n<br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
              enum: [1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
            };
            repeat_interval: {
              description: 'Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.\n\n';
              type: 'integer';
            };
            type: {
              description: 'Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
            };
            weekly_days: {
              default: '1';
              description: 'This field is required **if you\'re scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.';
              enum: ['1', '2', '3', '4', '5', '6', '7'];
              type: 'string';
            };
          };
          required: ['type'];
          type: 'object';
        };
        settings: {
          allOf: [
            {
              description: 'Webinar settings.';
              properties: {
                allow_multiple_devices: {
                  description: 'Allow attendees to join from multiple devices.';
                  type: 'boolean';
                };
                alternative_hosts: {
                  description: 'Alternative host emails or IDs. Multiple values separated by comma.';
                  type: 'string';
                };
                approval_type: {
                  default: 2;
                  description: '`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
                  enum: [0, 1, 2];
                  type: 'integer';
                  'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
                };
                attendees_and_panelists_reminder_email_notification: {
                  description: 'Send reminder email to attendees and panelists.';
                  properties: {
                    enable: {
                      description: '* `true`: Send reminder email to attendees and panelists.\n\n* `false`: Do not send reminder email to attendees and panelists.';
                      type: 'boolean';
                    };
                    type: {
                      description: '`0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.';
                      enum: [0, 1, 2, 3, 4, 5, 6, 7];
                      type: 'integer';
                      'x-enum-descriptions': [
                        'Send 1 hour before webinar.',
                        'Send 1 day before webinar.',
                        'Send 1 hour and 1 day before webinar.',
                        'Send 1 week before webinar.',
                        'Send 1 hour and 1 week before webinar.',
                        'Send 1 day and 1 week before webinar.',
                        'Send 1 hour, 1 day and 1 week before webinar.',
                      ];
                    };
                  };
                  type: 'object';
                };
                audio: {
                  default: 'both';
                  description: 'Determine how participants can join the audio portion of the webinar.';
                  enum: ['both', 'telephony', 'voip'];
                  type: 'string';
                  'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
                };
                authentication_domains: {
                  description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
                  type: 'string';
                };
                authentication_name: {
                  description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
                  type: 'string';
                };
                authentication_option: {
                  description: 'Webinar authentication option id.';
                  type: 'string';
                };
                auto_recording: {
                  default: 'none';
                  description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
                  enum: ['local', 'cloud', 'none'];
                  type: 'string';
                  'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
                };
                close_registration: {
                  description: 'Close registration after event date.';
                  type: 'boolean';
                };
                contact_email: {
                  description: 'Contact email for registration';
                  type: 'string';
                };
                contact_name: {
                  description: 'Contact name for registration';
                  type: 'string';
                };
                email_language: {
                  description: 'Set the email language to one of the following:\n`en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.';
                  type: 'string';
                };
                enforce_login: {
                  description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.';
                  type: 'boolean';
                };
                enforce_login_domains: {
                  description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.';
                  type: 'string';
                };
                follow_up_absentees_email_notification: {
                  description: 'Send follow-up email to absentees.';
                  properties: {
                    enable: {
                      description: '* `true`: Send follow-up email to absentees.\n\n* `false`: Do not send follow-up email to absentees.';
                      type: 'boolean';
                    };
                    type: {
                      description: '`0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
                      enum: [0, 1, 2, 3, 4, 5, 6, 7];
                      type: 'integer';
                      'x-enum-descriptions': [
                        'Send 1 days after the scheduled end date.',
                        'Send 2 days after the scheduled end date.',
                        'Send 3 days after the scheduled end date.',
                        'Send 4 days after the scheduled end date.',
                        'Send 5 days after the scheduled end date.',
                        'Send 6 days after the scheduled end date.',
                        'Send 7 days after the scheduled end date.',
                      ];
                    };
                  };
                  type: 'object';
                };
                follow_up_attendees_email_notification: {
                  description: 'Send follow-up email to attendees.';
                  properties: {
                    enable: {
                      description: '* `true`: Send follow-up email to attendees.\n\n* `false`: Do not send follow-up email to attendees.';
                      type: 'boolean';
                    };
                    type: {
                      description: '`0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
                      enum: [0, 1, 2, 3, 4, 5, 6, 7];
                      type: 'integer';
                      'x-enum-descriptions': [
                        'Send 1 day after the scheduled end date.',
                        'Send 2 days after the scheduled end date.',
                        'Send 3 days after the scheduled end date.',
                        'Send 4 days after the scheduled end date.',
                        'Send 5 days after the scheduled end date.',
                        'Send 6 days after the scheduled end date.',
                        'Send 7 days after the scheduled end date.',
                      ];
                    };
                  };
                  type: 'object';
                };
                global_dial_in_countries: {
                  description: 'List of global dial-in countries';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                hd_video: {
                  default: false;
                  description: 'Default to HD video.';
                  type: 'boolean';
                };
                host_video: {
                  description: 'Start video when host joins webinar.';
                  type: 'boolean';
                };
                meeting_authentication: {
                  description: '`true`- Only authenticated users can join Webinar.';
                  type: 'boolean';
                };
                notify_registrants: {
                  description: 'Send notification email to registrants when the host updates a webinar.';
                  type: 'boolean';
                };
                on_demand: {
                  default: false;
                  description: 'Make the webinar on-demand';
                  type: 'boolean';
                };
                panelists_invitation_email_notification: {
                  description: '* `true`: Send invitation email to panelists.\n\n* `false`: Do not send invitation email to panelists.';
                  type: 'boolean';
                };
                panelists_video: {
                  description: 'Start video when panelists join webinar.';
                  type: 'boolean';
                };
                post_webinar_survey: {
                  description: "Zoom will open a survey page in attendees' browsers after leaving the webinar";
                  type: 'boolean';
                };
                practice_session: {
                  default: false;
                  description: 'Enable practice session.';
                  type: 'boolean';
                };
                question_and_answer: {
                  description: "[Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.";
                  properties: {
                    allow_anonymous_questions: {
                      description: '* `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..\n\n* `false`: Do not allow anonymous questions.';
                      type: 'boolean';
                    };
                    answer_questions: {
                      description: 'Indicate whether you want attendees to be able to view answered questions only or view all questions.\n\n* `only`: Attendees are able to view answered questions only.\n\n*  `all`: Attendees are able to view all questions submitted in the Q&A.';
                      enum: ['only', 'all'];
                      type: 'string';
                    };
                    attendees_can_comment: {
                      description: '* `true`: Attendees can answer questions or leave a comment in the question thread.\n\n* `false`: Attendees can not answer questions or leave a comment in the question thread';
                      type: 'boolean';
                    };
                    attendees_can_upvote: {
                      description: '* `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.\n\n* `false`: Attendees can not click the thumbs up butoon on questions.';
                      type: 'boolean';
                    };
                    enable: {
                      description: "* `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.\n\n* `false`: Disable Q&A for webinar.";
                      type: 'boolean';
                    };
                  };
                  type: 'object';
                };
                registrants_confirmation_email: {
                  description: 'Send confirmation email to registrants';
                  type: 'boolean';
                };
                registrants_email_notification: {
                  description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
                  type: 'boolean';
                };
                registrants_restrict_number: {
                  default: 0;
                  description: 'Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.';
                  maximum: 20000;
                  minimum: 0;
                  type: 'integer';
                };
                registration_type: {
                  default: 1;
                  description: 'Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.';
                  enum: [1, 2, 3];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Attendees register once and can attend any of the occurrences',
                    'Attendees need to register for each occurrence to attend',
                    'Attendees register once and can choose one or more occurrences to attend',
                  ];
                };
                show_share_button: {
                  description: 'Show social share buttons on the registration page.';
                  type: 'boolean';
                };
                survey_url: {
                  description: 'Survey url for post webinar survey';
                  type: 'string';
                };
              };
              type: 'object';
            },
            {
              properties: {
                registrants_confirmation_email: {
                  description: 'Send confirmation email to registrants.';
                  type: 'boolean';
                };
              };
              type: 'object';
            },
          ];
        };
        start_time: {
          description: "Webinar start time, in the format \"yyyy-MM-dd'T'HH:mm:ss'Z'.\" Should be in GMT time. In the format \"yyyy-MM-dd'T'HH:mm:ss.\" This should be in local time and the timezone should be specified. Only used for scheduled webinars and recurring webinars with a fixed time.";
          format: 'date-time';
          type: 'string';
        };
        timezone: {
          description: 'Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.';
          type: 'string';
        };
        topic: {
          description: 'Webinar topic.';
          type: 'string';
        };
        tracking_fields: {
          description: 'Tracking fields';
          items: {
            properties: {
              field: {
                description: 'Tracking fields type';
                type: 'string';
              };
              value: {
                description: 'Tracking fields value';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        type: {
          default: 5;
          description: 'Webinar Types:<br>`5` - webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.';
          enum: [5, 6, 9];
          type: 'integer';
          'x-enum-descriptions': [
            'Webinar',
            'Recurring Webinar with no fixed time',
            'Recurring Webinar with fixed time',
          ];
        };
      };
      type: 'object';
    };
    SettingsUpdateTelephony: {
      properties: {
        audio_conference_info: {
          default: '';
          description: 'Third party audio conference info.';
          maxLength: 2048;
          type: 'string';
        };
        show_international_numbers_link: {
          description: 'Show the international numbers link on the invitation email.';
          type: 'boolean';
        };
        telephony_regions: {
          description: 'Indicates where most of the participants call into or call from duriing a meeting.';
          properties: {
            selection_values: {
              description: 'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.';
              items: {
                type: 'string';
              };
              type: 'array';
            };
          };
          type: 'object';
        };
        third_party_audio: {
          description: 'Third party audio conference.';
          type: 'boolean';
        };
      };
      title: 'Telephony update settings: Meeting settings';
      type: 'object';
    };
    TSP: {
      description: 'List of TSP accounts.';
      properties: {
        conference_code: {
          description: 'Conference code: numeric value, length is less than 16.';
          maxLength: 16;
          minLength: 1;
          type: 'string';
        };
        dial_in_numbers: {
          description: 'List of dial in numbers.';
          items: {
            properties: {
              code: {
                description: 'Country code.';
                maxLength: 6;
                type: 'string';
              };
              country_label: {
                description: 'Country Label, if passed, will display in place of code.';
                maxLength: 10;
                type: 'string';
              };
              number: {
                description: 'Dial-in number: length is less than 16.';
                maxLength: 16;
                minLength: 1;
                type: 'string';
              };
              type: {
                description: 'Dial-in number types:<br>`toll` - Toll number.<br>`tollfree` -Toll free number.<br>\n`media_link` - Media link.';
                enum: ['toll', 'tollfree', 'media_link'];
                type: 'string';
                'x-enum-descriptions': ['Toll number <br/>', 'Toll free number <br/>', 'Media link phone number <br/>'];
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        leader_pin: {
          description: 'Leader PIN: numeric value, length is less than 16.';
          maxLength: 16;
          minLength: 1;
          type: 'string';
        };
        tsp_bridge: {
          description: 'Telephony bridge';
          enum: ['US_TSP_TB', 'EU_TSP_TB'];
          type: 'string';
        };
      };
      required: ['conference_code', 'leader_pin'];
      title: 'TSP Accounts List';
      type: 'object';
    };
    TrackingField: {
      description: 'Tracking Field';
      properties: {
        field: {
          description: 'Label/ Name for the tracking field.';
          type: 'string';
        };
        recommended_values: {
          description: 'Array of recommended values';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        required: {
          description: 'Tracking Field Required';
          type: 'boolean';
        };
        visible: {
          description: 'Tracking Field Visible';
          type: 'boolean';
        };
      };
      title: 'Tracking Field';
      type: 'object';
    };
    TrackingFieldList: {
      allOf: [
        {
          properties: {
            total_records: {
              description: 'The number of all records available across pages';
              type: 'integer';
            };
            tracking_fields: {
              description: 'Array of Tracking Fields';
              items: {
                allOf: [
                  {
                    properties: {
                      id: {
                        description: 'ID of Tracking Field';
                        type: 'string';
                      };
                    };
                  },
                  {
                    description: 'Tracking Field';
                    properties: {
                      field: {
                        description: 'Label/ Name for the tracking field.';
                        type: 'string';
                      };
                      recommended_values: {
                        description: 'Array of recommended values';
                        items: {
                          type: 'string';
                        };
                        type: 'array';
                      };
                      required: {
                        description: 'Tracking Field Required';
                        type: 'boolean';
                      };
                      visible: {
                        description: 'Tracking Field Visible';
                        type: 'boolean';
                      };
                    };
                    title: 'Tracking Field';
                    type: 'object';
                  },
                ];
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'Tracking Field List';
      title: 'Tracking Field List';
      type: 'object';
    };
    User: {
      description: 'The user object represents a specific user on Zoom.';
      properties: {
        created_at: {
          description: 'User create time.';
          format: 'date-time';
          type: 'string';
        };
        dept: {
          description: 'Department.';
          type: 'string';
        };
        email: {
          default: 'john.doe@email.com';
          description: "User's email address.";
          type: 'string';
        };
        first_name: {
          description: "User's first name.";
          maxLength: 64;
          type: 'string';
        };
        last_client_version: {
          description: 'User last login client version.';
          type: 'string';
        };
        last_login_time: {
          description: 'User last login time.';
          format: 'date-time';
          type: 'string';
        };
        last_name: {
          description: "User's last name.";
          maxLength: 64;
          type: 'string';
        };
        pmi: {
          description: 'Personal meeting ID.';
          format: 'int64';
          type: 'integer';
        };
        role_name: {
          description: "User's [role](https://support.zoom.us/hc/en-us/articles/115001078646-Role-Based-Access-Control) name.";
          type: 'string';
        };
        timezone: {
          description: 'The time zone of the user.';
          type: 'string';
        };
        type: {
          description: "User's plan type:<br>`1` - Basic.<br>`2` - Licensed.<br>`3` - On-prem.<br>`99` - None (this can only be set with `ssoCreate`).";
          enum: [1, 2, 3, 99];
          type: 'integer';
        };
        use_pmi: {
          default: false;
          description: 'Use Personal Meeting ID for instant meetings.';
          type: 'boolean';
        };
      };
      required: ['email', 'type'];
      type: 'object';
    };
    UserAssistantsList: {
      description: "List of user's assistants.";
      properties: {
        assistants: {
          description: "List of User's assistants.";
          items: {
            properties: {
              email: {
                description: "Assistant's email address.";
                type: 'string';
              };
              id: {
                description: "Assistant's user ID.";
                type: 'string';
              };
            };
            type: 'object';
          };
          maximum: 30;
          type: 'array';
        };
      };
      title: 'User assistants List';
      type: 'object';
    };
    UserList: {
      allOf: [
        {
          description: 'Pagination Object.';
          properties: {
            next_page_token: {
              description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
              type: 'string';
            };
            page_count: {
              description: 'The number of pages returned for the request made.';
              type: 'integer';
            };
            page_number: {
              default: 1;
              description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
              type: 'integer';
            };
            page_size: {
              default: 30;
              description: 'The number of records returned with a single API call.';
              maximum: 300;
              type: 'integer';
            };
            total_records: {
              description: 'The total number of all the records available across pages.';
              type: 'integer';
            };
          };
          type: 'object';
        },
        {
          properties: {
            users: {
              description: 'List of user objects.';
              items: {
                allOf: [
                  {
                    properties: {
                      id: {
                        description: 'User ID.';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  },
                  {
                    description: 'The user object represents a specific user on Zoom.';
                    properties: {
                      created_at: {
                        description: 'User create time.';
                        format: 'date-time';
                        type: 'string';
                      };
                      dept: {
                        description: 'Department.';
                        type: 'string';
                      };
                      email: {
                        default: 'john.doe@email.com';
                        description: "User's email address.";
                        type: 'string';
                      };
                      first_name: {
                        description: "User's first name.";
                        maxLength: 64;
                        type: 'string';
                      };
                      last_client_version: {
                        description: 'User last login client version.';
                        type: 'string';
                      };
                      last_login_time: {
                        description: 'User last login time.';
                        format: 'date-time';
                        type: 'string';
                      };
                      last_name: {
                        description: "User's last name.";
                        maxLength: 64;
                        type: 'string';
                      };
                      pmi: {
                        description: 'Personal meeting ID.';
                        format: 'int64';
                        type: 'integer';
                      };
                      role_name: {
                        description: "User's [role](https://support.zoom.us/hc/en-us/articles/115001078646-Role-Based-Access-Control) name.";
                        type: 'string';
                      };
                      timezone: {
                        description: 'The time zone of the user.';
                        type: 'string';
                      };
                      type: {
                        description: "User's plan type:<br>`1` - Basic.<br>`2` - Licensed.<br>`3` - On-prem.<br>`99` - None (this can only be set with `ssoCreate`).";
                        enum: [1, 2, 3, 99];
                        type: 'integer';
                      };
                      use_pmi: {
                        default: false;
                        description: 'Use Personal Meeting ID for instant meetings.';
                        type: 'boolean';
                      };
                    };
                    required: ['email', 'type'];
                    type: 'object';
                  },
                  {
                    properties: {
                      group_ids: {
                        items: {
                          type: 'string';
                        };
                        type: 'array';
                      };
                      im_group_ids: {
                        items: {
                          type: 'string';
                        };
                        type: 'array';
                      };
                    };
                    type: 'object';
                  },
                ];
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'List of users.';
      title: 'User List';
      type: 'object';
    };
    UserPermissions: {
      description: '';
      properties: {
        permissions: {
          description: 'List of user permissions.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
    };
    UserSchedulersList: {
      description: "List of user's schedulers.";
      properties: {
        schedulers: {
          description: 'List of users for whom the current user can schedule meetings.';
          items: {
            properties: {
              email: {
                description: 'Email address of the scheduler.';
                type: 'string';
              };
              id: {
                description: 'Unique Identifier (User ID) of the Scheduler.';
                type: 'string';
              };
              pmi: {
                description: 'PMI of the meeting host in long (int64) format.';
                format: 'int64';
                type: 'integer';
              };
            };
            type: 'object';
          };
          maximum: 30;
          type: 'array';
        };
      };
      title: 'User schedulers List';
      type: 'object';
    };
    UserSettings: {
      properties: {
        email_notification: {
          description: '';
          properties: {
            alternative_host_reminder: {
              default: false;
              description: 'When an alternative host is set or removed from a meeting.';
              type: 'boolean';
            };
            cancel_meeting_reminder: {
              default: false;
              description: 'When a meeting is cancelled.';
              type: 'boolean';
            };
            jbh_reminder: {
              default: false;
              description: 'When attendees join meeting before host.';
              type: 'boolean';
            };
            schedule_for_reminder: {
              default: false;
              description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
              type: 'boolean';
            };
          };
          title: 'User settings: Notification settings';
          type: 'object';
        };
        feature: {
          description: '';
          properties: {
            cn_meeting: {
              description: 'Host meeting in China.';
              type: 'boolean';
            };
            in_meeting: {
              description: 'Host meeting in India.';
              type: 'boolean';
            };
            large_meeting: {
              description: 'Large meeting feature.';
              type: 'boolean';
            };
            large_meeting_capacity: {
              description: 'Large meeting capacity: can be 500 or 1000, depending on if the user has a large meeting capacity plan subscription or not.';
              type: 'integer';
            };
            meeting_capacity: {
              description: 'User’s meeting capacity.';
              type: 'integer';
            };
            webinar: {
              description: 'Webinar feature.';
              type: 'boolean';
            };
            webinar_capacity: {
              description: 'Webinar capacity: can be 100, 500, 1000, 3000, 5000 or 10000, depending on if the user has a webinar capacity plan subscription or not.';
              type: 'integer';
            };
            zoom_phone: {
              description: 'Zoom phone feature.';
              type: 'boolean';
            };
          };
          title: 'User settings: Feature settings';
          type: 'object';
        };
        in_meeting: {
          description: '';
          properties: {
            allow_live_streaming: {
              description: 'Allow live streaming.';
              type: 'boolean';
            };
            annotation: {
              default: false;
              description: 'Allow participants to use annotation tools.';
              type: 'boolean';
            };
            attendee_on_hold: {
              default: false;
              description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
              type: 'boolean';
            };
            auto_saving_chat: {
              default: false;
              description: 'Auto save all in-meeting chats.';
              type: 'boolean';
            };
            breakout_room: {
              default: false;
              description: 'Allow host to split meeting participants into separate breakout rooms.';
              type: 'boolean';
            };
            chat: {
              default: false;
              description: 'Enable chat during meeting for all participants.';
              type: 'boolean';
            };
            closed_caption: {
              default: false;
              description: 'Enable closed captions.';
              type: 'boolean';
            };
            co_host: {
              default: false;
              description: 'Allow the host to add co-hosts.';
              type: 'boolean';
            };
            custom_data_center_regions: {
              description: 'If set to `true`, you can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting your real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.';
              type: 'boolean';
            };
            custom_live_streaming_service: {
              description: 'Allow custom live streaming.';
              type: 'boolean';
            };
            custom_service_instructions: {
              description: 'Custom service instructions.';
              type: 'string';
            };
            data_center_regions: {
              description: 'If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["DE", "NL", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).\n';
              enum: ['HK', 'AU', 'IN', 'TY', 'CN', 'US', 'CA', 'DE', 'NL', 'LA'];
              items: {
                type: 'string';
              };
              type: 'array';
            };
            e2e_encryption: {
              description: 'Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).';
              type: 'boolean';
            };
            entry_exit_chime: {
              default: 'all';
              description: 'Play sound when participants join or leave:<br>`host` - When host joins or leaves.<br>`all` - When any participant joins or leaves.<br>`none` - No join or leave sound.';
              enum: ['host', 'all', 'none'];
              type: 'string';
              'x-enum-descriptions': [
                'when host joins/leaves',
                'when any participant joins/leaves',
                'no join/leave sound',
              ];
            };
            far_end_camera_control: {
              default: false;
              description: 'Allow another user to take control of the camera.';
              type: 'boolean';
            };
            feedback: {
              default: false;
              description: 'Enable option to send feedback to Zoom at the end of the meeting.';
              type: 'boolean';
            };
            file_transfer: {
              description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for the user or not.';
              type: 'boolean';
            };
            group_hd: {
              default: false;
              description: 'Enable group HD video.';
              type: 'boolean';
            };
            non_verbal_feedback: {
              default: false;
              description: 'Enable non-verbal feedback through screens.';
              type: 'boolean';
            };
            polling: {
              default: false;
              description: 'Add polls to the meeting controls.';
              type: 'boolean';
            };
            private_chat: {
              default: false;
              description: 'Enable 1:1 private chat between participants during meetings.';
              type: 'boolean';
            };
            record_play_voice: {
              description: 'Record and play their own voice.';
              type: 'boolean';
            };
            remote_control: {
              default: false;
              description: 'Enable remote control during screensharing.';
              type: 'boolean';
            };
            remote_support: {
              default: false;
              description: 'Allow host to provide 1:1 remote support to a participant.';
              type: 'boolean';
            };
            request_permission_to_unmute: {
              description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the user or not.';
              type: 'boolean';
            };
            screen_sharing: {
              description: 'Allow host and participants to share their screen or content during meetings\n';
              type: 'boolean';
            };
            share_dual_camera: {
              default: false;
              description: 'Share dual camera (deprecated).';
              type: 'boolean';
            };
            show_meeting_control_toolbar: {
              description: 'Always show meeting controls during a meeting.';
              type: 'boolean';
            };
            virtual_background: {
              default: false;
              description: 'Enable virtual background.';
              type: 'boolean';
            };
            virtual_background_settings: {
              description: 'Settings to manage virtual background.';
              properties: {
                allow_upload_custom: {
                  description: 'Allow user to upload custom backgrounds.';
                  type: 'boolean';
                };
                allow_videos: {
                  description: 'Allow use of videos for virtual backgrounds.';
                  type: 'boolean';
                };
                enable: {
                  description: 'Enable virtual background.';
                  type: 'boolean';
                };
                files: {
                  items: {
                    properties: {
                      id: {
                        description: 'Unique identifier of the file.';
                        type: 'string';
                      };
                      is_default: {
                        description: 'Indicates whether or not this file is the default virtual background file.';
                        type: 'boolean';
                      };
                      name: {
                        description: 'File name.';
                        type: 'string';
                      };
                      size: {
                        description: 'File size.';
                        type: 'string';
                      };
                      type: {
                        description: 'File type.';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            waiting_room: {
              default: false;
              description: 'Enable Waiting room - if enabled, attendees can only join after host approves.';
              type: 'boolean';
            };
            who_can_share_screen: {
              description: 'Indicates who can share their screen or content during meetings. The value can be one of the following: <br>\n`host`: Only host can share the screen.<br>\n`all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
              enum: ['host', 'all'];
              type: 'string';
            };
            who_can_share_screen_when_someone_is_sharing: {
              description: 'Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>\n`host`: Only a host can share the screen when someone else is sharing.<br>\n`all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
              enum: ['host', 'all'];
              type: 'string';
            };
            workplace_by_facebook: {
              description: 'Allow livestreaming by host through Workplace by Facebook.';
              type: 'boolean';
            };
          };
          title: 'User settings: Meeting settings';
          type: 'object';
        };
        profile: {
          properties: {
            recording_storage_location: {
              properties: {
                allowed_values: {
                  description: 'Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.\n\nProvide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                value: {
                  description: 'Abbreviated country code.';
                  type: 'string';
                };
              };
              type: 'object';
            };
          };
          title: 'Profile';
          type: 'object';
        };
        recording: {
          description: '';
          properties: {
            ask_host_to_confirm_disclaimer: {
              description: 'Ask host to confirm the disclaimer.';
              type: 'boolean';
            };
            ask_participants_to_consent_disclaimer: {
              description: 'This field can be used if `recording_disclaimer` is set to true. This field indicates whether or not you would like to ask participants for consent when a recording starts. The value can be one of the following:<br>\n* `true`: Ask participants for consent when a recording starts. <br>\n* `false`: Do not ask participants for consent when a recording starts.';
              type: 'boolean';
            };
            auto_delete_cmr: {
              default: false;
              description: 'Auto delete cloud recordings.';
              type: 'boolean';
            };
            auto_delete_cmr_days: {
              description: 'A specified number of days of auto delete cloud recordings.';
              maximum: 60;
              minimum: 1;
              type: 'integer';
            };
            auto_recording: {
              default: 'local';
              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` - Record on cloud.<br>`none` - Disabled.';
              enum: ['local', 'cloud', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Record on local', 'Record on cloud', 'Disabled'];
            };
            cloud_recording: {
              default: false;
              description: 'Cloud recording.';
              type: 'boolean';
            };
            host_pause_stop_recording: {
              default: false;
              description: 'Host can pause/stop the auto recording in the cloud.';
              type: 'boolean';
            };
            ip_address_access_control: {
              description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
              properties: {
                enable: {
                  description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                  type: 'boolean';
                };
                ip_addresses_or_ranges: {
                  description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                  type: 'string';
                };
              };
              type: 'object';
            };
            local_recording: {
              description: 'Local recording.';
              type: 'boolean';
            };
            record_audio_file: {
              default: false;
              description: 'Record an audio only file.';
              type: 'boolean';
            };
            record_gallery_view: {
              default: false;
              description: 'Record the gallery view.';
              type: 'boolean';
            };
            record_speaker_view: {
              default: false;
              description: 'Record the active speaker view.';
              type: 'boolean';
            };
            recording_audio_transcript: {
              description: 'Audio transcript.';
              type: 'boolean';
            };
            recording_disclaimer: {
              description: 'Show a disclaimer to participants before a recording starts\n';
              type: 'boolean';
            };
            recording_password_requirement: {
              description: 'This object represents the minimum passcode requirements set for recordings via Account Recording Settings.';
              properties: {
                have_letter: {
                  description: 'Indicates whether or not passcode must contain at least one alphabetical letter (a, b, c..).';
                  type: 'boolean';
                };
                have_number: {
                  description: 'Indicates whether or not passcode must contain at least one number(1, 2, 3..).';
                  type: 'boolean';
                };
                have_special_character: {
                  description: 'Indicates whether or not passcode must contain at least one special character(!, @, #..).';
                  type: 'boolean';
                };
                length: {
                  description: 'Minimum required length for the passcode.';
                  maximum: 10;
                  type: 'integer';
                };
                only_allow_numeric: {
                  description: 'Indicates whether or not passcode must contain only numeric characters.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            save_chat_text: {
              default: false;
              description: 'Save chat text from the meeting.';
              type: 'boolean';
            };
            show_timestamp: {
              default: false;
              description: 'Show timestamp on video.';
              type: 'boolean';
            };
          };
          title: 'User settings: Recording settings';
          type: 'object';
        };
        schedule_meeting: {
          description: '';
          properties: {
            audio_type: {
              default: 'voip';
              description: 'Determine how participants can join the audio portion of the meeting:<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - Third party audio conference.';
              enum: ['both', 'telephony', 'voip', 'thirdParty'];
              type: 'string';
              'x-enum-descriptions': [
                'Telephony and VoIP',
                'Audio PSTN telephony only',
                'VoIP only',
                '3rd party audio conference',
              ];
            };
            default_password_for_scheduled_meetings: {
              description: 'Passcode for already scheduled meetings\n';
              type: 'string';
            };
            embed_password_in_join_link: {
              description: 'If the value is set to `true`, the meeting passcode will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the passcode.\n ';
              type: 'boolean';
            };
            force_pmi_jbh_password: {
              description: 'Require a passcode for personal meetings if attendees can join before host.';
              type: 'boolean';
            };
            host_video: {
              description: 'Start meetings with host video on.';
              type: 'boolean';
            };
            join_before_host: {
              description: 'Join the meeting before host arrives.';
              type: 'boolean';
            };
            meeting_password_requirement: {
              description: 'Account wide meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
              properties: {
                consecutive_characters_length: {
                  enum: [0, 4, 5, 6, 7, 8];
                  type: 'integer';
                };
                have_letter: {
                  description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                  type: 'boolean';
                };
                have_number: {
                  description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                  type: 'boolean';
                };
                have_special_character: {
                  description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                  type: 'boolean';
                };
                have_upper_and_lower_characters: {
                  description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                  type: 'boolean';
                };
                length: {
                  description: 'The minimum length that the meeting/webinar passcode needs to have.';
                  type: 'integer';
                };
                only_allow_numeric: {
                  description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                  type: 'boolean';
                };
                weak_enhance_detection: {
                  description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            participants_video: {
              description: 'Start meetings with participants video on.';
              type: 'boolean';
            };
            personal_meeting: {
              description: 'Personal Meeting Setting.<br><br>\n`true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.\nFor Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n';
              type: 'boolean';
            };
            pmi_password: {
              description: 'PMI passcode\n';
              type: 'string';
            };
            pstn_password_protected: {
              description: 'Generate and require passcode for participants joining by phone.';
              type: 'boolean';
            };
            require_password_for_instant_meetings: {
              description: 'Require a passcode for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
              type: 'boolean';
            };
            require_password_for_pmi_meetings: {
              description: 'Require a passcode for Personal Meeting ID (PMI). This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
              enum: ['jbh_only', 'all', 'none'];
              type: 'string';
              'x-enum-descriptions': [
                'Only meetings with Join Before Host enabled',
                'All meetings using PMI',
                'Disabled',
              ];
            };
            require_password_for_scheduled_meetings: {
              description: 'Require a passcode for meetings which have already been scheduled\n';
              type: 'boolean';
            };
            require_password_for_scheduling_new_meetings: {
              description: 'Require a passcode when scheduling new meetings.This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
              type: 'boolean';
            };
            use_pmi_for_instant_meetings: {
              description: 'Use Personal Meeting ID (PMI) when starting an instant meeting\n';
              type: 'boolean';
            };
            use_pmi_for_scheduled_meetings: {
              description: 'Use Personal Meeting ID (PMI) when scheduling a meeting\n';
              type: 'boolean';
            };
          };
          title: 'User settings: Meeting settings';
          type: 'object';
        };
        telephony: {
          properties: {
            audio_conference_info: {
              default: '';
              description: 'Third party audio conference info.';
              maxLength: 2048;
              type: 'string';
            };
            show_international_numbers_link: {
              description: 'Show the international numbers link on the invitation email.';
              type: 'boolean';
            };
            telephony_regions: {
              description: 'Indicates where most of the participants call into or call from duriing a meeting.';
              properties: {
                allowed_values: {
                  description: 'Telephony region options provided by Zoom to select from.';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                selection_values: {
                  description: 'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            third_party_audio: {
              description: 'Third party audio conference.';
              type: 'boolean';
            };
          };
          title: 'User settings: Meeting settings';
          type: 'object';
        };
        tsp: {
          description: 'Account Settings: TSP.';
          properties: {
            call_out: {
              description: 'Call Out';
              type: 'boolean';
            };
            call_out_countries: {
              description: 'Call Out Countries/Regions';
              items: {};
              type: 'array';
            };
            show_international_numbers_link: {
              description: 'Show international numbers link on the invitation email';
              type: 'boolean';
            };
          };
          title: 'User settings: TSP settings';
          type: 'object';
        };
      };
      title: 'User settings';
      type: 'object';
    };
    UserSettingsEmailNotification: {
      description: '';
      properties: {
        alternative_host_reminder: {
          default: false;
          description: 'When an alternative host is set or removed from a meeting.';
          type: 'boolean';
        };
        cancel_meeting_reminder: {
          default: false;
          description: 'When a meeting is cancelled.';
          type: 'boolean';
        };
        jbh_reminder: {
          default: false;
          description: 'When attendees join meeting before host.';
          type: 'boolean';
        };
        schedule_for_reminder: {
          default: false;
          description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
          type: 'boolean';
        };
      };
      title: 'User settings: Notification settings';
      type: 'object';
    };
    UserSettingsFeature: {
      description: '';
      properties: {
        cn_meeting: {
          description: 'Host meeting in China.';
          type: 'boolean';
        };
        in_meeting: {
          description: 'Host meeting in India.';
          type: 'boolean';
        };
        large_meeting: {
          description: 'Large meeting feature.';
          type: 'boolean';
        };
        large_meeting_capacity: {
          description: 'Large meeting capacity: can be 500 or 1000, depending on if the user has a large meeting capacity plan subscription or not.';
          type: 'integer';
        };
        meeting_capacity: {
          description: 'User’s meeting capacity.';
          type: 'integer';
        };
        webinar: {
          description: 'Webinar feature.';
          type: 'boolean';
        };
        webinar_capacity: {
          description: 'Webinar capacity: can be 100, 500, 1000, 3000, 5000 or 10000, depending on if the user has a webinar capacity plan subscription or not.';
          type: 'integer';
        };
        zoom_phone: {
          description: 'Zoom phone feature.';
          type: 'boolean';
        };
      };
      title: 'User settings: Feature settings';
      type: 'object';
    };
    UserSettingsFeatureUpdate: {
      description: '';
      properties: {
        large_meeting: {
          description: 'Enable [large meeting](https://support.zoom.us/hc/en-us/articles/201362823-What-is-a-Large-Meeting-) feature for the user.';
          type: 'boolean';
        };
        large_meeting_capacity: {
          description: 'Set the meeting capacity for the user if the user has **Large meeting** feature enabled. The value for the field can be either 500 or 1000.';
          type: 'integer';
        };
        meeting_capacity: {
          description: "Set a user's meeting capacity. User’s meeting capacity denotes the maximum number of participants that can join a meeting scheduled by the user.";
          type: 'integer';
        };
        webinar: {
          description: 'Enable Webinar feature for the user.';
          type: 'boolean';
        };
        webinar_capacity: {
          description: 'Set the Webinar capacity for a user who has the Webinar feature enabled. The value of this field can be 100, 500, 1000, 3000, 5000 or 10000.';
          type: 'integer';
        };
        zoom_phone: {
          description: 'Zoom phone feature.';
          type: 'boolean';
        };
      };
      title: 'User settings: Feature settings';
      type: 'object';
    };
    UserSettingsInMeeting: {
      description: '';
      properties: {
        allow_live_streaming: {
          description: 'Allow live streaming.';
          type: 'boolean';
        };
        annotation: {
          default: false;
          description: 'Allow participants to use annotation tools.';
          type: 'boolean';
        };
        attendee_on_hold: {
          default: false;
          description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
          type: 'boolean';
        };
        auto_saving_chat: {
          default: false;
          description: 'Auto save all in-meeting chats.';
          type: 'boolean';
        };
        breakout_room: {
          default: false;
          description: 'Allow host to split meeting participants into separate breakout rooms.';
          type: 'boolean';
        };
        chat: {
          default: false;
          description: 'Enable chat during meeting for all participants.';
          type: 'boolean';
        };
        closed_caption: {
          default: false;
          description: 'Enable closed captions.';
          type: 'boolean';
        };
        co_host: {
          default: false;
          description: 'Allow the host to add co-hosts.';
          type: 'boolean';
        };
        custom_data_center_regions: {
          description: 'If set to `true`, you can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting your real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.';
          type: 'boolean';
        };
        custom_live_streaming_service: {
          description: 'Allow custom live streaming.';
          type: 'boolean';
        };
        custom_service_instructions: {
          description: 'Custom service instructions.';
          type: 'string';
        };
        data_center_regions: {
          description: 'If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["DE", "NL", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).\n';
          enum: ['HK', 'AU', 'IN', 'TY', 'CN', 'US', 'CA', 'DE', 'NL', 'LA'];
          items: {
            type: 'string';
          };
          type: 'array';
        };
        e2e_encryption: {
          description: 'Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).';
          type: 'boolean';
        };
        entry_exit_chime: {
          default: 'all';
          description: 'Play sound when participants join or leave:<br>`host` - When host joins or leaves.<br>`all` - When any participant joins or leaves.<br>`none` - No join or leave sound.';
          enum: ['host', 'all', 'none'];
          type: 'string';
          'x-enum-descriptions': ['when host joins/leaves', 'when any participant joins/leaves', 'no join/leave sound'];
        };
        far_end_camera_control: {
          default: false;
          description: 'Allow another user to take control of the camera.';
          type: 'boolean';
        };
        feedback: {
          default: false;
          description: 'Enable option to send feedback to Zoom at the end of the meeting.';
          type: 'boolean';
        };
        file_transfer: {
          description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for the user or not.';
          type: 'boolean';
        };
        group_hd: {
          default: false;
          description: 'Enable group HD video.';
          type: 'boolean';
        };
        non_verbal_feedback: {
          default: false;
          description: 'Enable non-verbal feedback through screens.';
          type: 'boolean';
        };
        polling: {
          default: false;
          description: 'Add polls to the meeting controls.';
          type: 'boolean';
        };
        private_chat: {
          default: false;
          description: 'Enable 1:1 private chat between participants during meetings.';
          type: 'boolean';
        };
        record_play_voice: {
          description: 'Record and play their own voice.';
          type: 'boolean';
        };
        remote_control: {
          default: false;
          description: 'Enable remote control during screensharing.';
          type: 'boolean';
        };
        remote_support: {
          default: false;
          description: 'Allow host to provide 1:1 remote support to a participant.';
          type: 'boolean';
        };
        request_permission_to_unmute: {
          description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the user or not.';
          type: 'boolean';
        };
        screen_sharing: {
          description: 'Allow host and participants to share their screen or content during meetings\n';
          type: 'boolean';
        };
        share_dual_camera: {
          default: false;
          description: 'Share dual camera (deprecated).';
          type: 'boolean';
        };
        show_meeting_control_toolbar: {
          description: 'Always show meeting controls during a meeting.';
          type: 'boolean';
        };
        virtual_background: {
          default: false;
          description: 'Enable virtual background.';
          type: 'boolean';
        };
        virtual_background_settings: {
          description: 'Settings to manage virtual background.';
          properties: {
            allow_upload_custom: {
              description: 'Allow user to upload custom backgrounds.';
              type: 'boolean';
            };
            allow_videos: {
              description: 'Allow use of videos for virtual backgrounds.';
              type: 'boolean';
            };
            enable: {
              description: 'Enable virtual background.';
              type: 'boolean';
            };
            files: {
              items: {
                properties: {
                  id: {
                    description: 'Unique identifier of the file.';
                    type: 'string';
                  };
                  is_default: {
                    description: 'Indicates whether or not this file is the default virtual background file.';
                    type: 'boolean';
                  };
                  name: {
                    description: 'File name.';
                    type: 'string';
                  };
                  size: {
                    description: 'File size.';
                    type: 'string';
                  };
                  type: {
                    description: 'File type.';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
          };
          type: 'object';
        };
        waiting_room: {
          default: false;
          description: 'Enable Waiting room - if enabled, attendees can only join after host approves.';
          type: 'boolean';
        };
        who_can_share_screen: {
          description: 'Indicates who can share their screen or content during meetings. The value can be one of the following: <br>\n`host`: Only host can share the screen.<br>\n`all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
          enum: ['host', 'all'];
          type: 'string';
        };
        who_can_share_screen_when_someone_is_sharing: {
          description: 'Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>\n`host`: Only a host can share the screen when someone else is sharing.<br>\n`all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
          enum: ['host', 'all'];
          type: 'string';
        };
        workplace_by_facebook: {
          description: 'Allow livestreaming by host through Workplace by Facebook.';
          type: 'boolean';
        };
      };
      title: 'User settings: Meeting settings';
      type: 'object';
    };
    UserSettingsRecording: {
      description: '';
      properties: {
        ask_host_to_confirm_disclaimer: {
          description: 'Ask host to confirm the disclaimer.';
          type: 'boolean';
        };
        ask_participants_to_consent_disclaimer: {
          description: 'This field can be used if `recording_disclaimer` is set to true. This field indicates whether or not you would like to ask participants for consent when a recording starts. The value can be one of the following:<br>\n* `true`: Ask participants for consent when a recording starts. <br>\n* `false`: Do not ask participants for consent when a recording starts.';
          type: 'boolean';
        };
        auto_delete_cmr: {
          default: false;
          description: 'Auto delete cloud recordings.';
          type: 'boolean';
        };
        auto_delete_cmr_days: {
          description: 'A specified number of days of auto delete cloud recordings.';
          maximum: 60;
          minimum: 1;
          type: 'integer';
        };
        auto_recording: {
          default: 'local';
          description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` - Record on cloud.<br>`none` - Disabled.';
          enum: ['local', 'cloud', 'none'];
          type: 'string';
          'x-enum-descriptions': ['Record on local', 'Record on cloud', 'Disabled'];
        };
        cloud_recording: {
          default: false;
          description: 'Cloud recording.';
          type: 'boolean';
        };
        host_pause_stop_recording: {
          default: false;
          description: 'Host can pause/stop the auto recording in the cloud.';
          type: 'boolean';
        };
        ip_address_access_control: {
          description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
          properties: {
            enable: {
              description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
              type: 'boolean';
            };
            ip_addresses_or_ranges: {
              description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
              type: 'string';
            };
          };
          type: 'object';
        };
        local_recording: {
          description: 'Local recording.';
          type: 'boolean';
        };
        record_audio_file: {
          default: false;
          description: 'Record an audio only file.';
          type: 'boolean';
        };
        record_gallery_view: {
          default: false;
          description: 'Record the gallery view.';
          type: 'boolean';
        };
        record_speaker_view: {
          default: false;
          description: 'Record the active speaker view.';
          type: 'boolean';
        };
        recording_audio_transcript: {
          description: 'Audio transcript.';
          type: 'boolean';
        };
        recording_disclaimer: {
          description: 'Show a disclaimer to participants before a recording starts\n';
          type: 'boolean';
        };
        recording_password_requirement: {
          description: 'This object represents the minimum passcode requirements set for recordings via Account Recording Settings.';
          properties: {
            have_letter: {
              description: 'Indicates whether or not passcode must contain at least one alphabetical letter (a, b, c..).';
              type: 'boolean';
            };
            have_number: {
              description: 'Indicates whether or not passcode must contain at least one number(1, 2, 3..).';
              type: 'boolean';
            };
            have_special_character: {
              description: 'Indicates whether or not passcode must contain at least one special character(!, @, #..).';
              type: 'boolean';
            };
            length: {
              description: 'Minimum required length for the passcode.';
              maximum: 10;
              type: 'integer';
            };
            only_allow_numeric: {
              description: 'Indicates whether or not passcode must contain only numeric characters.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        save_chat_text: {
          default: false;
          description: 'Save chat text from the meeting.';
          type: 'boolean';
        };
        show_timestamp: {
          default: false;
          description: 'Show timestamp on video.';
          type: 'boolean';
        };
      };
      title: 'User settings: Recording settings';
      type: 'object';
    };
    UserSettingsScheduleMeeting: {
      description: '';
      properties: {
        audio_type: {
          default: 'voip';
          description: 'Determine how participants can join the audio portion of the meeting:<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - Third party audio conference.';
          enum: ['both', 'telephony', 'voip', 'thirdParty'];
          type: 'string';
          'x-enum-descriptions': [
            'Telephony and VoIP',
            'Audio PSTN telephony only',
            'VoIP only',
            '3rd party audio conference',
          ];
        };
        default_password_for_scheduled_meetings: {
          description: 'Passcode for already scheduled meetings\n';
          type: 'string';
        };
        embed_password_in_join_link: {
          description: 'If the value is set to `true`, the meeting passcode will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the passcode.\n ';
          type: 'boolean';
        };
        force_pmi_jbh_password: {
          description: 'Require a passcode for personal meetings if attendees can join before host.';
          type: 'boolean';
        };
        host_video: {
          description: 'Start meetings with host video on.';
          type: 'boolean';
        };
        join_before_host: {
          description: 'Join the meeting before host arrives.';
          type: 'boolean';
        };
        meeting_password_requirement: {
          description: 'Account wide meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
          properties: {
            consecutive_characters_length: {
              enum: [0, 4, 5, 6, 7, 8];
              type: 'integer';
            };
            have_letter: {
              description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
              type: 'boolean';
            };
            have_number: {
              description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
              type: 'boolean';
            };
            have_special_character: {
              description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
              type: 'boolean';
            };
            have_upper_and_lower_characters: {
              description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
              type: 'boolean';
            };
            length: {
              description: 'The minimum length that the meeting/webinar passcode needs to have.';
              type: 'integer';
            };
            only_allow_numeric: {
              description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
              type: 'boolean';
            };
            weak_enhance_detection: {
              description: 'If set to `true`, users will be informed if the provided passcode is weak.';
              type: 'boolean';
            };
          };
          type: 'object';
        };
        participants_video: {
          description: 'Start meetings with participants video on.';
          type: 'boolean';
        };
        personal_meeting: {
          description: 'Personal Meeting Setting.<br><br>\n`true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.\nFor Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n';
          type: 'boolean';
        };
        pmi_password: {
          description: 'PMI passcode\n';
          type: 'string';
        };
        pstn_password_protected: {
          description: 'Generate and require passcode for participants joining by phone.';
          type: 'boolean';
        };
        require_password_for_instant_meetings: {
          description: 'Require a passcode for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
          type: 'boolean';
        };
        require_password_for_pmi_meetings: {
          description: 'Require a passcode for Personal Meeting ID (PMI). This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
          enum: ['jbh_only', 'all', 'none'];
          type: 'string';
          'x-enum-descriptions': ['Only meetings with Join Before Host enabled', 'All meetings using PMI', 'Disabled'];
        };
        require_password_for_scheduled_meetings: {
          description: 'Require a passcode for meetings which have already been scheduled\n';
          type: 'boolean';
        };
        require_password_for_scheduling_new_meetings: {
          description: 'Require a passcode when scheduling new meetings.This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
          type: 'boolean';
        };
        use_pmi_for_instant_meetings: {
          description: 'Use Personal Meeting ID (PMI) when starting an instant meeting\n';
          type: 'boolean';
        };
        use_pmi_for_scheduled_meetings: {
          description: 'Use Personal Meeting ID (PMI) when scheduling a meeting\n';
          type: 'boolean';
        };
      };
      title: 'User settings: Meeting settings';
      type: 'object';
    };
    UserSettingsTSP: {
      description: 'Account Settings: TSP.';
      properties: {
        call_out: {
          description: 'Call Out';
          type: 'boolean';
        };
        call_out_countries: {
          description: 'Call Out Countries/Regions';
          items: {};
          type: 'array';
        };
        show_international_numbers_link: {
          description: 'Show international numbers link on the invitation email';
          type: 'boolean';
        };
      };
      title: 'User settings: TSP settings';
      type: 'object';
    };
    UserSettingsTelephony: {
      properties: {
        audio_conference_info: {
          default: '';
          description: 'Third party audio conference info.';
          maxLength: 2048;
          type: 'string';
        };
        show_international_numbers_link: {
          description: 'Show the international numbers link on the invitation email.';
          type: 'boolean';
        };
        telephony_regions: {
          description: 'Indicates where most of the participants call into or call from duriing a meeting.';
          properties: {
            allowed_values: {
              description: 'Telephony region options provided by Zoom to select from.';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            selection_values: {
              description: 'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.';
              items: {
                type: 'string';
              };
              type: 'array';
            };
          };
          type: 'object';
        };
        third_party_audio: {
          description: 'Third party audio conference.';
          type: 'boolean';
        };
      };
      title: 'User settings: Meeting settings';
      type: 'object';
    };
    UserSettingsUpdate: {
      properties: {
        email_notification: {
          description: '';
          properties: {
            alternative_host_reminder: {
              default: false;
              description: 'When an alternative host is set or removed from a meeting.';
              type: 'boolean';
            };
            cancel_meeting_reminder: {
              default: false;
              description: 'When a meeting is cancelled.';
              type: 'boolean';
            };
            jbh_reminder: {
              default: false;
              description: 'When attendees join meeting before host.';
              type: 'boolean';
            };
            schedule_for_reminder: {
              default: false;
              description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.';
              type: 'boolean';
            };
          };
          title: 'User settings: Notification settings';
          type: 'object';
        };
        feature: {
          description: '';
          properties: {
            large_meeting: {
              description: 'Enable [large meeting](https://support.zoom.us/hc/en-us/articles/201362823-What-is-a-Large-Meeting-) feature for the user.';
              type: 'boolean';
            };
            large_meeting_capacity: {
              description: 'Set the meeting capacity for the user if the user has **Large meeting** feature enabled. The value for the field can be either 500 or 1000.';
              type: 'integer';
            };
            meeting_capacity: {
              description: "Set a user's meeting capacity. User’s meeting capacity denotes the maximum number of participants that can join a meeting scheduled by the user.";
              type: 'integer';
            };
            webinar: {
              description: 'Enable Webinar feature for the user.';
              type: 'boolean';
            };
            webinar_capacity: {
              description: 'Set the Webinar capacity for a user who has the Webinar feature enabled. The value of this field can be 100, 500, 1000, 3000, 5000 or 10000.';
              type: 'integer';
            };
            zoom_phone: {
              description: 'Zoom phone feature.';
              type: 'boolean';
            };
          };
          title: 'User settings: Feature settings';
          type: 'object';
        };
        in_meeting: {
          description: '';
          properties: {
            allow_live_streaming: {
              description: 'Allow live streaming.';
              type: 'boolean';
            };
            annotation: {
              default: false;
              description: 'Allow participants to use annotation tools.';
              type: 'boolean';
            };
            attendee_on_hold: {
              default: false;
              description: 'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**';
              type: 'boolean';
            };
            auto_saving_chat: {
              default: false;
              description: 'Auto save all in-meeting chats.';
              type: 'boolean';
            };
            breakout_room: {
              default: false;
              description: 'Allow host to split meeting participants into separate breakout rooms.';
              type: 'boolean';
            };
            chat: {
              default: false;
              description: 'Enable chat during meeting for all participants.';
              type: 'boolean';
            };
            closed_caption: {
              default: false;
              description: 'Enable closed captions.';
              type: 'boolean';
            };
            co_host: {
              default: false;
              description: 'Allow the host to add co-hosts.';
              type: 'boolean';
            };
            custom_data_center_regions: {
              description: 'If set to `true`, you can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting your real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.';
              type: 'boolean';
            };
            custom_live_streaming_service: {
              description: 'Allow custom live streaming.';
              type: 'boolean';
            };
            custom_service_instructions: {
              description: 'Custom service instructions.';
              type: 'string';
            };
            data_center_regions: {
              description: 'If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["DE", "NL", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).\n';
              enum: ['HK', 'AU', 'IN', 'TY', 'CN', 'US', 'CA', 'DE', 'NL', 'LA'];
              items: {
                type: 'string';
              };
              type: 'array';
            };
            e2e_encryption: {
              description: 'Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).';
              type: 'boolean';
            };
            entry_exit_chime: {
              default: 'all';
              description: 'Play sound when participants join or leave:<br>`host` - When host joins or leaves.<br>`all` - When any participant joins or leaves.<br>`none` - No join or leave sound.';
              enum: ['host', 'all', 'none'];
              type: 'string';
              'x-enum-descriptions': [
                'when host joins/leaves',
                'when any participant joins/leaves',
                'no join/leave sound',
              ];
            };
            far_end_camera_control: {
              default: false;
              description: 'Allow another user to take control of the camera.';
              type: 'boolean';
            };
            feedback: {
              default: false;
              description: 'Enable option to send feedback to Zoom at the end of the meeting.';
              type: 'boolean';
            };
            file_transfer: {
              description: 'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for the user or not.';
              type: 'boolean';
            };
            group_hd: {
              default: false;
              description: 'Enable group HD video.';
              type: 'boolean';
            };
            non_verbal_feedback: {
              default: false;
              description: 'Enable non-verbal feedback through screens.';
              type: 'boolean';
            };
            polling: {
              default: false;
              description: 'Add polls to the meeting controls.';
              type: 'boolean';
            };
            private_chat: {
              default: false;
              description: 'Enable 1:1 private chat between participants during meetings.';
              type: 'boolean';
            };
            record_play_voice: {
              description: 'Record and play their own voice.';
              type: 'boolean';
            };
            remote_control: {
              default: false;
              description: 'Enable remote control during screensharing.';
              type: 'boolean';
            };
            remote_support: {
              default: false;
              description: 'Allow host to provide 1:1 remote support to a participant.';
              type: 'boolean';
            };
            request_permission_to_unmute: {
              description: 'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the user or not.';
              type: 'boolean';
            };
            screen_sharing: {
              description: 'Allow host and participants to share their screen or content during meetings\n';
              type: 'boolean';
            };
            share_dual_camera: {
              default: false;
              description: 'Share dual camera (deprecated).';
              type: 'boolean';
            };
            show_meeting_control_toolbar: {
              description: 'Always show meeting controls during a meeting.';
              type: 'boolean';
            };
            virtual_background: {
              default: false;
              description: 'Enable virtual background.';
              type: 'boolean';
            };
            virtual_background_settings: {
              description: 'Settings to manage virtual background.';
              properties: {
                allow_upload_custom: {
                  description: 'Allow user to upload custom backgrounds.';
                  type: 'boolean';
                };
                allow_videos: {
                  description: 'Allow use of videos for virtual backgrounds.';
                  type: 'boolean';
                };
                enable: {
                  description: 'Enable virtual background.';
                  type: 'boolean';
                };
                files: {
                  items: {
                    properties: {
                      id: {
                        description: 'Unique identifier of the file.';
                        type: 'string';
                      };
                      is_default: {
                        description: 'Indicates whether or not this file is the default virtual background file.';
                        type: 'boolean';
                      };
                      name: {
                        description: 'File name.';
                        type: 'string';
                      };
                      size: {
                        description: 'File size.';
                        type: 'string';
                      };
                      type: {
                        description: 'File type.';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            waiting_room: {
              default: false;
              description: 'Enable Waiting room - if enabled, attendees can only join after host approves.';
              type: 'boolean';
            };
            who_can_share_screen: {
              description: 'Indicates who can share their screen or content during meetings. The value can be one of the following: <br>\n`host`: Only host can share the screen.<br>\n`all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
              enum: ['host', 'all'];
              type: 'string';
            };
            who_can_share_screen_when_someone_is_sharing: {
              description: 'Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>\n`host`: Only a host can share the screen when someone else is sharing.<br>\n`all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n';
              enum: ['host', 'all'];
              type: 'string';
            };
            workplace_by_facebook: {
              description: 'Allow livestreaming by host through Workplace by Facebook.';
              type: 'boolean';
            };
          };
          title: 'User settings: Meeting settings';
          type: 'object';
        };
        profile: {
          properties: {
            recording_storage_location: {
              properties: {
                allowed_values: {
                  description: 'Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.\n\nProvide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                value: {
                  description: 'Abbreviated country code.';
                  type: 'string';
                };
              };
              type: 'object';
            };
          };
          title: 'Profile';
          type: 'object';
        };
        recording: {
          description: '';
          properties: {
            ask_host_to_confirm_disclaimer: {
              description: 'Ask host to confirm the disclaimer.';
              type: 'boolean';
            };
            ask_participants_to_consent_disclaimer: {
              description: 'This field can be used if `recording_disclaimer` is set to true. This field indicates whether or not you would like to ask participants for consent when a recording starts. The value can be one of the following:<br>\n* `true`: Ask participants for consent when a recording starts. <br>\n* `false`: Do not ask participants for consent when a recording starts.';
              type: 'boolean';
            };
            auto_delete_cmr: {
              default: false;
              description: 'Auto delete cloud recordings.';
              type: 'boolean';
            };
            auto_delete_cmr_days: {
              description: 'A specified number of days of auto delete cloud recordings.';
              maximum: 60;
              minimum: 1;
              type: 'integer';
            };
            auto_recording: {
              default: 'local';
              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` - Record on cloud.<br>`none` - Disabled.';
              enum: ['local', 'cloud', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Record on local', 'Record on cloud', 'Disabled'];
            };
            cloud_recording: {
              default: false;
              description: 'Cloud recording.';
              type: 'boolean';
            };
            host_pause_stop_recording: {
              default: false;
              description: 'Host can pause/stop the auto recording in the cloud.';
              type: 'boolean';
            };
            ip_address_access_control: {
              description: 'Setting to allow cloud recording access only from specific IP address ranges.\n';
              properties: {
                enable: {
                  description: 'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n';
                  type: 'boolean';
                };
                ip_addresses_or_ranges: {
                  description: 'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n';
                  type: 'string';
                };
              };
              type: 'object';
            };
            local_recording: {
              description: 'Local recording.';
              type: 'boolean';
            };
            record_audio_file: {
              default: false;
              description: 'Record an audio only file.';
              type: 'boolean';
            };
            record_gallery_view: {
              default: false;
              description: 'Record the gallery view.';
              type: 'boolean';
            };
            record_speaker_view: {
              default: false;
              description: 'Record the active speaker view.';
              type: 'boolean';
            };
            recording_audio_transcript: {
              description: 'Audio transcript.';
              type: 'boolean';
            };
            recording_disclaimer: {
              description: 'Show a disclaimer to participants before a recording starts\n';
              type: 'boolean';
            };
            recording_password_requirement: {
              description: 'This object represents the minimum passcode requirements set for recordings via Account Recording Settings.';
              properties: {
                have_letter: {
                  description: 'Indicates whether or not passcode must contain at least one alphabetical letter (a, b, c..).';
                  type: 'boolean';
                };
                have_number: {
                  description: 'Indicates whether or not passcode must contain at least one number(1, 2, 3..).';
                  type: 'boolean';
                };
                have_special_character: {
                  description: 'Indicates whether or not passcode must contain at least one special character(!, @, #..).';
                  type: 'boolean';
                };
                length: {
                  description: 'Minimum required length for the passcode.';
                  maximum: 10;
                  type: 'integer';
                };
                only_allow_numeric: {
                  description: 'Indicates whether or not passcode must contain only numeric characters.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            save_chat_text: {
              default: false;
              description: 'Save chat text from the meeting.';
              type: 'boolean';
            };
            show_timestamp: {
              default: false;
              description: 'Show timestamp on video.';
              type: 'boolean';
            };
          };
          title: 'User settings: Recording settings';
          type: 'object';
        };
        schedule_meeting: {
          description: '';
          properties: {
            audio_type: {
              default: 'voip';
              description: 'Determine how participants can join the audio portion of the meeting:<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - Third party audio conference.';
              enum: ['both', 'telephony', 'voip', 'thirdParty'];
              type: 'string';
              'x-enum-descriptions': [
                'Telephony and VoIP',
                'Audio PSTN telephony only',
                'VoIP only',
                '3rd party audio conference',
              ];
            };
            default_password_for_scheduled_meetings: {
              description: 'Passcode for already scheduled meetings\n';
              type: 'string';
            };
            embed_password_in_join_link: {
              description: 'If the value is set to `true`, the meeting passcode will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the passcode.\n ';
              type: 'boolean';
            };
            force_pmi_jbh_password: {
              description: 'Require a passcode for personal meetings if attendees can join before host.';
              type: 'boolean';
            };
            host_video: {
              description: 'Start meetings with host video on.';
              type: 'boolean';
            };
            join_before_host: {
              description: 'Join the meeting before host arrives.';
              type: 'boolean';
            };
            meeting_password_requirement: {
              description: 'Account wide meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).';
              properties: {
                consecutive_characters_length: {
                  enum: [0, 4, 5, 6, 7, 8];
                  type: 'integer';
                };
                have_letter: {
                  description: 'If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).\n';
                  type: 'boolean';
                };
                have_number: {
                  description: 'If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).';
                  type: 'boolean';
                };
                have_special_character: {
                  description: 'If set to `true`, the passcode must have at least 1 special character (!,@,#...).';
                  type: 'boolean';
                };
                have_upper_and_lower_characters: {
                  description: 'If set to `true`, the passcode must include both uppercase and lowercase characters.';
                  type: 'boolean';
                };
                length: {
                  description: 'The minimum length that the meeting/webinar passcode needs to have.';
                  type: 'integer';
                };
                only_allow_numeric: {
                  description: 'If set to `true`, the passcode must only contain numbers and no other characters.';
                  type: 'boolean';
                };
                weak_enhance_detection: {
                  description: 'If set to `true`, users will be informed if the provided passcode is weak.';
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            participants_video: {
              description: 'Start meetings with participants video on.';
              type: 'boolean';
            };
            personal_meeting: {
              description: 'Personal Meeting Setting.<br><br>\n`true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.\nFor Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n';
              type: 'boolean';
            };
            pmi_password: {
              description: 'PMI passcode\n';
              type: 'string';
            };
            pstn_password_protected: {
              description: 'Generate and require passcode for participants joining by phone.';
              type: 'boolean';
            };
            require_password_for_instant_meetings: {
              description: 'Require a passcode for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
              type: 'boolean';
            };
            require_password_for_pmi_meetings: {
              description: 'Require a passcode for Personal Meeting ID (PMI). This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
              enum: ['jbh_only', 'all', 'none'];
              type: 'string';
              'x-enum-descriptions': [
                'Only meetings with Join Before Host enabled',
                'All meetings using PMI',
                'Disabled',
              ];
            };
            require_password_for_scheduled_meetings: {
              description: 'Require a passcode for meetings which have already been scheduled\n';
              type: 'boolean';
            };
            require_password_for_scheduling_new_meetings: {
              description: 'Require a passcode when scheduling new meetings.This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n';
              type: 'boolean';
            };
            use_pmi_for_instant_meetings: {
              description: 'Use Personal Meeting ID (PMI) when starting an instant meeting\n';
              type: 'boolean';
            };
            use_pmi_for_scheduled_meetings: {
              description: 'Use Personal Meeting ID (PMI) when scheduling a meeting\n';
              type: 'boolean';
            };
          };
          title: 'User settings: Meeting settings';
          type: 'object';
        };
        telephony: {
          properties: {
            audio_conference_info: {
              default: '';
              description: 'Third party audio conference info.';
              maxLength: 2048;
              type: 'string';
            };
            show_international_numbers_link: {
              description: 'Show the international numbers link on the invitation email.';
              type: 'boolean';
            };
            telephony_regions: {
              description: 'Indicates where most of the participants call into or call from duriing a meeting.';
              properties: {
                selection_values: {
                  description: 'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
              };
              type: 'object';
            };
            third_party_audio: {
              description: 'Third party audio conference.';
              type: 'boolean';
            };
          };
          title: 'Telephony update settings: Meeting settings';
          type: 'object';
        };
        tsp: {
          description: 'Account Settings: TSP.';
          properties: {
            call_out: {
              description: 'Call Out';
              type: 'boolean';
            };
            call_out_countries: {
              description: 'Call Out Countries/Regions';
              items: {};
              type: 'array';
            };
            show_international_numbers_link: {
              description: 'Show international numbers link on the invitation email';
              type: 'boolean';
            };
          };
          title: 'User settings: TSP settings';
          type: 'object';
        };
      };
      title: 'User settings';
      type: 'object';
    };
    UserUpdate: {
      description: 'The user update object represents a user on Zoom.';
      properties: {
        cms_user_id: {
          description: 'Kaltura user ID.';
          type: 'string';
        };
        company: {
          description: "User's company.";
          maxLength: 255;
          type: 'string';
        };
        custom_attributes: {
          description: 'Custom attribute(s) of the user.';
          properties: {
            key: {
              description: 'Identifier for the custom attribute.';
              type: 'string';
            };
            name: {
              description: 'Name of the custom attribute.';
              type: 'string';
            };
            value: {
              description: 'Value of the custom attribute.';
              type: 'string';
            };
          };
          type: 'object';
        };
        dept: {
          description: 'Department for user profile: use for report.';
          type: 'string';
        };
        first_name: {
          description: "User's first name. Cannot contain more than 5 Chinese characters.";
          maxLength: 64;
          type: 'string';
        };
        group_id: {
          description: 'Provide unique identifier of the group that you would like to add a [pending user](https://support.zoom.us/hc/en-us/articles/201363183-Managing-users#h_13c87a2a-ecd6-40ad-be61-a9935e660edb) to. The value of this field can be retrieved from [List Groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups) API.';
          type: 'string';
        };
        host_key: {
          description: 'Host key. It should be a 6-10 digit number.';
          maxLength: 10;
          minLength: 6;
          type: 'string';
        };
        job_title: {
          description: "User's job title.";
          maxLength: 128;
          type: 'string';
        };
        language: {
          description: 'language';
          type: 'string';
        };
        last_name: {
          description: "User's last name. Cannot contain more than 5 Chinese characters.";
          maxLength: 64;
          type: 'string';
        };
        location: {
          description: "User's location.";
          maxLength: 256;
          type: 'string';
        };
        manager: {
          description: 'The manager for the user.';
          format: 'email';
          type: 'string';
        };
        phone_country: {
          description: '**Note:** This field has been **deprecated** and will not be supported in the future. Use the **country** field of the **phone_numbers** object instead to select the country for the phone number.\n\n\n\n[Country ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) of the phone number. For example, if the phone number provided in the `phone_number` field is a Brazil based number, the value of the `phone_country` field should be `BR`.';
          type: 'string';
        };
        phone_number: {
          description: '**Note:** This field has been **deprecated** and will not be supported in the future. Use the **phone_numbers** field instead to assign phone number(s) to a user.\n\n\nPhone number of the user. To update a phone number, you must also provide the `phone_country` field.';
          type: 'string';
        };
        phone_numbers: {
          properties: {
            code: {
              description: 'Country code of the phone number. For example, for United States phone numbers, the value of this field should be "+1".';
              type: 'string';
            };
            country: {
              description: '[Country ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) of the phone number. For example, if the phone number provided in the `number` field is a Brazil based number, the value of the `country` field should be `BR`.';
              type: 'string';
            };
            number: {
              description: 'Phone number of the user.';
              type: 'string';
            };
          };
          type: 'object';
        };
        pmi: {
          description: 'Personal meeting ID: length must be 10.';
          maxLength: 10;
          minLength: 10;
          type: 'integer';
        };
        timezone: {
          description: 'The time zone ID for a user profile. For this parameter value please refer to the ID value in the [timezone](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) list.';
          type: 'string';
        };
        type: {
          description: 'User types:<br>`1` - Basic.<br>`2` - Licensed.<br>`3` - On-prem.<br>`99` - None (this can only be set with `ssoCreate`).';
          enum: [1, 2, 3, 99];
          type: 'integer';
        };
        use_pmi: {
          default: false;
          description: 'Use Personal Meeting ID for instant meetings.';
          type: 'boolean';
        };
        vanity_name: {
          description: 'Personal meeting room name.';
          type: 'string';
        };
      };
      type: 'object';
    };
    Webinar: {
      allOf: [
        {
          description: 'Base webinar object for sessions.';
          properties: {
            agenda: {
              description: 'Webinar description.';
              type: 'string';
            };
            duration: {
              description: 'Webinar duration (minutes). Used for scheduled webinars only.';
              type: 'integer';
            };
            password: {
              description: 'Webinar Passcode. Passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ *]. Max of 10 characters.';
              type: 'string';
            };
            recurrence: {
              description: 'Recurrence object. Use this object only for a webinar of type `9` i.e., a recurring webinar with fixed time. ';
              properties: {
                end_date_time: {
                  description: 'Select a date when the webinar will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
                  format: 'date-time';
                  type: 'string';
                };
                end_times: {
                  default: 1;
                  description: 'Select how many times the webinar will recur before it is canceled. (Cannot be used with "end_date_time".)';
                  maximum: 365;
                  type: 'integer';
                };
                monthly_day: {
                  description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state which day in a month, the webinar should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the webinar to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the webinar to recur once every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
                  type: 'integer';
                };
                monthly_week: {
                  description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state the week of the month when the webinar should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the webinar should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
                  enum: [-1, 1, 2, 3, 4];
                  type: 'integer';
                  'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
                };
                monthly_week_day: {
                  description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state a specific day in a week when the monthly webinar should recur. To use this field, you must also use the `monthly_week` field. <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
                  enum: [1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
                };
                repeat_interval: {
                  description: 'Define the interval at which the webinar should recur. For instance, if you would like to schedule a Webinar that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily webinar, the maximum interval you can set is `90` days. For a weekly webinar, the maximum interval that you can set is `12` weeks. For a monthly webinar, the maximum interval that you can set is `3` months.';
                  type: 'integer';
                };
                type: {
                  description: 'Recurrence webinar types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
                  enum: [1, 2, 3];
                  type: 'integer';
                  'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
                };
                weekly_days: {
                  description: 'Use this field **only if you\'re scheduling a recurring webinar of type** `2` to state which day(s) of the week the webinar should repeat. <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the Webinar should recur on Sunday, provide `"1"` as the value of this field.  <br><br> **Note:** If you would like the webinar to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the Webinar should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n<br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.\n\n';
                  type: 'string';
                };
              };
              required: ['type'];
              title: 'Recurrence Webinar';
              type: 'object';
            };
            settings: {
              description: 'Webinar settings.';
              properties: {
                allow_multiple_devices: {
                  description: 'Allow attendees to join from multiple devices.';
                  type: 'boolean';
                };
                alternative_hosts: {
                  description: 'Alternative host emails or IDs. Multiple values separated by comma.';
                  type: 'string';
                };
                approval_type: {
                  default: 2;
                  description: '`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
                  enum: [0, 1, 2];
                  type: 'integer';
                  'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
                };
                attendees_and_panelists_reminder_email_notification: {
                  description: 'Send reminder email to attendees and panelists.';
                  properties: {
                    enable: {
                      description: '* `true`: Send reminder email to attendees and panelists.\n\n* `false`: Do not send reminder email to attendees and panelists.';
                      type: 'boolean';
                    };
                    type: {
                      description: '`0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.';
                      enum: [0, 1, 2, 3, 4, 5, 6, 7];
                      type: 'integer';
                      'x-enum-descriptions': [
                        'Send 1 hour before webinar.',
                        'Send 1 day before webinar.',
                        'Send 1 hour and 1 day before webinar.',
                        'Send 1 week before webinar.',
                        'Send 1 hour and 1 week before webinar.',
                        'Send 1 day and 1 week before webinar.',
                        'Send 1 hour, 1 day and 1 week before webinar.',
                      ];
                    };
                  };
                  type: 'object';
                };
                audio: {
                  default: 'both';
                  description: 'Determine how participants can join the audio portion of the webinar.';
                  enum: ['both', 'telephony', 'voip'];
                  type: 'string';
                  'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
                };
                authentication_domains: {
                  description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
                  type: 'string';
                };
                authentication_name: {
                  description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
                  type: 'string';
                };
                authentication_option: {
                  description: 'Webinar authentication option id.';
                  type: 'string';
                };
                auto_recording: {
                  default: 'none';
                  description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
                  enum: ['local', 'cloud', 'none'];
                  type: 'string';
                  'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
                };
                close_registration: {
                  description: 'Close registration after event date.';
                  type: 'boolean';
                };
                contact_email: {
                  description: 'Contact email for registration';
                  type: 'string';
                };
                contact_name: {
                  description: 'Contact name for registration';
                  type: 'string';
                };
                email_language: {
                  description: 'Set the email language to one of the following:\n`en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.';
                  type: 'string';
                };
                enforce_login: {
                  description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.';
                  type: 'boolean';
                };
                enforce_login_domains: {
                  description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.';
                  type: 'string';
                };
                follow_up_absentees_email_notification: {
                  description: 'Send follow-up email to absentees.';
                  properties: {
                    enable: {
                      description: '* `true`: Send follow-up email to absentees.\n\n* `false`: Do not send follow-up email to absentees.';
                      type: 'boolean';
                    };
                    type: {
                      description: '`0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
                      enum: [0, 1, 2, 3, 4, 5, 6, 7];
                      type: 'integer';
                      'x-enum-descriptions': [
                        'Send 1 days after the scheduled end date.',
                        'Send 2 days after the scheduled end date.',
                        'Send 3 days after the scheduled end date.',
                        'Send 4 days after the scheduled end date.',
                        'Send 5 days after the scheduled end date.',
                        'Send 6 days after the scheduled end date.',
                        'Send 7 days after the scheduled end date.',
                      ];
                    };
                  };
                  type: 'object';
                };
                follow_up_attendees_email_notification: {
                  description: 'Send follow-up email to attendees.';
                  properties: {
                    enable: {
                      description: '* `true`: Send follow-up email to attendees.\n\n* `false`: Do not send follow-up email to attendees.';
                      type: 'boolean';
                    };
                    type: {
                      description: '`0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
                      enum: [0, 1, 2, 3, 4, 5, 6, 7];
                      type: 'integer';
                      'x-enum-descriptions': [
                        'Send 1 day after the scheduled end date.',
                        'Send 2 days after the scheduled end date.',
                        'Send 3 days after the scheduled end date.',
                        'Send 4 days after the scheduled end date.',
                        'Send 5 days after the scheduled end date.',
                        'Send 6 days after the scheduled end date.',
                        'Send 7 days after the scheduled end date.',
                      ];
                    };
                  };
                  type: 'object';
                };
                global_dial_in_countries: {
                  description: 'List of global dial-in countries';
                  items: {
                    type: 'string';
                  };
                  type: 'array';
                };
                hd_video: {
                  default: false;
                  description: 'Default to HD video.';
                  type: 'boolean';
                };
                host_video: {
                  description: 'Start video when host joins webinar.';
                  type: 'boolean';
                };
                meeting_authentication: {
                  description: '`true`- Only authenticated users can join Webinar.';
                  type: 'boolean';
                };
                notify_registrants: {
                  description: 'Send notification email to registrants when the host updates a webinar.';
                  type: 'boolean';
                };
                on_demand: {
                  default: false;
                  description: 'Make the webinar on-demand';
                  type: 'boolean';
                };
                panelists_invitation_email_notification: {
                  description: '* `true`: Send invitation email to panelists.\n\n* `false`: Do not send invitation email to panelists.';
                  type: 'boolean';
                };
                panelists_video: {
                  description: 'Start video when panelists join webinar.';
                  type: 'boolean';
                };
                post_webinar_survey: {
                  description: "Zoom will open a survey page in attendees' browsers after leaving the webinar";
                  type: 'boolean';
                };
                practice_session: {
                  default: false;
                  description: 'Enable practice session.';
                  type: 'boolean';
                };
                question_and_answer: {
                  description: "[Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.";
                  properties: {
                    allow_anonymous_questions: {
                      description: '* `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..\n\n* `false`: Do not allow anonymous questions.';
                      type: 'boolean';
                    };
                    answer_questions: {
                      description: 'Indicate whether you want attendees to be able to view answered questions only or view all questions.\n\n* `only`: Attendees are able to view answered questions only.\n\n*  `all`: Attendees are able to view all questions submitted in the Q&A.';
                      enum: ['only', 'all'];
                      type: 'string';
                    };
                    attendees_can_comment: {
                      description: '* `true`: Attendees can answer questions or leave a comment in the question thread.\n\n* `false`: Attendees can not answer questions or leave a comment in the question thread';
                      type: 'boolean';
                    };
                    attendees_can_upvote: {
                      description: '* `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.\n\n* `false`: Attendees can not click the thumbs up butoon on questions.';
                      type: 'boolean';
                    };
                    enable: {
                      description: "* `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.\n\n* `false`: Disable Q&A for webinar.";
                      type: 'boolean';
                    };
                  };
                  type: 'object';
                };
                registrants_confirmation_email: {
                  description: 'Send confirmation email to registrants';
                  type: 'boolean';
                };
                registrants_email_notification: {
                  description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
                  type: 'boolean';
                };
                registrants_restrict_number: {
                  default: 0;
                  description: 'Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.';
                  maximum: 20000;
                  minimum: 0;
                  type: 'integer';
                };
                registration_type: {
                  default: 1;
                  description: 'Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.';
                  enum: [1, 2, 3];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Attendees register once and can attend any of the occurrences',
                    'Attendees need to register for each occurrence to attend',
                    'Attendees register once and can choose one or more occurrences to attend',
                  ];
                };
                show_share_button: {
                  description: 'Show social share buttons on the registration page.';
                  type: 'boolean';
                };
                survey_url: {
                  description: 'Survey url for post webinar survey';
                  type: 'string';
                };
              };
              type: 'object';
            };
            start_time: {
              description: 'Webinar start time. We support two formats for `start_time` - local time and GMT.<br> \n\nTo set time as GMT the format should be `yyyy-MM-dd`T`HH:mm:ssZ`.\n\nTo set time using a specific timezone, use `yyyy-MM-dd`T`HH:mm:ss` format and specify the timezone [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) in the `timezone` field OR leave it blank and the timezone set on your Zoom account will be used. You can also set the time as UTC as the timezone field.\n\nThe `start_time` should only be used for scheduled and / or recurring webinars with fixed time.';
              format: 'date-time';
              type: 'string';
            };
            timezone: {
              description: 'Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.';
              type: 'string';
            };
            topic: {
              description: 'Webinar topic.';
              type: 'string';
            };
            tracking_fields: {
              description: 'Tracking fields';
              items: {
                properties: {
                  field: {
                    description: 'Tracking fields type';
                    type: 'string';
                  };
                  value: {
                    description: 'Tracking fields value';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            type: {
              default: 5;
              description: 'Webinar Types:<br>`5` - Webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.';
              enum: [5, 6, 9];
              type: 'integer';
              'x-enum-descriptions': [
                'Webinar',
                'Recurring Webinar with no fixed time',
                'Recurring Webinar with fixed time',
              ];
            };
          };
          type: 'object';
        },
      ];
      description: 'Webinar object.';
      type: 'object';
    };
    WebinarInfo: {
      description: 'Webinar object.';
      properties: {
        agenda: {
          description: 'Webinar agenda.';
          type: 'string';
        };
        created_at: {
          description: 'Create time.';
          format: 'date-time';
          type: 'string';
        };
        duration: {
          description: 'Webinar duration.';
          type: 'integer';
        };
        join_url: {
          description: 'URL to join the Webinar. This URL should only be shared with the users who should be invited to the Webinar.';
          type: 'string';
        };
        occurrences: {
          description: 'Array of occurrence objects.';
          items: {
            description: 'Occurence object. This object is only returned for Recurring Webinars.';
            properties: {
              duration: {
                description: 'Duration.';
                type: 'integer';
              };
              occurrence_id: {
                description: 'Occurrence ID: Unique Identifier that identifies an occurrence of a recurring webinar. [Recurring webinars](https://support.zoom.us/hc/en-us/articles/216354763-How-to-Schedule-A-Recurring-Webinar) can have a maximum of 50 occurrences.';
                type: 'string';
              };
              start_time: {
                description: 'Start time.';
                format: 'date-time';
                type: 'string';
              };
              status: {
                description: 'Occurrence status.';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        password: {
          description: 'Webinar passcode. \n\nIf "Require a passcode when scheduling new meetings" setting has been **enabled** **and** [locked](https://support.zoom.us/hc/en-us/articles/115005269866-Using-Tiered-Settings#locked) for the user, the passcode field will be autogenerated for the Webinar in the response even if it is not provided in the API request. <br><br>\n**Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the  [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API. \n\n\n\n\n\n';
          maxLength: 10;
          type: 'string';
        };
        recurrence: {
          description: 'Recurrence object. Use this object only for a webinar of type `9` i.e., a recurring webinar with fixed time. ';
          properties: {
            end_date_time: {
              description: 'Select a date when the webinar will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
              format: 'date-time';
              type: 'string';
            };
            end_times: {
              default: 1;
              description: 'Select how many times the webinar will recur before it is canceled. (Cannot be used with "end_date_time".)';
              maximum: 365;
              type: 'integer';
            };
            monthly_day: {
              description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state which day in a month, the webinar should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the webinar to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the webinar to recur once every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
              type: 'integer';
            };
            monthly_week: {
              description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state the week of the month when the webinar should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the webinar should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
              enum: [-1, 1, 2, 3, 4];
              type: 'integer';
              'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
            };
            monthly_week_day: {
              description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state a specific day in a week when the monthly webinar should recur. To use this field, you must also use the `monthly_week` field. <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
              enum: [1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
            };
            repeat_interval: {
              description: 'Define the interval at which the webinar should recur. For instance, if you would like to schedule a Webinar that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily webinar, the maximum interval you can set is `90` days. For a weekly webinar, the maximum interval that you can set is `12` weeks. For a monthly webinar, the maximum interval that you can set is `3` months.';
              type: 'integer';
            };
            type: {
              description: 'Recurrence webinar types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
            };
            weekly_days: {
              description: 'Use this field **only if you\'re scheduling a recurring webinar of type** `2` to state which day(s) of the week the webinar should repeat. <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the Webinar should recur on Sunday, provide `"1"` as the value of this field.  <br><br> **Note:** If you would like the webinar to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the Webinar should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n<br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.\n\n';
              type: 'string';
            };
          };
          required: ['type'];
          title: 'Recurrence Webinar';
          type: 'object';
        };
        settings: {
          description: 'Webinar settings.';
          properties: {
            allow_multiple_devices: {
              description: 'Allow attendees to join from multiple devices.';
              type: 'boolean';
            };
            alternative_hosts: {
              description: 'Alternative host emails or IDs. Multiple values separated by comma.';
              type: 'string';
            };
            approval_type: {
              default: 2;
              description: '`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
              enum: [0, 1, 2];
              type: 'integer';
              'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
            };
            attendees_and_panelists_reminder_email_notification: {
              description: 'Send reminder email to attendees and panelists.';
              properties: {
                enable: {
                  description: '* `true`: Send reminder email to attendees and panelists.\n\n* `false`: Do not send reminder email to attendees and panelists.';
                  type: 'boolean';
                };
                type: {
                  description: '`0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.';
                  enum: [0, 1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Send 1 hour before webinar.',
                    'Send 1 day before webinar.',
                    'Send 1 hour and 1 day before webinar.',
                    'Send 1 week before webinar.',
                    'Send 1 hour and 1 week before webinar.',
                    'Send 1 day and 1 week before webinar.',
                    'Send 1 hour, 1 day and 1 week before webinar.',
                  ];
                };
              };
              type: 'object';
            };
            audio: {
              default: 'both';
              description: 'Determine how participants can join the audio portion of the webinar.';
              enum: ['both', 'telephony', 'voip'];
              type: 'string';
              'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
            };
            authentication_domains: {
              description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
              type: 'string';
            };
            authentication_name: {
              description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
              type: 'string';
            };
            authentication_option: {
              description: 'Webinar authentication option id.';
              type: 'string';
            };
            auto_recording: {
              default: 'none';
              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
              enum: ['local', 'cloud', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
            };
            close_registration: {
              description: 'Close registration after event date.';
              type: 'boolean';
            };
            contact_email: {
              description: 'Contact email for registration';
              type: 'string';
            };
            contact_name: {
              description: 'Contact name for registration';
              type: 'string';
            };
            email_language: {
              description: 'Set the email language to one of the following:\n`en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.';
              type: 'string';
            };
            enforce_login: {
              description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.';
              type: 'boolean';
            };
            enforce_login_domains: {
              description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.';
              type: 'string';
            };
            follow_up_absentees_email_notification: {
              description: 'Send follow-up email to absentees.';
              properties: {
                enable: {
                  description: '* `true`: Send follow-up email to absentees.\n\n* `false`: Do not send follow-up email to absentees.';
                  type: 'boolean';
                };
                type: {
                  description: '`0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
                  enum: [0, 1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Send 1 days after the scheduled end date.',
                    'Send 2 days after the scheduled end date.',
                    'Send 3 days after the scheduled end date.',
                    'Send 4 days after the scheduled end date.',
                    'Send 5 days after the scheduled end date.',
                    'Send 6 days after the scheduled end date.',
                    'Send 7 days after the scheduled end date.',
                  ];
                };
              };
              type: 'object';
            };
            follow_up_attendees_email_notification: {
              description: 'Send follow-up email to attendees.';
              properties: {
                enable: {
                  description: '* `true`: Send follow-up email to attendees.\n\n* `false`: Do not send follow-up email to attendees.';
                  type: 'boolean';
                };
                type: {
                  description: '`0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
                  enum: [0, 1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Send 1 day after the scheduled end date.',
                    'Send 2 days after the scheduled end date.',
                    'Send 3 days after the scheduled end date.',
                    'Send 4 days after the scheduled end date.',
                    'Send 5 days after the scheduled end date.',
                    'Send 6 days after the scheduled end date.',
                    'Send 7 days after the scheduled end date.',
                  ];
                };
              };
              type: 'object';
            };
            global_dial_in_countries: {
              description: 'List of global dial-in countries';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            hd_video: {
              default: false;
              description: 'Default to HD video.';
              type: 'boolean';
            };
            host_video: {
              description: 'Start video when host joins webinar.';
              type: 'boolean';
            };
            meeting_authentication: {
              description: '`true`- Only authenticated users can join Webinar.';
              type: 'boolean';
            };
            notify_registrants: {
              description: 'Send notification email to registrants when the host updates a webinar.';
              type: 'boolean';
            };
            on_demand: {
              default: false;
              description: 'Make the webinar on-demand';
              type: 'boolean';
            };
            panelists_invitation_email_notification: {
              description: '* `true`: Send invitation email to panelists.\n\n* `false`: Do not send invitation email to panelists.';
              type: 'boolean';
            };
            panelists_video: {
              description: 'Start video when panelists join webinar.';
              type: 'boolean';
            };
            post_webinar_survey: {
              description: "Zoom will open a survey page in attendees' browsers after leaving the webinar";
              type: 'boolean';
            };
            practice_session: {
              default: false;
              description: 'Enable practice session.';
              type: 'boolean';
            };
            question_and_answer: {
              description: "[Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.";
              properties: {
                allow_anonymous_questions: {
                  description: '* `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..\n\n* `false`: Do not allow anonymous questions.';
                  type: 'boolean';
                };
                answer_questions: {
                  description: 'Indicate whether you want attendees to be able to view answered questions only or view all questions.\n\n* `only`: Attendees are able to view answered questions only.\n\n*  `all`: Attendees are able to view all questions submitted in the Q&A.';
                  enum: ['only', 'all'];
                  type: 'string';
                };
                attendees_can_comment: {
                  description: '* `true`: Attendees can answer questions or leave a comment in the question thread.\n\n* `false`: Attendees can not answer questions or leave a comment in the question thread';
                  type: 'boolean';
                };
                attendees_can_upvote: {
                  description: '* `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.\n\n* `false`: Attendees can not click the thumbs up butoon on questions.';
                  type: 'boolean';
                };
                enable: {
                  description: "* `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.\n\n* `false`: Disable Q&A for webinar.";
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            registrants_confirmation_email: {
              description: 'Send confirmation email to registrants';
              type: 'boolean';
            };
            registrants_email_notification: {
              description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
              type: 'boolean';
            };
            registrants_restrict_number: {
              default: 0;
              description: 'Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.';
              maximum: 20000;
              minimum: 0;
              type: 'integer';
            };
            registration_type: {
              default: 1;
              description: 'Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': [
                'Attendees register once and can attend any of the occurrences',
                'Attendees need to register for each occurrence to attend',
                'Attendees register once and can choose one or more occurrences to attend',
              ];
            };
            show_share_button: {
              description: 'Show social share buttons on the registration page.';
              type: 'boolean';
            };
            survey_url: {
              description: 'Survey url for post webinar survey';
              type: 'string';
            };
          };
          type: 'object';
        };
        start_time: {
          description: 'Webinar start time in GMT/UTC.';
          format: 'date-time';
          type: 'string';
        };
        start_url: {
          description: '<br><aside>The <code>start_url</code> of a Webinar is a URL using which a host or an alternative host can start the Webinar. This URL should only be used by the host of the meeting and should not be shared with anyone other than the host of the Webinar. \n\nThe expiration time for the <code>start_url</code> field listed in the response of [Create a Webinar API](https://marketplace.zoom.us/docs/api-reference/zoom-api/webinars/webinarcreate) is two hours for all regular users. \n\t\nFor users created using the <code>custCreate</code> option via the [Create Users](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usercreate) API, the expiration time of the <code>start_url</code> field is 90 days.\n\t\nFor security reasons, to retrieve the latest value for the <code>start_url</code> field programmatically (after expiry), you must call the [Retrieve a Webinar API](https://marketplace.zoom.us/docs/api-reference/zoom-api/webinars/webinar) and refer to the value of the <code>start_url</code> field in the response.</aside><br><br><br>';
          type: 'string';
        };
        timezone: {
          description: 'Time zone to format start_time.';
          type: 'string';
        };
        topic: {
          description: 'Webinar topic.';
          maxLength: 200;
          type: 'string';
        };
        tracking_fields: {
          description: 'Tracking fields';
          items: {
            properties: {
              field: {
                description: 'Tracking fields type';
                type: 'string';
              };
              value: {
                description: 'Tracking fields value';
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        type: {
          default: 5;
          description: 'Webinar Types:<br>`5` - Webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.';
          enum: [5, 6, 9];
          type: 'integer';
          'x-enum-descriptions': [
            'Webinar',
            'Recurring Webinar with no fixed time',
            'Recurring Webinar with fixed time',
          ];
        };
      };
      type: 'object';
    };
    WebinarInstances: {
      allOf: [
        {
          properties: {
            webinars: {
              description: 'List of ended webinar instances.';
              items: {
                allOf: [
                  {
                    properties: {
                      start_time: {
                        description: 'Start time.';
                        format: 'date-time';
                        type: 'string';
                      };
                      uuid: {
                        description: 'Webinar UUID.';
                        type: 'string';
                      };
                    };
                  },
                ];
                type: 'object';
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'List of webinars.';
      title: 'Webinar instances';
      type: 'object';
    };
    WebinarList: {
      allOf: [
        {
          description: 'Pagination Object.';
          properties: {
            next_page_token: {
              description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
              type: 'string';
            };
            page_count: {
              description: 'The number of pages returned for the request made.';
              type: 'integer';
            };
            page_number: {
              default: 1;
              description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
              type: 'integer';
            };
            page_size: {
              default: 30;
              description: 'The number of records returned with a single API call.';
              maximum: 300;
              type: 'integer';
            };
            total_records: {
              description: 'The total number of all the records available across pages.';
              type: 'integer';
            };
          };
          type: 'object';
        },
        {
          properties: {
            webinars: {
              description: 'List of webinar objects.';
              items: {
                allOf: [
                  {
                    properties: {
                      agenda: {
                        description: 'Webinar Description. The length of agenda gets truncated to 250 characters when you list all webinars for a user. To view the complete agenda, retrieve details for a single webinar [here](https://marketplace.zoom.us/docs/api-reference/zoom-api/webinars/webinar).';
                        type: 'string';
                      };
                      created_at: {
                        description: 'Time of webinar creation.';
                        format: 'date-time';
                        type: 'string';
                      };
                      duration: {
                        description: 'Meeting duration.';
                        type: 'integer';
                      };
                      host_id: {
                        description: 'ID of the host of the webinar.';
                        type: 'string';
                      };
                      id: {
                        description: 'Webinar ID in "**long**" format(represented as int64 data type in JSON), also known as the webinar number.';
                        format: 'int64';
                        type: 'integer';
                      };
                      join_url: {
                        description: 'Join URL of the webinar (using which others can join the webinar).';
                        type: 'string';
                      };
                      start_time: {
                        description: 'Scheduled start time of the Webinar.';
                        format: 'date-time';
                        type: 'string';
                      };
                      timezone: {
                        description: '[Timezone ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) for the Webinar.';
                        type: 'string';
                      };
                      topic: {
                        description: 'Meeting topic.';
                        type: 'string';
                      };
                      type: {
                        description: 'Webinar Types:<br>`5` - Webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.';
                        type: 'string';
                      };
                      uuid: {
                        description: 'Unique identifier of a Webinar. Each webinar instance will generate its own UUID. Once a Webinar ends, the value of uuid for the same webinar will be different from when it was scheduled.';
                        type: 'string';
                      };
                    };
                  },
                ];
                type: 'object';
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'List of webinars.';
      title: 'User List';
      type: 'object';
    };
    WebinarMetric: {
      description: 'Webinar metric details.';
      properties: {
        custom_keys: {
          description: 'Custom keys and values assigned to the Webinar.';
          items: {
            properties: {
              key: {
                description: 'Custom key associated with the Webinar.';
                maxLength: 64;
                type: 'string';
              };
              value: {
                description: 'Value of the custom key associated with the Webinar.';
                maxLength: 256;
                type: 'string';
              };
            };
            type: 'object';
          };
          maxItems: 10;
          type: 'array';
        };
        dept: {
          description: 'Department of the host.';
          type: 'string';
        };
        duration: {
          description: 'Webinar duration, formatted as hh:mm:ss, for example: `10:00` for ten minutes.';
          type: 'string';
        };
        email: {
          description: 'User email.';
          type: 'string';
        };
        end_time: {
          description: 'Webinar end time.';
          format: 'date-time';
          type: 'string';
        };
        has_3rd_party_audio: {
          description: 'Indicates whether or not TSP was used for the Webinar.';
          type: 'boolean';
        };
        has_pstn: {
          description: 'Indicates whether or not PSTN was used for the Webinar.';
          type: 'boolean';
        };
        has_recording: {
          description: 'Indicates whether or not recording was used for the Webinar.';
          type: 'boolean';
        };
        has_screen_share: {
          description: 'Indicates whether or not screen sharing was used for the Webinar.';
          type: 'boolean';
        };
        has_sip: {
          description: 'Indicates whether or not SIP was used for the Webinar.';
          type: 'boolean';
        };
        has_video: {
          description: 'Indicates whether or not video was used for the Webinar.';
          type: 'boolean';
        };
        has_voip: {
          description: 'Indicates whether or not VoIP was used for the Webinar.';
          type: 'boolean';
        };
        host: {
          description: 'User display name.';
          type: 'string';
        };
        id: {
          description: 'Webinar ID in "**long**" format(represented as int64 data type in JSON), also known as the webinar number.';
          format: 'int64';
          type: 'integer';
        };
        participants: {
          description: 'Webinar participant count.';
          type: 'integer';
        };
        start_time: {
          description: 'Webinar start time.';
          format: 'date-time';
          type: 'string';
        };
        topic: {
          description: 'Webinar topic.';
          type: 'string';
        };
        user_type: {
          description: 'User type.';
          type: 'string';
        };
        uuid: {
          description: 'Webinar UUID.';
          format: 'uuid';
          type: 'string';
        };
      };
      title: 'Webinar Metrics';
      type: 'object';
    };
    WebinarPanelist: {
      description: 'Webinar panelist.';
      properties: {
        panelists: {
          description: 'List of panelist objects.';
          items: {
            allOf: [
              {
                description: 'Panelist base object.';
                properties: {
                  email: {
                    description: "Panelist's email.";
                    format: 'email';
                    type: 'string';
                  };
                  name: {
                    description: "Panelist's full name.";
                    type: 'string';
                  };
                };
                type: 'object';
              },
            ];
          };
          maximum: 30;
          type: 'array';
        };
      };
      type: 'object';
    };
    WebinarPanelistList: {
      allOf: [
        {
          description: 'List of panelists.';
          properties: {
            panelists: {
              description: 'List of panelist objects.';
              items: {
                allOf: [
                  {
                    properties: {
                      id: {
                        description: "Panelist's ID.";
                        type: 'string';
                      };
                    };
                    type: 'object';
                  },
                  {
                    description: 'Panelist base object.';
                    properties: {
                      email: {
                        description: "Panelist's email.";
                        format: 'email';
                        type: 'string';
                      };
                      name: {
                        description: "Panelist's full name.";
                        type: 'string';
                      };
                    };
                    type: 'object';
                  },
                  {
                    properties: {
                      join_url: {
                        description: 'Join URL.';
                        type: 'string';
                      };
                    };
                    type: 'object';
                  },
                ];
              };
              type: 'array';
            };
            total_records: {
              description: 'Total records.';
              type: 'integer';
            };
          };
          title: 'Panelist List';
          type: 'object';
        },
      ];
      description: 'Webinar panelist.';
      type: 'object';
    };
    WebinarRegistrant: {
      allOf: [
        {
          description: 'Registrant base object.';
          properties: {
            address: {
              description: "Registrant's address.";
              type: 'string';
            };
            city: {
              description: "Registrant's city.";
              type: 'string';
            };
            comments: {
              description: 'A field that allows registrants to provide any questions or comments that they might have.';
              type: 'string';
            };
            country: {
              description: "Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.";
              type: 'string';
            };
            custom_questions: {
              description: 'Custom questions.';
              items: {
                description: 'Custom Question.';
                properties: {
                  title: {
                    type: 'string';
                  };
                  value: {
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            email: {
              description: 'A valid email address of the registrant.';
              maxLength: 128;
              type: 'string';
            };
            first_name: {
              description: "Registrant's first name.";
              maxLength: 64;
              type: 'string';
            };
            industry: {
              description: "Registrant's Industry.";
              type: 'string';
            };
            job_title: {
              description: "Registrant's job title.";
              type: 'string';
            };
            last_name: {
              description: "Registrant's last name.";
              maxLength: 64;
              type: 'string';
            };
            no_of_employees: {
              description: 'Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`';
              type: 'string';
            };
            org: {
              description: "Registrant's Organization.";
              type: 'string';
            };
            phone: {
              description: "Registrant's Phone number.";
              type: 'string';
            };
            purchasing_time_frame: {
              description: 'This field can be included to gauge interest of webinar attendees towards buying your product or service.\n\nPurchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`';
              type: 'string';
            };
            role_in_purchase_process: {
              description: 'Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved` ';
              type: 'string';
            };
            state: {
              description: "Registrant's State/Province.";
              type: 'string';
            };
            zip: {
              description: "Registrant's Zip/Postal Code.";
              type: 'string';
            };
          };
          required: ['email', 'first_name'];
          type: 'object';
        },
      ];
      description: 'Webinar registrant.';
      type: 'object';
    };
    WebinarRegistrantList: {
      allOf: [
        {
          allOf: [
            {
              description: 'Pagination Object.';
              properties: {
                next_page_token: {
                  description: 'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.';
                  type: 'string';
                };
                page_count: {
                  description: 'The number of pages returned for the request made.';
                  type: 'integer';
                };
                page_number: {
                  default: 1;
                  description: '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.';
                  type: 'integer';
                };
                page_size: {
                  default: 30;
                  description: 'The number of records returned with a single API call.';
                  maximum: 300;
                  type: 'integer';
                };
                total_records: {
                  description: 'The total number of all the records available across pages.';
                  type: 'integer';
                };
              };
              type: 'object';
            },
            {
              properties: {
                registrants: {
                  description: 'List of registrant objects.';
                  items: {
                    allOf: [
                      {
                        properties: {
                          id: {
                            description: 'Registrant ID.';
                            type: 'string';
                          };
                        };
                        type: 'object';
                      },
                      {
                        allOf: [
                          {
                            description: 'Registrant base object.';
                            properties: {
                              address: {
                                description: "Registrant's address.";
                                type: 'string';
                              };
                              city: {
                                description: "Registrant's city.";
                                type: 'string';
                              };
                              comments: {
                                description: 'A field that allows registrants to provide any questions or comments that they might have.';
                                type: 'string';
                              };
                              country: {
                                description: "Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.";
                                type: 'string';
                              };
                              custom_questions: {
                                description: 'Custom questions.';
                                items: {
                                  description: 'Custom Question.';
                                  properties: {
                                    title: {
                                      type: 'string';
                                    };
                                    value: {
                                      type: 'string';
                                    };
                                  };
                                  type: 'object';
                                };
                                type: 'array';
                              };
                              email: {
                                description: 'A valid email address of the registrant.';
                                maxLength: 128;
                                type: 'string';
                              };
                              first_name: {
                                description: "Registrant's first name.";
                                maxLength: 64;
                                type: 'string';
                              };
                              industry: {
                                description: "Registrant's Industry.";
                                type: 'string';
                              };
                              job_title: {
                                description: "Registrant's job title.";
                                type: 'string';
                              };
                              last_name: {
                                description: "Registrant's last name.";
                                maxLength: 64;
                                type: 'string';
                              };
                              no_of_employees: {
                                description: 'Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`';
                                type: 'string';
                              };
                              org: {
                                description: "Registrant's Organization.";
                                type: 'string';
                              };
                              phone: {
                                description: "Registrant's Phone number.";
                                type: 'string';
                              };
                              purchasing_time_frame: {
                                description: 'This field can be included to gauge interest of webinar attendees towards buying your product or service.\n\nPurchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`';
                                type: 'string';
                              };
                              role_in_purchase_process: {
                                description: 'Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved` ';
                                type: 'string';
                              };
                              state: {
                                description: "Registrant's State/Province.";
                                type: 'string';
                              };
                              zip: {
                                description: "Registrant's Zip/Postal Code.";
                                type: 'string';
                              };
                            };
                            required: ['email', 'first_name'];
                            type: 'object';
                          },
                        ];
                        description: ' Registrant.';
                        type: 'object';
                      },
                      {
                        properties: {
                          create_time: {
                            description: 'The time at which the registrant registered.';
                            format: 'date-time';
                            type: 'string';
                          };
                          join_url: {
                            description: 'The URL using which an approved registrant can join the webinar.';
                            format: 'string';
                            type: 'string';
                          };
                          status: {
                            description: "The status of the registrant's registration. <br> `approved`: User has been successfully approved for the webinar.<br> `pending`:  The registration is still pending.<br> `denied`: User has been denied from joining the webinar.";
                            type: 'string';
                          };
                        };
                        type: 'object';
                      },
                    ];
                  };
                  type: 'array';
                };
              };
            },
          ];
          description: 'List of users.';
          title: 'Registration List';
          type: 'object';
        },
      ];
      description: 'List of users.';
      title: 'Registration List';
      type: 'object';
    };
    WebinarRegistrantQuestions: {
      description: 'Webinar Registrant Questions';
      properties: {
        custom_questions: {
          description: 'Array of Registrant Custom Questions.';
          items: {
            properties: {
              answers: {
                description: "An array of answer choices. Can't be used for short answer type.";
                items: {
                  type: 'string';
                };
                type: 'array';
              };
              required: {
                description: 'State whether or not the custom question is required to be answered by a registrant.';
                type: 'boolean';
              };
              title: {
                description: 'Custom question.';
                type: 'string';
              };
              type: {
                description: 'The question-answer type.';
                enum: ['short', 'single_radio', 'single_dropdown', 'multiple'];
                type: 'string';
                'x-enum-descriptions': [
                  'Short Answer',
                  'Single Radio Answer',
                  'Single Dropdown Answer',
                  'Multiple Answer',
                ];
              };
            };
          };
          type: 'array';
        };
        questions: {
          description: 'Array of registration fields whose values should be provided by registrants during registration.';
          items: {
            properties: {
              field_name: {
                description: 'Field name';
                enum: [
                  'last_name',
                  'address',
                  'city',
                  'country',
                  'zip',
                  'state',
                  'phone',
                  'industry',
                  'org',
                  'job_title',
                  'purchasing_time_frame',
                  'role_in_purchase_process',
                  'no_of_employees',
                  'comments',
                ];
                type: 'string';
                'x-enum-descriptions': [
                  'Last Name',
                  'Address',
                  'City',
                  'Country/Region',
                  'Zip/Postal Code',
                  'State/Province',
                  'Phone',
                  'Industry',
                  'Organization',
                  'Job Title',
                  'Purchasing Time Frame',
                  'Role in Purchase Process',
                  'Number of Employees',
                  'Questions & Comments',
                ];
              };
              required: {
                description: 'State whether the selected fields are required or optional.';
                type: 'boolean';
              };
            };
          };
          type: 'array';
        };
      };
      title: 'Webinar Registrant Questions';
      type: 'object';
    };
    WebinarSettings: {
      description: 'Webinar settings.';
      properties: {
        allow_multiple_devices: {
          description: 'Allow attendees to join from multiple devices.';
          type: 'boolean';
        };
        alternative_hosts: {
          description: 'Alternative host emails or IDs. Multiple values separated by comma.';
          type: 'string';
        };
        approval_type: {
          default: 2;
          description: '`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
          enum: [0, 1, 2];
          type: 'integer';
          'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
        };
        attendees_and_panelists_reminder_email_notification: {
          description: 'Send reminder email to attendees and panelists.';
          properties: {
            enable: {
              description: '* `true`: Send reminder email to attendees and panelists.\n\n* `false`: Do not send reminder email to attendees and panelists.';
              type: 'boolean';
            };
            type: {
              description: '`0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.';
              enum: [0, 1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': [
                'Send 1 hour before webinar.',
                'Send 1 day before webinar.',
                'Send 1 hour and 1 day before webinar.',
                'Send 1 week before webinar.',
                'Send 1 hour and 1 week before webinar.',
                'Send 1 day and 1 week before webinar.',
                'Send 1 hour, 1 day and 1 week before webinar.',
              ];
            };
          };
          type: 'object';
        };
        audio: {
          default: 'both';
          description: 'Determine how participants can join the audio portion of the webinar.';
          enum: ['both', 'telephony', 'voip'];
          type: 'string';
          'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
        };
        authentication_domains: {
          description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
          type: 'string';
        };
        authentication_name: {
          description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
          type: 'string';
        };
        authentication_option: {
          description: 'Webinar authentication option id.';
          type: 'string';
        };
        auto_recording: {
          default: 'none';
          description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
          enum: ['local', 'cloud', 'none'];
          type: 'string';
          'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
        };
        close_registration: {
          description: 'Close registration after event date.';
          type: 'boolean';
        };
        contact_email: {
          description: 'Contact email for registration';
          type: 'string';
        };
        contact_name: {
          description: 'Contact name for registration';
          type: 'string';
        };
        email_language: {
          description: 'Set the email language to one of the following:\n`en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.';
          type: 'string';
        };
        enforce_login: {
          description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.';
          type: 'boolean';
        };
        enforce_login_domains: {
          description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.';
          type: 'string';
        };
        follow_up_absentees_email_notification: {
          description: 'Send follow-up email to absentees.';
          properties: {
            enable: {
              description: '* `true`: Send follow-up email to absentees.\n\n* `false`: Do not send follow-up email to absentees.';
              type: 'boolean';
            };
            type: {
              description: '`0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
              enum: [0, 1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': [
                'Send 1 days after the scheduled end date.',
                'Send 2 days after the scheduled end date.',
                'Send 3 days after the scheduled end date.',
                'Send 4 days after the scheduled end date.',
                'Send 5 days after the scheduled end date.',
                'Send 6 days after the scheduled end date.',
                'Send 7 days after the scheduled end date.',
              ];
            };
          };
          type: 'object';
        };
        follow_up_attendees_email_notification: {
          description: 'Send follow-up email to attendees.';
          properties: {
            enable: {
              description: '* `true`: Send follow-up email to attendees.\n\n* `false`: Do not send follow-up email to attendees.';
              type: 'boolean';
            };
            type: {
              description: '`0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
              enum: [0, 1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': [
                'Send 1 day after the scheduled end date.',
                'Send 2 days after the scheduled end date.',
                'Send 3 days after the scheduled end date.',
                'Send 4 days after the scheduled end date.',
                'Send 5 days after the scheduled end date.',
                'Send 6 days after the scheduled end date.',
                'Send 7 days after the scheduled end date.',
              ];
            };
          };
          type: 'object';
        };
        global_dial_in_countries: {
          description: 'List of global dial-in countries';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        hd_video: {
          default: false;
          description: 'Default to HD video.';
          type: 'boolean';
        };
        host_video: {
          description: 'Start video when host joins webinar.';
          type: 'boolean';
        };
        meeting_authentication: {
          description: '`true`- Only authenticated users can join Webinar.';
          type: 'boolean';
        };
        notify_registrants: {
          description: 'Send notification email to registrants when the host updates a webinar.';
          type: 'boolean';
        };
        on_demand: {
          default: false;
          description: 'Make the webinar on-demand';
          type: 'boolean';
        };
        panelists_invitation_email_notification: {
          description: '* `true`: Send invitation email to panelists.\n\n* `false`: Do not send invitation email to panelists.';
          type: 'boolean';
        };
        panelists_video: {
          description: 'Start video when panelists join webinar.';
          type: 'boolean';
        };
        post_webinar_survey: {
          description: "Zoom will open a survey page in attendees' browsers after leaving the webinar";
          type: 'boolean';
        };
        practice_session: {
          default: false;
          description: 'Enable practice session.';
          type: 'boolean';
        };
        question_and_answer: {
          description: "[Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.";
          properties: {
            allow_anonymous_questions: {
              description: '* `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..\n\n* `false`: Do not allow anonymous questions.';
              type: 'boolean';
            };
            answer_questions: {
              description: 'Indicate whether you want attendees to be able to view answered questions only or view all questions.\n\n* `only`: Attendees are able to view answered questions only.\n\n*  `all`: Attendees are able to view all questions submitted in the Q&A.';
              enum: ['only', 'all'];
              type: 'string';
            };
            attendees_can_comment: {
              description: '* `true`: Attendees can answer questions or leave a comment in the question thread.\n\n* `false`: Attendees can not answer questions or leave a comment in the question thread';
              type: 'boolean';
            };
            attendees_can_upvote: {
              description: '* `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.\n\n* `false`: Attendees can not click the thumbs up butoon on questions.';
              type: 'boolean';
            };
            enable: {
              description: "* `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.\n\n* `false`: Disable Q&A for webinar.";
              type: 'boolean';
            };
          };
          type: 'object';
        };
        registrants_confirmation_email: {
          description: 'Send confirmation email to registrants';
          type: 'boolean';
        };
        registrants_email_notification: {
          description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
          type: 'boolean';
        };
        registrants_restrict_number: {
          default: 0;
          description: 'Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.';
          maximum: 20000;
          minimum: 0;
          type: 'integer';
        };
        registration_type: {
          default: 1;
          description: 'Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.';
          enum: [1, 2, 3];
          type: 'integer';
          'x-enum-descriptions': [
            'Attendees register once and can attend any of the occurrences',
            'Attendees need to register for each occurrence to attend',
            'Attendees register once and can choose one or more occurrences to attend',
          ];
        };
        show_share_button: {
          description: 'Show social share buttons on the registration page.';
          type: 'boolean';
        };
        survey_url: {
          description: 'Survey url for post webinar survey';
          type: 'string';
        };
      };
      type: 'object';
    };
    WebinarUpdate: {
      allOf: [
        {
          description: 'Base webinar object for sessions.';
          properties: {
            agenda: {
              description: 'Webinar description.';
              type: 'string';
            };
            duration: {
              description: 'Webinar duration (minutes). Used for scheduled webinar only.';
              type: 'integer';
            };
            password: {
              description: '[Webinar passcode](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords). By default, passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ * !] and can have a maximum of 10 characters.\n\n**Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the  [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API. \n\nIf "**Require a passcode when scheduling new meetings**" setting has been **enabled** **and** [locked](https://support.zoom.us/hc/en-us/articles/115005269866-Using-Tiered-Settings#locked) for the user, the passcode field will be autogenerated for the Webinar in the response even if it is not provided in the API request. <br><br>\n\n\n\n\n\n\n\n';
              maxLength: 10;
              type: 'string';
            };
            recurrence: {
              description: 'Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time. ';
              properties: {
                end_date_time: {
                  description: 'Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
                  format: 'date-time';
                  type: 'string';
                };
                end_times: {
                  default: 1;
                  description: 'Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)';
                  maximum: 365;
                  type: 'integer';
                };
                monthly_day: {
                  default: 1;
                  description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
                  type: 'integer';
                };
                monthly_week: {
                  description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
                  enum: [-1, 1, 2, 3, 4];
                  type: 'integer';
                  'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
                };
                monthly_week_day: {
                  description: "Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field. \n\n<br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
                  enum: [1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
                };
                repeat_interval: {
                  description: 'Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.\n\n';
                  type: 'integer';
                };
                type: {
                  description: 'Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
                  enum: [1, 2, 3];
                  type: 'integer';
                  'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
                };
                weekly_days: {
                  default: '1';
                  description: 'This field is required **if you\'re scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.';
                  enum: ['1', '2', '3', '4', '5', '6', '7'];
                  type: 'string';
                };
              };
              required: ['type'];
              type: 'object';
            };
            settings: {
              allOf: [
                {
                  description: 'Webinar settings.';
                  properties: {
                    allow_multiple_devices: {
                      description: 'Allow attendees to join from multiple devices.';
                      type: 'boolean';
                    };
                    alternative_hosts: {
                      description: 'Alternative host emails or IDs. Multiple values separated by comma.';
                      type: 'string';
                    };
                    approval_type: {
                      default: 2;
                      description: '`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
                      enum: [0, 1, 2];
                      type: 'integer';
                      'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
                    };
                    attendees_and_panelists_reminder_email_notification: {
                      description: 'Send reminder email to attendees and panelists.';
                      properties: {
                        enable: {
                          description: '* `true`: Send reminder email to attendees and panelists.\n\n* `false`: Do not send reminder email to attendees and panelists.';
                          type: 'boolean';
                        };
                        type: {
                          description: '`0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.';
                          enum: [0, 1, 2, 3, 4, 5, 6, 7];
                          type: 'integer';
                          'x-enum-descriptions': [
                            'Send 1 hour before webinar.',
                            'Send 1 day before webinar.',
                            'Send 1 hour and 1 day before webinar.',
                            'Send 1 week before webinar.',
                            'Send 1 hour and 1 week before webinar.',
                            'Send 1 day and 1 week before webinar.',
                            'Send 1 hour, 1 day and 1 week before webinar.',
                          ];
                        };
                      };
                      type: 'object';
                    };
                    audio: {
                      default: 'both';
                      description: 'Determine how participants can join the audio portion of the webinar.';
                      enum: ['both', 'telephony', 'voip'];
                      type: 'string';
                      'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
                    };
                    authentication_domains: {
                      description: 'If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.';
                      type: 'string';
                    };
                    authentication_name: {
                      description: 'Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).';
                      type: 'string';
                    };
                    authentication_option: {
                      description: 'Webinar authentication option id.';
                      type: 'string';
                    };
                    auto_recording: {
                      default: 'none';
                      description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
                      enum: ['local', 'cloud', 'none'];
                      type: 'string';
                      'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
                    };
                    close_registration: {
                      description: 'Close registration after event date.';
                      type: 'boolean';
                    };
                    contact_email: {
                      description: 'Contact email for registration';
                      type: 'string';
                    };
                    contact_name: {
                      description: 'Contact name for registration';
                      type: 'string';
                    };
                    email_language: {
                      description: 'Set the email language to one of the following:\n`en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.';
                      type: 'string';
                    };
                    enforce_login: {
                      description: 'Only signed in users can join this meeting.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.';
                      type: 'boolean';
                    };
                    enforce_login_domains: {
                      description: 'Only signed in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.';
                      type: 'string';
                    };
                    follow_up_absentees_email_notification: {
                      description: 'Send follow-up email to absentees.';
                      properties: {
                        enable: {
                          description: '* `true`: Send follow-up email to absentees.\n\n* `false`: Do not send follow-up email to absentees.';
                          type: 'boolean';
                        };
                        type: {
                          description: '`0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
                          enum: [0, 1, 2, 3, 4, 5, 6, 7];
                          type: 'integer';
                          'x-enum-descriptions': [
                            'Send 1 days after the scheduled end date.',
                            'Send 2 days after the scheduled end date.',
                            'Send 3 days after the scheduled end date.',
                            'Send 4 days after the scheduled end date.',
                            'Send 5 days after the scheduled end date.',
                            'Send 6 days after the scheduled end date.',
                            'Send 7 days after the scheduled end date.',
                          ];
                        };
                      };
                      type: 'object';
                    };
                    follow_up_attendees_email_notification: {
                      description: 'Send follow-up email to attendees.';
                      properties: {
                        enable: {
                          description: '* `true`: Send follow-up email to attendees.\n\n* `false`: Do not send follow-up email to attendees.';
                          type: 'boolean';
                        };
                        type: {
                          description: '`0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
                          enum: [0, 1, 2, 3, 4, 5, 6, 7];
                          type: 'integer';
                          'x-enum-descriptions': [
                            'Send 1 day after the scheduled end date.',
                            'Send 2 days after the scheduled end date.',
                            'Send 3 days after the scheduled end date.',
                            'Send 4 days after the scheduled end date.',
                            'Send 5 days after the scheduled end date.',
                            'Send 6 days after the scheduled end date.',
                            'Send 7 days after the scheduled end date.',
                          ];
                        };
                      };
                      type: 'object';
                    };
                    global_dial_in_countries: {
                      description: 'List of global dial-in countries';
                      items: {
                        type: 'string';
                      };
                      type: 'array';
                    };
                    hd_video: {
                      default: false;
                      description: 'Default to HD video.';
                      type: 'boolean';
                    };
                    host_video: {
                      description: 'Start video when host joins webinar.';
                      type: 'boolean';
                    };
                    meeting_authentication: {
                      description: '`true`- Only authenticated users can join Webinar.';
                      type: 'boolean';
                    };
                    notify_registrants: {
                      description: 'Send notification email to registrants when the host updates a webinar.';
                      type: 'boolean';
                    };
                    on_demand: {
                      default: false;
                      description: 'Make the webinar on-demand';
                      type: 'boolean';
                    };
                    panelists_invitation_email_notification: {
                      description: '* `true`: Send invitation email to panelists.\n\n* `false`: Do not send invitation email to panelists.';
                      type: 'boolean';
                    };
                    panelists_video: {
                      description: 'Start video when panelists join webinar.';
                      type: 'boolean';
                    };
                    post_webinar_survey: {
                      description: "Zoom will open a survey page in attendees' browsers after leaving the webinar";
                      type: 'boolean';
                    };
                    practice_session: {
                      default: false;
                      description: 'Enable practice session.';
                      type: 'boolean';
                    };
                    question_and_answer: {
                      description: "[Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.";
                      properties: {
                        allow_anonymous_questions: {
                          description: '* `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..\n\n* `false`: Do not allow anonymous questions.';
                          type: 'boolean';
                        };
                        answer_questions: {
                          description: 'Indicate whether you want attendees to be able to view answered questions only or view all questions.\n\n* `only`: Attendees are able to view answered questions only.\n\n*  `all`: Attendees are able to view all questions submitted in the Q&A.';
                          enum: ['only', 'all'];
                          type: 'string';
                        };
                        attendees_can_comment: {
                          description: '* `true`: Attendees can answer questions or leave a comment in the question thread.\n\n* `false`: Attendees can not answer questions or leave a comment in the question thread';
                          type: 'boolean';
                        };
                        attendees_can_upvote: {
                          description: '* `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.\n\n* `false`: Attendees can not click the thumbs up butoon on questions.';
                          type: 'boolean';
                        };
                        enable: {
                          description: "* `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.\n\n* `false`: Disable Q&A for webinar.";
                          type: 'boolean';
                        };
                      };
                      type: 'object';
                    };
                    registrants_confirmation_email: {
                      description: 'Send confirmation email to registrants';
                      type: 'boolean';
                    };
                    registrants_email_notification: {
                      description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
                      type: 'boolean';
                    };
                    registrants_restrict_number: {
                      default: 0;
                      description: 'Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.';
                      maximum: 20000;
                      minimum: 0;
                      type: 'integer';
                    };
                    registration_type: {
                      default: 1;
                      description: 'Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.';
                      enum: [1, 2, 3];
                      type: 'integer';
                      'x-enum-descriptions': [
                        'Attendees register once and can attend any of the occurrences',
                        'Attendees need to register for each occurrence to attend',
                        'Attendees register once and can choose one or more occurrences to attend',
                      ];
                    };
                    show_share_button: {
                      description: 'Show social share buttons on the registration page.';
                      type: 'boolean';
                    };
                    survey_url: {
                      description: 'Survey url for post webinar survey';
                      type: 'string';
                    };
                  };
                  type: 'object';
                },
                {
                  properties: {
                    registrants_confirmation_email: {
                      description: 'Send confirmation email to registrants.';
                      type: 'boolean';
                    };
                  };
                  type: 'object';
                },
              ];
            };
            start_time: {
              description: "Webinar start time, in the format \"yyyy-MM-dd'T'HH:mm:ss'Z'.\" Should be in GMT time. In the format \"yyyy-MM-dd'T'HH:mm:ss.\" This should be in local time and the timezone should be specified. Only used for scheduled webinars and recurring webinars with a fixed time.";
              format: 'date-time';
              type: 'string';
            };
            timezone: {
              description: 'Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.';
              type: 'string';
            };
            topic: {
              description: 'Webinar topic.';
              type: 'string';
            };
            tracking_fields: {
              description: 'Tracking fields';
              items: {
                properties: {
                  field: {
                    description: 'Tracking fields type';
                    type: 'string';
                  };
                  value: {
                    description: 'Tracking fields value';
                    type: 'string';
                  };
                };
                type: 'object';
              };
              type: 'array';
            };
            type: {
              default: 5;
              description: 'Webinar Types:<br>`5` - webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.';
              enum: [5, 6, 9];
              type: 'integer';
              'x-enum-descriptions': [
                'Webinar',
                'Recurring Webinar with no fixed time',
                'Recurring Webinar with fixed time',
              ];
            };
          };
          type: 'object';
        },
      ];
      description: 'Webinar object';
      type: 'object';
    };
    ZoomRoom: {
      description: 'Zoom room.';
      properties: {
        account_type: {
          description: 'Zoom room email type.';
          type: 'string';
        };
        calender_name: {
          description: 'Zoom calendar name.';
          type: 'string';
        };
        camera: {
          description: 'Zoom room camera.';
          type: 'string';
        };
        device_ip: {
          description: 'Zoom room device IP.';
          type: 'string';
        };
        email: {
          description: 'Zoom room email.';
          type: 'string';
        };
        health: {
          type: 'string';
        };
        id: {
          description: 'Zoom room ID.';
          type: 'string';
        };
        issues: {
          description: 'Zoom Room issues.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        last_start_time: {
          description: 'Zoom room last start time.';
          type: 'string';
        };
        location: {
          description: 'Zoom room location.';
          type: 'string';
        };
        microphone: {
          description: 'Zoom room microphone.';
          type: 'string';
        };
        room_name: {
          description: 'Zoom room name.';
          type: 'string';
        };
        speaker: {
          description: 'Zoom room speaker.';
          type: 'string';
        };
        status: {
          description: 'Zoom room status.';
          type: 'string';
        };
      };
      title: 'Zoom Room';
      type: 'object';
    };
    ZoomRoomList: {
      allOf: [
        {
          description: 'Pagination Object.';
          properties: {
            next_page_token: {
              type: 'string';
            };
            page_count: {
              description: 'The number of pages returned for the request made.';
              type: 'integer';
            };
            page_number: {
              default: 1;
              description: 'The page number of the current results.';
              type: 'integer';
            };
            page_size: {
              default: 30;
              description: 'The number of records returned with a single API call.';
              maximum: 300;
              type: 'integer';
            };
            total_records: {
              description: 'The total number of all the records available across pages.';
              type: 'integer';
            };
          };
        },
        {
          properties: {
            zoom_rooms: {
              description: 'Array of Zoom Rooms';
              items: {
                description: 'Zoom room.';
                properties: {
                  account_type: {
                    description: 'Zoom room email type.';
                    type: 'string';
                  };
                  calender_name: {
                    description: 'Zoom calendar name.';
                    type: 'string';
                  };
                  camera: {
                    description: 'Zoom room camera.';
                    type: 'string';
                  };
                  device_ip: {
                    description: 'Zoom room device IP.';
                    type: 'string';
                  };
                  email: {
                    description: 'Zoom room email.';
                    type: 'string';
                  };
                  health: {
                    type: 'string';
                  };
                  id: {
                    description: 'Zoom room ID.';
                    type: 'string';
                  };
                  issues: {
                    description: 'Zoom Room issues.';
                    items: {
                      type: 'string';
                    };
                    type: 'array';
                  };
                  last_start_time: {
                    description: 'Zoom room last start time.';
                    type: 'string';
                  };
                  location: {
                    description: 'Zoom room location.';
                    type: 'string';
                  };
                  microphone: {
                    description: 'Zoom room microphone.';
                    type: 'string';
                  };
                  room_name: {
                    description: 'Zoom room name.';
                    type: 'string';
                  };
                  speaker: {
                    description: 'Zoom room speaker.';
                    type: 'string';
                  };
                  status: {
                    description: 'Zoom room status.';
                    type: 'string';
                  };
                };
                title: 'Zoom Room';
                type: 'object';
              };
              type: 'array';
            };
          };
        },
      ];
      description: 'Zoom Room List';
      title: 'Zoom Room List';
      type: 'object';
    };
    authenticationusersettings: {
      oneOf: [
        {
          description: 'Set/ update [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars).<br><br> The authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).';
          properties: {
            authentication_option: {
              description: 'Meeting Authentication Options';
              properties: {
                action: {
                  description: 'Specify the action that you would like to take via this API request:<br>\n* `add` : Choose this value if you are adding an authentication option.\n* `update`: Choose this value if you are updating an existing authentication option.\n* `delete`: Choose this value if you are deleting an existing authentication option.';
                  enum: ['update', 'delete', 'add'];
                  type: 'string';
                };
                default_option: {
                  description: 'Specify whether you would like to set this authentication option as the default option or not.';
                  type: 'boolean';
                };
                domains: {
                  description: 'If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to join your meetings or webinars. ';
                  type: 'string';
                };
                id: {
                  description: ' Authentication ID. You can get the ID from Get User Settings API with query parameter `option` set to `meeting_authentication`.<br><br>\n Use this field or the `name` field to identify the associated authentication option that you would like to update.';
                  type: 'string';
                };
                name: {
                  description: 'Unique name for the authentication option.';
                  type: 'string';
                };
                type: {
                  description: ' Authentication type. Specify one of the following authentication types for the authentication profile:<br>\n * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.';
                  enum: ['enforce_login', 'enforce_login_with_domains'];
                  type: 'string';
                };
              };
              type: 'object';
            };
            meeting_authentication: {
              description: 'If set to "true", only authenticated users can join meetings. The method for authentication can be defined in the "authentication_option". ';
              type: 'boolean';
            };
          };
        },
        {
          description: 'Set/Update [authentication profile for Cloud Recordings](https://support.zoom.us/hc/en-us/articles/360037756671-Authentication-Profiles-for-Cloud-Recordings).';
          properties: {
            authentication_option: {
              description: 'Specify the authentication options for this account.';
              properties: {
                action: {
                  description: 'Specify the action that you would like to take via this API request:<br>\n\n* `update`: Choose this value if you are updating an existing authentication option.\n* `show` : Choose this value if you would like this option to be one of the authentication options that the host can use for sharing the recording settings. \n* `hide`:  Choose this value if you would like this option to not be made available to the host for recording sharing settings.  ';
                  enum: ['update', 'delete', 'add'];
                  type: 'string';
                };
                default_option: {
                  description: 'Specify whether you would like to set this authentication option as the default option or not.';
                  type: 'boolean';
                };
                domains: {
                  description: 'If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to view the recordings. ';
                  type: 'string';
                };
                id: {
                  description: ' Authentication ID. You can get the ID from Get User Settings API with query parameter `option` set to `recording_authentication`.<br><br>\n\nUse this field or the `name` field to identify the associated authentication option that you would like to update or delete.';
                  type: 'string';
                };
                name: {
                  description: 'Unique name for the authentication option.';
                  type: 'string';
                };
                type: {
                  description: 'Specify one authentication type that is to be associated with this authentication configuration:<br>\n* `internally`: This option allows you specify a rule that only signed in users within your account can view the recording.<br>\n * `enforce_login`: This option allows any users to view the recording, as long as they are signed into their Zoom account.<br>\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can view the recording. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.\n\n';
                  enum: ['internally', 'enforce_login', 'enforce_login_with_domains'];
                  type: 'string';
                };
              };
              type: 'object';
            };
            recording_authentication: {
              description: 'If set to `true`, only authenticated users can view the cloud recordings.<br><br>\nThe authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).';
              type: 'boolean';
            };
          };
        },
      ];
      title: 'UserSettingsAuthenticationUpdate';
      type: 'object';
    };
    create_webinar: {
      description: 'Base webinar object for sessions.';
      properties: {
        agenda: {
          description: 'Webinar description.';
          type: 'string';
        };
        duration: {
          description: 'Webinar duration (minutes). Used for scheduled webinars only.';
          type: 'integer';
        };
        password: {
          description: 'Webinar passcode. Passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ * !]. Max of 10 characters.\n\nIf "Require a passcode when scheduling new meetings" setting has been **enabled** **and** [locked](https://support.zoom.us/hc/en-us/articles/115005269866-Using-Tiered-Settings#locked) for the user, the passcode field will be autogenerated for the Webinar in the response even if it is not provided in the API request. <br><br>\n\n**Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API. \n\n\n\n';
          type: 'string';
        };
        recurrence: {
          description: 'Recurrence object. Use this object only for a webinar of type `9` i.e., a recurring webinar with fixed time. ';
          properties: {
            end_date_time: {
              description: 'Select a date when the webinar will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
              format: 'date-time';
              type: 'string';
            };
            end_times: {
              default: 1;
              description: 'Select how many times the webinar will recur before it is canceled. (Cannot be used with "end_date_time".)';
              maximum: 365;
              type: 'integer';
            };
            monthly_day: {
              description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state which day in a month, the webinar should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the webinar to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the webinar to recur once every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
              type: 'integer';
            };
            monthly_week: {
              description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state the week of the month when the webinar should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the webinar should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
              enum: [-1, 1, 2, 3, 4];
              type: 'integer';
              'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
            };
            monthly_week_day: {
              description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state a specific day in a week when the monthly webinar should recur. To use this field, you must also use the `monthly_week` field. <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
              enum: [1, 2, 3, 4, 5, 6, 7];
              type: 'integer';
              'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
            };
            repeat_interval: {
              description: 'Define the interval at which the webinar should recur. For instance, if you would like to schedule a Webinar that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily webinar, the maximum interval you can set is `90` days. For a weekly webinar, the maximum interval that you can set is `12` weeks. For a monthly webinar, the maximum interval that you can set is `3` months.';
              type: 'integer';
            };
            type: {
              description: 'Recurrence webinar types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
            };
            weekly_days: {
              description: 'Use this field **only if you\'re scheduling a recurring webinar of type** `2` to state which day(s) of the week the webinar should repeat. <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the Webinar should recur on Sunday, provide `"1"` as the value of this field.  <br><br> **Note:** If you would like the webinar to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the Webinar should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n<br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.\n\n';
              type: 'string';
            };
          };
          required: ['type'];
          title: 'Recurrence Webinar';
          type: 'object';
        };
        settings: {
          description: 'Create Webinar settings.';
          properties: {
            allow_multiple_devices: {
              description: 'Allow attendees to join from multiple devices.';
              type: 'boolean';
            };
            alternative_hosts: {
              description: 'Alternative host emails or IDs. Multiple values separated by comma.';
              type: 'string';
            };
            approval_type: {
              default: 2;
              description: 'The default value is `2`. To enable registration required, set the approval type to `0` or `1`.  Values include:<br>\n\n`0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.';
              enum: [0, 1, 2];
              type: 'integer';
              'x-enum-descriptions': ['Automatically Approve', 'Manually Approve', 'No Registration Required'];
            };
            attendees_and_panelists_reminder_email_notification: {
              description: 'Send reminder email to attendees and panelists.';
              properties: {
                enable: {
                  description: '* `true`: Send reminder email to attendees and panelists.\n\n* `false`: Do not send reminder email to attendees and panelists.';
                  type: 'boolean';
                };
                type: {
                  description: '`0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.';
                  enum: [0, 1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Send 1 hour before webinar.',
                    'Send 1 day before webinar.',
                    'Send 1 hour and 1 day before webinar.',
                    'Send 1 week before webinar.',
                    'Send 1 hour and 1 week before webinar.',
                    'Send 1 day and 1 week before webinar.',
                    'Send 1 hour, 1 day and 1 week before webinar.',
                  ];
                };
              };
              type: 'object';
            };
            audio: {
              default: 'both';
              description: 'Determine how participants can join the audio portion of the meeting.';
              enum: ['both', 'telephony', 'voip'];
              type: 'string';
              'x-enum-descriptions': ['Both Telephony and VoIP', 'Telephony only', 'VoIP only'];
            };
            authentication_domains: {
              description: 'Meeting authentication domains. This option, allows you to specify the rule so that Zoom users, whose email address contains a certain domain, can join the Webinar. You can either provide multiple domains, using a comma in between and/or use a wildcard for listing domains.';
              type: 'string';
            };
            authentication_option: {
              description: 'Specify the authentication type for users to join a Webinar with`meeting_authentication` setting set to `true`. The value of this field can be retrieved from the `id` field within `authentication_options` array in the response of [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings).';
              type: 'string';
            };
            auto_recording: {
              default: 'none';
              description: 'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.';
              enum: ['local', 'cloud', 'none'];
              type: 'string';
              'x-enum-descriptions': ['Record to local device', 'Record to cloud', 'No Recording'];
            };
            close_registration: {
              description: 'Close registration after event date.';
              type: 'boolean';
            };
            contact_email: {
              description: 'Contact email for registration';
              type: 'string';
            };
            contact_name: {
              description: 'Contact name for registration';
              type: 'string';
            };
            email_language: {
              description: 'Set the email language to one of the following:\n`en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.';
              type: 'string';
            };
            enforce_login: {
              description: 'Only signed-in users can join this meeting. \n\n**This field is deprecated and will not be supported in future.** <br><br> Instead of this field, use the "meeting_authentication", "authentication_option" and/or "authentication_domains" fields to establish the authentication mechanism for this Webinar. ';
              type: 'boolean';
            };
            enforce_login_domains: {
              description: 'Only signed-in users with specified domains can join meetings.\n\n**This field is deprecated and will not be supported in future.** <br><br> Instead of this field, use the "authentication_domains" field for this Webinar. ';
              type: 'string';
            };
            follow_up_absentees_email_notification: {
              description: 'Send follow-up email to absentees.';
              properties: {
                enable: {
                  description: '* `true`: Send follow-up email to absentees.\n\n* `false`: Do not send follow-up email to absentees.';
                  type: 'boolean';
                };
                type: {
                  description: '`0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
                  enum: [0, 1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Send 1 days after the scheduled end date.',
                    'Send 2 days after the scheduled end date.',
                    'Send 3 days after the scheduled end date.',
                    'Send 4 days after the scheduled end date.',
                    'Send 5 days after the scheduled end date.',
                    'Send 6 days after the scheduled end date.',
                    'Send 7 days after the scheduled end date.',
                  ];
                };
              };
              type: 'object';
            };
            follow_up_attendees_email_notification: {
              description: 'Send follow-up email to attendees.';
              properties: {
                enable: {
                  description: '* `true`: Send follow-up email to attendees.\n\n* `false`: Do not send follow-up email to attendees.';
                  type: 'boolean';
                };
                type: {
                  description: '`0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.';
                  enum: [0, 1, 2, 3, 4, 5, 6, 7];
                  type: 'integer';
                  'x-enum-descriptions': [
                    'Send 1 day after the scheduled end date.',
                    'Send 2 days after the scheduled end date.',
                    'Send 3 days after the scheduled end date.',
                    'Send 4 days after the scheduled end date.',
                    'Send 5 days after the scheduled end date.',
                    'Send 6 days after the scheduled end date.',
                    'Send 7 days after the scheduled end date.',
                  ];
                };
              };
              type: 'object';
            };
            global_dial_in_countries: {
              description: 'List of global dial-in countries';
              items: {
                type: 'string';
              };
              type: 'array';
            };
            hd_video: {
              default: false;
              description: 'Default to HD video.';
              type: 'boolean';
            };
            host_video: {
              description: 'Start video when host joins webinar.';
              type: 'boolean';
            };
            meeting_authentication: {
              description: 'Only [authenticated](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) users can join meeting if the value of this field is set to `true`.';
              type: 'boolean';
            };
            on_demand: {
              default: false;
              description: 'Make the webinar on-demand';
              type: 'boolean';
            };
            panelists_invitation_email_notification: {
              description: '* `true`: Send invitation email to panelists.\n\n* `false`: Do not send invitation email to panelists.';
              type: 'boolean';
            };
            panelists_video: {
              description: 'Start video when panelists join webinar.';
              type: 'boolean';
            };
            post_webinar_survey: {
              description: "Zoom will open a survey page in attendees' browsers after leaving the webinar";
              type: 'boolean';
            };
            practice_session: {
              default: false;
              description: 'Enable practice session.';
              type: 'boolean';
            };
            question_and_answer: {
              description: "[Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.";
              properties: {
                allow_anonymous_questions: {
                  description: '* `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..\n\n* `false`: Do not allow anonymous questions.';
                  type: 'boolean';
                };
                answer_questions: {
                  description: 'Indicate whether you want attendees to be able to view answered questions only or view all questions.\n\n* `only`: Attendees are able to view answered questions only.\n\n*  `all`: Attendees are able to view all questions submitted in the Q&A.';
                  enum: ['only', 'all'];
                  type: 'string';
                };
                attendees_can_comment: {
                  description: '* `true`: Attendees can answer questions or leave a comment in the question thread.\n\n* `false`: Attendees can not answer questions or leave a comment in the question thread';
                  type: 'boolean';
                };
                attendees_can_upvote: {
                  description: '* `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.\n\n* `false`: Attendees can not click the thumbs up butoon on questions.';
                  type: 'boolean';
                };
                enable: {
                  description: "* `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.\n\n* `false`: Disable Q&A for webinar.";
                  type: 'boolean';
                };
              };
              type: 'object';
            };
            registrants_email_notification: {
              description: 'Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.';
              type: 'boolean';
            };
            registrants_restrict_number: {
              default: 0;
              description: 'Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.';
              maximum: 20000;
              minimum: 0;
              type: 'integer';
            };
            registration_type: {
              default: 1;
              description: 'Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.';
              enum: [1, 2, 3];
              type: 'integer';
              'x-enum-descriptions': [
                'Attendees register once and can attend any of the occurrences',
                'Attendees need to register for each occurrence to attend',
                'Attendees register once and can choose one or more occurrences to attend',
              ];
            };
            show_share_button: {
              description: 'Show social share buttons on the registration page.';
              type: 'boolean';
            };
            survey_url: {
              description: 'Survey url for post webinar survey';
              type: 'string';
            };
          };
          type: 'object';
        };
        start_time: {
          description: 'Webinar start time. We support two formats for `start_time` - local time and GMT.<br> \n\nTo set time as GMT the format should be `yyyy-MM-dd`T`HH:mm:ssZ`.\n\nTo set time using a specific timezone, use `yyyy-MM-dd`T`HH:mm:ss` format and specify the timezone [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) in the `timezone` field OR leave it blank and the timezone set on your Zoom account will be used. You can also set the time as UTC as the timezone field.\n\nThe `start_time` should only be used for scheduled and / or recurring webinars with fixed time.';
          format: 'date-time';
          type: 'string';
        };
        timezone: {
          description: 'Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [timezone](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) list for supported time zones and their formats.';
          type: 'string';
        };
        topic: {
          description: 'Webinar topic.';
          type: 'string';
        };
        tracking_fields: {
          description: 'Tracking fields';
          items: {
            properties: {
              field: {
                description: 'Tracking fields type';
                type: 'string';
              };
              value: {
                description: 'Tracking fields value';
                type: 'string';
              };
            };
            required: ['field'];
            type: 'object';
          };
          type: 'array';
        };
        type: {
          default: 5;
          description: 'Webinar Types:<br>`5` - Webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.';
          enum: [5, 6, 9];
          type: 'integer';
          'x-enum-descriptions': [
            'Webinar',
            'Recurring Webinar with no fixed time',
            'Recurring Webinar with fixed time',
          ];
        };
      };
      type: 'object';
    };
    listmeetingmetrics: {
      description: 'Meeting metric details.';
      properties: {
        custom_keys: {
          description: 'Custom keys and values assigned to the meeting.';
          items: {
            properties: {
              key: {
                description: 'Custom key associated with the meeting.';
                maxLength: 64;
                type: 'string';
              };
              value: {
                description: 'Value of the custom key associated with the meeting.';
                maxLength: 256;
                type: 'string';
              };
            };
            type: 'object';
          };
          maxItems: 10;
          type: 'array';
        };
        dept: {
          description: 'Department of the host.';
          type: 'string';
        };
        duration: {
          description: 'Meeting duration. Formatted as hh:mm:ss, for example: `16:08` for 16 minutes and 8 seconds.';
          type: 'string';
        };
        email: {
          description: 'Email address of the host.';
          type: 'string';
        };
        end_time: {
          description: 'Meeting end time.';
          format: 'date-time';
          type: 'string';
        };
        has_3rd_party_audio: {
          description: 'Indicates whether or not [third party audio](https://support.zoom.us/hc/en-us/articles/202470795-3rd-Party-Audio-Conference) was used in the meeting.';
          type: 'boolean';
        };
        has_pstn: {
          description: 'Indicates whether or not the PSTN was used in the meeting.';
          type: 'boolean';
        };
        has_recording: {
          description: 'Indicates whether or not the recording feature was used in the meeting. ';
          type: 'boolean';
        };
        has_screen_share: {
          description: 'Indicates whether or not screenshare feature was used in the meeting.';
          type: 'boolean';
        };
        has_sip: {
          description: 'Indicates whether or not someone joined the meeting using SIP.';
          type: 'boolean';
        };
        has_video: {
          description: 'Indicates whether or not video was used in the meeting.';
          type: 'boolean';
        };
        has_voip: {
          description: 'Indicates whether or not VoIP was used in the meeting.';
          type: 'boolean';
        };
        host: {
          description: 'Host display name.';
          type: 'string';
        };
        id: {
          description: '[Meeting ID](https://support.zoom.us/hc/en-us/articles/201362373-What-is-a-Meeting-ID-): Unique identifier of the meeting in "**long**" format(represented as int64 data type in JSON), also known as the meeting number.';
          format: 'int64';
          type: 'integer';
        };
        in_room_participants: {
          description: 'The number of Zoom Room participants in the meeting.';
          type: 'integer';
        };
        participants: {
          description: 'Meeting participant count.';
          type: 'integer';
        };
        start_time: {
          description: 'Meeting start time.';
          format: 'date-time';
          type: 'string';
        };
        topic: {
          description: 'Meeting topic.';
          type: 'string';
        };
        tracking_fields: {
          description: 'Tracking fields and values assigned to the meeting.';
          items: {
            properties: {
              field: {
                description: 'Label of the tracking field.';
                maxLength: 64;
                type: 'string';
              };
              value: {
                description: 'Value of the tracking field.';
                maxLength: 256;
                type: 'string';
              };
            };
            type: 'object';
          };
          type: 'array';
        };
        user_type: {
          description: 'License type of the user.';
          type: 'string';
        };
        uuid: {
          description: "Meeting UUID. Please double encode your UUID when using it for API calls if the UUID begins with a '/'or contains '//' in it.";
          format: 'uuid';
          type: 'string';
        };
      };
      title: 'Metrics';
      type: 'object';
    };
    'recurrence-webinar': {
      description: 'Recurrence object. Use this object only for a webinar of type `9` i.e., a recurring webinar with fixed time. ';
      properties: {
        end_date_time: {
          description: 'Select a date when the webinar will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)';
          format: 'date-time';
          type: 'string';
        };
        end_times: {
          default: 1;
          description: 'Select how many times the webinar will recur before it is canceled. (Cannot be used with "end_date_time".)';
          maximum: 365;
          type: 'integer';
        };
        monthly_day: {
          description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state which day in a month, the webinar should recur. The value range is from 1 to 31.\n\nFor instance, if you would like the webinar to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the webinar to recur once every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.";
          type: 'integer';
        };
        monthly_week: {
          description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state the week of the month when the webinar should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the webinar should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.";
          enum: [-1, 1, 2, 3, 4];
          type: 'integer';
          'x-enum-descriptions': ['Last week', 'First week', 'Second week', 'Third week', 'Fourth week'];
        };
        monthly_week_day: {
          description: "Use this field **only if you're scheduling a recurring webinar of type** `3` to state a specific day in a week when the monthly webinar should recur. To use this field, you must also use the `monthly_week` field. <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.";
          enum: [1, 2, 3, 4, 5, 6, 7];
          type: 'integer';
          'x-enum-descriptions': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        };
        repeat_interval: {
          description: 'Define the interval at which the webinar should recur. For instance, if you would like to schedule a Webinar that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`. \n\nFor a daily webinar, the maximum interval you can set is `90` days. For a weekly webinar, the maximum interval that you can set is `12` weeks. For a monthly webinar, the maximum interval that you can set is `3` months.';
          type: 'integer';
        };
        type: {
          description: 'Recurrence webinar types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.';
          enum: [1, 2, 3];
          type: 'integer';
          'x-enum-descriptions': ['Daily', 'Weekly', 'Monthly'];
        };
        weekly_days: {
          description: 'Use this field **only if you\'re scheduling a recurring webinar of type** `2` to state which day(s) of the week the webinar should repeat. <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the Webinar should recur on Sunday, provide `"1"` as the value of this field.  <br><br> **Note:** If you would like the webinar to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the Webinar should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.\n\n<br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.\n\n';
          type: 'string';
        };
      };
      required: ['type'];
      title: 'Recurrence Webinar';
      type: 'object';
    };
    'tsp-global-dial-in': {
      properties: {
        audio_url: {
          description: 'The global dial-in URL for a TSP enabled account. The URL must be valid with a max-length of 512 characters.';
          maxLength: 512;
          type: 'string';
        };
      };
      title: 'TSP Global Dial-In URL Setting';
      type: 'object';
    };
  };
  securitySchemes: {
    Bearer: {
      in: 'header';
      name: 'Authorization';
      type: 'apiKey';
    };
    Client_Credentials: {
      description: 'Client Credentials Flow for ChatBots';
      flows: {
        clientCredentials: {
          scopes: {};
          tokenUrl: 'https://api.zoom.us/oauth/token';
        };
      };
      type: 'oauth2';
    };
    OAuth: {
      flows: {
        authorizationCode: {
          authorizationUrl: 'https://zoom.us/oauth/authorize';
          scopes: {};
          tokenUrl: 'https://zoom.us/oauth/token';
        };
      };
      type: 'oauth2';
    };
  };
};
export const components = {
  parameters: {
    AccountId: {
      description: 'The account ID.',
      in: 'path',
      name: 'accountId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    DeviceId: {
      description: 'The device ID.',
      in: 'path',
      name: 'deviceId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    FeedbackId: {
      description: 'Feedback Detail Id',
      in: 'path',
      name: 'feedbackId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    FromDate: {
      description:
        'Start date in \'yyyy-mm-dd\' format. The date range defined by the "from" and "to" parameters should only be one month as the report includes only one month worth of data at once.',
      in: 'query',
      name: 'from',
      required: true,
      schema: {
        format: 'date',
        type: 'string',
      },
    },
    GroupId: {
      description:
        'The group ID.<br>\nCan be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).',
      in: 'path',
      name: 'groupId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    LoginType: {
      description: '`0` - Facebook.<br>`1` - Google.<br>`99` - API.<br>`100` - Zoom.<br>`101` - SSO.',
      in: 'query',
      name: 'login_type',
      schema: {
        enum: ['0', '1', '99', '100', '101'],
        type: 'string',
      },
      'x-enum-descriptions': ['Facebook', 'Google', 'API', 'Zoom', 'SSO'],
    },
    Mc: {
      description: 'Query Metadata of Recording if an On-Premise Meeting Connector was used for the meeting.',
      in: 'query',
      name: 'mc',
      schema: {
        default: 'false',
        type: 'string',
      },
    },
    MeetingId: {
      description:
        'The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).\n\nWhile storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.',
      in: 'path',
      name: 'meetingId',
      required: true,
      schema: {
        format: 'int64',
        type: 'integer',
      },
    },
    MeetingId4Metrics: {
      description:
        'The meeting ID or the meeting UUID.  If a meeting ID is provided in the request instead of a UUID, the response will be for the latest meeting instance.\n\nIf a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875==\\"), you must **double encode** the UUID before making an API request.',
      in: 'path',
      name: 'meetingId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    MeetingId4Recording: {
      description:
        'To get Cloud Recordings of a meeting, provide the meeting ID or meeting UUID. If the meeting ID is provided instead of UUID,the response will be for the latest meeting instance. \n\nTo get Cloud Recordings of a webinar, provide the webinar ID or the webinar UUID. If the webinar ID is provided instead of UUID,the response will be for the latest webinar instance. \n\nIf a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875=="), you must **double encode** the UUID before making an API request. ',
      in: 'path',
      name: 'meetingId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    MeetingIdNumber: {
      description: 'The meeting ID or UUID.',
      in: 'path',
      name: 'meetingId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    MeetingType: {
      description:
        'The meeting types: <br>`scheduled` - This includes all valid past meetings (unexpired), live meetings and upcoming scheduled meetings. It is equivalent to the combined list of "Previous Meetings" and "Upcoming Meetings" displayed in the user\'s [Meetings page](https://zoom.us/meeting) on the Zoom Web Portal.<br>`live` - All the ongoing meetings.<br>`upcoming` - All upcoming meetings including live meetings.',
      in: 'query',
      name: 'type',
      schema: {
        default: 'live',
        enum: ['scheduled', 'live', 'upcoming'],
        type: 'string',
      },
      'x-enum-descriptions': ['all the scheduled meetings', 'all the live meetings', 'all the upcoming meetings'],
    },
    MeetingTypePast: {
      description:
        'Specify a value to get the response for the corresponding meeting type. The value of this field can be one of the following:<br> <br>`past` - Meeting that already occurred in the specified date range.<br>`pastOne` - Past meetings that were attended by only one user. <br>`live` - Live meetings.<br><br>\n\nIf you do not provide this field, the default value will be `live` and thus, the API will only query responses for live meetings.',
      in: 'query',
      name: 'type',
      schema: {
        default: 'live',
        enum: ['past', 'pastOne', 'live'],
        type: 'string',
      },
      'x-enum-descriptions': ['past meetings', 'past one user meetings', 'live meetings'],
    },
    MeetingTypePast2: {
      description: 'The meeting types: <br>`past` - Past meetings.<br>`live` - Live Meetings.',
      in: 'query',
      name: 'type',
      schema: {
        default: 'live',
        enum: ['past', 'pastOne', 'live'],
        type: 'string',
      },
      'x-enum-descriptions': ['past meeting', 'single past user meetings', 'live meeting'],
    },
    MeetingTypePast3: {
      description:
        'The meeting types: <br>`past` - Past meetings.<br>`pastOne` - Past one user meetings.<br>`live` - Live meetings.',
      in: 'query',
      name: 'type',
      schema: {
        default: 'live',
        enum: ['past', 'pastOne', 'live'],
        type: 'string',
      },
      'x-enum-descriptions': ['past meeting', 'past one user meeting', 'live meeting'],
    },
    MeetingUUID: {
      description:
        "The meeting UUID. Each meeting instance will generate its own Meeting UUID (i.e., after a meeting ends, a new UUID will be generated for the next instance of the meeting). Please double encode your UUID when using it for other API calls if the UUID begins with a '/'or contains '//' in it.",
      in: 'path',
      name: 'meetingUUID',
      required: true,
      schema: {
        type: 'string',
      },
    },
    MemberId: {
      description: 'The member ID.',
      in: 'path',
      name: 'memberId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    NextPageToken: {
      description:
        'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.',
      in: 'query',
      name: 'next_page_token',
      schema: {
        type: 'string',
      },
    },
    OccurrenceId: {
      description: 'The meeting occurrence ID.',
      in: 'query',
      name: 'occurrence_id',
      schema: {
        type: 'string',
      },
    },
    PageNumber: {
      description:
        '\n**Deprecated** - This field has been deprecated and we will stop supporting it completely in a future release. Please use "next_page_token" for pagination instead of this field.\n\nThe page number of the current page in the returned records.',
      in: 'query',
      name: 'page_number',
      schema: {
        default: 1,
        type: 'integer',
      },
    },
    PageSize: {
      description: 'The number of records returned within a single API call.',
      in: 'query',
      name: 'page_size',
      schema: {
        default: 30,
        maximum: 300,
        type: 'integer',
      },
    },
    PageSize4Qos: {
      description: 'The number of items returned per page.',
      in: 'query',
      name: 'page_size',
      schema: {
        default: 1,
        maximum: 10,
        type: 'integer',
      },
    },
    PageToken: {
      description:
        'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceed the current page size. The expiration period for this token is 15 minutes.',
      in: 'query',
      name: 'next_page_token',
      schema: {
        type: 'string',
      },
    },
    ParticipantId: {
      description: 'Participant ID.',
      in: 'path',
      name: 'participantId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    RecordingDeleteAction: {
      description:
        'The recording delete actions:<br>`trash` - Move recording to trash.<br>`delete` - Delete recording permanently.',
      in: 'query',
      name: 'action',
      schema: {
        default: 'trash',
        enum: ['trash', 'delete'],
        type: 'string',
      },
      'x-enum-descriptions': ['move recording to trash', 'delete recording permanently'],
    },
    RecordingId: {
      description: 'The recording ID.',
      in: 'path',
      name: 'recordingId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    RegistrantId: {
      description: 'The registrant ID.',
      in: 'path',
      name: 'registrantId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    RegistrantStatus: {
      description:
        "The registrant status:<br>`pending` - Registrant's status is pending.<br>`approved` - Registrant's status is approved.<br>`denied` - Registrant's status is denied.",
      in: 'query',
      name: 'status',
      schema: {
        default: 'approved',
        enum: ['pending', 'approved', 'denied'],
        type: 'string',
      },
      'x-enum-descriptions': [
        'registrants status is pending',
        'registrants status is approved',
        'registrants status is denied',
      ],
    },
    RoleId: {
      description: 'The role ID',
      in: 'path',
      name: 'roleId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    SessionId: {
      description: 'IM chat session ID.',
      in: 'path',
      name: 'sessionId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    TSPId: {
      description: 'TSP account ID.',
      in: 'path',
      name: 'tspId',
      required: true,
      schema: {
        enum: [1, 2],
        type: 'string',
      },
    },
    ToDate: {
      description: 'End date.',
      in: 'query',
      name: 'to',
      required: true,
      schema: {
        format: 'date',
        type: 'string',
      },
    },
    TrackingSourceId: {
      description:
        'The tracking source ID for the registrants. Useful if you share the webinar registration page in multiple locations. See [Creating source tracking links for webinar registration](https://support.zoom.us/hc/en-us/articles/360000315683-Creating-source-tracking-links-for-webinar-registration) for details.',
      in: 'query',
      name: 'tracking_source_id',
      schema: {
        type: 'string',
      },
    },
    TransferEmail: {
      description: 'Transfer email.',
      in: 'query',
      name: 'transfer_email',
      required: false,
      schema: {
        type: 'string',
      },
    },
    TransferMeeting: {
      description: 'Transfer meeting.',
      in: 'query',
      name: 'transfer_meeting',
      required: false,
      schema: {
        type: 'boolean',
      },
    },
    TransferRecording: {
      description: 'Transfer recording.',
      in: 'query',
      name: 'transfer_recording',
      required: false,
      schema: {
        type: 'boolean',
      },
    },
    TransferWebinar: {
      description: 'Transfer webinar.',
      in: 'query',
      name: 'transfer_webinar',
      required: false,
      schema: {
        type: 'boolean',
      },
    },
    Trash: {
      description:
        'Query trash.\n`true`: List recordings from trash.<br> `false`: Do not list recordings from the trash.<br> The default value is `false`. If you set it to `true`, you can use the `trash_type` property to indicate the type of Cloud recording that you need to retrieve. ',
      in: 'query',
      name: 'trash',
      schema: {
        default: false,
        type: 'boolean',
      },
    },
    UserId: {
      description: 'The user ID or email address of the user. For user-level apps, pass `me` as the value for userId.',
      in: 'path',
      name: 'userId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    WebhookId: {
      description: 'The webhook ID.',
      in: 'path',
      name: 'webhookId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    WebinarId: {
      description: 'The webinar ID in "**long**" format(represented as int64 data type in JSON). ',
      in: 'path',
      name: 'webinarId',
      required: true,
      schema: {
        format: 'int64',
        type: 'integer',
      },
    },
    WebinarId4Metrics: {
      description:
        'The webinar ID or the webinar UUID.  If a webinar ID is provided in the request instead of a UUID, the response will be for the latest webinar instance.\n\nIf a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875==\\"), you must **double encode** the UUID before making an API request.',
      in: 'path',
      name: 'webinarId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    WebinarTypePast: {
      description: 'The webinar type.',
      in: 'query',
      name: 'type',
      schema: {
        default: 'live',
        enum: ['past', 'live'],
        type: 'string',
      },
      'x-enum-descriptions': ['past webinars', 'live webinars'],
    },
    WebinarTypePast2: {
      description: 'The webinar type.',
      in: 'query',
      name: 'type',
      schema: {
        default: 'live',
        enum: ['past', 'live'],
        type: 'string',
      },
      'x-enum-descriptions': ['past webinar', 'live webinar'],
    },
    WebinarUUID: {
      description:
        "The Webinar UUID. Each Webinar instance will generate its own Webinar UUID (i.e., after a Webinar ends, a new UUID will be generated for the next instance of the Webinar). Please double encode your UUID when using it for API calls if the UUID begins with a '/' or contains '//' in it.",
      in: 'path',
      name: 'WebinarUUID',
      required: true,
      schema: {
        type: 'string',
      },
    },
    ZoomRoomId: {
      description: 'The Zoom room ID.',
      in: 'path',
      name: 'zoomroomId',
      required: true,
      schema: {
        type: 'string',
      },
    },
    trash_type: {
      description:
        'The type of Cloud recording that you would like to retrieve from the trash. The value can be one of the following:<br>\n    `meeting_recordings`: List all meeting recordings from the trash.<br>\n    `recording_file`: List all individual recording files from the trash. ',
      in: 'query',
      name: 'trash_type',
      schema: {
        default: 'meeting_recordings',
        type: 'string',
      },
    },
  },
  requestBodies: {
    recordingStatusUpdateBody: {
      content: {
        'application/json': {
          schema: {
            properties: {
              action: {
                enum: ['recover'],
                type: 'string',
                'x-enum-descriptions': ['recover meeting recording'],
              },
            },
          },
        },
        'multipart/form-data': {
          schema: {
            properties: {
              action: {
                enum: ['recover'],
                type: 'string',
                'x-enum-descriptions': ['recover meeting recording'],
              },
            },
          },
        },
      },
      required: true,
      'x-examples': {
        'application/json': {
          action: 'recover',
        },
      },
    },
    updateChannelBody: {
      content: {
        'application/json': {
          schema: {
            properties: {
              name: {
                description: 'A new name for the channel.',
                type: 'string',
              },
            },
            required: ['name'],
            type: 'object',
          },
        },
        'multipart/form-data': {
          schema: {
            properties: {
              name: {
                description: 'A new name for the channel.',
                type: 'string',
              },
            },
            required: ['name'],
            type: 'object',
          },
        },
      },
      'x-examples': {
        'application/json': {
          name: 'Share happiness channel',
        },
      },
    },
    uploadVB: {
      content: {
        'multipart/form-data': {
          schema: {
            properties: {
              file: {
                description: "Provide the file's path here.",
                type: 'string',
              },
            },
            type: 'object',
          },
        },
      },
    },
  },
  schemas: {
    Account: {
      description:
        "The account object represents an account on Zoom. The account owner is the user who created the account or had an account created for them. You can read more about the Zoom account structure <a href='https://medium.com/zoom-developer-blog/a-brief-look-at-zoom-account-structures-1d19c745bf8a' target='_blank'>here</a>.",
      properties: {
        email: {
          description: "User's email address.",
          type: 'string',
        },
        first_name: {
          description: "User's first name.",
          type: 'string',
        },
        last_name: {
          description: "User's last name.",
          type: 'string',
        },
        options: {
          description: 'Account options object.',
          properties: {
            billing_auto_renew: {
              description: 'Toggle whether automatic billing renewal is on or off.',
              type: 'boolean',
            },
            meeting_connector_list: {
              description:
                'Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_mc` is set to `true`.',
              items: {
                type: 'string',
              },
              type: 'array',
            },
            pay_mode: {
              default: 'master',
              description: 'Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.',
              enum: ['master', 'sub'],
              type: 'string',
              'x-enum-descriptions': ['master account holder pays', 'Sub account holder pays'],
            },
            room_connector_list: {
              description:
                'Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_rc` is set to `true`.',
              items: {
                type: 'string',
              },
              type: 'array',
            },
            share_mc: {
              default: false,
              description:
                'Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.',
              type: 'boolean',
            },
            share_rc: {
              default: false,
              description:
                'Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.',
              type: 'boolean',
            },
          },
          type: 'object',
        },
        password: {
          description: "User's password.",
          minimum: 8,
          type: 'string',
        },
        vanity_url: {
          description: 'Account Vanity URL',
          type: 'string',
        },
      },
      required: ['first_name', 'last_name', 'email', 'password'],
      type: 'object',
    },
    AccountList: {
      allOf: [
        {
          description: 'Pagination Object.',
          properties: {
            next_page_token: {
              description:
                'The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.',
              type: 'string',
            },
            page_count: {
              description: 'The number of pages returned for the request made.',
              type: 'integer',
            },
            page_number: {
              default: 1,
              description:
                '**Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.\n\nThe page number of the current results.',
              type: 'integer',
            },
            page_size: {
              default: 30,
              description: 'The number of records returned with a single API call.',
              maximum: 300,
              type: 'integer',
            },
            total_records: {
              description: 'The total number of all the records available across pages.',
              type: 'integer',
            },
          },
          type: 'object',
        },
        {
          description: 'Account object in the account list.',
          properties: {
            accounts: {
              description: 'List of Account objects.',
              items: {
                properties: {
                  account_name: {
                    description: 'Account name.',
                    type: 'string',
                  },
                  account_number: {
                    description: 'Account Number of the account.',
                    type: 'string',
                  },
                  account_type: {
                    description: 'Account type.',
                    type: 'string',
                  },
                  created_at: {
                    description: 'Account creation date and time.',
                    format: 'date-time',
                    type: 'string',
                  },
                  id: {
                    description: 'Account ID.',
                    type: 'string',
                  },
                  owner_email: {
                    description: 'Account owner email.',
                    example: 'john.doe@zoom.us',
                    type: 'string',
                  },
                  seats: {
                    description: 'Account seats.',
                    type: 'integer',
                  },
                  subscription_end_time: {
                    description: 'Account subscription end date and time.',
                    format: 'date-time',
                    type: 'string',
                  },
                  subscription_start_time: {
                    description: 'Account subscription start date and time.',
                    format: 'date-time',
                    type: 'string',
                  },
                },
                type: 'object',
              },
              type: 'array',
            },
          },
          type: 'object',
        },
      ],
      description: 'List of Accounts.',
      title: 'Account List',
      type: 'object',
    },
    AccountListItem: {
      description: 'Account object in the account list.',
      properties: {
        accounts: {
          description: 'List of Account objects.',
          items: {
            properties: {
              account_name: {
                description: 'Account name.',
                type: 'string',
              },
              account_number: {
                description: 'Account Number of the account.',
                type: 'string',
              },
              account_type: {
                description: 'Account type.',
                type: 'string',
              },
              created_at: {
                description: 'Account creation date and time.',
                format: 'date-time',
                type: 'string',
              },
              id: {
                description: 'Account ID.',
                type: 'string',
              },
              owner_email: {
                description: 'Account owner email.',
                example: 'john.doe@zoom.us',
                type: 'string',
              },
              seats: {
                description: 'Account seats.',
                type: 'integer',
              },
              subscription_end_time: {
                description: 'Account subscription end date and time.',
                format: 'date-time',
                type: 'string',
              },
              subscription_start_time: {
                description: 'Account subscription start date and time.',
                format: 'date-time',
                type: 'string',
              },
            },
            type: 'object',
          },
          type: 'array',
        },
      },
      type: 'object',
    },
    AccountOptions: {
      description: 'Account options object.',
      properties: {
        billing_auto_renew: {
          description: 'Toggle whether automatic billing renewal is on or off.',
          type: 'boolean',
        },
        meeting_connector_list: {
          description:
            'Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_mc` is set to `true`.',
          items: {
            type: 'string',
          },
          type: 'array',
        },
        pay_mode: {
          default: 'master',
          description: 'Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.',
          enum: ['master', 'sub'],
          type: 'string',
          'x-enum-descriptions': ['master account holder pays', 'Sub account holder pays'],
        },
        room_connector_list: {
          description:
            'Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.\n\n\n**Note:** This option can only be used if the value of `share_rc` is set to `true`.',
          items: {
            type: 'string',
          },
          type: 'array',
        },
        share_mc: {
          default: false,
          description:
            'Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.',
          type: 'boolean',
        },
        share_rc: {
          default: false,
          description:
            'Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.',
          type: 'boolean',
        },
      },
      type: 'object',
    },
    AccountPlan: {
      description: 'Account plan object.',
      properties: {
        hosts: {
          description: 'Account plan number of hosts.',
          type: 'integer',
        },
        type: {
          description:
            'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>',
          type: 'string',
        },
      },
      type: 'object',
    },
    AccountPlanBaseRequired: {
      description: 'Account base plan object.',
      properties: {
        hosts: {
          description:
            'Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.',
          type: 'integer',
        },
        type: {
          description:
            'Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>',
          type: 'string',
        },
      },
      required: ['type', 'hosts'],
      type: 'object',
    },
    AccountPlanRequired: {
      description: 'Account plan object.',
      properties: {
        hosts: {
          description: 'Number of hosts for this plan.',
          type: 'integer',
        },
        type: {
          description:
            'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>',
          type: 'string',
        },
      },
      required: ['type', 'hosts'],
      type: 'object',
    },
    AccountPlans: {
      description: 'Account Plans object.',
      properties: {
        plan_audio: {
          description:
            'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.',
          properties: {
            callout_countries: {
              description:
                'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.',
              type: 'string',
            },
            ddi_numbers: {
              description: 'Dedicated dial-In numbers.',
              type: 'integer',
            },
            premium_countries: {
              description:
                'Premium countries: multiple values should be separated by commas. For a list of allowed values, refer to the "ID" field in the [Premium Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#premium-countries) table.',
              type: 'string',
            },
            tollfree_countries: {
              description:
                'Toll-free countries: multiple values should separated by a comma. For a list of allowed values, refer to the "ID" field in the [Toll Free Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#toll-free-countries) table.',
              type: 'string',
            },
            type: {
              description:
                'Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.',
              type: 'string',
            },
          },
          type: 'object',
        },
        plan_base: {
          description: 'Account base plan object.',
          properties: {
            hosts: {
              description:
                'Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.',
              type: 'integer',
            },
            type: {
              description:
                'Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>',
              type: 'string',
            },
          },
          required: ['type', 'hosts'],
          type: 'object',
        },
        plan_large_meeting: {
          description: 'Additional large meeting Plans.',
          items: {
            description: 'Account plan object.',
            properties: {
              hosts: {
                description: 'Account plan number of hosts.',
                type: 'integer',
              },
              type: {
                description:
                  'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>',
                type: 'string',
              },
            },
            type: 'object',
          },
          type: 'array',
        },
        plan_phone: {
          description: 'Phone Plan Object',
          properties: {
            plan_base: {
              description: 'Additional phone base plans.',
              properties: {
                callout_countries: {
                  description:
                    'Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.',
                  type: 'string',
                },
                type: {
                  description:
                    'Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>',
                  type: 'string',
                },
              },
              type: 'object',
            },
            plan_calling: {
              description: 'Additional phone calling plans.',
              items: {
                properties: {
                  hosts: {
                    type: 'integer',
                  },
                  type: {
                    description:
                      'Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>',
                    type: 'string',
                  },
                },
                type: 'object',
              },
              type: 'array',
            },
            plan_number: {
              description: 'Additional phone number plans.',
              items: {
                properties: {
                  hosts: {
                    type: 'integer',
                  },
                  type: {
                    description:
                      'Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>',
                    type: 'string',
                  },
                },
                type: 'object',
              },
              type: 'array',
            },
          },
          title: 'PhonePlan',
          type: 'object',
        },
        plan_recording: {
          description: 'Additional cloud recording plan.',
          type: 'string',
        },
        plan_room_connector: {
          description: 'Account plan object.',
          properties: {
            hosts: {
              description: 'Account plan number of hosts.',
              type: 'integer',
            },
            type: {
              description:
                'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>',
              type: 'string',
            },
          },
          type: 'object',
        },
        plan_webinar: {
          description: 'Additional webinar plans.',
          items: {
            description: 'Account plan object.',
            properties: {
              hosts: {
                description: 'Account plan number of hosts.',
                type: 'integer',
              },
              type: {
                description:
                  'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>',
                type: 'string',
              },
            },
            type: 'object',
          },
          type: 'array',
        },
        plan_zoom_rooms: {
          description: 'Account plan object.',
          properties: {
            hosts: {
              description: 'Account plan number of hosts.',
              type: 'integer',
            },
            type: {
              description:
                'Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>',
              type: 'string',
            },
          },
          type: 'object',
        },
      },
      required: ['plan_base'],
      type: 'object',
    },
    AccountSettings: {
      properties: {
        email_notification: {
          description: 'Account Settings: Notification.',
          properties: {
            alternative_host_reminder: {
              description: 'Notify when an alternative host is set or removed from a meeting.',
              type: 'boolean',
            },
            cancel_meeting_reminder: {
              description: 'Notify the host and participants when a meeting is cancelled.',
              type: 'boolean',
            },
            cloud_recording_avaliable_reminder: {
              description: 'Notify host when cloud recording is available.',
              type: 'boolean',
            },
            jbh_reminder: {
              description: 'Notify the host when participants join the meeting before them.',
              type: 'boolean',
            },
            low_host_count_reminder: {
              description: 'Notify user when host licenses are running low.',
              type: 'boolean',
            },
            schedule_for_reminder: {
              description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.',
              type: 'boolean',
            },
          },
          type: 'object',
        },
        feature: {
          description: 'Account Settings: Feature.',
          properties: {
            meeting_capacity: {
              description: 'Set the maximum number of participants a host can have in a single meeting.',
              type: 'integer',
            },
          },
          type: 'object',
        },
        in_meeting: {
          description: 'Account Settings: In Meeting.',
          properties: {
            alert_guest_join: {
              description: 'Identify guest participants in a meeting or webinar.',
              type: 'boolean',
            },
            allow_live_streaming: {
              description: 'Allow live streaming.',
              type: 'boolean',
            },
            allow_participants_to_rename: {
              description:
                'If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.\n',
              type: 'boolean',
            },
            allow_show_zoom_windows: {
              description: 'Show the Zoom desktop application when sharing screens. ',
              type: 'boolean',
            },
            annotation: {
              description: 'Allow participants to use annotation tools to add information to shared screens.',
              type: 'boolean',
            },
            anonymous_question_answer: {
              description: 'Allow an anonymous Q&A in a webinar.',
              type: 'boolean',
            },
            attendee_on_hold: {
              default: false,
              description:
                'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**',
              type: 'boolean',
            },
            auto_answer: {
              description:
                'Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.',
              type: 'boolean',
            },
            auto_saving_chat: {
              description:
                'Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.',
              type: 'boolean',
            },
            breakout_room: {
              description: 'Allow host to split meeting participants into separate, smaller rooms.',
              type: 'boolean',
            },
            chat: {
              description: 'Allow meeting participants to send a message that is visible to all participants.',
              type: 'boolean',
            },
            closed_caption: {
              description:
                'Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions. ',
              type: 'boolean',
            },
            co_host: {
              description: 'Allow the host to add co-hosts.',
              type: 'boolean',
            },
            custom_data_center_regions: {
              description:
                'If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.',
              type: 'boolean',
            },
            custom_live_streaming_service: {
              description: 'Custom live streaming.',
              type: 'boolean',
            },
            custom_service_instructions: {
              description: 'Custom service instructions.',
              type: 'string',
            },
            data_center_regions: {
              description:
                'If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).\n',
              enum: ['EU', 'HK', 'AU', 'IN', 'TY', 'CN', 'US', 'CA'],
              items: {
                type: 'string',
              },
              type: 'array',
            },
            dscp_audio: {
              description: 'DSCP audio.',
              maximum: 63,
              minimum: 1,
              type: 'integer',
            },
            dscp_marking: {
              description: 'DSCP marking.',
              type: 'boolean',
            },
            dscp_video: {
              description: 'DSCP video.',
              maximum: 63,
              minimum: 1,
              type: 'integer',
            },
            e2e_encryption: {
              description:
                'Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).',
              type: 'boolean',
            },
            entry_exit_chime: {
              description:
                'Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.',
              enum: ['host', 'all', 'none'],
              type: 'string',
              'x-enum-descriptions': ['Heard by host only', 'Heard by host and all attendees', 'Disable'],
            },
            far_end_camera_control: {
              description: 'Allow another user to take control of your camera during a meeting.',
              type: 'boolean',
            },
            feedback: {
              description:
                'Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.',
              type: 'boolean',
            },
            file_transfer: {
              description:
                'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.',
              type: 'boolean',
            },
            group_hd: {
              description:
                'Activate higher quality video for host and participants.\nPlease note: This will use more bandwidth.',
              type: 'boolean',
            },
            meeting_reactions: {
              description:
                'Enable or disable meeting reactions. <br>\n`true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>\n`false`: Do not enable meeting reactions.',
              type: 'boolean',
            },
            original_audio: {
              description: 'Allow users to select original sound in their client settings.',
              type: 'boolean',
            },
            p2p_connetion: {
              description: 'Peer to peer connection while only two people are in a meeting.',
              type: 'boolean',
            },
            p2p_ports: {
              description: 'Peer to peer listening ports range.',
              type: 'boolean',
            },
            polling: {
              description: 'Add "Polls" to the meeting controls.',
              type: 'boolean',
            },
            ports_range: {
              default: '',
              description:
                'The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.',
              type: 'string',
            },
            post_meeting_feedback: {
              description: 'Display a thumbs up or down survey at the end of each meeting.',
              type: 'boolean',
            },
            private_chat: {
              description: 'Allow a meeting participant to send a private message to another participant.',
              type: 'boolean',
            },
            record_play_own_voice: {
              description: 'Record and play their own voice.',
              type: 'boolean',
            },
            remote_control: {
              description: 'Allow users to request remote control.',
              type: 'boolean',
            },
            request_permission_to_unmute: {
              description:
                'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.',
              type: 'boolean',
            },
            screen_sharing: {
              description: 'Allow screen sharing.',
              type: 'boolean',
            },
            sending_default_email_invites: {
              description: 'Only show the default email when sending email invites.',
              type: 'boolean',
            },
            show_a_join_from_your_browser_link: {
              description:
                'If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.',
              type: 'boolean',
            },
            show_meeting_control_toolbar: {
              description: 'Always show the meeting control toolbar.',
              type: 'boolean',
            },
            stereo_audio: {
              description: 'Allow users to select stereo audio in their client settings.',
              type: 'boolean',
            },
            use_html_format_email: {
              description: 'Use HTML formatted email for the Outlook plugin.',
              type: 'boolean',
            },
            virtual_background: {
              description:
                'Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.',
              type: 'boolean',
            },
            virtual_background_settings: {
              description: 'Settings to manage virtual background.',
              properties: {
                allow_upload_custom: {
                  description: 'Allow users to upload custom backgrounds.',
                  type: 'boolean',
                },
                allow_videos: {
                  description: 'Allow use of videos for virtual backgrounds.',
                  type: 'boolean',
                },
                enable: {
                  description: 'Enable virtual background.',
                  type: 'boolean',
                },
                files: {
                  items: {
                    properties: {
                      id: {
                        description: 'Unique identifier of the file.',
                        type: 'string',
                      },
                      is_default: {
                        description: 'Indicates whether or not this file is the default virtual background file.',
                        type: 'boolean',
                      },
                      name: {
                        description: 'File name.',
                        type: 'string',
                      },
                      size: {
                        description: 'File size.',
                        type: 'string',
                      },
                      type: {
                        description: 'File type.',
                        type: 'string',
                      },
                    },
                    type: 'object',
                  },
                  type: 'array',
                },
              },
              type: 'object',
            },
            watermark: {
              description: 'Add a watermark when viewing a shared screen.',
              type: 'boolean',
            },
            webinar_question_answer: {
              description: 'Allow a Q&A in a webinar.',
              type: 'boolean',
            },
            whiteboard: {
              description: 'Allow participants to share a whiteboard that includes annotation tools.',
              type: 'boolean',
            },
            who_can_share_screen: {
              description:
                'Indicates who can share their screen or content during meetings. The value can be one of the following: <br>\n`host`: Only host can share the screen.<br>\n`all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n',
              enum: ['host', 'all'],
              type: 'string',
            },
            who_can_share_screen_when_someone_is_sharing: {
              description:
                'Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>\n`host`: Only a host can share the screen when someone else is sharing.<br>\n`all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n',
              enum: ['host', 'all'],
              type: 'string',
            },
            workplace_by_facebook: {
              description: 'Workplace by facebook.',
              type: 'boolean',
            },
          },
          type: 'object',
        },
        integration: {
          description: 'Account Settings: Integration.',
          properties: {
            box: {
              description:
                'Enable users who join a meeting from their mobile device to share content from their Box account.',
              type: 'boolean',
            },
            dropbox: {
              description:
                'Enable users who join a meeting from their mobile device to share content from their Dropbox account.',
              type: 'boolean',
            },
            google_calendar: {
              description: 'Enable meetings to be scheduled using Google Calendar.',
              type: 'boolean',
            },
            google_drive: {
              description:
                'Enable users who join a meeting from their mobile device to share content from their Google Drive.',
              type: 'boolean',
            },
            kubi: {
              description: 'Enable users to control a connected Kubi device from within a Zoom meeting.',
              type: 'boolean',
            },
            microsoft_one_drive: {
              description:
                'Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.',
              type: 'boolean',
            },
          },
          type: 'object',
        },
        profile: {
          properties: {
            recording_storage_location: {
              properties: {
                allowed_values: {
                  description:
                    'Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.\n\nProvide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.',
                  items: {
                    type: 'string',
                  },
                  type: 'array',
                },
                value: {
                  description: 'Abbreviated country code.',
                  type: 'string',
                },
              },
              type: 'object',
            },
          },
          title: 'Profile',
          type: 'object',
        },
        recording: {
          description: 'Account Settings: Recording.',
          properties: {
            account_user_access_recording: {
              description:
                'Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.',
              type: 'boolean',
            },
            allow_recovery_deleted_cloud_recordings: {
              description:
                'Allow recovery of deleted cloud recordings from trash. \nIf the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period. ',
              type: 'boolean',
            },
            archive: {
              description:
                '[Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.',
              properties: {
                enable: {
                  description: 'Enable the archiving feature.',
                  type: 'boolean',
                },
                settings: {
                  properties: {
                    audio_file: {
                      description: 'Include in-meeting and/or in-webinar audio in the archive.',
                      type: 'boolean',
                    },
                    cc_transcript_file: {
                      description: 'Include closed caption or transcript in the archive.',
                      type: 'boolean',
                    },
                    chat_file: {
                      description: 'Include in-meeting chat in the archive.',
                      type: 'boolean',
                    },
                    chat_with_sender_email: {
                      description: 'Include user email in in-meeting chat file.',
                      type: 'boolean',
                    },
                    video_file: {
                      description: 'Include in-meeting and/or in-webinar video in the archive.',
                      type: 'boolean',
                    },
                  },
                  type: 'object',
                },
                type: {
                  description:
                    'Archive types:\n\n* `1`: Only meetings are archived.<br>\n* `2`: Only webinars are archived.<br>\n* `3`: Both meetings and webinars are archived.',
                  enum: [1, 2, 3],
                  type: 'integer',
                },
              },
              type: 'object',
            },
            auto_delete_cmr: {
              description:
                'Allow Zoom to permanantly delete recordings automatically after a specified number of days.',
              type: 'boolean',
            },
            auto_delete_cmr_days: {
              description:
                "When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.",
              type: 'integer',
            },
            auto_recording: {
              description:
                'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.',
              enum: ['local', 'cloud', 'none'],
              type: 'string',
              'x-enum-descriptions': ['Record on local', 'Record on cloud', 'Disabled'],
            },
            cloud_recording: {
              description: 'Allow hosts to record and save the meeting in the cloud.',
              type: 'boolean',
            },
            cloud_recording_download: {
              description: 'Cloud recording downloads.',
              type: 'boolean',
            },
            cloud_recording_download_host: {
              description: 'Only the host can download cloud recordings.',
              type: 'boolean',
            },
            host_delete_cloud_recording: {
              description:
                'If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.\n',
              type: 'boolean',
            },
            ip_address_access_control: {
              description: 'Setting to allow cloud recording access only from specific IP address ranges.\n',
              properties: {
                enable: {
                  description:
                    'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n',
                  type: 'boolean',
                },
                ip_addresses_or_ranges: {
                  description:
                    'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n',
                  type: 'string',
                },
              },
              type: 'object',
            },
            local_recording: {
              description: 'Allow hosts and participants to record the meeting using a local file.',
              type: 'boolean',
            },
            prevent_host_access_recording: {
              description:
                'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n',
              type: 'boolean',
            },
            record_audio_file: {
              description: 'Record an audio only file.',
              type: 'boolean',
            },
            record_gallery_view: {
              description: 'Record the gallery view with a shared screen.',
              type: 'boolean',
            },
            record_speaker_view: {
              description: 'Record the active speaker with a shared screen.',
              type: 'boolean',
            },
            recording_audio_transcript: {
              description: 'Automatically transcribe the audio of the meeting or webinar to the cloud.',
              type: 'boolean',
            },
            recording_disclaimer: {
              description: 'Show a disclaimer to participants before a recording starts\n',
              type: 'boolean',
            },
            recording_password_requirement: {
              description:
                'This object represents the minimum password requirements set for recordings via Account Recording Settings.',
              properties: {
                have_letter: {
                  description:
                    'Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).',
                  type: 'boolean',
                },
                have_number: {
                  description: 'Indicates whether or not password must contain at least one number(1, 2, 3..).',
                  type: 'boolean',
                },
                have_special_character: {
                  description:
                    'Indicates whether or not password must contain at least one special character(!, @, #..).',
                  type: 'boolean',
                },
                length: {
                  description: 'Minimum required length for the password.',
                  maximum: 10,
                  type: 'integer',
                },
                only_allow_numeric: {
                  description: 'Indicates whether or not password must contain only numeric characters.',
                  type: 'boolean',
                },
              },
              type: 'object',
            },
            required_password_for_existing_cloud_recordings: {
              description: 'Require a passcode to access existing cloud recordings.',
              type: 'boolean',
            },
            save_chat_text: {
              description: 'Save the chat text from the meeting.',
              type: 'boolean',
            },
            show_timestamp: {
              description: 'Add a timestamp to the recording.',
              type: 'boolean',
            },
          },
          type: 'object',
        },
        schedule_meeting: {
          description: 'Account Settings: Schedule Meeting.',
          properties: {
            audio_type: {
              default: 'both',
              description:
                'Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.',
              enum: ['both', 'telephony', 'voip', 'thirdParty'],
              type: 'string',
              'x-enum-descriptions': [
                'Telephony and VoIP',
                'Audio PSTN telephony only',
                'VoIP only',
                '3rd party audio conference',
              ],
            },
            enforce_login: {
              description: 'Only Zoom users who are signed in can join meetings.',
              type: 'boolean',
            },
            enforce_login_domains: {
              description: 'Only signed in users with a specified domain can join the meeting. ',
              type: 'string',
            },
            enforce_login_with_domains: {
              description: 'Only signed in users with a specific domain can join meetings.',
              type: 'boolean',
            },
            force_pmi_jbh_password: {
              description: 'Require a password for Personal Meetings if attendees can join before host.',
              type: 'boolean',
            },
            host_video: {
              description: 'Start meetings with the host video on.',
              type: 'boolean',
            },
            join_before_host: {
              description: 'Allow participants to join the meeting before the host arrives.',
              type: 'boolean',
            },
            meeting_password_requirement: {
              description:
                'Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).',
              properties: {
                consecutive_characters_length: {
                  enum: [0, 4, 5, 6, 7, 8],
                  type: 'integer',
                },
                have_letter: {
                  description: 'If set to `true`, the password must contain at least 1 letter (such as a,b,c...).\n',
                  type: 'boolean',
                },
                have_number: {
                  description: 'If set to `true`, the password must contain at least 1 number (such as 1,2,3...).',
                  type: 'boolean',
                },
                have_special_character: {
                  description: 'If set to `true`, the password must have at least 1 special character (!,@,#...).',
                  type: 'boolean',
                },
                have_upper_and_lower_characters: {
                  description: 'If set to `true`, the password must include both uppercase and lowercase characters.',
                  type: 'boolean',
                },
                length: {
                  description: 'The minimum length that the meeting/webinar password needs to have.',
                  type: 'integer',
                },
                only_allow_numeric: {
                  description: 'If set to `true`, the password must only contain numbers and no other characters.',
                  type: 'boolean',
                },
                weak_enhance_detection: {
                  description: 'If set to `true`, users will be informed if the provided password is weak.',
                  type: 'boolean',
                },
              },
              type: 'object',
            },
            not_store_meeting_topic: {
              description: 'Always display "Zoom Meeting" as the meeting topic.',
              type: 'boolean',
            },
            participant_video: {
              description:
                'Start meetings with the participant video on. Participants can change this setting during the meeting.',
              type: 'boolean',
            },
            personal_meeting: {
              description:
                'Personal Meeting Setting.<br><br>\n`true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>\n`false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.\nFor Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.\n\n\n',
              type: 'boolean',
            },
            require_password_for_instant_meetings: {
              description:
                'Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n',
              type: 'boolean',
            },
            require_password_for_pmi_meetings: {
              description:
                'Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.\n',
              enum: ['jbh_only', 'all', 'none'],
              type: 'string',
              'x-enum-descriptions': [
                'Only meetings with Join Before Host enabled',
                'All meetings using PMI',
                'Disabled',
              ],
            },
            require_password_for_scheduled_meetings: {
              description: 'Require a password for meetings which have already been scheduled\n',
              type: 'boolean',
            },
            require_password_for_scheduling_new_meetings: {
              description:
                'Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.',
              type: 'boolean',
            },
            use_pmi_for_instant_meetings: {
              description: 'Use Personal Meeting ID (PMI) when starting an instant meeting\n',
              type: 'boolean',
            },
            use_pmi_for_scheduled_meetings: {
              description: 'Use Personal Meeting ID (PMI) when scheduling a meeting\n',
              type: 'boolean',
            },
          },
          type: 'object',
        },
        security: {
          description:
            '[Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.',
          properties: {
            admin_change_name_pic: {
              description: "Only account administrators can change a user's username and picture.",
              type: 'boolean',
            },
            hide_billing_info: {
              description: 'Hide billing information.',
              type: 'boolean',
            },
            import_photos_from_devices: {
              description: 'Allow users to import photos from a photo library on a  device.',
              type: 'boolean',
            },
            password_requirement: {
              description:
                "This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password. ",
              properties: {
                consecutive_characters_length: {
                  description:
                    '\nSpecify the max length of consecutive characters(abcde...) that can be used in a password.\nIf you set the value of this field to `0`, no restriction will be applied on consecutive characters. \n\nIf you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.\n\nThe max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).',
                  type: 'integer',
                },
                have_special_character: {
                  description:
                    'If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).',
                  type: 'boolean',
                },
                minimum_password_length: {
                  description:
                    'Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.',
                  maximum: 14,
                  minimum: 8,
                  type: 'integer',
                },
                weak_enhance_detection: {
                  description:
                    'If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.',
                  type: 'boolean',
                },
              },
              type: 'object',
            },
            sign_again_period_for_inactivity_on_client: {
              description:
                'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`45`: 45 minutes<br>\n`60`: 60 minutes<br>\n`90`: 90 minutes<br>\n`120`: 120 minutes\n',
              type: 'integer',
            },
            sign_again_period_for_inactivity_on_web: {
              description:
                'Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>\n\nIf this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>\n\n`5`: 5 minutes<br>\n`10`: 10 minutes<br>\n`15`: 15 minutes<br>\n`30`: 30 minutes<br>\n`60`: 60 minutes<br>\n`120`: 120 minutes\n\n    \n\n',
              type: 'integer',
            },
            sign_in_with_two_factor_auth: {
              description:
                'Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:\n`all`: Two factor authentication will be enabled for all users in the account.<br>\n`none`: Two factor authentication is disabled.<br>\n`group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>\n`role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the\n`sign_in_with_two_factor_auth_roles` field.\n',
              enum: ['all', 'group', 'role', 'none'],
              type: 'string',
            },
            sign_in_with_two_factor_auth_groups: {
              description:
                'This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`',
              items: {
                type: 'string',
              },
              type: 'array',
            },
            sign_in_with_two_factor_auth_roles: {
              description:
                'This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.',
              items: {
                type: 'string',
              },
              type: 'array',
            },
          },
          type: 'object',
        },
        telephony: {
          description: 'Account Settings: Telephony.',
          properties: {
            audio_conference_info: {
              description: 'Third party audio conference info.',
              type: 'string',
            },
            telephony_regions: {
              description: 'Indicates where most of the participants call into or call from duriing a meeting.',
              properties: {
                allowed_values: {
                  description: 'Telephony region options provided by Zoom to select from.',
                  items: {
                    type: 'string',
                  },
                  type: 'array',
                },
                selection_values: {
                  description:
                    'Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.',
                  items: {
                    type: 'string',
                  },
                  type: 'array',
                },
              },
              type: 'object',
            },
            third_party_audio: {
              description: 'Users can join the meeting using the existing third party audio configuration.',
              type: 'boolean',
            },
          },
          type: 'object',
        },
        tsp: {
          description: 'Account Settings: TSP.',
          properties: {
            call_out: {
              description: 'Call Out',
              type: 'boolean',
            },
            call_out_countries: {
              description: 'Call Out Countries/Regions',
              items: {},
              type: 'array',
            },
            display_toll_free_numbers: {
              description: 'Display toll-free numbers',
              type: 'boolean',
            },
            show_international_numbers_link: {
              description: 'Show international numbers link on the invitation email',
              type: 'boolean',
            },
          },
          type: 'object',
        },
        zoom_rooms: {
          description: 'Account Settings: Zoom Rooms.',
          properties: {
            auto_start_stop_scheduled_meetings: {
              description: 'Automatic start and stop for scheduled meetings.',
              type: 'boolean',
            },
            cmr_for_instant_meeting: {
              description: 'Cloud recording for instant meetings.',
              type: 'boolean',
            },
            force_private_meeting: {
              description: 'Shift all meetings to private.',
              type: 'boolean',
            },
            hide_host_information: {
              description: 'Hide host and meeting ID from private meetings.',
              type: 'boolean',
            },
            list_meetings_with_calendar: {
              description: 'Display meeting list with calendar integration.',
              type: 'boolean',
            },
            start_airplay_manually: {
              description: 'Start AirPlay service manually.',
              type: 'boolean',
            },
            ultrasonic: {
              description: 'Automatic direct sharing using an ultrasonic proximity signal.',
              type: 'boolean',
            },
            upcoming_meeting_alert: {
              description: 'Upcoming meeting alert.',
              type: 'boolean',
            },
            weekly_system_restart: {
              description: 'Weekly system restart.',
              type: 'boolean',
            },
            zr_post_meeting_feedback: {
              description: 'Zoom Room post meeting feedback.',
              type: 'boolean',
            },
          },
          type: 'object',
        },
      },
      title: 'Account settings',
      type: 'object',
    },
    AccountSettingsAuthentication: {
      oneOf: [
        {
          properties: {
            authentication_options: {
              description: 'Meeting Authentication Options',
              items: {
                properties: {
                  default_option: {
                    description: 'Authentication default option',
                    type: 'boolean',
                  },
                  domains: {
                    description: 'Authentication domians',
                    type: 'string',
                  },
                  id: {
                    description: 'Authentication id',
                    type: 'string',
                  },
                  name: {
                    description: 'Authentication name',
                    type: 'string',
                  },
                  type: {
                    description:
                      ' Authentication type. Specify one of the following authentication types for the authentication profile:<br>\n * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>\n * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.',
                    enum: ['enforce_login', 'enforce_login_with_same_account', 'enforce_login_with_domains'],
                    type: 'string',
                  },
                  visible: {
                    description: 'Authentication visible',
                    type: 'boolean',
                  },
                },
                type: 'object',
              },
              type: 'array',
            },
            meeting_authentication: {
              description: 'Only authenticated users can join meetings',
              type: 'boolean',
            },
          },
        },
        {
          properties: {
            authentication_options: {
              items: {
                properties: {
                  default_option: {
                    description: 'Authentication default option',
                    type: 'boolean',
                  },
                  domains: {
                    description: 'Authentication domians',
                    type: 'string',
                  },
                  id: {
                    description: 'Authentication id',
                    type: 'string',
                  },
                  name: {
                    description: 'Authentication name',
                    type: 'string',
                  },
                  type: {
                    description: 'Authentication type',
                    enum: ['internally', 'enforce_login', 'enforce_login_with_domains'],
                    type: 'string',
                  },
                  visible: {
                    description: 'Authentication visible',
                    type: 'boolean',
                  },
                },
                type: 'object',
              },
              type: 'array',
            },
            recording_authentication: {
              description: 'Only authenticated users can view cloud recordings',
              type: 'boolean',
            },
          },
        },
      ],
      title: 'AccountSettingsAuthentication',
      type: 'object',
    },
    AccountSettingsAuthenticationUpdate: {
      oneOf: [
        {
          description:
            'Set/ update [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars).<br><br> The authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).',
          properties: {
            authentication_option: {
              description: 'Meeting Authentication Options',
              properties: {
                action: {
                  description:
                    'Specify the action that you would like to take via this API request:<br>\n* `add` : Choose this value if you are adding an authentication option.\n* `update`: Choose this value if you are updating an existing authentication option.\n* `delete`: Choose this value if you are deleting an existing authentication option.',
                  enum: ['update', 'delete', 'add'],
                  type: 'string',
                },
                default_option: {
                  description:
                    'Specify whether you would like to set this authentication option as the default option or not.',
                  type: 'boolean',
                },
                domains: {
                  description:
                    'If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to join your meetings or webinars. ',
                  type: 'string',
                },
                id: {
                  description:
                    ' Authentication ID. If you are creating an authentication profile, you do not need to provide this field. The id field will be generated in the response once this API request is completed successfully. You can also use the Get Account Settings API with query parameter set to `meeting_authentication` to list the authentication id.<br><br>\n Use this field or the `name` field to identify the associated authentication option that you would like to update or delete.',
                  type: 'string',
                },
                name: {
                  description: 'Unique name for the authentication option.',
                  type: 'string',
                },
                type: {
                  description:
                    ' Authentication type. Specify one of the following authentication types for the authentication profile:<br>\n * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>\n * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.',
                  enum: ['enforce_login', 'enforce_login_with_same_account', 'enforce_login_with_domains'],
                  type: 'string',
                },
              },
              type: 'object',
            },
            meeting_authentication: {
              description:
                'If set to "true", only authenticated users can join meetings. The method for authentication can be defined in the "authentication_option". ',
              type: 'boolean',
            },
          },
        },
        {
          description:
            'Set/Update [authentication profile for Cloud Recordings](https://support.zoom.us/hc/en-us/articles/360037756671-Authentication-Profiles-for-Cloud-Recordings).',
          properties: {
            authentication_option: {
              description: 'Specify the authentication options for this account.',
              properties: {
                action: {
                  description:
                    'Specify the action that you would like to take via this API request:<br>\n* `add` : Choose this value if you are adding an authentication option.\n* `update`: Choose this value if you are updating an existing authentication option.\n* `delete`: Choose this value if you are deleting an existing authentication option.',
                  enum: ['update', 'delete', 'add'],
                  type: 'string',
                },
                default_option: {
                  description:
                    'Specify whether you would like to set this authentication option as the default option or not.',
                  type: 'boolean',
                },
                domains: {
                  description:
                    'If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to view the recordings. ',
                  type: 'string',
                },
                id: {
                  description:
                    ' Authentication ID. If you are creating an authentication profile, you do not need to provide this field. The id field will be generated in the response once this API request is completed successfully. You can also use the Get Account Settings API with query parameter set to `meeting_authentication` to list the authentication id.<br><br>\nUse this field or the `name` field to identify the associated authentication option that you would like to update or delete.',
                  type: 'string',
                },
                name: {
                  description: 'Unique name for the authentication option.',
                  type: 'string',
                },
                type: {
                  description:
                    'Specify one authentication type that is to be associated with this authentication configuration:<br>\n* `internally`: This option allows you specify a rule that only signed in users within your account can view the recording.<br>\n * `enforce_login`: This option allows any users to view the recording, as long as they are signed into their Zoom account.<br>\n * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can view the recording. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.\n\n',
                  enum: ['internally', 'enforce_login', 'enforce_login_with_domains'],
                  type: 'string',
                },
              },
              type: 'object',
            },
            recording_authentication: {
              description:
                'If set to `true`, only authenticated users can view the cloud recordings.<br><br>\nThe authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).',
              type: 'boolean',
            },
          },
        },
      ],
      title: 'AccountSettingsAuthenticationUpdate',
      type: 'object',
    },
    AccountSettingsEmailNotification: {
      description: 'Account Settings: Notification.',
      properties: {
        alternative_host_reminder: {
          description: 'Notify when an alternative host is set or removed from a meeting.',
          type: 'boolean',
        },
        cancel_meeting_reminder: {
          description: 'Notify the host and participants when a meeting is cancelled.',
          type: 'boolean',
        },
        cloud_recording_avaliable_reminder: {
          description: 'Notify host when cloud recording is available.',
          type: 'boolean',
        },
        jbh_reminder: {
          description: 'Notify the host when participants join the meeting before them.',
          type: 'boolean',
        },
        low_host_count_reminder: {
          description: 'Notify user when host licenses are running low.',
          type: 'boolean',
        },
        schedule_for_reminder: {
          description: 'Notify the host there is a meeting is scheduled, rescheduled, or cancelled.',
          type: 'boolean',
        },
      },
      type: 'object',
    },
    AccountSettingsFeature: {
      description: 'Account Settings: Feature.',
      properties: {
        meeting_capacity: {
          description: 'Set the maximum number of participants a host can have in a single meeting.',
          type: 'integer',
        },
      },
      type: 'object',
    },
    AccountSettingsInMeeting: {
      description: 'Account Settings: In Meeting.',
      properties: {
        alert_guest_join: {
          description: 'Identify guest participants in a meeting or webinar.',
          type: 'boolean',
        },
        allow_live_streaming: {
          description: 'Allow live streaming.',
          type: 'boolean',
        },
        allow_participants_to_rename: {
          description:
            'If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.\n',
          type: 'boolean',
        },
        allow_show_zoom_windows: {
          description: 'Show the Zoom desktop application when sharing screens. ',
          type: 'boolean',
        },
        annotation: {
          description: 'Allow participants to use annotation tools to add information to shared screens.',
          type: 'boolean',
        },
        anonymous_question_answer: {
          description: 'Allow an anonymous Q&A in a webinar.',
          type: 'boolean',
        },
        attendee_on_hold: {
          default: false,
          description:
            'Allow host to put attendee on hold.\n\n**This field has been deprecated and is no longer supported.**',
          type: 'boolean',
        },
        auto_answer: {
          description:
            'Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.',
          type: 'boolean',
        },
        auto_saving_chat: {
          description:
            'Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.',
          type: 'boolean',
        },
        breakout_room: {
          description: 'Allow host to split meeting participants into separate, smaller rooms.',
          type: 'boolean',
        },
        chat: {
          description: 'Allow meeting participants to send a message that is visible to all participants.',
          type: 'boolean',
        },
        closed_caption: {
          description:
            'Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions. ',
          type: 'boolean',
        },
        co_host: {
          description: 'Allow the host to add co-hosts.',
          type: 'boolean',
        },
        custom_data_center_regions: {
          description:
            'If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.',
          type: 'boolean',
        },
        custom_live_streaming_service: {
          description: 'Custom live streaming.',
          type: 'boolean',
        },
        custom_service_instructions: {
          description: 'Custom service instructions.',
          type: 'string',
        },
        data_center_regions: {
          description:
            'If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).\n',
          enum: ['EU', 'HK', 'AU', 'IN', 'TY', 'CN', 'US', 'CA'],
          items: {
            type: 'string',
          },
          type: 'array',
        },
        dscp_audio: {
          description: 'DSCP audio.',
          maximum: 63,
          minimum: 1,
          type: 'integer',
        },
        dscp_marking: {
          description: 'DSCP marking.',
          type: 'boolean',
        },
        dscp_video: {
          description: 'DSCP video.',
          maximum: 63,
          minimum: 1,
          type: 'integer',
        },
        e2e_encryption: {
          description:
            'Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).',
          type: 'boolean',
        },
        entry_exit_chime: {
          description:
            'Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.',
          enum: ['host', 'all', 'none'],
          type: 'string',
          'x-enum-descriptions': ['Heard by host only', 'Heard by host and all attendees', 'Disable'],
        },
        far_end_camera_control: {
          description: 'Allow another user to take control of your camera during a meeting.',
          type: 'boolean',
        },
        feedback: {
          description:
            'Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.',
          type: 'boolean',
        },
        file_transfer: {
          description:
            'Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.',
          type: 'boolean',
        },
        group_hd: {
          description:
            'Activate higher quality video for host and participants.\nPlease note: This will use more bandwidth.',
          type: 'boolean',
        },
        meeting_reactions: {
          description:
            'Enable or disable meeting reactions. <br>\n`true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>\n`false`: Do not enable meeting reactions.',
          type: 'boolean',
        },
        original_audio: {
          description: 'Allow users to select original sound in their client settings.',
          type: 'boolean',
        },
        p2p_connetion: {
          description: 'Peer to peer connection while only two people are in a meeting.',
          type: 'boolean',
        },
        p2p_ports: {
          description: 'Peer to peer listening ports range.',
          type: 'boolean',
        },
        polling: {
          description: 'Add "Polls" to the meeting controls.',
          type: 'boolean',
        },
        ports_range: {
          default: '',
          description:
            'The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.',
          type: 'string',
        },
        post_meeting_feedback: {
          description: 'Display a thumbs up or down survey at the end of each meeting.',
          type: 'boolean',
        },
        private_chat: {
          description: 'Allow a meeting participant to send a private message to another participant.',
          type: 'boolean',
        },
        record_play_own_voice: {
          description: 'Record and play their own voice.',
          type: 'boolean',
        },
        remote_control: {
          description: 'Allow users to request remote control.',
          type: 'boolean',
        },
        request_permission_to_unmute: {
          description:
            'Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.',
          type: 'boolean',
        },
        screen_sharing: {
          description: 'Allow screen sharing.',
          type: 'boolean',
        },
        sending_default_email_invites: {
          description: 'Only show the default email when sending email invites.',
          type: 'boolean',
        },
        show_a_join_from_your_browser_link: {
          description:
            'If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.',
          type: 'boolean',
        },
        show_meeting_control_toolbar: {
          description: 'Always show the meeting control toolbar.',
          type: 'boolean',
        },
        stereo_audio: {
          description: 'Allow users to select stereo audio in their client settings.',
          type: 'boolean',
        },
        use_html_format_email: {
          description: 'Use HTML formatted email for the Outlook plugin.',
          type: 'boolean',
        },
        virtual_background: {
          description:
            'Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.',
          type: 'boolean',
        },
        virtual_background_settings: {
          description: 'Settings to manage virtual background.',
          properties: {
            allow_upload_custom: {
              description: 'Allow users to upload custom backgrounds.',
              type: 'boolean',
            },
            allow_videos: {
              description: 'Allow use of videos for virtual backgrounds.',
              type: 'boolean',
            },
            enable: {
              description: 'Enable virtual background.',
              type: 'boolean',
            },
            files: {
              items: {
                properties: {
                  id: {
                    description: 'Unique identifier of the file.',
                    type: 'string',
                  },
                  is_default: {
                    description: 'Indicates whether or not this file is the default virtual background file.',
                    type: 'boolean',
                  },
                  name: {
                    description: 'File name.',
                    type: 'string',
                  },
                  size: {
                    description: 'File size.',
                    type: 'string',
                  },
                  type: {
                    description: 'File type.',
                    type: 'string',
                  },
                },
                type: 'object',
              },
              type: 'array',
            },
          },
          type: 'object',
        },
        watermark: {
          description: 'Add a watermark when viewing a shared screen.',
          type: 'boolean',
        },
        webinar_question_answer: {
          description: 'Allow a Q&A in a webinar.',
          type: 'boolean',
        },
        whiteboard: {
          description: 'Allow participants to share a whiteboard that includes annotation tools.',
          type: 'boolean',
        },
        who_can_share_screen: {
          description:
            'Indicates who can share their screen or content during meetings. The value can be one of the following: <br>\n`host`: Only host can share the screen.<br>\n`all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n',
          enum: ['host', 'all'],
          type: 'string',
        },
        who_can_share_screen_when_someone_is_sharing: {
          description:
            'Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>\n`host`: Only a host can share the screen when someone else is sharing.<br>\n`all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.\n',
          enum: ['host', 'all'],
          type: 'string',
        },
        workplace_by_facebook: {
          description: 'Workplace by facebook.',
          type: 'boolean',
        },
      },
      type: 'object',
    },
    AccountSettingsIntegration: {
      description: 'Account Settings: Integration.',
      properties: {
        box: {
          description:
            'Enable users who join a meeting from their mobile device to share content from their Box account.',
          type: 'boolean',
        },
        dropbox: {
          description:
            'Enable users who join a meeting from their mobile device to share content from their Dropbox account.',
          type: 'boolean',
        },
        google_calendar: {
          description: 'Enable meetings to be scheduled using Google Calendar.',
          type: 'boolean',
        },
        google_drive: {
          description:
            'Enable users who join a meeting from their mobile device to share content from their Google Drive.',
          type: 'boolean',
        },
        kubi: {
          description: 'Enable users to control a connected Kubi device from within a Zoom meeting.',
          type: 'boolean',
        },
        microsoft_one_drive: {
          description:
            'Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.',
          type: 'boolean',
        },
      },
      type: 'object',
    },
    AccountSettingsRecording: {
      description: 'Account Settings: Recording.',
      properties: {
        account_user_access_recording: {
          description:
            'Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.',
          type: 'boolean',
        },
        allow_recovery_deleted_cloud_recordings: {
          description:
            'Allow recovery of deleted cloud recordings from trash. \nIf the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period. ',
          type: 'boolean',
        },
        archive: {
          description:
            '[Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.',
          properties: {
            enable: {
              description: 'Enable the archiving feature.',
              type: 'boolean',
            },
            settings: {
              properties: {
                audio_file: {
                  description: 'Include in-meeting and/or in-webinar audio in the archive.',
                  type: 'boolean',
                },
                cc_transcript_file: {
                  description: 'Include closed caption or transcript in the archive.',
                  type: 'boolean',
                },
                chat_file: {
                  description: 'Include in-meeting chat in the archive.',
                  type: 'boolean',
                },
                chat_with_sender_email: {
                  description: 'Include user email in in-meeting chat file.',
                  type: 'boolean',
                },
                video_file: {
                  description: 'Include in-meeting and/or in-webinar video in the archive.',
                  type: 'boolean',
                },
              },
              type: 'object',
            },
            type: {
              description:
                'Archive types:\n\n* `1`: Only meetings are archived.<br>\n* `2`: Only webinars are archived.<br>\n* `3`: Both meetings and webinars are archived.',
              enum: [1, 2, 3],
              type: 'integer',
            },
          },
          type: 'object',
        },
        auto_delete_cmr: {
          description: 'Allow Zoom to permanantly delete recordings automatically after a specified number of days.',
          type: 'boolean',
        },
        auto_delete_cmr_days: {
          description:
            "When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.",
          type: 'integer',
        },
        auto_recording: {
          description:
            'Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.',
          enum: ['local', 'cloud', 'none'],
          type: 'string',
          'x-enum-descriptions': ['Record on local', 'Record on cloud', 'Disabled'],
        },
        cloud_recording: {
          description: 'Allow hosts to record and save the meeting in the cloud.',
          type: 'boolean',
        },
        cloud_recording_download: {
          description: 'Cloud recording downloads.',
          type: 'boolean',
        },
        cloud_recording_download_host: {
          description: 'Only the host can download cloud recordings.',
          type: 'boolean',
        },
        host_delete_cloud_recording: {
          description:
            'If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.\n',
          type: 'boolean',
        },
        ip_address_access_control: {
          description: 'Setting to allow cloud recording access only from specific IP address ranges.\n',
          properties: {
            enable: {
              description:
                'If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.\n\n',
              type: 'boolean',
            },
            ip_addresses_or_ranges: {
              description:
                'IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.\n\nExample: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`\n\n',
              type: 'string',
            },
          },
          type: 'object',
        },
        local_recording: {
          description: 'Allow hosts and participants to record the meeting using a local file.',
          type: 'boolean',
        },
        prevent_host_access_recording: {
          description:
            'If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.\n',
          type: 'boolean',
        },
        record_audio_file: {
          description: 'Record an audio only file.',
          type: 'boolean',
        },
        record_gallery_view: {
          description: 'Record the gallery view with a shared screen.',
          type: 'boolean',
        },
        record_speaker_view: {
          description: 'Record the active speaker with a shared screen.',
          type: 'boolean',
        },
        recording_audio_transcript: {
          description: 'Automatically transcribe the audio of the meeting or webinar to the cloud.',
          type: 'boolean',
        },
        recording_disclaimer: {
          description: 'Show a disclaimer to participants before a recording starts\n',
          type: 'boolean',
        },
        recording_password_requirement: {
          description:
            'This object represents the minimum password requirements set for recordings via Account Recording Settings.',
          properties: {
            have_letter: {
              description:
                'Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).',
              type: 'boolean',
            },
            have_number: {
              description: 'Indicates whether or not password must contain at least one number(1, 2, 3..).',
              type: 'boolean',
            },
            have_special_character: {
              description: 'Indicates whether or not password must contain at least one special character(!, @, #..).',
              type: 'boolean',
            },
            length: {
              description: 'Minimum required length for the password.',
              maximum: 10,
              type: 'integer',
            },
            only_allow_numeric: {
              description: 'Indicates whether or not password must contain only numeric characters.',
              type: 'boolean',
            },
          },
          type: 'object',
        },
        required_password_for_existing_cloud_recordings: {
          description: 'Require a passcode to access existing cloud recordings.',
          type: 'boolean',
        },
        save_chat_text: {
          description: 'Save the chat text from the meeting.',
          type: 'boolean',
        },
        show_timestamp: {
          description: 'Add a timestamp to the recording.',
          type: 'boolean',
        },
      },
      type: 'object',
    },
    AccountSettingsRecordingAuthenticationUpdate: {
      description:
        'Only authenticated users can view cloud recordings\nThe viewers need to authenticate prior to viewing the cloud recordings, hosts can choose one of the authentication methods when sharing a cloud recording.',
      properties: {
        authentication_option: {
          properties: {
            action: {
              enum: ['update', 'add', 'delete'],
              type: 'string',
            },
            default_option: {
              type: 'boolean',
            },
            domains: {
              type: 'string',
            },
            id: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            type: {
              enum: ['internally', 'enforce_login', 'enforce_login_with_domains'],
              type: 'string',
            },
          },
          type: 'object',
        },
        recording_authentication: {
          type: 'boolean',
        },
      },
      title: 'AccountSettingsRecordingAuthenticationUpdate',
      type: 'object',
    },
    AccountSettingsScheduleMeeting: {
      description: 'Account Settings: Schedule Meeting.',
      properties: {
        audio_type: {
          default: 'both',
          description:
            'Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.',
          enum: ['both', 'telephony', 'voip', 'thirdParty'],
          type: 'string',
          'x-enum-descriptions': [
            'Telephony and VoIP',
            'Audio PSTN telephony only',
            'VoIP only',
            '3rd party audio conference',
          ],
        },
        enforce_login: {
          description: 'Only Zoom users who are signed in can join meetings.',
          type: 'boolean',
        },
        enforce_login_domains: {
          description: 'Only signed in users with a specified domain can join the meeting. ',
          type: 'string',
        },
        enforce_login_with_domains: {
          description: 'Only signed in users with a specific domain can join meetings.',
          type: 'boolean',
        },
        force_pmi_jbh_password: {
          description: 'Require a password for Personal Meetings if attendees can join before host.',
