// Generated by ts-to-zod
import { z } from 'zod';

export const accountSchema = z.object({
  email: z.string(),
  first_name: z.string(),
  last_name: z.string(),
  options: z
    .object({
      billing_auto_renew: z.boolean().optional(),
      meeting_connector_list: z.array(z.string()).optional(),
      pay_mode: z.union([z.literal('master'), z.literal('sub')]).optional(),
      room_connector_list: z.array(z.string()).optional(),
      share_mc: z.boolean().optional(),
      share_rc: z.boolean().optional(),
    })
    .optional(),
  password: z.string(),
  vanity_url: z.string().optional(),
});

export const payModeSchema = z.union([z.literal('master'), z.literal('sub')]);

export const accountListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      accounts: z
        .array(
          z.object({
            account_name: z.string().optional(),
            account_number: z.string().optional(),
            account_type: z.string().optional(),
            created_at: z.string().optional(),
            id: z.string().optional(),
            owner_email: z.string().optional(),
            seats: z.number().optional(),
            subscription_end_time: z.string().optional(),
            subscription_start_time: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const accountListItemSchema = z.object({
  accounts: z
    .array(
      z.object({
        account_name: z.string().optional(),
        account_number: z.string().optional(),
        account_type: z.string().optional(),
        created_at: z.string().optional(),
        id: z.string().optional(),
        owner_email: z.string().optional(),
        seats: z.number().optional(),
        subscription_end_time: z.string().optional(),
        subscription_start_time: z.string().optional(),
      }),
    )
    .optional(),
});

export const accountOptionsSchema = z.object({
  billing_auto_renew: z.boolean().optional(),
  meeting_connector_list: z.array(z.string()).optional(),
  pay_mode: z.union([z.literal('master'), z.literal('sub')]).optional(),
  room_connector_list: z.array(z.string()).optional(),
  share_mc: z.boolean().optional(),
  share_rc: z.boolean().optional(),
});

export const accountPlanSchema = z.object({
  hosts: z.number().optional(),
  type: z.string().optional(),
});

export const accountPlanBaseRequiredSchema = z.object({
  hosts: z.number(),
  type: z.string(),
});

export const accountPlanRequiredSchema = z.object({
  hosts: z.number(),
  type: z.string(),
});

export const accountPlansSchema = z.object({
  plan_audio: z
    .object({
      callout_countries: z.string().optional(),
      ddi_numbers: z.number().optional(),
      premium_countries: z.string().optional(),
      tollfree_countries: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
  plan_base: z.object({
    hosts: z.number(),
    type: z.string(),
  }),
  plan_large_meeting: z
    .array(
      z.object({
        hosts: z.number().optional(),
        type: z.string().optional(),
      }),
    )
    .optional(),
  plan_phone: z
    .object({
      plan_base: z
        .object({
          callout_countries: z.string().optional(),
          type: z.string().optional(),
        })
        .optional(),
      plan_calling: z
        .array(
          z.object({
            hosts: z.number().optional(),
            type: z.string().optional(),
          }),
        )
        .optional(),
      plan_number: z
        .array(
          z.object({
            hosts: z.number().optional(),
            type: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  plan_recording: z.string().optional(),
  plan_room_connector: z
    .object({
      hosts: z.number().optional(),
      type: z.string().optional(),
    })
    .optional(),
  plan_webinar: z
    .array(
      z.object({
        hosts: z.number().optional(),
        type: z.string().optional(),
      }),
    )
    .optional(),
  plan_zoom_rooms: z
    .object({
      hosts: z.number().optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const accountSettingsSchema = z.object({
  email_notification: z
    .object({
      alternative_host_reminder: z.boolean().optional(),
      cancel_meeting_reminder: z.boolean().optional(),
      cloud_recording_avaliable_reminder: z.boolean().optional(),
      jbh_reminder: z.boolean().optional(),
      low_host_count_reminder: z.boolean().optional(),
      schedule_for_reminder: z.boolean().optional(),
    })
    .optional(),
  feature: z
    .object({
      meeting_capacity: z.number().optional(),
    })
    .optional(),
  in_meeting: z
    .object({
      alert_guest_join: z.boolean().optional(),
      allow_live_streaming: z.boolean().optional(),
      allow_participants_to_rename: z.boolean().optional(),
      allow_show_zoom_windows: z.boolean().optional(),
      annotation: z.boolean().optional(),
      anonymous_question_answer: z.boolean().optional(),
      attendee_on_hold: z.boolean().optional(),
      auto_answer: z.boolean().optional(),
      auto_saving_chat: z.boolean().optional(),
      breakout_room: z.boolean().optional(),
      chat: z.boolean().optional(),
      closed_caption: z.boolean().optional(),
      co_host: z.boolean().optional(),
      custom_data_center_regions: z.boolean().optional(),
      custom_live_streaming_service: z.boolean().optional(),
      custom_service_instructions: z.string().optional(),
      data_center_regions: z
        .union([
          z.literal('EU'),
          z.literal('HK'),
          z.literal('AU'),
          z.literal('IN'),
          z.literal('TY'),
          z.literal('CN'),
          z.literal('US'),
          z.literal('CA'),
        ])
        .optional(),
      dscp_audio: z.number().optional(),
      dscp_marking: z.boolean().optional(),
      dscp_video: z.number().optional(),
      e2e_encryption: z.boolean().optional(),
      entry_exit_chime: z.union([z.literal('host'), z.literal('all'), z.literal('none')]).optional(),
      far_end_camera_control: z.boolean().optional(),
      feedback: z.boolean().optional(),
      file_transfer: z.boolean().optional(),
      group_hd: z.boolean().optional(),
      meeting_reactions: z.boolean().optional(),
      original_audio: z.boolean().optional(),
      p2p_connetion: z.boolean().optional(),
      p2p_ports: z.boolean().optional(),
      polling: z.boolean().optional(),
      ports_range: z.string().optional(),
      post_meeting_feedback: z.boolean().optional(),
      private_chat: z.boolean().optional(),
      record_play_own_voice: z.boolean().optional(),
      remote_control: z.boolean().optional(),
      request_permission_to_unmute: z.boolean().optional(),
      screen_sharing: z.boolean().optional(),
      sending_default_email_invites: z.boolean().optional(),
      show_a_join_from_your_browser_link: z.boolean().optional(),
      show_meeting_control_toolbar: z.boolean().optional(),
      stereo_audio: z.boolean().optional(),
      use_html_format_email: z.boolean().optional(),
      virtual_background: z.boolean().optional(),
      virtual_background_settings: z
        .object({
          allow_upload_custom: z.boolean().optional(),
          allow_videos: z.boolean().optional(),
          enable: z.boolean().optional(),
          files: z
            .array(
              z.object({
                id: z.string().optional(),
                is_default: z.boolean().optional(),
                name: z.string().optional(),
                size: z.string().optional(),
                type: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      watermark: z.boolean().optional(),
      webinar_question_answer: z.boolean().optional(),
      whiteboard: z.boolean().optional(),
      who_can_share_screen: z.union([z.literal('host'), z.literal('all')]).optional(),
      who_can_share_screen_when_someone_is_sharing: z.union([z.literal('host'), z.literal('all')]).optional(),
      workplace_by_facebook: z.boolean().optional(),
    })
    .optional(),
  integration: z
    .object({
      box: z.boolean().optional(),
      dropbox: z.boolean().optional(),
      google_calendar: z.boolean().optional(),
      google_drive: z.boolean().optional(),
      kubi: z.boolean().optional(),
      microsoft_one_drive: z.boolean().optional(),
    })
    .optional(),
  profile: z
    .object({
      recording_storage_location: z
        .object({
          allowed_values: z.array(z.string()).optional(),
          value: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  recording: z
    .object({
      account_user_access_recording: z.boolean().optional(),
      allow_recovery_deleted_cloud_recordings: z.boolean().optional(),
      archive: z
        .object({
          enable: z.boolean().optional(),
          settings: z
            .object({
              audio_file: z.boolean().optional(),
              cc_transcript_file: z.boolean().optional(),
              chat_file: z.boolean().optional(),
              chat_with_sender_email: z.boolean().optional(),
              video_file: z.boolean().optional(),
            })
            .optional(),
          type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
        })
        .optional(),
      auto_delete_cmr: z.boolean().optional(),
      auto_delete_cmr_days: z.number().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      cloud_recording: z.boolean().optional(),
      cloud_recording_download: z.boolean().optional(),
      cloud_recording_download_host: z.boolean().optional(),
      host_delete_cloud_recording: z.boolean().optional(),
      ip_address_access_control: z
        .object({
          enable: z.boolean().optional(),
          ip_addresses_or_ranges: z.string().optional(),
        })
        .optional(),
      local_recording: z.boolean().optional(),
      prevent_host_access_recording: z.boolean().optional(),
      record_audio_file: z.boolean().optional(),
      record_gallery_view: z.boolean().optional(),
      record_speaker_view: z.boolean().optional(),
      recording_audio_transcript: z.boolean().optional(),
      recording_disclaimer: z.boolean().optional(),
      recording_password_requirement: z
        .object({
          have_letter: z.boolean().optional(),
          have_number: z.boolean().optional(),
          have_special_character: z.boolean().optional(),
          length: z.number().optional(),
          only_allow_numeric: z.boolean().optional(),
        })
        .optional(),
      required_password_for_existing_cloud_recordings: z.boolean().optional(),
      save_chat_text: z.boolean().optional(),
      show_timestamp: z.boolean().optional(),
    })
    .optional(),
  schedule_meeting: z
    .object({
      audio_type: z
        .union([z.literal('both'), z.literal('telephony'), z.literal('voip'), z.literal('thirdParty')])
        .optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      enforce_login_with_domains: z.boolean().optional(),
      force_pmi_jbh_password: z.boolean().optional(),
      host_video: z.boolean().optional(),
      join_before_host: z.boolean().optional(),
      meeting_password_requirement: z
        .object({
          consecutive_characters_length: z
            .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
            .optional(),
          have_letter: z.boolean().optional(),
          have_number: z.boolean().optional(),
          have_special_character: z.boolean().optional(),
          have_upper_and_lower_characters: z.boolean().optional(),
          length: z.number().optional(),
          only_allow_numeric: z.boolean().optional(),
          weak_enhance_detection: z.boolean().optional(),
        })
        .optional(),
      not_store_meeting_topic: z.boolean().optional(),
      participant_video: z.boolean().optional(),
      personal_meeting: z.boolean().optional(),
      require_password_for_instant_meetings: z.boolean().optional(),
      require_password_for_pmi_meetings: z
        .union([z.literal('jbh_only'), z.literal('all'), z.literal('none')])
        .optional(),
      require_password_for_scheduled_meetings: z.boolean().optional(),
      require_password_for_scheduling_new_meetings: z.boolean().optional(),
      use_pmi_for_instant_meetings: z.boolean().optional(),
      use_pmi_for_scheduled_meetings: z.boolean().optional(),
    })
    .optional(),
  security: z
    .object({
      admin_change_name_pic: z.boolean().optional(),
      hide_billing_info: z.boolean().optional(),
      import_photos_from_devices: z.boolean().optional(),
      password_requirement: z
        .object({
          consecutive_characters_length: z.number().optional(),
          have_special_character: z.boolean().optional(),
          minimum_password_length: z.number().optional(),
          weak_enhance_detection: z.boolean().optional(),
        })
        .optional(),
      sign_again_period_for_inactivity_on_client: z.number().optional(),
      sign_again_period_for_inactivity_on_web: z.number().optional(),
      sign_in_with_two_factor_auth: z
        .union([z.literal('all'), z.literal('group'), z.literal('role'), z.literal('none')])
        .optional(),
      sign_in_with_two_factor_auth_groups: z.array(z.string()).optional(),
      sign_in_with_two_factor_auth_roles: z.array(z.string()).optional(),
    })
    .optional(),
  telephony: z
    .object({
      audio_conference_info: z.string().optional(),
      telephony_regions: z
        .object({
          allowed_values: z.array(z.string()).optional(),
          selection_values: z.array(z.string()).optional(),
        })
        .optional(),
      third_party_audio: z.boolean().optional(),
    })
    .optional(),
  tsp: z
    .object({
      call_out: z.boolean().optional(),
      call_out_countries: z.array(z.unknown()).optional(),
      display_toll_free_numbers: z.boolean().optional(),
      show_international_numbers_link: z.boolean().optional(),
    })
    .optional(),
  zoom_rooms: z
    .object({
      auto_start_stop_scheduled_meetings: z.boolean().optional(),
      cmr_for_instant_meeting: z.boolean().optional(),
      force_private_meeting: z.boolean().optional(),
      hide_host_information: z.boolean().optional(),
      list_meetings_with_calendar: z.boolean().optional(),
      start_airplay_manually: z.boolean().optional(),
      ultrasonic: z.boolean().optional(),
      upcoming_meeting_alert: z.boolean().optional(),
      weekly_system_restart: z.boolean().optional(),
      zr_post_meeting_feedback: z.boolean().optional(),
    })
    .optional(),
});

export const dataCenterRegionsSchema = z.union([
  z.literal('EU'),
  z.literal('HK'),
  z.literal('AU'),
  z.literal('IN'),
  z.literal('TY'),
  z.literal('CN'),
  z.literal('US'),
  z.literal('CA'),
]);

export const entryExitChimeSchema = z.union([z.literal('host'), z.literal('all'), z.literal('none')]);

export const whoCanShareScreenSchema = z.union([z.literal('host'), z.literal('all')]);

export const whoCanShareScreenWhenSomeoneIsSharingSchema = z.union([z.literal('host'), z.literal('all')]);

export const typeSchema = z.union([z.literal(1), z.literal(2), z.literal(3)]);

export const autoRecordingSchema = z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]);

export const audioTypeSchema = z.union([
  z.literal('both'),
  z.literal('telephony'),
  z.literal('voip'),
  z.literal('thirdParty'),
]);

export const consecutiveCharactersLengthSchema = z.union([
  z.literal(0),
  z.literal(4),
  z.literal(5),
  z.literal(6),
  z.literal(7),
  z.literal(8),
]);

export const requirePasswordForPmiMeetingsSchema = z.union([
  z.literal('jbh_only'),
  z.literal('all'),
  z.literal('none'),
]);

export const signInWithTwoFactorAuthSchema = z.union([
  z.literal('all'),
  z.literal('group'),
  z.literal('role'),
  z.literal('none'),
]);

export const accountSettingsAuthenticationSchema = z.union([
  z.object({
    authentication_options: z
      .array(
        z.object({
          default_option: z.boolean().optional(),
          domains: z.string().optional(),
          id: z.string().optional(),
          name: z.string().optional(),
          type: z
            .union([
              z.literal('enforce_login'),
              z.literal('enforce_login_with_same_account'),
              z.literal('enforce_login_with_domains'),
            ])
            .optional(),
          visible: z.boolean().optional(),
        }),
      )
      .optional(),
    meeting_authentication: z.boolean().optional(),
  }),
  z.object({
    authentication_options: z
      .array(
        z.object({
          default_option: z.boolean().optional(),
          domains: z.string().optional(),
          id: z.string().optional(),
          name: z.string().optional(),
          type: z
            .union([z.literal('internally'), z.literal('enforce_login'), z.literal('enforce_login_with_domains')])
            .optional(),
          visible: z.boolean().optional(),
        }),
      )
      .optional(),
    recording_authentication: z.boolean().optional(),
  }),
]);

export const accountSettingsAuthenticationUpdateSchema = z.union([
  z.object({
    authentication_option: z
      .object({
        action: z.union([z.literal('update'), z.literal('delete'), z.literal('add')]).optional(),
        default_option: z.boolean().optional(),
        domains: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        type: z
          .union([
            z.literal('enforce_login'),
            z.literal('enforce_login_with_same_account'),
            z.literal('enforce_login_with_domains'),
          ])
          .optional(),
      })
      .optional(),
    meeting_authentication: z.boolean().optional(),
  }),
  z.object({
    authentication_option: z
      .object({
        action: z.union([z.literal('update'), z.literal('delete'), z.literal('add')]).optional(),
        default_option: z.boolean().optional(),
        domains: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        type: z
          .union([z.literal('internally'), z.literal('enforce_login'), z.literal('enforce_login_with_domains')])
          .optional(),
      })
      .optional(),
    recording_authentication: z.boolean().optional(),
  }),
]);

export const actionSchema = z.union([z.literal('update'), z.literal('delete'), z.literal('add')]);

export const type2Schema = z.union([
  z.literal('enforce_login'),
  z.literal('enforce_login_with_same_account'),
  z.literal('enforce_login_with_domains'),
]);

export const accountSettingsEmailNotificationSchema = z.object({
  alternative_host_reminder: z.boolean().optional(),
  cancel_meeting_reminder: z.boolean().optional(),
  cloud_recording_avaliable_reminder: z.boolean().optional(),
  jbh_reminder: z.boolean().optional(),
  low_host_count_reminder: z.boolean().optional(),
  schedule_for_reminder: z.boolean().optional(),
});

export const accountSettingsFeatureSchema = z.object({
  meeting_capacity: z.number().optional(),
});

export const accountSettingsInMeetingSchema = z.object({
  alert_guest_join: z.boolean().optional(),
  allow_live_streaming: z.boolean().optional(),
  allow_participants_to_rename: z.boolean().optional(),
  allow_show_zoom_windows: z.boolean().optional(),
  annotation: z.boolean().optional(),
  anonymous_question_answer: z.boolean().optional(),
  attendee_on_hold: z.boolean().optional(),
  auto_answer: z.boolean().optional(),
  auto_saving_chat: z.boolean().optional(),
  breakout_room: z.boolean().optional(),
  chat: z.boolean().optional(),
  closed_caption: z.boolean().optional(),
  co_host: z.boolean().optional(),
  custom_data_center_regions: z.boolean().optional(),
  custom_live_streaming_service: z.boolean().optional(),
  custom_service_instructions: z.string().optional(),
  data_center_regions: z
    .union([
      z.literal('EU'),
      z.literal('HK'),
      z.literal('AU'),
      z.literal('IN'),
      z.literal('TY'),
      z.literal('CN'),
      z.literal('US'),
      z.literal('CA'),
    ])
    .optional(),
  dscp_audio: z.number().optional(),
  dscp_marking: z.boolean().optional(),
  dscp_video: z.number().optional(),
  e2e_encryption: z.boolean().optional(),
  entry_exit_chime: z.union([z.literal('host'), z.literal('all'), z.literal('none')]).optional(),
  far_end_camera_control: z.boolean().optional(),
  feedback: z.boolean().optional(),
  file_transfer: z.boolean().optional(),
  group_hd: z.boolean().optional(),
  meeting_reactions: z.boolean().optional(),
  original_audio: z.boolean().optional(),
  p2p_connetion: z.boolean().optional(),
  p2p_ports: z.boolean().optional(),
  polling: z.boolean().optional(),
  ports_range: z.string().optional(),
  post_meeting_feedback: z.boolean().optional(),
  private_chat: z.boolean().optional(),
  record_play_own_voice: z.boolean().optional(),
  remote_control: z.boolean().optional(),
  request_permission_to_unmute: z.boolean().optional(),
  screen_sharing: z.boolean().optional(),
  sending_default_email_invites: z.boolean().optional(),
  show_a_join_from_your_browser_link: z.boolean().optional(),
  show_meeting_control_toolbar: z.boolean().optional(),
  stereo_audio: z.boolean().optional(),
  use_html_format_email: z.boolean().optional(),
  virtual_background: z.boolean().optional(),
  virtual_background_settings: z
    .object({
      allow_upload_custom: z.boolean().optional(),
      allow_videos: z.boolean().optional(),
      enable: z.boolean().optional(),
      files: z
        .array(
          z.object({
            id: z.string().optional(),
            is_default: z.boolean().optional(),
            name: z.string().optional(),
            size: z.string().optional(),
            type: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  watermark: z.boolean().optional(),
  webinar_question_answer: z.boolean().optional(),
  whiteboard: z.boolean().optional(),
  who_can_share_screen: z.union([z.literal('host'), z.literal('all')]).optional(),
  who_can_share_screen_when_someone_is_sharing: z.union([z.literal('host'), z.literal('all')]).optional(),
  workplace_by_facebook: z.boolean().optional(),
});

export const accountSettingsIntegrationSchema = z.object({
  box: z.boolean().optional(),
  dropbox: z.boolean().optional(),
  google_calendar: z.boolean().optional(),
  google_drive: z.boolean().optional(),
  kubi: z.boolean().optional(),
  microsoft_one_drive: z.boolean().optional(),
});

export const accountSettingsRecordingSchema = z.object({
  account_user_access_recording: z.boolean().optional(),
  allow_recovery_deleted_cloud_recordings: z.boolean().optional(),
  archive: z
    .object({
      enable: z.boolean().optional(),
      settings: z
        .object({
          audio_file: z.boolean().optional(),
          cc_transcript_file: z.boolean().optional(),
          chat_file: z.boolean().optional(),
          chat_with_sender_email: z.boolean().optional(),
          video_file: z.boolean().optional(),
        })
        .optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
    })
    .optional(),
  auto_delete_cmr: z.boolean().optional(),
  auto_delete_cmr_days: z.number().optional(),
  auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
  cloud_recording: z.boolean().optional(),
  cloud_recording_download: z.boolean().optional(),
  cloud_recording_download_host: z.boolean().optional(),
  host_delete_cloud_recording: z.boolean().optional(),
  ip_address_access_control: z
    .object({
      enable: z.boolean().optional(),
      ip_addresses_or_ranges: z.string().optional(),
    })
    .optional(),
  local_recording: z.boolean().optional(),
  prevent_host_access_recording: z.boolean().optional(),
  record_audio_file: z.boolean().optional(),
  record_gallery_view: z.boolean().optional(),
  record_speaker_view: z.boolean().optional(),
  recording_audio_transcript: z.boolean().optional(),
  recording_disclaimer: z.boolean().optional(),
  recording_password_requirement: z
    .object({
      have_letter: z.boolean().optional(),
      have_number: z.boolean().optional(),
      have_special_character: z.boolean().optional(),
      length: z.number().optional(),
      only_allow_numeric: z.boolean().optional(),
    })
    .optional(),
  required_password_for_existing_cloud_recordings: z.boolean().optional(),
  save_chat_text: z.boolean().optional(),
  show_timestamp: z.boolean().optional(),
});

export const accountSettingsRecordingAuthenticationUpdateSchema = z.object({
  authentication_option: z
    .object({
      action: z.union([z.literal('update'), z.literal('add'), z.literal('delete')]).optional(),
      default_option: z.boolean().optional(),
      domains: z.string().optional(),
      id: z.string().optional(),
      name: z.string().optional(),
      type: z
        .union([z.literal('internally'), z.literal('enforce_login'), z.literal('enforce_login_with_domains')])
        .optional(),
    })
    .optional(),
  recording_authentication: z.boolean().optional(),
});

export const type3Schema = z.union([
  z.literal('internally'),
  z.literal('enforce_login'),
  z.literal('enforce_login_with_domains'),
]);

export const accountSettingsScheduleMeetingSchema = z.object({
  audio_type: z
    .union([z.literal('both'), z.literal('telephony'), z.literal('voip'), z.literal('thirdParty')])
    .optional(),
  enforce_login: z.boolean().optional(),
  enforce_login_domains: z.string().optional(),
  enforce_login_with_domains: z.boolean().optional(),
  force_pmi_jbh_password: z.boolean().optional(),
  host_video: z.boolean().optional(),
  join_before_host: z.boolean().optional(),
  meeting_password_requirement: z
    .object({
      consecutive_characters_length: z
        .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
        .optional(),
      have_letter: z.boolean().optional(),
      have_number: z.boolean().optional(),
      have_special_character: z.boolean().optional(),
      have_upper_and_lower_characters: z.boolean().optional(),
      length: z.number().optional(),
      only_allow_numeric: z.boolean().optional(),
      weak_enhance_detection: z.boolean().optional(),
    })
    .optional(),
  not_store_meeting_topic: z.boolean().optional(),
  participant_video: z.boolean().optional(),
  personal_meeting: z.boolean().optional(),
  require_password_for_instant_meetings: z.boolean().optional(),
  require_password_for_pmi_meetings: z.union([z.literal('jbh_only'), z.literal('all'), z.literal('none')]).optional(),
  require_password_for_scheduled_meetings: z.boolean().optional(),
  require_password_for_scheduling_new_meetings: z.boolean().optional(),
  use_pmi_for_instant_meetings: z.boolean().optional(),
  use_pmi_for_scheduled_meetings: z.boolean().optional(),
});

export const accountSettingsSecuritySchema = z.object({
  admin_change_name_pic: z.boolean().optional(),
  hide_billing_info: z.boolean().optional(),
  import_photos_from_devices: z.boolean().optional(),
  password_requirement: z
    .object({
      consecutive_characters_length: z.number().optional(),
      have_special_character: z.boolean().optional(),
      minimum_password_length: z.number().optional(),
      weak_enhance_detection: z.boolean().optional(),
    })
    .optional(),
  sign_again_period_for_inactivity_on_client: z.number().optional(),
  sign_again_period_for_inactivity_on_web: z.number().optional(),
  sign_in_with_two_factor_auth: z
    .union([z.literal('all'), z.literal('group'), z.literal('role'), z.literal('none')])
    .optional(),
  sign_in_with_two_factor_auth_groups: z.array(z.string()).optional(),
  sign_in_with_two_factor_auth_roles: z.array(z.string()).optional(),
});

export const accountSettingsTSPSchema = z.object({
  call_out: z.boolean().optional(),
  call_out_countries: z.array(z.unknown()).optional(),
  display_toll_free_numbers: z.boolean().optional(),
  show_international_numbers_link: z.boolean().optional(),
});

export const accountSettingsTelephonySchema = z.object({
  audio_conference_info: z.string().optional(),
  telephony_regions: z
    .object({
      allowed_values: z.array(z.string()).optional(),
      selection_values: z.array(z.string()).optional(),
    })
    .optional(),
  third_party_audio: z.boolean().optional(),
});

export const accountSettingsUpdateTelephonySchema = z.object({
  audio_conference_info: z.string().optional(),
  telephony_regions: z
    .object({
      selection_values: z.array(z.string()).optional(),
    })
    .optional(),
  third_party_audio: z.boolean().optional(),
});

export const accountSettingsZoomRoomsSchema = z.object({
  auto_start_stop_scheduled_meetings: z.boolean().optional(),
  cmr_for_instant_meeting: z.boolean().optional(),
  force_private_meeting: z.boolean().optional(),
  hide_host_information: z.boolean().optional(),
  list_meetings_with_calendar: z.boolean().optional(),
  start_airplay_manually: z.boolean().optional(),
  ultrasonic: z.boolean().optional(),
  upcoming_meeting_alert: z.boolean().optional(),
  weekly_system_restart: z.boolean().optional(),
  zr_post_meeting_feedback: z.boolean().optional(),
});

export const accountUpdateSettingsSchema = z.object({
  email_notification: z
    .object({
      alternative_host_reminder: z.boolean().optional(),
      cancel_meeting_reminder: z.boolean().optional(),
      cloud_recording_avaliable_reminder: z.boolean().optional(),
      jbh_reminder: z.boolean().optional(),
      low_host_count_reminder: z.boolean().optional(),
      schedule_for_reminder: z.boolean().optional(),
    })
    .optional(),
  feature: z
    .object({
      meeting_capacity: z.number().optional(),
    })
    .optional(),
  in_meeting: z
    .object({
      alert_guest_join: z.boolean().optional(),
      allow_live_streaming: z.boolean().optional(),
      allow_participants_to_rename: z.boolean().optional(),
      allow_show_zoom_windows: z.boolean().optional(),
      annotation: z.boolean().optional(),
      anonymous_question_answer: z.boolean().optional(),
      attendee_on_hold: z.boolean().optional(),
      auto_answer: z.boolean().optional(),
      auto_saving_chat: z.boolean().optional(),
      breakout_room: z.boolean().optional(),
      chat: z.boolean().optional(),
      closed_caption: z.boolean().optional(),
      co_host: z.boolean().optional(),
      custom_data_center_regions: z.boolean().optional(),
      custom_live_streaming_service: z.boolean().optional(),
      custom_service_instructions: z.string().optional(),
      data_center_regions: z
        .union([
          z.literal('EU'),
          z.literal('HK'),
          z.literal('AU'),
          z.literal('IN'),
          z.literal('TY'),
          z.literal('CN'),
          z.literal('US'),
          z.literal('CA'),
        ])
        .optional(),
      dscp_audio: z.number().optional(),
      dscp_marking: z.boolean().optional(),
      dscp_video: z.number().optional(),
      e2e_encryption: z.boolean().optional(),
      entry_exit_chime: z.union([z.literal('host'), z.literal('all'), z.literal('none')]).optional(),
      far_end_camera_control: z.boolean().optional(),
      feedback: z.boolean().optional(),
      file_transfer: z.boolean().optional(),
      group_hd: z.boolean().optional(),
      meeting_reactions: z.boolean().optional(),
      original_audio: z.boolean().optional(),
      p2p_connetion: z.boolean().optional(),
      p2p_ports: z.boolean().optional(),
      polling: z.boolean().optional(),
      ports_range: z.string().optional(),
      post_meeting_feedback: z.boolean().optional(),
      private_chat: z.boolean().optional(),
      record_play_own_voice: z.boolean().optional(),
      remote_control: z.boolean().optional(),
      request_permission_to_unmute: z.boolean().optional(),
      screen_sharing: z.boolean().optional(),
      sending_default_email_invites: z.boolean().optional(),
      show_a_join_from_your_browser_link: z.boolean().optional(),
      show_meeting_control_toolbar: z.boolean().optional(),
      stereo_audio: z.boolean().optional(),
      use_html_format_email: z.boolean().optional(),
      virtual_background: z.boolean().optional(),
      virtual_background_settings: z
        .object({
          allow_upload_custom: z.boolean().optional(),
          allow_videos: z.boolean().optional(),
          enable: z.boolean().optional(),
          files: z
            .array(
              z.object({
                id: z.string().optional(),
                is_default: z.boolean().optional(),
                name: z.string().optional(),
                size: z.string().optional(),
                type: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      watermark: z.boolean().optional(),
      webinar_question_answer: z.boolean().optional(),
      whiteboard: z.boolean().optional(),
      who_can_share_screen: z.union([z.literal('host'), z.literal('all')]).optional(),
      who_can_share_screen_when_someone_is_sharing: z.union([z.literal('host'), z.literal('all')]).optional(),
      workplace_by_facebook: z.boolean().optional(),
    })
    .optional(),
  integration: z
    .object({
      box: z.boolean().optional(),
      dropbox: z.boolean().optional(),
      google_calendar: z.boolean().optional(),
      google_drive: z.boolean().optional(),
      kubi: z.boolean().optional(),
      microsoft_one_drive: z.boolean().optional(),
    })
    .optional(),
  profile: z
    .object({
      recording_storage_location: z
        .object({
          allowed_values: z.array(z.string()).optional(),
          value: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  recording: z
    .object({
      account_user_access_recording: z.boolean().optional(),
      allow_recovery_deleted_cloud_recordings: z.boolean().optional(),
      archive: z
        .object({
          enable: z.boolean().optional(),
          settings: z
            .object({
              audio_file: z.boolean().optional(),
              cc_transcript_file: z.boolean().optional(),
              chat_file: z.boolean().optional(),
              chat_with_sender_email: z.boolean().optional(),
              video_file: z.boolean().optional(),
            })
            .optional(),
          type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
        })
        .optional(),
      auto_delete_cmr: z.boolean().optional(),
      auto_delete_cmr_days: z.number().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      cloud_recording: z.boolean().optional(),
      cloud_recording_download: z.boolean().optional(),
      cloud_recording_download_host: z.boolean().optional(),
      host_delete_cloud_recording: z.boolean().optional(),
      ip_address_access_control: z
        .object({
          enable: z.boolean().optional(),
          ip_addresses_or_ranges: z.string().optional(),
        })
        .optional(),
      local_recording: z.boolean().optional(),
      prevent_host_access_recording: z.boolean().optional(),
      record_audio_file: z.boolean().optional(),
      record_gallery_view: z.boolean().optional(),
      record_speaker_view: z.boolean().optional(),
      recording_audio_transcript: z.boolean().optional(),
      recording_disclaimer: z.boolean().optional(),
      recording_password_requirement: z
        .object({
          have_letter: z.boolean().optional(),
          have_number: z.boolean().optional(),
          have_special_character: z.boolean().optional(),
          length: z.number().optional(),
          only_allow_numeric: z.boolean().optional(),
        })
        .optional(),
      required_password_for_existing_cloud_recordings: z.boolean().optional(),
      save_chat_text: z.boolean().optional(),
      show_timestamp: z.boolean().optional(),
    })
    .optional(),
  schedule_meeting: z
    .object({
      audio_type: z
        .union([z.literal('both'), z.literal('telephony'), z.literal('voip'), z.literal('thirdParty')])
        .optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      enforce_login_with_domains: z.boolean().optional(),
      force_pmi_jbh_password: z.boolean().optional(),
      host_video: z.boolean().optional(),
      join_before_host: z.boolean().optional(),
      meeting_password_requirement: z
        .object({
          consecutive_characters_length: z
            .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
            .optional(),
          have_letter: z.boolean().optional(),
          have_number: z.boolean().optional(),
          have_special_character: z.boolean().optional(),
          have_upper_and_lower_characters: z.boolean().optional(),
          length: z.number().optional(),
          only_allow_numeric: z.boolean().optional(),
          weak_enhance_detection: z.boolean().optional(),
        })
        .optional(),
      not_store_meeting_topic: z.boolean().optional(),
      participant_video: z.boolean().optional(),
      personal_meeting: z.boolean().optional(),
      require_password_for_instant_meetings: z.boolean().optional(),
      require_password_for_pmi_meetings: z
        .union([z.literal('jbh_only'), z.literal('all'), z.literal('none')])
        .optional(),
      require_password_for_scheduled_meetings: z.boolean().optional(),
      require_password_for_scheduling_new_meetings: z.boolean().optional(),
      use_pmi_for_instant_meetings: z.boolean().optional(),
      use_pmi_for_scheduled_meetings: z.boolean().optional(),
    })
    .optional(),
  security: z
    .object({
      admin_change_name_pic: z.boolean().optional(),
      hide_billing_info: z.boolean().optional(),
      import_photos_from_devices: z.boolean().optional(),
      password_requirement: z
        .object({
          consecutive_characters_length: z.number().optional(),
          have_special_character: z.boolean().optional(),
          minimum_password_length: z.number().optional(),
          weak_enhance_detection: z.boolean().optional(),
        })
        .optional(),
      sign_again_period_for_inactivity_on_client: z.number().optional(),
      sign_again_period_for_inactivity_on_web: z.number().optional(),
      sign_in_with_two_factor_auth: z
        .union([z.literal('all'), z.literal('group'), z.literal('role'), z.literal('none')])
        .optional(),
      sign_in_with_two_factor_auth_groups: z.array(z.string()).optional(),
      sign_in_with_two_factor_auth_roles: z.array(z.string()).optional(),
    })
    .optional(),
  telephony: z
    .object({
      audio_conference_info: z.string().optional(),
      telephony_regions: z
        .object({
          selection_values: z.array(z.string()).optional(),
        })
        .optional(),
      third_party_audio: z.boolean().optional(),
    })
    .optional(),
  tsp: z
    .object({
      call_out: z.boolean().optional(),
      call_out_countries: z.array(z.unknown()).optional(),
      display_toll_free_numbers: z.boolean().optional(),
      show_international_numbers_link: z.boolean().optional(),
    })
    .optional(),
  zoom_rooms: z
    .object({
      auto_start_stop_scheduled_meetings: z.boolean().optional(),
      cmr_for_instant_meeting: z.boolean().optional(),
      force_private_meeting: z.boolean().optional(),
      hide_host_information: z.boolean().optional(),
      list_meetings_with_calendar: z.boolean().optional(),
      start_airplay_manually: z.boolean().optional(),
      ultrasonic: z.boolean().optional(),
      upcoming_meeting_alert: z.boolean().optional(),
      weekly_system_restart: z.boolean().optional(),
      zr_post_meeting_feedback: z.boolean().optional(),
    })
    .optional(),
});

export const billingContactSchema = z.object({
  address: z.string().optional(),
  apt: z.string().optional(),
  city: z.string().optional(),
  country: z.string().optional(),
  email: z.string().optional(),
  first_name: z.string().optional(),
  last_name: z.string().optional(),
  phone_number: z.string().optional(),
  state: z.string().optional(),
  zip: z.string().optional(),
});

export const billingContactRequiredSchema = z.object({
  address: z.string(),
  apt: z.string().optional(),
  city: z.string(),
  country: z.string(),
  email: z.string(),
  first_name: z.string(),
  last_name: z.string(),
  phone_number: z.string(),
  state: z.string(),
  zip: z.string(),
});

export const channelSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
});

export const cloudArchivedFilesSchema = z.object({
  archive_files: z.array(
    z.object({
      download_url: z.string(),
      file_extension: z.string(),
      file_size: z.number(),
      file_type: z.string(),
      id: z.string(),
      recording_type: z.string(),
      status: z.string(),
    }),
  ),
  duration: z.number(),
  host_id: z.string(),
  id: z.number(),
  recording_count: z.number(),
  start_time: z.string(),
  timezone: z.string(),
  topic: z.string(),
  total_size: z.number(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]),
  uuid: z.string(),
});

export const type4Schema = z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]);

export const createWebinarSettingsSchema = z.object({
  allow_multiple_devices: z.boolean().optional(),
  alternative_hosts: z.string().optional(),
  approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
  attendees_and_panelists_reminder_email_notification: z
    .object({
      enable: z.boolean().optional(),
      type: z
        .union([
          z.literal(0),
          z.literal(1),
          z.literal(2),
          z.literal(3),
          z.literal(4),
          z.literal(5),
          z.literal(6),
          z.literal(7),
        ])
        .optional(),
    })
    .optional(),
  audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
  authentication_domains: z.string().optional(),
  authentication_option: z.string().optional(),
  auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
  close_registration: z.boolean().optional(),
  contact_email: z.string().optional(),
  contact_name: z.string().optional(),
  email_language: z.string().optional(),
  enforce_login: z.boolean().optional(),
  enforce_login_domains: z.string().optional(),
  follow_up_absentees_email_notification: z
    .object({
      enable: z.boolean().optional(),
      type: z
        .union([
          z.literal(0),
          z.literal(1),
          z.literal(2),
          z.literal(3),
          z.literal(4),
          z.literal(5),
          z.literal(6),
          z.literal(7),
        ])
        .optional(),
    })
    .optional(),
  follow_up_attendees_email_notification: z
    .object({
      enable: z.boolean().optional(),
      type: z
        .union([
          z.literal(0),
          z.literal(1),
          z.literal(2),
          z.literal(3),
          z.literal(4),
          z.literal(5),
          z.literal(6),
          z.literal(7),
        ])
        .optional(),
    })
    .optional(),
  global_dial_in_countries: z.array(z.string()).optional(),
  hd_video: z.boolean().optional(),
  host_video: z.boolean().optional(),
  meeting_authentication: z.boolean().optional(),
  on_demand: z.boolean().optional(),
  panelists_invitation_email_notification: z.boolean().optional(),
  panelists_video: z.boolean().optional(),
  post_webinar_survey: z.boolean().optional(),
  practice_session: z.boolean().optional(),
  question_and_answer: z
    .object({
      allow_anonymous_questions: z.boolean().optional(),
      answer_questions: z.union([z.literal('only'), z.literal('all')]).optional(),
      attendees_can_comment: z.boolean().optional(),
      attendees_can_upvote: z.boolean().optional(),
      enable: z.boolean().optional(),
    })
    .optional(),
  registrants_email_notification: z.boolean().optional(),
  registrants_restrict_number: z.number().optional(),
  registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
  show_share_button: z.boolean().optional(),
  survey_url: z.string().optional(),
});

export const approvalTypeSchema = z.union([z.literal(0), z.literal(1), z.literal(2)]);

export const type5Schema = z.union([
  z.literal(0),
  z.literal(1),
  z.literal(2),
  z.literal(3),
  z.literal(4),
  z.literal(5),
  z.literal(6),
  z.literal(7),
]);

export const audioSchema = z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]);

export const answerQuestionsSchema = z.union([z.literal('only'), z.literal('all')]);

export const registrationTypeSchema = z.union([z.literal(1), z.literal(2), z.literal(3)]);

export const customQuestionSchema = z.object({
  title: z.string().optional(),
  value: z.string().optional(),
});

export const dateTimeSchema = z.object({
  from: z.string().optional(),
  to: z.string().optional(),
});

export const deviceSchema = z.object({
  encryption: z.union([z.literal('auto'), z.literal('yes'), z.literal('no')]),
  ip: z.string(),
  name: z.string(),
  protocol: z.union([z.literal('H.323'), z.literal('SIP')]),
});

export const encryptionSchema = z.union([z.literal('auto'), z.literal('yes'), z.literal('no')]);

export const protocolSchema = z.union([z.literal('H.323'), z.literal('SIP')]);

export const deviceListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      devices: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z.object({
                encryption: z.union([z.literal('auto'), z.literal('yes'), z.literal('no')]),
                ip: z.string(),
                name: z.string(),
                protocol: z.union([z.literal('H.323'), z.literal('SIP')]),
              }),
            ),
        )
        .optional(),
    }),
  );

export const domainsListSchema = z.object({
  domains: z
    .array(
      z.object({
        domain: z.string().optional(),
        status: z.string().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const groupSchema = z.object({
  name: z.string().optional(),
  total_members: z.number().optional(),
});

export const groupListSchema = z.object({
  groups: z
    .array(
      z
        .object({
          id: z.string().optional(),
        })
        .and(
          z.object({
            name: z.string().optional(),
            total_members: z.number().optional(),
          }),
        ),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const groupMemberSchema = z.object({
  email: z.string().optional(),
  first_name: z.string().optional(),
  id: z.string().optional(),
  last_name: z.string().optional(),
  type: z.number().optional(),
});

export const groupMemberListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      members: z
        .array(
          z.object({
            email: z.string().optional(),
            first_name: z.string().optional(),
            id: z.string().optional(),
            last_name: z.string().optional(),
            type: z.number().optional(),
          }),
        )
        .optional(),
    }),
  );

export const groupUserSettingsAuthenticationSchema = z.union([
  z.object({
    authentication_options: z
      .array(
        z.object({
          default_option: z.boolean().optional(),
          domains: z.string().optional(),
          id: z.string().optional(),
          name: z.string().optional(),
          type: z
            .union([
              z.literal('enforce_login'),
              z.literal('enforce_login_with_same_account'),
              z.literal('enforce_login_with_domains'),
            ])
            .optional(),
          visible: z.boolean().optional(),
        }),
      )
      .optional(),
    meeting_authentication: z.boolean().optional(),
  }),
  z.object({
    authentication_options: z
      .array(
        z.object({
          default_option: z.boolean().optional(),
          domains: z.string().optional(),
          id: z.string().optional(),
          name: z.string().optional(),
          type: z
            .union([z.literal('internally'), z.literal('enforce_login'), z.literal('enforce_login_with_domains')])
            .optional(),
          visible: z.boolean().optional(),
        }),
      )
      .optional(),
    recording_authentication: z.boolean().optional(),
  }),
]);

export const groupUserSettingsAuthenticationUpdateSchema = z.union([
  z.object({
    authentication_option: z
      .object({
        action: z.union([z.literal('update'), z.literal('show'), z.literal('hide')]).optional(),
        default_option: z.boolean().optional(),
        domains: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        type: z
          .union([
            z.literal('enforce_login'),
            z.literal('enforce_login_with_same_account'),
            z.literal('enforce_login_with_domains'),
          ])
          .optional(),
      })
      .optional(),
    meeting_authentication: z.boolean().optional(),
  }),
  z.object({
    authentication_option: z
      .object({
        action: z.union([z.literal('update'), z.literal('show'), z.literal('hide')]).optional(),
        default_option: z.boolean().optional(),
        domians: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        type: z
          .union([z.literal('internally'), z.literal('enforce_login'), z.literal('enforce_login_with_domains')])
          .optional(),
      })
      .optional(),
    recording_authentication: z.boolean().optional(),
  }),
]);

export const action2Schema = z.union([z.literal('update'), z.literal('show'), z.literal('hide')]);

export const iMGroupSchema = z
  .object({
    name: z.string().optional(),
    total_members: z.number().optional(),
  })
  .and(
    z.object({
      search_by_account: z.boolean().optional(),
      search_by_domain: z.boolean().optional(),
      search_by_ma_account: z.boolean().optional(),
      type: z.union([z.literal('normal'), z.literal('shared'), z.literal('restricted')]).optional(),
    }),
  );

export const type6Schema = z.union([z.literal('normal'), z.literal('shared'), z.literal('restricted')]);

export const iMGroupListSchema = z
  .object({
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      groups: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z
                .object({
                  name: z.string().optional(),
                  total_members: z.number().optional(),
                })
                .and(
                  z.object({
                    search_by_account: z.boolean().optional(),
                    search_by_domain: z.boolean().optional(),
                    search_by_ma_account: z.boolean().optional(),
                    type: z.union([z.literal('normal'), z.literal('shared'), z.literal('restricted')]).optional(),
                  }),
                ),
            ),
        )
        .optional(),
    }),
  );

export const meetingSchema = z.object({
  agenda: z.string().optional(),
  duration: z.number().optional(),
  password: z.string().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z
        .union([
          z.literal('1'),
          z.literal('2'),
          z.literal('3'),
          z.literal('4'),
          z.literal('5'),
          z.literal('6'),
          z.literal('7'),
        ])
        .optional(),
    })
    .optional(),
  settings: z
    .object({
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      alternative_hosts_email_notification: z.boolean().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      approved_or_denied_countries_or_regions: z
        .object({
          approved_list: z.array(z.string()).optional(),
          denied_list: z.array(z.string()).optional(),
          enable: z.boolean().optional(),
          method: z.union([z.literal('approve'), z.literal('deny')]).optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_exception: z
        .array(
          z.object({
            email: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .optional(),
      authentication_name: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      breakout_room: z
        .object({
          enable: z.boolean().optional(),
          rooms: z
            .array(
              z.object({
                name: z.string().optional(),
                participants: z.array(z.string()).optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      close_registration: z.boolean().optional(),
      cn_meeting: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      custom_keys: z
        .array(
          z.object({
            key: z.string().optional(),
            value: z.string().optional(),
          }),
        )
        .optional(),
      encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      global_dial_in_numbers: z
        .array(
          z.object({
            city: z.string().optional(),
            country: z.string().optional(),
            country_name: z.string().optional(),
            number: z.string().optional(),
            type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
          }),
        )
        .optional(),
      host_video: z.boolean().optional(),
      in_meeting: z.boolean().optional(),
      jbh_time: z.union([z.literal(0), z.literal(5), z.literal(10)]).optional(),
      join_before_host: z.boolean().optional(),
      language_interpretation: z
        .object({
          enable: z.boolean().optional(),
          interpreters: z
            .array(
              z.object({
                email: z.string().optional(),
                languages: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      meeting_authentication: z.boolean().optional(),
      mute_upon_entry: z.boolean().optional(),
      participant_video: z.boolean().optional(),
      registrants_confirmation_email: z.boolean().optional(),
      registrants_email_notification: z.boolean().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      use_pmi: z.boolean().optional(),
      waiting_room: z.boolean().optional(),
      watermark: z.boolean().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
});

export const monthlyWeekSchema = z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]);

export const monthlyWeekDaySchema = z.union([
  z.literal(1),
  z.literal(2),
  z.literal(3),
  z.literal(4),
  z.literal(5),
  z.literal(6),
  z.literal(7),
]);

export const weeklyDaysSchema = z.union([
  z.literal('1'),
  z.literal('2'),
  z.literal('3'),
  z.literal('4'),
  z.literal('5'),
  z.literal('6'),
  z.literal('7'),
]);

export const methodSchema = z.union([z.literal('approve'), z.literal('deny')]);

export const encryptionTypeSchema = z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]);

export const jbhTimeSchema = z.union([z.literal(0), z.literal(5), z.literal(10)]);

export const meetingCreateSchema = z.object({
  agenda: z.string().optional(),
  duration: z.number().optional(),
  password: z.string().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z
        .union([
          z.literal('1'),
          z.literal('2'),
          z.literal('3'),
          z.literal('4'),
          z.literal('5'),
          z.literal('6'),
          z.literal('7'),
        ])
        .optional(),
    })
    .optional(),
  schedule_for: z.string().optional(),
  settings: z
    .object({
      additional_data_center_regions: z.array(z.string()).optional(),
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      alternative_hosts_email_notification: z.boolean().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      approved_or_denied_countries_or_regions: z
        .object({
          approved_list: z.array(z.string()).optional(),
          denied_list: z.array(z.string()).optional(),
          enable: z.boolean().optional(),
          method: z.union([z.literal('approve'), z.literal('deny')]).optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      breakout_room: z
        .object({
          enable: z.boolean().optional(),
          rooms: z
            .array(
              z.object({
                name: z.string().optional(),
                participants: z.array(z.string()).optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      close_registration: z.boolean().optional(),
      cn_meeting: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      host_video: z.boolean().optional(),
      in_meeting: z.boolean().optional(),
      jbh_time: z.union([z.literal(0), z.literal(5), z.literal(10)]).optional(),
      join_before_host: z.boolean().optional(),
      language_interpretation: z
        .object({
          enable: z.boolean().optional(),
          interpreters: z
            .array(
              z.object({
                email: z.string().optional(),
                languages: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      meeting_authentication: z.boolean().optional(),
      mute_upon_entry: z.boolean().optional(),
      participant_video: z.boolean().optional(),
      registrants_email_notification: z.boolean().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      use_pmi: z.boolean().optional(),
      waiting_room: z.boolean().optional(),
      watermark: z.boolean().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  template_id: z.string().optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
});

export const meetingInfoSchema = z.object({
  agenda: z.string().optional(),
  created_at: z.string().optional(),
  duration: z.number().optional(),
  h323_password: z.string().optional(),
  join_url: z.string().optional(),
  occurrences: z
    .array(
      z.object({
        duration: z.number().optional(),
        occurrence_id: z.string().optional(),
        start_time: z.string().optional(),
        status: z.string().optional(),
      }),
    )
    .optional(),
  password: z.string().optional(),
  pmi: z.number().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z
        .union([
          z.literal('1'),
          z.literal('2'),
          z.literal('3'),
          z.literal('4'),
          z.literal('5'),
          z.literal('6'),
          z.literal('7'),
        ])
        .optional(),
    })
    .optional(),
  settings: z
    .object({
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      alternative_hosts_email_notification: z.boolean().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      approved_or_denied_countries_or_regions: z
        .object({
          approved_list: z.array(z.string()).optional(),
          denied_list: z.array(z.string()).optional(),
          enable: z.boolean().optional(),
          method: z.union([z.literal('approve'), z.literal('deny')]).optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_exception: z
        .array(
          z.object({
            email: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .optional(),
      authentication_name: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      breakout_room: z
        .object({
          enable: z.boolean().optional(),
          rooms: z
            .array(
              z.object({
                name: z.string().optional(),
                participants: z.array(z.string()).optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      close_registration: z.boolean().optional(),
      cn_meeting: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      custom_keys: z
        .array(
          z.object({
            key: z.string().optional(),
            value: z.string().optional(),
          }),
        )
        .optional(),
      encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      global_dial_in_numbers: z
        .array(
          z.object({
            city: z.string().optional(),
            country: z.string().optional(),
            country_name: z.string().optional(),
            number: z.string().optional(),
            type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
          }),
        )
        .optional(),
      host_video: z.boolean().optional(),
      in_meeting: z.boolean().optional(),
      jbh_time: z.union([z.literal(0), z.literal(5), z.literal(10)]).optional(),
      join_before_host: z.boolean().optional(),
      language_interpretation: z
        .object({
          enable: z.boolean().optional(),
          interpreters: z
            .array(
              z.object({
                email: z.string().optional(),
                languages: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      meeting_authentication: z.boolean().optional(),
      mute_upon_entry: z.boolean().optional(),
      participant_video: z.boolean().optional(),
      registrants_confirmation_email: z.boolean().optional(),
      registrants_email_notification: z.boolean().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      use_pmi: z.boolean().optional(),
      waiting_room: z.boolean().optional(),
      watermark: z.boolean().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  start_url: z.string().optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
        visible: z.boolean().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
});

export const meetingInfoGetSchema = z.object({
  agenda: z.string().optional(),
  created_at: z.string().optional(),
  duration: z.number().optional(),
  encrypted_password: z.string().optional(),
  h323_password: z.string().optional(),
  join_url: z.string().optional(),
  occurrences: z
    .array(
      z.object({
        duration: z.number().optional(),
        occurrence_id: z.string().optional(),
        start_time: z.string().optional(),
        status: z.string().optional(),
      }),
    )
    .optional(),
  password: z.string().optional(),
  pmi: z.number().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z
        .union([
          z.literal('1'),
          z.literal('2'),
          z.literal('3'),
          z.literal('4'),
          z.literal('5'),
          z.literal('6'),
          z.literal('7'),
        ])
        .optional(),
    })
    .optional(),
  settings: z
    .object({
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      alternative_hosts_email_notification: z.boolean().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      approved_or_denied_countries_or_regions: z
        .object({
          approved_list: z.array(z.string()).optional(),
          denied_list: z.array(z.string()).optional(),
          enable: z.boolean().optional(),
          method: z.union([z.literal('approve'), z.literal('deny')]).optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_exception: z
        .array(
          z.object({
            email: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .optional(),
      authentication_name: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      breakout_room: z
        .object({
          enable: z.boolean().optional(),
          rooms: z
            .array(
              z.object({
                name: z.string().optional(),
                participants: z.array(z.string()).optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      close_registration: z.boolean().optional(),
      cn_meeting: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      custom_keys: z
        .array(
          z.object({
            key: z.string().optional(),
            value: z.string().optional(),
          }),
        )
        .optional(),
      encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      global_dial_in_numbers: z
        .array(
          z.object({
            city: z.string().optional(),
            country: z.string().optional(),
            country_name: z.string().optional(),
            number: z.string().optional(),
            type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
          }),
        )
        .optional(),
      host_video: z.boolean().optional(),
      in_meeting: z.boolean().optional(),
      jbh_time: z.union([z.literal(0), z.literal(5), z.literal(10)]).optional(),
      join_before_host: z.boolean().optional(),
      language_interpretation: z
        .object({
          enable: z.boolean().optional(),
          interpreters: z
            .array(
              z.object({
                email: z.string().optional(),
                languages: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      meeting_authentication: z.boolean().optional(),
      mute_upon_entry: z.boolean().optional(),
      participant_video: z.boolean().optional(),
      registrants_confirmation_email: z.boolean().optional(),
      registrants_email_notification: z.boolean().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      use_pmi: z.boolean().optional(),
      waiting_room: z.boolean().optional(),
      watermark: z.boolean().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  start_url: z.string().optional(),
  status: z.union([z.literal('waiting'), z.literal('started')]).optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
        visible: z.boolean().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
});

export const statusSchema = z.union([z.literal('waiting'), z.literal('started')]);

export const meetingInstancesSchema = z.object({
  meetings: z
    .array(
      z.object({
        start_time: z.string().optional(),
        uuid: z.string().optional(),
      }),
    )
    .optional(),
});

export const meetingInvitationSchema = z.object({
  invitation: z.string().optional(),
});

export const meetingListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      meetings: z
        .array(
          z.object({
            agenda: z.string().optional(),
            created_at: z.string().optional(),
            duration: z.number().optional(),
            host_id: z.string().optional(),
            id: z.number().optional(),
            join_url: z.string().optional(),
            start_time: z.string().optional(),
            timezone: z.string().optional(),
            topic: z.string().optional(),
            type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
            uuid: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const meetingLiveStreamSchema = z.object({
  page_url: z.string().optional(),
  stream_key: z.string(),
  stream_url: z.string(),
});

export const meetingLiveStreamStatusSchema = z.object({
  action: z.union([z.literal('start'), z.literal('stop')]).optional(),
  settings: z
    .object({
      active_speaker_name: z.boolean().optional(),
      display_name: z.string().optional(),
    })
    .optional(),
});

export const action3Schema = z.union([z.literal('start'), z.literal('stop')]);

export const meetingMetricSchema = z.object({
  custom_keys: z
    .array(
      z.object({
        key: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  dept: z.string().optional(),
  duration: z.string().optional(),
  email: z.string().optional(),
  end_time: z.string().optional(),
  has_3rd_party_audio: z.boolean().optional(),
  has_pstn: z.boolean().optional(),
  has_recording: z.boolean().optional(),
  has_screen_share: z.boolean().optional(),
  has_sip: z.boolean().optional(),
  has_video: z.boolean().optional(),
  has_voip: z.boolean().optional(),
  host: z.string().optional(),
  id: z.number().optional(),
  in_room_participants: z.number().optional(),
  participants: z.number().optional(),
  start_time: z.string().optional(),
  topic: z.string().optional(),
  user_type: z.string().optional(),
  uuid: z.string().optional(),
});

export const meetingRecordingRegistrantListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      registrants: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z.object({
                address: z.string().optional(),
                city: z.string().optional(),
                comments: z.string().optional(),
                country: z.string().optional(),
                custom_questions: z
                  .array(
                    z.object({
                      title: z.string().optional(),
                      value: z.string().optional(),
                    }),
                  )
                  .optional(),
                email: z.string(),
                first_name: z.string(),
                industry: z.string().optional(),
                job_title: z.string().optional(),
                last_name: z.string().optional(),
                no_of_employees: z.string().optional(),
                org: z.string().optional(),
                phone: z.string().optional(),
                purchasing_time_frame: z.string().optional(),
                role_in_purchase_process: z.string().optional(),
                state: z.string().optional(),
                zip: z.string().optional(),
              }),
            ),
        )
        .optional(),
    }),
  );

export const meetingRegistrantSchema = z.object({
  address: z.string().optional(),
  city: z.string().optional(),
  comments: z.string().optional(),
  country: z.string().optional(),
  custom_questions: z
    .array(
      z.object({
        title: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  email: z.string(),
  first_name: z.string(),
  industry: z.string().optional(),
  job_title: z.string().optional(),
  last_name: z.string().optional(),
  no_of_employees: z.string().optional(),
  org: z.string().optional(),
  phone: z.string().optional(),
  purchasing_time_frame: z.string().optional(),
  role_in_purchase_process: z.string().optional(),
  state: z.string().optional(),
  zip: z.string().optional(),
});

export const meetingRegistrantListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      registrants: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z.object({
                address: z.string().optional(),
                city: z.string().optional(),
                comments: z.string().optional(),
                country: z.string().optional(),
                custom_questions: z
                  .array(
                    z.object({
                      title: z.string().optional(),
                      value: z.string().optional(),
                    }),
                  )
                  .optional(),
                email: z.string(),
                first_name: z.string(),
                industry: z.string().optional(),
                job_title: z.string().optional(),
                last_name: z.string().optional(),
                no_of_employees: z.string().optional(),
                org: z.string().optional(),
                phone: z.string().optional(),
                purchasing_time_frame: z.string().optional(),
                role_in_purchase_process: z.string().optional(),
                state: z.string().optional(),
                zip: z.string().optional(),
              }),
            )
            .and(
              z.object({
                create_time: z.string().optional(),
                join_url: z.string().optional(),
                status: z.string().optional(),
              }),
            ),
        )
        .optional(),
    }),
  );

export const meetingRegistrantQuestionsSchema = z.object({
  custom_questions: z
    .array(
      z.object({
        answers: z.array(z.string()).optional(),
        required: z.boolean().optional(),
        title: z.string().optional(),
        type: z.union([z.literal('short'), z.literal('single')]).optional(),
      }),
    )
    .optional(),
  questions: z
    .array(
      z.object({
        field_name: z
          .union([
            z.literal('address'),
            z.literal('city'),
            z.literal('country'),
            z.literal('zip'),
            z.literal('state'),
            z.literal('phone'),
            z.literal('industry'),
            z.literal('org'),
            z.literal('job_title'),
            z.literal('purchasing_time_frame'),
            z.literal('role_in_purchase_process'),
            z.literal('no_of_employees'),
            z.literal('comments'),
          ])
          .optional(),
        required: z.boolean().optional(),
      }),
    )
    .optional(),
});

export const meetingSecuritySettingsSchema = z.object({
  meeting_security: z
    .object({
      auto_security: z.boolean().optional(),
      embed_password_in_join_link: z.boolean().optional(),
      encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
      end_to_end_encrypted_meetings: z.boolean().optional(),
      meeting_password: z.boolean().optional(),
      meeting_password_requirement: z
        .object({
          consecutive_characters_length: z
            .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
            .optional(),
          have_letter: z.boolean().optional(),
          have_number: z.boolean().optional(),
          have_special_character: z.boolean().optional(),
          have_upper_and_lower_characters: z.boolean().optional(),
          length: z.number().optional(),
          only_allow_numeric: z.boolean().optional(),
          weak_enhance_detection: z.boolean().optional(),
        })
        .optional(),
      phone_password: z.boolean().optional(),
      pmi_password: z.boolean().optional(),
      require_password_for_scheduled_meeting: z.boolean().optional(),
      require_password_for_scheduled_webinar: z.boolean().optional(),
      waiting_room: z.boolean().optional(),
      waiting_room_settings: z
        .object({
          participants_to_place_in_waiting_room: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
          users_who_can_admit_participants_from_waiting_room: z.number().optional(),
          whitelisted_domains_for_waiting_room: z.string().optional(),
        })
        .optional(),
      webinar_password: z.boolean().optional(),
    })
    .optional(),
});

export const participantsToPlaceInWaitingRoomSchema = z.union([z.literal(0), z.literal(1), z.literal(2)]);

export const meetingSettingsSchema = z.object({
  allow_multiple_devices: z.boolean().optional(),
  alternative_hosts: z.string().optional(),
  alternative_hosts_email_notification: z.boolean().optional(),
  approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
  approved_or_denied_countries_or_regions: z
    .object({
      approved_list: z.array(z.string()).optional(),
      denied_list: z.array(z.string()).optional(),
      enable: z.boolean().optional(),
      method: z.union([z.literal('approve'), z.literal('deny')]).optional(),
    })
    .optional(),
  audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
  authentication_domains: z.string().optional(),
  authentication_exception: z
    .array(
      z.object({
        email: z.string().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
  authentication_name: z.string().optional(),
  authentication_option: z.string().optional(),
  auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
  breakout_room: z
    .object({
      enable: z.boolean().optional(),
      rooms: z
        .array(
          z.object({
            name: z.string().optional(),
            participants: z.array(z.string()).optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  close_registration: z.boolean().optional(),
  cn_meeting: z.boolean().optional(),
  contact_email: z.string().optional(),
  contact_name: z.string().optional(),
  custom_keys: z
    .array(
      z.object({
        key: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
  enforce_login: z.boolean().optional(),
  enforce_login_domains: z.string().optional(),
  global_dial_in_countries: z.array(z.string()).optional(),
  global_dial_in_numbers: z
    .array(
      z.object({
        city: z.string().optional(),
        country: z.string().optional(),
        country_name: z.string().optional(),
        number: z.string().optional(),
        type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
      }),
    )
    .optional(),
  host_video: z.boolean().optional(),
  in_meeting: z.boolean().optional(),
  jbh_time: z.union([z.literal(0), z.literal(5), z.literal(10)]).optional(),
  join_before_host: z.boolean().optional(),
  language_interpretation: z
    .object({
      enable: z.boolean().optional(),
      interpreters: z
        .array(
          z.object({
            email: z.string().optional(),
            languages: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  meeting_authentication: z.boolean().optional(),
  mute_upon_entry: z.boolean().optional(),
  participant_video: z.boolean().optional(),
  registrants_confirmation_email: z.boolean().optional(),
  registrants_email_notification: z.boolean().optional(),
  registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
  show_share_button: z.boolean().optional(),
  use_pmi: z.boolean().optional(),
  waiting_room: z.boolean().optional(),
  watermark: z.boolean().optional(),
});

export const meetingUpdateSchema = z.object({
  agenda: z.string().optional(),
  duration: z.number().optional(),
  password: z.string().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z
        .union([
          z.literal('1'),
          z.literal('2'),
          z.literal('3'),
          z.literal('4'),
          z.literal('5'),
          z.literal('6'),
          z.literal('7'),
        ])
        .optional(),
    })
    .optional(),
  settings: z
    .object({
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      alternative_hosts_email_notification: z.boolean().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      approved_or_denied_countries_or_regions: z
        .object({
          approved_list: z.array(z.string()).optional(),
          denied_list: z.array(z.string()).optional(),
          enable: z.boolean().optional(),
          method: z.union([z.literal('approve'), z.literal('deny')]).optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_exception: z
        .array(
          z.object({
            email: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .optional(),
      authentication_name: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      breakout_room: z
        .object({
          enable: z.boolean().optional(),
          rooms: z
            .array(
              z.object({
                name: z.string().optional(),
                participants: z.array(z.string()).optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      close_registration: z.boolean().optional(),
      cn_meeting: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      custom_keys: z
        .array(
          z.object({
            key: z.string().optional(),
            value: z.string().optional(),
          }),
        )
        .optional(),
      encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      global_dial_in_numbers: z
        .array(
          z.object({
            city: z.string().optional(),
            country: z.string().optional(),
            country_name: z.string().optional(),
            number: z.string().optional(),
            type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
          }),
        )
        .optional(),
      host_video: z.boolean().optional(),
      in_meeting: z.boolean().optional(),
      jbh_time: z.union([z.literal(0), z.literal(5), z.literal(10)]).optional(),
      join_before_host: z.boolean().optional(),
      language_interpretation: z
        .object({
          enable: z.boolean().optional(),
          interpreters: z
            .array(
              z.object({
                email: z.string().optional(),
                languages: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      meeting_authentication: z.boolean().optional(),
      mute_upon_entry: z.boolean().optional(),
      participant_video: z.boolean().optional(),
      registrants_confirmation_email: z.boolean().optional(),
      registrants_email_notification: z.boolean().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      use_pmi: z.boolean().optional(),
      waiting_room: z.boolean().optional(),
      watermark: z.boolean().optional(),
    })
    .and(
      z.object({
        registrants_confirmation_email: z.boolean().optional(),
      }),
    )
    .optional(),
  start_time: z.string().optional(),
  template_id: z.string().optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
});

export const occurrenceSchema = z.object({
  duration: z.number().optional(),
  occurrence_id: z.string().optional(),
  start_time: z.string().optional(),
  status: z.string().optional(),
});

export const occurrencesSchema = z.array(
  z.object({
    duration: z.number().optional(),
    occurrence_id: z.string().optional(),
    start_time: z.string().optional(),
    status: z.string().optional(),
  }),
);

export const pacSchema = z.object({
  conference_id: z.number().optional(),
  dedicated_dial_in_number: z
    .array(
      z.object({
        country: z.string().optional(),
        number: z.string().optional(),
      }),
    )
    .optional(),
  global_dial_in_numbers: z
    .array(
      z.object({
        country: z.string().optional(),
        number: z.string().optional(),
      }),
    )
    .optional(),
  listen_only_password: z.string().optional(),
  participant_password: z.string().optional(),
});

export const paginationSchema = z.object({
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_number: z.number().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
});

export const paginationTokenSchema = z.object({
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
});

export const paginationToken4IMChatSchema = z.object({
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
});

export const paginationToken4QosSchema = z.object({
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
});

export const panelistSchema = z.object({
  email: z.string().optional(),
  name: z.string().optional(),
});

export const panelistListSchema = z.object({
  panelists: z
    .array(
      z
        .object({
          id: z.string().optional(),
        })
        .and(
          z.object({
            email: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .and(
          z.object({
            join_url: z.string().optional(),
          }),
        ),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const phonePlanSchema = z.object({
  plan_base: z
    .object({
      callout_countries: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
  plan_calling: z
    .array(
      z.object({
        hosts: z.number().optional(),
        type: z.string().optional(),
      }),
    )
    .optional(),
  plan_number: z
    .array(
      z.object({
        hosts: z.number().optional(),
        type: z.string().optional(),
      }),
    )
    .optional(),
});

export const pollSchema = z.object({
  questions: z
    .array(
      z.object({
        answers: z.array(z.string()).optional(),
        name: z.string().optional(),
        type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
      }),
    )
    .optional(),
  title: z.string().optional(),
});

export const pollListSchema = z.object({
  polls: z
    .array(
      z
        .object({
          id: z.string().optional(),
          status: z
            .union([z.literal('notstart'), z.literal('started'), z.literal('ended'), z.literal('sharing')])
            .optional(),
        })
        .and(
          z.object({
            questions: z
              .array(
                z.object({
                  answers: z.array(z.string()).optional(),
                  name: z.string().optional(),
                  type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
                }),
              )
              .optional(),
            title: z.string().optional(),
          }),
        ),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const profileSchema = z.object({
  recording_storage_location: z
    .object({
      allowed_values: z.array(z.string()).optional(),
      value: z.string().optional(),
    })
    .optional(),
});

export const qOSAudioSchema = z.object({
  avg_loss: z.string().optional(),
  bitrate: z.string().optional(),
  jitter: z.string().optional(),
  latency: z.string().optional(),
  max_loss: z.string().optional(),
});

export const qOSParticipantSchema = z.object({
  device: z.string().optional(),
  domain: z.string().optional(),
  harddisk_id: z.string().optional(),
  ip_address: z.string().optional(),
  join_time: z.string().optional(),
  leave_time: z.string().optional(),
  location: z.string().optional(),
  mac_addr: z.string().optional(),
  pc_name: z.string().optional(),
  user_id: z.string().optional(),
  user_name: z.string().optional(),
  user_qos: z
    .array(
      z.object({
        as_device_from_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        as_device_to_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        as_input: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .and(
            z.object({
              frame_rate: z.string().optional(),
              resolution: z.string().optional(),
            }),
          )
          .optional(),
        as_output: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .and(
            z.object({
              frame_rate: z.string().optional(),
              resolution: z.string().optional(),
            }),
          )
          .optional(),
        audio_device_from_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        audio_device_to_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        audio_input: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        audio_output: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        cpu_usage: z
          .object({
            system_max_cpu_usage: z.string().optional(),
            zoom_avg_cpu_usage: z.string().optional(),
            zoom_max_cpu_usage: z.string().optional(),
            zoom_min_cpu_usage: z.string().optional(),
          })
          .optional(),
        date_time: z.string().optional(),
        video_device_from_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        video_device_to_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        video_input: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .and(
            z.object({
              frame_rate: z.string().optional(),
              resolution: z.string().optional(),
            }),
          )
          .optional(),
        video_output: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .and(
            z.object({
              frame_rate: z.string().optional(),
              resolution: z.string().optional(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
  version: z.string().optional(),
});

export const qOSParticipantListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      participants: z
        .array(
          z.object({
            device: z.string().optional(),
            domain: z.string().optional(),
            harddisk_id: z.string().optional(),
            ip_address: z.string().optional(),
            join_time: z.string().optional(),
            leave_time: z.string().optional(),
            location: z.string().optional(),
            mac_addr: z.string().optional(),
            pc_name: z.string().optional(),
            user_id: z.string().optional(),
            user_name: z.string().optional(),
            user_qos: z
              .array(
                z.object({
                  as_device_from_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  as_device_to_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  as_input: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .and(
                      z.object({
                        frame_rate: z.string().optional(),
                        resolution: z.string().optional(),
                      }),
                    )
                    .optional(),
                  as_output: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .and(
                      z.object({
                        frame_rate: z.string().optional(),
                        resolution: z.string().optional(),
                      }),
                    )
                    .optional(),
                  audio_device_from_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  audio_device_to_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  audio_input: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  audio_output: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  cpu_usage: z
                    .object({
                      system_max_cpu_usage: z.string().optional(),
                      zoom_avg_cpu_usage: z.string().optional(),
                      zoom_max_cpu_usage: z.string().optional(),
                      zoom_min_cpu_usage: z.string().optional(),
                    })
                    .optional(),
                  date_time: z.string().optional(),
                  video_device_from_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  video_device_to_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  video_input: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .and(
                      z.object({
                        frame_rate: z.string().optional(),
                        resolution: z.string().optional(),
                      }),
                    )
                    .optional(),
                  video_output: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .and(
                      z.object({
                        frame_rate: z.string().optional(),
                        resolution: z.string().optional(),
                      }),
                    )
                    .optional(),
                }),
              )
              .optional(),
            version: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const qOSVideoSchema = z
  .object({
    avg_loss: z.string().optional(),
    bitrate: z.string().optional(),
    jitter: z.string().optional(),
    latency: z.string().optional(),
    max_loss: z.string().optional(),
  })
  .and(
    z.object({
      frame_rate: z.string().optional(),
      resolution: z.string().optional(),
    }),
  );

export const qoSPhoneSchema = z.object({
  avg_loss: z.string().optional(),
  bitrate: z.string().optional(),
  jitter: z.string().optional(),
  max_loss: z.string().optional(),
  mos: z.string().optional(),
  network_delay: z.string().optional(),
});

export const recordingSchema = z.object({
  deleted_time: z.string().optional(),
  download_url: z.string().optional(),
  file_size: z.number().optional(),
  file_type: z.string().optional(),
  id: z.string().optional(),
  meeting_id: z.string().optional(),
  play_url: z.string().optional(),
  recording_end: z.string().optional(),
  recording_start: z.string().optional(),
  recording_type: z.string().optional(),
  status: z.literal('completed').optional(),
});

export const status2Schema = z.literal('completed');

export const recordingListSchema = z.object({
  recording_files: z
    .array(
      z.object({
        deleted_time: z.string().optional(),
        download_url: z.string().optional(),
        file_size: z.number().optional(),
        file_type: z.string().optional(),
        id: z.string().optional(),
        meeting_id: z.string().optional(),
        play_url: z.string().optional(),
        recording_end: z.string().optional(),
        recording_start: z.string().optional(),
        recording_type: z.string().optional(),
        status: z.literal('completed').optional(),
      }),
    )
    .optional(),
});

export const recordingMeetingSchema = z
  .object({
    account_id: z.string().optional(),
    duration: z.number().optional(),
    host_id: z.string().optional(),
    id: z.string().optional(),
    recording_count: z.string().optional(),
    start_time: z.string().optional(),
    topic: z.string().optional(),
    total_size: z.string().optional(),
    type: z.string().optional(),
    uuid: z.string().optional(),
  })
  .and(
    z.object({
      recording_files: z
        .array(
          z.object({
            deleted_time: z.string().optional(),
            download_url: z.string().optional(),
            file_size: z.number().optional(),
            file_type: z.string().optional(),
            id: z.string().optional(),
            meeting_id: z.string().optional(),
            play_url: z.string().optional(),
            recording_end: z.string().optional(),
            recording_start: z.string().optional(),
            recording_type: z.string().optional(),
            status: z.literal('completed').optional(),
          }),
        )
        .optional(),
    }),
  );

export const recordingMeetingListSchema = z
  .object({
    from: z.string().optional(),
    to: z.string().optional(),
  })
  .and(
    z.object({
      next_page_token: z.string().optional(),
      page_count: z.number().optional(),
      page_size: z.number().optional(),
      total_records: z.number().optional(),
    }),
  )
  .and(
    z.object({
      meetings: z
        .array(
          z
            .object({
              account_id: z.string().optional(),
              duration: z.number().optional(),
              host_id: z.string().optional(),
              id: z.string().optional(),
              recording_count: z.string().optional(),
              start_time: z.string().optional(),
              topic: z.string().optional(),
              total_size: z.string().optional(),
              type: z.string().optional(),
              uuid: z.string().optional(),
            })
            .and(
              z.object({
                recording_files: z
                  .array(
                    z.object({
                      deleted_time: z.string().optional(),
                      download_url: z.string().optional(),
                      file_size: z.number().optional(),
                      file_type: z.string().optional(),
                      id: z.string().optional(),
                      meeting_id: z.string().optional(),
                      play_url: z.string().optional(),
                      recording_end: z.string().optional(),
                      recording_start: z.string().optional(),
                      recording_type: z.string().optional(),
                      status: z.literal('completed').optional(),
                    }),
                  )
                  .optional(),
              }),
            ),
        )
        .optional(),
    }),
  );

export const recordingRegistrantListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      registrants: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z.object({
                address: z.string().optional(),
                city: z.string().optional(),
                comments: z.string().optional(),
                country: z.string().optional(),
                custom_questions: z
                  .array(
                    z.object({
                      title: z.string().optional(),
                      value: z.string().optional(),
                    }),
                  )
                  .optional(),
                email: z.string(),
                first_name: z.string(),
                industry: z.string().optional(),
                job_title: z.string().optional(),
                last_name: z.string().optional(),
                no_of_employees: z.string().optional(),
                org: z.string().optional(),
                phone: z.string().optional(),
                purchasing_time_frame: z.string().optional(),
                role_in_purchase_process: z.string().optional(),
                state: z.string().optional(),
                zip: z.string().optional(),
              }),
            ),
        )
        .optional(),
    }),
  );

export const recordingRegistrantQuestionsSchema = z.object({
  custom_questions: z
    .array(
      z.object({
        answers: z.array(z.string()).optional(),
        required: z.boolean().optional(),
        title: z.string().optional(),
        type: z.union([z.literal('short'), z.literal('single'), z.literal('multiple')]).optional(),
      }),
    )
    .optional(),
  questions: z
    .array(
      z.object({
        field_name: z
          .union([
            z.literal('last_name'),
            z.literal('address'),
            z.literal('city'),
            z.literal('country'),
            z.literal('zip'),
            z.literal('state'),
            z.literal('phone'),
            z.literal('industry'),
            z.literal('org'),
            z.literal('job_title'),
            z.literal('purchasing_time_frame'),
            z.literal('role_in_purchase_process'),
            z.literal('no_of_employees'),
            z.literal('comments'),
          ])
          .optional(),
        required: z.boolean().optional(),
      }),
    )
    .optional(),
});

export const recordingRegistrantStatusSchema = z.object({
  action: z.union([z.literal('approve'), z.literal('deny')]),
  registrants: z
    .array(
      z.object({
        id: z.string().optional(),
      }),
    )
    .optional(),
});

export const action4Schema = z.union([z.literal('approve'), z.literal('deny')]);

export const recordingSettingsSchema = z.object({
  approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
  authentication_domains: z.string().optional(),
  authentication_option: z.string().optional(),
  on_demand: z.boolean().optional(),
  password: z.string().optional(),
  recording_authentication: z.boolean().optional(),
  send_email_to_host: z.boolean().optional(),
  share_recording: z.union([z.literal('publicly'), z.literal('internally'), z.literal('none')]).optional(),
  show_social_share_buttons: z.boolean().optional(),
  topic: z.string().optional(),
  viewer_download: z.boolean().optional(),
});

export const shareRecordingSchema = z.union([z.literal('publicly'), z.literal('internally'), z.literal('none')]);

export const recurrenceSchema = z.object({
  end_date_time: z.string().optional(),
  end_times: z.number().optional(),
  monthly_day: z.number().optional(),
  monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
  monthly_week_day: z
    .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
    .optional(),
  repeat_interval: z.number().optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
  weekly_days: z
    .union([
      z.literal('1'),
      z.literal('2'),
      z.literal('3'),
      z.literal('4'),
      z.literal('5'),
      z.literal('6'),
      z.literal('7'),
    ])
    .optional(),
});

export const registrantSchema = z.object({
  address: z.string().optional(),
  city: z.string().optional(),
  comments: z.string().optional(),
  country: z.string().optional(),
  custom_questions: z
    .array(
      z.object({
        title: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  email: z.string(),
  first_name: z.string(),
  industry: z.string().optional(),
  job_title: z.string().optional(),
  last_name: z.string().optional(),
  no_of_employees: z.string().optional(),
  org: z.string().optional(),
  phone: z.string().optional(),
  purchasing_time_frame: z.string().optional(),
  role_in_purchase_process: z.string().optional(),
  state: z.string().optional(),
  zip: z.string().optional(),
});

export const registrantListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      registrants: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z.object({
                address: z.string().optional(),
                city: z.string().optional(),
                comments: z.string().optional(),
                country: z.string().optional(),
                custom_questions: z
                  .array(
                    z.object({
                      title: z.string().optional(),
                      value: z.string().optional(),
                    }),
                  )
                  .optional(),
                email: z.string(),
                first_name: z.string(),
                industry: z.string().optional(),
                job_title: z.string().optional(),
                last_name: z.string().optional(),
                no_of_employees: z.string().optional(),
                org: z.string().optional(),
                phone: z.string().optional(),
                purchasing_time_frame: z.string().optional(),
                role_in_purchase_process: z.string().optional(),
                state: z.string().optional(),
                zip: z.string().optional(),
              }),
            )
            .and(
              z.object({
                create_time: z.string().optional(),
                join_url: z.string().optional(),
                status: z.string().optional(),
              }),
            ),
        )
        .optional(),
    }),
  );

export const registrantStatusSchema = z.object({
  action: z.union([z.literal('approve'), z.literal('cancel'), z.literal('deny')]),
  registrants: z
    .array(
      z.object({
        email: z.string().optional(),
        id: z.string().optional(),
      }),
    )
    .optional(),
});

export const action5Schema = z.union([z.literal('approve'), z.literal('cancel'), z.literal('deny')]);

export const roleListSchema = z.object({
  roles: z
    .array(
      z.object({
        description: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        total_members: z.number().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const roleMembersAddSchema = z.object({
  members: z
    .array(
      z.object({
        email: z.string().optional(),
        id: z.string().optional(),
      }),
    )
    .optional(),
});

export const roleMembersListSchema = z.object({
  members: z
    .array(
      z.object({
        department: z.string().optional(),
        email: z.string().optional(),
        first_name: z.string().optional(),
        id: z.string().optional(),
        last_name: z.string().optional(),
        type: z.number().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_number: z.number().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
});

export const sessionSchema = z.object({
  agenda: z.string().optional(),
  duration: z.number().optional(),
  password: z.string().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z
        .union([
          z.literal('1'),
          z.literal('2'),
          z.literal('3'),
          z.literal('4'),
          z.literal('5'),
          z.literal('6'),
          z.literal('7'),
        ])
        .optional(),
    })
    .optional(),
  settings: z
    .object({
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      alternative_hosts_email_notification: z.boolean().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      approved_or_denied_countries_or_regions: z
        .object({
          approved_list: z.array(z.string()).optional(),
          denied_list: z.array(z.string()).optional(),
          enable: z.boolean().optional(),
          method: z.union([z.literal('approve'), z.literal('deny')]).optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_exception: z
        .array(
          z.object({
            email: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .optional(),
      authentication_name: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      breakout_room: z
        .object({
          enable: z.boolean().optional(),
          rooms: z
            .array(
              z.object({
                name: z.string().optional(),
                participants: z.array(z.string()).optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      close_registration: z.boolean().optional(),
      cn_meeting: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      custom_keys: z
        .array(
          z.object({
            key: z.string().optional(),
            value: z.string().optional(),
          }),
        )
        .optional(),
      encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      global_dial_in_numbers: z
        .array(
          z.object({
            city: z.string().optional(),
            country: z.string().optional(),
            country_name: z.string().optional(),
            number: z.string().optional(),
            type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
          }),
        )
        .optional(),
      host_video: z.boolean().optional(),
      in_meeting: z.boolean().optional(),
      jbh_time: z.union([z.literal(0), z.literal(5), z.literal(10)]).optional(),
      join_before_host: z.boolean().optional(),
      language_interpretation: z
        .object({
          enable: z.boolean().optional(),
          interpreters: z
            .array(
              z.object({
                email: z.string().optional(),
                languages: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      meeting_authentication: z.boolean().optional(),
      mute_upon_entry: z.boolean().optional(),
      participant_video: z.boolean().optional(),
      registrants_confirmation_email: z.boolean().optional(),
      registrants_email_notification: z.boolean().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      use_pmi: z.boolean().optional(),
      waiting_room: z.boolean().optional(),
      watermark: z.boolean().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
});

export const sessionUpdateSchema = z.object({
  agenda: z.string().optional(),
  duration: z.number().optional(),
  password: z.string().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z
        .union([
          z.literal('1'),
          z.literal('2'),
          z.literal('3'),
          z.literal('4'),
          z.literal('5'),
          z.literal('6'),
          z.literal('7'),
        ])
        .optional(),
    })
    .optional(),
  settings: z
    .object({
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      alternative_hosts_email_notification: z.boolean().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      approved_or_denied_countries_or_regions: z
        .object({
          approved_list: z.array(z.string()).optional(),
          denied_list: z.array(z.string()).optional(),
          enable: z.boolean().optional(),
          method: z.union([z.literal('approve'), z.literal('deny')]).optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_exception: z
        .array(
          z.object({
            email: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .optional(),
      authentication_name: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      breakout_room: z
        .object({
          enable: z.boolean().optional(),
          rooms: z
            .array(
              z.object({
                name: z.string().optional(),
                participants: z.array(z.string()).optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      close_registration: z.boolean().optional(),
      cn_meeting: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      custom_keys: z
        .array(
          z.object({
            key: z.string().optional(),
            value: z.string().optional(),
          }),
        )
        .optional(),
      encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      global_dial_in_numbers: z
        .array(
          z.object({
            city: z.string().optional(),
            country: z.string().optional(),
            country_name: z.string().optional(),
            number: z.string().optional(),
            type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
          }),
        )
        .optional(),
      host_video: z.boolean().optional(),
      in_meeting: z.boolean().optional(),
      jbh_time: z.union([z.literal(0), z.literal(5), z.literal(10)]).optional(),
      join_before_host: z.boolean().optional(),
      language_interpretation: z
        .object({
          enable: z.boolean().optional(),
          interpreters: z
            .array(
              z.object({
                email: z.string().optional(),
                languages: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      meeting_authentication: z.boolean().optional(),
      mute_upon_entry: z.boolean().optional(),
      participant_video: z.boolean().optional(),
      registrants_confirmation_email: z.boolean().optional(),
      registrants_email_notification: z.boolean().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      use_pmi: z.boolean().optional(),
      waiting_room: z.boolean().optional(),
      watermark: z.boolean().optional(),
    })
    .and(
      z.object({
        registrants_confirmation_email: z.boolean().optional(),
      }),
    )
    .optional(),
  start_time: z.string().optional(),
  template_id: z.string().optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
});

export const sessionWebinarSchema = z.object({
  agenda: z.string().optional(),
  duration: z.number().optional(),
  password: z.string().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z.string().optional(),
    })
    .optional(),
  settings: z
    .object({
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      attendees_and_panelists_reminder_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_name: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      close_registration: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      email_language: z.string().optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      follow_up_absentees_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      follow_up_attendees_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      hd_video: z.boolean().optional(),
      host_video: z.boolean().optional(),
      meeting_authentication: z.boolean().optional(),
      notify_registrants: z.boolean().optional(),
      on_demand: z.boolean().optional(),
      panelists_invitation_email_notification: z.boolean().optional(),
      panelists_video: z.boolean().optional(),
      post_webinar_survey: z.boolean().optional(),
      practice_session: z.boolean().optional(),
      question_and_answer: z
        .object({
          allow_anonymous_questions: z.boolean().optional(),
          answer_questions: z.union([z.literal('only'), z.literal('all')]).optional(),
          attendees_can_comment: z.boolean().optional(),
          attendees_can_upvote: z.boolean().optional(),
          enable: z.boolean().optional(),
        })
        .optional(),
      registrants_confirmation_email: z.boolean().optional(),
      registrants_email_notification: z.boolean().optional(),
      registrants_restrict_number: z.number().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      survey_url: z.string().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(5), z.literal(6), z.literal(9)]).optional(),
});

export const sessionWebinarUpdateSchema = z.object({
  agenda: z.string().optional(),
  duration: z.number().optional(),
  password: z.string().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z
        .union([
          z.literal('1'),
          z.literal('2'),
          z.literal('3'),
          z.literal('4'),
          z.literal('5'),
          z.literal('6'),
          z.literal('7'),
        ])
        .optional(),
    })
    .optional(),
  settings: z
    .object({
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      attendees_and_panelists_reminder_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_name: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      close_registration: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      email_language: z.string().optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      follow_up_absentees_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      follow_up_attendees_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      hd_video: z.boolean().optional(),
      host_video: z.boolean().optional(),
      meeting_authentication: z.boolean().optional(),
      notify_registrants: z.boolean().optional(),
      on_demand: z.boolean().optional(),
      panelists_invitation_email_notification: z.boolean().optional(),
      panelists_video: z.boolean().optional(),
      post_webinar_survey: z.boolean().optional(),
      practice_session: z.boolean().optional(),
      question_and_answer: z
        .object({
          allow_anonymous_questions: z.boolean().optional(),
          answer_questions: z.union([z.literal('only'), z.literal('all')]).optional(),
          attendees_can_comment: z.boolean().optional(),
          attendees_can_upvote: z.boolean().optional(),
          enable: z.boolean().optional(),
        })
        .optional(),
      registrants_confirmation_email: z.boolean().optional(),
      registrants_email_notification: z.boolean().optional(),
      registrants_restrict_number: z.number().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      survey_url: z.string().optional(),
    })
    .and(
      z.object({
        registrants_confirmation_email: z.boolean().optional(),
      }),
    )
    .optional(),
  start_time: z.string().optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(5), z.literal(6), z.literal(9)]).optional(),
});

export const settingsUpdateTelephonySchema = z.object({
  audio_conference_info: z.string().optional(),
  show_international_numbers_link: z.boolean().optional(),
  telephony_regions: z
    .object({
      selection_values: z.array(z.string()).optional(),
    })
    .optional(),
  third_party_audio: z.boolean().optional(),
});

export const tspSchema = z.object({
  conference_code: z.string(),
  dial_in_numbers: z
    .array(
      z.object({
        code: z.string().optional(),
        country_label: z.string().optional(),
        number: z.string().optional(),
        type: z.union([z.literal('toll'), z.literal('tollfree'), z.literal('media_link')]).optional(),
      }),
    )
    .optional(),
  leader_pin: z.string(),
  tsp_bridge: z.union([z.literal('US_TSP_TB'), z.literal('EU_TSP_TB')]).optional(),
});

export const tspBridgeSchema = z.union([z.literal('US_TSP_TB'), z.literal('EU_TSP_TB')]);

export const trackingFieldSchema = z.object({
  field: z.string().optional(),
  recommended_values: z.array(z.string()).optional(),
  required: z.boolean().optional(),
  visible: z.boolean().optional(),
});

export const trackingFieldListSchema = z.object({
  total_records: z.number().optional(),
  tracking_fields: z
    .array(
      z
        .object({
          id: z.string().optional(),
        })
        .and(
          z.object({
            field: z.string().optional(),
            recommended_values: z.array(z.string()).optional(),
            required: z.boolean().optional(),
            visible: z.boolean().optional(),
          }),
        ),
    )
    .optional(),
});

export const userSchema = z.object({
  created_at: z.string().optional(),
  dept: z.string().optional(),
  email: z.string(),
  first_name: z.string().optional(),
  last_client_version: z.string().optional(),
  last_login_time: z.string().optional(),
  last_name: z.string().optional(),
  pmi: z.number().optional(),
  role_name: z.string().optional(),
  timezone: z.string().optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(99)]),
  use_pmi: z.boolean().optional(),
});

export const type7Schema = z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(99)]);

export const userAssistantsListSchema = z.object({
  assistants: z
    .array(
      z.object({
        email: z.string().optional(),
        id: z.string().optional(),
      }),
    )
    .optional(),
});

export const userListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      users: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z.object({
                created_at: z.string().optional(),
                dept: z.string().optional(),
                email: z.string(),
                first_name: z.string().optional(),
                last_client_version: z.string().optional(),
                last_login_time: z.string().optional(),
                last_name: z.string().optional(),
                pmi: z.number().optional(),
                role_name: z.string().optional(),
                timezone: z.string().optional(),
                type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(99)]),
                use_pmi: z.boolean().optional(),
              }),
            )
            .and(
              z.object({
                group_ids: z.array(z.string()).optional(),
                im_group_ids: z.array(z.string()).optional(),
              }),
            ),
        )
        .optional(),
    }),
  );

export const userPermissionsSchema = z.object({
  permissions: z.array(z.string()).optional(),
});

export const userSchedulersListSchema = z.object({
  schedulers: z
    .array(
      z.object({
        email: z.string().optional(),
        id: z.string().optional(),
        pmi: z.number().optional(),
      }),
    )
    .optional(),
});

export const userSettingsSchema = z.object({
  email_notification: z
    .object({
      alternative_host_reminder: z.boolean().optional(),
      cancel_meeting_reminder: z.boolean().optional(),
      jbh_reminder: z.boolean().optional(),
      schedule_for_reminder: z.boolean().optional(),
    })
    .optional(),
  feature: z
    .object({
      cn_meeting: z.boolean().optional(),
      in_meeting: z.boolean().optional(),
      large_meeting: z.boolean().optional(),
      large_meeting_capacity: z.number().optional(),
      meeting_capacity: z.number().optional(),
      webinar: z.boolean().optional(),
      webinar_capacity: z.number().optional(),
      zoom_phone: z.boolean().optional(),
    })
    .optional(),
  in_meeting: z
    .object({
      allow_live_streaming: z.boolean().optional(),
      annotation: z.boolean().optional(),
      attendee_on_hold: z.boolean().optional(),
      auto_saving_chat: z.boolean().optional(),
      breakout_room: z.boolean().optional(),
      chat: z.boolean().optional(),
      closed_caption: z.boolean().optional(),
      co_host: z.boolean().optional(),
      custom_data_center_regions: z.boolean().optional(),
      custom_live_streaming_service: z.boolean().optional(),
      custom_service_instructions: z.string().optional(),
      data_center_regions: z
        .union([
          z.literal('HK'),
          z.literal('AU'),
          z.literal('IN'),
          z.literal('TY'),
          z.literal('CN'),
          z.literal('US'),
          z.literal('CA'),
          z.literal('DE'),
          z.literal('NL'),
          z.literal('LA'),
        ])
        .optional(),
      e2e_encryption: z.boolean().optional(),
      entry_exit_chime: z.union([z.literal('host'), z.literal('all'), z.literal('none')]).optional(),
      far_end_camera_control: z.boolean().optional(),
      feedback: z.boolean().optional(),
      file_transfer: z.boolean().optional(),
      group_hd: z.boolean().optional(),
      non_verbal_feedback: z.boolean().optional(),
      polling: z.boolean().optional(),
      private_chat: z.boolean().optional(),
      record_play_voice: z.boolean().optional(),
      remote_control: z.boolean().optional(),
      remote_support: z.boolean().optional(),
      request_permission_to_unmute: z.boolean().optional(),
      screen_sharing: z.boolean().optional(),
      share_dual_camera: z.boolean().optional(),
      show_meeting_control_toolbar: z.boolean().optional(),
      virtual_background: z.boolean().optional(),
      virtual_background_settings: z
        .object({
          allow_upload_custom: z.boolean().optional(),
          allow_videos: z.boolean().optional(),
          enable: z.boolean().optional(),
          files: z
            .array(
              z.object({
                id: z.string().optional(),
                is_default: z.boolean().optional(),
                name: z.string().optional(),
                size: z.string().optional(),
                type: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      waiting_room: z.boolean().optional(),
      who_can_share_screen: z.union([z.literal('host'), z.literal('all')]).optional(),
      who_can_share_screen_when_someone_is_sharing: z.union([z.literal('host'), z.literal('all')]).optional(),
      workplace_by_facebook: z.boolean().optional(),
    })
    .optional(),
  profile: z
    .object({
      recording_storage_location: z
        .object({
          allowed_values: z.array(z.string()).optional(),
          value: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  recording: z
    .object({
      ask_host_to_confirm_disclaimer: z.boolean().optional(),
      ask_participants_to_consent_disclaimer: z.boolean().optional(),
      auto_delete_cmr: z.boolean().optional(),
      auto_delete_cmr_days: z.number().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      cloud_recording: z.boolean().optional(),
      host_pause_stop_recording: z.boolean().optional(),
      ip_address_access_control: z
        .object({
          enable: z.boolean().optional(),
          ip_addresses_or_ranges: z.string().optional(),
        })
        .optional(),
      local_recording: z.boolean().optional(),
      record_audio_file: z.boolean().optional(),
      record_gallery_view: z.boolean().optional(),
      record_speaker_view: z.boolean().optional(),
      recording_audio_transcript: z.boolean().optional(),
      recording_disclaimer: z.boolean().optional(),
      recording_password_requirement: z
        .object({
          have_letter: z.boolean().optional(),
          have_number: z.boolean().optional(),
          have_special_character: z.boolean().optional(),
          length: z.number().optional(),
          only_allow_numeric: z.boolean().optional(),
        })
        .optional(),
      save_chat_text: z.boolean().optional(),
      show_timestamp: z.boolean().optional(),
    })
    .optional(),
  schedule_meeting: z
    .object({
      audio_type: z
        .union([z.literal('both'), z.literal('telephony'), z.literal('voip'), z.literal('thirdParty')])
        .optional(),
      default_password_for_scheduled_meetings: z.string().optional(),
      embed_password_in_join_link: z.boolean().optional(),
      force_pmi_jbh_password: z.boolean().optional(),
      host_video: z.boolean().optional(),
      join_before_host: z.boolean().optional(),
      meeting_password_requirement: z
        .object({
          consecutive_characters_length: z
            .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
            .optional(),
          have_letter: z.boolean().optional(),
          have_number: z.boolean().optional(),
          have_special_character: z.boolean().optional(),
          have_upper_and_lower_characters: z.boolean().optional(),
          length: z.number().optional(),
          only_allow_numeric: z.boolean().optional(),
          weak_enhance_detection: z.boolean().optional(),
        })
        .optional(),
      participants_video: z.boolean().optional(),
      personal_meeting: z.boolean().optional(),
      pmi_password: z.string().optional(),
      pstn_password_protected: z.boolean().optional(),
      require_password_for_instant_meetings: z.boolean().optional(),
      require_password_for_pmi_meetings: z
        .union([z.literal('jbh_only'), z.literal('all'), z.literal('none')])
        .optional(),
      require_password_for_scheduled_meetings: z.boolean().optional(),
      require_password_for_scheduling_new_meetings: z.boolean().optional(),
      use_pmi_for_instant_meetings: z.boolean().optional(),
      use_pmi_for_scheduled_meetings: z.boolean().optional(),
    })
    .optional(),
  telephony: z
    .object({
      audio_conference_info: z.string().optional(),
      show_international_numbers_link: z.boolean().optional(),
      telephony_regions: z
        .object({
          allowed_values: z.array(z.string()).optional(),
          selection_values: z.array(z.string()).optional(),
        })
        .optional(),
      third_party_audio: z.boolean().optional(),
    })
    .optional(),
  tsp: z
    .object({
      call_out: z.boolean().optional(),
      call_out_countries: z.array(z.unknown()).optional(),
      show_international_numbers_link: z.boolean().optional(),
    })
    .optional(),
});

export const dataCenterRegions2Schema = z.union([
  z.literal('HK'),
  z.literal('AU'),
  z.literal('IN'),
  z.literal('TY'),
  z.literal('CN'),
  z.literal('US'),
  z.literal('CA'),
  z.literal('DE'),
  z.literal('NL'),
  z.literal('LA'),
]);

export const userSettingsEmailNotificationSchema = z.object({
  alternative_host_reminder: z.boolean().optional(),
  cancel_meeting_reminder: z.boolean().optional(),
  jbh_reminder: z.boolean().optional(),
  schedule_for_reminder: z.boolean().optional(),
});

export const userSettingsFeatureSchema = z.object({
  cn_meeting: z.boolean().optional(),
  in_meeting: z.boolean().optional(),
  large_meeting: z.boolean().optional(),
  large_meeting_capacity: z.number().optional(),
  meeting_capacity: z.number().optional(),
  webinar: z.boolean().optional(),
  webinar_capacity: z.number().optional(),
  zoom_phone: z.boolean().optional(),
});

export const userSettingsFeatureUpdateSchema = z.object({
  large_meeting: z.boolean().optional(),
  large_meeting_capacity: z.number().optional(),
  meeting_capacity: z.number().optional(),
  webinar: z.boolean().optional(),
  webinar_capacity: z.number().optional(),
  zoom_phone: z.boolean().optional(),
});

export const userSettingsInMeetingSchema = z.object({
  allow_live_streaming: z.boolean().optional(),
  annotation: z.boolean().optional(),
  attendee_on_hold: z.boolean().optional(),
  auto_saving_chat: z.boolean().optional(),
  breakout_room: z.boolean().optional(),
  chat: z.boolean().optional(),
  closed_caption: z.boolean().optional(),
  co_host: z.boolean().optional(),
  custom_data_center_regions: z.boolean().optional(),
  custom_live_streaming_service: z.boolean().optional(),
  custom_service_instructions: z.string().optional(),
  data_center_regions: z
    .union([
      z.literal('HK'),
      z.literal('AU'),
      z.literal('IN'),
      z.literal('TY'),
      z.literal('CN'),
      z.literal('US'),
      z.literal('CA'),
      z.literal('DE'),
      z.literal('NL'),
      z.literal('LA'),
    ])
    .optional(),
  e2e_encryption: z.boolean().optional(),
  entry_exit_chime: z.union([z.literal('host'), z.literal('all'), z.literal('none')]).optional(),
  far_end_camera_control: z.boolean().optional(),
  feedback: z.boolean().optional(),
  file_transfer: z.boolean().optional(),
  group_hd: z.boolean().optional(),
  non_verbal_feedback: z.boolean().optional(),
  polling: z.boolean().optional(),
  private_chat: z.boolean().optional(),
  record_play_voice: z.boolean().optional(),
  remote_control: z.boolean().optional(),
  remote_support: z.boolean().optional(),
  request_permission_to_unmute: z.boolean().optional(),
  screen_sharing: z.boolean().optional(),
  share_dual_camera: z.boolean().optional(),
  show_meeting_control_toolbar: z.boolean().optional(),
  virtual_background: z.boolean().optional(),
  virtual_background_settings: z
    .object({
      allow_upload_custom: z.boolean().optional(),
      allow_videos: z.boolean().optional(),
      enable: z.boolean().optional(),
      files: z
        .array(
          z.object({
            id: z.string().optional(),
            is_default: z.boolean().optional(),
            name: z.string().optional(),
            size: z.string().optional(),
            type: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  waiting_room: z.boolean().optional(),
  who_can_share_screen: z.union([z.literal('host'), z.literal('all')]).optional(),
  who_can_share_screen_when_someone_is_sharing: z.union([z.literal('host'), z.literal('all')]).optional(),
  workplace_by_facebook: z.boolean().optional(),
});

export const userSettingsRecordingSchema = z.object({
  ask_host_to_confirm_disclaimer: z.boolean().optional(),
  ask_participants_to_consent_disclaimer: z.boolean().optional(),
  auto_delete_cmr: z.boolean().optional(),
  auto_delete_cmr_days: z.number().optional(),
  auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
  cloud_recording: z.boolean().optional(),
  host_pause_stop_recording: z.boolean().optional(),
  ip_address_access_control: z
    .object({
      enable: z.boolean().optional(),
      ip_addresses_or_ranges: z.string().optional(),
    })
    .optional(),
  local_recording: z.boolean().optional(),
  record_audio_file: z.boolean().optional(),
  record_gallery_view: z.boolean().optional(),
  record_speaker_view: z.boolean().optional(),
  recording_audio_transcript: z.boolean().optional(),
  recording_disclaimer: z.boolean().optional(),
  recording_password_requirement: z
    .object({
      have_letter: z.boolean().optional(),
      have_number: z.boolean().optional(),
      have_special_character: z.boolean().optional(),
      length: z.number().optional(),
      only_allow_numeric: z.boolean().optional(),
    })
    .optional(),
  save_chat_text: z.boolean().optional(),
  show_timestamp: z.boolean().optional(),
});

export const userSettingsScheduleMeetingSchema = z.object({
  audio_type: z
    .union([z.literal('both'), z.literal('telephony'), z.literal('voip'), z.literal('thirdParty')])
    .optional(),
  default_password_for_scheduled_meetings: z.string().optional(),
  embed_password_in_join_link: z.boolean().optional(),
  force_pmi_jbh_password: z.boolean().optional(),
  host_video: z.boolean().optional(),
  join_before_host: z.boolean().optional(),
  meeting_password_requirement: z
    .object({
      consecutive_characters_length: z
        .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
        .optional(),
      have_letter: z.boolean().optional(),
      have_number: z.boolean().optional(),
      have_special_character: z.boolean().optional(),
      have_upper_and_lower_characters: z.boolean().optional(),
      length: z.number().optional(),
      only_allow_numeric: z.boolean().optional(),
      weak_enhance_detection: z.boolean().optional(),
    })
    .optional(),
  participants_video: z.boolean().optional(),
  personal_meeting: z.boolean().optional(),
  pmi_password: z.string().optional(),
  pstn_password_protected: z.boolean().optional(),
  require_password_for_instant_meetings: z.boolean().optional(),
  require_password_for_pmi_meetings: z.union([z.literal('jbh_only'), z.literal('all'), z.literal('none')]).optional(),
  require_password_for_scheduled_meetings: z.boolean().optional(),
  require_password_for_scheduling_new_meetings: z.boolean().optional(),
  use_pmi_for_instant_meetings: z.boolean().optional(),
  use_pmi_for_scheduled_meetings: z.boolean().optional(),
});

export const userSettingsTSPSchema = z.object({
  call_out: z.boolean().optional(),
  call_out_countries: z.array(z.unknown()).optional(),
  show_international_numbers_link: z.boolean().optional(),
});

export const userSettingsTelephonySchema = z.object({
  audio_conference_info: z.string().optional(),
  show_international_numbers_link: z.boolean().optional(),
  telephony_regions: z
    .object({
      allowed_values: z.array(z.string()).optional(),
      selection_values: z.array(z.string()).optional(),
    })
    .optional(),
  third_party_audio: z.boolean().optional(),
});

export const userSettingsUpdateSchema = z.object({
  email_notification: z
    .object({
      alternative_host_reminder: z.boolean().optional(),
      cancel_meeting_reminder: z.boolean().optional(),
      jbh_reminder: z.boolean().optional(),
      schedule_for_reminder: z.boolean().optional(),
    })
    .optional(),
  feature: z
    .object({
      large_meeting: z.boolean().optional(),
      large_meeting_capacity: z.number().optional(),
      meeting_capacity: z.number().optional(),
      webinar: z.boolean().optional(),
      webinar_capacity: z.number().optional(),
      zoom_phone: z.boolean().optional(),
    })
    .optional(),
  in_meeting: z
    .object({
      allow_live_streaming: z.boolean().optional(),
      annotation: z.boolean().optional(),
      attendee_on_hold: z.boolean().optional(),
      auto_saving_chat: z.boolean().optional(),
      breakout_room: z.boolean().optional(),
      chat: z.boolean().optional(),
      closed_caption: z.boolean().optional(),
      co_host: z.boolean().optional(),
      custom_data_center_regions: z.boolean().optional(),
      custom_live_streaming_service: z.boolean().optional(),
      custom_service_instructions: z.string().optional(),
      data_center_regions: z
        .union([
          z.literal('HK'),
          z.literal('AU'),
          z.literal('IN'),
          z.literal('TY'),
          z.literal('CN'),
          z.literal('US'),
          z.literal('CA'),
          z.literal('DE'),
          z.literal('NL'),
          z.literal('LA'),
        ])
        .optional(),
      e2e_encryption: z.boolean().optional(),
      entry_exit_chime: z.union([z.literal('host'), z.literal('all'), z.literal('none')]).optional(),
      far_end_camera_control: z.boolean().optional(),
      feedback: z.boolean().optional(),
      file_transfer: z.boolean().optional(),
      group_hd: z.boolean().optional(),
      non_verbal_feedback: z.boolean().optional(),
      polling: z.boolean().optional(),
      private_chat: z.boolean().optional(),
      record_play_voice: z.boolean().optional(),
      remote_control: z.boolean().optional(),
      remote_support: z.boolean().optional(),
      request_permission_to_unmute: z.boolean().optional(),
      screen_sharing: z.boolean().optional(),
      share_dual_camera: z.boolean().optional(),
      show_meeting_control_toolbar: z.boolean().optional(),
      virtual_background: z.boolean().optional(),
      virtual_background_settings: z
        .object({
          allow_upload_custom: z.boolean().optional(),
          allow_videos: z.boolean().optional(),
          enable: z.boolean().optional(),
          files: z
            .array(
              z.object({
                id: z.string().optional(),
                is_default: z.boolean().optional(),
                name: z.string().optional(),
                size: z.string().optional(),
                type: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      waiting_room: z.boolean().optional(),
      who_can_share_screen: z.union([z.literal('host'), z.literal('all')]).optional(),
      who_can_share_screen_when_someone_is_sharing: z.union([z.literal('host'), z.literal('all')]).optional(),
      workplace_by_facebook: z.boolean().optional(),
    })
    .optional(),
  profile: z
    .object({
      recording_storage_location: z
        .object({
          allowed_values: z.array(z.string()).optional(),
          value: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  recording: z
    .object({
      ask_host_to_confirm_disclaimer: z.boolean().optional(),
      ask_participants_to_consent_disclaimer: z.boolean().optional(),
      auto_delete_cmr: z.boolean().optional(),
      auto_delete_cmr_days: z.number().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      cloud_recording: z.boolean().optional(),
      host_pause_stop_recording: z.boolean().optional(),
      ip_address_access_control: z
        .object({
          enable: z.boolean().optional(),
          ip_addresses_or_ranges: z.string().optional(),
        })
        .optional(),
      local_recording: z.boolean().optional(),
      record_audio_file: z.boolean().optional(),
      record_gallery_view: z.boolean().optional(),
      record_speaker_view: z.boolean().optional(),
      recording_audio_transcript: z.boolean().optional(),
      recording_disclaimer: z.boolean().optional(),
      recording_password_requirement: z
        .object({
          have_letter: z.boolean().optional(),
          have_number: z.boolean().optional(),
          have_special_character: z.boolean().optional(),
          length: z.number().optional(),
          only_allow_numeric: z.boolean().optional(),
        })
        .optional(),
      save_chat_text: z.boolean().optional(),
      show_timestamp: z.boolean().optional(),
    })
    .optional(),
  schedule_meeting: z
    .object({
      audio_type: z
        .union([z.literal('both'), z.literal('telephony'), z.literal('voip'), z.literal('thirdParty')])
        .optional(),
      default_password_for_scheduled_meetings: z.string().optional(),
      embed_password_in_join_link: z.boolean().optional(),
      force_pmi_jbh_password: z.boolean().optional(),
      host_video: z.boolean().optional(),
      join_before_host: z.boolean().optional(),
      meeting_password_requirement: z
        .object({
          consecutive_characters_length: z
            .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
            .optional(),
          have_letter: z.boolean().optional(),
          have_number: z.boolean().optional(),
          have_special_character: z.boolean().optional(),
          have_upper_and_lower_characters: z.boolean().optional(),
          length: z.number().optional(),
          only_allow_numeric: z.boolean().optional(),
          weak_enhance_detection: z.boolean().optional(),
        })
        .optional(),
      participants_video: z.boolean().optional(),
      personal_meeting: z.boolean().optional(),
      pmi_password: z.string().optional(),
      pstn_password_protected: z.boolean().optional(),
      require_password_for_instant_meetings: z.boolean().optional(),
      require_password_for_pmi_meetings: z
        .union([z.literal('jbh_only'), z.literal('all'), z.literal('none')])
        .optional(),
      require_password_for_scheduled_meetings: z.boolean().optional(),
      require_password_for_scheduling_new_meetings: z.boolean().optional(),
      use_pmi_for_instant_meetings: z.boolean().optional(),
      use_pmi_for_scheduled_meetings: z.boolean().optional(),
    })
    .optional(),
  telephony: z
    .object({
      audio_conference_info: z.string().optional(),
      show_international_numbers_link: z.boolean().optional(),
      telephony_regions: z
        .object({
          selection_values: z.array(z.string()).optional(),
        })
        .optional(),
      third_party_audio: z.boolean().optional(),
    })
    .optional(),
  tsp: z
    .object({
      call_out: z.boolean().optional(),
      call_out_countries: z.array(z.unknown()).optional(),
      show_international_numbers_link: z.boolean().optional(),
    })
    .optional(),
});

export const userUpdateSchema = z.object({
  cms_user_id: z.string().optional(),
  company: z.string().optional(),
  custom_attributes: z
    .object({
      key: z.string().optional(),
      name: z.string().optional(),
      value: z.string().optional(),
    })
    .optional(),
  dept: z.string().optional(),
  first_name: z.string().optional(),
  group_id: z.string().optional(),
  host_key: z.string().optional(),
  job_title: z.string().optional(),
  language: z.string().optional(),
  last_name: z.string().optional(),
  location: z.string().optional(),
  manager: z.string().optional(),
  phone_country: z.string().optional(),
  phone_number: z.string().optional(),
  phone_numbers: z
    .object({
      code: z.string().optional(),
      country: z.string().optional(),
      number: z.string().optional(),
    })
    .optional(),
  pmi: z.number().optional(),
  timezone: z.string().optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(99)]).optional(),
  use_pmi: z.boolean().optional(),
  vanity_name: z.string().optional(),
});

export const webinarSchema = z.object({
  agenda: z.string().optional(),
  duration: z.number().optional(),
  password: z.string().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z.string().optional(),
    })
    .optional(),
  settings: z
    .object({
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      attendees_and_panelists_reminder_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_name: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      close_registration: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      email_language: z.string().optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      follow_up_absentees_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      follow_up_attendees_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      hd_video: z.boolean().optional(),
      host_video: z.boolean().optional(),
      meeting_authentication: z.boolean().optional(),
      notify_registrants: z.boolean().optional(),
      on_demand: z.boolean().optional(),
      panelists_invitation_email_notification: z.boolean().optional(),
      panelists_video: z.boolean().optional(),
      post_webinar_survey: z.boolean().optional(),
      practice_session: z.boolean().optional(),
      question_and_answer: z
        .object({
          allow_anonymous_questions: z.boolean().optional(),
          answer_questions: z.union([z.literal('only'), z.literal('all')]).optional(),
          attendees_can_comment: z.boolean().optional(),
          attendees_can_upvote: z.boolean().optional(),
          enable: z.boolean().optional(),
        })
        .optional(),
      registrants_confirmation_email: z.boolean().optional(),
      registrants_email_notification: z.boolean().optional(),
      registrants_restrict_number: z.number().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      survey_url: z.string().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(5), z.literal(6), z.literal(9)]).optional(),
});

export const webinarInfoSchema = z.object({
  agenda: z.string().optional(),
  created_at: z.string().optional(),
  duration: z.number().optional(),
  join_url: z.string().optional(),
  occurrences: z
    .array(
      z.object({
        duration: z.number().optional(),
        occurrence_id: z.string().optional(),
        start_time: z.string().optional(),
        status: z.string().optional(),
      }),
    )
    .optional(),
  password: z.string().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z.string().optional(),
    })
    .optional(),
  settings: z
    .object({
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      attendees_and_panelists_reminder_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_name: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      close_registration: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      email_language: z.string().optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      follow_up_absentees_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      follow_up_attendees_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      hd_video: z.boolean().optional(),
      host_video: z.boolean().optional(),
      meeting_authentication: z.boolean().optional(),
      notify_registrants: z.boolean().optional(),
      on_demand: z.boolean().optional(),
      panelists_invitation_email_notification: z.boolean().optional(),
      panelists_video: z.boolean().optional(),
      post_webinar_survey: z.boolean().optional(),
      practice_session: z.boolean().optional(),
      question_and_answer: z
        .object({
          allow_anonymous_questions: z.boolean().optional(),
          answer_questions: z.union([z.literal('only'), z.literal('all')]).optional(),
          attendees_can_comment: z.boolean().optional(),
          attendees_can_upvote: z.boolean().optional(),
          enable: z.boolean().optional(),
        })
        .optional(),
      registrants_confirmation_email: z.boolean().optional(),
      registrants_email_notification: z.boolean().optional(),
      registrants_restrict_number: z.number().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      survey_url: z.string().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  start_url: z.string().optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(5), z.literal(6), z.literal(9)]).optional(),
});

export const webinarInstancesSchema = z.object({
  webinars: z
    .array(
      z.object({
        start_time: z.string().optional(),
        uuid: z.string().optional(),
      }),
    )
    .optional(),
});

export const webinarListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      webinars: z
        .array(
          z.object({
            agenda: z.string().optional(),
            created_at: z.string().optional(),
            duration: z.number().optional(),
            host_id: z.string().optional(),
            id: z.number().optional(),
            join_url: z.string().optional(),
            start_time: z.string().optional(),
            timezone: z.string().optional(),
            topic: z.string().optional(),
            type: z.string().optional(),
            uuid: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const webinarMetricSchema = z.object({
  custom_keys: z
    .array(
      z.object({
        key: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  dept: z.string().optional(),
  duration: z.string().optional(),
  email: z.string().optional(),
  end_time: z.string().optional(),
  has_3rd_party_audio: z.boolean().optional(),
  has_pstn: z.boolean().optional(),
  has_recording: z.boolean().optional(),
  has_screen_share: z.boolean().optional(),
  has_sip: z.boolean().optional(),
  has_video: z.boolean().optional(),
  has_voip: z.boolean().optional(),
  host: z.string().optional(),
  id: z.number().optional(),
  participants: z.number().optional(),
  start_time: z.string().optional(),
  topic: z.string().optional(),
  user_type: z.string().optional(),
  uuid: z.string().optional(),
});

export const webinarPanelistSchema = z.object({
  panelists: z
    .array(
      z.object({
        email: z.string().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
});

export const webinarPanelistListSchema = z.object({
  panelists: z
    .array(
      z
        .object({
          id: z.string().optional(),
        })
        .and(
          z.object({
            email: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .and(
          z.object({
            join_url: z.string().optional(),
          }),
        ),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const webinarRegistrantSchema = z.object({
  address: z.string().optional(),
  city: z.string().optional(),
  comments: z.string().optional(),
  country: z.string().optional(),
  custom_questions: z
    .array(
      z.object({
        title: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  email: z.string(),
  first_name: z.string(),
  industry: z.string().optional(),
  job_title: z.string().optional(),
  last_name: z.string().optional(),
  no_of_employees: z.string().optional(),
  org: z.string().optional(),
  phone: z.string().optional(),
  purchasing_time_frame: z.string().optional(),
  role_in_purchase_process: z.string().optional(),
  state: z.string().optional(),
  zip: z.string().optional(),
});

export const webinarRegistrantListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      registrants: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z.object({
                address: z.string().optional(),
                city: z.string().optional(),
                comments: z.string().optional(),
                country: z.string().optional(),
                custom_questions: z
                  .array(
                    z.object({
                      title: z.string().optional(),
                      value: z.string().optional(),
                    }),
                  )
                  .optional(),
                email: z.string(),
                first_name: z.string(),
                industry: z.string().optional(),
                job_title: z.string().optional(),
                last_name: z.string().optional(),
                no_of_employees: z.string().optional(),
                org: z.string().optional(),
                phone: z.string().optional(),
                purchasing_time_frame: z.string().optional(),
                role_in_purchase_process: z.string().optional(),
                state: z.string().optional(),
                zip: z.string().optional(),
              }),
            )
            .and(
              z.object({
                create_time: z.string().optional(),
                join_url: z.string().optional(),
                status: z.string().optional(),
              }),
            ),
        )
        .optional(),
    }),
  );

export const webinarRegistrantQuestionsSchema = z.object({
  custom_questions: z
    .array(
      z.object({
        answers: z.array(z.string()).optional(),
        required: z.boolean().optional(),
        title: z.string().optional(),
        type: z
          .union([z.literal('short'), z.literal('single_radio'), z.literal('single_dropdown'), z.literal('multiple')])
          .optional(),
      }),
    )
    .optional(),
  questions: z
    .array(
      z.object({
        field_name: z
          .union([
            z.literal('last_name'),
            z.literal('address'),
            z.literal('city'),
            z.literal('country'),
            z.literal('zip'),
            z.literal('state'),
            z.literal('phone'),
            z.literal('industry'),
            z.literal('org'),
            z.literal('job_title'),
            z.literal('purchasing_time_frame'),
            z.literal('role_in_purchase_process'),
            z.literal('no_of_employees'),
            z.literal('comments'),
          ])
          .optional(),
        required: z.boolean().optional(),
      }),
    )
    .optional(),
});

export const webinarSettingsSchema = z.object({
  allow_multiple_devices: z.boolean().optional(),
  alternative_hosts: z.string().optional(),
  approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
  attendees_and_panelists_reminder_email_notification: z
    .object({
      enable: z.boolean().optional(),
      type: z
        .union([
          z.literal(0),
          z.literal(1),
          z.literal(2),
          z.literal(3),
          z.literal(4),
          z.literal(5),
          z.literal(6),
          z.literal(7),
        ])
        .optional(),
    })
    .optional(),
  audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
  authentication_domains: z.string().optional(),
  authentication_name: z.string().optional(),
  authentication_option: z.string().optional(),
  auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
  close_registration: z.boolean().optional(),
  contact_email: z.string().optional(),
  contact_name: z.string().optional(),
  email_language: z.string().optional(),
  enforce_login: z.boolean().optional(),
  enforce_login_domains: z.string().optional(),
  follow_up_absentees_email_notification: z
    .object({
      enable: z.boolean().optional(),
      type: z
        .union([
          z.literal(0),
          z.literal(1),
          z.literal(2),
          z.literal(3),
          z.literal(4),
          z.literal(5),
          z.literal(6),
          z.literal(7),
        ])
        .optional(),
    })
    .optional(),
  follow_up_attendees_email_notification: z
    .object({
      enable: z.boolean().optional(),
      type: z
        .union([
          z.literal(0),
          z.literal(1),
          z.literal(2),
          z.literal(3),
          z.literal(4),
          z.literal(5),
          z.literal(6),
          z.literal(7),
        ])
        .optional(),
    })
    .optional(),
  global_dial_in_countries: z.array(z.string()).optional(),
  hd_video: z.boolean().optional(),
  host_video: z.boolean().optional(),
  meeting_authentication: z.boolean().optional(),
  notify_registrants: z.boolean().optional(),
  on_demand: z.boolean().optional(),
  panelists_invitation_email_notification: z.boolean().optional(),
  panelists_video: z.boolean().optional(),
  post_webinar_survey: z.boolean().optional(),
  practice_session: z.boolean().optional(),
  question_and_answer: z
    .object({
      allow_anonymous_questions: z.boolean().optional(),
      answer_questions: z.union([z.literal('only'), z.literal('all')]).optional(),
      attendees_can_comment: z.boolean().optional(),
      attendees_can_upvote: z.boolean().optional(),
      enable: z.boolean().optional(),
    })
    .optional(),
  registrants_confirmation_email: z.boolean().optional(),
  registrants_email_notification: z.boolean().optional(),
  registrants_restrict_number: z.number().optional(),
  registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
  show_share_button: z.boolean().optional(),
  survey_url: z.string().optional(),
});

export const webinarUpdateSchema = z.object({
  agenda: z.string().optional(),
  duration: z.number().optional(),
  password: z.string().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z
        .union([
          z.literal('1'),
          z.literal('2'),
          z.literal('3'),
          z.literal('4'),
          z.literal('5'),
          z.literal('6'),
          z.literal('7'),
        ])
        .optional(),
    })
    .optional(),
  settings: z
    .object({
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      attendees_and_panelists_reminder_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_name: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      close_registration: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      email_language: z.string().optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      follow_up_absentees_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      follow_up_attendees_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      hd_video: z.boolean().optional(),
      host_video: z.boolean().optional(),
      meeting_authentication: z.boolean().optional(),
      notify_registrants: z.boolean().optional(),
      on_demand: z.boolean().optional(),
      panelists_invitation_email_notification: z.boolean().optional(),
      panelists_video: z.boolean().optional(),
      post_webinar_survey: z.boolean().optional(),
      practice_session: z.boolean().optional(),
      question_and_answer: z
        .object({
          allow_anonymous_questions: z.boolean().optional(),
          answer_questions: z.union([z.literal('only'), z.literal('all')]).optional(),
          attendees_can_comment: z.boolean().optional(),
          attendees_can_upvote: z.boolean().optional(),
          enable: z.boolean().optional(),
        })
        .optional(),
      registrants_confirmation_email: z.boolean().optional(),
      registrants_email_notification: z.boolean().optional(),
      registrants_restrict_number: z.number().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      survey_url: z.string().optional(),
    })
    .and(
      z.object({
        registrants_confirmation_email: z.boolean().optional(),
      }),
    )
    .optional(),
  start_time: z.string().optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(5), z.literal(6), z.literal(9)]).optional(),
});

export const zoomRoomSchema = z.object({
  account_type: z.string().optional(),
  calender_name: z.string().optional(),
  camera: z.string().optional(),
  device_ip: z.string().optional(),
  email: z.string().optional(),
  health: z.string().optional(),
  id: z.string().optional(),
  issues: z.array(z.string()).optional(),
  last_start_time: z.string().optional(),
  location: z.string().optional(),
  microphone: z.string().optional(),
  room_name: z.string().optional(),
  speaker: z.string().optional(),
  status: z.string().optional(),
});

export const zoomRoomListSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      zoom_rooms: z
        .array(
          z.object({
            account_type: z.string().optional(),
            calender_name: z.string().optional(),
            camera: z.string().optional(),
            device_ip: z.string().optional(),
            email: z.string().optional(),
            health: z.string().optional(),
            id: z.string().optional(),
            issues: z.array(z.string()).optional(),
            last_start_time: z.string().optional(),
            location: z.string().optional(),
            microphone: z.string().optional(),
            room_name: z.string().optional(),
            speaker: z.string().optional(),
            status: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const authenticationusersettingsSchema = z.union([
  z.object({
    authentication_option: z
      .object({
        action: z.union([z.literal('update'), z.literal('delete'), z.literal('add')]).optional(),
        default_option: z.boolean().optional(),
        domains: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        type: z.union([z.literal('enforce_login'), z.literal('enforce_login_with_domains')]).optional(),
      })
      .optional(),
    meeting_authentication: z.boolean().optional(),
  }),
  z.object({
    authentication_option: z
      .object({
        action: z.union([z.literal('update'), z.literal('delete'), z.literal('add')]).optional(),
        default_option: z.boolean().optional(),
        domains: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        type: z
          .union([z.literal('internally'), z.literal('enforce_login'), z.literal('enforce_login_with_domains')])
          .optional(),
      })
      .optional(),
    recording_authentication: z.boolean().optional(),
  }),
]);

export const type8Schema = z.union([z.literal('enforce_login'), z.literal('enforce_login_with_domains')]);

export const createWebinarSchema = z.object({
  agenda: z.string().optional(),
  duration: z.number().optional(),
  password: z.string().optional(),
  recurrence: z
    .object({
      end_date_time: z.string().optional(),
      end_times: z.number().optional(),
      monthly_day: z.number().optional(),
      monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
      monthly_week_day: z
        .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
        .optional(),
      repeat_interval: z.number().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
      weekly_days: z.string().optional(),
    })
    .optional(),
  settings: z
    .object({
      allow_multiple_devices: z.boolean().optional(),
      alternative_hosts: z.string().optional(),
      approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
      attendees_and_panelists_reminder_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
      authentication_domains: z.string().optional(),
      authentication_option: z.string().optional(),
      auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
      close_registration: z.boolean().optional(),
      contact_email: z.string().optional(),
      contact_name: z.string().optional(),
      email_language: z.string().optional(),
      enforce_login: z.boolean().optional(),
      enforce_login_domains: z.string().optional(),
      follow_up_absentees_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      follow_up_attendees_email_notification: z
        .object({
          enable: z.boolean().optional(),
          type: z
            .union([
              z.literal(0),
              z.literal(1),
              z.literal(2),
              z.literal(3),
              z.literal(4),
              z.literal(5),
              z.literal(6),
              z.literal(7),
            ])
            .optional(),
        })
        .optional(),
      global_dial_in_countries: z.array(z.string()).optional(),
      hd_video: z.boolean().optional(),
      host_video: z.boolean().optional(),
      meeting_authentication: z.boolean().optional(),
      on_demand: z.boolean().optional(),
      panelists_invitation_email_notification: z.boolean().optional(),
      panelists_video: z.boolean().optional(),
      post_webinar_survey: z.boolean().optional(),
      practice_session: z.boolean().optional(),
      question_and_answer: z
        .object({
          allow_anonymous_questions: z.boolean().optional(),
          answer_questions: z.union([z.literal('only'), z.literal('all')]).optional(),
          attendees_can_comment: z.boolean().optional(),
          attendees_can_upvote: z.boolean().optional(),
          enable: z.boolean().optional(),
        })
        .optional(),
      registrants_email_notification: z.boolean().optional(),
      registrants_restrict_number: z.number().optional(),
      registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
      show_share_button: z.boolean().optional(),
      survey_url: z.string().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  timezone: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.union([z.literal(5), z.literal(6), z.literal(9)]).optional(),
});

export const listmeetingmetricsSchema = z.object({
  custom_keys: z
    .array(
      z.object({
        key: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  dept: z.string().optional(),
  duration: z.string().optional(),
  email: z.string().optional(),
  end_time: z.string().optional(),
  has_3rd_party_audio: z.boolean().optional(),
  has_pstn: z.boolean().optional(),
  has_recording: z.boolean().optional(),
  has_screen_share: z.boolean().optional(),
  has_sip: z.boolean().optional(),
  has_video: z.boolean().optional(),
  has_voip: z.boolean().optional(),
  host: z.string().optional(),
  id: z.number().optional(),
  in_room_participants: z.number().optional(),
  participants: z.number().optional(),
  start_time: z.string().optional(),
  topic: z.string().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  user_type: z.string().optional(),
  uuid: z.string().optional(),
});

export const recurrenceWebinarSchema = z.object({
  end_date_time: z.string().optional(),
  end_times: z.number().optional(),
  monthly_day: z.number().optional(),
  monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
  monthly_week_day: z
    .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
    .optional(),
  repeat_interval: z.number().optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
  weekly_days: z.string().optional(),
});

export const tspGlobalDialInSchema = z.object({
  audio_url: z.string().optional(),
});

export const parameterAccountIdSchema = z.string();

export const parameterDeviceIdSchema = z.string();

export const parameterFeedbackIdSchema = z.string();

export const parameterFromDateSchema = z.string();

export const parameterGroupIdSchema = z.string();

export const parameterLoginTypeSchema = z.union([
  z.literal('0'),
  z.literal('1'),
  z.literal('99'),
  z.literal('100'),
  z.literal('101'),
]);

export const parameterMcSchema = z.string();

export const parameterMeetingIdSchema = z.number();

export const parameterMeetingId4MetricsSchema = z.string();

export const parameterMeetingId4RecordingSchema = z.string();

export const parameterMeetingIdNumberSchema = z.string();

export const parameterMeetingTypeSchema = z.union([z.literal('scheduled'), z.literal('live'), z.literal('upcoming')]);

export const parameterMeetingTypePastSchema = z.union([z.literal('past'), z.literal('pastOne'), z.literal('live')]);

export const parameterMeetingTypePast2Schema = z.union([z.literal('past'), z.literal('pastOne'), z.literal('live')]);

export const parameterMeetingTypePast3Schema = z.union([z.literal('past'), z.literal('pastOne'), z.literal('live')]);

export const parameterMeetingUUIDSchema = z.string();

export const parameterMemberIdSchema = z.string();

export const parameterNextPageTokenSchema = z.string();

export const parameterOccurrenceIdSchema = z.string();

export const parameterPageNumberSchema = z.number();

export const parameterPageSizeSchema = z.number();

export const parameterPageSize4QosSchema = z.number();

export const parameterPageTokenSchema = z.string();

export const parameterParticipantIdSchema = z.string();

export const parameterRecordingDeleteActionSchema = z.union([z.literal('trash'), z.literal('delete')]);

export const parameterRecordingIdSchema = z.string();

export const parameterRegistrantIdSchema = z.string();

export const parameterRegistrantStatusSchema = z.union([
  z.literal('pending'),
  z.literal('approved'),
  z.literal('denied'),
]);

export const parameterRoleIdSchema = z.string();

export const parameterSessionIdSchema = z.string();

export const parameterTSPIdSchema = z.union([z.literal(1), z.literal(2)]);

export const parameterToDateSchema = z.string();

export const parameterTrackingSourceIdSchema = z.string();

export const parameterTransferEmailSchema = z.string();

export const parameterTransferMeetingSchema = z.boolean();

export const parameterTransferRecordingSchema = z.boolean();

export const parameterTransferWebinarSchema = z.boolean();

export const parameterTrashSchema = z.boolean();

export const parameterUserIdSchema = z.string();

export const parameterWebhookIdSchema = z.string();

export const parameterWebinarIdSchema = z.number();

export const parameterWebinarId4MetricsSchema = z.string();

export const parameterWebinarTypePastSchema = z.union([z.literal('past'), z.literal('live')]);

export const parameterWebinarTypePast2Schema = z.union([z.literal('past'), z.literal('live')]);

export const parameterWebinarUUIDSchema = z.string();

export const parameterZoomRoomIdSchema = z.string();

export const parametertrashTypeSchema = z.string();

export const accountsDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_number: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const accountsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      accounts: z
        .array(
          z.object({
            account_name: z.string().optional(),
            account_number: z.string().optional(),
            account_type: z.string().optional(),
            created_at: z.string().optional(),
            id: z.string().optional(),
            owner_email: z.string().optional(),
            seats: z.number().optional(),
            subscription_end_time: z.string().optional(),
            subscription_start_time: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const accountsErrorSchema = z.unknown();

export const accountCreateDataSchema = z.object({
  body: z.object({
    account_name: z.string().optional(),
    email: z.string(),
    first_name: z.string(),
    last_name: z.string(),
    options: z
      .object({
        billing_auto_renew: z.boolean().optional(),
        meeting_connector_list: z.array(z.string()).optional(),
        pay_mode: z.union([z.literal('master'), z.literal('sub')]).optional(),
        room_connector_list: z.array(z.string()).optional(),
        share_mc: z.boolean().optional(),
        share_rc: z.boolean().optional(),
      })
      .optional(),
    password: z.string(),
  }),
});

export const accountCreateResponseSchema = z.object({
  created_at: z.string().optional(),
  id: z.string().optional(),
  owner_email: z.string().optional(),
  owner_id: z.string().optional(),
});

export const accountCreateErrorSchema = z.unknown();

export const accountDisassociateDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountDisassociateResponseSchema = z.any();

export const accountDisassociateErrorSchema = z.unknown();

export const accountDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountResponseSchema = z.object({
  created_at: z.string().optional(),
  id: z.string().optional(),
  options: z
    .object({
      billing_auto_renew: z.boolean().optional(),
      meeting_connector_list: z.array(z.string()).optional(),
      pay_mode: z.union([z.literal('master'), z.literal('sub')]).optional(),
      room_connector_list: z.array(z.string()).optional(),
      share_mc: z.boolean().optional(),
      share_rc: z.boolean().optional(),
    })
    .optional(),
  owner_email: z.string().optional(),
  owner_id: z.string().optional(),
  vanity_url: z.string().optional(),
});

export const accountErrorSchema = z.unknown();

export const accountBillingDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountBillingResponseSchema = z.object({
  address: z.string(),
  apt: z.string().optional(),
  city: z.string(),
  country: z.string(),
  email: z.string(),
  first_name: z.string(),
  last_name: z.string(),
  phone_number: z.string(),
  state: z.string(),
  zip: z.string(),
});

export const accountBillingErrorSchema = z.unknown();

export const accountBillingUpdateDataSchema = z.object({
  body: z.object({
    address: z.string().optional(),
    apt: z.string().optional(),
    city: z.string().optional(),
    country: z.string().optional(),
    email: z.string().optional(),
    first_name: z.string().optional(),
    last_name: z.string().optional(),
    phone_number: z.string().optional(),
    state: z.string().optional(),
    zip: z.string().optional(),
  }),
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountBillingUpdateResponseSchema = z.union([z.unknown(), z.any()]);

export const accountBillingUpdateErrorSchema = z.unknown();

export const accountBillingInvoicesDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
  query: z
    .object({
      from: z.string().optional(),
      to: z.string().optional(),
    })
    .optional(),
});

export const accountBillingInvoicesResponseSchema = z.object({
  currency: z.string().optional(),
  invoices: z
    .array(
      z.object({
        balance: z.number().optional(),
        due_date: z.string().optional(),
        id: z.string().optional(),
        invoice_date: z.string().optional(),
        invoice_number: z.string().optional(),
        status: z.string().optional(),
        target_date: z.string().optional(),
        tax_amount: z.number().optional(),
        total_amount: z.number().optional(),
      }),
    )
    .optional(),
});

export const accountBillingInvoicesErrorSchema = z.unknown();

export const getAccountBillingInvoiceDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
    invoiceId: z.string(),
  }),
});

export const getAccountBillingInvoiceResponseSchema = z.object({
  balance: z.number().optional(),
  currency: z.string().optional(),
  due_date: z.string().optional(),
  id: z.string().optional(),
  invoice_date: z.string().optional(),
  invoice_items: z
    .array(
      z.object({
        charge_name: z.string().optional(),
        charge_number: z.string().optional(),
        charge_type: z.string().optional(),
        end_date: z.string().optional(),
        quantity: z.number().optional(),
        start_date: z.string().optional(),
        tax_amount: z.number().optional(),
        total_amount: z.number().optional(),
      }),
    )
    .optional(),
  invoice_number: z.string().optional(),
  status: z.string().optional(),
  target_date: z.string().optional(),
  tax_amount: z.number().optional(),
  total_amount: z.number().optional(),
});

export const getAccountBillingInvoiceErrorSchema = z.unknown();

export const getAccountLockSettingsDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
  query: z
    .object({
      custom_query_fields: z.string().optional(),
      option: z.string().optional(),
    })
    .optional(),
});

export const getAccountLockSettingsResponseSchema = z.union([
  z.object({
    email_notification: z
      .object({
        alternative_host_reminder: z.boolean().optional(),
        cancel_meeting_reminder: z.boolean().optional(),
        cloud_recording_available_reminder: z.boolean().optional(),
        jbh_reminder: z.boolean().optional(),
        schedule_for_host_reminder: z.boolean().optional(),
      })
      .optional(),
    in_meeting: z
      .object({
        alert_guest_join: z.boolean().optional(),
        allow_show_zoom_windows: z.boolean().optional(),
        annotation: z.boolean().optional(),
        anonymous_question_answer: z.boolean().optional(),
        attendee_on_hold: z.boolean().optional(),
        auto_answer: z.boolean().optional(),
        auto_saving_chat: z.boolean().optional(),
        breakout_room: z.boolean().optional(),
        chat: z.boolean().optional(),
        closed_caption: z.boolean().optional(),
        co_host: z.boolean().optional(),
        custom_data_center_regions: z.boolean().optional(),
        dscp_marking: z.boolean().optional(),
        e2e_encryption: z.boolean().optional(),
        entry_exit_chime: z.string().optional(),
        far_end_camera_control: z.boolean().optional(),
        feedback: z.boolean().optional(),
        file_transfer: z.boolean().optional(),
        group_hd: z.boolean().optional(),
        original_audio: z.boolean().optional(),
        polling: z.boolean().optional(),
        post_meeting_feedback: z.boolean().optional(),
        private_chat: z.boolean().optional(),
        remote_control: z.boolean().optional(),
        request_permission_to_unmute: z.boolean().optional(),
        screen_sharing: z.boolean().optional(),
        sending_default_email_invites: z.boolean().optional(),
        show_meeting_control_toolbar: z.boolean().optional(),
        stereo_audio: z.boolean().optional(),
        use_html_format_email: z.boolean().optional(),
        virtual_background: z.boolean().optional(),
        webinar_question_answer: z.boolean().optional(),
        whiteboard: z.boolean().optional(),
      })
      .optional(),
    recording: z
      .object({
        account_user_access_recording: z.boolean().optional(),
        auto_delete_cmr: z.boolean().optional(),
        auto_recording: z.string().optional(),
        cloud_recording: z.boolean().optional(),
        cloud_recording_download: z.boolean().optional(),
        host_delete_cloud_recording: z.boolean().optional(),
        ip_address_access_control: z
          .object({
            enable: z.boolean().optional(),
            ip_addresses_or_ranges: z.string().optional(),
          })
          .optional(),
        local_recording: z.boolean().optional(),
        prevent_host_access_recording: z.boolean().optional(),
        recording_authentication: z.string().optional(),
      })
      .optional(),
    schedule_meeting: z
      .object({
        audio_type: z.boolean().optional(),
        embed_password_in_join_link: z.boolean().optional(),
        enforce_login: z.boolean().optional(),
        enforce_login_domains: z.string().optional(),
        enforce_login_with_domains: z.boolean().optional(),
        host_video: z.boolean().optional(),
        join_before_host: z.boolean().optional(),
        meeting_authentication: z.boolean().optional(),
        not_store_meeting_topic: z.boolean().optional(),
        participant_video: z.boolean().optional(),
        require_password_for_instant_meetings: z.boolean().optional(),
        require_password_for_pmi_meetings: z.boolean().optional(),
        require_password_for_scheduling_new_meetings: z.boolean().optional(),
      })
      .optional(),
    telephony: z
      .object({
        telephony_regions: z.boolean().optional(),
        third_party_audio: z.boolean().optional(),
      })
      .optional(),
    tsp: z
      .object({
        call_out: z.boolean().optional(),
        show_international_numbers_link: z.boolean().optional(),
      })
      .optional(),
  }),
  z.object({
    meeting_security: z
      .object({
        auto_security: z.boolean().optional(),
        embed_password_in_join_link: z.boolean().optional(),
        encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
        end_to_end_encrypted_meetings: z.boolean().optional(),
        meeting_password: z.boolean().optional(),
        meeting_password_requirement: z
          .object({
            consecutive_characters_length: z
              .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
              .optional(),
            have_letter: z.boolean().optional(),
            have_number: z.boolean().optional(),
            have_special_character: z.boolean().optional(),
            have_upper_and_lower_characters: z.boolean().optional(),
            length: z.number().optional(),
            only_allow_numeric: z.boolean().optional(),
            weak_enhance_detection: z.boolean().optional(),
          })
          .optional(),
        phone_password: z.boolean().optional(),
        pmi_password: z.boolean().optional(),
        require_password_for_scheduled_meeting: z.boolean().optional(),
        require_password_for_scheduled_webinar: z.boolean().optional(),
        waiting_room: z.boolean().optional(),
        waiting_room_settings: z
          .object({
            participants_to_place_in_waiting_room: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
            users_who_can_admit_participants_from_waiting_room: z.number().optional(),
            whitelisted_domains_for_waiting_room: z.string().optional(),
          })
          .optional(),
        webinar_password: z.boolean().optional(),
      })
      .optional(),
  }),
]);

export const getAccountLockSettingsErrorSchema = z.unknown();

export const updateAccountLockSettingsDataSchema = z.object({
  body: z
    .union([
      z.object({
        email_notification: z
          .object({
            alternative_host_reminder: z.boolean().optional(),
            cancel_meeting_reminder: z.boolean().optional(),
            cloud_recording_available_reminder: z.boolean().optional(),
            jbh_reminder: z.boolean().optional(),
            schedule_for_host_reminder: z.boolean().optional(),
          })
          .optional(),
        in_meeting: z
          .object({
            alert_guest_join: z.boolean().optional(),
            allow_show_zoom_windows: z.boolean().optional(),
            annotation: z.boolean().optional(),
            anonymous_question_answer: z.boolean().optional(),
            attendee_on_hold: z.boolean().optional(),
            auto_answer: z.boolean().optional(),
            auto_saving_chat: z.boolean().optional(),
            breakout_room: z.boolean().optional(),
            chat: z.boolean().optional(),
            closed_caption: z.boolean().optional(),
            co_host: z.boolean().optional(),
            custom_data_center_regions: z.boolean().optional(),
            dscp_marking: z.boolean().optional(),
            e2e_encryption: z.boolean().optional(),
            entry_exit_chime: z.string().optional(),
            far_end_camera_control: z.boolean().optional(),
            feedback: z.boolean().optional(),
            file_transfer: z.boolean().optional(),
            group_hd: z.boolean().optional(),
            original_audio: z.boolean().optional(),
            polling: z.boolean().optional(),
            post_meeting_feedback: z.boolean().optional(),
            private_chat: z.boolean().optional(),
            remote_control: z.boolean().optional(),
            request_permission_to_unmute: z.boolean().optional(),
            screen_sharing: z.boolean().optional(),
            sending_default_email_invites: z.boolean().optional(),
            show_meeting_control_toolbar: z.boolean().optional(),
            stereo_audio: z.boolean().optional(),
            use_html_format_email: z.boolean().optional(),
            virtual_background: z.boolean().optional(),
            webinar_question_answer: z.boolean().optional(),
            whiteboard: z.boolean().optional(),
          })
          .optional(),
        recording: z
          .object({
            account_user_access_recording: z.boolean().optional(),
            auto_delete_cmr: z.boolean().optional(),
            auto_recording: z.string().optional(),
            cloud_recording: z.boolean().optional(),
            cloud_recording_download: z.boolean().optional(),
            host_delete_cloud_recording: z.boolean().optional(),
            ip_address_access_control: z
              .object({
                enable: z.boolean().optional(),
                ip_addresses_or_ranges: z.string().optional(),
              })
              .optional(),
            local_recording: z.boolean().optional(),
            prevent_host_access_recording: z.boolean().optional(),
            recording_authentication: z.string().optional(),
          })
          .optional(),
        schedule_meeting: z
          .object({
            audio_type: z.boolean().optional(),
            embed_password_in_join_link: z.boolean().optional(),
            enforce_login: z.boolean().optional(),
            enforce_login_domains: z.string().optional(),
            enforce_login_with_domains: z.boolean().optional(),
            host_video: z.boolean().optional(),
            join_before_host: z.boolean().optional(),
            meeting_authentication: z.boolean().optional(),
            not_store_meeting_topic: z.boolean().optional(),
            participant_video: z.boolean().optional(),
            personal_meeting: z.boolean().optional(),
            require_password_for_instant_meetings: z.boolean().optional(),
            require_password_for_pmi_meetings: z.boolean().optional(),
            require_password_for_scheduling_new_meetings: z.boolean().optional(),
          })
          .optional(),
        telephony: z
          .object({
            telephony_regions: z.boolean().optional(),
            third_party_audio: z.boolean().optional(),
          })
          .optional(),
        tsp: z
          .object({
            call_out: z.boolean().optional(),
            show_international_numbers_link: z.boolean().optional(),
          })
          .optional(),
      }),
      z.object({
        meeting_security: z
          .object({
            auto_security: z.boolean().optional(),
            embed_password_in_join_link: z.boolean().optional(),
            encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
            end_to_end_encrypted_meetings: z.boolean().optional(),
            meeting_password: z.boolean().optional(),
            meeting_password_requirement: z
              .object({
                consecutive_characters_length: z
                  .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
                  .optional(),
                have_letter: z.boolean().optional(),
                have_number: z.boolean().optional(),
                have_special_character: z.boolean().optional(),
                have_upper_and_lower_characters: z.boolean().optional(),
                length: z.number().optional(),
                only_allow_numeric: z.boolean().optional(),
                weak_enhance_detection: z.boolean().optional(),
              })
              .optional(),
            phone_password: z.boolean().optional(),
            pmi_password: z.boolean().optional(),
            require_password_for_scheduled_meeting: z.boolean().optional(),
            require_password_for_scheduled_webinar: z.boolean().optional(),
            waiting_room: z.boolean().optional(),
            waiting_room_settings: z
              .object({
                participants_to_place_in_waiting_room: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
                users_who_can_admit_participants_from_waiting_room: z.number().optional(),
                whitelisted_domains_for_waiting_room: z.string().optional(),
              })
              .optional(),
            webinar_password: z.boolean().optional(),
          })
          .optional(),
      }),
    ])
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const updateAccountLockSettingsResponseSchema = z.union([z.unknown(), z.record(z.unknown())]);

export const updateAccountLockSettingsErrorSchema = z.unknown();

export const accountManagedDomainDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountManagedDomainResponseSchema = z.object({
  domains: z
    .array(
      z.object({
        domain: z.string().optional(),
        status: z.string().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const accountManagedDomainErrorSchema = z.unknown();

export const accountOptionsUpdateDataSchema = z.object({
  body: z.object({
    billing_auto_renew: z.boolean().optional(),
    meeting_connector_list: z.array(z.string()).optional(),
    pay_mode: z.union([z.literal('master'), z.literal('sub')]).optional(),
    room_connector_list: z.array(z.string()).optional(),
    share_mc: z.boolean().optional(),
    share_rc: z.boolean().optional(),
  }),
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountOptionsUpdateResponseSchema = z.union([z.unknown(), z.any()]);

export const accountOptionsUpdateErrorSchema = z.unknown();

export const updateAccountOwnerDataSchema = z.object({
  body: z
    .object({
      email: z.string(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const updateAccountOwnerResponseSchema = z.unknown();

export const updateAccountOwnerErrorSchema = z.unknown();

export const updatePhoneSettingsDataSchema = z.object({
  body: z
    .object({
      byoc: z
        .object({
          enable: z.boolean().optional(),
        })
        .optional(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const updatePhoneSettingsResponseSchema = z.unknown();

export const updatePhoneSettingsErrorSchema = z.unknown();

export const setUpAccountDataSchema = z.object({
  body: z
    .object({
      emergency_address: z.object({
        address_line1: z.string(),
        address_line2: z.string().optional(),
        city: z.string().optional(),
        country: z.string(),
        state_code: z.string().optional(),
        zip: z.string().optional(),
      }),
      extension_number: z.string(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const setUpAccountResponseSchema = z.unknown();

export const setUpAccountErrorSchema = z.unknown();

export const postPhoneSipTrunkDataSchema = z.object({
  body: z
    .object({
      sip_trunks: z
        .array(
          z.object({
            carrier_account: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const postPhoneSipTrunkResponseSchema = z.object({
  sip_trunks: z
    .array(
      z.object({
        carrier_account: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
});

export const postPhoneSipTrunkErrorSchema = z.unknown();

export const updatePhoneSipTrunkDataSchema = z.object({
  body: z
    .object({
      carrier_account: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
    sipTrunkId: z.string(),
  }),
});

export const updatePhoneSipTrunkResponseSchema = z.unknown();

export const updatePhoneSipTrunkErrorSchema = z.unknown();

export const accountPlansDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountPlansResponseSchema = z.object({
  plan_audio: z
    .object({
      callout_countries: z.string().optional(),
      ddi_numbers: z.number().optional(),
      next_invoice_date: z.string().optional(),
      premium_countries: z.string().optional(),
      service_effective_date: z.string().optional(),
      status: z.union([z.literal('active'), z.literal('cancel'), z.literal('expired')]).optional(),
      tollfree_countries: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
  plan_base: z
    .object({
      hosts: z.number().optional(),
      next_invoice_date: z.string().optional(),
      service_effective_date: z.string().optional(),
      status: z.union([z.literal('active'), z.literal('cancel'), z.literal('expired')]).optional(),
      type: z.string().optional(),
    })
    .optional(),
  plan_large_meeting: z
    .array(
      z.object({
        hosts: z.number().optional(),
        next_invoice_date: z.string().optional(),
        service_effective_date: z.string().optional(),
        status: z.union([z.literal('active'), z.literal('cancel'), z.literal('expired')]).optional(),
        type: z.string().optional(),
      }),
    )
    .optional(),
  plan_phone: z
    .object({
      plan_base: z
        .object({
          callout_countries: z.string().optional(),
          next_invoice_date: z.string().optional(),
          service_effective_date: z.string().optional(),
          status: z.union([z.literal('active'), z.literal('cancel'), z.literal('expired')]).optional(),
          type: z.string().optional(),
        })
        .optional(),
      plan_calling: z
        .array(
          z.object({
            hosts: z.number().optional(),
            next_invoice_date: z.string().optional(),
            service_effective_date: z.string().optional(),
            status: z.union([z.literal('active'), z.literal('cancel'), z.literal('expired')]).optional(),
            type: z.string().optional(),
          }),
        )
        .optional(),
      plan_number: z
        .array(
          z.object({
            hosts: z.number().optional(),
            next_invoice_date: z.string().optional(),
            service_effective_date: z.string().optional(),
            status: z.union([z.literal('active'), z.literal('cancel'), z.literal('expired')]).optional(),
            type: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  plan_recording: z.string().optional(),
  plan_recording_next_invoice_date: z.string().optional(),
  plan_recording_service_effective_date: z.string().optional(),
  plan_recording_status: z.union([z.literal('Active'), z.literal('Cancelled')]).optional(),
  plan_room_connector: z
    .object({
      hosts: z.number().optional(),
      next_invoice_date: z.string().optional(),
      service_effective_date: z.string().optional(),
      status: z.union([z.literal('active'), z.literal('cancel'), z.literal('expired')]).optional(),
      type: z.string().optional(),
    })
    .optional(),
  plan_webinar: z
    .array(
      z.object({
        hosts: z.number().optional(),
        next_invoice_date: z.string().optional(),
        service_effective_date: z.string().optional(),
        status: z.union([z.literal('active'), z.literal('cancel'), z.literal('expired')]).optional(),
        type: z.string().optional(),
      }),
    )
    .optional(),
  plan_zoom_rooms: z
    .object({
      hosts: z.number().optional(),
      next_invoice_date: z.string().optional(),
      service_effective_date: z.string().optional(),
      status: z.union([z.literal('active'), z.literal('cancel'), z.literal('expired')]).optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const accountPlansErrorSchema = z.unknown();

export const accountPlanCreateDataSchema = z.object({
  body: z
    .object({
      contact: z
        .object({
          address: z.string(),
          apt: z.string().optional(),
          city: z.string(),
          country: z.string(),
          email: z.string(),
          first_name: z.string(),
          last_name: z.string(),
          phone_number: z.string(),
          state: z.string(),
          zip: z.string(),
        })
        .optional(),
    })
    .and(
      z.object({
        plan_audio: z
          .object({
            callout_countries: z.string().optional(),
            ddi_numbers: z.number().optional(),
            premium_countries: z.string().optional(),
            tollfree_countries: z.string().optional(),
            type: z.string().optional(),
          })
          .optional(),
        plan_base: z.object({
          hosts: z.number(),
          type: z.string(),
        }),
        plan_large_meeting: z
          .array(
            z.object({
              hosts: z.number().optional(),
              type: z.string().optional(),
            }),
          )
          .optional(),
        plan_phone: z
          .object({
            plan_base: z
              .object({
                callout_countries: z.string().optional(),
                type: z.string().optional(),
              })
              .optional(),
            plan_calling: z
              .array(
                z.object({
                  hosts: z.number().optional(),
                  type: z.string().optional(),
                }),
              )
              .optional(),
            plan_number: z
              .array(
                z.object({
                  hosts: z.number().optional(),
                  type: z.string().optional(),
                }),
              )
              .optional(),
          })
          .optional(),
        plan_recording: z.string().optional(),
        plan_room_connector: z
          .object({
            hosts: z.number().optional(),
            type: z.string().optional(),
          })
          .optional(),
        plan_webinar: z
          .array(
            z.object({
              hosts: z.number().optional(),
              type: z.string().optional(),
            }),
          )
          .optional(),
        plan_zoom_rooms: z
          .object({
            hosts: z.number().optional(),
            type: z.string().optional(),
          })
          .optional(),
      }),
    ),
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountPlanCreateResponseSchema = z.union([
  z.unknown(),
  z.object({
    plan_audio: z
      .object({
        callout_countries: z.string().optional(),
        ddi_numbers: z.number().optional(),
        premium_countries: z.string().optional(),
        tollfree_countries: z.string().optional(),
        type: z.string().optional(),
      })
      .optional(),
    plan_base: z.object({
      hosts: z.number(),
      type: z.string(),
    }),
    plan_large_meeting: z
      .array(
        z.object({
          hosts: z.number().optional(),
          type: z.string().optional(),
        }),
      )
      .optional(),
    plan_phone: z
      .object({
        plan_base: z
          .object({
            callout_countries: z.string().optional(),
            type: z.string().optional(),
          })
          .optional(),
        plan_calling: z
          .array(
            z.object({
              hosts: z.number().optional(),
              type: z.string().optional(),
            }),
          )
          .optional(),
        plan_number: z
          .array(
            z.object({
              hosts: z.number().optional(),
              type: z.string().optional(),
            }),
          )
          .optional(),
      })
      .optional(),
    plan_recording: z.string().optional(),
    plan_room_connector: z
      .object({
        hosts: z.number().optional(),
        type: z.string().optional(),
      })
      .optional(),
    plan_webinar: z
      .array(
        z.object({
          hosts: z.number().optional(),
          type: z.string().optional(),
        }),
      )
      .optional(),
    plan_zoom_rooms: z
      .object({
        hosts: z.number().optional(),
        type: z.string().optional(),
      })
      .optional(),
  }),
]);

export const accountPlanCreateErrorSchema = z.unknown();

export const accountPlanAddonCreateDataSchema = z.object({
  body: z.union([
    z.object({
      hosts: z.number(),
      type: z.string(),
    }),
    z.object({
      plan_details: z.object({
        plan_base: z
          .object({
            callout_countries: z.string().optional(),
            type: z.string().optional(),
          })
          .optional(),
        plan_calling: z
          .array(
            z.object({
              hosts: z.number().optional(),
              type: z.string().optional(),
            }),
          )
          .optional(),
        plan_number: z
          .array(
            z.object({
              hosts: z.number().optional(),
              type: z.string().optional(),
            }),
          )
          .optional(),
      }),
      type: z.string(),
    }),
  ]),
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountPlanAddonCreateResponseSchema = z.unknown();

export const accountPlanAddonCreateErrorSchema = z.unknown();

export const accountPlanAddonUpdateDataSchema = z.object({
  body: z.object({
    hosts: z.number(),
    type: z.string(),
  }),
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountPlanAddonUpdateResponseSchema = z.union([z.unknown(), z.any()]);

export const accountPlanAddonUpdateErrorSchema = z.unknown();

export const accountPlanAddonCancelDataSchema = z.object({
  body: z
    .object({
      action: z.literal('cancel').optional(),
      comment: z.string().optional(),
      reason: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6)]).optional(),
      type: z.string().optional(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountPlanAddonCancelResponseSchema = z.unknown();

export const accountPlanAddonCancelErrorSchema = z.unknown();

export const accountPlanBaseUpdateDataSchema = z.object({
  body: z.object({
    hosts: z.number(),
    type: z.string(),
  }),
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountPlanBaseUpdateResponseSchema = z.union([z.unknown(), z.any()]);

export const accountPlanBaseUpdateErrorSchema = z.unknown();

export const accountPlanBaseDeleteDataSchema = z.object({
  body: z
    .object({
      action: z.string(),
      comment: z.string().optional(),
      reason: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6)]).optional(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountPlanBaseDeleteResponseSchema = z.union([z.unknown(), z.record(z.unknown())]);

export const accountPlanBaseDeleteErrorSchema = z.unknown();

export const getPlanUsageDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
});

export const getPlanUsageResponseSchema = z.object({
  plan_base: z
    .array(
      z.object({
        hosts: z.number().optional(),
        type: z.string().optional(),
        usage: z.number().optional(),
      }),
    )
    .optional(),
  plan_large_meeting: z
    .array(
      z.object({
        hosts: z.number().optional(),
        type: z.string().optional(),
        usage: z.number().optional(),
      }),
    )
    .optional(),
  plan_recording: z
    .object({
      free_storage: z.string().optional(),
      free_storage_usage: z.string().optional(),
      plan_storage: z.string().optional(),
      plan_storage_exceed: z.string().optional(),
      plan_storage_usage: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
  plan_united: z
    .object({
      hosts: z.number().optional(),
      name: z.string().optional(),
      type: z.string().optional(),
      usage: z.number().optional(),
    })
    .optional(),
  plan_webinar: z
    .array(
      z.object({
        hosts: z.number().optional(),
        type: z.string().optional(),
        usage: z.number().optional(),
      }),
    )
    .optional(),
  plan_zoom_rooms: z
    .array(
      z.object({
        hosts: z.number().optional(),
        type: z.string().optional(),
        usage: z.number().optional(),
      }),
    )
    .optional(),
});

export const getPlanUsageErrorSchema = z.unknown();

export const getAccountCloudRecordingDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
  query: z
    .object({
      from: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      to: z.string().optional(),
    })
    .optional(),
});

export const getAccountCloudRecordingResponseSchema = z.object({
  from: z.string().optional(),
  meetings: z
    .array(
      z.object({
        duration: z.number().optional(),
        host_id: z.string().optional(),
        id: z.string().optional(),
        recording_count: z.number().optional(),
        recording_files: z
          .array(
            z.object({
              download_url: z.string().optional(),
              file_size: z.number().optional(),
              file_type: z
                .union([
                  z.literal('MP4'),
                  z.literal('M4A'),
                  z.literal('CHAT'),
                  z.literal('TRANSCRIPT'),
                  z.literal('CC'),
                  z.literal('CSV'),
                  z.literal('TB'),
                ])
                .optional(),
              id: z.string().optional(),
              meeting_id: z.string().optional(),
              play_url: z.string().optional(),
              recording_end: z.string().optional(),
              recording_start: z.string().optional(),
              recording_type: z
                .union([
                  z.literal('shared_screen_with_speaker_view(CC)'),
                  z.literal('shared_screen_with_speaker_view'),
                  z.literal('shared_screen_with_gallery_view'),
                  z.literal('active_speaker'),
                  z.literal('gallery_view'),
                  z.literal('shared_screen'),
                  z.literal('audio_only'),
                  z.literal('audio_transcript'),
                  z.literal('chat_file'),
                  z.literal('poll'),
                  z.literal('host_video'),
                  z.literal('closed_caption'),
                  z.literal('timeline'),
                  z.literal('thumbnail'),
                ])
                .optional(),
              status: z.union([z.literal('completed'), z.literal('processing')]).optional(),
            }),
          )
          .optional(),
        start_time: z.string().optional(),
        topic: z.string().optional(),
        total_size: z.number().optional(),
        uuid: z.string().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  to: z.string().optional(),
  total_records: z.number().optional(),
});

export const getAccountCloudRecordingErrorSchema = z.unknown();

export const accountSettingsDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
  query: z
    .object({
      custom_query_fields: z.string().optional(),
      option: z.union([z.literal('meeting_authentication'), z.literal('recording_authentication')]).optional(),
    })
    .optional(),
});

export const accountSettingsResponseSchema = z.union([
  z.object({
    email_notification: z
      .object({
        alternative_host_reminder: z.boolean().optional(),
        cancel_meeting_reminder: z.boolean().optional(),
        cloud_recording_avaliable_reminder: z.boolean().optional(),
        jbh_reminder: z.boolean().optional(),
        low_host_count_reminder: z.boolean().optional(),
        schedule_for_reminder: z.boolean().optional(),
      })
      .optional(),
    feature: z
      .object({
        meeting_capacity: z.number().optional(),
      })
      .optional(),
    in_meeting: z
      .object({
        alert_guest_join: z.boolean().optional(),
        allow_live_streaming: z.boolean().optional(),
        allow_participants_to_rename: z.boolean().optional(),
        allow_show_zoom_windows: z.boolean().optional(),
        annotation: z.boolean().optional(),
        anonymous_question_answer: z.boolean().optional(),
        attendee_on_hold: z.boolean().optional(),
        auto_answer: z.boolean().optional(),
        auto_saving_chat: z.boolean().optional(),
        breakout_room: z.boolean().optional(),
        chat: z.boolean().optional(),
        closed_caption: z.boolean().optional(),
        co_host: z.boolean().optional(),
        custom_data_center_regions: z.boolean().optional(),
        custom_live_streaming_service: z.boolean().optional(),
        custom_service_instructions: z.string().optional(),
        data_center_regions: z
          .union([
            z.literal('EU'),
            z.literal('HK'),
            z.literal('AU'),
            z.literal('IN'),
            z.literal('TY'),
            z.literal('CN'),
            z.literal('US'),
            z.literal('CA'),
          ])
          .optional(),
        dscp_audio: z.number().optional(),
        dscp_marking: z.boolean().optional(),
        dscp_video: z.number().optional(),
        e2e_encryption: z.boolean().optional(),
        entry_exit_chime: z.union([z.literal('host'), z.literal('all'), z.literal('none')]).optional(),
        far_end_camera_control: z.boolean().optional(),
        feedback: z.boolean().optional(),
        file_transfer: z.boolean().optional(),
        group_hd: z.boolean().optional(),
        meeting_reactions: z.boolean().optional(),
        original_audio: z.boolean().optional(),
        p2p_connetion: z.boolean().optional(),
        p2p_ports: z.boolean().optional(),
        polling: z.boolean().optional(),
        ports_range: z.string().optional(),
        post_meeting_feedback: z.boolean().optional(),
        private_chat: z.boolean().optional(),
        record_play_own_voice: z.boolean().optional(),
        remote_control: z.boolean().optional(),
        request_permission_to_unmute: z.boolean().optional(),
        screen_sharing: z.boolean().optional(),
        sending_default_email_invites: z.boolean().optional(),
        show_a_join_from_your_browser_link: z.boolean().optional(),
        show_meeting_control_toolbar: z.boolean().optional(),
        stereo_audio: z.boolean().optional(),
        use_html_format_email: z.boolean().optional(),
        virtual_background: z.boolean().optional(),
        virtual_background_settings: z
          .object({
            allow_upload_custom: z.boolean().optional(),
            allow_videos: z.boolean().optional(),
            enable: z.boolean().optional(),
            files: z
              .array(
                z.object({
                  id: z.string().optional(),
                  is_default: z.boolean().optional(),
                  name: z.string().optional(),
                  size: z.string().optional(),
                  type: z.string().optional(),
                }),
              )
              .optional(),
          })
          .optional(),
        watermark: z.boolean().optional(),
        webinar_question_answer: z.boolean().optional(),
        whiteboard: z.boolean().optional(),
        who_can_share_screen: z.union([z.literal('host'), z.literal('all')]).optional(),
        who_can_share_screen_when_someone_is_sharing: z.union([z.literal('host'), z.literal('all')]).optional(),
        workplace_by_facebook: z.boolean().optional(),
      })
      .optional(),
    integration: z
      .object({
        box: z.boolean().optional(),
        dropbox: z.boolean().optional(),
        google_calendar: z.boolean().optional(),
        google_drive: z.boolean().optional(),
        kubi: z.boolean().optional(),
        microsoft_one_drive: z.boolean().optional(),
      })
      .optional(),
    profile: z
      .object({
        recording_storage_location: z
          .object({
            allowed_values: z.array(z.string()).optional(),
            value: z.string().optional(),
          })
          .optional(),
      })
      .optional(),
    recording: z
      .object({
        account_user_access_recording: z.boolean().optional(),
        allow_recovery_deleted_cloud_recordings: z.boolean().optional(),
        archive: z
          .object({
            enable: z.boolean().optional(),
            settings: z
              .object({
                audio_file: z.boolean().optional(),
                cc_transcript_file: z.boolean().optional(),
                chat_file: z.boolean().optional(),
                chat_with_sender_email: z.boolean().optional(),
                video_file: z.boolean().optional(),
              })
              .optional(),
            type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
          })
          .optional(),
        auto_delete_cmr: z.boolean().optional(),
        auto_delete_cmr_days: z.number().optional(),
        auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
        cloud_recording: z.boolean().optional(),
        cloud_recording_download: z.boolean().optional(),
        cloud_recording_download_host: z.boolean().optional(),
        host_delete_cloud_recording: z.boolean().optional(),
        ip_address_access_control: z
          .object({
            enable: z.boolean().optional(),
            ip_addresses_or_ranges: z.string().optional(),
          })
          .optional(),
        local_recording: z.boolean().optional(),
        prevent_host_access_recording: z.boolean().optional(),
        record_audio_file: z.boolean().optional(),
        record_gallery_view: z.boolean().optional(),
        record_speaker_view: z.boolean().optional(),
        recording_audio_transcript: z.boolean().optional(),
        recording_disclaimer: z.boolean().optional(),
        recording_password_requirement: z
          .object({
            have_letter: z.boolean().optional(),
            have_number: z.boolean().optional(),
            have_special_character: z.boolean().optional(),
            length: z.number().optional(),
            only_allow_numeric: z.boolean().optional(),
          })
          .optional(),
        required_password_for_existing_cloud_recordings: z.boolean().optional(),
        save_chat_text: z.boolean().optional(),
        show_timestamp: z.boolean().optional(),
      })
      .optional(),
    schedule_meeting: z
      .object({
        audio_type: z
          .union([z.literal('both'), z.literal('telephony'), z.literal('voip'), z.literal('thirdParty')])
          .optional(),
        enforce_login: z.boolean().optional(),
        enforce_login_domains: z.string().optional(),
        enforce_login_with_domains: z.boolean().optional(),
        force_pmi_jbh_password: z.boolean().optional(),
        host_video: z.boolean().optional(),
        join_before_host: z.boolean().optional(),
        meeting_password_requirement: z
          .object({
            consecutive_characters_length: z
              .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
              .optional(),
            have_letter: z.boolean().optional(),
            have_number: z.boolean().optional(),
            have_special_character: z.boolean().optional(),
            have_upper_and_lower_characters: z.boolean().optional(),
            length: z.number().optional(),
            only_allow_numeric: z.boolean().optional(),
            weak_enhance_detection: z.boolean().optional(),
          })
          .optional(),
        not_store_meeting_topic: z.boolean().optional(),
        participant_video: z.boolean().optional(),
        personal_meeting: z.boolean().optional(),
        require_password_for_instant_meetings: z.boolean().optional(),
        require_password_for_pmi_meetings: z
          .union([z.literal('jbh_only'), z.literal('all'), z.literal('none')])
          .optional(),
        require_password_for_scheduled_meetings: z.boolean().optional(),
        require_password_for_scheduling_new_meetings: z.boolean().optional(),
        use_pmi_for_instant_meetings: z.boolean().optional(),
        use_pmi_for_scheduled_meetings: z.boolean().optional(),
      })
      .optional(),
    security: z
      .object({
        admin_change_name_pic: z.boolean().optional(),
        hide_billing_info: z.boolean().optional(),
        import_photos_from_devices: z.boolean().optional(),
        password_requirement: z
          .object({
            consecutive_characters_length: z.number().optional(),
            have_special_character: z.boolean().optional(),
            minimum_password_length: z.number().optional(),
            weak_enhance_detection: z.boolean().optional(),
          })
          .optional(),
        sign_again_period_for_inactivity_on_client: z.number().optional(),
        sign_again_period_for_inactivity_on_web: z.number().optional(),
        sign_in_with_two_factor_auth: z
          .union([z.literal('all'), z.literal('group'), z.literal('role'), z.literal('none')])
          .optional(),
        sign_in_with_two_factor_auth_groups: z.array(z.string()).optional(),
        sign_in_with_two_factor_auth_roles: z.array(z.string()).optional(),
      })
      .optional(),
    telephony: z
      .object({
        audio_conference_info: z.string().optional(),
        telephony_regions: z
          .object({
            allowed_values: z.array(z.string()).optional(),
            selection_values: z.array(z.string()).optional(),
          })
          .optional(),
        third_party_audio: z.boolean().optional(),
      })
      .optional(),
    tsp: z
      .object({
        call_out: z.boolean().optional(),
        call_out_countries: z.array(z.unknown()).optional(),
        display_toll_free_numbers: z.boolean().optional(),
        show_international_numbers_link: z.boolean().optional(),
      })
      .optional(),
    zoom_rooms: z
      .object({
        auto_start_stop_scheduled_meetings: z.boolean().optional(),
        cmr_for_instant_meeting: z.boolean().optional(),
        force_private_meeting: z.boolean().optional(),
        hide_host_information: z.boolean().optional(),
        list_meetings_with_calendar: z.boolean().optional(),
        start_airplay_manually: z.boolean().optional(),
        ultrasonic: z.boolean().optional(),
        upcoming_meeting_alert: z.boolean().optional(),
        weekly_system_restart: z.boolean().optional(),
        zr_post_meeting_feedback: z.boolean().optional(),
      })
      .optional(),
  }),
  z.union([
    z.object({
      authentication_options: z
        .array(
          z.object({
            default_option: z.boolean().optional(),
            domains: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z
              .union([
                z.literal('enforce_login'),
                z.literal('enforce_login_with_same_account'),
                z.literal('enforce_login_with_domains'),
              ])
              .optional(),
            visible: z.boolean().optional(),
          }),
        )
        .optional(),
      meeting_authentication: z.boolean().optional(),
    }),
    z.object({
      authentication_options: z
        .array(
          z.object({
            default_option: z.boolean().optional(),
            domains: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z
              .union([z.literal('internally'), z.literal('enforce_login'), z.literal('enforce_login_with_domains')])
              .optional(),
            visible: z.boolean().optional(),
          }),
        )
        .optional(),
      recording_authentication: z.boolean().optional(),
    }),
  ]),
  z.object({
    admin_change_name_pic: z.boolean().optional(),
    hide_billing_info: z.boolean().optional(),
    import_photos_from_devices: z.boolean().optional(),
    password_requirement: z
      .object({
        consecutive_characters_length: z.number().optional(),
        have_special_character: z.boolean().optional(),
        minimum_password_length: z.number().optional(),
        weak_enhance_detection: z.boolean().optional(),
      })
      .optional(),
    sign_again_period_for_inactivity_on_client: z.number().optional(),
    sign_again_period_for_inactivity_on_web: z.number().optional(),
    sign_in_with_two_factor_auth: z
      .union([z.literal('all'), z.literal('group'), z.literal('role'), z.literal('none')])
      .optional(),
    sign_in_with_two_factor_auth_groups: z.array(z.string()).optional(),
    sign_in_with_two_factor_auth_roles: z.array(z.string()).optional(),
  }),
  z.object({
    meeting_security: z
      .object({
        auto_security: z.boolean().optional(),
        embed_password_in_join_link: z.boolean().optional(),
        encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
        end_to_end_encrypted_meetings: z.boolean().optional(),
        meeting_password: z.boolean().optional(),
        meeting_password_requirement: z
          .object({
            consecutive_characters_length: z
              .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
              .optional(),
            have_letter: z.boolean().optional(),
            have_number: z.boolean().optional(),
            have_special_character: z.boolean().optional(),
            have_upper_and_lower_characters: z.boolean().optional(),
            length: z.number().optional(),
            only_allow_numeric: z.boolean().optional(),
            weak_enhance_detection: z.boolean().optional(),
          })
          .optional(),
        phone_password: z.boolean().optional(),
        pmi_password: z.boolean().optional(),
        require_password_for_scheduled_meeting: z.boolean().optional(),
        require_password_for_scheduled_webinar: z.boolean().optional(),
        waiting_room: z.boolean().optional(),
        waiting_room_settings: z
          .object({
            participants_to_place_in_waiting_room: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
            users_who_can_admit_participants_from_waiting_room: z.number().optional(),
            whitelisted_domains_for_waiting_room: z.string().optional(),
          })
          .optional(),
        webinar_password: z.boolean().optional(),
      })
      .optional(),
  }),
]);

export const accountSettingsErrorSchema = z.unknown();

export const accountSettingsUpdateDataSchema = z.object({
  body: z.union([
    z.object({
      email_notification: z
        .object({
          alternative_host_reminder: z.boolean().optional(),
          cancel_meeting_reminder: z.boolean().optional(),
          cloud_recording_avaliable_reminder: z.boolean().optional(),
          jbh_reminder: z.boolean().optional(),
          low_host_count_reminder: z.boolean().optional(),
          schedule_for_reminder: z.boolean().optional(),
        })
        .optional(),
      feature: z
        .object({
          meeting_capacity: z.number().optional(),
        })
        .optional(),
      in_meeting: z
        .object({
          alert_guest_join: z.boolean().optional(),
          allow_live_streaming: z.boolean().optional(),
          allow_participants_to_rename: z.boolean().optional(),
          allow_show_zoom_windows: z.boolean().optional(),
          annotation: z.boolean().optional(),
          anonymous_question_answer: z.boolean().optional(),
          attendee_on_hold: z.boolean().optional(),
          auto_answer: z.boolean().optional(),
          auto_saving_chat: z.boolean().optional(),
          breakout_room: z.boolean().optional(),
          chat: z.boolean().optional(),
          closed_caption: z.boolean().optional(),
          co_host: z.boolean().optional(),
          custom_data_center_regions: z.boolean().optional(),
          custom_live_streaming_service: z.boolean().optional(),
          custom_service_instructions: z.string().optional(),
          data_center_regions: z
            .union([
              z.literal('EU'),
              z.literal('HK'),
              z.literal('AU'),
              z.literal('IN'),
              z.literal('TY'),
              z.literal('CN'),
              z.literal('US'),
              z.literal('CA'),
            ])
            .optional(),
          dscp_audio: z.number().optional(),
          dscp_marking: z.boolean().optional(),
          dscp_video: z.number().optional(),
          e2e_encryption: z.boolean().optional(),
          entry_exit_chime: z.union([z.literal('host'), z.literal('all'), z.literal('none')]).optional(),
          far_end_camera_control: z.boolean().optional(),
          feedback: z.boolean().optional(),
          file_transfer: z.boolean().optional(),
          group_hd: z.boolean().optional(),
          meeting_reactions: z.boolean().optional(),
          original_audio: z.boolean().optional(),
          p2p_connetion: z.boolean().optional(),
          p2p_ports: z.boolean().optional(),
          polling: z.boolean().optional(),
          ports_range: z.string().optional(),
          post_meeting_feedback: z.boolean().optional(),
          private_chat: z.boolean().optional(),
          record_play_own_voice: z.boolean().optional(),
          remote_control: z.boolean().optional(),
          request_permission_to_unmute: z.boolean().optional(),
          screen_sharing: z.boolean().optional(),
          sending_default_email_invites: z.boolean().optional(),
          show_a_join_from_your_browser_link: z.boolean().optional(),
          show_meeting_control_toolbar: z.boolean().optional(),
          stereo_audio: z.boolean().optional(),
          use_html_format_email: z.boolean().optional(),
          virtual_background: z.boolean().optional(),
          virtual_background_settings: z
            .object({
              allow_upload_custom: z.boolean().optional(),
              allow_videos: z.boolean().optional(),
              enable: z.boolean().optional(),
              files: z
                .array(
                  z.object({
                    id: z.string().optional(),
                    is_default: z.boolean().optional(),
                    name: z.string().optional(),
                    size: z.string().optional(),
                    type: z.string().optional(),
                  }),
                )
                .optional(),
            })
            .optional(),
          watermark: z.boolean().optional(),
          webinar_question_answer: z.boolean().optional(),
          whiteboard: z.boolean().optional(),
          who_can_share_screen: z.union([z.literal('host'), z.literal('all')]).optional(),
          who_can_share_screen_when_someone_is_sharing: z.union([z.literal('host'), z.literal('all')]).optional(),
          workplace_by_facebook: z.boolean().optional(),
        })
        .optional(),
      integration: z
        .object({
          box: z.boolean().optional(),
          dropbox: z.boolean().optional(),
          google_calendar: z.boolean().optional(),
          google_drive: z.boolean().optional(),
          kubi: z.boolean().optional(),
          microsoft_one_drive: z.boolean().optional(),
        })
        .optional(),
      profile: z
        .object({
          recording_storage_location: z
            .object({
              allowed_values: z.array(z.string()).optional(),
              value: z.string().optional(),
            })
            .optional(),
        })
        .optional(),
      recording: z
        .object({
          account_user_access_recording: z.boolean().optional(),
          allow_recovery_deleted_cloud_recordings: z.boolean().optional(),
          archive: z
            .object({
              enable: z.boolean().optional(),
              settings: z
                .object({
                  audio_file: z.boolean().optional(),
                  cc_transcript_file: z.boolean().optional(),
                  chat_file: z.boolean().optional(),
                  chat_with_sender_email: z.boolean().optional(),
                  video_file: z.boolean().optional(),
                })
                .optional(),
              type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
            })
            .optional(),
          auto_delete_cmr: z.boolean().optional(),
          auto_delete_cmr_days: z.number().optional(),
          auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
          cloud_recording: z.boolean().optional(),
          cloud_recording_download: z.boolean().optional(),
          cloud_recording_download_host: z.boolean().optional(),
          host_delete_cloud_recording: z.boolean().optional(),
          ip_address_access_control: z
            .object({
              enable: z.boolean().optional(),
              ip_addresses_or_ranges: z.string().optional(),
            })
            .optional(),
          local_recording: z.boolean().optional(),
          prevent_host_access_recording: z.boolean().optional(),
          record_audio_file: z.boolean().optional(),
          record_gallery_view: z.boolean().optional(),
          record_speaker_view: z.boolean().optional(),
          recording_audio_transcript: z.boolean().optional(),
          recording_disclaimer: z.boolean().optional(),
          recording_password_requirement: z
            .object({
              have_letter: z.boolean().optional(),
              have_number: z.boolean().optional(),
              have_special_character: z.boolean().optional(),
              length: z.number().optional(),
              only_allow_numeric: z.boolean().optional(),
            })
            .optional(),
          required_password_for_existing_cloud_recordings: z.boolean().optional(),
          save_chat_text: z.boolean().optional(),
          show_timestamp: z.boolean().optional(),
        })
        .optional(),
      schedule_meeting: z
        .object({
          audio_type: z
            .union([z.literal('both'), z.literal('telephony'), z.literal('voip'), z.literal('thirdParty')])
            .optional(),
          enforce_login: z.boolean().optional(),
          enforce_login_domains: z.string().optional(),
          enforce_login_with_domains: z.boolean().optional(),
          force_pmi_jbh_password: z.boolean().optional(),
          host_video: z.boolean().optional(),
          join_before_host: z.boolean().optional(),
          meeting_password_requirement: z
            .object({
              consecutive_characters_length: z
                .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
                .optional(),
              have_letter: z.boolean().optional(),
              have_number: z.boolean().optional(),
              have_special_character: z.boolean().optional(),
              have_upper_and_lower_characters: z.boolean().optional(),
              length: z.number().optional(),
              only_allow_numeric: z.boolean().optional(),
              weak_enhance_detection: z.boolean().optional(),
            })
            .optional(),
          not_store_meeting_topic: z.boolean().optional(),
          participant_video: z.boolean().optional(),
          personal_meeting: z.boolean().optional(),
          require_password_for_instant_meetings: z.boolean().optional(),
          require_password_for_pmi_meetings: z
            .union([z.literal('jbh_only'), z.literal('all'), z.literal('none')])
            .optional(),
          require_password_for_scheduled_meetings: z.boolean().optional(),
          require_password_for_scheduling_new_meetings: z.boolean().optional(),
          use_pmi_for_instant_meetings: z.boolean().optional(),
          use_pmi_for_scheduled_meetings: z.boolean().optional(),
        })
        .optional(),
      security: z
        .object({
          admin_change_name_pic: z.boolean().optional(),
          hide_billing_info: z.boolean().optional(),
          import_photos_from_devices: z.boolean().optional(),
          password_requirement: z
            .object({
              consecutive_characters_length: z.number().optional(),
              have_special_character: z.boolean().optional(),
              minimum_password_length: z.number().optional(),
              weak_enhance_detection: z.boolean().optional(),
            })
            .optional(),
          sign_again_period_for_inactivity_on_client: z.number().optional(),
          sign_again_period_for_inactivity_on_web: z.number().optional(),
          sign_in_with_two_factor_auth: z
            .union([z.literal('all'), z.literal('group'), z.literal('role'), z.literal('none')])
            .optional(),
          sign_in_with_two_factor_auth_groups: z.array(z.string()).optional(),
          sign_in_with_two_factor_auth_roles: z.array(z.string()).optional(),
        })
        .optional(),
      telephony: z
        .object({
          audio_conference_info: z.string().optional(),
          telephony_regions: z
            .object({
              selection_values: z.array(z.string()).optional(),
            })
            .optional(),
          third_party_audio: z.boolean().optional(),
        })
        .optional(),
      tsp: z
        .object({
          call_out: z.boolean().optional(),
          call_out_countries: z.array(z.unknown()).optional(),
          display_toll_free_numbers: z.boolean().optional(),
          show_international_numbers_link: z.boolean().optional(),
        })
        .optional(),
      zoom_rooms: z
        .object({
          auto_start_stop_scheduled_meetings: z.boolean().optional(),
          cmr_for_instant_meeting: z.boolean().optional(),
          force_private_meeting: z.boolean().optional(),
          hide_host_information: z.boolean().optional(),
          list_meetings_with_calendar: z.boolean().optional(),
          start_airplay_manually: z.boolean().optional(),
          ultrasonic: z.boolean().optional(),
          upcoming_meeting_alert: z.boolean().optional(),
          weekly_system_restart: z.boolean().optional(),
          zr_post_meeting_feedback: z.boolean().optional(),
        })
        .optional(),
    }),
    z.union([
      z.object({
        authentication_option: z
          .object({
            action: z.union([z.literal('update'), z.literal('delete'), z.literal('add')]).optional(),
            default_option: z.boolean().optional(),
            domains: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z
              .union([
                z.literal('enforce_login'),
                z.literal('enforce_login_with_same_account'),
                z.literal('enforce_login_with_domains'),
              ])
              .optional(),
          })
          .optional(),
        meeting_authentication: z.boolean().optional(),
      }),
      z.object({
        authentication_option: z
          .object({
            action: z.union([z.literal('update'), z.literal('delete'), z.literal('add')]).optional(),
            default_option: z.boolean().optional(),
            domains: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z
              .union([z.literal('internally'), z.literal('enforce_login'), z.literal('enforce_login_with_domains')])
              .optional(),
          })
          .optional(),
        recording_authentication: z.boolean().optional(),
      }),
    ]),
    z.object({
      meeting_security: z
        .object({
          auto_security: z.boolean().optional(),
          embed_password_in_join_link: z.boolean().optional(),
          encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
          end_to_end_encrypted_meetings: z.boolean().optional(),
          meeting_password: z.boolean().optional(),
          meeting_password_requirement: z
            .object({
              consecutive_characters_length: z
                .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
                .optional(),
              have_letter: z.boolean().optional(),
              have_number: z.boolean().optional(),
              have_special_character: z.boolean().optional(),
              have_upper_and_lower_characters: z.boolean().optional(),
              length: z.number().optional(),
              only_allow_numeric: z.boolean().optional(),
              weak_enhance_detection: z.boolean().optional(),
            })
            .optional(),
          phone_password: z.boolean().optional(),
          pmi_password: z.boolean().optional(),
          require_password_for_scheduled_meeting: z.boolean().optional(),
          require_password_for_scheduled_webinar: z.boolean().optional(),
          waiting_room: z.boolean().optional(),
          waiting_room_settings: z
            .object({
              participants_to_place_in_waiting_room: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
              users_who_can_admit_participants_from_waiting_room: z.number().optional(),
              whitelisted_domains_for_waiting_room: z.string().optional(),
            })
            .optional(),
          webinar_password: z.boolean().optional(),
        })
        .optional(),
    }),
  ]),
  path: z.object({
    accountId: z.string(),
  }),
  query: z
    .object({
      option: z
        .union([
          z.literal('meeting_authentication'),
          z.literal('recording_authentication'),
          z.literal('security'),
          z.literal('meeting_security'),
        ])
        .optional(),
    })
    .optional(),
});

export const accountSettingsUpdateResponseSchema = z.union([z.unknown(), z.any()]);

export const accountSettingsUpdateErrorSchema = z.unknown();

export const delVbDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
  query: z
    .object({
      file_ids: z.string().optional(),
    })
    .optional(),
});

export const delVbResponseSchema = z.any();

export const delVbErrorSchema = z.unknown();

export const uploadVbDataSchema = z.object({
  body: z
    .object({
      file: z.string().optional(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const uploadVbResponseSchema = z.object({
  id: z.string().optional(),
  is_default: z.boolean().optional(),
  name: z.string().optional(),
  size: z.string().optional(),
  type: z.string().optional(),
});

export const uploadVbErrorSchema = z.unknown();

export const listInternalCalloutCountriesDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
});

export const listInternalCalloutCountriesResponseSchema = z.object({
  callout_countries: z
    .array(
      z.object({
        code: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const listInternalCalloutCountriesErrorSchema = z.unknown();

export const addCalloutCountriesDataSchema = z.object({
  body: z
    .object({
      callout_countries: z.array(
        z.object({
          id: z.string(),
        }),
      ),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const addCalloutCountriesResponseSchema = z.object({
  callout_countries: z
    .array(
      z.object({
        code: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
});

export const addCalloutCountriesErrorSchema = z.unknown();

export const deleteInternalCallOutCountryDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
    countryId: z.string(),
  }),
});

export const deleteInternalCallOutCountryResponseSchema = z.unknown();

export const deleteInternalCallOutCountryErrorSchema = z.unknown();

export const listInternalNumbersDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const listInternalNumbersResponseSchema = z.object({
  internal_numbers: z
    .array(
      z.object({
        allow_for_external_meetings: z.boolean().optional(),
        allow_join: z.boolean().optional(),
        country: z.string(),
        display_number: z.string(),
        labels: z.string(),
        languages: z.union([z.literal('en-GB'), z.literal('en-US'), z.literal('de-DE')]),
        number: z.string(),
        type: z.union([z.literal(0), z.literal(1)]),
        visible: z.boolean().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
});

export const listInternalNumbersErrorSchema = z.unknown();

export const addInternalNumbersDataSchema = z.object({
  body: z
    .object({
      internal_numbers: z
        .array(
          z.object({
            allow_for_external_meetings: z.boolean().optional(),
            allow_join: z.boolean().optional(),
            country: z.string(),
            display_number: z.string(),
            labels: z.string(),
            languages: z.union([z.literal('en-GB'), z.literal('en-US'), z.literal('de-DE')]),
            number: z.string(),
            type: z.union([z.literal(0), z.literal(1)]),
            visible: z.boolean().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const addInternalNumbersResponseSchema = z.object({
  internal_numbers: z
    .array(
      z.object({
        allow_for_external_meetings: z.boolean().optional(),
        allow_join: z.boolean().optional(),
        country: z.string(),
        display_number: z.string(),
        id: z.string().optional(),
        labels: z.string(),
        languages: z.union([z.literal('en-GB'), z.literal('en-US'), z.literal('de-DE')]),
        number: z.string(),
        type: z.union([z.literal(0), z.literal(1)]),
        visible: z.boolean().optional(),
      }),
    )
    .optional(),
});

export const addInternalNumbersErrorSchema = z.unknown();

export const deleteInternalNumberDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
    numberId: z.string(),
  }),
});

export const deleteInternalNumberResponseSchema = z.unknown();

export const deleteInternalNumberErrorSchema = z.unknown();

export const deleteAllSipNumbersDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
});

export const deleteAllSipNumbersResponseSchema = z.unknown();

export const deleteAllSipNumbersErrorSchema = z.unknown();

export const assignSipTrunkNumbersDataSchema = z.object({
  body: z
    .object({
      phone_numbers: z.array(z.string()).optional(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const assignSipTrunkNumbersResponseSchema = z.unknown();

export const assignSipTrunkNumbersErrorSchema = z.unknown();

export const assignSipConfigDataSchema = z.object({
  body: z
    .object({
      enable: z.boolean().optional(),
      show_callout_internal_number: z.boolean().optional(),
      show_zoom_provided_callout_countries: z.number().optional(),
      show_zoom_provided_numbers: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const assignSipConfigResponseSchema = z.unknown();

export const assignSipConfigErrorSchema = z.unknown();

export const listSipTrunksDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
});

export const listSipTrunksResponseSchema = z.object({
  sip_trunks: z
    .array(
      z.object({
        dnis: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        number_prefix: z.string().optional(),
        outbound_caller_id: z.string().optional(),
        sip_server_address: z.string().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const listSipTrunksErrorSchema = z.unknown();

export const assignSipTrunksDataSchema = z.object({
  body: z
    .object({
      sip_trunks: z
        .array(
          z.object({
            dnis: z.string().optional(),
            id: z.string().optional(),
            outbound_caller_id: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
  }),
});

export const assignSipTrunksResponseSchema = z.object({
  sip_trunks: z
    .array(
      z.object({
        dnis: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        number_prefix: z.string().optional(),
        sip_server_address: z.string().optional(),
      }),
    )
    .optional(),
});

export const assignSipTrunksErrorSchema = z.unknown();

export const deleteSipTrunkDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
    trunkId: z.string(),
  }),
});

export const deleteSipTrunkResponseSchema = z.record(z.unknown());

export const deleteSipTrunkErrorSchema = z.unknown();

export const accountTrustedDomainDataSchema = z.object({
  path: z.object({
    accountId: z.string(),
  }),
});

export const accountTrustedDomainResponseSchema = z.object({
  trusted_domains: z.array(z.string()).optional(),
});

export const accountTrustedDomainErrorSchema = z.unknown();

export const switchUserAccountDataSchema = z.object({
  body: z
    .object({
      account_id: z.string(),
    })
    .optional(),
  path: z.object({
    accountId: z.string(),
    userId: z.string(),
  }),
});

export const switchUserAccountResponseSchema = z.unknown();

export const switchUserAccountErrorSchema = z.unknown();

export const downloadInvoicePdfDataSchema = z.object({
  path: z.object({
    invoiceId: z.string(),
  }),
});

export const downloadInvoicePdfResponseSchema = z.unknown();

export const downloadInvoicePdfErrorSchema = z.unknown();

export const listArchivedFilesDataSchema = z.object({
  query: z
    .object({
      from: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      query_data_type: z.union([z.literal('meeting_start_time'), z.literal('archive_complete_time')]).optional(),
      to: z.string().optional(),
    })
    .optional(),
});

export const listArchivedFilesResponseSchema = z.object({
  from: z.string().optional(),
  meetings: z
    .array(
      z.object({
        archive_files: z
          .array(
            z.object({
              download_url: z.string().optional(),
              file_extension: z.string().optional(),
              file_size: z.number().optional(),
              file_type: z.string().optional(),
              id: z.string().optional(),
              recording_type: z.string().optional(),
              status: z.string().optional(),
            }),
          )
          .optional(),
        duration: z.number().optional(),
        host_id: z.string().optional(),
        id: z.number().optional(),
        recording_count: z.number().optional(),
        start_time: z.string().optional(),
        timezone: z.string().optional(),
        topic: z.string().optional(),
        total_size: z.number().optional(),
        type: z.number().optional(),
        uuid: z.string().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  to: z.string().optional(),
});

export const listArchivedFilesErrorSchema = z.unknown();

export const deleteUserLevelChannelDataSchema = z.object({
  path: z.object({
    channelId: z.string(),
  }),
});

export const deleteUserLevelChannelResponseSchema = z.unknown();

export const deleteUserLevelChannelErrorSchema = z.unknown();

export const getUserLevelChannelDataSchema = z.object({
  path: z.object({
    channelId: z.string(),
  }),
});

export const getUserLevelChannelResponseSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
});

export const getUserLevelChannelErrorSchema = z.unknown();

export const updateUserLevelChannelDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
    })
    .optional(),
  path: z.object({
    channelId: z.string(),
  }),
});

export const updateUserLevelChannelResponseSchema = z.unknown();

export const updateUserLevelChannelErrorSchema = z.unknown();

export const leaveChannelDataSchema = z.object({
  path: z.object({
    channelId: z.string(),
  }),
});

export const leaveChannelResponseSchema = z.unknown();

export const leaveChannelErrorSchema = z.unknown();

export const joinChannelDataSchema = z.object({
  path: z.object({
    channelId: z.string(),
  }),
});

export const joinChannelResponseSchema = z.object({
  added_at: z.string().optional(),
  id: z.string().optional(),
});

export const joinChannelErrorSchema = z.unknown();

export const removeAuserLevelChannelMemberDataSchema = z.object({
  path: z.object({
    channelId: z.string(),
    memberId: z.string(),
  }),
});

export const removeAuserLevelChannelMemberResponseSchema = z.unknown();

export const removeAuserLevelChannelMemberErrorSchema = z.unknown();

export const getUserContactsDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const getUserContactsResponseSchema = z.object({
  contacts: z
    .array(
      z.object({
        email: z.string().optional(),
        first_name: z.string().optional(),
        id: z.string().optional(),
        last_name: z.string().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
});

export const getUserContactsErrorSchema = z.unknown();

export const getUserContactDataSchema = z.object({
  path: z.object({
    contactId: z.string(),
  }),
  query: z
    .object({
      query_presence_status: z.boolean().optional(),
    })
    .optional(),
});

export const getUserContactResponseSchema = z.object({
  direct_numbers: z.array(z.string()).optional(),
  email: z.string().optional(),
  extension_number: z.string().optional(),
  first_name: z.string().optional(),
  id: z.string().optional(),
  last_name: z.string().optional(),
  phone_number: z.string().optional(),
  presence_status: z
    .union([z.literal('Do_Not_Disturb'), z.literal('Away'), z.literal('Available'), z.literal('Offline')])
    .optional(),
});

export const getUserContactErrorSchema = z.unknown();

export const getChannelsDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const getChannelsResponseSchema = z.object({
  channels: z
    .array(
      z.object({
        channels_settings: z
          .object({
            allow_to_add_external_users: z.number().optional(),
            new_members_can_see_previous_messages_files: z.boolean().optional(),
            posting_permissions: z.number().optional(),
          })
          .optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        type: z.number().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
});

export const getChannelsErrorSchema = z.unknown();

export const createChannelDataSchema = z.object({
  body: z
    .object({
      members: z
        .array(
          z.object({
            email: z.string(),
          }),
        )
        .optional(),
      name: z.string().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
    })
    .optional(),
  path: z.object({
    userId: z.string(),
  }),
});

export const createChannelResponseSchema = z.object({
  id: z.string().optional(),
  jid: z.string().optional(),
  name: z.string().optional(),
  type: z.number().optional(),
});

export const createChannelErrorSchema = z.unknown();

export const deleteChannelDataSchema = z.object({
  path: z.object({
    channelId: z.string(),
    userId: z.string(),
  }),
});

export const deleteChannelResponseSchema = z.unknown();

export const deleteChannelErrorSchema = z.unknown();

export const getChannelDataSchema = z.object({
  path: z.object({
    channelId: z.string(),
    userId: z.string(),
  }),
});

export const getChannelResponseSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
});

export const getChannelErrorSchema = z.unknown();

export const updateChannelDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
    })
    .optional(),
  path: z.object({
    channelId: z.string(),
    userId: z.string(),
  }),
});

export const updateChannelResponseSchema = z.unknown();

export const updateChannelErrorSchema = z.unknown();

export const listChannelMembersDataSchema = z.object({
  path: z.object({
    channelId: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const listChannelMembersResponseSchema = z.object({
  members: z
    .array(
      z.object({
        email: z.string().optional(),
        first_name: z.string().optional(),
        id: z.string().optional(),
        last_name: z.string().optional(),
        role: z.union([z.literal('admin'), z.literal('owner'), z.literal('member')]).optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
});

export const listChannelMembersErrorSchema = z.unknown();

export const inviteChannelMembersDataSchema = z.object({
  body: z
    .object({
      members: z
        .array(
          z.object({
            email: z.string(),
          }),
        )
        .optional(),
    })
    .optional(),
  path: z.object({
    channelId: z.string(),
    userId: z.string(),
  }),
});

export const inviteChannelMembersResponseSchema = z.object({
  added_at: z.string().optional(),
  ids: z.array(z.string()).optional(),
});

export const inviteChannelMembersErrorSchema = z.unknown();

export const removeAchannelMemberDataSchema = z.object({
  path: z.object({
    channelId: z.string(),
    memberId: z.string(),
    userId: z.string(),
  }),
});

export const removeAchannelMemberResponseSchema = z.unknown();

export const removeAchannelMemberErrorSchema = z.unknown();

export const getChatMessagesDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      date: z.string().optional(),
      include_deleted_and_edited_message: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      to_channel: z.string().optional(),
      to_contact: z.string().optional(),
    })
    .optional(),
});

export const getChatMessagesResponseSchema = z.object({
  date: z.string().optional(),
  messages: z
    .array(
      z.object({
        date_time: z.string().optional(),
        id: z.string().optional(),
        message: z.string().optional(),
        reply_main_message_id: z.string().optional(),
        reply_main_message_timestamp: z.number().optional(),
        sender: z.string().optional(),
        status: z.union([z.literal('Deleted'), z.literal('Edited'), z.literal('Normal')]).optional(),
        timestamp: z.number().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
});

export const getChatMessagesErrorSchema = z.unknown();

export const sendaChatMessageDataSchema = z.object({
  body: z
    .object({
      at_items: z
        .array(
          z.object({
            at_contact: z.string().optional(),
            at_type: z.union([z.literal(1), z.literal(2)]).optional(),
            end_position: z.number().optional(),
            start_position: z.number().optional(),
          }),
        )
        .optional(),
      message: z.string(),
      to_channel: z.string().optional(),
      to_contact: z.string().optional(),
    })
    .optional(),
  path: z.object({
    userId: z.string(),
  }),
});

export const sendaChatMessageResponseSchema = z.object({
  id: z.string().optional(),
});

export const sendaChatMessageErrorSchema = z.unknown();

export const deleteChatMessageDataSchema = z.object({
  path: z.object({
    messageId: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      to_channel: z.string().optional(),
      to_contact: z.string().optional(),
    })
    .optional(),
});

export const deleteChatMessageResponseSchema = z.any();

export const deleteChatMessageErrorSchema = z.unknown();

export const editMessageDataSchema = z.object({
  body: z
    .object({
      message: z.string().optional(),
      to_channel: z.string().optional(),
      to_contact: z.string().optional(),
    })
    .optional(),
  path: z.object({
    messageId: z.string(),
    userId: z.string(),
  }),
});

export const editMessageResponseSchema = z.any();

export const editMessageErrorSchema = z.unknown();

export const searchCompanyContactsDataSchema = z.object({
  query: z.object({
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    query_presence_status: z.string().optional(),
    search_key: z.string(),
  }),
});

export const searchCompanyContactsResponseSchema = z.object({
  contacts: z
    .array(
      z.object({
        dept: z.string().optional(),
        direct_numbers: z.array(z.string()).optional(),
        email: z.string().optional(),
        extension_number: z.string().optional(),
        first_name: z.string().optional(),
        id: z.string().optional(),
        im_group_id: z.string().optional(),
        im_group_name: z.string().optional(),
        job_title: z.string().optional(),
        last_name: z.string().optional(),
        location: z.string().optional(),
        phone_number: z.string().optional(),
        presence_status: z
          .union([z.literal('Do_Not_Disturb'), z.literal('Away'), z.literal('Available'), z.literal('Offline')])
          .optional(),
        sip_phone_number: z.string().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
});

export const searchCompanyContactsErrorSchema = z.unknown();

export const groupsResponseSchema = z.object({
  groups: z
    .array(
      z
        .object({
          id: z.string().optional(),
        })
        .and(
          z.object({
            name: z.string().optional(),
            total_members: z.number().optional(),
          }),
        ),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const groupsErrorSchema = z.unknown();

export const groupCreateDataSchema = z.object({
  body: z.object({
    name: z.string().optional(),
  }),
});

export const groupCreateResponseSchema = z.union([
  z.unknown(),
  z.object({
    id: z.string().optional(),
    name: z.string().optional(),
    total_members: z.number().optional(),
  }),
]);

export const groupCreateErrorSchema = z.unknown();

export const groupDeleteDataSchema = z.object({
  path: z.object({
    groupId: z.string(),
  }),
});

export const groupDeleteResponseSchema = z.union([z.unknown(), z.any()]);

export const groupDeleteErrorSchema = z.unknown();

export const groupDataSchema = z.object({
  path: z.object({
    groupId: z.string(),
  }),
});

export const groupResponseSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  total_members: z.number().optional(),
});

export const groupErrorSchema = z.unknown();

export const groupUpdateDataSchema = z.object({
  body: z.object({
    name: z.string().optional(),
  }),
  path: z.object({
    groupId: z.string(),
  }),
});

export const groupUpdateResponseSchema = z.union([z.unknown(), z.any()]);

export const groupUpdateErrorSchema = z.unknown();

export const getGroupLockSettingsDataSchema = z.object({
  path: z.object({
    groupId: z.string(),
  }),
  query: z
    .object({
      custom_query_fields: z.string().optional(),
      option: z.string().optional(),
    })
    .optional(),
});

export const getGroupLockSettingsResponseSchema = z.union([
  z.object({
    email_notification: z
      .object({
        alternative_host_reminder: z.boolean().optional(),
        cancel_meeting_reminder: z.boolean().optional(),
        cloud_recording_available_reminder: z.boolean().optional(),
        jbh_reminder: z.boolean().optional(),
        schedule_for_host_reminder: z.boolean().optional(),
      })
      .optional(),
    in_meeting: z
      .object({
        alert_guest_join: z.boolean().optional(),
        allow_show_zoom_windows: z.boolean().optional(),
        annotation: z.boolean().optional(),
        attendee_on_hold: z.boolean().optional(),
        auto_answer: z.boolean().optional(),
        auto_saving_chat: z.boolean().optional(),
        breakout_room: z.boolean().optional(),
        chat: z.boolean().optional(),
        closed_caption: z.boolean().optional(),
        co_host: z.boolean().optional(),
        custom_data_center_regions: z.boolean().optional(),
        e2e_encryption: z.boolean().optional(),
        entry_exit_chime: z.string().optional(),
        far_end_camera_control: z.boolean().optional(),
        feedback: z.boolean().optional(),
        file_transfer: z.boolean().optional(),
        group_hd: z.boolean().optional(),
        non_verbal_feedback: z.boolean().optional(),
        original_audio: z.boolean().optional(),
        polling: z.boolean().optional(),
        post_meeting_feedback: z.boolean().optional(),
        private_chat: z.boolean().optional(),
        remote_control: z.boolean().optional(),
        remote_support: z.boolean().optional(),
        request_permission_to_unmute: z.boolean().optional(),
        screen_sharing: z.boolean().optional(),
        sending_default_email_invites: z.boolean().optional(),
        show_browser_join_link: z.boolean().optional(),
        show_meeting_control_toolbar: z.boolean().optional(),
        stereo_audio: z.boolean().optional(),
        use_html_format_email: z.boolean().optional(),
        virtual_background: z.boolean().optional(),
        waiting_room: z.boolean().optional(),
        whiteboard: z.boolean().optional(),
      })
      .optional(),
    recording: z
      .object({
        account_user_access_recording: z.boolean().optional(),
        auto_delete_cmr: z.boolean().optional(),
        auto_recording: z.string().optional(),
        cloud_recording: z.boolean().optional(),
        cloud_recording_download: z.boolean().optional(),
        host_delete_cloud_recording: z.boolean().optional(),
        ip_address_access_control: z
          .object({
            enable: z.boolean().optional(),
            ip_addresses_or_ranges: z.string().optional(),
          })
          .optional(),
        local_recording: z.boolean().optional(),
        prevent_host_access_recording: z.boolean().optional(),
        recording_authentication: z.boolean().optional(),
      })
      .optional(),
    schedule_meeting: z
      .object({
        audio_type: z.boolean().optional(),
        embed_password_in_join_link: z.boolean().optional(),
        force_pmi_jbh_password: z.boolean().optional(),
        host_video: z.boolean().optional(),
        join_before_host: z.boolean().optional(),
        meeting_authentication: z.boolean().optional(),
        mute_upon_entry: z.boolean().optional(),
        participant_video: z.boolean().optional(),
        pstn_password_protected: z.boolean().optional(),
        require_password_for_instant_meetings: z.boolean().optional(),
        require_password_for_pmi_meetings: z.boolean().optional(),
        require_password_for_scheduling_new_meetings: z.boolean().optional(),
        upcoming_meeting_reminder: z.boolean().optional(),
      })
      .optional(),
    telephony: z
      .object({
        telephony_regions: z.boolean().optional(),
        third_party_audio: z.boolean().optional(),
      })
      .optional(),
  }),
  z.object({
    meeting_security: z
      .object({
        auto_security: z.boolean().optional(),
        embed_password_in_join_link: z.boolean().optional(),
        encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
        end_to_end_encrypted_meetings: z.boolean().optional(),
        meeting_password: z.boolean().optional(),
        meeting_password_requirement: z
          .object({
            consecutive_characters_length: z
              .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
              .optional(),
            have_letter: z.boolean().optional(),
            have_number: z.boolean().optional(),
            have_special_character: z.boolean().optional(),
            have_upper_and_lower_characters: z.boolean().optional(),
            length: z.number().optional(),
            only_allow_numeric: z.boolean().optional(),
            weak_enhance_detection: z.boolean().optional(),
          })
          .optional(),
        phone_password: z.boolean().optional(),
        pmi_password: z.boolean().optional(),
        require_password_for_scheduled_meeting: z.boolean().optional(),
        require_password_for_scheduled_webinar: z.boolean().optional(),
        waiting_room: z.boolean().optional(),
        waiting_room_settings: z
          .object({
            participants_to_place_in_waiting_room: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
            users_who_can_admit_participants_from_waiting_room: z.number().optional(),
            whitelisted_domains_for_waiting_room: z.string().optional(),
          })
          .optional(),
        webinar_password: z.boolean().optional(),
      })
      .optional(),
  }),
]);

export const getGroupLockSettingsErrorSchema = z.unknown();

export const groupLockedSettingsDataSchema = z.object({
  body: z
    .union([
      z.object({
        email_notification: z
          .object({
            alternative_host_reminder: z.boolean().optional(),
            cancel_meeting_reminder: z.boolean().optional(),
            cloud_recording_available_reminder: z.boolean().optional(),
            jbh_reminder: z.boolean().optional(),
            schedule_for_host_reminder: z.boolean().optional(),
          })
          .optional(),
        in_meeting: z
          .object({
            alert_guest_join: z.boolean().optional(),
            allow_show_zoom_windows: z.boolean().optional(),
            annotation: z.boolean().optional(),
            attendee_on_hold: z.boolean().optional(),
            auto_answer: z.boolean().optional(),
            auto_saving_chat: z.boolean().optional(),
            breakout_room: z.boolean().optional(),
            chat: z.boolean().optional(),
            closed_caption: z.boolean().optional(),
            co_host: z.boolean().optional(),
            custom_data_center_regions: z.boolean().optional(),
            e2e_encryption: z.boolean().optional(),
            entry_exit_chime: z.string().optional(),
            far_end_camera_control: z.boolean().optional(),
            feedback: z.boolean().optional(),
            file_transfer: z.boolean().optional(),
            group_hd: z.boolean().optional(),
            non_verbal_feedback: z.boolean().optional(),
            original_audio: z.boolean().optional(),
            polling: z.boolean().optional(),
            post_meeting_feedback: z.boolean().optional(),
            private_chat: z.boolean().optional(),
            remote_control: z.boolean().optional(),
            remote_support: z.boolean().optional(),
            request_permission_to_unmute: z.boolean().optional(),
            screen_sharing: z.boolean().optional(),
            sending_default_email_invites: z.boolean().optional(),
            show_browser_join_link: z.boolean().optional(),
            show_meeting_control_toolbar: z.boolean().optional(),
            stereo_audio: z.boolean().optional(),
            use_html_format_email: z.boolean().optional(),
            virtual_background: z.boolean().optional(),
            waiting_room: z.boolean().optional(),
            whiteboard: z.boolean().optional(),
          })
          .optional(),
        recording: z
          .object({
            account_user_access_recording: z.boolean().optional(),
            auto_delete_cmr: z.boolean().optional(),
            auto_recording: z.string().optional(),
            cloud_recording: z.boolean().optional(),
            cloud_recording_download: z.boolean().optional(),
            host_delete_cloud_recording: z.boolean().optional(),
            ip_address_access_control: z
              .object({
                enable: z.boolean().optional(),
                ip_addresses_or_ranges: z.string().optional(),
              })
              .optional(),
            local_recording: z.boolean().optional(),
            recording_authentication: z.string().optional(),
          })
          .optional(),
        schedule_meeting: z
          .object({
            audio_type: z.boolean().optional(),
            embed_password_in_join_link: z.boolean().optional(),
            force_pmi_jbh_password: z.boolean().optional(),
            host_video: z.boolean().optional(),
            join_before_host: z.boolean().optional(),
            meeting_authentication: z.boolean().optional(),
            mute_upon_entry: z.boolean().optional(),
            participant_video: z.boolean().optional(),
            personal_meeting: z.boolean().optional(),
            pstn_password_protected: z.boolean().optional(),
            require_password_for_instant_meetings: z.boolean().optional(),
            require_password_for_pmi_meetings: z.boolean().optional(),
            require_password_for_scheduling_new_meetings: z.boolean().optional(),
            upcoming_meeting_reminder: z.boolean().optional(),
          })
          .optional(),
        telephony: z
          .object({
            telephony_regions: z.boolean().optional(),
            third_party_audio: z.boolean().optional(),
          })
          .optional(),
      }),
      z.object({
        meeting_security: z
          .object({
            auto_security: z.boolean().optional(),
            embed_password_in_join_link: z.boolean().optional(),
            encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
            end_to_end_encrypted_meetings: z.boolean().optional(),
            meeting_password: z.boolean().optional(),
            meeting_password_requirement: z
              .object({
                consecutive_characters_length: z
                  .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
                  .optional(),
                have_letter: z.boolean().optional(),
                have_number: z.boolean().optional(),
                have_special_character: z.boolean().optional(),
                have_upper_and_lower_characters: z.boolean().optional(),
                length: z.number().optional(),
                only_allow_numeric: z.boolean().optional(),
                weak_enhance_detection: z.boolean().optional(),
              })
              .optional(),
            phone_password: z.boolean().optional(),
            pmi_password: z.boolean().optional(),
            require_password_for_scheduled_meeting: z.boolean().optional(),
            require_password_for_scheduled_webinar: z.boolean().optional(),
            waiting_room: z.boolean().optional(),
            waiting_room_settings: z
              .object({
                participants_to_place_in_waiting_room: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
                users_who_can_admit_participants_from_waiting_room: z.number().optional(),
                whitelisted_domains_for_waiting_room: z.string().optional(),
              })
              .optional(),
            webinar_password: z.boolean().optional(),
          })
          .optional(),
      }),
    ])
    .optional(),
  path: z.object({
    groupId: z.string(),
  }),
  query: z
    .object({
      custom_query_fields: z.string().optional(),
      option: z.string().optional(),
    })
    .optional(),
});

export const groupLockedSettingsResponseSchema = z.unknown();

export const groupLockedSettingsErrorSchema = z.unknown();

export const groupMembersDataSchema = z.object({
  path: z.object({
    groupId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_number: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const groupMembersResponseSchema = z.object({
  members: z
    .array(
      z.object({
        email: z.string().optional(),
        first_name: z.string().optional(),
        id: z.string().optional(),
        last_name: z.string().optional(),
        type: z.number().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_number: z.number().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
});

export const groupMembersErrorSchema = z.unknown();

export const groupMembersCreateDataSchema = z.object({
  body: z.object({
    members: z
      .array(
        z.object({
          email: z.string().optional(),
          id: z.string().optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    groupId: z.string(),
  }),
});

export const groupMembersCreateResponseSchema = z.union([
  z.unknown(),
  z.object({
    added_at: z.string().optional(),
    ids: z.string().optional(),
  }),
]);

export const groupMembersCreateErrorSchema = z.unknown();

export const groupMembersDeleteDataSchema = z.object({
  path: z.object({
    groupId: z.string(),
    memberId: z.string(),
  }),
});

export const groupMembersDeleteResponseSchema = z.union([z.unknown(), z.any()]);

export const groupMembersDeleteErrorSchema = z.unknown();

export const updateAgroupMemberDataSchema = z.object({
  body: z
    .object({
      action: z.union([z.literal('move'), z.literal('set_primary')]),
      target_group_id: z.string().optional(),
    })
    .optional(),
  path: z.object({
    groupId: z.string(),
    memberId: z.string(),
  }),
});

export const updateAgroupMemberResponseSchema = z.unknown();

export const updateAgroupMemberErrorSchema = z.unknown();

export const getGroupSettingsDataSchema = z.object({
  path: z.object({
    groupId: z.string(),
  }),
  query: z
    .object({
      custom_query_fields: z.string().optional(),
      option: z.union([z.literal('meeting_authentication'), z.literal('recording_authentication')]).optional(),
    })
    .optional(),
});

export const getGroupSettingsResponseSchema = z.union([
  z.object({
    email_notification: z
      .object({
        alternative_host_reminder: z.boolean().optional(),
        cancel_meeting_reminder: z.boolean().optional(),
        cloud_recording_available_reminder: z.boolean().optional(),
        jbh_reminder: z.boolean().optional(),
        schedule_for_host_reminder: z.boolean().optional(),
      })
      .optional(),
    in_meeting: z
      .object({
        alert_guest_join: z.boolean().optional(),
        allow_show_zoom_windows: z.boolean().optional(),
        annotation: z.boolean().optional(),
        attendee_on_hold: z.boolean().optional(),
        auto_answer: z.boolean().optional(),
        auto_saving_chat: z.boolean().optional(),
        breakout_room: z.boolean().optional(),
        chat: z.boolean().optional(),
        closed_caption: z.boolean().optional(),
        co_host: z.boolean().optional(),
        custom_data_center_regions: z.boolean().optional(),
        data_center_regions: z
          .union([
            z.literal('EU'),
            z.literal('HK'),
            z.literal('AU'),
            z.literal('IN'),
            z.literal('TY'),
            z.literal('CN'),
            z.literal('US'),
            z.literal('CA'),
          ])
          .optional(),
        e2e_encryption: z.boolean().optional(),
        entry_exit_chime: z.string().optional(),
        far_end_camera_control: z.boolean().optional(),
        feedback: z.boolean().optional(),
        file_transfer: z.boolean().optional(),
        group_hd: z.boolean().optional(),
        non_verbal_feedback: z.boolean().optional(),
        only_host_view_device_list: z.boolean().optional(),
        original_audio: z.boolean().optional(),
        polling: z.boolean().optional(),
        post_meeting_feedback: z.boolean().optional(),
        private_chat: z.boolean().optional(),
        record_play_own_voice: z.boolean().optional(),
        remote_control: z.boolean().optional(),
        remote_support: z.boolean().optional(),
        request_permission_to_unmute: z.boolean().optional(),
        screen_sharing: z.boolean().optional(),
        sending_default_email_invites: z.boolean().optional(),
        show_browser_join_link: z.boolean().optional(),
        show_device_list: z.boolean().optional(),
        show_meeting_control_toolbar: z.boolean().optional(),
        stereo_audio: z.boolean().optional(),
        use_html_format_email: z.boolean().optional(),
        virtual_background: z.boolean().optional(),
        virtual_background_settings: z
          .object({
            allow_upload_custom: z.boolean().optional(),
            allow_videos: z.boolean().optional(),
            enable: z.boolean().optional(),
            files: z
              .array(
                z.object({
                  id: z.string().optional(),
                  is_default: z.boolean().optional(),
                  name: z.string().optional(),
                  size: z.string().optional(),
                  type: z.string().optional(),
                }),
              )
              .optional(),
          })
          .optional(),
        waiting_room: z.boolean().optional(),
        whiteboard: z.boolean().optional(),
        who_can_share_screen: z.union([z.literal('host'), z.literal('all')]).optional(),
        who_can_share_screen_when_someone_is_sharing: z.union([z.literal('host'), z.literal('all')]).optional(),
      })
      .optional(),
    profile: z
      .object({
        recording_storage_location: z
          .object({
            allowed_values: z.array(z.string()).optional(),
            value: z.string().optional(),
          })
          .optional(),
      })
      .optional(),
    recording: z
      .object({
        account_user_access_recording: z.boolean().optional(),
        archive: z
          .object({
            enable: z.boolean().optional(),
            settings: z
              .object({
                audio_file: z.boolean().optional(),
                cc_transcript_file: z.boolean().optional(),
                chat_file: z.boolean().optional(),
                chat_with_sender_email: z.boolean().optional(),
                video_file: z.boolean().optional(),
              })
              .optional(),
            type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
          })
          .optional(),
        auto_recording: z.string().optional(),
        cloud_recording: z.boolean().optional(),
        cloud_recording_download: z.boolean().optional(),
        cloud_recording_download_host: z.boolean().optional(),
        host_delete_cloud_recording: z.boolean().optional(),
        ip_address_access_control: z
          .object({
            enable: z.boolean().optional(),
            ip_addresses_or_ranges: z.string().optional(),
          })
          .optional(),
        local_recording: z.boolean().optional(),
        prevent_host_access_recording: z.boolean().optional(),
        record_audio_file: z.boolean().optional(),
        record_gallery_view: z.boolean().optional(),
        record_speaker_view: z.boolean().optional(),
        recording_audio_transcript: z.boolean().optional(),
        save_chat_text: z.boolean().optional(),
        show_timestamp: z.boolean().optional(),
      })
      .optional(),
    schedule_meeting: z
      .object({
        audio_type: z.string().optional(),
        embed_password_in_join_link: z.boolean().optional(),
        force_pmi_jbh_password: z.boolean().optional(),
        host_video: z.boolean().optional(),
        join_before_host: z.boolean().optional(),
        mute_upon_entry: z.boolean().optional(),
        participant_video: z.boolean().optional(),
        personal_meeting: z.boolean().optional(),
        pstn_password_protected: z.boolean().optional(),
        require_password_for_instant_meetings: z.boolean().optional(),
        require_password_for_pmi_meetings: z
          .union([z.literal('all'), z.literal('jbh_only'), z.literal('none')])
          .optional(),
        require_password_for_scheduled_meetings: z.boolean().optional(),
        require_password_for_scheduling_new_meetings: z.boolean().optional(),
        upcoming_meeting_reminder: z.boolean().optional(),
        use_pmi_for_instant_meetings: z.boolean().optional(),
        use_pmi_for_schedule_meetings: z.boolean().optional(),
      })
      .optional(),
    telephony: z
      .object({
        audio_conference_info: z.string().optional(),
        telephony_regions: z
          .object({
            selection_values: z.array(z.string()).optional(),
          })
          .optional(),
        third_party_audio: z.boolean().optional(),
      })
      .optional(),
  }),
  z.union([
    z.object({
      authentication_options: z
        .array(
          z.object({
            default_option: z.boolean().optional(),
            domains: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z
              .union([
                z.literal('enforce_login'),
                z.literal('enforce_login_with_same_account'),
                z.literal('enforce_login_with_domains'),
              ])
              .optional(),
            visible: z.boolean().optional(),
          }),
        )
        .optional(),
      meeting_authentication: z.boolean().optional(),
    }),
    z.object({
      authentication_options: z
        .array(
          z.object({
            default_option: z.boolean().optional(),
            domains: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z
              .union([z.literal('internally'), z.literal('enforce_login'), z.literal('enforce_login_with_domains')])
              .optional(),
            visible: z.boolean().optional(),
          }),
        )
        .optional(),
      recording_authentication: z.boolean().optional(),
    }),
  ]),
  z.object({
    meeting_security: z
      .object({
        auto_security: z.boolean().optional(),
        embed_password_in_join_link: z.boolean().optional(),
        encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
        end_to_end_encrypted_meetings: z.boolean().optional(),
        meeting_password: z.boolean().optional(),
        meeting_password_requirement: z
          .object({
            consecutive_characters_length: z
              .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
              .optional(),
            have_letter: z.boolean().optional(),
            have_number: z.boolean().optional(),
            have_special_character: z.boolean().optional(),
            have_upper_and_lower_characters: z.boolean().optional(),
            length: z.number().optional(),
            only_allow_numeric: z.boolean().optional(),
            weak_enhance_detection: z.boolean().optional(),
          })
          .optional(),
        phone_password: z.boolean().optional(),
        pmi_password: z.boolean().optional(),
        require_password_for_scheduled_meeting: z.boolean().optional(),
        require_password_for_scheduled_webinar: z.boolean().optional(),
        waiting_room: z.boolean().optional(),
        waiting_room_settings: z
          .object({
            participants_to_place_in_waiting_room: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
            users_who_can_admit_participants_from_waiting_room: z.number().optional(),
            whitelisted_domains_for_waiting_room: z.string().optional(),
          })
          .optional(),
        webinar_password: z.boolean().optional(),
      })
      .optional(),
  }),
]);

export const getGroupSettingsErrorSchema = z.unknown();

export const updateGroupSettingsDataSchema = z.object({
  body: z
    .union([
      z.object({
        email_notification: z
          .object({
            alternative_host_reminder: z.boolean().optional(),
            cancel_meeting_reminder: z.boolean().optional(),
            cloud_recording_available_reminder: z.boolean().optional(),
            jbh_reminder: z.boolean().optional(),
            schedule_for_host_reminder: z.boolean().optional(),
          })
          .optional(),
        in_meeting: z
          .object({
            alert_guest_join: z.boolean().optional(),
            allow_show_zoom_windows: z.boolean().optional(),
            annotation: z.boolean().optional(),
            attendee_on_hold: z.boolean().optional(),
            auto_answer: z.boolean().optional(),
            auto_saving_chat: z.boolean().optional(),
            breakout_room: z.boolean().optional(),
            chat: z.boolean().optional(),
            closed_caption: z.boolean().optional(),
            co_host: z.boolean().optional(),
            custom_data_center_regions: z.boolean().optional(),
            data_center_regions: z
              .union([
                z.literal('EU'),
                z.literal('HK'),
                z.literal('AU'),
                z.literal('IN'),
                z.literal('TY'),
                z.literal('CN'),
                z.literal('US'),
                z.literal('CA'),
              ])
              .optional(),
            e2e_encryption: z.boolean().optional(),
            entry_exit_chime: z.string().optional(),
            far_end_camera_control: z.boolean().optional(),
            feedback: z.boolean().optional(),
            file_transfer: z.boolean().optional(),
            group_hd: z.boolean().optional(),
            non_verbal_feedback: z.boolean().optional(),
            only_host_view_device_list: z.boolean().optional(),
            original_audio: z.boolean().optional(),
            polling: z.boolean().optional(),
            post_meeting_feedback: z.boolean().optional(),
            private_chat: z.boolean().optional(),
            record_play_own_voice: z.boolean().optional(),
            remote_control: z.boolean().optional(),
            remote_support: z.boolean().optional(),
            request_permission_to_unmute: z.boolean().optional(),
            screen_sharing: z.boolean().optional(),
            sending_default_email_invites: z.boolean().optional(),
            show_browser_join_link: z.boolean().optional(),
            show_device_list: z.boolean().optional(),
            show_meeting_control_toolbar: z.boolean().optional(),
            stereo_audio: z.boolean().optional(),
            use_html_format_email: z.boolean().optional(),
            virtual_background: z.boolean().optional(),
            waiting_room: z.boolean().optional(),
            whiteboard: z.boolean().optional(),
            who_can_share_screen: z.union([z.literal('host'), z.literal('all')]).optional(),
            who_can_share_screen_when_someone_is_sharing: z.union([z.literal('host'), z.literal('all')]).optional(),
          })
          .optional(),
        profile: z
          .object({
            recording_storage_location: z
              .object({
                allowed_values: z.array(z.string()).optional(),
                value: z.string().optional(),
              })
              .optional(),
          })
          .optional(),
        recording: z
          .object({
            account_user_access_recording: z.boolean().optional(),
            archive: z
              .object({
                enable: z.boolean().optional(),
                settings: z
                  .object({
                    audio_file: z.boolean().optional(),
                    cc_transcript_file: z.boolean().optional(),
                    chat_file: z.boolean().optional(),
                    chat_with_sender_email: z.boolean().optional(),
                    video_file: z.boolean().optional(),
                  })
                  .optional(),
                type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
              })
              .optional(),
            auto_recording: z.string().optional(),
            cloud_recording: z.boolean().optional(),
            cloud_recording_download: z.boolean().optional(),
            cloud_recording_download_host: z.boolean().optional(),
            host_delete_cloud_recording: z.boolean().optional(),
            ip_address_access_control: z
              .object({
                enable: z.boolean().optional(),
                ip_addresses_or_ranges: z.string().optional(),
              })
              .optional(),
            local_recording: z.boolean().optional(),
            prevent_host_access_recording: z.boolean().optional(),
            record_audio_file: z.boolean().optional(),
            record_gallery_view: z.boolean().optional(),
            record_speaker_view: z.boolean().optional(),
            recording_audio_transcript: z.boolean().optional(),
            save_chat_text: z.boolean().optional(),
            show_timestamp: z.boolean().optional(),
          })
          .optional(),
        schedule_meeting: z
          .object({
            audio_type: z.string().optional(),
            embed_password_in_join_link: z.boolean().optional(),
            force_pmi_jbh_password: z.boolean().optional(),
            host_video: z.boolean().optional(),
            join_before_host: z.boolean().optional(),
            mute_upon_entry: z.boolean().optional(),
            participant_video: z.boolean().optional(),
            pstn_password_protected: z.boolean().optional(),
            require_password_for_all_meetings: z.boolean().optional(),
            require_password_for_instant_meetings: z.boolean().optional(),
            require_password_for_pmi_meetings: z
              .union([z.literal('all'), z.literal('jbh_only'), z.literal('none')])
              .optional(),
            require_password_for_scheduled_meetings: z.boolean().optional(),
            require_password_for_scheduling_new_meetings: z.boolean().optional(),
            upcoming_meeting_reminder: z.boolean().optional(),
          })
          .optional(),
        telephony: z
          .object({
            audio_conference_info: z.string().optional(),
            third_party_audio: z.boolean().optional(),
          })
          .optional(),
      }),
      z.union([
        z.object({
          authentication_option: z
            .object({
              action: z.union([z.literal('update'), z.literal('show'), z.literal('hide')]).optional(),
              default_option: z.boolean().optional(),
              domains: z.string().optional(),
              id: z.string().optional(),
              name: z.string().optional(),
              type: z
                .union([
                  z.literal('enforce_login'),
                  z.literal('enforce_login_with_same_account'),
                  z.literal('enforce_login_with_domains'),
                ])
                .optional(),
            })
            .optional(),
          meeting_authentication: z.boolean().optional(),
        }),
        z.object({
          authentication_option: z
            .object({
              action: z.union([z.literal('update'), z.literal('show'), z.literal('hide')]).optional(),
              default_option: z.boolean().optional(),
              domians: z.string().optional(),
              id: z.string().optional(),
              name: z.string().optional(),
              type: z
                .union([z.literal('internally'), z.literal('enforce_login'), z.literal('enforce_login_with_domains')])
                .optional(),
            })
            .optional(),
          recording_authentication: z.boolean().optional(),
        }),
      ]),
      z.object({
        meeting_security: z
          .object({
            auto_security: z.boolean().optional(),
            embed_password_in_join_link: z.boolean().optional(),
            encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
            end_to_end_encrypted_meetings: z.boolean().optional(),
            meeting_password: z.boolean().optional(),
            meeting_password_requirement: z
              .object({
                consecutive_characters_length: z
                  .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
                  .optional(),
                have_letter: z.boolean().optional(),
                have_number: z.boolean().optional(),
                have_special_character: z.boolean().optional(),
                have_upper_and_lower_characters: z.boolean().optional(),
                length: z.number().optional(),
                only_allow_numeric: z.boolean().optional(),
                weak_enhance_detection: z.boolean().optional(),
              })
              .optional(),
            phone_password: z.boolean().optional(),
            pmi_password: z.boolean().optional(),
            require_password_for_scheduled_meeting: z.boolean().optional(),
            require_password_for_scheduled_webinar: z.boolean().optional(),
            waiting_room: z.boolean().optional(),
            waiting_room_settings: z
              .object({
                participants_to_place_in_waiting_room: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
                users_who_can_admit_participants_from_waiting_room: z.number().optional(),
                whitelisted_domains_for_waiting_room: z.string().optional(),
              })
              .optional(),
            webinar_password: z.boolean().optional(),
          })
          .optional(),
      }),
    ])
    .optional(),
  path: z.object({
    groupId: z.string(),
  }),
  query: z
    .object({
      custom_query_fields: z.string().optional(),
      option: z
        .union([
          z.literal('meeting_authentication'),
          z.literal('recording_authentication'),
          z.literal('meeting_security'),
        ])
        .optional(),
    })
    .optional(),
});

export const updateGroupSettingsResponseSchema = z.unknown();

export const updateGroupSettingsErrorSchema = z.unknown();

export const delGroupVbDataSchema = z.object({
  path: z.object({
    groupId: z.string(),
  }),
  query: z
    .object({
      file_ids: z.string().optional(),
    })
    .optional(),
});

export const delGroupVbResponseSchema = z.any();

export const delGroupVbErrorSchema = z.unknown();

export const uploadGroupVbDataSchema = z.object({
  body: z
    .object({
      file: z.string().optional(),
    })
    .optional(),
  path: z.object({
    groupId: z.string(),
  }),
  query: z
    .object({
      file_ids: z.string().optional(),
    })
    .optional(),
});

export const uploadGroupVbResponseSchema = z.object({
  id: z.string().optional(),
  is_default: z.boolean().optional(),
  name: z.string().optional(),
  size: z.string().optional(),
  type: z.string().optional(),
});

export const uploadGroupVbErrorSchema = z.unknown();

export const deviceListDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_number: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const deviceListResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      devices: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z.object({
                encryption: z.union([z.literal('auto'), z.literal('yes'), z.literal('no')]),
                ip: z.string(),
                name: z.string(),
                protocol: z.union([z.literal('H.323'), z.literal('SIP')]),
              }),
            ),
        )
        .optional(),
    }),
  );

export const deviceListErrorSchema = z.unknown();

export const deviceCreateDataSchema = z.object({
  body: z.object({
    encryption: z.union([z.literal('auto'), z.literal('yes'), z.literal('no')]),
    ip: z.string(),
    name: z.string(),
    protocol: z.union([z.literal('H.323'), z.literal('SIP')]),
  }),
});

export const deviceCreateResponseSchema = z.union([
  z.unknown(),
  z
    .object({
      id: z.string().optional(),
    })
    .and(
      z.object({
        encryption: z.union([z.literal('auto'), z.literal('yes'), z.literal('no')]),
        ip: z.string(),
        name: z.string(),
        protocol: z.union([z.literal('H.323'), z.literal('SIP')]),
      }),
    ),
]);

export const deviceCreateErrorSchema = z.unknown();

export const deviceDeleteDataSchema = z.object({
  path: z.object({
    deviceId: z.string(),
  }),
});

export const deviceDeleteResponseSchema = z.union([z.unknown(), z.any()]);

export const deviceDeleteErrorSchema = z.unknown();

export const deviceUpdateDataSchema = z.object({
  body: z.object({
    encryption: z.union([z.literal('auto'), z.literal('yes'), z.literal('no')]),
    ip: z.string(),
    name: z.string(),
    protocol: z.union([z.literal('H.323'), z.literal('SIP')]),
  }),
  path: z.object({
    deviceId: z.string(),
  }),
});

export const deviceUpdateResponseSchema = z.any();

export const deviceUpdateErrorSchema = z.unknown();

export const sendchatbotDataSchema = z.object({
  body: z
    .object({
      account_id: z.string(),
      content: z.record(z.unknown()),
      is_markdown_support: z.boolean().optional(),
      robot_jid: z.string(),
      to_jid: z.string(),
      user_jid: z.string().optional(),
      visible_to_user: z.string().optional(),
    })
    .optional(),
});

export const sendchatbotResponseSchema = z.unknown();

export const sendchatbotErrorSchema = z.unknown();

export const deleteAchatbotMessageDataSchema = z.object({
  body: z
    .object({
      account_id: z.string(),
      robot_jid: z.string(),
      user_jid: z.string().optional(),
    })
    .optional(),
  path: z.object({
    message_id: z.string(),
  }),
});

export const deleteAchatbotMessageResponseSchema = z.object({
  message_id: z.string().optional(),
  robot_jid: z.string().optional(),
  sent_time: z.string().optional(),
  to_jid: z.string().optional(),
  user_jid: z.string().optional(),
});

export const deleteAchatbotMessageErrorSchema = z.unknown();

export const editChatbotMessageDataSchema = z.object({
  body: z
    .object({
      account_id: z.string(),
      content: z.record(z.unknown()),
      is_markdown_support: z.boolean().optional(),
      robot_jid: z.string(),
      user_jid: z.string().optional(),
    })
    .optional(),
  path: z.object({
    message_id: z.string(),
  }),
});

export const editChatbotMessageResponseSchema = z.object({
  message_id: z.string().optional(),
  robot_jid: z.string().optional(),
  sent_time: z.string().optional(),
  to_jid: z.string().optional(),
  user_jid: z.string().optional(),
});

export const editChatbotMessageErrorSchema = z.unknown();

export const imChatSessionsDataSchema = z.object({
  query: z.object({
    from: z.string(),
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    to: z.string(),
  }),
});

export const imChatSessionsResponseSchema = z
  .object({
    from: z.string().optional(),
    to: z.string().optional(),
  })
  .and(
    z.object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    }),
  )
  .and(
    z.object({
      sessions: z
        .array(
          z.object({
            last_message_sent_time: z.string().optional(),
            name: z.string().optional(),
            session_id: z.string().optional(),
            type: z.union([z.literal('Group'), z.literal('1:1')]).optional(),
          }),
        )
        .optional(),
    }),
  );

export const imChatSessionsErrorSchema = z.unknown();

export const imChatMessagesDataSchema = z.object({
  path: z.object({
    sessionId: z.string(),
  }),
  query: z.object({
    from: z.string(),
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    to: z.string(),
  }),
});

export const imChatMessagesResponseSchema = z
  .object({
    from: z.string().optional(),
    session_id: z.string().optional(),
    to: z.string().optional(),
  })
  .and(
    z.object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    }),
  )
  .and(
    z.object({
      messages: z
        .array(
          z.object({
            action: z.string().optional(),
            action_time: z.string().optional(),
            date_time: z.string().optional(),
            message: z.string().optional(),
            sender: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const imChatMessagesErrorSchema = z.unknown();

export const imGroupsResponseSchema = z
  .object({
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      groups: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z
                .object({
                  name: z.string().optional(),
                  total_members: z.number().optional(),
                })
                .and(
                  z.object({
                    search_by_account: z.boolean().optional(),
                    search_by_domain: z.boolean().optional(),
                    search_by_ma_account: z.boolean().optional(),
                    type: z.union([z.literal('normal'), z.literal('shared'), z.literal('restricted')]).optional(),
                  }),
                ),
            ),
        )
        .optional(),
    }),
  );

export const imGroupsErrorSchema = z.unknown();

export const imGroupCreateDataSchema = z.object({
  body: z.object({
    name: z.string().optional(),
    search_by_account: z.boolean().optional(),
    search_by_domain: z.boolean().optional(),
    search_by_ma_account: z.boolean().optional(),
    type: z.union([z.literal('normal'), z.literal('shared'), z.literal('restricted')]).optional(),
  }),
});

export const imGroupCreateResponseSchema = z.union([
  z.unknown(),
  z.object({
    id: z.string().optional(),
    name: z.string().optional(),
    search_by_account: z.boolean().optional(),
    search_by_domain: z.boolean().optional(),
    search_by_ma_account: z.boolean().optional(),
    total_members: z.number().optional(),
  }),
]);

export const imGroupCreateErrorSchema = z.unknown();

export const imGroupDeleteDataSchema = z.object({
  path: z.object({
    groupId: z.string(),
  }),
});

export const imGroupDeleteResponseSchema = z.any();

export const imGroupDeleteErrorSchema = z.unknown();

export const imGroupDataSchema = z.object({
  path: z.object({
    groupId: z.string(),
  }),
});

export const imGroupResponseSchema = z
  .object({
    id: z.string().optional(),
  })
  .and(
    z
      .object({
        name: z.string().optional(),
        total_members: z.number().optional(),
      })
      .and(
        z.object({
          search_by_account: z.boolean().optional(),
          search_by_domain: z.boolean().optional(),
          search_by_ma_account: z.boolean().optional(),
          type: z.union([z.literal('normal'), z.literal('shared'), z.literal('restricted')]).optional(),
        }),
      ),
  );

export const imGroupErrorSchema = z.unknown();

export const imGroupUpdateDataSchema = z.object({
  body: z.object({
    name: z.string().optional(),
    search_by_account: z.boolean().optional(),
    search_by_domain: z.boolean().optional(),
    search_by_ma_account: z.boolean().optional(),
    type: z.union([z.literal('normal'), z.literal('shared'), z.literal('restricted')]).optional(),
  }),
  path: z.object({
    groupId: z.string(),
  }),
});

export const imGroupUpdateResponseSchema = z.any();

export const imGroupUpdateErrorSchema = z.unknown();

export const imGroupMembersDataSchema = z.object({
  path: z.object({
    groupId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_number: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const imGroupMembersResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      members: z
        .array(
          z.object({
            email: z.string().optional(),
            first_name: z.string().optional(),
            id: z.string().optional(),
            last_name: z.string().optional(),
            type: z.number().optional(),
          }),
        )
        .optional(),
    }),
  );

export const imGroupMembersErrorSchema = z.unknown();

export const imGroupMembersCreateDataSchema = z.object({
  body: z.object({
    members: z
      .array(
        z.object({
          email: z.string().optional(),
          id: z.string().optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    groupId: z.string(),
  }),
});

export const imGroupMembersCreateResponseSchema = z.union([
  z.unknown(),
  z.object({
    added_at: z.string().optional(),
    ids: z.string().optional(),
  }),
]);

export const imGroupMembersCreateErrorSchema = z.unknown();

export const imGroupMembersDeleteDataSchema = z.object({
  path: z.object({
    groupId: z.string(),
    memberId: z.string(),
  }),
});

export const imGroupMembersDeleteResponseSchema = z.union([z.unknown(), z.any()]);

export const imGroupMembersDeleteErrorSchema = z.unknown();

export const sendimmessagesDataSchema = z.object({
  body: z
    .object({
      message: z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      chat_user: z.string().optional(),
    })
    .optional(),
});

export const sendimmessagesResponseSchema = z.object({
  id: z.string().optional(),
});

export const sendimmessagesErrorSchema = z.unknown();

export const listimmessagesDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      channel: z.string().optional(),
      chat_user: z.string().optional(),
      date: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const listimmessagesResponseSchema = z.object({
  date: z.string().optional(),
  messages: z
    .array(
      z.object({
        date_time: z.string().optional(),
        id: z.string().optional(),
        message: z.string().optional(),
        sender: z.string().optional(),
        timstamp: z.number().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
});

export const listimmessagesErrorSchema = z.unknown();

export const inMeetingRecordingControlDataSchema = z.object({
  body: z
    .object({
      method: z.string().optional(),
    })
    .optional(),
  path: z.object({
    meetingId: z.string(),
  }),
});

export const inMeetingRecordingControlResponseSchema = z.unknown();

export const inMeetingRecordingControlErrorSchema = z.unknown();

export const meetingDeleteDataSchema = z.object({
  path: z.object({
    meetingId: z.number(),
  }),
  query: z
    .object({
      cancel_meeting_reminder: z.string().optional(),
      occurrence_id: z.string().optional(),
      schedule_for_reminder: z.boolean().optional(),
    })
    .optional(),
});

export const meetingDeleteResponseSchema = z.any();

export const meetingDeleteErrorSchema = z.unknown();

export const meetingDataSchema = z.object({
  path: z.object({
    meetingId: z.number(),
  }),
  query: z
    .object({
      occurrence_id: z.string().optional(),
      show_previous_occurrences: z.boolean().optional(),
    })
    .optional(),
});

export const meetingResponseSchema = z
  .object({
    assistant_id: z.string().optional(),
    host_email: z.string().optional(),
    host_id: z.string().optional(),
    id: z.number().optional(),
    uuid: z.string().optional(),
  })
  .and(
    z.object({
      agenda: z.string().optional(),
      created_at: z.string().optional(),
      duration: z.number().optional(),
      encrypted_password: z.string().optional(),
      h323_password: z.string().optional(),
      join_url: z.string().optional(),
      occurrences: z
        .array(
          z.object({
            duration: z.number().optional(),
            occurrence_id: z.string().optional(),
            start_time: z.string().optional(),
            status: z.string().optional(),
          }),
        )
        .optional(),
      password: z.string().optional(),
      pmi: z.number().optional(),
      recurrence: z
        .object({
          end_date_time: z.string().optional(),
          end_times: z.number().optional(),
          monthly_day: z.number().optional(),
          monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
          monthly_week_day: z
            .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
            .optional(),
          repeat_interval: z.number().optional(),
          type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
          weekly_days: z
            .union([
              z.literal('1'),
              z.literal('2'),
              z.literal('3'),
              z.literal('4'),
              z.literal('5'),
              z.literal('6'),
              z.literal('7'),
            ])
            .optional(),
        })
        .optional(),
      settings: z
        .object({
          allow_multiple_devices: z.boolean().optional(),
          alternative_hosts: z.string().optional(),
          alternative_hosts_email_notification: z.boolean().optional(),
          approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
          approved_or_denied_countries_or_regions: z
            .object({
              approved_list: z.array(z.string()).optional(),
              denied_list: z.array(z.string()).optional(),
              enable: z.boolean().optional(),
              method: z.union([z.literal('approve'), z.literal('deny')]).optional(),
            })
            .optional(),
          audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
          authentication_domains: z.string().optional(),
          authentication_exception: z
            .array(
              z.object({
                email: z.string().optional(),
                name: z.string().optional(),
              }),
            )
            .optional(),
          authentication_name: z.string().optional(),
          authentication_option: z.string().optional(),
          auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
          breakout_room: z
            .object({
              enable: z.boolean().optional(),
              rooms: z
                .array(
                  z.object({
                    name: z.string().optional(),
                    participants: z.array(z.string()).optional(),
                  }),
                )
                .optional(),
            })
            .optional(),
          close_registration: z.boolean().optional(),
          cn_meeting: z.boolean().optional(),
          contact_email: z.string().optional(),
          contact_name: z.string().optional(),
          custom_keys: z
            .array(
              z.object({
                key: z.string().optional(),
                value: z.string().optional(),
              }),
            )
            .optional(),
          encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
          enforce_login: z.boolean().optional(),
          enforce_login_domains: z.string().optional(),
          global_dial_in_countries: z.array(z.string()).optional(),
          global_dial_in_numbers: z
            .array(
              z.object({
                city: z.string().optional(),
                country: z.string().optional(),
                country_name: z.string().optional(),
                number: z.string().optional(),
                type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
              }),
            )
            .optional(),
          host_video: z.boolean().optional(),
          in_meeting: z.boolean().optional(),
          jbh_time: z.union([z.literal(0), z.literal(5), z.literal(10)]).optional(),
          join_before_host: z.boolean().optional(),
          language_interpretation: z
            .object({
              enable: z.boolean().optional(),
              interpreters: z
                .array(
                  z.object({
                    email: z.string().optional(),
                    languages: z.string().optional(),
                  }),
                )
                .optional(),
            })
            .optional(),
          meeting_authentication: z.boolean().optional(),
          mute_upon_entry: z.boolean().optional(),
          participant_video: z.boolean().optional(),
          registrants_confirmation_email: z.boolean().optional(),
          registrants_email_notification: z.boolean().optional(),
          registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
          show_share_button: z.boolean().optional(),
          use_pmi: z.boolean().optional(),
          waiting_room: z.boolean().optional(),
          watermark: z.boolean().optional(),
        })
        .optional(),
      start_time: z.string().optional(),
      start_url: z.string().optional(),
      status: z.union([z.literal('waiting'), z.literal('started')]).optional(),
      timezone: z.string().optional(),
      topic: z.string().optional(),
      tracking_fields: z
        .array(
          z.object({
            field: z.string().optional(),
            value: z.string().optional(),
            visible: z.boolean().optional(),
          }),
        )
        .optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
    }),
  );

export const meetingErrorSchema = z.unknown();

export const meetingUpdateDataSchema = z.object({
  body: z
    .object({
      schedule_for: z.string().optional(),
    })
    .and(
      z.object({
        agenda: z.string().optional(),
        duration: z.number().optional(),
        password: z.string().optional(),
        recurrence: z
          .object({
            end_date_time: z.string().optional(),
            end_times: z.number().optional(),
            monthly_day: z.number().optional(),
            monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
            monthly_week_day: z
              .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
              .optional(),
            repeat_interval: z.number().optional(),
            type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
            weekly_days: z
              .union([
                z.literal('1'),
                z.literal('2'),
                z.literal('3'),
                z.literal('4'),
                z.literal('5'),
                z.literal('6'),
                z.literal('7'),
              ])
              .optional(),
          })
          .optional(),
        settings: z
          .object({
            allow_multiple_devices: z.boolean().optional(),
            alternative_hosts: z.string().optional(),
            alternative_hosts_email_notification: z.boolean().optional(),
            approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
            approved_or_denied_countries_or_regions: z
              .object({
                approved_list: z.array(z.string()).optional(),
                denied_list: z.array(z.string()).optional(),
                enable: z.boolean().optional(),
                method: z.union([z.literal('approve'), z.literal('deny')]).optional(),
              })
              .optional(),
            audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
            authentication_domains: z.string().optional(),
            authentication_exception: z
              .array(
                z.object({
                  email: z.string().optional(),
                  name: z.string().optional(),
                }),
              )
              .optional(),
            authentication_name: z.string().optional(),
            authentication_option: z.string().optional(),
            auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
            breakout_room: z
              .object({
                enable: z.boolean().optional(),
                rooms: z
                  .array(
                    z.object({
                      name: z.string().optional(),
                      participants: z.array(z.string()).optional(),
                    }),
                  )
                  .optional(),
              })
              .optional(),
            close_registration: z.boolean().optional(),
            cn_meeting: z.boolean().optional(),
            contact_email: z.string().optional(),
            contact_name: z.string().optional(),
            custom_keys: z
              .array(
                z.object({
                  key: z.string().optional(),
                  value: z.string().optional(),
                }),
              )
              .optional(),
            encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
            enforce_login: z.boolean().optional(),
            enforce_login_domains: z.string().optional(),
            global_dial_in_countries: z.array(z.string()).optional(),
            global_dial_in_numbers: z
              .array(
                z.object({
                  city: z.string().optional(),
                  country: z.string().optional(),
                  country_name: z.string().optional(),
                  number: z.string().optional(),
                  type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
                }),
              )
              .optional(),
            host_video: z.boolean().optional(),
            in_meeting: z.boolean().optional(),
            jbh_time: z.union([z.literal(0), z.literal(5), z.literal(10)]).optional(),
            join_before_host: z.boolean().optional(),
            language_interpretation: z
              .object({
                enable: z.boolean().optional(),
                interpreters: z
                  .array(
                    z.object({
                      email: z.string().optional(),
                      languages: z.string().optional(),
                    }),
                  )
                  .optional(),
              })
              .optional(),
            meeting_authentication: z.boolean().optional(),
            mute_upon_entry: z.boolean().optional(),
            participant_video: z.boolean().optional(),
            registrants_confirmation_email: z.boolean().optional(),
            registrants_email_notification: z.boolean().optional(),
            registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
            show_share_button: z.boolean().optional(),
            use_pmi: z.boolean().optional(),
            waiting_room: z.boolean().optional(),
            watermark: z.boolean().optional(),
          })
          .and(
            z.object({
              registrants_confirmation_email: z.boolean().optional(),
            }),
          )
          .optional(),
        start_time: z.string().optional(),
        template_id: z.string().optional(),
        timezone: z.string().optional(),
        topic: z.string().optional(),
        tracking_fields: z
          .array(
            z.object({
              field: z.string().optional(),
              value: z.string().optional(),
            }),
          )
          .optional(),
        type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
      }),
    ),
  path: z.object({
    meetingId: z.number(),
  }),
  query: z
    .object({
      occurrence_id: z.string().optional(),
    })
    .optional(),
});

export const meetingUpdateResponseSchema = z.any();

export const meetingUpdateErrorSchema = z.unknown();

export const createBatchPollsDataSchema = z.object({
  body: z
    .object({
      questions: z
        .array(
          z.object({
            answers: z.array(z.string()).optional(),
            name: z.string().optional(),
            type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
          }),
        )
        .optional(),
      title: z.string().optional(),
    })
    .optional(),
  path: z.object({
    meetingId: z.string(),
  }),
});

export const createBatchPollsResponseSchema = z.object({
  polls: z
    .array(
      z.object({
        id: z.string().optional(),
        questions: z
          .array(
            z.object({
              answers: z.array(z.string()).optional(),
              name: z.string().optional(),
              type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
            }),
          )
          .optional(),
        status: z
          .union([z.literal('notstart'), z.literal('started'), z.literal('ended'), z.literal('sharing')])
          .optional(),
        title: z.string().optional(),
      }),
    )
    .optional(),
});

export const createBatchPollsErrorSchema = z.unknown();

export const meetingInvitationDataSchema = z.object({
  path: z.object({
    meetingId: z.number(),
  }),
});

export const meetingInvitationResponseSchema = z.object({
  invitation: z.string().optional(),
});

export const meetingInvitationErrorSchema = z.unknown();

export const getLiveStreamDetailsDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
});

export const getLiveStreamDetailsResponseSchema = z.object({
  page_url: z.string().optional(),
  stream_key: z.string().optional(),
  stream_url: z.string().optional(),
});

export const getLiveStreamDetailsErrorSchema = z.unknown();

export const meetingLiveStreamUpdateDataSchema = z.object({
  body: z.object({
    page_url: z.string().optional(),
    stream_key: z.string(),
    stream_url: z.string(),
  }),
  path: z.object({
    meetingId: z.number(),
  }),
});

export const meetingLiveStreamUpdateResponseSchema = z.any();

export const meetingLiveStreamUpdateErrorSchema = z.unknown();

export const meetingLiveStreamStatusUpdateDataSchema = z.object({
  body: z.object({
    action: z.union([z.literal('start'), z.literal('stop')]).optional(),
    settings: z
      .object({
        active_speaker_name: z.boolean().optional(),
        display_name: z.string().optional(),
      })
      .optional(),
  }),
  path: z.object({
    meetingId: z.number(),
  }),
});

export const meetingLiveStreamStatusUpdateResponseSchema = z.any();

export const meetingLiveStreamStatusUpdateErrorSchema = z.unknown();

export const meetingPollsDataSchema = z.object({
  path: z.object({
    meetingId: z.number(),
  }),
});

export const meetingPollsResponseSchema = z.object({
  polls: z
    .array(
      z
        .object({
          id: z.string().optional(),
          status: z
            .union([z.literal('notstart'), z.literal('started'), z.literal('ended'), z.literal('sharing')])
            .optional(),
        })
        .and(
          z.object({
            questions: z
              .array(
                z.object({
                  answers: z.array(z.string()).optional(),
                  name: z.string().optional(),
                  type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
                }),
              )
              .optional(),
            title: z.string().optional(),
          }),
        ),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const meetingPollsErrorSchema = z.unknown();

export const meetingPollCreateDataSchema = z.object({
  body: z.object({
    questions: z
      .array(
        z.object({
          answers: z.array(z.string()).optional(),
          name: z.string().optional(),
          type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
        }),
      )
      .optional(),
    title: z.string().optional(),
  }),
  path: z.object({
    meetingId: z.number(),
  }),
});

export const meetingPollCreateResponseSchema = z
  .object({
    id: z.string().optional(),
    status: z.union([z.literal('notstart'), z.literal('started'), z.literal('ended'), z.literal('sharing')]).optional(),
  })
  .and(
    z.object({
      questions: z
        .array(
          z.object({
            answers: z.array(z.string()).optional(),
            name: z.string().optional(),
            type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
          }),
        )
        .optional(),
      title: z.string().optional(),
    }),
  );

export const meetingPollCreateErrorSchema = z.unknown();

export const meetingPollDeleteDataSchema = z.object({
  path: z.object({
    meetingId: z.number(),
    pollId: z.string(),
  }),
});

export const meetingPollDeleteResponseSchema = z.any();

export const meetingPollDeleteErrorSchema = z.unknown();

export const meetingPollGetDataSchema = z.object({
  path: z.object({
    meetingId: z.number(),
    pollId: z.string(),
  }),
});

export const meetingPollGetResponseSchema = z
  .object({
    id: z.string().optional(),
    status: z.union([z.literal('notstart'), z.literal('started'), z.literal('ended'), z.literal('sharing')]).optional(),
  })
  .and(
    z.object({
      questions: z
        .array(
          z.object({
            answers: z.array(z.string()).optional(),
            name: z.string().optional(),
            type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
          }),
        )
        .optional(),
      title: z.string().optional(),
    }),
  );

export const meetingPollGetErrorSchema = z.unknown();

export const meetingPollUpdateDataSchema = z.object({
  body: z.object({
    questions: z
      .array(
        z.object({
          answers: z.array(z.string()).optional(),
          name: z.string().optional(),
          type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
        }),
      )
      .optional(),
    title: z.string().optional(),
  }),
  path: z.object({
    meetingId: z.number(),
    pollId: z.string(),
  }),
});

export const meetingPollUpdateResponseSchema = z.any();

export const meetingPollUpdateErrorSchema = z.unknown();

export const recordingDeleteDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
  query: z
    .object({
      action: z.union([z.literal('trash'), z.literal('delete')]).optional(),
    })
    .optional(),
});

export const recordingDeleteResponseSchema = z.union([z.unknown(), z.any()]);

export const recordingDeleteErrorSchema = z.unknown();

export const recordingGetDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
  query: z
    .object({
      include_fields: z.string().optional(),
      ttl: z.number().optional(),
    })
    .optional(),
});

export const recordingGetResponseSchema = z
  .object({
    account_id: z.string().optional(),
    duration: z.number().optional(),
    host_id: z.string().optional(),
    id: z.string().optional(),
    recording_count: z.string().optional(),
    start_time: z.string().optional(),
    topic: z.string().optional(),
    total_size: z.string().optional(),
    type: z.string().optional(),
    uuid: z.string().optional(),
  })
  .and(
    z.object({
      recording_files: z
        .array(
          z.object({
            deleted_time: z.string().optional(),
            download_url: z.string().optional(),
            file_size: z.number().optional(),
            file_type: z.string().optional(),
            id: z.string().optional(),
            meeting_id: z.string().optional(),
            play_url: z.string().optional(),
            recording_end: z.string().optional(),
            recording_start: z.string().optional(),
            recording_type: z.string().optional(),
            status: z.literal('completed').optional(),
          }),
        )
        .optional(),
    }),
  )
  .and(
    z.object({
      download_access_token: z.string().optional(),
    }),
  );

export const recordingGetErrorSchema = z.unknown();

export const meetingRecordingRegistrantsDataSchema = z.object({
  path: z.object({
    meetingId: z.number(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_number: z.number().optional(),
      page_size: z.number().optional(),
      status: z.union([z.literal('pending'), z.literal('approved'), z.literal('denied')]).optional(),
    })
    .optional(),
});

export const meetingRecordingRegistrantsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      registrants: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z.object({
                address: z.string().optional(),
                city: z.string().optional(),
                comments: z.string().optional(),
                country: z.string().optional(),
                custom_questions: z
                  .array(
                    z.object({
                      title: z.string().optional(),
                      value: z.string().optional(),
                    }),
                  )
                  .optional(),
                email: z.string(),
                first_name: z.string(),
                industry: z.string().optional(),
                job_title: z.string().optional(),
                last_name: z.string().optional(),
                no_of_employees: z.string().optional(),
                org: z.string().optional(),
                phone: z.string().optional(),
                purchasing_time_frame: z.string().optional(),
                role_in_purchase_process: z.string().optional(),
                state: z.string().optional(),
                zip: z.string().optional(),
              }),
            ),
        )
        .optional(),
    }),
  );

export const meetingRecordingRegistrantsErrorSchema = z.unknown();

export const meetingRecordingRegistrantCreateDataSchema = z.object({
  body: z.object({
    address: z.string().optional(),
    city: z.string().optional(),
    comments: z.string().optional(),
    country: z.string().optional(),
    custom_questions: z
      .array(
        z.object({
          title: z.string().optional(),
          value: z.string().optional(),
        }),
      )
      .optional(),
    email: z.string(),
    first_name: z.string(),
    industry: z.string().optional(),
    job_title: z.string().optional(),
    last_name: z.string().optional(),
    no_of_employees: z.string().optional(),
    org: z.string().optional(),
    phone: z.string().optional(),
    purchasing_time_frame: z.string().optional(),
    role_in_purchase_process: z.string().optional(),
    state: z.string().optional(),
    zip: z.string().optional(),
  }),
  path: z.object({
    meetingId: z.number(),
  }),
});

export const meetingRecordingRegistrantCreateResponseSchema = z.object({
  id: z.number().optional(),
  registrant_id: z.string().optional(),
  share_url: z.string().optional(),
  topic: z.string().optional(),
});

export const meetingRecordingRegistrantCreateErrorSchema = z.unknown();

export const recordingRegistrantsQuestionsGetDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
});

export const recordingRegistrantsQuestionsGetResponseSchema = z.object({
  custom_questions: z
    .array(
      z.object({
        answers: z.array(z.string()).optional(),
        required: z.boolean().optional(),
        title: z.string().optional(),
        type: z.union([z.literal('short'), z.literal('single'), z.literal('multiple')]).optional(),
      }),
    )
    .optional(),
  questions: z
    .array(
      z.object({
        field_name: z
          .union([
            z.literal('last_name'),
            z.literal('address'),
            z.literal('city'),
            z.literal('country'),
            z.literal('zip'),
            z.literal('state'),
            z.literal('phone'),
            z.literal('industry'),
            z.literal('org'),
            z.literal('job_title'),
            z.literal('purchasing_time_frame'),
            z.literal('role_in_purchase_process'),
            z.literal('no_of_employees'),
            z.literal('comments'),
          ])
          .optional(),
        required: z.boolean().optional(),
      }),
    )
    .optional(),
});

export const recordingRegistrantsQuestionsGetErrorSchema = z.unknown();

export const recordingRegistrantQuestionUpdateDataSchema = z.object({
  body: z.object({
    custom_questions: z
      .array(
        z.object({
          answers: z.array(z.string()).optional(),
          required: z.boolean().optional(),
          title: z.string().optional(),
          type: z.union([z.literal('short'), z.literal('single'), z.literal('multiple')]).optional(),
        }),
      )
      .optional(),
    questions: z
      .array(
        z.object({
          field_name: z
            .union([
              z.literal('last_name'),
              z.literal('address'),
              z.literal('city'),
              z.literal('country'),
              z.literal('zip'),
              z.literal('state'),
              z.literal('phone'),
              z.literal('industry'),
              z.literal('org'),
              z.literal('job_title'),
              z.literal('purchasing_time_frame'),
              z.literal('role_in_purchase_process'),
              z.literal('no_of_employees'),
              z.literal('comments'),
            ])
            .optional(),
          required: z.boolean().optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    meetingId: z.string(),
  }),
});

export const recordingRegistrantQuestionUpdateResponseSchema = z.any();

export const recordingRegistrantQuestionUpdateErrorSchema = z.unknown();

export const meetingRecordingRegistrantStatusDataSchema = z.object({
  body: z.object({
    action: z.union([z.literal('approve'), z.literal('deny')]),
    registrants: z
      .array(
        z.object({
          id: z.string().optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    meetingId: z.number(),
  }),
});

export const meetingRecordingRegistrantStatusResponseSchema = z.any();

export const meetingRecordingRegistrantStatusErrorSchema = z.unknown();

export const recordingSettingUpdateDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
});

export const recordingSettingUpdateResponseSchema = z.object({
  approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
  authentication_domains: z.string().optional(),
  authentication_option: z.string().optional(),
  on_demand: z.boolean().optional(),
  password: z.string().optional(),
  recording_authentication: z.boolean().optional(),
  send_email_to_host: z.boolean().optional(),
  share_recording: z.union([z.literal('publicly'), z.literal('internally'), z.literal('none')]).optional(),
  show_social_share_buttons: z.boolean().optional(),
  topic: z.string().optional(),
  viewer_download: z.boolean().optional(),
});

export const recordingSettingUpdateErrorSchema = z.unknown();

export const recordingSettingsUpdateDataSchema = z.object({
  body: z.object({
    approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
    authentication_domains: z.string().optional(),
    authentication_option: z.string().optional(),
    on_demand: z.boolean().optional(),
    password: z.string().optional(),
    recording_authentication: z.boolean().optional(),
    send_email_to_host: z.boolean().optional(),
    share_recording: z.union([z.literal('publicly'), z.literal('internally'), z.literal('none')]).optional(),
    show_social_share_buttons: z.boolean().optional(),
    topic: z.string().optional(),
    viewer_download: z.boolean().optional(),
  }),
  path: z.object({
    meetingId: z.string(),
  }),
});

export const recordingSettingsUpdateResponseSchema = z.any();

export const recordingSettingsUpdateErrorSchema = z.unknown();

export const recordingStatusUpdateDataSchema = z.object({
  body: z.object({
    action: z.literal('recover').optional(),
  }),
  path: z.object({
    meetingId: z.string(),
  }),
});

export const recordingStatusUpdateResponseSchema = z.union([z.unknown(), z.any()]);

export const recordingStatusUpdateErrorSchema = z.unknown();

export const recordingDeleteOneDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
    recordingId: z.string(),
  }),
  query: z
    .object({
      action: z.union([z.literal('trash'), z.literal('delete')]).optional(),
    })
    .optional(),
});

export const recordingDeleteOneResponseSchema = z.union([z.unknown(), z.any()]);

export const recordingDeleteOneErrorSchema = z.unknown();

export const recordingStatusUpdateOneDataSchema = z.object({
  body: z.object({
    action: z.literal('recover').optional(),
  }),
  path: z.object({
    meetingId: z.string(),
    recordingId: z.string(),
  }),
});

export const recordingStatusUpdateOneResponseSchema = z.any();

export const recordingStatusUpdateOneErrorSchema = z.unknown();

export const meetingRegistrantsDataSchema = z.object({
  path: z.object({
    meetingId: z.number(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      occurrence_id: z.string().optional(),
      page_number: z.number().optional(),
      page_size: z.number().optional(),
      status: z.union([z.literal('pending'), z.literal('approved'), z.literal('denied')]).optional(),
    })
    .optional(),
});

export const meetingRegistrantsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      registrants: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z.object({
                address: z.string().optional(),
                city: z.string().optional(),
                comments: z.string().optional(),
                country: z.string().optional(),
                custom_questions: z
                  .array(
                    z.object({
                      title: z.string().optional(),
                      value: z.string().optional(),
                    }),
                  )
                  .optional(),
                email: z.string(),
                first_name: z.string(),
                industry: z.string().optional(),
                job_title: z.string().optional(),
                last_name: z.string().optional(),
                no_of_employees: z.string().optional(),
                org: z.string().optional(),
                phone: z.string().optional(),
                purchasing_time_frame: z.string().optional(),
                role_in_purchase_process: z.string().optional(),
                state: z.string().optional(),
                zip: z.string().optional(),
              }),
            )
            .and(
              z.object({
                create_time: z.string().optional(),
                join_url: z.string().optional(),
                status: z.string().optional(),
              }),
            ),
        )
        .optional(),
    }),
  );

export const meetingRegistrantsErrorSchema = z.unknown();

export const meetingRegistrantCreateDataSchema = z.object({
  body: z
    .object({
      address: z.string().optional(),
      city: z.string().optional(),
      comments: z.string().optional(),
      country: z.string().optional(),
      custom_questions: z
        .array(
          z.object({
            title: z.string().optional(),
            value: z.string().optional(),
          }),
        )
        .optional(),
      email: z.string(),
      first_name: z.string(),
      industry: z.string().optional(),
      job_title: z.string().optional(),
      last_name: z.string().optional(),
      no_of_employees: z.string().optional(),
      org: z.string().optional(),
      phone: z.string().optional(),
      purchasing_time_frame: z.string().optional(),
      role_in_purchase_process: z.string().optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
    })
    .and(
      z.object({
        language: z.string().optional(),
      }),
    )
    .and(
      z.object({
        auto_approve: z.boolean().optional(),
      }),
    ),
  path: z.object({
    meetingId: z.number(),
  }),
  query: z
    .object({
      occurrence_ids: z.string().optional(),
    })
    .optional(),
});

export const meetingRegistrantCreateResponseSchema = z.object({
  id: z.number().optional(),
  join_url: z.string().optional(),
  registrant_id: z.string().optional(),
  start_time: z.string().optional(),
  topic: z.string().optional(),
});

export const meetingRegistrantCreateErrorSchema = z.unknown();

export const meetingRegistrantsQuestionsGetDataSchema = z.object({
  path: z.object({
    meetingId: z.number(),
  }),
});

export const meetingRegistrantsQuestionsGetResponseSchema = z.object({
  custom_questions: z
    .array(
      z.object({
        answers: z.array(z.string()).optional(),
        required: z.boolean().optional(),
        title: z.string().optional(),
        type: z.union([z.literal('short'), z.literal('single')]).optional(),
      }),
    )
    .optional(),
  questions: z
    .array(
      z.object({
        field_name: z
          .union([
            z.literal('address'),
            z.literal('city'),
            z.literal('country'),
            z.literal('zip'),
            z.literal('state'),
            z.literal('phone'),
            z.literal('industry'),
            z.literal('org'),
            z.literal('job_title'),
            z.literal('purchasing_time_frame'),
            z.literal('role_in_purchase_process'),
            z.literal('no_of_employees'),
            z.literal('comments'),
          ])
          .optional(),
        required: z.boolean().optional(),
      }),
    )
    .optional(),
});

export const meetingRegistrantsQuestionsGetErrorSchema = z.unknown();

export const meetingRegistrantQuestionUpdateDataSchema = z.object({
  body: z.object({
    custom_questions: z
      .array(
        z.object({
          answers: z.array(z.string()).optional(),
          required: z.boolean().optional(),
          title: z.string().optional(),
          type: z.union([z.literal('short'), z.literal('single')]).optional(),
        }),
      )
      .optional(),
    questions: z
      .array(
        z.object({
          field_name: z
            .union([
              z.literal('address'),
              z.literal('city'),
              z.literal('country'),
              z.literal('zip'),
              z.literal('state'),
              z.literal('phone'),
              z.literal('industry'),
              z.literal('org'),
              z.literal('job_title'),
              z.literal('purchasing_time_frame'),
              z.literal('role_in_purchase_process'),
              z.literal('no_of_employees'),
              z.literal('comments'),
            ])
            .optional(),
          required: z.boolean().optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    meetingId: z.number(),
  }),
});

export const meetingRegistrantQuestionUpdateResponseSchema = z.any();

export const meetingRegistrantQuestionUpdateErrorSchema = z.unknown();

export const meetingRegistrantStatusDataSchema = z.object({
  body: z.object({
    action: z.union([z.literal('approve'), z.literal('cancel'), z.literal('deny')]),
    registrants: z
      .array(
        z.object({
          email: z.string().optional(),
          id: z.string().optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    meetingId: z.number(),
  }),
  query: z
    .object({
      occurrence_id: z.string().optional(),
    })
    .optional(),
});

export const meetingRegistrantStatusResponseSchema = z.any();

export const meetingRegistrantStatusErrorSchema = z.unknown();

export const meetingregistrantdeleteDataSchema = z.object({
  path: z.object({
    meetingId: z.number(),
    registrantId: z.string(),
  }),
  query: z
    .object({
      occurrence_id: z.string().optional(),
    })
    .optional(),
});

export const meetingregistrantdeleteResponseSchema = z.any();

export const meetingregistrantdeleteErrorSchema = z.unknown();

export const meetingStatusDataSchema = z.object({
  body: z.object({
    action: z.union([z.literal('end'), z.literal('recover')]).optional(),
  }),
  path: z.object({
    meetingId: z.number(),
  }),
});

export const meetingStatusResponseSchema = z.any();

export const meetingStatusErrorSchema = z.unknown();

export const dashboardClientFeedbackDataSchema = z.object({
  query: z.object({
    from: z.string(),
    to: z.string(),
  }),
});

export const dashboardClientFeedbackResponseSchema = z.object({
  client_feedbacks: z
    .array(
      z.object({
        feedback_id: z.string().optional(),
        feedback_name: z.string().optional(),
        participants_count: z.number().optional(),
      }),
    )
    .optional(),
  from: z.string().optional(),
  to: z.string().optional(),
  total_records: z.number().optional(),
});

export const dashboardClientFeedbackErrorSchema = z.unknown();

export const dashboardClientFeedbackDetailDataSchema = z.object({
  path: z.object({
    feedbackId: z.string(),
  }),
  query: z
    .object({
      from: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      to: z.string().optional(),
    })
    .optional(),
});

export const dashboardClientFeedbackDetailResponseSchema = z
  .object({
    from: z.string().optional(),
    to: z.string().optional(),
  })
  .and(
    z.object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    }),
  )
  .and(
    z.object({
      client_feedback_details: z
        .array(
          z.object({
            email: z.string().optional(),
            meeting_id: z.string().optional(),
            participant_name: z.string().optional(),
            time: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardClientFeedbackDetailErrorSchema = z.unknown();

export const listMeetingSatisfactionDataSchema = z.object({
  query: z
    .object({
      from: z.string().optional(),
      to: z.string().optional(),
    })
    .optional(),
});

export const listMeetingSatisfactionResponseSchema = z.object({
  client_satisfaction: z
    .array(
      z.object({
        date: z.string().optional(),
        good_count: z.number().optional(),
        none_count: z.number().optional(),
        not_good_count: z.number().optional(),
        satisfaction_percent: z.number().optional(),
      }),
    )
    .optional(),
  from: z.string().optional(),
  to: z.string().optional(),
  total_records: z.number().optional(),
});

export const listMeetingSatisfactionErrorSchema = z.unknown();

export const dashboardCrcDataSchema = z.object({
  query: z.object({
    from: z.string(),
    to: z.string(),
  }),
});

export const dashboardCrcResponseSchema = z
  .object({
    from: z.string().optional(),
    to: z.string().optional(),
  })
  .and(
    z.object({
      crc_ports_usage: z
        .array(
          z.object({
            crc_ports_hour_usage: z
              .array(
                z.object({
                  hour: z.string().optional(),
                  max_usage: z.number().optional(),
                  total_usage: z.number().optional(),
                }),
              )
              .optional(),
            date_time: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardCrcErrorSchema = z.unknown();

export const dashboardImDataSchema = z.object({
  query: z.object({
    from: z.string(),
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    to: z.string(),
  }),
});

export const dashboardImResponseSchema = z
  .object({
    from: z.string().optional(),
    to: z.string().optional(),
  })
  .and(
    z.object({
      next_page_token: z.string().optional(),
      page_count: z.number().optional(),
      page_size: z.number().optional(),
      total_records: z.number().optional(),
    }),
  )
  .and(
    z.object({
      users: z
        .array(
          z.object({
            calls_receive: z.number().optional(),
            calls_send: z.number().optional(),
            email: z.string().optional(),
            emoji_receive: z.number().optional(),
            emoji_send: z.number().optional(),
            files_receive: z.number().optional(),
            files_send: z.number().optional(),
            group_receive: z.number().optional(),
            group_send: z.number().optional(),
            images_receive: z.number().optional(),
            images_send: z.number().optional(),
            total_receive: z.number().optional(),
            total_send: z.number().optional(),
            user_id: z.string().optional(),
            user_name: z.string().optional(),
            videos_receive: z.number().optional(),
            videos_send: z.number().optional(),
            voice_receive: z.number().optional(),
            voice_send: z.number().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardImErrorSchema = z.unknown();

export const dashboardIssueZoomRoomDataSchema = z.object({
  query: z.object({
    from: z.string(),
    to: z.string(),
  }),
});

export const dashboardIssueZoomRoomResponseSchema = z
  .object({
    from: z.string().optional(),
    to: z.string().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      zoom_rooms: z
        .array(
          z.object({
            id: z.string().optional(),
            issues_count: z.number().optional(),
            room_name: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardIssueZoomRoomErrorSchema = z.unknown();

export const dashboardIssueDetailZoomRoomDataSchema = z.object({
  path: z.object({
    zoomroomId: z.string(),
  }),
  query: z.object({
    from: z.string(),
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    to: z.string(),
  }),
});

export const dashboardIssueDetailZoomRoomResponseSchema = z
  .object({
    from: z.string().optional(),
    to: z.string().optional(),
  })
  .and(
    z.object({
      next_page_token: z.string().optional(),
      page_count: z.number().optional(),
      page_size: z.number().optional(),
      total_records: z.number().optional(),
    }),
  )
  .and(
    z.object({
      issue_details: z
        .array(
          z.object({
            issue: z.string().optional(),
            time: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardIssueDetailZoomRoomErrorSchema = z.unknown();

export const dashboardMeetingsDataSchema = z.object({
  query: z.object({
    from: z.string(),
    include_fields: z.literal('tracking_fields').optional(),
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    to: z.string(),
    type: z.union([z.literal('past'), z.literal('pastOne'), z.literal('live')]).optional(),
  }),
});

export const dashboardMeetingsResponseSchema = z
  .object({
    from: z.string().optional(),
    to: z.string().optional(),
  })
  .and(
    z.object({
      next_page_token: z.string().optional(),
      page_count: z.number().optional(),
      page_size: z.number().optional(),
      total_records: z.number().optional(),
    }),
  )
  .and(
    z.object({
      meetings: z
        .array(
          z.object({
            custom_keys: z
              .array(
                z.object({
                  key: z.string().optional(),
                  value: z.string().optional(),
                }),
              )
              .optional(),
            dept: z.string().optional(),
            duration: z.string().optional(),
            email: z.string().optional(),
            end_time: z.string().optional(),
            has_3rd_party_audio: z.boolean().optional(),
            has_pstn: z.boolean().optional(),
            has_recording: z.boolean().optional(),
            has_screen_share: z.boolean().optional(),
            has_sip: z.boolean().optional(),
            has_video: z.boolean().optional(),
            has_voip: z.boolean().optional(),
            host: z.string().optional(),
            id: z.number().optional(),
            in_room_participants: z.number().optional(),
            participants: z.number().optional(),
            start_time: z.string().optional(),
            topic: z.string().optional(),
            tracking_fields: z
              .array(
                z.object({
                  field: z.string().optional(),
                  value: z.string().optional(),
                }),
              )
              .optional(),
            user_type: z.string().optional(),
            uuid: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardMeetingsErrorSchema = z.unknown();

export const dashboardMeetingDetailDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
  query: z
    .object({
      type: z.union([z.literal('past'), z.literal('pastOne'), z.literal('live')]).optional(),
    })
    .optional(),
});

export const dashboardMeetingDetailResponseSchema = z.object({
  custom_keys: z
    .array(
      z.object({
        key: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  dept: z.string().optional(),
  duration: z.string().optional(),
  email: z.string().optional(),
  end_time: z.string().optional(),
  has_3rd_party_audio: z.boolean().optional(),
  has_pstn: z.boolean().optional(),
  has_recording: z.boolean().optional(),
  has_screen_share: z.boolean().optional(),
  has_sip: z.boolean().optional(),
  has_video: z.boolean().optional(),
  has_voip: z.boolean().optional(),
  host: z.string().optional(),
  id: z.number().optional(),
  in_room_participants: z.number().optional(),
  participants: z.number().optional(),
  start_time: z.string().optional(),
  topic: z.string().optional(),
  user_type: z.string().optional(),
  uuid: z.string().optional(),
});

export const dashboardMeetingDetailErrorSchema = z.unknown();

export const dashboardMeetingParticipantsDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
  query: z
    .object({
      include_fields: z.literal('registrant_id').optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      type: z.union([z.literal('past'), z.literal('pastOne'), z.literal('live')]).optional(),
    })
    .optional(),
});

export const dashboardMeetingParticipantsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      participants: z
        .array(
          z.object({
            audio_quality: z
              .union([z.literal(' '), z.literal('good'), z.literal('fair'), z.literal('poor'), z.literal('bad')])
              .optional(),
            camera: z.string().optional(),
            connection_type: z.string().optional(),
            customer_key: z.string().optional(),
            data_center: z.string().optional(),
            device: z.string().optional(),
            domain: z.string().optional(),
            email: z.string().optional(),
            harddisk_id: z.string().optional(),
            id: z.string().optional(),
            in_room_participants: z.number().optional(),
            ip_address: z.string().optional(),
            join_time: z.string().optional(),
            leave_reason: z.string().optional(),
            leave_time: z.string().optional(),
            location: z.string().optional(),
            mac_addr: z.string().optional(),
            microphone: z.string().optional(),
            network_type: z
              .union([
                z.literal('Wired'),
                z.literal('Wifi'),
                z.literal('PPP'),
                z.literal('Cellular (3G and 4G)'),
                z.literal('Others'),
              ])
              .optional(),
            pc_name: z.string().optional(),
            recording: z.boolean().optional(),
            registrant_id: z.string().optional(),
            screen_share_quality: z
              .union([z.literal(' '), z.literal('good'), z.literal('fair'), z.literal('poor'), z.literal('bad')])
              .optional(),
            share_application: z.boolean().optional(),
            share_desktop: z.boolean().optional(),
            share_whiteboard: z.boolean().optional(),
            speaker: z.string().optional(),
            status: z.union([z.literal('in_meeting'), z.literal('in_waiting_room')]).optional(),
            user_id: z.string().optional(),
            user_name: z.string().optional(),
            version: z.string().optional(),
            video_quality: z
              .union([z.literal(' '), z.literal('good'), z.literal('fair'), z.literal('poor'), z.literal('bad')])
              .optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardMeetingParticipantsErrorSchema = z.unknown();

export const dashboardMeetingParticipantsQosDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      type: z.union([z.literal('past'), z.literal('pastOne'), z.literal('live')]).optional(),
    })
    .optional(),
});

export const dashboardMeetingParticipantsQosResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      participants: z
        .array(
          z.object({
            device: z.string().optional(),
            domain: z.string().optional(),
            harddisk_id: z.string().optional(),
            ip_address: z.string().optional(),
            join_time: z.string().optional(),
            leave_time: z.string().optional(),
            location: z.string().optional(),
            mac_addr: z.string().optional(),
            pc_name: z.string().optional(),
            user_id: z.string().optional(),
            user_name: z.string().optional(),
            user_qos: z
              .array(
                z.object({
                  as_device_from_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  as_device_to_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  as_input: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .and(
                      z.object({
                        frame_rate: z.string().optional(),
                        resolution: z.string().optional(),
                      }),
                    )
                    .optional(),
                  as_output: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .and(
                      z.object({
                        frame_rate: z.string().optional(),
                        resolution: z.string().optional(),
                      }),
                    )
                    .optional(),
                  audio_device_from_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  audio_device_to_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  audio_input: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  audio_output: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  cpu_usage: z
                    .object({
                      system_max_cpu_usage: z.string().optional(),
                      zoom_avg_cpu_usage: z.string().optional(),
                      zoom_max_cpu_usage: z.string().optional(),
                      zoom_min_cpu_usage: z.string().optional(),
                    })
                    .optional(),
                  date_time: z.string().optional(),
                  video_device_from_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  video_device_to_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  video_input: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .and(
                      z.object({
                        frame_rate: z.string().optional(),
                        resolution: z.string().optional(),
                      }),
                    )
                    .optional(),
                  video_output: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .and(
                      z.object({
                        frame_rate: z.string().optional(),
                        resolution: z.string().optional(),
                      }),
                    )
                    .optional(),
                }),
              )
              .optional(),
            version: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardMeetingParticipantsQosErrorSchema = z.unknown();

export const participantFeedbackDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      type: z.union([z.literal('past'), z.literal('pastOne'), z.literal('live')]).optional(),
    })
    .optional(),
});

export const participantFeedbackResponseSchema = z.object({
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  participants: z
    .array(
      z.object({
        date_time: z.string().optional(),
        email: z.string().optional(),
        quality: z.union([z.literal('GOOD'), z.literal('NOT GOOD')]).optional(),
        user_id: z.string().optional(),
      }),
    )
    .optional(),
});

export const participantFeedbackErrorSchema = z.unknown();

export const dashboardMeetingParticipantShareDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      type: z.union([z.literal('past'), z.literal('pastOne'), z.literal('live')]).optional(),
    })
    .optional(),
});

export const dashboardMeetingParticipantShareResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      participants: z
        .array(
          z.object({
            details: z
              .array(
                z.object({
                  content: z.string().optional(),
                  end_time: z.string().optional(),
                  start_time: z.string().optional(),
                }),
              )
              .optional(),
            id: z.string().optional(),
            user_id: z.string().optional(),
            user_name: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardMeetingParticipantShareErrorSchema = z.unknown();

export const dashboardMeetingParticipantQosDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
    participantId: z.string(),
  }),
  query: z
    .object({
      type: z.union([z.literal('past'), z.literal('pastOne'), z.literal('live')]).optional(),
    })
    .optional(),
});

export const dashboardMeetingParticipantQosResponseSchema = z.object({
  device: z.string().optional(),
  domain: z.string().optional(),
  harddisk_id: z.string().optional(),
  ip_address: z.string().optional(),
  join_time: z.string().optional(),
  leave_time: z.string().optional(),
  location: z.string().optional(),
  mac_addr: z.string().optional(),
  pc_name: z.string().optional(),
  user_id: z.string().optional(),
  user_name: z.string().optional(),
  user_qos: z
    .array(
      z.object({
        as_device_from_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        as_device_to_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        as_input: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .and(
            z.object({
              frame_rate: z.string().optional(),
              resolution: z.string().optional(),
            }),
          )
          .optional(),
        as_output: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .and(
            z.object({
              frame_rate: z.string().optional(),
              resolution: z.string().optional(),
            }),
          )
          .optional(),
        audio_device_from_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        audio_device_to_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        audio_input: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        audio_output: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        cpu_usage: z
          .object({
            system_max_cpu_usage: z.string().optional(),
            zoom_avg_cpu_usage: z.string().optional(),
            zoom_max_cpu_usage: z.string().optional(),
            zoom_min_cpu_usage: z.string().optional(),
          })
          .optional(),
        date_time: z.string().optional(),
        video_device_from_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        video_device_to_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        video_input: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .and(
            z.object({
              frame_rate: z.string().optional(),
              resolution: z.string().optional(),
            }),
          )
          .optional(),
        video_output: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .and(
            z.object({
              frame_rate: z.string().optional(),
              resolution: z.string().optional(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
  version: z.string().optional(),
});

export const dashboardMeetingParticipantQosErrorSchema = z.unknown();

export const dashboardWebinarsDataSchema = z.object({
  query: z.object({
    from: z.string(),
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    to: z.string(),
    type: z.union([z.literal('past'), z.literal('live')]).optional(),
  }),
});

export const dashboardWebinarsResponseSchema = z
  .object({
    from: z.string().optional(),
    to: z.string().optional(),
  })
  .and(
    z.object({
      next_page_token: z.string().optional(),
      page_count: z.number().optional(),
      page_size: z.number().optional(),
      total_records: z.number().optional(),
    }),
  )
  .and(
    z.object({
      webinars: z
        .array(
          z.object({
            custom_keys: z
              .array(
                z.object({
                  key: z.string().optional(),
                  value: z.string().optional(),
                }),
              )
              .optional(),
            dept: z.string().optional(),
            duration: z.string().optional(),
            email: z.string().optional(),
            end_time: z.string().optional(),
            has_3rd_party_audio: z.boolean().optional(),
            has_pstn: z.boolean().optional(),
            has_recording: z.boolean().optional(),
            has_screen_share: z.boolean().optional(),
            has_sip: z.boolean().optional(),
            has_video: z.boolean().optional(),
            has_voip: z.boolean().optional(),
            host: z.string().optional(),
            id: z.number().optional(),
            participants: z.number().optional(),
            start_time: z.string().optional(),
            topic: z.string().optional(),
            user_type: z.string().optional(),
            uuid: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardWebinarsErrorSchema = z.unknown();

export const dashboardWebinarDetailDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
  query: z
    .object({
      type: z.union([z.literal('past'), z.literal('live')]).optional(),
    })
    .optional(),
});

export const dashboardWebinarDetailResponseSchema = z.object({
  custom_keys: z
    .array(
      z.object({
        key: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  dept: z.string().optional(),
  duration: z.string().optional(),
  email: z.string().optional(),
  end_time: z.string().optional(),
  has_3rd_party_audio: z.boolean().optional(),
  has_pstn: z.boolean().optional(),
  has_recording: z.boolean().optional(),
  has_screen_share: z.boolean().optional(),
  has_sip: z.boolean().optional(),
  has_video: z.boolean().optional(),
  has_voip: z.boolean().optional(),
  host: z.string().optional(),
  id: z.number().optional(),
  participants: z.number().optional(),
  start_time: z.string().optional(),
  topic: z.string().optional(),
  user_type: z.string().optional(),
  uuid: z.string().optional(),
});

export const dashboardWebinarDetailErrorSchema = z.unknown();

export const dashboardWebinarParticipantsDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
  query: z
    .object({
      include_fields: z.literal('registrant_id').optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      type: z.union([z.literal('past'), z.literal('live')]).optional(),
    })
    .optional(),
});

export const dashboardWebinarParticipantsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      participants: z
        .array(
          z.object({
            audio_quality: z
              .union([z.literal(' '), z.literal('good'), z.literal('fair'), z.literal('poor'), z.literal('bad')])
              .optional(),
            connection_type: z.string().optional(),
            customer_key: z.string().optional(),
            data_center: z.string().optional(),
            device: z.string().optional(),
            domain: z.string().optional(),
            email: z.string().optional(),
            harddisk_id: z.string().optional(),
            id: z.string().optional(),
            ip_address: z.string().optional(),
            join_time: z.string().optional(),
            leave_reason: z.string().optional(),
            leave_time: z.string().optional(),
            location: z.string().optional(),
            mac_addr: z.string().optional(),
            microphone: z.string().optional(),
            network_type: z.string().optional(),
            pc_name: z.string().optional(),
            recording: z.boolean().optional(),
            registrant_id: z.string().optional(),
            screen_share_quality: z
              .union([z.literal(' '), z.literal('good'), z.literal('fair'), z.literal('poor'), z.literal('bad')])
              .optional(),
            share_application: z.boolean().optional(),
            share_desktop: z.boolean().optional(),
            share_whiteboard: z.boolean().optional(),
            speaker: z.string().optional(),
            user_id: z.string().optional(),
            user_name: z.string().optional(),
            version: z.string().optional(),
            video_quality: z
              .union([z.literal(' '), z.literal('good'), z.literal('fair'), z.literal('poor'), z.literal('bad')])
              .optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardWebinarParticipantsErrorSchema = z.unknown();

export const dashboardWebinarParticipantsQosDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      type: z.union([z.literal('past'), z.literal('live')]).optional(),
    })
    .optional(),
});

export const dashboardWebinarParticipantsQosResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      participants: z
        .array(
          z.object({
            device: z.string().optional(),
            domain: z.string().optional(),
            harddisk_id: z.string().optional(),
            ip_address: z.string().optional(),
            join_time: z.string().optional(),
            leave_time: z.string().optional(),
            location: z.string().optional(),
            mac_addr: z.string().optional(),
            pc_name: z.string().optional(),
            user_id: z.string().optional(),
            user_name: z.string().optional(),
            user_qos: z
              .array(
                z.object({
                  as_device_from_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  as_device_to_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  as_input: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .and(
                      z.object({
                        frame_rate: z.string().optional(),
                        resolution: z.string().optional(),
                      }),
                    )
                    .optional(),
                  as_output: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .and(
                      z.object({
                        frame_rate: z.string().optional(),
                        resolution: z.string().optional(),
                      }),
                    )
                    .optional(),
                  audio_device_from_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  audio_device_to_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  audio_input: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  audio_output: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  cpu_usage: z
                    .object({
                      system_max_cpu_usage: z.string().optional(),
                      zoom_avg_cpu_usage: z.string().optional(),
                      zoom_max_cpu_usage: z.string().optional(),
                      zoom_min_cpu_usage: z.string().optional(),
                    })
                    .optional(),
                  date_time: z.string().optional(),
                  video_device_from_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  video_device_to_crc: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .optional(),
                  video_input: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .and(
                      z.object({
                        frame_rate: z.string().optional(),
                        resolution: z.string().optional(),
                      }),
                    )
                    .optional(),
                  video_output: z
                    .object({
                      avg_loss: z.string().optional(),
                      bitrate: z.string().optional(),
                      jitter: z.string().optional(),
                      latency: z.string().optional(),
                      max_loss: z.string().optional(),
                    })
                    .and(
                      z.object({
                        frame_rate: z.string().optional(),
                        resolution: z.string().optional(),
                      }),
                    )
                    .optional(),
                }),
              )
              .optional(),
            version: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardWebinarParticipantsQosErrorSchema = z.unknown();

export const participantWebinarFeedbackDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      type: z.union([z.literal('past'), z.literal('pastOne'), z.literal('live')]).optional(),
    })
    .optional(),
});

export const participantWebinarFeedbackResponseSchema = z.object({
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  participants: z
    .array(
      z.object({
        date_time: z.string().optional(),
        email: z.string().optional(),
        quality: z.union([z.literal('GOOD'), z.literal('NOT GOOD')]).optional(),
        user_id: z.string().optional(),
      }),
    )
    .optional(),
});

export const participantWebinarFeedbackErrorSchema = z.unknown();

export const dashboardWebinarParticipantShareDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      type: z.union([z.literal('past'), z.literal('live')]).optional(),
    })
    .optional(),
});

export const dashboardWebinarParticipantShareResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      participants: z
        .array(
          z.object({
            details: z
              .array(
                z.object({
                  content: z.string().optional(),
                  end_time: z.string().optional(),
                  start_time: z.string().optional(),
                }),
              )
              .optional(),
            id: z.string().optional(),
            user_id: z.string().optional(),
            user_name: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardWebinarParticipantShareErrorSchema = z.unknown();

export const dashboardWebinarParticipantQosDataSchema = z.object({
  path: z.object({
    participantId: z.string(),
    webinarId: z.string(),
  }),
  query: z
    .object({
      type: z.union([z.literal('past'), z.literal('live')]).optional(),
    })
    .optional(),
});

export const dashboardWebinarParticipantQosResponseSchema = z.object({
  device: z.string().optional(),
  domain: z.string().optional(),
  harddisk_id: z.string().optional(),
  ip_address: z.string().optional(),
  join_time: z.string().optional(),
  leave_time: z.string().optional(),
  location: z.string().optional(),
  mac_addr: z.string().optional(),
  pc_name: z.string().optional(),
  user_id: z.string().optional(),
  user_name: z.string().optional(),
  user_qos: z
    .array(
      z.object({
        as_device_from_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        as_device_to_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        as_input: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .and(
            z.object({
              frame_rate: z.string().optional(),
              resolution: z.string().optional(),
            }),
          )
          .optional(),
        as_output: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .and(
            z.object({
              frame_rate: z.string().optional(),
              resolution: z.string().optional(),
            }),
          )
          .optional(),
        audio_device_from_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        audio_device_to_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        audio_input: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        audio_output: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        cpu_usage: z
          .object({
            system_max_cpu_usage: z.string().optional(),
            zoom_avg_cpu_usage: z.string().optional(),
            zoom_max_cpu_usage: z.string().optional(),
            zoom_min_cpu_usage: z.string().optional(),
          })
          .optional(),
        date_time: z.string().optional(),
        video_device_from_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        video_device_to_crc: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .optional(),
        video_input: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .and(
            z.object({
              frame_rate: z.string().optional(),
              resolution: z.string().optional(),
            }),
          )
          .optional(),
        video_output: z
          .object({
            avg_loss: z.string().optional(),
            bitrate: z.string().optional(),
            jitter: z.string().optional(),
            latency: z.string().optional(),
            max_loss: z.string().optional(),
          })
          .and(
            z.object({
              frame_rate: z.string().optional(),
              resolution: z.string().optional(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
  version: z.string().optional(),
});

export const dashboardWebinarParticipantQosErrorSchema = z.unknown();

export const dashboardZoomRoomsDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_number: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const dashboardZoomRoomsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      zoom_rooms: z
        .array(
          z.object({
            account_type: z.string().optional(),
            calender_name: z.string().optional(),
            camera: z.string().optional(),
            device_ip: z.string().optional(),
            email: z.string().optional(),
            health: z.string().optional(),
            id: z.string().optional(),
            issues: z.array(z.string()).optional(),
            last_start_time: z.string().optional(),
            location: z.string().optional(),
            microphone: z.string().optional(),
            room_name: z.string().optional(),
            speaker: z.string().optional(),
            status: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardZoomRoomsErrorSchema = z.unknown();

export const dashboardZoomRoomIssueDataSchema = z.object({
  query: z.object({
    from: z.string(),
    to: z.string(),
  }),
});

export const dashboardZoomRoomIssueResponseSchema = z
  .object({
    from: z.string().optional(),
    to: z.string().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      issues: z
        .array(
          z.object({
            issue_name: z.string().optional(),
            zoom_rooms_count: z.number().optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardZoomRoomIssueErrorSchema = z.unknown();

export const dashboardZoomRoomDataSchema = z.object({
  path: z.object({
    zoomroomId: z.string(),
  }),
  query: z.object({
    from: z.string(),
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    to: z.string(),
  }),
});

export const dashboardZoomRoomResponseSchema = z
  .object({
    account_type: z.string().optional(),
    calender_name: z.string().optional(),
    camera: z.string().optional(),
    device_ip: z.string().optional(),
    email: z.string().optional(),
    health: z.string().optional(),
    id: z.string().optional(),
    issues: z.array(z.string()).optional(),
    last_start_time: z.string().optional(),
    location: z.string().optional(),
    microphone: z.string().optional(),
    room_name: z.string().optional(),
    speaker: z.string().optional(),
    status: z.string().optional(),
  })
  .and(
    z.object({
      live_meeting: z
        .object({
          custom_keys: z
            .array(
              z.object({
                key: z.string().optional(),
                value: z.string().optional(),
              }),
            )
            .optional(),
          dept: z.string().optional(),
          duration: z.string().optional(),
          email: z.string().optional(),
          end_time: z.string().optional(),
          has_3rd_party_audio: z.boolean().optional(),
          has_pstn: z.boolean().optional(),
          has_recording: z.boolean().optional(),
          has_screen_share: z.boolean().optional(),
          has_sip: z.boolean().optional(),
          has_video: z.boolean().optional(),
          has_voip: z.boolean().optional(),
          host: z.string().optional(),
          id: z.number().optional(),
          in_room_participants: z.number().optional(),
          participants: z.number().optional(),
          start_time: z.string().optional(),
          topic: z.string().optional(),
          user_type: z.string().optional(),
          uuid: z.string().optional(),
        })
        .optional(),
      past_meetings: z
        .object({
          from: z.string().optional(),
          to: z.string().optional(),
        })
        .and(
          z.object({
            next_page_token: z.string().optional(),
            page_count: z.number().optional(),
            page_size: z.number().optional(),
            total_records: z.number().optional(),
          }),
        )
        .and(
          z.object({
            meetings: z
              .array(
                z.object({
                  custom_keys: z
                    .array(
                      z.object({
                        key: z.string().optional(),
                        value: z.string().optional(),
                      }),
                    )
                    .optional(),
                  dept: z.string().optional(),
                  duration: z.string().optional(),
                  email: z.string().optional(),
                  end_time: z.string().optional(),
                  has_3rd_party_audio: z.boolean().optional(),
                  has_pstn: z.boolean().optional(),
                  has_recording: z.boolean().optional(),
                  has_screen_share: z.boolean().optional(),
                  has_sip: z.boolean().optional(),
                  has_video: z.boolean().optional(),
                  has_voip: z.boolean().optional(),
                  host: z.string().optional(),
                  id: z.number().optional(),
                  in_room_participants: z.number().optional(),
                  participants: z.number().optional(),
                  start_time: z.string().optional(),
                  topic: z.string().optional(),
                  user_type: z.string().optional(),
                  uuid: z.string().optional(),
                }),
              )
              .optional(),
          }),
        )
        .optional(),
    }),
  );

export const dashboardZoomRoomErrorSchema = z.unknown();

export const listPastMeetingFilesDataSchema = z.object({
  path: z.object({
    meetingId: z.number(),
  }),
});

export const listPastMeetingFilesResponseSchema = z.object({
  in_meeting_files: z
    .array(
      z.object({
        download_url: z.string().optional(),
        file_name: z.string().optional(),
        file_size: z.number().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const listPastMeetingFilesErrorSchema = z.unknown();

export const pastMeetingsDataSchema = z.object({
  path: z.object({
    meetingId: z.number(),
  }),
});

export const pastMeetingsResponseSchema = z.object({
  meetings: z
    .array(
      z.object({
        start_time: z.string().optional(),
        uuid: z.string().optional(),
      }),
    )
    .optional(),
});

export const pastMeetingsErrorSchema = z.unknown();

export const listPastMeetingPollsDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
});

export const listPastMeetingPollsResponseSchema = z.object({
  id: z.number().optional(),
  questions: z
    .array(
      z.object({
        email: z.string().optional(),
        name: z.string().optional(),
        question_details: z
          .array(
            z.object({
              answer: z.string().optional(),
              date_time: z.string().optional(),
              polling_id: z.string().optional(),
              question: z.string().optional(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
  start_time: z.string().optional(),
  uuid: z.string().optional(),
});

export const listPastMeetingPollsErrorSchema = z.unknown();

export const pastMeetingDetailsDataSchema = z.object({
  path: z.object({
    meetingUUID: z.string(),
  }),
});

export const pastMeetingDetailsResponseSchema = z.object({
  duration: z.number().optional(),
  end_time: z.string().optional(),
  host_id: z.string().optional(),
  id: z.number().optional(),
  participants_count: z.number().optional(),
  start_time: z.string().optional(),
  topic: z.string().optional(),
  total_minutes: z.number().optional(),
  type: z.number().optional(),
  user_email: z.string().optional(),
  user_name: z.string().optional(),
  uuid: z.string().optional(),
});

export const pastMeetingDetailsErrorSchema = z.unknown();

export const pastMeetingParticipantsDataSchema = z.object({
  path: z.object({
    meetingUUID: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const pastMeetingParticipantsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      participants: z
        .array(
          z.object({
            id: z.string().optional(),
            name: z.string().optional(),
            user_email: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const pastMeetingParticipantsErrorSchema = z.unknown();

export const webinarAbsenteesDataSchema = z.object({
  path: z.object({
    WebinarUUID: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      occurrence_id: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const webinarAbsenteesResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      registrants: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z.object({
                address: z.string().optional(),
                city: z.string().optional(),
                comments: z.string().optional(),
                country: z.string().optional(),
                custom_questions: z
                  .array(
                    z.object({
                      title: z.string().optional(),
                      value: z.string().optional(),
                    }),
                  )
                  .optional(),
                email: z.string(),
                first_name: z.string(),
                industry: z.string().optional(),
                job_title: z.string().optional(),
                last_name: z.string().optional(),
                no_of_employees: z.string().optional(),
                org: z.string().optional(),
                phone: z.string().optional(),
                purchasing_time_frame: z.string().optional(),
                role_in_purchase_process: z.string().optional(),
                state: z.string().optional(),
                zip: z.string().optional(),
              }),
            )
            .and(
              z.object({
                create_time: z.string().optional(),
                join_url: z.string().optional(),
                status: z.string().optional(),
              }),
            ),
        )
        .optional(),
    }),
  );

export const webinarAbsenteesErrorSchema = z.unknown();

export const listPastWebinarFilesDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
});

export const listPastWebinarFilesResponseSchema = z.object({
  in_meeting_files: z
    .array(
      z.object({
        download_url: z.string().optional(),
        file_name: z.string().optional(),
        file_size: z.number().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const listPastWebinarFilesErrorSchema = z.unknown();

export const pastWebinarsDataSchema = z.object({
  path: z.object({
    webinarId: z.number(),
  }),
});

export const pastWebinarsResponseSchema = z.object({
  webinars: z
    .array(
      z.object({
        start_time: z.string().optional(),
        uuid: z.string().optional(),
      }),
    )
    .optional(),
});

export const pastWebinarsErrorSchema = z.unknown();

export const listWebinarParticipantsDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const listWebinarParticipantsResponseSchema = z.object({
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_size: z.number().optional(),
  participants: z
    .array(
      z.object({
        id: z.string().optional(),
        name: z.string().optional(),
        user_email: z.string().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const listWebinarParticipantsErrorSchema = z.unknown();

export const listPastWebinarPollResultsDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
});

export const listPastWebinarPollResultsResponseSchema = z.object({
  id: z.number().optional(),
  questions: z
    .array(
      z.object({
        email: z.string().optional(),
        name: z.string().optional(),
        question_details: z
          .array(
            z.object({
              answer: z.string().optional(),
              date_time: z.string().optional(),
              polling_id: z.string().optional(),
              question: z.string().optional(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
  start_time: z.string().optional(),
  uuid: z.string().optional(),
});

export const listPastWebinarPollResultsErrorSchema = z.unknown();

export const listPastWebinarQaDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
});

export const listPastWebinarQaResponseSchema = z.object({
  id: z.number().optional(),
  questions: z
    .array(
      z.object({
        email: z.string().optional(),
        name: z.string().optional(),
        question_details: z
          .array(
            z.object({
              answer: z.string().optional(),
              question: z.string().optional(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
  start_time: z.string().optional(),
  uuid: z.string().optional(),
});

export const listPastWebinarQaErrorSchema = z.unknown();

export const addAutoReceptionistDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
      site_id: z.string().optional(),
    })
    .optional(),
});

export const addAutoReceptionistResponseSchema = z.object({
  extension_number: z.number().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
});

export const addAutoReceptionistErrorSchema = z.unknown();

export const updateAutoReceptionistDataSchema = z.object({
  body: z
    .object({
      extension_number: z.number().optional(),
      name: z.string().optional(),
    })
    .optional(),
  path: z.object({
    autoReceptionistId: z.string(),
  }),
});

export const updateAutoReceptionistResponseSchema = z.unknown();

export const updateAutoReceptionistErrorSchema = z.unknown();

export const unassignAllPhoneNumsAutoReceptionistDataSchema = z.object({
  path: z.object({
    autoReceptionistId: z.string(),
  }),
});

export const unassignAllPhoneNumsAutoReceptionistResponseSchema = z.unknown();

export const unassignAllPhoneNumsAutoReceptionistErrorSchema = z.unknown();

export const assignPhoneNumbersAutoReceptionistDataSchema = z.object({
  body: z
    .object({
      phone_numbers: z
        .array(
          z.object({
            id: z.string().optional(),
            number: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  path: z.object({
    autoReceptionistId: z.string(),
  }),
});

export const assignPhoneNumbersAutoReceptionistResponseSchema = z.unknown();

export const assignPhoneNumbersAutoReceptionistErrorSchema = z.unknown();

export const unassignAphoneNumAutoReceptionistDataSchema = z.object({
  path: z.object({
    autoReceptionistId: z.string(),
    phoneNumberId: z.string(),
  }),
});

export const unassignAphoneNumAutoReceptionistResponseSchema = z.unknown();

export const unassignAphoneNumAutoReceptionistErrorSchema = z.unknown();

export const listBlockedListDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const listBlockedListResponseSchema = z.object({
  blocked_list: z
    .array(
      z.object({
        block_type: z.union([z.literal('inbound'), z.literal('outbound')]).optional(),
        comment: z.string().optional(),
        id: z.string().optional(),
        match_type: z.union([z.literal('phoneNumber'), z.literal('prefix')]).optional(),
        phone_number: z.string().optional(),
        status: z.union([z.literal('active'), z.literal('inactive')]).optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
});

export const listBlockedListErrorSchema = z.unknown();

export const addAnumberToBlockedListDataSchema = z.object({
  body: z
    .object({
      block_type: z.union([z.literal('inbound'), z.literal('outbound')]).optional(),
      comment: z.string().optional(),
      match_type: z.union([z.literal('phoneNumber'), z.literal('prefix')]).optional(),
      phone_number: z.string().optional(),
      status: z.union([z.literal('active'), z.literal('inactive')]).optional(),
    })
    .optional(),
});

export const addAnumberToBlockedListResponseSchema = z.object({
  id: z.string().optional(),
});

export const addAnumberToBlockedListErrorSchema = z.unknown();

export const deleteAblockedListDataSchema = z.object({
  path: z.object({
    blockedListId: z.string(),
  }),
});

export const deleteAblockedListResponseSchema = z.unknown();

export const deleteAblockedListErrorSchema = z.unknown();

export const getAblockedListDataSchema = z.object({
  path: z.object({
    blockedListId: z.string(),
  }),
});

export const getAblockedListResponseSchema = z.object({
  block_type: z.union([z.literal('inbound'), z.literal('outbound')]).optional(),
  comment: z.string().optional(),
  id: z.string().optional(),
  match_type: z.union([z.literal('phoneNumber'), z.literal('prefix')]).optional(),
  phone_number: z.string().optional(),
  status: z.union([z.literal('active'), z.literal('inactive')]).optional(),
});

export const getAblockedListErrorSchema = z.unknown();

export const updateBlockedListDataSchema = z.object({
  body: z
    .object({
      block_type: z.union([z.literal('inbound'), z.literal('outbound')]).optional(),
      comment: z.string().optional(),
      match_type: z.union([z.literal('phoneNumber'), z.literal('prefix')]).optional(),
      phone_number: z.string().optional(),
      status: z.union([z.literal('active'), z.literal('inactive')]).optional(),
    })
    .optional(),
  path: z.object({
    blockedListId: z.string(),
  }),
});

export const updateBlockedListResponseSchema = z.unknown();

export const updateBlockedListErrorSchema = z.unknown();

export const addByocNumberDataSchema = z.object({
  body: z
    .object({
      carrier: z.string(),
      phone_numbers: z.array(z.string()),
      site_id: z.string().optional(),
    })
    .optional(),
});

export const addByocNumberResponseSchema = z.object({
  phone_numbers: z
    .array(
      z.object({
        id: z.string().optional(),
        number: z.string().optional(),
      }),
    )
    .optional(),
});

export const addByocNumberErrorSchema = z.unknown();

export const accountCallLogsDataSchema = z.object({
  query: z
    .object({
      from: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      path: z.string().optional(),
      site_id: z.string().optional(),
      time_type: z.union([z.literal('startTime'), z.literal('endTime')]).optional(),
      to: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const accountCallLogsResponseSchema = z.object({
  call_logs: z
    .array(
      z.object({
        answer_start_time: z.string().optional(),
        call_id: z.string().optional(),
        call_type: z
          .union([
            z.literal('voip'),
            z.literal('pstn'),
            z.literal('tollfree'),
            z.literal('international'),
            z.literal('contactCenter'),
          ])
          .optional(),
        callee_name: z.string().optional(),
        callee_number: z.string().optional(),
        callee_number_type: z.string().optional(),
        caller_name: z.string().optional(),
        caller_number: z.string().optional(),
        caller_number_type: z.string().optional(),
        charge: z.string().optional(),
        client_code: z.string().optional(),
        date_time: z.string().optional(),
        direction: z.string().optional(),
        duration: z.number().optional(),
        id: z.string().optional(),
        owner: z
          .object({
            extension_number: z.number().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z
              .union([
                z.literal('user'),
                z.literal('callQueue'),
                z.literal('autoReceptionist'),
                z.literal('commonAreaPhone'),
                z.literal('sharedLineGroup'),
              ])
              .optional(),
          })
          .optional(),
        path: z.string().optional(),
        rate: z.string().optional(),
        recording_id: z.string().optional(),
        recording_type: z.union([z.literal(1), z.literal(2)]).optional(),
        result: z.string().optional(),
        site: z
          .object({
            id: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        user_id: z.string().optional(),
        waiting_time: z.string().optional(),
      }),
    )
    .optional(),
  from: z.string().optional(),
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_size: z.number().optional(),
  to: z.string().optional(),
  total_records: z.number().optional(),
});

export const accountCallLogsErrorSchema = z.unknown();

export const listCallQueuesDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const listCallQueuesResponseSchema = z.object({
  call_queues: z
    .array(
      z.object({
        extension_number: z.number().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        phone_numbers: z
          .array(
            z.object({
              id: z.string().optional(),
              number: z.string().optional(),
              source: z.union([z.literal('internal'), z.literal('external')]).optional(),
            }),
          )
          .optional(),
        site: z
          .object({
            id: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        status: z.union([z.literal('active'), z.literal('inactive')]).optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
});

export const listCallQueuesErrorSchema = z.unknown();

export const createCallQueueDataSchema = z.object({
  body: z
    .object({
      description: z.string().optional(),
      extension_number: z.number().optional(),
      members: z
        .object({
          common_area_phone_ids: z.array(z.string()).optional(),
          users: z
            .array(
              z.object({
                email: z.string().optional(),
                id: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      name: z.string(),
      site_id: z.string(),
    })
    .optional(),
});

export const createCallQueueResponseSchema = z.object({
  extension_number: z.number().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  status: z.string().optional(),
});

export const createCallQueueErrorSchema = z.unknown();

export const deleteAcallQueueDataSchema = z.object({
  path: z.object({
    callQueueId: z.string(),
  }),
});

export const deleteAcallQueueResponseSchema = z.unknown();

export const deleteAcallQueueErrorSchema = z.unknown();

export const getAcallQueueDataSchema = z.object({
  path: z.object({
    callQueueId: z.string(),
  }),
});

export const getAcallQueueResponseSchema = z.object({
  extension_number: z.number().optional(),
  id: z.string().optional(),
  members: z
    .object({
      common_area_phones: z
        .array(
          z.object({
            id: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .optional(),
      users: z
        .array(
          z.object({
            id: z.string().optional(),
            level: z.union([z.literal('manager'), z.literal('user')]).optional(),
            name: z.string().optional(),
            receive_call: z.boolean().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  name: z.string().optional(),
  phone_numbers: z
    .array(
      z.object({
        id: z.string().optional(),
        number: z.string().optional(),
        source: z.union([z.literal('internal'), z.literal('external')]).optional(),
      }),
    )
    .optional(),
  site: z
    .object({
      id: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  status: z.union([z.literal('active'), z.literal('inactive')]).optional(),
});

export const getAcallQueueErrorSchema = z.unknown();

export const updateCallQueueDataSchema = z.object({
  body: z
    .object({
      description: z.string().optional(),
      extension_number: z.number().optional(),
      name: z.string().optional(),
      site_id: z.string().optional(),
      status: z.union([z.literal('active'), z.literal('inactive')]).optional(),
      timezone: z.string().optional(),
    })
    .optional(),
  path: z.object({
    callQueueId: z.string(),
  }),
});

export const updateCallQueueResponseSchema = z.unknown();

export const updateCallQueueErrorSchema = z.unknown();

export const changeCallQueueManagerDataSchema = z.object({
  body: z
    .object({
      member_id: z.string().optional(),
    })
    .optional(),
  path: z.object({
    callQueueId: z.string(),
  }),
});

export const changeCallQueueManagerResponseSchema = z.unknown();

export const changeCallQueueManagerErrorSchema = z.unknown();

export const unassignAllMembersDataSchema = z.object({
  path: z.object({
    callQueueId: z.string(),
  }),
});

export const unassignAllMembersResponseSchema = z.unknown();

export const unassignAllMembersErrorSchema = z.unknown();

export const addMembersToCallQueueDataSchema = z.object({
  body: z
    .object({
      members: z
        .object({
          common_area_phone_ids: z.array(z.string()).optional(),
          users: z
            .array(
              z.object({
                email: z.string().optional(),
                id: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
    })
    .optional(),
  path: z.object({
    callQueueId: z.string(),
  }),
});

export const addMembersToCallQueueResponseSchema = z.record(z.unknown());

export const addMembersToCallQueueErrorSchema = z.unknown();

export const unassignMemberFromCallQueueDataSchema = z.object({
  path: z.object({
    callQueueId: z.string(),
    memberId: z.string(),
  }),
});

export const unassignMemberFromCallQueueResponseSchema = z.unknown();

export const unassignMemberFromCallQueueErrorSchema = z.unknown();

export const unassignAphoneNumCallQueueDataSchema = z.object({
  path: z.object({
    callQueueId: z.string(),
  }),
});

export const unassignAphoneNumCallQueueResponseSchema = z.record(z.unknown());

export const unassignAphoneNumCallQueueErrorSchema = z.unknown();

export const assignPhoneToCallQueueDataSchema = z.object({
  body: z
    .object({
      phone_numbers: z
        .array(
          z.object({
            id: z.string().optional(),
            number: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  path: z.object({
    callQueueId: z.string(),
  }),
});

export const assignPhoneToCallQueueResponseSchema = z.record(z.unknown());

export const assignPhoneToCallQueueErrorSchema = z.unknown();

export const unAssignPhoneNumCallQueueDataSchema = z.object({
  path: z.object({
    callQueueId: z.string(),
    phoneNumberId: z.string(),
  }),
});

export const unAssignPhoneNumCallQueueResponseSchema = z.record(z.unknown());

export const unAssignPhoneNumCallQueueErrorSchema = z.unknown();

export const getCallQueueRecordingsDataSchema = z.object({
  path: z.object({
    callQueueId: z.string(),
  }),
  query: z
    .object({
      from: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      to: z.string().optional(),
    })
    .optional(),
});

export const getCallQueueRecordingsResponseSchema = z.object({
  from: z.string().optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  recordings: z
    .array(
      z.object({
        callee_name: z.string().optional(),
        callee_number: z.string().optional(),
        callee_number_type: z.string().optional(),
        caller_name: z.string().optional(),
        caller_number: z.string().optional(),
        caller_number_type: z.string().optional(),
        date_time: z.string().optional(),
        direction: z.string().optional(),
        download_url: z.string().optional(),
        duration: z.number().optional(),
        id: z.string().optional(),
      }),
    )
    .optional(),
  to: z.string().optional(),
  total_records: z.string().optional(),
});

export const getCallQueueRecordingsErrorSchema = z.unknown();

export const listCallingPlansResponseSchema = z.object({
  calling_plans: z
    .array(
      z.object({
        assigned: z.number().optional(),
        available: z.number().optional(),
        name: z.string().optional(),
        subscribed: z.number().optional(),
        type: z.number().optional(),
      }),
    )
    .optional(),
});

export const listCallingPlansErrorSchema = z.unknown();

export const listCommonAreaPhonesDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const listCommonAreaPhonesResponseSchema = z.object({
  common_area_phones: z
    .array(
      z.object({
        calling_plans: z
          .array(
            z.object({
              name: z.string().optional(),
              type: z.string().optional(),
            }),
          )
          .optional(),
        device_type: z.string().optional(),
        display_name: z.string().optional(),
        id: z.string().optional(),
        mac_address: z.string().optional(),
        phone_numbers: z
          .array(
            z.object({
              id: z.string().optional(),
              number: z.string().optional(),
              source: z.union([z.literal('internal'), z.literal('external')]).optional(),
            }),
          )
          .optional(),
        site: z
          .object({
            id: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        status: z.string().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
});

export const listCommonAreaPhonesErrorSchema = z.unknown();

export const addCommonAreaPhoneDataSchema = z.object({
  body: z
    .object({
      description: z.string().optional(),
      display_name: z.string(),
      extension_number: z.number(),
      mac_address: z.string(),
      model: z.string().optional(),
      site_id: z.string().optional(),
      time_zone: z.string().optional(),
      type: z.string(),
    })
    .optional(),
});

export const addCommonAreaPhoneResponseSchema = z.object({
  display_name: z.string().optional(),
  id: z.string().optional(),
});

export const addCommonAreaPhoneErrorSchema = z.unknown();

export const deleteCommonAreaPhoneDataSchema = z.object({
  path: z.object({
    commonAreaPhoneId: z.string(),
  }),
});

export const deleteCommonAreaPhoneResponseSchema = z.unknown();

export const deleteCommonAreaPhoneErrorSchema = z.unknown();

export const getAcommonAreaPhoneDataSchema = z.object({
  path: z.object({
    commonAreaPhoneId: z.string(),
  }),
});

export const getAcommonAreaPhoneResponseSchema = z.object({
  device_type: z.string().optional(),
  id: z.string().optional(),
  mac_address: z.string().optional(),
  name: z.string().optional(),
  provision: z
    .object({
      sip_accounts: z
        .array(
          z.object({
            authorization_id: z.string().optional(),
            outbound_proxy: z.string().optional(),
            password: z.string().optional(),
            sip_domain: z.string().optional(),
            user_name: z.string().optional(),
          }),
        )
        .optional(),
      type: z.union([z.literal('assisted'), z.literal('ztp'), z.literal('manual')]).optional(),
      url: z.string().optional(),
    })
    .optional(),
  site: z
    .object({
      id: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  status: z.string().optional(),
});

export const getAcommonAreaPhoneErrorSchema = z.unknown();

export const updateCommonAreaPhoneDataSchema = z.object({
  body: z
    .object({
      display_name: z.string().optional(),
      extension_number: z.number().optional(),
      mac_address: z.string().optional(),
      site_id: z.string().optional(),
    })
    .optional(),
  path: z.object({
    commonAreaPhoneId: z.string(),
  }),
});

export const updateCommonAreaPhoneResponseSchema = z.unknown();

export const updateCommonAreaPhoneErrorSchema = z.unknown();

export const changeMainCompanyNumberDataSchema = z.object({
  body: z
    .object({
      phone_number: z.string().optional(),
    })
    .optional(),
});

export const changeMainCompanyNumberResponseSchema = z.unknown();

export const changeMainCompanyNumberErrorSchema = z.unknown();

export const listPhoneDevicesDataSchema = z.object({
  query: z.object({
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    type: z.union([z.literal('assigned'), z.literal('unassigned')]),
  }),
});

export const listPhoneDevicesResponseSchema = z.object({
  devices: z
    .array(
      z.object({
        assignee: z
          .object({
            extension_number: z.number().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        device_type: z.string().optional(),
        display_name: z.string().optional(),
        id: z.string().optional(),
        mac_address: z.string().optional(),
        site: z
          .object({
            id: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        status: z.union([z.literal('online'), z.literal('offline')]).optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  total_records: z.string().optional(),
});

export const listPhoneDevicesErrorSchema = z.unknown();

export const addPhoneDeviceDataSchema = z.object({
  body: z
    .object({
      assigned_to: z.string().optional(),
      display_name: z.string(),
      mac_address: z.string(),
      model: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const addPhoneDeviceResponseSchema = z.unknown();

export const addPhoneDeviceErrorSchema = z.unknown();

export const deleteAdeviceDataSchema = z.object({
  path: z.object({
    deviceId: z.string(),
  }),
});

export const deleteAdeviceResponseSchema = z.unknown();

export const deleteAdeviceErrorSchema = z.unknown();

export const getAdeviceDataSchema = z.object({
  path: z.object({
    deviceId: z.string(),
  }),
});

export const getAdeviceResponseSchema = z.object({
  assignee: z
    .object({
      extension_number: z.number().optional(),
      id: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  device_type: z.string().optional(),
  display_name: z.string().optional(),
  id: z.string().optional(),
  mac_address: z.string().optional(),
  provision: z
    .object({
      sip_accounts: z
        .array(
          z.object({
            authorization_id: z.string().optional(),
            outbound_proxy: z.string().optional(),
            password: z.string().optional(),
            shared_line: z
              .object({
                alias: z.string().optional(),
                line_subscription: z
                  .object({
                    display_name: z.string().optional(),
                    extension_number: z.number().optional(),
                    phone_number: z.string().optional(),
                  })
                  .optional(),
                outbound_caller_id: z.string().optional(),
              })
              .optional(),
            sip_domain: z.string().optional(),
            user_name: z.string().optional(),
          }),
        )
        .optional(),
      type: z.union([z.literal('assisted'), z.literal('ztp'), z.literal('manual')]).optional(),
      url: z.string().optional(),
    })
    .optional(),
  site: z
    .object({
      id: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  status: z.union([z.literal('online'), z.literal('offline')]).optional(),
});

export const getAdeviceErrorSchema = z.unknown();

export const updateAdeviceDataSchema = z.object({
  body: z
    .object({
      assigned_to: z.string().optional(),
      display_name: z.string().optional(),
      mac_address: z.string().optional(),
    })
    .optional(),
  path: z.object({
    deviceId: z.string(),
  }),
});

export const updateAdeviceResponseSchema = z.unknown();

export const updateAdeviceErrorSchema = z.unknown();

export const listCallLogsMetricsDataSchema = z.object({
  query: z
    .object({
      from: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      quality_type: z.string().optional(),
      site_id: z.string().optional(),
      to: z.string().optional(),
    })
    .optional(),
});

export const listCallLogsMetricsResponseSchema = z.object({
  call_logs: z
    .array(
      z.object({
        call_id: z.string().optional(),
        callee: z
          .object({
            codec: z.string().optional(),
            device_type: z.string().optional(),
            extension_number: z.string().optional(),
            headset: z.string().optional(),
            isp: z.string().optional(),
            microphone: z.string().optional(),
            phone_number: z.string().optional(),
            site_id: z.string().optional(),
          })
          .optional(),
        caller: z
          .object({
            codec: z.string().optional(),
            device_type: z.string().optional(),
            extension_number: z.string().optional(),
            headset: z.string().optional(),
            isp: z.string().optional(),
            microphone: z.string().optional(),
            phone_number: z.string().optional(),
            site_id: z.string().optional(),
          })
          .optional(),
        date_time: z.string().optional(),
        direction: z.string().optional(),
        duration: z.number().optional(),
        mos: z.string().optional(),
      }),
    )
    .optional(),
  from: z.string().optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  to: z.string().optional(),
  total_records: z.number().optional(),
});

export const listCallLogsMetricsErrorSchema = z.unknown();

export const getCallQoSDataSchema = z.object({
  path: z.object({
    callId: z.string(),
  }),
});

export const getCallQoSResponseSchema = z.object({
  call_id: z.string().optional(),
  callee_qos: z
    .object({
      receiving: z
        .array(
          z.object({
            date_time: z.string().optional(),
            qos: z
              .object({
                avg_loss: z.string().optional(),
                bitrate: z.string().optional(),
                jitter: z.string().optional(),
                max_loss: z.string().optional(),
                mos: z.string().optional(),
                network_delay: z.string().optional(),
              })
              .optional(),
          }),
        )
        .optional(),
      sending: z
        .array(
          z.object({
            date_time: z.string().optional(),
            qos: z
              .object({
                avg_loss: z.string().optional(),
                bitrate: z.string().optional(),
                jitter: z.string().optional(),
                max_loss: z.string().optional(),
                mos: z.string().optional(),
                network_delay: z.string().optional(),
              })
              .optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  caller_qos: z
    .object({
      receiving: z
        .array(
          z.object({
            date_time: z.string().optional(),
            qos: z
              .object({
                avg_loss: z.string().optional(),
                bitrate: z.string().optional(),
                jitter: z.string().optional(),
                max_loss: z.string().optional(),
                mos: z.string().optional(),
                network_delay: z.string().optional(),
              })
              .optional(),
          }),
        )
        .optional(),
      sending: z
        .array(
          z.object({
            date_time: z.string().optional(),
            qos: z
              .object({
                avg_loss: z.string().optional(),
                bitrate: z.string().optional(),
                jitter: z.string().optional(),
                max_loss: z.string().optional(),
                mos: z.string().optional(),
                network_delay: z.string().optional(),
              })
              .optional(),
          }),
        )
        .optional(),
    })
    .optional(),
});

export const getCallQoSErrorSchema = z.unknown();

export const getCallLogMetricsDetailsDataSchema = z.object({
  path: z.object({
    call_id: z.string(),
  }),
});

export const getCallLogMetricsDetailsResponseSchema = z.object({
  call_id: z.string().optional(),
  callee: z
    .object({
      codec: z.string().optional(),
      device_type: z.string().optional(),
      extension_number: z.string().optional(),
      headset: z.string().optional(),
      isp: z.string().optional(),
      microphone: z.string().optional(),
      phone_number: z.string().optional(),
      site_id: z.string().optional(),
    })
    .optional(),
  caller: z
    .object({
      codec: z.string().optional(),
      device_type: z.string().optional(),
      extension_number: z.string().optional(),
      headset: z.string().optional(),
      isp: z.string().optional(),
      microphone: z.string().optional(),
      phone_number: z.string().optional(),
      site_id: z.string().optional(),
    })
    .optional(),
  date_time: z.string().optional(),
  direction: z.string().optional(),
  duration: z.number().optional(),
  mos: z.string().optional(),
});

export const getCallLogMetricsDetailsErrorSchema = z.unknown();

export const listAccountPhoneNumbersDataSchema = z.object({
  query: z
    .object({
      extension_type: z
        .union([z.literal('user'), z.literal('callQueue'), z.literal('autoReceptionist'), z.literal('commonAreaPhone')])
        .optional(),
      next_page_token: z.string().optional(),
      number_type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
      page_size: z.number().optional(),
      pending_numbers: z.boolean().optional(),
      site_id: z.string().optional(),
      type: z.union([z.literal('assigned'), z.literal('unassigned'), z.literal('all')]).optional(),
    })
    .optional(),
});

export const listAccountPhoneNumbersResponseSchema = z.object({
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  phone_numbers: z
    .array(
      z.object({
        assignee: z
          .object({
            extension_number: z.number().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z
              .union([
                z.literal('user'),
                z.literal('callQueue'),
                z.literal('autoReceptionist'),
                z.literal('commonAreaPhone'),
              ])
              .optional(),
          })
          .optional(),
        capability: z.array(z.string()).optional(),
        carrier: z
          .object({
            code: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        display_name: z.string().optional(),
        id: z.string().optional(),
        location: z.string().optional(),
        number: z.string().optional(),
        number_type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
        sip_group: z
          .object({
            id: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        site: z
          .object({
            id: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        source: z.union([z.literal('internal'), z.literal('external')]).optional(),
        status: z.union([z.literal('pending'), z.literal('available')]).optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const listAccountPhoneNumbersErrorSchema = z.unknown();

export const getPhoneNumberDetailsDataSchema = z.object({
  path: z.object({
    numberId: z.string(),
  }),
});

export const getPhoneNumberDetailsResponseSchema = z.object({
  assignee: z
    .object({
      extension_number: z.number().optional(),
      id: z.string().optional(),
      name: z.string().optional(),
      type: z
        .union([z.literal('user'), z.literal('callQueue'), z.literal('autoReceptionist'), z.literal('commonAreaPhone')])
        .optional(),
    })
    .optional(),
  capability: z.array(z.string()).optional(),
  display_name: z.string().optional(),
  id: z.string().optional(),
  location: z.string().optional(),
  number: z.string().optional(),
  number_type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
  site: z
    .object({
      id: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  source: z.union([z.literal('internal'), z.literal('external')]).optional(),
  status: z.union([z.literal('pending'), z.literal('available')]).optional(),
});

export const getPhoneNumberDetailsErrorSchema = z.unknown();

export const updatePhoneNumberDetailsDataSchema = z.object({
  body: z
    .object({
      capability: z.array(z.string()).optional(),
      display_name: z.string().optional(),
    })
    .optional(),
  path: z.object({
    numberId: z.string(),
  }),
});

export const updatePhoneNumberDetailsResponseSchema = z.unknown();

export const updatePhoneNumberDetailsErrorSchema = z.unknown();

export const getPhoneRecordingsDataSchema = z.object({
  query: z
    .object({
      from: z.string().optional(),
      next_page_token: z.string().optional(),
      owner_type: z.string().optional(),
      page_size: z.number().optional(),
      recording_type: z.string().optional(),
      site_id: z.string().optional(),
      to: z.string().optional(),
    })
    .optional(),
});

export const getPhoneRecordingsResponseSchema = z.object({
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  recordings: z
    .array(
      z.object({
        callee_name: z.string().optional(),
        callee_number: z.string().optional(),
        callee_number_type: z.union([z.literal(1), z.literal(2)]).optional(),
        caller_name: z.string().optional(),
        caller_number: z.string().optional(),
        caller_number_type: z.union([z.literal(1), z.literal(2)]).optional(),
        date_time: z.string().optional(),
        direction: z.union([z.literal('inbound'), z.literal('outbound')]).optional(),
        download_url: z.string().optional(),
        duration: z.number().optional(),
        id: z.string().optional(),
        owner: z
          .object({
            extension_number: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z.union([z.literal('user'), z.literal('call queue')]).optional(),
          })
          .optional(),
        recording_type: z.string().optional(),
        site: z
          .object({
            id: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const getPhoneRecordingsErrorSchema = z.unknown();

export const getPsOperationLogsDataSchema = z.object({
  query: z
    .object({
      category_type: z.string().optional(),
      from: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      to: z.string().optional(),
    })
    .optional(),
});

export const getPsOperationLogsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
  })
  .and(
    z.object({
      operation_logs: z
        .array(
          z.object({
            action: z.string().optional(),
            category_type: z.string().optional(),
            operation_detail: z.string().optional(),
            operator: z.string().optional(),
            time: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const getPsOperationLogsErrorSchema = z.unknown();

export const listSettingTemplatesDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      site_id: z.string().optional(),
    })
    .optional(),
});

export const listSettingTemplatesResponseSchema = z.object({
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  templates: z
    .array(
      z.object({
        description: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        type: z
          .union([
            z.literal('user'),
            z.literal('group'),
            z.literal('autReceptionist'),
            z.literal('commonArea'),
            z.literal('zr'),
            z.literal('interop'),
          ])
          .optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const listSettingTemplatesErrorSchema = z.unknown();

export const addSettingTemplateDataSchema = z.object({
  body: z
    .object({
      description: z.string().optional(),
      name: z.string(),
      site_id: z.string().optional(),
      type: z.union([
        z.literal('user'),
        z.literal('group'),
        z.literal('autoReceptionist'),
        z.literal('commonarea'),
        z.literal('interop'),
      ]),
    })
    .optional(),
});

export const addSettingTemplateResponseSchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  type: z.string().optional(),
});

export const addSettingTemplateErrorSchema = z.unknown();

export const getSettingTemplateDataSchema = z.object({
  path: z.object({
    templateId: z.string(),
  }),
  query: z
    .object({
      custom_query_fields: z.string().optional(),
    })
    .optional(),
});

export const getSettingTemplateResponseSchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  policy: z
    .object({
      ad_hoc_call_recording: z
        .object({
          enable: z.boolean().optional(),
          recording_start_prompt: z.boolean().optional(),
          recording_transcription: z.boolean().optional(),
        })
        .optional(),
      auto_call_recording: z
        .object({
          enable: z.boolean().optional(),
          recording_calls: z.string().optional(),
          recording_start_prompt: z.boolean().optional(),
          recording_transcription: z.boolean().optional(),
        })
        .optional(),
      sms: z
        .object({
          enable: z.boolean().optional(),
          international_sms: z.boolean().optional(),
        })
        .optional(),
      voicemail: z
        .object({
          allow_transcription: z.boolean().optional(),
          enable: z.boolean().optional(),
        })
        .optional(),
    })
    .optional(),
  profile: z
    .object({
      area_code: z.string().optional(),
      country: z.string().optional(),
    })
    .optional(),
  type: z
    .union([
      z.literal('user'),
      z.literal('group'),
      z.literal('autoReceptionist'),
      z.literal('commonArea'),
      z.literal('zr'),
      z.literal('interop'),
    ])
    .optional(),
  user_settings: z
    .object({
      audio_prompt_language: z.string().optional(),
      block_calls_without_caller_id: z.boolean().optional(),
      call_handling: z
        .object({
          business_hours: z
            .object({
              business_hour_action: z
                .union([z.literal(0), z.literal(1), z.literal(9), z.literal(26), z.literal(50)])
                .optional(),
              connect_to_operator: z
                .object({
                  enable: z.boolean().optional(),
                  id: z.string().optional(),
                  type: z
                    .union([
                      z.literal('user'),
                      z.literal('zoomRoom'),
                      z.literal('commonAreaPhone'),
                      z.literal('autoReceptionist'),
                      z.literal('callQueue'),
                      z.literal('sharedLineGroup'),
                    ])
                    .optional(),
                })
                .optional(),
              custom_hours: z
                .array(
                  z.object({
                    from: z.string().optional(),
                    to: z.string().optional(),
                    type: z.union([z.literal(1), z.literal(2)]).optional(),
                    weekday: z
                      .union([
                        z.literal(1),
                        z.literal(2),
                        z.literal(3),
                        z.literal(4),
                        z.literal(5),
                        z.literal(6),
                        z.literal(7),
                      ])
                      .optional(),
                  }),
                )
                .optional(),
              ring_type: z.union([z.literal(0), z.literal(1)]).optional(),
              ringing_duration: z
                .union([
                  z.literal(15),
                  z.literal(20),
                  z.literal(25),
                  z.literal(30),
                  z.literal(35),
                  z.literal(40),
                  z.literal(45),
                  z.literal(50),
                  z.literal(55),
                  z.literal(60),
                ])
                .optional(),
              type: z.union([z.literal(1), z.literal(2)]).optional(),
            })
            .optional(),
          close_hours: z
            .object({
              close_hour_action: z
                .union([z.literal(0), z.literal(1), z.literal(9), z.literal(26), z.literal(50)])
                .optional(),
              connect_to_operator: z
                .object({
                  enable: z.boolean().optional(),
                  id: z.string().optional(),
                  type: z
                    .union([
                      z.literal('user'),
                      z.literal('zoomRoom'),
                      z.literal('commonAreaPhone'),
                      z.literal('autoReceptionist'),
                      z.literal('callQueue'),
                      z.literal('sharedLineGroup'),
                    ])
                    .optional(),
                })
                .optional(),
              max_wait_time: z
                .union([
                  z.literal(15),
                  z.literal(20),
                  z.literal(25),
                  z.literal(30),
                  z.literal(35),
                  z.literal(40),
                  z.literal(45),
                  z.literal(50),
                  z.literal(55),
                  z.literal(60),
                ])
                .optional(),
            })
            .optional(),
        })
        .optional(),
      desk_phone: z
        .object({
          pin_code: z.string().optional(),
        })
        .optional(),
      hold_music: z.union([z.literal('default'), z.literal('disable')]).optional(),
    })
    .optional(),
});

export const getSettingTemplateErrorSchema = z.unknown();

export const updateSettingTemplateDataSchema = z.object({
  body: z
    .object({
      description: z.string().optional(),
      name: z.string().optional(),
      policy: z
        .object({
          ad_hoc_call_recording: z
            .object({
              enable: z.boolean().optional(),
              recording_start_prompt: z.boolean().optional(),
              recording_transcription: z.boolean().optional(),
            })
            .optional(),
          auto_call_recording: z
            .object({
              enable: z.boolean().optional(),
              recording_calls: z.union([z.literal('inbound'), z.literal('outbound'), z.literal('both')]).optional(),
              recording_start_prompt: z.boolean().optional(),
              recording_transcription: z.boolean().optional(),
            })
            .optional(),
          sms: z
            .object({
              enable: z.boolean().optional(),
              international_sms: z.boolean().optional(),
            })
            .optional(),
          voicemail: z
            .object({
              allow_transcription: z.boolean().optional(),
              enable: z.boolean().optional(),
            })
            .optional(),
        })
        .optional(),
      profile: z
        .object({
          area_code: z.string().optional(),
          country: z.string().optional(),
        })
        .optional(),
      user_settings: z
        .object({
          audio_prompt_language: z.string().optional(),
          block_calls_without_caller_id: z.boolean().optional(),
          call_handling: z
            .object({
              business_hours: z
                .object({
                  business_hour_action: z
                    .union([z.literal(0), z.literal(1), z.literal(9), z.literal(26), z.literal(50)])
                    .optional(),
                  connect_to_operator: z
                    .object({
                      enable: z.boolean().optional(),
                      id: z.string().optional(),
                      type: z
                        .union([
                          z.literal('user'),
                          z.literal('zoomRoom'),
                          z.literal('commonAreaPhone'),
                          z.literal('autoReceptionist'),
                          z.literal('callQueue'),
                          z.literal('sharedLineGroup'),
                        ])
                        .optional(),
                    })
                    .optional(),
                  custom_hours: z
                    .array(
                      z.object({
                        from: z.string().optional(),
                        to: z.string().optional(),
                        type: z.union([z.literal(1), z.literal(2)]).optional(),
                        weekday: z
                          .union([
                            z.literal(1),
                            z.literal(2),
                            z.literal(3),
                            z.literal(4),
                            z.literal(5),
                            z.literal(6),
                            z.literal(7),
                          ])
                          .optional(),
                      }),
                    )
                    .optional(),
                  ring_type: z.union([z.literal(0), z.literal(1)]).optional(),
                  ringing_duration: z
                    .union([
                      z.literal(15),
                      z.literal(20),
                      z.literal(25),
                      z.literal(30),
                      z.literal(35),
                      z.literal(40),
                      z.literal(45),
                      z.literal(50),
                      z.literal(55),
                      z.literal(60),
                    ])
                    .optional(),
                  type: z.union([z.literal(1), z.literal(2)]).optional(),
                })
                .optional(),
              close_hours: z
                .object({
                  close_hour_action: z
                    .union([z.literal(0), z.literal(1), z.literal(9), z.literal(26), z.literal(50)])
                    .optional(),
                  connect_to_operator: z
                    .object({
                      enable: z.boolean().optional(),
                      id: z.string().optional(),
                      type: z
                        .union([
                          z.literal('user'),
                          z.literal('zoomRoom'),
                          z.literal('commonAreaPhone'),
                          z.literal('autoReceptionist'),
                          z.literal('callQueue'),
                          z.literal('sharedLineGroup'),
                        ])
                        .optional(),
                    })
                    .optional(),
                  max_wait_time: z
                    .union([
                      z.literal(15),
                      z.literal(20),
                      z.literal(25),
                      z.literal(30),
                      z.literal(35),
                      z.literal(40),
                      z.literal(45),
                      z.literal(50),
                      z.literal(55),
                      z.literal(60),
                    ])
                    .optional(),
                })
                .optional(),
            })
            .optional(),
          desk_phone: z
            .object({
              pin_code: z.string().optional(),
            })
            .optional(),
          hold_music: z.union([z.literal('default'), z.literal('disable')]).optional(),
        })
        .optional(),
    })
    .optional(),
  path: z.object({
    templateId: z.string(),
  }),
});

export const updateSettingTemplateResponseSchema = z.unknown();

export const updateSettingTemplateErrorSchema = z.unknown();

export const listSharedLineGroupsDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const listSharedLineGroupsResponseSchema = z.object({
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  shared_line_groups: z
    .array(
      z.object({
        display_name: z.string().optional(),
        extension_number: z.number().optional(),
        id: z.string().optional(),
        phone_numbers: z
          .array(
            z.object({
              id: z.string().optional(),
              number: z.string().optional(),
              status: z.union([z.literal('pending'), z.literal('available')]).optional(),
            }),
          )
          .optional(),
        site: z
          .object({
            id: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        status: z.union([z.literal('active'), z.literal('inactive')]).optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const listSharedLineGroupsErrorSchema = z.unknown();

export const createAsharedLineGroupDataSchema = z.object({
  body: z
    .object({
      description: z.string().optional(),
      display_name: z.string(),
      extension_number: z.number().optional(),
      site_id: z.string().optional(),
    })
    .optional(),
});

export const createAsharedLineGroupResponseSchema = z.unknown();

export const createAsharedLineGroupErrorSchema = z.unknown();

export const deleteAsharedLineGroupDataSchema = z.object({
  path: z.object({
    sharedLineGroupId: z.string(),
  }),
});

export const deleteAsharedLineGroupResponseSchema = z.unknown();

export const deleteAsharedLineGroupErrorSchema = z.unknown();

export const getAsharedLineGroupDataSchema = z.object({
  path: z.object({
    sharedLineGroupId: z.string(),
  }),
});

export const getAsharedLineGroupResponseSchema = z.object({
  display_name: z.string().optional(),
  extension_number: z.number().optional(),
  id: z.string().optional(),
  members: z
    .object({
      common_area_phones: z
        .array(
          z.object({
            id: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .optional(),
      users: z
        .array(
          z.object({
            id: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  phone_numbers: z
    .array(
      z.object({
        id: z.string().optional(),
        number: z.string().optional(),
      }),
    )
    .optional(),
  primary_number: z.string().optional(),
  site: z
    .object({
      id: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  status: z.union([z.literal('active'), z.literal('inactive')]).optional(),
  timezone: z.string().optional(),
});

export const getAsharedLineGroupErrorSchema = z.unknown();

export const updateAsharedLineGroupDataSchema = z.object({
  body: z
    .object({
      display_name: z.string().optional(),
      extension_number: z.number().optional(),
      primary_number: z
        .object({
          id: z.string().optional(),
          number: z.string().optional(),
        })
        .optional(),
      status: z.union([z.literal('active'), z.literal('inactive')]).optional(),
      timezone: z.string().optional(),
    })
    .optional(),
  path: z.object({
    sharedLineGroupId: z.string(),
  }),
});

export const updateAsharedLineGroupResponseSchema = z.unknown();

export const updateAsharedLineGroupErrorSchema = z.unknown();

export const deleteMembersOfSlgDataSchema = z.object({
  path: z.object({
    sharedLineGroupId: z.string(),
  }),
});

export const deleteMembersOfSlgResponseSchema = z.unknown();

export const deleteMembersOfSlgErrorSchema = z.unknown();

export const addMembersToSharedLineGroupDataSchema = z.object({
  body: z
    .object({
      members: z
        .object({
          common_area_phone_ids: z.array(z.string()).optional(),
          users: z
            .array(
              z.object({
                email: z.string().optional(),
                id: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
    })
    .optional(),
  path: z.object({
    sharedLineGroupId: z.string(),
  }),
});

export const addMembersToSharedLineGroupResponseSchema = z.unknown();

export const addMembersToSharedLineGroupErrorSchema = z.unknown();

export const deleteAmemberSlgDataSchema = z.object({
  path: z.object({
    memberId: z.string(),
    sharedLineGroupId: z.string(),
  }),
});

export const deleteAmemberSlgResponseSchema = z.any();

export const deleteAmemberSlgErrorSchema = z.unknown();

export const assignPhoneNumbersSlgDataSchema = z.object({
  body: z
    .object({
      phone_numbers: z
        .array(
          z.object({
            id: z.string().optional(),
            number: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  path: z.object({
    sharedLineGroupId: z.string(),
  }),
});

export const assignPhoneNumbersSlgResponseSchema = z.unknown();

export const assignPhoneNumbersSlgErrorSchema = z.unknown();

export const deleteAphoneNumberSlgDataSchema = z.object({
  path: z.object({
    phoneNumberId: z.string(),
    sharedLineGroupId: z.string(),
  }),
});

export const deleteAphoneNumberSlgResponseSchema = z.any();

export const deleteAphoneNumberSlgErrorSchema = z.unknown();

export const listByocsipTrunkDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const listByocsipTrunkResponseSchema = z.object({
  byoc_sip_trunk: z
    .array(
      z.object({
        carrier: z.string().optional(),
        carrier_account: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        region: z.string().optional(),
        sbc_label: z.string().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
});

export const listByocsipTrunkErrorSchema = z.unknown();

export const listPhoneSitesDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const listPhoneSitesResponseSchema = z.object({
  next_page_token: z.string().optional(),
  page_size: z.string().optional(),
  sites: z
    .array(
      z.object({
        country: z
          .object({
            code: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        id: z.string().optional(),
        main_auto_receptionist: z
          .object({
            extension_id: z.string().optional(),
            extension_number: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        name: z.string().optional(),
        site_code: z.string().optional(),
      }),
    )
    .optional(),
  total_records: z.string().optional(),
});

export const listPhoneSitesErrorSchema = z.unknown();

export const createPhoneSiteDataSchema = z.object({
  body: z
    .object({
      auto_receptionist_name: z.string(),
      default_emergency_address: z
        .object({
          address_line1: z.string(),
          address_line2: z.string().optional(),
          city: z.string(),
          country: z.string(),
          state_code: z.string(),
          zip: z.string(),
        })
        .optional(),
      name: z.string(),
      short_extension: z
        .object({
          length: z.number().optional(),
        })
        .optional(),
      site_code: z.number().optional(),
    })
    .optional(),
});

export const createPhoneSiteResponseSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
});

export const createPhoneSiteErrorSchema = z.unknown();

export const deletePhoneSiteDataSchema = z.object({
  path: z.object({
    siteId: z.string(),
  }),
  query: z.object({
    transfer_site_id: z.string(),
  }),
});

export const deletePhoneSiteResponseSchema = z.unknown();

export const deletePhoneSiteErrorSchema = z.unknown();

export const getAsiteDataSchema = z.object({
  path: z.object({
    siteId: z.string(),
  }),
});

export const getAsiteResponseSchema = z.object({
  country: z
    .object({
      code: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  id: z.string().optional(),
  main_auto_receptionist: z
    .object({
      extension_id: z.string().optional(),
      extension_number: z.number().optional(),
      id: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  name: z.string().optional(),
  short_extension: z
    .object({
      length: z.number().optional(),
    })
    .optional(),
  site_code: z.number().optional(),
});

export const getAsiteErrorSchema = z.unknown();

export const updateSiteDetailsDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
      site_code: z.number().optional(),
    })
    .optional(),
  path: z.object({
    siteId: z.string(),
  }),
});

export const updateSiteDetailsResponseSchema = z.unknown();

export const updateSiteDetailsErrorSchema = z.unknown();

export const listPhoneUsersDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      site_id: z.string().optional(),
    })
    .optional(),
});

export const listPhoneUsersResponseSchema = z.object({
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
  users: z
    .array(
      z.object({
        calling_plans: z
          .array(
            z.object({
              name: z.string().optional(),
              type: z.string().optional(),
            }),
          )
          .optional(),
        email: z.string().optional(),
        extension_number: z.number().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        phone_user_id: z.string().optional(),
        site: z
          .object({
            id: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        status: z.string().optional(),
      }),
    )
    .optional(),
});

export const listPhoneUsersErrorSchema = z.unknown();

export const phoneUserDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
});

export const phoneUserResponseSchema = z.object({
  calling_plan: z
    .array(
      z.object({
        type: z.number().optional(),
      }),
    )
    .optional(),
  email: z.string().optional(),
  extension_number: z.number().optional(),
  id: z.string().optional(),
  phone_numbers: z
    .array(
      z.object({
        id: z.string().optional(),
        number: z.string().optional(),
      }),
    )
    .optional(),
  phone_user_id: z.string().optional(),
  site_admin: z.boolean().optional(),
  site_id: z.string().optional(),
  status: z.union([z.literal('activate'), z.literal('deactivate')]).optional(),
});

export const phoneUserErrorSchema = z.unknown();

export const updateUserProfileDataSchema = z.object({
  body: z
    .object({
      extension_number: z.string().optional(),
      site_id: z.string().optional(),
    })
    .optional(),
  path: z.object({
    userId: z.string(),
  }),
});

export const updateUserProfileResponseSchema = z.unknown();

export const updateUserProfileErrorSchema = z.unknown();

export const phoneUserCallLogsDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z.object({
    from: z.string(),
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    phone_number: z.string().optional(),
    time_type: z.union([z.literal('startTime'), z.literal('endTime')]).optional(),
    to: z.string(),
    type: z.union([z.literal('all'), z.literal('missed')]).optional(),
  }),
});

export const phoneUserCallLogsResponseSchema = z.object({
  call_logs: z
    .array(
      z.object({
        accepted_by: z
          .object({
            extension_number: z.string().optional(),
            location: z.string().optional(),
            name: z.string().optional(),
            number_type: z.string().optional(),
            phone_number: z.string().optional(),
          })
          .optional(),
        call_id: z.string().optional(),
        callee_name: z.string().optional(),
        callee_number: z.string().optional(),
        callee_number_type: z.string().optional(),
        caller_name: z.string().optional(),
        caller_number: z.string().optional(),
        caller_number_type: z.string().optional(),
        charge: z.string().optional(),
        client_code: z.string().optional(),
        date_time: z.string().optional(),
        direction: z.string().optional(),
        duration: z.number().optional(),
        forwarded_by: z
          .object({
            extension_number: z.string().optional(),
            location: z.string().optional(),
            name: z.string().optional(),
            number_type: z.string().optional(),
            phone_number: z.string().optional(),
          })
          .optional(),
        forwarded_to: z
          .object({
            extension_number: z.string().optional(),
            location: z.string().optional(),
            name: z.string().optional(),
            number_type: z.string().optional(),
            phone_number: z.string().optional(),
          })
          .optional(),
        has_recording: z.boolean().optional(),
        has_voicemail: z.boolean().optional(),
        id: z.string().optional(),
        outgoing_by: z
          .object({
            extension_number: z.string().optional(),
            location: z.string().optional(),
            name: z.string().optional(),
            number_type: z.string().optional(),
            phone_number: z.string().optional(),
          })
          .optional(),
        path: z.string().optional(),
        rate: z.string().optional(),
        recording_type: z.string().optional(),
        result: z.string().optional(),
        site: z
          .object({
            id: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
        user_id: z.string().optional(),
        waiting_time: z.number().optional(),
      }),
    )
    .optional(),
  from: z.string().optional(),
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_size: z.number().optional(),
  to: z.string().optional(),
  total_records: z.number().optional(),
});

export const phoneUserCallLogsErrorSchema = z.unknown();

export const deleteCallLogDataSchema = z.object({
  path: z.object({
    callLogId: z.string(),
    userId: z.string(),
  }),
});

export const deleteCallLogResponseSchema = z.unknown();

export const deleteCallLogErrorSchema = z.unknown();

export const assignCallingPlanDataSchema = z.object({
  body: z
    .object({
      calling_plans: z
        .array(
          z.object({
            type: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  path: z.object({
    userId: z.string(),
  }),
});

export const assignCallingPlanResponseSchema = z.unknown();

export const assignCallingPlanErrorSchema = z.unknown();

export const unassignCallingPlanDataSchema = z.object({
  path: z.object({
    type: z.string(),
    userId: z.string(),
  }),
});

export const unassignCallingPlanResponseSchema = z.unknown();

export const unassignCallingPlanErrorSchema = z.unknown();

export const assignPhoneNumberDataSchema = z.object({
  body: z
    .object({
      phone_numbers: z
        .array(
          z.object({
            id: z.string().optional(),
            number: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  path: z.object({
    userId: z.string(),
  }),
});

export const assignPhoneNumberResponseSchema = z.object({
  phone_numbers: z
    .array(
      z.object({
        id: z.string().optional(),
        number: z.string().optional(),
      }),
    )
    .optional(),
});

export const assignPhoneNumberErrorSchema = z.unknown();

export const unassignPhoneNumberDataSchema = z.object({
  path: z.object({
    phoneNumberId: z.string(),
    userId: z.string(),
  }),
});

export const unassignPhoneNumberResponseSchema = z.unknown();

export const unassignPhoneNumberErrorSchema = z.unknown();

export const phoneUserRecordingsDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z.object({
    from: z.string().optional(),
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    to: z.string(),
  }),
});

export const phoneUserRecordingsResponseSchema = z.object({
  from: z.string().optional(),
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_size: z.number().optional(),
  recordings: z
    .array(
      z.object({
        callee_name: z.string().optional(),
        callee_number: z.string().optional(),
        callee_number_type: z.string().optional(),
        caller_name: z.string().optional(),
        caller_number: z.string().optional(),
        caller_number_type: z.string().optional(),
        date_time: z.string().optional(),
        direction: z.string().optional(),
        download_url: z.string().optional(),
        duration: z.string().optional(),
        id: z.string().optional(),
      }),
    )
    .optional(),
  to: z.string().optional(),
  total_records: z.number().optional(),
});

export const phoneUserRecordingsErrorSchema = z.unknown();

export const phoneUserSettingsDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
});

export const phoneUserSettingsResponseSchema = z.object({
  area_code: z.string().optional(),
  company_number: z.string().optional(),
  desk_phone: z
    .object({
      keys_positions: z
        .object({
          primary_number: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  outbound_caller: z
    .object({
      number: z.string().optional(),
    })
    .optional(),
  outbound_caller_ids: z
    .object({
      is_default: z.boolean().optional(),
      name: z.string().optional(),
      number: z.string().optional(),
    })
    .optional(),
  voice_mail: z
    .object({
      access_user_id: z.string().optional(),
      delete: z.boolean().optional(),
      download: z.boolean().optional(),
      shared_id: z.string().optional(),
    })
    .optional(),
});

export const phoneUserSettingsErrorSchema = z.unknown();

export const deleteUserSettingDataSchema = z.object({
  path: z.object({
    settingType: z.string(),
    userId: z.string(),
  }),
  query: z.object({
    shared_id: z.string(),
  }),
});

export const deleteUserSettingResponseSchema = z.unknown();

export const deleteUserSettingErrorSchema = z.unknown();

export const updateUserSettingDataSchema = z.object({
  body: z
    .object({
      voice_mail: z
        .object({
          access_user_id: z.string().optional(),
          delete: z.boolean().optional(),
          download: z.boolean().optional(),
          shared_id: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  path: z.object({
    settingType: z.string(),
    userId: z.string(),
  }),
});

export const updateUserSettingResponseSchema = z.unknown();

export const updateUserSettingErrorSchema = z.union([z.record(z.unknown()), z.unknown()]);

export const addUserSettingDataSchema = z.object({
  body: z
    .object({
      voice_mail: z
        .object({
          access_user_id: z.string().optional(),
          delete: z.boolean().optional(),
          download: z.boolean().optional(),
        })
        .optional(),
    })
    .optional(),
  path: z.object({
    settingType: z.string(),
    userId: z.string(),
  }),
});

export const addUserSettingResponseSchema = z.object({
  voice_mail: z
    .object({
      access_user_id: z.string().optional(),
      delete: z.boolean().optional(),
      download: z.boolean().optional(),
      shared_id: z.string().optional(),
    })
    .optional(),
});

export const addUserSettingErrorSchema = z.unknown();

export const phoneUserVoiceMailsDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z.object({
    from: z.string().optional(),
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    status: z.union([z.literal('all'), z.literal('read'), z.literal('unread')]).optional(),
    to: z.string(),
  }),
});

export const phoneUserVoiceMailsResponseSchema = z.object({
  from: z.string().optional(),
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_size: z.number().optional(),
  to: z.string().optional(),
  total_records: z.number().optional(),
  voice_mails: z
    .array(
      z.object({
        callee_name: z.string().optional(),
        callee_number: z.string().optional(),
        callee_number_type: z.string().optional(),
        caller_name: z.string().optional(),
        caller_number: z.string().optional(),
        caller_number_type: z.string().optional(),
        date_time: z.string().optional(),
        download_url: z.string().optional(),
        duration: z.string().optional(),
        id: z.string().optional(),
        status: z.union([z.literal('read'), z.literal('unread')]).optional(),
      }),
    )
    .optional(),
});

export const phoneUserVoiceMailsErrorSchema = z.unknown();

export const deleteVoicemailDataSchema = z.object({
  path: z.object({
    voicemailId: z.string(),
  }),
});

export const deleteVoicemailResponseSchema = z.unknown();

export const deleteVoicemailErrorSchema = z.unknown();

export const reportSignInSignOutActivitiesDataSchema = z.object({
  query: z
    .object({
      from: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      to: z.string().optional(),
    })
    .optional(),
});

export const reportSignInSignOutActivitiesResponseSchema = z.object({
  activity_logs: z
    .array(
      z.object({
        client_type: z.string().optional(),
        email: z.string().optional(),
        ip_address: z.string().optional(),
        time: z.string().optional(),
        type: z.string().optional(),
        version: z.string().optional(),
      }),
    )
    .optional(),
  from: z.string().optional(),
  next_page_token: z.string().optional(),
  page_size: z.string().optional(),
  to: z.string().optional(),
});

export const reportSignInSignOutActivitiesErrorSchema = z.unknown();

export const reportCloudRecordingDataSchema = z.object({
  query: z.object({
    from: z.string(),
    to: z.string(),
  }),
});

export const reportCloudRecordingResponseSchema = z
  .object({
    from: z.string().optional(),
    to: z.string().optional(),
  })
  .and(
    z.object({
      cloud_recording_storage: z
        .array(
          z.object({
            date: z.string().optional(),
            free_usage: z.string().optional(),
            plan_usage: z.string().optional(),
            usage: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const reportCloudRecordingErrorSchema = z.unknown();

export const reportDailyDataSchema = z.object({
  query: z
    .object({
      month: z.number().optional(),
      year: z.number().optional(),
    })
    .optional(),
});

export const reportDailyResponseSchema = z.object({
  dates: z
    .array(
      z.object({
        date: z.string().optional(),
        meeting_minutes: z.number().optional(),
        meetings: z.number().optional(),
        new_users: z.number().optional(),
        participants: z.number().optional(),
      }),
    )
    .optional(),
  month: z.number().optional(),
  year: z.number().optional(),
});

export const reportDailyErrorSchema = z.unknown();

export const reportMeetingDetailsDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
});

export const reportMeetingDetailsResponseSchema = z.object({
  custom_keys: z
    .array(
      z.object({
        key: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  dept: z.string().optional(),
  duration: z.number().optional(),
  end_time: z.string().optional(),
  id: z.number().optional(),
  participants_count: z.number().optional(),
  start_time: z.string().optional(),
  topic: z.string().optional(),
  total_minutes: z.number().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.number().optional(),
  user_email: z.string().optional(),
  user_name: z.string().optional(),
  uuid: z.string().optional(),
});

export const reportMeetingDetailsErrorSchema = z.unknown();

export const reportMeetingParticipantsDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
  query: z
    .object({
      include_fields: z.literal('registrant_id').optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const reportMeetingParticipantsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      participants: z
        .array(
          z.object({
            customer_key: z.string().optional(),
            duration: z.number().optional(),
            failover: z.boolean().optional(),
            id: z.string().optional(),
            join_time: z.string().optional(),
            leave_time: z.string().optional(),
            name: z.string().optional(),
            registrant_id: z.string().optional(),
            user_email: z.string().optional(),
            user_id: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const reportMeetingParticipantsErrorSchema = z.unknown();

export const reportMeetingPollsDataSchema = z.object({
  path: z.object({
    meetingId: z.string(),
  }),
});

export const reportMeetingPollsResponseSchema = z.object({
  id: z.number().optional(),
  questions: z
    .array(
      z.object({
        email: z.string().optional(),
        name: z.string().optional(),
        question_details: z
          .array(
            z.object({
              answer: z.string().optional(),
              date_time: z.string().optional(),
              polling_id: z.string().optional(),
              question: z.string().optional(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
  start_time: z.string().optional(),
  uuid: z.string().optional(),
});

export const reportMeetingPollsErrorSchema = z.unknown();

export const reportOperationLogsDataSchema = z.object({
  query: z.object({
    category_type: z
      .union([
        z.literal('all'),
        z.literal('user'),
        z.literal('user_settings'),
        z.literal('account'),
        z.literal('billing'),
        z.literal('im'),
        z.literal('recording'),
        z.literal('phone_contacts'),
        z.literal('webinar'),
        z.literal('sub_account'),
        z.literal('role'),
        z.literal('zoom_rooms'),
      ])
      .optional(),
    from: z.string(),
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    to: z.string(),
  }),
});

export const reportOperationLogsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
  })
  .and(
    z.object({
      operation_logs: z
        .array(
          z.object({
            action: z.string().optional(),
            category_type: z.string().optional(),
            operation_detail: z.string().optional(),
            operator: z.string().optional(),
            time: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const reportOperationLogsErrorSchema = z.unknown();

export const reportTelephoneDataSchema = z.object({
  query: z.object({
    from: z.string(),
    next_page_token: z.string().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    to: z.string(),
    type: z.union([z.literal(1), z.literal(3)]).optional(),
  }),
});

export const reportTelephoneResponseSchema = z
  .object({
    from: z.string().optional(),
    next_page_token: z.number().optional(),
    page_count: z.number().optional(),
    page_size: z.number().optional(),
    to: z.string().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      telephony_usage: z
        .array(
          z.object({
            call_in_number: z.string().optional(),
            country_name: z.string().optional(),
            dept: z.string().optional(),
            duration: z.number().optional(),
            end_time: z.string().optional(),
            host_email: z.string().optional(),
            host_id: z.string().optional(),
            host_name: z.string().optional(),
            meeting_id: z.number().optional(),
            meeting_type: z.string().optional(),
            phone_number: z.string().optional(),
            rate: z.number().optional(),
            signaled_number: z.string().optional(),
            start_time: z.string().optional(),
            total: z.number().optional(),
            type: z
              .union([
                z.literal('toll-free'),
                z.literal('call-out'),
                z.literal('call-in'),
                z.literal('US toll-number'),
                z.literal('global toll-number'),
                z.literal('premium'),
                z.literal('premium call-in'),
              ])
              .optional(),
            uuid: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const reportTelephoneErrorSchema = z.unknown();

export const reportUsersDataSchema = z.object({
  query: z.object({
    from: z.string(),
    next_page_token: z.string().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    to: z.string(),
    type: z.union([z.literal('active'), z.literal('inactive')]).optional(),
  }),
});

export const reportUsersResponseSchema = z
  .object({
    from: z.string().optional(),
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    to: z.string().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      total_meeting_minutes: z.number().optional(),
      total_meetings: z.number().optional(),
      total_participants: z.number().optional(),
      users: z
        .array(
          z.object({
            custom_attributes: z
              .object({
                key: z.string().optional(),
                name: z.string().optional(),
                value: z.string().optional(),
              })
              .optional(),
            dept: z.string().optional(),
            email: z.string().optional(),
            id: z.string().optional(),
            meeting_minutes: z.number().optional(),
            meetings: z.number().optional(),
            participants: z.number().optional(),
            type: z.number().optional(),
            user_name: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const reportUsersErrorSchema = z.unknown();

export const reportMeetingsDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z.object({
    from: z.string(),
    next_page_token: z.string().optional(),
    page_size: z.number().optional(),
    to: z.string(),
    type: z.union([z.literal('past'), z.literal('pastOne')]).optional(),
  }),
});

export const reportMeetingsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      from: z.string().optional(),
      meetings: z
        .array(
          z.object({
            custom_keys: z
              .array(
                z.object({
                  key: z.string().optional(),
                  value: z.string().optional(),
                }),
              )
              .optional(),
            duration: z.number().optional(),
            end_time: z.string().optional(),
            id: z.number().optional(),
            participants_count: z.number().optional(),
            source: z.string().optional(),
            start_time: z.string().optional(),
            topic: z.string().optional(),
            total_minutes: z.number().optional(),
            type: z.number().optional(),
            user_email: z.string().optional(),
            user_name: z.string().optional(),
            uuid: z.string().optional(),
          }),
        )
        .optional(),
      next_page_token: z.string().optional(),
      to: z.string().optional(),
    }),
  );

export const reportMeetingsErrorSchema = z.unknown();

export const reportWebinarDetailsDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
});

export const reportWebinarDetailsResponseSchema = z.object({
  custom_keys: z
    .array(
      z.object({
        key: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  dept: z.string().optional(),
  duration: z.number().optional(),
  end_time: z.string().optional(),
  id: z.number().optional(),
  participants_count: z.number().optional(),
  start_time: z.string().optional(),
  topic: z.string().optional(),
  total_minutes: z.number().optional(),
  tracking_fields: z
    .array(
      z.object({
        field: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  type: z.number().optional(),
  user_email: z.string().optional(),
  user_name: z.string().optional(),
  uuid: z.string().optional(),
});

export const reportWebinarDetailsErrorSchema = z.unknown();

export const reportWebinarParticipantsDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
  query: z
    .object({
      include_fields: z.literal('registrant_id').optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const reportWebinarParticipantsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      participants: z
        .array(
          z.object({
            customer_key: z.string().optional(),
            duration: z.number().optional(),
            failover: z.boolean().optional(),
            id: z.string().optional(),
            join_time: z.string().optional(),
            leave_time: z.string().optional(),
            name: z.string().optional(),
            user_email: z.string().optional(),
            user_id: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const reportWebinarParticipantsErrorSchema = z.unknown();

export const reportWebinarPollsDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
});

export const reportWebinarPollsResponseSchema = z.object({
  id: z.number().optional(),
  questions: z
    .array(
      z.object({
        email: z.string().optional(),
        name: z.string().optional(),
        question_details: z
          .array(
            z.object({
              answer: z.string().optional(),
              date_time: z.string().optional(),
              polling_id: z.string().optional(),
              question: z.string().optional(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
  start_time: z.string().optional(),
  uuid: z.string().optional(),
});

export const reportWebinarPollsErrorSchema = z.unknown();

export const reportWebinarQaDataSchema = z.object({
  path: z.object({
    webinarId: z.string(),
  }),
});

export const reportWebinarQaResponseSchema = z.object({
  id: z.number().optional(),
  questions: z
    .array(
      z.object({
        email: z.string().optional(),
        name: z.string().optional(),
        question_details: z
          .array(
            z.object({
              answer: z.string().optional(),
              question: z.string().optional(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
  start_time: z.string().optional(),
  uuid: z.string().optional(),
});

export const reportWebinarQaErrorSchema = z.unknown();

export const rolesResponseSchema = z.object({
  roles: z
    .array(
      z.object({
        description: z.string().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
        total_members: z.number().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const rolesErrorSchema = z.unknown();

export const createRoleDataSchema = z.object({
  body: z
    .object({
      description: z.string().optional(),
      name: z.string().optional(),
      privileges: z.array(z.string()).optional(),
    })
    .optional(),
});

export const createRoleResponseSchema = z.union([
  z.unknown(),
  z.object({
    description: z.string().optional(),
    id: z.string().optional(),
    name: z.string().optional(),
    privileges: z.array(z.string()).optional(),
    total_members: z.number().optional(),
  }),
]);

export const createRoleErrorSchema = z.unknown();

export const deleteRoleDataSchema = z.object({
  path: z.object({
    roleId: z.string(),
  }),
});

export const deleteRoleResponseSchema = z.union([z.unknown(), z.record(z.unknown())]);

export const deleteRoleErrorSchema = z.unknown();

export const getRoleInformationDataSchema = z.object({
  path: z.object({
    roleId: z.string(),
  }),
});

export const getRoleInformationResponseSchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  privileges: z.array(z.string()).optional(),
  sub_account_privileges: z
    .object({
      second_level: z.number().optional(),
    })
    .optional(),
  total_members: z.number().optional(),
});

export const getRoleInformationErrorSchema = z.unknown();

export const updateRoleDataSchema = z.object({
  body: z
    .object({
      description: z.string().optional(),
      id: z.string().optional(),
      name: z.string().optional(),
      privileges: z.array(z.string()).optional(),
      sub_account_privileges: z
        .object({
          second_level: z.number().optional(),
        })
        .optional(),
      total_members: z.number().optional(),
    })
    .optional(),
  path: z.object({
    roleId: z.string(),
  }),
});

export const updateRoleResponseSchema = z.union([z.unknown(), z.any()]);

export const updateRoleErrorSchema = z.unknown();

export const roleMembersDataSchema = z.object({
  path: z.object({
    roleId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_count: z.string().optional(),
      page_number: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const roleMembersResponseSchema = z.object({
  members: z
    .array(
      z.object({
        department: z.string().optional(),
        email: z.string().optional(),
        first_name: z.string().optional(),
        id: z.string().optional(),
        last_name: z.string().optional(),
        type: z.number().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_number: z.number().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
});

export const roleMembersErrorSchema = z.unknown();

export const addRoleMembersDataSchema = z.object({
  body: z.object({
    members: z
      .array(
        z.object({
          email: z.string().optional(),
          id: z.string().optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    roleId: z.string(),
  }),
});

export const addRoleMembersResponseSchema = z.object({
  add_at: z.string().optional(),
  ids: z.string().optional(),
});

export const addRoleMembersErrorSchema = z.unknown();

export const roleMemberDeleteDataSchema = z.object({
  path: z.object({
    memberId: z.string(),
    roleId: z.string(),
  }),
});

export const roleMemberDeleteResponseSchema = z.any();

export const roleMemberDeleteErrorSchema = z.unknown();

export const listZoomRoomsDataSchema = z.object({
  query: z
    .object({
      location_id: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      status: z
        .union([z.literal('Offline'), z.literal('Available'), z.literal('InMeeting'), z.literal('UnderConstruction')])
        .optional(),
      type: z
        .union([z.literal('ZoomRoom'), z.literal('SchedulingDisplayOnly'), z.literal('DigitalSignageOnly')])
        .optional(),
      unassigned_rooms: z.boolean().optional(),
    })
    .optional(),
});

export const listZoomRoomsResponseSchema = z.object({
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
  rooms: z
    .array(
      z.object({
        activation_code: z.string().optional(),
        id: z.string().optional(),
        location_id: z.string().optional(),
        name: z.string().optional(),
        room_id: z.string().optional(),
        status: z
          .union([z.literal('Offline'), z.literal('Available'), z.literal('InMeeting'), z.literal('UnderConstruction')])
          .optional(),
      }),
    )
    .optional(),
});

export const listZoomRoomsErrorSchema = z.unknown();

export const addAroomDataSchema = z.object({
  body: z
    .object({
      location_id: z.string().optional(),
      name: z.string(),
      type: z.union([z.literal('ZoomRoom'), z.literal('SchedulingDisplayOnly'), z.literal('DigitalSignageOnly')]),
    })
    .optional(),
});

export const addAroomResponseSchema = z.object({
  id: z.string().optional(),
  location_id: z.string().optional(),
  name: z.string().optional(),
  room_id: z.string().optional(),
  type: z
    .union([z.literal('ZoomRoom'), z.literal('SchedulingDisplayOnly'), z.literal('DigitalSignageOnly')])
    .optional(),
});

export const addAroomErrorSchema = z.unknown();

export const getZrAccountProfileResponseSchema = z.object({
  basic: z
    .object({
      required_code_to_ext: z.boolean().optional(),
      room_passcode: z.string().optional(),
      support_email: z.string().optional(),
      support_phone: z.string().optional(),
    })
    .optional(),
});

export const getZrAccountProfileErrorSchema = z.unknown();

export const updateZrAccProfileDataSchema = z.object({
  body: z
    .object({
      basic: z
        .object({
          required_code_to_ext: z.boolean().optional(),
          room_passcode: z.string().optional(),
          support_email: z.string().optional(),
          support_phone: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
});

export const updateZrAccProfileResponseSchema = z.record(z.unknown());

export const updateZrAccProfileErrorSchema = z.unknown();

export const getZrAccountSettingsDataSchema = z.object({
  query: z.object({
    setting_type: z.union([z.literal('meeting'), z.literal('alert')]),
  }),
});

export const getZrAccountSettingsResponseSchema = z.union([
  z.object({
    zoom_rooms: z
      .object({
        allow_multiple_content_sharing: z.boolean().optional(),
        audio_device_daily_auto_test: z.boolean().optional(),
        auto_direct_sharing: z.boolean().optional(),
        auto_start_scheduled_meeting: z.boolean().optional(),
        auto_stop_scheduled_meeting: z.boolean().optional(),
        count_attendees_number_in_room: z.boolean().optional(),
        display_feedback_survey: z.boolean().optional(),
        display_meeting_list: z.boolean().optional(),
        display_top_banner: z.boolean().optional(),
        email_address_prompt_before_recording: z.boolean().optional(),
        encrypt_shared_screen_content: z.boolean().optional(),
        hide_id_for_private_meeting: z.boolean().optional(),
        make_room_alternative_host: z.boolean().optional(),
        secure_connection_channel: z.boolean().optional(),
        send_whiteboard_to_internal_contact_only: z.boolean().optional(),
        show_alert_before_meeting: z.boolean().optional(),
        show_call_history_in_room: z.boolean().optional(),
        show_contact_list_on_controller: z.boolean().optional(),
        show_non_video_participants: z.boolean().optional(),
        start_airplay_manually: z.boolean().optional(),
        start_airplay_mirroring: z.boolean().optional(),
        support_join_3rd_party_meeting: z.boolean().optional(),
        transform_meeting_to_private: z.boolean().optional(),
        upcoming_meeting_alert: z.boolean().optional(),
        weekly_system_restart: z.boolean().optional(),
      })
      .optional(),
  }),
  z.object({
    client_alert: z
      .object({
        detect_bluetooth_microphone_error_alert: z.boolean().optional(),
        detect_bluetooth_speaker_error_alert: z.boolean().optional(),
        detect_camera_error_alert: z.boolean().optional(),
        detect_microphone_error_alert: z.boolean().optional(),
        detect_speaker_error_alert: z.boolean().optional(),
      })
      .optional(),
    digital_signage: z
      .object({
        banner: z
          .object({
            banner_room_name: z.boolean().optional(),
            banner_sharing_key: z.boolean().optional(),
            banner_time: z.boolean().optional(),
          })
          .optional(),
        display_period: z
          .object({
            start_displaying_content: z.number().optional(),
            stop_displaying_content: z.number().optional(),
          })
          .optional(),
        enable_digital_signage: z.boolean().optional(),
        layout: z.string().optional(),
        mute: z.boolean().optional(),
        play_list: z
          .array(
            z.object({
              action: z.union([z.literal('add'), z.literal('update'), z.literal('delete')]).optional(),
              contents: z
                .array(
                  z.object({
                    content_id: z.string().optional(),
                    duration: z.number().optional(),
                    id: z.string().optional(),
                    name: z.string().optional(),
                    order: z.number().optional(),
                  }),
                )
                .optional(),
              end_time: z.string().optional(),
              id: z.string().optional(),
              name: z.string().optional(),
              start_time: z.string().optional(),
            }),
          )
          .optional(),
      })
      .optional(),
    notification: z
      .object({
        audio_meet_usability_threshold: z.boolean().optional(),
        audio_not_meet_usability_threshold: z.boolean().optional(),
        battery_is_charging: z.boolean().optional(),
        battery_low_and_not_charging: z.boolean().optional(),
        battery_percentage: z.string().optional(),
        controller_scheduling_disconnected: z.boolean().optional(),
        controller_scheduling_reconnected: z.boolean().optional(),
        cpu_usage_high_detected: z.boolean().optional(),
        mic_speaker_camera_disconnected: z.boolean().optional(),
        mic_speaker_camera_reconnected: z.boolean().optional(),
        network_unstable_detected: z.boolean().optional(),
        sip_registration_failed: z.boolean().optional(),
        sip_registration_re_enabled: z.boolean().optional(),
        zoom_room_come_back_online: z.boolean().optional(),
        zoom_room_display_disconnected: z.boolean().optional(),
        zoom_room_offline: z.boolean().optional(),
      })
      .optional(),
  }),
]);

export const getZrAccountSettingsErrorSchema = z.unknown();

export const updateZoomRoomAccSettingsDataSchema = z.object({
  body: z
    .union([
      z.object({
        zoom_rooms: z
          .object({
            allow_multiple_content_sharing: z.boolean().optional(),
            audio_device_daily_auto_test: z.boolean().optional(),
            auto_direct_sharing: z.boolean().optional(),
            auto_start_scheduled_meeting: z.boolean().optional(),
            auto_stop_scheduled_meeting: z.boolean().optional(),
            count_attendees_number_in_room: z.boolean().optional(),
            display_feedback_survey: z.boolean().optional(),
            display_meeting_list: z.boolean().optional(),
            display_top_banner: z.boolean().optional(),
            email_address_prompt_before_recording: z.boolean().optional(),
            encrypt_shared_screen_content: z.boolean().optional(),
            hide_id_for_private_meeting: z.boolean().optional(),
            make_room_alternative_host: z.boolean().optional(),
            secure_connection_channel: z.boolean().optional(),
            send_whiteboard_to_internal_contact_only: z.boolean().optional(),
            show_alert_before_meeting: z.boolean().optional(),
            show_call_history_in_room: z.boolean().optional(),
            show_contact_list_on_controller: z.boolean().optional(),
            show_non_video_participants: z.boolean().optional(),
            start_airplay_manually: z.boolean().optional(),
            support_join_3rd_party_meeting: z.boolean().optional(),
            transform_meeting_to_private: z.boolean().optional(),
            upcoming_meeting_alert: z.boolean().optional(),
            weekly_system_restart: z.boolean().optional(),
          })
          .optional(),
      }),
      z.object({
        client_alert: z
          .object({
            detect_bluetooth_microphone_error_alert: z.boolean().optional(),
            detect_bluetooth_speaker_error_alert: z.boolean().optional(),
            detect_camera_error_alert: z.boolean().optional(),
            detect_microphone_error_alert: z.boolean().optional(),
            detect_speaker_error_alert: z.boolean().optional(),
          })
          .optional(),
        digital_signage: z
          .object({
            banner: z
              .object({
                banner_room_name: z.boolean().optional(),
                banner_sharing_key: z.boolean().optional(),
                banner_time: z.boolean().optional(),
              })
              .optional(),
            display_period: z
              .object({
                start_displaying_content: z.number().optional(),
                stop_displaying_content: z.number().optional(),
              })
              .optional(),
            enable_digital_signage: z.boolean().optional(),
            layout: z.string().optional(),
            mute: z.boolean().optional(),
            play_list: z
              .array(
                z.object({
                  action: z.union([z.literal('add'), z.literal('update'), z.literal('delete')]).optional(),
                  contents: z
                    .array(
                      z.object({
                        action: z.string().optional(),
                        content_id: z.string().optional(),
                        duration: z.number().optional(),
                        id: z.string().optional(),
                        name: z.string().optional(),
                        order: z.number().optional(),
                      }),
                    )
                    .optional(),
                  end_time: z.string().optional(),
                  id: z.string().optional(),
                  name: z.string().optional(),
                  start_time: z.string().optional(),
                }),
              )
              .optional(),
          })
          .optional(),
        notification: z
          .object({
            audio_meet_usability_threshold: z.boolean().optional(),
            audio_not_meet_usability_threshold: z.boolean().optional(),
            battery_is_charging: z.boolean().optional(),
            battery_low_and_not_charging: z.boolean().optional(),
            battery_percentage: z.string().optional(),
            controller_scheduling_disconnected: z.boolean().optional(),
            controller_scheduling_reconnected: z.boolean().optional(),
            cpu_usage_high_detected: z.boolean().optional(),
            mic_speaker_camera_disconnected: z.boolean().optional(),
            mic_speaker_camera_reconnected: z.boolean().optional(),
            network_stable_detected: z.boolean().optional(),
            network_unstable_detected: z.boolean().optional(),
            sip_registration_failed: z.boolean().optional(),
            sip_registration_re_enabled: z.boolean().optional(),
            zoom_room_come_back_online: z.boolean().optional(),
            zoom_room_display_disconnected: z.boolean().optional(),
            zoom_room_offline: z.boolean().optional(),
          })
          .optional(),
      }),
    ])
    .optional(),
  query: z.object({
    setting_type: z.string(),
  }),
});

export const updateZoomRoomAccSettingsResponseSchema = z.record(z.unknown());

export const updateZoomRoomAccSettingsErrorSchema = z.unknown();

export const listDigitalSignageContentDataSchema = z.object({
  query: z
    .object({
      folder_id: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const listDigitalSignageContentResponseSchema = z.object({
  contents: z
    .array(
      z.object({
        id: z.string().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
});

export const listDigitalSignageContentErrorSchema = z.unknown();

export const manageE911SignageDataSchema = z.object({
  body: z
    .union([
      z.object({
        method: z.literal('zoomroom.emergency_alert_displayed').optional(),
        params: z
          .object({
            content: z.string().optional(),
            target_ids: z.array(z.string()).optional(),
            target_type: z.union([z.literal('account'), z.literal('location'), z.literal('room')]).optional(),
          })
          .optional(),
      }),
      z.object({
        method: z.literal('zoomroom.emergency_alert_removed').optional(),
        params: z
          .object({
            event_id: z.string().optional(),
            target_ids: z.array(z.string()).optional(),
            target_type: z.union([z.literal('account'), z.literal('location'), z.literal('room')]).optional(),
          })
          .optional(),
      }),
    ])
    .optional(),
});

export const manageE911SignageResponseSchema = z.object({
  event_id: z.string().optional(),
});

export const manageE911SignageErrorSchema = z.unknown();

export const listZrLocationsDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      parent_location_id: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const listZrLocationsResponseSchema = z.object({
  locations: z
    .array(
      z.object({
        id: z.string().optional(),
        name: z.string().optional(),
        parent_location_id: z.string().optional(),
        type: z
          .union([
            z.literal('country'),
            z.literal('states'),
            z.literal('city'),
            z.literal('campus'),
            z.literal('building'),
            z.literal('floor'),
          ])
          .optional(),
      }),
    )
    .optional(),
  next_page_token: z.string().optional(),
  page_size: z.number().optional(),
});

export const listZrLocationsErrorSchema = z.unknown();

export const addAzrLocationDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
      parent_location_id: z.string().optional(),
    })
    .optional(),
});

export const addAzrLocationResponseSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  parent_location_id: z.string().optional(),
  type: z
    .union([
      z.literal('country'),
      z.literal('states'),
      z.literal('city'),
      z.literal('campus'),
      z.literal('building'),
      z.literal('floor'),
    ])
    .optional(),
});

export const addAzrLocationErrorSchema = z.unknown();

export const getZrLocationStructureResponseSchema = z.object({
  structures: z.array(z.string()).optional(),
});

export const getZrLocationStructureErrorSchema = z.unknown();

export const updateZoomRoomsLocationStructureDataSchema = z.object({
  body: z
    .object({
      structures: z.array(z.string()).optional(),
    })
    .optional(),
});

export const updateZoomRoomsLocationStructureResponseSchema = z.unknown();

export const updateZoomRoomsLocationStructureErrorSchema = z.unknown();

export const getZrLocationProfileDataSchema = z.object({
  path: z.object({
    locationId: z.string(),
  }),
});

export const getZrLocationProfileResponseSchema = z.object({
  basic: z
    .object({
      address: z.string().optional(),
      'description ': z.string().optional(),
      name: z.string().optional(),
      required_code_to_ext: z.boolean().optional(),
      room_passcode: z.string().optional(),
      support_email: z.string().optional(),
      support_phone: z.string().optional(),
      timezone: z.string().optional(),
    })
    .optional(),
});

export const getZrLocationProfileErrorSchema = z.unknown();

export const updateZrLocationProfileDataSchema = z.object({
  body: z
    .object({
      basic: z
        .object({
          address: z.string().optional(),
          'description ': z.string().optional(),
          name: z.string().optional(),
          required_code_to_ext: z.boolean().optional(),
          room_passcode: z.string().optional(),
          support_email: z.string().optional(),
          support_phone: z.string().optional(),
          timezone: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  path: z.object({
    locationId: z.string(),
  }),
});

export const updateZrLocationProfileResponseSchema = z.unknown();

export const updateZrLocationProfileErrorSchema = z.unknown();

export const changeParentLocationDataSchema = z.object({
  body: z
    .object({
      parent_location_id: z.string().optional(),
    })
    .optional(),
  path: z.object({
    locationId: z.string(),
  }),
});

export const changeParentLocationResponseSchema = z.unknown();

export const changeParentLocationErrorSchema = z.unknown();

export const getZrLocationSettingsDataSchema = z.object({
  path: z.object({
    locationId: z.string(),
  }),
  query: z.object({
    setting_type: z.string(),
  }),
});

export const getZrLocationSettingsResponseSchema = z.union([
  z.object({
    meeting_security: z
      .object({
        encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
        end_to_end_encrypted_meetings: z.boolean().optional(),
      })
      .optional(),
    zoom_rooms: z
      .object({
        allow_multiple_content_sharing: z.boolean().optional(),
        audio_device_daily_auto_test: z.boolean().optional(),
        auto_accept_incoming_call_and_fecc: z.boolean().optional(),
        auto_direct_sharing: z.boolean().optional(),
        auto_start_scheduled_meeting: z.boolean().optional(),
        auto_stop_scheduled_meeting: z.boolean().optional(),
        count_attendees_number_in_room: z.boolean().optional(),
        display_feedback_survey: z.boolean().optional(),
        display_meeting_list: z.boolean().optional(),
        display_top_banner: z.boolean().optional(),
        encrypt_shared_screen_content: z.boolean().optional(),
        hide_id_for_private_meeting: z.boolean().optional(),
        hide_self_view: z.boolean().optional(),
        lock_speaker_volume_control: z.boolean().optional(),
        send_whiteboard_to_internal_contact_only: z.boolean().optional(),
        show_alert_before_meeting: z.boolean().optional(),
        show_call_history_in_room: z.boolean().optional(),
        show_contact_list_on_controller: z.boolean().optional(),
        show_non_video_participants: z.boolean().optional(),
        start_airplay_manually: z.boolean().optional(),
        start_airplay_mirroring: z.boolean().optional(),
        start_hdmi_content_share_manualy: z.boolean().optional(),
        support_join_3rd_party_meeting: z.boolean().optional(),
        transform_meeting_to_private: z.boolean().optional(),
        upcoming_meeting_alert: z.boolean().optional(),
        voice_commands: z.boolean().optional(),
        weekly_system_restart: z.boolean().optional(),
      })
      .optional(),
  }),
  z.object({
    client_alert: z
      .object({
        detect_bluetooth_microphone_error_alert: z.boolean().optional(),
        detect_bluetooth_speaker_error_alert: z.boolean().optional(),
        detect_camera_error_alert: z.boolean().optional(),
        detect_microphone_error_alert: z.boolean().optional(),
        detect_speaker_error_alert: z.boolean().optional(),
      })
      .optional(),
    digital_signage: z
      .object({
        banner: z
          .object({
            banner_room_name: z.boolean().optional(),
            banner_sharing_key: z.boolean().optional(),
            banner_time: z.boolean().optional(),
          })
          .optional(),
        display_period: z
          .object({
            start_displaying_content: z.number().optional(),
            stop_displaying_content: z.number().optional(),
          })
          .optional(),
        enable_digital_signage: z.boolean().optional(),
        layout: z.string().optional(),
        mute: z.boolean().optional(),
        play_list: z
          .array(
            z.object({
              action: z.union([z.literal('add'), z.literal('update'), z.literal('delete')]).optional(),
              contents: z
                .array(
                  z.object({
                    content_id: z.string().optional(),
                    duration: z.number().optional(),
                    id: z.string().optional(),
                    name: z.string().optional(),
                    order: z.number().optional(),
                  }),
                )
                .optional(),
              end_time: z.string().optional(),
              id: z.string().optional(),
              name: z.string().optional(),
              start_time: z.string().optional(),
            }),
          )
          .optional(),
      })
      .optional(),
    notification: z
      .object({
        audio_meet_usability_threshold: z.boolean().optional(),
        audio_not_meet_usability_threshold: z.boolean().optional(),
        battery_is_charging: z.boolean().optional(),
        battery_low_and_not_charging: z.boolean().optional(),
        battery_percentage: z.string().optional(),
        controller_scheduling_disconnected: z.boolean().optional(),
        controller_scheduling_reconnected: z.boolean().optional(),
        cpu_usage_high_detected: z.boolean().optional(),
        mic_speaker_camera_disconnected: z.boolean().optional(),
        mic_speaker_camera_reconnected: z.boolean().optional(),
        network_unstable_detected: z.boolean().optional(),
        sip_registration_failed: z.boolean().optional(),
        sip_registration_re_enabled: z.boolean().optional(),
        zoom_room_come_back_online: z.boolean().optional(),
        zoom_room_display_disconnected: z.boolean().optional(),
        zoom_room_offline: z.boolean().optional(),
      })
      .optional(),
  }),
]);

export const getZrLocationSettingsErrorSchema = z.unknown();

export const updateZrLocationSettingsDataSchema = z.object({
  body: z
    .union([
      z.object({
        meeting_security: z
          .object({
            encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
            end_to_end_encrypted_meetings: z.boolean().optional(),
          })
          .optional(),
        zoom_rooms: z
          .object({
            allow_multiple_content_sharing: z.boolean().optional(),
            audio_device_daily_auto_test: z.boolean().optional(),
            auto_accept_incoming_call_and_fecc: z.boolean().optional(),
            auto_direct_sharing: z.boolean().optional(),
            auto_start_scheduled_meeting: z.boolean().optional(),
            auto_stop_scheduled_meeting: z.boolean().optional(),
            count_attendees_number_in_room: z.boolean().optional(),
            display_feedback_survey: z.boolean().optional(),
            display_meeting_list: z.boolean().optional(),
            display_top_banner: z.boolean().optional(),
            encrypt_shared_screen_content: z.boolean().optional(),
            hide_id_for_private_meeting: z.boolean().optional(),
            hide_self_view: z.boolean().optional(),
            lock_speaker_volume_control: z.boolean().optional(),
            send_whiteboard_to_internal_contact_only: z.boolean().optional(),
            show_alert_before_meeting: z.boolean().optional(),
            show_call_history_in_room: z.boolean().optional(),
            show_contact_list_on_controller: z.boolean().optional(),
            show_non_video_participants: z.boolean().optional(),
            start_airplay_manually: z.boolean().optional(),
            start_airplay_mirroring: z.boolean().optional(),
            start_hdmi_content_share_manualy: z.boolean().optional(),
            support_join_3rd_party_meeting: z.boolean().optional(),
            transform_meeting_to_private: z.boolean().optional(),
            upcoming_meeting_alert: z.boolean().optional(),
            voice_commands: z.boolean().optional(),
            weekly_system_restart: z.boolean().optional(),
          })
          .optional(),
      }),
      z.object({
        client_alert: z
          .object({
            detect_bluetooth_microphone_error_alert: z.boolean().optional(),
            detect_bluetooth_speaker_error_alert: z.boolean().optional(),
            detect_camera_error_alert: z.boolean().optional(),
            detect_microphone_error_alert: z.boolean().optional(),
            detect_speaker_error_alert: z.boolean().optional(),
          })
          .optional(),
        digital_signage: z
          .object({
            banner: z
              .object({
                banner_room_name: z.boolean().optional(),
                banner_sharing_key: z.boolean().optional(),
                banner_time: z.boolean().optional(),
              })
              .optional(),
            display_period: z
              .object({
                start_displaying_content: z.number().optional(),
                stop_displaying_content: z.number().optional(),
              })
              .optional(),
            enable_digital_signage: z.boolean().optional(),
            layout: z.string().optional(),
            mute: z.boolean().optional(),
            play_list: z
              .array(
                z.object({
                  action: z.union([z.literal('add'), z.literal('update'), z.literal('delete')]).optional(),
                  contents: z
                    .array(
                      z.object({
                        action: z.string().optional(),
                        content_id: z.string().optional(),
                        duration: z.number().optional(),
                        id: z.string().optional(),
                        name: z.string().optional(),
                        order: z.number().optional(),
                      }),
                    )
                    .optional(),
                  end_time: z.string().optional(),
                  id: z.string().optional(),
                  name: z.string().optional(),
                  start_time: z.string().optional(),
                }),
              )
              .optional(),
          })
          .optional(),
        notification: z
          .object({
            audio_meet_usability_threshold: z.boolean().optional(),
            audio_not_meet_usability_threshold: z.boolean().optional(),
            battery_is_charging: z.boolean().optional(),
            battery_low_and_not_charging: z.boolean().optional(),
            battery_percentage: z.string().optional(),
            controller_scheduling_disconnected: z.boolean().optional(),
            controller_scheduling_reconnected: z.boolean().optional(),
            cpu_usage_high_detected: z.boolean().optional(),
            mic_speaker_camera_disconnected: z.boolean().optional(),
            mic_speaker_camera_reconnected: z.boolean().optional(),
            network_unstable_detected: z.boolean().optional(),
            sip_registration_failed: z.boolean().optional(),
            sip_registration_re_enabled: z.boolean().optional(),
            zoom_room_come_back_online: z.boolean().optional(),
            zoom_room_display_disconnected: z.boolean().optional(),
            zoom_room_offline: z.boolean().optional(),
          })
          .optional(),
      }),
    ])
    .optional(),
  path: z.object({
    locationId: z.string(),
  }),
  query: z.object({
    setting_type: z.string(),
  }),
});

export const updateZrLocationSettingsResponseSchema = z.unknown();

export const updateZrLocationSettingsErrorSchema = z.unknown();

export const checkInRoomsDataSchema = z.object({
  body: z
    .object({
      method: z.string().optional(),
      params: z
        .object({
          calendar_id: z.string().optional(),
          change_key: z.string().optional(),
          event_id: z.string(),
          resource_email: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const checkInRoomsResponseSchema = z.unknown();

export const checkInRoomsErrorSchema = z.unknown();

export const deleteAzoomRoomDataSchema = z.object({
  path: z.object({
    roomId: z.string(),
  }),
});

export const deleteAzoomRoomResponseSchema = z.record(z.unknown());

export const deleteAzoomRoomErrorSchema = z.unknown();

export const getZrProfileDataSchema = z.object({
  path: z.object({
    roomId: z.string(),
  }),
});

export const getZrProfileResponseSchema = z.object({
  basic: z
    .object({
      activation_code: z.string().optional(),
      hide_room_in_contacts: z.boolean().optional(),
      name: z.string().optional(),
      required_code_to_ext: z.boolean().optional(),
      room_passcode: z.string().optional(),
      support_email: z.string().optional(),
      support_phone: z.string().optional(),
    })
    .optional(),
});

export const getZrProfileErrorSchema = z.unknown();

export const updateRoomProfileDataSchema = z.object({
  body: z
    .object({
      basic: z
        .object({
          hide_room_in_contacts: z.boolean().optional(),
          name: z.string().optional(),
          required_code_to_ext: z.boolean().optional(),
          room_passcode: z.string().optional(),
          support_email: z.string().optional(),
          support_phone: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  path: z.object({
    roomId: z.string(),
  }),
});

export const updateRoomProfileResponseSchema = z.record(z.unknown());

export const updateRoomProfileErrorSchema = z.unknown();

export const listZrDevicesDataSchema = z.object({
  path: z.object({
    roomId: z.string(),
  }),
});

export const listZrDevicesResponseSchema = z.object({
  devices: z
    .array(
      z.object({
        app_version: z.string().optional(),
        device_system: z.string().optional(),
        device_type: z
          .union([
            z.literal('Zoom Rooms Computer'),
            z.literal('Controller'),
            z.literal('Scheduling Display'),
            z.literal('Zoom Rooms Control System'),
            z.literal('Companion Whiteboard'),
          ])
          .optional(),
        id: z.string().optional(),
        room_name: z.string().optional(),
        status: z.union([z.literal('Online'), z.literal('Offline')]).optional(),
      }),
    )
    .optional(),
});

export const listZrDevicesErrorSchema = z.unknown();

export const changeZoomRoomsAppVersionDataSchema = z.object({
  body: z
    .object({
      action: z.union([z.literal('upgrade'), z.literal('downgrade'), z.literal('cancel')]).optional(),
    })
    .optional(),
  path: z.object({
    deviceId: z.string(),
    roomId: z.string(),
  }),
});

export const changeZoomRoomsAppVersionResponseSchema = z.unknown();

export const changeZoomRoomsAppVersionErrorSchema = z.unknown();

export const changeZrLocationDataSchema = z.object({
  body: z
    .object({
      location_id: z.string().optional(),
    })
    .optional(),
  path: z.object({
    roomId: z.string(),
  }),
});

export const changeZrLocationResponseSchema = z.unknown();

export const changeZrLocationErrorSchema = z.unknown();

export const getZrSettingsDataSchema = z.object({
  path: z.object({
    roomId: z.string(),
  }),
  query: z.object({
    setting_type: z.string(),
  }),
});

export const getZrSettingsResponseSchema = z.union([
  z.object({
    meeting_security: z
      .object({
        encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
        end_to_end_encrypted_meetings: z.boolean().optional(),
      })
      .optional(),
    zoom_rooms: z
      .object({
        allow_multiple_content_sharing: z.boolean().optional(),
        audio_device_daily_auto_test: z.boolean().optional(),
        auto_direct_sharing: z.boolean().optional(),
        auto_start_scheduled_meeting: z.boolean().optional(),
        auto_stop_scheduled_meeting: z.boolean().optional(),
        count_attendees_number_in_room: z.boolean().optional(),
        display_feedback_survey: z.boolean().optional(),
        display_meeting_list: z.boolean().optional(),
        display_top_banner: z.boolean().optional(),
        encrypt_shared_screen_content: z.boolean().optional(),
        hide_id_for_private_meeting: z.boolean().optional(),
        hide_share_instruction: z.boolean().optional(),
        send_whiteboard_to_internal_contact_only: z.boolean().optional(),
        show_alert_before_meeting: z.boolean().optional(),
        show_call_history_in_room: z.boolean().optional(),
        show_contact_list_on_controller: z.boolean().optional(),
        show_non_video_participants: z.boolean().optional(),
        start_airplay_manually: z.boolean().optional(),
        start_airplay_mirroring: z.boolean().optional(),
        support_join_3rd_party_meeting: z.boolean().optional(),
        transform_meeting_to_private: z.boolean().optional(),
        upcoming_meeting_alert: z.boolean().optional(),
        weekly_system_restart: z.boolean().optional(),
      })
      .optional(),
  }),
  z.object({
    client_alert: z
      .object({
        detect_bluetooth_microphone_error_alert: z.boolean().optional(),
        detect_bluetooth_speaker_error_alert: z.boolean().optional(),
        detect_camera_error_alert: z.boolean().optional(),
        detect_microphone_error_alert: z.boolean().optional(),
        detect_speaker_error_alert: z.boolean().optional(),
      })
      .optional(),
    digital_signage: z
      .object({
        banner: z
          .object({
            banner_room_name: z.boolean().optional(),
            banner_sharing_key: z.boolean().optional(),
            banner_time: z.boolean().optional(),
          })
          .optional(),
        display_period: z
          .object({
            start_displaying_content: z.number().optional(),
            stop_displaying_content: z.number().optional(),
          })
          .optional(),
        enable_digital_signage: z.boolean().optional(),
        layout: z.string().optional(),
        mute: z.boolean().optional(),
        play_list: z
          .array(
            z.object({
              action: z.union([z.literal('add'), z.literal('update'), z.literal('delete')]).optional(),
              contents: z
                .array(
                  z.object({
                    content_id: z.string().optional(),
                    duration: z.number().optional(),
                    id: z.string().optional(),
                    name: z.string().optional(),
                    order: z.number().optional(),
                  }),
                )
                .optional(),
              end_time: z.string().optional(),
              id: z.string().optional(),
              name: z.string().optional(),
              start_time: z.string().optional(),
            }),
          )
          .optional(),
      })
      .optional(),
    notification: z
      .object({
        audio_meet_usability_threshold: z.boolean().optional(),
        audio_not_meet_usability_threshold: z.boolean().optional(),
        battery_is_charging: z.boolean().optional(),
        battery_low_and_not_charging: z.boolean().optional(),
        battery_percentage: z.string().optional(),
        controller_scheduling_disconnected: z.boolean().optional(),
        controller_scheduling_reconnected: z.boolean().optional(),
        cpu_usage_high_detected: z.boolean().optional(),
        mic_speaker_camera_disconnected: z.boolean().optional(),
        mic_speaker_camera_reconnected: z.boolean().optional(),
        network_unstable_detected: z.boolean().optional(),
        sip_registration_failed: z.boolean().optional(),
        sip_registration_re_enabled: z.boolean().optional(),
        zoom_room_come_back_online: z.boolean().optional(),
        zoom_room_display_disconnected: z.boolean().optional(),
        zoom_room_offline: z.boolean().optional(),
      })
      .optional(),
  }),
]);

export const getZrSettingsErrorSchema = z.unknown();

export const updateZrSettingsDataSchema = z.object({
  body: z
    .union([
      z.object({
        meeting_security: z
          .object({
            encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
            end_to_end_encrypted_meetings: z.boolean().optional(),
          })
          .optional(),
        zoom_rooms: z
          .object({
            allow_multiple_content_sharing: z.boolean().optional(),
            audio_device_daily_auto_test: z.boolean().optional(),
            auto_direct_sharing: z.boolean().optional(),
            auto_start_scheduled_meeting: z.boolean().optional(),
            auto_stop_scheduled_meeting: z.boolean().optional(),
            count_attendees_number_in_room: z.boolean().optional(),
            display_feedback_survey: z.boolean().optional(),
            display_meeting_list: z.boolean().optional(),
            display_top_banner: z.boolean().optional(),
            encrypt_shared_screen_content: z.boolean().optional(),
            hide_id_for_private_meeting: z.boolean().optional(),
            hide_share_instruction: z.boolean().optional(),
            send_whiteboard_to_internal_contact_only: z.boolean().optional(),
            show_alert_before_meeting: z.boolean().optional(),
            show_call_history_in_room: z.boolean().optional(),
            show_contact_list_on_controller: z.boolean().optional(),
            show_non_video_participants: z.boolean().optional(),
            start_airplay_manually: z.boolean().optional(),
            start_airplay_mirroring: z.boolean().optional(),
            support_join_3rd_party_meeting: z.boolean().optional(),
            transform_meeting_to_private: z.boolean().optional(),
            upcoming_meeting_alert: z.boolean().optional(),
            weekly_system_restart: z.boolean().optional(),
          })
          .optional(),
      }),
      z.object({
        client_alert: z
          .object({
            detect_bluetooth_microphone_error_alert: z.boolean().optional(),
            detect_bluetooth_speaker_error_alert: z.boolean().optional(),
            detect_camera_error_alert: z.boolean().optional(),
            detect_microphone_error_alert: z.boolean().optional(),
            detect_speaker_error_alert: z.boolean().optional(),
          })
          .optional(),
        digital_signage: z
          .object({
            banner: z
              .object({
                banner_room_name: z.boolean().optional(),
                banner_sharing_key: z.boolean().optional(),
                banner_time: z.boolean().optional(),
              })
              .optional(),
            display_period: z
              .object({
                start_displaying_content: z.number().optional(),
                stop_displaying_content: z.number().optional(),
              })
              .optional(),
            enable_digital_signage: z.boolean().optional(),
            layout: z.string().optional(),
            mute: z.boolean().optional(),
            play_list: z
              .array(
                z.object({
                  action: z.union([z.literal('add'), z.literal('update'), z.literal('delete')]).optional(),
                  contents: z
                    .array(
                      z.object({
                        action: z.string().optional(),
                        content_id: z.string().optional(),
                        duration: z.number().optional(),
                        id: z.string().optional(),
                        name: z.string().optional(),
                        order: z.number().optional(),
                      }),
                    )
                    .optional(),
                  end_time: z.string().optional(),
                  id: z.string().optional(),
                  name: z.string().optional(),
                  start_time: z.string().optional(),
                }),
              )
              .optional(),
          })
          .optional(),
        notification: z
          .object({
            audio_meet_usability_threshold: z.boolean().optional(),
            audio_not_meet_usability_threshold: z.boolean().optional(),
            battery_is_charging: z.boolean().optional(),
            battery_low_and_not_charging: z.boolean().optional(),
            battery_percentage: z.string().optional(),
            controller_scheduling_disconnected: z.boolean().optional(),
            controller_scheduling_reconnected: z.boolean().optional(),
            cpu_usage_high_detected: z.boolean().optional(),
            mic_speaker_camera_disconnected: z.boolean().optional(),
            mic_speaker_camera_reconnected: z.boolean().optional(),
            network_unstable_detected: z.boolean().optional(),
            sip_registration_failed: z.boolean().optional(),
            sip_registration_re_enabled: z.boolean().optional(),
            zoom_room_come_back_online: z.boolean().optional(),
            zoom_room_display_disconnected: z.boolean().optional(),
            zoom_room_offline: z.boolean().optional(),
          })
          .optional(),
      }),
    ])
    .optional(),
  path: z.object({
    roomId: z.string(),
  }),
  query: z
    .object({
      setting_type: z.string().optional(),
    })
    .optional(),
});

export const updateZrSettingsResponseSchema = z.unknown();

export const updateZrSettingsErrorSchema = z.unknown();

export const listSipPhonesDataSchema = z.object({
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_number: z.number().optional(),
      page_size: z.number().optional(),
      search_key: z.string().optional(),
    })
    .optional(),
});

export const listSipPhonesResponseSchema = z.object({
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_number: z.number().optional(),
  page_size: z.number().optional(),
  phones: z
    .array(
      z.object({
        authorization_name: z.string().optional(),
        domain: z.string().optional(),
        id: z.string().optional(),
        password: z.string().optional(),
        proxy_server: z.string().optional(),
        proxy_server2: z.string().optional(),
        proxy_server3: z.string().optional(),
        register_server: z.string().optional(),
        register_server2: z.string().optional(),
        register_server3: z.string().optional(),
        registration_expire_time: z.number().optional(),
        transport_protocol: z
          .union([z.literal('UDP'), z.literal('TCP'), z.literal('TLS'), z.literal('AUTO')])
          .optional(),
        transport_protocol2: z
          .union([z.literal('UDP'), z.literal('TCP'), z.literal('TLS'), z.literal('AUTO')])
          .optional(),
        transport_protocol3: z
          .union([z.literal('UDP'), z.literal('TCP'), z.literal('TLS'), z.literal('AUTO')])
          .optional(),
        user_email: z.string().optional(),
        user_name: z.string().optional(),
        voice_mail: z.string().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const listSipPhonesErrorSchema = z.unknown();

export const createSipPhoneDataSchema = z.object({
  body: z
    .object({
      authorization_name: z.string(),
      domain: z.string(),
      password: z.string(),
      proxy_server: z.string(),
      proxy_server2: z.string().optional(),
      proxy_server3: z.string().optional(),
      register_server: z.string(),
      register_server2: z.string().optional(),
      register_server3: z.string().optional(),
      registration_expire_time: z.number().optional(),
      transport_protocol: z.union([z.literal('UDP'), z.literal('TCP'), z.literal('TLS'), z.literal('AUTO')]).optional(),
      transport_protocol2: z
        .union([z.literal('UDP'), z.literal('TCP'), z.literal('TLS'), z.literal('AUTO')])
        .optional(),
      transport_protocol3: z
        .union([z.literal('UDP'), z.literal('TCP'), z.literal('TLS'), z.literal('AUTO')])
        .optional(),
      user_email: z.string(),
      user_name: z.string(),
      voice_mail: z.string(),
    })
    .optional(),
});

export const createSipPhoneResponseSchema = z.unknown();

export const createSipPhoneErrorSchema = z.unknown();

export const deleteSipPhoneDataSchema = z.object({
  path: z.object({
    phoneId: z.string(),
  }),
});

export const deleteSipPhoneResponseSchema = z.union([z.unknown(), z.record(z.unknown())]);

export const deleteSipPhoneErrorSchema = z.unknown();

export const updateSipPhoneDataSchema = z.object({
  body: z
    .object({
      authorization_name: z.string(),
      domain: z.string(),
      password: z.string(),
      proxy_server: z.string(),
      proxy_server2: z.string(),
      proxy_server3: z.string(),
      register_server: z.string(),
      register_server2: z.string(),
      register_server3: z.string(),
      registration_expire_time: z.number().optional(),
      transport_protocol: z.union([z.literal('UDP'), z.literal('TCP'), z.literal('TLS'), z.literal('AUTO')]).optional(),
      transport_protocol2: z
        .union([z.literal('UDP'), z.literal('TCP'), z.literal('TLS'), z.literal('AUTO')])
        .optional(),
      transport_protocol3: z
        .union([z.literal('UDP'), z.literal('TCP'), z.literal('TLS'), z.literal('AUTO')])
        .optional(),
      user_name: z.string(),
      voice_mail: z.string(),
    })
    .optional(),
  path: z.object({
    phoneId: z.string(),
  }),
});

export const updateSipPhoneResponseSchema = z.union([z.unknown(), z.record(z.unknown())]);

export const updateSipPhoneErrorSchema = z.unknown();

export const listSipTrunkNumbersResponseSchema = z.object({
  phone_numbers: z
    .array(
      z.object({
        country: z.string().optional(),
        number: z.string().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const listSipTrunkNumbersErrorSchema = z.unknown();

export const trackingfieldListResponseSchema = z.object({
  total_records: z.number().optional(),
  tracking_fields: z
    .array(
      z
        .object({
          id: z.string().optional(),
        })
        .and(
          z.object({
            field: z.string().optional(),
            recommended_values: z.array(z.string()).optional(),
            required: z.boolean().optional(),
            visible: z.boolean().optional(),
          }),
        ),
    )
    .optional(),
});

export const trackingfieldListErrorSchema = z.unknown();

export const trackingfieldCreateDataSchema = z.object({
  body: z.object({
    field: z.string().optional(),
    recommended_values: z.array(z.string()).optional(),
    required: z.boolean().optional(),
    visible: z.boolean().optional(),
  }),
});

export const trackingfieldCreateResponseSchema = z
  .object({
    id: z.string().optional(),
  })
  .and(
    z.object({
      field: z.string().optional(),
      recommended_values: z.array(z.string()).optional(),
      required: z.boolean().optional(),
      visible: z.boolean().optional(),
    }),
  );

export const trackingfieldCreateErrorSchema = z.unknown();

export const trackingfieldDeleteDataSchema = z.object({
  path: z.object({
    fieldId: z.string(),
  }),
});

export const trackingfieldDeleteResponseSchema = z.any();

export const trackingfieldDeleteErrorSchema = z.unknown();

export const trackingfieldGetDataSchema = z.object({
  path: z.object({
    fieldId: z.string(),
  }),
});

export const trackingfieldGetResponseSchema = z
  .object({
    id: z.string().optional(),
  })
  .and(
    z.object({
      field: z.string().optional(),
      recommended_values: z.array(z.string()).optional(),
      required: z.boolean().optional(),
      visible: z.boolean().optional(),
    }),
  );

export const trackingfieldGetErrorSchema = z.unknown();

export const trackingfieldUpdateDataSchema = z.object({
  body: z.object({
    field: z.string().optional(),
    recommended_values: z.array(z.string()).optional(),
    required: z.boolean().optional(),
    visible: z.boolean().optional(),
  }),
  path: z.object({
    fieldId: z.string(),
  }),
});

export const trackingfieldUpdateResponseSchema = z.any();

export const trackingfieldUpdateErrorSchema = z.unknown();

export const tspResponseSchema = z.object({
  dial_in_number_unrestricted: z.boolean().optional(),
  dial_in_numbers: z
    .array(
      z.object({
        code: z.string().optional(),
        number: z.string().optional(),
        type: z.string().optional(),
      }),
    )
    .optional(),
  enable: z.boolean().optional(),
  master_account_setting_extended: z.boolean().optional(),
  modify_credential_forbidden: z.boolean().optional(),
  tsp_bridge: z.union([z.literal('US_TSP_TB'), z.literal('EU_TSP_TB')]).optional(),
  tsp_enabled: z.boolean().optional(),
  tsp_provider: z.string().optional(),
});

export const tspErrorSchema = z.unknown();

export const tspUpdateDataSchema = z.object({
  body: z.object({
    dial_in_number_unrestricted: z.boolean().optional(),
    enable: z.boolean().optional(),
    master_account_setting_extended: z.boolean().optional(),
    modify_credential_forbidden: z.boolean().optional(),
    tsp_bridge: z.union([z.literal('US_TSP_TB'), z.literal('EU_TSP_TB')]).optional(),
    tsp_enabled: z.boolean().optional(),
    tsp_provider: z.string().optional(),
  }),
});

export const tspUpdateResponseSchema = z.any();

export const tspUpdateErrorSchema = z.unknown();

export const usersDataSchema = z.object({
  query: z
    .object({
      include_fields: z.string().optional(),
      next_page_token: z.string().optional(),
      page_number: z.string().optional(),
      page_size: z.number().optional(),
      role_id: z.string().optional(),
      status: z.union([z.literal('active'), z.literal('inactive'), z.literal('pending')]).optional(),
    })
    .optional(),
});

export const usersResponseSchema = z.object({
  next_page_token: z.string().optional(),
  page_count: z.number().optional(),
  page_number: z.number().optional(),
  page_size: z.number().optional(),
  total_records: z.number().optional(),
  users: z
    .array(
      z.object({
        created_at: z.string().optional(),
        custom_attributes: z
          .array(
            z.object({
              key: z.string().optional(),
              name: z.string().optional(),
              value: z.string().optional(),
            }),
          )
          .optional(),
        dept: z.string().optional(),
        email: z.string(),
        first_name: z.string().optional(),
        group_ids: z.array(z.string()).optional(),
        host_key: z.string().optional(),
        id: z.string().optional(),
        im_group_ids: z.array(z.string()).optional(),
        last_client_version: z.string().optional(),
        last_login_time: z.string().optional(),
        last_name: z.string().optional(),
        plan_united_type: z.string().optional(),
        pmi: z.number().optional(),
        role_id: z.string().optional(),
        status: z.string().optional(),
        timezone: z.string().optional(),
        type: z.number(),
        verified: z.number().optional(),
      }),
    )
    .optional(),
});

export const usersErrorSchema = z.unknown();

export const userCreateDataSchema = z.object({
  body: z.object({
    action: z.union([z.literal('create'), z.literal('autoCreate'), z.literal('custCreate'), z.literal('ssoCreate')]),
    user_info: z
      .object({
        email: z.string(),
        first_name: z.string().optional(),
        last_name: z.string().optional(),
        password: z.string().optional(),
        type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(99)]),
      })
      .optional(),
  }),
});

export const userCreateResponseSchema = z.object({
  email: z.string().optional(),
  first_name: z.string().optional(),
  id: z.string().optional(),
  last_name: z.string().optional(),
  type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(99)]).optional(),
});

export const userCreateErrorSchema = z.unknown();

export const userEmailDataSchema = z.object({
  query: z.object({
    email: z.string(),
  }),
});

export const userEmailResponseSchema = z.object({
  existed_email: z.boolean().optional(),
});

export const userEmailErrorSchema = z.unknown();

export const userZakResponseSchema = z.object({
  token: z.string().optional(),
});

export const userZakErrorSchema = z.unknown();

export const userVanityNameDataSchema = z.object({
  query: z.object({
    vanity_name: z.string(),
  }),
});

export const userVanityNameResponseSchema = z.object({
  existed: z.boolean().optional(),
});

export const userVanityNameErrorSchema = z.unknown();

export const userDeleteDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      action: z.union([z.literal('disassociate'), z.literal('delete')]).optional(),
      transfer_email: z.string().optional(),
      transfer_meeting: z.boolean().optional(),
      transfer_recording: z.boolean().optional(),
      transfer_webinar: z.boolean().optional(),
    })
    .optional(),
});

export const userDeleteResponseSchema = z.any();

export const userDeleteErrorSchema = z.unknown();

export const userDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      login_type: z
        .union([z.literal('0'), z.literal('1'), z.literal('99'), z.literal('100'), z.literal('101')])
        .optional(),
    })
    .optional(),
});

export const userResponseSchema = z
  .object({
    id: z.string().optional(),
  })
  .and(
    z.object({
      created_at: z.string().optional(),
      dept: z.string().optional(),
      email: z.string(),
      first_name: z.string().optional(),
      last_client_version: z.string().optional(),
      last_login_time: z.string().optional(),
      last_name: z.string().optional(),
      pmi: z.number().optional(),
      role_name: z.string().optional(),
      timezone: z.string().optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(99)]),
      use_pmi: z.boolean().optional(),
    }),
  )
  .and(
    z.object({
      account_id: z.string().optional(),
      cms_user_id: z.string().optional(),
      company: z.string().optional(),
      created_at: z.string().optional(),
      custom_attributes: z
        .object({
          key: z.string().optional(),
          name: z.string().optional(),
          value: z.string().optional(),
        })
        .optional(),
      group_ids: z.array(z.string()).optional(),
      host_key: z.string().optional(),
      im_group_ids: z.array(z.string()).optional(),
      jid: z.string().optional(),
      job_title: z.string().optional(),
      language: z.string().optional(),
      location: z.string().optional(),
      login_type: z.union([z.literal(0), z.literal(1), z.literal(99), z.literal(100), z.literal(101)]).optional(),
      manager: z.string().optional(),
      personal_meeting_url: z.string().optional(),
      phone_country: z.string().optional(),
      phone_number: z.string().optional(),
      phone_numbers: z
        .object({
          code: z.string().optional(),
          country: z.string().optional(),
          number: z.string().optional(),
          verified: z.boolean().optional(),
        })
        .optional(),
      pic_url: z.string().optional(),
      plan_united_type: z.string().optional(),
      role_id: z.string().optional(),
      status: z.union([z.literal('pending'), z.literal('active'), z.literal('inactive')]).optional(),
      use_pmi: z.boolean().optional(),
      vanity_url: z.string().optional(),
      verified: z.number().optional(),
    }),
  );

export const userErrorSchema = z.unknown();

export const userUpdateDataSchema = z.object({
  body: z.object({
    cms_user_id: z.string().optional(),
    company: z.string().optional(),
    custom_attributes: z
      .object({
        key: z.string().optional(),
        name: z.string().optional(),
        value: z.string().optional(),
      })
      .optional(),
    dept: z.string().optional(),
    first_name: z.string().optional(),
    group_id: z.string().optional(),
    host_key: z.string().optional(),
    job_title: z.string().optional(),
    language: z.string().optional(),
    last_name: z.string().optional(),
    location: z.string().optional(),
    manager: z.string().optional(),
    phone_country: z.string().optional(),
    phone_number: z.string().optional(),
    phone_numbers: z
      .object({
        code: z.string().optional(),
        country: z.string().optional(),
        number: z.string().optional(),
      })
      .optional(),
    pmi: z.number().optional(),
    timezone: z.string().optional(),
    type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(99)]).optional(),
    use_pmi: z.boolean().optional(),
    vanity_name: z.string().optional(),
  }),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      login_type: z
        .union([z.literal('0'), z.literal('1'), z.literal('99'), z.literal('100'), z.literal('101')])
        .optional(),
    })
    .optional(),
});

export const userUpdateResponseSchema = z.any();

export const userUpdateErrorSchema = z.unknown();

export const userAssistantsDeleteDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
});

export const userAssistantsDeleteResponseSchema = z.any();

export const userAssistantsDeleteErrorSchema = z.unknown();

export const userAssistantsDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
});

export const userAssistantsResponseSchema = z.object({
  assistants: z
    .array(
      z.object({
        email: z.string().optional(),
        id: z.string().optional(),
      }),
    )
    .optional(),
});

export const userAssistantsErrorSchema = z.unknown();

export const userAssistantCreateDataSchema = z.object({
  body: z.object({
    assistants: z
      .array(
        z.object({
          email: z.string().optional(),
          id: z.string().optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    userId: z.string(),
  }),
});

export const userAssistantCreateResponseSchema = z.object({
  add_at: z.string().optional(),
  ids: z.string().optional(),
});

export const userAssistantCreateErrorSchema = z.unknown();

export const userAssistantDeleteDataSchema = z.object({
  path: z.object({
    assistantId: z.string(),
    userId: z.string(),
  }),
});

export const userAssistantDeleteResponseSchema = z.any();

export const userAssistantDeleteErrorSchema = z.unknown();

export const userEmailUpdateDataSchema = z.object({
  body: z.object({
    email: z.string(),
  }),
  path: z.object({
    userId: z.string(),
  }),
});

export const userEmailUpdateResponseSchema = z.any();

export const userEmailUpdateErrorSchema = z.unknown();

export const listMeetingTemplatesDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
});

export const listMeetingTemplatesResponseSchema = z.object({
  templates: z
    .array(
      z.object({
        id: z.string().optional(),
        name: z.string().optional(),
        type: z.number().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const listMeetingTemplatesErrorSchema = z.unknown();

export const meetingsDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      page_number: z.string().optional(),
      page_size: z.number().optional(),
      type: z.union([z.literal('scheduled'), z.literal('live'), z.literal('upcoming')]).optional(),
    })
    .optional(),
});

export const meetingsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      meetings: z
        .array(
          z.object({
            agenda: z.string().optional(),
            created_at: z.string().optional(),
            duration: z.number().optional(),
            host_id: z.string().optional(),
            id: z.number().optional(),
            join_url: z.string().optional(),
            pmi: z.string().optional(),
            start_time: z.string().optional(),
            timezone: z.string().optional(),
            topic: z.string().optional(),
            type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
            uuid: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const meetingsErrorSchema = z.unknown();

export const meetingCreateDataSchema = z.object({
  body: z.object({
    agenda: z.string().optional(),
    duration: z.number().optional(),
    password: z.string().optional(),
    recurrence: z
      .object({
        end_date_time: z.string().optional(),
        end_times: z.number().optional(),
        monthly_day: z.number().optional(),
        monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
        monthly_week_day: z
          .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
          .optional(),
        repeat_interval: z.number().optional(),
        type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
        weekly_days: z
          .union([
            z.literal('1'),
            z.literal('2'),
            z.literal('3'),
            z.literal('4'),
            z.literal('5'),
            z.literal('6'),
            z.literal('7'),
          ])
          .optional(),
      })
      .optional(),
    schedule_for: z.string().optional(),
    settings: z
      .object({
        additional_data_center_regions: z.array(z.string()).optional(),
        allow_multiple_devices: z.boolean().optional(),
        alternative_hosts: z.string().optional(),
        alternative_hosts_email_notification: z.boolean().optional(),
        approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
        approved_or_denied_countries_or_regions: z
          .object({
            approved_list: z.array(z.string()).optional(),
            denied_list: z.array(z.string()).optional(),
            enable: z.boolean().optional(),
            method: z.union([z.literal('approve'), z.literal('deny')]).optional(),
          })
          .optional(),
        audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
        authentication_domains: z.string().optional(),
        authentication_option: z.string().optional(),
        auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
        breakout_room: z
          .object({
            enable: z.boolean().optional(),
            rooms: z
              .array(
                z.object({
                  name: z.string().optional(),
                  participants: z.array(z.string()).optional(),
                }),
              )
              .optional(),
          })
          .optional(),
        close_registration: z.boolean().optional(),
        cn_meeting: z.boolean().optional(),
        contact_email: z.string().optional(),
        contact_name: z.string().optional(),
        encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
        global_dial_in_countries: z.array(z.string()).optional(),
        host_video: z.boolean().optional(),
        in_meeting: z.boolean().optional(),
        jbh_time: z.union([z.literal(0), z.literal(5), z.literal(10)]).optional(),
        join_before_host: z.boolean().optional(),
        language_interpretation: z
          .object({
            enable: z.boolean().optional(),
            interpreters: z
              .array(
                z.object({
                  email: z.string().optional(),
                  languages: z.string().optional(),
                }),
              )
              .optional(),
          })
          .optional(),
        meeting_authentication: z.boolean().optional(),
        mute_upon_entry: z.boolean().optional(),
        participant_video: z.boolean().optional(),
        registrants_email_notification: z.boolean().optional(),
        registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
        show_share_button: z.boolean().optional(),
        use_pmi: z.boolean().optional(),
        waiting_room: z.boolean().optional(),
        watermark: z.boolean().optional(),
      })
      .optional(),
    start_time: z.string().optional(),
    template_id: z.string().optional(),
    timezone: z.string().optional(),
    topic: z.string().optional(),
    tracking_fields: z
      .array(
        z.object({
          field: z.string(),
          value: z.string().optional(),
        }),
      )
      .optional(),
    type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
  }),
  path: z.object({
    userId: z.string(),
  }),
});

export const meetingCreateResponseSchema = z
  .object({
    assistant_id: z.string().optional(),
    host_email: z.string().optional(),
    id: z.number().optional(),
    registration_url: z.string().optional(),
  })
  .and(
    z.object({
      agenda: z.string().optional(),
      created_at: z.string().optional(),
      duration: z.number().optional(),
      h323_password: z.string().optional(),
      join_url: z.string().optional(),
      occurrences: z
        .array(
          z.object({
            duration: z.number().optional(),
            occurrence_id: z.string().optional(),
            start_time: z.string().optional(),
            status: z.string().optional(),
          }),
        )
        .optional(),
      password: z.string().optional(),
      pmi: z.number().optional(),
      recurrence: z
        .object({
          end_date_time: z.string().optional(),
          end_times: z.number().optional(),
          monthly_day: z.number().optional(),
          monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
          monthly_week_day: z
            .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
            .optional(),
          repeat_interval: z.number().optional(),
          type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
          weekly_days: z
            .union([
              z.literal('1'),
              z.literal('2'),
              z.literal('3'),
              z.literal('4'),
              z.literal('5'),
              z.literal('6'),
              z.literal('7'),
            ])
            .optional(),
        })
        .optional(),
      settings: z
        .object({
          allow_multiple_devices: z.boolean().optional(),
          alternative_hosts: z.string().optional(),
          alternative_hosts_email_notification: z.boolean().optional(),
          approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
          approved_or_denied_countries_or_regions: z
            .object({
              approved_list: z.array(z.string()).optional(),
              denied_list: z.array(z.string()).optional(),
              enable: z.boolean().optional(),
              method: z.union([z.literal('approve'), z.literal('deny')]).optional(),
            })
            .optional(),
          audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
          authentication_domains: z.string().optional(),
          authentication_exception: z
            .array(
              z.object({
                email: z.string().optional(),
                name: z.string().optional(),
              }),
            )
            .optional(),
          authentication_name: z.string().optional(),
          authentication_option: z.string().optional(),
          auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
          breakout_room: z
            .object({
              enable: z.boolean().optional(),
              rooms: z
                .array(
                  z.object({
                    name: z.string().optional(),
                    participants: z.array(z.string()).optional(),
                  }),
                )
                .optional(),
            })
            .optional(),
          close_registration: z.boolean().optional(),
          cn_meeting: z.boolean().optional(),
          contact_email: z.string().optional(),
          contact_name: z.string().optional(),
          custom_keys: z
            .array(
              z.object({
                key: z.string().optional(),
                value: z.string().optional(),
              }),
            )
            .optional(),
          encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
          enforce_login: z.boolean().optional(),
          enforce_login_domains: z.string().optional(),
          global_dial_in_countries: z.array(z.string()).optional(),
          global_dial_in_numbers: z
            .array(
              z.object({
                city: z.string().optional(),
                country: z.string().optional(),
                country_name: z.string().optional(),
                number: z.string().optional(),
                type: z.union([z.literal('toll'), z.literal('tollfree')]).optional(),
              }),
            )
            .optional(),
          host_video: z.boolean().optional(),
          in_meeting: z.boolean().optional(),
          jbh_time: z.union([z.literal(0), z.literal(5), z.literal(10)]).optional(),
          join_before_host: z.boolean().optional(),
          language_interpretation: z
            .object({
              enable: z.boolean().optional(),
              interpreters: z
                .array(
                  z.object({
                    email: z.string().optional(),
                    languages: z.string().optional(),
                  }),
                )
                .optional(),
            })
            .optional(),
          meeting_authentication: z.boolean().optional(),
          mute_upon_entry: z.boolean().optional(),
          participant_video: z.boolean().optional(),
          registrants_confirmation_email: z.boolean().optional(),
          registrants_email_notification: z.boolean().optional(),
          registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
          show_share_button: z.boolean().optional(),
          use_pmi: z.boolean().optional(),
          waiting_room: z.boolean().optional(),
          watermark: z.boolean().optional(),
        })
        .optional(),
      start_time: z.string().optional(),
      start_url: z.string().optional(),
      timezone: z.string().optional(),
      topic: z.string().optional(),
      tracking_fields: z
        .array(
          z.object({
            field: z.string().optional(),
            value: z.string().optional(),
            visible: z.boolean().optional(),
          }),
        )
        .optional(),
      type: z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(8)]).optional(),
    }),
  );

export const meetingCreateErrorSchema = z.unknown();

export const userPaCsDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
});

export const userPaCsResponseSchema = z.object({
  pac_accounts: z
    .array(
      z.object({
        conference_id: z.number().optional(),
        dedicated_dial_in_number: z
          .array(
            z.object({
              country: z.string().optional(),
              number: z.string().optional(),
            }),
          )
          .optional(),
        global_dial_in_numbers: z
          .array(
            z.object({
              country: z.string().optional(),
              number: z.string().optional(),
            }),
          )
          .optional(),
        listen_only_password: z.string().optional(),
        participant_password: z.string().optional(),
      }),
    )
    .optional(),
});

export const userPaCsErrorSchema = z.unknown();

export const userPasswordDataSchema = z.object({
  body: z.object({
    password: z.string(),
  }),
  path: z.object({
    userId: z.string(),
  }),
});

export const userPasswordResponseSchema = z.any();

export const userPasswordErrorSchema = z.unknown();

export const userPermissionDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
});

export const userPermissionResponseSchema = z.object({
  permissions: z.array(z.string()).optional(),
});

export const userPermissionErrorSchema = z.unknown();

export const userPictureResponseSchema = z.string();

export const userPictureErrorSchema = z.unknown();

export const updatePresenceStatusDataSchema = z.object({
  body: z
    .object({
      duration: z.number().optional(),
      status: z.union([z.literal('Do_No_Disturb'), z.literal('Away'), z.literal('Available')]).optional(),
    })
    .optional(),
  path: z.object({
    userId: z.string(),
  }),
});

export const updatePresenceStatusResponseSchema = z.unknown();

export const updatePresenceStatusErrorSchema = z.unknown();

export const recordingsListDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      from: z.string().optional(),
      mc: z.string().optional(),
      next_page_token: z.string().optional(),
      page_size: z.number().optional(),
      to: z.string().optional(),
      trash: z.boolean().optional(),
      trash_type: z.string().optional(),
    })
    .optional(),
});

export const recordingsListResponseSchema = z
  .object({
    from: z.string().optional(),
    to: z.string().optional(),
  })
  .and(
    z.object({
      next_page_token: z.string().optional(),
      page_count: z.number().optional(),
      page_size: z.number().optional(),
      total_records: z.number().optional(),
    }),
  )
  .and(
    z.object({
      meetings: z
        .array(
          z
            .object({
              account_id: z.string().optional(),
              duration: z.number().optional(),
              host_id: z.string().optional(),
              id: z.string().optional(),
              recording_count: z.string().optional(),
              start_time: z.string().optional(),
              topic: z.string().optional(),
              total_size: z.string().optional(),
              type: z.string().optional(),
              uuid: z.string().optional(),
            })
            .and(
              z.object({
                recording_files: z
                  .array(
                    z.object({
                      deleted_time: z.string().optional(),
                      download_url: z.string().optional(),
                      file_size: z.number().optional(),
                      file_type: z.string().optional(),
                      id: z.string().optional(),
                      meeting_id: z.string().optional(),
                      play_url: z.string().optional(),
                      recording_end: z.string().optional(),
                      recording_start: z.string().optional(),
                      recording_type: z.string().optional(),
                      status: z.literal('completed').optional(),
                    }),
                  )
                  .optional(),
              }),
            ),
        )
        .optional(),
    }),
  );

export const recordingsListErrorSchema = z.unknown();

export const userSchedulersDeleteDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
});

export const userSchedulersDeleteResponseSchema = z.any();

export const userSchedulersDeleteErrorSchema = z.unknown();

export const userSchedulersDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
});

export const userSchedulersResponseSchema = z.object({
  schedulers: z
    .array(
      z.object({
        email: z.string().optional(),
        id: z.string().optional(),
        pmi: z.number().optional(),
      }),
    )
    .optional(),
});

export const userSchedulersErrorSchema = z.unknown();

export const userSchedulerDeleteDataSchema = z.object({
  path: z.object({
    schedulerId: z.string(),
    userId: z.string(),
  }),
});

export const userSchedulerDeleteResponseSchema = z.any();

export const userSchedulerDeleteErrorSchema = z.unknown();

export const userSettingsDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      custom_query_fields: z.string().optional(),
      login_type: z
        .union([z.literal('0'), z.literal('1'), z.literal('99'), z.literal('100'), z.literal('101')])
        .optional(),
      option: z.union([z.literal('meeting_authentication'), z.literal('recording_authentication')]).optional(),
    })
    .optional(),
});

export const userSettingsResponseSchema = z.union([
  z.object({
    email_notification: z
      .object({
        alternative_host_reminder: z.boolean().optional(),
        cancel_meeting_reminder: z.boolean().optional(),
        jbh_reminder: z.boolean().optional(),
        schedule_for_reminder: z.boolean().optional(),
      })
      .optional(),
    feature: z
      .object({
        cn_meeting: z.boolean().optional(),
        in_meeting: z.boolean().optional(),
        large_meeting: z.boolean().optional(),
        large_meeting_capacity: z.number().optional(),
        meeting_capacity: z.number().optional(),
        webinar: z.boolean().optional(),
        webinar_capacity: z.number().optional(),
        zoom_phone: z.boolean().optional(),
      })
      .optional(),
    in_meeting: z
      .object({
        allow_live_streaming: z.boolean().optional(),
        annotation: z.boolean().optional(),
        attendee_on_hold: z.boolean().optional(),
        auto_saving_chat: z.boolean().optional(),
        breakout_room: z.boolean().optional(),
        chat: z.boolean().optional(),
        closed_caption: z.boolean().optional(),
        co_host: z.boolean().optional(),
        custom_data_center_regions: z.boolean().optional(),
        custom_live_streaming_service: z.boolean().optional(),
        custom_service_instructions: z.string().optional(),
        data_center_regions: z
          .union([
            z.literal('HK'),
            z.literal('AU'),
            z.literal('IN'),
            z.literal('TY'),
            z.literal('CN'),
            z.literal('US'),
            z.literal('CA'),
            z.literal('DE'),
            z.literal('NL'),
            z.literal('LA'),
          ])
          .optional(),
        e2e_encryption: z.boolean().optional(),
        entry_exit_chime: z.union([z.literal('host'), z.literal('all'), z.literal('none')]).optional(),
        far_end_camera_control: z.boolean().optional(),
        feedback: z.boolean().optional(),
        file_transfer: z.boolean().optional(),
        group_hd: z.boolean().optional(),
        non_verbal_feedback: z.boolean().optional(),
        polling: z.boolean().optional(),
        private_chat: z.boolean().optional(),
        record_play_voice: z.boolean().optional(),
        remote_control: z.boolean().optional(),
        remote_support: z.boolean().optional(),
        request_permission_to_unmute: z.boolean().optional(),
        screen_sharing: z.boolean().optional(),
        share_dual_camera: z.boolean().optional(),
        show_meeting_control_toolbar: z.boolean().optional(),
        virtual_background: z.boolean().optional(),
        virtual_background_settings: z
          .object({
            allow_upload_custom: z.boolean().optional(),
            allow_videos: z.boolean().optional(),
            enable: z.boolean().optional(),
            files: z
              .array(
                z.object({
                  id: z.string().optional(),
                  is_default: z.boolean().optional(),
                  name: z.string().optional(),
                  size: z.string().optional(),
                  type: z.string().optional(),
                }),
              )
              .optional(),
          })
          .optional(),
        waiting_room: z.boolean().optional(),
        who_can_share_screen: z.union([z.literal('host'), z.literal('all')]).optional(),
        who_can_share_screen_when_someone_is_sharing: z.union([z.literal('host'), z.literal('all')]).optional(),
        workplace_by_facebook: z.boolean().optional(),
      })
      .optional(),
    profile: z
      .object({
        recording_storage_location: z
          .object({
            allowed_values: z.array(z.string()).optional(),
            value: z.string().optional(),
          })
          .optional(),
      })
      .optional(),
    recording: z
      .object({
        ask_host_to_confirm_disclaimer: z.boolean().optional(),
        ask_participants_to_consent_disclaimer: z.boolean().optional(),
        auto_delete_cmr: z.boolean().optional(),
        auto_delete_cmr_days: z.number().optional(),
        auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
        cloud_recording: z.boolean().optional(),
        host_pause_stop_recording: z.boolean().optional(),
        ip_address_access_control: z
          .object({
            enable: z.boolean().optional(),
            ip_addresses_or_ranges: z.string().optional(),
          })
          .optional(),
        local_recording: z.boolean().optional(),
        record_audio_file: z.boolean().optional(),
        record_gallery_view: z.boolean().optional(),
        record_speaker_view: z.boolean().optional(),
        recording_audio_transcript: z.boolean().optional(),
        recording_disclaimer: z.boolean().optional(),
        recording_password_requirement: z
          .object({
            have_letter: z.boolean().optional(),
            have_number: z.boolean().optional(),
            have_special_character: z.boolean().optional(),
            length: z.number().optional(),
            only_allow_numeric: z.boolean().optional(),
          })
          .optional(),
        save_chat_text: z.boolean().optional(),
        show_timestamp: z.boolean().optional(),
      })
      .optional(),
    schedule_meeting: z
      .object({
        audio_type: z
          .union([z.literal('both'), z.literal('telephony'), z.literal('voip'), z.literal('thirdParty')])
          .optional(),
        default_password_for_scheduled_meetings: z.string().optional(),
        embed_password_in_join_link: z.boolean().optional(),
        force_pmi_jbh_password: z.boolean().optional(),
        host_video: z.boolean().optional(),
        join_before_host: z.boolean().optional(),
        meeting_password_requirement: z
          .object({
            consecutive_characters_length: z
              .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
              .optional(),
            have_letter: z.boolean().optional(),
            have_number: z.boolean().optional(),
            have_special_character: z.boolean().optional(),
            have_upper_and_lower_characters: z.boolean().optional(),
            length: z.number().optional(),
            only_allow_numeric: z.boolean().optional(),
            weak_enhance_detection: z.boolean().optional(),
          })
          .optional(),
        participants_video: z.boolean().optional(),
        personal_meeting: z.boolean().optional(),
        pmi_password: z.string().optional(),
        pstn_password_protected: z.boolean().optional(),
        require_password_for_instant_meetings: z.boolean().optional(),
        require_password_for_pmi_meetings: z
          .union([z.literal('jbh_only'), z.literal('all'), z.literal('none')])
          .optional(),
        require_password_for_scheduled_meetings: z.boolean().optional(),
        require_password_for_scheduling_new_meetings: z.boolean().optional(),
        use_pmi_for_instant_meetings: z.boolean().optional(),
        use_pmi_for_scheduled_meetings: z.boolean().optional(),
      })
      .optional(),
    telephony: z
      .object({
        audio_conference_info: z.string().optional(),
        show_international_numbers_link: z.boolean().optional(),
        telephony_regions: z
          .object({
            allowed_values: z.array(z.string()).optional(),
            selection_values: z.array(z.string()).optional(),
          })
          .optional(),
        third_party_audio: z.boolean().optional(),
      })
      .optional(),
    tsp: z
      .object({
        call_out: z.boolean().optional(),
        call_out_countries: z.array(z.unknown()).optional(),
        show_international_numbers_link: z.boolean().optional(),
      })
      .optional(),
  }),
  z.union([
    z.object({
      authentication_options: z
        .array(
          z.object({
            default_option: z.boolean().optional(),
            domains: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z
              .union([
                z.literal('enforce_login'),
                z.literal('enforce_login_with_same_account'),
                z.literal('enforce_login_with_domains'),
              ])
              .optional(),
            visible: z.boolean().optional(),
          }),
        )
        .optional(),
      meeting_authentication: z.boolean().optional(),
    }),
    z.object({
      authentication_options: z
        .array(
          z.object({
            default_option: z.boolean().optional(),
            domains: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z
              .union([z.literal('internally'), z.literal('enforce_login'), z.literal('enforce_login_with_domains')])
              .optional(),
            visible: z.boolean().optional(),
          }),
        )
        .optional(),
      recording_authentication: z.boolean().optional(),
    }),
  ]),
  z.object({
    meeting_security: z
      .object({
        auto_security: z.boolean().optional(),
        embed_password_in_join_link: z.boolean().optional(),
        encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
        end_to_end_encrypted_meetings: z.boolean().optional(),
        meeting_password: z.boolean().optional(),
        meeting_password_requirement: z
          .object({
            consecutive_characters_length: z
              .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
              .optional(),
            have_letter: z.boolean().optional(),
            have_number: z.boolean().optional(),
            have_special_character: z.boolean().optional(),
            have_upper_and_lower_characters: z.boolean().optional(),
            length: z.number().optional(),
            only_allow_numeric: z.boolean().optional(),
            weak_enhance_detection: z.boolean().optional(),
          })
          .optional(),
        phone_password: z.boolean().optional(),
        pmi_password: z.boolean().optional(),
        require_password_for_scheduled_meeting: z.boolean().optional(),
        require_password_for_scheduled_webinar: z.boolean().optional(),
        waiting_room: z.boolean().optional(),
        waiting_room_settings: z
          .object({
            participants_to_place_in_waiting_room: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
            users_who_can_admit_participants_from_waiting_room: z.number().optional(),
            whitelisted_domains_for_waiting_room: z.string().optional(),
          })
          .optional(),
        webinar_password: z.boolean().optional(),
      })
      .optional(),
  }),
]);

export const userSettingsErrorSchema = z.unknown();

export const userSettingsUpdateDataSchema = z.object({
  body: z.union([
    z.object({
      email_notification: z
        .object({
          alternative_host_reminder: z.boolean().optional(),
          cancel_meeting_reminder: z.boolean().optional(),
          jbh_reminder: z.boolean().optional(),
          schedule_for_reminder: z.boolean().optional(),
        })
        .optional(),
      feature: z
        .object({
          large_meeting: z.boolean().optional(),
          large_meeting_capacity: z.number().optional(),
          meeting_capacity: z.number().optional(),
          webinar: z.boolean().optional(),
          webinar_capacity: z.number().optional(),
          zoom_phone: z.boolean().optional(),
        })
        .optional(),
      in_meeting: z
        .object({
          allow_live_streaming: z.boolean().optional(),
          annotation: z.boolean().optional(),
          attendee_on_hold: z.boolean().optional(),
          auto_saving_chat: z.boolean().optional(),
          breakout_room: z.boolean().optional(),
          chat: z.boolean().optional(),
          closed_caption: z.boolean().optional(),
          co_host: z.boolean().optional(),
          custom_data_center_regions: z.boolean().optional(),
          custom_live_streaming_service: z.boolean().optional(),
          custom_service_instructions: z.string().optional(),
          data_center_regions: z
            .union([
              z.literal('HK'),
              z.literal('AU'),
              z.literal('IN'),
              z.literal('TY'),
              z.literal('CN'),
              z.literal('US'),
              z.literal('CA'),
              z.literal('DE'),
              z.literal('NL'),
              z.literal('LA'),
            ])
            .optional(),
          e2e_encryption: z.boolean().optional(),
          entry_exit_chime: z.union([z.literal('host'), z.literal('all'), z.literal('none')]).optional(),
          far_end_camera_control: z.boolean().optional(),
          feedback: z.boolean().optional(),
          file_transfer: z.boolean().optional(),
          group_hd: z.boolean().optional(),
          non_verbal_feedback: z.boolean().optional(),
          polling: z.boolean().optional(),
          private_chat: z.boolean().optional(),
          record_play_voice: z.boolean().optional(),
          remote_control: z.boolean().optional(),
          remote_support: z.boolean().optional(),
          request_permission_to_unmute: z.boolean().optional(),
          screen_sharing: z.boolean().optional(),
          share_dual_camera: z.boolean().optional(),
          show_meeting_control_toolbar: z.boolean().optional(),
          virtual_background: z.boolean().optional(),
          virtual_background_settings: z
            .object({
              allow_upload_custom: z.boolean().optional(),
              allow_videos: z.boolean().optional(),
              enable: z.boolean().optional(),
              files: z
                .array(
                  z.object({
                    id: z.string().optional(),
                    is_default: z.boolean().optional(),
                    name: z.string().optional(),
                    size: z.string().optional(),
                    type: z.string().optional(),
                  }),
                )
                .optional(),
            })
            .optional(),
          waiting_room: z.boolean().optional(),
          who_can_share_screen: z.union([z.literal('host'), z.literal('all')]).optional(),
          who_can_share_screen_when_someone_is_sharing: z.union([z.literal('host'), z.literal('all')]).optional(),
          workplace_by_facebook: z.boolean().optional(),
        })
        .optional(),
      profile: z
        .object({
          recording_storage_location: z
            .object({
              allowed_values: z.array(z.string()).optional(),
              value: z.string().optional(),
            })
            .optional(),
        })
        .optional(),
      recording: z
        .object({
          ask_host_to_confirm_disclaimer: z.boolean().optional(),
          ask_participants_to_consent_disclaimer: z.boolean().optional(),
          auto_delete_cmr: z.boolean().optional(),
          auto_delete_cmr_days: z.number().optional(),
          auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
          cloud_recording: z.boolean().optional(),
          host_pause_stop_recording: z.boolean().optional(),
          ip_address_access_control: z
            .object({
              enable: z.boolean().optional(),
              ip_addresses_or_ranges: z.string().optional(),
            })
            .optional(),
          local_recording: z.boolean().optional(),
          record_audio_file: z.boolean().optional(),
          record_gallery_view: z.boolean().optional(),
          record_speaker_view: z.boolean().optional(),
          recording_audio_transcript: z.boolean().optional(),
          recording_disclaimer: z.boolean().optional(),
          recording_password_requirement: z
            .object({
              have_letter: z.boolean().optional(),
              have_number: z.boolean().optional(),
              have_special_character: z.boolean().optional(),
              length: z.number().optional(),
              only_allow_numeric: z.boolean().optional(),
            })
            .optional(),
          save_chat_text: z.boolean().optional(),
          show_timestamp: z.boolean().optional(),
        })
        .optional(),
      schedule_meeting: z
        .object({
          audio_type: z
            .union([z.literal('both'), z.literal('telephony'), z.literal('voip'), z.literal('thirdParty')])
            .optional(),
          default_password_for_scheduled_meetings: z.string().optional(),
          embed_password_in_join_link: z.boolean().optional(),
          force_pmi_jbh_password: z.boolean().optional(),
          host_video: z.boolean().optional(),
          join_before_host: z.boolean().optional(),
          meeting_password_requirement: z
            .object({
              consecutive_characters_length: z
                .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
                .optional(),
              have_letter: z.boolean().optional(),
              have_number: z.boolean().optional(),
              have_special_character: z.boolean().optional(),
              have_upper_and_lower_characters: z.boolean().optional(),
              length: z.number().optional(),
              only_allow_numeric: z.boolean().optional(),
              weak_enhance_detection: z.boolean().optional(),
            })
            .optional(),
          participants_video: z.boolean().optional(),
          personal_meeting: z.boolean().optional(),
          pmi_password: z.string().optional(),
          pstn_password_protected: z.boolean().optional(),
          require_password_for_instant_meetings: z.boolean().optional(),
          require_password_for_pmi_meetings: z
            .union([z.literal('jbh_only'), z.literal('all'), z.literal('none')])
            .optional(),
          require_password_for_scheduled_meetings: z.boolean().optional(),
          require_password_for_scheduling_new_meetings: z.boolean().optional(),
          use_pmi_for_instant_meetings: z.boolean().optional(),
          use_pmi_for_scheduled_meetings: z.boolean().optional(),
        })
        .optional(),
      telephony: z
        .object({
          audio_conference_info: z.string().optional(),
          show_international_numbers_link: z.boolean().optional(),
          telephony_regions: z
            .object({
              selection_values: z.array(z.string()).optional(),
            })
            .optional(),
          third_party_audio: z.boolean().optional(),
        })
        .optional(),
      tsp: z
        .object({
          call_out: z.boolean().optional(),
          call_out_countries: z.array(z.unknown()).optional(),
          show_international_numbers_link: z.boolean().optional(),
        })
        .optional(),
    }),
    z.union([
      z.object({
        authentication_option: z
          .object({
            action: z.union([z.literal('update'), z.literal('show'), z.literal('hide')]).optional(),
            default_option: z.boolean().optional(),
            domains: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z
              .union([
                z.literal('enforce_login'),
                z.literal('enforce_login_with_same_account'),
                z.literal('enforce_login_with_domains'),
              ])
              .optional(),
          })
          .optional(),
        meeting_authentication: z.boolean().optional(),
      }),
      z.object({
        authentication_option: z
          .object({
            action: z.union([z.literal('update'), z.literal('show'), z.literal('hide')]).optional(),
            default_option: z.boolean().optional(),
            domians: z.string().optional(),
            id: z.string().optional(),
            name: z.string().optional(),
            type: z
              .union([z.literal('internally'), z.literal('enforce_login'), z.literal('enforce_login_with_domains')])
              .optional(),
          })
          .optional(),
        recording_authentication: z.boolean().optional(),
      }),
    ]),
    z.object({
      meeting_security: z
        .object({
          auto_security: z.boolean().optional(),
          embed_password_in_join_link: z.boolean().optional(),
          encryption_type: z.union([z.literal('enhanced_encryption'), z.literal('e2ee')]).optional(),
          end_to_end_encrypted_meetings: z.boolean().optional(),
          meeting_password: z.boolean().optional(),
          meeting_password_requirement: z
            .object({
              consecutive_characters_length: z
                .union([z.literal(0), z.literal(4), z.literal(5), z.literal(6), z.literal(7), z.literal(8)])
                .optional(),
              have_letter: z.boolean().optional(),
              have_number: z.boolean().optional(),
              have_special_character: z.boolean().optional(),
              have_upper_and_lower_characters: z.boolean().optional(),
              length: z.number().optional(),
              only_allow_numeric: z.boolean().optional(),
              weak_enhance_detection: z.boolean().optional(),
            })
            .optional(),
          phone_password: z.boolean().optional(),
          pmi_password: z.boolean().optional(),
          require_password_for_scheduled_meeting: z.boolean().optional(),
          require_password_for_scheduled_webinar: z.boolean().optional(),
          waiting_room: z.boolean().optional(),
          waiting_room_settings: z
            .object({
              participants_to_place_in_waiting_room: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
              users_who_can_admit_participants_from_waiting_room: z.number().optional(),
              whitelisted_domains_for_waiting_room: z.string().optional(),
            })
            .optional(),
          webinar_password: z.boolean().optional(),
        })
        .optional(),
    }),
  ]),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      option: z
        .union([
          z.literal('meeting_authentication'),
          z.literal('recording_authentication'),
          z.literal('meeting_secuirty'),
        ])
        .optional(),
    })
    .optional(),
});

export const userSettingsUpdateResponseSchema = z.any();

export const userSettingsUpdateErrorSchema = z.unknown();

export const delUserVbDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      file_ids: z.string().optional(),
    })
    .optional(),
});

export const delUserVbResponseSchema = z.any();

export const delUserVbErrorSchema = z.unknown();

export const uploadVbuserDataSchema = z.object({
  body: z
    .object({
      file: z.string().optional(),
    })
    .optional(),
  path: z.object({
    userId: z.string(),
  }),
});

export const uploadVbuserResponseSchema = z.object({
  id: z.string().optional(),
  is_default: z.boolean().optional(),
  name: z.string().optional(),
  size: z.string().optional(),
  type: z.string().optional(),
});

export const uploadVbuserErrorSchema = z.unknown();

export const userStatusDataSchema = z.object({
  body: z.object({
    action: z.union([z.literal('activate'), z.literal('deactivate')]),
  }),
  path: z.object({
    userId: z.string(),
  }),
});

export const userStatusResponseSchema = z.union([z.unknown(), z.any()]);

export const userStatusErrorSchema = z.unknown();

export const userSsoTokenDeleteDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
});

export const userSsoTokenDeleteResponseSchema = z.any();

export const userSsoTokenDeleteErrorSchema = z.unknown();

export const userTokenDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      ttl: z.number().optional(),
      type: z.union([z.literal('token'), z.literal('zak')]).optional(),
    })
    .optional(),
});

export const userTokenResponseSchema = z.object({
  token: z.string().optional(),
});

export const userTokenErrorSchema = z.unknown();

export const userTsPsDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
});

export const userTsPsResponseSchema = z.object({
  tsp_accounts: z
    .array(
      z.object({
        conference_code: z.string(),
        dial_in_numbers: z
          .array(
            z.object({
              code: z.string().optional(),
              country_label: z.string().optional(),
              number: z.string().optional(),
              type: z.union([z.literal('toll'), z.literal('tollfree'), z.literal('media_link')]).optional(),
            }),
          )
          .optional(),
        id: z.union([z.literal(1), z.literal(2)]).optional(),
        leader_pin: z.string(),
        tsp_bridge: z.union([z.literal('US_TSP_TB'), z.literal('EU_TSP_TB')]).optional(),
      }),
    )
    .optional(),
});

export const userTsPsErrorSchema = z.unknown();

export const userTspCreateDataSchema = z.object({
  body: z.object({
    conference_code: z.string(),
    dial_in_numbers: z
      .array(
        z.object({
          code: z.string().optional(),
          country_label: z.string().optional(),
          number: z.string().optional(),
          type: z.union([z.literal('toll'), z.literal('tollfree'), z.literal('media_link')]).optional(),
        }),
      )
      .optional(),
    leader_pin: z.string(),
    tsp_bridge: z.union([z.literal('US_TSP_TB'), z.literal('EU_TSP_TB')]).optional(),
  }),
  path: z.object({
    userId: z.string(),
  }),
});

export const userTspCreateResponseSchema = z.object({
  conference_code: z.string(),
  dial_in_numbers: z
    .array(
      z.object({
        code: z.string().optional(),
        country_label: z.string().optional(),
        number: z.string().optional(),
        type: z.union([z.literal('toll'), z.literal('tollfree'), z.literal('media_link')]).optional(),
      }),
    )
    .optional(),
  leader_pin: z.string(),
  tsp_bridge: z.union([z.literal('US_TSP_TB'), z.literal('EU_TSP_TB')]).optional(),
});

export const userTspCreateErrorSchema = z.unknown();

export const tspUrlUpdateDataSchema = z.object({
  body: z
    .object({
      audio_url: z.string().optional(),
    })
    .optional(),
  path: z.object({
    userId: z.string(),
  }),
});

export const tspUrlUpdateResponseSchema = z.any();

export const tspUrlUpdateErrorSchema = z.unknown();

export const userTspDeleteDataSchema = z.object({
  path: z.object({
    tspId: z.union([z.literal(1), z.literal(2)]),
    userId: z.string(),
  }),
});

export const userTspDeleteResponseSchema = z.any();

export const userTspDeleteErrorSchema = z.unknown();

export const userTspDataSchema = z.object({
  path: z.object({
    tspId: z.union([z.literal(1), z.literal(2)]),
    userId: z.string(),
  }),
});

export const userTspResponseSchema = z.object({
  conference_code: z.string(),
  dial_in_numbers: z
    .array(
      z.object({
        code: z.string().optional(),
        country_label: z.string().optional(),
        number: z.string().optional(),
        type: z.union([z.literal('toll'), z.literal('tollfree'), z.literal('media_link')]).optional(),
      }),
    )
    .optional(),
  id: z.number().optional(),
  leader_pin: z.string(),
  tsp_bridge: z.union([z.literal('US_TSP_TB'), z.literal('EU_TSP_TB')]).optional(),
});

export const userTspErrorSchema = z.unknown();

export const userTspUpdateDataSchema = z.object({
  body: z.object({
    conference_code: z.string(),
    dial_in_numbers: z
      .array(
        z.object({
          code: z.string().optional(),
          country_label: z.string().optional(),
          number: z.string().optional(),
          type: z.union([z.literal('toll'), z.literal('tollfree'), z.literal('media_link')]).optional(),
        }),
      )
      .optional(),
    leader_pin: z.string(),
    tsp_bridge: z.union([z.literal('US_TSP_TB'), z.literal('EU_TSP_TB')]).optional(),
  }),
  path: z.object({
    tspId: z.union([z.literal(1), z.literal(2)]),
    userId: z.string(),
  }),
});

export const userTspUpdateResponseSchema = z.any();

export const userTspUpdateErrorSchema = z.unknown();

export const listWebinarTemplatesDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
});

export const listWebinarTemplatesResponseSchema = z.object({
  templates: z
    .array(
      z.object({
        id: z.string().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const listWebinarTemplatesErrorSchema = z.unknown();

export const webinarsDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      page_number: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const webinarsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      webinars: z
        .array(
          z.object({
            agenda: z.string().optional(),
            created_at: z.string().optional(),
            duration: z.number().optional(),
            host_id: z.string().optional(),
            id: z.number().optional(),
            join_url: z.string().optional(),
            start_time: z.string().optional(),
            timezone: z.string().optional(),
            topic: z.string().optional(),
            type: z.string().optional(),
            uuid: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const webinarsErrorSchema = z.unknown();

export const webinarCreateDataSchema = z.object({
  body: z.object({
    agenda: z.string().optional(),
    duration: z.number().optional(),
    password: z.string().optional(),
    recurrence: z
      .object({
        end_date_time: z.string().optional(),
        end_times: z.number().optional(),
        monthly_day: z.number().optional(),
        monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
        monthly_week_day: z
          .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
          .optional(),
        repeat_interval: z.number().optional(),
        type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
        weekly_days: z.string().optional(),
      })
      .optional(),
    settings: z
      .object({
        allow_multiple_devices: z.boolean().optional(),
        alternative_hosts: z.string().optional(),
        approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
        attendees_and_panelists_reminder_email_notification: z
          .object({
            enable: z.boolean().optional(),
            type: z
              .union([
                z.literal(0),
                z.literal(1),
                z.literal(2),
                z.literal(3),
                z.literal(4),
                z.literal(5),
                z.literal(6),
                z.literal(7),
              ])
              .optional(),
          })
          .optional(),
        audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
        authentication_domains: z.string().optional(),
        authentication_option: z.string().optional(),
        auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
        close_registration: z.boolean().optional(),
        contact_email: z.string().optional(),
        contact_name: z.string().optional(),
        email_language: z.string().optional(),
        enforce_login: z.boolean().optional(),
        enforce_login_domains: z.string().optional(),
        follow_up_absentees_email_notification: z
          .object({
            enable: z.boolean().optional(),
            type: z
              .union([
                z.literal(0),
                z.literal(1),
                z.literal(2),
                z.literal(3),
                z.literal(4),
                z.literal(5),
                z.literal(6),
                z.literal(7),
              ])
              .optional(),
          })
          .optional(),
        follow_up_attendees_email_notification: z
          .object({
            enable: z.boolean().optional(),
            type: z
              .union([
                z.literal(0),
                z.literal(1),
                z.literal(2),
                z.literal(3),
                z.literal(4),
                z.literal(5),
                z.literal(6),
                z.literal(7),
              ])
              .optional(),
          })
          .optional(),
        global_dial_in_countries: z.array(z.string()).optional(),
        hd_video: z.boolean().optional(),
        host_video: z.boolean().optional(),
        meeting_authentication: z.boolean().optional(),
        on_demand: z.boolean().optional(),
        panelists_invitation_email_notification: z.boolean().optional(),
        panelists_video: z.boolean().optional(),
        post_webinar_survey: z.boolean().optional(),
        practice_session: z.boolean().optional(),
        question_and_answer: z
          .object({
            allow_anonymous_questions: z.boolean().optional(),
            answer_questions: z.union([z.literal('only'), z.literal('all')]).optional(),
            attendees_can_comment: z.boolean().optional(),
            attendees_can_upvote: z.boolean().optional(),
            enable: z.boolean().optional(),
          })
          .optional(),
        registrants_email_notification: z.boolean().optional(),
        registrants_restrict_number: z.number().optional(),
        registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
        show_share_button: z.boolean().optional(),
        survey_url: z.string().optional(),
      })
      .optional(),
    start_time: z.string().optional(),
    timezone: z.string().optional(),
    topic: z.string().optional(),
    tracking_fields: z
      .array(
        z.object({
          field: z.string(),
          value: z.string().optional(),
        }),
      )
      .optional(),
    type: z.union([z.literal(5), z.literal(6), z.literal(9)]).optional(),
  }),
  path: z.object({
    userId: z.string(),
  }),
});

export const webinarCreateResponseSchema = z
  .object({
    host_email: z.string().optional(),
    host_id: z.string().optional(),
    id: z.number().optional(),
    registrants_confirmation_email: z.boolean().optional(),
    template_id: z.string().optional(),
    uuid: z.string().optional(),
  })
  .and(
    z.object({
      agenda: z.string().optional(),
      created_at: z.string().optional(),
      duration: z.number().optional(),
      join_url: z.string().optional(),
      occurrences: z
        .array(
          z.object({
            duration: z.number().optional(),
            occurrence_id: z.string().optional(),
            start_time: z.string().optional(),
            status: z.string().optional(),
          }),
        )
        .optional(),
      password: z.string().optional(),
      recurrence: z
        .object({
          end_date_time: z.string().optional(),
          end_times: z.number().optional(),
          monthly_day: z.number().optional(),
          monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
          monthly_week_day: z
            .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
            .optional(),
          repeat_interval: z.number().optional(),
          type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
          weekly_days: z.string().optional(),
        })
        .optional(),
      settings: z
        .object({
          allow_multiple_devices: z.boolean().optional(),
          alternative_hosts: z.string().optional(),
          approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
          attendees_and_panelists_reminder_email_notification: z
            .object({
              enable: z.boolean().optional(),
              type: z
                .union([
                  z.literal(0),
                  z.literal(1),
                  z.literal(2),
                  z.literal(3),
                  z.literal(4),
                  z.literal(5),
                  z.literal(6),
                  z.literal(7),
                ])
                .optional(),
            })
            .optional(),
          audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
          authentication_domains: z.string().optional(),
          authentication_name: z.string().optional(),
          authentication_option: z.string().optional(),
          auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
          close_registration: z.boolean().optional(),
          contact_email: z.string().optional(),
          contact_name: z.string().optional(),
          email_language: z.string().optional(),
          enforce_login: z.boolean().optional(),
          enforce_login_domains: z.string().optional(),
          follow_up_absentees_email_notification: z
            .object({
              enable: z.boolean().optional(),
              type: z
                .union([
                  z.literal(0),
                  z.literal(1),
                  z.literal(2),
                  z.literal(3),
                  z.literal(4),
                  z.literal(5),
                  z.literal(6),
                  z.literal(7),
                ])
                .optional(),
            })
            .optional(),
          follow_up_attendees_email_notification: z
            .object({
              enable: z.boolean().optional(),
              type: z
                .union([
                  z.literal(0),
                  z.literal(1),
                  z.literal(2),
                  z.literal(3),
                  z.literal(4),
                  z.literal(5),
                  z.literal(6),
                  z.literal(7),
                ])
                .optional(),
            })
            .optional(),
          global_dial_in_countries: z.array(z.string()).optional(),
          hd_video: z.boolean().optional(),
          host_video: z.boolean().optional(),
          meeting_authentication: z.boolean().optional(),
          notify_registrants: z.boolean().optional(),
          on_demand: z.boolean().optional(),
          panelists_invitation_email_notification: z.boolean().optional(),
          panelists_video: z.boolean().optional(),
          post_webinar_survey: z.boolean().optional(),
          practice_session: z.boolean().optional(),
          question_and_answer: z
            .object({
              allow_anonymous_questions: z.boolean().optional(),
              answer_questions: z.union([z.literal('only'), z.literal('all')]).optional(),
              attendees_can_comment: z.boolean().optional(),
              attendees_can_upvote: z.boolean().optional(),
              enable: z.boolean().optional(),
            })
            .optional(),
          registrants_confirmation_email: z.boolean().optional(),
          registrants_email_notification: z.boolean().optional(),
          registrants_restrict_number: z.number().optional(),
          registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
          show_share_button: z.boolean().optional(),
          survey_url: z.string().optional(),
        })
        .optional(),
      start_time: z.string().optional(),
      start_url: z.string().optional(),
      timezone: z.string().optional(),
      topic: z.string().optional(),
      tracking_fields: z
        .array(
          z.object({
            field: z.string().optional(),
            value: z.string().optional(),
          }),
        )
        .optional(),
      type: z.union([z.literal(5), z.literal(6), z.literal(9)]).optional(),
    }),
  );

export const webinarCreateErrorSchema = z.unknown();

export const webinarDeleteDataSchema = z.object({
  path: z.object({
    webinarId: z.number(),
  }),
  query: z
    .object({
      cancel_webinar_reminder: z.string().optional(),
      occurrence_id: z.string().optional(),
    })
    .optional(),
});

export const webinarDeleteResponseSchema = z.union([z.unknown(), z.any()]);

export const webinarDeleteErrorSchema = z.unknown();

export const webinarDataSchema = z.object({
  path: z.object({
    webinarId: z.number(),
  }),
  query: z
    .object({
      occurrence_id: z.string().optional(),
      show_previous_occurrences: z.boolean().optional(),
    })
    .optional(),
});

export const webinarResponseSchema = z
  .object({
    host_email: z.string().optional(),
    host_id: z.string().optional(),
    id: z.number().optional(),
    uuid: z.string().optional(),
  })
  .and(
    z.object({
      agenda: z.string().optional(),
      created_at: z.string().optional(),
      duration: z.number().optional(),
      join_url: z.string().optional(),
      occurrences: z
        .array(
          z.object({
            duration: z.number().optional(),
            occurrence_id: z.string().optional(),
            start_time: z.string().optional(),
            status: z.string().optional(),
          }),
        )
        .optional(),
      password: z.string().optional(),
      recurrence: z
        .object({
          end_date_time: z.string().optional(),
          end_times: z.number().optional(),
          monthly_day: z.number().optional(),
          monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
          monthly_week_day: z
            .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
            .optional(),
          repeat_interval: z.number().optional(),
          type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
          weekly_days: z.string().optional(),
        })
        .optional(),
      settings: z
        .object({
          allow_multiple_devices: z.boolean().optional(),
          alternative_hosts: z.string().optional(),
          approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
          attendees_and_panelists_reminder_email_notification: z
            .object({
              enable: z.boolean().optional(),
              type: z
                .union([
                  z.literal(0),
                  z.literal(1),
                  z.literal(2),
                  z.literal(3),
                  z.literal(4),
                  z.literal(5),
                  z.literal(6),
                  z.literal(7),
                ])
                .optional(),
            })
            .optional(),
          audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
          authentication_domains: z.string().optional(),
          authentication_name: z.string().optional(),
          authentication_option: z.string().optional(),
          auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
          close_registration: z.boolean().optional(),
          contact_email: z.string().optional(),
          contact_name: z.string().optional(),
          email_language: z.string().optional(),
          enforce_login: z.boolean().optional(),
          enforce_login_domains: z.string().optional(),
          follow_up_absentees_email_notification: z
            .object({
              enable: z.boolean().optional(),
              type: z
                .union([
                  z.literal(0),
                  z.literal(1),
                  z.literal(2),
                  z.literal(3),
                  z.literal(4),
                  z.literal(5),
                  z.literal(6),
                  z.literal(7),
                ])
                .optional(),
            })
            .optional(),
          follow_up_attendees_email_notification: z
            .object({
              enable: z.boolean().optional(),
              type: z
                .union([
                  z.literal(0),
                  z.literal(1),
                  z.literal(2),
                  z.literal(3),
                  z.literal(4),
                  z.literal(5),
                  z.literal(6),
                  z.literal(7),
                ])
                .optional(),
            })
            .optional(),
          global_dial_in_countries: z.array(z.string()).optional(),
          hd_video: z.boolean().optional(),
          host_video: z.boolean().optional(),
          meeting_authentication: z.boolean().optional(),
          notify_registrants: z.boolean().optional(),
          on_demand: z.boolean().optional(),
          panelists_invitation_email_notification: z.boolean().optional(),
          panelists_video: z.boolean().optional(),
          post_webinar_survey: z.boolean().optional(),
          practice_session: z.boolean().optional(),
          question_and_answer: z
            .object({
              allow_anonymous_questions: z.boolean().optional(),
              answer_questions: z.union([z.literal('only'), z.literal('all')]).optional(),
              attendees_can_comment: z.boolean().optional(),
              attendees_can_upvote: z.boolean().optional(),
              enable: z.boolean().optional(),
            })
            .optional(),
          registrants_confirmation_email: z.boolean().optional(),
          registrants_email_notification: z.boolean().optional(),
          registrants_restrict_number: z.number().optional(),
          registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
          show_share_button: z.boolean().optional(),
          survey_url: z.string().optional(),
        })
        .optional(),
      start_time: z.string().optional(),
      start_url: z.string().optional(),
      timezone: z.string().optional(),
      topic: z.string().optional(),
      tracking_fields: z
        .array(
          z.object({
            field: z.string().optional(),
            value: z.string().optional(),
          }),
        )
        .optional(),
      type: z.union([z.literal(5), z.literal(6), z.literal(9)]).optional(),
    }),
  );

export const webinarErrorSchema = z.unknown();

export const webinarUpdateDataSchema = z.object({
  body: z.object({
    agenda: z.string().optional(),
    duration: z.number().optional(),
    password: z.string().optional(),
    recurrence: z
      .object({
        end_date_time: z.string().optional(),
        end_times: z.number().optional(),
        monthly_day: z.number().optional(),
        monthly_week: z.union([z.literal(-1), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]).optional(),
        monthly_week_day: z
          .union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5), z.literal(6), z.literal(7)])
          .optional(),
        repeat_interval: z.number().optional(),
        type: z.union([z.literal(1), z.literal(2), z.literal(3)]),
        weekly_days: z
          .union([
            z.literal('1'),
            z.literal('2'),
            z.literal('3'),
            z.literal('4'),
            z.literal('5'),
            z.literal('6'),
            z.literal('7'),
          ])
          .optional(),
      })
      .optional(),
    settings: z
      .object({
        allow_multiple_devices: z.boolean().optional(),
        alternative_hosts: z.string().optional(),
        approval_type: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
        attendees_and_panelists_reminder_email_notification: z
          .object({
            enable: z.boolean().optional(),
            type: z
              .union([
                z.literal(0),
                z.literal(1),
                z.literal(2),
                z.literal(3),
                z.literal(4),
                z.literal(5),
                z.literal(6),
                z.literal(7),
              ])
              .optional(),
          })
          .optional(),
        audio: z.union([z.literal('both'), z.literal('telephony'), z.literal('voip')]).optional(),
        authentication_domains: z.string().optional(),
        authentication_name: z.string().optional(),
        authentication_option: z.string().optional(),
        auto_recording: z.union([z.literal('local'), z.literal('cloud'), z.literal('none')]).optional(),
        close_registration: z.boolean().optional(),
        contact_email: z.string().optional(),
        contact_name: z.string().optional(),
        email_language: z.string().optional(),
        enforce_login: z.boolean().optional(),
        enforce_login_domains: z.string().optional(),
        follow_up_absentees_email_notification: z
          .object({
            enable: z.boolean().optional(),
            type: z
              .union([
                z.literal(0),
                z.literal(1),
                z.literal(2),
                z.literal(3),
                z.literal(4),
                z.literal(5),
                z.literal(6),
                z.literal(7),
              ])
              .optional(),
          })
          .optional(),
        follow_up_attendees_email_notification: z
          .object({
            enable: z.boolean().optional(),
            type: z
              .union([
                z.literal(0),
                z.literal(1),
                z.literal(2),
                z.literal(3),
                z.literal(4),
                z.literal(5),
                z.literal(6),
                z.literal(7),
              ])
              .optional(),
          })
          .optional(),
        global_dial_in_countries: z.array(z.string()).optional(),
        hd_video: z.boolean().optional(),
        host_video: z.boolean().optional(),
        meeting_authentication: z.boolean().optional(),
        notify_registrants: z.boolean().optional(),
        on_demand: z.boolean().optional(),
        panelists_invitation_email_notification: z.boolean().optional(),
        panelists_video: z.boolean().optional(),
        post_webinar_survey: z.boolean().optional(),
        practice_session: z.boolean().optional(),
        question_and_answer: z
          .object({
            allow_anonymous_questions: z.boolean().optional(),
            answer_questions: z.union([z.literal('only'), z.literal('all')]).optional(),
            attendees_can_comment: z.boolean().optional(),
            attendees_can_upvote: z.boolean().optional(),
            enable: z.boolean().optional(),
          })
          .optional(),
        registrants_confirmation_email: z.boolean().optional(),
        registrants_email_notification: z.boolean().optional(),
        registrants_restrict_number: z.number().optional(),
        registration_type: z.union([z.literal(1), z.literal(2), z.literal(3)]).optional(),
        show_share_button: z.boolean().optional(),
        survey_url: z.string().optional(),
      })
      .and(
        z.object({
          registrants_confirmation_email: z.boolean().optional(),
        }),
      )
      .optional(),
    start_time: z.string().optional(),
    timezone: z.string().optional(),
    topic: z.string().optional(),
    tracking_fields: z
      .array(
        z.object({
          field: z.string().optional(),
          value: z.string().optional(),
        }),
      )
      .optional(),
    type: z.union([z.literal(5), z.literal(6), z.literal(9)]).optional(),
  }),
  path: z.object({
    webinarId: z.number(),
  }),
  query: z
    .object({
      occurrence_id: z.string().optional(),
    })
    .optional(),
});

export const webinarUpdateResponseSchema = z.union([z.unknown(), z.any()]);

export const webinarUpdateErrorSchema = z.unknown();

export const addBatchWebinarRegistrantsDataSchema = z.object({
  body: z
    .object({
      auto_approve: z.boolean().optional(),
      registrants: z
        .array(
          z.object({
            email: z.string(),
            first_name: z.string(),
            last_name: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  path: z.object({
    webinarId: z.string(),
  }),
});

export const addBatchWebinarRegistrantsResponseSchema = z.object({
  registrants: z
    .array(
      z.object({
        email: z.string().optional(),
        join_url: z.string().optional(),
        registrant_id: z.string().optional(),
      }),
    )
    .optional(),
});

export const addBatchWebinarRegistrantsErrorSchema = z.unknown();

export const webinarPanelistsDeleteDataSchema = z.object({
  path: z.object({
    webinarId: z.number(),
  }),
});

export const webinarPanelistsDeleteResponseSchema = z.any();

export const webinarPanelistsDeleteErrorSchema = z.unknown();

export const webinarPanelistsDataSchema = z.object({
  path: z.object({
    webinarId: z.number(),
  }),
});

export const webinarPanelistsResponseSchema = z.object({
  panelists: z
    .array(
      z
        .object({
          id: z.string().optional(),
        })
        .and(
          z.object({
            email: z.string().optional(),
            name: z.string().optional(),
          }),
        )
        .and(
          z.object({
            join_url: z.string().optional(),
          }),
        ),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const webinarPanelistsErrorSchema = z.unknown();

export const webinarPanelistCreateDataSchema = z.object({
  body: z.object({
    panelists: z
      .array(
        z.object({
          email: z.string().optional(),
          name: z.string().optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    webinarId: z.number(),
  }),
});

export const webinarPanelistCreateResponseSchema = z.union([
  z.unknown(),
  z.object({
    id: z.string().optional(),
    updated_at: z.string().optional(),
  }),
]);

export const webinarPanelistCreateErrorSchema = z.unknown();

export const webinarPanelistDeleteDataSchema = z.object({
  path: z.object({
    panelistId: z.number(),
    webinarId: z.number(),
  }),
});

export const webinarPanelistDeleteResponseSchema = z.union([z.unknown(), z.any()]);

export const webinarPanelistDeleteErrorSchema = z.unknown();

export const webinarPollsDataSchema = z.object({
  path: z.object({
    webinarId: z.number(),
  }),
});

export const webinarPollsResponseSchema = z.object({
  polls: z
    .array(
      z
        .object({
          id: z.string().optional(),
          status: z
            .union([z.literal('notstart'), z.literal('started'), z.literal('ended'), z.literal('sharing')])
            .optional(),
        })
        .and(
          z.object({
            questions: z
              .array(
                z.object({
                  answers: z.array(z.string()).optional(),
                  name: z.string().optional(),
                  type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
                }),
              )
              .optional(),
            title: z.string().optional(),
          }),
        ),
    )
    .optional(),
  total_records: z.number().optional(),
});

export const webinarPollsErrorSchema = z.unknown();

export const webinarPollCreateDataSchema = z.object({
  body: z.object({
    questions: z
      .array(
        z.object({
          answers: z.array(z.string()).optional(),
          name: z.string().optional(),
          type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
        }),
      )
      .optional(),
    title: z.string().optional(),
  }),
  path: z.object({
    webinarId: z.number(),
  }),
});

export const webinarPollCreateResponseSchema = z
  .object({
    id: z.string().optional(),
    status: z.union([z.literal('notstart'), z.literal('started'), z.literal('ended'), z.literal('sharing')]).optional(),
  })
  .and(
    z.object({
      questions: z
        .array(
          z.object({
            answers: z.array(z.string()).optional(),
            name: z.string().optional(),
            type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
          }),
        )
        .optional(),
      title: z.string().optional(),
    }),
  );

export const webinarPollCreateErrorSchema = z.unknown();

export const webinarPollDeleteDataSchema = z.object({
  path: z.object({
    pollId: z.string(),
    webinarId: z.number(),
  }),
});

export const webinarPollDeleteResponseSchema = z.any();

export const webinarPollDeleteErrorSchema = z.unknown();

export const webinarPollGetDataSchema = z.object({
  path: z.object({
    pollId: z.string(),
    webinarId: z.number(),
  }),
});

export const webinarPollGetResponseSchema = z
  .object({
    id: z.string().optional(),
    status: z.union([z.literal('notstart'), z.literal('started'), z.literal('ended'), z.literal('sharing')]).optional(),
  })
  .and(
    z.object({
      questions: z
        .array(
          z.object({
            answers: z.array(z.string()).optional(),
            name: z.string().optional(),
            type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
          }),
        )
        .optional(),
      title: z.string().optional(),
    }),
  );

export const webinarPollGetErrorSchema = z.unknown();

export const webinarPollUpdateDataSchema = z.object({
  body: z.object({
    questions: z
      .array(
        z.object({
          answers: z.array(z.string()).optional(),
          name: z.string().optional(),
          type: z.union([z.literal('single'), z.literal('multiple')]).optional(),
        }),
      )
      .optional(),
    title: z.string().optional(),
  }),
  path: z.object({
    pollId: z.string(),
    webinarId: z.number(),
  }),
});

export const webinarPollUpdateResponseSchema = z.any();

export const webinarPollUpdateErrorSchema = z.unknown();

export const webinarRegistrantsDataSchema = z.object({
  path: z.object({
    webinarId: z.number(),
  }),
  query: z
    .object({
      next_page_token: z.string().optional(),
      occurrence_id: z.string().optional(),
      page_number: z.number().optional(),
      page_size: z.number().optional(),
      status: z.union([z.literal('pending'), z.literal('approved'), z.literal('denied')]).optional(),
      tracking_source_id: z.string().optional(),
    })
    .optional(),
});

export const webinarRegistrantsResponseSchema = z
  .object({
    next_page_token: z.string().optional(),
    page_count: z.number().optional(),
    page_number: z.number().optional(),
    page_size: z.number().optional(),
    total_records: z.number().optional(),
  })
  .and(
    z.object({
      registrants: z
        .array(
          z
            .object({
              id: z.string().optional(),
            })
            .and(
              z.object({
                address: z.string().optional(),
                city: z.string().optional(),
                comments: z.string().optional(),
                country: z.string().optional(),
                custom_questions: z
                  .array(
                    z.object({
                      title: z.string().optional(),
                      value: z.string().optional(),
                    }),
                  )
                  .optional(),
                email: z.string(),
                first_name: z.string(),
                industry: z.string().optional(),
                job_title: z.string().optional(),
                last_name: z.string().optional(),
                no_of_employees: z.string().optional(),
                org: z.string().optional(),
                phone: z.string().optional(),
                purchasing_time_frame: z.string().optional(),
                role_in_purchase_process: z.string().optional(),
                state: z.string().optional(),
                zip: z.string().optional(),
              }),
            )
            .and(
              z.object({
                create_time: z.string().optional(),
                join_url: z.string().optional(),
                status: z.string().optional(),
              }),
            ),
        )
        .optional(),
    }),
  );

export const webinarRegistrantsErrorSchema = z.unknown();

export const webinarRegistrantCreateDataSchema = z.object({
  body: z.object({
    address: z.string().optional(),
    city: z.string().optional(),
    comments: z.string().optional(),
    country: z.string().optional(),
    custom_questions: z
      .array(
        z.object({
          title: z.string().optional(),
          value: z.string().optional(),
        }),
      )
      .optional(),
    email: z.string(),
    first_name: z.string(),
    industry: z.string().optional(),
    job_title: z.string().optional(),
    last_name: z.string().optional(),
    no_of_employees: z.string().optional(),
    org: z.string().optional(),
    phone: z.string().optional(),
    purchasing_time_frame: z.string().optional(),
    role_in_purchase_process: z.string().optional(),
    state: z.string().optional(),
    zip: z.string().optional(),
  }),
  path: z.object({
    webinarId: z.number(),
  }),
  query: z
    .object({
      occurrence_ids: z.string().optional(),
    })
    .optional(),
});

export const webinarRegistrantCreateResponseSchema = z.object({
  id: z.string().optional(),
  join_url: z.string().optional(),
  registrant_id: z.string().optional(),
  start_time: z.string().optional(),
  topic: z.string().optional(),
});

export const webinarRegistrantCreateErrorSchema = z.unknown();

export const webinarRegistrantsQuestionsGetDataSchema = z.object({
  path: z.object({
    webinarId: z.number(),
  }),
});

export const webinarRegistrantsQuestionsGetResponseSchema = z.object({
  custom_questions: z
    .array(
      z.object({
        answers: z.array(z.string()).optional(),
        required: z.boolean().optional(),
        title: z.string().optional(),
        type: z
          .union([z.literal('short'), z.literal('single_radio'), z.literal('single_dropdown'), z.literal('multiple')])
          .optional(),
      }),
    )
    .optional(),
  questions: z
    .array(
      z.object({
        field_name: z
          .union([
            z.literal('last_name'),
            z.literal('address'),
            z.literal('city'),
            z.literal('country'),
            z.literal('zip'),
            z.literal('state'),
            z.literal('phone'),
            z.literal('industry'),
            z.literal('org'),
            z.literal('job_title'),
            z.literal('purchasing_time_frame'),
            z.literal('role_in_purchase_process'),
            z.literal('no_of_employees'),
            z.literal('comments'),
          ])
          .optional(),
        required: z.boolean().optional(),
      }),
    )
    .optional(),
});

export const webinarRegistrantsQuestionsGetErrorSchema = z.unknown();

export const webinarRegistrantQuestionUpdateDataSchema = z.object({
  body: z.object({
    custom_questions: z
      .array(
        z.object({
          answers: z.array(z.string()).optional(),
          required: z.boolean().optional(),
          title: z.string().optional(),
          type: z
            .union([z.literal('short'), z.literal('single_radio'), z.literal('single_dropdown'), z.literal('multiple')])
            .optional(),
        }),
      )
      .optional(),
    questions: z
      .array(
        z.object({
          field_name: z
            .union([
              z.literal('last_name'),
              z.literal('address'),
              z.literal('city'),
              z.literal('country'),
              z.literal('zip'),
              z.literal('state'),
              z.literal('phone'),
              z.literal('industry'),
              z.literal('org'),
              z.literal('job_title'),
              z.literal('purchasing_time_frame'),
              z.literal('role_in_purchase_process'),
              z.literal('no_of_employees'),
              z.literal('comments'),
            ])
            .optional(),
          required: z.boolean().optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    webinarId: z.number(),
  }),
});

export const webinarRegistrantQuestionUpdateResponseSchema = z.any();

export const webinarRegistrantQuestionUpdateErrorSchema = z.unknown();

export const webinarRegistrantStatusDataSchema = z.object({
  body: z.object({
    action: z.union([z.literal('approve'), z.literal('cancel'), z.literal('deny')]),
    registrants: z
      .array(
        z.object({
          email: z.string().optional(),
          id: z.string().optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    webinarId: z.number(),
  }),
  query: z
    .object({
      occurrence_id: z.string().optional(),
    })
    .optional(),
});

export const webinarRegistrantStatusResponseSchema = z.unknown();

export const webinarRegistrantStatusErrorSchema = z.unknown();

export const deleteWebinarRegistrantDataSchema = z.object({
  path: z.object({
    registrantId: z.string(),
    webinarId: z.number(),
  }),
  query: z
    .object({
      occurrence_id: z.string().optional(),
    })
    .optional(),
});

export const deleteWebinarRegistrantResponseSchema = z.any();

export const deleteWebinarRegistrantErrorSchema = z.unknown();

export const webinarRegistrantGetDataSchema = z.object({
  path: z.object({
    registrantId: z.string(),
    webinarId: z.number(),
  }),
  query: z
    .object({
      occurrence_id: z.string().optional(),
    })
    .optional(),
});

export const webinarRegistrantGetResponseSchema = z
  .object({
    id: z.string().optional(),
  })
  .and(
    z.object({
      address: z.string().optional(),
      city: z.string().optional(),
      comments: z.string().optional(),
      country: z.string().optional(),
      custom_questions: z
        .array(
          z.object({
            title: z.string().optional(),
            value: z.string().optional(),
          }),
        )
        .optional(),
      email: z.string(),
      first_name: z.string(),
      industry: z.string().optional(),
      job_title: z.string().optional(),
      last_name: z.string().optional(),
      no_of_employees: z.string().optional(),
      org: z.string().optional(),
      phone: z.string().optional(),
      purchasing_time_frame: z.string().optional(),
      role_in_purchase_process: z.string().optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
    }),
  )
  .and(
    z.object({
      create_time: z.string().optional(),
      join_url: z.string().optional(),
      status: z.string().optional(),
    }),
  );

export const webinarRegistrantGetErrorSchema = z.unknown();

export const webinarStatusDataSchema = z.object({
  body: z.object({
    action: z.literal('end').optional(),
  }),
  path: z.object({
    webinarId: z.number(),
  }),
});

export const webinarStatusResponseSchema = z.union([z.unknown(), z.any()]);

export const webinarStatusErrorSchema = z.unknown();

export const getTrackingSourcesDataSchema = z.object({
  path: z.object({
    webinarId: z.number(),
  }),
});

export const getTrackingSourcesResponseSchema = z.object({
  total_records: z.number().optional(),
  tracking_sources: z
    .array(
      z.object({
        id: z.string().optional(),
        registration_count: z.number().optional(),
        source_name: z.string().optional(),
        tracking_url: z.string().optional(),
        visitor_count: z.number().optional(),
      }),
    )
    .optional(),
});

export const getTrackingSourcesErrorSchema = z.unknown();
