// This file is auto-generated by @hey-api/openapi-ts

/**
 * The account object represents an account on Zoom. The account owner is the user who created the account or had an account created for them. You can read more about the Zoom account structure <a href='https://medium.com/zoom-developer-blog/a-brief-look-at-zoom-account-structures-1d19c745bf8a' target='_blank'>here</a>.
 */
export type Account = {
  /**
   * User's email address.
   */
  email: string;
  /**
   * User's first name.
   */
  first_name: string;
  /**
   * User's last name.
   */
  last_name: string;
  /**
   * Account options object.
   */
  options?: {
    /**
     * Toggle whether automatic billing renewal is on or off.
     */
    billing_auto_renew?: boolean;
    /**
     * Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.
     *
     *
     * **Note:** This option can only be used if the value of `share_mc` is set to `true`.
     */
    meeting_connector_list?: Array<string>;
    /**
     * Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.
     */
    pay_mode?: 'master' | 'sub';
    /**
     * Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.
     *
     *
     * **Note:** This option can only be used if the value of `share_rc` is set to `true`.
     */
    room_connector_list?: Array<string>;
    /**
     * Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.
     */
    share_mc?: boolean;
    /**
     * Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.
     */
    share_rc?: boolean;
  };
  /**
   * User's password.
   */
  password: string;
  /**
   * Account Vanity URL
   */
  vanity_url?: string;
};

/**
 * Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.
 */
export type pay_mode = 'master' | 'sub';

/**
 * List of Accounts.
 */
export type AccountList = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of Account objects.
   */
  accounts?: Array<{
    /**
     * Account name.
     */
    account_name?: string;
    /**
     * Account Number of the account.
     */
    account_number?: string;
    /**
     * Account type.
     */
    account_type?: string;
    /**
     * Account creation date and time.
     */
    created_at?: string;
    /**
     * Account ID.
     */
    id?: string;
    /**
     * Account owner email.
     */
    owner_email?: string;
    /**
     * Account seats.
     */
    seats?: number;
    /**
     * Account subscription end date and time.
     */
    subscription_end_time?: string;
    /**
     * Account subscription start date and time.
     */
    subscription_start_time?: string;
  }>;
};

/**
 * Account object in the account list.
 */
export type AccountListItem = {
  /**
   * List of Account objects.
   */
  accounts?: Array<{
    /**
     * Account name.
     */
    account_name?: string;
    /**
     * Account Number of the account.
     */
    account_number?: string;
    /**
     * Account type.
     */
    account_type?: string;
    /**
     * Account creation date and time.
     */
    created_at?: string;
    /**
     * Account ID.
     */
    id?: string;
    /**
     * Account owner email.
     */
    owner_email?: string;
    /**
     * Account seats.
     */
    seats?: number;
    /**
     * Account subscription end date and time.
     */
    subscription_end_time?: string;
    /**
     * Account subscription start date and time.
     */
    subscription_start_time?: string;
  }>;
};

/**
 * Account options object.
 */
export type AccountOptions = {
  /**
   * Toggle whether automatic billing renewal is on or off.
   */
  billing_auto_renew?: boolean;
  /**
   * Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.
   *
   *
   * **Note:** This option can only be used if the value of `share_mc` is set to `true`.
   */
  meeting_connector_list?: Array<string>;
  /**
   * Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.
   */
  pay_mode?: 'master' | 'sub';
  /**
   * Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.
   *
   *
   * **Note:** This option can only be used if the value of `share_rc` is set to `true`.
   */
  room_connector_list?: Array<string>;
  /**
   * Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.
   */
  share_mc?: boolean;
  /**
   * Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.
   */
  share_rc?: boolean;
};

/**
 * Account plan object.
 */
export type AccountPlan = {
  /**
   * Account plan number of hosts.
   */
  hosts?: number;
  /**
   * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
   */
  type?: string;
};

/**
 * Account base plan object.
 */
export type AccountPlanBaseRequired = {
  /**
   * Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.
   */
  hosts: number;
  /**
   * Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
   */
  type: string;
};

/**
 * Account plan object.
 */
export type AccountPlanRequired = {
  /**
   * Number of hosts for this plan.
   */
  hosts: number;
  /**
   * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
   */
  type: string;
};

/**
 * Account Plans object.
 */
export type AccountPlans = {
  /**
   * Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.
   */
  plan_audio?: {
    /**
     * Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.
     */
    callout_countries?: string;
    /**
     * Dedicated dial-In numbers.
     */
    ddi_numbers?: number;
    /**
     * Premium countries: multiple values should be separated by commas. For a list of allowed values, refer to the "ID" field in the [Premium Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#premium-countries) table.
     */
    premium_countries?: string;
    /**
     * Toll-free countries: multiple values should separated by a comma. For a list of allowed values, refer to the "ID" field in the [Toll Free Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#toll-free-countries) table.
     */
    tollfree_countries?: string;
    /**
     * Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.
     */
    type?: string;
  };
  /**
   * Account base plan object.
   */
  plan_base: {
    /**
     * Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.
     */
    hosts: number;
    /**
     * Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
     */
    type: string;
  };
  /**
   * Additional large meeting Plans.
   */
  plan_large_meeting?: Array<{
    /**
     * Account plan number of hosts.
     */
    hosts?: number;
    /**
     * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
     */
    type?: string;
  }>;
  /**
   * Phone Plan Object
   */
  plan_phone?: {
    /**
     * Additional phone base plans.
     */
    plan_base?: {
      /**
       * Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.
       */
      callout_countries?: string;
      /**
       * Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
       */
      type?: string;
    };
    /**
     * Additional phone calling plans.
     */
    plan_calling?: Array<{
      hosts?: number;
      /**
       * Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
       */
      type?: string;
    }>;
    /**
     * Additional phone number plans.
     */
    plan_number?: Array<{
      hosts?: number;
      /**
       * Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
       */
      type?: string;
    }>;
  };
  /**
   * Additional cloud recording plan.
   */
  plan_recording?: string;
  /**
   * Account plan object.
   */
  plan_room_connector?: {
    /**
     * Account plan number of hosts.
     */
    hosts?: number;
    /**
     * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
     */
    type?: string;
  };
  /**
   * Additional webinar plans.
   */
  plan_webinar?: Array<{
    /**
     * Account plan number of hosts.
     */
    hosts?: number;
    /**
     * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
     */
    type?: string;
  }>;
  /**
   * Account plan object.
   */
  plan_zoom_rooms?: {
    /**
     * Account plan number of hosts.
     */
    hosts?: number;
    /**
     * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
     */
    type?: string;
  };
};

export type AccountSettings = {
  /**
   * Account Settings: Notification.
   */
  email_notification?: {
    /**
     * Notify when an alternative host is set or removed from a meeting.
     */
    alternative_host_reminder?: boolean;
    /**
     * Notify the host and participants when a meeting is cancelled.
     */
    cancel_meeting_reminder?: boolean;
    /**
     * Notify host when cloud recording is available.
     */
    cloud_recording_avaliable_reminder?: boolean;
    /**
     * Notify the host when participants join the meeting before them.
     */
    jbh_reminder?: boolean;
    /**
     * Notify user when host licenses are running low.
     */
    low_host_count_reminder?: boolean;
    /**
     * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
     */
    schedule_for_reminder?: boolean;
  };
  /**
   * Account Settings: Feature.
   */
  feature?: {
    /**
     * Set the maximum number of participants a host can have in a single meeting.
     */
    meeting_capacity?: number;
  };
  /**
   * Account Settings: In Meeting.
   */
  in_meeting?: {
    /**
     * Identify guest participants in a meeting or webinar.
     */
    alert_guest_join?: boolean;
    /**
     * Allow live streaming.
     */
    allow_live_streaming?: boolean;
    /**
     * If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.
     *
     */
    allow_participants_to_rename?: boolean;
    /**
     * Show the Zoom desktop application when sharing screens.
     */
    allow_show_zoom_windows?: boolean;
    /**
     * Allow participants to use annotation tools to add information to shared screens.
     */
    annotation?: boolean;
    /**
     * Allow an anonymous Q&A in a webinar.
     */
    anonymous_question_answer?: boolean;
    /**
     * Allow host to put attendee on hold.
     *
     * **This field has been deprecated and is no longer supported.**
     */
    attendee_on_hold?: boolean;
    /**
     * Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.
     */
    auto_answer?: boolean;
    /**
     * Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.
     */
    auto_saving_chat?: boolean;
    /**
     * Allow host to split meeting participants into separate, smaller rooms.
     */
    breakout_room?: boolean;
    /**
     * Allow meeting participants to send a message that is visible to all participants.
     */
    chat?: boolean;
    /**
     * Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions.
     */
    closed_caption?: boolean;
    /**
     * Allow the host to add co-hosts.
     */
    co_host?: boolean;
    /**
     * If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.
     */
    custom_data_center_regions?: boolean;
    /**
     * Custom live streaming.
     */
    custom_live_streaming_service?: boolean;
    /**
     * Custom service instructions.
     */
    custom_service_instructions?: string;
    /**
     * If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).
     *
     */
    data_center_regions?: 'EU' | 'HK' | 'AU' | 'IN' | 'TY' | 'CN' | 'US' | 'CA';
    /**
     * DSCP audio.
     */
    dscp_audio?: number;
    /**
     * DSCP marking.
     */
    dscp_marking?: boolean;
    /**
     * DSCP video.
     */
    dscp_video?: number;
    /**
     * Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).
     */
    e2e_encryption?: boolean;
    /**
     * Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.
     */
    entry_exit_chime?: 'host' | 'all' | 'none';
    /**
     * Allow another user to take control of your camera during a meeting.
     */
    far_end_camera_control?: boolean;
    /**
     * Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.
     */
    feedback?: boolean;
    /**
     * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.
     */
    file_transfer?: boolean;
    /**
     * Activate higher quality video for host and participants.
     * Please note: This will use more bandwidth.
     */
    group_hd?: boolean;
    /**
     * Enable or disable meeting reactions. <br>
     * `true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>
     * `false`: Do not enable meeting reactions.
     */
    meeting_reactions?: boolean;
    /**
     * Allow users to select original sound in their client settings.
     */
    original_audio?: boolean;
    /**
     * Peer to peer connection while only two people are in a meeting.
     */
    p2p_connetion?: boolean;
    /**
     * Peer to peer listening ports range.
     */
    p2p_ports?: boolean;
    /**
     * Add "Polls" to the meeting controls.
     */
    polling?: boolean;
    /**
     * The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.
     */
    ports_range?: string;
    /**
     * Display a thumbs up or down survey at the end of each meeting.
     */
    post_meeting_feedback?: boolean;
    /**
     * Allow a meeting participant to send a private message to another participant.
     */
    private_chat?: boolean;
    /**
     * Record and play their own voice.
     */
    record_play_own_voice?: boolean;
    /**
     * Allow users to request remote control.
     */
    remote_control?: boolean;
    /**
     * Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.
     */
    request_permission_to_unmute?: boolean;
    /**
     * Allow screen sharing.
     */
    screen_sharing?: boolean;
    /**
     * Only show the default email when sending email invites.
     */
    sending_default_email_invites?: boolean;
    /**
     * If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.
     */
    show_a_join_from_your_browser_link?: boolean;
    /**
     * Always show the meeting control toolbar.
     */
    show_meeting_control_toolbar?: boolean;
    /**
     * Allow users to select stereo audio in their client settings.
     */
    stereo_audio?: boolean;
    /**
     * Use HTML formatted email for the Outlook plugin.
     */
    use_html_format_email?: boolean;
    /**
     * Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.
     */
    virtual_background?: boolean;
    /**
     * Settings to manage virtual background.
     */
    virtual_background_settings?: {
      /**
       * Allow users to upload custom backgrounds.
       */
      allow_upload_custom?: boolean;
      /**
       * Allow use of videos for virtual backgrounds.
       */
      allow_videos?: boolean;
      /**
       * Enable virtual background.
       */
      enable?: boolean;
      files?: Array<{
        /**
         * Unique identifier of the file.
         */
        id?: string;
        /**
         * Indicates whether or not this file is the default virtual background file.
         */
        is_default?: boolean;
        /**
         * File name.
         */
        name?: string;
        /**
         * File size.
         */
        size?: string;
        /**
         * File type.
         */
        type?: string;
      }>;
    };
    /**
     * Add a watermark when viewing a shared screen.
     */
    watermark?: boolean;
    /**
     * Allow a Q&A in a webinar.
     */
    webinar_question_answer?: boolean;
    /**
     * Allow participants to share a whiteboard that includes annotation tools.
     */
    whiteboard?: boolean;
    /**
     * Indicates who can share their screen or content during meetings. The value can be one of the following: <br>
     * `host`: Only host can share the screen.<br>
     * `all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
     *
     */
    who_can_share_screen?: 'host' | 'all';
    /**
     * Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>
     * `host`: Only a host can share the screen when someone else is sharing.<br>
     * `all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
     *
     */
    who_can_share_screen_when_someone_is_sharing?: 'host' | 'all';
    /**
     * Workplace by facebook.
     */
    workplace_by_facebook?: boolean;
  };
  /**
   * Account Settings: Integration.
   */
  integration?: {
    /**
     * Enable users who join a meeting from their mobile device to share content from their Box account.
     */
    box?: boolean;
    /**
     * Enable users who join a meeting from their mobile device to share content from their Dropbox account.
     */
    dropbox?: boolean;
    /**
     * Enable meetings to be scheduled using Google Calendar.
     */
    google_calendar?: boolean;
    /**
     * Enable users who join a meeting from their mobile device to share content from their Google Drive.
     */
    google_drive?: boolean;
    /**
     * Enable users to control a connected Kubi device from within a Zoom meeting.
     */
    kubi?: boolean;
    /**
     * Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.
     */
    microsoft_one_drive?: boolean;
  };
  profile?: {
    recording_storage_location?: {
      /**
       * Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.
       *
       * Provide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.
       */
      allowed_values?: Array<string>;
      /**
       * Abbreviated country code.
       */
      value?: string;
    };
  };
  /**
   * Account Settings: Recording.
   */
  recording?: {
    /**
     * Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.
     */
    account_user_access_recording?: boolean;
    /**
     * Allow recovery of deleted cloud recordings from trash.
     * If the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period.
     */
    allow_recovery_deleted_cloud_recordings?: boolean;
    /**
     * [Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.
     */
    archive?: {
      /**
       * Enable the archiving feature.
       */
      enable?: boolean;
      settings?: {
        /**
         * Include in-meeting and/or in-webinar audio in the archive.
         */
        audio_file?: boolean;
        /**
         * Include closed caption or transcript in the archive.
         */
        cc_transcript_file?: boolean;
        /**
         * Include in-meeting chat in the archive.
         */
        chat_file?: boolean;
        /**
         * Include user email in in-meeting chat file.
         */
        chat_with_sender_email?: boolean;
        /**
         * Include in-meeting and/or in-webinar video in the archive.
         */
        video_file?: boolean;
      };
      /**
       * Archive types:
       *
       * * `1`: Only meetings are archived.<br>
       * * `2`: Only webinars are archived.<br>
       * * `3`: Both meetings and webinars are archived.
       */
      type?: 1 | 2 | 3;
    };
    /**
     * Allow Zoom to permanantly delete recordings automatically after a specified number of days.
     */
    auto_delete_cmr?: boolean;
    /**
     * When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.
     */
    auto_delete_cmr_days?: number;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Allow hosts to record and save the meeting in the cloud.
     */
    cloud_recording?: boolean;
    /**
     * Cloud recording downloads.
     */
    cloud_recording_download?: boolean;
    /**
     * Only the host can download cloud recordings.
     */
    cloud_recording_download_host?: boolean;
    /**
     * If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.
     *
     */
    host_delete_cloud_recording?: boolean;
    /**
     * Setting to allow cloud recording access only from specific IP address ranges.
     *
     */
    ip_address_access_control?: {
      /**
       * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
       *
       *
       */
      enable?: boolean;
      /**
       * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
       *
       * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
       *
       *
       */
      ip_addresses_or_ranges?: string;
    };
    /**
     * Allow hosts and participants to record the meeting using a local file.
     */
    local_recording?: boolean;
    /**
     * If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.
     *
     */
    prevent_host_access_recording?: boolean;
    /**
     * Record an audio only file.
     */
    record_audio_file?: boolean;
    /**
     * Record the gallery view with a shared screen.
     */
    record_gallery_view?: boolean;
    /**
     * Record the active speaker with a shared screen.
     */
    record_speaker_view?: boolean;
    /**
     * Automatically transcribe the audio of the meeting or webinar to the cloud.
     */
    recording_audio_transcript?: boolean;
    /**
     * Show a disclaimer to participants before a recording starts
     *
     */
    recording_disclaimer?: boolean;
    /**
     * This object represents the minimum password requirements set for recordings via Account Recording Settings.
     */
    recording_password_requirement?: {
      /**
       * Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).
       */
      have_letter?: boolean;
      /**
       * Indicates whether or not password must contain at least one number(1, 2, 3..).
       */
      have_number?: boolean;
      /**
       * Indicates whether or not password must contain at least one special character(!, @, #..).
       */
      have_special_character?: boolean;
      /**
       * Minimum required length for the password.
       */
      length?: number;
      /**
       * Indicates whether or not password must contain only numeric characters.
       */
      only_allow_numeric?: boolean;
    };
    /**
     * Require a passcode to access existing cloud recordings.
     */
    required_password_for_existing_cloud_recordings?: boolean;
    /**
     * Save the chat text from the meeting.
     */
    save_chat_text?: boolean;
    /**
     * Add a timestamp to the recording.
     */
    show_timestamp?: boolean;
  };
  /**
   * Account Settings: Schedule Meeting.
   */
  schedule_meeting?: {
    /**
     * Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.
     */
    audio_type?: 'both' | 'telephony' | 'voip' | 'thirdParty';
    /**
     * Only Zoom users who are signed in can join meetings.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with a specified domain can join the meeting.
     */
    enforce_login_domains?: string;
    /**
     * Only signed in users with a specific domain can join meetings.
     */
    enforce_login_with_domains?: boolean;
    /**
     * Require a password for Personal Meetings if attendees can join before host.
     */
    force_pmi_jbh_password?: boolean;
    /**
     * Start meetings with the host video on.
     */
    host_video?: boolean;
    /**
     * Allow participants to join the meeting before the host arrives.
     */
    join_before_host?: boolean;
    /**
     * Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
     */
    meeting_password_requirement?: {
      consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
      /**
       * If set to `true`, the password must contain at least 1 letter (such as a,b,c...).
       *
       */
      have_letter?: boolean;
      /**
       * If set to `true`, the password must contain at least 1 number (such as 1,2,3...).
       */
      have_number?: boolean;
      /**
       * If set to `true`, the password must have at least 1 special character (!,@,#...).
       */
      have_special_character?: boolean;
      /**
       * If set to `true`, the password must include both uppercase and lowercase characters.
       */
      have_upper_and_lower_characters?: boolean;
      /**
       * The minimum length that the meeting/webinar password needs to have.
       */
      length?: number;
      /**
       * If set to `true`, the password must only contain numbers and no other characters.
       */
      only_allow_numeric?: boolean;
      /**
       * If set to `true`, users will be informed if the provided password is weak.
       */
      weak_enhance_detection?: boolean;
    };
    /**
     * Always display "Zoom Meeting" as the meeting topic.
     */
    not_store_meeting_topic?: boolean;
    /**
     * Start meetings with the participant video on. Participants can change this setting during the meeting.
     */
    participant_video?: boolean;
    /**
     * Personal Meeting Setting.<br><br>
     * `true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>
     * `false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.
     * For Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.
     *
     *
     *
     */
    personal_meeting?: boolean;
    /**
     * Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
     *
     */
    require_password_for_instant_meetings?: boolean;
    /**
     * Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
     *
     */
    require_password_for_pmi_meetings?: 'jbh_only' | 'all' | 'none';
    /**
     * Require a password for meetings which have already been scheduled
     *
     */
    require_password_for_scheduled_meetings?: boolean;
    /**
     * Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
     */
    require_password_for_scheduling_new_meetings?: boolean;
    /**
     * Use Personal Meeting ID (PMI) when starting an instant meeting
     *
     */
    use_pmi_for_instant_meetings?: boolean;
    /**
     * Use Personal Meeting ID (PMI) when scheduling a meeting
     *
     */
    use_pmi_for_scheduled_meetings?: boolean;
  };
  /**
   * [Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.
   */
  security?: {
    /**
     * Only account administrators can change a user's username and picture.
     */
    admin_change_name_pic?: boolean;
    /**
     * Hide billing information.
     */
    hide_billing_info?: boolean;
    /**
     * Allow users to import photos from a photo library on a  device.
     */
    import_photos_from_devices?: boolean;
    /**
     * This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password.
     */
    password_requirement?: {
      /**
       *
       * Specify the max length of consecutive characters(abcde...) that can be used in a password.
       * If you set the value of this field to `0`, no restriction will be applied on consecutive characters.
       *
       * If you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.
       *
       * The max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).
       */
      consecutive_characters_length?: number;
      /**
       * If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).
       */
      have_special_character?: boolean;
      /**
       * Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.
       */
      minimum_password_length?: number;
      /**
       * If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.
       */
      weak_enhance_detection?: boolean;
    };
    /**
     * Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>
     *
     * If this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>
     *
     * `5`: 5 minutes<br>
     * `10`: 10 minutes<br>
     * `15`: 15 minutes<br>
     * `30`: 30 minutes<br>
     * `45`: 45 minutes<br>
     * `60`: 60 minutes<br>
     * `90`: 90 minutes<br>
     * `120`: 120 minutes
     *
     */
    sign_again_period_for_inactivity_on_client?: number;
    /**
     * Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>
     *
     * If this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>
     *
     * `5`: 5 minutes<br>
     * `10`: 10 minutes<br>
     * `15`: 15 minutes<br>
     * `30`: 30 minutes<br>
     * `60`: 60 minutes<br>
     * `120`: 120 minutes
     *
     *
     *
     *
     */
    sign_again_period_for_inactivity_on_web?: number;
    /**
     * Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:
     * `all`: Two factor authentication will be enabled for all users in the account.<br>
     * `none`: Two factor authentication is disabled.<br>
     * `group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>
     * `role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the
     * `sign_in_with_two_factor_auth_roles` field.
     *
     */
    sign_in_with_two_factor_auth?: 'all' | 'group' | 'role' | 'none';
    /**
     * This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`
     */
    sign_in_with_two_factor_auth_groups?: Array<string>;
    /**
     * This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.
     */
    sign_in_with_two_factor_auth_roles?: Array<string>;
  };
  /**
   * Account Settings: Telephony.
   */
  telephony?: {
    /**
     * Third party audio conference info.
     */
    audio_conference_info?: string;
    /**
     * Indicates where most of the participants call into or call from duriing a meeting.
     */
    telephony_regions?: {
      /**
       * Telephony region options provided by Zoom to select from.
       */
      allowed_values?: Array<string>;
      /**
       * Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.
       */
      selection_values?: Array<string>;
    };
    /**
     * Users can join the meeting using the existing third party audio configuration.
     */
    third_party_audio?: boolean;
  };
  /**
   * Account Settings: TSP.
   */
  tsp?: {
    /**
     * Call Out
     */
    call_out?: boolean;
    /**
     * Call Out Countries/Regions
     */
    call_out_countries?: Array<unknown>;
    /**
     * Display toll-free numbers
     */
    display_toll_free_numbers?: boolean;
    /**
     * Show international numbers link on the invitation email
     */
    show_international_numbers_link?: boolean;
  };
  /**
   * Account Settings: Zoom Rooms.
   */
  zoom_rooms?: {
    /**
     * Automatic start and stop for scheduled meetings.
     */
    auto_start_stop_scheduled_meetings?: boolean;
    /**
     * Cloud recording for instant meetings.
     */
    cmr_for_instant_meeting?: boolean;
    /**
     * Shift all meetings to private.
     */
    force_private_meeting?: boolean;
    /**
     * Hide host and meeting ID from private meetings.
     */
    hide_host_information?: boolean;
    /**
     * Display meeting list with calendar integration.
     */
    list_meetings_with_calendar?: boolean;
    /**
     * Start AirPlay service manually.
     */
    start_airplay_manually?: boolean;
    /**
     * Automatic direct sharing using an ultrasonic proximity signal.
     */
    ultrasonic?: boolean;
    /**
     * Upcoming meeting alert.
     */
    upcoming_meeting_alert?: boolean;
    /**
     * Weekly system restart.
     */
    weekly_system_restart?: boolean;
    /**
     * Zoom Room post meeting feedback.
     */
    zr_post_meeting_feedback?: boolean;
  };
};

/**
 * If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).
 *
 */
export type data_center_regions = 'EU' | 'HK' | 'AU' | 'IN' | 'TY' | 'CN' | 'US' | 'CA';

/**
 * Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.
 */
export type entry_exit_chime = 'host' | 'all' | 'none';

/**
 * Indicates who can share their screen or content during meetings. The value can be one of the following: <br>
 * `host`: Only host can share the screen.<br>
 * `all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
 *
 */
export type who_can_share_screen = 'host' | 'all';

/**
 * Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>
 * `host`: Only a host can share the screen when someone else is sharing.<br>
 * `all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
 *
 */
export type who_can_share_screen_when_someone_is_sharing = 'host' | 'all';

/**
 * Archive types:
 *
 * * `1`: Only meetings are archived.<br>
 * * `2`: Only webinars are archived.<br>
 * * `3`: Both meetings and webinars are archived.
 */
export type type = 1 | 2 | 3;

/**
 * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
 */
export type auto_recording = 'local' | 'cloud' | 'none';

/**
 * Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.
 */
export type audio_type = 'both' | 'telephony' | 'voip' | 'thirdParty';

export type consecutive_characters_length = 0 | 4 | 5 | 6 | 7 | 8;

/**
 * Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
 *
 */
export type require_password_for_pmi_meetings = 'jbh_only' | 'all' | 'none';

/**
 * Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:
 * `all`: Two factor authentication will be enabled for all users in the account.<br>
 * `none`: Two factor authentication is disabled.<br>
 * `group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>
 * `role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the
 * `sign_in_with_two_factor_auth_roles` field.
 *
 */
export type sign_in_with_two_factor_auth = 'all' | 'group' | 'role' | 'none';

export type AccountSettingsAuthentication =
  | {
      /**
       * Meeting Authentication Options
       */
      authentication_options?: Array<{
        /**
         * Authentication default option
         */
        default_option?: boolean;
        /**
         * Authentication domians
         */
        domains?: string;
        /**
         * Authentication id
         */
        id?: string;
        /**
         * Authentication name
         */
        name?: string;
        /**
         *  Authentication type. Specify one of the following authentication types for the authentication profile:<br>
         * * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.
         * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>
         * * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.
         */
        type?: 'enforce_login' | 'enforce_login_with_same_account' | 'enforce_login_with_domains';
        /**
         * Authentication visible
         */
        visible?: boolean;
      }>;
      /**
       * Only authenticated users can join meetings
       */
      meeting_authentication?: boolean;
    }
  | {
      authentication_options?: Array<{
        /**
         * Authentication default option
         */
        default_option?: boolean;
        /**
         * Authentication domians
         */
        domains?: string;
        /**
         * Authentication id
         */
        id?: string;
        /**
         * Authentication name
         */
        name?: string;
        /**
         * Authentication type
         */
        type?: 'internally' | 'enforce_login' | 'enforce_login_with_domains';
        /**
         * Authentication visible
         */
        visible?: boolean;
      }>;
      /**
       * Only authenticated users can view cloud recordings
       */
      recording_authentication?: boolean;
    };

export type AccountSettingsAuthenticationUpdate =
  | {
      /**
       * Meeting Authentication Options
       */
      authentication_option?: {
        /**
         * Specify the action that you would like to take via this API request:<br>
         * * `add` : Choose this value if you are adding an authentication option.
         * * `update`: Choose this value if you are updating an existing authentication option.
         * * `delete`: Choose this value if you are deleting an existing authentication option.
         */
        action?: 'update' | 'delete' | 'add';
        /**
         * Specify whether you would like to set this authentication option as the default option or not.
         */
        default_option?: boolean;
        /**
         * If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to join your meetings or webinars.
         */
        domains?: string;
        /**
         *  Authentication ID. If you are creating an authentication profile, you do not need to provide this field. The id field will be generated in the response once this API request is completed successfully. You can also use the Get Account Settings API with query parameter set to `meeting_authentication` to list the authentication id.<br><br>
         * Use this field or the `name` field to identify the associated authentication option that you would like to update or delete.
         */
        id?: string;
        /**
         * Unique name for the authentication option.
         */
        name?: string;
        /**
         *  Authentication type. Specify one of the following authentication types for the authentication profile:<br>
         * * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.
         * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>
         * * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.
         */
        type?: 'enforce_login' | 'enforce_login_with_same_account' | 'enforce_login_with_domains';
      };
      /**
       * If set to "true", only authenticated users can join meetings. The method for authentication can be defined in the "authentication_option".
       */
      meeting_authentication?: boolean;
    }
  | {
      /**
       * Specify the authentication options for this account.
       */
      authentication_option?: {
        /**
         * Specify the action that you would like to take via this API request:<br>
         * * `add` : Choose this value if you are adding an authentication option.
         * * `update`: Choose this value if you are updating an existing authentication option.
         * * `delete`: Choose this value if you are deleting an existing authentication option.
         */
        action?: 'update' | 'delete' | 'add';
        /**
         * Specify whether you would like to set this authentication option as the default option or not.
         */
        default_option?: boolean;
        /**
         * If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to view the recordings.
         */
        domains?: string;
        /**
         *  Authentication ID. If you are creating an authentication profile, you do not need to provide this field. The id field will be generated in the response once this API request is completed successfully. You can also use the Get Account Settings API with query parameter set to `meeting_authentication` to list the authentication id.<br><br>
         * Use this field or the `name` field to identify the associated authentication option that you would like to update or delete.
         */
        id?: string;
        /**
         * Unique name for the authentication option.
         */
        name?: string;
        /**
         * Specify one authentication type that is to be associated with this authentication configuration:<br>
         * * `internally`: This option allows you specify a rule that only signed in users within your account can view the recording.<br>
         * * `enforce_login`: This option allows any users to view the recording, as long as they are signed into their Zoom account.<br>
         * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can view the recording. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.
         *
         *
         */
        type?: 'internally' | 'enforce_login' | 'enforce_login_with_domains';
      };
      /**
       * If set to `true`, only authenticated users can view the cloud recordings.<br><br>
       * The authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).
       */
      recording_authentication?: boolean;
    };

/**
 * Specify the action that you would like to take via this API request:<br>
 * * `add` : Choose this value if you are adding an authentication option.
 * * `update`: Choose this value if you are updating an existing authentication option.
 * * `delete`: Choose this value if you are deleting an existing authentication option.
 */
export type action = 'update' | 'delete' | 'add';

/**
 *  Authentication type. Specify one of the following authentication types for the authentication profile:<br>
 * * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.
 * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>
 * * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.
 */
export type type2 = 'enforce_login' | 'enforce_login_with_same_account' | 'enforce_login_with_domains';

/**
 * Account Settings: Notification.
 */
export type AccountSettingsEmailNotification = {
  /**
   * Notify when an alternative host is set or removed from a meeting.
   */
  alternative_host_reminder?: boolean;
  /**
   * Notify the host and participants when a meeting is cancelled.
   */
  cancel_meeting_reminder?: boolean;
  /**
   * Notify host when cloud recording is available.
   */
  cloud_recording_avaliable_reminder?: boolean;
  /**
   * Notify the host when participants join the meeting before them.
   */
  jbh_reminder?: boolean;
  /**
   * Notify user when host licenses are running low.
   */
  low_host_count_reminder?: boolean;
  /**
   * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
   */
  schedule_for_reminder?: boolean;
};

/**
 * Account Settings: Feature.
 */
export type AccountSettingsFeature = {
  /**
   * Set the maximum number of participants a host can have in a single meeting.
   */
  meeting_capacity?: number;
};

/**
 * Account Settings: In Meeting.
 */
export type AccountSettingsInMeeting = {
  /**
   * Identify guest participants in a meeting or webinar.
   */
  alert_guest_join?: boolean;
  /**
   * Allow live streaming.
   */
  allow_live_streaming?: boolean;
  /**
   * If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.
   *
   */
  allow_participants_to_rename?: boolean;
  /**
   * Show the Zoom desktop application when sharing screens.
   */
  allow_show_zoom_windows?: boolean;
  /**
   * Allow participants to use annotation tools to add information to shared screens.
   */
  annotation?: boolean;
  /**
   * Allow an anonymous Q&A in a webinar.
   */
  anonymous_question_answer?: boolean;
  /**
   * Allow host to put attendee on hold.
   *
   * **This field has been deprecated and is no longer supported.**
   */
  attendee_on_hold?: boolean;
  /**
   * Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.
   */
  auto_answer?: boolean;
  /**
   * Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.
   */
  auto_saving_chat?: boolean;
  /**
   * Allow host to split meeting participants into separate, smaller rooms.
   */
  breakout_room?: boolean;
  /**
   * Allow meeting participants to send a message that is visible to all participants.
   */
  chat?: boolean;
  /**
   * Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions.
   */
  closed_caption?: boolean;
  /**
   * Allow the host to add co-hosts.
   */
  co_host?: boolean;
  /**
   * If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.
   */
  custom_data_center_regions?: boolean;
  /**
   * Custom live streaming.
   */
  custom_live_streaming_service?: boolean;
  /**
   * Custom service instructions.
   */
  custom_service_instructions?: string;
  /**
   * If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).
   *
   */
  data_center_regions?: 'EU' | 'HK' | 'AU' | 'IN' | 'TY' | 'CN' | 'US' | 'CA';
  /**
   * DSCP audio.
   */
  dscp_audio?: number;
  /**
   * DSCP marking.
   */
  dscp_marking?: boolean;
  /**
   * DSCP video.
   */
  dscp_video?: number;
  /**
   * Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).
   */
  e2e_encryption?: boolean;
  /**
   * Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.
   */
  entry_exit_chime?: 'host' | 'all' | 'none';
  /**
   * Allow another user to take control of your camera during a meeting.
   */
  far_end_camera_control?: boolean;
  /**
   * Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.
   */
  feedback?: boolean;
  /**
   * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.
   */
  file_transfer?: boolean;
  /**
   * Activate higher quality video for host and participants.
   * Please note: This will use more bandwidth.
   */
  group_hd?: boolean;
  /**
   * Enable or disable meeting reactions. <br>
   * `true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>
   * `false`: Do not enable meeting reactions.
   */
  meeting_reactions?: boolean;
  /**
   * Allow users to select original sound in their client settings.
   */
  original_audio?: boolean;
  /**
   * Peer to peer connection while only two people are in a meeting.
   */
  p2p_connetion?: boolean;
  /**
   * Peer to peer listening ports range.
   */
  p2p_ports?: boolean;
  /**
   * Add "Polls" to the meeting controls.
   */
  polling?: boolean;
  /**
   * The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.
   */
  ports_range?: string;
  /**
   * Display a thumbs up or down survey at the end of each meeting.
   */
  post_meeting_feedback?: boolean;
  /**
   * Allow a meeting participant to send a private message to another participant.
   */
  private_chat?: boolean;
  /**
   * Record and play their own voice.
   */
  record_play_own_voice?: boolean;
  /**
   * Allow users to request remote control.
   */
  remote_control?: boolean;
  /**
   * Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.
   */
  request_permission_to_unmute?: boolean;
  /**
   * Allow screen sharing.
   */
  screen_sharing?: boolean;
  /**
   * Only show the default email when sending email invites.
   */
  sending_default_email_invites?: boolean;
  /**
   * If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.
   */
  show_a_join_from_your_browser_link?: boolean;
  /**
   * Always show the meeting control toolbar.
   */
  show_meeting_control_toolbar?: boolean;
  /**
   * Allow users to select stereo audio in their client settings.
   */
  stereo_audio?: boolean;
  /**
   * Use HTML formatted email for the Outlook plugin.
   */
  use_html_format_email?: boolean;
  /**
   * Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.
   */
  virtual_background?: boolean;
  /**
   * Settings to manage virtual background.
   */
  virtual_background_settings?: {
    /**
     * Allow users to upload custom backgrounds.
     */
    allow_upload_custom?: boolean;
    /**
     * Allow use of videos for virtual backgrounds.
     */
    allow_videos?: boolean;
    /**
     * Enable virtual background.
     */
    enable?: boolean;
    files?: Array<{
      /**
       * Unique identifier of the file.
       */
      id?: string;
      /**
       * Indicates whether or not this file is the default virtual background file.
       */
      is_default?: boolean;
      /**
       * File name.
       */
      name?: string;
      /**
       * File size.
       */
      size?: string;
      /**
       * File type.
       */
      type?: string;
    }>;
  };
  /**
   * Add a watermark when viewing a shared screen.
   */
  watermark?: boolean;
  /**
   * Allow a Q&A in a webinar.
   */
  webinar_question_answer?: boolean;
  /**
   * Allow participants to share a whiteboard that includes annotation tools.
   */
  whiteboard?: boolean;
  /**
   * Indicates who can share their screen or content during meetings. The value can be one of the following: <br>
   * `host`: Only host can share the screen.<br>
   * `all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
   *
   */
  who_can_share_screen?: 'host' | 'all';
  /**
   * Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>
   * `host`: Only a host can share the screen when someone else is sharing.<br>
   * `all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
   *
   */
  who_can_share_screen_when_someone_is_sharing?: 'host' | 'all';
  /**
   * Workplace by facebook.
   */
  workplace_by_facebook?: boolean;
};

/**
 * Account Settings: Integration.
 */
export type AccountSettingsIntegration = {
  /**
   * Enable users who join a meeting from their mobile device to share content from their Box account.
   */
  box?: boolean;
  /**
   * Enable users who join a meeting from their mobile device to share content from their Dropbox account.
   */
  dropbox?: boolean;
  /**
   * Enable meetings to be scheduled using Google Calendar.
   */
  google_calendar?: boolean;
  /**
   * Enable users who join a meeting from their mobile device to share content from their Google Drive.
   */
  google_drive?: boolean;
  /**
   * Enable users to control a connected Kubi device from within a Zoom meeting.
   */
  kubi?: boolean;
  /**
   * Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.
   */
  microsoft_one_drive?: boolean;
};

/**
 * Account Settings: Recording.
 */
export type AccountSettingsRecording = {
  /**
   * Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.
   */
  account_user_access_recording?: boolean;
  /**
   * Allow recovery of deleted cloud recordings from trash.
   * If the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period.
   */
  allow_recovery_deleted_cloud_recordings?: boolean;
  /**
   * [Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.
   */
  archive?: {
    /**
     * Enable the archiving feature.
     */
    enable?: boolean;
    settings?: {
      /**
       * Include in-meeting and/or in-webinar audio in the archive.
       */
      audio_file?: boolean;
      /**
       * Include closed caption or transcript in the archive.
       */
      cc_transcript_file?: boolean;
      /**
       * Include in-meeting chat in the archive.
       */
      chat_file?: boolean;
      /**
       * Include user email in in-meeting chat file.
       */
      chat_with_sender_email?: boolean;
      /**
       * Include in-meeting and/or in-webinar video in the archive.
       */
      video_file?: boolean;
    };
    /**
     * Archive types:
     *
     * * `1`: Only meetings are archived.<br>
     * * `2`: Only webinars are archived.<br>
     * * `3`: Both meetings and webinars are archived.
     */
    type?: 1 | 2 | 3;
  };
  /**
   * Allow Zoom to permanantly delete recordings automatically after a specified number of days.
   */
  auto_delete_cmr?: boolean;
  /**
   * When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.
   */
  auto_delete_cmr_days?: number;
  /**
   * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
   */
  auto_recording?: 'local' | 'cloud' | 'none';
  /**
   * Allow hosts to record and save the meeting in the cloud.
   */
  cloud_recording?: boolean;
  /**
   * Cloud recording downloads.
   */
  cloud_recording_download?: boolean;
  /**
   * Only the host can download cloud recordings.
   */
  cloud_recording_download_host?: boolean;
  /**
   * If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.
   *
   */
  host_delete_cloud_recording?: boolean;
  /**
   * Setting to allow cloud recording access only from specific IP address ranges.
   *
   */
  ip_address_access_control?: {
    /**
     * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
     *
     *
     */
    enable?: boolean;
    /**
     * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
     *
     * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
     *
     *
     */
    ip_addresses_or_ranges?: string;
  };
  /**
   * Allow hosts and participants to record the meeting using a local file.
   */
  local_recording?: boolean;
  /**
   * If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.
   *
   */
  prevent_host_access_recording?: boolean;
  /**
   * Record an audio only file.
   */
  record_audio_file?: boolean;
  /**
   * Record the gallery view with a shared screen.
   */
  record_gallery_view?: boolean;
  /**
   * Record the active speaker with a shared screen.
   */
  record_speaker_view?: boolean;
  /**
   * Automatically transcribe the audio of the meeting or webinar to the cloud.
   */
  recording_audio_transcript?: boolean;
  /**
   * Show a disclaimer to participants before a recording starts
   *
   */
  recording_disclaimer?: boolean;
  /**
   * This object represents the minimum password requirements set for recordings via Account Recording Settings.
   */
  recording_password_requirement?: {
    /**
     * Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).
     */
    have_letter?: boolean;
    /**
     * Indicates whether or not password must contain at least one number(1, 2, 3..).
     */
    have_number?: boolean;
    /**
     * Indicates whether or not password must contain at least one special character(!, @, #..).
     */
    have_special_character?: boolean;
    /**
     * Minimum required length for the password.
     */
    length?: number;
    /**
     * Indicates whether or not password must contain only numeric characters.
     */
    only_allow_numeric?: boolean;
  };
  /**
   * Require a passcode to access existing cloud recordings.
   */
  required_password_for_existing_cloud_recordings?: boolean;
  /**
   * Save the chat text from the meeting.
   */
  save_chat_text?: boolean;
  /**
   * Add a timestamp to the recording.
   */
  show_timestamp?: boolean;
};

/**
 * Only authenticated users can view cloud recordings
 * The viewers need to authenticate prior to viewing the cloud recordings, hosts can choose one of the authentication methods when sharing a cloud recording.
 */
export type AccountSettingsRecordingAuthenticationUpdate = {
  authentication_option?: {
    action?: 'update' | 'add' | 'delete';
    default_option?: boolean;
    domains?: string;
    id?: string;
    name?: string;
    type?: 'internally' | 'enforce_login' | 'enforce_login_with_domains';
  };
  recording_authentication?: boolean;
};

export type type3 = 'internally' | 'enforce_login' | 'enforce_login_with_domains';

/**
 * Account Settings: Schedule Meeting.
 */
export type AccountSettingsScheduleMeeting = {
  /**
   * Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.
   */
  audio_type?: 'both' | 'telephony' | 'voip' | 'thirdParty';
  /**
   * Only Zoom users who are signed in can join meetings.
   */
  enforce_login?: boolean;
  /**
   * Only signed in users with a specified domain can join the meeting.
   */
  enforce_login_domains?: string;
  /**
   * Only signed in users with a specific domain can join meetings.
   */
  enforce_login_with_domains?: boolean;
  /**
   * Require a password for Personal Meetings if attendees can join before host.
   */
  force_pmi_jbh_password?: boolean;
  /**
   * Start meetings with the host video on.
   */
  host_video?: boolean;
  /**
   * Allow participants to join the meeting before the host arrives.
   */
  join_before_host?: boolean;
  /**
   * Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
   */
  meeting_password_requirement?: {
    consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
    /**
     * If set to `true`, the password must contain at least 1 letter (such as a,b,c...).
     *
     */
    have_letter?: boolean;
    /**
     * If set to `true`, the password must contain at least 1 number (such as 1,2,3...).
     */
    have_number?: boolean;
    /**
     * If set to `true`, the password must have at least 1 special character (!,@,#...).
     */
    have_special_character?: boolean;
    /**
     * If set to `true`, the password must include both uppercase and lowercase characters.
     */
    have_upper_and_lower_characters?: boolean;
    /**
     * The minimum length that the meeting/webinar password needs to have.
     */
    length?: number;
    /**
     * If set to `true`, the password must only contain numbers and no other characters.
     */
    only_allow_numeric?: boolean;
    /**
     * If set to `true`, users will be informed if the provided password is weak.
     */
    weak_enhance_detection?: boolean;
  };
  /**
   * Always display "Zoom Meeting" as the meeting topic.
   */
  not_store_meeting_topic?: boolean;
  /**
   * Start meetings with the participant video on. Participants can change this setting during the meeting.
   */
  participant_video?: boolean;
  /**
   * Personal Meeting Setting.<br><br>
   * `true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>
   * `false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.
   * For Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.
   *
   *
   *
   */
  personal_meeting?: boolean;
  /**
   * Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
   *
   */
  require_password_for_instant_meetings?: boolean;
  /**
   * Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
   *
   */
  require_password_for_pmi_meetings?: 'jbh_only' | 'all' | 'none';
  /**
   * Require a password for meetings which have already been scheduled
   *
   */
  require_password_for_scheduled_meetings?: boolean;
  /**
   * Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
   */
  require_password_for_scheduling_new_meetings?: boolean;
  /**
   * Use Personal Meeting ID (PMI) when starting an instant meeting
   *
   */
  use_pmi_for_instant_meetings?: boolean;
  /**
   * Use Personal Meeting ID (PMI) when scheduling a meeting
   *
   */
  use_pmi_for_scheduled_meetings?: boolean;
};

/**
 * [Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.
 */
export type AccountSettingsSecurity = {
  /**
   * Only account administrators can change a user's username and picture.
   */
  admin_change_name_pic?: boolean;
  /**
   * Hide billing information.
   */
  hide_billing_info?: boolean;
  /**
   * Allow users to import photos from a photo library on a  device.
   */
  import_photos_from_devices?: boolean;
  /**
   * This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password.
   */
  password_requirement?: {
    /**
     *
     * Specify the max length of consecutive characters(abcde...) that can be used in a password.
     * If you set the value of this field to `0`, no restriction will be applied on consecutive characters.
     *
     * If you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.
     *
     * The max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).
     */
    consecutive_characters_length?: number;
    /**
     * If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).
     */
    have_special_character?: boolean;
    /**
     * Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.
     */
    minimum_password_length?: number;
    /**
     * If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.
     */
    weak_enhance_detection?: boolean;
  };
  /**
   * Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>
   *
   * If this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>
   *
   * `5`: 5 minutes<br>
   * `10`: 10 minutes<br>
   * `15`: 15 minutes<br>
   * `30`: 30 minutes<br>
   * `45`: 45 minutes<br>
   * `60`: 60 minutes<br>
   * `90`: 90 minutes<br>
   * `120`: 120 minutes
   *
   */
  sign_again_period_for_inactivity_on_client?: number;
  /**
   * Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>
   *
   * If this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>
   *
   * `5`: 5 minutes<br>
   * `10`: 10 minutes<br>
   * `15`: 15 minutes<br>
   * `30`: 30 minutes<br>
   * `60`: 60 minutes<br>
   * `120`: 120 minutes
   *
   *
   *
   *
   */
  sign_again_period_for_inactivity_on_web?: number;
  /**
   * Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:
   * `all`: Two factor authentication will be enabled for all users in the account.<br>
   * `none`: Two factor authentication is disabled.<br>
   * `group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>
   * `role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the
   * `sign_in_with_two_factor_auth_roles` field.
   *
   */
  sign_in_with_two_factor_auth?: 'all' | 'group' | 'role' | 'none';
  /**
   * This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`
   */
  sign_in_with_two_factor_auth_groups?: Array<string>;
  /**
   * This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.
   */
  sign_in_with_two_factor_auth_roles?: Array<string>;
};

/**
 * Account Settings: TSP.
 */
export type AccountSettingsTSP = {
  /**
   * Call Out
   */
  call_out?: boolean;
  /**
   * Call Out Countries/Regions
   */
  call_out_countries?: Array<unknown>;
  /**
   * Display toll-free numbers
   */
  display_toll_free_numbers?: boolean;
  /**
   * Show international numbers link on the invitation email
   */
  show_international_numbers_link?: boolean;
};

/**
 * Account Settings: Telephony.
 */
export type AccountSettingsTelephony = {
  /**
   * Third party audio conference info.
   */
  audio_conference_info?: string;
  /**
   * Indicates where most of the participants call into or call from duriing a meeting.
   */
  telephony_regions?: {
    /**
     * Telephony region options provided by Zoom to select from.
     */
    allowed_values?: Array<string>;
    /**
     * Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.
     */
    selection_values?: Array<string>;
  };
  /**
   * Users can join the meeting using the existing third party audio configuration.
   */
  third_party_audio?: boolean;
};

/**
 * Account Settings Update: Telephony.
 */
export type AccountSettingsUpdateTelephony = {
  /**
   * Third party audio conference info.
   */
  audio_conference_info?: string;
  /**
   * Indicates where most of the participants call into or call from duriing a meeting.
   */
  telephony_regions?: {
    /**
     * Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.
     */
    selection_values?: Array<string>;
  };
  /**
   * Users can join the meeting using the existing third party audio configuration.
   */
  third_party_audio?: boolean;
};

/**
 * Account Settings: Zoom Rooms.
 */
export type AccountSettingsZoomRooms = {
  /**
   * Automatic start and stop for scheduled meetings.
   */
  auto_start_stop_scheduled_meetings?: boolean;
  /**
   * Cloud recording for instant meetings.
   */
  cmr_for_instant_meeting?: boolean;
  /**
   * Shift all meetings to private.
   */
  force_private_meeting?: boolean;
  /**
   * Hide host and meeting ID from private meetings.
   */
  hide_host_information?: boolean;
  /**
   * Display meeting list with calendar integration.
   */
  list_meetings_with_calendar?: boolean;
  /**
   * Start AirPlay service manually.
   */
  start_airplay_manually?: boolean;
  /**
   * Automatic direct sharing using an ultrasonic proximity signal.
   */
  ultrasonic?: boolean;
  /**
   * Upcoming meeting alert.
   */
  upcoming_meeting_alert?: boolean;
  /**
   * Weekly system restart.
   */
  weekly_system_restart?: boolean;
  /**
   * Zoom Room post meeting feedback.
   */
  zr_post_meeting_feedback?: boolean;
};

export type AccountUpdateSettings = {
  /**
   * Account Settings: Notification.
   */
  email_notification?: {
    /**
     * Notify when an alternative host is set or removed from a meeting.
     */
    alternative_host_reminder?: boolean;
    /**
     * Notify the host and participants when a meeting is cancelled.
     */
    cancel_meeting_reminder?: boolean;
    /**
     * Notify host when cloud recording is available.
     */
    cloud_recording_avaliable_reminder?: boolean;
    /**
     * Notify the host when participants join the meeting before them.
     */
    jbh_reminder?: boolean;
    /**
     * Notify user when host licenses are running low.
     */
    low_host_count_reminder?: boolean;
    /**
     * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
     */
    schedule_for_reminder?: boolean;
  };
  /**
   * Account Settings: Feature.
   */
  feature?: {
    /**
     * Set the maximum number of participants a host can have in a single meeting.
     */
    meeting_capacity?: number;
  };
  /**
   * Account Settings: In Meeting.
   */
  in_meeting?: {
    /**
     * Identify guest participants in a meeting or webinar.
     */
    alert_guest_join?: boolean;
    /**
     * Allow live streaming.
     */
    allow_live_streaming?: boolean;
    /**
     * If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.
     *
     */
    allow_participants_to_rename?: boolean;
    /**
     * Show the Zoom desktop application when sharing screens.
     */
    allow_show_zoom_windows?: boolean;
    /**
     * Allow participants to use annotation tools to add information to shared screens.
     */
    annotation?: boolean;
    /**
     * Allow an anonymous Q&A in a webinar.
     */
    anonymous_question_answer?: boolean;
    /**
     * Allow host to put attendee on hold.
     *
     * **This field has been deprecated and is no longer supported.**
     */
    attendee_on_hold?: boolean;
    /**
     * Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.
     */
    auto_answer?: boolean;
    /**
     * Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.
     */
    auto_saving_chat?: boolean;
    /**
     * Allow host to split meeting participants into separate, smaller rooms.
     */
    breakout_room?: boolean;
    /**
     * Allow meeting participants to send a message that is visible to all participants.
     */
    chat?: boolean;
    /**
     * Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions.
     */
    closed_caption?: boolean;
    /**
     * Allow the host to add co-hosts.
     */
    co_host?: boolean;
    /**
     * If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.
     */
    custom_data_center_regions?: boolean;
    /**
     * Custom live streaming.
     */
    custom_live_streaming_service?: boolean;
    /**
     * Custom service instructions.
     */
    custom_service_instructions?: string;
    /**
     * If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).
     *
     */
    data_center_regions?: 'EU' | 'HK' | 'AU' | 'IN' | 'TY' | 'CN' | 'US' | 'CA';
    /**
     * DSCP audio.
     */
    dscp_audio?: number;
    /**
     * DSCP marking.
     */
    dscp_marking?: boolean;
    /**
     * DSCP video.
     */
    dscp_video?: number;
    /**
     * Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).
     */
    e2e_encryption?: boolean;
    /**
     * Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.
     */
    entry_exit_chime?: 'host' | 'all' | 'none';
    /**
     * Allow another user to take control of your camera during a meeting.
     */
    far_end_camera_control?: boolean;
    /**
     * Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.
     */
    feedback?: boolean;
    /**
     * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.
     */
    file_transfer?: boolean;
    /**
     * Activate higher quality video for host and participants.
     * Please note: This will use more bandwidth.
     */
    group_hd?: boolean;
    /**
     * Enable or disable meeting reactions. <br>
     * `true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>
     * `false`: Do not enable meeting reactions.
     */
    meeting_reactions?: boolean;
    /**
     * Allow users to select original sound in their client settings.
     */
    original_audio?: boolean;
    /**
     * Peer to peer connection while only two people are in a meeting.
     */
    p2p_connetion?: boolean;
    /**
     * Peer to peer listening ports range.
     */
    p2p_ports?: boolean;
    /**
     * Add "Polls" to the meeting controls.
     */
    polling?: boolean;
    /**
     * The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.
     */
    ports_range?: string;
    /**
     * Display a thumbs up or down survey at the end of each meeting.
     */
    post_meeting_feedback?: boolean;
    /**
     * Allow a meeting participant to send a private message to another participant.
     */
    private_chat?: boolean;
    /**
     * Record and play their own voice.
     */
    record_play_own_voice?: boolean;
    /**
     * Allow users to request remote control.
     */
    remote_control?: boolean;
    /**
     * Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.
     */
    request_permission_to_unmute?: boolean;
    /**
     * Allow screen sharing.
     */
    screen_sharing?: boolean;
    /**
     * Only show the default email when sending email invites.
     */
    sending_default_email_invites?: boolean;
    /**
     * If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.
     */
    show_a_join_from_your_browser_link?: boolean;
    /**
     * Always show the meeting control toolbar.
     */
    show_meeting_control_toolbar?: boolean;
    /**
     * Allow users to select stereo audio in their client settings.
     */
    stereo_audio?: boolean;
    /**
     * Use HTML formatted email for the Outlook plugin.
     */
    use_html_format_email?: boolean;
    /**
     * Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.
     */
    virtual_background?: boolean;
    /**
     * Settings to manage virtual background.
     */
    virtual_background_settings?: {
      /**
       * Allow users to upload custom backgrounds.
       */
      allow_upload_custom?: boolean;
      /**
       * Allow use of videos for virtual backgrounds.
       */
      allow_videos?: boolean;
      /**
       * Enable virtual background.
       */
      enable?: boolean;
      files?: Array<{
        /**
         * Unique identifier of the file.
         */
        id?: string;
        /**
         * Indicates whether or not this file is the default virtual background file.
         */
        is_default?: boolean;
        /**
         * File name.
         */
        name?: string;
        /**
         * File size.
         */
        size?: string;
        /**
         * File type.
         */
        type?: string;
      }>;
    };
    /**
     * Add a watermark when viewing a shared screen.
     */
    watermark?: boolean;
    /**
     * Allow a Q&A in a webinar.
     */
    webinar_question_answer?: boolean;
    /**
     * Allow participants to share a whiteboard that includes annotation tools.
     */
    whiteboard?: boolean;
    /**
     * Indicates who can share their screen or content during meetings. The value can be one of the following: <br>
     * `host`: Only host can share the screen.<br>
     * `all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
     *
     */
    who_can_share_screen?: 'host' | 'all';
    /**
     * Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>
     * `host`: Only a host can share the screen when someone else is sharing.<br>
     * `all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
     *
     */
    who_can_share_screen_when_someone_is_sharing?: 'host' | 'all';
    /**
     * Workplace by facebook.
     */
    workplace_by_facebook?: boolean;
  };
  /**
   * Account Settings: Integration.
   */
  integration?: {
    /**
     * Enable users who join a meeting from their mobile device to share content from their Box account.
     */
    box?: boolean;
    /**
     * Enable users who join a meeting from their mobile device to share content from their Dropbox account.
     */
    dropbox?: boolean;
    /**
     * Enable meetings to be scheduled using Google Calendar.
     */
    google_calendar?: boolean;
    /**
     * Enable users who join a meeting from their mobile device to share content from their Google Drive.
     */
    google_drive?: boolean;
    /**
     * Enable users to control a connected Kubi device from within a Zoom meeting.
     */
    kubi?: boolean;
    /**
     * Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.
     */
    microsoft_one_drive?: boolean;
  };
  profile?: {
    recording_storage_location?: {
      /**
       * Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.
       *
       * Provide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.
       */
      allowed_values?: Array<string>;
      /**
       * Abbreviated country code.
       */
      value?: string;
    };
  };
  /**
   * Account Settings: Recording.
   */
  recording?: {
    /**
     * Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.
     */
    account_user_access_recording?: boolean;
    /**
     * Allow recovery of deleted cloud recordings from trash.
     * If the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period.
     */
    allow_recovery_deleted_cloud_recordings?: boolean;
    /**
     * [Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.
     */
    archive?: {
      /**
       * Enable the archiving feature.
       */
      enable?: boolean;
      settings?: {
        /**
         * Include in-meeting and/or in-webinar audio in the archive.
         */
        audio_file?: boolean;
        /**
         * Include closed caption or transcript in the archive.
         */
        cc_transcript_file?: boolean;
        /**
         * Include in-meeting chat in the archive.
         */
        chat_file?: boolean;
        /**
         * Include user email in in-meeting chat file.
         */
        chat_with_sender_email?: boolean;
        /**
         * Include in-meeting and/or in-webinar video in the archive.
         */
        video_file?: boolean;
      };
      /**
       * Archive types:
       *
       * * `1`: Only meetings are archived.<br>
       * * `2`: Only webinars are archived.<br>
       * * `3`: Both meetings and webinars are archived.
       */
      type?: 1 | 2 | 3;
    };
    /**
     * Allow Zoom to permanantly delete recordings automatically after a specified number of days.
     */
    auto_delete_cmr?: boolean;
    /**
     * When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.
     */
    auto_delete_cmr_days?: number;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Allow hosts to record and save the meeting in the cloud.
     */
    cloud_recording?: boolean;
    /**
     * Cloud recording downloads.
     */
    cloud_recording_download?: boolean;
    /**
     * Only the host can download cloud recordings.
     */
    cloud_recording_download_host?: boolean;
    /**
     * If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.
     *
     */
    host_delete_cloud_recording?: boolean;
    /**
     * Setting to allow cloud recording access only from specific IP address ranges.
     *
     */
    ip_address_access_control?: {
      /**
       * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
       *
       *
       */
      enable?: boolean;
      /**
       * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
       *
       * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
       *
       *
       */
      ip_addresses_or_ranges?: string;
    };
    /**
     * Allow hosts and participants to record the meeting using a local file.
     */
    local_recording?: boolean;
    /**
     * If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.
     *
     */
    prevent_host_access_recording?: boolean;
    /**
     * Record an audio only file.
     */
    record_audio_file?: boolean;
    /**
     * Record the gallery view with a shared screen.
     */
    record_gallery_view?: boolean;
    /**
     * Record the active speaker with a shared screen.
     */
    record_speaker_view?: boolean;
    /**
     * Automatically transcribe the audio of the meeting or webinar to the cloud.
     */
    recording_audio_transcript?: boolean;
    /**
     * Show a disclaimer to participants before a recording starts
     *
     */
    recording_disclaimer?: boolean;
    /**
     * This object represents the minimum password requirements set for recordings via Account Recording Settings.
     */
    recording_password_requirement?: {
      /**
       * Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).
       */
      have_letter?: boolean;
      /**
       * Indicates whether or not password must contain at least one number(1, 2, 3..).
       */
      have_number?: boolean;
      /**
       * Indicates whether or not password must contain at least one special character(!, @, #..).
       */
      have_special_character?: boolean;
      /**
       * Minimum required length for the password.
       */
      length?: number;
      /**
       * Indicates whether or not password must contain only numeric characters.
       */
      only_allow_numeric?: boolean;
    };
    /**
     * Require a passcode to access existing cloud recordings.
     */
    required_password_for_existing_cloud_recordings?: boolean;
    /**
     * Save the chat text from the meeting.
     */
    save_chat_text?: boolean;
    /**
     * Add a timestamp to the recording.
     */
    show_timestamp?: boolean;
  };
  /**
   * Account Settings: Schedule Meeting.
   */
  schedule_meeting?: {
    /**
     * Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.
     */
    audio_type?: 'both' | 'telephony' | 'voip' | 'thirdParty';
    /**
     * Only Zoom users who are signed in can join meetings.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with a specified domain can join the meeting.
     */
    enforce_login_domains?: string;
    /**
     * Only signed in users with a specific domain can join meetings.
     */
    enforce_login_with_domains?: boolean;
    /**
     * Require a password for Personal Meetings if attendees can join before host.
     */
    force_pmi_jbh_password?: boolean;
    /**
     * Start meetings with the host video on.
     */
    host_video?: boolean;
    /**
     * Allow participants to join the meeting before the host arrives.
     */
    join_before_host?: boolean;
    /**
     * Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
     */
    meeting_password_requirement?: {
      consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
      /**
       * If set to `true`, the password must contain at least 1 letter (such as a,b,c...).
       *
       */
      have_letter?: boolean;
      /**
       * If set to `true`, the password must contain at least 1 number (such as 1,2,3...).
       */
      have_number?: boolean;
      /**
       * If set to `true`, the password must have at least 1 special character (!,@,#...).
       */
      have_special_character?: boolean;
      /**
       * If set to `true`, the password must include both uppercase and lowercase characters.
       */
      have_upper_and_lower_characters?: boolean;
      /**
       * The minimum length that the meeting/webinar password needs to have.
       */
      length?: number;
      /**
       * If set to `true`, the password must only contain numbers and no other characters.
       */
      only_allow_numeric?: boolean;
      /**
       * If set to `true`, users will be informed if the provided password is weak.
       */
      weak_enhance_detection?: boolean;
    };
    /**
     * Always display "Zoom Meeting" as the meeting topic.
     */
    not_store_meeting_topic?: boolean;
    /**
     * Start meetings with the participant video on. Participants can change this setting during the meeting.
     */
    participant_video?: boolean;
    /**
     * Personal Meeting Setting.<br><br>
     * `true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>
     * `false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.
     * For Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.
     *
     *
     *
     */
    personal_meeting?: boolean;
    /**
     * Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
     *
     */
    require_password_for_instant_meetings?: boolean;
    /**
     * Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
     *
     */
    require_password_for_pmi_meetings?: 'jbh_only' | 'all' | 'none';
    /**
     * Require a password for meetings which have already been scheduled
     *
     */
    require_password_for_scheduled_meetings?: boolean;
    /**
     * Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
     */
    require_password_for_scheduling_new_meetings?: boolean;
    /**
     * Use Personal Meeting ID (PMI) when starting an instant meeting
     *
     */
    use_pmi_for_instant_meetings?: boolean;
    /**
     * Use Personal Meeting ID (PMI) when scheduling a meeting
     *
     */
    use_pmi_for_scheduled_meetings?: boolean;
  };
  /**
   * [Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.
   */
  security?: {
    /**
     * Only account administrators can change a user's username and picture.
     */
    admin_change_name_pic?: boolean;
    /**
     * Hide billing information.
     */
    hide_billing_info?: boolean;
    /**
     * Allow users to import photos from a photo library on a  device.
     */
    import_photos_from_devices?: boolean;
    /**
     * This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password.
     */
    password_requirement?: {
      /**
       *
       * Specify the max length of consecutive characters(abcde...) that can be used in a password.
       * If you set the value of this field to `0`, no restriction will be applied on consecutive characters.
       *
       * If you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.
       *
       * The max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).
       */
      consecutive_characters_length?: number;
      /**
       * If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).
       */
      have_special_character?: boolean;
      /**
       * Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.
       */
      minimum_password_length?: number;
      /**
       * If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.
       */
      weak_enhance_detection?: boolean;
    };
    /**
     * Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>
     *
     * If this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>
     *
     * `5`: 5 minutes<br>
     * `10`: 10 minutes<br>
     * `15`: 15 minutes<br>
     * `30`: 30 minutes<br>
     * `45`: 45 minutes<br>
     * `60`: 60 minutes<br>
     * `90`: 90 minutes<br>
     * `120`: 120 minutes
     *
     */
    sign_again_period_for_inactivity_on_client?: number;
    /**
     * Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>
     *
     * If this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>
     *
     * `5`: 5 minutes<br>
     * `10`: 10 minutes<br>
     * `15`: 15 minutes<br>
     * `30`: 30 minutes<br>
     * `60`: 60 minutes<br>
     * `120`: 120 minutes
     *
     *
     *
     *
     */
    sign_again_period_for_inactivity_on_web?: number;
    /**
     * Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:
     * `all`: Two factor authentication will be enabled for all users in the account.<br>
     * `none`: Two factor authentication is disabled.<br>
     * `group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>
     * `role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the
     * `sign_in_with_two_factor_auth_roles` field.
     *
     */
    sign_in_with_two_factor_auth?: 'all' | 'group' | 'role' | 'none';
    /**
     * This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`
     */
    sign_in_with_two_factor_auth_groups?: Array<string>;
    /**
     * This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.
     */
    sign_in_with_two_factor_auth_roles?: Array<string>;
  };
  /**
   * Account Settings Update: Telephony.
   */
  telephony?: {
    /**
     * Third party audio conference info.
     */
    audio_conference_info?: string;
    /**
     * Indicates where most of the participants call into or call from duriing a meeting.
     */
    telephony_regions?: {
      /**
       * Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.
       */
      selection_values?: Array<string>;
    };
    /**
     * Users can join the meeting using the existing third party audio configuration.
     */
    third_party_audio?: boolean;
  };
  /**
   * Account Settings: TSP.
   */
  tsp?: {
    /**
     * Call Out
     */
    call_out?: boolean;
    /**
     * Call Out Countries/Regions
     */
    call_out_countries?: Array<unknown>;
    /**
     * Display toll-free numbers
     */
    display_toll_free_numbers?: boolean;
    /**
     * Show international numbers link on the invitation email
     */
    show_international_numbers_link?: boolean;
  };
  /**
   * Account Settings: Zoom Rooms.
   */
  zoom_rooms?: {
    /**
     * Automatic start and stop for scheduled meetings.
     */
    auto_start_stop_scheduled_meetings?: boolean;
    /**
     * Cloud recording for instant meetings.
     */
    cmr_for_instant_meeting?: boolean;
    /**
     * Shift all meetings to private.
     */
    force_private_meeting?: boolean;
    /**
     * Hide host and meeting ID from private meetings.
     */
    hide_host_information?: boolean;
    /**
     * Display meeting list with calendar integration.
     */
    list_meetings_with_calendar?: boolean;
    /**
     * Start AirPlay service manually.
     */
    start_airplay_manually?: boolean;
    /**
     * Automatic direct sharing using an ultrasonic proximity signal.
     */
    ultrasonic?: boolean;
    /**
     * Upcoming meeting alert.
     */
    upcoming_meeting_alert?: boolean;
    /**
     * Weekly system restart.
     */
    weekly_system_restart?: boolean;
    /**
     * Zoom Room post meeting feedback.
     */
    zr_post_meeting_feedback?: boolean;
  };
};

/**
 * Billing Contact object.
 */
export type BillingContact = {
  /**
   * Billing Contact's address.
   */
  address?: string;
  /**
   * Billing Contact's apartment/suite.
   */
  apt?: string;
  /**
   * Billing Contact's city.
   */
  city?: string;
  /**
   * Billing Contact's country.
   */
  country?: string;
  /**
   * Billing Contact's email address.
   */
  email?: string;
  /**
   * Billing Contact's first name.
   */
  first_name?: string;
  /**
   * Billing Contact's last name.
   */
  last_name?: string;
  /**
   * Billing Contact's phone number.
   */
  phone_number?: string;
  /**
   * Billing Contact's state.
   */
  state?: string;
  /**
   * Billing Contact's zip/postal code.
   */
  zip?: string;
};

/**
 * Billing Contact object.
 */
export type BillingContactRequired = {
  /**
   * Billing Contact's address.
   */
  address: string;
  /**
   * Billing Contact's apartment/suite.
   */
  apt?: string;
  /**
   * Billing Contact's city.
   */
  city: string;
  /**
   * Billing Contact's Country [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) in abbreviated format.
   */
  country: string;
  /**
   * Billing Contact's email address.
   */
  email: string;
  /**
   * Billing Contact's first name.
   */
  first_name: string;
  /**
   * Billing Contact's last name.
   */
  last_name: string;
  /**
   * Billing Contact's phone number.
   */
  phone_number: string;
  /**
   * Billing Contact's state.
   */
  state: string;
  /**
   * Billing Contact's zip/postal code.
   */
  zip: string;
};

/**
 * The channel object represents a Zoom chat [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-).
 */
export type Channel = {
  /**
   * Channel Id.
   */
  id?: string;
  /**
   * Name of the channel.
   */
  name?: string;
  /**
   * Type of the channel. The value can be one of the following:<br>
   * `1`: Private channel. In this type of channel, members must be invited to join a channel.<br>
   * `2`: Private channel with members that belong to one Zoom account. Members in this channel should be invited and the members should be from the same organization.<br>
   * `3`: Public channel. Anyone can search for this channel and join the channel.<br>
   */
  type?: 1 | 2 | 3;
};

export type CloudArchivedFiles = {
  /**
   * An explanation about the purpose of this instance.
   */
  archive_files: Array<{
    /**
     * The URL where the archived file can be downloaded. To download the archived file of a meeting or a webinar hosted in your account, create a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the `access_token` query parameter and include this query parameter at the end of the URL as shown in the example. Example: `https://{{base-domain}}/rec/archive/download/xxx?access_token={{Your-JWT}}`.<br>If a user has authorized and installed your OAuth app that supports archiving, use the user’s [OAuth access token(https://marketplace.zoom.us/docs/guides/auth/oauth) to download the file.<br>For example: `https://{{base-domain}}/rec/archive/download/xxx?access_token={{ OAuth Access Token }}`.
     */
    download_url: string;
    /**
     * The file extension of the recording.
     */
    file_extension: string;
    /**
     * The file size of the recording.
     */
    file_size: number;
    /**
     * The file type of the recording. The value of this field could be one of the following:`MP4`: Video file of the recording.<br>`M4A`: Audio-only file of the recording.<br>`TRANSCRIPT`: Transcription file of the recording in VTT format.<br>`CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>`CC`: File containing closed captions of the recording in VTT file format.<br>`CSV`: File containing polling data in csv format. See [Managing and sharing cloud recordings](https://support.zoom.us/hc/en-us/articles/205347605-Managing-and-sharing-cloud-recordings#h_9898497b-e736-4980-a749-d55608f10773) for details.
     */
    file_type: string;
    /**
     * The unique identifier of the archived file.
     */
    id: string;
    /**
     * The value of this field can be one of the following:* `shared_screen_with_speaker_view(CC)`* `shared_screen_with_speaker_view`* `shared_screen_with_gallery_view`* `speaker_view`* `gallery_view`* `shared_screen`* `audio_only`* `audio_transcript`* `chat_file`,* `active_speaker`* `host_video`. See [Managing and sharing cloud recordings](https://support.zoom.us/hc/en-us/articles/205347605-Managing-and-sharing-cloud-recordings#h_9898497b-e736-4980-a749-d55608f10773) for details.
     */
    recording_type: string;
    /**
     * Status of the archived file.
     */
    status: string;
  }>;
  /**
   * The duration.
   */
  duration: number;
  /**
   * The ID of the user who set as the host of the meeting.
   */
  host_id: string;
  /**
   * The Meeting ID, also known as the meeting number in long (int64) format.
   */
  id: number;
  /**
   * Number of recording files returned in the response of this API call.
   */
  recording_count: number;
  /**
   * Meeting start time.
   */
  start_time: string;
  /**
   * Timezone to format the meeting start time.
   */
  timezone: string;
  /**
   * The meeting topic.
   */
  topic: string;
  /**
   * Total size of the archive.
   */
  total_size: number;
  /**
   * The meeting type:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.
   */
  type: 1 | 2 | 3 | 8;
  /**
   * The Unique Meeting ID. Each meeting instance will generate its own Meeting UUID.
   */
  uuid: string;
};

/**
 * The meeting type:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.
 */
export type type4 = 1 | 2 | 3 | 8;

/**
 * Create Webinar settings.
 */
export type CreateWebinarSettings = {
  /**
   * Allow attendees to join from multiple devices.
   */
  allow_multiple_devices?: boolean;
  /**
   * Alternative host emails or IDs. Multiple values separated by comma.
   */
  alternative_hosts?: string;
  /**
   * The default value is `2`. To enable registration required, set the approval type to `0` or `1`.  Values include:<br>
   *
   * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
   */
  approval_type?: 0 | 1 | 2;
  /**
   * Send reminder email to attendees and panelists.
   */
  attendees_and_panelists_reminder_email_notification?: {
    /**
     * * `true`: Send reminder email to attendees and panelists.
     *
     * * `false`: Do not send reminder email to attendees and panelists.
     */
    enable?: boolean;
    /**
     * `0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.
     */
    type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
  };
  /**
   * Determine how participants can join the audio portion of the meeting.
   */
  audio?: 'both' | 'telephony' | 'voip';
  /**
   * Meeting authentication domains. This option, allows you to specify the rule so that Zoom users, whose email address contains a certain domain, can join the Webinar. You can either provide multiple domains, using a comma in between and/or use a wildcard for listing domains.
   */
  authentication_domains?: string;
  /**
   * Specify the authentication type for users to join a Webinar with`meeting_authentication` setting set to `true`. The value of this field can be retrieved from the `id` field within `authentication_options` array in the response of [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings).
   */
  authentication_option?: string;
  /**
   * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
   */
  auto_recording?: 'local' | 'cloud' | 'none';
  /**
   * Close registration after event date.
   */
  close_registration?: boolean;
  /**
   * Contact email for registration
   */
  contact_email?: string;
  /**
   * Contact name for registration
   */
  contact_name?: string;
  /**
   * Set the email language to one of the following:
   * `en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.
   */
  email_language?: string;
  /**
   * Only signed-in users can join this meeting.
   *
   * **This field is deprecated and will not be supported in future.** <br><br> Instead of this field, use the "meeting_authentication", "authentication_option" and/or "authentication_domains" fields to establish the authentication mechanism for this Webinar.
   */
  enforce_login?: boolean;
  /**
   * Only signed-in users with specified domains can join meetings.
   *
   * **This field is deprecated and will not be supported in future.** <br><br> Instead of this field, use the "authentication_domains" field for this Webinar.
   */
  enforce_login_domains?: string;
  /**
   * Send follow-up email to absentees.
   */
  follow_up_absentees_email_notification?: {
    /**
     * * `true`: Send follow-up email to absentees.
     *
     * * `false`: Do not send follow-up email to absentees.
     */
    enable?: boolean;
    /**
     * `0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
     */
    type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
  };
  /**
   * Send follow-up email to attendees.
   */
  follow_up_attendees_email_notification?: {
    /**
     * * `true`: Send follow-up email to attendees.
     *
     * * `false`: Do not send follow-up email to attendees.
     */
    enable?: boolean;
    /**
     * `0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
     */
    type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
  };
  /**
   * List of global dial-in countries
   */
  global_dial_in_countries?: Array<string>;
  /**
   * Default to HD video.
   */
  hd_video?: boolean;
  /**
   * Start video when host joins webinar.
   */
  host_video?: boolean;
  /**
   * Only [authenticated](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) users can join meeting if the value of this field is set to `true`.
   */
  meeting_authentication?: boolean;
  /**
   * Make the webinar on-demand
   */
  on_demand?: boolean;
  /**
   * * `true`: Send invitation email to panelists.
   *
   * * `false`: Do not send invitation email to panelists.
   */
  panelists_invitation_email_notification?: boolean;
  /**
   * Start video when panelists join webinar.
   */
  panelists_video?: boolean;
  /**
   * Zoom will open a survey page in attendees' browsers after leaving the webinar
   */
  post_webinar_survey?: boolean;
  /**
   * Enable practice session.
   */
  practice_session?: boolean;
  /**
   * [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
   */
  question_and_answer?: {
    /**
     * * `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..
     *
     * * `false`: Do not allow anonymous questions.
     */
    allow_anonymous_questions?: boolean;
    /**
     * Indicate whether you want attendees to be able to view answered questions only or view all questions.
     *
     * * `only`: Attendees are able to view answered questions only.
     *
     * *  `all`: Attendees are able to view all questions submitted in the Q&A.
     */
    answer_questions?: 'only' | 'all';
    /**
     * * `true`: Attendees can answer questions or leave a comment in the question thread.
     *
     * * `false`: Attendees can not answer questions or leave a comment in the question thread
     */
    attendees_can_comment?: boolean;
    /**
     * * `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.
     *
     * * `false`: Attendees can not click the thumbs up butoon on questions.
     */
    attendees_can_upvote?: boolean;
    /**
     * * `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
     *
     * * `false`: Disable Q&A for webinar.
     */
    enable?: boolean;
  };
  /**
   * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
   */
  registrants_email_notification?: boolean;
  /**
   * Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.
   */
  registrants_restrict_number?: number;
  /**
   * Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.
   */
  registration_type?: 1 | 2 | 3;
  /**
   * Show social share buttons on the registration page.
   */
  show_share_button?: boolean;
  /**
   * Survey url for post webinar survey
   */
  survey_url?: string;
};

/**
 * The default value is `2`. To enable registration required, set the approval type to `0` or `1`.  Values include:<br>
 *
 * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
 */
export type approval_type = 0 | 1 | 2;

/**
 * `0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.
 */
export type type5 = 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;

/**
 * Determine how participants can join the audio portion of the meeting.
 */
export type audio = 'both' | 'telephony' | 'voip';

/**
 * Indicate whether you want attendees to be able to view answered questions only or view all questions.
 *
 * * `only`: Attendees are able to view answered questions only.
 *
 * *  `all`: Attendees are able to view all questions submitted in the Q&A.
 */
export type answer_questions = 'only' | 'all';

/**
 * Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.
 */
export type registration_type = 1 | 2 | 3;

/**
 * Custom Question.
 */
export type CustomQuestion = {
  title?: string;
  value?: string;
};

/**
 * DateTime Object.
 */
export type DateTime = {
  /**
   * Start Date.
   */
  from?: string;
  /**
   * End Date.
   */
  to?: string;
};

/**
 * The H.323/SIP device object.
 */
export type Device = {
  /**
   * Device encryption:<br>`auto` - auto.<br>`yes` - yes.<br>`no` - no.
   */
  encryption: 'auto' | 'yes' | 'no';
  /**
   * Device IP.
   */
  ip: string;
  /**
   * Device name.
   */
  name: string;
  /**
   * Device protocol:<br>`H.323` - H.323.<br>`SIP` - SIP.
   */
  protocol: 'H.323' | 'SIP';
};

/**
 * Device encryption:<br>`auto` - auto.<br>`yes` - yes.<br>`no` - no.
 */
export type encryption = 'auto' | 'yes' | 'no';

/**
 * Device protocol:<br>`H.323` - H.323.<br>`SIP` - SIP.
 */
export type protocol = 'H.323' | 'SIP';

/**
 * List of H.323/SIP Devices.
 */
export type DeviceList = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of H.323/SIP Device objects.
   */
  devices?: Array<
    {
      /**
       * Device ID.
       */
      id?: string;
    } & {
      /**
       * Device encryption:<br>`auto` - auto.<br>`yes` - yes.<br>`no` - no.
       */
      encryption: 'auto' | 'yes' | 'no';
      /**
       * Device IP.
       */
      ip: string;
      /**
       * Device name.
       */
      name: string;
      /**
       * Device protocol:<br>`H.323` - H.323.<br>`SIP` - SIP.
       */
      protocol: 'H.323' | 'SIP';
    }
  >;
};

/**
 * List of managed domains.
 */
export type DomainsList = {
  /**
   * List of managed domain objects.
   */
  domains?: Array<{
    /**
     * Domain name.
     */
    domain?: string;
    /**
     * Domain status.
     */
    status?: string;
  }>;
  /**
   * Total records.
   */
  total_records?: number;
};

/**
 * Group object.
 */
export type Group = {
  /**
   * Group name.
   */
  name?: string;
  /**
   * Total number of members in this group.
   */
  total_members?: number;
};

/**
 * List of Groups.
 */
export type GroupList = {
  /**
   * List of Group objects.
   */
  groups?: Array<
    {
      /**
       * Group ID.
       */
      id?: string;
    } & {
      /**
       * Group name.
       */
      name?: string;
      /**
       * Total number of members in this group.
       */
      total_members?: number;
    }
  >;
  /**
   * Total records.
   */
  total_records?: number;
};

/**
 * Group member object.
 */
export type GroupMember = {
  /**
   * User email.
   */
  email?: string;
  /**
   * User first name.
   */
  first_name?: string;
  /**
   * User ID.
   */
  id?: string;
  /**
   * User last name.
   */
  last_name?: string;
  /**
   * User type.<br>
   * `1` - Basic<br> `2` - Licensed<br>
   * `3` - On-prem
   */
  type?: number;
};

/**
 * List of Group Members.
 */
export type GroupMemberList = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of Group member objects.
   */
  members?: Array<{
    /**
     * User email.
     */
    email?: string;
    /**
     * User first name.
     */
    first_name?: string;
    /**
     * User ID.
     */
    id?: string;
    /**
     * User last name.
     */
    last_name?: string;
    /**
     * User type.<br>
     * `1` - Basic<br> `2` - Licensed<br>
     * `3` - On-prem
     */
    type?: number;
  }>;
};

export type GroupUserSettingsAuthentication =
  | {
      /**
       * Meeting Authentication Options
       */
      authentication_options?: Array<{
        /**
         * Authentication default option
         */
        default_option?: boolean;
        /**
         * Authentication domains
         */
        domains?: string;
        /**
         * Authentication id
         */
        id?: string;
        /**
         * Authentication name
         */
        name?: string;
        /**
         *  Authentication type. Specify one of the following authentication types for the authentication profile:<br>
         * * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.
         * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>
         * * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.
         */
        type?: 'enforce_login' | 'enforce_login_with_same_account' | 'enforce_login_with_domains';
        /**
         * Authentication visible
         */
        visible?: boolean;
      }>;
      /**
       * Only authenticated users can join meetings
       */
      meeting_authentication?: boolean;
    }
  | {
      /**
       * Authentication Options
       */
      authentication_options?: Array<{
        /**
         * Authentication default option
         */
        default_option?: boolean;
        /**
         * Authentication domians
         */
        domains?: string;
        /**
         * Authentication id
         */
        id?: string;
        /**
         * Authentication name
         */
        name?: string;
        /**
         * Authentication type
         */
        type?: 'internally' | 'enforce_login' | 'enforce_login_with_domains';
        /**
         * Authentication visible
         */
        visible?: boolean;
      }>;
      /**
       * Only authenticated users can view cloud recordings
       */
      recording_authentication?: boolean;
    };

export type GroupUserSettingsAuthenticationUpdate =
  | {
      /**
       * Meeting Authentication Options
       */
      authentication_option?: {
        /**
         * Authentication action
         */
        action?: 'update' | 'show' | 'hide';
        /**
         * Authentication default option
         */
        default_option?: boolean;
        /**
         * Authentication domains
         */
        domains?: string;
        /**
         * Authentication id
         */
        id?: string;
        /**
         * Authentication name
         */
        name?: string;
        /**
         *  Authentication type. Specify one of the following authentication types for the authentication profile:<br>
         * * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.
         * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>
         * * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.
         */
        type?: 'enforce_login' | 'enforce_login_with_same_account' | 'enforce_login_with_domains';
      };
      /**
       * Only authenticated users can join meetings
       */
      meeting_authentication?: boolean;
    }
  | {
      /**
       * Authentication Options
       */
      authentication_option?: {
        /**
         * Authentication action
         */
        action?: 'update' | 'show' | 'hide';
        /**
         * Authentication default option
         */
        default_option?: boolean;
        /**
         * Authentication domians
         */
        domians?: string;
        /**
         * Authentication id
         */
        id?: string;
        /**
         * Authentication name
         */
        name?: string;
        /**
         * Authentication type
         */
        type?: 'internally' | 'enforce_login' | 'enforce_login_with_domains';
      };
      /**
       * Only authenticated users can view cloud recordings
       */
      recording_authentication?: boolean;
    };

/**
 * Authentication action
 */
export type action2 = 'update' | 'show' | 'hide';

/**
 * IM group object.
 */
export type IMGroup = {
  /**
   * Group name.
   */
  name?: string;
  /**
   * Total number of members in this group.
   */
  total_members?: number;
} & {
  /**
   * Members can search for others under same account.
   */
  search_by_account?: boolean;
  /**
   * Members can search for others in the same email domain.
   */
  search_by_domain?: boolean;
  /**
   * Members can search for others under same master account - including all sub accounts.
   */
  search_by_ma_account?: boolean;
  /**
   * IM Group types:<br>`normal` - Only members can see the other members in the group. Other people can search for members in the group.<br>`shared` - Everyone in the account can see the group and members. <br>`restricted` - No one except group members can see the group or search for other group members.
   */
  type?: 'normal' | 'shared' | 'restricted';
};

/**
 * IM Group types:<br>`normal` - Only members can see the other members in the group. Other people can search for members in the group.<br>`shared` - Everyone in the account can see the group and members. <br>`restricted` - No one except group members can see the group or search for other group members.
 */
export type type6 = 'normal' | 'shared' | 'restricted';

/**
 * List of IM Groups.
 */
export type IMGroupList = {
  /**
   * Total number of records returned.
   */
  total_records?: number;
} & {
  /**
   * List of group objects.
   */
  groups?: Array<
    {
      /**
       * IM group ID.
       */
      id?: string;
    } & ({
      /**
       * Group name.
       */
      name?: string;
      /**
       * Total number of members in this group.
       */
      total_members?: number;
    } & {
      /**
       * Members can search for others under same account.
       */
      search_by_account?: boolean;
      /**
       * Members can search for others in the same email domain.
       */
      search_by_domain?: boolean;
      /**
       * Members can search for others under same master account - including all sub accounts.
       */
      search_by_ma_account?: boolean;
      /**
       * IM Group types:<br>`normal` - Only members can see the other members in the group. Other people can search for members in the group.<br>`shared` - Everyone in the account can see the group and members. <br>`restricted` - No one except group members can see the group or search for other group members.
       */
      type?: 'normal' | 'shared' | 'restricted';
    })
  >;
};

/**
 * Meeting object.
 */
export type Meeting = {
  /**
   * Meeting description.
   */
  agenda?: string;
  /**
   * Meeting duration (minutes). Used for scheduled meetings only.
   */
  duration?: number;
  /**
   * Password to join the meeting. Password may only contain the following characters: [a-z A-Z 0-9 @ - _ *]. Max of 10 characters.
   */
  password?: string;
  /**
   * Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time.
   */
  recurrence?: {
    /**
     * Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
     *
     * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.
     *
     *
     */
    repeat_interval?: number;
    /**
     * Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    weekly_days?: '1' | '2' | '3' | '4' | '5' | '6' | '7';
  };
  /**
   * Meeting settings.
   */
  settings?: {
    /**
     * Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host's emails or IDs: multiple values are separated by a semicolon.
     */
    alternative_hosts?: string;
    /**
     * Flag to determine whether to send email notifications to alternative hosts, default value is true.
     */
    alternative_hosts_email_notification?: boolean;
    /**
     * Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>
     *
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Approve or block users from specific regions/countries from joining this meeting.
     *
     */
    approved_or_denied_countries_or_regions?: {
      /**
       * List of countries/regions from where participants can join this meeting.
       */
      approved_list?: Array<string>;
      /**
       * List of countries/regions from where participants can not join this meeting.
       */
      denied_list?: Array<string>;
      /**
       * `true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>
       *
       * `false`: Setting disabled.
       */
      enable?: boolean;
      /**
       * Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>
       * `approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>
       * `deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`
       */
      method?: 'approve' | 'deny';
    };
    /**
     * Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
     */
    authentication_domains?: string;
    /**
     * The participants added here will receive unique meeting invite links and bypass authentication.
     */
    authentication_exception?: Array<{
      /**
       * Email address of the participant.
       */
      email?: string;
      /**
       * Name of the participant.
       */
      name?: string;
    }>;
    /**
     * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
     */
    authentication_name?: string;
    /**
     * Meeting authentication option id.
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).
     */
    breakout_room?: {
      /**
       * Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.
       */
      enable?: boolean;
      /**
       * Create room(s).
       */
      rooms?: Array<{
        /**
         * Name of the breakout room.
         */
        name?: string;
        /**
         * Email addresses of the participants who are to be assigned to the breakout room.
         */
        participants?: Array<string>;
      }>;
    };
    /**
     * Close registration after event date
     */
    close_registration?: boolean;
    /**
     * Host meeting in China.
     */
    cn_meeting?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Custom keys and values assigned to the meeting.
     */
    custom_keys?: Array<{
      /**
       * Custom key associated with the user.
       */
      key?: string;
      /**
       * Value of the custom key associated with the user.
       */
      value?: string;
    }>;
    /**
     * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
     * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
     *
     * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
     */
    encryption_type?: 'enhanced_encryption' | 'e2ee';
    /**
     * Only signed in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login_domains?: string;
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Global Dial-in Countries/Regions
     */
    global_dial_in_numbers?: Array<{
      /**
       * City of the number, if any. For example, Chicago.
       */
      city?: string;
      /**
       * Country code. For example, BR.
       */
      country?: string;
      /**
       * Full name of country. For example, Brazil.
       */
      country_name?: string;
      /**
       * Phone number. For example, +1 2332357613.
       */
      number?: string;
      /**
       * Type of number.
       */
      type?: 'toll' | 'tollfree';
    }>;
    /**
     * Start video when the host joins the meeting.
     */
    host_video?: boolean;
    /**
     * Host meeting in India.
     */
    in_meeting?: boolean;
    /**
     * If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:
     *
     * *  `0`: Allow participant to join anytime.
     * *  `5`: Allow participant to join 5 minutes before meeting start time.
     * * `10`: Allow participant to join 10 minutes before meeting start time.
     */
    jbh_time?: 0 | 5 | 10;
    /**
     * Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.
     */
    join_before_host?: boolean;
    language_interpretation?: {
      enable?: boolean;
      /**
       * Information associated with the interpreter.
       */
      interpreters?: Array<{
        /**
         * Email address of the interpreter.
         */
        email?: string;
        /**
         * Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma.
         *
         * For example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".
         */
        languages?: string;
      }>;
    };
    /**
     * `true`- Only authenticated users can join meetings.
     */
    meeting_authentication?: boolean;
    /**
     * Mute participants upon entry.
     */
    mute_upon_entry?: boolean;
    /**
     * Start video when participants join the meeting.
     */
    participant_video?: boolean;
    /**
     * Send confirmation email to registrants upon successful registration.
     */
    registrants_confirmation_email?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the meeting registration page.
     * This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    show_share_button?: boolean;
    /**
     * Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.
     */
    use_pmi?: boolean;
    /**
     * Enable waiting room
     */
    waiting_room?: boolean;
    /**
     * Add watermark when viewing a shared screen.
     */
    watermark?: boolean;
  };
  /**
   * Meeting start time. When using a format like "yyyy-MM-dd'T'HH:mm:ss'Z'", always use GMT time. When using a format like "yyyy-MM-dd'T'HH:mm:ss", you should use local time and specify the time zone. This is only used for scheduled meetings and recurring meetings with a fixed time.
   */
  start_time?: string;
  /**
   * Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) list for supported time zones and their formats.
   */
  timezone?: string;
  /**
   * Meeting topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Tracking fields type
     */
    field?: string;
    /**
     * Tracking fields value
     */
    value?: string;
  }>;
  /**
   * Meeting Type:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.
   */
  type?: 1 | 2 | 3 | 8;
};

/**
 * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
 */
export type monthly_week = -1 | 1 | 2 | 3 | 4;

/**
 * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
 *
 * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
 */
export type monthly_week_day = 1 | 2 | 3 | 4 | 5 | 6 | 7;

/**
 * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
 *
 * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
 */
export type weekly_days = '1' | '2' | '3' | '4' | '5' | '6' | '7';

/**
 * Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>
 * `approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>
 * `deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`
 */
export type method = 'approve' | 'deny';

/**
 * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
 * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
 *
 * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
 */
export type encryption_type = 'enhanced_encryption' | 'e2ee';

/**
 * If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:
 *
 * *  `0`: Allow participant to join anytime.
 * *  `5`: Allow participant to join 5 minutes before meeting start time.
 * * `10`: Allow participant to join 10 minutes before meeting start time.
 */
export type jbh_time = 0 | 5 | 10;

/**
 * Base object for meeting.
 */
export type MeetingCreate = {
  /**
   * Meeting description.
   */
  agenda?: string;
  /**
   * Meeting duration (minutes). Used for scheduled meetings only.
   */
  duration?: number;
  /**
   * Passcode to join the meeting. By default, passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ *] and can have a maximum of 10 characters.
   *
   * **Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API.
   */
  password?: string;
  /**
   * Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time.
   */
  recurrence?: {
    /**
     * Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
     *
     * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.
     *
     *
     */
    repeat_interval?: number;
    /**
     * Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    weekly_days?: '1' | '2' | '3' | '4' | '5' | '6' | '7';
  };
  /**
   * If you would like to schedule this meeting for someone else in your account, provide the Zoom user id or email address of the user here.
   */
  schedule_for?: string;
  /**
   * Meeting settings.
   */
  settings?: {
    /**
     * Enable additional [data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) for this meeting. Provide the value in the form of array of country code(s) for the countries which are available as data center regions in the [account settings](https://zoom.us/account/setting) but have been opt out of in the user settings. For instance, let's say that in your account settings, the data center regions that have been selected are Europe, Honkong, Australia, India, Latin America, Japan, China, United States,and Canada. The complete list of available data center regions for your account is: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]. In [user settings](https://zoom.us/profile/setting), you have opted out of India(IN) and Japan(TY) for meeting and webinar traffic routing. If you would like, you can still include India and Japan as additional data centers for this meeting using this field. To include India and Japan as additional data center regions, you would provide ["IN", "TY"] as the value.
     */
    additional_data_center_regions?: Array<string>;
    /**
     * If set to `true`, attendees will be allowed to join a meeting from multiple devices.
     *
     * **Note:** This setting is only applied for meetings that have enabled registration.
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host's emails or IDs: multiple values separated by a comma.
     */
    alternative_hosts?: string;
    /**
     * Flag to determine whether to send email notifications to alternative hosts, default value is true.
     */
    alternative_hosts_email_notification?: boolean;
    /**
     * The default value is `2`. To enable registration required, set the approval type to `0` or `1`. Values include:<br>
     *
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Approve or block users from specific regions/countries from joining this meeting.
     *
     */
    approved_or_denied_countries_or_regions?: {
      /**
       * List of countries/regions from where participants can join this meeting.
       */
      approved_list?: Array<string>;
      /**
       * List of countries/regions from where participants can not join this meeting.
       */
      denied_list?: Array<string>;
      /**
       * `true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>
       *
       * `false`: Setting disabled.
       */
      enable?: boolean;
      /**
       * Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>
       * `approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>
       * `deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`
       */
      method?: 'approve' | 'deny';
    };
    /**
     * Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * Meeting authentication domains. This option, allows you to specify the rule so that Zoom users, whose email address contains a certain domain, can join the meeting. You can either provide multiple domains, using a comma in between and/or use a wildcard for listing domains.
     */
    authentication_domains?: string;
    /**
     * Specify the authentication type for users to join a meeting with`meeting_authentication` setting set to `true`. The value of this field can be retrieved from the `id` field within `authentication_options` array in the response of [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings).
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).
     */
    breakout_room?: {
      /**
       * Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.
       */
      enable?: boolean;
      /**
       * Create room(s).
       */
      rooms?: Array<{
        /**
         * Name of the breakout room.
         */
        name?: string;
        /**
         * Email addresses of the participants who are to be assigned to the breakout room.
         */
        participants?: Array<string>;
      }>;
    };
    /**
     * Close registration after event date
     */
    close_registration?: boolean;
    /**
     * Host meeting in China.
     */
    cn_meeting?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
     * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
     *
     * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
     */
    encryption_type?: 'enhanced_encryption' | 'e2ee';
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Start video when the host joins the meeting.
     */
    host_video?: boolean;
    /**
     * Host meeting in India.
     */
    in_meeting?: boolean;
    /**
     * If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:
     *
     * *  `0`: Allow participant to join anytime.
     * *  `5`: Allow participant to join 5 minutes before meeting start time.
     * * `10`: Allow participant to join 10 minutes before meeting start time.
     */
    jbh_time?: 0 | 5 | 10;
    /**
     * Allow participants to join the meeting before the host starts the meeting. This field can only used for scheduled or recurring meetings.
     *
     * **Note:** If waiting room is enabled, the **join before host** setting will be disabled.
     */
    join_before_host?: boolean;
    /**
     * Language interpretation [settings](https://support.zoom.us/hc/en-us/articles/360034919791-Language-interpretation-in-meetings-and-webinars#h_01EGGQFD3Q4BST3378SA762MJ1) for meetings.
     *
     * **Note:** This feature is only available on certain Webinar add-on, Education, Business and higher plans. If this feature is not enabled on the host's account, this setting will not be applied for the meeting.
     */
    language_interpretation?: {
      /**
       * Indicate whether or not you would like to enable [language interpretation](https://support.zoom.us/hc/en-us/articles/360034919791-Language-interpretation-in-meetings-and-webinars#h_01EGGQFD3Q4BST3378SA762MJ1) for this meeting.
       */
      enable?: boolean;
      /**
       * Information associated with the interpreter.
       */
      interpreters?: Array<{
        /**
         * Email address of the interpreter.
         */
        email?: string;
        /**
         * Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma.
         *
         * For example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".
         */
        languages?: string;
      }>;
    };
    /**
     * Only [authenticated](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) users can join meeting if the value of this field is set to `true`.
     */
    meeting_authentication?: boolean;
    /**
     * Mute participants upon entry.
     */
    mute_upon_entry?: boolean;
    /**
     * Start video when participants join the meeting.
     */
    participant_video?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * If set to `true`, the registration page for the meeting will include social share buttons.
     *
     * **Note:** This setting is only applied for meetings that have enabled registration.
     */
    show_share_button?: boolean;
    /**
     * Use Personal Meeting ID instead of an automatically generated meeting ID. It can only be used for scheduled meetings, instant meetings and recurring meetings with no fixed time.
     */
    use_pmi?: boolean;
    /**
     * Enable waiting room. Note that if the value of this field is set to `true`, it will override and disable the `join_before_host` setting.
     */
    waiting_room?: boolean;
    /**
     * Add watermark when viewing a shared screen.
     */
    watermark?: boolean;
  };
  /**
   * Meeting start time. We support two formats for `start_time` - local time and GMT.<br>
   *
   * To set time as GMT the format should be `yyyy-MM-dd`T`HH:mm:ssZ`. Example: "2020-03-31T12:02:00Z"
   *
   * To set time using a specific timezone, use `yyyy-MM-dd`T`HH:mm:ss` format and specify the timezone [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) in the `timezone` field OR leave it blank and the timezone set on your Zoom account will be used. You can also set the time as UTC as the timezone field.
   *
   * The `start_time` should only be used for scheduled and / or recurring webinars with fixed time.
   */
  start_time?: string;
  /**
   * Unique identifier of the **admin meeting template**. To create admin meeting templates, contact the Zoom support team.
   *
   * Use this field if you would like to [schedule the meeting from a admin meeting template](https://support.zoom.us/hc/en-us/articles/360036559151-Meeting-templates#h_86f06cff-0852-4998-81c5-c83663c176fb). You can retrieve the value of this field by calling the [List meeting templates](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/listmeetingtemplates) API.
   */
  template_id?: string;
  /**
   * Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) list for supported time zones and their formats.
   */
  timezone?: string;
  /**
   * Meeting topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Label of the tracking field.
     */
    field: string;
    /**
     * Tracking fields value
     */
    value?: string;
  }>;
  /**
   * Meeting Type:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.
   */
  type?: 1 | 2 | 3 | 8;
};

/**
 * Meeting object
 */
export type MeetingInfo = {
  /**
   * Agenda
   */
  agenda?: string;
  /**
   * The date and time at which this meeting was created.
   */
  created_at?: string;
  /**
   * Meeting duration.
   */
  duration?: number;
  /**
   * H.323/SIP room system password
   */
  h323_password?: string;
  /**
   * URL for participants to join the meeting. This URL should only be shared with users that you would like to invite for the meeting.
   */
  join_url?: string;
  /**
   * Array of occurrence objects.
   */
  occurrences?: Array<{
    /**
     * Duration.
     */
    duration?: number;
    /**
     * Occurrence ID: Unique Identifier that identifies an occurrence of a recurring webinar. [Recurring webinars](https://support.zoom.us/hc/en-us/articles/216354763-How-to-Schedule-A-Recurring-Webinar) can have a maximum of 50 occurrences.
     */
    occurrence_id?: string;
    /**
     * Start time.
     */
    start_time?: string;
    /**
     * Occurrence status.
     */
    status?: string;
  }>;
  /**
   * Meeting password. Password may only contain the following characters: `[a-z A-Z 0-9 @ - _ * !]`
   *
   * If "Require a password when scheduling new meetings" setting has been **enabled** **and** [locked](https://support.zoom.us/hc/en-us/articles/115005269866-Using-Tiered-Settings#locked) for the user, the password field will be autogenerated in the response even if it is not provided in the API request.
   *
   *
   *
   */
  password?: string;
  /**
   * Personal Meeting Id. Only used for scheduled meetings and recurring meetings with no fixed time.
   */
  pmi?: number;
  /**
   * Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time.
   */
  recurrence?: {
    /**
     * Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
     *
     * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.
     *
     *
     */
    repeat_interval?: number;
    /**
     * Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    weekly_days?: '1' | '2' | '3' | '4' | '5' | '6' | '7';
  };
  /**
   * Meeting settings.
   */
  settings?: {
    /**
     * Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host's emails or IDs: multiple values are separated by a semicolon.
     */
    alternative_hosts?: string;
    /**
     * Flag to determine whether to send email notifications to alternative hosts, default value is true.
     */
    alternative_hosts_email_notification?: boolean;
    /**
     * Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>
     *
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Approve or block users from specific regions/countries from joining this meeting.
     *
     */
    approved_or_denied_countries_or_regions?: {
      /**
       * List of countries/regions from where participants can join this meeting.
       */
      approved_list?: Array<string>;
      /**
       * List of countries/regions from where participants can not join this meeting.
       */
      denied_list?: Array<string>;
      /**
       * `true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>
       *
       * `false`: Setting disabled.
       */
      enable?: boolean;
      /**
       * Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>
       * `approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>
       * `deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`
       */
      method?: 'approve' | 'deny';
    };
    /**
     * Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
     */
    authentication_domains?: string;
    /**
     * The participants added here will receive unique meeting invite links and bypass authentication.
     */
    authentication_exception?: Array<{
      /**
       * Email address of the participant.
       */
      email?: string;
      /**
       * Name of the participant.
       */
      name?: string;
    }>;
    /**
     * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
     */
    authentication_name?: string;
    /**
     * Meeting authentication option id.
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).
     */
    breakout_room?: {
      /**
       * Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.
       */
      enable?: boolean;
      /**
       * Create room(s).
       */
      rooms?: Array<{
        /**
         * Name of the breakout room.
         */
        name?: string;
        /**
         * Email addresses of the participants who are to be assigned to the breakout room.
         */
        participants?: Array<string>;
      }>;
    };
    /**
     * Close registration after event date
     */
    close_registration?: boolean;
    /**
     * Host meeting in China.
     */
    cn_meeting?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Custom keys and values assigned to the meeting.
     */
    custom_keys?: Array<{
      /**
       * Custom key associated with the user.
       */
      key?: string;
      /**
       * Value of the custom key associated with the user.
       */
      value?: string;
    }>;
    /**
     * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
     * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
     *
     * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
     */
    encryption_type?: 'enhanced_encryption' | 'e2ee';
    /**
     * Only signed in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login_domains?: string;
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Global Dial-in Countries/Regions
     */
    global_dial_in_numbers?: Array<{
      /**
       * City of the number, if any. For example, Chicago.
       */
      city?: string;
      /**
       * Country code. For example, BR.
       */
      country?: string;
      /**
       * Full name of country. For example, Brazil.
       */
      country_name?: string;
      /**
       * Phone number. For example, +1 2332357613.
       */
      number?: string;
      /**
       * Type of number.
       */
      type?: 'toll' | 'tollfree';
    }>;
    /**
     * Start video when the host joins the meeting.
     */
    host_video?: boolean;
    /**
     * Host meeting in India.
     */
    in_meeting?: boolean;
    /**
     * If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:
     *
     * *  `0`: Allow participant to join anytime.
     * *  `5`: Allow participant to join 5 minutes before meeting start time.
     * * `10`: Allow participant to join 10 minutes before meeting start time.
     */
    jbh_time?: 0 | 5 | 10;
    /**
     * Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.
     */
    join_before_host?: boolean;
    language_interpretation?: {
      enable?: boolean;
      /**
       * Information associated with the interpreter.
       */
      interpreters?: Array<{
        /**
         * Email address of the interpreter.
         */
        email?: string;
        /**
         * Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma.
         *
         * For example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".
         */
        languages?: string;
      }>;
    };
    /**
     * `true`- Only authenticated users can join meetings.
     */
    meeting_authentication?: boolean;
    /**
     * Mute participants upon entry.
     */
    mute_upon_entry?: boolean;
    /**
     * Start video when participants join the meeting.
     */
    participant_video?: boolean;
    /**
     * Send confirmation email to registrants upon successful registration.
     */
    registrants_confirmation_email?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the meeting registration page.
     * This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    show_share_button?: boolean;
    /**
     * Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.
     */
    use_pmi?: boolean;
    /**
     * Enable waiting room
     */
    waiting_room?: boolean;
    /**
     * Add watermark when viewing a shared screen.
     */
    watermark?: boolean;
  };
  /**
   * Meeting start date-time in UTC/GMT. Example: "2020-03-31T12:02:00Z"
   */
  start_time?: string;
  /**
   * URL to start the meeting. This URL should only be used by the host of the meeting and **should not be shared with anyone other than the host** of the meeting as anyone with this URL will be able to login to the Zoom Client as the host of the meeting.
   */
  start_url?: string;
  /**
   * Timezone to format start_time
   */
  timezone?: string;
  /**
   * Meeting topic
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Label of the tracking field.
     */
    field?: string;
    /**
     * Value for the field.
     */
    value?: string;
    /**
     * Indicates whether the [tracking field](https://support.zoom.us/hc/en-us/articles/115000293426-Scheduling-Tracking-Fields) is visible in the meeting scheduling options in the Zoom Web Portal or not.
     *
     * `true`: Tracking field is visible. <br>
     *
     * `false`: Tracking field is not visible to the users in the meeting options in the Zoom Web Portal but the field was used while scheduling this meeting via API. An invisible tracking field can be used by users while scheduling meetings via API only.
     */
    visible?: boolean;
  }>;
  /**
   * Meeting Type
   */
  type?: 1 | 2 | 3 | 8;
};

/**
 * Meeting object.
 */
export type MeetingInfoGet = {
  /**
   * Meeting description
   */
  agenda?: string;
  /**
   * Time of creation.
   */
  created_at?: string;
  /**
   * Meeting duration.
   */
  duration?: number;
  /**
   * Encrypted passcode for third party endpoints (H323/SIP).
   */
  encrypted_password?: string;
  /**
   * H.323/SIP room system passcode.
   */
  h323_password?: string;
  /**
   * URL for participants to join the meeting. This URL should only be shared with users that you would like to invite for the meeting.
   */
  join_url?: string;
  /**
   * Array of occurrence objects.
   */
  occurrences?: Array<{
    /**
     * Duration.
     */
    duration?: number;
    /**
     * Occurrence ID: Unique Identifier that identifies an occurrence of a recurring webinar. [Recurring webinars](https://support.zoom.us/hc/en-us/articles/216354763-How-to-Schedule-A-Recurring-Webinar) can have a maximum of 50 occurrences.
     */
    occurrence_id?: string;
    /**
     * Start time.
     */
    start_time?: string;
    /**
     * Occurrence status.
     */
    status?: string;
  }>;
  /**
   * Meeting passcode.
   */
  password?: string;
  /**
   * Personal Meeting Id. Only used for scheduled meetings and recurring meetings with no fixed time.
   */
  pmi?: number;
  /**
   * Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time.
   */
  recurrence?: {
    /**
     * Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
     *
     * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.
     *
     *
     */
    repeat_interval?: number;
    /**
     * Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    weekly_days?: '1' | '2' | '3' | '4' | '5' | '6' | '7';
  };
  /**
   * Meeting settings.
   */
  settings?: {
    /**
     * Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host's emails or IDs: multiple values are separated by a semicolon.
     */
    alternative_hosts?: string;
    /**
     * Flag to determine whether to send email notifications to alternative hosts, default value is true.
     */
    alternative_hosts_email_notification?: boolean;
    /**
     * Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>
     *
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Approve or block users from specific regions/countries from joining this meeting.
     *
     */
    approved_or_denied_countries_or_regions?: {
      /**
       * List of countries/regions from where participants can join this meeting.
       */
      approved_list?: Array<string>;
      /**
       * List of countries/regions from where participants can not join this meeting.
       */
      denied_list?: Array<string>;
      /**
       * `true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>
       *
       * `false`: Setting disabled.
       */
      enable?: boolean;
      /**
       * Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>
       * `approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>
       * `deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`
       */
      method?: 'approve' | 'deny';
    };
    /**
     * Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
     */
    authentication_domains?: string;
    /**
     * The participants added here will receive unique meeting invite links and bypass authentication.
     */
    authentication_exception?: Array<{
      /**
       * Email address of the participant.
       */
      email?: string;
      /**
       * Name of the participant.
       */
      name?: string;
    }>;
    /**
     * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
     */
    authentication_name?: string;
    /**
     * Meeting authentication option id.
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).
     */
    breakout_room?: {
      /**
       * Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.
       */
      enable?: boolean;
      /**
       * Create room(s).
       */
      rooms?: Array<{
        /**
         * Name of the breakout room.
         */
        name?: string;
        /**
         * Email addresses of the participants who are to be assigned to the breakout room.
         */
        participants?: Array<string>;
      }>;
    };
    /**
     * Close registration after event date
     */
    close_registration?: boolean;
    /**
     * Host meeting in China.
     */
    cn_meeting?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Custom keys and values assigned to the meeting.
     */
    custom_keys?: Array<{
      /**
       * Custom key associated with the user.
       */
      key?: string;
      /**
       * Value of the custom key associated with the user.
       */
      value?: string;
    }>;
    /**
     * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
     * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
     *
     * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
     */
    encryption_type?: 'enhanced_encryption' | 'e2ee';
    /**
     * Only signed in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login_domains?: string;
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Global Dial-in Countries/Regions
     */
    global_dial_in_numbers?: Array<{
      /**
       * City of the number, if any. For example, Chicago.
       */
      city?: string;
      /**
       * Country code. For example, BR.
       */
      country?: string;
      /**
       * Full name of country. For example, Brazil.
       */
      country_name?: string;
      /**
       * Phone number. For example, +1 2332357613.
       */
      number?: string;
      /**
       * Type of number.
       */
      type?: 'toll' | 'tollfree';
    }>;
    /**
     * Start video when the host joins the meeting.
     */
    host_video?: boolean;
    /**
     * Host meeting in India.
     */
    in_meeting?: boolean;
    /**
     * If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:
     *
     * *  `0`: Allow participant to join anytime.
     * *  `5`: Allow participant to join 5 minutes before meeting start time.
     * * `10`: Allow participant to join 10 minutes before meeting start time.
     */
    jbh_time?: 0 | 5 | 10;
    /**
     * Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.
     */
    join_before_host?: boolean;
    language_interpretation?: {
      enable?: boolean;
      /**
       * Information associated with the interpreter.
       */
      interpreters?: Array<{
        /**
         * Email address of the interpreter.
         */
        email?: string;
        /**
         * Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma.
         *
         * For example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".
         */
        languages?: string;
      }>;
    };
    /**
     * `true`- Only authenticated users can join meetings.
     */
    meeting_authentication?: boolean;
    /**
     * Mute participants upon entry.
     */
    mute_upon_entry?: boolean;
    /**
     * Start video when participants join the meeting.
     */
    participant_video?: boolean;
    /**
     * Send confirmation email to registrants upon successful registration.
     */
    registrants_confirmation_email?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the meeting registration page.
     * This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    show_share_button?: boolean;
    /**
     * Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.
     */
    use_pmi?: boolean;
    /**
     * Enable waiting room
     */
    waiting_room?: boolean;
    /**
     * Add watermark when viewing a shared screen.
     */
    watermark?: boolean;
  };
  /**
   * Meeting start time in GMT/UTC. Start time will not be returned if the meeting is an **instant** meeting.
   *
   */
  start_time?: string;
  /**
   * <br><aside>The <code>start_url</code> of a Meeting is a URL using which a host or an alternative host can start the Meeting.
   *
   * The expiration time for the <code>start_url</code> field listed in the response of [Create a Meeting API](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meetingcreate) is two hours for all regular users.
   *
   * For users created using the <code>custCreate</code> option via the [Create Users](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usercreate) API, the expiration time of the <code>start_url</code> field is 90 days.
   *
   * For security reasons, to retrieve the updated value for the <code>start_url</code> field programmatically (after the expiry time), you must call the [Retrieve a Meeting API](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meeting) and refer to the value of the <code>start_url</code> field in the response.</aside><br>This URL should only be used by the host of the meeting and **should not be shared with anyone other than the host** of the meeting as anyone with this URL will be able to login to the Zoom Client as the host of the meeting.
   */
  start_url?: string;
  /**
   * Meeting status
   */
  status?: 'waiting' | 'started';
  /**
   * Timezone to format the meeting start time on the .
   */
  timezone?: string;
  /**
   * Meeting topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Label of the tracking field.
     */
    field?: string;
    /**
     * Value for the field.
     */
    value?: string;
    /**
     * Indicates whether the [tracking field](https://support.zoom.us/hc/en-us/articles/115000293426-Scheduling-Tracking-Fields) is visible in the meeting scheduling options in the Zoom Web Portal or not.
     *
     * `true`: Tracking field is visible. <br>
     *
     * `false`: Tracking field is not visible to the users when they look at the meeting details in the Zoom Web Portal but the field was used while scheduling this meeting via API. An invisible tracking field can be used by users while scheduling meetings via API only.
     */
    visible?: boolean;
  }>;
  /**
   * Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`4` - PMI Meeting<br>
   * `8` - Recurring meeting with a fixed time.
   */
  type?: 1 | 2 | 3 | 8;
};

/**
 * Meeting status
 */
export type status = 'waiting' | 'started';

/**
 * List of Meetings
 */
export type MeetingInstances = {
  /**
   * List of ended meeting instances.
   */
  meetings?: Array<{
    /**
     * Start time
     */
    start_time?: string;
    /**
     * Meeting UUID. Unique meeting ID. Each meeting instance will generate its own Meeting UUID (i.e., after a meeting ends, a new UUID will be generated for the next instance of the meeting). Please double encode your UUID when using it for API calls if the UUID begins with a '/'or contains '//' in it.
     *
     *
     */
    uuid?: string;
  }>;
};

/**
 * Meeting invitation details.
 */
export type MeetingInvitation = {
  /**
   * Meeting invitation.
   */
  invitation?: string;
};

/**
 * List of meetings.
 */
export type MeetingList = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of Meeting objects.
   */
  meetings?: Array<{
    /**
     * Meeting description. The length of agenda gets truncated to 250 characters when you list all meetings for a user. To view the complete agenda of a meeting, retrieve details for a single meeting [here](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meeting).
     */
    agenda?: string;
    /**
     * Time of creation.
     */
    created_at?: string;
    /**
     * Meeting duration.
     */
    duration?: number;
    /**
     * ID of the user who is set as the host of the meeting.
     */
    host_id?: string;
    /**
     * Meeting ID - also known as the meeting number in double (int64) format.
     */
    id?: number;
    /**
     * Join URL.
     */
    join_url?: string;
    /**
     * Meeting start time.
     */
    start_time?: string;
    /**
     * Timezone to format the meeting start time.
     */
    timezone?: string;
    /**
     * Meeting topic.
     */
    topic?: string;
    /**
     * Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.
     */
    type?: 1 | 2 | 3 | 8;
    /**
     * Unique Meeting ID. Each meeting instance will generate its own Meeting UUID.
     */
    uuid?: string;
  }>;
};

/**
 * Meeting live stream.
 */
export type MeetingLiveStream = {
  /**
   * The livestream page URL.
   */
  page_url?: string;
  /**
   * Stream name and key.
   */
  stream_key: string;
  /**
   * Streaming URL.
   */
  stream_url: string;
};

/**
 * Meeting live stream status.
 */
export type MeetingLiveStreamStatus = {
  /**
   * Update the status of a livestream.
   *
   * The value can be one of the following:<br>
   * `start`: Start a live stream. <br>
   * `stop`: Stop an ongoing live stream.
   */
  action?: 'start' | 'stop';
  /**
   * Update the settings of a live streaming session. The settings can only be updated for a live stream that has been stopped. You can not update the settings of an ongoing live stream.
   */
  settings?: {
    /**
     * Display the name of the active speaker during a live stream.
     */
    active_speaker_name?: boolean;
    /**
     * Display name of the live stream.
     */
    display_name?: string;
  };
};

/**
 * Update the status of a livestream.
 *
 * The value can be one of the following:<br>
 * `start`: Start a live stream. <br>
 * `stop`: Stop an ongoing live stream.
 */
export type action3 = 'start' | 'stop';

/**
 * Meeting metric details.
 */
export type MeetingMetric = {
  /**
   * Custom keys and values assigned to the meeting.
   */
  custom_keys?: Array<{
    /**
     * Custom key associated with the meetinh.
     */
    key?: string;
    /**
     * Value of the custom key associated with the meeting.
     */
    value?: string;
  }>;
  /**
   * Department of the host.
   */
  dept?: string;
  /**
   * Meeting duration.
   */
  duration?: string;
  /**
   * Email address of the host.
   */
  email?: string;
  /**
   * Meeting end time.
   */
  end_time?: string;
  /**
   * Indicates whether or not [third party audio](https://support.zoom.us/hc/en-us/articles/202470795-3rd-Party-Audio-Conference) was used in the meeting.
   */
  has_3rd_party_audio?: boolean;
  /**
   * Indicates whether or not the PSTN was used in the meeting.
   */
  has_pstn?: boolean;
  /**
   * Indicates whether or not the recording feature was used in the meeting.
   */
  has_recording?: boolean;
  /**
   * Indicates whether or not screenshare feature was used in the meeting.
   */
  has_screen_share?: boolean;
  /**
   * Indicates whether or not someone joined the meeting using SIP.
   */
  has_sip?: boolean;
  /**
   * Indicates whether or not video was used in the meeting.
   */
  has_video?: boolean;
  /**
   * Indicates whether or not VoIP was used in the meeting.
   */
  has_voip?: boolean;
  /**
   * Host display name.
   */
  host?: string;
  /**
   * [Meeting ID](https://support.zoom.us/hc/en-us/articles/201362373-What-is-a-Meeting-ID-): Unique identifier of the meeting in "**long**" format(represented as int64 data type in JSON), also known as the meeting number.
   */
  id?: number;
  /**
   * The number of Zoom Room participants in the meeting.
   */
  in_room_participants?: number;
  /**
   * Meeting participant count.
   */
  participants?: number;
  /**
   * Meeting start time.
   */
  start_time?: string;
  /**
   * Meeting topic.
   */
  topic?: string;
  /**
   * License type of the user.
   */
  user_type?: string;
  /**
   * Meeting UUID. Please double encode your UUID when using it for API calls if the UUID begins with a '/'or contains '//' in it.
   */
  uuid?: string;
};

/**
 * List of meeting recording registrant
 */
export type MeetingRecordingRegistrantList = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of Registrant objects
   */
  registrants?: Array<
    {
      id?: string;
    } & {
      /**
       * Registrant's address.
       */
      address?: string;
      /**
       * Registrant's city.
       */
      city?: string;
      /**
       * A field that allows registrants to provide any questions or comments that they might have.
       */
      comments?: string;
      /**
       * Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.
       */
      country?: string;
      /**
       * Custom questions.
       */
      custom_questions?: Array<{
        title?: string;
        value?: string;
      }>;
      /**
       * A valid email address of the registrant.
       */
      email: string;
      /**
       * Registrant's first name.
       */
      first_name: string;
      /**
       * Registrant's Industry.
       */
      industry?: string;
      /**
       * Registrant's job title.
       */
      job_title?: string;
      /**
       * Registrant's last name.
       */
      last_name?: string;
      /**
       * Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`
       */
      no_of_employees?: string;
      /**
       * Registrant's Organization.
       */
      org?: string;
      /**
       * Registrant's Phone number.
       */
      phone?: string;
      /**
       * This field can be included to gauge interest of webinar attendees towards buying your product or service.
       *
       * Purchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`
       */
      purchasing_time_frame?: string;
      /**
       * Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved`
       */
      role_in_purchase_process?: string;
      /**
       * Registrant's State/Province.
       */
      state?: string;
      /**
       * Registrant's Zip/Postal Code.
       */
      zip?: string;
    }
  >;
};

/**
 *  Registrant.
 */
export type MeetingRegistrant = {
  /**
   * Registrant's address.
   */
  address?: string;
  /**
   * Registrant's city.
   */
  city?: string;
  /**
   * A field that allows registrants to provide any questions or comments that they might have.
   */
  comments?: string;
  /**
   * Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.
   */
  country?: string;
  /**
   * Custom questions.
   */
  custom_questions?: Array<{
    title?: string;
    value?: string;
  }>;
  /**
   * A valid email address of the registrant.
   */
  email: string;
  /**
   * Registrant's first name.
   */
  first_name: string;
  /**
   * Registrant's Industry.
   */
  industry?: string;
  /**
   * Registrant's job title.
   */
  job_title?: string;
  /**
   * Registrant's last name.
   */
  last_name?: string;
  /**
   * Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`
   */
  no_of_employees?: string;
  /**
   * Registrant's Organization.
   */
  org?: string;
  /**
   * Registrant's Phone number.
   */
  phone?: string;
  /**
   * This field can be included to gauge interest of webinar attendees towards buying your product or service.
   *
   * Purchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`
   */
  purchasing_time_frame?: string;
  /**
   * Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved`
   */
  role_in_purchase_process?: string;
  /**
   * Registrant's State/Province.
   */
  state?: string;
  /**
   * Registrant's Zip/Postal Code.
   */
  zip?: string;
};

/**
 * List of users.
 */
export type MeetingRegistrantList = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of registrant objects.
   */
  registrants?: Array<
    {
      /**
       * Registrant ID.
       */
      id?: string;
    } & {
      /**
       * Registrant's address.
       */
      address?: string;
      /**
       * Registrant's city.
       */
      city?: string;
      /**
       * A field that allows registrants to provide any questions or comments that they might have.
       */
      comments?: string;
      /**
       * Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.
       */
      country?: string;
      /**
       * Custom questions.
       */
      custom_questions?: Array<{
        title?: string;
        value?: string;
      }>;
      /**
       * A valid email address of the registrant.
       */
      email: string;
      /**
       * Registrant's first name.
       */
      first_name: string;
      /**
       * Registrant's Industry.
       */
      industry?: string;
      /**
       * Registrant's job title.
       */
      job_title?: string;
      /**
       * Registrant's last name.
       */
      last_name?: string;
      /**
       * Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`
       */
      no_of_employees?: string;
      /**
       * Registrant's Organization.
       */
      org?: string;
      /**
       * Registrant's Phone number.
       */
      phone?: string;
      /**
       * This field can be included to gauge interest of webinar attendees towards buying your product or service.
       *
       * Purchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`
       */
      purchasing_time_frame?: string;
      /**
       * Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved`
       */
      role_in_purchase_process?: string;
      /**
       * Registrant's State/Province.
       */
      state?: string;
      /**
       * Registrant's Zip/Postal Code.
       */
      zip?: string;
    } & {
      /**
       * The time at which the registrant registered.
       */
      create_time?: string;
      /**
       * The URL using which an approved registrant can join the webinar.
       */
      join_url?: string;
      /**
       * The status of the registrant's registration. <br> `approved`: User has been successfully approved for the webinar.<br> `pending`:  The registration is still pending.<br> `denied`: User has been denied from joining the webinar.
       */
      status?: string;
    }
  >;
};

/**
 * Meeting Registrant Questions
 */
export type MeetingRegistrantQuestions = {
  /**
   * Array of Registrant Custom Questions
   */
  custom_questions?: Array<{
    /**
     * Answer choices for the question. Can not be used for `short` question type as this type of question requires registrants to type out the answer.
     */
    answers?: Array<string>;
    /**
     * Indicates whether or not the custom question is required to be answered by participants or not.
     */
    required?: boolean;
    /**
     * Title of the custom question.
     */
    title?: string;
    /**
     * Type of the question being asked.
     */
    type?: 'short' | 'single';
  }>;
  /**
   * Array of Registrant Questions
   */
  questions?: Array<{
    /**
     * Field name of the question.
     */
    field_name?:
      | 'address'
      | 'city'
      | 'country'
      | 'zip'
      | 'state'
      | 'phone'
      | 'industry'
      | 'org'
      | 'job_title'
      | 'purchasing_time_frame'
      | 'role_in_purchase_process'
      | 'no_of_employees'
      | 'comments';
    /**
     * Indicates whether or not the displayed fields are required to be filled out by registrants.
     */
    required?: boolean;
  }>;
};

export type MeetingSecuritySettings = {
  meeting_security?: {
    /**
     * `true`: Require that all meetings are secured with at least one security option.
     *
     * This setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).
     */
    auto_security?: boolean;
    /**
     * If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.
     *
     */
    embed_password_in_join_link?: boolean;
    /**
     * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
     * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
     *
     * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
     */
    encryption_type?: 'enhanced_encryption' | 'e2ee';
    /**
     * Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.
     */
    end_to_end_encrypted_meetings?: boolean;
    /**
     * If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.
     */
    meeting_password?: boolean;
    /**
     * Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
     */
    meeting_password_requirement?: {
      consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
      /**
       * If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).
       *
       */
      have_letter?: boolean;
      /**
       * If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).
       */
      have_number?: boolean;
      /**
       * If set to `true`, the passcode must have at least 1 special character (!,@,#...).
       */
      have_special_character?: boolean;
      /**
       * If set to `true`, the passcode must include both uppercase and lowercase characters.
       */
      have_upper_and_lower_characters?: boolean;
      /**
       * The minimum length that the meeting/webinar passcode needs to have.
       */
      length?: number;
      /**
       * If set to `true`, the passcode must only contain numbers and no other characters.
       */
      only_allow_numeric?: boolean;
      /**
       * If set to `true`, users will be informed if the provided passcode is weak.
       */
      weak_enhance_detection?: boolean;
    };
    /**
     * Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.
     */
    phone_password?: boolean;
    /**
     * If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.
     *
     */
    pmi_password?: boolean;
    /**
     * Require a passcode for meetings which have already been scheduled.
     *
     */
    require_password_for_scheduled_meeting?: boolean;
    /**
     * Require a passcode for webinars which have already been scheduled.
     *
     */
    require_password_for_scheduled_webinar?: boolean;
    /**
     * When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.
     *
     */
    waiting_room?: boolean;
    /**
     * Specify the settings to be applied if waiting room is enabled.
     */
    waiting_room_settings?: {
      /**
       *
       *
       * Specify who should be admitted to the waiting room. The value of this field can be one of the following:<br>
       * `0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in
       */
      participants_to_place_in_waiting_room?: 0 | 1 | 2;
      /**
       * Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>
       * `0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).
       *
       *
       *
       */
      users_who_can_admit_participants_from_waiting_room?: number;
      /**
       * If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").
       */
      whitelisted_domains_for_waiting_room?: string;
    };
    /**
     * If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.
     *
     */
    webinar_password?: boolean;
  };
};

/**
 *
 *
 * Specify who should be admitted to the waiting room. The value of this field can be one of the following:<br>
 * `0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in
 */
export type participants_to_place_in_waiting_room = 0 | 1 | 2;

/**
 * Meeting settings.
 */
export type MeetingSettings = {
  /**
   * Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
   */
  allow_multiple_devices?: boolean;
  /**
   * Alternative host's emails or IDs: multiple values are separated by a semicolon.
   */
  alternative_hosts?: string;
  /**
   * Flag to determine whether to send email notifications to alternative hosts, default value is true.
   */
  alternative_hosts_email_notification?: boolean;
  /**
   * Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>
   *
   * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
   */
  approval_type?: 0 | 1 | 2;
  /**
   * Approve or block users from specific regions/countries from joining this meeting.
   *
   */
  approved_or_denied_countries_or_regions?: {
    /**
     * List of countries/regions from where participants can join this meeting.
     */
    approved_list?: Array<string>;
    /**
     * List of countries/regions from where participants can not join this meeting.
     */
    denied_list?: Array<string>;
    /**
     * `true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>
     *
     * `false`: Setting disabled.
     */
    enable?: boolean;
    /**
     * Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>
     * `approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>
     * `deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`
     */
    method?: 'approve' | 'deny';
  };
  /**
   * Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.
   */
  audio?: 'both' | 'telephony' | 'voip';
  /**
   * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
   */
  authentication_domains?: string;
  /**
   * The participants added here will receive unique meeting invite links and bypass authentication.
   */
  authentication_exception?: Array<{
    /**
     * Email address of the participant.
     */
    email?: string;
    /**
     * Name of the participant.
     */
    name?: string;
  }>;
  /**
   * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
   */
  authentication_name?: string;
  /**
   * Meeting authentication option id.
   */
  authentication_option?: string;
  /**
   * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
   */
  auto_recording?: 'local' | 'cloud' | 'none';
  /**
   * Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).
   */
  breakout_room?: {
    /**
     * Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.
     */
    enable?: boolean;
    /**
     * Create room(s).
     */
    rooms?: Array<{
      /**
       * Name of the breakout room.
       */
      name?: string;
      /**
       * Email addresses of the participants who are to be assigned to the breakout room.
       */
      participants?: Array<string>;
    }>;
  };
  /**
   * Close registration after event date
   */
  close_registration?: boolean;
  /**
   * Host meeting in China.
   */
  cn_meeting?: boolean;
  /**
   * Contact email for registration
   */
  contact_email?: string;
  /**
   * Contact name for registration
   */
  contact_name?: string;
  /**
   * Custom keys and values assigned to the meeting.
   */
  custom_keys?: Array<{
    /**
     * Custom key associated with the user.
     */
    key?: string;
    /**
     * Value of the custom key associated with the user.
     */
    value?: string;
  }>;
  /**
   * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
   * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
   *
   * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
   */
  encryption_type?: 'enhanced_encryption' | 'e2ee';
  /**
   * Only signed in users can join this meeting.
   *
   * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
   */
  enforce_login?: boolean;
  /**
   * Only signed in users with specified domains can join meetings.
   *
   * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
   */
  enforce_login_domains?: string;
  /**
   * List of global dial-in countries
   */
  global_dial_in_countries?: Array<string>;
  /**
   * Global Dial-in Countries/Regions
   */
  global_dial_in_numbers?: Array<{
    /**
     * City of the number, if any. For example, Chicago.
     */
    city?: string;
    /**
     * Country code. For example, BR.
     */
    country?: string;
    /**
     * Full name of country. For example, Brazil.
     */
    country_name?: string;
    /**
     * Phone number. For example, +1 2332357613.
     */
    number?: string;
    /**
     * Type of number.
     */
    type?: 'toll' | 'tollfree';
  }>;
  /**
   * Start video when the host joins the meeting.
   */
  host_video?: boolean;
  /**
   * Host meeting in India.
   */
  in_meeting?: boolean;
  /**
   * If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:
   *
   * *  `0`: Allow participant to join anytime.
   * *  `5`: Allow participant to join 5 minutes before meeting start time.
   * * `10`: Allow participant to join 10 minutes before meeting start time.
   */
  jbh_time?: 0 | 5 | 10;
  /**
   * Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.
   */
  join_before_host?: boolean;
  language_interpretation?: {
    enable?: boolean;
    /**
     * Information associated with the interpreter.
     */
    interpreters?: Array<{
      /**
       * Email address of the interpreter.
       */
      email?: string;
      /**
       * Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma.
       *
       * For example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".
       */
      languages?: string;
    }>;
  };
  /**
   * `true`- Only authenticated users can join meetings.
   */
  meeting_authentication?: boolean;
  /**
   * Mute participants upon entry.
   */
  mute_upon_entry?: boolean;
  /**
   * Start video when participants join the meeting.
   */
  participant_video?: boolean;
  /**
   * Send confirmation email to registrants upon successful registration.
   */
  registrants_confirmation_email?: boolean;
  /**
   * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
   */
  registrants_email_notification?: boolean;
  /**
   * Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.
   */
  registration_type?: 1 | 2 | 3;
  /**
   * Show social share buttons on the meeting registration page.
   * This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
   */
  show_share_button?: boolean;
  /**
   * Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.
   */
  use_pmi?: boolean;
  /**
   * Enable waiting room
   */
  waiting_room?: boolean;
  /**
   * Add watermark when viewing a shared screen.
   */
  watermark?: boolean;
};

/**
 * Meeting object
 */
export type MeetingUpdate = {
  /**
   * Meeting description.
   */
  agenda?: string;
  /**
   * Meeting duration (minutes). Used for scheduled meetings only.
   */
  duration?: number;
  /**
   * Meeting passcode. Passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ *] and can have a maximum of 10 characters.
   *
   * **Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the  [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API.
   */
  password?: string;
  /**
   * Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time.
   */
  recurrence?: {
    /**
     * Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
     *
     * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.
     *
     *
     */
    repeat_interval?: number;
    /**
     * Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    weekly_days?: '1' | '2' | '3' | '4' | '5' | '6' | '7';
  };
  settings?: {
    /**
     * Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host's emails or IDs: multiple values are separated by a semicolon.
     */
    alternative_hosts?: string;
    /**
     * Flag to determine whether to send email notifications to alternative hosts, default value is true.
     */
    alternative_hosts_email_notification?: boolean;
    /**
     * Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>
     *
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Approve or block users from specific regions/countries from joining this meeting.
     *
     */
    approved_or_denied_countries_or_regions?: {
      /**
       * List of countries/regions from where participants can join this meeting.
       */
      approved_list?: Array<string>;
      /**
       * List of countries/regions from where participants can not join this meeting.
       */
      denied_list?: Array<string>;
      /**
       * `true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>
       *
       * `false`: Setting disabled.
       */
      enable?: boolean;
      /**
       * Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>
       * `approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>
       * `deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`
       */
      method?: 'approve' | 'deny';
    };
    /**
     * Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
     */
    authentication_domains?: string;
    /**
     * The participants added here will receive unique meeting invite links and bypass authentication.
     */
    authentication_exception?: Array<{
      /**
       * Email address of the participant.
       */
      email?: string;
      /**
       * Name of the participant.
       */
      name?: string;
    }>;
    /**
     * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
     */
    authentication_name?: string;
    /**
     * Meeting authentication option id.
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).
     */
    breakout_room?: {
      /**
       * Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.
       */
      enable?: boolean;
      /**
       * Create room(s).
       */
      rooms?: Array<{
        /**
         * Name of the breakout room.
         */
        name?: string;
        /**
         * Email addresses of the participants who are to be assigned to the breakout room.
         */
        participants?: Array<string>;
      }>;
    };
    /**
     * Close registration after event date
     */
    close_registration?: boolean;
    /**
     * Host meeting in China.
     */
    cn_meeting?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Custom keys and values assigned to the meeting.
     */
    custom_keys?: Array<{
      /**
       * Custom key associated with the user.
       */
      key?: string;
      /**
       * Value of the custom key associated with the user.
       */
      value?: string;
    }>;
    /**
     * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
     * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
     *
     * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
     */
    encryption_type?: 'enhanced_encryption' | 'e2ee';
    /**
     * Only signed in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login_domains?: string;
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Global Dial-in Countries/Regions
     */
    global_dial_in_numbers?: Array<{
      /**
       * City of the number, if any. For example, Chicago.
       */
      city?: string;
      /**
       * Country code. For example, BR.
       */
      country?: string;
      /**
       * Full name of country. For example, Brazil.
       */
      country_name?: string;
      /**
       * Phone number. For example, +1 2332357613.
       */
      number?: string;
      /**
       * Type of number.
       */
      type?: 'toll' | 'tollfree';
    }>;
    /**
     * Start video when the host joins the meeting.
     */
    host_video?: boolean;
    /**
     * Host meeting in India.
     */
    in_meeting?: boolean;
    /**
     * If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:
     *
     * *  `0`: Allow participant to join anytime.
     * *  `5`: Allow participant to join 5 minutes before meeting start time.
     * * `10`: Allow participant to join 10 minutes before meeting start time.
     */
    jbh_time?: 0 | 5 | 10;
    /**
     * Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.
     */
    join_before_host?: boolean;
    language_interpretation?: {
      enable?: boolean;
      /**
       * Information associated with the interpreter.
       */
      interpreters?: Array<{
        /**
         * Email address of the interpreter.
         */
        email?: string;
        /**
         * Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma.
         *
         * For example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".
         */
        languages?: string;
      }>;
    };
    /**
     * `true`- Only authenticated users can join meetings.
     */
    meeting_authentication?: boolean;
    /**
     * Mute participants upon entry.
     */
    mute_upon_entry?: boolean;
    /**
     * Start video when participants join the meeting.
     */
    participant_video?: boolean;
    /**
     * Send confirmation email to registrants upon successful registration.
     */
    registrants_confirmation_email?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the meeting registration page.
     * This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    show_share_button?: boolean;
    /**
     * Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.
     */
    use_pmi?: boolean;
    /**
     * Enable waiting room
     */
    waiting_room?: boolean;
    /**
     * Add watermark when viewing a shared screen.
     */
    watermark?: boolean;
  } & {
    /**
     * Send confirmation Email to Registrants
     */
    registrants_confirmation_email?: boolean;
  };
  /**
   * Meeting start time. When using a format like "yyyy-MM-dd'T'HH:mm:ss'Z'", always use GMT time. When using a format like "yyyy-MM-dd'T'HH:mm:ss", you should use local time and  specify the time zone. Only used for scheduled meetings and recurring meetings with a fixed time.
   */
  start_time?: string;
  /**
   * Unique identifier of the meeting template.
   *
   * Use this field if you would like to [schedule the meeting from a meeting template](https://support.zoom.us/hc/en-us/articles/360036559151-Meeting-templates#h_86f06cff-0852-4998-81c5-c83663c176fb). You can retrieve the value of this field by calling the [List meeting templates]() API.
   */
  template_id?: string;
  /**
   * Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.
   */
  timezone?: string;
  /**
   * Meeting topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Tracking fields type
     */
    field?: string;
    /**
     * Tracking fields value
     */
    value?: string;
  }>;
  /**
   * Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with a fixed time.
   */
  type?: 1 | 2 | 3 | 8;
};

/**
 * Occurence object. This object is only returned for Recurring Webinars.
 */
export type Occurrence = {
  /**
   * Duration.
   */
  duration?: number;
  /**
   * Occurrence ID: Unique Identifier that identifies an occurrence of a recurring webinar. [Recurring webinars](https://support.zoom.us/hc/en-us/articles/216354763-How-to-Schedule-A-Recurring-Webinar) can have a maximum of 50 occurrences.
   */
  occurrence_id?: string;
  /**
   * Start time.
   */
  start_time?: string;
  /**
   * Occurrence status.
   */
  status?: string;
};

/**
 * Array of occurrence objects.
 */
export type Occurrences = Array<{
  /**
   * Duration.
   */
  duration?: number;
  /**
   * Occurrence ID: Unique Identifier that identifies an occurrence of a recurring webinar. [Recurring webinars](https://support.zoom.us/hc/en-us/articles/216354763-How-to-Schedule-A-Recurring-Webinar) can have a maximum of 50 occurrences.
   */
  occurrence_id?: string;
  /**
   * Start time.
   */
  start_time?: string;
  /**
   * Occurrence status.
   */
  status?: string;
}>;

/**
 * List of PAC accounts.
 */
export type PAC = {
  /**
   * Conference ID.
   */
  conference_id?: number;
  /**
   * List of dedicated dial-in numbers.
   */
  dedicated_dial_in_number?: Array<{
    /**
     * Country code.
     */
    country?: string;
    /**
     * Dial-in number: length is less than 16.
     */
    number?: string;
  }>;
  /**
   * List of global dial-in numbers.
   */
  global_dial_in_numbers?: Array<{
    /**
     * Country code.
     */
    country?: string;
    /**
     * Dial-in number: length is less than 16.
     */
    number?: string;
  }>;
  /**
   * Listen-Only passcode: numeric value - length is less than 6.
   */
  listen_only_password?: string;
  /**
   * Participant passcode: numeric value - length is less than 6.
   */
  participant_password?: string;
};

/**
 * Pagination Object.
 */
export type Pagination = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
};

/**
 * Pagination object.
 */
export type PaginationToken = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * The number of records returned within a single API call.
   */
  page_size?: number;
  /**
   * The number of all records available across pages.
   */
  total_records?: number;
};

/**
 * Pagination object.
 */
export type PaginationToken4IMChat = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of the available result list exceeds the page size. The expiration period is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The amount of records returns within a single API call.
   */
  page_size?: number;
};

/**
 * Pagination object.
 */
export type PaginationToken4Qos = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceed the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * The number of items per page.
   */
  page_size?: number;
  /**
   * The number of all records available across pages.
   */
  total_records?: number;
};

/**
 * Panelist base object.
 */
export type Panelist = {
  /**
   * Panelist's email.
   */
  email?: string;
  /**
   * Panelist's full name.
   */
  name?: string;
};

/**
 * List of panelists.
 */
export type PanelistList = {
  /**
   * List of panelist objects.
   */
  panelists?: Array<
    {
      /**
       * Panelist's ID.
       */
      id?: string;
    } & {
      /**
       * Panelist's email.
       */
      email?: string;
      /**
       * Panelist's full name.
       */
      name?: string;
    } & {
      /**
       * Join URL.
       */
      join_url?: string;
    }
  >;
  /**
   * Total records.
   */
  total_records?: number;
};

/**
 * Phone Plan Object
 */
export type PhonePlan = {
  /**
   * Additional phone base plans.
   */
  plan_base?: {
    /**
     * Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.
     */
    callout_countries?: string;
    /**
     * Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
     */
    type?: string;
  };
  /**
   * Additional phone calling plans.
   */
  plan_calling?: Array<{
    hosts?: number;
    /**
     * Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
     */
    type?: string;
  }>;
  /**
   * Additional phone number plans.
   */
  plan_number?: Array<{
    hosts?: number;
    /**
     * Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
     */
    type?: string;
  }>;
};

/**
 * Poll
 */
export type Poll = {
  /**
   * Array of Polls
   */
  questions?: Array<{
    /**
     * Answers to the questions
     */
    answers?: Array<string>;
    /**
     * Question to be asked to the attendees.
     */
    name?: string;
    /**
     * Poll Question & Answer type:<br>`single` - Single choice<br>`mutliple` - Multiple choice
     */
    type?: 'single' | 'multiple';
  }>;
  /**
   * Title for the poll.
   */
  title?: string;
};

/**
 * Poll List
 */
export type PollList = {
  /**
   * Array of Polls
   */
  polls?: Array<
    {
      /**
       * ID of Poll
       */
      id?: string;
      /**
       * Status of Poll:<br>`notstart` - Poll not started<br>`started` - Poll started<br>`ended` - Poll ended<br>`sharing` - Sharing poll results
       */
      status?: 'notstart' | 'started' | 'ended' | 'sharing';
    } & {
      /**
       * Array of Polls
       */
      questions?: Array<{
        /**
         * Answers to the questions
         */
        answers?: Array<string>;
        /**
         * Question to be asked to the attendees.
         */
        name?: string;
        /**
         * Poll Question & Answer type:<br>`single` - Single choice<br>`mutliple` - Multiple choice
         */
        type?: 'single' | 'multiple';
      }>;
      /**
       * Title for the poll.
       */
      title?: string;
    }
  >;
  /**
   * The number of all records available across pages
   */
  total_records?: number;
};

export type Profile = {
  recording_storage_location?: {
    /**
     * Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.
     *
     * Provide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.
     */
    allowed_values?: Array<string>;
    /**
     * Abbreviated country code.
     */
    value?: string;
  };
};

/**
 * Quality of Service object.
 */
export type QOSAudio = {
  /**
   * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
   */
  avg_loss?: string;
  /**
   * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
   */
  bitrate?: string;
  /**
   * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
   */
  jitter?: string;
  /**
   * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
   */
  latency?: string;
  /**
   * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
   */
  max_loss?: string;
};

/**
 * Participant QOS.
 */
export type QOSParticipant = {
  /**
   * The type of device using which the participant joined the meeting.
   */
  device?: string;
  /**
   * Participant's PC domain.
   */
  domain?: string;
  /**
   * Participant's hard disk ID.
   */
  harddisk_id?: string;
  /**
   * Participant's IP address.
   */
  ip_address?: string;
  /**
   * The time at which participant joined the meeting.
   */
  join_time?: string;
  /**
   * The time at which participant left the meeting.
   */
  leave_time?: string;
  /**
   * Participant's location.
   */
  location?: string;
  /**
   * Participant's MAC address.
   */
  mac_addr?: string;
  /**
   * Participant's PC name.
   */
  pc_name?: string;
  /**
   * Participant ID.
   */
  user_id?: string;
  /**
   * Participant display name.
   */
  user_name?: string;
  /**
   * Quality of service provided to the user.
   */
  user_qos?: Array<{
    /**
     * QoS metrics on screen shares by a participant who joined the meeting via a Cloud Room Connector.
     */
    as_device_from_crc?: {
      /**
       * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
       */
      avg_loss?: string;
      /**
       * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
       */
      bitrate?: string;
      /**
       * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
       */
      jitter?: string;
      /**
       * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
       */
      latency?: string;
      /**
       * The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
       */
      max_loss?: string;
    };
    /**
     * QoS metrics on screen shares output being received by a participant who joined the meeting via a Cloud Room Connector.
     */
    as_device_to_crc?: {
      /**
       * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
       */
      avg_loss?: string;
      /**
       * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
       */
      bitrate?: string;
      /**
       * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
       */
      jitter?: string;
      /**
       * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
       */
      latency?: string;
      /**
       * The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
       */
      max_loss?: string;
    };
    /**
     * Quality of service object.
     */
    as_input?: {
      /**
       * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
       */
      avg_loss?: string;
      /**
       * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
       */
      bitrate?: string;
      /**
       * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
       */
      jitter?: string;
      /**
       * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
       */
      latency?: string;
      /**
       * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
       */
      max_loss?: string;
    } & {
      /**
       * The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.
       */
      frame_rate?: string;
      /**
       * The number of pixels in each dimension that can be displayed by your video camera.
       */
      resolution?: string;
    };
    /**
     * Quality of service object.
     */
    as_output?: {
      /**
       * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
       */
      avg_loss?: string;
      /**
       * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
       */
      bitrate?: string;
      /**
       * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
       */
      jitter?: string;
      /**
       * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
       */
      latency?: string;
      /**
       * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
       */
      max_loss?: string;
    } & {
      /**
       * The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.
       */
      frame_rate?: string;
      /**
       * The number of pixels in each dimension that can be displayed by your video camera.
       */
      resolution?: string;
    };
    /**
     * QoS metrics on audio being sent by a participant who joined the meeting via a Cloud Room Connector.
     */
    audio_device_from_crc?: {
      /**
       * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
       */
      avg_loss?: string;
      /**
       * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
       */
      bitrate?: string;
      /**
       * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
       */
      jitter?: string;
      /**
       * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
       */
      latency?: string;
      /**
       * The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
       */
      max_loss?: string;
    };
    /**
     * QoS metrics on audio received by a participant who joined the meeting via a Cloud Room Connector.
     */
    audio_device_to_crc?: {
      /**
       * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
       */
      avg_loss?: string;
      /**
       * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
       */
      bitrate?: string;
      /**
       * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
       */
      jitter?: string;
      /**
       * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
       */
      latency?: string;
      /**
       * The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
       */
      max_loss?: string;
    };
    /**
     * Quality of Service object.
     */
    audio_input?: {
      /**
       * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
       */
      avg_loss?: string;
      /**
       * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
       */
      bitrate?: string;
      /**
       * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
       */
      jitter?: string;
      /**
       * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
       */
      latency?: string;
      /**
       * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
       */
      max_loss?: string;
    };
    /**
     * Quality of Service object.
     */
    audio_output?: {
      /**
       * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
       */
      avg_loss?: string;
      /**
       * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
       */
      bitrate?: string;
      /**
       * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
       */
      jitter?: string;
      /**
       * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
       */
      latency?: string;
      /**
       * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
       */
      max_loss?: string;
    };
    cpu_usage?: {
      /**
       * System Maximum CPU Usage
       */
      system_max_cpu_usage?: string;
      /**
       * Zoom Average CPU Usage
       */
      zoom_avg_cpu_usage?: string;
      /**
       * Zoom Maximum CPU Usage
       */
      zoom_max_cpu_usage?: string;
      /**
       * Zoom Minimum CPU Usage
       */
      zoom_min_cpu_usage?: string;
    };
    /**
     * Date-time of QOS
     */
    date_time?: string;
    /**
     * QoS metrics on video input being sent from a Cloud Room Connector used by the participant to join the meeting.
     */
    video_device_from_crc?: {
      /**
       * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
       */
      avg_loss?: string;
      /**
       * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
       */
      bitrate?: string;
      /**
       * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
       */
      jitter?: string;
      /**
       * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
       */
      latency?: string;
      /**
       * The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
       */
      max_loss?: string;
    };
    /**
     * QoS metrics on video output received by a participant who joined the meeting via a Cloud Room Connector.
     */
    video_device_to_crc?: {
      /**
       * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
       */
      avg_loss?: string;
      /**
       * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
       */
      bitrate?: string;
      /**
       * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
       */
      jitter?: string;
      /**
       * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
       */
      latency?: string;
      /**
       * The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
       */
      max_loss?: string;
    };
    /**
     * Quality of service object.
     */
    video_input?: {
      /**
       * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
       */
      avg_loss?: string;
      /**
       * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
       */
      bitrate?: string;
      /**
       * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
       */
      jitter?: string;
      /**
       * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
       */
      latency?: string;
      /**
       * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
       */
      max_loss?: string;
    } & {
      /**
       * The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.
       */
      frame_rate?: string;
      /**
       * The number of pixels in each dimension that can be displayed by your video camera.
       */
      resolution?: string;
    };
    /**
     * Quality of service object.
     */
    video_output?: {
      /**
       * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
       */
      avg_loss?: string;
      /**
       * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
       */
      bitrate?: string;
      /**
       * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
       */
      jitter?: string;
      /**
       * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
       */
      latency?: string;
      /**
       * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
       */
      max_loss?: string;
    } & {
      /**
       * The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.
       */
      frame_rate?: string;
      /**
       * The number of pixels in each dimension that can be displayed by your video camera.
       */
      resolution?: string;
    };
  }>;
  /**
   * Participant's Zoom Client version.
   */
  version?: string;
};

/**
 * Participant QOS list.
 */
export type QOSParticipantList = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceed the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * The number of items per page.
   */
  page_size?: number;
  /**
   * The number of all records available across pages.
   */
  total_records?: number;
} & {
  /**
   * Array of user objects.
   */
  participants?: Array<{
    /**
     * The type of device using which the participant joined the meeting.
     */
    device?: string;
    /**
     * Participant's PC domain.
     */
    domain?: string;
    /**
     * Participant's hard disk ID.
     */
    harddisk_id?: string;
    /**
     * Participant's IP address.
     */
    ip_address?: string;
    /**
     * The time at which participant joined the meeting.
     */
    join_time?: string;
    /**
     * The time at which participant left the meeting.
     */
    leave_time?: string;
    /**
     * Participant's location.
     */
    location?: string;
    /**
     * Participant's MAC address.
     */
    mac_addr?: string;
    /**
     * Participant's PC name.
     */
    pc_name?: string;
    /**
     * Participant ID.
     */
    user_id?: string;
    /**
     * Participant display name.
     */
    user_name?: string;
    /**
     * Quality of service provided to the user.
     */
    user_qos?: Array<{
      /**
       * QoS metrics on screen shares by a participant who joined the meeting via a Cloud Room Connector.
       */
      as_device_from_crc?: {
        /**
         * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
         */
        avg_loss?: string;
        /**
         * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
         */
        bitrate?: string;
        /**
         * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
         */
        jitter?: string;
        /**
         * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
         */
        latency?: string;
        /**
         * The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
         */
        max_loss?: string;
      };
      /**
       * QoS metrics on screen shares output being received by a participant who joined the meeting via a Cloud Room Connector.
       */
      as_device_to_crc?: {
        /**
         * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
         */
        avg_loss?: string;
        /**
         * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
         */
        bitrate?: string;
        /**
         * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
         */
        jitter?: string;
        /**
         * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
         */
        latency?: string;
        /**
         * The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
         */
        max_loss?: string;
      };
      /**
       * Quality of service object.
       */
      as_input?: {
        /**
         * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
         */
        avg_loss?: string;
        /**
         * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
         */
        bitrate?: string;
        /**
         * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
         */
        jitter?: string;
        /**
         * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
         */
        latency?: string;
        /**
         * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
         */
        max_loss?: string;
      } & {
        /**
         * The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.
         */
        frame_rate?: string;
        /**
         * The number of pixels in each dimension that can be displayed by your video camera.
         */
        resolution?: string;
      };
      /**
       * Quality of service object.
       */
      as_output?: {
        /**
         * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
         */
        avg_loss?: string;
        /**
         * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
         */
        bitrate?: string;
        /**
         * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
         */
        jitter?: string;
        /**
         * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
         */
        latency?: string;
        /**
         * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
         */
        max_loss?: string;
      } & {
        /**
         * The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.
         */
        frame_rate?: string;
        /**
         * The number of pixels in each dimension that can be displayed by your video camera.
         */
        resolution?: string;
      };
      /**
       * QoS metrics on audio being sent by a participant who joined the meeting via a Cloud Room Connector.
       */
      audio_device_from_crc?: {
        /**
         * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
         */
        avg_loss?: string;
        /**
         * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
         */
        bitrate?: string;
        /**
         * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
         */
        jitter?: string;
        /**
         * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
         */
        latency?: string;
        /**
         * The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
         */
        max_loss?: string;
      };
      /**
       * QoS metrics on audio received by a participant who joined the meeting via a Cloud Room Connector.
       */
      audio_device_to_crc?: {
        /**
         * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
         */
        avg_loss?: string;
        /**
         * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
         */
        bitrate?: string;
        /**
         * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
         */
        jitter?: string;
        /**
         * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
         */
        latency?: string;
        /**
         * The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
         */
        max_loss?: string;
      };
      /**
       * Quality of Service object.
       */
      audio_input?: {
        /**
         * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
         */
        avg_loss?: string;
        /**
         * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
         */
        bitrate?: string;
        /**
         * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
         */
        jitter?: string;
        /**
         * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
         */
        latency?: string;
        /**
         * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
         */
        max_loss?: string;
      };
      /**
       * Quality of Service object.
       */
      audio_output?: {
        /**
         * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
         */
        avg_loss?: string;
        /**
         * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
         */
        bitrate?: string;
        /**
         * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
         */
        jitter?: string;
        /**
         * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
         */
        latency?: string;
        /**
         * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
         */
        max_loss?: string;
      };
      cpu_usage?: {
        /**
         * System Maximum CPU Usage
         */
        system_max_cpu_usage?: string;
        /**
         * Zoom Average CPU Usage
         */
        zoom_avg_cpu_usage?: string;
        /**
         * Zoom Maximum CPU Usage
         */
        zoom_max_cpu_usage?: string;
        /**
         * Zoom Minimum CPU Usage
         */
        zoom_min_cpu_usage?: string;
      };
      /**
       * Date-time of QOS
       */
      date_time?: string;
      /**
       * QoS metrics on video input being sent from a Cloud Room Connector used by the participant to join the meeting.
       */
      video_device_from_crc?: {
        /**
         * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
         */
        avg_loss?: string;
        /**
         * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
         */
        bitrate?: string;
        /**
         * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
         */
        jitter?: string;
        /**
         * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
         */
        latency?: string;
        /**
         * The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
         */
        max_loss?: string;
      };
      /**
       * QoS metrics on video output received by a participant who joined the meeting via a Cloud Room Connector.
       */
      video_device_to_crc?: {
        /**
         * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
         */
        avg_loss?: string;
        /**
         * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
         */
        bitrate?: string;
        /**
         * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
         */
        jitter?: string;
        /**
         * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
         */
        latency?: string;
        /**
         * The max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
         */
        max_loss?: string;
      };
      /**
       * Quality of service object.
       */
      video_input?: {
        /**
         * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
         */
        avg_loss?: string;
        /**
         * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
         */
        bitrate?: string;
        /**
         * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
         */
        jitter?: string;
        /**
         * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
         */
        latency?: string;
        /**
         * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
         */
        max_loss?: string;
      } & {
        /**
         * The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.
         */
        frame_rate?: string;
        /**
         * The number of pixels in each dimension that can be displayed by your video camera.
         */
        resolution?: string;
      };
      /**
       * Quality of service object.
       */
      video_output?: {
        /**
         * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
         */
        avg_loss?: string;
        /**
         * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
         */
        bitrate?: string;
        /**
         * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
         */
        jitter?: string;
        /**
         * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
         */
        latency?: string;
        /**
         * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
         */
        max_loss?: string;
      } & {
        /**
         * The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.
         */
        frame_rate?: string;
        /**
         * The number of pixels in each dimension that can be displayed by your video camera.
         */
        resolution?: string;
      };
    }>;
    /**
     * Participant's Zoom Client version.
     */
    version?: string;
  }>;
};

/**
 * Quality of service object.
 */
export type QOSVideo = {
  /**
   * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
   */
  avg_loss?: string;
  /**
   * The number of bits per second that can be transmitted along a digital network. The value of this field is expressed in kbps.
   */
  bitrate?: string;
  /**
   * The variation in the delay of received packets. The value of this field is expressed in milliseconds.
   */
  jitter?: string;
  /**
   * The amount of time it takes for a packet to travel from one point to another. The value of this field is expressed in milliseconds.
   */
  latency?: string;
  /**
   * Max loss: the max amount of packet loss, that is the max percentage of packets that fail to arrive at their destination.
   */
  max_loss?: string;
} & {
  /**
   * The rate at which your video camera can produce unique images, or frames. Zoom supports a frame rate of up to 30fps.
   */
  frame_rate?: string;
  /**
   * The number of pixels in each dimension that can be displayed by your video camera.
   */
  resolution?: string;
};

/**
 * Quality of Service object.
 */
export type QoSPhone = {
  /**
   * The average amount of packet loss, i.e., the percentage of packets that fail to arrive at their destination.
   */
  avg_loss?: string;
  /**
   * The number of bits per second that can be transmitted along a digital network.
   */
  bitrate?: string;
  /**
   * The variation in the delay of received packets.
   */
  jitter?: string;
  /**
   * The max amount of packet loss, i.e., the max percentage of packets that fail to arrive at their destination.
   */
  max_loss?: string;
  /**
   * Mean Opinion Score(MOS) measures voice quality on a scale of 1 to 5. A MOS greater than or equal to 3.5 means good quality, while below 3.5 means poor quality.
   */
  mos?: string;
  /**
   * The amount of time it takes for a VoIP packet to travel from one point to another.
   */
  network_delay?: string;
};

/**
 * Recording file object.
 */
export type Recording = {
  /**
   * The time at which recording was deleted. Returned in the response only for trash query.
   */
  deleted_time?: string;
  /**
   * The URL using which the recording file can be downloaded. **To access a private or password protected cloud recording of a user in your account, you can use a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the `access_token` query parameter and include this query parameter at the end of the URL as shown in the example.**
   * <br>
   * Example: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ JWT Token }}`
   *
   * **Similarly, if the user has installed your OAuth app that contains recording scope(s), you can also use the user's [OAuth access token](https://marketplace.zoom.us/docs/guides/auth/oauth) to download the Cloud Recording.**<br>
   *
   * Example: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ OAuth Access Token }}`
   *
   *
   */
  download_url?: string;
  /**
   * The recording file size.
   */
  file_size?: number;
  /**
   * The recording file type. The value of this field could be one of the following:<br>
   * `MP4`: Video file of the recording.<br>`M4A` Audio-only file of the recording.<br>`TIMELINE`: Timestamp file of the recording in JSON file format. To get a timeline file, the "Add a timestamp to the recording" setting must be enabled in the [recording settings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-recording#h_3f14c3a4-d16b-4a3c-bbe5-ef7d24500048). The time will display in the host's timezone, set on their Zoom profile.
   * <br> `TRANSCRIPT`: Transcription file of the recording in VTT format.<br> `CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>`CC`: File containing closed captions of the recording in VTT file format.<br>`CSV`: File containing polling data in csv format.
   *
   * <br>
   *
   * A recording file object with file type of either `CC` or `TIMELINE` **does not have** the following properties:<br>
   * `id`, `status`, `file_size`, `recording_type`, and `play_url`.
   */
  file_type?: string;
  /**
   * The recording file ID. Included in the response of general query.
   */
  id?: string;
  /**
   * The meeting ID.
   */
  meeting_id?: string;
  /**
   * The URL using which a recording file can be played.
   */
  play_url?: string;
  /**
   * The recording end time. Response in general query.
   */
  recording_end?: string;
  /**
   * The recording start time.
   */
  recording_start?: string;
  /**
   * The recording type. The value of this field can be one of the following:<br>`shared_screen_with_speaker_view(CC)`<br>`shared_screen_with_speaker_view`<br>`shared_screen_with_gallery_view`<br>`speaker_view`<br>`gallery_view`<br>`shared_screen`<br>`audio_only`<br>`audio_transcript`<br>`chat_file`<br>`active_speaker`<br>`poll`
   */
  recording_type?: string;
  /**
   * The recording status.
   */
  status?: 'completed';
};

/**
 * The recording status.
 */
export type status2 = 'completed';

/**
 * List of recording file.
 */
export type RecordingList = {
  /**
   * List of recording file.
   */
  recording_files?: Array<{
    /**
     * The time at which recording was deleted. Returned in the response only for trash query.
     */
    deleted_time?: string;
    /**
     * The URL using which the recording file can be downloaded. **To access a private or password protected cloud recording of a user in your account, you can use a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the `access_token` query parameter and include this query parameter at the end of the URL as shown in the example.**
     * <br>
     * Example: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ JWT Token }}`
     *
     * **Similarly, if the user has installed your OAuth app that contains recording scope(s), you can also use the user's [OAuth access token](https://marketplace.zoom.us/docs/guides/auth/oauth) to download the Cloud Recording.**<br>
     *
     * Example: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ OAuth Access Token }}`
     *
     *
     */
    download_url?: string;
    /**
     * The recording file size.
     */
    file_size?: number;
    /**
     * The recording file type. The value of this field could be one of the following:<br>
     * `MP4`: Video file of the recording.<br>`M4A` Audio-only file of the recording.<br>`TIMELINE`: Timestamp file of the recording in JSON file format. To get a timeline file, the "Add a timestamp to the recording" setting must be enabled in the [recording settings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-recording#h_3f14c3a4-d16b-4a3c-bbe5-ef7d24500048). The time will display in the host's timezone, set on their Zoom profile.
     * <br> `TRANSCRIPT`: Transcription file of the recording in VTT format.<br> `CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>`CC`: File containing closed captions of the recording in VTT file format.<br>`CSV`: File containing polling data in csv format.
     *
     * <br>
     *
     * A recording file object with file type of either `CC` or `TIMELINE` **does not have** the following properties:<br>
     * `id`, `status`, `file_size`, `recording_type`, and `play_url`.
     */
    file_type?: string;
    /**
     * The recording file ID. Included in the response of general query.
     */
    id?: string;
    /**
     * The meeting ID.
     */
    meeting_id?: string;
    /**
     * The URL using which a recording file can be played.
     */
    play_url?: string;
    /**
     * The recording end time. Response in general query.
     */
    recording_end?: string;
    /**
     * The recording start time.
     */
    recording_start?: string;
    /**
     * The recording type. The value of this field can be one of the following:<br>`shared_screen_with_speaker_view(CC)`<br>`shared_screen_with_speaker_view`<br>`shared_screen_with_gallery_view`<br>`speaker_view`<br>`gallery_view`<br>`shared_screen`<br>`audio_only`<br>`audio_transcript`<br>`chat_file`<br>`active_speaker`<br>`poll`
     */
    recording_type?: string;
    /**
     * The recording status.
     */
    status?: 'completed';
  }>;
};

/**
 * The recording meeting object.
 */
export type RecordingMeeting = {
  /**
   * Unique Identifier of the user account.
   */
  account_id?: string;
  /**
   * Meeting duration.
   */
  duration?: number;
  /**
   * ID of the user set as host of meeting.
   */
  host_id?: string;
  /**
   * Meeting ID - also known as the meeting number.
   */
  id?: string;
  /**
   * Number of recording files returned in the response of this API call.
   */
  recording_count?: string;
  /**
   * The time at which the meeting started.
   */
  start_time?: string;
  /**
   * Meeting topic.
   */
  topic?: string;
  /**
   * Total size of the recording.
   */
  total_size?: string;
  /**
   * Type of the meeting that was recorded.
   *
   * Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.
   */
  type?: string;
  /**
   * Unique Meeting Identifier. Each instance of the meeting will have its own UUID.
   */
  uuid?: string;
} & {
  /**
   * List of recording file.
   */
  recording_files?: Array<{
    /**
     * The time at which recording was deleted. Returned in the response only for trash query.
     */
    deleted_time?: string;
    /**
     * The URL using which the recording file can be downloaded. **To access a private or password protected cloud recording of a user in your account, you can use a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the `access_token` query parameter and include this query parameter at the end of the URL as shown in the example.**
     * <br>
     * Example: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ JWT Token }}`
     *
     * **Similarly, if the user has installed your OAuth app that contains recording scope(s), you can also use the user's [OAuth access token](https://marketplace.zoom.us/docs/guides/auth/oauth) to download the Cloud Recording.**<br>
     *
     * Example: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ OAuth Access Token }}`
     *
     *
     */
    download_url?: string;
    /**
     * The recording file size.
     */
    file_size?: number;
    /**
     * The recording file type. The value of this field could be one of the following:<br>
     * `MP4`: Video file of the recording.<br>`M4A` Audio-only file of the recording.<br>`TIMELINE`: Timestamp file of the recording in JSON file format. To get a timeline file, the "Add a timestamp to the recording" setting must be enabled in the [recording settings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-recording#h_3f14c3a4-d16b-4a3c-bbe5-ef7d24500048). The time will display in the host's timezone, set on their Zoom profile.
     * <br> `TRANSCRIPT`: Transcription file of the recording in VTT format.<br> `CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>`CC`: File containing closed captions of the recording in VTT file format.<br>`CSV`: File containing polling data in csv format.
     *
     * <br>
     *
     * A recording file object with file type of either `CC` or `TIMELINE` **does not have** the following properties:<br>
     * `id`, `status`, `file_size`, `recording_type`, and `play_url`.
     */
    file_type?: string;
    /**
     * The recording file ID. Included in the response of general query.
     */
    id?: string;
    /**
     * The meeting ID.
     */
    meeting_id?: string;
    /**
     * The URL using which a recording file can be played.
     */
    play_url?: string;
    /**
     * The recording end time. Response in general query.
     */
    recording_end?: string;
    /**
     * The recording start time.
     */
    recording_start?: string;
    /**
     * The recording type. The value of this field can be one of the following:<br>`shared_screen_with_speaker_view(CC)`<br>`shared_screen_with_speaker_view`<br>`shared_screen_with_gallery_view`<br>`speaker_view`<br>`gallery_view`<br>`shared_screen`<br>`audio_only`<br>`audio_transcript`<br>`chat_file`<br>`active_speaker`<br>`poll`
     */
    recording_type?: string;
    /**
     * The recording status.
     */
    status?: 'completed';
  }>;
};

/**
 * List of recordings.
 */
export type RecordingMeetingList = {
  /**
   * Start Date.
   */
  from?: string;
  /**
   * End Date.
   */
  to?: string;
} & {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * The number of records returned within a single API call.
   */
  page_size?: number;
  /**
   * The number of all records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of recordings.
   */
  meetings?: Array<
    {
      /**
       * Unique Identifier of the user account.
       */
      account_id?: string;
      /**
       * Meeting duration.
       */
      duration?: number;
      /**
       * ID of the user set as host of meeting.
       */
      host_id?: string;
      /**
       * Meeting ID - also known as the meeting number.
       */
      id?: string;
      /**
       * Number of recording files returned in the response of this API call.
       */
      recording_count?: string;
      /**
       * The time at which the meeting started.
       */
      start_time?: string;
      /**
       * Meeting topic.
       */
      topic?: string;
      /**
       * Total size of the recording.
       */
      total_size?: string;
      /**
       * Type of the meeting that was recorded.
       *
       * Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.
       */
      type?: string;
      /**
       * Unique Meeting Identifier. Each instance of the meeting will have its own UUID.
       */
      uuid?: string;
    } & {
      /**
       * List of recording file.
       */
      recording_files?: Array<{
        /**
         * The time at which recording was deleted. Returned in the response only for trash query.
         */
        deleted_time?: string;
        /**
         * The URL using which the recording file can be downloaded. **To access a private or password protected cloud recording of a user in your account, you can use a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the `access_token` query parameter and include this query parameter at the end of the URL as shown in the example.**
         * <br>
         * Example: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ JWT Token }}`
         *
         * **Similarly, if the user has installed your OAuth app that contains recording scope(s), you can also use the user's [OAuth access token](https://marketplace.zoom.us/docs/guides/auth/oauth) to download the Cloud Recording.**<br>
         *
         * Example: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ OAuth Access Token }}`
         *
         *
         */
        download_url?: string;
        /**
         * The recording file size.
         */
        file_size?: number;
        /**
         * The recording file type. The value of this field could be one of the following:<br>
         * `MP4`: Video file of the recording.<br>`M4A` Audio-only file of the recording.<br>`TIMELINE`: Timestamp file of the recording in JSON file format. To get a timeline file, the "Add a timestamp to the recording" setting must be enabled in the [recording settings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-recording#h_3f14c3a4-d16b-4a3c-bbe5-ef7d24500048). The time will display in the host's timezone, set on their Zoom profile.
         * <br> `TRANSCRIPT`: Transcription file of the recording in VTT format.<br> `CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>`CC`: File containing closed captions of the recording in VTT file format.<br>`CSV`: File containing polling data in csv format.
         *
         * <br>
         *
         * A recording file object with file type of either `CC` or `TIMELINE` **does not have** the following properties:<br>
         * `id`, `status`, `file_size`, `recording_type`, and `play_url`.
         */
        file_type?: string;
        /**
         * The recording file ID. Included in the response of general query.
         */
        id?: string;
        /**
         * The meeting ID.
         */
        meeting_id?: string;
        /**
         * The URL using which a recording file can be played.
         */
        play_url?: string;
        /**
         * The recording end time. Response in general query.
         */
        recording_end?: string;
        /**
         * The recording start time.
         */
        recording_start?: string;
        /**
         * The recording type. The value of this field can be one of the following:<br>`shared_screen_with_speaker_view(CC)`<br>`shared_screen_with_speaker_view`<br>`shared_screen_with_gallery_view`<br>`speaker_view`<br>`gallery_view`<br>`shared_screen`<br>`audio_only`<br>`audio_transcript`<br>`chat_file`<br>`active_speaker`<br>`poll`
         */
        recording_type?: string;
        /**
         * The recording status.
         */
        status?: 'completed';
      }>;
    }
  >;
};

/**
 * List of Recording Registration
 */
export type RecordingRegistrantList = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of Registrant objects
   */
  registrants?: Array<
    {
      id?: string;
    } & {
      /**
       * Registrant's address.
       */
      address?: string;
      /**
       * Registrant's city.
       */
      city?: string;
      /**
       * A field that allows registrants to provide any questions or comments that they might have.
       */
      comments?: string;
      /**
       * Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.
       */
      country?: string;
      /**
       * Custom questions.
       */
      custom_questions?: Array<{
        title?: string;
        value?: string;
      }>;
      /**
       * A valid email address of the registrant.
       */
      email: string;
      /**
       * Registrant's first name.
       */
      first_name: string;
      /**
       * Registrant's Industry.
       */
      industry?: string;
      /**
       * Registrant's job title.
       */
      job_title?: string;
      /**
       * Registrant's last name.
       */
      last_name?: string;
      /**
       * Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`
       */
      no_of_employees?: string;
      /**
       * Registrant's Organization.
       */
      org?: string;
      /**
       * Registrant's Phone number.
       */
      phone?: string;
      /**
       * This field can be included to gauge interest of webinar attendees towards buying your product or service.
       *
       * Purchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`
       */
      purchasing_time_frame?: string;
      /**
       * Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved`
       */
      role_in_purchase_process?: string;
      /**
       * Registrant's State/Province.
       */
      state?: string;
      /**
       * Registrant's Zip/Postal Code.
       */
      zip?: string;
    }
  >;
};

/**
 * Recording Registrant Questions
 */
export type RecordingRegistrantQuestions = {
  /**
   * Array of Registrant Custom Questions
   */
  custom_questions?: Array<{
    /**
     * Answer choices for the question. Can not be used with Short answer type.
     */
    answers?: Array<string>;
    /**
     * State whether registrants are required to answer custom questions or not.
     */
    required?: boolean;
    /**
     * Title of the question.
     */
    title?: string;
    /**
     * The type of registration question and answers.
     */
    type?: 'short' | 'single' | 'multiple';
  }>;
  /**
   * Array of Registrant Questions
   */
  questions?: Array<{
    /**
     * Field name.
     */
    field_name?:
      | 'last_name'
      | 'address'
      | 'city'
      | 'country'
      | 'zip'
      | 'state'
      | 'phone'
      | 'industry'
      | 'org'
      | 'job_title'
      | 'purchasing_time_frame'
      | 'role_in_purchase_process'
      | 'no_of_employees'
      | 'comments';
    /**
     * State whether the field is required to be answered by the registrant or not.
     */
    required?: boolean;
  }>;
};

/**
 * Registrant Status
 */
export type RecordingRegistrantStatus = {
  action: 'approve' | 'deny';
  /**
   * List of registrants
   */
  registrants?: Array<{
    id?: string;
  }>;
};

export type action4 = 'approve' | 'deny';

export type RecordingSettings = {
  /**
   * Approval type for the registration.<br>
   * `0`- Automatically approve the registration when a user registers.<br>
   * `1` - Manually approve or deny the registration of a user.<br>
   * `2` - No registration required to view the recording.
   */
  approval_type?: 0 | 1 | 2;
  /**
   * Authentication domains.
   */
  authentication_domains?: string;
  /**
   * Authentication Options.
   */
  authentication_option?: string;
  /**
   * Determine whether registration  isrequired to view the recording.
   */
  on_demand?: boolean;
  /**
   * Enable password protection for the recording by setting a password. The password must have a minimum of **eight** characters with a mix of numbers, letters and special characters.<br><br>
   * **Note:** If the account owner or the admin has set minimum password strength requirements for recordings via Account Settings, the password value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API.
   */
  password?: string;
  /**
   * Only authenticated users can view.
   */
  recording_authentication?: boolean;
  /**
   * Send an email to host when someone registers to view the recording. This applies for On-demand recordings only.
   */
  send_email_to_host?: boolean;
  /**
   * Determine how the meeting recording is shared.
   */
  share_recording?: 'publicly' | 'internally' | 'none';
  /**
   * Show social share buttons on registration page. This applies for On-demand recordings only.
   */
  show_social_share_buttons?: boolean;
  /**
   * Name of the recording.
   */
  topic?: string;
  /**
   * Determine whether a viewer can download the recording file or not.
   */
  viewer_download?: boolean;
};

/**
 * Determine how the meeting recording is shared.
 */
export type share_recording = 'publicly' | 'internally' | 'none';

/**
 * Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time.
 */
export type Recurrence = {
  /**
   * Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
   */
  end_date_time?: string;
  /**
   * Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)
   */
  end_times?: number;
  /**
   * Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.
   *
   * For instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
   */
  monthly_day?: number;
  /**
   * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
   */
  monthly_week?: -1 | 1 | 2 | 3 | 4;
  /**
   * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
   *
   * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
   */
  monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
  /**
   * Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
   *
   * For a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.
   *
   *
   */
  repeat_interval?: number;
  /**
   * Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
   */
  type: 1 | 2 | 3;
  /**
   * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
   *
   * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
   */
  weekly_days?: '1' | '2' | '3' | '4' | '5' | '6' | '7';
};

/**
 * Registrant base object.
 */
export type Registrant = {
  /**
   * Registrant's address.
   */
  address?: string;
  /**
   * Registrant's city.
   */
  city?: string;
  /**
   * A field that allows registrants to provide any questions or comments that they might have.
   */
  comments?: string;
  /**
   * Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.
   */
  country?: string;
  /**
   * Custom questions.
   */
  custom_questions?: Array<{
    title?: string;
    value?: string;
  }>;
  /**
   * A valid email address of the registrant.
   */
  email: string;
  /**
   * Registrant's first name.
   */
  first_name: string;
  /**
   * Registrant's Industry.
   */
  industry?: string;
  /**
   * Registrant's job title.
   */
  job_title?: string;
  /**
   * Registrant's last name.
   */
  last_name?: string;
  /**
   * Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`
   */
  no_of_employees?: string;
  /**
   * Registrant's Organization.
   */
  org?: string;
  /**
   * Registrant's Phone number.
   */
  phone?: string;
  /**
   * This field can be included to gauge interest of webinar attendees towards buying your product or service.
   *
   * Purchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`
   */
  purchasing_time_frame?: string;
  /**
   * Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved`
   */
  role_in_purchase_process?: string;
  /**
   * Registrant's State/Province.
   */
  state?: string;
  /**
   * Registrant's Zip/Postal Code.
   */
  zip?: string;
};

/**
 * List of users.
 */
export type RegistrantList = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of registrant objects.
   */
  registrants?: Array<
    {
      /**
       * Registrant ID.
       */
      id?: string;
    } & {
      /**
       * Registrant's address.
       */
      address?: string;
      /**
       * Registrant's city.
       */
      city?: string;
      /**
       * A field that allows registrants to provide any questions or comments that they might have.
       */
      comments?: string;
      /**
       * Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.
       */
      country?: string;
      /**
       * Custom questions.
       */
      custom_questions?: Array<{
        title?: string;
        value?: string;
      }>;
      /**
       * A valid email address of the registrant.
       */
      email: string;
      /**
       * Registrant's first name.
       */
      first_name: string;
      /**
       * Registrant's Industry.
       */
      industry?: string;
      /**
       * Registrant's job title.
       */
      job_title?: string;
      /**
       * Registrant's last name.
       */
      last_name?: string;
      /**
       * Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`
       */
      no_of_employees?: string;
      /**
       * Registrant's Organization.
       */
      org?: string;
      /**
       * Registrant's Phone number.
       */
      phone?: string;
      /**
       * This field can be included to gauge interest of webinar attendees towards buying your product or service.
       *
       * Purchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`
       */
      purchasing_time_frame?: string;
      /**
       * Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved`
       */
      role_in_purchase_process?: string;
      /**
       * Registrant's State/Province.
       */
      state?: string;
      /**
       * Registrant's Zip/Postal Code.
       */
      zip?: string;
    } & {
      /**
       * The time at which the registrant registered.
       */
      create_time?: string;
      /**
       * The URL using which an approved registrant can join the webinar.
       */
      join_url?: string;
      /**
       * The status of the registrant's registration. <br> `approved`: User has been successfully approved for the webinar.<br> `pending`:  The registration is still pending.<br> `denied`: User has been denied from joining the webinar.
       */
      status?: string;
    }
  >;
};

export type RegistrantStatus = {
  /**
   * Registrant Status:<br>`approve` - Approve registrant.<br>`cancel` - Cancel previously approved registrant's registration.<br>`deny` - Deny registrant.
   */
  action: 'approve' | 'cancel' | 'deny';
  /**
   * List of registrants.
   */
  registrants?: Array<{
    email?: string;
    id?: string;
  }>;
};

/**
 * Registrant Status:<br>`approve` - Approve registrant.<br>`cancel` - Cancel previously approved registrant's registration.<br>`deny` - Deny registrant.
 */
export type action5 = 'approve' | 'cancel' | 'deny';

/**
 * List of Roles
 */
export type RoleList = {
  /**
   * List of Roles objects
   */
  roles?: Array<{
    /**
     * Role Description
     */
    description?: string;
    /**
     * Role Id
     */
    id?: string;
    /**
     * Role Name
     */
    name?: string;
    /**
     * Total members in this role
     */
    total_members?: number;
  }>;
  /**
   * The number of all records available across pages
   */
  total_records?: number;
};

/**
 * Add Role Members
 */
export type RoleMembersAdd = {
  /**
   * List of Role's members
   */
  members?: Array<{
    /**
     * User email address. Must have id or email, if given id, the email is ignored.
     */
    email?: string;
    /**
     * User ID
     */
    id?: string;
  }>;
};

/**
 * List of a Role Members
 */
export type RoleMembersList = {
  /**
   * List of a Role Members
   */
  members?: Array<{
    /**
     * Member Department
     */
    department?: string;
    /**
     * Member Email
     */
    email?: string;
    /**
     * Member First Name
     */
    first_name?: string;
    /**
     * Member ID
     */
    id?: string;
    /**
     * Member Last Name
     */
    last_name?: string;
    /**
     * Member Type
     */
    type?: number;
  }>;
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned within a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
};

/**
 * Base object for sessions.
 */
export type Session = {
  /**
   * Meeting description.
   */
  agenda?: string;
  /**
   * Meeting duration (minutes). Used for scheduled meetings only.
   */
  duration?: number;
  /**
   * Password to join the meeting. Password may only contain the following characters: [a-z A-Z 0-9 @ - _ *]. Max of 10 characters.
   */
  password?: string;
  /**
   * Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time.
   */
  recurrence?: {
    /**
     * Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
     *
     * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.
     *
     *
     */
    repeat_interval?: number;
    /**
     * Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    weekly_days?: '1' | '2' | '3' | '4' | '5' | '6' | '7';
  };
  /**
   * Meeting settings.
   */
  settings?: {
    /**
     * Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host's emails or IDs: multiple values are separated by a semicolon.
     */
    alternative_hosts?: string;
    /**
     * Flag to determine whether to send email notifications to alternative hosts, default value is true.
     */
    alternative_hosts_email_notification?: boolean;
    /**
     * Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>
     *
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Approve or block users from specific regions/countries from joining this meeting.
     *
     */
    approved_or_denied_countries_or_regions?: {
      /**
       * List of countries/regions from where participants can join this meeting.
       */
      approved_list?: Array<string>;
      /**
       * List of countries/regions from where participants can not join this meeting.
       */
      denied_list?: Array<string>;
      /**
       * `true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>
       *
       * `false`: Setting disabled.
       */
      enable?: boolean;
      /**
       * Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>
       * `approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>
       * `deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`
       */
      method?: 'approve' | 'deny';
    };
    /**
     * Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
     */
    authentication_domains?: string;
    /**
     * The participants added here will receive unique meeting invite links and bypass authentication.
     */
    authentication_exception?: Array<{
      /**
       * Email address of the participant.
       */
      email?: string;
      /**
       * Name of the participant.
       */
      name?: string;
    }>;
    /**
     * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
     */
    authentication_name?: string;
    /**
     * Meeting authentication option id.
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).
     */
    breakout_room?: {
      /**
       * Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.
       */
      enable?: boolean;
      /**
       * Create room(s).
       */
      rooms?: Array<{
        /**
         * Name of the breakout room.
         */
        name?: string;
        /**
         * Email addresses of the participants who are to be assigned to the breakout room.
         */
        participants?: Array<string>;
      }>;
    };
    /**
     * Close registration after event date
     */
    close_registration?: boolean;
    /**
     * Host meeting in China.
     */
    cn_meeting?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Custom keys and values assigned to the meeting.
     */
    custom_keys?: Array<{
      /**
       * Custom key associated with the user.
       */
      key?: string;
      /**
       * Value of the custom key associated with the user.
       */
      value?: string;
    }>;
    /**
     * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
     * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
     *
     * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
     */
    encryption_type?: 'enhanced_encryption' | 'e2ee';
    /**
     * Only signed in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login_domains?: string;
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Global Dial-in Countries/Regions
     */
    global_dial_in_numbers?: Array<{
      /**
       * City of the number, if any. For example, Chicago.
       */
      city?: string;
      /**
       * Country code. For example, BR.
       */
      country?: string;
      /**
       * Full name of country. For example, Brazil.
       */
      country_name?: string;
      /**
       * Phone number. For example, +1 2332357613.
       */
      number?: string;
      /**
       * Type of number.
       */
      type?: 'toll' | 'tollfree';
    }>;
    /**
     * Start video when the host joins the meeting.
     */
    host_video?: boolean;
    /**
     * Host meeting in India.
     */
    in_meeting?: boolean;
    /**
     * If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:
     *
     * *  `0`: Allow participant to join anytime.
     * *  `5`: Allow participant to join 5 minutes before meeting start time.
     * * `10`: Allow participant to join 10 minutes before meeting start time.
     */
    jbh_time?: 0 | 5 | 10;
    /**
     * Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.
     */
    join_before_host?: boolean;
    language_interpretation?: {
      enable?: boolean;
      /**
       * Information associated with the interpreter.
       */
      interpreters?: Array<{
        /**
         * Email address of the interpreter.
         */
        email?: string;
        /**
         * Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma.
         *
         * For example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".
         */
        languages?: string;
      }>;
    };
    /**
     * `true`- Only authenticated users can join meetings.
     */
    meeting_authentication?: boolean;
    /**
     * Mute participants upon entry.
     */
    mute_upon_entry?: boolean;
    /**
     * Start video when participants join the meeting.
     */
    participant_video?: boolean;
    /**
     * Send confirmation email to registrants upon successful registration.
     */
    registrants_confirmation_email?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the meeting registration page.
     * This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    show_share_button?: boolean;
    /**
     * Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.
     */
    use_pmi?: boolean;
    /**
     * Enable waiting room
     */
    waiting_room?: boolean;
    /**
     * Add watermark when viewing a shared screen.
     */
    watermark?: boolean;
  };
  /**
   * Meeting start time. When using a format like "yyyy-MM-dd'T'HH:mm:ss'Z'", always use GMT time. When using a format like "yyyy-MM-dd'T'HH:mm:ss", you should use local time and specify the time zone. This is only used for scheduled meetings and recurring meetings with a fixed time.
   */
  start_time?: string;
  /**
   * Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) list for supported time zones and their formats.
   */
  timezone?: string;
  /**
   * Meeting topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Tracking fields type
     */
    field?: string;
    /**
     * Tracking fields value
     */
    value?: string;
  }>;
  /**
   * Meeting Type:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.
   */
  type?: 1 | 2 | 3 | 8;
};

/**
 * Base object for sessions.
 */
export type SessionUpdate = {
  /**
   * Meeting description.
   */
  agenda?: string;
  /**
   * Meeting duration (minutes). Used for scheduled meetings only.
   */
  duration?: number;
  /**
   * Meeting passcode. Passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ *] and can have a maximum of 10 characters.
   *
   * **Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the  [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API.
   */
  password?: string;
  /**
   * Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time.
   */
  recurrence?: {
    /**
     * Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
     *
     * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.
     *
     *
     */
    repeat_interval?: number;
    /**
     * Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    weekly_days?: '1' | '2' | '3' | '4' | '5' | '6' | '7';
  };
  settings?: {
    /**
     * Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host's emails or IDs: multiple values are separated by a semicolon.
     */
    alternative_hosts?: string;
    /**
     * Flag to determine whether to send email notifications to alternative hosts, default value is true.
     */
    alternative_hosts_email_notification?: boolean;
    /**
     * Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>
     *
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Approve or block users from specific regions/countries from joining this meeting.
     *
     */
    approved_or_denied_countries_or_regions?: {
      /**
       * List of countries/regions from where participants can join this meeting.
       */
      approved_list?: Array<string>;
      /**
       * List of countries/regions from where participants can not join this meeting.
       */
      denied_list?: Array<string>;
      /**
       * `true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>
       *
       * `false`: Setting disabled.
       */
      enable?: boolean;
      /**
       * Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>
       * `approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>
       * `deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`
       */
      method?: 'approve' | 'deny';
    };
    /**
     * Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
     */
    authentication_domains?: string;
    /**
     * The participants added here will receive unique meeting invite links and bypass authentication.
     */
    authentication_exception?: Array<{
      /**
       * Email address of the participant.
       */
      email?: string;
      /**
       * Name of the participant.
       */
      name?: string;
    }>;
    /**
     * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
     */
    authentication_name?: string;
    /**
     * Meeting authentication option id.
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).
     */
    breakout_room?: {
      /**
       * Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.
       */
      enable?: boolean;
      /**
       * Create room(s).
       */
      rooms?: Array<{
        /**
         * Name of the breakout room.
         */
        name?: string;
        /**
         * Email addresses of the participants who are to be assigned to the breakout room.
         */
        participants?: Array<string>;
      }>;
    };
    /**
     * Close registration after event date
     */
    close_registration?: boolean;
    /**
     * Host meeting in China.
     */
    cn_meeting?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Custom keys and values assigned to the meeting.
     */
    custom_keys?: Array<{
      /**
       * Custom key associated with the user.
       */
      key?: string;
      /**
       * Value of the custom key associated with the user.
       */
      value?: string;
    }>;
    /**
     * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
     * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
     *
     * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
     */
    encryption_type?: 'enhanced_encryption' | 'e2ee';
    /**
     * Only signed in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login_domains?: string;
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Global Dial-in Countries/Regions
     */
    global_dial_in_numbers?: Array<{
      /**
       * City of the number, if any. For example, Chicago.
       */
      city?: string;
      /**
       * Country code. For example, BR.
       */
      country?: string;
      /**
       * Full name of country. For example, Brazil.
       */
      country_name?: string;
      /**
       * Phone number. For example, +1 2332357613.
       */
      number?: string;
      /**
       * Type of number.
       */
      type?: 'toll' | 'tollfree';
    }>;
    /**
     * Start video when the host joins the meeting.
     */
    host_video?: boolean;
    /**
     * Host meeting in India.
     */
    in_meeting?: boolean;
    /**
     * If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:
     *
     * *  `0`: Allow participant to join anytime.
     * *  `5`: Allow participant to join 5 minutes before meeting start time.
     * * `10`: Allow participant to join 10 minutes before meeting start time.
     */
    jbh_time?: 0 | 5 | 10;
    /**
     * Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.
     */
    join_before_host?: boolean;
    language_interpretation?: {
      enable?: boolean;
      /**
       * Information associated with the interpreter.
       */
      interpreters?: Array<{
        /**
         * Email address of the interpreter.
         */
        email?: string;
        /**
         * Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma.
         *
         * For example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".
         */
        languages?: string;
      }>;
    };
    /**
     * `true`- Only authenticated users can join meetings.
     */
    meeting_authentication?: boolean;
    /**
     * Mute participants upon entry.
     */
    mute_upon_entry?: boolean;
    /**
     * Start video when participants join the meeting.
     */
    participant_video?: boolean;
    /**
     * Send confirmation email to registrants upon successful registration.
     */
    registrants_confirmation_email?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the meeting registration page.
     * This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    show_share_button?: boolean;
    /**
     * Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.
     */
    use_pmi?: boolean;
    /**
     * Enable waiting room
     */
    waiting_room?: boolean;
    /**
     * Add watermark when viewing a shared screen.
     */
    watermark?: boolean;
  } & {
    /**
     * Send confirmation Email to Registrants
     */
    registrants_confirmation_email?: boolean;
  };
  /**
   * Meeting start time. When using a format like "yyyy-MM-dd'T'HH:mm:ss'Z'", always use GMT time. When using a format like "yyyy-MM-dd'T'HH:mm:ss", you should use local time and  specify the time zone. Only used for scheduled meetings and recurring meetings with a fixed time.
   */
  start_time?: string;
  /**
   * Unique identifier of the meeting template.
   *
   * Use this field if you would like to [schedule the meeting from a meeting template](https://support.zoom.us/hc/en-us/articles/360036559151-Meeting-templates#h_86f06cff-0852-4998-81c5-c83663c176fb). You can retrieve the value of this field by calling the [List meeting templates]() API.
   */
  template_id?: string;
  /**
   * Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.
   */
  timezone?: string;
  /**
   * Meeting topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Tracking fields type
     */
    field?: string;
    /**
     * Tracking fields value
     */
    value?: string;
  }>;
  /**
   * Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with a fixed time.
   */
  type?: 1 | 2 | 3 | 8;
};

/**
 * Base webinar object for sessions.
 */
export type SessionWebinar = {
  /**
   * Webinar description.
   */
  agenda?: string;
  /**
   * Webinar duration (minutes). Used for scheduled webinars only.
   */
  duration?: number;
  /**
   * Webinar Passcode. Passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ *]. Max of 10 characters.
   */
  password?: string;
  /**
   * Recurrence object. Use this object only for a webinar of type `9` i.e., a recurring webinar with fixed time.
   */
  recurrence?: {
    /**
     * Select a date when the webinar will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the webinar will recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `3` to state which day in a month, the webinar should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the webinar to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the webinar to recur once every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `3` to state the week of the month when the webinar should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the webinar should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `3` to state a specific day in a week when the monthly webinar should recur. To use this field, you must also use the `monthly_week` field. <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the webinar should recur. For instance, if you would like to schedule a Webinar that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily webinar, the maximum interval you can set is `90` days. For a weekly webinar, the maximum interval that you can set is `12` weeks. For a monthly webinar, the maximum interval that you can set is `3` months.
     */
    repeat_interval?: number;
    /**
     * Recurrence webinar types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `2` to state which day(s) of the week the webinar should repeat. <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the Webinar should recur on Sunday, provide `"1"` as the value of this field.  <br><br> **Note:** If you would like the webinar to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the Webinar should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     *
     *
     */
    weekly_days?: string;
  };
  /**
   * Webinar settings.
   */
  settings?: {
    /**
     * Allow attendees to join from multiple devices.
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host emails or IDs. Multiple values separated by comma.
     */
    alternative_hosts?: string;
    /**
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Send reminder email to attendees and panelists.
     */
    attendees_and_panelists_reminder_email_notification?: {
      /**
       * * `true`: Send reminder email to attendees and panelists.
       *
       * * `false`: Do not send reminder email to attendees and panelists.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * Determine how participants can join the audio portion of the webinar.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
     */
    authentication_domains?: string;
    /**
     * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
     */
    authentication_name?: string;
    /**
     * Webinar authentication option id.
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Close registration after event date.
     */
    close_registration?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Set the email language to one of the following:
     * `en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.
     */
    email_language?: string;
    /**
     * Only signed in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.
     */
    enforce_login_domains?: string;
    /**
     * Send follow-up email to absentees.
     */
    follow_up_absentees_email_notification?: {
      /**
       * * `true`: Send follow-up email to absentees.
       *
       * * `false`: Do not send follow-up email to absentees.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * Send follow-up email to attendees.
     */
    follow_up_attendees_email_notification?: {
      /**
       * * `true`: Send follow-up email to attendees.
       *
       * * `false`: Do not send follow-up email to attendees.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Default to HD video.
     */
    hd_video?: boolean;
    /**
     * Start video when host joins webinar.
     */
    host_video?: boolean;
    /**
     * `true`- Only authenticated users can join Webinar.
     */
    meeting_authentication?: boolean;
    /**
     * Send notification email to registrants when the host updates a webinar.
     */
    notify_registrants?: boolean;
    /**
     * Make the webinar on-demand
     */
    on_demand?: boolean;
    /**
     * * `true`: Send invitation email to panelists.
     *
     * * `false`: Do not send invitation email to panelists.
     */
    panelists_invitation_email_notification?: boolean;
    /**
     * Start video when panelists join webinar.
     */
    panelists_video?: boolean;
    /**
     * Zoom will open a survey page in attendees' browsers after leaving the webinar
     */
    post_webinar_survey?: boolean;
    /**
     * Enable practice session.
     */
    practice_session?: boolean;
    /**
     * [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
     */
    question_and_answer?: {
      /**
       * * `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..
       *
       * * `false`: Do not allow anonymous questions.
       */
      allow_anonymous_questions?: boolean;
      /**
       * Indicate whether you want attendees to be able to view answered questions only or view all questions.
       *
       * * `only`: Attendees are able to view answered questions only.
       *
       * *  `all`: Attendees are able to view all questions submitted in the Q&A.
       */
      answer_questions?: 'only' | 'all';
      /**
       * * `true`: Attendees can answer questions or leave a comment in the question thread.
       *
       * * `false`: Attendees can not answer questions or leave a comment in the question thread
       */
      attendees_can_comment?: boolean;
      /**
       * * `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.
       *
       * * `false`: Attendees can not click the thumbs up butoon on questions.
       */
      attendees_can_upvote?: boolean;
      /**
       * * `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
       *
       * * `false`: Disable Q&A for webinar.
       */
      enable?: boolean;
    };
    /**
     * Send confirmation email to registrants
     */
    registrants_confirmation_email?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.
     */
    registrants_restrict_number?: number;
    /**
     * Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the registration page.
     */
    show_share_button?: boolean;
    /**
     * Survey url for post webinar survey
     */
    survey_url?: string;
  };
  /**
   * Webinar start time. We support two formats for `start_time` - local time and GMT.<br>
   *
   * To set time as GMT the format should be `yyyy-MM-dd`T`HH:mm:ssZ`.
   *
   * To set time using a specific timezone, use `yyyy-MM-dd`T`HH:mm:ss` format and specify the timezone [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) in the `timezone` field OR leave it blank and the timezone set on your Zoom account will be used. You can also set the time as UTC as the timezone field.
   *
   * The `start_time` should only be used for scheduled and / or recurring webinars with fixed time.
   */
  start_time?: string;
  /**
   * Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.
   */
  timezone?: string;
  /**
   * Webinar topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Tracking fields type
     */
    field?: string;
    /**
     * Tracking fields value
     */
    value?: string;
  }>;
  /**
   * Webinar Types:<br>`5` - Webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.
   */
  type?: 5 | 6 | 9;
};

/**
 * Base webinar object for sessions.
 */
export type SessionWebinarUpdate = {
  /**
   * Webinar description.
   */
  agenda?: string;
  /**
   * Webinar duration (minutes). Used for scheduled webinar only.
   */
  duration?: number;
  /**
   * [Webinar passcode](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords). By default, passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ * !] and can have a maximum of 10 characters.
   *
   * **Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the  [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API.
   *
   * If "**Require a passcode when scheduling new meetings**" setting has been **enabled** **and** [locked](https://support.zoom.us/hc/en-us/articles/115005269866-Using-Tiered-Settings#locked) for the user, the passcode field will be autogenerated for the Webinar in the response even if it is not provided in the API request. <br><br>
   *
   *
   *
   *
   *
   *
   *
   *
   */
  password?: string;
  /**
   * Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time.
   */
  recurrence?: {
    /**
     * Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
     *
     * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.
     *
     *
     */
    repeat_interval?: number;
    /**
     * Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    weekly_days?: '1' | '2' | '3' | '4' | '5' | '6' | '7';
  };
  settings?: {
    /**
     * Allow attendees to join from multiple devices.
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host emails or IDs. Multiple values separated by comma.
     */
    alternative_hosts?: string;
    /**
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Send reminder email to attendees and panelists.
     */
    attendees_and_panelists_reminder_email_notification?: {
      /**
       * * `true`: Send reminder email to attendees and panelists.
       *
       * * `false`: Do not send reminder email to attendees and panelists.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * Determine how participants can join the audio portion of the webinar.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
     */
    authentication_domains?: string;
    /**
     * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
     */
    authentication_name?: string;
    /**
     * Webinar authentication option id.
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Close registration after event date.
     */
    close_registration?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Set the email language to one of the following:
     * `en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.
     */
    email_language?: string;
    /**
     * Only signed in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.
     */
    enforce_login_domains?: string;
    /**
     * Send follow-up email to absentees.
     */
    follow_up_absentees_email_notification?: {
      /**
       * * `true`: Send follow-up email to absentees.
       *
       * * `false`: Do not send follow-up email to absentees.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * Send follow-up email to attendees.
     */
    follow_up_attendees_email_notification?: {
      /**
       * * `true`: Send follow-up email to attendees.
       *
       * * `false`: Do not send follow-up email to attendees.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Default to HD video.
     */
    hd_video?: boolean;
    /**
     * Start video when host joins webinar.
     */
    host_video?: boolean;
    /**
     * `true`- Only authenticated users can join Webinar.
     */
    meeting_authentication?: boolean;
    /**
     * Send notification email to registrants when the host updates a webinar.
     */
    notify_registrants?: boolean;
    /**
     * Make the webinar on-demand
     */
    on_demand?: boolean;
    /**
     * * `true`: Send invitation email to panelists.
     *
     * * `false`: Do not send invitation email to panelists.
     */
    panelists_invitation_email_notification?: boolean;
    /**
     * Start video when panelists join webinar.
     */
    panelists_video?: boolean;
    /**
     * Zoom will open a survey page in attendees' browsers after leaving the webinar
     */
    post_webinar_survey?: boolean;
    /**
     * Enable practice session.
     */
    practice_session?: boolean;
    /**
     * [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
     */
    question_and_answer?: {
      /**
       * * `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..
       *
       * * `false`: Do not allow anonymous questions.
       */
      allow_anonymous_questions?: boolean;
      /**
       * Indicate whether you want attendees to be able to view answered questions only or view all questions.
       *
       * * `only`: Attendees are able to view answered questions only.
       *
       * *  `all`: Attendees are able to view all questions submitted in the Q&A.
       */
      answer_questions?: 'only' | 'all';
      /**
       * * `true`: Attendees can answer questions or leave a comment in the question thread.
       *
       * * `false`: Attendees can not answer questions or leave a comment in the question thread
       */
      attendees_can_comment?: boolean;
      /**
       * * `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.
       *
       * * `false`: Attendees can not click the thumbs up butoon on questions.
       */
      attendees_can_upvote?: boolean;
      /**
       * * `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
       *
       * * `false`: Disable Q&A for webinar.
       */
      enable?: boolean;
    };
    /**
     * Send confirmation email to registrants
     */
    registrants_confirmation_email?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.
     */
    registrants_restrict_number?: number;
    /**
     * Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the registration page.
     */
    show_share_button?: boolean;
    /**
     * Survey url for post webinar survey
     */
    survey_url?: string;
  } & {
    /**
     * Send confirmation email to registrants.
     */
    registrants_confirmation_email?: boolean;
  };
  /**
   * Webinar start time, in the format "yyyy-MM-dd'T'HH:mm:ss'Z'." Should be in GMT time. In the format "yyyy-MM-dd'T'HH:mm:ss." This should be in local time and the timezone should be specified. Only used for scheduled webinars and recurring webinars with a fixed time.
   */
  start_time?: string;
  /**
   * Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.
   */
  timezone?: string;
  /**
   * Webinar topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Tracking fields type
     */
    field?: string;
    /**
     * Tracking fields value
     */
    value?: string;
  }>;
  /**
   * Webinar Types:<br>`5` - webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.
   */
  type?: 5 | 6 | 9;
};

export type SettingsUpdateTelephony = {
  /**
   * Third party audio conference info.
   */
  audio_conference_info?: string;
  /**
   * Show the international numbers link on the invitation email.
   */
  show_international_numbers_link?: boolean;
  /**
   * Indicates where most of the participants call into or call from duriing a meeting.
   */
  telephony_regions?: {
    /**
     * Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.
     */
    selection_values?: Array<string>;
  };
  /**
   * Third party audio conference.
   */
  third_party_audio?: boolean;
};

/**
 * List of TSP accounts.
 */
export type TSP = {
  /**
   * Conference code: numeric value, length is less than 16.
   */
  conference_code: string;
  /**
   * List of dial in numbers.
   */
  dial_in_numbers?: Array<{
    /**
     * Country code.
     */
    code?: string;
    /**
     * Country Label, if passed, will display in place of code.
     */
    country_label?: string;
    /**
     * Dial-in number: length is less than 16.
     */
    number?: string;
    /**
     * Dial-in number types:<br>`toll` - Toll number.<br>`tollfree` -Toll free number.<br>
     * `media_link` - Media link.
     */
    type?: 'toll' | 'tollfree' | 'media_link';
  }>;
  /**
   * Leader PIN: numeric value, length is less than 16.
   */
  leader_pin: string;
  /**
   * Telephony bridge
   */
  tsp_bridge?: 'US_TSP_TB' | 'EU_TSP_TB';
};

/**
 * Telephony bridge
 */
export type tsp_bridge = 'US_TSP_TB' | 'EU_TSP_TB';

/**
 * Tracking Field
 */
export type TrackingField = {
  /**
   * Label/ Name for the tracking field.
   */
  field?: string;
  /**
   * Array of recommended values
   */
  recommended_values?: Array<string>;
  /**
   * Tracking Field Required
   */
  required?: boolean;
  /**
   * Tracking Field Visible
   */
  visible?: boolean;
};

/**
 * Tracking Field List
 */
export type TrackingFieldList = {
  /**
   * The number of all records available across pages
   */
  total_records?: number;
  /**
   * Array of Tracking Fields
   */
  tracking_fields?: Array<
    {
      /**
       * ID of Tracking Field
       */
      id?: string;
    } & {
      /**
       * Label/ Name for the tracking field.
       */
      field?: string;
      /**
       * Array of recommended values
       */
      recommended_values?: Array<string>;
      /**
       * Tracking Field Required
       */
      required?: boolean;
      /**
       * Tracking Field Visible
       */
      visible?: boolean;
    }
  >;
};

/**
 * The user object represents a specific user on Zoom.
 */
export type User = {
  /**
   * User create time.
   */
  created_at?: string;
  /**
   * Department.
   */
  dept?: string;
  /**
   * User's email address.
   */
  email: string;
  /**
   * User's first name.
   */
  first_name?: string;
  /**
   * User last login client version.
   */
  last_client_version?: string;
  /**
   * User last login time.
   */
  last_login_time?: string;
  /**
   * User's last name.
   */
  last_name?: string;
  /**
   * Personal meeting ID.
   */
  pmi?: number;
  /**
   * User's [role](https://support.zoom.us/hc/en-us/articles/115001078646-Role-Based-Access-Control) name.
   */
  role_name?: string;
  /**
   * The time zone of the user.
   */
  timezone?: string;
  /**
   * User's plan type:<br>`1` - Basic.<br>`2` - Licensed.<br>`3` - On-prem.<br>`99` - None (this can only be set with `ssoCreate`).
   */
  type: 1 | 2 | 3 | 99;
  /**
   * Use Personal Meeting ID for instant meetings.
   */
  use_pmi?: boolean;
};

/**
 * User's plan type:<br>`1` - Basic.<br>`2` - Licensed.<br>`3` - On-prem.<br>`99` - None (this can only be set with `ssoCreate`).
 */
export type type7 = 1 | 2 | 3 | 99;

/**
 * List of user's assistants.
 */
export type UserAssistantsList = {
  /**
   * List of User's assistants.
   */
  assistants?: Array<{
    /**
     * Assistant's email address.
     */
    email?: string;
    /**
     * Assistant's user ID.
     */
    id?: string;
  }>;
};

/**
 * List of users.
 */
export type UserList = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of user objects.
   */
  users?: Array<
    {
      /**
       * User ID.
       */
      id?: string;
    } & {
      /**
       * User create time.
       */
      created_at?: string;
      /**
       * Department.
       */
      dept?: string;
      /**
       * User's email address.
       */
      email: string;
      /**
       * User's first name.
       */
      first_name?: string;
      /**
       * User last login client version.
       */
      last_client_version?: string;
      /**
       * User last login time.
       */
      last_login_time?: string;
      /**
       * User's last name.
       */
      last_name?: string;
      /**
       * Personal meeting ID.
       */
      pmi?: number;
      /**
       * User's [role](https://support.zoom.us/hc/en-us/articles/115001078646-Role-Based-Access-Control) name.
       */
      role_name?: string;
      /**
       * The time zone of the user.
       */
      timezone?: string;
      /**
       * User's plan type:<br>`1` - Basic.<br>`2` - Licensed.<br>`3` - On-prem.<br>`99` - None (this can only be set with `ssoCreate`).
       */
      type: 1 | 2 | 3 | 99;
      /**
       * Use Personal Meeting ID for instant meetings.
       */
      use_pmi?: boolean;
    } & {
      group_ids?: Array<string>;
      im_group_ids?: Array<string>;
    }
  >;
};

export type UserPermissions = {
  /**
   * List of user permissions.
   */
  permissions?: Array<string>;
};

/**
 * List of user's schedulers.
 */
export type UserSchedulersList = {
  /**
   * List of users for whom the current user can schedule meetings.
   */
  schedulers?: Array<{
    /**
     * Email address of the scheduler.
     */
    email?: string;
    /**
     * Unique Identifier (User ID) of the Scheduler.
     */
    id?: string;
    /**
     * PMI of the meeting host in long (int64) format.
     */
    pmi?: number;
  }>;
};

export type UserSettings = {
  email_notification?: {
    /**
     * When an alternative host is set or removed from a meeting.
     */
    alternative_host_reminder?: boolean;
    /**
     * When a meeting is cancelled.
     */
    cancel_meeting_reminder?: boolean;
    /**
     * When attendees join meeting before host.
     */
    jbh_reminder?: boolean;
    /**
     * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
     */
    schedule_for_reminder?: boolean;
  };
  feature?: {
    /**
     * Host meeting in China.
     */
    cn_meeting?: boolean;
    /**
     * Host meeting in India.
     */
    in_meeting?: boolean;
    /**
     * Large meeting feature.
     */
    large_meeting?: boolean;
    /**
     * Large meeting capacity: can be 500 or 1000, depending on if the user has a large meeting capacity plan subscription or not.
     */
    large_meeting_capacity?: number;
    /**
     * User’s meeting capacity.
     */
    meeting_capacity?: number;
    /**
     * Webinar feature.
     */
    webinar?: boolean;
    /**
     * Webinar capacity: can be 100, 500, 1000, 3000, 5000 or 10000, depending on if the user has a webinar capacity plan subscription or not.
     */
    webinar_capacity?: number;
    /**
     * Zoom phone feature.
     */
    zoom_phone?: boolean;
  };
  in_meeting?: {
    /**
     * Allow live streaming.
     */
    allow_live_streaming?: boolean;
    /**
     * Allow participants to use annotation tools.
     */
    annotation?: boolean;
    /**
     * Allow host to put attendee on hold.
     *
     * **This field has been deprecated and is no longer supported.**
     */
    attendee_on_hold?: boolean;
    /**
     * Auto save all in-meeting chats.
     */
    auto_saving_chat?: boolean;
    /**
     * Allow host to split meeting participants into separate breakout rooms.
     */
    breakout_room?: boolean;
    /**
     * Enable chat during meeting for all participants.
     */
    chat?: boolean;
    /**
     * Enable closed captions.
     */
    closed_caption?: boolean;
    /**
     * Allow the host to add co-hosts.
     */
    co_host?: boolean;
    /**
     * If set to `true`, you can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting your real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.
     */
    custom_data_center_regions?: boolean;
    /**
     * Allow custom live streaming.
     */
    custom_live_streaming_service?: boolean;
    /**
     * Custom service instructions.
     */
    custom_service_instructions?: string;
    /**
     * If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["DE", "NL", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).
     *
     */
    data_center_regions?: 'HK' | 'AU' | 'IN' | 'TY' | 'CN' | 'US' | 'CA' | 'DE' | 'NL' | 'LA';
    /**
     * Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).
     */
    e2e_encryption?: boolean;
    /**
     * Play sound when participants join or leave:<br>`host` - When host joins or leaves.<br>`all` - When any participant joins or leaves.<br>`none` - No join or leave sound.
     */
    entry_exit_chime?: 'host' | 'all' | 'none';
    /**
     * Allow another user to take control of the camera.
     */
    far_end_camera_control?: boolean;
    /**
     * Enable option to send feedback to Zoom at the end of the meeting.
     */
    feedback?: boolean;
    /**
     * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for the user or not.
     */
    file_transfer?: boolean;
    /**
     * Enable group HD video.
     */
    group_hd?: boolean;
    /**
     * Enable non-verbal feedback through screens.
     */
    non_verbal_feedback?: boolean;
    /**
     * Add polls to the meeting controls.
     */
    polling?: boolean;
    /**
     * Enable 1:1 private chat between participants during meetings.
     */
    private_chat?: boolean;
    /**
     * Record and play their own voice.
     */
    record_play_voice?: boolean;
    /**
     * Enable remote control during screensharing.
     */
    remote_control?: boolean;
    /**
     * Allow host to provide 1:1 remote support to a participant.
     */
    remote_support?: boolean;
    /**
     * Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the user or not.
     */
    request_permission_to_unmute?: boolean;
    /**
     * Allow host and participants to share their screen or content during meetings
     *
     */
    screen_sharing?: boolean;
    /**
     * Share dual camera (deprecated).
     */
    share_dual_camera?: boolean;
    /**
     * Always show meeting controls during a meeting.
     */
    show_meeting_control_toolbar?: boolean;
    /**
     * Enable virtual background.
     */
    virtual_background?: boolean;
    /**
     * Settings to manage virtual background.
     */
    virtual_background_settings?: {
      /**
       * Allow user to upload custom backgrounds.
       */
      allow_upload_custom?: boolean;
      /**
       * Allow use of videos for virtual backgrounds.
       */
      allow_videos?: boolean;
      /**
       * Enable virtual background.
       */
      enable?: boolean;
      files?: Array<{
        /**
         * Unique identifier of the file.
         */
        id?: string;
        /**
         * Indicates whether or not this file is the default virtual background file.
         */
        is_default?: boolean;
        /**
         * File name.
         */
        name?: string;
        /**
         * File size.
         */
        size?: string;
        /**
         * File type.
         */
        type?: string;
      }>;
    };
    /**
     * Enable Waiting room - if enabled, attendees can only join after host approves.
     */
    waiting_room?: boolean;
    /**
     * Indicates who can share their screen or content during meetings. The value can be one of the following: <br>
     * `host`: Only host can share the screen.<br>
     * `all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
     *
     */
    who_can_share_screen?: 'host' | 'all';
    /**
     * Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>
     * `host`: Only a host can share the screen when someone else is sharing.<br>
     * `all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
     *
     */
    who_can_share_screen_when_someone_is_sharing?: 'host' | 'all';
    /**
     * Allow livestreaming by host through Workplace by Facebook.
     */
    workplace_by_facebook?: boolean;
  };
  profile?: {
    recording_storage_location?: {
      /**
       * Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.
       *
       * Provide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.
       */
      allowed_values?: Array<string>;
      /**
       * Abbreviated country code.
       */
      value?: string;
    };
  };
  recording?: {
    /**
     * Ask host to confirm the disclaimer.
     */
    ask_host_to_confirm_disclaimer?: boolean;
    /**
     * This field can be used if `recording_disclaimer` is set to true. This field indicates whether or not you would like to ask participants for consent when a recording starts. The value can be one of the following:<br>
     * * `true`: Ask participants for consent when a recording starts. <br>
     * * `false`: Do not ask participants for consent when a recording starts.
     */
    ask_participants_to_consent_disclaimer?: boolean;
    /**
     * Auto delete cloud recordings.
     */
    auto_delete_cmr?: boolean;
    /**
     * A specified number of days of auto delete cloud recordings.
     */
    auto_delete_cmr_days?: number;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` - Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Cloud recording.
     */
    cloud_recording?: boolean;
    /**
     * Host can pause/stop the auto recording in the cloud.
     */
    host_pause_stop_recording?: boolean;
    /**
     * Setting to allow cloud recording access only from specific IP address ranges.
     *
     */
    ip_address_access_control?: {
      /**
       * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
       *
       *
       */
      enable?: boolean;
      /**
       * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
       *
       * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
       *
       *
       */
      ip_addresses_or_ranges?: string;
    };
    /**
     * Local recording.
     */
    local_recording?: boolean;
    /**
     * Record an audio only file.
     */
    record_audio_file?: boolean;
    /**
     * Record the gallery view.
     */
    record_gallery_view?: boolean;
    /**
     * Record the active speaker view.
     */
    record_speaker_view?: boolean;
    /**
     * Audio transcript.
     */
    recording_audio_transcript?: boolean;
    /**
     * Show a disclaimer to participants before a recording starts
     *
     */
    recording_disclaimer?: boolean;
    /**
     * This object represents the minimum passcode requirements set for recordings via Account Recording Settings.
     */
    recording_password_requirement?: {
      /**
       * Indicates whether or not passcode must contain at least one alphabetical letter (a, b, c..).
       */
      have_letter?: boolean;
      /**
       * Indicates whether or not passcode must contain at least one number(1, 2, 3..).
       */
      have_number?: boolean;
      /**
       * Indicates whether or not passcode must contain at least one special character(!, @, #..).
       */
      have_special_character?: boolean;
      /**
       * Minimum required length for the passcode.
       */
      length?: number;
      /**
       * Indicates whether or not passcode must contain only numeric characters.
       */
      only_allow_numeric?: boolean;
    };
    /**
     * Save chat text from the meeting.
     */
    save_chat_text?: boolean;
    /**
     * Show timestamp on video.
     */
    show_timestamp?: boolean;
  };
  schedule_meeting?: {
    /**
     * Determine how participants can join the audio portion of the meeting:<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - Third party audio conference.
     */
    audio_type?: 'both' | 'telephony' | 'voip' | 'thirdParty';
    /**
     * Passcode for already scheduled meetings
     *
     */
    default_password_for_scheduled_meetings?: string;
    /**
     * If the value is set to `true`, the meeting passcode will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the passcode.
     *
     */
    embed_password_in_join_link?: boolean;
    /**
     * Require a passcode for personal meetings if attendees can join before host.
     */
    force_pmi_jbh_password?: boolean;
    /**
     * Start meetings with host video on.
     */
    host_video?: boolean;
    /**
     * Join the meeting before host arrives.
     */
    join_before_host?: boolean;
    /**
     * Account wide meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
     */
    meeting_password_requirement?: {
      consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
      /**
       * If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).
       *
       */
      have_letter?: boolean;
      /**
       * If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).
       */
      have_number?: boolean;
      /**
       * If set to `true`, the passcode must have at least 1 special character (!,@,#...).
       */
      have_special_character?: boolean;
      /**
       * If set to `true`, the passcode must include both uppercase and lowercase characters.
       */
      have_upper_and_lower_characters?: boolean;
      /**
       * The minimum length that the meeting/webinar passcode needs to have.
       */
      length?: number;
      /**
       * If set to `true`, the passcode must only contain numbers and no other characters.
       */
      only_allow_numeric?: boolean;
      /**
       * If set to `true`, users will be informed if the provided passcode is weak.
       */
      weak_enhance_detection?: boolean;
    };
    /**
     * Start meetings with participants video on.
     */
    participants_video?: boolean;
    /**
     * Personal Meeting Setting.<br><br>
     * `true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>
     * `false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.
     * For Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.
     *
     *
     *
     */
    personal_meeting?: boolean;
    /**
     * PMI passcode
     *
     */
    pmi_password?: string;
    /**
     * Generate and require passcode for participants joining by phone.
     */
    pstn_password_protected?: boolean;
    /**
     * Require a passcode for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
     *
     */
    require_password_for_instant_meetings?: boolean;
    /**
     * Require a passcode for Personal Meeting ID (PMI). This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
     *
     */
    require_password_for_pmi_meetings?: 'jbh_only' | 'all' | 'none';
    /**
     * Require a passcode for meetings which have already been scheduled
     *
     */
    require_password_for_scheduled_meetings?: boolean;
    /**
     * Require a passcode when scheduling new meetings.This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
     *
     */
    require_password_for_scheduling_new_meetings?: boolean;
    /**
     * Use Personal Meeting ID (PMI) when starting an instant meeting
     *
     */
    use_pmi_for_instant_meetings?: boolean;
    /**
     * Use Personal Meeting ID (PMI) when scheduling a meeting
     *
     */
    use_pmi_for_scheduled_meetings?: boolean;
  };
  telephony?: {
    /**
     * Third party audio conference info.
     */
    audio_conference_info?: string;
    /**
     * Show the international numbers link on the invitation email.
     */
    show_international_numbers_link?: boolean;
    /**
     * Indicates where most of the participants call into or call from duriing a meeting.
     */
    telephony_regions?: {
      /**
       * Telephony region options provided by Zoom to select from.
       */
      allowed_values?: Array<string>;
      /**
       * Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.
       */
      selection_values?: Array<string>;
    };
    /**
     * Third party audio conference.
     */
    third_party_audio?: boolean;
  };
  /**
   * Account Settings: TSP.
   */
  tsp?: {
    /**
     * Call Out
     */
    call_out?: boolean;
    /**
     * Call Out Countries/Regions
     */
    call_out_countries?: Array<unknown>;
    /**
     * Show international numbers link on the invitation email
     */
    show_international_numbers_link?: boolean;
  };
};

/**
 * If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["DE", "NL", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).
 *
 */
export type data_center_regions2 = 'HK' | 'AU' | 'IN' | 'TY' | 'CN' | 'US' | 'CA' | 'DE' | 'NL' | 'LA';

export type UserSettingsEmailNotification = {
  /**
   * When an alternative host is set or removed from a meeting.
   */
  alternative_host_reminder?: boolean;
  /**
   * When a meeting is cancelled.
   */
  cancel_meeting_reminder?: boolean;
  /**
   * When attendees join meeting before host.
   */
  jbh_reminder?: boolean;
  /**
   * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
   */
  schedule_for_reminder?: boolean;
};

export type UserSettingsFeature = {
  /**
   * Host meeting in China.
   */
  cn_meeting?: boolean;
  /**
   * Host meeting in India.
   */
  in_meeting?: boolean;
  /**
   * Large meeting feature.
   */
  large_meeting?: boolean;
  /**
   * Large meeting capacity: can be 500 or 1000, depending on if the user has a large meeting capacity plan subscription or not.
   */
  large_meeting_capacity?: number;
  /**
   * User’s meeting capacity.
   */
  meeting_capacity?: number;
  /**
   * Webinar feature.
   */
  webinar?: boolean;
  /**
   * Webinar capacity: can be 100, 500, 1000, 3000, 5000 or 10000, depending on if the user has a webinar capacity plan subscription or not.
   */
  webinar_capacity?: number;
  /**
   * Zoom phone feature.
   */
  zoom_phone?: boolean;
};

export type UserSettingsFeatureUpdate = {
  /**
   * Enable [large meeting](https://support.zoom.us/hc/en-us/articles/201362823-What-is-a-Large-Meeting-) feature for the user.
   */
  large_meeting?: boolean;
  /**
   * Set the meeting capacity for the user if the user has **Large meeting** feature enabled. The value for the field can be either 500 or 1000.
   */
  large_meeting_capacity?: number;
  /**
   * Set a user's meeting capacity. User’s meeting capacity denotes the maximum number of participants that can join a meeting scheduled by the user.
   */
  meeting_capacity?: number;
  /**
   * Enable Webinar feature for the user.
   */
  webinar?: boolean;
  /**
   * Set the Webinar capacity for a user who has the Webinar feature enabled. The value of this field can be 100, 500, 1000, 3000, 5000 or 10000.
   */
  webinar_capacity?: number;
  /**
   * Zoom phone feature.
   */
  zoom_phone?: boolean;
};

export type UserSettingsInMeeting = {
  /**
   * Allow live streaming.
   */
  allow_live_streaming?: boolean;
  /**
   * Allow participants to use annotation tools.
   */
  annotation?: boolean;
  /**
   * Allow host to put attendee on hold.
   *
   * **This field has been deprecated and is no longer supported.**
   */
  attendee_on_hold?: boolean;
  /**
   * Auto save all in-meeting chats.
   */
  auto_saving_chat?: boolean;
  /**
   * Allow host to split meeting participants into separate breakout rooms.
   */
  breakout_room?: boolean;
  /**
   * Enable chat during meeting for all participants.
   */
  chat?: boolean;
  /**
   * Enable closed captions.
   */
  closed_caption?: boolean;
  /**
   * Allow the host to add co-hosts.
   */
  co_host?: boolean;
  /**
   * If set to `true`, you can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting your real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.
   */
  custom_data_center_regions?: boolean;
  /**
   * Allow custom live streaming.
   */
  custom_live_streaming_service?: boolean;
  /**
   * Custom service instructions.
   */
  custom_service_instructions?: string;
  /**
   * If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["DE", "NL", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).
   *
   */
  data_center_regions?: 'HK' | 'AU' | 'IN' | 'TY' | 'CN' | 'US' | 'CA' | 'DE' | 'NL' | 'LA';
  /**
   * Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).
   */
  e2e_encryption?: boolean;
  /**
   * Play sound when participants join or leave:<br>`host` - When host joins or leaves.<br>`all` - When any participant joins or leaves.<br>`none` - No join or leave sound.
   */
  entry_exit_chime?: 'host' | 'all' | 'none';
  /**
   * Allow another user to take control of the camera.
   */
  far_end_camera_control?: boolean;
  /**
   * Enable option to send feedback to Zoom at the end of the meeting.
   */
  feedback?: boolean;
  /**
   * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for the user or not.
   */
  file_transfer?: boolean;
  /**
   * Enable group HD video.
   */
  group_hd?: boolean;
  /**
   * Enable non-verbal feedback through screens.
   */
  non_verbal_feedback?: boolean;
  /**
   * Add polls to the meeting controls.
   */
  polling?: boolean;
  /**
   * Enable 1:1 private chat between participants during meetings.
   */
  private_chat?: boolean;
  /**
   * Record and play their own voice.
   */
  record_play_voice?: boolean;
  /**
   * Enable remote control during screensharing.
   */
  remote_control?: boolean;
  /**
   * Allow host to provide 1:1 remote support to a participant.
   */
  remote_support?: boolean;
  /**
   * Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the user or not.
   */
  request_permission_to_unmute?: boolean;
  /**
   * Allow host and participants to share their screen or content during meetings
   *
   */
  screen_sharing?: boolean;
  /**
   * Share dual camera (deprecated).
   */
  share_dual_camera?: boolean;
  /**
   * Always show meeting controls during a meeting.
   */
  show_meeting_control_toolbar?: boolean;
  /**
   * Enable virtual background.
   */
  virtual_background?: boolean;
  /**
   * Settings to manage virtual background.
   */
  virtual_background_settings?: {
    /**
     * Allow user to upload custom backgrounds.
     */
    allow_upload_custom?: boolean;
    /**
     * Allow use of videos for virtual backgrounds.
     */
    allow_videos?: boolean;
    /**
     * Enable virtual background.
     */
    enable?: boolean;
    files?: Array<{
      /**
       * Unique identifier of the file.
       */
      id?: string;
      /**
       * Indicates whether or not this file is the default virtual background file.
       */
      is_default?: boolean;
      /**
       * File name.
       */
      name?: string;
      /**
       * File size.
       */
      size?: string;
      /**
       * File type.
       */
      type?: string;
    }>;
  };
  /**
   * Enable Waiting room - if enabled, attendees can only join after host approves.
   */
  waiting_room?: boolean;
  /**
   * Indicates who can share their screen or content during meetings. The value can be one of the following: <br>
   * `host`: Only host can share the screen.<br>
   * `all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
   *
   */
  who_can_share_screen?: 'host' | 'all';
  /**
   * Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>
   * `host`: Only a host can share the screen when someone else is sharing.<br>
   * `all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
   *
   */
  who_can_share_screen_when_someone_is_sharing?: 'host' | 'all';
  /**
   * Allow livestreaming by host through Workplace by Facebook.
   */
  workplace_by_facebook?: boolean;
};

export type UserSettingsRecording = {
  /**
   * Ask host to confirm the disclaimer.
   */
  ask_host_to_confirm_disclaimer?: boolean;
  /**
   * This field can be used if `recording_disclaimer` is set to true. This field indicates whether or not you would like to ask participants for consent when a recording starts. The value can be one of the following:<br>
   * * `true`: Ask participants for consent when a recording starts. <br>
   * * `false`: Do not ask participants for consent when a recording starts.
   */
  ask_participants_to_consent_disclaimer?: boolean;
  /**
   * Auto delete cloud recordings.
   */
  auto_delete_cmr?: boolean;
  /**
   * A specified number of days of auto delete cloud recordings.
   */
  auto_delete_cmr_days?: number;
  /**
   * Automatic recording:<br>`local` - Record on local.<br>`cloud` - Record on cloud.<br>`none` - Disabled.
   */
  auto_recording?: 'local' | 'cloud' | 'none';
  /**
   * Cloud recording.
   */
  cloud_recording?: boolean;
  /**
   * Host can pause/stop the auto recording in the cloud.
   */
  host_pause_stop_recording?: boolean;
  /**
   * Setting to allow cloud recording access only from specific IP address ranges.
   *
   */
  ip_address_access_control?: {
    /**
     * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
     *
     *
     */
    enable?: boolean;
    /**
     * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
     *
     * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
     *
     *
     */
    ip_addresses_or_ranges?: string;
  };
  /**
   * Local recording.
   */
  local_recording?: boolean;
  /**
   * Record an audio only file.
   */
  record_audio_file?: boolean;
  /**
   * Record the gallery view.
   */
  record_gallery_view?: boolean;
  /**
   * Record the active speaker view.
   */
  record_speaker_view?: boolean;
  /**
   * Audio transcript.
   */
  recording_audio_transcript?: boolean;
  /**
   * Show a disclaimer to participants before a recording starts
   *
   */
  recording_disclaimer?: boolean;
  /**
   * This object represents the minimum passcode requirements set for recordings via Account Recording Settings.
   */
  recording_password_requirement?: {
    /**
     * Indicates whether or not passcode must contain at least one alphabetical letter (a, b, c..).
     */
    have_letter?: boolean;
    /**
     * Indicates whether or not passcode must contain at least one number(1, 2, 3..).
     */
    have_number?: boolean;
    /**
     * Indicates whether or not passcode must contain at least one special character(!, @, #..).
     */
    have_special_character?: boolean;
    /**
     * Minimum required length for the passcode.
     */
    length?: number;
    /**
     * Indicates whether or not passcode must contain only numeric characters.
     */
    only_allow_numeric?: boolean;
  };
  /**
   * Save chat text from the meeting.
   */
  save_chat_text?: boolean;
  /**
   * Show timestamp on video.
   */
  show_timestamp?: boolean;
};

export type UserSettingsScheduleMeeting = {
  /**
   * Determine how participants can join the audio portion of the meeting:<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - Third party audio conference.
   */
  audio_type?: 'both' | 'telephony' | 'voip' | 'thirdParty';
  /**
   * Passcode for already scheduled meetings
   *
   */
  default_password_for_scheduled_meetings?: string;
  /**
   * If the value is set to `true`, the meeting passcode will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the passcode.
   *
   */
  embed_password_in_join_link?: boolean;
  /**
   * Require a passcode for personal meetings if attendees can join before host.
   */
  force_pmi_jbh_password?: boolean;
  /**
   * Start meetings with host video on.
   */
  host_video?: boolean;
  /**
   * Join the meeting before host arrives.
   */
  join_before_host?: boolean;
  /**
   * Account wide meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
   */
  meeting_password_requirement?: {
    consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
    /**
     * If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).
     *
     */
    have_letter?: boolean;
    /**
     * If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).
     */
    have_number?: boolean;
    /**
     * If set to `true`, the passcode must have at least 1 special character (!,@,#...).
     */
    have_special_character?: boolean;
    /**
     * If set to `true`, the passcode must include both uppercase and lowercase characters.
     */
    have_upper_and_lower_characters?: boolean;
    /**
     * The minimum length that the meeting/webinar passcode needs to have.
     */
    length?: number;
    /**
     * If set to `true`, the passcode must only contain numbers and no other characters.
     */
    only_allow_numeric?: boolean;
    /**
     * If set to `true`, users will be informed if the provided passcode is weak.
     */
    weak_enhance_detection?: boolean;
  };
  /**
   * Start meetings with participants video on.
   */
  participants_video?: boolean;
  /**
   * Personal Meeting Setting.<br><br>
   * `true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>
   * `false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.
   * For Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.
   *
   *
   *
   */
  personal_meeting?: boolean;
  /**
   * PMI passcode
   *
   */
  pmi_password?: string;
  /**
   * Generate and require passcode for participants joining by phone.
   */
  pstn_password_protected?: boolean;
  /**
   * Require a passcode for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
   *
   */
  require_password_for_instant_meetings?: boolean;
  /**
   * Require a passcode for Personal Meeting ID (PMI). This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
   *
   */
  require_password_for_pmi_meetings?: 'jbh_only' | 'all' | 'none';
  /**
   * Require a passcode for meetings which have already been scheduled
   *
   */
  require_password_for_scheduled_meetings?: boolean;
  /**
   * Require a passcode when scheduling new meetings.This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
   *
   */
  require_password_for_scheduling_new_meetings?: boolean;
  /**
   * Use Personal Meeting ID (PMI) when starting an instant meeting
   *
   */
  use_pmi_for_instant_meetings?: boolean;
  /**
   * Use Personal Meeting ID (PMI) when scheduling a meeting
   *
   */
  use_pmi_for_scheduled_meetings?: boolean;
};

/**
 * Account Settings: TSP.
 */
export type UserSettingsTSP = {
  /**
   * Call Out
   */
  call_out?: boolean;
  /**
   * Call Out Countries/Regions
   */
  call_out_countries?: Array<unknown>;
  /**
   * Show international numbers link on the invitation email
   */
  show_international_numbers_link?: boolean;
};

export type UserSettingsTelephony = {
  /**
   * Third party audio conference info.
   */
  audio_conference_info?: string;
  /**
   * Show the international numbers link on the invitation email.
   */
  show_international_numbers_link?: boolean;
  /**
   * Indicates where most of the participants call into or call from duriing a meeting.
   */
  telephony_regions?: {
    /**
     * Telephony region options provided by Zoom to select from.
     */
    allowed_values?: Array<string>;
    /**
     * Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.
     */
    selection_values?: Array<string>;
  };
  /**
   * Third party audio conference.
   */
  third_party_audio?: boolean;
};

export type UserSettingsUpdate = {
  email_notification?: {
    /**
     * When an alternative host is set or removed from a meeting.
     */
    alternative_host_reminder?: boolean;
    /**
     * When a meeting is cancelled.
     */
    cancel_meeting_reminder?: boolean;
    /**
     * When attendees join meeting before host.
     */
    jbh_reminder?: boolean;
    /**
     * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
     */
    schedule_for_reminder?: boolean;
  };
  feature?: {
    /**
     * Enable [large meeting](https://support.zoom.us/hc/en-us/articles/201362823-What-is-a-Large-Meeting-) feature for the user.
     */
    large_meeting?: boolean;
    /**
     * Set the meeting capacity for the user if the user has **Large meeting** feature enabled. The value for the field can be either 500 or 1000.
     */
    large_meeting_capacity?: number;
    /**
     * Set a user's meeting capacity. User’s meeting capacity denotes the maximum number of participants that can join a meeting scheduled by the user.
     */
    meeting_capacity?: number;
    /**
     * Enable Webinar feature for the user.
     */
    webinar?: boolean;
    /**
     * Set the Webinar capacity for a user who has the Webinar feature enabled. The value of this field can be 100, 500, 1000, 3000, 5000 or 10000.
     */
    webinar_capacity?: number;
    /**
     * Zoom phone feature.
     */
    zoom_phone?: boolean;
  };
  in_meeting?: {
    /**
     * Allow live streaming.
     */
    allow_live_streaming?: boolean;
    /**
     * Allow participants to use annotation tools.
     */
    annotation?: boolean;
    /**
     * Allow host to put attendee on hold.
     *
     * **This field has been deprecated and is no longer supported.**
     */
    attendee_on_hold?: boolean;
    /**
     * Auto save all in-meeting chats.
     */
    auto_saving_chat?: boolean;
    /**
     * Allow host to split meeting participants into separate breakout rooms.
     */
    breakout_room?: boolean;
    /**
     * Enable chat during meeting for all participants.
     */
    chat?: boolean;
    /**
     * Enable closed captions.
     */
    closed_caption?: boolean;
    /**
     * Allow the host to add co-hosts.
     */
    co_host?: boolean;
    /**
     * If set to `true`, you can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting your real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.
     */
    custom_data_center_regions?: boolean;
    /**
     * Allow custom live streaming.
     */
    custom_live_streaming_service?: boolean;
    /**
     * Custom service instructions.
     */
    custom_service_instructions?: string;
    /**
     * If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["DE", "NL", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).
     *
     */
    data_center_regions?: 'HK' | 'AU' | 'IN' | 'TY' | 'CN' | 'US' | 'CA' | 'DE' | 'NL' | 'LA';
    /**
     * Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).
     */
    e2e_encryption?: boolean;
    /**
     * Play sound when participants join or leave:<br>`host` - When host joins or leaves.<br>`all` - When any participant joins or leaves.<br>`none` - No join or leave sound.
     */
    entry_exit_chime?: 'host' | 'all' | 'none';
    /**
     * Allow another user to take control of the camera.
     */
    far_end_camera_control?: boolean;
    /**
     * Enable option to send feedback to Zoom at the end of the meeting.
     */
    feedback?: boolean;
    /**
     * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for the user or not.
     */
    file_transfer?: boolean;
    /**
     * Enable group HD video.
     */
    group_hd?: boolean;
    /**
     * Enable non-verbal feedback through screens.
     */
    non_verbal_feedback?: boolean;
    /**
     * Add polls to the meeting controls.
     */
    polling?: boolean;
    /**
     * Enable 1:1 private chat between participants during meetings.
     */
    private_chat?: boolean;
    /**
     * Record and play their own voice.
     */
    record_play_voice?: boolean;
    /**
     * Enable remote control during screensharing.
     */
    remote_control?: boolean;
    /**
     * Allow host to provide 1:1 remote support to a participant.
     */
    remote_support?: boolean;
    /**
     * Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the user or not.
     */
    request_permission_to_unmute?: boolean;
    /**
     * Allow host and participants to share their screen or content during meetings
     *
     */
    screen_sharing?: boolean;
    /**
     * Share dual camera (deprecated).
     */
    share_dual_camera?: boolean;
    /**
     * Always show meeting controls during a meeting.
     */
    show_meeting_control_toolbar?: boolean;
    /**
     * Enable virtual background.
     */
    virtual_background?: boolean;
    /**
     * Settings to manage virtual background.
     */
    virtual_background_settings?: {
      /**
       * Allow user to upload custom backgrounds.
       */
      allow_upload_custom?: boolean;
      /**
       * Allow use of videos for virtual backgrounds.
       */
      allow_videos?: boolean;
      /**
       * Enable virtual background.
       */
      enable?: boolean;
      files?: Array<{
        /**
         * Unique identifier of the file.
         */
        id?: string;
        /**
         * Indicates whether or not this file is the default virtual background file.
         */
        is_default?: boolean;
        /**
         * File name.
         */
        name?: string;
        /**
         * File size.
         */
        size?: string;
        /**
         * File type.
         */
        type?: string;
      }>;
    };
    /**
     * Enable Waiting room - if enabled, attendees can only join after host approves.
     */
    waiting_room?: boolean;
    /**
     * Indicates who can share their screen or content during meetings. The value can be one of the following: <br>
     * `host`: Only host can share the screen.<br>
     * `all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
     *
     */
    who_can_share_screen?: 'host' | 'all';
    /**
     * Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>
     * `host`: Only a host can share the screen when someone else is sharing.<br>
     * `all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
     *
     */
    who_can_share_screen_when_someone_is_sharing?: 'host' | 'all';
    /**
     * Allow livestreaming by host through Workplace by Facebook.
     */
    workplace_by_facebook?: boolean;
  };
  profile?: {
    recording_storage_location?: {
      /**
       * Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.
       *
       * Provide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.
       */
      allowed_values?: Array<string>;
      /**
       * Abbreviated country code.
       */
      value?: string;
    };
  };
  recording?: {
    /**
     * Ask host to confirm the disclaimer.
     */
    ask_host_to_confirm_disclaimer?: boolean;
    /**
     * This field can be used if `recording_disclaimer` is set to true. This field indicates whether or not you would like to ask participants for consent when a recording starts. The value can be one of the following:<br>
     * * `true`: Ask participants for consent when a recording starts. <br>
     * * `false`: Do not ask participants for consent when a recording starts.
     */
    ask_participants_to_consent_disclaimer?: boolean;
    /**
     * Auto delete cloud recordings.
     */
    auto_delete_cmr?: boolean;
    /**
     * A specified number of days of auto delete cloud recordings.
     */
    auto_delete_cmr_days?: number;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` - Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Cloud recording.
     */
    cloud_recording?: boolean;
    /**
     * Host can pause/stop the auto recording in the cloud.
     */
    host_pause_stop_recording?: boolean;
    /**
     * Setting to allow cloud recording access only from specific IP address ranges.
     *
     */
    ip_address_access_control?: {
      /**
       * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
       *
       *
       */
      enable?: boolean;
      /**
       * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
       *
       * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
       *
       *
       */
      ip_addresses_or_ranges?: string;
    };
    /**
     * Local recording.
     */
    local_recording?: boolean;
    /**
     * Record an audio only file.
     */
    record_audio_file?: boolean;
    /**
     * Record the gallery view.
     */
    record_gallery_view?: boolean;
    /**
     * Record the active speaker view.
     */
    record_speaker_view?: boolean;
    /**
     * Audio transcript.
     */
    recording_audio_transcript?: boolean;
    /**
     * Show a disclaimer to participants before a recording starts
     *
     */
    recording_disclaimer?: boolean;
    /**
     * This object represents the minimum passcode requirements set for recordings via Account Recording Settings.
     */
    recording_password_requirement?: {
      /**
       * Indicates whether or not passcode must contain at least one alphabetical letter (a, b, c..).
       */
      have_letter?: boolean;
      /**
       * Indicates whether or not passcode must contain at least one number(1, 2, 3..).
       */
      have_number?: boolean;
      /**
       * Indicates whether or not passcode must contain at least one special character(!, @, #..).
       */
      have_special_character?: boolean;
      /**
       * Minimum required length for the passcode.
       */
      length?: number;
      /**
       * Indicates whether or not passcode must contain only numeric characters.
       */
      only_allow_numeric?: boolean;
    };
    /**
     * Save chat text from the meeting.
     */
    save_chat_text?: boolean;
    /**
     * Show timestamp on video.
     */
    show_timestamp?: boolean;
  };
  schedule_meeting?: {
    /**
     * Determine how participants can join the audio portion of the meeting:<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - Third party audio conference.
     */
    audio_type?: 'both' | 'telephony' | 'voip' | 'thirdParty';
    /**
     * Passcode for already scheduled meetings
     *
     */
    default_password_for_scheduled_meetings?: string;
    /**
     * If the value is set to `true`, the meeting passcode will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the passcode.
     *
     */
    embed_password_in_join_link?: boolean;
    /**
     * Require a passcode for personal meetings if attendees can join before host.
     */
    force_pmi_jbh_password?: boolean;
    /**
     * Start meetings with host video on.
     */
    host_video?: boolean;
    /**
     * Join the meeting before host arrives.
     */
    join_before_host?: boolean;
    /**
     * Account wide meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
     */
    meeting_password_requirement?: {
      consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
      /**
       * If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).
       *
       */
      have_letter?: boolean;
      /**
       * If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).
       */
      have_number?: boolean;
      /**
       * If set to `true`, the passcode must have at least 1 special character (!,@,#...).
       */
      have_special_character?: boolean;
      /**
       * If set to `true`, the passcode must include both uppercase and lowercase characters.
       */
      have_upper_and_lower_characters?: boolean;
      /**
       * The minimum length that the meeting/webinar passcode needs to have.
       */
      length?: number;
      /**
       * If set to `true`, the passcode must only contain numbers and no other characters.
       */
      only_allow_numeric?: boolean;
      /**
       * If set to `true`, users will be informed if the provided passcode is weak.
       */
      weak_enhance_detection?: boolean;
    };
    /**
     * Start meetings with participants video on.
     */
    participants_video?: boolean;
    /**
     * Personal Meeting Setting.<br><br>
     * `true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>
     * `false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.
     * For Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.
     *
     *
     *
     */
    personal_meeting?: boolean;
    /**
     * PMI passcode
     *
     */
    pmi_password?: string;
    /**
     * Generate and require passcode for participants joining by phone.
     */
    pstn_password_protected?: boolean;
    /**
     * Require a passcode for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
     *
     */
    require_password_for_instant_meetings?: boolean;
    /**
     * Require a passcode for Personal Meeting ID (PMI). This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
     *
     */
    require_password_for_pmi_meetings?: 'jbh_only' | 'all' | 'none';
    /**
     * Require a passcode for meetings which have already been scheduled
     *
     */
    require_password_for_scheduled_meetings?: boolean;
    /**
     * Require a passcode when scheduling new meetings.This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
     *
     */
    require_password_for_scheduling_new_meetings?: boolean;
    /**
     * Use Personal Meeting ID (PMI) when starting an instant meeting
     *
     */
    use_pmi_for_instant_meetings?: boolean;
    /**
     * Use Personal Meeting ID (PMI) when scheduling a meeting
     *
     */
    use_pmi_for_scheduled_meetings?: boolean;
  };
  telephony?: {
    /**
     * Third party audio conference info.
     */
    audio_conference_info?: string;
    /**
     * Show the international numbers link on the invitation email.
     */
    show_international_numbers_link?: boolean;
    /**
     * Indicates where most of the participants call into or call from duriing a meeting.
     */
    telephony_regions?: {
      /**
       * Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.
       */
      selection_values?: Array<string>;
    };
    /**
     * Third party audio conference.
     */
    third_party_audio?: boolean;
  };
  /**
   * Account Settings: TSP.
   */
  tsp?: {
    /**
     * Call Out
     */
    call_out?: boolean;
    /**
     * Call Out Countries/Regions
     */
    call_out_countries?: Array<unknown>;
    /**
     * Show international numbers link on the invitation email
     */
    show_international_numbers_link?: boolean;
  };
};

/**
 * The user update object represents a user on Zoom.
 */
export type UserUpdate = {
  /**
   * Kaltura user ID.
   */
  cms_user_id?: string;
  /**
   * User's company.
   */
  company?: string;
  /**
   * Custom attribute(s) of the user.
   */
  custom_attributes?: {
    /**
     * Identifier for the custom attribute.
     */
    key?: string;
    /**
     * Name of the custom attribute.
     */
    name?: string;
    /**
     * Value of the custom attribute.
     */
    value?: string;
  };
  /**
   * Department for user profile: use for report.
   */
  dept?: string;
  /**
   * User's first name. Cannot contain more than 5 Chinese characters.
   */
  first_name?: string;
  /**
   * Provide unique identifier of the group that you would like to add a [pending user](https://support.zoom.us/hc/en-us/articles/201363183-Managing-users#h_13c87a2a-ecd6-40ad-be61-a9935e660edb) to. The value of this field can be retrieved from [List Groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups) API.
   */
  group_id?: string;
  /**
   * Host key. It should be a 6-10 digit number.
   */
  host_key?: string;
  /**
   * User's job title.
   */
  job_title?: string;
  /**
   * language
   */
  language?: string;
  /**
   * User's last name. Cannot contain more than 5 Chinese characters.
   */
  last_name?: string;
  /**
   * User's location.
   */
  location?: string;
  /**
   * The manager for the user.
   */
  manager?: string;
  /**
   * **Note:** This field has been **deprecated** and will not be supported in the future. Use the **country** field of the **phone_numbers** object instead to select the country for the phone number.
   *
   *
   *
   * [Country ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) of the phone number. For example, if the phone number provided in the `phone_number` field is a Brazil based number, the value of the `phone_country` field should be `BR`.
   */
  phone_country?: string;
  /**
   * **Note:** This field has been **deprecated** and will not be supported in the future. Use the **phone_numbers** field instead to assign phone number(s) to a user.
   *
   *
   * Phone number of the user. To update a phone number, you must also provide the `phone_country` field.
   */
  phone_number?: string;
  phone_numbers?: {
    /**
     * Country code of the phone number. For example, for United States phone numbers, the value of this field should be "+1".
     */
    code?: string;
    /**
     * [Country ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) of the phone number. For example, if the phone number provided in the `number` field is a Brazil based number, the value of the `country` field should be `BR`.
     */
    country?: string;
    /**
     * Phone number of the user.
     */
    number?: string;
  };
  /**
   * Personal meeting ID: length must be 10.
   */
  pmi?: number;
  /**
   * The time zone ID for a user profile. For this parameter value please refer to the ID value in the [timezone](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) list.
   */
  timezone?: string;
  /**
   * User types:<br>`1` - Basic.<br>`2` - Licensed.<br>`3` - On-prem.<br>`99` - None (this can only be set with `ssoCreate`).
   */
  type?: 1 | 2 | 3 | 99;
  /**
   * Use Personal Meeting ID for instant meetings.
   */
  use_pmi?: boolean;
  /**
   * Personal meeting room name.
   */
  vanity_name?: string;
};

/**
 * Webinar object.
 */
export type Webinar = {
  /**
   * Webinar description.
   */
  agenda?: string;
  /**
   * Webinar duration (minutes). Used for scheduled webinars only.
   */
  duration?: number;
  /**
   * Webinar Passcode. Passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ *]. Max of 10 characters.
   */
  password?: string;
  /**
   * Recurrence object. Use this object only for a webinar of type `9` i.e., a recurring webinar with fixed time.
   */
  recurrence?: {
    /**
     * Select a date when the webinar will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the webinar will recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `3` to state which day in a month, the webinar should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the webinar to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the webinar to recur once every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `3` to state the week of the month when the webinar should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the webinar should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `3` to state a specific day in a week when the monthly webinar should recur. To use this field, you must also use the `monthly_week` field. <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the webinar should recur. For instance, if you would like to schedule a Webinar that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily webinar, the maximum interval you can set is `90` days. For a weekly webinar, the maximum interval that you can set is `12` weeks. For a monthly webinar, the maximum interval that you can set is `3` months.
     */
    repeat_interval?: number;
    /**
     * Recurrence webinar types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `2` to state which day(s) of the week the webinar should repeat. <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the Webinar should recur on Sunday, provide `"1"` as the value of this field.  <br><br> **Note:** If you would like the webinar to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the Webinar should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     *
     *
     */
    weekly_days?: string;
  };
  /**
   * Webinar settings.
   */
  settings?: {
    /**
     * Allow attendees to join from multiple devices.
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host emails or IDs. Multiple values separated by comma.
     */
    alternative_hosts?: string;
    /**
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Send reminder email to attendees and panelists.
     */
    attendees_and_panelists_reminder_email_notification?: {
      /**
       * * `true`: Send reminder email to attendees and panelists.
       *
       * * `false`: Do not send reminder email to attendees and panelists.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * Determine how participants can join the audio portion of the webinar.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
     */
    authentication_domains?: string;
    /**
     * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
     */
    authentication_name?: string;
    /**
     * Webinar authentication option id.
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Close registration after event date.
     */
    close_registration?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Set the email language to one of the following:
     * `en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.
     */
    email_language?: string;
    /**
     * Only signed in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.
     */
    enforce_login_domains?: string;
    /**
     * Send follow-up email to absentees.
     */
    follow_up_absentees_email_notification?: {
      /**
       * * `true`: Send follow-up email to absentees.
       *
       * * `false`: Do not send follow-up email to absentees.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * Send follow-up email to attendees.
     */
    follow_up_attendees_email_notification?: {
      /**
       * * `true`: Send follow-up email to attendees.
       *
       * * `false`: Do not send follow-up email to attendees.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Default to HD video.
     */
    hd_video?: boolean;
    /**
     * Start video when host joins webinar.
     */
    host_video?: boolean;
    /**
     * `true`- Only authenticated users can join Webinar.
     */
    meeting_authentication?: boolean;
    /**
     * Send notification email to registrants when the host updates a webinar.
     */
    notify_registrants?: boolean;
    /**
     * Make the webinar on-demand
     */
    on_demand?: boolean;
    /**
     * * `true`: Send invitation email to panelists.
     *
     * * `false`: Do not send invitation email to panelists.
     */
    panelists_invitation_email_notification?: boolean;
    /**
     * Start video when panelists join webinar.
     */
    panelists_video?: boolean;
    /**
     * Zoom will open a survey page in attendees' browsers after leaving the webinar
     */
    post_webinar_survey?: boolean;
    /**
     * Enable practice session.
     */
    practice_session?: boolean;
    /**
     * [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
     */
    question_and_answer?: {
      /**
       * * `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..
       *
       * * `false`: Do not allow anonymous questions.
       */
      allow_anonymous_questions?: boolean;
      /**
       * Indicate whether you want attendees to be able to view answered questions only or view all questions.
       *
       * * `only`: Attendees are able to view answered questions only.
       *
       * *  `all`: Attendees are able to view all questions submitted in the Q&A.
       */
      answer_questions?: 'only' | 'all';
      /**
       * * `true`: Attendees can answer questions or leave a comment in the question thread.
       *
       * * `false`: Attendees can not answer questions or leave a comment in the question thread
       */
      attendees_can_comment?: boolean;
      /**
       * * `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.
       *
       * * `false`: Attendees can not click the thumbs up butoon on questions.
       */
      attendees_can_upvote?: boolean;
      /**
       * * `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
       *
       * * `false`: Disable Q&A for webinar.
       */
      enable?: boolean;
    };
    /**
     * Send confirmation email to registrants
     */
    registrants_confirmation_email?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.
     */
    registrants_restrict_number?: number;
    /**
     * Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the registration page.
     */
    show_share_button?: boolean;
    /**
     * Survey url for post webinar survey
     */
    survey_url?: string;
  };
  /**
   * Webinar start time. We support two formats for `start_time` - local time and GMT.<br>
   *
   * To set time as GMT the format should be `yyyy-MM-dd`T`HH:mm:ssZ`.
   *
   * To set time using a specific timezone, use `yyyy-MM-dd`T`HH:mm:ss` format and specify the timezone [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) in the `timezone` field OR leave it blank and the timezone set on your Zoom account will be used. You can also set the time as UTC as the timezone field.
   *
   * The `start_time` should only be used for scheduled and / or recurring webinars with fixed time.
   */
  start_time?: string;
  /**
   * Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.
   */
  timezone?: string;
  /**
   * Webinar topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Tracking fields type
     */
    field?: string;
    /**
     * Tracking fields value
     */
    value?: string;
  }>;
  /**
   * Webinar Types:<br>`5` - Webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.
   */
  type?: 5 | 6 | 9;
};

/**
 * Webinar object.
 */
export type WebinarInfo = {
  /**
   * Webinar agenda.
   */
  agenda?: string;
  /**
   * Create time.
   */
  created_at?: string;
  /**
   * Webinar duration.
   */
  duration?: number;
  /**
   * URL to join the Webinar. This URL should only be shared with the users who should be invited to the Webinar.
   */
  join_url?: string;
  /**
   * Array of occurrence objects.
   */
  occurrences?: Array<{
    /**
     * Duration.
     */
    duration?: number;
    /**
     * Occurrence ID: Unique Identifier that identifies an occurrence of a recurring webinar. [Recurring webinars](https://support.zoom.us/hc/en-us/articles/216354763-How-to-Schedule-A-Recurring-Webinar) can have a maximum of 50 occurrences.
     */
    occurrence_id?: string;
    /**
     * Start time.
     */
    start_time?: string;
    /**
     * Occurrence status.
     */
    status?: string;
  }>;
  /**
   * Webinar passcode.
   *
   * If "Require a passcode when scheduling new meetings" setting has been **enabled** **and** [locked](https://support.zoom.us/hc/en-us/articles/115005269866-Using-Tiered-Settings#locked) for the user, the passcode field will be autogenerated for the Webinar in the response even if it is not provided in the API request. <br><br>
   * **Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the  [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API.
   *
   *
   *
   *
   *
   *
   */
  password?: string;
  /**
   * Recurrence object. Use this object only for a webinar of type `9` i.e., a recurring webinar with fixed time.
   */
  recurrence?: {
    /**
     * Select a date when the webinar will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the webinar will recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `3` to state which day in a month, the webinar should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the webinar to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the webinar to recur once every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `3` to state the week of the month when the webinar should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the webinar should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `3` to state a specific day in a week when the monthly webinar should recur. To use this field, you must also use the `monthly_week` field. <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the webinar should recur. For instance, if you would like to schedule a Webinar that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily webinar, the maximum interval you can set is `90` days. For a weekly webinar, the maximum interval that you can set is `12` weeks. For a monthly webinar, the maximum interval that you can set is `3` months.
     */
    repeat_interval?: number;
    /**
     * Recurrence webinar types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `2` to state which day(s) of the week the webinar should repeat. <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the Webinar should recur on Sunday, provide `"1"` as the value of this field.  <br><br> **Note:** If you would like the webinar to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the Webinar should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     *
     *
     */
    weekly_days?: string;
  };
  /**
   * Webinar settings.
   */
  settings?: {
    /**
     * Allow attendees to join from multiple devices.
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host emails or IDs. Multiple values separated by comma.
     */
    alternative_hosts?: string;
    /**
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Send reminder email to attendees and panelists.
     */
    attendees_and_panelists_reminder_email_notification?: {
      /**
       * * `true`: Send reminder email to attendees and panelists.
       *
       * * `false`: Do not send reminder email to attendees and panelists.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * Determine how participants can join the audio portion of the webinar.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
     */
    authentication_domains?: string;
    /**
     * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
     */
    authentication_name?: string;
    /**
     * Webinar authentication option id.
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Close registration after event date.
     */
    close_registration?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Set the email language to one of the following:
     * `en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.
     */
    email_language?: string;
    /**
     * Only signed in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.
     */
    enforce_login_domains?: string;
    /**
     * Send follow-up email to absentees.
     */
    follow_up_absentees_email_notification?: {
      /**
       * * `true`: Send follow-up email to absentees.
       *
       * * `false`: Do not send follow-up email to absentees.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * Send follow-up email to attendees.
     */
    follow_up_attendees_email_notification?: {
      /**
       * * `true`: Send follow-up email to attendees.
       *
       * * `false`: Do not send follow-up email to attendees.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Default to HD video.
     */
    hd_video?: boolean;
    /**
     * Start video when host joins webinar.
     */
    host_video?: boolean;
    /**
     * `true`- Only authenticated users can join Webinar.
     */
    meeting_authentication?: boolean;
    /**
     * Send notification email to registrants when the host updates a webinar.
     */
    notify_registrants?: boolean;
    /**
     * Make the webinar on-demand
     */
    on_demand?: boolean;
    /**
     * * `true`: Send invitation email to panelists.
     *
     * * `false`: Do not send invitation email to panelists.
     */
    panelists_invitation_email_notification?: boolean;
    /**
     * Start video when panelists join webinar.
     */
    panelists_video?: boolean;
    /**
     * Zoom will open a survey page in attendees' browsers after leaving the webinar
     */
    post_webinar_survey?: boolean;
    /**
     * Enable practice session.
     */
    practice_session?: boolean;
    /**
     * [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
     */
    question_and_answer?: {
      /**
       * * `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..
       *
       * * `false`: Do not allow anonymous questions.
       */
      allow_anonymous_questions?: boolean;
      /**
       * Indicate whether you want attendees to be able to view answered questions only or view all questions.
       *
       * * `only`: Attendees are able to view answered questions only.
       *
       * *  `all`: Attendees are able to view all questions submitted in the Q&A.
       */
      answer_questions?: 'only' | 'all';
      /**
       * * `true`: Attendees can answer questions or leave a comment in the question thread.
       *
       * * `false`: Attendees can not answer questions or leave a comment in the question thread
       */
      attendees_can_comment?: boolean;
      /**
       * * `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.
       *
       * * `false`: Attendees can not click the thumbs up butoon on questions.
       */
      attendees_can_upvote?: boolean;
      /**
       * * `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
       *
       * * `false`: Disable Q&A for webinar.
       */
      enable?: boolean;
    };
    /**
     * Send confirmation email to registrants
     */
    registrants_confirmation_email?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.
     */
    registrants_restrict_number?: number;
    /**
     * Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the registration page.
     */
    show_share_button?: boolean;
    /**
     * Survey url for post webinar survey
     */
    survey_url?: string;
  };
  /**
   * Webinar start time in GMT/UTC.
   */
  start_time?: string;
  /**
   * <br><aside>The <code>start_url</code> of a Webinar is a URL using which a host or an alternative host can start the Webinar. This URL should only be used by the host of the meeting and should not be shared with anyone other than the host of the Webinar.
   *
   * The expiration time for the <code>start_url</code> field listed in the response of [Create a Webinar API](https://marketplace.zoom.us/docs/api-reference/zoom-api/webinars/webinarcreate) is two hours for all regular users.
   *
   * For users created using the <code>custCreate</code> option via the [Create Users](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usercreate) API, the expiration time of the <code>start_url</code> field is 90 days.
   *
   * For security reasons, to retrieve the latest value for the <code>start_url</code> field programmatically (after expiry), you must call the [Retrieve a Webinar API](https://marketplace.zoom.us/docs/api-reference/zoom-api/webinars/webinar) and refer to the value of the <code>start_url</code> field in the response.</aside><br><br><br>
   */
  start_url?: string;
  /**
   * Time zone to format start_time.
   */
  timezone?: string;
  /**
   * Webinar topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Tracking fields type
     */
    field?: string;
    /**
     * Tracking fields value
     */
    value?: string;
  }>;
  /**
   * Webinar Types:<br>`5` - Webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.
   */
  type?: 5 | 6 | 9;
};

/**
 * List of webinars.
 */
export type WebinarInstances = {
  /**
   * List of ended webinar instances.
   */
  webinars?: Array<{
    /**
     * Start time.
     */
    start_time?: string;
    /**
     * Webinar UUID.
     */
    uuid?: string;
  }>;
};

/**
 * List of webinars.
 */
export type WebinarList = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of webinar objects.
   */
  webinars?: Array<{
    /**
     * Webinar Description. The length of agenda gets truncated to 250 characters when you list all webinars for a user. To view the complete agenda, retrieve details for a single webinar [here](https://marketplace.zoom.us/docs/api-reference/zoom-api/webinars/webinar).
     */
    agenda?: string;
    /**
     * Time of webinar creation.
     */
    created_at?: string;
    /**
     * Meeting duration.
     */
    duration?: number;
    /**
     * ID of the host of the webinar.
     */
    host_id?: string;
    /**
     * Webinar ID in "**long**" format(represented as int64 data type in JSON), also known as the webinar number.
     */
    id?: number;
    /**
     * Join URL of the webinar (using which others can join the webinar).
     */
    join_url?: string;
    /**
     * Scheduled start time of the Webinar.
     */
    start_time?: string;
    /**
     * [Timezone ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) for the Webinar.
     */
    timezone?: string;
    /**
     * Meeting topic.
     */
    topic?: string;
    /**
     * Webinar Types:<br>`5` - Webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.
     */
    type?: string;
    /**
     * Unique identifier of a Webinar. Each webinar instance will generate its own UUID. Once a Webinar ends, the value of uuid for the same webinar will be different from when it was scheduled.
     */
    uuid?: string;
  }>;
};

/**
 * Webinar metric details.
 */
export type WebinarMetric = {
  /**
   * Custom keys and values assigned to the Webinar.
   */
  custom_keys?: Array<{
    /**
     * Custom key associated with the Webinar.
     */
    key?: string;
    /**
     * Value of the custom key associated with the Webinar.
     */
    value?: string;
  }>;
  /**
   * Department of the host.
   */
  dept?: string;
  /**
   * Webinar duration, formatted as hh:mm:ss, for example: `10:00` for ten minutes.
   */
  duration?: string;
  /**
   * User email.
   */
  email?: string;
  /**
   * Webinar end time.
   */
  end_time?: string;
  /**
   * Indicates whether or not TSP was used for the Webinar.
   */
  has_3rd_party_audio?: boolean;
  /**
   * Indicates whether or not PSTN was used for the Webinar.
   */
  has_pstn?: boolean;
  /**
   * Indicates whether or not recording was used for the Webinar.
   */
  has_recording?: boolean;
  /**
   * Indicates whether or not screen sharing was used for the Webinar.
   */
  has_screen_share?: boolean;
  /**
   * Indicates whether or not SIP was used for the Webinar.
   */
  has_sip?: boolean;
  /**
   * Indicates whether or not video was used for the Webinar.
   */
  has_video?: boolean;
  /**
   * Indicates whether or not VoIP was used for the Webinar.
   */
  has_voip?: boolean;
  /**
   * User display name.
   */
  host?: string;
  /**
   * Webinar ID in "**long**" format(represented as int64 data type in JSON), also known as the webinar number.
   */
  id?: number;
  /**
   * Webinar participant count.
   */
  participants?: number;
  /**
   * Webinar start time.
   */
  start_time?: string;
  /**
   * Webinar topic.
   */
  topic?: string;
  /**
   * User type.
   */
  user_type?: string;
  /**
   * Webinar UUID.
   */
  uuid?: string;
};

/**
 * Webinar panelist.
 */
export type WebinarPanelist = {
  /**
   * List of panelist objects.
   */
  panelists?: Array<{
    /**
     * Panelist's email.
     */
    email?: string;
    /**
     * Panelist's full name.
     */
    name?: string;
  }>;
};

/**
 * Webinar panelist.
 */
export type WebinarPanelistList = {
  /**
   * List of panelist objects.
   */
  panelists?: Array<
    {
      /**
       * Panelist's ID.
       */
      id?: string;
    } & {
      /**
       * Panelist's email.
       */
      email?: string;
      /**
       * Panelist's full name.
       */
      name?: string;
    } & {
      /**
       * Join URL.
       */
      join_url?: string;
    }
  >;
  /**
   * Total records.
   */
  total_records?: number;
};

/**
 * Webinar registrant.
 */
export type WebinarRegistrant = {
  /**
   * Registrant's address.
   */
  address?: string;
  /**
   * Registrant's city.
   */
  city?: string;
  /**
   * A field that allows registrants to provide any questions or comments that they might have.
   */
  comments?: string;
  /**
   * Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.
   */
  country?: string;
  /**
   * Custom questions.
   */
  custom_questions?: Array<{
    title?: string;
    value?: string;
  }>;
  /**
   * A valid email address of the registrant.
   */
  email: string;
  /**
   * Registrant's first name.
   */
  first_name: string;
  /**
   * Registrant's Industry.
   */
  industry?: string;
  /**
   * Registrant's job title.
   */
  job_title?: string;
  /**
   * Registrant's last name.
   */
  last_name?: string;
  /**
   * Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`
   */
  no_of_employees?: string;
  /**
   * Registrant's Organization.
   */
  org?: string;
  /**
   * Registrant's Phone number.
   */
  phone?: string;
  /**
   * This field can be included to gauge interest of webinar attendees towards buying your product or service.
   *
   * Purchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`
   */
  purchasing_time_frame?: string;
  /**
   * Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved`
   */
  role_in_purchase_process?: string;
  /**
   * Registrant's State/Province.
   */
  state?: string;
  /**
   * Registrant's Zip/Postal Code.
   */
  zip?: string;
};

/**
 * List of users.
 */
export type WebinarRegistrantList = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of registrant objects.
   */
  registrants?: Array<
    {
      /**
       * Registrant ID.
       */
      id?: string;
    } & {
      /**
       * Registrant's address.
       */
      address?: string;
      /**
       * Registrant's city.
       */
      city?: string;
      /**
       * A field that allows registrants to provide any questions or comments that they might have.
       */
      comments?: string;
      /**
       * Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.
       */
      country?: string;
      /**
       * Custom questions.
       */
      custom_questions?: Array<{
        title?: string;
        value?: string;
      }>;
      /**
       * A valid email address of the registrant.
       */
      email: string;
      /**
       * Registrant's first name.
       */
      first_name: string;
      /**
       * Registrant's Industry.
       */
      industry?: string;
      /**
       * Registrant's job title.
       */
      job_title?: string;
      /**
       * Registrant's last name.
       */
      last_name?: string;
      /**
       * Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`
       */
      no_of_employees?: string;
      /**
       * Registrant's Organization.
       */
      org?: string;
      /**
       * Registrant's Phone number.
       */
      phone?: string;
      /**
       * This field can be included to gauge interest of webinar attendees towards buying your product or service.
       *
       * Purchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`
       */
      purchasing_time_frame?: string;
      /**
       * Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved`
       */
      role_in_purchase_process?: string;
      /**
       * Registrant's State/Province.
       */
      state?: string;
      /**
       * Registrant's Zip/Postal Code.
       */
      zip?: string;
    } & {
      /**
       * The time at which the registrant registered.
       */
      create_time?: string;
      /**
       * The URL using which an approved registrant can join the webinar.
       */
      join_url?: string;
      /**
       * The status of the registrant's registration. <br> `approved`: User has been successfully approved for the webinar.<br> `pending`:  The registration is still pending.<br> `denied`: User has been denied from joining the webinar.
       */
      status?: string;
    }
  >;
};

/**
 * Webinar Registrant Questions
 */
export type WebinarRegistrantQuestions = {
  /**
   * Array of Registrant Custom Questions.
   */
  custom_questions?: Array<{
    /**
     * An array of answer choices. Can't be used for short answer type.
     */
    answers?: Array<string>;
    /**
     * State whether or not the custom question is required to be answered by a registrant.
     */
    required?: boolean;
    /**
     * Custom question.
     */
    title?: string;
    /**
     * The question-answer type.
     */
    type?: 'short' | 'single_radio' | 'single_dropdown' | 'multiple';
  }>;
  /**
   * Array of registration fields whose values should be provided by registrants during registration.
   */
  questions?: Array<{
    /**
     * Field name
     */
    field_name?:
      | 'last_name'
      | 'address'
      | 'city'
      | 'country'
      | 'zip'
      | 'state'
      | 'phone'
      | 'industry'
      | 'org'
      | 'job_title'
      | 'purchasing_time_frame'
      | 'role_in_purchase_process'
      | 'no_of_employees'
      | 'comments';
    /**
     * State whether the selected fields are required or optional.
     */
    required?: boolean;
  }>;
};

/**
 * Webinar settings.
 */
export type WebinarSettings = {
  /**
   * Allow attendees to join from multiple devices.
   */
  allow_multiple_devices?: boolean;
  /**
   * Alternative host emails or IDs. Multiple values separated by comma.
   */
  alternative_hosts?: string;
  /**
   * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
   */
  approval_type?: 0 | 1 | 2;
  /**
   * Send reminder email to attendees and panelists.
   */
  attendees_and_panelists_reminder_email_notification?: {
    /**
     * * `true`: Send reminder email to attendees and panelists.
     *
     * * `false`: Do not send reminder email to attendees and panelists.
     */
    enable?: boolean;
    /**
     * `0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.
     */
    type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
  };
  /**
   * Determine how participants can join the audio portion of the webinar.
   */
  audio?: 'both' | 'telephony' | 'voip';
  /**
   * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
   */
  authentication_domains?: string;
  /**
   * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
   */
  authentication_name?: string;
  /**
   * Webinar authentication option id.
   */
  authentication_option?: string;
  /**
   * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
   */
  auto_recording?: 'local' | 'cloud' | 'none';
  /**
   * Close registration after event date.
   */
  close_registration?: boolean;
  /**
   * Contact email for registration
   */
  contact_email?: string;
  /**
   * Contact name for registration
   */
  contact_name?: string;
  /**
   * Set the email language to one of the following:
   * `en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.
   */
  email_language?: string;
  /**
   * Only signed in users can join this meeting.
   *
   * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.
   */
  enforce_login?: boolean;
  /**
   * Only signed in users with specified domains can join meetings.
   *
   * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.
   */
  enforce_login_domains?: string;
  /**
   * Send follow-up email to absentees.
   */
  follow_up_absentees_email_notification?: {
    /**
     * * `true`: Send follow-up email to absentees.
     *
     * * `false`: Do not send follow-up email to absentees.
     */
    enable?: boolean;
    /**
     * `0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
     */
    type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
  };
  /**
   * Send follow-up email to attendees.
   */
  follow_up_attendees_email_notification?: {
    /**
     * * `true`: Send follow-up email to attendees.
     *
     * * `false`: Do not send follow-up email to attendees.
     */
    enable?: boolean;
    /**
     * `0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
     */
    type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
  };
  /**
   * List of global dial-in countries
   */
  global_dial_in_countries?: Array<string>;
  /**
   * Default to HD video.
   */
  hd_video?: boolean;
  /**
   * Start video when host joins webinar.
   */
  host_video?: boolean;
  /**
   * `true`- Only authenticated users can join Webinar.
   */
  meeting_authentication?: boolean;
  /**
   * Send notification email to registrants when the host updates a webinar.
   */
  notify_registrants?: boolean;
  /**
   * Make the webinar on-demand
   */
  on_demand?: boolean;
  /**
   * * `true`: Send invitation email to panelists.
   *
   * * `false`: Do not send invitation email to panelists.
   */
  panelists_invitation_email_notification?: boolean;
  /**
   * Start video when panelists join webinar.
   */
  panelists_video?: boolean;
  /**
   * Zoom will open a survey page in attendees' browsers after leaving the webinar
   */
  post_webinar_survey?: boolean;
  /**
   * Enable practice session.
   */
  practice_session?: boolean;
  /**
   * [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
   */
  question_and_answer?: {
    /**
     * * `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..
     *
     * * `false`: Do not allow anonymous questions.
     */
    allow_anonymous_questions?: boolean;
    /**
     * Indicate whether you want attendees to be able to view answered questions only or view all questions.
     *
     * * `only`: Attendees are able to view answered questions only.
     *
     * *  `all`: Attendees are able to view all questions submitted in the Q&A.
     */
    answer_questions?: 'only' | 'all';
    /**
     * * `true`: Attendees can answer questions or leave a comment in the question thread.
     *
     * * `false`: Attendees can not answer questions or leave a comment in the question thread
     */
    attendees_can_comment?: boolean;
    /**
     * * `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.
     *
     * * `false`: Attendees can not click the thumbs up butoon on questions.
     */
    attendees_can_upvote?: boolean;
    /**
     * * `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
     *
     * * `false`: Disable Q&A for webinar.
     */
    enable?: boolean;
  };
  /**
   * Send confirmation email to registrants
   */
  registrants_confirmation_email?: boolean;
  /**
   * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
   */
  registrants_email_notification?: boolean;
  /**
   * Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.
   */
  registrants_restrict_number?: number;
  /**
   * Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.
   */
  registration_type?: 1 | 2 | 3;
  /**
   * Show social share buttons on the registration page.
   */
  show_share_button?: boolean;
  /**
   * Survey url for post webinar survey
   */
  survey_url?: string;
};

/**
 * Webinar object
 */
export type WebinarUpdate = {
  /**
   * Webinar description.
   */
  agenda?: string;
  /**
   * Webinar duration (minutes). Used for scheduled webinar only.
   */
  duration?: number;
  /**
   * [Webinar passcode](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords). By default, passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ * !] and can have a maximum of 10 characters.
   *
   * **Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the  [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API.
   *
   * If "**Require a passcode when scheduling new meetings**" setting has been **enabled** **and** [locked](https://support.zoom.us/hc/en-us/articles/115005269866-Using-Tiered-Settings#locked) for the user, the passcode field will be autogenerated for the Webinar in the response even if it is not provided in the API request. <br><br>
   *
   *
   *
   *
   *
   *
   *
   *
   */
  password?: string;
  /**
   * Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time.
   */
  recurrence?: {
    /**
     * Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
     *
     * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.
     *
     *
     */
    repeat_interval?: number;
    /**
     * Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    weekly_days?: '1' | '2' | '3' | '4' | '5' | '6' | '7';
  };
  settings?: {
    /**
     * Allow attendees to join from multiple devices.
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host emails or IDs. Multiple values separated by comma.
     */
    alternative_hosts?: string;
    /**
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Send reminder email to attendees and panelists.
     */
    attendees_and_panelists_reminder_email_notification?: {
      /**
       * * `true`: Send reminder email to attendees and panelists.
       *
       * * `false`: Do not send reminder email to attendees and panelists.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * Determine how participants can join the audio portion of the webinar.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
     */
    authentication_domains?: string;
    /**
     * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
     */
    authentication_name?: string;
    /**
     * Webinar authentication option id.
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Close registration after event date.
     */
    close_registration?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Set the email language to one of the following:
     * `en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.
     */
    email_language?: string;
    /**
     * Only signed in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the Webinar.
     */
    enforce_login_domains?: string;
    /**
     * Send follow-up email to absentees.
     */
    follow_up_absentees_email_notification?: {
      /**
       * * `true`: Send follow-up email to absentees.
       *
       * * `false`: Do not send follow-up email to absentees.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * Send follow-up email to attendees.
     */
    follow_up_attendees_email_notification?: {
      /**
       * * `true`: Send follow-up email to attendees.
       *
       * * `false`: Do not send follow-up email to attendees.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Default to HD video.
     */
    hd_video?: boolean;
    /**
     * Start video when host joins webinar.
     */
    host_video?: boolean;
    /**
     * `true`- Only authenticated users can join Webinar.
     */
    meeting_authentication?: boolean;
    /**
     * Send notification email to registrants when the host updates a webinar.
     */
    notify_registrants?: boolean;
    /**
     * Make the webinar on-demand
     */
    on_demand?: boolean;
    /**
     * * `true`: Send invitation email to panelists.
     *
     * * `false`: Do not send invitation email to panelists.
     */
    panelists_invitation_email_notification?: boolean;
    /**
     * Start video when panelists join webinar.
     */
    panelists_video?: boolean;
    /**
     * Zoom will open a survey page in attendees' browsers after leaving the webinar
     */
    post_webinar_survey?: boolean;
    /**
     * Enable practice session.
     */
    practice_session?: boolean;
    /**
     * [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
     */
    question_and_answer?: {
      /**
       * * `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..
       *
       * * `false`: Do not allow anonymous questions.
       */
      allow_anonymous_questions?: boolean;
      /**
       * Indicate whether you want attendees to be able to view answered questions only or view all questions.
       *
       * * `only`: Attendees are able to view answered questions only.
       *
       * *  `all`: Attendees are able to view all questions submitted in the Q&A.
       */
      answer_questions?: 'only' | 'all';
      /**
       * * `true`: Attendees can answer questions or leave a comment in the question thread.
       *
       * * `false`: Attendees can not answer questions or leave a comment in the question thread
       */
      attendees_can_comment?: boolean;
      /**
       * * `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.
       *
       * * `false`: Attendees can not click the thumbs up butoon on questions.
       */
      attendees_can_upvote?: boolean;
      /**
       * * `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
       *
       * * `false`: Disable Q&A for webinar.
       */
      enable?: boolean;
    };
    /**
     * Send confirmation email to registrants
     */
    registrants_confirmation_email?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.
     */
    registrants_restrict_number?: number;
    /**
     * Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the registration page.
     */
    show_share_button?: boolean;
    /**
     * Survey url for post webinar survey
     */
    survey_url?: string;
  } & {
    /**
     * Send confirmation email to registrants.
     */
    registrants_confirmation_email?: boolean;
  };
  /**
   * Webinar start time, in the format "yyyy-MM-dd'T'HH:mm:ss'Z'." Should be in GMT time. In the format "yyyy-MM-dd'T'HH:mm:ss." This should be in local time and the timezone should be specified. Only used for scheduled webinars and recurring webinars with a fixed time.
   */
  start_time?: string;
  /**
   * Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.
   */
  timezone?: string;
  /**
   * Webinar topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Tracking fields type
     */
    field?: string;
    /**
     * Tracking fields value
     */
    value?: string;
  }>;
  /**
   * Webinar Types:<br>`5` - webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.
   */
  type?: 5 | 6 | 9;
};

/**
 * Zoom room.
 */
export type ZoomRoom = {
  /**
   * Zoom room email type.
   */
  account_type?: string;
  /**
   * Zoom calendar name.
   */
  calender_name?: string;
  /**
   * Zoom room camera.
   */
  camera?: string;
  /**
   * Zoom room device IP.
   */
  device_ip?: string;
  /**
   * Zoom room email.
   */
  email?: string;
  health?: string;
  /**
   * Zoom room ID.
   */
  id?: string;
  /**
   * Zoom Room issues.
   */
  issues?: Array<string>;
  /**
   * Zoom room last start time.
   */
  last_start_time?: string;
  /**
   * Zoom room location.
   */
  location?: string;
  /**
   * Zoom room microphone.
   */
  microphone?: string;
  /**
   * Zoom room name.
   */
  room_name?: string;
  /**
   * Zoom room speaker.
   */
  speaker?: string;
  /**
   * Zoom room status.
   */
  status?: string;
};

/**
 * Zoom Room List
 */
export type ZoomRoomList = {
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * Array of Zoom Rooms
   */
  zoom_rooms?: Array<{
    /**
     * Zoom room email type.
     */
    account_type?: string;
    /**
     * Zoom calendar name.
     */
    calender_name?: string;
    /**
     * Zoom room camera.
     */
    camera?: string;
    /**
     * Zoom room device IP.
     */
    device_ip?: string;
    /**
     * Zoom room email.
     */
    email?: string;
    health?: string;
    /**
     * Zoom room ID.
     */
    id?: string;
    /**
     * Zoom Room issues.
     */
    issues?: Array<string>;
    /**
     * Zoom room last start time.
     */
    last_start_time?: string;
    /**
     * Zoom room location.
     */
    location?: string;
    /**
     * Zoom room microphone.
     */
    microphone?: string;
    /**
     * Zoom room name.
     */
    room_name?: string;
    /**
     * Zoom room speaker.
     */
    speaker?: string;
    /**
     * Zoom room status.
     */
    status?: string;
  }>;
};

export type authenticationusersettings =
  | {
      /**
       * Meeting Authentication Options
       */
      authentication_option?: {
        /**
         * Specify the action that you would like to take via this API request:<br>
         * * `add` : Choose this value if you are adding an authentication option.
         * * `update`: Choose this value if you are updating an existing authentication option.
         * * `delete`: Choose this value if you are deleting an existing authentication option.
         */
        action?: 'update' | 'delete' | 'add';
        /**
         * Specify whether you would like to set this authentication option as the default option or not.
         */
        default_option?: boolean;
        /**
         * If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to join your meetings or webinars.
         */
        domains?: string;
        /**
         *  Authentication ID. You can get the ID from Get User Settings API with query parameter `option` set to `meeting_authentication`.<br><br>
         * Use this field or the `name` field to identify the associated authentication option that you would like to update.
         */
        id?: string;
        /**
         * Unique name for the authentication option.
         */
        name?: string;
        /**
         *  Authentication type. Specify one of the following authentication types for the authentication profile:<br>
         * * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.
         * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.
         */
        type?: 'enforce_login' | 'enforce_login_with_domains';
      };
      /**
       * If set to "true", only authenticated users can join meetings. The method for authentication can be defined in the "authentication_option".
       */
      meeting_authentication?: boolean;
    }
  | {
      /**
       * Specify the authentication options for this account.
       */
      authentication_option?: {
        /**
         * Specify the action that you would like to take via this API request:<br>
         *
         * * `update`: Choose this value if you are updating an existing authentication option.
         * * `show` : Choose this value if you would like this option to be one of the authentication options that the host can use for sharing the recording settings.
         * * `hide`:  Choose this value if you would like this option to not be made available to the host for recording sharing settings.
         */
        action?: 'update' | 'delete' | 'add';
        /**
         * Specify whether you would like to set this authentication option as the default option or not.
         */
        default_option?: boolean;
        /**
         * If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to view the recordings.
         */
        domains?: string;
        /**
         *  Authentication ID. You can get the ID from Get User Settings API with query parameter `option` set to `recording_authentication`.<br><br>
         *
         * Use this field or the `name` field to identify the associated authentication option that you would like to update or delete.
         */
        id?: string;
        /**
         * Unique name for the authentication option.
         */
        name?: string;
        /**
         * Specify one authentication type that is to be associated with this authentication configuration:<br>
         * * `internally`: This option allows you specify a rule that only signed in users within your account can view the recording.<br>
         * * `enforce_login`: This option allows any users to view the recording, as long as they are signed into their Zoom account.<br>
         * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can view the recording. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.
         *
         *
         */
        type?: 'internally' | 'enforce_login' | 'enforce_login_with_domains';
      };
      /**
       * If set to `true`, only authenticated users can view the cloud recordings.<br><br>
       * The authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).
       */
      recording_authentication?: boolean;
    };

/**
 *  Authentication type. Specify one of the following authentication types for the authentication profile:<br>
 * * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.
 * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.
 */
export type type8 = 'enforce_login' | 'enforce_login_with_domains';

/**
 * Base webinar object for sessions.
 */
export type create_webinar = {
  /**
   * Webinar description.
   */
  agenda?: string;
  /**
   * Webinar duration (minutes). Used for scheduled webinars only.
   */
  duration?: number;
  /**
   * Webinar passcode. Passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ * !]. Max of 10 characters.
   *
   * If "Require a passcode when scheduling new meetings" setting has been **enabled** **and** [locked](https://support.zoom.us/hc/en-us/articles/115005269866-Using-Tiered-Settings#locked) for the user, the passcode field will be autogenerated for the Webinar in the response even if it is not provided in the API request. <br><br>
   *
   * **Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API.
   *
   *
   *
   *
   */
  password?: string;
  /**
   * Recurrence object. Use this object only for a webinar of type `9` i.e., a recurring webinar with fixed time.
   */
  recurrence?: {
    /**
     * Select a date when the webinar will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the webinar will recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `3` to state which day in a month, the webinar should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the webinar to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the webinar to recur once every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `3` to state the week of the month when the webinar should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the webinar should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `3` to state a specific day in a week when the monthly webinar should recur. To use this field, you must also use the `monthly_week` field. <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the webinar should recur. For instance, if you would like to schedule a Webinar that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily webinar, the maximum interval you can set is `90` days. For a weekly webinar, the maximum interval that you can set is `12` weeks. For a monthly webinar, the maximum interval that you can set is `3` months.
     */
    repeat_interval?: number;
    /**
     * Recurrence webinar types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * Use this field **only if you're scheduling a recurring webinar of type** `2` to state which day(s) of the week the webinar should repeat. <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the Webinar should recur on Sunday, provide `"1"` as the value of this field.  <br><br> **Note:** If you would like the webinar to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the Webinar should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     *
     *
     */
    weekly_days?: string;
  };
  /**
   * Create Webinar settings.
   */
  settings?: {
    /**
     * Allow attendees to join from multiple devices.
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host emails or IDs. Multiple values separated by comma.
     */
    alternative_hosts?: string;
    /**
     * The default value is `2`. To enable registration required, set the approval type to `0` or `1`.  Values include:<br>
     *
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Send reminder email to attendees and panelists.
     */
    attendees_and_panelists_reminder_email_notification?: {
      /**
       * * `true`: Send reminder email to attendees and panelists.
       *
       * * `false`: Do not send reminder email to attendees and panelists.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 hour before webinar.<br>`2` - Send 1 day before webinar.<br>`3` - Send 1 hour and 1 day before webinar.<br>`4` - Send 1 week before webinar.<br>`5` - Send 1 hour and 1 week before webinar.<br>`6` - Send 1 day and 1 week before webinar.<br>`7` - Send 1 hour, 1 day and 1 week before webinar.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * Determine how participants can join the audio portion of the meeting.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * Meeting authentication domains. This option, allows you to specify the rule so that Zoom users, whose email address contains a certain domain, can join the Webinar. You can either provide multiple domains, using a comma in between and/or use a wildcard for listing domains.
     */
    authentication_domains?: string;
    /**
     * Specify the authentication type for users to join a Webinar with`meeting_authentication` setting set to `true`. The value of this field can be retrieved from the `id` field within `authentication_options` array in the response of [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings).
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Close registration after event date.
     */
    close_registration?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Set the email language to one of the following:
     * `en-US`,`de-DE`,`es-ES`,`fr-FR`,`jp-JP`,`pt-PT`,`ru-RU`,`zh-CN`, `zh-TW`, `ko-KO`, `it-IT`, `vi-VN`.
     */
    email_language?: string;
    /**
     * Only signed-in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in future.** <br><br> Instead of this field, use the "meeting_authentication", "authentication_option" and/or "authentication_domains" fields to establish the authentication mechanism for this Webinar.
     */
    enforce_login?: boolean;
    /**
     * Only signed-in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in future.** <br><br> Instead of this field, use the "authentication_domains" field for this Webinar.
     */
    enforce_login_domains?: string;
    /**
     * Send follow-up email to absentees.
     */
    follow_up_absentees_email_notification?: {
      /**
       * * `true`: Send follow-up email to absentees.
       *
       * * `false`: Do not send follow-up email to absentees.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 days after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * Send follow-up email to attendees.
     */
    follow_up_attendees_email_notification?: {
      /**
       * * `true`: Send follow-up email to attendees.
       *
       * * `false`: Do not send follow-up email to attendees.
       */
      enable?: boolean;
      /**
       * `0` - No plan.<br>`1` - Send 1 day after the scheduled end date.<br>`2` - Send 2 days after the scheduled end date.<br>`3` - Send 3 days after the scheduled end date.<br>`4` - Send 4 days after the scheduled end date.<br>`5` - Send 5 days after the scheduled end date.<br>`6` - Send 6 days after the scheduled end date.<br>`7` - Send 7 days after the scheduled end date.
       */
      type?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    };
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Default to HD video.
     */
    hd_video?: boolean;
    /**
     * Start video when host joins webinar.
     */
    host_video?: boolean;
    /**
     * Only [authenticated](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) users can join meeting if the value of this field is set to `true`.
     */
    meeting_authentication?: boolean;
    /**
     * Make the webinar on-demand
     */
    on_demand?: boolean;
    /**
     * * `true`: Send invitation email to panelists.
     *
     * * `false`: Do not send invitation email to panelists.
     */
    panelists_invitation_email_notification?: boolean;
    /**
     * Start video when panelists join webinar.
     */
    panelists_video?: boolean;
    /**
     * Zoom will open a survey page in attendees' browsers after leaving the webinar
     */
    post_webinar_survey?: boolean;
    /**
     * Enable practice session.
     */
    practice_session?: boolean;
    /**
     * [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
     */
    question_and_answer?: {
      /**
       * * `true`: Allow participants to send questions without providing their name to the host, co-host, and panelists..
       *
       * * `false`: Do not allow anonymous questions.
       */
      allow_anonymous_questions?: boolean;
      /**
       * Indicate whether you want attendees to be able to view answered questions only or view all questions.
       *
       * * `only`: Attendees are able to view answered questions only.
       *
       * *  `all`: Attendees are able to view all questions submitted in the Q&A.
       */
      answer_questions?: 'only' | 'all';
      /**
       * * `true`: Attendees can answer questions or leave a comment in the question thread.
       *
       * * `false`: Attendees can not answer questions or leave a comment in the question thread
       */
      attendees_can_comment?: boolean;
      /**
       * * `true`: Attendees can click the thumbs up button to bring popular questions to the top of the Q&A window.
       *
       * * `false`: Attendees can not click the thumbs up butoon on questions.
       */
      attendees_can_upvote?: boolean;
      /**
       * * `true`: Enable [Q&A](https://support.zoom.us/hc/en-us/articles/203686015-Using-Q-A-as-the-webinar-host#:~:text=Overview,and%20upvote%20each%20other's%20questions.) for webinar.
       *
       * * `false`: Disable Q&A for webinar.
       */
      enable?: boolean;
    };
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Restrict number of registrants for a webinar. By default, it is set to `0`. A `0` value means that the restriction option is disabled. Provide a number higher than 0 to restrict the webinar registrants by the that number.
     */
    registrants_restrict_number?: number;
    /**
     * Registration types. Only used for recurring webinars with a fixed time.<br>`1` - Attendees register once and can attend any of the webinar sessions.<br>`2` - Attendees need to register for each session in order to attend.<br>`3` - Attendees register once and can choose one or more sessions to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the registration page.
     */
    show_share_button?: boolean;
    /**
     * Survey url for post webinar survey
     */
    survey_url?: string;
  };
  /**
   * Webinar start time. We support two formats for `start_time` - local time and GMT.<br>
   *
   * To set time as GMT the format should be `yyyy-MM-dd`T`HH:mm:ssZ`.
   *
   * To set time using a specific timezone, use `yyyy-MM-dd`T`HH:mm:ss` format and specify the timezone [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) in the `timezone` field OR leave it blank and the timezone set on your Zoom account will be used. You can also set the time as UTC as the timezone field.
   *
   * The `start_time` should only be used for scheduled and / or recurring webinars with fixed time.
   */
  start_time?: string;
  /**
   * Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [timezone](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#timezones) list for supported time zones and their formats.
   */
  timezone?: string;
  /**
   * Webinar topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Tracking fields type
     */
    field: string;
    /**
     * Tracking fields value
     */
    value?: string;
  }>;
  /**
   * Webinar Types:<br>`5` - Webinar.<br>`6` - Recurring webinar with no fixed time.<br>`9` - Recurring webinar with a fixed time.
   */
  type?: 5 | 6 | 9;
};

/**
 * Meeting metric details.
 */
export type listmeetingmetrics = {
  /**
   * Custom keys and values assigned to the meeting.
   */
  custom_keys?: Array<{
    /**
     * Custom key associated with the meeting.
     */
    key?: string;
    /**
     * Value of the custom key associated with the meeting.
     */
    value?: string;
  }>;
  /**
   * Department of the host.
   */
  dept?: string;
  /**
   * Meeting duration. Formatted as hh:mm:ss, for example: `16:08` for 16 minutes and 8 seconds.
   */
  duration?: string;
  /**
   * Email address of the host.
   */
  email?: string;
  /**
   * Meeting end time.
   */
  end_time?: string;
  /**
   * Indicates whether or not [third party audio](https://support.zoom.us/hc/en-us/articles/202470795-3rd-Party-Audio-Conference) was used in the meeting.
   */
  has_3rd_party_audio?: boolean;
  /**
   * Indicates whether or not the PSTN was used in the meeting.
   */
  has_pstn?: boolean;
  /**
   * Indicates whether or not the recording feature was used in the meeting.
   */
  has_recording?: boolean;
  /**
   * Indicates whether or not screenshare feature was used in the meeting.
   */
  has_screen_share?: boolean;
  /**
   * Indicates whether or not someone joined the meeting using SIP.
   */
  has_sip?: boolean;
  /**
   * Indicates whether or not video was used in the meeting.
   */
  has_video?: boolean;
  /**
   * Indicates whether or not VoIP was used in the meeting.
   */
  has_voip?: boolean;
  /**
   * Host display name.
   */
  host?: string;
  /**
   * [Meeting ID](https://support.zoom.us/hc/en-us/articles/201362373-What-is-a-Meeting-ID-): Unique identifier of the meeting in "**long**" format(represented as int64 data type in JSON), also known as the meeting number.
   */
  id?: number;
  /**
   * The number of Zoom Room participants in the meeting.
   */
  in_room_participants?: number;
  /**
   * Meeting participant count.
   */
  participants?: number;
  /**
   * Meeting start time.
   */
  start_time?: string;
  /**
   * Meeting topic.
   */
  topic?: string;
  /**
   * Tracking fields and values assigned to the meeting.
   */
  tracking_fields?: Array<{
    /**
     * Label of the tracking field.
     */
    field?: string;
    /**
     * Value of the tracking field.
     */
    value?: string;
  }>;
  /**
   * License type of the user.
   */
  user_type?: string;
  /**
   * Meeting UUID. Please double encode your UUID when using it for API calls if the UUID begins with a '/'or contains '//' in it.
   */
  uuid?: string;
};

/**
 * Recurrence object. Use this object only for a webinar of type `9` i.e., a recurring webinar with fixed time.
 */
export type recurrence_webinar = {
  /**
   * Select a date when the webinar will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
   */
  end_date_time?: string;
  /**
   * Select how many times the webinar will recur before it is canceled. (Cannot be used with "end_date_time".)
   */
  end_times?: number;
  /**
   * Use this field **only if you're scheduling a recurring webinar of type** `3` to state which day in a month, the webinar should recur. The value range is from 1 to 31.
   *
   * For instance, if you would like the webinar to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the webinar to recur once every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
   */
  monthly_day?: number;
  /**
   * Use this field **only if you're scheduling a recurring webinar of type** `3` to state the week of the month when the webinar should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the webinar should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
   */
  monthly_week?: -1 | 1 | 2 | 3 | 4;
  /**
   * Use this field **only if you're scheduling a recurring webinar of type** `3` to state a specific day in a week when the monthly webinar should recur. To use this field, you must also use the `monthly_week` field. <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
   */
  monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
  /**
   * Define the interval at which the webinar should recur. For instance, if you would like to schedule a Webinar that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
   *
   * For a daily webinar, the maximum interval you can set is `90` days. For a weekly webinar, the maximum interval that you can set is `12` weeks. For a monthly webinar, the maximum interval that you can set is `3` months.
   */
  repeat_interval?: number;
  /**
   * Recurrence webinar types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
   */
  type: 1 | 2 | 3;
  /**
   * Use this field **only if you're scheduling a recurring webinar of type** `2` to state which day(s) of the week the webinar should repeat. <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the Webinar should recur on Sunday, provide `"1"` as the value of this field.  <br><br> **Note:** If you would like the webinar to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the Webinar should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
   *
   * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
   *
   *
   */
  weekly_days?: string;
};

export type tsp_global_dial_in = {
  /**
   * The global dial-in URL for a TSP enabled account. The URL must be valid with a max-length of 512 characters.
   */
  audio_url?: string;
};

/**
 * The account ID.
 */
export type ParameterAccountId = string;

/**
 * The device ID.
 */
export type ParameterDeviceId = string;

/**
 * Feedback Detail Id
 */
export type ParameterFeedbackId = string;

/**
 * Start date in 'yyyy-mm-dd' format. The date range defined by the "from" and "to" parameters should only be one month as the report includes only one month worth of data at once.
 */
export type ParameterFromDate = string;

/**
 * The group ID.<br>
 * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
 */
export type ParameterGroupId = string;

/**
 * `0` - Facebook.<br>`1` - Google.<br>`99` - API.<br>`100` - Zoom.<br>`101` - SSO.
 */
export type ParameterLoginType = '0' | '1' | '99' | '100' | '101';

/**
 * Query Metadata of Recording if an On-Premise Meeting Connector was used for the meeting.
 */
export type ParameterMc = string;

/**
 * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
 *
 * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
 */
export type ParameterMeetingId = number;

/**
 * The meeting ID or the meeting UUID.  If a meeting ID is provided in the request instead of a UUID, the response will be for the latest meeting instance.
 *
 * If a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875==\"), you must **double encode** the UUID before making an API request.
 */
export type ParameterMeetingId4Metrics = string;

/**
 * To get Cloud Recordings of a meeting, provide the meeting ID or meeting UUID. If the meeting ID is provided instead of UUID,the response will be for the latest meeting instance.
 *
 * To get Cloud Recordings of a webinar, provide the webinar ID or the webinar UUID. If the webinar ID is provided instead of UUID,the response will be for the latest webinar instance.
 *
 * If a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875=="), you must **double encode** the UUID before making an API request.
 */
export type ParameterMeetingId4Recording = string;

/**
 * The meeting ID or UUID.
 */
export type ParameterMeetingIdNumber = string;

/**
 * The meeting types: <br>`scheduled` - This includes all valid past meetings (unexpired), live meetings and upcoming scheduled meetings. It is equivalent to the combined list of "Previous Meetings" and "Upcoming Meetings" displayed in the user's [Meetings page](https://zoom.us/meeting) on the Zoom Web Portal.<br>`live` - All the ongoing meetings.<br>`upcoming` - All upcoming meetings including live meetings.
 */
export type ParameterMeetingType = 'scheduled' | 'live' | 'upcoming';

/**
 * Specify a value to get the response for the corresponding meeting type. The value of this field can be one of the following:<br> <br>`past` - Meeting that already occurred in the specified date range.<br>`pastOne` - Past meetings that were attended by only one user. <br>`live` - Live meetings.<br><br>
 *
 * If you do not provide this field, the default value will be `live` and thus, the API will only query responses for live meetings.
 */
export type ParameterMeetingTypePast = 'past' | 'pastOne' | 'live';

/**
 * The meeting types: <br>`past` - Past meetings.<br>`live` - Live Meetings.
 */
export type ParameterMeetingTypePast2 = 'past' | 'pastOne' | 'live';

/**
 * The meeting types: <br>`past` - Past meetings.<br>`pastOne` - Past one user meetings.<br>`live` - Live meetings.
 */
export type ParameterMeetingTypePast3 = 'past' | 'pastOne' | 'live';

/**
 * The meeting UUID. Each meeting instance will generate its own Meeting UUID (i.e., after a meeting ends, a new UUID will be generated for the next instance of the meeting). Please double encode your UUID when using it for other API calls if the UUID begins with a '/'or contains '//' in it.
 */
export type ParameterMeetingUUID = string;

/**
 * The member ID.
 */
export type ParameterMemberId = string;

/**
 * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
 */
export type ParameterNextPageToken = string;

/**
 * The meeting occurrence ID.
 */
export type ParameterOccurrenceId = string;

/**
 *
 * **Deprecated** - This field has been deprecated and we will stop supporting it completely in a future release. Please use "next_page_token" for pagination instead of this field.
 *
 * The page number of the current page in the returned records.
 */
export type ParameterPageNumber = number;

/**
 * The number of records returned within a single API call.
 */
export type ParameterPageSize = number;

/**
 * The number of items returned per page.
 */
export type ParameterPageSize4Qos = number;

/**
 * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceed the current page size. The expiration period for this token is 15 minutes.
 */
export type ParameterPageToken = string;

/**
 * Participant ID.
 */
export type ParameterParticipantId = string;

/**
 * The recording delete actions:<br>`trash` - Move recording to trash.<br>`delete` - Delete recording permanently.
 */
export type ParameterRecordingDeleteAction = 'trash' | 'delete';

/**
 * The recording ID.
 */
export type ParameterRecordingId = string;

/**
 * The registrant ID.
 */
export type ParameterRegistrantId = string;

/**
 * The registrant status:<br>`pending` - Registrant's status is pending.<br>`approved` - Registrant's status is approved.<br>`denied` - Registrant's status is denied.
 */
export type ParameterRegistrantStatus = 'pending' | 'approved' | 'denied';

/**
 * The role ID
 */
export type ParameterRoleId = string;

/**
 * IM chat session ID.
 */
export type ParameterSessionId = string;

/**
 * TSP account ID.
 */
export type ParameterTSPId = 1 | 2;

/**
 * End date.
 */
export type ParameterToDate = string;

/**
 * The tracking source ID for the registrants. Useful if you share the webinar registration page in multiple locations. See [Creating source tracking links for webinar registration](https://support.zoom.us/hc/en-us/articles/360000315683-Creating-source-tracking-links-for-webinar-registration) for details.
 */
export type ParameterTrackingSourceId = string;

/**
 * Transfer email.
 */
export type ParameterTransferEmail = string;

/**
 * Transfer meeting.
 */
export type ParameterTransferMeeting = boolean;

/**
 * Transfer recording.
 */
export type ParameterTransferRecording = boolean;

/**
 * Transfer webinar.
 */
export type ParameterTransferWebinar = boolean;

/**
 * Query trash.
 * `true`: List recordings from trash.<br> `false`: Do not list recordings from the trash.<br> The default value is `false`. If you set it to `true`, you can use the `trash_type` property to indicate the type of Cloud recording that you need to retrieve.
 */
export type ParameterTrash = boolean;

/**
 * The user ID or email address of the user. For user-level apps, pass `me` as the value for userId.
 */
export type ParameterUserId = string;

/**
 * The webhook ID.
 */
export type ParameterWebhookId = string;

/**
 * The webinar ID in "**long**" format(represented as int64 data type in JSON).
 */
export type ParameterWebinarId = number;

/**
 * The webinar ID or the webinar UUID.  If a webinar ID is provided in the request instead of a UUID, the response will be for the latest webinar instance.
 *
 * If a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875==\"), you must **double encode** the UUID before making an API request.
 */
export type ParameterWebinarId4Metrics = string;

/**
 * The webinar type.
 */
export type ParameterWebinarTypePast = 'past' | 'live';

/**
 * The webinar type.
 */
export type ParameterWebinarTypePast2 = 'past' | 'live';

/**
 * The Webinar UUID. Each Webinar instance will generate its own Webinar UUID (i.e., after a Webinar ends, a new UUID will be generated for the next instance of the Webinar). Please double encode your UUID when using it for API calls if the UUID begins with a '/' or contains '//' in it.
 */
export type ParameterWebinarUUID = string;

/**
 * The Zoom room ID.
 */
export type ParameterZoomRoomId = string;

/**
 * The type of Cloud recording that you would like to retrieve from the trash. The value can be one of the following:<br>
 * `meeting_recordings`: List all meeting recordings from the trash.<br>
 * `recording_file`: List all individual recording files from the trash.
 */
export type Parametertrash_type = string;

export type AccountsData = {
  query?: {
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     *
     * **Deprecated** - This field has been deprecated and we will stop supporting it completely in a future release. Please use "next_page_token" for pagination instead of this field.
     *
     * The page number of the current page in the returned records.
     */
    page_number?: number;
    /**
     * The number of records returned within a single API call.
     */
    page_size?: number;
  };
};

export type AccountsResponse = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of Account objects.
   */
  accounts?: Array<{
    /**
     * Account name.
     */
    account_name?: string;
    /**
     * Account Number of the account.
     */
    account_number?: string;
    /**
     * Account type.
     */
    account_type?: string;
    /**
     * Account creation date and time.
     */
    created_at?: string;
    /**
     * Account ID.
     */
    id?: string;
    /**
     * Account owner email.
     */
    owner_email?: string;
    /**
     * Account seats.
     */
    seats?: number;
    /**
     * Account subscription end date and time.
     */
    subscription_end_time?: string;
    /**
     * Account subscription start date and time.
     */
    subscription_start_time?: string;
  }>;
};

export type AccountsError = unknown;

export type AccountCreateData = {
  /**
   * Account.
   */
  body: {
    /**
     * Name of the account. If you do not provide a value for this field, by default, the value will be set as a concatenation of "first_name" and "last_name".
     */
    account_name?: string;
    /**
     * User's email address.
     */
    email: string;
    /**
     * User's first name.
     */
    first_name: string;
    /**
     * User's last name.
     */
    last_name: string;
    /**
     * Account options object.
     */
    options?: {
      /**
       * Toggle whether automatic billing renewal is on or off.
       */
      billing_auto_renew?: boolean;
      /**
       * Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.
       *
       *
       * **Note:** This option can only be used if the value of `share_mc` is set to `true`.
       */
      meeting_connector_list?: Array<string>;
      /**
       * Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.
       */
      pay_mode?: 'master' | 'sub';
      /**
       * Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.
       *
       *
       * **Note:** This option can only be used if the value of `share_rc` is set to `true`.
       */
      room_connector_list?: Array<string>;
      /**
       * Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.
       */
      share_mc?: boolean;
      /**
       * Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.
       */
      share_rc?: boolean;
    };
    /**
     * User's password.
     *
     * **Note:** If the account owner or admin has enabled [enhanced password requirements](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_fa9186e4-6818-4f7a-915c-2e25c19f0acd), the value provided in this field must meet those requirements. These requirements can be retrieved by calling the [Get Account Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) and referring to the `password_requirement` field present in the `security` object.
     */
    password: string;
  };
};

export type AccountCreateResponse = {
  /**
   * Account created date time.
   */
  created_at?: string;
  /**
   * Account ID.
   */
  id?: string;
  /**
   * Account owner email.
   */
  owner_email?: string;
  /**
   * Account owner ID.
   */
  owner_id?: string;
};

export type AccountCreateError = unknown;

export type AccountDisassociateData = {
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
};

export type AccountDisassociateResponse = any;

export type AccountDisassociateError = unknown;

export type AccountData = {
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
};

export type AccountResponse = {
  /**
   * Account creation date and time.
   */
  created_at?: string;
  /**
   * Account ID.
   */
  id?: string;
  /**
   * Account options object.
   */
  options?: {
    /**
     * Toggle whether automatic billing renewal is on or off.
     */
    billing_auto_renew?: boolean;
    /**
     * Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.
     *
     *
     * **Note:** This option can only be used if the value of `share_mc` is set to `true`.
     */
    meeting_connector_list?: Array<string>;
    /**
     * Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.
     */
    pay_mode?: 'master' | 'sub';
    /**
     * Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.
     *
     *
     * **Note:** This option can only be used if the value of `share_rc` is set to `true`.
     */
    room_connector_list?: Array<string>;
    /**
     * Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.
     */
    share_mc?: boolean;
    /**
     * Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.
     */
    share_rc?: boolean;
  };
  /**
   * Account owner email.
   */
  owner_email?: string;
  /**
   * Account owner ID.
   */
  owner_id?: string;
  /**
   * Account Vanity URL
   */
  vanity_url?: string;
};

export type AccountError = unknown;

export type AccountBillingData = {
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
};

export type AccountBillingResponse = {
  /**
   * Billing Contact's address.
   */
  address: string;
  /**
   * Billing Contact's apartment/suite.
   */
  apt?: string;
  /**
   * Billing Contact's city.
   */
  city: string;
  /**
   * Billing Contact's Country [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) in abbreviated format.
   */
  country: string;
  /**
   * Billing Contact's email address.
   */
  email: string;
  /**
   * Billing Contact's first name.
   */
  first_name: string;
  /**
   * Billing Contact's last name.
   */
  last_name: string;
  /**
   * Billing Contact's phone number.
   */
  phone_number: string;
  /**
   * Billing Contact's state.
   */
  state: string;
  /**
   * Billing Contact's zip/postal code.
   */
  zip: string;
};

export type AccountBillingError = unknown;

export type AccountBillingUpdateData = {
  body: {
    /**
     * Billing Contact's address.
     */
    address?: string;
    /**
     * Billing Contact's apartment/suite.
     */
    apt?: string;
    /**
     * Billing Contact's city.
     */
    city?: string;
    /**
     * Billing Contact's country.
     */
    country?: string;
    /**
     * Billing Contact's email address.
     */
    email?: string;
    /**
     * Billing Contact's first name.
     */
    first_name?: string;
    /**
     * Billing Contact's last name.
     */
    last_name?: string;
    /**
     * Billing Contact's phone number.
     */
    phone_number?: string;
    /**
     * Billing Contact's state.
     */
    state?: string;
    /**
     * Billing Contact's zip/postal code.
     */
    zip?: string;
  };
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
};

export type AccountBillingUpdateResponse = unknown | any;

export type AccountBillingUpdateError = unknown;

export type AccountBillingInvoicesData = {
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
  query?: {
    /**
     * Start date for the invoice query in `yyyy-mm-dd` format. The date range defined by the “from” and “to” parameters should not exceed one year. The range defined should fall within the past three years.
     *
     */
    from?: string;
    /**
     * End date for the invoice query in `yyyy-mm-dd` format
     */
    to?: string;
  };
};

export type AccountBillingInvoicesResponse = {
  /**
   * Currency used in the invoice.
   */
  currency?: string;
  invoices?: Array<{
    /**
     * The remaining balance of the invoice after all payments, adjustments, and refunds are applied.
     *
     *
     */
    balance?: number;
    /**
     * The date by which the payment for this invoice is due.
     *
     *
     */
    due_date?: string;
    /**
     * Unique identifier of the invoice.
     */
    id?: string;
    /**
     * The date when the invoice was generated.
     *
     */
    invoice_date?: string;
    /**
     * Invoice number.
     */
    invoice_number?: string;
    /**
     * Status of the invoice.
     */
    status?: string;
    /**
     * This date is used to determine which charges are to be billed. All charges that are to be billed on this date or prior will be included in the invoice.
     *
     */
    target_date?: string;
    /**
     * Tax amount.
     */
    tax_amount?: number;
    /**
     * Total invoice amount.
     */
    total_amount?: number;
  }>;
};

export type AccountBillingInvoicesError = unknown;

export type GetAccountBillingInvoiceData = {
  path: {
    /**
     * The account ID.
     */
    accountId: string;
    /**
     * The invoice ID.
     */
    invoiceId: string;
  };
};

export type GetAccountBillingInvoiceResponse = {
  /**
   * The remaining balance of the invoice after all payments, adjustments, and refunds are applied.
   *
   *
   */
  balance?: number;
  /**
   * Billing currency.
   */
  currency?: string;
  /**
   * The date by which the payment for this invoice is due.
   *
   *
   */
  due_date?: string;
  /**
   * Unique identifier of the invoice.
   */
  id?: string;
  /**
   * The date when the invoice was generated.
   *
   */
  invoice_date?: string;
  invoice_items?: Array<{
    /**
     * Description for the charge.
     */
    charge_name?: string;
    /**
     * Identifier for the charge.
     */
    charge_number?: string;
    /**
     * Charge type.
     */
    charge_type?: string;
    /**
     * Billing end date.
     */
    end_date?: string;
    /**
     * Quantity.
     */
    quantity?: number;
    /**
     * Billing start date.
     */
    start_date?: string;
    /**
     * Tax amount.
     */
    tax_amount?: number;
    /**
     * Total amount.
     */
    total_amount?: number;
  }>;
  /**
   * Invoice number.
   */
  invoice_number?: string;
  /**
   * Status of the invoice.
   */
  status?: string;
  /**
   * This date is used to determine which charges are to be billed. All charges that are to be billed on this date or prior will be included in the invoice.
   *
   */
  target_date?: string;
  /**
   * Tax amount.
   */
  tax_amount?: number;
  /**
   * Total invoice amount.
   */
  total_amount?: number;
};

export type GetAccountBillingInvoiceError = unknown;

export type GetAccountLockSettingsData = {
  path: {
    /**
     * Unique Identifier of the account. To retrieve locked settings of the master account or a regular account, provide "me" as the value of this field. <br> To retrieve locked settings of a sub account, provide the Account ID of the sub account in this field.
     */
    accountId: string;
  };
  query?: {
    /**
     * Provide the name of the field by which you would like to filter the response. For example, if you provide "host_video" as the value of this field, you will get a response similar to the following:<br>
     * {
     * "schedule_meeting": {
     * "host_video": false
     * }
     * }
     * <br>You can provide multiple values by separating them with commas(example: "host_video,participant_video”).
     */
    custom_query_fields?: string;
    /**
     * `meeting_security`: Use this query parameter to view meeting security settings applied on the account.<br>
     */
    option?: string;
  };
};

export type GetAccountLockSettingsResponse =
  | {
      email_notification?: {
        /**
         * Notify the alternative host who is set or removed.
         */
        alternative_host_reminder?: boolean;
        /**
         * Notify host and participants when the meeting is cancelled.
         */
        cancel_meeting_reminder?: boolean;
        /**
         * Notify host when cloud recording is available.
         */
        cloud_recording_available_reminder?: boolean;
        /**
         * Notify host when participants join the meeting before them.
         */
        jbh_reminder?: boolean;
        /**
         * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
         */
        schedule_for_host_reminder?: boolean;
      };
      in_meeting?: {
        /**
         * Allow participants who belong to your account to see that a guest (someone who does not belong to your account) is participating in the meeting/webinar.
         */
        alert_guest_join?: boolean;
        /**
         * Show Zoom windows during screen share.
         */
        allow_show_zoom_windows?: boolean;
        /**
         * Allow participants to use annotation tools to add information to shared screens.
         */
        annotation?: boolean;
        anonymous_question_answer?: boolean;
        /**
         * Allow host to put attendee on hold.
         *
         * **This field has been deprecated and is no longer supported.**
         */
        attendee_on_hold?: boolean;
        /**
         * Enable users to see and add contacts to 'auto-answer group' in the contact list on chat. Any call from members of this group will be automatically answered.
         */
        auto_answer?: boolean;
        /**
         * Automatically save all in-meeting chats.
         */
        auto_saving_chat?: boolean;
        /**
         * Allow host to split meeting participants into separate, smaller rooms.
         */
        breakout_room?: boolean;
        /**
         * Allow meeting participants to send chat message visible to all participants.
         */
        chat?: boolean;
        /**
         * Allow host to type closed captions or assign a participant/third party device to add closed captions.
         */
        closed_caption?: boolean;
        /**
         * Allow the host to add co-hosts. Co-hosts have the same in-meeting controls as the host.
         */
        co_host?: boolean;
        /**
         * Displays whether or not custom [data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) have been selected for meetings/webinars hosted by the account.
         */
        custom_data_center_regions?: boolean;
        /**
         * Enable DSCP marking for signaling and media packets. (Default is 56 for audio, 40 for video, and 40 for signaling.)
         */
        dscp_marking?: boolean;
        /**
         * Require that all meetings are encrypted using AES.
         */
        e2e_encryption?: boolean;
        /**
         * Play sound when participants join or leave.
         */
        entry_exit_chime?: string;
        /**
         * Allow another user to take control of the camera during a meeting.
         */
        far_end_camera_control?: boolean;
        /**
         * Enable users to provide feedback to Zoom at the end of the meeting.
         */
        feedback?: boolean;
        /**
         * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for all users on the account or not.
         */
        file_transfer?: boolean;
        /**
         * Enable higher quality video for host and participants. This will require more bandwidth.
         */
        group_hd?: boolean;
        /**
         * Allow users to select original sound during a meeting.
         */
        original_audio?: boolean;
        /**
         * Add 'Polls' to the meeting controls. This allows the host to survey the attendees.
         */
        polling?: boolean;
        /**
         * Display end-of-meeting experience feedback survey.
         */
        post_meeting_feedback?: boolean;
        /**
         * Allow meeting participants to send a private 1:1 message to another participant.
         */
        private_chat?: boolean;
        /**
         * During screen sharing, allow the person who is sharing to let others control the shared content.
         */
        remote_control?: boolean;
        /**
         * Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option is enabled and locked for the account or not.
         */
        request_permission_to_unmute?: boolean;
        /**
         * Allow host and participants to share their screen or content during meetings.
         */
        screen_sharing?: boolean;
        /**
         * Allow users to invite participants by email only by default.
         */
        sending_default_email_invites?: boolean;
        /**
         * Always show meeting controls during a meeting.
         */
        show_meeting_control_toolbar?: boolean;
        /**
         * Allow users to select stereo audio during a meeting.
         */
        stereo_audio?: boolean;
        /**
         * Allow  HTML formatting instead of plain text for meeting invitations scheduled with the Outlook plugin.
         */
        use_html_format_email?: boolean;
        /**
         * Enable virtual background.
         */
        virtual_background?: boolean;
        /**
         * Allow attendees to ask questions for the host and panelists to answer in the webinar.
         */
        webinar_question_answer?: boolean;
        /**
         * Allow participants to share a whiteboard that includes annotation tools.
         */
        whiteboard?: boolean;
      };
      recording?: {
        /**
         * Make cloud recordings accessible to account members only.
         */
        account_user_access_recording?: boolean;
        /**
         * Allow Zoom to automatically delete recordings permanently after a specified number of days.
         */
        auto_delete_cmr?: boolean;
        /**
         * Record meetings automatically as they start.
         */
        auto_recording?: string;
        /**
         * Allow hosts to record and save the meeting / webinar in the cloud.
         */
        cloud_recording?: boolean;
        /**
         * Allow anyone with a link to the cloud recording to download.
         */
        cloud_recording_download?: boolean;
        /**
         * Allow the host to delete the recordings. If this option is disabled, the recordings cannot be deleted by the host and only admin can delete them.
         */
        host_delete_cloud_recording?: boolean;
        /**
         * Setting to allow cloud recording access only from specific IP address ranges.
         *
         */
        ip_address_access_control?: {
          /**
           * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
           *
           *
           */
          enable?: boolean;
          /**
           * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
           *
           * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
           *
           *
           */
          ip_addresses_or_ranges?: string;
        };
        /**
         * Allow hosts and participants to record the meeting to a local file.
         */
        local_recording?: boolean;
        /**
         * If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.
         *
         *
         */
        prevent_host_access_recording?: boolean;
        /**
         * Only authenticated users can view cloud recordings
         */
        recording_authentication?: string;
      };
      schedule_meeting?: {
        /**
         * Determine how participants can join the audio portion of the meeting.
         */
        audio_type?: boolean;
        /**
         * If the value is set to `true`, the meeting password will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the password.
         *
         */
        embed_password_in_join_link?: boolean;
        /**
         * Allow only signed-in users to join meetings.
         *
         */
        enforce_login?: boolean;
        /**
         * Specify the domains from which users can join a meeting.
         *
         */
        enforce_login_domains?: string;
        /**
         * Allow only signed-in users with specified domains to join meetings.
         *
         */
        enforce_login_with_domains?: boolean;
        /**
         * Start meetings with host video on.
         */
        host_video?: boolean;
        /**
         * Allow participants to join the meeting before the host arrives
         */
        join_before_host?: boolean;
        /**
         * Only authenticated users can join meetings
         */
        meeting_authentication?: boolean;
        /**
         * Hide actual meeting topic and display "Zoom Meeting" for your scheduled meetings
         */
        not_store_meeting_topic?: boolean;
        /**
         * Start meetings with participant video on.
         */
        participant_video?: boolean;
        /**
         * Require password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
         */
        require_password_for_instant_meetings?: boolean;
        /**
         * Require participants to enter password for PMI meetings. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
         */
        require_password_for_pmi_meetings?: boolean;
        /**
         * This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
         */
        require_password_for_scheduling_new_meetings?: boolean;
      };
      telephony?: {
        telephony_regions?: boolean;
        /**
         * Allow users to join the meeting using the existing 3rd party audio configuration.
         */
        third_party_audio?: boolean;
      };
      tsp?: {
        call_out?: boolean;
        show_international_numbers_link?: boolean;
      };
    }
  | {
      meeting_security?: {
        /**
         * `true`: Require that all meetings are secured with at least one security option.
         *
         * This setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).
         */
        auto_security?: boolean;
        /**
         * If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.
         *
         */
        embed_password_in_join_link?: boolean;
        /**
         * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
         * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
         *
         * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
         */
        encryption_type?: 'enhanced_encryption' | 'e2ee';
        /**
         * Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.
         */
        end_to_end_encrypted_meetings?: boolean;
        /**
         * If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.
         */
        meeting_password?: boolean;
        /**
         * Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
         */
        meeting_password_requirement?: {
          consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
          /**
           * If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).
           *
           */
          have_letter?: boolean;
          /**
           * If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).
           */
          have_number?: boolean;
          /**
           * If set to `true`, the passcode must have at least 1 special character (!,@,#...).
           */
          have_special_character?: boolean;
          /**
           * If set to `true`, the passcode must include both uppercase and lowercase characters.
           */
          have_upper_and_lower_characters?: boolean;
          /**
           * The minimum length that the meeting/webinar passcode needs to have.
           */
          length?: number;
          /**
           * If set to `true`, the passcode must only contain numbers and no other characters.
           */
          only_allow_numeric?: boolean;
          /**
           * If set to `true`, users will be informed if the provided passcode is weak.
           */
          weak_enhance_detection?: boolean;
        };
        /**
         * Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.
         */
        phone_password?: boolean;
        /**
         * If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.
         *
         */
        pmi_password?: boolean;
        /**
         * Require a passcode for meetings which have already been scheduled.
         *
         */
        require_password_for_scheduled_meeting?: boolean;
        /**
         * Require a passcode for webinars which have already been scheduled.
         *
         */
        require_password_for_scheduled_webinar?: boolean;
        /**
         * When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.
         *
         */
        waiting_room?: boolean;
        /**
         * Specify the settings to be applied if waiting room is enabled.
         */
        waiting_room_settings?: {
          /**
           *
           *
           * Specify who should be admitted to the waiting room. The value of this field can be one of the following:<br>
           * `0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in
           */
          participants_to_place_in_waiting_room?: 0 | 1 | 2;
          /**
           * Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>
           * `0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).
           *
           *
           *
           */
          users_who_can_admit_participants_from_waiting_room?: number;
          /**
           * If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").
           */
          whitelisted_domains_for_waiting_room?: string;
        };
        /**
         * If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.
         *
         */
        webinar_password?: boolean;
      };
    };

export type GetAccountLockSettingsError = unknown;

export type UpdateAccountLockSettingsData = {
  body?:
    | {
        email_notification?: {
          /**
           * Notify the alternative host who is set or removed.
           */
          alternative_host_reminder?: boolean;
          /**
           * Notify host and participants when the meeting is cancelled.
           */
          cancel_meeting_reminder?: boolean;
          /**
           * Notify host when cloud recording is available.
           */
          cloud_recording_available_reminder?: boolean;
          /**
           * Notify host when participants join the meeting before them.
           */
          jbh_reminder?: boolean;
          /**
           * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
           */
          schedule_for_host_reminder?: boolean;
        };
        in_meeting?: {
          /**
           * Allow participants who belong to your account to see that a guest (someone who does not belong to your account) is participating in the meeting/webinar.
           */
          alert_guest_join?: boolean;
          /**
           * Show Zoom windows during screen share.
           */
          allow_show_zoom_windows?: boolean;
          /**
           * Allow participants to use annotation tools to add information to shared screens.
           */
          annotation?: boolean;
          anonymous_question_answer?: boolean;
          /**
           * Allow host to put attendee on hold.
           *
           * **This field has been deprecated and is no longer supported.**
           */
          attendee_on_hold?: boolean;
          /**
           * Enable users to see and add contacts to 'auto-answer group' in the contact list on chat. Any call from members of this group will be automatically answered.
           */
          auto_answer?: boolean;
          /**
           * Automatically save all in-meeting chats.
           */
          auto_saving_chat?: boolean;
          /**
           * Allow host to split meeting participants into separate, smaller rooms.
           */
          breakout_room?: boolean;
          /**
           * Allow meeting participants to send chat message visible to all participants.
           */
          chat?: boolean;
          /**
           * Allow host to type closed captions or assign a participant/third party device to add closed captions.
           */
          closed_caption?: boolean;
          /**
           * Allow the host to add co-hosts. Co-hosts have the same in-meeting controls as the host.
           */
          co_host?: boolean;
          /**
           * If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field in the account settings. If set to `false`, the regions cannot be customized and the default regions will be used.
           */
          custom_data_center_regions?: boolean;
          /**
           * Allow users to select stereo audio during a meeting.
           */
          dscp_marking?: boolean;
          /**
           * Require that all meetings are encrypted using AES.
           */
          e2e_encryption?: boolean;
          /**
           * Play sound when participants join or leave.
           */
          entry_exit_chime?: string;
          /**
           * Allow another user to take control of the camera during a meeting.
           */
          far_end_camera_control?: boolean;
          /**
           * Enable users to provide feedback to Zoom at the end of the meeting.
           */
          feedback?: boolean;
          /**
           * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for all users on the account or not.
           */
          file_transfer?: boolean;
          /**
           * Enable higher quality video for host and participants. This will require more bandwidth.
           */
          group_hd?: boolean;
          /**
           * Allow users to select original sound during a meeting.
           */
          original_audio?: boolean;
          /**
           * Add 'Polls' to the meeting controls. This allows the host to survey the attendees.
           */
          polling?: boolean;
          /**
           * Display end-of-meeting experience feedback survey.
           */
          post_meeting_feedback?: boolean;
          /**
           * Allow meeting participants to send a private 1:1 message to another participant.
           */
          private_chat?: boolean;
          /**
           * During screen sharing, allow the person who is sharing to let others control the shared content.
           */
          remote_control?: boolean;
          /**
           * Indicate whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option should be enabled and locked for the account or not.
           */
          request_permission_to_unmute?: boolean;
          /**
           * Allow host and participants to share their screen or content during meetings.
           */
          screen_sharing?: boolean;
          /**
           * Allow users to invite participants by email only by default.
           */
          sending_default_email_invites?: boolean;
          /**
           * Always show meeting controls during a meeting.
           */
          show_meeting_control_toolbar?: boolean;
          /**
           * Allow users to select stereo audio during a meeting.
           */
          stereo_audio?: boolean;
          /**
           * Allow  HTML formatting instead of plain text for meeting invitations scheduled with the Outlook plugin.
           */
          use_html_format_email?: boolean;
          /**
           * Enable virtual background.
           */
          virtual_background?: boolean;
          webinar_question_answer?: boolean;
          /**
           * Allow participants to share a whiteboard that includes annotation tools.
           */
          whiteboard?: boolean;
        };
        recording?: {
          /**
           * Make cloud recordings accessible to account members only.
           */
          account_user_access_recording?: boolean;
          /**
           * Allow Zoom to automatically delete recordings permanently after a specified number of days.
           */
          auto_delete_cmr?: boolean;
          /**
           * Record meetings automatically as they start.
           */
          auto_recording?: string;
          /**
           * Allow hosts to record and save the meeting / webinar in the cloud.
           */
          cloud_recording?: boolean;
          /**
           * Allow anyone with a link to the cloud recording to download.
           */
          cloud_recording_download?: boolean;
          /**
           * Allow the host to delete the recordings. If this option is disabled, the recordings cannot be deleted by the host and only admin can delete them.
           */
          host_delete_cloud_recording?: boolean;
          /**
           * Setting to allow cloud recording access only from specific IP address ranges.
           *
           */
          ip_address_access_control?: {
            /**
             * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
             *
             *
             */
            enable?: boolean;
            /**
             * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
             *
             * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
             *
             *
             */
            ip_addresses_or_ranges?: string;
          };
          /**
           * Allow hosts and participants to record the meeting to a local file.
           */
          local_recording?: boolean;
          /**
           * If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.
           *
           *
           */
          prevent_host_access_recording?: boolean;
          recording_authentication?: string;
        };
        schedule_meeting?: {
          /**
           * Determine how participants can join the audio portion of the meeting.
           */
          audio_type?: boolean;
          /**
           * If the value is set to `true`, the meeting password will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the password.
           *
           */
          embed_password_in_join_link?: boolean;
          /**
           * Participants must always sign in before joining the scheduled meeting.
           */
          enforce_login?: boolean;
          enforce_login_domains?: string;
          enforce_login_with_domains?: boolean;
          /**
           * Start meetings with host video on.
           */
          host_video?: boolean;
          /**
           * Allow participants to join the meeting before the host arrives
           */
          join_before_host?: boolean;
          meeting_authentication?: boolean;
          not_store_meeting_topic?: boolean;
          /**
           * Start meetings with participant video on.
           */
          participant_video?: boolean;
          /**
           * Turn the lock setting on or off for the **Enable Personal Meeting ID** setting for an entire account.<br><br>
           * `true`: Turn the **"Enable Personal Meeting ID"** setting **on** for all users in the account. Users can choose to use personal meeting ID for their meetings. <br><br>
           * `false`: Turn **off** the **"Enable Personal Meeting ID"** setting. **If this setting is [disabled](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link?flash_digest=eb7ac62d8c7fb4daf285916e3e15d87537806133#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a), meetings that were scheduled with PMI by the users in the account will be invalid. Users will have to update previously scheduled PMI meetings.**<br><br>
           * For Zoom Phone only: If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.
           *
           *
           *
           */
          personal_meeting?: boolean;
          /**
           * Require password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
           */
          require_password_for_instant_meetings?: boolean;
          /**
           * Require participants to enter password for PMI meetings. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
           */
          require_password_for_pmi_meetings?: boolean;
          /**
           * This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
           */
          require_password_for_scheduling_new_meetings?: boolean;
        };
        telephony?: {
          telephony_regions?: boolean;
          /**
           * Allow users to join the meeting using the existing 3rd party audio configuration.
           */
          third_party_audio?: boolean;
        };
        tsp?: {
          call_out?: boolean;
          show_international_numbers_link?: boolean;
        };
      }
    | {
        meeting_security?: {
          /**
           * `true`: Require that all meetings are secured with at least one security option.
           *
           * This setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).
           */
          auto_security?: boolean;
          /**
           * If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.
           *
           */
          embed_password_in_join_link?: boolean;
          /**
           * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
           * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
           *
           * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
           */
          encryption_type?: 'enhanced_encryption' | 'e2ee';
          /**
           * Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.
           */
          end_to_end_encrypted_meetings?: boolean;
          /**
           * If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.
           */
          meeting_password?: boolean;
          /**
           * Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
           */
          meeting_password_requirement?: {
            consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
            /**
             * If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).
             *
             */
            have_letter?: boolean;
            /**
             * If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).
             */
            have_number?: boolean;
            /**
             * If set to `true`, the passcode must have at least 1 special character (!,@,#...).
             */
            have_special_character?: boolean;
            /**
             * If set to `true`, the passcode must include both uppercase and lowercase characters.
             */
            have_upper_and_lower_characters?: boolean;
            /**
             * The minimum length that the meeting/webinar passcode needs to have.
             */
            length?: number;
            /**
             * If set to `true`, the passcode must only contain numbers and no other characters.
             */
            only_allow_numeric?: boolean;
            /**
             * If set to `true`, users will be informed if the provided passcode is weak.
             */
            weak_enhance_detection?: boolean;
          };
          /**
           * Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.
           */
          phone_password?: boolean;
          /**
           * If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.
           *
           */
          pmi_password?: boolean;
          /**
           * Require a passcode for meetings which have already been scheduled.
           *
           */
          require_password_for_scheduled_meeting?: boolean;
          /**
           * Require a passcode for webinars which have already been scheduled.
           *
           */
          require_password_for_scheduled_webinar?: boolean;
          /**
           * When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.
           *
           */
          waiting_room?: boolean;
          /**
           * Specify the settings to be applied if waiting room is enabled.
           */
          waiting_room_settings?: {
            /**
             *
             *
             * Specify who should be admitted to the waiting room. The value of this field can be one of the following:<br>
             * `0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in
             */
            participants_to_place_in_waiting_room?: 0 | 1 | 2;
            /**
             * Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>
             * `0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).
             *
             *
             *
             */
            users_who_can_admit_participants_from_waiting_room?: number;
            /**
             * If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").
             */
            whitelisted_domains_for_waiting_room?: string;
          };
          /**
           * If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.
           *
           */
          webinar_password?: boolean;
        };
      };
  path: {
    /**
     * Unique Identifier of the account. To retrieve locked settings of the master account or a regular account, provide "me" as the value of this field. <br> To retrieve locked settings of a sub account, provide the Account ID of the sub account in this field.
     */
    accountId: string;
  };
};

export type UpdateAccountLockSettingsResponse =
  | unknown
  | {
      [key: string]: unknown;
    };

export type UpdateAccountLockSettingsError = unknown;

export type AccountManagedDomainData = {
  path: {
    /**
     * Unique Identifier of the account. To retrieve locked settings of the master account or a regular account, provide "me" as the value of this field. <br> To retrieve locked settings of a sub account, provide the Account ID of the sub account in this field.
     */
    accountId: string;
  };
};

export type AccountManagedDomainResponse = {
  /**
   * List of managed domain objects.
   */
  domains?: Array<{
    /**
     * Domain name.
     */
    domain?: string;
    /**
     * Domain status.
     */
    status?: string;
  }>;
  /**
   * Total records.
   */
  total_records?: number;
};

export type AccountManagedDomainError = unknown;

export type AccountOptionsUpdateData = {
  body: {
    /**
     * Toggle whether automatic billing renewal is on or off.
     */
    billing_auto_renew?: boolean;
    /**
     * Specify the IP addresses of the Meeting Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Meeting Connectors of a master account will be shared with the sub account.
     *
     *
     * **Note:** This option can only be used if the value of `share_mc` is set to `true`.
     */
    meeting_connector_list?: Array<string>;
    /**
     * Payee:<br>`master` - master account holder pays.<br>`sub` - Sub account holder pays.
     */
    pay_mode?: 'master' | 'sub';
    /**
     * Specify the IP addresses of the Room Connectors that you would like to share with the sub account. Multiple values can be separated by comma. If no value is provided in this field, all the Room Connectors of a master account will be shared with the sub account.
     *
     *
     * **Note:** This option can only be used if the value of `share_rc` is set to `true`.
     */
    room_connector_list?: Array<string>;
    /**
     * Enable/disable the option for a sub account to use shared [Meeting Connector(s)](https://support.zoom.us/hc/en-us/articles/201363093-Getting-Started-with-the-Meeting-Connector) that are set up by the master account. Meeting Connectors can only be used by On-prem users.
     */
    share_mc?: boolean;
    /**
     * Enable/disable the option for a sub account to use shared [Virtual Room Connector(s)](https://support.zoom.us/hc/en-us/articles/202134758-Getting-Started-With-Virtual-Room-Connector) that are set up by the master account. Virtual Room Connectors can only be used by On-prem users.
     */
    share_rc?: boolean;
  };
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
};

export type AccountOptionsUpdateResponse = unknown | any;

export type AccountOptionsUpdateError = unknown;

export type UpdateAccountOwnerData = {
  body?: {
    /**
     * Email address of the new owner.
     */
    email: string;
  };
  path: {
    /**
     * Account Id of the account.
     */
    accountId: string;
  };
};

export type UpdateAccountOwnerResponse = unknown;

export type UpdateAccountOwnerError = unknown;

export type UpdatePhoneSettingsData = {
  body?: {
    byoc?: {
      /**
       * Set the value of this field to `true` to allow a sub account to add BYOC numbers from the Zoom web admin portal.
       */
      enable?: boolean;
    };
  };
  path: {
    /**
     * Unique identifier of the sub account.
     */
    accountId: string;
  };
};

export type UpdatePhoneSettingsResponse = unknown;

export type UpdatePhoneSettingsError = unknown;

export type SetUpAccountData = {
  body?: {
    /**
     * Specify emergency address for the account.
     */
    emergency_address: {
      /**
       * Specify the street address.
       */
      address_line1: string;
      /**
       * Specify any building number, floor number, or unit number.
       */
      address_line2?: string;
      /**
       * City of the emergency address. Required or optional dependent on different countries.
       */
      city?: string;
      /**
       * Specify the two letter [country code](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) (Alpha-2 code in ISO-3166).
       */
      country: string;
      /**
       * State code of the emergency address. Required or optional dependent on the country and state.
       */
      state_code?: string;
      /**
       * Zip code of the emergency address. Required or optional dependent on different countries.
       */
      zip?: string;
    };
    /**
     * Specify extension number that will be associated with the owner of the account.
     */
    extension_number: string;
  };
  path: {
    /**
     * Unique identifier of the account.
     */
    accountId: string;
  };
};

export type SetUpAccountResponse = unknown;

export type SetUpAccountError = unknown;

export type PostPhoneSipTrunkData = {
  body?: {
    /**
     * SIP trunk configurations.
     */
    sip_trunks?: Array<{
      /**
       * The account associated to the carrier.
       */
      carrier_account?: string;
      /**
       * Unique identifier of the master account's SIP trunk.
       */
      id?: string;
      /**
       * The name of the SIP Trunk. If this is not used, the master SIP Trunk name will be the default.
       *
       */
      name?: string;
    }>;
  };
  path: {
    /**
     * Unique identifier of the account.
     */
    accountId: string;
  };
};

export type PostPhoneSipTrunkResponse = {
  sip_trunks?: Array<{
    /**
     * Carrier account.
     */
    carrier_account?: string;
    /**
     * Unique identifier of the SIP trunk of the sub account.
     */
    id?: string;
    /**
     * Name of the SIP trunk.
     */
    name?: string;
  }>;
};

export type PostPhoneSipTrunkError = unknown;

export type UpdatePhoneSipTrunkData = {
  body?: {
    /**
     * Account associated with the carrier.
     */
    carrier_account?: string;
    /**
     * Name of the SIP Trunk.
     */
    name?: string;
  };
  path: {
    /**
     * Unique identifier of the sub account.
     */
    accountId: string;
    /**
     * Unique identifier of the SIP trunk.
     */
    sipTrunkId: string;
  };
};

export type UpdatePhoneSipTrunkResponse = unknown;

export type UpdatePhoneSipTrunkError = unknown;

export type AccountPlansData = {
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
};

export type AccountPlansResponse = {
  /**
   * Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type.</a>
   */
  plan_audio?: {
    /**
     * Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.
     */
    callout_countries?: string;
    /**
     * Dedicated dial-In numbers.
     */
    ddi_numbers?: number;
    /**
     * Next invoice date for the plan.
     */
    next_invoice_date?: string;
    /**
     * Premium countries: multiple values should be separated by commas. For a list of allowed values, refer to the "ID" field in the [Premium Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#premium-countries) table.
     */
    premium_countries?: string;
    /**
     * Date at which the plan became effective on the account.
     */
    service_effective_date?: string;
    /**
     * Status of the plan.
     */
    status?: 'active' | 'cancel' | 'expired';
    /**
     * Toll-free countries: multiple values should separated by a comma. For a list of allowed values, refer to the "ID" field in the [Toll Free Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#toll-free-countries) table.
     */
    tollfree_countries?: string;
    /**
     * Additional audio conferencing <a href="/api-reference/other-references/plans">plan type.</a>
     */
    type?: string;
  };
  plan_base?: {
    /**
     * Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.
     */
    hosts?: number;
    /**
     * Next invoice date for the plan.
     */
    next_invoice_date?: string;
    /**
     * Date at which the plan became effective on the account.
     */
    service_effective_date?: string;
    /**
     * Status of the plan.
     */
    status?: 'active' | 'cancel' | 'expired';
    /**
     * Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
     */
    type?: string;
  };
  plan_large_meeting?: Array<{
    /**
     * Account plan number of hosts.
     */
    hosts?: number;
    /**
     * Next invoice date for the plan.
     */
    next_invoice_date?: string;
    /**
     * Date at which the plan became effective on the account.
     */
    service_effective_date?: string;
    /**
     * Status of the plan.
     */
    status?: 'active' | 'cancel' | 'expired';
    /**
     * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
     */
    type?: string;
  }>;
  /**
   * Phone Plan Object
   */
  plan_phone?: {
    /**
     * Additional phone base plans.
     */
    plan_base?: {
      /**
       * Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.
       */
      callout_countries?: string;
      /**
       * Next invoice date for the plan.
       */
      next_invoice_date?: string;
      /**
       * Date at which the plan became effective on the account.
       */
      service_effective_date?: string;
      /**
       * Status of the plan.
       */
      status?: 'active' | 'cancel' | 'expired';
      /**
       * Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
       */
      type?: string;
    };
    /**
     * Additional phone calling plans.
     */
    plan_calling?: Array<{
      hosts?: number;
      /**
       * Next invoice date for the plan.
       */
      next_invoice_date?: string;
      /**
       * Date at which the plan became effective on the account.
       */
      service_effective_date?: string;
      /**
       * Status of the plan.
       */
      status?: 'active' | 'cancel' | 'expired';
      /**
       * Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
       */
      type?: string;
    }>;
    /**
     * Additional phone number plans.
     */
    plan_number?: Array<{
      hosts?: number;
      /**
       * Next invoice date for the plan.
       */
      next_invoice_date?: string;
      /**
       * Date at which the plan became effective on the account.
       */
      service_effective_date?: string;
      /**
       * Status of the plan.
       */
      status?: 'active' | 'cancel' | 'expired';
      /**
       * Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
       */
      type?: string;
    }>;
  };
  /**
   * Additional Cloud Recording plan.
   */
  plan_recording?: string;
  /**
   * Next invoice date of Additional Cloud Recording plan.
   */
  plan_recording_next_invoice_date?: string;
  /**
   * Plan start date of Additional Cloud Recording plan.
   */
  plan_recording_service_effective_date?: string;
  /**
   * Status of additional Cloud Recording plan.
   */
  plan_recording_status?: 'Active' | 'Cancelled';
  plan_room_connector?: {
    /**
     * Account plan number of hosts.
     */
    hosts?: number;
    /**
     * Next invoice date for the plan.
     */
    next_invoice_date?: string;
    /**
     * Date at which the plan became effective on the account.
     */
    service_effective_date?: string;
    /**
     * Status of the plan.
     */
    status?: 'active' | 'cancel' | 'expired';
    /**
     * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
     */
    type?: string;
  };
  plan_webinar?: Array<{
    /**
     * Account plan number of hosts.
     */
    hosts?: number;
    /**
     * Next invoice date for the plan.
     */
    next_invoice_date?: string;
    /**
     * Date at which the plan became effective on the account.
     */
    service_effective_date?: string;
    /**
     * Status of the plan.
     */
    status?: 'active' | 'cancel' | 'expired';
    /**
     * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
     */
    type?: string;
  }>;
  plan_zoom_rooms?: {
    /**
     * Account plan number of hosts.
     */
    hosts?: number;
    /**
     * Next invoice date for the plan.
     */
    next_invoice_date?: string;
    /**
     * Date at which the plan became effective on the account.
     */
    service_effective_date?: string;
    /**
     * Status of the plan.
     */
    status?: 'active' | 'cancel' | 'expired';
    /**
     * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
     */
    type?: string;
  };
};

export type AccountPlansError = unknown;

export type AccountPlanCreateData = {
  body: {
    /**
     * Billing Contact object.
     */
    contact?: {
      /**
       * Billing Contact's address.
       */
      address: string;
      /**
       * Billing Contact's apartment/suite.
       */
      apt?: string;
      /**
       * Billing Contact's city.
       */
      city: string;
      /**
       * Billing Contact's Country [ID](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) in abbreviated format.
       */
      country: string;
      /**
       * Billing Contact's email address.
       */
      email: string;
      /**
       * Billing Contact's first name.
       */
      first_name: string;
      /**
       * Billing Contact's last name.
       */
      last_name: string;
      /**
       * Billing Contact's phone number.
       */
      phone_number: string;
      /**
       * Billing Contact's state.
       */
      state: string;
      /**
       * Billing Contact's zip/postal code.
       */
      zip: string;
    };
  } & {
    /**
     * Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.
     */
    plan_audio?: {
      /**
       * Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.
       */
      callout_countries?: string;
      /**
       * Dedicated dial-In numbers.
       */
      ddi_numbers?: number;
      /**
       * Premium countries: multiple values should be separated by commas. For a list of allowed values, refer to the "ID" field in the [Premium Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#premium-countries) table.
       */
      premium_countries?: string;
      /**
       * Toll-free countries: multiple values should separated by a comma. For a list of allowed values, refer to the "ID" field in the [Toll Free Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#toll-free-countries) table.
       */
      tollfree_countries?: string;
      /**
       * Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.
       */
      type?: string;
    };
    /**
     * Account base plan object.
     */
    plan_base: {
      /**
       * Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.
       */
      hosts: number;
      /**
       * Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
       */
      type: string;
    };
    /**
     * Additional large meeting Plans.
     */
    plan_large_meeting?: Array<{
      /**
       * Account plan number of hosts.
       */
      hosts?: number;
      /**
       * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
       */
      type?: string;
    }>;
    /**
     * Phone Plan Object
     */
    plan_phone?: {
      /**
       * Additional phone base plans.
       */
      plan_base?: {
        /**
         * Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.
         */
        callout_countries?: string;
        /**
         * Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
         */
        type?: string;
      };
      /**
       * Additional phone calling plans.
       */
      plan_calling?: Array<{
        hosts?: number;
        /**
         * Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
         */
        type?: string;
      }>;
      /**
       * Additional phone number plans.
       */
      plan_number?: Array<{
        hosts?: number;
        /**
         * Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
         */
        type?: string;
      }>;
    };
    /**
     * Additional cloud recording plan.
     */
    plan_recording?: string;
    /**
     * Account plan object.
     */
    plan_room_connector?: {
      /**
       * Account plan number of hosts.
       */
      hosts?: number;
      /**
       * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
       */
      type?: string;
    };
    /**
     * Additional webinar plans.
     */
    plan_webinar?: Array<{
      /**
       * Account plan number of hosts.
       */
      hosts?: number;
      /**
       * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
       */
      type?: string;
    }>;
    /**
     * Account plan object.
     */
    plan_zoom_rooms?: {
      /**
       * Account plan number of hosts.
       */
      hosts?: number;
      /**
       * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
       */
      type?: string;
    };
  };
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
};

export type AccountPlanCreateResponse =
  | unknown
  | {
      /**
       * Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.
       */
      plan_audio?: {
        /**
         * Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.
         */
        callout_countries?: string;
        /**
         * Dedicated dial-In numbers.
         */
        ddi_numbers?: number;
        /**
         * Premium countries: multiple values should be separated by commas. For a list of allowed values, refer to the "ID" field in the [Premium Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#premium-countries) table.
         */
        premium_countries?: string;
        /**
         * Toll-free countries: multiple values should separated by a comma. For a list of allowed values, refer to the "ID" field in the [Toll Free Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#toll-free-countries) table.
         */
        tollfree_countries?: string;
        /**
         * Additional audio conferencing <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#audio-conferencing-plans">plan type</a>.
         */
        type?: string;
      };
      /**
       * Account base plan object.
       */
      plan_base: {
        /**
         * Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.
         */
        hosts: number;
        /**
         * Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
         */
        type: string;
      };
      /**
       * Additional large meeting Plans.
       */
      plan_large_meeting?: Array<{
        /**
         * Account plan number of hosts.
         */
        hosts?: number;
        /**
         * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
         */
        type?: string;
      }>;
      /**
       * Phone Plan Object
       */
      plan_phone?: {
        /**
         * Additional phone base plans.
         */
        plan_base?: {
          /**
           * Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.
           */
          callout_countries?: string;
          /**
           * Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
           */
          type?: string;
        };
        /**
         * Additional phone calling plans.
         */
        plan_calling?: Array<{
          hosts?: number;
          /**
           * Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
           */
          type?: string;
        }>;
        /**
         * Additional phone number plans.
         */
        plan_number?: Array<{
          hosts?: number;
          /**
           * Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
           */
          type?: string;
        }>;
      };
      /**
       * Additional cloud recording plan.
       */
      plan_recording?: string;
      /**
       * Account plan object.
       */
      plan_room_connector?: {
        /**
         * Account plan number of hosts.
         */
        hosts?: number;
        /**
         * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
         */
        type?: string;
      };
      /**
       * Additional webinar plans.
       */
      plan_webinar?: Array<{
        /**
         * Account plan number of hosts.
         */
        hosts?: number;
        /**
         * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
         */
        type?: string;
      }>;
      /**
       * Account plan object.
       */
      plan_zoom_rooms?: {
        /**
         * Account plan number of hosts.
         */
        hosts?: number;
        /**
         * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
         */
        type?: string;
      };
    };

export type AccountPlanCreateError = unknown;

export type AccountPlanAddonCreateData = {
  body:
    | {
        /**
         * Number of hosts for this plan.
         */
        hosts: number;
        /**
         * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
         */
        type: string;
      }
    | {
        /**
         * Phone Plan Object
         */
        plan_details: {
          /**
           * Additional phone base plans.
           */
          plan_base?: {
            /**
             * Call-out countries: multiple values should separated by  commas. For a list of allowed values, refer to the "ID" field in [this](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#tsp-call-out-countries) table.
             */
            callout_countries?: string;
            /**
             * Additional phone base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
             */
            type?: string;
          };
          /**
           * Additional phone calling plans.
           */
          plan_calling?: Array<{
            hosts?: number;
            /**
             * Additional phone calling <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
             */
            type?: string;
          }>;
          /**
           * Additional phone number plans.
           */
          plan_number?: Array<{
            hosts?: number;
            /**
             * Additional phone number <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans#additional-zoom-phone-plans">plan type.</a>
             */
            type?: string;
          }>;
        };
        /**
         * Zoom Phone Plan `plan_phone`
         */
        type: string;
      };
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
};

export type AccountPlanAddonCreateResponse = unknown;

export type AccountPlanAddonCreateError = unknown;

export type AccountPlanAddonUpdateData = {
  body: {
    /**
     * Number of hosts for this plan.
     */
    hosts: number;
    /**
     * Account <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
     */
    type: string;
  };
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
};

export type AccountPlanAddonUpdateResponse = unknown | any;

export type AccountPlanAddonUpdateError = unknown;

export type AccountPlanAddonCancelData = {
  body?: {
    /**
     * The action that needs to be taken for this sub account. Value must be set to "cancel".
     */
    action?: 'cancel';
    /**
     * Additional comments about the cancellation decision.
     */
    comment?: string;
    /**
     * The reason for the cancellation of plan. Reason options:<br>`1` - I am no longer working remote.<br>`2` - I had challenges getting the support I needed.<br>`3` - Features in the Basic Free Plan are sufficient.<br>`4` - The expense is too high.<br>`5` - I purchased the wrong product.<br> `6` - Paid purchase not needed right now, will repurchase in the future.
     */
    reason?: 1 | 2 | 3 | 4 | 5 | 6;
    /**
     * Plan [type](https://marketplace.zoom.us/docs/api-reference/other-references/plans).
     */
    type?: string;
  };
  path: {
    accountId: string;
  };
};

export type AccountPlanAddonCancelResponse = unknown;

export type AccountPlanAddonCancelError = unknown;

export type AccountPlanBaseUpdateData = {
  body: {
    /**
     * Account base plan number of hosts. For a Pro Plan please select a value between 1 and 9. For a Business Plan please select a value between 10 and 49. For a Education Plan please select a value between 20 and 149. For a Free Trial Plan please select a value between 1 and 9999.
     */
    hosts: number;
    /**
     * Account base <a href="https://marketplace.zoom.us/docs/api-reference/other-references/plans">plan type.</a>
     */
    type: string;
  };
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
};

export type AccountPlanBaseUpdateResponse = unknown | any;

export type AccountPlanBaseUpdateError = unknown;

export type AccountPlanBaseDeleteData = {
  body?: {
    /**
     * The action that needs to be taken for this sub account. Value must be set to "cancel".
     */
    action: string;
    /**
     * Additional comments about the cancellation decision.
     */
    comment?: string;
    /**
     * The reason for the cancellation of plan. Reason options:<br>`1` - I am no longer working remote.<br>`2` - I had challenges getting the support I needed.<br>`3` - Features in the Basic Free Plan are sufficient.<br>`4` - The expense is too high.<br>`5` - I purchased the wrong product.<br> `6` - Paid purchase not needed right now, will repurchase in the future.
     */
    reason?: 1 | 2 | 3 | 4 | 5 | 6;
  };
  path: {
    accountId: string;
  };
};

export type AccountPlanBaseDeleteResponse =
  | unknown
  | {
      [key: string]: unknown;
    };

export type AccountPlanBaseDeleteError = unknown;

export type GetPlanUsageData = {
  path: {
    accountId: string;
  };
};

export type GetPlanUsageResponse = {
  /**
   * The base plan subscribed for the sub account.
   */
  plan_base?: Array<{
    /**
     * Number of hosts under the base plan.
     */
    hosts?: number;
    /**
     * Type of the base plan.
     */
    type?: string;
    /**
     * Total number of usage of this plan.
     */
    usage?: number;
  }>;
  /**
   * Large Meeting Plan
   */
  plan_large_meeting?: Array<{
    /**
     * Number of hosts in this plan.
     */
    hosts?: number;
    /**
     * Large meeting Plan Type
     */
    type?: string;
    /**
     * Number of usages for this account plan.
     */
    usage?: number;
  }>;
  /**
   * Recording Plan
   */
  plan_recording?: {
    /**
     * Recording free storage.
     */
    free_storage?: string;
    /**
     * Amount of free storage used.
     */
    free_storage_usage?: string;
    /**
     * Recording plan storage.
     */
    plan_storage?: string;
    plan_storage_exceed?: string;
    /**
     * Recording storage usage.
     */
    plan_storage_usage?: string;
    /**
     * Recording plan type.
     */
    type?: string;
  };
  /**
   * [Zoom United](https://zoom.us/pricing/zoom-bundles) plan.
   */
  plan_united?: {
    /**
     * Number of licenses purchased.
     */
    hosts?: number;
    /**
     * Name of the plan.
     */
    name?: string;
    /**
     * Plan [type](https://marketplace.zoom.us/docs/api-reference/other-references/plans#zoom-united-plans).
     */
    type?: string;
    /**
     * Number of licenses that are already being used.
     */
    usage?: number;
  };
  /**
   * Webinar Plan
   */
  plan_webinar?: Array<{
    /**
     * The number of hosts in this plan.
     */
    hosts?: number;
    /**
     * The type of Webinar plan for the account.
     */
    type?: string;
    /**
     * The total number of plan usage.
     */
    usage?: number;
  }>;
  /**
   * Zoom Rooms Plan
   */
  plan_zoom_rooms?: Array<{
    /**
     * The number of hosts in this plan.
     */
    hosts?: number;
    /**
     * THe plan type for Zoom room plan.
     */
    type?: string;
    /**
     * The total number of usage for this plan.
     */
    usage?: number;
  }>;
};

export type GetPlanUsageError = unknown;

export type GetAccountCloudRecordingData = {
  path: {
    /**
     * Unique identifier of the account.
     */
    accountId: string;
  };
  query?: {
    /**
     * The start date in UTC for the monthly range for which you would like to retrieve recordings. The maximum range can be a month. If no value is provided for this field, the default will be current date. For example, if you make the API request on June 30, 2020, without providing the “from” and “to” parameters, by default the value of 'from' field will be “2020-06-30” and the value of the 'to' field will be “2020-07-01”.
     */
    from?: string;
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     * The number of records returned within a single API call.
     */
    page_size?: number;
    /**
     * The end date for the monthly range for which you would like to retrieve recordings. The maximum range can be a month.
     */
    to?: string;
  };
};

export type GetAccountCloudRecordingResponse = {
  /**
   * The start date for the monthly range for which you would like to retrieve recordings. The maximum range can be a month. If no value is provided for this field, the default will be current date. For example, if you make the API request on June 30, 2020, without providing the “from” and “to” parameters, by default the value of 'from' field will be “2020-06-30” and the value of the 'to' field will be “2020-07-01”.
   */
  from?: string;
  /**
   * Meetings Object
   */
  meetings?: Array<{
    /**
     * The scheduled duration of the meeting.
     */
    duration?: number;
    /**
     * User ID of the user who is set as the host of the meeting.
     */
    host_id?: string;
    /**
     * Meeting ID - Unique Identifier of a meeting, also known as Meeting Number.
     */
    id?: string;
    /**
     * The total number of recordings retrieved from the account.
     */
    recording_count?: number;
    /**
     * Recording files object
     */
    recording_files?: Array<{
      /**
       * The URL using which the recording can be downloaded
       */
      download_url?: string;
      /**
       * The size of the recording file in bytes.
       */
      file_size?: number;
      /**
       * The recording file type. The value of this field could be one of the following:<br>
       * * `MP4`: Video file of the recording.<br>
       * * `M4A` Audio-only file of the recording.<br>
       * * `TB`: Timestamp file of the recording in JSON format.<br>
       * * `TRANSCRIPT`: Transcription file of the recording in VTT format.<br>
       * * `CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>
       * * `CC`: File containing closed captions of the recording in VTT file format.<br>
       * * `CSV`: File containing polling data in csv format.
       *
       * A recording file object with file type of either `CC` or `TB` **does not have** the following properties:<br>
       * `id`, `status`, `file_size`, `recording_type`, and `play_url`.
       */
      file_type?: 'MP4' | 'M4A' | 'CHAT' | 'TRANSCRIPT' | 'CC' | 'CSV' | 'TB';
      /**
       * Recording ID. Identifier for the recording.
       */
      id?: string;
      /**
       * Universally unique identifier of the meeting instance that was being recorded.
       */
      meeting_id?: string;
      /**
       * The URL using which recording can be played.
       */
      play_url?: string;
      /**
       * The date and time at which the recording ended.
       */
      recording_end?: string;
      /**
       * The date and time at which the recording started.
       */
      recording_start?: string;
      /**
       * The recording type. The value of this field can be one of the following:<br>
       * * `shared_screen_with_speaker_view(CC)`
       * * `shared_screen_with_speaker_view`
       * * `shared_screen_with_gallery_view`
       * * `shared_screen`
       * * `active_speaker`
       * * `gallery_view`
       * * `audio_only`
       * * `audio_transcript`
       * * `chat_file`
       * * `host_video`
       * * `closed_caption`
       * * `poll`
       * * `timeline`
       * * `thumbnail`
       *
       */
      recording_type?:
        | 'shared_screen_with_speaker_view(CC)'
        | 'shared_screen_with_speaker_view'
        | 'shared_screen_with_gallery_view'
        | 'active_speaker'
        | 'gallery_view'
        | 'shared_screen'
        | 'audio_only'
        | 'audio_transcript'
        | 'chat_file'
        | 'poll'
        | 'host_video'
        | 'closed_caption'
        | 'timeline'
        | 'thumbnail';
      /**
       * The status of the recording, either `completed` or `processing`.
       */
      status?: 'completed' | 'processing';
    }>;
    /**
     * The date and time at which the meeting started.
     */
    start_time?: string;
    /**
     * Meeting topic.
     */
    topic?: string;
    /**
     * The total size of the meeting in bytes.
     */
    total_size?: number;
    /**
     * Universally Unique Identifier of a meeting instance. Each meeting instance will have its own meeting UUID.
     */
    uuid?: string;
  }>;
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of records returned within a single API call.
   */
  page_size?: number;
  /**
   * The end date for the monthly range for which you would like to retrieve recordings. The maximum range can be a month.
   */
  to?: string;
  /**
   * Total number of records found for this request across all pages.
   */
  total_records?: number;
};

export type GetAccountCloudRecordingError = unknown;

export type AccountSettingsData = {
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
  query?: {
    /**
     * Provide the name of the field by which you would like to filter the response. For example, if you provide "host_video" as the value of this field, you will get a response similar to the following:<br>
     * {
     * "schedule_meeting": {
     * "host_video": false
     * }
     * }
     * <br>You can provide multiple values by separating them with commas(example: "host_video,participant_video”).
     */
    custom_query_fields?: string;
    /**
     * `meeting_authentication`: Use this query parameter to view [meeting authentication configuration](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) applied on the account.<br>`recording_authentication`: Use this query parameter to view [recording authentication configuration](https://support.zoom.us/hc/en-us/articles/360037756671-Authentication-Profiles-for-Cloud-Recordings) applied on the account.<br>`security`: Use this query parameter to view security settings such as password requirements for user login, two factor authentication etc., applied on the account.<br>
     * `meeting_security`: Use this query parameter to view meeting security settings applied on the account.<br>
     */
    option?: 'meeting_authentication' | 'recording_authentication';
  };
};

export type AccountSettingsResponse =
  | {
      /**
       * Account Settings: Notification.
       */
      email_notification?: {
        /**
         * Notify when an alternative host is set or removed from a meeting.
         */
        alternative_host_reminder?: boolean;
        /**
         * Notify the host and participants when a meeting is cancelled.
         */
        cancel_meeting_reminder?: boolean;
        /**
         * Notify host when cloud recording is available.
         */
        cloud_recording_avaliable_reminder?: boolean;
        /**
         * Notify the host when participants join the meeting before them.
         */
        jbh_reminder?: boolean;
        /**
         * Notify user when host licenses are running low.
         */
        low_host_count_reminder?: boolean;
        /**
         * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
         */
        schedule_for_reminder?: boolean;
      };
      /**
       * Account Settings: Feature.
       */
      feature?: {
        /**
         * Set the maximum number of participants a host can have in a single meeting.
         */
        meeting_capacity?: number;
      };
      /**
       * Account Settings: In Meeting.
       */
      in_meeting?: {
        /**
         * Identify guest participants in a meeting or webinar.
         */
        alert_guest_join?: boolean;
        /**
         * Allow live streaming.
         */
        allow_live_streaming?: boolean;
        /**
         * If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.
         *
         */
        allow_participants_to_rename?: boolean;
        /**
         * Show the Zoom desktop application when sharing screens.
         */
        allow_show_zoom_windows?: boolean;
        /**
         * Allow participants to use annotation tools to add information to shared screens.
         */
        annotation?: boolean;
        /**
         * Allow an anonymous Q&A in a webinar.
         */
        anonymous_question_answer?: boolean;
        /**
         * Allow host to put attendee on hold.
         *
         * **This field has been deprecated and is no longer supported.**
         */
        attendee_on_hold?: boolean;
        /**
         * Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.
         */
        auto_answer?: boolean;
        /**
         * Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.
         */
        auto_saving_chat?: boolean;
        /**
         * Allow host to split meeting participants into separate, smaller rooms.
         */
        breakout_room?: boolean;
        /**
         * Allow meeting participants to send a message that is visible to all participants.
         */
        chat?: boolean;
        /**
         * Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions.
         */
        closed_caption?: boolean;
        /**
         * Allow the host to add co-hosts.
         */
        co_host?: boolean;
        /**
         * If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.
         */
        custom_data_center_regions?: boolean;
        /**
         * Custom live streaming.
         */
        custom_live_streaming_service?: boolean;
        /**
         * Custom service instructions.
         */
        custom_service_instructions?: string;
        /**
         * If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).
         *
         */
        data_center_regions?: 'EU' | 'HK' | 'AU' | 'IN' | 'TY' | 'CN' | 'US' | 'CA';
        /**
         * DSCP audio.
         */
        dscp_audio?: number;
        /**
         * DSCP marking.
         */
        dscp_marking?: boolean;
        /**
         * DSCP video.
         */
        dscp_video?: number;
        /**
         * Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).
         */
        e2e_encryption?: boolean;
        /**
         * Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.
         */
        entry_exit_chime?: 'host' | 'all' | 'none';
        /**
         * Allow another user to take control of your camera during a meeting.
         */
        far_end_camera_control?: boolean;
        /**
         * Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.
         */
        feedback?: boolean;
        /**
         * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.
         */
        file_transfer?: boolean;
        /**
         * Activate higher quality video for host and participants.
         * Please note: This will use more bandwidth.
         */
        group_hd?: boolean;
        /**
         * Enable or disable meeting reactions. <br>
         * `true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>
         * `false`: Do not enable meeting reactions.
         */
        meeting_reactions?: boolean;
        /**
         * Allow users to select original sound in their client settings.
         */
        original_audio?: boolean;
        /**
         * Peer to peer connection while only two people are in a meeting.
         */
        p2p_connetion?: boolean;
        /**
         * Peer to peer listening ports range.
         */
        p2p_ports?: boolean;
        /**
         * Add "Polls" to the meeting controls.
         */
        polling?: boolean;
        /**
         * The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.
         */
        ports_range?: string;
        /**
         * Display a thumbs up or down survey at the end of each meeting.
         */
        post_meeting_feedback?: boolean;
        /**
         * Allow a meeting participant to send a private message to another participant.
         */
        private_chat?: boolean;
        /**
         * Record and play their own voice.
         */
        record_play_own_voice?: boolean;
        /**
         * Allow users to request remote control.
         */
        remote_control?: boolean;
        /**
         * Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.
         */
        request_permission_to_unmute?: boolean;
        /**
         * Allow screen sharing.
         */
        screen_sharing?: boolean;
        /**
         * Only show the default email when sending email invites.
         */
        sending_default_email_invites?: boolean;
        /**
         * If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.
         */
        show_a_join_from_your_browser_link?: boolean;
        /**
         * Always show the meeting control toolbar.
         */
        show_meeting_control_toolbar?: boolean;
        /**
         * Allow users to select stereo audio in their client settings.
         */
        stereo_audio?: boolean;
        /**
         * Use HTML formatted email for the Outlook plugin.
         */
        use_html_format_email?: boolean;
        /**
         * Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.
         */
        virtual_background?: boolean;
        /**
         * Settings to manage virtual background.
         */
        virtual_background_settings?: {
          /**
           * Allow users to upload custom backgrounds.
           */
          allow_upload_custom?: boolean;
          /**
           * Allow use of videos for virtual backgrounds.
           */
          allow_videos?: boolean;
          /**
           * Enable virtual background.
           */
          enable?: boolean;
          files?: Array<{
            /**
             * Unique identifier of the file.
             */
            id?: string;
            /**
             * Indicates whether or not this file is the default virtual background file.
             */
            is_default?: boolean;
            /**
             * File name.
             */
            name?: string;
            /**
             * File size.
             */
            size?: string;
            /**
             * File type.
             */
            type?: string;
          }>;
        };
        /**
         * Add a watermark when viewing a shared screen.
         */
        watermark?: boolean;
        /**
         * Allow a Q&A in a webinar.
         */
        webinar_question_answer?: boolean;
        /**
         * Allow participants to share a whiteboard that includes annotation tools.
         */
        whiteboard?: boolean;
        /**
         * Indicates who can share their screen or content during meetings. The value can be one of the following: <br>
         * `host`: Only host can share the screen.<br>
         * `all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
         *
         */
        who_can_share_screen?: 'host' | 'all';
        /**
         * Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>
         * `host`: Only a host can share the screen when someone else is sharing.<br>
         * `all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
         *
         */
        who_can_share_screen_when_someone_is_sharing?: 'host' | 'all';
        /**
         * Workplace by facebook.
         */
        workplace_by_facebook?: boolean;
      };
      /**
       * Account Settings: Integration.
       */
      integration?: {
        /**
         * Enable users who join a meeting from their mobile device to share content from their Box account.
         */
        box?: boolean;
        /**
         * Enable users who join a meeting from their mobile device to share content from their Dropbox account.
         */
        dropbox?: boolean;
        /**
         * Enable meetings to be scheduled using Google Calendar.
         */
        google_calendar?: boolean;
        /**
         * Enable users who join a meeting from their mobile device to share content from their Google Drive.
         */
        google_drive?: boolean;
        /**
         * Enable users to control a connected Kubi device from within a Zoom meeting.
         */
        kubi?: boolean;
        /**
         * Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.
         */
        microsoft_one_drive?: boolean;
      };
      profile?: {
        recording_storage_location?: {
          /**
           * Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.
           *
           * Provide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.
           */
          allowed_values?: Array<string>;
          /**
           * Abbreviated country code.
           */
          value?: string;
        };
      };
      /**
       * Account Settings: Recording.
       */
      recording?: {
        /**
         * Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.
         */
        account_user_access_recording?: boolean;
        /**
         * Allow recovery of deleted cloud recordings from trash.
         * If the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period.
         */
        allow_recovery_deleted_cloud_recordings?: boolean;
        /**
         * [Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.
         */
        archive?: {
          /**
           * Enable the archiving feature.
           */
          enable?: boolean;
          settings?: {
            /**
             * Include in-meeting and/or in-webinar audio in the archive.
             */
            audio_file?: boolean;
            /**
             * Include closed caption or transcript in the archive.
             */
            cc_transcript_file?: boolean;
            /**
             * Include in-meeting chat in the archive.
             */
            chat_file?: boolean;
            /**
             * Include user email in in-meeting chat file.
             */
            chat_with_sender_email?: boolean;
            /**
             * Include in-meeting and/or in-webinar video in the archive.
             */
            video_file?: boolean;
          };
          /**
           * Archive types:
           *
           * * `1`: Only meetings are archived.<br>
           * * `2`: Only webinars are archived.<br>
           * * `3`: Both meetings and webinars are archived.
           */
          type?: 1 | 2 | 3;
        };
        /**
         * Allow Zoom to permanantly delete recordings automatically after a specified number of days.
         */
        auto_delete_cmr?: boolean;
        /**
         * When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.
         */
        auto_delete_cmr_days?: number;
        /**
         * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
         */
        auto_recording?: 'local' | 'cloud' | 'none';
        /**
         * Allow hosts to record and save the meeting in the cloud.
         */
        cloud_recording?: boolean;
        /**
         * Cloud recording downloads.
         */
        cloud_recording_download?: boolean;
        /**
         * Only the host can download cloud recordings.
         */
        cloud_recording_download_host?: boolean;
        /**
         * If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.
         *
         */
        host_delete_cloud_recording?: boolean;
        /**
         * Setting to allow cloud recording access only from specific IP address ranges.
         *
         */
        ip_address_access_control?: {
          /**
           * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
           *
           *
           */
          enable?: boolean;
          /**
           * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
           *
           * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
           *
           *
           */
          ip_addresses_or_ranges?: string;
        };
        /**
         * Allow hosts and participants to record the meeting using a local file.
         */
        local_recording?: boolean;
        /**
         * If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.
         *
         */
        prevent_host_access_recording?: boolean;
        /**
         * Record an audio only file.
         */
        record_audio_file?: boolean;
        /**
         * Record the gallery view with a shared screen.
         */
        record_gallery_view?: boolean;
        /**
         * Record the active speaker with a shared screen.
         */
        record_speaker_view?: boolean;
        /**
         * Automatically transcribe the audio of the meeting or webinar to the cloud.
         */
        recording_audio_transcript?: boolean;
        /**
         * Show a disclaimer to participants before a recording starts
         *
         */
        recording_disclaimer?: boolean;
        /**
         * This object represents the minimum password requirements set for recordings via Account Recording Settings.
         */
        recording_password_requirement?: {
          /**
           * Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).
           */
          have_letter?: boolean;
          /**
           * Indicates whether or not password must contain at least one number(1, 2, 3..).
           */
          have_number?: boolean;
          /**
           * Indicates whether or not password must contain at least one special character(!, @, #..).
           */
          have_special_character?: boolean;
          /**
           * Minimum required length for the password.
           */
          length?: number;
          /**
           * Indicates whether or not password must contain only numeric characters.
           */
          only_allow_numeric?: boolean;
        };
        /**
         * Require a passcode to access existing cloud recordings.
         */
        required_password_for_existing_cloud_recordings?: boolean;
        /**
         * Save the chat text from the meeting.
         */
        save_chat_text?: boolean;
        /**
         * Add a timestamp to the recording.
         */
        show_timestamp?: boolean;
      };
      /**
       * Account Settings: Schedule Meeting.
       */
      schedule_meeting?: {
        /**
         * Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.
         */
        audio_type?: 'both' | 'telephony' | 'voip' | 'thirdParty';
        /**
         * Only Zoom users who are signed in can join meetings.
         */
        enforce_login?: boolean;
        /**
         * Only signed in users with a specified domain can join the meeting.
         */
        enforce_login_domains?: string;
        /**
         * Only signed in users with a specific domain can join meetings.
         */
        enforce_login_with_domains?: boolean;
        /**
         * Require a password for Personal Meetings if attendees can join before host.
         */
        force_pmi_jbh_password?: boolean;
        /**
         * Start meetings with the host video on.
         */
        host_video?: boolean;
        /**
         * Allow participants to join the meeting before the host arrives.
         */
        join_before_host?: boolean;
        /**
         * Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
         */
        meeting_password_requirement?: {
          consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
          /**
           * If set to `true`, the password must contain at least 1 letter (such as a,b,c...).
           *
           */
          have_letter?: boolean;
          /**
           * If set to `true`, the password must contain at least 1 number (such as 1,2,3...).
           */
          have_number?: boolean;
          /**
           * If set to `true`, the password must have at least 1 special character (!,@,#...).
           */
          have_special_character?: boolean;
          /**
           * If set to `true`, the password must include both uppercase and lowercase characters.
           */
          have_upper_and_lower_characters?: boolean;
          /**
           * The minimum length that the meeting/webinar password needs to have.
           */
          length?: number;
          /**
           * If set to `true`, the password must only contain numbers and no other characters.
           */
          only_allow_numeric?: boolean;
          /**
           * If set to `true`, users will be informed if the provided password is weak.
           */
          weak_enhance_detection?: boolean;
        };
        /**
         * Always display "Zoom Meeting" as the meeting topic.
         */
        not_store_meeting_topic?: boolean;
        /**
         * Start meetings with the participant video on. Participants can change this setting during the meeting.
         */
        participant_video?: boolean;
        /**
         * Personal Meeting Setting.<br><br>
         * `true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>
         * `false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.
         * For Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.
         *
         *
         *
         */
        personal_meeting?: boolean;
        /**
         * Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
         *
         */
        require_password_for_instant_meetings?: boolean;
        /**
         * Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
         *
         */
        require_password_for_pmi_meetings?: 'jbh_only' | 'all' | 'none';
        /**
         * Require a password for meetings which have already been scheduled
         *
         */
        require_password_for_scheduled_meetings?: boolean;
        /**
         * Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
         */
        require_password_for_scheduling_new_meetings?: boolean;
        /**
         * Use Personal Meeting ID (PMI) when starting an instant meeting
         *
         */
        use_pmi_for_instant_meetings?: boolean;
        /**
         * Use Personal Meeting ID (PMI) when scheduling a meeting
         *
         */
        use_pmi_for_scheduled_meetings?: boolean;
      };
      /**
       * [Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.
       */
      security?: {
        /**
         * Only account administrators can change a user's username and picture.
         */
        admin_change_name_pic?: boolean;
        /**
         * Hide billing information.
         */
        hide_billing_info?: boolean;
        /**
         * Allow users to import photos from a photo library on a  device.
         */
        import_photos_from_devices?: boolean;
        /**
         * This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password.
         */
        password_requirement?: {
          /**
           *
           * Specify the max length of consecutive characters(abcde...) that can be used in a password.
           * If you set the value of this field to `0`, no restriction will be applied on consecutive characters.
           *
           * If you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.
           *
           * The max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).
           */
          consecutive_characters_length?: number;
          /**
           * If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).
           */
          have_special_character?: boolean;
          /**
           * Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.
           */
          minimum_password_length?: number;
          /**
           * If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.
           */
          weak_enhance_detection?: boolean;
        };
        /**
         * Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>
         *
         * If this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>
         *
         * `5`: 5 minutes<br>
         * `10`: 10 minutes<br>
         * `15`: 15 minutes<br>
         * `30`: 30 minutes<br>
         * `45`: 45 minutes<br>
         * `60`: 60 minutes<br>
         * `90`: 90 minutes<br>
         * `120`: 120 minutes
         *
         */
        sign_again_period_for_inactivity_on_client?: number;
        /**
         * Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>
         *
         * If this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>
         *
         * `5`: 5 minutes<br>
         * `10`: 10 minutes<br>
         * `15`: 15 minutes<br>
         * `30`: 30 minutes<br>
         * `60`: 60 minutes<br>
         * `120`: 120 minutes
         *
         *
         *
         *
         */
        sign_again_period_for_inactivity_on_web?: number;
        /**
         * Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:
         * `all`: Two factor authentication will be enabled for all users in the account.<br>
         * `none`: Two factor authentication is disabled.<br>
         * `group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>
         * `role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the
         * `sign_in_with_two_factor_auth_roles` field.
         *
         */
        sign_in_with_two_factor_auth?: 'all' | 'group' | 'role' | 'none';
        /**
         * This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`
         */
        sign_in_with_two_factor_auth_groups?: Array<string>;
        /**
         * This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.
         */
        sign_in_with_two_factor_auth_roles?: Array<string>;
      };
      /**
       * Account Settings: Telephony.
       */
      telephony?: {
        /**
         * Third party audio conference info.
         */
        audio_conference_info?: string;
        /**
         * Indicates where most of the participants call into or call from duriing a meeting.
         */
        telephony_regions?: {
          /**
           * Telephony region options provided by Zoom to select from.
           */
          allowed_values?: Array<string>;
          /**
           * Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.
           */
          selection_values?: Array<string>;
        };
        /**
         * Users can join the meeting using the existing third party audio configuration.
         */
        third_party_audio?: boolean;
      };
      /**
       * Account Settings: TSP.
       */
      tsp?: {
        /**
         * Call Out
         */
        call_out?: boolean;
        /**
         * Call Out Countries/Regions
         */
        call_out_countries?: Array<unknown>;
        /**
         * Display toll-free numbers
         */
        display_toll_free_numbers?: boolean;
        /**
         * Show international numbers link on the invitation email
         */
        show_international_numbers_link?: boolean;
      };
      /**
       * Account Settings: Zoom Rooms.
       */
      zoom_rooms?: {
        /**
         * Automatic start and stop for scheduled meetings.
         */
        auto_start_stop_scheduled_meetings?: boolean;
        /**
         * Cloud recording for instant meetings.
         */
        cmr_for_instant_meeting?: boolean;
        /**
         * Shift all meetings to private.
         */
        force_private_meeting?: boolean;
        /**
         * Hide host and meeting ID from private meetings.
         */
        hide_host_information?: boolean;
        /**
         * Display meeting list with calendar integration.
         */
        list_meetings_with_calendar?: boolean;
        /**
         * Start AirPlay service manually.
         */
        start_airplay_manually?: boolean;
        /**
         * Automatic direct sharing using an ultrasonic proximity signal.
         */
        ultrasonic?: boolean;
        /**
         * Upcoming meeting alert.
         */
        upcoming_meeting_alert?: boolean;
        /**
         * Weekly system restart.
         */
        weekly_system_restart?: boolean;
        /**
         * Zoom Room post meeting feedback.
         */
        zr_post_meeting_feedback?: boolean;
      };
    }
  | (
      | {
          /**
           * Meeting Authentication Options
           */
          authentication_options?: Array<{
            /**
             * Authentication default option
             */
            default_option?: boolean;
            /**
             * Authentication domians
             */
            domains?: string;
            /**
             * Authentication id
             */
            id?: string;
            /**
             * Authentication name
             */
            name?: string;
            /**
             *  Authentication type. Specify one of the following authentication types for the authentication profile:<br>
             * * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.
             * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>
             * * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.
             */
            type?: 'enforce_login' | 'enforce_login_with_same_account' | 'enforce_login_with_domains';
            /**
             * Authentication visible
             */
            visible?: boolean;
          }>;
          /**
           * Only authenticated users can join meetings
           */
          meeting_authentication?: boolean;
        }
      | {
          authentication_options?: Array<{
            /**
             * Authentication default option
             */
            default_option?: boolean;
            /**
             * Authentication domians
             */
            domains?: string;
            /**
             * Authentication id
             */
            id?: string;
            /**
             * Authentication name
             */
            name?: string;
            /**
             * Authentication type
             */
            type?: 'internally' | 'enforce_login' | 'enforce_login_with_domains';
            /**
             * Authentication visible
             */
            visible?: boolean;
          }>;
          /**
           * Only authenticated users can view cloud recordings
           */
          recording_authentication?: boolean;
        }
    )
  | {
      /**
       * Only account administrators can change a user's username and picture.
       */
      admin_change_name_pic?: boolean;
      /**
       * Hide billing information.
       */
      hide_billing_info?: boolean;
      /**
       * Allow users to import photos from a photo library on a  device.
       */
      import_photos_from_devices?: boolean;
      /**
       * This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password.
       */
      password_requirement?: {
        /**
         *
         * Specify the max length of consecutive characters(abcde...) that can be used in a password.
         * If you set the value of this field to `0`, no restriction will be applied on consecutive characters.
         *
         * If you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.
         *
         * The max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).
         */
        consecutive_characters_length?: number;
        /**
         * If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).
         */
        have_special_character?: boolean;
        /**
         * Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.
         */
        minimum_password_length?: number;
        /**
         * If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.
         */
        weak_enhance_detection?: boolean;
      };
      /**
       * Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>
       *
       * If this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>
       *
       * `5`: 5 minutes<br>
       * `10`: 10 minutes<br>
       * `15`: 15 minutes<br>
       * `30`: 30 minutes<br>
       * `45`: 45 minutes<br>
       * `60`: 60 minutes<br>
       * `90`: 90 minutes<br>
       * `120`: 120 minutes
       *
       */
      sign_again_period_for_inactivity_on_client?: number;
      /**
       * Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>
       *
       * If this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>
       *
       * `5`: 5 minutes<br>
       * `10`: 10 minutes<br>
       * `15`: 15 minutes<br>
       * `30`: 30 minutes<br>
       * `60`: 60 minutes<br>
       * `120`: 120 minutes
       *
       *
       *
       *
       */
      sign_again_period_for_inactivity_on_web?: number;
      /**
       * Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:
       * `all`: Two factor authentication will be enabled for all users in the account.<br>
       * `none`: Two factor authentication is disabled.<br>
       * `group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>
       * `role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the
       * `sign_in_with_two_factor_auth_roles` field.
       *
       */
      sign_in_with_two_factor_auth?: 'all' | 'group' | 'role' | 'none';
      /**
       * This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`
       */
      sign_in_with_two_factor_auth_groups?: Array<string>;
      /**
       * This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.
       */
      sign_in_with_two_factor_auth_roles?: Array<string>;
    }
  | {
      meeting_security?: {
        /**
         * `true`: Require that all meetings are secured with at least one security option.
         *
         * This setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).
         */
        auto_security?: boolean;
        /**
         * If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.
         *
         */
        embed_password_in_join_link?: boolean;
        /**
         * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
         * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
         *
         * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
         */
        encryption_type?: 'enhanced_encryption' | 'e2ee';
        /**
         * Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.
         */
        end_to_end_encrypted_meetings?: boolean;
        /**
         * If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.
         */
        meeting_password?: boolean;
        /**
         * Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
         */
        meeting_password_requirement?: {
          consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
          /**
           * If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).
           *
           */
          have_letter?: boolean;
          /**
           * If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).
           */
          have_number?: boolean;
          /**
           * If set to `true`, the passcode must have at least 1 special character (!,@,#...).
           */
          have_special_character?: boolean;
          /**
           * If set to `true`, the passcode must include both uppercase and lowercase characters.
           */
          have_upper_and_lower_characters?: boolean;
          /**
           * The minimum length that the meeting/webinar passcode needs to have.
           */
          length?: number;
          /**
           * If set to `true`, the passcode must only contain numbers and no other characters.
           */
          only_allow_numeric?: boolean;
          /**
           * If set to `true`, users will be informed if the provided passcode is weak.
           */
          weak_enhance_detection?: boolean;
        };
        /**
         * Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.
         */
        phone_password?: boolean;
        /**
         * If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.
         *
         */
        pmi_password?: boolean;
        /**
         * Require a passcode for meetings which have already been scheduled.
         *
         */
        require_password_for_scheduled_meeting?: boolean;
        /**
         * Require a passcode for webinars which have already been scheduled.
         *
         */
        require_password_for_scheduled_webinar?: boolean;
        /**
         * When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.
         *
         */
        waiting_room?: boolean;
        /**
         * Specify the settings to be applied if waiting room is enabled.
         */
        waiting_room_settings?: {
          /**
           *
           *
           * Specify who should be admitted to the waiting room. The value of this field can be one of the following:<br>
           * `0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in
           */
          participants_to_place_in_waiting_room?: 0 | 1 | 2;
          /**
           * Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>
           * `0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).
           *
           *
           *
           */
          users_who_can_admit_participants_from_waiting_room?: number;
          /**
           * If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").
           */
          whitelisted_domains_for_waiting_room?: string;
        };
        /**
         * If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.
         *
         */
        webinar_password?: boolean;
      };
    };

export type AccountSettingsError = unknown;

export type AccountSettingsUpdateData = {
  body:
    | {
        /**
         * Account Settings: Notification.
         */
        email_notification?: {
          /**
           * Notify when an alternative host is set or removed from a meeting.
           */
          alternative_host_reminder?: boolean;
          /**
           * Notify the host and participants when a meeting is cancelled.
           */
          cancel_meeting_reminder?: boolean;
          /**
           * Notify host when cloud recording is available.
           */
          cloud_recording_avaliable_reminder?: boolean;
          /**
           * Notify the host when participants join the meeting before them.
           */
          jbh_reminder?: boolean;
          /**
           * Notify user when host licenses are running low.
           */
          low_host_count_reminder?: boolean;
          /**
           * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
           */
          schedule_for_reminder?: boolean;
        };
        /**
         * Account Settings: Feature.
         */
        feature?: {
          /**
           * Set the maximum number of participants a host can have in a single meeting.
           */
          meeting_capacity?: number;
        };
        /**
         * Account Settings: In Meeting.
         */
        in_meeting?: {
          /**
           * Identify guest participants in a meeting or webinar.
           */
          alert_guest_join?: boolean;
          /**
           * Allow live streaming.
           */
          allow_live_streaming?: boolean;
          /**
           * If the value of this field is set to `true`, meeting participants and webinar panelists can be allowed to rename themselves during a meeting or a webinar.
           *
           */
          allow_participants_to_rename?: boolean;
          /**
           * Show the Zoom desktop application when sharing screens.
           */
          allow_show_zoom_windows?: boolean;
          /**
           * Allow participants to use annotation tools to add information to shared screens.
           */
          annotation?: boolean;
          /**
           * Allow an anonymous Q&A in a webinar.
           */
          anonymous_question_answer?: boolean;
          /**
           * Allow host to put attendee on hold.
           *
           * **This field has been deprecated and is no longer supported.**
           */
          attendee_on_hold?: boolean;
          /**
           * Enable users to see and add contacts to the "auto-answer group" in the chat contact list. Any call from members of this group will automatically be answered.
           */
          auto_answer?: boolean;
          /**
           * Automatically save all in-meeting chats so that the host does not need to manually save the chat transcript after the meeting starts.
           */
          auto_saving_chat?: boolean;
          /**
           * Allow host to split meeting participants into separate, smaller rooms.
           */
          breakout_room?: boolean;
          /**
           * Allow meeting participants to send a message that is visible to all participants.
           */
          chat?: boolean;
          /**
           * Allow a host to type closed captions. Enable a host to assign a participant or third party device to add closed captions.
           */
          closed_caption?: boolean;
          /**
           * Allow the host to add co-hosts.
           */
          co_host?: boolean;
          /**
           * If set to `true`, account owners and admins on paid accounts can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to use for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.
           */
          custom_data_center_regions?: boolean;
          /**
           * Custom live streaming.
           */
          custom_live_streaming_service?: boolean;
          /**
           * Custom service instructions.
           */
          custom_service_instructions?: string;
          /**
           * If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).
           *
           */
          data_center_regions?: 'EU' | 'HK' | 'AU' | 'IN' | 'TY' | 'CN' | 'US' | 'CA';
          /**
           * DSCP audio.
           */
          dscp_audio?: number;
          /**
           * DSCP marking.
           */
          dscp_marking?: boolean;
          /**
           * DSCP video.
           */
          dscp_video?: number;
          /**
           * Zoom requires encryption for all data between the Zoom cloud, Zoom client, and Zoom Room. Require encryption for 3rd party endpoints (H323/SIP).
           */
          e2e_encryption?: boolean;
          /**
           * Play sound when participants join or leave.<br>`host` - Heard by host only.<br>`all` - Heard by host and all attendees.<br>`none` - Disable.
           */
          entry_exit_chime?: 'host' | 'all' | 'none';
          /**
           * Allow another user to take control of your camera during a meeting.
           */
          far_end_camera_control?: boolean;
          /**
           * Add a "Feedback" tab to the Windows Settings or Mac Preferences dialog. Enable users to provide feedback to Zoom at the end of the meeting.
           */
          feedback?: boolean;
          /**
           * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled on the account or not.
           */
          file_transfer?: boolean;
          /**
           * Activate higher quality video for host and participants.
           * Please note: This will use more bandwidth.
           */
          group_hd?: boolean;
          /**
           * Enable or disable meeting reactions. <br>
           * `true`: Allow meeting participants to communicate without interrupting by reacting with an emoji that shows on their video.<br>
           * `false`: Do not enable meeting reactions.
           */
          meeting_reactions?: boolean;
          /**
           * Allow users to select original sound in their client settings.
           */
          original_audio?: boolean;
          /**
           * Peer to peer connection while only two people are in a meeting.
           */
          p2p_connetion?: boolean;
          /**
           * Peer to peer listening ports range.
           */
          p2p_ports?: boolean;
          /**
           * Add "Polls" to the meeting controls.
           */
          polling?: boolean;
          /**
           * The listening ports range, separated by a comma (ex 55,56). The ports range must be between 1 to 65535.
           */
          ports_range?: string;
          /**
           * Display a thumbs up or down survey at the end of each meeting.
           */
          post_meeting_feedback?: boolean;
          /**
           * Allow a meeting participant to send a private message to another participant.
           */
          private_chat?: boolean;
          /**
           * Record and play their own voice.
           */
          record_play_own_voice?: boolean;
          /**
           * Allow users to request remote control.
           */
          remote_control?: boolean;
          /**
           * Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the account or not.
           */
          request_permission_to_unmute?: boolean;
          /**
           * Allow screen sharing.
           */
          screen_sharing?: boolean;
          /**
           * Only show the default email when sending email invites.
           */
          sending_default_email_invites?: boolean;
          /**
           * If the value of this field is set to `true`, you will allow participants to join a meeting directly from their browser and bypass the Zoom application download process. This is a workaround for participants who are unable to download, install, or run applications. Note that the meeting experience from the browser is limited.
           */
          show_a_join_from_your_browser_link?: boolean;
          /**
           * Always show the meeting control toolbar.
           */
          show_meeting_control_toolbar?: boolean;
          /**
           * Allow users to select stereo audio in their client settings.
           */
          stereo_audio?: boolean;
          /**
           * Use HTML formatted email for the Outlook plugin.
           */
          use_html_format_email?: boolean;
          /**
           * Allow users to replace their background with any selected image. Choose or upload an image in the Zoom desktop application settings.
           */
          virtual_background?: boolean;
          /**
           * Settings to manage virtual background.
           */
          virtual_background_settings?: {
            /**
             * Allow users to upload custom backgrounds.
             */
            allow_upload_custom?: boolean;
            /**
             * Allow use of videos for virtual backgrounds.
             */
            allow_videos?: boolean;
            /**
             * Enable virtual background.
             */
            enable?: boolean;
            files?: Array<{
              /**
               * Unique identifier of the file.
               */
              id?: string;
              /**
               * Indicates whether or not this file is the default virtual background file.
               */
              is_default?: boolean;
              /**
               * File name.
               */
              name?: string;
              /**
               * File size.
               */
              size?: string;
              /**
               * File type.
               */
              type?: string;
            }>;
          };
          /**
           * Add a watermark when viewing a shared screen.
           */
          watermark?: boolean;
          /**
           * Allow a Q&A in a webinar.
           */
          webinar_question_answer?: boolean;
          /**
           * Allow participants to share a whiteboard that includes annotation tools.
           */
          whiteboard?: boolean;
          /**
           * Indicates who can share their screen or content during meetings. The value can be one of the following: <br>
           * `host`: Only host can share the screen.<br>
           * `all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
           *
           */
          who_can_share_screen?: 'host' | 'all';
          /**
           * Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>
           * `host`: Only a host can share the screen when someone else is sharing.<br>
           * `all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
           *
           */
          who_can_share_screen_when_someone_is_sharing?: 'host' | 'all';
          /**
           * Workplace by facebook.
           */
          workplace_by_facebook?: boolean;
        };
        /**
         * Account Settings: Integration.
         */
        integration?: {
          /**
           * Enable users who join a meeting from their mobile device to share content from their Box account.
           */
          box?: boolean;
          /**
           * Enable users who join a meeting from their mobile device to share content from their Dropbox account.
           */
          dropbox?: boolean;
          /**
           * Enable meetings to be scheduled using Google Calendar.
           */
          google_calendar?: boolean;
          /**
           * Enable users who join a meeting from their mobile device to share content from their Google Drive.
           */
          google_drive?: boolean;
          /**
           * Enable users to control a connected Kubi device from within a Zoom meeting.
           */
          kubi?: boolean;
          /**
           * Enable users who join a meeting from their mobile device to share content from their Microsoft OneDrive account.
           */
          microsoft_one_drive?: boolean;
        };
        profile?: {
          recording_storage_location?: {
            /**
             * Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.
             *
             * Provide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.
             */
            allowed_values?: Array<string>;
            /**
             * Abbreviated country code.
             */
            value?: string;
          };
        };
        /**
         * Account Settings: Recording.
         */
        recording?: {
          /**
           * Cloud recordings are only accessible to account members. People outside of your organization cannot open links that provide access to cloud recordings.
           */
          account_user_access_recording?: boolean;
          /**
           * Allow recovery of deleted cloud recordings from trash.
           * If the value of this field is set to `true`, deleted cloud recordings will be kept in trash for 30 days after deletion and can be recovered within that period.
           */
          allow_recovery_deleted_cloud_recordings?: boolean;
          /**
           * [Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted with archiving solution access by the Zoom support team.
           */
          archive?: {
            /**
             * Enable the archiving feature.
             */
            enable?: boolean;
            settings?: {
              /**
               * Include in-meeting and/or in-webinar audio in the archive.
               */
              audio_file?: boolean;
              /**
               * Include closed caption or transcript in the archive.
               */
              cc_transcript_file?: boolean;
              /**
               * Include in-meeting chat in the archive.
               */
              chat_file?: boolean;
              /**
               * Include user email in in-meeting chat file.
               */
              chat_with_sender_email?: boolean;
              /**
               * Include in-meeting and/or in-webinar video in the archive.
               */
              video_file?: boolean;
            };
            /**
             * Archive types:
             *
             * * `1`: Only meetings are archived.<br>
             * * `2`: Only webinars are archived.<br>
             * * `3`: Both meetings and webinars are archived.
             */
            type?: 1 | 2 | 3;
          };
          /**
           * Allow Zoom to permanantly delete recordings automatically after a specified number of days.
           */
          auto_delete_cmr?: boolean;
          /**
           * When `auto_delete_cmr` function is 'true' this value will set the number of days before the auto deletion of cloud recordings.
           */
          auto_delete_cmr_days?: number;
          /**
           * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
           */
          auto_recording?: 'local' | 'cloud' | 'none';
          /**
           * Allow hosts to record and save the meeting in the cloud.
           */
          cloud_recording?: boolean;
          /**
           * Cloud recording downloads.
           */
          cloud_recording_download?: boolean;
          /**
           * Only the host can download cloud recordings.
           */
          cloud_recording_download_host?: boolean;
          /**
           * If the value of this field is set to `true`, hosts will be able to delete the recordings. If this option is set to `false`, the recordings cannot be deleted by the host and only admin can delete them.
           *
           */
          host_delete_cloud_recording?: boolean;
          /**
           * Setting to allow cloud recording access only from specific IP address ranges.
           *
           */
          ip_address_access_control?: {
            /**
             * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
             *
             *
             */
            enable?: boolean;
            /**
             * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
             *
             * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
             *
             *
             */
            ip_addresses_or_ranges?: string;
          };
          /**
           * Allow hosts and participants to record the meeting using a local file.
           */
          local_recording?: boolean;
          /**
           * If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.
           *
           */
          prevent_host_access_recording?: boolean;
          /**
           * Record an audio only file.
           */
          record_audio_file?: boolean;
          /**
           * Record the gallery view with a shared screen.
           */
          record_gallery_view?: boolean;
          /**
           * Record the active speaker with a shared screen.
           */
          record_speaker_view?: boolean;
          /**
           * Automatically transcribe the audio of the meeting or webinar to the cloud.
           */
          recording_audio_transcript?: boolean;
          /**
           * Show a disclaimer to participants before a recording starts
           *
           */
          recording_disclaimer?: boolean;
          /**
           * This object represents the minimum password requirements set for recordings via Account Recording Settings.
           */
          recording_password_requirement?: {
            /**
             * Indicates whether or not password must contain at least one alphabetical letter (a, b, c..).
             */
            have_letter?: boolean;
            /**
             * Indicates whether or not password must contain at least one number(1, 2, 3..).
             */
            have_number?: boolean;
            /**
             * Indicates whether or not password must contain at least one special character(!, @, #..).
             */
            have_special_character?: boolean;
            /**
             * Minimum required length for the password.
             */
            length?: number;
            /**
             * Indicates whether or not password must contain only numeric characters.
             */
            only_allow_numeric?: boolean;
          };
          /**
           * Require a passcode to access existing cloud recordings.
           */
          required_password_for_existing_cloud_recordings?: boolean;
          /**
           * Save the chat text from the meeting.
           */
          save_chat_text?: boolean;
          /**
           * Add a timestamp to the recording.
           */
          show_timestamp?: boolean;
        };
        /**
         * Account Settings: Schedule Meeting.
         */
        schedule_meeting?: {
          /**
           * Determine how participants can join the audio portion of the meeting.<br>`both` - Telephony and VoIP.<br>`telephony` - Audio PSTN telephony only.<br>`voip` - VoIP only.<br>`thirdParty` - 3rd party audio conference.
           */
          audio_type?: 'both' | 'telephony' | 'voip' | 'thirdParty';
          /**
           * Only Zoom users who are signed in can join meetings.
           */
          enforce_login?: boolean;
          /**
           * Only signed in users with a specified domain can join the meeting.
           */
          enforce_login_domains?: string;
          /**
           * Only signed in users with a specific domain can join meetings.
           */
          enforce_login_with_domains?: boolean;
          /**
           * Require a password for Personal Meetings if attendees can join before host.
           */
          force_pmi_jbh_password?: boolean;
          /**
           * Start meetings with the host video on.
           */
          host_video?: boolean;
          /**
           * Allow participants to join the meeting before the host arrives.
           */
          join_before_host?: boolean;
          /**
           * Account wide meeting/webinar [password requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
           */
          meeting_password_requirement?: {
            consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
            /**
             * If set to `true`, the password must contain at least 1 letter (such as a,b,c...).
             *
             */
            have_letter?: boolean;
            /**
             * If set to `true`, the password must contain at least 1 number (such as 1,2,3...).
             */
            have_number?: boolean;
            /**
             * If set to `true`, the password must have at least 1 special character (!,@,#...).
             */
            have_special_character?: boolean;
            /**
             * If set to `true`, the password must include both uppercase and lowercase characters.
             */
            have_upper_and_lower_characters?: boolean;
            /**
             * The minimum length that the meeting/webinar password needs to have.
             */
            length?: number;
            /**
             * If set to `true`, the password must only contain numbers and no other characters.
             */
            only_allow_numeric?: boolean;
            /**
             * If set to `true`, users will be informed if the provided password is weak.
             */
            weak_enhance_detection?: boolean;
          };
          /**
           * Always display "Zoom Meeting" as the meeting topic.
           */
          not_store_meeting_topic?: boolean;
          /**
           * Start meetings with the participant video on. Participants can change this setting during the meeting.
           */
          participant_video?: boolean;
          /**
           * Personal Meeting Setting.<br><br>
           * `true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>
           * `false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.
           * For Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.
           *
           *
           *
           */
          personal_meeting?: boolean;
          /**
           * Require a password for instant meetings. If you use PMI for your instant meetings, this option will be disabled. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
           *
           */
          require_password_for_instant_meetings?: boolean;
          /**
           * Require a password for a meeting held using Personal Meeting ID (PMI) This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
           *
           */
          require_password_for_pmi_meetings?: 'jbh_only' | 'all' | 'none';
          /**
           * Require a password for meetings which have already been scheduled
           *
           */
          require_password_for_scheduled_meetings?: boolean;
          /**
           * Require a password when scheduling new meetings. This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting. This setting is always enabled for free accounts and Pro accounts with a single host and cannot be modified for these accounts.
           */
          require_password_for_scheduling_new_meetings?: boolean;
          /**
           * Use Personal Meeting ID (PMI) when starting an instant meeting
           *
           */
          use_pmi_for_instant_meetings?: boolean;
          /**
           * Use Personal Meeting ID (PMI) when scheduling a meeting
           *
           */
          use_pmi_for_scheduled_meetings?: boolean;
        };
        /**
         * [Security settings](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) of an Account.
         */
        security?: {
          /**
           * Only account administrators can change a user's username and picture.
           */
          admin_change_name_pic?: boolean;
          /**
           * Hide billing information.
           */
          hide_billing_info?: boolean;
          /**
           * Allow users to import photos from a photo library on a  device.
           */
          import_photos_from_devices?: boolean;
          /**
           * This object refers to the [enhanced password rules](https://support.zoom.us/hc/en-us/articles/360034675592-Advanced-security-settings#h_bf8a25f6-9a66-447a-befd-f02ed3404f89) that allows Zoom account admins and owners to apply extra requiremets to the users' Zoom login password.
           */
          password_requirement?: {
            /**
             *
             * Specify the max length of consecutive characters(abcde...) that can be used in a password.
             * If you set the value of this field to `0`, no restriction will be applied on consecutive characters.
             *
             * If you would like to set this restriction, you can specify a number between 4 and 8 that define the maximum allowed length for consecutive characters in a password.
             *
             * The max allowed length will be `n-1` where `n` refers to the value you provide for this field.  For instance, if you provide `4` as the value, there can only be a maximum of `3` consecutive characters in a password(example: abc1x@8fdh).
             */
            consecutive_characters_length?: number;
            /**
             * If the value of this field is set to `true`, the password must have at least one special character(!, @, #...).
             */
            have_special_character?: boolean;
            /**
             * Specify a minimum length for the password. The password length can be from a minimum of 9 characters, up to 14 characters. If you provide `0` as the value of this field, this field will be disabled and not be used and the basic password length requirement (minimum of 8 characters) will be applied for the requirement.
             */
            minimum_password_length?: number;
            /**
             * If the value of this field is set to `true`, user passwords will have to pass detection through a weak password dictionary in case hackers use simple passwords to sign in to your users’ accounts.
             */
            weak_enhance_detection?: boolean;
          };
          /**
           * Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Client app after a set amount of time. <br>
           *
           * If this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Client. The value for the period of inactivity can be one of the following:<br>
           *
           * `5`: 5 minutes<br>
           * `10`: 10 minutes<br>
           * `15`: 15 minutes<br>
           * `30`: 30 minutes<br>
           * `45`: 45 minutes<br>
           * `60`: 60 minutes<br>
           * `90`: 90 minutes<br>
           * `120`: 120 minutes
           *
           */
          sign_again_period_for_inactivity_on_client?: number;
          /**
           * Settings for User Sign In interval requirements after a period of inactivity. If enabled, this setting forces automatic logout of users in Zoom Web Portal after a set amount of time. <br>
           *
           * If this setting is disabled, the value of this field will be `0`. If the setting is enabled, the value of this field will indicate the **period of inactivity** in minutes after which, an inactive user will be automatically logged out of the Zoom Web Portal. The value for the period of inactivity can be one of the following:<br>
           *
           * `5`: 5 minutes<br>
           * `10`: 10 minutes<br>
           * `15`: 15 minutes<br>
           * `30`: 30 minutes<br>
           * `60`: 60 minutes<br>
           * `120`: 120 minutes
           *
           *
           *
           *
           */
          sign_again_period_for_inactivity_on_web?: number;
          /**
           * Settings for 2FA( [two factor authentication](https://support.zoom.us/hc/en-us/articles/360038247071) ). The value can be one of the following:
           * `all`: Two factor authentication will be enabled for all users in the account.<br>
           * `none`: Two factor authentication is disabled.<br>
           * `group`: Two factor authentication will be enabled for users belonging to specific groups. If 2FA is enabled for certain groups, the group IDs of the group(s) will be provided in the `sign_in_with_two_factor_auth_groups` field.<br>
           * `role`: Two factor authentication will be enabled only for users assigned with specific roles in the account. If 2FA is enabled for specific roles, the role IDs will be provided in the
           * `sign_in_with_two_factor_auth_roles` field.
           *
           */
          sign_in_with_two_factor_auth?: 'all' | 'group' | 'role' | 'none';
          /**
           * This field contains group IDs of groups that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `group`
           */
          sign_in_with_two_factor_auth_groups?: Array<string>;
          /**
           * This field contains role IDs of roles that have 2FA enabled. This field is only returned if the value of `sign_in_with_two_factor_auth` is `role`.
           */
          sign_in_with_two_factor_auth_roles?: Array<string>;
        };
        /**
         * Account Settings Update: Telephony.
         */
        telephony?: {
          /**
           * Third party audio conference info.
           */
          audio_conference_info?: string;
          /**
           * Indicates where most of the participants call into or call from duriing a meeting.
           */
          telephony_regions?: {
            /**
             * Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.
             */
            selection_values?: Array<string>;
          };
          /**
           * Users can join the meeting using the existing third party audio configuration.
           */
          third_party_audio?: boolean;
        };
        /**
         * Account Settings: TSP.
         */
        tsp?: {
          /**
           * Call Out
           */
          call_out?: boolean;
          /**
           * Call Out Countries/Regions
           */
          call_out_countries?: Array<unknown>;
          /**
           * Display toll-free numbers
           */
          display_toll_free_numbers?: boolean;
          /**
           * Show international numbers link on the invitation email
           */
          show_international_numbers_link?: boolean;
        };
        /**
         * Account Settings: Zoom Rooms.
         */
        zoom_rooms?: {
          /**
           * Automatic start and stop for scheduled meetings.
           */
          auto_start_stop_scheduled_meetings?: boolean;
          /**
           * Cloud recording for instant meetings.
           */
          cmr_for_instant_meeting?: boolean;
          /**
           * Shift all meetings to private.
           */
          force_private_meeting?: boolean;
          /**
           * Hide host and meeting ID from private meetings.
           */
          hide_host_information?: boolean;
          /**
           * Display meeting list with calendar integration.
           */
          list_meetings_with_calendar?: boolean;
          /**
           * Start AirPlay service manually.
           */
          start_airplay_manually?: boolean;
          /**
           * Automatic direct sharing using an ultrasonic proximity signal.
           */
          ultrasonic?: boolean;
          /**
           * Upcoming meeting alert.
           */
          upcoming_meeting_alert?: boolean;
          /**
           * Weekly system restart.
           */
          weekly_system_restart?: boolean;
          /**
           * Zoom Room post meeting feedback.
           */
          zr_post_meeting_feedback?: boolean;
        };
      }
    | (
        | {
            /**
             * Meeting Authentication Options
             */
            authentication_option?: {
              /**
               * Specify the action that you would like to take via this API request:<br>
               * * `add` : Choose this value if you are adding an authentication option.
               * * `update`: Choose this value if you are updating an existing authentication option.
               * * `delete`: Choose this value if you are deleting an existing authentication option.
               */
              action?: 'update' | 'delete' | 'add';
              /**
               * Specify whether you would like to set this authentication option as the default option or not.
               */
              default_option?: boolean;
              /**
               * If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to join your meetings or webinars.
               */
              domains?: string;
              /**
               *  Authentication ID. If you are creating an authentication profile, you do not need to provide this field. The id field will be generated in the response once this API request is completed successfully. You can also use the Get Account Settings API with query parameter set to `meeting_authentication` to list the authentication id.<br><br>
               * Use this field or the `name` field to identify the associated authentication option that you would like to update or delete.
               */
              id?: string;
              /**
               * Unique name for the authentication option.
               */
              name?: string;
              /**
               *  Authentication type. Specify one of the following authentication types for the authentication profile:<br>
               * * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.
               * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>
               * * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.
               */
              type?: 'enforce_login' | 'enforce_login_with_same_account' | 'enforce_login_with_domains';
            };
            /**
             * If set to "true", only authenticated users can join meetings. The method for authentication can be defined in the "authentication_option".
             */
            meeting_authentication?: boolean;
          }
        | {
            /**
             * Specify the authentication options for this account.
             */
            authentication_option?: {
              /**
               * Specify the action that you would like to take via this API request:<br>
               * * `add` : Choose this value if you are adding an authentication option.
               * * `update`: Choose this value if you are updating an existing authentication option.
               * * `delete`: Choose this value if you are deleting an existing authentication option.
               */
              action?: 'update' | 'delete' | 'add';
              /**
               * Specify whether you would like to set this authentication option as the default option or not.
               */
              default_option?: boolean;
              /**
               * If you chose `enforce_login_with_domains` as the authentication type, specify the domain(s) that you want to allow to view the recordings.
               */
              domains?: string;
              /**
               *  Authentication ID. If you are creating an authentication profile, you do not need to provide this field. The id field will be generated in the response once this API request is completed successfully. You can also use the Get Account Settings API with query parameter set to `meeting_authentication` to list the authentication id.<br><br>
               * Use this field or the `name` field to identify the associated authentication option that you would like to update or delete.
               */
              id?: string;
              /**
               * Unique name for the authentication option.
               */
              name?: string;
              /**
               * Specify one authentication type that is to be associated with this authentication configuration:<br>
               * * `internally`: This option allows you specify a rule that only signed in users within your account can view the recording.<br>
               * * `enforce_login`: This option allows any users to view the recording, as long as they are signed into their Zoom account.<br>
               * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can view the recording. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.
               *
               *
               */
              type?: 'internally' | 'enforce_login' | 'enforce_login_with_domains';
            };
            /**
             * If set to `true`, only authenticated users can view the cloud recordings.<br><br>
             * The authentication profile **must first be set at the account level via the account settings**, and later can be disabled after enabling on the preferred level - i.e. user level using user settings or at group level via group settings  (if you do not want the settings to be enabled on the entire account).
             */
            recording_authentication?: boolean;
          }
      )
    | {
        meeting_security?: {
          /**
           * `true`: Require that all meetings are secured with at least one security option.
           *
           * This setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).
           */
          auto_security?: boolean;
          /**
           * If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.
           *
           */
          embed_password_in_join_link?: boolean;
          /**
           * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
           * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
           *
           * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
           */
          encryption_type?: 'enhanced_encryption' | 'e2ee';
          /**
           * Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.
           */
          end_to_end_encrypted_meetings?: boolean;
          /**
           * If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.
           */
          meeting_password?: boolean;
          /**
           * Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
           */
          meeting_password_requirement?: {
            consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
            /**
             * If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).
             *
             */
            have_letter?: boolean;
            /**
             * If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).
             */
            have_number?: boolean;
            /**
             * If set to `true`, the passcode must have at least 1 special character (!,@,#...).
             */
            have_special_character?: boolean;
            /**
             * If set to `true`, the passcode must include both uppercase and lowercase characters.
             */
            have_upper_and_lower_characters?: boolean;
            /**
             * The minimum length that the meeting/webinar passcode needs to have.
             */
            length?: number;
            /**
             * If set to `true`, the passcode must only contain numbers and no other characters.
             */
            only_allow_numeric?: boolean;
            /**
             * If set to `true`, users will be informed if the provided passcode is weak.
             */
            weak_enhance_detection?: boolean;
          };
          /**
           * Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.
           */
          phone_password?: boolean;
          /**
           * If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.
           *
           */
          pmi_password?: boolean;
          /**
           * Require a passcode for meetings which have already been scheduled.
           *
           */
          require_password_for_scheduled_meeting?: boolean;
          /**
           * Require a passcode for webinars which have already been scheduled.
           *
           */
          require_password_for_scheduled_webinar?: boolean;
          /**
           * When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.
           *
           */
          waiting_room?: boolean;
          /**
           * Specify the settings to be applied if waiting room is enabled.
           */
          waiting_room_settings?: {
            /**
             *
             *
             * Specify who should be admitted to the waiting room. The value of this field can be one of the following:<br>
             * `0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in
             */
            participants_to_place_in_waiting_room?: 0 | 1 | 2;
            /**
             * Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>
             * `0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).
             *
             *
             *
             */
            users_who_can_admit_participants_from_waiting_room?: number;
            /**
             * If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").
             */
            whitelisted_domains_for_waiting_room?: string;
          };
          /**
           * If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.
           *
           */
          webinar_password?: boolean;
        };
      };
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
  query?: {
    option?: 'meeting_authentication' | 'recording_authentication' | 'security' | 'meeting_security';
  };
};

export type AccountSettingsUpdateResponse = unknown | any;

export type AccountSettingsUpdateError = unknown;

export type DelVbData = {
  path: {
    accountId: string;
  };
  query?: {
    /**
     * Provide the id of the file that is to be deleted. To delete multiple files, provide comma separated values for this field.
     */
    file_ids?: string;
  };
};

export type DelVbResponse = any;

export type DelVbError = unknown;

export type UploadVbData = {
  body?: {
    /**
     * Provide the file's path here.
     */
    file?: string;
  };
  path: {
    /**
     * Unique identifier of the account.
     */
    accountId: string;
  };
};

export type UploadVbResponse = {
  /**
   * Unique identifier of the file.
   */
  id?: string;
  /**
   * Indicates whether or not this file is the default virtual background file.
   */
  is_default?: boolean;
  /**
   * File name.
   */
  name?: string;
  /**
   * File size.
   */
  size?: string;
  /**
   * File type.
   */
  type?: string;
};

export type UploadVbError = unknown;

export type ListInternalCalloutCountriesData = {
  path: {
    /**
     * Unique identifier of the account. To list Call-out enabled countries to a sub account, provide the account ID of the sub account in the `accountId` path parameter. To list Call-out enabled countries of a sub account, provide the account ID of the sub account in the `accountId` path parameter. To list Call-out enabled countries of a master account, provide `me` as the value of the `accountId` path parameter.
     */
    accountId: string;
  };
};

export type ListInternalCalloutCountriesResponse = {
  callout_countries?: Array<{
    /**
     * Country code.
     */
    code?: string;
    /**
     * Two letter country Id.
     */
    id?: string;
    /**
     * Name of the country.
     */
    name?: string;
  }>;
  /**
   * The total number of records returned.
   */
  total_records?: number;
};

export type ListInternalCalloutCountriesError = unknown;

export type AddCalloutCountriesData = {
  body?: {
    /**
     * List of callout countries.
     */
    callout_countries: Array<{
      /**
       * Two letter country code of the  call-out country.
       */
      id: string;
    }>;
  };
  path: {
    /**
     * Unique identifier of the account. To add Call-out enabled countries to a sub account, provide the account ID of the sub account in the `accountId` path parameter. To add Call-out enabled countries to a master account, provide `me` as the value of the `accountId` path parameter.
     */
    accountId: string;
  };
};

export type AddCalloutCountriesResponse = {
  /**
   * List of Call-out countries.
   */
  callout_countries?: Array<{
    /**
     * Country code for Phone number.
     */
    code?: string;
    /**
     * Country ID.
     */
    id?: string;
    /**
     * Name of the country.
     */
    name?: string;
  }>;
};

export type AddCalloutCountriesError = unknown;

export type DeleteInternalCallOutCountryData = {
  path: {
    /**
     * Unique Identifier of the Account.<br>
     * To remove Call-out country from a sub account, provide the account ID of the sub account in the `accountId` path parameter. To remove Call-out country from a master account, provide `me` as the value of the `accountId` path parameter.
     */
    accountId: string;
    /**
     * Two lettered Id of the country.
     */
    countryId: string;
  };
};

export type DeleteInternalCallOutCountryResponse = unknown;

export type DeleteInternalCallOutCountryError = unknown;

export type ListInternalNumbersData = {
  path: {
    /**
     * Unique identifier of the account. To list internal numbers of a sub account, provide the account ID of the sub account in the `accountId` path parameter. To list internal numbers of a  master account, provide `me` as the value of the `accountId` path parameter.
     */
    accountId: string;
  };
  query?: {
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     * The number of records returned within a single API call.
     */
    page_size?: number;
  };
};

export type ListInternalNumbersResponse = {
  internal_numbers?: Array<{
    /**
     * Control whether the number can be used to attend 3rd party meetings.
     */
    allow_for_external_meetings?: boolean;
    /**
     * Specify whether this number can be used by users to join a meeting or not. <br>
     * * `true` : This number can be used to join a meeting. <br>
     * *  `false`: This number can not be used to join a meeting.
     *
     * Note that if the value of `visible` field is set to `true`, the value of this field will always be `true`.
     */
    allow_join?: boolean;
    /**
     * Two letter country code of the country.
     */
    country: string;
    /**
     * Phone number with display format. For instance, if the value in the number field is `+1888888000`, the value of this field could be `+1 888 888 000`.
     */
    display_number: string;
    /**
     * A short description for the phone number.
     */
    labels: string;
    /**
     * Specify the language in which this phone number should be displayed. Currently, the only supported languages are `en-GB`, `en-US`, `de-DE`.
     */
    languages: 'en-GB' | 'en-US' | 'de-DE';
    /**
     * Phone number in E164 format.
     */
    number: string;
    /**
     * Type of phone number. <br>
     * The value can be one of the following:<br>
     * * `0` : toll <br>
     * * `1` : tollfree
     */
    type: 0 | 1;
    /**
     * Specify whether you want this number to be visible (in Zoom Client and Zoom Portal) to the account users or not. The value could be one of the following:<br>
     * * `true`: Make the number visible. <br>
     * * `false`: Hide the number.
     */
    visible?: boolean;
  }>;
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of records that you specified to get in the response per page.
   */
  page_size?: number;
  /**
   * The total number of records returned.
   */
  total_records?: number;
};

export type ListInternalNumbersError = unknown;

export type AddInternalNumbersData = {
  body?: {
    internal_numbers?: Array<{
      /**
       * Control whether the number can be used to attend 3rd party meetings.
       */
      allow_for_external_meetings?: boolean;
      /**
       * Specify whether this number can be used by users to join a meeting or not. <br>
       * * `true` : This number can be used to join a meeting. <br>
       * *  `false`: This number can not be used to join a meeting.
       *
       * Note that if the value of `visible` field is set to `true`, the value of this field will always be `true`.
       */
      allow_join?: boolean;
      /**
       * Two letter country code of the country.
       */
      country: string;
      /**
       * Phone number with display format. For instance, if the value in the number field is `+1888888000`, the value of this field could be `+1 888 888 000`.
       */
      display_number: string;
      /**
       * A short description for the phone number.
       */
      labels: string;
      /**
       * Specify the language in which this phone number should be displayed. Currently, the only supported languages are `en-GB`, `en-US`, `de-DE`.
       */
      languages: 'en-GB' | 'en-US' | 'de-DE';
      /**
       * Phone number in E164 format.
       */
      number: string;
      /**
       * Type of phone number. <br>
       * The value can be one of the following:<br>
       * * `0` : toll <br>
       * * `1` : tollfree
       */
      type: 0 | 1;
      /**
       * Specify whether you want this number to be visible (in Zoom Client and Zoom Portal) to the account users or not. The value could be one of the following:<br>
       * * `true`: Make the number visible. <br>
       * * `false`: Hide the number.
       */
      visible?: boolean;
    }>;
  };
  path: {
    /**
     * Unique identifier of the account.<br>To add internal numbers to a sub account, provide the account ID of the sub account in the `accountId` path parameter. To add internal numbers to a master account, provide `me` as the value of the `accountId` path parameter.
     */
    accountId: string;
  };
};

export type AddInternalNumbersResponse = {
  internal_numbers?: Array<{
    /**
     * Control whether the number can be used to attend 3rd party meetings.
     */
    allow_for_external_meetings?: boolean;
    /**
     * Specify whether this number can be used by users to join a meeting or not. <br>
     * * `true` : This number can be used to join a meeting. <br>
     * *  `false`: This number can not be used to join a meeting.
     *
     * Note that if the value of `visible` field is set to `true`, the value of this field will always be `true`.
     */
    allow_join?: boolean;
    /**
     * Two letter country code of the country.
     */
    country: string;
    /**
     * Phone number with display format. For instance, if the value in the number field is `+1888888000`, the value of this field could be `+1 888 888 000`.
     */
    display_number: string;
    /**
     * Unique identifier of the internal number.
     */
    id?: string;
    /**
     * A short description for the phone number.
     */
    labels: string;
    /**
     * Specify the language in which this phone number should be displayed. Currently, the only supported languages are `en-GB`, `en-US`, `de-DE`.
     */
    languages: 'en-GB' | 'en-US' | 'de-DE';
    /**
     * Phone number in E164 format.
     */
    number: string;
    /**
     * Type of phone number. <br>
     * The value can be one of the following:<br>
     * * `0` : toll <br>
     * * `1` : tollfree
     */
    type: 0 | 1;
    /**
     * Specify whether you want this number to be visible (in Zoom Client and Zoom Portal) to the account users or not. The value could be one of the following:<br>
     * * `true`: Make the number visible. <br>
     * * `false`: Hide the number.
     */
    visible?: boolean;
  }>;
};

export type AddInternalNumbersError = unknown;

export type DeleteInternalNumberData = {
  path: {
    /**
     * Unique Identifier of the account. To delete an internal number from a sub account, provide the account ID of the sub account in the `accountId` path parameter. To delete an internal number from a master account, provide `me` as the value of the `accountId` path parameter.
     */
    accountId: string;
    /**
     * Unique identifier of the phone number. This value can be retrieved by calling the List Internal Numbers API.
     */
    numberId: string;
  };
};

export type DeleteInternalNumberResponse = unknown;

export type DeleteInternalNumberError = unknown;

export type DeleteAllSipNumbersData = {
  path: {
    /**
     * Account ID of the sub account from which the numbers are to be deleted. This can be retrieved from [List sub accounts](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/account) API.
     */
    accountId: string;
  };
};

export type DeleteAllSipNumbersResponse = unknown;

export type DeleteAllSipNumbersError = unknown;

export type AssignSipTrunkNumbersData = {
  body?: {
    /**
     * Phone number(s) to be assigned to the sub account.
     */
    phone_numbers?: Array<string>;
  };
  path: {
    /**
     * Unique Identifier of the sub account.
     */
    accountId: string;
  };
};

export type AssignSipTrunkNumbersResponse = unknown;

export type AssignSipTrunkNumbersError = unknown;

export type AssignSipConfigData = {
  body?: {
    /**
     * Enable or delete the configuration.<br> The values can be one of the following:<br> `true`: Enable configuration.<br> `false`: Delete configuration
     */
    enable?: boolean;
    /**
     * If the value of this option is set to `true`, the call-out numbers provided by the Zoom carrier partners will be displayed in the account's list of available call-out numbers in the Zoom Web Portal and Zoom Client.
     */
    show_callout_internal_number?: boolean;
    /**
     * If the value of this option is set to `0`, the call-out countries list provided by Zoom will be [displayed](https://support.zoom.us/hc/en-us/articles/200942859-Using-telephone-call-out) in the account's list of available call-out countries.
     *
     * If the value of this option is set to `1`, the Zoom provided call-out countries will be hidden from the user's account.<br>
     *
     * If the value of this option is set to `2`, all Zoom provided countries will be deleted and only internal countries (provided by carrier partners) will be used.
     */
    show_zoom_provided_callout_countries?: number;
    /**
     * If the value of this option is set to `0`, the numbers provided by Zoom will be displayed in the account's list of available call-out and call-in numbers in the Zoom Web Portal and Zoom Client.
     *
     * If the value of this option is set to `1`, the Zoom provided numbers will be shown in the Zoom Web Portal but will not be used unless specified by the user.<br>
     *
     * If the value of this option is set to `2`, all Zoom provided numbers will be deleted and only internal numbers (provided by carrier partners) will be used.
     */
    show_zoom_provided_numbers?: 0 | 1 | 2;
  };
  path: {
    accountId: string;
  };
};

export type AssignSipConfigResponse = unknown;

export type AssignSipConfigError = unknown;

export type ListSipTrunksData = {
  path: {
    /**
     * Unique Identifier of the Account. To retrieve SIP trunks assigned to a sub account, provide the account ID of the sub account in the as the value of this field. To retrieve SIP trunks of a master account, provide `me` as the value of this field.
     */
    accountId: string;
  };
};

export type ListSipTrunksResponse = {
  sip_trunks?: Array<{
    /**
     * DNIS of the SIP trunk.
     */
    dnis?: string;
    /**
     * Unique identifier of the sip trunk.
     */
    id?: string;
    /**
     * Name assigned to the SIP trunk.
     */
    name?: string;
    /**
     * Prefix of the SIP Connected Audio phone number.
     */
    number_prefix?: string;
    /**
     * Outbound caller Id assigned to the trunk.
     */
    outbound_caller_id?: string;
    /**
     * IP address or domain of the SIP trunk.
     */
    sip_server_address?: string;
  }>;
  /**
   * Total number of records returned.
   */
  total_records?: number;
};

export type ListSipTrunksError = unknown;

export type AssignSipTrunksData = {
  body?: {
    /**
     * Array of one or more SIP Trunk objects.
     */
    sip_trunks?: Array<{
      /**
       * DNIS of the sub account. The prefix of the DNIS (i.e. the first five digits of the DNIS value) must match the DNIS prefix of the master account. To retrieve the DNIS prefix of a master account's SIP Trunk, use the List SIP Trunks API and refer to the first five digits in the `dnis` value.
       *
       * For example, if the DNIS of the master account is 1888812345, the DNIS of the sub account must comprise of "18888" + "random_number". The maximum allowed length of the DNIS is 8.
       */
      dnis?: string;
      /**
       * Unique identifier of the SIP trunk that will be assigned to the sub account. The value of this field can be retrieved by listing the SIP Trunks of a master account using List SIP Trunks API.
       */
      id?: string;
      /**
       * Assign an outbound caller Id to the trunk.
       */
      outbound_caller_id?: string;
    }>;
  };
  path: {
    /**
     * Unique Identifier of the sub account.
     */
    accountId: string;
  };
};

export type AssignSipTrunksResponse = {
  sip_trunks?: Array<{
    /**
     * DNIS - identifier for the SIP trunk enabled account.
     */
    dnis?: string;
    /**
     * Unique identifier of the SIP trunk.
     */
    id?: string;
    /**
     * Name of the SIP trunk.
     */
    name?: string;
    /**
     * If the value of this field is `"0"`, it means that all the calls will be routed through this special line. All other values indicate the prefix of the phone number.
     */
    number_prefix?: string;
    /**
     * IP Address or domain of the SIP trunk.
     */
    sip_server_address?: string;
  }>;
};

export type AssignSipTrunksError = unknown;

export type DeleteSipTrunkData = {
  path: {
    /**
     * Unique identifier of the sub account.
     */
    accountId: string;
    /**
     * Unique identifier of the SIP Trunk that was previously assigned to a sub account. To retrieve the value of this field, use the List SIP Trunks API.
     */
    trunkId: string;
  };
};

export type DeleteSipTrunkResponse = {
  [key: string]: unknown;
};

export type DeleteSipTrunkError = unknown;

export type AccountTrustedDomainData = {
  path: {
    /**
     * The account ID.
     */
    accountId: string;
  };
};

export type AccountTrustedDomainResponse = {
  /**
   * List of trusted domains
   */
  trusted_domains?: Array<string>;
};

export type AccountTrustedDomainError = unknown;

export type SwitchUserAccountData = {
  body?: {
    /**
     * The Account ID of the account to which you would like move the user to.
     */
    account_id: string;
  };
  path: {
    accountId: string;
    userId: string;
  };
};

export type SwitchUserAccountResponse = unknown;

export type SwitchUserAccountError = unknown;

export type DownloadInvoicePdfData = {
  path: {
    invoiceId: string;
  };
};

export type DownloadInvoicePdfResponse = unknown;

export type DownloadInvoicePdfError = unknown;

export type ListArchivedFilesData = {
  query?: {
    /**
     * Start date for the query in "yyyy-MM-dd'T'HH:mm:ss'Z'" format. The duration for the query defined using the "from" and "to" parameters should not exceed 7 days as this API only provides a week's data at once.
     */
    from?: string;
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     * The number of records returned within a single API call.
     */
    page_size?: number;
    /**
     * Query data type for `from` and `to`.
     */
    query_data_type?: 'meeting_start_time' | 'archive_complete_time';
    /**
     * End date for the query in "yyyy-MM-dd'T'HH:mm:ss'Z'" format.
     */
    to?: string;
  };
};

export type ListArchivedFilesResponse = {
  /**
   * Start date for the query in "yyyy-MM-dd'T'HH:mm:ss'Z'" format. The duration for the query defined using the "from" and "to" parameters should not exceed 7 days as this API only provides a week's data at once.
   */
  from?: string;
  meetings?: Array<{
    archive_files?: Array<{
      /**
       * The URL using which the archived file can be downloaded. To download the archived file of a meeting or a webinar hosted in your account, create a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the access_token query parameter and include this query parameter at the end of the URL as shown in the example.
       *
       * Example: `https://{{base-domain}}/rec/archive/download/xxx?access_token={{Your-JWT}}`
       *
       * If a user has authorized and installed your OAuth app that supports archiving, use the user’s [OAuth access token](https://marketplace.zoom.us/docs/guides/auth/oauth) to download the file.
       *
       * Example: `https://{{base-domain}}/rec/archive/download/xxx?access_token={{ OAuth Access Token }}`
       */
      download_url?: string;
      /**
       * Extension of the recording file.
       *
       */
      file_extension?: string;
      /**
       * The recording file size.
       *
       */
      file_size?: number;
      /**
       * Recorded file type. The value of this field could be one of the following:
       *
       * `MP4`: Video file of the recording.<br>
       * `M4A`: Audio-only file of the recording.<br>
       * `TRANSCRIPT`: Transcription file of the recording in VTT format.
       * CHAT: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>
       * `CC`: File containing closed captions of the recording in VTT file format.<br>
       * `CSV`: File containing polling data in csv format.
       */
      file_type?: string;
      /**
       * Unique identifier of the archived file.
       *
       */
      id?: string;
      /**
       * The recording type. The value of this field can be one of the following:
       * * `shared_screen_with_speaker_view(CC)`
       * * `shared_screen_with_speaker_view`
       * * `shared_screen_with_gallery_view`
       * * `speaker_view`
       * * `gallery_view`
       * * `shared_screen`
       * * `audio_only`
       * * `audio_transcript`
       * * `chat_file`,
       * * `active_speaker`
       * * `host_video`
       *
       */
      recording_type?: string;
      /**
       * Status of the archived file.
       *
       */
      status?: string;
    }>;
    /**
     * Scheduled duration of the meeting or the webinar.
     */
    duration?: number;
    /**
     * ID of the user set as the host of meeting or the webinar that was archived.
     *
     */
    host_id?: string;
    /**
     * Unique identifier of the meeting(meetingId) or the webinar(webinarId).
     *
     */
    id?: number;
    /**
     * Number of recording files returned in the response of this API call.
     *
     */
    recording_count?: number;
    /**
     * The time at which the meeting or the webinar started.
     *
     */
    start_time?: string;
    /**
     * Timezone of the host.
     */
    timezone?: string;
    /**
     * Meeting or webinar topic.
     */
    topic?: string;
    /**
     * Total size of the archive.
     *
     */
    total_size?: number;
    /**
     * Type of the meeting or the webinar that was archived.<br>
     * <br>Meeting types:<br>
     * `1` - Instant meeting<br>
     * `2` - Scheduled meeting<br>
     * `3` - Recurring meeting with no fixed time<br>
     * 8 - Recurring meeting with fixed time
     *
     * Webinar types:<br>
     * `5` - Webinar<br>
     * `6` - Recurring webinar with no fixed time<br>
     * `9` - Recurring webinar with a fixed time
     *
     */
    type?: number;
    /**
     * Unique identifier of the meeting instance or the webinar instance during which the archiving took place. Each instance of the meeting will have its own UUID.
     *
     */
    uuid?: string;
  }>;
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of records returned within a single API call.
   */
  page_size?: number;
  /**
   * End date for the query in "yyyy-MM-dd'T'HH:mm:ss'Z'" format.
   */
  to?: string;
};

export type ListArchivedFilesError = unknown;

export type DeleteUserLevelChannelData = {
  path: {
    /**
     * Channel ID: Unique Identifier of a channel.
     */
    channelId: string;
  };
};

export type DeleteUserLevelChannelResponse = unknown;

export type DeleteUserLevelChannelError = unknown;

export type GetUserLevelChannelData = {
  path: {
    /**
     * Channel ID: Unique Identifier of a channel.
     */
    channelId: string;
  };
};

export type GetUserLevelChannelResponse = {
  /**
   * Channel Id.
   */
  id?: string;
  /**
   * Name of the channel.
   */
  name?: string;
  /**
   * Type of the channel. The value can be one of the following:<br>
   * `1`: Private channel. In this type of channel, members must be invited to join a channel.<br>
   * `2`: Private channel with members that belong to one Zoom account. Members in this channel should be invited and the members should be from the same organization.<br>
   * `3`: Public channel. Anyone can search for this channel and join the channel.<br>
   */
  type?: 1 | 2 | 3;
};

export type GetUserLevelChannelError = unknown;

export type UpdateUserLevelChannelData = {
  body?: {
    /**
     * A new name for the channel.
     */
    name: string;
  };
  path: {
    /**
     * Channel Id.
     */
    channelId: string;
  };
};

export type UpdateUserLevelChannelResponse = unknown;

export type UpdateUserLevelChannelError = unknown;

export type LeaveChannelData = {
  path: {
    /**
     * Channel ID: Unique Identifier of a channel.
     */
    channelId: string;
  };
};

export type LeaveChannelResponse = unknown;

export type LeaveChannelError = unknown;

export type JoinChannelData = {
  path: {
    /**
     * Channel Id.
     */
    channelId: string;
  };
};

export type JoinChannelResponse = {
  /**
   * The date and time at which a user joined the channel.
   */
  added_at?: string;
  /**
   * Member Id of the user who joined the public channel.
   */
  id?: string;
};

export type JoinChannelError = unknown;

export type RemoveAuserLevelChannelMemberData = {
  path: {
    /**
     * Unique Identifier of the Channel from where you would like to remove a member. This can be retrieved from the [List Channels API](https://marketplace.zoom.us/docs/api-reference/zoom-api/chat-channels/getchannels).
     */
    channelId: string;
    /**
     * Email address of the member whom you would like to be remove from the channel.
     */
    memberId: string;
  };
};

export type RemoveAuserLevelChannelMemberResponse = unknown;

export type RemoveAuserLevelChannelMemberError = unknown;

export type GetUserContactsData = {
  query?: {
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     * The number of records returned with a single API call.
     */
    page_size?: number;
    /**
     * The type of contact. The value can be one of the following:
     * `company`: Contacts from the user's organization.
     * `external`: External contacts.
     */
    type?: string;
  };
};

export type GetUserContactsResponse = {
  /**
   * The contacts object.
   */
  contacts?: Array<{
    /**
     * Contact's email address.
     */
    email?: string;
    /**
     * Contact's first name.
     */
    first_name?: string;
    /**
     * Contact Id.
     */
    id?: string;
    /**
     * Contact's last name.
     */
    last_name?: string;
  }>;
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of records returned with a single API call.
   * Default value: 30.
   */
  page_size?: number;
};

export type GetUserContactsError = unknown;

export type GetUserContactData = {
  path: {
    /**
     * The user's contact Id or email address. The contact can be either a company contact or an external contact.
     */
    contactId: string;
  };
  query?: {
    /**
     * The presence status of the contact.
     * Include this query parameter with a value of `true` to get the presence status of the contact in the response.
     */
    query_presence_status?: boolean;
  };
};

export type GetUserContactResponse = {
  /**
   * Direct number(s) assigned to the contact.
   */
  direct_numbers?: Array<string>;
  /**
   * Contact's email address.
   */
  email?: string;
  /**
   * Extension number of the contact.
   */
  extension_number?: string;
  /**
   * Contact's first name
   */
  first_name?: string;
  /**
   * User ID of the contact.
   */
  id?: string;
  /**
   * Contact's last name
   */
  last_name?: string;
  /**
   * Phone number of the contact.
   */
  phone_number?: string;
  /**
   * Contact's Presence Status in the Zoom Chat Client. The status can be one of the following: <br> `Do_Not_Disturb`<br> `Away`<br> `Available`<br> `Offline`
   */
  presence_status?: 'Do_Not_Disturb' | 'Away' | 'Available' | 'Offline';
};

export type GetUserContactError = unknown;

export type GetChannelsData = {
  path: {
    /**
     * Unique identifier of the user.
     */
    userId: string;
  };
  query?: {
    /**
     * The next page token is used to paginate through large result sets. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     * The number of records returned from a single API call.
     */
    page_size?: number;
  };
};

export type GetChannelsResponse = {
  /**
   * Chat Channel object(s).
   */
  channels?: Array<{
    channels_settings?: {
      allow_to_add_external_users?: number;
      new_members_can_see_previous_messages_files?: boolean;
      posting_permissions?: number;
    };
    /**
     * Channel ID: Unique identifier of the Channel.
     */
    id?: string;
    /**
     * Name of the channel.
     */
    name?: string;
    /**
     * Type of the channel. The value can be one of the following:<br>
     * `1`: **Private channel.** In this type of channel, members must be invited to join a channel.<br>
     * `2`: **Private channel with users that belong to the same Zoom account**. Members in this channel should be invited and the members should be from the same organization.<br>
     * `3`: **Public channel.** Anyone can search for this channel and join the channel. External members cannot be invited.<br>
     * `4`: **New chat**. This is an instant channel which can be created by adding members to a new chat.<br>
     * `5`: **Public channel**, similar to above, except members can invite members of other accounts.
     */
    type?: number;
  }>;
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of records returned with a single API call.
   * Default value: 30.
   */
  page_size?: number;
  /**
   * The total number of records found.
   */
  total_records?: number;
};

export type GetChannelsError = unknown;

export type CreateChannelData = {
  body?: {
    /**
     * Member(s) to include in the channel. A max of 5 members can be added to the channel at once with this API.
     */
    members?: Array<{
      /**
       * Member's email address.
       */
      email: string;
    }>;
    /**
     * Name of the channel.
     */
    name?: string;
    /**
     * Type of the channel. The value can be one of the following:<br>
     * `1`: Private channel. In this type of channel, members must be invited to join a channel.<br>
     * `2`: Private channel with members that belong to one Zoom account. Members in this channel should be invited and the members should be from the same organization.<br>
     * `3`: Public channel. Anyone can search for this channel and join the channel.<br>
     * `4`: New chat. This is an instant channel which can be created by adding members to a new chat.
     */
    type?: 1 | 2 | 3;
  };
  path: {
    /**
     * Unique identifier of the user.
     */
    userId: string;
  };
};

export type CreateChannelResponse = {
  /**
   * Channel ID: Unique Identifier of the Channel.
   */
  id?: string;
  /**
   * Channel JID.
   */
  jid?: string;
  /**
   * Channel name.
   */
  name?: string;
  /**
   * Channel type.
   */
  type?: number;
};

export type CreateChannelError = unknown;

export type DeleteChannelData = {
  path: {
    /**
     * Channel ID: Unique Identifier of a channel.
     */
    channelId: string;
    userId: string;
  };
};

export type DeleteChannelResponse = unknown;

export type DeleteChannelError = unknown;

export type GetChannelData = {
  path: {
    /**
     * Channel ID: Unique Identifier of a channel.
     */
    channelId: string;
    /**
     * Unique identifier of the user who is the owner of the channel.
     */
    userId: string;
  };
};

export type GetChannelResponse = {
  /**
   * Channel Id.
   */
  id?: string;
  /**
   * Name of the channel.
   */
  name?: string;
  /**
   * Type of the channel. The value can be one of the following:<br>
   * `1`: Private channel. In this type of channel, members must be invited to join a channel.<br>
   * `2`: Private channel with members that belong to one Zoom account. Members in this channel should be invited and the members should be from the same organization.<br>
   * `3`: Public channel. Anyone can search for this channel and join the channel.<br>
   */
  type?: 1 | 2 | 3;
};

export type GetChannelError = unknown;

export type UpdateChannelData = {
  body?: {
    /**
     * A new name for the channel.
     */
    name: string;
  };
  path: {
    /**
     * Channel Id.
     */
    channelId: string;
    /**
     * Unique Identifier of the Zoom user who is the owner of the channel.
     */
    userId: string;
  };
};

export type UpdateChannelResponse = unknown;

export type UpdateChannelError = unknown;

export type ListChannelMembersData = {
  path: {
    /**
     * Channel Id.
     */
    channelId: string;
    /**
     * Unique identifier of the user who is the owner of this channel.
     */
    userId: string;
  };
  query?: {
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     * The number of records returned with a single API call.
     */
    page_size?: number;
  };
};

export type ListChannelMembersResponse = {
  /**
   * Members in a channel.
   */
  members?: Array<{
    /**
     * Email address of the member.
     */
    email?: string;
    /**
     * Member's first name.
     */
    first_name?: string;
    /**
     * Member ID: Unique Identifier of the member.
     */
    id?: string;
    /**
     * Member's last name.
     */
    last_name?: string;
    /**
     * The role of the member. The value can be one of these: `owner`, `admin`, `member`.
     */
    role?: 'admin' | 'owner' | 'member';
  }>;
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of records returned.
   */
  total_records?: number;
};

export type ListChannelMembersError = unknown;

export type InviteChannelMembersData = {
  body?: {
    /**
     * Members of a channel. You can invite up to a max number of 5 members with a single API call.
     */
    members?: Array<{
      /**
       * Email adress of the member.
       */
      email: string;
    }>;
  };
  path: {
    /**
     * Channel ID: Unique Identifier of the channel.
     */
    channelId: string;
    /**
     * Unique identifier of the user who is the owner of this channel.
     */
    userId: string;
  };
};

export type InviteChannelMembersResponse = {
  /**
   * The date and time at which the member(s) are added to the channe.
   */
  added_at?: string;
  /**
   * Member Ids of the members.
   */
  ids?: Array<string>;
};

export type InviteChannelMembersError = unknown;

export type RemoveAchannelMemberData = {
  path: {
    /**
     * Unique Identifier of the Channel from where you would like to remove a member. This can be retrieved from the [List Channels API](https://marketplace.zoom.us/docs/api-reference/zoom-api/chat-channels/getchannels).
     */
    channelId: string;
    /**
     * Email address of the member whom you would like to be remove from the channel.
     */
    memberId: string;
    /**
     * Unique identifier of the channel owner.
     */
    userId: string;
  };
};

export type RemoveAchannelMemberResponse = unknown;

export type RemoveAchannelMemberError = unknown;

export type GetChatMessagesData = {
  path: {
    userId: string;
  };
  query?: {
    /**
     * The query date for which you would like to get the chat messages.
     */
    date?: string;
    /**
     * **Optional** <br>
     * Set the value of this field to `true` to include edited and deleted messages in the response.
     */
    include_deleted_and_edited_message?: string;
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     * The number of records returned with a single API call.
     */
    page_size?: number;
    /**
     * The channel Id of a channel inside which the current user had chat conversations. Messages that were sent and/or received between the user and the channel is displayed.
     *
     * Note: You must provide either `contact` or `channel` as a query parameter to retrieve messages either from an individual or a chat channel.
     */
    to_channel?: string;
    /**
     * The email address of a chat contact with whom the current user chatted. Messages that were sent and/or received between the user and the contact is displayed.
     *
     * Note: You must provide either `contact` or `channel` as a query parameter to retrieve messages either from an individual or a chat channel.
     */
    to_contact?: string;
  };
};

export type GetChatMessagesResponse = {
  /**
   * The date provided in the query parameter. If a date is not provided, the default value is the **current date**.
   */
  date?: string;
  /**
   * List of message(s).
   */
  messages?: Array<{
    /**
     * The date-time at which the message was sent.
     */
    date_time?: string;
    /**
     * Message ID: Unique Identifier of the message.
     */
    id?: string;
    /**
     * The message content.
     */
    message?: string;
    /**
     * Unique identifier of a reply. This field will only be returned if the message is a reply message.
     */
    reply_main_message_id?: string;
    /**
     * Timestamp of when the reply message was sent. This field will only be returned if the message is a reply message.
     *
     * The value of this field will be in **long** format(int64).
     */
    reply_main_message_timestamp?: number;
    /**
     * The email address of the sender of the message.
     */
    sender?: string;
    /**
     * This field indicates whether a message is an original message(unedited), an edited message or a deleted message.
     *
     * This field is only returned if you set the value of `for include_deleted_and_edited_message` query parameter to `true`.
     */
    status?: 'Deleted' | 'Edited' | 'Normal';
    /**
     * The timestamp of the message in microseconds.
     */
    timestamp?: number;
  }>;
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   *
   */
  next_page_token?: string;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
};

export type GetChatMessagesError = unknown;

export type SendaChatMessageData = {
  body?: {
    /**
     * [Chat mentions](https://support.zoom.us/hc/en-us/articles/360037567431-Using-chat-mentions-and-slash-commands) object. Use this object to include mentions in the message that will be sent to  a channel.
     */
    at_items?: Array<{
      /**
       * This field is required if the value of `at_type` field is set to 1.
       *
       * Email address of the contact.
       *
       *
       */
      at_contact?: string;
      /**
       * Type of mention. You can use one of the following values:<br>
       * * `1`: Mention a contact.
       *
       * * `2`: Mention "all" to notify everyone in the channel.
       */
      at_type?: 1 | 2;
      /**
       * End position of the mention.
       *
       * Example message: "@Shrijana How are you?"
       * In this case, the end position of the mention "@Shrijana" is 8. Hence, the value of this field will be 8.
       */
      end_position?: number;
      /**
       * Start position of the mention("@") in the message string.
       *
       * For example if you want to include the mention at the beginning of the message, the value for this field will be 0.
       *
       * Example message: "@Shrijana How are you?"
       *
       *
       */
      start_position?: number;
    }>;
    /**
     * The message to be sent.
     */
    message: string;
    /**
     * The Channel Id of the channel where you would like to send a message.
     */
    to_channel?: string;
    /**
     * The email address of the contact to whom you would like to send the message.
     */
    to_contact?: string;
  };
  path: {
    userId: string;
  };
};

export type SendaChatMessageResponse = {
  /**
   * Message ID: Unique Identifier of the message.
   */
  id?: string;
};

export type SendaChatMessageError = unknown;

export type DeleteChatMessageData = {
  path: {
    /**
     * Message ID
     */
    messageId: string;
    userId: string;
  };
  query?: {
    /**
     * The channel Id of the channel where you would like to send the message.
     *
     * You must provide either `to_contact` or `to_channel` as a query parameter to delete a message that was previously sent to either an individual or a chat channel
     */
    to_channel?: string;
    /**
     * The userId or email address of a chat contact to whom you previously sent the message.
     *
     * Note: You must provide either `to_contact` or `to_channel` as a query parameter to delete a message that was previously sent to either an individual or a chat channel respectively.
     */
    to_contact?: string;
  };
};

export type DeleteChatMessageResponse = any;

export type DeleteChatMessageError = unknown;

export type EditMessageData = {
  body?: {
    /**
     * The edited message.
     */
    message?: string;
    /**
     * The Channel ID of the channel where you sent the message.<br>You must provide either `to_contact` or `to_channel` parameter in the API request.
     * Channel ID can be retrieved from List User's Channels API.
     */
    to_channel?: string;
    /**
     * The email address of the contact to whom the message was sent.<br>
     * You must provide either `to_contact` or `to_channel` parameter in the API request.
     */
    to_contact?: string;
  };
  path: {
    /**
     * Message ID: Unique Identifier of the message.
     */
    messageId: string;
    userId: string;
  };
};

export type EditMessageResponse = any;

export type EditMessageError = unknown;

export type SearchCompanyContactsData = {
  query: {
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     * The number of records to be returned with a single API call.
     */
    page_size?: number;
    /**
     * Set `query_presence_status` to `true` in order to include the presence status of a contact in the response.
     */
    query_presence_status?: string;
    /**
     * Provide the keyword - either first name, last name or email of the contact whom you have to search for.
     */
    search_key: string;
  };
};

export type SearchCompanyContactsResponse = {
  contacts?: Array<{
    /**
     * Department of the contact as provided in the user's Zoom profile.
     */
    dept?: string;
    /**
     * Direct Number(s) of a user who has Zoom Phone license assigned.
     */
    direct_numbers?: Array<string>;
    /**
     * Email address of the contact.
     */
    email?: string;
    /**
     * Extension Number of a user who has Zoom Phone license assigned.
     */
    extension_number?: string;
    /**
     * First name of the contact.
     */
    first_name?: string;
    /**
     * User ID of the contact.
     */
    id?: string;
    /**
     * Unique Identifier of the [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management) in which the user has been added. An IM Directory group is not the same as a channel. IM Directory allows administrators to assign users in their account to groups that display within the Contacts list on Zoom clients.
     */
    im_group_id?: string;
    /**
     * Name of the [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management) in which the user has been added. An IM Directory group is not the same as a channel. IM Directory allows administrators to assign users in their account to groups that display within the Contacts list on Zoom clients.
     */
    im_group_name?: string;
    /**
     * Department of the user as provided in the user's Zoom profile.
     */
    job_title?: string;
    /**
     * Last name of the contact.
     */
    last_name?: string;
    /**
     * Location of the user as provided in the user's Zoom profile.
     */
    location?: string;
    /**
     * Phone number of the user.
     */
    phone_number?: string;
    /**
     * Presence status of the contact in Zoom Client. The value of this field can be one of the following:
     * `Do_Not_Disturb`<br> `away`<br> `Available`<br> `Offline`
     */
    presence_status?: 'Do_Not_Disturb' | 'Away' | 'Available' | 'Offline';
    /**
     * SIP Phone number of the user. Returned only if user has SIP phone enabled.
     */
    sip_phone_number?: string;
  }>;
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of records returned with a single API call. Default value is `1`.
   */
  page_size?: number;
};

export type SearchCompanyContactsError = unknown;

export type GroupsResponse = {
  /**
   * List of Group objects.
   */
  groups?: Array<
    {
      /**
       * Group ID.
       */
      id?: string;
    } & {
      /**
       * Group name.
       */
      name?: string;
      /**
       * Total number of members in this group.
       */
      total_members?: number;
    }
  >;
  /**
   * Total records.
   */
  total_records?: number;
};

export type GroupsError = unknown;

export type GroupCreateData = {
  body: {
    /**
     * Group name.
     */
    name?: string;
  };
};

export type GroupCreateResponse =
  | unknown
  | {
      /**
       * Group ID.
       */
      id?: string;
      /**
       * Group name.
       */
      name?: string;
      /**
       * Group member count.
       */
      total_members?: number;
    };

export type GroupCreateError = unknown;

export type GroupDeleteData = {
  path: {
    /**
     * The group ID.<br>
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
     */
    groupId: string;
  };
};

export type GroupDeleteResponse = unknown | any;

export type GroupDeleteError = unknown;

export type GroupData = {
  path: {
    /**
     * The group ID.<br>
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
     */
    groupId: string;
  };
};

export type GroupResponse = {
  /**
   * Group ID.
   */
  id?: string;
  /**
   * Group name.
   */
  name?: string;
  /**
   * Total count of members in the group.
   */
  total_members?: number;
};

export type GroupError = unknown;

export type GroupUpdateData = {
  body: {
    /**
     * Group name. It must be unique to one account and less than 128 characters.
     */
    name?: string;
  };
  path: {
    /**
     * The group ID.<br>
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
     */
    groupId: string;
  };
};

export type GroupUpdateResponse = unknown | any;

export type GroupUpdateError = unknown;

export type GetGroupLockSettingsData = {
  path: {
    /**
     * Id of the group.
     */
    groupId: string;
  };
  query?: {
    /**
     * Provide the name of the field by which you would like to filter the response. For example, if you provide "host_video" as the value of this field, you will get a response similar to the following:<br>
     * {
     * "schedule_meeting": {
     * "host_video": false
     * }
     * }
     * <br>You can provide multiple values by separating them with commas(example: "host_video,participant_video”).
     */
    custom_query_fields?: string;
    /**
     * Specify `meeting_security` as the value of this field if you would like to view security settings applied on a meeting hosted by the users in this group.
     */
    option?: string;
  };
};

export type GetGroupLockSettingsResponse =
  | {
      email_notification?: {
        /**
         * Notify the alternative host who is set or removed.
         */
        alternative_host_reminder?: boolean;
        /**
         * Notify host and participants when the meeting is cancelled.
         */
        cancel_meeting_reminder?: boolean;
        /**
         * Notify host when cloud recording is available.
         */
        cloud_recording_available_reminder?: boolean;
        /**
         * Notify host when participants join the meeting before them.
         */
        jbh_reminder?: boolean;
        /**
         * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
         */
        schedule_for_host_reminder?: boolean;
      };
      in_meeting?: {
        /**
         * Allow participants who belong to your account to see that a guest (someone who does not belong to your account) is participating in the meeting/webinar.
         */
        alert_guest_join?: boolean;
        /**
         * Show Zoom windows during screen share.
         */
        allow_show_zoom_windows?: boolean;
        /**
         * Allow participants to use annotation tools to add information to shared screens.
         */
        annotation?: boolean;
        /**
         * Allow host to put attendee on hold.
         *
         * **This field has been deprecated and is no longer supported.**
         */
        attendee_on_hold?: boolean;
        /**
         * Enable users to see and add contacts to 'auto-answer group' in the contact list on chat. Any call from members of this group will be automatically answered.
         */
        auto_answer?: boolean;
        /**
         * Automatically save all in-meeting chats.
         */
        auto_saving_chat?: boolean;
        /**
         * Allow host to split meeting participants into separate, smaller rooms.
         */
        breakout_room?: boolean;
        /**
         * Allow meeting participants to send chat message visible to all participants.
         */
        chat?: boolean;
        /**
         * Allow host to type closed captions or assign a participant/third party device to add closed captions.
         */
        closed_caption?: boolean;
        /**
         * Allow the host to add co-hosts. Co-hosts have the same in-meeting controls as the host.
         */
        co_host?: boolean;
        /**
         * Displays whether or not custom [data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) have been selected for meetings/webinars hosted by this group.
         */
        custom_data_center_regions?: boolean;
        /**
         * Require that all meetings are encrypted using AES.
         */
        e2e_encryption?: boolean;
        /**
         * Play sound when participants join or leave.
         */
        entry_exit_chime?: string;
        /**
         * Allow another user to take control of the camera during a meeting.
         */
        far_end_camera_control?: boolean;
        /**
         * Enable users to provide feedback to Zoom at the end of the meeting.
         */
        feedback?: boolean;
        /**
         * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for the users in the group or not.
         */
        file_transfer?: boolean;
        /**
         * Enable higher quality video for host and participants. This will require more bandwidth.
         */
        group_hd?: boolean;
        /**
         * Allow participants in a meeting can provide nonverbal feedback and express opinions by clicking on icons in the Participants panel.
         */
        non_verbal_feedback?: boolean;
        /**
         * Allow users to select original sound during a meeting.
         */
        original_audio?: boolean;
        /**
         * Add 'Polls' to the meeting controls. This allows the host to survey the attendees.
         */
        polling?: boolean;
        /**
         * Display end-of-meeting experience feedback survey.
         */
        post_meeting_feedback?: boolean;
        /**
         * Allow meeting participants to send a private 1:1 message to another participant.
         */
        private_chat?: boolean;
        /**
         * During screen sharing, allow the person who is sharing to let others control the shared content.
         */
        remote_control?: boolean;
        /**
         * Allow meeting host to provide 1:1 remote support to another participant.
         */
        remote_support?: boolean;
        /**
         * Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled and locked for the group or not.
         */
        request_permission_to_unmute?: boolean;
        /**
         * Allow host and participants to share their screen or content during meetings.
         */
        screen_sharing?: boolean;
        /**
         * Allow users to invite participants by email only by default.
         */
        sending_default_email_invites?: boolean;
        /**
         * Allow participants to join a meeting directly from their browser.
         */
        show_browser_join_link?: boolean;
        /**
         * Always show meeting controls during a meeting.
         */
        show_meeting_control_toolbar?: boolean;
        /**
         * Allow users to select stereo audio during a meeting.
         */
        stereo_audio?: boolean;
        /**
         * Allow  HTML formatting instead of plain text for meeting invitations scheduled with the Outlook plugin.
         */
        use_html_format_email?: boolean;
        /**
         * Enable virtual background.
         */
        virtual_background?: boolean;
        /**
         * Attendees cannot join a meeting until a host admits them individually from the waiting room.
         */
        waiting_room?: boolean;
        /**
         * Allow participants to share a whiteboard that includes annotation tools.
         */
        whiteboard?: boolean;
      };
      recording?: {
        /**
         * Make cloud recordings accessible to account members only.
         */
        account_user_access_recording?: boolean;
        /**
         * Allow Zoom to automatically delete recordings permanently after a specified number of days.
         */
        auto_delete_cmr?: boolean;
        /**
         * Record meetings automatically as they start.
         */
        auto_recording?: string;
        /**
         * Allow hosts to record and save the meeting / webinar in the cloud.
         */
        cloud_recording?: boolean;
        /**
         * Allow anyone with a link to the cloud recording to download.
         */
        cloud_recording_download?: boolean;
        /**
         * Allow the host to delete the recordings. If this option is disabled, the recordings cannot be deleted by the host and only admin can delete them.
         */
        host_delete_cloud_recording?: boolean;
        /**
         * Setting to allow cloud recording access only from specific IP address ranges.
         *
         */
        ip_address_access_control?: {
          /**
           * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
           *
           *
           */
          enable?: boolean;
          /**
           * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
           *
           * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
           *
           *
           */
          ip_addresses_or_ranges?: string;
        };
        /**
         * Allow hosts and participants to record the meeting to a local file.
         */
        local_recording?: boolean;
        /**
         * If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.
         *
         *
         */
        prevent_host_access_recording?: boolean;
        /**
         * Only authenticated users can view cloud recordings
         */
        recording_authentication?: boolean;
      };
      schedule_meeting?: {
        /**
         * Determine how participants can join the audio portion of the meeting.
         */
        audio_type?: boolean;
        /**
         * If the value is set to `true`, the meeting password will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the password.
         *
         */
        embed_password_in_join_link?: boolean;
        /**
         * If join before host option is enabled for a personal meeting, then enforce password requirement.
         */
        force_pmi_jbh_password?: boolean;
        /**
         * Start meetings with host video on.
         */
        host_video?: boolean;
        /**
         * Allow participants to join the meeting before the host arrives
         */
        join_before_host?: boolean;
        /**
         * Only authenticated users can join meetings
         */
        meeting_authentication?: boolean;
        /**
         * Automatically mute all participants when they join the meeting.
         */
        mute_upon_entry?: boolean;
        /**
         * Start meetings with participant video on.
         */
        participant_video?: boolean;
        /**
         * Generate and send new passwords for newly scheduled or edited meetings.
         */
        pstn_password_protected?: boolean;
        /**
         * Require password for instant meetings. If you use PMI for your instant meetings, this option will be disabled.
         */
        require_password_for_instant_meetings?: boolean;
        /**
         * Require participants to enter password for PMI meetings.
         */
        require_password_for_pmi_meetings?: boolean;
        /**
         * This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting.
         */
        require_password_for_scheduling_new_meetings?: boolean;
        /**
         * Receive desktop notification for upcoming meetings.
         */
        upcoming_meeting_reminder?: boolean;
      };
      telephony?: {
        telephony_regions?: boolean;
        /**
         * Allow users to join the meeting using the existing 3rd party audio configuration.
         */
        third_party_audio?: boolean;
      };
    }
  | {
      meeting_security?: {
        /**
         * `true`: Require that all meetings are secured with at least one security option.
         *
         * This setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).
         */
        auto_security?: boolean;
        /**
         * If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.
         *
         */
        embed_password_in_join_link?: boolean;
        /**
         * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
         * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
         *
         * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
         */
        encryption_type?: 'enhanced_encryption' | 'e2ee';
        /**
         * Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.
         */
        end_to_end_encrypted_meetings?: boolean;
        /**
         * If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.
         */
        meeting_password?: boolean;
        /**
         * Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
         */
        meeting_password_requirement?: {
          consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
          /**
           * If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).
           *
           */
          have_letter?: boolean;
          /**
           * If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).
           */
          have_number?: boolean;
          /**
           * If set to `true`, the passcode must have at least 1 special character (!,@,#...).
           */
          have_special_character?: boolean;
          /**
           * If set to `true`, the passcode must include both uppercase and lowercase characters.
           */
          have_upper_and_lower_characters?: boolean;
          /**
           * The minimum length that the meeting/webinar passcode needs to have.
           */
          length?: number;
          /**
           * If set to `true`, the passcode must only contain numbers and no other characters.
           */
          only_allow_numeric?: boolean;
          /**
           * If set to `true`, users will be informed if the provided passcode is weak.
           */
          weak_enhance_detection?: boolean;
        };
        /**
         * Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.
         */
        phone_password?: boolean;
        /**
         * If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.
         *
         */
        pmi_password?: boolean;
        /**
         * Require a passcode for meetings which have already been scheduled.
         *
         */
        require_password_for_scheduled_meeting?: boolean;
        /**
         * Require a passcode for webinars which have already been scheduled.
         *
         */
        require_password_for_scheduled_webinar?: boolean;
        /**
         * When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.
         *
         */
        waiting_room?: boolean;
        /**
         * Specify the settings to be applied if waiting room is enabled.
         */
        waiting_room_settings?: {
          /**
           *
           *
           * Specify who should be admitted to the waiting room. The value of this field can be one of the following:<br>
           * `0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in
           */
          participants_to_place_in_waiting_room?: 0 | 1 | 2;
          /**
           * Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>
           * `0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).
           *
           *
           *
           */
          users_who_can_admit_participants_from_waiting_room?: number;
          /**
           * If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").
           */
          whitelisted_domains_for_waiting_room?: string;
        };
        /**
         * If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.
         *
         */
        webinar_password?: boolean;
      };
    };

export type GetGroupLockSettingsError = unknown;

export type GroupLockedSettingsData = {
  body?:
    | {
        email_notification?: {
          /**
           * Notify the alternative host who is set or removed.
           */
          alternative_host_reminder?: boolean;
          /**
           * Notify host and participants when the meeting is cancelled.
           */
          cancel_meeting_reminder?: boolean;
          /**
           * Notify host when cloud recording is available.
           */
          cloud_recording_available_reminder?: boolean;
          /**
           * Notify host when participants join the meeting before them.
           */
          jbh_reminder?: boolean;
          /**
           * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
           */
          schedule_for_host_reminder?: boolean;
        };
        in_meeting?: {
          /**
           * Allow participants who belong to your account to see that a guest (someone who does not belong to your account) is participating in the meeting/webinar.
           */
          alert_guest_join?: boolean;
          /**
           * Show Zoom windows during screen share.
           */
          allow_show_zoom_windows?: boolean;
          /**
           * Allow participants to use annotation tools to add information to shared screens.
           */
          annotation?: boolean;
          /**
           * Allow host to put attendee on hold.
           *
           * **This field has been deprecated and is no longer supported.**
           */
          attendee_on_hold?: boolean;
          /**
           * Enable users to see and add contacts to 'auto-answer group' in the contact list on chat. Any call from members of this group will be automatically answered.
           */
          auto_answer?: boolean;
          /**
           * Automatically save all in-meeting chats.
           */
          auto_saving_chat?: boolean;
          /**
           * Allow host to split meeting participants into separate, smaller rooms.
           */
          breakout_room?: boolean;
          /**
           * Allow meeting participants to send chat message visible to all participants.
           */
          chat?: boolean;
          /**
           * Allow host to type closed captions or assign a participant/third party device to add closed captions.
           */
          closed_caption?: boolean;
          /**
           * Allow the host to add co-hosts. Co-hosts have the same in-meeting controls as the host.
           */
          co_host?: boolean;
          /**
           * Displays whether or not custom [data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) have been selected for meetings/webinars hosted by this group.
           */
          custom_data_center_regions?: boolean;
          /**
           * Require that all meetings are encrypted using AES.
           */
          e2e_encryption?: boolean;
          /**
           * Play sound when participants join or leave.
           */
          entry_exit_chime?: string;
          /**
           * Allow another user to take control of the camera during a meeting.
           */
          far_end_camera_control?: boolean;
          /**
           * Enable users to provide feedback to Zoom at the end of the meeting.
           */
          feedback?: boolean;
          /**
           * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for the users in the group or not.
           */
          file_transfer?: boolean;
          /**
           * Enable higher quality video for host and participants. This will require more bandwidth.
           */
          group_hd?: boolean;
          /**
           * Allow participants in a meeting can provide nonverbal feedback and express opinions by clicking on icons in the Participants panel.
           */
          non_verbal_feedback?: boolean;
          /**
           * Allow users to select original sound during a meeting.
           */
          original_audio?: boolean;
          /**
           * Add 'Polls' to the meeting controls. This allows the host to survey the attendees.
           */
          polling?: boolean;
          /**
           * Display end-of-meeting experience feedback survey.
           */
          post_meeting_feedback?: boolean;
          /**
           * Allow meeting participants to send a private 1:1 message to another participant.
           */
          private_chat?: boolean;
          /**
           * During screen sharing, allow the person who is sharing to let others control the shared content.
           */
          remote_control?: boolean;
          /**
           * Allow meeting host to provide 1:1 remote support to another participant.
           */
          remote_support?: boolean;
          /**
           * Indicate whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option should be enabled and locked for the group or not.
           */
          request_permission_to_unmute?: boolean;
          /**
           * Allow host and participants to share their screen or content during meetings.
           */
          screen_sharing?: boolean;
          /**
           * Allow users to invite participants by email only by default.
           */
          sending_default_email_invites?: boolean;
          /**
           * Allow participants to join a meeting directly from their browser.
           */
          show_browser_join_link?: boolean;
          /**
           * Always show meeting controls during a meeting.
           */
          show_meeting_control_toolbar?: boolean;
          /**
           * Allow users to select stereo audio during a meeting.
           */
          stereo_audio?: boolean;
          /**
           * Allow  HTML formatting instead of plain text for meeting invitations scheduled with the Outlook plugin.
           */
          use_html_format_email?: boolean;
          /**
           * Enable virtual background.
           */
          virtual_background?: boolean;
          /**
           * Attendees cannot join a meeting until a host admits them individually from the waiting room.
           */
          waiting_room?: boolean;
          /**
           * Allow participants to share a whiteboard that includes annotation tools.
           */
          whiteboard?: boolean;
        };
        recording?: {
          /**
           * Make cloud recordings accessible to account members only.
           */
          account_user_access_recording?: boolean;
          /**
           * Allow Zoom to automatically delete recordings permanently after a specified number of days.
           */
          auto_delete_cmr?: boolean;
          /**
           * Record meetings automatically as they start.
           */
          auto_recording?: string;
          /**
           * Allow hosts to record and save the meeting / webinar in the cloud.
           */
          cloud_recording?: boolean;
          /**
           * Allow anyone with a link to the cloud recording to download.
           */
          cloud_recording_download?: boolean;
          /**
           * Allow the host to delete the recordings. If this option is disabled, the recordings cannot be deleted by the host and only admin can delete them.
           */
          host_delete_cloud_recording?: boolean;
          /**
           * Setting to allow cloud recording access only from specific IP address ranges.
           *
           */
          ip_address_access_control?: {
            /**
             * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
             *
             *
             */
            enable?: boolean;
            /**
             * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
             *
             * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
             *
             *
             */
            ip_addresses_or_ranges?: string;
          };
          /**
           * Allow hosts and participants to record the meeting to a local file.
           */
          local_recording?: boolean;
          recording_authentication?: string;
        };
        schedule_meeting?: {
          /**
           * Determine how participants can join the audio portion of the meeting.
           */
          audio_type?: boolean;
          /**
           * If the value is set to `true`, the meeting password will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the password.
           *
           */
          embed_password_in_join_link?: boolean;
          /**
           * If join before host option is enabled for a personal meeting, then enforce password requirement.
           */
          force_pmi_jbh_password?: boolean;
          /**
           * Start meetings with host video on.
           */
          host_video?: boolean;
          /**
           * Allow participants to join the meeting before the host arrives
           */
          join_before_host?: boolean;
          /**
           * Only authenticated users can join meetings
           */
          meeting_authentication?: boolean;
          /**
           * Automatically mute all participants when they join the meeting.
           */
          mute_upon_entry?: boolean;
          /**
           * Start meetings with participant video on.
           */
          participant_video?: boolean;
          /**
           * Turn the lock setting on or off for the **Enable Personal Meeting ID** setting for a group.<br><br>
           * `true`: Turn the **"Enable Personal Meeting ID"** setting **on** for all users in the group. Users can choose to use personal meeting ID for their meetings. <br><br>
           * `false`: Turn **off** the **"Enable Personal Meeting ID"** setting. **If this setting is [disabled](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link?flash_digest=eb7ac62d8c7fb4daf285916e3e15d87537806133#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a), meetings that were scheduled with PMI by this group members will be invalid. Users will have to update previously scheduled PMI meetings.**<br><br>
           * For Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.
           *
           *
           *
           */
          personal_meeting?: boolean;
          /**
           * Generate and send new passwords for newly scheduled or edited meetings.
           */
          pstn_password_protected?: boolean;
          /**
           * Require password for instant meetings. If you use PMI for your instant meetings, this option will be disabled.
           */
          require_password_for_instant_meetings?: boolean;
          /**
           * Require participants to enter password for PMI meetings.
           */
          require_password_for_pmi_meetings?: boolean;
          /**
           * This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting.
           */
          require_password_for_scheduling_new_meetings?: boolean;
          /**
           * Receive desktop notification for upcoming meetings.
           */
          upcoming_meeting_reminder?: boolean;
        };
        telephony?: {
          telephony_regions?: boolean;
          /**
           * Allow users to join the meeting using the existing 3rd party audio configuration.
           */
          third_party_audio?: boolean;
        };
      }
    | {
        meeting_security?: {
          /**
           * `true`: Require that all meetings are secured with at least one security option.
           *
           * This setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).
           */
          auto_security?: boolean;
          /**
           * If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.
           *
           */
          embed_password_in_join_link?: boolean;
          /**
           * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
           * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
           *
           * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
           */
          encryption_type?: 'enhanced_encryption' | 'e2ee';
          /**
           * Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.
           */
          end_to_end_encrypted_meetings?: boolean;
          /**
           * If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.
           */
          meeting_password?: boolean;
          /**
           * Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
           */
          meeting_password_requirement?: {
            consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
            /**
             * If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).
             *
             */
            have_letter?: boolean;
            /**
             * If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).
             */
            have_number?: boolean;
            /**
             * If set to `true`, the passcode must have at least 1 special character (!,@,#...).
             */
            have_special_character?: boolean;
            /**
             * If set to `true`, the passcode must include both uppercase and lowercase characters.
             */
            have_upper_and_lower_characters?: boolean;
            /**
             * The minimum length that the meeting/webinar passcode needs to have.
             */
            length?: number;
            /**
             * If set to `true`, the passcode must only contain numbers and no other characters.
             */
            only_allow_numeric?: boolean;
            /**
             * If set to `true`, users will be informed if the provided passcode is weak.
             */
            weak_enhance_detection?: boolean;
          };
          /**
           * Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.
           */
          phone_password?: boolean;
          /**
           * If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.
           *
           */
          pmi_password?: boolean;
          /**
           * Require a passcode for meetings which have already been scheduled.
           *
           */
          require_password_for_scheduled_meeting?: boolean;
          /**
           * Require a passcode for webinars which have already been scheduled.
           *
           */
          require_password_for_scheduled_webinar?: boolean;
          /**
           * When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.
           *
           */
          waiting_room?: boolean;
          /**
           * Specify the settings to be applied if waiting room is enabled.
           */
          waiting_room_settings?: {
            /**
             *
             *
             * Specify who should be admitted to the waiting room. The value of this field can be one of the following:<br>
             * `0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in
             */
            participants_to_place_in_waiting_room?: 0 | 1 | 2;
            /**
             * Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>
             * `0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).
             *
             *
             *
             */
            users_who_can_admit_participants_from_waiting_room?: number;
            /**
             * If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").
             */
            whitelisted_domains_for_waiting_room?: string;
          };
          /**
           * If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.
           *
           */
          webinar_password?: boolean;
        };
      };
  path: {
    /**
     * The Id of the group.
     */
    groupId: string;
  };
  query?: {
    /**
     * Provide the name of the field by which you would like to filter the response. For example, if you provide "host_video" as the value of this field, you will get a response similar to the following:<br>
     * {
     * "schedule_meeting": {
     * "host_video": false
     * }
     * }
     * <br>You can provide multiple values by separating them with commas(example: "host_video,participant_video”).
     */
    custom_query_fields?: string;
    /**
     * Specify `meeting_security` as the value of this field if you would like to view security settings applied on a meeting hosted by the users in this group.
     */
    option?: string;
  };
};

export type GroupLockedSettingsResponse = unknown;

export type GroupLockedSettingsError = unknown;

export type GroupMembersData = {
  path: {
    /**
     * The group ID.<br>
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
     */
    groupId: string;
  };
  query?: {
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     *
     * **Deprecated** - This field has been deprecated and we will stop supporting it completely in a future release. Please use "next_page_token" for pagination instead of this field.
     *
     * The page number of the current page in the returned records.
     */
    page_number?: number;
    /**
     * The number of records returned within a single API call.
     */
    page_size?: number;
  };
};

export type GroupMembersResponse = {
  members?: Array<{
    /**
     * User's email address.
     */
    email?: string;
    /**
     * First name of the user.
     */
    first_name?: string;
    /**
     * Unique Identifier of the user.
     */
    id?: string;
    /**
     * Last name of the user.
     */
    last_name?: string;
    /**
     * User type: <br> `1` - Basic<br> `2` - Licensed<br> `3` - On-prem
     */
    type?: number;
  }>;
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned from this request.
   */
  page_count?: number;
  /**
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned from a single API call.
   */
  page_size?: number;
  /**
   * The total number of records available across all pages.
   */
  total_records?: number;
};

export type GroupMembersError = unknown;

export type GroupMembersCreateData = {
  body: {
    /**
     * List of Group members
     */
    members?: Array<{
      /**
       * User email. If the user ID is given then the user email should be ignored.
       */
      email?: string;
      /**
       * User ID.
       */
      id?: string;
    }>;
  };
  path: {
    /**
     * The group ID.<br>
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
     */
    groupId: string;
  };
};

export type GroupMembersCreateResponse =
  | unknown
  | {
      added_at?: string;
      ids?: string;
    };

export type GroupMembersCreateError = unknown;

export type GroupMembersDeleteData = {
  path: {
    /**
     * The group ID.<br>
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
     */
    groupId: string;
    /**
     * The member ID.
     */
    memberId: string;
  };
};

export type GroupMembersDeleteResponse = unknown | any;

export type GroupMembersDeleteError = unknown;

export type UpdateAgroupMemberData = {
  body?: {
    /**
     * Specify the type of action to be performed:<br><br>
     * `move`: Simultaneously remove a member from one group and move the member to a different group.<br>
     * `set_primary`: Set a primary group for the user.
     *
     */
    action: 'move' | 'set_primary';
    /**
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups) API.<br>
     *
     * To move a user, use this field to specify the groupId of the group where the member is to be moved.<br>
     *
     * To set a primary group for the user, provide the groupId of the group which is going to be the primary group.
     */
    target_group_id?: string;
  };
  path: {
    /**
     * Unique Identifier of the group. Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups) API.<br> To change a member's primary group, provide the groupId of the member's current primary group as the value of this field.<br> To remove a member from one group and move the member to another group, provide the groupId of the group from which the member is to be moved.
     */
    groupId: string;
    /**
     * Unique Identifier of the group member. Can be retrieved by calling the [List Group Members](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groupmembers) API.
     */
    memberId: string;
  };
};

export type UpdateAgroupMemberResponse = unknown;

export type UpdateAgroupMemberError = unknown;

export type GetGroupSettingsData = {
  path: {
    groupId: string;
  };
  query?: {
    /**
     * Provide the name of the field by which you would like to filter the response. For example, if you provide "host_video" as the value of this field, you will get a response similar to the following:<br>
     * {
     * "schedule_meeting": {
     * "host_video": false
     * }
     * }
     * <br>You can provide multiple values by separating them with commas(example: "host_video,participant_video”).
     */
    custom_query_fields?: string;
    /**
     * `meeting_authentication`: Use this query parameter to view [meeting authentication configuration](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) applied on the group.<br>`recording_authentication`: Use this query parameter to view [recording authentication configuration](https://support.zoom.us/hc/en-us/articles/360037756671-Authentication-Profiles-for-Cloud-Recordings) applied on the group.<br>
     * `meeting_security`: Use this query parameter to view meeting security settings applied on the group.<br>
     */
    option?: 'meeting_authentication' | 'recording_authentication';
  };
};

export type GetGroupSettingsResponse =
  | {
      email_notification?: {
        /**
         * Notify the alternative host who is set or removed.
         */
        alternative_host_reminder?: boolean;
        /**
         * Notify host and participants when the meeting is cancelled.
         */
        cancel_meeting_reminder?: boolean;
        /**
         * Notify host when cloud recording is available.
         */
        cloud_recording_available_reminder?: boolean;
        /**
         * Notify host when participants join the meeting before them.
         */
        jbh_reminder?: boolean;
        /**
         * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
         */
        schedule_for_host_reminder?: boolean;
      };
      in_meeting?: {
        /**
         * Allow participants who belong to your account to see that a guest (someone who does not belong to your account) is participating in the meeting/webinar.
         */
        alert_guest_join?: boolean;
        /**
         * Show Zoom windows during screen share.
         */
        allow_show_zoom_windows?: boolean;
        /**
         * Allow participants to use annotation tools to add information to shared screens.
         */
        annotation?: boolean;
        /**
         * Allow host to put attendee on hold.
         *
         * **This field has been deprecated and is no longer supported.**
         */
        attendee_on_hold?: boolean;
        /**
         * Enable users to see and add contacts to 'auto-answer group' in the contact list on chat. Any call from members of this group will be automatically answered.
         */
        auto_answer?: boolean;
        /**
         * Automatically save all in-meeting chats.
         */
        auto_saving_chat?: boolean;
        /**
         * Allow host to split meeting participants into separate, smaller rooms.
         */
        breakout_room?: boolean;
        /**
         * Allow meeting participants to send chat message visible to all participants.
         */
        chat?: boolean;
        /**
         * Allow host to type closed captions or assign a participant/third party device to add closed captions.
         */
        closed_caption?: boolean;
        /**
         * Allow the host to add co-hosts. Co-hosts have the same in-meeting controls as the host.
         */
        co_host?: boolean;
        /**
         * If set to `true`, you can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to be used by this group for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.
         */
        custom_data_center_regions?: boolean;
        /**
         * If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).
         *
         */
        data_center_regions?: 'EU' | 'HK' | 'AU' | 'IN' | 'TY' | 'CN' | 'US' | 'CA';
        /**
         * Require that all meetings are encrypted using AES.
         */
        e2e_encryption?: boolean;
        /**
         * Play sound when participants join or leave.
         */
        entry_exit_chime?: string;
        /**
         * Allow another user to take control of the camera during a meeting.
         */
        far_end_camera_control?: boolean;
        /**
         * Enable users to provide feedback to Zoom at the end of the meeting.
         */
        feedback?: boolean;
        /**
         * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for the users in the group or not.
         */
        file_transfer?: boolean;
        /**
         * Enable higher quality video for host and participants. This will require more bandwidth.
         */
        group_hd?: boolean;
        /**
         * Allow participants in a meeting can provide nonverbal feedback and express opinions by clicking on icons in the Participants panel.
         */
        non_verbal_feedback?: boolean;
        /**
         * Show the list of H.323/SIP devices only to the host.
         */
        only_host_view_device_list?: boolean;
        /**
         * Allow users to select original sound during a meeting.
         */
        original_audio?: boolean;
        /**
         * Add 'Polls' to the meeting controls. This allows the host to survey the attendees.
         */
        polling?: boolean;
        /**
         * Display end-of-meeting experience feedback survey.
         */
        post_meeting_feedback?: boolean;
        /**
         * Allow meeting participants to send a private 1:1 message to another participant.
         */
        private_chat?: boolean;
        /**
         * When each participant joins by telephone, allow the option to record and play their own voice as entry and exit chimes.
         */
        record_play_own_voice?: boolean;
        /**
         * During screen sharing, allow the person who is sharing to let others control the shared content.
         */
        remote_control?: boolean;
        /**
         * Allow meeting host to provide 1:1 remote support to another participant.
         */
        remote_support?: boolean;
        /**
         * Indicates whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option has been enabled for the group or not.
         */
        request_permission_to_unmute?: boolean;
        /**
         * Allow host and participants to share their screen or content during meetings.
         */
        screen_sharing?: boolean;
        /**
         * Allow users to invite participants by email only by default.
         */
        sending_default_email_invites?: boolean;
        /**
         * Allow participants to join a meeting directly from their browser.
         */
        show_browser_join_link?: boolean;
        /**
         * Show the list of H.323/SIP devices.
         */
        show_device_list?: boolean;
        /**
         * Always show meeting controls during a meeting.
         */
        show_meeting_control_toolbar?: boolean;
        /**
         * Allow users to select stereo audio during a meeting.
         */
        stereo_audio?: boolean;
        /**
         * Allow  HTML formatting instead of plain text for meeting invitations scheduled with the Outlook plugin.
         */
        use_html_format_email?: boolean;
        /**
         * Enable virtual background.
         */
        virtual_background?: boolean;
        /**
         * Settings to manage virtual background.
         */
        virtual_background_settings?: {
          /**
           * Allow users to upload custom backgrounds.
           */
          allow_upload_custom?: boolean;
          /**
           * Allow use of videos for virtual backgrounds.
           */
          allow_videos?: boolean;
          /**
           * Enable virtual background.
           */
          enable?: boolean;
          files?: Array<{
            /**
             * Unique identifier of the file.
             */
            id?: string;
            /**
             * Indicates whether or not this file is the default virtual background file.
             */
            is_default?: boolean;
            /**
             * File name.
             */
            name?: string;
            /**
             * File size.
             */
            size?: string;
            /**
             * File type.
             */
            type?: string;
          }>;
        };
        /**
         * Attendees cannot join a meeting until a host admits them individually from the waiting room.
         */
        waiting_room?: boolean;
        /**
         * Allow participants to share a whiteboard that includes annotation tools.
         */
        whiteboard?: boolean;
        /**
         * Indicates who can share their screen or content during meetings. The value can be one of the following: <br>
         * `host`: Only host can share the screen.<br>
         * `all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
         *
         */
        who_can_share_screen?: 'host' | 'all';
        /**
         * Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>
         * `host`: Only a host can share the screen when someone else is sharing.<br>
         * `all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
         *
         */
        who_can_share_screen_when_someone_is_sharing?: 'host' | 'all';
      };
      profile?: {
        recording_storage_location?: {
          /**
           * Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.
           *
           * Provide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.
           */
          allowed_values?: Array<string>;
          /**
           * Abbreviated country code.
           */
          value?: string;
        };
      };
      recording?: {
        /**
         * Make cloud recordings accessible to account members only.
         */
        account_user_access_recording?: boolean;
        /**
         * [Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted archiving solution access by the Zoom Support team.
         */
        archive?: {
          /**
           * Enable the archiving feature.
           */
          enable?: boolean;
          settings?: {
            /**
             * Include in-meeting and/or in-webinar audio in the archive.
             */
            audio_file?: boolean;
            /**
             * Include closed caption or transcript in the archive.
             */
            cc_transcript_file?: boolean;
            /**
             * Include in-meeting chat in the archive.
             */
            chat_file?: boolean;
            /**
             * Include user email in in-meeting chat file.
             */
            chat_with_sender_email?: boolean;
            /**
             * Include in-meeting and/or in-webinar video in the archive.
             */
            video_file?: boolean;
          };
          /**
           * Archive types:
           *
           * * `1`: Only meetings are archived.<br>
           * * `2`: Only webinars are archived.<br>
           * * `3`: Both meetings and webinars are archived.
           */
          type?: 1 | 2 | 3;
        };
        /**
         * Record meetings automatically as they start.
         */
        auto_recording?: string;
        /**
         * Allow hosts to record and save the meeting / webinar in the cloud.
         */
        cloud_recording?: boolean;
        /**
         * Allow anyone with a link to the cloud recording to download.
         */
        cloud_recording_download?: boolean;
        /**
         * Allow only the host with a link to the cloud recording to download.
         */
        cloud_recording_download_host?: boolean;
        /**
         * Allow the host to delete the recordings. If this option is disabled, the recordings cannot be deleted by the host and only admin can delete them.
         */
        host_delete_cloud_recording?: boolean;
        /**
         * Setting to allow cloud recording access only from specific IP address ranges.
         *
         */
        ip_address_access_control?: {
          /**
           * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
           *
           *
           */
          enable?: boolean;
          /**
           * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
           *
           * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
           *
           *
           */
          ip_addresses_or_ranges?: string;
        };
        /**
         * Allow hosts and participants to record the meeting to a local file.
         */
        local_recording?: boolean;
        /**
         * If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.
         *
         *
         */
        prevent_host_access_recording?: boolean;
        /**
         * Record an audio only file.
         */
        record_audio_file?: boolean;
        /**
         * When someone is sharing their screen, active speaker will show on the top right corner of the shared screen.
         */
        record_gallery_view?: boolean;
        /**
         * Record active speaker with shared screen.
         */
        record_speaker_view?: boolean;
        /**
         * Automatically transcribe the audio of a meeting or webinar for cloud recordings.
         */
        recording_audio_transcript?: boolean;
        /**
         * Save chat messages from the meeting / webinar.
         */
        save_chat_text?: boolean;
        /**
         * Add a timestamp to the recording.
         */
        show_timestamp?: boolean;
      };
      schedule_meeting?: {
        /**
         * Determine how participants can join the audio portion of the meeting.
         */
        audio_type?: string;
        /**
         * If the value is set to `true`, the meeting password will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the password.
         *
         */
        embed_password_in_join_link?: boolean;
        /**
         * If join before host option is enabled for a personal meeting, then enforce password requirement.
         *
         *
         * **This field will be deprecated in near future.** If you would like to enable this setting, we highly encourage you to use the `require_password_for_pmi_meetings` field.
         *
         *
         */
        force_pmi_jbh_password?: boolean;
        /**
         * Start meetings with host video on.
         */
        host_video?: boolean;
        /**
         * Allow participants to join the meeting before the host arrives
         */
        join_before_host?: boolean;
        /**
         * Automatically mute all participants when they join the meeting.
         */
        mute_upon_entry?: boolean;
        /**
         * Start meetings with participant video on.
         */
        participant_video?: boolean;
        /**
         * Personal Meeting Setting.<br><br>
         * `true`: Indicates that the **"Enable Personal Meeting ID"** setting is turned on. Users can choose to use personal meeting ID for their meetings. <br><br>
         * `false`: Indicates that the **"Enable Personal Meeting ID"** setting is [turned off](https://support.zoom.us/hc/en-us/articles/201362843-Personal-meeting-ID-PMI-and-personal-link#h_aa0335c8-3b06-41bc-bc1f-a8b84ef17f2a). If this setting is disabled, meetings that were scheduled with PMI will be invalid. Scheduled meetings will need to be manually updated.
         * For Zoom Phone only:If a user has been assigned a desk phone, **"Elevate to Zoom Meeting"** on desk phone will be disabled.
         *
         *
         *
         */
        personal_meeting?: boolean;
        /**
         * Generate and send new passwords for newly scheduled or edited meetings.
         */
        pstn_password_protected?: boolean;
        /**
         * If enabled, a random password will be generated on the user's end who starts the instant meeting. Other participants will have to enter the password to join the meeting. If you use PMI for your instant meetings, this option will be disabled.
         */
        require_password_for_instant_meetings?: boolean;
        /**
         * Indicates whether a password is required for [PMI](https://support.zoom.us/hc/en-us/articles/203276937-Using-Personal-Meeting-ID-PMI-) meetings or not. The value can be one of the following:<br>
         * `none`: Do not require password for PMI meetings.<br>
         * `all`: Require participants to enter password for all PMI enabled meetings.<br> `jbh_only`: Require password only for meetings where the **"join before host"** setting is enabled.
         */
        require_password_for_pmi_meetings?: 'all' | 'jbh_only' | 'none';
        /**
         * Require a password for meetings which have already been scheduled
         *
         */
        require_password_for_scheduled_meetings?: boolean;
        /**
         * This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting.
         */
        require_password_for_scheduling_new_meetings?: boolean;
        /**
         * Receive desktop notification for upcoming meetings.
         */
        upcoming_meeting_reminder?: boolean;
        /**
         * Indicates whether PMI is enabled for all instant meetings or not.
         */
        use_pmi_for_instant_meetings?: boolean;
        /**
         * Indicates whether PMI is enabled for all scheduled meetings or not.
         */
        use_pmi_for_schedule_meetings?: boolean;
      };
      telephony?: {
        audio_conference_info?: string;
        /**
         * Indicates where most of the participants call into or call from duriing a meeting.
         */
        telephony_regions?: {
          /**
           * Telephony regions selected by the account to indicate where most of the participants call into or call from during a meeting.
           */
          selection_values?: Array<string>;
        };
        /**
         * Allow users to join the meeting using the existing 3rd party audio configuration.
         */
        third_party_audio?: boolean;
      };
    }
  | (
      | {
          /**
           * Meeting Authentication Options
           */
          authentication_options?: Array<{
            /**
             * Authentication default option
             */
            default_option?: boolean;
            /**
             * Authentication domains
             */
            domains?: string;
            /**
             * Authentication id
             */
            id?: string;
            /**
             * Authentication name
             */
            name?: string;
            /**
             *  Authentication type. Specify one of the following authentication types for the authentication profile:<br>
             * * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.
             * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>
             * * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.
             */
            type?: 'enforce_login' | 'enforce_login_with_same_account' | 'enforce_login_with_domains';
            /**
             * Authentication visible
             */
            visible?: boolean;
          }>;
          /**
           * Only authenticated users can join meetings
           */
          meeting_authentication?: boolean;
        }
      | {
          /**
           * Authentication Options
           */
          authentication_options?: Array<{
            /**
             * Authentication default option
             */
            default_option?: boolean;
            /**
             * Authentication domians
             */
            domains?: string;
            /**
             * Authentication id
             */
            id?: string;
            /**
             * Authentication name
             */
            name?: string;
            /**
             * Authentication type
             */
            type?: 'internally' | 'enforce_login' | 'enforce_login_with_domains';
            /**
             * Authentication visible
             */
            visible?: boolean;
          }>;
          /**
           * Only authenticated users can view cloud recordings
           */
          recording_authentication?: boolean;
        }
    )
  | {
      meeting_security?: {
        /**
         * `true`: Require that all meetings are secured with at least one security option.
         *
         * This setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).
         */
        auto_security?: boolean;
        /**
         * If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.
         *
         */
        embed_password_in_join_link?: boolean;
        /**
         * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
         * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
         *
         * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
         */
        encryption_type?: 'enhanced_encryption' | 'e2ee';
        /**
         * Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.
         */
        end_to_end_encrypted_meetings?: boolean;
        /**
         * If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.
         */
        meeting_password?: boolean;
        /**
         * Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
         */
        meeting_password_requirement?: {
          consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
          /**
           * If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).
           *
           */
          have_letter?: boolean;
          /**
           * If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).
           */
          have_number?: boolean;
          /**
           * If set to `true`, the passcode must have at least 1 special character (!,@,#...).
           */
          have_special_character?: boolean;
          /**
           * If set to `true`, the passcode must include both uppercase and lowercase characters.
           */
          have_upper_and_lower_characters?: boolean;
          /**
           * The minimum length that the meeting/webinar passcode needs to have.
           */
          length?: number;
          /**
           * If set to `true`, the passcode must only contain numbers and no other characters.
           */
          only_allow_numeric?: boolean;
          /**
           * If set to `true`, users will be informed if the provided passcode is weak.
           */
          weak_enhance_detection?: boolean;
        };
        /**
         * Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.
         */
        phone_password?: boolean;
        /**
         * If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.
         *
         */
        pmi_password?: boolean;
        /**
         * Require a passcode for meetings which have already been scheduled.
         *
         */
        require_password_for_scheduled_meeting?: boolean;
        /**
         * Require a passcode for webinars which have already been scheduled.
         *
         */
        require_password_for_scheduled_webinar?: boolean;
        /**
         * When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.
         *
         */
        waiting_room?: boolean;
        /**
         * Specify the settings to be applied if waiting room is enabled.
         */
        waiting_room_settings?: {
          /**
           *
           *
           * Specify who should be admitted to the waiting room. The value of this field can be one of the following:<br>
           * `0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in
           */
          participants_to_place_in_waiting_room?: 0 | 1 | 2;
          /**
           * Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>
           * `0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).
           *
           *
           *
           */
          users_who_can_admit_participants_from_waiting_room?: number;
          /**
           * If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").
           */
          whitelisted_domains_for_waiting_room?: string;
        };
        /**
         * If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.
         *
         */
        webinar_password?: boolean;
      };
    };

export type GetGroupSettingsError = unknown;

export type UpdateGroupSettingsData = {
  body?:
    | {
        email_notification?: {
          /**
           * Notify the alternative host who is set or removed.
           */
          alternative_host_reminder?: boolean;
          /**
           * Notify host and participants when the meeting is cancelled.
           */
          cancel_meeting_reminder?: boolean;
          /**
           * Notify host when cloud recording is available.
           */
          cloud_recording_available_reminder?: boolean;
          /**
           * Notify host when participants join the meeting before them.
           */
          jbh_reminder?: boolean;
          /**
           * Notify the host there is a meeting is scheduled, rescheduled, or cancelled.
           */
          schedule_for_host_reminder?: boolean;
        };
        in_meeting?: {
          /**
           * Allow participants who belong to your account to see that a guest (someone who does not belong to your account) is participating in the meeting/webinar.
           */
          alert_guest_join?: boolean;
          /**
           * Show Zoom windows during screen share.
           */
          allow_show_zoom_windows?: boolean;
          /**
           * Allow participants to use annotation tools to add information to shared screens.
           */
          annotation?: boolean;
          /**
           * Allow host to put attendee on hold.
           *
           * **This field has been deprecated and is no longer supported.**
           */
          attendee_on_hold?: boolean;
          /**
           * Enable users to see and add contacts to 'auto-answer group' in the contact list on chat. Any call from members of this group will be automatically answered.
           */
          auto_answer?: boolean;
          /**
           * Automatically save all in-meeting chats.
           */
          auto_saving_chat?: boolean;
          /**
           * Allow host to split meeting participants into separate, smaller rooms.
           */
          breakout_room?: boolean;
          /**
           * Allow meeting participants to send chat message visible to all participants.
           */
          chat?: boolean;
          /**
           * Allow host to type closed captions or assign a participant/third party device to add closed captions.
           */
          closed_caption?: boolean;
          /**
           * Allow the host to add co-hosts. Co-hosts have the same in-meeting controls as the host.
           */
          co_host?: boolean;
          /**
           * If set to `true`, you can [select data center regions](https://support.zoom.us/hc/en-us/articles/360042411451-Selecting-data-center-regions-for-hosted-meetings-and-webinars) to be used by this group for hosting their real-time meeting and webinar traffic. These regions can be provided in the `data_center_regions` field. If set to `false`, the regions cannot be customized and the default regions will be used.
           */
          custom_data_center_regions?: boolean;
          /**
           * If you have set the value of `custom_data_center_regions` to `true`, specify the data center regions that you would like to opt in to (country codes from among: ["EU", "HK", "AU", "IN", "LA", "TY", "CN", "US", "CA"]).
           *
           */
          data_center_regions?: 'EU' | 'HK' | 'AU' | 'IN' | 'TY' | 'CN' | 'US' | 'CA';
          /**
           * Require that all meetings are encrypted using AES.
           */
          e2e_encryption?: boolean;
          /**
           * Play sound when participants join or leave.
           */
          entry_exit_chime?: string;
          /**
           * Allow another user to take control of the camera during a meeting.
           */
          far_end_camera_control?: boolean;
          /**
           * Enable users to provide feedback to Zoom at the end of the meeting.
           */
          feedback?: boolean;
          /**
           * Indicates whether [in-meeting file transfer](https://support.zoom.us/hc/en-us/articles/209605493-In-meeting-file-transfer) setting has been enabled for the users in the group or not.
           */
          file_transfer?: boolean;
          /**
           * Enable higher quality video for host and participants. This will require more bandwidth.
           */
          group_hd?: boolean;
          /**
           * Allow participants in a meeting can provide nonverbal feedback and express opinions by clicking on icons in the Participants panel.
           */
          non_verbal_feedback?: boolean;
          /**
           * Show the list of H.323/SIP devices only to the host.
           */
          only_host_view_device_list?: boolean;
          /**
           * Allow users to select original sound during a meeting.
           */
          original_audio?: boolean;
          /**
           * Add 'Polls' to the meeting controls. This allows the host to survey the attendees.
           */
          polling?: boolean;
          /**
           * Display end-of-meeting experience feedback survey.
           */
          post_meeting_feedback?: boolean;
          /**
           * Allow meeting participants to send a private 1:1 message to another participant.
           */
          private_chat?: boolean;
          /**
           * When each participant joins by telephone, allow the option to record and play their own voice as entry and exit chimes.
           */
          record_play_own_voice?: boolean;
          /**
           * During screen sharing, allow the person who is sharing to let others control the shared content.
           */
          remote_control?: boolean;
          /**
           * Allow meeting host to provide 1:1 remote support to another participant.
           */
          remote_support?: boolean;
          /**
           * Indicate whether the [**Request permission to unmute participants**](https://support.zoom.us/hc/en-us/articles/203435537-Muting-and-unmuting-participants-in-a-meeting#h_01EGK4XFWS1SJGZ71MYGKF7260) option should be enabled for the group or not.
           */
          request_permission_to_unmute?: boolean;
          /**
           * Allow host and participants to share their screen or content during meetings.
           */
          screen_sharing?: boolean;
          /**
           * Allow users to invite participants by email only by default.
           */
          sending_default_email_invites?: boolean;
          /**
           * Allow participants to join a meeting directly from their browser.
           */
          show_browser_join_link?: boolean;
          /**
           * Show the list of H.323/SIP devices.
           */
          show_device_list?: boolean;
          /**
           * Always show meeting controls during a meeting.
           */
          show_meeting_control_toolbar?: boolean;
          /**
           * Allow users to select stereo audio during a meeting.
           */
          stereo_audio?: boolean;
          /**
           * Allow  HTML formatting instead of plain text for meeting invitations scheduled with the Outlook plugin.
           */
          use_html_format_email?: boolean;
          /**
           * Enable virtual background.
           */
          virtual_background?: boolean;
          /**
           * Attendees cannot join a meeting until a host admits them individually from the waiting room.
           */
          waiting_room?: boolean;
          /**
           * Allow participants to share a whiteboard that includes annotation tools.
           */
          whiteboard?: boolean;
          /**
           * Indicates who can share their screen or content during meetings. The value can be one of the following: <br>
           * `host`: Only host can share the screen.<br>
           * `all`: Both hosts and attendees can share their screen during meetings. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
           *
           */
          who_can_share_screen?: 'host' | 'all';
          /**
           * Indicates who is allowed to start sharing screen when someone else in the meeting is sharing their screen. The value can be one of the following:<br>
           * `host`: Only a host can share the screen when someone else is sharing.<br>
           * `all`: Anyone in the meeting is allowed to start sharing their screen when someone else is sharing. For Webinar, the hosts and panelists can start screen sharing, but not the attendees.
           *
           */
          who_can_share_screen_when_someone_is_sharing?: 'host' | 'all';
        };
        profile?: {
          recording_storage_location?: {
            /**
             * Users can choose the country to store their recorded content. Content can include meeting, webinar, and phone recordings, as well as voicemail, transcripts, and custom greeting prompts. See [Managing the Communications Content storage location](https://support.zoom.us/hc/en-us/articles/360050781131) for details.
             *
             * Provide abbreviated country codes as the value for this field. See the [Countries abbreviation list](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) for details.
             */
            allowed_values?: Array<string>;
            /**
             * Abbreviated country code.
             */
            value?: string;
          };
        };
        recording?: {
          /**
           * Make cloud recordings accessible to account members only.
           */
          account_user_access_recording?: boolean;
          /**
           * [Archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) settings. This setting can only be used if you have been granted archiving solution access by the Zoom Support team.
           */
          archive?: {
            /**
             * Enable the archiving feature.
             */
            enable?: boolean;
            settings?: {
              /**
               * Include in-meeting and/or in-webinar audio in the archive.
               */
              audio_file?: boolean;
              /**
               * Include closed caption or transcript in the archive.
               */
              cc_transcript_file?: boolean;
              /**
               * Include in-meeting chat in the archive.
               */
              chat_file?: boolean;
              /**
               * Include user email in in-meeting chat file.
               */
              chat_with_sender_email?: boolean;
              /**
               * Include in-meeting and/or in-webinar video in the archive.
               */
              video_file?: boolean;
            };
            /**
             * Archive types:
             *
             * * `1`: Only meetings are archived.<br>
             * * `2`: Only webinars are archived.<br>
             * * `3`: Both meetings and webinars are archived.
             */
            type?: 1 | 2 | 3;
          };
          /**
           * Record meetings automatically as they start.
           */
          auto_recording?: string;
          /**
           * Allow hosts to record and save the meeting / webinar in the cloud.
           */
          cloud_recording?: boolean;
          /**
           * Allow anyone with a link to the cloud recording to download.
           */
          cloud_recording_download?: boolean;
          /**
           * Allow only the host with a link to the cloud recording to download.
           */
          cloud_recording_download_host?: boolean;
          /**
           * Allow the host to delete the recordings. If this option is disabled, the recordings cannot be deleted by the host and only admin can delete them.
           */
          host_delete_cloud_recording?: boolean;
          /**
           * Setting to allow cloud recording access only from specific IP address ranges.
           *
           */
          ip_address_access_control?: {
            /**
             * If set to `true`, the cloud recordings of this account can only be accessed by the IP addresses defined in the `ip_addresses_or_ranges` property.
             *
             *
             */
            enable?: boolean;
            /**
             * IP addresses or ranges that have access to the cloud recordings. Separate multiple IP ranges with comma. Use n.n.n.n, n.n.n.n/n or n.n.n.n - n.n.n.n syntax where n is a number.
             *
             * Example: `46.33.24.184, 48.99.100.2/25` or `200.181.108.17 - 220.181.108.157`
             *
             *
             */
            ip_addresses_or_ranges?: string;
          };
          /**
           * Allow hosts and participants to record the meeting to a local file.
           */
          local_recording?: boolean;
          /**
           * If set to `true`, meeting hosts cannot view their meeting cloud recordings. Only the admins who have recording management privilege can access them.
           *
           *
           */
          prevent_host_access_recording?: boolean;
          /**
           * Record an audio only file.
           */
          record_audio_file?: boolean;
          /**
           * When someone is sharing their screen, active speaker will show on the top right corner of the shared screen.
           */
          record_gallery_view?: boolean;
          /**
           * Record active speaker with shared screen.
           */
          record_speaker_view?: boolean;
          /**
           * Automatically transcribe the audio of a meeting or webinar for cloud recordings.
           */
          recording_audio_transcript?: boolean;
          /**
           * Save chat messages from the meeting / webinar.
           */
          save_chat_text?: boolean;
          /**
           * Add a timestamp to the recording.
           */
          show_timestamp?: boolean;
        };
        schedule_meeting?: {
          /**
           * Determine how participants can join the audio portion of the meeting.
           */
          audio_type?: string;
          /**
           * If the value is set to `true`, the meeting password will be encrypted and included in the join meeting link to allow participants to join with just one click without having to enter the password.
           *
           */
          embed_password_in_join_link?: boolean;
          /**
           * If join before host option is enabled for a personal meeting, then enforce password requirement.
           */
          force_pmi_jbh_password?: boolean;
          /**
           * Start meetings with host video on.
           */
          host_video?: boolean;
          /**
           * Allow participants to join the meeting before the host arrives
           */
          join_before_host?: boolean;
          /**
           * Automatically mute all participants when they join the meeting.
           */
          mute_upon_entry?: boolean;
          /**
           * Start meetings with participant video on.
           */
          participant_video?: boolean;
          /**
           * Generate and send new passwords for newly scheduled or edited meetings.
           */
          pstn_password_protected?: boolean;
          /**
           * Require password from all participants before joining a meeting.
           */
          require_password_for_all_meetings?: boolean;
          /**
           * If enabled, a random password will be generated on the user's end who starts the instant meeting. Other participants will have to enter the password to join the meeting. If you use PMI for your instant meetings, this option will be disabled.
           */
          require_password_for_instant_meetings?: boolean;
          /**
           * Indicates whether a password is required for [PMI](https://support.zoom.us/hc/en-us/articles/203276937-Using-Personal-Meeting-ID-PMI-) meetings or not. The value can be one of the following:<br>
           * `none`: Do not require password for PMI meetings.<br>
           * `all`: Require participants to enter password for all PMI enabled meetings.<br> `jbh_only`: Require password only for meetings where the **"join before host"** setting is enabled.
           */
          require_password_for_pmi_meetings?: 'all' | 'jbh_only' | 'none';
          /**
           * Require a password for meetings which have already been scheduled
           *
           */
          require_password_for_scheduled_meetings?: boolean;
          /**
           * This setting applies for regular meetings that do not use PMI. If enabled, a password will be generated while a host schedules a new meeting and participants will be required to enter the password before they can join the meeting.
           */
          require_password_for_scheduling_new_meetings?: boolean;
          /**
           * Receive desktop notification for upcoming meetings.
           */
          upcoming_meeting_reminder?: boolean;
        };
        telephony?: {
          audio_conference_info?: string;
          /**
           * Allow users to join the meeting using the existing 3rd party audio configuration.
           */
          third_party_audio?: boolean;
        };
      }
    | (
        | {
            /**
             * Meeting Authentication Options
             */
            authentication_option?: {
              /**
               * Authentication action
               */
              action?: 'update' | 'show' | 'hide';
              /**
               * Authentication default option
               */
              default_option?: boolean;
              /**
               * Authentication domains
               */
              domains?: string;
              /**
               * Authentication id
               */
              id?: string;
              /**
               * Authentication name
               */
              name?: string;
              /**
               *  Authentication type. Specify one of the following authentication types for the authentication profile:<br>
               * * `enforce_login`: This option allows any users to join the meeting or webinar, as long as they are signed into their Zoom account.
               * * `enforce_login_with_domains`: This option, allows you to specify a rule so that only those Zoom users whose email addresses contain a certain domain, can join the meeting or webinar. You can either add multiple domains using a comma in between and/or use a wildcard for listing domains.<br>
               * * `enforce_login_with_same_account`: This option allows users to join the meeting or webinar with the same Zoom account.
               */
              type?: 'enforce_login' | 'enforce_login_with_same_account' | 'enforce_login_with_domains';
            };
            /**
             * Only authenticated users can join meetings
             */
            meeting_authentication?: boolean;
          }
        | {
            /**
             * Authentication Options
             */
            authentication_option?: {
              /**
               * Authentication action
               */
              action?: 'update' | 'show' | 'hide';
              /**
               * Authentication default option
               */
              default_option?: boolean;
              /**
               * Authentication domians
               */
              domians?: string;
              /**
               * Authentication id
               */
              id?: string;
              /**
               * Authentication name
               */
              name?: string;
              /**
               * Authentication type
               */
              type?: 'internally' | 'enforce_login' | 'enforce_login_with_domains';
            };
            /**
             * Only authenticated users can view cloud recordings
             */
            recording_authentication?: boolean;
          }
      )
    | {
        meeting_security?: {
          /**
           * `true`: Require that all meetings are secured with at least one security option.
           *
           * This setting can only be disabled by Enterprise, ISV, Business (with more than 100 licenses), and Education accounts. [Learn more](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#meeting-security).
           */
          auto_security?: boolean;
          /**
           * If set to `true`, meeting passcode will be encrypted and included in the invite link to allow participants to join with just one click without having to enter the passcode.
           *
           */
          embed_password_in_join_link?: boolean;
          /**
           * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
           * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
           *
           * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
           */
          encryption_type?: 'enhanced_encryption' | 'e2ee';
          /**
           * Allow use of end-to-end encryption for meetings. If set to `true`, you can specify the encryption type in `encryption_type` field.
           */
          end_to_end_encrypted_meetings?: boolean;
          /**
           * If set to `true`, all instant, and scheduled meetings that users can join via client, or room systems will be passcode-protected. The Personal Meeting ID (PMI) meetings are not included in this setting.
           */
          meeting_password?: boolean;
          /**
           * Meeting/webinar [passcode requirements](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604).
           */
          meeting_password_requirement?: {
            consecutive_characters_length?: 0 | 4 | 5 | 6 | 7 | 8;
            /**
             * If set to `true`, the passcode must contain at least 1 letter (such as a,b,c...).
             *
             */
            have_letter?: boolean;
            /**
             * If set to `true`, the passcode must contain at least 1 number (such as 1,2,3...).
             */
            have_number?: boolean;
            /**
             * If set to `true`, the passcode must have at least 1 special character (!,@,#...).
             */
            have_special_character?: boolean;
            /**
             * If set to `true`, the passcode must include both uppercase and lowercase characters.
             */
            have_upper_and_lower_characters?: boolean;
            /**
             * The minimum length that the meeting/webinar passcode needs to have.
             */
            length?: number;
            /**
             * If set to `true`, the passcode must only contain numbers and no other characters.
             */
            only_allow_numeric?: boolean;
            /**
             * If set to `true`, users will be informed if the provided passcode is weak.
             */
            weak_enhance_detection?: boolean;
          };
          /**
           * Require passcode for participants joining by phone. If set to `true`, a numeric passcode will be required for participants joining by phone if your meeting has a passcode. For meeting with an alphanumeric passcode, a numeric version will be generated.
           */
          phone_password?: boolean;
          /**
           * If set to `true`, all Personal Meeting ID (PMI) meetings that users can join via client, or room systems will be passcode-protected.
           *
           */
          pmi_password?: boolean;
          /**
           * Require a passcode for meetings which have already been scheduled.
           *
           */
          require_password_for_scheduled_meeting?: boolean;
          /**
           * Require a passcode for webinars which have already been scheduled.
           *
           */
          require_password_for_scheduled_webinar?: boolean;
          /**
           * When participants join a meeting, place them in a waiting room and require the host to admit them individually. Enabling the waiting room automatically disables the setting for allowing participants to join before host.
           *
           */
          waiting_room?: boolean;
          /**
           * Specify the settings to be applied if waiting room is enabled.
           */
          waiting_room_settings?: {
            /**
             *
             *
             * Specify who should be admitted to the waiting room. The value of this field can be one of the following:<br>
             * `0`: All attendees<br> `1`: Users who are not in your account<br> `2`: Users who are not in your account and are not part of your whitelisted domains that are specified in
             */
            participants_to_place_in_waiting_room?: 0 | 1 | 2;
            /**
             * Specify who can admit participants from the waiting room. The value of this field can be one of the following:<br>
             * `0`: Host and co-hosts only<br> `1`: Host, co-hosts, and anyone who bypassed the waiting room (only if host and co-hosts are not present).
             *
             *
             *
             */
            users_who_can_admit_participants_from_waiting_room?: number;
            /**
             * If the value of the `participants_to_place_in_waiting_room` field is `2`, use this setting to specify the domains that can bypass the waiting room feature. Separate multiple domains with commas(example: "aaa.com,bbb.com").
             */
            whitelisted_domains_for_waiting_room?: string;
          };
          /**
           * If set to `true`, a passcode will be generated when scheduling a Webinar and participants require the passcode to join the Webinar.
           *
           */
          webinar_password?: boolean;
        };
      };
  path: {
    /**
     * Id of the group.
     */
    groupId: string;
  };
  query?: {
    /**
     * Provide the name of the field by which you would like to filter the response. For example, if you provide "host_video" as the value of this field, you will get a response similar to the following:<br>
     * {
     * "schedule_meeting": {
     * "host_video": false
     * }
     * }
     * <br>You can provide multiple values by separating them with commas(example: "host_video,participant_video”).
     */
    custom_query_fields?: string;
    option?: 'meeting_authentication' | 'recording_authentication' | 'meeting_security';
  };
};

export type UpdateGroupSettingsResponse = unknown;

export type UpdateGroupSettingsError = unknown;

export type DelGroupVbData = {
  path: {
    /**
     * Unique identifier of the group. Retrieve the value for this field by calling the [List groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups) API.
     */
    groupId: string;
  };
  query?: {
    /**
     * Provide the id of the file that is to be deleted. To delete multiple files, provide comma separated values for this field.
     */
    file_ids?: string;
  };
};

export type DelGroupVbResponse = any;

export type DelGroupVbError = unknown;

export type UploadGroupVbData = {
  body?: {
    /**
     * Provide the file's path here.
     */
    file?: string;
  };
  path: {
    /**
     * Unique identifier of the group. Retrieve the value for this field by calling the [List groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups) API.
     */
    groupId: string;
  };
  query?: {
    /**
     * Provide the id of the file that is to be deleted. To delete multiple files, provide comma separated values for this field.
     */
    file_ids?: string;
  };
};

export type UploadGroupVbResponse = {
  /**
   * Unique identifier of the file.
   */
  id?: string;
  /**
   * Indicate whether or not this file is the default virtual background file.
   */
  is_default?: boolean;
  /**
   * File name.
   */
  name?: string;
  /**
   * File size.
   */
  size?: string;
  /**
   * File type.
   */
  type?: string;
};

export type UploadGroupVbError = unknown;

export type DeviceListData = {
  query?: {
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     *
     * **Deprecated** - This field has been deprecated and we will stop supporting it completely in a future release. Please use "next_page_token" for pagination instead of this field.
     *
     * The page number of the current page in the returned records.
     */
    page_number?: number;
    /**
     * The number of records returned within a single API call.
     */
    page_size?: number;
  };
};

export type DeviceListResponse = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of H.323/SIP Device objects.
   */
  devices?: Array<
    {
      /**
       * Device ID.
       */
      id?: string;
    } & {
      /**
       * Device encryption:<br>`auto` - auto.<br>`yes` - yes.<br>`no` - no.
       */
      encryption: 'auto' | 'yes' | 'no';
      /**
       * Device IP.
       */
      ip: string;
      /**
       * Device name.
       */
      name: string;
      /**
       * Device protocol:<br>`H.323` - H.323.<br>`SIP` - SIP.
       */
      protocol: 'H.323' | 'SIP';
    }
  >;
};

export type DeviceListError = unknown;

export type DeviceCreateData = {
  /**
   * H.323/SIP device.
   */
  body: {
    /**
     * Device encryption:<br>`auto` - auto.<br>`yes` - yes.<br>`no` - no.
     */
    encryption: 'auto' | 'yes' | 'no';
    /**
     * Device IP.
     */
    ip: string;
    /**
     * Device name.
     */
    name: string;
    /**
     * Device protocol:<br>`H.323` - H.323.<br>`SIP` - SIP.
     */
    protocol: 'H.323' | 'SIP';
  };
};

export type DeviceCreateResponse =
  | unknown
  | ({
      /**
       * Device ID.
       */
      id?: string;
    } & {
      /**
       * Device encryption:<br>`auto` - auto.<br>`yes` - yes.<br>`no` - no.
       */
      encryption: 'auto' | 'yes' | 'no';
      /**
       * Device IP.
       */
      ip: string;
      /**
       * Device name.
       */
      name: string;
      /**
       * Device protocol:<br>`H.323` - H.323.<br>`SIP` - SIP.
       */
      protocol: 'H.323' | 'SIP';
    });

export type DeviceCreateError = unknown;

export type DeviceDeleteData = {
  path: {
    /**
     * The device ID.
     */
    deviceId: string;
  };
};

export type DeviceDeleteResponse = unknown | any;

export type DeviceDeleteError = unknown;

export type DeviceUpdateData = {
  body: {
    /**
     * Device encryption:<br>`auto` - auto.<br>`yes` - yes.<br>`no` - no.
     */
    encryption: 'auto' | 'yes' | 'no';
    /**
     * Device IP.
     */
    ip: string;
    /**
     * Device name.
     */
    name: string;
    /**
     * Device protocol:<br>`H.323` - H.323.<br>`SIP` - SIP.
     */
    protocol: 'H.323' | 'SIP';
  };
  path: {
    /**
     * The device ID.
     */
    deviceId: string;
  };
};

export type DeviceUpdateResponse = any;

export type DeviceUpdateError = unknown;

export type SendchatbotData = {
  body?: {
    /**
     * Account ID of the authorized account.
     */
    account_id: string;
    /**
     * JSON template describing how the message should be displayed for the user. For more information please see our ["Send Message" templates](https://marketplace.zoom.us/docs/guides/chatbots/sending-messages#example-request).
     */
    content: {
      [key: string]: unknown;
    };
    /**
     * **Optional**<br>
     * Applies the markdown parser to your chatbot message if the value of this field is set to `true`.<br> To learn more, refer to the Chatbot message [markdown reference](https://marketplace.zoom.us/docs/guides/chatbots/customizing-messages/message-with-markdown).
     */
    is_markdown_support?: boolean;
    /**
     * Robot JID created when enabling chatbot features on your marketplace app.
     */
    robot_jid: string;
    /**
     * Unique JID of reciever. Can be a group or user.
     */
    to_jid: string;
    /**
     * **Optional**<br>
     * The UserJID of the user on whose behalf the message is being sent. Use this field to prevent members of a channel from getting notifications that were set up by a user who has left the channel.
     */
    user_jid?: string;
    /**
     * **Optional**<br>Allow a Chatbot to send a message to a group channel, but have only one designated person in that group channel see the message by providing the person's UserID in this field.
     */
    visible_to_user?: string;
  };
};

export type SendchatbotResponse = unknown;

export type SendchatbotError = unknown;

export type DeleteAchatbotMessageData = {
  body?: {
    /**
     * The AccountID of the Zoom account to which the message was sent. Retrieve this from the Chatbot request sent to your server as shown in the example [here]( https://marketplace.zoom.us/docs/guides/chatbots/sending-messages).
     */
    account_id: string;
    /**
     * The BotJID found in the Chat Subscription Section on the Features page of your App Dashboard.
     */
    robot_jid: string;
    /**
     * The UserJID of the user on whose behalf the message is being sent. Used to prevent members of a channel from getting notifications that were set up by a user who has left the channel.
     */
    user_jid?: string;
  };
  path: {
    message_id: string;
  };
};

export type DeleteAchatbotMessageResponse = {
  /**
   * Unique identifier of the message that was deleted.
   */
  message_id?: string;
  /**
   * The BotJID of the Chatbot app. It can be found in the Chat Subscription Section on the Features page of your App Dashboard
   */
  robot_jid?: string;
  /**
   * The date and time at which the message was deleted.
   */
  sent_time?: string;
  /**
   * The JID of the Channel or User to whom the message was sent.
   */
  to_jid?: string;
  /**
   *  The UserJID of the user on whose behalf the message was sent. Used to prevent members of a channel from getting notifications that were set up by a user who has left the channel.
   */
  user_jid?: string;
};

export type DeleteAchatbotMessageError = unknown;

export type EditChatbotMessageData = {
  body?: {
    /**
     * The AccountID of the Zoom account to which the message was sent. Retrieve this from the Chatbot request sent to your server as shown in the example [here]( https://marketplace.zoom.us/docs/guides/chatbots/sending-messages).
     */
    account_id: string;
    /**
     * JSON template describing how the edited message should be displayed for the user. For more information please see our ["Send Message" templates](https://marketplace.zoom.us/docs/guides/chatbots/sending-messages#example-request).
     */
    content: {
      [key: string]: unknown;
    };
    /**
     * **Optional**<br>
     * Enable or disable markdown parser to your chatbot message. Applies the markdown parser to your chatbot message if the value of this field is set to `true`.<br> To learn more, refer to the Chatbot message [markdown reference](https://marketplace.zoom.us/docs/guides/chatbots/customizing-messages/message-with-markdown).
     */
    is_markdown_support?: boolean;
    /**
     * Robot JID created when enabling chatbot features on your marketplace app.
     */
    robot_jid: string;
    /**
     * **Optional**<br>
     * The UserJID of the user on whose behalf the message is being sent. Use this field to prevent members of a channel from getting notifications that were set up by a user who has left the channel.
     */
    user_jid?: string;
  };
  path: {
    /**
     * Unique Identifier of the message that needs to be updated. This should be retrieved from the response of [Send Chatbot Message API](https://marketplace.zoom.us/docs/api-reference/zoom-api/im-chat/sendchatbot).
     */
    message_id: string;
  };
};

export type EditChatbotMessageResponse = {
  /**
   * Unique Identifier of the updated message,
   */
  message_id?: string;
  /**
   * The BotJID found in the Chat Subscription Section on the Features page of your App Dashboard.
   */
  robot_jid?: string;
  /**
   * The date and time at which the message was sent.
   */
  sent_time?: string;
  /**
   * The JID of the Channel or User to whom the message was sent.
   */
  to_jid?: string;
  /**
   * The UserJID of the user on whose behalf the message is being sent. Used to prevent members of a channel from getting notifications that were set up by a user who has left the channel.
   */
  user_jid?: string;
};

export type EditChatbotMessageError = unknown;

export type ImChatSessionsData = {
  query: {
    /**
     * Start date in 'yyyy-mm-dd' format. The date range defined by the "from" and "to" parameters should only be one month as the report includes only one month worth of data at once.
     */
    from: string;
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     * The number of records returned within a single API call.
     */
    page_size?: number;
    /**
     * End date.
     */
    to: string;
  };
};

export type ImChatSessionsResponse = {
  /**
   * Start date.
   */
  from?: string;
  /**
   * End date.
   */
  to?: string;
} & {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of the available result list exceeds the page size. The expiration period is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The amount of records returns within a single API call.
   */
  page_size?: number;
} & {
  /**
   * Array of session objects.
   */
  sessions?: Array<{
    /**
     * Last message sent time.
     */
    last_message_sent_time?: string;
    /**
     * Meeting topic.
     */
    name?: string;
    /**
     * IM chat session ID.
     */
    session_id?: string;
    /**
     * IM chat session type.
     */
    type?: 'Group' | '1:1';
  }>;
};

export type ImChatSessionsError = unknown;

export type ImChatMessagesData = {
  path: {
    /**
     * IM chat session ID.
     */
    sessionId: string;
  };
  query: {
    /**
     * Start date in 'yyyy-mm-dd' format. The date range defined by the "from" and "to" parameters should only be one month as the report includes only one month worth of data at once.
     */
    from: string;
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     * The number of records returned within a single API call.
     */
    page_size?: number;
    /**
     * End date.
     */
    to: string;
  };
};

export type ImChatMessagesResponse = {
  /**
   * Start date.
   */
  from?: string;
  /**
   * IM chat session ID.
   */
  session_id?: string;
  /**
   * End date.
   */
  to?: string;
} & {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of the available result list exceeds the page size. The expiration period is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The amount of records returns within a single API call.
   */
  page_size?: number;
} & {
  /**
   * Array of session objects.
   */
  messages?: Array<{
    /**
     * IM chat message action.
     */
    action?: string;
    /**
     * Action time.
     */
    action_time?: string;
    /**
     * IM chat message sent time.
     */
    date_time?: string;
    /**
     * IM chat message content.
     */
    message?: string;
    /**
     * IM chat message sender.
     */
    sender?: string;
  }>;
};

export type ImChatMessagesError = unknown;

export type ImGroupsResponse = {
  /**
   * Total number of records returned.
   */
  total_records?: number;
} & {
  /**
   * List of group objects.
   */
  groups?: Array<
    {
      /**
       * IM group ID.
       */
      id?: string;
    } & ({
      /**
       * Group name.
       */
      name?: string;
      /**
       * Total number of members in this group.
       */
      total_members?: number;
    } & {
      /**
       * Members can search for others under same account.
       */
      search_by_account?: boolean;
      /**
       * Members can search for others in the same email domain.
       */
      search_by_domain?: boolean;
      /**
       * Members can search for others under same master account - including all sub accounts.
       */
      search_by_ma_account?: boolean;
      /**
       * IM Group types:<br>`normal` - Only members can see the other members in the group. Other people can search for members in the group.<br>`shared` - Everyone in the account can see the group and members. <br>`restricted` - No one except group members can see the group or search for other group members.
       */
      type?: 'normal' | 'shared' | 'restricted';
    })
  >;
};

export type ImGroupsError = unknown;

export type ImGroupCreateData = {
  body: {
    /**
     * Group name: must be unique to one account.
     */
    name?: string;
    /**
     * Members can search for others under same account.
     */
    search_by_account?: boolean;
    /**
     * Members can search for others in the same email domain.
     */
    search_by_domain?: boolean;
    /**
     * Members can search for others under same master account, including all sub accounts.
     */
    search_by_ma_account?: boolean;
    /**
     * IM Group types:<br>`normal` - Only members can see automatically see the other members of this group. Other people can search for members within this group. <br>`shared` - Everyone under an account can see the group members automatically.<br>`restricted` - Nobody can see the group or search for members except the members in the group.
     */
    type?: 'normal' | 'shared' | 'restricted';
  };
};

export type ImGroupCreateResponse =
  | unknown
  | {
      /**
       * Group ID.
       */
      id?: string;
      /**
       * Group name.
       */
      name?: string;
      /**
       * Members can search for others under same account.
       */
      search_by_account?: boolean;
      /**
       * Members can search for others in the same email domain.
       */
      search_by_domain?: boolean;
      /**
       * Members can search for others under same master account, including all sub accounts.
       */
      search_by_ma_account?: boolean;
      /**
       * Group member count.
       */
      total_members?: number;
    };

export type ImGroupCreateError = unknown;

export type ImGroupDeleteData = {
  path: {
    /**
     * The group ID.<br>
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
     */
    groupId: string;
  };
};

export type ImGroupDeleteResponse = any;

export type ImGroupDeleteError = unknown;

export type ImGroupData = {
  path: {
    /**
     * The group ID.<br>
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
     */
    groupId: string;
  };
};

export type ImGroupResponse = {
  /**
   * Group ID.
   */
  id?: string;
} & ({
  /**
   * Group name.
   */
  name?: string;
  /**
   * Total number of members in this group.
   */
  total_members?: number;
} & {
  /**
   * Members can search for others under same account.
   */
  search_by_account?: boolean;
  /**
   * Members can search for others in the same email domain.
   */
  search_by_domain?: boolean;
  /**
   * Members can search for others under same master account - including all sub accounts.
   */
  search_by_ma_account?: boolean;
  /**
   * IM Group types:<br>`normal` - Only members can see the other members in the group. Other people can search for members in the group.<br>`shared` - Everyone in the account can see the group and members. <br>`restricted` - No one except group members can see the group or search for other group members.
   */
  type?: 'normal' | 'shared' | 'restricted';
});

export type ImGroupError = unknown;

export type ImGroupUpdateData = {
  body: {
    /**
     * Group name: must be unique to one account.
     */
    name?: string;
    /**
     * Members can search for others under same account.
     */
    search_by_account?: boolean;
    /**
     * Members can search for others in the same email domain.
     */
    search_by_domain?: boolean;
    /**
     * Members can search for others under same master account, including all sub accounts.
     */
    search_by_ma_account?: boolean;
    /**
     * IM Group types:<br>`normal` - Only group members can automatically see others in their group. Other people can search for members in the group.<br>`shared` - Everyone under the account can see the group and members automatically.<br>`restricted` - Nobody can see the group or search for members except for the members in the group.
     */
    type?: 'normal' | 'shared' | 'restricted';
  };
  path: {
    /**
     * The group ID.<br>
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
     */
    groupId: string;
  };
};

export type ImGroupUpdateResponse = any;

export type ImGroupUpdateError = unknown;

export type ImGroupMembersData = {
  path: {
    /**
     * The group ID.<br>
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
     */
    groupId: string;
  };
  query?: {
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     *
     * **Deprecated** - This field has been deprecated and we will stop supporting it completely in a future release. Please use "next_page_token" for pagination instead of this field.
     *
     * The page number of the current page in the returned records.
     */
    page_number?: number;
    /**
     * The number of records returned within a single API call.
     */
    page_size?: number;
  };
};

export type ImGroupMembersResponse = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of Group member objects.
   */
  members?: Array<{
    /**
     * User email.
     */
    email?: string;
    /**
     * User first name.
     */
    first_name?: string;
    /**
     * User ID.
     */
    id?: string;
    /**
     * User last name.
     */
    last_name?: string;
    /**
     * User type.<br>
     * `1` - Basic<br> `2` - Licensed<br>
     * `3` - On-prem
     */
    type?: number;
  }>;
};

export type ImGroupMembersError = unknown;

export type ImGroupMembersCreateData = {
  body: {
    /**
     * List of IM group members.
     */
    members?: Array<{
      /**
       * User email. If the user ID is given then ignore the user email.
       */
      email?: string;
      /**
       * User ID.
       */
      id?: string;
    }>;
  };
  path: {
    /**
     * The group ID.<br>
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
     */
    groupId: string;
  };
};

export type ImGroupMembersCreateResponse =
  | unknown
  | {
      added_at?: string;
      ids?: string;
    };

export type ImGroupMembersCreateError = unknown;

export type ImGroupMembersDeleteData = {
  path: {
    /**
     * The group ID.<br>
     * Can be retrieved by calling [GET /groups](https://marketplace.zoom.us/docs/api-reference/zoom-api/groups/groups).
     */
    groupId: string;
    /**
     * The member ID.
     */
    memberId: string;
  };
};

export type ImGroupMembersDeleteResponse = unknown | any;

export type ImGroupMembersDeleteError = unknown;

export type SendimmessagesData = {
  body?: {
    /**
     * IM message content.
     */
    message?: string;
  };
  query?: {
    /**
     * The email address (registered with Zoom) or the userId of the chat user.
     */
    chat_user?: string;
  };
};

export type SendimmessagesResponse = {
  /**
   * IM message UUID.
   */
  id?: string;
};

export type SendimmessagesError = unknown;

export type ListimmessagesData = {
  path: {
    /**
     * The user ID or email address.
     */
    userId: string;
  };
  query?: {
    /**
     * IM Channel's ID.
     */
    channel?: string;
    /**
     * Chat user's ID or email address.
     */
    chat_user?: string;
    /**
     * IM message's query date time, format as yyyy-MM-dd.
     */
    date?: string;
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     * The number of records returned within a single API call.
     */
    page_size?: number;
  };
};

export type ListimmessagesResponse = {
  /**
   * Query date time, format as yyyy-mm-dd.
   */
  date?: string;
  /**
   * Array of im messages.
   */
  messages?: Array<{
    /**
     * IM message send time.
     */
    date_time?: string;
    /**
     * IM message UUID.
     */
    id?: string;
    /**
     * IM message content.
     */
    message?: string;
    /**
     * IM message sender.
     */
    sender?: string;
    /**
     * IM message send timestamp.
     */
    timstamp?: number;
  }>;
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of records returned within a single API call.
   */
  page_size?: number;
};

export type ListimmessagesError = unknown;

export type InMeetingRecordingControlData = {
  body?: {
    /**
     * The method that you would like to control. The value of this field can be one of the following:
     * * `recording.start`: Provide this value if you would like to start the recording.<br><br>
     * * `recording.stop`: Provide this value if you would like to stop the recording.<br><br>
     * * `recording.pause`: Provide this value if you would like to pause the recording.<br><br>
     * * `recording.resume`: Provide this value if you would like to resume the recording that was previously paused.
     *
     *
     *
     *
     */
    method?: string;
  };
  path: {
    /**
     * Unique identifier of the live meeting.
     */
    meetingId: string;
  };
};

export type InMeetingRecordingControlResponse = unknown;

export type InMeetingRecordingControlError = unknown;

export type MeetingDeleteData = {
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
  };
  query?: {
    /**
     * `true`: Notify registrants about the meeting cancellation via email.
     *
     * `false`: Do not send any email notification to meeting registrants.
     *
     * The default value of this field is `false`.
     */
    cancel_meeting_reminder?: string;
    /**
     * The meeting occurrence ID.
     */
    occurrence_id?: string;
    /**
     * `true`: Notify host and alternative host about the meeting cancellation via email.
     * `false`: Do not send any email notification.
     */
    schedule_for_reminder?: boolean;
  };
};

export type MeetingDeleteResponse = any;

export type MeetingDeleteError = unknown;

export type MeetingData = {
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
  };
  query?: {
    /**
     * Meeting Occurrence ID. Provide this field to view meeting details of a particular occurrence of the [recurring meeting](https://support.zoom.us/hc/en-us/articles/214973206-Scheduling-Recurring-Meetings).
     */
    occurrence_id?: string;
    /**
     * Set the value of this field to `true` if you would like to view meeting details of all previous occurrences of a [recurring meeting](https://support.zoom.us/hc/en-us/articles/214973206-Scheduling-Recurring-Meetings).
     */
    show_previous_occurrences?: boolean;
  };
};

export type MeetingResponse = {
  /**
   * Unique identifier of the scheduler who scheduled this meeting on behalf of the host. This field is only returned if you used "schedule_for" option in the [Create a Meeting API request](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meetingcreate).
   */
  assistant_id?: string;
  /**
   * Email address of the meeting host.
   */
  host_email?: string;
  /**
   * ID of the user who is set as host of meeting.
   */
  host_id?: string;
  /**
   * [Meeting ID](https://support.zoom.us/hc/en-us/articles/201362373-What-is-a-Meeting-ID-): Unique identifier of the meeting in "**long**" format(represented as int64 data type in JSON), also known as the meeting number.
   */
  id?: number;
  /**
   * Unique meeting ID. Each meeting instance will generate its own Meeting UUID (i.e., after a meeting ends, a new UUID will be generated for the next instance of the meeting). You can retrieve a list of UUIDs from past meeting instances using [this API](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/pastmeetings) . Please double encode your UUID when using it for API calls if the UUID begins with a '/'or contains '//' in it.
   *
   */
  uuid?: string;
} & {
  /**
   * Meeting description
   */
  agenda?: string;
  /**
   * Time of creation.
   */
  created_at?: string;
  /**
   * Meeting duration.
   */
  duration?: number;
  /**
   * Encrypted passcode for third party endpoints (H323/SIP).
   */
  encrypted_password?: string;
  /**
   * H.323/SIP room system passcode.
   */
  h323_password?: string;
  /**
   * URL for participants to join the meeting. This URL should only be shared with users that you would like to invite for the meeting.
   */
  join_url?: string;
  /**
   * Array of occurrence objects.
   */
  occurrences?: Array<{
    /**
     * Duration.
     */
    duration?: number;
    /**
     * Occurrence ID: Unique Identifier that identifies an occurrence of a recurring webinar. [Recurring webinars](https://support.zoom.us/hc/en-us/articles/216354763-How-to-Schedule-A-Recurring-Webinar) can have a maximum of 50 occurrences.
     */
    occurrence_id?: string;
    /**
     * Start time.
     */
    start_time?: string;
    /**
     * Occurrence status.
     */
    status?: string;
  }>;
  /**
   * Meeting passcode.
   */
  password?: string;
  /**
   * Personal Meeting Id. Only used for scheduled meetings and recurring meetings with no fixed time.
   */
  pmi?: number;
  /**
   * Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time.
   */
  recurrence?: {
    /**
     * Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
     */
    end_date_time?: string;
    /**
     * Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)
     */
    end_times?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.
     *
     * For instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
     */
    monthly_day?: number;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
     */
    monthly_week?: -1 | 1 | 2 | 3 | 4;
    /**
     * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
     *
     * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /**
     * Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
     *
     * For a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.
     *
     *
     */
    repeat_interval?: number;
    /**
     * Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
     */
    type: 1 | 2 | 3;
    /**
     * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
     *
     * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
     */
    weekly_days?: '1' | '2' | '3' | '4' | '5' | '6' | '7';
  };
  /**
   * Meeting settings.
   */
  settings?: {
    /**
     * Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    allow_multiple_devices?: boolean;
    /**
     * Alternative host's emails or IDs: multiple values are separated by a semicolon.
     */
    alternative_hosts?: string;
    /**
     * Flag to determine whether to send email notifications to alternative hosts, default value is true.
     */
    alternative_hosts_email_notification?: boolean;
    /**
     * Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>
     *
     * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Approve or block users from specific regions/countries from joining this meeting.
     *
     */
    approved_or_denied_countries_or_regions?: {
      /**
       * List of countries/regions from where participants can join this meeting.
       */
      approved_list?: Array<string>;
      /**
       * List of countries/regions from where participants can not join this meeting.
       */
      denied_list?: Array<string>;
      /**
       * `true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>
       *
       * `false`: Setting disabled.
       */
      enable?: boolean;
      /**
       * Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>
       * `approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>
       * `deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`
       */
      method?: 'approve' | 'deny';
    };
    /**
     * Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.
     */
    audio?: 'both' | 'telephony' | 'voip';
    /**
     * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
     */
    authentication_domains?: string;
    /**
     * The participants added here will receive unique meeting invite links and bypass authentication.
     */
    authentication_exception?: Array<{
      /**
       * Email address of the participant.
       */
      email?: string;
      /**
       * Name of the participant.
       */
      name?: string;
    }>;
    /**
     * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
     */
    authentication_name?: string;
    /**
     * Meeting authentication option id.
     */
    authentication_option?: string;
    /**
     * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
     */
    auto_recording?: 'local' | 'cloud' | 'none';
    /**
     * Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).
     */
    breakout_room?: {
      /**
       * Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.
       */
      enable?: boolean;
      /**
       * Create room(s).
       */
      rooms?: Array<{
        /**
         * Name of the breakout room.
         */
        name?: string;
        /**
         * Email addresses of the participants who are to be assigned to the breakout room.
         */
        participants?: Array<string>;
      }>;
    };
    /**
     * Close registration after event date
     */
    close_registration?: boolean;
    /**
     * Host meeting in China.
     */
    cn_meeting?: boolean;
    /**
     * Contact email for registration
     */
    contact_email?: string;
    /**
     * Contact name for registration
     */
    contact_name?: string;
    /**
     * Custom keys and values assigned to the meeting.
     */
    custom_keys?: Array<{
      /**
       * Custom key associated with the user.
       */
      key?: string;
      /**
       * Value of the custom key associated with the user.
       */
      value?: string;
    }>;
    /**
     * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
     * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
     *
     * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
     */
    encryption_type?: 'enhanced_encryption' | 'e2ee';
    /**
     * Only signed in users can join this meeting.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login?: boolean;
    /**
     * Only signed in users with specified domains can join meetings.
     *
     * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
     */
    enforce_login_domains?: string;
    /**
     * List of global dial-in countries
     */
    global_dial_in_countries?: Array<string>;
    /**
     * Global Dial-in Countries/Regions
     */
    global_dial_in_numbers?: Array<{
      /**
       * City of the number, if any. For example, Chicago.
       */
      city?: string;
      /**
       * Country code. For example, BR.
       */
      country?: string;
      /**
       * Full name of country. For example, Brazil.
       */
      country_name?: string;
      /**
       * Phone number. For example, +1 2332357613.
       */
      number?: string;
      /**
       * Type of number.
       */
      type?: 'toll' | 'tollfree';
    }>;
    /**
     * Start video when the host joins the meeting.
     */
    host_video?: boolean;
    /**
     * Host meeting in India.
     */
    in_meeting?: boolean;
    /**
     * If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:
     *
     * *  `0`: Allow participant to join anytime.
     * *  `5`: Allow participant to join 5 minutes before meeting start time.
     * * `10`: Allow participant to join 10 minutes before meeting start time.
     */
    jbh_time?: 0 | 5 | 10;
    /**
     * Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.
     */
    join_before_host?: boolean;
    language_interpretation?: {
      enable?: boolean;
      /**
       * Information associated with the interpreter.
       */
      interpreters?: Array<{
        /**
         * Email address of the interpreter.
         */
        email?: string;
        /**
         * Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma.
         *
         * For example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".
         */
        languages?: string;
      }>;
    };
    /**
     * `true`- Only authenticated users can join meetings.
     */
    meeting_authentication?: boolean;
    /**
     * Mute participants upon entry.
     */
    mute_upon_entry?: boolean;
    /**
     * Start video when participants join the meeting.
     */
    participant_video?: boolean;
    /**
     * Send confirmation email to registrants upon successful registration.
     */
    registrants_confirmation_email?: boolean;
    /**
     * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
     */
    registrants_email_notification?: boolean;
    /**
     * Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.
     */
    registration_type?: 1 | 2 | 3;
    /**
     * Show social share buttons on the meeting registration page.
     * This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
     */
    show_share_button?: boolean;
    /**
     * Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.
     */
    use_pmi?: boolean;
    /**
     * Enable waiting room
     */
    waiting_room?: boolean;
    /**
     * Add watermark when viewing a shared screen.
     */
    watermark?: boolean;
  };
  /**
   * Meeting start time in GMT/UTC. Start time will not be returned if the meeting is an **instant** meeting.
   *
   */
  start_time?: string;
  /**
   * <br><aside>The <code>start_url</code> of a Meeting is a URL using which a host or an alternative host can start the Meeting.
   *
   * The expiration time for the <code>start_url</code> field listed in the response of [Create a Meeting API](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meetingcreate) is two hours for all regular users.
   *
   * For users created using the <code>custCreate</code> option via the [Create Users](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usercreate) API, the expiration time of the <code>start_url</code> field is 90 days.
   *
   * For security reasons, to retrieve the updated value for the <code>start_url</code> field programmatically (after the expiry time), you must call the [Retrieve a Meeting API](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meeting) and refer to the value of the <code>start_url</code> field in the response.</aside><br>This URL should only be used by the host of the meeting and **should not be shared with anyone other than the host** of the meeting as anyone with this URL will be able to login to the Zoom Client as the host of the meeting.
   */
  start_url?: string;
  /**
   * Meeting status
   */
  status?: 'waiting' | 'started';
  /**
   * Timezone to format the meeting start time on the .
   */
  timezone?: string;
  /**
   * Meeting topic.
   */
  topic?: string;
  /**
   * Tracking fields
   */
  tracking_fields?: Array<{
    /**
     * Label of the tracking field.
     */
    field?: string;
    /**
     * Value for the field.
     */
    value?: string;
    /**
     * Indicates whether the [tracking field](https://support.zoom.us/hc/en-us/articles/115000293426-Scheduling-Tracking-Fields) is visible in the meeting scheduling options in the Zoom Web Portal or not.
     *
     * `true`: Tracking field is visible. <br>
     *
     * `false`: Tracking field is not visible to the users when they look at the meeting details in the Zoom Web Portal but the field was used while scheduling this meeting via API. An invisible tracking field can be used by users while scheduling meetings via API only.
     */
    visible?: boolean;
  }>;
  /**
   * Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`4` - PMI Meeting<br>
   * `8` - Recurring meeting with a fixed time.
   */
  type?: 1 | 2 | 3 | 8;
};

export type MeetingError = unknown;

export type MeetingUpdateData = {
  /**
   * Meeting
   */
  body: {
    /**
     * Email or userId if you want to schedule meeting for another user.
     */
    schedule_for?: string;
  } & {
    /**
     * Meeting description.
     */
    agenda?: string;
    /**
     * Meeting duration (minutes). Used for scheduled meetings only.
     */
    duration?: number;
    /**
     * Meeting passcode. Passcode may only contain the following characters: [a-z A-Z 0-9 @ - _ *] and can have a maximum of 10 characters.
     *
     * **Note:** If the account owner or the admin has configured [minimum passcode requirement settings](https://support.zoom.us/hc/en-us/articles/360033559832-Meeting-and-webinar-passwords#h_a427384b-e383-4f80-864d-794bf0a37604), the passcode value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the  [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API.
     */
    password?: string;
    /**
     * Recurrence object. Use this object only for a meeting with type `8` i.e., a recurring meeting with fixed time.
     */
    recurrence?: {
      /**
       * Select the final date on which the meeting will recur before it is canceled. Should be in UTC time, such as 2017-11-25T12:00:00Z. (Cannot be used with "end_times".)
       */
      end_date_time?: string;
      /**
       * Select how many times the meeting should recur before it is canceled. (Cannot be used with "end_date_time".)
       */
      end_times?: number;
      /**
       * Use this field **only if you're scheduling a recurring meeting of type** `3` to state which day in a month, the meeting should recur. The value range is from 1 to 31.
       *
       * For instance, if you would like the meeting to recur on 23rd of each month, provide `23` as the value of this field and `1` as the value of the `repeat_interval` field. Instead, if you would like the meeting to recur every three months, on 23rd of the month, change the value of the `repeat_interval` field to `3`.
       */
      monthly_day?: number;
      /**
       * Use this field **only if you're scheduling a recurring meeting of type** `3` to state the week of the month when the meeting should recur. If you use this field, **you must also use the `monthly_week_day` field to state the day of the week when the meeting should recur.** <br>`-1` - Last week of the month.<br>`1` - First week of the month.<br>`2` - Second week of the month.<br>`3` - Third week of the month.<br>`4` - Fourth week of the month.
       */
      monthly_week?: -1 | 1 | 2 | 3 | 4;
      /**
       * Use this field **only if you're scheduling a recurring meeting of type** `3` to state a specific day in a week when the monthly meeting should recur. To use this field, you must also use the `monthly_week` field.
       *
       * <br>`1` - Sunday.<br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` - Thursday.<br>`6` - Friday.<br>`7` - Saturday.
       */
      monthly_week_day?: 1 | 2 | 3 | 4 | 5 | 6 | 7;
      /**
       * Define the interval at which the meeting should recur. For instance, if you would like to schedule a meeting that recurs every two months, you must set the value of this field as `2` and the value of the `type` parameter as `3`.
       *
       * For a daily meeting, the maximum interval you can set is `90` days. For a weekly meeting the maximum interval that you can set is  of `12` weeks. For a monthly meeting, there is a maximum of `3` months.
       *
       *
       */
      repeat_interval?: number;
      /**
       * Recurrence meeting types:<br>`1` - Daily.<br>`2` - Weekly.<br>`3` - Monthly.
       */
      type: 1 | 2 | 3;
      /**
       * This field is required **if you're scheduling a recurring meeting of type** `2` to state which day(s) of the week the meeting should repeat. <br> <br> The value for this field could be a number between `1` to `7` in string format. For instance, if the meeting should recur on Sunday, provide `"1"` as the value of this field.<br><br> **Note:** If you would like the meeting to occur on multiple days of a week, you should provide comma separated values for this field. For instance, if the meeting should recur on Sundays and Tuesdays provide `"1,3"` as the value of this field.
       *
       * <br>`1`  - Sunday. <br>`2` - Monday.<br>`3` - Tuesday.<br>`4` -  Wednesday.<br>`5` -  Thursday.<br>`6` - Friday.<br>`7` - Saturday.
       */
      weekly_days?: '1' | '2' | '3' | '4' | '5' | '6' | '7';
    };
    settings?: {
      /**
       * Allow attendees to join the meeting from multiple devices. This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
       */
      allow_multiple_devices?: boolean;
      /**
       * Alternative host's emails or IDs: multiple values are separated by a semicolon.
       */
      alternative_hosts?: string;
      /**
       * Flag to determine whether to send email notifications to alternative hosts, default value is true.
       */
      alternative_hosts_email_notification?: boolean;
      /**
       * Enable registration and set approval for the registration. Note that this feature requires the host to be of **Licensed** user type. **Registration cannot be enabled for a basic user.** <br><br>
       *
       * `0` - Automatically approve.<br>`1` - Manually approve.<br>`2` - No registration required.
       */
      approval_type?: 0 | 1 | 2;
      /**
       * Approve or block users from specific regions/countries from joining this meeting.
       *
       */
      approved_or_denied_countries_or_regions?: {
        /**
         * List of countries/regions from where participants can join this meeting.
         */
        approved_list?: Array<string>;
        /**
         * List of countries/regions from where participants can not join this meeting.
         */
        denied_list?: Array<string>;
        /**
         * `true`: Setting enabled to either allow users or block users from specific regions to join your meetings. <br>
         *
         * `false`: Setting disabled.
         */
        enable?: boolean;
        /**
         * Specify whether to allow users from specific regions to join this meeting; or block users from specific regions from joining this meeting. <br><br>
         * `approve`: Allow users from specific regions/countries to join this meeting. If this setting is selected, the approved regions/countries must be included in the `approved_list`.<br><br>
         * `deny`: Block users from specific regions/countries from joining this meeting. If this setting is selected, the approved regions/countries must be included in the `denied_list`
         */
        method?: 'approve' | 'deny';
      };
      /**
       * Determine how participants can join the audio portion of the meeting.<br>`both` - Both Telephony and VoIP.<br>`telephony` - Telephony only.<br>`voip` - VoIP only.
       */
      audio?: 'both' | 'telephony' | 'voip';
      /**
       * If user has configured ["Sign Into Zoom with Specified Domains"](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f) option, this will list the domains that are authenticated.
       */
      authentication_domains?: string;
      /**
       * The participants added here will receive unique meeting invite links and bypass authentication.
       */
      authentication_exception?: Array<{
        /**
         * Email address of the participant.
         */
        email?: string;
        /**
         * Name of the participant.
         */
        name?: string;
      }>;
      /**
       * Authentication name set in the [authentication profile](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars#h_5c0df2e1-cfd2-469f-bb4a-c77d7c0cca6f).
       */
      authentication_name?: string;
      /**
       * Meeting authentication option id.
       */
      authentication_option?: string;
      /**
       * Automatic recording:<br>`local` - Record on local.<br>`cloud` -  Record on cloud.<br>`none` - Disabled.
       */
      auto_recording?: 'local' | 'cloud' | 'none';
      /**
       * Setting to [pre-assign breakout rooms](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4).
       */
      breakout_room?: {
        /**
         * Set the value of this field to `true` if you would like to enable the [breakout room pre-assign](https://support.zoom.us/hc/en-us/articles/360032752671-Pre-assigning-participants-to-breakout-rooms#h_36f71353-4190-48a2-b999-ca129861c1f4) option.
         */
        enable?: boolean;
        /**
         * Create room(s).
         */
        rooms?: Array<{
          /**
           * Name of the breakout room.
           */
          name?: string;
          /**
           * Email addresses of the participants who are to be assigned to the breakout room.
           */
          participants?: Array<string>;
        }>;
      };
      /**
       * Close registration after event date
       */
      close_registration?: boolean;
      /**
       * Host meeting in China.
       */
      cn_meeting?: boolean;
      /**
       * Contact email for registration
       */
      contact_email?: string;
      /**
       * Contact name for registration
       */
      contact_name?: string;
      /**
       * Custom keys and values assigned to the meeting.
       */
      custom_keys?: Array<{
        /**
         * Custom key associated with the user.
         */
        key?: string;
        /**
         * Value of the custom key associated with the user.
         */
        value?: string;
      }>;
      /**
       * Choose between enhanced encryption and [end-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871) when starting or a meeting. When using end-to-end encryption, several features (e.g. cloud recording, phone/SIP/H.323 dial-in) will be **automatically disabled**. <br><br>The value of this field can be one of the following:<br>
       * `enhanced_encryption`: Enhanced encryption. Encryption is stored in the cloud if you enable this option. <br>
       *
       * `e2ee`: [End-to-end encryption](https://support.zoom.us/hc/en-us/articles/360048660871). The encryption key is stored in your local device and can not be obtained by anyone else. Enabling this setting also **disables** the following features: join before host, cloud recording, streaming, live transcription, breakout rooms, polling, 1:1 private chat, and meeting reactions.
       */
      encryption_type?: 'enhanced_encryption' | 'e2ee';
      /**
       * Only signed in users can join this meeting.
       *
       * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
       */
      enforce_login?: boolean;
      /**
       * Only signed in users with specified domains can join meetings.
       *
       * **This field is deprecated and will not be supported in the future.**  <br><br>As an alternative, use the "meeting_authentication", "authentication_option" and "authentication_domains" fields to understand the [authentication configurations](https://support.zoom.us/hc/en-us/articles/360037117472-Authentication-Profiles-for-Meetings-and-Webinars) set for the meeting.
       */
      enforce_login_domains?: string;
      /**
       * List of global dial-in countries
       */
      global_dial_in_countries?: Array<string>;
      /**
       * Global Dial-in Countries/Regions
       */
      global_dial_in_numbers?: Array<{
        /**
         * City of the number, if any. For example, Chicago.
         */
        city?: string;
        /**
         * Country code. For example, BR.
         */
        country?: string;
        /**
         * Full name of country. For example, Brazil.
         */
        country_name?: string;
        /**
         * Phone number. For example, +1 2332357613.
         */
        number?: string;
        /**
         * Type of number.
         */
        type?: 'toll' | 'tollfree';
      }>;
      /**
       * Start video when the host joins the meeting.
       */
      host_video?: boolean;
      /**
       * Host meeting in India.
       */
      in_meeting?: boolean;
      /**
       * If the value of "join_before_host" field is set to true, this field can be used to indicate time limits within which a participant may join a meeting before a host. The value of this field can be one of the following:
       *
       * *  `0`: Allow participant to join anytime.
       * *  `5`: Allow participant to join 5 minutes before meeting start time.
       * * `10`: Allow participant to join 10 minutes before meeting start time.
       */
      jbh_time?: 0 | 5 | 10;
      /**
       * Allow participants to join the meeting before the host starts the meeting. Only used for scheduled or recurring meetings.
       */
      join_before_host?: boolean;
      language_interpretation?: {
        enable?: boolean;
        /**
         * Information associated with the interpreter.
         */
        interpreters?: Array<{
          /**
           * Email address of the interpreter.
           */
          email?: string;
          /**
           * Languages for interpretation. The string must contain two [country Ids](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) separated by a comma.
           *
           * For example, if the language is to be interpreted from English to Chinese, the value of this field should be "US,CN".
           */
          languages?: string;
        }>;
      };
      /**
       * `true`- Only authenticated users can join meetings.
       */
      meeting_authentication?: boolean;
      /**
       * Mute participants upon entry.
       */
      mute_upon_entry?: boolean;
      /**
       * Start video when participants join the meeting.
       */
      participant_video?: boolean;
      /**
       * Send confirmation email to registrants upon successful registration.
       */
      registrants_confirmation_email?: boolean;
      /**
       * Send email notifications to registrants about approval, cancellation, denial of the registration. The value of this field must be set to true in order to use the `registrants_confirmation_email` field.
       */
      registrants_email_notification?: boolean;
      /**
       * Registration type. Used for recurring meeting with fixed time only. <br>`1` Attendees register once and can attend any of the occurrences.<br>`2` Attendees need to register for each occurrence to attend.<br>`3` Attendees register once and can choose one or more occurrences to attend.
       */
      registration_type?: 1 | 2 | 3;
      /**
       * Show social share buttons on the meeting registration page.
       * This setting only works for meetings that require [registration](https://support.zoom.us/hc/en-us/articles/211579443-Setting-up-registration-for-a-meeting).
       */
      show_share_button?: boolean;
      /**
       * Use a personal meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time.
       */
      use_pmi?: boolean;
      /**
       * Enable waiting room
       */
      waiting_room?: boolean;
      /**
       * Add watermark when viewing a shared screen.
       */
      watermark?: boolean;
    } & {
      /**
       * Send confirmation Email to Registrants
       */
      registrants_confirmation_email?: boolean;
    };
    /**
     * Meeting start time. When using a format like "yyyy-MM-dd'T'HH:mm:ss'Z'", always use GMT time. When using a format like "yyyy-MM-dd'T'HH:mm:ss", you should use local time and  specify the time zone. Only used for scheduled meetings and recurring meetings with a fixed time.
     */
    start_time?: string;
    /**
     * Unique identifier of the meeting template.
     *
     * Use this field if you would like to [schedule the meeting from a meeting template](https://support.zoom.us/hc/en-us/articles/360036559151-Meeting-templates#h_86f06cff-0852-4998-81c5-c83663c176fb). You can retrieve the value of this field by calling the [List meeting templates]() API.
     */
    template_id?: string;
    /**
     * Time zone to format start_time. For example, "America/Los_Angeles". For scheduled meetings only. Please reference our [time zone](#timezones) list for supported time zones and their formats.
     */
    timezone?: string;
    /**
     * Meeting topic.
     */
    topic?: string;
    /**
     * Tracking fields
     */
    tracking_fields?: Array<{
      /**
       * Tracking fields type
       */
      field?: string;
      /**
       * Tracking fields value
       */
      value?: string;
    }>;
    /**
     * Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with a fixed time.
     */
    type?: 1 | 2 | 3 | 8;
  };
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
  };
  query?: {
    /**
     * Meeting occurrence id. Support change of agenda, start_time, duration, settings: {host_video, participant_video, join_before_host, mute_upon_entry, waiting_room, watermark, auto_recording}
     */
    occurrence_id?: string;
  };
};

export type MeetingUpdateResponse = any;

export type MeetingUpdateError = unknown;

export type CreateBatchPollsData = {
  /**
   * Batch Meeting poll object
   */
  body?: {
    questions?: Array<{
      /**
       * Possible answers for the question.
       */
      answers?: Array<string>;
      /**
       * Name of the question.
       */
      name?: string;
      /**
       * Question type:<br>`single` - Single choice<br>`mutliple` - Multiple choice
       */
      type?: 'single' | 'multiple';
    }>;
    /**
     * Meeting Poll Title.
     */
    title?: string;
  };
  path: {
    meetingId: string;
  };
};

export type CreateBatchPollsResponse = {
  polls?: Array<{
    /**
     * Meeting Poll ID
     */
    id?: string;
    questions?: Array<{
      /**
       * Answers to questons
       */
      answers?: Array<string>;
      /**
       * Name of question.
       */
      name?: string;
      /**
       * Poll question and answer type.
       */
      type?: 'single' | 'multiple';
    }>;
    /**
     * Status of the Meeting Poll:<br>`notstart` - Poll not started<br>`started` - Poll started<br>`ended` - Poll ended<br>`sharing` - Sharing poll results
     */
    status?: 'notstart' | 'started' | 'ended' | 'sharing';
    /**
     * Title for the Poll
     */
    title?: string;
  }>;
};

export type CreateBatchPollsError = unknown;

export type MeetingInvitationData = {
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
  };
};

export type MeetingInvitationResponse = {
  /**
   * Meeting invitation.
   */
  invitation?: string;
};

export type MeetingInvitationError = unknown;

export type GetLiveStreamDetailsData = {
  path: {
    /**
     * Unique identifier of the meeting.
     */
    meetingId: string;
  };
};

export type GetLiveStreamDetailsResponse = {
  /**
   * Live streaming page URL. This is the URL using which anyone can view the live stream of the meeting.
   */
  page_url?: string;
  /**
   * Stream Key.
   */
  stream_key?: string;
  /**
   * Stream URL.
   */
  stream_url?: string;
};

export type GetLiveStreamDetailsError = unknown;

export type MeetingLiveStreamUpdateData = {
  /**
   * Meeting
   */
  body: {
    /**
     * The livestream page URL.
     */
    page_url?: string;
    /**
     * Stream name and key.
     */
    stream_key: string;
    /**
     * Streaming URL.
     */
    stream_url: string;
  };
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
  };
};

export type MeetingLiveStreamUpdateResponse = any;

export type MeetingLiveStreamUpdateError = unknown;

export type MeetingLiveStreamStatusUpdateData = {
  /**
   * Meeting
   */
  body: {
    /**
     * Update the status of a livestream.
     *
     * The value can be one of the following:<br>
     * `start`: Start a live stream. <br>
     * `stop`: Stop an ongoing live stream.
     */
    action?: 'start' | 'stop';
    /**
     * Update the settings of a live streaming session. The settings can only be updated for a live stream that has been stopped. You can not update the settings of an ongoing live stream.
     */
    settings?: {
      /**
       * Display the name of the active speaker during a live stream.
       */
      active_speaker_name?: boolean;
      /**
       * Display name of the live stream.
       */
      display_name?: string;
    };
  };
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
  };
};

export type MeetingLiveStreamStatusUpdateResponse = any;

export type MeetingLiveStreamStatusUpdateError = unknown;

export type MeetingPollsData = {
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
  };
};

export type MeetingPollsResponse = {
  /**
   * Array of Polls
   */
  polls?: Array<
    {
      /**
       * ID of Poll
       */
      id?: string;
      /**
       * Status of Poll:<br>`notstart` - Poll not started<br>`started` - Poll started<br>`ended` - Poll ended<br>`sharing` - Sharing poll results
       */
      status?: 'notstart' | 'started' | 'ended' | 'sharing';
    } & {
      /**
       * Array of Polls
       */
      questions?: Array<{
        /**
         * Answers to the questions
         */
        answers?: Array<string>;
        /**
         * Question to be asked to the attendees.
         */
        name?: string;
        /**
         * Poll Question & Answer type:<br>`single` - Single choice<br>`mutliple` - Multiple choice
         */
        type?: 'single' | 'multiple';
      }>;
      /**
       * Title for the poll.
       */
      title?: string;
    }
  >;
  /**
   * The number of all records available across pages
   */
  total_records?: number;
};

export type MeetingPollsError = unknown;

export type MeetingPollCreateData = {
  /**
   * Meeting poll object
   */
  body: {
    /**
     * Array of Polls
     */
    questions?: Array<{
      /**
       * Answers to the questions
       */
      answers?: Array<string>;
      /**
       * Question to be asked to the attendees.
       */
      name?: string;
      /**
       * Poll Question & Answer type:<br>`single` - Single choice<br>`mutliple` - Multiple choice
       */
      type?: 'single' | 'multiple';
    }>;
    /**
     * Title for the poll.
     */
    title?: string;
  };
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
  };
};

export type MeetingPollCreateResponse = {
  /**
   * Meeting Poll ID
   */
  id?: string;
  /**
   * Status of the Meeting Poll:<br>`notstart` - Poll not started<br>`started` - Poll started<br>`ended` - Poll ended<br>`sharing` - Sharing poll results
   */
  status?: 'notstart' | 'started' | 'ended' | 'sharing';
} & {
  /**
   * Array of Polls
   */
  questions?: Array<{
    /**
     * Answers to the questions
     */
    answers?: Array<string>;
    /**
     * Question to be asked to the attendees.
     */
    name?: string;
    /**
     * Poll Question & Answer type:<br>`single` - Single choice<br>`mutliple` - Multiple choice
     */
    type?: 'single' | 'multiple';
  }>;
  /**
   * Title for the poll.
   */
  title?: string;
};

export type MeetingPollCreateError = unknown;

export type MeetingPollDeleteData = {
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
    /**
     * The poll ID
     */
    pollId: string;
  };
};

export type MeetingPollDeleteResponse = any;

export type MeetingPollDeleteError = unknown;

export type MeetingPollGetData = {
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
    /**
     * The poll ID
     */
    pollId: string;
  };
};

export type MeetingPollGetResponse = {
  /**
   * Meeting Poll ID
   */
  id?: string;
  /**
   * Status of the Meeting Poll:<br>`notstart` - Poll not started<br>`started` - Poll started<br>`ended` - Poll ended<br>`sharing` - Sharing poll results
   */
  status?: 'notstart' | 'started' | 'ended' | 'sharing';
} & {
  /**
   * Array of Polls
   */
  questions?: Array<{
    /**
     * Answers to the questions
     */
    answers?: Array<string>;
    /**
     * Question to be asked to the attendees.
     */
    name?: string;
    /**
     * Poll Question & Answer type:<br>`single` - Single choice<br>`mutliple` - Multiple choice
     */
    type?: 'single' | 'multiple';
  }>;
  /**
   * Title for the poll.
   */
  title?: string;
};

export type MeetingPollGetError = unknown;

export type MeetingPollUpdateData = {
  /**
   * Meeting Poll
   */
  body: {
    /**
     * Array of Polls
     */
    questions?: Array<{
      /**
       * Answers to the questions
       */
      answers?: Array<string>;
      /**
       * Question to be asked to the attendees.
       */
      name?: string;
      /**
       * Poll Question & Answer type:<br>`single` - Single choice<br>`mutliple` - Multiple choice
       */
      type?: 'single' | 'multiple';
    }>;
    /**
     * Title for the poll.
     */
    title?: string;
  };
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
    /**
     * The poll ID
     */
    pollId: string;
  };
};

export type MeetingPollUpdateResponse = any;

export type MeetingPollUpdateError = unknown;

export type RecordingDeleteData = {
  path: {
    /**
     * To get Cloud Recordings of a meeting, provide the meeting ID or meeting UUID. If the meeting ID is provided instead of UUID,the response will be for the latest meeting instance.
     *
     * To get Cloud Recordings of a webinar, provide the webinar ID or the webinar UUID. If the webinar ID is provided instead of UUID,the response will be for the latest webinar instance.
     *
     * If a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875=="), you must **double encode** the UUID before making an API request.
     */
    meetingId: string;
  };
  query?: {
    /**
     * The recording delete actions:<br>`trash` - Move recording to trash.<br>`delete` - Delete recording permanently.
     */
    action?: 'trash' | 'delete';
  };
};

export type RecordingDeleteResponse = unknown | any;

export type RecordingDeleteError = unknown;

export type RecordingGetData = {
  path: {
    /**
     * To get Cloud Recordings of a meeting, provide the meeting ID or meeting UUID. If the meeting ID is provided instead of UUID,the response will be for the latest meeting instance.
     *
     * To get Cloud Recordings of a webinar, provide the webinar ID or the webinar UUID. If the webinar ID is provided instead of UUID,the response will be for the latest webinar instance.
     *
     * If a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875=="), you must **double encode** the UUID before making an API request.
     */
    meetingId: string;
  };
  query?: {
    /**
     * Get the `download_access_token` field for downloading meeting recordings.
     */
    include_fields?: string;
    /**
     * Time to live (TTL) of the `download_access_token`. This is only valid if the `include_fields` query parameter contains `download_access_token`. The range is between 0-604800.
     */
    ttl?: number;
  };
};

export type RecordingGetResponse = ({
  /**
   * Unique Identifier of the user account.
   */
  account_id?: string;
  /**
   * Meeting duration.
   */
  duration?: number;
  /**
   * ID of the user set as host of meeting.
   */
  host_id?: string;
  /**
   * Meeting ID - also known as the meeting number.
   */
  id?: string;
  /**
   * Number of recording files returned in the response of this API call.
   */
  recording_count?: string;
  /**
   * The time at which the meeting started.
   */
  start_time?: string;
  /**
   * Meeting topic.
   */
  topic?: string;
  /**
   * Total size of the recording.
   */
  total_size?: string;
  /**
   * Type of the meeting that was recorded.
   *
   * Meeting Types:<br>`1` - Instant meeting.<br>`2` - Scheduled meeting.<br>`3` - Recurring meeting with no fixed time.<br>`8` - Recurring meeting with fixed time.
   */
  type?: string;
  /**
   * Unique Meeting Identifier. Each instance of the meeting will have its own UUID.
   */
  uuid?: string;
} & {
  /**
   * List of recording file.
   */
  recording_files?: Array<{
    /**
     * The time at which recording was deleted. Returned in the response only for trash query.
     */
    deleted_time?: string;
    /**
     * The URL using which the recording file can be downloaded. **To access a private or password protected cloud recording of a user in your account, you can use a [Zoom JWT App Type](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app). Use the generated JWT token as the value of the `access_token` query parameter and include this query parameter at the end of the URL as shown in the example.**
     * <br>
     * Example: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ JWT Token }}`
     *
     * **Similarly, if the user has installed your OAuth app that contains recording scope(s), you can also use the user's [OAuth access token](https://marketplace.zoom.us/docs/guides/auth/oauth) to download the Cloud Recording.**<br>
     *
     * Example: `https://api.zoom.us/recording/download/{{ Download Path }}?access_token={{ OAuth Access Token }}`
     *
     *
     */
    download_url?: string;
    /**
     * The recording file size.
     */
    file_size?: number;
    /**
     * The recording file type. The value of this field could be one of the following:<br>
     * `MP4`: Video file of the recording.<br>`M4A` Audio-only file of the recording.<br>`TIMELINE`: Timestamp file of the recording in JSON file format. To get a timeline file, the "Add a timestamp to the recording" setting must be enabled in the [recording settings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-recording#h_3f14c3a4-d16b-4a3c-bbe5-ef7d24500048). The time will display in the host's timezone, set on their Zoom profile.
     * <br> `TRANSCRIPT`: Transcription file of the recording in VTT format.<br> `CHAT`: A TXT file containing in-meeting chat messages that were sent during the meeting.<br>`CC`: File containing closed captions of the recording in VTT file format.<br>`CSV`: File containing polling data in csv format.
     *
     * <br>
     *
     * A recording file object with file type of either `CC` or `TIMELINE` **does not have** the following properties:<br>
     * `id`, `status`, `file_size`, `recording_type`, and `play_url`.
     */
    file_type?: string;
    /**
     * The recording file ID. Included in the response of general query.
     */
    id?: string;
    /**
     * The meeting ID.
     */
    meeting_id?: string;
    /**
     * The URL using which a recording file can be played.
     */
    play_url?: string;
    /**
     * The recording end time. Response in general query.
     */
    recording_end?: string;
    /**
     * The recording start time.
     */
    recording_start?: string;
    /**
     * The recording type. The value of this field can be one of the following:<br>`shared_screen_with_speaker_view(CC)`<br>`shared_screen_with_speaker_view`<br>`shared_screen_with_gallery_view`<br>`speaker_view`<br>`gallery_view`<br>`shared_screen`<br>`audio_only`<br>`audio_transcript`<br>`chat_file`<br>`active_speaker`<br>`poll`
     */
    recording_type?: string;
    /**
     * The recording status.
     */
    status?: 'completed';
  }>;
}) & {
  /**
   * JWT token for downloading the meeting recording.
   * This is only returned if the `include_fields` query parameter contains `download_access_token`.
   */
  download_access_token?: string;
};

export type RecordingGetError = unknown;

export type MeetingRecordingRegistrantsData = {
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
  };
  query?: {
    /**
     * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
     */
    next_page_token?: string;
    /**
     *
     * **Deprecated** - This field has been deprecated and we will stop supporting it completely in a future release. Please use "next_page_token" for pagination instead of this field.
     *
     * The page number of the current page in the returned records.
     */
    page_number?: number;
    /**
     * The number of records returned within a single API call.
     */
    page_size?: number;
    /**
     * The registrant status:<br>`pending` - Registrant's status is pending.<br>`approved` - Registrant's status is approved.<br>`denied` - Registrant's status is denied.
     */
    status?: 'pending' | 'approved' | 'denied';
  };
};

export type MeetingRecordingRegistrantsResponse = {
  /**
   * The next page token is used to paginate through large result sets. A next page token will be returned whenever the set of available results exceeds the current page size. The expiration period for this token is 15 minutes.
   */
  next_page_token?: string;
  /**
   * The number of pages returned for the request made.
   */
  page_count?: number;
  /**
   * **Deprecated**: This field has been deprecated. Please use the "next_page_token" field for pagination instead of this field.
   *
   * The page number of the current results.
   */
  page_number?: number;
  /**
   * The number of records returned with a single API call.
   */
  page_size?: number;
  /**
   * The total number of all the records available across pages.
   */
  total_records?: number;
} & {
  /**
   * List of Registrant objects
   */
  registrants?: Array<
    {
      id?: string;
    } & {
      /**
       * Registrant's address.
       */
      address?: string;
      /**
       * Registrant's city.
       */
      city?: string;
      /**
       * A field that allows registrants to provide any questions or comments that they might have.
       */
      comments?: string;
      /**
       * Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.
       */
      country?: string;
      /**
       * Custom questions.
       */
      custom_questions?: Array<{
        title?: string;
        value?: string;
      }>;
      /**
       * A valid email address of the registrant.
       */
      email: string;
      /**
       * Registrant's first name.
       */
      first_name: string;
      /**
       * Registrant's Industry.
       */
      industry?: string;
      /**
       * Registrant's job title.
       */
      job_title?: string;
      /**
       * Registrant's last name.
       */
      last_name?: string;
      /**
       * Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`
       */
      no_of_employees?: string;
      /**
       * Registrant's Organization.
       */
      org?: string;
      /**
       * Registrant's Phone number.
       */
      phone?: string;
      /**
       * This field can be included to gauge interest of webinar attendees towards buying your product or service.
       *
       * Purchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`
       */
      purchasing_time_frame?: string;
      /**
       * Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved`
       */
      role_in_purchase_process?: string;
      /**
       * Registrant's State/Province.
       */
      state?: string;
      /**
       * Registrant's Zip/Postal Code.
       */
      zip?: string;
    }
  >;
};

export type MeetingRecordingRegistrantsError = unknown;

export type MeetingRecordingRegistrantCreateData = {
  body: {
    /**
     * Registrant's address.
     */
    address?: string;
    /**
     * Registrant's city.
     */
    city?: string;
    /**
     * A field that allows registrants to provide any questions or comments that they might have.
     */
    comments?: string;
    /**
     * Registrant's country. The value of this field must be in two-letter abbreviated form and must match the ID field provided in the [Countries](https://marketplace.zoom.us/docs/api-reference/other-references/abbreviation-lists#countries) table.
     */
    country?: string;
    /**
     * Custom questions.
     */
    custom_questions?: Array<{
      title?: string;
      value?: string;
    }>;
    /**
     * A valid email address of the registrant.
     */
    email: string;
    /**
     * Registrant's first name.
     */
    first_name: string;
    /**
     * Registrant's Industry.
     */
    industry?: string;
    /**
     * Registrant's job title.
     */
    job_title?: string;
    /**
     * Registrant's last name.
     */
    last_name?: string;
    /**
     * Number of Employees:<br>`1-20`<br>`21-50`<br>`51-100`<br>`101-500`<br>`500-1,000`<br>`1,001-5,000`<br>`5,001-10,000`<br>`More than 10,000`
     */
    no_of_employees?: string;
    /**
     * Registrant's Organization.
     */
    org?: string;
    /**
     * Registrant's Phone number.
     */
    phone?: string;
    /**
     * This field can be included to gauge interest of webinar attendees towards buying your product or service.
     *
     * Purchasing Time Frame:<br>`Within a month`<br>`1-3 months`<br>`4-6 months`<br>`More than 6 months`<br>`No timeframe`
     */
    purchasing_time_frame?: string;
    /**
     * Role in Purchase Process:<br>`Decision Maker`<br>`Evaluator/Recommender`<br>`Influencer`<br>`Not involved`
     */
    role_in_purchase_process?: string;
    /**
     * Registrant's State/Province.
     */
    state?: string;
    /**
     * Registrant's Zip/Postal Code.
     */
    zip?: string;
  };
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
  };
};

export type MeetingRecordingRegistrantCreateResponse = {
  /**
   * [Meeting ID](https://support.zoom.us/hc/en-us/articles/201362373-What-is-a-Meeting-ID-): Unique identifier of the meeting in "**long**" format(represented as int64 data type in JSON), also known as the meeting number.
   */
  id?: number;
  /**
   * Registrant ID
   */
  registrant_id?: string;
  /**
   * Share URL for the on-demand recording. This includes the “tk” token for the registrant. This is similar to the token that Zoom returns in the URL response to join a registered meeting, for example: `url?tk=xxxx`. Except while the meeting registration token can be used to join the meeting, this token can only be used to watch the recording.
   */
  share_url?: string;
  /**
   * Meeting Topic
   */
  topic?: string;
};

export type MeetingRecordingRegistrantCreateError = unknown;

export type RecordingRegistrantsQuestionsGetData = {
  path: {
    /**
     * To get Cloud Recordings of a meeting, provide the meeting ID or meeting UUID. If the meeting ID is provided instead of UUID,the response will be for the latest meeting instance.
     *
     * To get Cloud Recordings of a webinar, provide the webinar ID or the webinar UUID. If the webinar ID is provided instead of UUID,the response will be for the latest webinar instance.
     *
     * If a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875=="), you must **double encode** the UUID before making an API request.
     */
    meetingId: string;
  };
};

export type RecordingRegistrantsQuestionsGetResponse = {
  /**
   * Array of Registrant Custom Questions
   */
  custom_questions?: Array<{
    /**
     * Answer choices for the question. Can not be used with Short answer type.
     */
    answers?: Array<string>;
    /**
     * State whether registrants are required to answer custom questions or not.
     */
    required?: boolean;
    /**
     * Title of the question.
     */
    title?: string;
    /**
     * The type of registration question and answers.
     */
    type?: 'short' | 'single' | 'multiple';
  }>;
  /**
   * Array of Registrant Questions
   */
  questions?: Array<{
    /**
     * Field name.
     */
    field_name?:
      | 'last_name'
      | 'address'
      | 'city'
      | 'country'
      | 'zip'
      | 'state'
      | 'phone'
      | 'industry'
      | 'org'
      | 'job_title'
      | 'purchasing_time_frame'
      | 'role_in_purchase_process'
      | 'no_of_employees'
      | 'comments';
    /**
     * State whether the field is required to be answered by the registrant or not.
     */
    required?: boolean;
  }>;
};

export type RecordingRegistrantsQuestionsGetError = unknown;

export type RecordingRegistrantQuestionUpdateData = {
  /**
   * Recording Registrant Questions
   */
  body: {
    /**
     * Array of Registrant Custom Questions
     */
    custom_questions?: Array<{
      /**
       * Answer choices for the question. Can not be used with Short answer type.
       */
      answers?: Array<string>;
      /**
       * State whether registrants are required to answer custom questions or not.
       */
      required?: boolean;
      /**
       * Title of the question.
       */
      title?: string;
      /**
       * The type of registration question and answers.
       */
      type?: 'short' | 'single' | 'multiple';
    }>;
    /**
     * Array of Registrant Questions
     */
    questions?: Array<{
      /**
       * Field name.
       */
      field_name?:
        | 'last_name'
        | 'address'
        | 'city'
        | 'country'
        | 'zip'
        | 'state'
        | 'phone'
        | 'industry'
        | 'org'
        | 'job_title'
        | 'purchasing_time_frame'
        | 'role_in_purchase_process'
        | 'no_of_employees'
        | 'comments';
      /**
       * State whether the field is required to be answered by the registrant or not.
       */
      required?: boolean;
    }>;
  };
  path: {
    /**
     * To get Cloud Recordings of a meeting, provide the meeting ID or meeting UUID. If the meeting ID is provided instead of UUID,the response will be for the latest meeting instance.
     *
     * To get Cloud Recordings of a webinar, provide the webinar ID or the webinar UUID. If the webinar ID is provided instead of UUID,the response will be for the latest webinar instance.
     *
     * If a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875=="), you must **double encode** the UUID before making an API request.
     */
    meetingId: string;
  };
};

export type RecordingRegistrantQuestionUpdateResponse = any;

export type RecordingRegistrantQuestionUpdateError = unknown;

export type MeetingRecordingRegistrantStatusData = {
  body: {
    action: 'approve' | 'deny';
    /**
     * List of registrants
     */
    registrants?: Array<{
      id?: string;
    }>;
  };
  path: {
    /**
     * The meeting ID in **long** format. The data type of this field is "long"(represented as int64 in JSON).
     *
     * While storing it in your database, store it as a **long** data type and **not as an integer**, as the Meeting IDs can be longer than 10 digits.
     */
    meetingId: number;
  };
};

export type MeetingRecordingRegistrantStatusResponse = any;

export type MeetingRecordingRegistrantStatusError = unknown;

export type RecordingSettingUpdateData = {
  path: {
    /**
     * To get Cloud Recordings of a meeting, provide the meeting ID or meeting UUID. If the meeting ID is provided instead of UUID,the response will be for the latest meeting instance.
     *
     * To get Cloud Recordings of a webinar, provide the webinar ID or the webinar UUID. If the webinar ID is provided instead of UUID,the response will be for the latest webinar instance.
     *
     * If a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875=="), you must **double encode** the UUID before making an API request.
     */
    meetingId: string;
  };
};

export type RecordingSettingUpdateResponse = {
  /**
   * Approval type for the registration.<br>
   * `0`- Automatically approve the registration when a user registers.<br>
   * `1` - Manually approve or deny the registration of a user.<br>
   * `2` - No registration required to view the recording.
   */
  approval_type?: 0 | 1 | 2;
  /**
   * Authentication domains.
   */
  authentication_domains?: string;
  /**
   * Authentication Options.
   */
  authentication_option?: string;
  /**
   * Determine whether registration  isrequired to view the recording.
   */
  on_demand?: boolean;
  /**
   * Enable password protection for the recording by setting a password. The password must have a minimum of **eight** characters with a mix of numbers, letters and special characters.<br><br>
   * **Note:** If the account owner or the admin has set minimum password strength requirements for recordings via Account Settings, the password value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API.
   */
  password?: string;
  /**
   * Only authenticated users can view.
   */
  recording_authentication?: boolean;
  /**
   * Send an email to host when someone registers to view the recording. This applies for On-demand recordings only.
   */
  send_email_to_host?: boolean;
  /**
   * Determine how the meeting recording is shared.
   */
  share_recording?: 'publicly' | 'internally' | 'none';
  /**
   * Show social share buttons on registration page. This applies for On-demand recordings only.
   */
  show_social_share_buttons?: boolean;
  /**
   * Name of the recording.
   */
  topic?: string;
  /**
   * Determine whether a viewer can download the recording file or not.
   */
  viewer_download?: boolean;
};

export type RecordingSettingUpdateError = unknown;

export type RecordingSettingsUpdateData = {
  /**
   * Meeting recording Settings
   */
  body: {
    /**
     * Approval type for the registration.<br>
     * `0`- Automatically approve the registration when a user registers.<br>
     * `1` - Manually approve or deny the registration of a user.<br>
     * `2` - No registration required to view the recording.
     */
    approval_type?: 0 | 1 | 2;
    /**
     * Authentication domains.
     */
    authentication_domains?: string;
    /**
     * Authentication Options.
     */
    authentication_option?: string;
    /**
     * Determine whether registration  isrequired to view the recording.
     */
    on_demand?: boolean;
    /**
     * Enable password protection for the recording by setting a password. The password must have a minimum of **eight** characters with a mix of numbers, letters and special characters.<br><br>
     * **Note:** If the account owner or the admin has set minimum password strength requirements for recordings via Account Settings, the password value provided here must meet those requirements. <br><br>If the requirements are enabled, you can view those requirements by calling either the [Get User Settings API](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usersettings) or the [Get Account Settings](https://marketplace.zoom.us/docs/api-reference/zoom-api/accounts/accountsettings) API.
     */
    password?: string;
    /**
     * Only authenticated users can view.
     */
    recording_authentication?: boolean;
    /**
     * Send an email to host when someone registers to view the recording. This applies for On-demand recordings only.
     */
    send_email_to_host?: boolean;
    /**
     * Determine how the meeting recording is shared.
     */
    share_recording?: 'publicly' | 'internally' | 'none';
    /**
     * Show social share buttons on registration page. This applies for On-demand recordings only.
     */
    show_social_share_buttons?: boolean;
    /**
     * Name of the recording.
     */
    topic?: string;
    /**
     * Determine whether a viewer can download the recording file or not.
     */
    viewer_download?: boolean;
  };
  path: {
    /**
     * To get Cloud Recordings of a meeting, provide the meeting ID or meeting UUID. If the meeting ID is provided instead of UUID,the response will be for the latest meeting instance.
     *
     * To get Cloud Recordings of a webinar, provide the webinar ID or the webinar UUID. If the webinar ID is provided instead of UUID,the response will be for the latest webinar instance.
     *
     * If a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875=="), you must **double encode** the UUID before making an API request.
     */
    meetingId: string;
  };
};

export type RecordingSettingsUpdateResponse = any;

export type RecordingSettingsUpdateError = unknown;

export type RecordingStatusUpdateData = {
  body: {
    action?: 'recover';
  };
  path: {
    /**
     * To get Cloud Recordings of a meeting, provide the meeting ID or meeting UUID. If the meeting ID is provided instead of UUID,the response will be for the latest meeting instance.
     *
     * To get Cloud Recordings of a webinar, provide the webinar ID or the webinar UUID. If the webinar ID is provided instead of UUID,the response will be for the latest webinar instance.
     *
     * If a UUID starts with "/" or contains "//" (example: "/ajXp112QmuoKj4854875=="), you must **double encode** the UUID before making an API request.
     */
    meetingId: string;
  };
};

export type RecordingStatusUpdateResponse = unknown | any;

export type RecordingStatusUpdateError = unknown;

export type RecordingDeleteOneData = {
  path: {
    /**
     * To get Cloud Recordings of a meeting, provide the meeting ID or meeting UUID. If the meeting ID is provided instead of UUID,the response will be for the latest meeting instance.
     *
     * To get Cloud Recordings of a webinar, provide the webinar ID or the webinar UUID. If the webinar I