// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options, formDataBodySerializer } from '@hey-api/client-fetch';

import type {
  AccountsData,
  AccountsError,
  AccountsResponse,
  AccountCreateData,
  AccountCreateError,
  AccountCreateResponse,
  AccountDisassociateData,
  AccountDisassociateError,
  AccountDisassociateResponse,
  AccountData,
  AccountError,
  AccountResponse,
  AccountBillingData,
  AccountBillingError,
  AccountBillingResponse,
  AccountBillingUpdateData,
  AccountBillingUpdateError,
  AccountBillingUpdateResponse,
  AccountBillingInvoicesData,
  AccountBillingInvoicesError,
  AccountBillingInvoicesResponse,
  GetAccountBillingInvoiceData,
  GetAccountBillingInvoiceError,
  GetAccountBillingInvoiceResponse,
  GetAccountLockSettingsData,
  GetAccountLockSettingsError,
  GetAccountLockSettingsResponse,
  UpdateAccountLockSettingsData,
  UpdateAccountLockSettingsError,
  UpdateAccountLockSettingsResponse,
  AccountManagedDomainData,
  AccountManagedDomainError,
  AccountManagedDomainResponse,
  AccountOptionsUpdateData,
  AccountOptionsUpdateError,
  AccountOptionsUpdateResponse,
  UpdateAccountOwnerData,
  UpdateAccountOwnerError,
  UpdateAccountOwnerResponse,
  UpdatePhoneSettingsData,
  UpdatePhoneSettingsError,
  UpdatePhoneSettingsResponse,
  SetUpAccountData,
  SetUpAccountError,
  SetUpAccountResponse,
  PostPhoneSipTrunkData,
  PostPhoneSipTrunkError,
  PostPhoneSipTrunkResponse,
  UpdatePhoneSipTrunkData,
  UpdatePhoneSipTrunkError,
  UpdatePhoneSipTrunkResponse,
  AccountPlansData,
  AccountPlansError,
  AccountPlansResponse,
  AccountPlanCreateData,
  AccountPlanCreateError,
  AccountPlanCreateResponse,
  AccountPlanAddonCreateData,
  AccountPlanAddonCreateError,
  AccountPlanAddonCreateResponse,
  AccountPlanAddonUpdateData,
  AccountPlanAddonUpdateError,
  AccountPlanAddonUpdateResponse,
  AccountPlanAddonCancelData,
  AccountPlanAddonCancelError,
  AccountPlanAddonCancelResponse,
  AccountPlanBaseUpdateData,
  AccountPlanBaseUpdateError,
  AccountPlanBaseUpdateResponse,
  AccountPlanBaseDeleteData,
  AccountPlanBaseDeleteError,
  AccountPlanBaseDeleteResponse,
  GetPlanUsageData,
  GetPlanUsageError,
  GetPlanUsageResponse,
  GetAccountCloudRecordingData,
  GetAccountCloudRecordingError,
  GetAccountCloudRecordingResponse,
  AccountSettingsData,
  AccountSettingsError,
  AccountSettingsResponse,
  AccountSettingsUpdateData,
  AccountSettingsUpdateError,
  AccountSettingsUpdateResponse,
  DelVbData,
  DelVbError,
  DelVbResponse,
  UploadVbData,
  UploadVbError,
  UploadVbResponse,
  ListInternalCalloutCountriesData,
  ListInternalCalloutCountriesError,
  ListInternalCalloutCountriesResponse,
  AddCalloutCountriesData,
  AddCalloutCountriesError,
  AddCalloutCountriesResponse,
  DeleteInternalCallOutCountryData,
  DeleteInternalCallOutCountryError,
  DeleteInternalCallOutCountryResponse,
  ListInternalNumbersData,
  ListInternalNumbersError,
  ListInternalNumbersResponse,
  AddInternalNumbersData,
  AddInternalNumbersError,
  AddInternalNumbersResponse,
  DeleteInternalNumberData,
  DeleteInternalNumberError,
  DeleteInternalNumberResponse,
  DeleteAllSipNumbersData,
  DeleteAllSipNumbersError,
  DeleteAllSipNumbersResponse,
  AssignSipTrunkNumbersData,
  AssignSipTrunkNumbersError,
  AssignSipTrunkNumbersResponse,
  AssignSipConfigData,
  AssignSipConfigError,
  AssignSipConfigResponse,
  ListSipTrunksData,
  ListSipTrunksError,
  ListSipTrunksResponse,
  AssignSipTrunksData,
  AssignSipTrunksError,
  AssignSipTrunksResponse,
  DeleteSipTrunkData,
  DeleteSipTrunkError,
  DeleteSipTrunkResponse,
  AccountTrustedDomainData,
  AccountTrustedDomainError,
  AccountTrustedDomainResponse,
  SwitchUserAccountData,
  SwitchUserAccountError,
  SwitchUserAccountResponse,
  DownloadInvoicePdfData,
  DownloadInvoicePdfError,
  DownloadInvoicePdfResponse,
  ListArchivedFilesData,
  ListArchivedFilesError,
  ListArchivedFilesResponse,
  DeleteUserLevelChannelData,
  DeleteUserLevelChannelError,
  DeleteUserLevelChannelResponse,
  GetUserLevelChannelData,
  GetUserLevelChannelError,
  GetUserLevelChannelResponse,
  UpdateUserLevelChannelData,
  UpdateUserLevelChannelError,
  UpdateUserLevelChannelResponse,
  LeaveChannelData,
  LeaveChannelError,
  LeaveChannelResponse,
  JoinChannelData,
  JoinChannelError,
  JoinChannelResponse,
  RemoveAuserLevelChannelMemberData,
  RemoveAuserLevelChannelMemberError,
  RemoveAuserLevelChannelMemberResponse,
  GetUserContactsData,
  GetUserContactsError,
  GetUserContactsResponse,
  GetUserContactData,
  GetUserContactError,
  GetUserContactResponse,
  GetChannelsData,
  GetChannelsError,
  GetChannelsResponse,
  CreateChannelData,
  CreateChannelError,
  CreateChannelResponse,
  DeleteChannelData,
  DeleteChannelError,
  DeleteChannelResponse,
  GetChannelData,
  GetChannelError,
  GetChannelResponse,
  UpdateChannelData,
  UpdateChannelError,
  UpdateChannelResponse,
  ListChannelMembersData,
  ListChannelMembersError,
  ListChannelMembersResponse,
  InviteChannelMembersData,
  InviteChannelMembersError,
  InviteChannelMembersResponse,
  RemoveAchannelMemberData,
  RemoveAchannelMemberError,
  RemoveAchannelMemberResponse,
  GetChatMessagesData,
  GetChatMessagesError,
  GetChatMessagesResponse,
  SendaChatMessageData,
  SendaChatMessageError,
  SendaChatMessageResponse,
  DeleteChatMessageData,
  DeleteChatMessageError,
  DeleteChatMessageResponse,
  EditMessageData,
  EditMessageError,
  EditMessageResponse,
  SearchCompanyContactsData,
  SearchCompanyContactsError,
  SearchCompanyContactsResponse,
  GroupsError,
  GroupsResponse,
  GroupCreateData,
  GroupCreateError,
  GroupCreateResponse,
  GroupDeleteData,
  GroupDeleteError,
  GroupDeleteResponse,
  GroupData,
  GroupError,
  GroupResponse,
  GroupUpdateData,
  GroupUpdateError,
  GroupUpdateResponse,
  GetGroupLockSettingsData,
  GetGroupLockSettingsError,
  GetGroupLockSettingsResponse,
  GroupLockedSettingsData,
  GroupLockedSettingsError,
  GroupLockedSettingsResponse,
  GroupMembersData,
  GroupMembersError,
  GroupMembersResponse,
  GroupMembersCreateData,
  GroupMembersCreateError,
  GroupMembersCreateResponse,
  GroupMembersDeleteData,
  GroupMembersDeleteError,
  GroupMembersDeleteResponse,
  UpdateAgroupMemberData,
  UpdateAgroupMemberError,
  UpdateAgroupMemberResponse,
  GetGroupSettingsData,
  GetGroupSettingsError,
  GetGroupSettingsResponse,
  UpdateGroupSettingsData,
  UpdateGroupSettingsError,
  UpdateGroupSettingsResponse,
  DelGroupVbData,
  DelGroupVbError,
  DelGroupVbResponse,
  UploadGroupVbData,
  UploadGroupVbError,
  UploadGroupVbResponse,
  DeviceListData,
  DeviceListError,
  DeviceListResponse,
  DeviceCreateData,
  DeviceCreateError,
  DeviceCreateResponse,
  DeviceDeleteData,
  DeviceDeleteError,
  DeviceDeleteResponse,
  DeviceUpdateData,
  DeviceUpdateError,
  DeviceUpdateResponse,
  SendchatbotData,
  SendchatbotError,
  SendchatbotResponse,
  DeleteAchatbotMessageData,
  DeleteAchatbotMessageError,
  DeleteAchatbotMessageResponse,
  EditChatbotMessageData,
  EditChatbotMessageError,
  EditChatbotMessageResponse,
  ImChatSessionsData,
  ImChatSessionsError,
  ImChatSessionsResponse,
  ImChatMessagesData,
  ImChatMessagesError,
  ImChatMessagesResponse,
  ImGroupsError,
  ImGroupsResponse,
  ImGroupCreateData,
  ImGroupCreateError,
  ImGroupCreateResponse,
  ImGroupDeleteData,
  ImGroupDeleteError,
  ImGroupDeleteResponse,
  ImGroupData,
  ImGroupError,
  ImGroupResponse,
  ImGroupUpdateData,
  ImGroupUpdateError,
  ImGroupUpdateResponse,
  ImGroupMembersData,
  ImGroupMembersError,
  ImGroupMembersResponse,
  ImGroupMembersCreateData,
  ImGroupMembersCreateError,
  ImGroupMembersCreateResponse,
  ImGroupMembersDeleteData,
  ImGroupMembersDeleteError,
  ImGroupMembersDeleteResponse,
  SendimmessagesData,
  SendimmessagesError,
  SendimmessagesResponse,
  ListimmessagesData,
  ListimmessagesError,
  ListimmessagesResponse,
  InMeetingRecordingControlData,
  InMeetingRecordingControlError,
  InMeetingRecordingControlResponse,
  MeetingDeleteData,
  MeetingDeleteError,
  MeetingDeleteResponse,
  MeetingData,
  MeetingError,
  MeetingResponse,
  MeetingUpdateData,
  MeetingUpdateError,
  MeetingUpdateResponse,
  CreateBatchPollsData,
  CreateBatchPollsError,
  CreateBatchPollsResponse,
  MeetingInvitationData,
  MeetingInvitationError,
  MeetingInvitationResponse,
  GetLiveStreamDetailsData,
  GetLiveStreamDetailsError,
  GetLiveStreamDetailsResponse,
  MeetingLiveStreamUpdateData,
  MeetingLiveStreamUpdateError,
  MeetingLiveStreamUpdateResponse,
  MeetingLiveStreamStatusUpdateData,
  MeetingLiveStreamStatusUpdateError,
  MeetingLiveStreamStatusUpdateResponse,
  MeetingPollsData,
  MeetingPollsError,
  MeetingPollsResponse,
  MeetingPollCreateData,
  MeetingPollCreateError,
  MeetingPollCreateResponse,
  MeetingPollDeleteData,
  MeetingPollDeleteError,
  MeetingPollDeleteResponse,
  MeetingPollGetData,
  MeetingPollGetError,
  MeetingPollGetResponse,
  MeetingPollUpdateData,
  MeetingPollUpdateError,
  MeetingPollUpdateResponse,
  RecordingDeleteData,
  RecordingDeleteError,
  RecordingDeleteResponse,
  RecordingGetData,
  RecordingGetError,
  RecordingGetResponse,
  MeetingRecordingRegistrantsData,
  MeetingRecordingRegistrantsError,
  MeetingRecordingRegistrantsResponse,
  MeetingRecordingRegistrantCreateData,
  MeetingRecordingRegistrantCreateError,
  MeetingRecordingRegistrantCreateResponse,
  RecordingRegistrantsQuestionsGetData,
  RecordingRegistrantsQuestionsGetError,
  RecordingRegistrantsQuestionsGetResponse,
  RecordingRegistrantQuestionUpdateData,
  RecordingRegistrantQuestionUpdateError,
  RecordingRegistrantQuestionUpdateResponse,
  MeetingRecordingRegistrantStatusData,
  MeetingRecordingRegistrantStatusError,
  MeetingRecordingRegistrantStatusResponse,
  RecordingSettingUpdateData,
  RecordingSettingUpdateError,
  RecordingSettingUpdateResponse,
  RecordingSettingsUpdateData,
  RecordingSettingsUpdateError,
  RecordingSettingsUpdateResponse,
  RecordingStatusUpdateData,
  RecordingStatusUpdateError,
  RecordingStatusUpdateResponse,
  RecordingDeleteOneData,
  RecordingDeleteOneError,
  RecordingDeleteOneResponse,
  RecordingStatusUpdateOneData,
  RecordingStatusUpdateOneError,
  RecordingStatusUpdateOneResponse,
  MeetingRegistrantsData,
  MeetingRegistrantsError,
  MeetingRegistrantsResponse,
  MeetingRegistrantCreateData,
  MeetingRegistrantCreateError,
  MeetingRegistrantCreateResponse,
  MeetingRegistrantsQuestionsGetData,
  MeetingRegistrantsQuestionsGetError,
  MeetingRegistrantsQuestionsGetResponse,
  MeetingRegistrantQuestionUpdateData,
  MeetingRegistrantQuestionUpdateError,
  MeetingRegistrantQuestionUpdateResponse,
  MeetingRegistrantStatusData,
  MeetingRegistrantStatusError,
  MeetingRegistrantStatusResponse,
  MeetingregistrantdeleteData,
  MeetingregistrantdeleteError,
  MeetingregistrantdeleteResponse,
  MeetingStatusData,
  MeetingStatusError,
  MeetingStatusResponse,
  DashboardClientFeedbackData,
  DashboardClientFeedbackError,
  DashboardClientFeedbackResponse,
  DashboardClientFeedbackDetailData,
  DashboardClientFeedbackDetailError,
  DashboardClientFeedbackDetailResponse,
  ListMeetingSatisfactionData,
  ListMeetingSatisfactionError,
  ListMeetingSatisfactionResponse,
  DashboardCrcData,
  DashboardCrcError,
  DashboardCrcResponse,
  DashboardImData,
  DashboardImError,
  DashboardImResponse,
  DashboardIssueZoomRoomData,
  DashboardIssueZoomRoomError,
  DashboardIssueZoomRoomResponse,
  DashboardIssueDetailZoomRoomData,
  DashboardIssueDetailZoomRoomError,
  DashboardIssueDetailZoomRoomResponse,
  DashboardMeetingsData,
  DashboardMeetingsError,
  DashboardMeetingsResponse,
  DashboardMeetingDetailData,
  DashboardMeetingDetailError,
  DashboardMeetingDetailResponse,
  DashboardMeetingParticipantsData,
  DashboardMeetingParticipantsError,
  DashboardMeetingParticipantsResponse,
  DashboardMeetingParticipantsQosData,
  DashboardMeetingParticipantsQosError,
  DashboardMeetingParticipantsQosResponse,
  ParticipantFeedbackData,
  ParticipantFeedbackError,
  ParticipantFeedbackResponse,
  DashboardMeetingParticipantShareData,
  DashboardMeetingParticipantShareError,
  DashboardMeetingParticipantShareResponse,
  DashboardMeetingParticipantQosData,
  DashboardMeetingParticipantQosError,
  DashboardMeetingParticipantQosResponse,
  DashboardWebinarsData,
  DashboardWebinarsError,
  DashboardWebinarsResponse,
  DashboardWebinarDetailData,
  DashboardWebinarDetailError,
  DashboardWebinarDetailResponse,
  DashboardWebinarParticipantsData,
  DashboardWebinarParticipantsError,
  DashboardWebinarParticipantsResponse,
  DashboardWebinarParticipantsQosData,
  DashboardWebinarParticipantsQosError,
  DashboardWebinarParticipantsQosResponse,
  ParticipantWebinarFeedbackData,
  ParticipantWebinarFeedbackError,
  ParticipantWebinarFeedbackResponse,
  DashboardWebinarParticipantShareData,
  DashboardWebinarParticipantShareError,
  DashboardWebinarParticipantShareResponse,
  DashboardWebinarParticipantQosData,
  DashboardWebinarParticipantQosError,
  DashboardWebinarParticipantQosResponse,
  DashboardZoomRoomsData,
  DashboardZoomRoomsError,
  DashboardZoomRoomsResponse,
  DashboardZoomRoomIssueData,
  DashboardZoomRoomIssueError,
  DashboardZoomRoomIssueResponse,
  DashboardZoomRoomData,
  DashboardZoomRoomError,
  DashboardZoomRoomResponse,
  ListPastMeetingFilesData,
  ListPastMeetingFilesError,
  ListPastMeetingFilesResponse,
  PastMeetingsData,
  PastMeetingsError,
  PastMeetingsResponse,
  ListPastMeetingPollsData,
  ListPastMeetingPollsError,
  ListPastMeetingPollsResponse,
  PastMeetingDetailsData,
  PastMeetingDetailsError,
  PastMeetingDetailsResponse,
  PastMeetingParticipantsData,
  PastMeetingParticipantsError,
  PastMeetingParticipantsResponse,
  WebinarAbsenteesData,
  WebinarAbsenteesError,
  WebinarAbsenteesResponse,
  ListPastWebinarFilesData,
  ListPastWebinarFilesError,
  ListPastWebinarFilesResponse,
  PastWebinarsData,
  PastWebinarsError,
  PastWebinarsResponse,
  ListWebinarParticipantsData,
  ListWebinarParticipantsError,
  ListWebinarParticipantsResponse,
  ListPastWebinarPollResultsData,
  ListPastWebinarPollResultsError,
  ListPastWebinarPollResultsResponse,
  ListPastWebinarQaData,
  ListPastWebinarQaError,
  ListPastWebinarQaResponse,
  AddAutoReceptionistData,
  AddAutoReceptionistError,
  AddAutoReceptionistResponse,
  UpdateAutoReceptionistData,
  UpdateAutoReceptionistError,
  UpdateAutoReceptionistResponse,
  UnassignAllPhoneNumsAutoReceptionistData,
  UnassignAllPhoneNumsAutoReceptionistError,
  UnassignAllPhoneNumsAutoReceptionistResponse,
  AssignPhoneNumbersAutoReceptionistData,
  AssignPhoneNumbersAutoReceptionistError,
  AssignPhoneNumbersAutoReceptionistResponse,
  UnassignAphoneNumAutoReceptionistData,
  UnassignAphoneNumAutoReceptionistError,
  UnassignAphoneNumAutoReceptionistResponse,
  ListBlockedListData,
  ListBlockedListError,
  ListBlockedListResponse,
  AddAnumberToBlockedListData,
  AddAnumberToBlockedListError,
  AddAnumberToBlockedListResponse,
  DeleteAblockedListData,
  DeleteAblockedListError,
  DeleteAblockedListResponse,
  GetAblockedListData,
  GetAblockedListError,
  GetAblockedListResponse,
  UpdateBlockedListData,
  UpdateBlockedListError,
  UpdateBlockedListResponse,
  AddByocNumberData,
  AddByocNumberError,
  AddByocNumberResponse,
  AccountCallLogsData,
  AccountCallLogsError,
  AccountCallLogsResponse,
  ListCallQueuesData,
  ListCallQueuesError,
  ListCallQueuesResponse,
  CreateCallQueueData,
  CreateCallQueueError,
  CreateCallQueueResponse,
  DeleteAcallQueueData,
  DeleteAcallQueueError,
  DeleteAcallQueueResponse,
  GetAcallQueueData,
  GetAcallQueueError,
  GetAcallQueueResponse,
  UpdateCallQueueData,
  UpdateCallQueueError,
  UpdateCallQueueResponse,
  ChangeCallQueueManagerData,
  ChangeCallQueueManagerError,
  ChangeCallQueueManagerResponse,
  UnassignAllMembersData,
  UnassignAllMembersError,
  UnassignAllMembersResponse,
  AddMembersToCallQueueData,
  AddMembersToCallQueueError,
  AddMembersToCallQueueResponse,
  UnassignMemberFromCallQueueData,
  UnassignMemberFromCallQueueError,
  UnassignMemberFromCallQueueResponse,
  UnassignAphoneNumCallQueueData,
  UnassignAphoneNumCallQueueError,
  UnassignAphoneNumCallQueueResponse,
  AssignPhoneToCallQueueData,
  AssignPhoneToCallQueueError,
  AssignPhoneToCallQueueResponse,
  UnAssignPhoneNumCallQueueData,
  UnAssignPhoneNumCallQueueError,
  UnAssignPhoneNumCallQueueResponse,
  GetCallQueueRecordingsData,
  GetCallQueueRecordingsError,
  GetCallQueueRecordingsResponse,
  ListCallingPlansError,
  ListCallingPlansResponse,
  ListCommonAreaPhonesData,
  ListCommonAreaPhonesError,
  ListCommonAreaPhonesResponse,
  AddCommonAreaPhoneData,
  AddCommonAreaPhoneError,
  AddCommonAreaPhoneResponse,
  DeleteCommonAreaPhoneData,
  DeleteCommonAreaPhoneError,
  DeleteCommonAreaPhoneResponse,
  GetAcommonAreaPhoneData,
  GetAcommonAreaPhoneError,
  GetAcommonAreaPhoneResponse,
  UpdateCommonAreaPhoneData,
  UpdateCommonAreaPhoneError,
  UpdateCommonAreaPhoneResponse,
  ChangeMainCompanyNumberData,
  ChangeMainCompanyNumberError,
  ChangeMainCompanyNumberResponse,
  ListPhoneDevicesData,
  ListPhoneDevicesError,
  ListPhoneDevicesResponse,
  AddPhoneDeviceData,
  AddPhoneDeviceError,
  AddPhoneDeviceResponse,
  DeleteAdeviceData,
  DeleteAdeviceError,
  DeleteAdeviceResponse,
  GetAdeviceData,
  GetAdeviceError,
  GetAdeviceResponse,
  UpdateAdeviceData,
  UpdateAdeviceError,
  UpdateAdeviceResponse,
  ListCallLogsMetricsData,
  ListCallLogsMetricsError,
  ListCallLogsMetricsResponse,
  GetCallQoSData,
  GetCallQoSError,
  GetCallQoSResponse,
  GetCallLogMetricsDetailsData,
  GetCallLogMetricsDetailsError,
  GetCallLogMetricsDetailsResponse,
  ListAccountPhoneNumbersData,
  ListAccountPhoneNumbersError,
  ListAccountPhoneNumbersResponse,
  GetPhoneNumberDetailsData,
  GetPhoneNumberDetailsError,
  GetPhoneNumberDetailsResponse,
  UpdatePhoneNumberDetailsData,
  UpdatePhoneNumberDetailsError,
  UpdatePhoneNumberDetailsResponse,
  GetPhoneRecordingsData,
  GetPhoneRecordingsError,
  GetPhoneRecordingsResponse,
  GetPsOperationLogsData,
  GetPsOperationLogsError,
  GetPsOperationLogsResponse,
  ListSettingTemplatesData,
  ListSettingTemplatesError,
  ListSettingTemplatesResponse,
  AddSettingTemplateData,
  AddSettingTemplateError,
  AddSettingTemplateResponse,
  GetSettingTemplateData,
  GetSettingTemplateError,
  GetSettingTemplateResponse,
  UpdateSettingTemplateData,
  UpdateSettingTemplateError,
  UpdateSettingTemplateResponse,
  ListSharedLineGroupsData,
  ListSharedLineGroupsError,
  ListSharedLineGroupsResponse,
  CreateAsharedLineGroupData,
  CreateAsharedLineGroupError,
  CreateAsharedLineGroupResponse,
  DeleteAsharedLineGroupData,
  DeleteAsharedLineGroupError,
  DeleteAsharedLineGroupResponse,
  GetAsharedLineGroupData,
  GetAsharedLineGroupError,
  GetAsharedLineGroupResponse,
  UpdateAsharedLineGroupData,
  UpdateAsharedLineGroupError,
  UpdateAsharedLineGroupResponse,
  DeleteMembersOfSlgData,
  DeleteMembersOfSlgError,
  DeleteMembersOfSlgResponse,
  AddMembersToSharedLineGroupData,
  AddMembersToSharedLineGroupError,
  AddMembersToSharedLineGroupResponse,
  DeleteAmemberSlgData,
  DeleteAmemberSlgError,
  DeleteAmemberSlgResponse,
  AssignPhoneNumbersSlgData,
  AssignPhoneNumbersSlgError,
  AssignPhoneNumbersSlgResponse,
  DeleteAphoneNumberSlgData,
  DeleteAphoneNumberSlgError,
  DeleteAphoneNumberSlgResponse,
  ListByocsipTrunkData,
  ListByocsipTrunkError,
  ListByocsipTrunkResponse,
  ListPhoneSitesData,
  ListPhoneSitesError,
  ListPhoneSitesResponse,
  CreatePhoneSiteData,
  CreatePhoneSiteError,
  CreatePhoneSiteResponse,
  DeletePhoneSiteData,
  DeletePhoneSiteError,
  DeletePhoneSiteResponse,
  GetAsiteData,
  GetAsiteError,
  GetAsiteResponse,
  UpdateSiteDetailsData,
  UpdateSiteDetailsError,
  UpdateSiteDetailsResponse,
  ListPhoneUsersData,
  ListPhoneUsersError,
  ListPhoneUsersResponse,
  PhoneUserData,
  PhoneUserError,
  PhoneUserResponse,
  UpdateUserProfileData,
  UpdateUserProfileError,
  UpdateUserProfileResponse,
  PhoneUserCallLogsData,
  PhoneUserCallLogsError,
  PhoneUserCallLogsResponse,
  DeleteCallLogData,
  DeleteCallLogError,
  DeleteCallLogResponse,
  AssignCallingPlanData,
  AssignCallingPlanError,
  AssignCallingPlanResponse,
  UnassignCallingPlanData,
  UnassignCallingPlanError,
  UnassignCallingPlanResponse,
  AssignPhoneNumberData,
  AssignPhoneNumberError,
  AssignPhoneNumberResponse,
  UnassignPhoneNumberData,
  UnassignPhoneNumberError,
  UnassignPhoneNumberResponse,
  PhoneUserRecordingsData,
  PhoneUserRecordingsError,
  PhoneUserRecordingsResponse,
  PhoneUserSettingsData,
  PhoneUserSettingsError,
  PhoneUserSettingsResponse,
  DeleteUserSettingData,
  DeleteUserSettingError,
  DeleteUserSettingResponse,
  UpdateUserSettingData,
  UpdateUserSettingError,
  UpdateUserSettingResponse,
  AddUserSettingData,
  AddUserSettingError,
  AddUserSettingResponse,
  PhoneUserVoiceMailsData,
  PhoneUserVoiceMailsError,
  PhoneUserVoiceMailsResponse,
  DeleteVoicemailData,
  DeleteVoicemailError,
  DeleteVoicemailResponse,
  ReportSignInSignOutActivitiesData,
  ReportSignInSignOutActivitiesError,
  ReportSignInSignOutActivitiesResponse,
  ReportCloudRecordingData,
  ReportCloudRecordingError,
  ReportCloudRecordingResponse,
  ReportDailyData,
  ReportDailyError,
  ReportDailyResponse,
  ReportMeetingDetailsData,
  ReportMeetingDetailsError,
  ReportMeetingDetailsResponse,
  ReportMeetingParticipantsData,
  ReportMeetingParticipantsError,
  ReportMeetingParticipantsResponse,
  ReportMeetingPollsData,
  ReportMeetingPollsError,
  ReportMeetingPollsResponse,
  ReportOperationLogsData,
  ReportOperationLogsError,
  ReportOperationLogsResponse,
  ReportTelephoneData,
  ReportTelephoneError,
  ReportTelephoneResponse,
  ReportUsersData,
  ReportUsersError,
  ReportUsersResponse,
  ReportMeetingsData,
  ReportMeetingsError,
  ReportMeetingsResponse,
  ReportWebinarDetailsData,
  ReportWebinarDetailsError,
  ReportWebinarDetailsResponse,
  ReportWebinarParticipantsData,
  ReportWebinarParticipantsError,
  ReportWebinarParticipantsResponse,
  ReportWebinarPollsData,
  ReportWebinarPollsError,
  ReportWebinarPollsResponse,
  ReportWebinarQaData,
  ReportWebinarQaError,
  ReportWebinarQaResponse,
  RolesError,
  RolesResponse,
  CreateRoleData,
  CreateRoleError,
  CreateRoleResponse,
  DeleteRoleData,
  DeleteRoleError,
  DeleteRoleResponse,
  GetRoleInformationData,
  GetRoleInformationError,
  GetRoleInformationResponse,
  UpdateRoleData,
  UpdateRoleError,
  UpdateRoleResponse,
  RoleMembersData,
  RoleMembersError,
  RoleMembersResponse,
  AddRoleMembersData,
  AddRoleMembersError,
  AddRoleMembersResponse,
  RoleMemberDeleteData,
  RoleMemberDeleteError,
  RoleMemberDeleteResponse,
  ListZoomRoomsData,
  ListZoomRoomsError,
  ListZoomRoomsResponse,
  AddAroomData,
  AddAroomError,
  AddAroomResponse,
  GetZrAccountProfileError,
  GetZrAccountProfileResponse,
  UpdateZrAccProfileData,
  UpdateZrAccProfileError,
  UpdateZrAccProfileResponse,
  GetZrAccountSettingsData,
  GetZrAccountSettingsError,
  GetZrAccountSettingsResponse,
  UpdateZoomRoomAccSettingsData,
  UpdateZoomRoomAccSettingsError,
  UpdateZoomRoomAccSettingsResponse,
  ListDigitalSignageContentData,
  ListDigitalSignageContentError,
  ListDigitalSignageContentResponse,
  ManageE911SignageData,
  ManageE911SignageError,
  ManageE911SignageResponse,
  ListZrLocationsData,
  ListZrLocationsError,
  ListZrLocationsResponse,
  AddAzrLocationData,
  AddAzrLocationError,
  AddAzrLocationResponse,
  GetZrLocationStructureError,
  GetZrLocationStructureResponse,
  UpdateZoomRoomsLocationStructureData,
  UpdateZoomRoomsLocationStructureError,
  UpdateZoomRoomsLocationStructureResponse,
  GetZrLocationProfileData,
  GetZrLocationProfileError,
  GetZrLocationProfileResponse,
  UpdateZrLocationProfileData,
  UpdateZrLocationProfileError,
  UpdateZrLocationProfileResponse,
  ChangeParentLocationData,
  ChangeParentLocationError,
  ChangeParentLocationResponse,
  GetZrLocationSettingsData,
  GetZrLocationSettingsError,
  GetZrLocationSettingsResponse,
  UpdateZrLocationSettingsData,
  UpdateZrLocationSettingsError,
  UpdateZrLocationSettingsResponse,
  CheckInRoomsData,
  CheckInRoomsError,
  CheckInRoomsResponse,
  DeleteAzoomRoomData,
  DeleteAzoomRoomError,
  DeleteAzoomRoomResponse,
  GetZrProfileData,
  GetZrProfileError,
  GetZrProfileResponse,
  UpdateRoomProfileData,
  UpdateRoomProfileError,
  UpdateRoomProfileResponse,
  ListZrDevicesData,
  ListZrDevicesError,
  ListZrDevicesResponse,
  ChangeZoomRoomsAppVersionData,
  ChangeZoomRoomsAppVersionError,
  ChangeZoomRoomsAppVersionResponse,
  ChangeZrLocationData,
  ChangeZrLocationError,
  ChangeZrLocationResponse,
  GetZrSettingsData,
  GetZrSettingsError,
  GetZrSettingsResponse,
  UpdateZrSettingsData,
  UpdateZrSettingsError,
  UpdateZrSettingsResponse,
  ListSipPhonesData,
  ListSipPhonesError,
  ListSipPhonesResponse,
  CreateSipPhoneData,
  CreateSipPhoneError,
  CreateSipPhoneResponse,
  DeleteSipPhoneData,
  DeleteSipPhoneError,
  DeleteSipPhoneResponse,
  UpdateSipPhoneData,
  UpdateSipPhoneError,
  UpdateSipPhoneResponse,
  ListSipTrunkNumbersError,
  ListSipTrunkNumbersResponse,
  TrackingfieldListError,
  TrackingfieldListResponse,
  TrackingfieldCreateData,
  TrackingfieldCreateError,
  TrackingfieldCreateResponse,
  TrackingfieldDeleteData,
  TrackingfieldDeleteError,
  TrackingfieldDeleteResponse,
  TrackingfieldGetData,
  TrackingfieldGetError,
  TrackingfieldGetResponse,
  TrackingfieldUpdateData,
  TrackingfieldUpdateError,
  TrackingfieldUpdateResponse,
  TspError,
  TspResponse,
  TspUpdateData,
  TspUpdateError,
  TspUpdateResponse,
  UsersData,
  UsersError,
  UsersResponse,
  UserCreateData,
  UserCreateError,
  UserCreateResponse,
  UserEmailData,
  UserEmailError,
  UserEmailResponse,
  UserZakError,
  UserZakResponse,
  UserVanityNameData,
  UserVanityNameError,
  UserVanityNameResponse,
  UserDeleteData,
  UserDeleteError,
  UserDeleteResponse,
  UserData,
  UserError,
  UserResponse,
  UserUpdateData,
  UserUpdateError,
  UserUpdateResponse,
  UserAssistantsDeleteData,
  UserAssistantsDeleteError,
  UserAssistantsDeleteResponse,
  UserAssistantsData,
  UserAssistantsError,
  UserAssistantsResponse,
  UserAssistantCreateData,
  UserAssistantCreateError,
  UserAssistantCreateResponse,
  UserAssistantDeleteData,
  UserAssistantDeleteError,
  UserAssistantDeleteResponse,
  UserEmailUpdateData,
  UserEmailUpdateError,
  UserEmailUpdateResponse,
  ListMeetingTemplatesData,
  ListMeetingTemplatesError,
  ListMeetingTemplatesResponse,
  MeetingsData,
  MeetingsError,
  MeetingsResponse,
  MeetingCreateData,
  MeetingCreateError,
  MeetingCreateResponse,
  UserPaCsData,
  UserPaCsError,
  UserPaCsResponse,
  UserPasswordData,
  UserPasswordError,
  UserPasswordResponse,
  UserPermissionData,
  UserPermissionError,
  UserPermissionResponse,
  UserPictureData,
  UserPictureError,
  UserPictureResponse,
  UpdatePresenceStatusData,
  UpdatePresenceStatusError,
  UpdatePresenceStatusResponse,
  RecordingsListData,
  RecordingsListError,
  RecordingsListResponse,
  UserSchedulersDeleteData,
  UserSchedulersDeleteError,
  UserSchedulersDeleteResponse,
  UserSchedulersData,
  UserSchedulersError,
  UserSchedulersResponse,
  UserSchedulerDeleteData,
  UserSchedulerDeleteError,
  UserSchedulerDeleteResponse,
  UserSettingsData,
  UserSettingsError,
  UserSettingsResponse,
  UserSettingsUpdateData,
  UserSettingsUpdateError,
  UserSettingsUpdateResponse,
  DelUserVbData,
  DelUserVbError,
  DelUserVbResponse,
  UploadVbuserData,
  UploadVbuserError,
  UploadVbuserResponse,
  UserStatusData,
  UserStatusError,
  UserStatusResponse,
  UserSsoTokenDeleteData,
  UserSsoTokenDeleteError,
  UserSsoTokenDeleteResponse,
  UserTokenData,
  UserTokenError,
  UserTokenResponse,
  UserTsPsData,
  UserTsPsError,
  UserTsPsResponse,
  UserTspCreateData,
  UserTspCreateError,
  UserTspCreateResponse,
  TspUrlUpdateData,
  TspUrlUpdateError,
  TspUrlUpdateResponse,
  UserTspDeleteData,
  UserTspDeleteError,
  UserTspDeleteResponse,
  UserTspData,
  UserTspError,
  UserTspResponse,
  UserTspUpdateData,
  UserTspUpdateError,
  UserTspUpdateResponse,
  ListWebinarTemplatesData,
  ListWebinarTemplatesError,
  ListWebinarTemplatesResponse,
  WebinarsData,
  WebinarsError,
  WebinarsResponse,
  WebinarCreateData,
  WebinarCreateError,
  WebinarCreateResponse,
  WebinarDeleteData,
  WebinarDeleteError,
  WebinarDeleteResponse,
  WebinarData,
  WebinarError,
  WebinarResponse,
  WebinarUpdateData,
  WebinarUpdateError,
  WebinarUpdateResponse,
  AddBatchWebinarRegistrantsData,
  AddBatchWebinarRegistrantsError,
  AddBatchWebinarRegistrantsResponse,
  WebinarPanelistsDeleteData,
  WebinarPanelistsDeleteError,
  WebinarPanelistsDeleteResponse,
  WebinarPanelistsData,
  WebinarPanelistsError,
  WebinarPanelistsResponse,
  WebinarPanelistCreateData,
  WebinarPanelistCreateError,
  WebinarPanelistCreateResponse,
  WebinarPanelistDeleteData,
  WebinarPanelistDeleteError,
  WebinarPanelistDeleteResponse,
  WebinarPollsData,
  WebinarPollsError,
  WebinarPollsResponse,
  WebinarPollCreateData,
  WebinarPollCreateError,
  WebinarPollCreateResponse,
  WebinarPollDeleteData,
  WebinarPollDeleteError,
  WebinarPollDeleteResponse,
  WebinarPollGetData,
  WebinarPollGetError,
  WebinarPollGetResponse,
  WebinarPollUpdateData,
  WebinarPollUpdateError,
  WebinarPollUpdateResponse,
  WebinarRegistrantsData,
  WebinarRegistrantsError,
  WebinarRegistrantsResponse,
  WebinarRegistrantCreateData,
  WebinarRegistrantCreateError,
  WebinarRegistrantCreateResponse,
  WebinarRegistrantsQuestionsGetData,
  WebinarRegistrantsQuestionsGetError,
  WebinarRegistrantsQuestionsGetResponse,
  WebinarRegistrantQuestionUpdateData,
  WebinarRegistrantQuestionUpdateError,
  WebinarRegistrantQuestionUpdateResponse,
  WebinarRegistrantStatusData,
  WebinarRegistrantStatusError,
  WebinarRegistrantStatusResponse,
  DeleteWebinarRegistrantData,
  DeleteWebinarRegistrantError,
  DeleteWebinarRegistrantResponse,
  WebinarRegistrantGetData,
  WebinarRegistrantGetError,
  WebinarRegistrantGetResponse,
  WebinarStatusData,
  WebinarStatusError,
  WebinarStatusResponse,
  GetTrackingSourcesData,
  GetTrackingSourcesError,
  GetTrackingSourcesResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * List sub accounts
 * List all the sub accounts that have been created by a master account.<br><br>Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts. Email the partner programs team at **partner-success@zoom.us** for more details.
 *
 * <br>**Prerequisites:**<br>
 * * Pro or a higher paid account with master account option enabled. <br>
 *
 * **Scope**: `account:read:admin`
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 */
export const accounts = <ThrowOnError extends boolean = false>(options?: Options<AccountsData, ThrowOnError>) => {
  return (options?.client ?? client).get<AccountsResponse, AccountsError, ThrowOnError>({
    ...options,
    url: '/accounts',
  });
};

/**
 * Create a sub account
 * Create a sub account under a master account. Your account must be a master account in order to create sub accounts.
 * <br><br>Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts. Email the partner programs team at partner-success@zoom.us. for more details. Please note that the created account user will receive a confirmation email.<br><br>
 * <br>
 * **Prerequisites:**<br>
 * * Pro or a higher paid account with master account option enabled. <br>
 *
 * **Scope**: `account:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 *
 */
export const accountCreate = <ThrowOnError extends boolean = false>(
  options: Options<AccountCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AccountCreateResponse, AccountCreateError, ThrowOnError>({
    ...options,
    url: '/accounts',
  });
};

/**
 * Disassociate a sub account
 * Disassociate a sub account from its master account. This will leave the sub account intact but it will no longer be associated with the master account.<br>
 *
 * **Prerequisites:**
 * * Pro or a higher paid account with master account option enabled. <br>
 * * The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis).<br><br>
 *
 *
 * **Scope**: `account:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 *
 */
export const accountDisassociate = <ThrowOnError extends boolean = false>(
  options: Options<AccountDisassociateData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<AccountDisassociateResponse, AccountDisassociateError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}',
  });
};

/**
 * Get sub account details
 * Get details of a sub account that is listed under a master account. Your account must be a master account in order to retrieve sub accounts' details. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and create sub accounts. Email the partner programs team at **partner-success@zoom.us** for more details.
 *
 * **Prerequisites:**
 * * Pro or a higher paid account with master account option enabled. <br>
 *
 * **Scope**: `account:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 *
 *
 */
export const account = <ThrowOnError extends boolean = false>(options: Options<AccountData, ThrowOnError>) => {
  return (options?.client ?? client).get<AccountResponse, AccountError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}',
  });
};

/**
 * Get billing information
 * Get [billing information](https://support.zoom.us/hc/en-us/articles/201363263-About-Billing) of a sub account.<br><br>Only master accounts can use this API. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' billing information. Email the partner programs team at **partner-success@zoom.us** for more details.<br>
 *
 * **Prerequisites:**
 * * Pro or a higher paid account with master account option enabled. <br>
 *
 * **Scope**:`billing:master`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 */
export const accountBilling = <ThrowOnError extends boolean = false>(
  options: Options<AccountBillingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AccountBillingResponse, AccountBillingError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/billing',
  });
};

/**
 * Update billing information
 * Update [billing information](https://support.zoom.us/hc/en-us/articles/201363263-About-Billing) of a sub account.<br><br>
 * This API can only be used by master accounts that pay all billiing charges of their associated sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' billing information. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>
 *
 * **Prerequisites:**
 * * Pro or a higher paid account with master account option enabled. <br>
 *
 * **Scope**:`billing:master`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 *
 *
 */
export const accountBillingUpdate = <ThrowOnError extends boolean = false>(
  options: Options<AccountBillingUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<AccountBillingUpdateResponse, AccountBillingUpdateError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/billing',
  });
};

/**
 * List billing invoices
 * List [invoices](https://support.zoom.us/hc/en-us/articles/207276556-Viewing-your-invoice-history#h_6710542f-23cc-4059-9cc7-ff02bec7314e) of a Zoom account.
 *
 * To list a regular Zoom account's invoices or a master account's invoices, provide `me` as the value of the `accountId` path parameter. To list a sub account's invoices, provide the account ID of the sub account in the `accountId` path parameter.
 *
 * **Prerequisites:**
 * * Account must be enrolled in Pro or a higher plan.<br>
 *
 * **Scope**:`billing:master`<br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Additional Rate Limit:** You can make **one** API request per account(`accountId`) every **five** minutes until the daily limit is reached. This API has a daily limit of **6** requests per account(`accountId`).
 */
export const accountBillingInvoices = <ThrowOnError extends boolean = false>(
  options: Options<AccountBillingInvoicesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AccountBillingInvoicesResponse, AccountBillingInvoicesError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/billing/invoices',
  });
};

/**
 * Get invoice details
 * Get detailed information about a specific [invoice](https://support.zoom.us/hc/en-us/articles/207276556-Viewing-your-invoice-history#h_6710542f-23cc-4059-9cc7-ff02bec7314e). <br>To retrieve a regular Zoom account's invoice details or a master account's invoice details, provide `me` as the value of `accountId` path parameter. To list a sub account's invoice details, provide the account ID of the sub account in the `accountId` path parameter.
 *
 * **Prerequisites:**
 * * Account must be enrolled in Pro or a higher plan. <br>
 *
 * **Scope**:`billing:master`<br>
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Additional Rate Limit:** You can make **one** API request every **thirty** minutes until the daily limit is reached. This API has a daily limit of **100** requests per **account**.
 */
export const getAccountBillingInvoice = <ThrowOnError extends boolean = false>(
  options: Options<GetAccountBillingInvoiceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAccountBillingInvoiceResponse, GetAccountBillingInvoiceError, ThrowOnError>(
    {
      ...options,
      url: '/accounts/{accountId}/billing/invoices/{invoiceId}',
    },
  );
};

/**
 * Get locked settings
 * [Account Locked Settings](https://support.zoom.us/hc/en-us/articles/115005269866) allow you turn settings on or off for all users in your account. No user except the account admin or account owner can change these settings. With lock settings, you force the settings on for all users.
 * Use this API to retrieve an account's locked settings.
 *
 * **Note:** This API can be used by Zoom Accounts that are on a Pro or a higher plan as well accounts that have master and sub accounts options enabled. <br><br>
 * **Prerequisites:**
 * * Pro or a higher paid account. <br>
 *
 * **Scope**: `account:read:admin`.
 * <br> **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 *
 *
 *
 * **Scope:** account:read:admin
 */
export const getAccountLockSettings = <ThrowOnError extends boolean = false>(
  options: Options<GetAccountLockSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAccountLockSettingsResponse, GetAccountLockSettingsError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/lock_settings',
  });
};

/**
 * Update locked settings
 * [Account Locked Settings](https://support.zoom.us/hc/en-us/articles/115005269866) allow you turn settings on or off for all users in your account. No user except the account admin or account owner can change these settings. With lock settings, you force the settings on for all users. Use this API to update an account's locked settings.
 *
 * **Note:** This API can be used by Zoom Accounts that are on a Pro or a higher plan as well accounts that have master and sub accounts options enabled.<br><br>
 * **Prerequisites:**<br>
 * * Pro or a higher paid account. <br>
 *
 * **Scope:** `account:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 *
 */
export const updateAccountLockSettings = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAccountLockSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateAccountLockSettingsResponse,
    UpdateAccountLockSettingsError,
    ThrowOnError
  >({
    ...options,
    url: '/accounts/{accountId}/lock_settings',
  });
};

/**
 * Get managed domains
 * Get a sub account's [managed domains](https://support.zoom.us/hc/en-us/articles/203395207-What-is-Managed-Domain-).<br><br>
 *
 * **Note:** This API can be used by Zoom Accounts that are on a Pro or a higher plan as well accounts that have master and sub accounts options enabled. <br><br>
 * To get managed domains of the master account, provide `me` as the value for accountId in the path parameter. Provide the sub account's Account ID as the value of accountId path parameter to get managed domains of the sub account.<br><br>
 * **Prerequisites:**<br>
 * * Pro or a higher paid account with master account option enabled. <br>
 *
 * **Scope:** `account:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 *
 *
 */
export const accountManagedDomain = <ThrowOnError extends boolean = false>(
  options: Options<AccountManagedDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AccountManagedDomainResponse, AccountManagedDomainError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/managed_domains',
  });
};

/**
 * Update options
 * Update a sub account's options under the master account.<br> <aside>Your account must be a master account in order to update the options for sub accounts. Zoom only assigns this privilege to trusted partners. </aside>
 *
 * **Prerequisites:**
 * * Pro or a higher paid account with master account option enabled.
 * * The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis).<br><br>
 *
 * **Scope**: `account:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 *
 */
export const accountOptionsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<AccountOptionsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<AccountOptionsUpdateResponse, AccountOptionsUpdateError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/options',
  });
};

/**
 * Update the account owner
 * The current account owner can [change the owner of an account](https://support.zoom.us/hc/en-us/articles/115005686983-Change-Account-Owner) to another user on the same account.<br> Use this API to change the owner of a sub account.
 *
 * **Prerequisites**: <br>
 * * Account owner or admin permissions of an account.
 * * The account making this API request must be on a pro or a hiigher plan with [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) privilege.<br><br>
 *
 * **Scopes:**  `account:write:admin` or `account:master`<br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 *
 *
 * <br>
 */
export const updateAccountOwner = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAccountOwnerData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateAccountOwnerResponse, UpdateAccountOwnerError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/owner',
  });
};

/**
 * Update BYOC settings
 * Only [master account owners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) can use this API to enable BYOC(Bring your own carrier) option for a sub account.<br>
 *
 * **Scope**:<br>
 * * `phone:master` <br>
 *
 * **Prerequisites**: <br>
 * * Business or enterprise Account.<br>
 */
export const updatePhoneSettings = <ThrowOnError extends boolean = false>(
  options: Options<UpdatePhoneSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdatePhoneSettingsResponse, UpdatePhoneSettingsError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/phone/settings',
  });
};

/**
 * Set up a Zoom Phone account
 * After assigning a Zoom phone license to an account, an admin or account owner can proceed with the [initial Zoom phone set up](https://support.zoom.us/hc/en-us/articles/360001297663-Getting-started-with-Zoom-Phone-admin-#h_5ae26a3a-290c-4a8d-b3b0-6384ed267b13) using this API.
 *
 * **Scope**:<br>
 * * `phone:write:admin` `phone:write`
 *
 * **Prerequisites**: <br>
 * * Pro or a higher paid account with master account option enabled.
 *
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const setUpAccount = <ThrowOnError extends boolean = false>(
  options: Options<SetUpAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<SetUpAccountResponse, SetUpAccountError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/phone/setup',
  });
};

/**
 * Assign SIP trunks
 * Using this API, a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) owner can assign SIP trunk(s) to a sub account.<br>
 *
 * **Scope**:<br>
 * * `phone:master` <br>
 *
 * **Prerequisites**:<br>
 * * Business or enterprise Account.<br>
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const postPhoneSipTrunk = <ThrowOnError extends boolean = false>(
  options: Options<PostPhoneSipTrunkData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostPhoneSipTrunkResponse, PostPhoneSipTrunkError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/phone/sip_trunk/trunks',
  });
};

/**
 * Update SIP trunk details
 * Update details of a SIP trunk that is assigned to a sub account.<br>
 *
 * **Scope**:<br>
 * * `phone:master` <br>
 *
 * **Prerequisites**:<br>
 * Business or Enterprise Account.<br>
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const updatePhoneSipTrunk = <ThrowOnError extends boolean = false>(
  options: Options<UpdatePhoneSipTrunkData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdatePhoneSipTrunkResponse, UpdatePhoneSipTrunkError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/phone/sip_trunk/trunks/{sipTrunkId}',
  });
};

/**
 * Get plan Information
 * Get plan information of a sub account that is managed by a master account. <br><br>This API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' billing information. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>
 * **Scopes:** `billing:master`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 *
 */
export const accountPlans = <ThrowOnError extends boolean = false>(
  options: Options<AccountPlansData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AccountPlansResponse, AccountPlansError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/plans',
  });
};

/**
 * Subscribe plans
 * Subscribe a sub account to a Zoom plan using your master account. This API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' subscriptions. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>
 * **Scopes**: `billing:master`<br>
 *
 */
export const accountPlanCreate = <ThrowOnError extends boolean = false>(
  options: Options<AccountPlanCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AccountPlanCreateResponse, AccountPlanCreateError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/plans',
  });
};

/**
 * Subscribe additional plan
 * Subscribe a sub account to a Zoom addon plan. This API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' subscriptions. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>
 * <br>**Prerequisites:**<br>
 * * Pro or a higher plan with master account option enabled.
 * * The sub account must be a paid account. The billing charges for the sub account must be paid by its master account.<br><br>
 *
 * **Scopes**: `billing:master`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 *
 *
 */
export const accountPlanAddonCreate = <ThrowOnError extends boolean = false>(
  options: Options<AccountPlanAddonCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AccountPlanAddonCreateResponse, AccountPlanAddonCreateError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/plans/addons',
  });
};

/**
 * Update an additional plan
 * Update an additional plan for a sub account.
 *
 * This API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' subscriptions. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>
 * <br>**Prerequisites:**<br>
 * * Pro or a higher plan with master account enabled.
 * * The sub account must be a paid account. The billing charges for the sub account must be paid by the master account.<br><br>
 *
 * **Scopes**: `billing:master`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 *
 *
 *
 */
export const accountPlanAddonUpdate = <ThrowOnError extends boolean = false>(
  options: Options<AccountPlanAddonUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<AccountPlanAddonUpdateResponse, AccountPlanAddonUpdateError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/plans/addons',
  });
};

/**
 * Cancel additional plans
 * [Cancel additional plan](https://support.zoom.us/hc/en-us/articles/203634215-How-Do-I-Cancel-My-Subscription-) of a sub account. The cancellation does not provide refund for the current subscription. The service remains active for the current session.
 *
 * This API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' subscriptions. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 *
 * **Prerequisites:**<br>
 * * Pro or a higher plan with master account option enabled.
 * * The sub account must be a paid account.<br>
 * **Scope:** `billing:master`<br>
 *
 */
export const accountPlanAddonCancel = <ThrowOnError extends boolean = false>(
  options: Options<AccountPlanAddonCancelData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<AccountPlanAddonCancelResponse, AccountPlanAddonCancelError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/plans/addons/status',
  });
};

/**
 * Update a base plan
 * Update a base plan of a sub account.
 *
 * This API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' subscriptions. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>
 * **Scopes:** `billing:master`<br><br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * The sub account must have a Pro or a higher plan.
 *
 */
export const accountPlanBaseUpdate = <ThrowOnError extends boolean = false>(
  options: Options<AccountPlanBaseUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<AccountPlanBaseUpdateResponse, AccountPlanBaseUpdateError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/plans/base',
  });
};

/**
 * Cancel a base plan
 * [Cancel a base plan](https://support.zoom.us/hc/en-us/articles/203634215-How-Do-I-Cancel-My-Subscription-) for a sub account.
 *
 * This API can only be used by master accounts that pay all billiing charges of their associated Pro or higher sub accounts. Zoom allows only [approved partners](https://marketplace.zoom.us/docs/api-reference/master-account-apis) to use master APIs and manage sub accounts' subscriptions. Email the partner programs team at **partner-success@zoom.us** for more details.<br><br>
 *
 * **Scopes**: `billing:master`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * The sub account must have a Pro or a higher plan.
 *
 */
export const accountPlanBaseDelete = <ThrowOnError extends boolean = false>(
  options: Options<AccountPlanBaseDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<AccountPlanBaseDeleteResponse, AccountPlanBaseDeleteError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/plans/base/status',
  });
};

/**
 * Get plan usage
 * Get information on usage of [plans](https://marketplace.zoom.us/docs/api-reference/other-references/plans) of an account. This API supports regular accounts as well as master and sub accounts. To get plan usage of a regular account, use the `account:read:admin` scope and provide “me” as the value of the  `accountId` path parameter.To get plan usage of a master account, provide the keyword "me" as the value of the `accountId` path parameter and use the `billing:master` scope. To get plan usage of a sub account, provide the actual account Id of the sub account as the value of the `accountId` path parameter and use the `billing:master` scope.
 *
 * **Prerequisite**:<br>
 * Account type: master account on a paid Pro, Business or Enterprise plan.<br>
 * **Scope:** `billing:master` for master and sub accounts. `account:read:admin` for regular Zoom accounts.<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`
 */
export const getPlanUsage = <ThrowOnError extends boolean = false>(
  options: Options<GetPlanUsageData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPlanUsageResponse, GetPlanUsageError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/plans/usage',
  });
};

/**
 * List recordings of an account
 * List [Cloud Recordings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-Recording) available on an Account.
 *
 * > To access a password protected cloud recording, add an "access_token" parameter to the download URL and provide [JWT](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app) as the value of the "access_token".
 * <br>
 * **Prerequisites**:<br>
 * * A Pro or a higher paid plan with Cloud Recording option enabled.<br>
 * **Scopes**: `recording:read:admin` or `account:read:admin`
 *
 * If the scope `recording:read:admin` is used, the Account ID of the Account must be provided in the `accountId` path parameter to list recordings that belong to the Account. This scope only works for sub accounts.
 *
 * To list recordings of a master account, the scope must be `account:read:admin` and the value of `accountId` should be `me`.<br>  **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 */
export const getAccountCloudRecording = <ThrowOnError extends boolean = false>(
  options: Options<GetAccountCloudRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAccountCloudRecordingResponse, GetAccountCloudRecordingError, ThrowOnError>(
    {
      ...options,
      url: '/accounts/{accountId}/recordings',
    },
  );
};

/**
 * Get settings
 * Get the settings of an account.<br>
 * To get the settings of a master account, use `me` as the value for the `accountId` path parameter.<br><br>
 * **Prerequisites**:
 * * The account must be a paid account.<br>
 * **Scopes**: `account:read:admin`
 * <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const accountSettings = <ThrowOnError extends boolean = false>(
  options: Options<AccountSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AccountSettingsResponse, AccountSettingsError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/settings',
  });
};

/**
 * Update settings
 * Update the settings of a sub account that is under a master account.<br> To update the settings of the master account, use `me` as the value of the `accountId` path parameter.<br><br>
 * **Prerequisites**:
 * * The sub account must be a paid account.<br>
 * **Scopes**: `account:write:admin`
 * <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const accountSettingsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<AccountSettingsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<AccountSettingsUpdateResponse, AccountSettingsUpdateError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/settings',
  });
};

/**
 * Delete virtual background files
 * Delete existing virtual background file(s) from an account.
 *
 * **Prerequisites:**<br>
 * * Virtual background feature must be [enabled](https://support.zoom.us/hc/en-us/articles/210707503-Virtual-Background#h_2ef28080-fce9-4ac2-b567-dc958afab1b7) on the account.
 * <br> **Scope:** `account:write:admin`<br> <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const delVb = <ThrowOnError extends boolean = false>(options: Options<DelVbData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DelVbResponse, DelVbError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/settings/virtual_backgrounds',
  });
};

/**
 * Upload virtual background files
 * Use this API to [upload virtual background files](https://support.zoom.us/hc/en-us/articles/210707503-Virtual-Background#h_01EJF3YFEWGT8YA0ZJ079JEDQE) for all users on the account to use.
 *
 *
 * **Prerequisites:**<br>
 * * Virtual background feature must be [enabled](https://support.zoom.us/hc/en-us/articles/210707503-Virtual-Background#h_2ef28080-fce9-4ac2-b567-dc958afab1b7) on the account.
 * <br> **Scope:** `account:write:admin`<br><br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 */
export const uploadVb = <ThrowOnError extends boolean = false>(options: Options<UploadVbData, ThrowOnError>) => {
  return (options?.client ?? client).post<UploadVbResponse, UploadVbError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/accounts/{accountId}/settings/virtual_backgrounds',
  });
};

/**
 * List internal call-out countries
 * Retrieve the list of internal [call-out](https://support.zoom.us/hc/en-us/articles/200942859-How-To-Use-Telephone-Call-Out-) countries of a master account or a sub account. To list call-out enabled countries of a sub account, provide the account ID of the sub account in the `accountId` path parameter. To list call-out enabled countries of a master account, provide `me` as the value of the `accountId` path parameter.
 * <br><b>Prerequisites:</b><br>
 * * The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) with SIP Connected Audio Plan.<br><br>
 * **Scope:** `sip_trunk:master`
 */
export const listInternalCalloutCountries = <ThrowOnError extends boolean = false>(
  options: Options<ListInternalCalloutCountriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListInternalCalloutCountriesResponse,
    ListInternalCalloutCountriesError,
    ThrowOnError
  >({
    ...options,
    url: '/accounts/{accountId}/sip_trunk/callout_countries',
  });
};

/**
 * Add internal call-out countries
 * Specify the list of [call-out](https://support.zoom.us/hc/en-us/articles/200942859-How-To-Use-Telephone-Call-Out-) countries for a master account or a sub account. To add call-out enabled countries to a sub account, provide the account ID of the sub account in the `accountId` path parameter. To add call-out enabled countries to a master account, provide `me` as the value of the `accountId` path parameter.
 * <br><b>Prerequisites:</b><br>
 * * The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) with SIP Connected Audio Plan.<br><br>
 * **Scope:** `sip_trunk:master`
 */
export const addCalloutCountries = <ThrowOnError extends boolean = false>(
  options: Options<AddCalloutCountriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddCalloutCountriesResponse, AddCalloutCountriesError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/sip_trunk/callout_countries',
  });
};

/**
 * Delete internal call-out country
 * Delete a previously assigned [call-out](https://support.zoom.us/hc/en-us/articles/200942859-How-To-Use-Telephone-Call-Out-) country from a master account or a sub account. To remove call-out country from a sub account, provide the account ID of the sub account in the `accountId` path parameter. To remove call-out country from a master account, provide `me` as the value of the `accountId` path parameter.
 * <br><b>Prerequisites:</b><br>
 * * The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) with SIP Connected Audio Plan.<br><br>
 * **Scope:** `sip_trunk:master`
 */
export const deleteInternalCallOutCountry = <ThrowOnError extends boolean = false>(
  options: Options<DeleteInternalCallOutCountryData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteInternalCallOutCountryResponse,
    DeleteInternalCallOutCountryError,
    ThrowOnError
  >({
    ...options,
    url: '/accounts/{accountId}/sip_trunk/callout_countries/{countryId}',
  });
};

/**
 * List internal numbers
 * This API allows a master account with SIP Connected Audio plan to list internal phone numbers (i.e., numbers that are not provided by Zoom but are owned by the organization consuming the API) assigned to a master account or a sub account.<br><br>To list internal numbers of a sub account, provide the account ID of the sub account in the `accountId` path parameter. To list internal numbers of a  master account, provide `me` as the value of the `accountId` path parameter.
 * <br><b>Prerequisites:</b><br>
 * * The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) with SIP Connected Audio Plan.<br><br>
 * **Scope:** `sip_trunk:master`
 *
 *
 *
 */
export const listInternalNumbers = <ThrowOnError extends boolean = false>(
  options: Options<ListInternalNumbersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListInternalNumbersResponse, ListInternalNumbersError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/sip_trunk/internal_numbers',
  });
};

/**
 * Add internal numbers
 * This API allows a master account with SIP Connected Audio plan to assign internal phone numbers (i.e., numbers that are not provided by Zoom but are owned by the organization consuming the API) to a master account or a sub account.<br><br>To add internal numbers to a sub account, provide the account ID of the sub account in the `accountId` path parameter. To add internal numbers to a master account, provide `me` as the value of the `accountId` path parameter.
 * <br><b>Prerequisites:</b><br>
 * * The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) with SIP Connected Audio Plan.<br><br>
 * **Scope:** `sip_trunk:master`
 *
 *
 */
export const addInternalNumbers = <ThrowOnError extends boolean = false>(
  options: Options<AddInternalNumbersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddInternalNumbersResponse, AddInternalNumbersError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/sip_trunk/internal_numbers',
  });
};

/**
 * Delete an internal number
 * This API allows a master account with SIP Connected Audio plan to delete a previously assigned internal phone number from a master account or a sub account.<br><br>To delete an internal number from a sub account, provide the account ID of the sub account in the `accountId` path parameter. To delete an internal number from a master account, provide `me` as the value of the `accountId` path parameter.
 * <br><b>Prerequisites:</b><br>
 * * The account making this API request must be a [master account](https://marketplace.zoom.us/docs/api-reference/master-account-apis) with SIP Connected Audio Plan.<br><br>
 * **Scope:** `sip_trunk:master`
 *
 *
 *
 */
export const deleteInternalNumber = <ThrowOnError extends boolean = false>(
  options: Options<DeleteInternalNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteInternalNumberResponse, DeleteInternalNumberError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/sip_trunk/internal_numbers/{numberId}',
  });
};

/**
 * Delete all numbers
 * With SIP-connected audio, Zoom establishes a SIP trunk (a network connection specifically designed to make and deliver phone calls) over a direct and private connection between the customer’s network and the Zoom cloud. Meeting participants that dial into a meeting or have the meeting call them, and are On-Net from the perspective of the customers' IP telephony network, will be connected over this trunk rather than over the PSTN. <br><br>Use this API to delete all internal numbers assigned to a sub account.
 * **Prerequisites:**<br>
 *
 * * Pro or a higher account with SIP Connected Audio plan enabled.
 * * The account must be a master account<br>
 * **Scopes:** `sip_trunk:master`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deleteAllSipNumbers = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAllSipNumbersData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAllSipNumbersResponse, DeleteAllSipNumbersError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/sip_trunk/numbers',
  });
};

/**
 * Assign numbers
 * With SIP-connected audio, Zoom establishes a SIP trunk (a network connection specifically designed to make and deliver phone calls) over a direct and private connection between the customer’s network and the Zoom cloud. Meeting participants that dial into a meeting or have the meeting call them, and are On-Net from the perspective of the customers' IP telephony network, will be connected over this trunk rather than over the PSTN. <br><br>Use this API to assign internal numbers to a sub account.
 *
 * **Prerequisites:**<br>
 * * Pro or a higher account with SIP Connected Audio plan enabled.
 * * The account must be a master account<br>
 * **Scopes:** `sip_trunk:master`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 */
export const assignSipTrunkNumbers = <ThrowOnError extends boolean = false>(
  options: Options<AssignSipTrunkNumbersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AssignSipTrunkNumbersResponse, AssignSipTrunkNumbersError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/sip_trunk/numbers',
  });
};

/**
 * Assign SIP trunk configuration
 * With SIP-connected audio, Zoom establishes a SIP trunk (a network connection specifically designed to make and deliver phone calls) over a direct and private connection between the customer’s network and the Zoom cloud. Meeting participants that dial into a meeting or have the meeting call them, and are On-Net from the perspective of the customers' IP telephony network, will be connected over this trunk rather than over the PSTN. <br><br> Using this API, a master account owner can copy the SIP Connected Audio configurations applied on the master account and enable those configurations on a sub account. The owner can also disable the configuration in the sub account where it was previously enabled.
 * **Prerequisites:**<br>
 * * Pro or a higher account with SIP Connected Audio plan enabled.
 * * master account Owner<br>
 * **Scopes:** `sip_trunk:master`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const assignSipConfig = <ThrowOnError extends boolean = false>(
  options: Options<AssignSipConfigData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<AssignSipConfigResponse, AssignSipConfigError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/sip_trunk/settings',
  });
};

/**
 * List SIP trunks
 * With SIP-connected audio, Zoom establishes a SIP trunk (a network connection specifically designed to make and deliver phone calls) over a direct and private connection between the customer’s network and the Zoom cloud. Meeting participants that dial into a meeting or have the meeting call them, and are On-Net from the perspective of the customers’ IP telephony network, will be connected over this trunk rather than over the PSTN.<br><br>
 * Use this API to list all the SIP trunks assigned to a master account or a sub account of the master account. To retrieve SIP trunks assigned to a sub account, provide the account ID of the sub account in the `accountId` path parameter. To retrieve SIP trunks of a master account, provide `me` as the value of the `accountId` path parameter. <br><br> **Scope:** `sip_trunk:read:admin`
 * <br><b>Prerequisites:</b><br>
 * * The account must either be a master account or a sub account with [API Partner Plan](https://zoom.us/plan/api) and SIP Connected Audio Plan.
 */
export const listSipTrunks = <ThrowOnError extends boolean = false>(
  options: Options<ListSipTrunksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListSipTrunksResponse, ListSipTrunksError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/sip_trunk/trunks',
  });
};

/**
 * Assign SIP trunks
 * With SIP-connected audio, Zoom establishes a SIP trunk (a network connection specifically designed to make and deliver phone calls) over a direct and private connection between the customer’s network and the Zoom cloud. Meeting participants that dial into a meeting or have the meeting call them, and are On-Net from the perspective of the customers’ IP telephony network, will be connected over this trunk rather than over the PSTN.<br><br>Use this API to assign SIP trunk(s) that are available on a master account to a sub account. <br><b>Prerequisites:</b><br>
 * * The account making this API request must be a master account with [API Partner Plan](https://zoom.us/plan/api) and SIP Connected Audio Plan.<br><br>
 * **Scope:** `sip_trunk:master`
 */
export const assignSipTrunks = <ThrowOnError extends boolean = false>(
  options: Options<AssignSipTrunksData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AssignSipTrunksResponse, AssignSipTrunksError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/sip_trunk/trunks',
  });
};

/**
 * Delete a SIP trunk
 * Use this API to remove existing SIP trunk of a sub account.<br>
 * <br><b>Prerequisites:</b><br>
 * * The account making this API request must be a master account with [API Partner Plan](https://zoom.us/plan/api) and SIP Connected Audio Plan.<br><br>
 * **Scope:** `sip_trunk:master`
 */
export const deleteSipTrunk = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSipTrunkData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteSipTrunkResponse, DeleteSipTrunkError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/sip_trunk/trunks/{trunkId}',
  });
};

/**
 * Get trusted domains
 * Get trusted domains of a sub account. To get the trusted domains of a master account, use `me` as the value for the `accountId` path parameter.
 *
 * **Prerequisites:**<br>
 * * The sub account must be a paid account.<br>
 * **Scope:** `account:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const accountTrustedDomain = <ThrowOnError extends boolean = false>(
  options: Options<AccountTrustedDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AccountTrustedDomainResponse, AccountTrustedDomainError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/trusted_domains',
  });
};

/**
 * Switch a user's account
 * Disassociate a user from one Account and move the user to another Account under the same master account.
 *
 * With this API, a user under a master account or a sub account can be moved to another sub account within the same master account. To move a user from a master account to a sub account, use `me` as the value for `accountId`. In this scenario, "me" refers to the Account ID of the master account.
 *
 * To move a user from one sub account to another sub account, provide the sub account's Account ID as the value for `accountId`.
 *
 * **Prerequisites**:
 * * The account should have Pro or a higher plan with master account option enabled.
 * * The user whose account needs to be switched should not be an admin or an owner of that account.
 * * The user should not have the same [managed domain](https://support.zoom.us/hc/en-us/articles/203395207-What-is-Managed-Domain-) as the account owner.
 *
 * **Scope:** `user:master`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const switchUserAccount = <ThrowOnError extends boolean = false>(
  options: Options<SwitchUserAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<SwitchUserAccountResponse, SwitchUserAccountError, ThrowOnError>({
    ...options,
    url: '/accounts/{accountId}/users/{userId}/account',
  });
};

/**
 * Download an invoice file
 * Download a [billed](https://support.zoom.us/hc/en-us/articles/201363263-About-Billing) invoice file of a Zoom account in PDF format. To download a regular account's invoice or a  master account's invoice, provide `me` as the value of `accountId` path parameter. To download a sub account's invoice, provide the account ID of the sub account in the `accountId` path parameter.
 *
 *
 * **Prerequisites:**
 * * Account must be enrolled in Pro or a higher plan.<br>
 *
 * **Scope**:`billing:master`<br>
 * **Rate Limit:** You can make **one** request to this API every **thirty** minutes until the daily limit is reached. This API has a daily limit of **100** requests per **account**.
 */
export const downloadInvoicePdf = <ThrowOnError extends boolean = false>(
  options: Options<DownloadInvoicePdfData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DownloadInvoicePdfResponse, DownloadInvoicePdfError, ThrowOnError>({
    ...options,
    url: '/api/download/billing/invoices/{invoiceId}',
  });
};

/**
 * List archived files
 * Zoom’s [archiving solution](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data) allows account administrators to set up an automated mechanism to record, collect and archive meeting data to a 3rd party platform of their choice and hence, satisfy FINRA and/ or other compliance requirements.<br><br>
 * Use this API to retrieve archived meeting or webinar files of an account.
 *
 * **Scope:** `recording:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br><br>
 * **Prerequisites:** <br>
 * * Enable cloud recording.
 * * Follow the [enablement process](https://support.zoom.us/hc/en-us/articles/360050431572-Archiving-Meeting-and-Webinar-data#h_01ENPBD3WR68D7FAKTBY92SG45) to access the archiving feature.
 */
export const listArchivedFiles = <ThrowOnError extends boolean = false>(
  options?: Options<ListArchivedFilesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListArchivedFilesResponse, ListArchivedFilesError, ThrowOnError>({
    ...options,
    url: '/archive_files',
  });
};

/**
 * Delete a channel
 * Zoom chat [channels](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) allow users to communicate via chat in private or public groups. Use this API to delete a specific channel.
 *
 * **Scope:** `chat_channel:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>
 *
 *
 *
 */
export const deleteUserLevelChannel = <ThrowOnError extends boolean = false>(
  options: Options<DeleteUserLevelChannelData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteUserLevelChannelResponse, DeleteUserLevelChannelError, ThrowOnError>({
    ...options,
    url: '/chat/channels/{channelId}',
  });
};

/**
 * Get a channel
 * Zoom chat [channels](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) allow users to communicate via chat in private or public groups. Use this API to get information about a specific channel.
 *
 * **Scope:** `chat_channel:read`	<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>
 *
 *
 *
 */
export const getUserLevelChannel = <ThrowOnError extends boolean = false>(
  options: Options<GetUserLevelChannelData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUserLevelChannelResponse, GetUserLevelChannelError, ThrowOnError>({
    ...options,
    url: '/chat/channels/{channelId}',
  });
};

/**
 * Update a channel
 * Zoom chat channels allow users to communicate via chat in private or public channels. Use this API to update the name of a specific channel that you created.
 *
 * **Scope:** `chat_channel:write`	<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>
 *
 *
 */
export const updateUserLevelChannel = <ThrowOnError extends boolean = false>(
  options: Options<UpdateUserLevelChannelData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateUserLevelChannelResponse, UpdateUserLevelChannelError, ThrowOnError>({
    ...options,
    url: '/chat/channels/{channelId}',
  });
};

/**
 * Leave a channel
 * If you're no longer interested in being a member of an existing channel, you can leave the channel at any time. Use this API to leave a specific channel. After leaving the channel, you can no longer access information from that channel.
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b>This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>
 *
 * **Scope:** `chat_channel:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const leaveChannel = <ThrowOnError extends boolean = false>(
  options: Options<LeaveChannelData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<LeaveChannelResponse, LeaveChannelError, ThrowOnError>({
    ...options,
    url: '/chat/channels/{channelId}/members/me',
  });
};

/**
 * Join a channel
 * A [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) can have one or multiple members. Use this API to join a channel that is open for anyone in the same organization to join. You cannot use this API to join private channels that only allows invited members to be a part of it.
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b>This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>
 *
 * **Scope:** `chat_channel:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const joinChannel = <ThrowOnError extends boolean = false>(options: Options<JoinChannelData, ThrowOnError>) => {
  return (options?.client ?? client).post<JoinChannelResponse, JoinChannelError, ThrowOnError>({
    ...options,
    url: '/chat/channels/{channelId}/members/me',
  });
};

/**
 * Remove a member
 *  A [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) can have one or multiple members. Use this API to remove a member from a chat channel.<br><br>
 * **Scopes:** `chat_channel:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>
 *
 *
 *
 */
export const removeAuserLevelChannelMember = <ThrowOnError extends boolean = false>(
  options: Options<RemoveAuserLevelChannelMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    RemoveAuserLevelChannelMemberResponse,
    RemoveAuserLevelChannelMemberError,
    ThrowOnError
  >({
    ...options,
    url: '/chat/channels/{channelId}/members/{memberId}',
  });
};

/**
 * List user's contacts
 * A user under an organization’s Zoom account has internal users listed under Company Contacts in the Zoom Client. A Zoom user can also add another Zoom user as a [contact](https://support.zoom.us/hc/en-us/articles/115004055706-Managing-Contacts). Call this API to list all the contacts of a Zoom user. Zoom contacts are categorized into "company contacts" and "external contacts". You must specify the contact type in the `type` query parameter. If you do not specify, by default, the type will be set as company contact.
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>
 *
 * **Scope**: `chat_contact:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const getUserContacts = <ThrowOnError extends boolean = false>(
  options?: Options<GetUserContactsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUserContactsResponse, GetUserContactsError, ThrowOnError>({
    ...options,
    url: '/chat/users/me/contacts',
  });
};

/**
 * Get user's contact details
 * A user under an organization’s Zoom account has internal users listed under Company Contacts in the Zoom Client. A Zoom user can also add another Zoom user as a [contact](https://support.zoom.us/hc/en-us/articles/115004055706-Managing-Contacts). Call this API to get information on a specific contact of the Zoom user.
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b>This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>
 *
 * **Scope**: `chat_contact:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const getUserContact = <ThrowOnError extends boolean = false>(
  options: Options<GetUserContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUserContactResponse, GetUserContactError, ThrowOnError>({
    ...options,
    url: '/chat/users/me/contacts/{contactId}',
  });
};

/**
 * List user's channels
 * Zoom chat [channels](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) allow users to communicate via chat in private or public groups. Use this API to list a user's chat channels.
 *
 * **Scope**: `chat_channel:read` or `chat_channel:read:admin`<br>
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API supports both user-managed apps and account-level apps. However, in an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, to list channels of another user in the same Zoom account, the user calling this API must have a <a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit.">role</a> that has <b>View or Edit</b> permission for the Chat channels feature.</p><br>
 *
 *
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 */
export const getChannels = <ThrowOnError extends boolean = false>(options: Options<GetChannelsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetChannelsResponse, GetChannelsError, ThrowOnError>({
    ...options,
    url: '/chat/users/{userId}/channels',
  });
};

/**
 * Create a channel
 * Zoom chat channels allow users to communicate via chat in private or public groups. Use this API to create a channel for a user.<br>
 * **Scopes**:`chat_channel:write` or `chat_channel:write:admin`<br>
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API supports both user-managed apps and account-level apps. However, in an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, to create a channel on behalf of another user in the same Zoom account, the user calling this API must have a <a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit.">role</a> that has <b>Edit</b> permission for the Chat channels feature.</p><br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 *
 */
export const createChannel = <ThrowOnError extends boolean = false>(
  options: Options<CreateChannelData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateChannelResponse, CreateChannelError, ThrowOnError>({
    ...options,
    url: '/chat/users/{userId}/channels',
  });
};

/**
 * Delete a channel
 * Zoom chat [channels](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) allow users to communicate via chat in private or public groups. Use this API to delete a specific channel.
 *
 * **Scope:** `chat_channel:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> This API only supports <b>user-managed</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>.</p><br>
 *
 *
 *
 */
export const deleteChannel = <ThrowOnError extends boolean = false>(
  options: Options<DeleteChannelData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteChannelResponse, DeleteChannelError, ThrowOnError>({
    ...options,
    url: '/chat/users/{userId}/channels/{channelId}',
  });
};

/**
 * Get a channel
 * Zoom chat [channels](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) allow users to communicate via chat in private or public groups. Use this API to get information about a specific channel.
 *
 * **Scope:** `chat_channel:read:admin` <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium` <br>
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b> <a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a>  that has View or Edit permission for Chat Channels</b>.</p>
 *
 *
 *
 */
export const getChannel = <ThrowOnError extends boolean = false>(options: Options<GetChannelData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetChannelResponse, GetChannelError, ThrowOnError>({
    ...options,
    url: '/chat/users/{userId}/channels/{channelId}',
  });
};

/**
 * Update a channel
 * Zoom chat channels allow users to communicate via chat in private or public channels. Use this API to update the name of a specific channel created by a user. <br><br>
 * **Scope:** `chat_channel:write:admin`	<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b> <a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a>  that has Edit permission for Chat Channel</b>.</p>
 *
 */
export const updateChannel = <ThrowOnError extends boolean = false>(
  options: Options<UpdateChannelData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateChannelResponse, UpdateChannelError, ThrowOnError>({
    ...options,
    url: '/chat/users/{userId}/channels/{channelId}',
  });
};

/**
 * List channel members
 * A [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) can have one or multiple members. List all the members of a channel using this API.
 *
 * </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b><a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a> that has View or Edit permission for Chat Channels</b>.</p>
 *
 * **Scopes:** `chat_channel:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listChannelMembers = <ThrowOnError extends boolean = false>(
  options: Options<ListChannelMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListChannelMembersResponse, ListChannelMembersError, ThrowOnError>({
    ...options,
    url: '/chat/users/{userId}/channels/{channelId}/members',
  });
};

/**
 * Invite channel members
 * A [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) can have one or multiple members. Use this API to invite members that are in a user's contact list to a channel. The maximum number of members that can be added at once with this API is 5.
 *
 * **Scope:** `chat_channel:write:admin` <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 * </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b><a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a> that has Edit permission for Chat Channels</b>.</p>
 */
export const inviteChannelMembers = <ThrowOnError extends boolean = false>(
  options: Options<InviteChannelMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<InviteChannelMembersResponse, InviteChannelMembersError, ThrowOnError>({
    ...options,
    url: '/chat/users/{userId}/channels/{channelId}/members',
  });
};

/**
 * Remove a member
 *  A [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) can have one or multiple members. Use this API to remove a member from a chat channel.<br><br>
 *
 * **Scopes:** `chat_channel:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium` <br>
 *
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b><a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a> that has Edit permission for Chat Channels</b>.</p>
 */
export const removeAchannelMember = <ThrowOnError extends boolean = false>(
  options: Options<RemoveAchannelMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RemoveAchannelMemberResponse, RemoveAchannelMemberError, ThrowOnError>({
    ...options,
    url: '/chat/users/{userId}/channels/{channelId}/members/{memberId}',
  });
};

/**
 * List user's chat messages
 * A Zoom user can have conversations with other Zoom users via chat. Use this API to list the current user's chat messages between the user and an individual contact or a chat channel.<br> In the query parameter, you must provide either of the following:<br>
 * * `to_contact`: The email address of the contact with whom the user conversed by sending/receiving messages.
 * * `to_channel`: The channel ID of the channel to/from which the user has sent and/or received messages.
 *
 * <br> **Specify a date** in the `date` query parameter to view messages from that date. If a date is not provided, the default value for the query will be the **current date**.<br>
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit.">role</a> that has <b>View or Edit</b> permission for Chat Messages.</p><br>
 *
 * <br>**Scopes:** `chat_message:read`, `chat_message:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 *
 */
export const getChatMessages = <ThrowOnError extends boolean = false>(
  options: Options<GetChatMessagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetChatMessagesResponse, GetChatMessagesError, ThrowOnError>({
    ...options,
    url: '/chat/users/{userId}/messages',
  });
};

/**
 * Send a chat message
 * Send chat messages on Zoom to either an individual user who is in your contact list or to a [channel](https://support.zoom.us/hc/en-us/articles/200912909-Getting-Started-With-Channels-Group-Messaging-) of which you are a member. To send a message to a contact, provide the contact's email address in the `to_contact` field. Similary, to send a message to a channel, provide the Channel Id of the Channel in `to_channel` field.<br>
 * <br>**Scopes:** `chat_message:write`, `chat_message:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br> <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b><a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a> that has Edit permission for Chat Messages</b>.</p>
 *
 *
 */
export const sendaChatMessage = <ThrowOnError extends boolean = false>(
  options: Options<SendaChatMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<SendaChatMessageResponse, SendaChatMessageError, ThrowOnError>({
    ...options,
    url: '/chat/users/{userId}/messages',
  });
};

/**
 * Delete a message
 * Delete a chat message that you previously sent to a contact or a channel. In the query parameter, you must provide either of the following:<br>
 * * `to_contact`: The email address of the contact to whom you sent the message. Use this parameter to delete a message sent to an individual contact in Zoom.
 * * `to_channel`: The channel ID of the channel where you sent the message. Use this parameter to delete a message sent to a channel in Zoom.
 *
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b><a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a> that has Edit permission for Chat Messages</b>.</p>
 *
 * **Scope:** `chat_message:write`, `chat_message:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const deleteChatMessage = <ThrowOnError extends boolean = false>(
  options: Options<DeleteChatMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteChatMessageResponse, DeleteChatMessageError, ThrowOnError>({
    ...options,
    url: '/chat/users/{userId}/messages/{messageId}',
  });
};

/**
 * Update a message
 * Each chat message has a unique identifier. Use this API to edit a chat message that you previously sent to either a contact or a channel in Zoom by providing the ID of the message as the value of the `messageId` parameter. The ID can be retrieved from List User's Chat Messages API. Additionally, as a query parameter, you must provide either the **email address** of the contact or the **Channel ID** of the channel where the message was sent.
 *
 * **Scope:** `chat_message:write`,`chat_message:write:admin`	<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 * </b> For an<b> account-level</b> <a href="https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-oauth-app">OAuth app</a>, this API can only be used on behalf of a user who is assigned with a <b><a href="https://support.zoom.us/hc/en-us/articles/115001078646-Using-role-management#:~:text=Each%20user%20in%20a%20Zoom,owner%2C%20administrator%2C%20or%20member.&text=Role%2Dbased%20access%20control%20enables,needs%20to%20view%20or%20edit."> role</a> that has Edit permission for Chat Messages</b>.</p>
 * **Scope:** `chat_message:write`, `chat_message:write:admin`<br>
 *
 *
 *
 *
 *
 *
 *
 */
export const editMessage = <ThrowOnError extends boolean = false>(options: Options<EditMessageData, ThrowOnError>) => {
  return (options?.client ?? client).put<EditMessageResponse, EditMessageError, ThrowOnError>({
    ...options,
    url: '/chat/users/{userId}/messages/{messageId}',
  });
};

/**
 * Search company contacts
 * A user under an organization's Zoom account has internal users listed under Company Contacts in the Zoom Client. Use this API to search users that are in the company contacts of a Zoom account. Using the `search_key` query parameter, provide either first name, last name or the email address of the user that you would like to search for. Optionally, set `query_presence_status` to `true` in order to include the presence status of a contact. <br><br>
 *
 * **Scopes:** `contact:read:admin`, `contact:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const searchCompanyContacts = <ThrowOnError extends boolean = false>(
  options: Options<SearchCompanyContactsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SearchCompanyContactsResponse, SearchCompanyContactsError, ThrowOnError>({
    ...options,
    url: '/contacts',
  });
};

/**
 * List groups
 * List [groups](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) under an account.
 *
 * **Prerequisite**: Pro or higher account.<br>
 * **Scopes**: `group:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const groups = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GroupsResponse, GroupsError, ThrowOnError>({
    ...options,
    url: '/groups',
  });
};

/**
 * Create a group
 * Create a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) under an account.
 *
 * You can add a maximum of 100 groups in one account per day. If you go over, you will get an error. You can add a maximum of 5000 groups in one account.
 *
 * **Prerequisite**: Pro or higher account.<br>
 * **Scopes**: `group:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const groupCreate = <ThrowOnError extends boolean = false>(options: Options<GroupCreateData, ThrowOnError>) => {
  return (options?.client ?? client).post<GroupCreateResponse, GroupCreateError, ThrowOnError>({
    ...options,
    url: '/groups',
  });
};

/**
 * Delete a group
 * Delete a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-).
 *
 * **Prerequisite**: Pro, Business, or Education account<br>
 * **Scopes**: `group:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const groupDelete = <ThrowOnError extends boolean = false>(options: Options<GroupDeleteData, ThrowOnError>) => {
  return (options?.client ?? client).delete<GroupDeleteResponse, GroupDeleteError, ThrowOnError>({
    ...options,
    url: '/groups/{groupId}',
  });
};

/**
 * Get a group
 * Get a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) under an account.
 *
 * **Prerequisite**: Pro, Business, or Education account<br>
 * **Scopes**: `group:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const group = <ThrowOnError extends boolean = false>(options: Options<GroupData, ThrowOnError>) => {
  return (options?.client ?? client).get<GroupResponse, GroupError, ThrowOnError>({
    ...options,
    url: '/groups/{groupId}',
  });
};

/**
 * Update a group
 * Update a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) under your account.
 *
 * **Prerequisite**: Pro, Business, or Education account<br>
 * **Scopes**: `group:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const groupUpdate = <ThrowOnError extends boolean = false>(options: Options<GroupUpdateData, ThrowOnError>) => {
  return (options?.client ?? client).patch<GroupUpdateResponse, GroupUpdateError, ThrowOnError>({
    ...options,
    url: '/groups/{groupId}',
  });
};

/**
 * Get locked settings
 * Retrieve a [group's](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) locked settings. If you lock a setting, the group members will not be able to modify it individually. <p style="background-color:#FEEFB3; color:#9F6000"><br>Note:</b> The `force_pmi_jbh_password` field under meeting settings is planned to be deprecated on September 22, 2019. This field will be replaced by another field that will provide the same functionality.</p>
 *
 * **Prerequisite**: Pro, Business, or Education account<br>
 * **Scopes**: `group:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const getGroupLockSettings = <ThrowOnError extends boolean = false>(
  options: Options<GetGroupLockSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGroupLockSettingsResponse, GetGroupLockSettingsError, ThrowOnError>({
    ...options,
    url: '/groups/{groupId}/lock_settings',
  });
};

/**
 * Update locked settings
 * Update a [group's](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) locked settings. If you lock a setting, the group members will not be able to modify it individually. <p style="background-color:#FEEFB3; color:#9F6000"><br>Note:</b> The `force_pmi_jbh_password` field under meeting settings is planned to be deprecated on September 22, 2019. This field will be replaced by another field that will provide the same functionality.</p>
 *
 * **Prerequisite**: Pro, Business, or Education account<br>
 * **Scopes**: `group:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const groupLockedSettings = <ThrowOnError extends boolean = false>(
  options: Options<GroupLockedSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<GroupLockedSettingsResponse, GroupLockedSettingsError, ThrowOnError>({
    ...options,
    url: '/groups/{groupId}/lock_settings',
  });
};

/**
 * List group members
 * List the members of a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) under your account.
 *
 * **Prerequisite**: Pro, Business, or Education account<br>
 * **Scopes**: `group:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const groupMembers = <ThrowOnError extends boolean = false>(
  options: Options<GroupMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GroupMembersResponse, GroupMembersError, ThrowOnError>({
    ...options,
    url: '/groups/{groupId}/members',
  });
};

/**
 * Add group members
 * Add members to a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) under your account.
 *
 * **Prerequisite**: Pro, Business, or Education account<br>
 * **Scopes**: `group:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const groupMembersCreate = <ThrowOnError extends boolean = false>(
  options: Options<GroupMembersCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<GroupMembersCreateResponse, GroupMembersCreateError, ThrowOnError>({
    ...options,
    url: '/groups/{groupId}/members',
  });
};

/**
 * Delete a group member
 * Delete a member from a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-) in a Zoom account.
 *
 * **Prerequisite**: Pro, Business, or Education account<br>
 * **Scopes**: `group:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const groupMembersDelete = <ThrowOnError extends boolean = false>(
  options: Options<GroupMembersDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<GroupMembersDeleteResponse, GroupMembersDeleteError, ThrowOnError>({
    ...options,
    url: '/groups/{groupId}/members/{memberId}',
  });
};

/**
 * Update a group member
 * If a user is a member in multiple groups, you can [set a primary group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-#h_d07c7dcd-4fd8-485a-b5fe-a322e8d21c09) for the user. The group member will use the primary group's settings by default. However, if settings are locked in other groups, those settings will continue to be locked for that user. By default, the primary group is the first group that user is added to.<br><br>
 * Use this API to perform either of the following tasks:
 * * Simultaneously remove a member from one group and move the member to a different group.
 * * Set a primary group for the user<br><br>
 * **Prerequisites:**
 * * Pro or higher account<br> **Scopes:** `group:write:admin`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const updateAgroupMember = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAgroupMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateAgroupMemberResponse, UpdateAgroupMemberError, ThrowOnError>({
    ...options,
    url: '/groups/{groupId}/members/{memberId}',
  });
};

/**
 * Get a group's settings
 * Get settings for a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-).
 * **Prerequisite**: Pro, Business, or Education account<br>
 * **Scopes**: `group:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const getGroupSettings = <ThrowOnError extends boolean = false>(
  options: Options<GetGroupSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGroupSettingsResponse, GetGroupSettingsError, ThrowOnError>({
    ...options,
    url: '/groups/{groupId}/settings',
  });
};

/**
 * Update a group's settings
 * Update settings for a [group](https://support.zoom.us/hc/en-us/articles/204519819-Group-Management-).<p style="background-color:#FEEFB3; color:#9F6000"><br>Note:</b> The `force_pmi_jbh_password` field under meeting settings is planned to be deprecated on September 22, 2019. This field will be replaced by another field that will provide the same functionality.</p>
 * **Prerequisite**: Pro, Business, or Education account<br>
 * **Scopes**: `group:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const updateGroupSettings = <ThrowOnError extends boolean = false>(
  options: Options<UpdateGroupSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateGroupSettingsResponse, UpdateGroupSettingsError, ThrowOnError>({
    ...options,
    url: '/groups/{groupId}/settings',
  });
};

/**
 * Delete virtual background files
 * Delete existing virtual background file(s) from an account.
 *
 * **Prerequisites:**<br>
 * * Virtual background feature must be [enabled](https://support.zoom.us/hc/en-us/articles/210707503-Virtual-Background#h_2ef28080-fce9-4ac2-b567-dc958afab1b7) on the account.
 * <br> **Scope:** `group:write:admin`<br><br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const delGroupVb = <ThrowOnError extends boolean = false>(options: Options<DelGroupVbData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DelGroupVbResponse, DelGroupVbError, ThrowOnError>({
    ...options,
    url: '/groups/{groupId}/settings/virtual_backgrounds',
  });
};

/**
 * Upload virtual background files
 * Use this API to [upload virtual background files](https://support.zoom.us/hc/en-us/articles/210707503-Virtual-Background#h_01EJF3YFEWGT8YA0ZJ079JEDQE) for all users in a group to use.
 *
 *
 * **Prerequisites:**<br>
 * * Virtual background feature must be [enabled](https://support.zoom.us/hc/en-us/articles/210707503-Virtual-Background#h_2ef28080-fce9-4ac2-b567-dc958afab1b7) on the account.
 * <br> **Scope:** `group:write:admin`<br><br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 * `
 */
export const uploadGroupVb = <ThrowOnError extends boolean = false>(
  options: Options<UploadGroupVbData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UploadGroupVbResponse, UploadGroupVbError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/groups/{groupId}/settings/virtual_backgrounds',
  });
};

/**
 * List H.323/SIP devices
 * A H.323 or SIP device can make a video call to a [Room Connector](https://support.zoom.us/hc/en-us/articles/201363273-Getting-Started-With-H-323-SIP-Room-Connector) to join a Zoom cloud meeting. A Room Connector can also call out to a H.323 or SIP device to join a Zoom cloud meeting. Use this API to list all H.323/SIP Devices on a Zoom account.<br><br>
 * **Scopes:** `h323:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 */
export const deviceList = <ThrowOnError extends boolean = false>(options?: Options<DeviceListData, ThrowOnError>) => {
  return (options?.client ?? client).get<DeviceListResponse, DeviceListError, ThrowOnError>({
    ...options,
    url: '/h323/devices',
  });
};

/**
 * Create a H.323/SIP device
 * A H.323 or SIP device can make a video call to a [Room Connector](https://support.zoom.us/hc/en-us/articles/201363273-Getting-Started-With-H-323-SIP-Room-Connector) to join a Zoom cloud meeting. A Room Connector can also call out to a H.323 or SIP device to join a Zoom cloud meeting. Use this API to add a H.323/SIP device to your Zoom account<br><br>
 * **Scopes:** `h323:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light` <br>
 */
export const deviceCreate = <ThrowOnError extends boolean = false>(
  options: Options<DeviceCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DeviceCreateResponse, DeviceCreateError, ThrowOnError>({
    ...options,
    url: '/h323/devices',
  });
};

/**
 * Delete a H.323/SIP device
 * A H.323 or SIP device can make a video call to a [Room Connector](https://support.zoom.us/hc/en-us/articles/201363273-Getting-Started-With-H-323-SIP-Room-Connector) to join a Zoom cloud meeting. A Room Connector can also call out to a H.323 or SIP device to join a Zoom cloud meeting. Use this API to delete a H.323/SIP device from your Zoom account.<br><br>
 * **Scopes:** `h323:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 */
export const deviceDelete = <ThrowOnError extends boolean = false>(
  options: Options<DeviceDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeviceDeleteResponse, DeviceDeleteError, ThrowOnError>({
    ...options,
    url: '/h323/devices/{deviceId}',
  });
};

/**
 * Update a H.323/SIP device
 * A H.323 or SIP device can make a video call to a [Room Connector](https://support.zoom.us/hc/en-us/articles/201363273-Getting-Started-With-H-323-SIP-Room-Connector) to join a Zoom cloud meeting. A Room Connector can also call out to a H.323 or SIP device to join a Zoom cloud meeting. Use this API to edit information of a H.323/SIP device from your Zoom account.<br><br>
 * **Scopes:** `h323:write:admin`<br>
 * <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deviceUpdate = <ThrowOnError extends boolean = false>(
  options: Options<DeviceUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<DeviceUpdateResponse, DeviceUpdateError, ThrowOnError>({
    ...options,
    url: '/h323/devices/{deviceId}',
  });
};

/**
 * Send chatbot messages
 * Send chatbot messages from your marketplace chatbot app.<br><br>
 * **Scopes:** `imchat:bot`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 * **Authorization Flow**: Client Credentials Flow<br><br>
 * To get authorized, make a POST request to `/oauth/token` endpoint with grant type as `client_credentials`. <br>Use `https://api.zoom.us/oauth/token?grant_type=client_credentials` as the endpoint for the request.
 * You will need to send your ClientID and Secret as a Basic base64 encoded AUthorization header. Ex. `Basic base64Encode({client_id}:{client_sceret})`<br><br> Next, use the token recieved (access_token) as a bearer token while making the POST /im/chat/messages request to send chatbot messages.<br><br>
 * Learn more about how to authorize chatbots in the [Chatbot Authorization](https://marketplace.zoom.us/docs/guides/chatbots/authorization) guide.
 */
export const sendchatbot = <ThrowOnError extends boolean = false>(options?: Options<SendchatbotData, ThrowOnError>) => {
  return (options?.client ?? client).post<SendchatbotResponse, SendchatbotError, ThrowOnError>({
    ...options,
    url: '/im/chat/messages',
  });
};

/**
 * Delete a chatbot message
 * Delete a message that was sent by your chatbot app.<br><br> **Scopes:** `imchat:bot`<br> **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>**Authorization Flow**: Client Credentials Flow<br><br>To get authorized, make a POST request to `/oauth/token` endpoint with grant type as `client_credentials`. <br>Use `https://api.zoom.us/oauth/token?grant_type=client_credentials` as the endpoint for the request.
 * You will need to send your ClientID and Secret as a Basic base64 encoded AUthorization header. Ex. `Basic base64Encode({client_id}:{client_sceret})`<br><br> Next, use the token received (access_token) as a bearer token while making the DELETE /im/chat/messages/{message_id} request to delete a message.<br><br>
 * Learn more about how to authotize chatbots in the [Chatbot Authorization](https://marketplace.zoom.us/docs/guides/chatbots/authorization) guide.
 */
export const deleteAchatbotMessage = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAchatbotMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAchatbotMessageResponse, DeleteAchatbotMessageError, ThrowOnError>({
    ...options,
    url: '/im/chat/messages/{message_id}',
  });
};

/**
 * Edit a chatbot message
 * Edit a message that was [sent](https://marketplace.zoom.us/docs/api-reference/zoom-api/im-chat/sendchatbot) by your Chatbot app.<br> After sending a message using the Send Chatbot Message API, you must store the messageId returned in the response so that you can make edits to the associated message using this API.
 *
 * **Scope:** `imchat:bot`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 * **Authorization Flow**: Client Credentials Flow<br><br>
 * To get authorized, make a POST request to `/oauth/token` endpoint with grant type as `client_credentials`. <br>Use `https://api.zoom.us/oauth/token?grant_type=client_credentials` as the endpoint for the request.
 * You will need to send your ClientID and Secret as a Basic base64 encoded AUthorization header. Ex. `Basic base64Encode({client_id}:{client_sceret})`<br><br> Next, use the token received (access_token) as a bearer token while making the PUT /im/chat/messages/{message_id} request to edit a chatbot message.<br><br>
 * Learn more about how to authotize chatbots in the [Chatbot Authorization](https://marketplace.zoom.us/docs/guides/chatbots/authorization) guide.
 */
export const editChatbotMessage = <ThrowOnError extends boolean = false>(
  options: Options<EditChatbotMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<EditChatbotMessageResponse, EditChatbotMessageError, ThrowOnError>({
    ...options,
    url: '/im/chat/messages/{message_id}',
  });
};

/**
 * @deprecated
 * Get IM chat sessions
 * Retrieve IM Chat sessions for a specified period of time. <aside>Note: This API only supports Oauth2.</aside><br>
 *
 * **Scopes:** `imchat:read, imchat:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`
 *
 * Please see our [announcements page related to this deprecation](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#im-api-notice).
 */
export const imChatSessions = <ThrowOnError extends boolean = false>(
  options: Options<ImChatSessionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ImChatSessionsResponse, ImChatSessionsError, ThrowOnError>({
    ...options,
    url: '/im/chat/sessions',
  });
};

/**
 * @deprecated
 * Get IM chat messages
 * Retrieve IM chat messages for a specified period of time. <aside>Note: This API only supports oauth2.</aside><br><br>
 *
 * **Scopes:** `imchat:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 * Please see our [announcements page related to this deprecation](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#im-api-notice).
 *
 *
 *
 */
export const imChatMessages = <ThrowOnError extends boolean = false>(
  options: Options<ImChatMessagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ImChatMessagesResponse, ImChatMessagesError, ThrowOnError>({
    ...options,
    url: '/im/chat/sessions/{sessionId}',
  });
};

/**
 * List IM directory groups
 * List [IM directory groups](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management).<br><br>
 * **Scopes**: `imgroup:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const imGroups = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<ImGroupsResponse, ImGroupsError, ThrowOnError>({
    ...options,
    url: '/im/groups',
  });
};

/**
 * Create an IM directory group
 * Create an [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management) under your account.<br><br>
 * **Scopes**: `imgroup:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const imGroupCreate = <ThrowOnError extends boolean = false>(
  options: Options<ImGroupCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ImGroupCreateResponse, ImGroupCreateError, ThrowOnError>({
    ...options,
    url: '/im/groups',
  });
};

/**
 * Delete an IM directory group
 * Delete an [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management) under your account.<br><br>
 * Scopes: `imgroup:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const imGroupDelete = <ThrowOnError extends boolean = false>(
  options: Options<ImGroupDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<ImGroupDeleteResponse, ImGroupDeleteError, ThrowOnError>({
    ...options,
    url: '/im/groups/{groupId}',
  });
};

/**
 * Retrieve an IM directory group
 * Retrieve an [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management) under your account.<br><br>
 * Scopes: `imgroup:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const imGroup = <ThrowOnError extends boolean = false>(options: Options<ImGroupData, ThrowOnError>) => {
  return (options?.client ?? client).get<ImGroupResponse, ImGroupError, ThrowOnError>({
    ...options,
    url: '/im/groups/{groupId}',
  });
};

/**
 * Update an IM directory group
 * Update an [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management) under your account.<br><br>
 * **Scopes**: `imgroup:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const imGroupUpdate = <ThrowOnError extends boolean = false>(
  options: Options<ImGroupUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<ImGroupUpdateResponse, ImGroupUpdateError, ThrowOnError>({
    ...options,
    url: '/im/groups/{groupId}',
  });
};

/**
 * List IM directory group members
 * List the members of an [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management).<br><br>
 * **Scope:** `imgroup:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const imGroupMembers = <ThrowOnError extends boolean = false>(
  options: Options<ImGroupMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ImGroupMembersResponse, ImGroupMembersError, ThrowOnError>({
    ...options,
    url: '/im/groups/{groupId}/members',
  });
};

/**
 * Add IM directory group members
 * Add members to an [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management) under an account.<br><br>
 * **Scope:** `imgroup:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const imGroupMembersCreate = <ThrowOnError extends boolean = false>(
  options: Options<ImGroupMembersCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ImGroupMembersCreateResponse, ImGroupMembersCreateError, ThrowOnError>({
    ...options,
    url: '/im/groups/{groupId}/members',
  });
};

/**
 * Delete an IM directory group member
 * Delete a member from an [IM directory group](https://support.zoom.us/hc/en-us/articles/203749815-IM-Management) under an account.<br><br>
 * Scopes: `imgroup:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const imGroupMembersDelete = <ThrowOnError extends boolean = false>(
  options: Options<ImGroupMembersDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<ImGroupMembersDeleteResponse, ImGroupMembersDeleteError, ThrowOnError>({
    ...options,
    url: '/im/groups/{groupId}/members/{memberId}',
  });
};

/**
 * @deprecated
 * Send IM messages
 * Send chat message to a user. <aside>Note: This API only supports OAuth 2.0.</aside><br><br>**Scope:** `imchat:write`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const sendimmessages = <ThrowOnError extends boolean = false>(
  options?: Options<SendimmessagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<SendimmessagesResponse, SendimmessagesError, ThrowOnError>({
    ...options,
    url: '/im/users/me/chat/messages',
  });
};

/**
 * @deprecated
 * Get user’s IM messages
 * Get IM Chat messages for a specified period of time. <aside>Note: This API only supports Oauth2.</aside><br><br>
 * **Scopes:** `imchat:read`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 * Please see the [announcements page related to this deprecation.](https://marketplace.zoom.us/docs/guides/stay-up-to-date/announcements#im-api-notice)
 */
export const listimmessages = <ThrowOnError extends boolean = false>(
  options: Options<ListimmessagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListimmessagesResponse, ListimmessagesError, ThrowOnError>({
    ...options,
    url: '/im/users/{userId}/chat/messages',
  });
};

/**
 * Use in-Meeting recording controls
 * Use this API to control the [in-meeting](https://support.zoom.us/hc/en-us/articles/360021921032-In-Meeting-Controls) **recording features** such as starting a recording, stopping a recording, pausing a recording, and resuming a recording. This API only works for Cloud Recordings and not for local recordings.
 *
 *
 * **Prerequisite:**
 * * The meeting must be a live meeting.
 * * Cloud Recording must be enabled.
 * * The user using this API must either be the host or alternative host of the meeting.
 *
 * **Scopes:** `meeting:write`, `meeting:write:admin`, `meeting:master`
 */
export const inMeetingRecordingControl = <ThrowOnError extends boolean = false>(
  options: Options<InMeetingRecordingControlData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    InMeetingRecordingControlResponse,
    InMeetingRecordingControlError,
    ThrowOnError
  >({
    ...options,
    url: '/live_meetings/{meetingId}/events',
  });
};

/**
 * Delete a meeting
 * Delete a meeting.<br><br>
 * **Scopes:** `meeting:write:admin` `meeting:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const meetingDelete = <ThrowOnError extends boolean = false>(
  options: Options<MeetingDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<MeetingDeleteResponse, MeetingDeleteError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}',
  });
};

/**
 * Get a meeting
 * Retrieve the details of a meeting.<br><br>
 * **Scopes:** `meeting:read:admin` `meeting:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const meeting = <ThrowOnError extends boolean = false>(options: Options<MeetingData, ThrowOnError>) => {
  return (options?.client ?? client).get<MeetingResponse, MeetingError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}',
  });
};

/**
 * Update a meeting
 * Update the details of a meeting.<br>This API has a rate limit of 100 requests per day. Therefore, a meeting can only be updated for a maximum of 100 times within a 24 hour window.<br>
 * **Scopes:** `meeting:write:admin` `meeting:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const meetingUpdate = <ThrowOnError extends boolean = false>(
  options: Options<MeetingUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<MeetingUpdateResponse, MeetingUpdateError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}',
  });
};

/**
 * Perform batch poll creation
 * Polls allow the meeting host to survey attendees. Use this API to create batch [polls](https://support.zoom.us/hc/en-us/articles/213756303-Polling-for-Meetings) for a meeting.<br><br>
 *
 * **Scopes**: `meeting:write:admin` `meeting:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites**:<br>
 * * Host user type must be **Pro** or higher plan.
 * * Polling feature must be enabled in the host's account.
 * * Meeting must be a scheduled meeting. Instant meetings do not have polling features enabled.
 */
export const createBatchPolls = <ThrowOnError extends boolean = false>(
  options: Options<CreateBatchPollsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateBatchPollsResponse, CreateBatchPollsError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/batch_polls',
  });
};

/**
 * Get meeting invitation
 * Retrieve the meeting invite note that was sent for a specific meeting.<br><br>
 * **Scopes:** `meeting:read:admin` `meeting:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const meetingInvitation = <ThrowOnError extends boolean = false>(
  options: Options<MeetingInvitationData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<MeetingInvitationResponse, MeetingInvitationError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/invitation',
  });
};

/**
 * Get live stream details
 * Zoom allows users to [live stream a meeting](https://support.zoom.us/hc/en-us/articles/115001777826-Live-Streaming-Meetings-or-Webinars-Using-a-Custom-Service) to a custom platform. Use this API to get a meeting's live stream configuration details such as Stream URL, Stream Key and Page URL.<br><br>
 * **Prerequisites:**<br>
 * * Meeting host must be a licensed user with a Pro or higher plan.<br>
 * * Live streaming details must have been [configured](https://support.zoom.us/hc/en-us/articles/115001777826-Live-Streaming-Meetings-or-Webinars-Using-a-Custom-Service#h_01589a6f-a40a-4e18-a448-cb746e52ebc5) for the meeting.<br><br>
 * **Scopes:** `meeting:read:admin` `meeting:read`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 *
 *
 */
export const getLiveStreamDetails = <ThrowOnError extends boolean = false>(
  options: Options<GetLiveStreamDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetLiveStreamDetailsResponse, GetLiveStreamDetailsError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/livestream',
  });
};

/**
 * Update a live stream
 * Zoom allows users to [live stream a meeting](https://support.zoom.us/hc/en-us/articles/115001777826-Live-Streaming-Meetings-or-Webinars-Using-a-Custom-Service) to a custom platform. Use this API to update a meeting's live stream information.<br><br>
 * **Prerequisites:**<br>
 * * Meeting host must have a Pro license.<br>
 * **Scopes:** `meeting:write:admin` `meeting:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 *
 */
export const meetingLiveStreamUpdate = <ThrowOnError extends boolean = false>(
  options: Options<MeetingLiveStreamUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<MeetingLiveStreamUpdateResponse, MeetingLiveStreamUpdateError, ThrowOnError>(
    {
      ...options,
      url: '/meetings/{meetingId}/livestream',
    },
  );
};

/**
 * Update Live Stream Status
 * Zoom allows users to [live stream a meeting](https://support.zoom.us/hc/en-us/articles/115001777826-Live-Streaming-Meetings-or-Webinars-Using-a-Custom-Service) to a custom platform. Use this API to update the status of a meeting's live stream.<br><br>
 * **Prerequisites:**<br>
 * * Meeting host must have a Pro license.<br>
 * **Scopes:** `meeting:write:admin` `meeting:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const meetingLiveStreamStatusUpdate = <ThrowOnError extends boolean = false>(
  options: Options<MeetingLiveStreamStatusUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    MeetingLiveStreamStatusUpdateResponse,
    MeetingLiveStreamStatusUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/meetings/{meetingId}/livestream/status',
  });
};

/**
 * List meeting polls
 * Polls allow the meeting host to survey attendees. Use this API to list [polls](https://support.zoom.us/hc/en-us/articles/213756303-Polling-for-Meetings) of a meeting.<br><br>
 *
 * **Scopes**: `meeting:read:admin` `meeting:read`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites**:<br>
 * * Host user type must be **Pro** or higher plan.
 * * Meeting must be a scheduled meeting. Instant meetings do not have polling features enabled.
 */
export const meetingPolls = <ThrowOnError extends boolean = false>(
  options: Options<MeetingPollsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<MeetingPollsResponse, MeetingPollsError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/polls',
  });
};

/**
 * Create a meeting poll
 * Polls allow the meeting host to survey attendees. Use this API to create a [poll](https://support.zoom.us/hc/en-us/articles/213756303-Polling-for-Meetings) for a meeting.<br><br>
 *
 * **Scopes**: `meeting:write:admin` `meeting:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites**:<br>
 * * Host user type must be **Pro** or higher plan.
 * * Polling feature must be enabled in the host's account.
 * * Meeting must be a scheduled meeting. Instant meetings do not have polling features enabled.
 */
export const meetingPollCreate = <ThrowOnError extends boolean = false>(
  options: Options<MeetingPollCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<MeetingPollCreateResponse, MeetingPollCreateError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/polls',
  });
};

/**
 * Delete a meeting poll
 * Polls allow the meeting host to survey attendees. Use this API to delete a meeting [poll](https://support.zoom.us/hc/en-us/articles/213756303-Polling-for-Meetings).<br>
 * **Scopes**: `meeting:write:admin` `meeting:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light` <br>
 * **Prerequisites**:<br>
 * * Host user type must be **Pro**.
 * * Polling feature should be enabled in the host's account.
 * * Meeting must be a scheduled meeting. Instant meetings do not have polling features enabled.
 */
export const meetingPollDelete = <ThrowOnError extends boolean = false>(
  options: Options<MeetingPollDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<MeetingPollDeleteResponse, MeetingPollDeleteError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/polls/{pollId}',
  });
};

/**
 * Get a meeting poll
 * Polls allow the meeting host to survey attendees. Use this API to get information about a specific meeting [poll](https://support.zoom.us/hc/en-us/articles/213756303-Polling-for-Meetings).<br><br>
 * **Scopes**: `meeting:read:admin` `meeting:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 *
 */
export const meetingPollGet = <ThrowOnError extends boolean = false>(
  options: Options<MeetingPollGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<MeetingPollGetResponse, MeetingPollGetError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/polls/{pollId}',
  });
};

/**
 * Update a meeting poll
 * Polls allow the meeting host to survey attendees. Use this API to update information of a specific meeting [poll](https://support.zoom.us/hc/en-us/articles/213756303-Polling-for-Meetings)<br><br>
 * **Scopes**: `meeting:write:admin` `meeting:write`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const meetingPollUpdate = <ThrowOnError extends boolean = false>(
  options: Options<MeetingPollUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<MeetingPollUpdateResponse, MeetingPollUpdateError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/polls/{pollId}',
  });
};

/**
 * Delete meeting recordings
 * Delete all recording files of a meeting.<br><br>
 *
 * **Scopes:** `recording:write:admin` `recording:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites**:
 * * Cloud Recording should be enabled on the user's account.<br>
 *
 */
export const recordingDelete = <ThrowOnError extends boolean = false>(
  options: Options<RecordingDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RecordingDeleteResponse, RecordingDeleteError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/recordings',
  });
};

/**
 * Get meeting recordings
 * Get all the [recordings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-Recording#h_7420acb5-1897-4061-87b4-5b76e99c03b4) from a meeting or Webinar instance.<br><br> The recording files can be downloaded via the `download_url` property listed in the response.
 *
 * > To access a password protected cloud recording, add an "access_token" parameter to the download URL and provide OAuth access token or [JWT](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app) as the value of the "access_token".
 * <br>
 *
 * **Scopes:** `recording:read:admin` `recording:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const recordingGet = <ThrowOnError extends boolean = false>(
  options: Options<RecordingGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RecordingGetResponse, RecordingGetError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/recordings',
  });
};

/**
 * List recording registrants
 * Cloud Recordings of past Zoom Meetings can be made [on-demand](https://support.zoom.us/hc/en-us/articles/360000488283-On-demand-Recordings). Users should be [registered](https://marketplace.zoom.us/docs/api-reference/zoom-api/cloud-recording/meetingrecordingregistrantcreate) to view these recordings.
 *
 * Use this API to list registrants of **On-demand Cloud Recordings** of a past meeting.<br>
 * **Scopes:** `recording:read:admin`, `recording:read`.<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 */
export const meetingRecordingRegistrants = <ThrowOnError extends boolean = false>(
  options: Options<MeetingRecordingRegistrantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    MeetingRecordingRegistrantsResponse,
    MeetingRecordingRegistrantsError,
    ThrowOnError
  >({
    ...options,
    url: '/meetings/{meetingId}/recordings/registrants',
  });
};

/**
 * Create a recording registrant
 * Cloud Recordings of past Zoom Meetings can be made [on-demand](https://support.zoom.us/hc/en-us/articles/360000488283-On-demand-Recordings). Users should be [registered](https://marketplace.zoom.us/docs/api-reference/zoom-api/cloud-recording/meetingrecordingregistrantcreate) to view these recordings.
 *
 * Use this API to register a user to gain access to **On-demand Cloud Recordings** of a past meeting.<br>
 * **Scopes:** `recording:write:admin`, `recording:write`.<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const meetingRecordingRegistrantCreate = <ThrowOnError extends boolean = false>(
  options: Options<MeetingRecordingRegistrantCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    MeetingRecordingRegistrantCreateResponse,
    MeetingRecordingRegistrantCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/meetings/{meetingId}/recordings/registrants',
  });
};

/**
 * Get registration questions
 * For [on-demand](https://support.zoom.us/hc/en-us/articles/360000488283-On-demand-Recordings) meeting recordings, you can include fields with questions that will be shown to registrants when they register to view the recording.
 *
 * Use this API to retrieve a list of questions that are displayed for users to complete when registering to view the recording of a specific meeting.<br>
 * **Scopes:** `recording:read:admin`, `recording:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 */
export const recordingRegistrantsQuestionsGet = <ThrowOnError extends boolean = false>(
  options: Options<RecordingRegistrantsQuestionsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    RecordingRegistrantsQuestionsGetResponse,
    RecordingRegistrantsQuestionsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/meetings/{meetingId}/recordings/registrants/questions',
  });
};

/**
 * Update registration questions
 * For [on-demand](https://support.zoom.us/hc/en-us/articles/360000488283-On-demand-Recordings) meeting recordings, you can include fields with questions that will be shown to registrants when they register to view the recording.
 *
 * Use this API to update registration questions that are to be answered by users while registering to view a recording.<br>
 * **Scopes:** `recording:write:admin`, `recording:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 */
export const recordingRegistrantQuestionUpdate = <ThrowOnError extends boolean = false>(
  options: Options<RecordingRegistrantQuestionUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    RecordingRegistrantQuestionUpdateResponse,
    RecordingRegistrantQuestionUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/meetings/{meetingId}/recordings/registrants/questions',
  });
};

/**
 * Update registrant's status
 * A registrant can either be approved or denied from viewing the [on-demand](https://support.zoom.us/hc/en-us/articles/360000488283-On-demand-Recordings) recording.
 * Use this API to update a registrant's status.
 *
 * **Scopes:** `recording:write:admin`, `recording:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 */
export const meetingRecordingRegistrantStatus = <ThrowOnError extends boolean = false>(
  options: Options<MeetingRecordingRegistrantStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    MeetingRecordingRegistrantStatusResponse,
    MeetingRecordingRegistrantStatusError,
    ThrowOnError
  >({
    ...options,
    url: '/meetings/{meetingId}/recordings/registrants/status',
  });
};

/**
 * Get meeting recording settings
 * Retrieve settings applied to a meeting's [Cloud Recording](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-Recording).<br><br>
 * **Scopes**: `recording:read:admin` `recording:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light` <br>
 */
export const recordingSettingUpdate = <ThrowOnError extends boolean = false>(
  options: Options<RecordingSettingUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RecordingSettingUpdateResponse, RecordingSettingUpdateError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/recordings/settings',
  });
};

/**
 * Update meeting recording settings
 * Update settings applied to a meeting's [Cloud Recording](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-Recording)<br><br>
 * **Scopes**: `recording:write:admin` `recording:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light` <br>
 */
export const recordingSettingsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<RecordingSettingsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<RecordingSettingsUpdateResponse, RecordingSettingsUpdateError, ThrowOnError>(
    {
      ...options,
      url: '/meetings/{meetingId}/recordings/settings',
    },
  );
};

/**
 * Recover meeting recordings
 * Zoom allows users to recover recordings from trash for up to 30 days from the deletion date. Use this API to recover all deleted [Cloud Recordings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-Recording) of a specific meeting.<br><br>
 * **Scopes**: `recording:write:admin` `recording:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites**:<br>
 * * A Pro user with Cloud Recording enabled.
 */
export const recordingStatusUpdate = <ThrowOnError extends boolean = false>(
  options: Options<RecordingStatusUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<RecordingStatusUpdateResponse, RecordingStatusUpdateError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/recordings/status',
  });
};

/**
 * Delete a meeting recording file
 * Delete a sprecific recording file from a meeting.<br><br>
 * **Scopes**: `recording:write:admin` `recording:write`<br>
 * <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const recordingDeleteOne = <ThrowOnError extends boolean = false>(
  options: Options<RecordingDeleteOneData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RecordingDeleteOneResponse, RecordingDeleteOneError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/recordings/{recordingId}',
  });
};

/**
 * Recover a single recording
 * Zoom allows users to recover recordings from trash for up to 30 days from the deletion date. Use this API to recover a single recording file from the meeting.<br>
 * **Scopes:** `recording:write:admin` `recording:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 */
export const recordingStatusUpdateOne = <ThrowOnError extends boolean = false>(
  options: Options<RecordingStatusUpdateOneData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<RecordingStatusUpdateOneResponse, RecordingStatusUpdateOneError, ThrowOnError>(
    {
      ...options,
      url: '/meetings/{meetingId}/recordings/{recordingId}/status',
    },
  );
};

/**
 * List meeting registrants
 * A host or a user with admin permission can require [registration for a Zoom meeting](https://support.zoom.us/hc/en-us/articles/211579443-Registration-for-Meetings). Use this API to list users that have registered for a meeting.<br><br>
 * **Scopes**: `meeting:read:admin` `meeting:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const meetingRegistrants = <ThrowOnError extends boolean = false>(
  options: Options<MeetingRegistrantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<MeetingRegistrantsResponse, MeetingRegistrantsError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/registrants',
  });
};

/**
 * Add meeting registrant
 * Register a participant for a meeting.<br><br> Note that there is a maximum limit of 4999 registrants per meeting and users will see an error if the capacity has reached.
 *
 * **Prerequisite:**<br>
 * * Host user type must be "Licensed".
 *
 * **Scopes:** `meeting:write:admin` `meeting:write`
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const meetingRegistrantCreate = <ThrowOnError extends boolean = false>(
  options: Options<MeetingRegistrantCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<MeetingRegistrantCreateResponse, MeetingRegistrantCreateError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/registrants',
  });
};

/**
 * List registration questions
 * List registration questions that will be displayed to users while [registering for a meeting](https://support.zoom.us/hc/en-us/articles/211579443-Registration-for-Meetings).<br>
 *
 * **Scopes:** `meeting:read`, `meeting:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const meetingRegistrantsQuestionsGet = <ThrowOnError extends boolean = false>(
  options: Options<MeetingRegistrantsQuestionsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    MeetingRegistrantsQuestionsGetResponse,
    MeetingRegistrantsQuestionsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/meetings/{meetingId}/registrants/questions',
  });
};

/**
 * Update registration questions
 * Update registration questions that will be displayed to users while [registering for a meeting](https://support.zoom.us/hc/en-us/articles/211579443-Registration-for-Meetings).<br><br>
 * **Scopes:** `meeting:write`, `meeting:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 *
 */
export const meetingRegistrantQuestionUpdate = <ThrowOnError extends boolean = false>(
  options: Options<MeetingRegistrantQuestionUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    MeetingRegistrantQuestionUpdateResponse,
    MeetingRegistrantQuestionUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/meetings/{meetingId}/registrants/questions',
  });
};

/**
 * Update registrant's status
 * Update a meeting registrant's status by either approving, cancelling or denying a registrant from joining the meeting.<br><br>
 * **Scopes:** `meeting:write:admin` `meeting:write`
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const meetingRegistrantStatus = <ThrowOnError extends boolean = false>(
  options: Options<MeetingRegistrantStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<MeetingRegistrantStatusResponse, MeetingRegistrantStatusError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/registrants/status',
  });
};

/**
 * Delete a meeting registrant
 * Delete a meeting registrant.<br><br>
 * **Scopes**: `meeting:write:admin` `meeting:write`<br>
 * <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const meetingregistrantdelete = <ThrowOnError extends boolean = false>(
  options: Options<MeetingregistrantdeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    MeetingregistrantdeleteResponse,
    MeetingregistrantdeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/meetings/{meetingId}/registrants/{registrantId}',
  });
};

/**
 * Update meeting status
 * Update the status of a meeting.<br><br>
 * **Scopes:** `meeting:write:admin` `meeting:write`
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const meetingStatus = <ThrowOnError extends boolean = false>(
  options: Options<MeetingStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<MeetingStatusResponse, MeetingStatusError, ThrowOnError>({
    ...options,
    url: '/meetings/{meetingId}/status',
  });
};

/**
 * List Zoom meetings client feedback
 * Retrieve survey results from [Zoom meetings client feedback](https://support.zoom.us/hc/en-us/articles/115005855266-End-of-Meeting-Feedback-Survey#h_e30d552b-6d8e-4e0a-a588-9ca8180c4dbf). <br> You can specify a monthly date range for the dashboard data using the `from` and `to` query parameters. The month should fall within the last six months.
 *
 * **Prerequisites:**
 * * Business or higher account
 * * [Feedback to Zoom](https://support.zoom.us/hc/en-us/articles/115005838023) enabled.
 *
 * **Scope:** `account:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`
 */
export const dashboardClientFeedback = <ThrowOnError extends boolean = false>(
  options: Options<DashboardClientFeedbackData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DashboardClientFeedbackResponse, DashboardClientFeedbackError, ThrowOnError>({
    ...options,
    url: '/metrics/client/feedback',
  });
};

/**
 * Get zoom meetings client feedback
 * Retrieve detailed information on a [Zoom meetings client feedback](https://support.zoom.us/hc/en-us/articles/115005855266-End-of-Meeting-Feedback-Survey#h_e30d552b-6d8e-4e0a-a588-9ca8180c4dbf). <br> You can specify a monthly date range for the dashboard data using the `from` and `to` query parameters. The month should fall within the last six months.
 *
 * **Prerequisites:**
 * * Business or higher account
 * * [Feedback to Zoom](https://support.zoom.us/hc/en-us/articles/115005838023) enabled.
 *
 * **Scope:** `dashboard_home:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`
 *
 * `
 */
export const dashboardClientFeedbackDetail = <ThrowOnError extends boolean = false>(
  options: Options<DashboardClientFeedbackDetailData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    DashboardClientFeedbackDetailResponse,
    DashboardClientFeedbackDetailError,
    ThrowOnError
  >({
    ...options,
    url: '/metrics/client/feedback/{feedbackId}',
  });
};

/**
 * List client meeting satisfaction
 * If the [End of Meeting Feedback Survey](https://support.zoom.us/hc/en-us/articles/115005855266) option is enabled, attendees will be prompted with a survey window where they can tap either the **Thumbs Up** or **Thumbs Down** button that indicates their Zoom meeting experience. With this API, you can get information on the attendees' meeting satisfaction. Specify a monthly date range for the query using the from and to query parameters. The month should fall within the last six months.
 *
 * To get information on the survey results with negative experiences (indicated by **Thumbs Down**), use the [Get Zoom Meetings Client Feedback API](https://marketplace.zoom.us/docs/api-reference/zoom-api/dashboards/dashboardclientfeedbackdetail).<br>
 * **Scopes:** `dashboard:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`
 */
export const listMeetingSatisfaction = <ThrowOnError extends boolean = false>(
  options?: Options<ListMeetingSatisfactionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListMeetingSatisfactionResponse, ListMeetingSatisfactionError, ThrowOnError>({
    ...options,
    url: '/metrics/client/satisfaction',
  });
};

/**
 * Get CRC port usage
 * A Cloud Room Connector allows H.323/SIP endpoints to connect to a Zoom meeting.
 *
 * Use this API to get the hour by hour CRC Port usage for a specified period of time. <aside class='notice'>We will provide the report for a maximum of one month. For example, if "from" is set to "2017-08-05" and "to" is set to "2017-10-10", we will adjust "from" to "2017-09-10".</aside><br><br>
 * **Prerequisites:**<br>
 * * Business, Education or API Plan.
 * * Room Connector must be enabled on the account.<br><br>
 * **Scopes:** `dashboard_crc:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`
 */
export const dashboardCrc = <ThrowOnError extends boolean = false>(
  options: Options<DashboardCrcData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DashboardCrcResponse, DashboardCrcError, ThrowOnError>({
    ...options,
    url: '/metrics/crc',
  });
};

/**
 * Get IM metrics
 * Get [metrics](https://support.zoom.us/hc/en-us/articles/204654719-Dashboard#h_cc7e9749-1c70-4afb-a9a2-9680654821e4) on how users are utilizing the Zoom Chat Client.<br><br> <br> You can specify a monthly date range for the dashboard data using the `from` and `to` query parameters. The month should fall within the last six months.
 * **Scope:** `dashboard_im:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Resource-intensive`<br>
 * **Prerequisites:**<br>
 * * Business or a higher plan.
 *
 *
 */
export const dashboardIm = <ThrowOnError extends boolean = false>(options: Options<DashboardImData, ThrowOnError>) => {
  return (options?.client ?? client).get<DashboardImResponse, DashboardImError, ThrowOnError>({
    ...options,
    url: '/metrics/im',
  });
};

/**
 * Get top 25 Zoom Rooms with issues
 * Get information on top 25 Zoom Rooms with issues in a month. The month specified with the "from" and "to" range should fall within the last six months.<br>
 * **Scope:** `dashboard_home:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Business or a higher plan.
 * * Zoom Room must be enabled in the account.
 */
export const dashboardIssueZoomRoom = <ThrowOnError extends boolean = false>(
  options: Options<DashboardIssueZoomRoomData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DashboardIssueZoomRoomResponse, DashboardIssueZoomRoomError, ThrowOnError>({
    ...options,
    url: '/metrics/issues/zoomrooms',
  });
};

/**
 * Get issues of Zoom Rooms
 * Get information about the issues that occured on the Top 25 **Zoom Rooms with issues** in an acount. <br> You can specify a monthly date range for the dashboard data using the `from` and `to` query parameters. The month should fall within the last six months.
 *
 * **Scope:** `dashboard_home:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:** <br>
 * * Business or a higher plan.
 * * Zoom Room must be enabled in the account.
 */
export const dashboardIssueDetailZoomRoom = <ThrowOnError extends boolean = false>(
  options: Options<DashboardIssueDetailZoomRoomData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    DashboardIssueDetailZoomRoomResponse,
    DashboardIssueDetailZoomRoomError,
    ThrowOnError
  >({
    ...options,
    url: '/metrics/issues/zoomrooms/{zoomroomId}',
  });
};

/**
 * List meetings
 * List total live or past meetings that occurred during a specified period of time. This overview will show if features such as audio, video, screen sharing, and recording were being used in the meeting. You can also see the license types of each user on your account.<br> You can specify a monthly date range for the dashboard data using the `from` and `to` query parameters. The month should fall within the last six months.<br>
 * **Scopes:** `dashboard_meetings:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Resource-intensive`<br><br>
 * **Prerequisites:** <br>
 * * Business or a higher plan.<br><br>
 */
export const dashboardMeetings = <ThrowOnError extends boolean = false>(
  options: Options<DashboardMeetingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DashboardMeetingsResponse, DashboardMeetingsError, ThrowOnError>({
    ...options,
    url: '/metrics/meetings',
  });
};

/**
 * Get meeting details
 * Get details on live or past meetings. This overview will show if features such as audio, video, screen sharing, and recording were being used in the meeting. You can also see the license types of each user on your account.<br> You can specify a monthly date range for the dashboard data using the `from` and `to` query parameters. The month should fall within the last six months.  <br>
 * **Scopes:** `dashboard_meetings:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:** <br>
 * * Business or a higher plan.
 */
export const dashboardMeetingDetail = <ThrowOnError extends boolean = false>(
  options: Options<DashboardMeetingDetailData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DashboardMeetingDetailResponse, DashboardMeetingDetailError, ThrowOnError>({
    ...options,
    url: '/metrics/meetings/{meetingId}',
  });
};

/**
 * List meeting participants
 * Get a list of participants from live or past meetings.<br><br>
 * If you do not provide the `type` query parameter, the default value will be set to `live` and thus, you will only see metrics for participants in a live meeting, if any meeting is currently being conducted. To view metrics on past meeting participants, provide the appropriate value for `type`. <br> You can specify a monthly date range for the dashboard data using the `from` and `to` query parameters. The month should fall within the last six months.
 *
 * **Scopes:** `dashboard_meetings:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:** Business or a higher plan.
 */
export const dashboardMeetingParticipants = <ThrowOnError extends boolean = false>(
  options: Options<DashboardMeetingParticipantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    DashboardMeetingParticipantsResponse,
    DashboardMeetingParticipantsError,
    ThrowOnError
  >({
    ...options,
    url: '/metrics/meetings/{meetingId}/participants',
  });
};

/**
 * List meeting participants QoS
 * Get a list of meeting participants from live or past meetings along with the quality of service they recieve during the meeting such as connection quality for sending/receiving video, audio, and shared content.<br>If you do not provide the `type` query parameter, the default value will be set to `live` and thus, you will only see metrics for participants in a live meeting, if any meeting is currently being conducted. To view metrics on past meeting participants, provide the appropriate value for `type`.<br> <br> You can specify a monthly date range for the dashboard data using the `from` and `to` query parameters. The month should fall within the last six months.<br><br>
 * **Scopes:** `dashboard_meetings:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:** <br>
 * * Business or a higher plan.
 */
export const dashboardMeetingParticipantsQos = <ThrowOnError extends boolean = false>(
  options: Options<DashboardMeetingParticipantsQosData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    DashboardMeetingParticipantsQosResponse,
    DashboardMeetingParticipantsQosError,
    ThrowOnError
  >({
    ...options,
    url: '/metrics/meetings/{meetingId}/participants/qos',
  });
};

/**
 * Get post meeting feedback
 * When a meeting ends, each attendee will be prompted to share their meeting experience by clicking either thumbs up or thumbs down. Use this API to retrieve the feedback submitted for a specific meeting. Note that this API only works for meetings scheduled after December 20, 2020.
 *
 * **Prerequisites:**
 * * [Feedback to Zoom](https://support.zoom.us/hc/en-us/articles/115005838023) setting must be enabled by the participant prior to the meeting.
 * * The user making the API request must be enrolled in a Business or a higher plan.
 *
 * <br> **Scope:** `dashboard_meetings:read:admiin`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 */
export const participantFeedback = <ThrowOnError extends boolean = false>(
  options: Options<ParticipantFeedbackData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ParticipantFeedbackResponse, ParticipantFeedbackError, ThrowOnError>({
    ...options,
    url: '/metrics/meetings/{meetingId}/participants/satisfaction',
  });
};

/**
 * Get sharing/recording details
 * Retrieve the sharing and recording details of participants from live or past meetings.<br>
 * **Scopes:** `dashboard_meetings:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:** <br>
 * * Business or a higher plan.
 */
export const dashboardMeetingParticipantShare = <ThrowOnError extends boolean = false>(
  options: Options<DashboardMeetingParticipantShareData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    DashboardMeetingParticipantShareResponse,
    DashboardMeetingParticipantShareError,
    ThrowOnError
  >({
    ...options,
    url: '/metrics/meetings/{meetingId}/participants/sharing',
  });
};

/**
 * Get meeting participant QoS
 * Retrieve the quality of service for participants from live or past meetings. This data indicates the connection quality for sending/receiving video, audio, and shared content. If nothing is being sent or received at that time, no information will be shown in the fields. <br><br>
 * **Scopes:** `dashboard_meetings:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`
 */
export const dashboardMeetingParticipantQos = <ThrowOnError extends boolean = false>(
  options: Options<DashboardMeetingParticipantQosData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    DashboardMeetingParticipantQosResponse,
    DashboardMeetingParticipantQosError,
    ThrowOnError
  >({
    ...options,
    url: '/metrics/meetings/{meetingId}/participants/{participantId}/qos',
  });
};

/**
 * List webinars
 * List all the live or past webinars from a specified period of time. <br><br>
 * **Scopes:** `dashboard_webinars:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Resource-intensive`<br>
 * **Prerequisites:**<br>
 * * Business, Education or API Plan with Webinar add-on.
 *
 *
 *
 */
export const dashboardWebinars = <ThrowOnError extends boolean = false>(
  options: Options<DashboardWebinarsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DashboardWebinarsResponse, DashboardWebinarsError, ThrowOnError>({
    ...options,
    url: '/metrics/webinars',
  });
};

/**
 * Get webinar details
 * Retrieve details from live or past webinars.<br><br>
 * **Scopes:** `dashboard_webinars:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Business, Education or API Plan with Webinar add-on.
 *
 *
 */
export const dashboardWebinarDetail = <ThrowOnError extends boolean = false>(
  options: Options<DashboardWebinarDetailData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DashboardWebinarDetailResponse, DashboardWebinarDetailError, ThrowOnError>({
    ...options,
    url: '/metrics/webinars/{webinarId}',
  });
};

/**
 * Get webinar participants
 * Retrieve details on participants from live or past webinars.<br><br>
 * **Scopes:** `dashboard_webinars:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Business, Education or API Plan with Webinar add-on.
 *
 *
 */
export const dashboardWebinarParticipants = <ThrowOnError extends boolean = false>(
  options: Options<DashboardWebinarParticipantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    DashboardWebinarParticipantsResponse,
    DashboardWebinarParticipantsError,
    ThrowOnError
  >({
    ...options,
    url: '/metrics/webinars/{webinarId}/participants',
  });
};

/**
 * List webinar participant QoS
 * Retrieve a list of participants from live or past webinars and the quality of service they received.<br>This data indicates the connection quality for sending/receiving video, audio, and shared content. If nothing is being sent or received at that time, no information will be shown in the fields.<br>
 * **Scopes:** `dashboard_webinars:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**
 * * Business, Education or API Plan with Webinar add-on.
 *
 *
 */
export const dashboardWebinarParticipantsQos = <ThrowOnError extends boolean = false>(
  options: Options<DashboardWebinarParticipantsQosData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    DashboardWebinarParticipantsQosResponse,
    DashboardWebinarParticipantsQosError,
    ThrowOnError
  >({
    ...options,
    url: '/metrics/webinars/{webinarId}/participants/qos',
  });
};

/**
 * Get post webinar feedback
 * When a Webinar ends, each attendee will be prompted to share their Webinar experience by clicking either thumbs up or thumbs down. Use this API to retrieve the feedback submitted for a specific webinar. Note that this API only works for meetings scheduled after December 20, 2020.
 *
 * **Prerequisites:**
 * * [Feedback to Zoom](https://support.zoom.us/hc/en-us/articles/115005838023) setting must be enabled by the participant prior to the meeting.
 * * The user making the API request must be enrolled in a Business or a higher plan.
 *
 *
 * <br> **Scope:** `dashboard_webinars:read:admin`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 */
export const participantWebinarFeedback = <ThrowOnError extends boolean = false>(
  options: Options<ParticipantWebinarFeedbackData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ParticipantWebinarFeedbackResponse,
    ParticipantWebinarFeedbackError,
    ThrowOnError
  >({
    ...options,
    url: '/metrics/webinars/{webinarId}/participants/satisfaction',
  });
};

/**
 * Get sharing/recording details
 * Retrieve the sharing and recording details of participants from live or past webinars. <br><br>
 * **Scopes:** `dashboard_webinars:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy` <br>
 * **Prerequisites:**<br>
 * * Business, Education or API Plan with Webinar add-on.
 *
 *
 */
export const dashboardWebinarParticipantShare = <ThrowOnError extends boolean = false>(
  options: Options<DashboardWebinarParticipantShareData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    DashboardWebinarParticipantShareResponse,
    DashboardWebinarParticipantShareError,
    ThrowOnError
  >({
    ...options,
    url: '/metrics/webinars/{webinarId}/participants/sharing',
  });
};

/**
 * Get webinar participant QoS
 * Retrieve details on the quality of service that participants from live or past webinars recieved.<br>This data indicates the connection quality for sending/receiving video, audio, and shared content. If nothing is being sent or received at that time, no information will be shown in the fields.<br>
 * **Scopes:** `dashboard_webinars:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy` <br>
 * **Prerequisites:** <br>
 * * Business, Education or API Plan with Zoom Rooms set up.
 *
 */
export const dashboardWebinarParticipantQos = <ThrowOnError extends boolean = false>(
  options: Options<DashboardWebinarParticipantQosData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    DashboardWebinarParticipantQosResponse,
    DashboardWebinarParticipantQosError,
    ThrowOnError
  >({
    ...options,
    url: '/metrics/webinars/{webinarId}/participants/{participantId}/qos',
  });
};

/**
 * List Zoom Rooms
 * List information on all Zoom Rooms in an account.<br><br>
 * **Scopes:** `dashboard_zr:read:admin`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Resource-intensive`<br>
 * **Prerequisites:**<br>
 * * Business, Education or API Plan with Zoom Rooms set up.
 *
 *
 *
 */
export const dashboardZoomRooms = <ThrowOnError extends boolean = false>(
  options?: Options<DashboardZoomRoomsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DashboardZoomRoomsResponse, DashboardZoomRoomsError, ThrowOnError>({
    ...options,
    url: '/metrics/zoomrooms',
  });
};

/**
 * Get top 25 issues of Zoom Rooms
 * Get top 25 issues of Zoom Rooms.<br>
 * **Scopes:** `dashboard_zr:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Business, Education or API Plan with Zoom Rooms set up.
 *
 *
 */
export const dashboardZoomRoomIssue = <ThrowOnError extends boolean = false>(
  options: Options<DashboardZoomRoomIssueData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DashboardZoomRoomIssueResponse, DashboardZoomRoomIssueError, ThrowOnError>({
    ...options,
    url: '/metrics/zoomrooms/issues',
  });
};

/**
 * Get Zoom Rooms details
 * The Zoom Rooms dashboard metrics lets you know the type of configuration a Zoom room has and details on the meetings held in that room.
 *
 * Use this API to retrieve information on a specific room.<br><br>
 * **Scopes:** `dashboard_zr:read:admin`<br> <br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`**Prerequisites:**<br>
 * * Business, Education or API Plan with Zoom Rooms set up.
 *
 */
export const dashboardZoomRoom = <ThrowOnError extends boolean = false>(
  options: Options<DashboardZoomRoomData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DashboardZoomRoomResponse, DashboardZoomRoomError, ThrowOnError>({
    ...options,
    url: '/metrics/zoomrooms/{zoomroomId}',
  });
};

/**
 * List past meeting's files
 * **Note: This API has been deprecated and is no longer supported due to GCM encryption updates for security purposes.** To learn about saving the in-meeting chat files via Zoom Client, refer to the [Saving in-meeting chat](https://support.zoom.us/hc/en-us/articles/115004792763-Saving-in-meeting-chat) guide.
 *
 * List files sent via in-meeting chat during a meeting. The in-meeting files are deleted after 24 hours of the meeting completion time.
 * <br><br>
 * **Scope:** `meeting:read`, `meeting:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listPastMeetingFiles = <ThrowOnError extends boolean = false>(
  options: Options<ListPastMeetingFilesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPastMeetingFilesResponse, ListPastMeetingFilesError, ThrowOnError>({
    ...options,
    url: '/past_meetings/{meetingId}/files',
  });
};

/**
 * List ended meeting instances
 * Get a list of ended meeting instances<br><br>
 * **Scopes:** `meeting:read:admin` `meeting:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const pastMeetings = <ThrowOnError extends boolean = false>(
  options: Options<PastMeetingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<PastMeetingsResponse, PastMeetingsError, ThrowOnError>({
    ...options,
    url: '/past_meetings/{meetingId}/instances',
  });
};

/**
 * List past meeting's poll results
 * [Polls](https://support.zoom.us/hc/en-us/articles/213756303-Polling-for-Meetings) allow the meeting host to survey attendees. Use this API to list poll results of a meeting.<br><br>
 *
 * **Scopes**: `meeting:read:admin`, `meeting:read`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium` <br>
 * **Prerequisites**:<br>
 * * Host user type must be **Pro**.
 * * Meeting must be a scheduled meeting. Instant meetings do not have polling features enabled.
 */
export const listPastMeetingPolls = <ThrowOnError extends boolean = false>(
  options: Options<ListPastMeetingPollsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPastMeetingPollsResponse, ListPastMeetingPollsError, ThrowOnError>({
    ...options,
    url: '/past_meetings/{meetingId}/polls',
  });
};

/**
 * Get past meeting details
 * Get details on a past meeting. <br><br>
 * **Scopes:** `meeting:read:admin` `meeting:read`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 * > **Note**: Please double encode your UUID when using this API if the UUID begins with a '/'or contains '//' in it.
 */
export const pastMeetingDetails = <ThrowOnError extends boolean = false>(
  options: Options<PastMeetingDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<PastMeetingDetailsResponse, PastMeetingDetailsError, ThrowOnError>({
    ...options,
    url: '/past_meetings/{meetingUUID}',
  });
};

/**
 * Get past meeting participants
 * Retrieve information on participants from a past meeting. <br><br>
 * **Scopes:** `meeting:read:admin` `meeting:read`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 * **Prerequisites:**<br>
 * * Paid account on a Pro or higher plan.
 *
 * <br> <br>  **Note**: Please double encode your UUID when using this API if the UUID begins with a '/'or contains '//' in it.
 *
 */
export const pastMeetingParticipants = <ThrowOnError extends boolean = false>(
  options: Options<PastMeetingParticipantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<PastMeetingParticipantsResponse, PastMeetingParticipantsError, ThrowOnError>({
    ...options,
    url: '/past_meetings/{meetingUUID}/participants',
  });
};

/**
 * Get webinar absentees
 * List absentees of a webinar.<br><br>
 * **Scopes:** `webinar:read:admin` `webinar:read`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`
 */
export const webinarAbsentees = <ThrowOnError extends boolean = false>(
  options: Options<WebinarAbsenteesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<WebinarAbsenteesResponse, WebinarAbsenteesError, ThrowOnError>({
    ...options,
    url: '/past_webinars/{WebinarUUID}/absentees',
  });
};

/**
 * List past webinar files
 * **Note: This API has been deprecated and is no longer supported due to GCM encryption updates for security purposes.**
 *
 * List files sent via in-meeting chat during a meeting. The in-meeting files are deleted after 24 hours of the meeting completion time.
 * <br><br>
 * **Scope:** `webinar:read`, `webinar:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 */
export const listPastWebinarFiles = <ThrowOnError extends boolean = false>(
  options: Options<ListPastWebinarFilesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPastWebinarFilesResponse, ListPastWebinarFilesError, ThrowOnError>({
    ...options,
    url: '/past_webinars/{webinarId}/files',
  });
};

/**
 * List past webinar instances
 * List past webinar instances.<br><br>
 * **Scopes:** `webinar:read:admin` `webinar:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const pastWebinars = <ThrowOnError extends boolean = false>(
  options: Options<PastWebinarsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<PastWebinarsResponse, PastWebinarsError, ThrowOnError>({
    ...options,
    url: '/past_webinars/{webinarId}/instances',
  });
};

/**
 * List webinar participants
 * Use this API to list all the participants who attended a webinar hosted in the past. <br>
 *
 * **Prerequisites:**
 * * Pro or higher plan with a Webinar Add-on.<br>
 * **Scopes:** `webinar:read:admin` `webinar:read`<br>
 * <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 *
 *
 */
export const listWebinarParticipants = <ThrowOnError extends boolean = false>(
  options: Options<ListWebinarParticipantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListWebinarParticipantsResponse, ListWebinarParticipantsError, ThrowOnError>({
    ...options,
    url: '/past_webinars/{webinarId}/participants',
  });
};

/**
 * List past webinar poll results
 * The polling feature for webinar allows you to create single choice or multiple choice polling questions for your webinars. Use this API to retrieve the results for Webinar Polls of a specific Webinar.
 *
 * **Prerequisites:**<br>
 * * [Webinar license](https://zoom.us/webinar)<br>
 * **Scopes**: `webinar:read:admin`, `webinar:read`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 *
 */
export const listPastWebinarPollResults = <ThrowOnError extends boolean = false>(
  options: Options<ListPastWebinarPollResultsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListPastWebinarPollResultsResponse,
    ListPastWebinarPollResultsError,
    ThrowOnError
  >({
    ...options,
    url: '/past_webinars/{webinarId}/polls',
  });
};

/**
 * List Q&A of past webinar
 * The [Question & Answer (Q&A)](https://support.zoom.us/hc/en-us/articles/203686015-Getting-Started-with-Question-Answer) feature for Webinars allows attendees to ask questions during the Webinar and for the panelists, co-hosts and host to answer their questions.<br>
 * Use this API to list Q&A of a specific Webinar.
 *
 * **Prerequisites:**<br>
 * * [Webinar license](https://zoom.us/webinar)<br>
 * **Scopes**: `webinar:read:admin`, `webinar:read`<br>
 * <br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listPastWebinarQa = <ThrowOnError extends boolean = false>(
  options: Options<ListPastWebinarQaData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPastWebinarQaResponse, ListPastWebinarQaError, ThrowOnError>({
    ...options,
    url: '/past_webinars/{webinarId}/qa',
  });
};

/**
 * Add an auto receptionist
 * Auto receptionists answer calls with a personalized recording and routes calls to a phone user, call queue, common area phone, voicemail or an IVR system. Use this API to add an [auto receptionist](https://support.zoom.us/hc/en-us/articles/360021121312-Managing-Auto-Receptionists-and-Interactive-Voice-Response-IVR-) to a Zoom Phone.<br>
 *
 * **Prerequisites:**<br>
 * * Pro or higher account with Zoom Phone license.<br>
 * **Scopes:** `phone:write:admin` <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const addAutoReceptionist = <ThrowOnError extends boolean = false>(
  options?: Options<AddAutoReceptionistData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddAutoReceptionistResponse, AddAutoReceptionistError, ThrowOnError>({
    ...options,
    url: '/phone/auto_receptionists',
  });
};

/**
 * Update auto receptionist details
 * An auto receptionist answers calls with a personalized recording and routes calls to a phone user, call queue, common area phone, or voicemail. An auto receptionist can also be set up so that it routes calls to an interactive voice response (IVR) system to allow callers to select the routing options.<br>
 * Use this API to [change information](https://support.zoom.us/hc/en-us/articles/360021121312-Managing-Auto-Receptionists-and-Interactive-Voice-Response-IVR-#h_1d5ffc56-6ba3-4ce5-9d86-4a1a1ee743f3) such as display name and extension number assigned to the main auto receptionist.<br><br>
 * **Prerequisites:**<br>
 * * Pro or higher account with Zoom Phone license.<br>
 * **Scopes:** `phone:write:admin` <br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const updateAutoReceptionist = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAutoReceptionistData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateAutoReceptionistResponse, UpdateAutoReceptionistError, ThrowOnError>({
    ...options,
    url: '/phone/auto_receptionists/{autoReceptionistId}',
  });
};

/**
 * Unassign all phone numbers
 * Unassign all phone numbers that were previously assigned to an [auto receptionist](https://support.zoom.us/hc/en-us/articles/360021121312-Managing-Auto-Receptionists-and-Interactive-Voice-Response-IVR-).
 *
 * **Prerequisites:**
 * * Pro or higher account plan with Zoom Phone License
 * * Account owner or admin permissions<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 */
export const unassignAllPhoneNumsAutoReceptionist = <ThrowOnError extends boolean = false>(
  options: Options<UnassignAllPhoneNumsAutoReceptionistData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    UnassignAllPhoneNumsAutoReceptionistResponse,
    UnassignAllPhoneNumsAutoReceptionistError,
    ThrowOnError
  >({
    ...options,
    url: '/phone/auto_receptionists/{autoReceptionistId}/phone_numbers',
  });
};

/**
 * Assign phone numbers
 * Assign available phone numbers to an [auto receptionist](https://support.zoom.us/hc/en-us/articles/360021121312-Managing-Auto-Receptionists-and-Interactive-Voice-Response-IVR-). The available numbers can be retrieved using the List Phone Numbers API with `type` query parameter set to "unassigned".
 *
 * **Prerequisites:**
 * * Pro or higher account plan with Zoom Phone License
 * * Account owner or admin permissions<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const assignPhoneNumbersAutoReceptionist = <ThrowOnError extends boolean = false>(
  options: Options<AssignPhoneNumbersAutoReceptionistData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AssignPhoneNumbersAutoReceptionistResponse,
    AssignPhoneNumbersAutoReceptionistError,
    ThrowOnError
  >({
    ...options,
    url: '/phone/auto_receptionists/{autoReceptionistId}/phone_numbers',
  });
};

/**
 * Unassign a phone number
 * Unassign a specific phone number that was previously assigned to an [auto receptionist](https://support.zoom.us/hc/en-us/articles/360021121312-Managing-Auto-Receptionists-and-Interactive-Voice-Response-IVR-).
 *
 * **Prerequisites:**
 * * Pro or higher account plan with Zoom Phone License
 * * Account owner or admin permissions<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const unassignAphoneNumAutoReceptionist = <ThrowOnError extends boolean = false>(
  options: Options<UnassignAphoneNumAutoReceptionistData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    UnassignAphoneNumAutoReceptionistResponse,
    UnassignAphoneNumAutoReceptionistError,
    ThrowOnError
  >({
    ...options,
    url: '/phone/auto_receptionists/{autoReceptionistId}/phone_numbers/{phoneNumberId}',
  });
};

/**
 * List blocked lists
 * A Zoom account owner or a user with admin privilege can block phone numbers for phone users in an account. Blocked numbers can be inbound (numbers will be blocked from calling in) and outbound (phone users in your account won't be able to dial those numbers). Blocked callers will hear a generic message stating that the person they are calling is not available.<br>Use this API to list all the blocked lists in an acccount.<br>
 * **Prerequisites:**
 * * Pro or higher account plan with Zoom phone license<br>
 * **Scope:** `phone:read:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listBlockedList = <ThrowOnError extends boolean = false>(
  options?: Options<ListBlockedListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListBlockedListResponse, ListBlockedListError, ThrowOnError>({
    ...options,
    url: '/phone/blocked_list',
  });
};

/**
 * Create a blocked list
 * A Zoom account owner or a user with admin privilege can block phone numbers for phone users in an account. Blocked numbers can be inbound (numbers will be blocked from calling in) and outbound (phone users in your account won't be able to dial those numbers). Blocked callers will hear a generic message stating that the person they are calling is not available.<br>Use this API to create a blocked list and add a number to that blocked list.<br>
 * **Prerequisites:**
 * * Pro or higher account plan with Zoom phone license<br>
 * **Scope:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const addAnumberToBlockedList = <ThrowOnError extends boolean = false>(
  options?: Options<AddAnumberToBlockedListData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddAnumberToBlockedListResponse, AddAnumberToBlockedListError, ThrowOnError>({
    ...options,
    url: '/phone/blocked_list',
  });
};

/**
 * Delete a blocked list
 * A Zoom account owner or a user with admin privilege can block phone numbers for phone users in an account. Blocked numbers can be inbound (numbers will be blocked from calling in) and outbound (phone users in your account won't be able to dial those numbers).
 * <br>Use this API to delete a blocked list and therefore removing the associated number from the blocked list. The number will be unblocked after the deletion.<br>
 * **Prerequisites:**
 * * Pro or higher account plan with Zoom phone license<br>
 * **Scope:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deleteAblockedList = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAblockedListData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAblockedListResponse, DeleteAblockedListError, ThrowOnError>({
    ...options,
    url: '/phone/blocked_list/{blockedListId}',
  });
};

/**
 * Get blocked list details
 * A Zoom account owner or a user with admin privilege can block phone numbers for phone users in an account. Blocked numbers can be inbound (numbers will be blocked from calling in) and outbound (phone users in your account won't be able to dial those numbers). Blocked callers will hear a generic message stating that the person they are calling is not available.<br>Use this API to get information about a specific blocked list.<br>
 * **Prerequisites:**
 * * Pro or higher account plan with Zoom phone license<br>
 * **Scope:** `phone:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const getAblockedList = <ThrowOnError extends boolean = false>(
  options: Options<GetAblockedListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAblockedListResponse, GetAblockedListError, ThrowOnError>({
    ...options,
    url: '/phone/blocked_list/{blockedListId}',
  });
};

/**
 * Update a blocked list
 * A Zoom account owner or a user with admin privilege can block phone numbers for phone users in an account. Blocked numbers can be inbound (numbers will be blocked from calling in) and outbound (phone users in your account won't be able to dial those numbers). Blocked callers will hear a generic message stating that the person they are calling is not available.<br>Use this API to update information on the blocked list.<br>
 * **Prerequisites:**
 * * Pro or higher account plan with Zoom phone license<br>
 * **Scope:** `phone:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const updateBlockedList = <ThrowOnError extends boolean = false>(
  options: Options<UpdateBlockedListData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateBlockedListResponse, UpdateBlockedListError, ThrowOnError>({
    ...options,
    url: '/phone/blocked_list/{blockedListId}',
  });
};

/**
 * Add BYOC phone numbers
 * Use this API to add BYOC phone numbers(provided to you by your carrier) to Zoom.
 *
 * **Scope:** `phone:write:admin` or `phone:write` or `phone:master`
 *
 * **Prerequisites:**<br>
 * * The account must hold a business or enterprise plan and Zoom Phone license.
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 *
 */
export const addByocNumber = <ThrowOnError extends boolean = false>(
  options?: Options<AddByocNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddByocNumberResponse, AddByocNumberError, ThrowOnError>({
    ...options,
    url: '/phone/byoc_numbers',
  });
};

/**
 * Get account's call logs
 * Retrieve [call logs](https://support.zoom.us/hc/en-us/articles/360021114452-Viewing-Call-Logs) for an account.
 *
 * **Scopes**: `phone:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisite:**<br>
 * 1. Business or Enterprise account<br>
 * 2. A Zoom Phone license<br>
 * 3. Account Owner and a [role](https://support.zoom.us/hc/en-us/articles/115001078646-Role-Based-Access-Control) with Zoom Phone Management<br>
 */
export const accountCallLogs = <ThrowOnError extends boolean = false>(
  options?: Options<AccountCallLogsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AccountCallLogsResponse, AccountCallLogsError, ThrowOnError>({
    ...options,
    url: '/phone/call_logs',
  });
};

/**
 * List call queues
 * Call queues allow you to route incoming calls to a group of users. For instance, you can use call queues to route calls to various departments in your organization such as sales, engineering, billing, customer service etc.<br> Use this API to list Call queues.<br><br>
 * **Prerequisites:**<br>
 * * Pro, Business, or Education account
 * * Account owner or admin permissions
 * * Zoom Phone license<br>
 * **Scopes:** `phone:read:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 */
export const listCallQueues = <ThrowOnError extends boolean = false>(
  options?: Options<ListCallQueuesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListCallQueuesResponse, ListCallQueuesError, ThrowOnError>({
    ...options,
    url: '/phone/call_queues',
  });
};

/**
 * Create a call queue
 * Call queues allow you to route incoming calls to a group of users. For instance, you can use call queues to route calls to various departments in your organization such as sales, engineering, billing, customer service etc.<br> Use this API to [create a call queue](https://support.zoom.us/hc/en-us/articles/360021524831-Managing-Call-Queues#h_e81faeeb-9184-429a-aaea-df49ff5ff413).<br> You can add phone users or common area phones to call queues.
 *
 * **Prerequisites:**<br>
 * * Pro, Business, or Education account
 * * Account owner or admin permissions
 * * Zoom Phone license<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const createCallQueue = <ThrowOnError extends boolean = false>(
  options?: Options<CreateCallQueueData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateCallQueueResponse, CreateCallQueueError, ThrowOnError>({
    ...options,
    url: '/phone/call_queues',
  });
};

/**
 * Delete a call queue
 * Call queues allow you to route incoming calls to a group of users. For instance, you can use call queues to route calls to various departments in your organization such as sales, engineering, billing, customer service etc.<br> Use this API to delete a Call Queue.<br>
 * **Prerequisites:**<br>
 * * Pro, Business, or Education account
 * * Account owner or admin permissions
 * * Zoom Phone license<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const deleteAcallQueue = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAcallQueueData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAcallQueueResponse, DeleteAcallQueueError, ThrowOnError>({
    ...options,
    url: '/phone/call_queues/{callQueueId}',
  });
};

/**
 * Get call queue details
 * Call queues allow you to route incoming calls to a group of users. For instance, you can use call queues to route calls to various departments in your organization such as sales, engineering, billing, customer service etc.<br> Use this API to get information on a specific Call Queue.<br><br>
 * **Prerequisites:**<br>
 * * Pro, Business, or Education account
 * * Account owner or admin permissions
 * * Zoom Phone license<br>
 * **Scopes:** `phone:read:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const getAcallQueue = <ThrowOnError extends boolean = false>(
  options: Options<GetAcallQueueData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAcallQueueResponse, GetAcallQueueError, ThrowOnError>({
    ...options,
    url: '/phone/call_queues/{callQueueId}',
  });
};

/**
 * Update call queue details
 * Call queues allow you to route incoming calls to a group of users. For instance, you can use call queues to route calls to various departments in your organization such as sales, engineering, billing, customer service etc.<br> Use this API to update information of a specific Call Queue.<br>
 * **Prerequisites:**<br>
 * * Pro, Business, or Education account
 * * Account owner or admin permissions
 * * Zoom Phone license<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 */
export const updateCallQueue = <ThrowOnError extends boolean = false>(
  options: Options<UpdateCallQueueData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateCallQueueResponse, UpdateCallQueueError, ThrowOnError>({
    ...options,
    url: '/phone/call_queues/{callQueueId}',
  });
};

/**
 * Change call queue manager
 * A call queue manager has the privileges to maanage the call queue's voicemail inbox and recordings, change all call queue settings and call queue policy settings.<br><br> Use this API to to set another phone user as the [call queue manager](https://support.zoom.us/hc/en-us/articles/360021524831-Managing-Call-Queues#h_db06854b-e6a3-4afe-ba15-baf58f31f90c).
 * **Prerequisites:**<br>
 * * Pro or higher account plan.
 * * Account owner or admin permissions
 * * Zoom Phone license<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const changeCallQueueManager = <ThrowOnError extends boolean = false>(
  options: Options<ChangeCallQueueManagerData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<ChangeCallQueueManagerResponse, ChangeCallQueueManagerError, ThrowOnError>({
    ...options,
    url: '/phone/call_queues/{callQueueId}/manager',
  });
};

/**
 * Unassign all members
 * Use this API to remove all members from a Call Queue who were previously assigned to that Call Queue. The members could be phone users or [common area phones](https://support.zoom.us/hc/en-us/articles/360028516231-Managing-Common-Area-Phones).
 * **Prerequisites:**<br>
 * * Pro or higher account plan.
 * * Zoom Phone license<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const unassignAllMembers = <ThrowOnError extends boolean = false>(
  options: Options<UnassignAllMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UnassignAllMembersResponse, UnassignAllMembersError, ThrowOnError>({
    ...options,
    url: '/phone/call_queues/{callQueueId}/members',
  });
};

/**
 * Add members to a call queue
 * Add phone users and/or [common area phones](https://support.zoom.us/hc/en-us/articles/360028516231-Managing-Common-Area-Phones) as members to a specific Call Queue.<br><br>
 * **Prerequisites:**<br>
 * * Pro or higher account plan.
 * * Zoom Phone license<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const addMembersToCallQueue = <ThrowOnError extends boolean = false>(
  options: Options<AddMembersToCallQueueData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddMembersToCallQueueResponse, AddMembersToCallQueueError, ThrowOnError>({
    ...options,
    url: '/phone/call_queues/{callQueueId}/members',
  });
};

/**
 * Unassign a member
 * Use this API to remove a member from a Call Queue who was previously added to that Call Queue. The member could be a phone user or a [common area phone](https://support.zoom.us/hc/en-us/articles/360028516231-Managing-Common-Area-Phones). A member who is a Call Queue Manager cannot be unassigned from the Call Queue using this API.
 * **Prerequisites:**<br>
 * * Pro or higher account plan.
 * * Zoom Phone license<br>
 * **Scopes:** `phone:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const unassignMemberFromCallQueue = <ThrowOnError extends boolean = false>(
  options: Options<UnassignMemberFromCallQueueData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    UnassignMemberFromCallQueueResponse,
    UnassignMemberFromCallQueueError,
    ThrowOnError
  >({
    ...options,
    url: '/phone/call_queues/{callQueueId}/members/{memberId}',
  });
};

/**
 * Unassign all phone numbers
 * Use this API to unbind all phone numbers that are assigned to a [Call Queue](https://support.zoom.us/hc/en-us/articles/360021524831-Managing-Call-Queues) After successful unbinding, the numbers will appear in the [Unassigned tab](https://zoom.us/signin#/numbers/unassigned).<br> If you only need to unassign a specific phone number, use the Unassign a Phone Number API instead. <br>
 * **Prerequisites:**
 * * Pro or higher account palan
 * * Account owner or admin permissions
 * * Zoom Phone license <br> **Scopes:** `phone:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const unassignAphoneNumCallQueue = <ThrowOnError extends boolean = false>(
  options: Options<UnassignAphoneNumCallQueueData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    UnassignAphoneNumCallQueueResponse,
    UnassignAphoneNumCallQueueError,
    ThrowOnError
  >({
    ...options,
    url: '/phone/call_queues/{callQueueId}/phone_numbers',
  });
};

/**
 * Assign numbers to a call queue
 * After [buying phone number(s)](https://support.zoom.us/hc/en-us/articles/360020808292#h_007ec8c2-0914-4265-8351-96ab23efa3ad), you can assign it, allowing callers to directly dial a number to reach a [call queue](https://support.zoom.us/hc/en-us/articles/360021524831-Managing-Call-Queues).<br><br>
 * **Prerequisites:**<br>
 * * Pro or higher account plan.
 * * Account owner or admin permissions
 * * Zoom Phone license<br>
 * **Scopes:** `phone:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const assignPhoneToCallQueue = <ThrowOnError extends boolean = false>(
  options: Options<AssignPhoneToCallQueueData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AssignPhoneToCallQueueResponse, AssignPhoneToCallQueueError, ThrowOnError>({
    ...options,
    url: '/phone/call_queues/{callQueueId}/phone_numbers',
  });
};

/**
 * Unassign a phone number
 * After assigning a phone number, you can unbind it if you don't want it to be assigned to a [Call Queue](https://support.zoom.us/hc/en-us/articles/360021524831-Managing-Call-Queues). Use this API to unbind a phone number from a Call Queue. After successful unbinding, the number will appear in the [Unassigned tab](https://zoom.us/signin#/numbers/unassigned).<br><br>
 * **Prerequisites:**
 * * Pro or higher account palan
 * * Account owner or admin permissions
 * * Zoom Phone license <br> **Scopes:** `phone:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const unAssignPhoneNumCallQueue = <ThrowOnError extends boolean = false>(
  options: Options<UnAssignPhoneNumCallQueueData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    UnAssignPhoneNumCallQueueResponse,
    UnAssignPhoneNumCallQueueError,
    ThrowOnError
  >({
    ...options,
    url: '/phone/call_queues/{callQueueId}/phone_numbers/{phoneNumberId}',
  });
};

/**
 * Get call queue recordings
 * Use this API to view [call recordings](https://support.zoom.us/hc/en-us/articles/360038521091#h_cbc9f2a3-e06c-4daa-83d4-ddbceef9c77b) from the call queue.<br><br>
 * **Prerequisites:**<br>
 * * Pro or higher account with Zoom Phone license.
 * * [Automatic call recordings](https://support.zoom.us/hc/en-us/articles/360033511872#h_fcb297bb-14e8-4094-91ca-dc61e1a18734) must be enabled in the Policy Settings for call queues. <br> **Scope:** `phone:read:admin`<br> **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 *
 *
 *
 */
export const getCallQueueRecordings = <ThrowOnError extends boolean = false>(
  options: Options<GetCallQueueRecordingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCallQueueRecordingsResponse, GetCallQueueRecordingsError, ThrowOnError>({
    ...options,
    url: '/phone/call_queues/{callQueueId}/recordings',
  });
};

/**
 * List calling plans
 * List all Zoom Phone [calling plans](https://marketplace.zoom.us/docs/api-reference/other-references/plans#zoom-phone-calling-plans) that are enabled for a Zoom account.<br><br>
 * **Prerequisites:**<br>
 * * Pro or a higher account with Zoom phone license. <br>
 * **Scope:** `phone:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listCallingPlans = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<ListCallingPlansResponse, ListCallingPlansError, ThrowOnError>({
    ...options,
    url: '/phone/calling_plans',
  });
};

/**
 * List common area phones
 * A common area phone can be provisioned by a Zoom account owner or a Zoom admin so that anyone in an organization can use it. For example, if your office has shared desks that don't belong to a specific employees, you could add a common area phone so that any person can use it.<br> Use this API to [list all common area phone](https://support.zoom.us/hc/en-us/articles/360028516231-Managing-Common-Area-Phones) in an account.<br><br>**Prerequisites:**<br>
 * * Pro or a higher account with Zoom Phone license.
 * * Account owner or admin permissions.
 * * [Supported device](https://support.zoom.us/hc/en-us/articles/360001299063-Zoom-Voice-Supported-Devices)<br><br>
 * **Scope:** `phone:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listCommonAreaPhones = <ThrowOnError extends boolean = false>(
  options?: Options<ListCommonAreaPhonesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListCommonAreaPhonesResponse, ListCommonAreaPhonesError, ThrowOnError>({
    ...options,
    url: '/phone/common_area_phones',
  });
};

/**
 * Add a common area phone
 * A common area phone can be provisioned by a Zoom account owner or a Zoom admin so that anyone in an organization can use it. For example, if your office has shared desks that don't belong to a specific employees, you could add a common area phone so that any person can use it.<br> Use this API to [add a common area phone](https://support.zoom.us/hc/en-us/articles/360028516231-Managing-Common-Area-Phones#h_2d0da347-c35a-4993-9771-e21aaa568deb).<br><br>
 * **Prerequisites:**<br>
 * * Pro or a higher account with Zoom Phone license.
 * * Account owner or admin permissions.
 * * [Supported device](https://support.zoom.us/hc/en-us/articles/360001299063-Zoom-Voice-Supported-Devices)<br>
 * **Scope:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const addCommonAreaPhone = <ThrowOnError extends boolean = false>(
  options?: Options<AddCommonAreaPhoneData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddCommonAreaPhoneResponse, AddCommonAreaPhoneError, ThrowOnError>({
    ...options,
    url: '/phone/common_area_phones',
  });
};

/**
 * Delete a common area phone
 * A common area phone can be provisioned by a Zoom account owner or a Zoom admin so that anyone in an organization can use it. For example, if your office has shared desks that don't belong to a specific employees, you could add a common area phone so that any person can use it.<br> Use this API to remove the [common area phone](https://support.zoom.us/hc/en-us/articles/360028516231-Managing-Common-Area-Phones) from Zoom Phone System in an account.<br><br>**Prerequisites:**<br>
 * * Pro or a higher account with Zoom Phone license.
 * * Account owner or admin permissions.
 * * [Supported device](https://support.zoom.us/hc/en-us/articles/360001299063-Zoom-Voice-Supported-Devices)<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deleteCommonAreaPhone = <ThrowOnError extends boolean = false>(
  options: Options<DeleteCommonAreaPhoneData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteCommonAreaPhoneResponse, DeleteCommonAreaPhoneError, ThrowOnError>({
    ...options,
    url: '/phone/common_area_phones/{commonAreaPhoneId}',
  });
};

/**
 * Get common area phone details
 * A common area phone can be provisioned by a Zoom account owner or a Zoom admin so that anyone in an organization can use it. For example, if your office has shared desks that don't belong to a specific employees, you could add a common area phone so that any person can use it.<br> Use this API to get details on a specific [common area phone](https://support.zoom.us/hc/en-us/articles/360028516231-Managing-Common-Area-Phones) in an account.<br>For the `commonAreaPhoneId`, use the unique identifier or the Mac address of the common area phone. The Mac address can be hyphenated (00-04-f2-5e-ec-3c) or not hyphenated (0004f25eec3c).<br><br>**Prerequisites:**<br>
 * * Pro or a higher account with Zoom Phone license.
 * * Account owner or admin permissions.
 * * [Supported device](https://support.zoom.us/hc/en-us/articles/360001299063-Zoom-Voice-Supported-Devices)<br>
 * **Scopes:** `phone:read:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const getAcommonAreaPhone = <ThrowOnError extends boolean = false>(
  options: Options<GetAcommonAreaPhoneData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAcommonAreaPhoneResponse, GetAcommonAreaPhoneError, ThrowOnError>({
    ...options,
    url: '/phone/common_area_phones/{commonAreaPhoneId}',
  });
};

/**
 * Update common area phone
 * A common area phone can be provisioned by a Zoom account owner or a Zoom admin so that anyone in an organization can use it. For example, if your office has shared desks that don't belong to a specific employees, you could add a common area phone so that any person can use it.<br> Use this API to update details on a specific [common area phone](https://support.zoom.us/hc/en-us/articles/360028516231-Managing-Common-Area-Phones) in an account.<br><br>**Prerequisites:**<br>
 * * Pro or a higher account with Zoom Phone license.
 * * Account owner or admin permissions.
 * * [Supported device](https://support.zoom.us/hc/en-us/articles/360001299063-Zoom-Voice-Supported-Devices)<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const updateCommonAreaPhone = <ThrowOnError extends boolean = false>(
  options: Options<UpdateCommonAreaPhoneData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateCommonAreaPhoneResponse, UpdateCommonAreaPhoneError, ThrowOnError>({
    ...options,
    url: '/phone/common_area_phones/{commonAreaPhoneId}',
  });
};

/**
 * Change main company number
 * The [main company number](https://support.zoom.us/hc/en-us/articles/360028553691) can be used by external callers to reach your phone users (by dialing the main company number and the user's extension). It can also be used by phone users in your account as their caller ID while making calls.<br><br> Use this API to [change the main company number](https://support.zoom.us/hc/en-us/articles/360028553691#h_82414c34-9df2-428a-85a4-efcf7f9e0d72) of an account.<br><br>
 * **Prerequisites:**<br>
 * * Pro or higher account plan.
 * * Account owner or admin permissions<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const changeMainCompanyNumber = <ThrowOnError extends boolean = false>(
  options?: Options<ChangeMainCompanyNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<ChangeMainCompanyNumberResponse, ChangeMainCompanyNumberError, ThrowOnError>({
    ...options,
    url: '/phone/company_number',
  });
};

/**
 * List devices
 * List all the [desk phone devices](https://support.zoom.us/hc/en-us/articles/360021119092) that are configured with Zoom Phone on an account. To view devices that have not yet been assigned to a user, set the value of the `type` query parameter as `unassigned` and to view devices that have been assigned, set the value as `assigned`.<br><br>
 * **Scopes:** `phone:read:admin`
 * <br>
 * **Prerequisites:**<br>
 * * Pro or a higher account with Zoom Phone license
 * * Account owner or admin permissions<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listPhoneDevices = <ThrowOnError extends boolean = false>(
  options: Options<ListPhoneDevicesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPhoneDevicesResponse, ListPhoneDevicesError, ThrowOnError>({
    ...options,
    url: '/phone/devices',
  });
};

/**
 * Add a device
 * By default, all Zoom Phone users can make and receive calls using the Zoom desktop and mobile applications. Additionally, if a desk phone is required, use this API to [add a desk phone and assign it](https://support.zoom.us/hc/en-us/articles/360021119092#h_5ca07504-68a8-4c3d-ad0e-c1d3594436da) to a user.
 *
 * **Prerequisites:**<br>
 * * Pro or a higher account with Zoom Phone license
 * * Account owner or admin permissions
 * * [Supported device](https://support.zoom.us/hc/en-us/articles/360001299063-Zoom-Voice-Supported-Devices)<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const addPhoneDevice = <ThrowOnError extends boolean = false>(
  options?: Options<AddPhoneDeviceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddPhoneDeviceResponse, AddPhoneDeviceError, ThrowOnError>({
    ...options,
    url: '/phone/devices',
  });
};

/**
 * Delete a device
 * Remove a [desk phone device](https://support.zoom.us/hc/en-us/articles/360021119092) from the Zoom Phone System Management.<br><br>
 * **Prerequisites:**<br>
 * * Pro or a higher account with Zoom Phone license
 * * Account owner or admin permissions
 * * Device must not have been assigned to a user.<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deleteAdevice = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAdeviceData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAdeviceResponse, DeleteAdeviceError, ThrowOnError>({
    ...options,
    url: '/phone/devices/{deviceId}',
  });
};

/**
 * Get device details
 * Get detailed information about a specific [desk phone device](https://support.zoom.us/hc/en-us/articles/360021119092).<br><br>
 * **Prerequisites:**<br>
 * * Pro or a higher account with Zoom Phone license
 * * Account owner or admin permissions<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const getAdevice = <ThrowOnError extends boolean = false>(options: Options<GetAdeviceData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetAdeviceResponse, GetAdeviceError, ThrowOnError>({
    ...options,
    url: '/phone/devices/{deviceId}',
  });
};

/**
 * Update a device
 * Update information of a [desk phone device](https://support.zoom.us/hc/en-us/articles/360021119092).<br><br>
 * **Prerequisites:**<br>
 * * Pro or a higher account with Zoom Phone license
 * * Account owner or admin permissions<br>
 * **Scopes:** `phone:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const updateAdevice = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAdeviceData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateAdeviceResponse, UpdateAdeviceError, ThrowOnError>({
    ...options,
    url: '/phone/devices/{deviceId}',
  });
};

/**
 * List call logs
 * Call logs provide a record of all incoming and outgoing calls over Zoom Phone in an account.
 *
 * Use this API to list monthly call logs metrics. You can use query parameters to filter the response by date, site and MOS(Mean Opinion Score) of the call.
 *
 * **Prerequisites:**
 * * Business, or Education account
 * * Zoom Phone license <br><br>
 *
 * **Scopes:** `phone:read:admin`, `phone:write:admin`<br>
 * **Rate Limit Label:** `Heavy`
 */
export const listCallLogsMetrics = <ThrowOnError extends boolean = false>(
  options?: Options<ListCallLogsMetricsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListCallLogsMetricsResponse, ListCallLogsMetricsError, ThrowOnError>({
    ...options,
    url: '/phone/metrics/call_logs',
  });
};

/**
 * Get call QoS
 * Get call quality of service(QoS) data for a call made or received by a Zoom phone user in the account.
 *
 * **Prerequisites:**
 * * Business, or Education account
 * * Zoom Phone license <br><br>
 * **Scopes:** `phone:read:admin`, `phone:write:admin`<br>
 * **Rate Limit Label:** `Light`
 */
export const getCallQoS = <ThrowOnError extends boolean = false>(options: Options<GetCallQoSData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetCallQoSResponse, GetCallQoSError, ThrowOnError>({
    ...options,
    url: '/phone/metrics/call_logs/{callId}/qos',
  });
};

/**
 * Get call details from call log
 * Call logs provide a record of all incoming and outgoing calls over Zoom Phone in an account.
 *
 * Use this API to list call log details of a specific call.
 *
 * **Prerequisites:**
 * * Business, or Education account
 * * Zoom Phone license <br><br>
 *
 * **Scopes:** `phone:read:admin`, `phone:write:admin`<br>
 * **Rate Limit Label:** `Light`
 *
 */
export const getCallLogMetricsDetails = <ThrowOnError extends boolean = false>(
  options: Options<GetCallLogMetricsDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCallLogMetricsDetailsResponse, GetCallLogMetricsDetailsError, ThrowOnError>(
    {
      ...options,
      url: '/phone/metrics/call_logs/{call_id}',
    },
  );
};

/**
 * List phone numbers
 * A Zoom account owner or admin can purchase phone numbers and assign them to Zoom phone users. Use this API to list all Zoom Phone numbers in a Zoom account. You can filter the response based on your needs by using query parameters.
 *
 * **Prerequisites:**<br>
 * * Pro or higher plan with Zoom phone license<br>
 * **Scope:** `phone:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listAccountPhoneNumbers = <ThrowOnError extends boolean = false>(
  options?: Options<ListAccountPhoneNumbersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListAccountPhoneNumbersResponse, ListAccountPhoneNumbersError, ThrowOnError>({
    ...options,
    url: '/phone/numbers',
  });
};

/**
 * Get phone number details
 * A Zoom account owner or admin can purchase phone numbers and assign them to Zoom phone users. Use this API to get details on a specific Phone number in a Zoom account.<br><br>
 * **Prerequisites:**<br>
 * * Pro or higher plan with Zoom phone license<br>
 * **Scope:** `phone:read:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const getPhoneNumberDetails = <ThrowOnError extends boolean = false>(
  options: Options<GetPhoneNumberDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPhoneNumberDetailsResponse, GetPhoneNumberDetailsError, ThrowOnError>({
    ...options,
    url: '/phone/numbers/{numberId}',
  });
};

/**
 * Update phone number details
 * Update phone number details.
 *
 * **Scopes:**
 * * `phone:write` `phone:write:admin`
 * * `phone:master`
 *
 * **Prerequisite:**
 * * Paid account
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const updatePhoneNumberDetails = <ThrowOnError extends boolean = false>(
  options: Options<UpdatePhoneNumberDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdatePhoneNumberDetailsResponse,
    UpdatePhoneNumberDetailsError,
    ThrowOnError
  >({
    ...options,
    url: '/phone/numbers/{numberId}',
  });
};

/**
 * Get call recordings
 * List [call recordings](https://support.zoom.us/hc/en-us/articles/360038521091-Accessing-and-sharing-call-recordings) of an account.<br>
 *
 * **Scopes:**<br>
 * * `phone:read:admin` `phone:write:admin`
 *
 * **Prerequisties:** <br>
 * * Pro or higher account with Zoom Phone license.
 * * Account owner or admin privileges.
 *
 *
 */
export const getPhoneRecordings = <ThrowOnError extends boolean = false>(
  options?: Options<GetPhoneRecordingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPhoneRecordingsResponse, GetPhoneRecordingsError, ThrowOnError>({
    ...options,
    url: '/phone/recordings',
  });
};

/**
 * Get operation logs report
 * The **Phone System operation logs report** allows account owners and admins to view monthly Zoom phone related admin operation details.
 *
 * Use this API to retrieve the **Phone System Operation Logs Report**. Account owners and admins can also access this information by logging into their Zoom accounts and navigating to [Phone System Operation Logs](https://zoom.us/pbx/page/report/operations#/report/operation-logs).<br><br> **Scopes:** `phone:read:admin`, `phone:write:admin` <br> **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * <br> **Prerequisites:** <br>
 * * Account must be enrollled in Pro or a higher plan
 * * Account must be enrolled in a [Zoom Phone](https://zoom.us/pricing/zoom-phone) plan
 *
 *
 */
export const getPsOperationLogs = <ThrowOnError extends boolean = false>(
  options?: Options<GetPsOperationLogsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPsOperationLogsResponse, GetPsOperationLogsError, ThrowOnError>({
    ...options,
    url: '/phone/reports/operationlogs',
  });
};

/**
 * List setting templates
 * This API lets you retrieve a list of all the phone template settings previously created.
 * <br>
 * **Scope**:<br>
 * * `phone:read:admin` or `phone:read`
 * <br>**Prerequisites**: <br>
 * 1. Business or enterprise Account
 * 2. A Zoom Phone license
 *
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const listSettingTemplates = <ThrowOnError extends boolean = false>(
  options?: Options<ListSettingTemplatesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListSettingTemplatesResponse, ListSettingTemplatesError, ThrowOnError>({
    ...options,
    url: '/phone/setting_templates',
  });
};

/**
 * Add a setting template
 * This API lets you create a Zoom Phone setting template for an account. Template type includes **User**, **Auto Receptionist**, or **Call Queue**. Settings include profile, policy and user settings. After creating a phone template, the settings defined via this request will become the default settings for an account.
 * <br><br>
 * **Scope**:
 * * `phone:write:admin` `phone:write`
 *
 *
 * **Prerequisites**:
 * 1. Business or enterprise Zoom account
 * 2. A Zoom Phone license
 *
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 * <br>
 */
export const addSettingTemplate = <ThrowOnError extends boolean = false>(
  options?: Options<AddSettingTemplateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddSettingTemplateResponse, AddSettingTemplateError, ThrowOnError>({
    ...options,
    url: '/phone/setting_templates',
  });
};

/**
 * Get setting template details
 * This API lets you retrieve a specific account phone template previously created. <br>
 *
 * **Scope**: <br>
 * * `phone:write:admin` or `phone:write`
 *
 * **Prerequisites**: <br>
 * 1. Business or Enterprise Account
 * 2. A Zoom Phone license
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const getSettingTemplate = <ThrowOnError extends boolean = false>(
  options: Options<GetSettingTemplateData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetSettingTemplateResponse, GetSettingTemplateError, ThrowOnError>({
    ...options,
    url: '/phone/setting_templates/{templateId}',
  });
};

/**
 * Update a setting template
 * Use this API to update or modify profile settings for the phone template. Template type includes **User**, **Auto Receptionist**, or **Call Queue**. After you've modified a template, click **User Settings** to set up settings for Call Handling, Desk Phone, and Others. <br>
 *
 * **Scope**:<br>
 * * `phone:write:admin` or `phone:write`
 *
 * **Prerequisites**: <br>
 * 1. Business or Enterprise Account
 * 2. A Zoom Phone license
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const updateSettingTemplate = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSettingTemplateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateSettingTemplateResponse, UpdateSettingTemplateError, ThrowOnError>({
    ...options,
    url: '/phone/setting_templates/{templateId}',
  });
};

/**
 * List shared line groups
 * A [shared line group](https://support.zoom.us/hc/en-us/articles/360038850792) allows Zoom Phone admins to share a phone number and extension with a group of phone users or common area phones. This gives members of the shared line group access to the group's direct phone number and voicemail. Use this API to list all the Shared Line Groups.
 *
 * **Prerequisties:** <br>
 * * Pro or higher account with Zoom Phone license.
 * * Account owner or admin privileges  <br>
 *
 * **Scopes:** `phone:read:admin`, `phone:write:admin`
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listSharedLineGroups = <ThrowOnError extends boolean = false>(
  options?: Options<ListSharedLineGroupsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListSharedLineGroupsResponse, ListSharedLineGroupsError, ThrowOnError>({
    ...options,
    url: '/phone/shared_line_groups',
  });
};

/**
 * Create a shared line group
 * A [shared line group](https://support.zoom.us/hc/en-us/articles/360038850792) allows Zoom Phone admins to share a phone number and extension with a group of phone users or common area phones. This gives members of the shared line group access to the group's direct phone number and voicemail. Use this API to create a shared line group.
 *
 * **Prerequisties:** <br>
 * * Pro or higher account with Zoom Phone license.
 * * Account owner or admin privileges
 *
 * **Scopes:** `phone:write:admin`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const createAsharedLineGroup = <ThrowOnError extends boolean = false>(
  options?: Options<CreateAsharedLineGroupData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateAsharedLineGroupResponse, CreateAsharedLineGroupError, ThrowOnError>({
    ...options,
    url: '/phone/shared_line_groups',
  });
};

/**
 * Delete a shared line group
 * A [shared line group](https://support.zoom.us/hc/en-us/articles/360038850792) allows Zoom Phone admins to share a phone number and extension with a group of phone users or common area phones. Use this API to delete a Shared Line Group.
 * **Prerequisties:** <br>
 * * Pro or higher account with Zoom Phone license.
 * * Account owner or admin privileges
 *
 * **Scopes:** `phone:write:admin`
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deleteAsharedLineGroup = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAsharedLineGroupData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAsharedLineGroupResponse, DeleteAsharedLineGroupError, ThrowOnError>({
    ...options,
    url: '/phone/shared_line_groups/{sharedLineGroupId}',
  });
};

/**
 * Get a shared line group
 * A [shared line group](https://support.zoom.us/hc/en-us/articles/360038850792) allows Zoom Phone admins to share a phone number and extension with a group of phone users or common area phones. This gives members of the shared line group access to the group's direct phone number and voicemail. Use this API to list all the Shared Line Groups.
 *
 * **Prerequisties:** <br>
 * * Pro or higher account with Zoom Phone license.
 * * Account owner or admin privileges
 *
 * **Scopes:** `phone:read:admin` or `phone:write:admin`
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const getAsharedLineGroup = <ThrowOnError extends boolean = false>(
  options: Options<GetAsharedLineGroupData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAsharedLineGroupResponse, GetAsharedLineGroupError, ThrowOnError>({
    ...options,
    url: '/phone/shared_line_groups/{sharedLineGroupId}',
  });
};

/**
 * Update a shared line group
 * A [shared line group](https://support.zoom.us/hc/en-us/articles/360038850792) allows Zoom Phone admins to share a phone number and extension with a group of phone users or common area phones. This gives members of the shared line group access to the group's direct phone number and voicemail. Use this API to update information of a Shared Line Group.
 * **Prerequisties:** <br>
 * * Pro or higher account with Zoom Phone license.
 * * Account owner or admin privileges
 *
 * **Scopes:** `phone:write:admin`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const updateAsharedLineGroup = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAsharedLineGroupData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateAsharedLineGroupResponse, UpdateAsharedLineGroupError, ThrowOnError>({
    ...options,
    url: '/phone/shared_line_groups/{sharedLineGroupId}',
  });
};

/**
 * Unassign members of a shared line group
 * Members of the [shared line group](https://support.zoom.us/hc/en-us/articles/360038850792) have access to the group's phone number and voicemail. Use this API to unassign **all** the existing members from a Shared Line Group.
 * **Prerequisties:** <br>
 * * Pro or higher account with Zoom Phone license.
 * * A valid Shared Line Group
 * * Account owner or admin privileges
 *
 * **Scopes:** `phone:write:admin`
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deleteMembersOfSlg = <ThrowOnError extends boolean = false>(
  options: Options<DeleteMembersOfSlgData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteMembersOfSlgResponse, DeleteMembersOfSlgError, ThrowOnError>({
    ...options,
    url: '/phone/shared_line_groups/{sharedLineGroupId}/members',
  });
};

/**
 * Add members to a shared line group
 * A [shared line group](https://support.zoom.us/hc/en-us/articles/360038850792) allows Zoom Phone admins to share a phone number and extension with a group of phone users or common area phones. This gives members of the shared line group access to the group's direct phone number and voicemail. Use this API to [add members](https://support.zoom.us/hc/en-us/articles/360038850792-Setting-up-shared-line-groups#h_7cb42370-48f6-4a8f-84f4-c6eee4d9f0ca) to a Shared Line Group. Note that a member can only be added to one shared line group.
 *
 * **Prerequisties:** <br>
 * * Pro or higher account with Zoom Phone license.
 * * A valid Shared Line Group
 * * Account owner or admin privileges
 *
 * **Scopes:** `phone:write:admin`
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const addMembersToSharedLineGroup = <ThrowOnError extends boolean = false>(
  options: Options<AddMembersToSharedLineGroupData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AddMembersToSharedLineGroupResponse,
    AddMembersToSharedLineGroupError,
    ThrowOnError
  >({
    ...options,
    url: '/phone/shared_line_groups/{sharedLineGroupId}/members',
  });
};

/**
 * Unassign a member from a shared line group
 * Members of the [shared line group](https://support.zoom.us/hc/en-us/articles/360038850792) have access to the group's phone number and voicemail. Use this API to unassign **a specific member** from a Shared Line Group.
 * **Prerequisties:** <br>
 * * Pro or higher account with Zoom Phone license.
 * * A valid Shared Line Group
 * * Account owner or admin privileges
 *
 * **Scopes:** `phone:write:admin`
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deleteAmemberSlg = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAmemberSlgData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAmemberSlgResponse, DeleteAmemberSlgError, ThrowOnError>({
    ...options,
    url: '/phone/shared_line_groups/{sharedLineGroupId}/members/{memberId}',
  });
};

/**
 * Assign phone numbers
 * Use this API to assign phone numbers to a shared line groups. These direct phone numbers will be shared among members of the [shared line group](https://support.zoom.us/hc/en-us/articles/360038850792-Setting-up-shared-line-groups).
 * **Prerequisties:** <br>
 * * Pro or higher account with Zoom Phone license.
 * * A valid Shared Line Group
 * * Account owner or admin privileges
 *
 * **Scopes:** `phone:write:admin`
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const assignPhoneNumbersSlg = <ThrowOnError extends boolean = false>(
  options: Options<AssignPhoneNumbersSlgData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AssignPhoneNumbersSlgResponse, AssignPhoneNumbersSlgError, ThrowOnError>({
    ...options,
    url: '/phone/shared_line_groups/{sharedLineGroupId}/phone_numbers',
  });
};

/**
 * Unassign a phone number
 * Use this API to unassign a specific phone number that was assigned to the [shared line group](https://support.zoom.us/hc/en-us/articles/360038850792-Setting-up-shared-line-groups).
 * **Prerequisties:** <br>
 * * Pro or higher account with Zoom Phone license.
 * * A valid Shared Line Group
 * * Account owner or admin privileges
 *
 * **Scopes:** `phone:write:admin`
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deleteAphoneNumberSlg = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAphoneNumberSlgData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAphoneNumberSlgResponse, DeleteAphoneNumberSlgError, ThrowOnError>({
    ...options,
    url: '/phone/shared_line_groups/{sharedLineGroupId}/phone_numbers/{phoneNumberId}',
  });
};

/**
 * List BYOC SIP trunks
 * List [BYOC SIP trunks](https://zoom.us/docs/doc/Zoom-Bring%20Your%20Own%20Carrier.pdf) that are assigned to an account.
 *
 * **Scopes**:<br>
 * * `phone:write:admin` or `phone:master`<br>
 *
 * **Prerequisites**:<br>
 * * Business or Enterprise Account
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const listByocsipTrunk = <ThrowOnError extends boolean = false>(
  options?: Options<ListByocsipTrunkData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListByocsipTrunkResponse, ListByocsipTrunkError, ThrowOnError>({
    ...options,
    url: '/phone/sip_trunk/trunks',
  });
};

/**
 * List phone sites
 * Sites allow you to organize Zoom Phone users in your organization. Use this API to list all the [sites](https://support.zoom.us/hc/en-us/articles/360020809672) that have been created for an account.<br>
 * **Prerequisites:**<br>
 * * Multiple Sites must be [enabled](https://support.zoom.us/hc/en-us/articles/360020809672-Managing-Multiple-Sites#h_05c88e35-1593-491f-b1a8-b7139a75dc15).
 * * Pro or a higher account with Zoom Phone enabled.
 *
 * **Scope:** `phone:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listPhoneSites = <ThrowOnError extends boolean = false>(
  options?: Options<ListPhoneSitesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPhoneSitesResponse, ListPhoneSitesError, ThrowOnError>({
    ...options,
    url: '/phone/sites',
  });
};

/**
 * Create a phone site
 * Sites allow you to organize Zoom Phone users in your organization. Use this API to create a [Site](https://support.zoom.us/hc/en-us/articles/360020809672).<br>
 * **Prerequisites:**<br>
 * * Multiple Sites must be [enabled](https://support.zoom.us/hc/en-us/articles/360020809672-Managing-Multiple-Sites#h_05c88e35-1593-491f-b1a8-b7139a75dc15).
 * * Pro or a higher account with Zoom Phone enabled.
 * **Scope:** `phone:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const createPhoneSite = <ThrowOnError extends boolean = false>(
  options?: Options<CreatePhoneSiteData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreatePhoneSiteResponse, CreatePhoneSiteError, ThrowOnError>({
    ...options,
    url: '/phone/sites',
  });
};

/**
 * Delete a phone site
 * Sites allow you to organize Zoom Phone users in your organization. Use this API to delete a specific [site](https://support.zoom.us/hc/en-us/articles/360020809672) in a Zoom account. To delete a site, in the query parameter, you must provide the Site ID of another site where the assets of current site (users, numbers and phones) can be transferred to.  You cannot use this API to delete the main site.
 *
 * **Prerequisites:** <br>
 * * Account must have a Pro or a higher plan with Zoom Phone license.
 * * [Multiple Sites](https://support.zoom.us/hc/en-us/articles/360020809672-Managing-Multiple-Sites) must be enabled.<br>
 * **Scope:** `phone:write:admin`
 * <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const deletePhoneSite = <ThrowOnError extends boolean = false>(
  options: Options<DeletePhoneSiteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeletePhoneSiteResponse, DeletePhoneSiteError, ThrowOnError>({
    ...options,
    url: '/phone/sites/{siteId}',
  });
};

/**
 * Get phone site details
 * Sites allow you to organize Zoom Phone users in your organization. Use this API to get information about a specific [site](https://support.zoom.us/hc/en-us/articles/360020809672).
 *
 *
 * **Prerequisites:** <br>
 * * Account must have a Pro or a higher plan with Zoom Phone license.
 * * Multiple Sites must be [enabled](https://support.zoom.us/hc/en-us/articles/360020809672-Managing-Multiple-Sites#h_05c88e35-1593-491f-b1a8-b7139a75dc15).<br>
 * **Scope:** `phone:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const getAsite = <ThrowOnError extends boolean = false>(options: Options<GetAsiteData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetAsiteResponse, GetAsiteError, ThrowOnError>({
    ...options,
    url: '/phone/sites/{siteId}',
  });
};

/**
 * Update phone site details
 * Sites allow you to organize Zoom Phone users in your organization. Use this API to update information about a specific [site](https://support.zoom.us/hc/en-us/articles/360020809672).
 *
 *
 * **Prerequisites:** <br>
 * * Account must have a Pro or a higher plan with Zoom Phone license.
 * * **Scope:** `phone:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const updateSiteDetails = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSiteDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateSiteDetailsResponse, UpdateSiteDetailsError, ThrowOnError>({
    ...options,
    url: '/phone/sites/{siteId}',
  });
};

/**
 * List phone users
 * List all the users on an account who have been assigned Zoom Phone licenses.<br><br>
 * **Prerequisites:**<br>
 * * Pro or higher plan with Zoom phone license<br>
 * **Scope:** `phone:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const listPhoneUsers = <ThrowOnError extends boolean = false>(
  options?: Options<ListPhoneUsersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPhoneUsersResponse, ListPhoneUsersError, ThrowOnError>({
    ...options,
    url: '/phone/users',
  });
};

/**
 * Get user's profile
 * Retrieve a user's [zoom phone](https://support.zoom.us/hc/en-us/articles/360001297663-Quickstart-Guide-for-Zoom-Phone-Administrators) profile.
 *
 * **Scopes:** `phone:read`, `phone:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 * **Prerequisites** :
 * 1. Business or Enterprise account
 * 2. A Zoom Phone license
 */
export const phoneUser = <ThrowOnError extends boolean = false>(options: Options<PhoneUserData, ThrowOnError>) => {
  return (options?.client ?? client).get<PhoneUserResponse, PhoneUserError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}',
  });
};

/**
 * Update user's profile
 * Update a [Zoom Phone](https://support.zoom.us/hc/en-us/categories/360001370051-Zoom-Phone) user's profile.
 *
 * **Scopes:** `phone:write` `phone:write:admin`  <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisite:**
 * 1. Business or Enterprise account
 * 2. A Zoom Phone license
 */
export const updateUserProfile = <ThrowOnError extends boolean = false>(
  options: Options<UpdateUserProfileData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateUserProfileResponse, UpdateUserProfileError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}',
  });
};

/**
 * Get user's call logs
 * Retrieve a [zoom phone](https://support.zoom.us/hc/en-us/articles/360001297663-Quickstart-Guide-for-Zoom-Phone-Administrators) user's call logs.
 *
 * **Scopes:** `phone:read`, `phone:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisite:**
 * 1. Business or Enterprise account
 * 2. A Zoom Phone license
 */
export const phoneUserCallLogs = <ThrowOnError extends boolean = false>(
  options: Options<PhoneUserCallLogsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<PhoneUserCallLogsResponse, PhoneUserCallLogsError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}/call_logs',
  });
};

/**
 * Delete a user's call log
 * Delete a user's [call log](https://support.zoom.us/hc/en-us/articles/360021114452-Viewing-and-identifying-logs).
 *
 * **Scopes:** `phone:write`, `phone:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 * **Prerequisites:**
 * 1. User must belong to a Business or an Enterprise account.
 * 2. User must hold a Zoom Phone license.
 */
export const deleteCallLog = <ThrowOnError extends boolean = false>(
  options: Options<DeleteCallLogData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteCallLogResponse, DeleteCallLogError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}/call_logs/{callLogId}',
  });
};

/**
 * Assign calling plan to a user
 * Assign [calling plan](https://marketplace.zoom.us/docs/api-reference/other-references/plans#zoom-phone-calling-plans) to a [Zoom Phone](https://support.zoom.us/hc/en-us/categories/360001370051-Zoom-Phone) user.
 *
 * **Scopes**: `phone:write` `phone:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisite:**
 * 1. Business or Enterprise account
 * 2. A Zoom Phone license
 *
 *
 */
export const assignCallingPlan = <ThrowOnError extends boolean = false>(
  options: Options<AssignCallingPlanData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AssignCallingPlanResponse, AssignCallingPlanError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}/calling_plans',
  });
};

/**
 * Unassign user's calling plan
 * Unassign a [calling plan](https://marketplace.zoom.us/docs/api-reference/other-references/plans#zoom-phone-calling-plans) that was previously assigned to a [Zoom Phone](https://support.zoom.us/hc/en-us/categories/360001370051) user.
 *
 * **Scopes**: `phone:write` `phone:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisite:**
 * 1. Business or Enterprise account
 * 2. A Zoom Phone license
 */
export const unassignCallingPlan = <ThrowOnError extends boolean = false>(
  options: Options<UnassignCallingPlanData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UnassignCallingPlanResponse, UnassignCallingPlanError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}/calling_plans/{type}',
  });
};

/**
 * Assign phone number to user
 * Assign a [phone number](https://support.zoom.us/hc/en-us/articles/360020808292-Managing-Phone-Numbers) to a user who has already enabled Zoom Phone.
 *
 * **Scopes**: `phone:write` `phone:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisite:**
 * 1. Business or Enterprise account
 * 2. A Zoom Phone license
 */
export const assignPhoneNumber = <ThrowOnError extends boolean = false>(
  options: Options<AssignPhoneNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AssignPhoneNumberResponse, AssignPhoneNumberError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}/phone_numbers',
  });
};

/**
 * Unassign phone number
 * Unassign [phone number](https://support.zoom.us/hc/en-us/articles/360020808292-Managing-Phone-Numbers#h_38ba8b01-26e3-4b1b-a9b5-0717c00a7ca6) of a Zoom phone user. <br>
 *
 * After assigning a phone number, you can remove it if you don't want it to be assigned to anyone.
 *
 * **Scopes**: `phone:write` `phone:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisite:**
 * 1. Business or Enterprise account
 * 2. A Zoom Phone license
 * 3. User must have been previously assigned a Zoom Phone number.
 */
export const unassignPhoneNumber = <ThrowOnError extends boolean = false>(
  options: Options<UnassignPhoneNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UnassignPhoneNumberResponse, UnassignPhoneNumberError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}/phone_numbers/{phoneNumberId}',
  });
};

/**
 * Get user's recordings
 * Retrieve a user's zoom [phone recordings](https://support.zoom.us/hc/en-us/articles/360021336671-Viewing-Call-History-and-Recordings).
 * **Scopes:** `phone:read`, `phone:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 * **Prerequisite:**
 * 1. Business or Enterprise account
 * 2. A Zoom Phone license
 */
export const phoneUserRecordings = <ThrowOnError extends boolean = false>(
  options: Options<PhoneUserRecordingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<PhoneUserRecordingsResponse, PhoneUserRecordingsError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}/recordings',
  });
};

/**
 * Get user's settings
 * Retrieve a user's zoom phone profile [settings](https://support.zoom.us/hc/en-us/articles/360021325712-Configuring-Settings).
 *
 * **Scopes:** `phone:read`, `phone:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisite:**
 * 1. Business or Enterprise account
 * 2. A Zoom Phone license
 */
export const phoneUserSettings = <ThrowOnError extends boolean = false>(
  options: Options<PhoneUserSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<PhoneUserSettingsResponse, PhoneUserSettingsError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}/settings',
  });
};

/**
 * Remove shared access
 * Remove the shared voicemail access settings that were previously assigned to a user.
 *
 * To view these settings in your Zoom web portal, navigate to **Admin >Phone System Management> Users & Rooms**. Click the **Users** tab and select **User Settings**. Scroll down to **Voicemail & Call Recordings**.<br>
 *
 * **Scope**: `phone:write:admin`<br><br>
 * **Prerequisites**:<br>
 * * Business or enterprise Account<br>
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const deleteUserSetting = <ThrowOnError extends boolean = false>(
  options: Options<DeleteUserSettingData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteUserSettingResponse, DeleteUserSettingError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}/settings/{settingType}',
  });
};

/**
 * Update shared access
 * Phone users can access [shared voicemail inboxes](https://support.zoom.us/hc/en-us/articles/360033863991-Sharing-and-controlling-access-to-a-voicemail-inbox) in the Zoom desktop client, web portal, or provisioned desk phone. Use this API to update the voicemail access permissions of a user.
 *
 * To view these settings in the Zoom web portal, navigate to **Admin >Phone System Management> Users & Rooms**. Click the **Users** tab and select **User Settings**. Scroll down to **Voicemail & Call Recordings**.<br>
 *
 * **Scope**: <br>`phone:write:admin`<br>
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 *
 * **Prerequisites**:<br>
 * Business or Enterprise Account
 */
export const updateUserSetting = <ThrowOnError extends boolean = false>(
  options: Options<UpdateUserSettingData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateUserSettingResponse, UpdateUserSettingError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}/settings/{settingType}',
  });
};

/**
 * Set up shared access
 * Phone users can access [shared voicemail inboxes](https://support.zoom.us/hc/en-us/articles/360033863991-Sharing-and-controlling-access-to-a-voicemail-inbox) in the Zoom desktop client, web portal, or provisioned desk phone. Use this API to define the voicemail access permissions of a user.
 *
 * To view these settings in the Zoom web portal, navigate to **Admin >Phone System Management> Users & Rooms**. Click the **Users** tab and select **User Settings**. Scroll down to **Voicemail & Call Recordings**.<br>
 *
 * **Scope**:`phone:write:admin`<br>
 * <br>**[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 *
 * **Prerequisites**: <br>
 * Business or Enterprise Account
 */
export const addUserSetting = <ThrowOnError extends boolean = false>(
  options: Options<AddUserSettingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddUserSettingResponse, AddUserSettingError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}/settings/{settingType}',
  });
};

/**
 * Get user's voicemails
 * Retrieve a user's Zoom Phone voicemails.
 *
 * **Scopes:** `phone:read`, `phone:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 * **Prerequisite:**
 * 1. Business or Enterprise account
 * 2. A Zoom Phone license
 */
export const phoneUserVoiceMails = <ThrowOnError extends boolean = false>(
  options: Options<PhoneUserVoiceMailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<PhoneUserVoiceMailsResponse, PhoneUserVoiceMailsError, ThrowOnError>({
    ...options,
    url: '/phone/users/{userId}/voice_mails',
  });
};

/**
 * Delete a voicemail
 * Delete a [voicemail message](https://support.zoom.us/hc/en-us/articles/360021400211-Managing-voicemail-messages) from a Zoom account.
 *
 * **Scope:** `phone:write:admin` or `phone:write`
 *
 *
 * **Prerequisite**:
 * * The account must have activted Zoom Phone license.
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 *
 */
export const deleteVoicemail = <ThrowOnError extends boolean = false>(
  options: Options<DeleteVoicemailData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteVoicemailResponse, DeleteVoicemailError, ThrowOnError>({
    ...options,
    url: '/phone/voice_mails/{voicemailId}',
  });
};

/**
 * Get sign In / sign out activity report
 * Retrieve a list of sign in / sign out activity logs [report](https://support.zoom.us/hc/en-us/articles/201363213-Getting-Started-with-Reports) of users under a Zoom account.<br>
 * **Prerequisites**<br>
 * * Pro or higher plan.<br>
 * **Scopes:** `report:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`
 */
export const reportSignInSignOutActivities = <ThrowOnError extends boolean = false>(
  options?: Options<ReportSignInSignOutActivitiesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ReportSignInSignOutActivitiesResponse,
    ReportSignInSignOutActivitiesError,
    ThrowOnError
  >({
    ...options,
    url: '/report/activities',
  });
};

/**
 * Get cloud recording usage report
 * Retrieve cloud recording usage report for a specified period. You can only get cloud recording reports that is one day ealier than the current date and for the most recent period of 6 months. The date gap between from and to dates should be smaller or equal to 30 days. <br>
 * **Prerequisites**<br>
 * * Pro or higher plan.<br>
 * **Scopes:** `report:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`
 */
export const reportCloudRecording = <ThrowOnError extends boolean = false>(
  options: Options<ReportCloudRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ReportCloudRecordingResponse, ReportCloudRecordingError, ThrowOnError>({
    ...options,
    url: '/report/cloud_recording',
  });
};

/**
 * Get daily usage report
 * Retrieve daily report to access the account-wide usage of Zoom services for each day in a given month. It lists the number of new users, meetings, participants, and meeting minutes.<br>
 * **Prerequisites**<br>
 * * Pro or higher plan.<br>
 * **Scopes:** `report:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`
 */
export const reportDaily = <ThrowOnError extends boolean = false>(options?: Options<ReportDailyData, ThrowOnError>) => {
  return (options?.client ?? client).get<ReportDailyResponse, ReportDailyError, ThrowOnError>({
    ...options,
    url: '/report/daily',
  });
};

/**
 * Get meeting detail reports
 * Get a detailed report for a past meeting. <br>
 * **Scopes:** `report:read:admin`<br>
 * \
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Pro or a higher plan.<br>
 *
 */
export const reportMeetingDetails = <ThrowOnError extends boolean = false>(
  options: Options<ReportMeetingDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ReportMeetingDetailsResponse, ReportMeetingDetailsError, ThrowOnError>({
    ...options,
    url: '/report/meetings/{meetingId}',
  });
};

/**
 * Get meeting participant reports
 * Get participant report for a past meeting.<br><br>
 * **Scopes:** `report:read:admin`<br>
 * \
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Pro or a higher plan.<br>
 *
 */
export const reportMeetingParticipants = <ThrowOnError extends boolean = false>(
  options: Options<ReportMeetingParticipantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ReportMeetingParticipantsResponse,
    ReportMeetingParticipantsError,
    ThrowOnError
  >({
    ...options,
    url: '/report/meetings/{meetingId}/participants',
  });
};

/**
 * Get meeting poll reports
 * Retrieve a report of [poll](https://support.zoom.us/hc/en-us/articles/213756303-Polling-for-Meetings) results for a past meeting. <br><br>
 * **Scopes:** `report:read:admin`<br>
 * \
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Pro or a higher plan.<br>
 *
 */
export const reportMeetingPolls = <ThrowOnError extends boolean = false>(
  options: Options<ReportMeetingPollsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ReportMeetingPollsResponse, ReportMeetingPollsError, ThrowOnError>({
    ...options,
    url: '/report/meetings/{meetingId}/polls',
  });
};

/**
 * Get operation logs report
 * The [Operations Logs](https://support.zoom.us/hc/en-us/articles/360032748331-Operation-Logs) report allows you to audit admin and user activity, such as adding a new user, changing account settings, and deleting recordings.<br>
 * Use this API to retrieve operation logs report for a specified period of time.<br>
 * **Scopes:** `report:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Pro or higher plan.
 */
export const reportOperationLogs = <ThrowOnError extends boolean = false>(
  options: Options<ReportOperationLogsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ReportOperationLogsResponse, ReportOperationLogsError, ThrowOnError>({
    ...options,
    url: '/report/operationlogs',
  });
};

/**
 * Get telephone reports
 * The [telephone report](https://support.zoom.us/hc/en-us/articles/206514816-Telephone-reports) allows you to view who dialed into meetings via phone (Audio Conferencing or SIP Connected Audio) and which number they dialed into and other details. Use this API to get telephone report for a specified period of time.
 *
 * **Scopes:** `report:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>**Prerequisites:**<br>
 * * Pro or higher plan.
 */
export const reportTelephone = <ThrowOnError extends boolean = false>(
  options: Options<ReportTelephoneData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ReportTelephoneResponse, ReportTelephoneError, ThrowOnError>({
    ...options,
    url: '/report/telephone',
  });
};

/**
 * Get active/inactive host reports
 * A user is considered to be an active host during the month specified in the "from" and "to" range, if the user has hosted at least one meeting during this period. If the user didn't host any meetings during this period, the user is considered to be inactive.<br>The Active Hosts report displays a list of meetings, participants, and meeting minutes for a specific time range, up to one month. The month should fall within the last six months.<br>The Inactive Hosts report pulls a list of users who were not active during a specific period of time.
 * Use this API to retrieve an active or inactive host report for a specified period of time. The time range for the report is limited to a month and the month should fall under the past six months. <br>You can specify the type of report and date range using the query parameters.<br>
 * **Scopes:** `report:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Pro or higher plan.
 */
export const reportUsers = <ThrowOnError extends boolean = false>(options: Options<ReportUsersData, ThrowOnError>) => {
  return (options?.client ?? client).get<ReportUsersResponse, ReportUsersError, ThrowOnError>({
    ...options,
    url: '/report/users',
  });
};

/**
 * Get meeting reports
 * Retrieve [report](https://support.zoom.us/hc/en-us/articles/216378603-Meeting-Reporting) on a past meeting for a specified period of time. The time range for the report is limited to a month and the month should fall under the past six months.
 *
 * Meetings will only be returned in the response if the meeting has two or more unique participants.  <br><br>
 * **Scopes:** `report:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Pro or higher plan.
 */
export const reportMeetings = <ThrowOnError extends boolean = false>(
  options: Options<ReportMeetingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ReportMeetingsResponse, ReportMeetingsError, ThrowOnError>({
    ...options,
    url: '/report/users/{userId}/meetings',
  });
};

/**
 * Get webinar detail reports
 * Retrieve a [report](https://support.zoom.us/hc/en-us/articles/201393719-Webinar-Reporting) containing past webinar details.  <br><br>
 * **Scopes:** `report:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Pro or higher plan with Webinar add-on.
 */
export const reportWebinarDetails = <ThrowOnError extends boolean = false>(
  options: Options<ReportWebinarDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ReportWebinarDetailsResponse, ReportWebinarDetailsError, ThrowOnError>({
    ...options,
    url: '/report/webinars/{webinarId}',
  });
};

/**
 * Get webinar participant reports
 * Get detailed report on each attendee of a webinar.<br><br>
 * **Scopes:** `report:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Pro or a higher plan with Webinar add-on enabled.
 */
export const reportWebinarParticipants = <ThrowOnError extends boolean = false>(
  options: Options<ReportWebinarParticipantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ReportWebinarParticipantsResponse,
    ReportWebinarParticipantsError,
    ThrowOnError
  >({
    ...options,
    url: '/report/webinars/{webinarId}/participants',
  });
};

/**
 * Get webinar poll reports
 * Retrieve a report on past [webinar polls](https://support.zoom.us/hc/en-us/articles/203749865-Polling-for-Webinars).<br><br>
 * **Scopes:** `report:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Pro or a higher plan with Webinar add-on enabled.
 */
export const reportWebinarPolls = <ThrowOnError extends boolean = false>(
  options: Options<ReportWebinarPollsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ReportWebinarPollsResponse, ReportWebinarPollsError, ThrowOnError>({
    ...options,
    url: '/report/webinars/{webinarId}/polls',
  });
};

/**
 * Get webinar Q&A report
 * The Question & Answer (Q&A) feature for webinars allows attendees to ask questions during the webinar and for the panelists, co-hosts and host to answer their questions.
 *
 * Use this API to retrieve a report on question and answers from past webinars. <br><br>
 * **Scopes:** `report:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 * **Prerequisites:**<br>
 * * Pro or a higher plan with Webinar add-on enabled.
 */
export const reportWebinarQa = <ThrowOnError extends boolean = false>(
  options: Options<ReportWebinarQaData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ReportWebinarQaResponse, ReportWebinarQaError, ThrowOnError>({
    ...options,
    url: '/report/webinars/{webinarId}/qa',
  });
};

/**
 * List roles
 * List [roles](https://support.zoom.us/hc/en-us/articles/115001078646-Role-Based-Access-Control) on your account
 *
 * **Scopes:** `role:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 * **Prerequisites** :
 * *  Pro or higher plan.
 * *  For setting the initial role, you must be the Account Owner.
 * *  For subsequent role management, you must be the Account Owner or user with role management permissions.
 */
export const roles = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<RolesResponse, RolesError, ThrowOnError>({
    ...options,
    url: '/roles',
  });
};

/**
 * Create a role
 * Each Zoom user automatically has a role which can either be owner, administrator, or a member.
 *
 * **Pre-requisite:**<br>
 * * Pro or higher plan.
 * * For setting the initial role, you must be the Account Owner.<br>
 * * For subsequent role management, you must be the Account Owner or user with role management permissions.<br>
 * **Scopes:** `role:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const createRole = <ThrowOnError extends boolean = false>(options?: Options<CreateRoleData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateRoleResponse, CreateRoleError, ThrowOnError>({
    ...options,
    url: '/roles',
  });
};

/**
 * Delete a role
 * Each Zoom user automatically has a role which can either be owner, administrator, or a member. Account Owners and users with edit privileges for Role management can add customized roles with a list.
 *
 * Use this API to delete a role.<br>
 * **Pre-requisite:**<br>
 * * A Pro or higher plan.<br>
 * * For role management and updates, you must be the Account Owner or user with role management permissions.
 *
 * **Scopes:** `role:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deleteRole = <ThrowOnError extends boolean = false>(options: Options<DeleteRoleData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteRoleResponse, DeleteRoleError, ThrowOnError>({
    ...options,
    url: '/roles/{roleId}',
  });
};

/**
 * Get role information
 * Each Zoom user automatically has a role which can either be owner, administrator, or a member. Account Owners and users with edit privileges for Role management can add customized roles with a list of privileges.
 *
 * Use this API to get information including specific privileges assigned to a [role](https://support.zoom.us/hc/en-us/articles/115001078646-Role-Based-Access-Control).<br>
 * **Pre-requisite:**<br>
 * * A Pro or higher plan.<br>
 * * For role management and updates, you must be the Account Owner or user with role management permissions.
 *
 * **Scopes:** `role:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const getRoleInformation = <ThrowOnError extends boolean = false>(
  options: Options<GetRoleInformationData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetRoleInformationResponse, GetRoleInformationError, ThrowOnError>({
    ...options,
    url: '/roles/{roleId}',
  });
};

/**
 * Update role information
 * Each Zoom user automatically has a [role](https://support.zoom.us/hc/en-us/articles/115001078646-Role-Based-Access-Control) which can either be owner, administrator, or a member. Account Owners and users with edit privileges for Role management can add customized roles with a list.
 *
 * Use this API to change the privileges, name and description of a specific role.<br>
 * **Pre-requisite:**<br>
 * * A Pro or higher plan.<br>
 * * For role management and updates, you must be the Account Owner or user with role management permissions.<br>**Scopes:** `role:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const updateRole = <ThrowOnError extends boolean = false>(options: Options<UpdateRoleData, ThrowOnError>) => {
  return (options?.client ?? client).patch<UpdateRoleResponse, UpdateRoleError, ThrowOnError>({
    ...options,
    url: '/roles/{roleId}',
  });
};

/**
 * List members in a role
 * User [roles](https://support.zoom.us/hc/en-us/articles/115001078646-Role-Based-Access-Control) can have a set of permissions that allows access only to the pages a user needs to view or edit. Use this API to list all the members that are assigned a specific role.
 *
 * **Scope:** `role:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>**Prerequisites:**<br>
 * * A Pro or a higher plan.
 */
export const roleMembers = <ThrowOnError extends boolean = false>(options: Options<RoleMembersData, ThrowOnError>) => {
  return (options?.client ?? client).get<RoleMembersResponse, RoleMembersError, ThrowOnError>({
    ...options,
    url: '/roles/{roleId}/members',
  });
};

/**
 * Assign a role
 * User [roles](https://support.zoom.us/hc/en-us/articles/115001078646-Role-Based-Access-Control) can have a set of permissions that allows access only to the pages a user needs to view or edit. Use this API to [assign a role](https://support.zoom.us/hc/en-us/articles/115001078646-Role-Based-Access-Control#h_748b6fd8-5057-4cf4-bbfd-787909c09db0) to members.
 *
 * **Scopes:** `role:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 * **Prerequisites:**<br>
 * * A Pro or a higher plan.
 */
export const addRoleMembers = <ThrowOnError extends boolean = false>(
  options: Options<AddRoleMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddRoleMembersResponse, AddRoleMembersError, ThrowOnError>({
    ...options,
    url: '/roles/{roleId}/members',
  });
};

/**
 * Unassign a role
 * User [roles](https://support.zoom.us/hc/en-us/articles/115001078646-Role-Based-Access-Control) can have a set of permissions that allows access only to the pages a user needs to view or edit. Use this API to unassign a user's role.
 *
 * **Scope:** `role:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**<br>
 * * A Pro or a higher plan.
 */
export const roleMemberDelete = <ThrowOnError extends boolean = false>(
  options: Options<RoleMemberDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RoleMemberDeleteResponse, RoleMemberDeleteError, ThrowOnError>({
    ...options,
    url: '/roles/{roleId}/members/{memberId}',
  });
};

/**
 * List Zoom Rooms
 * Zoom Rooms is a software-based room system that provides an integrated experience for audio conferencing, wireless screen sharing and video conferencing. Use this API to list all the existing [Zoom Rooms](https://support.zoom.us/hc/en-us/articles/207483343-Getting-Started-with-Zoom-Rooms) in a Zoom account.<br><br>
 * **Prerequisites:**<br>
 * * Pro or a higher plan with [Zoom Room](https://zoom.us/zoomrooms) license.<br>
 * **Scopes**: `room:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listZoomRooms = <ThrowOnError extends boolean = false>(
  options?: Options<ListZoomRoomsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListZoomRoomsResponse, ListZoomRoomsError, ThrowOnError>({
    ...options,
    url: '/rooms',
  });
};

/**
 * Add a Zoom Room
 * Use this API to [add a Zoom Room](https://support.zoom.us/hc/en-us/articles/202822279-Add-Zoom-Rooms-on-Web-Portal) to a Zoom account.<br><br>
 * **Prerequisites:**<br>
 * * Pro or a higher plan with [Zoom Room](https://zoom.us/zoomrooms) license.<br>
 * **Scopes**: `room:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const addAroom = <ThrowOnError extends boolean = false>(options?: Options<AddAroomData, ThrowOnError>) => {
  return (options?.client ?? client).post<AddAroomResponse, AddAroomError, ThrowOnError>({
    ...options,
    url: '/rooms',
  });
};

/**
 * Get Zoom Room account profile
 * Get details on the account profile of a Zoom Room. This information can only by accessed either by the Zoom Room Account Owner or a user with Zoom Rooms admin permission. To get information on an individual Room Profile, use [Get Zoom Room Profile API](https://marketplace.zoom.us/docs/api-reference/zoom-api/rooms/getzrprofile) instead.
 *
 * **Prerequisites:**<br>
 * * Zoom account owner or Zoom Rooms admin permissions<br>
 *
 * **Scopes:** `room:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const getZrAccountProfile = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetZrAccountProfileResponse, GetZrAccountProfileError, ThrowOnError>({
    ...options,
    url: '/rooms/account_profile',
  });
};

/**
 * Update Zoom Room account profile
 * Update information on the account profile of a Zoom Room. This information can only by accessed either by the Zoom Room Account Owner or a user with Zoom Rooms admin permission. To update information on an individual Room Profile, use [Update Zoom Room Profile API](https://marketplace.zoom.us/docs/api-reference/zoom-api/rooms/updatezrprofile) instead.
 *
 * **Prerequisites:**<br>
 * * Zoom account owner or Zoom Rooms admin permissions<br>
 *
 * **Scopes:** `room:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const updateZrAccProfile = <ThrowOnError extends boolean = false>(
  options?: Options<UpdateZrAccProfileData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateZrAccProfileResponse, UpdateZrAccProfileError, ThrowOnError>({
    ...options,
    url: '/rooms/account_profile',
  });
};

/**
 * Get Zoom Room account settings
 * Get details on Account Settings of a Zoom Room. With this API, you can view either the **Account Meeting Settings** or the **Alert Settings** (Client Alert Settings and Notfication Settings) of the Zoom Rooms account. By default, only **Account Meeting Settings** are returned. To view only **Alert Settings**, specify `alert` as the value of the `setting_type` query parameter.<br><br>
 * **Prerequisites:**<br>
 * * Zoom Room licenses
 * * Owner or Admin privileges on the Zoom Account.<br>
 * **Scopes:** `room:read:admin`<br><br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const getZrAccountSettings = <ThrowOnError extends boolean = false>(
  options: Options<GetZrAccountSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetZrAccountSettingsResponse, GetZrAccountSettingsError, ThrowOnError>({
    ...options,
    url: '/rooms/account_settings',
  });
};

/**
 * Update Zoom Room account settings
 * Update account settings applied for Zoom Rooms in a Zoom account. With this API, you can update either the **Account Meeting Settings** or the **Alert Settings** (Client Alert Settings and Notfication Settings) of the Zoom Rooms account by specifying the required setting type in the `setting_type` parameter. To update only **Alert Settings**, specify `alert` as the value of the `setting_type` query parameter and to update only **Account Meeting Settings**, specify `meeting` as the value of the `setting_type` query parameter.<br><br>
 * **Prerequisites:**<br>
 * * Zoom Room licenses
 * * Owner or Admin privileges on the Zoom Account.<br>
 * **Scopes:** `room:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const updateZoomRoomAccSettings = <ThrowOnError extends boolean = false>(
  options: Options<UpdateZoomRoomAccSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateZoomRoomAccSettingsResponse,
    UpdateZoomRoomAccSettingsError,
    ThrowOnError
  >({
    ...options,
    url: '/rooms/account_settings',
  });
};

/**
 * List digital signage contents
 * List information about existing [Zoom Rooms digital signage](https://support.zoom.us/hc/en-us/articles/360000030683-Zoom-Rooms-digital-signage) content in a Zoom account.<br> You can also access this information by logging into your Zoom account in the Zoom web portal and visiting the [Digital Signage Content](https://zoom.us/digitalsignage#/) page listed under **Room Management**.
 *
 * **Prerequisites:**
 * * Pro or a higher account with Zoom Rooms.
 * * Existing content files or folder in [Digital Signage Content](https://zoom.us/digitalsignage#/) page.
 *
 *
 *
 */
export const listDigitalSignageContent = <ThrowOnError extends boolean = false>(
  options?: Options<ListDigitalSignageContentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListDigitalSignageContentResponse,
    ListDigitalSignageContentError,
    ThrowOnError
  >({
    ...options,
    url: '/rooms/digital_signage',
  });
};

/**
 * Update E911 digital signage
 * Display or hide E911 emergency alert text content from [Zoom Rooms digital signage](https://support.zoom.us/hc/en-us/articles/360000030683-Zoom-Rooms-digital-signage).
 *
 * **Scope:** `room:write:admin`
 *
 * **Prerequisites:**<br>
 * * [Zoom Rooms](https://zoom.us/zoomrooms/software) 5.3.0 or higher
 * * Zoom Rooms digital signage must be [enabled](https://support.zoom.us/hc/en-us/articles/360000030683-Zoom-Rooms-Digital-Signage#h_767fbb33-82a8-45a8-8392-a1bfa9687edd)
 *
 */
export const manageE911Signage = <ThrowOnError extends boolean = false>(
  options?: Options<ManageE911SignageData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<ManageE911SignageResponse, ManageE911SignageError, ThrowOnError>({
    ...options,
    url: '/rooms/events',
  });
};

/**
 * List Zoom Room locations
 * A Zoom account owner or a Zoom Room administrator can establish a [location hierarchy](https://support.zoom.us/hc/en-us/articles/115000342983-Zoom-Rooms-Location-Hierarchy) to help manage Zoom Rooms that are spread among a variety of locations. Use this API to list the different location types used for Zoom Rooms in an account.<br><br>
 * **Prerequisites:**
 * * Account owner or admin permissions.
 * * Zoom Rooms Version 4.0 or higher<br><br>
 * **Scopes:** `room:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listZrLocations = <ThrowOnError extends boolean = false>(
  options?: Options<ListZrLocationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListZrLocationsResponse, ListZrLocationsError, ThrowOnError>({
    ...options,
    url: '/rooms/locations',
  });
};

/**
 * Add a location
 * Add a location to the [location hierarchial structure(s)](https://support.zoom.us/hc/en-us/articles/115000342983-Zoom-Rooms-Location-Hierarchy) of Zoom Rooms in an account.
 *
 * **Prerequisites:**
 * * Account owner or admin permissions.
 * * Zoom Rooms Version 4.0 or higher<br><br>
 * **Scopes:** `room:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const addAzrLocation = <ThrowOnError extends boolean = false>(
  options?: Options<AddAzrLocationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddAzrLocationResponse, AddAzrLocationError, ThrowOnError>({
    ...options,
    url: '/rooms/locations',
  });
};

/**
 * Get Zoom Room location structure
 * Get the [location hierarchial structure(s)](https://support.zoom.us/hc/en-us/articles/115000342983-Zoom-Rooms-Location-Hierarchy) applied on the Zoom Rooms in an account.<br><br>
 * **Prerequisites:**<br>
 * * Zoom Rooms version 4.0 or higher
 * * Account owner or admin permissions<br>
 * **Scopes:** `room:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const getZrLocationStructure = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetZrLocationStructureResponse, GetZrLocationStructureError, ThrowOnError>({
    ...options,
    url: '/rooms/locations/structure',
  });
};

/**
 * Update Zoom Rooms location structure
 * Update the [location hierarchial structure(s)](https://support.zoom.us/hc/en-us/articles/115000342983-Zoom-Rooms-Location-Hierarchy) applied on the Zoom Rooms in an account.<br><br>
 * **Prerequisites:**<br>
 * * Zoom Rooms version 4.0 or higher
 * * Account owner or admin permissions<br>
 * **Scopes:** `room:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const updateZoomRoomsLocationStructure = <ThrowOnError extends boolean = false>(
  options?: Options<UpdateZoomRoomsLocationStructureData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateZoomRoomsLocationStructureResponse,
    UpdateZoomRoomsLocationStructureError,
    ThrowOnError
  >({
    ...options,
    url: '/rooms/locations/structure',
  });
};

/**
 * Get Zoom Room location profile
 * Each location type of the [Zoom Rooms location hierarchy](https://support.zoom.us/hc/en-us/articles/115000342983-Zoom-Rooms-Location-Hierarchy) has a profile page that includes information such as name of the location, address, support email, etc. Use this API to retrieve information about a specific Zoom Rooms location type such as information about the city where the Zoom Rooms is located.
 *
 * **Prerequisite:**<br>
 * * Account owner or admin permission
 * * Zoom Rooms version 4.0 or higher<br>
 * **Scopes:** `room:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const getZrLocationProfile = <ThrowOnError extends boolean = false>(
  options: Options<GetZrLocationProfileData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetZrLocationProfileResponse, GetZrLocationProfileError, ThrowOnError>({
    ...options,
    url: '/rooms/locations/{locationId}',
  });
};

/**
 * Update Zoom Room location profile
 * Each location type of the [Zoom Rooms location hierarchy](https://support.zoom.us/hc/en-us/articles/115000342983-Zoom-Rooms-Location-Hierarchy) has a profile page that includes information such as name of the location, address, support email, etc. Use this API to update information about a specific Zoom Rooms location type such as information about the city where the Zoom Rooms is located.
 *
 * **Prerequisite:**<br>
 * * Account owner or admin permission
 * * Zoom Rooms version 4.0 or higher<br>
 * **Scopes:** `room:write:admin`<br>
 *
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const updateZrLocationProfile = <ThrowOnError extends boolean = false>(
  options: Options<UpdateZrLocationProfileData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateZrLocationProfileResponse, UpdateZrLocationProfileError, ThrowOnError>(
    {
      ...options,
      url: '/rooms/locations/{locationId}',
    },
  );
};

/**
 * Change the assigned parent location
 * An account owner of a Zoom account can establish a [Zoom Rooms Location Hierarchy](https://support.zoom.us/hc/en-us/articles/115000342983-Zoom-Rooms-Location-Hierarchy) to better organize Zoom Rooms spread accross various location. The location can be structured in a hierarchy with Country being the top-level location, followed by city, campus, building, and floor. The location in the lower level in the hierarchy is considered as a child of the location that is a level above in the hierarchy. Use this API to change the parent location of a child location. <br><br> For instance, if the location hierarchy is structured in a way where there are two campuses (Campus 1, and Campus 2) in a City and Campus 1 consists of a building named Building 1 with a floor where Zoom Rooms are located, and you would like to rearrange the structure so that Building 1 along with its child locations (floor and Zoom Rooms) are relocated directly under Campus 2 instead of Campus 1, you must provide the location ID of Building 1 in the path parameter of this request and the location ID of Campus 2 as the value of `parent_location_id` in the  request body.<br><br>
 * **Prerequisite:**<br>
 * * Account owner or admin permission
 * * Zoom Rooms version 4.0 or higher<br>
 * **Scopes:** `room:write:admin`<br><br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const changeParentLocation = <ThrowOnError extends boolean = false>(
  options: Options<ChangeParentLocationData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<ChangeParentLocationResponse, ChangeParentLocationError, ThrowOnError>({
    ...options,
    url: '/rooms/locations/{locationId}/location',
  });
};

/**
 * Get location settings
 * Get information on meeting or alert settings applied to Zoom Rooms located in a specific location. By default, only **Meeting Settings** are returned. To view only **Alert Settings**, specify `alert` as the value of the `setting_type` query parameter.<br><br>
 * **Prerequisites:**<br>
 * * Zoom Room licenses
 * * Owner or Admin privileges on the Zoom Account.<br>
 * **Scopes:** `room:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const getZrLocationSettings = <ThrowOnError extends boolean = false>(
  options: Options<GetZrLocationSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetZrLocationSettingsResponse, GetZrLocationSettingsError, ThrowOnError>({
    ...options,
    url: '/rooms/locations/{locationId}/settings',
  });
};

/**
 * Update location settings
 * Update information on either meeting or alert settings applied to Zoom Rooms located in a specific location. To update **Alert Settings**, specify `alert` as the value of the `setting_type` query parameter. Similarly, to update **Meeting Settings**, specify `meeting` as the value of the `setting_type` query parameter.<br><br>
 * **Prerequisites:**<br>
 * * Zoom Room licenses
 * * Owner or Admin privileges on the Zoom Account.<br>
 * **Scopes:** `room:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const updateZrLocationSettings = <ThrowOnError extends boolean = false>(
  options: Options<UpdateZrLocationSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateZrLocationSettingsResponse,
    UpdateZrLocationSettingsError,
    ThrowOnError
  >({
    ...options,
    url: '/rooms/locations/{locationId}/settings',
  });
};

/**
 * Check-in or check-out of a Zoom Room
 * The Zoom Rooms check-in feature helps maximize your room utilization. Use this API to either **check in** and confirm that you are utilizing the room reservation or to **check out** of the room so that the room gets released from the scheduled meeting and will be made available for others to use. Learn more from the [Using the Zoom Rooms check-in feature](https://support.zoom.us/hc/en-us/articles/360001147163-Using-the-Zoom-Rooms-check-in-feature) guide.
 *
 * **Prerequisites:**
 * * [Zoom Rooms](https://support.zoom.us/hc/en-us/articles/207483343-Getting-started-with-Zoom-Rooms#:~:text=Zoom%20Rooms%20is%20a%20software,or%20from%20their%20mobile%20device) must have been set up for use for the account and must be online.
 * * You must have access to the Calendar Integration APIs (either Microsoft Exchange or Google Calendar APIs) to get calendar information associated with the Room.
 *
 * **Scope:** `room:write:admin`
 */
export const checkInRooms = <ThrowOnError extends boolean = false>(
  options: Options<CheckInRoomsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<CheckInRoomsResponse, CheckInRoomsError, ThrowOnError>({
    ...options,
    url: '/rooms/{id}/events',
  });
};

/**
 * Delete a Zoom Room
 * [Remove](https://support.zoom.us/hc/en-us/articles/360033432032-Zoom-Room-Device-Profiles#h_e55b2092-c418-4b02-819f-44de51448900) a specific Zoom Room profile from a Zoom account.<br><br>
 * **Prerequisites:**<br>
 * * Pro or a higher plan with [Zoom Room](https://zoom.us/zoomrooms) license.<br>
 * **Scopes**: `room:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deleteAzoomRoom = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAzoomRoomData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAzoomRoomResponse, DeleteAzoomRoomError, ThrowOnError>({
    ...options,
    url: '/rooms/{roomId}',
  });
};

/**
 * Get Zoom Room profile
 *
 * Zoom Rooms is a software-based room system that provides an integrated experience for audio conferencing, wireless screen sharing and video conferencing. Use this API to get detailed information on a specific Zoom Room in a Zoom account.
 *
 * **Prerequisites:**<br>
 * * Pro or a higher plan with [Zoom Room](https://zoom.us/zoomrooms) license.<br>
 * **Scopes**: `room:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const getZrProfile = <ThrowOnError extends boolean = false>(
  options: Options<GetZrProfileData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetZrProfileResponse, GetZrProfileError, ThrowOnError>({
    ...options,
    url: '/rooms/{roomId}',
  });
};

/**
 * Update a Zoom Room profile
 * Update basic information on a specific Zoom Room in a Zoom account.<br>
 *
 * **Prerequisites:**<br>
 * * Pro or a higher plan with [Zoom Room](https://zoom.us/zoomrooms) license.<br>
 * **Scopes**: `room:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const updateRoomProfile = <ThrowOnError extends boolean = false>(
  options: Options<UpdateRoomProfileData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateRoomProfileResponse, UpdateRoomProfileError, ThrowOnError>({
    ...options,
    url: '/rooms/{roomId}',
  });
};

/**
 * List Zoom Room devices
 * List information about the devices that are being used for a specific [Zoom Room](https://support.zoom.us/hc/en-us/articles/207483343-Getting-Started-with-Zoom-Rooms) in an account.
 *
 * **Prerequisites:**<br>
 * * Pro or a higher plan with [Zoom Room](https://zoom.us/zoomrooms) license.<br>
 * * Account owner or admin permissions.
 * **Scopes**: `room:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const listZrDevices = <ThrowOnError extends boolean = false>(
  options: Options<ListZrDevicesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListZrDevicesResponse, ListZrDevicesError, ThrowOnError>({
    ...options,
    url: '/rooms/{roomId}/devices',
  });
};

/**
 * Change Zoom Rooms' app version
 * [Upgrade](https://support.zoom.us/hc/en-us/articles/204675449-Upgrade-or-Downgrade-Zoom-Rooms-Software#h_1751c48a-644e-4a60-b96a-31ec77c616e6) or [downgrade](https://support.zoom.us/hc/en-us/articles/204675449-Upgrade-or-Downgrade-Zoom-Rooms-Software#h_d97349d6-9253-484c-af80-350475026524) the version of Zoom Rooms App installed in your Mac or Windows device.
 *
 * **Prerequisites:**<br>
 * * Pro or a higher account with Zoom Rooms.
 * * Zoom Rooms software must be installed either on a Mac or a Windows device. This API does not support other devices.
 */
export const changeZoomRoomsAppVersion = <ThrowOnError extends boolean = false>(
  options: Options<ChangeZoomRoomsAppVersionData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    ChangeZoomRoomsAppVersionResponse,
    ChangeZoomRoomsAppVersionError,
    ThrowOnError
  >({
    ...options,
    url: '/rooms/{roomId}/devices/{deviceId}/app_version',
  });
};

/**
 * Change a Zoom Room's location
 * An account owner of a Zoom account can establish a [Zoom Rooms Location Hierarchy](https://support.zoom.us/hc/en-us/articles/115000342983-Zoom-Rooms-Location-Hierarchy) to better organize Zoom Rooms spread accress various location. The location can be structured in a hierarchy with Country being the top-level location, followed by city, campus, building, and floor. Use this API to assign a new location for a Zoom Room. Note that the Zoom Room can be assigned only to the lowest level location available in the hierarchy.
 * **Prerequisite:**<br>
 * * Account owner or admin permission
 * * Zoom Rooms version 4.0 or higher<br>
 * **Scopes:** `room:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const changeZrLocation = <ThrowOnError extends boolean = false>(
  options: Options<ChangeZrLocationData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<ChangeZrLocationResponse, ChangeZrLocationError, ThrowOnError>({
    ...options,
    url: '/rooms/{roomId}/location',
  });
};

/**
 * Get Zoom Room settings
 * Get information on meeting or alert settings applied to a specific Zoom Room. By default, only **Meeting Settings** are returned. To view only **Alert Settings**, specify `alert` as the value of the `setting_type` query parameter.<br>
 * **Prerequisites:**<br>
 * * Zoom Room licenses
 * * Owner or Admin privileges on the Zoom Account.<br>
 * **Scopes:** `room:read:admin`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 */
export const getZrSettings = <ThrowOnError extends boolean = false>(
  options: Options<GetZrSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetZrSettingsResponse, GetZrSettingsError, ThrowOnError>({
    ...options,
    url: '/rooms/{roomId}/settings',
  });
};

/**
 * Update Zoom Room settings
 * Update either meeting or alert settings applied to a specific Zoom Room. To update **Alert Settings**, specify `alert` as the value of the `setting_type` query parameter. To update **Meeting Settings**, specify `meeting` as the value of the `setting_type` query parameter.<br>
 * **Prerequisites:**<br>
 * * Zoom Room licenses
 * * Owner or Admin privileges on the Zoom Account.<br>
 * **Scopes:** `room:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const updateZrSettings = <ThrowOnError extends boolean = false>(
  options: Options<UpdateZrSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateZrSettingsResponse, UpdateZrSettingsError, ThrowOnError>({
    ...options,
    url: '/rooms/{roomId}/settings',
  });
};

/**
 * List SIP phones
 * Zoom’s Phone System Integration (PSI), also referred as SIP phones, enables an organization to leverage the Zoom client to complete a softphone registration to supported premise based PBX system. End users will have the ability to have softphone functionality within a single client while maintaining a comparable interface to Zoom Phone. Use this API to list SIP phones on an account.<br><br>
 * **Prerequisites**:
 * * Currently only supported on Cisco and Avaya PBX systems.
 * * User must enable SIP Phone Integration by contacting the [Sales](https://zoom.us/contactsales) team.<br> **Scope:** `sip_phone:read:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 */
export const listSipPhones = <ThrowOnError extends boolean = false>(
  options?: Options<ListSipPhonesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListSipPhonesResponse, ListSipPhonesError, ThrowOnError>({
    ...options,
    url: '/sip_phones',
  });
};

/**
 * Enable SIP phone
 * Zoom’s Phone System Integration (PSI), also referred as SIP phones, enables an organization to leverage the Zoom client to complete a softphone registration to supported premise based PBX system. End users will have the ability to have softphone functionality within a single client while maintaining a comparable interface to Zoom Phone. Use this API to enable a user to use SIP phone.<br><br>
 * **Prerequisites**:
 * * Currently only supported on Cisco and Avaya PBX systems.
 * * The account owner or account admin must first enable SIP Phone Integration by contacting the [Sales](https://zoom.us/contactsales) team.<br> **Scope:** `sip_phone:write:admin`
 * <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const createSipPhone = <ThrowOnError extends boolean = false>(
  options?: Options<CreateSipPhoneData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateSipPhoneResponse, CreateSipPhoneError, ThrowOnError>({
    ...options,
    url: '/sip_phones',
  });
};

/**
 * Delete SIP phone
 * Zoom’s Phone System Integration (PSI), also referred as SIP phones, enables an organization to leverage the Zoom client to complete a softphone registration to supported premise based PBX system. End users will have the ability to have softphone functionality within a single client while maintaining a comparable interface to Zoom Phone. Use this API to delete a specific SIP phone on a Zoom account.<br><br>
 * **Prerequisites**:
 * * Currently only supported on Cisco and Avaya PBX systems.
 * * User must enable SIP Phone Integration by contacting the [Sales](https://zoom.us/contactsales) team.<br> **Scope:** `sip_phone:read:admin`
 * <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deleteSipPhone = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSipPhoneData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteSipPhoneResponse, DeleteSipPhoneError, ThrowOnError>({
    ...options,
    url: '/sip_phones/{phoneId}',
  });
};

/**
 * Update SIP phone
 * Zoom’s Phone System Integration (PSI), also referred as SIP phones, enables an organization to leverage the Zoom client to complete a softphone registration to supported premise based PBX system. End users will have the ability to have softphone functionality within a single client while maintaining a comparable interface to Zoom Phone. Use this API to update information of a specific SIP Phone on a Zoom account.<br><br>
 * **Prerequisites**:
 * * Currently only supported on Cisco and Avaya PBX systems.
 * * The account owner or account admin must first enable SIP Phone Integration by contacting the [Sales](https://zoom.us/contactsales) team.<br> **Scope:** `sip_phone:write:admin`
 * <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const updateSipPhone = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSipPhoneData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateSipPhoneResponse, UpdateSipPhoneError, ThrowOnError>({
    ...options,
    url: '/sip_phones/{phoneId}',
  });
};

/**
 * List SIP trunk numbers
 * With SIP-connected audio, Zoom establishes a SIP trunk (a network connection specifically designed to make and deliver phone calls) over a direct and private connection between the customer’s network and the Zoom cloud. Meeting participants that dial into a meeting or have the meeting call them, and are On-Net from the perspective of the customers' IP telephony network, will be connected over this trunk rather than over the PSTN. <br><br>Use this API to list all the numbers that are configured for SIP Connected Audio in a Zoom Account.
 *
 * **Prerequisites:**<br>
 * * Pro or a higher account with SIP Connected Audio plan enabled.
 * * The account must be a master account<br>
 * **Scopes:** `sip_trunk:master`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const listSipTrunkNumbers = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<ListSipTrunkNumbersResponse, ListSipTrunkNumbersError, ThrowOnError>({
    ...options,
    url: '/sip_trunk/numbers',
  });
};

/**
 * List tracking fields
 * [Tracking fields](https://support.zoom.us/hc/en-us/articles/115000293426-Scheduling-Tracking-Fields) allow you to analyze usage by various fields within an organization.<br> Use this API to list all the tracking fields on your Zoom account.<br><br>
 * **Scopes:** `trackingfield:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 * **Prerequisites:**
 * * Business, Education, API or higher plan
 */
export const trackingfieldList = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<TrackingfieldListResponse, TrackingfieldListError, ThrowOnError>({
    ...options,
    url: '/tracking_fields',
  });
};

/**
 * Create a tracking field
 * [Tracking fields](https://support.zoom.us/hc/en-us/articles/115000293426-Scheduling-Tracking-Fields) allow you to analyze usage by various fields within an organization.<br> Use this API to create a new tracking field.<br><br>
 * **Scope:** `trackingfield:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**
 * * Business, Education, API or higher plan
 */
export const trackingfieldCreate = <ThrowOnError extends boolean = false>(
  options: Options<TrackingfieldCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<TrackingfieldCreateResponse, TrackingfieldCreateError, ThrowOnError>({
    ...options,
    url: '/tracking_fields',
  });
};

/**
 * Delete a tracking field
 * [Tracking fields](https://support.zoom.us/hc/en-us/articles/115000293426-Scheduling-Tracking-Fields) allow you to analyze usage by various fields within an organization.<br> Use this API to delete a tracking field.<br><br>
 * **Scope:** `trackingfield:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**
 * * Business, Education, API or higher plan
 */
export const trackingfieldDelete = <ThrowOnError extends boolean = false>(
  options: Options<TrackingfieldDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<TrackingfieldDeleteResponse, TrackingfieldDeleteError, ThrowOnError>({
    ...options,
    url: '/tracking_fields/{fieldId}',
  });
};

/**
 * Get a tracking field
 * [Tracking fields](https://support.zoom.us/hc/en-us/articles/115000293426-Scheduling-Tracking-Fields) allow you to analyze usage by various fields within an organization.<br><br> When scheduling a meeting, the tracking field will be included in the meeting options.<br>Use this API to get information on a tracking field.<br><br>
 * **Scopes:** `trackingfield:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**
 * * Business, Education, API or higher plan
 *
 */
export const trackingfieldGet = <ThrowOnError extends boolean = false>(
  options: Options<TrackingfieldGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TrackingfieldGetResponse, TrackingfieldGetError, ThrowOnError>({
    ...options,
    url: '/tracking_fields/{fieldId}',
  });
};

/**
 * Update a tracking field
 * [Tracking fields](https://support.zoom.us/hc/en-us/articles/115000293426-Scheduling-Tracking-Fields) allow you to analyze usage by various fields within an organization.<br> Use this API to update a tracking field.<br><br>
 * **Scope:** `trackingfield:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**
 * * Business, Education, API or higher plan
 */
export const trackingfieldUpdate = <ThrowOnError extends boolean = false>(
  options: Options<TrackingfieldUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<TrackingfieldUpdateResponse, TrackingfieldUpdateError, ThrowOnError>({
    ...options,
    url: '/tracking_fields/{fieldId}',
  });
};

/**
 * Get account's TSP information
 * Get information on Telephony Service Provider on an account level.<br><br>
 * **Scopes:** `tsp:read:admin` <br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 * **Prerequisites:**<br>
 * * A Pro or a higher plan.
 */
export const tsp = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<TspResponse, TspError, ThrowOnError>({
    ...options,
    url: '/tsp',
  });
};

/**
 * Update account's TSP information
 * Update information of the Telephony Service Provider set up on an account.<br>
 * **Prerequisites**:<br>
 * TSP account option should be enabled.<br>
 * **Scopes:** `tsp:write:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 */
export const tspUpdate = <ThrowOnError extends boolean = false>(options: Options<TspUpdateData, ThrowOnError>) => {
  return (options?.client ?? client).patch<TspUpdateResponse, TspUpdateError, ThrowOnError>({
    ...options,
    url: '/tsp',
  });
};

/**
 * List users
 * A Zoom account can have one or more users. Use this API to list users on your account.<br><br>
 * **Scopes:** `user:read:admin`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const users = <ThrowOnError extends boolean = false>(options?: Options<UsersData, ThrowOnError>) => {
  return (options?.client ?? client).get<UsersResponse, UsersError, ThrowOnError>({
    ...options,
    url: '/users',
  });
};

/**
 * Create users
 * A Zoom account can have one or more users. Use this API to add a new user to your account.<br><br>
 * **Prerequisites:**<br>
 * * Pro or higher plan<br><br>
 * **Scopes:** `user:write:admin` `user:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const userCreate = <ThrowOnError extends boolean = false>(options: Options<UserCreateData, ThrowOnError>) => {
  return (options?.client ?? client).post<UserCreateResponse, UserCreateError, ThrowOnError>({
    ...options,
    url: '/users',
  });
};

/**
 * Check a user email
 * Verify if a user's email is registered with Zoom.<br><br>
 *
 * <b>Note: </b>You can successfully check if a user is a registered Zoom user only if the user **signed up for Zoom via email and is within your account.** If you provide an email address of a user who is not in your account, the value of "existed_email" parameter will be "false" irrespective of whether or not the user is registered with Zoom. The response of this API call will not include users who joined Zoom using options such as "Sign in with SSO", "Sign in with Google" or "Sign in with Facebook" even if they are in the same account as yours.
 *
 * **Scopes:** `user:read:admin` `user:read`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 */
export const userEmail = <ThrowOnError extends boolean = false>(options: Options<UserEmailData, ThrowOnError>) => {
  return (options?.client ?? client).get<UserEmailResponse, UserEmailError, ThrowOnError>({
    ...options,
    url: '/users/email',
  });
};

/**
 * Get user's ZAK
 * Get User’s Zoom Access Token (ZAK). You can use a ZAK to enable a non-login user to join a meeting on your app. Non-login users do not need to enter their username and password to join meetings.
 *
 * **Scope:** `user_zak:read`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const userZak = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<UserZakResponse, UserZakError, ThrowOnError>({
    ...options,
    url: '/users/me/zak',
  });
};

/**
 * Check a user's PM room
 * A personal meeting room is a virtual meeting room that can be permanently assigned to a user.
 * Use this API to check if a personal meeting room with the given name exists or not.<br><br>
 * **Scopes:** `user:read:admin` `user:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const userVanityName = <ThrowOnError extends boolean = false>(
  options: Options<UserVanityNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UserVanityNameResponse, UserVanityNameError, ThrowOnError>({
    ...options,
    url: '/users/vanity_name',
  });
};

/**
 * Delete a user
 * Deleting a user permanently removes the user and their data from Zoom. Users can create a new Zoom account using the same email address. An account owner or an account admin can transfer meetings, webinars and cloud recordings to another Zoom user account before deleting.<br><br>
 *
 * This API disassociates (unlinks) a user from the associated Zoom account and provides the user their own basic free Zoom account, and the user can purchase their own licenses. You can transfer the user's data (meetings, webinars and cloud recordings) to another user before disassociation.<br> To permanently delete a user, specify "delete" as the value of the `action` query parameter.
 * **Scopes:** `user:write:admin` `user:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const userDelete = <ThrowOnError extends boolean = false>(options: Options<UserDeleteData, ThrowOnError>) => {
  return (options?.client ?? client).delete<UserDeleteResponse, UserDeleteError, ThrowOnError>({
    ...options,
    url: '/users/{userId}',
  });
};

/**
 * Get a user
 * A Zoom account can have one or more users. Use this API to view information of a specific user on a Zoom account.<br><br>
 * **Scopes:** `user:read:admin` `user:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 * <p style="background-color:#e1f5fe; color:#01579b; padding:8px"> <b>Note: </b>If a user's status is pending, only `id` and `created_at` fields will be returned. The value of `created_at` will be the time at which the API call was made until the user activates their account.</p>
 */
export const user = <ThrowOnError extends boolean = false>(options: Options<UserData, ThrowOnError>) => {
  return (options?.client ?? client).get<UserResponse, UserError, ThrowOnError>({
    ...options,
    url: '/users/{userId}',
  });
};

/**
 * Update a user
 * Update information on a user's Zoom [profile](https://support.zoom.us/hc/en-us/articles/201363203-My-Profile).<br><br>
 * **Scopes:** `user:write:admin` `user:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const userUpdate = <ThrowOnError extends boolean = false>(options: Options<UserUpdateData, ThrowOnError>) => {
  return (options?.client ?? client).patch<UserUpdateResponse, UserUpdateError, ThrowOnError>({
    ...options,
    url: '/users/{userId}',
  });
};

/**
 * Delete user assistants
 * Delete all assistants of the current user.<br> Assistants are the users to whom the current user has assigned [scheduling privilege](https://support.zoom.us/hc/en-us/articles/201362803-Scheduling-Privilege). These assistants can schedule meeting on behalf of the current user as well as manage and act as an alternative host for all meetings if the admin has enabled [Co-host option](https://zoom.us/account/setting) on the account.<br>
 * **Prerequisite**:
 * * The user as well as the assistant must have Licensed or an On-prem license.
 * * Assistants must be under the current user's account.<br>
 * **Scopes**: `user:write:admin` `user:write`
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const userAssistantsDelete = <ThrowOnError extends boolean = false>(
  options: Options<UserAssistantsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UserAssistantsDeleteResponse, UserAssistantsDeleteError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/assistants',
  });
};

/**
 * List user assistants
 * List a user's assistants.
 *
 * Assistants are the users to whom the current user has assigned [scheduling privilege](https://support.zoom.us/hc/en-us/articles/201362803-Scheduling-Privilege). These assistants can schedule meeting on behalf of the current user as well as manage and act as an alternative host for all meetings if the admin has enabled [Co-host option](https://zoom.us/account/setting) on the account.<br><br>
 * **Prerequisites**: <br>
 * * Current user as well as the assistant must have Licensed or an On-prem license.
 * * Assistants must be under the current user's account.<br>
 * **Scopes**: `user:read:admin` `user:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const userAssistants = <ThrowOnError extends boolean = false>(
  options: Options<UserAssistantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UserAssistantsResponse, UserAssistantsError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/assistants',
  });
};

/**
 * Add assistants
 * Assistants are the users to whom the current user has assigned [scheduling privilege](https://support.zoom.us/hc/en-us/articles/201362803-Scheduling-Privilege). These assistants can schedule meeting on behalf of the current user as well as manage and act as an alternative host for all meetings if the admin has enabled [Co-host option](https://zoom.us/account/setting) on the account.<br>Use this API to assign assistants to a user. <br> In the request body, provide either the User ID or the email address of the user.<br><br>
 * **Prerequisite**:
 * * The user as well as the assistant must have Licensed or an On-prem license.
 * * Assistants must be under the current user's account.<br>
 * **Scopes**: `user:write:admin` `user:write`
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 */
export const userAssistantCreate = <ThrowOnError extends boolean = false>(
  options: Options<UserAssistantCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UserAssistantCreateResponse, UserAssistantCreateError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/assistants',
  });
};

/**
 * Delete a user assistant
 * Delete a specific assistant of a user.
 * Assistants are the users to whom the current user has assigned [scheduling privilege](https://support.zoom.us/hc/en-us/articles/201362803-Scheduling-Privilege). These assistants can schedule meeting on behalf of the current user as well as manage and act as an alternative host for all meetings if the admin has enabled [Co-host option](https://zoom.us/account/setting) on the account.<br><br>
 * **Prerequisites**:
 * * The user as well as the assistant must have Licensed or an On-prem license.
 * * Assistants must be under the current user's account.<br>
 * **Scopes**: `user:write:admin` `user:write`
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const userAssistantDelete = <ThrowOnError extends boolean = false>(
  options: Options<UserAssistantDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UserAssistantDeleteResponse, UserAssistantDeleteError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/assistants/{assistantId}',
  });
};

/**
 * Update a user's email
 * Change a user's [email address](https://support.zoom.us/hc/en-us/articles/201362563-How-Do-I-Change-the-Email-on-My-Account-) on a Zoom account that has managed domain set up.<br>If the Zoom Account in which the user belongs, has multiple [managed domains](https://support.zoom.us/hc/en-us/articles/203395207-What-is-Managed-Domain-), the email to be updated must match one of the managed domains.<br>
 * **Scopes:** `user:write:admin` `user:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * >  Note: A user's email address can only be changed for a maximum of 3 times in a day(24 hours).
 * **Prerequisite:**<br>
 * * Managed domain must be enabled in the account.
 * * The new email address should not already exist in Zoom.
 */
export const userEmailUpdate = <ThrowOnError extends boolean = false>(
  options: Options<UserEmailUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UserEmailUpdateResponse, UserEmailUpdateError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/email',
  });
};

/**
 * List meeting templates
 * Use this API to list [meeting templates](https://support.zoom.us/hc/en-us/articles/360036559151-Meeting-templates) that are available to be used by a user.
 *
 * **Scope:** `meeting:read` or `meeting:read:admin`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 *
 */
export const listMeetingTemplates = <ThrowOnError extends boolean = false>(
  options: Options<ListMeetingTemplatesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListMeetingTemplatesResponse, ListMeetingTemplatesError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/meeting_templates',
  });
};

/**
 * List meetings
 * List all the meetings that were scheduled for a user (meeting host). This API only supports scheduled meetings and thus, details on instant meetings are not returned via this API.<br><br>
 * **Scopes:** `meeting:read:admin` `meeting:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const meetings = <ThrowOnError extends boolean = false>(options: Options<MeetingsData, ThrowOnError>) => {
  return (options?.client ?? client).get<MeetingsResponse, MeetingsError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/meetings',
  });
};

/**
 * Create a meeting
 * [Create a meeting](https://support.zoom.us/hc/en-us/articles/201362413-Scheduling-meetings) for a user. <br>This API has a daily rate limit of 100 requests per day. Therefore, only 100 **Create a Meeting** API requests are permitted within a 24 hour window for a user.<br>
 *
 * <aside>The <code>start_url</code> of a meeting is a URL using which a host or an alternative host can start a meeting. The expiration time for the <code>start_url</code> field is two hours for all regular users.
 *
 * For custCreate meeting hosts( i.e., users created using the <code>custCreate</code> option via the [Create Users](https://marketplace.zoom.us/docs/api-reference/zoom-api/users/usercreate) API), the expiration time of the <code>start_url</code> field is 90 days from the generation of the <code>start_url</code>.
 *
 * For security reasons, the recommended way to retrieve the updated value for the <code>start_url</code> field programmatically (after expiry) is by calling the [Retrieve a Meeting API](https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meeting) and referring to the value of the <code>start_url</code> field in the response.</aside><br><br>
 * Scopes: `meeting:write:admin` `meeting:write`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const meetingCreate = <ThrowOnError extends boolean = false>(
  options: Options<MeetingCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<MeetingCreateResponse, MeetingCreateError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/meetings',
  });
};

/**
 * List a user's PAC accounts
 * [Personal Audio Conference](https://support.zoom.us/hc/en-us/articles/204517069-Getting-Started-with-Personal-Audio-Conference) (PAC) allows Pro or higher account holders to host meetings through PSTN (phone dial-in) only.<br>Use this API to list a user's PAC accounts.<br><br>
 * **Scopes:** `pac:read:admin` `pac:read`<br>
 * <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**<br>
 * * A Pro or higher plan with [Premium Audio Conferencing](https://support.zoom.us/hc/en-us/articles/204517069-Getting-Started-with-Personal-Audio-Conference) add-on.
 * * Personal Audio Conference must be enabled in the user's profile.
 */
export const userPaCs = <ThrowOnError extends boolean = false>(options: Options<UserPaCsData, ThrowOnError>) => {
  return (options?.client ?? client).get<UserPaCsResponse, UserPaCsError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/pac',
  });
};

/**
 * Update a user's password
 * Update the [password](https://support.zoom.us/hc/en-us/articles/206344385-Change-a-User-s-Password) of a user using which the user can login to Zoom.<br> After this request is processed successfully, an email notification will be sent to the user stating that the password was changed.<br>
 * **Scopes:** `user:write:admin` `user:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 * **Prerequisites:**<br>
 * * Owner or admin of the Zoom account.
 */
export const userPassword = <ThrowOnError extends boolean = false>(
  options: Options<UserPasswordData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UserPasswordResponse, UserPasswordError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/password',
  });
};

/**
 * Get user permissions
 * Users can be assigned a set of permissions that allows them to access only the pages/information that a user needs to view or edit.<br>
 *
 * Use this API to get permissions that have been granted to the user.<br><br>
 * **Scopes:** `user:read:admin` `user:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const userPermission = <ThrowOnError extends boolean = false>(
  options: Options<UserPermissionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UserPermissionResponse, UserPermissionError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/permissions',
  });
};

/**
 * Upload a user's profile picture
 * Upload a user's profile picture.<br><br>
 *
 * Provide `multipart/form-data` as the value of the `content-type` header for this request. This API supports JPEG and PNG file formats.
 *
 * **Scopes:** `user:write:admin` `user:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const userPicture = <ThrowOnError extends boolean = false>(options: Options<UserPictureData, ThrowOnError>) => {
  return (options?.client ?? client).post<UserPictureResponse, UserPictureError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/users/{userId}/picture',
  });
};

/**
 * Update a user's presence status
 * Users in the Zoom desktop client and mobile apps are assigned with a [presence status](https://support.zoom.us/hc/en-us/articles/360032554051-Status-Icons). The presence status informs users of their contact's availability. Users can also change their own presence status to be either "Away", "Do not disturb", or "Available".
 *
 * Use this API to update a user's presence status. A user's status can not be updated more than once per minute, i.e., you can only submit a maximum of 1 update request/minute for a single user.<br>Note that a user's presence status can not be updated using this API if the user is not logged in to the Zoom client.
 *
 * **Scopes:** `user:write`, `user:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 *
 */
export const updatePresenceStatus = <ThrowOnError extends boolean = false>(
  options: Options<UpdatePresenceStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdatePresenceStatusResponse, UpdatePresenceStatusError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/presence_status',
  });
};

/**
 * List all recordings
 * When a user records a meeting or a webinar by choosing the **Record to the Cloud** option, the video, audio, and chat text are recorded in the Zoom cloud.
 *
 * Use this API to list all [Cloud recordings](https://support.zoom.us/hc/en-us/articles/203741855-Cloud-Recording) of a user.<br>
 * > To access a user's password protected cloud recording, add an "access_token" parameter to the download URL and provide either the [JWT](https://marketplace.zoom.us/docs/guides/getting-started/app-types/create-jwt-app) or the user's OAuth access token as the value of the "access_token" parameter.
 * <br>
 *
 * **Scopes:** `recording:read:admin` `recording:read`  <br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 * **Prerequisites:**
 * * Pro or a higher plan.
 * * Cloud Recording must be enabled on the user's account.
 */
export const recordingsList = <ThrowOnError extends boolean = false>(
  options: Options<RecordingsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RecordingsListResponse, RecordingsListError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/recordings',
  });
};

/**
 * Delete user schedulers
 * Delete all of a user's schedulers. Schedulers are users on whose behalf the current user (assistant) can schedule meetings for. By calling this API, the current user will no longer be a scheduling assistant of any user.
 *
 * **Prerequisite**: Current user (assistant) must be under the same account as the scheduler.<br>
 * **Scopes**: `user:write:admin` `user:write`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const userSchedulersDelete = <ThrowOnError extends boolean = false>(
  options: Options<UserSchedulersDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UserSchedulersDeleteResponse, UserSchedulersDeleteError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/schedulers',
  });
};

/**
 * List user schedulers
 * List all the schedulers of a user. Schedulers in this context are the users for whom the current user can schedule meetings for.
 *
 * For instance, if the current user (i.e., the user whose userId was passed in the path parameter of this API call) is user A, the response of this API will contain a list of user(s), for whom user A can schedule and manage meetings. User A is the assistant of these users and thus has scheduling privilege for these user(s).
 *
 * **Prerequisites**:
 * * Current user must be under the same account as the scheduler.<br>
 * **Scopes**: `user:read:admin` `user:read`
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const userSchedulers = <ThrowOnError extends boolean = false>(
  options: Options<UserSchedulersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UserSchedulersResponse, UserSchedulersError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/schedulers',
  });
};

/**
 * Delete a scheduler
 * Delete a Scheduler.
 *
 * Schedulers are users on whose behalf the current user (assistant) can schedule meetings for. By calling this API, the current user will no longer be a scheduling assistant of this scheduler.
 *
 * **Prerequisite**: Current user must be under the same account as the scheduler.<br>
 * **Scopes**: `user:write:admin` `user:write`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const userSchedulerDelete = <ThrowOnError extends boolean = false>(
  options: Options<UserSchedulerDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UserSchedulerDeleteResponse, UserSchedulerDeleteError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/schedulers/{schedulerId}',
  });
};

/**
 * Get user settings
 * Retrieve a user's settings.<br><br>
 * **Scopes:** `user:read:admin` `user:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const userSettings = <ThrowOnError extends boolean = false>(
  options: Options<UserSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UserSettingsResponse, UserSettingsError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/settings',
  });
};

/**
 * Update user settings
 * Update a user's settings.<br><br>
 * **Scopes:** `user:write:admin` `user:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const userSettingsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<UserSettingsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UserSettingsUpdateResponse, UserSettingsUpdateError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/settings',
  });
};

/**
 * Delete virtual background files
 * Delete existing virtual background file(s) of a user.
 *
 * **Prerequisites:**<br>
 * * Virtual background feature must be [enabled](https://support.zoom.us/hc/en-us/articles/210707503-Virtual-Background#h_2ef28080-fce9-4ac2-b567-dc958afab1b7) on the account.
 * <br> **Scope:** `user:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const delUserVb = <ThrowOnError extends boolean = false>(options: Options<DelUserVbData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DelUserVbResponse, DelUserVbError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/settings/virtual_backgrounds',
  });
};

/**
 * Upload virtual background files
 * Use this API to [upload virtual background files](https://support.zoom.us/hc/en-us/articles/210707503-Virtual-Background) for a user.
 *
 * **Prerequisites:**<br>
 * * Virtual background feature must be [enabled](https://support.zoom.us/hc/en-us/articles/210707503-Virtual-Background#h_2ef28080-fce9-4ac2-b567-dc958afab1b7) on the account.
 * <br> **Scope:** `user:write:admin`
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 */
export const uploadVbuser = <ThrowOnError extends boolean = false>(
  options: Options<UploadVbuserData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UploadVbuserResponse, UploadVbuserError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/users/{userId}/settings/virtual_backgrounds',
  });
};

/**
 * Update user status
 * An account owner or admins can deactivate as well as activate a user in a Zoom account. Deactivating a user will remove all licenses associated with a user. It will prevent the deactivated user from logging into their Zoom account. A deactivated user can be reactivated. Reactivating a user grants the user access to login to their Zoom account.<br> Use this API to either [deactivate](https://support.zoom.us/hc/en-us/articles/115005269946-Remove-User-from-your-Account#h_6a9bc1c3-d739-4945-b1f2-00b3b88fb5cc) an active user or to [reactivate](https://support.zoom.us/hc/en-us/articles/115005269946-Remove-User-from-your-Account#h_16319724-d120-4be6-af5d-31582d134ea0) a deactivated user .<br><br>**Scopes:** `user:write:admin` `user:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const userStatus = <ThrowOnError extends boolean = false>(options: Options<UserStatusData, ThrowOnError>) => {
  return (options?.client ?? client).put<UserStatusResponse, UserStatusError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/status',
  });
};

/**
 * Revoke a user's SSO token
 * Revoke a user's SSO token.<br><br> After calling this API, the SSO user will be logged out of their current Zoom session.<br>
 * **Scopes:** `user:write:admin` `user:write`
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const userSsoTokenDelete = <ThrowOnError extends boolean = false>(
  options: Options<UserSsoTokenDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UserSsoTokenDeleteResponse, UserSsoTokenDeleteError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/token',
  });
};

/**
 * Get a user token
 * Retrieve a user's token.<br><br> This token is used for starting meetings with the Client SDK.<br>
 * **Scopes:** `user:read:admin` `user:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 * If a user signed into Zoom using Google or Facebook, a null value will be returned for the token. To get the token with this API, ask the user to sign into Zoom using their email and password instead.
 */
export const userToken = <ThrowOnError extends boolean = false>(options: Options<UserTokenData, ThrowOnError>) => {
  return (options?.client ?? client).get<UserTokenResponse, UserTokenError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/token',
  });
};

/**
 * List user's TSP accounts
 * A user can have a maximum of two TSP accounts. Use this API to list all TSP accounts of a user.<br><br>
 * **Scopes:** `tsp:read:admin` `tsp:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 */
export const userTsPs = <ThrowOnError extends boolean = false>(options: Options<UserTsPsData, ThrowOnError>) => {
  return (options?.client ?? client).get<UserTsPsResponse, UserTsPsError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/tsp',
  });
};

/**
 * Add a user's TSP account
 * Add a user's TSP account.<br><br>
 * **Scopes:** `tsp:write:admin` `tsp:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 */
export const userTspCreate = <ThrowOnError extends boolean = false>(
  options: Options<UserTspCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UserTspCreateResponse, UserTspCreateError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/tsp',
  });
};

/**
 * Set global dial-in URL for a TSP user
 * A global dial-in page can provide a list of global access numbers using which audio conferencing can be conducted. By calling this API, you can set the url for the global dial-in page of a user whose Zoom account has TSP and special TSP with third-party audio conferencing options enabled. <p></p>
 * **Scopes:**`tsp:write:admin` `tsp:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 */
export const tspUrlUpdate = <ThrowOnError extends boolean = false>(
  options: Options<TspUrlUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<TspUrlUpdateResponse, TspUrlUpdateError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/tsp/settings',
  });
};

/**
 * Delete a user's TSP account
 * Delete a user's TSP account.<br><br>
 * **Scopes:** `tsp:write:admin` `tsp:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 */
export const userTspDelete = <ThrowOnError extends boolean = false>(
  options: Options<UserTspDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UserTspDeleteResponse, UserTspDeleteError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/tsp/{tspId}',
  });
};

/**
 * Get a user's TSP account
 * Each user can have a maximum of two TSP accounts. Use this API to retrieve details of a specific TSP account enabled for a specific user.<br><br>
 * **Scopes:** `tsp:read:admin` `tsp:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 */
export const userTsp = <ThrowOnError extends boolean = false>(options: Options<UserTspData, ThrowOnError>) => {
  return (options?.client ?? client).get<UserTspResponse, UserTspError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/tsp/{tspId}',
  });
};

/**
 * Update a TSP account
 * Update a user's TSP account.<br><br>
 * **Scopes:** `tsp:write:admin` `tsp:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 */
export const userTspUpdate = <ThrowOnError extends boolean = false>(
  options: Options<UserTspUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UserTspUpdateResponse, UserTspUpdateError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/tsp/{tspId}',
  });
};

/**
 * List webinar templates
 * When you schedule a webinar, you can save the settings for that webinar as a template for scheduling future webinars. <br><br>Use this API to list a user's existing [Webinar templates'](https://support.zoom.us/hc/en-us/articles/115001079746-Webinar-Templates) information.
 *
 * **Prerequisites:**
 * * Pro or a higher account with Webinar plan enabled.
 */
export const listWebinarTemplates = <ThrowOnError extends boolean = false>(
  options: Options<ListWebinarTemplatesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListWebinarTemplatesResponse, ListWebinarTemplatesError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/webinar_templates',
  });
};

/**
 * List webinars
 * Zoom users with a [Webinar Plan](https://zoom.us/webinar) have access to creating and managing Webinars. Webinar allows a host to broadcast a Zoom meeting to up to 10,000 attendees.<br> Use this API to list all the webinars that are scheduled by or on-behalf a user (Webinar host).<br><br>
 * **Scopes:** `webinar:read:admin` `webinar:read`<br> <br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`
 * **Prerequisites:**
 * * Pro or higher plan with a Webinar Add-on.
 */
export const webinars = <ThrowOnError extends boolean = false>(options: Options<WebinarsData, ThrowOnError>) => {
  return (options?.client ?? client).get<WebinarsResponse, WebinarsError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/webinars',
  });
};

/**
 * Create a webinar
 * Zoom users with a [Webinar Plan](https://zoom.us/webinar) have access to creating and managing Webinars. Webinar allows a host to broadcast a Zoom meeting to up to 10,000 attendees.<br>Use this API to schedule a Webinar for a user (host).<br><br>
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**
 * * Pro or higher plan with a Webinar Add-on.
 */
export const webinarCreate = <ThrowOnError extends boolean = false>(
  options: Options<WebinarCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<WebinarCreateResponse, WebinarCreateError, ThrowOnError>({
    ...options,
    url: '/users/{userId}/webinars',
  });
};

/**
 * Delete a webinar
 * Delete a Webinar.<br><br>
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**<br>
 * * Pro or higher plan with a Webinar Add-on.
 */
export const webinarDelete = <ThrowOnError extends boolean = false>(
  options: Options<WebinarDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<WebinarDeleteResponse, WebinarDeleteError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}',
  });
};

/**
 * Get a webinar
 * Zoom users with a [Webinar Plan](https://zoom.us/webinar) have access to creating and managing Webinars. Webinar allows a host to broadcast a Zoom meeting to up to 10,000 attendees.<br>Use this API to get details of a scheduled webinar.<br><br>
 * **Scopes:** `webinar:read:admin` `webinar:read`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>**Prerequisites:**
 * * Pro or higher plan with a Webinar Add-on.
 */
export const webinar = <ThrowOnError extends boolean = false>(options: Options<WebinarData, ThrowOnError>) => {
  return (options?.client ?? client).get<WebinarResponse, WebinarError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}',
  });
};

/**
 * Update a webinar
 * Zoom users with a [Webinar Plan](https://zoom.us/webinar) have access to creating and managing Webinars. Webinar allows a host to broadcast a Zoom meeting to up to 10,000 attendees.<br>
 * Use this API to make updates to a scheduled Webinar.<br><br>
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**<br>
 * * Pro or higher plan with a Webinar Add-on.
 */
export const webinarUpdate = <ThrowOnError extends boolean = false>(
  options: Options<WebinarUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<WebinarUpdateResponse, WebinarUpdateError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}',
  });
};

/**
 * Perform batch registration
 * Use this API to register up to 30 registrants at once for a scheduled webinar that requires [registration](https://support.zoom.us/hc/en-us/articles/204619915-Scheduling-a-webinar-with-registration). <br>
 *
 * **Prerequisites:**<br>
 * * The webinar host must be a Licensed user.
 * * The webinar should be of type `5`, i.e., it should be a scheduled webinar. Other types of webinars are not supported by this API.<br><br>
 * **Scope:** `webinar:write`, `webinar:write:admin`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Heavy`<br>
 *
 *
 *
 *
 *
 *
 *
 *
 */
export const addBatchWebinarRegistrants = <ThrowOnError extends boolean = false>(
  options: Options<AddBatchWebinarRegistrantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AddBatchWebinarRegistrantsResponse,
    AddBatchWebinarRegistrantsError,
    ThrowOnError
  >({
    ...options,
    url: '/webinars/{webinarId}/batch_registrants',
  });
};

/**
 * Remove panelists
 * Remove all the panelists from a Webinar.<br>
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**<br>
 * * Pro or a higher plan with [Webinar Add-on](https://zoom.us/webinar).<br>
 */
export const webinarPanelistsDelete = <ThrowOnError extends boolean = false>(
  options: Options<WebinarPanelistsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<WebinarPanelistsDeleteResponse, WebinarPanelistsDeleteError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/panelists',
  });
};

/**
 * List panelists
 * Panelists in a Webinar can view and send video, screen share, annotate, etc and do much more compared to attendees in a Webinar.
 *
 * Use this API to list all the panelists of a Webinar.<br><br>
 * **Scopes:** `webinar:read:admin` `webinar:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 * **Prerequisites:**<br>
 * * Pro or a higher plan with [Webinar Add-on](https://zoom.us/webinar).<br>
 */
export const webinarPanelists = <ThrowOnError extends boolean = false>(
  options: Options<WebinarPanelistsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<WebinarPanelistsResponse, WebinarPanelistsError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/panelists',
  });
};

/**
 * Add panelists
 * Panelists in a Webinar can view and send video, screen share, annotate, etc and do much more compared to attendees in a webinar.<br>Use this API to [add panelists](https://support.zoom.us/hc/en-us/articles/115005657826-Inviting-Panelists-to-a-Webinar#h_7550d59e-23f5-4703-9e22-e76bded1ed70) to a scheduled webinar.<br><br>
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 * **Prerequisites:**
 * * Pro or a higher plan with [Webinar Add-on](https://zoom.us/webinar).<br>
 */
export const webinarPanelistCreate = <ThrowOnError extends boolean = false>(
  options: Options<WebinarPanelistCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<WebinarPanelistCreateResponse, WebinarPanelistCreateError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/panelists',
  });
};

/**
 * Remove a panelist
 * [Remove](https://support.zoom.us/hc/en-us/articles/115005657826-Inviting-Panelists-to-a-Webinar#h_de31f237-a91c-4fb2-912b-ecfba8ec5ffb) a single panelist from a webinar.<br> You can retrieve the `panelistId` by calling **List Panelists API**.<br><br>
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 * **Prerequisites:**<br>
 * * Pro or a higher plan with [Webinar Add-on](https://zoom.us/webinar).<br>
 */
export const webinarPanelistDelete = <ThrowOnError extends boolean = false>(
  options: Options<WebinarPanelistDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<WebinarPanelistDeleteResponse, WebinarPanelistDeleteError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/panelists/{panelistId}',
  });
};

/**
 * List a webinar's polls
 * List all the [polls](https://support.zoom.us/hc/en-us/articles/203749865-Polling-for-Webinars) of a Webinar.<br><br>
 * **Scopes:** `webinar:read:admin` `webinar:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const webinarPolls = <ThrowOnError extends boolean = false>(
  options: Options<WebinarPollsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<WebinarPollsResponse, WebinarPollsError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/polls',
  });
};

/**
 * Create a webinar's poll
 * Create a [poll](https://support.zoom.us/hc/en-us/articles/203749865-Polling-for-Webinars) for a webinar.<br><br>
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const webinarPollCreate = <ThrowOnError extends boolean = false>(
  options: Options<WebinarPollCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<WebinarPollCreateResponse, WebinarPollCreateError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/polls',
  });
};

/**
 * Delete a webinar poll
 * Delete a webinar's [poll](https://support.zoom.us/hc/en-us/articles/203749865-Polling-for-Webinars).<br><br>
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const webinarPollDelete = <ThrowOnError extends boolean = false>(
  options: Options<WebinarPollDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<WebinarPollDeleteResponse, WebinarPollDeleteError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/polls/{pollId}',
  });
};

/**
 * Get a webinar poll
 * Get a webinar's [poll](https://support.zoom.us/hc/en-us/articles/203749865-Polling-for-Webinars) details.<br><br>
 * **Scopes:** `webinar:read:admin` `webinar:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const webinarPollGet = <ThrowOnError extends boolean = false>(
  options: Options<WebinarPollGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<WebinarPollGetResponse, WebinarPollGetError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/polls/{pollId}',
  });
};

/**
 * Update a webinar poll
 * Update a webinar's [poll](https://support.zoom.us/hc/en-us/articles/203749865-Polling-for-Webinars).<br><br>
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const webinarPollUpdate = <ThrowOnError extends boolean = false>(
  options: Options<WebinarPollUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<WebinarPollUpdateResponse, WebinarPollUpdateError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/polls/{pollId}',
  });
};

/**
 * List webinar registrants
 * Zoom users with a [Webinar Plan](https://zoom.us/webinar) have access to creating and managing Webinars. Webinar allows a host to broadcast a Zoom meeting to up to 10,000 attendees. Scheduling a [Webinar with registration](https://support.zoom.us/hc/en-us/articles/204619915-Scheduling-a-Webinar-with-Registration) requires your registrants to complete a brief form before receiving the link to join the Webinar.<br>
 * Use this API to list all the users that have registered for a webinar.<br><br>
 * **Prerequisites:**
 * * Pro or higher plan with a Webinar Add-on.<br>
 * **Scopes:** `webinar:read:admin` `webinar:read`<br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 */
export const webinarRegistrants = <ThrowOnError extends boolean = false>(
  options: Options<WebinarRegistrantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<WebinarRegistrantsResponse, WebinarRegistrantsError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/registrants',
  });
};

/**
 * Add a webinar registrant
 * Zoom users with a [Webinar Plan](https://zoom.us/webinar) have access to creating and managing Webinars. Webinar allows a host to broadcast a Zoom meeting to up to 10,000 attendees. Scheduling a [Webinar with registration](https://support.zoom.us/hc/en-us/articles/204619915-Scheduling-a-Webinar-with-Registration) requires your registrants to complete a brief form before receiving the link to join the Webinar.<br>Use this API to create and submit the registration of a user for a webinar.<br><br>
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**
 * * Pro or higher plan with a Webinar Add-on.
 */
export const webinarRegistrantCreate = <ThrowOnError extends boolean = false>(
  options: Options<WebinarRegistrantCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<WebinarRegistrantCreateResponse, WebinarRegistrantCreateError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/registrants',
  });
};

/**
 * List registration questions
 * Scheduling a [Webinar with registration](https://support.zoom.us/hc/en-us/articles/204619915-Scheduling-a-Webinar-with-Registration) requires your registrants to complete a brief form with fields and questions before they can receive the link to join the Webinar.<br>Use this API to list registration questions and fields that are to be answered by users while registering for a Webinar.<br>
 * **Prerequisites:**<br>
 * * Pro or higher plan with a Webinar Add-on.
 * **Scopes:** `webinar:read:admin` `webinar:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 *
 *
 */
export const webinarRegistrantsQuestionsGet = <ThrowOnError extends boolean = false>(
  options: Options<WebinarRegistrantsQuestionsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    WebinarRegistrantsQuestionsGetResponse,
    WebinarRegistrantsQuestionsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/webinars/{webinarId}/registrants/questions',
  });
};

/**
 * Update registration questions
 * Scheduling a [Webinar with registration](https://support.zoom.us/hc/en-us/articles/204619915-Scheduling-a-Webinar-with-Registration) requires your registrants to complete a brief form with fields and questions before they can receive the link to join the Webinar.<br>Use this API to update registration questions and fields of a scheduled Webinar that are to be answered by users while registering for a Webinar.<br><br>
 * **Prerequisites:**<br>
 * * Pro or higher plan with a Webinar Add-on.
 * * Registration option for Webinar should be set as required to use this API.
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 *
 *
 */
export const webinarRegistrantQuestionUpdate = <ThrowOnError extends boolean = false>(
  options: Options<WebinarRegistrantQuestionUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    WebinarRegistrantQuestionUpdateResponse,
    WebinarRegistrantQuestionUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/webinars/{webinarId}/registrants/questions',
  });
};

/**
 * Update registrant's status
 * Update a webinar registrant's status. Using this API, you can specify whether you want to approve a registration, deny a registration or cancel a previously approved registration.<br><br>
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 *
 *
 */
export const webinarRegistrantStatus = <ThrowOnError extends boolean = false>(
  options: Options<WebinarRegistrantStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<WebinarRegistrantStatusResponse, WebinarRegistrantStatusError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/registrants/status',
  });
};

/**
 * Delete a webinar registrant
 * Delete a webinar registrant.<br><br>
 * **Scopes**: `webinar:write:admin` `webinar:write`<br>
 * <br>
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`
 */
export const deleteWebinarRegistrant = <ThrowOnError extends boolean = false>(
  options: Options<DeleteWebinarRegistrantData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteWebinarRegistrantResponse,
    DeleteWebinarRegistrantError,
    ThrowOnError
  >({
    ...options,
    url: '/webinars/{webinarId}/registrants/{registrantId}',
  });
};

/**
 * Get a webinar registrant
 * Zoom users with a [Webinar Plan](https://zoom.us/webinar) have access to creating and managing Webinars. Webinar allows a host to broadcast a Zoom meeting to up to 10,000 attendees. Scheduling a [Webinar with registration](https://support.zoom.us/hc/en-us/articles/204619915-Scheduling-a-Webinar-with-Registration) requires your registrants to complete a brief form before receiving the link to join the Webinar.<br>Use this API to get details on a specific user who has registered for the Webinar.<br><br>
 * **Scopes:** `webinar:read:admin` `webinar:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**<br>
 * * The account must have a Webinar plan.
 */
export const webinarRegistrantGet = <ThrowOnError extends boolean = false>(
  options: Options<WebinarRegistrantGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<WebinarRegistrantGetResponse, WebinarRegistrantGetError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/registrants/{registrantId}',
  });
};

/**
 * Update webinar status
 * Update a webinar's status. Use this API to end an ongoing webinar.<br><br>
 * **Scopes:** `webinar:write:admin` `webinar:write`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Light`<br>
 * **Prerequisites:**<br>
 * * The account must hold a valid [Webinar plan](https://zoom.us/webinar).
 */
export const webinarStatus = <ThrowOnError extends boolean = false>(
  options: Options<WebinarStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<WebinarStatusResponse, WebinarStatusError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/status',
  });
};

/**
 * Get webinar tracking sources
 * [Webinar Registration Tracking Sources](https://support.zoom.us/hc/en-us/articles/360000315683-Webinar-Registration-Source-Tracking) allow you to see where your registrants are coming from if you share the webinar registration page in multiple platforms. You can then use the source tracking to see the number of registrants generated from each platform.<br> Use this API to list information on all the tracking sources of a Webinar.<br>
 * **Scopes:** `webinar:read:admin`, `webinar:read`<br>
 *
 * **[Rate Limit Label](https://marketplace.zoom.us/docs/api-reference/rate-limits#rate-limits):** `Medium`<br>
 * **Prerequisites**:<br>
 * * [Webinar license](https://zoom.us/webinar).
 * * Registration must be required for the Webinar.
 *
 */
export const getTrackingSources = <ThrowOnError extends boolean = false>(
  options: Options<GetTrackingSourcesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTrackingSourcesResponse, GetTrackingSourcesError, ThrowOnError>({
    ...options,
    url: '/webinars/{webinarId}/tracking_sources',
  });
};
