// Generated by ts-to-zod
import { z } from 'zod';

export const accountSettingsActiveFeaturesObjectSchema = z.object({
  advanced_analytics: z.boolean().optional(),
  agent_forwarding: z.boolean().optional(),
  allow_ccs: z.boolean().optional(),
  allow_email_template_customization: z.boolean().optional(),
  automatic_answers: z.boolean().optional(),
  bcc_archiving: z.boolean().optional(),
  benchmark_opt_out: z.boolean().optional(),
  business_hours: z.boolean().optional(),
  chat: z.boolean().optional(),
  chat_about_my_ticket: z.boolean().optional(),
  csat_reason_code: z.boolean().optional(),
  custom_dkim_domain: z.boolean().optional(),
  customer_context_as_default: z.boolean().optional(),
  customer_satisfaction: z.boolean().optional(),
  dynamic_contents: z.boolean().optional(),
  explore: z.boolean().optional(),
  explore_on_support_ent_plan: z.boolean().optional(),
  explore_on_support_pro_plan: z.boolean().optional(),
  facebook: z.boolean().optional(),
  facebook_login: z.boolean().optional(),
  fallback_composer: z.boolean().optional(),
  forum_analytics: z.boolean().optional(),
  good_data_and_explore: z.boolean().optional(),
  google_login: z.boolean().optional(),
  insights: z.boolean().optional(),
  is_abusive: z.boolean().optional(),
  light_agents: z.boolean().optional(),
  markdown: z.boolean().optional(),
  on_hold_status: z.boolean().optional(),
  organization_access_enabled: z.boolean().optional(),
  rich_content_in_emails: z.boolean().optional(),
  sandbox: z.boolean().optional(),
  satisfaction_prediction: z.boolean().optional(),
  suspended_ticket_notification: z.boolean().optional(),
  ticket_forms: z.boolean().optional(),
  ticket_tagging: z.boolean().optional(),
  topic_suggestion: z.boolean().optional(),
  twitter: z.boolean().optional(),
  twitter_login: z.boolean().optional(),
  user_org_fields: z.boolean().optional(),
  user_tagging: z.boolean().optional(),
  voice: z.boolean().optional(),
});

export const accountSettingsAgentObjectSchema = z.object({
  agent_home: z.boolean().optional(),
  agent_workspace: z.boolean().optional(),
  aw_self_serve_migration_enabled: z.boolean().optional(),
  focus_mode: z.boolean().optional(),
  idle_timeout_enabled: z.boolean().optional(),
  unified_agent_statuses: z.boolean().optional(),
});

export const accountSettingsApiObjectSchema = z.object({
  accepted_api_agreement: z.boolean().optional(),
  api_password_access: z.string().optional(),
  api_token_access: z.string().optional(),
});

export const accountSettingsAppsObjectSchema = z.object({
  create_private: z.boolean().optional(),
  create_public: z.boolean().optional(),
  use: z.boolean().optional(),
});

export const accountSettingsBillingObjectSchema = z.object({
  backend: z.string().optional(),
});

export const accountSettingsBrandingObjectSchema = z.object({
  favicon_url: z.string().optional().nullable(),
  header_color: z.string().optional(),
  header_logo_url: z.string().optional().nullable(),
  page_background_color: z.string().optional(),
  tab_background_color: z.string().optional(),
  text_color: z.string().optional(),
});

export const accountSettingsBrandsObjectSchema = z.object({
  default_brand_id: z.number().optional(),
  require_brand_on_new_tickets: z.boolean().optional(),
});

export const accountSettingsCdnObjectSchema = z.object({
  cdn_provider: z.string().optional(),
  fallback_cdn_provider: z.string().optional(),
  hosts: z
    .array(
      z.object({
        name: z.string().optional(),
        url: z.string().optional(),
      }),
    )
    .optional(),
});

export const accountSettingsChatObjectSchema = z.object({
  available: z.boolean().optional(),
  enabled: z.boolean().optional(),
  integrated: z.boolean().optional(),
  maximum_request_count: z.number().optional(),
  welcome_message: z.string().optional(),
});

export const accountSettingsCrossSellObjectSchema = z.object({
  show_chat_tooltip: z.boolean().optional(),
  xsell_source: z.string().optional().nullable(),
});

export const accountSettingsGooddataAdvancedAnalyticsObjectSchema = z.object({
  enabled: z.boolean().optional(),
});

export const accountSettingsGoogleAppsObjectSchema = z.object({
  has_google_apps: z.boolean().optional(),
  has_google_apps_admin: z.boolean().optional(),
});

export const accountSettingsGroupObjectSchema = z.object({
  check_group_name_uniqueness: z.boolean().optional(),
});

export const accountSettingsLimitsObjectSchema = z.object({
  attachment_size: z.number().optional(),
});

export const accountSettingsLocalizationObjectSchema = z.object({
  locale_ids: z.array(z.number()).optional(),
});

export const accountSettingsLotusObjectSchema = z.object({
  pod_id: z.number().optional(),
  prefer_lotus: z.boolean().optional(),
  reporting: z.boolean().optional(),
});

export const accountSettingsMetricsObjectSchema = z.object({
  account_size: z.string().optional(),
});

export const accountSettingsOnboardingObjectSchema = z.object({
  checklist_onboarding_version: z.number().optional(),
  onboarding_segments: z.string().optional().nullable(),
  product_sign_up: z.string().optional().nullable(),
});

export const accountSettingsRoutingObjectSchema = z.object({
  autorouting_tag: z.string().optional(),
  enabled: z.boolean().optional(),
  max_email_capacity: z.number().optional(),
  max_messaging_capacity: z.number().optional(),
  reassignment_messaging_enabled: z.boolean().optional(),
  reassignment_messaging_timeout: z.number().optional(),
  reassignment_talk_timeout: z.number().optional(),
});

export const accountSettingsRuleObjectSchema = z.object({
  macro_most_used: z.boolean().optional(),
  macro_order: z.string().optional(),
  skill_based_filtered_views: z.array(z.record(z.unknown())).optional(),
  using_skill_based_routing: z.boolean().optional(),
});

export const accountSettingsSideConversationsObjectSchema = z.object({
  email_channel: z.boolean().optional(),
  msteams_channel: z.boolean().optional(),
  show_in_context_panel: z.boolean().optional(),
  slack_channel: z.boolean().optional(),
  tickets_channel: z.boolean().optional(),
});

export const accountSettingsStatisticsObjectSchema = z.object({
  forum: z.boolean().optional(),
  rule_usage: z.boolean().optional(),
  search: z.boolean().optional(),
});

export const accountSettingsTicketFormObjectSchema = z.object({
  raw_ticket_forms_instructions: z.string().optional(),
  ticket_forms_instructions: z.string().optional(),
});

export const accountSettingsTicketObjectSchema = z.object({
  accepted_new_collaboration_tos: z.boolean().optional(),
  agent_collision: z.boolean().optional(),
  agent_invitation_enabled: z.boolean().optional(),
  agent_ticket_deletion: z.boolean().optional(),
  allow_group_reset: z.boolean().optional(),
  assign_default_organization: z.boolean().optional(),
  assign_tickets_upon_solve: z.boolean().optional(),
  auto_translation_enabled: z.boolean().optional(),
  auto_updated_ccs_followers_rules: z.boolean().optional(),
  chat_sla_enablement: z.boolean().optional(),
  collaboration: z.boolean().optional(),
  comments_public_by_default: z.boolean().optional(),
  default_solved_ticket_reassignment_strategy: z.string().optional(),
  email_attachments: z.boolean().optional(),
  emoji_autocompletion: z.boolean().optional(),
  follower_and_email_cc_collaborations: z.boolean().optional(),
  has_color_text: z.boolean().optional(),
  is_first_comment_private_enabled: z.boolean().optional(),
  light_agent_email_ccs_allowed: z.boolean().optional(),
  list_empty_views: z.boolean().optional(),
  list_newest_comments_first: z.boolean().optional(),
  markdown_ticket_comments: z.boolean().optional(),
  maximum_personal_views_to_list: z.number().optional(),
  modern_ticket_reassignment: z.boolean().optional(),
  private_attachments: z.boolean().optional(),
  rich_text_comments: z.boolean().optional(),
  show_modern_ticket_reassignment: z.boolean().optional(),
  status_hold: z.boolean().optional(),
  tagging: z.boolean().optional(),
  using_skill_based_routing: z.boolean().optional(),
});

export const accountSettingsTwitterObjectSchema = z.object({
  shorten_url: z.string().optional(),
});

export const accountSettingsUserObjectSchema = z.object({
  agent_created_welcome_emails: z.boolean().optional(),
  end_user_phone_number_validation: z.boolean().optional(),
  have_gravatars_enabled: z.boolean().optional(),
  language_selection: z.boolean().optional(),
  multiple_organizations: z.boolean().optional(),
  tagging: z.boolean().optional(),
  time_zone_selection: z.boolean().optional(),
});

export const accountSettingsVoiceObjectSchema = z.object({
  agent_confirmation_when_forwarding: z.boolean().optional(),
  agent_wrap_up_after_calls: z.boolean().optional(),
  enabled: z.boolean().optional(),
  logging: z.boolean().optional(),
  maximum_queue_size: z.number().optional(),
  maximum_queue_wait_time: z.number().optional(),
  only_during_business_hours: z.boolean().optional(),
  outbound_enabled: z.boolean().optional(),
  recordings_public: z.boolean().optional(),
  uk_mobile_forwarding: z.boolean().optional(),
});

export const accountSettingsObjectSchema = z.object({
  active_features: accountSettingsActiveFeaturesObjectSchema.optional(),
  agents: accountSettingsAgentObjectSchema.optional(),
  api: accountSettingsApiObjectSchema.optional(),
  apps: accountSettingsAppsObjectSchema.optional(),
  billing: accountSettingsBillingObjectSchema.optional(),
  branding: accountSettingsBrandingObjectSchema.optional(),
  brands: accountSettingsBrandsObjectSchema.optional(),
  cdn: accountSettingsCdnObjectSchema.optional(),
  chat: accountSettingsChatObjectSchema.optional(),
  cross_sell: accountSettingsCrossSellObjectSchema.optional(),
  gooddata_advanced_analytics: accountSettingsGooddataAdvancedAnalyticsObjectSchema.optional(),
  google_apps: accountSettingsGoogleAppsObjectSchema.optional(),
  groups: accountSettingsGroupObjectSchema.optional(),
  limits: accountSettingsLimitsObjectSchema.optional(),
  localization: accountSettingsLocalizationObjectSchema.optional(),
  lotus: accountSettingsLotusObjectSchema.optional(),
  metrics: accountSettingsMetricsObjectSchema.optional(),
  onboarding: accountSettingsOnboardingObjectSchema.optional(),
  routing: accountSettingsRoutingObjectSchema.optional(),
  rule: accountSettingsRuleObjectSchema.optional(),
  side_conversations: accountSettingsSideConversationsObjectSchema.optional(),
  statistics: accountSettingsStatisticsObjectSchema.optional(),
  ticket_form: accountSettingsTicketFormObjectSchema.optional(),
  tickets: accountSettingsTicketObjectSchema.optional(),
  twitter: accountSettingsTwitterObjectSchema.optional(),
  user: accountSettingsUserObjectSchema.optional(),
  voice: accountSettingsVoiceObjectSchema.optional(),
});

export const actionObjectSchema = z.object({
  field: z.string().optional(),
  value: z.string().optional(),
});

export const actionsObjectSchema = z.object({
  actions: z.array(actionObjectSchema).optional(),
});

export const activitiesCountResponseSchema = z.object({
  count: z
    .object({
      refreshed_at: z.string().optional(),
      value: z.number().optional(),
    })
    .optional(),
});

export const assigneeFieldAssignableAgentObjectSchema = z.object({
  avatar_url: z.string().optional().nullable(),
  id: z.number().optional(),
  name: z.string().optional(),
});

export const assigneeFieldAssignableGroupAgentsResponseSchema = z.object({
  agents: z.array(assigneeFieldAssignableAgentObjectSchema).optional(),
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
});

export const assigneeFieldAssignableGroupObjectSchema = z.object({
  description: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
});

export const assigneeFieldAssignableSearchAgentObjectSchema = z.object({
  group: z.string().optional(),
  group_id: z.number().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  photo_url: z.string().optional().nullable(),
});

export const assigneeFieldAssignableSearchGroupObjectSchema = z.object({
  id: z.number().optional(),
  name: z.string().optional(),
});

export const assigneeFieldAssignableGroupsResponseSchema = z.object({
  count: z.number().optional(),
  groups: z.array(assigneeFieldAssignableGroupObjectSchema).optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
});

export const attachmentBaseObjectSchema = z.object({
  content_type: z.string().optional(),
  content_url: z.string().optional(),
  deleted: z.boolean().optional(),
  file_name: z.string().optional(),
  height: z.string().optional(),
  id: z.number().optional(),
  inline: z.boolean().optional(),
  malware_access_override: z.boolean().optional(),
  malware_scan_result: z.string().optional(),
  mapped_content_url: z.string().optional(),
  size: z.number().optional(),
  url: z.string().optional(),
  width: z.string().optional(),
});

export const attachmentThumbnailsSchema = z.object({
  thumbnails: z.array(attachmentBaseObjectSchema).optional(),
});

export const attachmentObjectSchema = attachmentBaseObjectSchema.and(attachmentThumbnailsSchema);

export const attachmentUpdateInputSchema = z.object({
  malware_access_override: z.boolean().optional(),
});

export const attachmentUpdateRequestSchema = z.object({
  attachment: attachmentUpdateInputSchema.optional(),
});

export const attachmentUploadResponseSchema = z.object({
  upload: z
    .object({
      attachment: attachmentObjectSchema.optional(),
      attachments: z.array(attachmentObjectSchema).optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const auditLogObjectSchema = z.object({
  action: z.string().optional(),
  action_label: z.string().optional(),
  actor_id: z.number().optional(),
  actor_name: z.string().optional(),
  change_description: z.string().optional(),
  created_at: z.string().optional(),
  id: z.number().optional(),
  ip_address: z.string().optional(),
  source_id: z.number().optional(),
  source_label: z.string().optional(),
  source_type: z.string().optional(),
  url: z.string().optional(),
});

export const auditLogResponseSchema = z.object({
  audit_log: auditLogObjectSchema.optional(),
});

export const auditLogsResponseSchema = z.object({
  audit_logs: z.array(auditLogObjectSchema).optional(),
});

export const viaObjectSchema = z.object({
  channel: z.string().optional(),
  source: z
    .record(z.union([z.unknown(), z.string()]))
    .and(
      z.object({
        from: z
          .object({
            address: z.string().optional().nullable(),
            id: z.number().optional().nullable(),
            name: z.string().optional().nullable(),
            title: z.string().optional().nullable(),
          })
          .optional(),
        rel: z.string().optional().nullable(),
        to: z
          .object({
            address: z.string().optional(),
            name: z.string().optional(),
          })
          .optional(),
      }),
    )
    .optional(),
});

export const authorObjectSchema = z.object({
  email: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
});

export const errorSchema = z.object({
  code: z.string(),
  detail: z.string().optional(),
  id: z.string().optional(),
  links: z.record(z.unknown()).optional(),
  source: z.record(z.unknown()).optional(),
  status: z.string().optional(),
  title: z.string(),
});

export const triggerCategoryBatchRequestSchema = z.object({
  id: z.string(),
  position: z.number(),
});

export const triggerBatchRequestSchema = z.object({
  active: z.boolean().optional(),
  category_id: z.string().optional(),
  id: z.string(),
  position: z.number().optional(),
});

export const actionSchema = z.literal('patch');

export const batchErrorItemSchema = errorSchema.and(
  z.object({
    trigger_id: z.string().optional(),
  }),
);

export const triggerCategorySchema = z.object({
  created_at: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  position: z.number().optional(),
  updated_at: z.string().optional(),
});

export const statusSchema = z.union([z.literal('complete'), z.literal('failed')]);

export const bookmarkInputSchema = z.object({
  ticket_id: z.number().optional(),
});

export const offsetPaginationObjectSchema = z.object({
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
});

export const brandObjectSchema = z.object({
  active: z.boolean().optional(),
  brand_url: z.string().optional(),
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  has_help_center: z.boolean().optional(),
  help_center_state: z.union([z.literal('enabled'), z.literal('disabled'), z.literal('restricted')]).optional(),
  host_mapping: z.string().optional(),
  id: z.number().optional(),
  is_deleted: z.boolean().optional(),
  logo: attachmentObjectSchema.optional(),
  name: z.string(),
  signature_template: z.string().optional(),
  subdomain: z.string(),
  ticket_form_ids: z.array(z.number()).optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const helpCenterStateSchema = z.union([z.literal('enabled'), z.literal('disabled'), z.literal('restricted')]);

export const brandResponseSchema = z.object({
  brand: brandObjectSchema.optional(),
});

export const brandUpdateRequestSchema = z.object({
  brand: brandObjectSchema.optional(),
});

export const brandsResponseSchema = offsetPaginationObjectSchema.and(
  z.object({
    brands: z.array(brandObjectSchema).optional(),
  }),
);

export const bulkUpdateDefaultCustomStatusRequestSchema = z.object({
  ids: z.string().optional(),
});

export const bulkUpdateDefaultCustomStatusResponseSchema = z.record(z.unknown());

export const channelFrameworkResultStatusObjectSchema = z.object({
  code: z.string().optional(),
  description: z.string().optional(),
});

export const collaboratorObjectSchema = z.object({
  email: z.string().optional(),
  name: z.string().optional(),
});

export const complianceDeletionStatusObjectSchema = z.object({
  account_subdomain: z.string(),
  action: z.string(),
  application: z.string(),
  created_at: z.string(),
  executer_id: z.number().nullable(),
  user_id: z.number(),
});

export const complianceDeletionStatusesResponseSchema = z.object({
  compliance_deletion_statuses: z.array(complianceDeletionStatusObjectSchema).optional(),
});

export const conditionObjectSchema = z.object({
  field: z.string().optional(),
  operator: z.string().optional(),
  value: z.string().optional(),
});

export const conditionsObjectSchema = z.object({
  all: z.array(conditionObjectSchema).optional(),
  any: z.array(conditionObjectSchema).optional(),
});

export const countOrganizationObjectSchema = z.object({
  refreshed_at: z.string().optional(),
  value: z.number().optional(),
});

export const countOrganizationResponseSchema = z.object({
  count: countOrganizationObjectSchema.optional(),
});

export const countResponseSchema = z.object({
  count: z
    .object({
      refreshed_at: z.string().optional(),
      value: z.number().optional(),
    })
    .optional(),
});

export const organizationObjectSchema = z.object({
  created_at: z.string().optional(),
  details: z.string().optional().nullable(),
  domain_names: z.array(z.string()).optional(),
  external_id: z.string().optional().nullable(),
  group_id: z.number().optional().nullable(),
  id: z.number().optional(),
  name: z.string(),
  notes: z.string().optional().nullable(),
  organization_fields: z
    .record(z.union([z.string(), z.number()]))
    .optional()
    .nullable(),
  shared_comments: z.boolean().optional(),
  shared_tickets: z.boolean().optional(),
  tags: z.array(z.string()).optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const createResourceResultSchema = z.object({
  id: z.number(),
  index: z.number(),
});

export const ticketObjectSchema = z.object({
  allow_attachments: z.boolean().optional(),
  allow_channelback: z.boolean().optional(),
  assignee_email: z.string().optional(),
  assignee_id: z.number().optional(),
  attribute_value_ids: z.array(z.number()).optional(),
  brand_id: z.number().optional(),
  collaborator_ids: z.array(z.number()).optional(),
  collaborators: z.array(collaboratorObjectSchema).optional(),
  comment: z.record(z.unknown()).optional(),
  created_at: z.string().optional(),
  custom_fields: z
    .array(
      z.object({
        id: z.number().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  custom_status_id: z.number().optional(),
  description: z.string().optional(),
  due_at: z.string().optional().nullable(),
  email_cc_ids: z.array(z.number()).optional(),
  email_ccs: z.record(z.unknown()).optional(),
  external_id: z.string().optional(),
  follower_ids: z.array(z.number()).optional(),
  followers: z.record(z.unknown()).optional(),
  followup_ids: z.array(z.number()).optional(),
  forum_topic_id: z.number().optional(),
  from_messaging_channel: z.boolean().optional(),
  generated_timestamp: z.number().optional(),
  group_id: z.number().optional(),
  has_incidents: z.boolean().optional(),
  id: z.number().optional(),
  is_public: z.boolean().optional(),
  macro_id: z.number().optional(),
  macro_ids: z.array(z.number()).optional(),
  metadata: z.record(z.unknown()).optional(),
  organization_id: z.number().optional(),
  priority: z.union([z.literal('urgent'), z.literal('high'), z.literal('normal'), z.literal('low')]).optional(),
  problem_id: z.number().optional(),
  raw_subject: z.string().optional(),
  recipient: z.string().optional(),
  requester: z.record(z.unknown()).optional(),
  requester_id: z.number(),
  safe_update: z.boolean().optional(),
  satisfaction_rating: z.record(z.unknown()).optional(),
  sharing_agreement_ids: z.array(z.number()).optional(),
  status: z
    .union([
      z.literal('new'),
      z.literal('open'),
      z.literal('pending'),
      z.literal('hold'),
      z.literal('solved'),
      z.literal('closed'),
    ])
    .optional(),
  subject: z.string().optional(),
  submitter_id: z.number().optional(),
  tags: z.array(z.string()).optional(),
  ticket_form_id: z.number().optional(),
  type: z.union([z.literal('problem'), z.literal('incident'), z.literal('question'), z.literal('task')]).optional(),
  updated_at: z.string().optional(),
  updated_stamp: z.string().optional(),
  url: z.string().optional(),
  via: z
    .object({
      channel: z.string().optional(),
      source: z.record(z.unknown()).optional(),
    })
    .optional(),
  via_followup_source_id: z.number().optional(),
  via_id: z.number().optional(),
  voice_comment: z.record(z.unknown()).optional(),
});

export const customFieldOptionObjectSchema = z.object({
  id: z.number().optional(),
  name: z.string(),
  position: z.number().optional(),
  raw_name: z.string().optional(),
  url: z.string().optional(),
  value: z.string(),
});

export const customFieldOptionResponseSchema = z.object({
  custom_field_option: customFieldOptionObjectSchema.optional(),
});

export const customFieldOptionsResponseSchema = z.object({
  count: z.number().optional(),
  custom_field_options: z.array(customFieldOptionObjectSchema).optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
});

export const customObjectSchema = z.object({
  created_at: z.string().optional(),
  created_by_user_id: z.string().optional(),
  description: z.string().optional(),
  include_in_list_view: z.boolean(),
  key: z.string(),
  raw_description: z.string().optional(),
  raw_title: z.string().optional(),
  raw_title_pluralized: z.string().optional(),
  title: z.string(),
  title_pluralized: z.string(),
  updated_at: z.string().optional(),
  updated_by_user_id: z.string().optional(),
  url: z.string().optional(),
});

export const customObjectCreateInputSchema = z.object({
  key: z.string().optional(),
  title: z.string().optional(),
  title_pluralized: z.string().optional(),
});

export const customFieldObjectSchema = z.object({
  active: z.boolean().optional(),
  created_at: z.string().optional(),
  custom_field_options: z.array(customFieldOptionObjectSchema).optional(),
  description: z.string().optional(),
  id: z.number().optional(),
  key: z.string(),
  position: z.number().optional(),
  raw_description: z.string().optional(),
  raw_title: z.string().optional(),
  regexp_for_validation: z.string().optional().nullable(),
  relationship_filter: z.record(z.unknown()).optional(),
  relationship_target_type: z.string().optional(),
  system: z.boolean().optional(),
  tag: z.string().optional(),
  title: z.string(),
  type: z.string(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const customObjectFieldSchema = customFieldObjectSchema;

export const customObjectFieldsCreateRequestSchema = z.object({
  custom_object_field: customObjectFieldSchema.optional(),
});

export const customObjectFieldsResponseSchema = z.object({
  custom_object_fields: z.array(customObjectFieldSchema).optional(),
});

export const customObjectLimitsResponseSchema = z.object({
  count: z.number().optional(),
  limit: z.number().optional(),
});

export const customObjectRecordSchema = z.object({
  created_at: z.string().optional(),
  created_by_user_id: z.string().optional(),
  custom_object_fields: z.record(z.unknown()).optional(),
  custom_object_key: z.string().optional(),
  external_id: z.string().optional().nullable(),
  id: z.string().optional(),
  name: z.string(),
  updated_at: z.string().optional(),
  updated_by_user_id: z.string().optional(),
  url: z.string().optional(),
});

export const customObjectRecordFilteredSearchConditionSchema = z.record(z.unknown()).and(
  z.object({
    field_key: z
      .object({
        operator: z.string().optional(),
        value: z.union([z.string(), z.number(), z.array(z.union([z.string(), z.number()]))]).optional(),
      })
      .optional()
      .nullable(),
  }),
);

export const customObjectRecordResponseSchema = z.object({
  custom_object_record: customObjectRecordSchema.optional(),
});

export const customObjectRecordsBulkCreateRequestSchema = z.object({
  job: z
    .object({
      action: z.string().optional(),
      items: z.array(customObjectRecordSchema).optional(),
    })
    .optional(),
});

export const customObjectRecordsCreateRequestSchema = z.object({
  custom_object_record: customObjectRecordSchema.optional(),
});

export const customObjectRecordsFilteredSearchRequestBasicSchema = z.object({
  filter: customObjectRecordFilteredSearchConditionSchema.optional(),
});

export const customObjectRecordsFilteredSearchRequestComplexSchema = z.object({
  filter: z
    .object({
      $and: z.array(customObjectRecordFilteredSearchConditionSchema).optional(),
      $or: z.array(customObjectRecordFilteredSearchConditionSchema).optional(),
    })
    .optional(),
});

export const customObjectRecordsJobsResponseSchema = z.object({
  job_status: z
    .object({
      id: z.string().optional(),
      message: z.string().optional().nullable(),
      progress: z.number().optional().nullable(),
      results: z.array(customObjectRecordSchema).optional().nullable(),
      status: z.string().optional(),
      total: z.number().optional(),
      url: z.string().optional(),
    })
    .optional(),
});

export const customObjectRecordsResponseSchema = z.object({
  count: z.number().optional(),
  custom_object_records: z.array(customObjectRecordSchema).optional(),
  links: z
    .object({
      next: z.string().nullable(),
      prev: z.string().nullable(),
    })
    .optional(),
  meta: z
    .object({
      after_cursor: z.string().nullable(),
      before_cursor: z.string().nullable(),
      has_more: z.boolean(),
    })
    .optional(),
});

export const customObjectRecordsUpsertRequestSchema = z.object({
  custom_object_record: customObjectRecordSchema.optional(),
});

export const customObjectResponseSchema = z.object({
  custom_object: customObjectSchema.optional(),
});

export const customObjectsCreateRequestSchema = z.object({
  custom_object: customObjectCreateInputSchema.optional(),
});

export const customObjectsResponseSchema = z.object({
  custom_objects: z.array(customObjectSchema).optional(),
});

export const customRoleConfigurationObjectSchema = z.object({
  assign_tickets_to_any_group: z.boolean().optional(),
  chat_access: z.boolean().optional(),
  end_user_list_access: z.string().optional(),
  end_user_profile_access: z.string().optional(),
  explore_access: z.string().optional(),
  forum_access: z.string().optional(),
  forum_access_restricted_content: z.boolean().optional(),
  group_access: z.boolean().optional(),
  light_agent: z.boolean().optional(),
  macro_access: z.string().optional(),
  manage_business_rules: z.boolean().optional(),
  manage_contextual_workspaces: z.boolean().optional(),
  manage_dynamic_content: z.boolean().optional(),
  manage_extensions_and_channels: z.boolean().optional(),
  manage_facebook: z.boolean().optional(),
  manage_organization_fields: z.boolean().optional(),
  manage_ticket_fields: z.boolean().optional(),
  manage_ticket_forms: z.boolean().optional(),
  manage_user_fields: z.boolean().optional(),
  moderate_forums: z.boolean().optional(),
  organization_editing: z.boolean().optional(),
  organization_notes_editing: z.boolean().optional(),
  report_access: z.string().optional(),
  side_conversation_create: z.boolean().optional(),
  ticket_access: z.string().optional(),
  ticket_comment_access: z.string().optional(),
  ticket_deletion: z.boolean().optional(),
  ticket_editing: z.boolean().optional(),
  ticket_merge: z.boolean().optional(),
  ticket_tag_editing: z.boolean().optional(),
  twitter_search_access: z.boolean().optional(),
  user_view_access: z.string().optional(),
  view_access: z.string().optional(),
  view_deleted_tickets: z.boolean().optional(),
  voice_access: z.boolean().optional(),
  voice_dashboard_access: z.boolean().optional(),
});

export const customRoleObjectSchema = z.object({
  configuration: customRoleConfigurationObjectSchema.optional(),
  created_at: z.string().optional(),
  description: z.string().optional(),
  id: z.number().optional(),
  name: z.string(),
  role_type: z.number(),
  team_member_count: z.number().optional(),
  updated_at: z.string().optional(),
});

export const customRoleResponseSchema = z.object({
  custom_role: customRoleObjectSchema.optional(),
});

export const customRolesResponseSchema = z.object({
  custom_roles: z.array(customRoleObjectSchema).optional(),
});

export const customStatusUpdateInputSchema = z.object({
  active: z.boolean().optional(),
  agent_label: z.string().optional(),
  description: z.string().optional(),
  end_user_description: z.string().optional(),
  end_user_label: z.string().optional(),
});

export const statusCategorySchema = z.union([
  z.literal('new'),
  z.literal('open'),
  z.literal('pending'),
  z.literal('hold'),
  z.literal('solved'),
]);

export const customStatusCreateInputSchema = customStatusUpdateInputSchema.and(
  z.object({
    status_category: z
      .union([z.literal('new'), z.literal('open'), z.literal('pending'), z.literal('hold'), z.literal('solved')])
      .optional(),
  }),
);

export const customStatusObjectSchema = z.object({
  active: z.boolean().optional(),
  agent_label: z.string(),
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  description: z.string().optional(),
  end_user_description: z.string().optional(),
  end_user_label: z.string().optional(),
  id: z.number().optional(),
  raw_agent_label: z.string().optional(),
  raw_description: z.string().optional(),
  raw_end_user_description: z.string().optional(),
  raw_end_user_label: z.string().optional(),
  status_category: z.union([
    z.literal('new'),
    z.literal('open'),
    z.literal('pending'),
    z.literal('hold'),
    z.literal('solved'),
  ]),
  updated_at: z.string().optional(),
});

export const customStatusResponseSchema = z.object({
  custom_status: customStatusObjectSchema.optional(),
});

export const customStatusUpdateRequestSchema = z.object({
  custom_status: customStatusUpdateInputSchema.optional(),
});

export const customStatusesResponseSchema = z.object({
  custom_statuses: z.array(customStatusObjectSchema).optional(),
});

export const definitionsResponseSchema = z.object({
  definitions: z
    .object({
      conditions_all: z
        .array(
          z.object({
            group: z.string().optional(),
            nullable: z.boolean().optional(),
            operators: z
              .array(
                z.object({
                  terminal: z.boolean().optional(),
                  title: z.string().optional(),
                  value: z.string().optional(),
                }),
              )
              .optional(),
            repeatable: z.boolean().optional(),
            subject: z.string().optional(),
            title: z.string().optional(),
            type: z.string().optional(),
            values: z
              .array(
                z.object({
                  enabled: z.boolean().optional(),
                  title: z.string().optional(),
                  value: z.string().optional(),
                }),
              )
              .optional(),
          }),
        )
        .optional(),
      conditions_any: z
        .array(
          z.object({
            group: z.string().optional(),
            nullable: z.boolean().optional(),
            operators: z
              .array(
                z.object({
                  terminal: z.boolean().optional(),
                  title: z.string().optional(),
                  value: z.string().optional(),
                }),
              )
              .optional(),
            repeatable: z.boolean().optional(),
            subject: z.string().optional(),
            title: z.string().optional(),
            type: z.string().optional(),
            values: z
              .array(
                z.object({
                  enabled: z.boolean().optional(),
                  title: z.string().optional(),
                  value: z.string().optional(),
                }),
              )
              .optional(),
          }),
        )
        .optional(),
    })
    .optional(),
});

export const deletedUserObjectSchema = z.object({
  active: z.boolean(),
  created_at: z.string(),
  email: z.string(),
  id: z.number(),
  locale: z.string(),
  locale_id: z.number(),
  name: z.string(),
  organization_id: z.number(),
  phone: z.string().nullable(),
  photo: z.record(z.unknown()).nullable(),
  role: z.string(),
  shared_phone_number: z.string().nullable(),
  time_zone: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const deletedUserResponseSchema = z.object({
  deleted_user: deletedUserObjectSchema.optional(),
});

export const deletedUsersResponseSchema = z.object({
  deleted_users: z.array(deletedUserObjectSchema).optional(),
});

export const deletionScheduleSchema = z.object({
  active: z.boolean().optional(),
  conditions: conditionsObjectSchema.optional(),
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  description: z.string().optional(),
  id: z.number().optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const dynamicContentVariantObjectSchema = z.object({
  active: z.boolean().optional(),
  content: z.string(),
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  id: z.number().optional(),
  locale_id: z.number(),
  outdated: z.boolean().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const dynamicContentObjectSchema = z.object({
  created_at: z.string().optional(),
  default_locale_id: z.number(),
  id: z.number().optional(),
  name: z.string(),
  outdated: z.boolean().optional(),
  placeholder: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  variants: z.array(dynamicContentVariantObjectSchema),
});

export const dynamicContentVariantResponseSchema = z.object({
  variant: dynamicContentVariantObjectSchema.optional(),
});

export const dynamicContentVariantsResponseSchema = z.object({
  variants: z.array(dynamicContentVariantObjectSchema).optional(),
});

export const dynamicContentsResponseSchema = z.object({
  items: z.array(dynamicContentObjectSchema).optional(),
});

export const followerObjectSchema = z.object({
  action: z.union([z.literal('put'), z.literal('delete')]).optional(),
  user_email: z.string().optional(),
  user_id: z.string().optional(),
});

export const action2Schema = z.union([z.literal('put'), z.literal('delete')]);

export const recipientObjectSchema = z.object({
  delivery_status: z
    .object({
      code: z.string().optional(),
      id: z.number().optional(),
      message: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  email_address: z.string().optional(),
  user_id: z.number().optional(),
});

export const emailNotificationObjectSchema = z.object({
  comment_id: z.number().optional(),
  created_at: z.string().optional(),
  email_id: z.string().optional(),
  message_id: z.string().optional(),
  notification_id: z.number().optional(),
  recipients: z.array(recipientObjectSchema).optional(),
  ticket_id: z.number().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const emailNotificationsResponseSchema = z.object({
  email_notifications: z.array(emailNotificationObjectSchema).optional(),
});

export const errorsSchema = z.object({
  errors: z.array(errorSchema).optional(),
});

export const essentialsCardObjectSchema = z.object({
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  fields: z.array(z.record(z.unknown())),
  id: z.string().optional().nullable(),
  key: z.string().optional(),
  layout: z.string().optional(),
  max_count: z.number().optional(),
  updated_at: z.string().optional(),
});

export const essentialsCardResponseSchema = z.object({
  object_layout: essentialsCardObjectSchema.optional(),
});

export const essentialsCardsResponseSchema = z.object({
  object_layouts: z.array(essentialsCardObjectSchema).optional(),
});

export const exportIncrementalOrganizationsResponseSchema = z.object({
  count: z.number().optional(),
  end_of_stream: z.boolean().optional(),
  end_time: z.number().optional(),
  next_page: z.string().optional().nullable(),
  organizations: z.array(organizationObjectSchema).optional(),
});

export const ticketMetricEventBaseObjectSchema = z.object({
  id: z.number().optional(),
  instance_id: z.number().optional(),
  metric: z
    .union([
      z.literal('agent_work_time'),
      z.literal('pausable_update_time'),
      z.literal('periodic_update_time'),
      z.literal('reply_time'),
      z.literal('requester_wait_time'),
      z.literal('resolution_time'),
      z.literal('group_ownership_time'),
    ])
    .optional(),
  ticket_id: z.number().optional(),
  time: z.string().optional(),
  type: z
    .union([
      z.literal('activate'),
      z.literal('pause'),
      z.literal('fulfill'),
      z.literal('apply_sla'),
      z.literal('apply_group_sla'),
      z.literal('breach'),
      z.literal('update_status'),
      z.literal('measure'),
    ])
    .optional(),
});

export const groupMembershipObjectSchema = z.object({
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  group_id: z.number(),
  id: z.number().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  user_id: z.number(),
});

export const groupMembershipResponseSchema = z.object({
  group_membership: groupMembershipObjectSchema.optional(),
});

export const groupMembershipsResponseSchema = z.object({
  group_memberships: z.array(groupMembershipObjectSchema).optional(),
});

export const groupObjectSchema = z.object({
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  deleted: z.boolean().optional(),
  description: z.string().optional(),
  id: z.number().optional(),
  is_public: z.boolean().optional(),
  name: z.string(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const groupResponseSchema = z.object({
  group: groupObjectSchema.optional(),
});

export const groupSLAPolicyFilterConditionObjectSchema = z.object({
  field: z.string().optional(),
  operator: z.string().optional(),
  value: z.array(z.union([z.string(), z.number()])).optional(),
});

export const groupSLAPolicyFilterDefinitionResponseSchema = z.object({
  definitions: z
    .object({
      all: z
        .array(
          z.object({
            group: z.string().optional(),
            operators: z
              .array(
                z.object({
                  title: z.string().optional(),
                  value: z.string().optional(),
                }),
              )
              .optional(),
            title: z.string().optional(),
            value: z.string().optional(),
            values: z
              .object({
                list: z
                  .array(
                    z.object({
                      title: z.string().optional(),
                      value: z.number().optional().nullable(),
                    }),
                  )
                  .optional(),
                type: z.string().optional(),
              })
              .optional(),
          }),
        )
        .optional(),
    })
    .optional(),
});

export const groupSLAPolicyFilterObjectSchema = z.object({
  all: z.array(groupSLAPolicyFilterConditionObjectSchema).optional(),
});

export const groupSLAPolicyMetricObjectSchema = z.object({
  business_hours: z.boolean().optional(),
  metric: z.string().optional(),
  priority: z.string().optional(),
  target: z.number().optional(),
});

export const groupSLAPolicyObjectSchema = z.object({
  created_at: z.string().optional(),
  description: z.string().optional(),
  filter: groupSLAPolicyFilterObjectSchema,
  id: z.string().optional(),
  policy_metrics: z.array(groupSLAPolicyMetricObjectSchema).optional(),
  position: z.number().optional(),
  title: z.string(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const groupSLAPolicyResponseSchema = z.object({
  group_sla_policy: groupSLAPolicyObjectSchema.optional(),
});

export const groupsCountObjectSchema = z.object({
  count: z
    .object({
      refreshed_at: z.string().optional(),
      value: z.number().optional(),
    })
    .optional(),
});

export const groupsResponseSchema = z.object({
  groups: z.array(groupObjectSchema).optional(),
});

export const hostMappingObjectSchema = z.object({
  cname: z.string().optional(),
  expected_cnames: z.array(z.string()).optional(),
  is_valid: z.boolean().optional(),
  reason: z.string().optional(),
});

export const incrementalSkillBasedRoutingAttributeValueSchema = z.object({
  attribute_id: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  time: z.string().optional(),
  type: z.string().optional(),
});

export const incrementalSkillBasedRoutingAttributeSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  time: z.string().optional(),
  type: z.string().optional(),
});

export const incrementalSkillBasedRoutingInstanceValueSchema = z.object({
  attribute_value_id: z.string().optional(),
  id: z.string().optional(),
  instance_id: z.string().optional(),
  time: z.string().optional(),
  type: z.string().optional(),
});

export const updateResourceResultSchema = z.object({
  action: z.string(),
  id: z.number(),
  status: z.string(),
  success: z.boolean(),
});

export const listDeletedTicketsResponseSchema = z
  .object({
    deleted_tickets: z
      .array(
        z.object({
          actor: z
            .object({
              id: z.number().optional(),
              name: z.string().optional(),
            })
            .optional(),
          deleted_at: z.string().optional(),
          id: z.number().optional(),
          previous_state: z.string().optional(),
          subject: z.string().optional(),
        }),
      )
      .optional(),
  })
  .and(offsetPaginationObjectSchema);

export const listTicketCollaboratorsResponseSchema = z.record(z.unknown());

export const listTicketEmailCCsResponseSchema = z.record(z.unknown());

export const listTicketFollowersResponseSchema = z.record(z.unknown());

export const listTicketIncidentsResponseSchema = z.record(z.unknown());

export const listTicketProblemsResponseSchema = z.record(z.unknown());

export const localeObjectSchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  locale: z.string().optional(),
  name: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const localeResponseSchema = z.object({
  locale: localeObjectSchema.optional(),
});

export const localesResponseSchema = z.object({
  locales: z.array(localeObjectSchema).optional(),
});

export const macroApplyTicketResponseSchema = z.object({
  result: z
    .object({
      ticket: z
        .object({
          assignee_id: z.number().optional(),
          comment: z
            .object({
              body: z.string().optional(),
              public: z.boolean().optional(),
              scoped_body: z.array(z.array(z.string())).optional(),
            })
            .optional(),
          fields: z
            .object({
              id: z.number().optional(),
              value: z.string().optional(),
            })
            .optional(),
          group_id: z.number().optional(),
          id: z.number().optional(),
          url: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
});

export const macroAttachmentObjectSchema = z.object({
  content_type: z.string().optional(),
  content_url: z.string().optional(),
  created_at: z.string().optional(),
  filename: z.string().optional(),
  id: z.number().optional(),
  size: z.number().optional(),
});

export const macroAttachmentResponseSchema = z.object({
  macro_attachment: macroAttachmentObjectSchema.optional(),
});

export const macroAttachmentsResponseSchema = z.object({
  macro_attachments: z.array(macroAttachmentObjectSchema).optional(),
});

export const macroCategoriesResponseSchema = z.object({
  categories: z.array(z.string()).optional(),
});

export const macroCommonObjectSchema = z.object({
  actions: z.array(actionObjectSchema),
  active: z.boolean().optional(),
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  description: z.string().optional().nullable(),
  id: z.number().optional(),
  position: z.number().optional(),
  restriction: z.record(z.unknown()).optional().nullable(),
  title: z.string(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const macroInputSchema = z.object({
  actions: z.array(actionObjectSchema),
  active: z.boolean().optional(),
  description: z.string().optional().nullable(),
  restriction: z
    .record(z.union([z.unknown(), z.number(), z.string()]))
    .and(
      z.object({
        id: z.number().optional(),
        ids: z.array(z.number()).optional(),
        type: z.string().optional(),
      }),
    )
    .optional(),
  title: z.string(),
});

export const macroObjectSchema = macroCommonObjectSchema.and(
  z.object({
    app_installation: z.string().optional().nullable(),
    categories: z.string().optional().nullable(),
    permissions: z.string().optional().nullable(),
    usage_1h: z.number().optional(),
    usage_7d: z.number().optional(),
    usage_24h: z.number().optional(),
    usage_30d: z.number().optional(),
  }),
);

export const macroResponseSchema = z.object({
  macro: macroObjectSchema.optional(),
});

export const macroUpdateManyInputSchema = z.object({
  macros: z
    .array(
      z.object({
        active: z.boolean().optional(),
        id: z.number(),
        position: z.number().optional(),
      }),
    )
    .optional(),
});

export const macrosResponseSchema = z
  .object({
    macros: z.array(macroObjectSchema).optional(),
  })
  .and(offsetPaginationObjectSchema);

export const objectTriggerActionDefinitionObjectSchema = z.object({
  group: z.string().optional(),
  nullable: z.boolean().optional(),
  repeatable: z.boolean().optional(),
  subject: z.string().optional(),
  title: z.string().optional(),
  type: z.string().optional(),
  values: z
    .array(
      z.object({
        enabled: z.boolean().optional(),
        format: z.string().optional(),
        title: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
});

export const objectTriggerBulkUpdateItemSchema = z.object({
  active: z.boolean().optional(),
  id: z.number(),
  position: z.number().optional(),
});

export const objectTriggerBulkUpdateRequestSchema = z.object({
  triggers: z.array(objectTriggerBulkUpdateItemSchema).optional(),
});

export const objectTriggerConditionDefinitionObjectAllSchema = z.object({
  group: z.string().optional(),
  nullable: z.boolean().optional(),
  operators: z
    .array(
      z.object({
        format: z.string().optional(),
        terminal: z.boolean().optional(),
        title: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  repeatable: z.boolean().optional(),
  subject: z.string().optional(),
  title: z.string().optional(),
  type: z.string().optional(),
  values: z
    .array(
      z.object({
        enabled: z.boolean().optional(),
        title: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
});

export const objectTriggerConditionDefinitionObjectAnySchema = z.object({
  group: z.string().optional(),
  nullable: z.boolean().optional(),
  operators: z
    .array(
      z.object({
        format: z.string().optional(),
        terminal: z.boolean().optional(),
        title: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  repeatable: z.boolean().optional(),
  subject: z.string().optional(),
  title: z.string().optional(),
  type: z.string().optional(),
  values: z
    .array(
      z.object({
        enabled: z.boolean().optional(),
        title: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
});

export const objectTriggerDefinitionObjectSchema = z.object({
  actions: z.array(objectTriggerActionDefinitionObjectSchema).optional(),
  conditions_all: z.array(objectTriggerConditionDefinitionObjectAllSchema).optional(),
  conditions_any: z.array(objectTriggerConditionDefinitionObjectAnySchema).optional(),
});

export const objectTriggerDefinitionResponseSchema = z.object({
  definitions: objectTriggerDefinitionObjectSchema.optional(),
});

export const triggerActionObjectSchema = z.object({
  field: z.string().optional(),
  value: z.union([z.string(), z.number(), z.array(z.union([z.string(), z.number()]))]).optional(),
});

export const organizationFieldObjectSchema = customFieldObjectSchema;

export const organizationFieldResponseSchema = z.object({
  organization_field: organizationFieldObjectSchema.optional(),
});

export const organizationFieldsResponseSchema = z.object({
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  organization_fields: z.array(organizationFieldObjectSchema).optional(),
  previous_page: z.string().optional().nullable(),
});

export const organizationMembershipObjectSchema = z.object({
  created_at: z.string().optional(),
  default: z.boolean().nullable(),
  id: z.number().optional(),
  organization_id: z.number(),
  organization_name: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  user_id: z.number(),
  view_tickets: z.boolean().optional(),
});

export const organizationMembershipResponseSchema = z.object({
  organization_membership: organizationMembershipObjectSchema.optional(),
});

export const organizationMembershipsResponseSchema = z.object({
  organization_memberships: z.array(organizationMembershipObjectSchema).optional(),
});

export const organizationMergeListResponseSchema = z.object({
  organization_merges: z
    .array(
      z.object({
        id: z.string().optional(),
        loser_id: z.number().optional(),
        status: z
          .union([z.literal('new'), z.literal('in_progress'), z.literal('error'), z.literal('complete')])
          .optional(),
        url: z.string().optional(),
        winner_id: z.number().optional(),
      }),
    )
    .optional(),
});

export const organizationMergeRequestSchema = z.object({
  organization_merge: z
    .object({
      winner_id: z.number().optional(),
    })
    .optional(),
});

export const organizationMergeResponseSchema = z.object({
  organization_merge: z
    .object({
      id: z.string(),
      loser_id: z.number(),
      status: z.union([z.literal('new'), z.literal('in_progress'), z.literal('error'), z.literal('complete')]),
      url: z.string(),
      winner_id: z.number(),
    })
    .optional(),
});

export const status2Schema = z.union([
  z.literal('new'),
  z.literal('in_progress'),
  z.literal('error'),
  z.literal('complete'),
]);

export const organizationMetadataObjectSchema = z.object({
  tickets_count: z.number().optional(),
  users_count: z.number().optional(),
});

export const organizationResponseSchema = z.object({
  organization: organizationObjectSchema.optional(),
});

export const organizationSubscriptionInputSchema = z.object({
  organization_id: z.number().optional(),
  user_id: z.number().optional(),
});

export const organizationSubscriptionObjectSchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  organization_id: z.number().optional(),
  user_id: z.number().optional(),
});

export const organizationSubscriptionResponseSchema = z.object({
  organization_subscription: organizationSubscriptionObjectSchema.optional(),
});

export const organizationSubscriptionsResponseSchema = offsetPaginationObjectSchema.and(
  z.object({
    organization_subscriptions: z.array(organizationSubscriptionObjectSchema).optional(),
  }),
);

export const organizationsRelatedResponseSchema = z.object({
  organization_related: organizationMetadataObjectSchema.optional(),
});

export const organizationsResponseSchema = z.object({
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  organizations: z.array(organizationObjectSchema).optional(),
  previous_page: z.string().optional().nullable(),
});

export const paginationSchema = z.object({
  links: z
    .object({
      next: z.string().optional(),
      prev: z.string().optional(),
    })
    .optional(),
  meta: z
    .object({
      after_cursor: z.string().optional(),
      before_cursor: z.string().optional(),
      has_more: z.boolean().optional(),
    })
    .optional(),
});

export const pushNotificationDevicesInputSchema = z.array(z.string());

export const pushNotificationDevicesRequestSchema = z.object({
  push_notification_devices: pushNotificationDevicesInputSchema.optional(),
});

export const queueObjectSchema = z.object({
  created_at: z.string().optional(),
  definition: z
    .object({
      all: z
        .array(
          z.object({
            field: z.string().optional(),
            operator: z.string().optional(),
            value: z.string().optional(),
          }),
        )
        .optional(),
      any: z
        .array(
          z.object({
            field: z.string().optional(),
            operator: z.string().optional(),
            value: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  description: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  order: z.number().optional(),
  primary_groups: z
    .object({
      count: z.number().optional(),
      groups: z
        .array(
          z.object({
            id: z.number().optional(),
            name: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  priority: z.number().optional(),
  secondary_groups: z
    .object({
      count: z.number().optional(),
      groups: z
        .array(
          z.object({
            id: z.number().optional(),
            name: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const queueResponseSchema = z.object({
  queue: queueObjectSchema.optional(),
});

export const queuesResponseSchema = z.object({
  queues: z.array(queueObjectSchema).optional(),
});

export const recoverSuspendedTicketResponseSchema = z.object({
  ticket: z.array(ticketObjectSchema).optional(),
});

export const suspendedTicketObjectSchema = z.object({
  attachments: z.array(attachmentObjectSchema).optional().nullable(),
  author: authorObjectSchema.optional(),
  brand_id: z.number().optional(),
  cause: z.string().optional(),
  cause_id: z.number().optional(),
  content: z.string().optional(),
  created_at: z.string().optional(),
  error_messages: z.array(z.record(z.unknown())).optional().nullable(),
  id: z.number().optional(),
  message_id: z.string().optional(),
  recipient: z.string().optional(),
  subject: z.string().optional(),
  ticket_id: z.number().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  via: viaObjectSchema.optional(),
});

export const recoverSuspendedTicketsResponseSchema = z.object({
  tickets: z.array(ticketObjectSchema).optional(),
});

export const triggerConditionDefinitionObjectAllSchema = z.object({
  group: z.string().optional(),
  nullable: z.boolean().optional(),
  operators: z
    .array(
      z.object({
        terminal: z.boolean().optional(),
        title: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  repeatable: z.boolean().optional(),
  subject: z.string().optional(),
  title: z.string().optional(),
  type: z.string().optional(),
  values: z
    .array(
      z.object({
        enabled: z.boolean().optional(),
        title: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
});

export const triggerConditionDefinitionObjectAnySchema = z.object({
  group: z.string().optional(),
  nullable: z.boolean().optional(),
  operators: z
    .array(
      z.object({
        terminal: z.boolean().optional(),
        title: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  repeatable: z.boolean().optional(),
  subject: z.string().optional(),
  title: z.string().optional(),
  type: z.string().optional(),
});

export const relationshipFilterDefinitionSchema = z.object({
  conditions_all: z.array(triggerConditionDefinitionObjectAllSchema).optional(),
  conditions_any: z.array(triggerConditionDefinitionObjectAnySchema).optional(),
});

export const renewSessionResponseSchema = z.object({
  authenticity_token: z.string().optional(),
});

export const ticketAuditViaObjectSchema = z.object({
  channel: z.string().optional(),
  source: z.record(z.unknown()).optional(),
});

export const requestObjectSchema = z.object({
  assignee_id: z.number().optional(),
  can_be_solved_by_me: z.boolean().optional(),
  collaborator_ids: z.array(z.number()).optional(),
  created_at: z.string().optional(),
  custom_fields: z
    .array(
      z.object({
        id: z.number().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  custom_status_id: z.number().optional(),
  description: z.string().optional(),
  due_at: z.string().optional(),
  email_cc_ids: z.array(z.number()).optional(),
  followup_source_id: z.number().optional(),
  group_id: z.number().optional(),
  id: z.number().optional(),
  is_public: z.boolean().optional(),
  organization_id: z.number().optional(),
  priority: z.string().optional(),
  recipient: z.string().optional(),
  requester_id: z.number().optional(),
  solved: z.boolean().optional(),
  status: z.string().optional(),
  subject: z.string(),
  ticket_form_id: z.number().optional(),
  type: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  via: ticketAuditViaObjectSchema.optional(),
});

export const requestsResponseSchema = z.object({
  requests: z.array(requestObjectSchema).optional(),
});

export const resourceCollectionObjectSchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  resources: z
    .array(
      z.object({
        deleted: z.boolean().optional(),
        identifier: z.string().optional(),
        resource_id: z.number().optional(),
        type: z.string().optional(),
      }),
    )
    .optional(),
  updated_at: z.string().optional(),
});

export const resourceCollectionResponseSchema = z.object({
  resource_collection: resourceCollectionObjectSchema.optional(),
});

export const resourceCollectionsResponseSchema = z.object({
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
  resource_collections: z.array(resourceCollectionObjectSchema).optional(),
});

export const sLAPolicyFilterConditionObjectSchema = z.object({
  field: z.string().optional(),
  operator: z.string().optional(),
  value: z.union([z.string(), z.array(z.union([z.string(), z.number()]))]).optional(),
});

export const sLAPolicyFilterDefinitionResponseSchema = z.object({
  definitions: z
    .object({
      all: z
        .array(
          z.object({
            group: z.string().optional(),
            operators: z
              .array(
                z.object({
                  title: z.string().optional(),
                  value: z.string().optional(),
                }),
              )
              .optional(),
            target: z.string().optional().nullable(),
            title: z.string().optional(),
            value: z.string().optional(),
            values: z
              .object({
                list: z
                  .array(
                    z.object({
                      title: z.string().optional(),
                      value: z.string().optional().nullable(),
                    }),
                  )
                  .optional(),
                type: z.string().optional(),
              })
              .optional(),
          }),
        )
        .optional(),
      any: z
        .array(
          z.object({
            group: z.string().optional(),
            operators: z
              .array(
                z.object({
                  title: z.string().optional(),
                  value: z.string().optional(),
                }),
              )
              .optional(),
            target: z.string().optional().nullable(),
            title: z.string().optional(),
            value: z.string().optional(),
            values: z
              .object({
                list: z
                  .array(
                    z.object({
                      title: z.string().optional(),
                      value: z.string().optional().nullable(),
                    }),
                  )
                  .optional(),
                type: z.string().optional(),
              })
              .optional(),
          }),
        )
        .optional(),
    })
    .optional(),
});

export const sLAPolicyFilterObjectSchema = z.object({
  all: z.array(sLAPolicyFilterConditionObjectSchema).optional(),
  any: z.array(sLAPolicyFilterConditionObjectSchema).optional(),
});

export const sLAPolicyMetricObjectSchema = z.object({
  business_hours: z.boolean().optional(),
  metric: z.string().optional(),
  priority: z.string().optional(),
  target: z.number().optional(),
});

export const sLAPolicyObjectSchema = z.object({
  created_at: z.string().optional(),
  description: z.string().optional(),
  filter: sLAPolicyFilterObjectSchema,
  id: z.number().optional(),
  policy_metrics: z.array(sLAPolicyMetricObjectSchema).optional(),
  position: z.number().optional(),
  title: z.string(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const sLAPolicyResponseSchema = z.object({
  sla_policy: sLAPolicyObjectSchema.optional(),
});

export const satisfactionRatingObjectSchema = z.object({
  assignee_id: z.number(),
  comment: z.string().optional(),
  created_at: z.string().optional(),
  group_id: z.number(),
  id: z.number().optional(),
  reason: z.string().optional(),
  reason_code: z.number().optional(),
  reason_id: z.number().optional(),
  requester_id: z.number(),
  score: z.string(),
  ticket_id: z.number(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const satisfactionRatingResponseSchema = z.object({
  satisfaction_rating: z.array(satisfactionRatingObjectSchema).optional(),
});

export const satisfactionRatingsCountResponseSchema = z.object({
  count: z
    .object({
      refreshed_at: z.string().optional(),
      value: z.number().optional(),
    })
    .optional(),
});

export const satisfactionRatingsResponseSchema = z.object({
  satisfaction_ratings: z.array(satisfactionRatingObjectSchema).optional(),
});

export const satisfactionReasonObjectSchema = z.object({
  created_at: z.string().optional(),
  deleted_at: z.string().optional(),
  id: z.number().optional(),
  raw_value: z.string().optional(),
  reason_code: z.number().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  value: z.string(),
});

export const satisfactionReasonResponseSchema = z.object({
  reason: z.array(satisfactionReasonObjectSchema).optional(),
});

export const satisfactionReasonsResponseSchema = z.object({
  reasons: z.array(satisfactionReasonObjectSchema).optional(),
});

export const searchCountResponseSchema = z.object({
  count: z.number().optional(),
});

export const searchResultObjectSchema = z.object({
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  deleted: z.boolean().optional(),
  description: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  result_type: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const searchResponseSchema = z.object({
  count: z.number().optional(),
  facets: z.string().optional().nullable(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
  results: z.array(searchResultObjectSchema).optional(),
});

export const sessionObjectSchema = z.object({
  authenticated_at: z.string().optional().nullable(),
  id: z.number(),
  last_seen_at: z.string().optional().nullable(),
  url: z.string().optional().nullable(),
  user_id: z.number().optional().nullable(),
});

export const sessionResponseSchema = z.object({
  session: z.array(sessionObjectSchema).optional(),
});

export const sessionsResponseSchema = z.object({
  sessions: z.array(sessionObjectSchema).optional(),
});

export const sharingAgreementObjectSchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  partner_name: z.string().optional().nullable(),
  remote_subdomain: z.string().optional(),
  status: z.string().optional(),
  type: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const sharingAgreementResponseSchema = z.object({
  sharing_agreement: sharingAgreementObjectSchema.optional(),
});

export const sharingAgreementsResponseSchema = z.object({
  sharing_agreements: z.array(sharingAgreementObjectSchema).optional(),
});

export const skillBasedRoutingAttributeDefinitionsSchema = z.object({
  definitions: z
    .object({
      conditions_all: z
        .array(
          z.object({
            subject: z.string().optional(),
            title: z.string().optional(),
          }),
        )
        .optional(),
      conditions_any: z
        .array(
          z.object({
            subject: z.string().optional(),
            title: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
});

export const skillBasedRoutingAttributeObjectSchema = z.object({
  created_at: z.string().optional(),
  id: z.string().optional(),
  name: z.string(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const skillBasedRoutingAttributeResponseSchema = z.object({
  attribute: skillBasedRoutingAttributeObjectSchema.optional(),
});

export const skillBasedRoutingAttributeValueObjectSchema = z.object({
  attribute_id: z.string().optional(),
  created_at: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const skillBasedRoutingAttributeValueResponseSchema = z.object({
  attribute_value: skillBasedRoutingAttributeValueObjectSchema.optional(),
});

export const skillBasedRoutingAttributeValuesResponseSchema = z.object({
  attribute_values: z.array(skillBasedRoutingAttributeValueObjectSchema).optional(),
});

export const skillBasedRoutingAttributesResponseSchema = z.object({
  attributes: z.array(skillBasedRoutingAttributeObjectSchema).optional(),
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
});

export const skillBasedRoutingTicketFulfilledResponseSchema = z.object({
  fulfilled_ticket_ids: z.array(z.number()).optional(),
});

export const supportAddressObjectSchema = z.object({
  brand_id: z.number().optional(),
  cname_status: z.union([z.literal('unknown'), z.literal('verified'), z.literal('failed')]).optional(),
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  dns_results: z.union([z.literal('verified'), z.literal('failed')]).optional(),
  domain_verification_code: z.string().optional(),
  domain_verification_status: z.union([z.literal('unknown'), z.literal('verified'), z.literal('failed')]).optional(),
  email: z.string(),
  forwarding_status: z
    .union([z.literal('unknown'), z.literal('waiting'), z.literal('verified'), z.literal('failed')])
    .optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  spf_status: z.union([z.literal('unknown'), z.literal('verified'), z.literal('failed')]).optional(),
  updated_at: z.string().optional(),
});

export const cnameStatusSchema = z.union([z.literal('unknown'), z.literal('verified'), z.literal('failed')]);

export const dnsResultsSchema = z.union([z.literal('verified'), z.literal('failed')]);

export const domainVerificationStatusSchema = z.union([
  z.literal('unknown'),
  z.literal('verified'),
  z.literal('failed'),
]);

export const forwardingStatusSchema = z.union([
  z.literal('unknown'),
  z.literal('waiting'),
  z.literal('verified'),
  z.literal('failed'),
]);

export const spfStatusSchema = z.union([z.literal('unknown'), z.literal('verified'), z.literal('failed')]);

export const supportAddressResponseSchema = z.object({
  recipient_address: supportAddressObjectSchema.optional(),
});

export const supportAddressesResponseSchema = z.object({
  recipient_addresses: z.array(supportAddressObjectSchema).optional(),
});

export const suspendedTicketResponseSchema = z.object({
  suspended_ticket: z.array(suspendedTicketObjectSchema).optional(),
});

export const suspendedTicketsAttachmentsResponseSchema = z.object({
  upload: z
    .object({
      attachments: z.array(attachmentObjectSchema).optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const suspendedTicketsExportResponseSchema = z.object({
  export: z
    .object({
      status: z.string().optional(),
      view_id: z.string().optional(),
    })
    .optional(),
});

export const suspendedTicketsResponseSchema = z.object({
  suspended_tickets: z.array(suspendedTicketObjectSchema).optional(),
});

export const systemFieldOptionObjectSchema = z.object({
  name: z.string().optional(),
  value: z.string().optional(),
});

export const tagCountObjectSchema = z.object({
  refreshed_at: z.string().optional(),
  value: z.number().optional(),
});

export const tagCountResponseSchema = z.object({
  count: tagCountObjectSchema.optional(),
});

export const tagListTagObjectSchema = z.object({
  count: z.number().optional(),
  name: z.string().optional(),
});

export const tagUrlObjectSchema = z.object({
  url: z.string().optional(),
});

export const tagsByObjectIdResponseSchema = z.object({
  tags: z.array(z.string()),
});

export const tagsResponseSchema = z.object({
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
  tags: z.array(tagListTagObjectSchema).optional(),
});

export const targetBasecampSchema = z.object({
  message_id: z.string().optional(),
  password: z.string().optional(),
  project_id: z.string(),
  resource: z.string(),
  target_url: z.string(),
  todo_list_id: z.string().optional(),
  token: z.string(),
  username: z.string().optional(),
});

export const targetCampfireSchema = z.object({
  preserve_format: z.boolean().optional(),
  room: z.string(),
  ssl: z.boolean().optional(),
  subdomain: z.string(),
  token: z.string(),
});

export const targetClickatellSchema = z.object({
  api_id: z.string(),
  attribute: z.string().optional(),
  from: z.string().optional(),
  method: z.string().optional(),
  password: z.string(),
  target_url: z.string().optional(),
  to: z.string(),
  us_small_business_account: z.string().optional(),
  username: z.string(),
});

export const targetCommonFieldsSchema = z.object({
  active: z.boolean().optional(),
  created_at: z.string().optional(),
  id: z.number().optional(),
  title: z.string(),
  type: z.string(),
});

export const targetEmailSchema = z.object({
  email: z.string(),
  subject: z.string(),
});

export const targetFailureObjectSchema = z.object({
  consecutive_failure_count: z.number().optional(),
  created_at: z.string().optional(),
  id: z.number().optional(),
  raw_request: z.string().optional(),
  raw_response: z.string().optional(),
  status_code: z.number().optional(),
  target_name: z.string().optional(),
  url: z.string().optional(),
});

export const targetFailureResponseSchema = z.object({
  target_failure: targetFailureObjectSchema.optional(),
});

export const targetFailuresResponseSchema = z.object({
  target_failures: z.array(targetFailureObjectSchema).optional(),
});

export const targetFlowdockSchema = z.object({
  api_token: z.string(),
});

export const targetGetSatisfactionSchema = z.object({
  account_name: z.string(),
  email: z.string(),
  password: z.string(),
  target_url: z.string().optional(),
});

export const targetHTTPSchema = z.object({
  content_type: z.string(),
  method: z.string(),
  password: z.string().optional(),
  target_url: z.string(),
  username: z.string().optional(),
});

export const targetJiraSchema = z.object({
  password: z.string(),
  target_url: z.string(),
  username: z.string(),
});

export const targetPivotalSchema = z.object({
  owner_by: z.string().optional(),
  project_id: z.string(),
  requested_by: z.string().optional(),
  story_labels: z.string().optional(),
  story_title: z.string(),
  story_type: z.string(),
  token: z.string(),
});

export const targetTwitterSchema = z.object({
  secret: z.string().optional(),
  token: z.string().optional(),
});

export const targetURLSchema = z.object({
  attribute: z.string(),
  method: z.string().optional(),
  password: z.string().optional(),
  target_url: z.string(),
  username: z.string().optional(),
});

export const targetYammerSchema = z.object({
  group_id: z.string().optional(),
  token: z.string().optional(),
});

export const targetObjectSchema = targetCommonFieldsSchema.and(
  z.union([
    targetBasecampSchema,
    targetCampfireSchema,
    targetClickatellSchema,
    targetEmailSchema,
    targetFlowdockSchema,
    targetGetSatisfactionSchema,
    targetJiraSchema,
    targetPivotalSchema,
    targetTwitterSchema,
    targetURLSchema,
    targetHTTPSchema,
    targetYammerSchema,
  ]),
);

export const targetsResponseSchema = z.object({
  targets: z.array(targetObjectSchema).optional(),
});

export const ticketAuditObjectSchema = z.object({
  author_id: z.number().optional(),
  created_at: z.string().optional(),
  events: z.array(z.record(z.unknown())).optional(),
  id: z.number().optional(),
  metadata: z.record(z.unknown()).optional(),
  ticket_id: z.number().optional(),
  via: ticketAuditViaObjectSchema.optional(),
});

export const ticketAuditResponseSchema = z.object({
  audit: ticketAuditObjectSchema.optional(),
});

export const ticketAuditsCountResponseSchema = z.object({
  count: z
    .object({
      refreshed_at: z.string().optional(),
      value: z.number().optional(),
    })
    .optional(),
});

export const ticketAuditsResponseSchema = z.object({
  after_cursor: z.string().optional(),
  after_url: z.string().optional(),
  audits: z.array(ticketAuditObjectSchema).optional(),
  before_cursor: z.string().optional(),
  before_url: z.string().optional(),
});

export const ticketAuditsResponseNoneCursorSchema = z.object({
  audits: z.array(ticketAuditObjectSchema).optional(),
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
});

export const ticketChatCommentRedactionResponseSchema = z.object({
  chat_event: z
    .object({
      id: z.number().optional(),
      type: z.string().optional(),
      value: z
        .object({
          chat_id: z.string().optional(),
          history: z.array(z.record(z.unknown())).optional(),
          visitor_id: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
});

export const ticketCommentObjectSchema = z.object({
  attachments: z.array(attachmentObjectSchema).optional(),
  audit_id: z.number().optional(),
  author_id: z.number().optional(),
  body: z.string().optional(),
  created_at: z.string().optional(),
  html_body: z.string().optional(),
  id: z.number().optional(),
  metadata: z.record(z.unknown()).optional(),
  plain_body: z.string().optional(),
  public: z.boolean().optional(),
  type: z.string().optional(),
  uploads: z.array(z.string()).optional(),
  via: ticketAuditViaObjectSchema.optional(),
});

export const ticketCommentResponseSchema = z.object({
  comment: ticketCommentObjectSchema.optional(),
});

export const ticketCommentsCountResponseSchema = z.object({
  count: z
    .object({
      refreshed_at: z.string().optional(),
      value: z.number().optional(),
    })
    .optional(),
});

export const ticketCommentsResponseSchema = z.object({
  comments: z.array(ticketCommentObjectSchema).optional(),
});

export const ticketCreateVoicemailTicketVoiceCommentInputSchema = z.object({
  answered_by_id: z.number().optional(),
  call_duration: z.number().optional(),
  from: z.string().optional(),
  location: z.string().optional(),
  recording_url: z.string().optional(),
  started_at: z.string().optional(),
  to: z.string().optional(),
  transcription_text: z.string().optional(),
});

export const prioritySchema = z.union([z.literal('urgent'), z.literal('high'), z.literal('normal'), z.literal('low')]);

export const viaIdSchema = z.union([z.literal(44), z.literal(45), z.literal(46)]);

export const ticketCreateVoicemailTicketInputSchema = z.object({
  comment: ticketCommentObjectSchema.optional(),
  priority: z.union([z.literal('urgent'), z.literal('high'), z.literal('normal'), z.literal('low')]).optional(),
  via_id: z.union([z.literal(44), z.literal(45), z.literal(46)]).optional(),
  voice_comment: ticketCreateVoicemailTicketVoiceCommentInputSchema.optional(),
});

export const ticketFieldCountResponseSchema = z.object({
  count: z
    .object({
      refreshed_at: z.string().optional(),
      value: z.number().optional(),
    })
    .optional(),
});

export const ticketFieldCustomStatusObjectSchema = z.object({
  active: z.boolean().optional(),
  agent_label: z.string().optional(),
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  description: z.string().optional(),
  end_user_description: z.string().optional(),
  end_user_label: z.string().optional(),
  id: z.number().optional(),
  status_category: z
    .union([z.literal('new'), z.literal('open'), z.literal('pending'), z.literal('hold'), z.literal('solved')])
    .optional(),
  updated_at: z.string().optional(),
});

export const ticketFieldObjectSchema = z.object({
  active: z.boolean().optional(),
  agent_description: z.string().optional(),
  collapsed_for_agents: z.boolean().optional(),
  created_at: z.string().optional(),
  creator_app_name: z.string().optional(),
  creator_user_id: z.number().optional(),
  custom_field_options: z.array(customFieldOptionObjectSchema).optional(),
  custom_statuses: z.array(ticketFieldCustomStatusObjectSchema).optional(),
  description: z.string().optional(),
  editable_in_portal: z.boolean().optional(),
  id: z.number().optional(),
  position: z.number().optional(),
  raw_description: z.string().optional(),
  raw_title: z.string().optional(),
  raw_title_in_portal: z.string().optional(),
  regexp_for_validation: z.string().optional().nullable(),
  relationship_filter: z.record(z.unknown()).optional(),
  relationship_target_type: z.string().optional(),
  removable: z.boolean().optional(),
  required: z.boolean().optional(),
  required_in_portal: z.boolean().optional(),
  sub_type_id: z.number().optional(),
  system_field_options: z.array(systemFieldOptionObjectSchema).optional(),
  tag: z.string().optional().nullable(),
  title: z.string(),
  title_in_portal: z.string().optional(),
  type: z.string(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  visible_in_portal: z.boolean().optional(),
});

export const ticketFieldResponseSchema = z.object({
  ticket_field: ticketFieldObjectSchema.optional(),
});

export const ticketFieldsResponseSchema = z.object({
  ticket_fields: z.array(ticketFieldObjectSchema).optional(),
});

export const ticketFormObjectSchema = z.object({
  active: z.boolean().optional(),
  agent_conditions: z.array(z.record(z.unknown())).optional(),
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  display_name: z.string().optional(),
  end_user_conditions: z.array(z.record(z.unknown())).optional(),
  end_user_visible: z.boolean().optional(),
  id: z.number().optional(),
  in_all_brands: z.boolean().optional(),
  name: z.string(),
  position: z.number().optional(),
  raw_display_name: z.string().optional(),
  raw_name: z.string().optional(),
  restricted_brand_ids: z.array(z.number()).optional(),
  ticket_field_ids: z.array(z.number()).optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const ticketFormResponseSchema = z.object({
  ticket_form: ticketFormObjectSchema.optional(),
});

export const ticketFormsResponseSchema = z.object({
  ticket_forms: z.array(ticketFormObjectSchema).optional(),
});

export const ticketImportInputSchema = z.object({
  assignee_id: z.number().optional(),
  comments: z
    .array(
      z
        .object({
          value: z.string().optional(),
        })
        .and(ticketCommentObjectSchema),
    )
    .optional(),
  description: z.string().optional(),
  requester_id: z.number().optional(),
  subject: z.string().optional(),
  tags: z.array(z.string()).optional(),
});

export const ticketImportRequestSchema = z.object({
  ticket: ticketImportInputSchema.optional(),
});

export const ticketMergeInputSchema = z.object({
  ids: z.array(z.number()),
  source_comment: z.string().optional(),
  source_comment_is_public: z.boolean().optional(),
  target_comment: z.string().optional(),
  target_comment_is_public: z.boolean().optional(),
});

export const metricSchema = z.union([
  z.literal('agent_work_time'),
  z.literal('pausable_update_time'),
  z.literal('periodic_update_time'),
  z.literal('reply_time'),
  z.literal('requester_wait_time'),
  z.literal('resolution_time'),
  z.literal('group_ownership_time'),
]);

export const typeSchema = z.union([
  z.literal('activate'),
  z.literal('pause'),
  z.literal('fulfill'),
  z.literal('apply_sla'),
  z.literal('apply_group_sla'),
  z.literal('breach'),
  z.literal('update_status'),
  z.literal('measure'),
]);

export const ticketMetricEventBreachObjectSchema = ticketMetricEventBaseObjectSchema.and(
  z.object({
    deleted: z.boolean().optional(),
  }),
);

export const ticketMetricEventGroupSLAObjectSchema = ticketMetricEventBaseObjectSchema.and(
  z.object({
    group_sla: z.record(z.unknown()).optional(),
  }),
);

export const ticketMetricEventSLAObjectSchema = ticketMetricEventBaseObjectSchema.and(
  z.object({
    sla: z.record(z.unknown()).optional(),
  }),
);

export const ticketMetricEventUpdateStatusObjectSchema = ticketMetricEventBaseObjectSchema.and(
  z.object({
    status: z.record(z.unknown()).optional(),
  }),
);

export const ticketMetricEventsResponseSchema = z
  .object({
    ticket_metric_events: z.array(ticketMetricEventBaseObjectSchema).optional(),
  })
  .and(
    z.object({
      count: z.number().optional(),
      end_time: z.number().optional(),
      next_page: z.string().optional(),
    }),
  );

export const ticketMetricTimeObjectSchema = z.object({
  business: z.number().optional(),
  calendar: z.number().optional(),
});

export const ticketMetricObjectSchema = z.object({
  agent_wait_time_in_minutes: ticketMetricTimeObjectSchema.optional(),
  assigned_at: z.string().optional(),
  assignee_stations: z.number().optional(),
  assignee_updated_at: z.string().optional(),
  created_at: z.string().optional(),
  custom_status_updated_at: z.string().optional(),
  first_resolution_time_in_minutes: ticketMetricTimeObjectSchema.optional(),
  full_resolution_time_in_minutes: ticketMetricTimeObjectSchema.optional(),
  group_stations: z.number().optional(),
  id: z.number().optional(),
  initially_assigned_at: z.string().optional(),
  latest_comment_added_at: z.string().optional(),
  on_hold_time_in_minutes: ticketMetricTimeObjectSchema.optional(),
  reopens: z.number().optional(),
  replies: z.number().optional(),
  reply_time_in_minutes: ticketMetricTimeObjectSchema.optional(),
  reply_time_in_seconds: ticketMetricTimeObjectSchema.optional(),
  requester_updated_at: z.string().optional(),
  requester_wait_time_in_minutes: ticketMetricTimeObjectSchema.optional(),
  solved_at: z.string().optional(),
  status_updated_at: z.string().optional(),
  ticket_id: z.number().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const ticketMetricsResponseSchema = z.object({
  ticket_metrics: z.array(ticketMetricObjectSchema).optional(),
});

export const status3Schema = z.union([
  z.literal('new'),
  z.literal('open'),
  z.literal('pending'),
  z.literal('hold'),
  z.literal('solved'),
  z.literal('closed'),
]);

export const type2Schema = z.union([
  z.literal('problem'),
  z.literal('incident'),
  z.literal('question'),
  z.literal('task'),
]);

export const ticketRelatedInformationSchema = z.object({
  followup_source_ids: z.array(z.string()).optional(),
  from_archive: z.boolean().optional(),
  incidents: z.number().optional(),
  jira_issue_ids: z.array(z.string()).optional(),
  topic_id: z.string().optional().nullable(),
});

export const ticketResponseSchema = z.object({
  ticket: ticketObjectSchema.optional(),
});

export const ticketSkipObjectSchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  reason: z.string().optional(),
  ticket: ticketObjectSchema.optional(),
  ticket_id: z.number().optional(),
  updated_at: z.string().optional(),
  user_id: z.number().optional(),
});

export const ticketSkipsResponseSchema = z.object({
  skips: z.array(ticketSkipObjectSchema).optional(),
});

export const emailCCObjectSchema = followerObjectSchema.and(
  z.object({
    action: z.union([z.literal('put'), z.literal('delete')]).optional(),
    user_email: z.string().optional(),
    user_id: z.string().optional(),
    user_name: z.string().optional(),
  }),
);

export const ticketUpdateInputSchema = z.object({
  additional_collaborators: z.array(collaboratorObjectSchema).optional(),
  assignee_email: z.string().optional(),
  assignee_id: z.number().optional(),
  attribute_value_ids: z.array(z.number()).optional(),
  collaborator_ids: z.array(z.number()).optional(),
  comment: ticketCommentObjectSchema.optional(),
  custom_fields: z.array(customFieldObjectSchema).optional(),
  custom_status_id: z.number().optional(),
  due_at: z.string().optional().nullable(),
  email_ccs: z.array(emailCCObjectSchema).optional(),
  external_id: z.string().optional(),
  followers: z.array(followerObjectSchema).optional(),
  group_id: z.number().optional(),
  organization_id: z.number().optional(),
  priority: z.union([z.literal('urgent'), z.literal('high'), z.literal('normal'), z.literal('low')]).optional(),
  problem_id: z.number().optional(),
  requester_id: z.number().optional(),
  safe_update: z.boolean().optional(),
  sharing_agreement_ids: z.array(z.number()).optional(),
  status: z
    .union([
      z.literal('new'),
      z.literal('open'),
      z.literal('pending'),
      z.literal('hold'),
      z.literal('solved'),
      z.literal('closed'),
    ])
    .optional(),
  subject: z.string().optional(),
  tags: z.array(z.string()).optional(),
  type: z.union([z.literal('problem'), z.literal('incident'), z.literal('question'), z.literal('task')]).optional(),
  updated_stamp: z.string().optional(),
});

export const auditObjectSchema = z.object({
  author_id: z.number().optional(),
  created_at: z.string().optional(),
  events: z
    .array(
      z.object({
        body: z.string().optional(),
        field_name: z.string().optional(),
        id: z.number().optional(),
        type: z.string().optional(),
        value: z.union([z.string(), z.number()]).optional(),
      }),
    )
    .optional(),
  id: z.number().optional(),
  metadata: z.record(z.unknown()).optional(),
  ticket_id: z.number().optional(),
  via: viaObjectSchema.optional(),
});

export const ticketCreateInputSchema = ticketUpdateInputSchema.and(
  z.object({
    brand_id: z.number().optional(),
    collaborators: z.array(collaboratorObjectSchema).optional(),
    email_cc_ids: z.array(z.number()).optional(),
    follower_ids: z.array(z.number()).optional(),
    macro_ids: z.array(z.number()).optional(),
    raw_subject: z.string().optional(),
    recipient: z.string().optional(),
    submitter_id: z.number().optional(),
    ticket_form_id: z.number().optional(),
    via: viaObjectSchema.optional(),
    via_followup_source_id: z.number().optional(),
  }),
);

export const ticketsResponseSchema = z.object({
  tickets: z.array(ticketObjectSchema).optional(),
});

export const timeBasedExportIncrementalTicketsResponseSchema = z.object({
  count: z.number().optional(),
  end_of_stream: z.boolean().optional(),
  end_time: z.number().optional(),
  next_page: z.string().optional().nullable(),
  tickets: z.array(ticketObjectSchema).optional(),
});

export const trialAccountObjectSchema = z.object({
  name: z.string().optional(),
  subdomain: z.string().optional(),
  url: z.string().optional(),
});

export const trialAccountResponseSchema = z.object({
  account: trialAccountObjectSchema.optional(),
});

export const triggerActionDefinitionObjectSchema = z.object({
  group: z.string().optional(),
  nullable: z.boolean().optional(),
  repeatable: z.boolean().optional(),
  subject: z.string().optional(),
  title: z.string().optional(),
  type: z.string().optional(),
  values: z
    .array(
      z.object({
        enabled: z.boolean().optional(),
        title: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
});

export const triggerChangeObjectSchema = z.object({
  change: z.string().optional(),
  content: z
    .union([z.boolean(), z.string(), z.number(), z.array(z.union([z.string(), z.number(), z.boolean()]))])
    .optional(),
});

export const triggerBulkUpdateItemSchema = z.object({
  active: z.boolean().optional(),
  category_id: z.string().optional(),
  id: z.number(),
  position: z.number().optional(),
});

export const triggerBulkUpdateRequestSchema = z.object({
  triggers: z.array(triggerBulkUpdateItemSchema).optional(),
});

export const triggerCategoriesResponseSchema = z.object({
  trigger_categories: z.array(triggerCategorySchema).optional(),
});

export const triggerCategoryIdSchema = z.string();

export const triggerCategoryRequestSchema = z.object({
  name: z.string().optional(),
  position: z.number().optional(),
});

export const triggerCategoryRequestRequiredSchema = z.record(z.unknown());

export const triggerCategoryResponseSchema = z.object({
  trigger_category: triggerCategorySchema.optional(),
});

export const triggerCategoryRuleCountsSchema = z.object({
  active_count: z.number().optional(),
  inactive_count: z.number().optional(),
});

export const triggerConditionDiffObjectSchema = z.object({
  field: z.array(triggerChangeObjectSchema).optional(),
  operator: z.array(triggerChangeObjectSchema).optional(),
  value: z.array(triggerChangeObjectSchema).optional(),
});

export const triggerConditionObjectSchema = z.object({
  field: z.string().optional(),
  operator: z.string().optional(),
  value: z.union([z.string(), z.number(), z.array(z.union([z.string(), z.number()]))]).optional(),
});

export const triggerConditionsDiffObjectSchema = z.object({
  all: z.array(triggerConditionDiffObjectSchema).optional().nullable(),
  any: z.array(triggerConditionDiffObjectSchema).optional().nullable(),
});

export const triggerConditionsObjectSchema = z.object({
  all: z.array(triggerConditionObjectSchema).optional().nullable(),
  any: z.array(triggerConditionObjectSchema).optional().nullable(),
});

export const triggerDefinitionObjectSchema = z.object({
  actions: z.array(triggerActionDefinitionObjectSchema).optional(),
  conditions_all: z.array(triggerConditionDefinitionObjectAllSchema).optional(),
  conditions_any: z.array(triggerConditionDefinitionObjectAnySchema).optional(),
});

export const triggerDefinitionResponseSchema = z.object({
  definitions: triggerDefinitionObjectSchema.optional(),
});

export const triggerObjectSchema = z.object({
  actions: z.array(triggerActionObjectSchema),
  active: z.boolean().optional(),
  category_id: z.string().optional(),
  conditions: triggerConditionsObjectSchema,
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  description: z.string().optional(),
  id: z.number().optional(),
  position: z.number().optional(),
  raw_title: z.string().optional(),
  title: z.string(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const triggerResponseSchema = z.object({
  trigger: triggerObjectSchema.optional(),
});

export const triggerRevisionResponseSchema = z.object({
  trigger_revision: z
    .object({
      author_id: z.number().optional(),
      created_at: z.string().optional(),
      id: z.number().optional(),
      snapshot: z
        .object({
          actions: z.array(triggerActionObjectSchema).optional(),
          active: z.boolean().optional(),
          conditions: triggerConditionsObjectSchema.optional(),
          description: z.string().optional().nullable(),
          title: z.string().optional(),
        })
        .optional(),
      url: z.string().optional(),
    })
    .optional(),
});

export const triggerActionDiffObjectSchema = z.object({
  field: z.array(triggerChangeObjectSchema).optional(),
  value: z.array(triggerChangeObjectSchema).optional(),
});

export const triggerSnapshotObjectSchema = z.object({
  actions: z.array(triggerActionObjectSchema).optional(),
  active: z.boolean().optional(),
  conditions: triggerConditionsObjectSchema.optional(),
  description: z.string().optional().nullable(),
  title: z.string().optional(),
});

export const triggerWithCategoryRequestSchema = z.object({
  trigger: triggerObjectSchema.and(z.union([triggerCategorySchema, triggerCategoryIdSchema])).optional(),
});

export const triggersResponseSchema = z.object({
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
  triggers: z.array(triggerObjectSchema).optional(),
});

export const twitterChannelObjectSchema = z.object({
  allow_reply: z.boolean().optional(),
  avatar_url: z.string().optional(),
  brand_id: z.number().optional(),
  can_reply: z.boolean().optional(),
  created_at: z.string().optional(),
  id: z.number(),
  name: z.string().optional(),
  screen_name: z.string(),
  twitter_user_id: z.number(),
  updated_at: z.string().optional(),
});

export const twitterChannelResponseSchema = z.object({
  monitored_twitter_handle: twitterChannelObjectSchema.optional(),
});

export const twitterChannelTwicketStatusResponseSchema = z.object({
  statuses: z
    .array(
      z.object({
        favorited: z.boolean().optional(),
        id: z.number().optional(),
        retweeted: z.boolean().optional(),
        user_followed: z.boolean().optional(),
      }),
    )
    .optional(),
});

export const twitterChannelsResponseSchema = z.object({
  monitored_twitter_handles: z.array(twitterChannelObjectSchema).optional(),
});

export const urlObjectSchema = z.object({
  url: z.string().optional(),
});

export const userCreateInputSchema = z.object({
  custom_role_id: z.number().optional(),
  email: z.string(),
  external_id: z.string().optional(),
  identities: z
    .array(
      z.object({
        type: z.string(),
        value: z.string(),
      }),
    )
    .optional(),
  name: z.string(),
  organization: z
    .object({
      name: z.string(),
    })
    .optional(),
  organization_id: z.number().optional(),
  role: z.string().optional(),
});

export const userFieldObjectSchema = customFieldObjectSchema;

export const userFieldResponseSchema = z.object({
  user_field: userFieldObjectSchema.optional(),
});

export const userFieldsResponseSchema = z.object({
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
  user_fields: z.array(userFieldObjectSchema).optional(),
});

export const userForAdminSchema = z.object({
  active: z.boolean().optional(),
  alias: z.string().optional(),
  chat_only: z.boolean().optional(),
  created_at: z.string().optional(),
  custom_role_id: z.number().optional().nullable(),
  default_group_id: z.number().optional(),
  details: z.string().optional(),
  email: z.string().optional(),
  external_id: z.string().optional().nullable(),
  iana_time_zone: z.string().optional(),
  id: z.number().optional(),
  last_login_at: z.string().optional(),
  locale: z.string().optional(),
  locale_id: z.number().optional(),
  moderator: z.boolean().optional(),
  name: z.string(),
  notes: z.string().optional(),
  only_private_comments: z.boolean().optional(),
  organization_id: z.number().optional().nullable(),
  phone: z.string().optional().nullable(),
  photo: z.record(z.unknown()).optional().nullable(),
  remote_photo_url: z.string().optional(),
  report_csv: z.boolean().optional(),
  restricted_agent: z.boolean().optional(),
  role: z.string().optional(),
  role_type: z.number().optional().nullable(),
  shared: z.boolean().optional(),
  shared_agent: z.boolean().optional(),
  shared_phone_number: z.boolean().optional().nullable(),
  signature: z.string().optional(),
  suspended: z.boolean().optional(),
  tags: z.array(z.string()).optional(),
  ticket_restriction: z.string().optional().nullable(),
  time_zone: z.string().optional(),
  two_factor_auth_enabled: z.boolean().optional().nullable(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  user_fields: z.record(z.unknown()).optional(),
  verified: z.boolean().optional(),
});

export const userForEndUserSchema = z.object({
  created_at: z.string().optional(),
  email: z.string().optional(),
  iana_time_zone: z.string().optional(),
  id: z.number().optional(),
  locale: z.string().optional(),
  locale_id: z.number().optional(),
  name: z.string(),
  organization_id: z.number().optional(),
  phone: z.string().optional(),
  photo: z.record(z.unknown()).optional(),
  role: z.string().optional(),
  shared_phone_number: z.boolean().optional(),
  time_zone: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  verified: z.boolean().optional(),
});

export const userIdentityObjectSchema = z.object({
  created_at: z.string().optional(),
  deliverable_state: z.string().optional(),
  id: z.number().optional(),
  primary: z.boolean().optional(),
  type: z.union([
    z.literal('email'),
    z.literal('twitter'),
    z.literal('facebook'),
    z.literal('google'),
    z.literal('phone_number'),
    z.literal('agent_forwarding'),
    z.literal('any_channel'),
    z.literal('foreign'),
    z.literal('sdk'),
  ]),
  undeliverable_count: z.number().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  user_id: z.number(),
  value: z.string(),
  verified: z.boolean().optional(),
});

export const type3Schema = z.union([
  z.literal('email'),
  z.literal('twitter'),
  z.literal('facebook'),
  z.literal('google'),
  z.literal('phone_number'),
  z.literal('agent_forwarding'),
  z.literal('any_channel'),
  z.literal('foreign'),
  z.literal('sdk'),
]);

export const userIdentityResponseSchema = z.object({
  identity: userIdentityObjectSchema.optional(),
});

export const userMergePropertiesInputSchema = z.object({
  email: z.string().optional(),
  name: z.string().optional(),
  organization_id: z.number().optional(),
  password: z.string().optional(),
});

export const userMergeByIdInputSchema = z.object({
  id: z.number().optional(),
});

export const userObjectSchema = z.union([userForAdminSchema, userForEndUserSchema]);

export const userPasswordRequirementsResponseSchema = z.object({
  requirements: z.array(z.string()).optional(),
});

export const userRelatedObjectSchema = z.object({
  assigned_tickets: z.number().optional(),
  ccd_tickets: z.number().optional(),
  organization_subscriptions: z.number().optional(),
  requested_tickets: z.number().optional(),
});

export const userRelatedResponseSchema = z.object({
  user_related: userRelatedObjectSchema.optional(),
});

export const userInputSchema = z.union([
  userCreateInputSchema,
  userMergePropertiesInputSchema,
  userMergeByIdInputSchema,
]);

export const userResponseSchema = z.object({
  user: userObjectSchema.optional(),
});

export const usersRequestSchema = z.object({
  users: z.array(userInputSchema),
});

export const usersResponseSchema = z.object({
  users: z.array(userObjectSchema).optional(),
});

export const viewCategorySchema = z.object({
  created_at: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  position: z.number().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const viewCategoryErrorSchema = z.object({
  code: z.string(),
  detail: z.string().optional(),
  id: z.string().optional(),
  links: z.record(z.unknown()).optional(),
  source: z.record(z.unknown()).optional(),
  status: z.string().optional(),
  title: z.string(),
});

export const viewCategoryErrorsSchema = z.object({
  errors: z.array(viewCategoryErrorSchema).optional(),
});

export const viewCategoryRequestSchema = z.object({
  name: z.string().optional(),
});

export const viewCategoryRequestRequiredSchema = z.record(z.unknown());

export const viewCategoryResponseSchema = z.object({
  view_category: viewCategorySchema.optional(),
});

export const viewCountObjectSchema = z.object({
  active: z.boolean().optional(),
  fresh: z.boolean().optional(),
  pretty: z.string().optional(),
  url: z.string().optional(),
  value: z.number().optional().nullable(),
  view_id: z.number().optional(),
});

export const viewCountResponseSchema = z.object({
  view_count: viewCountObjectSchema.optional(),
});

export const viewCountsResponseSchema = z.object({
  view_counts: z.array(viewCountObjectSchema).optional(),
});

export const viewExportResponseSchema = z.object({
  export: z
    .object({
      status: z.string().optional(),
      view_id: z.number().optional(),
    })
    .optional(),
});

export const viewObjectSchema = z.object({
  active: z.boolean().optional(),
  conditions: z.record(z.unknown()).optional(),
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  description: z.string().optional(),
  execution: z.record(z.unknown()).optional(),
  id: z.number().optional(),
  position: z.number().optional(),
  restriction: z.record(z.unknown()).optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
});

export const viewResponseSchema = z.object({
  columns: z.array(z.record(z.unknown())).optional(),
  groups: z.array(z.record(z.unknown())).optional(),
  rows: z.array(z.record(z.unknown())).optional(),
  view: viewObjectSchema.optional(),
});

export const viewsCountResponseSchema = z.object({
  count: z
    .object({
      refreshed_at: z.string().optional(),
      value: z.number().optional(),
    })
    .optional(),
});

export const viewsResponseSchema = z.object({
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
  views: z.array(viewObjectSchema).optional(),
});

export const workspaceInputSchema = z.object({
  conditions: conditionsObjectSchema.optional(),
  description: z.string().optional(),
  macros: z.array(z.number()).optional(),
  ticket_form_id: z.number().optional(),
  title: z.string().optional(),
});

export const workspaceObjectSchema = z.object({
  activated: z.boolean().optional(),
  apps: z.array(z.record(z.unknown())).optional(),
  conditions: conditionsObjectSchema.optional(),
  created_at: z.string().optional(),
  description: z.string().optional(),
  id: z.number().optional(),
  macro_ids: z.array(z.number()).optional(),
  macros: z.array(z.number()).optional(),
  position: z.number().optional(),
  prefer_workspace_app_order: z.boolean().optional(),
  selected_macros: z.array(macroObjectSchema).optional(),
  ticket_form_id: z.number().optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const workspaceResponseSchema = z
  .object({
    workspaces: z.array(workspaceObjectSchema).optional(),
  })
  .and(offsetPaginationObjectSchema);

export const parameterActivityIdSchema = z.number();

export const parameterActivitySinceSchema = z.string();

export const parameterAgentIdSchema = z.number();

export const parameterArchiveImmediatelySchema = z.boolean();

export const parameterAssigneeFieldSearchValueSchema = z.string();

export const parameterAttachmentIdSchema = z.number();

export const parameterAuditLogIdSchema = z.number();

export const parameterAutomationActiveSchema = z.boolean();

export const parameterAutomationIdSchema = z.number();

export const parameterAutomationIncludeSchema = z.string();

export const parameterAutomationSearchQuerySchema = z.string();

export const parameterAutomationSortBySchema = z.string();

export const parameterAutomationSortOrderSchema = z.string();

export const parameterBookmarkIdSchema = z.number();

export const parameterBrandIdSchema = z.number();

export const parameterCommentIdSchema = z.number();

export const parameterCreatorSchema = z.boolean();

export const parameterCustomObjectFieldKeyOrIdSchema = z.string();

export const parameterCustomObjectKeySchema = z.string();

export const parameterCustomObjectRecordExternalIdSchema = z.string();

export const parameterCustomObjectRecordIdSchema = z.string();

export const parameterCustomRoleIdSchema = z.number();

export const parameterCustomStatusIdSchema = z.number();

export const parameterDeletedUserIdSchema = z.number();

export const parameterDeletionScheduleIdSchema = z.number();

export const parameterDynamicContentItemIdSchema = z.number();

export const parameterDynamicContentVariantIdSchema = z.number();

export const parameterEmailNotificationsFilterSchema = z.union([
  z.literal('ticket_id'),
  z.literal('comment_id'),
  z.literal('notification_id'),
]);

export const parameterEssentialsCardKeySchema = z.string();

export const parameterExcludeDeletedSchema = z.boolean();

export const parameterGroupIdSchema = z.number();

export const parameterGroupMembershipIdSchema = z.number();

export const parameterGroupSLAPolicyIdSchema = z.number();

export const parameterHostMappingSchema = z.string();

export const parameterIncludeStandardFieldsSchema = z.boolean();

export const parameterIncrementalCursorSchema = z.string();

export const parameterIncrementalPageSchema = z.number();

export const parameterIncrementalResourceSchema = z.string();

export const parameterIncrementalTimeQueryParameterSchema = z.number();

export const parameterIncrementalUnixTimeSchema = z.number();

export const parameterJobStatusIdSchema = z.string();

export const parameterLocaleIdSchema = z.string();

export const parameterLookupRelationshipAutocompleteFieldIdFragmentSchema = z.string();

export const parameterLookupRelationshipAutocompleteSourceFragmentSchema = z.string();

export const parameterMacroAccessSchema = z.string();

export const parameterMacroActiveSchema = z.boolean();

export const parameterMacroCategorySchema = z.number();

export const parameterMacroGroupIdSchema = z.number();

export const parameterMacroIdSchema = z.number();

export const parameterMacroIdQuerySchema = z.number();

export const parameterMacroIncludeSchema = z.string();

export const parameterMacroOnlyViewableSchema = z.boolean();

export const parameterMacroQuerySchema = z.string();

export const parameterMacroSearchSortBySchema = z.string();

export const parameterMacroSortBySchema = z.string();

export const parameterMacroSortOrderSchema = z.string();

export const parameterMonitoredTwitterHandleIdSchema = z.number();

export const parameterNotificationIdSchema = z.number();

export const parameterObjectKeySchema = z.string();

export const parameterOcrQueueIdSchema = z.string();

export const parameterOrganizationExternalIdSchema = z.number();

export const parameterOrganizationExternalIdsSchema = z.string();

export const parameterOrganizationFieldIdSchema = z.union([z.number(), z.string()]);

export const parameterOrganizationIdSchema = z.number();

export const parameterOrganizationIdsSchema = z.string();

export const parameterOrganizationMembershipIdSchema = z.number();

export const parameterOrganizationMergeIdSchema = z.string();

export const parameterOrganizationNameSchema = z.string();

export const parameterOrganizationQueryFragmentSchema = z.string();

export const parameterOrganizationSubscriptionIdSchema = z.number();

export const parameterRequestIdSchema = z.number();

export const parameterResourceCollectionIdSchema = z.number();

export const parameterSLAPolicyIdSchema = z.number();

export const parameterSessionIdSchema = z.number();

export const parameterSharingAgreementIdSchema = z.number();

export const parameterSkillBasedRoutingAttributeIdSchema = z.string();

export const parameterSkillBasedRoutingAttributeValueIdSchema = z.string();

export const parameterSkipTicketUserIdSchema = z.number();

export const parameterSortSchema = z.string();

export const parameterSubdomainSchema = z.string();

export const parameterSupportAddressIdSchema = z.number();

export const parameterSuspendedTicketIdSchema = z.number();

export const parameterSuspendedTicketIdsSchema = z.string();

export const parameterSuspendedTicketsDeleteIdsSchema = z.string();

export const parameterSuspendedTicketsRecoverIdsSchema = z.string();

export const parameterSuspendedTicketsSortBySchema = z.string();

export const parameterSuspendedTicketsSortOrderSchema = z.string();

export const parameterTagNameFragmentSchema = z.string();

export const parameterTargetFailureIdSchema = z.number();

export const parameterTargetIdSchema = z.number();

export const parameterTicketAuditIdSchema = z.number();

export const parameterTicketCommentIdSchema = z.number();

export const parameterTicketFieldIdSchema = z.number();

export const parameterTicketFieldOptionIdSchema = z.number();

export const parameterTicketFormIdSchema = z.number();

export const parameterTicketIdSchema = z.number();

export const parameterTicketIdsSchema = z.string();

export const parameterTicketSortBySchema = z.union([z.literal('id'), z.literal('subject'), z.literal('deleted_at')]);

export const parameterTicketSortOrderSchema = z.union([z.literal('asc'), z.literal('desc')]);

export const parameterTriggerActiveSchema = z.boolean();

export const parameterTriggerCategoryIdSchema = z.string();

export const parameterTriggerIdSchema = z.number();

export const parameterTriggerIdsSchema = z.string();

export const parameterTriggerIncludeSchema = z.string();

export const parameterTriggerRevisionIdSchema = z.number();

export const parameterTriggerSearchFilterSchema = z.object({
  json: triggerObjectSchema.optional(),
});

export const parameterTriggerSearchQuerySchema = z.string();

export const parameterTriggerSortSchema = z.string();

export const parameterTriggerSortBySchema = z.string();

export const parameterTriggerSortOrderSchema = z.string();

export const parameterUserExternalIdFilterSchema = z.string();

export const parameterUserFieldIdSchema = z.union([z.number(), z.string()]);

export const parameterUserFieldOptionIdSchema = z.number();

export const parameterUserIdSchema = z.number();

export const parameterUserIdentityIdSchema = z.number();

export const parameterUserPermissionSetFilterSchema = z.number();

export const parameterUserRoleFilterSchema = z.union([z.literal('end-user'), z.literal('agent'), z.literal('admin')]);

export const parameterUserRolesFilterSchema = z.string();

export const parameterViewIdSchema = z.number();

export const parameterWorkspaceIdSchema = z.number();

export const listAssigneeFieldAssignableGroupsAndAgentsSearchDataSchema = z.object({
  query: z.object({
    name: z.string(),
  }),
});

export const assigneeFieldAssignableGroupsAndAgentsSearchResponseSchema = z.object({
  agents: z.array(assigneeFieldAssignableSearchAgentObjectSchema).optional(),
  count: z.number().optional(),
  groups: z.array(assigneeFieldAssignableSearchGroupObjectSchema).optional(),
});

export const listAssigneeFieldAssignableGroupsAndAgentsSearchErrorSchema = z.unknown();

export const listAssigneeFieldAssignableGroupsResponseSchema = assigneeFieldAssignableGroupsResponseSchema;

export const listAssigneeFieldAssignableGroupsErrorSchema = z.unknown();

export const listAssigneeFieldAssignableGroupAgentsDataSchema = z.object({
  path: z.object({
    group_id: z.number(),
  }),
});

export const listAssigneeFieldAssignableGroupAgentsResponseSchema = assigneeFieldAssignableGroupAgentsResponseSchema;

export const listAssigneeFieldAssignableGroupAgentsErrorSchema = z.unknown();

export const getSourcesByTargetDataSchema = z.object({
  path: z.object({
    field_id: z.number(),
    source_type: z.string(),
    target_id: z.number(),
    target_type: z.string(),
  }),
});

export const reverseLookupResponseSchema = usersResponseSchema;

export const getSourcesByTargetErrorSchema = z.unknown();

export const accountSettingsResponseSchema = z.object({
  settings: accountSettingsObjectSchema.optional(),
});

export const showAccountSettingsErrorSchema = z.unknown();

export const updateAccountSettingsResponseSchema = accountSettingsResponseSchema;

export const updateAccountSettingsErrorSchema = z.unknown();

export const createTrialAccountResponseSchema = trialAccountResponseSchema;

export const createTrialAccountErrorSchema = z.unknown();

export const verifySubdomainAvailabilityDataSchema = z.object({
  query: z.object({
    subdomain: z.string(),
  }),
});

export const verifySubdomainAvailabilityResponseSchema = z.object({
  success: z.boolean().optional(),
});

export const verifySubdomainAvailabilityErrorSchema = z.unknown();

export const listActivitiesDataSchema = z.object({
  query: z
    .object({
      since: z.string().optional(),
    })
    .optional(),
});

export const listActivitiesErrorSchema = z.unknown();

export const showActivityDataSchema = z.object({
  path: z.object({
    activity_id: z.number(),
  }),
});

export const showActivityErrorSchema = z.unknown();

export const countActivitiesResponseSchema = activitiesCountResponseSchema;

export const countActivitiesErrorSchema = z.unknown();

export const reportChannelbackErrorResponseSchema = z.string();

export const reportChannelbackErrorErrorSchema = z.unknown();

export const pushContentToSupportErrorSchema = z.unknown();

export const validateTokenResponseSchema = z.string();

export const validateTokenErrorSchema = z.unknown();

export const showAttachmentDataSchema = z.object({
  path: z.object({
    attachment_id: z.number(),
  }),
});

export const attachmentResponseSchema = z.object({
  attachment: attachmentObjectSchema.optional(),
});

export const showAttachmentErrorSchema = z.unknown();

export const updateAttachmentDataSchema = z.object({
  body: attachmentUpdateRequestSchema.optional(),
  path: z.object({
    attachment_id: z.number(),
  }),
});

export const updateAttachmentResponseSchema = attachmentResponseSchema;

export const updateAttachmentErrorSchema = z.unknown();

export const listAuditLogsDataSchema = z.object({
  query: z
    .object({
      'filter[action]': z.string().optional(),
      'filter[actor_id]': z.number().optional(),
      'filter[created_at]': z.string().optional(),
      'filter[ip_address]': z.string().optional(),
      'filter[source_id]': z.number().optional(),
      'filter[source_type]': z.string().optional(),
      sort: z.string().optional(),
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const listAuditLogsResponseSchema = auditLogsResponseSchema;

export const listAuditLogsErrorSchema = z.unknown();

export const showAuditLogDataSchema = z.object({
  path: z.object({
    audit_log_id: z.number(),
  }),
});

export const showAuditLogResponseSchema = auditLogResponseSchema;

export const showAuditLogErrorSchema = z.unknown();

export const exportAuditLogsDataSchema = z.object({
  query: z
    .object({
      'filter[action]': z.string().optional(),
      'filter[actor_id]': z.number().optional(),
      'filter[created_at]': z.string().optional(),
      'filter[ip_address]': z.string().optional(),
      'filter[source_id]': z.number().optional(),
      'filter[source_type]': z.string().optional(),
    })
    .optional(),
});

export const exportAuditLogsResponseSchema = z.string();

export const exportAuditLogsErrorSchema = z.unknown();

export const autocompleteTagsDataSchema = z.object({
  query: z
    .object({
      name: z.string().optional(),
    })
    .optional(),
});

export const autocompleteTagsResponseSchema = tagsByObjectIdResponseSchema;

export const autocompleteTagsErrorSchema = z.unknown();

export const listAutomationsErrorSchema = z.unknown();

export const createAutomationErrorSchema = z.unknown();

export const showAutomationDataSchema = z.object({
  path: z.object({
    automation_id: z.number(),
  }),
});

export const showAutomationErrorSchema = z.unknown();

export const updateAutomationDataSchema = z.object({
  path: z.object({
    automation_id: z.number(),
  }),
});

export const updateAutomationErrorSchema = z.unknown();

export const deleteAutomationDataSchema = z.object({
  path: z.object({
    automation_id: z.number(),
  }),
});

export const deleteAutomationResponseSchema = z.any();

export const deleteAutomationErrorSchema = z.unknown();

export const listActiveAutomationsErrorSchema = z.unknown();

export const bulkDeleteAutomationsDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
    })
    .optional(),
});

export const bulkDeleteAutomationsResponseSchema = z.any();

export const bulkDeleteAutomationsErrorSchema = z.unknown();

export const searchAutomationsDataSchema = z.object({
  query: z.object({
    active: z.boolean().optional(),
    include: z.string().optional(),
    query: z.string(),
    sort_by: z.string().optional(),
    sort_order: z.string().optional(),
  }),
});

export const searchAutomationsErrorSchema = z.unknown();

export const updateManyAutomationsErrorSchema = z.unknown();

export const listBookmarksErrorSchema = z.unknown();

export const bookmarkCreateRequestSchema = z.object({
  bookmark: bookmarkInputSchema.optional(),
});

export const createBookmarkErrorSchema = z.unknown();

export const deleteBookmarkDataSchema = z.object({
  path: z.object({
    bookmark_id: z.number(),
  }),
});

export const deleteBookmarkResponseSchema = z.any();

export const deleteBookmarkErrorSchema = z.unknown();

export const listBrandsResponseSchema = brandsResponseSchema;

export const listBrandsErrorSchema = z.unknown();

export const brandCreateRequestSchema = z.object({
  brand: brandObjectSchema.optional(),
});

export const createBrandResponseSchema = brandResponseSchema;

export const createBrandErrorSchema = z.unknown();

export const showBrandDataSchema = z.object({
  path: z.object({
    brand_id: z.number(),
  }),
});

export const showBrandResponseSchema = brandResponseSchema;

export const showBrandErrorSchema = z.unknown();

export const updateBrandDataSchema = z.object({
  body: brandUpdateRequestSchema.optional(),
  path: z.object({
    brand_id: z.number(),
  }),
});

export const updateBrandResponseSchema = brandResponseSchema;

export const updateBrandErrorSchema = z.unknown();

export const deleteBrandDataSchema = z.object({
  path: z.object({
    brand_id: z.number(),
  }),
});

export const deleteBrandResponseSchema = z.any();

export const deleteBrandErrorSchema = z.unknown();

export const checkHostMappingValidityForExistingBrandDataSchema = z.object({
  path: z.object({
    brand_id: z.number(),
  }),
});

export const checkHostMappingValidityForExistingBrandResponseSchema = hostMappingObjectSchema;

export const checkHostMappingValidityForExistingBrandErrorSchema = z.unknown();

export const checkHostMappingValidityDataSchema = z.object({
  query: z.object({
    host_mapping: z.string(),
    subdomain: z.string(),
  }),
});

export const checkHostMappingValidityResponseSchema = hostMappingObjectSchema;

export const checkHostMappingValidityErrorSchema = z.unknown();

export const listMonitoredTwitterHandlesResponseSchema = twitterChannelsResponseSchema;

export const listMonitoredTwitterHandlesErrorSchema = z.unknown();

export const showMonitoredTwitterHandleDataSchema = z.object({
  path: z.object({
    monitored_twitter_handle_id: z.number(),
  }),
});

export const showMonitoredTwitterHandleResponseSchema = twitterChannelResponseSchema;

export const showMonitoredTwitterHandleErrorSchema = z.unknown();

export const createTicketFromTweetResponseSchema = z.string();

export const createTicketFromTweetErrorSchema = z.unknown();

export const gettingTwicketStatusDataSchema = z.object({
  path: z.object({
    comment_id: z.number(),
  }),
  query: z
    .object({
      ids: z.string().optional(),
    })
    .optional(),
});

export const gettingTwicketStatusResponseSchema = twitterChannelTwicketStatusResponseSchema;

export const gettingTwicketStatusErrorSchema = z.unknown();

export const openTicketInAgentBrowserDataSchema = z.object({
  path: z.object({
    agent_id: z.number(),
    ticket_id: z.number(),
  }),
});

export const openTicketInAgentBrowserResponseSchema = z.string();

export const openTicketInAgentBrowserErrorSchema = z.string();

export const openUsersProfileInAgentBrowserDataSchema = z.object({
  path: z.object({
    agent_id: z.number(),
    user_id: z.number(),
  }),
});

export const openUsersProfileInAgentBrowserResponseSchema = z.string();

export const openUsersProfileInAgentBrowserErrorSchema = z.string();

export const ticketCreateVoicemailTicketRequestSchema = z.object({
  display_to_agent: z.number().optional(),
  ticket: ticketCreateVoicemailTicketInputSchema.optional(),
});

export const createTicketOrVoicemailTicketResponseSchema = ticketResponseSchema;

export const createTicketOrVoicemailTicketErrorSchema = z.string();

export const redactChatCommentAttachmentDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const redactChatCommentAttachmentResponseSchema = ticketChatCommentRedactionResponseSchema;

export const redactChatCommentAttachmentErrorSchema = z.unknown();

export const redactChatCommentDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const redactChatCommentResponseSchema = ticketChatCommentRedactionResponseSchema;

export const redactChatCommentErrorSchema = z.unknown();

export const redactTicketCommentInAgentWorkspaceDataSchema = z.object({
  path: z.object({
    ticket_comment_id: z.number(),
  }),
});

export const redactTicketCommentInAgentWorkspaceResponseSchema = ticketCommentResponseSchema;

export const redactTicketCommentInAgentWorkspaceErrorSchema = z.unknown();

export const listCustomObjectsResponseSchema = customObjectsResponseSchema;

export const listCustomObjectsErrorSchema = z.unknown();

export const createCustomObjectDataSchema = z.object({
  body: customObjectsCreateRequestSchema.optional(),
});

export const createCustomObjectResponseSchema = customObjectResponseSchema;

export const createCustomObjectErrorSchema = z.unknown();

export const showCustomObjectDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
});

export const showCustomObjectResponseSchema = customObjectResponseSchema;

export const showCustomObjectErrorSchema = z.unknown();

export const updateCustomObjectDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
});

export const updateCustomObjectResponseSchema = customObjectResponseSchema;

export const updateCustomObjectErrorSchema = z.unknown();

export const deleteCustomObjectDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
});

export const deleteCustomObjectResponseSchema = z.any();

export const deleteCustomObjectErrorSchema = z.unknown();

export const listCustomObjectFieldsDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
  query: z
    .object({
      include_standard_fields: z.boolean().optional(),
    })
    .optional(),
});

export const listCustomObjectFieldsResponseSchema = customObjectFieldsResponseSchema;

export const listCustomObjectFieldsErrorSchema = z.unknown();

export const createCustomObjectFieldDataSchema = z.object({
  body: customObjectFieldsCreateRequestSchema.optional(),
  path: z.object({
    custom_object_key: z.string(),
  }),
});

export const customObjectFieldResponseSchema = z.object({
  custom_object_field: customObjectFieldSchema.optional(),
});

export const createCustomObjectFieldErrorSchema = z.unknown();

export const showCustomObjectFieldDataSchema = z.object({
  path: z.object({
    custom_object_field_key_or_id: z.string(),
    custom_object_key: z.string(),
  }),
});

export const showCustomObjectFieldResponseSchema = customObjectFieldResponseSchema;

export const showCustomObjectFieldErrorSchema = z.unknown();

export const updateCustomObjectFieldDataSchema = z.object({
  path: z.object({
    custom_object_field_key_or_id: z.string(),
    custom_object_key: z.string(),
  }),
});

export const updateCustomObjectFieldResponseSchema = customObjectFieldResponseSchema;

export const updateCustomObjectFieldErrorSchema = z.unknown();

export const deleteCustomObjectFieldDataSchema = z.object({
  path: z.object({
    custom_object_field_key_or_id: z.string(),
    custom_object_key: z.string(),
  }),
});

export const deleteCustomObjectFieldResponseSchema = z.any();

export const deleteCustomObjectFieldErrorSchema = z.unknown();

export const reorderCustomObjectFieldsDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
});

export const reorderCustomObjectFieldsResponseSchema = z.string();

export const reorderCustomObjectFieldsErrorSchema = z.unknown();

export const customObjectRecordBulkJobsDataSchema = z.object({
  body: customObjectRecordsBulkCreateRequestSchema.optional(),
  path: z.object({
    custom_object_key: z.string(),
  }),
});

export const customObjectRecordBulkJobsResponseSchema = customObjectRecordsJobsResponseSchema;

export const customObjectRecordBulkJobsErrorSchema = z.unknown();

export const customObjectFieldsLimitDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
});

export const customObjectFieldsLimitResponseSchema = customObjectLimitsResponseSchema;

export const customObjectFieldsLimitErrorSchema = z.unknown();

export const listCustomObjectRecordsDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
  query: z
    .object({
      'filter[external_ids]': z.string().optional(),
      'filter[ids]': z.string().optional(),
      'page[after]': z.string().optional(),
      'page[before]': z.string().optional(),
      'page[size]': z.number().optional(),
      sort: z.string().optional(),
    })
    .optional(),
});

export const listCustomObjectRecordsResponseSchema = customObjectRecordsResponseSchema;

export const listCustomObjectRecordsErrorSchema = z.unknown();

export const createCustomObjectRecordDataSchema = z.object({
  body: customObjectRecordsCreateRequestSchema.optional(),
  path: z.object({
    custom_object_key: z.string(),
  }),
});

export const createCustomObjectRecordResponseSchema = customObjectRecordResponseSchema;

export const createCustomObjectRecordErrorSchema = z.unknown();

export const upsertCustomObjectRecordDataSchema = z.object({
  body: customObjectRecordsUpsertRequestSchema.optional(),
  path: z.object({
    custom_object_key: z.string(),
  }),
  query: z.object({
    external_id: z.string(),
  }),
});

export const upsertCustomObjectRecordResponseSchema = customObjectRecordResponseSchema;

export const upsertCustomObjectRecordErrorSchema = z.unknown();

export const deleteCustomObjectRecordByExternalIdDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
  query: z.object({
    external_id: z.string(),
  }),
});

export const deleteCustomObjectRecordByExternalIdResponseSchema = z.any();

export const deleteCustomObjectRecordByExternalIdErrorSchema = z.unknown();

export const showCustomObjectRecordDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
    custom_object_record_id: z.string(),
  }),
});

export const showCustomObjectRecordResponseSchema = customObjectRecordResponseSchema;

export const showCustomObjectRecordErrorSchema = z.unknown();

export const updateCustomObjectRecordDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
    custom_object_record_id: z.string(),
  }),
});

export const updateCustomObjectRecordResponseSchema = customObjectRecordResponseSchema;

export const updateCustomObjectRecordErrorSchema = z.unknown();

export const deleteCustomObjectRecordDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
    custom_object_record_id: z.string(),
  }),
});

export const deleteCustomObjectRecordResponseSchema = z.any();

export const deleteCustomObjectRecordErrorSchema = z.unknown();

export const autocompleteCustomObjectRecordSearchDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
  query: z
    .object({
      assignee_id: z.number().optional(),
      field_id: z.string().optional(),
      name: z.string().optional(),
      organization_id: z.number().optional(),
      'page[after]': z.string().optional(),
      'page[before]': z.string().optional(),
      'page[size]': z.number().optional(),
      requester_id: z.number().optional(),
      source: z.string().optional(),
    })
    .optional(),
});

export const autocompleteCustomObjectRecordSearchResponseSchema = customObjectRecordsResponseSchema;

export const autocompleteCustomObjectRecordSearchErrorSchema = z.unknown();

export const countCustomObjectRecordsDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
});

export const countCustomObjectRecordsResponseSchema = z.object({
  count: z
    .record(
      z.object({
        refreshed_at: z.string().optional(),
        value: z.number().optional(),
      }),
    )
    .optional(),
});

export const countCustomObjectRecordsErrorSchema = z.unknown();

export const searchCustomObjectRecordsDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
  query: z
    .object({
      'page[after]': z.string().optional(),
      'page[before]': z.string().optional(),
      'page[size]': z.number().optional(),
      query: z.string().optional(),
      sort: z.string().optional(),
    })
    .optional(),
});

export const searchCustomObjectRecordsResponseSchema = customObjectRecordsResponseSchema;

export const searchCustomObjectRecordsErrorSchema = z.unknown();

export const filteredSearchCustomObjectRecordsDataSchema = z.object({
  body: z
    .union([customObjectRecordsFilteredSearchRequestBasicSchema, customObjectRecordsFilteredSearchRequestComplexSchema])
    .optional(),
  path: z.object({
    custom_object_key: z.string(),
  }),
  query: z
    .object({
      'page[after]': z.string().optional(),
      'page[before]': z.string().optional(),
      'page[size]': z.number().optional(),
      query: z.string().optional(),
      sort: z.string().optional(),
    })
    .optional(),
});

export const filteredSearchCustomObjectRecordsResponseSchema = customObjectRecordsResponseSchema;

export const filteredSearchCustomObjectRecordsErrorSchema = z.unknown();

export const listObjectTriggersDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
  query: z
    .object({
      active: z.boolean().optional(),
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const listObjectTriggersErrorSchema = z.unknown();

export const createObjectTriggerErrorSchema = z.unknown();

export const getObjectTriggerDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
    trigger_id: z.number(),
  }),
});

export const getObjectTriggerErrorSchema = z.unknown();

export const updateObjectTriggerErrorSchema = z.unknown();

export const deleteObjectTriggerDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
    trigger_id: z.number(),
  }),
});

export const deleteObjectTriggerResponseSchema = z.any();

export const deleteObjectTriggerErrorSchema = z.unknown();

export const listActiveObjectTriggersDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
  query: z
    .object({
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const listActiveObjectTriggersErrorSchema = z.unknown();

export const listObjectTriggersDefinitionsDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
});

export const listObjectTriggersDefinitionsResponseSchema = objectTriggerDefinitionResponseSchema;

export const listObjectTriggersDefinitionsErrorSchema = z.unknown();

export const deleteManyObjectTriggersDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
  query: z.object({
    ids: z.string(),
  }),
});

export const deleteManyObjectTriggersResponseSchema = z.any();

export const deleteManyObjectTriggersErrorSchema = z.unknown();

export const searchObjectTriggersDataSchema = z.object({
  path: z.object({
    custom_object_key: z.string(),
  }),
  query: z.object({
    active: z.boolean().optional(),
    filter: z
      .object({
        json: triggerObjectSchema.optional(),
      })
      .optional(),
    include: z.string().optional(),
    query: z.string(),
    sort: z.string().optional(),
    sort_by: z.string().optional(),
    sort_order: z.string().optional(),
  }),
});

export const searchObjectTriggersErrorSchema = z.unknown();

export const updateManyObjectTriggersDataSchema = z.object({
  body: objectTriggerBulkUpdateRequestSchema,
  path: z.object({
    custom_object_key: z.string(),
  }),
});

export const updateManyObjectTriggersErrorSchema = z.unknown();

export const customObjectsLimitResponseSchema = customObjectLimitsResponseSchema;

export const customObjectsLimitErrorSchema = z.unknown();

export const customObjectRecordsLimitResponseSchema = customObjectLimitsResponseSchema;

export const customObjectRecordsLimitErrorSchema = z.unknown();

export const listCustomRolesResponseSchema = customRolesResponseSchema;

export const listCustomRolesErrorSchema = z.unknown();

export const createCustomRoleResponseSchema = customRoleResponseSchema;

export const createCustomRoleErrorSchema = z.unknown();

export const showCustomRoleByIdDataSchema = z.object({
  path: z.object({
    custom_role_id: z.number(),
  }),
});

export const showCustomRoleByIdResponseSchema = customRoleResponseSchema;

export const showCustomRoleByIdErrorSchema = z.unknown();

export const updateCustomRoleByIdDataSchema = z.object({
  path: z.object({
    custom_role_id: z.number(),
  }),
});

export const updateCustomRoleByIdResponseSchema = customRoleResponseSchema;

export const updateCustomRoleByIdErrorSchema = z.unknown();

export const deleteCustomRoleByIdDataSchema = z.object({
  path: z.object({
    custom_role_id: z.number(),
  }),
});

export const deleteCustomRoleByIdResponseSchema = z.any();

export const deleteCustomRoleByIdErrorSchema = z.unknown();

export const bulkUpdateDefaultCustomStatusDataSchema = z.object({
  body: bulkUpdateDefaultCustomStatusRequestSchema.optional(),
});

export const bulkUpdateDefaultCustomStatusResponse2Schema = bulkUpdateDefaultCustomStatusResponseSchema;

export const bulkUpdateDefaultCustomStatusErrorSchema = z.unknown();

export const listCustomStatusesDataSchema = z.object({
  query: z
    .object({
      active: z.boolean().optional(),
      default: z.boolean().optional(),
      status_categories: z.string().optional(),
    })
    .optional(),
});

export const listCustomStatusesResponseSchema = customStatusesResponseSchema;

export const listCustomStatusesErrorSchema = z.unknown();

export const customStatusCreateRequestSchema = z.object({
  custom_status: customStatusCreateInputSchema.optional(),
});

export const createCustomStatusResponseSchema = customStatusResponseSchema;

export const createCustomStatusErrorSchema = z.unknown();

export const showCustomStatusDataSchema = z.object({
  path: z.object({
    custom_status_id: z.number(),
  }),
});

export const showCustomStatusResponseSchema = customStatusResponseSchema;

export const showCustomStatusErrorSchema = z.unknown();

export const updateCustomStatusDataSchema = z.object({
  body: customStatusUpdateRequestSchema.optional(),
  path: z.object({
    custom_status_id: z.number(),
  }),
});

export const updateCustomStatusResponseSchema = customStatusResponseSchema;

export const updateCustomStatusErrorSchema = z.unknown();

export const listDeletedTicketsDataSchema = z.object({
  query: z
    .object({
      sort_by: z.union([z.literal('id'), z.literal('subject'), z.literal('deleted_at')]).optional(),
      sort_order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
    })
    .optional(),
});

export const listDeletedTicketsResponse2Schema = listDeletedTicketsResponseSchema;

export const listDeletedTicketsErrorSchema = z.unknown();

export const deleteTicketPermanentlyDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const deleteTicketPermanentlyErrorSchema = z.unknown();

export const restoreDeletedTicketDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const restoreDeletedTicketResponseSchema = z.string();

export const restoreDeletedTicketErrorSchema = z.unknown();

export const bulkPermanentlyDeleteTicketsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const bulkPermanentlyDeleteTicketsErrorSchema = z.unknown();

export const bulkRestoreDeletedTicketsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const bulkRestoreDeletedTicketsResponseSchema = z.string();

export const bulkRestoreDeletedTicketsErrorSchema = z.unknown();

export const listDeletedUsersResponseSchema = deletedUsersResponseSchema;

export const listDeletedUsersErrorSchema = z.unknown();

export const showDeletedUserDataSchema = z.object({
  path: z.object({
    deleted_user_id: z.number(),
  }),
});

export const showDeletedUserResponseSchema = deletedUserResponseSchema;

export const showDeletedUserErrorSchema = z.unknown();

export const permanentlyDeleteUserDataSchema = z.object({
  path: z.object({
    deleted_user_id: z.number(),
  }),
});

export const permanentlyDeleteUserResponseSchema = deletedUserResponseSchema;

export const permanentlyDeleteUserErrorSchema = z.unknown();

export const countDeletedUsersResponseSchema = countResponseSchema;

export const countDeletedUsersErrorSchema = z.unknown();

export const listDeletionSchedulesResponseSchema = z.object({
  deletion_schedules: z.array(deletionScheduleSchema).optional(),
});

export const listDeletionSchedulesErrorSchema = z.unknown();

export const createDeletionScheduleDataSchema = z.object({
  body: z.object({
    deletion_schedule: deletionScheduleSchema.optional(),
  }),
});

export const createDeletionScheduleResponseSchema = z.object({
  deletion_schedule: deletionScheduleSchema.optional(),
});

export const createDeletionScheduleErrorSchema = z.unknown();

export const getDeletionScheduleDataSchema = z.object({
  path: z.object({
    deletion_schedule_id: z.number(),
  }),
});

export const getDeletionScheduleResponseSchema = z.object({
  deletion_schedule: deletionScheduleSchema.optional(),
});

export const getDeletionScheduleErrorSchema = z.unknown();

export const updateDeletionScheduleDataSchema = z.object({
  body: z.object({
    deletion_schedule: deletionScheduleSchema.optional(),
  }),
  path: z.object({
    deletion_schedule_id: z.number(),
  }),
});

export const updateDeletionScheduleResponseSchema = z.object({
  deletion_schedule: deletionScheduleSchema.optional(),
});

export const updateDeletionScheduleErrorSchema = z.unknown();

export const deleteDeletionScheduleDataSchema = z.object({
  path: z.object({
    deletion_schedule_id: z.number(),
  }),
});

export const deleteDeletionScheduleResponseSchema = z.any();

export const deleteDeletionScheduleErrorSchema = z.unknown();

export const listDynamicContentsResponseSchema = dynamicContentsResponseSchema;

export const listDynamicContentsErrorSchema = z.unknown();

export const dynamicContentResponseSchema = z.object({
  item: dynamicContentObjectSchema.optional(),
});

export const createDynamicContentErrorSchema = z.unknown();

export const showDynamicContentItemDataSchema = z.object({
  path: z.object({
    dynamic_content_item_id: z.number(),
  }),
});

export const showDynamicContentItemResponseSchema = dynamicContentResponseSchema;

export const showDynamicContentItemErrorSchema = z.unknown();

export const updateDynamicContentItemDataSchema = z.object({
  path: z.object({
    dynamic_content_item_id: z.number(),
  }),
});

export const updateDynamicContentItemResponseSchema = dynamicContentResponseSchema;

export const updateDynamicContentItemErrorSchema = z.unknown();

export const deleteDynamicContentItemDataSchema = z.object({
  path: z.object({
    dynamic_content_item_id: z.number(),
  }),
});

export const deleteDynamicContentItemResponseSchema = z.any();

export const deleteDynamicContentItemErrorSchema = z.unknown();

export const dynamicContentListVariantsDataSchema = z.object({
  path: z.object({
    dynamic_content_item_id: z.number(),
  }),
});

export const dynamicContentListVariantsResponseSchema = dynamicContentVariantsResponseSchema;

export const dynamicContentListVariantsErrorSchema = z.unknown();

export const createDynamicContentVariantDataSchema = z.object({
  path: z.object({
    dynamic_content_item_id: z.number(),
  }),
});

export const createDynamicContentVariantResponseSchema = dynamicContentVariantResponseSchema;

export const createDynamicContentVariantErrorSchema = z.unknown();

export const showDynamicContentVariantDataSchema = z.object({
  path: z.object({
    dynamic_content_item_id: z.number(),
    dynammic_content_variant_id: z.number(),
  }),
});

export const showDynamicContentVariantResponseSchema = dynamicContentVariantResponseSchema;

export const showDynamicContentVariantErrorSchema = z.unknown();

export const updateDynamicContentVariantDataSchema = z.object({
  path: z.object({
    dynamic_content_item_id: z.number(),
    dynammic_content_variant_id: z.number(),
  }),
});

export const updateDynamicContentVariantResponseSchema = dynamicContentVariantResponseSchema;

export const updateDynamicContentVariantErrorSchema = z.unknown();

export const deleteDynamicContentVariantDataSchema = z.object({
  path: z.object({
    dynamic_content_item_id: z.number(),
    dynammic_content_variant_id: z.number(),
  }),
});

export const deleteDynamicContentVariantResponseSchema = z.any();

export const deleteDynamicContentVariantErrorSchema = z.unknown();

export const createManyDynamicContentVariantsDataSchema = z.object({
  path: z.object({
    dynamic_content_item_id: z.number(),
  }),
});

export const createManyDynamicContentVariantsResponseSchema = dynamicContentVariantsResponseSchema;

export const createManyDynamicContentVariantsErrorSchema = z.unknown();

export const updateManyDynamicContentVariantsDataSchema = z.object({
  path: z.object({
    dynamic_content_item_id: z.number(),
  }),
});

export const updateManyDynamicContentVariantsResponseSchema = dynamicContentVariantsResponseSchema;

export const updateManyDynamicContentVariantsErrorSchema = z.unknown();

export const showManyDynamicContentsDataSchema = z.object({
  query: z
    .object({
      identifiers: z.string().optional(),
    })
    .optional(),
});

export const showManyDynamicContentsResponseSchema = dynamicContentsResponseSchema;

export const showManyDynamicContentsErrorSchema = z.unknown();

export const listEmailNotificationsDataSchema = z.object({
  query: z
    .object({
      filter: z.union([z.literal('ticket_id'), z.literal('comment_id'), z.literal('notification_id')]).optional(),
      per_page: z.number().optional(),
      sort: z.string().optional(),
    })
    .optional(),
});

export const listEmailNotificationsResponseSchema = emailNotificationsResponseSchema;

export const listEmailNotificationsErrorSchema = z.unknown();

export const showEmailNotificationDataSchema = z.object({
  path: z.object({
    notification_id: z.number(),
  }),
});

export const emailNotificationResponseSchema = z.object({
  email_notification: emailNotificationObjectSchema.optional(),
});

export const showEmailNotificationErrorSchema = z.unknown();

export const listGroupMembershipsDataSchema = z.object({
  path: z.object({
    group_id: z.number(),
    user_id: z.number(),
  }),
});

export const listGroupMembershipsResponseSchema = groupMembershipsResponseSchema;

export const listGroupMembershipsErrorSchema = z.unknown();

export const createGroupMembershipResponseSchema = groupMembershipResponseSchema;

export const createGroupMembershipErrorSchema = z.unknown();

export const showGroupMembershipByIdDataSchema = z.object({
  path: z.object({
    group_membership_id: z.number(),
    user_id: z.number(),
  }),
});

export const showGroupMembershipByIdResponseSchema = groupMembershipResponseSchema;

export const showGroupMembershipByIdErrorSchema = z.unknown();

export const deleteGroupMembershipDataSchema = z.object({
  path: z.object({
    group_membership_id: z.number(),
    user_id: z.number(),
  }),
});

export const deleteGroupMembershipResponseSchema = z.any();

export const deleteGroupMembershipErrorSchema = z.unknown();

export const listAssignableGroupMembershipsResponseSchema = groupMembershipsResponseSchema;

export const listAssignableGroupMembershipsErrorSchema = z.unknown();

export const groupMembershipBulkCreateErrorSchema = z.unknown();

export const groupMembershipBulkDeleteDataSchema = z.object({
  query: z
    .object({
      ids: z.string().optional(),
    })
    .optional(),
});

export const groupMembershipBulkDeleteErrorSchema = z.unknown();

export const groupSLAPoliciesResponseSchema = z.object({
  count: z.number().optional(),
  group_sla_policies: z.array(groupSLAPolicyObjectSchema).optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
});

export const listGroupSlaPoliciesErrorSchema = z.unknown();

export const createGroupSlaPolicyResponseSchema = groupSLAPolicyResponseSchema;

export const createGroupSlaPolicyErrorSchema = z.unknown();

export const showGroupSlaPolicyDataSchema = z.object({
  path: z.object({
    group_sla_policy_id: z.number(),
  }),
});

export const showGroupSlaPolicyResponseSchema = groupSLAPolicyResponseSchema;

export const showGroupSlaPolicyErrorSchema = z.unknown();

export const updateGroupSlaPolicyDataSchema = z.object({
  path: z.object({
    group_sla_policy_id: z.number(),
  }),
});

export const updateGroupSlaPolicyResponseSchema = groupSLAPolicyResponseSchema;

export const updateGroupSlaPolicyErrorSchema = z.unknown();

export const deleteGroupSlaPolicyDataSchema = z.object({
  path: z.object({
    group_sla_policy_id: z.number(),
  }),
});

export const deleteGroupSlaPolicyResponseSchema = z.any();

export const deleteGroupSlaPolicyErrorSchema = z.unknown();

export const retrieveGroupSlaPolicyFilterDefinitionItemsResponseSchema = groupSLAPolicyFilterDefinitionResponseSchema;

export const retrieveGroupSlaPolicyFilterDefinitionItemsErrorSchema = z.unknown();

export const reorderGroupSlaPoliciesDataSchema = z.object({
  query: z
    .object({
      group_sla_policy_ids: z.array(z.string()).optional(),
    })
    .optional(),
});

export const reorderGroupSlaPoliciesResponseSchema = z.string();

export const reorderGroupSlaPoliciesErrorSchema = z.unknown();

export const listGroupsDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
  query: z
    .object({
      exclude_deleted: z.boolean().optional(),
    })
    .optional(),
});

export const listGroupsResponseSchema = groupsResponseSchema;

export const listGroupsErrorSchema = z.unknown();

export const createGroupResponseSchema = groupResponseSchema;

export const createGroupErrorSchema = z.unknown();

export const showGroupByIdDataSchema = z.object({
  path: z.object({
    group_id: z.number(),
  }),
});

export const showGroupByIdResponseSchema = groupResponseSchema;

export const showGroupByIdErrorSchema = z.unknown();

export const updateGroupDataSchema = z.object({
  path: z.object({
    group_id: z.number(),
  }),
});

export const updateGroupResponseSchema = groupResponseSchema;

export const updateGroupErrorSchema = z.unknown();

export const deleteGroupDataSchema = z.object({
  path: z.object({
    group_id: z.number(),
  }),
});

export const deleteGroupResponseSchema = z.any();

export const deleteGroupErrorSchema = z.unknown();

export const listAssignableGroupsResponseSchema = groupsResponseSchema;

export const listAssignableGroupsErrorSchema = z.unknown();

export const countGroupsDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const countGroupsResponseSchema = groupsCountObjectSchema;

export const countGroupsErrorSchema = z.unknown();

export const ticketImportDataSchema = z.object({
  body: ticketImportRequestSchema.optional(),
  query: z
    .object({
      archive_immediately: z.boolean().optional(),
    })
    .optional(),
});

export const ticketImportResponseSchema = ticketResponseSchema;

export const ticketImportErrorSchema = z.unknown();

export const ticketBulkImportRequestSchema = z.object({
  tickets: z.array(ticketImportInputSchema).optional(),
});

export const ticketBulkImportErrorSchema = z.unknown();

export const incrementalSampleExportDataSchema = z.object({
  path: z.object({
    incremental_resource: z.string(),
  }),
  query: z.object({
    start_time: z.number(),
  }),
});

export const incrementalSampleExportResponseSchema = timeBasedExportIncrementalTicketsResponseSchema;

export const incrementalSampleExportErrorSchema = z.unknown();

export const incrementalOrganizationExportDataSchema = z.object({
  query: z.object({
    start_time: z.number(),
  }),
});

export const incrementalOrganizationExportResponseSchema = exportIncrementalOrganizationsResponseSchema;

export const incrementalOrganizationExportErrorSchema = z.unknown();

export const incrementalSkillBasedRoutingSchema = z.object({
  attribute_values: z.array(incrementalSkillBasedRoutingAttributeValueSchema).optional(),
  attributes: z.array(incrementalSkillBasedRoutingAttributeSchema).optional(),
  count: z.number().optional(),
  end_time: z.number().optional(),
  instance_values: z.array(incrementalSkillBasedRoutingInstanceValueSchema).optional(),
  next_page: z.string().optional(),
});

export const incrementalSkilBasedRoutingAttributeValuesExportErrorSchema = z.unknown();

export const incrementalSkilBasedRoutingAttributesExportResponseSchema = incrementalSkillBasedRoutingSchema;

export const incrementalSkilBasedRoutingAttributesExportErrorSchema = z.unknown();

export const incrementalSkilBasedRoutingInstanceValuesExportResponseSchema = incrementalSkillBasedRoutingSchema;

export const incrementalSkilBasedRoutingInstanceValuesExportErrorSchema = z.unknown();

export const incrementalTicketEventsDataSchema = z.object({
  query: z.object({
    start_time: z.number(),
  }),
});

export const exportIncrementalTicketEventsResponseSchema = z.object({
  count: z.number().optional(),
  end_of_stream: z.boolean().optional(),
  end_time: z.number().optional(),
  next_page: z.string().optional().nullable(),
  ticket_events: z.array(ticketMetricEventBaseObjectSchema).optional(),
});

export const incrementalTicketEventsErrorSchema = z.unknown();

export const listTicketMetricEventsDataSchema = z.object({
  query: z.object({
    start_time: z.number(),
  }),
});

export const listTicketMetricEventsResponseSchema = ticketMetricEventsResponseSchema;

export const listTicketMetricEventsErrorSchema = z.unknown();

export const incrementalTicketExportTimeDataSchema = z.object({
  query: z.object({
    start_time: z.number(),
  }),
});

export const incrementalTicketExportTimeResponseSchema = timeBasedExportIncrementalTicketsResponseSchema;

export const incrementalTicketExportTimeErrorSchema = z.unknown();

export const incrementalTicketExportCursorDataSchema = z.object({
  query: z.object({
    cursor: z.string().optional(),
    start_time: z.number(),
  }),
});

export const cursorBasedExportIncrementalTicketsResponseSchema = z.object({
  after_cursor: z.string().optional().nullable(),
  after_url: z.string().optional().nullable(),
  before_cursor: z.string().optional().nullable(),
  before_url: z.string().optional().nullable(),
  end_of_stream: z.boolean().optional(),
  tickets: z.array(ticketObjectSchema).optional(),
});

export const incrementalTicketExportCursorErrorSchema = z.unknown();

export const incrementalUserExportTimeDataSchema = z.object({
  query: z.object({
    per_page: z.number().optional(),
    start_time: z.number(),
  }),
});

export const timeBasedExportIncrementalUsersResponseSchema = z.object({
  count: z.number().optional(),
  end_of_stream: z.boolean().optional(),
  end_time: z.number().optional(),
  next_page: z.string().optional().nullable(),
  users: z.array(userObjectSchema).optional(),
});

export const incrementalUserExportTimeErrorSchema = z.unknown();

export const incrementalUserExportCursorDataSchema = z.object({
  query: z.object({
    cursor: z.string().optional(),
    per_page: z.number().optional(),
    start_time: z.number(),
  }),
});

export const cursorBasedExportIncrementalUsersResponseSchema = z.object({
  after_cursor: z.string().optional().nullable(),
  after_url: z.string().optional().nullable(),
  before_cursor: z.string().optional().nullable(),
  before_url: z.string().optional().nullable(),
  end_of_stream: z.boolean().optional(),
  users: z.array(userObjectSchema).optional(),
});

export const incrementalUserExportCursorErrorSchema = z.unknown();

export const listJobStatusesErrorSchema = z.unknown();

export const showJobStatusDataSchema = z.object({
  path: z.object({
    job_status_id: z.string(),
  }),
});

export const showJobStatusErrorSchema = z.unknown();

export const showManyJobStatusesDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const showManyJobStatusesErrorSchema = z.unknown();

export const listLocalesResponseSchema = localesResponseSchema;

export const listLocalesErrorSchema = z.unknown();

export const showLocaleByIdDataSchema = z.object({
  path: z.object({
    locale_id: z.string(),
  }),
});

export const showLocaleByIdResponseSchema = localeResponseSchema;

export const showLocaleByIdErrorSchema = z.unknown();

export const listLocalesForAgentResponseSchema = localesResponseSchema;

export const listLocalesForAgentErrorSchema = z.unknown();

export const showCurrentLocaleResponseSchema = localeResponseSchema;

export const showCurrentLocaleErrorSchema = z.unknown();

export const detectBestLocaleResponseSchema = localeResponseSchema;

export const detectBestLocaleErrorSchema = z.unknown();

export const listAvailablePublicLocalesResponseSchema = localesResponseSchema;

export const listAvailablePublicLocalesErrorSchema = z.unknown();

export const listMacrosDataSchema = z.object({
  query: z
    .object({
      access: z.string().optional(),
      active: z.boolean().optional(),
      category: z.number().optional(),
      group_id: z.number().optional(),
      include: z.string().optional(),
      only_viewable: z.boolean().optional(),
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const listMacrosResponseSchema = macrosResponseSchema;

export const listMacrosErrorSchema = z.unknown();

export const createMacroDataSchema = z.object({
  body: z
    .object({
      macro: macroInputSchema.optional(),
    })
    .optional(),
});

export const createMacroResponseSchema = z.object({
  macro: macroObjectSchema.optional(),
});

export const createMacroErrorSchema = z.unknown();

export const showMacroDataSchema = z.object({
  path: z.object({
    macro_id: z.number(),
  }),
});

export const showMacroResponseSchema = macroResponseSchema;

export const showMacroErrorSchema = z.unknown();

export const updateMacroDataSchema = z.object({
  body: z
    .object({
      macro: macroInputSchema.optional(),
    })
    .optional(),
  path: z.object({
    macro_id: z.number(),
  }),
});

export const updateMacroResponseSchema = z.object({
  macro: macroObjectSchema.optional(),
});

export const updateMacroErrorSchema = z.unknown();

export const deleteMacroDataSchema = z.object({
  path: z.object({
    macro_id: z.number(),
  }),
});

export const deleteMacroResponseSchema = z.any();

export const deleteMacroErrorSchema = z.unknown();

export const showChangesToTicketDataSchema = z.object({
  path: z.object({
    macro_id: z.number(),
  }),
});

export const showChangesToTicketResponseSchema = macroApplyTicketResponseSchema;

export const showChangesToTicketErrorSchema = z.unknown();

export const listMacroAttachmentsDataSchema = z.object({
  path: z.object({
    macro_id: z.number(),
  }),
});

export const listMacroAttachmentsResponseSchema = macroAttachmentsResponseSchema;

export const listMacroAttachmentsErrorSchema = z.unknown();

export const createAssociatedMacroAttachmentDataSchema = z.object({
  path: z.object({
    macro_id: z.number(),
  }),
});

export const createAssociatedMacroAttachmentResponseSchema = macroAttachmentResponseSchema;

export const createAssociatedMacroAttachmentErrorSchema = z.unknown();

export const listMacrosActionsResponseSchema = z.object({
  actions: z.array(z.record(z.unknown())).optional(),
});

export const listMacrosActionsErrorSchema = z.unknown();

export const listActiveMacrosDataSchema = z.object({
  query: z
    .object({
      access: z.string().optional(),
      category: z.number().optional(),
      group_id: z.number().optional(),
      include: z.string().optional(),
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const listActiveMacrosResponseSchema = macrosResponseSchema;

export const listActiveMacrosErrorSchema = z.unknown();

export const createMacroAttachmentResponseSchema = macroAttachmentResponseSchema;

export const createMacroAttachmentErrorSchema = z.unknown();

export const showMacroAttachmentDataSchema = z.object({
  path: z.object({
    attachment_id: z.number(),
  }),
});

export const showMacroAttachmentResponseSchema = macroAttachmentResponseSchema;

export const showMacroAttachmentErrorSchema = z.unknown();

export const listMacroCategoriesResponseSchema = macroCategoriesResponseSchema;

export const listMacroCategoriesErrorSchema = z.unknown();

export const listMacroActionDefinitionsResponseSchema = z.object({
  definitions: z
    .object({
      actions: z.array(z.record(z.unknown())).optional(),
    })
    .optional(),
});

export const listMacroActionDefinitionsErrorSchema = z.unknown();

export const deleteManyMacrosDataSchema = z.object({
  query: z.object({
    ids: z.array(z.number()),
  }),
});

export const deleteManyMacrosResponseSchema = z.any();

export const deleteManyMacrosErrorSchema = z.unknown();

export const showDerivedMacroDataSchema = z.object({
  query: z.object({
    macro_id: z.number(),
    ticket_id: z.number(),
  }),
});

export const showDerivedMacroResponseSchema = macroResponseSchema;

export const showDerivedMacroErrorSchema = z.unknown();

export const searchMacroDataSchema = z.object({
  query: z.object({
    access: z.string().optional(),
    active: z.boolean().optional(),
    category: z.number().optional(),
    group_id: z.number().optional(),
    include: z.string().optional(),
    only_viewable: z.boolean().optional(),
    query: z.string(),
    sort_by: z.string().optional(),
    sort_order: z.string().optional(),
  }),
});

export const searchMacroResponseSchema = macrosResponseSchema;

export const searchMacroErrorSchema = z.unknown();

export const updateManyMacrosDataSchema = z.object({
  body: macroUpdateManyInputSchema.optional(),
});

export const updateManyMacrosResponseSchema = macrosResponseSchema;

export const updateManyMacrosErrorSchema = z.unknown();

export const showEssentialsCardDataSchema = z.object({
  path: z.object({
    object_type: z.string(),
  }),
});

export const showEssentialsCardResponseSchema = essentialsCardResponseSchema;

export const showEssentialsCardErrorSchema = z.unknown();

export const updateEssentialsCardDataSchema = z.object({
  path: z.object({
    object_type: z.string(),
  }),
});

export const updateEssentialsCardResponseSchema = essentialsCardResponseSchema;

export const updateEssentialsCardErrorSchema = z.unknown();

export const deleteEssentialsCardDataSchema = z.object({
  path: z.object({
    object_type: z.string(),
  }),
});

export const deleteEssentialsCardResponseSchema = z.any();

export const deleteEssentialsCardErrorSchema = z.unknown();

export const showEssentialsCardsResponseSchema = essentialsCardsResponseSchema;

export const showEssentialsCardsErrorSchema = z.unknown();

export const listOrganizationFieldsResponseSchema = organizationFieldsResponseSchema;

export const listOrganizationFieldsErrorSchema = z.unknown();

export const createOrganizationFieldResponseSchema = organizationFieldResponseSchema;

export const createOrganizationFieldErrorSchema = z.unknown();

export const showOrganizationFieldDataSchema = z.object({
  path: z.object({
    organization_field_id: z.union([z.number(), z.string()]),
  }),
});

export const showOrganizationFieldResponseSchema = organizationFieldResponseSchema;

export const showOrganizationFieldErrorSchema = z.unknown();

export const updateOrganizationFieldDataSchema = z.object({
  path: z.object({
    organization_field_id: z.union([z.number(), z.string()]),
  }),
});

export const updateOrganizationFieldResponseSchema = organizationFieldResponseSchema;

export const updateOrganizationFieldErrorSchema = z.unknown();

export const deleteOrganizationFieldDataSchema = z.object({
  path: z.object({
    organization_field_id: z.union([z.number(), z.string()]),
  }),
});

export const deleteOrganizationFieldResponseSchema = z.any();

export const deleteOrganizationFieldErrorSchema = z.unknown();

export const reorderOrganizationFieldResponseSchema = z.string();

export const reorderOrganizationFieldErrorSchema = z.unknown();

export const listOrganizationMembershipsResponseSchema = organizationMembershipsResponseSchema;

export const listOrganizationMembershipsErrorSchema = z.unknown();

export const createOrganizationMembershipResponseSchema = organizationMembershipResponseSchema;

export const createOrganizationMembershipErrorSchema = z.unknown();

export const showOrganizationMembershipByIdDataSchema = z.object({
  path: z.object({
    organization_membership_id: z.number(),
  }),
});

export const showOrganizationMembershipByIdResponseSchema = organizationMembershipResponseSchema;

export const showOrganizationMembershipByIdErrorSchema = z.unknown();

export const deleteOrganizationMembershipDataSchema = z.object({
  path: z.object({
    organization_membership_id: z.number(),
  }),
});

export const deleteOrganizationMembershipResponseSchema = z.any();

export const deleteOrganizationMembershipErrorSchema = z.unknown();

export const createManyOrganizationMembershipsErrorSchema = z.unknown();

export const deleteManyOrganizationMembershipsDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
    })
    .optional(),
});

export const deleteManyOrganizationMembershipsErrorSchema = z.unknown();

export const showOrganizationMergeDataSchema = z.object({
  path: z.object({
    organization_merge_id: z.string(),
  }),
});

export const showOrganizationMergeResponseSchema = organizationMergeResponseSchema;

export const showOrganizationMergeErrorSchema = z.unknown();

export const listOrganizationSubscriptionsResponseSchema = organizationSubscriptionsResponseSchema;

export const listOrganizationSubscriptionsErrorSchema = z.unknown();

export const organizationSubscriptionCreateRequestSchema = z.object({
  organization_subscription: organizationSubscriptionInputSchema.optional(),
});

export const createOrganizationSubscriptionResponseSchema = organizationSubscriptionResponseSchema;

export const createOrganizationSubscriptionErrorSchema = z.unknown();

export const showOrganizationSubscriptionDataSchema = z.object({
  path: z.object({
    organization_subscription_id: z.number(),
  }),
});

export const showOrganizationSubscriptionResponseSchema = organizationSubscriptionResponseSchema;

export const showOrganizationSubscriptionErrorSchema = z.unknown();

export const deleteOrganizationSubscriptionDataSchema = z.object({
  path: z.object({
    organization_subscription_id: z.number(),
  }),
});

export const deleteOrganizationSubscriptionResponseSchema = z.any();

export const deleteOrganizationSubscriptionErrorSchema = z.unknown();

export const listOrganizationsResponseSchema = organizationsResponseSchema;

export const listOrganizationsErrorSchema = z.unknown();

export const createOrganizationRequestSchema = z.object({
  organization: organizationObjectSchema,
});

export const createOrganizationResponseSchema = organizationResponseSchema;

export const createOrganizationErrorSchema = z.unknown();

export const showOrganizationDataSchema = z.object({
  path: z.object({
    organization_id: z.number(),
  }),
});

export const showOrganizationResponseSchema = organizationResponseSchema;

export const showOrganizationErrorSchema = z.unknown();

export const updateOrganizationDataSchema = z.object({
  path: z.object({
    organization_id: z.number(),
  }),
});

export const updateOrganizationResponseSchema = organizationResponseSchema;

export const updateOrganizationErrorSchema = errorsSchema;

export const deleteOrganizationDataSchema = z.object({
  path: z.object({
    organization_id: z.number(),
  }),
});

export const deleteOrganizationResponseSchema = z.any();

export const deleteOrganizationErrorSchema = z.unknown();

export const createOrganizationMergeDataSchema = z.object({
  body: organizationMergeRequestSchema,
  path: z.object({
    organization_id: z.number(),
  }),
});

export const createOrganizationMergeResponseSchema = organizationMergeResponseSchema;

export const createOrganizationMergeErrorSchema = z.unknown();

export const listOrganizationMergesDataSchema = z.object({
  path: z.object({
    organization_id: z.number(),
  }),
});

export const listOrganizationMergesResponseSchema = organizationMergeListResponseSchema;

export const listOrganizationMergesErrorSchema = z.unknown();

export const organizationRelatedDataSchema = z.object({
  path: z.object({
    organization_id: z.number(),
  }),
});

export const organizationRelatedResponseSchema = organizationsRelatedResponseSchema;

export const organizationRelatedErrorSchema = z.unknown();

export const autocompleteOrganizationsDataSchema = z.object({
  query: z.object({
    field_id: z.string().optional(),
    name: z.string(),
    source: z.string().optional(),
  }),
});

export const autocompleteOrganizationsResponseSchema = organizationsResponseSchema;

export const autocompleteOrganizationsErrorSchema = errorsSchema;

export const countOrganizationsResponseSchema = countOrganizationResponseSchema;

export const countOrganizationsErrorSchema = z.unknown();

export const createManyOrganizationsErrorSchema = z.unknown();

export const createOrUpdateOrganizationResponseSchema = organizationResponseSchema;

export const createOrUpdateOrganizationErrorSchema = z.unknown();

export const deleteManyOrganizationsDataSchema = z.object({
  query: z
    .object({
      external_ids: z.string().optional(),
      ids: z.string().optional(),
    })
    .optional(),
});

export const deleteManyOrganizationsErrorSchema = z.unknown();

export const searchOrganizationsDataSchema = z.object({
  query: z
    .object({
      external_id: z.number().optional(),
      name: z.string().optional(),
    })
    .optional(),
});

export const searchOrganizationsResponseSchema = organizationsResponseSchema;

export const searchOrganizationsErrorSchema = z.unknown();

export const showManyOrganizationsDataSchema = z.object({
  query: z
    .object({
      external_ids: z.string().optional(),
      ids: z.string().optional(),
    })
    .optional(),
});

export const showManyOrganizationsResponseSchema = organizationsResponseSchema;

export const showManyOrganizationsErrorSchema = z.unknown();

export const updateManyOrganizationsDataSchema = z.object({
  query: z
    .object({
      external_ids: z.string().optional(),
      ids: z.string().optional(),
    })
    .optional(),
});

export const updateManyOrganizationsErrorSchema = z.unknown();

export const listTicketProblemsResponse2Schema = listTicketProblemsResponseSchema;

export const listTicketProblemsErrorSchema = z.unknown();

export const autocompleteProblemsDataSchema = z.object({
  body: z
    .object({
      text: z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      text: z.string().optional(),
    })
    .optional(),
});

export const autocompleteProblemsResponseSchema = listTicketProblemsResponseSchema;

export const autocompleteProblemsErrorSchema = z.unknown();

export const pushNotificationDevicesDataSchema = z.object({
  body: pushNotificationDevicesRequestSchema.optional(),
});

export const pushNotificationDevicesResponseSchema = z.string();

export const pushNotificationDevicesErrorSchema = z.unknown();

export const listQueuesResponseSchema = queuesResponseSchema;

export const listQueuesErrorSchema = z.unknown();

export const createQueueResponseSchema = queueResponseSchema;

export const createQueueErrorSchema = z.unknown();

export const showQueueByIdDataSchema = z.object({
  path: z.object({
    queue_id: z.string(),
  }),
});

export const showQueueByIdResponseSchema = queueResponseSchema;

export const showQueueByIdErrorSchema = z.unknown();

export const updateQueueDataSchema = z.object({
  path: z.object({
    queue_id: z.string(),
  }),
});

export const updateQueueResponseSchema = queueResponseSchema;

export const updateQueueErrorSchema = z.unknown();

export const deleteQueueDataSchema = z.object({
  path: z.object({
    queue_id: z.string(),
  }),
});

export const deleteQueueResponseSchema = z.any();

export const deleteQueueErrorSchema = z.unknown();

export const listQueueDefinitionsResponseSchema = definitionsResponseSchema;

export const listQueueDefinitionsErrorSchema = z.unknown();

export const listSupportAddressesResponseSchema = supportAddressesResponseSchema;

export const listSupportAddressesErrorSchema = z.unknown();

export const createSupportAddressResponseSchema = supportAddressResponseSchema;

export const createSupportAddressErrorSchema = z.unknown();

export const showSupportAddressDataSchema = z.object({
  path: z.object({
    support_address_id: z.number(),
  }),
});

export const showSupportAddressResponseSchema = supportAddressResponseSchema;

export const showSupportAddressErrorSchema = z.unknown();

export const updateSupportAddressDataSchema = z.object({
  path: z.object({
    support_address_id: z.number(),
  }),
});

export const updateSupportAddressResponseSchema = supportAddressResponseSchema;

export const updateSupportAddressErrorSchema = z.unknown();

export const deleteRecipientAddressDataSchema = z.object({
  path: z.object({
    support_address_id: z.number(),
  }),
});

export const deleteRecipientAddressResponseSchema = z.any();

export const deleteRecipientAddressErrorSchema = z.unknown();

export const verifySupportAddressForwardingDataSchema = z.object({
  path: z.object({
    support_address_id: z.number(),
  }),
});

export const verifySupportAddressForwardingResponseSchema = z.string();

export const verifySupportAddressForwardingErrorSchema = z.unknown();

export const getRelationshipFilterDefinitionsDataSchema = z.object({
  path: z.object({
    target_type: z.string(),
  }),
  query: z
    .object({
      source_type: z.string().optional(),
    })
    .optional(),
});

export const relationshipFilterDefinitionResponseSchema = z.object({
  definitions: relationshipFilterDefinitionSchema.optional(),
});

export const getRelationshipFilterDefinitionsErrorSchema = z.unknown();

export const listRequestsDataSchema = z.object({
  query: z
    .object({
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const listRequestsResponseSchema = requestsResponseSchema;

export const listRequestsErrorSchema = z.unknown();

export const requestResponseSchema = z.object({
  request: requestObjectSchema.optional(),
});

export const createRequestErrorSchema = z.unknown();

export const showRequestDataSchema = z.object({
  path: z.object({
    request_id: z.number(),
  }),
});

export const showRequestResponseSchema = requestResponseSchema;

export const showRequestErrorSchema = z.unknown();

export const updateRequestDataSchema = z.object({
  path: z.object({
    request_id: z.number(),
  }),
});

export const updateRequestResponseSchema = requestResponseSchema;

export const updateRequestErrorSchema = z.unknown();

export const listCommentsDataSchema = z.object({
  path: z.object({
    request_id: z.number(),
  }),
  query: z
    .object({
      role: z.string().optional(),
      since: z.string().optional(),
    })
    .optional(),
});

export const listCommentsResponseSchema = ticketCommentsResponseSchema;

export const listCommentsErrorSchema = z.unknown();

export const showCommentDataSchema = z.object({
  path: z.object({
    request_id: z.number(),
    ticket_comment_id: z.number(),
  }),
});

export const showCommentResponseSchema = ticketCommentResponseSchema;

export const showCommentErrorSchema = z.unknown();

export const searchRequestsDataSchema = z.object({
  query: z
    .object({
      query: z.string().optional(),
    })
    .optional(),
});

export const searchRequestsResponseSchema = requestsResponseSchema;

export const searchRequestsErrorSchema = z.unknown();

export const listResourceCollectionsResponseSchema = resourceCollectionsResponseSchema;

export const listResourceCollectionsErrorSchema = z.unknown();

export const createResourceCollectionErrorSchema = z.unknown();

export const retrieveResourceCollectionDataSchema = z.object({
  path: z.object({
    resource_collection_id: z.number(),
  }),
});

export const retrieveResourceCollectionResponseSchema = resourceCollectionResponseSchema;

export const retrieveResourceCollectionErrorSchema = z.unknown();

export const updateResourceCollectionDataSchema = z.object({
  path: z.object({
    resource_collection_id: z.number(),
  }),
});

export const updateResourceCollectionErrorSchema = z.unknown();

export const deleteResourceCollectionDataSchema = z.object({
  path: z.object({
    resource_collection_id: z.number(),
  }),
});

export const deleteResourceCollectionErrorSchema = z.unknown();

export const listAgentAttributeValuesDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const listAgentAttributeValuesResponseSchema = skillBasedRoutingAttributeValuesResponseSchema;

export const listAgentAttributeValuesErrorSchema = z.unknown();

export const setAgentAttributeValuesDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const setAgentAttributeValuesResponseSchema = skillBasedRoutingAttributeValuesResponseSchema;

export const setAgentAttributeValuesErrorSchema = z.unknown();

export const listAccountAttributesResponseSchema = skillBasedRoutingAttributesResponseSchema;

export const listAccountAttributesErrorSchema = z.unknown();

export const createAttributeResponseSchema = skillBasedRoutingAttributeResponseSchema;

export const createAttributeErrorSchema = z.unknown();

export const showAttributeDataSchema = z.object({
  path: z.object({
    attribute_id: z.string(),
  }),
});

export const showAttributeResponseSchema = skillBasedRoutingAttributeResponseSchema;

export const showAttributeErrorSchema = z.unknown();

export const updateAttributeDataSchema = z.object({
  path: z.object({
    attribute_id: z.string(),
  }),
});

export const updateAttributeResponseSchema = skillBasedRoutingAttributeResponseSchema;

export const updateAttributeErrorSchema = z.unknown();

export const deleteAttributeDataSchema = z.object({
  path: z.object({
    attribute_id: z.string(),
  }),
});

export const deleteAttributeResponseSchema = z.any();

export const deleteAttributeErrorSchema = z.unknown();

export const listAttributeValuesDataSchema = z.object({
  path: z.object({
    attribute_id: z.string(),
  }),
});

export const listAttributeValuesResponseSchema = skillBasedRoutingAttributeValuesResponseSchema;

export const listAttributeValuesErrorSchema = z.unknown();

export const createAttributeValueDataSchema = z.object({
  path: z.object({
    attribute_id: z.string(),
  }),
});

export const createAttributeValueResponseSchema = skillBasedRoutingAttributeValueResponseSchema;

export const createAttributeValueErrorSchema = z.unknown();

export const showAttributeValueDataSchema = z.object({
  path: z.object({
    attribute_id: z.string(),
    attribute_value_id: z.string(),
  }),
});

export const showAttributeValueResponseSchema = skillBasedRoutingAttributeValueResponseSchema;

export const showAttributeValueErrorSchema = z.unknown();

export const updateAttributeValueDataSchema = z.object({
  path: z.object({
    attribute_id: z.string(),
    attribute_value_id: z.string(),
  }),
});

export const updateAttributeValueResponseSchema = skillBasedRoutingAttributeValueResponseSchema;

export const updateAttributeValueErrorSchema = z.unknown();

export const deleteAttributeValueDataSchema = z.object({
  path: z.object({
    attribute_id: z.string(),
    attribute_value_id: z.string(),
  }),
});

export const deleteAttributeValueResponseSchema = z.any();

export const deleteAttributeValueErrorSchema = z.unknown();

export const listRoutingAttributeDefinitionsResponseSchema = skillBasedRoutingAttributeDefinitionsSchema;

export const listRoutingAttributeDefinitionsErrorSchema = z.unknown();

export const listTicketsFullfilledByUserDataSchema = z.object({
  query: z.object({
    ticket_ids: z.number(),
  }),
});

export const listTicketsFullfilledByUserResponseSchema = skillBasedRoutingTicketFulfilledResponseSchema;

export const listTicketsFullfilledByUserErrorSchema = z.unknown();

export const listTicketAttributeValuesDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const listTicketAttributeValuesResponseSchema = skillBasedRoutingAttributeValuesResponseSchema;

export const listTicketAttributeValuesErrorSchema = z.unknown();

export const setTicketAttributeValuesDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const setTicketAttributeValuesResponseSchema = skillBasedRoutingAttributeValuesResponseSchema;

export const setTicketAttributeValuesErrorSchema = z.unknown();

export const listSatisfactionRatingsResponseSchema = satisfactionRatingsResponseSchema;

export const listSatisfactionRatingsErrorSchema = z.unknown();

export const showSatisfactionRatingDataSchema = z.object({
  path: z.object({
    satisfaction_rating_id: z.number(),
  }),
});

export const showSatisfactionRatingResponseSchema = satisfactionRatingResponseSchema;

export const showSatisfactionRatingErrorSchema = z.unknown();

export const countSatisfactionRatingsResponseSchema = satisfactionRatingsCountResponseSchema;

export const countSatisfactionRatingsErrorSchema = z.unknown();

export const listSatisfactionRatingReasonsResponseSchema = satisfactionReasonsResponseSchema;

export const listSatisfactionRatingReasonsErrorSchema = z.unknown();

export const showSatisfactionRatingsDataSchema = z.object({
  path: z.object({
    satisfaction_reason_id: z.number(),
  }),
});

export const showSatisfactionRatingsResponseSchema = satisfactionReasonResponseSchema;

export const showSatisfactionRatingsErrorSchema = z.unknown();

export const listSearchResultsDataSchema = z.object({
  query: z.object({
    query: z.string(),
    sort_by: z.string().optional(),
    sort_order: z.string().optional(),
  }),
});

export const listSearchResultsResponseSchema = searchResponseSchema;

export const listSearchResultsErrorSchema = z.unknown();

export const countSearchResultsDataSchema = z.object({
  query: z.object({
    query: z.string(),
  }),
});

export const countSearchResultsResponseSchema = searchCountResponseSchema;

export const countSearchResultsErrorSchema = z.unknown();

export const exportSearchResultsDataSchema = z.object({
  query: z.object({
    'filter[type]': z.string().optional(),
    'page[size]': z.number().optional(),
    query: z.string(),
  }),
});

export const searchExportResponseSchema = z.object({
  facets: z.string().optional().nullable(),
  links: z
    .object({
      next: z.string().optional().nullable(),
      prev: z.string().optional().nullable(),
    })
    .optional(),
  meta: z
    .object({
      after_cursor: z.string().optional().nullable(),
      before_cursor: z.string().optional().nullable(),
      has_more: z.boolean().optional(),
    })
    .optional(),
  results: z.array(searchResultObjectSchema).optional(),
});

export const exportSearchResultsErrorSchema = z.unknown();

export const listSessionsDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const listSessionsResponseSchema = sessionsResponseSchema;

export const listSessionsErrorSchema = z.unknown();

export const listSharingAgreementsResponseSchema = sharingAgreementsResponseSchema;

export const listSharingAgreementsErrorSchema = z.unknown();

export const createSharingAgreementResponseSchema = sharingAgreementResponseSchema;

export const createSharingAgreementErrorSchema = z.unknown();

export const showSharingAgreementDataSchema = z.object({
  path: z.object({
    sharing_agreement_id: z.number(),
  }),
});

export const showSharingAgreementResponseSchema = sharingAgreementResponseSchema;

export const showSharingAgreementErrorSchema = z.unknown();

export const updateSharingAgreementDataSchema = z.object({
  path: z.object({
    sharing_agreement_id: z.number(),
  }),
});

export const updateSharingAgreementResponseSchema = sharingAgreementResponseSchema;

export const updateSharingAgreementErrorSchema = z.unknown();

export const deleteSharingAgreementDataSchema = z.object({
  path: z.object({
    sharing_agreement_id: z.number(),
  }),
});

export const deleteSharingAgreementResponseSchema = z.any();

export const deleteSharingAgreementErrorSchema = z.unknown();

export const ticketSkipCreationSchema = z.object({
  skip: ticketSkipObjectSchema.optional(),
});

export const recordNewSkipErrorSchema = z.unknown();

export const sLAPoliciesResponseSchema = z.object({
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
  sla_policies: z.array(sLAPolicyObjectSchema).optional(),
});

export const listSlaPoliciesErrorSchema = z.unknown();

export const createSlaPolicyResponseSchema = sLAPolicyResponseSchema;

export const createSlaPolicyErrorSchema = z.unknown();

export const showSlaPolicyDataSchema = z.object({
  path: z.object({
    sla_policy_id: z.number(),
  }),
});

export const showSlaPolicyResponseSchema = sLAPolicyResponseSchema;

export const showSlaPolicyErrorSchema = z.unknown();

export const updateSlaPolicyDataSchema = z.object({
  path: z.object({
    sla_policy_id: z.number(),
  }),
});

export const updateSlaPolicyResponseSchema = sLAPolicyResponseSchema;

export const updateSlaPolicyErrorSchema = z.unknown();

export const deleteSlaPolicyDataSchema = z.object({
  path: z.object({
    sla_policy_id: z.number(),
  }),
});

export const deleteSlaPolicyResponseSchema = z.any();

export const deleteSlaPolicyErrorSchema = z.unknown();

export const retrieveSlaPolicyFilterDefinitionItemsResponseSchema = sLAPolicyFilterDefinitionResponseSchema;

export const retrieveSlaPolicyFilterDefinitionItemsErrorSchema = z.unknown();

export const reorderSlaPoliciesDataSchema = z.object({
  query: z
    .object({
      sla_policy_ids: z.array(z.number()).optional(),
    })
    .optional(),
});

export const reorderSlaPoliciesResponseSchema = z.string();

export const reorderSlaPoliciesErrorSchema = z.unknown();

export const listSuspendedTicketsDataSchema = z.object({
  query: z
    .object({
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const listSuspendedTicketsResponseSchema = suspendedTicketsResponseSchema;

export const listSuspendedTicketsErrorSchema = z.unknown();

export const showSuspendedTicketsDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const showSuspendedTicketsResponseSchema = suspendedTicketsResponseSchema;

export const showSuspendedTicketsErrorSchema = z.unknown();

export const deleteSuspendedTicketDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const deleteSuspendedTicketResponseSchema = z.any();

export const deleteSuspendedTicketErrorSchema = z.unknown();

export const recoverSuspendedTicketDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const recoverSuspendedTicketResponse2Schema = recoverSuspendedTicketResponseSchema;

export const recoverSuspendedTicketUnprocessableContentResponseSchema = z.object({
  ticket: z.array(suspendedTicketObjectSchema).optional(),
});

export const suspendedTicketsAttachmentsDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const suspendedTicketsAttachmentsResponse2Schema = suspendedTicketsAttachmentsResponseSchema;

export const suspendedTicketsAttachmentsErrorSchema = z.unknown();

export const deleteSuspendedTicketsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const deleteSuspendedTicketsResponseSchema = z.any();

export const deleteSuspendedTicketsErrorSchema = z.unknown();

export const exportSuspendedTicketsResponseSchema = suspendedTicketsExportResponseSchema;

export const exportSuspendedTicketsErrorSchema = z.unknown();

export const recoverSuspendedTicketsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const recoverSuspendedTicketsResponse2Schema = recoverSuspendedTicketsResponseSchema;

export const recoverSuspendedTicketsErrorSchema = z.unknown();

export const listTagsResponseSchema = tagsResponseSchema;

export const listTagsErrorSchema = z.unknown();

export const countTagsResponseSchema = tagCountResponseSchema;

export const countTagsErrorSchema = z.unknown();

export const listTargetFailuresResponseSchema = targetFailuresResponseSchema;

export const listTargetFailuresErrorSchema = z.unknown();

export const showTargetFailureDataSchema = z.object({
  path: z.object({
    target_failure_id: z.number(),
  }),
});

export const showTargetFailureResponseSchema = targetFailureResponseSchema;

export const showTargetFailureErrorSchema = z.unknown();

export const listTargetsResponseSchema = targetsResponseSchema;

export const listTargetsErrorSchema = z.unknown();

export const targetResponseSchema = z.object({
  target: targetObjectSchema.optional(),
});

export const createTargetErrorSchema = z.unknown();

export const showTargetDataSchema = z.object({
  path: z.object({
    target_id: z.number(),
  }),
});

export const showTargetResponseSchema = targetResponseSchema;

export const showTargetErrorSchema = z.unknown();

export const updateTargetDataSchema = z.object({
  path: z.object({
    target_id: z.number(),
  }),
});

export const updateTargetResponseSchema = targetResponseSchema;

export const updateTargetErrorSchema = z.unknown();

export const deleteTargetDataSchema = z.object({
  path: z.object({
    target_id: z.number(),
  }),
});

export const deleteTargetResponseSchema = z.any();

export const deleteTargetErrorSchema = z.unknown();

export const listTicketAuditsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
    })
    .optional(),
});

export const listTicketAuditsResponseSchema = ticketAuditsResponseSchema;

export const listTicketAuditsErrorSchema = z.unknown();

export const listTicketFieldsDataSchema = z.object({
  query: z
    .object({
      creator: z.boolean().optional(),
      locale: z.string().optional(),
    })
    .optional(),
});

export const listTicketFieldsResponseSchema = ticketFieldsResponseSchema;

export const listTicketFieldsErrorSchema = z.unknown();

export const createTicketFieldResponseSchema = ticketFieldResponseSchema;

export const createTicketFieldErrorSchema = z.unknown();

export const showTicketfieldDataSchema = z.object({
  path: z.object({
    ticket_field_id: z.number(),
  }),
  query: z
    .object({
      creator: z.boolean().optional(),
    })
    .optional(),
});

export const showTicketfieldResponseSchema = ticketFieldResponseSchema;

export const showTicketfieldErrorSchema = z.unknown();

export const updateTicketFieldDataSchema = z.object({
  path: z.object({
    ticket_field_id: z.number(),
  }),
  query: z
    .object({
      creator: z.boolean().optional(),
    })
    .optional(),
});

export const updateTicketFieldResponseSchema = ticketFieldResponseSchema;

export const updateTicketFieldErrorSchema = z.unknown();

export const deleteTicketFieldDataSchema = z.object({
  path: z.object({
    ticket_field_id: z.number(),
  }),
  query: z
    .object({
      creator: z.boolean().optional(),
    })
    .optional(),
});

export const deleteTicketFieldResponseSchema = z.any();

export const deleteTicketFieldErrorSchema = z.unknown();

export const listTicketFieldOptionsDataSchema = z.object({
  path: z.object({
    ticket_field_id: z.number(),
  }),
});

export const listTicketFieldOptionsResponseSchema = customFieldOptionsResponseSchema;

export const listTicketFieldOptionsErrorSchema = z.unknown();

export const createOrUpdateTicketFieldOptionDataSchema = z.object({
  path: z.object({
    ticket_field_id: z.number(),
  }),
});

export const createOrUpdateTicketFieldOptionResponseSchema = customFieldOptionResponseSchema;

export const createOrUpdateTicketFieldOptionErrorSchema = z.unknown();

export const showTicketFieldOptionDataSchema = z.object({
  path: z.object({
    ticket_field_id: z.number(),
    ticket_field_option_id: z.number(),
  }),
});

export const showTicketFieldOptionResponseSchema = customFieldOptionResponseSchema;

export const showTicketFieldOptionErrorSchema = z.unknown();

export const deleteTicketFieldOptionDataSchema = z.object({
  path: z.object({
    ticket_field_id: z.number(),
    ticket_field_option_id: z.number(),
  }),
});

export const deleteTicketFieldOptionResponseSchema = z.any();

export const deleteTicketFieldOptionErrorSchema = z.unknown();

export const countTicketFieldsResponseSchema = ticketFieldCountResponseSchema;

export const countTicketFieldsErrorSchema = z.unknown();

export const reorderTicketFieldsResponseSchema = z.string();

export const reorderTicketFieldsErrorSchema = z.unknown();

export const listTicketFormsDataSchema = z.object({
  query: z
    .object({
      active: z.boolean().optional(),
      associated_to_brand: z.boolean().optional(),
      end_user_visible: z.boolean().optional(),
      fallback_to_default: z.boolean().optional(),
    })
    .optional(),
});

export const listTicketFormsResponseSchema = ticketFormsResponseSchema;

export const listTicketFormsErrorSchema = z.unknown();

export const createTicketFormResponseSchema = ticketFormResponseSchema;

export const createTicketFormErrorSchema = z.unknown();

export const showTicketFormDataSchema = z.object({
  path: z.object({
    ticket_form_id: z.number(),
  }),
});

export const showTicketFormResponseSchema = ticketFormResponseSchema;

export const showTicketFormErrorSchema = z.unknown();

export const updateTicketFormDataSchema = z.object({
  path: z.object({
    ticket_form_id: z.number(),
  }),
});

export const updateTicketFormResponseSchema = ticketFormResponseSchema;

export const updateTicketFormErrorSchema = z.unknown();

export const deleteTicketFormDataSchema = z.object({
  path: z.object({
    ticket_form_id: z.number(),
  }),
});

export const deleteTicketFormResponseSchema = z.any();

export const deleteTicketFormErrorSchema = z.unknown();

export const cloneTicketFormDataSchema = z.object({
  path: z.object({
    ticket_form_id: z.number(),
  }),
});

export const cloneTicketFormResponseSchema = ticketFormResponseSchema;

export const cloneTicketFormErrorSchema = z.unknown();

export const reorderTicketFormsResponseSchema = ticketFormsResponseSchema;

export const reorderTicketFormsErrorSchema = z.unknown();

export const showManyTicketFormsDataSchema = z.object({
  query: z.object({
    active: z.boolean().optional(),
    associated_to_brand: z.boolean().optional(),
    end_user_visible: z.boolean().optional(),
    fallback_to_default: z.boolean().optional(),
    ids: z.string(),
  }),
});

export const showManyTicketFormsResponseSchema = ticketFormsResponseSchema;

export const showManyTicketFormsErrorSchema = z.unknown();

export const listTicketMetricsResponseSchema = ticketMetricsResponseSchema;

export const listTicketMetricsErrorSchema = z.unknown();

export const showTicketMetricsDataSchema = z.object({
  path: z.object({
    ticket_metric_id: z.string(),
  }),
});

export const ticketMetricsByTicketMetricIdResponseSchema = z.object({
  ticket_metric: z.array(ticketMetricObjectSchema).optional(),
});

export const showTicketMetricsErrorSchema = z.unknown();

export const listTicketsDataSchema = z.object({
  query: z
    .object({
      external_id: z.string().optional(),
    })
    .optional(),
});

export const listTicketsResponseSchema = ticketsResponseSchema;

export const listTicketsErrorSchema = z.unknown();

export const ticketCreateRequestSchema = z.object({
  ticket: ticketCreateInputSchema.optional(),
});

export const createTicketResponseSchema = ticketResponseSchema;

export const createTicketErrorSchema = z.unknown();

export const showTicketDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const showTicketResponseSchema = ticketResponseSchema;

export const showTicketErrorSchema = z.unknown();

export const ticketUpdateRequestSchema = z.object({
  ticket: ticketUpdateInputSchema.optional(),
});

export const ticketUpdateResponseSchema = z.object({
  audit: auditObjectSchema.optional(),
  ticket: ticketObjectSchema.optional(),
});

export const updateTicketErrorSchema = z.unknown();

export const deleteTicketDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const deleteTicketResponseSchema = z.any();

export const deleteTicketErrorSchema = z.unknown();

export const listAuditsForTicketDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const listAuditsForTicketResponseSchema = ticketAuditsResponseNoneCursorSchema;

export const listAuditsForTicketErrorSchema = z.unknown();

export const showTicketAuditDataSchema = z.object({
  path: z.object({
    ticket_audit_id: z.number(),
    ticket_id: z.number(),
  }),
});

export const showTicketAuditResponseSchema = ticketAuditResponseSchema;

export const showTicketAuditErrorSchema = z.unknown();

export const makeTicketCommentPrivateFromAuditsDataSchema = z.object({
  path: z.object({
    ticket_audit_id: z.number(),
    ticket_id: z.number(),
  }),
});

export const makeTicketCommentPrivateFromAuditsResponseSchema = z.string();

export const makeTicketCommentPrivateFromAuditsErrorSchema = z.unknown();

export const countAuditsForTicketDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const countAuditsForTicketResponseSchema = ticketAuditsCountResponseSchema;

export const countAuditsForTicketErrorSchema = z.unknown();

export const listTicketCollaboratorsDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const listTicketCollaboratorsResponse2Schema = listTicketCollaboratorsResponseSchema;

export const listTicketCollaboratorsErrorSchema = z.unknown();

export const listTicketCommentsDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
  query: z
    .object({
      include: z.string().optional(),
      include_inline_images: z.boolean().optional(),
    })
    .optional(),
});

export const listTicketCommentsResponseSchema = ticketCommentsResponseSchema;

export const listTicketCommentsErrorSchema = z.unknown();

export const redactCommentAttachmentDataSchema = z.object({
  path: z.object({
    attachment_id: z.number(),
    comment_id: z.number(),
    ticket_id: z.number(),
  }),
});

export const redactCommentAttachmentResponseSchema = attachmentResponseSchema;

export const redactCommentAttachmentErrorSchema = z.unknown();

export const makeTicketCommentPrivateDataSchema = z.object({
  path: z.object({
    ticket_comment_id: z.number(),
    ticket_id: z.number(),
  }),
});

export const makeTicketCommentPrivateResponseSchema = z.string();

export const makeTicketCommentPrivateErrorSchema = z.unknown();

export const redactStringInCommentDataSchema = z.object({
  path: z.object({
    ticket_comment_id: z.number(),
    ticket_id: z.number(),
  }),
});

export const redactStringInCommentResponseSchema = ticketCommentResponseSchema;

export const redactStringInCommentErrorSchema = z.unknown();

export const countTicketCommentsDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const countTicketCommentsResponseSchema = ticketCommentsCountResponseSchema;

export const countTicketCommentsErrorSchema = z.unknown();

export const listTicketEmailCcsDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const listTicketEmailCcsResponseSchema = listTicketEmailCCsResponseSchema;

export const listTicketEmailCcsErrorSchema = z.unknown();

export const listTicketFollowersDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const listTicketFollowersResponse2Schema = listTicketFollowersResponseSchema;

export const listTicketFollowersErrorSchema = z.unknown();

export const listTicketIncidentsDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const listTicketIncidentsResponse2Schema = listTicketIncidentsResponseSchema;

export const listTicketIncidentsErrorSchema = z.unknown();

export const showTicketAfterChangesDataSchema = z.object({
  path: z.object({
    macro_id: z.number(),
    ticket_id: z.number(),
  }),
});

export const showTicketAfterChangesResponseSchema = macroApplyTicketResponseSchema;

export const showTicketAfterChangesErrorSchema = z.unknown();

export const markTicketAsSpamAndSuspendRequesterDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const markTicketAsSpamAndSuspendRequesterResponseSchema = z.string();

export const markTicketAsSpamAndSuspendRequesterErrorSchema = z.unknown();

export const mergeTicketsIntoTargetTicketDataSchema = z.object({
  body: ticketMergeInputSchema.optional(),
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const mergeTicketsIntoTargetTicketErrorSchema = z.unknown();

export const ticketRelatedInformationDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const ticketRelatedInformationResponseSchema = ticketRelatedInformationSchema;

export const ticketRelatedInformationErrorSchema = z.unknown();

export const createTicketSatisfactionRatingDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const createTicketSatisfactionRatingResponseSchema = satisfactionRatingResponseSchema;

export const createTicketSatisfactionRatingErrorSchema = z.unknown();

export const listResourceTagsDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const listResourceTagsResponseSchema = tagsByObjectIdResponseSchema;

export const listResourceTagsErrorSchema = z.unknown();

export const setTagsTicketDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const setTagsTicketResponseSchema = tagsByObjectIdResponseSchema;

export const setTagsTicketErrorSchema = z.unknown();

export const putTagsTicketDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const putTagsTicketResponseSchema = tagsByObjectIdResponseSchema;

export const putTagsTicketErrorSchema = z.unknown();

export const deleteTagsTicketDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const deleteTagsTicketResponseSchema = z.any();

export const deleteTagsTicketErrorSchema = z.unknown();

export const countTicketsResponseSchema = z.object({
  count: z
    .object({
      refreshed_at: z.string().optional(),
      value: z.number().optional(),
    })
    .optional(),
});

export const countTicketsErrorSchema = z.unknown();

export const ticketsCreateRequestSchema = z.object({
  tickets: z.array(ticketCreateInputSchema).optional(),
});

export const ticketsCreateManyErrorSchema = z.unknown();

export const bulkDeleteTicketsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const bulkDeleteTicketsErrorSchema = z.unknown();

export const markManyTicketsAsSpamDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const markManyTicketsAsSpamErrorSchema = z.unknown();

export const ticketsShowManyDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const ticketsShowManyResponseSchema = ticketsResponseSchema;

export const ticketsShowManyErrorSchema = z.unknown();

export const ticketsUpdateManyDataSchema = z.object({
  query: z
    .object({
      ids: z.string().optional(),
    })
    .optional(),
});

export const ticketsUpdateManyErrorSchema = z.unknown();

export const listTriggerCategoriesDataSchema = z.object({
  query: z
    .object({
      include: z.literal('rule_counts').optional(),
      page: z
        .object({
          after: z.string().optional(),
          before: z.string().optional(),
          size: z.number().optional(),
        })
        .optional(),
      sort: z
        .union([
          z.literal('position'),
          z.literal('-position'),
          z.literal('name'),
          z.literal('-name'),
          z.literal('created_at'),
          z.literal('-created_at'),
          z.literal('updated_at'),
          z.literal('-updated_at'),
        ])
        .optional(),
    })
    .optional(),
});

export const listTriggerCategoriesResponseSchema = triggerCategoriesResponseSchema.and(paginationSchema);

export const listTriggerCategoriesErrorSchema = errorsSchema;

export const createTriggerCategoryDataSchema = z.object({
  body: z.object({
    trigger_category: triggerCategoryRequestSchema.and(triggerCategoryRequestRequiredSchema).optional(),
  }),
});

export const createTriggerCategoryResponseSchema = triggerCategoryResponseSchema;

export const createTriggerCategoryErrorSchema = errorsSchema;

export const showTriggerCategoryByIdDataSchema = z.object({
  path: z.object({
    trigger_category_id: z.string(),
  }),
});

export const showTriggerCategoryByIdResponseSchema = triggerCategoryResponseSchema;

export const showTriggerCategoryByIdErrorSchema = errorsSchema;

export const updateTriggerCategoryDataSchema = z.object({
  body: z.object({
    trigger_category: triggerCategoryRequestSchema.optional(),
  }),
  path: z.object({
    trigger_category_id: z.string(),
  }),
});

export const updateTriggerCategoryResponseSchema = triggerCategoryResponseSchema;

export const updateTriggerCategoryErrorSchema = errorsSchema;

export const deleteTriggerCategoryDataSchema = z.object({
  path: z.object({
    trigger_category_id: z.string(),
  }),
});

export const deleteTriggerCategoryResponseSchema = z.any();

export const deleteTriggerCategoryErrorSchema = errorsSchema;

export const batchJobRequestSchema = z.object({
  job: z
    .object({
      action: z.literal('patch').optional(),
      items: z
        .object({
          trigger_categories: z.array(triggerCategoryBatchRequestSchema).optional(),
          triggers: z.array(triggerBatchRequestSchema).optional(),
        })
        .optional(),
    })
    .optional(),
});

export const batchJobResponseSchema = z.object({
  errors: z.array(batchErrorItemSchema).optional(),
  results: z
    .object({
      trigger_categories: z.array(triggerCategorySchema).optional(),
      triggers: z.array(triggerObjectSchema).optional(),
    })
    .optional(),
  status: z.union([z.literal('complete'), z.literal('failed')]).optional(),
});

export const batchOperateTriggerCategoriesErrorSchema = batchJobResponseSchema;

export const listTriggersDataSchema = z.object({
  query: z
    .object({
      active: z.boolean().optional(),
      category_id: z.string().optional(),
      sort: z.string().optional(),
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const listTriggersResponseSchema = triggersResponseSchema;

export const listTriggersErrorSchema = z.unknown();

export const createTriggerDataSchema = z.object({
  body: triggerWithCategoryRequestSchema,
});

export const createTriggerResponseSchema = triggerResponseSchema;

export const createTriggerErrorSchema = z.unknown();

export const getTriggerDataSchema = z.object({
  path: z.object({
    trigger_id: z.number(),
  }),
});

export const getTriggerResponseSchema = triggerResponseSchema;

export const getTriggerErrorSchema = z.unknown();

export const updateTriggerDataSchema = z.object({
  body: triggerWithCategoryRequestSchema,
  path: z.object({
    trigger_id: z.number(),
  }),
});

export const updateTriggerResponseSchema = triggerResponseSchema;

export const updateTriggerErrorSchema = z.unknown();

export const deleteTriggerDataSchema = z.object({
  path: z.object({
    trigger_id: z.number(),
  }),
});

export const deleteTriggerResponseSchema = z.any();

export const deleteTriggerErrorSchema = z.unknown();

export const listTriggerRevisionsDataSchema = z.object({
  path: z.object({
    trigger_id: z.number(),
  }),
});

export const triggerRevisionsResponseSchema = z.object({
  after_cursor: z.string().optional(),
  after_url: z.string().optional(),
  before_cursor: z.string().optional(),
  before_url: z.string().optional(),
  count: z.number().optional(),
  trigger_revisions: z
    .array(
      z.object({
        author_id: z.number().optional(),
        created_at: z.string().optional(),
        diff: z
          .object({
            actions: z.array(triggerActionDiffObjectSchema).optional(),
            active: z.array(triggerChangeObjectSchema).optional(),
            conditions: triggerConditionDiffObjectSchema.optional(),
            description: z.array(triggerChangeObjectSchema).optional(),
            source_id: z.number().optional(),
            target_id: z.number().optional(),
            title: z.array(triggerChangeObjectSchema).optional(),
          })
          .optional(),
        id: z.number().optional(),
        snapshot: triggerSnapshotObjectSchema.optional(),
        url: z.string().optional(),
      }),
    )
    .optional(),
});

export const listTriggerRevisionsErrorSchema = z.unknown();

export const triggerRevisionDataSchema = z.object({
  path: z.object({
    trigger_id: z.number(),
    trigger_revision_id: z.number(),
  }),
});

export const triggerRevisionResponse2Schema = triggerRevisionResponseSchema;

export const triggerRevisionErrorSchema = z.unknown();

export const listActiveTriggersDataSchema = z.object({
  query: z
    .object({
      category_id: z.string().optional(),
      sort: z.string().optional(),
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const listActiveTriggersResponseSchema = triggersResponseSchema;

export const listActiveTriggersErrorSchema = z.unknown();

export const listTriggerActionConditionDefinitionsResponseSchema = triggerDefinitionResponseSchema;

export const listTriggerActionConditionDefinitionsErrorSchema = z.unknown();

export const deleteManyTriggersDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const deleteManyTriggersResponseSchema = z.any();

export const deleteManyTriggersErrorSchema = z.unknown();

export const reorderTriggersResponseSchema = triggerResponseSchema;

export const reorderTriggersErrorSchema = z.unknown();

export const searchTriggersDataSchema = z.object({
  query: z.object({
    active: z.boolean().optional(),
    filter: z
      .object({
        json: triggerObjectSchema.optional(),
      })
      .optional(),
    include: z.string().optional(),
    query: z.string(),
    sort: z.string().optional(),
    sort_by: z.string().optional(),
    sort_order: z.string().optional(),
  }),
});

export const searchTriggersResponseSchema = triggersResponseSchema;

export const searchTriggersErrorSchema = z.unknown();

export const updateManyTriggersDataSchema = z.object({
  body: triggerBulkUpdateRequestSchema,
});

export const updateManyTriggersResponseSchema = triggersResponseSchema;

export const updateManyTriggersErrorSchema = z.unknown();

export const uploadFilesResponseSchema = attachmentUploadResponseSchema;

export const uploadFilesErrorSchema = z.unknown();

export const deleteUploadDataSchema = z.object({
  path: z.object({
    token: z.string(),
  }),
});

export const deleteUploadResponseSchema = z.any();

export const deleteUploadErrorSchema = z.unknown();

export const listUserFieldsResponseSchema = userFieldsResponseSchema;

export const listUserFieldsErrorSchema = z.unknown();

export const createUserFieldResponseSchema = userFieldResponseSchema;

export const createUserFieldErrorSchema = z.unknown();

export const showUserFieldDataSchema = z.object({
  path: z.object({
    user_field_id: z.union([z.number(), z.string()]),
  }),
});

export const showUserFieldResponseSchema = userFieldResponseSchema;

export const showUserFieldErrorSchema = z.unknown();

export const updateUserFieldDataSchema = z.object({
  path: z.object({
    user_field_id: z.union([z.number(), z.string()]),
  }),
});

export const updateUserFieldResponseSchema = userFieldResponseSchema;

export const updateUserFieldErrorSchema = z.unknown();

export const deleteUserFieldDataSchema = z.object({
  path: z.object({
    user_field_id: z.union([z.number(), z.string()]),
  }),
});

export const deleteUserFieldResponseSchema = z.any();

export const deleteUserFieldErrorSchema = z.unknown();

export const listUserFieldOptionsDataSchema = z.object({
  path: z.object({
    user_field_id: z.union([z.number(), z.string()]),
  }),
});

export const listUserFieldOptionsResponseSchema = customFieldOptionsResponseSchema;

export const listUserFieldOptionsErrorSchema = z.unknown();

export const createOrUpdateUserFieldOptionDataSchema = z.object({
  path: z.object({
    user_field_id: z.union([z.number(), z.string()]),
  }),
});

export const createOrUpdateUserFieldOptionResponseSchema = customFieldOptionResponseSchema;

export const createOrUpdateUserFieldOptionErrorSchema = z.unknown();

export const showUserFieldOptionDataSchema = z.object({
  path: z.object({
    user_field_id: z.union([z.number(), z.string()]),
    user_field_option_id: z.number(),
  }),
});

export const showUserFieldOptionResponseSchema = customFieldOptionResponseSchema;

export const showUserFieldOptionErrorSchema = z.unknown();

export const deleteUserFieldOptionDataSchema = z.object({
  path: z.object({
    user_field_id: z.union([z.number(), z.string()]),
    user_field_option_id: z.number(),
  }),
});

export const deleteUserFieldOptionResponseSchema = z.any();

export const deleteUserFieldOptionErrorSchema = z.unknown();

export const reorderUserFieldResponseSchema = z.string();

export const reorderUserFieldErrorSchema = z.unknown();

export const listUsersDataSchema = z.object({
  query: z
    .object({
      external_id: z.string().optional(),
      permission_set: z.number().optional(),
      role: z.union([z.literal('end-user'), z.literal('agent'), z.literal('admin')]).optional(),
      'role[]': z.string().optional(),
    })
    .optional(),
});

export const listUsersResponseSchema = usersResponseSchema;

export const listUsersErrorSchema = z.unknown();

export const userRequestSchema = z.object({
  user: userInputSchema,
});

export const createUserResponseSchema = userResponseSchema;

export const createUserErrorSchema = z.unknown();

export const showUserDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const showUserResponseSchema = userResponseSchema;

export const showUserErrorSchema = z.unknown();

export const updateUserDataSchema = z.object({
  body: userRequestSchema,
  path: z.object({
    user_id: z.number(),
  }),
});

export const updateUserResponseSchema = userResponseSchema;

export const updateUserErrorSchema = z.unknown();

export const deleteUserDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const deleteUserResponseSchema = userResponseSchema;

export const deleteUserErrorSchema = z.unknown();

export const showUserComplianceDeletionStatusesDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
  query: z
    .object({
      application: z.string().optional(),
    })
    .optional(),
});

export const showUserComplianceDeletionStatusesResponseSchema = complianceDeletionStatusesResponseSchema;

export const showUserComplianceDeletionStatusesErrorSchema = z.unknown();

export const groupMembershipSetDefaultDataSchema = z.object({
  path: z.object({
    group_membership_id: z.number(),
    user_id: z.number(),
  }),
});

export const groupMembershipSetDefaultResponseSchema = groupMembershipsResponseSchema;

export const groupMembershipSetDefaultErrorSchema = z.unknown();

export const listUserIdentitiesDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const userIdentitiesResponseSchema = z.object({
  identities: z.array(userIdentityObjectSchema).optional(),
});

export const listUserIdentitiesErrorSchema = z.unknown();

export const createUserIdentityDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const createUserIdentityResponseSchema = userIdentityResponseSchema;

export const createUserIdentityErrorSchema = z.unknown();

export const showUserIdentityDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
    user_identity_id: z.number(),
  }),
});

export const showUserIdentityResponseSchema = userIdentityResponseSchema;

export const showUserIdentityErrorSchema = z.unknown();

export const updateUserIdentityDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
    user_identity_id: z.number(),
  }),
});

export const updateUserIdentityResponseSchema = userIdentityResponseSchema;

export const updateUserIdentityErrorSchema = z.unknown();

export const deleteUserIdentityDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
    user_identity_id: z.number(),
  }),
});

export const deleteUserIdentityResponseSchema = z.any();

export const deleteUserIdentityErrorSchema = z.unknown();

export const makeUserIdentityPrimaryDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
    user_identity_id: z.number(),
  }),
});

export const makeUserIdentityPrimaryResponseSchema = userIdentitiesResponseSchema;

export const makeUserIdentityPrimaryErrorSchema = z.unknown();

export const requestUserVerficationDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
    user_identity_id: z.number(),
  }),
});

export const requestUserVerficationResponseSchema = z.string();

export const requestUserVerficationErrorSchema = z.unknown();

export const verifyUserIdentityDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
    user_identity_id: z.number(),
  }),
});

export const verifyUserIdentityResponseSchema = userIdentityResponseSchema;

export const verifyUserIdentityErrorSchema = z.unknown();

export const mergeEndUsersDataSchema = z.object({
  body: userRequestSchema,
  path: z.object({
    user_id: z.number(),
  }),
});

export const mergeEndUsersResponseSchema = userResponseSchema;

export const mergeEndUsersErrorSchema = z.unknown();

export const setOrganizationMembershipAsDefaultDataSchema = z.object({
  path: z.object({
    organization_membership_id: z.number(),
    user_id: z.number(),
  }),
});

export const setOrganizationMembershipAsDefaultResponseSchema = organizationMembershipsResponseSchema;

export const setOrganizationMembershipAsDefaultErrorSchema = z.unknown();

export const unassignOrganizationDataSchema = z.object({
  path: z.object({
    organization_id: z.number(),
    user_id: z.number(),
  }),
});

export const unassignOrganizationResponseSchema = z.any();

export const unassignOrganizationErrorSchema = z.unknown();

export const setOrganizationAsDefaultDataSchema = z.object({
  path: z.object({
    organization_id: z.number(),
    user_id: z.number(),
  }),
});

export const setOrganizationAsDefaultResponseSchema = organizationMembershipResponseSchema;

export const setOrganizationAsDefaultErrorSchema = z.unknown();

export const setUserPasswordDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const setUserPasswordResponseSchema = z.string();

export const setUserPasswordErrorSchema = z.unknown();

export const changeOwnPasswordDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const changeOwnPasswordResponseSchema = z.string();

export const changeOwnPasswordErrorSchema = z.unknown();

export const getUserPasswordRequirementsDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const getUserPasswordRequirementsResponseSchema = userPasswordRequirementsResponseSchema;

export const getUserPasswordRequirementsErrorSchema = z.unknown();

export const showUserRelatedDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const showUserRelatedResponseSchema = userRelatedResponseSchema;

export const showUserRelatedErrorSchema = z.unknown();

export const bulkDeleteSessionsByUserIdDataSchema = z.object({
  path: z.object({
    user_id: z.number(),
  }),
});

export const bulkDeleteSessionsByUserIdResponseSchema = z.any();

export const bulkDeleteSessionsByUserIdErrorSchema = z.unknown();

export const showSessionDataSchema = z.object({
  path: z.object({
    session_id: z.number(),
    user_id: z.number(),
  }),
});

export const showSessionResponseSchema = sessionResponseSchema;

export const showSessionErrorSchema = z.unknown();

export const deleteSessionDataSchema = z.object({
  path: z.object({
    session_id: z.number(),
    user_id: z.number(),
  }),
});

export const deleteSessionResponseSchema = z.any();

export const deleteSessionErrorSchema = z.unknown();

export const listTicketSkipsDataSchema = z.object({
  path: z.object({
    ticket_id: z.number(),
    user_id: z.number(),
  }),
  query: z
    .object({
      sort_order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
    })
    .optional(),
});

export const listTicketSkipsResponseSchema = ticketSkipsResponseSchema;

export const listTicketSkipsErrorSchema = z.unknown();

export const autocompleteUsersDataSchema = z.object({
  query: z.object({
    field_id: z.string().optional(),
    name: z.string(),
    source: z.string().optional(),
  }),
});

export const autocompleteUsersResponseSchema = usersResponseSchema;

export const autocompleteUsersErrorSchema = z.unknown();

export const countUsersDataSchema = z.object({
  query: z
    .object({
      permission_set: z.number().optional(),
      role: z.union([z.literal('end-user'), z.literal('agent'), z.literal('admin')]).optional(),
      'role[]': z.string().optional(),
    })
    .optional(),
});

export const countUsersResponseSchema = countResponseSchema;

export const countUsersErrorSchema = z.unknown();

export const createManyUsersDataSchema = z.object({
  body: usersRequestSchema,
});

export const createManyUsersErrorSchema = z.unknown();

export const createOrUpdateUserDataSchema = z.object({
  body: userRequestSchema,
});

export const createOrUpdateUserResponseSchema = userResponseSchema;

export const createOrUpdateUserErrorSchema = z.unknown();

export const createOrUpdateManyUsersDataSchema = z.object({
  body: usersRequestSchema,
});

export const createOrUpdateManyUsersErrorSchema = z.unknown();

export const destroyManyUsersDataSchema = z.object({
  query: z
    .object({
      external_ids: z.string().optional(),
      ids: z.string().optional(),
    })
    .optional(),
});

export const destroyManyUsersErrorSchema = z.unknown();

export const logoutManyUsersDataSchema = z.object({
  query: z
    .object({
      ids: z.string().optional(),
    })
    .optional(),
});

export const logoutManyUsersResponseSchema = z.string();

export const logoutManyUsersErrorSchema = z.unknown();

export const currentUserResponseSchema = z.object({
  user: userObjectSchema
    .and(
      z.object({
        authenticity_token: z.string().optional(),
      }),
    )
    .optional(),
});

export const showCurrentUserErrorSchema = z.unknown();

export const deleteAuthenticatedSessionResponseSchema = z.any();

export const deleteAuthenticatedSessionErrorSchema = z.unknown();

export const showCurrentlyAuthenticatedSessionResponseSchema = sessionResponseSchema;

export const showCurrentlyAuthenticatedSessionErrorSchema = z.unknown();

export const renewCurrentSessionResponseSchema = renewSessionResponseSchema;

export const renewCurrentSessionErrorSchema = z.unknown();

export const requestUserCreateDataSchema = z.object({
  body: userRequestSchema,
});

export const requestUserCreateResponseSchema = z.string();

export const requestUserCreateErrorSchema = z.unknown();

export const searchUsersDataSchema = z.object({
  query: z
    .object({
      external_id: z.string().optional(),
      query: z.string().optional(),
    })
    .optional(),
});

export const searchUsersResponseSchema = usersResponseSchema;

export const searchUsersErrorSchema = z.unknown();

export const showManyUsersDataSchema = z.object({
  query: z
    .object({
      external_ids: z.string().optional(),
      ids: z.string().optional(),
    })
    .optional(),
});

export const showManyUsersResponseSchema = usersResponseSchema;

export const showManyUsersErrorSchema = z.unknown();

export const updateManyUsersDataSchema = z.object({
  body: z.union([userRequestSchema, usersRequestSchema]),
  query: z
    .object({
      external_ids: z.string().optional(),
      ids: z.string().optional(),
    })
    .optional(),
});

export const updateManyUsersErrorSchema = z.unknown();

export const viewCategoriesResponseSchema = z.object({
  view_categories: z.array(viewCategorySchema).optional(),
});

export const listViewCategoriesErrorSchema = viewCategoryErrorsSchema;

export const createViewCategoryDataSchema = z.object({
  body: z.object({
    view_category: viewCategoryRequestSchema.and(viewCategoryRequestRequiredSchema).optional(),
  }),
});

export const createViewCategoryResponseSchema = viewCategoryResponseSchema;

export const createViewCategoryErrorSchema = viewCategoryErrorsSchema;

export const updateViewCategoryDataSchema = z.object({
  body: z.object({
    view_category: viewCategoryRequestSchema.optional(),
  }),
  path: z.object({
    view_category_id: z.string(),
  }),
});

export const updateViewCategoryResponseSchema = viewCategoryResponseSchema;

export const updateViewCategoryErrorSchema = viewCategoryErrorsSchema;

export const deleteViewCategoryDataSchema = z.object({
  path: z.object({
    view_category_id: z.string(),
  }),
});

export const deleteViewCategoryResponseSchema = z.any();

export const deleteViewCategoryErrorSchema = viewCategoryErrorsSchema;

export const listViewsDataSchema = z.object({
  query: z
    .object({
      access: z.string().optional(),
      active: z.boolean().optional(),
      group_id: z.number().optional(),
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const listViewsResponseSchema = viewsResponseSchema;

export const listViewsErrorSchema = z.unknown();

export const createViewResponseSchema = viewResponseSchema;

export const createViewErrorSchema = z.unknown();

export const showViewDataSchema = z.object({
  path: z.object({
    view_id: z.number(),
  }),
});

export const showViewResponseSchema = viewResponseSchema;

export const showViewErrorSchema = z.unknown();

export const updateViewDataSchema = z.object({
  path: z.object({
    view_id: z.number(),
  }),
});

export const updateViewResponseSchema = viewResponseSchema;

export const updateViewErrorSchema = z.unknown();

export const deleteViewDataSchema = z.object({
  path: z.object({
    view_id: z.number(),
  }),
});

export const deleteViewResponseSchema = z.any();

export const deleteViewErrorSchema = z.unknown();

export const getViewCountDataSchema = z.object({
  path: z.object({
    view_id: z.number(),
  }),
});

export const getViewCountResponseSchema = viewCountResponseSchema;

export const getViewCountErrorSchema = z.unknown();

export const executeViewDataSchema = z.object({
  path: z.object({
    view_id: z.number(),
  }),
  query: z
    .object({
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const executeViewResponseSchema = viewResponseSchema;

export const executeViewErrorSchema = z.unknown();

export const exportViewDataSchema = z.object({
  path: z.object({
    view_id: z.number(),
  }),
});

export const exportViewResponseSchema = viewExportResponseSchema;

export const exportViewErrorSchema = z.unknown();

export const listTicketsFromViewDataSchema = z.object({
  path: z.object({
    view_id: z.number(),
  }),
  query: z
    .object({
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const listTicketsFromViewResponseSchema = ticketsResponseSchema;

export const listTicketsFromViewErrorSchema = z.unknown();

export const listActiveViewsDataSchema = z.object({
  query: z
    .object({
      access: z.string().optional(),
      group_id: z.number().optional(),
      sort_by: z.string().optional(),
      sort_order: z.string().optional(),
    })
    .optional(),
});

export const listActiveViewsResponseSchema = viewsResponseSchema;

export const listActiveViewsErrorSchema = z.unknown();

export const listCompactViewsResponseSchema = viewsResponseSchema;

export const listCompactViewsErrorSchema = z.unknown();

export const countViewsResponseSchema = viewsCountResponseSchema;

export const countViewsErrorSchema = z.unknown();

export const getViewCountsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const getViewCountsResponseSchema = viewCountsResponseSchema;

export const getViewCountsErrorSchema = z.unknown();

export const bulkDeleteViewsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const bulkDeleteViewsResponseSchema = z.any();

export const bulkDeleteViewsErrorSchema = z.unknown();

export const previewViewsResponseSchema = viewResponseSchema;

export const previewViewsErrorSchema = z.unknown();

export const previewCountResponseSchema = viewCountResponseSchema;

export const previewCountErrorSchema = z.unknown();

export const searchViewsDataSchema = z.object({
  query: z.object({
    access: z.string().optional(),
    active: z.boolean().optional(),
    group_id: z.number().optional(),
    include: z.string().optional(),
    query: z.string(),
    sort_by: z.string().optional(),
    sort_order: z.string().optional(),
  }),
});

export const searchViewsResponseSchema = viewsResponseSchema;

export const searchViewsErrorSchema = z.unknown();

export const listViewsByIdDataSchema = z.object({
  query: z.object({
    active: z.boolean().optional(),
    ids: z.string(),
  }),
});

export const listViewsByIdResponseSchema = viewsResponseSchema;

export const listViewsByIdErrorSchema = z.unknown();

export const updateManyViewsResponseSchema = viewsResponseSchema;

export const updateManyViewsErrorSchema = z.unknown();

export const listWorkspacesResponseSchema = workspaceResponseSchema;

export const listWorkspacesErrorSchema = z.unknown();

export const createWorkspaceDataSchema = z.object({
  body: z
    .object({
      workspace: workspaceInputSchema.optional(),
    })
    .optional(),
});

export const createWorkspaceResponseSchema = z.object({
  workspace: workspaceObjectSchema.optional(),
});

export const createWorkspaceErrorSchema = z.unknown();

export const showWorkspaceDataSchema = z.object({
  path: z.object({
    workspace_id: z.number(),
  }),
});

export const showWorkspaceResponseSchema = z.object({
  workspace: workspaceObjectSchema.optional(),
});

export const showWorkspaceErrorSchema = z.unknown();

export const updateWorkspaceDataSchema = z.object({
  body: z
    .object({
      workspace: workspaceInputSchema.optional(),
    })
    .optional(),
  path: z.object({
    workspace_id: z.number(),
  }),
});

export const updateWorkspaceResponseSchema = z.object({
  workspace: workspaceObjectSchema.optional(),
});

export const updateWorkspaceErrorSchema = z.unknown();

export const deleteWorkspaceDataSchema = z.object({
  path: z.object({
    workspace_id: z.number(),
  }),
});

export const deleteWorkspaceResponseSchema = z.any();

export const deleteWorkspaceErrorSchema = z.unknown();

export const destroyManyWorkspacesDataSchema = z.object({
  query: z.object({
    ids: z.array(z.number()),
  }),
});

export const destroyManyWorkspacesResponseSchema = z.string();

export const destroyManyWorkspacesErrorSchema = z.unknown();

export const reorderWorkspacesDataSchema = z.object({
  body: z
    .object({
      ids: z.array(z.number()).optional(),
    })
    .optional(),
});

export const reorderWorkspacesResponseSchema = z.string();

export const reorderWorkspacesErrorSchema = z.unknown();

export const activityObjectSchema = z.object({
  actor: userObjectSchema.optional(),
  actor_id: z.number().optional(),
  created_at: z.string().optional(),
  id: z.number().optional(),
  object: z.record(z.unknown()).optional(),
  target: z.record(z.unknown()).optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  user: userObjectSchema.optional(),
  user_id: z.number().optional(),
  verb: z.string().optional(),
});

export const activityResponseSchema = z.object({
  activity: activityObjectSchema.optional(),
});

export const automationObjectSchema = z.object({
  actions: z.array(actionObjectSchema).optional(),
  active: z.boolean().optional(),
  conditions: conditionsObjectSchema.optional(),
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  id: z.number().optional(),
  position: z.number().optional(),
  raw_title: z.string().optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
});

export const automationResponseSchema = z.object({
  automation: automationObjectSchema.optional(),
});

export const automationsResponseSchema = z.object({
  automations: z.array(automationObjectSchema).optional(),
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
});

export const bookmarkObjectSchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  ticket: ticketObjectSchema.optional(),
  url: z.string().optional(),
});

export const bookmarkResponseSchema = z.object({
  bookmark: bookmarkObjectSchema.optional(),
});

export const bookmarksResponseSchema = offsetPaginationObjectSchema.and(
  z.object({
    bookmarks: z.array(bookmarkObjectSchema).optional(),
  }),
);

export const channelFrameworkResultObjectSchema = z.object({
  external_resource_id: z.string().optional(),
  status: channelFrameworkResultStatusObjectSchema.optional(),
});

export const jobStatusResultObjectSchema = z.union([createResourceResultSchema, updateResourceResultSchema]);

export const jobStatusObjectSchema = z.object({
  id: z.string().optional(),
  job_type: z.string().optional(),
  message: z.string().optional().nullable(),
  progress: z.number().optional().nullable(),
  results: z
    .union([
      z.array(jobStatusResultObjectSchema),
      z.object({
        success: z.boolean(),
      }),
    ])
    .optional()
    .nullable(),
  status: z.string().optional(),
  total: z.number().optional().nullable(),
  url: z.string().optional(),
});

export const jobStatusesResponseSchema = z.object({
  job_statuses: z.array(jobStatusObjectSchema),
});

export const objectTriggerObjectSchema = z.object({
  actions: z.array(triggerActionObjectSchema),
  active: z.boolean().optional(),
  conditions: triggerConditionsObjectSchema,
  created_at: z.string().optional(),
  default: z.boolean().optional(),
  description: z.string().optional(),
  id: z.number().optional(),
  position: z.number().optional(),
  raw_title: z.string().optional(),
  title: z.string(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const objectTriggerRequestSchema = z.object({
  trigger: objectTriggerObjectSchema.optional(),
});

export const objectTriggerResponseSchema = z.object({
  trigger: objectTriggerObjectSchema.optional(),
});

export const objectTriggersResponseSchema = z.object({
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
  triggers: z.array(objectTriggerObjectSchema).optional(),
});

export const listAssigneeFieldAssignableGroupsAndAgentsSearchResponseSchema =
  assigneeFieldAssignableGroupsAndAgentsSearchResponseSchema;

export const getSourcesByTargetResponseSchema = reverseLookupResponseSchema;

export const showAccountSettingsResponseSchema = accountSettingsResponseSchema;

export const activitiesResponseSchema = z.object({
  activities: z.array(activityObjectSchema).optional(),
  actors: z.array(z.record(z.unknown())).optional(),
  count: z.number().optional(),
  next_page: z.string().optional().nullable(),
  previous_page: z.string().optional().nullable(),
  users: z.array(z.record(z.unknown())).optional(),
});

export const showActivityResponseSchema = activityResponseSchema;

export const channelFrameworkPushResultsResponseSchema = z.object({
  results: z.array(channelFrameworkResultObjectSchema).optional(),
});

export const showAttachmentResponseSchema = attachmentResponseSchema;

export const listAutomationsResponseSchema = automationsResponseSchema;

export const createAutomationResponseSchema = automationResponseSchema;

export const showAutomationResponseSchema = automationResponseSchema;

export const updateAutomationResponseSchema = automationResponseSchema;

export const listActiveAutomationsResponseSchema = automationsResponseSchema;

export const searchAutomationsResponseSchema = automationsResponseSchema;

export const updateManyAutomationsResponseSchema = automationsResponseSchema;

export const listBookmarksResponseSchema = bookmarksResponseSchema;

export const createBookmarkDataSchema = z.object({
  body: bookmarkCreateRequestSchema.optional(),
});

export const createBookmarkResponseSchema = bookmarkResponseSchema;

export const createBrandDataSchema = z.object({
  body: brandCreateRequestSchema.optional(),
});

export const createTicketOrVoicemailTicketDataSchema = z.object({
  body: ticketCreateVoicemailTicketRequestSchema.optional(),
  path: z.object({
    agent_id: z.number(),
    ticket_id: z.number(),
  }),
});

export const createCustomObjectFieldResponseSchema = customObjectFieldResponseSchema;

export const listObjectTriggersResponseSchema = objectTriggersResponseSchema;

export const createObjectTriggerDataSchema = z.object({
  body: objectTriggerRequestSchema,
  path: z.object({
    custom_object_key: z.string(),
  }),
});

export const createObjectTriggerResponseSchema = objectTriggerResponseSchema;

export const getObjectTriggerResponseSchema = objectTriggerResponseSchema;

export const updateObjectTriggerDataSchema = z.object({
  body: objectTriggerRequestSchema,
  path: z.object({
    custom_object_key: z.string(),
    trigger_id: z.number(),
  }),
});

export const updateObjectTriggerResponseSchema = objectTriggerResponseSchema;

export const listActiveObjectTriggersResponseSchema = objectTriggersResponseSchema;

export const searchObjectTriggersResponseSchema = objectTriggersResponseSchema;

export const updateManyObjectTriggersResponseSchema = objectTriggersResponseSchema;

export const createCustomStatusDataSchema = z.object({
  body: customStatusCreateRequestSchema.optional(),
});

export const jobStatusResponseSchema = z.object({
  job_status: jobStatusObjectSchema.optional(),
});

export const bulkPermanentlyDeleteTicketsResponseSchema = jobStatusResponseSchema;

export const createDynamicContentResponseSchema = dynamicContentResponseSchema;

export const showEmailNotificationResponseSchema = emailNotificationResponseSchema;

export const groupMembershipBulkCreateResponseSchema = jobStatusResponseSchema;

export const groupMembershipBulkDeleteResponseSchema = jobStatusResponseSchema;

export const listGroupSlaPoliciesResponseSchema = groupSLAPoliciesResponseSchema;

export const ticketBulkImportDataSchema = z.object({
  body: ticketBulkImportRequestSchema.optional(),
  query: z
    .object({
      archive_immediately: z.boolean().optional(),
    })
    .optional(),
});

export const ticketBulkImportResponseSchema = jobStatusResponseSchema;

export const incrementalSkilBasedRoutingAttributeValuesExportResponseSchema = incrementalSkillBasedRoutingSchema;

export const incrementalTicketEventsResponseSchema = exportIncrementalTicketEventsResponseSchema;

export const incrementalTicketExportCursorResponseSchema = cursorBasedExportIncrementalTicketsResponseSchema;

export const incrementalUserExportTimeResponseSchema = timeBasedExportIncrementalUsersResponseSchema;

export const incrementalUserExportCursorResponseSchema = cursorBasedExportIncrementalUsersResponseSchema;

export const listJobStatusesResponseSchema = jobStatusesResponseSchema;

export const showJobStatusResponseSchema = jobStatusResponseSchema;

export const showManyJobStatusesResponseSchema = jobStatusesResponseSchema;

export const createManyOrganizationMembershipsResponseSchema = jobStatusResponseSchema;

export const deleteManyOrganizationMembershipsResponseSchema = jobStatusResponseSchema;

export const createOrganizationSubscriptionDataSchema = z.object({
  body: organizationSubscriptionCreateRequestSchema.optional(),
});

export const createOrganizationDataSchema = z.object({
  body: createOrganizationRequestSchema,
});

export const createManyOrganizationsResponseSchema = jobStatusResponseSchema;

export const deleteManyOrganizationsResponseSchema = jobStatusResponseSchema;

export const updateManyOrganizationsResponseSchema = jobStatusResponseSchema;

export const getRelationshipFilterDefinitionsResponseSchema = relationshipFilterDefinitionResponseSchema;

export const createRequestResponseSchema = requestResponseSchema;

export const createResourceCollectionResponseSchema = jobStatusResponseSchema;

export const updateResourceCollectionResponseSchema = jobStatusResponseSchema;

export const deleteResourceCollectionResponseSchema = jobStatusResponseSchema;

export const exportSearchResultsResponseSchema = searchExportResponseSchema;

export const recordNewSkipResponseSchema = ticketSkipCreationSchema;

export const listSlaPoliciesResponseSchema = sLAPoliciesResponseSchema;

export const recoverSuspendedTicketErrorSchema = recoverSuspendedTicketUnprocessableContentResponseSchema;

export const createTargetResponseSchema = targetResponseSchema;

export const showTicketMetricsResponseSchema = ticketMetricsByTicketMetricIdResponseSchema;

export const createTicketDataSchema = z.object({
  body: ticketCreateRequestSchema.optional(),
});

export const updateTicketDataSchema = z.object({
  body: ticketUpdateRequestSchema.optional(),
  path: z.object({
    ticket_id: z.number(),
  }),
});

export const updateTicketResponseSchema = ticketUpdateResponseSchema;

export const mergeTicketsIntoTargetTicketResponseSchema = jobStatusResponseSchema;

export const ticketsCreateManyDataSchema = z.object({
  body: ticketsCreateRequestSchema.optional(),
});

export const ticketsCreateManyResponseSchema = jobStatusResponseSchema;

export const bulkDeleteTicketsResponseSchema = jobStatusResponseSchema;

export const markManyTicketsAsSpamResponseSchema = jobStatusResponseSchema;

export const ticketsUpdateManyResponseSchema = jobStatusResponseSchema;

export const batchOperateTriggerCategoriesDataSchema = z.object({
  body: batchJobRequestSchema,
});

export const batchOperateTriggerCategoriesResponseSchema = batchJobResponseSchema;

export const listTriggerRevisionsResponseSchema = triggerRevisionsResponseSchema;

export const createUserDataSchema = z.object({
  body: userRequestSchema,
});

export const listUserIdentitiesResponseSchema = userIdentitiesResponseSchema;

export const createManyUsersResponseSchema = jobStatusResponseSchema;

export const createOrUpdateManyUsersResponseSchema = jobStatusResponseSchema;

export const destroyManyUsersResponseSchema = jobStatusResponseSchema;

export const showCurrentUserResponseSchema = currentUserResponseSchema;

export const updateManyUsersResponseSchema = jobStatusResponseSchema;

export const listViewCategoriesResponseSchema = viewCategoriesResponseSchema;

export const listActivitiesResponseSchema = activitiesResponseSchema;

export const pushContentToSupportResponseSchema = channelFrameworkPushResultsResponseSchema;

export const deleteTicketPermanentlyResponseSchema = jobStatusResponseSchema;
