// This file is auto-generated by @hey-api/openapi-ts

/**
 * The active features for an account. See [Active Features](#active-features)
 */
export type AccountSettingsActiveFeaturesObject = {
  advanced_analytics?: boolean;
  agent_forwarding?: boolean;
  allow_ccs?: boolean;
  allow_email_template_customization?: boolean;
  automatic_answers?: boolean;
  bcc_archiving?: boolean;
  benchmark_opt_out?: boolean;
  business_hours?: boolean;
  chat?: boolean;
  chat_about_my_ticket?: boolean;
  csat_reason_code?: boolean;
  custom_dkim_domain?: boolean;
  customer_context_as_default?: boolean;
  customer_satisfaction?: boolean;
  dynamic_contents?: boolean;
  explore?: boolean;
  explore_on_support_ent_plan?: boolean;
  explore_on_support_pro_plan?: boolean;
  facebook?: boolean;
  facebook_login?: boolean;
  fallback_composer?: boolean;
  forum_analytics?: boolean;
  good_data_and_explore?: boolean;
  google_login?: boolean;
  insights?: boolean;
  is_abusive?: boolean;
  light_agents?: boolean;
  markdown?: boolean;
  on_hold_status?: boolean;
  organization_access_enabled?: boolean;
  rich_content_in_emails?: boolean;
  sandbox?: boolean;
  satisfaction_prediction?: boolean;
  suspended_ticket_notification?: boolean;
  ticket_forms?: boolean;
  ticket_tagging?: boolean;
  topic_suggestion?: boolean;
  twitter?: boolean;
  twitter_login?: boolean;
  user_org_fields?: boolean;
  user_tagging?: boolean;
  voice?: boolean;
};

/**
 * Configuration for the agent workspace. See [Agents](#agents)
 */
export type AccountSettingsAgentObject = {
  agent_home?: boolean;
  agent_workspace?: boolean;
  aw_self_serve_migration_enabled?: boolean;
  focus_mode?: boolean;
  idle_timeout_enabled?: boolean;
  unified_agent_statuses?: boolean;
};

/**
 * API configuration options. See [API](#api)
 */
export type AccountSettingsApiObject = {
  accepted_api_agreement?: boolean;
  api_password_access?: string;
  api_token_access?: string;
};

/**
 * Apps configuration options. See [Apps](#apps)
 */
export type AccountSettingsAppsObject = {
  create_private?: boolean;
  create_public?: boolean;
  use?: boolean;
};

/**
 * Billing configuration options. See [Billing](#billing)
 */
export type AccountSettingsBillingObject = {
  backend?: string;
};

/**
 * Branding settings. See [Branding](#branding)
 */
export type AccountSettingsBrandingObject = {
  favicon_url?: string | null;
  header_color?: string;
  header_logo_url?: string | null;
  page_background_color?: string;
  tab_background_color?: string;
  text_color?: string;
};

/**
 * Brand settings. See [Brands](#brands)
 */
export type AccountSettingsBrandsObject = {
  default_brand_id?: number;
  require_brand_on_new_tickets?: boolean;
};

/**
 * CDN settings
 */
export type AccountSettingsCdnObject = {
  cdn_provider?: string;
  fallback_cdn_provider?: string;
  hosts?: Array<{
    name?: string;
    url?: string;
  }>;
};

/**
 * Zendesk Chat settings. See [Chat](#chat)
 */
export type AccountSettingsChatObject = {
  available?: boolean;
  enabled?: boolean;
  integrated?: boolean;
  maximum_request_count?: number;
  welcome_message?: string;
};

/**
 * Cross Sell settings
 */
export type AccountSettingsCrossSellObject = {
  show_chat_tooltip?: boolean;
  xsell_source?: string | null;
};

/**
 * GoodData settings, used for insights. Legacy configuration prior to Zendesk Explore. See [GoodData Advanced Analytics](#gooddata-advanced-analytics)
 */
export type AccountSettingsGooddataAdvancedAnalyticsObject = {
  enabled?: boolean;
};

/**
 * Google Apps configuration. See [G Suite](#g-suite)
 */
export type AccountSettingsGoogleAppsObject = {
  has_google_apps?: boolean;
  has_google_apps_admin?: boolean;
};

/**
 * Group configuration
 */
export type AccountSettingsGroupObject = {
  check_group_name_uniqueness?: boolean;
};

/**
 * Account limits configuration. See [Limits](#limits)
 */
export type AccountSettingsLimitsObject = {
  attachment_size?: number;
};

/**
 * Internationalization configuration settings. See [Localization](#localization)
 */
export type AccountSettingsLocalizationObject = {
  locale_ids?: Array<number>;
};

/**
 * Support UI settings. See [Lotus](#lotus)
 */
export type AccountSettingsLotusObject = {
  pod_id?: number;
  prefer_lotus?: boolean;
  reporting?: boolean;
};

/**
 * Account metrics settings. See [Metrics](#metrics)
 */
export type AccountSettingsMetricsObject = {
  account_size?: string;
};

export type AccountSettingsObject = {
  active_features?: AccountSettingsActiveFeaturesObject;
  agents?: AccountSettingsAgentObject;
  api?: AccountSettingsApiObject;
  apps?: AccountSettingsAppsObject;
  billing?: AccountSettingsBillingObject;
  branding?: AccountSettingsBrandingObject;
  brands?: AccountSettingsBrandsObject;
  cdn?: AccountSettingsCdnObject;
  chat?: AccountSettingsChatObject;
  cross_sell?: AccountSettingsCrossSellObject;
  gooddata_advanced_analytics?: AccountSettingsGooddataAdvancedAnalyticsObject;
  google_apps?: AccountSettingsGoogleAppsObject;
  groups?: AccountSettingsGroupObject;
  limits?: AccountSettingsLimitsObject;
  localization?: AccountSettingsLocalizationObject;
  lotus?: AccountSettingsLotusObject;
  metrics?: AccountSettingsMetricsObject;
  onboarding?: AccountSettingsOnboardingObject;
  routing?: AccountSettingsRoutingObject;
  rule?: AccountSettingsRuleObject;
  side_conversations?: AccountSettingsSideConversationsObject;
  statistics?: AccountSettingsStatisticsObject;
  ticket_form?: AccountSettingsTicketFormObject;
  tickets?: AccountSettingsTicketObject;
  twitter?: AccountSettingsTwitterObject;
  user?: AccountSettingsUserObject;
  voice?: AccountSettingsVoiceObject;
};

/**
 * Onboarding settings
 */
export type AccountSettingsOnboardingObject = {
  checklist_onboarding_version?: number;
  onboarding_segments?: string | null;
  product_sign_up?: string | null;
};

export type AccountSettingsResponse = {
  settings?: AccountSettingsObject;
};

/**
 * Configuration for routing. See [Routing](#routing)
 */
export type AccountSettingsRoutingObject = {
  autorouting_tag?: string;
  enabled?: boolean;
  max_email_capacity?: number;
  max_messaging_capacity?: number;
  reassignment_messaging_enabled?: boolean;
  reassignment_messaging_timeout?: number;
  reassignment_talk_timeout?: number;
};

/**
 * Rules settings for triggers, macros, views, and automations. See [Rules](#rules)
 */
export type AccountSettingsRuleObject = {
  macro_most_used?: boolean;
  macro_order?: string;
  skill_based_filtered_views?: Array<{
    [key: string]: unknown;
  }>;
  using_skill_based_routing?: boolean;
};

/**
 * Side conversations settings
 */
export type AccountSettingsSideConversationsObject = {
  email_channel?: boolean;
  msteams_channel?: boolean;
  show_in_context_panel?: boolean;
  slack_channel?: boolean;
  tickets_channel?: boolean;
};

/**
 * Account statistics settings. See [Statistics](#statistics)
 */
export type AccountSettingsStatisticsObject = {
  forum?: boolean;
  rule_usage?: boolean;
  search?: boolean;
};

/**
 * Ticket form settings. See [Ticket Form](#ticket-form)
 */
export type AccountSettingsTicketFormObject = {
  raw_ticket_forms_instructions?: string;
  ticket_forms_instructions?: string;
};

/**
 * Ticket settings. See [Tickets](#tickets)
 */
export type AccountSettingsTicketObject = {
  accepted_new_collaboration_tos?: boolean;
  agent_collision?: boolean;
  agent_invitation_enabled?: boolean;
  agent_ticket_deletion?: boolean;
  allow_group_reset?: boolean;
  assign_default_organization?: boolean;
  assign_tickets_upon_solve?: boolean;
  auto_translation_enabled?: boolean;
  auto_updated_ccs_followers_rules?: boolean;
  chat_sla_enablement?: boolean;
  collaboration?: boolean;
  comments_public_by_default?: boolean;
  default_solved_ticket_reassignment_strategy?: string;
  email_attachments?: boolean;
  emoji_autocompletion?: boolean;
  follower_and_email_cc_collaborations?: boolean;
  has_color_text?: boolean;
  is_first_comment_private_enabled?: boolean;
  light_agent_email_ccs_allowed?: boolean;
  list_empty_views?: boolean;
  list_newest_comments_first?: boolean;
  markdown_ticket_comments?: boolean;
  maximum_personal_views_to_list?: number;
  modern_ticket_reassignment?: boolean;
  private_attachments?: boolean;
  rich_text_comments?: boolean;
  show_modern_ticket_reassignment?: boolean;
  status_hold?: boolean;
  tagging?: boolean;
  using_skill_based_routing?: boolean;
};

/**
 * X (formerly Twitter) settings. See [X](#x-formerly-twitter)
 */
export type AccountSettingsTwitterObject = {
  shorten_url?: string;
};

/**
 * User settings. See [Users](#users)
 */
export type AccountSettingsUserObject = {
  agent_created_welcome_emails?: boolean;
  end_user_phone_number_validation?: boolean;
  have_gravatars_enabled?: boolean;
  language_selection?: boolean;
  multiple_organizations?: boolean;
  tagging?: boolean;
  time_zone_selection?: boolean;
};

/**
 * Zendesk Talk settings. See [Voice](#voice)
 */
export type AccountSettingsVoiceObject = {
  agent_confirmation_when_forwarding?: boolean;
  agent_wrap_up_after_calls?: boolean;
  enabled?: boolean;
  logging?: boolean;
  maximum_queue_size?: number;
  maximum_queue_wait_time?: number;
  only_during_business_hours?: boolean;
  outbound_enabled?: boolean;
  recordings_public?: boolean;
  uk_mobile_forwarding?: boolean;
};

export type ActionObject = {
  /**
   * The name of a ticket field to modify
   */
  field?: string;
  /**
   * The new value of the field
   */
  value?: string;
};

export type ActionsObject = {
  actions?: Array<ActionObject>;
};

export type ActivitiesCountResponse = {
  count?: {
    refreshed_at?: string;
    value?: number;
  };
};

export type ActivitiesResponse = {
  readonly activities?: Array<ActivityObject>;
  readonly actors?: Array<{
    [key: string]: unknown;
  }>;
  readonly count?: number;
  readonly next_page?: string | null;
  readonly previous_page?: string | null;
  readonly users?: Array<{
    [key: string]: unknown;
  }>;
};

export type ActivityObject = {
  /**
   * The full user record of the user responsible for the ticket activity. See [Users](/api-reference/ticketing/users/users/)
   */
  readonly actor?: UserObject;
  /**
   * The id of the user responsible for the ticket activity. An `actor_id` of "-1" is a Zendesk system user, such as an automations action.
   */
  readonly actor_id?: number;
  /**
   * When the record was created
   */
  readonly created_at?: string;
  /**
   * Automatically assigned on creation
   */
  readonly id?: number;
  /**
   * The content of the activity. Can be a ticket, comment, or change.
   */
  readonly object?: {
    [key: string]: unknown;
  };
  /**
   * The target of the activity, a ticket.
   */
  readonly target?: {
    [key: string]: unknown;
  };
  /**
   * Description of the activity
   */
  readonly title?: string;
  /**
   * When the record was last updated
   */
  readonly updated_at?: string;
  /**
   * The API url of the activity
   */
  readonly url?: string;
  /**
   * The full user record of the agent making the request. See [Users](/api-reference/ticketing/users/users/)
   */
  readonly user?: UserObject;
  /**
   * The id of the agent making the request
   */
  readonly user_id?: number;
  /**
   * The type of activity. Can be "tickets.assignment", "tickets.comment", or "tickets.priority_increase"
   */
  readonly verb?: string;
};

export type ActivityResponse = {
  activity?: ActivityObject;
};

export type AssigneeFieldAssignableAgentObject = {
  /**
   * URL of Agent's avatar
   */
  avatar_url?: string | null;
  /**
   * Agent Support ID
   */
  id?: number;
  /**
   * Name of the agent
   */
  name?: string;
};

export type AssigneeFieldAssignableGroupAgentsResponse = {
  agents?: Array<AssigneeFieldAssignableAgentObject>;
  /**
   * Number of agents listed in `agents` property.
   */
  count?: number;
  readonly next_page?: string | null;
  readonly previous_page?: string | null;
};

export type AssigneeFieldAssignableGroupObject = {
  /**
   * Description of the group
   */
  readonly description?: string;
  /**
   * Group ID
   */
  readonly id?: number;
  /**
   * Name of the group
   */
  readonly name?: string;
};

export type AssigneeFieldAssignableGroupsAndAgentsSearchResponse = {
  agents?: Array<AssigneeFieldAssignableSearchAgentObject>;
  /**
   * Number of agents + groups listed from search result.
   */
  count?: number;
  groups?: Array<AssigneeFieldAssignableSearchGroupObject>;
};

export type AssigneeFieldAssignableGroupsResponse = {
  /**
   * Number of groups listed in `groups` property.
   */
  count?: number;
  groups?: Array<AssigneeFieldAssignableGroupObject>;
  readonly next_page?: string | null;
  readonly previous_page?: string | null;
};

export type AssigneeFieldAssignableSearchAgentObject = {
  /**
   * Name of the agent's group
   */
  group?: string;
  /**
   * Agent's Group ID
   */
  group_id?: number;
  /**
   * Agent ID
   */
  id?: number;
  /**
   * Name of the agent
   */
  name?: string;
  /**
   * URL of Avatar
   */
  photo_url?: string | null;
};

export type AssigneeFieldAssignableSearchGroupObject = {
  /**
   * Group ID
   */
  id?: number;
  /**
   * Name of the group
   */
  name?: string;
};

export type AttachmentBaseObject = {
  /**
   * The content type of the image. Example value: "image/png"
   */
  readonly content_type?: string;
  /**
   * A full URL where the attachment image file can be downloaded. The file may be hosted externally so take care not to inadvertently send Zendesk authentication credentials. See [Working with url properties](/documentation/ticketing/managing-tickets/working-with-url-properties)
   */
  readonly content_url?: string;
  /**
   * If true, the attachment has been deleted
   */
  readonly deleted?: boolean;
  /**
   * The name of the image file
   */
  readonly file_name?: string;
  /**
   * The height of the image file in pixels. If height is unknown, returns null
   */
  readonly height?: string;
  /**
   * Automatically assigned when created
   */
  readonly id?: number;
  /**
   * If true, the attachment is excluded from the attachment list and the attachment's URL
   * can be referenced within the comment of a ticket. Default is false
   *
   */
  readonly inline?: boolean;
  /**
   * If true, you can download an attachment flagged as malware. If false, you can't download such an attachment.
   */
  readonly malware_access_override?: boolean;
  /**
   * The result of the malware scan. There is a delay between the time the attachment is uploaded and when the malware scan is completed. Usually the scan is done within a few seconds, but high load conditions can delay the scan results. Possible values: "malware_found", "malware_not_found", "failed_to_scan", "not_scanned"
   */
  readonly malware_scan_result?: string;
  /**
   * The URL the attachment image file has been mapped to
   */
  readonly mapped_content_url?: string;
  /**
   * The size of the image file in bytes
   */
  readonly size?: number;
  /**
   * A URL to access the attachment details
   */
  readonly url?: string;
  /**
   * The width of the image file in pixels. If width is unknown, returns null
   */
  readonly width?: string;
};

/**
 * A file represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object
 */
export type AttachmentObject = AttachmentBaseObject & AttachmentThumbnails;

export type AttachmentResponse = {
  attachment?: AttachmentObject;
};

export type AttachmentThumbnails = {
  /**
   * An array of attachment objects. Note that photo thumbnails do not have thumbnails
   */
  readonly thumbnails?: Array<AttachmentBaseObject>;
};

export type AttachmentUpdateInput = {
  /**
   * If true, allows access to attachments with detected malware.
   */
  malware_access_override?: boolean;
};

export type AttachmentUpdateRequest = {
  attachment?: AttachmentUpdateInput;
};

export type AttachmentUploadResponse = {
  upload?: {
    attachment?: AttachmentObject;
    attachments?: Array<AttachmentObject>;
    /**
     * Token for subsequent request
     */
    readonly token?: string;
  };
};

export type AuditLogObject = {
  /**
   * Type of change made. Possible values are "create", "destroy", "exported", "login", and "update"
   *
   */
  readonly action?: string;
  /**
   * Localized string of action field
   */
  readonly action_label?: string;
  /**
   * id of the user or system that initiated the change
   */
  readonly actor_id?: number;
  /**
   * Name of the user or system that initiated the change
   */
  readonly actor_name?: string;
  /**
   * The description of the change that occurred
   */
  readonly change_description?: string;
  /**
   * The time the audit got created
   */
  readonly created_at?: string;
  /**
   * The id automatically assigned upon creation
   */
  readonly id?: number;
  /**
   * The IP address of the user doing the audit
   */
  readonly ip_address?: string;
  /**
   * The id of the item being audited
   */
  readonly source_id?: number;
  /**
   * The name of the item being audited
   */
  readonly source_label?: string;
  /**
   * Item type being audited. Typically describes the system where the change
   * was initiated. Possible values vary based on your account's Zendesk
   * products and activity. Common values include "apitoken", "rule", "ticket",
   * "user", and "zendesk/app_market/app". The "rule" value is used for
   * [automations](https://support.zendesk.com/hc/en-us/articles/4408832701850),
   * [macros](https://support.zendesk.com/hc/en-us/articles/4408844187034),
   * [triggers](https://support.zendesk.com/hc/en-us/articles/4408822236058),
   * [views](https://support.zendesk.com/hc/en-us/articles/4408888828570),
   * and other automated business rules
   *
   */
  readonly source_type?: string;
  /**
   * The URL to access the audit log
   */
  readonly url?: string;
};

export type AuditLogResponse = {
  audit_log?: AuditLogObject;
};

export type AuditLogsResponse = {
  audit_logs?: Array<AuditLogObject>;
};

export type AuditObject = {
  readonly author_id?: number;
  readonly created_at?: string;
  readonly events?: Array<{
    readonly body?: string;
    readonly field_name?: string;
    readonly id?: number;
    readonly type?: string;
    value?: string | number;
  }>;
  readonly id?: number;
  readonly metadata?: {
    [key: string]: unknown;
  };
  readonly ticket_id?: number;
  via?: ViaObject;
};

export type AuthorObject = {
  /**
   * The author email
   */
  readonly email?: string;
  /**
   * The author id
   */
  readonly id?: number;
  /**
   * The author name
   */
  readonly name?: string;
};

export type AutomationObject = {
  /**
   * An object describing what the automation will do. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)
   */
  actions?: Array<ActionObject>;
  /**
   * Whether the automation is active
   */
  active?: boolean;
  conditions?: ConditionsObject;
  /**
   * The time the automation was created
   */
  readonly created_at?: string;
  /**
   * If true, the automation is a default automation
   */
  readonly default?: boolean;
  /**
   * Automatically assigned when created
   */
  readonly id?: number;
  /**
   * The position of the automation which specifies the order it will be executed
   */
  position?: number;
  /**
   * The raw title of the automation
   */
  readonly raw_title?: string;
  /**
   * The title of the automation
   */
  title?: string;
  /**
   * The time of the last update of the automation
   */
  readonly updated_at?: string;
};

export type AutomationResponse = {
  automation?: AutomationObject;
};

export type AutomationsResponse = {
  automations?: Array<AutomationObject>;
  readonly count?: number;
  readonly next_page?: string | null;
  readonly previous_page?: string | null;
};

export type BatchErrorItem = Error & {
  trigger_id?: string;
};

export type BatchJobRequest = {
  job?: {
    action?: 'patch';
    items?: {
      trigger_categories?: Array<TriggerCategoryBatchRequest>;
      triggers?: Array<TriggerBatchRequest>;
    };
  };
};

export type action = 'patch';

export type BatchJobResponse = {
  errors?: Array<BatchErrorItem>;
  results?: {
    trigger_categories?: Array<TriggerCategory>;
    triggers?: Array<TriggerObject>;
  };
  status?: 'complete' | 'failed';
};

export type status = 'complete' | 'failed';

export type BookmarkCreateRequest = {
  bookmark?: BookmarkInput;
};

export type BookmarkInput = {
  /**
   * The id of the ticket the bookmark is for.
   */
  ticket_id?: number;
};

export type BookmarkObject = {
  /**
   * The time the bookmark was created
   */
  readonly created_at?: string;
  /**
   * Automatically assigned when the bookmark is created
   */
  readonly id?: number;
  readonly ticket?: TicketObject;
  /**
   * The API url of this bookmark
   */
  readonly url?: string;
};

export type BookmarkResponse = {
  bookmark?: BookmarkObject;
};

export type BookmarksResponse = OffsetPaginationObject & {
  bookmarks?: Array<BookmarkObject>;
};

export type BrandCreateRequest = {
  brand?: BrandObject;
};

export type BrandObject = {
  /**
   * If the brand is set as active
   */
  active?: boolean;
  /**
   * The url of the brand
   */
  brand_url?: string;
  /**
   * The time the brand was created
   */
  readonly created_at?: string;
  /**
   * Is the brand the default brand for this account
   */
  default?: boolean;
  /**
   * If the brand has a Help Center
   */
  has_help_center?: boolean;
  /**
   * The state of the Help Center
   */
  readonly help_center_state?: 'enabled' | 'disabled' | 'restricted';
  /**
   * The hostmapping to this brand, if any. Only admins view this property.
   */
  host_mapping?: string;
  /**
   * The ID automatically assigned when the brand is created
   */
  readonly id?: number;
  /**
   * If the brand object is deleted or not
   */
  is_deleted?: boolean;
  logo?: AttachmentObject;
  /**
   * The name of the brand
   */
  name: string;
  /**
   * The signature template for a brand
   */
  signature_template?: string;
  /**
   * The subdomain of the brand
   */
  subdomain: string;
  /**
   * The ids of ticket forms that are available for use by a brand
   */
  readonly ticket_form_ids?: Array<number>;
  /**
   * The time of the last update of the brand
   */
  readonly updated_at?: string;
  /**
   * The API url of this brand
   */
  readonly url?: string;
};

/**
 * The state of the Help Center
 */
export type help_center_state = 'enabled' | 'disabled' | 'restricted';

export type BrandResponse = {
  brand?: BrandObject;
};

export type BrandUpdateRequest = {
  brand?: BrandObject;
};

export type BrandsResponse = OffsetPaginationObject & {
  /**
   * Array of brands
   */
  brands?: Array<BrandObject>;
};

export type BulkUpdateDefaultCustomStatusRequest = {
  /**
   * The comma-separated list of custom ticket status ids to be set as default for their status categories
   */
  ids?: string;
};

export type BulkUpdateDefaultCustomStatusResponse = {
  [key: string]: unknown;
};

export type ChannelFrameworkPushResultsResponse = {
  /**
   * An array of [result objects](#result-object)
   */
  results?: Array<ChannelFrameworkResultObject>;
};

export type ChannelFrameworkResultObject = {
  /**
   * The external ID of the resource, as passed in
   */
  readonly external_resource_id?: string;
  status?: ChannelFrameworkResultStatusObject;
};

/**
 * The status of the import for the indicated resource
 */
export type ChannelFrameworkResultStatusObject = {
  /**
   * A code indicating the status of the import of the resource, as described in [status codes](#status-codes)
   */
  readonly code?: string;
  /**
   * In the case of an exception, a description of the exception. Otherwise, not present.
   */
  readonly description?: string;
};

export type CollaboratorObject = {
  email?: string;
  name?: string;
};

export type ComplianceDeletionStatusObject = {
  account_subdomain: string;
  action: string;
  application: string;
  created_at: string;
  executer_id: number | null;
  user_id: number;
};

export type ComplianceDeletionStatusesResponse = {
  compliance_deletion_statuses?: Array<ComplianceDeletionStatusObject>;
};

export type ConditionObject = {
  /**
   * The name of a ticket field
   */
  field?: string;
  /**
   * A comparison operator
   */
  operator?: string;
  /**
   * The value of a ticket field
   */
  value?: string;
};

/**
 * An object that describes the conditions under which the automation will execute. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)
 */
export type ConditionsObject = {
  /**
   * Logical AND. Tickets must fulfill all of the conditions to be considered matching
   */
  all?: Array<ConditionObject>;
  /**
   * Logical OR. Tickets may satisfy any of the conditions to be considered matching
   */
  any?: Array<ConditionObject>;
};

export type CountOrganizationObject = {
  readonly refreshed_at?: string;
  readonly value?: number;
};

export type CountOrganizationResponse = {
  count?: CountOrganizationObject;
};

export type CountResponse = {
  count?: {
    refreshed_at?: string;
    value?: number;
  };
};

export type CreateOrganizationRequest = {
  organization: OrganizationObject;
};

export type CreateResourceResult = {
  /**
   * the id of the new resource
   */
  id: number;
  /**
   * the index number of the resul
   */
  index: number;
};

export type CurrentUserResponse = {
  user?: UserObject & {
    /**
     * CSRF token required by some Zendesk APIs.
     */
    readonly authenticity_token?: string;
  };
};

/**
 * See [Tickets](/api-reference/ticketing/tickets/tickets/) for a detailed example.
 *
 */
export type CursorBasedExportIncrementalTicketsResponse = {
  after_cursor?: string | null;
  after_url?: string | null;
  before_cursor?: string | null;
  before_url?: string | null;
  end_of_stream?: boolean;
  tickets?: Array<TicketObject>;
};

export type CursorBasedExportIncrementalUsersResponse = {
  after_cursor?: string | null;
  after_url?: string | null;
  before_cursor?: string | null;
  before_url?: string | null;
  end_of_stream?: boolean;
  users?: Array<UserObject>;
};

export type CustomFieldObject = {
  /**
   * If true, this field is available for use
   */
  active?: boolean;
  /**
   * The time of the last update of the ticket field
   */
  readonly created_at?: string;
  /**
   * Required and presented for a custom field of type "dropdown". Each option is represented by an object with a `name` and `value` property
   */
  custom_field_options?: Array<CustomFieldOptionObject>;
  /**
   * User-defined description of this field's purpose
   */
  description?: string;
  /**
   * Automatically assigned upon creation
   */
  readonly id?: number;
  /**
   * A unique key that identifies this custom field. This is used for updating the field and referencing in placeholders. The key must consist of only letters, numbers, and underscores. It can't be only numbers
   */
  key: string;
  /**
   * Ordering of the field relative to other fields
   */
  position?: number;
  /**
   * The dynamic content placeholder, if present, or the `description` value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  raw_description?: string;
  /**
   * The dynamic content placeholder, if present, or the `title` value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  raw_title?: string;
  /**
   * Regular expression field only. The validation pattern for a field value to be deemed valid
   */
  regexp_for_validation?: string | null;
  /**
   * A filter definition that allows your autocomplete to filter down results
   */
  relationship_filter?: {
    [key: string]: unknown;
  };
  /**
   * A representation of what type of object the field references. Options are "zen:user", "zen:organization", "zen:ticket", and "zen:custom_object:{key}" where key is a custom object key. For example "zen:custom_object:apartment".
   */
  relationship_target_type?: string;
  /**
   * If true, only active and position values of this field can be changed
   */
  readonly system?: boolean;
  /**
   * Optional for custom field of type "checkbox"; not presented otherwise.
   */
  tag?: string;
  /**
   * The title of the custom field
   */
  title: string;
  /**
   * The custom field type: "checkbox", "date", "decimal", "dropdown", "integer", ["lookup"](/api-reference/ticketing/lookup_relationships/lookup_relationships/), "multiselect", "regexp", "text", or "textarea"
   */
  type: string;
  /**
   * The time of the last update of the ticket field
   */
  readonly updated_at?: string;
  /**
   * The URL for this resource
   */
  readonly url?: string;
};

export type CustomFieldOptionObject = {
  /**
   * Automatically assigned upon creation
   */
  readonly id?: number;
  /**
   * Name of the dropdown option
   */
  name: string;
  /**
   * Position of the dropdown option
   */
  position?: number;
  /**
   * Raw name of the dropdown option
   */
  readonly raw_name?: string;
  /**
   * URL of the dropdown option
   */
  readonly url?: string;
  /**
   * Value of the dropdown option
   */
  value: string;
};

export type CustomFieldOptionResponse = {
  custom_field_option?: CustomFieldOptionObject;
};

export type CustomFieldOptionsResponse = {
  /**
   * Total count of records retrieved
   */
  readonly count?: number;
  custom_field_options?: Array<CustomFieldOptionObject>;
  /**
   * URL of the next page
   */
  readonly next_page?: string | null;
  /**
   * URL of the previous page
   */
  readonly previous_page?: string | null;
};

export type CustomObject = {
  /**
   * The time the object type was created
   */
  readonly created_at?: string;
  /**
   * Id of a user who created the object
   */
  readonly created_by_user_id?: string;
  /**
   * User-defined description of the object
   */
  description?: string;
  /**
   * A flag setting the visibility of the object in the agent's list view. If true, all agents and admins have viewing access to the object in the Custom objects record page in the Agent Workspace. If false, only admins have viewing access
   */
  include_in_list_view: boolean;
  /**
   * A user-defined unique identifier. Writable on create only
   */
  readonly key: string;
  /**
   * The dynamic content placeholder, if present, or the "raw_description" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  raw_description?: string;
  /**
   * The dynamic content placeholder, if present, or the "title" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  raw_title?: string;
  /**
   * The dynamic content placeholder, if present, or the "raw_title_pluralized" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  raw_title_pluralized?: string;
  /**
   * User-defined display name for the object
   */
  title: string;
  /**
   * User-defined pluralized version of the object's title
   */
  title_pluralized: string;
  /**
   * The time of the last update of the object
   */
  readonly updated_at?: string;
  /**
   * Id of the last user who updated the object
   */
  readonly updated_by_user_id?: string;
  /**
   * Direct link to the specific custom object
   */
  readonly url?: string;
};

export type CustomObjectCreateInput = {
  /**
   * Unique identifier. Writable on create only
   */
  key?: string;
  /**
   * Display name for the object
   */
  title?: string;
  /**
   * Pluralized version of the object's title
   */
  title_pluralized?: string;
};

export type CustomObjectField = CustomFieldObject;

export type CustomObjectFieldResponse = {
  custom_object_field?: CustomObjectField;
};

export type CustomObjectFieldsCreateRequest = {
  custom_object_field?: CustomObjectField;
};

export type CustomObjectFieldsResponse = {
  custom_object_fields?: Array<CustomObjectField>;
};

export type CustomObjectLimitsResponse = {
  /**
   * The current numnber of the requested resource
   */
  readonly count?: number;
  /**
   * The maximum allowed number for the requested resource
   */
  readonly limit?: number;
};

export type CustomObjectRecord = {
  /**
   * The time the object was created
   */
  readonly created_at?: string;
  /**
   * Id of a user who created the object
   */
  readonly created_by_user_id?: string;
  custom_object_fields?: {
    [key: string]: unknown;
  };
  /**
   * A user-defined unique identifier
   */
  readonly custom_object_key?: string;
  /**
   * An id you can use to link custom object records to external data
   */
  external_id?: string | null;
  /**
   * Automatically assigned upon creation
   */
  readonly id?: string;
  /**
   * User-defined display name for the object
   */
  readonly name: string;
  /**
   * The time of the last update of the object
   */
  readonly updated_at?: string;
  /**
   * Id of the last user who updated the object
   */
  readonly updated_by_user_id?: string;
  /**
   * Direct link to the specific custom object
   */
  readonly url?: string;
};

export type CustomObjectRecordFilteredSearchCondition = {
  field_key?: {
    operator?: string;
    value?: string | number | Array<string | number>;
  } | null;
  [key: string]: unknown;
};

export type CustomObjectRecordResponse = {
  custom_object_record?: CustomObjectRecord;
};

export type CustomObjectRecordsBulkCreateRequest = {
  job?: {
    action?: string;
    /**
     * An array of record objects for job actions that create, update, or set. An array of strings for job actions that delete.
     */
    items?: Array<CustomObjectRecord>;
  };
};

export type CustomObjectRecordsCreateRequest = {
  custom_object_record?: CustomObjectRecord;
};

export type CustomObjectRecordsFilteredSearchRequestBasic = {
  filter?: CustomObjectRecordFilteredSearchCondition;
};

export type CustomObjectRecordsFilteredSearchRequestComplex = {
  filter?: {
    $and?: Array<CustomObjectRecordFilteredSearchCondition>;
    $or?: Array<CustomObjectRecordFilteredSearchCondition>;
  };
};

export type CustomObjectRecordsJobsResponse = {
  job_status?: {
    id?: string;
    message?: string | null;
    progress?: number | null;
    results?: Array<CustomObjectRecord> | null;
    status?: string;
    total?: number;
    url?: string;
  };
};

export type CustomObjectRecordsResponse = {
  /**
   * The number of results returned for the current request
   */
  readonly count?: number;
  custom_object_records?: Array<CustomObjectRecord>;
  links?: {
    next: string | null;
    prev: string | null;
  };
  meta?: {
    after_cursor: string | null;
    before_cursor: string | null;
    has_more: boolean;
  };
};

export type CustomObjectRecordsUpsertRequest = {
  custom_object_record?: CustomObjectRecord;
};

export type CustomObjectResponse = {
  custom_object?: CustomObject;
};

export type CustomObjectsCreateRequest = {
  custom_object?: CustomObjectCreateInput;
};

export type CustomObjectsResponse = {
  custom_objects?: Array<CustomObject>;
};

/**
 * Configuration settings for the role. See [Configuration](#configuration)
 */
export type CustomRoleConfigurationObject = {
  /**
   * Whether or not the agent can assign tickets to any group
   */
  readonly assign_tickets_to_any_group?: boolean;
  /**
   * Whether or not the agent has access to Chat
   */
  readonly chat_access?: boolean;
  /**
   * Whether or not the agent can view lists of user profiles. Allowed values: "full", "none"
   */
  end_user_list_access?: string;
  /**
   * What the agent can do with end-user profiles. Allowed values: "edit", "edit-within-org", "full", "readonly"
   */
  end_user_profile_access?: string;
  /**
   * Allowed values: "edit", "full", "none", "readonly"
   */
  explore_access?: string;
  /**
   * The kind of access the agent has to Guide. Allowed values: "edit-topics", "full", "readonly"
   */
  forum_access?: string;
  forum_access_restricted_content?: boolean;
  /**
   * Whether or not the agent can add or modify groups
   */
  readonly group_access?: boolean;
  readonly light_agent?: boolean;
  /**
   * What the agent can do with macros. Allowed values: "full", "manage-group", "manage-personal", "readonly"
   */
  macro_access?: string;
  /**
   * Whether or not the agent can manage business rules
   */
  manage_business_rules?: boolean;
  /**
   * Whether or not the agent can view, add, and edit contextual workspaces
   */
  manage_contextual_workspaces?: boolean;
  /**
   * Whether or not the agent can access dynamic content
   */
  manage_dynamic_content?: boolean;
  /**
   * Whether or not the agent can manage channels and extensions
   */
  manage_extensions_and_channels?: boolean;
  /**
   * Whether or not the agent can manage Facebook pages
   */
  manage_facebook?: boolean;
  /**
   * Whether or not the agent can create and manage organization fields
   */
  manage_organization_fields?: boolean;
  /**
   * Whether or not the agent can create and manage ticket fields
   */
  manage_ticket_fields?: boolean;
  /**
   * Whether or not the agent can create and manage ticket forms
   */
  manage_ticket_forms?: boolean;
  /**
   * Whether or not the agent can create and manage user fields
   */
  manage_user_fields?: boolean;
  readonly moderate_forums?: boolean;
  /**
   * Whether or not the agent can add or modify organizations
   */
  organization_editing?: boolean;
  /**
   * Whether or not the agent can add or modify organization notes
   */
  readonly organization_notes_editing?: boolean;
  /**
   * What the agent can do with reports. Allowed values: "full", "none", "readonly"
   */
  report_access?: string;
  /**
   * Whether or not the agent can contribute to side conversations
   */
  side_conversation_create?: boolean;
  /**
   * What kind of tickets the agent can access. Allowed values: "all", "assigned-only", "within-groups", "within-groups-and-public-groups", "within-organization"
   */
  ticket_access?: string;
  /**
   * What type of comments the agent can make. Allowed values: "public", "none"
   */
  ticket_comment_access?: string;
  /**
   * Whether or not the agent can delete tickets
   */
  ticket_deletion?: boolean;
  /**
   * Whether or not the agent can edit ticket properties
   */
  ticket_editing?: boolean;
  /**
   * Whether or not the agent can merge tickets
   */
  ticket_merge?: boolean;
  /**
   * Whether or not the agent can edit ticket tags
   */
  ticket_tag_editing?: boolean;
  twitter_search_access?: boolean;
  /**
   * What the agent can do with customer lists. Allowed values: "full", "manage-group", "manage-personal", "none", "readonly"
   */
  user_view_access?: string;
  /**
   * What the agent can do with views. Allowed values: "full", "manage-group", "manage-personal", "playonly", "readonly"
   */
  view_access?: string;
  /**
   * Whether or not the agent can view deleted tickets
   */
  view_deleted_tickets?: boolean;
  /**
   * Whether or not the agent can answer and place calls to end users
   */
  voice_access?: boolean;
  /**
   * Whether or not the agent can view details about calls on the Talk dashboard
   */
  voice_dashboard_access?: boolean;
};

export type CustomRoleObject = {
  configuration?: CustomRoleConfigurationObject;
  /**
   * The time the record was created
   */
  readonly created_at?: string;
  /**
   * A description of the role
   */
  description?: string;
  /**
   * Automatically assigned on creation
   */
  readonly id?: number;
  /**
   * Name of the custom role
   */
  name: string;
  /**
   * The user's role. 0 stands for a custom agent, 1 for a light agent, 2 for a chat agent, 3 for a contributor, 4 for an admin and 5 for a billing admin. See [Understanding standard agent roles in Zendesk Support](https://support.zendesk.com/hc/en-us/articles/4409155971354-Understanding-standard-agent-roles-in-Zendesk-Support) in Zendesk help
   */
  readonly role_type: number;
  /**
   * The number of team members assigned to this role
   */
  readonly team_member_count?: number;
  /**
   * The time the record was last updated
   */
  readonly updated_at?: string;
};

export type CustomRoleResponse = {
  custom_role?: CustomRoleObject;
};

export type CustomRolesResponse = {
  custom_roles?: Array<CustomRoleObject>;
};

export type CustomStatusCreateInput = CustomStatusUpdateInput & {
  /**
   * The status category the custom ticket status belongs to
   */
  status_category?: 'new' | 'open' | 'pending' | 'hold' | 'solved';
};

/**
 * The status category the custom ticket status belongs to
 */
export type status_category = 'new' | 'open' | 'pending' | 'hold' | 'solved';

export type CustomStatusCreateRequest = {
  custom_status?: CustomStatusCreateInput;
};

export type CustomStatusObject = {
  /**
   * If true, the custom status is set to active, If false, the custom status is set to inactive
   */
  active?: boolean;
  /**
   * The label displayed to agents. Maximum length is 48 characters
   */
  agent_label: string;
  /**
   * The date and time the custom ticket status was created
   */
  readonly created_at?: string;
  /**
   * If true, the custom status is set to default. If false, the custom status is set to non-default
   */
  default?: boolean;
  /**
   * The description of when the user should select this custom ticket status
   */
  description?: string;
  /**
   * The description displayed to end users
   */
  end_user_description?: string;
  /**
   * The label displayed to end users. Maximum length is 48 characters
   */
  end_user_label?: string;
  /**
   * Automatically assigned when the custom ticket status is created
   */
  readonly id?: number;
  /**
   * The dynamic content placeholder. If the dynamic content placeholder is not available, this is the "agent_label" value. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  readonly raw_agent_label?: string;
  /**
   * The dynamic content placeholder. If the dynamic content placeholder is not available, this is the "description" value. [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  readonly raw_description?: string;
  /**
   * The dynamic content placeholder. If the dynamic content placeholder is not available, this is the "end_user_description" value. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  readonly raw_end_user_description?: string;
  /**
   * The dynamic content placeholder. If the dynamic content placeholder is not available, this is the "end_user_label" value. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  readonly raw_end_user_label?: string;
  /**
   * The status category the custom ticket status belongs to
   */
  status_category: 'new' | 'open' | 'pending' | 'hold' | 'solved';
  /**
   * The date and time the custom ticket status was last updated
   */
  readonly updated_at?: string;
};

export type CustomStatusResponse = {
  custom_status?: CustomStatusObject;
};

export type CustomStatusUpdateInput = {
  /**
   * True if the custom status is set as active; inactive if false
   */
  active?: boolean;
  /**
   * The dynamic content placeholder, if present, or the "agent_label" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  agent_label?: string;
  /**
   * The dynamic content placeholder, if present, or the "description" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  description?: string;
  /**
   * The dynamic content placeholder, if present, or the "end_user_description" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  end_user_description?: string;
  /**
   * The dynamic content placeholder, if present, or the "end_user_label" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  end_user_label?: string;
};

export type CustomStatusUpdateRequest = {
  custom_status?: CustomStatusUpdateInput;
};

export type CustomStatusesResponse = {
  custom_statuses?: Array<CustomStatusObject>;
};

export type DefinitionsResponse = {
  definitions?: {
    conditions_all?: Array<{
      group?: string;
      nullable?: boolean;
      operators?: Array<{
        terminal?: boolean;
        title?: string;
        value?: string;
      }>;
      repeatable?: boolean;
      subject?: string;
      title?: string;
      type?: string;
      values?: Array<{
        enabled?: boolean;
        title?: string;
        value?: string;
      }>;
    }>;
    conditions_any?: Array<{
      group?: string;
      nullable?: boolean;
      operators?: Array<{
        terminal?: boolean;
        title?: string;
        value?: string;
      }>;
      repeatable?: boolean;
      subject?: string;
      title?: string;
      type?: string;
      values?: Array<{
        enabled?: boolean;
        title?: string;
        value?: string;
      }>;
    }>;
  };
};

export type DeletedUserObject = {
  active: boolean;
  created_at: string;
  email: string;
  id: number;
  locale: string;
  locale_id: number;
  name: string;
  organization_id: number;
  phone: string | null;
  photo: {
    [key: string]: unknown;
  } | null;
  role: string;
  shared_phone_number: string | null;
  time_zone: string;
  updated_at: string;
  url: string;
};

export type DeletedUserResponse = {
  deleted_user?: DeletedUserObject;
};

export type DeletedUsersResponse = {
  deleted_users?: Array<DeletedUserObject>;
};

export type DeletionSchedule = {
  /**
   * Whether the deletion schedule is active
   */
  active?: boolean;
  conditions?: ConditionsObject;
  /**
   * The time the deletion schedule was created
   */
  readonly created_at?: string;
  /**
   * Whether the deletion schedule is the default
   */
  readonly default?: boolean;
  /**
   * The description of the deletion schedule
   */
  description?: string;
  /**
   * The id of the deletion schedule
   */
  readonly id?: number;
  /**
   * The title of the deletion schedule
   */
  title?: string;
  /**
   * The time the deletion schedule was last updated
   */
  readonly updated_at?: string;
  /**
   * Url for obtaining the deletion schedule JSON
   */
  readonly url?: string;
};

export type DynamicContentObject = {
  /**
   * When this record was created
   */
  readonly created_at?: string;
  /**
   * The default locale for the item. Must be one of the [locales the account has active](/api-reference/ticketing/account-configuration/locales/#list-locales).
   */
  default_locale_id: number;
  /**
   * Automatically assigned when creating items
   */
  readonly id?: number;
  /**
   * The unique name of the item
   */
  name: string;
  /**
   * Indicates the item has outdated variants within it
   */
  readonly outdated?: boolean;
  /**
   * Automatically generated placeholder for the item, derived from name
   */
  readonly placeholder?: string;
  /**
   * When this record was last updated
   */
  readonly updated_at?: string;
  /**
   * The API url of this item
   */
  readonly url?: string;
  /**
   * All variants within this item. See [Dynamic Content Item Variants](/api-reference/ticketing/ticket-management/dynamic_content_item_variants/)
   */
  variants: Array<DynamicContentVariantObject>;
};

export type DynamicContentResponse = {
  item?: DynamicContentObject;
};

export type DynamicContentVariantObject = {
  /**
   * If the variant is active and useable
   */
  active?: boolean;
  /**
   * The content of the variant
   */
  content: string;
  /**
   * When the variant was created
   */
  readonly created_at?: string;
  /**
   * If the variant is the default for the item it belongs to
   */
  default?: boolean;
  /**
   * Automatically assigned when the variant is created
   */
  readonly id?: number;
  /**
   * An active locale
   */
  locale_id: number;
  /**
   * If the variant is outdated
   */
  readonly outdated?: boolean;
  /**
   * When the variant was last updated
   */
  readonly updated_at?: string;
  /**
   * The API url of the variant
   */
  readonly url?: string;
};

export type DynamicContentVariantResponse = {
  variant?: DynamicContentVariantObject;
};

export type DynamicContentVariantsResponse = {
  variants?: Array<DynamicContentVariantObject>;
};

export type DynamicContentsResponse = {
  items?: Array<DynamicContentObject>;
};

export type EmailCCObject = FollowerObject & {
  action?: 'put' | 'delete';
  user_email?: string;
  user_id?: string;
  user_name?: string;
};

export type action2 = 'put' | 'delete';

export type EmailNotificationObject = {
  /**
   * The comment ID associated to this email notification
   */
  readonly comment_id?: number;
  /**
   * When this email notification was created
   */
  readonly created_at?: string;
  /**
   * The email ID of this email notification
   */
  readonly email_id?: string;
  /**
   * The value of the Message-Id header of the email
   */
  readonly message_id?: string;
  /**
   * The notification id of this email notification
   */
  readonly notification_id?: number;
  /**
   * The list of recipients associated to this email notification
   */
  readonly recipients?: Array<RecipientObject>;
  /**
   * The ticket ID associated to this email notification
   */
  readonly ticket_id?: number;
  /**
   * When this email notification was last updated
   */
  readonly updated_at?: string;
  /**
   * The API url of this email notification
   */
  readonly url?: string;
};

export type EmailNotificationResponse = {
  email_notification?: EmailNotificationObject;
};

export type EmailNotificationsResponse = {
  email_notifications?: Array<EmailNotificationObject>;
};

export type Error = {
  code: string;
  detail?: string;
  id?: string;
  links?: {
    [key: string]: unknown;
  };
  source?: {
    [key: string]: unknown;
  };
  status?: string;
  title: string;
};

export type Errors = {
  errors?: Array<Error>;
};

export type EssentialsCardObject = {
  /**
   * Date and time the essentials card were created
   */
  readonly created_at?: string;
  /**
   * If true, the system has used the first twenty fields for the custom object type as the essentials card.
   */
  readonly default?: boolean;
  /**
   * Fields that are displayed in the essentials card details. The order is defined by the order of the fields in the array
   */
  fields: Array<{
    [key: string]: unknown;
  }>;
  /**
   * id of the essentials card
   *
   */
  readonly id?: string | null;
  /**
   * Object type. Example: `zen:user` refers to `User` type
   *
   */
  readonly key?: string;
  /**
   * layout type
   *
   */
  readonly layout?: string;
  /**
   * Maximum number of fields allowed in the essentials card
   */
  readonly max_count?: number;
  /**
   * Date and time the essentials card were last updated
   */
  readonly updated_at?: string;
};

export type EssentialsCardResponse = {
  object_layout?: EssentialsCardObject;
};

export type EssentialsCardsResponse = {
  object_layouts?: Array<EssentialsCardObject>;
};

export type ExportIncrementalOrganizationsResponse = {
  count?: number;
  end_of_stream?: boolean;
  end_time?: number;
  next_page?: string | null;
  organizations?: Array<OrganizationObject>;
};

export type ExportIncrementalTicketEventsResponse = {
  count?: number;
  end_of_stream?: boolean;
  end_time?: number;
  next_page?: string | null;
  ticket_events?: Array<TicketMetricEventBaseObject>;
};

export type FollowerObject = {
  action?: 'put' | 'delete';
  user_email?: string;
  user_id?: string;
};

export type GroupMembershipObject = {
  /**
   * The time the group was created
   */
  readonly created_at?: string;
  /**
   * If true, tickets assigned directly to the agent will assume this membership's group
   */
  default?: boolean;
  /**
   * The id of a group
   */
  group_id: number;
  /**
   * Automatically assigned upon creation
   */
  readonly id?: number;
  /**
   * The time of the last update of the group
   */
  readonly updated_at?: string;
  /**
   * The API url of this record
   */
  readonly url?: string;
  /**
   * The id of an agent
   */
  user_id: number;
};

export type GroupMembershipResponse = {
  group_membership?: GroupMembershipObject;
};

export type GroupMembershipsResponse = {
  group_memberships?: Array<GroupMembershipObject>;
};

export type GroupObject = {
  /**
   * The time the group was created
   */
  readonly created_at?: string;
  /**
   * If the group is the default one for the account
   */
  readonly default?: boolean;
  /**
   * Deleted groups get marked as such
   */
  readonly deleted?: boolean;
  /**
   * The description of the group
   */
  description?: string;
  /**
   * Automatically assigned when creating groups
   */
  readonly id?: number;
  /**
   * If true, the group is public.
   * If false, the group is private.
   * You can't change a private group to a public group
   *
   */
  is_public?: boolean;
  /**
   * The name of the group
   */
  name: string;
  /**
   * The time of the last update of the group
   */
  readonly updated_at?: string;
  /**
   * The API url of the group
   */
  readonly url?: string;
};

export type GroupResponse = {
  group?: GroupObject;
};

export type GroupSLAPoliciesResponse = {
  readonly count?: number;
  group_sla_policies?: Array<GroupSLAPolicyObject>;
  readonly next_page?: string | null;
  readonly previous_page?: string | null;
};

export type GroupSLAPolicyFilterConditionObject = {
  /**
   * The name of a ticket field
   */
  field?: string;
  /**
   * A comparison operator
   */
  operator?: string;
  /**
   * The value of a ticket field
   */
  value?: Array<string | number>;
};

export type GroupSLAPolicyFilterDefinitionResponse = {
  definitions?: {
    all?: Array<{
      group?: string;
      operators?: Array<{
        title?: string;
        value?: string;
      }>;
      title?: string;
      value?: string;
      values?: {
        list?: Array<{
          title?: string;
          value?: number | null;
        }>;
        type?: string;
      };
    }>;
  };
};

/**
 * An object that describes the conditions a ticket must match for a Group SLA policy to be applied to the ticket. See [Filter](#filter).
 */
export type GroupSLAPolicyFilterObject = {
  all?: Array<GroupSLAPolicyFilterConditionObject>;
};

export type GroupSLAPolicyMetricObject = {
  /**
   * Whether the metric targets are being measured in business hours or calendar hours
   */
  business_hours?: boolean;
  /**
   * The definition of the time that is being measured
   */
  metric?: string;
  /**
   * Priority that a ticket must match
   */
  priority?: string;
  /**
   * The time within which the end-state for a metric should be met
   */
  target?: number;
};

export type GroupSLAPolicyObject = {
  /**
   * The time the Group SLA policy was created
   */
  readonly created_at?: string;
  /**
   * The description of the Group SLA policy
   */
  description?: string;
  filter: GroupSLAPolicyFilterObject;
  /**
   * Automatically assigned when created
   */
  readonly id?: string;
  /**
   * Array of [policy metric](#policy-metric) objects
   */
  policy_metrics?: Array<GroupSLAPolicyMetricObject>;
  /**
   * Position of the Group SLA policy. This position determines the order in which policies are matched to tickets. If not specified, the Group SLA policy is added at the last position
   */
  position?: number;
  /**
   * The title of the Group SLA policy
   */
  title: string;
  /**
   * The time of the last update of the Group SLA policy
   */
  readonly updated_at?: string;
  /**
   * URL of the Group SLA policy record
   */
  readonly url?: string;
};

export type GroupSLAPolicyResponse = {
  group_sla_policy?: GroupSLAPolicyObject;
};

export type GroupsCountObject = {
  count?: {
    /**
     * Timestamp that indicates when the count was last updated
     */
    readonly refreshed_at?: string;
    /**
     * Approximate count of groups
     */
    readonly value?: number;
  };
};

export type GroupsResponse = {
  groups?: Array<GroupObject>;
};

export type HostMappingObject = {
  /**
   * The canonical name record for a host mapping
   */
  cname?: string;
  /**
   * Array of expected CNAME records for host mapping(s) of a given brand
   */
  expected_cnames?: Array<string>;
  /**
   * Whether a host mapping is valid or not for a given brand
   */
  is_valid?: boolean;
  /**
   * Reason why a host mapping is valid or not
   */
  reason?: string;
};

export type IncrementalSkillBasedRouting = {
  /**
   * Routing attribute values
   */
  attribute_values?: Array<IncrementalSkillBasedRoutingAttributeValue>;
  /**
   * Routing attributes
   */
  attributes?: Array<IncrementalSkillBasedRoutingAttribute>;
  /**
   * The number of results returned for the current request
   */
  readonly count?: number;
  /**
   * The most recent resource creation time present in this result set in Unix epoch time
   */
  readonly end_time?: number;
  /**
   * Routing instance values
   */
  instance_values?: Array<IncrementalSkillBasedRoutingInstanceValue>;
  /**
   * The URL that should be called to get the next set of results
   */
  readonly next_page?: string;
};

export type IncrementalSkillBasedRoutingAttribute = {
  /**
   * Automatically assigned when an attribute is created
   */
  readonly id?: string;
  /**
   * The name of the attribute
   */
  readonly name?: string;
  /**
   * The time the attribute was created, updated, or deleted
   */
  readonly time?: string;
  /**
   * One of "create", "update", or "delete"
   */
  readonly type?: string;
};

export type IncrementalSkillBasedRoutingAttributeValue = {
  /**
   * Id of the associated attribute
   */
  readonly attribute_id?: string;
  /**
   * Automatically assigned when an attribute value is created
   */
  readonly id?: string;
  /**
   * The name of the attribute value
   */
  readonly name?: string;
  /**
   * The time the attribute value was created, updated, or deleted
   */
  readonly time?: string;
  /**
   * One of "create", "update", or "delete"
   */
  readonly type?: string;
};

export type IncrementalSkillBasedRoutingInstanceValue = {
  /**
   * Id of the associated attribute value
   */
  readonly attribute_value_id?: string;
  /**
   * Automatically assigned when an instance value is created
   */
  readonly id?: string;
  /**
   * Id of the associated agent or ticket
   */
  readonly instance_id?: string;
  /**
   * The time the instance value was created or deleted
   */
  readonly time?: string;
  /**
   * One of "associate_agent", "unassociate_agent", "associate_ticket", or "unassociate_ticket"
   */
  readonly type?: string;
};

export type JobStatusObject = {
  /**
   * Automatically assigned when the job is queued
   */
  readonly id?: string;
  /**
   * The type of the job
   */
  readonly job_type?: string;
  /**
   * Message from the job worker, if any
   */
  readonly message?: string | null;
  /**
   * Number of tasks that have already been completed
   */
  readonly progress?: number | null;
  /**
   * Result data from processed tasks. See [Results](#results) below
   */
  readonly results?:
    | Array<JobStatusResultObject>
    | null
    | {
        /**
         * Whether the action was successful or not
         */
        readonly success: boolean;
      };
  /**
   * The current status. One of the following: "queued", "working", "failed", "completed"
   */
  readonly status?: string;
  /**
   * The total number of tasks this job is batching through
   */
  readonly total?: number | null;
  /**
   * The URL to poll for status updates
   */
  readonly url?: string;
};

export type JobStatusResponse = {
  job_status?: JobStatusObject;
};

export type JobStatusResultObject = CreateResourceResult | UpdateResourceResult;

export type JobStatusesResponse = {
  job_statuses: Array<JobStatusObject>;
};

export type ListDeletedTicketsResponse = {
  deleted_tickets?: Array<{
    actor?: {
      id?: number;
      name?: string;
    };
    deleted_at?: string;
    id?: number;
    previous_state?: string;
    subject?: string;
  }>;
} & OffsetPaginationObject;

export type ListTicketCollaboratorsResponse = {
  [key: string]: unknown;
};

export type ListTicketEmailCCsResponse = {
  [key: string]: unknown;
};

export type ListTicketFollowersResponse = {
  [key: string]: unknown;
};

export type ListTicketIncidentsResponse = {
  [key: string]: unknown;
};

export type ListTicketProblemsResponse = {
  [key: string]: unknown;
};

export type LocaleObject = {
  /**
   * The ISO 8601 formatted date-time the locale was created
   */
  readonly created_at?: string;
  /**
   * The unique ID of the locale
   */
  readonly id?: number;
  /**
   * The name of the locale
   */
  readonly locale?: string;
  /**
   * The name of the language
   */
  readonly name?: string;
  /**
   * The ISO 8601 formatted date-time when the locale was last updated
   */
  readonly updated_at?: string;
  /**
   * The URL of the locale record
   */
  readonly url?: string;
};

export type LocaleResponse = {
  locale?: LocaleObject;
};

export type LocalesResponse = {
  locales?: Array<LocaleObject>;
};

export type MacroApplyTicketResponse = {
  result?: {
    ticket?: {
      assignee_id?: number;
      comment?: {
        body?: string;
        public?: boolean;
        scoped_body?: Array<Array<string>>;
      };
      fields?: {
        id?: number;
        value?: string;
      };
      group_id?: number;
      id?: number;
      url?: string;
    };
  };
};

export type MacroAttachmentObject = {
  /**
   * The content type of the image. Example value: "image/png"
   */
  readonly content_type?: string;
  /**
   * A full URL where the attachment image file can be downloaded
   */
  readonly content_url?: string;
  /**
   * The time when this attachment was created
   */
  created_at?: string;
  /**
   * The name of the image file
   */
  readonly filename?: string;
  /**
   * Automatically assigned when created
   */
  readonly id?: number;
  /**
   * The size of the image file in bytes
   */
  readonly size?: number;
};

export type MacroAttachmentResponse = {
  macro_attachment?: MacroAttachmentObject;
};

export type MacroAttachmentsResponse = {
  macro_attachments?: Array<MacroAttachmentObject>;
};

export type MacroCategoriesResponse = {
  categories?: Array<string>;
};

export type MacroCommonObject = {
  /**
   * Each action describes what the macro will do. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)
   */
  actions: Array<ActionObject>;
  /**
   * Useful for determining if the macro should be displayed
   */
  active?: boolean;
  /**
   * The time the macro was created
   */
  created_at?: string;
  /**
   * If true, the macro is a default macro
   */
  readonly default?: boolean;
  /**
   * The description of the macro
   */
  description?: string | null;
  /**
   * The ID automatically assigned when a macro is created
   */
  id?: number;
  /**
   * The position of the macro
   */
  position?: number;
  /**
   * Access to this macro. A null value allows unrestricted access for all users in the account
   */
  restriction?: {
    [key: string]: unknown;
  } | null;
  /**
   * The title of the macro
   */
  title: string;
  /**
   * The time of the last update of the macro
   */
  updated_at?: string;
  /**
   * A URL to access the macro's details
   */
  url?: string;
};

export type MacroInput = {
  /**
   * Each action describes what the macro will do
   */
  actions: Array<ActionObject>;
  /**
   * Useful for determining if the macro should be displayed
   */
  active?: boolean;
  /**
   * The description of the macro
   */
  description?: string | null;
  /**
   * Who may access this macro. Will be null when everyone in the account can access it
   */
  restriction?: {
    /**
     * The numeric ID of the group or user
     */
    id?: number;
    /**
     * The numeric IDs of the groups
     */
    ids?: Array<number>;
    /**
     * Allowed values are Group or User
     */
    type?: string;
    [key: string]: unknown | number | string;
  };
  /**
   * The title of the macro
   */
  title: string;
};

export type MacroObject = MacroCommonObject & {
  /**
   * The app installation that requires each macro, if present
   */
  app_installation?: string | null;
  /**
   * The macro categories
   */
  categories?: string | null;
  /**
   * Permissions for each macro
   */
  permissions?: string | null;
  /**
   * The number of times each macro has been used in the past hour
   */
  usage_1h?: number;
  /**
   * The number of times each macro has been used in the past week
   */
  usage_7d?: number;
  /**
   * The number of times each macro has been used in the past day
   */
  usage_24h?: number;
  /**
   * The number of times each macro has been used in the past thirty days
   */
  usage_30d?: number;
};

export type MacroResponse = {
  macro?: MacroObject;
};

export type MacroUpdateManyInput = {
  macros?: Array<{
    /**
     * The active status of the macro (true or false)
     */
    active?: boolean;
    /**
     * The ID of the macro to update
     */
    id: number;
    /**
     * The new position of the macro
     */
    position?: number;
  }>;
};

export type MacrosResponse = {
  macros?: Array<MacroObject>;
} & OffsetPaginationObject;

export type ObjectTriggerActionDefinitionObject = {
  group?: string;
  nullable?: boolean;
  repeatable?: boolean;
  subject?: string;
  title?: string;
  type?: string;
  values?: Array<{
    enabled?: boolean;
    format?: string;
    title?: string;
    value?: string;
  }>;
};

export type ObjectTriggerBulkUpdateItem = {
  /**
   * Whether an object trigger is active
   */
  active?: boolean;
  /**
   * The id of the object trigger to update
   */
  id: number;
  /**
   * The new position of the object trigger
   */
  position?: number;
};

export type ObjectTriggerBulkUpdateRequest = {
  triggers?: Array<ObjectTriggerBulkUpdateItem>;
};

export type ObjectTriggerConditionDefinitionObjectAll = {
  group?: string;
  nullable?: boolean;
  operators?: Array<{
    format?: string;
    terminal?: boolean;
    title?: string;
    value?: string;
  }>;
  repeatable?: boolean;
  subject?: string;
  title?: string;
  type?: string;
  values?: Array<{
    enabled?: boolean;
    title?: string;
    value?: string;
  }>;
};

export type ObjectTriggerConditionDefinitionObjectAny = {
  group?: string;
  nullable?: boolean;
  operators?: Array<{
    format?: string;
    terminal?: boolean;
    title?: string;
    value?: string;
  }>;
  repeatable?: boolean;
  subject?: string;
  title?: string;
  type?: string;
  values?: Array<{
    enabled?: boolean;
    title?: string;
    value?: string;
  }>;
};

export type ObjectTriggerDefinitionObject = {
  actions?: Array<ObjectTriggerActionDefinitionObject>;
  conditions_all?: Array<ObjectTriggerConditionDefinitionObjectAll>;
  conditions_any?: Array<ObjectTriggerConditionDefinitionObjectAny>;
};

export type ObjectTriggerDefinitionResponse = {
  definitions?: ObjectTriggerDefinitionObject;
};

export type ObjectTriggerObject = {
  /**
   * An array of actions the trigger does when its conditions are met. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)
   */
  actions: Array<TriggerActionObject>;
  /**
   * Whether the trigger is active
   */
  active?: boolean;
  conditions: TriggerConditionsObject;
  /**
   * The time the trigger was created
   */
  readonly created_at?: string;
  /**
   * Always false for object triggers
   */
  readonly default?: boolean;
  /**
   * The description of the trigger
   */
  description?: string;
  /**
   * Automatically assigned when created
   */
  readonly id?: number;
  /**
   * Position of the trigger, determines the order they will execute in
   */
  position?: number;
  /**
   * The raw format of the title of the trigger
   */
  raw_title?: string;
  /**
   * The title of the trigger
   */
  title: string;
  /**
   * The time of the last update of the trigger
   */
  readonly updated_at?: string;
  /**
   * The url of the trigger
   */
  readonly url?: string;
};

export type ObjectTriggerRequest = {
  trigger?: ObjectTriggerObject;
};

export type ObjectTriggerResponse = {
  trigger?: ObjectTriggerObject;
};

export type ObjectTriggersResponse = {
  count?: number;
  next_page?: string | null;
  previous_page?: string | null;
  triggers?: Array<ObjectTriggerObject>;
};

export type OffsetPaginationObject = {
  /**
   * the total record count
   */
  count?: number;
  /**
   * the URL of the next page
   */
  next_page?: string | null;
  /**
   * the URL of the previous page
   */
  previous_page?: string | null;
};

export type OrganizationFieldObject = CustomFieldObject;

export type OrganizationFieldResponse = {
  organization_field?: OrganizationFieldObject;
};

export type OrganizationFieldsResponse = {
  /**
   * Total count of records retrieved
   */
  readonly count?: number;
  /**
   * URL of the next page
   */
  readonly next_page?: string | null;
  organization_fields?: Array<OrganizationFieldObject>;
  /**
   * URL of the previous page
   */
  readonly previous_page?: string | null;
};

export type OrganizationMembershipObject = {
  /**
   * When this record was created
   */
  readonly created_at?: string;
  /**
   * Denotes whether this is the default organization membership for the user. If false, returns `null`
   */
  default: boolean | null;
  /**
   * Automatically assigned when the membership is created
   */
  readonly id?: number;
  /**
   * The ID of the organization associated with this user, in this membership
   */
  readonly organization_id: number;
  /**
   * The name of the organization associated with this user, in this membership
   */
  readonly organization_name?: string;
  /**
   * When this record last got updated
   */
  readonly updated_at?: string;
  /**
   * The API url of this membership
   */
  readonly url?: string;
  /**
   * The ID of the user for whom this memberships belongs
   */
  readonly user_id: number;
  /**
   * Denotes whether the user can or cannot have access to all organization's tickets.
   */
  readonly view_tickets?: boolean;
};

export type OrganizationMembershipResponse = {
  organization_membership?: OrganizationMembershipObject;
};

export type OrganizationMembershipsResponse = {
  organization_memberships?: Array<OrganizationMembershipObject>;
};

export type OrganizationMergeListResponse = {
  organization_merges?: Array<{
    id?: string;
    loser_id?: number;
    status?: 'new' | 'in_progress' | 'error' | 'complete';
    url?: string;
    winner_id?: number;
  }>;
};

export type OrganizationMergeRequest = {
  organization_merge?: {
    /**
     * The id of the winning organization.
     */
    winner_id?: number;
  };
};

export type OrganizationMergeResponse = {
  organization_merge?: {
    id: string;
    loser_id: number;
    status: 'new' | 'in_progress' | 'error' | 'complete';
    url: string;
    winner_id: number;
  };
};

export type status2 = 'new' | 'in_progress' | 'error' | 'complete';

export type OrganizationMetadataObject = {
  /**
   * The number of tickets for the organization
   */
  tickets_count?: number;
  /**
   * The number of users for the organization
   */
  users_count?: number;
};

export type OrganizationObject = {
  /**
   * The time the organization was created
   */
  readonly created_at?: string;
  /**
   * Any details obout the organization, such as the address
   */
  details?: string | null;
  /**
   * An array of domain names associated with this organization
   */
  domain_names?: Array<string>;
  /**
   * A unique external id to associate organizations to an external record. The id is case-insensitive. For example, "company1" and "Company1" are considered the same
   */
  external_id?: string | null;
  /**
   * New tickets from users in this organization are automatically put in this group
   */
  group_id?: number | null;
  /**
   * Automatically assigned when the organization is created
   */
  id?: number;
  /**
   * A unique name for the organization
   */
  name: string;
  /**
   * Any notes you have about the organization
   */
  notes?: string | null;
  /**
   * Custom fields for this organization. See [Custom organization fields](/api-reference/ticketing/organizations/organizations/#custom-organization-fields)
   */
  organization_fields?: {
    [key: string]: string | number;
  } | null;
  /**
   * End users in this organization are able to comment on each other's tickets
   */
  shared_comments?: boolean;
  /**
   * End users in this organization are able to see each other's tickets
   */
  shared_tickets?: boolean;
  /**
   * The tags of the organization
   */
  tags?: Array<string>;
  /**
   * The time of the last update of the organization
   */
  readonly updated_at?: string;
  /**
   * The API url of this organization
   */
  readonly url?: string;
};

export type OrganizationResponse = {
  organization?: OrganizationObject;
};

export type OrganizationSubscriptionCreateRequest = {
  organization_subscription?: OrganizationSubscriptionInput;
};

export type OrganizationSubscriptionInput = {
  /**
   * The ID of the organization
   */
  organization_id?: number;
  /**
   * The ID of the user
   */
  user_id?: number;
};

export type OrganizationSubscriptionObject = {
  /**
   * The date the organization subscription was created
   */
  created_at?: string;
  /**
   * The ID of the organization subscription
   */
  id?: number;
  /**
   * The ID of the organization
   */
  organization_id?: number;
  /**
   * The ID of the user
   */
  user_id?: number;
};

export type OrganizationSubscriptionResponse = {
  organization_subscription?: OrganizationSubscriptionObject;
};

export type OrganizationSubscriptionsResponse = OffsetPaginationObject & {
  /**
   * An array of organization subscriptions
   */
  organization_subscriptions?: Array<OrganizationSubscriptionObject>;
};

export type OrganizationsRelatedResponse = {
  organization_related?: OrganizationMetadataObject;
};

export type OrganizationsResponse = {
  count?: number;
  next_page?: string | null;
  organizations?: Array<OrganizationObject>;
  previous_page?: string | null;
};

export type Pagination = {
  links?: {
    next?: string;
    prev?: string;
  };
  meta?: {
    after_cursor?: string;
    before_cursor?: string;
    has_more?: boolean;
  };
};

export type PushNotificationDevicesInput = Array<string>;

export type PushNotificationDevicesRequest = {
  push_notification_devices?: PushNotificationDevicesInput;
};

export type QueueObject = {
  /**
   * The time the queue was created
   */
  readonly created_at?: string;
  /**
   * Conditions when queue could be applied
   */
  definition?: {
    all?: Array<{
      field?: string;
      operator?: string;
      value?: string;
    }>;
    any?: Array<{
      field?: string;
      operator?: string;
      value?: string;
    }>;
  };
  /**
   * The description of the queue
   */
  description?: string;
  /**
   * Automatically assigned when creating queue
   */
  readonly id?: string;
  /**
   * The name of the queue
   */
  name?: string;
  /**
   * The queue-applied order
   */
  order?: number;
  /**
   * Primary group ids linked to the queue
   */
  primary_groups?: {
    count?: number;
    groups?: Array<{
      id?: number;
      name?: string;
    }>;
  };
  /**
   * The queue-applied priority
   */
  priority?: number;
  /**
   * Secondary group ids linked to the queue
   */
  secondary_groups?: {
    count?: number;
    groups?: Array<{
      id?: number;
      name?: string;
    }>;
  };
  /**
   * The time of the queue's last update
   */
  readonly updated_at?: string;
  /**
   * The API URL of the queue
   */
  readonly url?: string;
};

export type QueueResponse = {
  queue?: QueueObject;
};

export type QueuesResponse = {
  queues?: Array<QueueObject>;
};

export type RecipientObject = {
  /**
   * Details about the delivery status
   */
  delivery_status?: {
    /**
     * The delivery status code (SMTP code and DSN code)
     */
    readonly code?: string;
    /**
     * The delivery status id
     */
    readonly id?: number;
    /**
     * The delivery status description
     */
    readonly message?: string;
    /**
     * The delivery status type (key)
     */
    readonly name?: string;
  };
  /**
   * The recipient's email address
   */
  readonly email_address?: string;
  /**
   * The recipient's user id
   */
  readonly user_id?: number;
};

export type RecoverSuspendedTicketResponse = {
  ticket?: Array<TicketObject>;
};

export type RecoverSuspendedTicketUnprocessableContentResponse = {
  ticket?: Array<SuspendedTicketObject>;
};

export type RecoverSuspendedTicketsResponse = {
  tickets?: Array<TicketObject>;
};

export type RelationshipFilterDefinition = {
  conditions_all?: Array<TriggerConditionDefinitionObjectAll>;
  conditions_any?: Array<TriggerConditionDefinitionObjectAny>;
};

export type RelationshipFilterDefinitionResponse = {
  definitions?: RelationshipFilterDefinition;
};

export type RenewSessionResponse = {
  /**
   * A token of authenticity for the request
   */
  authenticity_token?: string;
};

export type RequestObject = {
  /**
   * The id of the assignee if the field is visible to end users
   */
  readonly assignee_id?: number;
  /**
   * If true, an end user can mark the request as solved. See [Update Request](/api-reference/ticketing/tickets/ticket-requests/#update-request)
   */
  readonly can_be_solved_by_me?: boolean;
  /**
   * The ids of users currently CC'ed on the ticket
   */
  readonly collaborator_ids?: Array<number>;
  /**
   * When this record was created
   */
  readonly created_at?: string;
  /**
   * Custom fields for the request. See [Setting custom field values](/api-reference/ticketing/tickets/tickets/#setting-custom-field-values) in the Tickets doc
   */
  custom_fields?: Array<{
    id?: number;
    value?: string;
  }>;
  /**
   * The custom ticket status id of the ticket
   */
  custom_status_id?: number;
  /**
   * Read-only first comment on the request. When [creating a request](#create-request), use `comment` to set the description
   */
  readonly description?: string;
  /**
   * When the task is due (only applies if the request is of type "task")
   */
  due_at?: string;
  /**
   * The ids of users who are currently email CCs on the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233) in the Support Help Center
   */
  readonly email_cc_ids?: Array<number>;
  /**
   * The id of the original ticket if this request is a follow-up ticket. See [Create Request](#create-request)
   */
  readonly followup_source_id?: number;
  /**
   * The id of the assigned group if the field is visible to end users
   */
  readonly group_id?: number;
  /**
   * Automatically assigned when creating requests
   */
  readonly id?: number;
  /**
   * Is true if any comments are public, false otherwise
   */
  readonly is_public?: boolean;
  /**
   * The organization of the requester
   */
  readonly organization_id?: number;
  /**
   * The priority of the request, "low", "normal", "high", "urgent"
   */
  priority?: string;
  /**
   * The original recipient e-mail address of the request
   */
  recipient?: string;
  /**
   * The id of the requester
   */
  readonly requester_id?: number;
  /**
   * Whether or not request is solved (an end user can set this if "can_be_solved_by_me", above, is true for that user)
   */
  solved?: boolean;
  /**
   * The state of the request, "new", "open", "pending", "hold", "solved", "closed"
   */
  status?: string;
  /**
   * The value of the subject field for this request if the subject field is visible to end users; a truncated version of the description otherwise
   */
  subject: string;
  /**
   * The numeric id of the ticket form associated with this request if the form is visible to end users - only applicable for enterprise accounts
   */
  ticket_form_id?: number;
  /**
   * The type of the request, "question", "incident", "problem", "task"
   */
  type?: string;
  /**
   * When this record last got updated
   */
  readonly updated_at?: string;
  /**
   * The API url of this request
   */
  readonly url?: string;
  via?: TicketAuditViaObject;
};

export type RequestResponse = {
  request?: RequestObject;
};

export type RequestsResponse = {
  requests?: Array<RequestObject>;
};

export type ResourceCollectionObject = {
  /**
   * When the resource collection was created
   */
  readonly created_at?: string;
  /**
   * id for the resource collection. Automatically assigned upon creation
   */
  readonly id?: number;
  /**
   * Array of resource metadata objects. See [Resource objects](#resource-objects)
   */
  readonly resources?: Array<{
    deleted?: boolean;
    identifier?: string;
    resource_id?: number;
    type?: string;
  }>;
  /**
   * Last time the resource collection was updated
   */
  readonly updated_at?: string;
};

export type ResourceCollectionResponse = {
  resource_collection?: ResourceCollectionObject;
};

export type ResourceCollectionsResponse = {
  readonly count?: number;
  readonly next_page?: string | null;
  readonly previous_page?: string | null;
  resource_collections?: Array<ResourceCollectionObject>;
};

export type ReverseLookupResponse = UsersResponse;

export type SLAPoliciesResponse = {
  readonly count?: number;
  readonly next_page?: string | null;
  readonly previous_page?: string | null;
  sla_policies?: Array<SLAPolicyObject>;
};

export type SLAPolicyFilterConditionObject = {
  /**
   * The name of a ticket field
   */
  field?: string;
  /**
   * A comparison operator
   */
  operator?: string;
  /**
   * The value of a ticket field
   */
  value?: string | Array<string | number>;
};

export type SLAPolicyFilterDefinitionResponse = {
  definitions?: {
    all?: Array<{
      group?: string;
      operators?: Array<{
        title?: string;
        value?: string;
      }>;
      target?: string | null;
      title?: string;
      value?: string;
      values?: {
        list?: Array<{
          title?: string;
          value?: string | null;
        }>;
        type?: string;
      };
    }>;
    any?: Array<{
      group?: string;
      operators?: Array<{
        title?: string;
        value?: string;
      }>;
      target?: string | null;
      title?: string;
      value?: string;
      values?: {
        list?: Array<{
          title?: string;
          value?: string | null;
        }>;
        type?: string;
      };
    }>;
  };
};

/**
 * An object that describes the conditions that a ticket must match in order for an SLA policy to be applied to that ticket. See [Filter](#filter).
 */
export type SLAPolicyFilterObject = {
  all?: Array<SLAPolicyFilterConditionObject>;
  any?: Array<SLAPolicyFilterConditionObject>;
};

export type SLAPolicyMetricObject = {
  /**
   * Whether the metric targets are being measured in business hours or calendar hours
   */
  business_hours?: boolean;
  /**
   * The definition of the time that is being measured
   */
  metric?: string;
  /**
   * Priority that a ticket must match
   */
  priority?: string;
  /**
   * The time within which the end-state for a metric should be met
   */
  target?: number;
};

export type SLAPolicyObject = {
  /**
   * The time the SLA policy was created
   */
  readonly created_at?: string;
  /**
   * The description of the SLA policy
   */
  description?: string;
  filter: SLAPolicyFilterObject;
  /**
   * Automatically assigned when created
   */
  readonly id?: number;
  /**
   * Array of [Policy Metric](#policy-metric) objects
   */
  policy_metrics?: Array<SLAPolicyMetricObject>;
  /**
   * Position of the SLA policy that determines the order they will be matched. If not specified, the SLA policy is added as the last position
   */
  position?: number;
  /**
   * The title of the SLA policy
   */
  title: string;
  /**
   * The time of the last update of the SLA policy
   */
  readonly updated_at?: string;
  /**
   * URL of the SLA Policy reacord
   */
  readonly url?: string;
};

export type SLAPolicyResponse = {
  sla_policy?: SLAPolicyObject;
};

export type SatisfactionRatingObject = {
  /**
   * The id of agent assigned to at the time of rating
   */
  readonly assignee_id: number;
  /**
   * The comment received with this rating, if available
   */
  comment?: string;
  /**
   * The time the satisfaction rating got created
   */
  readonly created_at?: string;
  /**
   * The id of group assigned to at the time of rating
   */
  readonly group_id: number;
  /**
   * Automatically assigned upon creation
   */
  readonly id?: number;
  /**
   * The reason for a bad rating given by the requester in a follow-up question. Satisfaction reasons must be [enabled](https://support.zendesk.com/hc/en-us/articles/223152967)
   */
  reason?: string;
  /**
   * The default reasons the user can select from a list menu for giving a negative rating. See [Reason codes](/api-reference/ticketing/ticket-management/satisfaction_reasons/#reason-codes) in the Satisfaction Reasons API. Can only be set on ratings with a `score` of "bad". Responses don't include this property
   */
  reason_code?: number;
  /**
   * id for the reason the user gave a negative rating. Can only be set on ratings with a `score` of "bad". To get a descriptive value for the id, use the [Show Reason for Satisfaction Rating](/api-reference/ticketing/ticket-management/satisfaction_reasons/#show-reason-for-satisfaction-rating) endpoint
   */
  reason_id?: number;
  /**
   * The id of ticket requester submitting the rating
   */
  readonly requester_id: number;
  /**
   * The rating "offered", "unoffered", "good" or "bad"
   */
  score: string;
  /**
   * The id of ticket being rated
   */
  readonly ticket_id: number;
  /**
   * The time the satisfaction rating got updated
   */
  readonly updated_at?: string;
  /**
   * The API url of this rating
   */
  readonly url?: string;
};

export type SatisfactionRatingResponse = {
  satisfaction_rating?: Array<SatisfactionRatingObject>;
};

export type SatisfactionRatingsCountResponse = {
  count?: {
    refreshed_at?: string;
    value?: number;
  };
};

export type SatisfactionRatingsResponse = {
  satisfaction_ratings?: Array<SatisfactionRatingObject>;
};

export type SatisfactionReasonObject = {
  /**
   * The time the reason was created
   */
  readonly created_at?: string;
  /**
   * The time the reason was deleted
   */
  readonly deleted_at?: string;
  /**
   * Automatically assigned upon creation
   */
  readonly id?: number;
  /**
   * The dynamic content placeholder, if present, or the current "value", if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  raw_value?: string;
  /**
   * An account-level code for referencing the reason. Custom reasons are assigned an auto-incrementing integer (non-system reason codes begin at 1000). See [Reason codes](#reason-codes)
   */
  readonly reason_code?: number;
  /**
   * The time the reason was updated
   */
  readonly updated_at?: string;
  /**
   * API URL for the resource
   */
  readonly url?: string;
  /**
   * Translated value of the reason in the account locale
   */
  value: string;
};

export type SatisfactionReasonResponse = {
  reason?: Array<SatisfactionReasonObject>;
};

export type SatisfactionReasonsResponse = {
  reasons?: Array<SatisfactionReasonObject>;
};

export type SearchCountResponse = {
  count?: number;
};

export type SearchExportResponse = {
  /**
   * The facets corresponding to the search query
   */
  readonly facets?: string | null;
  /**
   * The links to the previous and next entries via the cursor ids in the metadata.
   */
  links?: {
    /**
     * The url to the next entry via the cursor.
     */
    readonly next?: string | null;
    /**
     * The url to the previous entry via the cursor.
     */
    readonly prev?: string | null;
  };
  /**
   * Metadata for the export query response.
   */
  meta?: {
    /**
     * The cursor id for the next object.
     */
    readonly after_cursor?: string | null;
    /**
     * The cursor id for the previous object.
     */
    readonly before_cursor?: string | null;
    /**
     * Whether there are more items yet to be returned by the cursor.
     */
    readonly has_more?: boolean;
  };
  /**
   * May consist of tickets, users, groups, or organizations, as specified by the `result_type` property in each result object
   */
  readonly results?: Array<SearchResultObject>;
};

export type SearchResponse = {
  /**
   * The number of resources returned by the query corresponding to this page of results in the paginated response
   */
  readonly count?: number;
  /**
   * The facets corresponding to the search query
   */
  readonly facets?: string | null;
  /**
   * URL to the next page of results
   */
  readonly next_page?: string | null;
  /**
   * URL to the previous page of results
   */
  readonly previous_page?: string | null;
  /**
   * May consist of tickets, users, groups, or organizations, as specified by the `result_type` property in each result object
   */
  readonly results?: Array<SearchResultObject>;
};

export type SearchResultObject = {
  /**
   * When the resource was created
   */
  created_at?: string;
  /**
   * Flag to indicate whether this is the default resource
   */
  default?: boolean;
  /**
   * Flag to indicate whether or not resource has been deleted
   */
  deleted?: boolean;
  /**
   * The description of the resource
   */
  description?: string;
  /**
   * The ID of the resource
   */
  id?: number;
  /**
   * The name of the resource
   */
  name?: string;
  /**
   * The type of the resource
   */
  result_type?: string;
  /**
   * When the resource was last updated
   */
  updated_at?: string;
  /**
   * The url of the resource
   */
  url?: string;
};

export type SessionObject = {
  /**
   * When the session was created
   */
  authenticated_at?: string | null;
  /**
   * Automatically assigned when the session is created
   */
  id: number;
  /**
   * The last approximate time this session was seen. This does not update on every request.
   */
  last_seen_at?: string | null;
  /**
   * The API URL of this session
   */
  url?: string | null;
  /**
   * The id of the user
   */
  user_id?: number | null;
};

export type SessionResponse = {
  session?: Array<SessionObject>;
};

export type SessionsResponse = {
  sessions?: Array<SessionObject>;
};

export type SharingAgreementObject = {
  /**
   * The time the record was created
   */
  readonly created_at?: string;
  /**
   * Automatically assigned upon creation
   */
  readonly id?: number;
  /**
   * Name of this sharing agreement
   */
  name?: string;
  /**
   * Can be one of the following: "jira", null
   */
  partner_name?: string | null;
  /**
   * Subdomain of the remote account or null if not associated with an account
   */
  remote_subdomain?: string;
  /**
   * Can be one of the following: "accepted", "declined", "pending", "inactive", "failed", "ssl_error", "configuration_error"
   */
  status?: string;
  /**
   * Can be one of the following: "inbound", "outbound"
   */
  type?: string;
  /**
   * The time the record was updated
   */
  readonly updated_at?: string;
  /**
   * URL of the sharing agreement record
   */
  readonly url?: string;
};

export type SharingAgreementResponse = {
  sharing_agreement?: SharingAgreementObject;
};

export type SharingAgreementsResponse = {
  sharing_agreements?: Array<SharingAgreementObject>;
};

export type SkillBasedRoutingAttributeDefinitions = {
  definitions?: {
    conditions_all?: Array<{
      subject?: string;
      title?: string;
    }>;
    conditions_any?: Array<{
      subject?: string;
      title?: string;
    }>;
  };
};

export type SkillBasedRoutingAttributeObject = {
  /**
   * When this record was created
   */
  readonly created_at?: string;
  /**
   * Automatically assigned when an attribute is created
   */
  readonly id?: string;
  /**
   * The name of the attribute
   */
  name: string;
  /**
   * When this record was last updated
   */
  readonly updated_at?: string;
  /**
   * URL of the attribute
   */
  readonly url?: string;
};

export type SkillBasedRoutingAttributeResponse = {
  attribute?: SkillBasedRoutingAttributeObject;
};

export type SkillBasedRoutingAttributeValueObject = {
  /**
   * Id of the associated attribute
   */
  attribute_id?: string;
  /**
   * When this record was created
   */
  readonly created_at?: string;
  /**
   * Automatically assigned when an attribute value is created
   */
  readonly id?: string;
  /**
   * The name of the attribute value
   */
  name?: string;
  /**
   * When this record was last updated
   */
  readonly updated_at?: string;
  /**
   * URL of the attribute value
   */
  readonly url?: string;
};

export type SkillBasedRoutingAttributeValueResponse = {
  attribute_value?: SkillBasedRoutingAttributeValueObject;
};

export type SkillBasedRoutingAttributeValuesResponse = {
  attribute_values?: Array<SkillBasedRoutingAttributeValueObject>;
};

export type SkillBasedRoutingAttributesResponse = {
  attributes?: Array<SkillBasedRoutingAttributeObject>;
  readonly count?: number;
  readonly next_page?: string | null;
  readonly previous_page?: string | null;
};

export type SkillBasedRoutingTicketFulfilledResponse = {
  fulfilled_ticket_ids?: Array<number>;
};

export type SupportAddressObject = {
  /**
   * The ID of the [brand](/api-reference/ticketing/account-configuration/brands/)
   */
  brand_id?: number;
  /**
   * Whether all of the required CNAME records are set. Possible values: "unknown", "verified", "failed"
   */
  readonly cname_status?: 'unknown' | 'verified' | 'failed';
  /**
   * When the address was created
   */
  readonly created_at?: string;
  /**
   * Whether the address is the account's default support address
   */
  default?: boolean;
  /**
   * Verification statuses for the domain and CNAME records. Possible types: "verified", "failed"
   */
  readonly dns_results?: 'verified' | 'failed';
  /**
   * Verification string to be added as a TXT record to the domain. Possible types: string or null.
   */
  readonly domain_verification_code?: string;
  /**
   * Whether the domain verification record is valid. Possible values: "unknown", "verified", "failed"
   */
  readonly domain_verification_status?: 'unknown' | 'verified' | 'failed';
  /**
   * The email address. You can't change the email address of an existing support address.
   */
  email: string;
  /**
   * Status of email forwarding. Possible values: "unknown", "waiting", "verified", or "failed"
   */
  readonly forwarding_status?: 'unknown' | 'waiting' | 'verified' | 'failed';
  /**
   * Automatically assigned when created
   */
  readonly id?: number;
  /**
   * The name for the address
   */
  name?: string;
  /**
   * Whether the SPF record is set up correctly. Possible values: "unknown", "verified", "failed"
   */
  readonly spf_status?: 'unknown' | 'verified' | 'failed';
  /**
   * When the address was updated
   */
  readonly updated_at?: string;
};

/**
 * Whether all of the required CNAME records are set. Possible values: "unknown", "verified", "failed"
 */
export type cname_status = 'unknown' | 'verified' | 'failed';

/**
 * Verification statuses for the domain and CNAME records. Possible types: "verified", "failed"
 */
export type dns_results = 'verified' | 'failed';

/**
 * Whether the domain verification record is valid. Possible values: "unknown", "verified", "failed"
 */
export type domain_verification_status = 'unknown' | 'verified' | 'failed';

/**
 * Status of email forwarding. Possible values: "unknown", "waiting", "verified", or "failed"
 */
export type forwarding_status = 'unknown' | 'waiting' | 'verified' | 'failed';

/**
 * Whether the SPF record is set up correctly. Possible values: "unknown", "verified", "failed"
 */
export type spf_status = 'unknown' | 'verified' | 'failed';

export type SupportAddressResponse = {
  recipient_address?: SupportAddressObject;
};

export type SupportAddressesResponse = {
  recipient_addresses?: Array<SupportAddressObject>;
};

export type SuspendedTicketObject = {
  /**
   * The attachments, if any associated to this suspended ticket. See [Attachments](/api-reference/ticketing/tickets/ticket-attachments/)
   */
  readonly attachments?: Array<AttachmentObject> | null;
  /**
   * The author id (if available), name and email
   */
  readonly author?: AuthorObject;
  /**
   * The id of the brand this ticket is associated with. Only applicable for Enterprise accounts
   */
  readonly brand_id?: number;
  /**
   * Why the ticket was suspended
   */
  readonly cause?: string;
  /**
   * The ID of the cause
   */
  readonly cause_id?: number;
  /**
   * The content that was flagged
   */
  readonly content?: string;
  /**
   * The ticket ID this suspended email is associated with, if available
   */
  readonly created_at?: string;
  /**
   * The error messages if any associated to this suspended ticket
   */
  readonly error_messages?: Array<{
    [key: string]: unknown;
  }> | null;
  /**
   * Automatically assigned
   */
  readonly id?: number;
  /**
   * The ID of the email, if available
   */
  readonly message_id?: string;
  /**
   * The original recipient e-mail address of the ticket
   */
  readonly recipient?: string;
  /**
   * The value of the subject field for this ticket
   */
  readonly subject?: string;
  /**
   * The ticket ID this suspended email is associated with, if available
   */
  readonly ticket_id?: number;
  /**
   * When the ticket was assigned
   */
  readonly updated_at?: string;
  /**
   * The API url of this ticket
   */
  readonly url?: string;
  via?: ViaObject;
};

export type SuspendedTicketResponse = {
  suspended_ticket?: Array<SuspendedTicketObject>;
};

export type SuspendedTicketsAttachmentsResponse = {
  upload?: {
    attachments?: Array<AttachmentObject>;
    /**
     * Token for subsequent request
     */
    readonly token?: string;
  };
};

export type SuspendedTicketsExportResponse = {
  export?: {
    readonly status?: string;
    readonly view_id?: string;
  };
};

export type SuspendedTicketsResponse = {
  suspended_tickets?: Array<SuspendedTicketObject>;
};

export type SystemFieldOptionObject = {
  /**
   * Name of the system field option
   */
  readonly name?: string;
  /**
   * Value of the system field option
   */
  readonly value?: string;
};

export type TagCountObject = {
  /**
   * The time that the count value was last refreshed
   */
  readonly refreshed_at?: string;
  /**
   * The count of tags created in the last 24 hours
   */
  readonly value?: number;
};

export type TagCountResponse = {
  count?: TagCountObject;
};

export type TagListTagObject = {
  /**
   * The number of tags
   */
  readonly count?: number;
  /**
   * A name for the tag
   */
  name?: string;
};

export type TagUrlObject = {
  /**
   * The url associated to the api request
   */
  readonly url?: string;
};

export type TagsByObjectIdResponse = {
  /**
   * An array of strings
   */
  tags: Array<string>;
};

export type TagsResponse = {
  /**
   * The number of pages
   */
  readonly count?: number;
  /**
   * The url of the previous page
   */
  readonly next_page?: string | null;
  /**
   * The url of the next page
   */
  readonly previous_page?: string | null;
  tags?: Array<TagListTagObject>;
};

export type TargetBasecamp = {
  /**
   * Can be filled if it is a "message" resource
   */
  message_id?: string;
  /**
   * The 37Signals password for the Basecamp account (only writable)
   */
  password?: string;
  /**
   * The ID of the project in Basecamp where updates should be pushed
   */
  project_id: string;
  /**
   * "todo" or "message"
   */
  resource: string;
  /**
   * The URL of your Basecamp account, including protocol and path
   */
  target_url: string;
  /**
   * Can be filled if it is a "todo" resource
   */
  todo_list_id?: string;
  /**
   * Get the API token from My info > Show your tokens > Token for feed readers or the Basecamp API in your Basecamp account
   */
  token: string;
  /**
   * The 37Signals username of the account you use to log in to Basecamp
   */
  username?: string;
};

export type TargetCampfire = {
  preserve_format?: boolean;
  room: string;
  ssl?: boolean;
  subdomain: string;
  token: string;
};

export type TargetClickatell = {
  api_id: string;
  /**
   * Read-only
   */
  attribute?: string;
  from?: string;
  /**
   * Read-only
   */
  method?: string;
  /**
   * only writable
   */
  password: string;
  /**
   * Read-only
   */
  target_url?: string;
  to: string;
  us_small_business_account?: string;
  username: string;
};

export type TargetCommonFields = {
  /**
   * Whether or not the target is activated
   */
  active?: boolean;
  /**
   * The time the target was created
   */
  readonly created_at?: string;
  /**
   * Automatically assigned when created
   */
  readonly id?: number;
  /**
   * A name for the target
   */
  title: string;
  /**
   * A pre-defined target, such as "basecamp_target". See the additional attributes for the type that follow
   */
  type: string;
};

export type TargetEmail = {
  email: string;
  subject: string;
};

export type TargetFailureObject = {
  /**
   * Number of times the target failed consecutively
   */
  readonly consecutive_failure_count?: number;
  /**
   * Time of the failure
   */
  readonly created_at?: string;
  /**
   * The ID of the target failure
   */
  readonly id?: number;
  /**
   * The raw message of the target request
   */
  readonly raw_request?: string;
  /**
   * The raw response of the failure
   */
  readonly raw_response?: string;
  /**
   * HTTP status code of the target failure
   */
  readonly status_code?: number;
  /**
   * Name of the target failure
   */
  readonly target_name?: string;
  /**
   * The API url of the failure record
   */
  readonly url?: string;
};

export type TargetFailureResponse = {
  target_failure?: TargetFailureObject;
};

export type TargetFailuresResponse = {
  target_failures?: Array<TargetFailureObject>;
};

export type TargetFlowdock = {
  api_token: string;
};

export type TargetGetSatisfaction = {
  account_name: string;
  email: string;
  /**
   * only writable
   */
  password: string;
  target_url?: string;
};

export type TargetHTTP = {
  /**
   * "application/json", "application/xml", or "application/x-www-form-urlencoded"
   */
  content_type: string;
  /**
   * "get", "patch", "put", "post", or "delete"
   */
  method: string;
  /**
   * only writable
   */
  password?: string;
  target_url: string;
  username?: string;
};

export type TargetJira = {
  /**
   * only writable
   */
  password: string;
  target_url: string;
  username: string;
};

export type TargetObject = TargetCommonFields &
  (
    | TargetBasecamp
    | TargetCampfire
    | TargetClickatell
    | TargetEmail
    | TargetFlowdock
    | TargetGetSatisfaction
    | TargetJira
    | TargetPivotal
    | TargetTwitter
    | TargetURL
    | TargetHTTP
    | TargetYammer
  );

export type TargetPivotal = {
  owner_by?: string;
  project_id: string;
  requested_by?: string;
  story_labels?: string;
  story_title: string;
  story_type: string;
  token: string;
};

export type TargetResponse = {
  target?: TargetObject;
};

export type TargetTwitter = {
  /**
   * only writable
   */
  secret?: string;
  token?: string;
};

export type TargetURL = {
  attribute: string;
  /**
   * "get"
   */
  method?: string;
  /**
   * only writable
   */
  password?: string;
  target_url: string;
  username?: string;
};

export type TargetYammer = {
  group_id?: string;
  token?: string;
};

export type TargetsResponse = {
  targets?: Array<TargetObject>;
};

export type TicketAuditObject = {
  /**
   * The user who created the audit
   */
  readonly author_id?: number;
  /**
   * The time the audit was created
   */
  readonly created_at?: string;
  /**
   * An array of the events that happened in this audit. See the [Ticket Audit events reference](/documentation/ticketing/reference-guides/ticket-audit-events-reference)
   */
  events?: Array<{
    [key: string]: unknown;
  }>;
  /**
   * Automatically assigned when creating audits
   */
  readonly id?: number;
  /**
   * Metadata for the audit, custom and system data
   */
  readonly metadata?: {
    [key: string]: unknown;
  };
  /**
   * The ID of the associated ticket
   */
  readonly ticket_id?: number;
  via?: TicketAuditViaObject;
};

export type TicketAuditResponse = {
  audit?: TicketAuditObject;
};

/**
 * Describes how the object was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)
 */
export type TicketAuditViaObject = {
  /**
   * This tells you how the ticket or event was created. Examples: "web", "mobile", "rule", "system"
   */
  readonly channel?: string;
  /**
   * For some channels a source object gives more information about how or why the ticket or event was created
   */
  readonly source?: {
    [key: string]: unknown;
  };
};

export type TicketAuditsCountResponse = {
  count?: {
    refreshed_at?: string;
    value?: number;
  };
};

export type TicketAuditsResponse = {
  readonly after_cursor?: string;
  readonly after_url?: string;
  audits?: Array<TicketAuditObject>;
  readonly before_cursor?: string;
  readonly before_url?: string;
};

export type TicketAuditsResponseNoneCursor = {
  audits?: Array<TicketAuditObject>;
  readonly count?: number;
  readonly next_page?: string | null;
  readonly previous_page?: string | null;
};

export type TicketBulkImportRequest = {
  tickets?: Array<TicketImportInput>;
};

export type TicketChatCommentRedactionResponse = {
  /**
   * Chat event object
   */
  readonly chat_event?: {
    /**
     * Id assigned to the chat event object
     */
    readonly id?: number;
    /**
     * Type of chat event
     */
    readonly type?: string;
    /**
     * The value of the chat event object
     */
    readonly value?: {
      /**
       * Id of the chat session
       */
      readonly chat_id?: string;
      /**
       * Chat events within the chat session
       */
      history?: Array<{
        [key: string]: unknown;
      }>;
      /**
       * Id assigned to the visitor
       */
      readonly visitor_id?: string;
    };
  };
};

export type TicketCommentObject = {
  /**
   * Attachments, if any. See [Attachment](/api-reference/ticketing/tickets/ticket-attachments/)
   */
  readonly attachments?: Array<AttachmentObject>;
  /**
   * The id of the ticket audit record. See [Show Audit](/api-reference/ticketing/tickets/ticket_audits/#show-audit)
   */
  readonly audit_id?: number;
  /**
   * The id of the comment author. See [Author id](#author-id)
   */
  author_id?: number;
  /**
   * The comment string. See [Bodies](#bodies)
   */
  body?: string;
  /**
   * The time the comment was created
   */
  readonly created_at?: string;
  /**
   * The comment formatted as HTML. See [Bodies](#bodies)
   */
  html_body?: string;
  /**
   * Automatically assigned when the comment is created
   */
  readonly id?: number;
  /**
   * System information (web client, IP address, etc.) and comment flags, if any. See [Comment flags](#comment-flags)
   */
  readonly metadata?: {
    [key: string]: unknown;
  };
  /**
   * The comment presented as plain text. See [Bodies](#bodies)
   */
  readonly plain_body?: string;
  /**
   * true if a public comment; false if an internal note. The initial value set on ticket creation persists for any additional comment unless you change it
   */
  public?: boolean;
  /**
   * `Comment` or `VoiceComment`. The JSON object for adding voice comments to tickets is different. See [Adding voice comments to tickets](/documentation/ticketing/managing-tickets/adding-voice-comments-to-tickets)
   */
  readonly type?: string;
  /**
   * List of tokens received from [uploading files](/api-reference/ticketing/tickets/ticket-attachments/#upload-files) for comment attachments. The files are attached by creating or updating tickets with the tokens. See [Attaching files](/api-reference/ticketing/tickets/tickets/#attaching-files) in Tickets
   */
  uploads?: Array<string>;
  via?: TicketAuditViaObject;
};

export type TicketCommentResponse = {
  comment?: TicketCommentObject;
};

export type TicketCommentsCountResponse = {
  count?: {
    refreshed_at?: string;
    value?: number;
  };
};

export type TicketCommentsResponse = {
  comments?: Array<TicketCommentObject>;
};

export type TicketCreateInput = TicketUpdateInput & {
  /**
   * Enterprise only. The id of the brand this ticket is associated with
   */
  brand_id?: number;
  /**
   * POST requests only. Users to add as cc's when creating a ticket. See [Setting Collaborators](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-collaborators)
   */
  collaborators?: Array<CollaboratorObject>;
  /**
   * The ids of agents or end users currently CC'ed on the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233) in the Support Help Center
   */
  email_cc_ids?: Array<number>;
  /**
   * The ids of agents currently following the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233)
   */
  follower_ids?: Array<number>;
  /**
   * POST requests only. List of macro IDs to be recorded in the ticket audit
   */
  macro_ids?: Array<number>;
  /**
   * The dynamic content placeholder, if present, or the "subject" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   *
   */
  raw_subject?: string;
  /**
   * The original recipient e-mail address of the ticket
   */
  recipient?: string;
  /**
   * The user who submitted the ticket. The submitter always becomes the author of the first comment on the ticket
   */
  submitter_id?: number;
  /**
   * Enterprise only. The id of the ticket form to render for the ticket
   */
  ticket_form_id?: number;
  via?: ViaObject;
  /**
   * POST requests only. The id of a closed ticket when creating a follow-up ticket. See [Creating a follow-up ticket](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#creating-a-follow-up-ticket)
   */
  via_followup_source_id?: number;
};

export type TicketCreateRequest = {
  ticket?: TicketCreateInput;
};

export type TicketCreateVoicemailTicketInput = {
  comment?: TicketCommentObject;
  /**
   * The urgency with which the ticket should be addressed.
   */
  priority?: 'urgent' | 'high' | 'normal' | 'low';
  /**
   * Required for Create Ticket operation
   */
  via_id?: 44 | 45 | 46;
  /**
   * Required if creating voicemail ticket
   */
  voice_comment?: TicketCreateVoicemailTicketVoiceCommentInput;
};

/**
 * The urgency with which the ticket should be addressed.
 */
export type priority = 'urgent' | 'high' | 'normal' | 'low';

/**
 * Required for Create Ticket operation
 */
export type via_id = 44 | 45 | 46;

export type TicketCreateVoicemailTicketRequest = {
  /**
   * Optional value such as the ID of the agent that will see the newly created ticket.
   */
  display_to_agent?: number;
  /**
   * Ticket object that lists the values to set when the ticket is created
   */
  ticket?: TicketCreateVoicemailTicketInput;
};

export type TicketCreateVoicemailTicketVoiceCommentInput = {
  /**
   * The agent who answered the call
   */
  answered_by_id?: number;
  /**
   * Duration in seconds of the call
   */
  call_duration?: number;
  /**
   * Incoming phone number
   */
  from?: string;
  /**
   * Location of the caller (optional)
   */
  location?: string;
  /**
   * Incoming phone number
   */
  recording_url?: string;
  /**
   * [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp of the call starting time
   */
  started_at?: string;
  /**
   * Dialed phone number
   */
  to?: string;
  /**
   * Transcription of the call (optional)
   */
  transcription_text?: string;
};

export type TicketFieldCountResponse = {
  count?: {
    refreshed_at?: string;
    value?: number;
  };
};

export type TicketFieldCustomStatusObject = {
  /**
   * If true, if the custom status is set to active. If false, the custom status is set to inactive
   */
  active?: boolean;
  /**
   * The label displayed to agents
   */
  agent_label?: string;
  /**
   * The date and time at which the custom ticket status was created
   */
  readonly created_at?: string;
  /**
   * If true, the custom status is set to default. If false, the custom status is set to non-default
   */
  default?: boolean;
  /**
   * The description of when the user should select this custom ticket status
   */
  description?: string;
  /**
   * The description displayed to end users
   */
  end_user_description?: string;
  /**
   * The label displayed to end users
   */
  end_user_label?: string;
  /**
   * Automatically assigned when the custom ticket status is created
   */
  readonly id?: number;
  /**
   * The status category the custom ticket status belongs to
   */
  status_category?: 'new' | 'open' | 'pending' | 'hold' | 'solved';
  /**
   * The date and time at which the custom ticket status was last updated
   */
  readonly updated_at?: string;
};

export type TicketFieldObject = {
  /**
   * Whether this field is available
   */
  active?: boolean;
  /**
   * A description of the ticket field that only agents can see
   */
  agent_description?: string;
  /**
   * If true, the field is shown to agents by default. If false, the field is hidden alongside infrequently used fields. Classic interface only
   */
  collapsed_for_agents?: boolean;
  /**
   * The time the custom ticket field was created
   */
  readonly created_at?: string;
  /**
   * Name of the app that created the ticket field, or a null value if no app created the ticket field
   */
  creator_app_name?: string;
  /**
   * The id of the user that created the ticket field, or a value of "-1" if an app created the ticket field
   */
  creator_user_id?: number;
  /**
   * Required and presented for a custom ticket field of type "multiselect" or "tagger"
   */
  custom_field_options?: Array<CustomFieldOptionObject>;
  /**
   * List of customized ticket statuses. Only presented for a system ticket field of type "custom_status"
   */
  readonly custom_statuses?: Array<TicketFieldCustomStatusObject>;
  /**
   * Describes the purpose of the ticket field to users
   */
  description?: string;
  /**
   * Whether this field is editable by end users in Help Center
   */
  editable_in_portal?: boolean;
  /**
   * Automatically assigned when created
   */
  readonly id?: number;
  /**
   * The relative position of the ticket field on a ticket. Note that for accounts with ticket forms, positions are controlled by the different forms
   */
  position?: number;
  /**
   * The dynamic content placeholder if present, or the `description` value if not. See [Dynamic Content](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  raw_description?: string;
  /**
   * The dynamic content placeholder if present, or the `title` value if not. See [Dynamic Content](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  raw_title?: string;
  /**
   * The dynamic content placeholder if present, or the "title_in_portal" value if not. See [Dynamic Content](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  raw_title_in_portal?: string;
  /**
   * For "regexp" fields only. The validation pattern for a field value to be deemed valid
   */
  regexp_for_validation?: string | null;
  /**
   * A filter definition that allows your autocomplete to filter down results
   */
  relationship_filter?: {
    [key: string]: unknown;
  };
  /**
   * A representation of what type of object the field references. Options are "zen:user", "zen:organization", "zen:ticket", or "zen:custom_object:{key}" where key is a custom object key. For example "zen:custom_object:apartment".
   */
  relationship_target_type?: string;
  /**
   * If false, this field is a system field that must be present on all tickets
   */
  readonly removable?: boolean;
  /**
   * If true, agents must enter a value in the field to change the ticket status to solved
   */
  required?: boolean;
  /**
   * If true, end users must enter a value in the field to create the request
   */
  required_in_portal?: boolean;
  /**
   * For system ticket fields of type "priority" and "status". Defaults to 0. A "priority" sub type of 1 removes the "Low" and "Urgent" options. A "status" sub type of 1 adds the "On-Hold" option
   */
  sub_type_id?: number;
  /**
   * Presented for a system ticket field of type "tickettype", "priority" or "status"
   */
  readonly system_field_options?: Array<SystemFieldOptionObject>;
  /**
   * For "checkbox" fields only. A tag added to tickets when the checkbox field is selected
   */
  tag?: string | null;
  /**
   * The title of the ticket field
   */
  title: string;
  /**
   * The title of the ticket field for end users in Help Center
   */
  title_in_portal?: string;
  /**
   * System or custom field type. Editable for custom field types and only on creation. See [Create Ticket Field](#create-ticket-field)
   */
  type: string;
  /**
   * The time the custom ticket field was last updated
   */
  readonly updated_at?: string;
  /**
   * The URL for this resource
   */
  readonly url?: string;
  /**
   * Whether this field is visible to end users in Help Center
   */
  visible_in_portal?: boolean;
};

export type TicketFieldResponse = {
  ticket_field?: TicketFieldObject;
};

export type TicketFieldsResponse = {
  ticket_fields?: Array<TicketFieldObject>;
};

export type TicketFormObject = {
  /**
   * If the form is set as active
   */
  active?: boolean;
  /**
   * Array of condition sets for agent workspaces
   */
  agent_conditions?: Array<{
    [key: string]: unknown;
  }>;
  /**
   * The time the ticket form was created
   */
  readonly created_at?: string;
  /**
   * Is the form the default form for this account
   */
  default?: boolean;
  /**
   * The name of the form that is displayed to an end user
   */
  display_name?: string;
  /**
   * Array of condition sets for end user products
   */
  end_user_conditions?: Array<{
    [key: string]: unknown;
  }>;
  /**
   * Is the form visible to the end user
   */
  end_user_visible?: boolean;
  /**
   * Automatically assigned when creating ticket form
   */
  readonly id?: number;
  /**
   * Is the form available for use in all brands on this account
   */
  in_all_brands?: boolean;
  /**
   * The name of the form
   */
  name: string;
  /**
   * The position of this form among other forms in the account, i.e. dropdown
   */
  position?: number;
  /**
   * The dynamic content placeholder, if present, or the "display_name" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  raw_display_name?: string;
  /**
   * The dynamic content placeholder, if present, or the "name" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   */
  raw_name?: string;
  /**
   * ids of all brands that this ticket form is restricted to
   */
  readonly restricted_brand_ids?: Array<number>;
  /**
   * ids of all ticket fields which are in this ticket form. The products use the order of the ids to show the field values in the tickets
   */
  ticket_field_ids?: Array<number>;
  /**
   * The time of the last update of the ticket form
   */
  readonly updated_at?: string;
  /**
   * URL of the ticket form
   */
  readonly url?: string;
};

export type TicketFormResponse = {
  ticket_form?: TicketFormObject;
};

export type TicketFormsResponse = {
  ticket_forms?: Array<TicketFormObject>;
};

export type TicketImportInput = {
  /**
   * The agent currently assigned to the ticket
   */
  assignee_id?: number;
  /**
   * The conversation between requesters, collaborators, and agents
   */
  comments?: Array<
    {
      /**
       * The comment string value
       */
      value?: string;
    } & TicketCommentObject
  >;
  /**
   * Read-only first comment on the ticket. When [creating a ticket](#create-ticket), use `comment` to set the description. See [Description and first comment](#description-and-first-comment)
   */
  description?: string;
  /**
   * The user who requested this ticket
   */
  requester_id?: number;
  /**
   * The value of the subject field for this ticket
   */
  subject?: string;
  /**
   * The array of tags applied to this ticket
   */
  tags?: Array<string>;
};

export type TicketImportRequest = {
  ticket?: TicketImportInput;
};

export type TicketMergeInput = {
  /**
   * Ids of tickets to merge into the target ticket
   */
  ids: Array<number>;
  /**
   * Private comment to add to the source ticket
   */
  source_comment?: string;
  /**
   * Whether comment in source tickets are public or private
   */
  source_comment_is_public?: boolean;
  /**
   * Private comment to add to the target ticket
   */
  target_comment?: string;
  /**
   * Whether comment in target ticket is public or private
   */
  target_comment_is_public?: boolean;
};

export type TicketMetricEventBaseObject = {
  /**
   * Automatically assigned when the record is created
   */
  readonly id?: number;
  /**
   * The instance of the metric associated with the event. See [instance_id](#instance_id)
   */
  readonly instance_id?: number;
  /**
   * The metric being tracked
   */
  readonly metric?:
    | 'agent_work_time'
    | 'pausable_update_time'
    | 'periodic_update_time'
    | 'reply_time'
    | 'requester_wait_time'
    | 'resolution_time'
    | 'group_ownership_time';
  /**
   * Id of the associated ticket
   */
  readonly ticket_id?: number;
  /**
   * The time the event occurred
   */
  readonly time?: string;
  /**
   * The type of the metric event. See [Ticket metric event types reference](/documentation/ticketing/reference-guides/ticket-metric-event-types-reference)
   */
  readonly type?:
    | 'activate'
    | 'pause'
    | 'fulfill'
    | 'apply_sla'
    | 'apply_group_sla'
    | 'breach'
    | 'update_status'
    | 'measure';
};

/**
 * The metric being tracked
 */
export type metric =
  | 'agent_work_time'
  | 'pausable_update_time'
  | 'periodic_update_time'
  | 'reply_time'
  | 'requester_wait_time'
  | 'resolution_time'
  | 'group_ownership_time';

/**
 * The type of the metric event. See [Ticket metric event types reference](/documentation/ticketing/reference-guides/ticket-metric-event-types-reference)
 */
export type type =
  | 'activate'
  | 'pause'
  | 'fulfill'
  | 'apply_sla'
  | 'apply_group_sla'
  | 'breach'
  | 'update_status'
  | 'measure';

export type TicketMetricEventBreachObject = TicketMetricEventBaseObject & {
  /**
   * Available if `type` is `breach`. In general, you can ignore any breach event when `deleted` is true. See [deleted](#deleted)
   */
  readonly deleted?: boolean;
};

export type TicketMetricEventGroupSLAObject = TicketMetricEventBaseObject & {
  /**
   * Available if `type` is "apply_group_sla". The Group SLA policy and target being enforced on the ticket and metric in question, if any. See [group_sla](#group_sla)
   */
  readonly group_sla?: {
    [key: string]: unknown;
  };
};

export type TicketMetricEventSLAObject = TicketMetricEventBaseObject & {
  /**
   * Available if `type` is `apply_sla`. The SLA policy and target being enforced on the ticket and metric in question, if any. See [sla](#sla)
   */
  readonly sla?: {
    [key: string]: unknown;
  };
};

export type TicketMetricEventUpdateStatusObject = TicketMetricEventBaseObject & {
  /**
   * Available if `type` is `update_status`. Minutes since the metric has been open. See [status](#status)
   */
  readonly status?: {
    [key: string]: unknown;
  };
};

export type TicketMetricEventsResponse = {
  ticket_metric_events?: Array<TicketMetricEventBaseObject>;
} & {
  count?: number;
  end_time?: number;
  next_page?: string;
};

export type TicketMetricObject = {
  /**
   * Number of minutes the agent spent waiting during calendar and business hours
   */
  readonly agent_wait_time_in_minutes?: TicketMetricTimeObject;
  /**
   * When the ticket was assigned
   */
  readonly assigned_at?: string;
  /**
   * Number of assignees the ticket had
   */
  readonly assignee_stations?: number;
  /**
   * When the assignee last updated the ticket
   */
  readonly assignee_updated_at?: string;
  /**
   * When the record was created
   */
  readonly created_at?: string;
  /**
   * The date and time the ticket's custom status was last updated
   */
  readonly custom_status_updated_at?: string;
  /**
   * Number of minutes to the first resolution time during calendar and business hours
   */
  readonly first_resolution_time_in_minutes?: TicketMetricTimeObject;
  /**
   * Number of minutes to the full resolution during calendar and business hours
   */
  readonly full_resolution_time_in_minutes?: TicketMetricTimeObject;
  /**
   * Number of groups the ticket passed through
   */
  readonly group_stations?: number;
  /**
   * Automatically assigned when the client is created
   */
  readonly id?: number;
  /**
   * When the ticket was initially assigned
   */
  readonly initially_assigned_at?: string;
  /**
   * When the latest comment was added
   */
  readonly latest_comment_added_at?: string;
  /**
   * Number of minutes on hold
   */
  readonly on_hold_time_in_minutes?: TicketMetricTimeObject;
  /**
   * Total number of times the ticket was reopened
   */
  readonly reopens?: number;
  /**
   * The number of public replies added to a ticket by an agent
   */
  readonly replies?: number;
  /**
   * Number of minutes to the first reply during calendar and business hours
   */
  readonly reply_time_in_minutes?: TicketMetricTimeObject;
  /**
   * Number of seconds to the first reply during calendar hours, only available for Messaging tickets
   */
  readonly reply_time_in_seconds?: TicketMetricTimeObject;
  /**
   * When the requester last updated the ticket
   */
  readonly requester_updated_at?: string;
  /**
   * Number of minutes the requester spent waiting during calendar and business hours
   */
  readonly requester_wait_time_in_minutes?: TicketMetricTimeObject;
  /**
   * When the ticket was solved
   */
  readonly solved_at?: string;
  /**
   * When the status of the ticket was last updated
   */
  readonly status_updated_at?: string;
  /**
   * Id of the associated ticket
   */
  readonly ticket_id?: number;
  /**
   * When the record was last updated
   */
  readonly updated_at?: string;
  /**
   * The API url of the ticket metric
   */
  readonly url?: string;
};

export type TicketMetricTimeObject = {
  /**
   * Time in business hours
   */
  readonly business?: number;
  /**
   * Time in calendar hours
   */
  readonly calendar?: number;
};

export type TicketMetricsByTicketMetricIdResponse = {
  ticket_metric?: Array<TicketMetricObject>;
};

export type TicketMetricsResponse = {
  ticket_metrics?: Array<TicketMetricObject>;
};

export type TicketObject = {
  /**
   * Permission for agents to add add attachments to a comment. Defaults to true
   */
  readonly allow_attachments?: boolean;
  /**
   * Is false if channelback is disabled, true otherwise. Only applicable for channels framework ticket
   */
  readonly allow_channelback?: boolean;
  /**
   * Write only. The email address of the agent to assign the ticket to
   */
  assignee_email?: string;
  /**
   * The agent currently assigned to the ticket
   */
  assignee_id?: number;
  /**
   * Write only. An array of the IDs of attribute values to be associated with the ticket
   */
  attribute_value_ids?: Array<number>;
  /**
   * The id of the brand this ticket is associated with. See [Setting up multiple brands](https://support.zendesk.com/hc/en-us/articles/4408829476378)
   */
  brand_id?: number;
  /**
   * The ids of users currently CC'ed on the ticket
   */
  collaborator_ids?: Array<number>;
  /**
   * POST requests only. Users to add as cc's when creating a ticket. See [Setting Collaborators](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-collaborators)
   */
  collaborators?: Array<CollaboratorObject>;
  /**
   * Write only. An object that adds a comment to the ticket. See [Ticket comments](/api-reference/ticketing/tickets/ticket_comments/). To include an attachment with the comment, see [Attaching files](/documentation/ticketing/managing-tickets/creating-and-updating-tickets/#attaching-files). A ticket can contain up to 5000 comments in total, including both public and private comments. Once this limit is reached, any additional attempts to add comments results in a 422 error. The ticket can still be updated in other ways, provided that no new comments are added.
   */
  comment?: {
    [key: string]: unknown;
  };
  /**
   * When this record was created
   */
  readonly created_at?: string;
  /**
   * Custom fields for the ticket. See [Setting custom field values](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-custom-field-values)
   */
  custom_fields?: Array<{
    /**
     * The id of the custom field
     */
    id?: number;
    /**
     * The value of the custom field
     */
    value?: string;
  }>;
  /**
   * The custom ticket status id of the ticket. See [custom ticket statuses](#custom-ticket-statuses)
   */
  custom_status_id?: number;
  /**
   * Read-only first comment on the ticket. When [creating a ticket](#create-ticket), use `comment` to set the description. See [Description and first comment](#description-and-first-comment)
   *
   */
  readonly description?: string;
  /**
   * If this is a ticket of type "task" it has a due date.  Due date format uses [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format
   */
  due_at?: string | null;
  /**
   * The ids of agents or end users currently CC'ed on the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233) in the Support Help Center
   */
  email_cc_ids?: Array<number>;
  /**
   * Write only. An array of objects that represent agent or end users email CCs to add or delete from the ticket. See [Setting email CCs](/documentation/ticketing/managing-tickets/creating-and-updating-tickets/#setting-email-ccs)
   */
  email_ccs?: {
    [key: string]: unknown;
  };
  /**
   * An id you can use to link Zendesk Support tickets to local records
   */
  external_id?: string;
  /**
   * The ids of agents currently following the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233)
   */
  follower_ids?: Array<number>;
  /**
   * Write only. An array of objects that represent agent followers to add or delete from the ticket. See [Setting followers](/documentation/ticketing/managing-tickets/creating-and-updating-tickets/#setting-followers)
   */
  followers?: {
    [key: string]: unknown;
  };
  /**
   * The ids of the followups created from this ticket. Ids are only visible once the ticket is closed
   */
  readonly followup_ids?: Array<number>;
  /**
   * The topic in the Zendesk Web portal this ticket originated from, if any. The Web portal is deprecated
   */
  readonly forum_topic_id?: number;
  /**
   * If true, the ticket's [via type](/documentation/ticketing/reference-guides/via-object-reference/) is a messaging channel.
   */
  readonly from_messaging_channel?: boolean;
  /**
   * A Unix timestamp that represents the most accurate reading of when this record was last updated. It is updated for all ticket updates, including system updates
   */
  readonly generated_timestamp?: number;
  /**
   * The group this ticket is assigned to
   */
  group_id?: number;
  /**
   * Is true if a ticket is a problem type and has one or more incidents linked to it. Otherwise, the value is false.
   */
  readonly has_incidents?: boolean;
  /**
   * Automatically assigned when the ticket is created
   */
  readonly id?: number;
  /**
   * Is true if any comments are public, false otherwise
   */
  readonly is_public?: boolean;
  /**
   * Write only. A macro ID to be recorded in the ticket audit
   */
  macro_id?: number;
  /**
   * POST requests only. List of macro IDs to be recorded in the ticket audit
   */
  macro_ids?: Array<number>;
  /**
   * Write only. Metadata for the audit. In the `audit` object, the data is specified in the `custom` property of the `metadata` object. See [Setting Metadata](/documentation/ticketing/managing-tickets/creating-and-updating-tickets/#setting-metadata)
   */
  metadata?: {
    [key: string]: unknown;
  };
  /**
   * The organization of the requester. You can only specify the ID of an organization associated with the requester. See [Organization Memberships](/api-reference/ticketing/organizations/organization_memberships/)
   */
  organization_id?: number;
  /**
   * The urgency with which the ticket should be addressed
   */
  priority?: 'urgent' | 'high' | 'normal' | 'low';
  /**
   * For tickets of type "incident", the ID of the problem the incident is linked to
   */
  problem_id?: number;
  /**
   * The dynamic content placeholder, if present, or the "subject" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
   *
   */
  raw_subject?: string;
  /**
   * The original recipient e-mail address of the ticket. Notification emails for the ticket are sent from this address
   */
  recipient?: string;
  /**
   * Write only. See [Creating a ticket with a new requester](/documentation/ticketing/managing-tickets/creating-and-updating-tickets/#creating-a-ticket-with-a-new-requester)
   */
  requester?: {
    [key: string]: unknown;
  };
  /**
   * The user who requested this ticket
   */
  requester_id: number;
  /**
   * Write only. Optional boolean. When true and an `update_stamp` date is included, protects against ticket update collisions and returns a message to let you know if one occurs. See [Protecting against ticket update collisions](/documentation/ticketing/managing-tickets/creating-and-updating-tickets/#protecting-against-ticket-update-collisions). A value of false has the same effect as true. Omit the property to force the updates to not be safe
   */
  safe_update?: boolean;
  /**
   * The satisfaction rating of the ticket, if it exists, or the state of satisfaction, "offered" or "unoffered". The value is null for plan types that don't support CSAT
   */
  readonly satisfaction_rating?: {
    [key: string]: unknown;
  };
  /**
   * The ids of the sharing agreements used for this ticket
   */
  sharing_agreement_ids?: Array<number>;
  /**
   * The state of the ticket.
   *
   * If your account has activated custom ticket statuses, this is the ticket's
   * status category. See [custom ticket statuses](#custom-ticket-statuses)
   *
   */
  status?: 'new' | 'open' | 'pending' | 'hold' | 'solved' | 'closed';
  /**
   * The value of the subject field for this ticket. See [Subject](/api-reference/ticketing/tickets/tickets/#subject)
   *
   */
  subject?: string;
  /**
   * The user who submitted the ticket. The submitter always becomes the author of the first comment on the ticket
   */
  submitter_id?: number;
  /**
   * The array of tags applied to this ticket. Unless otherwise specified, the [set tag](/api-reference/ticketing/ticket-management/tags/#set-tags) behavior is used, which overwrites and replaces existing tags
   */
  tags?: Array<string>;
  /**
   * Enterprise only. The id of the ticket form to render for the ticket
   */
  ticket_form_id?: number;
  /**
   * The type of this ticket
   */
  type?: 'problem' | 'incident' | 'question' | 'task';
  /**
   * When this record last got updated. It is updated only if the update generates a [ticket event](#incremental-ticket-event-export)
   */
  readonly updated_at?: string;
  /**
   * Write only. Datetime of last update received from API. See the `safe_update` property
   */
  updated_stamp?: string;
  /**
   * The API url of this ticket
   */
  readonly url?: string;
  /**
   * For more information, see the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)
   */
  via?: {
    /**
     * This tells you how the ticket or event was created. Examples: "web", "mobile", "rule", "system"
     *
     */
    channel?: string;
    /**
     * For some channels a source object gives more information about how or why the ticket or event was created
     *
     */
    source?: {
      [key: string]: unknown;
    };
  };
  /**
   * POST requests only. The id of a closed ticket when creating a follow-up ticket. See [Creating a follow-up ticket](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#creating-a-follow-up-ticket)
   */
  via_followup_source_id?: number;
  /**
   * Write only. For more information, see the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference/)
   */
  via_id?: number;
  /**
   * Write only. See [Creating voicemail ticket](/api-reference/voice/talk-partner-edition-api/reference/#creating-voicemail-tickets)
   */
  voice_comment?: {
    [key: string]: unknown;
  };
};

/**
 * The state of the ticket.
 *
 * If your account has activated custom ticket statuses, this is the ticket's
 * status category. See [custom ticket statuses](#custom-ticket-statuses)
 *
 */
export type status3 = 'new' | 'open' | 'pending' | 'hold' | 'solved' | 'closed';

/**
 * The type of this ticket
 */
export type type2 = 'problem' | 'incident' | 'question' | 'task';

export type TicketRelatedInformation = {
  followup_source_ids?: Array<string>;
  /**
   * Is true if the current ticket is archived
   */
  from_archive?: boolean;
  /**
   * A count of related incident occurrences
   */
  incidents?: number;
  jira_issue_ids?: Array<string>;
  /**
   * Related topic in the Web portal (deprecated feature)
   */
  topic_id?: string | null;
};

export type TicketResponse = {
  ticket?: TicketObject;
};

export type TicketSkipCreation = {
  skip?: TicketSkipObject;
};

export type TicketSkipObject = {
  /**
   * Time the skip was created
   */
  readonly created_at?: string;
  /**
   * Automatically assigned upon creation
   */
  readonly id?: number;
  /**
   * Reason for skipping the ticket
   */
  readonly reason?: string;
  /**
   * The skipped ticket. See the [Ticket object reference](/api-reference/ticketing/tickets/tickets/#json-format)
   */
  ticket?: TicketObject;
  /**
   * ID of the skipped ticket
   */
  readonly ticket_id?: number;
  /**
   * Time the skip was last updated
   */
  readonly updated_at?: string;
  /**
   * ID of the skipping agent
   */
  readonly user_id?: number;
};

export type TicketSkipsResponse = {
  skips?: Array<TicketSkipObject>;
};

export type TicketUpdateInput = {
  /**
   * An array of numeric IDs, emails, or objects containing name and email properties. See [Setting Collaborators](/api-reference/ticketing/tickets/tickets/#setting-collaborators). An email notification is sent to them when the ticket is updated
   */
  additional_collaborators?: Array<CollaboratorObject>;
  /**
   * The email address of the agent to assign the ticket to
   */
  assignee_email?: string;
  /**
   * The agent currently assigned to the ticket
   */
  assignee_id?: number;
  /**
   * An array of the IDs of attribute values to be associated with the ticket
   */
  attribute_value_ids?: Array<number>;
  /**
   * The ids of users currently CC'ed on the ticket
   */
  collaborator_ids?: Array<number>;
  comment?: TicketCommentObject;
  /**
   * Custom fields for the ticket. See [Setting custom field values](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-custom-field-values)
   */
  custom_fields?: Array<CustomFieldObject>;
  /**
   * The custom ticket status id of the ticket. See [custom ticket statuses](#custom-ticket-statuses)
   */
  custom_status_id?: number;
  /**
   * If this is a ticket of type "task" it has a due date.  Due date format uses [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
   */
  due_at?: string | null;
  /**
   * An array of objects that represent agent or end users email CCs to add or delete from the ticket. See [Setting email CCs](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-email-ccs)
   */
  email_ccs?: Array<EmailCCObject>;
  /**
   * An id you can use to link Zendesk Support tickets to local records
   */
  external_id?: string;
  /**
   * An array of objects that represent agent followers to add or delete from the ticket. See [Setting followers](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-followers)
   */
  followers?: Array<FollowerObject>;
  /**
   * The group this ticket is assigned to
   */
  group_id?: number;
  /**
   * The organization of the requester. You can only specify the ID of an organization associated with the requester. See [Organization Memberships](/api-reference/ticketing/organizations/organization_memberships/)
   */
  organization_id?: number;
  /**
   * The urgency with which the ticket should be addressed.
   */
  priority?: 'urgent' | 'high' | 'normal' | 'low';
  /**
   * For tickets of type "incident", the ID of the problem the incident is linked to
   */
  problem_id?: number;
  /**
   * The user who requested this ticket
   */
  requester_id?: number;
  /**
   * Optional boolean. Prevents updates with outdated ticket data (`updated_stamp` property required when true)
   */
  safe_update?: boolean;
  /**
   * An array of the numeric IDs of sharing agreements. Note that this replaces any existing agreements
   */
  sharing_agreement_ids?: Array<number>;
  /**
   * The state of the ticket.
   *
   * If your account has activated custom ticket statuses, this is the ticket's
   * status category. See [custom ticket statuses](#custom-ticket-statuses).
   *
   */
  status?: 'new' | 'open' | 'pending' | 'hold' | 'solved' | 'closed';
  /**
   * The value of the subject field for this ticket
   */
  subject?: string;
  /**
   * The array of tags applied to this ticket
   */
  tags?: Array<string>;
  /**
   * The type of this ticket.
   */
  type?: 'problem' | 'incident' | 'question' | 'task';
  /**
   * Datetime of last update received from API. See the safe_update property
   */
  updated_stamp?: string;
};

export type TicketUpdateRequest = {
  ticket?: TicketUpdateInput;
};

export type TicketUpdateResponse = {
  audit?: AuditObject;
  ticket?: TicketObject;
};

export type TicketsCreateRequest = {
  tickets?: Array<TicketCreateInput>;
};

export type TicketsResponse = {
  tickets?: Array<TicketObject>;
};

/**
 * See [Tickets](/api-reference/ticketing/tickets/tickets/) for a detailed example.
 *
 */
export type TimeBasedExportIncrementalTicketsResponse = {
  count?: number;
  end_of_stream?: boolean;
  end_time?: number;
  next_page?: string | null;
  tickets?: Array<TicketObject>;
};

export type TimeBasedExportIncrementalUsersResponse = {
  count?: number;
  end_of_stream?: boolean;
  end_time?: number;
  next_page?: string | null;
  users?: Array<UserObject>;
};

export type TrialAccountObject = {
  /**
   * The name of the account
   */
  name?: string;
  /**
   * The subdomain of the account
   */
  subdomain?: string;
  /**
   * The URL of the account
   */
  url?: string;
};

export type TrialAccountResponse = {
  account?: TrialAccountObject;
};

export type TriggerActionDefinitionObject = {
  group?: string;
  nullable?: boolean;
  repeatable?: boolean;
  subject?: string;
  title?: string;
  type?: string;
  values?: Array<{
    enabled?: boolean;
    title?: string;
    value?: string;
  }>;
};

export type TriggerActionDiffObject = {
  /**
   * An array of [change](#change) objects.
   */
  field?: Array<TriggerChangeObject>;
  /**
   * An array of [change](#change) objects.
   */
  value?: Array<TriggerChangeObject>;
};

export type TriggerActionObject = {
  field?: string;
  value?: string | number | Array<string | number>;
};

export type TriggerBatchRequest = {
  active?: boolean;
  category_id?: string;
  id: string;
  position?: number;
};

export type TriggerBulkUpdateItem = {
  /**
   * The active status of the ticket trigger (true or false)
   */
  active?: boolean;
  /**
   * The ID of the new category the ticket trigger is to be moved to
   */
  category_id?: string;
  /**
   * The ID of the ticket trigger to update
   */
  id: number;
  /**
   * The new position of the ticket trigger
   */
  position?: number;
};

export type TriggerBulkUpdateRequest = {
  triggers?: Array<TriggerBulkUpdateItem>;
};

export type TriggerCategoriesResponse = {
  trigger_categories?: Array<TriggerCategory>;
};

export type TriggerCategory = {
  readonly created_at?: string;
  readonly id?: string;
  name?: string;
  position?: number;
  readonly updated_at?: string;
};

export type TriggerCategoryBatchRequest = {
  id: string;
  position: number;
};

export type TriggerCategoryId = string;

export type TriggerCategoryRequest = {
  name?: string;
  position?: number;
};

export type TriggerCategoryRequestRequired = {
  [key: string]: unknown;
};

export type TriggerCategoryResponse = {
  trigger_category?: TriggerCategory;
};

export type TriggerCategoryRuleCounts = {
  active_count?: number;
  inactive_count?: number;
};

export type TriggerChangeObject = {
  /**
   * One of `-`, `+`, `=` representing the type of change
   */
  change?: string;
  /**
   * The value of the item it represents
   */
  content?: boolean | string | number | Array<string | number | boolean>;
};

export type TriggerConditionDefinitionObjectAll = {
  group?: string;
  nullable?: boolean;
  operators?: Array<{
    terminal?: boolean;
    title?: string;
    value?: string;
  }>;
  repeatable?: boolean;
  subject?: string;
  title?: string;
  type?: string;
  values?: Array<{
    enabled?: boolean;
    title?: string;
    value?: string;
  }>;
};

export type TriggerConditionDefinitionObjectAny = {
  group?: string;
  nullable?: boolean;
  operators?: Array<{
    terminal?: boolean;
    title?: string;
    value?: string;
  }>;
  repeatable?: boolean;
  subject?: string;
  title?: string;
  type?: string;
};

export type TriggerConditionDiffObject = {
  /**
   * An array of [change](#change) objects
   */
  field?: Array<TriggerChangeObject>;
  /**
   * An array of [change](#change) objects
   */
  operator?: Array<TriggerChangeObject>;
  /**
   * An array of [change](#change) objects
   */
  value?: Array<TriggerChangeObject>;
};

export type TriggerConditionObject = {
  field?: string;
  operator?: string;
  value?: string | number | Array<string | number>;
};

export type TriggerConditionsDiffObject = {
  all?: Array<TriggerConditionDiffObject> | null;
  any?: Array<TriggerConditionDiffObject> | null;
};

/**
 * An object that describes the circumstances under which the trigger performs its actions. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)
 */
export type TriggerConditionsObject = {
  all?: Array<TriggerConditionObject> | null;
  any?: Array<TriggerConditionObject> | null;
};

export type TriggerDefinitionObject = {
  actions?: Array<TriggerActionDefinitionObject>;
  conditions_all?: Array<TriggerConditionDefinitionObjectAll>;
  conditions_any?: Array<TriggerConditionDefinitionObjectAny>;
};

export type TriggerDefinitionResponse = {
  definitions?: TriggerDefinitionObject;
};

export type TriggerObject = {
  /**
   * An array of actions describing what the ticket trigger will do. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)
   */
  actions: Array<TriggerActionObject>;
  /**
   * Whether the ticket trigger is active
   */
  active?: boolean;
  /**
   * The ID of the category the ticket trigger belongs to
   */
  category_id?: string;
  conditions: TriggerConditionsObject;
  /**
   * The time the ticket trigger was created
   */
  readonly created_at?: string;
  /**
   * If true, the ticket trigger is a standard trigger
   */
  readonly default?: boolean;
  /**
   * The description of the ticket trigger
   */
  description?: string;
  /**
   * Automatically assigned when created
   */
  readonly id?: number;
  /**
   * Position of the ticket trigger, determines the order they will execute in
   */
  position?: number;
  /**
   * The raw format of the title of the ticket trigger
   */
  raw_title?: string;
  /**
   * The title of the ticket trigger
   */
  title: string;
  /**
   * The time of the last update of the ticket trigger
   */
  readonly updated_at?: string;
  /**
   * The url of the ticket trigger
   */
  readonly url?: string;
};

export type TriggerResponse = {
  trigger?: TriggerObject;
};

export type TriggerRevisionResponse = {
  trigger_revision?: {
    author_id?: number;
    created_at?: string;
    id?: number;
    snapshot?: {
      actions?: Array<TriggerActionObject>;
      active?: boolean;
      conditions?: TriggerConditionsObject;
      description?: string | null;
      title?: string;
    };
    url?: string;
  };
};

export type TriggerRevisionsResponse = {
  after_cursor?: string;
  after_url?: string;
  before_cursor?: string;
  before_url?: string;
  count?: number;
  trigger_revisions?: Array<{
    author_id?: number;
    created_at?: string;
    diff?: {
      /**
       * An array that contain [action diff objects](#Action Diffs)
       */
      actions?: Array<TriggerActionDiffObject>;
      /**
       * An array of [change](#change) objects
       */
      active?: Array<TriggerChangeObject>;
      conditions?: TriggerConditionDiffObject;
      /**
       * An array of [change](#change) objects
       */
      description?: Array<TriggerChangeObject>;
      /**
       * ID of the source revision
       */
      source_id?: number;
      /**
       * ID of the target revision
       */
      target_id?: number;
      /**
       * An array of [change](#change) objects
       */
      title?: Array<TriggerChangeObject>;
    };
    id?: number;
    snapshot?: TriggerSnapshotObject;
    url?: string;
  }>;
};

export type TriggerSnapshotObject = {
  /**
   * An array of [Actions](#actions) describing what the ticket trigger will do
   */
  actions?: Array<TriggerActionObject>;
  /**
   * Whether the ticket trigger is active
   */
  active?: boolean;
  conditions?: TriggerConditionsObject;
  /**
   * The description of the ticket trigger
   */
  description?: string | null;
  /**
   * The title of the ticket trigger
   */
  title?: string;
};

export type TriggerWithCategoryRequest = {
  trigger?: TriggerObject & (TriggerCategory | TriggerCategoryId);
};

export type TriggersResponse = {
  count?: number;
  next_page?: string | null;
  previous_page?: string | null;
  triggers?: Array<TriggerObject>;
};

export type TwitterChannelObject = {
  /**
   * If replies are allowed for this handle
   */
  readonly allow_reply?: boolean;
  /**
   * The profile image url of the handle
   */
  readonly avatar_url?: string;
  /**
   * What brand the handle is associated with
   */
  readonly brand_id?: number;
  /**
   * If replies are allowed for this handle
   */
  readonly can_reply?: boolean;
  /**
   * The time the handle was created
   */
  readonly created_at?: string;
  /**
   * Automatically assigned upon creation
   */
  readonly id: number;
  /**
   * The profile name of the handle
   */
  readonly name?: string;
  /**
   * The X handle
   */
  readonly screen_name: string;
  /**
   * The country's code
   */
  readonly twitter_user_id: number;
  /**
   * The time of the last update of the handle
   */
  readonly updated_at?: string;
};

export type TwitterChannelResponse = {
  monitored_twitter_handle?: TwitterChannelObject;
};

export type TwitterChannelTwicketStatusResponse = {
  statuses?: Array<{
    favorited?: boolean;
    id?: number;
    retweeted?: boolean;
    user_followed?: boolean;
  }>;
};

export type TwitterChannelsResponse = {
  monitored_twitter_handles?: Array<TwitterChannelObject>;
};

export type UpdateResourceResult = {
  /**
   * the action the job attempted (`"action": "update"`)
   *
   */
  action: string;
  /**
   * the id of the resource the job attempted to update
   */
  id: number;
  /**
   * the status (`"status": "Updated"`)
   *
   */
  status: string;
  /**
   * whether the action was successful or not (`"success": true`)
   *
   */
  success: boolean;
};

export type UrlObject = {
  readonly url?: string;
};

export type UserCreateInput = {
  custom_role_id?: number;
  email: string;
  external_id?: string;
  identities?: Array<{
    type: string;
    value: string;
  }>;
  name: string;
  organization?: {
    name: string;
  };
  organization_id?: number;
  role?: string;
};

export type UserFieldObject = CustomFieldObject;

export type UserFieldResponse = {
  user_field?: UserFieldObject;
};

export type UserFieldsResponse = {
  /**
   * Total count of records retrieved
   */
  readonly count?: number;
  /**
   * URL of the next page
   */
  readonly next_page?: string | null;
  /**
   * URL of the previous page
   */
  readonly previous_page?: string | null;
  user_fields?: Array<UserFieldObject>;
};

export type UserForAdmin = {
  /**
   * false if the user has been deleted
   */
  readonly active?: boolean;
  /**
   * An alias displayed to end users
   */
  alias?: string;
  /**
   * Whether or not the user is a chat-only agent
   */
  readonly chat_only?: boolean;
  /**
   * The time the user was created
   */
  readonly created_at?: string;
  /**
   * A custom role if the user is an agent on the Enterprise plan or above
   */
  custom_role_id?: number | null;
  /**
   * The id of the user's default group
   */
  default_group_id?: number;
  /**
   * Any details you want to store about the user, such as an address
   */
  details?: string;
  /**
   * The user's primary email address. *Writeable on create only. On update, a secondary email is added. See [Email Address](#email-address)
   */
  email?: string;
  /**
   * A unique identifier from another system. The API treats the id as case insensitive. Example: "ian1" and "IAN1" are the same value.
   */
  external_id?: string | null;
  /**
   * The time zone for the user
   */
  readonly iana_time_zone?: string;
  /**
   * Automatically assigned when the user is created
   */
  readonly id?: number;
  /**
   * Last time the user signed in to Zendesk Support or made an API request
   * using an API token or basic authentication
   *
   */
  readonly last_login_at?: string;
  /**
   * The user's locale. A BCP-47 compliant tag for the locale. If both "locale" and "locale_id" are present on create or update, "locale_id" is ignored and only "locale" is used.
   */
  locale?: string;
  /**
   * The user's language identifier
   */
  locale_id?: number;
  /**
   * Designates whether the user has forum moderation capabilities
   */
  moderator?: boolean;
  /**
   * The user's name
   */
  name: string;
  /**
   * Any notes you want to store about the user
   */
  notes?: string;
  /**
   * true if the user can only create private comments
   */
  only_private_comments?: boolean;
  /**
   * The id of the user's organization. If the user has more than one [organization memberships](/api-reference/ticketing/organizations/organization_memberships/), the id of the user's default organization. If updating, see [Organization ID](#organization-id)
   */
  organization_id?: number | null;
  /**
   * The user's primary phone number. See [Phone Number](#phone-number) below
   */
  phone?: string | null;
  /**
   * The user's profile picture represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object
   */
  photo?: {
    [key: string]: unknown;
  } | null;
  /**
   * A URL pointing to the user's profile picture.
   */
  remote_photo_url?: string;
  /**
   * This parameter is inert and has no effect. It may be deprecated in the
   * future.
   *
   * Previously, this parameter determined whether a user could access a CSV
   * report in a legacy Guide dashboard. This dashboard has been removed. See
   * [Announcing Guide legacy reporting upgrade to
   * Explore](https://support.zendesk.com/hc/en-us/articles/4762263171610-Announcing-Guide-legacy-reporting-upgrade-to-Explore-)
   *
   */
  readonly report_csv?: boolean;
  /**
   * If the agent has any restrictions; false for admins and unrestricted agents, true for other agents
   */
  restricted_agent?: boolean;
  /**
   * The user's role. Possible values are "end-user", "agent", or "admin"
   */
  role?: string;
  /**
   * The user's role id. 0 for a custom agent, 1 for a light agent, 2 for a chat agent, 3 for a chat agent added to the Support account as a contributor ([Chat Phase 4](https://support.zendesk.com/hc/en-us/articles/360022365373#topic_djh_1zk_4fb)), 4 for an admin, and 5 for a billing admin
   */
  readonly role_type?: number | null;
  /**
   * If the user is shared from a different Zendesk Support instance. Ticket sharing accounts only
   */
  readonly shared?: boolean;
  /**
   * If the user is a shared agent from a different Zendesk Support instance. Ticket sharing accounts only
   */
  readonly shared_agent?: boolean;
  /**
   * Whether the `phone` number is shared or not. See [Phone Number](#phone-number) below
   */
  shared_phone_number?: boolean | null;
  /**
   * The user's signature. Only agents and admins can have signatures
   */
  signature?: string;
  /**
   * If the agent is suspended. Tickets from suspended users are also suspended, and these users cannot sign in to the end user portal
   */
  suspended?: boolean;
  /**
   * The user's tags. Only present if your account has user tagging enabled
   */
  tags?: Array<string>;
  /**
   * Specifies which tickets the user has access to. Possible values are: "organization", "groups", "assigned", "requested", null. "groups" and "assigned" are valid only for agents. If you pass an invalid value to an end user (for example, "groups"), they will be assigned to "requested", regardless of their previous access
   */
  ticket_restriction?: string | null;
  /**
   * The user's time zone. See [Time Zone](#time-zone)
   */
  time_zone?: string;
  /**
   * If two factor authentication is enabled
   */
  readonly two_factor_auth_enabled?: boolean | null;
  /**
   * The time the user was last updated
   */
  readonly updated_at?: string;
  /**
   * The user's API url
   */
  readonly url?: string;
  /**
   * Values of custom fields in the user's profile. See [User Fields](#user-fields)
   */
  user_fields?: {
    [key: string]: unknown;
  };
  /**
   * Any of the user's identities is verified. See [User Identities](/api-reference/ticketing/users/user_identities)
   */
  verified?: boolean;
};

export type UserForEndUser = {
  /**
   * The time the user was created
   */
  readonly created_at?: string;
  /**
   * The primary email address of this user. If the primary email address is not [verified](https://support.zendesk.com/hc/en-us/articles/4408886752410), the secondary email address is used
   */
  email?: string;
  /**
   * The time zone for the user
   */
  readonly iana_time_zone?: string;
  /**
   * Automatically assigned when creating users
   */
  readonly id?: number;
  /**
   * The locale for this user
   */
  readonly locale?: string;
  /**
   * The language identifier for this user
   */
  locale_id?: number;
  /**
   * The name of the user
   */
  name: string;
  /**
   * The id of the user's organization. If the user has more than one [organization memberships](/api-reference/ticketing/organizations/organization_memberships/), the id of the user's default organization. If updating, see [Organization ID](/api-reference/ticketing/users/users/#organization-id)
   */
  organization_id?: number;
  /**
   * The primary phone number of this user. See [Phone Number](/api-reference/ticketing/users/users/#phone-number) in the Users API
   */
  phone?: string;
  /**
   * The user's profile picture represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object
   */
  photo?: {
    [key: string]: unknown;
  };
  /**
   * The role of the user. Possible values: `"end-user"`, `"agent"`, `"admin"`
   */
  role?: string;
  /**
   * Whether the `phone` number is shared or not. See [Phone Number](/api-reference/ticketing/users/users/#phone-number) in the Users API
   */
  shared_phone_number?: boolean;
  /**
   * The time-zone of this user
   */
  time_zone?: string;
  /**
   * The time of the last update of the user
   */
  readonly updated_at?: string;
  /**
   * The API url of this user
   */
  readonly url?: string;
  /**
   * Any of the user's identities is verified. See [User Identities](/api-reference/ticketing/users/user_identities)
   */
  verified?: boolean;
};

export type UserIdentitiesResponse = {
  identities?: Array<UserIdentityObject>;
};

export type UserIdentityObject = {
  /**
   * The time the identity was created
   */
  readonly created_at?: string;
  /**
   * Email identity type only. Indicates if Zendesk sends notifications to the email address. See [Deliverable state](#deliverable-state)
   */
  readonly deliverable_state?: string;
  /**
   * Automatically assigned on creation
   */
  readonly id?: number;
  /**
   * If the identity is the primary identity. *Writable only when creating, not when updating. Use the [Make Identity Primary](#make-identity-primary) endpoint instead
   */
  primary?: boolean;
  /**
   * The type of this identity
   */
  readonly type:
    | 'email'
    | 'twitter'
    | 'facebook'
    | 'google'
    | 'phone_number'
    | 'agent_forwarding'
    | 'any_channel'
    | 'foreign'
    | 'sdk';
  /**
   * The number of times a soft-bounce response was received at that address
   */
  readonly undeliverable_count?: number;
  /**
   * The time the identity was updated
   */
  readonly updated_at?: string;
  /**
   * The API url of this identity
   */
  readonly url?: string;
  /**
   * The id of the user
   */
  readonly user_id: number;
  /**
   * The identifier for this identity, such as an email address
   */
  readonly value: string;
  /**
   * If the identity has been verified
   */
  verified?: boolean;
};

/**
 * The type of this identity
 */
export type type3 =
  | 'email'
  | 'twitter'
  | 'facebook'
  | 'google'
  | 'phone_number'
  | 'agent_forwarding'
  | 'any_channel'
  | 'foreign'
  | 'sdk';

export type UserIdentityResponse = {
  identity?: UserIdentityObject;
};

export type UserInput = UserCreateInput | UserMergePropertiesInput | UserMergeByIdInput;

export type UserMergeByIdInput = {
  id?: number;
};

export type UserMergePropertiesInput = {
  email?: string;
  name?: string;
  organization_id?: number;
  password?: string;
};

export type UserObject = UserForAdmin | UserForEndUser;

export type UserPasswordRequirementsResponse = {
  requirements?: Array<string>;
};

export type UserRelatedObject = {
  /**
   * Count of assigned tickets
   */
  assigned_tickets?: number;
  /**
   * Count of collaborated tickets
   */
  ccd_tickets?: number;
  /**
   * Count of organization subscriptions
   */
  organization_subscriptions?: number;
  /**
   * Count of requested tickets
   */
  requested_tickets?: number;
};

export type UserRelatedResponse = {
  user_related?: UserRelatedObject;
};

export type UserRequest = {
  user: UserInput;
};

export type UserResponse = {
  user?: UserObject;
};

export type UsersRequest = {
  users: Array<UserInput>;
};

export type UsersResponse = {
  users?: Array<UserObject>;
};

/**
 * An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)
 *
 */
export type ViaObject = {
  /**
   * This tells you how the ticket or event was created. Examples: "web", "mobile", "rule", "system"
   *
   */
  channel?: string;
  /**
   * For some channels a source object gives more information about how or why the ticket or event was created
   *
   */
  source?: {
    from?: {
      address?: string | null;
      id?: number | null;
      name?: string | null;
      title?: string | null;
    };
    rel?: string | null;
    to?: {
      address?: string;
      name?: string;
    };
    [key: string]: unknown | string;
  };
};

export type ViewCategoriesResponse = {
  view_categories?: Array<ViewCategory>;
};

export type ViewCategory = {
  /**
   * The time the view category was created
   */
  readonly created_at?: string;
  /**
   * Automatically assigned when a view category is created
   */
  readonly id?: string;
  /**
   * The name of the view category
   */
  name?: string;
  /**
   * Position of the view category. Determines the order in which it will be displayed
   */
  position?: number;
  /**
   * The time of the last update of the view category
   */
  readonly updated_at?: string;
  /**
   * The url of the view category
   */
  readonly url?: string;
};

export type ViewCategoryError = {
  code: string;
  detail?: string;
  id?: string;
  links?: {
    [key: string]: unknown;
  };
  source?: {
    [key: string]: unknown;
  };
  status?: string;
  title: string;
};

export type ViewCategoryErrors = {
  errors?: Array<ViewCategoryError>;
};

export type ViewCategoryRequest = {
  name?: string;
};

export type ViewCategoryRequestRequired = {
  [key: string]: unknown;
};

export type ViewCategoryResponse = {
  view_category?: ViewCategory;
};

export type ViewCountObject = {
  /**
   * Only active views if true, inactive views if false, all views if null.
   */
  readonly active?: boolean;
  /**
   * false if the cached data is stale and the system is still loading and caching new data
   */
  readonly fresh?: boolean;
  /**
   * A pretty-printed text approximation of the view count
   */
  readonly pretty?: string;
  /**
   * The API url of the count
   */
  readonly url?: string;
  /**
   * The cached number of tickets in the view. Can also be null if the system is loading and caching new data. Not to be confused with 0 tickets
   */
  readonly value?: number | null;
  /**
   * The id of the view
   */
  readonly view_id?: number;
};

export type ViewCountResponse = {
  view_count?: ViewCountObject;
};

export type ViewCountsResponse = {
  view_counts?: Array<ViewCountObject>;
};

export type ViewExportResponse = {
  export?: {
    readonly status?: string;
    readonly view_id?: number;
  };
};

export type ViewObject = {
  /**
   * Whether the view is active
   */
  active?: boolean;
  /**
   * Describes how the view is constructed. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)
   */
  conditions?: {
    [key: string]: unknown;
  };
  /**
   * The time the view was created
   */
  readonly created_at?: string;
  /**
   * If true, the view is a default view
   */
  readonly default?: boolean;
  /**
   * The description of the view
   */
  description?: string;
  /**
   * Describes how the view should be executed. See [Execution](#execution)
   */
  execution?: {
    [key: string]: unknown;
  };
  /**
   * Automatically assigned when created
   */
  readonly id?: number;
  /**
   * The position of the view
   */
  position?: number;
  /**
   * Who may access this account. Is null when everyone in the account can access it
   */
  restriction?: {
    [key: string]: unknown;
  };
  /**
   * The title of the view
   */
  title?: string;
  /**
   * The time the view was last updated
   */
  readonly updated_at?: string;
};

export type ViewResponse = {
  columns?: Array<{
    [key: string]: unknown;
  }>;
  groups?: Array<{
    [key: string]: unknown;
  }>;
  rows?: Array<{
    [key: string]: unknown;
  }>;
  view?: ViewObject;
};

export type ViewsCountResponse = {
  count?: {
    refreshed_at?: string;
    value?: number;
  };
};

export type ViewsResponse = {
  readonly count?: number;
  readonly next_page?: string | null;
  readonly previous_page?: string | null;
  views?: Array<ViewObject>;
};

export type WorkspaceInput = {
  conditions?: ConditionsObject;
  /**
   * User-defined description of this workspace's purpose
   */
  description?: string;
  macros?: Array<number>;
  ticket_form_id?: number;
  /**
   * The title of the workspace
   */
  title?: string;
};

export type WorkspaceObject = {
  /**
   * If true, this workspace is available for use
   */
  activated?: boolean;
  /**
   * The apps associated to this workspace
   */
  apps?: Array<{
    [key: string]: unknown;
  }>;
  conditions?: ConditionsObject;
  /**
   * The time the workspace was created
   */
  created_at?: string;
  /**
   * User-defined description of this workspace's purpose
   */
  description?: string;
  /**
   * Automatically assigned upon creation
   */
  id?: number;
  /**
   * The ids of the macros associated to this workspace
   */
  macro_ids?: Array<number>;
  /**
   * The ids of the macros associated to this workspace
   */
  macros?: Array<number>;
  /**
   * Ordering of the workspace relative to other workspaces
   */
  position?: number;
  /**
   * If true, the order of apps within the workspace will be preserved
   */
  prefer_workspace_app_order?: boolean;
  /**
   * An array of the macro objects that will be used in this workspace. See [Macros](/api-reference/ticketing/business-rules/macros/)
   */
  selected_macros?: Array<MacroObject>;
  /**
   * The id of the ticket web form associated to this workspace
   */
  ticket_form_id?: number;
  /**
   * The title of the workspace
   */
  title?: string;
  /**
   * The time of the last update of the workspace
   */
  updated_at?: string;
  /**
   * The URL for this resource
   */
  url?: string;
};

export type WorkspaceResponse = {
  workspaces?: Array<WorkspaceObject>;
} & OffsetPaginationObject;

/**
 * The activity ID
 */
export type ParameterActivityId = number;

/**
 * A UTC time in ISO 8601 format to return ticket activities since said date.
 */
export type ParameterActivitySince = string;

/**
 * ID of an agent
 */
export type ParameterAgentId = number;

/**
 * If `true`, any ticket created with a `closed` status bypasses the normal ticket lifecycle and will be created directly in your ticket archive
 */
export type ParameterArchiveImmediately = boolean;

/**
 * Query string used to search assignable groups & agents in the AssigneeField
 */
export type ParameterAssigneeFieldSearchValue = string;

/**
 * The ID of the attachment
 */
export type ParameterAttachmentId = number;

/**
 * The ID of the audit log
 */
export type ParameterAuditLogId = number;

/**
 * Filter by active automations if true or inactive automations if false
 */
export type ParameterAutomationActive = boolean;

/**
 * The ID of the automation
 */
export type ParameterAutomationId = number;

/**
 * A sideload to include in the response. See [Sideloads](#sideloads-2)
 */
export type ParameterAutomationInclude = string;

/**
 * Query string used to find all automations with matching title
 */
export type ParameterAutomationSearchQuery = string;

/**
 * Possible values are "alphabetical", "created_at", "updated_at", and "position". If unspecified, the automations are sorted by relevance
 */
export type ParameterAutomationSortBy = string;

/**
 * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
 */
export type ParameterAutomationSortOrder = string;

/**
 * The ID of the bookmark
 */
export type ParameterBookmarkId = number;

/**
 * The ID of the brand
 */
export type ParameterBrandId = number;

/**
 * The ID of the comment
 */
export type ParameterCommentId = number;

/**
 * If true, displays the `creator_user_id` and `creator_app_name` properties. If the ticket field is created
 * by an app, `creator_app_name` is the name of the app and `creator_user_id` is `-1`. If the ticket field
 * is not created by an app, then `creator_app_name` is null
 *
 */
export type ParameterCreator = boolean;

/**
 * The key or id of a custom object field
 */
export type ParameterCustomObjectFieldKeyOrId = string;

/**
 * The key of a custom object
 */
export type ParameterCustomObjectKey = string;

/**
 * The external id of a custom object record
 */
export type ParameterCustomObjectRecordExternalId = string;

/**
 * The id of a custom object record
 */
export type ParameterCustomObjectRecordId = string;

/**
 * The ID of the custom agent role
 */
export type ParameterCustomRoleId = number;

/**
 * The id of the custom status
 */
export type ParameterCustomStatusId = number;

/**
 * The ID of the deleted user
 */
export type ParameterDeletedUserId = number;

/**
 * The id of the deletion schedule
 */
export type ParameterDeletionScheduleId = number;

/**
 * The ID of the dynamic content item
 */
export type ParameterDynamicContentItemId = number;

/**
 * The ID of the variant
 */
export type ParameterDynamicContentVariantId = number;

/**
 * Filters the email notifications by ticket, comment, or notification id.
 *
 */
export type ParameterEmailNotificationsFilter = 'ticket_id' | 'comment_id' | 'notification_id';

/**
 * Essentials card type. Example: `zen:user` refers user type
 *
 */
export type ParameterEssentialsCardKey = string;

/**
 * Whether to exclude deleted entities
 */
export type ParameterExcludeDeleted = boolean;

/**
 * The ID of the group
 */
export type ParameterGroupId = number;

/**
 * The ID of the group membership
 */
export type ParameterGroupMembershipId = number;

/**
 * The id of the Group SLA policy
 */
export type ParameterGroupSLAPolicyId = number;

/**
 * The hostmapping to a brand, if any (only admins view this key)
 */
export type ParameterHostMapping = string;

/**
 * Include standard fields if true. Exclude them if false
 */
export type ParameterIncludeStandardFields = boolean;

/**
 * The cursor pointer to work with for all subsequent exports after the initial request
 */
export type ParameterIncrementalCursor = string;

/**
 * The number of records to return per page
 */
export type ParameterIncrementalPage = number;

/**
 * The resource requested for incremental sample export
 */
export type ParameterIncrementalResource = string;

/**
 * A query start time for incremental exports
 */
export type ParameterIncrementalTimeQueryParameter = number;

/**
 * The time to start the incremental export from. Must be at least one minute in the past. Data isn't provided for the most recent minute
 */
export type ParameterIncrementalUnixTime = number;

/**
 * the Id of the Job status
 */
export type ParameterJobStatusId = string;

/**
 * The ID or the [BCP-47 code](https://en.wikipedia.org/wiki/IETF_language_tag) of the locale. Examples: es-419, en-us, pr-br
 *
 */
export type ParameterLocaleId = string;

/**
 * The id of a lookup relationship field.  The type of field is determined
 * by the `source` param
 *
 */
export type ParameterLookupRelationshipAutocompleteFieldIdFragment = string;

/**
 * If a `field_id` is provided, this specifies the type of the field.
 * For example, if the field is on a "zen:user", it references a field on a user
 *
 */
export type ParameterLookupRelationshipAutocompleteSourceFragment = string;

/**
 * Filter macros by access. Possible values are "personal", "agents", "shared", or "account". The "agents" value returns all personal macros for the account's agents and is only available to admins.
 */
export type ParameterMacroAccess = string;

/**
 * Filter by active macros if true or inactive macros if false
 */
export type ParameterMacroActive = boolean;

/**
 * Filter macros by category
 */
export type ParameterMacroCategory = number;

/**
 * Filter macros by group
 */
export type ParameterMacroGroupId = number;

/**
 * The ID of the macro
 */
export type ParameterMacroId = number;

/**
 * The ID of the macro to replicate
 */
export type ParameterMacroIdQuery = number;

/**
 * A sideload to include in the response. See [Sideloads](#sideloads-2)
 */
export type ParameterMacroInclude = string;

/**
 * If true, returns only macros that can be applied to tickets. If false, returns all macros the current user can manage. Default is false
 */
export type ParameterMacroOnlyViewable = boolean;

/**
 * Query string used to find macros with matching titles
 */
export type ParameterMacroQuery = string;

/**
 * Possible values are "alphabetical", "created_at", "updated_at", or "position". Defaults to alphabetical
 */
export type ParameterMacroSearchSortBy = string;

/**
 * Possible values are "alphabetical", "created_at", "updated_at", "usage_1h", "usage_24h", "usage_7d", or "usage_30d". Defaults to alphabetical
 */
export type ParameterMacroSortBy = string;

/**
 * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
 */
export type ParameterMacroSortOrder = string;

/**
 * The ID of the custom agent role
 */
export type ParameterMonitoredTwitterHandleId = number;

/**
 * The id of the email notification
 */
export type ParameterNotificationId = number;

/**
 * Custom object type. Example: `zen:custom_object:car` refers to a custom object type with the
 * `car` key
 *
 */
export type ParameterObjectKey = string;

/**
 * The id of the omnichannel routing queue
 */
export type ParameterOcrQueueId = string;

/**
 * The external id of an organization
 */
export type ParameterOrganizationExternalId = number;

/**
 * A list of external ids
 */
export type ParameterOrganizationExternalIds = string;

/**
 * The ID or key of the organization field
 */
export type ParameterOrganizationFieldId = number | string;

/**
 * The ID of an organization
 */
export type ParameterOrganizationId = number;

/**
 * A list of organization ids
 */
export type ParameterOrganizationIds = string;

/**
 * The ID of the organization membership
 */
export type ParameterOrganizationMembershipId = number;

/**
 * The ID of the organization merge
 */
export type ParameterOrganizationMergeId = string;

/**
 * The name of an organization
 */
export type ParameterOrganizationName = string;

/**
 * A substring of an organization to search for
 */
export type ParameterOrganizationQueryFragment = string;

/**
 * The ID of the organization subscription
 */
export type ParameterOrganizationSubscriptionId = number;

/**
 * The ID of the request
 */
export type ParameterRequestId = number;

/**
 * The id of the resource collection
 */
export type ParameterResourceCollectionId = number;

/**
 * The ID of the SLA Policy
 */
export type ParameterSLAPolicyId = number;

/**
 * The ID of the session
 */
export type ParameterSessionId = number;

/**
 * The ID of the sharing agreement
 */
export type ParameterSharingAgreementId = number;

/**
 * The ID of the skill-based routing attribute
 */
export type ParameterSkillBasedRoutingAttributeId = string;

/**
 * The ID of the skill-based routing attribute value
 */
export type ParameterSkillBasedRoutingAttributeValueId = string;

/**
 * User ID of an agent
 */
export type ParameterSkipTicketUserId = number;

/**
 * The field to sort the list.  Possible values are "created_at", "updated_at" (ascending order) or "-created_at", "-updated_at" (descending order)
 */
export type ParameterSort = string;

/**
 * Subdomain for a given Zendesk account address
 */
export type ParameterSubdomain = string;

/**
 * The ID of the support address
 */
export type ParameterSupportAddressId = number;

/**
 * id of the suspended ticket
 */
export type ParameterSuspendedTicketId = number;

/**
 * A list of suspended ticket ids
 */
export type ParameterSuspendedTicketIds = string;

/**
 * A comma separated list of ids of suspended tickets to delete.
 */
export type ParameterSuspendedTicketsDeleteIds = string;

/**
 * A comma separated list of ids of suspended tickets to recover.
 */
export type ParameterSuspendedTicketsRecoverIds = string;

/**
 * The field to sort the suspended tickets by. One of "author_email", "cause", "created_at", or "subject"
 */
export type ParameterSuspendedTicketsSortBy = string;

/**
 * The order in which to sort the suspended tickets.  This can take value `asc` or `desc`.
 */
export type ParameterSuspendedTicketsSortOrder = string;

/**
 * A substring of a tag to search for
 */
export type ParameterTagNameFragment = string;

/**
 * The ID of the target failure
 */
export type ParameterTargetFailureId = number;

/**
 * The ID of the target
 */
export type ParameterTargetId = number;

/**
 * The ID of the ticket audit
 */
export type ParameterTicketAuditId = number;

/**
 * The ID of the ticket comment
 */
export type ParameterTicketCommentId = number;

/**
 * The ID of the ticket field
 */
export type ParameterTicketFieldId = number;

/**
 * The ID of the ticket field option
 */
export type ParameterTicketFieldOptionId = number;

/**
 * The ID of the ticket form
 */
export type ParameterTicketFormId = number;

/**
 * The ID of the ticket
 */
export type ParameterTicketId = number;

/**
 * Comma-separated list of ticket ids
 */
export type ParameterTicketIds = string;

/**
 * Sort by
 */
export type ParameterTicketSortBy = 'id' | 'subject' | 'deleted_at';

/**
 * Sort order. Defaults to "asc"
 */
export type ParameterTicketSortOrder = 'asc' | 'desc';

/**
 * Filter by active triggers if true or inactive triggers if false
 */
export type ParameterTriggerActive = boolean;

/**
 * Filter triggers by category ID
 */
export type ParameterTriggerCategoryId = string;

/**
 * The ID of the trigger
 */
export type ParameterTriggerId = number;

/**
 * A comma separated list of trigger IDs
 */
export type ParameterTriggerIds = string;

/**
 * A sideload to include in the response. See [Sideloads](#sideloads-2)
 */
export type ParameterTriggerInclude = string;

/**
 * The ID of the revision for a particular trigger
 */
export type ParameterTriggerRevisionId = number;

/**
 * Trigger attribute filters for the search. See [Filter](#filter)
 */
export type ParameterTriggerSearchFilter = {
  json?: TriggerObject;
};

/**
 * Query string used to find all triggers with matching title
 */
export type ParameterTriggerSearchQuery = string;

/**
 * Cursor-based pagination only. Possible values are "alphabetical", "created_at", "updated_at", or "position".
 */
export type ParameterTriggerSort = string;

/**
 * Offset pagination only. Possible values are "alphabetical", "created_at", "updated_at", "usage_1h", "usage_24h", or "usage_7d". Defaults to "position"
 */
export type ParameterTriggerSortBy = string;

/**
 * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
 */
export type ParameterTriggerSortOrder = string;

/**
 * List users by external id. External id has to be unique for each user under the same account.
 */
export type ParameterUserExternalIdFilter = string;

/**
 * The ID or key of the user field
 */
export type ParameterUserFieldId = number | string;

/**
 * The ID of the user field option
 */
export type ParameterUserFieldOptionId = number;

/**
 * The id of the user
 */
export type ParameterUserId = number;

/**
 * The ID of the user identity
 */
export type ParameterUserIdentityId = number;

/**
 * For custom roles which is available on the Enterprise plan and above. You can only filter by one role ID per request
 */
export type ParameterUserPermissionSetFilter = number;

/**
 * Filters the results by role. Possible values are "end-user", "agent", or "admin"
 *
 */
export type ParameterUserRoleFilter = 'end-user' | 'agent' | 'admin';

/**
 * Filters the results by more than one role using the format `role[]={role}&role[]={role}`
 *
 */
export type ParameterUserRolesFilter = string;

/**
 * The ID of the view
 */
export type ParameterViewId = number;

/**
 * The id of the workspace
 */
export type ParameterWorkspaceId = number;

export type ListAssigneeFieldAssignableGroupsAndAgentsSearchData = {
  query: {
    /**
     * Query string used to search assignable groups & agents in the AssigneeField
     */
    name: string;
  };
};

export type ListAssigneeFieldAssignableGroupsAndAgentsSearchResponse =
  AssigneeFieldAssignableGroupsAndAgentsSearchResponse;

export type ListAssigneeFieldAssignableGroupsAndAgentsSearchError = unknown;

export type ListAssigneeFieldAssignableGroupsResponse = AssigneeFieldAssignableGroupsResponse;

export type ListAssigneeFieldAssignableGroupsError = unknown;

export type ListAssigneeFieldAssignableGroupAgentsData = {
  path: {
    /**
     * The ID of the group
     */
    group_id: number;
  };
};

export type ListAssigneeFieldAssignableGroupAgentsResponse = AssigneeFieldAssignableGroupAgentsResponse;

export type ListAssigneeFieldAssignableGroupAgentsError = unknown;

export type GetSourcesByTargetData = {
  path: {
    /**
     * The id of the lookup relationship field
     *
     */
    field_id: number;
    /**
     * The type of object the relationship field belongs to (example. ticket field belongs to a ticket object).
     * The options are "zen:user", "zen:ticket", "zen:organization", and "zen:custom_object:CUSTOM_OBJECT_KEY"
     *
     */
    source_type: string;
    /**
     * The id of the object the relationship field is targeting
     *
     */
    target_id: number;
    /**
     * The type of object the relationship field is targeting.
     * The options are "zen:user", "zen:ticket", "zen:organization", and "zen:custom_object:CUSTOM_OBJECT_KEY"
     *
     */
    target_type: string;
  };
};

export type GetSourcesByTargetResponse = ReverseLookupResponse;

export type GetSourcesByTargetError = unknown;

export type ShowAccountSettingsResponse = AccountSettingsResponse;

export type ShowAccountSettingsError = unknown;

export type UpdateAccountSettingsResponse = AccountSettingsResponse;

export type UpdateAccountSettingsError = unknown;

export type CreateTrialAccountResponse = TrialAccountResponse;

export type CreateTrialAccountError = unknown;

export type VerifySubdomainAvailabilityData = {
  query: {
    /**
     * Specify the name of the subdomain you want to verify. The name can't contain underscores, hyphens, or spaces.
     *
     */
    subdomain: string;
  };
};

export type VerifySubdomainAvailabilityResponse = {
  success?: boolean;
};

export type VerifySubdomainAvailabilityError = unknown;

export type ListActivitiesData = {
  query?: {
    /**
     * A UTC time in ISO 8601 format to return ticket activities since said date.
     */
    since?: string;
  };
};

export type ListActivitiesResponse = ActivitiesResponse;

export type ListActivitiesError = unknown;

export type ShowActivityData = {
  path: {
    /**
     * The activity ID
     */
    activity_id: number;
  };
};

export type ShowActivityResponse = ActivityResponse;

export type ShowActivityError = unknown;

export type CountActivitiesResponse = ActivitiesCountResponse;

export type CountActivitiesError = unknown;

export type ReportChannelbackErrorResponse = string;

export type ReportChannelbackErrorError = unknown;

export type PushContentToSupportResponse = ChannelFrameworkPushResultsResponse;

export type PushContentToSupportError = unknown;

export type ValidateTokenResponse = string;

export type ValidateTokenError = unknown;

export type ShowAttachmentData = {
  path: {
    /**
     * The ID of the attachment
     */
    attachment_id: number;
  };
};

export type ShowAttachmentResponse = AttachmentResponse;

export type ShowAttachmentError = unknown;

export type UpdateAttachmentData = {
  body?: AttachmentUpdateRequest;
  path: {
    /**
     * The ID of the attachment
     */
    attachment_id: number;
  };
};

export type UpdateAttachmentResponse = AttachmentResponse;

export type UpdateAttachmentError = unknown;

export type ListAuditLogsData = {
  query?: {
    /**
     * Filter audit logs by the action
     */
    'filter[action]'?: string;
    /**
     * Filter audit logs by the actor id
     */
    'filter[actor_id]'?: number;
    /**
     * Filter audit logs by the time of creation. When used, you must specify `filter[created_at]` twice in your request, first with the start time and again with an end time
     */
    'filter[created_at]'?: string;
    /**
     * Filter audit logs by the ip address
     */
    'filter[ip_address]'?: string;
    /**
     * Filter audit logs by the source id. Requires `filter[source_type]` to also be set
     */
    'filter[source_id]'?: number;
    /**
     * Filter audit logs by the source type. For example, user or rule
     */
    'filter[source_type]'?: string;
    /**
     * Cursor pagination only. Sort audit logs. Default is `sort=-created_at`
     */
    sort?: string;
    /**
     * Offset pagination only. Sort audit logs. Default is `sort_by=created_at`
     */
    sort_by?: string;
    /**
     * Offset pagination only. Sort audit logs. Default is `sort_order=desc`
     */
    sort_order?: string;
  };
};

export type ListAuditLogsResponse = AuditLogsResponse;

export type ListAuditLogsError = unknown;

export type ShowAuditLogData = {
  path: {
    /**
     * The ID of the audit log
     */
    audit_log_id: number;
  };
};

export type ShowAuditLogResponse = AuditLogResponse;

export type ShowAuditLogError = unknown;

export type ExportAuditLogsData = {
  query?: {
    /**
     * Filter audit logs by the action
     */
    'filter[action]'?: string;
    /**
     * Filter audit logs by the actor id
     */
    'filter[actor_id]'?: number;
    /**
     * Filter audit logs by the time of creation. When used, you must specify `filter[created_at]` twice in your request, first with the start time and again with an end time
     */
    'filter[created_at]'?: string;
    /**
     * Filter audit logs by the ip address
     */
    'filter[ip_address]'?: string;
    /**
     * Filter audit logs by the source id. Requires `filter[source_type]` to also be set.
     */
    'filter[source_id]'?: number;
    /**
     * Filter audit logs by the source type. For example, user or rule
     */
    'filter[source_type]'?: string;
  };
};

export type ExportAuditLogsResponse = string;

export type ExportAuditLogsError = unknown;

export type AutocompleteTagsData = {
  query?: {
    /**
     * A substring of a tag to search for
     */
    name?: string;
  };
};

export type AutocompleteTagsResponse = TagsByObjectIdResponse;

export type AutocompleteTagsError = unknown;

export type ListAutomationsResponse = AutomationsResponse;

export type ListAutomationsError = unknown;

export type CreateAutomationResponse = AutomationResponse;

export type CreateAutomationError = unknown;

export type ShowAutomationData = {
  path: {
    /**
     * The ID of the automation
     */
    automation_id: number;
  };
};

export type ShowAutomationResponse = AutomationResponse;

export type ShowAutomationError = unknown;

export type UpdateAutomationData = {
  path: {
    /**
     * The ID of the automation
     */
    automation_id: number;
  };
};

export type UpdateAutomationResponse = AutomationResponse;

export type UpdateAutomationError = unknown;

export type DeleteAutomationData = {
  path: {
    /**
     * The ID of the automation
     */
    automation_id: number;
  };
};

export type DeleteAutomationResponse = any;

export type DeleteAutomationError = unknown;

export type ListActiveAutomationsResponse = AutomationsResponse;

export type ListActiveAutomationsError = unknown;

export type BulkDeleteAutomationsData = {
  query?: {
    /**
     * The IDs of the automations to delete
     */
    ids?: Array<number>;
  };
};

export type BulkDeleteAutomationsResponse = any;

export type BulkDeleteAutomationsError = unknown;

export type SearchAutomationsData = {
  query: {
    /**
     * Filter by active automations if true or inactive automations if false
     */
    active?: boolean;
    /**
     * A sideload to include in the response. See [Sideloads](#sideloads-2)
     */
    include?: string;
    /**
     * Query string used to find all automations with matching title
     */
    query: string;
    /**
     * Possible values are "alphabetical", "created_at", "updated_at", and "position". If unspecified, the automations are sorted by relevance
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type SearchAutomationsResponse = AutomationsResponse;

export type SearchAutomationsError = unknown;

export type UpdateManyAutomationsResponse = AutomationsResponse;

export type UpdateManyAutomationsError = unknown;

export type ListBookmarksResponse = BookmarksResponse;

export type ListBookmarksError = unknown;

export type CreateBookmarkData = {
  body?: BookmarkCreateRequest;
};

export type CreateBookmarkResponse = BookmarkResponse;

export type CreateBookmarkError = unknown;

export type DeleteBookmarkData = {
  path: {
    /**
     * The ID of the bookmark
     */
    bookmark_id: number;
  };
};

export type DeleteBookmarkResponse = any;

export type DeleteBookmarkError = unknown;

export type ListBrandsResponse = BrandsResponse;

export type ListBrandsError = unknown;

export type CreateBrandData = {
  body?: BrandCreateRequest;
};

export type CreateBrandResponse = BrandResponse;

export type CreateBrandError = unknown;

export type ShowBrandData = {
  path: {
    /**
     * The ID of the brand
     */
    brand_id: number;
  };
};

export type ShowBrandResponse = BrandResponse;

export type ShowBrandError = unknown;

export type UpdateBrandData = {
  body?: BrandUpdateRequest;
  path: {
    /**
     * The ID of the brand
     */
    brand_id: number;
  };
};

export type UpdateBrandResponse = BrandResponse;

export type UpdateBrandError = unknown;

export type DeleteBrandData = {
  path: {
    /**
     * The ID of the brand
     */
    brand_id: number;
  };
};

export type DeleteBrandResponse = any;

export type DeleteBrandError = unknown;

export type CheckHostMappingValidityForExistingBrandData = {
  path: {
    /**
     * The ID of the brand
     */
    brand_id: number;
  };
};

export type CheckHostMappingValidityForExistingBrandResponse = HostMappingObject;

export type CheckHostMappingValidityForExistingBrandError = unknown;

export type CheckHostMappingValidityData = {
  query: {
    /**
     * The hostmapping to a brand, if any (only admins view this key)
     */
    host_mapping: string;
    /**
     * Subdomain for a given Zendesk account address
     */
    subdomain: string;
  };
};

export type CheckHostMappingValidityResponse = HostMappingObject;

export type CheckHostMappingValidityError = unknown;

export type ListMonitoredTwitterHandlesResponse = TwitterChannelsResponse;

export type ListMonitoredTwitterHandlesError = unknown;

export type ShowMonitoredTwitterHandleData = {
  path: {
    /**
     * The ID of the custom agent role
     */
    monitored_twitter_handle_id: number;
  };
};

export type ShowMonitoredTwitterHandleResponse = TwitterChannelResponse;

export type ShowMonitoredTwitterHandleError = unknown;

export type CreateTicketFromTweetResponse = string;

export type CreateTicketFromTweetError = unknown;

export type GettingTwicketStatusData = {
  path: {
    /**
     * The ID of the comment
     */
    comment_id: number;
  };
  query?: {
    /**
     * Optional comment ids to retrieve tweet information for only particular comments
     */
    ids?: string;
  };
};

export type GettingTwicketStatusResponse = TwitterChannelTwicketStatusResponse;

export type GettingTwicketStatusError = unknown;

export type OpenTicketInAgentBrowserData = {
  path: {
    /**
     * ID of an agent
     */
    agent_id: number;
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type OpenTicketInAgentBrowserResponse = string;

export type OpenTicketInAgentBrowserError = string;

export type OpenUsersProfileInAgentBrowserData = {
  path: {
    /**
     * ID of an agent
     */
    agent_id: number;
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type OpenUsersProfileInAgentBrowserResponse = string;

export type OpenUsersProfileInAgentBrowserError = string;

export type CreateTicketOrVoicemailTicketData = {
  body?: TicketCreateVoicemailTicketRequest;
  path: {
    /**
     * ID of an agent
     */
    agent_id: number;
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type CreateTicketOrVoicemailTicketResponse = TicketResponse;

export type CreateTicketOrVoicemailTicketError = string;

export type RedactChatCommentAttachmentData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type RedactChatCommentAttachmentResponse = TicketChatCommentRedactionResponse;

export type RedactChatCommentAttachmentError = unknown;

export type RedactChatCommentData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type RedactChatCommentResponse = TicketChatCommentRedactionResponse;

export type RedactChatCommentError = unknown;

export type RedactTicketCommentInAgentWorkspaceData = {
  path: {
    /**
     * The ID of the ticket comment
     */
    ticket_comment_id: number;
  };
};

export type RedactTicketCommentInAgentWorkspaceResponse = TicketCommentResponse;

export type RedactTicketCommentInAgentWorkspaceError = unknown;

export type ListCustomObjectsResponse = CustomObjectsResponse;

export type ListCustomObjectsError = unknown;

export type CreateCustomObjectData = {
  body?: CustomObjectsCreateRequest;
};

export type CreateCustomObjectResponse = CustomObjectResponse;

export type CreateCustomObjectError = unknown;

export type ShowCustomObjectData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type ShowCustomObjectResponse = CustomObjectResponse;

export type ShowCustomObjectError = unknown;

export type UpdateCustomObjectData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type UpdateCustomObjectResponse = CustomObjectResponse;

export type UpdateCustomObjectError = unknown;

export type DeleteCustomObjectData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type DeleteCustomObjectResponse = any;

export type DeleteCustomObjectError = unknown;

export type ListCustomObjectFieldsData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
  query?: {
    /**
     * Include standard fields if true. Exclude them if false
     */
    include_standard_fields?: boolean;
  };
};

export type ListCustomObjectFieldsResponse = CustomObjectFieldsResponse;

export type ListCustomObjectFieldsError = unknown;

export type CreateCustomObjectFieldData = {
  body?: CustomObjectFieldsCreateRequest;
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type CreateCustomObjectFieldResponse = CustomObjectFieldResponse;

export type CreateCustomObjectFieldError = unknown;

export type ShowCustomObjectFieldData = {
  path: {
    /**
     * The key or id of a custom object field
     */
    custom_object_field_key_or_id: string;
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type ShowCustomObjectFieldResponse = CustomObjectFieldResponse;

export type ShowCustomObjectFieldError = unknown;

export type UpdateCustomObjectFieldData = {
  path: {
    /**
     * The key or id of a custom object field
     */
    custom_object_field_key_or_id: string;
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type UpdateCustomObjectFieldResponse = CustomObjectFieldResponse;

export type UpdateCustomObjectFieldError = unknown;

export type DeleteCustomObjectFieldData = {
  path: {
    /**
     * The key or id of a custom object field
     */
    custom_object_field_key_or_id: string;
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type DeleteCustomObjectFieldResponse = any;

export type DeleteCustomObjectFieldError = unknown;

export type ReorderCustomObjectFieldsData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type ReorderCustomObjectFieldsResponse = string;

export type ReorderCustomObjectFieldsError = unknown;

export type CustomObjectRecordBulkJobsData = {
  body?: CustomObjectRecordsBulkCreateRequest;
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type CustomObjectRecordBulkJobsResponse = CustomObjectRecordsJobsResponse;

export type CustomObjectRecordBulkJobsError = unknown;

export type CustomObjectFieldsLimitData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type CustomObjectFieldsLimitResponse = CustomObjectLimitsResponse;

export type CustomObjectFieldsLimitError = unknown;

export type ListCustomObjectRecordsData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
  query?: {
    /**
     * Optional comma-separated list of external ids to filter records by. If one or more ids are specified, only matching records are returned. The ids must be unique and are case sensitive.
     */
    'filter[external_ids]'?: string;
    /**
     * Optional comma-separated list of ids to filter records by. If one or more ids are specified, only matching records are returned. The ids must be unique and are case sensitive.
     */
    'filter[ids]'?: string;
    /**
     * A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.
     *
     */
    'page[after]'?: string;
    /**
     * A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.
     *
     */
    'page[before]'?: string;
    /**
     * Specifies how many records should be returned in the response. You can specify up to 100 records per page.
     *
     */
    'page[size]'?: number;
    /**
     * One of `id`, `updated_at`, `-id`, or `-updated_at`. The `-` denotes the sort will be descending.
     *
     */
    sort?: string;
  };
};

export type ListCustomObjectRecordsResponse = CustomObjectRecordsResponse;

export type ListCustomObjectRecordsError = unknown;

export type CreateCustomObjectRecordData = {
  body?: CustomObjectRecordsCreateRequest;
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type CreateCustomObjectRecordResponse = CustomObjectRecordResponse;

export type CreateCustomObjectRecordError = unknown;

export type UpsertCustomObjectRecordData = {
  body?: CustomObjectRecordsUpsertRequest;
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
  query: {
    /**
     * The external id of a custom object record
     */
    external_id: string;
  };
};

export type UpsertCustomObjectRecordResponse = CustomObjectRecordResponse;

export type UpsertCustomObjectRecordError = unknown;

export type DeleteCustomObjectRecordByExternalIdData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
  query: {
    /**
     * The external id of a custom object record
     */
    external_id: string;
  };
};

export type DeleteCustomObjectRecordByExternalIdResponse = any;

export type DeleteCustomObjectRecordByExternalIdError = unknown;

export type ShowCustomObjectRecordData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
    /**
     * The id of a custom object record
     */
    custom_object_record_id: string;
  };
};

export type ShowCustomObjectRecordResponse = CustomObjectRecordResponse;

export type ShowCustomObjectRecordError = unknown;

export type UpdateCustomObjectRecordData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
    /**
     * The id of a custom object record
     */
    custom_object_record_id: string;
  };
};

export type UpdateCustomObjectRecordResponse = CustomObjectRecordResponse;

export type UpdateCustomObjectRecordError = unknown;

export type DeleteCustomObjectRecordData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
    /**
     * The id of a custom object record
     */
    custom_object_record_id: string;
  };
};

export type DeleteCustomObjectRecordResponse = any;

export type DeleteCustomObjectRecordError = unknown;

export type AutocompleteCustomObjectRecordSearchData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
  query?: {
    /**
     * The id of the selected assignee. For use with dynamic filters.
     *
     */
    assignee_id?: number;
    /**
     * The id of the lookup field. If the field has a relationship filter, the filter is applied to the results. Must be used with `source` param.
     *
     */
    field_id?: string;
    /**
     * Part of a name of the record you are searching for
     */
    name?: string;
    /**
     * The id of the organization the requester belongs to. For use with dynamic filters.
     *
     */
    organization_id?: number;
    /**
     * A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.
     *
     */
    'page[after]'?: string;
    /**
     * A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.
     *
     */
    'page[before]'?: string;
    /**
     * The number of records to return in the response. You can specify up to 100 records per page.
     *
     */
    'page[size]'?: number;
    /**
     * The id of the requester. For use with dynamic filters.
     *
     */
    requester_id?: number;
    /**
     * One of "zen:user", "zen:ticket", "zen:organization", or "zen:custom_object:CUSTOM_OBJECT_KEY". Represents the object `field_id` belongs to. Must be used with field_id param.
     *
     */
    source?: string;
  };
};

export type AutocompleteCustomObjectRecordSearchResponse = CustomObjectRecordsResponse;

export type AutocompleteCustomObjectRecordSearchError = unknown;

export type CountCustomObjectRecordsData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type CountCustomObjectRecordsResponse = {
  count?: {
    [key: string]: {
      /**
       * The time the last count was performed
       */
      readonly refreshed_at?: string;
      /**
       * Number of records at the time of the latest count operation
       */
      readonly value?: number;
    };
  };
};

export type CountCustomObjectRecordsError = unknown;

export type SearchCustomObjectRecordsData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
  query?: {
    /**
     * A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.
     *
     */
    'page[after]'?: string;
    /**
     * A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.
     *
     */
    'page[before]'?: string;
    /**
     * Specifies how many records should be returned in the response. You can specify up to 100 records per page.
     *
     */
    'page[size]'?: number;
    /**
     * The query parameter is used to search text-based fields for records that match specific query terms.
     * The query can be multiple words or numbers. Every record that matches the beginning of any word or number in the query string is returned.<br/><br/>
     *
     * Fuzzy search is supported for the following text-based field types: : Text fields, Multi Line Text fields, and RegExp fields.<br/><br/>
     *
     * For example, you might want to search for records related to Tesla vehicles: `query=Tesla`. In this example the API would return every record for the given custom object where any of the supported text fields contain the word 'Tesla'.<br/><br/>
     *
     * You can include multiple words or numbers in your search. For example: `query=Tesla Honda 2020`. This search phrase would be URL encoded as `query=Tesla%20Honda%202020` and return every record for the custom object for which any of the supported text fields contained 'Tesla', 'Honda', or '2020'.
     *
     */
    query?: string;
    /**
     * One of `name`, `created_at`, `updated_at`, `-name`, `-created_at`, or `-updated_at`. The `-` denotes the sort will be descending. Defaults to sorting by relevance.
     *
     */
    sort?: string;
  };
};

export type SearchCustomObjectRecordsResponse = CustomObjectRecordsResponse;

export type SearchCustomObjectRecordsError = unknown;

export type FilteredSearchCustomObjectRecordsData = {
  body?: CustomObjectRecordsFilteredSearchRequestBasic | CustomObjectRecordsFilteredSearchRequestComplex;
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
  query?: {
    /**
     * A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.
     *
     */
    'page[after]'?: string;
    /**
     * A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.
     *
     */
    'page[before]'?: string;
    /**
     * Specifies how many records should be returned in the response. You can specify up to 100 records per page.
     *
     */
    'page[size]'?: number;
    /**
     * The query parameter is used to search text-based fields for records that match specific query terms.
     * The query can be multiple words or numbers. Every record that matches the beginning of any word or number in the query string is returned.<br/><br/>
     *
     * Fuzzy search is supported for the following text-based field types: Text fields, Multi Line Text fields, and RegExp fields.<br/><br/>
     *
     * For example, you might want to search for records related to Tesla vehicles: `query=Tesla`. In this example the API would return every record for the given custom object where any of the supported text fields contain the word 'Tesla'.<br/><br/>
     *
     * You can include multiple words or numbers in your search. For example: `query=Tesla Honda 2020`. This search phrase would be URL encoded as `query=Tesla%20Honda%202020` and return every record for the custom object for which any of the supported text fields contained 'Tesla', 'Honda', or '2020'.
     *
     */
    query?: string;
    /**
     * One of `name`, `created_at`, `updated_at`, `-name`, `-created_at`, or `-updated_at`. The `-` denotes the sort will be descending. Defaults to sorting by relevance.
     *
     */
    sort?: string;
  };
};

export type FilteredSearchCustomObjectRecordsResponse = CustomObjectRecordsResponse;

export type FilteredSearchCustomObjectRecordsError = unknown;

export type ListObjectTriggersData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
  query?: {
    /**
     * Filter by active triggers if true or inactive triggers if false
     */
    active?: boolean;
    /**
     * Offset pagination only. Possible values are "alphabetical", "created_at", "updated_at", "usage_1h", "usage_24h", or "usage_7d". Defaults to "position"
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type ListObjectTriggersResponse = ObjectTriggersResponse;

export type ListObjectTriggersError = unknown;

export type CreateObjectTriggerData = {
  body: ObjectTriggerRequest;
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type CreateObjectTriggerResponse = ObjectTriggerResponse;

export type CreateObjectTriggerError = unknown;

export type GetObjectTriggerData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
    /**
     * The ID of the trigger
     */
    trigger_id: number;
  };
};

export type GetObjectTriggerResponse = ObjectTriggerResponse;

export type GetObjectTriggerError = unknown;

export type UpdateObjectTriggerData = {
  body: ObjectTriggerRequest;
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
    /**
     * The ID of the trigger
     */
    trigger_id: number;
  };
};

export type UpdateObjectTriggerResponse = ObjectTriggerResponse;

export type UpdateObjectTriggerError = unknown;

export type DeleteObjectTriggerData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
    /**
     * The ID of the trigger
     */
    trigger_id: number;
  };
};

export type DeleteObjectTriggerResponse = any;

export type DeleteObjectTriggerError = unknown;

export type ListActiveObjectTriggersData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
  query?: {
    /**
     * Offset pagination only. Possible values are "alphabetical", "created_at", "updated_at", "usage_1h", "usage_24h", or "usage_7d". Defaults to "position"
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type ListActiveObjectTriggersResponse = ObjectTriggersResponse;

export type ListActiveObjectTriggersError = unknown;

export type ListObjectTriggersDefinitionsData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type ListObjectTriggersDefinitionsResponse = ObjectTriggerDefinitionResponse;

export type ListObjectTriggersDefinitionsError = unknown;

export type DeleteManyObjectTriggersData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
  query: {
    /**
     * A comma separated list of trigger IDs
     */
    ids: string;
  };
};

export type DeleteManyObjectTriggersResponse = any;

export type DeleteManyObjectTriggersError = unknown;

export type SearchObjectTriggersData = {
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
  query: {
    /**
     * Filter by active triggers if true or inactive triggers if false
     */
    active?: boolean;
    /**
     * Trigger attribute filters for the search. See [Filter](#filter)
     */
    filter?: {
      json?: TriggerObject;
    };
    /**
     * A sideload to include in the response. See [Sideloads](#sideloads-2)
     */
    include?: string;
    /**
     * Query string used to find all triggers with matching title
     */
    query: string;
    /**
     * Cursor-based pagination only. Possible values are "alphabetical", "created_at", "updated_at", or "position".
     */
    sort?: string;
    /**
     * Offset pagination only. Possible values are "alphabetical", "created_at", "updated_at", "usage_1h", "usage_24h", or "usage_7d". Defaults to "position"
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type SearchObjectTriggersResponse = ObjectTriggersResponse;

export type SearchObjectTriggersError = unknown;

export type UpdateManyObjectTriggersData = {
  body: ObjectTriggerBulkUpdateRequest;
  path: {
    /**
     * The key of a custom object
     */
    custom_object_key: string;
  };
};

export type UpdateManyObjectTriggersResponse = ObjectTriggersResponse;

export type UpdateManyObjectTriggersError = unknown;

export type CustomObjectsLimitResponse = CustomObjectLimitsResponse;

export type CustomObjectsLimitError = unknown;

export type CustomObjectRecordsLimitResponse = CustomObjectLimitsResponse;

export type CustomObjectRecordsLimitError = unknown;

export type ListCustomRolesResponse = CustomRolesResponse;

export type ListCustomRolesError = unknown;

export type CreateCustomRoleResponse = CustomRoleResponse;

export type CreateCustomRoleError = unknown;

export type ShowCustomRoleByIdData = {
  path: {
    /**
     * The ID of the custom agent role
     */
    custom_role_id: number;
  };
};

export type ShowCustomRoleByIdResponse = CustomRoleResponse;

export type ShowCustomRoleByIdError = unknown;

export type UpdateCustomRoleByIdData = {
  path: {
    /**
     * The ID of the custom agent role
     */
    custom_role_id: number;
  };
};

export type UpdateCustomRoleByIdResponse = CustomRoleResponse;

export type UpdateCustomRoleByIdError = unknown;

export type DeleteCustomRoleByIdData = {
  path: {
    /**
     * The ID of the custom agent role
     */
    custom_role_id: number;
  };
};

export type DeleteCustomRoleByIdResponse = any;

export type DeleteCustomRoleByIdError = unknown;

export type BulkUpdateDefaultCustomStatusData = {
  body?: BulkUpdateDefaultCustomStatusRequest;
};

export type BulkUpdateDefaultCustomStatusResponse2 = BulkUpdateDefaultCustomStatusResponse;

export type BulkUpdateDefaultCustomStatusError = unknown;

export type ListCustomStatusesData = {
  query?: {
    /**
     * If true, show only active custom ticket statuses. If false, show only inactive custom ticket statuses. If the filter is not used, show all custom ticket statuses
     */
    active?: boolean;
    /**
     * If true, show only default custom ticket statuses. If false, show only non-default custom ticket statuses. If the filter is not used, show all custom ticket statuses
     */
    default?: boolean;
    /**
     * Filter the list of custom ticket statuses by a comma-separated list of status categories
     */
    status_categories?: string;
  };
};

export type ListCustomStatusesResponse = CustomStatusesResponse;

export type ListCustomStatusesError = unknown;

export type CreateCustomStatusData = {
  body?: CustomStatusCreateRequest;
};

export type CreateCustomStatusResponse = CustomStatusResponse;

export type CreateCustomStatusError = unknown;

export type ShowCustomStatusData = {
  path: {
    /**
     * The id of the custom status
     */
    custom_status_id: number;
  };
};

export type ShowCustomStatusResponse = CustomStatusResponse;

export type ShowCustomStatusError = unknown;

export type UpdateCustomStatusData = {
  body?: CustomStatusUpdateRequest;
  path: {
    /**
     * The id of the custom status
     */
    custom_status_id: number;
  };
};

export type UpdateCustomStatusResponse = CustomStatusResponse;

export type UpdateCustomStatusError = unknown;

export type ListDeletedTicketsData = {
  query?: {
    /**
     * Sort by
     */
    sort_by?: 'id' | 'subject' | 'deleted_at';
    /**
     * Sort order. Defaults to "asc"
     */
    sort_order?: 'asc' | 'desc';
  };
};

export type ListDeletedTicketsResponse2 = ListDeletedTicketsResponse;

export type ListDeletedTicketsError = unknown;

export type DeleteTicketPermanentlyData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type DeleteTicketPermanentlyResponse = JobStatusResponse;

export type DeleteTicketPermanentlyError = unknown;

export type RestoreDeletedTicketData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type RestoreDeletedTicketResponse = string;

export type RestoreDeletedTicketError = unknown;

export type BulkPermanentlyDeleteTicketsData = {
  query: {
    /**
     * Comma-separated list of ticket ids
     */
    ids: string;
  };
};

export type BulkPermanentlyDeleteTicketsResponse = JobStatusResponse;

export type BulkPermanentlyDeleteTicketsError = unknown;

export type BulkRestoreDeletedTicketsData = {
  query: {
    /**
     * Comma-separated list of ticket ids
     */
    ids: string;
  };
};

export type BulkRestoreDeletedTicketsResponse = string;

export type BulkRestoreDeletedTicketsError = unknown;

export type ListDeletedUsersResponse = DeletedUsersResponse;

export type ListDeletedUsersError = unknown;

export type ShowDeletedUserData = {
  path: {
    /**
     * The ID of the deleted user
     */
    deleted_user_id: number;
  };
};

export type ShowDeletedUserResponse = DeletedUserResponse;

export type ShowDeletedUserError = unknown;

export type PermanentlyDeleteUserData = {
  path: {
    /**
     * The ID of the deleted user
     */
    deleted_user_id: number;
  };
};

export type PermanentlyDeleteUserResponse = DeletedUserResponse;

export type PermanentlyDeleteUserError = unknown;

export type CountDeletedUsersResponse = CountResponse;

export type CountDeletedUsersError = unknown;

export type ListDeletionSchedulesResponse = {
  deletion_schedules?: Array<DeletionSchedule>;
};

export type ListDeletionSchedulesError = unknown;

export type CreateDeletionScheduleData = {
  body: {
    deletion_schedule?: DeletionSchedule;
  };
};

export type CreateDeletionScheduleResponse = {
  deletion_schedule?: DeletionSchedule;
};

export type CreateDeletionScheduleError = unknown;

export type GetDeletionScheduleData = {
  path: {
    /**
     * The id of the deletion schedule
     */
    deletion_schedule_id: number;
  };
};

export type GetDeletionScheduleResponse = {
  deletion_schedule?: DeletionSchedule;
};

export type GetDeletionScheduleError = unknown;

export type UpdateDeletionScheduleData = {
  body: {
    deletion_schedule?: DeletionSchedule;
  };
  path: {
    /**
     * The id of the deletion schedule
     */
    deletion_schedule_id: number;
  };
};

export type UpdateDeletionScheduleResponse = {
  deletion_schedule?: DeletionSchedule;
};

export type UpdateDeletionScheduleError = unknown;

export type DeleteDeletionScheduleData = {
  path: {
    /**
     * The id of the deletion schedule
     */
    deletion_schedule_id: number;
  };
};

export type DeleteDeletionScheduleResponse = any;

export type DeleteDeletionScheduleError = unknown;

export type ListDynamicContentsResponse = DynamicContentsResponse;

export type ListDynamicContentsError = unknown;

export type CreateDynamicContentResponse = DynamicContentResponse;

export type CreateDynamicContentError = unknown;

export type ShowDynamicContentItemData = {
  path: {
    /**
     * The ID of the dynamic content item
     */
    dynamic_content_item_id: number;
  };
};

export type ShowDynamicContentItemResponse = DynamicContentResponse;

export type ShowDynamicContentItemError = unknown;

export type UpdateDynamicContentItemData = {
  path: {
    /**
     * The ID of the dynamic content item
     */
    dynamic_content_item_id: number;
  };
};

export type UpdateDynamicContentItemResponse = DynamicContentResponse;

export type UpdateDynamicContentItemError = unknown;

export type DeleteDynamicContentItemData = {
  path: {
    /**
     * The ID of the dynamic content item
     */
    dynamic_content_item_id: number;
  };
};

export type DeleteDynamicContentItemResponse = any;

export type DeleteDynamicContentItemError = unknown;

export type DynamicContentListVariantsData = {
  path: {
    /**
     * The ID of the dynamic content item
     */
    dynamic_content_item_id: number;
  };
};

export type DynamicContentListVariantsResponse = DynamicContentVariantsResponse;

export type DynamicContentListVariantsError = unknown;

export type CreateDynamicContentVariantData = {
  path: {
    /**
     * The ID of the dynamic content item
     */
    dynamic_content_item_id: number;
  };
};

export type CreateDynamicContentVariantResponse = DynamicContentVariantResponse;

export type CreateDynamicContentVariantError = unknown;

export type ShowDynamicContentVariantData = {
  path: {
    /**
     * The ID of the dynamic content item
     */
    dynamic_content_item_id: number;
    /**
     * The ID of the variant
     */
    dynammic_content_variant_id: number;
  };
};

export type ShowDynamicContentVariantResponse = DynamicContentVariantResponse;

export type ShowDynamicContentVariantError = unknown;

export type UpdateDynamicContentVariantData = {
  path: {
    /**
     * The ID of the dynamic content item
     */
    dynamic_content_item_id: number;
    /**
     * The ID of the variant
     */
    dynammic_content_variant_id: number;
  };
};

export type UpdateDynamicContentVariantResponse = DynamicContentVariantResponse;

export type UpdateDynamicContentVariantError = unknown;

export type DeleteDynamicContentVariantData = {
  path: {
    /**
     * The ID of the dynamic content item
     */
    dynamic_content_item_id: number;
    /**
     * The ID of the variant
     */
    dynammic_content_variant_id: number;
  };
};

export type DeleteDynamicContentVariantResponse = any;

export type DeleteDynamicContentVariantError = unknown;

export type CreateManyDynamicContentVariantsData = {
  path: {
    /**
     * The ID of the dynamic content item
     */
    dynamic_content_item_id: number;
  };
};

export type CreateManyDynamicContentVariantsResponse = DynamicContentVariantsResponse;

export type CreateManyDynamicContentVariantsError = unknown;

export type UpdateManyDynamicContentVariantsData = {
  path: {
    /**
     * The ID of the dynamic content item
     */
    dynamic_content_item_id: number;
  };
};

export type UpdateManyDynamicContentVariantsResponse = DynamicContentVariantsResponse;

export type UpdateManyDynamicContentVariantsError = unknown;

export type ShowManyDynamicContentsData = {
  query?: {
    /**
     * Identifiers for the dynamic contents
     */
    identifiers?: string;
  };
};

export type ShowManyDynamicContentsResponse = DynamicContentsResponse;

export type ShowManyDynamicContentsError = unknown;

export type ListEmailNotificationsData = {
  query?: {
    /**
     * Filters the email notifications by ticket, comment, or notification id.
     *
     */
    filter?: 'ticket_id' | 'comment_id' | 'notification_id';
    /**
     * The number of records to return per page
     */
    per_page?: number;
    /**
     * The field to sort the list.  Possible values are "created_at", "updated_at" (ascending order) or "-created_at", "-updated_at" (descending order)
     */
    sort?: string;
  };
};

export type ListEmailNotificationsResponse = EmailNotificationsResponse;

export type ListEmailNotificationsError = unknown;

export type ShowEmailNotificationData = {
  path: {
    /**
     * The id of the email notification
     */
    notification_id: number;
  };
};

export type ShowEmailNotificationResponse = EmailNotificationResponse;

export type ShowEmailNotificationError = unknown;

export type ListGroupMembershipsData = {
  path: {
    /**
     * The ID of the group
     */
    group_id: number;
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type ListGroupMembershipsResponse = GroupMembershipsResponse;

export type ListGroupMembershipsError = unknown;

export type CreateGroupMembershipResponse = GroupMembershipResponse;

export type CreateGroupMembershipError = unknown;

export type ShowGroupMembershipByIdData = {
  path: {
    /**
     * The ID of the group membership
     */
    group_membership_id: number;
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type ShowGroupMembershipByIdResponse = GroupMembershipResponse;

export type ShowGroupMembershipByIdError = unknown;

export type DeleteGroupMembershipData = {
  path: {
    /**
     * The ID of the group membership
     */
    group_membership_id: number;
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type DeleteGroupMembershipResponse = any;

export type DeleteGroupMembershipError = unknown;

export type ListAssignableGroupMembershipsResponse = GroupMembershipsResponse;

export type ListAssignableGroupMembershipsError = unknown;

export type GroupMembershipBulkCreateResponse = JobStatusResponse;

export type GroupMembershipBulkCreateError = unknown;

export type GroupMembershipBulkDeleteData = {
  query?: {
    /**
     * Id of the group memberships to delete. Comma separated
     */
    ids?: string;
  };
};

export type GroupMembershipBulkDeleteResponse = JobStatusResponse;

export type GroupMembershipBulkDeleteError = unknown;

export type ListGroupSlaPoliciesResponse = GroupSLAPoliciesResponse;

export type ListGroupSlaPoliciesError = unknown;

export type CreateGroupSlaPolicyResponse = GroupSLAPolicyResponse;

export type CreateGroupSlaPolicyError = unknown;

export type ShowGroupSlaPolicyData = {
  path: {
    /**
     * The id of the Group SLA policy
     */
    group_sla_policy_id: number;
  };
};

export type ShowGroupSlaPolicyResponse = GroupSLAPolicyResponse;

export type ShowGroupSlaPolicyError = unknown;

export type UpdateGroupSlaPolicyData = {
  path: {
    /**
     * The id of the Group SLA policy
     */
    group_sla_policy_id: number;
  };
};

export type UpdateGroupSlaPolicyResponse = GroupSLAPolicyResponse;

export type UpdateGroupSlaPolicyError = unknown;

export type DeleteGroupSlaPolicyData = {
  path: {
    /**
     * The id of the Group SLA policy
     */
    group_sla_policy_id: number;
  };
};

export type DeleteGroupSlaPolicyResponse = any;

export type DeleteGroupSlaPolicyError = unknown;

export type RetrieveGroupSlaPolicyFilterDefinitionItemsResponse = GroupSLAPolicyFilterDefinitionResponse;

export type RetrieveGroupSlaPolicyFilterDefinitionItemsError = unknown;

export type ReorderGroupSlaPoliciesData = {
  query?: {
    /**
     * The ids of the Group SLA policies to reorder
     */
    group_sla_policy_ids?: Array<string>;
  };
};

export type ReorderGroupSlaPoliciesResponse = string;

export type ReorderGroupSlaPoliciesError = unknown;

export type ListGroupsData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
  query?: {
    /**
     * Whether to exclude deleted entities
     */
    exclude_deleted?: boolean;
  };
};

export type ListGroupsResponse = GroupsResponse;

export type ListGroupsError = unknown;

export type CreateGroupResponse = GroupResponse;

export type CreateGroupError = unknown;

export type ShowGroupByIdData = {
  path: {
    /**
     * The ID of the group
     */
    group_id: number;
  };
};

export type ShowGroupByIdResponse = GroupResponse;

export type ShowGroupByIdError = unknown;

export type UpdateGroupData = {
  path: {
    /**
     * The ID of the group
     */
    group_id: number;
  };
};

export type UpdateGroupResponse = GroupResponse;

export type UpdateGroupError = unknown;

export type DeleteGroupData = {
  path: {
    /**
     * The ID of the group
     */
    group_id: number;
  };
};

export type DeleteGroupResponse = any;

export type DeleteGroupError = unknown;

export type ListAssignableGroupsResponse = GroupsResponse;

export type ListAssignableGroupsError = unknown;

export type CountGroupsData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type CountGroupsResponse = GroupsCountObject;

export type CountGroupsError = unknown;

export type TicketImportData = {
  body?: TicketImportRequest;
  query?: {
    /**
     * If `true`, any ticket created with a `closed` status bypasses the normal ticket lifecycle and will be created directly in your ticket archive
     */
    archive_immediately?: boolean;
  };
};

export type TicketImportResponse = TicketResponse;

export type TicketImportError = unknown;

export type TicketBulkImportData = {
  body?: TicketBulkImportRequest;
  query?: {
    /**
     * If `true`, any ticket created with a `closed` status bypasses the normal ticket lifecycle and will be created directly in your ticket archive
     */
    archive_immediately?: boolean;
  };
};

export type TicketBulkImportResponse = JobStatusResponse;

export type TicketBulkImportError = unknown;

export type IncrementalSampleExportData = {
  path: {
    /**
     * The resource requested for incremental sample export
     */
    incremental_resource: string;
  };
  query: {
    /**
     * The time to start the incremental export from. Must be at least one minute in the past. Data isn't provided for the most recent minute
     */
    start_time: number;
  };
};

export type IncrementalSampleExportResponse = TimeBasedExportIncrementalTicketsResponse;

export type IncrementalSampleExportError = unknown;

export type IncrementalOrganizationExportData = {
  query: {
    /**
     * The time to start the incremental export from. Must be at least one minute in the past. Data isn't provided for the most recent minute
     */
    start_time: number;
  };
};

export type IncrementalOrganizationExportResponse = ExportIncrementalOrganizationsResponse;

export type IncrementalOrganizationExportError = unknown;

export type IncrementalSkilBasedRoutingAttributeValuesExportResponse = IncrementalSkillBasedRouting;

export type IncrementalSkilBasedRoutingAttributeValuesExportError = unknown;

export type IncrementalSkilBasedRoutingAttributesExportResponse = IncrementalSkillBasedRouting;

export type IncrementalSkilBasedRoutingAttributesExportError = unknown;

export type IncrementalSkilBasedRoutingInstanceValuesExportResponse = IncrementalSkillBasedRouting;

export type IncrementalSkilBasedRoutingInstanceValuesExportError = unknown;

export type IncrementalTicketEventsData = {
  query: {
    /**
     * The time to start the incremental export from. Must be at least one minute in the past. Data isn't provided for the most recent minute
     */
    start_time: number;
  };
};

export type IncrementalTicketEventsResponse = ExportIncrementalTicketEventsResponse;

export type IncrementalTicketEventsError = unknown;

export type ListTicketMetricEventsData = {
  query: {
    /**
     * The Unix UTC epoch time of the oldest event you're interested in. Example: 1332034771.
     */
    start_time: number;
  };
};

export type ListTicketMetricEventsResponse = TicketMetricEventsResponse;

export type ListTicketMetricEventsError = unknown;

export type IncrementalTicketExportTimeData = {
  query: {
    /**
     * The time to start the incremental export from. Must be at least one minute in the past. Data isn't provided for the most recent minute
     */
    start_time: number;
  };
};

export type IncrementalTicketExportTimeResponse = TimeBasedExportIncrementalTicketsResponse;

export type IncrementalTicketExportTimeError = unknown;

export type IncrementalTicketExportCursorData = {
  query: {
    /**
     * The cursor pointer to work with for all subsequent exports after the initial request
     */
    cursor?: string;
    /**
     * The time to start the incremental export from. Must be at least one minute in the past. Data isn't provided for the most recent minute
     */
    start_time: number;
  };
};

export type IncrementalTicketExportCursorResponse = CursorBasedExportIncrementalTicketsResponse;

export type IncrementalTicketExportCursorError = unknown;

export type IncrementalUserExportTimeData = {
  query: {
    /**
     * The number of records to return per page
     */
    per_page?: number;
    /**
     * The time to start the incremental export from. Must be at least one minute in the past. Data isn't provided for the most recent minute
     */
    start_time: number;
  };
};

export type IncrementalUserExportTimeResponse = TimeBasedExportIncrementalUsersResponse;

export type IncrementalUserExportTimeError = unknown;

export type IncrementalUserExportCursorData = {
  query: {
    /**
     * The cursor pointer to work with for all subsequent exports after the initial request
     */
    cursor?: string;
    /**
     * The number of records to return per page
     */
    per_page?: number;
    /**
     * The time to start the incremental export from. Must be at least one minute in the past. Data isn't provided for the most recent minute
     */
    start_time: number;
  };
};

export type IncrementalUserExportCursorResponse = CursorBasedExportIncrementalUsersResponse;

export type IncrementalUserExportCursorError = unknown;

export type ListJobStatusesResponse = JobStatusesResponse;

export type ListJobStatusesError = unknown;

export type ShowJobStatusData = {
  path: {
    /**
     * the Id of the Job status
     */
    job_status_id: string;
  };
};

export type ShowJobStatusResponse = JobStatusResponse;

export type ShowJobStatusError = unknown;

export type ShowManyJobStatusesData = {
  query: {
    /**
     * Comma-separated list of job status ids.
     */
    ids: string;
  };
};

export type ShowManyJobStatusesResponse = JobStatusesResponse;

export type ShowManyJobStatusesError = unknown;

export type ListLocalesResponse = LocalesResponse;

export type ListLocalesError = unknown;

export type ShowLocaleByIdData = {
  path: {
    /**
     * The ID or the [BCP-47 code](https://en.wikipedia.org/wiki/IETF_language_tag) of the locale. Examples: es-419, en-us, pr-br
     *
     */
    locale_id: string;
  };
};

export type ShowLocaleByIdResponse = LocaleResponse;

export type ShowLocaleByIdError = unknown;

export type ListLocalesForAgentResponse = LocalesResponse;

export type ListLocalesForAgentError = unknown;

export type ShowCurrentLocaleResponse = LocaleResponse;

export type ShowCurrentLocaleError = unknown;

export type DetectBestLocaleResponse = LocaleResponse;

export type DetectBestLocaleError = unknown;

export type ListAvailablePublicLocalesResponse = LocalesResponse;

export type ListAvailablePublicLocalesError = unknown;

export type ListMacrosData = {
  query?: {
    /**
     * Filter macros by access. Possible values are "personal", "agents", "shared", or "account". The "agents" value returns all personal macros for the account's agents and is only available to admins.
     */
    access?: string;
    /**
     * Filter by active macros if true or inactive macros if false
     */
    active?: boolean;
    /**
     * Filter macros by category
     */
    category?: number;
    /**
     * Filter macros by group
     */
    group_id?: number;
    /**
     * A sideload to include in the response. See [Sideloads](#sideloads-2)
     */
    include?: string;
    /**
     * If true, returns only macros that can be applied to tickets. If false, returns all macros the current user can manage. Default is false
     */
    only_viewable?: boolean;
    /**
     * Possible values are "alphabetical", "created_at", "updated_at", "usage_1h", "usage_24h", "usage_7d", or "usage_30d". Defaults to alphabetical
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type ListMacrosResponse = MacrosResponse;

export type ListMacrosError = unknown;

export type CreateMacroData = {
  body?: {
    macro?: MacroInput;
  };
};

export type CreateMacroResponse = {
  macro?: MacroObject;
};

export type CreateMacroError = unknown;

export type ShowMacroData = {
  path: {
    /**
     * The ID of the macro
     */
    macro_id: number;
  };
};

export type ShowMacroResponse = MacroResponse;

export type ShowMacroError = unknown;

export type UpdateMacroData = {
  body?: {
    macro?: MacroInput;
  };
  path: {
    /**
     * The ID of the macro
     */
    macro_id: number;
  };
};

export type UpdateMacroResponse = {
  macro?: MacroObject;
};

export type UpdateMacroError = unknown;

export type DeleteMacroData = {
  path: {
    /**
     * The ID of the macro
     */
    macro_id: number;
  };
};

export type DeleteMacroResponse = any;

export type DeleteMacroError = unknown;

export type ShowChangesToTicketData = {
  path: {
    /**
     * The ID of the macro
     */
    macro_id: number;
  };
};

export type ShowChangesToTicketResponse = MacroApplyTicketResponse;

export type ShowChangesToTicketError = unknown;

export type ListMacroAttachmentsData = {
  path: {
    /**
     * The ID of the macro
     */
    macro_id: number;
  };
};

export type ListMacroAttachmentsResponse = MacroAttachmentsResponse;

export type ListMacroAttachmentsError = unknown;

export type CreateAssociatedMacroAttachmentData = {
  path: {
    /**
     * The ID of the macro
     */
    macro_id: number;
  };
};

export type CreateAssociatedMacroAttachmentResponse = MacroAttachmentResponse;

export type CreateAssociatedMacroAttachmentError = unknown;

export type ListMacrosActionsResponse = {
  actions?: Array<{
    [key: string]: unknown;
  }>;
};

export type ListMacrosActionsError = unknown;

export type ListActiveMacrosData = {
  query?: {
    /**
     * Filter macros by access. Possible values are "personal", "agents", "shared", or "account". The "agents" value returns all personal macros for the account's agents and is only available to admins.
     */
    access?: string;
    /**
     * Filter macros by category
     */
    category?: number;
    /**
     * Filter macros by group
     */
    group_id?: number;
    /**
     * A sideload to include in the response. See [Sideloads](#sideloads-2)
     */
    include?: string;
    /**
     * Possible values are "alphabetical", "created_at", "updated_at", "usage_1h", "usage_24h", "usage_7d", or "usage_30d". Defaults to alphabetical
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type ListActiveMacrosResponse = MacrosResponse;

export type ListActiveMacrosError = unknown;

export type CreateMacroAttachmentResponse = MacroAttachmentResponse;

export type CreateMacroAttachmentError = unknown;

export type ShowMacroAttachmentData = {
  path: {
    /**
     * The ID of the attachment
     */
    attachment_id: number;
  };
};

export type ShowMacroAttachmentResponse = MacroAttachmentResponse;

export type ShowMacroAttachmentError = unknown;

export type ListMacroCategoriesResponse = MacroCategoriesResponse;

export type ListMacroCategoriesError = unknown;

export type ListMacroActionDefinitionsResponse = {
  definitions?: {
    actions?: Array<{
      [key: string]: unknown;
    }>;
  };
};

export type ListMacroActionDefinitionsError = unknown;

export type DeleteManyMacrosData = {
  query: {
    /**
     * The IDs of the macros to delete
     */
    ids: Array<number>;
  };
};

export type DeleteManyMacrosResponse = any;

export type DeleteManyMacrosError = unknown;

export type ShowDerivedMacroData = {
  query: {
    /**
     * The ID of the macro to replicate
     */
    macro_id: number;
    /**
     * The ID of the ticket from which to build a macro replica
     */
    ticket_id: number;
  };
};

export type ShowDerivedMacroResponse = MacroResponse;

export type ShowDerivedMacroError = unknown;

export type SearchMacroData = {
  query: {
    /**
     * Filter macros by access. Possible values are "personal", "agents", "shared", or "account". The "agents" value returns all personal macros for the account's agents and is only available to admins.
     */
    access?: string;
    /**
     * Filter by active macros if true or inactive macros if false
     */
    active?: boolean;
    /**
     * Filter macros by category
     */
    category?: number;
    /**
     * Filter macros by group
     */
    group_id?: number;
    /**
     * A sideload to include in the response. See [Sideloads](#sideloads-2)
     */
    include?: string;
    /**
     * If true, returns only macros that can be applied to tickets. If false, returns all macros the current user can manage. Default is false
     */
    only_viewable?: boolean;
    /**
     * Query string used to find macros with matching titles
     */
    query: string;
    /**
     * Possible values are "alphabetical", "created_at", "updated_at", or "position". Defaults to alphabetical
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type SearchMacroResponse = MacrosResponse;

export type SearchMacroError = unknown;

export type UpdateManyMacrosData = {
  body?: MacroUpdateManyInput;
};

export type UpdateManyMacrosResponse = MacrosResponse;

export type UpdateManyMacrosError = unknown;

export type ShowEssentialsCardData = {
  path: {
    /**
     * Essentials card type. Example: `zen:user` refers user type
     *
     */
    object_type: string;
  };
};

export type ShowEssentialsCardResponse = EssentialsCardResponse;

export type ShowEssentialsCardError = unknown;

export type UpdateEssentialsCardData = {
  path: {
    /**
     * Essentials card type. Example: `zen:user` refers user type
     *
     */
    object_type: string;
  };
};

export type UpdateEssentialsCardResponse = EssentialsCardResponse;

export type UpdateEssentialsCardError = unknown;

export type DeleteEssentialsCardData = {
  path: {
    /**
     * Essentials card type. Example: `zen:user` refers user type
     *
     */
    object_type: string;
  };
};

export type DeleteEssentialsCardResponse = any;

export type DeleteEssentialsCardError = unknown;

export type ShowEssentialsCardsResponse = EssentialsCardsResponse;

export type ShowEssentialsCardsError = unknown;

export type ListOrganizationFieldsResponse = OrganizationFieldsResponse;

export type ListOrganizationFieldsError = unknown;

export type CreateOrganizationFieldResponse = OrganizationFieldResponse;

export type CreateOrganizationFieldError = unknown;

export type ShowOrganizationFieldData = {
  path: {
    /**
     * The ID or key of the organization field
     */
    organization_field_id: number | string;
  };
};

export type ShowOrganizationFieldResponse = OrganizationFieldResponse;

export type ShowOrganizationFieldError = unknown;

export type UpdateOrganizationFieldData = {
  path: {
    /**
     * The ID or key of the organization field
     */
    organization_field_id: number | string;
  };
};

export type UpdateOrganizationFieldResponse = OrganizationFieldResponse;

export type UpdateOrganizationFieldError = unknown;

export type DeleteOrganizationFieldData = {
  path: {
    /**
     * The ID or key of the organization field
     */
    organization_field_id: number | string;
  };
};

export type DeleteOrganizationFieldResponse = any;

export type DeleteOrganizationFieldError = unknown;

export type ReorderOrganizationFieldResponse = string;

export type ReorderOrganizationFieldError = unknown;

export type ListOrganizationMembershipsResponse = OrganizationMembershipsResponse;

export type ListOrganizationMembershipsError = unknown;

export type CreateOrganizationMembershipResponse = OrganizationMembershipResponse;

export type CreateOrganizationMembershipError = unknown;

export type ShowOrganizationMembershipByIdData = {
  path: {
    /**
     * The ID of the organization membership
     */
    organization_membership_id: number;
  };
};

export type ShowOrganizationMembershipByIdResponse = OrganizationMembershipResponse;

export type ShowOrganizationMembershipByIdError = unknown;

export type DeleteOrganizationMembershipData = {
  path: {
    /**
     * The ID of the organization membership
     */
    organization_membership_id: number;
  };
};

export type DeleteOrganizationMembershipResponse = any;

export type DeleteOrganizationMembershipError = unknown;

export type CreateManyOrganizationMembershipsResponse = JobStatusResponse;

export type CreateManyOrganizationMembershipsError = unknown;

export type DeleteManyOrganizationMembershipsData = {
  query?: {
    /**
     * The IDs of the organization memberships to delete
     */
    ids?: Array<number>;
  };
};

export type DeleteManyOrganizationMembershipsResponse = JobStatusResponse;

export type DeleteManyOrganizationMembershipsError = unknown;

export type ShowOrganizationMergeData = {
  path: {
    /**
     * The ID of the organization merge
     */
    organization_merge_id: string;
  };
};

export type ShowOrganizationMergeResponse = OrganizationMergeResponse;

export type ShowOrganizationMergeError = unknown;

export type ListOrganizationSubscriptionsResponse = OrganizationSubscriptionsResponse;

export type ListOrganizationSubscriptionsError = unknown;

export type CreateOrganizationSubscriptionData = {
  body?: OrganizationSubscriptionCreateRequest;
};

export type CreateOrganizationSubscriptionResponse = OrganizationSubscriptionResponse;

export type CreateOrganizationSubscriptionError = unknown;

export type ShowOrganizationSubscriptionData = {
  path: {
    /**
     * The ID of the organization subscription
     */
    organization_subscription_id: number;
  };
};

export type ShowOrganizationSubscriptionResponse = OrganizationSubscriptionResponse;

export type ShowOrganizationSubscriptionError = unknown;

export type DeleteOrganizationSubscriptionData = {
  path: {
    /**
     * The ID of the organization subscription
     */
    organization_subscription_id: number;
  };
};

export type DeleteOrganizationSubscriptionResponse = any;

export type DeleteOrganizationSubscriptionError = unknown;

export type ListOrganizationsResponse = OrganizationsResponse;

export type ListOrganizationsError = unknown;

export type CreateOrganizationData = {
  body: CreateOrganizationRequest;
};

export type CreateOrganizationResponse = OrganizationResponse;

export type CreateOrganizationError = unknown;

export type ShowOrganizationData = {
  path: {
    /**
     * The ID of an organization
     */
    organization_id: number;
  };
};

export type ShowOrganizationResponse = OrganizationResponse;

export type ShowOrganizationError = unknown;

export type UpdateOrganizationData = {
  path: {
    /**
     * The ID of an organization
     */
    organization_id: number;
  };
};

export type UpdateOrganizationResponse = OrganizationResponse;

export type UpdateOrganizationError = Errors;

export type DeleteOrganizationData = {
  path: {
    /**
     * The ID of an organization
     */
    organization_id: number;
  };
};

export type DeleteOrganizationResponse = any;

export type DeleteOrganizationError = unknown;

export type CreateOrganizationMergeData = {
  body: OrganizationMergeRequest;
  path: {
    /**
     * The ID of an organization
     */
    organization_id: number;
  };
};

export type CreateOrganizationMergeResponse = OrganizationMergeResponse;

export type CreateOrganizationMergeError = unknown;

export type ListOrganizationMergesData = {
  path: {
    /**
     * The ID of an organization
     */
    organization_id: number;
  };
};

export type ListOrganizationMergesResponse = OrganizationMergeListResponse;

export type ListOrganizationMergesError = unknown;

export type OrganizationRelatedData = {
  path: {
    /**
     * The ID of an organization
     */
    organization_id: number;
  };
};

export type OrganizationRelatedResponse = OrganizationsRelatedResponse;

export type OrganizationRelatedError = unknown;

export type AutocompleteOrganizationsData = {
  query: {
    /**
     * The id of a lookup relationship field.  The type of field is determined
     * by the `source` param
     *
     */
    field_id?: string;
    /**
     * A substring of an organization to search for
     */
    name: string;
    /**
     * If a `field_id` is provided, this specifies the type of the field.
     * For example, if the field is on a "zen:user", it references a field on a user
     *
     */
    source?: string;
  };
};

export type AutocompleteOrganizationsResponse = OrganizationsResponse;

export type AutocompleteOrganizationsError = Errors;

export type CountOrganizationsResponse = CountOrganizationResponse;

export type CountOrganizationsError = unknown;

export type CreateManyOrganizationsResponse = JobStatusResponse;

export type CreateManyOrganizationsError = unknown;

export type CreateOrUpdateOrganizationResponse = OrganizationResponse;

export type CreateOrUpdateOrganizationError = unknown;

export type DeleteManyOrganizationsData = {
  query?: {
    /**
     * A list of external ids
     */
    external_ids?: string;
    /**
     * A list of organization ids
     */
    ids?: string;
  };
};

export type DeleteManyOrganizationsResponse = JobStatusResponse;

export type DeleteManyOrganizationsError = unknown;

export type SearchOrganizationsData = {
  query?: {
    /**
     * The external id of an organization
     */
    external_id?: number;
    /**
     * The name of an organization
     */
    name?: string;
  };
};

export type SearchOrganizationsResponse = OrganizationsResponse;

export type SearchOrganizationsError = unknown;

export type ShowManyOrganizationsData = {
  query?: {
    /**
     * A list of external ids
     */
    external_ids?: string;
    /**
     * A list of organization ids
     */
    ids?: string;
  };
};

export type ShowManyOrganizationsResponse = OrganizationsResponse;

export type ShowManyOrganizationsError = unknown;

export type UpdateManyOrganizationsData = {
  query?: {
    /**
     * A list of external ids
     */
    external_ids?: string;
    /**
     * A list of organization ids
     */
    ids?: string;
  };
};

export type UpdateManyOrganizationsResponse = JobStatusResponse;

export type UpdateManyOrganizationsError = unknown;

export type ListTicketProblemsResponse2 = ListTicketProblemsResponse;

export type ListTicketProblemsError = unknown;

export type AutocompleteProblemsData = {
  body?: {
    /**
     * The text to search for
     */
    text?: string;
  };
  query?: {
    /**
     * The text to search for
     */
    text?: string;
  };
};

export type AutocompleteProblemsResponse = ListTicketProblemsResponse;

export type AutocompleteProblemsError = unknown;

export type PushNotificationDevicesData = {
  body?: PushNotificationDevicesRequest;
};

export type PushNotificationDevicesResponse = string;

export type PushNotificationDevicesError = unknown;

export type ListQueuesResponse = QueuesResponse;

export type ListQueuesError = unknown;

export type CreateQueueResponse = QueueResponse;

export type CreateQueueError = unknown;

export type ShowQueueByIdData = {
  path: {
    /**
     * The id of the omnichannel routing queue
     */
    queue_id: string;
  };
};

export type ShowQueueByIdResponse = QueueResponse;

export type ShowQueueByIdError = unknown;

export type UpdateQueueData = {
  path: {
    /**
     * The id of the omnichannel routing queue
     */
    queue_id: string;
  };
};

export type UpdateQueueResponse = QueueResponse;

export type UpdateQueueError = unknown;

export type DeleteQueueData = {
  path: {
    /**
     * The id of the omnichannel routing queue
     */
    queue_id: string;
  };
};

export type DeleteQueueResponse = any;

export type DeleteQueueError = unknown;

export type ListQueueDefinitionsResponse = DefinitionsResponse;

export type ListQueueDefinitionsError = unknown;

export type ListSupportAddressesResponse = SupportAddressesResponse;

export type ListSupportAddressesError = unknown;

export type CreateSupportAddressResponse = SupportAddressResponse;

export type CreateSupportAddressError = unknown;

export type ShowSupportAddressData = {
  path: {
    /**
     * The ID of the support address
     */
    support_address_id: number;
  };
};

export type ShowSupportAddressResponse = SupportAddressResponse;

export type ShowSupportAddressError = unknown;

export type UpdateSupportAddressData = {
  path: {
    /**
     * The ID of the support address
     */
    support_address_id: number;
  };
};

export type UpdateSupportAddressResponse = SupportAddressResponse;

export type UpdateSupportAddressError = unknown;

export type DeleteRecipientAddressData = {
  path: {
    /**
     * The ID of the support address
     */
    support_address_id: number;
  };
};

export type DeleteRecipientAddressResponse = any;

export type DeleteRecipientAddressError = unknown;

export type VerifySupportAddressForwardingData = {
  path: {
    /**
     * The ID of the support address
     */
    support_address_id: number;
  };
};

export type VerifySupportAddressForwardingResponse = string;

export type VerifySupportAddressForwardingError = unknown;

export type GetRelationshipFilterDefinitionsData = {
  path: {
    /**
     * The target type for which you would like to see filter definitions.
     * The options are "zen:user", "zen:ticket", "zen:organization", and "zen:custom_object:CUSTOM_OBJECT_KEY"
     *
     */
    target_type: string;
  };
  query?: {
    /**
     * The source type for which you would like to see filter definitions.
     * The options are "zen:user", "zen:ticket", and "zen:organization"
     *
     */
    source_type?: string;
  };
};

export type GetRelationshipFilterDefinitionsResponse = RelationshipFilterDefinitionResponse;

export type GetRelationshipFilterDefinitionsError = unknown;

export type ListRequestsData = {
  query?: {
    /**
     * Possible values are "updated_at", "created_at"
     */
    sort_by?: string;
    /**
     * One of "asc", "desc". Defaults to "asc"
     */
    sort_order?: string;
  };
};

export type ListRequestsResponse = RequestsResponse;

export type ListRequestsError = unknown;

export type CreateRequestResponse = RequestResponse;

export type CreateRequestError = unknown;

export type ShowRequestData = {
  path: {
    /**
     * The ID of the request
     */
    request_id: number;
  };
};

export type ShowRequestResponse = RequestResponse;

export type ShowRequestError = unknown;

export type UpdateRequestData = {
  path: {
    /**
     * The ID of the request
     */
    request_id: number;
  };
};

export type UpdateRequestResponse = RequestResponse;

export type UpdateRequestError = unknown;

export type ListCommentsData = {
  path: {
    /**
     * The ID of the request
     */
    request_id: number;
  };
  query?: {
    /**
     * One of "agent", "end_user". If not specified it does not filter
     */
    role?: string;
    /**
     * Filters the comments from the given datetime
     */
    since?: string;
  };
};

export type ListCommentsResponse = TicketCommentsResponse;

export type ListCommentsError = unknown;

export type ShowCommentData = {
  path: {
    /**
     * The ID of the request
     */
    request_id: number;
    /**
     * The ID of the ticket comment
     */
    ticket_comment_id: number;
  };
};

export type ShowCommentResponse = TicketCommentResponse;

export type ShowCommentError = unknown;

export type SearchRequestsData = {
  query?: {
    /**
     * The syntax and matching logic for the string is detailed in the [Zendesk Support search reference](https://support.zendesk.com/hc/en-us/articles/203663226). See also [Query basics](/api-reference/ticketing/ticket-management/search/#query-basics) in the Tickets API doc.
     */
    query?: string;
  };
};

export type SearchRequestsResponse = RequestsResponse;

export type SearchRequestsError = unknown;

export type ListResourceCollectionsResponse = ResourceCollectionsResponse;

export type ListResourceCollectionsError = unknown;

export type CreateResourceCollectionResponse = JobStatusResponse;

export type CreateResourceCollectionError = unknown;

export type RetrieveResourceCollectionData = {
  path: {
    /**
     * The id of the resource collection
     */
    resource_collection_id: number;
  };
};

export type RetrieveResourceCollectionResponse = ResourceCollectionResponse;

export type RetrieveResourceCollectionError = unknown;

export type UpdateResourceCollectionData = {
  path: {
    /**
     * The id of the resource collection
     */
    resource_collection_id: number;
  };
};

export type UpdateResourceCollectionResponse = JobStatusResponse;

export type UpdateResourceCollectionError = unknown;

export type DeleteResourceCollectionData = {
  path: {
    /**
     * The id of the resource collection
     */
    resource_collection_id: number;
  };
};

export type DeleteResourceCollectionResponse = JobStatusResponse;

export type DeleteResourceCollectionError = unknown;

export type ListAgentAttributeValuesData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type ListAgentAttributeValuesResponse = SkillBasedRoutingAttributeValuesResponse;

export type ListAgentAttributeValuesError = unknown;

export type SetAgentAttributeValuesData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type SetAgentAttributeValuesResponse = SkillBasedRoutingAttributeValuesResponse;

export type SetAgentAttributeValuesError = unknown;

export type ListAccountAttributesResponse = SkillBasedRoutingAttributesResponse;

export type ListAccountAttributesError = unknown;

export type CreateAttributeResponse = SkillBasedRoutingAttributeResponse;

export type CreateAttributeError = unknown;

export type ShowAttributeData = {
  path: {
    /**
     * The ID of the skill-based routing attribute
     */
    attribute_id: string;
  };
};

export type ShowAttributeResponse = SkillBasedRoutingAttributeResponse;

export type ShowAttributeError = unknown;

export type UpdateAttributeData = {
  path: {
    /**
     * The ID of the skill-based routing attribute
     */
    attribute_id: string;
  };
};

export type UpdateAttributeResponse = SkillBasedRoutingAttributeResponse;

export type UpdateAttributeError = unknown;

export type DeleteAttributeData = {
  path: {
    /**
     * The ID of the skill-based routing attribute
     */
    attribute_id: string;
  };
};

export type DeleteAttributeResponse = any;

export type DeleteAttributeError = unknown;

export type ListAttributeValuesData = {
  path: {
    /**
     * The ID of the skill-based routing attribute
     */
    attribute_id: string;
  };
};

export type ListAttributeValuesResponse = SkillBasedRoutingAttributeValuesResponse;

export type ListAttributeValuesError = unknown;

export type CreateAttributeValueData = {
  path: {
    /**
     * The ID of the skill-based routing attribute
     */
    attribute_id: string;
  };
};

export type CreateAttributeValueResponse = SkillBasedRoutingAttributeValueResponse;

export type CreateAttributeValueError = unknown;

export type ShowAttributeValueData = {
  path: {
    /**
     * The ID of the skill-based routing attribute
     */
    attribute_id: string;
    /**
     * The ID of the skill-based routing attribute value
     */
    attribute_value_id: string;
  };
};

export type ShowAttributeValueResponse = SkillBasedRoutingAttributeValueResponse;

export type ShowAttributeValueError = unknown;

export type UpdateAttributeValueData = {
  path: {
    /**
     * The ID of the skill-based routing attribute
     */
    attribute_id: string;
    /**
     * The ID of the skill-based routing attribute value
     */
    attribute_value_id: string;
  };
};

export type UpdateAttributeValueResponse = SkillBasedRoutingAttributeValueResponse;

export type UpdateAttributeValueError = unknown;

export type DeleteAttributeValueData = {
  path: {
    /**
     * The ID of the skill-based routing attribute
     */
    attribute_id: string;
    /**
     * The ID of the skill-based routing attribute value
     */
    attribute_value_id: string;
  };
};

export type DeleteAttributeValueResponse = any;

export type DeleteAttributeValueError = unknown;

export type ListRoutingAttributeDefinitionsResponse = SkillBasedRoutingAttributeDefinitions;

export type ListRoutingAttributeDefinitionsError = unknown;

export type ListTicketsFullfilledByUserData = {
  query: {
    /**
     * The IDs of the relevant tickets to check for matching attributes
     */
    ticket_ids: number;
  };
};

export type ListTicketsFullfilledByUserResponse = SkillBasedRoutingTicketFulfilledResponse;

export type ListTicketsFullfilledByUserError = unknown;

export type ListTicketAttributeValuesData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type ListTicketAttributeValuesResponse = SkillBasedRoutingAttributeValuesResponse;

export type ListTicketAttributeValuesError = unknown;

export type SetTicketAttributeValuesData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type SetTicketAttributeValuesResponse = SkillBasedRoutingAttributeValuesResponse;

export type SetTicketAttributeValuesError = unknown;

export type ListSatisfactionRatingsResponse = SatisfactionRatingsResponse;

export type ListSatisfactionRatingsError = unknown;

export type ShowSatisfactionRatingData = {
  path: {
    /**
     * The id of the satisfaction rating to retrieve
     */
    satisfaction_rating_id: number;
  };
};

export type ShowSatisfactionRatingResponse = SatisfactionRatingResponse;

export type ShowSatisfactionRatingError = unknown;

export type CountSatisfactionRatingsResponse = SatisfactionRatingsCountResponse;

export type CountSatisfactionRatingsError = unknown;

export type ListSatisfactionRatingReasonsResponse = SatisfactionReasonsResponse;

export type ListSatisfactionRatingReasonsError = unknown;

export type ShowSatisfactionRatingsData = {
  path: {
    /**
     * The id of the satisfaction rating reason
     */
    satisfaction_reason_id: number;
  };
};

export type ShowSatisfactionRatingsResponse = SatisfactionReasonResponse;

export type ShowSatisfactionRatingsError = unknown;

export type ListSearchResultsData = {
  query: {
    /**
     * The search query. See [Query basics](#query-basics) above. For details on the query syntax, see the [Zendesk Support search reference](https://support.zendesk.com/hc/en-us/articles/203663226)
     */
    query: string;
    /**
     * One of `updated_at`, `created_at`, `priority`, `status`, or `ticket_type`. Defaults to sorting by relevance
     */
    sort_by?: string;
    /**
     * One of `asc` or `desc`.  Defaults to `desc`
     */
    sort_order?: string;
  };
};

export type ListSearchResultsResponse = SearchResponse;

export type ListSearchResultsError = unknown;

export type CountSearchResultsData = {
  query: {
    /**
     * The search query
     */
    query: string;
  };
};

export type CountSearchResultsResponse = SearchCountResponse;

export type CountSearchResultsError = unknown;

export type ExportSearchResultsData = {
  query: {
    /**
     * The object type returned by the export query. Can be `ticket`, `organization`, `user`, or `group`.
     */
    'filter[type]'?: string;
    /**
     * The number of results shown in a page.
     */
    'page[size]'?: number;
    /**
     * The search query. See [Query basics](#query-basics) above. For details on the query syntax, see the [Zendesk Support search reference](https://support.zendesk.com/hc/en-us/articles/203663226)
     */
    query: string;
  };
};

export type ExportSearchResultsResponse = SearchExportResponse;

export type ExportSearchResultsError = unknown;

export type ListSessionsData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type ListSessionsResponse = SessionsResponse;

export type ListSessionsError = unknown;

export type ListSharingAgreementsResponse = SharingAgreementsResponse;

export type ListSharingAgreementsError = unknown;

export type CreateSharingAgreementResponse = SharingAgreementResponse;

export type CreateSharingAgreementError = unknown;

export type ShowSharingAgreementData = {
  path: {
    /**
     * The ID of the sharing agreement
     */
    sharing_agreement_id: number;
  };
};

export type ShowSharingAgreementResponse = SharingAgreementResponse;

export type ShowSharingAgreementError = unknown;

export type UpdateSharingAgreementData = {
  path: {
    /**
     * The ID of the sharing agreement
     */
    sharing_agreement_id: number;
  };
};

export type UpdateSharingAgreementResponse = SharingAgreementResponse;

export type UpdateSharingAgreementError = unknown;

export type DeleteSharingAgreementData = {
  path: {
    /**
     * The ID of the sharing agreement
     */
    sharing_agreement_id: number;
  };
};

export type DeleteSharingAgreementResponse = any;

export type DeleteSharingAgreementError = unknown;

export type RecordNewSkipResponse = TicketSkipCreation;

export type RecordNewSkipError = unknown;

export type ListSlaPoliciesResponse = SLAPoliciesResponse;

export type ListSlaPoliciesError = unknown;

export type CreateSlaPolicyResponse = SLAPolicyResponse;

export type CreateSlaPolicyError = unknown;

export type ShowSlaPolicyData = {
  path: {
    /**
     * The ID of the SLA Policy
     */
    sla_policy_id: number;
  };
};

export type ShowSlaPolicyResponse = SLAPolicyResponse;

export type ShowSlaPolicyError = unknown;

export type UpdateSlaPolicyData = {
  path: {
    /**
     * The ID of the SLA Policy
     */
    sla_policy_id: number;
  };
};

export type UpdateSlaPolicyResponse = SLAPolicyResponse;

export type UpdateSlaPolicyError = unknown;

export type DeleteSlaPolicyData = {
  path: {
    /**
     * The ID of the SLA Policy
     */
    sla_policy_id: number;
  };
};

export type DeleteSlaPolicyResponse = any;

export type DeleteSlaPolicyError = unknown;

export type RetrieveSlaPolicyFilterDefinitionItemsResponse = SLAPolicyFilterDefinitionResponse;

export type RetrieveSlaPolicyFilterDefinitionItemsError = unknown;

export type ReorderSlaPoliciesData = {
  query?: {
    /**
     * The IDs of the SLA Policies to reorder
     */
    sla_policy_ids?: Array<number>;
  };
};

export type ReorderSlaPoliciesResponse = string;

export type ReorderSlaPoliciesError = unknown;

export type ListSuspendedTicketsData = {
  query?: {
    /**
     * The field to sort the suspended tickets by. One of "author_email", "cause", "created_at", or "subject"
     */
    sort_by?: string;
    /**
     * The order in which to sort the suspended tickets.  This can take value `asc` or `desc`.
     */
    sort_order?: string;
  };
};

export type ListSuspendedTicketsResponse = SuspendedTicketsResponse;

export type ListSuspendedTicketsError = unknown;

export type ShowSuspendedTicketsData = {
  path: {
    /**
     * id of the suspended ticket
     */
    id: number;
  };
};

export type ShowSuspendedTicketsResponse = SuspendedTicketsResponse;

export type ShowSuspendedTicketsError = unknown;

export type DeleteSuspendedTicketData = {
  path: {
    /**
     * id of the suspended ticket
     */
    id: number;
  };
};

export type DeleteSuspendedTicketResponse = any;

export type DeleteSuspendedTicketError = unknown;

export type RecoverSuspendedTicketData = {
  path: {
    /**
     * id of the suspended ticket
     */
    id: number;
  };
};

export type RecoverSuspendedTicketResponse2 = RecoverSuspendedTicketResponse;

export type RecoverSuspendedTicketError = RecoverSuspendedTicketUnprocessableContentResponse;

export type SuspendedTicketsAttachmentsData = {
  path: {
    /**
     * id of the suspended ticket
     */
    id: number;
  };
};

export type SuspendedTicketsAttachmentsResponse2 = SuspendedTicketsAttachmentsResponse;

export type SuspendedTicketsAttachmentsError = unknown;

export type DeleteSuspendedTicketsData = {
  query: {
    /**
     * A comma separated list of ids of suspended tickets to delete.
     */
    ids: string;
  };
};

export type DeleteSuspendedTicketsResponse = any;

export type DeleteSuspendedTicketsError = unknown;

export type ExportSuspendedTicketsResponse = SuspendedTicketsExportResponse;

export type ExportSuspendedTicketsError = unknown;

export type RecoverSuspendedTicketsData = {
  query: {
    /**
     * A comma separated list of ids of suspended tickets to recover.
     */
    ids: string;
  };
};

export type RecoverSuspendedTicketsResponse2 = RecoverSuspendedTicketsResponse;

export type RecoverSuspendedTicketsError = unknown;

export type ListTagsResponse = TagsResponse;

export type ListTagsError = unknown;

export type CountTagsResponse = TagCountResponse;

export type CountTagsError = unknown;

export type ListTargetFailuresResponse = TargetFailuresResponse;

export type ListTargetFailuresError = unknown;

export type ShowTargetFailureData = {
  path: {
    /**
     * The ID of the target failure
     */
    target_failure_id: number;
  };
};

export type ShowTargetFailureResponse = TargetFailureResponse;

export type ShowTargetFailureError = unknown;

export type ListTargetsResponse = TargetsResponse;

export type ListTargetsError = unknown;

export type CreateTargetResponse = TargetResponse;

export type CreateTargetError = unknown;

export type ShowTargetData = {
  path: {
    /**
     * The ID of the target
     */
    target_id: number;
  };
};

export type ShowTargetResponse = TargetResponse;

export type ShowTargetError = unknown;

export type UpdateTargetData = {
  path: {
    /**
     * The ID of the target
     */
    target_id: number;
  };
};

export type UpdateTargetResponse = TargetResponse;

export type UpdateTargetError = unknown;

export type DeleteTargetData = {
  path: {
    /**
     * The ID of the target
     */
    target_id: number;
  };
};

export type DeleteTargetResponse = any;

export type DeleteTargetError = unknown;

export type ListTicketAuditsData = {
  query?: {
    /**
     * Maximum number of results returned
     */
    limit?: number;
  };
};

export type ListTicketAuditsResponse = TicketAuditsResponse;

export type ListTicketAuditsError = unknown;

export type ListTicketFieldsData = {
  query?: {
    /**
     * Displays the `creator_user_id` and `creator_app_name` properties. If the ticket field is created
     * by an app, `creator_app_name` is the name of the app and `creator_user_id` is `-1`. If the ticket field
     * is not created by an app, `creator_app_name` is null
     *
     */
    creator?: boolean;
    /**
     * Forces the `title_in_portal` property to return a dynamic content variant for the specified locale.
     * Only accepts [active locale ids](/api-reference/ticketing/account-configuration/locales/#list-locales).
     * Example: `locale="de"`.
     *
     */
    locale?: string;
  };
};

export type ListTicketFieldsResponse = TicketFieldsResponse;

export type ListTicketFieldsError = unknown;

export type CreateTicketFieldResponse = TicketFieldResponse;

export type CreateTicketFieldError = unknown;

export type ShowTicketfieldData = {
  path: {
    /**
     * The ID of the ticket field
     */
    ticket_field_id: number;
  };
  query?: {
    /**
     * If true, displays the `creator_user_id` and `creator_app_name` properties. If the ticket field is created
     * by an app, `creator_app_name` is the name of the app and `creator_user_id` is `-1`. If the ticket field
     * is not created by an app, then `creator_app_name` is null
     *
     */
    creator?: boolean;
  };
};

export type ShowTicketfieldResponse = TicketFieldResponse;

export type ShowTicketfieldError = unknown;

export type UpdateTicketFieldData = {
  path: {
    /**
     * The ID of the ticket field
     */
    ticket_field_id: number;
  };
  query?: {
    /**
     * If true, displays the `creator_user_id` and `creator_app_name` properties. If the ticket field is created
     * by an app, `creator_app_name` is the name of the app and `creator_user_id` is `-1`. If the ticket field
     * is not created by an app, then `creator_app_name` is null
     *
     */
    creator?: boolean;
  };
};

export type UpdateTicketFieldResponse = TicketFieldResponse;

export type UpdateTicketFieldError = unknown;

export type DeleteTicketFieldData = {
  path: {
    /**
     * The ID of the ticket field
     */
    ticket_field_id: number;
  };
  query?: {
    /**
     * If true, displays the `creator_user_id` and `creator_app_name` properties. If the ticket field is created
     * by an app, `creator_app_name` is the name of the app and `creator_user_id` is `-1`. If the ticket field
     * is not created by an app, then `creator_app_name` is null
     *
     */
    creator?: boolean;
  };
};

export type DeleteTicketFieldResponse = any;

export type DeleteTicketFieldError = unknown;

export type ListTicketFieldOptionsData = {
  path: {
    /**
     * The ID of the ticket field
     */
    ticket_field_id: number;
  };
};

export type ListTicketFieldOptionsResponse = CustomFieldOptionsResponse;

export type ListTicketFieldOptionsError = unknown;

export type CreateOrUpdateTicketFieldOptionData = {
  path: {
    /**
     * The ID of the ticket field
     */
    ticket_field_id: number;
  };
};

export type CreateOrUpdateTicketFieldOptionResponse = CustomFieldOptionResponse;

export type CreateOrUpdateTicketFieldOptionError = unknown;

export type ShowTicketFieldOptionData = {
  path: {
    /**
     * The ID of the ticket field
     */
    ticket_field_id: number;
    /**
     * The ID of the ticket field option
     */
    ticket_field_option_id: number;
  };
};

export type ShowTicketFieldOptionResponse = CustomFieldOptionResponse;

export type ShowTicketFieldOptionError = unknown;

export type DeleteTicketFieldOptionData = {
  path: {
    /**
     * The ID of the ticket field
     */
    ticket_field_id: number;
    /**
     * The ID of the ticket field option
     */
    ticket_field_option_id: number;
  };
};

export type DeleteTicketFieldOptionResponse = any;

export type DeleteTicketFieldOptionError = unknown;

export type CountTicketFieldsResponse = TicketFieldCountResponse;

export type CountTicketFieldsError = unknown;

export type ReorderTicketFieldsResponse = string;

export type ReorderTicketFieldsError = unknown;

export type ListTicketFormsData = {
  query?: {
    /**
     * true returns active ticket forms; false returns inactive ticket forms. If not present, returns both
     */
    active?: boolean;
    /**
     * true returns the ticket forms of the brand specified by the url's subdomain
     */
    associated_to_brand?: boolean;
    /**
     * true returns ticket forms where `end_user_visible`; false returns ticket forms that are not end-user visible. If not present, returns both
     */
    end_user_visible?: boolean;
    /**
     * true returns the default ticket form when the criteria defined by the parameters results in a set without active and end-user visible ticket forms
     */
    fallback_to_default?: boolean;
  };
};

export type ListTicketFormsResponse = TicketFormsResponse;

export type ListTicketFormsError = unknown;

export type CreateTicketFormResponse = TicketFormResponse;

export type CreateTicketFormError = unknown;

export type ShowTicketFormData = {
  path: {
    /**
     * The ID of the ticket form
     */
    ticket_form_id: number;
  };
};

export type ShowTicketFormResponse = TicketFormResponse;

export type ShowTicketFormError = unknown;

export type UpdateTicketFormData = {
  path: {
    /**
     * The ID of the ticket form
     */
    ticket_form_id: number;
  };
};

export type UpdateTicketFormResponse = TicketFormResponse;

export type UpdateTicketFormError = unknown;

export type DeleteTicketFormData = {
  path: {
    /**
     * The ID of the ticket form
     */
    ticket_form_id: number;
  };
};

export type DeleteTicketFormResponse = any;

export type DeleteTicketFormError = unknown;

export type CloneTicketFormData = {
  path: {
    /**
     * The ID of the ticket form
     */
    ticket_form_id: number;
  };
};

export type CloneTicketFormResponse = TicketFormResponse;

export type CloneTicketFormError = unknown;

export type ReorderTicketFormsResponse = TicketFormsResponse;

export type ReorderTicketFormsError = unknown;

export type ShowManyTicketFormsData = {
  query: {
    /**
     * true returns active ticket forms; false returns inactive ticket forms. If not present, returns both
     */
    active?: boolean;
    /**
     * true returns the ticket forms of the brand specified by the url's subdomain
     */
    associated_to_brand?: boolean;
    /**
     * true returns ticket forms where `end_user_visible`; false returns ticket forms that are not end-user visible. If not present, returns both
     */
    end_user_visible?: boolean;
    /**
     * true returns the default ticket form when the criteria defined by the parameters results in a set without active and end-user visible ticket forms
     */
    fallback_to_default?: boolean;
    /**
     * IDs of the ticket forms to be shown
     */
    ids: string;
  };
};

export type ShowManyTicketFormsResponse = TicketFormsResponse;

export type ShowManyTicketFormsError = unknown;

export type ListTicketMetricsResponse = TicketMetricsResponse;

export type ListTicketMetricsError = unknown;

export type ShowTicketMetricsData = {
  path: {
    /**
     * The id of the ticket metric to retrieve
     */
    ticket_metric_id: string;
  };
};

export type ShowTicketMetricsResponse = TicketMetricsByTicketMetricIdResponse;

export type ShowTicketMetricsError = unknown;

export type ListTicketsData = {
  query?: {
    /**
     * Lists tickets by external id. External ids don't have to be unique for each ticket. As a result, the request may return multiple tickets with the same external id.
     */
    external_id?: string;
  };
};

export type ListTicketsResponse = TicketsResponse;

export type ListTicketsError = unknown;

export type CreateTicketData = {
  body?: TicketCreateRequest;
};

export type CreateTicketResponse = TicketResponse;

export type CreateTicketError = unknown;

export type ShowTicketData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type ShowTicketResponse = TicketResponse;

export type ShowTicketError = unknown;

export type UpdateTicketData = {
  body?: TicketUpdateRequest;
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type UpdateTicketResponse = TicketUpdateResponse;

export type UpdateTicketError = unknown;

export type DeleteTicketData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type DeleteTicketResponse = any;

export type DeleteTicketError = unknown;

export type ListAuditsForTicketData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type ListAuditsForTicketResponse = TicketAuditsResponseNoneCursor;

export type ListAuditsForTicketError = unknown;

export type ShowTicketAuditData = {
  path: {
    /**
     * The ID of the ticket audit
     */
    ticket_audit_id: number;
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type ShowTicketAuditResponse = TicketAuditResponse;

export type ShowTicketAuditError = unknown;

export type MakeTicketCommentPrivateFromAuditsData = {
  path: {
    /**
     * The ID of the ticket audit
     */
    ticket_audit_id: number;
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type MakeTicketCommentPrivateFromAuditsResponse = string;

export type MakeTicketCommentPrivateFromAuditsError = unknown;

export type CountAuditsForTicketData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type CountAuditsForTicketResponse = TicketAuditsCountResponse;

export type CountAuditsForTicketError = unknown;

export type ListTicketCollaboratorsData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type ListTicketCollaboratorsResponse2 = ListTicketCollaboratorsResponse;

export type ListTicketCollaboratorsError = unknown;

export type ListTicketCommentsData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
  query?: {
    /**
     * Accepts "users". Use this parameter to list email CCs by side-loading users. Example: `?include=users`. **Note**: If the comment source is email, a deleted user will be represented as the CCd email address. If the comment source is anything else, a deleted user will be represented as the user name.
     */
    include?: string;
    /**
     * Default is false. When true, inline images are also listed as attachments in the response
     */
    include_inline_images?: boolean;
  };
};

export type ListTicketCommentsResponse = TicketCommentsResponse;

export type ListTicketCommentsError = unknown;

export type RedactCommentAttachmentData = {
  path: {
    /**
     * The ID of the attachment
     */
    attachment_id: number;
    /**
     * The ID of the comment
     */
    comment_id: number;
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type RedactCommentAttachmentResponse = AttachmentResponse;

export type RedactCommentAttachmentError = unknown;

export type MakeTicketCommentPrivateData = {
  path: {
    /**
     * The ID of the ticket comment
     */
    ticket_comment_id: number;
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type MakeTicketCommentPrivateResponse = string;

export type MakeTicketCommentPrivateError = unknown;

export type RedactStringInCommentData = {
  path: {
    /**
     * The ID of the ticket comment
     */
    ticket_comment_id: number;
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type RedactStringInCommentResponse = TicketCommentResponse;

export type RedactStringInCommentError = unknown;

export type CountTicketCommentsData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type CountTicketCommentsResponse = TicketCommentsCountResponse;

export type CountTicketCommentsError = unknown;

export type ListTicketEmailCcsData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type ListTicketEmailCcsResponse = ListTicketEmailCCsResponse;

export type ListTicketEmailCcsError = unknown;

export type ListTicketFollowersData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type ListTicketFollowersResponse2 = ListTicketFollowersResponse;

export type ListTicketFollowersError = unknown;

export type ListTicketIncidentsData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type ListTicketIncidentsResponse2 = ListTicketIncidentsResponse;

export type ListTicketIncidentsError = unknown;

export type ShowTicketAfterChangesData = {
  path: {
    /**
     * The ID of the macro
     */
    macro_id: number;
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type ShowTicketAfterChangesResponse = MacroApplyTicketResponse;

export type ShowTicketAfterChangesError = unknown;

export type MarkTicketAsSpamAndSuspendRequesterData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type MarkTicketAsSpamAndSuspendRequesterResponse = string;

export type MarkTicketAsSpamAndSuspendRequesterError = unknown;

export type MergeTicketsIntoTargetTicketData = {
  body?: TicketMergeInput;
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type MergeTicketsIntoTargetTicketResponse = JobStatusResponse;

export type MergeTicketsIntoTargetTicketError = unknown;

export type TicketRelatedInformationData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type TicketRelatedInformationResponse = TicketRelatedInformation;

export type TicketRelatedInformationError = unknown;

export type CreateTicketSatisfactionRatingData = {
  path: {
    /**
     * The id of the ticket
     */
    ticket_id: number;
  };
};

export type CreateTicketSatisfactionRatingResponse = SatisfactionRatingResponse;

export type CreateTicketSatisfactionRatingError = unknown;

export type ListResourceTagsData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type ListResourceTagsResponse = TagsByObjectIdResponse;

export type ListResourceTagsError = unknown;

export type SetTagsTicketData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type SetTagsTicketResponse = TagsByObjectIdResponse;

export type SetTagsTicketError = unknown;

export type PutTagsTicketData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type PutTagsTicketResponse = TagsByObjectIdResponse;

export type PutTagsTicketError = unknown;

export type DeleteTagsTicketData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
  };
};

export type DeleteTagsTicketResponse = any;

export type DeleteTagsTicketError = unknown;

export type CountTicketsResponse = {
  count?: {
    refreshed_at?: string;
    value?: number;
  };
};

export type CountTicketsError = unknown;

export type TicketsCreateManyData = {
  body?: TicketsCreateRequest;
};

export type TicketsCreateManyResponse = JobStatusResponse;

export type TicketsCreateManyError = unknown;

export type BulkDeleteTicketsData = {
  query: {
    /**
     * Comma-separated list of ticket ids
     */
    ids: string;
  };
};

export type BulkDeleteTicketsResponse = JobStatusResponse;

export type BulkDeleteTicketsError = unknown;

export type MarkManyTicketsAsSpamData = {
  query: {
    /**
     * Comma-separated list of ticket ids
     */
    ids: string;
  };
};

export type MarkManyTicketsAsSpamResponse = JobStatusResponse;

export type MarkManyTicketsAsSpamError = unknown;

export type TicketsShowManyData = {
  query: {
    /**
     * Comma-separated list of ticket ids
     */
    ids: string;
  };
};

export type TicketsShowManyResponse = TicketsResponse;

export type TicketsShowManyError = unknown;

export type TicketsUpdateManyData = {
  query?: {
    /**
     * Comma-separated list of ticket ids
     */
    ids?: string;
  };
};

export type TicketsUpdateManyResponse = JobStatusResponse;

export type TicketsUpdateManyError = unknown;

export type ListTriggerCategoriesData = {
  query?: {
    /**
     * Allowed sideloads
     */
    include?: 'rule_counts';
    /**
     * Pagination parameters
     */
    page?: {
      after?: string;
      before?: string;
      size?: number;
    };
    /**
     * Sort parameters
     */
    sort?: 'position' | '-position' | 'name' | '-name' | 'created_at' | '-created_at' | 'updated_at' | '-updated_at';
  };
};

export type ListTriggerCategoriesResponse = TriggerCategoriesResponse & Pagination;

export type ListTriggerCategoriesError = Errors;

export type CreateTriggerCategoryData = {
  body: {
    trigger_category?: TriggerCategoryRequest & TriggerCategoryRequestRequired;
  };
};

export type CreateTriggerCategoryResponse = TriggerCategoryResponse;

export type CreateTriggerCategoryError = Errors;

export type ShowTriggerCategoryByIdData = {
  path: {
    /**
     * The id of the ticket trigger category to retrieve
     */
    trigger_category_id: string;
  };
};

export type ShowTriggerCategoryByIdResponse = TriggerCategoryResponse;

export type ShowTriggerCategoryByIdError = Errors;

export type UpdateTriggerCategoryData = {
  body: {
    trigger_category?: TriggerCategoryRequest;
  };
  path: {
    /**
     * The id of the ticket trigger category to update
     */
    trigger_category_id: string;
  };
};

export type UpdateTriggerCategoryResponse = TriggerCategoryResponse;

export type UpdateTriggerCategoryError = Errors;

export type DeleteTriggerCategoryData = {
  path: {
    /**
     * The id of the ticket trigger category to delete
     */
    trigger_category_id: string;
  };
};

export type DeleteTriggerCategoryResponse = any;

export type DeleteTriggerCategoryError = Errors;

export type BatchOperateTriggerCategoriesData = {
  body: BatchJobRequest;
};

export type BatchOperateTriggerCategoriesResponse = BatchJobResponse;

export type BatchOperateTriggerCategoriesError = BatchJobResponse;

export type ListTriggersData = {
  query?: {
    /**
     * Filter by active triggers if true or inactive triggers if false
     */
    active?: boolean;
    /**
     * Filter triggers by category ID
     */
    category_id?: string;
    /**
     * Cursor-based pagination only. Possible values are "alphabetical", "created_at", "updated_at", or "position".
     */
    sort?: string;
    /**
     * Offset pagination only. Possible values are "alphabetical", "created_at", "updated_at", "usage_1h", "usage_24h", or "usage_7d". Defaults to "position"
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type ListTriggersResponse = TriggersResponse;

export type ListTriggersError = unknown;

export type CreateTriggerData = {
  body: TriggerWithCategoryRequest;
};

export type CreateTriggerResponse = TriggerResponse;

export type CreateTriggerError = unknown;

export type GetTriggerData = {
  path: {
    /**
     * The ID of the trigger
     */
    trigger_id: number;
  };
};

export type GetTriggerResponse = TriggerResponse;

export type GetTriggerError = unknown;

export type UpdateTriggerData = {
  body: TriggerWithCategoryRequest;
  path: {
    /**
     * The ID of the trigger
     */
    trigger_id: number;
  };
};

export type UpdateTriggerResponse = TriggerResponse;

export type UpdateTriggerError = unknown;

export type DeleteTriggerData = {
  path: {
    /**
     * The ID of the trigger
     */
    trigger_id: number;
  };
};

export type DeleteTriggerResponse = any;

export type DeleteTriggerError = unknown;

export type ListTriggerRevisionsData = {
  path: {
    /**
     * The ID of the trigger
     */
    trigger_id: number;
  };
};

export type ListTriggerRevisionsResponse = TriggerRevisionsResponse;

export type ListTriggerRevisionsError = unknown;

export type TriggerRevisionData = {
  path: {
    /**
     * The ID of the trigger
     */
    trigger_id: number;
    /**
     * The ID of the revision for a particular trigger
     */
    trigger_revision_id: number;
  };
};

export type TriggerRevisionResponse2 = TriggerRevisionResponse;

export type TriggerRevisionError = unknown;

export type ListActiveTriggersData = {
  query?: {
    /**
     * Filter triggers by category ID
     */
    category_id?: string;
    /**
     * Cursor-based pagination only. Possible values are "alphabetical", "created_at", "updated_at", or "position".
     */
    sort?: string;
    /**
     * Offset pagination only. Possible values are "alphabetical", "created_at", "updated_at", "usage_1h", "usage_24h", or "usage_7d". Defaults to "position"
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type ListActiveTriggersResponse = TriggersResponse;

export type ListActiveTriggersError = unknown;

export type ListTriggerActionConditionDefinitionsResponse = TriggerDefinitionResponse;

export type ListTriggerActionConditionDefinitionsError = unknown;

export type DeleteManyTriggersData = {
  query: {
    /**
     * A comma separated list of trigger IDs
     */
    ids: string;
  };
};

export type DeleteManyTriggersResponse = any;

export type DeleteManyTriggersError = unknown;

export type ReorderTriggersResponse = TriggerResponse;

export type ReorderTriggersError = unknown;

export type SearchTriggersData = {
  query: {
    /**
     * Filter by active triggers if true or inactive triggers if false
     */
    active?: boolean;
    /**
     * Trigger attribute filters for the search. See [Filter](#filter)
     */
    filter?: {
      json?: TriggerObject;
    };
    /**
     * A sideload to include in the response. See [Sideloads](#sideloads-2)
     */
    include?: string;
    /**
     * Query string used to find all triggers with matching title
     */
    query: string;
    /**
     * Cursor-based pagination only. Possible values are "alphabetical", "created_at", "updated_at", or "position".
     */
    sort?: string;
    /**
     * Offset pagination only. Possible values are "alphabetical", "created_at", "updated_at", "usage_1h", "usage_24h", or "usage_7d". Defaults to "position"
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type SearchTriggersResponse = TriggersResponse;

export type SearchTriggersError = unknown;

export type UpdateManyTriggersData = {
  body: TriggerBulkUpdateRequest;
};

export type UpdateManyTriggersResponse = TriggersResponse;

export type UpdateManyTriggersError = unknown;

export type UploadFilesResponse = AttachmentUploadResponse;

export type UploadFilesError = unknown;

export type DeleteUploadData = {
  path: {
    /**
     * The token of the uploaded attachment
     */
    token: string;
  };
};

export type DeleteUploadResponse = any;

export type DeleteUploadError = unknown;

export type ListUserFieldsResponse = UserFieldsResponse;

export type ListUserFieldsError = unknown;

export type CreateUserFieldResponse = UserFieldResponse;

export type CreateUserFieldError = unknown;

export type ShowUserFieldData = {
  path: {
    /**
     * The ID or key of the user field
     */
    user_field_id: number | string;
  };
};

export type ShowUserFieldResponse = UserFieldResponse;

export type ShowUserFieldError = unknown;

export type UpdateUserFieldData = {
  path: {
    /**
     * The ID or key of the user field
     */
    user_field_id: number | string;
  };
};

export type UpdateUserFieldResponse = UserFieldResponse;

export type UpdateUserFieldError = unknown;

export type DeleteUserFieldData = {
  path: {
    /**
     * The ID or key of the user field
     */
    user_field_id: number | string;
  };
};

export type DeleteUserFieldResponse = any;

export type DeleteUserFieldError = unknown;

export type ListUserFieldOptionsData = {
  path: {
    /**
     * The ID or key of the user field
     */
    user_field_id: number | string;
  };
};

export type ListUserFieldOptionsResponse = CustomFieldOptionsResponse;

export type ListUserFieldOptionsError = unknown;

export type CreateOrUpdateUserFieldOptionData = {
  path: {
    /**
     * The ID or key of the user field
     */
    user_field_id: number | string;
  };
};

export type CreateOrUpdateUserFieldOptionResponse = CustomFieldOptionResponse;

export type CreateOrUpdateUserFieldOptionError = unknown;

export type ShowUserFieldOptionData = {
  path: {
    /**
     * The ID or key of the user field
     */
    user_field_id: number | string;
    /**
     * The ID of the user field option
     */
    user_field_option_id: number;
  };
};

export type ShowUserFieldOptionResponse = CustomFieldOptionResponse;

export type ShowUserFieldOptionError = unknown;

export type DeleteUserFieldOptionData = {
  path: {
    /**
     * The ID or key of the user field
     */
    user_field_id: number | string;
    /**
     * The ID of the user field option
     */
    user_field_option_id: number;
  };
};

export type DeleteUserFieldOptionResponse = any;

export type DeleteUserFieldOptionError = unknown;

export type ReorderUserFieldResponse = string;

export type ReorderUserFieldError = unknown;

export type ListUsersData = {
  query?: {
    /**
     * List users by external id. External id has to be unique for each user under the same account.
     */
    external_id?: string;
    /**
     * For custom roles which is available on the Enterprise plan and above. You can only filter by one role ID per request
     */
    permission_set?: number;
    /**
     * Filters the results by role. Possible values are "end-user", "agent", or "admin"
     *
     */
    role?: 'end-user' | 'agent' | 'admin';
    /**
     * Filters the results by more than one role using the format `role[]={role}&role[]={role}`
     *
     */
    'role[]'?: string;
  };
};

export type ListUsersResponse = UsersResponse;

export type ListUsersError = unknown;

export type CreateUserData = {
  body: UserRequest;
};

export type CreateUserResponse = UserResponse;

export type CreateUserError = unknown;

export type ShowUserData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type ShowUserResponse = UserResponse;

export type ShowUserError = unknown;

export type UpdateUserData = {
  body: UserRequest;
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type UpdateUserResponse = UserResponse;

export type UpdateUserError = unknown;

export type DeleteUserData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type DeleteUserResponse = UserResponse;

export type DeleteUserError = unknown;

export type ShowUserComplianceDeletionStatusesData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
  query?: {
    /**
     * Area of compliance
     */
    application?: string;
  };
};

export type ShowUserComplianceDeletionStatusesResponse = ComplianceDeletionStatusesResponse;

export type ShowUserComplianceDeletionStatusesError = unknown;

export type GroupMembershipSetDefaultData = {
  path: {
    /**
     * The ID of the group membership
     */
    group_membership_id: number;
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type GroupMembershipSetDefaultResponse = GroupMembershipsResponse;

export type GroupMembershipSetDefaultError = unknown;

export type ListUserIdentitiesData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type ListUserIdentitiesResponse = UserIdentitiesResponse;

export type ListUserIdentitiesError = unknown;

export type CreateUserIdentityData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type CreateUserIdentityResponse = UserIdentityResponse;

export type CreateUserIdentityError = unknown;

export type ShowUserIdentityData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
    /**
     * The ID of the user identity
     */
    user_identity_id: number;
  };
};

export type ShowUserIdentityResponse = UserIdentityResponse;

export type ShowUserIdentityError = unknown;

export type UpdateUserIdentityData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
    /**
     * The ID of the user identity
     */
    user_identity_id: number;
  };
};

export type UpdateUserIdentityResponse = UserIdentityResponse;

export type UpdateUserIdentityError = unknown;

export type DeleteUserIdentityData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
    /**
     * The ID of the user identity
     */
    user_identity_id: number;
  };
};

export type DeleteUserIdentityResponse = any;

export type DeleteUserIdentityError = unknown;

export type MakeUserIdentityPrimaryData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
    /**
     * The ID of the user identity
     */
    user_identity_id: number;
  };
};

export type MakeUserIdentityPrimaryResponse = UserIdentitiesResponse;

export type MakeUserIdentityPrimaryError = unknown;

export type RequestUserVerficationData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
    /**
     * The ID of the user identity
     */
    user_identity_id: number;
  };
};

export type RequestUserVerficationResponse = string;

export type RequestUserVerficationError = unknown;

export type VerifyUserIdentityData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
    /**
     * The ID of the user identity
     */
    user_identity_id: number;
  };
};

export type VerifyUserIdentityResponse = UserIdentityResponse;

export type VerifyUserIdentityError = unknown;

export type MergeEndUsersData = {
  body: UserRequest;
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type MergeEndUsersResponse = UserResponse;

export type MergeEndUsersError = unknown;

export type SetOrganizationMembershipAsDefaultData = {
  path: {
    /**
     * The ID of the organization membership
     */
    organization_membership_id: number;
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type SetOrganizationMembershipAsDefaultResponse = OrganizationMembershipsResponse;

export type SetOrganizationMembershipAsDefaultError = unknown;

export type UnassignOrganizationData = {
  path: {
    /**
     * The ID of an organization
     */
    organization_id: number;
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type UnassignOrganizationResponse = any;

export type UnassignOrganizationError = unknown;

export type SetOrganizationAsDefaultData = {
  path: {
    /**
     * The ID of an organization
     */
    organization_id: number;
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type SetOrganizationAsDefaultResponse = OrganizationMembershipResponse;

export type SetOrganizationAsDefaultError = unknown;

export type SetUserPasswordData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type SetUserPasswordResponse = string;

export type SetUserPasswordError = unknown;

export type ChangeOwnPasswordData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type ChangeOwnPasswordResponse = string;

export type ChangeOwnPasswordError = unknown;

export type GetUserPasswordRequirementsData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type GetUserPasswordRequirementsResponse = UserPasswordRequirementsResponse;

export type GetUserPasswordRequirementsError = unknown;

export type ShowUserRelatedData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type ShowUserRelatedResponse = UserRelatedResponse;

export type ShowUserRelatedError = unknown;

export type BulkDeleteSessionsByUserIdData = {
  path: {
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type BulkDeleteSessionsByUserIdResponse = any;

export type BulkDeleteSessionsByUserIdError = unknown;

export type ShowSessionData = {
  path: {
    /**
     * The ID of the session
     */
    session_id: number;
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type ShowSessionResponse = SessionResponse;

export type ShowSessionError = unknown;

export type DeleteSessionData = {
  path: {
    /**
     * The ID of the session
     */
    session_id: number;
    /**
     * The id of the user
     */
    user_id: number;
  };
};

export type DeleteSessionResponse = any;

export type DeleteSessionError = unknown;

export type ListTicketSkipsData = {
  path: {
    /**
     * The ID of the ticket
     */
    ticket_id: number;
    /**
     * User ID of an agent
     */
    user_id: number;
  };
  query?: {
    /**
     * Sort order. Defaults to "asc"
     */
    sort_order?: 'asc' | 'desc';
  };
};

export type ListTicketSkipsResponse = TicketSkipsResponse;

export type ListTicketSkipsError = unknown;

export type AutocompleteUsersData = {
  query: {
    /**
     * The id of a lookup relationship field.  The type of field is determined
     * by the `source` param
     *
     */
    field_id?: string;
    /**
     * The name to search for the user.
     *
     */
    name: string;
    /**
     * If a `field_id` is provided, this specifies the type of the field.
     * For example, if the field is on a "zen:user", it references a field on a user
     *
     */
    source?: string;
  };
};

export type AutocompleteUsersResponse = UsersResponse;

export type AutocompleteUsersError = unknown;

export type CountUsersData = {
  query?: {
    /**
     * For custom roles which is available on the Enterprise plan and above. You can only filter by one role ID per request
     */
    permission_set?: number;
    /**
     * Filters the results by role. Possible values are "end-user", "agent", or "admin"
     *
     */
    role?: 'end-user' | 'agent' | 'admin';
    /**
     * Filters the results by more than one role using the format `role[]={role}&role[]={role}`
     *
     */
    'role[]'?: string;
  };
};

export type CountUsersResponse = CountResponse;

export type CountUsersError = unknown;

export type CreateManyUsersData = {
  body: UsersRequest;
};

export type CreateManyUsersResponse = JobStatusResponse;

export type CreateManyUsersError = unknown;

export type CreateOrUpdateUserData = {
  body: UserRequest;
};

export type CreateOrUpdateUserResponse = UserResponse;

export type CreateOrUpdateUserError = unknown;

export type CreateOrUpdateManyUsersData = {
  body: UsersRequest;
};

export type CreateOrUpdateManyUsersResponse = JobStatusResponse;

export type CreateOrUpdateManyUsersError = unknown;

export type DestroyManyUsersData = {
  query?: {
    /**
     * External Id of the users to delete. Comma separated
     */
    external_ids?: string;
    /**
     * Id of the users to delete. Comma separated
     */
    ids?: string;
  };
};

export type DestroyManyUsersResponse = JobStatusResponse;

export type DestroyManyUsersError = unknown;

export type LogoutManyUsersData = {
  query?: {
    /**
     * Accepts a comma-separated list of up to 100 user ids.
     *
     */
    ids?: string;
  };
};

export type LogoutManyUsersResponse = string;

export type LogoutManyUsersError = unknown;

export type ShowCurrentUserResponse = CurrentUserResponse;

export type ShowCurrentUserError = unknown;

export type DeleteAuthenticatedSessionResponse = any;

export type DeleteAuthenticatedSessionError = unknown;

export type ShowCurrentlyAuthenticatedSessionResponse = SessionResponse;

export type ShowCurrentlyAuthenticatedSessionError = unknown;

export type RenewCurrentSessionResponse = RenewSessionResponse;

export type RenewCurrentSessionError = unknown;

export type RequestUserCreateData = {
  body: UserRequest;
};

export type RequestUserCreateResponse = string;

export type RequestUserCreateError = unknown;

export type SearchUsersData = {
  query?: {
    /**
     * The `external_id` parameter does not support the search syntax. It only accepts ids.
     *
     */
    external_id?: string;
    /**
     * The `query` parameter supports the Zendesk search syntax for more advanced
     * user searches. It can specify a partial or full value of any
     * user property, including name, email address, notes, or phone. Example:
     * `query="jdoe"`.
     * See the [Search API](/api-reference/ticketing/ticket-management/search/).
     *
     */
    query?: string;
  };
};

export type SearchUsersResponse = UsersResponse;

export type SearchUsersError = unknown;

export type ShowManyUsersData = {
  query?: {
    /**
     * Accepts a comma-separated list of up to 100 external ids.
     *
     */
    external_ids?: string;
    /**
     * Accepts a comma-separated list of up to 100 user ids.
     *
     */
    ids?: string;
  };
};

export type ShowManyUsersResponse = UsersResponse;

export type ShowManyUsersError = unknown;

export type UpdateManyUsersData = {
  body: UserRequest | UsersRequest;
  query?: {
    /**
     * External Id of the users to update. Comma separated
     */
    external_ids?: string;
    /**
     * Id of the users to update. Comma separated
     */
    ids?: string;
  };
};

export type UpdateManyUsersResponse = JobStatusResponse;

export type UpdateManyUsersError = unknown;

export type ListViewCategoriesResponse = ViewCategoriesResponse;

export type ListViewCategoriesError = ViewCategoryErrors;

export type CreateViewCategoryData = {
  body: {
    view_category?: ViewCategoryRequest & ViewCategoryRequestRequired;
  };
};

export type CreateViewCategoryResponse = ViewCategoryResponse;

export type CreateViewCategoryError = ViewCategoryErrors;

export type UpdateViewCategoryData = {
  body: {
    view_category?: ViewCategoryRequest;
  };
  path: {
    /**
     * The id of the view category to update
     */
    view_category_id: string;
  };
};

export type UpdateViewCategoryResponse = ViewCategoryResponse;

export type UpdateViewCategoryError = ViewCategoryErrors;

export type DeleteViewCategoryData = {
  path: {
    /**
     * The id of the view category to delete
     */
    view_category_id: string;
  };
};

export type DeleteViewCategoryResponse = any;

export type DeleteViewCategoryError = ViewCategoryErrors;

export type ListViewsData = {
  query?: {
    /**
     * Only views with given access. May be "personal", "shared", or "account"
     */
    access?: string;
    /**
     * Only active views if true, inactive views if false
     */
    active?: boolean;
    /**
     * Only views belonging to given group
     */
    group_id?: number;
    /**
     * Possible values are "alphabetical", "created_at", or "updated_at". Defaults to "position"
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type ListViewsResponse = ViewsResponse;

export type ListViewsError = unknown;

export type CreateViewResponse = ViewResponse;

export type CreateViewError = unknown;

export type ShowViewData = {
  path: {
    /**
     * The ID of the view
     */
    view_id: number;
  };
};

export type ShowViewResponse = ViewResponse;

export type ShowViewError = unknown;

export type UpdateViewData = {
  path: {
    /**
     * The ID of the view
     */
    view_id: number;
  };
};

export type UpdateViewResponse = ViewResponse;

export type UpdateViewError = unknown;

export type DeleteViewData = {
  path: {
    /**
     * The ID of the view
     */
    view_id: number;
  };
};

export type DeleteViewResponse = any;

export type DeleteViewError = unknown;

export type GetViewCountData = {
  path: {
    /**
     * The ID of the view
     */
    view_id: number;
  };
};

export type GetViewCountResponse = ViewCountResponse;

export type GetViewCountError = unknown;

export type ExecuteViewData = {
  path: {
    /**
     * The ID of the view
     */
    view_id: number;
  };
  query?: {
    /**
     * The ticket field used for sorting. This will either be a title or a custom field id.
     */
    sort_by?: string;
    /**
     * The direction the tickets are sorted. May be one of 'asc' or 'desc'
     */
    sort_order?: string;
  };
};

export type ExecuteViewResponse = ViewResponse;

export type ExecuteViewError = unknown;

export type ExportViewData = {
  path: {
    /**
     * The ID of the view
     */
    view_id: number;
  };
};

export type ExportViewResponse = ViewExportResponse;

export type ExportViewError = unknown;

export type ListTicketsFromViewData = {
  path: {
    /**
     * The ID of the view
     */
    view_id: number;
  };
  query?: {
    /**
     * Sort or group the tickets by a column in the [View columns](#view-columns) table. The `subject` and `submitter` columns are not supported
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type ListTicketsFromViewResponse = TicketsResponse;

export type ListTicketsFromViewError = unknown;

export type ListActiveViewsData = {
  query?: {
    /**
     * Only views with given access. May be "personal", "shared", or "account"
     */
    access?: string;
    /**
     * Only views belonging to given group
     */
    group_id?: number;
    /**
     * Possible values are "alphabetical", "created_at", or "updated_at". Defaults to "position"
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type ListActiveViewsResponse = ViewsResponse;

export type ListActiveViewsError = unknown;

export type ListCompactViewsResponse = ViewsResponse;

export type ListCompactViewsError = unknown;

export type CountViewsResponse = ViewsCountResponse;

export type CountViewsError = unknown;

export type GetViewCountsData = {
  query: {
    /**
     * List of view's ids separated by commas.
     */
    ids: string;
  };
};

export type GetViewCountsResponse = ViewCountsResponse;

export type GetViewCountsError = unknown;

export type BulkDeleteViewsData = {
  query: {
    /**
     * The IDs of the views to delete
     */
    ids: string;
  };
};

export type BulkDeleteViewsResponse = any;

export type BulkDeleteViewsError = unknown;

export type PreviewViewsResponse = ViewResponse;

export type PreviewViewsError = unknown;

export type PreviewCountResponse = ViewCountResponse;

export type PreviewCountError = unknown;

export type SearchViewsData = {
  query: {
    /**
     * Filter views by access. May be "personal", "shared", or "account"
     */
    access?: string;
    /**
     * Filter by active views if true or inactive views if false
     */
    active?: boolean;
    /**
     * Filter views by group
     */
    group_id?: number;
    /**
     * A sideload to include in the response. See [Sideloads](#sideloads-3)
     */
    include?: string;
    /**
     * Query string used to find all views with matching title
     */
    query: string;
    /**
     * Possible values are "alphabetical", "created_at", "updated_at", and "position". If unspecified, the views are sorted by relevance
     */
    sort_by?: string;
    /**
     * One of "asc" or "desc". Defaults to "asc" for alphabetical and position sort, "desc" for all others
     */
    sort_order?: string;
  };
};

export type SearchViewsResponse = ViewsResponse;

export type SearchViewsError = unknown;

export type ListViewsByIdData = {
  query: {
    /**
     * Only active views if true, inactive views if false
     */
    active?: boolean;
    /**
     * List of view's ids separated by commas.
     */
    ids: string;
  };
};

export type ListViewsByIdResponse = ViewsResponse;

export type ListViewsByIdError = unknown;

export type UpdateManyViewsResponse = ViewsResponse;

export type UpdateManyViewsError = unknown;

export type ListWorkspacesResponse = WorkspaceResponse;

export type ListWorkspacesError = unknown;

export type CreateWorkspaceData = {
  body?: {
    workspace?: WorkspaceInput;
  };
};

export type CreateWorkspaceResponse = {
  workspace?: WorkspaceObject;
};

export type CreateWorkspaceError = unknown;

export type ShowWorkspaceData = {
  path: {
    /**
     * The id of the workspace
     */
    workspace_id: number;
  };
};

export type ShowWorkspaceResponse = {
  workspace?: WorkspaceObject;
};

export type ShowWorkspaceError = unknown;

export type UpdateWorkspaceData = {
  body?: {
    workspace?: WorkspaceInput;
  };
  path: {
    /**
     * The id of the workspace
     */
    workspace_id: number;
  };
};

export type UpdateWorkspaceResponse = {
  workspace?: WorkspaceObject;
};

export type UpdateWorkspaceError = unknown;

export type DeleteWorkspaceData = {
  path: {
    /**
     * The id of the workspace
     */
    workspace_id: number;
  };
};

export type DeleteWorkspaceResponse = any;

export type DeleteWorkspaceError = unknown;

export type DestroyManyWorkspacesData = {
  query: {
    /**
     * The ids of the workspaces to delete
     */
    ids: Array<number>;
  };
};

export type DestroyManyWorkspacesResponse = string;

export type DestroyManyWorkspacesError = unknown;

export type ReorderWorkspacesData = {
  body?: {
    ids?: Array<number>;
  };
};

export type ReorderWorkspacesResponse = string;

export type ReorderWorkspacesError = unknown;
