// This file is auto-generated by @hey-api/openapi-ts

export const AccountSettingsActiveFeaturesObjectSchema = {
  type: 'object',
  description: 'The active features for an account. See [Active Features](#active-features)',
  properties: {
    advanced_analytics: {
      type: 'boolean',
    },
    agent_forwarding: {
      type: 'boolean',
    },
    allow_ccs: {
      type: 'boolean',
    },
    allow_email_template_customization: {
      type: 'boolean',
    },
    automatic_answers: {
      type: 'boolean',
    },
    bcc_archiving: {
      type: 'boolean',
    },
    benchmark_opt_out: {
      type: 'boolean',
    },
    business_hours: {
      type: 'boolean',
    },
    chat: {
      type: 'boolean',
    },
    chat_about_my_ticket: {
      type: 'boolean',
    },
    csat_reason_code: {
      type: 'boolean',
    },
    custom_dkim_domain: {
      type: 'boolean',
    },
    customer_context_as_default: {
      type: 'boolean',
    },
    customer_satisfaction: {
      type: 'boolean',
    },
    dynamic_contents: {
      type: 'boolean',
    },
    explore: {
      type: 'boolean',
    },
    explore_on_support_ent_plan: {
      type: 'boolean',
    },
    explore_on_support_pro_plan: {
      type: 'boolean',
    },
    facebook: {
      type: 'boolean',
    },
    facebook_login: {
      type: 'boolean',
    },
    fallback_composer: {
      type: 'boolean',
    },
    forum_analytics: {
      type: 'boolean',
    },
    good_data_and_explore: {
      type: 'boolean',
    },
    google_login: {
      type: 'boolean',
    },
    insights: {
      type: 'boolean',
    },
    is_abusive: {
      type: 'boolean',
    },
    light_agents: {
      type: 'boolean',
    },
    markdown: {
      type: 'boolean',
    },
    on_hold_status: {
      type: 'boolean',
    },
    organization_access_enabled: {
      type: 'boolean',
    },
    rich_content_in_emails: {
      type: 'boolean',
    },
    sandbox: {
      type: 'boolean',
    },
    satisfaction_prediction: {
      type: 'boolean',
    },
    suspended_ticket_notification: {
      type: 'boolean',
    },
    ticket_forms: {
      type: 'boolean',
    },
    ticket_tagging: {
      type: 'boolean',
    },
    topic_suggestion: {
      type: 'boolean',
    },
    twitter: {
      type: 'boolean',
    },
    twitter_login: {
      type: 'boolean',
    },
    user_org_fields: {
      type: 'boolean',
    },
    user_tagging: {
      type: 'boolean',
    },
    voice: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsAgentObjectSchema = {
  type: 'object',
  description: 'Configuration for the agent workspace. See [Agents](#agents)',
  properties: {
    agent_home: {
      type: 'boolean',
    },
    agent_workspace: {
      type: 'boolean',
    },
    aw_self_serve_migration_enabled: {
      type: 'boolean',
    },
    focus_mode: {
      type: 'boolean',
    },
    idle_timeout_enabled: {
      type: 'boolean',
    },
    unified_agent_statuses: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsApiObjectSchema = {
  type: 'object',
  description: 'API configuration options. See [API](#api)',
  properties: {
    accepted_api_agreement: {
      type: 'boolean',
    },
    api_password_access: {
      type: 'string',
    },
    api_token_access: {
      type: 'string',
    },
  },
} as const;

export const AccountSettingsAppsObjectSchema = {
  type: 'object',
  description: 'Apps configuration options. See [Apps](#apps)',
  properties: {
    create_private: {
      type: 'boolean',
    },
    create_public: {
      type: 'boolean',
    },
    use: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsBillingObjectSchema = {
  type: 'object',
  description: 'Billing configuration options. See [Billing](#billing)',
  properties: {
    backend: {
      type: 'string',
    },
  },
} as const;

export const AccountSettingsBrandingObjectSchema = {
  type: 'object',
  description: 'Branding settings. See [Branding](#branding)',
  properties: {
    favicon_url: {
      type: 'string',
      nullable: true,
    },
    header_color: {
      type: 'string',
    },
    header_logo_url: {
      type: 'string',
      nullable: true,
    },
    page_background_color: {
      type: 'string',
    },
    tab_background_color: {
      type: 'string',
    },
    text_color: {
      type: 'string',
    },
  },
} as const;

export const AccountSettingsBrandsObjectSchema = {
  type: 'object',
  description: 'Brand settings. See [Brands](#brands)',
  properties: {
    default_brand_id: {
      type: 'integer',
    },
    require_brand_on_new_tickets: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsCdnObjectSchema = {
  type: 'object',
  description: 'CDN settings',
  properties: {
    cdn_provider: {
      type: 'string',
    },
    fallback_cdn_provider: {
      type: 'string',
    },
    hosts: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          name: {
            type: 'string',
          },
          url: {
            type: 'string',
          },
        },
      },
    },
  },
} as const;

export const AccountSettingsChatObjectSchema = {
  type: 'object',
  description: 'Zendesk Chat settings. See [Chat](#chat)',
  properties: {
    available: {
      type: 'boolean',
    },
    enabled: {
      type: 'boolean',
    },
    integrated: {
      type: 'boolean',
    },
    maximum_request_count: {
      type: 'integer',
    },
    welcome_message: {
      type: 'string',
    },
  },
} as const;

export const AccountSettingsCrossSellObjectSchema = {
  type: 'object',
  description: 'Cross Sell settings',
  properties: {
    show_chat_tooltip: {
      type: 'boolean',
    },
    xsell_source: {
      type: 'string',
      nullable: true,
    },
  },
} as const;

export const AccountSettingsGooddataAdvancedAnalyticsObjectSchema = {
  type: 'object',
  description:
    'GoodData settings, used for insights. Legacy configuration prior to Zendesk Explore. See [GoodData Advanced Analytics](#gooddata-advanced-analytics)',
  properties: {
    enabled: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsGoogleAppsObjectSchema = {
  type: 'object',
  description: 'Google Apps configuration. See [G Suite](#g-suite)',
  properties: {
    has_google_apps: {
      type: 'boolean',
    },
    has_google_apps_admin: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsGroupObjectSchema = {
  type: 'object',
  description: 'Group configuration',
  properties: {
    check_group_name_uniqueness: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsLimitsObjectSchema = {
  type: 'object',
  description: 'Account limits configuration. See [Limits](#limits)',
  properties: {
    attachment_size: {
      type: 'integer',
    },
  },
} as const;

export const AccountSettingsLocalizationObjectSchema = {
  type: 'object',
  description: 'Internationalization configuration settings. See [Localization](#localization)',
  properties: {
    locale_ids: {
      type: 'array',
      items: {
        type: 'integer',
      },
    },
  },
} as const;

export const AccountSettingsLotusObjectSchema = {
  type: 'object',
  description: 'Support UI settings. See [Lotus](#lotus)',
  properties: {
    pod_id: {
      type: 'integer',
    },
    prefer_lotus: {
      type: 'boolean',
    },
    reporting: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsMetricsObjectSchema = {
  type: 'object',
  description: 'Account metrics settings. See [Metrics](#metrics)',
  properties: {
    account_size: {
      type: 'string',
    },
  },
} as const;

export const AccountSettingsObjectSchema = {
  type: 'object',
  properties: {
    active_features: {
      $ref: '#/components/schemas/AccountSettingsActiveFeaturesObject',
    },
    agents: {
      $ref: '#/components/schemas/AccountSettingsAgentObject',
    },
    api: {
      $ref: '#/components/schemas/AccountSettingsApiObject',
    },
    apps: {
      $ref: '#/components/schemas/AccountSettingsAppsObject',
    },
    billing: {
      $ref: '#/components/schemas/AccountSettingsBillingObject',
    },
    branding: {
      $ref: '#/components/schemas/AccountSettingsBrandingObject',
    },
    brands: {
      $ref: '#/components/schemas/AccountSettingsBrandsObject',
    },
    cdn: {
      $ref: '#/components/schemas/AccountSettingsCdnObject',
    },
    chat: {
      $ref: '#/components/schemas/AccountSettingsChatObject',
    },
    cross_sell: {
      $ref: '#/components/schemas/AccountSettingsCrossSellObject',
    },
    gooddata_advanced_analytics: {
      $ref: '#/components/schemas/AccountSettingsGooddataAdvancedAnalyticsObject',
    },
    google_apps: {
      $ref: '#/components/schemas/AccountSettingsGoogleAppsObject',
    },
    groups: {
      $ref: '#/components/schemas/AccountSettingsGroupObject',
    },
    limits: {
      $ref: '#/components/schemas/AccountSettingsLimitsObject',
    },
    localization: {
      $ref: '#/components/schemas/AccountSettingsLocalizationObject',
    },
    lotus: {
      $ref: '#/components/schemas/AccountSettingsLotusObject',
    },
    metrics: {
      $ref: '#/components/schemas/AccountSettingsMetricsObject',
    },
    onboarding: {
      $ref: '#/components/schemas/AccountSettingsOnboardingObject',
    },
    routing: {
      $ref: '#/components/schemas/AccountSettingsRoutingObject',
    },
    rule: {
      $ref: '#/components/schemas/AccountSettingsRuleObject',
    },
    side_conversations: {
      $ref: '#/components/schemas/AccountSettingsSideConversationsObject',
    },
    statistics: {
      $ref: '#/components/schemas/AccountSettingsStatisticsObject',
    },
    ticket_form: {
      $ref: '#/components/schemas/AccountSettingsTicketFormObject',
    },
    tickets: {
      $ref: '#/components/schemas/AccountSettingsTicketObject',
    },
    twitter: {
      $ref: '#/components/schemas/AccountSettingsTwitterObject',
    },
    user: {
      $ref: '#/components/schemas/AccountSettingsUserObject',
    },
    voice: {
      $ref: '#/components/schemas/AccountSettingsVoiceObject',
    },
  },
  example: {
    active_features: {
      advanced_analytics: false,
      agent_forwarding: false,
      allow_ccs: true,
      allow_email_template_customization: true,
      automatic_answers: false,
      bcc_archiving: false,
      benchmark_opt_out: false,
      business_hours: false,
      chat: false,
      chat_about_my_ticket: false,
      csat_reason_code: false,
      custom_dkim_domain: true,
      customer_context_as_default: false,
      customer_satisfaction: false,
      dynamic_contents: false,
      explore: true,
      explore_on_support_ent_plan: false,
      explore_on_support_pro_plan: false,
      facebook: false,
      facebook_login: false,
      fallback_composer: false,
      forum_analytics: true,
      good_data_and_explore: false,
      google_login: false,
      insights: false,
      is_abusive: false,
      light_agents: false,
      markdown: false,
      on_hold_status: false,
      organization_access_enabled: true,
      rich_content_in_emails: true,
      sandbox: false,
      satisfaction_prediction: false,
      suspended_ticket_notification: false,
      ticket_forms: true,
      ticket_tagging: true,
      topic_suggestion: false,
      twitter: true,
      twitter_login: false,
      user_org_fields: true,
      user_tagging: true,
      voice: true,
    },
    agents: {
      agent_home: false,
      agent_workspace: false,
      aw_self_serve_migration_enabled: true,
      focus_mode: false,
      idle_timeout_enabled: false,
      unified_agent_statuses: false,
    },
    api: {
      accepted_api_agreement: true,
      api_password_access: 'true',
      api_token_access: 'true',
    },
    apps: {
      create_private: true,
      create_public: false,
      use: true,
    },
    billing: {
      backend: 'zuora',
    },
    branding: {
      favicon_url: null,
      header_color: '78A300',
      header_logo_url: null,
      page_background_color: '333333',
      tab_background_color: '7FA239',
      text_color: 'FFFFFF',
    },
    brands: {
      default_brand_id: 1873,
      require_brand_on_new_tickets: false,
    },
    cdn: {
      cdn_provider: 'default',
      fallback_cdn_provider: 'cloudfront',
      hosts: [
        {
          name: 'default',
          url: 'https://p18.zdassets.com',
        },
        {
          name: 'cloudfront',
          url: 'https://d2y9oszrd3dhjh.cloudfront.net',
        },
      ],
    },
    chat: {
      available: true,
      enabled: false,
      integrated: true,
      maximum_request_count: 1,
      welcome_message: 'Hi there. How can I help today?',
    },
    cross_sell: {
      show_chat_tooltip: true,
      xsell_source: null,
    },
    gooddata_advanced_analytics: {
      enabled: true,
    },
    google_apps: {
      has_google_apps: false,
      has_google_apps_admin: false,
    },
    groups: {
      check_group_name_uniqueness: true,
    },
    limits: {
      attachment_size: 52428800,
    },
    localization: {
      locale_ids: [1042],
    },
    lotus: {
      pod_id: 999,
      prefer_lotus: true,
      reporting: true,
    },
    metrics: {
      account_size: '100-399',
    },
    onboarding: {
      checklist_onboarding_version: 2,
      onboarding_segments: null,
      product_sign_up: null,
    },
    routing: {
      autorouting_tag: '',
      enabled: false,
      max_email_capacity: 0,
      max_messaging_capacity: 0,
      reassignment_messaging_enabled: true,
      reassignment_messaging_timeout: 30,
      reassignment_talk_timeout: 30,
    },
    rule: {
      macro_most_used: true,
      macro_order: 'alphabetical',
      skill_based_filtered_views: [],
      using_skill_based_routing: false,
    },
    side_conversations: {
      email_channel: false,
      msteams_channel: false,
      show_in_context_panel: false,
      slack_channel: false,
      tickets_channel: false,
    },
    statistics: {
      forum: true,
      rule_usage: true,
      search: true,
    },
    ticket_form: {
      raw_ticket_forms_instructions: 'Please choose your issue below',
      ticket_forms_instructions: 'Please choose your issue below',
    },
    tickets: {
      accepted_new_collaboration_tos: false,
      agent_collision: true,
      agent_invitation_enabled: true,
      agent_ticket_deletion: false,
      allow_group_reset: true,
      assign_default_organization: true,
      assign_tickets_upon_solve: true,
      auto_translation_enabled: false,
      auto_updated_ccs_followers_rules: false,
      chat_sla_enablement: false,
      collaboration: true,
      comments_public_by_default: true,
      default_solved_ticket_reassignment_strategy: 'legacy',
      email_attachments: false,
      emoji_autocompletion: true,
      follower_and_email_cc_collaborations: false,
      has_color_text: true,
      is_first_comment_private_enabled: true,
      light_agent_email_ccs_allowed: false,
      list_empty_views: true,
      list_newest_comments_first: true,
      markdown_ticket_comments: false,
      maximum_personal_views_to_list: 8,
      modern_ticket_reassignment: false,
      private_attachments: false,
      rich_text_comments: true,
      show_modern_ticket_reassignment: false,
      status_hold: false,
      tagging: true,
      using_skill_based_routing: false,
    },
    twitter: {
      shorten_url: 'optional',
    },
    user: {
      agent_created_welcome_emails: true,
      end_user_phone_number_validation: false,
      have_gravatars_enabled: true,
      language_selection: true,
      multiple_organizations: false,
      tagging: true,
      time_zone_selection: true,
    },
    voice: {
      agent_confirmation_when_forwarding: true,
      agent_wrap_up_after_calls: true,
      enabled: true,
      logging: true,
      maximum_queue_size: 5,
      maximum_queue_wait_time: 1,
      only_during_business_hours: false,
      outbound_enabled: true,
      recordings_public: true,
      uk_mobile_forwarding: true,
    },
  },
} as const;

export const AccountSettingsOnboardingObjectSchema = {
  type: 'object',
  description: 'Onboarding settings',
  properties: {
    checklist_onboarding_version: {
      type: 'integer',
    },
    onboarding_segments: {
      type: 'string',
      nullable: true,
    },
    product_sign_up: {
      type: 'string',
      nullable: true,
    },
  },
} as const;

export const AccountSettingsResponseSchema = {
  type: 'object',
  properties: {
    settings: {
      $ref: '#/components/schemas/AccountSettingsObject',
    },
  },
  example: {
    settings: {
      active_features: {
        advanced_analytics: false,
        agent_forwarding: false,
        allow_ccs: true,
        allow_email_template_customization: true,
        automatic_answers: false,
        bcc_archiving: false,
        benchmark_opt_out: false,
        business_hours: false,
        chat: false,
        chat_about_my_ticket: false,
        csat_reason_code: false,
        custom_dkim_domain: true,
        customer_context_as_default: false,
        customer_satisfaction: false,
        dynamic_contents: false,
        explore: true,
        explore_on_support_ent_plan: false,
        explore_on_support_pro_plan: false,
        facebook: false,
        facebook_login: false,
        fallback_composer: false,
        forum_analytics: true,
        good_data_and_explore: false,
        google_login: false,
        insights: false,
        is_abusive: false,
        light_agents: false,
        markdown: false,
        on_hold_status: false,
        organization_access_enabled: true,
        rich_content_in_emails: true,
        sandbox: false,
        satisfaction_prediction: false,
        suspended_ticket_notification: false,
        ticket_forms: true,
        ticket_tagging: true,
        topic_suggestion: false,
        twitter: true,
        twitter_login: false,
        user_org_fields: true,
        user_tagging: true,
        voice: true,
      },
      agents: {
        agent_home: false,
        agent_workspace: false,
        aw_self_serve_migration_enabled: true,
        focus_mode: false,
        idle_timeout_enabled: false,
        unified_agent_statuses: false,
      },
      api: {
        accepted_api_agreement: true,
        api_password_access: 'true',
        api_token_access: 'true',
      },
      apps: {
        create_private: true,
        create_public: false,
        use: true,
      },
      billing: {
        backend: 'zuora',
      },
      branding: {
        favicon_url: null,
        header_color: '78A300',
        header_logo_url: null,
        page_background_color: '333333',
        tab_background_color: '7FA239',
        text_color: 'FFFFFF',
      },
      brands: {
        default_brand_id: 1873,
        require_brand_on_new_tickets: false,
      },
      cdn: {
        cdn_provider: 'default',
        fallback_cdn_provider: 'cloudfront',
        hosts: [
          {
            name: 'default',
            url: 'https://p18.zdassets.com',
          },
          {
            name: 'cloudfront',
            url: 'https://d2y9oszrd3dhjh.cloudfront.net',
          },
        ],
      },
      chat: {
        available: true,
        enabled: false,
        integrated: true,
        maximum_request_count: 1,
        welcome_message: 'Hi there. How can I help today?',
      },
      cross_sell: {
        show_chat_tooltip: true,
        xsell_source: null,
      },
      gooddata_advanced_analytics: {
        enabled: true,
      },
      google_apps: {
        has_google_apps: false,
        has_google_apps_admin: false,
      },
      groups: {
        check_group_name_uniqueness: true,
      },
      limits: {
        attachment_size: 52428800,
      },
      localization: {
        locale_ids: [1042],
      },
      lotus: {
        pod_id: 999,
        prefer_lotus: true,
        reporting: true,
      },
      metrics: {
        account_size: '100-399',
      },
      onboarding: {
        checklist_onboarding_version: 2,
        onboarding_segments: null,
        product_sign_up: null,
      },
      routing: {
        autorouting_tag: '',
        enabled: false,
        max_email_capacity: 0,
        max_messaging_capacity: 0,
      },
      rule: {
        macro_most_used: true,
        macro_order: 'alphabetical',
        skill_based_filtered_views: [],
        using_skill_based_routing: false,
      },
      side_conversations: {
        email_channel: false,
        msteams_channel: false,
        show_in_context_panel: false,
        slack_channel: false,
        tickets_channel: false,
      },
      statistics: {
        forum: true,
        rule_usage: true,
        search: true,
      },
      ticket_form: {
        raw_ticket_forms_instructions: 'Please choose your issue below',
        ticket_forms_instructions: 'Please choose your issue below',
      },
      tickets: {
        accepted_new_collaboration_tos: false,
        agent_collision: true,
        agent_invitation_enabled: true,
        agent_ticket_deletion: false,
        allow_group_reset: true,
        assign_default_organization: true,
        assign_tickets_upon_solve: true,
        auto_translation_enabled: false,
        auto_updated_ccs_followers_rules: false,
        chat_sla_enablement: false,
        collaboration: true,
        comments_public_by_default: true,
        default_solved_ticket_reassignment_strategy: 'legacy',
        email_attachments: false,
        emoji_autocompletion: true,
        follower_and_email_cc_collaborations: false,
        has_color_text: true,
        is_first_comment_private_enabled: true,
        light_agent_email_ccs_allowed: false,
        list_empty_views: true,
        list_newest_comments_first: true,
        markdown_ticket_comments: false,
        maximum_personal_views_to_list: 8,
        modern_ticket_reassignment: false,
        private_attachments: false,
        rich_text_comments: true,
        show_modern_ticket_reassignment: false,
        status_hold: false,
        tagging: true,
        using_skill_based_routing: false,
      },
      twitter: {
        shorten_url: 'optional',
      },
      user: {
        agent_created_welcome_emails: true,
        end_user_phone_number_validation: false,
        have_gravatars_enabled: true,
        language_selection: true,
        multiple_organizations: false,
        tagging: true,
        time_zone_selection: true,
      },
      voice: {
        agent_confirmation_when_forwarding: true,
        agent_wrap_up_after_calls: true,
        enabled: true,
        logging: true,
        maximum_queue_size: 5,
        maximum_queue_wait_time: 1,
        only_during_business_hours: false,
        outbound_enabled: true,
        recordings_public: true,
        uk_mobile_forwarding: true,
      },
    },
  },
} as const;

export const AccountSettingsRoutingObjectSchema = {
  type: 'object',
  description: 'Configuration for routing. See [Routing](#routing)',
  properties: {
    autorouting_tag: {
      type: 'string',
    },
    enabled: {
      type: 'boolean',
    },
    max_email_capacity: {
      type: 'integer',
    },
    max_messaging_capacity: {
      type: 'integer',
    },
    reassignment_messaging_enabled: {
      type: 'boolean',
    },
    reassignment_messaging_timeout: {
      type: 'integer',
    },
    reassignment_talk_timeout: {
      type: 'integer',
    },
  },
} as const;

export const AccountSettingsRuleObjectSchema = {
  type: 'object',
  description: 'Rules settings for triggers, macros, views, and automations. See [Rules](#rules)',
  properties: {
    macro_most_used: {
      type: 'boolean',
    },
    macro_order: {
      type: 'string',
    },
    skill_based_filtered_views: {
      type: 'array',
      items: {
        type: 'object',
        additionalProperties: true,
      },
    },
    using_skill_based_routing: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsSideConversationsObjectSchema = {
  type: 'object',
  description: 'Side conversations settings',
  properties: {
    email_channel: {
      type: 'boolean',
    },
    msteams_channel: {
      type: 'boolean',
    },
    show_in_context_panel: {
      type: 'boolean',
    },
    slack_channel: {
      type: 'boolean',
    },
    tickets_channel: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsStatisticsObjectSchema = {
  type: 'object',
  description: 'Account statistics settings. See [Statistics](#statistics)',
  properties: {
    forum: {
      type: 'boolean',
    },
    rule_usage: {
      type: 'boolean',
    },
    search: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsTicketFormObjectSchema = {
  type: 'object',
  description: 'Ticket form settings. See [Ticket Form](#ticket-form)',
  properties: {
    raw_ticket_forms_instructions: {
      type: 'string',
    },
    ticket_forms_instructions: {
      type: 'string',
    },
  },
} as const;

export const AccountSettingsTicketObjectSchema = {
  type: 'object',
  description: 'Ticket settings. See [Tickets](#tickets)',
  properties: {
    accepted_new_collaboration_tos: {
      type: 'boolean',
    },
    agent_collision: {
      type: 'boolean',
    },
    agent_invitation_enabled: {
      type: 'boolean',
    },
    agent_ticket_deletion: {
      type: 'boolean',
    },
    allow_group_reset: {
      type: 'boolean',
    },
    assign_default_organization: {
      type: 'boolean',
    },
    assign_tickets_upon_solve: {
      type: 'boolean',
    },
    auto_translation_enabled: {
      type: 'boolean',
    },
    auto_updated_ccs_followers_rules: {
      type: 'boolean',
    },
    chat_sla_enablement: {
      type: 'boolean',
    },
    collaboration: {
      type: 'boolean',
    },
    comments_public_by_default: {
      type: 'boolean',
    },
    default_solved_ticket_reassignment_strategy: {
      type: 'string',
    },
    email_attachments: {
      type: 'boolean',
    },
    emoji_autocompletion: {
      type: 'boolean',
    },
    follower_and_email_cc_collaborations: {
      type: 'boolean',
    },
    has_color_text: {
      type: 'boolean',
    },
    is_first_comment_private_enabled: {
      type: 'boolean',
    },
    light_agent_email_ccs_allowed: {
      type: 'boolean',
    },
    list_empty_views: {
      type: 'boolean',
    },
    list_newest_comments_first: {
      type: 'boolean',
    },
    markdown_ticket_comments: {
      type: 'boolean',
    },
    maximum_personal_views_to_list: {
      type: 'integer',
    },
    modern_ticket_reassignment: {
      type: 'boolean',
    },
    private_attachments: {
      type: 'boolean',
    },
    rich_text_comments: {
      type: 'boolean',
    },
    show_modern_ticket_reassignment: {
      type: 'boolean',
    },
    status_hold: {
      type: 'boolean',
    },
    tagging: {
      type: 'boolean',
    },
    using_skill_based_routing: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsTwitterObjectSchema = {
  type: 'object',
  description: 'X (formerly Twitter) settings. See [X](#x-formerly-twitter)',
  properties: {
    shorten_url: {
      type: 'string',
    },
  },
} as const;

export const AccountSettingsUserObjectSchema = {
  type: 'object',
  description: 'User settings. See [Users](#users)',
  properties: {
    agent_created_welcome_emails: {
      type: 'boolean',
    },
    end_user_phone_number_validation: {
      type: 'boolean',
    },
    have_gravatars_enabled: {
      type: 'boolean',
    },
    language_selection: {
      type: 'boolean',
    },
    multiple_organizations: {
      type: 'boolean',
    },
    tagging: {
      type: 'boolean',
    },
    time_zone_selection: {
      type: 'boolean',
    },
  },
} as const;

export const AccountSettingsVoiceObjectSchema = {
  type: 'object',
  description: 'Zendesk Talk settings. See [Voice](#voice)',
  properties: {
    agent_confirmation_when_forwarding: {
      type: 'boolean',
    },
    agent_wrap_up_after_calls: {
      type: 'boolean',
    },
    enabled: {
      type: 'boolean',
    },
    logging: {
      type: 'boolean',
    },
    maximum_queue_size: {
      type: 'integer',
    },
    maximum_queue_wait_time: {
      type: 'integer',
    },
    only_during_business_hours: {
      type: 'boolean',
    },
    outbound_enabled: {
      type: 'boolean',
    },
    recordings_public: {
      type: 'boolean',
    },
    uk_mobile_forwarding: {
      type: 'boolean',
    },
  },
} as const;

export const ActionObjectSchema = {
  type: 'object',
  properties: {
    field: {
      type: 'string',
      description: 'The name of a ticket field to modify',
    },
    value: {
      type: 'string',
      description: 'The new value of the field',
    },
  },
} as const;

export const ActionsObjectSchema = {
  type: 'object',
  properties: {
    actions: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ActionObject',
      },
    },
  },
} as const;

export const ActivitiesCountResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'object',
      properties: {
        refreshed_at: {
          type: 'string',
          format: 'date-time',
        },
        value: {
          type: 'integer',
        },
      },
    },
  },
} as const;

export const ActivitiesResponseSchema = {
  type: 'object',
  properties: {
    activities: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ActivityObject',
      },
      readOnly: true,
    },
    actors: {
      type: 'array',
      items: {
        type: 'object',
        additionalProperties: true,
      },
      readOnly: true,
    },
    count: {
      type: 'integer',
      readOnly: true,
    },
    next_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    users: {
      type: 'array',
      items: {
        type: 'object',
        additionalProperties: true,
      },
      readOnly: true,
    },
  },
  example: {
    activities: [
      {
        actor: {
          active: true,
          alias: '',
          created_at: '2020-11-17T00:32:12Z',
          custom_role_id: null,
          default_group_id: 1873,
          details: '',
          email: 'cgoddard+ted@zendesk.com',
          external_id: null,
          iana_time_zone: 'America/Juneau',
          id: 158488612,
          last_login_at: '2020-11-17T00:33:44Z',
          locale: 'en-gb',
          locale_id: 5,
          moderator: true,
          name: 'Tedd',
          notes: '',
          only_private_comments: false,
          organization_id: null,
          phone: null,
          photo: null,
          report_csv: true,
          restricted_agent: false,
          role: 'admin',
          role_type: null,
          shared: false,
          shared_agent: false,
          shared_phone_number: null,
          signature: '',
          suspended: false,
          tags: [],
          ticket_restriction: null,
          time_zone: 'Alaska',
          two_factor_auth_enabled: null,
          updated_at: '2020-11-17T00:34:38Z',
          url: 'https://example.zendesk.com/api/v2/users/158488612.json',
          user_fields: {
            its_remember_september: null,
            skittles: null,
            user_field_1: null,
          },
          verified: true,
        },
        actor_id: 158488612,
        created_at: '2020-11-17T00:34:40Z',
        id: 29183462,
        object: {
          ticket: {
            id: 1521,
            subject: 'test',
          },
        },
        target: {
          ticket: {
            id: 1521,
            subject: 'test',
          },
        },
        title: 'Tedd assigned ticket #1521 to you.',
        updated_at: '2020-11-17T00:34:40Z',
        url: 'https://example.zendesk.com/api/v2/activities/29183462.json',
        user: {
          active: true,
          alias: 'test',
          created_at: '2017-08-14T20:13:53Z',
          custom_role_id: null,
          default_group_id: 1873,
          details: '',
          email: 'user@zendesk.com',
          external_id: 'oev7jj',
          iana_time_zone: 'Pacific/Pago_Pago',
          id: 3343,
          last_login_at: '2020-11-16T22:57:45Z',
          locale: 'en-gb',
          locale_id: 5,
          moderator: true,
          name: 'Samwise Gamgee',
          notes: 'test',
          only_private_comments: false,
          organization_id: 1873,
          phone: null,
          photo: {
            content_type: 'image/gif',
            content_url: 'https://example.zendesk.com/system/photos/8730791/1f84950b8d7949b3.gif',
            deleted: false,
            file_name: '1f84950b8d7949b3.gif',
            height: 80,
            id: 8730791,
            inline: false,
            mapped_content_url: 'https://example.zendesk.com/system/photos/8730791/1f84950b8d7949b3.gif',
            size: 4566,
            thumbnails: [
              {
                content_type: 'image/gif',
                content_url: 'https://example.zendesk.com/system/photos/8730801/1f84950b8d7949b3_thumb.gif',
                deleted: false,
                file_name: '1f84950b8d7949b3_thumb.gif',
                height: 32,
                id: 8730801,
                inline: false,
                mapped_content_url: 'https://example.zendesk.com/system/photos/8730801/1f84950b8d7949b3_thumb.gif',
                size: 1517,
                url: 'https://example.zendesk.com/api/v2/attachments/8730801.json',
                width: 32,
              },
            ],
            url: 'https://example.zendesk.com/api/v2/attachments/8730791.json',
            width: 80,
          },
          report_csv: true,
          restricted_agent: false,
          role: 'admin',
          role_type: null,
          shared: false,
          shared_agent: false,
          shared_phone_number: null,
          signature: 'test',
          suspended: false,
          tags: ['101'],
          ticket_restriction: null,
          time_zone: 'American Samoa',
          two_factor_auth_enabled: null,
          updated_at: '2020-11-17T00:33:55Z',
          url: 'https://example.zendesk.com/api/v2/users/3343.json',
          user_fields: {
            its_remember_september: null,
            skittles: '2018-09-14T00:00:00+00:00',
            user_field_1: '101',
          },
          verified: true,
        },
        user_id: 3343,
        verb: 'tickets.assignment',
      },
    ],
    actors: [
      {
        active: true,
        alias: '',
        created_at: '2020-11-17T00:32:12Z',
        custom_role_id: null,
        default_group_id: 1873,
        details: '',
        email: 'cgoddard+ted@zendesk.com',
        external_id: null,
        iana_time_zone: 'America/Juneau',
        id: 158488612,
        last_login_at: '2020-11-17T00:33:44Z',
        locale: 'en-gb',
        locale_id: 5,
        moderator: true,
        name: 'Tedd',
        notes: '',
        only_private_comments: false,
        organization_id: null,
        phone: null,
        photo: null,
        report_csv: true,
        restricted_agent: false,
        role: 'admin',
        role_type: null,
        shared: false,
        shared_agent: false,
        shared_phone_number: null,
        signature: '',
        suspended: false,
        tags: [],
        ticket_restriction: null,
        time_zone: 'Alaska',
        two_factor_auth_enabled: null,
        updated_at: '2020-11-17T00:34:38Z',
        url: 'https://example.zendesk.com/api/v2/users/158488612.json',
        user_fields: {
          its_remember_september: null,
          skittles: null,
          user_field_1: null,
        },
        verified: true,
      },
    ],
    count: 1,
    next_page: null,
    previous_page: null,
    users: [
      {
        active: true,
        alias: 'test',
        created_at: '2017-08-14T20:13:53Z',
        custom_role_id: null,
        default_group_id: 1873,
        details: '',
        email: 'user@zendesk.com',
        external_id: 'oev7jj',
        iana_time_zone: 'Pacific/Pago_Pago',
        id: 3343,
        last_login_at: '2020-11-16T22:57:45Z',
        locale: 'en-gb',
        locale_id: 5,
        moderator: true,
        name: 'Samwise Gamgee',
        notes: 'test',
        only_private_comments: false,
        organization_id: 1873,
        phone: null,
        photo: {
          content_type: 'image/gif',
          content_url: 'https://example.zendesk.com/system/photos/8730791/1f84950b8d7949b3.gif',
          deleted: false,
          file_name: '1f84950b8d7949b3.gif',
          height: 80,
          id: 8730791,
          inline: false,
          mapped_content_url: 'https://example.zendesk.com/system/photos/8730791/1f84950b8d7949b3.gif',
          size: 4566,
          thumbnails: [
            {
              content_type: 'image/gif',
              content_url: 'https://example.zendesk.com/system/photos/8730801/1f84950b8d7949b3_thumb.gif',
              deleted: false,
              file_name: '1f84950b8d7949b3_thumb.gif',
              height: 32,
              id: 8730801,
              inline: false,
              mapped_content_url: 'https://example.zendesk.com/system/photos/8730801/1f84950b8d7949b3_thumb.gif',
              size: 1517,
              url: 'https://example.zendesk.com/api/v2/attachments/8730801.json',
              width: 32,
            },
          ],
          url: 'https://example.zendesk.com/api/v2/attachments/8730791.json',
          width: 80,
        },
        report_csv: true,
        restricted_agent: false,
        role: 'admin',
        role_type: null,
        shared: false,
        shared_agent: false,
        shared_phone_number: null,
        signature: 'test',
        suspended: false,
        tags: ['101'],
        ticket_restriction: null,
        time_zone: 'American Samoa',
        two_factor_auth_enabled: null,
        updated_at: '2020-11-17T00:33:55Z',
        url: 'https://example.zendesk.com/api/v2/users/3343.json',
        user_fields: {
          its_remember_september: null,
          skittles: '2018-09-14T00:00:00+00:00',
          user_field_1: '101',
        },
        verified: true,
      },
    ],
  },
} as const;

export const ActivityObjectSchema = {
  title: 'Ticket Activities',
  type: 'object',
  properties: {
    actor: {
      type: 'object',
      description:
        'The full user record of the user responsible for the ticket activity. See [Users](/api-reference/ticketing/users/users/)',
      allOf: [
        {
          $ref: '#/components/schemas/UserObject',
        },
      ],
      readOnly: true,
    },
    actor_id: {
      type: 'integer',
      description:
        'The id of the user responsible for the ticket activity. An `actor_id` of "-1" is a Zendesk system user, such as an automations action.',
      readOnly: true,
    },
    created_at: {
      type: 'string',
      description: 'When the record was created',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned on creation',
      readOnly: true,
    },
    object: {
      type: 'object',
      description: 'The content of the activity. Can be a ticket, comment, or change.',
      additionalProperties: true,
      readOnly: true,
    },
    target: {
      type: 'object',
      description: 'The target of the activity, a ticket.',
      additionalProperties: true,
      readOnly: true,
    },
    title: {
      type: 'string',
      description: 'Description of the activity',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      description: 'When the record was last updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of the activity',
      readOnly: true,
    },
    user: {
      type: 'object',
      description:
        'The full user record of the agent making the request. See [Users](/api-reference/ticketing/users/users/)',
      allOf: [
        {
          $ref: '#/components/schemas/UserObject',
        },
      ],
      readOnly: true,
    },
    user_id: {
      type: 'integer',
      description: 'The id of the agent making the request',
      readOnly: true,
    },
    verb: {
      type: 'string',
      description:
        'The type of activity. Can be "tickets.assignment", "tickets.comment", or "tickets.priority_increase"',
      readOnly: true,
    },
  },
  example: {
    actor: {
      id: 8678530,
      name: 'James A. Rosen',
    },
    actor_id: 23546,
    created_at: '2019-03-05T10:38:52Z',
    id: 35,
    object: {},
    target: {},
    title: 'John Hopeful assigned ticket #123 to you',
    updated_at: '2019-03-05T10:38:52Z',
    url: 'https://company.zendesk.com/api/v2/activities/35.json',
    user: {
      id: 223443,
      name: 'Johnny Agent',
    },
    user_id: 29451,
    verb: 'tickets.assignment',
  },
} as const;

export const ActivityResponseSchema = {
  type: 'object',
  properties: {
    activity: {
      $ref: '#/components/schemas/ActivityObject',
    },
  },
  example: {
    activity: {
      actor: {
        active: true,
        alias: '',
        created_at: '2020-11-17T00:32:12Z',
        custom_role_id: null,
        default_group_id: 1873,
        details: '',
        email: 'cgoddard+ted@zendesk.com',
        external_id: null,
        iana_time_zone: 'America/Juneau',
        id: 158488612,
        last_login_at: '2020-11-17T00:33:44Z',
        locale: 'en-gb',
        locale_id: 5,
        moderator: true,
        name: 'Tedd',
        notes: '',
        only_private_comments: false,
        organization_id: null,
        phone: null,
        photo: null,
        report_csv: true,
        restricted_agent: false,
        role: 'admin',
        role_type: null,
        shared: false,
        shared_agent: false,
        shared_phone_number: null,
        signature: '',
        suspended: false,
        tags: [],
        ticket_restriction: null,
        time_zone: 'Alaska',
        two_factor_auth_enabled: null,
        updated_at: '2020-11-17T00:34:38Z',
        url: 'https://example.zendesk.com/api/v2/users/158488612.json',
        user_fields: {
          its_remember_september: null,
          skittles: null,
          user_field_1: null,
        },
        verified: true,
      },
      actor_id: 158488612,
      created_at: '2020-11-17T00:34:40Z',
      id: 29183462,
      object: {
        ticket: {
          id: 1521,
          subject: 'test',
        },
      },
      target: {
        ticket: {
          id: 1521,
          subject: 'test',
        },
      },
      title: 'Tedd assigned ticket #1521 to you.',
      updated_at: '2020-11-17T00:34:40Z',
      url: 'https://example.zendesk.com/api/v2/activities/29183462.json',
      user: {
        active: true,
        alias: 'test',
        created_at: '2017-08-14T20:13:53Z',
        custom_role_id: null,
        default_group_id: 1873,
        details: '',
        email: 'user@zendesk.com',
        external_id: 'oev7jj',
        iana_time_zone: 'Pacific/Pago_Pago',
        id: 3343,
        last_login_at: '2020-11-16T22:57:45Z',
        locale: 'en-gb',
        locale_id: 5,
        moderator: true,
        name: 'Samwise Gamgee',
        notes: 'test',
        only_private_comments: false,
        organization_id: 1873,
        phone: null,
        photo: {
          content_type: 'image/gif',
          content_url: 'https://example.zendesk.com/system/photos/8730791/1f84950b8d7949b3.gif',
          deleted: false,
          file_name: '1f84950b8d7949b3.gif',
          height: 80,
          id: 8730791,
          inline: false,
          mapped_content_url: 'https://example.zendesk.com/system/photos/8730791/1f84950b8d7949b3.gif',
          size: 4566,
          thumbnails: [
            {
              content_type: 'image/gif',
              content_url: 'https://example.zendesk.com/system/photos/8730801/1f84950b8d7949b3_thumb.gif',
              deleted: false,
              file_name: '1f84950b8d7949b3_thumb.gif',
              height: 32,
              id: 8730801,
              inline: false,
              mapped_content_url: 'https://example.zendesk.com/system/photos/8730801/1f84950b8d7949b3_thumb.gif',
              size: 1517,
              url: 'https://example.zendesk.com/api/v2/attachments/8730801.json',
              width: 32,
            },
          ],
          url: 'https://example.zendesk.com/api/v2/attachments/8730791.json',
          width: 80,
        },
        report_csv: true,
        restricted_agent: false,
        role: 'admin',
        role_type: null,
        shared: false,
        shared_agent: false,
        shared_phone_number: null,
        signature: 'test',
        suspended: false,
        tags: ['101'],
        ticket_restriction: null,
        time_zone: 'American Samoa',
        two_factor_auth_enabled: null,
        updated_at: '2020-11-17T00:33:55Z',
        url: 'https://example.zendesk.com/api/v2/users/3343.json',
        user_fields: {
          its_remember_september: null,
          skittles: '2018-09-14T00:00:00+00:00',
          user_field_1: '101',
        },
        verified: true,
      },
      user_id: 3343,
      verb: 'tickets.assignment',
    },
  },
} as const;

export const AssigneeFieldAssignableAgentObjectSchema = {
  title: 'AssigneeFieldAssignableAgents',
  type: 'object',
  properties: {
    avatar_url: {
      type: 'string',
      description: "URL of Agent's avatar",
      nullable: true,
    },
    id: {
      type: 'integer',
      description: 'Agent Support ID',
    },
    name: {
      type: 'string',
      description: 'Name of the agent',
    },
  },
  example: {
    avatar_url: 'https://z3n-example.zendesk.com/system/photos/900005192023/my_profile.png',
    id: 6473829100,
    name: 'Joe Smith',
  },
} as const;

export const AssigneeFieldAssignableGroupAgentsResponseSchema = {
  type: 'object',
  properties: {
    agents: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AssigneeFieldAssignableAgentObject',
      },
    },
    count: {
      type: 'integer',
      description: 'Number of agents listed in `agents` property.',
    },
    next_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
  },
  example: {
    agents: [
      {
        avatar_url: 'https://z3n-example.zendesk.com/system/photos/900005192023/my_profile.png',
        id: 6473829100,
        name: 'Joe Smith',
      },
      {
        avatar_url: 'https://z3n-example.zendesk.com/system/photos/412005192023/my_profile.png',
        id: 9182736400,
        name: 'Jane Doe',
      },
      {
        avatar_url: 'https://z3n-example.zendesk.com/system/photos/887005192023/my_profile.png',
        id: 1928373460,
        name: 'Cookie Monster',
      },
    ],
    count: 3,
    next_page: null,
    previous_page: null,
  },
} as const;

export const AssigneeFieldAssignableGroupObjectSchema = {
  title: 'AssigneeFieldAssignableGroups',
  type: 'object',
  properties: {
    description: {
      type: 'string',
      description: 'Description of the group',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Group ID',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'Name of the group',
      readOnly: true,
    },
  },
  example: {
    description: 'Engineering team for bugs',
    id: 9182736455,
    name: 'Engineering',
  },
} as const;

export const AssigneeFieldAssignableGroupsAndAgentsSearchResponseSchema = {
  type: 'object',
  properties: {
    agents: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AssigneeFieldAssignableSearchAgentObject',
      },
    },
    count: {
      type: 'integer',
      description: 'Number of agents + groups listed from search result.',
    },
    groups: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AssigneeFieldAssignableSearchGroupObject',
      },
    },
  },
  example: {
    agents: [
      {
        group: 'Tech',
        group_id: 6574839201,
        id: 8392017465,
        name: 'Sam Technologist',
        photo_url: 'https://z3n-example.zendesk.com/system/photos/410305192023/my_profile.png',
      },
    ],
    count: 2,
    groups: [
      {
        id: 6574839201,
        name: 'Tech',
      },
    ],
  },
} as const;

export const AssigneeFieldAssignableGroupsResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      description: 'Number of groups listed in `groups` property.',
    },
    groups: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AssigneeFieldAssignableGroupObject',
      },
    },
    next_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
  },
  example: {
    count: 3,
    groups: [
      {
        description: 'Engineering',
        id: 9182736455,
        name: 'Group for Bugs for Engineering',
      },
      {
        description: 'Product',
        id: 1928374655,
        name: 'Group for feature requests',
      },
      {
        description: 'Customer Support',
        id: 5519283746,
        name: 'Group for customer inquiries',
      },
    ],
    next_page: null,
    previous_page: null,
  },
} as const;

export const AssigneeFieldAssignableSearchAgentObjectSchema = {
  type: 'object',
  properties: {
    group: {
      type: 'string',
      description: "Name of the agent's group",
    },
    group_id: {
      type: 'integer',
      description: "Agent's Group ID",
    },
    id: {
      type: 'integer',
      description: 'Agent ID',
    },
    name: {
      type: 'string',
      description: 'Name of the agent',
    },
    photo_url: {
      type: 'string',
      description: 'URL of Avatar',
      nullable: true,
    },
  },
  example: {
    group: 'Engineering',
    group_id: 9182736455,
    id: 6473829100,
    name: 'Joe Smith',
    photo_url: 'https://z3n-example.zendesk.com/system/photos/900005192023/my_profile.png',
  },
} as const;

export const AssigneeFieldAssignableSearchGroupObjectSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'integer',
      description: 'Group ID',
    },
    name: {
      type: 'string',
      description: 'Name of the group',
    },
  },
  example: {
    id: 9182736455,
    name: 'Engineering',
  },
} as const;

export const AttachmentBaseObjectSchema = {
  type: 'object',
  properties: {
    content_type: {
      type: 'string',
      description: 'The content type of the image. Example value: "image/png"',
      readOnly: true,
    },
    content_url: {
      type: 'string',
      description:
        'A full URL where the attachment image file can be downloaded. The file may be hosted externally so take care not to inadvertently send Zendesk authentication credentials. See [Working with url properties](/documentation/ticketing/managing-tickets/working-with-url-properties)',
      readOnly: true,
    },
    deleted: {
      type: 'boolean',
      description: 'If true, the attachment has been deleted',
      readOnly: true,
    },
    file_name: {
      type: 'string',
      description: 'The name of the image file',
      readOnly: true,
    },
    height: {
      type: 'string',
      description: 'The height of the image file in pixels. If height is unknown, returns null',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when created',
      readOnly: true,
    },
    inline: {
      type: 'boolean',
      description: `If true, the attachment is excluded from the attachment list and the attachment's URL
can be referenced within the comment of a ticket. Default is false
`,
      readOnly: true,
    },
    malware_access_override: {
      type: 'boolean',
      description:
        "If true, you can download an attachment flagged as malware. If false, you can't download such an attachment.",
      readOnly: true,
    },
    malware_scan_result: {
      type: 'string',
      description:
        'The result of the malware scan. There is a delay between the time the attachment is uploaded and when the malware scan is completed. Usually the scan is done within a few seconds, but high load conditions can delay the scan results. Possible values: "malware_found", "malware_not_found", "failed_to_scan", "not_scanned"',
      readOnly: true,
    },
    mapped_content_url: {
      type: 'string',
      description: 'The URL the attachment image file has been mapped to',
      readOnly: true,
    },
    size: {
      type: 'integer',
      description: 'The size of the image file in bytes',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'A URL to access the attachment details',
      readOnly: true,
    },
    width: {
      type: 'string',
      description: 'The width of the image file in pixels. If width is unknown, returns null',
      readOnly: true,
    },
  },
} as const;

export const AttachmentObjectSchema = {
  type: 'object',
  description: 'A file represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object',
  allOf: [
    {
      $ref: '#/components/schemas/AttachmentBaseObject',
    },
    {
      $ref: '#/components/schemas/AttachmentThumbnails',
    },
  ],
  example: {
    content_type: 'image/png',
    content_url: 'https://company.zendesk.com/attachments/my_funny_profile_pic.png',
    file_name: 'my_funny_profile_pic.png',
    id: 928374,
    size: 166144,
    thumbnails: [
      {
        content_type: 'image/png',
        content_url: 'https://company.zendesk.com/attachments/my_funny_profile_pic_thumb.png',
        file_name: 'my_funny_profile_pic_thumb.png',
        id: 928375,
        size: 58298,
      },
    ],
  },
} as const;

export const AttachmentResponseSchema = {
  type: 'object',
  properties: {
    attachment: {
      $ref: '#/components/schemas/AttachmentObject',
    },
  },
} as const;

export const AttachmentThumbnailsSchema = {
  type: 'object',
  properties: {
    thumbnails: {
      type: 'array',
      description: 'An array of attachment objects. Note that photo thumbnails do not have thumbnails',
      items: {
        $ref: '#/components/schemas/AttachmentBaseObject',
      },
      readOnly: true,
    },
  },
} as const;

export const AttachmentUpdateInputSchema = {
  type: 'object',
  properties: {
    malware_access_override: {
      type: 'boolean',
      description: 'If true, allows access to attachments with detected malware.',
    },
  },
} as const;

export const AttachmentUpdateRequestSchema = {
  type: 'object',
  properties: {
    attachment: {
      $ref: '#/components/schemas/AttachmentUpdateInput',
    },
  },
} as const;

export const AttachmentUploadResponseSchema = {
  type: 'object',
  properties: {
    upload: {
      type: 'object',
      properties: {
        attachment: {
          $ref: '#/components/schemas/AttachmentObject',
        },
        attachments: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/AttachmentObject',
          },
        },
        token: {
          type: 'string',
          description: 'Token for subsequent request',
          readOnly: true,
        },
      },
    },
  },
} as const;

export const AuditLogObjectSchema = {
  type: 'object',
  properties: {
    action: {
      type: 'string',
      description: `Type of change made. Possible values are "create", "destroy", "exported", "login", and "update"
`,
      readOnly: true,
    },
    action_label: {
      type: 'string',
      description: 'Localized string of action field',
      readOnly: true,
    },
    actor_id: {
      type: 'integer',
      description: 'id of the user or system that initiated the change',
      readOnly: true,
    },
    actor_name: {
      type: 'string',
      description: 'Name of the user or system that initiated the change',
      readOnly: true,
    },
    change_description: {
      type: 'string',
      description: 'The description of the change that occurred',
      readOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the audit got created',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'The id automatically assigned upon creation',
      readOnly: true,
    },
    ip_address: {
      type: 'string',
      description: 'The IP address of the user doing the audit',
      readOnly: true,
    },
    source_id: {
      type: 'integer',
      description: 'The id of the item being audited',
      readOnly: true,
    },
    source_label: {
      type: 'string',
      description: 'The name of the item being audited',
      readOnly: true,
    },
    source_type: {
      type: 'string',
      description: `Item type being audited. Typically describes the system where the change
was initiated. Possible values vary based on your account's Zendesk
products and activity. Common values include "apitoken", "rule", "ticket",
"user", and "zendesk/app_market/app". The "rule" value is used for
[automations](https://support.zendesk.com/hc/en-us/articles/4408832701850),
[macros](https://support.zendesk.com/hc/en-us/articles/4408844187034),
[triggers](https://support.zendesk.com/hc/en-us/articles/4408822236058),
[views](https://support.zendesk.com/hc/en-us/articles/4408888828570),
and other automated business rules
`,
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The URL to access the audit log',
      readOnly: true,
    },
  },
  example: {
    action: 'update',
    action_label: 'Updated',
    actor_id: 1234,
    actor_name: 'Sameer Patel',
    change_description: 'Role changed from Administrator to End User',
    created_at: '2012-03-05T11:32:44Z',
    id: 498483,
    ip_address: '209.119.38.228',
    source_id: 3456,
    source_label: 'John Doe',
    source_type: 'user',
    url: 'https://company.zendesk.com/api/v2/audit_logs/498483.json',
  },
} as const;

export const AuditLogResponseSchema = {
  type: 'object',
  properties: {
    audit_log: {
      $ref: '#/components/schemas/AuditLogObject',
    },
  },
} as const;

export const AuditLogsResponseSchema = {
  type: 'object',
  properties: {
    audit_logs: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AuditLogObject',
      },
    },
  },
} as const;

export const AuditObjectSchema = {
  type: 'object',
  properties: {
    author_id: {
      type: 'integer',
      readOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      readOnly: true,
    },
    events: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          body: {
            type: 'string',
            readOnly: true,
          },
          field_name: {
            type: 'string',
            readOnly: true,
          },
          id: {
            type: 'integer',
            readOnly: true,
          },
          type: {
            type: 'string',
            readOnly: true,
          },
          value: {
            oneOf: [
              {
                type: 'string',
              },
              {
                type: 'integer',
              },
            ],
          },
        },
      },
      readOnly: true,
    },
    id: {
      type: 'integer',
      readOnly: true,
    },
    metadata: {
      type: 'object',
      readOnly: true,
    },
    ticket_id: {
      type: 'integer',
      readOnly: true,
    },
    via: {
      $ref: '#/components/schemas/ViaObject',
    },
  },
} as const;

export const AuthorObjectSchema = {
  type: 'object',
  properties: {
    email: {
      type: 'string',
      description: 'The author email',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'The author id',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'The author name',
      readOnly: true,
    },
  },
} as const;

export const AutomationObjectSchema = {
  type: 'object',
  properties: {
    actions: {
      type: 'array',
      description:
        'An object describing what the automation will do. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)',
      items: {
        $ref: '#/components/schemas/ActionObject',
      },
    },
    active: {
      type: 'boolean',
      description: 'Whether the automation is active',
    },
    conditions: {
      $ref: '#/components/schemas/ConditionsObject',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the automation was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: 'If true, the automation is a default automation',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when created',
      readOnly: true,
    },
    position: {
      type: 'integer',
      description: 'The position of the automation which specifies the order it will be executed',
    },
    raw_title: {
      type: 'string',
      description: 'The raw title of the automation',
      readOnly: true,
    },
    title: {
      type: 'string',
      description: 'The title of the automation',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the automation',
      readOnly: true,
    },
  },
  example: {
    actions: [
      {
        field: 'priority',
        value: 'high',
      },
    ],
    active: true,
    conditions: {
      all: [
        {
          field: 'status',
          operator: 'is',
          value: 'open',
        },
        {
          field: 'priority',
          operator: 'less_than',
          value: 'high',
        },
      ],
      any: [],
    },
    default: false,
    id: 9873843,
    position: 8,
    raw_title: 'Roger Wilco',
    title: 'Roger Wilco',
  },
} as const;

export const AutomationResponseSchema = {
  type: 'object',
  properties: {
    automation: {
      $ref: '#/components/schemas/AutomationObject',
    },
  },
} as const;

export const AutomationsResponseSchema = {
  type: 'object',
  properties: {
    automations: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AutomationObject',
      },
    },
    count: {
      type: 'integer',
      readOnly: true,
    },
    next_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
  },
} as const;

export const BatchErrorItemSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/Error',
    },
    {
      type: 'object',
      properties: {
        trigger_id: {
          type: 'string',
        },
      },
    },
  ],
} as const;

export const BatchJobRequestSchema = {
  type: 'object',
  properties: {
    job: {
      type: 'object',
      properties: {
        action: {
          type: 'string',
          enum: ['patch'],
        },
        items: {
          type: 'object',
          properties: {
            trigger_categories: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/TriggerCategoryBatchRequest',
              },
            },
            triggers: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/TriggerBatchRequest',
              },
            },
          },
        },
      },
    },
  },
} as const;

export const BatchJobResponseSchema = {
  type: 'object',
  properties: {
    errors: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/BatchErrorItem',
      },
    },
    results: {
      type: 'object',
      properties: {
        trigger_categories: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/TriggerCategory',
          },
        },
        triggers: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/TriggerObject',
          },
        },
      },
    },
    status: {
      type: 'string',
      enum: ['complete', 'failed'],
    },
  },
} as const;

export const BookmarkCreateRequestSchema = {
  type: 'object',
  properties: {
    bookmark: {
      $ref: '#/components/schemas/BookmarkInput',
    },
  },
} as const;

export const BookmarkInputSchema = {
  type: 'object',
  properties: {
    ticket_id: {
      type: 'integer',
      description: 'The id of the ticket the bookmark is for.',
    },
  },
} as const;

export const BookmarkObjectSchema = {
  title: 'Bookmarks',
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the bookmark was created',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when the bookmark is created',
      readOnly: true,
    },
    ticket: {
      type: 'object',
      allOf: [
        {
          $ref: '#/components/schemas/TicketObject',
        },
      ],
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this bookmark',
      readOnly: true,
    },
  },
  example: {
    created_at: '2014-11-20T22:55:29Z',
    id: 35436,
    ticket: {
      description: 'The fire is very colorful.',
      id: 60,
      priority: 'high',
      requester_id: 156,
      subject: 'Help, my printer is on fire!',
    },
    url: 'https://{subdomain}.zendesk.com/api/v2/bookmarks/35436.json',
  },
} as const;

export const BookmarkResponseSchema = {
  type: 'object',
  properties: {
    bookmark: {
      $ref: '#/components/schemas/BookmarkObject',
    },
  },
} as const;

export const BookmarksResponseSchema = {
  title: 'Bookmarks',
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/OffsetPaginationObject',
    },
    {
      type: 'object',
      properties: {
        bookmarks: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/BookmarkObject',
          },
        },
      },
    },
  ],
} as const;

export const BrandCreateRequestSchema = {
  type: 'object',
  properties: {
    brand: {
      $ref: '#/components/schemas/BrandObject',
    },
  },
} as const;

export const BrandObjectSchema = {
  title: 'Brands',
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'If the brand is set as active',
    },
    brand_url: {
      type: 'string',
      description: 'The url of the brand',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the brand was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: 'Is the brand the default brand for this account',
    },
    has_help_center: {
      type: 'boolean',
      description: 'If the brand has a Help Center',
    },
    help_center_state: {
      type: 'string',
      description: 'The state of the Help Center',
      enum: ['enabled', 'disabled', 'restricted'],
      readOnly: true,
    },
    host_mapping: {
      type: 'string',
      description: 'The hostmapping to this brand, if any. Only admins view this property.',
    },
    id: {
      type: 'integer',
      description: 'The ID automatically assigned when the brand is created',
      readOnly: true,
    },
    is_deleted: {
      type: 'boolean',
      description: 'If the brand object is deleted or not',
    },
    logo: {
      $ref: '#/components/schemas/AttachmentObject',
    },
    name: {
      type: 'string',
      description: 'The name of the brand',
    },
    signature_template: {
      type: 'string',
      description: 'The signature template for a brand',
    },
    subdomain: {
      type: 'string',
      description: 'The subdomain of the brand',
    },
    ticket_form_ids: {
      type: 'array',
      description: 'The ids of ticket forms that are available for use by a brand',
      items: {
        type: 'integer',
      },
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the brand',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this brand',
      readOnly: true,
    },
  },
  example: {
    active: true,
    brand_url: 'https://brand1.com',
    created_at: '2012-04-02T22:55:29Z',
    default: true,
    has_help_center: true,
    help_center_state: 'enabled',
    host_mapping: 'brand1.com',
    id: 47,
    logo: {
      content_type: 'image/png',
      content_url: 'https://company.zendesk.com/logos/brand1_logo.png',
      file_name: 'brand1_logo.png',
      id: 928374,
      size: 166144,
      thumbnails: [
        {
          content_type: 'image/png',
          content_url: 'https://company.zendesk.com/photos/brand1_logo_thumb.png',
          file_name: 'brand1_logo_thumb.png',
          id: 928375,
          mapped_content_url: 'https://company.com/photos/brand1_logo_thumb.png',
          size: 58298,
          url: 'https://company.zendesk.com/api/v2/attachments/928375.json',
        },
        {
          content_type: 'image/png',
          content_url: 'https://company.zendesk.com/photos/brand1_logo_small.png',
          file_name: 'brand1_logo_small.png',
          id: 928376,
          mapped_content_url: 'https://company.com/photos/brand1_logo_small.png',
          size: 58298,
          url: 'https://company.zendesk.com/api/v2/attachments/928376.json',
        },
      ],
      url: 'https://company.zendesk.com/api/v2/attachments/928374.json',
    },
    name: 'Brand 1',
    signature_template: '{{agent.signature}}',
    subdomain: 'brand1',
    ticket_form_ids: [47, 33, 22],
    updated_at: '2012-04-02T22:55:29Z',
    url: 'https://company.zendesk.com/api/v2/brands/47.json',
  },
  required: ['name', 'subdomain'],
} as const;

export const BrandResponseSchema = {
  type: 'object',
  properties: {
    brand: {
      $ref: '#/components/schemas/BrandObject',
    },
  },
} as const;

export const BrandUpdateRequestSchema = {
  type: 'object',
  properties: {
    brand: {
      $ref: '#/components/schemas/BrandObject',
    },
  },
} as const;

export const BrandsResponseSchema = {
  title: 'Brands',
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/OffsetPaginationObject',
    },
    {
      type: 'object',
      properties: {
        brands: {
          type: 'array',
          description: 'Array of brands',
          items: {
            $ref: '#/components/schemas/BrandObject',
          },
        },
      },
    },
  ],
} as const;

export const BulkUpdateDefaultCustomStatusRequestSchema = {
  type: 'object',
  properties: {
    ids: {
      type: 'string',
      description:
        'The comma-separated list of custom ticket status ids to be set as default for their status categories',
    },
  },
} as const;

export const BulkUpdateDefaultCustomStatusResponseSchema = {
  type: 'object',
} as const;

export const ChannelFrameworkPushResultsResponseSchema = {
  type: 'object',
  properties: {
    results: {
      type: 'array',
      description: 'An array of [result objects](#result-object)',
      items: {
        $ref: '#/components/schemas/ChannelFrameworkResultObject',
      },
    },
  },
} as const;

export const ChannelFrameworkResultObjectSchema = {
  type: 'object',
  properties: {
    external_resource_id: {
      type: 'string',
      description: 'The external ID of the resource, as passed in',
      readOnly: true,
    },
    status: {
      $ref: '#/components/schemas/ChannelFrameworkResultStatusObject',
    },
  },
} as const;

export const ChannelFrameworkResultStatusObjectSchema = {
  type: 'object',
  description: 'The status of the import for the indicated resource',
  properties: {
    code: {
      type: 'string',
      description:
        'A code indicating the status of the import of the resource, as described in [status codes](#status-codes)',
      readOnly: true,
    },
    description: {
      type: 'string',
      description: 'In the case of an exception, a description of the exception. Otherwise, not present.',
      readOnly: true,
    },
  },
} as const;

export const CollaboratorObjectSchema = {
  type: 'object',
  properties: {
    email: {
      type: 'string',
      format: 'email',
    },
    name: {
      type: 'string',
    },
  },
  example: {
    email: 'someone@example.com',
    name: 'Someone Special',
  },
} as const;

export const ComplianceDeletionStatusObjectSchema = {
  type: 'object',
  properties: {
    account_subdomain: {
      type: 'string',
    },
    action: {
      type: 'string',
    },
    application: {
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    executer_id: {
      type: 'integer',
      nullable: true,
    },
    user_id: {
      type: 'integer',
    },
  },
  required: ['action', 'application', 'account_subdomain', 'executer_id', 'user_id', 'created_at'],
} as const;

export const ComplianceDeletionStatusesResponseSchema = {
  type: 'object',
  properties: {
    compliance_deletion_statuses: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ComplianceDeletionStatusObject',
      },
    },
  },
} as const;

export const ConditionObjectSchema = {
  type: 'object',
  properties: {
    field: {
      type: 'string',
      description: 'The name of a ticket field',
    },
    operator: {
      type: 'string',
      description: 'A comparison operator',
    },
    value: {
      type: 'string',
      description: 'The value of a ticket field',
    },
  },
} as const;

export const ConditionsObjectSchema = {
  type: 'object',
  description:
    'An object that describes the conditions under which the automation will execute. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)',
  properties: {
    all: {
      type: 'array',
      description: 'Logical AND. Tickets must fulfill all of the conditions to be considered matching',
      items: {
        $ref: '#/components/schemas/ConditionObject',
      },
    },
    any: {
      type: 'array',
      description: 'Logical OR. Tickets may satisfy any of the conditions to be considered matching',
      items: {
        $ref: '#/components/schemas/ConditionObject',
      },
    },
  },
} as const;

export const CountOrganizationObjectSchema = {
  type: 'object',
  properties: {
    refreshed_at: {
      type: 'string',
      readOnly: true,
    },
    value: {
      type: 'integer',
      readOnly: true,
    },
  },
} as const;

export const CountOrganizationResponseSchema = {
  type: 'object',
  properties: {
    count: {
      $ref: '#/components/schemas/CountOrganizationObject',
    },
  },
} as const;

export const CountResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'object',
      properties: {
        refreshed_at: {
          type: 'string',
          format: 'datetime',
        },
        value: {
          type: 'integer',
        },
      },
    },
  },
} as const;

export const CreateOrganizationRequestSchema = {
  type: 'object',
  properties: {
    organization: {
      $ref: '#/components/schemas/OrganizationObject',
    },
  },
  required: ['organization'],
} as const;

export const CreateResourceResultSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'integer',
      description: 'the id of the new resource',
    },
    index: {
      type: 'integer',
      description: 'the index number of the resul',
    },
  },
  required: ['id', 'index'],
} as const;

export const CurrentUserResponseSchema = {
  type: 'object',
  properties: {
    user: {
      allOf: [
        {
          $ref: '#/components/schemas/UserObject',
        },
        {
          type: 'object',
          properties: {
            authenticity_token: {
              type: 'string',
              description: 'CSRF token required by some Zendesk APIs.',
              readOnly: true,
            },
          },
        },
      ],
    },
  },
} as const;

export const CursorBasedExportIncrementalTicketsResponseSchema = {
  type: 'object',
  description: `See [Tickets](/api-reference/ticketing/tickets/tickets/) for a detailed example.
`,
  properties: {
    after_cursor: {
      type: 'string',
      nullable: true,
    },
    after_url: {
      type: 'string',
      nullable: true,
    },
    before_cursor: {
      type: 'string',
      nullable: true,
    },
    before_url: {
      type: 'string',
      nullable: true,
    },
    end_of_stream: {
      type: 'boolean',
    },
    tickets: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketObject',
      },
    },
  },
  example: {
    after_cursor: 'MTU3NjYxMzUzOS4wfHw0Njd8',
    after_url: 'https://{subdomain}.zendesk.com/api/v2/incremental/tickets/cursor.json?cursor=MTU3NjYxMzUzOS4wfHw0Njd8',
    before_cursor: null,
    before_url: null,
    end_of_stream: true,
    tickets: [
      {
        assignee_id: 235323,
        collaborator_ids: [35334, 234],
        created_at: '2009-07-20T22:55:29Z',
        custom_fields: [
          {
            id: 27642,
            value: '745',
          },
          {
            id: 27648,
            value: 'yes',
          },
        ],
        description: 'The fire is very colorful.',
        due_at: null,
        external_id: 'ahg35h3jh',
        follower_ids: [35334, 234],
        generated_timestamp: 1304553600,
        group_id: 98738,
        has_incidents: false,
        id: 35436,
        organization_id: 509974,
        priority: 'high',
        problem_id: 9873764,
        raw_subject: '{{dc.printer_on_fire}}',
        recipient: 'support@company.com',
        requester_id: 20978392,
        satisfaction_rating: {
          comment: 'Great support!',
          id: 1234,
          score: 'good',
        },
        sharing_agreement_ids: [84432],
        status: 'open',
        subject: 'Help, my printer is on fire!',
        submitter_id: 76872,
        tags: ['enterprise', 'other_tag'],
        type: 'incident',
        updated_at: '2011-05-05T10:38:52Z',
        url: 'https://company.zendesk.com/api/v2/tickets/35436.json',
        via: {
          channel: 'web',
        },
      },
    ],
  },
} as const;

export const CursorBasedExportIncrementalUsersResponseSchema = {
  type: 'object',
  properties: {
    after_cursor: {
      type: 'string',
      nullable: true,
    },
    after_url: {
      type: 'string',
      nullable: true,
    },
    before_cursor: {
      type: 'string',
      nullable: true,
    },
    before_url: {
      type: 'string',
      nullable: true,
    },
    end_of_stream: {
      type: 'boolean',
    },
    users: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/UserObject',
      },
    },
  },
  example: {
    after_cursor: 'MTU3NjYxMzUzOS4wfHw0Njd8',
    after_url: 'https://example.zendesk.com/api/v2/incremental/users/cursor.json?cursor=MTU3NjYxMzUzOS4wfHw0Njd8',
    before_cursor: null,
    before_url: null,
    end_of_stream: true,
    users: [
      {
        active: true,
        alias: 'Mr. Johnny',
        created_at: '2009-07-20T22:55:29Z',
        custom_role_id: 9373643,
        details: '',
        email: 'johnny@example.com',
        external_id: 'sai989sur98w9',
        id: 35436,
        last_login_at: '2011-05-05T10:38:52Z',
        locale: 'en-US',
        locale_id: 1,
        moderator: true,
        name: 'Johnny Agent',
        notes: 'Johnny is a nice guy!',
        only_private_comments: false,
        organization_id: 57542,
        phone: '+15551234567',
        photo: {
          content_type: 'image/png',
          content_url: 'https://company.zendesk.com/photos/my_funny_profile_pic.png',
          id: 928374,
          name: 'my_funny_profile_pic.png',
          size: 166144,
          thumbnails: [
            {
              content_type: 'image/png',
              content_url: 'https://company.zendesk.com/photos/my_funny_profile_pic_thumb.png',
              id: 928375,
              name: 'my_funny_profile_pic_thumb.png',
              size: 58298,
            },
          ],
        },
        restricted_agent: true,
        role: 'agent',
        role_type: 0,
        shared: false,
        shared_agent: false,
        signature: 'Have a nice day, Johnny',
        suspended: true,
        tags: ['enterprise', 'other_tag'],
        ticket_restriction: 'assigned',
        time_zone: 'Copenhagen',
        updated_at: '2011-05-05T10:38:52Z',
        url: 'https://company.zendesk.com/api/v2/users/35436.json',
        user_fields: {
          user_date: '2012-07-23T00:00:00Z',
          user_decimal: 5.1,
          user_dropdown: 'option_1',
        },
        verified: true,
      },
    ],
  },
} as const;

export const CustomFieldObjectSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'If true, this field is available for use',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the ticket field',
      readOnly: true,
    },
    custom_field_options: {
      type: 'array',
      description:
        'Required and presented for a custom field of type "dropdown". Each option is represented by an object with a `name` and `value` property',
      items: {
        $ref: '#/components/schemas/CustomFieldOptionObject',
      },
    },
    description: {
      type: 'string',
      description: "User-defined description of this field's purpose",
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned upon creation',
      readOnly: true,
    },
    key: {
      type: 'string',
      description:
        "A unique key that identifies this custom field. This is used for updating the field and referencing in placeholders. The key must consist of only letters, numbers, and underscores. It can't be only numbers",
    },
    position: {
      type: 'integer',
      description: 'Ordering of the field relative to other fields',
    },
    raw_description: {
      type: 'string',
      description:
        'The dynamic content placeholder, if present, or the `description` value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    raw_title: {
      type: 'string',
      description:
        'The dynamic content placeholder, if present, or the `title` value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    regexp_for_validation: {
      type: 'string',
      description: 'Regular expression field only. The validation pattern for a field value to be deemed valid',
      nullable: true,
    },
    relationship_filter: {
      type: 'object',
      description: 'A filter definition that allows your autocomplete to filter down results',
    },
    relationship_target_type: {
      type: 'string',
      description:
        'A representation of what type of object the field references. Options are "zen:user", "zen:organization", "zen:ticket", and "zen:custom_object:{key}" where key is a custom object key. For example "zen:custom_object:apartment".',
    },
    system: {
      type: 'boolean',
      description: 'If true, only active and position values of this field can be changed',
      readOnly: true,
    },
    tag: {
      type: 'string',
      description: 'Optional for custom field of type "checkbox"; not presented otherwise.',
    },
    title: {
      type: 'string',
      description: 'The title of the custom field',
    },
    type: {
      type: 'string',
      description:
        'The custom field type: "checkbox", "date", "decimal", "dropdown", "integer", ["lookup"](/api-reference/ticketing/lookup_relationships/lookup_relationships/), "multiselect", "regexp", "text", or "textarea"',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the ticket field',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The URL for this resource',
      readOnly: true,
    },
  },
  required: ['key', 'type', 'title'],
} as const;

export const CustomFieldOptionObjectSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'integer',
      description: 'Automatically assigned upon creation',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'Name of the dropdown option',
    },
    position: {
      type: 'integer',
      description: 'Position of the dropdown option',
    },
    raw_name: {
      type: 'string',
      description: 'Raw name of the dropdown option',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'URL of the dropdown option',
      readOnly: true,
    },
    value: {
      type: 'string',
      description: 'Value of the dropdown option',
    },
  },
  required: ['name', 'value'],
} as const;

export const CustomFieldOptionResponseSchema = {
  type: 'object',
  properties: {
    custom_field_option: {
      $ref: '#/components/schemas/CustomFieldOptionObject',
    },
  },
} as const;

export const CustomFieldOptionsResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      description: 'Total count of records retrieved',
      readOnly: true,
    },
    custom_field_options: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CustomFieldOptionObject',
      },
    },
    next_page: {
      type: 'string',
      description: 'URL of the next page',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      description: 'URL of the previous page',
      nullable: true,
      readOnly: true,
    },
  },
} as const;

export const CustomObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the object type was created',
      readOnly: true,
    },
    created_by_user_id: {
      type: 'string',
      description: 'Id of a user who created the object',
      readOnly: true,
    },
    description: {
      type: 'string',
      description: 'User-defined description of the object',
    },
    include_in_list_view: {
      type: 'boolean',
      description:
        "A flag setting the visibility of the object in the agent's list view. If true, all agents and admins have viewing access to the object in the Custom objects record page in the Agent Workspace. If false, only admins have viewing access",
    },
    key: {
      type: 'string',
      description: 'A user-defined unique identifier. Writable on create only',
      readOnly: true,
    },
    raw_description: {
      type: 'string',
      description:
        'The dynamic content placeholder, if present, or the "raw_description" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    raw_title: {
      type: 'string',
      description:
        'The dynamic content placeholder, if present, or the "title" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    raw_title_pluralized: {
      type: 'string',
      description:
        'The dynamic content placeholder, if present, or the "raw_title_pluralized" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    title: {
      type: 'string',
      description: 'User-defined display name for the object',
    },
    title_pluralized: {
      type: 'string',
      description: "User-defined pluralized version of the object's title",
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the object',
      readOnly: true,
    },
    updated_by_user_id: {
      type: 'string',
      description: 'Id of the last user who updated the object',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'Direct link to the specific custom object',
      readOnly: true,
    },
  },
  required: ['key', 'title', 'title_pluralized', 'include_in_list_view'],
} as const;

export const CustomObjectCreateInputSchema = {
  type: 'object',
  properties: {
    key: {
      type: 'string',
      description: 'Unique identifier. Writable on create only',
    },
    title: {
      type: 'string',
      description: 'Display name for the object',
    },
    title_pluralized: {
      type: 'string',
      description: "Pluralized version of the object's title",
    },
  },
} as const;

export const CustomObjectFieldSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/CustomFieldObject',
    },
  ],
  example: {
    active: true,
    created_at: '2022-09-07T23:21:59Z',
    description: 'Make',
    id: 4398096842879,
    key: 'make',
    position: 0,
    raw_description: 'Make',
    raw_title: 'Make',
    regexp_for_validation: null,
    system: false,
    title: 'Make',
    type: 'text',
    updated_at: '2022-09-07T23:22:00Z',
    url: 'https://company.zendesk.com/api/v2/custom_objects/car/fields/4398096842879.json',
  },
} as const;

export const CustomObjectFieldResponseSchema = {
  type: 'object',
  properties: {
    custom_object_field: {
      $ref: '#/components/schemas/CustomObjectField',
    },
  },
} as const;

export const CustomObjectFieldsCreateRequestSchema = {
  type: 'object',
  properties: {
    custom_object_field: {
      $ref: '#/components/schemas/CustomObjectField',
    },
  },
} as const;

export const CustomObjectFieldsResponseSchema = {
  type: 'object',
  properties: {
    custom_object_fields: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CustomObjectField',
      },
    },
  },
} as const;

export const CustomObjectLimitsResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      description: 'The current numnber of the requested resource',
      readOnly: true,
    },
    limit: {
      type: 'integer',
      description: 'The maximum allowed number for the requested resource',
      readOnly: true,
    },
  },
} as const;

export const CustomObjectRecordSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the object was created',
      readOnly: true,
    },
    created_by_user_id: {
      type: 'string',
      description: 'Id of a user who created the object',
      readOnly: true,
    },
    custom_object_fields: {
      type: 'object',
      additionalProperties: true,
    },
    custom_object_key: {
      type: 'string',
      description: 'A user-defined unique identifier',
      readOnly: true,
    },
    external_id: {
      type: 'string',
      description: 'An id you can use to link custom object records to external data',
      nullable: true,
    },
    id: {
      type: 'string',
      description: 'Automatically assigned upon creation',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'User-defined display name for the object',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the object',
      readOnly: true,
    },
    updated_by_user_id: {
      type: 'string',
      description: 'Id of the last user who updated the object',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'Direct link to the specific custom object',
      readOnly: true,
    },
  },
  required: ['name'],
} as const;

export const CustomObjectRecordFilteredSearchConditionSchema = {
  type: 'object',
  properties: {
    field_key: {
      type: 'object',
      properties: {
        operator: {
          type: 'string',
        },
        value: {
          oneOf: [
            {
              type: 'string',
            },
            {
              type: 'integer',
            },
            {
              type: 'array',
              items: {
                oneOf: [
                  {
                    type: 'string',
                  },
                  {
                    type: 'integer',
                  },
                ],
              },
            },
          ],
        },
      },
      example: {
        operator: 'value',
      },
      nullable: true,
    },
  },
  additionalProperties: true,
} as const;

export const CustomObjectRecordResponseSchema = {
  type: 'object',
  properties: {
    custom_object_record: {
      $ref: '#/components/schemas/CustomObjectRecord',
    },
  },
} as const;

export const CustomObjectRecordsBulkCreateRequestSchema = {
  type: 'object',
  properties: {
    job: {
      type: 'object',
      properties: {
        action: {
          type: 'string',
        },
        items: {
          type: 'array',
          description:
            'An array of record objects for job actions that create, update, or set. An array of strings for job actions that delete.',
          items: {
            $ref: '#/components/schemas/CustomObjectRecord',
          },
        },
      },
    },
  },
} as const;

export const CustomObjectRecordsCreateRequestSchema = {
  type: 'object',
  properties: {
    custom_object_record: {
      $ref: '#/components/schemas/CustomObjectRecord',
    },
  },
} as const;

export const CustomObjectRecordsFilteredSearchRequestBasicSchema = {
  type: 'object',
  properties: {
    filter: {
      $ref: '#/components/schemas/CustomObjectRecordFilteredSearchCondition',
    },
  },
} as const;

export const CustomObjectRecordsFilteredSearchRequestComplexSchema = {
  type: 'object',
  properties: {
    filter: {
      type: 'object',
      properties: {
        $and: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/CustomObjectRecordFilteredSearchCondition',
          },
        },
        $or: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/CustomObjectRecordFilteredSearchCondition',
          },
        },
      },
    },
  },
} as const;

export const CustomObjectRecordsJobsResponseSchema = {
  type: 'object',
  properties: {
    job_status: {
      type: 'object',
      properties: {
        id: {
          type: 'string',
        },
        message: {
          type: 'string',
          nullable: true,
        },
        progress: {
          type: 'integer',
          nullable: true,
        },
        results: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/CustomObjectRecord',
          },
          nullable: true,
        },
        status: {
          type: 'string',
        },
        total: {
          type: 'integer',
        },
        url: {
          type: 'string',
        },
      },
    },
  },
} as const;

export const CustomObjectRecordsResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      description: 'The number of results returned for the current request',
      readOnly: true,
    },
    custom_object_records: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CustomObjectRecord',
      },
    },
    links: {
      type: 'object',
      properties: {
        next: {
          type: 'string',
          nullable: true,
        },
        prev: {
          type: 'string',
          nullable: true,
        },
      },
      required: ['prev', 'next'],
    },
    meta: {
      type: 'object',
      properties: {
        after_cursor: {
          type: 'string',
          nullable: true,
        },
        before_cursor: {
          type: 'string',
          nullable: true,
        },
        has_more: {
          type: 'boolean',
        },
      },
      required: ['has_more', 'after_cursor', 'before_cursor'],
    },
  },
} as const;

export const CustomObjectRecordsUpsertRequestSchema = {
  type: 'object',
  properties: {
    custom_object_record: {
      $ref: '#/components/schemas/CustomObjectRecord',
    },
  },
} as const;

export const CustomObjectResponseSchema = {
  type: 'object',
  properties: {
    custom_object: {
      $ref: '#/components/schemas/CustomObject',
    },
  },
} as const;

export const CustomObjectsCreateRequestSchema = {
  type: 'object',
  properties: {
    custom_object: {
      $ref: '#/components/schemas/CustomObjectCreateInput',
    },
  },
} as const;

export const CustomObjectsResponseSchema = {
  type: 'object',
  properties: {
    custom_objects: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CustomObject',
      },
    },
  },
} as const;

export const CustomRoleConfigurationObjectSchema = {
  type: 'object',
  description: 'Configuration settings for the role. See [Configuration](#configuration)',
  properties: {
    assign_tickets_to_any_group: {
      type: 'boolean',
      description: 'Whether or not the agent can assign tickets to any group',
      readOnly: true,
    },
    chat_access: {
      type: 'boolean',
      description: 'Whether or not the agent has access to Chat',
      readOnly: true,
    },
    end_user_list_access: {
      type: 'string',
      description: 'Whether or not the agent can view lists of user profiles. Allowed values: "full", "none"',
    },
    end_user_profile_access: {
      type: 'string',
      description:
        'What the agent can do with end-user profiles. Allowed values: "edit", "edit-within-org", "full", "readonly"',
    },
    explore_access: {
      type: 'string',
      description: 'Allowed values: "edit", "full", "none", "readonly"',
    },
    forum_access: {
      type: 'string',
      description: 'The kind of access the agent has to Guide. Allowed values: "edit-topics", "full", "readonly"',
    },
    forum_access_restricted_content: {
      type: 'boolean',
    },
    group_access: {
      type: 'boolean',
      description: 'Whether or not the agent can add or modify groups',
      readOnly: true,
    },
    light_agent: {
      type: 'boolean',
      readOnly: true,
    },
    macro_access: {
      type: 'string',
      description:
        'What the agent can do with macros. Allowed values: "full", "manage-group", "manage-personal", "readonly"',
    },
    manage_business_rules: {
      type: 'boolean',
      description: 'Whether or not the agent can manage business rules',
    },
    manage_contextual_workspaces: {
      type: 'boolean',
      description: 'Whether or not the agent can view, add, and edit contextual workspaces',
    },
    manage_dynamic_content: {
      type: 'boolean',
      description: 'Whether or not the agent can access dynamic content',
    },
    manage_extensions_and_channels: {
      type: 'boolean',
      description: 'Whether or not the agent can manage channels and extensions',
    },
    manage_facebook: {
      type: 'boolean',
      description: 'Whether or not the agent can manage Facebook pages',
    },
    manage_organization_fields: {
      type: 'boolean',
      description: 'Whether or not the agent can create and manage organization fields',
    },
    manage_ticket_fields: {
      type: 'boolean',
      description: 'Whether or not the agent can create and manage ticket fields',
    },
    manage_ticket_forms: {
      type: 'boolean',
      description: 'Whether or not the agent can create and manage ticket forms',
    },
    manage_user_fields: {
      type: 'boolean',
      description: 'Whether or not the agent can create and manage user fields',
    },
    moderate_forums: {
      type: 'boolean',
      readOnly: true,
    },
    organization_editing: {
      type: 'boolean',
      description: 'Whether or not the agent can add or modify organizations',
    },
    organization_notes_editing: {
      type: 'boolean',
      description: 'Whether or not the agent can add or modify organization notes',
      readOnly: true,
    },
    report_access: {
      type: 'string',
      description: 'What the agent can do with reports. Allowed values: "full", "none", "readonly"',
    },
    side_conversation_create: {
      type: 'boolean',
      description: 'Whether or not the agent can contribute to side conversations',
    },
    ticket_access: {
      type: 'string',
      description:
        'What kind of tickets the agent can access. Allowed values: "all", "assigned-only", "within-groups", "within-groups-and-public-groups", "within-organization"',
    },
    ticket_comment_access: {
      type: 'string',
      description: 'What type of comments the agent can make. Allowed values: "public", "none"',
    },
    ticket_deletion: {
      type: 'boolean',
      description: 'Whether or not the agent can delete tickets',
    },
    ticket_editing: {
      type: 'boolean',
      description: 'Whether or not the agent can edit ticket properties',
    },
    ticket_merge: {
      type: 'boolean',
      description: 'Whether or not the agent can merge tickets',
    },
    ticket_tag_editing: {
      type: 'boolean',
      description: 'Whether or not the agent can edit ticket tags',
    },
    twitter_search_access: {
      type: 'boolean',
    },
    user_view_access: {
      type: 'string',
      description:
        'What the agent can do with customer lists. Allowed values: "full", "manage-group", "manage-personal", "none", "readonly"',
    },
    view_access: {
      type: 'string',
      description:
        'What the agent can do with views. Allowed values: "full", "manage-group", "manage-personal", "playonly", "readonly"',
    },
    view_deleted_tickets: {
      type: 'boolean',
      description: 'Whether or not the agent can view deleted tickets',
    },
    voice_access: {
      type: 'boolean',
      description: 'Whether or not the agent can answer and place calls to end users',
    },
    voice_dashboard_access: {
      type: 'boolean',
      description: 'Whether or not the agent can view details about calls on the Talk dashboard',
    },
  },
} as const;

export const CustomRoleObjectSchema = {
  title: 'Custom Agent Roles',
  type: 'object',
  properties: {
    configuration: {
      $ref: '#/components/schemas/CustomRoleConfigurationObject',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the record was created',
      readOnly: true,
    },
    description: {
      type: 'string',
      description: 'A description of the role',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned on creation',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'Name of the custom role',
    },
    role_type: {
      type: 'integer',
      description:
        "The user's role. 0 stands for a custom agent, 1 for a light agent, 2 for a chat agent, 3 for a contributor, 4 for an admin and 5 for a billing admin. See [Understanding standard agent roles in Zendesk Support](https://support.zendesk.com/hc/en-us/articles/4409155971354-Understanding-standard-agent-roles-in-Zendesk-Support) in Zendesk help",
      readOnly: true,
    },
    team_member_count: {
      type: 'integer',
      description: 'The number of team members assigned to this role',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the record was last updated',
      readOnly: true,
    },
  },
  required: ['name', 'role_type'],
} as const;

export const CustomRoleResponseSchema = {
  type: 'object',
  properties: {
    custom_role: {
      $ref: '#/components/schemas/CustomRoleObject',
    },
  },
} as const;

export const CustomRolesResponseSchema = {
  type: 'object',
  properties: {
    custom_roles: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CustomRoleObject',
      },
    },
  },
} as const;

export const CustomStatusCreateInputSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/CustomStatusUpdateInput',
    },
    {
      type: 'object',
      properties: {
        status_category: {
          type: 'string',
          description: 'The status category the custom ticket status belongs to',
          enum: ['new', 'open', 'pending', 'hold', 'solved'],
        },
      },
    },
  ],
} as const;

export const CustomStatusCreateRequestSchema = {
  type: 'object',
  properties: {
    custom_status: {
      $ref: '#/components/schemas/CustomStatusCreateInput',
    },
  },
} as const;

export const CustomStatusObjectSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'If true, the custom status is set to active, If false, the custom status is set to inactive',
    },
    agent_label: {
      type: 'string',
      description: 'The label displayed to agents. Maximum length is 48 characters',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The date and time the custom ticket status was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: 'If true, the custom status is set to default. If false, the custom status is set to non-default',
    },
    description: {
      type: 'string',
      description: 'The description of when the user should select this custom ticket status',
    },
    end_user_description: {
      type: 'string',
      description: 'The description displayed to end users',
    },
    end_user_label: {
      type: 'string',
      description: 'The label displayed to end users. Maximum length is 48 characters',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when the custom ticket status is created',
      readOnly: true,
    },
    raw_agent_label: {
      type: 'string',
      description:
        'The dynamic content placeholder. If the dynamic content placeholder is not available, this is the "agent_label" value. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
      readOnly: true,
    },
    raw_description: {
      type: 'string',
      description:
        'The dynamic content placeholder. If the dynamic content placeholder is not available, this is the "description" value. [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
      readOnly: true,
    },
    raw_end_user_description: {
      type: 'string',
      description:
        'The dynamic content placeholder. If the dynamic content placeholder is not available, this is the "end_user_description" value. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
      readOnly: true,
    },
    raw_end_user_label: {
      type: 'string',
      description:
        'The dynamic content placeholder. If the dynamic content placeholder is not available, this is the "end_user_label" value. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
      readOnly: true,
    },
    status_category: {
      type: 'string',
      description: 'The status category the custom ticket status belongs to',
      enum: ['new', 'open', 'pending', 'hold', 'solved'],
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The date and time the custom ticket status was last updated',
      readOnly: true,
    },
  },
  required: ['status_category', 'agent_label'],
} as const;

export const CustomStatusResponseSchema = {
  type: 'object',
  properties: {
    custom_status: {
      $ref: '#/components/schemas/CustomStatusObject',
    },
  },
} as const;

export const CustomStatusUpdateInputSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'True if the custom status is set as active; inactive if false',
    },
    agent_label: {
      type: 'string',
      description:
        'The dynamic content placeholder, if present, or the "agent_label" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    description: {
      type: 'string',
      description:
        'The dynamic content placeholder, if present, or the "description" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    end_user_description: {
      type: 'string',
      description:
        'The dynamic content placeholder, if present, or the "end_user_description" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    end_user_label: {
      type: 'string',
      description:
        'The dynamic content placeholder, if present, or the "end_user_label" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
  },
} as const;

export const CustomStatusUpdateRequestSchema = {
  type: 'object',
  properties: {
    custom_status: {
      $ref: '#/components/schemas/CustomStatusUpdateInput',
    },
  },
} as const;

export const CustomStatusesResponseSchema = {
  type: 'object',
  properties: {
    custom_statuses: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CustomStatusObject',
      },
    },
  },
} as const;

export const DefinitionsResponseSchema = {
  type: 'object',
  properties: {
    definitions: {
      type: 'object',
      properties: {
        conditions_all: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              group: {
                type: 'string',
              },
              nullable: {
                type: 'boolean',
              },
              operators: {
                type: 'array',
                items: {
                  type: 'object',
                  properties: {
                    terminal: {
                      type: 'boolean',
                    },
                    title: {
                      type: 'string',
                    },
                    value: {
                      type: 'string',
                    },
                  },
                },
              },
              repeatable: {
                type: 'boolean',
              },
              subject: {
                type: 'string',
              },
              title: {
                type: 'string',
              },
              type: {
                type: 'string',
              },
              values: {
                type: 'array',
                items: {
                  type: 'object',
                  properties: {
                    enabled: {
                      type: 'boolean',
                    },
                    title: {
                      type: 'string',
                    },
                    value: {
                      type: 'string',
                    },
                  },
                },
              },
            },
          },
        },
        conditions_any: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              group: {
                type: 'string',
              },
              nullable: {
                type: 'boolean',
              },
              operators: {
                type: 'array',
                items: {
                  type: 'object',
                  properties: {
                    terminal: {
                      type: 'boolean',
                    },
                    title: {
                      type: 'string',
                    },
                    value: {
                      type: 'string',
                    },
                  },
                },
              },
              repeatable: {
                type: 'boolean',
              },
              subject: {
                type: 'string',
              },
              title: {
                type: 'string',
              },
              type: {
                type: 'string',
              },
              values: {
                type: 'array',
                items: {
                  type: 'object',
                  properties: {
                    enabled: {
                      type: 'boolean',
                    },
                    title: {
                      type: 'string',
                    },
                    value: {
                      type: 'string',
                    },
                  },
                },
              },
            },
          },
        },
      },
    },
  },
} as const;

export const DeletedUserObjectSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
    },
    created_at: {
      type: 'string',
    },
    email: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    locale: {
      type: 'string',
    },
    locale_id: {
      type: 'integer',
    },
    name: {
      type: 'string',
    },
    organization_id: {
      type: 'integer',
    },
    phone: {
      type: 'string',
      nullable: true,
    },
    photo: {
      type: 'object',
      nullable: true,
    },
    role: {
      type: 'string',
    },
    shared_phone_number: {
      type: 'string',
      nullable: true,
    },
    time_zone: {
      type: 'string',
    },
    updated_at: {
      type: 'string',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'id',
    'url',
    'name',
    'email',
    'created_at',
    'updated_at',
    'time_zone',
    'phone',
    'shared_phone_number',
    'photo',
    'locale_id',
    'locale',
    'organization_id',
    'role',
    'active',
  ],
} as const;

export const DeletedUserResponseSchema = {
  type: 'object',
  properties: {
    deleted_user: {
      $ref: '#/components/schemas/DeletedUserObject',
    },
  },
} as const;

export const DeletedUsersResponseSchema = {
  type: 'object',
  properties: {
    deleted_users: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/DeletedUserObject',
      },
    },
  },
} as const;

export const DeletionScheduleSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'Whether the deletion schedule is active',
    },
    conditions: {
      $ref: '#/components/schemas/ConditionsObject',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the deletion schedule was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: 'Whether the deletion schedule is the default',
      readOnly: true,
    },
    description: {
      type: 'string',
      description: 'The description of the deletion schedule',
    },
    id: {
      type: 'integer',
      description: 'The id of the deletion schedule',
      readOnly: true,
    },
    title: {
      type: 'string',
      description: 'The title of the deletion schedule',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the deletion schedule was last updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'Url for obtaining the deletion schedule JSON',
      readOnly: true,
    },
  },
} as const;

export const DynamicContentObjectSchema = {
  title: 'Dynamic Content Items',
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this record was created',
      readOnly: true,
    },
    default_locale_id: {
      type: 'integer',
      description:
        'The default locale for the item. Must be one of the [locales the account has active](/api-reference/ticketing/account-configuration/locales/#list-locales).',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when creating items',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'The unique name of the item',
    },
    outdated: {
      type: 'boolean',
      description: 'Indicates the item has outdated variants within it',
      readOnly: true,
    },
    placeholder: {
      type: 'string',
      description: 'Automatically generated placeholder for the item, derived from name',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this record was last updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this item',
      readOnly: true,
    },
    variants: {
      type: 'array',
      description:
        'All variants within this item. See [Dynamic Content Item Variants](/api-reference/ticketing/ticket-management/dynamic_content_item_variants/)',
      items: {
        $ref: '#/components/schemas/DynamicContentVariantObject',
      },
    },
  },
  required: ['name', 'default_locale_id', 'variants'],
} as const;

export const DynamicContentResponseSchema = {
  type: 'object',
  properties: {
    item: {
      $ref: '#/components/schemas/DynamicContentObject',
    },
  },
} as const;

export const DynamicContentVariantObjectSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'If the variant is active and useable',
    },
    content: {
      type: 'string',
      description: 'The content of the variant',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the variant was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: 'If the variant is the default for the item it belongs to',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when the variant is created',
      readOnly: true,
    },
    locale_id: {
      type: 'integer',
      description: 'An active locale',
    },
    outdated: {
      type: 'boolean',
      description: 'If the variant is outdated',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the variant was last updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of the variant',
      readOnly: true,
    },
  },
  example: {
    active: true,
    content: 'This is my dynamic content in English',
    created_at: '2014-04-09T19:53:23Z',
    default: true,
    id: 23,
    locale_id: 125,
    outdated: false,
    updated_at: '2014-04-09T19:53:23Z',
    url: 'https://subdomain.zendesk.com/api/v2/dynamic_content/items/3/variants/23.json',
  },
  required: ['content', 'locale_id'],
} as const;

export const DynamicContentVariantResponseSchema = {
  type: 'object',
  properties: {
    variant: {
      $ref: '#/components/schemas/DynamicContentVariantObject',
    },
  },
} as const;

export const DynamicContentVariantsResponseSchema = {
  type: 'object',
  properties: {
    variants: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/DynamicContentVariantObject',
      },
    },
  },
} as const;

export const DynamicContentsResponseSchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/DynamicContentObject',
      },
    },
  },
} as const;

export const EmailCCObjectSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/FollowerObject',
    },
    {
      type: 'object',
      properties: {
        action: {
          type: 'string',
          enum: ['put', 'delete'],
        },
        user_email: {
          type: 'string',
        },
        user_id: {
          type: 'string',
        },
        user_name: {
          type: 'string',
        },
      },
    },
  ],
} as const;

export const EmailNotificationObjectSchema = {
  type: 'object',
  properties: {
    comment_id: {
      type: 'integer',
      description: 'The comment ID associated to this email notification',
      readOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this email notification was created',
      readOnly: true,
    },
    email_id: {
      type: 'string',
      description: 'The email ID of this email notification',
      readOnly: true,
    },
    message_id: {
      type: 'string',
      description: 'The value of the Message-Id header of the email',
      readOnly: true,
    },
    notification_id: {
      type: 'integer',
      description: 'The notification id of this email notification',
      readOnly: true,
    },
    recipients: {
      type: 'array',
      description: 'The list of recipients associated to this email notification',
      items: {
        $ref: '#/components/schemas/RecipientObject',
      },
      readOnly: true,
    },
    ticket_id: {
      type: 'integer',
      description: 'The ticket ID associated to this email notification',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this email notification was last updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this email notification',
      readOnly: true,
    },
  },
  example: {
    comment_id: 7824075373565,
    created_at: '2024-02-21T23:13:07Z',
    email_id: '01HQ6Z3DE28F34XBFCYH0SRM95',
    message_id: '<56Z97D7G67G_65d68382aa493_4639581606f3@example.com>',
    notification_id: 7824075373693,
    recipients: [
      {
        delivery_status: {
          code: '530 5.7.0',
          id: 24,
          message: 'Email failed to deliver. 530 5.7.0',
          name: 'authentication_required',
        },
        email_address: 'recipient@example.com',
        user_id: 7612709251581,
      },
    ],
    ticket_id: 623,
    updated_at: '2024-02-21T23:13:07Z',
    url: 'https://example.zendesk.com/api/v2/email_notifications/7824075373693.json',
  },
} as const;

export const EmailNotificationResponseSchema = {
  type: 'object',
  properties: {
    email_notification: {
      $ref: '#/components/schemas/EmailNotificationObject',
    },
  },
} as const;

export const EmailNotificationsResponseSchema = {
  type: 'object',
  properties: {
    email_notifications: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/EmailNotificationObject',
      },
    },
  },
} as const;

export const ErrorSchema = {
  type: 'object',
  properties: {
    code: {
      type: 'string',
    },
    detail: {
      type: 'string',
    },
    id: {
      type: 'string',
    },
    links: {
      type: 'object',
    },
    source: {
      type: 'object',
    },
    status: {
      type: 'string',
    },
    title: {
      type: 'string',
    },
  },
  required: ['code', 'title'],
} as const;

export const ErrorsSchema = {
  type: 'object',
  properties: {
    errors: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Error',
      },
    },
  },
} as const;

export const EssentialsCardObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'Date and time the essentials card were created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description:
        'If true, the system has used the first twenty fields for the custom object type as the essentials card.',
      readOnly: true,
    },
    fields: {
      type: 'array',
      description:
        'Fields that are displayed in the essentials card details. The order is defined by the order of the fields in the array',
      items: {
        type: 'object',
        additionalProperties: true,
      },
    },
    id: {
      type: 'string',
      description: `id of the essentials card
`,
      nullable: true,
      readOnly: true,
    },
    key: {
      type: 'string',
      description: `Object type. Example: \`zen:user\` refers to \`User\` type
`,
      readOnly: true,
    },
    layout: {
      type: 'string',
      description: `layout type
`,
      readOnly: true,
    },
    max_count: {
      type: 'integer',
      description: 'Maximum number of fields allowed in the essentials card',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'Date and time the essentials card were last updated',
      readOnly: true,
    },
  },
  example: {
    created_at: '2012-04-02T22:55:29Z',
    default: true,
    fields: [
      {
        id: null,
        zrn: 'zen:user:identity:email',
      },
      {
        id: null,
        zrn: 'zen:user:field:standard:external_id',
      },
      {
        id: null,
        zrn: 'zen:user:field:standard:iana_time_zone',
      },
      {
        id: null,
        zrn: 'zen:user:field:standard:locale',
      },
      {
        id: null,
        zrn: 'zen:user:field:standard:organization_id',
      },
    ],
    id: '123',
    key: 'zen:custom_object:boat',
    layout: 'essentials_card',
    max_count: 20,
    updated_at: '2012-04-02T22:55:29Z',
  },
  required: ['fields'],
} as const;

export const EssentialsCardResponseSchema = {
  type: 'object',
  properties: {
    object_layout: {
      $ref: '#/components/schemas/EssentialsCardObject',
    },
  },
} as const;

export const EssentialsCardsResponseSchema = {
  type: 'object',
  properties: {
    object_layouts: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/EssentialsCardObject',
      },
    },
  },
} as const;

export const ExportIncrementalOrganizationsResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
    },
    end_of_stream: {
      type: 'boolean',
    },
    end_time: {
      type: 'integer',
    },
    next_page: {
      type: 'string',
      nullable: true,
    },
    organizations: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/OrganizationObject',
      },
    },
  },
  example: {
    count: 1,
    end_of_stream: true,
    end_time: 1601357503,
    next_page: 'https://example.zendesk.com/api/v2/incremental/ticket_events.json?start_time=1601357503',
    organizations: [
      {
        created_at: '2018-11-14T00:14:52Z',
        details: 'caterpillar =)',
        domain_names: ['remain.com'],
        external_id: 'ABC198',
        group_id: 1835962,
        id: 4112492,
        name: 'Groablet Enterprises',
        notes: 'donkey',
        organization_fields: {
          datepudding: '2018-11-04T00:00:00+00:00',
          org_field_1: 'happy happy',
          org_field_2: 'teapot_kettle',
        },
        shared_comments: false,
        shared_tickets: false,
        tags: ['smiley', 'teapot_kettle'],
        updated_at: '2018-11-14T00:54:22Z',
        url: 'https://example.zendesk.com/api/v2/organizations/4112492.json',
      },
    ],
  },
} as const;

export const ExportIncrementalTicketEventsResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
    },
    end_of_stream: {
      type: 'boolean',
    },
    end_time: {
      type: 'integer',
    },
    next_page: {
      type: 'string',
      nullable: true,
    },
    ticket_events: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketMetricEventBaseObject',
      },
    },
  },
  example: {
    count: 1,
    end_of_stream: true,
    end_time: 1601357503,
    next_page: 'https://example.zendesk.com/api/v2/incremental/ticket_events.json?start_time=1601357503',
    ticket_events: [
      {
        id: 926256957613,
        instance_id: 1,
        metric: 'agent_work_time',
        ticket_id: 155,
        time: '2020-10-26T12:53:12Z',
        type: 'measure',
      },
    ],
  },
} as const;

export const FollowerObjectSchema = {
  type: 'object',
  properties: {
    action: {
      type: 'string',
      enum: ['put', 'delete'],
    },
    user_email: {
      type: 'string',
      format: 'email',
    },
    user_id: {
      type: 'string',
    },
  },
} as const;

export const GroupMembershipObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the group was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: "If true, tickets assigned directly to the agent will assume this membership's group",
    },
    group_id: {
      type: 'integer',
      description: 'The id of a group',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned upon creation',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the group',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this record',
      readOnly: true,
    },
    user_id: {
      type: 'integer',
      description: 'The id of an agent',
    },
  },
  required: ['user_id', 'group_id'],
} as const;

export const GroupMembershipResponseSchema = {
  type: 'object',
  properties: {
    group_membership: {
      $ref: '#/components/schemas/GroupMembershipObject',
    },
  },
} as const;

export const GroupMembershipsResponseSchema = {
  type: 'object',
  properties: {
    group_memberships: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GroupMembershipObject',
      },
    },
  },
} as const;

export const GroupObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the group was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: 'If the group is the default one for the account',
      readOnly: true,
    },
    deleted: {
      type: 'boolean',
      description: 'Deleted groups get marked as such',
      readOnly: true,
    },
    description: {
      type: 'string',
      description: 'The description of the group',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when creating groups',
      readOnly: true,
    },
    is_public: {
      type: 'boolean',
      description: `If true, the group is public.
If false, the group is private.
You can't change a private group to a public group
`,
    },
    name: {
      type: 'string',
      description: 'The name of the group',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the group',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of the group',
      readOnly: true,
    },
  },
  example: {
    created_at: '2009-07-20T22:55:29Z',
    default: true,
    deleted: false,
    description: 'Some clever description here',
    id: 3432,
    is_public: true,
    name: 'First Level Support',
    updated_at: '2011-05-05T10:38:52Z',
    url: 'https://company.zendesk.com/api/v2/groups/3432.json',
  },
  required: ['name'],
} as const;

export const GroupResponseSchema = {
  type: 'object',
  properties: {
    group: {
      $ref: '#/components/schemas/GroupObject',
    },
  },
} as const;

export const GroupSLAPoliciesResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      readOnly: true,
    },
    group_sla_policies: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GroupSLAPolicyObject',
      },
    },
    next_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
  },
} as const;

export const GroupSLAPolicyFilterConditionObjectSchema = {
  type: 'object',
  properties: {
    field: {
      type: 'string',
      description: 'The name of a ticket field',
    },
    operator: {
      type: 'string',
      description: 'A comparison operator',
    },
    value: {
      type: 'array',
      description: 'The value of a ticket field',
      items: {
        oneOf: [
          {
            type: 'string',
          },
          {
            type: 'integer',
          },
        ],
      },
    },
  },
} as const;

export const GroupSLAPolicyFilterDefinitionResponseSchema = {
  type: 'object',
  properties: {
    definitions: {
      type: 'object',
      properties: {
        all: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              group: {
                type: 'string',
              },
              operators: {
                type: 'array',
                items: {
                  type: 'object',
                  properties: {
                    title: {
                      type: 'string',
                    },
                    value: {
                      type: 'string',
                    },
                  },
                },
              },
              title: {
                type: 'string',
              },
              value: {
                type: 'string',
              },
              values: {
                type: 'object',
                properties: {
                  list: {
                    type: 'array',
                    items: {
                      type: 'object',
                      properties: {
                        title: {
                          type: 'string',
                        },
                        value: {
                          type: 'integer',
                          nullable: true,
                        },
                      },
                    },
                  },
                  type: {
                    type: 'string',
                  },
                },
              },
            },
          },
        },
      },
    },
  },
} as const;

export const GroupSLAPolicyFilterObjectSchema = {
  type: 'object',
  description:
    'An object that describes the conditions a ticket must match for a Group SLA policy to be applied to the ticket. See [Filter](#filter).',
  properties: {
    all: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GroupSLAPolicyFilterConditionObject',
      },
    },
  },
} as const;

export const GroupSLAPolicyMetricObjectSchema = {
  type: 'object',
  properties: {
    business_hours: {
      type: 'boolean',
      description: 'Whether the metric targets are being measured in business hours or calendar hours',
    },
    metric: {
      type: 'string',
      description: 'The definition of the time that is being measured',
    },
    priority: {
      type: 'string',
      description: 'Priority that a ticket must match',
    },
    target: {
      type: 'integer',
      description: 'The time within which the end-state for a metric should be met',
    },
  },
} as const;

export const GroupSLAPolicyObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the Group SLA policy was created',
      readOnly: true,
    },
    description: {
      type: 'string',
      description: 'The description of the Group SLA policy',
    },
    filter: {
      $ref: '#/components/schemas/GroupSLAPolicyFilterObject',
    },
    id: {
      type: 'string',
      description: 'Automatically assigned when created',
      readOnly: true,
    },
    policy_metrics: {
      type: 'array',
      description: 'Array of [policy metric](#policy-metric) objects',
      items: {
        $ref: '#/components/schemas/GroupSLAPolicyMetricObject',
      },
    },
    position: {
      type: 'integer',
      description:
        'Position of the Group SLA policy. This position determines the order in which policies are matched to tickets. If not specified, the Group SLA policy is added at the last position',
    },
    title: {
      type: 'string',
      description: 'The title of the Group SLA policy',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the Group SLA policy',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'URL of the Group SLA policy record',
      readOnly: true,
    },
  },
  example: {
    created_at: '2023-03-17T22:50:26Z',
    description: 'Group: Tier 1',
    filter: {
      all: [],
    },
    id: '01H078CBDY28BZG7P6BONY09DN',
    policy_metrics: [
      {
        business_hours: false,
        metric: 'group_ownership_time',
        priority: 'low',
        target: 3600,
      },
    ],
    position: 3,
    title: 'Tier 1',
    updated_at: '2023-03-17T22:50:26Z',
    url: 'https://company.zendesk.com/api/v2/group_slas/policies/01H078CBDY28BZG7P6BONY09DN.json',
  },
  required: ['title', 'filter'],
} as const;

export const GroupSLAPolicyResponseSchema = {
  type: 'object',
  properties: {
    group_sla_policy: {
      $ref: '#/components/schemas/GroupSLAPolicyObject',
    },
  },
} as const;

export const GroupsCountObjectSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'object',
      properties: {
        refreshed_at: {
          type: 'string',
          format: 'date-time',
          description: 'Timestamp that indicates when the count was last updated',
          readOnly: true,
        },
        value: {
          type: 'integer',
          description: 'Approximate count of groups',
          readOnly: true,
        },
      },
    },
  },
} as const;

export const GroupsResponseSchema = {
  type: 'object',
  properties: {
    groups: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GroupObject',
      },
    },
  },
} as const;

export const HostMappingObjectSchema = {
  title: 'Host Mapping',
  type: 'object',
  properties: {
    cname: {
      type: 'string',
      description: 'The canonical name record for a host mapping',
    },
    expected_cnames: {
      type: 'array',
      description: 'Array of expected CNAME records for host mapping(s) of a given brand',
      items: {
        type: 'string',
      },
    },
    is_valid: {
      type: 'boolean',
      description: 'Whether a host mapping is valid or not for a given brand',
    },
    reason: {
      type: 'string',
      description: 'Reason why a host mapping is valid or not',
    },
  },
  example: {
    cname: 'google.com',
    expected_cnames: ['bar.zendesk.coom'],
    is_valid: false,
    reason: 'wrong_cname',
  },
} as const;

export const IncrementalSkillBasedRoutingSchema = {
  title: 'Incremental Skill-based Routing',
  type: 'object',
  properties: {
    attribute_values: {
      type: 'array',
      description: 'Routing attribute values',
      items: {
        $ref: '#/components/schemas/IncrementalSkillBasedRoutingAttributeValue',
      },
    },
    attributes: {
      type: 'array',
      description: 'Routing attributes',
      items: {
        $ref: '#/components/schemas/IncrementalSkillBasedRoutingAttribute',
      },
    },
    count: {
      type: 'integer',
      description: 'The number of results returned for the current request',
      readOnly: true,
    },
    end_time: {
      type: 'integer',
      description: 'The most recent resource creation time present in this result set in Unix epoch time',
      readOnly: true,
    },
    instance_values: {
      type: 'array',
      description: 'Routing instance values',
      items: {
        $ref: '#/components/schemas/IncrementalSkillBasedRoutingInstanceValue',
      },
    },
    next_page: {
      type: 'string',
      description: 'The URL that should be called to get the next set of results',
      readOnly: true,
    },
  },
} as const;

export const IncrementalSkillBasedRoutingAttributeSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'Automatically assigned when an attribute is created',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'The name of the attribute',
      readOnly: true,
    },
    time: {
      type: 'string',
      format: 'date-time',
      description: 'The time the attribute was created, updated, or deleted',
      readOnly: true,
    },
    type: {
      type: 'string',
      description: 'One of "create", "update", or "delete"',
      readOnly: true,
    },
  },
} as const;

export const IncrementalSkillBasedRoutingAttributeValueSchema = {
  type: 'object',
  properties: {
    attribute_id: {
      type: 'string',
      description: 'Id of the associated attribute',
      readOnly: true,
    },
    id: {
      type: 'string',
      description: 'Automatically assigned when an attribute value is created',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'The name of the attribute value',
      readOnly: true,
    },
    time: {
      type: 'string',
      format: 'date-time',
      description: 'The time the attribute value was created, updated, or deleted',
      readOnly: true,
    },
    type: {
      type: 'string',
      description: 'One of "create", "update", or "delete"',
      readOnly: true,
    },
  },
} as const;

export const IncrementalSkillBasedRoutingInstanceValueSchema = {
  type: 'object',
  properties: {
    attribute_value_id: {
      type: 'string',
      description: 'Id of the associated attribute value',
      readOnly: true,
    },
    id: {
      type: 'string',
      description: 'Automatically assigned when an instance value is created',
      readOnly: true,
    },
    instance_id: {
      type: 'string',
      description: 'Id of the associated agent or ticket',
      readOnly: true,
    },
    time: {
      type: 'string',
      format: 'date-time',
      description: 'The time the instance value was created or deleted',
      readOnly: true,
    },
    type: {
      type: 'string',
      description: 'One of "associate_agent", "unassociate_agent", "associate_ticket", or "unassociate_ticket"',
      readOnly: true,
    },
  },
} as const;

export const JobStatusObjectSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'Automatically assigned when the job is queued',
      readOnly: true,
    },
    job_type: {
      type: 'string',
      description: 'The type of the job',
      readOnly: true,
    },
    message: {
      type: 'string',
      description: 'Message from the job worker, if any',
      nullable: true,
      readOnly: true,
    },
    progress: {
      type: 'integer',
      description: 'Number of tasks that have already been completed',
      nullable: true,
      readOnly: true,
    },
    results: {
      description: 'Result data from processed tasks. See [Results](#results) below',
      oneOf: [
        {
          type: 'array',
          items: {
            $ref: '#/components/schemas/JobStatusResultObject',
          },
          nullable: true,
        },
        {
          type: 'object',
          properties: {
            success: {
              type: 'boolean',
              description: 'Whether the action was successful or not',
              readOnly: true,
            },
          },
          required: ['success'],
        },
      ],
      readOnly: true,
    },
    status: {
      type: 'string',
      description: 'The current status. One of the following: "queued", "working", "failed", "completed"',
      readOnly: true,
    },
    total: {
      type: 'integer',
      description: 'The total number of tasks this job is batching through',
      nullable: true,
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The URL to poll for status updates',
      readOnly: true,
    },
  },
  example: {
    id: '82de0b044094f0c67893ac9fe64f1a99',
    message: 'Completed at 2018-03-08 10:07:04 +0000',
    progress: 2,
    results: [
      {
        action: 'update',
        id: 244,
        status: 'Updated',
        success: true,
      },
      {
        action: 'update',
        id: 245,
        status: 'Updated',
        success: true,
      },
    ],
    status: 'completed',
    total: 2,
    url: 'https://example.zendesk.com/api/v2/job_statuses/82de0b0467893ac9fe64f1a99.json',
  },
} as const;

export const JobStatusResponseSchema = {
  type: 'object',
  properties: {
    job_status: {
      $ref: '#/components/schemas/JobStatusObject',
    },
  },
} as const;

export const JobStatusResultObjectSchema = {
  oneOf: [
    {
      $ref: '#/components/schemas/CreateResourceResult',
    },
    {
      $ref: '#/components/schemas/UpdateResourceResult',
    },
  ],
  additionalProperties: true,
} as const;

export const JobStatusesResponseSchema = {
  type: 'object',
  properties: {
    job_statuses: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/JobStatusObject',
      },
    },
  },
  required: ['job_statuses'],
} as const;

export const ListDeletedTicketsResponseSchema = {
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        deleted_tickets: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              actor: {
                type: 'object',
                properties: {
                  id: {
                    type: 'integer',
                  },
                  name: {
                    type: 'string',
                  },
                },
              },
              deleted_at: {
                type: 'string',
              },
              id: {
                type: 'integer',
              },
              previous_state: {
                type: 'string',
              },
              subject: {
                type: 'string',
              },
            },
          },
        },
      },
    },
    {
      $ref: '#/components/schemas/OffsetPaginationObject',
    },
  ],
} as const;

export const ListTicketCollaboratorsResponseSchema = {
  type: 'object',
  additionalProperties: true,
} as const;

export const ListTicketEmailCCsResponseSchema = {
  type: 'object',
  additionalProperties: true,
} as const;

export const ListTicketFollowersResponseSchema = {
  type: 'object',
  additionalProperties: true,
} as const;

export const ListTicketIncidentsResponseSchema = {
  type: 'object',
  additionalProperties: true,
} as const;

export const ListTicketProblemsResponseSchema = {
  type: 'object',
  additionalProperties: true,
} as const;

export const LocaleObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The ISO 8601 formatted date-time the locale was created',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'The unique ID of the locale',
      readOnly: true,
    },
    locale: {
      type: 'string',
      description: 'The name of the locale',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'The name of the language',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The ISO 8601 formatted date-time when the locale was last updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The URL of the locale record',
      readOnly: true,
    },
  },
  example: {
    created_at: '2009-07-20T22:55:29Z',
    id: 1,
    locale: 'en-US',
    name: 'English',
    updated_at: '2011-05-05T10:38:52Z',
    url: 'https://company.zendesk.com/api/v2/locales/en-US.json',
  },
} as const;

export const LocaleResponseSchema = {
  type: 'object',
  properties: {
    locale: {
      $ref: '#/components/schemas/LocaleObject',
    },
  },
} as const;

export const LocalesResponseSchema = {
  type: 'object',
  properties: {
    locales: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/LocaleObject',
      },
    },
  },
} as const;

export const MacroApplyTicketResponseSchema = {
  type: 'object',
  properties: {
    result: {
      type: 'object',
      properties: {
        ticket: {
          type: 'object',
          properties: {
            assignee_id: {
              type: 'integer',
            },
            comment: {
              type: 'object',
              properties: {
                body: {
                  type: 'string',
                },
                public: {
                  type: 'boolean',
                },
                scoped_body: {
                  type: 'array',
                  items: {
                    type: 'array',
                    items: {
                      type: 'string',
                    },
                  },
                },
              },
            },
            fields: {
              type: 'object',
              properties: {
                id: {
                  type: 'integer',
                },
                value: {
                  type: 'string',
                },
              },
            },
            group_id: {
              type: 'integer',
            },
            id: {
              type: 'integer',
            },
            url: {
              type: 'string',
            },
          },
        },
      },
    },
  },
} as const;

export const MacroAttachmentObjectSchema = {
  type: 'object',
  properties: {
    content_type: {
      type: 'string',
      description: 'The content type of the image. Example value: "image/png"',
      readOnly: true,
    },
    content_url: {
      type: 'string',
      description: 'A full URL where the attachment image file can be downloaded',
      readOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time when this attachment was created',
    },
    filename: {
      type: 'string',
      description: 'The name of the image file',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when created',
      readOnly: true,
    },
    size: {
      type: 'integer',
      description: 'The size of the image file in bytes',
      readOnly: true,
    },
  },
} as const;

export const MacroAttachmentResponseSchema = {
  type: 'object',
  properties: {
    macro_attachment: {
      $ref: '#/components/schemas/MacroAttachmentObject',
    },
  },
} as const;

export const MacroAttachmentsResponseSchema = {
  type: 'object',
  properties: {
    macro_attachments: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/MacroAttachmentObject',
      },
    },
  },
} as const;

export const MacroCategoriesResponseSchema = {
  type: 'object',
  properties: {
    categories: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
  },
} as const;

export const MacroCommonObjectSchema = {
  type: 'object',
  properties: {
    actions: {
      type: 'array',
      description:
        'Each action describes what the macro will do. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)',
      items: {
        $ref: '#/components/schemas/ActionObject',
      },
    },
    active: {
      type: 'boolean',
      description: 'Useful for determining if the macro should be displayed',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the macro was created',
    },
    default: {
      type: 'boolean',
      description: 'If true, the macro is a default macro',
      readOnly: true,
    },
    description: {
      type: 'string',
      description: 'The description of the macro',
      nullable: true,
    },
    id: {
      type: 'integer',
      description: 'The ID automatically assigned when a macro is created',
    },
    position: {
      type: 'integer',
      description: 'The position of the macro',
    },
    restriction: {
      type: 'object',
      description: 'Access to this macro. A null value allows unrestricted access for all users in the account',
      additionalProperties: true,
      nullable: true,
    },
    title: {
      type: 'string',
      description: 'The title of the macro',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the macro',
    },
    url: {
      type: 'string',
      description: "A URL to access the macro's details",
    },
  },
  example: {
    actions: [
      {
        field: 'status',
        value: 'solved',
      },
      {
        field: 'priority',
        value: 'normal',
      },
      {
        field: 'type',
        value: 'incident',
      },
      {
        field: 'assignee_id',
        value: 'current_user',
      },
      {
        field: 'group_id',
        value: 'current_groups',
      },
      {
        field: 'comment_value',
        value:
          'Thanks for your request. This issue you reported is a known issue. For more information, please visit our forums. ',
      },
    ],
    active: true,
    created_at: '2019-09-16T02:17:38Z',
    default: false,
    description: null,
    id: 360111062754,
    position: 9999,
    restriction: null,
    title: 'Close and redirect to topics',
    updated_at: '2019-09-16T02:17:38Z',
    url: 'https://subdomain.zendesk.com/api/v2/macros/360111062754.json',
  },
  required: ['actions', 'title'],
} as const;

export const MacroInputSchema = {
  type: 'object',
  properties: {
    actions: {
      type: 'array',
      description: 'Each action describes what the macro will do',
      items: {
        $ref: '#/components/schemas/ActionObject',
      },
    },
    active: {
      type: 'boolean',
      description: 'Useful for determining if the macro should be displayed',
    },
    description: {
      type: 'string',
      description: 'The description of the macro',
      nullable: true,
    },
    restriction: {
      type: 'object',
      description: 'Who may access this macro. Will be null when everyone in the account can access it',
      properties: {
        id: {
          type: 'integer',
          description: 'The numeric ID of the group or user',
        },
        ids: {
          type: 'array',
          description: 'The numeric IDs of the groups',
          items: {
            type: 'integer',
          },
        },
        type: {
          type: 'string',
          description: 'Allowed values are Group or User',
        },
      },
      additionalProperties: true,
    },
    title: {
      type: 'string',
      description: 'The title of the macro',
    },
  },
  required: ['title', 'actions'],
} as const;

export const MacroObjectSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/MacroCommonObject',
    },
    {
      type: 'object',
      properties: {
        app_installation: {
          type: 'string',
          description: 'The app installation that requires each macro, if present',
          nullable: true,
        },
        categories: {
          type: 'string',
          description: 'The macro categories',
          nullable: true,
        },
        permissions: {
          type: 'string',
          description: 'Permissions for each macro',
          nullable: true,
        },
        usage_1h: {
          type: 'integer',
          description: 'The number of times each macro has been used in the past hour',
        },
        usage_7d: {
          type: 'integer',
          description: 'The number of times each macro has been used in the past week',
        },
        usage_24h: {
          type: 'integer',
          description: 'The number of times each macro has been used in the past day',
        },
        usage_30d: {
          type: 'integer',
          description: 'The number of times each macro has been used in the past thirty days',
        },
      },
    },
  ],
  example: {
    actions: [],
    active: true,
    description: 'Sets the ticket status to `solved`',
    id: 25,
    position: 42,
    restriction: {
      id: 4,
      type: 'User',
    },
    title: 'Close and Save',
  },
} as const;

export const MacroResponseSchema = {
  type: 'object',
  properties: {
    macro: {
      $ref: '#/components/schemas/MacroObject',
    },
  },
} as const;

export const MacroUpdateManyInputSchema = {
  type: 'object',
  properties: {
    macros: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          active: {
            type: 'boolean',
            description: 'The active status of the macro (true or false)',
          },
          id: {
            type: 'integer',
            description: 'The ID of the macro to update',
          },
          position: {
            type: 'integer',
            description: 'The new position of the macro',
          },
        },
        required: ['id'],
      },
    },
  },
} as const;

export const MacrosResponseSchema = {
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        macros: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/MacroObject',
          },
        },
      },
    },
    {
      $ref: '#/components/schemas/OffsetPaginationObject',
    },
  ],
} as const;

export const ObjectTriggerActionDefinitionObjectSchema = {
  type: 'object',
  properties: {
    group: {
      type: 'string',
    },
    nullable: {
      type: 'boolean',
    },
    repeatable: {
      type: 'boolean',
    },
    subject: {
      type: 'string',
    },
    title: {
      type: 'string',
    },
    type: {
      type: 'string',
    },
    values: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          enabled: {
            type: 'boolean',
          },
          format: {
            type: 'string',
          },
          title: {
            type: 'string',
          },
          value: {
            type: 'string',
          },
        },
      },
    },
  },
} as const;

export const ObjectTriggerBulkUpdateItemSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'Whether an object trigger is active',
    },
    id: {
      type: 'integer',
      description: 'The id of the object trigger to update',
    },
    position: {
      type: 'integer',
      description: 'The new position of the object trigger',
    },
  },
  example: {
    active: true,
    id: 25,
    position: 8,
  },
  required: ['id'],
} as const;

export const ObjectTriggerBulkUpdateRequestSchema = {
  type: 'object',
  properties: {
    triggers: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ObjectTriggerBulkUpdateItem',
      },
    },
  },
} as const;

export const ObjectTriggerConditionDefinitionObjectAllSchema = {
  type: 'object',
  properties: {
    group: {
      type: 'string',
    },
    nullable: {
      type: 'boolean',
    },
    operators: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          format: {
            type: 'string',
          },
          terminal: {
            type: 'boolean',
          },
          title: {
            type: 'string',
          },
          value: {
            type: 'string',
          },
        },
      },
    },
    repeatable: {
      type: 'boolean',
    },
    subject: {
      type: 'string',
    },
    title: {
      type: 'string',
    },
    type: {
      type: 'string',
    },
    values: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          enabled: {
            type: 'boolean',
          },
          title: {
            type: 'string',
          },
          value: {
            type: 'string',
          },
        },
      },
    },
  },
} as const;

export const ObjectTriggerConditionDefinitionObjectAnySchema = {
  type: 'object',
  properties: {
    group: {
      type: 'string',
    },
    nullable: {
      type: 'boolean',
    },
    operators: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          format: {
            type: 'string',
          },
          terminal: {
            type: 'boolean',
          },
          title: {
            type: 'string',
          },
          value: {
            type: 'string',
          },
        },
      },
    },
    repeatable: {
      type: 'boolean',
    },
    subject: {
      type: 'string',
    },
    title: {
      type: 'string',
    },
    type: {
      type: 'string',
    },
    values: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          enabled: {
            type: 'boolean',
          },
          title: {
            type: 'string',
          },
          value: {
            type: 'string',
          },
        },
      },
    },
  },
} as const;

export const ObjectTriggerDefinitionObjectSchema = {
  type: 'object',
  properties: {
    actions: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ObjectTriggerActionDefinitionObject',
      },
    },
    conditions_all: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ObjectTriggerConditionDefinitionObjectAll',
      },
    },
    conditions_any: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ObjectTriggerConditionDefinitionObjectAny',
      },
    },
  },
} as const;

export const ObjectTriggerDefinitionResponseSchema = {
  type: 'object',
  properties: {
    definitions: {
      $ref: '#/components/schemas/ObjectTriggerDefinitionObject',
    },
  },
} as const;

export const ObjectTriggerObjectSchema = {
  type: 'object',
  properties: {
    actions: {
      type: 'array',
      description:
        'An array of actions the trigger does when its conditions are met. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)',
      items: {
        $ref: '#/components/schemas/TriggerActionObject',
      },
    },
    active: {
      type: 'boolean',
      description: 'Whether the trigger is active',
    },
    conditions: {
      $ref: '#/components/schemas/TriggerConditionsObject',
    },
    created_at: {
      type: 'string',
      description: 'The time the trigger was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: 'Always false for object triggers',
      readOnly: true,
    },
    description: {
      type: 'string',
      description: 'The description of the trigger',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when created',
      readOnly: true,
    },
    position: {
      type: 'integer',
      description: 'Position of the trigger, determines the order they will execute in',
    },
    raw_title: {
      type: 'string',
      description: 'The raw format of the title of the trigger',
    },
    title: {
      type: 'string',
      description: 'The title of the trigger',
    },
    updated_at: {
      type: 'string',
      description: 'The time of the last update of the trigger',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The url of the trigger',
      readOnly: true,
    },
  },
  example: {
    actions: [{}],
    active: true,
    conditions: {},
    created_at: '2024-07-08T20:44:32Z',
    default: false,
    description: 'Sets mile count when heat not present on order custom object',
    id: 25,
    position: 8,
    raw_title: 'CO trigger with tagger field condition',
    title: 'CO trigger with tagger field condition',
    updated_at: '2024-07-08T20:44:32Z',
    url: 'http://{subdomain}.zendesk.com/api/v2/custom_objects/order/triggers/25.json',
  },
  required: ['conditions', 'actions', 'title'],
} as const;

export const ObjectTriggerRequestSchema = {
  type: 'object',
  properties: {
    trigger: {
      allOf: [
        {
          $ref: '#/components/schemas/ObjectTriggerObject',
        },
      ],
    },
  },
} as const;

export const ObjectTriggerResponseSchema = {
  type: 'object',
  properties: {
    trigger: {
      $ref: '#/components/schemas/ObjectTriggerObject',
    },
  },
} as const;

export const ObjectTriggersResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
    },
    next_page: {
      type: 'string',
      nullable: true,
    },
    previous_page: {
      type: 'string',
      nullable: true,
    },
    triggers: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ObjectTriggerObject',
      },
    },
  },
} as const;

export const OffsetPaginationObjectSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      description: 'the total record count',
    },
    next_page: {
      type: 'string',
      format: 'url',
      description: 'the URL of the next page',
      nullable: true,
    },
    previous_page: {
      type: 'string',
      format: 'url',
      description: 'the URL of the previous page',
      nullable: true,
    },
  },
} as const;

export const OrganizationFieldObjectSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/CustomFieldObject',
    },
  ],
  example: {
    active: true,
    created_at: '2012-10-16T16:04:06Z',
    description: 'Description of Custom Field',
    id: 7,
    key: 'custom_field_1',
    position: 9999,
    raw_description: '{{dc.my_description}}',
    raw_title: 'Custom Field 1',
    regexp_for_validation: null,
    title: 'Custom Field 1',
    type: 'text',
    updated_at: '2012-10-16T16:04:06Z',
    url: 'https://company.zendesk.com/api/v2/organization_fields/7.json',
  },
} as const;

export const OrganizationFieldResponseSchema = {
  type: 'object',
  properties: {
    organization_field: {
      $ref: '#/components/schemas/OrganizationFieldObject',
    },
  },
} as const;

export const OrganizationFieldsResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      description: 'Total count of records retrieved',
      readOnly: true,
    },
    next_page: {
      type: 'string',
      description: 'URL of the next page',
      nullable: true,
      readOnly: true,
    },
    organization_fields: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/OrganizationFieldObject',
      },
    },
    previous_page: {
      type: 'string',
      description: 'URL of the previous page',
      nullable: true,
      readOnly: true,
    },
  },
} as const;

export const OrganizationMembershipObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this record was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: 'Denotes whether this is the default organization membership for the user. If false, returns `null`',
      nullable: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when the membership is created',
      readOnly: true,
    },
    organization_id: {
      type: 'integer',
      description: 'The ID of the organization associated with this user, in this membership',
      readOnly: true,
    },
    organization_name: {
      type: 'string',
      description: 'The name of the organization associated with this user, in this membership',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this record last got updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this membership',
      readOnly: true,
    },
    user_id: {
      type: 'integer',
      description: 'The ID of the user for whom this memberships belongs',
      readOnly: true,
    },
    view_tickets: {
      type: 'boolean',
      description: "Denotes whether the user can or cannot have access to all organization's tickets.",
      readOnly: true,
    },
  },
  example: {
    created_at: '2009-05-13T00:07:08Z',
    default: true,
    id: 4,
    organization_id: 12,
    organization_name: 'first organization',
    updated_at: '2011-07-22T00:11:12Z',
    url: 'https://example.zendesk.com/api/v2/organization_memberships/4.json',
    user_id: 29,
    view_tickets: true,
  },
  required: ['user_id', 'organization_id', 'default'],
} as const;

export const OrganizationMembershipResponseSchema = {
  type: 'object',
  properties: {
    organization_membership: {
      $ref: '#/components/schemas/OrganizationMembershipObject',
    },
  },
} as const;

export const OrganizationMembershipsResponseSchema = {
  type: 'object',
  properties: {
    organization_memberships: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/OrganizationMembershipObject',
      },
    },
  },
} as const;

export const OrganizationMergeListResponseSchema = {
  type: 'object',
  properties: {
    organization_merges: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          id: {
            type: 'string',
            format: 'string',
          },
          loser_id: {
            type: 'integer',
          },
          status: {
            type: 'string',
            enum: ['new', 'in_progress', 'error', 'complete'],
          },
          url: {
            type: 'string',
            format: 'string',
          },
          winner_id: {
            type: 'integer',
          },
        },
      },
      required: ['id', 'url', 'loser_id', 'winner_id', 'status'],
    },
  },
} as const;

export const OrganizationMergeRequestSchema = {
  type: 'object',
  properties: {
    organization_merge: {
      type: 'object',
      properties: {
        winner_id: {
          type: 'integer',
          description: 'The id of the winning organization.',
          required: ['winner_id'],
        },
      },
    },
  },
} as const;

export const OrganizationMergeResponseSchema = {
  type: 'object',
  properties: {
    organization_merge: {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          format: 'string',
        },
        loser_id: {
          type: 'integer',
        },
        status: {
          type: 'string',
          enum: ['new', 'in_progress', 'error', 'complete'],
        },
        url: {
          type: 'string',
          format: 'string',
        },
        winner_id: {
          type: 'integer',
        },
      },
      required: ['id', 'url', 'loser_id', 'winner_id', 'status'],
    },
  },
} as const;

export const OrganizationMetadataObjectSchema = {
  type: 'object',
  properties: {
    tickets_count: {
      type: 'integer',
      description: 'The number of tickets for the organization',
    },
    users_count: {
      type: 'integer',
      description: 'The number of users for the organization',
    },
  },
} as const;

export const OrganizationObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      description: 'The time the organization was created',
      readOnly: true,
    },
    details: {
      type: 'string',
      description: 'Any details obout the organization, such as the address',
      nullable: true,
    },
    domain_names: {
      type: 'array',
      description: 'An array of domain names associated with this organization',
      items: {
        type: 'string',
      },
    },
    external_id: {
      type: 'string',
      description:
        'A unique external id to associate organizations to an external record. The id is case-insensitive. For example, "company1" and "Company1" are considered the same',
      nullable: true,
    },
    group_id: {
      type: 'integer',
      description: 'New tickets from users in this organization are automatically put in this group',
      nullable: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when the organization is created',
    },
    name: {
      type: 'string',
      description: 'A unique name for the organization',
    },
    notes: {
      type: 'string',
      description: 'Any notes you have about the organization',
      nullable: true,
    },
    organization_fields: {
      type: 'object',
      description:
        'Custom fields for this organization. See [Custom organization fields](/api-reference/ticketing/organizations/organizations/#custom-organization-fields)',
      additionalProperties: {
        oneOf: [
          {
            type: 'string',
          },
          {
            type: 'number',
          },
        ],
      },
      nullable: true,
    },
    shared_comments: {
      type: 'boolean',
      description: "End users in this organization are able to comment on each other's tickets",
    },
    shared_tickets: {
      type: 'boolean',
      description: "End users in this organization are able to see each other's tickets",
    },
    tags: {
      type: 'array',
      description: 'The tags of the organization',
      items: {
        type: 'string',
      },
    },
    updated_at: {
      type: 'string',
      description: 'The time of the last update of the organization',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this organization',
      readOnly: true,
    },
  },
  example: {
    created_at: '2009-07-20T22:55:29Z',
    details: 'This is a kind of organization',
    domain_names: ['example.com', 'test.com'],
    external_id: 'ABC123',
    group_id: null,
    id: 35436,
    name: 'One Organization',
    notes: '',
    organization_fields: {
      org_decimal: 5.2,
      org_dropdown: 'option_1',
    },
    shared_comments: true,
    shared_tickets: true,
    tags: ['enterprise', 'other_tag'],
    updated_at: '2011-05-05T10:38:52Z',
    url: 'https://company.zendesk.com/api/v2/organizations/35436.json',
  },
  required: ['name'],
} as const;

export const OrganizationResponseSchema = {
  type: 'object',
  properties: {
    organization: {
      $ref: '#/components/schemas/OrganizationObject',
    },
  },
} as const;

export const OrganizationSubscriptionCreateRequestSchema = {
  type: 'object',
  properties: {
    organization_subscription: {
      $ref: '#/components/schemas/OrganizationSubscriptionInput',
    },
  },
} as const;

export const OrganizationSubscriptionInputSchema = {
  type: 'object',
  properties: {
    organization_id: {
      type: 'integer',
      description: 'The ID of the organization',
    },
    user_id: {
      type: 'integer',
      description: 'The ID of the user',
    },
  },
} as const;

export const OrganizationSubscriptionObjectSchema = {
  title: 'Organization Subscriptions',
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The date the organization subscription was created',
    },
    id: {
      type: 'integer',
      description: 'The ID of the organization subscription',
    },
    organization_id: {
      type: 'integer',
      description: 'The ID of the organization',
    },
    user_id: {
      type: 'integer',
      description: 'The ID of the user',
    },
  },
  example: {
    created_at: '2009-07-20T22:55:29Z',
    id: 1234,
    organization_id: 32,
    user_id: 482,
  },
} as const;

export const OrganizationSubscriptionResponseSchema = {
  type: 'object',
  properties: {
    organization_subscription: {
      $ref: '#/components/schemas/OrganizationSubscriptionObject',
    },
  },
} as const;

export const OrganizationSubscriptionsResponseSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/OffsetPaginationObject',
    },
    {
      type: 'object',
      properties: {
        organization_subscriptions: {
          type: 'array',
          description: 'An array of organization subscriptions',
          items: {
            $ref: '#/components/schemas/OrganizationSubscriptionObject',
          },
        },
      },
    },
  ],
} as const;

export const OrganizationsRelatedResponseSchema = {
  type: 'object',
  properties: {
    organization_related: {
      $ref: '#/components/schemas/OrganizationMetadataObject',
    },
  },
} as const;

export const OrganizationsResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
    },
    next_page: {
      type: 'string',
      nullable: true,
    },
    organizations: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/OrganizationObject',
      },
    },
    previous_page: {
      type: 'string',
      nullable: true,
    },
  },
} as const;

export const PaginationSchema = {
  type: 'object',
  properties: {
    links: {
      type: 'object',
      properties: {
        next: {
          type: 'string',
        },
        prev: {
          type: 'string',
        },
      },
    },
    meta: {
      type: 'object',
      properties: {
        after_cursor: {
          type: 'string',
        },
        before_cursor: {
          type: 'string',
        },
        has_more: {
          type: 'boolean',
        },
      },
    },
  },
} as const;

export const PushNotificationDevicesInputSchema = {
  type: 'array',
  items: {
    type: 'string',
    description: 'Mobile device token',
  },
} as const;

export const PushNotificationDevicesRequestSchema = {
  type: 'object',
  properties: {
    push_notification_devices: {
      $ref: '#/components/schemas/PushNotificationDevicesInput',
    },
  },
} as const;

export const QueueObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the queue was created',
      readOnly: true,
    },
    definition: {
      type: 'object',
      description: 'Conditions when queue could be applied',
      properties: {
        all: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              field: {
                type: 'string',
              },
              operator: {
                type: 'string',
              },
              value: {
                type: 'string',
              },
            },
          },
        },
        any: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              field: {
                type: 'string',
              },
              operator: {
                type: 'string',
              },
              value: {
                type: 'string',
              },
            },
          },
        },
      },
    },
    description: {
      type: 'string',
      description: 'The description of the queue',
    },
    id: {
      type: 'string',
      description: 'Automatically assigned when creating queue',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'The name of the queue',
    },
    order: {
      type: 'integer',
      description: 'The queue-applied order',
    },
    primary_groups: {
      type: 'object',
      description: 'Primary group ids linked to the queue',
      properties: {
        count: {
          type: 'integer',
        },
        groups: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              id: {
                type: 'integer',
              },
              name: {
                type: 'string',
              },
            },
          },
        },
      },
    },
    priority: {
      type: 'integer',
      description: 'The queue-applied priority',
    },
    secondary_groups: {
      type: 'object',
      description: 'Secondary group ids linked to the queue',
      properties: {
        count: {
          type: 'integer',
        },
        groups: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              id: {
                type: 'integer',
              },
              name: {
                type: 'string',
              },
            },
          },
        },
      },
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: "The time of the queue's last update",
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API URL of the queue',
      readOnly: true,
    },
  },
  example: {
    created_at: '2023-11-27T09:03:59Z',
    definition: {
      all: [
        {
          field: 'priority',
          operator: 'is',
          value: 'urgent',
        },
      ],
      any: [],
    },
    description: 'Queue description',
    id: '01HG80ATNNZK1N7XRFVKX48XD6',
    name: 'New queue with valid definition',
    order: 1,
    primary_groups: {
      count: 2,
      groups: [
        {
          id: 6784729637757,
          name: 'EWR',
        },
        {
          id: 5399674286077,
          name: 'test',
        },
      ],
    },
    priority: 1,
    secondary_groups: {
      count: 0,
      groups: [],
    },
    updated_at: '2023-11-27T09:03:59Z',
    url: 'https://company.zendesk.com/api/v2/queues/01HG80ATNNZK1N7XRFVKX48XD6.json',
  },
} as const;

export const QueueResponseSchema = {
  type: 'object',
  properties: {
    queue: {
      $ref: '#/components/schemas/QueueObject',
    },
  },
} as const;

export const QueuesResponseSchema = {
  type: 'object',
  properties: {
    queues: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/QueueObject',
      },
    },
  },
} as const;

export const RecipientObjectSchema = {
  type: 'object',
  properties: {
    delivery_status: {
      type: 'object',
      description: 'Details about the delivery status',
      properties: {
        code: {
          type: 'string',
          description: 'The delivery status code (SMTP code and DSN code)',
          readOnly: true,
        },
        id: {
          type: 'integer',
          description: 'The delivery status id',
          readOnly: true,
        },
        message: {
          type: 'string',
          description: 'The delivery status description',
          readOnly: true,
        },
        name: {
          type: 'string',
          description: 'The delivery status type (key)',
          readOnly: true,
        },
      },
    },
    email_address: {
      type: 'string',
      description: "The recipient's email address",
      readOnly: true,
    },
    user_id: {
      type: 'integer',
      description: "The recipient's user id",
      readOnly: true,
    },
  },
} as const;

export const RecoverSuspendedTicketResponseSchema = {
  type: 'object',
  properties: {
    ticket: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketObject',
      },
    },
  },
} as const;

export const RecoverSuspendedTicketUnprocessableContentResponseSchema = {
  type: 'object',
  properties: {
    ticket: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SuspendedTicketObject',
      },
    },
  },
} as const;

export const RecoverSuspendedTicketsResponseSchema = {
  type: 'object',
  properties: {
    tickets: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketObject',
      },
    },
  },
} as const;

export const RelationshipFilterDefinitionSchema = {
  type: 'object',
  properties: {
    conditions_all: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TriggerConditionDefinitionObjectAll',
      },
    },
    conditions_any: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TriggerConditionDefinitionObjectAny',
      },
    },
  },
} as const;

export const RelationshipFilterDefinitionResponseSchema = {
  type: 'object',
  properties: {
    definitions: {
      $ref: '#/components/schemas/RelationshipFilterDefinition',
    },
  },
} as const;

export const RenewSessionResponseSchema = {
  type: 'object',
  properties: {
    authenticity_token: {
      type: 'string',
      description: 'A token of authenticity for the request',
    },
  },
} as const;

export const RequestObjectSchema = {
  type: 'object',
  properties: {
    assignee_id: {
      type: 'integer',
      description: 'The id of the assignee if the field is visible to end users',
      readOnly: true,
    },
    can_be_solved_by_me: {
      type: 'boolean',
      description:
        'If true, an end user can mark the request as solved. See [Update Request](/api-reference/ticketing/tickets/ticket-requests/#update-request)',
      readOnly: true,
    },
    collaborator_ids: {
      type: 'array',
      description: "The ids of users currently CC'ed on the ticket",
      items: {
        type: 'integer',
      },
      readOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this record was created',
      readOnly: true,
    },
    custom_fields: {
      type: 'array',
      description:
        'Custom fields for the request. See [Setting custom field values](/api-reference/ticketing/tickets/tickets/#setting-custom-field-values) in the Tickets doc',
      items: {
        type: 'object',
        properties: {
          id: {
            type: 'integer',
          },
          value: {
            type: 'string',
          },
        },
      },
    },
    custom_status_id: {
      type: 'integer',
      description: 'The custom ticket status id of the ticket',
    },
    description: {
      type: 'string',
      description:
        'Read-only first comment on the request. When [creating a request](#create-request), use `comment` to set the description',
      readOnly: true,
    },
    due_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the task is due (only applies if the request is of type "task")',
    },
    email_cc_ids: {
      type: 'array',
      description:
        'The ids of users who are currently email CCs on the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233) in the Support Help Center',
      items: {
        type: 'integer',
      },
      readOnly: true,
    },
    followup_source_id: {
      type: 'integer',
      description:
        'The id of the original ticket if this request is a follow-up ticket. See [Create Request](#create-request)',
      readOnly: true,
    },
    group_id: {
      type: 'integer',
      description: 'The id of the assigned group if the field is visible to end users',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when creating requests',
      readOnly: true,
    },
    is_public: {
      type: 'boolean',
      description: 'Is true if any comments are public, false otherwise',
      readOnly: true,
    },
    organization_id: {
      type: 'integer',
      description: 'The organization of the requester',
      readOnly: true,
    },
    priority: {
      type: 'string',
      description: 'The priority of the request, "low", "normal", "high", "urgent"',
    },
    recipient: {
      type: 'string',
      description: 'The original recipient e-mail address of the request',
    },
    requester_id: {
      type: 'integer',
      description: 'The id of the requester',
      readOnly: true,
    },
    solved: {
      type: 'boolean',
      description:
        'Whether or not request is solved (an end user can set this if "can_be_solved_by_me", above, is true for that user)',
    },
    status: {
      type: 'string',
      description: 'The state of the request, "new", "open", "pending", "hold", "solved", "closed"',
    },
    subject: {
      type: 'string',
      description:
        'The value of the subject field for this request if the subject field is visible to end users; a truncated version of the description otherwise',
    },
    ticket_form_id: {
      type: 'integer',
      description:
        'The numeric id of the ticket form associated with this request if the form is visible to end users - only applicable for enterprise accounts',
    },
    type: {
      type: 'string',
      description: 'The type of the request, "question", "incident", "problem", "task"',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this record last got updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this request',
      readOnly: true,
    },
    via: {
      $ref: '#/components/schemas/TicketAuditViaObject',
    },
  },
  example: {
    assignee_id: 72983,
    can_be_solved_by_me: false,
    collaborator_ids: [],
    created_at: '2009-07-20T22:55:29Z',
    description: 'The fire is very colorful.',
    due_at: '2011-05-24T12:00:00Z',
    group_id: 8665,
    id: 35436,
    organization_id: 509974,
    priority: 'normal',
    requester_id: 1462,
    status: 'open',
    subject: 'Help, my printer is on fire!',
    ticket_form_id: 2,
    type: 'problem',
    updated_at: '2011-05-05T10:38:52Z',
    url: 'https://company.zendesk.com/api/v2/requests/35436.json',
    via: {
      channel: 'web',
    },
  },
  required: ['subject'],
} as const;

export const RequestResponseSchema = {
  type: 'object',
  properties: {
    request: {
      $ref: '#/components/schemas/RequestObject',
    },
  },
} as const;

export const RequestsResponseSchema = {
  type: 'object',
  properties: {
    requests: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/RequestObject',
      },
    },
  },
} as const;

export const ResourceCollectionObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the resource collection was created',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'id for the resource collection. Automatically assigned upon creation',
      readOnly: true,
    },
    resources: {
      type: 'array',
      description: 'Array of resource metadata objects. See [Resource objects](#resource-objects)',
      items: {
        type: 'object',
        properties: {
          deleted: {
            type: 'boolean',
          },
          identifier: {
            type: 'string',
          },
          resource_id: {
            type: 'integer',
          },
          type: {
            type: 'string',
          },
        },
      },
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'Last time the resource collection was updated',
      readOnly: true,
    },
  },
  example: {
    created_at: '2011-07-20T22:55:29Z',
    id: 35436,
    resources: [
      {
        deleted: false,
        identifier: 'email_on_ticket_solved',
        resource_id: 10824486485524,
        type: 'triggers',
      },
      {
        deleted: false,
        identifier: 'support_description',
        resource_id: 10824486482580,
        type: 'ticket_fields',
      },
    ],
    updated_at: '2011-07-20T22:55:29Z',
  },
} as const;

export const ResourceCollectionResponseSchema = {
  type: 'object',
  properties: {
    resource_collection: {
      $ref: '#/components/schemas/ResourceCollectionObject',
    },
  },
} as const;

export const ResourceCollectionsResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      readOnly: true,
    },
    next_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    resource_collections: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ResourceCollectionObject',
      },
    },
  },
} as const;

export const ReverseLookupResponseSchema = {
  type: 'object',
  anyOf: [
    {
      $ref: '#/components/schemas/UsersResponse',
    },
  ],
} as const;

export const SLAPoliciesResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      readOnly: true,
    },
    next_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    sla_policies: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SLAPolicyObject',
      },
    },
  },
} as const;

export const SLAPolicyFilterConditionObjectSchema = {
  type: 'object',
  properties: {
    field: {
      type: 'string',
      description: 'The name of a ticket field',
    },
    operator: {
      type: 'string',
      description: 'A comparison operator',
    },
    value: {
      description: 'The value of a ticket field',
      oneOf: [
        {
          type: 'string',
        },
        {
          type: 'array',
          items: {
            oneOf: [
              {
                type: 'string',
              },
              {
                type: 'integer',
              },
            ],
          },
        },
      ],
    },
  },
} as const;

export const SLAPolicyFilterDefinitionResponseSchema = {
  type: 'object',
  properties: {
    definitions: {
      type: 'object',
      properties: {
        all: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              group: {
                type: 'string',
              },
              operators: {
                type: 'array',
                items: {
                  type: 'object',
                  properties: {
                    title: {
                      type: 'string',
                    },
                    value: {
                      type: 'string',
                    },
                  },
                },
              },
              target: {
                type: 'string',
                nullable: true,
              },
              title: {
                type: 'string',
              },
              value: {
                type: 'string',
              },
              values: {
                type: 'object',
                properties: {
                  list: {
                    type: 'array',
                    items: {
                      type: 'object',
                      properties: {
                        title: {
                          type: 'string',
                        },
                        value: {
                          type: 'string',
                          nullable: true,
                        },
                      },
                    },
                  },
                  type: {
                    type: 'string',
                  },
                },
              },
            },
          },
        },
        any: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              group: {
                type: 'string',
              },
              operators: {
                type: 'array',
                items: {
                  type: 'object',
                  properties: {
                    title: {
                      type: 'string',
                    },
                    value: {
                      type: 'string',
                    },
                  },
                },
              },
              target: {
                type: 'string',
                nullable: true,
              },
              title: {
                type: 'string',
              },
              value: {
                type: 'string',
              },
              values: {
                type: 'object',
                properties: {
                  list: {
                    type: 'array',
                    items: {
                      type: 'object',
                      properties: {
                        title: {
                          type: 'string',
                        },
                        value: {
                          type: 'string',
                          nullable: true,
                        },
                      },
                    },
                  },
                  type: {
                    type: 'string',
                  },
                },
              },
            },
          },
        },
      },
    },
  },
} as const;

export const SLAPolicyFilterObjectSchema = {
  type: 'object',
  description:
    'An object that describes the conditions that a ticket must match in order for an SLA policy to be applied to that ticket. See [Filter](#filter).',
  properties: {
    all: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SLAPolicyFilterConditionObject',
      },
    },
    any: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SLAPolicyFilterConditionObject',
      },
    },
  },
} as const;

export const SLAPolicyMetricObjectSchema = {
  type: 'object',
  properties: {
    business_hours: {
      type: 'boolean',
      description: 'Whether the metric targets are being measured in business hours or calendar hours',
    },
    metric: {
      type: 'string',
      description: 'The definition of the time that is being measured',
    },
    priority: {
      type: 'string',
      description: 'Priority that a ticket must match',
    },
    target: {
      type: 'integer',
      description: 'The time within which the end-state for a metric should be met',
    },
  },
} as const;

export const SLAPolicyObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the SLA policy was created',
      readOnly: true,
    },
    description: {
      type: 'string',
      description: 'The description of the SLA policy',
    },
    filter: {
      $ref: '#/components/schemas/SLAPolicyFilterObject',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when created',
      readOnly: true,
    },
    policy_metrics: {
      type: 'array',
      description: 'Array of [Policy Metric](#policy-metric) objects',
      items: {
        $ref: '#/components/schemas/SLAPolicyMetricObject',
      },
    },
    position: {
      type: 'integer',
      description:
        'Position of the SLA policy that determines the order they will be matched. If not specified, the SLA policy is added as the last position',
    },
    title: {
      type: 'string',
      description: 'The title of the SLA policy',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the SLA policy',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'URL of the SLA Policy reacord',
      readOnly: true,
    },
  },
  example: {
    created_at: '2015-03-17T22:50:26Z',
    description: 'Organizations: Silver Plan',
    filter: {
      all: [
        {
          field: 'type',
          operator: 'is',
          value: 'incident',
        },
        {
          field: 'via_id',
          operator: 'is',
          value: '4',
        },
        {
          field: 'custom_status_id',
          operator: 'includes',
          value: ['1', '2'],
        },
      ],
      any: [],
    },
    id: 25,
    policy_metrics: [
      {
        business_hours: false,
        metric: 'first_reply_time',
        priority: 'low',
        target: 60,
      },
    ],
    position: 3,
    title: 'Silver Plan',
    updated_at: '2015-03-17T22:50:26Z',
    url: 'https://company.zendesk.com/api/v2/slas/policies/25.json',
  },
  required: ['title', 'filter'],
} as const;

export const SLAPolicyResponseSchema = {
  type: 'object',
  properties: {
    sla_policy: {
      $ref: '#/components/schemas/SLAPolicyObject',
    },
  },
} as const;

export const SatisfactionRatingObjectSchema = {
  type: 'object',
  properties: {
    assignee_id: {
      type: 'integer',
      description: 'The id of agent assigned to at the time of rating',
      readOnly: true,
    },
    comment: {
      type: 'string',
      description: 'The comment received with this rating, if available',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the satisfaction rating got created',
      readOnly: true,
    },
    group_id: {
      type: 'integer',
      description: 'The id of group assigned to at the time of rating',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned upon creation',
      readOnly: true,
    },
    reason: {
      type: 'string',
      description:
        'The reason for a bad rating given by the requester in a follow-up question. Satisfaction reasons must be [enabled](https://support.zendesk.com/hc/en-us/articles/223152967)',
    },
    reason_code: {
      type: 'integer',
      description: `The default reasons the user can select from a list menu for giving a negative rating. See [Reason codes](/api-reference/ticketing/ticket-management/satisfaction_reasons/#reason-codes) in the Satisfaction Reasons API. Can only be set on ratings with a \`score\` of "bad". Responses don't include this property`,
    },
    reason_id: {
      type: 'integer',
      description:
        'id for the reason the user gave a negative rating. Can only be set on ratings with a `score` of "bad". To get a descriptive value for the id, use the [Show Reason for Satisfaction Rating](/api-reference/ticketing/ticket-management/satisfaction_reasons/#show-reason-for-satisfaction-rating) endpoint',
    },
    requester_id: {
      type: 'integer',
      description: 'The id of ticket requester submitting the rating',
      readOnly: true,
    },
    score: {
      type: 'string',
      description: 'The rating "offered", "unoffered", "good" or "bad"',
    },
    ticket_id: {
      type: 'integer',
      description: 'The id of ticket being rated',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the satisfaction rating got updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this rating',
      readOnly: true,
    },
  },
  example: {
    assignee_id: 135,
    created_at: '2011-07-20T22:55:29Z',
    group_id: 44,
    id: 35436,
    requester_id: 7881,
    score: 'good',
    ticket_id: 208,
    updated_at: '2011-07-20T22:55:29Z',
    url: 'https://company.zendesk.com/api/v2/satisfaction_ratings/62.json',
  },
  required: ['assignee_id', 'group_id', 'requester_id', 'ticket_id', 'score'],
} as const;

export const SatisfactionRatingResponseSchema = {
  type: 'object',
  properties: {
    satisfaction_rating: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SatisfactionRatingObject',
      },
    },
  },
} as const;

export const SatisfactionRatingsCountResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'object',
      properties: {
        refreshed_at: {
          type: 'string',
          format: 'date-time',
        },
        value: {
          type: 'integer',
        },
      },
    },
  },
} as const;

export const SatisfactionRatingsResponseSchema = {
  type: 'object',
  properties: {
    satisfaction_ratings: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SatisfactionRatingObject',
      },
    },
  },
} as const;

export const SatisfactionReasonObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the reason was created',
      readOnly: true,
    },
    deleted_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the reason was deleted',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned upon creation',
      readOnly: true,
    },
    raw_value: {
      type: 'string',
      description:
        'The dynamic content placeholder, if present, or the current "value", if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    reason_code: {
      type: 'integer',
      description:
        'An account-level code for referencing the reason. Custom reasons are assigned an auto-incrementing integer (non-system reason codes begin at 1000). See [Reason codes](#reason-codes)',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the reason was updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'API URL for the resource',
      readOnly: true,
    },
    value: {
      type: 'string',
      description: 'Translated value of the reason in the account locale',
    },
  },
  example: {
    created_at: '2011-07-20T22:55:29Z',
    deleted_at: '2012-03-12T12:45:32Z',
    id: 35436,
    raw_value: '{{dc.reason_code_1003}}',
    reason_code: 1003,
    updated_at: '2011-07-20T22:55:29Z',
    url: 'https://example.zendesk.com/api/v2/satisfaction_reasons/35436.json',
    value: 'Agent did not respond quickly',
  },
  required: ['value'],
} as const;

export const SatisfactionReasonResponseSchema = {
  type: 'object',
  properties: {
    reason: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SatisfactionReasonObject',
      },
    },
  },
} as const;

export const SatisfactionReasonsResponseSchema = {
  type: 'object',
  properties: {
    reasons: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SatisfactionReasonObject',
      },
    },
  },
} as const;

export const SearchCountResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
    },
  },
} as const;

export const SearchExportResponseSchema = {
  type: 'object',
  properties: {
    facets: {
      type: 'string',
      description: 'The facets corresponding to the search query',
      nullable: true,
      readOnly: true,
    },
    links: {
      type: 'object',
      description: 'The links to the previous and next entries via the cursor ids in the metadata.',
      properties: {
        next: {
          type: 'string',
          description: 'The url to the next entry via the cursor.',
          nullable: true,
          readOnly: true,
        },
        prev: {
          type: 'string',
          description: 'The url to the previous entry via the cursor.',
          nullable: true,
          readOnly: true,
        },
      },
    },
    meta: {
      type: 'object',
      description: 'Metadata for the export query response.',
      properties: {
        after_cursor: {
          type: 'string',
          description: 'The cursor id for the next object.',
          nullable: true,
          readOnly: true,
        },
        before_cursor: {
          type: 'string',
          description: 'The cursor id for the previous object.',
          nullable: true,
          readOnly: true,
        },
        has_more: {
          type: 'boolean',
          description: 'Whether there are more items yet to be returned by the cursor.',
          readOnly: true,
        },
      },
    },
    results: {
      type: 'array',
      description:
        'May consist of tickets, users, groups, or organizations, as specified by the `result_type` property in each result object',
      items: {
        $ref: '#/components/schemas/SearchResultObject',
      },
      readOnly: true,
    },
  },
  example: {
    facets: null,
    links: {
      next: 'https://example.zendesk.com/api/v2/search/export.json?filter%5Btype%5D=ticket&page%5Bafter%5D=eyJmaWVsZCI6ImNyZWF0ZWRfYXQiLCJkZXNjIjp0cnVlLCJ0aWVCcmVha0ZpZWxkIjoiaWQiLCJ0aWVCcmVha0Rlc2MiOmZhbHNlLCJzb3J0VmFsdWVzIjpudWxsLCJleHBvcnRlZFRodXNGYXIiOjAsInNlc3Npb25TdGFydCI6MTYwNzAzOTI1Mzk4NSwiY3JlYXRlZEF0IjoxNjA3MDM5MjUzOTg1LCJzYWx0ZWRSZXF1ZXN0SGFzaCI6LTQ5ODM0ODc3LCJzYWx0ZWRDdXJzb3JIYXNoIjotMjQwMzQ4MjgwfQ%3D%3D&page%5Bsize%5D=100&query=hello%26page%5Bsize%5D%3D100%26filter%5Btype%5D%3Dticket',
      prev: null,
    },
    meta: {
      after_cursor:
        'eyJmaWVsZCI6ImNyZWF0ZWRfYXQiLCJkZXNjIjp0cnVlLCJ0aWVCcmVha0ZpZWxkIjoiaWQiLCJ0aWVCcmVha0Rlc2MiOmZhbHNlLCJzb3J0VmFsdWVzIjpudWxsLCJleHBvcnRlZFRodXNGYXIiOjAsInNlc3Npb25TdGFydCI6MTYwNzAzOTI1Mzk4NSwiY3JlYXRlZEF0IjoxNjA3MDM5MjUzOTg1LCJzYWx0ZWRSZXF1ZXN0SGFzaCI6LTQ5ODM0ODc3LCJzYWx0ZWRDdXJzb3JIYXNoIjotMjQwMzQ4MjgwfQ==',
      before_cursor: null,
      has_more: true,
    },
    results: [],
  },
} as const;

export const SearchResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      description:
        'The number of resources returned by the query corresponding to this page of results in the paginated response',
      readOnly: true,
    },
    facets: {
      type: 'string',
      description: 'The facets corresponding to the search query',
      nullable: true,
      readOnly: true,
    },
    next_page: {
      type: 'string',
      description: 'URL to the next page of results',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      description: 'URL to the previous page of results',
      nullable: true,
      readOnly: true,
    },
    results: {
      type: 'array',
      description:
        'May consist of tickets, users, groups, or organizations, as specified by the `result_type` property in each result object',
      items: {
        $ref: '#/components/schemas/SearchResultObject',
      },
      readOnly: true,
    },
  },
  example: {
    count: 1,
    facets: null,
    next_page: null,
    previous_page: null,
    results: [
      {
        created_at: '2018-04-06T03:17:05Z',
        default: false,
        deleted: false,
        description: '',
        id: 1835972,
        name: 'Ragtail',
        result_type: 'group',
        updated_at: '2018-04-06T03:17:05Z',
        url: 'https://example.zendesk.com/api/v2/groups/1835972.json',
      },
    ],
  },
} as const;

export const SearchResultObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      description: 'When the resource was created',
    },
    default: {
      type: 'boolean',
      description: 'Flag to indicate whether this is the default resource',
    },
    deleted: {
      type: 'boolean',
      description: 'Flag to indicate whether or not resource has been deleted',
    },
    description: {
      type: 'string',
      description: 'The description of the resource',
    },
    id: {
      type: 'integer',
      description: 'The ID of the resource',
    },
    name: {
      type: 'string',
      description: 'The name of the resource',
    },
    result_type: {
      type: 'string',
      description: 'The type of the resource',
    },
    updated_at: {
      type: 'string',
      description: 'When the resource was last updated',
    },
    url: {
      type: 'string',
      description: 'The url of the resource',
    },
  },
} as const;

export const SessionObjectSchema = {
  type: 'object',
  properties: {
    authenticated_at: {
      type: 'string',
      description: 'When the session was created',
      nullable: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when the session is created',
    },
    last_seen_at: {
      type: 'string',
      description: 'The last approximate time this session was seen. This does not update on every request.',
      nullable: true,
    },
    url: {
      type: 'string',
      description: 'The API URL of this session',
      nullable: true,
    },
    user_id: {
      type: 'integer',
      description: 'The id of the user',
      nullable: true,
    },
  },
  example: {
    authenticated_at: '2014-11-18T17:24:29Z',
    id: 3432,
    last_seen_at: '2014-11-18T17:30:52Z',
    url: 'https://company.zendesk.com/api/v2/users/12345/sessions/3432.json',
    user_id: 12345,
  },
  required: ['id'],
} as const;

export const SessionResponseSchema = {
  type: 'object',
  properties: {
    session: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SessionObject',
      },
    },
  },
} as const;

export const SessionsResponseSchema = {
  type: 'object',
  properties: {
    sessions: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SessionObject',
      },
    },
  },
} as const;

export const SharingAgreementObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the record was created',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned upon creation',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'Name of this sharing agreement',
    },
    partner_name: {
      type: 'string',
      description: 'Can be one of the following: "jira", null',
      nullable: true,
    },
    remote_subdomain: {
      type: 'string',
      description: 'Subdomain of the remote account or null if not associated with an account',
    },
    status: {
      type: 'string',
      description:
        'Can be one of the following: "accepted", "declined", "pending", "inactive", "failed", "ssl_error", "configuration_error"',
    },
    type: {
      type: 'string',
      description: 'Can be one of the following: "inbound", "outbound"',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the record was updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'URL of the sharing agreement record',
      readOnly: true,
    },
  },
  example: {
    created_at: '2012-02-20T22:55:29Z',
    id: 88335,
    name: 'Ticket Sharing',
    partner_name: 'jira',
    status: 'accepted',
    type: 'inbound',
    updated_at: '2013-02-20T22:55:29Z',
    url: 'https://company.zendesk.com/api/v2/agreements/88335.json',
  },
} as const;

export const SharingAgreementResponseSchema = {
  type: 'object',
  properties: {
    sharing_agreement: {
      $ref: '#/components/schemas/SharingAgreementObject',
    },
  },
} as const;

export const SharingAgreementsResponseSchema = {
  type: 'object',
  properties: {
    sharing_agreements: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SharingAgreementObject',
      },
    },
  },
} as const;

export const SkillBasedRoutingAttributeDefinitionsSchema = {
  type: 'object',
  properties: {
    definitions: {
      type: 'object',
      properties: {
        conditions_all: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              subject: {
                type: 'string',
              },
              title: {
                type: 'string',
              },
            },
          },
        },
        conditions_any: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              subject: {
                type: 'string',
              },
              title: {
                type: 'string',
              },
            },
          },
        },
      },
    },
  },
} as const;

export const SkillBasedRoutingAttributeObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this record was created',
      readOnly: true,
    },
    id: {
      type: 'string',
      description: 'Automatically assigned when an attribute is created',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'The name of the attribute',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this record was last updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'URL of the attribute',
      readOnly: true,
    },
  },
  example: {
    created_at: '2017-12-01T19:29:31Z',
    id: '15821cba-7326-11e8-b07e-950ba849aa27',
    name: 'color',
    updated_at: '2017-12-01T19:29:31Z',
    url: 'https://{subdomain}.zendesk.com/api/v2/routing/attributes/15821cba-7326-11e8-b07e-950ba849aa27.json',
  },
  required: ['name'],
} as const;

export const SkillBasedRoutingAttributeResponseSchema = {
  type: 'object',
  properties: {
    attribute: {
      $ref: '#/components/schemas/SkillBasedRoutingAttributeObject',
    },
  },
} as const;

export const SkillBasedRoutingAttributeValueObjectSchema = {
  type: 'object',
  properties: {
    attribute_id: {
      type: 'string',
      description: 'Id of the associated attribute',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this record was created',
      readOnly: true,
    },
    id: {
      type: 'string',
      description: 'Automatically assigned when an attribute value is created',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'The name of the attribute value',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this record was last updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'URL of the attribute value',
      readOnly: true,
    },
  },
} as const;

export const SkillBasedRoutingAttributeValueResponseSchema = {
  type: 'object',
  properties: {
    attribute_value: {
      $ref: '#/components/schemas/SkillBasedRoutingAttributeValueObject',
    },
  },
} as const;

export const SkillBasedRoutingAttributeValuesResponseSchema = {
  type: 'object',
  properties: {
    attribute_values: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SkillBasedRoutingAttributeValueObject',
      },
    },
  },
} as const;

export const SkillBasedRoutingAttributesResponseSchema = {
  type: 'object',
  properties: {
    attributes: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SkillBasedRoutingAttributeObject',
      },
    },
    count: {
      type: 'integer',
      readOnly: true,
    },
    next_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
  },
} as const;

export const SkillBasedRoutingTicketFulfilledResponseSchema = {
  type: 'object',
  properties: {
    fulfilled_ticket_ids: {
      type: 'array',
      items: {
        type: 'integer',
      },
    },
  },
} as const;

export const SupportAddressObjectSchema = {
  type: 'object',
  properties: {
    brand_id: {
      type: 'integer',
      description: 'The ID of the [brand](/api-reference/ticketing/account-configuration/brands/)',
    },
    cname_status: {
      type: 'string',
      description:
        'Whether all of the required CNAME records are set. Possible values: "unknown", "verified", "failed"',
      enum: ['unknown', 'verified', 'failed'],
      readOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the address was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: "Whether the address is the account's default support address",
    },
    dns_results: {
      type: 'string',
      description: 'Verification statuses for the domain and CNAME records. Possible types: "verified", "failed"',
      enum: ['verified', 'failed'],
      readOnly: true,
    },
    domain_verification_code: {
      type: 'string',
      description: 'Verification string to be added as a TXT record to the domain. Possible types: string or null.',
      readOnly: true,
    },
    domain_verification_status: {
      type: 'string',
      description: 'Whether the domain verification record is valid. Possible values: "unknown", "verified", "failed"',
      enum: ['unknown', 'verified', 'failed'],
      readOnly: true,
    },
    email: {
      type: 'string',
      description: "The email address. You can't change the email address of an existing support address.",
    },
    forwarding_status: {
      type: 'string',
      description: 'Status of email forwarding. Possible values: "unknown", "waiting", "verified", or "failed"',
      enum: ['unknown', 'waiting', 'verified', 'failed'],
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when created',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'The name for the address',
    },
    spf_status: {
      type: 'string',
      description: 'Whether the SPF record is set up correctly. Possible values: "unknown", "verified", "failed"',
      enum: ['unknown', 'verified', 'failed'],
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the address was updated',
      readOnly: true,
    },
  },
  example: {
    brand_id: 123,
    cname_status: 'verified',
    created_at: '2015-07-20T22:55:29Z',
    default: true,
    domain_verification_status: 'verified',
    email: 'support@example.zendesk.com',
    forwarding_status: 'unknown',
    id: 35436,
    name: 'all',
    spf_status: 'verified',
    updated_at: '2016-09-21T20:15:20Z',
  },
  required: ['email'],
} as const;

export const SupportAddressResponseSchema = {
  type: 'object',
  properties: {
    recipient_address: {
      $ref: '#/components/schemas/SupportAddressObject',
    },
  },
} as const;

export const SupportAddressesResponseSchema = {
  type: 'object',
  properties: {
    recipient_addresses: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SupportAddressObject',
      },
    },
  },
} as const;

export const SuspendedTicketObjectSchema = {
  type: 'object',
  properties: {
    attachments: {
      type: 'array',
      description:
        'The attachments, if any associated to this suspended ticket. See [Attachments](/api-reference/ticketing/tickets/ticket-attachments/)',
      items: {
        $ref: '#/components/schemas/AttachmentObject',
      },
      nullable: true,
      readOnly: true,
    },
    author: {
      type: 'object',
      description: 'The author id (if available), name and email',
      allOf: [
        {
          $ref: '#/components/schemas/AuthorObject',
        },
      ],
      readOnly: true,
    },
    brand_id: {
      type: 'integer',
      description: 'The id of the brand this ticket is associated with. Only applicable for Enterprise accounts',
      readOnly: true,
    },
    cause: {
      type: 'string',
      description: 'Why the ticket was suspended',
      readOnly: true,
    },
    cause_id: {
      type: 'integer',
      description: 'The ID of the cause',
      readOnly: true,
    },
    content: {
      type: 'string',
      description: 'The content that was flagged',
      readOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The ticket ID this suspended email is associated with, if available',
      readOnly: true,
    },
    error_messages: {
      type: 'array',
      description: 'The error messages if any associated to this suspended ticket',
      items: {
        type: 'object',
      },
      nullable: true,
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned',
      readOnly: true,
    },
    message_id: {
      type: 'string',
      description: 'The ID of the email, if available',
      readOnly: true,
    },
    recipient: {
      type: 'string',
      description: 'The original recipient e-mail address of the ticket',
      readOnly: true,
    },
    subject: {
      type: 'string',
      description: 'The value of the subject field for this ticket',
      readOnly: true,
    },
    ticket_id: {
      type: 'integer',
      description: 'The ticket ID this suspended email is associated with, if available',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the ticket was assigned',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this ticket',
      readOnly: true,
    },
    via: {
      $ref: '#/components/schemas/ViaObject',
    },
  },
  example: {
    attachments: [],
    author: {
      email: 'styx@example.com',
      id: 1111,
      name: 'Mr. Roboto',
    },
    brand_id: 123,
    cause: 'Detected as spam',
    cause_id: 0,
    content: 'Out Of Office Reply',
    created_at: '2009-07-20T22:55:29Z',
    error_messages: null,
    id: 435,
    message_id: 'Spambot@spam.co.evil',
    recipient: 'john@example.com',
    subject: 'Help, my printer is on fire!',
    ticket_id: 67321,
    updated_at: '2011-05-05T10:38:52Z',
    url: 'https://example.zendesk.com/api/v2/tickets/35436.json',
    via: {
      channel: 'email',
      source: {
        from: {
          address: 'totallylegit@emailaddress.com',
          name: 'TotallyLegit',
        },
        rel: null,
        to: {
          address: 'support@example.zendesk.com',
          name: 'Example Account',
        },
      },
    },
  },
} as const;

export const SuspendedTicketResponseSchema = {
  type: 'object',
  properties: {
    suspended_ticket: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SuspendedTicketObject',
      },
    },
  },
} as const;

export const SuspendedTicketsAttachmentsResponseSchema = {
  type: 'object',
  properties: {
    upload: {
      type: 'object',
      properties: {
        attachments: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/AttachmentObject',
          },
        },
        token: {
          type: 'string',
          description: 'Token for subsequent request',
          readOnly: true,
        },
      },
    },
  },
} as const;

export const SuspendedTicketsExportResponseSchema = {
  type: 'object',
  properties: {
    export: {
      type: 'object',
      properties: {
        status: {
          type: 'string',
          readOnly: true,
        },
        view_id: {
          type: 'string',
          readOnly: true,
        },
      },
    },
  },
} as const;

export const SuspendedTicketsResponseSchema = {
  type: 'object',
  properties: {
    suspended_tickets: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SuspendedTicketObject',
      },
    },
  },
} as const;

export const SystemFieldOptionObjectSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      description: 'Name of the system field option',
      readOnly: true,
    },
    value: {
      type: 'string',
      description: 'Value of the system field option',
      readOnly: true,
    },
  },
} as const;

export const TagCountObjectSchema = {
  type: 'object',
  properties: {
    refreshed_at: {
      type: 'string',
      description: 'The time that the count value was last refreshed',
      readOnly: true,
    },
    value: {
      type: 'integer',
      description: 'The count of tags created in the last 24 hours',
      readOnly: true,
    },
  },
} as const;

export const TagCountResponseSchema = {
  type: 'object',
  properties: {
    count: {
      $ref: '#/components/schemas/TagCountObject',
    },
  },
} as const;

export const TagListTagObjectSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      description: 'The number of tags',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'A name for the tag',
    },
  },
} as const;

export const TagUrlObjectSchema = {
  type: 'object',
  properties: {
    url: {
      type: 'string',
      description: 'The url associated to the api request',
      readOnly: true,
    },
  },
} as const;

export const TagsByObjectIdResponseSchema = {
  type: 'object',
  properties: {
    tags: {
      type: 'array',
      description: 'An array of strings',
      items: {
        type: 'string',
      },
    },
  },
  required: ['tags'],
} as const;

export const TagsResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      description: 'The number of pages',
      readOnly: true,
    },
    next_page: {
      type: 'string',
      description: 'The url of the previous page',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      description: 'The url of the next page',
      nullable: true,
      readOnly: true,
    },
    tags: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TagListTagObject',
      },
    },
  },
} as const;

export const TargetBasecampSchema = {
  type: 'object',
  properties: {
    message_id: {
      type: 'string',
      description: 'Can be filled if it is a "message" resource',
    },
    password: {
      type: 'string',
      description: 'The 37Signals password for the Basecamp account (only writable)',
    },
    project_id: {
      type: 'string',
      description: 'The ID of the project in Basecamp where updates should be pushed',
    },
    resource: {
      type: 'string',
      description: '"todo" or "message"',
    },
    target_url: {
      type: 'string',
      description: 'The URL of your Basecamp account, including protocol and path',
    },
    todo_list_id: {
      type: 'string',
      description: 'Can be filled if it is a "todo" resource',
    },
    token: {
      type: 'string',
      description:
        'Get the API token from My info > Show your tokens > Token for feed readers or the Basecamp API in your Basecamp account',
    },
    username: {
      type: 'string',
      description: 'The 37Signals username of the account you use to log in to Basecamp',
    },
  },
  required: ['target_url', 'token', 'project_id', 'resource'],
} as const;

export const TargetCampfireSchema = {
  type: 'object',
  properties: {
    preserve_format: {
      type: 'boolean',
    },
    room: {
      type: 'string',
    },
    ssl: {
      type: 'boolean',
    },
    subdomain: {
      type: 'string',
    },
    token: {
      type: 'string',
    },
  },
  required: ['subdomain', 'room', 'token'],
} as const;

export const TargetClickatellSchema = {
  type: 'object',
  properties: {
    api_id: {
      type: 'string',
    },
    attribute: {
      type: 'string',
      description: 'Read-only',
    },
    from: {
      type: 'string',
    },
    method: {
      type: 'string',
      description: 'Read-only',
    },
    password: {
      type: 'string',
      description: 'only writable',
    },
    target_url: {
      type: 'string',
      description: 'Read-only',
    },
    to: {
      type: 'string',
    },
    us_small_business_account: {
      type: 'string',
    },
    username: {
      type: 'string',
    },
  },
  required: ['username', 'password', 'api_id', 'to'],
} as const;

export const TargetCommonFieldsSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'Whether or not the target is activated',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the target was created',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when created',
      readOnly: true,
    },
    title: {
      type: 'string',
      description: 'A name for the target',
    },
    type: {
      type: 'string',
      description:
        'A pre-defined target, such as "basecamp_target". See the additional attributes for the type that follow',
    },
  },
  required: ['title', 'type'],
} as const;

export const TargetEmailSchema = {
  type: 'object',
  properties: {
    email: {
      type: 'string',
    },
    subject: {
      type: 'string',
    },
  },
  required: ['email', 'subject'],
} as const;

export const TargetFailureObjectSchema = {
  type: 'object',
  properties: {
    consecutive_failure_count: {
      type: 'integer',
      description: 'Number of times the target failed consecutively',
      readOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'Time of the failure',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'The ID of the target failure',
      readOnly: true,
    },
    raw_request: {
      type: 'string',
      description: 'The raw message of the target request',
      readOnly: true,
    },
    raw_response: {
      type: 'string',
      description: 'The raw response of the failure',
      readOnly: true,
    },
    status_code: {
      type: 'integer',
      description: 'HTTP status code of the target failure',
      readOnly: true,
    },
    target_name: {
      type: 'string',
      description: 'Name of the target failure',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of the failure record',
      readOnly: true,
    },
  },
  example: {
    consecutive_failure_count: 1,
    created_at: '2017-09-05T10:38:52Z',
    id: 6001326,
    raw_request: `GET /api/v2/tickets.json HTTP/1.1
User-Agent: Zendesk Target
 ...`,
    raw_response: `HTTP/1.1 401 Unauthorized
Server: nginx
 ...`,
    status_code: 401,
    target_name: 'My URL Target',
    url: 'https://example.zendesk.com/api/v2/target_failures/6001326.json',
  },
} as const;

export const TargetFailureResponseSchema = {
  type: 'object',
  properties: {
    target_failure: {
      $ref: '#/components/schemas/TargetFailureObject',
    },
  },
} as const;

export const TargetFailuresResponseSchema = {
  type: 'object',
  properties: {
    target_failures: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TargetFailureObject',
      },
    },
  },
} as const;

export const TargetFlowdockSchema = {
  type: 'object',
  properties: {
    api_token: {
      type: 'string',
    },
  },
  required: ['api_token'],
} as const;

export const TargetGetSatisfactionSchema = {
  type: 'object',
  properties: {
    account_name: {
      type: 'string',
    },
    email: {
      type: 'string',
    },
    password: {
      type: 'string',
      description: 'only writable',
    },
    target_url: {
      type: 'string',
    },
  },
  required: ['email', 'password', 'account_name'],
} as const;

export const TargetHTTPSchema = {
  type: 'object',
  properties: {
    content_type: {
      type: 'string',
      description: '"application/json", "application/xml", or "application/x-www-form-urlencoded"',
    },
    method: {
      type: 'string',
      description: '"get", "patch", "put", "post", or "delete"',
    },
    password: {
      type: 'string',
      description: 'only writable',
    },
    target_url: {
      type: 'string',
    },
    username: {
      type: 'string',
    },
  },
  required: ['target_url', 'method', 'content_type'],
} as const;

export const TargetJiraSchema = {
  type: 'object',
  properties: {
    password: {
      type: 'string',
      description: 'only writable',
    },
    target_url: {
      type: 'string',
    },
    username: {
      type: 'string',
    },
  },
  required: ['target_url', 'username', 'password'],
} as const;

export const TargetObjectSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/TargetCommonFields',
    },
    {
      anyOf: [
        {
          $ref: '#/components/schemas/TargetBasecamp',
        },
        {
          $ref: '#/components/schemas/TargetCampfire',
        },
        {
          $ref: '#/components/schemas/TargetClickatell',
        },
        {
          $ref: '#/components/schemas/TargetEmail',
        },
        {
          $ref: '#/components/schemas/TargetFlowdock',
        },
        {
          $ref: '#/components/schemas/TargetGetSatisfaction',
        },
        {
          $ref: '#/components/schemas/TargetJira',
        },
        {
          $ref: '#/components/schemas/TargetPivotal',
        },
        {
          $ref: '#/components/schemas/TargetTwitter',
        },
        {
          $ref: '#/components/schemas/TargetURL',
        },
        {
          $ref: '#/components/schemas/TargetHTTP',
        },
        {
          $ref: '#/components/schemas/TargetYammer',
        },
      ],
    },
  ],
  additionalProperties: true,
  example: {
    active: false,
    created_at: '2012-02-20T22:55:29Z',
    id: 88335,
    title: 'basecamp target',
    type: 'basecamp_target',
    url: 'https://company.zendesk.com/api/v2/targets/88335.json',
  },
} as const;

export const TargetPivotalSchema = {
  type: 'object',
  properties: {
    owner_by: {
      type: 'string',
    },
    project_id: {
      type: 'string',
    },
    requested_by: {
      type: 'string',
    },
    story_labels: {
      type: 'string',
    },
    story_title: {
      type: 'string',
    },
    story_type: {
      type: 'string',
    },
    token: {
      type: 'string',
    },
  },
  required: ['token', 'project_id', 'story_type', 'story_title'],
} as const;

export const TargetResponseSchema = {
  type: 'object',
  properties: {
    target: {
      $ref: '#/components/schemas/TargetObject',
    },
  },
} as const;

export const TargetTwitterSchema = {
  type: 'object',
  properties: {
    secret: {
      type: 'string',
      description: 'only writable',
    },
    token: {
      type: 'string',
    },
  },
} as const;

export const TargetURLSchema = {
  type: 'object',
  properties: {
    attribute: {
      type: 'string',
    },
    method: {
      type: 'string',
      description: '"get"',
    },
    password: {
      type: 'string',
      description: 'only writable',
    },
    target_url: {
      type: 'string',
    },
    username: {
      type: 'string',
    },
  },
  required: ['target_url', 'attribute'],
} as const;

export const TargetYammerSchema = {
  type: 'object',
  properties: {
    group_id: {
      type: 'string',
    },
    token: {
      type: 'string',
    },
  },
} as const;

export const TargetsResponseSchema = {
  type: 'object',
  properties: {
    targets: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TargetObject',
      },
    },
  },
} as const;

export const TicketAuditObjectSchema = {
  type: 'object',
  properties: {
    author_id: {
      type: 'integer',
      description: 'The user who created the audit',
      readOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the audit was created',
      readOnly: true,
    },
    events: {
      type: 'array',
      description:
        'An array of the events that happened in this audit. See the [Ticket Audit events reference](/documentation/ticketing/reference-guides/ticket-audit-events-reference)',
      items: {
        type: 'object',
        additionalProperties: true,
      },
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when creating audits',
      readOnly: true,
    },
    metadata: {
      type: 'object',
      description: 'Metadata for the audit, custom and system data',
      additionalProperties: true,
      readOnly: true,
    },
    ticket_id: {
      type: 'integer',
      description: 'The ID of the associated ticket',
      readOnly: true,
    },
    via: {
      $ref: '#/components/schemas/TicketAuditViaObject',
    },
  },
  example: {
    author_id: 35436,
    created_at: '2009-07-20T22:55:29Z',
    events: [
      {
        attachments: [],
        body: 'Thanks for your help!',
        id: 1564245,
        public: true,
        type: 'Comment',
      },
      {
        body: 'Ticket #47 has been updated',
        id: 1564246,
        subject: 'Your ticket has been updated',
        type: 'Notification',
      },
    ],
    id: 35436,
    metadata: {
      custom: {
        time_spent: '3m22s',
      },
      system: {
        ip_address: '184.106.40.75',
      },
    },
    ticket_id: 47,
    via: {
      channel: 'web',
    },
  },
} as const;

export const TicketAuditResponseSchema = {
  type: 'object',
  properties: {
    audit: {
      $ref: '#/components/schemas/TicketAuditObject',
    },
  },
} as const;

export const TicketAuditViaObjectSchema = {
  type: 'object',
  description:
    'Describes how the object was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)',
  properties: {
    channel: {
      type: 'string',
      description: 'This tells you how the ticket or event was created. Examples: "web", "mobile", "rule", "system"',
      readOnly: true,
    },
    source: {
      type: 'object',
      description:
        'For some channels a source object gives more information about how or why the ticket or event was created',
      additionalProperties: true,
      readOnly: true,
    },
  },
} as const;

export const TicketAuditsCountResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'object',
      properties: {
        refreshed_at: {
          type: 'string',
          format: 'date-time',
        },
        value: {
          type: 'integer',
        },
      },
    },
  },
} as const;

export const TicketAuditsResponseSchema = {
  type: 'object',
  properties: {
    after_cursor: {
      type: 'string',
      readOnly: true,
    },
    after_url: {
      type: 'string',
      readOnly: true,
    },
    audits: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketAuditObject',
      },
    },
    before_cursor: {
      type: 'string',
      readOnly: true,
    },
    before_url: {
      type: 'string',
      readOnly: true,
    },
  },
} as const;

export const TicketAuditsResponseNoneCursorSchema = {
  type: 'object',
  properties: {
    audits: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketAuditObject',
      },
    },
    count: {
      type: 'integer',
      readOnly: true,
    },
    next_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
  },
} as const;

export const TicketBulkImportRequestSchema = {
  type: 'object',
  properties: {
    tickets: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketImportInput',
      },
    },
  },
} as const;

export const TicketChatCommentRedactionResponseSchema = {
  type: 'object',
  properties: {
    chat_event: {
      type: 'object',
      description: 'Chat event object',
      properties: {
        id: {
          type: 'integer',
          description: 'Id assigned to the chat event object',
          readOnly: true,
        },
        type: {
          type: 'string',
          description: 'Type of chat event',
          readOnly: true,
        },
        value: {
          type: 'object',
          description: 'The value of the chat event object',
          properties: {
            chat_id: {
              type: 'string',
              description: 'Id of the chat session',
              readOnly: true,
            },
            history: {
              type: 'array',
              description: 'Chat events within the chat session',
              items: {
                type: 'object',
                additionalProperties: true,
              },
            },
            visitor_id: {
              type: 'string',
              description: 'Id assigned to the visitor',
              readOnly: true,
            },
          },
          readOnly: true,
        },
      },
      readOnly: true,
    },
  },
  example: {
    chat_event: {
      id: 1932802680168,
      type: 'ChatStartedEvent',
      value: {
        chat_id: '2109.10502823.Sjuj2YrBpXwei',
        history: [
          {
            actor_id: 1900448983828,
            actor_name: 'Visitor 36044085',
            actor_type: 'end-user',
            chat_index: 0,
            timestamp: 1632470783218,
            type: 'ChatJoin',
          },
        ],
        visitor_id: '10502823-16EkM3T6VNq7KMd',
      },
    },
  },
} as const;

export const TicketCommentObjectSchema = {
  type: 'object',
  properties: {
    attachments: {
      type: 'array',
      description: 'Attachments, if any. See [Attachment](/api-reference/ticketing/tickets/ticket-attachments/)',
      items: {
        $ref: '#/components/schemas/AttachmentObject',
      },
      readOnly: true,
    },
    audit_id: {
      type: 'integer',
      description:
        'The id of the ticket audit record. See [Show Audit](/api-reference/ticketing/tickets/ticket_audits/#show-audit)',
      readOnly: true,
    },
    author_id: {
      type: 'integer',
      description: 'The id of the comment author. See [Author id](#author-id)',
    },
    body: {
      type: 'string',
      description: 'The comment string. See [Bodies](#bodies)',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the comment was created',
      readOnly: true,
    },
    html_body: {
      type: 'string',
      description: 'The comment formatted as HTML. See [Bodies](#bodies)',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when the comment is created',
      readOnly: true,
    },
    metadata: {
      type: 'object',
      description:
        'System information (web client, IP address, etc.) and comment flags, if any. See [Comment flags](#comment-flags)',
      additionalProperties: true,
      readOnly: true,
    },
    plain_body: {
      type: 'string',
      description: 'The comment presented as plain text. See [Bodies](#bodies)',
      readOnly: true,
    },
    public: {
      type: 'boolean',
      description:
        'true if a public comment; false if an internal note. The initial value set on ticket creation persists for any additional comment unless you change it',
    },
    type: {
      type: 'string',
      description: `\`Comment\` or \`VoiceComment\`. The JSON object for adding voice comments to tickets is different. See [Adding voice comments to tickets](/documentation/ticketing/managing-tickets/adding-voice-comments-to-tickets)`,
      readOnly: true,
    },
    uploads: {
      type: 'array',
      description:
        'List of tokens received from [uploading files](/api-reference/ticketing/tickets/ticket-attachments/#upload-files) for comment attachments. The files are attached by creating or updating tickets with the tokens. See [Attaching files](/api-reference/ticketing/tickets/tickets/#attaching-files) in Tickets',
      items: {
        type: 'string',
      },
    },
    via: {
      $ref: '#/components/schemas/TicketAuditViaObject',
    },
  },
  example: {
    attachments: [
      {
        content_type: 'text/plain',
        content_url: 'https://company.zendesk.com/attachments/crash.log',
        file_name: 'crash.log',
        id: 498483,
        size: 2532,
        thumbnails: [],
      },
    ],
    author_id: 123123,
    body: 'Thanks for your help!',
    created_at: '2009-07-20T22:55:29Z',
    id: 1274,
    metadata: {
      system: {
        client:
          'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36',
        ip_address: '1.1.1.1',
        latitude: -37.000000000001,
        location: 'Melbourne, 07, Australia',
        longitude: 144.0000000000002,
      },
      via: {
        channel: 'web',
        source: {
          from: {},
          rel: 'web_widget',
          to: {},
        },
      },
    },
    public: true,
    type: 'Comment',
  },
} as const;

export const TicketCommentResponseSchema = {
  type: 'object',
  properties: {
    comment: {
      $ref: '#/components/schemas/TicketCommentObject',
    },
  },
} as const;

export const TicketCommentsCountResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'object',
      properties: {
        refreshed_at: {
          type: 'string',
          format: 'date-time',
        },
        value: {
          type: 'integer',
        },
      },
    },
  },
} as const;

export const TicketCommentsResponseSchema = {
  type: 'object',
  properties: {
    comments: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketCommentObject',
      },
    },
  },
} as const;

export const TicketCreateInputSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/TicketUpdateInput',
    },
    {
      type: 'object',
      properties: {
        brand_id: {
          type: 'integer',
          description: 'Enterprise only. The id of the brand this ticket is associated with',
        },
        collaborators: {
          type: 'array',
          description:
            "POST requests only. Users to add as cc's when creating a ticket. See [Setting Collaborators](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-collaborators)",
          items: {
            $ref: '#/components/schemas/CollaboratorObject',
          },
        },
        email_cc_ids: {
          type: 'array',
          description:
            "The ids of agents or end users currently CC'ed on the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233) in the Support Help Center",
          items: {
            type: 'integer',
          },
        },
        follower_ids: {
          type: 'array',
          description:
            'The ids of agents currently following the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233)',
          items: {
            type: 'integer',
          },
        },
        macro_ids: {
          type: 'array',
          description: 'POST requests only. List of macro IDs to be recorded in the ticket audit',
          items: {
            type: 'integer',
          },
        },
        raw_subject: {
          type: 'string',
          description: `The dynamic content placeholder, if present, or the "subject" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
`,
        },
        recipient: {
          type: 'string',
          description: 'The original recipient e-mail address of the ticket',
        },
        submitter_id: {
          type: 'integer',
          description:
            'The user who submitted the ticket. The submitter always becomes the author of the first comment on the ticket',
        },
        ticket_form_id: {
          type: 'integer',
          description: 'Enterprise only. The id of the ticket form to render for the ticket',
        },
        via: {
          $ref: '#/components/schemas/ViaObject',
        },
        via_followup_source_id: {
          type: 'integer',
          description:
            'POST requests only. The id of a closed ticket when creating a follow-up ticket. See [Creating a follow-up ticket](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#creating-a-follow-up-ticket)',
        },
      },
      required: ['comment'],
    },
  ],
  example: {
    comment: {
      body: 'The smoke is very colorful.',
    },
    priority: 'urgent',
    subject: 'My printer is on fire!',
  },
} as const;

export const TicketCreateRequestSchema = {
  type: 'object',
  properties: {
    ticket: {
      $ref: '#/components/schemas/TicketCreateInput',
    },
  },
} as const;

export const TicketCreateVoicemailTicketInputSchema = {
  type: 'object',
  properties: {
    comment: {
      $ref: '#/components/schemas/TicketCommentObject',
    },
    priority: {
      type: 'string',
      description: 'The urgency with which the ticket should be addressed.',
      enum: ['urgent', 'high', 'normal', 'low'],
    },
    via_id: {
      type: 'integer',
      description: 'Required for Create Ticket operation',
      enum: [44, 45, 46],
    },
    voice_comment: {
      type: 'object',
      description: 'Required if creating voicemail ticket',
      allOf: [
        {
          $ref: '#/components/schemas/TicketCreateVoicemailTicketVoiceCommentInput',
        },
      ],
    },
  },
} as const;

export const TicketCreateVoicemailTicketRequestSchema = {
  type: 'object',
  properties: {
    display_to_agent: {
      type: 'integer',
      description: 'Optional value such as the ID of the agent that will see the newly created ticket.',
    },
    ticket: {
      type: 'object',
      description: 'Ticket object that lists the values to set when the ticket is created',
      allOf: [
        {
          $ref: '#/components/schemas/TicketCreateVoicemailTicketInput',
        },
      ],
    },
  },
} as const;

export const TicketCreateVoicemailTicketVoiceCommentInputSchema = {
  type: 'object',
  properties: {
    answered_by_id: {
      type: 'integer',
      description: 'The agent who answered the call',
    },
    call_duration: {
      type: 'integer',
      description: 'Duration in seconds of the call',
    },
    from: {
      type: 'string',
      description: 'Incoming phone number',
    },
    location: {
      type: 'string',
      description: 'Location of the caller (optional)',
    },
    recording_url: {
      type: 'string',
      description: 'Incoming phone number',
    },
    started_at: {
      type: 'string',
      format: 'date-time',
      description: '[ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp of the call starting time',
    },
    to: {
      type: 'string',
      description: 'Dialed phone number',
    },
    transcription_text: {
      type: 'string',
      description: 'Transcription of the call (optional)',
    },
  },
} as const;

export const TicketFieldCountResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'object',
      properties: {
        refreshed_at: {
          type: 'string',
          format: 'date-time',
        },
        value: {
          type: 'integer',
        },
      },
    },
  },
} as const;

export const TicketFieldCustomStatusObjectSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'If true, if the custom status is set to active. If false, the custom status is set to inactive',
    },
    agent_label: {
      type: 'string',
      description: 'The label displayed to agents',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The date and time at which the custom ticket status was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: 'If true, the custom status is set to default. If false, the custom status is set to non-default',
    },
    description: {
      type: 'string',
      description: 'The description of when the user should select this custom ticket status',
    },
    end_user_description: {
      type: 'string',
      description: 'The description displayed to end users',
    },
    end_user_label: {
      type: 'string',
      description: 'The label displayed to end users',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when the custom ticket status is created',
      readOnly: true,
    },
    status_category: {
      type: 'string',
      description: 'The status category the custom ticket status belongs to',
      enum: ['new', 'open', 'pending', 'hold', 'solved'],
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The date and time at which the custom ticket status was last updated',
      readOnly: true,
    },
  },
} as const;

export const TicketFieldObjectSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'Whether this field is available',
    },
    agent_description: {
      type: 'string',
      description: 'A description of the ticket field that only agents can see',
    },
    collapsed_for_agents: {
      type: 'boolean',
      description:
        'If true, the field is shown to agents by default. If false, the field is hidden alongside infrequently used fields. Classic interface only',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the custom ticket field was created',
      readOnly: true,
    },
    creator_app_name: {
      type: 'string',
      description: 'Name of the app that created the ticket field, or a null value if no app created the ticket field',
    },
    creator_user_id: {
      type: 'integer',
      description:
        'The id of the user that created the ticket field, or a value of "-1" if an app created the ticket field',
    },
    custom_field_options: {
      type: 'array',
      description: 'Required and presented for a custom ticket field of type "multiselect" or "tagger"',
      items: {
        $ref: '#/components/schemas/CustomFieldOptionObject',
      },
    },
    custom_statuses: {
      type: 'array',
      description:
        'List of customized ticket statuses. Only presented for a system ticket field of type "custom_status"',
      items: {
        $ref: '#/components/schemas/TicketFieldCustomStatusObject',
      },
      readOnly: true,
    },
    description: {
      type: 'string',
      description: 'Describes the purpose of the ticket field to users',
    },
    editable_in_portal: {
      type: 'boolean',
      description: 'Whether this field is editable by end users in Help Center',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when created',
      readOnly: true,
    },
    position: {
      type: 'integer',
      description:
        'The relative position of the ticket field on a ticket. Note that for accounts with ticket forms, positions are controlled by the different forms',
    },
    raw_description: {
      type: 'string',
      description:
        'The dynamic content placeholder if present, or the `description` value if not. See [Dynamic Content](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    raw_title: {
      type: 'string',
      description:
        'The dynamic content placeholder if present, or the `title` value if not. See [Dynamic Content](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    raw_title_in_portal: {
      type: 'string',
      description:
        'The dynamic content placeholder if present, or the "title_in_portal" value if not. See [Dynamic Content](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    regexp_for_validation: {
      type: 'string',
      description: 'For "regexp" fields only. The validation pattern for a field value to be deemed valid',
      nullable: true,
    },
    relationship_filter: {
      type: 'object',
      description: 'A filter definition that allows your autocomplete to filter down results',
    },
    relationship_target_type: {
      type: 'string',
      description:
        'A representation of what type of object the field references. Options are "zen:user", "zen:organization", "zen:ticket", or "zen:custom_object:{key}" where key is a custom object key. For example "zen:custom_object:apartment".',
    },
    removable: {
      type: 'boolean',
      description: 'If false, this field is a system field that must be present on all tickets',
      readOnly: true,
    },
    required: {
      type: 'boolean',
      description: 'If true, agents must enter a value in the field to change the ticket status to solved',
    },
    required_in_portal: {
      type: 'boolean',
      description: 'If true, end users must enter a value in the field to create the request',
    },
    sub_type_id: {
      type: 'integer',
      description:
        'For system ticket fields of type "priority" and "status". Defaults to 0. A "priority" sub type of 1 removes the "Low" and "Urgent" options. A "status" sub type of 1 adds the "On-Hold" option',
    },
    system_field_options: {
      type: 'array',
      description: 'Presented for a system ticket field of type "tickettype", "priority" or "status"',
      items: {
        $ref: '#/components/schemas/SystemFieldOptionObject',
      },
      readOnly: true,
    },
    tag: {
      type: 'string',
      description: 'For "checkbox" fields only. A tag added to tickets when the checkbox field is selected',
      nullable: true,
    },
    title: {
      type: 'string',
      description: 'The title of the ticket field',
    },
    title_in_portal: {
      type: 'string',
      description: 'The title of the ticket field for end users in Help Center',
    },
    type: {
      type: 'string',
      description:
        'System or custom field type. Editable for custom field types and only on creation. See [Create Ticket Field](#create-ticket-field)',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the custom ticket field was last updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The URL for this resource',
      readOnly: true,
    },
    visible_in_portal: {
      type: 'boolean',
      description: 'Whether this field is visible to end users in Help Center',
    },
  },
  example: {
    active: true,
    agent_description: 'This is the agent only description for the subject field',
    collapsed_for_agents: false,
    created_at: '2009-07-20T22:55:29Z',
    description: 'This is the subject field of a ticket',
    editable_in_portal: true,
    id: 34,
    position: 21,
    raw_description: 'This is the subject field of a ticket',
    raw_title: '{{dc.my_title}}',
    raw_title_in_portal: '{{dc.my_title_in_portal}}',
    regexp_for_validation: null,
    removable: false,
    required: true,
    required_in_portal: true,
    tag: null,
    title: 'Subject',
    title_in_portal: 'Subject',
    type: 'subject',
    updated_at: '2011-05-05T10:38:52Z',
    url: 'https://company.zendesk.com/api/v2/ticket_fields/34.json',
    visible_in_portal: true,
  },
  required: ['type', 'title'],
} as const;

export const TicketFieldResponseSchema = {
  type: 'object',
  properties: {
    ticket_field: {
      $ref: '#/components/schemas/TicketFieldObject',
    },
  },
} as const;

export const TicketFieldsResponseSchema = {
  type: 'object',
  properties: {
    ticket_fields: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketFieldObject',
      },
    },
  },
} as const;

export const TicketFormObjectSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'If the form is set as active',
    },
    agent_conditions: {
      type: 'array',
      description: 'Array of condition sets for agent workspaces',
      items: {
        type: 'object',
        additionalProperties: true,
      },
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the ticket form was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: 'Is the form the default form for this account',
    },
    display_name: {
      type: 'string',
      description: 'The name of the form that is displayed to an end user',
    },
    end_user_conditions: {
      type: 'array',
      description: 'Array of condition sets for end user products',
      items: {
        type: 'object',
        additionalProperties: true,
      },
    },
    end_user_visible: {
      type: 'boolean',
      description: 'Is the form visible to the end user',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when creating ticket form',
      readOnly: true,
    },
    in_all_brands: {
      type: 'boolean',
      description: 'Is the form available for use in all brands on this account',
    },
    name: {
      type: 'string',
      description: 'The name of the form',
    },
    position: {
      type: 'integer',
      description: 'The position of this form among other forms in the account, i.e. dropdown',
    },
    raw_display_name: {
      type: 'string',
      description:
        'The dynamic content placeholder, if present, or the "display_name" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    raw_name: {
      type: 'string',
      description:
        'The dynamic content placeholder, if present, or the "name" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)',
    },
    restricted_brand_ids: {
      type: 'array',
      description: 'ids of all brands that this ticket form is restricted to',
      items: {
        type: 'integer',
      },
      readOnly: true,
    },
    ticket_field_ids: {
      type: 'array',
      description:
        'ids of all ticket fields which are in this ticket form. The products use the order of the ids to show the field values in the tickets',
      items: {
        type: 'integer',
      },
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the ticket form',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'URL of the ticket form',
      readOnly: true,
    },
  },
  example: {
    active: true,
    agent_conditions: [
      {
        child_fields: [
          {
            id: 101,
            is_required: false,
            required_on_statuses: {
              statuses: ['new', 'open', 'pending', 'hold'],
              type: 'SOME_STATUSES',
            },
          },
          {
            id: 200,
            is_required: true,
            required_on_statuses: {
              statuses: ['solved'],
              type: 'SOME_STATUSES',
            },
          },
        ],
        parent_field_id: 100,
        value: 'matching_value',
      },
      {
        child_fields: [
          {
            id: 102,
            is_required: true,
            required_on_statuses: {
              type: 'ALL_STATUSES',
            },
          },
          {
            id: 200,
            is_required: false,
            required_on_statuses: {
              type: 'NO_STATUSES',
            },
          },
        ],
        parent_field_id: 101,
        value: 'matching_value_2',
      },
    ],
    created_at: '2012-04-02T22:55:29Z',
    default: true,
    display_name: 'Snowboard Damage',
    end_user_conditions: [
      {
        child_fields: [
          {
            id: 101,
            is_required: true,
          },
        ],
        parent_field_id: 100,
        value: 'matching_value',
      },
      {
        child_fields: [
          {
            id: 202,
            is_required: false,
          },
        ],
        parent_field_id: 200,
        value: 'matching_value',
      },
    ],
    end_user_visible: true,
    id: 47,
    in_all_brands: false,
    name: 'Snowboard Problem',
    position: 9999,
    raw_display_name: '{{dc.my_display_name}}',
    raw_name: 'Snowboard Problem',
    restricted_brand_ids: [47, 33, 22],
    ticket_field_ids: [2, 4, 5, 10, 100, 101, 102, 200],
    updated_at: '2012-04-02T22:55:29Z',
    url: 'https://company.zendesk.com/api/v2/ticket_forms/47.json',
  },
  required: ['name'],
} as const;

export const TicketFormResponseSchema = {
  type: 'object',
  properties: {
    ticket_form: {
      $ref: '#/components/schemas/TicketFormObject',
    },
  },
} as const;

export const TicketFormsResponseSchema = {
  type: 'object',
  properties: {
    ticket_forms: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketFormObject',
      },
    },
  },
} as const;

export const TicketImportInputSchema = {
  type: 'object',
  properties: {
    assignee_id: {
      type: 'integer',
      description: 'The agent currently assigned to the ticket',
    },
    comments: {
      type: 'array',
      description: 'The conversation between requesters, collaborators, and agents',
      items: {
        allOf: [
          {
            type: 'object',
            properties: {
              value: {
                type: 'string',
                description: 'The comment string value',
              },
            },
          },
          {
            $ref: '#/components/schemas/TicketCommentObject',
          },
        ],
      },
      additionalProperties: true,
    },
    description: {
      type: 'string',
      description:
        'Read-only first comment on the ticket. When [creating a ticket](#create-ticket), use `comment` to set the description. See [Description and first comment](#description-and-first-comment)',
    },
    requester_id: {
      type: 'integer',
      description: 'The user who requested this ticket',
    },
    subject: {
      type: 'string',
      description: 'The value of the subject field for this ticket',
    },
    tags: {
      type: 'array',
      description: 'The array of tags applied to this ticket',
      items: {
        type: 'string',
      },
    },
  },
} as const;

export const TicketImportRequestSchema = {
  type: 'object',
  properties: {
    ticket: {
      $ref: '#/components/schemas/TicketImportInput',
    },
  },
} as const;

export const TicketMergeInputSchema = {
  type: 'object',
  properties: {
    ids: {
      type: 'array',
      description: 'Ids of tickets to merge into the target ticket',
      items: {
        type: 'integer',
      },
    },
    source_comment: {
      type: 'string',
      description: 'Private comment to add to the source ticket',
    },
    source_comment_is_public: {
      type: 'boolean',
      description: 'Whether comment in source tickets are public or private',
    },
    target_comment: {
      type: 'string',
      description: 'Private comment to add to the target ticket',
    },
    target_comment_is_public: {
      type: 'boolean',
      description: 'Whether comment in target ticket is public or private',
    },
  },
  required: ['ids'],
} as const;

export const TicketMetricEventBaseObjectSchema = {
  title: 'Ticket Metric Events',
  type: 'object',
  properties: {
    id: {
      type: 'integer',
      description: 'Automatically assigned when the record is created',
      readOnly: true,
    },
    instance_id: {
      type: 'integer',
      description: 'The instance of the metric associated with the event. See [instance_id](#instance_id)',
      readOnly: true,
    },
    metric: {
      type: 'string',
      description: 'The metric being tracked',
      enum: [
        'agent_work_time',
        'pausable_update_time',
        'periodic_update_time',
        'reply_time',
        'requester_wait_time',
        'resolution_time',
        'group_ownership_time',
      ],
      readOnly: true,
    },
    ticket_id: {
      type: 'integer',
      description: 'Id of the associated ticket',
      readOnly: true,
    },
    time: {
      type: 'string',
      format: 'date-time',
      description: 'The time the event occurred',
      readOnly: true,
    },
    type: {
      type: 'string',
      description:
        'The type of the metric event. See [Ticket metric event types reference](/documentation/ticketing/reference-guides/ticket-metric-event-types-reference)',
      enum: ['activate', 'pause', 'fulfill', 'apply_sla', 'apply_group_sla', 'breach', 'update_status', 'measure'],
      readOnly: true,
    },
  },
  example: {
    id: 926256957613,
    instance_id: 1,
    metric: 'agent_work_time',
    ticket_id: 155,
    time: '2020-10-26T12:53:12Z',
    type: 'measure',
  },
} as const;

export const TicketMetricEventBreachObjectSchema = {
  title: 'Ticket Metric Event',
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/TicketMetricEventBaseObject',
    },
    {
      type: 'object',
      properties: {
        deleted: {
          type: 'boolean',
          description:
            'Available if `type` is `breach`. In general, you can ignore any breach event when `deleted` is true. See [deleted](#deleted)',
          readOnly: true,
        },
      },
    },
  ],
} as const;

export const TicketMetricEventGroupSLAObjectSchema = {
  title: 'Ticket Metric Event',
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/TicketMetricEventBaseObject',
    },
    {
      type: 'object',
      properties: {
        group_sla: {
          type: 'object',
          description:
            'Available if `type` is "apply_group_sla". The Group SLA policy and target being enforced on the ticket and metric in question, if any. See [group_sla](#group_sla)',
          readOnly: true,
        },
      },
    },
  ],
} as const;

export const TicketMetricEventSLAObjectSchema = {
  title: 'Ticket Metric Event',
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/TicketMetricEventBaseObject',
    },
    {
      type: 'object',
      properties: {
        sla: {
          type: 'object',
          description:
            'Available if `type` is `apply_sla`. The SLA policy and target being enforced on the ticket and metric in question, if any. See [sla](#sla)',
          readOnly: true,
        },
      },
    },
  ],
} as const;

export const TicketMetricEventUpdateStatusObjectSchema = {
  title: 'Ticket Metric Event',
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/TicketMetricEventBaseObject',
    },
    {
      type: 'object',
      properties: {
        status: {
          type: 'object',
          description:
            'Available if `type` is `update_status`. Minutes since the metric has been open. See [status](#status)',
          readOnly: true,
        },
      },
    },
  ],
} as const;

export const TicketMetricEventsResponseSchema = {
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        ticket_metric_events: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/TicketMetricEventBaseObject',
          },
        },
      },
    },
    {
      type: 'object',
      properties: {
        count: {
          type: 'integer',
        },
        end_time: {
          type: 'integer',
        },
        next_page: {
          type: 'string',
        },
      },
    },
  ],
} as const;

export const TicketMetricObjectSchema = {
  type: 'object',
  properties: {
    agent_wait_time_in_minutes: {
      type: 'object',
      description: 'Number of minutes the agent spent waiting during calendar and business hours',
      allOf: [
        {
          $ref: '#/components/schemas/TicketMetricTimeObject',
        },
      ],
      readOnly: true,
    },
    assigned_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the ticket was assigned',
      readOnly: true,
    },
    assignee_stations: {
      type: 'integer',
      description: 'Number of assignees the ticket had',
      readOnly: true,
    },
    assignee_updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the assignee last updated the ticket',
      readOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the record was created',
      readOnly: true,
    },
    custom_status_updated_at: {
      type: 'string',
      format: 'date-time',
      description: "The date and time the ticket's custom status was last updated",
      readOnly: true,
    },
    first_resolution_time_in_minutes: {
      type: 'object',
      description: 'Number of minutes to the first resolution time during calendar and business hours',
      allOf: [
        {
          $ref: '#/components/schemas/TicketMetricTimeObject',
        },
      ],
      readOnly: true,
    },
    full_resolution_time_in_minutes: {
      type: 'object',
      description: 'Number of minutes to the full resolution during calendar and business hours',
      allOf: [
        {
          $ref: '#/components/schemas/TicketMetricTimeObject',
        },
      ],
      readOnly: true,
    },
    group_stations: {
      type: 'integer',
      description: 'Number of groups the ticket passed through',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when the client is created',
      readOnly: true,
    },
    initially_assigned_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the ticket was initially assigned',
      readOnly: true,
    },
    latest_comment_added_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the latest comment was added',
      readOnly: true,
    },
    on_hold_time_in_minutes: {
      type: 'object',
      description: 'Number of minutes on hold',
      allOf: [
        {
          $ref: '#/components/schemas/TicketMetricTimeObject',
        },
      ],
      readOnly: true,
    },
    reopens: {
      type: 'integer',
      description: 'Total number of times the ticket was reopened',
      readOnly: true,
    },
    replies: {
      type: 'integer',
      description: 'The number of public replies added to a ticket by an agent',
      readOnly: true,
    },
    reply_time_in_minutes: {
      type: 'object',
      description: 'Number of minutes to the first reply during calendar and business hours',
      allOf: [
        {
          $ref: '#/components/schemas/TicketMetricTimeObject',
        },
      ],
      readOnly: true,
    },
    reply_time_in_seconds: {
      type: 'object',
      description: 'Number of seconds to the first reply during calendar hours, only available for Messaging tickets',
      allOf: [
        {
          $ref: '#/components/schemas/TicketMetricTimeObject',
        },
      ],
      readOnly: true,
    },
    requester_updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the requester last updated the ticket',
      readOnly: true,
    },
    requester_wait_time_in_minutes: {
      type: 'object',
      description: 'Number of minutes the requester spent waiting during calendar and business hours',
      allOf: [
        {
          $ref: '#/components/schemas/TicketMetricTimeObject',
        },
      ],
      readOnly: true,
    },
    solved_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the ticket was solved',
      readOnly: true,
    },
    status_updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the status of the ticket was last updated',
      readOnly: true,
    },
    ticket_id: {
      type: 'integer',
      description: 'Id of the associated ticket',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'When the record was last updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of the ticket metric',
      readOnly: true,
    },
  },
  example: {
    agent_wait_time_in_minutes: {
      business: 737,
      calendar: 2391,
    },
    assigned_at: '2011-05-05T10:38:52Z',
    assignee_stations: 1,
    assignee_updated_at: '2011-05-06T10:38:52Z',
    created_at: '2009-07-20T22:55:29Z',
    custom_status_updated_at: '2011-05-09T10:38:52Z',
    first_resolution_time_in_minutes: {
      business: 737,
      calendar: 2391,
    },
    full_resolution_time_in_minutes: {
      business: 737,
      calendar: 2391,
    },
    group_stations: 7,
    id: 33,
    initially_assigned_at: '2011-05-03T10:38:52Z',
    latest_comment_added_at: '2011-05-09T10:38:52Z',
    on_hold_time_in_minutes: {
      business: 637,
      calendar: 2290,
    },
    reopens: 55,
    replies: 322,
    reply_time_in_minutes: {
      business: 737,
      calendar: 2391,
    },
    reply_time_in_seconds: {
      calendar: 143460,
    },
    requester_updated_at: '2011-05-07T10:38:52Z',
    requester_wait_time_in_minutes: {
      business: 737,
      calendar: 2391,
    },
    solved_at: '2011-05-09T10:38:52Z',
    status_updated_at: '2011-05-04T10:38:52Z',
    ticket_id: 4343,
    updated_at: '2011-05-05T10:38:52Z',
  },
} as const;

export const TicketMetricTimeObjectSchema = {
  type: 'object',
  properties: {
    business: {
      type: 'integer',
      description: 'Time in business hours',
      readOnly: true,
    },
    calendar: {
      type: 'integer',
      description: 'Time in calendar hours',
      readOnly: true,
    },
  },
} as const;

export const TicketMetricsByTicketMetricIdResponseSchema = {
  type: 'object',
  properties: {
    ticket_metric: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketMetricObject',
      },
    },
  },
} as const;

export const TicketMetricsResponseSchema = {
  type: 'object',
  properties: {
    ticket_metrics: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketMetricObject',
      },
    },
  },
} as const;

export const TicketObjectSchema = {
  type: 'object',
  properties: {
    allow_attachments: {
      type: 'boolean',
      description: 'Permission for agents to add add attachments to a comment. Defaults to true',
      readOnly: true,
    },
    allow_channelback: {
      type: 'boolean',
      description: 'Is false if channelback is disabled, true otherwise. Only applicable for channels framework ticket',
      readOnly: true,
    },
    assignee_email: {
      type: 'string',
      description: 'Write only. The email address of the agent to assign the ticket to',
      writeOnly: true,
    },
    assignee_id: {
      type: 'integer',
      description: 'The agent currently assigned to the ticket',
    },
    attribute_value_ids: {
      type: 'array',
      description: 'Write only. An array of the IDs of attribute values to be associated with the ticket',
      items: {
        type: 'integer',
      },
      writeOnly: true,
    },
    brand_id: {
      type: 'integer',
      description:
        'The id of the brand this ticket is associated with. See [Setting up multiple brands](https://support.zendesk.com/hc/en-us/articles/4408829476378)',
    },
    collaborator_ids: {
      type: 'array',
      description: "The ids of users currently CC'ed on the ticket",
      items: {
        type: 'integer',
      },
    },
    collaborators: {
      type: 'array',
      description:
        "POST requests only. Users to add as cc's when creating a ticket. See [Setting Collaborators](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-collaborators)",
      items: {
        $ref: '#/components/schemas/CollaboratorObject',
      },
    },
    comment: {
      type: 'object',
      description:
        'Write only. An object that adds a comment to the ticket. See [Ticket comments](/api-reference/ticketing/tickets/ticket_comments/). To include an attachment with the comment, see [Attaching files](/documentation/ticketing/managing-tickets/creating-and-updating-tickets/#attaching-files). A ticket can contain up to 5000 comments in total, including both public and private comments. Once this limit is reached, any additional attempts to add comments results in a 422 error. The ticket can still be updated in other ways, provided that no new comments are added.',
      writeOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'When this record was created',
      readOnly: true,
    },
    custom_fields: {
      type: 'array',
      description:
        'Custom fields for the ticket. See [Setting custom field values](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-custom-field-values)',
      items: {
        type: 'object',
        properties: {
          id: {
            type: 'integer',
            description: 'The id of the custom field',
          },
          value: {
            type: 'string',
            description: 'The value of the custom field',
          },
        },
      },
    },
    custom_status_id: {
      type: 'integer',
      description: 'The custom ticket status id of the ticket. See [custom ticket statuses](#custom-ticket-statuses)',
    },
    description: {
      type: 'string',
      description: `Read-only first comment on the ticket. When [creating a ticket](#create-ticket), use \`comment\` to set the description. See [Description and first comment](#description-and-first-comment)
`,
      readOnly: true,
    },
    due_at: {
      type: 'string',
      format: 'date-time',
      description:
        'If this is a ticket of type "task" it has a due date.  Due date format uses [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format',
      nullable: true,
    },
    email_cc_ids: {
      type: 'array',
      description:
        "The ids of agents or end users currently CC'ed on the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233) in the Support Help Center",
      items: {
        type: 'integer',
      },
    },
    email_ccs: {
      type: 'object',
      description:
        'Write only. An array of objects that represent agent or end users email CCs to add or delete from the ticket. See [Setting email CCs](/documentation/ticketing/managing-tickets/creating-and-updating-tickets/#setting-email-ccs)',
      writeOnly: true,
    },
    external_id: {
      type: 'string',
      description: 'An id you can use to link Zendesk Support tickets to local records',
    },
    follower_ids: {
      type: 'array',
      description:
        'The ids of agents currently following the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233)',
      items: {
        type: 'integer',
      },
    },
    followers: {
      type: 'object',
      description:
        'Write only. An array of objects that represent agent followers to add or delete from the ticket. See [Setting followers](/documentation/ticketing/managing-tickets/creating-and-updating-tickets/#setting-followers)',
      writeOnly: true,
    },
    followup_ids: {
      type: 'array',
      description: 'The ids of the followups created from this ticket. Ids are only visible once the ticket is closed',
      items: {
        type: 'integer',
      },
      readOnly: true,
    },
    forum_topic_id: {
      type: 'integer',
      description:
        'The topic in the Zendesk Web portal this ticket originated from, if any. The Web portal is deprecated',
      readOnly: true,
    },
    from_messaging_channel: {
      type: 'boolean',
      description:
        "If true, the ticket's [via type](/documentation/ticketing/reference-guides/via-object-reference/) is a messaging channel.",
      readOnly: true,
    },
    generated_timestamp: {
      type: 'integer',
      description:
        'A Unix timestamp that represents the most accurate reading of when this record was last updated. It is updated for all ticket updates, including system updates',
      readOnly: true,
    },
    group_id: {
      type: 'integer',
      description: 'The group this ticket is assigned to',
    },
    has_incidents: {
      type: 'boolean',
      description:
        'Is true if a ticket is a problem type and has one or more incidents linked to it. Otherwise, the value is false.',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when the ticket is created',
      readOnly: true,
    },
    is_public: {
      type: 'boolean',
      description: 'Is true if any comments are public, false otherwise',
      readOnly: true,
    },
    macro_id: {
      type: 'integer',
      description: 'Write only. A macro ID to be recorded in the ticket audit',
      writeOnly: true,
    },
    macro_ids: {
      type: 'array',
      description: 'POST requests only. List of macro IDs to be recorded in the ticket audit',
      items: {
        type: 'integer',
      },
    },
    metadata: {
      type: 'object',
      description:
        'Write only. Metadata for the audit. In the `audit` object, the data is specified in the `custom` property of the `metadata` object. See [Setting Metadata](/documentation/ticketing/managing-tickets/creating-and-updating-tickets/#setting-metadata)',
      writeOnly: true,
    },
    organization_id: {
      type: 'integer',
      description:
        'The organization of the requester. You can only specify the ID of an organization associated with the requester. See [Organization Memberships](/api-reference/ticketing/organizations/organization_memberships/)',
    },
    priority: {
      type: 'string',
      description: 'The urgency with which the ticket should be addressed',
      enum: ['urgent', 'high', 'normal', 'low'],
    },
    problem_id: {
      type: 'integer',
      description: 'For tickets of type "incident", the ID of the problem the incident is linked to',
    },
    raw_subject: {
      type: 'string',
      description: `The dynamic content placeholder, if present, or the "subject" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)
`,
    },
    recipient: {
      type: 'string',
      description:
        'The original recipient e-mail address of the ticket. Notification emails for the ticket are sent from this address',
    },
    requester: {
      type: 'object',
      description:
        'Write only. See [Creating a ticket with a new requester](/documentation/ticketing/managing-tickets/creating-and-updating-tickets/#creating-a-ticket-with-a-new-requester)',
      writeOnly: true,
    },
    requester_id: {
      type: 'integer',
      description: 'The user who requested this ticket',
    },
    safe_update: {
      type: 'boolean',
      description:
        'Write only. Optional boolean. When true and an `update_stamp` date is included, protects against ticket update collisions and returns a message to let you know if one occurs. See [Protecting against ticket update collisions](/documentation/ticketing/managing-tickets/creating-and-updating-tickets/#protecting-against-ticket-update-collisions). A value of false has the same effect as true. Omit the property to force the updates to not be safe',
      writeOnly: true,
    },
    satisfaction_rating: {
      type: 'object',
      description: `The satisfaction rating of the ticket, if it exists, or the state of satisfaction, "offered" or "unoffered". The value is null for plan types that don't support CSAT`,
      additionalProperties: true,
      readOnly: true,
    },
    sharing_agreement_ids: {
      type: 'array',
      description: 'The ids of the sharing agreements used for this ticket',
      items: {
        type: 'integer',
      },
    },
    status: {
      type: 'string',
      description: `The state of the ticket.

If your account has activated custom ticket statuses, this is the ticket's
status category. See [custom ticket statuses](#custom-ticket-statuses)
`,
      enum: ['new', 'open', 'pending', 'hold', 'solved', 'closed'],
    },
    subject: {
      type: 'string',
      description: `The value of the subject field for this ticket. See [Subject](/api-reference/ticketing/tickets/tickets/#subject)
`,
    },
    submitter_id: {
      type: 'integer',
      description:
        'The user who submitted the ticket. The submitter always becomes the author of the first comment on the ticket',
    },
    tags: {
      type: 'array',
      description:
        'The array of tags applied to this ticket. Unless otherwise specified, the [set tag](/api-reference/ticketing/ticket-management/tags/#set-tags) behavior is used, which overwrites and replaces existing tags',
      items: {
        type: 'string',
      },
    },
    ticket_form_id: {
      type: 'integer',
      description: 'Enterprise only. The id of the ticket form to render for the ticket',
    },
    type: {
      type: 'string',
      description: 'The type of this ticket',
      enum: ['problem', 'incident', 'question', 'task'],
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description:
        'When this record last got updated. It is updated only if the update generates a [ticket event](#incremental-ticket-event-export)',
      readOnly: true,
    },
    updated_stamp: {
      type: 'string',
      description: 'Write only. Datetime of last update received from API. See the `safe_update` property',
      writeOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this ticket',
      readOnly: true,
    },
    via: {
      type: 'object',
      description:
        'For more information, see the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)',
      properties: {
        channel: {
          type: 'string',
          description: `This tells you how the ticket or event was created. Examples: "web", "mobile", "rule", "system"
`,
        },
        source: {
          type: 'object',
          description: `For some channels a source object gives more information about how or why the ticket or event was created
`,
          additionalProperties: true,
        },
      },
    },
    via_followup_source_id: {
      type: 'integer',
      description:
        'POST requests only. The id of a closed ticket when creating a follow-up ticket. See [Creating a follow-up ticket](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#creating-a-follow-up-ticket)',
    },
    via_id: {
      type: 'integer',
      description:
        'Write only. For more information, see the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference/)',
      writeOnly: true,
    },
    voice_comment: {
      type: 'object',
      description:
        'Write only. See [Creating voicemail ticket](/api-reference/voice/talk-partner-edition-api/reference/#creating-voicemail-tickets)',
      writeOnly: true,
    },
  },
  example: {
    assignee_id: 235323,
    collaborator_ids: [35334, 234],
    created_at: '2009-07-20T22:55:29Z',
    custom_fields: [
      {
        id: 27642,
        value: '745',
      },
      {
        id: 27648,
        value: 'yes',
      },
    ],
    custom_status_id: 123,
    description: 'The fire is very colorful.',
    due_at: null,
    external_id: 'ahg35h3jh',
    follower_ids: [35334, 234],
    from_messaging_channel: false,
    generated_timestamp: 1304553600,
    group_id: 98738,
    has_incidents: false,
    id: 35436,
    organization_id: 509974,
    priority: 'high',
    problem_id: 9873764,
    raw_subject: '{{dc.printer_on_fire}}',
    recipient: 'support@company.com',
    requester_id: 20978392,
    satisfaction_rating: {
      comment: 'Great support!',
      id: 1234,
      score: 'good',
    },
    sharing_agreement_ids: [84432],
    status: 'open',
    subject: 'Help, my printer is on fire!',
    submitter_id: 76872,
    tags: ['enterprise', 'other_tag'],
    type: 'incident',
    updated_at: '2011-05-05T10:38:52Z',
    url: 'https://company.zendesk.com/api/v2/tickets/35436.json',
    via: {
      channel: 'web',
    },
  },
  required: ['requester_id'],
} as const;

export const TicketRelatedInformationSchema = {
  type: 'object',
  properties: {
    followup_source_ids: {
      type: 'array',
      items: {
        type: 'string',
        description: 'Sources to follow up',
      },
    },
    from_archive: {
      type: 'boolean',
      description: 'Is true if the current ticket is archived',
    },
    incidents: {
      type: 'integer',
      description: 'A count of related incident occurrences',
    },
    jira_issue_ids: {
      type: 'array',
      items: {
        type: 'string',
        description: 'Associated jira issues',
      },
    },
    topic_id: {
      type: 'string',
      description: 'Related topic in the Web portal (deprecated feature)',
      nullable: true,
    },
  },
} as const;

export const TicketResponseSchema = {
  type: 'object',
  properties: {
    ticket: {
      $ref: '#/components/schemas/TicketObject',
    },
  },
} as const;

export const TicketSkipCreationSchema = {
  type: 'object',
  properties: {
    skip: {
      $ref: '#/components/schemas/TicketSkipObject',
    },
  },
} as const;

export const TicketSkipObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'Time the skip was created',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned upon creation',
      readOnly: true,
    },
    reason: {
      type: 'string',
      description: 'Reason for skipping the ticket',
      readOnly: true,
    },
    ticket: {
      type: 'object',
      description:
        'The skipped ticket. See the [Ticket object reference](/api-reference/ticketing/tickets/tickets/#json-format)',
      allOf: [
        {
          $ref: '#/components/schemas/TicketObject',
        },
      ],
    },
    ticket_id: {
      type: 'integer',
      description: 'ID of the skipped ticket',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'Time the skip was last updated',
      readOnly: true,
    },
    user_id: {
      type: 'integer',
      description: 'ID of the skipping agent',
      readOnly: true,
    },
  },
  example: {
    created_at: '2015-09-30T21:44:03Z',
    id: 1,
    reason: 'I have no idea.',
    ticket: {
      assignee_id: 235323,
      collaborator_ids: [35334, 234],
      created_at: '2009-07-20T22:55:29Z',
      custom_fields: [
        {
          id: 27642,
          value: '745',
        },
        {
          id: 27648,
          value: 'yes',
        },
      ],
      description: 'The fire is very colorful.',
      due_at: null,
      external_id: 'ahg35h3jh',
      follower_ids: [35334, 234],
      from_messaging_channel: false,
      generated_timestamp: 1304553600,
      group_id: 98738,
      has_incidents: false,
      id: 123,
      organization_id: 509974,
      priority: 'high',
      problem_id: 9873764,
      raw_subject: '{{dc.printer_on_fire}}',
      recipient: 'support@company.com',
      requester_id: 20978392,
      satisfaction_rating: {
        comment: 'Great support!',
        id: 1234,
        score: 'good',
      },
      sharing_agreement_ids: [84432],
      status: 'open',
      subject: 'Help, my printer is on fire!',
      submitter_id: 76872,
      tags: ['enterprise', 'other_tag'],
      type: 'incident',
      updated_at: '2011-05-05T10:38:52Z',
      url: 'https://company.zendesk.com/api/v2/tickets/35436.json',
      via: {
        channel: 'web',
      },
    },
    ticket_id: 123,
    updated_at: '2015-09-30T21:44:03Z',
    user_id: 456,
  },
} as const;

export const TicketSkipsResponseSchema = {
  type: 'object',
  properties: {
    skips: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketSkipObject',
      },
    },
  },
} as const;

export const TicketUpdateInputSchema = {
  type: 'object',
  properties: {
    additional_collaborators: {
      type: 'array',
      description:
        'An array of numeric IDs, emails, or objects containing name and email properties. See [Setting Collaborators](/api-reference/ticketing/tickets/tickets/#setting-collaborators). An email notification is sent to them when the ticket is updated',
      items: {
        $ref: '#/components/schemas/CollaboratorObject',
      },
    },
    assignee_email: {
      type: 'string',
      format: 'email',
      description: 'The email address of the agent to assign the ticket to',
    },
    assignee_id: {
      type: 'integer',
      description: 'The agent currently assigned to the ticket',
    },
    attribute_value_ids: {
      type: 'array',
      description: 'An array of the IDs of attribute values to be associated with the ticket',
      items: {
        type: 'integer',
      },
    },
    collaborator_ids: {
      type: 'array',
      description: "The ids of users currently CC'ed on the ticket",
      items: {
        type: 'integer',
      },
    },
    comment: {
      $ref: '#/components/schemas/TicketCommentObject',
    },
    custom_fields: {
      type: 'array',
      description:
        'Custom fields for the ticket. See [Setting custom field values](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-custom-field-values)',
      items: {
        $ref: '#/components/schemas/CustomFieldObject',
      },
    },
    custom_status_id: {
      type: 'integer',
      description: 'The custom ticket status id of the ticket. See [custom ticket statuses](#custom-ticket-statuses)',
    },
    due_at: {
      type: 'string',
      format: 'date-time',
      description:
        'If this is a ticket of type "task" it has a due date.  Due date format uses [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format.',
      nullable: true,
    },
    email_ccs: {
      type: 'array',
      description:
        'An array of objects that represent agent or end users email CCs to add or delete from the ticket. See [Setting email CCs](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-email-ccs)',
      items: {
        $ref: '#/components/schemas/EmailCCObject',
      },
    },
    external_id: {
      type: 'string',
      description: 'An id you can use to link Zendesk Support tickets to local records',
    },
    followers: {
      type: 'array',
      description:
        'An array of objects that represent agent followers to add or delete from the ticket. See [Setting followers](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-followers)',
      items: {
        $ref: '#/components/schemas/FollowerObject',
      },
    },
    group_id: {
      type: 'integer',
      description: 'The group this ticket is assigned to',
    },
    organization_id: {
      type: 'integer',
      description:
        'The organization of the requester. You can only specify the ID of an organization associated with the requester. See [Organization Memberships](/api-reference/ticketing/organizations/organization_memberships/)',
    },
    priority: {
      type: 'string',
      description: 'The urgency with which the ticket should be addressed.',
      enum: ['urgent', 'high', 'normal', 'low'],
    },
    problem_id: {
      type: 'integer',
      description: 'For tickets of type "incident", the ID of the problem the incident is linked to',
    },
    requester_id: {
      type: 'integer',
      description: 'The user who requested this ticket',
    },
    safe_update: {
      type: 'boolean',
      description:
        'Optional boolean. Prevents updates with outdated ticket data (`updated_stamp` property required when true)',
    },
    sharing_agreement_ids: {
      type: 'array',
      description: 'An array of the numeric IDs of sharing agreements. Note that this replaces any existing agreements',
      items: {
        type: 'integer',
      },
    },
    status: {
      type: 'string',
      description: `The state of the ticket.

If your account has activated custom ticket statuses, this is the ticket's
status category. See [custom ticket statuses](#custom-ticket-statuses).
`,
      enum: ['new', 'open', 'pending', 'hold', 'solved', 'closed'],
    },
    subject: {
      type: 'string',
      description: 'The value of the subject field for this ticket',
    },
    tags: {
      type: 'array',
      description: 'The array of tags applied to this ticket',
      items: {
        type: 'string',
      },
    },
    type: {
      type: 'string',
      description: 'The type of this ticket.',
      enum: ['problem', 'incident', 'question', 'task'],
    },
    updated_stamp: {
      type: 'string',
      format: 'date-time',
      description: 'Datetime of last update received from API. See the safe_update property',
    },
  },
  example: {
    comment: {
      body: 'The smoke is very colorful.',
    },
    priority: 'urgent',
    subject: 'My printer is on fire!',
  },
} as const;

export const TicketUpdateRequestSchema = {
  type: 'object',
  properties: {
    ticket: {
      $ref: '#/components/schemas/TicketUpdateInput',
    },
  },
} as const;

export const TicketUpdateResponseSchema = {
  type: 'object',
  properties: {
    audit: {
      $ref: '#/components/schemas/AuditObject',
    },
    ticket: {
      $ref: '#/components/schemas/TicketObject',
    },
  },
} as const;

export const TicketsCreateRequestSchema = {
  type: 'object',
  properties: {
    tickets: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketCreateInput',
      },
    },
  },
} as const;

export const TicketsResponseSchema = {
  type: 'object',
  properties: {
    tickets: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketObject',
      },
    },
  },
} as const;

export const TimeBasedExportIncrementalTicketsResponseSchema = {
  type: 'object',
  description: `See [Tickets](/api-reference/ticketing/tickets/tickets/) for a detailed example.
`,
  properties: {
    count: {
      type: 'integer',
    },
    end_of_stream: {
      type: 'boolean',
    },
    end_time: {
      type: 'integer',
    },
    next_page: {
      type: 'string',
      nullable: true,
    },
    tickets: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TicketObject',
      },
    },
  },
  example: {
    count: 2,
    end_of_stream: true,
    end_time: 1390362485,
    next_page: 'https://{subdomain}.zendesk.com/api/v2/incremental/tickets.json?per_page=3&start_time=1390362485',
    tickets: [
      {
        assignee_id: 235323,
        collaborator_ids: [35334, 234],
        created_at: '2009-07-20T22:55:29Z',
        custom_fields: [
          {
            id: 27642,
            value: '745',
          },
          {
            id: 27648,
            value: 'yes',
          },
        ],
        description: 'The fire is very colorful.',
        due_at: null,
        external_id: 'ahg35h3jh',
        follower_ids: [35334, 234],
        generated_timestamp: 1304553600,
        group_id: 98738,
        has_incidents: false,
        id: 35436,
        organization_id: 509974,
        priority: 'high',
        problem_id: 9873764,
        raw_subject: '{{dc.printer_on_fire}}',
        recipient: 'support@company.com',
        requester_id: 20978392,
        satisfaction_rating: {
          comment: 'Great support!',
          id: 1234,
          score: 'good',
        },
        sharing_agreement_ids: [84432],
        status: 'open',
        subject: 'Help, my printer is on fire!',
        submitter_id: 76872,
        tags: ['enterprise', 'other_tag'],
        type: 'incident',
        updated_at: '2011-05-05T10:38:52Z',
        url: 'https://company.zendesk.com/api/v2/tickets/35436.json',
        via: {
          channel: 'web',
        },
      },
    ],
  },
} as const;

export const TimeBasedExportIncrementalUsersResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
    },
    end_of_stream: {
      type: 'boolean',
    },
    end_time: {
      type: 'integer',
    },
    next_page: {
      type: 'string',
      nullable: true,
    },
    users: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/UserObject',
      },
    },
  },
  example: {
    count: 1,
    end_of_stream: true,
    end_time: 1601357503,
    next_page: 'https://example.zendesk.com/api/v2/incremental/ticket_events.json?start_time=1601357503',
    users: [
      {
        active: true,
        alias: 'Mr. Johnny',
        created_at: '2009-07-20T22:55:29Z',
        custom_role_id: 9373643,
        details: '',
        email: 'johnny@example.com',
        external_id: 'sai989sur98w9',
        id: 35436,
        last_login_at: '2011-05-05T10:38:52Z',
        locale: 'en-US',
        locale_id: 1,
        moderator: true,
        name: 'Johnny Agent',
        notes: 'Johnny is a nice guy!',
        only_private_comments: false,
        organization_id: 57542,
        phone: '+15551234567',
        photo: {
          content_type: 'image/png',
          content_url: 'https://company.zendesk.com/photos/my_funny_profile_pic.png',
          id: 928374,
          name: 'my_funny_profile_pic.png',
          size: 166144,
          thumbnails: [
            {
              content_type: 'image/png',
              content_url: 'https://company.zendesk.com/photos/my_funny_profile_pic_thumb.png',
              id: 928375,
              name: 'my_funny_profile_pic_thumb.png',
              size: 58298,
            },
          ],
        },
        restricted_agent: true,
        role: 'agent',
        role_type: 0,
        shared: false,
        shared_agent: false,
        signature: 'Have a nice day, Johnny',
        suspended: true,
        tags: ['enterprise', 'other_tag'],
        ticket_restriction: 'assigned',
        time_zone: 'Copenhagen',
        updated_at: '2011-05-05T10:38:52Z',
        url: 'https://company.zendesk.com/api/v2/users/35436.json',
        user_fields: {
          user_date: '2012-07-23T00:00:00Z',
          user_decimal: 5.1,
          user_dropdown: 'option_1',
        },
        verified: true,
      },
    ],
  },
} as const;

export const TrialAccountObjectSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      description: 'The name of the account',
    },
    subdomain: {
      type: 'string',
      description: 'The subdomain of the account',
    },
    url: {
      type: 'string',
      description: 'The URL of the account',
    },
  },
} as const;

export const TrialAccountResponseSchema = {
  type: 'object',
  properties: {
    account: {
      $ref: '#/components/schemas/TrialAccountObject',
    },
  },
} as const;

export const TriggerActionDefinitionObjectSchema = {
  type: 'object',
  properties: {
    group: {
      type: 'string',
    },
    nullable: {
      type: 'boolean',
    },
    repeatable: {
      type: 'boolean',
    },
    subject: {
      type: 'string',
    },
    title: {
      type: 'string',
    },
    type: {
      type: 'string',
    },
    values: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          enabled: {
            type: 'boolean',
          },
          title: {
            type: 'string',
          },
          value: {
            type: 'string',
          },
        },
      },
    },
  },
} as const;

export const TriggerActionDiffObjectSchema = {
  type: 'object',
  properties: {
    field: {
      type: 'array',
      description: 'An array of [change](#change) objects.',
      items: {
        $ref: '#/components/schemas/TriggerChangeObject',
      },
    },
    value: {
      type: 'array',
      description: 'An array of [change](#change) objects.',
      items: {
        $ref: '#/components/schemas/TriggerChangeObject',
      },
    },
  },
  example: {
    field: [
      {
        change: '+',
        content: 'solved',
      },
    ],
    value: [
      {
        change: '-',
        content: 'open',
      },
    ],
  },
} as const;

export const TriggerActionObjectSchema = {
  type: 'object',
  properties: {
    field: {
      type: 'string',
    },
    value: {
      oneOf: [
        {
          type: 'string',
        },
        {
          type: 'integer',
        },
        {
          type: 'array',
          items: {
            oneOf: [
              {
                type: 'string',
              },
              {
                type: 'integer',
              },
            ],
          },
        },
      ],
    },
  },
  example: {
    field: 'status',
    value: 'solved',
  },
} as const;

export const TriggerBatchRequestSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
    },
    category_id: {
      type: 'string',
    },
    id: {
      type: 'string',
    },
    position: {
      type: 'integer',
      format: 'int64',
    },
  },
  required: ['id'],
} as const;

export const TriggerBulkUpdateItemSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'The active status of the ticket trigger (true or false)',
    },
    category_id: {
      type: 'string',
      description: 'The ID of the new category the ticket trigger is to be moved to',
    },
    id: {
      type: 'integer',
      description: 'The ID of the ticket trigger to update',
    },
    position: {
      type: 'integer',
      description: 'The new position of the ticket trigger',
    },
  },
  example: {
    active: true,
    category_id: '10026',
    id: 25,
    position: 8,
  },
  required: ['id'],
} as const;

export const TriggerBulkUpdateRequestSchema = {
  type: 'object',
  properties: {
    triggers: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TriggerBulkUpdateItem',
      },
    },
  },
} as const;

export const TriggerCategoriesResponseSchema = {
  type: 'object',
  properties: {
    trigger_categories: {
      type: 'array',
      items: {
        type: 'object',
        anyOf: [
          {
            $ref: '#/components/schemas/TriggerCategoryRuleCounts',
          },
        ],
        allOf: [
          {
            $ref: '#/components/schemas/TriggerCategory',
          },
        ],
      },
    },
  },
} as const;

export const TriggerCategorySchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      readOnly: true,
    },
    id: {
      type: 'string',
      readOnly: true,
    },
    name: {
      type: 'string',
    },
    position: {
      type: 'integer',
      format: 'int64',
    },
    updated_at: {
      type: 'string',
      readOnly: true,
    },
  },
} as const;

export const TriggerCategoryBatchRequestSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    position: {
      type: 'integer',
      format: 'int64',
    },
  },
  required: ['id', 'position'],
} as const;

export const TriggerCategoryIdSchema = {
  type: 'string',
} as const;

export const TriggerCategoryRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
    },
    position: {
      type: 'integer',
      format: 'int64',
    },
  },
} as const;

export const TriggerCategoryRequestRequiredSchema = {
  type: 'object',
  required: ['name'],
} as const;

export const TriggerCategoryResponseSchema = {
  type: 'object',
  properties: {
    trigger_category: {
      $ref: '#/components/schemas/TriggerCategory',
    },
  },
} as const;

export const TriggerCategoryRuleCountsSchema = {
  type: 'object',
  properties: {
    active_count: {
      type: 'integer',
      format: 'int64',
    },
    inactive_count: {
      type: 'integer',
      format: 'int64',
    },
  },
} as const;

export const TriggerChangeObjectSchema = {
  type: 'object',
  properties: {
    change: {
      type: 'string',
      description: 'One of `-`, `+`, `=` representing the type of change',
    },
    content: {
      description: 'The value of the item it represents',
      oneOf: [
        {
          type: 'boolean',
        },
        {
          type: 'string',
        },
        {
          type: 'integer',
        },
        {
          type: 'array',
          items: {
            oneOf: [
              {
                type: 'string',
              },
              {
                type: 'integer',
              },
              {
                type: 'boolean',
              },
            ],
          },
        },
      ],
    },
  },
  example: {
    change: '+',
    content: 'solved',
  },
} as const;

export const TriggerConditionDefinitionObjectAllSchema = {
  type: 'object',
  properties: {
    group: {
      type: 'string',
    },
    nullable: {
      type: 'boolean',
    },
    operators: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          terminal: {
            type: 'boolean',
          },
          title: {
            type: 'string',
          },
          value: {
            type: 'string',
          },
        },
      },
    },
    repeatable: {
      type: 'boolean',
    },
    subject: {
      type: 'string',
    },
    title: {
      type: 'string',
    },
    type: {
      type: 'string',
    },
    values: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          enabled: {
            type: 'boolean',
          },
          title: {
            type: 'string',
          },
          value: {
            type: 'string',
          },
        },
      },
    },
  },
} as const;

export const TriggerConditionDefinitionObjectAnySchema = {
  type: 'object',
  properties: {
    group: {
      type: 'string',
    },
    nullable: {
      type: 'boolean',
    },
    operators: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          terminal: {
            type: 'boolean',
          },
          title: {
            type: 'string',
          },
          value: {
            type: 'string',
          },
        },
      },
    },
    repeatable: {
      type: 'boolean',
    },
    subject: {
      type: 'string',
    },
    title: {
      type: 'string',
    },
    type: {
      type: 'string',
    },
  },
} as const;

export const TriggerConditionDiffObjectSchema = {
  type: 'object',
  properties: {
    field: {
      type: 'array',
      description: 'An array of [change](#change) objects',
      items: {
        $ref: '#/components/schemas/TriggerChangeObject',
      },
    },
    operator: {
      type: 'array',
      description: 'An array of [change](#change) objects',
      items: {
        $ref: '#/components/schemas/TriggerChangeObject',
      },
    },
    value: {
      type: 'array',
      description: 'An array of [change](#change) objects',
      items: {
        $ref: '#/components/schemas/TriggerChangeObject',
      },
    },
  },
  example: {
    field: [
      {
        change: '=',
        content: 'status',
      },
    ],
    operator: [
      {
        change: '=',
        content: 'less_than',
      },
    ],
    value: [
      {
        change: '+',
        content: 'solved',
      },
    ],
  },
} as const;

export const TriggerConditionObjectSchema = {
  type: 'object',
  properties: {
    field: {
      type: 'string',
    },
    operator: {
      type: 'string',
    },
    value: {
      oneOf: [
        {
          type: 'string',
        },
        {
          type: 'integer',
        },
        {
          type: 'array',
          items: {
            oneOf: [
              {
                type: 'string',
              },
              {
                type: 'integer',
              },
            ],
          },
        },
      ],
    },
  },
  example: {
    field: 'status',
    operator: 'less_than',
    value: 'solved',
  },
} as const;

export const TriggerConditionsDiffObjectSchema = {
  type: 'object',
  properties: {
    all: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TriggerConditionDiffObject',
      },
      nullable: true,
    },
    any: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TriggerConditionDiffObject',
      },
      nullable: true,
    },
  },
} as const;

export const TriggerConditionsObjectSchema = {
  type: 'object',
  description:
    'An object that describes the circumstances under which the trigger performs its actions. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)',
  properties: {
    all: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TriggerConditionObject',
      },
      nullable: true,
    },
    any: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TriggerConditionObject',
      },
      nullable: true,
    },
  },
  example: {
    all: [
      {
        field: 'status',
        operator: 'less_than',
        value: 'solved',
      },
      {
        field: 'assignee_id',
        operator: 'is',
        value: '296220096',
      },
      {
        field: 'custom_status_id',
        operator: 'includes',
        value: ['1', '2'],
      },
    ],
    any: [
      {
        field: 'status',
        operator: 'less_than',
        value: 'solved',
      },
      {
        field: 'custom_status_id',
        operator: 'includes',
        value: ['1', '2'],
      },
    ],
  },
} as const;

export const TriggerDefinitionObjectSchema = {
  type: 'object',
  properties: {
    actions: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TriggerActionDefinitionObject',
      },
    },
    conditions_all: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TriggerConditionDefinitionObjectAll',
      },
    },
    conditions_any: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TriggerConditionDefinitionObjectAny',
      },
    },
  },
} as const;

export const TriggerDefinitionResponseSchema = {
  type: 'object',
  properties: {
    definitions: {
      $ref: '#/components/schemas/TriggerDefinitionObject',
    },
  },
} as const;

export const TriggerObjectSchema = {
  type: 'object',
  properties: {
    actions: {
      type: 'array',
      description:
        'An array of actions describing what the ticket trigger will do. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)',
      items: {
        $ref: '#/components/schemas/TriggerActionObject',
      },
    },
    active: {
      type: 'boolean',
      description: 'Whether the ticket trigger is active',
    },
    category_id: {
      type: 'string',
      description: 'The ID of the category the ticket trigger belongs to',
    },
    conditions: {
      $ref: '#/components/schemas/TriggerConditionsObject',
    },
    created_at: {
      type: 'string',
      description: 'The time the ticket trigger was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: 'If true, the ticket trigger is a standard trigger',
      readOnly: true,
    },
    description: {
      type: 'string',
      description: 'The description of the ticket trigger',
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when created',
      readOnly: true,
    },
    position: {
      type: 'integer',
      description: 'Position of the ticket trigger, determines the order they will execute in',
    },
    raw_title: {
      type: 'string',
      description: 'The raw format of the title of the ticket trigger',
    },
    title: {
      type: 'string',
      description: 'The title of the ticket trigger',
    },
    updated_at: {
      type: 'string',
      description: 'The time of the last update of the ticket trigger',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The url of the ticket trigger',
      readOnly: true,
    },
  },
  example: {
    actions: [{}],
    active: true,
    category_id: '10026',
    conditions: {},
    created_at: '2012-09-25T22:50:26Z',
    default: false,
    description: 'Close and save a ticket',
    id: 25,
    position: 8,
    raw_title: 'Close and Save',
    title: 'Close and Save',
    updated_at: '2012-09-25T22:50:26Z',
    url: 'http://{subdomain}.zendesk.com/api/v2/triggers/25.json',
  },
  required: ['conditions', 'actions', 'title'],
} as const;

export const TriggerResponseSchema = {
  type: 'object',
  properties: {
    trigger: {
      $ref: '#/components/schemas/TriggerObject',
    },
  },
} as const;

export const TriggerRevisionResponseSchema = {
  type: 'object',
  properties: {
    trigger_revision: {
      type: 'object',
      properties: {
        author_id: {
          type: 'integer',
        },
        created_at: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        snapshot: {
          type: 'object',
          properties: {
            actions: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/TriggerActionObject',
              },
            },
            active: {
              type: 'boolean',
            },
            conditions: {
              $ref: '#/components/schemas/TriggerConditionsObject',
            },
            description: {
              type: 'string',
              nullable: true,
            },
            title: {
              type: 'string',
            },
          },
        },
        url: {
          type: 'string',
        },
      },
    },
  },
} as const;

export const TriggerRevisionsResponseSchema = {
  type: 'object',
  properties: {
    after_cursor: {
      type: 'string',
    },
    after_url: {
      type: 'string',
    },
    before_cursor: {
      type: 'string',
    },
    before_url: {
      type: 'string',
    },
    count: {
      type: 'integer',
    },
    trigger_revisions: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          author_id: {
            type: 'integer',
          },
          created_at: {
            type: 'string',
          },
          diff: {
            type: 'object',
            properties: {
              actions: {
                type: 'array',
                description: 'An array that contain [action diff objects](#Action Diffs)',
                items: {
                  $ref: '#/components/schemas/TriggerActionDiffObject',
                },
              },
              active: {
                type: 'array',
                description: 'An array of [change](#change) objects',
                items: {
                  $ref: '#/components/schemas/TriggerChangeObject',
                },
              },
              conditions: {
                $ref: '#/components/schemas/TriggerConditionDiffObject',
              },
              description: {
                type: 'array',
                description: 'An array of [change](#change) objects',
                items: {
                  $ref: '#/components/schemas/TriggerChangeObject',
                },
              },
              source_id: {
                type: 'integer',
                description: 'ID of the source revision',
              },
              target_id: {
                type: 'integer',
                description: 'ID of the target revision',
              },
              title: {
                type: 'array',
                description: 'An array of [change](#change) objects',
                items: {
                  $ref: '#/components/schemas/TriggerChangeObject',
                },
              },
            },
          },
          id: {
            type: 'integer',
          },
          snapshot: {
            $ref: '#/components/schemas/TriggerSnapshotObject',
          },
          url: {
            type: 'string',
          },
        },
      },
    },
  },
} as const;

export const TriggerSnapshotObjectSchema = {
  type: 'object',
  properties: {
    actions: {
      type: 'array',
      description: 'An array of [Actions](#actions) describing what the ticket trigger will do',
      items: {
        $ref: '#/components/schemas/TriggerActionObject',
      },
    },
    active: {
      type: 'boolean',
      description: 'Whether the ticket trigger is active',
    },
    conditions: {
      $ref: '#/components/schemas/TriggerConditionsObject',
    },
    description: {
      type: 'string',
      description: 'The description of the ticket trigger',
      nullable: true,
    },
    title: {
      type: 'string',
      description: 'The title of the ticket trigger',
    },
  },
  example: {
    actions: [],
    active: true,
    conditions: {},
    description: 'Notifies requester that a comment was updated',
    title: 'Notify requester of comment update',
  },
} as const;

export const TriggerWithCategoryRequestSchema = {
  type: 'object',
  properties: {
    trigger: {
      allOf: [
        {
          $ref: '#/components/schemas/TriggerObject',
        },
        {
          anyOf: [
            {
              $ref: '#/components/schemas/TriggerCategory',
            },
            {
              $ref: '#/components/schemas/TriggerCategoryId',
            },
          ],
        },
      ],
    },
  },
} as const;

export const TriggersResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
    },
    next_page: {
      type: 'string',
      nullable: true,
    },
    previous_page: {
      type: 'string',
      nullable: true,
    },
    triggers: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TriggerObject',
      },
    },
  },
} as const;

export const TwitterChannelObjectSchema = {
  title: 'Monitored X handles',
  type: 'object',
  properties: {
    allow_reply: {
      type: 'boolean',
      description: 'If replies are allowed for this handle',
      readOnly: true,
    },
    avatar_url: {
      type: 'string',
      description: 'The profile image url of the handle',
      readOnly: true,
    },
    brand_id: {
      type: 'integer',
      description: 'What brand the handle is associated with',
      readOnly: true,
    },
    can_reply: {
      type: 'boolean',
      description: 'If replies are allowed for this handle',
      readOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the handle was created',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned upon creation',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'The profile name of the handle',
      readOnly: true,
    },
    screen_name: {
      type: 'string',
      description: 'The X handle',
      readOnly: true,
    },
    twitter_user_id: {
      type: 'integer',
      description: "The country's code",
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the handle',
      readOnly: true,
    },
  },
  example: {
    created_at: '2009-05-13T00:07:08Z',
    id: 211,
    screen_name: '@zendesk',
    twitter_user_id: 67462376832,
    updated_at: '2011-07-22T00:11:12Z',
  },
  required: ['id', 'screen_name', 'twitter_user_id'],
} as const;

export const TwitterChannelResponseSchema = {
  type: 'object',
  properties: {
    monitored_twitter_handle: {
      $ref: '#/components/schemas/TwitterChannelObject',
    },
  },
} as const;

export const TwitterChannelTwicketStatusResponseSchema = {
  type: 'object',
  properties: {
    statuses: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          favorited: {
            type: 'boolean',
          },
          id: {
            type: 'integer',
          },
          retweeted: {
            type: 'boolean',
          },
          user_followed: {
            type: 'boolean',
          },
        },
      },
    },
  },
} as const;

export const TwitterChannelsResponseSchema = {
  type: 'object',
  properties: {
    monitored_twitter_handles: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TwitterChannelObject',
      },
    },
  },
} as const;

export const UpdateResourceResultSchema = {
  type: 'object',
  properties: {
    action: {
      type: 'string',
      description: `the action the job attempted (\`"action": "update"\`)
`,
    },
    id: {
      type: 'integer',
      description: 'the id of the resource the job attempted to update',
    },
    status: {
      type: 'string',
      description: `the status (\`"status": "Updated"\`)
`,
    },
    success: {
      type: 'boolean',
      description: `whether the action was successful or not (\`"success": true\`)
`,
    },
  },
  required: ['id', 'action', 'success', 'status'],
} as const;

export const UrlObjectSchema = {
  type: 'object',
  properties: {
    url: {
      type: 'string',
      readOnly: true,
    },
  },
} as const;

export const UserCreateInputSchema = {
  type: 'object',
  properties: {
    custom_role_id: {
      type: 'integer',
    },
    email: {
      type: 'string',
    },
    external_id: {
      type: 'string',
    },
    identities: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          type: {
            type: 'string',
          },
          value: {
            type: 'string',
          },
        },
        required: ['type', 'value'],
      },
    },
    name: {
      type: 'string',
    },
    organization: {
      type: 'object',
      properties: {
        name: {
          type: 'string',
        },
      },
      required: ['name'],
    },
    organization_id: {
      type: 'integer',
    },
    role: {
      type: 'string',
    },
  },
  required: ['name', 'email'],
} as const;

export const UserFieldObjectSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/CustomFieldObject',
    },
  ],
  example: {
    active: true,
    created_at: '2012-10-16T16:04:06Z',
    description: 'Description of Custom Field',
    id: 7,
    key: 'custom_field_1',
    position: 9999,
    raw_description: '{{dc.my_description}}',
    raw_title: 'Custom Field 1',
    regexp_for_validation: null,
    title: 'Custom Field 1',
    type: 'text',
    updated_at: '2012-10-16T16:04:06Z',
    url: 'https://company.zendesk.com/api/v2/user_fields/7.json',
  },
} as const;

export const UserFieldResponseSchema = {
  type: 'object',
  properties: {
    user_field: {
      $ref: '#/components/schemas/UserFieldObject',
    },
  },
} as const;

export const UserFieldsResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      description: 'Total count of records retrieved',
      readOnly: true,
    },
    next_page: {
      type: 'string',
      description: 'URL of the next page',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      description: 'URL of the previous page',
      nullable: true,
      readOnly: true,
    },
    user_fields: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/UserFieldObject',
      },
    },
  },
} as const;

export const UserForAdminSchema = {
  title: 'Users',
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'false if the user has been deleted',
      readOnly: true,
    },
    alias: {
      type: 'string',
      description: 'An alias displayed to end users',
    },
    chat_only: {
      type: 'boolean',
      description: 'Whether or not the user is a chat-only agent',
      readOnly: true,
    },
    created_at: {
      type: 'string',
      format: 'datetime',
      description: 'The time the user was created',
      readOnly: true,
    },
    custom_role_id: {
      type: 'integer',
      description: 'A custom role if the user is an agent on the Enterprise plan or above',
      nullable: true,
    },
    default_group_id: {
      type: 'integer',
      description: "The id of the user's default group",
    },
    details: {
      type: 'string',
      description: 'Any details you want to store about the user, such as an address',
    },
    email: {
      type: 'string',
      description:
        "The user's primary email address. *Writeable on create only. On update, a secondary email is added. See [Email Address](#email-address)",
    },
    external_id: {
      type: 'string',
      description:
        'A unique identifier from another system. The API treats the id as case insensitive. Example: "ian1" and "IAN1" are the same value.',
      nullable: true,
    },
    iana_time_zone: {
      type: 'string',
      description: 'The time zone for the user',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when the user is created',
      readOnly: true,
    },
    last_login_at: {
      type: 'string',
      format: 'datetime',
      description: `Last time the user signed in to Zendesk Support or made an API request
using an API token or basic authentication
`,
      readOnly: true,
    },
    locale: {
      type: 'string',
      description: `The user's locale. A BCP-47 compliant tag for the locale. If both "locale" and "locale_id" are present on create or update, "locale_id" is ignored and only "locale" is used.`,
    },
    locale_id: {
      type: 'integer',
      description: "The user's language identifier",
    },
    moderator: {
      type: 'boolean',
      description: 'Designates whether the user has forum moderation capabilities',
    },
    name: {
      type: 'string',
      description: "The user's name",
    },
    notes: {
      type: 'string',
      description: 'Any notes you want to store about the user',
    },
    only_private_comments: {
      type: 'boolean',
      description: 'true if the user can only create private comments',
    },
    organization_id: {
      type: 'integer',
      description:
        "The id of the user's organization. If the user has more than one [organization memberships](/api-reference/ticketing/organizations/organization_memberships/), the id of the user's default organization. If updating, see [Organization ID](#organization-id)",
      nullable: true,
    },
    phone: {
      type: 'string',
      description: "The user's primary phone number. See [Phone Number](#phone-number) below",
      nullable: true,
    },
    photo: {
      type: 'object',
      description:
        "The user's profile picture represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object",
      additionalProperties: true,
      nullable: true,
    },
    remote_photo_url: {
      type: 'string',
      description: "A URL pointing to the user's profile picture.",
    },
    report_csv: {
      type: 'boolean',
      description: `This parameter is inert and has no effect. It may be deprecated in the
future.

Previously, this parameter determined whether a user could access a CSV
report in a legacy Guide dashboard. This dashboard has been removed. See
[Announcing Guide legacy reporting upgrade to
Explore](https://support.zendesk.com/hc/en-us/articles/4762263171610-Announcing-Guide-legacy-reporting-upgrade-to-Explore-)
`,
      readOnly: true,
    },
    restricted_agent: {
      type: 'boolean',
      description: 'If the agent has any restrictions; false for admins and unrestricted agents, true for other agents',
    },
    role: {
      type: 'string',
      description: `The user's role. Possible values are "end-user", "agent", or "admin"`,
    },
    role_type: {
      type: 'integer',
      description:
        "The user's role id. 0 for a custom agent, 1 for a light agent, 2 for a chat agent, 3 for a chat agent added to the Support account as a contributor ([Chat Phase 4](https://support.zendesk.com/hc/en-us/articles/360022365373#topic_djh_1zk_4fb)), 4 for an admin, and 5 for a billing admin",
      nullable: true,
      readOnly: true,
    },
    shared: {
      type: 'boolean',
      description: 'If the user is shared from a different Zendesk Support instance. Ticket sharing accounts only',
      readOnly: true,
    },
    shared_agent: {
      type: 'boolean',
      description:
        'If the user is a shared agent from a different Zendesk Support instance. Ticket sharing accounts only',
      readOnly: true,
    },
    shared_phone_number: {
      type: 'boolean',
      description: 'Whether the `phone` number is shared or not. See [Phone Number](#phone-number) below',
      nullable: true,
    },
    signature: {
      type: 'string',
      description: "The user's signature. Only agents and admins can have signatures",
    },
    suspended: {
      type: 'boolean',
      description:
        'If the agent is suspended. Tickets from suspended users are also suspended, and these users cannot sign in to the end user portal',
    },
    tags: {
      type: 'array',
      description: "The user's tags. Only present if your account has user tagging enabled",
      items: {
        type: 'string',
      },
    },
    ticket_restriction: {
      type: 'string',
      description:
        'Specifies which tickets the user has access to. Possible values are: "organization", "groups", "assigned", "requested", null. "groups" and "assigned" are valid only for agents. If you pass an invalid value to an end user (for example, "groups"), they will be assigned to "requested", regardless of their previous access',
      nullable: true,
    },
    time_zone: {
      type: 'string',
      description: "The user's time zone. See [Time Zone](#time-zone)",
    },
    two_factor_auth_enabled: {
      type: 'boolean',
      description: 'If two factor authentication is enabled',
      nullable: true,
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'datetime',
      description: 'The time the user was last updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: "The user's API url",
      readOnly: true,
    },
    user_fields: {
      type: 'object',
      description: "Values of custom fields in the user's profile. See [User Fields](#user-fields)",
      additionalProperties: true,
    },
    verified: {
      type: 'boolean',
      description:
        "Any of the user's identities is verified. See [User Identities](/api-reference/ticketing/users/user_identities)",
    },
  },
  example: {
    active: true,
    alias: 'Mr. Johnny',
    created_at: '2009-07-20T22:55:29Z',
    custom_role_id: 9373643,
    details: '',
    email: 'johnny@example.com',
    external_id: 'sai989sur98w9',
    iana_time_zone: 'Pacific/Pago_Pago',
    id: 35436,
    last_login_at: '2011-05-05T10:38:52Z',
    locale: 'en-US',
    locale_id: 1,
    moderator: true,
    name: 'Johnny Agent',
    notes: 'Johnny is a nice guy!',
    only_private_comments: false,
    organization_id: 57542,
    phone: '+15551234567',
    photo: {
      content_type: 'image/png',
      content_url: 'https://company.zendesk.com/photos/my_funny_profile_pic.png',
      id: 928374,
      name: 'my_funny_profile_pic.png',
      size: 166144,
      thumbnails: [
        {
          content_type: 'image/png',
          content_url: 'https://company.zendesk.com/photos/my_funny_profile_pic_thumb.png',
          id: 928375,
          name: 'my_funny_profile_pic_thumb.png',
          size: 58298,
        },
      ],
    },
    restricted_agent: true,
    role: 'agent',
    role_type: 0,
    shared: false,
    shared_agent: false,
    signature: 'Have a nice day, Johnny',
    suspended: true,
    tags: ['enterprise', 'other_tag'],
    ticket_restriction: 'assigned',
    time_zone: 'Copenhagen',
    updated_at: '2011-05-05T10:38:52Z',
    url: 'https://company.zendesk.com/api/v2/users/35436.json',
    user_fields: {
      user_date: '2012-07-23T00:00:00Z',
      user_decimal: 5.1,
      user_dropdown: 'option_1',
    },
    verified: true,
  },
  required: ['name'],
} as const;

export const UserForEndUserSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'datetime',
      description: 'The time the user was created',
      readOnly: true,
    },
    email: {
      type: 'string',
      description:
        'The primary email address of this user. If the primary email address is not [verified](https://support.zendesk.com/hc/en-us/articles/4408886752410), the secondary email address is used',
    },
    iana_time_zone: {
      type: 'string',
      description: 'The time zone for the user',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when creating users',
      readOnly: true,
    },
    locale: {
      type: 'string',
      description: 'The locale for this user',
      readOnly: true,
    },
    locale_id: {
      type: 'integer',
      description: 'The language identifier for this user',
    },
    name: {
      type: 'string',
      description: 'The name of the user',
    },
    organization_id: {
      type: 'integer',
      description:
        "The id of the user's organization. If the user has more than one [organization memberships](/api-reference/ticketing/organizations/organization_memberships/), the id of the user's default organization. If updating, see [Organization ID](/api-reference/ticketing/users/users/#organization-id)",
    },
    phone: {
      type: 'string',
      description:
        'The primary phone number of this user. See [Phone Number](/api-reference/ticketing/users/users/#phone-number) in the Users API',
    },
    photo: {
      type: 'object',
      description:
        "The user's profile picture represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object",
      additionalProperties: true,
    },
    role: {
      type: 'string',
      description: 'The role of the user. Possible values: `"end-user"`, `"agent"`, `"admin"`',
    },
    shared_phone_number: {
      type: 'boolean',
      description:
        'Whether the `phone` number is shared or not. See [Phone Number](/api-reference/ticketing/users/users/#phone-number) in the Users API',
    },
    time_zone: {
      type: 'string',
      description: 'The time-zone of this user',
    },
    updated_at: {
      type: 'string',
      format: 'datetime',
      description: 'The time of the last update of the user',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this user',
      readOnly: true,
    },
    verified: {
      type: 'boolean',
      description:
        "Any of the user's identities is verified. See [User Identities](/api-reference/ticketing/users/user_identities)",
    },
  },
  required: ['name'],
} as const;

export const UserIdentitiesResponseSchema = {
  type: 'object',
  properties: {
    identities: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/UserIdentityObject',
      },
    },
  },
} as const;

export const UserIdentityObjectSchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the identity was created',
      readOnly: true,
    },
    deliverable_state: {
      type: 'string',
      description:
        'Email identity type only. Indicates if Zendesk sends notifications to the email address. See [Deliverable state](#deliverable-state)',
      readOnly: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned on creation',
      readOnly: true,
    },
    primary: {
      type: 'boolean',
      description:
        'If the identity is the primary identity. *Writable only when creating, not when updating. Use the [Make Identity Primary](#make-identity-primary) endpoint instead',
    },
    type: {
      type: 'string',
      description: 'The type of this identity',
      enum: [
        'email',
        'twitter',
        'facebook',
        'google',
        'phone_number',
        'agent_forwarding',
        'any_channel',
        'foreign',
        'sdk',
      ],
      readOnly: true,
    },
    undeliverable_count: {
      type: 'integer',
      description: 'The number of times a soft-bounce response was received at that address',
      readOnly: true,
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the identity was updated',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of this identity',
      readOnly: true,
    },
    user_id: {
      type: 'integer',
      description: 'The id of the user',
      readOnly: true,
    },
    value: {
      type: 'string',
      description: 'The identifier for this identity, such as an email address',
      readOnly: true,
    },
    verified: {
      type: 'boolean',
      description: 'If the identity has been verified',
    },
  },
  example: {
    created_at: '2011-07-20T22:55:29Z',
    deliverable_state: 'deliverable',
    id: 35436,
    primary: true,
    type: 'email',
    updated_at: '2011-07-20T22:55:29Z',
    url: 'https://company.zendesk.com/api/v2/users/135/identities/35436.json',
    user_id: 135,
    value: 'someone@example.com',
    verified: true,
  },
  required: ['user_id', 'type', 'value'],
} as const;

export const UserIdentityResponseSchema = {
  type: 'object',
  properties: {
    identity: {
      $ref: '#/components/schemas/UserIdentityObject',
    },
  },
} as const;

export const UserInputSchema = {
  anyOf: [
    {
      $ref: '#/components/schemas/UserCreateInput',
    },
    {
      $ref: '#/components/schemas/UserMergePropertiesInput',
    },
    {
      $ref: '#/components/schemas/UserMergeByIdInput',
    },
  ],
  additionalProperties: true,
} as const;

export const UserMergeByIdInputSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'integer',
    },
  },
} as const;

export const UserMergePropertiesInputSchema = {
  type: 'object',
  properties: {
    email: {
      type: 'string',
    },
    name: {
      type: 'string',
    },
    organization_id: {
      type: 'integer',
    },
    password: {
      type: 'string',
    },
  },
} as const;

export const UserObjectSchema = {
  anyOf: [
    {
      $ref: '#/components/schemas/UserForAdmin',
    },
    {
      $ref: '#/components/schemas/UserForEndUser',
    },
  ],
  additionalProperties: true,
} as const;

export const UserPasswordRequirementsResponseSchema = {
  type: 'object',
  properties: {
    requirements: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
  },
} as const;

export const UserRelatedObjectSchema = {
  type: 'object',
  properties: {
    assigned_tickets: {
      type: 'integer',
      description: 'Count of assigned tickets',
    },
    ccd_tickets: {
      type: 'integer',
      description: 'Count of collaborated tickets',
    },
    organization_subscriptions: {
      type: 'integer',
      description: 'Count of organization subscriptions',
    },
    requested_tickets: {
      type: 'integer',
      description: 'Count of requested tickets',
    },
  },
} as const;

export const UserRelatedResponseSchema = {
  type: 'object',
  properties: {
    user_related: {
      $ref: '#/components/schemas/UserRelatedObject',
    },
  },
} as const;

export const UserRequestSchema = {
  type: 'object',
  properties: {
    user: {
      $ref: '#/components/schemas/UserInput',
    },
  },
  required: ['user'],
} as const;

export const UserResponseSchema = {
  type: 'object',
  properties: {
    user: {
      $ref: '#/components/schemas/UserObject',
    },
  },
} as const;

export const UsersRequestSchema = {
  type: 'object',
  properties: {
    users: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/UserInput',
      },
    },
  },
  required: ['users'],
} as const;

export const UsersResponseSchema = {
  type: 'object',
  properties: {
    users: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/UserObject',
      },
    },
  },
} as const;

export const ViaObjectSchema = {
  type: 'object',
  description: `An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)
`,
  properties: {
    channel: {
      type: 'string',
      description: `This tells you how the ticket or event was created. Examples: "web", "mobile", "rule", "system"
`,
    },
    source: {
      type: 'object',
      description: `For some channels a source object gives more information about how or why the ticket or event was created
`,
      properties: {
        from: {
          type: 'object',
          properties: {
            address: {
              type: 'string',
              nullable: true,
            },
            id: {
              type: 'integer',
              nullable: true,
            },
            name: {
              type: 'string',
              nullable: true,
            },
            title: {
              type: 'string',
              nullable: true,
            },
          },
        },
        rel: {
          type: 'string',
          nullable: true,
        },
        to: {
          type: 'object',
          properties: {
            address: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
          },
        },
      },
      additionalProperties: true,
    },
  },
  example: {
    channel: 'rule',
    source: {
      from: {
        id: 22472716,
        title: 'Assign to first responder',
      },
      rel: 'trigger',
      to: {},
    },
  },
  readOnly: true,
} as const;

export const ViewCategoriesResponseSchema = {
  type: 'object',
  properties: {
    view_categories: {
      type: 'array',
      items: {
        type: 'object',
        allOf: [
          {
            $ref: '#/components/schemas/ViewCategory',
          },
        ],
      },
    },
  },
} as const;

export const ViewCategorySchema = {
  type: 'object',
  properties: {
    created_at: {
      type: 'string',
      description: 'The time the view category was created',
      readOnly: true,
    },
    id: {
      type: 'string',
      description: 'Automatically assigned when a view category is created',
      readOnly: true,
    },
    name: {
      type: 'string',
      description: 'The name of the view category',
    },
    position: {
      type: 'integer',
      format: 'int64',
      description: 'Position of the view category. Determines the order in which it will be displayed',
    },
    updated_at: {
      type: 'string',
      description: 'The time of the last update of the view category',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The url of the view category',
      readOnly: true,
    },
  },
} as const;

export const ViewCategoryErrorSchema = {
  type: 'object',
  properties: {
    code: {
      type: 'string',
    },
    detail: {
      type: 'string',
    },
    id: {
      type: 'string',
    },
    links: {
      type: 'object',
    },
    source: {
      type: 'object',
    },
    status: {
      type: 'string',
    },
    title: {
      type: 'string',
    },
  },
  required: ['code', 'title'],
} as const;

export const ViewCategoryErrorsSchema = {
  type: 'object',
  properties: {
    errors: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ViewCategoryError',
      },
    },
  },
} as const;

export const ViewCategoryRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
    },
  },
} as const;

export const ViewCategoryRequestRequiredSchema = {
  type: 'object',
  required: ['name'],
} as const;

export const ViewCategoryResponseSchema = {
  type: 'object',
  properties: {
    view_category: {
      $ref: '#/components/schemas/ViewCategory',
    },
  },
} as const;

export const ViewCountObjectSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'Only active views if true, inactive views if false, all views if null.',
      readOnly: true,
    },
    fresh: {
      type: 'boolean',
      description: 'false if the cached data is stale and the system is still loading and caching new data',
      readOnly: true,
    },
    pretty: {
      type: 'string',
      description: 'A pretty-printed text approximation of the view count',
      readOnly: true,
    },
    url: {
      type: 'string',
      description: 'The API url of the count',
      readOnly: true,
    },
    value: {
      type: 'integer',
      description:
        'The cached number of tickets in the view. Can also be null if the system is loading and caching new data. Not to be confused with 0 tickets',
      nullable: true,
      readOnly: true,
    },
    view_id: {
      type: 'integer',
      description: 'The id of the view',
      readOnly: true,
    },
  },
} as const;

export const ViewCountResponseSchema = {
  type: 'object',
  properties: {
    view_count: {
      $ref: '#/components/schemas/ViewCountObject',
    },
  },
} as const;

export const ViewCountsResponseSchema = {
  type: 'object',
  properties: {
    view_counts: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ViewCountObject',
      },
    },
  },
} as const;

export const ViewExportResponseSchema = {
  type: 'object',
  properties: {
    export: {
      type: 'object',
      properties: {
        status: {
          type: 'string',
          readOnly: true,
        },
        view_id: {
          type: 'integer',
          readOnly: true,
        },
      },
    },
  },
} as const;

export const ViewObjectSchema = {
  type: 'object',
  properties: {
    active: {
      type: 'boolean',
      description: 'Whether the view is active',
    },
    conditions: {
      type: 'object',
      description:
        'Describes how the view is constructed. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)',
      additionalProperties: true,
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the view was created',
      readOnly: true,
    },
    default: {
      type: 'boolean',
      description: 'If true, the view is a default view',
      readOnly: true,
    },
    description: {
      type: 'string',
      description: 'The description of the view',
    },
    execution: {
      type: 'object',
      description: 'Describes how the view should be executed. See [Execution](#execution)',
      additionalProperties: true,
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned when created',
      readOnly: true,
    },
    position: {
      type: 'integer',
      description: 'The position of the view',
    },
    restriction: {
      type: 'object',
      description: 'Who may access this account. Is null when everyone in the account can access it',
      additionalProperties: true,
    },
    title: {
      type: 'string',
      description: 'The title of the view',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the view was last updated',
      readOnly: true,
    },
  },
  example: {
    active: true,
    conditions: {
      all: [
        {
          field: 'status',
          operator: 'less_than',
          value: 'solved',
        },
        {
          field: 'assignee_id',
          operator: 'is',
          value: '296220096',
        },
      ],
      any: [],
    },
    default: false,
    description: 'View for recent tickets',
    execution: {
      columns: [
        {
          id: 'status',
          title: 'Status',
        },
        {
          id: 'updated',
          title: 'Updated',
        },
        {
          id: 5,
          title: 'Account',
          type: 'text',
          url: 'https://example.zendesk.com/api/v2/ticket_fields/5.json',
        },
      ],
      group: {
        id: 'status',
        order: 'desc',
        title: 'Status',
      },
      sort: {
        id: 'updated',
        order: 'desc',
        title: 'Updated',
      },
    },
    id: 25,
    position: 8,
    restriction: {
      id: 4,
      type: 'User',
    },
    title: 'Tickets updated <12 Hours',
  },
} as const;

export const ViewResponseSchema = {
  type: 'object',
  properties: {
    columns: {
      type: 'array',
      items: {
        type: 'object',
        additionalProperties: true,
      },
    },
    groups: {
      type: 'array',
      items: {
        type: 'object',
        additionalProperties: true,
      },
    },
    rows: {
      type: 'array',
      items: {
        type: 'object',
        additionalProperties: true,
      },
    },
    view: {
      $ref: '#/components/schemas/ViewObject',
    },
  },
} as const;

export const ViewsCountResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'object',
      properties: {
        refreshed_at: {
          type: 'string',
          format: 'date-time',
        },
        value: {
          type: 'integer',
        },
      },
    },
  },
} as const;

export const ViewsResponseSchema = {
  type: 'object',
  properties: {
    count: {
      type: 'integer',
      readOnly: true,
    },
    next_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    previous_page: {
      type: 'string',
      nullable: true,
      readOnly: true,
    },
    views: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ViewObject',
      },
    },
  },
} as const;

export const WorkspaceInputSchema = {
  type: 'object',
  properties: {
    conditions: {
      $ref: '#/components/schemas/ConditionsObject',
    },
    description: {
      type: 'string',
      description: "User-defined description of this workspace's purpose",
    },
    macros: {
      type: 'array',
      items: {
        type: 'number',
      },
    },
    ticket_form_id: {
      type: 'number',
    },
    title: {
      type: 'string',
      description: 'The title of the workspace',
    },
  },
} as const;

export const WorkspaceObjectSchema = {
  type: 'object',
  properties: {
    activated: {
      type: 'boolean',
      description: 'If true, this workspace is available for use',
    },
    apps: {
      type: 'array',
      description: 'The apps associated to this workspace',
      items: {
        type: 'object',
        additionalProperties: true,
      },
    },
    conditions: {
      $ref: '#/components/schemas/ConditionsObject',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time the workspace was created',
    },
    description: {
      type: 'string',
      description: "User-defined description of this workspace's purpose",
    },
    id: {
      type: 'integer',
      description: 'Automatically assigned upon creation',
    },
    macro_ids: {
      type: 'array',
      description: 'The ids of the macros associated to this workspace',
      items: {
        type: 'integer',
      },
    },
    macros: {
      type: 'array',
      description: 'The ids of the macros associated to this workspace',
      items: {
        type: 'integer',
      },
    },
    position: {
      type: 'integer',
      description: 'Ordering of the workspace relative to other workspaces',
    },
    prefer_workspace_app_order: {
      type: 'boolean',
      description: 'If true, the order of apps within the workspace will be preserved',
    },
    selected_macros: {
      type: 'array',
      description:
        'An array of the macro objects that will be used in this workspace. See [Macros](/api-reference/ticketing/business-rules/macros/)',
      items: {
        $ref: '#/components/schemas/MacroObject',
      },
    },
    ticket_form_id: {
      type: 'integer',
      description: 'The id of the ticket web form associated to this workspace',
    },
    title: {
      type: 'string',
      description: 'The title of the workspace',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      description: 'The time of the last update of the workspace',
    },
    url: {
      type: 'string',
      description: 'The URL for this resource',
    },
  },
} as const;

export const WorkspaceResponseSchema = {
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        workspaces: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/WorkspaceObject',
          },
        },
      },
    },
    {
      $ref: '#/components/schemas/OffsetPaginationObject',
    },
  ],
} as const;
