// Generated by ts-to-zod
import { z } from 'zod';

import {
  type Allocation,
  type CreditNote,
  type Invoice,
  type Overpayment,
  type Prepayment,
  type Allocations,
  type BankTransaction,
  type Contact,
  type BankTransactions,
  type BatchPayment,
  type Payment,
  type BatchPayments,
  type ContactGroup,
  type ContactGroups,
  type Contacts,
  type CreditNotes,
  type ExpenseClaim,
  type Receipt,
  type ExpenseClaims,
  type Invoices,
  type Overpayments,
  type Payments,
  type Prepayments,
  type PurchaseOrder,
  type PurchaseOrders,
  type Quote,
  type Quotes,
  type Receipts,
  type RepeatingInvoice,
  type RepeatingInvoices,
  type GetBankTransactionsResponse,
  type UpdateOrCreateBankTransactionsData,
  type UpdateOrCreateBankTransactionsResponse,
  type CreateBankTransactionsData,
  type CreateBankTransactionsResponse,
  type GetBankTransactionResponse,
  type UpdateBankTransactionData,
  type UpdateBankTransactionResponse,
  type GetBatchPaymentsResponse,
  type CreateBatchPaymentData,
  type CreateBatchPaymentResponse,
  type GetContactGroupsResponse,
  type CreateContactGroupData,
  type CreateContactGroupResponse,
  type GetContactGroupResponse,
  type UpdateContactGroupData,
  type UpdateContactGroupResponse,
  type CreateContactGroupContactsData,
  type CreateContactGroupContactsResponse,
  type GetContactsResponse,
  type UpdateOrCreateContactsData,
  type UpdateOrCreateContactsResponse,
  type CreateContactsData,
  type CreateContactsResponse,
  type GetContactResponse,
  type UpdateContactData,
  type UpdateContactResponse,
  type GetContactByContactNumberResponse,
  type GetCreditNotesResponse,
  type UpdateOrCreateCreditNotesData,
  type UpdateOrCreateCreditNotesResponse,
  type CreateCreditNotesData,
  type CreateCreditNotesResponse,
  type GetCreditNoteResponse,
  type UpdateCreditNoteData,
  type UpdateCreditNoteResponse,
  type CreateCreditNoteAllocationData,
  type CreateCreditNoteAllocationResponse,
  type GetExpenseClaimsResponse,
  type CreateExpenseClaimsData,
  type CreateExpenseClaimsResponse,
  type GetExpenseClaimResponse,
  type UpdateExpenseClaimData,
  type UpdateExpenseClaimResponse,
  type GetInvoicesResponse,
  type UpdateOrCreateInvoicesData,
  type UpdateOrCreateInvoicesResponse,
  type CreateInvoicesData,
  type CreateInvoicesResponse,
  type GetInvoiceResponse,
  type UpdateInvoiceData,
  type UpdateInvoiceResponse,
  type GetOverpaymentsResponse,
  type GetOverpaymentResponse,
  type CreateOverpaymentAllocationsData,
  type CreateOverpaymentAllocationsResponse,
  type GetPaymentsResponse,
  type CreatePaymentData,
  type CreatePaymentResponse,
  type CreatePaymentsData,
  type CreatePaymentsResponse,
  type GetPaymentResponse,
  type DeletePaymentResponse,
  type GetPrepaymentsResponse,
  type GetPrepaymentResponse,
  type CreatePrepaymentAllocationsData,
  type CreatePrepaymentAllocationsResponse,
  type GetPurchaseOrdersResponse,
  type UpdateOrCreatePurchaseOrdersData,
  type UpdateOrCreatePurchaseOrdersResponse,
  type CreatePurchaseOrdersData,
  type CreatePurchaseOrdersResponse,
  type GetPurchaseOrderResponse,
  type UpdatePurchaseOrderData,
  type UpdatePurchaseOrderResponse,
  type GetPurchaseOrderByNumberResponse,
  type GetQuotesResponse,
  type UpdateOrCreateQuotesData,
  type UpdateOrCreateQuotesResponse,
  type CreateQuotesData,
  type CreateQuotesResponse,
  type GetQuoteResponse,
  type UpdateQuoteData,
  type UpdateQuoteResponse,
  type GetReceiptsResponse,
  type CreateReceiptData,
  type CreateReceiptResponse,
  type GetReceiptResponse,
  type UpdateReceiptData,
  type UpdateReceiptResponse,
  type GetRepeatingInvoicesResponse,
  type GetRepeatingInvoiceResponse,
} from './types.gen';

export const currencyCodeSchema = z.union([
  z.literal('AED'),
  z.literal('AFN'),
  z.literal('ALL'),
  z.literal('AMD'),
  z.literal('ANG'),
  z.literal('AOA'),
  z.literal('ARS'),
  z.literal('AUD'),
  z.literal('AWG'),
  z.literal('AZN'),
  z.literal('BAM'),
  z.literal('BBD'),
  z.literal('BDT'),
  z.literal('BGN'),
  z.literal('BHD'),
  z.literal('BIF'),
  z.literal('BMD'),
  z.literal('BND'),
  z.literal('BOB'),
  z.literal('BRL'),
  z.literal('BSD'),
  z.literal('BTN'),
  z.literal('BWP'),
  z.literal('BYN'),
  z.literal('BYR'),
  z.literal('BZD'),
  z.literal('CAD'),
  z.literal('CDF'),
  z.literal('CHF'),
  z.literal('CLP'),
  z.literal('CNY'),
  z.literal('COP'),
  z.literal('CRC'),
  z.literal('CUC'),
  z.literal('CUP'),
  z.literal('CVE'),
  z.literal('CZK'),
  z.literal('DJF'),
  z.literal('DKK'),
  z.literal('DOP'),
  z.literal('DZD'),
  z.literal('EGP'),
  z.literal('ERN'),
  z.literal('ETB'),
  z.literal('EUR'),
  z.literal('FJD'),
  z.literal('FKP'),
  z.literal('GBP'),
  z.literal('GEL'),
  z.literal('GGP'),
  z.literal('GHS'),
  z.literal('GIP'),
  z.literal('GMD'),
  z.literal('GNF'),
  z.literal('GTQ'),
  z.literal('GYD'),
  z.literal('HKD'),
  z.literal('HNL'),
  z.literal('HRK'),
  z.literal('HTG'),
  z.literal('HUF'),
  z.literal('IDR'),
  z.literal('ILS'),
  z.literal('IMP'),
  z.literal('INR'),
  z.literal('IQD'),
  z.literal('IRR'),
  z.literal('ISK'),
  z.literal('JEP'),
  z.literal('JMD'),
  z.literal('JOD'),
  z.literal('JPY'),
  z.literal('KES'),
  z.literal('KGS'),
  z.literal('KHR'),
  z.literal('KMF'),
  z.literal('KPW'),
  z.literal('KRW'),
  z.literal('KWD'),
  z.literal('KYD'),
  z.literal('KZT'),
  z.literal('LAK'),
  z.literal('LBP'),
  z.literal('LKR'),
  z.literal('LRD'),
  z.literal('LSL'),
  z.literal('LTL'),
  z.literal('LYD'),
  z.literal('MAD'),
  z.literal('MDL'),
  z.literal('MGA'),
  z.literal('MKD'),
  z.literal('MMK'),
  z.literal('MNT'),
  z.literal('MOP'),
  z.literal('MRU'),
  z.literal('MUR'),
  z.literal('MVR'),
  z.literal('MWK'),
  z.literal('MXN'),
  z.literal('MYR'),
  z.literal('MZN'),
  z.literal('NAD'),
  z.literal('NGN'),
  z.literal('NIO'),
  z.literal('NOK'),
  z.literal('NPR'),
  z.literal('NZD'),
  z.literal('OMR'),
  z.literal('PAB'),
  z.literal('PEN'),
  z.literal('PGK'),
  z.literal('PHP'),
  z.literal('PKR'),
  z.literal('PLN'),
  z.literal('PYG'),
  z.literal('QAR'),
  z.literal('RON'),
  z.literal('RSD'),
  z.literal('RUB'),
  z.literal('RWF'),
  z.literal('SAR'),
  z.literal('SBD'),
  z.literal('SCR'),
  z.literal('SDG'),
  z.literal('SEK'),
  z.literal('SGD'),
  z.literal('SHP'),
  z.literal('SLL'),
  z.literal('SOS'),
  z.literal('SPL'),
  z.literal('SRD'),
  z.literal('STN'),
  z.literal('SVC'),
  z.literal('SYP'),
  z.literal('SZL'),
  z.literal('THB'),
  z.literal('TJS'),
  z.literal('TMT'),
  z.literal('TND'),
  z.literal('TOP'),
  z.literal('TRY'),
  z.literal('TTD'),
  z.literal('TVD'),
  z.literal('TWD'),
  z.literal('TZS'),
  z.literal('UAH'),
  z.literal('UGX'),
  z.literal('USD'),
  z.literal('UYU'),
  z.literal('UZS'),
  z.literal('VEF'),
  z.literal('VND'),
  z.literal('VUV'),
  z.literal('WST'),
  z.literal('XAF'),
  z.literal('XCD'),
  z.literal('XDR'),
  z.literal('XOF'),
  z.literal('XPF'),
  z.literal('YER'),
  z.literal('ZAR'),
  z.literal('ZMW'),
  z.literal('ZMK'),
  z.literal('ZWD'),
  z.literal(''),
]);

export const accountTypeSchema = z.union([
  z.literal('BANK'),
  z.literal('CURRENT'),
  z.literal('CURRLIAB'),
  z.literal('DEPRECIATN'),
  z.literal('DIRECTCOSTS'),
  z.literal('EQUITY'),
  z.literal('EXPENSE'),
  z.literal('FIXED'),
  z.literal('INVENTORY'),
  z.literal('LIABILITY'),
  z.literal('NONCURRENT'),
  z.literal('OTHERINCOME'),
  z.literal('OVERHEADS'),
  z.literal('PREPAYMENT'),
  z.literal('REVENUE'),
  z.literal('SALES'),
  z.literal('TERMLIAB'),
  z.literal('PAYGLIABILITY'),
  z.literal('PAYG'),
  z.literal('SUPERANNUATIONEXPENSE'),
  z.literal('SUPERANNUATIONLIABILITY'),
  z.literal('WAGESEXPENSE'),
]);

export const validationErrorSchema = z.object({
  Message: z.string().optional(),
});

export const bankAccountTypeSchema = z.union([
  z.literal('BANK'),
  z.literal('CREDITCARD'),
  z.literal('PAYPAL'),
  z.literal('NONE'),
  z.literal(''),
]);

export const classSchema = z.union([
  z.literal('ASSET'),
  z.literal('EQUITY'),
  z.literal('EXPENSE'),
  z.literal('LIABILITY'),
  z.literal('REVENUE'),
]);

export const statusSchema = z.union([z.literal('ACTIVE'), z.literal('ARCHIVED'), z.literal('DELETED')]);

export const systemAccountSchema = z.union([
  z.literal('DEBTORS'),
  z.literal('CREDITORS'),
  z.literal('BANKCURRENCYGAIN'),
  z.literal('GST'),
  z.literal('GSTONIMPORTS'),
  z.literal('HISTORICAL'),
  z.literal('REALISEDCURRENCYGAIN'),
  z.literal('RETAINEDEARNINGS'),
  z.literal('ROUNDING'),
  z.literal('TRACKINGTRANSFERS'),
  z.literal('UNPAIDEXPCLM'),
  z.literal('UNREALISEDCURRENCYGAIN'),
  z.literal('WAGEPAYABLES'),
  z.literal('CISASSETS'),
  z.literal('CISASSET'),
  z.literal('CISLABOUR'),
  z.literal('CISLABOUREXPENSE'),
  z.literal('CISLABOURINCOME'),
  z.literal('CISLIABILITY'),
  z.literal('CISMATERIALS'),
  z.literal(''),
]);

export const accountSchema = z.object({
  AccountID: z.string().optional(),
  AddToWatchlist: z.boolean().optional(),
  BankAccountNumber: z.string().optional(),
  BankAccountType: z
    .union([z.literal('BANK'), z.literal('CREDITCARD'), z.literal('PAYPAL'), z.literal('NONE'), z.literal('')])
    .optional(),
  Class: z
    .union([
      z.literal('ASSET'),
      z.literal('EQUITY'),
      z.literal('EXPENSE'),
      z.literal('LIABILITY'),
      z.literal('REVENUE'),
    ])
    .optional(),
  Code: z.string().optional(),
  CurrencyCode: currencyCodeSchema.optional(),
  Description: z.string().optional(),
  EnablePaymentsToAccount: z.boolean().optional(),
  HasAttachments: z.boolean().optional(),
  Name: z.string().optional(),
  ReportingCode: z.string().optional(),
  ReportingCodeName: z.string().optional(),
  ShowInExpenseClaims: z.boolean().optional(),
  Status: z.union([z.literal('ACTIVE'), z.literal('ARCHIVED'), z.literal('DELETED')]).optional(),
  SystemAccount: z
    .union([
      z.literal('DEBTORS'),
      z.literal('CREDITORS'),
      z.literal('BANKCURRENCYGAIN'),
      z.literal('GST'),
      z.literal('GSTONIMPORTS'),
      z.literal('HISTORICAL'),
      z.literal('REALISEDCURRENCYGAIN'),
      z.literal('RETAINEDEARNINGS'),
      z.literal('ROUNDING'),
      z.literal('TRACKINGTRANSFERS'),
      z.literal('UNPAIDEXPCLM'),
      z.literal('UNREALISEDCURRENCYGAIN'),
      z.literal('WAGEPAYABLES'),
      z.literal('CISASSETS'),
      z.literal('CISASSET'),
      z.literal('CISLABOUR'),
      z.literal('CISLABOUREXPENSE'),
      z.literal('CISLABOURINCOME'),
      z.literal('CISLIABILITY'),
      z.literal('CISMATERIALS'),
      z.literal(''),
    ])
    .optional(),
  TaxType: z.string().optional(),
  Type: accountTypeSchema.optional(),
  UpdatedDateUTC: z.string().optional(),
  ValidationErrors: z.array(validationErrorSchema).optional(),
});

export const accountsPayableSchema = z.object({
  Outstanding: z.number().optional(),
  Overdue: z.number().optional(),
});

export const accountsReceivableSchema = z.object({
  Outstanding: z.number().optional(),
  Overdue: z.number().optional(),
});

export const actionSchema = z.object({
  Name: z.string().optional(),
  Status: z.union([z.literal('ALLOWED'), z.literal('NOT-ALLOWED')]).optional(),
});

export const status2Schema = z.union([z.literal('ALLOWED'), z.literal('NOT-ALLOWED')]);

export const actionsSchema = z.object({
  Actions: z.array(actionSchema).optional(),
});

export const addressSchema = z.object({
  AddressLine1: z.string().optional(),
  AddressLine2: z.string().optional(),
  AddressLine3: z.string().optional(),
  AddressLine4: z.string().optional(),
  AddressType: z.union([z.literal('POBOX'), z.literal('STREET')]).optional(),
  AttentionTo: z.string().optional(),
  City: z.string().optional(),
  Country: z.string().optional(),
  PostalCode: z.string().optional(),
  Region: z.string().optional(),
});

export const addressTypeSchema = z.union([z.literal('POBOX'), z.literal('STREET')]);

export const addressForOrganisationSchema = z.object({
  AddressLine1: z.string().optional(),
  AddressLine2: z.string().optional(),
  AddressLine3: z.string().optional(),
  AddressLine4: z.string().optional(),
  AddressType: z.union([z.literal('POBOX'), z.literal('STREET'), z.literal('DELIVERY')]).optional(),
  AttentionTo: z.string().optional(),
  City: z.string().optional(),
  Country: z.string().optional(),
  PostalCode: z.string().optional(),
  Region: z.string().optional(),
});

export const addressType2Schema = z.union([z.literal('POBOX'), z.literal('STREET'), z.literal('DELIVERY')]);

export const attachmentSchema = z.object({
  AttachmentID: z.string().optional(),
  ContentLength: z.number().optional(),
  FileName: z.string().optional(),
  IncludeOnline: z.boolean().optional(),
  MimeType: z.string().optional(),
  Url: z.string().optional(),
});

export const attachmentsSchema = z.object({
  Attachments: z.array(attachmentSchema).optional(),
});

export const balanceDetailsSchema = z.object({
  Balance: z.number().optional(),
  CurrencyCode: z.string().optional(),
  CurrencyRate: z.number().optional(),
});

export const balancesSchema = z.object({
  AccountsPayable: accountsPayableSchema.optional(),
  AccountsReceivable: accountsReceivableSchema.optional(),
});

export const lineAmountTypesSchema = z.union([z.literal('Exclusive'), z.literal('Inclusive'), z.literal('NoTax')]);

export const status3Schema = z.union([z.literal('AUTHORISED'), z.literal('DELETED'), z.literal('VOIDED')]);

export const typeSchema = z.union([
  z.literal('RECEIVE'),
  z.literal('RECEIVE-OVERPAYMENT'),
  z.literal('RECEIVE-PREPAYMENT'),
  z.literal('SPEND'),
  z.literal('SPEND-OVERPAYMENT'),
  z.literal('SPEND-PREPAYMENT'),
  z.literal('RECEIVE-TRANSFER'),
  z.literal('SPEND-TRANSFER'),
]);

export const bankTransferSchema = z.object({
  Amount: z.number(),
  BankTransferID: z.string().optional(),
  CreatedDateUTC: z.string().optional(),
  CurrencyRate: z.number().optional(),
  Date: z.string().optional(),
  FromBankAccount: accountSchema,
  FromBankTransactionID: z.string().optional(),
  HasAttachments: z.boolean().optional(),
  ToBankAccount: accountSchema,
  ToBankTransactionID: z.string().optional(),
  ValidationErrors: z.array(validationErrorSchema).optional(),
});

export const bankTransfersSchema = z.object({
  BankTransfers: z.array(bankTransferSchema).optional(),
});

export const status4Schema = z.union([z.literal('AUTHORISED'), z.literal('DELETED')]);

export const type2Schema = z.union([z.literal('PAYBATCH'), z.literal('RECBATCH')]);

export const batchPaymentDetailsSchema = z.object({
  BankAccountName: z.string().optional(),
  BankAccountNumber: z.string().optional(),
  Code: z.string().optional(),
  Details: z.string().optional(),
  Reference: z.string().optional(),
});

export const paymentTermTypeSchema = z.union([
  z.literal('DAYSAFTERBILLDATE'),
  z.literal('DAYSAFTERBILLMONTH'),
  z.literal('OFCURRENTMONTH'),
  z.literal('OFFOLLOWINGMONTH'),
]);

export const brandingThemeSchema = z.object({
  BrandingThemeID: z.string().optional(),
  CreatedDateUTC: z.string().optional(),
  LogoUrl: z.string().optional(),
  Name: z.string().optional(),
  SortOrder: z.number().optional(),
  Type: z.literal('INVOICE').optional(),
});

export const type3Schema = z.literal('INVOICE');

export const brandingThemesSchema = z.object({
  BrandingThemes: z.array(brandingThemeSchema).optional(),
});

export const cISOrgSettingSchema = z.object({
  CISContractorEnabled: z.boolean().optional(),
  CISSubContractorEnabled: z.boolean().optional(),
  Rate: z.number().optional(),
});

export const cISOrgSettingsSchema = z.object({
  CISSettings: z.array(cISOrgSettingSchema).optional(),
});

export const cISSettingSchema = z.object({
  CISEnabled: z.boolean().optional(),
  Rate: z.number().optional(),
});

export const cISSettingsSchema = z.object({
  CISSettings: z.array(cISSettingSchema).optional(),
});

export const contactPersonSchema = z.object({
  EmailAddress: z.string().optional(),
  FirstName: z.string().optional(),
  IncludeInEmails: z.boolean().optional(),
  LastName: z.string().optional(),
});

export const phoneSchema = z.object({
  PhoneAreaCode: z.string().optional(),
  PhoneCountryCode: z.string().optional(),
  PhoneNumber: z.string().optional(),
  PhoneType: z
    .union([z.literal('DEFAULT'), z.literal('DDI'), z.literal('MOBILE'), z.literal('FAX'), z.literal('OFFICE')])
    .optional(),
});

export const salesTrackingCategorySchema = z.object({
  TrackingCategoryName: z.string().optional(),
  TrackingOptionName: z.string().optional(),
});

export const contactStatusSchema = z.union([z.literal('ACTIVE'), z.literal('ARCHIVED'), z.literal('GDPRREQUEST')]);

export const status5Schema = z.union([z.literal('ACTIVE'), z.literal('DELETED')]);

export const conversionBalancesSchema = z.object({
  AccountCode: z.string().optional(),
  Balance: z.number().optional(),
  BalanceDetails: z.array(balanceDetailsSchema).optional(),
});

export const conversionDateSchema = z.object({
  Month: z.number().optional(),
  Year: z.number().optional(),
});

export const countryCodeSchema = z.union([
  z.literal('AD'),
  z.literal('AE'),
  z.literal('AF'),
  z.literal('AG'),
  z.literal('AI'),
  z.literal('AL'),
  z.literal('AM'),
  z.literal('AN'),
  z.literal('AO'),
  z.literal('AQ'),
  z.literal('AR'),
  z.literal('AS'),
  z.literal('AT'),
  z.literal('AU'),
  z.literal('AW'),
  z.literal('AZ'),
  z.literal('BA'),
  z.literal('BB'),
  z.literal('BD'),
  z.literal('BE'),
  z.literal('BF'),
  z.literal('BG'),
  z.literal('BH'),
  z.literal('BI'),
  z.literal('BJ'),
  z.literal('BL'),
  z.literal('BM'),
  z.literal('BN'),
  z.literal('BO'),
  z.literal('BR'),
  z.literal('BS'),
  z.literal('BT'),
  z.literal('BW'),
  z.literal('BY'),
  z.literal('BZ'),
  z.literal('CA'),
  z.literal('CC'),
  z.literal('CD'),
  z.literal('CF'),
  z.literal('CG'),
  z.literal('CH'),
  z.literal('CI'),
  z.literal('CK'),
  z.literal('CL'),
  z.literal('CM'),
  z.literal('CN'),
  z.literal('CO'),
  z.literal('CR'),
  z.literal('CU'),
  z.literal('CV'),
  z.literal('CW'),
  z.literal('CX'),
  z.literal('CY'),
  z.literal('CZ'),
  z.literal('DE'),
  z.literal('DJ'),
  z.literal('DK'),
  z.literal('DM'),
  z.literal('DO'),
  z.literal('DZ'),
  z.literal('EC'),
  z.literal('EE'),
  z.literal('EG'),
  z.literal('EH'),
  z.literal('ER'),
  z.literal('ES'),
  z.literal('ET'),
  z.literal('FI'),
  z.literal('FJ'),
  z.literal('FK'),
  z.literal('FM'),
  z.literal('FO'),
  z.literal('FR'),
  z.literal('GA'),
  z.literal('GB'),
  z.literal('GD'),
  z.literal('GE'),
  z.literal('GG'),
  z.literal('GH'),
  z.literal('GI'),
  z.literal('GL'),
  z.literal('GM'),
  z.literal('GN'),
  z.literal('GQ'),
  z.literal('GR'),
  z.literal('GT'),
  z.literal('GU'),
  z.literal('GW'),
  z.literal('GY'),
  z.literal('HK'),
  z.literal('HN'),
  z.literal('HR'),
  z.literal('HT'),
  z.literal('HU'),
  z.literal('ID'),
  z.literal('IE'),
  z.literal('IL'),
  z.literal('IM'),
  z.literal('IN'),
  z.literal('IO'),
  z.literal('IQ'),
  z.literal('IR'),
  z.literal('IS'),
  z.literal('IT'),
  z.literal('JE'),
  z.literal('JM'),
  z.literal('JO'),
  z.literal('JP'),
  z.literal('KE'),
  z.literal('KG'),
  z.literal('KH'),
  z.literal('KI'),
  z.literal('KM'),
  z.literal('KN'),
  z.literal('KP'),
  z.literal('KR'),
  z.literal('KW'),
  z.literal('KY'),
  z.literal('KZ'),
  z.literal('LA'),
  z.literal('LB'),
  z.literal('LC'),
  z.literal('LI'),
  z.literal('LK'),
  z.literal('LR'),
  z.literal('LS'),
  z.literal('LT'),
  z.literal('LU'),
  z.literal('LV'),
  z.literal('LY'),
  z.literal('MA'),
  z.literal('MC'),
  z.literal('MD'),
  z.literal('ME'),
  z.literal('MF'),
  z.literal('MG'),
  z.literal('MH'),
  z.literal('MK'),
  z.literal('ML'),
  z.literal('MM'),
  z.literal('MN'),
  z.literal('MO'),
  z.literal('MP'),
  z.literal('MR'),
  z.literal('MS'),
  z.literal('MT'),
  z.literal('MU'),
  z.literal('MV'),
  z.literal('MW'),
  z.literal('MX'),
  z.literal('MY'),
  z.literal('MZ'),
  z.literal('NA'),
  z.literal('NC'),
  z.literal('NE'),
  z.literal('NG'),
  z.literal('NI'),
  z.literal('NL'),
  z.literal('NO'),
  z.literal('NP'),
  z.literal('NR'),
  z.literal('NU'),
  z.literal('NZ'),
  z.literal('OM'),
  z.literal('PA'),
  z.literal('PE'),
  z.literal('PF'),
  z.literal('PG'),
  z.literal('PH'),
  z.literal('PK'),
  z.literal('PL'),
  z.literal('PM'),
  z.literal('PN'),
  z.literal('PR'),
  z.literal('PS'),
  z.literal('PT'),
  z.literal('PW'),
  z.literal('PY'),
  z.literal('QA'),
  z.literal('RE'),
  z.literal('RO'),
  z.literal('RS'),
  z.literal('RU'),
  z.literal('RW'),
  z.literal('SA'),
  z.literal('SB'),
  z.literal('SC'),
  z.literal('SD'),
  z.literal('SE'),
  z.literal('SG'),
  z.literal('SH'),
  z.literal('SI'),
  z.literal('SJ'),
  z.literal('SK'),
  z.literal('SL'),
  z.literal('SM'),
  z.literal('SN'),
  z.literal('SO'),
  z.literal('SR'),
  z.literal('SS'),
  z.literal('ST'),
  z.literal('SV'),
  z.literal('SX'),
  z.literal('SY'),
  z.literal('SZ'),
  z.literal('TC'),
  z.literal('TD'),
  z.literal('TG'),
  z.literal('TH'),
  z.literal('TJ'),
  z.literal('TK'),
  z.literal('TL'),
  z.literal('TM'),
  z.literal('TN'),
  z.literal('TO'),
  z.literal('TR'),
  z.literal('TT'),
  z.literal('TV'),
  z.literal('TW'),
  z.literal('TZ'),
  z.literal('UA'),
  z.literal('UG'),
  z.literal('US'),
  z.literal('UY'),
  z.literal('UZ'),
  z.literal('VA'),
  z.literal('VC'),
  z.literal('VE'),
  z.literal('VG'),
  z.literal('VI'),
  z.literal('VN'),
  z.literal('VU'),
  z.literal('WF'),
  z.literal('WS'),
  z.literal('XK'),
  z.literal('YE'),
  z.literal('YT'),
  z.literal('ZA'),
  z.literal('ZM'),
  z.literal('ZW'),
]);

export const status6Schema = z.union([
  z.literal('DRAFT'),
  z.literal('SUBMITTED'),
  z.literal('DELETED'),
  z.literal('AUTHORISED'),
  z.literal('PAID'),
  z.literal('VOIDED'),
]);

export const type4Schema = z.union([z.literal('ACCPAYCREDIT'), z.literal('ACCRECCREDIT')]);

export const currencySchema = z.object({
  Code: currencyCodeSchema.optional(),
  Description: z.string().optional(),
});

export const elementSchema = z.object({
  BankTransactionID: z.string().optional(),
  BatchPaymentID: z.string().optional(),
  ContactID: z.string().optional(),
  CreditNoteID: z.string().optional(),
  InvoiceID: z.string().optional(),
  ItemID: z.string().optional(),
  PurchaseOrderID: z.string().optional(),
  ValidationErrors: z.array(validationErrorSchema).optional(),
});

export const externalLinkSchema = z.object({
  Description: z.string().optional(),
  LinkType: z
    .union([
      z.literal('Facebook'),
      z.literal('GooglePlus'),
      z.literal('LinkedIn'),
      z.literal('Twitter'),
      z.literal('Website'),
    ])
    .optional(),
  Url: z.string().optional(),
});

export const status7Schema = z.union([
  z.literal('ACTIVE'),
  z.literal('ARCHIVED'),
  z.literal('GDPRREQUEST'),
  z.literal('DELETED'),
]);

export const employeeSchema = z.object({
  EmployeeID: z.string().optional(),
  ExternalLink: externalLinkSchema.optional(),
  FirstName: z.string().optional(),
  LastName: z.string().optional(),
  Status: z
    .union([z.literal('ACTIVE'), z.literal('ARCHIVED'), z.literal('GDPRREQUEST'), z.literal('DELETED')])
    .optional(),
  StatusAttributeString: z.string().optional(),
  UpdatedDateUTC: z.string().optional(),
  ValidationErrors: z.array(validationErrorSchema).optional(),
});

export const errorSchema = z.object({
  Elements: z.array(elementSchema).optional(),
  ErrorNumber: z.number().optional(),
  Message: z.string().optional(),
  Type: z.string().optional(),
});

export const userSchema = z.object({
  EmailAddress: z.string().optional(),
  FirstName: z.string().optional(),
  IsSubscriber: z.boolean().optional(),
  LastName: z.string().optional(),
  OrganisationRole: z
    .union([
      z.literal('READONLY'),
      z.literal('INVOICEONLY'),
      z.literal('STANDARD'),
      z.literal('FINANCIALADVISER'),
      z.literal('MANAGEDCLIENT'),
      z.literal('CASHBOOKCLIENT'),
      z.literal('UNKNOWN'),
    ])
    .optional(),
  UpdatedDateUTC: z.string().optional(),
  UserID: z.string().optional(),
});

export const status8Schema = z.union([
  z.literal('SUBMITTED'),
  z.literal('AUTHORISED'),
  z.literal('PAID'),
  z.literal('VOIDED'),
  z.literal('DELETED'),
]);

export const linkTypeSchema = z.union([
  z.literal('Facebook'),
  z.literal('GooglePlus'),
  z.literal('LinkedIn'),
  z.literal('Twitter'),
  z.literal('Website'),
]);

export const historyRecordSchema = z.object({
  Changes: z.string().optional(),
  DateUTC: z.string().optional(),
  Details: z.string().optional(),
  User: z.string().optional(),
});

export const historyRecordsSchema = z.object({
  HistoryRecords: z.array(historyRecordSchema).optional(),
});

export const importSummaryAccountsSchema = z.object({
  Deleted: z.number().optional(),
  Errored: z.number().optional(),
  Locked: z.number().optional(),
  New: z.number().optional(),
  NewOrUpdated: z.number().optional(),
  Present: z.boolean().optional(),
  System: z.number().optional(),
  Total: z.number().optional(),
  Updated: z.number().optional(),
});

export const importSummaryOrganisationSchema = z.object({
  Present: z.boolean().optional(),
});

export const importSummarySchema = z.object({
  Accounts: importSummaryAccountsSchema.optional(),
  Organisation: importSummaryOrganisationSchema.optional(),
});

export const type5Schema = z.union([
  z.literal('ACCPAY'),
  z.literal('ACCPAYCREDIT'),
  z.literal('APOVERPAYMENT'),
  z.literal('APPREPAYMENT'),
  z.literal('ACCREC'),
  z.literal('ACCRECCREDIT'),
  z.literal('AROVERPAYMENT'),
  z.literal('ARPREPAYMENT'),
]);

export const invoiceReminderSchema = z.object({
  Enabled: z.boolean().optional(),
});

export const invoiceRemindersSchema = z.object({
  InvoiceReminders: z.array(invoiceReminderSchema).optional(),
});

export const purchaseSchema = z.object({
  AccountCode: z.string().optional(),
  COGSAccountCode: z.string().optional(),
  TaxType: z.string().optional(),
  UnitPrice: z.number().optional(),
});

export const itemSchema = z.object({
  Code: z.string(),
  Description: z.string().optional(),
  InventoryAssetAccountCode: z.string().optional(),
  IsPurchased: z.boolean().optional(),
  IsSold: z.boolean().optional(),
  IsTrackedAsInventory: z.boolean().optional(),
  ItemID: z.string().optional(),
  Name: z.string().optional(),
  PurchaseDescription: z.string().optional(),
  PurchaseDetails: purchaseSchema.optional(),
  QuantityOnHand: z.number().optional(),
  SalesDetails: purchaseSchema.optional(),
  StatusAttributeString: z.string().optional(),
  TotalCostPool: z.number().optional(),
  UpdatedDateUTC: z.string().optional(),
  ValidationErrors: z.array(validationErrorSchema).optional(),
});

export const sourceTypeSchema = z.union([
  z.literal('ACCREC'),
  z.literal('ACCPAY'),
  z.literal('ACCRECCREDIT'),
  z.literal('ACCPAYCREDIT'),
  z.literal('ACCRECPAYMENT'),
  z.literal('ACCPAYPAYMENT'),
  z.literal('ARCREDITPAYMENT'),
  z.literal('APCREDITPAYMENT'),
  z.literal('CASHREC'),
  z.literal('CASHPAID'),
  z.literal('TRANSFER'),
  z.literal('ARPREPAYMENT'),
  z.literal('APPREPAYMENT'),
  z.literal('AROVERPAYMENT'),
  z.literal('APOVERPAYMENT'),
  z.literal('EXPCLAIM'),
  z.literal('EXPPAYMENT'),
  z.literal('MANJOURNAL'),
  z.literal('PAYSLIP'),
  z.literal('WAGEPAYABLE'),
  z.literal('INTEGRATEDPAYROLLPE'),
  z.literal('INTEGRATEDPAYROLLPT'),
  z.literal('EXTERNALSPENDMONEY'),
  z.literal('INTEGRATEDPAYROLLPTPAYMENT'),
  z.literal('INTEGRATEDPAYROLLCN'),
]);

export const lineItemTrackingSchema = z.object({
  Name: z.string().optional(),
  Option: z.string().optional(),
  TrackingCategoryID: z.string().optional(),
  TrackingOptionID: z.string().optional(),
});

export const linkedTransactionSchema = z.object({
  ContactID: z.string().optional(),
  LinkedTransactionID: z.string().optional(),
  SourceLineItemID: z.string().optional(),
  SourceTransactionID: z.string().optional(),
  SourceTransactionTypeCode: z.union([z.literal('ACCPAY'), z.literal('SPEND')]).optional(),
  Status: z
    .union([z.literal('APPROVED'), z.literal('DRAFT'), z.literal('ONDRAFT'), z.literal('BILLED'), z.literal('VOIDED')])
    .optional(),
  TargetLineItemID: z.string().optional(),
  TargetTransactionID: z.string().optional(),
  Type: z.literal('BILLABLEEXPENSE').optional(),
  UpdatedDateUTC: z.string().optional(),
  ValidationErrors: z.array(validationErrorSchema).optional(),
});

export const sourceTransactionTypeCodeSchema = z.union([z.literal('ACCPAY'), z.literal('SPEND')]);

export const status9Schema = z.union([
  z.literal('APPROVED'),
  z.literal('DRAFT'),
  z.literal('ONDRAFT'),
  z.literal('BILLED'),
  z.literal('VOIDED'),
]);

export const type6Schema = z.literal('BILLABLEEXPENSE');

export const linkedTransactionsSchema = z.object({
  LinkedTransactions: z.array(linkedTransactionSchema).optional(),
});

export const status10Schema = z.union([
  z.literal('DRAFT'),
  z.literal('POSTED'),
  z.literal('DELETED'),
  z.literal('VOIDED'),
  z.literal('ARCHIVED'),
]);

export const onlineInvoiceSchema = z.object({
  OnlineInvoiceUrl: z.string().optional(),
});

export const onlineInvoicesSchema = z.object({
  OnlineInvoices: z.array(onlineInvoiceSchema).optional(),
});

export const timeZoneSchema = z.union([
  z.literal('MOROCCOSTANDARDTIME'),
  z.literal('UTC'),
  z.literal('GMTSTANDARDTIME'),
  z.literal('GREENWICHSTANDARDTIME'),
  z.literal('WEUROPESTANDARDTIME'),
  z.literal('CENTRALEUROPESTANDARDTIME'),
  z.literal('ROMANCESTANDARDTIME'),
  z.literal('CENTRALEUROPEANSTANDARDTIME'),
  z.literal('WCENTRALAFRICASTANDARDTIME'),
  z.literal('NAMIBIASTANDARDTIME'),
  z.literal('JORDANSTANDARDTIME'),
  z.literal('GTBSTANDARDTIME'),
  z.literal('MIDDLEEASTSTANDARDTIME'),
  z.literal('EGYPTSTANDARDTIME'),
  z.literal('SYRIASTANDARDTIME'),
  z.literal('EEUROPESTANDARDTIME'),
  z.literal('SOUTHAFRICASTANDARDTIME'),
  z.literal('FLESTANDARDTIME'),
  z.literal('TURKEYSTANDARDTIME'),
  z.literal('ISRAELSTANDARDTIME'),
  z.literal('KALININGRADSTANDARDTIME'),
  z.literal('LIBYASTANDARDTIME'),
  z.literal('ARABICSTANDARDTIME'),
  z.literal('ARABSTANDARDTIME'),
  z.literal('BELARUSSTANDARDTIME'),
  z.literal('RUSSIANSTANDARDTIME'),
  z.literal('EAFRICASTANDARDTIME'),
  z.literal('IRANSTANDARDTIME'),
  z.literal('ARABIANSTANDARDTIME'),
  z.literal('AZERBAIJANSTANDARDTIME'),
  z.literal('RUSSIATIMEZONE3'),
  z.literal('MAURITIUSSTANDARDTIME'),
  z.literal('GEORGIANSTANDARDTIME'),
  z.literal('CAUCASUSSTANDARDTIME'),
  z.literal('AFGHANISTANSTANDARDTIME'),
  z.literal('WESTASIASTANDARDTIME'),
  z.literal('EKATERINBURGSTANDARDTIME'),
  z.literal('PAKISTANSTANDARDTIME'),
  z.literal('INDIASTANDARDTIME'),
  z.literal('SRILANKASTANDARDTIME'),
  z.literal('NEPALSTANDARDTIME'),
  z.literal('CENTRALASIASTANDARDTIME'),
  z.literal('BANGLADESHSTANDARDTIME'),
  z.literal('NCENTRALASIASTANDARDTIME'),
  z.literal('MYANMARSTANDARDTIME'),
  z.literal('SEASIASTANDARDTIME'),
  z.literal('NORTHASIASTANDARDTIME'),
  z.literal('CHINASTANDARDTIME'),
  z.literal('NORTHASIAEASTSTANDARDTIME'),
  z.literal('SINGAPORESTANDARDTIME'),
  z.literal('WAUSTRALIASTANDARDTIME'),
  z.literal('TAIPEISTANDARDTIME'),
  z.literal('ULAANBAATARSTANDARDTIME'),
  z.literal('TOKYOSTANDARDTIME'),
  z.literal('KOREASTANDARDTIME'),
  z.literal('YAKUTSKSTANDARDTIME'),
  z.literal('CENAUSTRALIASTANDARDTIME'),
  z.literal('AUSCENTRALSTANDARDTIME'),
  z.literal('EAUSTRALIASTANDARDTIME'),
  z.literal('AUSEASTERNSTANDARDTIME'),
  z.literal('WESTPACIFICSTANDARDTIME'),
  z.literal('TASMANIASTANDARDTIME'),
  z.literal('MAGADANSTANDARDTIME'),
  z.literal('VLADIVOSTOKSTANDARDTIME'),
  z.literal('RUSSIATIMEZONE10'),
  z.literal('CENTRALPACIFICSTANDARDTIME'),
  z.literal('RUSSIATIMEZONE11'),
  z.literal('NEWZEALANDSTANDARDTIME'),
  z.literal('UTC+12'),
  z.literal('UTC+13'),
  z.literal('FIJISTANDARDTIME'),
  z.literal('KAMCHATKASTANDARDTIME'),
  z.literal('TONGASTANDARDTIME'),
  z.literal('SAMOASTANDARDTIME'),
  z.literal('LINEISLANDSSTANDARDTIME'),
  z.literal('AZORESSTANDARDTIME'),
  z.literal('CAPEVERDESTANDARDTIME'),
  z.literal('UTC02'),
  z.literal('MIDATLANTICSTANDARDTIME'),
  z.literal('ESOUTHAMERICASTANDARDTIME'),
  z.literal('ARGENTINASTANDARDTIME'),
  z.literal('SAEASTERNSTANDARDTIME'),
  z.literal('GREENLANDSTANDARDTIME'),
  z.literal('MONTEVIDEOSTANDARDTIME'),
  z.literal('BAHIASTANDARDTIME'),
  z.literal('NEWFOUNDLANDSTANDARDTIME'),
  z.literal('PARAGUAYSTANDARDTIME'),
  z.literal('ATLANTICSTANDARDTIME'),
  z.literal('CENTRALBRAZILIANSTANDARDTIME'),
  z.literal('SAWESTERNSTANDARDTIME'),
  z.literal('PACIFICSASTANDARDTIME'),
  z.literal('VENEZUELASTANDARDTIME'),
  z.literal('SAPACIFICSTANDARDTIME'),
  z.literal('EASTERNSTANDARDTIME'),
  z.literal('USEASTERNSTANDARDTIME'),
  z.literal('CENTRALAMERICASTANDARDTIME'),
  z.literal('CENTRALSTANDARDTIME'),
  z.literal('CENTRALSTANDARDTIME(MEXICO)'),
  z.literal('CANADACENTRALSTANDARDTIME'),
  z.literal('USMOUNTAINSTANDARDTIME'),
  z.literal('MOUNTAINSTANDARDTIME(MEXICO)'),
  z.literal('MOUNTAINSTANDARDTIME'),
  z.literal('PACIFICSTANDARDTIME(MEXICO)'),
  z.literal('PACIFICSTANDARDTIME'),
  z.literal('ALASKANSTANDARDTIME'),
  z.literal('HAWAIIANSTANDARDTIME'),
  z.literal('UTC11'),
  z.literal('DATELINESTANDARDTIME'),
]);

export const class2Schema = z.union([
  z.literal('DEMO'),
  z.literal('TRIAL'),
  z.literal('STARTER'),
  z.literal('STANDARD'),
  z.literal('PREMIUM'),
  z.literal('PREMIUM_20'),
  z.literal('PREMIUM_50'),
  z.literal('PREMIUM_100'),
  z.literal('LEDGER'),
  z.literal('GST_CASHBOOK'),
  z.literal('NON_GST_CASHBOOK'),
]);

export const editionSchema = z.union([z.literal('BUSINESS'), z.literal('PARTNER')]);

export const organisationEntityTypeSchema = z.union([
  z.literal('ACCOUNTING_PRACTICE'),
  z.literal('COMPANY'),
  z.literal('CHARITY'),
  z.literal('CLUB_OR_SOCIETY'),
  z.literal('LOOK_THROUGH_COMPANY'),
  z.literal('NOT_FOR_PROFIT'),
  z.literal('PARTNERSHIP'),
  z.literal('S_CORPORATION'),
  z.literal('SELF_MANAGED_SUPERANNUATION_FUND'),
  z.literal('SOLE_TRADER'),
  z.literal('SUPERANNUATION_FUND'),
  z.literal('TRUST'),
]);

export const organisationTypeSchema = z.union([
  z.literal('ACCOUNTING_PRACTICE'),
  z.literal('COMPANY'),
  z.literal('CHARITY'),
  z.literal('CLUB_OR_SOCIETY'),
  z.literal('LOOK_THROUGH_COMPANY'),
  z.literal('NOT_FOR_PROFIT'),
  z.literal('PARTNERSHIP'),
  z.literal('S_CORPORATION'),
  z.literal('SELF_MANAGED_SUPERANNUATION_FUND'),
  z.literal('SOLE_TRADER'),
  z.literal('SUPERANNUATION_FUND'),
  z.literal('TRUST'),
]);

export const salesTaxBasisSchema = z.union([
  z.literal('PAYMENTS'),
  z.literal('INVOICE'),
  z.literal('NONE'),
  z.literal('CASH'),
  z.literal('ACCRUAL'),
  z.literal('FLATRATECASH'),
  z.literal('FLATRATEACCRUAL'),
  z.literal('ACCRUALS'),
]);

export const salesTaxPeriodSchema = z.union([
  z.literal('MONTHLY'),
  z.literal('QUARTERLY1'),
  z.literal('QUARTERLY2'),
  z.literal('QUARTERLY3'),
  z.literal('ANNUALLY'),
  z.literal('ONEMONTHS'),
  z.literal('TWOMONTHS'),
  z.literal('SIXMONTHS'),
  z.literal('1MONTHLY'),
  z.literal('2MONTHLY'),
  z.literal('3MONTHLY'),
  z.literal('6MONTHLY'),
  z.literal('QUARTERLY'),
  z.literal('YEARLY'),
  z.literal('NONE'),
]);

export const versionSchema = z.union([
  z.literal('AU'),
  z.literal('NZ'),
  z.literal('GLOBAL'),
  z.literal('UK'),
  z.literal('US'),
  z.literal('AUONRAMP'),
  z.literal('NZONRAMP'),
  z.literal('GLOBALONRAMP'),
  z.literal('UKONRAMP'),
  z.literal('USONRAMP'),
]);

export const lineItemSchema = z.object({
  AccountCode: z.string().optional(),
  Description: z.string().optional(),
  DiscountAmount: z.number().optional(),
  DiscountRate: z.number().optional(),
  ItemCode: z.string().optional(),
  LineAmount: z.number().optional(),
  LineItemID: z.string().optional(),
  Quantity: z.number().optional(),
  RepeatingInvoiceID: z.string().optional(),
  TaxAmount: z.number().optional(),
  TaxType: z.string().optional(),
  Tracking: z.array(lineItemTrackingSchema).optional(),
  UnitAmount: z.number().optional(),
});

export const status11Schema = z.union([z.literal('AUTHORISED'), z.literal('PAID'), z.literal('VOIDED')]);

export const type7Schema = z.union([
  z.literal('RECEIVE-OVERPAYMENT'),
  z.literal('SPEND-OVERPAYMENT'),
  z.literal('AROVERPAYMENT'),
]);

export const paymentTypeSchema = z.union([
  z.literal('ACCRECPAYMENT'),
  z.literal('ACCPAYPAYMENT'),
  z.literal('ARCREDITPAYMENT'),
  z.literal('APCREDITPAYMENT'),
  z.literal('AROVERPAYMENTPAYMENT'),
  z.literal('ARPREPAYMENTPAYMENT'),
  z.literal('APPREPAYMENTPAYMENT'),
  z.literal('APOVERPAYMENTPAYMENT'),
]);

export const paymentDeleteSchema = z.object({
  Status: z.string(),
});

export const paymentServiceSchema = z.object({
  PayNowText: z.string().optional(),
  PaymentServiceID: z.string().optional(),
  PaymentServiceName: z.string().optional(),
  PaymentServiceType: z.string().optional(),
  PaymentServiceUrl: z.string().optional(),
  ValidationErrors: z.array(validationErrorSchema).optional(),
});

export const paymentServicesSchema = z.object({
  PaymentServices: z.array(paymentServiceSchema).optional(),
});

export const billSchema = z.object({
  Day: z.number().optional(),
  Type: paymentTermTypeSchema.optional(),
});

export const phoneTypeSchema = z.union([
  z.literal('DEFAULT'),
  z.literal('DDI'),
  z.literal('MOBILE'),
  z.literal('FAX'),
  z.literal('OFFICE'),
]);

export const type8Schema = z.union([
  z.literal('RECEIVE-PREPAYMENT'),
  z.literal('SPEND-PREPAYMENT'),
  z.literal('ARPREPAYMENT'),
  z.literal('APPREPAYMENT'),
]);

export const status12Schema = z.union([
  z.literal('DRAFT'),
  z.literal('SUBMITTED'),
  z.literal('AUTHORISED'),
  z.literal('BILLED'),
  z.literal('DELETED'),
]);

export const quoteLineAmountTypesSchema = z.union([z.literal('EXCLUSIVE'), z.literal('INCLUSIVE'), z.literal('NOTAX')]);

export const quoteStatusCodesSchema = z.union([
  z.literal('DRAFT'),
  z.literal('SENT'),
  z.literal('DECLINED'),
  z.literal('ACCEPTED'),
  z.literal('INVOICED'),
  z.literal('DELETED'),
]);

export const status13Schema = z.union([
  z.literal('DRAFT'),
  z.literal('SUBMITTED'),
  z.literal('AUTHORISED'),
  z.literal('DECLINED'),
  z.literal('VOIDED'),
]);

export const scheduleSchema = z.object({
  DueDate: z.number().optional(),
  DueDateType: z
    .union([
      z.literal('DAYSAFTERBILLDATE'),
      z.literal('DAYSAFTERBILLMONTH'),
      z.literal('DAYSAFTERINVOICEDATE'),
      z.literal('DAYSAFTERINVOICEMONTH'),
      z.literal('OFCURRENTMONTH'),
      z.literal('OFFOLLOWINGMONTH'),
    ])
    .optional(),
  EndDate: z.string().optional(),
  NextScheduledDate: z.string().optional(),
  Period: z.number().optional(),
  StartDate: z.string().optional(),
  Unit: z.union([z.literal('WEEKLY'), z.literal('MONTHLY')]).optional(),
});

export const status14Schema = z.union([z.literal('DRAFT'), z.literal('AUTHORISED'), z.literal('DELETED')]);

export const type9Schema = z.union([z.literal('ACCPAY'), z.literal('ACCREC')]);

export const tenNinetyNineContactSchema = z.object({
  Box1: z.number().optional(),
  Box10: z.number().optional(),
  Box11: z.number().optional(),
  Box13: z.number().optional(),
  Box14: z.number().optional(),
  Box2: z.number().optional(),
  Box3: z.number().optional(),
  Box4: z.number().optional(),
  Box5: z.number().optional(),
  Box6: z.number().optional(),
  Box7: z.number().optional(),
  Box8: z.number().optional(),
  Box9: z.number().optional(),
  City: z.string().optional(),
  ContactId: z.string().optional(),
  Email: z.string().optional(),
  FederalTaxIDType: z.string().optional(),
  Name: z.string().optional(),
  State: z.string().optional(),
  StreetAddress: z.string().optional(),
  TaxID: z.string().optional(),
  Zip: z.string().optional(),
});

export const reportTypeSchema = z.literal('AgedPayablesByContact');

export const reportAttributeSchema = z.object({
  Id: z.string().optional(),
  Value: z.string().optional(),
});

export const reportCellSchema = z.object({
  Attributes: z.array(reportAttributeSchema).optional(),
  Value: z.string().optional(),
});

export const reportFieldsSchema = z.object({
  Description: z.string().optional(),
  FieldID: z.string().optional(),
  Value: z.string().optional(),
});

export const rowTypeSchema = z.union([
  z.literal('Header'),
  z.literal('Section'),
  z.literal('Row'),
  z.literal('SummaryRow'),
]);

export const reportRowSchema = z.object({
  Cells: z.array(reportCellSchema).optional(),
  RowType: rowTypeSchema.optional(),
  Title: z.string().optional(),
});

export const reportRowsSchema = z.object({
  Cells: z.array(reportCellSchema).optional(),
  RowType: rowTypeSchema.optional(),
  Rows: z.array(reportRowSchema).optional(),
  Title: z.string().optional(),
});

export const reportWithRowSchema = z.object({
  Fields: z.array(reportFieldsSchema).optional(),
  ReportDate: z.string().optional(),
  ReportID: z.string().optional(),
  ReportName: z.string().optional(),
  ReportTitle: z.string().optional(),
  ReportTitles: z.array(z.string()).optional(),
  ReportType: z.string().optional(),
  Rows: z.array(reportRowsSchema).optional(),
  UpdatedDateUTC: z.string().optional(),
});

export const reportSchema = z.object({
  Contacts: z.array(tenNinetyNineContactSchema).optional(),
  ReportDate: z.string().optional(),
  ReportID: z.string().optional(),
  ReportName: z.string().optional(),
  ReportTitle: z.string().optional(),
  ReportType: z.literal('AgedPayablesByContact').optional(),
  UpdatedDateUTC: z.string().optional(),
});

export const requestEmptySchema = z.object({
  Status: z.string().optional(),
});

export const dueDateTypeSchema = z.union([
  z.literal('DAYSAFTERBILLDATE'),
  z.literal('DAYSAFTERBILLMONTH'),
  z.literal('DAYSAFTERINVOICEDATE'),
  z.literal('DAYSAFTERINVOICEMONTH'),
  z.literal('OFCURRENTMONTH'),
  z.literal('OFFOLLOWINGMONTH'),
]);

export const unitSchema = z.union([z.literal('WEEKLY'), z.literal('MONTHLY')]);

export const setupSchema = z.object({
  Accounts: z.array(accountSchema).optional(),
  ConversionBalances: z.array(conversionBalancesSchema).optional(),
  ConversionDate: conversionDateSchema.optional(),
});

export const taxComponentSchema = z.object({
  IsCompound: z.boolean().optional(),
  IsNonRecoverable: z.boolean().optional(),
  Name: z.string().optional(),
  Rate: z.number().optional(),
});

export const taxRateSchema = z.object({
  CanApplyToAssets: z.boolean().optional(),
  CanApplyToEquity: z.boolean().optional(),
  CanApplyToExpenses: z.boolean().optional(),
  CanApplyToLiabilities: z.boolean().optional(),
  CanApplyToRevenue: z.boolean().optional(),
  DisplayTaxRate: z.number().optional(),
  EffectiveRate: z.number().optional(),
  Name: z.string().optional(),
  ReportTaxType: z
    .union([
      z.literal('AVALARA'),
      z.literal('BASEXCLUDED'),
      z.literal('CAPITALSALESOUTPUT'),
      z.literal('CAPITALEXPENSESINPUT'),
      z.literal('ECOUTPUT'),
      z.literal('ECOUTPUTSERVICES'),
      z.literal('ECINPUT'),
      z.literal('ECACQUISITIONS'),
      z.literal('EXEMPTEXPENSES'),
      z.literal('EXEMPTINPUT'),
      z.literal('EXEMPTOUTPUT'),
      z.literal('GSTONIMPORTS'),
      z.literal('INPUT'),
      z.literal('INPUTTAXED'),
      z.literal('MOSSSALES'),
      z.literal('NONE'),
      z.literal('NONEOUTPUT'),
      z.literal('OUTPUT'),
      z.literal('PURCHASESINPUT'),
      z.literal('SALESOUTPUT'),
      z.literal('EXEMPTCAPITAL'),
      z.literal('EXEMPTEXPORT'),
      z.literal('CAPITALEXINPUT'),
      z.literal('GSTONCAPIMPORTS'),
      z.literal('GSTONCAPITALIMPORTS'),
      z.literal('REVERSECHARGES'),
      z.literal('PAYMENTS'),
      z.literal('INVOICE'),
      z.literal('CASH'),
      z.literal('ACCRUAL'),
      z.literal('FLATRATECASH'),
      z.literal('FLATRATEACCRUAL'),
      z.literal('ACCRUALS'),
      z.literal('TXCA'),
      z.literal('SRCAS'),
      z.literal('DSOUTPUT'),
      z.literal('BLINPUT2'),
      z.literal('EPINPUT'),
      z.literal('IMINPUT2'),
      z.literal('MEINPUT'),
      z.literal('IGDSINPUT2'),
      z.literal('ESN33OUTPUT'),
      z.literal('OPINPUT'),
      z.literal('OSOUTPUT'),
      z.literal('TXN33INPUT'),
      z.literal('TXESSINPUT'),
      z.literal('TXREINPUT'),
      z.literal('TXPETINPUT'),
      z.literal('NRINPUT'),
      z.literal('ES33OUTPUT'),
      z.literal('ZERORATEDINPUT'),
      z.literal('ZERORATEDOUTPUT'),
      z.literal('DRCHARGESUPPLY'),
      z.literal('DRCHARGE'),
      z.literal('CAPINPUT'),
      z.literal('CAPIMPORTS'),
      z.literal('IMINPUT'),
      z.literal('INPUT2'),
      z.literal('CIUINPUT'),
      z.literal('SRINPUT'),
      z.literal('OUTPUT2'),
      z.literal('SROUTPUT'),
      z.literal('CAPOUTPUT'),
      z.literal('SROUTPUT2'),
      z.literal('CIUOUTPUT'),
      z.literal('ZROUTPUT'),
      z.literal('ZREXPORT'),
      z.literal('ACC28PLUS'),
      z.literal('ACCUPTO28'),
      z.literal('OTHEROUTPUT'),
      z.literal('SHOUTPUT'),
      z.literal('ZRINPUT'),
      z.literal('BADDEBT'),
      z.literal('OTHERINPUT'),
    ])
    .optional(),
  Status: z.union([z.literal('ACTIVE'), z.literal('DELETED'), z.literal('ARCHIVED'), z.literal('PENDING')]).optional(),
  TaxComponents: z.array(taxComponentSchema).optional(),
  TaxType: z.string().optional(),
});

export const reportTaxTypeSchema = z.union([
  z.literal('AVALARA'),
  z.literal('BASEXCLUDED'),
  z.literal('CAPITALSALESOUTPUT'),
  z.literal('CAPITALEXPENSESINPUT'),
  z.literal('ECOUTPUT'),
  z.literal('ECOUTPUTSERVICES'),
  z.literal('ECINPUT'),
  z.literal('ECACQUISITIONS'),
  z.literal('EXEMPTEXPENSES'),
  z.literal('EXEMPTINPUT'),
  z.literal('EXEMPTOUTPUT'),
  z.literal('GSTONIMPORTS'),
  z.literal('INPUT'),
  z.literal('INPUTTAXED'),
  z.literal('MOSSSALES'),
  z.literal('NONE'),
  z.literal('NONEOUTPUT'),
  z.literal('OUTPUT'),
  z.literal('PURCHASESINPUT'),
  z.literal('SALESOUTPUT'),
  z.literal('EXEMPTCAPITAL'),
  z.literal('EXEMPTEXPORT'),
  z.literal('CAPITALEXINPUT'),
  z.literal('GSTONCAPIMPORTS'),
  z.literal('GSTONCAPITALIMPORTS'),
  z.literal('REVERSECHARGES'),
  z.literal('PAYMENTS'),
  z.literal('INVOICE'),
  z.literal('CASH'),
  z.literal('ACCRUAL'),
  z.literal('FLATRATECASH'),
  z.literal('FLATRATEACCRUAL'),
  z.literal('ACCRUALS'),
  z.literal('TXCA'),
  z.literal('SRCAS'),
  z.literal('DSOUTPUT'),
  z.literal('BLINPUT2'),
  z.literal('EPINPUT'),
  z.literal('IMINPUT2'),
  z.literal('MEINPUT'),
  z.literal('IGDSINPUT2'),
  z.literal('ESN33OUTPUT'),
  z.literal('OPINPUT'),
  z.literal('OSOUTPUT'),
  z.literal('TXN33INPUT'),
  z.literal('TXESSINPUT'),
  z.literal('TXREINPUT'),
  z.literal('TXPETINPUT'),
  z.literal('NRINPUT'),
  z.literal('ES33OUTPUT'),
  z.literal('ZERORATEDINPUT'),
  z.literal('ZERORATEDOUTPUT'),
  z.literal('DRCHARGESUPPLY'),
  z.literal('DRCHARGE'),
  z.literal('CAPINPUT'),
  z.literal('CAPIMPORTS'),
  z.literal('IMINPUT'),
  z.literal('INPUT2'),
  z.literal('CIUINPUT'),
  z.literal('SRINPUT'),
  z.literal('OUTPUT2'),
  z.literal('SROUTPUT'),
  z.literal('CAPOUTPUT'),
  z.literal('SROUTPUT2'),
  z.literal('CIUOUTPUT'),
  z.literal('ZROUTPUT'),
  z.literal('ZREXPORT'),
  z.literal('ACC28PLUS'),
  z.literal('ACCUPTO28'),
  z.literal('OTHEROUTPUT'),
  z.literal('SHOUTPUT'),
  z.literal('ZRINPUT'),
  z.literal('BADDEBT'),
  z.literal('OTHERINPUT'),
]);

export const status15Schema = z.union([
  z.literal('ACTIVE'),
  z.literal('DELETED'),
  z.literal('ARCHIVED'),
  z.literal('PENDING'),
]);

export const taxRatesSchema = z.object({
  TaxRates: z.array(taxRateSchema).optional(),
});

export const taxTypeSchema = z.union([
  z.literal('OUTPUT'),
  z.literal('INPUT'),
  z.literal('CAPEXINPUT'),
  z.literal('EXEMPTEXPORT'),
  z.literal('EXEMPTEXPENSES'),
  z.literal('EXEMPTCAPITAL'),
  z.literal('EXEMPTOUTPUT'),
  z.literal('INPUTTAXED'),
  z.literal('BASEXCLUDED'),
  z.literal('GSTONCAPIMPORTS'),
  z.literal('GSTONIMPORTS'),
  z.literal('NONE'),
  z.literal('INPUT2'),
  z.literal('ZERORATED'),
  z.literal('OUTPUT2'),
  z.literal('CAPEXINPUT2'),
  z.literal('CAPEXOUTPUT'),
  z.literal('CAPEXOUTPUT2'),
  z.literal('CAPEXSRINPUT'),
  z.literal('CAPEXSROUTPUT'),
  z.literal('ECACQUISITIONS'),
  z.literal('ECZRINPUT'),
  z.literal('ECZROUTPUT'),
  z.literal('ECZROUTPUTSERVICES'),
  z.literal('EXEMPTINPUT'),
  z.literal('REVERSECHARGES'),
  z.literal('RRINPUT'),
  z.literal('RROUTPUT'),
  z.literal('SRINPUT'),
  z.literal('SROUTPUT'),
  z.literal('ZERORATEDINPUT'),
  z.literal('ZERORATEDOUTPUT'),
  z.literal('BLINPUT'),
  z.literal('DSOUTPUT'),
  z.literal('EPINPUT'),
  z.literal('ES33OUTPUT'),
  z.literal('ESN33OUTPUT'),
  z.literal('IGDSINPUT2'),
  z.literal('IMINPUT2'),
  z.literal('MEINPUT'),
  z.literal('NRINPUT'),
  z.literal('OPINPUT'),
  z.literal('OSOUTPUT'),
  z.literal('TXESSINPUT'),
  z.literal('TXN33INPUT'),
  z.literal('TXPETINPUT'),
  z.literal('TXREINPUT'),
  z.literal('INPUT3'),
  z.literal('INPUT4'),
  z.literal('OUTPUT3'),
  z.literal('OUTPUT4'),
  z.literal('SROUTPUT2'),
  z.literal('TXCA'),
  z.literal('SRCAS'),
  z.literal('BLINPUT2'),
  z.literal('DRCHARGESUPPLY20'),
  z.literal('DRCHARGE20'),
  z.literal('DRCHARGESUPPLY5'),
  z.literal('DRCHARGE5'),
]);

export const trackingOptionSchema = z.object({
  Name: z.string().optional(),
  Status: z.union([z.literal('ACTIVE'), z.literal('ARCHIVED'), z.literal('DELETED')]).optional(),
  TrackingCategoryID: z.string().optional(),
  TrackingOptionID: z.string().optional(),
});

export const trackingOptionsSchema = z.object({
  Options: z.array(trackingOptionSchema).optional(),
});

export const organisationRoleSchema = z.union([
  z.literal('READONLY'),
  z.literal('INVOICEONLY'),
  z.literal('STANDARD'),
  z.literal('FINANCIALADVISER'),
  z.literal('MANAGEDCLIENT'),
  z.literal('CASHBOOKCLIENT'),
  z.literal('UNKNOWN'),
]);

export const usersSchema = z.object({
  Users: z.array(userSchema).optional(),
});

export const parameterifModifiedSinceSchema = z.string();

export const parameterincludeOnlineSchema = z.boolean();

export const parameterrequiredHeaderSchema = z.string();

export const parametersummarizeErrorsSchema = z.boolean();

export const parameterunitdpSchema = z.number();

export const getAccountsDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const accountsSchema = z.object({
  Accounts: z.array(accountSchema).optional(),
});

export const getAccountsErrorSchema = z.unknown();

export const createAccountDataSchema = z.object({
  body: accountSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const createAccountResponseSchema = accountsSchema;

export const createAccountErrorSchema = errorSchema;

export const deleteAccountDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AccountID: z.string(),
  }),
});

export const deleteAccountResponseSchema = accountsSchema;

export const deleteAccountErrorSchema = errorSchema;

export const getAccountDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AccountID: z.string(),
  }),
});

export const getAccountResponseSchema = accountsSchema;

export const getAccountErrorSchema = z.unknown();

export const updateAccountDataSchema = z.object({
  body: accountsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AccountID: z.string(),
  }),
});

export const updateAccountResponseSchema = accountsSchema;

export const updateAccountErrorSchema = errorSchema;

export const getAccountAttachmentsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AccountID: z.string(),
  }),
});

export const getAccountAttachmentsResponseSchema = attachmentsSchema;

export const getAccountAttachmentsErrorSchema = z.unknown();

export const getAccountAttachmentByIdDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AccountID: z.string(),
    AttachmentID: z.string(),
  }),
});

export const getAccountAttachmentByIdErrorSchema = z.unknown();

export const getAccountAttachmentByFileNameDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AccountID: z.string(),
    FileName: z.string(),
  }),
});

export const getAccountAttachmentByFileNameErrorSchema = z.unknown();

export const updateAccountAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AccountID: z.string(),
    FileName: z.string(),
  }),
});

export const updateAccountAttachmentByFileNameResponseSchema = attachmentsSchema;

export const updateAccountAttachmentByFileNameErrorSchema = errorSchema;

export const createAccountAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AccountID: z.string(),
    FileName: z.string(),
  }),
});

export const createAccountAttachmentByFileNameResponseSchema = attachmentsSchema;

export const createAccountAttachmentByFileNameErrorSchema = errorSchema;

export const getBankTransactionsDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      page: z.number().optional(),
      unitdp: z.number().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getBankTransactionsErrorSchema = z.unknown();

export const updateOrCreateBankTransactionsErrorSchema = errorSchema;

export const createBankTransactionsErrorSchema = errorSchema;

export const getBankTransactionDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransactionID: z.string(),
  }),
  query: z
    .object({
      unitdp: z.number().optional(),
    })
    .optional(),
});

export const getBankTransactionErrorSchema = z.unknown();

export const updateBankTransactionErrorSchema = errorSchema;

export const getBankTransactionAttachmentsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransactionID: z.string(),
  }),
});

export const getBankTransactionAttachmentsResponseSchema = attachmentsSchema;

export const getBankTransactionAttachmentsErrorSchema = z.unknown();

export const getBankTransactionAttachmentByIdDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AttachmentID: z.string(),
    BankTransactionID: z.string(),
  }),
});

export const getBankTransactionAttachmentByIdErrorSchema = z.unknown();

export const getBankTransactionAttachmentByFileNameDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransactionID: z.string(),
    FileName: z.string(),
  }),
});

export const getBankTransactionAttachmentByFileNameErrorSchema = z.unknown();

export const updateBankTransactionAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransactionID: z.string(),
    FileName: z.string(),
  }),
});

export const updateBankTransactionAttachmentByFileNameResponseSchema = attachmentsSchema;

export const updateBankTransactionAttachmentByFileNameErrorSchema = errorSchema;

export const createBankTransactionAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransactionID: z.string(),
    FileName: z.string(),
  }),
});

export const createBankTransactionAttachmentByFileNameResponseSchema = attachmentsSchema;

export const createBankTransactionAttachmentByFileNameErrorSchema = errorSchema;

export const getBankTransactionsHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransactionID: z.string(),
  }),
});

export const getBankTransactionsHistoryResponseSchema = historyRecordsSchema;

export const getBankTransactionsHistoryErrorSchema = z.unknown();

export const createBankTransactionHistoryRecordDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransactionID: z.string(),
  }),
});

export const createBankTransactionHistoryRecordResponseSchema = historyRecordsSchema;

export const createBankTransactionHistoryRecordErrorSchema = errorSchema;

export const getBankTransfersDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getBankTransfersResponseSchema = bankTransfersSchema;

export const getBankTransfersErrorSchema = z.unknown();

export const createBankTransferDataSchema = z.object({
  body: bankTransfersSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const createBankTransferResponseSchema = bankTransfersSchema;

export const createBankTransferErrorSchema = errorSchema;

export const getBankTransferDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransferID: z.string(),
  }),
});

export const getBankTransferResponseSchema = bankTransfersSchema;

export const getBankTransferErrorSchema = z.unknown();

export const getBankTransferAttachmentsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransferID: z.string(),
  }),
});

export const getBankTransferAttachmentsResponseSchema = attachmentsSchema;

export const getBankTransferAttachmentsErrorSchema = z.unknown();

export const getBankTransferAttachmentByIdDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AttachmentID: z.string(),
    BankTransferID: z.string(),
  }),
});

export const getBankTransferAttachmentByIdErrorSchema = z.unknown();

export const getBankTransferAttachmentByFileNameDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransferID: z.string(),
    FileName: z.string(),
  }),
});

export const getBankTransferAttachmentByFileNameErrorSchema = z.unknown();

export const updateBankTransferAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransferID: z.string(),
    FileName: z.string(),
  }),
});

export const updateBankTransferAttachmentByFileNameResponseSchema = attachmentsSchema;

export const updateBankTransferAttachmentByFileNameErrorSchema = errorSchema;

export const createBankTransferAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransferID: z.string(),
    FileName: z.string(),
  }),
});

export const createBankTransferAttachmentByFileNameResponseSchema = attachmentsSchema;

export const createBankTransferAttachmentByFileNameErrorSchema = errorSchema;

export const getBankTransferHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransferID: z.string(),
  }),
});

export const getBankTransferHistoryResponseSchema = historyRecordsSchema;

export const getBankTransferHistoryErrorSchema = z.unknown();

export const createBankTransferHistoryRecordDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BankTransferID: z.string(),
  }),
});

export const createBankTransferHistoryRecordResponseSchema = historyRecordsSchema;

export const createBankTransferHistoryRecordErrorSchema = errorSchema;

export const getBatchPaymentsDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getBatchPaymentsErrorSchema = z.unknown();

export const createBatchPaymentErrorSchema = errorSchema;

export const getBatchPaymentHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BatchPaymentID: z.string(),
  }),
});

export const getBatchPaymentHistoryResponseSchema = historyRecordsSchema;

export const getBatchPaymentHistoryErrorSchema = z.unknown();

export const createBatchPaymentHistoryRecordDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BatchPaymentID: z.string(),
  }),
});

export const createBatchPaymentHistoryRecordResponseSchema = historyRecordsSchema;

export const createBatchPaymentHistoryRecordErrorSchema = errorSchema;

export const getBrandingThemesDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const getBrandingThemesResponseSchema = brandingThemesSchema;

export const getBrandingThemesErrorSchema = z.unknown();

export const getBrandingThemeDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BrandingThemeID: z.string(),
  }),
});

export const getBrandingThemeResponseSchema = brandingThemesSchema;

export const getBrandingThemeErrorSchema = z.unknown();

export const getBrandingThemePaymentServicesDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BrandingThemeID: z.string(),
  }),
});

export const getBrandingThemePaymentServicesResponseSchema = paymentServicesSchema;

export const getBrandingThemePaymentServicesErrorSchema = z.unknown();

export const createBrandingThemePaymentServicesDataSchema = z.object({
  body: paymentServiceSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    BrandingThemeID: z.string(),
  }),
});

export const createBrandingThemePaymentServicesResponseSchema = paymentServicesSchema;

export const createBrandingThemePaymentServicesErrorSchema = errorSchema;

export const getContactGroupsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getContactGroupsErrorSchema = z.unknown();

export const createContactGroupErrorSchema = errorSchema;

export const getContactGroupDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ContactGroupID: z.string(),
  }),
});

export const getContactGroupErrorSchema = z.unknown();

export const updateContactGroupErrorSchema = errorSchema;

export const deleteContactGroupContactsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ContactGroupID: z.string(),
  }),
});

export const deleteContactGroupContactsResponseSchema = z.any();

export const deleteContactGroupContactsErrorSchema = z.unknown();

export const createContactGroupContactsErrorSchema = errorSchema;

export const deleteContactGroupContactDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ContactGroupID: z.string(),
    ContactID: z.string(),
  }),
});

export const deleteContactGroupContactResponseSchema = z.any();

export const deleteContactGroupContactErrorSchema = errorSchema;

export const getContactsDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      IDs: z.array(z.string()).optional(),
      includeArchived: z.boolean().optional(),
      order: z.string().optional(),
      page: z.number().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getContactsErrorSchema = z.unknown();

export const updateOrCreateContactsErrorSchema = errorSchema;

export const createContactsErrorSchema = errorSchema;

export const getContactDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ContactID: z.string(),
  }),
});

export const getContactErrorSchema = z.unknown();

export const updateContactErrorSchema = errorSchema;

export const getContactAttachmentsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ContactID: z.string(),
  }),
});

export const getContactAttachmentsResponseSchema = attachmentsSchema;

export const getContactAttachmentsErrorSchema = z.unknown();

export const getContactAttachmentByIdDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AttachmentID: z.string(),
    ContactID: z.string(),
  }),
});

export const getContactAttachmentByIdErrorSchema = z.unknown();

export const getContactAttachmentByFileNameDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ContactID: z.string(),
    FileName: z.string(),
  }),
});

export const getContactAttachmentByFileNameErrorSchema = z.unknown();

export const updateContactAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ContactID: z.string(),
    FileName: z.string(),
  }),
});

export const updateContactAttachmentByFileNameResponseSchema = attachmentsSchema;

export const updateContactAttachmentByFileNameErrorSchema = errorSchema;

export const createContactAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ContactID: z.string(),
    FileName: z.string(),
  }),
});

export const createContactAttachmentByFileNameResponseSchema = attachmentsSchema;

export const createContactAttachmentByFileNameErrorSchema = errorSchema;

export const getContactCisSettingsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ContactID: z.string(),
  }),
});

export const getContactCisSettingsResponseSchema = cISSettingsSchema;

export const getContactCisSettingsErrorSchema = z.unknown();

export const getContactHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ContactID: z.string(),
  }),
});

export const getContactHistoryResponseSchema = historyRecordsSchema;

export const getContactHistoryErrorSchema = z.unknown();

export const createContactHistoryDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ContactID: z.string(),
  }),
});

export const createContactHistoryResponseSchema = historyRecordsSchema;

export const createContactHistoryErrorSchema = errorSchema;

export const getContactByContactNumberDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ContactNumber: z.string(),
  }),
});

export const getContactByContactNumberErrorSchema = z.unknown();

export const getCreditNotesDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      page: z.number().optional(),
      unitdp: z.number().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getCreditNotesErrorSchema = z.unknown();

export const updateOrCreateCreditNotesErrorSchema = errorSchema;

export const createCreditNotesErrorSchema = errorSchema;

export const getCreditNoteDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    CreditNoteID: z.string(),
  }),
  query: z
    .object({
      unitdp: z.number().optional(),
    })
    .optional(),
});

export const getCreditNoteErrorSchema = z.unknown();

export const updateCreditNoteErrorSchema = errorSchema;

export const createCreditNoteAllocationErrorSchema = errorSchema;

export const getCreditNoteAttachmentsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    CreditNoteID: z.string(),
  }),
});

export const getCreditNoteAttachmentsResponseSchema = attachmentsSchema;

export const getCreditNoteAttachmentsErrorSchema = z.unknown();

export const getCreditNoteAttachmentByIdDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AttachmentID: z.string(),
    CreditNoteID: z.string(),
  }),
});

export const getCreditNoteAttachmentByIdErrorSchema = z.unknown();

export const getCreditNoteAttachmentByFileNameDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    CreditNoteID: z.string(),
    FileName: z.string(),
  }),
});

export const getCreditNoteAttachmentByFileNameErrorSchema = z.unknown();

export const updateCreditNoteAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    CreditNoteID: z.string(),
    FileName: z.string(),
  }),
});

export const updateCreditNoteAttachmentByFileNameResponseSchema = attachmentsSchema;

export const updateCreditNoteAttachmentByFileNameErrorSchema = errorSchema;

export const createCreditNoteAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    CreditNoteID: z.string(),
    FileName: z.string(),
  }),
  query: z
    .object({
      IncludeOnline: z.boolean().optional(),
    })
    .optional(),
});

export const createCreditNoteAttachmentByFileNameResponseSchema = attachmentsSchema;

export const createCreditNoteAttachmentByFileNameErrorSchema = errorSchema;

export const getCreditNoteHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    CreditNoteID: z.string(),
  }),
});

export const getCreditNoteHistoryResponseSchema = historyRecordsSchema;

export const getCreditNoteHistoryErrorSchema = z.unknown();

export const createCreditNoteHistoryDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    CreditNoteID: z.string(),
  }),
});

export const createCreditNoteHistoryResponseSchema = historyRecordsSchema;

export const createCreditNoteHistoryErrorSchema = errorSchema;

export const getCreditNoteAsPdfDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    CreditNoteID: z.string(),
  }),
});

export const getCreditNoteAsPdfErrorSchema = z.unknown();

export const getCurrenciesDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const currenciesSchema = z.object({
  Currencies: z.array(currencySchema).optional(),
});

export const getCurrenciesErrorSchema = z.unknown();

export const createCurrencyDataSchema = z.object({
  body: currencySchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const createCurrencyResponseSchema = currenciesSchema;

export const createCurrencyErrorSchema = z.unknown();

export const getEmployeesDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const employeesSchema = z.object({
  Employees: z.array(employeeSchema).optional(),
});

export const getEmployeesErrorSchema = z.unknown();

export const updateOrCreateEmployeesDataSchema = z.object({
  body: employeesSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      summarizeErrors: z.boolean().optional(),
    })
    .optional(),
});

export const updateOrCreateEmployeesResponseSchema = employeesSchema;

export const updateOrCreateEmployeesErrorSchema = errorSchema;

export const createEmployeesDataSchema = z.object({
  body: employeesSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      summarizeErrors: z.boolean().optional(),
    })
    .optional(),
});

export const createEmployeesResponseSchema = employeesSchema;

export const createEmployeesErrorSchema = errorSchema;

export const getEmployeeDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    EmployeeID: z.string(),
  }),
});

export const getEmployeeResponseSchema = employeesSchema;

export const getEmployeeErrorSchema = z.unknown();

export const getExpenseClaimsDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getExpenseClaimsErrorSchema = z.unknown();

export const createExpenseClaimsErrorSchema = errorSchema;

export const getExpenseClaimDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ExpenseClaimID: z.string(),
  }),
});

export const getExpenseClaimErrorSchema = z.unknown();

export const updateExpenseClaimErrorSchema = errorSchema;

export const getExpenseClaimHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ExpenseClaimID: z.string(),
  }),
});

export const getExpenseClaimHistoryResponseSchema = historyRecordsSchema;

export const getExpenseClaimHistoryErrorSchema = z.unknown();

export const createExpenseClaimHistoryDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ExpenseClaimID: z.string(),
  }),
});

export const createExpenseClaimHistoryResponseSchema = historyRecordsSchema;

export const createExpenseClaimHistoryErrorSchema = z.unknown();

export const getInvoiceRemindersDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const getInvoiceRemindersResponseSchema = invoiceRemindersSchema;

export const getInvoiceRemindersErrorSchema = z.unknown();

export const getInvoicesDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      ContactIDs: z.array(z.string()).optional(),
      createdByMyApp: z.boolean().optional(),
      IDs: z.array(z.string()).optional(),
      includeArchived: z.boolean().optional(),
      InvoiceNumbers: z.array(z.string()).optional(),
      order: z.string().optional(),
      page: z.number().optional(),
      Statuses: z.array(z.string()).optional(),
      unitdp: z.number().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getInvoicesErrorSchema = z.unknown();

export const updateOrCreateInvoicesErrorSchema = errorSchema;

export const createInvoicesErrorSchema = errorSchema;

export const getInvoiceDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    InvoiceID: z.string(),
  }),
  query: z
    .object({
      unitdp: z.number().optional(),
    })
    .optional(),
});

export const getInvoiceErrorSchema = z.unknown();

export const updateInvoiceErrorSchema = errorSchema;

export const getInvoiceAttachmentsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    InvoiceID: z.string(),
  }),
});

export const getInvoiceAttachmentsResponseSchema = attachmentsSchema;

export const getInvoiceAttachmentsErrorSchema = z.unknown();

export const getInvoiceAttachmentByIdDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AttachmentID: z.string(),
    InvoiceID: z.string(),
  }),
});

export const getInvoiceAttachmentByIdErrorSchema = z.unknown();

export const getInvoiceAttachmentByFileNameDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    InvoiceID: z.string(),
  }),
});

export const getInvoiceAttachmentByFileNameErrorSchema = z.unknown();

export const updateInvoiceAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    InvoiceID: z.string(),
  }),
});

export const updateInvoiceAttachmentByFileNameResponseSchema = attachmentsSchema;

export const updateInvoiceAttachmentByFileNameErrorSchema = errorSchema;

export const createInvoiceAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    InvoiceID: z.string(),
  }),
  query: z
    .object({
      IncludeOnline: z.boolean().optional(),
    })
    .optional(),
});

export const createInvoiceAttachmentByFileNameResponseSchema = attachmentsSchema;

export const createInvoiceAttachmentByFileNameErrorSchema = errorSchema;

export const emailInvoiceDataSchema = z.object({
  body: requestEmptySchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    InvoiceID: z.string(),
  }),
});

export const emailInvoiceResponseSchema = z.any();

export const emailInvoiceErrorSchema = errorSchema;

export const getInvoiceHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    InvoiceID: z.string(),
  }),
});

export const getInvoiceHistoryResponseSchema = historyRecordsSchema;

export const getInvoiceHistoryErrorSchema = z.unknown();

export const createInvoiceHistoryDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    InvoiceID: z.string(),
  }),
});

export const createInvoiceHistoryResponseSchema = historyRecordsSchema;

export const createInvoiceHistoryErrorSchema = errorSchema;

export const getOnlineInvoiceDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    InvoiceID: z.string(),
  }),
});

export const getOnlineInvoiceResponseSchema = onlineInvoicesSchema;

export const getOnlineInvoiceErrorSchema = z.unknown();

export const getInvoiceAsPdfDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    InvoiceID: z.string(),
  }),
});

export const getInvoiceAsPdfErrorSchema = z.unknown();

export const getItemsDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      unitdp: z.number().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const itemsSchema = z.object({
  Items: z.array(itemSchema).optional(),
});

export const getItemsErrorSchema = z.unknown();

export const updateOrCreateItemsDataSchema = z.object({
  body: itemsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      summarizeErrors: z.boolean().optional(),
      unitdp: z.number().optional(),
    })
    .optional(),
});

export const updateOrCreateItemsResponseSchema = itemsSchema;

export const updateOrCreateItemsErrorSchema = errorSchema;

export const createItemsDataSchema = z.object({
  body: itemsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      summarizeErrors: z.boolean().optional(),
      unitdp: z.number().optional(),
    })
    .optional(),
});

export const createItemsResponseSchema = itemsSchema;

export const createItemsErrorSchema = errorSchema;

export const deleteItemDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ItemID: z.string(),
  }),
});

export const deleteItemResponseSchema = z.any();

export const deleteItemErrorSchema = errorSchema;

export const getItemDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ItemID: z.string(),
  }),
  query: z
    .object({
      unitdp: z.number().optional(),
    })
    .optional(),
});

export const getItemResponseSchema = itemsSchema;

export const getItemErrorSchema = z.unknown();

export const updateItemDataSchema = z.object({
  body: itemsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ItemID: z.string(),
  }),
  query: z
    .object({
      unitdp: z.number().optional(),
    })
    .optional(),
});

export const updateItemResponseSchema = itemsSchema;

export const updateItemErrorSchema = errorSchema;

export const getItemHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ItemID: z.string(),
  }),
});

export const getItemHistoryResponseSchema = historyRecordsSchema;

export const getItemHistoryErrorSchema = z.unknown();

export const createItemHistoryDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ItemID: z.string(),
  }),
});

export const createItemHistoryResponseSchema = historyRecordsSchema;

export const createItemHistoryErrorSchema = z.unknown();

export const getJournalsDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      offset: z.number().optional(),
      paymentsOnly: z.boolean().optional(),
    })
    .optional(),
});

export const getJournalsErrorSchema = z.unknown();

export const getJournalDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    JournalID: z.string(),
  }),
});

export const getJournalErrorSchema = z.unknown();

export const getLinkedTransactionsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      ContactID: z.string().optional(),
      LinkedTransactionID: z.string().optional(),
      page: z.number().optional(),
      SourceTransactionID: z.string().optional(),
      Status: z.string().optional(),
      TargetTransactionID: z.string().optional(),
    })
    .optional(),
});

export const getLinkedTransactionsResponseSchema = linkedTransactionsSchema;

export const getLinkedTransactionsErrorSchema = z.unknown();

export const createLinkedTransactionDataSchema = z.object({
  body: linkedTransactionSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const createLinkedTransactionResponseSchema = linkedTransactionsSchema;

export const createLinkedTransactionErrorSchema = errorSchema;

export const deleteLinkedTransactionDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    LinkedTransactionID: z.string(),
  }),
});

export const deleteLinkedTransactionResponseSchema = z.any();

export const deleteLinkedTransactionErrorSchema = errorSchema;

export const getLinkedTransactionDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    LinkedTransactionID: z.string(),
  }),
});

export const getLinkedTransactionResponseSchema = linkedTransactionsSchema;

export const getLinkedTransactionErrorSchema = z.unknown();

export const updateLinkedTransactionDataSchema = z.object({
  body: linkedTransactionsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    LinkedTransactionID: z.string(),
  }),
});

export const updateLinkedTransactionResponseSchema = linkedTransactionsSchema;

export const updateLinkedTransactionErrorSchema = errorSchema;

export const getManualJournalsDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      page: z.number().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getManualJournalsErrorSchema = z.unknown();

export const updateOrCreateManualJournalsErrorSchema = errorSchema;

export const createManualJournalsErrorSchema = errorSchema;

export const getManualJournalDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ManualJournalID: z.string(),
  }),
});

export const getManualJournalErrorSchema = z.unknown();

export const updateManualJournalErrorSchema = errorSchema;

export const getManualJournalAttachmentsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ManualJournalID: z.string(),
  }),
});

export const getManualJournalAttachmentsResponseSchema = attachmentsSchema;

export const getManualJournalAttachmentsErrorSchema = z.unknown();

export const getManualJournalAttachmentByIdDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AttachmentID: z.string(),
    ManualJournalID: z.string(),
  }),
});

export const getManualJournalAttachmentByIdErrorSchema = z.unknown();

export const getManualJournalAttachmentByFileNameDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    ManualJournalID: z.string(),
  }),
});

export const getManualJournalAttachmentByFileNameErrorSchema = z.unknown();

export const updateManualJournalAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    ManualJournalID: z.string(),
  }),
});

export const updateManualJournalAttachmentByFileNameResponseSchema = attachmentsSchema;

export const updateManualJournalAttachmentByFileNameErrorSchema = errorSchema;

export const createManualJournalAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    ManualJournalID: z.string(),
  }),
});

export const createManualJournalAttachmentByFileNameResponseSchema = attachmentsSchema;

export const createManualJournalAttachmentByFileNameErrorSchema = errorSchema;

export const getManualJournalsHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ManualJournalID: z.string(),
  }),
});

export const getManualJournalsHistoryResponseSchema = historyRecordsSchema;

export const getManualJournalsHistoryErrorSchema = z.unknown();

export const createManualJournalHistoryRecordDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ManualJournalID: z.string(),
  }),
});

export const createManualJournalHistoryRecordResponseSchema = historyRecordsSchema;

export const createManualJournalHistoryRecordErrorSchema = errorSchema;

export const getOrganisationsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const getOrganisationsErrorSchema = z.unknown();

export const getOrganisationActionsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const getOrganisationActionsResponseSchema = actionsSchema;

export const getOrganisationActionsErrorSchema = z.unknown();

export const getOrganisationCisSettingsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    OrganisationID: z.string(),
  }),
});

export const getOrganisationCisSettingsResponseSchema = cISOrgSettingsSchema;

export const getOrganisationCisSettingsErrorSchema = z.unknown();

export const getOverpaymentsDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      page: z.number().optional(),
      unitdp: z.number().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getOverpaymentsErrorSchema = z.unknown();

export const getOverpaymentDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    OverpaymentID: z.string(),
  }),
});

export const getOverpaymentErrorSchema = z.unknown();

export const createOverpaymentAllocationsErrorSchema = errorSchema;

export const getOverpaymentHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    OverpaymentID: z.string(),
  }),
});

export const getOverpaymentHistoryResponseSchema = historyRecordsSchema;

export const getOverpaymentHistoryErrorSchema = z.unknown();

export const createOverpaymentHistoryDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    OverpaymentID: z.string(),
  }),
});

export const createOverpaymentHistoryResponseSchema = historyRecordsSchema;

export const createOverpaymentHistoryErrorSchema = errorSchema;

export const getPaymentServicesDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const getPaymentServicesResponseSchema = paymentServicesSchema;

export const getPaymentServicesErrorSchema = z.unknown();

export const createPaymentServiceDataSchema = z.object({
  body: paymentServicesSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const createPaymentServiceResponseSchema = paymentServicesSchema;

export const createPaymentServiceErrorSchema = errorSchema;

export const getPaymentsDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      page: z.number().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getPaymentsErrorSchema = z.unknown();

export const createPaymentErrorSchema = errorSchema;

export const createPaymentsErrorSchema = errorSchema;

export const getPaymentDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PaymentID: z.string(),
  }),
});

export const getPaymentErrorSchema = z.unknown();

export const deletePaymentDataSchema = z.object({
  body: paymentDeleteSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PaymentID: z.string(),
  }),
});

export const deletePaymentErrorSchema = errorSchema;

export const getPaymentHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PaymentID: z.string(),
  }),
});

export const getPaymentHistoryResponseSchema = historyRecordsSchema;

export const getPaymentHistoryErrorSchema = z.unknown();

export const createPaymentHistoryDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PaymentID: z.string(),
  }),
});

export const createPaymentHistoryResponseSchema = historyRecordsSchema;

export const createPaymentHistoryErrorSchema = errorSchema;

export const getPrepaymentsDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      page: z.number().optional(),
      unitdp: z.number().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getPrepaymentsErrorSchema = z.unknown();

export const getPrepaymentDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PrepaymentID: z.string(),
  }),
});

export const getPrepaymentErrorSchema = z.unknown();

export const createPrepaymentAllocationsErrorSchema = errorSchema;

export const getPrepaymentHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PrepaymentID: z.string(),
  }),
});

export const getPrepaymentHistoryResponseSchema = historyRecordsSchema;

export const getPrepaymentHistoryErrorSchema = z.unknown();

export const createPrepaymentHistoryDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PrepaymentID: z.string(),
  }),
});

export const createPrepaymentHistoryResponseSchema = historyRecordsSchema;

export const createPrepaymentHistoryErrorSchema = errorSchema;

export const getPurchaseOrdersDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      DateFrom: z.string().optional(),
      DateTo: z.string().optional(),
      order: z.string().optional(),
      page: z.number().optional(),
      Status: z
        .union([
          z.literal('DRAFT'),
          z.literal('SUBMITTED'),
          z.literal('AUTHORISED'),
          z.literal('BILLED'),
          z.literal('DELETED'),
        ])
        .optional(),
    })
    .optional(),
});

export const getPurchaseOrdersErrorSchema = z.unknown();

export const updateOrCreatePurchaseOrdersErrorSchema = errorSchema;

export const createPurchaseOrdersErrorSchema = errorSchema;

export const getPurchaseOrderDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PurchaseOrderID: z.string(),
  }),
});

export const getPurchaseOrderErrorSchema = z.unknown();

export const updatePurchaseOrderErrorSchema = errorSchema;

export const getPurchaseOrderAttachmentsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PurchaseOrderID: z.string(),
  }),
});

export const getPurchaseOrderAttachmentsResponseSchema = attachmentsSchema;

export const getPurchaseOrderAttachmentsErrorSchema = z.unknown();

export const getPurchaseOrderAttachmentByIdDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AttachmentID: z.string(),
    PurchaseOrderID: z.string(),
  }),
});

export const getPurchaseOrderAttachmentByIdErrorSchema = z.unknown();

export const getPurchaseOrderAttachmentByFileNameDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    PurchaseOrderID: z.string(),
  }),
});

export const getPurchaseOrderAttachmentByFileNameErrorSchema = z.unknown();

export const updatePurchaseOrderAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    PurchaseOrderID: z.string(),
  }),
});

export const updatePurchaseOrderAttachmentByFileNameResponseSchema = attachmentsSchema;

export const updatePurchaseOrderAttachmentByFileNameErrorSchema = errorSchema;

export const createPurchaseOrderAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    PurchaseOrderID: z.string(),
  }),
});

export const createPurchaseOrderAttachmentByFileNameResponseSchema = attachmentsSchema;

export const createPurchaseOrderAttachmentByFileNameErrorSchema = errorSchema;

export const getPurchaseOrderHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PurchaseOrderID: z.string(),
  }),
});

export const getPurchaseOrderHistoryResponseSchema = historyRecordsSchema;

export const getPurchaseOrderHistoryErrorSchema = z.unknown();

export const createPurchaseOrderHistoryDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PurchaseOrderID: z.string(),
  }),
});

export const createPurchaseOrderHistoryResponseSchema = historyRecordsSchema;

export const createPurchaseOrderHistoryErrorSchema = errorSchema;

export const getPurchaseOrderAsPdfDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PurchaseOrderID: z.string(),
  }),
});

export const getPurchaseOrderAsPdfErrorSchema = z.unknown();

export const getPurchaseOrderByNumberDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    PurchaseOrderNumber: z.string(),
  }),
});

export const getPurchaseOrderByNumberErrorSchema = z.unknown();

export const getQuotesDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      ContactID: z.string().optional(),
      DateFrom: z.string().optional(),
      DateTo: z.string().optional(),
      ExpiryDateFrom: z.string().optional(),
      ExpiryDateTo: z.string().optional(),
      order: z.string().optional(),
      page: z.number().optional(),
      QuoteNumber: z.string().optional(),
      Status: z.string().optional(),
    })
    .optional(),
});

export const getQuotesErrorSchema = z.unknown();

export const updateOrCreateQuotesErrorSchema = errorSchema;

export const createQuotesErrorSchema = errorSchema;

export const getQuoteDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    QuoteID: z.string(),
  }),
});

export const getQuoteErrorSchema = z.unknown();

export const updateQuoteErrorSchema = errorSchema;

export const getQuoteAttachmentsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    QuoteID: z.string(),
  }),
});

export const getQuoteAttachmentsResponseSchema = attachmentsSchema;

export const getQuoteAttachmentsErrorSchema = z.unknown();

export const getQuoteAttachmentByIdDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AttachmentID: z.string(),
    QuoteID: z.string(),
  }),
});

export const getQuoteAttachmentByIdErrorSchema = z.unknown();

export const getQuoteAttachmentByFileNameDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    QuoteID: z.string(),
  }),
});

export const getQuoteAttachmentByFileNameErrorSchema = z.unknown();

export const updateQuoteAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    QuoteID: z.string(),
  }),
});

export const updateQuoteAttachmentByFileNameResponseSchema = attachmentsSchema;

export const updateQuoteAttachmentByFileNameErrorSchema = errorSchema;

export const createQuoteAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    QuoteID: z.string(),
  }),
});

export const createQuoteAttachmentByFileNameResponseSchema = attachmentsSchema;

export const createQuoteAttachmentByFileNameErrorSchema = errorSchema;

export const getQuoteHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    QuoteID: z.string(),
  }),
});

export const getQuoteHistoryResponseSchema = historyRecordsSchema;

export const getQuoteHistoryErrorSchema = z.unknown();

export const createQuoteHistoryDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    QuoteID: z.string(),
  }),
});

export const createQuoteHistoryResponseSchema = historyRecordsSchema;

export const createQuoteHistoryErrorSchema = errorSchema;

export const getQuoteAsPdfDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    QuoteID: z.string(),
  }),
});

export const getQuoteAsPdfErrorSchema = z.unknown();

export const getReceiptsDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      unitdp: z.number().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getReceiptsErrorSchema = z.unknown();

export const createReceiptErrorSchema = errorSchema;

export const getReceiptDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ReceiptID: z.string(),
  }),
  query: z
    .object({
      unitdp: z.number().optional(),
    })
    .optional(),
});

export const getReceiptErrorSchema = z.unknown();

export const updateReceiptErrorSchema = errorSchema;

export const getReceiptAttachmentsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ReceiptID: z.string(),
  }),
});

export const getReceiptAttachmentsResponseSchema = attachmentsSchema;

export const getReceiptAttachmentsErrorSchema = z.unknown();

export const getReceiptAttachmentByIdDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AttachmentID: z.string(),
    ReceiptID: z.string(),
  }),
});

export const getReceiptAttachmentByIdErrorSchema = z.unknown();

export const getReceiptAttachmentByFileNameDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    ReceiptID: z.string(),
  }),
});

export const getReceiptAttachmentByFileNameErrorSchema = z.unknown();

export const updateReceiptAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    ReceiptID: z.string(),
  }),
});

export const updateReceiptAttachmentByFileNameResponseSchema = attachmentsSchema;

export const updateReceiptAttachmentByFileNameErrorSchema = errorSchema;

export const createReceiptAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    ReceiptID: z.string(),
  }),
});

export const createReceiptAttachmentByFileNameResponseSchema = attachmentsSchema;

export const createReceiptAttachmentByFileNameErrorSchema = errorSchema;

export const getReceiptHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ReceiptID: z.string(),
  }),
});

export const getReceiptHistoryResponseSchema = historyRecordsSchema;

export const getReceiptHistoryErrorSchema = z.unknown();

export const createReceiptHistoryDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ReceiptID: z.string(),
  }),
});

export const createReceiptHistoryResponseSchema = historyRecordsSchema;

export const createReceiptHistoryErrorSchema = errorSchema;

export const getRepeatingInvoicesDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getRepeatingInvoicesErrorSchema = z.unknown();

export const getRepeatingInvoiceDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    RepeatingInvoiceID: z.string(),
  }),
});

export const getRepeatingInvoiceErrorSchema = z.unknown();

export const getRepeatingInvoiceAttachmentsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    RepeatingInvoiceID: z.string(),
  }),
});

export const getRepeatingInvoiceAttachmentsResponseSchema = attachmentsSchema;

export const getRepeatingInvoiceAttachmentsErrorSchema = z.unknown();

export const getRepeatingInvoiceAttachmentByIdDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    AttachmentID: z.string(),
    RepeatingInvoiceID: z.string(),
  }),
});

export const getRepeatingInvoiceAttachmentByIdErrorSchema = z.unknown();

export const getRepeatingInvoiceAttachmentByFileNameDataSchema = z.object({
  headers: z.object({
    contentType: z.string(),
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    RepeatingInvoiceID: z.string(),
  }),
});

export const getRepeatingInvoiceAttachmentByFileNameErrorSchema = z.unknown();

export const updateRepeatingInvoiceAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    RepeatingInvoiceID: z.string(),
  }),
});

export const updateRepeatingInvoiceAttachmentByFileNameResponseSchema = attachmentsSchema;

export const updateRepeatingInvoiceAttachmentByFileNameErrorSchema = errorSchema;

export const createRepeatingInvoiceAttachmentByFileNameDataSchema = z.object({
  body: z.string(),
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    FileName: z.string(),
    RepeatingInvoiceID: z.string(),
  }),
});

export const createRepeatingInvoiceAttachmentByFileNameResponseSchema = attachmentsSchema;

export const createRepeatingInvoiceAttachmentByFileNameErrorSchema = errorSchema;

export const getRepeatingInvoiceHistoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    RepeatingInvoiceID: z.string(),
  }),
});

export const getRepeatingInvoiceHistoryResponseSchema = historyRecordsSchema;

export const getRepeatingInvoiceHistoryErrorSchema = z.unknown();

export const createRepeatingInvoiceHistoryDataSchema = z.object({
  body: historyRecordsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    RepeatingInvoiceID: z.string(),
  }),
});

export const createRepeatingInvoiceHistoryResponseSchema = historyRecordsSchema;

export const createRepeatingInvoiceHistoryErrorSchema = errorSchema;

export const getReportBaSorGstListDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const reportWithRowsSchema = z.object({
  Reports: z.array(reportWithRowSchema).optional(),
});

export const getReportBaSorGstListErrorSchema = z.unknown();

export const getReportAgedPayablesByContactDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z.object({
    contactId: z.string(),
    date: z.string().optional(),
    fromDate: z.string().optional(),
    toDate: z.string().optional(),
  }),
});

export const getReportAgedPayablesByContactResponseSchema = reportWithRowsSchema;

export const getReportAgedPayablesByContactErrorSchema = z.unknown();

export const getReportAgedReceivablesByContactDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z.object({
    contactId: z.string(),
    date: z.string().optional(),
    fromDate: z.string().optional(),
    toDate: z.string().optional(),
  }),
});

export const getReportAgedReceivablesByContactResponseSchema = reportWithRowsSchema;

export const getReportAgedReceivablesByContactErrorSchema = z.unknown();

export const getReportBalanceSheetDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      date: z.string().optional(),
      paymentsOnly: z.boolean().optional(),
      periods: z.number().optional(),
      standardLayout: z.boolean().optional(),
      timeframe: z.union([z.literal('MONTH'), z.literal('QUARTER'), z.literal('YEAR')]).optional(),
      trackingOptionID1: z.string().optional(),
      trackingOptionID2: z.string().optional(),
    })
    .optional(),
});

export const getReportBalanceSheetResponseSchema = reportWithRowsSchema;

export const getReportBalanceSheetErrorSchema = z.unknown();

export const getReportBankSummaryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      fromDate: z.string().optional(),
      toDate: z.string().optional(),
    })
    .optional(),
});

export const getReportBankSummaryResponseSchema = reportWithRowsSchema;

export const getReportBankSummaryErrorSchema = z.unknown();

export const getReportBudgetSummaryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      date: z.string().optional(),
      period: z.number().optional(),
      timeframe: z.number().optional(),
    })
    .optional(),
});

export const getReportBudgetSummaryResponseSchema = reportWithRowsSchema;

export const getReportBudgetSummaryErrorSchema = z.unknown();

export const getReportExecutiveSummaryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      date: z.string().optional(),
    })
    .optional(),
});

export const getReportExecutiveSummaryResponseSchema = reportWithRowsSchema;

export const getReportExecutiveSummaryErrorSchema = z.unknown();

export const getReportProfitAndLossDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      fromDate: z.string().optional(),
      paymentsOnly: z.boolean().optional(),
      periods: z.number().optional(),
      standardLayout: z.boolean().optional(),
      timeframe: z.union([z.literal('MONTH'), z.literal('QUARTER'), z.literal('YEAR')]).optional(),
      toDate: z.string().optional(),
      trackingCategoryID: z.string().optional(),
      trackingCategoryID2: z.string().optional(),
      trackingOptionID: z.string().optional(),
      trackingOptionID2: z.string().optional(),
    })
    .optional(),
});

export const getReportProfitAndLossResponseSchema = reportWithRowsSchema;

export const getReportProfitAndLossErrorSchema = z.unknown();

export const getReportTenNinetyNineDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      reportYear: z.string().optional(),
    })
    .optional(),
});

export const reportsSchema = z.object({
  Reports: z.array(reportSchema).optional(),
});

export const getReportTenNinetyNineErrorSchema = z.unknown();

export const getReportTrialBalanceDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      date: z.string().optional(),
      paymentsOnly: z.boolean().optional(),
    })
    .optional(),
});

export const getReportTrialBalanceResponseSchema = reportWithRowsSchema;

export const getReportTrialBalanceErrorSchema = z.unknown();

export const getReportBaSorGstDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ReportID: z.string(),
  }),
});

export const getReportBaSorGstResponseSchema = reportWithRowsSchema;

export const getReportBaSorGstErrorSchema = z.unknown();

export const postSetupDataSchema = z.object({
  body: setupSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const importSummaryObjectSchema = z.object({
  ImportSummary: importSummarySchema.optional(),
});

export const postSetupErrorSchema = z.unknown();

export const getTaxRatesDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      TaxType: z.string().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getTaxRatesResponseSchema = taxRatesSchema;

export const getTaxRatesErrorSchema = z.unknown();

export const updateTaxRateDataSchema = z.object({
  body: taxRatesSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const updateTaxRateResponseSchema = taxRatesSchema;

export const updateTaxRateErrorSchema = errorSchema;

export const createTaxRatesDataSchema = z.object({
  body: taxRatesSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const createTaxRatesResponseSchema = taxRatesSchema;

export const createTaxRatesErrorSchema = errorSchema;

export const getTrackingCategoriesDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      includeArchived: z.boolean().optional(),
      order: z.string().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getTrackingCategoriesErrorSchema = z.unknown();

export const trackingCategorySchema = z.object({
  Name: z.string().optional(),
  Option: z.string().optional(),
  Options: z.array(trackingOptionSchema).optional(),
  Status: z.union([z.literal('ACTIVE'), z.literal('ARCHIVED'), z.literal('DELETED')]).optional(),
  TrackingCategoryID: z.string().optional(),
  TrackingOptionID: z.string().optional(),
});

export const trackingCategoriesSchema = z.object({
  TrackingCategories: z.array(trackingCategorySchema).optional(),
});

export const createTrackingCategoryErrorSchema = errorSchema;

export const deleteTrackingCategoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    TrackingCategoryID: z.string(),
  }),
});

export const deleteTrackingCategoryResponseSchema = trackingCategoriesSchema;

export const deleteTrackingCategoryErrorSchema = errorSchema;

export const getTrackingCategoryDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    TrackingCategoryID: z.string(),
  }),
});

export const getTrackingCategoryResponseSchema = trackingCategoriesSchema;

export const getTrackingCategoryErrorSchema = z.unknown();

export const updateTrackingCategoryDataSchema = z.object({
  body: trackingCategorySchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    TrackingCategoryID: z.string(),
  }),
});

export const updateTrackingCategoryResponseSchema = trackingCategoriesSchema;

export const updateTrackingCategoryErrorSchema = errorSchema;

export const createTrackingOptionsDataSchema = z.object({
  body: trackingOptionSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    TrackingCategoryID: z.string(),
  }),
});

export const createTrackingOptionsResponseSchema = trackingOptionsSchema;

export const createTrackingOptionsErrorSchema = errorSchema;

export const deleteTrackingOptionsDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    TrackingCategoryID: z.string(),
    TrackingOptionID: z.string(),
  }),
});

export const deleteTrackingOptionsResponseSchema = trackingOptionsSchema;

export const deleteTrackingOptionsErrorSchema = errorSchema;

export const updateTrackingOptionsDataSchema = z.object({
  body: trackingOptionSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    TrackingCategoryID: z.string(),
    TrackingOptionID: z.string(),
  }),
});

export const updateTrackingOptionsResponseSchema = trackingOptionsSchema;

export const updateTrackingOptionsErrorSchema = errorSchema;

export const getUsersDataSchema = z.object({
  headers: z.object({
    'If-Modified-Since': z.string().optional(),
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      order: z.string().optional(),
      where: z.string().optional(),
    })
    .optional(),
});

export const getUsersResponseSchema = usersSchema;

export const getUsersErrorSchema = z.unknown();

export const getUserDataSchema = z.object({
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    UserID: z.string(),
  }),
});

export const getUserResponseSchema = usersSchema;

export const getUserErrorSchema = z.unknown();

export const paymentTermSchema = z.object({
  Bills: billSchema.optional(),
  Sales: billSchema.optional(),
});

export const journalLineSchema = z.object({
  AccountCode: z.string().optional(),
  AccountID: z.string().optional(),
  AccountName: z.string().optional(),
  AccountType: accountTypeSchema.optional(),
  Description: z.string().optional(),
  GrossAmount: z.number().optional(),
  JournalLineID: z.string().optional(),
  NetAmount: z.number().optional(),
  TaxAmount: z.number().optional(),
  TaxName: z.string().optional(),
  TaxType: z.string().optional(),
  TrackingCategories: z.array(trackingCategorySchema).optional(),
});

export const journalSchema = z.object({
  CreatedDateUTC: z.string().optional(),
  JournalDate: z.string().optional(),
  JournalID: z.string().optional(),
  JournalLines: z.array(journalLineSchema).optional(),
  JournalNumber: z.number().optional(),
  Reference: z.string().optional(),
  SourceID: z.string().optional(),
  SourceType: z
    .union([
      z.literal('ACCREC'),
      z.literal('ACCPAY'),
      z.literal('ACCRECCREDIT'),
      z.literal('ACCPAYCREDIT'),
      z.literal('ACCRECPAYMENT'),
      z.literal('ACCPAYPAYMENT'),
      z.literal('ARCREDITPAYMENT'),
      z.literal('APCREDITPAYMENT'),
      z.literal('CASHREC'),
      z.literal('CASHPAID'),
      z.literal('TRANSFER'),
      z.literal('ARPREPAYMENT'),
      z.literal('APPREPAYMENT'),
      z.literal('AROVERPAYMENT'),
      z.literal('APOVERPAYMENT'),
      z.literal('EXPCLAIM'),
      z.literal('EXPPAYMENT'),
      z.literal('MANJOURNAL'),
      z.literal('PAYSLIP'),
      z.literal('WAGEPAYABLE'),
      z.literal('INTEGRATEDPAYROLLPE'),
      z.literal('INTEGRATEDPAYROLLPT'),
      z.literal('EXTERNALSPENDMONEY'),
      z.literal('INTEGRATEDPAYROLLPTPAYMENT'),
      z.literal('INTEGRATEDPAYROLLCN'),
    ])
    .optional(),
});

export const manualJournalLineSchema = z.object({
  AccountCode: z.string().optional(),
  AccountID: z.string().optional(),
  Description: z.string().optional(),
  IsBlank: z.boolean().optional(),
  LineAmount: z.number().optional(),
  TaxAmount: z.number().optional(),
  TaxType: z.string().optional(),
  Tracking: z.array(trackingCategorySchema).optional(),
});

export const manualJournalSchema = z.object({
  Attachments: z.array(attachmentSchema).optional(),
  Date: z.string().optional(),
  HasAttachments: z.boolean().optional(),
  JournalLines: z.array(manualJournalLineSchema).optional(),
  LineAmountTypes: lineAmountTypesSchema.optional(),
  ManualJournalID: z.string().optional(),
  Narration: z.string(),
  ShowOnCashBasisReports: z.boolean().optional(),
  Status: z
    .union([z.literal('DRAFT'), z.literal('POSTED'), z.literal('DELETED'), z.literal('VOIDED'), z.literal('ARCHIVED')])
    .optional(),
  StatusAttributeString: z.string().optional(),
  UpdatedDateUTC: z.string().optional(),
  Url: z.string().optional(),
  ValidationErrors: z.array(validationErrorSchema).optional(),
  Warnings: z.array(validationErrorSchema).optional(),
});

export const organisationSchema = z.object({
  APIKey: z.string().optional(),
  Addresses: z.array(addressForOrganisationSchema).optional(),
  BaseCurrency: currencyCodeSchema.optional(),
  Class: z
    .union([
      z.literal('DEMO'),
      z.literal('TRIAL'),
      z.literal('STARTER'),
      z.literal('STANDARD'),
      z.literal('PREMIUM'),
      z.literal('PREMIUM_20'),
      z.literal('PREMIUM_50'),
      z.literal('PREMIUM_100'),
      z.literal('LEDGER'),
      z.literal('GST_CASHBOOK'),
      z.literal('NON_GST_CASHBOOK'),
    ])
    .optional(),
  CountryCode: countryCodeSchema.optional(),
  CreatedDateUTC: z.string().optional(),
  DefaultPurchasesTax: z.string().optional(),
  DefaultSalesTax: z.string().optional(),
  Edition: z.union([z.literal('BUSINESS'), z.literal('PARTNER')]).optional(),
  EmployerIdentificationNumber: z.string().optional(),
  EndOfYearLockDate: z.string().optional(),
  ExternalLinks: z.array(externalLinkSchema).optional(),
  FinancialYearEndDay: z.number().optional(),
  FinancialYearEndMonth: z.number().optional(),
  IsDemoCompany: z.boolean().optional(),
  LegalName: z.string().optional(),
  LineOfBusiness: z.string().optional(),
  Name: z.string().optional(),
  OrganisationEntityType: z
    .union([
      z.literal('ACCOUNTING_PRACTICE'),
      z.literal('COMPANY'),
      z.literal('CHARITY'),
      z.literal('CLUB_OR_SOCIETY'),
      z.literal('LOOK_THROUGH_COMPANY'),
      z.literal('NOT_FOR_PROFIT'),
      z.literal('PARTNERSHIP'),
      z.literal('S_CORPORATION'),
      z.literal('SELF_MANAGED_SUPERANNUATION_FUND'),
      z.literal('SOLE_TRADER'),
      z.literal('SUPERANNUATION_FUND'),
      z.literal('TRUST'),
    ])
    .optional(),
  OrganisationID: z.string().optional(),
  OrganisationStatus: z.string().optional(),
  OrganisationType: z
    .union([
      z.literal('ACCOUNTING_PRACTICE'),
      z.literal('COMPANY'),
      z.literal('CHARITY'),
      z.literal('CLUB_OR_SOCIETY'),
      z.literal('LOOK_THROUGH_COMPANY'),
      z.literal('NOT_FOR_PROFIT'),
      z.literal('PARTNERSHIP'),
      z.literal('S_CORPORATION'),
      z.literal('SELF_MANAGED_SUPERANNUATION_FUND'),
      z.literal('SOLE_TRADER'),
      z.literal('SUPERANNUATION_FUND'),
      z.literal('TRUST'),
    ])
    .optional(),
  PaymentTerms: paymentTermSchema.optional(),
  PaysTax: z.boolean().optional(),
  PeriodLockDate: z.string().optional(),
  Phones: z.array(phoneSchema).optional(),
  RegistrationNumber: z.string().optional(),
  SalesTaxBasis: z
    .union([
      z.literal('PAYMENTS'),
      z.literal('INVOICE'),
      z.literal('NONE'),
      z.literal('CASH'),
      z.literal('ACCRUAL'),
      z.literal('FLATRATECASH'),
      z.literal('FLATRATEACCRUAL'),
      z.literal('ACCRUALS'),
    ])
    .optional(),
  SalesTaxPeriod: z
    .union([
      z.literal('MONTHLY'),
      z.literal('QUARTERLY1'),
      z.literal('QUARTERLY2'),
      z.literal('QUARTERLY3'),
      z.literal('ANNUALLY'),
      z.literal('ONEMONTHS'),
      z.literal('TWOMONTHS'),
      z.literal('SIXMONTHS'),
      z.literal('1MONTHLY'),
      z.literal('2MONTHLY'),
      z.literal('3MONTHLY'),
      z.literal('6MONTHLY'),
      z.literal('QUARTERLY'),
      z.literal('YEARLY'),
      z.literal('NONE'),
    ])
    .optional(),
  ShortCode: z.string().optional(),
  TaxNumber: z.string().optional(),
  Timezone: timeZoneSchema.optional(),
  Version: z
    .union([
      z.literal('AU'),
      z.literal('NZ'),
      z.literal('GLOBAL'),
      z.literal('UK'),
      z.literal('US'),
      z.literal('AUONRAMP'),
      z.literal('NZONRAMP'),
      z.literal('GLOBALONRAMP'),
      z.literal('UKONRAMP'),
      z.literal('USONRAMP'),
    ])
    .optional(),
});

export const organisationsSchema = z.object({
  Organisations: z.array(organisationSchema).optional(),
});

export const getAccountsResponseSchema = accountsSchema;

export const getCurrenciesResponseSchema = currenciesSchema;

export const getEmployeesResponseSchema = employeesSchema;

export const getItemsResponseSchema = itemsSchema;

export const journalsSchema = z.object({
  Journals: z.array(journalSchema).optional(),
});

export const getJournalResponseSchema = journalsSchema;

export const manualJournalsSchema = z.object({
  ManualJournals: z.array(manualJournalSchema).optional(),
});

export const updateOrCreateManualJournalsDataSchema = z.object({
  body: manualJournalsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      summarizeErrors: z.boolean().optional(),
    })
    .optional(),
});

export const updateOrCreateManualJournalsResponseSchema = manualJournalsSchema;

export const createManualJournalsDataSchema = z.object({
  body: manualJournalsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  query: z
    .object({
      summarizeErrors: z.boolean().optional(),
    })
    .optional(),
});

export const createManualJournalsResponseSchema = manualJournalsSchema;

export const getManualJournalResponseSchema = manualJournalsSchema;

export const updateManualJournalDataSchema = z.object({
  body: manualJournalsSchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
  path: z.object({
    ManualJournalID: z.string(),
  }),
});

export const updateManualJournalResponseSchema = manualJournalsSchema;

export const getOrganisationsResponseSchema = organisationsSchema;

export const getReportBaSorGstListResponseSchema = reportWithRowsSchema;

export const getReportTenNinetyNineResponseSchema = reportsSchema;

export const postSetupResponseSchema = importSummaryObjectSchema;

export const getTrackingCategoriesResponseSchema = trackingCategoriesSchema;

export const createTrackingCategoryDataSchema = z.object({
  body: trackingCategorySchema,
  headers: z.object({
    'xero-tenant-id': z.string(),
  }),
});

export const createTrackingCategoryResponseSchema = trackingCategoriesSchema;

export const getJournalsResponseSchema = journalsSchema;

export const getManualJournalsResponseSchema = manualJournalsSchema;

export const allocationSchema: z.ZodSchema<Allocation> = z.lazy(() =>
  z.object({
    Amount: z.number(),
    CreditNote: creditNoteSchema.optional(),
    Date: z.string(),
    Invoice: invoiceSchema,
    Overpayment: overpaymentSchema.optional(),
    Prepayment: prepaymentSchema.optional(),
    StatusAttributeString: z.string().optional(),
    ValidationErrors: z.array(validationErrorSchema).optional(),
  }),
);

export const creditNoteSchema: z.ZodSchema<CreditNote> = z.lazy(() =>
  z.object({
    Allocations: z.array(allocationSchema).optional(),
    AppliedAmount: z.number().optional(),
    BrandingThemeID: z.string().optional(),
    CISDeduction: z.number().optional(),
    CISRate: z.number().optional(),
    Contact: contactSchema.optional(),
    CreditNoteID: z.string().optional(),
    CreditNoteNumber: z.string().optional(),
    CurrencyCode: currencyCodeSchema.optional(),
    CurrencyRate: z.number().optional(),
    Date: z.string().optional(),
    DueDate: z.string().optional(),
    FullyPaidOnDate: z.string().optional(),
    HasAttachments: z.boolean().optional(),
    HasErrors: z.boolean().optional(),
    LineAmountTypes: lineAmountTypesSchema.optional(),
    LineItems: z.array(lineItemSchema).optional(),
    Payments: z.array(paymentSchema).optional(),
    Reference: z.string().optional(),
    RemainingCredit: z.number().optional(),
    SentToContact: z.boolean().optional(),
    Status: z
      .union([
        z.literal('DRAFT'),
        z.literal('SUBMITTED'),
        z.literal('DELETED'),
        z.literal('AUTHORISED'),
        z.literal('PAID'),
        z.literal('VOIDED'),
      ])
      .optional(),
    StatusAttributeString: z.string().optional(),
    SubTotal: z.number().optional(),
    Total: z.number().optional(),
    TotalTax: z.number().optional(),
    Type: z.union([z.literal('ACCPAYCREDIT'), z.literal('ACCRECCREDIT')]).optional(),
    UpdatedDateUTC: z.string().optional(),
    ValidationErrors: z.array(validationErrorSchema).optional(),
    Warnings: z.array(validationErrorSchema).optional(),
  }),
);

export const invoiceSchema: z.ZodSchema<Invoice> = z.lazy(() =>
  z.object({
    AmountCredited: z.number().optional(),
    AmountDue: z.number().optional(),
    AmountPaid: z.number().optional(),
    Attachments: z.array(attachmentSchema).optional(),
    BrandingThemeID: z.string().optional(),
    CISDeduction: z.number().optional(),
    CISRate: z.number().optional(),
    Contact: contactSchema.optional(),
    CreditNotes: z.array(creditNoteSchema).optional(),
    CurrencyCode: currencyCodeSchema.optional(),
    CurrencyRate: z.number().optional(),
    Date: z.string().optional(),
    DueDate: z.string().optional(),
    ExpectedPaymentDate: z.string().optional(),
    FullyPaidOnDate: z.string().optional(),
    HasAttachments: z.boolean().optional(),
    HasErrors: z.boolean().optional(),
    InvoiceID: z.string().optional(),
    InvoiceNumber: z.string().optional(),
    IsDiscounted: z.boolean().optional(),
    LineAmountTypes: lineAmountTypesSchema.optional(),
    LineItems: z.array(lineItemSchema).optional(),
    Overpayments: z.array(overpaymentSchema).optional(),
    Payments: z.array(paymentSchema).optional(),
    PlannedPaymentDate: z.string().optional(),
    Prepayments: z.array(prepaymentSchema).optional(),
    Reference: z.string().optional(),
    RepeatingInvoiceID: z.string().optional(),
    SentToContact: z.boolean().optional(),
    Status: z
      .union([
        z.literal('DRAFT'),
        z.literal('SUBMITTED'),
        z.literal('DELETED'),
        z.literal('AUTHORISED'),
        z.literal('PAID'),
        z.literal('VOIDED'),
      ])
      .optional(),
    StatusAttributeString: z.string().optional(),
    SubTotal: z.number().optional(),
    Total: z.number().optional(),
    TotalDiscount: z.number().optional(),
    TotalTax: z.number().optional(),
    Type: z
      .union([
        z.literal('ACCPAY'),
        z.literal('ACCPAYCREDIT'),
        z.literal('APOVERPAYMENT'),
        z.literal('APPREPAYMENT'),
        z.literal('ACCREC'),
        z.literal('ACCRECCREDIT'),
        z.literal('AROVERPAYMENT'),
        z.literal('ARPREPAYMENT'),
      ])
      .optional(),
    UpdatedDateUTC: z.string().optional(),
    Url: z.string().optional(),
    ValidationErrors: z.array(validationErrorSchema).optional(),
    Warnings: z.array(validationErrorSchema).optional(),
  }),
);

export const overpaymentSchema: z.ZodSchema<Overpayment> = z.lazy(() =>
  z.object({
    Allocations: z.array(allocationSchema).optional(),
    AppliedAmount: z.number().optional(),
    Attachments: z.array(attachmentSchema).optional(),
    Contact: contactSchema.optional(),
    CurrencyCode: currencyCodeSchema.optional(),
    CurrencyRate: z.number().optional(),
    Date: z.string().optional(),
    HasAttachments: z.boolean().optional(),
    LineAmountTypes: lineAmountTypesSchema.optional(),
    LineItems: z.array(lineItemSchema).optional(),
    OverpaymentID: z.string().optional(),
    Payments: z.array(paymentSchema).optional(),
    RemainingCredit: z.number().optional(),
    Status: z.union([z.literal('AUTHORISED'), z.literal('PAID'), z.literal('VOIDED')]).optional(),
    SubTotal: z.number().optional(),
    Total: z.number().optional(),
    TotalTax: z.number().optional(),
    Type: z
      .union([z.literal('RECEIVE-OVERPAYMENT'), z.literal('SPEND-OVERPAYMENT'), z.literal('AROVERPAYMENT')])
      .optional(),
    UpdatedDateUTC: z.string().optional(),
  }),
);

export const prepaymentSchema: z.ZodSchema<Prepayment> = z.lazy(() =>
  z.object({
    Allocations: z.array(allocationSchema).optional(),
    AppliedAmount: z.number().optional(),
    Attachments: z.array(attachmentSchema).optional(),
    Contact: contactSchema.optional(),
    CurrencyCode: currencyCodeSchema.optional(),
    CurrencyRate: z.number().optional(),
    Date: z.string().optional(),
    HasAttachments: z.boolean().optional(),
    LineAmountTypes: lineAmountTypesSchema.optional(),
    LineItems: z.array(lineItemSchema).optional(),
    PrepaymentID: z.string().optional(),
    Reference: z.string().optional(),
    RemainingCredit: z.number().optional(),
    Status: z.union([z.literal('AUTHORISED'), z.literal('PAID'), z.literal('VOIDED')]).optional(),
    SubTotal: z.number().optional(),
    Total: z.number().optional(),
    TotalTax: z.number().optional(),
    Type: z
      .union([
        z.literal('RECEIVE-PREPAYMENT'),
        z.literal('SPEND-PREPAYMENT'),
        z.literal('ARPREPAYMENT'),
        z.literal('APPREPAYMENT'),
      ])
      .optional(),
    UpdatedDateUTC: z.string().optional(),
  }),
);

export const allocationsSchema: z.ZodSchema<Allocations> = z.lazy(() =>
  z.object({
    Allocations: z.array(allocationSchema).optional(),
  }),
);

export const bankTransactionSchema: z.ZodSchema<BankTransaction> = z.lazy(() =>
  z.object({
    BankAccount: accountSchema,
    BankTransactionID: z.string().optional(),
    Contact: contactSchema.optional(),
    CurrencyCode: currencyCodeSchema.optional(),
    CurrencyRate: z.number().optional(),
    Date: z.string().optional(),
    HasAttachments: z.boolean().optional(),
    IsReconciled: z.boolean().optional(),
    LineAmountTypes: lineAmountTypesSchema.optional(),
    LineItems: z.array(lineItemSchema),
    OverpaymentID: z.string().optional(),
    PrepaymentID: z.string().optional(),
    Reference: z.string().optional(),
    Status: z.union([z.literal('AUTHORISED'), z.literal('DELETED'), z.literal('VOIDED')]).optional(),
    StatusAttributeString: z.string().optional(),
    SubTotal: z.number().optional(),
    Total: z.number().optional(),
    TotalTax: z.number().optional(),
    Type: z.union([
      z.literal('RECEIVE'),
      z.literal('RECEIVE-OVERPAYMENT'),
      z.literal('RECEIVE-PREPAYMENT'),
      z.literal('SPEND'),
      z.literal('SPEND-OVERPAYMENT'),
      z.literal('SPEND-PREPAYMENT'),
      z.literal('RECEIVE-TRANSFER'),
      z.literal('SPEND-TRANSFER'),
    ]),
    UpdatedDateUTC: z.string().optional(),
    Url: z.string().optional(),
    ValidationErrors: z.array(validationErrorSchema).optional(),
  }),
);

export const contactSchema: z.ZodSchema<Contact> = z.lazy(() =>
  z.object({
    AccountNumber: z.string().optional(),
    AccountsPayableTaxType: z.string().optional(),
    AccountsReceivableTaxType: z.string().optional(),
    Addresses: z.array(addressSchema).optional(),
    Attachments: z.array(attachmentSchema).optional(),
    Balances: balancesSchema.optional(),
    BankAccountDetails: z.string().optional(),
    BatchPayments: batchPaymentDetailsSchema.optional(),
    BrandingTheme: brandingThemeSchema.optional(),
    ContactGroups: z.array(contactGroupSchema).optional(),
    ContactID: z.string().optional(),
    ContactNumber: z.string().optional(),
    ContactPersons: z.array(contactPersonSchema).optional(),
    ContactStatus: z.union([z.literal('ACTIVE'), z.literal('ARCHIVED'), z.literal('GDPRREQUEST')]).optional(),
    DefaultCurrency: currencyCodeSchema.optional(),
    Discount: z.number().optional(),
    EmailAddress: z.string().optional(),
    FirstName: z.string().optional(),
    HasAttachments: z.boolean().optional(),
    HasValidationErrors: z.boolean().optional(),
    IsCustomer: z.boolean().optional(),
    IsSupplier: z.boolean().optional(),
    LastName: z.string().optional(),
    Name: z.string().optional(),
    PaymentTerms: paymentTermSchema.optional(),
    Phones: z.array(phoneSchema).optional(),
    PurchasesDefaultAccountCode: z.string().optional(),
    PurchasesTrackingCategories: z.array(salesTrackingCategorySchema).optional(),
    SalesDefaultAccountCode: z.string().optional(),
    SalesTrackingCategories: z.array(salesTrackingCategorySchema).optional(),
    SkypeUserName: z.string().optional(),
    StatusAttributeString: z.string().optional(),
    TaxNumber: z.string().optional(),
    TrackingCategoryName: z.string().optional(),
    TrackingCategoryOption: z.string().optional(),
    UpdatedDateUTC: z.string().optional(),
    ValidationErrors: z.array(validationErrorSchema).optional(),
    Website: z.string().optional(),
    XeroNetworkKey: z.string().optional(),
  }),
);

export const bankTransactionsSchema: z.ZodSchema<BankTransactions> = z.lazy(() =>
  z.object({
    BankTransactions: z.array(bankTransactionSchema).optional(),
  }),
);

export const batchPaymentSchema: z.ZodSchema<BatchPayment> = z.lazy(() =>
  z.object({
    Account: accountSchema.optional(),
    Amount: z.number().optional(),
    BatchPaymentID: z.string().optional(),
    Code: z.string().optional(),
    Date: z.string().optional(),
    DateString: z.string().optional(),
    Details: z.string().optional(),
    IsReconciled: z.string().optional(),
    Narrative: z.string().optional(),
    Particulars: z.string().optional(),
    Payments: z.array(paymentSchema).optional(),
    Reference: z.string().optional(),
    Status: z.union([z.literal('AUTHORISED'), z.literal('DELETED')]).optional(),
    TotalAmount: z.string().optional(),
    Type: z.union([z.literal('PAYBATCH'), z.literal('RECBATCH')]).optional(),
    UpdatedDateUTC: z.string().optional(),
  }),
);

export const paymentSchema: z.ZodSchema<Payment> = z.lazy(() =>
  z.object({
    Account: accountSchema.optional(),
    Amount: z.number().optional(),
    BankAccountNumber: z.string().optional(),
    BatchPaymentID: z.string().optional(),
    Code: z.string().optional(),
    CreditNote: creditNoteSchema.optional(),
    CreditNoteNumber: z.string().optional(),
    CurrencyRate: z.number().optional(),
    Date: z.string().optional(),
    Details: z.string().optional(),
    HasAccount: z.boolean().optional(),
    HasValidationErrors: z.boolean().optional(),
    Invoice: invoiceSchema.optional(),
    InvoiceNumber: z.string().optional(),
    IsReconciled: z.boolean().optional(),
    Overpayment: overpaymentSchema.optional(),
    Particulars: z.string().optional(),
    PaymentID: z.string().optional(),
    PaymentType: z
      .union([
        z.literal('ACCRECPAYMENT'),
        z.literal('ACCPAYPAYMENT'),
        z.literal('ARCREDITPAYMENT'),
        z.literal('APCREDITPAYMENT'),
        z.literal('AROVERPAYMENTPAYMENT'),
        z.literal('ARPREPAYMENTPAYMENT'),
        z.literal('APPREPAYMENTPAYMENT'),
        z.literal('APOVERPAYMENTPAYMENT'),
      ])
      .optional(),
    Prepayment: prepaymentSchema.optional(),
    Reference: z.string().optional(),
    Status: z.union([z.literal('AUTHORISED'), z.literal('DELETED')]).optional(),
    StatusAttributeString: z.string().optional(),
    UpdatedDateUTC: z.string().optional(),
    ValidationErrors: z.array(validationErrorSchema).optional(),
  }),
);

export const batchPaymentsSchema: z.ZodSchema<BatchPayments> = z.lazy(() =>
  z.object({
    BatchPayments: z.array(batchPaymentSchema).optional(),
  }),
);

export const contactGroupSchema: z.ZodSchema<ContactGroup> = z.lazy(() =>
  z.object({
    ContactGroupID: z.string().optional(),
    Contacts: z.array(contactSchema).optional(),
    Name: z.string().optional(),
    Status: z.union([z.literal('ACTIVE'), z.literal('DELETED')]).optional(),
  }),
);

export const contactGroupsSchema: z.ZodSchema<ContactGroups> = z.lazy(() =>
  z.object({
    ContactGroups: z.array(contactGroupSchema).optional(),
  }),
);

export const contactsSchema: z.ZodSchema<Contacts> = z.lazy(() =>
  z.object({
    Contacts: z.array(contactSchema).optional(),
  }),
);

export const creditNotesSchema: z.ZodSchema<CreditNotes> = z.lazy(() =>
  z.object({
    CreditNotes: z.array(creditNoteSchema).optional(),
  }),
);

export const expenseClaimSchema: z.ZodSchema<ExpenseClaim> = z.lazy(() =>
  z.object({
    AmountDue: z.number().optional(),
    AmountPaid: z.number().optional(),
    ExpenseClaimID: z.string().optional(),
    PaymentDueDate: z.string().optional(),
    Payments: z.array(paymentSchema).optional(),
    ReceiptID: z.string().optional(),
    Receipts: z.array(receiptSchema).optional(),
    ReportingDate: z.string().optional(),
    Status: z
      .union([
        z.literal('SUBMITTED'),
        z.literal('AUTHORISED'),
        z.literal('PAID'),
        z.literal('VOIDED'),
        z.literal('DELETED'),
      ])
      .optional(),
    Total: z.number().optional(),
    UpdatedDateUTC: z.string().optional(),
    User: userSchema.optional(),
  }),
);

export const receiptSchema: z.ZodSchema<Receipt> = z.lazy(() =>
  z.object({
    Attachments: z.array(attachmentSchema).optional(),
    Contact: contactSchema.optional(),
    Date: z.string().optional(),
    HasAttachments: z.boolean().optional(),
    LineAmountTypes: lineAmountTypesSchema.optional(),
    LineItems: z.array(lineItemSchema).optional(),
    ReceiptID: z.string().optional(),
    ReceiptNumber: z.string().optional(),
    Reference: z.string().optional(),
    Status: z
      .union([
        z.literal('DRAFT'),
        z.literal('SUBMITTED'),
        z.literal('AUTHORISED'),
        z.literal('DECLINED'),
        z.literal('VOIDED'),
      ])
      .optional(),
    SubTotal: z.number().optional(),
    Total: z.number().optional(),
    TotalTax: z.number().optional(),
    UpdatedDateUTC: z.string().optional(),
    Url: z.string().optional(),
    User: userSchema.optional(),
    ValidationErrors: z.array(validationErrorSchema).optional(),
    Warnings: z.array(validationErrorSchema).optional(),
  }),
);

export const expenseClaimsSchema: z.ZodSchema<ExpenseClaims> = z.lazy(() =>
  z.object({
    ExpenseClaims: z.array(expenseClaimSchema).optional(),
  }),
);

export const invoicesSchema: z.ZodSchema<Invoices> = z.lazy(() =>
  z.object({
    Invoices: z.array(invoiceSchema).optional(),
  }),
);

export const overpaymentsSchema: z.ZodSchema<Overpayments> = z.lazy(() =>
  z.object({
    Overpayments: z.array(overpaymentSchema).optional(),
  }),
);

export const paymentsSchema: z.ZodSchema<Payments> = z.lazy(() =>
  z.object({
    Payments: z.array(paymentSchema).optional(),
  }),
);

export const prepaymentsSchema: z.ZodSchema<Prepayments> = z.lazy(() =>
  z.object({
    Prepayments: z.array(prepaymentSchema).optional(),
  }),
);

export const purchaseOrderSchema: z.ZodSchema<PurchaseOrder> = z.lazy(() =>
  z.object({
    Attachments: z.array(attachmentSchema).optional(),
    AttentionTo: z.string().optional(),
    BrandingThemeID: z.string().optional(),
    Contact: contactSchema.optional(),
    CurrencyCode: currencyCodeSchema.optional(),
    CurrencyRate: z.number().optional(),
    Date: z.string().optional(),
    DeliveryAddress: z.string().optional(),
    DeliveryDate: z.string().optional(),
    DeliveryInstructions: z.string().optional(),
    ExpectedArrivalDate: z.string().optional(),
    HasAttachments: z.boolean().optional(),
    LineAmountTypes: lineAmountTypesSchema.optional(),
    LineItems: z.array(lineItemSchema).optional(),
    PurchaseOrderID: z.string().optional(),
    PurchaseOrderNumber: z.string().optional(),
    Reference: z.string().optional(),
    SentToContact: z.boolean().optional(),
    Status: z
      .union([
        z.literal('DRAFT'),
        z.literal('SUBMITTED'),
        z.literal('AUTHORISED'),
        z.literal('BILLED'),
        z.literal('DELETED'),
      ])
      .optional(),
    StatusAttributeString: z.string().optional(),
    SubTotal: z.number().optional(),
    Telephone: z.string().optional(),
    Total: z.number().optional(),
    TotalDiscount: z.number().optional(),
    TotalTax: z.number().optional(),
    UpdatedDateUTC: z.string().optional(),
    ValidationErrors: z.array(validationErrorSchema).optional(),
    Warnings: z.array(validationErrorSchema).optional(),
  }),
);

export const purchaseOrdersSchema: z.ZodSchema<PurchaseOrders> = z.lazy(() =>
  z.object({
    PurchaseOrders: z.array(purchaseOrderSchema).optional(),
  }),
);

export const quoteSchema: z.ZodSchema<Quote> = z.lazy(() =>
  z.object({
    BrandingThemeID: z.string().optional(),
    Contact: contactSchema.optional(),
    CurrencyCode: currencyCodeSchema.optional(),
    CurrencyRate: z.number().optional(),
    Date: z.string().optional(),
    DateString: z.string().optional(),
    ExpiryDate: z.string().optional(),
    ExpiryDateString: z.string().optional(),
    LineAmountTypes: quoteLineAmountTypesSchema.optional(),
    LineItems: z.array(lineItemSchema).optional(),
    QuoteID: z.string().optional(),
    QuoteNumber: z.string().optional(),
    Reference: z.string().optional(),
    Status: quoteStatusCodesSchema.optional(),
    StatusAttributeString: z.string().optional(),
    SubTotal: z.number().optional(),
    Summary: z.string().optional(),
    Terms: z.string().optional(),
    Title: z.string().optional(),
    Total: z.number().optional(),
    TotalDiscount: z.number().optional(),
    TotalTax: z.number().optional(),
    UpdatedDateUTC: z.string().optional(),
    ValidationErrors: z.array(validationErrorSchema).optional(),
  }),
);

export const quotesSchema: z.ZodSchema<Quotes> = z.lazy(() =>
  z.object({
    Quotes: z.array(quoteSchema).optional(),
  }),
);

export const receiptsSchema: z.ZodSchema<Receipts> = z.lazy(() =>
  z.object({
    Receipts: z.array(receiptSchema).optional(),
  }),
);

export const repeatingInvoiceSchema: z.ZodSchema<RepeatingInvoice> = z.lazy(() =>
  z.object({
    Attachments: z.array(attachmentSchema).optional(),
    BrandingThemeID: z.string().optional(),
    Contact: contactSchema.optional(),
    CurrencyCode: currencyCodeSchema.optional(),
    HasAttachments: z.boolean().optional(),
    ID: z.string().optional(),
    LineAmountTypes: lineAmountTypesSchema.optional(),
    LineItems: z.array(lineItemSchema).optional(),
    Reference: z.string().optional(),
    RepeatingInvoiceID: z.string().optional(),
    Schedule: scheduleSchema.optional(),
    Status: z.union([z.literal('DRAFT'), z.literal('AUTHORISED'), z.literal('DELETED')]).optional(),
    SubTotal: z.number().optional(),
    Total: z.number().optional(),
    TotalTax: z.number().optional(),
    Type: z.union([z.literal('ACCPAY'), z.literal('ACCREC')]).optional(),
  }),
);

export const repeatingInvoicesSchema: z.ZodSchema<RepeatingInvoices> = z.lazy(() =>
  z.object({
    RepeatingInvoices: z.array(repeatingInvoiceSchema).optional(),
  }),
);

export const getBankTransactionsResponseSchema: z.ZodSchema<GetBankTransactionsResponse> = z.lazy(
  () => bankTransactionsSchema,
);

export const updateOrCreateBankTransactionsDataSchema: z.ZodSchema<UpdateOrCreateBankTransactionsData> = z.lazy(() =>
  z.object({
    body: bankTransactionsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
        unitdp: z.number().optional(),
      })
      .optional(),
  }),
);

export const updateOrCreateBankTransactionsResponseSchema: z.ZodSchema<UpdateOrCreateBankTransactionsResponse> = z.lazy(
  () => bankTransactionsSchema,
);

export const createBankTransactionsDataSchema: z.ZodSchema<CreateBankTransactionsData> = z.lazy(() =>
  z.object({
    body: bankTransactionsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
        unitdp: z.number().optional(),
      })
      .optional(),
  }),
);

export const createBankTransactionsResponseSchema: z.ZodSchema<CreateBankTransactionsResponse> = z.lazy(
  () => bankTransactionsSchema,
);

export const getBankTransactionResponseSchema: z.ZodSchema<GetBankTransactionResponse> = z.lazy(
  () => bankTransactionsSchema,
);

export const updateBankTransactionDataSchema: z.ZodSchema<UpdateBankTransactionData> = z.lazy(() =>
  z.object({
    body: bankTransactionsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      BankTransactionID: z.string(),
    }),
    query: z
      .object({
        unitdp: z.number().optional(),
      })
      .optional(),
  }),
);

export const updateBankTransactionResponseSchema: z.ZodSchema<UpdateBankTransactionResponse> = z.lazy(
  () => bankTransactionsSchema,
);

export const getBatchPaymentsResponseSchema: z.ZodSchema<GetBatchPaymentsResponse> = z.lazy(() => batchPaymentsSchema);

export const createBatchPaymentDataSchema: z.ZodSchema<CreateBatchPaymentData> = z.lazy(() =>
  z.object({
    body: batchPaymentsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
      })
      .optional(),
  }),
);

export const createBatchPaymentResponseSchema: z.ZodSchema<CreateBatchPaymentResponse> = z.lazy(
  () => batchPaymentsSchema,
);

export const getContactGroupsResponseSchema: z.ZodSchema<GetContactGroupsResponse> = z.lazy(() => contactGroupsSchema);

export const createContactGroupDataSchema: z.ZodSchema<CreateContactGroupData> = z.lazy(() =>
  z.object({
    body: contactGroupsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
  }),
);

export const createContactGroupResponseSchema: z.ZodSchema<CreateContactGroupResponse> = z.lazy(
  () => contactGroupsSchema,
);

export const getContactGroupResponseSchema: z.ZodSchema<GetContactGroupResponse> = z.lazy(() => contactGroupsSchema);

export const updateContactGroupDataSchema: z.ZodSchema<UpdateContactGroupData> = z.lazy(() =>
  z.object({
    body: contactGroupsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      ContactGroupID: z.string(),
    }),
  }),
);

export const updateContactGroupResponseSchema: z.ZodSchema<UpdateContactGroupResponse> = z.lazy(
  () => contactGroupsSchema,
);

export const createContactGroupContactsDataSchema: z.ZodSchema<CreateContactGroupContactsData> = z.lazy(() =>
  z.object({
    body: contactsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      ContactGroupID: z.string(),
    }),
  }),
);

export const createContactGroupContactsResponseSchema: z.ZodSchema<CreateContactGroupContactsResponse> = z.lazy(
  () => contactsSchema,
);

export const getContactsResponseSchema: z.ZodSchema<GetContactsResponse> = z.lazy(() => contactsSchema);

export const updateOrCreateContactsDataSchema: z.ZodSchema<UpdateOrCreateContactsData> = z.lazy(() =>
  z.object({
    body: contactsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
      })
      .optional(),
  }),
);

export const updateOrCreateContactsResponseSchema: z.ZodSchema<UpdateOrCreateContactsResponse> = z.lazy(
  () => contactsSchema,
);

export const createContactsDataSchema: z.ZodSchema<CreateContactsData> = z.lazy(() =>
  z.object({
    body: contactsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
      })
      .optional(),
  }),
);

export const createContactsResponseSchema: z.ZodSchema<CreateContactsResponse> = z.lazy(() => contactsSchema);

export const getContactResponseSchema: z.ZodSchema<GetContactResponse> = z.lazy(() => contactsSchema);

export const updateContactDataSchema: z.ZodSchema<UpdateContactData> = z.lazy(() =>
  z.object({
    body: contactsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      ContactID: z.string(),
    }),
  }),
);

export const updateContactResponseSchema: z.ZodSchema<UpdateContactResponse> = z.lazy(() => contactsSchema);

export const getContactByContactNumberResponseSchema: z.ZodSchema<GetContactByContactNumberResponse> = z.lazy(
  () => contactsSchema,
);

export const getCreditNotesResponseSchema: z.ZodSchema<GetCreditNotesResponse> = z.lazy(() => creditNotesSchema);

export const updateOrCreateCreditNotesDataSchema: z.ZodSchema<UpdateOrCreateCreditNotesData> = z.lazy(() =>
  z.object({
    body: creditNotesSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
        unitdp: z.number().optional(),
      })
      .optional(),
  }),
);

export const updateOrCreateCreditNotesResponseSchema: z.ZodSchema<UpdateOrCreateCreditNotesResponse> = z.lazy(
  () => creditNotesSchema,
);

export const createCreditNotesDataSchema: z.ZodSchema<CreateCreditNotesData> = z.lazy(() =>
  z.object({
    body: creditNotesSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
        unitdp: z.number().optional(),
      })
      .optional(),
  }),
);

export const createCreditNotesResponseSchema: z.ZodSchema<CreateCreditNotesResponse> = z.lazy(() => creditNotesSchema);

export const getCreditNoteResponseSchema: z.ZodSchema<GetCreditNoteResponse> = z.lazy(() => creditNotesSchema);

export const updateCreditNoteDataSchema: z.ZodSchema<UpdateCreditNoteData> = z.lazy(() =>
  z.object({
    body: creditNotesSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      CreditNoteID: z.string(),
    }),
    query: z
      .object({
        unitdp: z.number().optional(),
      })
      .optional(),
  }),
);

export const updateCreditNoteResponseSchema: z.ZodSchema<UpdateCreditNoteResponse> = z.lazy(() => creditNotesSchema);

export const createCreditNoteAllocationDataSchema: z.ZodSchema<CreateCreditNoteAllocationData> = z.lazy(() =>
  z.object({
    body: allocationsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      CreditNoteID: z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
      })
      .optional(),
  }),
);

export const createCreditNoteAllocationResponseSchema: z.ZodSchema<CreateCreditNoteAllocationResponse> = z.lazy(
  () => allocationsSchema,
);

export const getExpenseClaimsResponseSchema: z.ZodSchema<GetExpenseClaimsResponse> = z.lazy(() => expenseClaimsSchema);

export const createExpenseClaimsDataSchema: z.ZodSchema<CreateExpenseClaimsData> = z.lazy(() =>
  z.object({
    body: expenseClaimsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
  }),
);

export const createExpenseClaimsResponseSchema: z.ZodSchema<CreateExpenseClaimsResponse> = z.lazy(
  () => expenseClaimsSchema,
);

export const getExpenseClaimResponseSchema: z.ZodSchema<GetExpenseClaimResponse> = z.lazy(() => expenseClaimsSchema);

export const updateExpenseClaimDataSchema: z.ZodSchema<UpdateExpenseClaimData> = z.lazy(() =>
  z.object({
    body: expenseClaimsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      ExpenseClaimID: z.string(),
    }),
  }),
);

export const updateExpenseClaimResponseSchema: z.ZodSchema<UpdateExpenseClaimResponse> = z.lazy(
  () => expenseClaimsSchema,
);

export const getInvoicesResponseSchema: z.ZodSchema<GetInvoicesResponse> = z.lazy(() => invoicesSchema);

export const updateOrCreateInvoicesDataSchema: z.ZodSchema<UpdateOrCreateInvoicesData> = z.lazy(() =>
  z.object({
    body: invoicesSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
        unitdp: z.number().optional(),
      })
      .optional(),
  }),
);

export const updateOrCreateInvoicesResponseSchema: z.ZodSchema<UpdateOrCreateInvoicesResponse> = z.lazy(
  () => invoicesSchema,
);

export const createInvoicesDataSchema: z.ZodSchema<CreateInvoicesData> = z.lazy(() =>
  z.object({
    body: invoicesSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
        unitdp: z.number().optional(),
      })
      .optional(),
  }),
);

export const createInvoicesResponseSchema: z.ZodSchema<CreateInvoicesResponse> = z.lazy(() => invoicesSchema);

export const getInvoiceResponseSchema: z.ZodSchema<GetInvoiceResponse> = z.lazy(() => invoicesSchema);

export const updateInvoiceDataSchema: z.ZodSchema<UpdateInvoiceData> = z.lazy(() =>
  z.object({
    body: invoicesSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      InvoiceID: z.string(),
    }),
    query: z
      .object({
        unitdp: z.number().optional(),
      })
      .optional(),
  }),
);

export const updateInvoiceResponseSchema: z.ZodSchema<UpdateInvoiceResponse> = z.lazy(() => invoicesSchema);

export const getOverpaymentsResponseSchema: z.ZodSchema<GetOverpaymentsResponse> = z.lazy(() => overpaymentsSchema);

export const getOverpaymentResponseSchema: z.ZodSchema<GetOverpaymentResponse> = z.lazy(() => overpaymentsSchema);

export const createOverpaymentAllocationsDataSchema: z.ZodSchema<CreateOverpaymentAllocationsData> = z.lazy(() =>
  z.object({
    body: allocationsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      OverpaymentID: z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
      })
      .optional(),
  }),
);

export const createOverpaymentAllocationsResponseSchema: z.ZodSchema<CreateOverpaymentAllocationsResponse> = z.lazy(
  () => allocationsSchema,
);

export const getPaymentsResponseSchema: z.ZodSchema<GetPaymentsResponse> = z.lazy(() => paymentsSchema);

export const createPaymentDataSchema: z.ZodSchema<CreatePaymentData> = z.lazy(() =>
  z.object({
    body: paymentSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
  }),
);

export const createPaymentResponseSchema: z.ZodSchema<CreatePaymentResponse> = z.lazy(() => paymentsSchema);

export const createPaymentsDataSchema: z.ZodSchema<CreatePaymentsData> = z.lazy(() =>
  z.object({
    body: paymentsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
      })
      .optional(),
  }),
);

export const createPaymentsResponseSchema: z.ZodSchema<CreatePaymentsResponse> = z.lazy(() => paymentsSchema);

export const getPaymentResponseSchema: z.ZodSchema<GetPaymentResponse> = z.lazy(() => paymentsSchema);

export const deletePaymentResponseSchema: z.ZodSchema<DeletePaymentResponse> = z.lazy(() => paymentsSchema);

export const getPrepaymentsResponseSchema: z.ZodSchema<GetPrepaymentsResponse> = z.lazy(() => prepaymentsSchema);

export const getPrepaymentResponseSchema: z.ZodSchema<GetPrepaymentResponse> = z.lazy(() => prepaymentsSchema);

export const createPrepaymentAllocationsDataSchema: z.ZodSchema<CreatePrepaymentAllocationsData> = z.lazy(() =>
  z.object({
    body: allocationsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      PrepaymentID: z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
      })
      .optional(),
  }),
);

export const createPrepaymentAllocationsResponseSchema: z.ZodSchema<CreatePrepaymentAllocationsResponse> = z.lazy(
  () => allocationsSchema,
);

export const getPurchaseOrdersResponseSchema: z.ZodSchema<GetPurchaseOrdersResponse> = z.lazy(
  () => purchaseOrdersSchema,
);

export const updateOrCreatePurchaseOrdersDataSchema: z.ZodSchema<UpdateOrCreatePurchaseOrdersData> = z.lazy(() =>
  z.object({
    body: purchaseOrdersSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
      })
      .optional(),
  }),
);

export const updateOrCreatePurchaseOrdersResponseSchema: z.ZodSchema<UpdateOrCreatePurchaseOrdersResponse> = z.lazy(
  () => purchaseOrdersSchema,
);

export const createPurchaseOrdersDataSchema: z.ZodSchema<CreatePurchaseOrdersData> = z.lazy(() =>
  z.object({
    body: purchaseOrdersSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
      })
      .optional(),
  }),
);

export const createPurchaseOrdersResponseSchema: z.ZodSchema<CreatePurchaseOrdersResponse> = z.lazy(
  () => purchaseOrdersSchema,
);

export const getPurchaseOrderResponseSchema: z.ZodSchema<GetPurchaseOrderResponse> = z.lazy(() => purchaseOrdersSchema);

export const updatePurchaseOrderDataSchema: z.ZodSchema<UpdatePurchaseOrderData> = z.lazy(() =>
  z.object({
    body: purchaseOrdersSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      PurchaseOrderID: z.string(),
    }),
  }),
);

export const updatePurchaseOrderResponseSchema: z.ZodSchema<UpdatePurchaseOrderResponse> = z.lazy(
  () => purchaseOrdersSchema,
);

export const getPurchaseOrderByNumberResponseSchema: z.ZodSchema<GetPurchaseOrderByNumberResponse> = z.lazy(
  () => purchaseOrdersSchema,
);

export const getQuotesResponseSchema: z.ZodSchema<GetQuotesResponse> = z.lazy(() => quotesSchema);

export const updateOrCreateQuotesDataSchema: z.ZodSchema<UpdateOrCreateQuotesData> = z.lazy(() =>
  z.object({
    body: quotesSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
      })
      .optional(),
  }),
);

export const updateOrCreateQuotesResponseSchema: z.ZodSchema<UpdateOrCreateQuotesResponse> = z.lazy(() => quotesSchema);

export const createQuotesDataSchema: z.ZodSchema<CreateQuotesData> = z.lazy(() =>
  z.object({
    body: quotesSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        summarizeErrors: z.boolean().optional(),
      })
      .optional(),
  }),
);

export const createQuotesResponseSchema: z.ZodSchema<CreateQuotesResponse> = z.lazy(() => quotesSchema);

export const getQuoteResponseSchema: z.ZodSchema<GetQuoteResponse> = z.lazy(() => quotesSchema);

export const updateQuoteDataSchema: z.ZodSchema<UpdateQuoteData> = z.lazy(() =>
  z.object({
    body: quotesSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      QuoteID: z.string(),
    }),
  }),
);

export const updateQuoteResponseSchema: z.ZodSchema<UpdateQuoteResponse> = z.lazy(() => quotesSchema);

export const getReceiptsResponseSchema: z.ZodSchema<GetReceiptsResponse> = z.lazy(() => receiptsSchema);

export const createReceiptDataSchema: z.ZodSchema<CreateReceiptData> = z.lazy(() =>
  z.object({
    body: receiptsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    query: z
      .object({
        unitdp: z.number().optional(),
      })
      .optional(),
  }),
);

export const createReceiptResponseSchema: z.ZodSchema<CreateReceiptResponse> = z.lazy(() => receiptsSchema);

export const getReceiptResponseSchema: z.ZodSchema<GetReceiptResponse> = z.lazy(() => receiptsSchema);

export const updateReceiptDataSchema: z.ZodSchema<UpdateReceiptData> = z.lazy(() =>
  z.object({
    body: receiptsSchema,
    headers: z.object({
      'xero-tenant-id': z.string(),
    }),
    path: z.object({
      ReceiptID: z.string(),
    }),
    query: z
      .object({
        unitdp: z.number().optional(),
      })
      .optional(),
  }),
);

export const updateReceiptResponseSchema: z.ZodSchema<UpdateReceiptResponse> = z.lazy(() => receiptsSchema);

export const getRepeatingInvoicesResponseSchema: z.ZodSchema<GetRepeatingInvoicesResponse> = z.lazy(
  () => repeatingInvoicesSchema,
);

export const getRepeatingInvoiceResponseSchema: z.ZodSchema<GetRepeatingInvoiceResponse> = z.lazy(
  () => repeatingInvoicesSchema,
);
