// This file is auto-generated by @hey-api/openapi-ts

export type Account = {
  /**
   * The Xero identifier for an account – specified as a string following  the endpoint name   e.g. /297c2dc5-cc47-4afd-8ec8-74990b8761e9
   */
  AccountID?: string;
  /**
   * Boolean – describes whether the account is shown in the watchlist widget on the dashboard
   */
  AddToWatchlist?: boolean;
  /**
   * For bank accounts only (Account Type BANK)
   */
  BankAccountNumber?: string;
  /**
   * For bank accounts only. See Bank Account types
   */
  BankAccountType?: 'BANK' | 'CREDITCARD' | 'PAYPAL' | 'NONE' | '';
  /**
   * See Account Class Types
   */
  readonly Class?: 'ASSET' | 'EQUITY' | 'EXPENSE' | 'LIABILITY' | 'REVENUE';
  /**
   * Customer defined alpha numeric account code e.g 200 or SALES (max length = 10)
   */
  Code?: string;
  CurrencyCode?: CurrencyCode;
  /**
   * Description of the Account. Valid for all types of accounts except bank accounts (max length = 4000)
   */
  Description?: string;
  /**
   * Boolean – describes whether account can have payments applied to it
   */
  EnablePaymentsToAccount?: boolean;
  /**
   * boolean to indicate if an account has an attachment (read only)
   */
  readonly HasAttachments?: boolean;
  /**
   * Name of account (max length = 150)
   */
  Name?: string;
  /**
   * Shown if set
   */
  ReportingCode?: string;
  /**
   * Shown if set
   */
  readonly ReportingCodeName?: string;
  /**
   * Boolean – describes whether account code is available for use with expense claims
   */
  ShowInExpenseClaims?: boolean;
  /**
   * Accounts with a status of ACTIVE can be updated to ARCHIVED. See Account Status Codes
   */
  Status?: 'ACTIVE' | 'ARCHIVED' | 'DELETED';
  /**
   * If this is a system account then this element is returned. See System Account types. Note that non-system accounts may have this element set as either “” or null.
   */
  readonly SystemAccount?:
    | 'DEBTORS'
    | 'CREDITORS'
    | 'BANKCURRENCYGAIN'
    | 'GST'
    | 'GSTONIMPORTS'
    | 'HISTORICAL'
    | 'REALISEDCURRENCYGAIN'
    | 'RETAINEDEARNINGS'
    | 'ROUNDING'
    | 'TRACKINGTRANSFERS'
    | 'UNPAIDEXPCLM'
    | 'UNREALISEDCURRENCYGAIN'
    | 'WAGEPAYABLES'
    | 'CISASSETS'
    | 'CISASSET'
    | 'CISLABOUR'
    | 'CISLABOUREXPENSE'
    | 'CISLABOURINCOME'
    | 'CISLIABILITY'
    | 'CISMATERIALS'
    | '';
  /**
   * The tax type from TaxRates
   */
  TaxType?: string;
  Type?: AccountType;
  /**
   * Last modified date UTC format
   */
  readonly UpdatedDateUTC?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
};

/**
 * For bank accounts only. See Bank Account types
 */
export type BankAccountType = 'BANK' | 'CREDITCARD' | 'PAYPAL' | 'NONE' | '';

/**
 * See Account Class Types
 */
export type Class = 'ASSET' | 'EQUITY' | 'EXPENSE' | 'LIABILITY' | 'REVENUE';

/**
 * Accounts with a status of ACTIVE can be updated to ARCHIVED. See Account Status Codes
 */
export type Status = 'ACTIVE' | 'ARCHIVED' | 'DELETED';

/**
 * If this is a system account then this element is returned. See System Account types. Note that non-system accounts may have this element set as either “” or null.
 */
export type SystemAccount =
  | 'DEBTORS'
  | 'CREDITORS'
  | 'BANKCURRENCYGAIN'
  | 'GST'
  | 'GSTONIMPORTS'
  | 'HISTORICAL'
  | 'REALISEDCURRENCYGAIN'
  | 'RETAINEDEARNINGS'
  | 'ROUNDING'
  | 'TRACKINGTRANSFERS'
  | 'UNPAIDEXPCLM'
  | 'UNREALISEDCURRENCYGAIN'
  | 'WAGEPAYABLES'
  | 'CISASSETS'
  | 'CISASSET'
  | 'CISLABOUR'
  | 'CISLABOUREXPENSE'
  | 'CISLABOURINCOME'
  | 'CISLIABILITY'
  | 'CISMATERIALS'
  | '';

/**
 * See Account Types
 */
export type AccountType =
  | 'BANK'
  | 'CURRENT'
  | 'CURRLIAB'
  | 'DEPRECIATN'
  | 'DIRECTCOSTS'
  | 'EQUITY'
  | 'EXPENSE'
  | 'FIXED'
  | 'INVENTORY'
  | 'LIABILITY'
  | 'NONCURRENT'
  | 'OTHERINCOME'
  | 'OVERHEADS'
  | 'PREPAYMENT'
  | 'REVENUE'
  | 'SALES'
  | 'TERMLIAB'
  | 'PAYGLIABILITY'
  | 'PAYG'
  | 'SUPERANNUATIONEXPENSE'
  | 'SUPERANNUATIONLIABILITY'
  | 'WAGESEXPENSE';

export type Accounts = {
  Accounts?: Array<Account>;
};

export type AccountsPayable = {
  Outstanding?: number;
  Overdue?: number;
};

export type AccountsReceivable = {
  Outstanding?: number;
  Overdue?: number;
};

export type Action = {
  /**
   * Name of the actions for this organisation
   */
  Name?: string;
  /**
   * Status of the action for this organisation
   */
  Status?: 'ALLOWED' | 'NOT-ALLOWED';
};

/**
 * Status of the action for this organisation
 */
export type Status2 = 'ALLOWED' | 'NOT-ALLOWED';

export type Actions = {
  Actions?: Array<Action>;
};

export type Address = {
  /**
   * max length = 500
   */
  AddressLine1?: string;
  /**
   * max length = 500
   */
  AddressLine2?: string;
  /**
   * max length = 500
   */
  AddressLine3?: string;
  /**
   * max length = 500
   */
  AddressLine4?: string;
  /**
   * define the type of address
   */
  AddressType?: 'POBOX' | 'STREET';
  /**
   * max length = 255
   */
  AttentionTo?: string;
  /**
   * max length = 255
   */
  City?: string;
  /**
   * max length = 50, [A-Z], [a-z] only
   */
  Country?: string;
  /**
   * max length = 50
   */
  PostalCode?: string;
  /**
   * max length = 255
   */
  Region?: string;
};

/**
 * define the type of address
 */
export type AddressType = 'POBOX' | 'STREET';

export type AddressForOrganisation = {
  /**
   * max length = 500
   */
  AddressLine1?: string;
  /**
   * max length = 500
   */
  AddressLine2?: string;
  /**
   * max length = 500
   */
  AddressLine3?: string;
  /**
   * max length = 500
   */
  AddressLine4?: string;
  /**
   * define the type of address
   */
  AddressType?: 'POBOX' | 'STREET' | 'DELIVERY';
  /**
   * max length = 255
   */
  AttentionTo?: string;
  /**
   * max length = 255
   */
  City?: string;
  /**
   * max length = 50, [A-Z], [a-z] only
   */
  Country?: string;
  /**
   * max length = 50
   */
  PostalCode?: string;
  /**
   * max length = 255
   */
  Region?: string;
};

/**
 * define the type of address
 */
export type AddressType2 = 'POBOX' | 'STREET' | 'DELIVERY';

export type Allocation = {
  /**
   * the amount being applied to the invoice
   */
  Amount: number;
  CreditNote?: CreditNote;
  /**
   * the date the allocation is applied YYYY-MM-DD.
   */
  Date: string;
  Invoice: Invoice;
  Overpayment?: Overpayment;
  Prepayment?: Prepayment;
  /**
   * A string to indicate if a invoice status
   */
  StatusAttributeString?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
};

export type Allocations = {
  Allocations?: Array<Allocation>;
};

export type Attachment = {
  /**
   * Unique ID for the file
   */
  AttachmentID?: string;
  /**
   * Length of the file content
   */
  ContentLength?: number;
  /**
   * Name of the file
   */
  FileName?: string;
  /**
   * Include the file with the online invoice
   */
  IncludeOnline?: boolean;
  /**
   * Type of file
   */
  MimeType?: string;
  /**
   * URL to the file on xero.com
   */
  Url?: string;
};

export type Attachments = {
  Attachments?: Array<Attachment>;
};

/**
 * An array to specify multiple currency balances of an account
 */
export type BalanceDetails = {
  /**
   * The opening balances of the account. Debits are positive, credits are negative values
   */
  Balance?: number;
  /**
   * The currency of the balance (Not required for base currency)
   */
  CurrencyCode?: string;
  /**
   * (Optional) Exchange rate to base currency when money is spent or received. If not specified, XE rate for the day is applied
   */
  CurrencyRate?: number;
};

/**
 * The raw AccountsReceivable(sales invoices) and AccountsPayable(bills) outstanding and overdue amounts, not converted to base currency (read only)
 */
export type Balances = {
  AccountsPayable?: AccountsPayable;
  AccountsReceivable?: AccountsReceivable;
};

export type BankTransaction = {
  BankAccount: Account;
  /**
   * Xero generated unique identifier for bank transaction
   */
  BankTransactionID?: string;
  Contact?: Contact;
  CurrencyCode?: CurrencyCode;
  /**
   * Exchange rate to base currency when money is spent or received. e.g.0.7500 Only used for bank transactions in non base currency. If this isn’t specified for non base currency accounts then either the user-defined rate (preference) or the XE.com day rate will be used. Setting currency is only supported on overpayments.
   */
  CurrencyRate?: number;
  /**
   * Date of transaction – YYYY-MM-DD
   */
  Date?: string;
  /**
   * Boolean to indicate if a bank transaction has an attachment
   */
  readonly HasAttachments?: boolean;
  /**
   * Boolean to show if transaction is reconciled
   */
  IsReconciled?: boolean;
  LineAmountTypes?: LineAmountTypes;
  /**
   * See LineItems
   */
  LineItems: Array<LineItem>;
  /**
   * Xero generated unique identifier for an Overpayment. This will be returned on BankTransactions with a Type of SPEND-OVERPAYMENT or RECEIVE-OVERPAYMENT
   */
  readonly OverpaymentID?: string;
  /**
   * Xero generated unique identifier for a Prepayment. This will be returned on BankTransactions with a Type of SPEND-PREPAYMENT or RECEIVE-PREPAYMENT
   */
  readonly PrepaymentID?: string;
  /**
   * Reference for the transaction. Only supported for SPEND and RECEIVE transactions.
   */
  Reference?: string;
  /**
   * See Bank Transaction Status Codes
   */
  Status?: 'AUTHORISED' | 'DELETED' | 'VOIDED';
  /**
   * A string to indicate if a invoice status
   */
  StatusAttributeString?: string;
  /**
   * Total of bank transaction excluding taxes
   */
  SubTotal?: number;
  /**
   * Total of bank transaction tax inclusive
   */
  Total?: number;
  /**
   * Total tax on bank transaction
   */
  TotalTax?: number;
  /**
   * See Bank Transaction Types
   */
  Type:
    | 'RECEIVE'
    | 'RECEIVE-OVERPAYMENT'
    | 'RECEIVE-PREPAYMENT'
    | 'SPEND'
    | 'SPEND-OVERPAYMENT'
    | 'SPEND-PREPAYMENT'
    | 'RECEIVE-TRANSFER'
    | 'SPEND-TRANSFER';
  /**
   * Last modified date UTC format
   */
  readonly UpdatedDateUTC?: string;
  /**
   * URL link to a source document – shown as “Go to App Name”
   */
  Url?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
};

/**
 * See Bank Transaction Status Codes
 */
export type Status3 = 'AUTHORISED' | 'DELETED' | 'VOIDED';

/**
 * See Bank Transaction Types
 */
export type Type =
  | 'RECEIVE'
  | 'RECEIVE-OVERPAYMENT'
  | 'RECEIVE-PREPAYMENT'
  | 'SPEND'
  | 'SPEND-OVERPAYMENT'
  | 'SPEND-PREPAYMENT'
  | 'RECEIVE-TRANSFER'
  | 'SPEND-TRANSFER';

export type BankTransactions = {
  BankTransactions?: Array<BankTransaction>;
};

export type BankTransfer = {
  /**
   * amount of the transaction
   */
  Amount: number;
  /**
   * The identifier of the Bank Transfer
   */
  readonly BankTransferID?: string;
  /**
   * UTC timestamp of creation date of bank transfer
   */
  readonly CreatedDateUTC?: string;
  /**
   * The currency rate
   */
  readonly CurrencyRate?: number;
  /**
   * The date of the Transfer YYYY-MM-DD
   */
  Date?: string;
  FromBankAccount: Account;
  /**
   * The Bank Transaction ID for the source account
   */
  readonly FromBankTransactionID?: string;
  /**
   * Boolean to indicate if a Bank Transfer has an attachment
   */
  readonly HasAttachments?: boolean;
  ToBankAccount: Account;
  /**
   * The Bank Transaction ID for the destination account
   */
  readonly ToBankTransactionID?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
};

export type BankTransfers = {
  BankTransfers?: Array<BankTransfer>;
};

export type BatchPayment = {
  Account?: Account;
  /**
   * The amount of the payment. Must be less than or equal to the outstanding amount owing on the invoice e.g. 200.00
   */
  Amount?: number;
  /**
   * The Xero generated unique identifier for the bank transaction (read-only)
   */
  readonly BatchPaymentID?: string;
  /**
   * (NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.
   */
  Code?: string;
  /**
   * Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06
   */
  Date?: string;
  /**
   * Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06
   */
  DateString?: string;
  /**
   * (Non-NZ Only) These details are sent to the org’s bank as a reference for the batch payment transaction. They will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement imported into Xero. Maximum field length = 18
   */
  Details?: string;
  /**
   * Booelan that tells you if the batch payment has been reconciled (read-only)
   */
  readonly IsReconciled?: string;
  /**
   * (UK Only) Only shows on the statement line in Xero. Max length =18
   */
  Narrative?: string;
  /**
   * (NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.
   */
  Particulars?: string;
  /**
   * An array of payments
   */
  Payments?: Array<Payment>;
  /**
   * (NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.
   */
  Reference?: string;
  /**
   * AUTHORISED or DELETED (read-only). New batch payments will have a status of AUTHORISED. It is not possible to delete batch payments via the API.
   */
  readonly Status?: 'AUTHORISED' | 'DELETED';
  /**
   * The total of the payments that make up the batch (read-only)
   */
  readonly TotalAmount?: string;
  /**
   * PAYBATCH for bill payments or RECBATCH for sales invoice payments (read-only)
   */
  readonly Type?: 'PAYBATCH' | 'RECBATCH';
  /**
   * UTC timestamp of last update to the payment
   */
  readonly UpdatedDateUTC?: string;
};

/**
 * AUTHORISED or DELETED (read-only). New batch payments will have a status of AUTHORISED. It is not possible to delete batch payments via the API.
 */
export type Status4 = 'AUTHORISED' | 'DELETED';

/**
 * PAYBATCH for bill payments or RECBATCH for sales invoice payments (read-only)
 */
export type Type2 = 'PAYBATCH' | 'RECBATCH';

/**
 * Bank details for use on a batch payment stored with each contact
 */
export type BatchPaymentDetails = {
  /**
   * Name of bank for use with Batch Payments
   */
  BankAccountName?: string;
  /**
   * Bank account number for use with Batch Payments
   */
  BankAccountNumber?: string;
  /**
   * (NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.
   */
  Code?: string;
  /**
   * (Non-NZ Only) These details are sent to the org’s bank as a reference for the batch payment transaction. They will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement imported into Xero. Maximum field length = 18
   */
  Details?: string;
  /**
   * (NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.
   */
  Reference?: string;
};

export type BatchPayments = {
  BatchPayments?: Array<BatchPayment>;
};

export type Bill = {
  /**
   * Day of Month (0-31)
   */
  Day?: number;
  Type?: PaymentTermType;
};

export type BrandingTheme = {
  /**
   * Xero identifier
   */
  BrandingThemeID?: string;
  /**
   * UTC timestamp of creation date of branding theme
   */
  readonly CreatedDateUTC?: string;
  /**
   * The location of the image file used as the logo on this branding theme
   */
  LogoUrl?: string;
  /**
   * Name of branding theme
   */
  Name?: string;
  /**
   * Integer – ranked order of branding theme. The default branding theme has a value of 0
   */
  SortOrder?: number;
  /**
   * Always INVOICE
   */
  Type?: 'INVOICE';
};

/**
 * Always INVOICE
 */
export type Type3 = 'INVOICE';

export type BrandingThemes = {
  BrandingThemes?: Array<BrandingTheme>;
};

export type CISOrgSetting = {
  /**
   * true or false - Boolean that describes if the organisation is a CIS Contractor
   */
  CISContractorEnabled?: boolean;
  /**
   * true or false - Boolean that describes if the organisation is a CIS SubContractor
   */
  CISSubContractorEnabled?: boolean;
  /**
   * CIS Deduction rate for the organisation
   */
  readonly Rate?: number;
};

export type CISOrgSettings = {
  CISSettings?: Array<CISOrgSetting>;
};

export type CISSetting = {
  /**
   * Boolean that describes if the contact is a CIS Subcontractor
   */
  CISEnabled?: boolean;
  /**
   * CIS Deduction rate for the contact if he is a subcontractor. If the contact is not CISEnabled, then the rate is not returned
   */
  readonly Rate?: number;
};

export type CISSettings = {
  CISSettings?: Array<CISSetting>;
};

export type Contact = {
  /**
   * A user defined account number. This can be updated via the API and the Xero UI (max length = 50)
   */
  AccountNumber?: string;
  /**
   * The tax type from TaxRates
   */
  AccountsPayableTaxType?: string;
  /**
   * The tax type from TaxRates
   */
  AccountsReceivableTaxType?: string;
  /**
   * Store certain address types for a contact – see address types
   */
  Addresses?: Array<Address>;
  /**
   * Displays array of attachments from the API
   */
  Attachments?: Array<Attachment>;
  Balances?: Balances;
  /**
   * Bank account number of contact
   */
  BankAccountDetails?: string;
  BatchPayments?: BatchPaymentDetails;
  BrandingTheme?: BrandingTheme;
  /**
   * Displays which contact groups a contact is included in
   */
  ContactGroups?: Array<ContactGroup>;
  /**
   * Xero identifier
   */
  ContactID?: string;
  /**
   * This can be updated via the API only i.e. This field is read only on the Xero contact screen, used to identify contacts in external systems (max length = 50). If the Contact Number is used, this is displayed as Contact Code in the Contacts UI in Xero.
   */
  ContactNumber?: string;
  /**
   * See contact persons
   */
  ContactPersons?: Array<ContactPerson>;
  /**
   * Current status of a contact – see contact status types
   */
  ContactStatus?: 'ACTIVE' | 'ARCHIVED' | 'GDPRREQUEST';
  DefaultCurrency?: CurrencyCode;
  /**
   * The default discount rate for the contact (read only)
   */
  readonly Discount?: number;
  /**
   * Email address of contact person (umlauts not supported) (max length  = 255)
   */
  EmailAddress?: string;
  /**
   * First name of contact person (max length = 255)
   */
  FirstName?: string;
  /**
   * A boolean to indicate if a contact has an attachment
   */
  HasAttachments?: boolean;
  /**
   * A boolean to indicate if a contact has an validation errors
   */
  HasValidationErrors?: boolean;
  /**
   * true or false – Boolean that describes if a contact has any AR invoices entered against them. Cannot be set via PUT or POST – it is automatically set when an accounts receivable invoice is generated against this contact.
   */
  IsCustomer?: boolean;
  /**
   * true or false – Boolean that describes if a contact that has any AP  invoices entered against them. Cannot be set via PUT or POST – it is automatically set when an accounts payable invoice is generated against this contact.
   */
  IsSupplier?: boolean;
  /**
   * Last name of contact person (max length = 255)
   */
  LastName?: string;
  /**
   * Full name of contact/organisation (max length = 255)
   */
  Name?: string;
  PaymentTerms?: PaymentTerm;
  /**
   * Store certain phone types for a contact – see phone types
   */
  Phones?: Array<Phone>;
  /**
   * The default purchases account code for contacts
   */
  PurchasesDefaultAccountCode?: string;
  /**
   * The default purchases tracking categories for contacts
   */
  PurchasesTrackingCategories?: Array<SalesTrackingCategory>;
  /**
   * The default sales account code for contacts
   */
  SalesDefaultAccountCode?: string;
  /**
   * The default sales tracking categories for contacts
   */
  SalesTrackingCategories?: Array<SalesTrackingCategory>;
  /**
   * Skype user name of contact
   */
  SkypeUserName?: string;
  /**
   * Status of object
   */
  StatusAttributeString?: string;
  /**
   * Tax number of contact – this is also known as the ABN (Australia), GST Number (New Zealand), VAT Number (UK) or Tax ID Number (US and global) in the Xero UI depending on which regionalized version of Xero you are using (max length = 50)
   */
  TaxNumber?: string;
  /**
   * The name of the Tracking Category assigned to the contact under SalesTrackingCategories and PurchasesTrackingCategories
   */
  TrackingCategoryName?: string;
  /**
   * The name of the Tracking Option assigned to the contact under SalesTrackingCategories and PurchasesTrackingCategories
   */
  TrackingCategoryOption?: string;
  /**
   * UTC timestamp of last update to contact
   */
  readonly UpdatedDateUTC?: string;
  /**
   * Displays validation errors returned from the API
   */
  ValidationErrors?: Array<ValidationError>;
  /**
   * Website address for contact (read only)
   */
  readonly Website?: string;
  /**
   * Store XeroNetworkKey for contacts.
   */
  XeroNetworkKey?: string;
};

/**
 * Current status of a contact – see contact status types
 */
export type ContactStatus = 'ACTIVE' | 'ARCHIVED' | 'GDPRREQUEST';

export type ContactGroup = {
  /**
   * The Xero identifier for an contact group – specified as a string following the endpoint name. e.g. /297c2dc5-cc47-4afd-8ec8-74990b8761e9
   */
  ContactGroupID?: string;
  /**
   * The ContactID and Name of Contacts in a contact group. Returned on GETs when the ContactGroupID is supplied in the URL.
   */
  Contacts?: Array<Contact>;
  /**
   * The Name of the contact group. Required when creating a new contact  group
   */
  Name?: string;
  /**
   * The Status of a contact group. To delete a contact group update the status to DELETED. Only contact groups with a status of ACTIVE are returned on GETs.
   */
  Status?: 'ACTIVE' | 'DELETED';
};

/**
 * The Status of a contact group. To delete a contact group update the status to DELETED. Only contact groups with a status of ACTIVE are returned on GETs.
 */
export type Status5 = 'ACTIVE' | 'DELETED';

export type ContactGroups = {
  ContactGroups?: Array<ContactGroup>;
};

export type ContactPerson = {
  /**
   * Email address of person
   */
  EmailAddress?: string;
  /**
   * First name of person
   */
  FirstName?: string;
  /**
   * boolean to indicate whether contact should be included on emails with invoices etc.
   */
  IncludeInEmails?: boolean;
  /**
   * Last name of person
   */
  LastName?: string;
};

export type Contacts = {
  Contacts?: Array<Contact>;
};

/**
 * Balance supplied for each account that has a value as at the conversion date.
 */
export type ConversionBalances = {
  /**
   * The account code for a account
   */
  AccountCode?: string;
  /**
   * The opening balances of the account. Debits are positive, credits are negative values
   */
  Balance?: number;
  BalanceDetails?: Array<BalanceDetails>;
};

/**
 * The date when the organisation starts using Xero
 */
export type ConversionDate = {
  /**
   * The month the organisation starts using Xero. Value is an integer between 1 and 12
   */
  Month?: number;
  /**
   * The year the organisation starts using Xero. Value is an integer greater than 2006
   */
  Year?: number;
};

export type CountryCode =
  | 'AD'
  | 'AE'
  | 'AF'
  | 'AG'
  | 'AI'
  | 'AL'
  | 'AM'
  | 'AN'
  | 'AO'
  | 'AQ'
  | 'AR'
  | 'AS'
  | 'AT'
  | 'AU'
  | 'AW'
  | 'AZ'
  | 'BA'
  | 'BB'
  | 'BD'
  | 'BE'
  | 'BF'
  | 'BG'
  | 'BH'
  | 'BI'
  | 'BJ'
  | 'BL'
  | 'BM'
  | 'BN'
  | 'BO'
  | 'BR'
  | 'BS'
  | 'BT'
  | 'BW'
  | 'BY'
  | 'BZ'
  | 'CA'
  | 'CC'
  | 'CD'
  | 'CF'
  | 'CG'
  | 'CH'
  | 'CI'
  | 'CK'
  | 'CL'
  | 'CM'
  | 'CN'
  | 'CO'
  | 'CR'
  | 'CU'
  | 'CV'
  | 'CW'
  | 'CX'
  | 'CY'
  | 'CZ'
  | 'DE'
  | 'DJ'
  | 'DK'
  | 'DM'
  | 'DO'
  | 'DZ'
  | 'EC'
  | 'EE'
  | 'EG'
  | 'EH'
  | 'ER'
  | 'ES'
  | 'ET'
  | 'FI'
  | 'FJ'
  | 'FK'
  | 'FM'
  | 'FO'
  | 'FR'
  | 'GA'
  | 'GB'
  | 'GD'
  | 'GE'
  | 'GG'
  | 'GH'
  | 'GI'
  | 'GL'
  | 'GM'
  | 'GN'
  | 'GQ'
  | 'GR'
  | 'GT'
  | 'GU'
  | 'GW'
  | 'GY'
  | 'HK'
  | 'HN'
  | 'HR'
  | 'HT'
  | 'HU'
  | 'ID'
  | 'IE'
  | 'IL'
  | 'IM'
  | 'IN'
  | 'IO'
  | 'IQ'
  | 'IR'
  | 'IS'
  | 'IT'
  | 'JE'
  | 'JM'
  | 'JO'
  | 'JP'
  | 'KE'
  | 'KG'
  | 'KH'
  | 'KI'
  | 'KM'
  | 'KN'
  | 'KP'
  | 'KR'
  | 'KW'
  | 'KY'
  | 'KZ'
  | 'LA'
  | 'LB'
  | 'LC'
  | 'LI'
  | 'LK'
  | 'LR'
  | 'LS'
  | 'LT'
  | 'LU'
  | 'LV'
  | 'LY'
  | 'MA'
  | 'MC'
  | 'MD'
  | 'ME'
  | 'MF'
  | 'MG'
  | 'MH'
  | 'MK'
  | 'ML'
  | 'MM'
  | 'MN'
  | 'MO'
  | 'MP'
  | 'MR'
  | 'MS'
  | 'MT'
  | 'MU'
  | 'MV'
  | 'MW'
  | 'MX'
  | 'MY'
  | 'MZ'
  | 'NA'
  | 'NC'
  | 'NE'
  | 'NG'
  | 'NI'
  | 'NL'
  | 'NO'
  | 'NP'
  | 'NR'
  | 'NU'
  | 'NZ'
  | 'OM'
  | 'PA'
  | 'PE'
  | 'PF'
  | 'PG'
  | 'PH'
  | 'PK'
  | 'PL'
  | 'PM'
  | 'PN'
  | 'PR'
  | 'PS'
  | 'PT'
  | 'PW'
  | 'PY'
  | 'QA'
  | 'RE'
  | 'RO'
  | 'RS'
  | 'RU'
  | 'RW'
  | 'SA'
  | 'SB'
  | 'SC'
  | 'SD'
  | 'SE'
  | 'SG'
  | 'SH'
  | 'SI'
  | 'SJ'
  | 'SK'
  | 'SL'
  | 'SM'
  | 'SN'
  | 'SO'
  | 'SR'
  | 'SS'
  | 'ST'
  | 'SV'
  | 'SX'
  | 'SY'
  | 'SZ'
  | 'TC'
  | 'TD'
  | 'TG'
  | 'TH'
  | 'TJ'
  | 'TK'
  | 'TL'
  | 'TM'
  | 'TN'
  | 'TO'
  | 'TR'
  | 'TT'
  | 'TV'
  | 'TW'
  | 'TZ'
  | 'UA'
  | 'UG'
  | 'US'
  | 'UY'
  | 'UZ'
  | 'VA'
  | 'VC'
  | 'VE'
  | 'VG'
  | 'VI'
  | 'VN'
  | 'VU'
  | 'WF'
  | 'WS'
  | 'XK'
  | 'YE'
  | 'YT'
  | 'ZA'
  | 'ZM'
  | 'ZW';

export type CreditNote = {
  /**
   * See Allocations
   */
  Allocations?: Array<Allocation>;
  /**
   * The amount of applied to an invoice
   */
  AppliedAmount?: number;
  /**
   * See BrandingThemes
   */
  BrandingThemeID?: string;
  /**
   * CIS deduction for UK contractors
   */
  readonly CISDeduction?: number;
  /**
   * CIS Deduction rate for the organisation
   */
  readonly CISRate?: number;
  Contact?: Contact;
  /**
   * Xero generated unique identifier
   */
  CreditNoteID?: string;
  /**
   * ACCRECCREDIT – Unique alpha numeric code identifying credit note (when missing will auto-generate from your Organisation Invoice Settings)
   */
  CreditNoteNumber?: string;
  /**
   * The specified currency code
   */
  CurrencyCode?: CurrencyCode;
  /**
   * The currency rate for a multicurrency invoice. If no rate is specified, the XE.com day rate is used
   */
  CurrencyRate?: number;
  /**
   * The date the credit note is issued YYYY-MM-DD. If the Date element is not specified then it will default to the current date based on the timezone setting of the organisation
   */
  Date?: string;
  /**
   * Date invoice is due – YYYY-MM-DD
   */
  DueDate?: string;
  /**
   * Date when credit note was fully paid(UTC format)
   */
  FullyPaidOnDate?: string;
  /**
   * boolean to indicate if a credit note has an attachment
   */
  HasAttachments?: boolean;
  /**
   * A boolean to indicate if a credit note has an validation errors
   */
  HasErrors?: boolean;
  LineAmountTypes?: LineAmountTypes;
  /**
   * See Invoice Line Items
   */
  LineItems?: Array<LineItem>;
  /**
   * See Payments
   */
  Payments?: Array<Payment>;
  /**
   * ACCRECCREDIT only – additional reference number
   */
  Reference?: string;
  /**
   * The remaining credit balance on the Credit Note
   */
  RemainingCredit?: number;
  /**
   * boolean to indicate if a credit note has been sent to a contact via  the Xero app (currently read only)
   */
  readonly SentToContact?: boolean;
  /**
   * See Credit Note Status Codes
   */
  Status?: 'DRAFT' | 'SUBMITTED' | 'DELETED' | 'AUTHORISED' | 'PAID' | 'VOIDED';
  /**
   * A string to indicate if a invoice status
   */
  StatusAttributeString?: string;
  /**
   * The subtotal of the credit note excluding taxes
   */
  SubTotal?: number;
  /**
   * The total of the Credit Note(subtotal + total tax)
   */
  Total?: number;
  /**
   * The total tax on the credit note
   */
  TotalTax?: number;
  /**
   * See Credit Note Types
   */
  Type?: 'ACCPAYCREDIT' | 'ACCRECCREDIT';
  /**
   * UTC timestamp of last update to the credit note
   */
  readonly UpdatedDateUTC?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
  /**
   * Displays array of warning messages from the API
   */
  Warnings?: Array<ValidationError>;
};

/**
 * See Credit Note Status Codes
 */
export type Status6 = 'DRAFT' | 'SUBMITTED' | 'DELETED' | 'AUTHORISED' | 'PAID' | 'VOIDED';

/**
 * See Credit Note Types
 */
export type Type4 = 'ACCPAYCREDIT' | 'ACCRECCREDIT';

export type CreditNotes = {
  CreditNotes?: Array<CreditNote>;
};

export type Currencies = {
  Currencies?: Array<Currency>;
};

export type Currency = {
  Code?: CurrencyCode;
  /**
   * Name of Currency
   */
  Description?: string;
};

/**
 * 3 letter alpha code for the currency – see list of currency codes
 */
export type CurrencyCode =
  | 'AED'
  | 'AFN'
  | 'ALL'
  | 'AMD'
  | 'ANG'
  | 'AOA'
  | 'ARS'
  | 'AUD'
  | 'AWG'
  | 'AZN'
  | 'BAM'
  | 'BBD'
  | 'BDT'
  | 'BGN'
  | 'BHD'
  | 'BIF'
  | 'BMD'
  | 'BND'
  | 'BOB'
  | 'BRL'
  | 'BSD'
  | 'BTN'
  | 'BWP'
  | 'BYN'
  | 'BYR'
  | 'BZD'
  | 'CAD'
  | 'CDF'
  | 'CHF'
  | 'CLP'
  | 'CNY'
  | 'COP'
  | 'CRC'
  | 'CUC'
  | 'CUP'
  | 'CVE'
  | 'CZK'
  | 'DJF'
  | 'DKK'
  | 'DOP'
  | 'DZD'
  | 'EGP'
  | 'ERN'
  | 'ETB'
  | 'EUR'
  | 'FJD'
  | 'FKP'
  | 'GBP'
  | 'GEL'
  | 'GGP'
  | 'GHS'
  | 'GIP'
  | 'GMD'
  | 'GNF'
  | 'GTQ'
  | 'GYD'
  | 'HKD'
  | 'HNL'
  | 'HRK'
  | 'HTG'
  | 'HUF'
  | 'IDR'
  | 'ILS'
  | 'IMP'
  | 'INR'
  | 'IQD'
  | 'IRR'
  | 'ISK'
  | 'JEP'
  | 'JMD'
  | 'JOD'
  | 'JPY'
  | 'KES'
  | 'KGS'
  | 'KHR'
  | 'KMF'
  | 'KPW'
  | 'KRW'
  | 'KWD'
  | 'KYD'
  | 'KZT'
  | 'LAK'
  | 'LBP'
  | 'LKR'
  | 'LRD'
  | 'LSL'
  | 'LTL'
  | 'LYD'
  | 'MAD'
  | 'MDL'
  | 'MGA'
  | 'MKD'
  | 'MMK'
  | 'MNT'
  | 'MOP'
  | 'MRU'
  | 'MUR'
  | 'MVR'
  | 'MWK'
  | 'MXN'
  | 'MYR'
  | 'MZN'
  | 'NAD'
  | 'NGN'
  | 'NIO'
  | 'NOK'
  | 'NPR'
  | 'NZD'
  | 'OMR'
  | 'PAB'
  | 'PEN'
  | 'PGK'
  | 'PHP'
  | 'PKR'
  | 'PLN'
  | 'PYG'
  | 'QAR'
  | 'RON'
  | 'RSD'
  | 'RUB'
  | 'RWF'
  | 'SAR'
  | 'SBD'
  | 'SCR'
  | 'SDG'
  | 'SEK'
  | 'SGD'
  | 'SHP'
  | 'SLL'
  | 'SOS'
  | 'SPL'
  | 'SRD'
  | 'STN'
  | 'SVC'
  | 'SYP'
  | 'SZL'
  | 'THB'
  | 'TJS'
  | 'TMT'
  | 'TND'
  | 'TOP'
  | 'TRY'
  | 'TTD'
  | 'TVD'
  | 'TWD'
  | 'TZS'
  | 'UAH'
  | 'UGX'
  | 'USD'
  | 'UYU'
  | 'UZS'
  | 'VEF'
  | 'VND'
  | 'VUV'
  | 'WST'
  | 'XAF'
  | 'XCD'
  | 'XDR'
  | 'XOF'
  | 'XPF'
  | 'YER'
  | 'ZAR'
  | 'ZMW'
  | 'ZMK'
  | 'ZWD'
  | '';

export type Element = {
  BankTransactionID?: string;
  /**
   * Unique ID for batch payment object with validation error
   */
  BatchPaymentID?: string;
  ContactID?: string;
  CreditNoteID?: string;
  InvoiceID?: string;
  ItemID?: string;
  PurchaseOrderID?: string;
  /**
   * Array of Validation Error message
   */
  ValidationErrors?: Array<ValidationError>;
};

export type Employee = {
  /**
   * The Xero identifier for an employee e.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9
   */
  EmployeeID?: string;
  ExternalLink?: ExternalLink;
  /**
   * First name of an employee (max length = 255)
   */
  FirstName?: string;
  /**
   * Last name of an employee (max length = 255)
   */
  LastName?: string;
  /**
   * Current status of an employee – see contact status types
   */
  Status?: 'ACTIVE' | 'ARCHIVED' | 'GDPRREQUEST' | 'DELETED';
  /**
   * A string to indicate if a invoice status
   */
  StatusAttributeString?: string;
  readonly UpdatedDateUTC?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
};

/**
 * Current status of an employee – see contact status types
 */
export type Status7 = 'ACTIVE' | 'ARCHIVED' | 'GDPRREQUEST' | 'DELETED';

export type Employees = {
  Employees?: Array<Employee>;
};

export type Error = {
  /**
   * Array of Elements of validation Errors
   */
  Elements?: Array<Element>;
  /**
   * Exception number
   */
  ErrorNumber?: number;
  /**
   * Exception message
   */
  Message?: string;
  /**
   * Exception type
   */
  Type?: string;
};

export type ExpenseClaim = {
  /**
   * The amount due to be paid for an expense claim
   */
  readonly AmountDue?: number;
  /**
   * The amount still to pay for an expense claim
   */
  readonly AmountPaid?: number;
  /**
   * Xero generated unique identifier for an expense claim
   */
  ExpenseClaimID?: string;
  /**
   * The date when the expense claim is due to be paid YYYY-MM-DD
   */
  readonly PaymentDueDate?: string;
  /**
   * See Payments
   */
  Payments?: Array<Payment>;
  /**
   * The Xero identifier for the Receipt e.g. e59a2c7f-1306-4078-a0f3-73537afcbba9
   */
  ReceiptID?: string;
  Receipts?: Array<Receipt>;
  /**
   * The date the expense claim will be reported in Xero YYYY-MM-DD
   */
  readonly ReportingDate?: string;
  /**
   * Current status of an expense claim – see status types
   */
  Status?: 'SUBMITTED' | 'AUTHORISED' | 'PAID' | 'VOIDED' | 'DELETED';
  /**
   * The total of an expense claim being paid
   */
  readonly Total?: number;
  /**
   * Last modified date UTC format
   */
  readonly UpdatedDateUTC?: string;
  User?: User;
};

/**
 * Current status of an expense claim – see status types
 */
export type Status8 = 'SUBMITTED' | 'AUTHORISED' | 'PAID' | 'VOIDED' | 'DELETED';

export type ExpenseClaims = {
  ExpenseClaims?: Array<ExpenseClaim>;
};

export type ExternalLink = {
  Description?: string;
  /**
   * See External link types
   */
  LinkType?: 'Facebook' | 'GooglePlus' | 'LinkedIn' | 'Twitter' | 'Website';
  /**
   * URL for service e.g. http://twitter.com/xeroapi
   */
  Url?: string;
};

/**
 * See External link types
 */
export type LinkType = 'Facebook' | 'GooglePlus' | 'LinkedIn' | 'Twitter' | 'Website';

export type HistoryRecord = {
  /**
   * Name of branding theme
   */
  Changes?: string;
  /**
   * UTC timestamp of creation date of branding theme
   */
  readonly DateUTC?: string;
  /**
   * details
   */
  Details?: string;
  /**
   * has a value of 0
   */
  User?: string;
};

export type HistoryRecords = {
  HistoryRecords?: Array<HistoryRecord>;
};

/**
 * A summary of the import from setup endpoint
 */
export type ImportSummary = {
  Accounts?: ImportSummaryAccounts;
  Organisation?: ImportSummaryOrganisation;
};

/**
 * A summary of the accounts changes
 */
export type ImportSummaryAccounts = {
  /**
   * The number of accounts deleted
   */
  Deleted?: number;
  /**
   * The number of accounts that had an error
   */
  Errored?: number;
  /**
   * The number of locked accounts
   */
  Locked?: number;
  /**
   * The number of new accounts created
   */
  New?: number;
  /**
   * The number of new or updated accounts
   */
  NewOrUpdated?: number;
  Present?: boolean;
  /**
   * The number of system accounts
   */
  System?: number;
  /**
   * The total number of accounts in the org
   */
  Total?: number;
  /**
   * The number of accounts updated
   */
  Updated?: number;
};

export type ImportSummaryObject = {
  ImportSummary?: ImportSummary;
};

export type ImportSummaryOrganisation = {
  Present?: boolean;
};

export type Invoice = {
  /**
   * Sum of all credit notes, over-payments and pre-payments applied to invoice
   */
  readonly AmountCredited?: number;
  /**
   * Amount remaining to be paid on invoice
   */
  readonly AmountDue?: number;
  /**
   * Sum of payments received for invoice
   */
  readonly AmountPaid?: number;
  /**
   * Displays array of attachments from the API
   */
  Attachments?: Array<Attachment>;
  /**
   * See BrandingThemes
   */
  BrandingThemeID?: string;
  /**
   * CIS deduction for UK contractors
   */
  readonly CISDeduction?: number;
  /**
   * CIS Deduction rate for the organisation
   */
  readonly CISRate?: number;
  Contact?: Contact;
  /**
   * Details of credit notes that have been applied to an invoice
   */
  readonly CreditNotes?: Array<CreditNote>;
  CurrencyCode?: CurrencyCode;
  /**
   * The currency rate for a multicurrency invoice. If no rate is specified, the XE.com day rate is used. (max length = [18].[6])
   */
  CurrencyRate?: number;
  /**
   * Date invoice was issued – YYYY-MM-DD. If the Date element is not specified it will default to the current date based on the timezone setting of the organisation
   */
  Date?: string;
  /**
   * Date invoice is due – YYYY-MM-DD
   */
  DueDate?: string;
  /**
   * Shown on sales invoices (Accounts Receivable) when this has been set
   */
  ExpectedPaymentDate?: string;
  /**
   * The date the invoice was fully paid. Only returned on fully paid invoices
   */
  readonly FullyPaidOnDate?: string;
  /**
   * boolean to indicate if an invoice has an attachment
   */
  readonly HasAttachments?: boolean;
  /**
   * A boolean to indicate if a invoice has an validation errors
   */
  HasErrors?: boolean;
  /**
   * Xero generated unique identifier for invoice
   */
  InvoiceID?: string;
  /**
   * ACCREC – Unique alpha numeric code identifying invoice (when missing will auto-generate from your Organisation Invoice Settings) (max length = 255)
   */
  InvoiceNumber?: string;
  /**
   * boolean to indicate if an invoice has a discount
   */
  readonly IsDiscounted?: boolean;
  LineAmountTypes?: LineAmountTypes;
  /**
   * See LineItems
   */
  LineItems?: Array<LineItem>;
  /**
   * See Overpayments
   */
  readonly Overpayments?: Array<Overpayment>;
  /**
   * See Payments
   */
  readonly Payments?: Array<Payment>;
  /**
   * Shown on bills (Accounts Payable) when this has been set
   */
  PlannedPaymentDate?: string;
  /**
   * See Prepayments
   */
  readonly Prepayments?: Array<Prepayment>;
  /**
   * ACCREC only – additional reference number
   */
  Reference?: string;
  /**
   * Xero generated unique identifier for repeating invoices
   */
  RepeatingInvoiceID?: string;
  /**
   * Boolean to set whether the invoice in the Xero app should be marked as “sent”. This can be set only on invoices that have been approved
   */
  SentToContact?: boolean;
  /**
   * See Invoice Status Codes
   */
  Status?: 'DRAFT' | 'SUBMITTED' | 'DELETED' | 'AUTHORISED' | 'PAID' | 'VOIDED';
  /**
   * A string to indicate if a invoice status
   */
  StatusAttributeString?: string;
  /**
   * Total of invoice excluding taxes
   */
  readonly SubTotal?: number;
  /**
   * Total of Invoice tax inclusive (i.e. SubTotal + TotalTax). This will be ignored if it doesn’t equal the sum of the LineAmounts
   */
  readonly Total?: number;
  /**
   * Total of discounts applied on the invoice line items
   */
  readonly TotalDiscount?: number;
  /**
   * Total tax on invoice
   */
  readonly TotalTax?: number;
  /**
   * See Invoice Types
   */
  Type?:
    | 'ACCPAY'
    | 'ACCPAYCREDIT'
    | 'APOVERPAYMENT'
    | 'APPREPAYMENT'
    | 'ACCREC'
    | 'ACCRECCREDIT'
    | 'AROVERPAYMENT'
    | 'ARPREPAYMENT';
  /**
   * Last modified date UTC format
   */
  readonly UpdatedDateUTC?: string;
  /**
   * URL link to a source document – shown as “Go to [appName]” in the Xero app
   */
  Url?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
  /**
   * Displays array of warning messages from the API
   */
  Warnings?: Array<ValidationError>;
};

/**
 * See Invoice Types
 */
export type Type5 =
  | 'ACCPAY'
  | 'ACCPAYCREDIT'
  | 'APOVERPAYMENT'
  | 'APPREPAYMENT'
  | 'ACCREC'
  | 'ACCRECCREDIT'
  | 'AROVERPAYMENT'
  | 'ARPREPAYMENT';

export type InvoiceReminder = {
  /**
   * setting for on or off
   */
  Enabled?: boolean;
};

export type InvoiceReminders = {
  InvoiceReminders?: Array<InvoiceReminder>;
};

export type Invoices = {
  Invoices?: Array<Invoice>;
};

export type Item = {
  /**
   * User defined item code (max length = 30)
   */
  Code: string;
  /**
   * The sales description of the item (max length = 4000)
   */
  Description?: string;
  /**
   * The inventory asset account for the item. The account must be of type INVENTORY. The  COGSAccountCode in PurchaseDetails is also required to create a tracked item
   */
  InventoryAssetAccountCode?: string;
  /**
   * Boolean value, defaults to true. When IsPurchased is true the item is available for purchase transactions in the Xero UI. If IsPurchased is updated to false then PurchaseDescription and PurchaseDetails values will be nulled.
   */
  IsPurchased?: boolean;
  /**
   * Boolean value, defaults to true. When IsSold is true the item will be available on sales transactions in the Xero UI. If IsSold is updated to false then Description and SalesDetails values will be nulled.
   */
  IsSold?: boolean;
  /**
   * True for items that are tracked as inventory. An item will be tracked as inventory if the InventoryAssetAccountCode and COGSAccountCode are set.
   */
  IsTrackedAsInventory?: boolean;
  /**
   * The Xero identifier for an Item
   */
  ItemID?: string;
  /**
   * The name of the item (max length = 50)
   */
  Name?: string;
  /**
   * The purchase description of the item (max length = 4000)
   */
  PurchaseDescription?: string;
  PurchaseDetails?: Purchase;
  /**
   * The quantity of the item on hand
   */
  QuantityOnHand?: number;
  SalesDetails?: Purchase;
  /**
   * Status of object
   */
  StatusAttributeString?: string;
  /**
   * The value of the item on hand. Calculated using average cost accounting.
   */
  TotalCostPool?: number;
  /**
   * Last modified date in UTC format
   */
  readonly UpdatedDateUTC?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
};

export type Items = {
  Items?: Array<Item>;
};

export type Journal = {
  /**
   * Created date UTC format
   */
  readonly CreatedDateUTC?: string;
  /**
   * Date the journal was posted
   */
  JournalDate?: string;
  /**
   * Xero identifier
   */
  JournalID?: string;
  /**
   * See JournalLines
   */
  JournalLines?: Array<JournalLine>;
  /**
   * Xero generated journal number
   */
  JournalNumber?: number;
  /**
   * reference field for additional indetifying information
   */
  Reference?: string;
  /**
   * The identifier for the source transaction (e.g. InvoiceID)
   */
  SourceID?: string;
  /**
   * The journal source type. The type of transaction that created the journal
   */
  SourceType?:
    | 'ACCREC'
    | 'ACCPAY'
    | 'ACCRECCREDIT'
    | 'ACCPAYCREDIT'
    | 'ACCRECPAYMENT'
    | 'ACCPAYPAYMENT'
    | 'ARCREDITPAYMENT'
    | 'APCREDITPAYMENT'
    | 'CASHREC'
    | 'CASHPAID'
    | 'TRANSFER'
    | 'ARPREPAYMENT'
    | 'APPREPAYMENT'
    | 'AROVERPAYMENT'
    | 'APOVERPAYMENT'
    | 'EXPCLAIM'
    | 'EXPPAYMENT'
    | 'MANJOURNAL'
    | 'PAYSLIP'
    | 'WAGEPAYABLE'
    | 'INTEGRATEDPAYROLLPE'
    | 'INTEGRATEDPAYROLLPT'
    | 'EXTERNALSPENDMONEY'
    | 'INTEGRATEDPAYROLLPTPAYMENT'
    | 'INTEGRATEDPAYROLLCN';
};

/**
 * The journal source type. The type of transaction that created the journal
 */
export type SourceType =
  | 'ACCREC'
  | 'ACCPAY'
  | 'ACCRECCREDIT'
  | 'ACCPAYCREDIT'
  | 'ACCRECPAYMENT'
  | 'ACCPAYPAYMENT'
  | 'ARCREDITPAYMENT'
  | 'APCREDITPAYMENT'
  | 'CASHREC'
  | 'CASHPAID'
  | 'TRANSFER'
  | 'ARPREPAYMENT'
  | 'APPREPAYMENT'
  | 'AROVERPAYMENT'
  | 'APOVERPAYMENT'
  | 'EXPCLAIM'
  | 'EXPPAYMENT'
  | 'MANJOURNAL'
  | 'PAYSLIP'
  | 'WAGEPAYABLE'
  | 'INTEGRATEDPAYROLLPE'
  | 'INTEGRATEDPAYROLLPT'
  | 'EXTERNALSPENDMONEY'
  | 'INTEGRATEDPAYROLLPTPAYMENT'
  | 'INTEGRATEDPAYROLLCN';

export type JournalLine = {
  /**
   * See Accounts
   */
  AccountCode?: string;
  /**
   * See Accounts
   */
  AccountID?: string;
  /**
   * See AccountCodes
   */
  AccountName?: string;
  AccountType?: AccountType;
  /**
   * The description from the source transaction line item. Only returned if populated.
   */
  Description?: string;
  /**
   * Gross amount of journal line (NetAmount + TaxAmount).
   */
  GrossAmount?: number;
  /**
   * Xero identifier for Journal
   */
  JournalLineID?: string;
  /**
   * Net amount of journal line. This will be a positive value for a debit and negative for a credit
   */
  NetAmount?: number;
  /**
   * Total tax on a journal line
   */
  readonly TaxAmount?: number;
  /**
   * see TaxRates
   */
  TaxName?: string;
  /**
   * The tax type from TaxRates
   */
  TaxType?: string;
  /**
   * Optional Tracking Category – see Tracking. Any JournalLine can have a maximum of 2 <TrackingCategory> elements.
   */
  TrackingCategories?: Array<TrackingCategory>;
};

export type Journals = {
  Journals?: Array<Journal>;
};

/**
 * Line amounts are exclusive of tax by default if you don’t specify this element. See Line Amount Types
 */
export type LineAmountTypes = 'Exclusive' | 'Inclusive' | 'NoTax';

export type LineItem = {
  /**
   * See Accounts
   */
  AccountCode?: string;
  /**
   * Description needs to be at least 1 char long. A line item with just a description (i.e no unit amount or quantity) can be created by specifying just a <Description> element that contains at least 1 character
   */
  Description?: string;
  /**
   * Discount amount being applied to a line item. Only supported on ACCREC invoices - ACCPAY invoices and credit notes in Xero do not support discounts.
   */
  DiscountAmount?: number;
  /**
   * Percentage discount being applied to a line item (only supported on  ACCREC invoices – ACC PAY invoices and credit notes in Xero do not support discounts
   */
  DiscountRate?: number;
  /**
   * See Items
   */
  ItemCode?: string;
  /**
   * If you wish to omit either of the <Quantity> or <UnitAmount> you can provide a LineAmount and Xero will calculate the missing amount for you. The line amount reflects the discounted price if a DiscountRate has been used . i.e LineAmount = Quantity * Unit Amount * ((100 – DiscountRate)/100)
   */
  LineAmount?: number;
  /**
   * LineItem unique ID
   */
  LineItemID?: string;
  /**
   * LineItem Quantity
   */
  Quantity?: number;
  /**
   * The Xero identifier for a Repeating Invoice
   */
  RepeatingInvoiceID?: string;
  /**
   * The tax amount is auto calculated as a percentage of the line amount (see below) based on the tax rate. This value can be overriden if the calculated <TaxAmount> is not correct.
   */
  TaxAmount?: number;
  /**
   * The tax type from TaxRates
   */
  TaxType?: string;
  /**
   * Optional Tracking Category – see Tracking.  Any LineItem can have a  maximum of 2 <TrackingCategory> elements.
   */
  Tracking?: Array<LineItemTracking>;
  /**
   * LineItem Unit Amount
   */
  UnitAmount?: number;
};

export type LineItemTracking = {
  /**
   * The name of the tracking category
   */
  Name?: string;
  /**
   * See Tracking Options
   */
  Option?: string;
  /**
   * The Xero identifier for a tracking category
   */
  TrackingCategoryID?: string;
  /**
   * The Xero identifier for a tracking category option
   */
  TrackingOptionID?: string;
};

export type LinkedTransaction = {
  /**
   * Filter by the combination of ContactID and Status. Get all the linked transactions that have been assigned to a particular customer and have a particular status e.g. GET /LinkedTransactions?ContactID=4bb34b03-3378-4bb2-a0ed-6345abf3224e&Status=APPROVED.
   */
  ContactID?: string;
  /**
   * The Xero identifier for an Linked Transaction e.g./LinkedTransactions/297c2dc5-cc47-4afd-8ec8-74990b8761e9
   */
  LinkedTransactionID?: string;
  /**
   * The line item identifier from the source transaction.
   */
  SourceLineItemID?: string;
  /**
   * Filter by the SourceTransactionID. Get all the linked transactions created from a particular ACCPAY invoice
   */
  SourceTransactionID?: string;
  /**
   * The Type of the source tranasction. This will be ACCPAY if the linked transaction was created from an invoice and SPEND if it was created from a bank transaction.
   */
  SourceTransactionTypeCode?: 'ACCPAY' | 'SPEND';
  /**
   * Filter by the combination of ContactID and Status. Get all the linked transactions that have been assigned to a particular customer and have a particular status e.g. GET /LinkedTransactions?ContactID=4bb34b03-3378-4bb2-a0ed-6345abf3224e&Status=APPROVED.
   */
  Status?: 'APPROVED' | 'DRAFT' | 'ONDRAFT' | 'BILLED' | 'VOIDED';
  /**
   * The line item identifier from the target transaction. It is possible  to link multiple billable expenses to the same TargetLineItemID.
   */
  TargetLineItemID?: string;
  /**
   * Filter by the TargetTransactionID. Get all the linked transactions  allocated to a particular ACCREC invoice
   */
  TargetTransactionID?: string;
  /**
   * This will always be BILLABLEEXPENSE. More types may be added in future.
   */
  Type?: 'BILLABLEEXPENSE';
  /**
   * The last modified date in UTC format
   */
  readonly UpdatedDateUTC?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
};

/**
 * The Type of the source tranasction. This will be ACCPAY if the linked transaction was created from an invoice and SPEND if it was created from a bank transaction.
 */
export type SourceTransactionTypeCode = 'ACCPAY' | 'SPEND';

/**
 * Filter by the combination of ContactID and Status. Get all the linked transactions that have been assigned to a particular customer and have a particular status e.g. GET /LinkedTransactions?ContactID=4bb34b03-3378-4bb2-a0ed-6345abf3224e&Status=APPROVED.
 */
export type Status9 = 'APPROVED' | 'DRAFT' | 'ONDRAFT' | 'BILLED' | 'VOIDED';

/**
 * This will always be BILLABLEEXPENSE. More types may be added in future.
 */
export type Type6 = 'BILLABLEEXPENSE';

export type LinkedTransactions = {
  LinkedTransactions?: Array<LinkedTransaction>;
};

export type ManualJournal = {
  /**
   * Displays array of attachments from the API
   */
  Attachments?: Array<Attachment>;
  /**
   * Date journal was posted – YYYY-MM-DD
   */
  Date?: string;
  /**
   * Boolean to indicate if a manual journal has an attachment
   */
  readonly HasAttachments?: boolean;
  /**
   * See JournalLines
   */
  JournalLines?: Array<ManualJournalLine>;
  LineAmountTypes?: LineAmountTypes;
  /**
   * The Xero identifier for a Manual Journal
   */
  ManualJournalID?: string;
  /**
   * Description of journal being posted
   */
  Narration: string;
  /**
   * Boolean – default is true if not specified
   */
  ShowOnCashBasisReports?: boolean;
  /**
   * See Manual Journal Status Codes
   */
  Status?: 'DRAFT' | 'POSTED' | 'DELETED' | 'VOIDED' | 'ARCHIVED';
  /**
   * A string to indicate if a invoice status
   */
  StatusAttributeString?: string;
  /**
   * Last modified date UTC format
   */
  readonly UpdatedDateUTC?: string;
  /**
   * Url link to a source document – shown as “Go to [appName]” in the Xero app
   */
  Url?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
  /**
   * Displays array of warning messages from the API
   */
  Warnings?: Array<ValidationError>;
};

/**
 * See Manual Journal Status Codes
 */
export type Status10 = 'DRAFT' | 'POSTED' | 'DELETED' | 'VOIDED' | 'ARCHIVED';

export type ManualJournalLine = {
  /**
   * See Accounts
   */
  AccountCode?: string;
  /**
   * See Accounts
   */
  AccountID?: string;
  /**
   * Description for journal line
   */
  Description?: string;
  /**
   * is the line blank
   */
  IsBlank?: boolean;
  /**
   * total for line. Debits are positive, credits are negative value
   */
  LineAmount?: number;
  /**
   * The calculated tax amount based on the TaxType and LineAmount
   */
  readonly TaxAmount?: number;
  /**
   * The tax type from TaxRates
   */
  TaxType?: string;
  /**
   * Optional Tracking Category – see Tracking. Any JournalLine can have a maximum of 2 <TrackingCategory> elements.
   */
  Tracking?: Array<TrackingCategory>;
};

export type ManualJournals = {
  ManualJournals?: Array<ManualJournal>;
};

export type OnlineInvoice = {
  /**
   * the URL to an online invoice
   */
  OnlineInvoiceUrl?: string;
};

export type OnlineInvoices = {
  OnlineInvoices?: Array<OnlineInvoice>;
};

export type Organisation = {
  /**
   * Display a unique key used for Xero-to-Xero transactions
   */
  APIKey?: string;
  /**
   * Address details for organisation – see Addresses
   */
  Addresses?: Array<AddressForOrganisation>;
  BaseCurrency?: CurrencyCode;
  /**
   * Organisation Classes describe which plan the Xero organisation is on (e.g. DEMO, TRIAL, PREMIUM)
   */
  Class?:
    | 'DEMO'
    | 'TRIAL'
    | 'STARTER'
    | 'STANDARD'
    | 'PREMIUM'
    | 'PREMIUM_20'
    | 'PREMIUM_50'
    | 'PREMIUM_100'
    | 'LEDGER'
    | 'GST_CASHBOOK'
    | 'NON_GST_CASHBOOK';
  CountryCode?: CountryCode;
  /**
   * Timestamp when the organisation was created in Xero
   */
  readonly CreatedDateUTC?: string;
  /**
   * The default for LineAmountTypes on purchase transactions
   */
  DefaultPurchasesTax?: string;
  /**
   * The default for LineAmountTypes on sales transactions
   */
  DefaultSalesTax?: string;
  /**
   * BUSINESS or PARTNER. Partner edition organisations are sold exclusively through accounting partners and have restricted functionality (e.g. no access to invoicing)
   */
  Edition?: 'BUSINESS' | 'PARTNER';
  /**
   * Shown if set. US Only.
   */
  EmployerIdentificationNumber?: string;
  /**
   * Shown if set. See lock dates
   */
  EndOfYearLockDate?: string;
  /**
   * Organisation profile links for popular services such as Facebook,Twitter, GooglePlus and LinkedIn. You can also add link to your website here. Shown if Organisation settings  is updated in Xero. See ExternalLinks below
   */
  ExternalLinks?: Array<ExternalLink>;
  /**
   * Calendar day e.g. 0-31
   */
  FinancialYearEndDay?: number;
  /**
   * Calendar Month e.g. 1-12
   */
  FinancialYearEndMonth?: number;
  /**
   * Boolean to describe if organisation is a demo company.
   */
  IsDemoCompany?: boolean;
  /**
   * Organisation name shown on Reports
   */
  LegalName?: string;
  /**
   * Description of business type as defined in Organisation settings
   */
  LineOfBusiness?: string;
  /**
   * Display name of organisation shown in Xero
   */
  Name?: string;
  /**
   * Organisation Entity Type
   */
  OrganisationEntityType?:
    | 'ACCOUNTING_PRACTICE'
    | 'COMPANY'
    | 'CHARITY'
    | 'CLUB_OR_SOCIETY'
    | 'LOOK_THROUGH_COMPANY'
    | 'NOT_FOR_PROFIT'
    | 'PARTNERSHIP'
    | 'S_CORPORATION'
    | 'SELF_MANAGED_SUPERANNUATION_FUND'
    | 'SOLE_TRADER'
    | 'SUPERANNUATION_FUND'
    | 'TRUST';
  /**
   * Unique Xero identifier
   */
  OrganisationID?: string;
  /**
   * Will be set to ACTIVE if you can connect to organisation via the Xero API
   */
  OrganisationStatus?: string;
  /**
   * Organisation Type
   */
  OrganisationType?:
    | 'ACCOUNTING_PRACTICE'
    | 'COMPANY'
    | 'CHARITY'
    | 'CLUB_OR_SOCIETY'
    | 'LOOK_THROUGH_COMPANY'
    | 'NOT_FOR_PROFIT'
    | 'PARTNERSHIP'
    | 'S_CORPORATION'
    | 'SELF_MANAGED_SUPERANNUATION_FUND'
    | 'SOLE_TRADER'
    | 'SUPERANNUATION_FUND'
    | 'TRUST';
  PaymentTerms?: PaymentTerm;
  /**
   * Boolean to describe if organisation is registered with a local tax authority i.e. true, false
   */
  PaysTax?: boolean;
  /**
   * Shown if set. See lock dates
   */
  PeriodLockDate?: string;
  /**
   * Phones details for organisation – see Phones
   */
  Phones?: Array<Phone>;
  /**
   * Shows for New Zealand, Australian and UK organisations
   */
  RegistrationNumber?: string;
  /**
   * The accounting basis used for tax returns. See Sales Tax Basis
   */
  SalesTaxBasis?:
    | 'PAYMENTS'
    | 'INVOICE'
    | 'NONE'
    | 'CASH'
    | 'ACCRUAL'
    | 'FLATRATECASH'
    | 'FLATRATEACCRUAL'
    | 'ACCRUALS';
  /**
   * The frequency with which tax returns are processed. See Sales Tax Period
   */
  SalesTaxPeriod?:
    | 'MONTHLY'
    | 'QUARTERLY1'
    | 'QUARTERLY2'
    | 'QUARTERLY3'
    | 'ANNUALLY'
    | 'ONEMONTHS'
    | 'TWOMONTHS'
    | 'SIXMONTHS'
    | '1MONTHLY'
    | '2MONTHLY'
    | '3MONTHLY'
    | '6MONTHLY'
    | 'QUARTERLY'
    | 'YEARLY'
    | 'NONE';
  /**
   * A unique identifier for the organisation. Potential uses.
   */
  ShortCode?: string;
  /**
   * Shown if set. Displays in the Xero UI as Tax File Number (AU), GST Number (NZ), VAT Number (UK) and Tax ID Number (US & Global).
   */
  TaxNumber?: string;
  Timezone?: TimeZone;
  /**
   * See Version Types
   */
  Version?: 'AU' | 'NZ' | 'GLOBAL' | 'UK' | 'US' | 'AUONRAMP' | 'NZONRAMP' | 'GLOBALONRAMP' | 'UKONRAMP' | 'USONRAMP';
};

/**
 * Organisation Classes describe which plan the Xero organisation is on (e.g. DEMO, TRIAL, PREMIUM)
 */
export type Class2 =
  | 'DEMO'
  | 'TRIAL'
  | 'STARTER'
  | 'STANDARD'
  | 'PREMIUM'
  | 'PREMIUM_20'
  | 'PREMIUM_50'
  | 'PREMIUM_100'
  | 'LEDGER'
  | 'GST_CASHBOOK'
  | 'NON_GST_CASHBOOK';

/**
 * BUSINESS or PARTNER. Partner edition organisations are sold exclusively through accounting partners and have restricted functionality (e.g. no access to invoicing)
 */
export type Edition = 'BUSINESS' | 'PARTNER';

/**
 * Organisation Entity Type
 */
export type OrganisationEntityType =
  | 'ACCOUNTING_PRACTICE'
  | 'COMPANY'
  | 'CHARITY'
  | 'CLUB_OR_SOCIETY'
  | 'LOOK_THROUGH_COMPANY'
  | 'NOT_FOR_PROFIT'
  | 'PARTNERSHIP'
  | 'S_CORPORATION'
  | 'SELF_MANAGED_SUPERANNUATION_FUND'
  | 'SOLE_TRADER'
  | 'SUPERANNUATION_FUND'
  | 'TRUST';

/**
 * Organisation Type
 */
export type OrganisationType =
  | 'ACCOUNTING_PRACTICE'
  | 'COMPANY'
  | 'CHARITY'
  | 'CLUB_OR_SOCIETY'
  | 'LOOK_THROUGH_COMPANY'
  | 'NOT_FOR_PROFIT'
  | 'PARTNERSHIP'
  | 'S_CORPORATION'
  | 'SELF_MANAGED_SUPERANNUATION_FUND'
  | 'SOLE_TRADER'
  | 'SUPERANNUATION_FUND'
  | 'TRUST';

/**
 * The accounting basis used for tax returns. See Sales Tax Basis
 */
export type SalesTaxBasis =
  | 'PAYMENTS'
  | 'INVOICE'
  | 'NONE'
  | 'CASH'
  | 'ACCRUAL'
  | 'FLATRATECASH'
  | 'FLATRATEACCRUAL'
  | 'ACCRUALS';

/**
 * The frequency with which tax returns are processed. See Sales Tax Period
 */
export type SalesTaxPeriod =
  | 'MONTHLY'
  | 'QUARTERLY1'
  | 'QUARTERLY2'
  | 'QUARTERLY3'
  | 'ANNUALLY'
  | 'ONEMONTHS'
  | 'TWOMONTHS'
  | 'SIXMONTHS'
  | '1MONTHLY'
  | '2MONTHLY'
  | '3MONTHLY'
  | '6MONTHLY'
  | 'QUARTERLY'
  | 'YEARLY'
  | 'NONE';

/**
 * See Version Types
 */
export type Version =
  | 'AU'
  | 'NZ'
  | 'GLOBAL'
  | 'UK'
  | 'US'
  | 'AUONRAMP'
  | 'NZONRAMP'
  | 'GLOBALONRAMP'
  | 'UKONRAMP'
  | 'USONRAMP';

export type Organisations = {
  Organisations?: Array<Organisation>;
};

export type Overpayment = {
  /**
   * See Allocations
   */
  Allocations?: Array<Allocation>;
  /**
   * The amount of applied to an invoice
   */
  AppliedAmount?: number;
  /**
   * See Attachments
   */
  Attachments?: Array<Attachment>;
  Contact?: Contact;
  CurrencyCode?: CurrencyCode;
  /**
   * The currency rate for a multicurrency overpayment. If no rate is specified, the XE.com day rate is used
   */
  CurrencyRate?: number;
  /**
   * The date the overpayment is created YYYY-MM-DD
   */
  Date?: string;
  /**
   * boolean to indicate if a overpayment has an attachment
   */
  readonly HasAttachments?: boolean;
  LineAmountTypes?: LineAmountTypes;
  /**
   * See Overpayment Line Items
   */
  LineItems?: Array<LineItem>;
  /**
   * Xero generated unique identifier
   */
  OverpaymentID?: string;
  /**
   * See Payments
   */
  Payments?: Array<Payment>;
  /**
   * The remaining credit balance on the overpayment
   */
  RemainingCredit?: number;
  /**
   * See Overpayment Status Codes
   */
  Status?: 'AUTHORISED' | 'PAID' | 'VOIDED';
  /**
   * The subtotal of the overpayment excluding taxes
   */
  SubTotal?: number;
  /**
   * The total of the overpayment (subtotal + total tax)
   */
  Total?: number;
  /**
   * The total tax on the overpayment
   */
  TotalTax?: number;
  /**
   * See Overpayment Types
   */
  Type?: 'RECEIVE-OVERPAYMENT' | 'SPEND-OVERPAYMENT' | 'AROVERPAYMENT';
  /**
   * UTC timestamp of last update to the overpayment
   */
  readonly UpdatedDateUTC?: string;
};

/**
 * See Overpayment Status Codes
 */
export type Status11 = 'AUTHORISED' | 'PAID' | 'VOIDED';

/**
 * See Overpayment Types
 */
export type Type7 = 'RECEIVE-OVERPAYMENT' | 'SPEND-OVERPAYMENT' | 'AROVERPAYMENT';

export type Overpayments = {
  Overpayments?: Array<Overpayment>;
};

export type Payment = {
  Account?: Account;
  /**
   * The amount of the payment. Must be less than or equal to the outstanding amount owing on the invoice e.g. 200.00
   */
  Amount?: number;
  /**
   * The suppliers bank account number the payment is being made to
   */
  BankAccountNumber?: string;
  /**
   * Present if the payment was created as part of a batch.
   */
  BatchPaymentID?: string;
  /**
   * Code of account you are using to make the payment e.g. 001 (note- not all accounts have a code value)
   */
  Code?: string;
  CreditNote?: CreditNote;
  /**
   * Number of invoice or credit note you are applying payment to e.g. INV-4003
   */
  CreditNoteNumber?: string;
  /**
   * Exchange rate when payment is received. Only used for non base currency invoices and credit notes e.g. 0.7500
   */
  CurrencyRate?: number;
  /**
   * Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06
   */
  Date?: string;
  /**
   * The information to appear on the supplier's bank account
   */
  Details?: string;
  /**
   * A boolean to indicate if a contact has an validation errors
   */
  HasAccount?: boolean;
  /**
   * A boolean to indicate if a contact has an validation errors
   */
  HasValidationErrors?: boolean;
  Invoice?: Invoice;
  /**
   * Number of invoice or credit note you are applying payment to e.g.INV-4003
   */
  InvoiceNumber?: string;
  /**
   * An optional parameter for the payment. A boolean indicating whether you would like the payment to be created as reconciled when using PUT, or whether a payment has been reconciled when using GET
   */
  IsReconciled?: boolean;
  Overpayment?: Overpayment;
  /**
   * The suppliers bank account number the payment is being made to
   */
  Particulars?: string;
  /**
   * The Xero identifier for an Payment e.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9
   */
  PaymentID?: string;
  /**
   * See Payment Types.
   */
  readonly PaymentType?:
    | 'ACCRECPAYMENT'
    | 'ACCPAYPAYMENT'
    | 'ARCREDITPAYMENT'
    | 'APCREDITPAYMENT'
    | 'AROVERPAYMENTPAYMENT'
    | 'ARPREPAYMENTPAYMENT'
    | 'APPREPAYMENTPAYMENT'
    | 'APOVERPAYMENTPAYMENT';
  Prepayment?: Prepayment;
  /**
   * An optional description for the payment e.g. Direct Debit
   */
  Reference?: string;
  /**
   * The status of the payment.
   */
  Status?: 'AUTHORISED' | 'DELETED';
  /**
   * A string to indicate if a invoice status
   */
  StatusAttributeString?: string;
  /**
   * UTC timestamp of last update to the payment
   */
  readonly UpdatedDateUTC?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
};

/**
 * See Payment Types.
 */
export type PaymentType =
  | 'ACCRECPAYMENT'
  | 'ACCPAYPAYMENT'
  | 'ARCREDITPAYMENT'
  | 'APCREDITPAYMENT'
  | 'AROVERPAYMENTPAYMENT'
  | 'ARPREPAYMENTPAYMENT'
  | 'APPREPAYMENTPAYMENT'
  | 'APOVERPAYMENTPAYMENT';

export type PaymentDelete = {
  /**
   * The status of the payment.
   */
  Status: string;
};

export type PaymentService = {
  /**
   * The text displayed on the Pay Now button in Xero Online Invoicing. If this is not set it will default to Pay by credit card
   */
  PayNowText?: string;
  /**
   * Xero identifier
   */
  PaymentServiceID?: string;
  /**
   * Name of payment service
   */
  PaymentServiceName?: string;
  /**
   * This will always be CUSTOM for payment services created via the API.
   */
  PaymentServiceType?: string;
  /**
   * The custom payment URL
   */
  PaymentServiceUrl?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
};

export type PaymentServices = {
  PaymentServices?: Array<PaymentService>;
};

export type PaymentTerm = {
  Bills?: Bill;
  Sales?: Bill;
};

export type PaymentTermType = 'DAYSAFTERBILLDATE' | 'DAYSAFTERBILLMONTH' | 'OFCURRENTMONTH' | 'OFFOLLOWINGMONTH';

export type Payments = {
  Payments?: Array<Payment>;
};

export type Phone = {
  /**
   * max length = 10
   */
  PhoneAreaCode?: string;
  /**
   * max length = 20
   */
  PhoneCountryCode?: string;
  /**
   * max length = 50
   */
  PhoneNumber?: string;
  PhoneType?: 'DEFAULT' | 'DDI' | 'MOBILE' | 'FAX' | 'OFFICE';
};

export type PhoneType = 'DEFAULT' | 'DDI' | 'MOBILE' | 'FAX' | 'OFFICE';

export type Prepayment = {
  /**
   * See Allocations
   */
  Allocations?: Array<Allocation>;
  /**
   * The amount of applied to an invoice
   */
  AppliedAmount?: number;
  /**
   * See Attachments
   */
  Attachments?: Array<Attachment>;
  Contact?: Contact;
  CurrencyCode?: CurrencyCode;
  /**
   * The currency rate for a multicurrency prepayment. If no rate is specified, the XE.com day rate is used
   */
  CurrencyRate?: number;
  /**
   * The date the prepayment is created YYYY-MM-DD
   */
  Date?: string;
  /**
   * boolean to indicate if a prepayment has an attachment
   */
  readonly HasAttachments?: boolean;
  LineAmountTypes?: LineAmountTypes;
  /**
   * See Prepayment Line Items
   */
  LineItems?: Array<LineItem>;
  /**
   * Xero generated unique identifier
   */
  PrepaymentID?: string;
  /**
   * Returns Invoice number field. Reference field isn't available.
   */
  readonly Reference?: string;
  /**
   * The remaining credit balance on the prepayment
   */
  RemainingCredit?: number;
  /**
   * See Prepayment Status Codes
   */
  Status?: 'AUTHORISED' | 'PAID' | 'VOIDED';
  /**
   * The subtotal of the prepayment excluding taxes
   */
  SubTotal?: number;
  /**
   * The total of the prepayment(subtotal + total tax)
   */
  Total?: number;
  /**
   * The total tax on the prepayment
   */
  TotalTax?: number;
  /**
   * See Prepayment Types
   */
  Type?: 'RECEIVE-PREPAYMENT' | 'SPEND-PREPAYMENT' | 'ARPREPAYMENT' | 'APPREPAYMENT';
  /**
   * UTC timestamp of last update to the prepayment
   */
  readonly UpdatedDateUTC?: string;
};

/**
 * See Prepayment Types
 */
export type Type8 = 'RECEIVE-PREPAYMENT' | 'SPEND-PREPAYMENT' | 'ARPREPAYMENT' | 'APPREPAYMENT';

export type Prepayments = {
  Prepayments?: Array<Prepayment>;
};

export type Purchase = {
  /**
   * Default account code to be used for purchased/sale. Not applicable to the purchase details of tracked items
   */
  AccountCode?: string;
  /**
   * Cost of goods sold account. Only applicable to the purchase details of tracked items.
   */
  COGSAccountCode?: string;
  /**
   * The tax type from TaxRates
   */
  TaxType?: string;
  /**
   * Unit Price of the item. By default UnitPrice is rounded to two decimal places. You can use 4 decimal places by adding the unitdp=4 querystring parameter to your request.
   */
  UnitPrice?: number;
};

export type PurchaseOrder = {
  /**
   * Displays array of attachments from the API
   */
  Attachments?: Array<Attachment>;
  /**
   * The person that the delivery is going to
   */
  AttentionTo?: string;
  /**
   * See BrandingThemes
   */
  BrandingThemeID?: string;
  Contact?: Contact;
  CurrencyCode?: CurrencyCode;
  /**
   * The currency rate for a multicurrency purchase order. If no rate is specified, the XE.com day rate is used.
   */
  CurrencyRate?: number;
  /**
   * Date purchase order was issued – YYYY-MM-DD. If the Date element is not specified then it will default to the current date based on the timezone setting of the organisation
   */
  Date?: string;
  /**
   * The address the goods are to be delivered to
   */
  DeliveryAddress?: string;
  /**
   * Date the goods are to be delivered – YYYY-MM-DD
   */
  DeliveryDate?: string;
  /**
   * A free text feild for instructions (500 characters max)
   */
  DeliveryInstructions?: string;
  /**
   * The date the goods are expected to arrive.
   */
  ExpectedArrivalDate?: string;
  /**
   * boolean to indicate if a purchase order has an attachment
   */
  readonly HasAttachments?: boolean;
  LineAmountTypes?: LineAmountTypes;
  /**
   * See LineItems
   */
  LineItems?: Array<LineItem>;
  /**
   * Xero generated unique identifier for purchase order
   */
  PurchaseOrderID?: string;
  /**
   * Unique alpha numeric code identifying purchase order (when missing will auto-generate from your Organisation Invoice Settings)
   */
  PurchaseOrderNumber?: string;
  /**
   * Additional reference number
   */
  Reference?: string;
  /**
   * Boolean to set whether the purchase order should be marked as “sent”. This can be set only on purchase orders that have been approved or billed
   */
  SentToContact?: boolean;
  /**
   * See Purchase Order Status Codes
   */
  Status?: 'DRAFT' | 'SUBMITTED' | 'AUTHORISED' | 'BILLED' | 'DELETED';
  /**
   * A string to indicate if a invoice status
   */
  StatusAttributeString?: string;
  /**
   * Total of purchase order excluding taxes
   */
  readonly SubTotal?: number;
  /**
   * The phone number for the person accepting the delivery
   */
  Telephone?: string;
  /**
   * Total of Purchase Order tax inclusive (i.e. SubTotal + TotalTax)
   */
  readonly Total?: number;
  /**
   * Total of discounts applied on the purchase order line items
   */
  readonly TotalDiscount?: number;
  /**
   * Total tax on purchase order
   */
  readonly TotalTax?: number;
  /**
   * Last modified date UTC format
   */
  readonly UpdatedDateUTC?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
  /**
   * Displays array of warning messages from the API
   */
  Warnings?: Array<ValidationError>;
};

/**
 * See Purchase Order Status Codes
 */
export type Status12 = 'DRAFT' | 'SUBMITTED' | 'AUTHORISED' | 'BILLED' | 'DELETED';

export type PurchaseOrders = {
  PurchaseOrders?: Array<PurchaseOrder>;
};

export type Quote = {
  /**
   * See BrandingThemes
   */
  BrandingThemeID?: string;
  Contact?: Contact;
  CurrencyCode?: CurrencyCode;
  /**
   * The currency rate for a multicurrency quote
   */
  CurrencyRate?: number;
  /**
   * Date quote was issued – YYYY-MM-DD. If the Date element is not specified it will default to the current date based on the timezone setting of the organisation
   */
  Date?: string;
  /**
   * Date the quote was issued (YYYY-MM-DD)
   */
  DateString?: string;
  /**
   * Date the quote expires – YYYY-MM-DD.
   */
  ExpiryDate?: string;
  /**
   * Date the quote expires – YYYY-MM-DD.
   */
  ExpiryDateString?: string;
  /**
   * See Quote Line Amount Types
   */
  LineAmountTypes?: QuoteLineAmountTypes;
  /**
   * See LineItems
   */
  LineItems?: Array<LineItem>;
  /**
   * QuoteID GUID is automatically generated and is returned after create or GET.
   */
  QuoteID?: string;
  /**
   * Unique alpha numeric code identifying a quote (Max Length = 255)
   */
  QuoteNumber?: string;
  /**
   * Additional reference number
   */
  Reference?: string;
  Status?: QuoteStatusCodes;
  /**
   * A string to indicate if a invoice status
   */
  StatusAttributeString?: string;
  /**
   * Total of quote excluding taxes.
   */
  readonly SubTotal?: number;
  /**
   * Summary text for the quote
   */
  Summary?: string;
  /**
   * Terms of the quote
   */
  Terms?: string;
  /**
   * Title text for the quote
   */
  Title?: string;
  /**
   * Total of Quote tax inclusive (i.e. SubTotal + TotalTax). This will be ignored if it doesn’t equal the sum of the LineAmounts
   */
  readonly Total?: number;
  /**
   * Total of discounts applied on the quote line items
   */
  readonly TotalDiscount?: number;
  /**
   * Total tax on quote
   */
  readonly TotalTax?: number;
  /**
   * Last modified date UTC format
   */
  readonly UpdatedDateUTC?: string;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
};

/**
 * Line amounts are exclusive of tax by default if you don’t specify this element. See Line Amount Types
 */
export type QuoteLineAmountTypes = 'EXCLUSIVE' | 'INCLUSIVE' | 'NOTAX';

/**
 * The status of the quote.
 */
export type QuoteStatusCodes = 'DRAFT' | 'SENT' | 'DECLINED' | 'ACCEPTED' | 'INVOICED' | 'DELETED';

export type Quotes = {
  Quotes?: Array<Quote>;
};

export type Receipt = {
  /**
   * Displays array of attachments from the API
   */
  Attachments?: Array<Attachment>;
  Contact?: Contact;
  /**
   * Date of receipt – YYYY-MM-DD
   */
  Date?: string;
  /**
   * boolean to indicate if a receipt has an attachment
   */
  readonly HasAttachments?: boolean;
  LineAmountTypes?: LineAmountTypes;
  LineItems?: Array<LineItem>;
  /**
   * Xero generated unique identifier for receipt
   */
  ReceiptID?: string;
  /**
   * Xero generated sequence number for receipt in current claim for a given user
   */
  readonly ReceiptNumber?: string;
  /**
   * Additional reference number
   */
  Reference?: string;
  /**
   * Current status of receipt – see status types
   */
  Status?: 'DRAFT' | 'SUBMITTED' | 'AUTHORISED' | 'DECLINED' | 'VOIDED';
  /**
   * Total of receipt excluding taxes
   */
  SubTotal?: number;
  /**
   * Total of receipt tax inclusive (i.e. SubTotal + TotalTax)
   */
  Total?: number;
  /**
   * Total tax on receipt
   */
  TotalTax?: number;
  /**
   * Last modified date UTC format
   */
  readonly UpdatedDateUTC?: string;
  /**
   * URL link to a source document – shown as “Go to [appName]” in the Xero app
   */
  readonly Url?: string;
  User?: User;
  /**
   * Displays array of validation error messages from the API
   */
  ValidationErrors?: Array<ValidationError>;
  /**
   * Displays array of warning messages from the API
   */
  Warnings?: Array<ValidationError>;
};

/**
 * Current status of receipt – see status types
 */
export type Status13 = 'DRAFT' | 'SUBMITTED' | 'AUTHORISED' | 'DECLINED' | 'VOIDED';

export type Receipts = {
  Receipts?: Array<Receipt>;
};

export type RepeatingInvoice = {
  /**
   * Displays array of attachments from the API
   */
  Attachments?: Array<Attachment>;
  /**
   * See BrandingThemes
   */
  BrandingThemeID?: string;
  Contact?: Contact;
  CurrencyCode?: CurrencyCode;
  /**
   * boolean to indicate if an invoice has an attachment
   */
  readonly HasAttachments?: boolean;
  /**
   * Xero generated unique identifier for repeating invoice template
   */
  ID?: string;
  LineAmountTypes?: LineAmountTypes;
  /**
   * See LineItems
   */
  LineItems?: Array<LineItem>;
  /**
   * ACCREC only – additional reference number
   */
  Reference?: string;
  /**
   * Xero generated unique identifier for repeating invoice template
   */
  RepeatingInvoiceID?: string;
  Schedule?: Schedule;
  /**
   * One of the following - DRAFT or AUTHORISED – See Invoice Status Codes
   */
  Status?: 'DRAFT' | 'AUTHORISED' | 'DELETED';
  /**
   * Total of invoice excluding taxes
   */
  SubTotal?: number;
  /**
   * Total of Invoice tax inclusive (i.e. SubTotal + TotalTax)
   */
  Total?: number;
  /**
   * Total tax on invoice
   */
  TotalTax?: number;
  /**
   * See Invoice Types
   */
  Type?: 'ACCPAY' | 'ACCREC';
};

/**
 * One of the following - DRAFT or AUTHORISED – See Invoice Status Codes
 */
export type Status14 = 'DRAFT' | 'AUTHORISED' | 'DELETED';

/**
 * See Invoice Types
 */
export type Type9 = 'ACCPAY' | 'ACCREC';

export type RepeatingInvoices = {
  RepeatingInvoices?: Array<RepeatingInvoice>;
};

export type Report = {
  Contacts?: Array<TenNinetyNineContact>;
  /**
   * Date of report
   */
  ReportDate?: string;
  /**
   * See Prepayment Types
   */
  ReportID?: string;
  /**
   * See Prepayment Types
   */
  ReportName?: string;
  /**
   * See Prepayment Types
   */
  ReportTitle?: string;
  /**
   * See Prepayment Types
   */
  ReportType?: 'AgedPayablesByContact';
  /**
   * Updated Date
   */
  readonly UpdatedDateUTC?: string;
};

/**
 * See Prepayment Types
 */
export type ReportType = 'AgedPayablesByContact';

export type ReportAttribute = {
  Id?: string;
  Value?: string;
};

export type ReportCell = {
  Attributes?: Array<ReportAttribute>;
  Value?: string;
};

export type ReportFields = {
  Description?: string;
  FieldID?: string;
  Value?: string;
};

export type ReportRow = {
  Cells?: Array<ReportCell>;
  RowType?: RowType;
  Title?: string;
};

export type ReportRows = {
  Cells?: Array<ReportCell>;
  RowType?: RowType;
  Rows?: Array<ReportRow>;
  Title?: string;
};

export type ReportWithRow = {
  Fields?: Array<ReportFields>;
  /**
   * Date of report
   */
  ReportDate?: string;
  /**
   * Report id
   */
  ReportID?: string;
  /**
   * Name of the report
   */
  ReportName?: string;
  /**
   * Title of the report
   */
  ReportTitle?: string;
  /**
   * Report titles array (3 to 4 strings with the report name, orgnisation name and time frame of report)
   */
  ReportTitles?: Array<string>;
  /**
   * The type of report (BalanceSheet,ProfitLoss, etc)
   */
  ReportType?: string;
  Rows?: Array<ReportRows>;
  /**
   * Updated Date
   */
  readonly UpdatedDateUTC?: string;
};

export type ReportWithRows = {
  Reports?: Array<ReportWithRow>;
};

export type Reports = {
  Reports?: Array<Report>;
};

export type RequestEmpty = {
  /**
   * Need at least one field to create an empty JSON payload
   */
  Status?: string;
};

export type RowType = 'Header' | 'Section' | 'Row' | 'SummaryRow';

export type SalesTrackingCategory = {
  /**
   * The default sales tracking category name for contacts
   */
  TrackingCategoryName?: string;
  /**
   * The default purchase tracking category name for contacts
   */
  TrackingOptionName?: string;
};

export type Schedule = {
  /**
   * Integer used with due date type e.g 20 (of following month), 31 (of current month)
   */
  DueDate?: number;
  /**
   * the payment terms
   */
  DueDateType?:
    | 'DAYSAFTERBILLDATE'
    | 'DAYSAFTERBILLMONTH'
    | 'DAYSAFTERINVOICEDATE'
    | 'DAYSAFTERINVOICEMONTH'
    | 'OFCURRENTMONTH'
    | 'OFFOLLOWINGMONTH';
  /**
   * Invoice end date – only returned if the template has an end date set
   */
  EndDate?: string;
  /**
   * The calendar date of the next invoice in the schedule to be generated
   */
  NextScheduledDate?: string;
  /**
   * Integer used with the unit e.g. 1 (every 1 week), 2 (every 2 months)
   */
  Period?: number;
  /**
   * Date the first invoice of the current version of the repeating schedule was generated (changes when repeating invoice is edited)
   */
  StartDate?: string;
  /**
   * One of the following - WEEKLY or MONTHLY
   */
  Unit?: 'WEEKLY' | 'MONTHLY';
};

/**
 * the payment terms
 */
export type DueDateType =
  | 'DAYSAFTERBILLDATE'
  | 'DAYSAFTERBILLMONTH'
  | 'DAYSAFTERINVOICEDATE'
  | 'DAYSAFTERINVOICEMONTH'
  | 'OFCURRENTMONTH'
  | 'OFFOLLOWINGMONTH';

/**
 * One of the following - WEEKLY or MONTHLY
 */
export type Unit = 'WEEKLY' | 'MONTHLY';

export type Setup = {
  Accounts?: Array<Account>;
  /**
   * Balance supplied for each account that has a value as at the conversion date.
   */
  ConversionBalances?: Array<ConversionBalances>;
  ConversionDate?: ConversionDate;
};

export type TaxComponent = {
  /**
   * Boolean to describe if Tax rate is compounded.
   */
  IsCompound?: boolean;
  /**
   * Boolean to describe if tax rate is non-recoverable. Non-recoverable rates are only applicable to Canadian organisations
   */
  IsNonRecoverable?: boolean;
  /**
   * Name of Tax Component
   */
  Name?: string;
  /**
   * Tax Rate (up to 4dp)
   */
  Rate?: number;
};

export type TaxRate = {
  /**
   * Boolean to describe if tax rate can be used for asset accounts i.e.  true,false
   */
  readonly CanApplyToAssets?: boolean;
  /**
   * Boolean to describe if tax rate can be used for equity accounts i.e true,false
   */
  readonly CanApplyToEquity?: boolean;
  /**
   * Boolean to describe if tax rate can be used for expense accounts  i.e. true,false
   */
  readonly CanApplyToExpenses?: boolean;
  /**
   * Boolean to describe if tax rate can be used for liability accounts  i.e. true,false
   */
  readonly CanApplyToLiabilities?: boolean;
  /**
   * Boolean to describe if tax rate can be used for revenue accounts i.e. true,false
   */
  readonly CanApplyToRevenue?: boolean;
  /**
   * Tax Rate (decimal to 4dp) e.g 12.5000
   */
  readonly DisplayTaxRate?: number;
  /**
   * Effective Tax Rate (decimal to 4dp) e.g 12.5000
   */
  readonly EffectiveRate?: number;
  /**
   * Name of tax rate
   */
  Name?: string;
  /**
   * See ReportTaxTypes
   */
  ReportTaxType?:
    | 'AVALARA'
    | 'BASEXCLUDED'
    | 'CAPITALSALESOUTPUT'
    | 'CAPITALEXPENSESINPUT'
    | 'ECOUTPUT'
    | 'ECOUTPUTSERVICES'
    | 'ECINPUT'
    | 'ECACQUISITIONS'
    | 'EXEMPTEXPENSES'
    | 'EXEMPTINPUT'
    | 'EXEMPTOUTPUT'
    | 'GSTONIMPORTS'
    | 'INPUT'
    | 'INPUTTAXED'
    | 'MOSSSALES'
    | 'NONE'
    | 'NONEOUTPUT'
    | 'OUTPUT'
    | 'PURCHASESINPUT'
    | 'SALESOUTPUT'
    | 'EXEMPTCAPITAL'
    | 'EXEMPTEXPORT'
    | 'CAPITALEXINPUT'
    | 'GSTONCAPIMPORTS'
    | 'GSTONCAPITALIMPORTS'
    | 'REVERSECHARGES'
    | 'PAYMENTS'
    | 'INVOICE'
    | 'CASH'
    | 'ACCRUAL'
    | 'FLATRATECASH'
    | 'FLATRATEACCRUAL'
    | 'ACCRUALS'
    | 'TXCA'
    | 'SRCAS'
    | 'DSOUTPUT'
    | 'BLINPUT2'
    | 'EPINPUT'
    | 'IMINPUT2'
    | 'MEINPUT'
    | 'IGDSINPUT2'
    | 'ESN33OUTPUT'
    | 'OPINPUT'
    | 'OSOUTPUT'
    | 'TXN33INPUT'
    | 'TXESSINPUT'
    | 'TXREINPUT'
    | 'TXPETINPUT'
    | 'NRINPUT'
    | 'ES33OUTPUT'
    | 'ZERORATEDINPUT'
    | 'ZERORATEDOUTPUT'
    | 'DRCHARGESUPPLY'
    | 'DRCHARGE'
    | 'CAPINPUT'
    | 'CAPIMPORTS'
    | 'IMINPUT'
    | 'INPUT2'
    | 'CIUINPUT'
    | 'SRINPUT'
    | 'OUTPUT2'
    | 'SROUTPUT'
    | 'CAPOUTPUT'
    | 'SROUTPUT2'
    | 'CIUOUTPUT'
    | 'ZROUTPUT'
    | 'ZREXPORT'
    | 'ACC28PLUS'
    | 'ACCUPTO28'
    | 'OTHEROUTPUT'
    | 'SHOUTPUT'
    | 'ZRINPUT'
    | 'BADDEBT'
    | 'OTHERINPUT';
  /**
   * See Status Codes
   */
  Status?: 'ACTIVE' | 'DELETED' | 'ARCHIVED' | 'PENDING';
  /**
   * See TaxComponents
   */
  TaxComponents?: Array<TaxComponent>;
  /**
   * The tax type
   */
  TaxType?: string;
};

/**
 * See ReportTaxTypes
 */
export type ReportTaxType =
  | 'AVALARA'
  | 'BASEXCLUDED'
  | 'CAPITALSALESOUTPUT'
  | 'CAPITALEXPENSESINPUT'
  | 'ECOUTPUT'
  | 'ECOUTPUTSERVICES'
  | 'ECINPUT'
  | 'ECACQUISITIONS'
  | 'EXEMPTEXPENSES'
  | 'EXEMPTINPUT'
  | 'EXEMPTOUTPUT'
  | 'GSTONIMPORTS'
  | 'INPUT'
  | 'INPUTTAXED'
  | 'MOSSSALES'
  | 'NONE'
  | 'NONEOUTPUT'
  | 'OUTPUT'
  | 'PURCHASESINPUT'
  | 'SALESOUTPUT'
  | 'EXEMPTCAPITAL'
  | 'EXEMPTEXPORT'
  | 'CAPITALEXINPUT'
  | 'GSTONCAPIMPORTS'
  | 'GSTONCAPITALIMPORTS'
  | 'REVERSECHARGES'
  | 'PAYMENTS'
  | 'INVOICE'
  | 'CASH'
  | 'ACCRUAL'
  | 'FLATRATECASH'
  | 'FLATRATEACCRUAL'
  | 'ACCRUALS'
  | 'TXCA'
  | 'SRCAS'
  | 'DSOUTPUT'
  | 'BLINPUT2'
  | 'EPINPUT'
  | 'IMINPUT2'
  | 'MEINPUT'
  | 'IGDSINPUT2'
  | 'ESN33OUTPUT'
  | 'OPINPUT'
  | 'OSOUTPUT'
  | 'TXN33INPUT'
  | 'TXESSINPUT'
  | 'TXREINPUT'
  | 'TXPETINPUT'
  | 'NRINPUT'
  | 'ES33OUTPUT'
  | 'ZERORATEDINPUT'
  | 'ZERORATEDOUTPUT'
  | 'DRCHARGESUPPLY'
  | 'DRCHARGE'
  | 'CAPINPUT'
  | 'CAPIMPORTS'
  | 'IMINPUT'
  | 'INPUT2'
  | 'CIUINPUT'
  | 'SRINPUT'
  | 'OUTPUT2'
  | 'SROUTPUT'
  | 'CAPOUTPUT'
  | 'SROUTPUT2'
  | 'CIUOUTPUT'
  | 'ZROUTPUT'
  | 'ZREXPORT'
  | 'ACC28PLUS'
  | 'ACCUPTO28'
  | 'OTHEROUTPUT'
  | 'SHOUTPUT'
  | 'ZRINPUT'
  | 'BADDEBT'
  | 'OTHERINPUT';

/**
 * See Status Codes
 */
export type Status15 = 'ACTIVE' | 'DELETED' | 'ARCHIVED' | 'PENDING';

export type TaxRates = {
  TaxRates?: Array<TaxRate>;
};

/**
 * See Tax Types – can only be used on update calls
 */
export type TaxType =
  | 'OUTPUT'
  | 'INPUT'
  | 'CAPEXINPUT'
  | 'EXEMPTEXPORT'
  | 'EXEMPTEXPENSES'
  | 'EXEMPTCAPITAL'
  | 'EXEMPTOUTPUT'
  | 'INPUTTAXED'
  | 'BASEXCLUDED'
  | 'GSTONCAPIMPORTS'
  | 'GSTONIMPORTS'
  | 'NONE'
  | 'INPUT2'
  | 'ZERORATED'
  | 'OUTPUT2'
  | 'CAPEXINPUT2'
  | 'CAPEXOUTPUT'
  | 'CAPEXOUTPUT2'
  | 'CAPEXSRINPUT'
  | 'CAPEXSROUTPUT'
  | 'ECACQUISITIONS'
  | 'ECZRINPUT'
  | 'ECZROUTPUT'
  | 'ECZROUTPUTSERVICES'
  | 'EXEMPTINPUT'
  | 'REVERSECHARGES'
  | 'RRINPUT'
  | 'RROUTPUT'
  | 'SRINPUT'
  | 'SROUTPUT'
  | 'ZERORATEDINPUT'
  | 'ZERORATEDOUTPUT'
  | 'BLINPUT'
  | 'DSOUTPUT'
  | 'EPINPUT'
  | 'ES33OUTPUT'
  | 'ESN33OUTPUT'
  | 'IGDSINPUT2'
  | 'IMINPUT2'
  | 'MEINPUT'
  | 'NRINPUT'
  | 'OPINPUT'
  | 'OSOUTPUT'
  | 'TXESSINPUT'
  | 'TXN33INPUT'
  | 'TXPETINPUT'
  | 'TXREINPUT'
  | 'INPUT3'
  | 'INPUT4'
  | 'OUTPUT3'
  | 'OUTPUT4'
  | 'SROUTPUT2'
  | 'TXCA'
  | 'SRCAS'
  | 'BLINPUT2'
  | 'DRCHARGESUPPLY20'
  | 'DRCHARGE20'
  | 'DRCHARGESUPPLY5'
  | 'DRCHARGE5';

export type TenNinetyNineContact = {
  /**
   * Box 1 on 1099 Form
   */
  Box1?: number;
  /**
   * Box 10 on 1099 Form
   */
  Box10?: number;
  /**
   * Box 11 on 1099 Form
   */
  Box11?: number;
  /**
   * Box 13 on 1099 Form
   */
  Box13?: number;
  /**
   * Box 14 on 1099 Form
   */
  Box14?: number;
  /**
   * Box 2 on 1099 Form
   */
  Box2?: number;
  /**
   * Box 3 on 1099 Form
   */
  Box3?: number;
  /**
   * Box 4 on 1099 Form
   */
  Box4?: number;
  /**
   * Box 5 on 1099 Form
   */
  Box5?: number;
  /**
   * Box 6 on 1099 Form
   */
  Box6?: number;
  /**
   * Box 7 on 1099 Form
   */
  Box7?: number;
  /**
   * Box 8 on 1099 Form
   */
  Box8?: number;
  /**
   * Box 9 on 1099 Form
   */
  Box9?: number;
  /**
   * Contact city on 1099 Form
   */
  City?: string;
  /**
   * Contact contact id
   */
  ContactId?: string;
  /**
   * Contact email on 1099 Form
   */
  Email?: string;
  /**
   * Contact Fed Tax ID type
   */
  FederalTaxIDType?: string;
  /**
   * Contact name on 1099 Form
   */
  Name?: string;
  /**
   * Contact State on 1099 Form
   */
  State?: string;
  /**
   * Contact address on 1099 Form
   */
  StreetAddress?: string;
  /**
   * Contact tax id on 1099 Form
   */
  TaxID?: string;
  /**
   * Contact zip on 1099 Form
   */
  Zip?: string;
};

/**
 * Timezone specifications
 */
export type TimeZone =
  | 'MOROCCOSTANDARDTIME'
  | 'UTC'
  | 'GMTSTANDARDTIME'
  | 'GREENWICHSTANDARDTIME'
  | 'WEUROPESTANDARDTIME'
  | 'CENTRALEUROPESTANDARDTIME'
  | 'ROMANCESTANDARDTIME'
  | 'CENTRALEUROPEANSTANDARDTIME'
  | 'WCENTRALAFRICASTANDARDTIME'
  | 'NAMIBIASTANDARDTIME'
  | 'JORDANSTANDARDTIME'
  | 'GTBSTANDARDTIME'
  | 'MIDDLEEASTSTANDARDTIME'
  | 'EGYPTSTANDARDTIME'
  | 'SYRIASTANDARDTIME'
  | 'EEUROPESTANDARDTIME'
  | 'SOUTHAFRICASTANDARDTIME'
  | 'FLESTANDARDTIME'
  | 'TURKEYSTANDARDTIME'
  | 'ISRAELSTANDARDTIME'
  | 'KALININGRADSTANDARDTIME'
  | 'LIBYASTANDARDTIME'
  | 'ARABICSTANDARDTIME'
  | 'ARABSTANDARDTIME'
  | 'BELARUSSTANDARDTIME'
  | 'RUSSIANSTANDARDTIME'
  | 'EAFRICASTANDARDTIME'
  | 'IRANSTANDARDTIME'
  | 'ARABIANSTANDARDTIME'
  | 'AZERBAIJANSTANDARDTIME'
  | 'RUSSIATIMEZONE3'
  | 'MAURITIUSSTANDARDTIME'
  | 'GEORGIANSTANDARDTIME'
  | 'CAUCASUSSTANDARDTIME'
  | 'AFGHANISTANSTANDARDTIME'
  | 'WESTASIASTANDARDTIME'
  | 'EKATERINBURGSTANDARDTIME'
  | 'PAKISTANSTANDARDTIME'
  | 'INDIASTANDARDTIME'
  | 'SRILANKASTANDARDTIME'
  | 'NEPALSTANDARDTIME'
  | 'CENTRALASIASTANDARDTIME'
  | 'BANGLADESHSTANDARDTIME'
  | 'NCENTRALASIASTANDARDTIME'
  | 'MYANMARSTANDARDTIME'
  | 'SEASIASTANDARDTIME'
  | 'NORTHASIASTANDARDTIME'
  | 'CHINASTANDARDTIME'
  | 'NORTHASIAEASTSTANDARDTIME'
  | 'SINGAPORESTANDARDTIME'
  | 'WAUSTRALIASTANDARDTIME'
  | 'TAIPEISTANDARDTIME'
  | 'ULAANBAATARSTANDARDTIME'
  | 'TOKYOSTANDARDTIME'
  | 'KOREASTANDARDTIME'
  | 'YAKUTSKSTANDARDTIME'
  | 'CENAUSTRALIASTANDARDTIME'
  | 'AUSCENTRALSTANDARDTIME'
  | 'EAUSTRALIASTANDARDTIME'
  | 'AUSEASTERNSTANDARDTIME'
  | 'WESTPACIFICSTANDARDTIME'
  | 'TASMANIASTANDARDTIME'
  | 'MAGADANSTANDARDTIME'
  | 'VLADIVOSTOKSTANDARDTIME'
  | 'RUSSIATIMEZONE10'
  | 'CENTRALPACIFICSTANDARDTIME'
  | 'RUSSIATIMEZONE11'
  | 'NEWZEALANDSTANDARDTIME'
  | 'UTC+12'
  | 'UTC+13'
  | 'FIJISTANDARDTIME'
  | 'KAMCHATKASTANDARDTIME'
  | 'TONGASTANDARDTIME'
  | 'SAMOASTANDARDTIME'
  | 'LINEISLANDSSTANDARDTIME'
  | 'AZORESSTANDARDTIME'
  | 'CAPEVERDESTANDARDTIME'
  | 'UTC02'
  | 'MIDATLANTICSTANDARDTIME'
  | 'ESOUTHAMERICASTANDARDTIME'
  | 'ARGENTINASTANDARDTIME'
  | 'SAEASTERNSTANDARDTIME'
  | 'GREENLANDSTANDARDTIME'
  | 'MONTEVIDEOSTANDARDTIME'
  | 'BAHIASTANDARDTIME'
  | 'NEWFOUNDLANDSTANDARDTIME'
  | 'PARAGUAYSTANDARDTIME'
  | 'ATLANTICSTANDARDTIME'
  | 'CENTRALBRAZILIANSTANDARDTIME'
  | 'SAWESTERNSTANDARDTIME'
  | 'PACIFICSASTANDARDTIME'
  | 'VENEZUELASTANDARDTIME'
  | 'SAPACIFICSTANDARDTIME'
  | 'EASTERNSTANDARDTIME'
  | 'USEASTERNSTANDARDTIME'
  | 'CENTRALAMERICASTANDARDTIME'
  | 'CENTRALSTANDARDTIME'
  | 'CENTRALSTANDARDTIME(MEXICO)'
  | 'CANADACENTRALSTANDARDTIME'
  | 'USMOUNTAINSTANDARDTIME'
  | 'MOUNTAINSTANDARDTIME(MEXICO)'
  | 'MOUNTAINSTANDARDTIME'
  | 'PACIFICSTANDARDTIME(MEXICO)'
  | 'PACIFICSTANDARDTIME'
  | 'ALASKANSTANDARDTIME'
  | 'HAWAIIANSTANDARDTIME'
  | 'UTC11'
  | 'DATELINESTANDARDTIME';

export type TrackingCategories = {
  TrackingCategories?: Array<TrackingCategory>;
};

export type TrackingCategory = {
  /**
   * The name of the tracking category e.g. Department, Region (max length = 100)
   */
  Name?: string;
  /**
   * The option name of the tracking option e.g. East, West (max length = 100)
   */
  Option?: string;
  /**
   * See Tracking Options
   */
  Options?: Array<TrackingOption>;
  /**
   * The status of a tracking category
   */
  Status?: 'ACTIVE' | 'ARCHIVED' | 'DELETED';
  /**
   * The Xero identifier for a tracking category e.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9
   */
  TrackingCategoryID?: string;
  /**
   * The Xero identifier for a tracking option e.g. dc54c220-0140-495a-b925-3246adc0075f
   */
  TrackingOptionID?: string;
};

export type TrackingOption = {
  /**
   * The name of the tracking option e.g. Marketing, East (max length = 100)
   */
  Name?: string;
  /**
   * The status of a tracking option
   */
  Status?: 'ACTIVE' | 'ARCHIVED' | 'DELETED';
  /**
   * Filter by a tracking category e.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9
   */
  TrackingCategoryID?: string;
  /**
   * The Xero identifier for a tracking option e.g. ae777a87-5ef3-4fa0-a4f0-d10e1f13073a
   */
  TrackingOptionID?: string;
};

export type TrackingOptions = {
  Options?: Array<TrackingOption>;
};

export type User = {
  /**
   * Email address of user
   */
  EmailAddress?: string;
  /**
   * First name of user
   */
  FirstName?: string;
  /**
   * Boolean to indicate if user is the subscriber
   */
  IsSubscriber?: boolean;
  /**
   * Last name of user
   */
  LastName?: string;
  /**
   * User role that defines permissions in Xero and via API (READONLY, INVOICEONLY, STANDARD, FINANCIALADVISER, etc)
   */
  OrganisationRole?:
    | 'READONLY'
    | 'INVOICEONLY'
    | 'STANDARD'
    | 'FINANCIALADVISER'
    | 'MANAGEDCLIENT'
    | 'CASHBOOKCLIENT'
    | 'UNKNOWN';
  /**
   * Timestamp of last change to user
   */
  readonly UpdatedDateUTC?: string;
  /**
   * Xero identifier
   */
  UserID?: string;
};

/**
 * User role that defines permissions in Xero and via API (READONLY, INVOICEONLY, STANDARD, FINANCIALADVISER, etc)
 */
export type OrganisationRole =
  | 'READONLY'
  | 'INVOICEONLY'
  | 'STANDARD'
  | 'FINANCIALADVISER'
  | 'MANAGEDCLIENT'
  | 'CASHBOOKCLIENT'
  | 'UNKNOWN';

export type Users = {
  Users?: Array<User>;
};

export type ValidationError = {
  /**
   * Validation error message
   */
  Message?: string;
};

/**
 * Only records created or modified since this timestamp will be returned
 */
export type ParameterifModifiedSince = string;

/**
 * Allows an attachment to be seen by the end customer within their online invoice
 */
export type ParameterincludeOnline = boolean;

/**
 * Xero identifier for Tenant
 */
export type ParameterrequiredHeader = string;

/**
 * If false return 200 OK and mix of successfully created objects and any with validation errors
 */
export type ParametersummarizeErrors = boolean;

/**
 * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
 */
export type Parameterunitdp = number;

export type GetAccountsData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetAccountsResponse = Accounts;

export type GetAccountsError = unknown;

export type CreateAccountData = {
  /**
   * Account object in body of request
   */
  body: Account;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type CreateAccountResponse = Accounts;

export type CreateAccountError = Error;

export type DeleteAccountData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for retrieving single object
     */
    AccountID: string;
  };
};

export type DeleteAccountResponse = Accounts;

export type DeleteAccountError = Error;

export type GetAccountData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for retrieving single object
     */
    AccountID: string;
  };
};

export type GetAccountResponse = Accounts;

export type GetAccountError = unknown;

export type UpdateAccountData = {
  /**
   * Request of type Accounts array with one Account
   */
  body: Accounts;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for retrieving single object
     */
    AccountID: string;
  };
};

export type UpdateAccountResponse = Accounts;

export type UpdateAccountError = Error;

export type GetAccountAttachmentsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for Account object
     */
    AccountID: string;
  };
};

export type GetAccountAttachmentsResponse = Attachments;

export type GetAccountAttachmentsError = unknown;

export type GetAccountAttachmentByIdData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for Account object
     */
    AccountID: string;
    /**
     * Unique identifier for Attachment object
     */
    AttachmentID: string;
  };
};

export type GetAccountAttachmentByIdResponse = Blob | File;

export type GetAccountAttachmentByIdError = unknown;

export type GetAccountAttachmentByFileNameData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for Account object
     */
    AccountID: string;
    /**
     * Name of the attachment
     */
    FileName: string;
  };
};

export type GetAccountAttachmentByFileNameResponse = Blob | File;

export type GetAccountAttachmentByFileNameError = unknown;

export type UpdateAccountAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for Account object
     */
    AccountID: string;
    /**
     * Name of the attachment
     */
    FileName: string;
  };
};

export type UpdateAccountAttachmentByFileNameResponse = Attachments;

export type UpdateAccountAttachmentByFileNameError = Error;

export type CreateAccountAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for Account object
     */
    AccountID: string;
    /**
     * Name of the attachment
     */
    FileName: string;
  };
};

export type CreateAccountAttachmentByFileNameResponse = Attachments;

export type CreateAccountAttachmentByFileNameError = Error;

export type GetBankTransactionsData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Up to 100 bank transactions will be returned in a single API call with line items details
     */
    page?: number;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetBankTransactionsResponse = BankTransactions;

export type GetBankTransactionsError = unknown;

export type UpdateOrCreateBankTransactionsData = {
  body: BankTransactions;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type UpdateOrCreateBankTransactionsResponse = BankTransactions;

export type UpdateOrCreateBankTransactionsError = Error;

export type CreateBankTransactionsData = {
  /**
   * BankTransactions with an array of BankTransaction objects in body of request
   */
  body: BankTransactions;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type CreateBankTransactionsResponse = BankTransactions;

export type CreateBankTransactionsError = Error;

export type GetBankTransactionData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transaction
     */
    BankTransactionID: string;
  };
  query?: {
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type GetBankTransactionResponse = BankTransactions;

export type GetBankTransactionError = unknown;

export type UpdateBankTransactionData = {
  body: BankTransactions;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transaction
     */
    BankTransactionID: string;
  };
  query?: {
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type UpdateBankTransactionResponse = BankTransactions;

export type UpdateBankTransactionError = Error;

export type GetBankTransactionAttachmentsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transaction
     */
    BankTransactionID: string;
  };
};

export type GetBankTransactionAttachmentsResponse = Attachments;

export type GetBankTransactionAttachmentsError = unknown;

export type GetBankTransactionAttachmentByIdData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for an attachment
     */
    AttachmentID: string;
    /**
     * Xero generated unique identifier for a bank transaction
     */
    BankTransactionID: string;
  };
};

export type GetBankTransactionAttachmentByIdResponse = Blob | File;

export type GetBankTransactionAttachmentByIdError = unknown;

export type GetBankTransactionAttachmentByFileNameData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transaction
     */
    BankTransactionID: string;
    /**
     * The name of the file being attached
     */
    FileName: string;
  };
};

export type GetBankTransactionAttachmentByFileNameResponse = Blob | File;

export type GetBankTransactionAttachmentByFileNameError = unknown;

export type UpdateBankTransactionAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transaction
     */
    BankTransactionID: string;
    /**
     * The name of the file being attached
     */
    FileName: string;
  };
};

export type UpdateBankTransactionAttachmentByFileNameResponse = Attachments;

export type UpdateBankTransactionAttachmentByFileNameError = Error;

export type CreateBankTransactionAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transaction
     */
    BankTransactionID: string;
    /**
     * The name of the file being attached
     */
    FileName: string;
  };
};

export type CreateBankTransactionAttachmentByFileNameResponse = Attachments;

export type CreateBankTransactionAttachmentByFileNameError = Error;

export type GetBankTransactionsHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transaction
     */
    BankTransactionID: string;
  };
};

export type GetBankTransactionsHistoryResponse = HistoryRecords;

export type GetBankTransactionsHistoryError = unknown;

export type CreateBankTransactionHistoryRecordData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transaction
     */
    BankTransactionID: string;
  };
};

export type CreateBankTransactionHistoryRecordResponse = HistoryRecords;

export type CreateBankTransactionHistoryRecordError = Error;

export type GetBankTransfersData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetBankTransfersResponse = BankTransfers;

export type GetBankTransfersError = unknown;

export type CreateBankTransferData = {
  /**
   * BankTransfers with array of BankTransfer objects in request body
   */
  body: BankTransfers;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type CreateBankTransferResponse = BankTransfers;

export type CreateBankTransferError = Error;

export type GetBankTransferData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transfer
     */
    BankTransferID: string;
  };
};

export type GetBankTransferResponse = BankTransfers;

export type GetBankTransferError = unknown;

export type GetBankTransferAttachmentsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transfer
     */
    BankTransferID: string;
  };
};

export type GetBankTransferAttachmentsResponse = Attachments;

export type GetBankTransferAttachmentsError = unknown;

export type GetBankTransferAttachmentByIdData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for an Attachment to a bank transfer
     */
    AttachmentID: string;
    /**
     * Xero generated unique identifier for a bank transfer
     */
    BankTransferID: string;
  };
};

export type GetBankTransferAttachmentByIdResponse = Blob | File;

export type GetBankTransferAttachmentByIdError = unknown;

export type GetBankTransferAttachmentByFileNameData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transfer
     */
    BankTransferID: string;
    /**
     * The name of the file being attached to a Bank Transfer
     */
    FileName: string;
  };
};

export type GetBankTransferAttachmentByFileNameResponse = Blob | File;

export type GetBankTransferAttachmentByFileNameError = unknown;

export type UpdateBankTransferAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transfer
     */
    BankTransferID: string;
    /**
     * The name of the file being attached to a Bank Transfer
     */
    FileName: string;
  };
};

export type UpdateBankTransferAttachmentByFileNameResponse = Attachments;

export type UpdateBankTransferAttachmentByFileNameError = Error;

export type CreateBankTransferAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transfer
     */
    BankTransferID: string;
    /**
     * The name of the file being attached to a Bank Transfer
     */
    FileName: string;
  };
};

export type CreateBankTransferAttachmentByFileNameResponse = Attachments;

export type CreateBankTransferAttachmentByFileNameError = Error;

export type GetBankTransferHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transfer
     */
    BankTransferID: string;
  };
};

export type GetBankTransferHistoryResponse = HistoryRecords;

export type GetBankTransferHistoryError = unknown;

export type CreateBankTransferHistoryRecordData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a bank transfer
     */
    BankTransferID: string;
  };
};

export type CreateBankTransferHistoryRecordResponse = HistoryRecords;

export type CreateBankTransferHistoryRecordError = Error;

export type GetBatchPaymentsData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetBatchPaymentsResponse = BatchPayments;

export type GetBatchPaymentsError = unknown;

export type CreateBatchPaymentData = {
  /**
   * BatchPayments with an array of Payments in body of request
   */
  body: BatchPayments;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type CreateBatchPaymentResponse = BatchPayments;

export type CreateBatchPaymentError = Error;

export type GetBatchPaymentHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for BatchPayment
     */
    BatchPaymentID: string;
  };
};

export type GetBatchPaymentHistoryResponse = HistoryRecords;

export type GetBatchPaymentHistoryError = unknown;

export type CreateBatchPaymentHistoryRecordData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for BatchPayment
     */
    BatchPaymentID: string;
  };
};

export type CreateBatchPaymentHistoryRecordResponse = HistoryRecords;

export type CreateBatchPaymentHistoryRecordError = Error;

export type GetBrandingThemesData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type GetBrandingThemesResponse = BrandingThemes;

export type GetBrandingThemesError = unknown;

export type GetBrandingThemeData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Branding Theme
     */
    BrandingThemeID: string;
  };
};

export type GetBrandingThemeResponse = BrandingThemes;

export type GetBrandingThemeError = unknown;

export type GetBrandingThemePaymentServicesData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Branding Theme
     */
    BrandingThemeID: string;
  };
};

export type GetBrandingThemePaymentServicesResponse = PaymentServices;

export type GetBrandingThemePaymentServicesError = unknown;

export type CreateBrandingThemePaymentServicesData = {
  /**
   * PaymentService object in body of request
   */
  body: PaymentService;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Branding Theme
     */
    BrandingThemeID: string;
  };
};

export type CreateBrandingThemePaymentServicesResponse = PaymentServices;

export type CreateBrandingThemePaymentServicesError = Error;

export type GetContactGroupsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetContactGroupsResponse = ContactGroups;

export type GetContactGroupsError = unknown;

export type CreateContactGroupData = {
  /**
   * ContactGroups with an array of names in request body
   */
  body: ContactGroups;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type CreateContactGroupResponse = ContactGroups;

export type CreateContactGroupError = Error;

export type GetContactGroupData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact Group
     */
    ContactGroupID: string;
  };
};

export type GetContactGroupResponse = ContactGroups;

export type GetContactGroupError = unknown;

export type UpdateContactGroupData = {
  /**
   * an array of Contact groups with Name of specific group to update
   */
  body: ContactGroups;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact Group
     */
    ContactGroupID: string;
  };
};

export type UpdateContactGroupResponse = ContactGroups;

export type UpdateContactGroupError = Error;

export type DeleteContactGroupContactsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact Group
     */
    ContactGroupID: string;
  };
};

export type DeleteContactGroupContactsResponse = any;

export type DeleteContactGroupContactsError = unknown;

export type CreateContactGroupContactsData = {
  /**
   * Contacts with array of contacts specifying the ContactID to be added to ContactGroup in body of request
   */
  body: Contacts;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact Group
     */
    ContactGroupID: string;
  };
};

export type CreateContactGroupContactsResponse = Contacts;

export type CreateContactGroupContactsError = Error;

export type DeleteContactGroupContactData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact Group
     */
    ContactGroupID: string;
    /**
     * Unique identifier for a Contact
     */
    ContactID: string;
  };
};

export type DeleteContactGroupContactResponse = any;

export type DeleteContactGroupContactError = Error;

export type GetContactsData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Filter by a comma separated list of ContactIDs. Allows you to retrieve a specific set of contacts in a single call.
     */
    IDs?: Array<string>;
    /**
     * e.g. includeArchived=true - Contacts with a status of ARCHIVED will be included in the response
     */
    includeArchived?: boolean;
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * e.g. page=1 - Up to 100 contacts will be returned in a single API call.
     */
    page?: number;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetContactsResponse = Contacts;

export type GetContactsError = unknown;

export type UpdateOrCreateContactsData = {
  body: Contacts;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type UpdateOrCreateContactsResponse = Contacts;

export type UpdateOrCreateContactsError = Error;

export type CreateContactsData = {
  /**
   * Contacts with an array of Contact objects to create in body of request
   */
  body: Contacts;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type CreateContactsResponse = Contacts;

export type CreateContactsError = Error;

export type GetContactData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact
     */
    ContactID: string;
  };
};

export type GetContactResponse = Contacts;

export type GetContactError = unknown;

export type UpdateContactData = {
  /**
   * an array of Contacts containing single Contact object with properties to update
   */
  body: Contacts;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact
     */
    ContactID: string;
  };
};

export type UpdateContactResponse = Contacts;

export type UpdateContactError = Error;

export type GetContactAttachmentsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact
     */
    ContactID: string;
  };
};

export type GetContactAttachmentsResponse = Attachments;

export type GetContactAttachmentsError = unknown;

export type GetContactAttachmentByIdData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Attachment
     */
    AttachmentID: string;
    /**
     * Unique identifier for a Contact
     */
    ContactID: string;
  };
};

export type GetContactAttachmentByIdResponse = Blob | File;

export type GetContactAttachmentByIdError = unknown;

export type GetContactAttachmentByFileNameData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact
     */
    ContactID: string;
    /**
     * Name for the file you are attaching
     */
    FileName: string;
  };
};

export type GetContactAttachmentByFileNameResponse = Blob | File;

export type GetContactAttachmentByFileNameError = unknown;

export type UpdateContactAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact
     */
    ContactID: string;
    /**
     * Name for the file you are attaching
     */
    FileName: string;
  };
};

export type UpdateContactAttachmentByFileNameResponse = Attachments;

export type UpdateContactAttachmentByFileNameError = Error;

export type CreateContactAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact
     */
    ContactID: string;
    /**
     * Name for the file you are attaching
     */
    FileName: string;
  };
};

export type CreateContactAttachmentByFileNameResponse = Attachments;

export type CreateContactAttachmentByFileNameError = Error;

export type GetContactCisSettingsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact
     */
    ContactID: string;
  };
};

export type GetContactCisSettingsResponse = CISSettings;

export type GetContactCisSettingsError = unknown;

export type GetContactHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact
     */
    ContactID: string;
  };
};

export type GetContactHistoryResponse = HistoryRecords;

export type GetContactHistoryError = unknown;

export type CreateContactHistoryData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Contact
     */
    ContactID: string;
  };
};

export type CreateContactHistoryResponse = HistoryRecords;

export type CreateContactHistoryError = Error;

export type GetContactByContactNumberData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * This field is read only on the Xero contact screen, used to identify contacts in external systems (max length = 50).
     */
    ContactNumber: string;
  };
};

export type GetContactByContactNumberResponse = Contacts;

export type GetContactByContactNumberError = unknown;

export type GetCreditNotesData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * e.g. page=1 – Up to 100 credit notes will be returned in a single API call with line items shown for each credit note
     */
    page?: number;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetCreditNotesResponse = CreditNotes;

export type GetCreditNotesError = unknown;

export type UpdateOrCreateCreditNotesData = {
  /**
   * an array of Credit Notes with a single CreditNote object.
   */
  body: CreditNotes;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type UpdateOrCreateCreditNotesResponse = CreditNotes;

export type UpdateOrCreateCreditNotesError = Error;

export type CreateCreditNotesData = {
  /**
   * Credit Notes with array of CreditNote object in body of request
   */
  body: CreditNotes;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type CreateCreditNotesResponse = CreditNotes;

export type CreateCreditNotesError = Error;

export type GetCreditNoteData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Credit Note
     */
    CreditNoteID: string;
  };
  query?: {
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type GetCreditNoteResponse = CreditNotes;

export type GetCreditNoteError = unknown;

export type UpdateCreditNoteData = {
  /**
   * an array of Credit Notes containing credit note details to update
   */
  body: CreditNotes;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Credit Note
     */
    CreditNoteID: string;
  };
  query?: {
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type UpdateCreditNoteResponse = CreditNotes;

export type UpdateCreditNoteError = Error;

export type CreateCreditNoteAllocationData = {
  /**
   * Allocations with array of Allocation object in body of request.
   */
  body: Allocations;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Credit Note
     */
    CreditNoteID: string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type CreateCreditNoteAllocationResponse = Allocations;

export type CreateCreditNoteAllocationError = Error;

export type GetCreditNoteAttachmentsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Credit Note
     */
    CreditNoteID: string;
  };
};

export type GetCreditNoteAttachmentsResponse = Attachments;

export type GetCreditNoteAttachmentsError = unknown;

export type GetCreditNoteAttachmentByIdData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Attachment
     */
    AttachmentID: string;
    /**
     * Unique identifier for a Credit Note
     */
    CreditNoteID: string;
  };
};

export type GetCreditNoteAttachmentByIdResponse = Blob | File;

export type GetCreditNoteAttachmentByIdError = unknown;

export type GetCreditNoteAttachmentByFileNameData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Credit Note
     */
    CreditNoteID: string;
    /**
     * Name of the file you are attaching to Credit Note
     */
    FileName: string;
  };
};

export type GetCreditNoteAttachmentByFileNameResponse = Blob | File;

export type GetCreditNoteAttachmentByFileNameError = unknown;

export type UpdateCreditNoteAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Credit Note
     */
    CreditNoteID: string;
    /**
     * Name of the file you are attaching to Credit Note
     */
    FileName: string;
  };
};

export type UpdateCreditNoteAttachmentByFileNameResponse = Attachments;

export type UpdateCreditNoteAttachmentByFileNameError = Error;

export type CreateCreditNoteAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Credit Note
     */
    CreditNoteID: string;
    /**
     * Name of the file you are attaching to Credit Note
     */
    FileName: string;
  };
  query?: {
    /**
     * Allows an attachment to be seen by the end customer within their online invoice
     */
    IncludeOnline?: boolean;
  };
};

export type CreateCreditNoteAttachmentByFileNameResponse = Attachments;

export type CreateCreditNoteAttachmentByFileNameError = Error;

export type GetCreditNoteHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Credit Note
     */
    CreditNoteID: string;
  };
};

export type GetCreditNoteHistoryResponse = HistoryRecords;

export type GetCreditNoteHistoryError = unknown;

export type CreateCreditNoteHistoryData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Credit Note
     */
    CreditNoteID: string;
  };
};

export type CreateCreditNoteHistoryResponse = HistoryRecords;

export type CreateCreditNoteHistoryError = Error;

export type GetCreditNoteAsPdfData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Credit Note
     */
    CreditNoteID: string;
  };
};

export type GetCreditNoteAsPdfResponse = Blob | File;

export type GetCreditNoteAsPdfError = unknown;

export type GetCurrenciesData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetCurrenciesResponse = Currencies;

export type GetCurrenciesError = unknown;

export type CreateCurrencyData = {
  /**
   * Currency object in the body of request
   */
  body: Currency;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type CreateCurrencyResponse = Currencies;

export type CreateCurrencyError = unknown;

export type GetEmployeesData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetEmployeesResponse = Employees;

export type GetEmployeesError = unknown;

export type UpdateOrCreateEmployeesData = {
  /**
   * Employees with array of Employee object in body of request
   */
  body: Employees;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type UpdateOrCreateEmployeesResponse = Employees;

export type UpdateOrCreateEmployeesError = Error;

export type CreateEmployeesData = {
  /**
   * Employees with array of Employee object in body of request
   */
  body: Employees;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type CreateEmployeesResponse = Employees;

export type CreateEmployeesError = Error;

export type GetEmployeeData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Employee
     */
    EmployeeID: string;
  };
};

export type GetEmployeeResponse = Employees;

export type GetEmployeeError = unknown;

export type GetExpenseClaimsData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetExpenseClaimsResponse = ExpenseClaims;

export type GetExpenseClaimsError = unknown;

export type CreateExpenseClaimsData = {
  /**
   * ExpenseClaims with array of ExpenseClaim object in body of request
   */
  body: ExpenseClaims;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type CreateExpenseClaimsResponse = ExpenseClaims;

export type CreateExpenseClaimsError = Error;

export type GetExpenseClaimData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a ExpenseClaim
     */
    ExpenseClaimID: string;
  };
};

export type GetExpenseClaimResponse = ExpenseClaims;

export type GetExpenseClaimError = unknown;

export type UpdateExpenseClaimData = {
  body: ExpenseClaims;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a ExpenseClaim
     */
    ExpenseClaimID: string;
  };
};

export type UpdateExpenseClaimResponse = ExpenseClaims;

export type UpdateExpenseClaimError = Error;

export type GetExpenseClaimHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a ExpenseClaim
     */
    ExpenseClaimID: string;
  };
};

export type GetExpenseClaimHistoryResponse = HistoryRecords;

export type GetExpenseClaimHistoryError = unknown;

export type CreateExpenseClaimHistoryData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a ExpenseClaim
     */
    ExpenseClaimID: string;
  };
};

export type CreateExpenseClaimHistoryResponse = HistoryRecords;

export type CreateExpenseClaimHistoryError = unknown;

export type GetInvoiceRemindersData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type GetInvoiceRemindersResponse = InvoiceReminders;

export type GetInvoiceRemindersError = unknown;

export type GetInvoicesData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Filter by a comma-separated list of ContactIDs.
     */
    ContactIDs?: Array<string>;
    /**
     * When set to true you'll only retrieve Invoices created by your app
     */
    createdByMyApp?: boolean;
    /**
     * Filter by a comma-separated list of InvoicesIDs.
     */
    IDs?: Array<string>;
    /**
     * e.g. includeArchived=true - Contacts with a status of ARCHIVED will be included in the response
     */
    includeArchived?: boolean;
    /**
     * Filter by a comma-separated list of InvoiceNumbers.
     */
    InvoiceNumbers?: Array<string>;
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * e.g. page=1 – Up to 100 invoices will be returned in a single API call with line items shown for each invoice
     */
    page?: number;
    /**
     * Filter by a comma-separated list Statuses. For faster response times we recommend using these explicit parameters instead of passing OR conditions into the Where filter.
     */
    Statuses?: Array<string>;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetInvoicesResponse = Invoices;

export type GetInvoicesError = unknown;

export type UpdateOrCreateInvoicesData = {
  body: Invoices;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type UpdateOrCreateInvoicesResponse = Invoices;

export type UpdateOrCreateInvoicesError = Error;

export type CreateInvoicesData = {
  /**
   * Invoices with an array of invoice objects in body of request
   */
  body: Invoices;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type CreateInvoicesResponse = Invoices;

export type CreateInvoicesError = Error;

export type GetInvoiceData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Invoice
     */
    InvoiceID: string;
  };
  query?: {
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type GetInvoiceResponse = Invoices;

export type GetInvoiceError = unknown;

export type UpdateInvoiceData = {
  body: Invoices;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Invoice
     */
    InvoiceID: string;
  };
  query?: {
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type UpdateInvoiceResponse = Invoices;

export type UpdateInvoiceError = Error;

export type GetInvoiceAttachmentsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Invoice
     */
    InvoiceID: string;
  };
};

export type GetInvoiceAttachmentsResponse = Attachments;

export type GetInvoiceAttachmentsError = unknown;

export type GetInvoiceAttachmentByIdData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Attachment
     */
    AttachmentID: string;
    /**
     * Unique identifier for an Invoice
     */
    InvoiceID: string;
  };
};

export type GetInvoiceAttachmentByIdResponse = Blob | File;

export type GetInvoiceAttachmentByIdError = unknown;

export type GetInvoiceAttachmentByFileNameData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Name of the file you are attaching
     */
    FileName: string;
    /**
     * Unique identifier for an Invoice
     */
    InvoiceID: string;
  };
};

export type GetInvoiceAttachmentByFileNameResponse = Blob | File;

export type GetInvoiceAttachmentByFileNameError = unknown;

export type UpdateInvoiceAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Name of the file you are attaching
     */
    FileName: string;
    /**
     * Unique identifier for an Invoice
     */
    InvoiceID: string;
  };
};

export type UpdateInvoiceAttachmentByFileNameResponse = Attachments;

export type UpdateInvoiceAttachmentByFileNameError = Error;

export type CreateInvoiceAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Name of the file you are attaching
     */
    FileName: string;
    /**
     * Unique identifier for an Invoice
     */
    InvoiceID: string;
  };
  query?: {
    /**
     * Allows an attachment to be seen by the end customer within their online invoice
     */
    IncludeOnline?: boolean;
  };
};

export type CreateInvoiceAttachmentByFileNameResponse = Attachments;

export type CreateInvoiceAttachmentByFileNameError = Error;

export type EmailInvoiceData = {
  body: RequestEmpty;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Invoice
     */
    InvoiceID: string;
  };
};

export type EmailInvoiceResponse = any;

export type EmailInvoiceError = Error;

export type GetInvoiceHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Invoice
     */
    InvoiceID: string;
  };
};

export type GetInvoiceHistoryResponse = HistoryRecords;

export type GetInvoiceHistoryError = unknown;

export type CreateInvoiceHistoryData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Invoice
     */
    InvoiceID: string;
  };
};

export type CreateInvoiceHistoryResponse = HistoryRecords;

export type CreateInvoiceHistoryError = Error;

export type GetOnlineInvoiceData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Invoice
     */
    InvoiceID: string;
  };
};

export type GetOnlineInvoiceResponse = OnlineInvoices;

export type GetOnlineInvoiceError = unknown;

export type GetInvoiceAsPdfData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Invoice
     */
    InvoiceID: string;
  };
};

export type GetInvoiceAsPdfResponse = Blob | File;

export type GetInvoiceAsPdfError = unknown;

export type GetItemsData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetItemsResponse = Items;

export type GetItemsError = unknown;

export type UpdateOrCreateItemsData = {
  body: Items;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type UpdateOrCreateItemsResponse = Items;

export type UpdateOrCreateItemsError = Error;

export type CreateItemsData = {
  /**
   * Items with an array of Item objects in body of request
   */
  body: Items;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type CreateItemsResponse = Items;

export type CreateItemsError = Error;

export type DeleteItemData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Item
     */
    ItemID: string;
  };
};

export type DeleteItemResponse = any;

export type DeleteItemError = Error;

export type GetItemData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Item
     */
    ItemID: string;
  };
  query?: {
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type GetItemResponse = Items;

export type GetItemError = unknown;

export type UpdateItemData = {
  body: Items;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Item
     */
    ItemID: string;
  };
  query?: {
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type UpdateItemResponse = Items;

export type UpdateItemError = Error;

export type GetItemHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Item
     */
    ItemID: string;
  };
};

export type GetItemHistoryResponse = HistoryRecords;

export type GetItemHistoryError = unknown;

export type CreateItemHistoryData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Item
     */
    ItemID: string;
  };
};

export type CreateItemHistoryResponse = HistoryRecords;

export type CreateItemHistoryError = unknown;

export type GetJournalsData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Offset by a specified journal number. e.g. journals with a JournalNumber greater than the offset will be returned
     */
    offset?: number;
    /**
     * Filter to retrieve journals on a cash basis. Journals are returned on an accrual basis by default.
     */
    paymentsOnly?: boolean;
  };
};

export type GetJournalsResponse = Journals;

export type GetJournalsError = unknown;

export type GetJournalData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Journal
     */
    JournalID: string;
  };
};

export type GetJournalResponse = Journals;

export type GetJournalError = unknown;

export type GetLinkedTransactionsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Filter by the ContactID. Get all the linked transactions that have been assigned to a particular customer.
     */
    ContactID?: string;
    /**
     * The Xero identifier for an Linked Transaction
     */
    LinkedTransactionID?: string;
    /**
     * Up to 100 linked transactions will be returned in a single API call. Use the page parameter to specify the page to be returned e.g. page=1.
     */
    page?: number;
    /**
     * Filter by the SourceTransactionID. Get the linked transactions created from a particular ACCPAY invoice
     */
    SourceTransactionID?: string;
    /**
     * Filter by the combination of ContactID and Status. Get  the linked transactions associated to a  customer and with a status
     */
    Status?: string;
    /**
     * Filter by the TargetTransactionID. Get all the linked transactions allocated to a particular ACCREC invoice
     */
    TargetTransactionID?: string;
  };
};

export type GetLinkedTransactionsResponse = LinkedTransactions;

export type GetLinkedTransactionsError = unknown;

export type CreateLinkedTransactionData = {
  /**
   * LinkedTransaction object in body of request
   */
  body: LinkedTransaction;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type CreateLinkedTransactionResponse = LinkedTransactions;

export type CreateLinkedTransactionError = Error;

export type DeleteLinkedTransactionData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a LinkedTransaction
     */
    LinkedTransactionID: string;
  };
};

export type DeleteLinkedTransactionResponse = any;

export type DeleteLinkedTransactionError = Error;

export type GetLinkedTransactionData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a LinkedTransaction
     */
    LinkedTransactionID: string;
  };
};

export type GetLinkedTransactionResponse = LinkedTransactions;

export type GetLinkedTransactionError = unknown;

export type UpdateLinkedTransactionData = {
  body: LinkedTransactions;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a LinkedTransaction
     */
    LinkedTransactionID: string;
  };
};

export type UpdateLinkedTransactionResponse = LinkedTransactions;

export type UpdateLinkedTransactionError = Error;

export type GetManualJournalsData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * e.g. page=1 – Up to 100 manual journals will be returned in a single API call with line items shown for each overpayment
     */
    page?: number;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetManualJournalsResponse = ManualJournals;

export type GetManualJournalsError = unknown;

export type UpdateOrCreateManualJournalsData = {
  /**
   * ManualJournals array with ManualJournal object in body of request
   */
  body: ManualJournals;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type UpdateOrCreateManualJournalsResponse = ManualJournals;

export type UpdateOrCreateManualJournalsError = Error;

export type CreateManualJournalsData = {
  /**
   * ManualJournals array with ManualJournal object in body of request
   */
  body: ManualJournals;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type CreateManualJournalsResponse = ManualJournals;

export type CreateManualJournalsError = Error;

export type GetManualJournalData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a ManualJournal
     */
    ManualJournalID: string;
  };
};

export type GetManualJournalResponse = ManualJournals;

export type GetManualJournalError = unknown;

export type UpdateManualJournalData = {
  body: ManualJournals;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a ManualJournal
     */
    ManualJournalID: string;
  };
};

export type UpdateManualJournalResponse = ManualJournals;

export type UpdateManualJournalError = Error;

export type GetManualJournalAttachmentsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a ManualJournal
     */
    ManualJournalID: string;
  };
};

export type GetManualJournalAttachmentsResponse = Attachments;

export type GetManualJournalAttachmentsError = unknown;

export type GetManualJournalAttachmentByIdData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Attachment
     */
    AttachmentID: string;
    /**
     * Unique identifier for a ManualJournal
     */
    ManualJournalID: string;
  };
};

export type GetManualJournalAttachmentByIdResponse = Blob | File;

export type GetManualJournalAttachmentByIdError = unknown;

export type GetManualJournalAttachmentByFileNameData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * The name of the file being attached to a ManualJournal
     */
    FileName: string;
    /**
     * Unique identifier for a ManualJournal
     */
    ManualJournalID: string;
  };
};

export type GetManualJournalAttachmentByFileNameResponse = Blob | File;

export type GetManualJournalAttachmentByFileNameError = unknown;

export type UpdateManualJournalAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * The name of the file being attached to a ManualJournal
     */
    FileName: string;
    /**
     * Unique identifier for a ManualJournal
     */
    ManualJournalID: string;
  };
};

export type UpdateManualJournalAttachmentByFileNameResponse = Attachments;

export type UpdateManualJournalAttachmentByFileNameError = Error;

export type CreateManualJournalAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * The name of the file being attached to a ManualJournal
     */
    FileName: string;
    /**
     * Unique identifier for a ManualJournal
     */
    ManualJournalID: string;
  };
};

export type CreateManualJournalAttachmentByFileNameResponse = Attachments;

export type CreateManualJournalAttachmentByFileNameError = Error;

export type GetManualJournalsHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a manual journal
     */
    ManualJournalID: string;
  };
};

export type GetManualJournalsHistoryResponse = HistoryRecords;

export type GetManualJournalsHistoryError = unknown;

export type CreateManualJournalHistoryRecordData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Xero generated unique identifier for a manual journal
     */
    ManualJournalID: string;
  };
};

export type CreateManualJournalHistoryRecordResponse = HistoryRecords;

export type CreateManualJournalHistoryRecordError = Error;

export type GetOrganisationsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type GetOrganisationsResponse = Organisations;

export type GetOrganisationsError = unknown;

export type GetOrganisationActionsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type GetOrganisationActionsResponse = Actions;

export type GetOrganisationActionsError = unknown;

export type GetOrganisationCisSettingsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * The unique Xero identifier for an organisation
     */
    OrganisationID: string;
  };
};

export type GetOrganisationCisSettingsResponse = CISOrgSettings;

export type GetOrganisationCisSettingsError = unknown;

export type GetOverpaymentsData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * e.g. page=1 – Up to 100 overpayments will be returned in a single API call with line items shown for each overpayment
     */
    page?: number;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetOverpaymentsResponse = Overpayments;

export type GetOverpaymentsError = unknown;

export type GetOverpaymentData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Overpayment
     */
    OverpaymentID: string;
  };
};

export type GetOverpaymentResponse = Overpayments;

export type GetOverpaymentError = unknown;

export type CreateOverpaymentAllocationsData = {
  /**
   * Allocations array with Allocation object in body of request
   */
  body: Allocations;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Overpayment
     */
    OverpaymentID: string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type CreateOverpaymentAllocationsResponse = Allocations;

export type CreateOverpaymentAllocationsError = Error;

export type GetOverpaymentHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Overpayment
     */
    OverpaymentID: string;
  };
};

export type GetOverpaymentHistoryResponse = HistoryRecords;

export type GetOverpaymentHistoryError = unknown;

export type CreateOverpaymentHistoryData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Overpayment
     */
    OverpaymentID: string;
  };
};

export type CreateOverpaymentHistoryResponse = HistoryRecords;

export type CreateOverpaymentHistoryError = Error;

export type GetPaymentServicesData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type GetPaymentServicesResponse = PaymentServices;

export type GetPaymentServicesError = unknown;

export type CreatePaymentServiceData = {
  /**
   * PaymentServices array with PaymentService object in body of request
   */
  body: PaymentServices;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type CreatePaymentServiceResponse = PaymentServices;

export type CreatePaymentServiceError = Error;

export type GetPaymentsData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Up to 100 payments will be returned in a single API call
     */
    page?: number;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetPaymentsResponse = Payments;

export type GetPaymentsError = unknown;

export type CreatePaymentData = {
  /**
   * Request body with a single Payment object
   */
  body: Payment;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type CreatePaymentResponse = Payments;

export type CreatePaymentError = Error;

export type CreatePaymentsData = {
  /**
   * Payments array with Payment object in body of request
   */
  body: Payments;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type CreatePaymentsResponse = Payments;

export type CreatePaymentsError = Error;

export type GetPaymentData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Payment
     */
    PaymentID: string;
  };
};

export type GetPaymentResponse = Payments;

export type GetPaymentError = unknown;

export type DeletePaymentData = {
  body: PaymentDelete;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Payment
     */
    PaymentID: string;
  };
};

export type DeletePaymentResponse = Payments;

export type DeletePaymentError = Error;

export type GetPaymentHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Payment
     */
    PaymentID: string;
  };
};

export type GetPaymentHistoryResponse = HistoryRecords;

export type GetPaymentHistoryError = unknown;

export type CreatePaymentHistoryData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Payment
     */
    PaymentID: string;
  };
};

export type CreatePaymentHistoryResponse = HistoryRecords;

export type CreatePaymentHistoryError = Error;

export type GetPrepaymentsData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * e.g. page=1 – Up to 100 prepayments will be returned in a single API call with line items shown for each overpayment
     */
    page?: number;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetPrepaymentsResponse = Prepayments;

export type GetPrepaymentsError = unknown;

export type GetPrepaymentData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a PrePayment
     */
    PrepaymentID: string;
  };
};

export type GetPrepaymentResponse = Prepayments;

export type GetPrepaymentError = unknown;

export type CreatePrepaymentAllocationsData = {
  /**
   * Allocations with an array of Allocation object in body of request
   */
  body: Allocations;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for Prepayment
     */
    PrepaymentID: string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type CreatePrepaymentAllocationsResponse = Allocations;

export type CreatePrepaymentAllocationsError = Error;

export type GetPrepaymentHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a PrePayment
     */
    PrepaymentID: string;
  };
};

export type GetPrepaymentHistoryResponse = HistoryRecords;

export type GetPrepaymentHistoryError = unknown;

export type CreatePrepaymentHistoryData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a PrePayment
     */
    PrepaymentID: string;
  };
};

export type CreatePrepaymentHistoryResponse = HistoryRecords;

export type CreatePrepaymentHistoryError = Error;

export type GetPurchaseOrdersData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Filter by purchase order date (e.g. GET https://.../PurchaseOrders?DateFrom=2015-12-01&DateTo=2015-12-31
     */
    DateFrom?: string;
    /**
     * Filter by purchase order date (e.g. GET https://.../PurchaseOrders?DateFrom=2015-12-01&DateTo=2015-12-31
     */
    DateTo?: string;
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * To specify a page, append the page parameter to the URL e.g. ?page=1. If there are 100 records in the response you will need to check if there is any more data by fetching the next page e.g ?page=2 and continuing this process until no more results are returned.
     */
    page?: number;
    /**
     * Filter by purchase order status
     */
    Status?: 'DRAFT' | 'SUBMITTED' | 'AUTHORISED' | 'BILLED' | 'DELETED';
  };
};

export type GetPurchaseOrdersResponse = PurchaseOrders;

export type GetPurchaseOrdersError = unknown;

export type UpdateOrCreatePurchaseOrdersData = {
  body: PurchaseOrders;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type UpdateOrCreatePurchaseOrdersResponse = PurchaseOrders;

export type UpdateOrCreatePurchaseOrdersError = Error;

export type CreatePurchaseOrdersData = {
  /**
   * PurchaseOrders with an array of PurchaseOrder object in body of request
   */
  body: PurchaseOrders;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type CreatePurchaseOrdersResponse = PurchaseOrders;

export type CreatePurchaseOrdersError = Error;

export type GetPurchaseOrderData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a PurchaseOrder
     */
    PurchaseOrderID: string;
  };
};

export type GetPurchaseOrderResponse = PurchaseOrders;

export type GetPurchaseOrderError = unknown;

export type UpdatePurchaseOrderData = {
  body: PurchaseOrders;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a PurchaseOrder
     */
    PurchaseOrderID: string;
  };
};

export type UpdatePurchaseOrderResponse = PurchaseOrders;

export type UpdatePurchaseOrderError = Error;

export type GetPurchaseOrderAttachmentsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for Purchase Orders object
     */
    PurchaseOrderID: string;
  };
};

export type GetPurchaseOrderAttachmentsResponse = Attachments;

export type GetPurchaseOrderAttachmentsError = unknown;

export type GetPurchaseOrderAttachmentByIdData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for Attachment object
     */
    AttachmentID: string;
    /**
     * Unique identifier for Purchase Order object
     */
    PurchaseOrderID: string;
  };
};

export type GetPurchaseOrderAttachmentByIdResponse = Blob | File;

export type GetPurchaseOrderAttachmentByIdError = unknown;

export type GetPurchaseOrderAttachmentByFileNameData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Name of the attachment
     */
    FileName: string;
    /**
     * Unique identifier for Purchase Order object
     */
    PurchaseOrderID: string;
  };
};

export type GetPurchaseOrderAttachmentByFileNameResponse = Blob | File;

export type GetPurchaseOrderAttachmentByFileNameError = unknown;

export type UpdatePurchaseOrderAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Name of the attachment
     */
    FileName: string;
    /**
     * Unique identifier for Purchase Order object
     */
    PurchaseOrderID: string;
  };
};

export type UpdatePurchaseOrderAttachmentByFileNameResponse = Attachments;

export type UpdatePurchaseOrderAttachmentByFileNameError = Error;

export type CreatePurchaseOrderAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Name of the attachment
     */
    FileName: string;
    /**
     * Unique identifier for Purchase Order object
     */
    PurchaseOrderID: string;
  };
};

export type CreatePurchaseOrderAttachmentByFileNameResponse = Attachments;

export type CreatePurchaseOrderAttachmentByFileNameError = Error;

export type GetPurchaseOrderHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a PurchaseOrder
     */
    PurchaseOrderID: string;
  };
};

export type GetPurchaseOrderHistoryResponse = HistoryRecords;

export type GetPurchaseOrderHistoryError = unknown;

export type CreatePurchaseOrderHistoryData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a PurchaseOrder
     */
    PurchaseOrderID: string;
  };
};

export type CreatePurchaseOrderHistoryResponse = HistoryRecords;

export type CreatePurchaseOrderHistoryError = Error;

export type GetPurchaseOrderAsPdfData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Purchase Order
     */
    PurchaseOrderID: string;
  };
};

export type GetPurchaseOrderAsPdfResponse = Blob | File;

export type GetPurchaseOrderAsPdfError = unknown;

export type GetPurchaseOrderByNumberData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a PurchaseOrder
     */
    PurchaseOrderNumber: string;
  };
};

export type GetPurchaseOrderByNumberResponse = PurchaseOrders;

export type GetPurchaseOrderByNumberError = unknown;

export type GetQuotesData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Filter for quotes belonging to a particular contact
     */
    ContactID?: string;
    /**
     * Filter for quotes after a particular date
     */
    DateFrom?: string;
    /**
     * Filter for quotes before a particular date
     */
    DateTo?: string;
    /**
     * Filter for quotes expiring after a particular date
     */
    ExpiryDateFrom?: string;
    /**
     * Filter for quotes before a particular date
     */
    ExpiryDateTo?: string;
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * e.g. page=1 – Up to 100 Quotes will be returned in a single API call with line items shown for each quote
     */
    page?: number;
    /**
     * Filter by quote number (e.g. GET https://.../Quotes?QuoteNumber=QU-0001)
     */
    QuoteNumber?: string;
    /**
     * Filter for quotes of a particular Status
     */
    Status?: string;
  };
};

export type GetQuotesResponse = Quotes;

export type GetQuotesError = unknown;

export type UpdateOrCreateQuotesData = {
  body: Quotes;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type UpdateOrCreateQuotesResponse = Quotes;

export type UpdateOrCreateQuotesError = Error;

export type CreateQuotesData = {
  /**
   * Quotes with an array of Quote object in body of request
   */
  body: Quotes;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * If false return 200 OK and mix of successfully created objects and any with validation errors
     */
    summarizeErrors?: boolean;
  };
};

export type CreateQuotesResponse = Quotes;

export type CreateQuotesError = Error;

export type GetQuoteData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Quote
     */
    QuoteID: string;
  };
};

export type GetQuoteResponse = Quotes;

export type GetQuoteError = unknown;

export type UpdateQuoteData = {
  body: Quotes;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Quote
     */
    QuoteID: string;
  };
};

export type UpdateQuoteResponse = Quotes;

export type UpdateQuoteError = Error;

export type GetQuoteAttachmentsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for Quote object
     */
    QuoteID: string;
  };
};

export type GetQuoteAttachmentsResponse = Attachments;

export type GetQuoteAttachmentsError = unknown;

export type GetQuoteAttachmentByIdData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for Attachment object
     */
    AttachmentID: string;
    /**
     * Unique identifier for Quote object
     */
    QuoteID: string;
  };
};

export type GetQuoteAttachmentByIdResponse = Blob | File;

export type GetQuoteAttachmentByIdError = unknown;

export type GetQuoteAttachmentByFileNameData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Name of the attachment
     */
    FileName: string;
    /**
     * Unique identifier for Quote object
     */
    QuoteID: string;
  };
};

export type GetQuoteAttachmentByFileNameResponse = Blob | File;

export type GetQuoteAttachmentByFileNameError = unknown;

export type UpdateQuoteAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Name of the attachment
     */
    FileName: string;
    /**
     * Unique identifier for Quote object
     */
    QuoteID: string;
  };
};

export type UpdateQuoteAttachmentByFileNameResponse = Attachments;

export type UpdateQuoteAttachmentByFileNameError = Error;

export type CreateQuoteAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Name of the attachment
     */
    FileName: string;
    /**
     * Unique identifier for Quote object
     */
    QuoteID: string;
  };
};

export type CreateQuoteAttachmentByFileNameResponse = Attachments;

export type CreateQuoteAttachmentByFileNameError = Error;

export type GetQuoteHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Quote
     */
    QuoteID: string;
  };
};

export type GetQuoteHistoryResponse = HistoryRecords;

export type GetQuoteHistoryError = unknown;

export type CreateQuoteHistoryData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Quote
     */
    QuoteID: string;
  };
};

export type CreateQuoteHistoryResponse = HistoryRecords;

export type CreateQuoteHistoryError = Error;

export type GetQuoteAsPdfData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for an Quote
     */
    QuoteID: string;
  };
};

export type GetQuoteAsPdfResponse = Blob | File;

export type GetQuoteAsPdfError = unknown;

export type GetReceiptsData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetReceiptsResponse = Receipts;

export type GetReceiptsError = unknown;

export type CreateReceiptData = {
  /**
   * Receipts with an array of Receipt object in body of request
   */
  body: Receipts;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type CreateReceiptResponse = Receipts;

export type CreateReceiptError = Error;

export type GetReceiptData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Receipt
     */
    ReceiptID: string;
  };
  query?: {
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type GetReceiptResponse = Receipts;

export type GetReceiptError = unknown;

export type UpdateReceiptData = {
  body: Receipts;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Receipt
     */
    ReceiptID: string;
  };
  query?: {
    /**
     * e.g. unitdp=4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts
     */
    unitdp?: number;
  };
};

export type UpdateReceiptResponse = Receipts;

export type UpdateReceiptError = Error;

export type GetReceiptAttachmentsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Receipt
     */
    ReceiptID: string;
  };
};

export type GetReceiptAttachmentsResponse = Attachments;

export type GetReceiptAttachmentsError = unknown;

export type GetReceiptAttachmentByIdData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Attachment
     */
    AttachmentID: string;
    /**
     * Unique identifier for a Receipt
     */
    ReceiptID: string;
  };
};

export type GetReceiptAttachmentByIdResponse = Blob | File;

export type GetReceiptAttachmentByIdError = unknown;

export type GetReceiptAttachmentByFileNameData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * The name of the file being attached to the Receipt
     */
    FileName: string;
    /**
     * Unique identifier for a Receipt
     */
    ReceiptID: string;
  };
};

export type GetReceiptAttachmentByFileNameResponse = Blob | File;

export type GetReceiptAttachmentByFileNameError = unknown;

export type UpdateReceiptAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * The name of the file being attached to the Receipt
     */
    FileName: string;
    /**
     * Unique identifier for a Receipt
     */
    ReceiptID: string;
  };
};

export type UpdateReceiptAttachmentByFileNameResponse = Attachments;

export type UpdateReceiptAttachmentByFileNameError = Error;

export type CreateReceiptAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * The name of the file being attached to the Receipt
     */
    FileName: string;
    /**
     * Unique identifier for a Receipt
     */
    ReceiptID: string;
  };
};

export type CreateReceiptAttachmentByFileNameResponse = Attachments;

export type CreateReceiptAttachmentByFileNameError = Error;

export type GetReceiptHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Receipt
     */
    ReceiptID: string;
  };
};

export type GetReceiptHistoryResponse = HistoryRecords;

export type GetReceiptHistoryError = unknown;

export type CreateReceiptHistoryData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Receipt
     */
    ReceiptID: string;
  };
};

export type CreateReceiptHistoryResponse = HistoryRecords;

export type CreateReceiptHistoryError = Error;

export type GetRepeatingInvoicesData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetRepeatingInvoicesResponse = RepeatingInvoices;

export type GetRepeatingInvoicesError = unknown;

export type GetRepeatingInvoiceData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Repeating Invoice
     */
    RepeatingInvoiceID: string;
  };
};

export type GetRepeatingInvoiceResponse = RepeatingInvoices;

export type GetRepeatingInvoiceError = unknown;

export type GetRepeatingInvoiceAttachmentsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Repeating Invoice
     */
    RepeatingInvoiceID: string;
  };
};

export type GetRepeatingInvoiceAttachmentsResponse = Attachments;

export type GetRepeatingInvoiceAttachmentsError = unknown;

export type GetRepeatingInvoiceAttachmentByIdData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Attachment
     */
    AttachmentID: string;
    /**
     * Unique identifier for a Repeating Invoice
     */
    RepeatingInvoiceID: string;
  };
};

export type GetRepeatingInvoiceAttachmentByIdResponse = Blob | File;

export type GetRepeatingInvoiceAttachmentByIdError = unknown;

export type GetRepeatingInvoiceAttachmentByFileNameData = {
  headers: {
    /**
     * The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf
     */
    contentType: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * The name of the file being attached to a Repeating Invoice
     */
    FileName: string;
    /**
     * Unique identifier for a Repeating Invoice
     */
    RepeatingInvoiceID: string;
  };
};

export type GetRepeatingInvoiceAttachmentByFileNameResponse = Blob | File;

export type GetRepeatingInvoiceAttachmentByFileNameError = unknown;

export type UpdateRepeatingInvoiceAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * The name of the file being attached to a Repeating Invoice
     */
    FileName: string;
    /**
     * Unique identifier for a Repeating Invoice
     */
    RepeatingInvoiceID: string;
  };
};

export type UpdateRepeatingInvoiceAttachmentByFileNameResponse = Attachments;

export type UpdateRepeatingInvoiceAttachmentByFileNameError = Error;

export type CreateRepeatingInvoiceAttachmentByFileNameData = {
  /**
   * Byte array of file in body of request
   */
  body: string;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * The name of the file being attached to a Repeating Invoice
     */
    FileName: string;
    /**
     * Unique identifier for a Repeating Invoice
     */
    RepeatingInvoiceID: string;
  };
};

export type CreateRepeatingInvoiceAttachmentByFileNameResponse = Attachments;

export type CreateRepeatingInvoiceAttachmentByFileNameError = Error;

export type GetRepeatingInvoiceHistoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Repeating Invoice
     */
    RepeatingInvoiceID: string;
  };
};

export type GetRepeatingInvoiceHistoryResponse = HistoryRecords;

export type GetRepeatingInvoiceHistoryError = unknown;

export type CreateRepeatingInvoiceHistoryData = {
  /**
   * HistoryRecords containing an array of HistoryRecord objects in body of request
   */
  body: HistoryRecords;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Repeating Invoice
     */
    RepeatingInvoiceID: string;
  };
};

export type CreateRepeatingInvoiceHistoryResponse = HistoryRecords;

export type CreateRepeatingInvoiceHistoryError = Error;

export type GetReportBaSorGstListData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type GetReportBaSorGstListResponse = ReportWithRows;

export type GetReportBaSorGstListError = unknown;

export type GetReportAgedPayablesByContactData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query: {
    /**
     * Unique identifier for a Contact
     */
    contactId: string;
    /**
     * The date of the Aged Payables By Contact report
     */
    date?: string;
    /**
     * The from date of the Aged Payables By Contact report
     */
    fromDate?: string;
    /**
     * The to date of the Aged Payables By Contact report
     */
    toDate?: string;
  };
};

export type GetReportAgedPayablesByContactResponse = ReportWithRows;

export type GetReportAgedPayablesByContactError = unknown;

export type GetReportAgedReceivablesByContactData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query: {
    /**
     * Unique identifier for a Contact
     */
    contactId: string;
    /**
     * The date of the Aged Receivables By Contact report
     */
    date?: string;
    /**
     * The from date of the Aged Receivables By Contact report
     */
    fromDate?: string;
    /**
     * The to date of the Aged Receivables By Contact report
     */
    toDate?: string;
  };
};

export type GetReportAgedReceivablesByContactResponse = ReportWithRows;

export type GetReportAgedReceivablesByContactError = unknown;

export type GetReportBalanceSheetData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * The date of the Balance Sheet report
     */
    date?: string;
    /**
     * return a cash basis for the Balance Sheet report
     */
    paymentsOnly?: boolean;
    /**
     * The number of periods for the Balance Sheet report
     */
    periods?: number;
    /**
     * The standard layout boolean for the Balance Sheet report
     */
    standardLayout?: boolean;
    /**
     * The period size to compare to (MONTH, QUARTER, YEAR)
     */
    timeframe?: 'MONTH' | 'QUARTER' | 'YEAR';
    /**
     * The tracking option 1 for the Balance Sheet report
     */
    trackingOptionID1?: string;
    /**
     * The tracking option 2 for the Balance Sheet report
     */
    trackingOptionID2?: string;
  };
};

export type GetReportBalanceSheetResponse = ReportWithRows;

export type GetReportBalanceSheetError = unknown;

export type GetReportBankSummaryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * The from date for the Bank Summary report e.g. 2018-03-31
     */
    fromDate?: string;
    /**
     * The to date for the Bank Summary report e.g. 2018-03-31
     */
    toDate?: string;
  };
};

export type GetReportBankSummaryResponse = ReportWithRows;

export type GetReportBankSummaryError = unknown;

export type GetReportBudgetSummaryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * The date for the Bank Summary report e.g. 2018-03-31
     */
    date?: string;
    /**
     * The number of periods to compare (integer between 1 and 12)
     */
    period?: number;
    /**
     * The period size to compare to (1=month, 3=quarter, 12=year)
     */
    timeframe?: number;
  };
};

export type GetReportBudgetSummaryResponse = ReportWithRows;

export type GetReportBudgetSummaryError = unknown;

export type GetReportExecutiveSummaryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * The date for the Bank Summary report e.g. 2018-03-31
     */
    date?: string;
  };
};

export type GetReportExecutiveSummaryResponse = ReportWithRows;

export type GetReportExecutiveSummaryError = unknown;

export type GetReportProfitAndLossData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * The from date for the ProfitAndLoss report e.g. 2018-03-31
     */
    fromDate?: string;
    /**
     * Return cash only basis for the ProfitAndLoss report
     */
    paymentsOnly?: boolean;
    /**
     * The number of periods to compare (integer between 1 and 12)
     */
    periods?: number;
    /**
     * Return the standard layout for the ProfitAndLoss report
     */
    standardLayout?: boolean;
    /**
     * The period size to compare to (MONTH, QUARTER, YEAR)
     */
    timeframe?: 'MONTH' | 'QUARTER' | 'YEAR';
    /**
     * The to date for the ProfitAndLoss report e.g. 2018-03-31
     */
    toDate?: string;
    /**
     * The trackingCategory 1 for the ProfitAndLoss report
     */
    trackingCategoryID?: string;
    /**
     * The trackingCategory 2 for the ProfitAndLoss report
     */
    trackingCategoryID2?: string;
    /**
     * The tracking option 1 for the ProfitAndLoss report
     */
    trackingOptionID?: string;
    /**
     * The tracking option 2 for the ProfitAndLoss report
     */
    trackingOptionID2?: string;
  };
};

export type GetReportProfitAndLossResponse = ReportWithRows;

export type GetReportProfitAndLossError = unknown;

export type GetReportTenNinetyNineData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * The year of the 1099 report
     */
    reportYear?: string;
  };
};

export type GetReportTenNinetyNineResponse = Reports;

export type GetReportTenNinetyNineError = unknown;

export type GetReportTrialBalanceData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * The date for the Trial Balance report e.g. 2018-03-31
     */
    date?: string;
    /**
     * Return cash only basis for the Trial Balance report
     */
    paymentsOnly?: boolean;
  };
};

export type GetReportTrialBalanceResponse = ReportWithRows;

export type GetReportTrialBalanceError = unknown;

export type GetReportBaSorGstData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a Report
     */
    ReportID: string;
  };
};

export type GetReportBaSorGstResponse = ReportWithRows;

export type GetReportBaSorGstError = unknown;

export type PostSetupData = {
  /**
   * Object including an accounts array, a conversion balances array and a conversion date object in body of request
   */
  body: Setup;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type PostSetupResponse = ImportSummaryObject;

export type PostSetupError = unknown;

export type GetTaxRatesData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Filter by tax type
     */
    TaxType?: string;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetTaxRatesResponse = TaxRates;

export type GetTaxRatesError = unknown;

export type UpdateTaxRateData = {
  body: TaxRates;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type UpdateTaxRateResponse = TaxRates;

export type UpdateTaxRateError = Error;

export type CreateTaxRatesData = {
  /**
   * TaxRates array with TaxRate object in body of request
   */
  body: TaxRates;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type CreateTaxRatesResponse = TaxRates;

export type CreateTaxRatesError = Error;

export type GetTrackingCategoriesData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * e.g. includeArchived=true - Categories and options with a status of ARCHIVED will be included in the response
     */
    includeArchived?: boolean;
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetTrackingCategoriesResponse = TrackingCategories;

export type GetTrackingCategoriesError = unknown;

export type CreateTrackingCategoryData = {
  /**
   * TrackingCategory object in body of request
   */
  body: TrackingCategory;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
};

export type CreateTrackingCategoryResponse = TrackingCategories;

export type CreateTrackingCategoryError = Error;

export type DeleteTrackingCategoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a TrackingCategory
     */
    TrackingCategoryID: string;
  };
};

export type DeleteTrackingCategoryResponse = TrackingCategories;

export type DeleteTrackingCategoryError = Error;

export type GetTrackingCategoryData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a TrackingCategory
     */
    TrackingCategoryID: string;
  };
};

export type GetTrackingCategoryResponse = TrackingCategories;

export type GetTrackingCategoryError = unknown;

export type UpdateTrackingCategoryData = {
  body: TrackingCategory;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a TrackingCategory
     */
    TrackingCategoryID: string;
  };
};

export type UpdateTrackingCategoryResponse = TrackingCategories;

export type UpdateTrackingCategoryError = Error;

export type CreateTrackingOptionsData = {
  /**
   * TrackingOption object in body of request
   */
  body: TrackingOption;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a TrackingCategory
     */
    TrackingCategoryID: string;
  };
};

export type CreateTrackingOptionsResponse = TrackingOptions;

export type CreateTrackingOptionsError = Error;

export type DeleteTrackingOptionsData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a TrackingCategory
     */
    TrackingCategoryID: string;
    /**
     * Unique identifier for a Tracking Option
     */
    TrackingOptionID: string;
  };
};

export type DeleteTrackingOptionsResponse = TrackingOptions;

export type DeleteTrackingOptionsError = Error;

export type UpdateTrackingOptionsData = {
  body: TrackingOption;
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a TrackingCategory
     */
    TrackingCategoryID: string;
    /**
     * Unique identifier for a Tracking Option
     */
    TrackingOptionID: string;
  };
};

export type UpdateTrackingOptionsResponse = TrackingOptions;

export type UpdateTrackingOptionsError = Error;

export type GetUsersData = {
  headers: {
    /**
     * Only records created or modified since this timestamp will be returned
     */
    'If-Modified-Since'?: string;
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  query?: {
    /**
     * Order by an any element
     */
    order?: string;
    /**
     * Filter by an any element
     */
    where?: string;
  };
};

export type GetUsersResponse = Users;

export type GetUsersError = unknown;

export type GetUserData = {
  headers: {
    /**
     * Xero identifier for Tenant
     */
    'xero-tenant-id': string;
  };
  path: {
    /**
     * Unique identifier for a User
     */
    UserID: string;
  };
};

export type GetUserResponse = Users;

export type GetUserError = unknown;
