// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  GetAccountsData,
  GetAccountsError,
  GetAccountsResponse,
  CreateAccountData,
  CreateAccountError,
  CreateAccountResponse,
  DeleteAccountData,
  DeleteAccountError,
  DeleteAccountResponse,
  GetAccountData,
  GetAccountError,
  GetAccountResponse,
  UpdateAccountData,
  UpdateAccountError,
  UpdateAccountResponse,
  GetAccountAttachmentsData,
  GetAccountAttachmentsError,
  GetAccountAttachmentsResponse,
  GetAccountAttachmentByIdData,
  GetAccountAttachmentByIdError,
  GetAccountAttachmentByIdResponse,
  GetAccountAttachmentByFileNameData,
  GetAccountAttachmentByFileNameError,
  GetAccountAttachmentByFileNameResponse,
  UpdateAccountAttachmentByFileNameData,
  UpdateAccountAttachmentByFileNameError,
  UpdateAccountAttachmentByFileNameResponse,
  CreateAccountAttachmentByFileNameData,
  CreateAccountAttachmentByFileNameError,
  CreateAccountAttachmentByFileNameResponse,
  GetBankTransactionsData,
  GetBankTransactionsError,
  GetBankTransactionsResponse,
  UpdateOrCreateBankTransactionsData,
  UpdateOrCreateBankTransactionsError,
  UpdateOrCreateBankTransactionsResponse,
  CreateBankTransactionsData,
  CreateBankTransactionsError,
  CreateBankTransactionsResponse,
  GetBankTransactionData,
  GetBankTransactionError,
  GetBankTransactionResponse,
  UpdateBankTransactionData,
  UpdateBankTransactionError,
  UpdateBankTransactionResponse,
  GetBankTransactionAttachmentsData,
  GetBankTransactionAttachmentsError,
  GetBankTransactionAttachmentsResponse,
  GetBankTransactionAttachmentByIdData,
  GetBankTransactionAttachmentByIdError,
  GetBankTransactionAttachmentByIdResponse,
  GetBankTransactionAttachmentByFileNameData,
  GetBankTransactionAttachmentByFileNameError,
  GetBankTransactionAttachmentByFileNameResponse,
  UpdateBankTransactionAttachmentByFileNameData,
  UpdateBankTransactionAttachmentByFileNameError,
  UpdateBankTransactionAttachmentByFileNameResponse,
  CreateBankTransactionAttachmentByFileNameData,
  CreateBankTransactionAttachmentByFileNameError,
  CreateBankTransactionAttachmentByFileNameResponse,
  GetBankTransactionsHistoryData,
  GetBankTransactionsHistoryError,
  GetBankTransactionsHistoryResponse,
  CreateBankTransactionHistoryRecordData,
  CreateBankTransactionHistoryRecordError,
  CreateBankTransactionHistoryRecordResponse,
  GetBankTransfersData,
  GetBankTransfersError,
  GetBankTransfersResponse,
  CreateBankTransferData,
  CreateBankTransferError,
  CreateBankTransferResponse,
  GetBankTransferData,
  GetBankTransferError,
  GetBankTransferResponse,
  GetBankTransferAttachmentsData,
  GetBankTransferAttachmentsError,
  GetBankTransferAttachmentsResponse,
  GetBankTransferAttachmentByIdData,
  GetBankTransferAttachmentByIdError,
  GetBankTransferAttachmentByIdResponse,
  GetBankTransferAttachmentByFileNameData,
  GetBankTransferAttachmentByFileNameError,
  GetBankTransferAttachmentByFileNameResponse,
  UpdateBankTransferAttachmentByFileNameData,
  UpdateBankTransferAttachmentByFileNameError,
  UpdateBankTransferAttachmentByFileNameResponse,
  CreateBankTransferAttachmentByFileNameData,
  CreateBankTransferAttachmentByFileNameError,
  CreateBankTransferAttachmentByFileNameResponse,
  GetBankTransferHistoryData,
  GetBankTransferHistoryError,
  GetBankTransferHistoryResponse,
  CreateBankTransferHistoryRecordData,
  CreateBankTransferHistoryRecordError,
  CreateBankTransferHistoryRecordResponse,
  GetBatchPaymentsData,
  GetBatchPaymentsError,
  GetBatchPaymentsResponse,
  CreateBatchPaymentData,
  CreateBatchPaymentError,
  CreateBatchPaymentResponse,
  GetBatchPaymentHistoryData,
  GetBatchPaymentHistoryError,
  GetBatchPaymentHistoryResponse,
  CreateBatchPaymentHistoryRecordData,
  CreateBatchPaymentHistoryRecordError,
  CreateBatchPaymentHistoryRecordResponse,
  GetBrandingThemesData,
  GetBrandingThemesError,
  GetBrandingThemesResponse,
  GetBrandingThemeData,
  GetBrandingThemeError,
  GetBrandingThemeResponse,
  GetBrandingThemePaymentServicesData,
  GetBrandingThemePaymentServicesError,
  GetBrandingThemePaymentServicesResponse,
  CreateBrandingThemePaymentServicesData,
  CreateBrandingThemePaymentServicesError,
  CreateBrandingThemePaymentServicesResponse,
  GetContactGroupsData,
  GetContactGroupsError,
  GetContactGroupsResponse,
  CreateContactGroupData,
  CreateContactGroupError,
  CreateContactGroupResponse,
  GetContactGroupData,
  GetContactGroupError,
  GetContactGroupResponse,
  UpdateContactGroupData,
  UpdateContactGroupError,
  UpdateContactGroupResponse,
  DeleteContactGroupContactsData,
  DeleteContactGroupContactsError,
  DeleteContactGroupContactsResponse,
  CreateContactGroupContactsData,
  CreateContactGroupContactsError,
  CreateContactGroupContactsResponse,
  DeleteContactGroupContactData,
  DeleteContactGroupContactError,
  DeleteContactGroupContactResponse,
  GetContactsData,
  GetContactsError,
  GetContactsResponse,
  UpdateOrCreateContactsData,
  UpdateOrCreateContactsError,
  UpdateOrCreateContactsResponse,
  CreateContactsData,
  CreateContactsError,
  CreateContactsResponse,
  GetContactData,
  GetContactError,
  GetContactResponse,
  UpdateContactData,
  UpdateContactError,
  UpdateContactResponse,
  GetContactAttachmentsData,
  GetContactAttachmentsError,
  GetContactAttachmentsResponse,
  GetContactAttachmentByIdData,
  GetContactAttachmentByIdError,
  GetContactAttachmentByIdResponse,
  GetContactAttachmentByFileNameData,
  GetContactAttachmentByFileNameError,
  GetContactAttachmentByFileNameResponse,
  UpdateContactAttachmentByFileNameData,
  UpdateContactAttachmentByFileNameError,
  UpdateContactAttachmentByFileNameResponse,
  CreateContactAttachmentByFileNameData,
  CreateContactAttachmentByFileNameError,
  CreateContactAttachmentByFileNameResponse,
  GetContactCisSettingsData,
  GetContactCisSettingsError,
  GetContactCisSettingsResponse,
  GetContactHistoryData,
  GetContactHistoryError,
  GetContactHistoryResponse,
  CreateContactHistoryData,
  CreateContactHistoryError,
  CreateContactHistoryResponse,
  GetContactByContactNumberData,
  GetContactByContactNumberError,
  GetContactByContactNumberResponse,
  GetCreditNotesData,
  GetCreditNotesError,
  GetCreditNotesResponse,
  UpdateOrCreateCreditNotesData,
  UpdateOrCreateCreditNotesError,
  UpdateOrCreateCreditNotesResponse,
  CreateCreditNotesData,
  CreateCreditNotesError,
  CreateCreditNotesResponse,
  GetCreditNoteData,
  GetCreditNoteError,
  GetCreditNoteResponse,
  UpdateCreditNoteData,
  UpdateCreditNoteError,
  UpdateCreditNoteResponse,
  CreateCreditNoteAllocationData,
  CreateCreditNoteAllocationError,
  CreateCreditNoteAllocationResponse,
  GetCreditNoteAttachmentsData,
  GetCreditNoteAttachmentsError,
  GetCreditNoteAttachmentsResponse,
  GetCreditNoteAttachmentByIdData,
  GetCreditNoteAttachmentByIdError,
  GetCreditNoteAttachmentByIdResponse,
  GetCreditNoteAttachmentByFileNameData,
  GetCreditNoteAttachmentByFileNameError,
  GetCreditNoteAttachmentByFileNameResponse,
  UpdateCreditNoteAttachmentByFileNameData,
  UpdateCreditNoteAttachmentByFileNameError,
  UpdateCreditNoteAttachmentByFileNameResponse,
  CreateCreditNoteAttachmentByFileNameData,
  CreateCreditNoteAttachmentByFileNameError,
  CreateCreditNoteAttachmentByFileNameResponse,
  GetCreditNoteHistoryData,
  GetCreditNoteHistoryError,
  GetCreditNoteHistoryResponse,
  CreateCreditNoteHistoryData,
  CreateCreditNoteHistoryError,
  CreateCreditNoteHistoryResponse,
  GetCreditNoteAsPdfData,
  GetCreditNoteAsPdfError,
  GetCreditNoteAsPdfResponse,
  GetCurrenciesData,
  GetCurrenciesError,
  GetCurrenciesResponse,
  CreateCurrencyData,
  CreateCurrencyError,
  CreateCurrencyResponse,
  GetEmployeesData,
  GetEmployeesError,
  GetEmployeesResponse,
  UpdateOrCreateEmployeesData,
  UpdateOrCreateEmployeesError,
  UpdateOrCreateEmployeesResponse,
  CreateEmployeesData,
  CreateEmployeesError,
  CreateEmployeesResponse,
  GetEmployeeData,
  GetEmployeeError,
  GetEmployeeResponse,
  GetExpenseClaimsData,
  GetExpenseClaimsError,
  GetExpenseClaimsResponse,
  CreateExpenseClaimsData,
  CreateExpenseClaimsError,
  CreateExpenseClaimsResponse,
  GetExpenseClaimData,
  GetExpenseClaimError,
  GetExpenseClaimResponse,
  UpdateExpenseClaimData,
  UpdateExpenseClaimError,
  UpdateExpenseClaimResponse,
  GetExpenseClaimHistoryData,
  GetExpenseClaimHistoryError,
  GetExpenseClaimHistoryResponse,
  CreateExpenseClaimHistoryData,
  CreateExpenseClaimHistoryError,
  CreateExpenseClaimHistoryResponse,
  GetInvoiceRemindersData,
  GetInvoiceRemindersError,
  GetInvoiceRemindersResponse,
  GetInvoicesData,
  GetInvoicesError,
  GetInvoicesResponse,
  UpdateOrCreateInvoicesData,
  UpdateOrCreateInvoicesError,
  UpdateOrCreateInvoicesResponse,
  CreateInvoicesData,
  CreateInvoicesError,
  CreateInvoicesResponse,
  GetInvoiceData,
  GetInvoiceError,
  GetInvoiceResponse,
  UpdateInvoiceData,
  UpdateInvoiceError,
  UpdateInvoiceResponse,
  GetInvoiceAttachmentsData,
  GetInvoiceAttachmentsError,
  GetInvoiceAttachmentsResponse,
  GetInvoiceAttachmentByIdData,
  GetInvoiceAttachmentByIdError,
  GetInvoiceAttachmentByIdResponse,
  GetInvoiceAttachmentByFileNameData,
  GetInvoiceAttachmentByFileNameError,
  GetInvoiceAttachmentByFileNameResponse,
  UpdateInvoiceAttachmentByFileNameData,
  UpdateInvoiceAttachmentByFileNameError,
  UpdateInvoiceAttachmentByFileNameResponse,
  CreateInvoiceAttachmentByFileNameData,
  CreateInvoiceAttachmentByFileNameError,
  CreateInvoiceAttachmentByFileNameResponse,
  EmailInvoiceData,
  EmailInvoiceError,
  EmailInvoiceResponse,
  GetInvoiceHistoryData,
  GetInvoiceHistoryError,
  GetInvoiceHistoryResponse,
  CreateInvoiceHistoryData,
  CreateInvoiceHistoryError,
  CreateInvoiceHistoryResponse,
  GetOnlineInvoiceData,
  GetOnlineInvoiceError,
  GetOnlineInvoiceResponse,
  GetInvoiceAsPdfData,
  GetInvoiceAsPdfError,
  GetInvoiceAsPdfResponse,
  GetItemsData,
  GetItemsError,
  GetItemsResponse,
  UpdateOrCreateItemsData,
  UpdateOrCreateItemsError,
  UpdateOrCreateItemsResponse,
  CreateItemsData,
  CreateItemsError,
  CreateItemsResponse,
  DeleteItemData,
  DeleteItemError,
  DeleteItemResponse,
  GetItemData,
  GetItemError,
  GetItemResponse,
  UpdateItemData,
  UpdateItemError,
  UpdateItemResponse,
  GetItemHistoryData,
  GetItemHistoryError,
  GetItemHistoryResponse,
  CreateItemHistoryData,
  CreateItemHistoryError,
  CreateItemHistoryResponse,
  GetJournalsData,
  GetJournalsError,
  GetJournalsResponse,
  GetJournalData,
  GetJournalError,
  GetJournalResponse,
  GetLinkedTransactionsData,
  GetLinkedTransactionsError,
  GetLinkedTransactionsResponse,
  CreateLinkedTransactionData,
  CreateLinkedTransactionError,
  CreateLinkedTransactionResponse,
  DeleteLinkedTransactionData,
  DeleteLinkedTransactionError,
  DeleteLinkedTransactionResponse,
  GetLinkedTransactionData,
  GetLinkedTransactionError,
  GetLinkedTransactionResponse,
  UpdateLinkedTransactionData,
  UpdateLinkedTransactionError,
  UpdateLinkedTransactionResponse,
  GetManualJournalsData,
  GetManualJournalsError,
  GetManualJournalsResponse,
  UpdateOrCreateManualJournalsData,
  UpdateOrCreateManualJournalsError,
  UpdateOrCreateManualJournalsResponse,
  CreateManualJournalsData,
  CreateManualJournalsError,
  CreateManualJournalsResponse,
  GetManualJournalData,
  GetManualJournalError,
  GetManualJournalResponse,
  UpdateManualJournalData,
  UpdateManualJournalError,
  UpdateManualJournalResponse,
  GetManualJournalAttachmentsData,
  GetManualJournalAttachmentsError,
  GetManualJournalAttachmentsResponse,
  GetManualJournalAttachmentByIdData,
  GetManualJournalAttachmentByIdError,
  GetManualJournalAttachmentByIdResponse,
  GetManualJournalAttachmentByFileNameData,
  GetManualJournalAttachmentByFileNameError,
  GetManualJournalAttachmentByFileNameResponse,
  UpdateManualJournalAttachmentByFileNameData,
  UpdateManualJournalAttachmentByFileNameError,
  UpdateManualJournalAttachmentByFileNameResponse,
  CreateManualJournalAttachmentByFileNameData,
  CreateManualJournalAttachmentByFileNameError,
  CreateManualJournalAttachmentByFileNameResponse,
  GetManualJournalsHistoryData,
  GetManualJournalsHistoryError,
  GetManualJournalsHistoryResponse,
  CreateManualJournalHistoryRecordData,
  CreateManualJournalHistoryRecordError,
  CreateManualJournalHistoryRecordResponse,
  GetOrganisationsData,
  GetOrganisationsError,
  GetOrganisationsResponse,
  GetOrganisationActionsData,
  GetOrganisationActionsError,
  GetOrganisationActionsResponse,
  GetOrganisationCisSettingsData,
  GetOrganisationCisSettingsError,
  GetOrganisationCisSettingsResponse,
  GetOverpaymentsData,
  GetOverpaymentsError,
  GetOverpaymentsResponse,
  GetOverpaymentData,
  GetOverpaymentError,
  GetOverpaymentResponse,
  CreateOverpaymentAllocationsData,
  CreateOverpaymentAllocationsError,
  CreateOverpaymentAllocationsResponse,
  GetOverpaymentHistoryData,
  GetOverpaymentHistoryError,
  GetOverpaymentHistoryResponse,
  CreateOverpaymentHistoryData,
  CreateOverpaymentHistoryError,
  CreateOverpaymentHistoryResponse,
  GetPaymentServicesData,
  GetPaymentServicesError,
  GetPaymentServicesResponse,
  CreatePaymentServiceData,
  CreatePaymentServiceError,
  CreatePaymentServiceResponse,
  GetPaymentsData,
  GetPaymentsError,
  GetPaymentsResponse,
  CreatePaymentData,
  CreatePaymentError,
  CreatePaymentResponse,
  CreatePaymentsData,
  CreatePaymentsError,
  CreatePaymentsResponse,
  GetPaymentData,
  GetPaymentError,
  GetPaymentResponse,
  DeletePaymentData,
  DeletePaymentError,
  DeletePaymentResponse,
  GetPaymentHistoryData,
  GetPaymentHistoryError,
  GetPaymentHistoryResponse,
  CreatePaymentHistoryData,
  CreatePaymentHistoryError,
  CreatePaymentHistoryResponse,
  GetPrepaymentsData,
  GetPrepaymentsError,
  GetPrepaymentsResponse,
  GetPrepaymentData,
  GetPrepaymentError,
  GetPrepaymentResponse,
  CreatePrepaymentAllocationsData,
  CreatePrepaymentAllocationsError,
  CreatePrepaymentAllocationsResponse,
  GetPrepaymentHistoryData,
  GetPrepaymentHistoryError,
  GetPrepaymentHistoryResponse,
  CreatePrepaymentHistoryData,
  CreatePrepaymentHistoryError,
  CreatePrepaymentHistoryResponse,
  GetPurchaseOrdersData,
  GetPurchaseOrdersError,
  GetPurchaseOrdersResponse,
  UpdateOrCreatePurchaseOrdersData,
  UpdateOrCreatePurchaseOrdersError,
  UpdateOrCreatePurchaseOrdersResponse,
  CreatePurchaseOrdersData,
  CreatePurchaseOrdersError,
  CreatePurchaseOrdersResponse,
  GetPurchaseOrderData,
  GetPurchaseOrderError,
  GetPurchaseOrderResponse,
  UpdatePurchaseOrderData,
  UpdatePurchaseOrderError,
  UpdatePurchaseOrderResponse,
  GetPurchaseOrderAttachmentsData,
  GetPurchaseOrderAttachmentsError,
  GetPurchaseOrderAttachmentsResponse,
  GetPurchaseOrderAttachmentByIdData,
  GetPurchaseOrderAttachmentByIdError,
  GetPurchaseOrderAttachmentByIdResponse,
  GetPurchaseOrderAttachmentByFileNameData,
  GetPurchaseOrderAttachmentByFileNameError,
  GetPurchaseOrderAttachmentByFileNameResponse,
  UpdatePurchaseOrderAttachmentByFileNameData,
  UpdatePurchaseOrderAttachmentByFileNameError,
  UpdatePurchaseOrderAttachmentByFileNameResponse,
  CreatePurchaseOrderAttachmentByFileNameData,
  CreatePurchaseOrderAttachmentByFileNameError,
  CreatePurchaseOrderAttachmentByFileNameResponse,
  GetPurchaseOrderHistoryData,
  GetPurchaseOrderHistoryError,
  GetPurchaseOrderHistoryResponse,
  CreatePurchaseOrderHistoryData,
  CreatePurchaseOrderHistoryError,
  CreatePurchaseOrderHistoryResponse,
  GetPurchaseOrderAsPdfData,
  GetPurchaseOrderAsPdfError,
  GetPurchaseOrderAsPdfResponse,
  GetPurchaseOrderByNumberData,
  GetPurchaseOrderByNumberError,
  GetPurchaseOrderByNumberResponse,
  GetQuotesData,
  GetQuotesError,
  GetQuotesResponse,
  UpdateOrCreateQuotesData,
  UpdateOrCreateQuotesError,
  UpdateOrCreateQuotesResponse,
  CreateQuotesData,
  CreateQuotesError,
  CreateQuotesResponse,
  GetQuoteData,
  GetQuoteError,
  GetQuoteResponse,
  UpdateQuoteData,
  UpdateQuoteError,
  UpdateQuoteResponse,
  GetQuoteAttachmentsData,
  GetQuoteAttachmentsError,
  GetQuoteAttachmentsResponse,
  GetQuoteAttachmentByIdData,
  GetQuoteAttachmentByIdError,
  GetQuoteAttachmentByIdResponse,
  GetQuoteAttachmentByFileNameData,
  GetQuoteAttachmentByFileNameError,
  GetQuoteAttachmentByFileNameResponse,
  UpdateQuoteAttachmentByFileNameData,
  UpdateQuoteAttachmentByFileNameError,
  UpdateQuoteAttachmentByFileNameResponse,
  CreateQuoteAttachmentByFileNameData,
  CreateQuoteAttachmentByFileNameError,
  CreateQuoteAttachmentByFileNameResponse,
  GetQuoteHistoryData,
  GetQuoteHistoryError,
  GetQuoteHistoryResponse,
  CreateQuoteHistoryData,
  CreateQuoteHistoryError,
  CreateQuoteHistoryResponse,
  GetQuoteAsPdfData,
  GetQuoteAsPdfError,
  GetQuoteAsPdfResponse,
  GetReceiptsData,
  GetReceiptsError,
  GetReceiptsResponse,
  CreateReceiptData,
  CreateReceiptError,
  CreateReceiptResponse,
  GetReceiptData,
  GetReceiptError,
  GetReceiptResponse,
  UpdateReceiptData,
  UpdateReceiptError,
  UpdateReceiptResponse,
  GetReceiptAttachmentsData,
  GetReceiptAttachmentsError,
  GetReceiptAttachmentsResponse,
  GetReceiptAttachmentByIdData,
  GetReceiptAttachmentByIdError,
  GetReceiptAttachmentByIdResponse,
  GetReceiptAttachmentByFileNameData,
  GetReceiptAttachmentByFileNameError,
  GetReceiptAttachmentByFileNameResponse,
  UpdateReceiptAttachmentByFileNameData,
  UpdateReceiptAttachmentByFileNameError,
  UpdateReceiptAttachmentByFileNameResponse,
  CreateReceiptAttachmentByFileNameData,
  CreateReceiptAttachmentByFileNameError,
  CreateReceiptAttachmentByFileNameResponse,
  GetReceiptHistoryData,
  GetReceiptHistoryError,
  GetReceiptHistoryResponse,
  CreateReceiptHistoryData,
  CreateReceiptHistoryError,
  CreateReceiptHistoryResponse,
  GetRepeatingInvoicesData,
  GetRepeatingInvoicesError,
  GetRepeatingInvoicesResponse,
  GetRepeatingInvoiceData,
  GetRepeatingInvoiceError,
  GetRepeatingInvoiceResponse,
  GetRepeatingInvoiceAttachmentsData,
  GetRepeatingInvoiceAttachmentsError,
  GetRepeatingInvoiceAttachmentsResponse,
  GetRepeatingInvoiceAttachmentByIdData,
  GetRepeatingInvoiceAttachmentByIdError,
  GetRepeatingInvoiceAttachmentByIdResponse,
  GetRepeatingInvoiceAttachmentByFileNameData,
  GetRepeatingInvoiceAttachmentByFileNameError,
  GetRepeatingInvoiceAttachmentByFileNameResponse,
  UpdateRepeatingInvoiceAttachmentByFileNameData,
  UpdateRepeatingInvoiceAttachmentByFileNameError,
  UpdateRepeatingInvoiceAttachmentByFileNameResponse,
  CreateRepeatingInvoiceAttachmentByFileNameData,
  CreateRepeatingInvoiceAttachmentByFileNameError,
  CreateRepeatingInvoiceAttachmentByFileNameResponse,
  GetRepeatingInvoiceHistoryData,
  GetRepeatingInvoiceHistoryError,
  GetRepeatingInvoiceHistoryResponse,
  CreateRepeatingInvoiceHistoryData,
  CreateRepeatingInvoiceHistoryError,
  CreateRepeatingInvoiceHistoryResponse,
  GetReportBaSorGstListData,
  GetReportBaSorGstListError,
  GetReportBaSorGstListResponse,
  GetReportAgedPayablesByContactData,
  GetReportAgedPayablesByContactError,
  GetReportAgedPayablesByContactResponse,
  GetReportAgedReceivablesByContactData,
  GetReportAgedReceivablesByContactError,
  GetReportAgedReceivablesByContactResponse,
  GetReportBalanceSheetData,
  GetReportBalanceSheetError,
  GetReportBalanceSheetResponse,
  GetReportBankSummaryData,
  GetReportBankSummaryError,
  GetReportBankSummaryResponse,
  GetReportBudgetSummaryData,
  GetReportBudgetSummaryError,
  GetReportBudgetSummaryResponse,
  GetReportExecutiveSummaryData,
  GetReportExecutiveSummaryError,
  GetReportExecutiveSummaryResponse,
  GetReportProfitAndLossData,
  GetReportProfitAndLossError,
  GetReportProfitAndLossResponse,
  GetReportTenNinetyNineData,
  GetReportTenNinetyNineError,
  GetReportTenNinetyNineResponse,
  GetReportTrialBalanceData,
  GetReportTrialBalanceError,
  GetReportTrialBalanceResponse,
  GetReportBaSorGstData,
  GetReportBaSorGstError,
  GetReportBaSorGstResponse,
  PostSetupData,
  PostSetupError,
  PostSetupResponse,
  GetTaxRatesData,
  GetTaxRatesError,
  GetTaxRatesResponse,
  UpdateTaxRateData,
  UpdateTaxRateError,
  UpdateTaxRateResponse,
  CreateTaxRatesData,
  CreateTaxRatesError,
  CreateTaxRatesResponse,
  GetTrackingCategoriesData,
  GetTrackingCategoriesError,
  GetTrackingCategoriesResponse,
  CreateTrackingCategoryData,
  CreateTrackingCategoryError,
  CreateTrackingCategoryResponse,
  DeleteTrackingCategoryData,
  DeleteTrackingCategoryError,
  DeleteTrackingCategoryResponse,
  GetTrackingCategoryData,
  GetTrackingCategoryError,
  GetTrackingCategoryResponse,
  UpdateTrackingCategoryData,
  UpdateTrackingCategoryError,
  UpdateTrackingCategoryResponse,
  CreateTrackingOptionsData,
  CreateTrackingOptionsError,
  CreateTrackingOptionsResponse,
  DeleteTrackingOptionsData,
  DeleteTrackingOptionsError,
  DeleteTrackingOptionsResponse,
  UpdateTrackingOptionsData,
  UpdateTrackingOptionsError,
  UpdateTrackingOptionsResponse,
  GetUsersData,
  GetUsersError,
  GetUsersResponse,
  GetUserData,
  GetUserError,
  GetUserResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Retrieves the full chart of accounts
 */
export const getAccounts = <ThrowOnError extends boolean = false>(options: Options<GetAccountsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetAccountsResponse, GetAccountsError, ThrowOnError>({
    ...options,
    url: '/Accounts',
  });
};

/**
 * Creates a new chart of accounts
 */
export const createAccount = <ThrowOnError extends boolean = false>(
  options: Options<CreateAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateAccountResponse, CreateAccountError, ThrowOnError>({
    ...options,
    url: '/Accounts',
  });
};

/**
 * Deletes a chart of accounts
 */
export const deleteAccount = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAccountResponse, DeleteAccountError, ThrowOnError>({
    ...options,
    url: '/Accounts/{AccountID}',
  });
};

/**
 * Retrieves a single chart of accounts by using a unique account Id
 */
export const getAccount = <ThrowOnError extends boolean = false>(options: Options<GetAccountData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetAccountResponse, GetAccountError, ThrowOnError>({
    ...options,
    url: '/Accounts/{AccountID}',
  });
};

/**
 * Updates a chart of accounts
 */
export const updateAccount = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateAccountResponse, UpdateAccountError, ThrowOnError>({
    ...options,
    url: '/Accounts/{AccountID}',
  });
};

/**
 * Retrieves attachments for a specific accounts by using a unique account Id
 */
export const getAccountAttachments = <ThrowOnError extends boolean = false>(
  options: Options<GetAccountAttachmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAccountAttachmentsResponse, GetAccountAttachmentsError, ThrowOnError>({
    ...options,
    url: '/Accounts/{AccountID}/Attachments',
  });
};

/**
 * Retrieves a specific attachment from a specific account using a unique attachment Id
 */
export const getAccountAttachmentById = <ThrowOnError extends boolean = false>(
  options: Options<GetAccountAttachmentByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAccountAttachmentByIdResponse, GetAccountAttachmentByIdError, ThrowOnError>(
    {
      ...options,
      url: '/Accounts/{AccountID}/Attachments/{AttachmentID}',
    },
  );
};

/**
 * Retrieves an attachment for a specific account by filename
 */
export const getAccountAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<GetAccountAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetAccountAttachmentByFileNameResponse,
    GetAccountAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Accounts/{AccountID}/Attachments/{FileName}',
  });
};

/**
 * Updates attachment on a specific account by filename
 */
export const updateAccountAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAccountAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateAccountAttachmentByFileNameResponse,
    UpdateAccountAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Accounts/{AccountID}/Attachments/{FileName}',
  });
};

/**
 * Creates an attachment on a specific account
 */
export const createAccountAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<CreateAccountAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateAccountAttachmentByFileNameResponse,
    CreateAccountAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Accounts/{AccountID}/Attachments/{FileName}',
  });
};

/**
 * Retrieves any spent or received money transactions
 */
export const getBankTransactions = <ThrowOnError extends boolean = false>(
  options: Options<GetBankTransactionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBankTransactionsResponse, GetBankTransactionsError, ThrowOnError>({
    ...options,
    url: '/BankTransactions',
  });
};

/**
 * Updates or creates one or more spent or received money transaction
 */
export const updateOrCreateBankTransactions = <ThrowOnError extends boolean = false>(
  options: Options<UpdateOrCreateBankTransactionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateOrCreateBankTransactionsResponse,
    UpdateOrCreateBankTransactionsError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransactions',
  });
};

/**
 * Creates one or more spent or received money transaction
 */
export const createBankTransactions = <ThrowOnError extends boolean = false>(
  options: Options<CreateBankTransactionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateBankTransactionsResponse, CreateBankTransactionsError, ThrowOnError>({
    ...options,
    url: '/BankTransactions',
  });
};

/**
 * Retrieves a single spent or received money transaction by using a unique bank transaction Id
 */
export const getBankTransaction = <ThrowOnError extends boolean = false>(
  options: Options<GetBankTransactionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBankTransactionResponse, GetBankTransactionError, ThrowOnError>({
    ...options,
    url: '/BankTransactions/{BankTransactionID}',
  });
};

/**
 * Updates a single spent or received money transaction
 */
export const updateBankTransaction = <ThrowOnError extends boolean = false>(
  options: Options<UpdateBankTransactionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateBankTransactionResponse, UpdateBankTransactionError, ThrowOnError>({
    ...options,
    url: '/BankTransactions/{BankTransactionID}',
  });
};

/**
 * Retrieves any attachments from a specific bank transactions
 */
export const getBankTransactionAttachments = <ThrowOnError extends boolean = false>(
  options: Options<GetBankTransactionAttachmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetBankTransactionAttachmentsResponse,
    GetBankTransactionAttachmentsError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransactions/{BankTransactionID}/Attachments',
  });
};

/**
 * Retrieves specific attachments from a specific BankTransaction using a unique attachment Id
 */
export const getBankTransactionAttachmentById = <ThrowOnError extends boolean = false>(
  options: Options<GetBankTransactionAttachmentByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetBankTransactionAttachmentByIdResponse,
    GetBankTransactionAttachmentByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransactions/{BankTransactionID}/Attachments/{AttachmentID}',
  });
};

/**
 * Retrieves a specific attachment from a specific bank transaction by filename
 */
export const getBankTransactionAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<GetBankTransactionAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetBankTransactionAttachmentByFileNameResponse,
    GetBankTransactionAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransactions/{BankTransactionID}/Attachments/{FileName}',
  });
};

/**
 * Updates a specific attachment from a specific bank transaction by filename
 */
export const updateBankTransactionAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<UpdateBankTransactionAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateBankTransactionAttachmentByFileNameResponse,
    UpdateBankTransactionAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransactions/{BankTransactionID}/Attachments/{FileName}',
  });
};

/**
 * Creates an attachment for a specific bank transaction by filename
 */
export const createBankTransactionAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<CreateBankTransactionAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateBankTransactionAttachmentByFileNameResponse,
    CreateBankTransactionAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransactions/{BankTransactionID}/Attachments/{FileName}',
  });
};

/**
 * Retrieves history from a specific bank transaction using a unique bank transaction Id
 */
export const getBankTransactionsHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetBankTransactionsHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetBankTransactionsHistoryResponse,
    GetBankTransactionsHistoryError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransactions/{BankTransactionID}/History',
  });
};

/**
 * Creates a history record for a specific bank transactions
 */
export const createBankTransactionHistoryRecord = <ThrowOnError extends boolean = false>(
  options: Options<CreateBankTransactionHistoryRecordData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateBankTransactionHistoryRecordResponse,
    CreateBankTransactionHistoryRecordError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransactions/{BankTransactionID}/History',
  });
};

/**
 * Retrieves all bank transfers
 */
export const getBankTransfers = <ThrowOnError extends boolean = false>(
  options: Options<GetBankTransfersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBankTransfersResponse, GetBankTransfersError, ThrowOnError>({
    ...options,
    url: '/BankTransfers',
  });
};

/**
 * Creates a bank transfer
 */
export const createBankTransfer = <ThrowOnError extends boolean = false>(
  options: Options<CreateBankTransferData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateBankTransferResponse, CreateBankTransferError, ThrowOnError>({
    ...options,
    url: '/BankTransfers',
  });
};

/**
 * Retrieves specific bank transfers by using a unique bank transfer Id
 */
export const getBankTransfer = <ThrowOnError extends boolean = false>(
  options: Options<GetBankTransferData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBankTransferResponse, GetBankTransferError, ThrowOnError>({
    ...options,
    url: '/BankTransfers/{BankTransferID}',
  });
};

/**
 * Retrieves attachments from a specific bank transfer
 */
export const getBankTransferAttachments = <ThrowOnError extends boolean = false>(
  options: Options<GetBankTransferAttachmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetBankTransferAttachmentsResponse,
    GetBankTransferAttachmentsError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransfers/{BankTransferID}/Attachments',
  });
};

/**
 * Retrieves a specific attachment from a specific bank transfer using a unique attachment ID
 */
export const getBankTransferAttachmentById = <ThrowOnError extends boolean = false>(
  options: Options<GetBankTransferAttachmentByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetBankTransferAttachmentByIdResponse,
    GetBankTransferAttachmentByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransfers/{BankTransferID}/Attachments/{AttachmentID}',
  });
};

/**
 * Retrieves a specific attachment on a specific bank transfer by file name
 */
export const getBankTransferAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<GetBankTransferAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetBankTransferAttachmentByFileNameResponse,
    GetBankTransferAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransfers/{BankTransferID}/Attachments/{FileName}',
  });
};

export const updateBankTransferAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<UpdateBankTransferAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateBankTransferAttachmentByFileNameResponse,
    UpdateBankTransferAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransfers/{BankTransferID}/Attachments/{FileName}',
  });
};

export const createBankTransferAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<CreateBankTransferAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateBankTransferAttachmentByFileNameResponse,
    CreateBankTransferAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransfers/{BankTransferID}/Attachments/{FileName}',
  });
};

/**
 * Retrieves history from a specific bank transfer using a unique bank transfer Id
 */
export const getBankTransferHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetBankTransferHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBankTransferHistoryResponse, GetBankTransferHistoryError, ThrowOnError>({
    ...options,
    url: '/BankTransfers/{BankTransferID}/History',
  });
};

/**
 * Creates a history record for a specific bank transfer
 */
export const createBankTransferHistoryRecord = <ThrowOnError extends boolean = false>(
  options: Options<CreateBankTransferHistoryRecordData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateBankTransferHistoryRecordResponse,
    CreateBankTransferHistoryRecordError,
    ThrowOnError
  >({
    ...options,
    url: '/BankTransfers/{BankTransferID}/History',
  });
};

/**
 * Retrieves either one or many batch payments for invoices
 */
export const getBatchPayments = <ThrowOnError extends boolean = false>(
  options: Options<GetBatchPaymentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBatchPaymentsResponse, GetBatchPaymentsError, ThrowOnError>({
    ...options,
    url: '/BatchPayments',
  });
};

/**
 * Creates one or many batch payments for invoices
 */
export const createBatchPayment = <ThrowOnError extends boolean = false>(
  options: Options<CreateBatchPaymentData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateBatchPaymentResponse, CreateBatchPaymentError, ThrowOnError>({
    ...options,
    url: '/BatchPayments',
  });
};

/**
 * Retrieves history from a specific batch payment
 */
export const getBatchPaymentHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetBatchPaymentHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBatchPaymentHistoryResponse, GetBatchPaymentHistoryError, ThrowOnError>({
    ...options,
    url: '/BatchPayments/{BatchPaymentID}/History',
  });
};

/**
 * Creates a history record for a specific batch payment
 */
export const createBatchPaymentHistoryRecord = <ThrowOnError extends boolean = false>(
  options: Options<CreateBatchPaymentHistoryRecordData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateBatchPaymentHistoryRecordResponse,
    CreateBatchPaymentHistoryRecordError,
    ThrowOnError
  >({
    ...options,
    url: '/BatchPayments/{BatchPaymentID}/History',
  });
};

/**
 * Retrieves all the branding themes
 */
export const getBrandingThemes = <ThrowOnError extends boolean = false>(
  options: Options<GetBrandingThemesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBrandingThemesResponse, GetBrandingThemesError, ThrowOnError>({
    ...options,
    url: '/BrandingThemes',
  });
};

/**
 * Retrieves a specific branding theme using a unique branding theme Id
 */
export const getBrandingTheme = <ThrowOnError extends boolean = false>(
  options: Options<GetBrandingThemeData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBrandingThemeResponse, GetBrandingThemeError, ThrowOnError>({
    ...options,
    url: '/BrandingThemes/{BrandingThemeID}',
  });
};

/**
 * Retrieves the payment services for a specific branding theme
 */
export const getBrandingThemePaymentServices = <ThrowOnError extends boolean = false>(
  options: Options<GetBrandingThemePaymentServicesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetBrandingThemePaymentServicesResponse,
    GetBrandingThemePaymentServicesError,
    ThrowOnError
  >({
    ...options,
    url: '/BrandingThemes/{BrandingThemeID}/PaymentServices',
  });
};

/**
 * Creates a new custom payment service for a specific branding theme
 */
export const createBrandingThemePaymentServices = <ThrowOnError extends boolean = false>(
  options: Options<CreateBrandingThemePaymentServicesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateBrandingThemePaymentServicesResponse,
    CreateBrandingThemePaymentServicesError,
    ThrowOnError
  >({
    ...options,
    url: '/BrandingThemes/{BrandingThemeID}/PaymentServices',
  });
};

/**
 * Retrieves the contact Id and name of all the contacts in a contact group
 */
export const getContactGroups = <ThrowOnError extends boolean = false>(
  options: Options<GetContactGroupsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetContactGroupsResponse, GetContactGroupsError, ThrowOnError>({
    ...options,
    url: '/ContactGroups',
  });
};

/**
 * Creates a contact group
 */
export const createContactGroup = <ThrowOnError extends boolean = false>(
  options: Options<CreateContactGroupData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateContactGroupResponse, CreateContactGroupError, ThrowOnError>({
    ...options,
    url: '/ContactGroups',
  });
};

/**
 * Retrieves a specific contact group by using a unique contact group Id
 */
export const getContactGroup = <ThrowOnError extends boolean = false>(
  options: Options<GetContactGroupData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetContactGroupResponse, GetContactGroupError, ThrowOnError>({
    ...options,
    url: '/ContactGroups/{ContactGroupID}',
  });
};

/**
 * Updates a specific contact group
 */
export const updateContactGroup = <ThrowOnError extends boolean = false>(
  options: Options<UpdateContactGroupData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateContactGroupResponse, UpdateContactGroupError, ThrowOnError>({
    ...options,
    url: '/ContactGroups/{ContactGroupID}',
  });
};

/**
 * Deletes all contacts from a specific contact group
 */
export const deleteContactGroupContacts = <ThrowOnError extends boolean = false>(
  options: Options<DeleteContactGroupContactsData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteContactGroupContactsResponse,
    DeleteContactGroupContactsError,
    ThrowOnError
  >({
    ...options,
    url: '/ContactGroups/{ContactGroupID}/Contacts',
  });
};

/**
 * Creates contacts to a specific contact group
 */
export const createContactGroupContacts = <ThrowOnError extends boolean = false>(
  options: Options<CreateContactGroupContactsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateContactGroupContactsResponse,
    CreateContactGroupContactsError,
    ThrowOnError
  >({
    ...options,
    url: '/ContactGroups/{ContactGroupID}/Contacts',
  });
};

/**
 * Deletes a specific contact from a contact group using a unique contact Id
 */
export const deleteContactGroupContact = <ThrowOnError extends boolean = false>(
  options: Options<DeleteContactGroupContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteContactGroupContactResponse,
    DeleteContactGroupContactError,
    ThrowOnError
  >({
    ...options,
    url: '/ContactGroups/{ContactGroupID}/Contacts/{ContactID}',
  });
};

/**
 * Retrieves all contacts in a Xero organisation
 */
export const getContacts = <ThrowOnError extends boolean = false>(options: Options<GetContactsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetContactsResponse, GetContactsError, ThrowOnError>({
    ...options,
    url: '/Contacts',
  });
};

/**
 * Updates or creates one or more contacts in a Xero organisation
 */
export const updateOrCreateContacts = <ThrowOnError extends boolean = false>(
  options: Options<UpdateOrCreateContactsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateOrCreateContactsResponse, UpdateOrCreateContactsError, ThrowOnError>({
    ...options,
    url: '/Contacts',
  });
};

/**
 * Creates multiple contacts (bulk) in a Xero organisation
 */
export const createContacts = <ThrowOnError extends boolean = false>(
  options: Options<CreateContactsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateContactsResponse, CreateContactsError, ThrowOnError>({
    ...options,
    url: '/Contacts',
  });
};

/**
 * Retrieves a specific contacts in a Xero organisation using a unique contact Id
 */
export const getContact = <ThrowOnError extends boolean = false>(options: Options<GetContactData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetContactResponse, GetContactError, ThrowOnError>({
    ...options,
    url: '/Contacts/{ContactID}',
  });
};

/**
 * Updates a specific contact in a Xero organisation
 */
export const updateContact = <ThrowOnError extends boolean = false>(
  options: Options<UpdateContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateContactResponse, UpdateContactError, ThrowOnError>({
    ...options,
    url: '/Contacts/{ContactID}',
  });
};

/**
 * Retrieves attachments for a specific contact in a Xero organisation
 */
export const getContactAttachments = <ThrowOnError extends boolean = false>(
  options: Options<GetContactAttachmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetContactAttachmentsResponse, GetContactAttachmentsError, ThrowOnError>({
    ...options,
    url: '/Contacts/{ContactID}/Attachments',
  });
};

/**
 * Retrieves a specific attachment from a specific contact using a unique attachment Id
 */
export const getContactAttachmentById = <ThrowOnError extends boolean = false>(
  options: Options<GetContactAttachmentByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetContactAttachmentByIdResponse, GetContactAttachmentByIdError, ThrowOnError>(
    {
      ...options,
      url: '/Contacts/{ContactID}/Attachments/{AttachmentID}',
    },
  );
};

/**
 * Retrieves a specific attachment from a specific contact by file name
 */
export const getContactAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<GetContactAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetContactAttachmentByFileNameResponse,
    GetContactAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Contacts/{ContactID}/Attachments/{FileName}',
  });
};

export const updateContactAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<UpdateContactAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateContactAttachmentByFileNameResponse,
    UpdateContactAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Contacts/{ContactID}/Attachments/{FileName}',
  });
};

export const createContactAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<CreateContactAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateContactAttachmentByFileNameResponse,
    CreateContactAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Contacts/{ContactID}/Attachments/{FileName}',
  });
};

/**
 * Retrieves CIS settings for a specific contact in a Xero organisation
 */
export const getContactCisSettings = <ThrowOnError extends boolean = false>(
  options: Options<GetContactCisSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetContactCisSettingsResponse, GetContactCisSettingsError, ThrowOnError>({
    ...options,
    url: '/Contacts/{ContactID}/CISSettings',
  });
};

/**
 * Retrieves history records for a specific contact
 */
export const getContactHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetContactHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetContactHistoryResponse, GetContactHistoryError, ThrowOnError>({
    ...options,
    url: '/Contacts/{ContactID}/History',
  });
};

/**
 * Creates a new history record for a specific contact
 */
export const createContactHistory = <ThrowOnError extends boolean = false>(
  options: Options<CreateContactHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateContactHistoryResponse, CreateContactHistoryError, ThrowOnError>({
    ...options,
    url: '/Contacts/{ContactID}/History',
  });
};

/**
 * Retrieves a specific contact by contact number in a Xero organisation
 */
export const getContactByContactNumber = <ThrowOnError extends boolean = false>(
  options: Options<GetContactByContactNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetContactByContactNumberResponse,
    GetContactByContactNumberError,
    ThrowOnError
  >({
    ...options,
    url: '/Contacts/{ContactNumber}',
  });
};

/**
 * Retrieves any credit notes
 */
export const getCreditNotes = <ThrowOnError extends boolean = false>(
  options: Options<GetCreditNotesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCreditNotesResponse, GetCreditNotesError, ThrowOnError>({
    ...options,
    url: '/CreditNotes',
  });
};

/**
 * Updates or creates one or more credit notes
 */
export const updateOrCreateCreditNotes = <ThrowOnError extends boolean = false>(
  options: Options<UpdateOrCreateCreditNotesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateOrCreateCreditNotesResponse,
    UpdateOrCreateCreditNotesError,
    ThrowOnError
  >({
    ...options,
    url: '/CreditNotes',
  });
};

/**
 * Creates a new credit note
 */
export const createCreditNotes = <ThrowOnError extends boolean = false>(
  options: Options<CreateCreditNotesData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateCreditNotesResponse, CreateCreditNotesError, ThrowOnError>({
    ...options,
    url: '/CreditNotes',
  });
};

/**
 * Retrieves a specific credit note using a unique credit note Id
 */
export const getCreditNote = <ThrowOnError extends boolean = false>(
  options: Options<GetCreditNoteData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCreditNoteResponse, GetCreditNoteError, ThrowOnError>({
    ...options,
    url: '/CreditNotes/{CreditNoteID}',
  });
};

/**
 * Updates a specific credit note
 */
export const updateCreditNote = <ThrowOnError extends boolean = false>(
  options: Options<UpdateCreditNoteData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateCreditNoteResponse, UpdateCreditNoteError, ThrowOnError>({
    ...options,
    url: '/CreditNotes/{CreditNoteID}',
  });
};

/**
 * Creates allocation for a specific credit note
 */
export const createCreditNoteAllocation = <ThrowOnError extends boolean = false>(
  options: Options<CreateCreditNoteAllocationData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateCreditNoteAllocationResponse,
    CreateCreditNoteAllocationError,
    ThrowOnError
  >({
    ...options,
    url: '/CreditNotes/{CreditNoteID}/Allocations',
  });
};

/**
 * Retrieves attachments for a specific credit notes
 */
export const getCreditNoteAttachments = <ThrowOnError extends boolean = false>(
  options: Options<GetCreditNoteAttachmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCreditNoteAttachmentsResponse, GetCreditNoteAttachmentsError, ThrowOnError>(
    {
      ...options,
      url: '/CreditNotes/{CreditNoteID}/Attachments',
    },
  );
};

/**
 * Retrieves a specific attachment from a specific credit note using a unique attachment Id
 */
export const getCreditNoteAttachmentById = <ThrowOnError extends boolean = false>(
  options: Options<GetCreditNoteAttachmentByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetCreditNoteAttachmentByIdResponse,
    GetCreditNoteAttachmentByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/CreditNotes/{CreditNoteID}/Attachments/{AttachmentID}',
  });
};

/**
 * Retrieves a specific attachment on a specific credit note by file name
 */
export const getCreditNoteAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<GetCreditNoteAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetCreditNoteAttachmentByFileNameResponse,
    GetCreditNoteAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/CreditNotes/{CreditNoteID}/Attachments/{FileName}',
  });
};

/**
 * Updates attachments on a specific credit note by file name
 */
export const updateCreditNoteAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<UpdateCreditNoteAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateCreditNoteAttachmentByFileNameResponse,
    UpdateCreditNoteAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/CreditNotes/{CreditNoteID}/Attachments/{FileName}',
  });
};

/**
 * Creates an attachment for a specific credit note
 */
export const createCreditNoteAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<CreateCreditNoteAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateCreditNoteAttachmentByFileNameResponse,
    CreateCreditNoteAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/CreditNotes/{CreditNoteID}/Attachments/{FileName}',
  });
};

/**
 * Retrieves history records of a specific credit note
 */
export const getCreditNoteHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetCreditNoteHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCreditNoteHistoryResponse, GetCreditNoteHistoryError, ThrowOnError>({
    ...options,
    url: '/CreditNotes/{CreditNoteID}/History',
  });
};

/**
 * Retrieves history records of a specific credit note
 */
export const createCreditNoteHistory = <ThrowOnError extends boolean = false>(
  options: Options<CreateCreditNoteHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateCreditNoteHistoryResponse, CreateCreditNoteHistoryError, ThrowOnError>({
    ...options,
    url: '/CreditNotes/{CreditNoteID}/History',
  });
};

/**
 * Retrieves credit notes as PDF files
 */
export const getCreditNoteAsPdf = <ThrowOnError extends boolean = false>(
  options: Options<GetCreditNoteAsPdfData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCreditNoteAsPdfResponse, GetCreditNoteAsPdfError, ThrowOnError>({
    ...options,
    url: '/CreditNotes/{CreditNoteID}/pdf',
  });
};

/**
 * Retrieves currencies for your Xero organisation
 */
export const getCurrencies = <ThrowOnError extends boolean = false>(
  options: Options<GetCurrenciesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCurrenciesResponse, GetCurrenciesError, ThrowOnError>({
    ...options,
    url: '/Currencies',
  });
};

/**
 * Create a new currency for a Xero organisation
 */
export const createCurrency = <ThrowOnError extends boolean = false>(
  options: Options<CreateCurrencyData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateCurrencyResponse, CreateCurrencyError, ThrowOnError>({
    ...options,
    url: '/Currencies',
  });
};

/**
 * Retrieves employees used in Xero payrun
 */
export const getEmployees = <ThrowOnError extends boolean = false>(
  options: Options<GetEmployeesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetEmployeesResponse, GetEmployeesError, ThrowOnError>({
    ...options,
    url: '/Employees',
  });
};

/**
 * Creates a single new employees used in Xero payrun
 */
export const updateOrCreateEmployees = <ThrowOnError extends boolean = false>(
  options: Options<UpdateOrCreateEmployeesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateOrCreateEmployeesResponse, UpdateOrCreateEmployeesError, ThrowOnError>({
    ...options,
    url: '/Employees',
  });
};

/**
 * Creates new employees used in Xero payrun
 */
export const createEmployees = <ThrowOnError extends boolean = false>(
  options: Options<CreateEmployeesData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateEmployeesResponse, CreateEmployeesError, ThrowOnError>({
    ...options,
    url: '/Employees',
  });
};

/**
 * Retrieves a specific employee used in Xero payrun using a unique employee Id
 */
export const getEmployee = <ThrowOnError extends boolean = false>(options: Options<GetEmployeeData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetEmployeeResponse, GetEmployeeError, ThrowOnError>({
    ...options,
    url: '/Employees/{EmployeeID}',
  });
};

/**
 * Retrieves expense claims
 */
export const getExpenseClaims = <ThrowOnError extends boolean = false>(
  options: Options<GetExpenseClaimsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetExpenseClaimsResponse, GetExpenseClaimsError, ThrowOnError>({
    ...options,
    url: '/ExpenseClaims',
  });
};

/**
 * Creates expense claims
 */
export const createExpenseClaims = <ThrowOnError extends boolean = false>(
  options: Options<CreateExpenseClaimsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateExpenseClaimsResponse, CreateExpenseClaimsError, ThrowOnError>({
    ...options,
    url: '/ExpenseClaims',
  });
};

/**
 * Retrieves a specific expense claim using a unique expense claim Id
 */
export const getExpenseClaim = <ThrowOnError extends boolean = false>(
  options: Options<GetExpenseClaimData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetExpenseClaimResponse, GetExpenseClaimError, ThrowOnError>({
    ...options,
    url: '/ExpenseClaims/{ExpenseClaimID}',
  });
};

/**
 * Updates a specific expense claims
 */
export const updateExpenseClaim = <ThrowOnError extends boolean = false>(
  options: Options<UpdateExpenseClaimData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateExpenseClaimResponse, UpdateExpenseClaimError, ThrowOnError>({
    ...options,
    url: '/ExpenseClaims/{ExpenseClaimID}',
  });
};

/**
 * Retrieves history records of a specific expense claim
 */
export const getExpenseClaimHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetExpenseClaimHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetExpenseClaimHistoryResponse, GetExpenseClaimHistoryError, ThrowOnError>({
    ...options,
    url: '/ExpenseClaims/{ExpenseClaimID}/History',
  });
};

/**
 * Creates a history record for a specific expense claim
 */
export const createExpenseClaimHistory = <ThrowOnError extends boolean = false>(
  options: Options<CreateExpenseClaimHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateExpenseClaimHistoryResponse,
    CreateExpenseClaimHistoryError,
    ThrowOnError
  >({
    ...options,
    url: '/ExpenseClaims/{ExpenseClaimID}/History',
  });
};

/**
 * Retrieves invoice reminder settings
 */
export const getInvoiceReminders = <ThrowOnError extends boolean = false>(
  options: Options<GetInvoiceRemindersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetInvoiceRemindersResponse, GetInvoiceRemindersError, ThrowOnError>({
    ...options,
    url: '/InvoiceReminders/Settings',
  });
};

/**
 * Retrieves sales invoices or purchase bills
 */
export const getInvoices = <ThrowOnError extends boolean = false>(options: Options<GetInvoicesData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetInvoicesResponse, GetInvoicesError, ThrowOnError>({
    ...options,
    url: '/Invoices',
  });
};

/**
 * Updates or creates one or more sales invoices or purchase bills
 */
export const updateOrCreateInvoices = <ThrowOnError extends boolean = false>(
  options: Options<UpdateOrCreateInvoicesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateOrCreateInvoicesResponse, UpdateOrCreateInvoicesError, ThrowOnError>({
    ...options,
    url: '/Invoices',
  });
};

/**
 * Creates one or more sales invoices or purchase bills
 */
export const createInvoices = <ThrowOnError extends boolean = false>(
  options: Options<CreateInvoicesData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateInvoicesResponse, CreateInvoicesError, ThrowOnError>({
    ...options,
    url: '/Invoices',
  });
};

/**
 * Retrieves a specific sales invoice or purchase bill using a unique invoice Id
 */
export const getInvoice = <ThrowOnError extends boolean = false>(options: Options<GetInvoiceData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetInvoiceResponse, GetInvoiceError, ThrowOnError>({
    ...options,
    url: '/Invoices/{InvoiceID}',
  });
};

/**
 * Updates a specific sales invoices or purchase bills
 */
export const updateInvoice = <ThrowOnError extends boolean = false>(
  options: Options<UpdateInvoiceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateInvoiceResponse, UpdateInvoiceError, ThrowOnError>({
    ...options,
    url: '/Invoices/{InvoiceID}',
  });
};

/**
 * Retrieves attachments for a specific invoice or purchase bill
 */
export const getInvoiceAttachments = <ThrowOnError extends boolean = false>(
  options: Options<GetInvoiceAttachmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetInvoiceAttachmentsResponse, GetInvoiceAttachmentsError, ThrowOnError>({
    ...options,
    url: '/Invoices/{InvoiceID}/Attachments',
  });
};

/**
 * Retrieves a specific attachment from a specific invoices or purchase bills by using a unique attachment Id
 */
export const getInvoiceAttachmentById = <ThrowOnError extends boolean = false>(
  options: Options<GetInvoiceAttachmentByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetInvoiceAttachmentByIdResponse, GetInvoiceAttachmentByIdError, ThrowOnError>(
    {
      ...options,
      url: '/Invoices/{InvoiceID}/Attachments/{AttachmentID}',
    },
  );
};

/**
 * Retrieves an attachment from a specific invoice or purchase bill by filename
 */
export const getInvoiceAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<GetInvoiceAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetInvoiceAttachmentByFileNameResponse,
    GetInvoiceAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Invoices/{InvoiceID}/Attachments/{FileName}',
  });
};

/**
 * Updates an attachment from a specific invoices or purchase bill by filename
 */
export const updateInvoiceAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<UpdateInvoiceAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateInvoiceAttachmentByFileNameResponse,
    UpdateInvoiceAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Invoices/{InvoiceID}/Attachments/{FileName}',
  });
};

/**
 * Creates an attachment for a specific invoice or purchase bill by filename
 */
export const createInvoiceAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<CreateInvoiceAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateInvoiceAttachmentByFileNameResponse,
    CreateInvoiceAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Invoices/{InvoiceID}/Attachments/{FileName}',
  });
};

/**
 * Sends a copy of a specific invoice to related contact via email
 */
export const emailInvoice = <ThrowOnError extends boolean = false>(
  options: Options<EmailInvoiceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<EmailInvoiceResponse, EmailInvoiceError, ThrowOnError>({
    ...options,
    url: '/Invoices/{InvoiceID}/Email',
  });
};

/**
 * Retrieves history records for a specific invoice
 */
export const getInvoiceHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetInvoiceHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetInvoiceHistoryResponse, GetInvoiceHistoryError, ThrowOnError>({
    ...options,
    url: '/Invoices/{InvoiceID}/History',
  });
};

/**
 * Creates a history record for a specific invoice
 */
export const createInvoiceHistory = <ThrowOnError extends boolean = false>(
  options: Options<CreateInvoiceHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateInvoiceHistoryResponse, CreateInvoiceHistoryError, ThrowOnError>({
    ...options,
    url: '/Invoices/{InvoiceID}/History',
  });
};

/**
 * Retrieves a URL to an online invoice
 */
export const getOnlineInvoice = <ThrowOnError extends boolean = false>(
  options: Options<GetOnlineInvoiceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetOnlineInvoiceResponse, GetOnlineInvoiceError, ThrowOnError>({
    ...options,
    url: '/Invoices/{InvoiceID}/OnlineInvoice',
  });
};

/**
 * Retrieves invoices or purchase bills as PDF files
 */
export const getInvoiceAsPdf = <ThrowOnError extends boolean = false>(
  options: Options<GetInvoiceAsPdfData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetInvoiceAsPdfResponse, GetInvoiceAsPdfError, ThrowOnError>({
    ...options,
    url: '/Invoices/{InvoiceID}/pdf',
  });
};

/**
 * Retrieves items
 */
export const getItems = <ThrowOnError extends boolean = false>(options: Options<GetItemsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetItemsResponse, GetItemsError, ThrowOnError>({
    ...options,
    url: '/Items',
  });
};

/**
 * Updates or creates one or more items
 */
export const updateOrCreateItems = <ThrowOnError extends boolean = false>(
  options: Options<UpdateOrCreateItemsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateOrCreateItemsResponse, UpdateOrCreateItemsError, ThrowOnError>({
    ...options,
    url: '/Items',
  });
};

/**
 * Creates one or more items
 */
export const createItems = <ThrowOnError extends boolean = false>(options: Options<CreateItemsData, ThrowOnError>) => {
  return (options?.client ?? client).put<CreateItemsResponse, CreateItemsError, ThrowOnError>({
    ...options,
    url: '/Items',
  });
};

/**
 * Deletes a specific item
 */
export const deleteItem = <ThrowOnError extends boolean = false>(options: Options<DeleteItemData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteItemResponse, DeleteItemError, ThrowOnError>({
    ...options,
    url: '/Items/{ItemID}',
  });
};

/**
 * Retrieves a specific item using a unique item Id
 */
export const getItem = <ThrowOnError extends boolean = false>(options: Options<GetItemData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetItemResponse, GetItemError, ThrowOnError>({
    ...options,
    url: '/Items/{ItemID}',
  });
};

/**
 * Updates a specific item
 */
export const updateItem = <ThrowOnError extends boolean = false>(options: Options<UpdateItemData, ThrowOnError>) => {
  return (options?.client ?? client).post<UpdateItemResponse, UpdateItemError, ThrowOnError>({
    ...options,
    url: '/Items/{ItemID}',
  });
};

/**
 * Retrieves history for a specific item
 */
export const getItemHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetItemHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetItemHistoryResponse, GetItemHistoryError, ThrowOnError>({
    ...options,
    url: '/Items/{ItemID}/History',
  });
};

/**
 * Creates a history record for a specific item
 */
export const createItemHistory = <ThrowOnError extends boolean = false>(
  options: Options<CreateItemHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateItemHistoryResponse, CreateItemHistoryError, ThrowOnError>({
    ...options,
    url: '/Items/{ItemID}/History',
  });
};

/**
 * Retrieves journals
 */
export const getJournals = <ThrowOnError extends boolean = false>(options: Options<GetJournalsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetJournalsResponse, GetJournalsError, ThrowOnError>({
    ...options,
    url: '/Journals',
  });
};

/**
 * Retrieves a specific journal using a unique journal Id.
 */
export const getJournal = <ThrowOnError extends boolean = false>(options: Options<GetJournalData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetJournalResponse, GetJournalError, ThrowOnError>({
    ...options,
    url: '/Journals/{JournalID}',
  });
};

/**
 * Retrieves linked transactions (billable expenses)
 */
export const getLinkedTransactions = <ThrowOnError extends boolean = false>(
  options: Options<GetLinkedTransactionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetLinkedTransactionsResponse, GetLinkedTransactionsError, ThrowOnError>({
    ...options,
    url: '/LinkedTransactions',
  });
};

/**
 * Creates linked transactions (billable expenses)
 */
export const createLinkedTransaction = <ThrowOnError extends boolean = false>(
  options: Options<CreateLinkedTransactionData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateLinkedTransactionResponse, CreateLinkedTransactionError, ThrowOnError>({
    ...options,
    url: '/LinkedTransactions',
  });
};

/**
 * Deletes a specific linked transactions (billable expenses)
 */
export const deleteLinkedTransaction = <ThrowOnError extends boolean = false>(
  options: Options<DeleteLinkedTransactionData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteLinkedTransactionResponse,
    DeleteLinkedTransactionError,
    ThrowOnError
  >({
    ...options,
    url: '/LinkedTransactions/{LinkedTransactionID}',
  });
};

/**
 * Retrieves a specific linked transaction (billable expenses) using a unique linked transaction Id
 */
export const getLinkedTransaction = <ThrowOnError extends boolean = false>(
  options: Options<GetLinkedTransactionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetLinkedTransactionResponse, GetLinkedTransactionError, ThrowOnError>({
    ...options,
    url: '/LinkedTransactions/{LinkedTransactionID}',
  });
};

/**
 * Updates a specific linked transactions (billable expenses)
 */
export const updateLinkedTransaction = <ThrowOnError extends boolean = false>(
  options: Options<UpdateLinkedTransactionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateLinkedTransactionResponse, UpdateLinkedTransactionError, ThrowOnError>({
    ...options,
    url: '/LinkedTransactions/{LinkedTransactionID}',
  });
};

/**
 * Retrieves manual journals
 */
export const getManualJournals = <ThrowOnError extends boolean = false>(
  options: Options<GetManualJournalsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetManualJournalsResponse, GetManualJournalsError, ThrowOnError>({
    ...options,
    url: '/ManualJournals',
  });
};

/**
 * Updates or creates a single manual journal
 */
export const updateOrCreateManualJournals = <ThrowOnError extends boolean = false>(
  options: Options<UpdateOrCreateManualJournalsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateOrCreateManualJournalsResponse,
    UpdateOrCreateManualJournalsError,
    ThrowOnError
  >({
    ...options,
    url: '/ManualJournals',
  });
};

/**
 * Creates one or more manual journals
 */
export const createManualJournals = <ThrowOnError extends boolean = false>(
  options: Options<CreateManualJournalsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateManualJournalsResponse, CreateManualJournalsError, ThrowOnError>({
    ...options,
    url: '/ManualJournals',
  });
};

/**
 * Retrieves a specific manual journal
 */
export const getManualJournal = <ThrowOnError extends boolean = false>(
  options: Options<GetManualJournalData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetManualJournalResponse, GetManualJournalError, ThrowOnError>({
    ...options,
    url: '/ManualJournals/{ManualJournalID}',
  });
};

/**
 * Updates a specific manual journal
 */
export const updateManualJournal = <ThrowOnError extends boolean = false>(
  options: Options<UpdateManualJournalData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateManualJournalResponse, UpdateManualJournalError, ThrowOnError>({
    ...options,
    url: '/ManualJournals/{ManualJournalID}',
  });
};

/**
 * Retrieves attachment for a specific manual journal
 */
export const getManualJournalAttachments = <ThrowOnError extends boolean = false>(
  options: Options<GetManualJournalAttachmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetManualJournalAttachmentsResponse,
    GetManualJournalAttachmentsError,
    ThrowOnError
  >({
    ...options,
    url: '/ManualJournals/{ManualJournalID}/Attachments',
  });
};

/**
 * Allows you to retrieve a specific attachment from a specific manual journal using a unique attachment Id
 */
export const getManualJournalAttachmentById = <ThrowOnError extends boolean = false>(
  options: Options<GetManualJournalAttachmentByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetManualJournalAttachmentByIdResponse,
    GetManualJournalAttachmentByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ManualJournals/{ManualJournalID}/Attachments/{AttachmentID}',
  });
};

/**
 * Retrieves a specific attachment from a specific manual journal by file name
 */
export const getManualJournalAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<GetManualJournalAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetManualJournalAttachmentByFileNameResponse,
    GetManualJournalAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/ManualJournals/{ManualJournalID}/Attachments/{FileName}',
  });
};

/**
 * Updates a specific attachment from a specific manual journal by file name
 */
export const updateManualJournalAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<UpdateManualJournalAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateManualJournalAttachmentByFileNameResponse,
    UpdateManualJournalAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/ManualJournals/{ManualJournalID}/Attachments/{FileName}',
  });
};

/**
 * Creates a specific attachment for a specific manual journal by file name
 */
export const createManualJournalAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<CreateManualJournalAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateManualJournalAttachmentByFileNameResponse,
    CreateManualJournalAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/ManualJournals/{ManualJournalID}/Attachments/{FileName}',
  });
};

/**
 * Retrieves history for a specific manual journal
 */
export const getManualJournalsHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetManualJournalsHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetManualJournalsHistoryResponse, GetManualJournalsHistoryError, ThrowOnError>(
    {
      ...options,
      url: '/ManualJournals/{ManualJournalID}/History',
    },
  );
};

/**
 * Creates a history record for a specific manual journal
 */
export const createManualJournalHistoryRecord = <ThrowOnError extends boolean = false>(
  options: Options<CreateManualJournalHistoryRecordData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateManualJournalHistoryRecordResponse,
    CreateManualJournalHistoryRecordError,
    ThrowOnError
  >({
    ...options,
    url: '/ManualJournals/{ManualJournalID}/History',
  });
};

/**
 * Retrieves Xero organisation details
 */
export const getOrganisations = <ThrowOnError extends boolean = false>(
  options: Options<GetOrganisationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetOrganisationsResponse, GetOrganisationsError, ThrowOnError>({
    ...options,
    url: '/Organisation',
  });
};

/**
 * Retrieves a list of the key actions your app has permission to perform in the connected Xero organisation.
 */
export const getOrganisationActions = <ThrowOnError extends boolean = false>(
  options: Options<GetOrganisationActionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetOrganisationActionsResponse, GetOrganisationActionsError, ThrowOnError>({
    ...options,
    url: '/Organisation/Actions',
  });
};

/**
 * Retrieves the CIS settings for the Xero organistaion.
 */
export const getOrganisationCisSettings = <ThrowOnError extends boolean = false>(
  options: Options<GetOrganisationCisSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetOrganisationCisSettingsResponse,
    GetOrganisationCisSettingsError,
    ThrowOnError
  >({
    ...options,
    url: '/Organisation/{OrganisationID}/CISSettings',
  });
};

/**
 * Retrieves overpayments
 */
export const getOverpayments = <ThrowOnError extends boolean = false>(
  options: Options<GetOverpaymentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetOverpaymentsResponse, GetOverpaymentsError, ThrowOnError>({
    ...options,
    url: '/Overpayments',
  });
};

/**
 * Retrieves a specific overpayment using a unique overpayment Id
 */
export const getOverpayment = <ThrowOnError extends boolean = false>(
  options: Options<GetOverpaymentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetOverpaymentResponse, GetOverpaymentError, ThrowOnError>({
    ...options,
    url: '/Overpayments/{OverpaymentID}',
  });
};

/**
 * Creates a single allocation for a specific overpayment
 */
export const createOverpaymentAllocations = <ThrowOnError extends boolean = false>(
  options: Options<CreateOverpaymentAllocationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateOverpaymentAllocationsResponse,
    CreateOverpaymentAllocationsError,
    ThrowOnError
  >({
    ...options,
    url: '/Overpayments/{OverpaymentID}/Allocations',
  });
};

/**
 * Retrieves history records of a specific overpayment
 */
export const getOverpaymentHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetOverpaymentHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetOverpaymentHistoryResponse, GetOverpaymentHistoryError, ThrowOnError>({
    ...options,
    url: '/Overpayments/{OverpaymentID}/History',
  });
};

/**
 * Creates a history record for a specific overpayment
 */
export const createOverpaymentHistory = <ThrowOnError extends boolean = false>(
  options: Options<CreateOverpaymentHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateOverpaymentHistoryResponse, CreateOverpaymentHistoryError, ThrowOnError>(
    {
      ...options,
      url: '/Overpayments/{OverpaymentID}/History',
    },
  );
};

/**
 * Retrieves payment services
 */
export const getPaymentServices = <ThrowOnError extends boolean = false>(
  options: Options<GetPaymentServicesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPaymentServicesResponse, GetPaymentServicesError, ThrowOnError>({
    ...options,
    url: '/PaymentServices',
  });
};

/**
 * Creates a payment service
 */
export const createPaymentService = <ThrowOnError extends boolean = false>(
  options: Options<CreatePaymentServiceData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreatePaymentServiceResponse, CreatePaymentServiceError, ThrowOnError>({
    ...options,
    url: '/PaymentServices',
  });
};

/**
 * Retrieves payments for invoices and credit notes
 */
export const getPayments = <ThrowOnError extends boolean = false>(options: Options<GetPaymentsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetPaymentsResponse, GetPaymentsError, ThrowOnError>({
    ...options,
    url: '/Payments',
  });
};

/**
 * Creates a single payment for invoice or credit notes
 */
export const createPayment = <ThrowOnError extends boolean = false>(
  options: Options<CreatePaymentData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreatePaymentResponse, CreatePaymentError, ThrowOnError>({
    ...options,
    url: '/Payments',
  });
};

/**
 * Creates multiple payments for invoices or credit notes
 */
export const createPayments = <ThrowOnError extends boolean = false>(
  options: Options<CreatePaymentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreatePaymentsResponse, CreatePaymentsError, ThrowOnError>({
    ...options,
    url: '/Payments',
  });
};

/**
 * Retrieves a specific payment for invoices and credit notes using a unique payment Id
 */
export const getPayment = <ThrowOnError extends boolean = false>(options: Options<GetPaymentData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetPaymentResponse, GetPaymentError, ThrowOnError>({
    ...options,
    url: '/Payments/{PaymentID}',
  });
};

/**
 * Updates a specific payment for invoices and credit notes
 */
export const deletePayment = <ThrowOnError extends boolean = false>(
  options: Options<DeletePaymentData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DeletePaymentResponse, DeletePaymentError, ThrowOnError>({
    ...options,
    url: '/Payments/{PaymentID}',
  });
};

/**
 * Retrieves history records of a specific payment
 */
export const getPaymentHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetPaymentHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPaymentHistoryResponse, GetPaymentHistoryError, ThrowOnError>({
    ...options,
    url: '/Payments/{PaymentID}/History',
  });
};

/**
 * Creates a history record for a specific payment
 */
export const createPaymentHistory = <ThrowOnError extends boolean = false>(
  options: Options<CreatePaymentHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreatePaymentHistoryResponse, CreatePaymentHistoryError, ThrowOnError>({
    ...options,
    url: '/Payments/{PaymentID}/History',
  });
};

/**
 * Retrieves prepayments
 */
export const getPrepayments = <ThrowOnError extends boolean = false>(
  options: Options<GetPrepaymentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPrepaymentsResponse, GetPrepaymentsError, ThrowOnError>({
    ...options,
    url: '/Prepayments',
  });
};

/**
 * Allows you to retrieve a specified prepayments
 */
export const getPrepayment = <ThrowOnError extends boolean = false>(
  options: Options<GetPrepaymentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPrepaymentResponse, GetPrepaymentError, ThrowOnError>({
    ...options,
    url: '/Prepayments/{PrepaymentID}',
  });
};

/**
 * Allows you to create an Allocation for prepayments
 */
export const createPrepaymentAllocations = <ThrowOnError extends boolean = false>(
  options: Options<CreatePrepaymentAllocationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreatePrepaymentAllocationsResponse,
    CreatePrepaymentAllocationsError,
    ThrowOnError
  >({
    ...options,
    url: '/Prepayments/{PrepaymentID}/Allocations',
  });
};

/**
 * Retrieves history record for a specific prepayment
 */
export const getPrepaymentHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetPrepaymentHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPrepaymentHistoryResponse, GetPrepaymentHistoryError, ThrowOnError>({
    ...options,
    url: '/Prepayments/{PrepaymentID}/History',
  });
};

/**
 * Creates a history record for a specific prepayment
 */
export const createPrepaymentHistory = <ThrowOnError extends boolean = false>(
  options: Options<CreatePrepaymentHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreatePrepaymentHistoryResponse, CreatePrepaymentHistoryError, ThrowOnError>({
    ...options,
    url: '/Prepayments/{PrepaymentID}/History',
  });
};

/**
 * Retrieves purchase orders
 */
export const getPurchaseOrders = <ThrowOnError extends boolean = false>(
  options: Options<GetPurchaseOrdersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPurchaseOrdersResponse, GetPurchaseOrdersError, ThrowOnError>({
    ...options,
    url: '/PurchaseOrders',
  });
};

/**
 * Updates or creates one or more purchase orders
 */
export const updateOrCreatePurchaseOrders = <ThrowOnError extends boolean = false>(
  options: Options<UpdateOrCreatePurchaseOrdersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateOrCreatePurchaseOrdersResponse,
    UpdateOrCreatePurchaseOrdersError,
    ThrowOnError
  >({
    ...options,
    url: '/PurchaseOrders',
  });
};

/**
 * Creates one or more purchase orders
 */
export const createPurchaseOrders = <ThrowOnError extends boolean = false>(
  options: Options<CreatePurchaseOrdersData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreatePurchaseOrdersResponse, CreatePurchaseOrdersError, ThrowOnError>({
    ...options,
    url: '/PurchaseOrders',
  });
};

/**
 * Retrieves a specific purchase order using a unique purchase order Id
 */
export const getPurchaseOrder = <ThrowOnError extends boolean = false>(
  options: Options<GetPurchaseOrderData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPurchaseOrderResponse, GetPurchaseOrderError, ThrowOnError>({
    ...options,
    url: '/PurchaseOrders/{PurchaseOrderID}',
  });
};

/**
 * Updates a specific purchase order
 */
export const updatePurchaseOrder = <ThrowOnError extends boolean = false>(
  options: Options<UpdatePurchaseOrderData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdatePurchaseOrderResponse, UpdatePurchaseOrderError, ThrowOnError>({
    ...options,
    url: '/PurchaseOrders/{PurchaseOrderID}',
  });
};

/**
 * Retrieves attachments for a specific purchase order
 */
export const getPurchaseOrderAttachments = <ThrowOnError extends boolean = false>(
  options: Options<GetPurchaseOrderAttachmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetPurchaseOrderAttachmentsResponse,
    GetPurchaseOrderAttachmentsError,
    ThrowOnError
  >({
    ...options,
    url: '/PurchaseOrders/{PurchaseOrderID}/Attachments',
  });
};

/**
 * Retrieves specific attachment for a specific purchase order using a unique attachment Id
 */
export const getPurchaseOrderAttachmentById = <ThrowOnError extends boolean = false>(
  options: Options<GetPurchaseOrderAttachmentByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetPurchaseOrderAttachmentByIdResponse,
    GetPurchaseOrderAttachmentByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/PurchaseOrders/{PurchaseOrderID}/Attachments/{AttachmentID}',
  });
};

/**
 * Retrieves a specific attachment for a specific purchase order by filename
 */
export const getPurchaseOrderAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<GetPurchaseOrderAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetPurchaseOrderAttachmentByFileNameResponse,
    GetPurchaseOrderAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName}',
  });
};

/**
 * Updates a specific attachment for a specific purchase order by filename
 */
export const updatePurchaseOrderAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<UpdatePurchaseOrderAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdatePurchaseOrderAttachmentByFileNameResponse,
    UpdatePurchaseOrderAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName}',
  });
};

/**
 * Creates attachment for a specific purchase order
 */
export const createPurchaseOrderAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<CreatePurchaseOrderAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreatePurchaseOrderAttachmentByFileNameResponse,
    CreatePurchaseOrderAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName}',
  });
};

/**
 * Retrieves history for a specific purchase order
 */
export const getPurchaseOrderHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetPurchaseOrderHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPurchaseOrderHistoryResponse, GetPurchaseOrderHistoryError, ThrowOnError>({
    ...options,
    url: '/PurchaseOrders/{PurchaseOrderID}/History',
  });
};

/**
 * Creates a history record for a specific purchase orders
 */
export const createPurchaseOrderHistory = <ThrowOnError extends boolean = false>(
  options: Options<CreatePurchaseOrderHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreatePurchaseOrderHistoryResponse,
    CreatePurchaseOrderHistoryError,
    ThrowOnError
  >({
    ...options,
    url: '/PurchaseOrders/{PurchaseOrderID}/History',
  });
};

/**
 * Retrieves specific purchase order as PDF files using a unique purchase order Id
 */
export const getPurchaseOrderAsPdf = <ThrowOnError extends boolean = false>(
  options: Options<GetPurchaseOrderAsPdfData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPurchaseOrderAsPdfResponse, GetPurchaseOrderAsPdfError, ThrowOnError>({
    ...options,
    url: '/PurchaseOrders/{PurchaseOrderID}/pdf',
  });
};

/**
 * Retrieves a specific purchase order using purchase order number
 */
export const getPurchaseOrderByNumber = <ThrowOnError extends boolean = false>(
  options: Options<GetPurchaseOrderByNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPurchaseOrderByNumberResponse, GetPurchaseOrderByNumberError, ThrowOnError>(
    {
      ...options,
      url: '/PurchaseOrders/{PurchaseOrderNumber}',
    },
  );
};

/**
 * Retrieves sales quotes
 */
export const getQuotes = <ThrowOnError extends boolean = false>(options: Options<GetQuotesData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetQuotesResponse, GetQuotesError, ThrowOnError>({
    ...options,
    url: '/Quotes',
  });
};

/**
 * Updates or creates one or more quotes
 */
export const updateOrCreateQuotes = <ThrowOnError extends boolean = false>(
  options: Options<UpdateOrCreateQuotesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateOrCreateQuotesResponse, UpdateOrCreateQuotesError, ThrowOnError>({
    ...options,
    url: '/Quotes',
  });
};

/**
 * Create one or more quotes
 */
export const createQuotes = <ThrowOnError extends boolean = false>(
  options: Options<CreateQuotesData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateQuotesResponse, CreateQuotesError, ThrowOnError>({
    ...options,
    url: '/Quotes',
  });
};

/**
 * Retrieves a specific quote using a unique quote Id
 */
export const getQuote = <ThrowOnError extends boolean = false>(options: Options<GetQuoteData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetQuoteResponse, GetQuoteError, ThrowOnError>({
    ...options,
    url: '/Quotes/{QuoteID}',
  });
};

/**
 * Updates a specific quote
 */
export const updateQuote = <ThrowOnError extends boolean = false>(options: Options<UpdateQuoteData, ThrowOnError>) => {
  return (options?.client ?? client).post<UpdateQuoteResponse, UpdateQuoteError, ThrowOnError>({
    ...options,
    url: '/Quotes/{QuoteID}',
  });
};

/**
 * Retrieves attachments for a specific quote
 */
export const getQuoteAttachments = <ThrowOnError extends boolean = false>(
  options: Options<GetQuoteAttachmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetQuoteAttachmentsResponse, GetQuoteAttachmentsError, ThrowOnError>({
    ...options,
    url: '/Quotes/{QuoteID}/Attachments',
  });
};

/**
 * Retrieves a specific attachment from a specific quote using a unique attachment Id
 */
export const getQuoteAttachmentById = <ThrowOnError extends boolean = false>(
  options: Options<GetQuoteAttachmentByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetQuoteAttachmentByIdResponse, GetQuoteAttachmentByIdError, ThrowOnError>({
    ...options,
    url: '/Quotes/{QuoteID}/Attachments/{AttachmentID}',
  });
};

/**
 * Retrieves a specific attachment from a specific quote by filename
 */
export const getQuoteAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<GetQuoteAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetQuoteAttachmentByFileNameResponse,
    GetQuoteAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Quotes/{QuoteID}/Attachments/{FileName}',
  });
};

/**
 * Updates a specific attachment from a specific quote by filename
 */
export const updateQuoteAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<UpdateQuoteAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateQuoteAttachmentByFileNameResponse,
    UpdateQuoteAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Quotes/{QuoteID}/Attachments/{FileName}',
  });
};

/**
 * Creates attachment for a specific quote
 */
export const createQuoteAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<CreateQuoteAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateQuoteAttachmentByFileNameResponse,
    CreateQuoteAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Quotes/{QuoteID}/Attachments/{FileName}',
  });
};

/**
 * Retrieves history records of a specific quote
 */
export const getQuoteHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetQuoteHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetQuoteHistoryResponse, GetQuoteHistoryError, ThrowOnError>({
    ...options,
    url: '/Quotes/{QuoteID}/History',
  });
};

/**
 * Creates a history record for a specific quote
 */
export const createQuoteHistory = <ThrowOnError extends boolean = false>(
  options: Options<CreateQuoteHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateQuoteHistoryResponse, CreateQuoteHistoryError, ThrowOnError>({
    ...options,
    url: '/Quotes/{QuoteID}/History',
  });
};

/**
 * Retrieves a specific quote as a PDF file using a unique quote Id
 */
export const getQuoteAsPdf = <ThrowOnError extends boolean = false>(
  options: Options<GetQuoteAsPdfData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetQuoteAsPdfResponse, GetQuoteAsPdfError, ThrowOnError>({
    ...options,
    url: '/Quotes/{QuoteID}/pdf',
  });
};

/**
 * Retrieves draft expense claim receipts for any user
 */
export const getReceipts = <ThrowOnError extends boolean = false>(options: Options<GetReceiptsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetReceiptsResponse, GetReceiptsError, ThrowOnError>({
    ...options,
    url: '/Receipts',
  });
};

/**
 * Creates draft expense claim receipts for any user
 */
export const createReceipt = <ThrowOnError extends boolean = false>(
  options: Options<CreateReceiptData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateReceiptResponse, CreateReceiptError, ThrowOnError>({
    ...options,
    url: '/Receipts',
  });
};

/**
 * Retrieves a specific draft expense claim receipt by using a unique receipt Id
 */
export const getReceipt = <ThrowOnError extends boolean = false>(options: Options<GetReceiptData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetReceiptResponse, GetReceiptError, ThrowOnError>({
    ...options,
    url: '/Receipts/{ReceiptID}',
  });
};

/**
 * Updates a specific draft expense claim receipts
 */
export const updateReceipt = <ThrowOnError extends boolean = false>(
  options: Options<UpdateReceiptData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateReceiptResponse, UpdateReceiptError, ThrowOnError>({
    ...options,
    url: '/Receipts/{ReceiptID}',
  });
};

/**
 * Retrieves attachments for a specific expense claim receipt
 */
export const getReceiptAttachments = <ThrowOnError extends boolean = false>(
  options: Options<GetReceiptAttachmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReceiptAttachmentsResponse, GetReceiptAttachmentsError, ThrowOnError>({
    ...options,
    url: '/Receipts/{ReceiptID}/Attachments',
  });
};

/**
 * Retrieves a specific attachments from a specific expense claim receipts by using a unique attachment Id
 */
export const getReceiptAttachmentById = <ThrowOnError extends boolean = false>(
  options: Options<GetReceiptAttachmentByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReceiptAttachmentByIdResponse, GetReceiptAttachmentByIdError, ThrowOnError>(
    {
      ...options,
      url: '/Receipts/{ReceiptID}/Attachments/{AttachmentID}',
    },
  );
};

/**
 * Retrieves a specific attachment from a specific expense claim receipts by file name
 */
export const getReceiptAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<GetReceiptAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReceiptAttachmentByFileNameResponse,
    GetReceiptAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Receipts/{ReceiptID}/Attachments/{FileName}',
  });
};

/**
 * Updates a specific attachment on a specific expense claim receipts by file name
 */
export const updateReceiptAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<UpdateReceiptAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateReceiptAttachmentByFileNameResponse,
    UpdateReceiptAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Receipts/{ReceiptID}/Attachments/{FileName}',
  });
};

/**
 * Creates an attachment on a specific expense claim receipts by file name
 */
export const createReceiptAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<CreateReceiptAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateReceiptAttachmentByFileNameResponse,
    CreateReceiptAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/Receipts/{ReceiptID}/Attachments/{FileName}',
  });
};

/**
 * Retrieves a history record for a specific receipt
 */
export const getReceiptHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetReceiptHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReceiptHistoryResponse, GetReceiptHistoryError, ThrowOnError>({
    ...options,
    url: '/Receipts/{ReceiptID}/History',
  });
};

/**
 * Creates a history record for a specific receipt
 */
export const createReceiptHistory = <ThrowOnError extends boolean = false>(
  options: Options<CreateReceiptHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateReceiptHistoryResponse, CreateReceiptHistoryError, ThrowOnError>({
    ...options,
    url: '/Receipts/{ReceiptID}/History',
  });
};

/**
 * Retrieves repeating invoices
 */
export const getRepeatingInvoices = <ThrowOnError extends boolean = false>(
  options: Options<GetRepeatingInvoicesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetRepeatingInvoicesResponse, GetRepeatingInvoicesError, ThrowOnError>({
    ...options,
    url: '/RepeatingInvoices',
  });
};

/**
 * Retrieves a specific repeating invoice by using a unique repeating invoice Id
 */
export const getRepeatingInvoice = <ThrowOnError extends boolean = false>(
  options: Options<GetRepeatingInvoiceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetRepeatingInvoiceResponse, GetRepeatingInvoiceError, ThrowOnError>({
    ...options,
    url: '/RepeatingInvoices/{RepeatingInvoiceID}',
  });
};

/**
 * Retrieves attachments from a specific repeating invoice
 */
export const getRepeatingInvoiceAttachments = <ThrowOnError extends boolean = false>(
  options: Options<GetRepeatingInvoiceAttachmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetRepeatingInvoiceAttachmentsResponse,
    GetRepeatingInvoiceAttachmentsError,
    ThrowOnError
  >({
    ...options,
    url: '/RepeatingInvoices/{RepeatingInvoiceID}/Attachments',
  });
};

/**
 * Retrieves a specific attachment from a specific repeating invoice
 */
export const getRepeatingInvoiceAttachmentById = <ThrowOnError extends boolean = false>(
  options: Options<GetRepeatingInvoiceAttachmentByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetRepeatingInvoiceAttachmentByIdResponse,
    GetRepeatingInvoiceAttachmentByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{AttachmentID}',
  });
};

/**
 * Retrieves a specific attachment from a specific repeating invoices by file name
 */
export const getRepeatingInvoiceAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<GetRepeatingInvoiceAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetRepeatingInvoiceAttachmentByFileNameResponse,
    GetRepeatingInvoiceAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}',
  });
};

/**
 * Updates a specific attachment from a specific repeating invoices by file name
 */
export const updateRepeatingInvoiceAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<UpdateRepeatingInvoiceAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateRepeatingInvoiceAttachmentByFileNameResponse,
    UpdateRepeatingInvoiceAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}',
  });
};

/**
 * Creates an attachment from a specific repeating invoices by file name
 */
export const createRepeatingInvoiceAttachmentByFileName = <ThrowOnError extends boolean = false>(
  options: Options<CreateRepeatingInvoiceAttachmentByFileNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateRepeatingInvoiceAttachmentByFileNameResponse,
    CreateRepeatingInvoiceAttachmentByFileNameError,
    ThrowOnError
  >({
    ...options,
    url: '/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}',
  });
};

/**
 * Retrieves history record for a specific repeating invoice
 */
export const getRepeatingInvoiceHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetRepeatingInvoiceHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetRepeatingInvoiceHistoryResponse,
    GetRepeatingInvoiceHistoryError,
    ThrowOnError
  >({
    ...options,
    url: '/RepeatingInvoices/{RepeatingInvoiceID}/History',
  });
};

/**
 * Creates a  history record for a specific repeating invoice
 */
export const createRepeatingInvoiceHistory = <ThrowOnError extends boolean = false>(
  options: Options<CreateRepeatingInvoiceHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CreateRepeatingInvoiceHistoryResponse,
    CreateRepeatingInvoiceHistoryError,
    ThrowOnError
  >({
    ...options,
    url: '/RepeatingInvoices/{RepeatingInvoiceID}/History',
  });
};

/**
 * Retrieves report for BAS (only valid for AU orgs)
 */
export const getReportBaSorGstList = <ThrowOnError extends boolean = false>(
  options: Options<GetReportBaSorGstListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportBaSorGstListResponse, GetReportBaSorGstListError, ThrowOnError>({
    ...options,
    url: '/Reports',
  });
};

/**
 * Retrieves report for aged payables by contact
 */
export const getReportAgedPayablesByContact = <ThrowOnError extends boolean = false>(
  options: Options<GetReportAgedPayablesByContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportAgedPayablesByContactResponse,
    GetReportAgedPayablesByContactError,
    ThrowOnError
  >({
    ...options,
    url: '/Reports/AgedPayablesByContact',
  });
};

/**
 * Retrieves report for aged receivables by contact
 */
export const getReportAgedReceivablesByContact = <ThrowOnError extends boolean = false>(
  options: Options<GetReportAgedReceivablesByContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportAgedReceivablesByContactResponse,
    GetReportAgedReceivablesByContactError,
    ThrowOnError
  >({
    ...options,
    url: '/Reports/AgedReceivablesByContact',
  });
};

/**
 * Retrieves report for balancesheet
 */
export const getReportBalanceSheet = <ThrowOnError extends boolean = false>(
  options: Options<GetReportBalanceSheetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportBalanceSheetResponse, GetReportBalanceSheetError, ThrowOnError>({
    ...options,
    url: '/Reports/BalanceSheet',
  });
};

/**
 * Retrieves report for bank summary
 */
export const getReportBankSummary = <ThrowOnError extends boolean = false>(
  options: Options<GetReportBankSummaryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportBankSummaryResponse, GetReportBankSummaryError, ThrowOnError>({
    ...options,
    url: '/Reports/BankSummary',
  });
};

/**
 * Retrieves report for budget summary
 */
export const getReportBudgetSummary = <ThrowOnError extends boolean = false>(
  options: Options<GetReportBudgetSummaryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportBudgetSummaryResponse, GetReportBudgetSummaryError, ThrowOnError>({
    ...options,
    url: '/Reports/BudgetSummary',
  });
};

/**
 * Retrieves report for executive summary
 */
export const getReportExecutiveSummary = <ThrowOnError extends boolean = false>(
  options: Options<GetReportExecutiveSummaryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportExecutiveSummaryResponse,
    GetReportExecutiveSummaryError,
    ThrowOnError
  >({
    ...options,
    url: '/Reports/ExecutiveSummary',
  });
};

/**
 * Retrieves report for profit and loss
 */
export const getReportProfitAndLoss = <ThrowOnError extends boolean = false>(
  options: Options<GetReportProfitAndLossData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportProfitAndLossResponse, GetReportProfitAndLossError, ThrowOnError>({
    ...options,
    url: '/Reports/ProfitAndLoss',
  });
};

/**
 * Retrieve reports for 1099
 */
export const getReportTenNinetyNine = <ThrowOnError extends boolean = false>(
  options: Options<GetReportTenNinetyNineData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportTenNinetyNineResponse, GetReportTenNinetyNineError, ThrowOnError>({
    ...options,
    url: '/Reports/TenNinetyNine',
  });
};

/**
 * Retrieves report for trial balance
 */
export const getReportTrialBalance = <ThrowOnError extends boolean = false>(
  options: Options<GetReportTrialBalanceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportTrialBalanceResponse, GetReportTrialBalanceError, ThrowOnError>({
    ...options,
    url: '/Reports/TrialBalance',
  });
};

/**
 * Retrieves a specific report for BAS using a unique report Id (only valid for AU orgs)
 */
export const getReportBaSorGst = <ThrowOnError extends boolean = false>(
  options: Options<GetReportBaSorGstData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportBaSorGstResponse, GetReportBaSorGstError, ThrowOnError>({
    ...options,
    url: '/Reports/{ReportID}',
  });
};

/**
 * Sets the chart of accounts, the conversion date and conversion balances
 */
export const postSetup = <ThrowOnError extends boolean = false>(options: Options<PostSetupData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostSetupResponse, PostSetupError, ThrowOnError>({
    ...options,
    url: '/Setup',
  });
};

/**
 * Retrieves tax rates
 */
export const getTaxRates = <ThrowOnError extends boolean = false>(options: Options<GetTaxRatesData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetTaxRatesResponse, GetTaxRatesError, ThrowOnError>({
    ...options,
    url: '/TaxRates',
  });
};

/**
 * Updates tax rates
 */
export const updateTaxRate = <ThrowOnError extends boolean = false>(
  options: Options<UpdateTaxRateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateTaxRateResponse, UpdateTaxRateError, ThrowOnError>({
    ...options,
    url: '/TaxRates',
  });
};

/**
 * Creates one or more tax rates
 */
export const createTaxRates = <ThrowOnError extends boolean = false>(
  options: Options<CreateTaxRatesData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateTaxRatesResponse, CreateTaxRatesError, ThrowOnError>({
    ...options,
    url: '/TaxRates',
  });
};

/**
 * Retrieves tracking categories and options
 */
export const getTrackingCategories = <ThrowOnError extends boolean = false>(
  options: Options<GetTrackingCategoriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTrackingCategoriesResponse, GetTrackingCategoriesError, ThrowOnError>({
    ...options,
    url: '/TrackingCategories',
  });
};

/**
 * Create tracking categories
 */
export const createTrackingCategory = <ThrowOnError extends boolean = false>(
  options: Options<CreateTrackingCategoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateTrackingCategoryResponse, CreateTrackingCategoryError, ThrowOnError>({
    ...options,
    url: '/TrackingCategories',
  });
};

/**
 * Deletes a specific tracking category
 */
export const deleteTrackingCategory = <ThrowOnError extends boolean = false>(
  options: Options<DeleteTrackingCategoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteTrackingCategoryResponse, DeleteTrackingCategoryError, ThrowOnError>({
    ...options,
    url: '/TrackingCategories/{TrackingCategoryID}',
  });
};

/**
 * Retrieves specific tracking categories and options using a unique tracking category Id
 */
export const getTrackingCategory = <ThrowOnError extends boolean = false>(
  options: Options<GetTrackingCategoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTrackingCategoryResponse, GetTrackingCategoryError, ThrowOnError>({
    ...options,
    url: '/TrackingCategories/{TrackingCategoryID}',
  });
};

/**
 * Updates a specific tracking category
 */
export const updateTrackingCategory = <ThrowOnError extends boolean = false>(
  options: Options<UpdateTrackingCategoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateTrackingCategoryResponse, UpdateTrackingCategoryError, ThrowOnError>({
    ...options,
    url: '/TrackingCategories/{TrackingCategoryID}',
  });
};

/**
 * Creates options for a specific tracking category
 */
export const createTrackingOptions = <ThrowOnError extends boolean = false>(
  options: Options<CreateTrackingOptionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CreateTrackingOptionsResponse, CreateTrackingOptionsError, ThrowOnError>({
    ...options,
    url: '/TrackingCategories/{TrackingCategoryID}/Options',
  });
};

/**
 * Deletes a specific option for a specific tracking category
 */
export const deleteTrackingOptions = <ThrowOnError extends boolean = false>(
  options: Options<DeleteTrackingOptionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteTrackingOptionsResponse, DeleteTrackingOptionsError, ThrowOnError>({
    ...options,
    url: '/TrackingCategories/{TrackingCategoryID}/Options/{TrackingOptionID}',
  });
};

/**
 * Updates a specific option for a specific tracking category
 */
export const updateTrackingOptions = <ThrowOnError extends boolean = false>(
  options: Options<UpdateTrackingOptionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateTrackingOptionsResponse, UpdateTrackingOptionsError, ThrowOnError>({
    ...options,
    url: '/TrackingCategories/{TrackingCategoryID}/Options/{TrackingOptionID}',
  });
};

/**
 * Retrieves users
 */
export const getUsers = <ThrowOnError extends boolean = false>(options: Options<GetUsersData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetUsersResponse, GetUsersError, ThrowOnError>({
    ...options,
    url: '/Users',
  });
};

/**
 * Retrieves a specific user
 */
export const getUser = <ThrowOnError extends boolean = false>(options: Options<GetUserData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetUserResponse, GetUserError, ThrowOnError>({
    ...options,
    url: '/Users/{UserID}',
  });
};
