export const comments = {
  getAccounts: {
    comment: 'Retrieves the full chart of accounts',
    doc: 'Retrieves the full chart of accounts',
  },
  createAccount: {
    comment: 'Creates a new chart of accounts',
    doc: 'Creates a new chart of accounts',
  },
  deleteAccount: {
    comment: 'Deletes a chart of accounts',
    doc: 'Deletes a chart of accounts',
  },
  getAccount: {
    comment: 'Retrieves a single chart of accounts by using a unique account Id',
    doc: 'Retrieves a single chart of accounts by using a unique account Id',
  },
  updateAccount: {
    comment: 'Updates a chart of accounts',
    doc: 'Updates a chart of accounts',
  },
  getAccountAttachments: {
    comment: 'Retrieves attachments for a specific accounts by using a unique account Id',
    doc: 'Retrieves attachments for a specific accounts by using a unique account Id',
  },
  getAccountAttachmentById: {
    comment: 'Retrieves a specific attachment from a specific account using a unique attachment Id',
    doc: 'Retrieves a specific attachment from a specific account using a unique attachment Id',
  },
  getAccountAttachmentByFileName: {
    comment: 'Retrieves an attachment for a specific account by filename',
    doc: 'Retrieves an attachment for a specific account by filename',
  },
  updateAccountAttachmentByFileName: {
    comment: 'Updates attachment on a specific account by filename',
    doc: 'Updates attachment on a specific account by filename',
  },
  createAccountAttachmentByFileName: {
    comment: 'Creates an attachment on a specific account',
    doc: 'Creates an attachment on a specific account',
  },
  getBankTransactions: {
    comment: 'Retrieves any spent or received money transactions',
    doc: 'Retrieves any spent or received money transactions',
  },
  updateOrCreateBankTransactions: {
    comment: 'Updates or creates one or more spent or received money transaction',
    doc: 'Updates or creates one or more spent or received money transaction',
  },
  createBankTransactions: {
    comment: 'Creates one or more spent or received money transaction',
    doc: 'Creates one or more spent or received money transaction',
  },
  getBankTransaction: {
    comment: 'Retrieves a single spent or received money transaction by using a unique bank transaction Id',
    doc: 'Retrieves a single spent or received money transaction by using a unique bank transaction Id',
  },
  updateBankTransaction: {
    comment: 'Updates a single spent or received money transaction',
    doc: 'Updates a single spent or received money transaction',
  },
  getBankTransactionAttachments: {
    comment: 'Retrieves any attachments from a specific bank transactions',
    doc: 'Retrieves any attachments from a specific bank transactions',
  },
  getBankTransactionAttachmentById: {
    comment: 'Retrieves specific attachments from a specific BankTransaction using a unique attachment Id',
    doc: 'Retrieves specific attachments from a specific BankTransaction using a unique attachment Id',
  },
  getBankTransactionAttachmentByFileName: {
    comment: 'Retrieves a specific attachment from a specific bank transaction by filename',
    doc: 'Retrieves a specific attachment from a specific bank transaction by filename',
  },
  updateBankTransactionAttachmentByFileName: {
    comment: 'Updates a specific attachment from a specific bank transaction by filename',
    doc: 'Updates a specific attachment from a specific bank transaction by filename',
  },
  createBankTransactionAttachmentByFileName: {
    comment: 'Creates an attachment for a specific bank transaction by filename',
    doc: 'Creates an attachment for a specific bank transaction by filename',
  },
  getBankTransactionsHistory: {
    comment: 'Retrieves history from a specific bank transaction using a unique bank transaction Id',
    doc: 'Retrieves history from a specific bank transaction using a unique bank transaction Id',
  },
  createBankTransactionHistoryRecord: {
    comment: 'Creates a history record for a specific bank transactions',
    doc: 'Creates a history record for a specific bank transactions',
  },
  getBankTransfers: {
    comment: 'Retrieves all bank transfers',
    doc: 'Retrieves all bank transfers',
  },
  createBankTransfer: {
    comment: 'Creates a bank transfer',
    doc: 'Creates a bank transfer',
  },
  getBankTransfer: {
    comment: 'Retrieves specific bank transfers by using a unique bank transfer Id',
    doc: 'Retrieves specific bank transfers by using a unique bank transfer Id',
  },
  getBankTransferAttachments: {
    comment: 'Retrieves attachments from a specific bank transfer',
    doc: 'Retrieves attachments from a specific bank transfer',
  },
  getBankTransferAttachmentById: {
    comment: 'Retrieves a specific attachment from a specific bank transfer using a unique attachment ID',
    doc: 'Retrieves a specific attachment from a specific bank transfer using a unique attachment ID',
  },
  getBankTransferAttachmentByFileName: {
    comment: 'Retrieves a specific attachment on a specific bank transfer by file name',
    doc: 'Retrieves a specific attachment on a specific bank transfer by file name',
  },
  getBankTransferHistory: {
    comment: 'Retrieves history from a specific bank transfer using a unique bank transfer Id',
    doc: 'Retrieves history from a specific bank transfer using a unique bank transfer Id',
  },
  createBankTransferHistoryRecord: {
    comment: 'Creates a history record for a specific bank transfer',
    doc: 'Creates a history record for a specific bank transfer',
  },
  getBatchPayments: {
    comment: 'Retrieves either one or many batch payments for invoices',
    doc: 'Retrieves either one or many batch payments for invoices',
  },
  createBatchPayment: {
    comment: 'Creates one or many batch payments for invoices',
    doc: 'Creates one or many batch payments for invoices',
  },
  getBatchPaymentHistory: {
    comment: 'Retrieves history from a specific batch payment',
    doc: 'Retrieves history from a specific batch payment',
  },
  createBatchPaymentHistoryRecord: {
    comment: 'Creates a history record for a specific batch payment',
    doc: 'Creates a history record for a specific batch payment',
  },
  getBrandingThemes: {
    comment: 'Retrieves all the branding themes',
    doc: 'Retrieves all the branding themes',
  },
  getBrandingTheme: {
    comment: 'Retrieves a specific branding theme using a unique branding theme Id',
    doc: 'Retrieves a specific branding theme using a unique branding theme Id',
  },
  getBrandingThemePaymentServices: {
    comment: 'Retrieves the payment services for a specific branding theme',
    doc: 'Retrieves the payment services for a specific branding theme',
  },
  createBrandingThemePaymentServices: {
    comment: 'Creates a new custom payment service for a specific branding theme',
    doc: 'Creates a new custom payment service for a specific branding theme',
  },
  getContactGroups: {
    comment: 'Retrieves the contact Id and name of all the contacts in a contact group',
    doc: 'Retrieves the contact Id and name of all the contacts in a contact group',
  },
  createContactGroup: {
    comment: 'Creates a contact group',
    doc: 'Creates a contact group',
  },
  getContactGroup: {
    comment: 'Retrieves a specific contact group by using a unique contact group Id',
    doc: 'Retrieves a specific contact group by using a unique contact group Id',
  },
  updateContactGroup: {
    comment: 'Updates a specific contact group',
    doc: 'Updates a specific contact group',
  },
  deleteContactGroupContacts: {
    comment: 'Deletes all contacts from a specific contact group',
    doc: 'Deletes all contacts from a specific contact group',
  },
  createContactGroupContacts: {
    comment: 'Creates contacts to a specific contact group',
    doc: 'Creates contacts to a specific contact group',
  },
  deleteContactGroupContact: {
    comment: 'Deletes a specific contact from a contact group using a unique contact Id',
    doc: 'Deletes a specific contact from a contact group using a unique contact Id',
  },
  getContacts: {
    comment: 'Retrieves all contacts in a Xero organisation',
    doc: 'Retrieves all contacts in a Xero organisation',
  },
  updateOrCreateContacts: {
    comment: 'Updates or creates one or more contacts in a Xero organisation',
    doc: 'Updates or creates one or more contacts in a Xero organisation',
  },
  createContacts: {
    comment: 'Creates multiple contacts (bulk) in a Xero organisation',
    doc: 'Creates multiple contacts (bulk) in a Xero organisation',
  },
  getContact: {
    comment: 'Retrieves a specific contacts in a Xero organisation using a unique contact Id',
    doc: 'Retrieves a specific contacts in a Xero organisation using a unique contact Id',
  },
  updateContact: {
    comment: 'Updates a specific contact in a Xero organisation',
    doc: 'Updates a specific contact in a Xero organisation',
  },
  getContactAttachments: {
    comment: 'Retrieves attachments for a specific contact in a Xero organisation',
    doc: 'Retrieves attachments for a specific contact in a Xero organisation',
  },
  getContactAttachmentById: {
    comment: 'Retrieves a specific attachment from a specific contact using a unique attachment Id',
    doc: 'Retrieves a specific attachment from a specific contact using a unique attachment Id',
  },
  getContactAttachmentByFileName: {
    comment: 'Retrieves a specific attachment from a specific contact by file name',
    doc: 'Retrieves a specific attachment from a specific contact by file name',
  },
  getContactCisSettings: {
    comment: 'Retrieves CIS settings for a specific contact in a Xero organisation',
    doc: 'Retrieves CIS settings for a specific contact in a Xero organisation',
  },
  getContactHistory: {
    comment: 'Retrieves history records for a specific contact',
    doc: 'Retrieves history records for a specific contact',
  },
  createContactHistory: {
    comment: 'Creates a new history record for a specific contact',
    doc: 'Creates a new history record for a specific contact',
  },
  getContactByContactNumber: {
    comment: 'Retrieves a specific contact by contact number in a Xero organisation',
    doc: 'Retrieves a specific contact by contact number in a Xero organisation',
  },
  getCreditNotes: {
    comment: 'Retrieves any credit notes',
    doc: 'Retrieves any credit notes',
  },
  updateOrCreateCreditNotes: {
    comment: 'Updates or creates one or more credit notes',
    doc: 'Updates or creates one or more credit notes',
  },
  createCreditNotes: {
    comment: 'Creates a new credit note',
    doc: 'Creates a new credit note',
  },
  getCreditNote: {
    comment: 'Retrieves a specific credit note using a unique credit note Id',
    doc: 'Retrieves a specific credit note using a unique credit note Id',
  },
  updateCreditNote: {
    comment: 'Updates a specific credit note',
    doc: 'Updates a specific credit note',
  },
  createCreditNoteAllocation: {
    comment: 'Creates allocation for a specific credit note',
    doc: 'Creates allocation for a specific credit note',
  },
  getCreditNoteAttachments: {
    comment: 'Retrieves attachments for a specific credit notes',
    doc: 'Retrieves attachments for a specific credit notes',
  },
  getCreditNoteAttachmentById: {
    comment: 'Retrieves a specific attachment from a specific credit note using a unique attachment Id',
    doc: 'Retrieves a specific attachment from a specific credit note using a unique attachment Id',
  },
  getCreditNoteAttachmentByFileName: {
    comment: 'Retrieves a specific attachment on a specific credit note by file name',
    doc: 'Retrieves a specific attachment on a specific credit note by file name',
  },
  updateCreditNoteAttachmentByFileName: {
    comment: 'Updates attachments on a specific credit note by file name',
    doc: 'Updates attachments on a specific credit note by file name',
  },
  createCreditNoteAttachmentByFileName: {
    comment: 'Creates an attachment for a specific credit note',
    doc: 'Creates an attachment for a specific credit note',
  },
  getCreditNoteHistory: {
    comment: 'Retrieves history records of a specific credit note',
    doc: 'Retrieves history records of a specific credit note',
  },
  createCreditNoteHistory: {
    comment: 'Retrieves history records of a specific credit note',
    doc: 'Retrieves history records of a specific credit note',
  },
  getCreditNoteAsPdf: {
    comment: 'Retrieves credit notes as PDF files',
    doc: 'Retrieves credit notes as PDF files',
  },
  getCurrencies: {
    comment: 'Retrieves currencies for your Xero organisation',
    doc: 'Retrieves currencies for your Xero organisation',
  },
  createCurrency: {
    comment: 'Create a new currency for a Xero organisation',
    doc: 'Create a new currency for a Xero organisation',
  },
  getEmployees: {
    comment: 'Retrieves employees used in Xero payrun',
    doc: 'Retrieves employees used in Xero payrun',
  },
  updateOrCreateEmployees: {
    comment: 'Creates a single new employees used in Xero payrun',
    doc: 'Creates a single new employees used in Xero payrun',
  },
  createEmployees: {
    comment: 'Creates new employees used in Xero payrun',
    doc: 'Creates new employees used in Xero payrun',
  },
  getEmployee: {
    comment: 'Retrieves a specific employee used in Xero payrun using a unique employee Id',
    doc: 'Retrieves a specific employee used in Xero payrun using a unique employee Id',
  },
  getExpenseClaims: {
    comment: 'Retrieves expense claims',
    doc: 'Retrieves expense claims',
  },
  createExpenseClaims: {
    comment: 'Creates expense claims',
    doc: 'Creates expense claims',
  },
  getExpenseClaim: {
    comment: 'Retrieves a specific expense claim using a unique expense claim Id',
    doc: 'Retrieves a specific expense claim using a unique expense claim Id',
  },
  updateExpenseClaim: {
    comment: 'Updates a specific expense claims',
    doc: 'Updates a specific expense claims',
  },
  getExpenseClaimHistory: {
    comment: 'Retrieves history records of a specific expense claim',
    doc: 'Retrieves history records of a specific expense claim',
  },
  createExpenseClaimHistory: {
    comment: 'Creates a history record for a specific expense claim',
    doc: 'Creates a history record for a specific expense claim',
  },
  getInvoiceReminders: {
    comment: 'Retrieves invoice reminder settings',
    doc: 'Retrieves invoice reminder settings',
  },
  getInvoices: {
    comment: 'Retrieves sales invoices or purchase bills',
    doc: 'Retrieves sales invoices or purchase bills',
  },
  updateOrCreateInvoices: {
    comment: 'Updates or creates one or more sales invoices or purchase bills',
    doc: 'Updates or creates one or more sales invoices or purchase bills',
  },
  createInvoices: {
    comment: 'Creates one or more sales invoices or purchase bills',
    doc: 'Creates one or more sales invoices or purchase bills',
  },
  getInvoice: {
    comment: 'Retrieves a specific sales invoice or purchase bill using a unique invoice Id',
    doc: 'Retrieves a specific sales invoice or purchase bill using a unique invoice Id',
  },
  updateInvoice: {
    comment: 'Updates a specific sales invoices or purchase bills',
    doc: 'Updates a specific sales invoices or purchase bills',
  },
  getInvoiceAttachments: {
    comment: 'Retrieves attachments for a specific invoice or purchase bill',
    doc: 'Retrieves attachments for a specific invoice or purchase bill',
  },
  getInvoiceAttachmentById: {
    comment:
      'Retrieves a specific attachment from a specific invoices or purchase bills by using a unique attachment Id',
    doc: 'Retrieves a specific attachment from a specific invoices or purchase bills by using a unique attachment Id',
  },
  getInvoiceAttachmentByFileName: {
    comment: 'Retrieves an attachment from a specific invoice or purchase bill by filename',
    doc: 'Retrieves an attachment from a specific invoice or purchase bill by filename',
  },
  updateInvoiceAttachmentByFileName: {
    comment: 'Updates an attachment from a specific invoices or purchase bill by filename',
    doc: 'Updates an attachment from a specific invoices or purchase bill by filename',
  },
  createInvoiceAttachmentByFileName: {
    comment: 'Creates an attachment for a specific invoice or purchase bill by filename',
    doc: 'Creates an attachment for a specific invoice or purchase bill by filename',
  },
  emailInvoice: {
    comment: 'Sends a copy of a specific invoice to related contact via email',
    doc: 'Sends a copy of a specific invoice to related contact via email',
  },
  getInvoiceHistory: {
    comment: 'Retrieves history records for a specific invoice',
    doc: 'Retrieves history records for a specific invoice',
  },
  createInvoiceHistory: {
    comment: 'Creates a history record for a specific invoice',
    doc: 'Creates a history record for a specific invoice',
  },
  getOnlineInvoice: {
    comment: 'Retrieves a URL to an online invoice',
    doc: 'Retrieves a URL to an online invoice',
  },
  getInvoiceAsPdf: {
    comment: 'Retrieves invoices or purchase bills as PDF files',
    doc: 'Retrieves invoices or purchase bills as PDF files',
  },
  getItems: {
    comment: 'Retrieves items',
    doc: 'Retrieves items',
  },
  updateOrCreateItems: {
    comment: 'Updates or creates one or more items',
    doc: 'Updates or creates one or more items',
  },
  createItems: {
    comment: 'Creates one or more items',
    doc: 'Creates one or more items',
  },
  deleteItem: {
    comment: 'Deletes a specific item',
    doc: 'Deletes a specific item',
  },
  getItem: {
    comment: 'Retrieves a specific item using a unique item Id',
    doc: 'Retrieves a specific item using a unique item Id',
  },
  updateItem: {
    comment: 'Updates a specific item',
    doc: 'Updates a specific item',
  },
  getItemHistory: {
    comment: 'Retrieves history for a specific item',
    doc: 'Retrieves history for a specific item',
  },
  createItemHistory: {
    comment: 'Creates a history record for a specific item',
    doc: 'Creates a history record for a specific item',
  },
  getJournals: {
    comment: 'Retrieves journals',
    doc: 'Retrieves journals',
  },
  getJournal: {
    comment: 'Retrieves a specific journal using a unique journal Id.',
    doc: 'Retrieves a specific journal using a unique journal Id.',
  },
  getLinkedTransactions: {
    comment: 'Retrieves linked transactions (billable expenses)',
    doc: 'Retrieves linked transactions (billable expenses)',
  },
  createLinkedTransaction: {
    comment: 'Creates linked transactions (billable expenses)',
    doc: 'Creates linked transactions (billable expenses)',
  },
  deleteLinkedTransaction: {
    comment: 'Deletes a specific linked transactions (billable expenses)',
    doc: 'Deletes a specific linked transactions (billable expenses)',
  },
  getLinkedTransaction: {
    comment: 'Retrieves a specific linked transaction (billable expenses) using a unique linked transaction Id',
    doc: 'Retrieves a specific linked transaction (billable expenses) using a unique linked transaction Id',
  },
  updateLinkedTransaction: {
    comment: 'Updates a specific linked transactions (billable expenses)',
    doc: 'Updates a specific linked transactions (billable expenses)',
  },
  getManualJournals: {
    comment: 'Retrieves manual journals',
    doc: 'Retrieves manual journals',
  },
  updateOrCreateManualJournals: {
    comment: 'Updates or creates a single manual journal',
    doc: 'Updates or creates a single manual journal',
  },
  createManualJournals: {
    comment: 'Creates one or more manual journals',
    doc: 'Creates one or more manual journals',
  },
  getManualJournal: {
    comment: 'Retrieves a specific manual journal',
    doc: 'Retrieves a specific manual journal',
  },
  updateManualJournal: {
    comment: 'Updates a specific manual journal',
    doc: 'Updates a specific manual journal',
  },
  getManualJournalAttachments: {
    comment: 'Retrieves attachment for a specific manual journal',
    doc: 'Retrieves attachment for a specific manual journal',
  },
  getManualJournalAttachmentById: {
    comment: 'Allows you to retrieve a specific attachment from a specific manual journal using a unique attachment Id',
    doc: 'Allows you to retrieve a specific attachment from a specific manual journal using a unique attachment Id',
  },
  getManualJournalAttachmentByFileName: {
    comment: 'Retrieves a specific attachment from a specific manual journal by file name',
    doc: 'Retrieves a specific attachment from a specific manual journal by file name',
  },
  updateManualJournalAttachmentByFileName: {
    comment: 'Updates a specific attachment from a specific manual journal by file name',
    doc: 'Updates a specific attachment from a specific manual journal by file name',
  },
  createManualJournalAttachmentByFileName: {
    comment: 'Creates a specific attachment for a specific manual journal by file name',
    doc: 'Creates a specific attachment for a specific manual journal by file name',
  },
  getManualJournalsHistory: {
    comment: 'Retrieves history for a specific manual journal',
    doc: 'Retrieves history for a specific manual journal',
  },
  createManualJournalHistoryRecord: {
    comment: 'Creates a history record for a specific manual journal',
    doc: 'Creates a history record for a specific manual journal',
  },
  getOrganisations: {
    comment: 'Retrieves Xero organisation details',
    doc: 'Retrieves Xero organisation details',
  },
  getOrganisationActions: {
    comment:
      'Retrieves a list of the key actions your app has permission to perform in the connected Xero organisation.',
    doc: 'Retrieves a list of the key actions your app has permission to perform in the connected Xero organisation.',
  },
  getOrganisationCisSettings: {
    comment: 'Retrieves the CIS settings for the Xero organistaion.',
    doc: 'Retrieves the CIS settings for the Xero organistaion.',
  },
  getOverpayments: {
    comment: 'Retrieves overpayments',
    doc: 'Retrieves overpayments',
  },
  getOverpayment: {
    comment: 'Retrieves a specific overpayment using a unique overpayment Id',
    doc: 'Retrieves a specific overpayment using a unique overpayment Id',
  },
  createOverpaymentAllocations: {
    comment: 'Creates a single allocation for a specific overpayment',
    doc: 'Creates a single allocation for a specific overpayment',
  },
  getOverpaymentHistory: {
    comment: 'Retrieves history records of a specific overpayment',
    doc: 'Retrieves history records of a specific overpayment',
  },
  createOverpaymentHistory: {
    comment: 'Creates a history record for a specific overpayment',
    doc: 'Creates a history record for a specific overpayment',
  },
  getPaymentServices: {
    comment: 'Retrieves payment services',
    doc: 'Retrieves payment services',
  },
  createPaymentService: {
    comment: 'Creates a payment service',
    doc: 'Creates a payment service',
  },
  getPayments: {
    comment: 'Retrieves payments for invoices and credit notes',
    doc: 'Retrieves payments for invoices and credit notes',
  },
  createPayment: {
    comment: 'Creates a single payment for invoice or credit notes',
    doc: 'Creates a single payment for invoice or credit notes',
  },
  createPayments: {
    comment: 'Creates multiple payments for invoices or credit notes',
    doc: 'Creates multiple payments for invoices or credit notes',
  },
  getPayment: {
    comment: 'Retrieves a specific payment for invoices and credit notes using a unique payment Id',
    doc: 'Retrieves a specific payment for invoices and credit notes using a unique payment Id',
  },
  deletePayment: {
    comment: 'Updates a specific payment for invoices and credit notes',
    doc: 'Updates a specific payment for invoices and credit notes',
  },
  getPaymentHistory: {
    comment: 'Retrieves history records of a specific payment',
    doc: 'Retrieves history records of a specific payment',
  },
  createPaymentHistory: {
    comment: 'Creates a history record for a specific payment',
    doc: 'Creates a history record for a specific payment',
  },
  getPrepayments: {
    comment: 'Retrieves prepayments',
    doc: 'Retrieves prepayments',
  },
  getPrepayment: {
    comment: 'Allows you to retrieve a specified prepayments',
    doc: 'Allows you to retrieve a specified prepayments',
  },
  createPrepaymentAllocations: {
    comment: 'Allows you to create an Allocation for prepayments',
    doc: 'Allows you to create an Allocation for prepayments',
  },
  getPrepaymentHistory: {
    comment: 'Retrieves history record for a specific prepayment',
    doc: 'Retrieves history record for a specific prepayment',
  },
  createPrepaymentHistory: {
    comment: 'Creates a history record for a specific prepayment',
    doc: 'Creates a history record for a specific prepayment',
  },
  getPurchaseOrders: {
    comment: 'Retrieves purchase orders',
    doc: 'Retrieves purchase orders',
  },
  updateOrCreatePurchaseOrders: {
    comment: 'Updates or creates one or more purchase orders',
    doc: 'Updates or creates one or more purchase orders',
  },
  createPurchaseOrders: {
    comment: 'Creates one or more purchase orders',
    doc: 'Creates one or more purchase orders',
  },
  getPurchaseOrder: {
    comment: 'Retrieves a specific purchase order using a unique purchase order Id',
    doc: 'Retrieves a specific purchase order using a unique purchase order Id',
  },
  updatePurchaseOrder: {
    comment: 'Updates a specific purchase order',
    doc: 'Updates a specific purchase order',
  },
  getPurchaseOrderAttachments: {
    comment: 'Retrieves attachments for a specific purchase order',
    doc: 'Retrieves attachments for a specific purchase order',
  },
  getPurchaseOrderAttachmentById: {
    comment: 'Retrieves specific attachment for a specific purchase order using a unique attachment Id',
    doc: 'Retrieves specific attachment for a specific purchase order using a unique attachment Id',
  },
  getPurchaseOrderAttachmentByFileName: {
    comment: 'Retrieves a specific attachment for a specific purchase order by filename',
    doc: 'Retrieves a specific attachment for a specific purchase order by filename',
  },
  updatePurchaseOrderAttachmentByFileName: {
    comment: 'Updates a specific attachment for a specific purchase order by filename',
    doc: 'Updates a specific attachment for a specific purchase order by filename',
  },
  createPurchaseOrderAttachmentByFileName: {
    comment: 'Creates attachment for a specific purchase order',
    doc: 'Creates attachment for a specific purchase order',
  },
  getPurchaseOrderHistory: {
    comment: 'Retrieves history for a specific purchase order',
    doc: 'Retrieves history for a specific purchase order',
  },
  createPurchaseOrderHistory: {
    comment: 'Creates a history record for a specific purchase orders',
    doc: 'Creates a history record for a specific purchase orders',
  },
  getPurchaseOrderAsPdf: {
    comment: 'Retrieves specific purchase order as PDF files using a unique purchase order Id',
    doc: 'Retrieves specific purchase order as PDF files using a unique purchase order Id',
  },
  getPurchaseOrderByNumber: {
    comment: 'Retrieves a specific purchase order using purchase order number',
    doc: 'Retrieves a specific purchase order using purchase order number',
  },
  getQuotes: {
    comment: 'Retrieves sales quotes',
    doc: 'Retrieves sales quotes',
  },
  updateOrCreateQuotes: {
    comment: 'Updates or creates one or more quotes',
    doc: 'Updates or creates one or more quotes',
  },
  createQuotes: {
    comment: 'Create one or more quotes',
    doc: 'Create one or more quotes',
  },
  getQuote: {
    comment: 'Retrieves a specific quote using a unique quote Id',
    doc: 'Retrieves a specific quote using a unique quote Id',
  },
  updateQuote: {
    comment: 'Updates a specific quote',
    doc: 'Updates a specific quote',
  },
  getQuoteAttachments: {
    comment: 'Retrieves attachments for a specific quote',
    doc: 'Retrieves attachments for a specific quote',
  },
  getQuoteAttachmentById: {
    comment: 'Retrieves a specific attachment from a specific quote using a unique attachment Id',
    doc: 'Retrieves a specific attachment from a specific quote using a unique attachment Id',
  },
  getQuoteAttachmentByFileName: {
    comment: 'Retrieves a specific attachment from a specific quote by filename',
    doc: 'Retrieves a specific attachment from a specific quote by filename',
  },
  updateQuoteAttachmentByFileName: {
    comment: 'Updates a specific attachment from a specific quote by filename',
    doc: 'Updates a specific attachment from a specific quote by filename',
  },
  createQuoteAttachmentByFileName: {
    comment: 'Creates attachment for a specific quote',
    doc: 'Creates attachment for a specific quote',
  },
  getQuoteHistory: {
    comment: 'Retrieves history records of a specific quote',
    doc: 'Retrieves history records of a specific quote',
  },
  createQuoteHistory: {
    comment: 'Creates a history record for a specific quote',
    doc: 'Creates a history record for a specific quote',
  },
  getQuoteAsPdf: {
    comment: 'Retrieves a specific quote as a PDF file using a unique quote Id',
    doc: 'Retrieves a specific quote as a PDF file using a unique quote Id',
  },
  getReceipts: {
    comment: 'Retrieves draft expense claim receipts for any user',
    doc: 'Retrieves draft expense claim receipts for any user',
  },
  createReceipt: {
    comment: 'Creates draft expense claim receipts for any user',
    doc: 'Creates draft expense claim receipts for any user',
  },
  getReceipt: {
    comment: 'Retrieves a specific draft expense claim receipt by using a unique receipt Id',
    doc: 'Retrieves a specific draft expense claim receipt by using a unique receipt Id',
  },
  updateReceipt: {
    comment: 'Updates a specific draft expense claim receipts',
    doc: 'Updates a specific draft expense claim receipts',
  },
  getReceiptAttachments: {
    comment: 'Retrieves attachments for a specific expense claim receipt',
    doc: 'Retrieves attachments for a specific expense claim receipt',
  },
  getReceiptAttachmentById: {
    comment: 'Retrieves a specific attachments from a specific expense claim receipts by using a unique attachment Id',
    doc: 'Retrieves a specific attachments from a specific expense claim receipts by using a unique attachment Id',
  },
  getReceiptAttachmentByFileName: {
    comment: 'Retrieves a specific attachment from a specific expense claim receipts by file name',
    doc: 'Retrieves a specific attachment from a specific expense claim receipts by file name',
  },
  updateReceiptAttachmentByFileName: {
    comment: 'Updates a specific attachment on a specific expense claim receipts by file name',
    doc: 'Updates a specific attachment on a specific expense claim receipts by file name',
  },
  createReceiptAttachmentByFileName: {
    comment: 'Creates an attachment on a specific expense claim receipts by file name',
    doc: 'Creates an attachment on a specific expense claim receipts by file name',
  },
  getReceiptHistory: {
    comment: 'Retrieves a history record for a specific receipt',
    doc: 'Retrieves a history record for a specific receipt',
  },
  createReceiptHistory: {
    comment: 'Creates a history record for a specific receipt',
    doc: 'Creates a history record for a specific receipt',
  },
  getRepeatingInvoices: {
    comment: 'Retrieves repeating invoices',
    doc: 'Retrieves repeating invoices',
  },
  getRepeatingInvoice: {
    comment: 'Retrieves a specific repeating invoice by using a unique repeating invoice Id',
    doc: 'Retrieves a specific repeating invoice by using a unique repeating invoice Id',
  },
  getRepeatingInvoiceAttachments: {
    comment: 'Retrieves attachments from a specific repeating invoice',
    doc: 'Retrieves attachments from a specific repeating invoice',
  },
  getRepeatingInvoiceAttachmentById: {
    comment: 'Retrieves a specific attachment from a specific repeating invoice',
    doc: 'Retrieves a specific attachment from a specific repeating invoice',
  },
  getRepeatingInvoiceAttachmentByFileName: {
    comment: 'Retrieves a specific attachment from a specific repeating invoices by file name',
    doc: 'Retrieves a specific attachment from a specific repeating invoices by file name',
  },
  updateRepeatingInvoiceAttachmentByFileName: {
    comment: 'Updates a specific attachment from a specific repeating invoices by file name',
    doc: 'Updates a specific attachment from a specific repeating invoices by file name',
  },
  createRepeatingInvoiceAttachmentByFileName: {
    comment: 'Creates an attachment from a specific repeating invoices by file name',
    doc: 'Creates an attachment from a specific repeating invoices by file name',
  },
  getRepeatingInvoiceHistory: {
    comment: 'Retrieves history record for a specific repeating invoice',
    doc: 'Retrieves history record for a specific repeating invoice',
  },
  createRepeatingInvoiceHistory: {
    comment: 'Creates a  history record for a specific repeating invoice',
    doc: 'Creates a  history record for a specific repeating invoice',
  },
  getReportBaSorGstList: {
    comment: 'Retrieves report for BAS (only valid for AU orgs)',
    doc: 'Retrieves report for BAS (only valid for AU orgs)',
  },
  getReportAgedPayablesByContact: {
    comment: 'Retrieves report for aged payables by contact',
    doc: 'Retrieves report for aged payables by contact',
  },
  getReportAgedReceivablesByContact: {
    comment: 'Retrieves report for aged receivables by contact',
    doc: 'Retrieves report for aged receivables by contact',
  },
  getReportBalanceSheet: {
    comment: 'Retrieves report for balancesheet',
    doc: 'Retrieves report for balancesheet',
  },
  getReportBankSummary: {
    comment: 'Retrieves report for bank summary',
    doc: 'Retrieves report for bank summary',
  },
  getReportBudgetSummary: {
    comment: 'Retrieves report for budget summary',
    doc: 'Retrieves report for budget summary',
  },
  getReportExecutiveSummary: {
    comment: 'Retrieves report for executive summary',
    doc: 'Retrieves report for executive summary',
  },
  getReportProfitAndLoss: {
    comment: 'Retrieves report for profit and loss',
    doc: 'Retrieves report for profit and loss',
  },
  getReportTenNinetyNine: {
    comment: 'Retrieve reports for 1099',
    doc: 'Retrieve reports for 1099',
  },
  getReportTrialBalance: {
    comment: 'Retrieves report for trial balance',
    doc: 'Retrieves report for trial balance',
  },
  getReportBaSorGst: {
    comment: 'Retrieves a specific report for BAS using a unique report Id (only valid for AU orgs)',
    doc: 'Retrieves a specific report for BAS using a unique report Id (only valid for AU orgs)',
  },
  postSetup: {
    comment: 'Sets the chart of accounts, the conversion date and conversion balances',
    doc: 'Sets the chart of accounts, the conversion date and conversion balances',
  },
  getTaxRates: {
    comment: 'Retrieves tax rates',
    doc: 'Retrieves tax rates',
  },
  updateTaxRate: {
    comment: 'Updates tax rates',
    doc: 'Updates tax rates',
  },
  createTaxRates: {
    comment: 'Creates one or more tax rates',
    doc: 'Creates one or more tax rates',
  },
  getTrackingCategories: {
    comment: 'Retrieves tracking categories and options',
    doc: 'Retrieves tracking categories and options',
  },
  createTrackingCategory: {
    comment: 'Create tracking categories',
    doc: 'Create tracking categories',
  },
  deleteTrackingCategory: {
    comment: 'Deletes a specific tracking category',
    doc: 'Deletes a specific tracking category',
  },
  getTrackingCategory: {
    comment: 'Retrieves specific tracking categories and options using a unique tracking category Id',
    doc: 'Retrieves specific tracking categories and options using a unique tracking category Id',
  },
  updateTrackingCategory: {
    comment: 'Updates a specific tracking category',
    doc: 'Updates a specific tracking category',
  },
  createTrackingOptions: {
    comment: 'Creates options for a specific tracking category',
    doc: 'Creates options for a specific tracking category',
  },
  deleteTrackingOptions: {
    comment: 'Deletes a specific option for a specific tracking category',
    doc: 'Deletes a specific option for a specific tracking category',
  },
  updateTrackingOptions: {
    comment: 'Updates a specific option for a specific tracking category',
    doc: 'Updates a specific option for a specific tracking category',
  },
  getUsers: {
    comment: 'Retrieves users',
    doc: 'Retrieves users',
  },
  getUser: {
    comment: 'Retrieves a specific user',
    doc: 'Retrieves a specific user',
  },
};
