// Generated by ts-to-zod
import { z } from 'zod';

export const problemSchema = z.object({
  detail: z.string().optional(),
  status: z.number().optional(),
  title: z.string(),
  type: z.string(),
});

export const aggregateSchema = z.number();

export const blockUserMutationResponseSchema = z.object({
  data: z
    .object({
      blocking: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const userIdSchema = z.string();

export const tweetIdSchema = z.string();

export const bookmarkMutationResponseSchema = z.object({
  data: z
    .object({
      bookmarked: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const entityIndicesInclusiveExclusiveSchema = z.object({
  end: z.number(),
  start: z.number(),
});

export const cashtagFieldsSchema = z.object({
  tag: z.string(),
});

export const clientDisconnectedProblemSchema = problemSchema;

export const clientForbiddenProblemSchema = problemSchema.and(
  z.object({
    reason: z.union([z.literal('official-client-forbidden'), z.literal('client-not-enrolled')]).optional(),
    registration_url: z.string().optional(),
  }),
);

export const reasonSchema = z.union([z.literal('official-client-forbidden'), z.literal('client-not-enrolled')]);

export const createdAtSchema = z.string();

export const downloadExpirationSchema = z.string();

export const downloadUrlSchema = z.string();

export const jobIdSchema = z.string();

export const complianceJobNameSchema = z.string();

export const complianceJobStatusSchema = z.union([
  z.literal('created'),
  z.literal('in_progress'),
  z.literal('failed'),
  z.literal('complete'),
  z.literal('expired'),
]);

export const complianceJobTypeSchema = z.union([z.literal('tweets'), z.literal('users')]);

export const uploadExpirationSchema = z.string();

export const uploadUrlSchema = z.string();

export const conflictProblemSchema = problemSchema;

export const connectionExceptionProblemSchema = problemSchema.and(
  z.object({
    connection_issue: z
      .union([
        z.literal('TooManyConnections'),
        z.literal('ProvisioningSubscription'),
        z.literal('RuleConfigurationIssue'),
        z.literal('RulesInvalidIssue'),
      ])
      .optional(),
  }),
);

export const connectionIssueSchema = z.union([
  z.literal('TooManyConnections'),
  z.literal('ProvisioningSubscription'),
  z.literal('RuleConfigurationIssue'),
  z.literal('RulesInvalidIssue'),
]);

export const contextAnnotationDomainFieldsSchema = z.object({
  description: z.string().optional(),
  id: z.string(),
  name: z.string().optional(),
});

export const contextAnnotationEntityFieldsSchema = z.object({
  description: z.string().optional(),
  id: z.string(),
  name: z.string().optional(),
});

export const countryCodeSchema = z.string();

export const createComplianceJobRequestSchema = z.object({
  name: complianceJobNameSchema.optional(),
  resumable: z.boolean().optional(),
  type: z.union([z.literal('tweets'), z.literal('users')]),
});

export const typeSchema = z.union([z.literal('tweets'), z.literal('users')]);

export const complianceJobSchema = z.object({
  created_at: createdAtSchema,
  download_expires_at: downloadExpirationSchema,
  download_url: downloadUrlSchema,
  id: jobIdSchema,
  name: complianceJobNameSchema.optional(),
  status: complianceJobStatusSchema,
  type: complianceJobTypeSchema,
  upload_expires_at: uploadExpirationSchema,
  upload_url: uploadUrlSchema,
});

export const dmParticipantsSchema = z.array(userIdSchema);

export const conversationTypeSchema = z.literal('Group');

export const dmConversationIdSchema = z.string();

export const dmEventIdSchema = z.string();

export const ruleIdSchema = z.string();

export const ruleValueSchema = z.string();

export const disallowedResourceProblemSchema = problemSchema.and(
  z.object({
    resource_id: z.string(),
    resource_type: z.union([
      z.literal('user'),
      z.literal('tweet'),
      z.literal('media'),
      z.literal('list'),
      z.literal('space'),
    ]),
    section: z.union([z.literal('data'), z.literal('includes')]),
  }),
);

export const resourceTypeSchema = z.union([
  z.literal('user'),
  z.literal('tweet'),
  z.literal('media'),
  z.literal('list'),
  z.literal('space'),
]);

export const sectionSchema = z.union([z.literal('data'), z.literal('includes')]);

export const mediaKeySchema = z.string();

export const mediaIdSchema = z.string();

export const duplicateRuleProblemSchema = problemSchema.and(
  z.object({
    id: z.string().optional(),
    value: z.string().optional(),
  }),
);

export const endSchema = z.string();

export const entityIndicesInclusiveInclusiveSchema = z.object({
  end: z.number(),
  start: z.number(),
});

export const errorSchema = z.object({
  code: z.number(),
  message: z.string(),
});

export const fieldUnauthorizedProblemSchema = problemSchema.and(
  z.object({
    field: z.string(),
    resource_type: z.union([
      z.literal('user'),
      z.literal('tweet'),
      z.literal('media'),
      z.literal('list'),
      z.literal('space'),
    ]),
    section: z.union([z.literal('data'), z.literal('includes')]),
  }),
);

export const ruleTagSchema = z.string();

export const cashtagEntitySchema = entityIndicesInclusiveExclusiveSchema.and(cashtagFieldsSchema);

export const genericProblemSchema = problemSchema;

export const type2Schema = z.literal('Feature');

export const get2ComplianceJobsIdResponseSchema = z.object({
  data: complianceJobSchema.optional(),
  errors: z.array(problemSchema).optional(),
});

export const resultCountSchema = z.number();

export const dmEventSchema = z.object({
  attachments: z
    .object({
      card_ids: z.array(z.string()).optional(),
      media_keys: z.array(mediaKeySchema).optional(),
    })
    .optional(),
  created_at: z.string().optional(),
  dm_conversation_id: dmConversationIdSchema.optional(),
  event_type: z.string(),
  id: dmEventIdSchema,
  participant_ids: z.array(userIdSchema).optional(),
  referenced_tweets: z
    .array(
      z.object({
        id: tweetIdSchema,
      }),
    )
    .optional(),
  sender_id: userIdSchema.optional(),
  text: z.string().optional(),
});

export const nextTokenSchema = z.string();

export const previousTokenSchema = z.string();

export const newestIdSchema = z.string();

export const oldestIdSchema = z.string();

export const hashtagFieldsSchema = z.object({
  tag: z.string(),
});

export const httpStatusCodeSchema = z.number();

export const invalidRequestProblemSchema = problemSchema.and(
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
          parameters: z.record(z.array(z.string())).optional(),
        }),
      )
      .optional(),
  }),
);

export const invalidRuleProblemSchema = problemSchema;

export const listIdSchema = z.string();

export const listAddUserRequestSchema = z.object({
  user_id: userIdSchema,
});

export const listCreateRequestSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  private: z.boolean().optional(),
});

export const listCreateResponseSchema = z.object({
  data: z
    .object({
      id: listIdSchema,
      name: z.string(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const listDeleteResponseSchema = z.object({
  data: z
    .object({
      deleted: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const listFollowedRequestSchema = z.object({
  list_id: listIdSchema,
});

export const listFollowedResponseSchema = z.object({
  data: z
    .object({
      following: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const listMutateResponseSchema = z.object({
  data: z
    .object({
      is_member: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const listPinnedRequestSchema = z.object({
  list_id: listIdSchema,
});

export const listPinnedResponseSchema = z.object({
  data: z
    .object({
      pinned: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const listUnpinResponseSchema = z.object({
  data: z
    .object({
      pinned: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const listUpdateRequestSchema = z.object({
  description: z.string().optional(),
  name: z.string().optional(),
  private: z.boolean().optional(),
});

export const listUpdateResponseSchema = z.object({
  data: z
    .object({
      updated: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const mediaHeightSchema = z.number();

export const mediaWidthSchema = z.number();

export const userNameSchema = z.string();

export const muteUserMutationResponseSchema = z.object({
  data: z
    .object({
      muting: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const muteUserRequestSchema = z.object({
  target_user_id: userIdSchema,
});

export const nonCompliantRulesProblemSchema = problemSchema;

export const oauth1PermissionsProblemSchema = problemSchema;

export const operationalDisconnectProblemSchema = problemSchema.and(
  z.object({
    disconnect_type: z
      .union([
        z.literal('OperationalDisconnect'),
        z.literal('UpstreamOperationalDisconnect'),
        z.literal('ForceDisconnect'),
        z.literal('UpstreamUncleanDisconnect'),
        z.literal('SlowReader'),
        z.literal('InternalError'),
        z.literal('ClientApplicationStateDegraded'),
        z.literal('InvalidRules'),
      ])
      .optional(),
  }),
);

export const disconnectTypeSchema = z.union([
  z.literal('OperationalDisconnect'),
  z.literal('UpstreamOperationalDisconnect'),
  z.literal('ForceDisconnect'),
  z.literal('UpstreamUncleanDisconnect'),
  z.literal('SlowReader'),
  z.literal('InternalError'),
  z.literal('ClientApplicationStateDegraded'),
  z.literal('InvalidRules'),
]);

export const paginationToken32Schema = z.string();

export const paginationToken36Schema = z.string();

export const paginationTokenLongSchema = z.string();

export const mediaSchema = z.object({
  height: mediaHeightSchema.optional(),
  media_key: mediaKeySchema.optional(),
  type: z.string(),
  width: mediaWidthSchema.optional(),
});

export const placeIdSchema = z.string();

export const placeTypeSchema = z.union([
  z.literal('poi'),
  z.literal('neighborhood'),
  z.literal('city'),
  z.literal('admin'),
  z.literal('country'),
  z.literal('unknown'),
]);

export const positionSchema = z.tuple([z.number(), z.number()]);

export const type3Schema = z.literal('Point');

export const pollIdSchema = z.string();

export const votingStatusSchema = z.union([z.literal('open'), z.literal('closed')]);

export const pollOptionLabelSchema = z.string();

export const replySettingsSchema = z.union([z.literal('following'), z.literal('mentionedUsers')]);

export const resourceNotFoundProblemSchema = problemSchema.and(
  z.object({
    parameter: z.string(),
    resource_id: z.string(),
    resource_type: z.union([
      z.literal('user'),
      z.literal('tweet'),
      z.literal('media'),
      z.literal('list'),
      z.literal('space'),
    ]),
    value: z.string(),
  }),
);

export const resourceUnauthorizedProblemSchema = problemSchema.and(
  z.object({
    parameter: z.string(),
    resource_id: z.string(),
    resource_type: z.union([
      z.literal('user'),
      z.literal('tweet'),
      z.literal('media'),
      z.literal('list'),
      z.literal('space'),
    ]),
    section: z.union([z.literal('data'), z.literal('includes')]),
    value: z.string(),
  }),
);

export const resourceUnavailableProblemSchema = problemSchema.and(
  z.object({
    parameter: z.string(),
    resource_id: z.string(),
    resource_type: z.union([
      z.literal('user'),
      z.literal('tweet'),
      z.literal('media'),
      z.literal('list'),
      z.literal('space'),
    ]),
  }),
);

export const ruleSchema = z.object({
  id: ruleIdSchema.optional(),
  tag: ruleTagSchema.optional(),
  value: ruleValueSchema,
});

export const ruleNoIdSchema = z.object({
  tag: ruleTagSchema.optional(),
  value: ruleValueSchema,
});

export const rulesCapProblemSchema = problemSchema;

export const rulesRequestSummarySchema = z.union([
  z.object({
    created: z.number(),
    invalid: z.number(),
    not_created: z.number(),
    valid: z.number(),
  }),
  z.object({
    deleted: z.number(),
    not_deleted: z.number(),
  }),
]);

export const rulesResponseMetadataSchema = z.object({
  next_token: nextTokenSchema.optional(),
  result_count: z.number().optional(),
  sent: z.string(),
  summary: rulesRequestSummarySchema.optional(),
});

export const startSchema = z.string();

export const tweetCountSchema = z.number();

export const spaceIdSchema = z.string();

export const stateSchema = z.union([z.literal('live'), z.literal('scheduled'), z.literal('ended')]);

export const topicIdSchema = z.string();

export const contextAnnotationSchema = z.object({
  domain: contextAnnotationDomainFieldsSchema,
  entity: contextAnnotationEntityFieldsSchema,
});

export const pointSchema = z.object({
  coordinates: positionSchema,
  type: z.literal('Point'),
});

export const tweetTextSchema = z.string();

export const tweetWithheldSchema = z.object({
  copyright: z.boolean(),
  country_codes: z.array(countryCodeSchema),
  scope: z.union([z.literal('tweet'), z.literal('user')]).optional(),
});

export const tweetComplianceSchemaSchema = z.object({
  event_at: z.string(),
  quote_tweet_id: tweetIdSchema.optional(),
  tweet: z.object({
    author_id: userIdSchema,
    id: tweetIdSchema,
  }),
});

export const tweetCreateRequestSchema = z.object({
  card_uri: z.string().optional(),
  direct_message_deep_link: z.string().optional(),
  for_super_followers_only: z.boolean().optional(),
  geo: z
    .object({
      place_id: z.string().optional(),
    })
    .optional(),
  media: z
    .object({
      media_ids: z.array(mediaIdSchema),
      tagged_user_ids: z.array(userIdSchema).optional(),
    })
    .optional(),
  nullcast: z.boolean().optional(),
  poll: z
    .object({
      duration_minutes: z.number(),
      options: z.array(z.string()),
      reply_settings: z.union([z.literal('following'), z.literal('mentionedUsers')]).optional(),
    })
    .optional(),
  quote_tweet_id: tweetIdSchema.optional(),
  reply: z
    .object({
      exclude_reply_user_ids: z.array(userIdSchema).optional(),
      in_reply_to_tweet_id: tweetIdSchema,
    })
    .optional(),
  reply_settings: z.union([z.literal('following'), z.literal('mentionedUsers')]).optional(),
  text: tweetTextSchema.optional(),
});

export const tweetCreateResponseSchema = z.object({
  data: z
    .object({
      id: tweetIdSchema,
      text: tweetTextSchema,
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const tweetDeleteComplianceSchemaSchema = z.object({
  delete: tweetComplianceSchemaSchema,
});

export const tweetDeleteResponseSchema = z.object({
  data: z
    .object({
      deleted: z.boolean(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const tweetDropComplianceSchemaSchema = z.object({
  drop: tweetComplianceSchemaSchema,
});

export const tweetEditComplianceObjectSchemaSchema = z.object({
  edit_tweet_ids: z.array(tweetIdSchema),
  event_at: z.string(),
  initial_tweet_id: tweetIdSchema,
  tweet: z.object({
    id: tweetIdSchema,
  }),
});

export const tweetEditComplianceSchemaSchema = z.object({
  tweet_edit: tweetEditComplianceObjectSchemaSchema,
});

export const tweetHideRequestSchema = z.object({
  hidden: z.boolean(),
});

export const tweetHideResponseSchema = z.object({
  data: z
    .object({
      hidden: z.boolean().optional(),
    })
    .optional(),
});

export const tweetNoticeSchema = z.object({
  application: z.string(),
  details: z.string().optional(),
  event_at: z.string(),
  event_type: z.string(),
  extended_details_url: z.string().optional(),
  label_title: z.string().optional(),
  tweet: z.object({
    author_id: userIdSchema,
    id: tweetIdSchema,
  }),
});

export const tweetNoticeSchemaSchema = z.object({
  public_tweet_notice: tweetNoticeSchema,
});

export const tweetTakedownComplianceSchemaSchema = z.object({
  event_at: z.string(),
  quote_tweet_id: tweetIdSchema.optional(),
  tweet: z.object({
    author_id: userIdSchema,
    id: tweetIdSchema,
  }),
  withheld_in_countries: z.array(countryCodeSchema),
});

export const tweetUndropComplianceSchemaSchema = z.object({
  undrop: tweetComplianceSchemaSchema,
});

export const tweetUnviewableSchema = z.object({
  application: z.string(),
  event_at: z.string(),
  tweet: z.object({
    author_id: userIdSchema,
    id: tweetIdSchema,
  }),
});

export const tweetUnviewableSchemaSchema = z.object({
  public_tweet_unviewable: tweetUnviewableSchema,
});

export const scopeSchema = z.union([z.literal('tweet'), z.literal('user')]);

export const tweetWithheldComplianceSchemaSchema = z.object({
  withheld: tweetTakedownComplianceSchemaSchema,
});

export const unsupportedAuthenticationProblemSchema = problemSchema;

export const urlSchema = z.string();

export const urlImageSchema = z.object({
  height: mediaHeightSchema.optional(),
  url: urlSchema.optional(),
  width: mediaWidthSchema.optional(),
});

export const usageCapExceededProblemSchema = problemSchema.and(
  z.object({
    period: z.union([z.literal('Daily'), z.literal('Monthly')]).optional(),
    scope: z.union([z.literal('Account'), z.literal('Product')]).optional(),
  }),
);

export const periodSchema = z.union([z.literal('Daily'), z.literal('Monthly')]);

export const scope2Schema = z.union([z.literal('Account'), z.literal('Product')]);

export const userWithheldSchema = z.object({
  country_codes: z.array(countryCodeSchema),
  scope: z.literal('user').optional(),
});

export const userComplianceSchemaSchema = z.object({
  event_at: z.string(),
  user: z.object({
    id: userIdSchema,
  }),
});

export const userDeleteComplianceSchemaSchema = z.object({
  user_delete: userComplianceSchemaSchema,
});

export const userIdMatchesAuthenticatedUserSchema = z.string();

export const userProfileModificationObjectSchemaSchema = z.object({
  event_at: z.string(),
  new_value: z.string(),
  profile_field: z.string(),
  user: z.object({
    id: userIdSchema,
  }),
});

export const userProtectComplianceSchemaSchema = z.object({
  user_protect: userComplianceSchemaSchema,
});

export const userScrubGeoObjectSchemaSchema = z.object({
  event_at: z.string(),
  up_to_tweet_id: tweetIdSchema,
  user: z.object({
    id: userIdSchema,
  }),
});

export const userScrubGeoSchemaSchema = z.object({
  scrub_geo: userScrubGeoObjectSchemaSchema,
});

export const userSuspendComplianceSchemaSchema = z.object({
  user_suspend: userComplianceSchemaSchema,
});

export const userTakedownComplianceSchemaSchema = z.object({
  event_at: z.string(),
  user: z.object({
    id: userIdSchema,
  }),
  withheld_in_countries: z.array(countryCodeSchema),
});

export const userUndeleteComplianceSchemaSchema = z.object({
  user_undelete: userComplianceSchemaSchema,
});

export const userUnprotectComplianceSchemaSchema = z.object({
  user_unprotect: userComplianceSchemaSchema,
});

export const userUnsuspendComplianceSchemaSchema = z.object({
  user_unsuspend: userComplianceSchemaSchema,
});

export const scope3Schema = z.literal('user');

export const userWithheldComplianceSchemaSchema = z.object({
  user_withheld: userTakedownComplianceSchemaSchema,
});

export const usersFollowingCreateRequestSchema = z.object({
  target_user_id: userIdSchema,
});

export const usersFollowingCreateResponseSchema = z.object({
  data: z
    .object({
      following: z.boolean().optional(),
      pending_follow: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const usersFollowingDeleteResponseSchema = z.object({
  data: z
    .object({
      following: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const usersLikesCreateRequestSchema = z.object({
  tweet_id: tweetIdSchema,
});

export const usersLikesCreateResponseSchema = z.object({
  data: z
    .object({
      liked: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const usersLikesDeleteResponseSchema = z.object({
  data: z
    .object({
      liked: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const usersRetweetsCreateRequestSchema = z.object({
  tweet_id: tweetIdSchema,
});

export const usersRetweetsCreateResponseSchema = z.object({
  data: z
    .object({
      retweeted: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const usersRetweetsDeleteResponseSchema = z.object({
  data: z
    .object({
      retweeted: z.boolean().optional(),
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const variantSchema = z.object({
  bit_rate: z.number().optional(),
  content_type: z.string().optional(),
  url: z.string().optional(),
});

export const variantsSchema = z.array(variantSchema);

export const videoSchema = mediaSchema.and(
  z.object({
    duration_ms: z.number().optional(),
    non_public_metrics: z
      .object({
        playback_0_count: z.number().optional(),
        playback_100_count: z.number().optional(),
        playback_25_count: z.number().optional(),
        playback_50_count: z.number().optional(),
        playback_75_count: z.number().optional(),
      })
      .optional(),
    organic_metrics: z
      .object({
        playback_0_count: z.number().optional(),
        playback_100_count: z.number().optional(),
        playback_25_count: z.number().optional(),
        playback_50_count: z.number().optional(),
        playback_75_count: z.number().optional(),
        view_count: z.number().optional(),
      })
      .optional(),
    preview_image_url: z.string().optional(),
    promoted_metrics: z
      .object({
        playback_0_count: z.number().optional(),
        playback_100_count: z.number().optional(),
        playback_25_count: z.number().optional(),
        playback_50_count: z.number().optional(),
        playback_75_count: z.number().optional(),
        view_count: z.number().optional(),
      })
      .optional(),
    public_metrics: z
      .object({
        view_count: z.number().optional(),
      })
      .optional(),
    variants: variantsSchema.optional(),
  }),
);

export const parameterComplianceJobFieldsParameterSchema = z.array(
  z.union([
    z.literal('created_at'),
    z.literal('download_expires_at'),
    z.literal('download_url'),
    z.literal('id'),
    z.literal('name'),
    z.literal('resumable'),
    z.literal('status'),
    z.literal('type'),
    z.literal('upload_expires_at'),
    z.literal('upload_url'),
  ]),
);

export const parameterDmConversationFieldsParameterSchema = z.array(z.literal('id'));

export const parameterDmEventExpansionsParameterSchema = z.array(
  z.union([
    z.literal('attachments.media_keys'),
    z.literal('participant_ids'),
    z.literal('referenced_tweets.id'),
    z.literal('sender_id'),
  ]),
);

export const parameterDmEventFieldsParameterSchema = z.array(
  z.union([
    z.literal('attachments'),
    z.literal('created_at'),
    z.literal('dm_conversation_id'),
    z.literal('event_type'),
    z.literal('id'),
    z.literal('participant_ids'),
    z.literal('referenced_tweets'),
    z.literal('sender_id'),
    z.literal('text'),
  ]),
);

export const parameterListExpansionsParameterSchema = z.array(z.literal('owner_id'));

export const parameterListFieldsParameterSchema = z.array(
  z.union([
    z.literal('created_at'),
    z.literal('description'),
    z.literal('follower_count'),
    z.literal('id'),
    z.literal('member_count'),
    z.literal('name'),
    z.literal('owner_id'),
    z.literal('private'),
  ]),
);

export const parameterMediaFieldsParameterSchema = z.array(
  z.union([
    z.literal('alt_text'),
    z.literal('duration_ms'),
    z.literal('height'),
    z.literal('media_key'),
    z.literal('non_public_metrics'),
    z.literal('organic_metrics'),
    z.literal('preview_image_url'),
    z.literal('promoted_metrics'),
    z.literal('public_metrics'),
    z.literal('type'),
    z.literal('url'),
    z.literal('variants'),
    z.literal('width'),
  ]),
);

export const parameterPlaceFieldsParameterSchema = z.array(
  z.union([
    z.literal('contained_within'),
    z.literal('country'),
    z.literal('country_code'),
    z.literal('full_name'),
    z.literal('geo'),
    z.literal('id'),
    z.literal('name'),
    z.literal('place_type'),
  ]),
);

export const parameterPollFieldsParameterSchema = z.array(
  z.union([
    z.literal('duration_minutes'),
    z.literal('end_datetime'),
    z.literal('id'),
    z.literal('options'),
    z.literal('voting_status'),
  ]),
);

export const parameterSearchCountFieldsParameterSchema = z.array(
  z.union([z.literal('end'), z.literal('start'), z.literal('tweet_count')]),
);

export const parameterSpaceExpansionsParameterSchema = z.array(
  z.union([
    z.literal('creator_id'),
    z.literal('host_ids'),
    z.literal('invited_user_ids'),
    z.literal('speaker_ids'),
    z.literal('topic_ids'),
  ]),
);

export const parameterSpaceFieldsParameterSchema = z.array(
  z.union([
    z.literal('created_at'),
    z.literal('creator_id'),
    z.literal('ended_at'),
    z.literal('host_ids'),
    z.literal('id'),
    z.literal('invited_user_ids'),
    z.literal('is_ticketed'),
    z.literal('lang'),
    z.literal('participant_count'),
    z.literal('scheduled_start'),
    z.literal('speaker_ids'),
    z.literal('started_at'),
    z.literal('state'),
    z.literal('subscriber_count'),
    z.literal('title'),
    z.literal('topic_ids'),
    z.literal('updated_at'),
  ]),
);

export const parameterTopicFieldsParameterSchema = z.array(
  z.union([z.literal('description'), z.literal('id'), z.literal('name')]),
);

export const parameterTweetExpansionsParameterSchema = z.array(
  z.union([
    z.literal('attachments.media_keys'),
    z.literal('attachments.poll_ids'),
    z.literal('author_id'),
    z.literal('edit_history_tweet_ids'),
    z.literal('entities.mentions.username'),
    z.literal('geo.place_id'),
    z.literal('in_reply_to_user_id'),
    z.literal('referenced_tweets.id'),
    z.literal('referenced_tweets.id.author_id'),
  ]),
);

export const parameterTweetFieldsParameterSchema = z.array(
  z.union([
    z.literal('attachments'),
    z.literal('author_id'),
    z.literal('context_annotations'),
    z.literal('conversation_id'),
    z.literal('created_at'),
    z.literal('edit_controls'),
    z.literal('edit_history_tweet_ids'),
    z.literal('entities'),
    z.literal('geo'),
    z.literal('id'),
    z.literal('in_reply_to_user_id'),
    z.literal('lang'),
    z.literal('non_public_metrics'),
    z.literal('organic_metrics'),
    z.literal('possibly_sensitive'),
    z.literal('promoted_metrics'),
    z.literal('public_metrics'),
    z.literal('referenced_tweets'),
    z.literal('reply_settings'),
    z.literal('source'),
    z.literal('text'),
    z.literal('withheld'),
  ]),
);

export const parameterUserExpansionsParameterSchema = z.array(z.literal('pinned_tweet_id'));

export const parameterUserFieldsParameterSchema = z.array(
  z.union([
    z.literal('created_at'),
    z.literal('description'),
    z.literal('entities'),
    z.literal('id'),
    z.literal('location'),
    z.literal('name'),
    z.literal('pinned_tweet_id'),
    z.literal('profile_image_url'),
    z.literal('protected'),
    z.literal('public_metrics'),
    z.literal('url'),
    z.literal('username'),
    z.literal('verified'),
    z.literal('verified_type'),
    z.literal('withheld'),
  ]),
);

export const listBatchComplianceJobsDataSchema = z.object({
  query: z.object({
    'compliance_job.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('download_expires_at'),
          z.literal('download_url'),
          z.literal('id'),
          z.literal('name'),
          z.literal('resumable'),
          z.literal('status'),
          z.literal('type'),
          z.literal('upload_expires_at'),
          z.literal('upload_url'),
        ]),
      )
      .optional(),
    status: z
      .union([z.literal('created'), z.literal('in_progress'), z.literal('failed'), z.literal('complete')])
      .optional(),
    type: z.union([z.literal('tweets'), z.literal('users')]),
  }),
});

export const get2ComplianceJobsResponseSchema = z.object({
  data: z.array(complianceJobSchema).optional(),
  errors: z.array(problemSchema).optional(),
  meta: z
    .object({
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const listBatchComplianceJobsErrorSchema = errorSchema;

export const createBatchComplianceJobDataSchema = z.object({
  body: createComplianceJobRequestSchema,
});

export const createComplianceJobResponseSchema = z.object({
  data: complianceJobSchema.optional(),
  errors: z.array(problemSchema).optional(),
});

export const createBatchComplianceJobErrorSchema = errorSchema;

export const getBatchComplianceJobDataSchema = z.object({
  path: z.object({
    id: jobIdSchema,
  }),
  query: z
    .object({
      'compliance_job.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('download_expires_at'),
            z.literal('download_url'),
            z.literal('id'),
            z.literal('name'),
            z.literal('resumable'),
            z.literal('status'),
            z.literal('type'),
            z.literal('upload_expires_at'),
            z.literal('upload_url'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const getBatchComplianceJobResponseSchema = get2ComplianceJobsIdResponseSchema;

export const getBatchComplianceJobErrorSchema = errorSchema;

export const createDmEventResponseSchema = z.object({
  data: z
    .object({
      dm_conversation_id: dmConversationIdSchema,
      dm_event_id: dmEventIdSchema,
    })
    .optional(),
  errors: z.array(problemSchema).optional(),
});

export const dmConversationIdCreateErrorSchema = errorSchema;

export const getDmConversationsWithParticipantIdDmEventsDataSchema = z.object({
  path: z.object({
    participant_id: userIdSchema,
  }),
  query: z
    .object({
      'dm_event.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('created_at'),
            z.literal('dm_conversation_id'),
            z.literal('event_type'),
            z.literal('id'),
            z.literal('participant_ids'),
            z.literal('referenced_tweets'),
            z.literal('sender_id'),
            z.literal('text'),
          ]),
        )
        .optional(),
      event_types: z
        .array(z.union([z.literal('MessageCreate'), z.literal('ParticipantsJoin'), z.literal('ParticipantsLeave')]))
        .optional(),
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('participant_ids'),
            z.literal('referenced_tweets.id'),
            z.literal('sender_id'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      pagination_token: paginationToken32Schema.optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const getDmConversationsWithParticipantIdDmEventsErrorSchema = errorSchema;

export const dmConversationWithUserEventIdCreateResponseSchema = createDmEventResponseSchema;

export const dmConversationWithUserEventIdCreateErrorSchema = errorSchema;

export const dmConversationByIdEventIdCreateResponseSchema = createDmEventResponseSchema;

export const dmConversationByIdEventIdCreateErrorSchema = errorSchema;

export const getDmConversationsIdDmEventsDataSchema = z.object({
  path: z.object({
    id: dmConversationIdSchema,
  }),
  query: z
    .object({
      'dm_event.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('created_at'),
            z.literal('dm_conversation_id'),
            z.literal('event_type'),
            z.literal('id'),
            z.literal('participant_ids'),
            z.literal('referenced_tweets'),
            z.literal('sender_id'),
            z.literal('text'),
          ]),
        )
        .optional(),
      event_types: z
        .array(z.union([z.literal('MessageCreate'), z.literal('ParticipantsJoin'), z.literal('ParticipantsLeave')]))
        .optional(),
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('participant_ids'),
            z.literal('referenced_tweets.id'),
            z.literal('sender_id'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      pagination_token: paginationToken32Schema.optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const getDmConversationsIdDmEventsErrorSchema = errorSchema;

export const getDmEventsDataSchema = z.object({
  query: z
    .object({
      'dm_event.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('created_at'),
            z.literal('dm_conversation_id'),
            z.literal('event_type'),
            z.literal('id'),
            z.literal('participant_ids'),
            z.literal('referenced_tweets'),
            z.literal('sender_id'),
            z.literal('text'),
          ]),
        )
        .optional(),
      event_types: z
        .array(z.union([z.literal('MessageCreate'), z.literal('ParticipantsJoin'), z.literal('ParticipantsLeave')]))
        .optional(),
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('participant_ids'),
            z.literal('referenced_tweets.id'),
            z.literal('sender_id'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      pagination_token: paginationToken32Schema.optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const getDmEventsErrorSchema = errorSchema;

export const listIdCreateDataSchema = z.object({
  body: listCreateRequestSchema.optional(),
});

export const listIdCreateResponseSchema = listCreateResponseSchema;

export const listIdCreateErrorSchema = errorSchema;

export const listIdDeleteDataSchema = z.object({
  path: z.object({
    id: listIdSchema,
  }),
});

export const listIdDeleteResponseSchema = listDeleteResponseSchema;

export const listIdDeleteErrorSchema = errorSchema;

export const listIdGetDataSchema = z.object({
  path: z.object({
    id: listIdSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('owner_id')).optional(),
      'list.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('follower_count'),
            z.literal('id'),
            z.literal('member_count'),
            z.literal('name'),
            z.literal('owner_id'),
            z.literal('private'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const listIdGetErrorSchema = errorSchema;

export const listIdUpdateDataSchema = z.object({
  body: listUpdateRequestSchema.optional(),
  path: z.object({
    id: listIdSchema,
  }),
});

export const listIdUpdateResponseSchema = listUpdateResponseSchema;

export const listIdUpdateErrorSchema = errorSchema;

export const listGetFollowersDataSchema = z.object({
  path: z.object({
    id: listIdSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('pinned_tweet_id')).optional(),
      max_results: z.number().optional(),
      pagination_token: paginationTokenLongSchema.optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const listGetFollowersErrorSchema = errorSchema;

export const listGetMembersDataSchema = z.object({
  path: z.object({
    id: listIdSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('pinned_tweet_id')).optional(),
      max_results: z.number().optional(),
      pagination_token: paginationTokenLongSchema.optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const listGetMembersErrorSchema = errorSchema;

export const listAddMemberDataSchema = z.object({
  body: listAddUserRequestSchema.optional(),
  path: z.object({
    id: listIdSchema,
  }),
});

export const listAddMemberResponseSchema = listMutateResponseSchema;

export const listAddMemberErrorSchema = errorSchema;

export const listRemoveMemberDataSchema = z.object({
  path: z.object({
    id: listIdSchema,
    user_id: userIdSchema,
  }),
});

export const listRemoveMemberResponseSchema = listMutateResponseSchema;

export const listRemoveMemberErrorSchema = errorSchema;

export const listsIdTweetsDataSchema = z.object({
  path: z.object({
    id: listIdSchema,
  }),
  query: z
    .object({
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('attachments.poll_ids'),
            z.literal('author_id'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities.mentions.username'),
            z.literal('geo.place_id'),
            z.literal('in_reply_to_user_id'),
            z.literal('referenced_tweets.id'),
            z.literal('referenced_tweets.id.author_id'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      pagination_token: paginationToken36Schema.optional(),
      'place.fields': z
        .array(
          z.union([
            z.literal('contained_within'),
            z.literal('country'),
            z.literal('country_code'),
            z.literal('full_name'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('name'),
            z.literal('place_type'),
          ]),
        )
        .optional(),
      'poll.fields': z
        .array(
          z.union([
            z.literal('duration_minutes'),
            z.literal('end_datetime'),
            z.literal('id'),
            z.literal('options'),
            z.literal('voting_status'),
          ]),
        )
        .optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const listsIdTweetsErrorSchema = errorSchema;

export const getOpenApiSpecResponseSchema = z.record(z.unknown());

export const getOpenApiSpecErrorSchema = z.unknown();

export const findSpacesByIdsDataSchema = z.object({
  query: z.object({
    expansions: z
      .array(
        z.union([
          z.literal('creator_id'),
          z.literal('host_ids'),
          z.literal('invited_user_ids'),
          z.literal('speaker_ids'),
          z.literal('topic_ids'),
        ]),
      )
      .optional(),
    ids: z.array(z.string()),
    'space.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('creator_id'),
          z.literal('ended_at'),
          z.literal('host_ids'),
          z.literal('id'),
          z.literal('invited_user_ids'),
          z.literal('is_ticketed'),
          z.literal('lang'),
          z.literal('participant_count'),
          z.literal('scheduled_start'),
          z.literal('speaker_ids'),
          z.literal('started_at'),
          z.literal('state'),
          z.literal('subscriber_count'),
          z.literal('title'),
          z.literal('topic_ids'),
          z.literal('updated_at'),
        ]),
      )
      .optional(),
    'topic.fields': z.array(z.union([z.literal('description'), z.literal('id'), z.literal('name')])).optional(),
    'user.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('description'),
          z.literal('entities'),
          z.literal('id'),
          z.literal('location'),
          z.literal('name'),
          z.literal('pinned_tweet_id'),
          z.literal('profile_image_url'),
          z.literal('protected'),
          z.literal('public_metrics'),
          z.literal('url'),
          z.literal('username'),
          z.literal('verified'),
          z.literal('verified_type'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
  }),
});

export const findSpacesByIdsErrorSchema = errorSchema;

export const findSpacesByCreatorIdsDataSchema = z.object({
  query: z.object({
    expansions: z
      .array(
        z.union([
          z.literal('creator_id'),
          z.literal('host_ids'),
          z.literal('invited_user_ids'),
          z.literal('speaker_ids'),
          z.literal('topic_ids'),
        ]),
      )
      .optional(),
    'space.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('creator_id'),
          z.literal('ended_at'),
          z.literal('host_ids'),
          z.literal('id'),
          z.literal('invited_user_ids'),
          z.literal('is_ticketed'),
          z.literal('lang'),
          z.literal('participant_count'),
          z.literal('scheduled_start'),
          z.literal('speaker_ids'),
          z.literal('started_at'),
          z.literal('state'),
          z.literal('subscriber_count'),
          z.literal('title'),
          z.literal('topic_ids'),
          z.literal('updated_at'),
        ]),
      )
      .optional(),
    'topic.fields': z.array(z.union([z.literal('description'), z.literal('id'), z.literal('name')])).optional(),
    user_ids: z.array(userIdSchema),
    'user.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('description'),
          z.literal('entities'),
          z.literal('id'),
          z.literal('location'),
          z.literal('name'),
          z.literal('pinned_tweet_id'),
          z.literal('profile_image_url'),
          z.literal('protected'),
          z.literal('public_metrics'),
          z.literal('url'),
          z.literal('username'),
          z.literal('verified'),
          z.literal('verified_type'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
  }),
});

export const findSpacesByCreatorIdsErrorSchema = errorSchema;

export const searchSpacesDataSchema = z.object({
  query: z.object({
    expansions: z
      .array(
        z.union([
          z.literal('creator_id'),
          z.literal('host_ids'),
          z.literal('invited_user_ids'),
          z.literal('speaker_ids'),
          z.literal('topic_ids'),
        ]),
      )
      .optional(),
    max_results: z.number().optional(),
    query: z.string(),
    'space.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('creator_id'),
          z.literal('ended_at'),
          z.literal('host_ids'),
          z.literal('id'),
          z.literal('invited_user_ids'),
          z.literal('is_ticketed'),
          z.literal('lang'),
          z.literal('participant_count'),
          z.literal('scheduled_start'),
          z.literal('speaker_ids'),
          z.literal('started_at'),
          z.literal('state'),
          z.literal('subscriber_count'),
          z.literal('title'),
          z.literal('topic_ids'),
          z.literal('updated_at'),
        ]),
      )
      .optional(),
    state: z.union([z.literal('live'), z.literal('scheduled'), z.literal('all')]).optional(),
    'topic.fields': z.array(z.union([z.literal('description'), z.literal('id'), z.literal('name')])).optional(),
    'user.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('description'),
          z.literal('entities'),
          z.literal('id'),
          z.literal('location'),
          z.literal('name'),
          z.literal('pinned_tweet_id'),
          z.literal('profile_image_url'),
          z.literal('protected'),
          z.literal('public_metrics'),
          z.literal('url'),
          z.literal('username'),
          z.literal('verified'),
          z.literal('verified_type'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
  }),
});

export const searchSpacesErrorSchema = errorSchema;

export const findSpaceByIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      expansions: z
        .array(
          z.union([
            z.literal('creator_id'),
            z.literal('host_ids'),
            z.literal('invited_user_ids'),
            z.literal('speaker_ids'),
            z.literal('topic_ids'),
          ]),
        )
        .optional(),
      'space.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('creator_id'),
            z.literal('ended_at'),
            z.literal('host_ids'),
            z.literal('id'),
            z.literal('invited_user_ids'),
            z.literal('is_ticketed'),
            z.literal('lang'),
            z.literal('participant_count'),
            z.literal('scheduled_start'),
            z.literal('speaker_ids'),
            z.literal('started_at'),
            z.literal('state'),
            z.literal('subscriber_count'),
            z.literal('title'),
            z.literal('topic_ids'),
            z.literal('updated_at'),
          ]),
        )
        .optional(),
      'topic.fields': z.array(z.union([z.literal('description'), z.literal('id'), z.literal('name')])).optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const findSpaceByIdErrorSchema = errorSchema;

export const spaceBuyersDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      expansions: z.array(z.literal('pinned_tweet_id')).optional(),
      max_results: z.number().optional(),
      pagination_token: paginationToken32Schema.optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const spaceBuyersErrorSchema = errorSchema;

export const spaceTweetsDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('attachments.poll_ids'),
            z.literal('author_id'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities.mentions.username'),
            z.literal('geo.place_id'),
            z.literal('in_reply_to_user_id'),
            z.literal('referenced_tweets.id'),
            z.literal('referenced_tweets.id.author_id'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      'place.fields': z
        .array(
          z.union([
            z.literal('contained_within'),
            z.literal('country'),
            z.literal('country_code'),
            z.literal('full_name'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('name'),
            z.literal('place_type'),
          ]),
        )
        .optional(),
      'poll.fields': z
        .array(
          z.union([
            z.literal('duration_minutes'),
            z.literal('end_datetime'),
            z.literal('id'),
            z.literal('options'),
            z.literal('voting_status'),
          ]),
        )
        .optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const spaceTweetsErrorSchema = errorSchema;

export const findTweetsByIdDataSchema = z.object({
  query: z.object({
    expansions: z
      .array(
        z.union([
          z.literal('attachments.media_keys'),
          z.literal('attachments.poll_ids'),
          z.literal('author_id'),
          z.literal('edit_history_tweet_ids'),
          z.literal('entities.mentions.username'),
          z.literal('geo.place_id'),
          z.literal('in_reply_to_user_id'),
          z.literal('referenced_tweets.id'),
          z.literal('referenced_tweets.id.author_id'),
        ]),
      )
      .optional(),
    ids: z.array(tweetIdSchema),
    'media.fields': z
      .array(
        z.union([
          z.literal('alt_text'),
          z.literal('duration_ms'),
          z.literal('height'),
          z.literal('media_key'),
          z.literal('non_public_metrics'),
          z.literal('organic_metrics'),
          z.literal('preview_image_url'),
          z.literal('promoted_metrics'),
          z.literal('public_metrics'),
          z.literal('type'),
          z.literal('url'),
          z.literal('variants'),
          z.literal('width'),
        ]),
      )
      .optional(),
    'place.fields': z
      .array(
        z.union([
          z.literal('contained_within'),
          z.literal('country'),
          z.literal('country_code'),
          z.literal('full_name'),
          z.literal('geo'),
          z.literal('id'),
          z.literal('name'),
          z.literal('place_type'),
        ]),
      )
      .optional(),
    'poll.fields': z
      .array(
        z.union([
          z.literal('duration_minutes'),
          z.literal('end_datetime'),
          z.literal('id'),
          z.literal('options'),
          z.literal('voting_status'),
        ]),
      )
      .optional(),
    'tweet.fields': z
      .array(
        z.union([
          z.literal('attachments'),
          z.literal('author_id'),
          z.literal('context_annotations'),
          z.literal('conversation_id'),
          z.literal('created_at'),
          z.literal('edit_controls'),
          z.literal('edit_history_tweet_ids'),
          z.literal('entities'),
          z.literal('geo'),
          z.literal('id'),
          z.literal('in_reply_to_user_id'),
          z.literal('lang'),
          z.literal('non_public_metrics'),
          z.literal('organic_metrics'),
          z.literal('possibly_sensitive'),
          z.literal('promoted_metrics'),
          z.literal('public_metrics'),
          z.literal('referenced_tweets'),
          z.literal('reply_settings'),
          z.literal('source'),
          z.literal('text'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
    'user.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('description'),
          z.literal('entities'),
          z.literal('id'),
          z.literal('location'),
          z.literal('name'),
          z.literal('pinned_tweet_id'),
          z.literal('profile_image_url'),
          z.literal('protected'),
          z.literal('public_metrics'),
          z.literal('url'),
          z.literal('username'),
          z.literal('verified'),
          z.literal('verified_type'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
  }),
});

export const findTweetsByIdErrorSchema = errorSchema;

export const createTweetDataSchema = z.object({
  body: tweetCreateRequestSchema,
});

export const createTweetResponseSchema = tweetCreateResponseSchema;

export const createTweetErrorSchema = errorSchema;

export const getTweetsComplianceStreamDataSchema = z.object({
  query: z.object({
    backfill_minutes: z.number().optional(),
    end_time: z.string().optional(),
    partition: z.number(),
    start_time: z.string().optional(),
  }),
});

export const getTweetsComplianceStreamErrorSchema = errorSchema;

export const tweetCountsFullArchiveSearchDataSchema = z.object({
  query: z.object({
    end_time: z.string().optional(),
    granularity: z.union([z.literal('minute'), z.literal('hour'), z.literal('day')]).optional(),
    next_token: paginationToken36Schema.optional(),
    pagination_token: paginationToken36Schema.optional(),
    query: z.string(),
    'search_count.fields': z
      .array(z.union([z.literal('end'), z.literal('start'), z.literal('tweet_count')]))
      .optional(),
    since_id: tweetIdSchema.optional(),
    start_time: z.string().optional(),
    until_id: tweetIdSchema.optional(),
  }),
});

export const tweetCountsFullArchiveSearchErrorSchema = errorSchema;

export const tweetCountsRecentSearchDataSchema = z.object({
  query: z.object({
    end_time: z.string().optional(),
    granularity: z.union([z.literal('minute'), z.literal('hour'), z.literal('day')]).optional(),
    next_token: paginationToken36Schema.optional(),
    pagination_token: paginationToken36Schema.optional(),
    query: z.string(),
    'search_count.fields': z
      .array(z.union([z.literal('end'), z.literal('start'), z.literal('tweet_count')]))
      .optional(),
    since_id: tweetIdSchema.optional(),
    start_time: z.string().optional(),
    until_id: tweetIdSchema.optional(),
  }),
});

export const tweetCountsRecentSearchErrorSchema = errorSchema;

export const getTweetsFirehoseStreamDataSchema = z.object({
  query: z.object({
    backfill_minutes: z.number().optional(),
    end_time: z.string().optional(),
    expansions: z
      .array(
        z.union([
          z.literal('attachments.media_keys'),
          z.literal('attachments.poll_ids'),
          z.literal('author_id'),
          z.literal('edit_history_tweet_ids'),
          z.literal('entities.mentions.username'),
          z.literal('geo.place_id'),
          z.literal('in_reply_to_user_id'),
          z.literal('referenced_tweets.id'),
          z.literal('referenced_tweets.id.author_id'),
        ]),
      )
      .optional(),
    'media.fields': z
      .array(
        z.union([
          z.literal('alt_text'),
          z.literal('duration_ms'),
          z.literal('height'),
          z.literal('media_key'),
          z.literal('non_public_metrics'),
          z.literal('organic_metrics'),
          z.literal('preview_image_url'),
          z.literal('promoted_metrics'),
          z.literal('public_metrics'),
          z.literal('type'),
          z.literal('url'),
          z.literal('variants'),
          z.literal('width'),
        ]),
      )
      .optional(),
    partition: z.number(),
    'place.fields': z
      .array(
        z.union([
          z.literal('contained_within'),
          z.literal('country'),
          z.literal('country_code'),
          z.literal('full_name'),
          z.literal('geo'),
          z.literal('id'),
          z.literal('name'),
          z.literal('place_type'),
        ]),
      )
      .optional(),
    'poll.fields': z
      .array(
        z.union([
          z.literal('duration_minutes'),
          z.literal('end_datetime'),
          z.literal('id'),
          z.literal('options'),
          z.literal('voting_status'),
        ]),
      )
      .optional(),
    start_time: z.string().optional(),
    'tweet.fields': z
      .array(
        z.union([
          z.literal('attachments'),
          z.literal('author_id'),
          z.literal('context_annotations'),
          z.literal('conversation_id'),
          z.literal('created_at'),
          z.literal('edit_controls'),
          z.literal('edit_history_tweet_ids'),
          z.literal('entities'),
          z.literal('geo'),
          z.literal('id'),
          z.literal('in_reply_to_user_id'),
          z.literal('lang'),
          z.literal('non_public_metrics'),
          z.literal('organic_metrics'),
          z.literal('possibly_sensitive'),
          z.literal('promoted_metrics'),
          z.literal('public_metrics'),
          z.literal('referenced_tweets'),
          z.literal('reply_settings'),
          z.literal('source'),
          z.literal('text'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
    'user.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('description'),
          z.literal('entities'),
          z.literal('id'),
          z.literal('location'),
          z.literal('name'),
          z.literal('pinned_tweet_id'),
          z.literal('profile_image_url'),
          z.literal('protected'),
          z.literal('public_metrics'),
          z.literal('url'),
          z.literal('username'),
          z.literal('verified'),
          z.literal('verified_type'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
  }),
});

export const getTweetsFirehoseStreamErrorSchema = errorSchema;

export const getTweetsLabelStreamDataSchema = z.object({
  query: z
    .object({
      backfill_minutes: z.number().optional(),
      end_time: z.string().optional(),
      start_time: z.string().optional(),
    })
    .optional(),
});

export const getTweetsLabelStreamErrorSchema = errorSchema;

export const sampleStreamDataSchema = z.object({
  query: z
    .object({
      backfill_minutes: z.number().optional(),
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('attachments.poll_ids'),
            z.literal('author_id'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities.mentions.username'),
            z.literal('geo.place_id'),
            z.literal('in_reply_to_user_id'),
            z.literal('referenced_tweets.id'),
            z.literal('referenced_tweets.id.author_id'),
          ]),
        )
        .optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      'place.fields': z
        .array(
          z.union([
            z.literal('contained_within'),
            z.literal('country'),
            z.literal('country_code'),
            z.literal('full_name'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('name'),
            z.literal('place_type'),
          ]),
        )
        .optional(),
      'poll.fields': z
        .array(
          z.union([
            z.literal('duration_minutes'),
            z.literal('end_datetime'),
            z.literal('id'),
            z.literal('options'),
            z.literal('voting_status'),
          ]),
        )
        .optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const sampleStreamErrorSchema = errorSchema;

export const getTweetsSample10StreamDataSchema = z.object({
  query: z.object({
    backfill_minutes: z.number().optional(),
    end_time: z.string().optional(),
    expansions: z
      .array(
        z.union([
          z.literal('attachments.media_keys'),
          z.literal('attachments.poll_ids'),
          z.literal('author_id'),
          z.literal('edit_history_tweet_ids'),
          z.literal('entities.mentions.username'),
          z.literal('geo.place_id'),
          z.literal('in_reply_to_user_id'),
          z.literal('referenced_tweets.id'),
          z.literal('referenced_tweets.id.author_id'),
        ]),
      )
      .optional(),
    'media.fields': z
      .array(
        z.union([
          z.literal('alt_text'),
          z.literal('duration_ms'),
          z.literal('height'),
          z.literal('media_key'),
          z.literal('non_public_metrics'),
          z.literal('organic_metrics'),
          z.literal('preview_image_url'),
          z.literal('promoted_metrics'),
          z.literal('public_metrics'),
          z.literal('type'),
          z.literal('url'),
          z.literal('variants'),
          z.literal('width'),
        ]),
      )
      .optional(),
    partition: z.number(),
    'place.fields': z
      .array(
        z.union([
          z.literal('contained_within'),
          z.literal('country'),
          z.literal('country_code'),
          z.literal('full_name'),
          z.literal('geo'),
          z.literal('id'),
          z.literal('name'),
          z.literal('place_type'),
        ]),
      )
      .optional(),
    'poll.fields': z
      .array(
        z.union([
          z.literal('duration_minutes'),
          z.literal('end_datetime'),
          z.literal('id'),
          z.literal('options'),
          z.literal('voting_status'),
        ]),
      )
      .optional(),
    start_time: z.string().optional(),
    'tweet.fields': z
      .array(
        z.union([
          z.literal('attachments'),
          z.literal('author_id'),
          z.literal('context_annotations'),
          z.literal('conversation_id'),
          z.literal('created_at'),
          z.literal('edit_controls'),
          z.literal('edit_history_tweet_ids'),
          z.literal('entities'),
          z.literal('geo'),
          z.literal('id'),
          z.literal('in_reply_to_user_id'),
          z.literal('lang'),
          z.literal('non_public_metrics'),
          z.literal('organic_metrics'),
          z.literal('possibly_sensitive'),
          z.literal('promoted_metrics'),
          z.literal('public_metrics'),
          z.literal('referenced_tweets'),
          z.literal('reply_settings'),
          z.literal('source'),
          z.literal('text'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
    'user.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('description'),
          z.literal('entities'),
          z.literal('id'),
          z.literal('location'),
          z.literal('name'),
          z.literal('pinned_tweet_id'),
          z.literal('profile_image_url'),
          z.literal('protected'),
          z.literal('public_metrics'),
          z.literal('url'),
          z.literal('username'),
          z.literal('verified'),
          z.literal('verified_type'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
  }),
});

export const getTweetsSample10StreamErrorSchema = errorSchema;

export const tweetsFullarchiveSearchDataSchema = z.object({
  query: z.object({
    end_time: z.string().optional(),
    expansions: z
      .array(
        z.union([
          z.literal('attachments.media_keys'),
          z.literal('attachments.poll_ids'),
          z.literal('author_id'),
          z.literal('edit_history_tweet_ids'),
          z.literal('entities.mentions.username'),
          z.literal('geo.place_id'),
          z.literal('in_reply_to_user_id'),
          z.literal('referenced_tweets.id'),
          z.literal('referenced_tweets.id.author_id'),
        ]),
      )
      .optional(),
    max_results: z.number().optional(),
    'media.fields': z
      .array(
        z.union([
          z.literal('alt_text'),
          z.literal('duration_ms'),
          z.literal('height'),
          z.literal('media_key'),
          z.literal('non_public_metrics'),
          z.literal('organic_metrics'),
          z.literal('preview_image_url'),
          z.literal('promoted_metrics'),
          z.literal('public_metrics'),
          z.literal('type'),
          z.literal('url'),
          z.literal('variants'),
          z.literal('width'),
        ]),
      )
      .optional(),
    next_token: paginationToken36Schema.optional(),
    pagination_token: paginationToken36Schema.optional(),
    'place.fields': z
      .array(
        z.union([
          z.literal('contained_within'),
          z.literal('country'),
          z.literal('country_code'),
          z.literal('full_name'),
          z.literal('geo'),
          z.literal('id'),
          z.literal('name'),
          z.literal('place_type'),
        ]),
      )
      .optional(),
    'poll.fields': z
      .array(
        z.union([
          z.literal('duration_minutes'),
          z.literal('end_datetime'),
          z.literal('id'),
          z.literal('options'),
          z.literal('voting_status'),
        ]),
      )
      .optional(),
    query: z.string(),
    since_id: tweetIdSchema.optional(),
    sort_order: z.union([z.literal('recency'), z.literal('relevancy')]).optional(),
    start_time: z.string().optional(),
    'tweet.fields': z
      .array(
        z.union([
          z.literal('attachments'),
          z.literal('author_id'),
          z.literal('context_annotations'),
          z.literal('conversation_id'),
          z.literal('created_at'),
          z.literal('edit_controls'),
          z.literal('edit_history_tweet_ids'),
          z.literal('entities'),
          z.literal('geo'),
          z.literal('id'),
          z.literal('in_reply_to_user_id'),
          z.literal('lang'),
          z.literal('non_public_metrics'),
          z.literal('organic_metrics'),
          z.literal('possibly_sensitive'),
          z.literal('promoted_metrics'),
          z.literal('public_metrics'),
          z.literal('referenced_tweets'),
          z.literal('reply_settings'),
          z.literal('source'),
          z.literal('text'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
    until_id: tweetIdSchema.optional(),
    'user.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('description'),
          z.literal('entities'),
          z.literal('id'),
          z.literal('location'),
          z.literal('name'),
          z.literal('pinned_tweet_id'),
          z.literal('profile_image_url'),
          z.literal('protected'),
          z.literal('public_metrics'),
          z.literal('url'),
          z.literal('username'),
          z.literal('verified'),
          z.literal('verified_type'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
  }),
});

export const tweetsFullarchiveSearchErrorSchema = errorSchema;

export const tweetsRecentSearchDataSchema = z.object({
  query: z.object({
    end_time: z.string().optional(),
    expansions: z
      .array(
        z.union([
          z.literal('attachments.media_keys'),
          z.literal('attachments.poll_ids'),
          z.literal('author_id'),
          z.literal('edit_history_tweet_ids'),
          z.literal('entities.mentions.username'),
          z.literal('geo.place_id'),
          z.literal('in_reply_to_user_id'),
          z.literal('referenced_tweets.id'),
          z.literal('referenced_tweets.id.author_id'),
        ]),
      )
      .optional(),
    max_results: z.number().optional(),
    'media.fields': z
      .array(
        z.union([
          z.literal('alt_text'),
          z.literal('duration_ms'),
          z.literal('height'),
          z.literal('media_key'),
          z.literal('non_public_metrics'),
          z.literal('organic_metrics'),
          z.literal('preview_image_url'),
          z.literal('promoted_metrics'),
          z.literal('public_metrics'),
          z.literal('type'),
          z.literal('url'),
          z.literal('variants'),
          z.literal('width'),
        ]),
      )
      .optional(),
    next_token: paginationToken36Schema.optional(),
    pagination_token: paginationToken36Schema.optional(),
    'place.fields': z
      .array(
        z.union([
          z.literal('contained_within'),
          z.literal('country'),
          z.literal('country_code'),
          z.literal('full_name'),
          z.literal('geo'),
          z.literal('id'),
          z.literal('name'),
          z.literal('place_type'),
        ]),
      )
      .optional(),
    'poll.fields': z
      .array(
        z.union([
          z.literal('duration_minutes'),
          z.literal('end_datetime'),
          z.literal('id'),
          z.literal('options'),
          z.literal('voting_status'),
        ]),
      )
      .optional(),
    query: z.string(),
    since_id: tweetIdSchema.optional(),
    sort_order: z.union([z.literal('recency'), z.literal('relevancy')]).optional(),
    start_time: z.string().optional(),
    'tweet.fields': z
      .array(
        z.union([
          z.literal('attachments'),
          z.literal('author_id'),
          z.literal('context_annotations'),
          z.literal('conversation_id'),
          z.literal('created_at'),
          z.literal('edit_controls'),
          z.literal('edit_history_tweet_ids'),
          z.literal('entities'),
          z.literal('geo'),
          z.literal('id'),
          z.literal('in_reply_to_user_id'),
          z.literal('lang'),
          z.literal('non_public_metrics'),
          z.literal('organic_metrics'),
          z.literal('possibly_sensitive'),
          z.literal('promoted_metrics'),
          z.literal('public_metrics'),
          z.literal('referenced_tweets'),
          z.literal('reply_settings'),
          z.literal('source'),
          z.literal('text'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
    until_id: tweetIdSchema.optional(),
    'user.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('description'),
          z.literal('entities'),
          z.literal('id'),
          z.literal('location'),
          z.literal('name'),
          z.literal('pinned_tweet_id'),
          z.literal('profile_image_url'),
          z.literal('protected'),
          z.literal('public_metrics'),
          z.literal('url'),
          z.literal('username'),
          z.literal('verified'),
          z.literal('verified_type'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
  }),
});

export const tweetsRecentSearchErrorSchema = errorSchema;

export const searchStreamDataSchema = z.object({
  query: z
    .object({
      backfill_minutes: z.number().optional(),
      end_time: z.string().optional(),
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('attachments.poll_ids'),
            z.literal('author_id'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities.mentions.username'),
            z.literal('geo.place_id'),
            z.literal('in_reply_to_user_id'),
            z.literal('referenced_tweets.id'),
            z.literal('referenced_tweets.id.author_id'),
          ]),
        )
        .optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      'place.fields': z
        .array(
          z.union([
            z.literal('contained_within'),
            z.literal('country'),
            z.literal('country_code'),
            z.literal('full_name'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('name'),
            z.literal('place_type'),
          ]),
        )
        .optional(),
      'poll.fields': z
        .array(
          z.union([
            z.literal('duration_minutes'),
            z.literal('end_datetime'),
            z.literal('id'),
            z.literal('options'),
            z.literal('voting_status'),
          ]),
        )
        .optional(),
      start_time: z.string().optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const searchStreamErrorSchema = errorSchema;

export const getRulesDataSchema = z.object({
  query: z
    .object({
      ids: z.array(ruleIdSchema).optional(),
      max_results: z.number().optional(),
      pagination_token: z.string().optional(),
    })
    .optional(),
});

export const rulesLookupResponseSchema = z.object({
  data: z.array(ruleSchema).optional(),
  meta: rulesResponseMetadataSchema,
});

export const getRulesErrorSchema = errorSchema;

export const addOrDeleteRulesResponseSchema = z.object({
  data: z.array(ruleSchema).optional(),
  errors: z.array(problemSchema).optional(),
  meta: rulesResponseMetadataSchema,
});

export const addOrDeleteRulesErrorSchema = errorSchema;

export const deleteTweetByIdDataSchema = z.object({
  path: z.object({
    id: tweetIdSchema,
  }),
});

export const deleteTweetByIdResponseSchema = tweetDeleteResponseSchema;

export const deleteTweetByIdErrorSchema = errorSchema;

export const findTweetByIdDataSchema = z.object({
  path: z.object({
    id: tweetIdSchema,
  }),
  query: z
    .object({
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('attachments.poll_ids'),
            z.literal('author_id'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities.mentions.username'),
            z.literal('geo.place_id'),
            z.literal('in_reply_to_user_id'),
            z.literal('referenced_tweets.id'),
            z.literal('referenced_tweets.id.author_id'),
          ]),
        )
        .optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      'place.fields': z
        .array(
          z.union([
            z.literal('contained_within'),
            z.literal('country'),
            z.literal('country_code'),
            z.literal('full_name'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('name'),
            z.literal('place_type'),
          ]),
        )
        .optional(),
      'poll.fields': z
        .array(
          z.union([
            z.literal('duration_minutes'),
            z.literal('end_datetime'),
            z.literal('id'),
            z.literal('options'),
            z.literal('voting_status'),
          ]),
        )
        .optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const findTweetByIdErrorSchema = errorSchema;

export const tweetsIdLikingUsersDataSchema = z.object({
  path: z.object({
    id: tweetIdSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('pinned_tweet_id')).optional(),
      max_results: z.number().optional(),
      pagination_token: paginationToken36Schema.optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const tweetsIdLikingUsersErrorSchema = errorSchema;

export const findTweetsThatQuoteAtweetDataSchema = z.object({
  path: z.object({
    id: tweetIdSchema,
  }),
  query: z
    .object({
      exclude: z.array(z.union([z.literal('replies'), z.literal('retweets')])).optional(),
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('attachments.poll_ids'),
            z.literal('author_id'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities.mentions.username'),
            z.literal('geo.place_id'),
            z.literal('in_reply_to_user_id'),
            z.literal('referenced_tweets.id'),
            z.literal('referenced_tweets.id.author_id'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      pagination_token: paginationToken36Schema.optional(),
      'place.fields': z
        .array(
          z.union([
            z.literal('contained_within'),
            z.literal('country'),
            z.literal('country_code'),
            z.literal('full_name'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('name'),
            z.literal('place_type'),
          ]),
        )
        .optional(),
      'poll.fields': z
        .array(
          z.union([
            z.literal('duration_minutes'),
            z.literal('end_datetime'),
            z.literal('id'),
            z.literal('options'),
            z.literal('voting_status'),
          ]),
        )
        .optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const findTweetsThatQuoteAtweetErrorSchema = errorSchema;

export const tweetsIdRetweetingUsersDataSchema = z.object({
  path: z.object({
    id: tweetIdSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('pinned_tweet_id')).optional(),
      max_results: z.number().optional(),
      pagination_token: paginationToken36Schema.optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const tweetsIdRetweetingUsersErrorSchema = errorSchema;

export const hideReplyByIdDataSchema = z.object({
  body: tweetHideRequestSchema.optional(),
  path: z.object({
    tweet_id: tweetIdSchema,
  }),
});

export const hideReplyByIdResponseSchema = tweetHideResponseSchema;

export const hideReplyByIdErrorSchema = errorSchema;

export const findUsersByIdDataSchema = z.object({
  query: z.object({
    expansions: z.array(z.literal('pinned_tweet_id')).optional(),
    ids: z.array(userIdSchema),
    'tweet.fields': z
      .array(
        z.union([
          z.literal('attachments'),
          z.literal('author_id'),
          z.literal('context_annotations'),
          z.literal('conversation_id'),
          z.literal('created_at'),
          z.literal('edit_controls'),
          z.literal('edit_history_tweet_ids'),
          z.literal('entities'),
          z.literal('geo'),
          z.literal('id'),
          z.literal('in_reply_to_user_id'),
          z.literal('lang'),
          z.literal('non_public_metrics'),
          z.literal('organic_metrics'),
          z.literal('possibly_sensitive'),
          z.literal('promoted_metrics'),
          z.literal('public_metrics'),
          z.literal('referenced_tweets'),
          z.literal('reply_settings'),
          z.literal('source'),
          z.literal('text'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
    'user.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('description'),
          z.literal('entities'),
          z.literal('id'),
          z.literal('location'),
          z.literal('name'),
          z.literal('pinned_tweet_id'),
          z.literal('profile_image_url'),
          z.literal('protected'),
          z.literal('public_metrics'),
          z.literal('url'),
          z.literal('username'),
          z.literal('verified'),
          z.literal('verified_type'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
  }),
});

export const findUsersByIdErrorSchema = errorSchema;

export const findUsersByUsernameDataSchema = z.object({
  query: z.object({
    expansions: z.array(z.literal('pinned_tweet_id')).optional(),
    'tweet.fields': z
      .array(
        z.union([
          z.literal('attachments'),
          z.literal('author_id'),
          z.literal('context_annotations'),
          z.literal('conversation_id'),
          z.literal('created_at'),
          z.literal('edit_controls'),
          z.literal('edit_history_tweet_ids'),
          z.literal('entities'),
          z.literal('geo'),
          z.literal('id'),
          z.literal('in_reply_to_user_id'),
          z.literal('lang'),
          z.literal('non_public_metrics'),
          z.literal('organic_metrics'),
          z.literal('possibly_sensitive'),
          z.literal('promoted_metrics'),
          z.literal('public_metrics'),
          z.literal('referenced_tweets'),
          z.literal('reply_settings'),
          z.literal('source'),
          z.literal('text'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
    'user.fields': z
      .array(
        z.union([
          z.literal('created_at'),
          z.literal('description'),
          z.literal('entities'),
          z.literal('id'),
          z.literal('location'),
          z.literal('name'),
          z.literal('pinned_tweet_id'),
          z.literal('profile_image_url'),
          z.literal('protected'),
          z.literal('public_metrics'),
          z.literal('url'),
          z.literal('username'),
          z.literal('verified'),
          z.literal('verified_type'),
          z.literal('withheld'),
        ]),
      )
      .optional(),
    usernames: z.array(z.string()),
  }),
});

export const findUsersByUsernameErrorSchema = errorSchema;

export const findUserByUsernameDataSchema = z.object({
  path: z.object({
    username: z.string(),
  }),
  query: z
    .object({
      expansions: z.array(z.literal('pinned_tweet_id')).optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const findUserByUsernameErrorSchema = errorSchema;

export const getUsersComplianceStreamDataSchema = z.object({
  query: z.object({
    backfill_minutes: z.number().optional(),
    end_time: z.string().optional(),
    partition: z.number(),
    start_time: z.string().optional(),
  }),
});

export const getUsersComplianceStreamErrorSchema = errorSchema;

export const findMyUserDataSchema = z.object({
  query: z
    .object({
      expansions: z.array(z.literal('pinned_tweet_id')).optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const findMyUserErrorSchema = errorSchema;

export const findUserByIdDataSchema = z.object({
  path: z.object({
    id: userIdSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('pinned_tweet_id')).optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const findUserByIdErrorSchema = errorSchema;

export const usersIdBlockingDataSchema = z.object({
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('pinned_tweet_id')).optional(),
      max_results: z.number().optional(),
      pagination_token: paginationToken32Schema.optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const usersIdBlockingErrorSchema = errorSchema;

export const blockUserRequestSchema = z.object({
  target_user_id: userIdSchema,
});

export const usersIdBlockResponseSchema = blockUserMutationResponseSchema;

export const usersIdBlockErrorSchema = errorSchema;

export const getUsersIdBookmarksDataSchema = z.object({
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
  query: z
    .object({
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('attachments.poll_ids'),
            z.literal('author_id'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities.mentions.username'),
            z.literal('geo.place_id'),
            z.literal('in_reply_to_user_id'),
            z.literal('referenced_tweets.id'),
            z.literal('referenced_tweets.id.author_id'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      pagination_token: paginationToken36Schema.optional(),
      'place.fields': z
        .array(
          z.union([
            z.literal('contained_within'),
            z.literal('country'),
            z.literal('country_code'),
            z.literal('full_name'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('name'),
            z.literal('place_type'),
          ]),
        )
        .optional(),
      'poll.fields': z
        .array(
          z.union([
            z.literal('duration_minutes'),
            z.literal('end_datetime'),
            z.literal('id'),
            z.literal('options'),
            z.literal('voting_status'),
          ]),
        )
        .optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const getUsersIdBookmarksErrorSchema = errorSchema;

export const bookmarkAddRequestSchema = z.object({
  tweet_id: tweetIdSchema,
});

export const postUsersIdBookmarksResponseSchema = bookmarkMutationResponseSchema;

export const postUsersIdBookmarksErrorSchema = errorSchema;

export const usersIdBookmarksDeleteDataSchema = z.object({
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
    tweet_id: tweetIdSchema,
  }),
});

export const usersIdBookmarksDeleteResponseSchema = bookmarkMutationResponseSchema;

export const usersIdBookmarksDeleteErrorSchema = errorSchema;

export const userFollowedListsDataSchema = z.object({
  path: z.object({
    id: userIdSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('owner_id')).optional(),
      'list.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('follower_count'),
            z.literal('id'),
            z.literal('member_count'),
            z.literal('name'),
            z.literal('owner_id'),
            z.literal('private'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      pagination_token: paginationTokenLongSchema.optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const userFollowedListsErrorSchema = errorSchema;

export const listUserFollowDataSchema = z.object({
  body: listFollowedRequestSchema.optional(),
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
});

export const listUserFollowResponseSchema = listFollowedResponseSchema;

export const listUserFollowErrorSchema = errorSchema;

export const listUserUnfollowDataSchema = z.object({
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
    list_id: listIdSchema,
  }),
});

export const listUserUnfollowResponseSchema = listFollowedResponseSchema;

export const listUserUnfollowErrorSchema = errorSchema;

export const usersIdFollowersDataSchema = z.object({
  path: z.object({
    id: userIdSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('pinned_tweet_id')).optional(),
      max_results: z.number().optional(),
      pagination_token: paginationToken32Schema.optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const usersIdFollowersErrorSchema = errorSchema;

export const usersIdFollowingDataSchema = z.object({
  path: z.object({
    id: userIdSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('pinned_tweet_id')).optional(),
      max_results: z.number().optional(),
      pagination_token: paginationToken32Schema.optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const usersIdFollowingErrorSchema = errorSchema;

export const usersIdFollowDataSchema = z.object({
  body: usersFollowingCreateRequestSchema.optional(),
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
});

export const usersIdFollowResponseSchema = usersFollowingCreateResponseSchema;

export const usersIdFollowErrorSchema = errorSchema;

export const usersIdLikedTweetsDataSchema = z.object({
  path: z.object({
    id: userIdSchema,
  }),
  query: z
    .object({
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('attachments.poll_ids'),
            z.literal('author_id'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities.mentions.username'),
            z.literal('geo.place_id'),
            z.literal('in_reply_to_user_id'),
            z.literal('referenced_tweets.id'),
            z.literal('referenced_tweets.id.author_id'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      pagination_token: paginationToken36Schema.optional(),
      'place.fields': z
        .array(
          z.union([
            z.literal('contained_within'),
            z.literal('country'),
            z.literal('country_code'),
            z.literal('full_name'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('name'),
            z.literal('place_type'),
          ]),
        )
        .optional(),
      'poll.fields': z
        .array(
          z.union([
            z.literal('duration_minutes'),
            z.literal('end_datetime'),
            z.literal('id'),
            z.literal('options'),
            z.literal('voting_status'),
          ]),
        )
        .optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const usersIdLikedTweetsErrorSchema = errorSchema;

export const usersIdLikeDataSchema = z.object({
  body: usersLikesCreateRequestSchema.optional(),
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
});

export const usersIdLikeResponseSchema = usersLikesCreateResponseSchema;

export const usersIdLikeErrorSchema = errorSchema;

export const usersIdUnlikeDataSchema = z.object({
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
    tweet_id: tweetIdSchema,
  }),
});

export const usersIdUnlikeResponseSchema = usersLikesDeleteResponseSchema;

export const usersIdUnlikeErrorSchema = errorSchema;

export const getUserListMembershipsDataSchema = z.object({
  path: z.object({
    id: userIdSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('owner_id')).optional(),
      'list.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('follower_count'),
            z.literal('id'),
            z.literal('member_count'),
            z.literal('name'),
            z.literal('owner_id'),
            z.literal('private'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      pagination_token: paginationTokenLongSchema.optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const getUserListMembershipsErrorSchema = errorSchema;

export const usersIdMentionsDataSchema = z.object({
  path: z.object({
    id: userIdSchema,
  }),
  query: z
    .object({
      end_time: z.string().optional(),
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('attachments.poll_ids'),
            z.literal('author_id'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities.mentions.username'),
            z.literal('geo.place_id'),
            z.literal('in_reply_to_user_id'),
            z.literal('referenced_tweets.id'),
            z.literal('referenced_tweets.id.author_id'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      pagination_token: paginationToken36Schema.optional(),
      'place.fields': z
        .array(
          z.union([
            z.literal('contained_within'),
            z.literal('country'),
            z.literal('country_code'),
            z.literal('full_name'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('name'),
            z.literal('place_type'),
          ]),
        )
        .optional(),
      'poll.fields': z
        .array(
          z.union([
            z.literal('duration_minutes'),
            z.literal('end_datetime'),
            z.literal('id'),
            z.literal('options'),
            z.literal('voting_status'),
          ]),
        )
        .optional(),
      since_id: tweetIdSchema.optional(),
      start_time: z.string().optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      until_id: tweetIdSchema.optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const usersIdMentionsErrorSchema = errorSchema;

export const usersIdMutingDataSchema = z.object({
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('pinned_tweet_id')).optional(),
      max_results: z.number().optional(),
      pagination_token: paginationTokenLongSchema.optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const usersIdMutingErrorSchema = errorSchema;

export const usersIdMuteDataSchema = z.object({
  body: muteUserRequestSchema.optional(),
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
});

export const usersIdMuteResponseSchema = muteUserMutationResponseSchema;

export const usersIdMuteErrorSchema = errorSchema;

export const listUserOwnedListsDataSchema = z.object({
  path: z.object({
    id: userIdSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('owner_id')).optional(),
      'list.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('follower_count'),
            z.literal('id'),
            z.literal('member_count'),
            z.literal('name'),
            z.literal('owner_id'),
            z.literal('private'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      pagination_token: paginationTokenLongSchema.optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const listUserOwnedListsErrorSchema = errorSchema;

export const listUserPinnedListsDataSchema = z.object({
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
  query: z
    .object({
      expansions: z.array(z.literal('owner_id')).optional(),
      'list.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('follower_count'),
            z.literal('id'),
            z.literal('member_count'),
            z.literal('name'),
            z.literal('owner_id'),
            z.literal('private'),
          ]),
        )
        .optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const listUserPinnedListsErrorSchema = errorSchema;

export const listUserPinDataSchema = z.object({
  body: listPinnedRequestSchema,
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
});

export const listUserPinResponseSchema = listPinnedResponseSchema;

export const listUserPinErrorSchema = errorSchema;

export const listUserUnpinDataSchema = z.object({
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
    list_id: listIdSchema,
  }),
});

export const listUserUnpinResponseSchema = listUnpinResponseSchema;

export const listUserUnpinErrorSchema = errorSchema;

export const usersIdRetweetsDataSchema = z.object({
  body: usersRetweetsCreateRequestSchema.optional(),
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
});

export const usersIdRetweetsResponseSchema = usersRetweetsCreateResponseSchema;

export const usersIdRetweetsErrorSchema = errorSchema;

export const usersIdUnretweetsDataSchema = z.object({
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
    source_tweet_id: tweetIdSchema,
  }),
});

export const usersIdUnretweetsResponseSchema = usersRetweetsDeleteResponseSchema;

export const usersIdUnretweetsErrorSchema = errorSchema;

export const usersIdTimelineDataSchema = z.object({
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
  query: z
    .object({
      end_time: z.string().optional(),
      exclude: z.array(z.union([z.literal('replies'), z.literal('retweets')])).optional(),
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('attachments.poll_ids'),
            z.literal('author_id'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities.mentions.username'),
            z.literal('geo.place_id'),
            z.literal('in_reply_to_user_id'),
            z.literal('referenced_tweets.id'),
            z.literal('referenced_tweets.id.author_id'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      pagination_token: paginationToken36Schema.optional(),
      'place.fields': z
        .array(
          z.union([
            z.literal('contained_within'),
            z.literal('country'),
            z.literal('country_code'),
            z.literal('full_name'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('name'),
            z.literal('place_type'),
          ]),
        )
        .optional(),
      'poll.fields': z
        .array(
          z.union([
            z.literal('duration_minutes'),
            z.literal('end_datetime'),
            z.literal('id'),
            z.literal('options'),
            z.literal('voting_status'),
          ]),
        )
        .optional(),
      since_id: tweetIdSchema.optional(),
      start_time: z.string().optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      until_id: tweetIdSchema.optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const usersIdTimelineErrorSchema = errorSchema;

export const usersIdTweetsDataSchema = z.object({
  path: z.object({
    id: userIdSchema,
  }),
  query: z
    .object({
      end_time: z.string().optional(),
      exclude: z.array(z.union([z.literal('replies'), z.literal('retweets')])).optional(),
      expansions: z
        .array(
          z.union([
            z.literal('attachments.media_keys'),
            z.literal('attachments.poll_ids'),
            z.literal('author_id'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities.mentions.username'),
            z.literal('geo.place_id'),
            z.literal('in_reply_to_user_id'),
            z.literal('referenced_tweets.id'),
            z.literal('referenced_tweets.id.author_id'),
          ]),
        )
        .optional(),
      max_results: z.number().optional(),
      'media.fields': z
        .array(
          z.union([
            z.literal('alt_text'),
            z.literal('duration_ms'),
            z.literal('height'),
            z.literal('media_key'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('preview_image_url'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('type'),
            z.literal('url'),
            z.literal('variants'),
            z.literal('width'),
          ]),
        )
        .optional(),
      pagination_token: paginationToken36Schema.optional(),
      'place.fields': z
        .array(
          z.union([
            z.literal('contained_within'),
            z.literal('country'),
            z.literal('country_code'),
            z.literal('full_name'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('name'),
            z.literal('place_type'),
          ]),
        )
        .optional(),
      'poll.fields': z
        .array(
          z.union([
            z.literal('duration_minutes'),
            z.literal('end_datetime'),
            z.literal('id'),
            z.literal('options'),
            z.literal('voting_status'),
          ]),
        )
        .optional(),
      since_id: tweetIdSchema.optional(),
      start_time: z.string().optional(),
      'tweet.fields': z
        .array(
          z.union([
            z.literal('attachments'),
            z.literal('author_id'),
            z.literal('context_annotations'),
            z.literal('conversation_id'),
            z.literal('created_at'),
            z.literal('edit_controls'),
            z.literal('edit_history_tweet_ids'),
            z.literal('entities'),
            z.literal('geo'),
            z.literal('id'),
            z.literal('in_reply_to_user_id'),
            z.literal('lang'),
            z.literal('non_public_metrics'),
            z.literal('organic_metrics'),
            z.literal('possibly_sensitive'),
            z.literal('promoted_metrics'),
            z.literal('public_metrics'),
            z.literal('referenced_tweets'),
            z.literal('reply_settings'),
            z.literal('source'),
            z.literal('text'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
      until_id: tweetIdSchema.optional(),
      'user.fields': z
        .array(
          z.union([
            z.literal('created_at'),
            z.literal('description'),
            z.literal('entities'),
            z.literal('id'),
            z.literal('location'),
            z.literal('name'),
            z.literal('pinned_tweet_id'),
            z.literal('profile_image_url'),
            z.literal('protected'),
            z.literal('public_metrics'),
            z.literal('url'),
            z.literal('username'),
            z.literal('verified'),
            z.literal('verified_type'),
            z.literal('withheld'),
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const usersIdTweetsErrorSchema = errorSchema;

export const usersIdUnblockDataSchema = z.object({
  path: z.object({
    source_user_id: userIdMatchesAuthenticatedUserSchema,
    target_user_id: userIdSchema,
  }),
});

export const usersIdUnblockResponseSchema = blockUserMutationResponseSchema;

export const usersIdUnblockErrorSchema = errorSchema;

export const usersIdUnfollowDataSchema = z.object({
  path: z.object({
    source_user_id: userIdMatchesAuthenticatedUserSchema,
    target_user_id: userIdSchema,
  }),
});

export const usersIdUnfollowResponseSchema = usersFollowingDeleteResponseSchema;

export const usersIdUnfollowErrorSchema = errorSchema;

export const usersIdUnmuteDataSchema = z.object({
  path: z.object({
    source_user_id: userIdMatchesAuthenticatedUserSchema,
    target_user_id: userIdSchema,
  }),
});

export const usersIdUnmuteResponseSchema = muteUserMutationResponseSchema;

export const usersIdUnmuteErrorSchema = errorSchema;

export const addRulesRequestSchema = z.object({
  add: z.array(ruleNoIdSchema),
});

export const deleteRulesRequestSchema = z.object({
  delete: z.object({
    ids: z.array(ruleIdSchema).optional(),
    values: z.array(ruleValueSchema).optional(),
  }),
});

export const animatedGifSchema = mediaSchema.and(
  z.object({
    preview_image_url: z.string().optional(),
    variants: variantsSchema.optional(),
  }),
);

export const dmMediaAttachmentSchema = z.object({
  media_id: mediaIdSchema,
});

export const topicSchema = z.object({
  description: z.string().optional(),
  id: topicIdSchema,
  name: z.string(),
});

export const hashtagEntitySchema = entityIndicesInclusiveExclusiveSchema.and(hashtagFieldsSchema);

export const geoSchema = z.object({
  bbox: z.tuple([z.number(), z.number(), z.number(), z.number()]),
  geometry: pointSchema.optional(),
  properties: z.record(z.unknown()),
  type: z.literal('Feature'),
});

export const listSchema = z.object({
  created_at: z.string().optional(),
  description: z.string().optional(),
  follower_count: z.number().optional(),
  id: listIdSchema,
  member_count: z.number().optional(),
  name: z.string(),
  owner_id: userIdSchema.optional(),
  private: z.boolean().optional(),
});

export const spaceSchema = z.object({
  created_at: z.string().optional(),
  creator_id: userIdSchema.optional(),
  ended_at: z.string().optional(),
  host_ids: z.array(userIdSchema).optional(),
  id: spaceIdSchema,
  invited_user_ids: z.array(userIdSchema).optional(),
  is_ticketed: z.boolean().optional(),
  lang: z.string().optional(),
  participant_count: z.number().optional(),
  scheduled_start: z.string().optional(),
  speaker_ids: z.array(userIdSchema).optional(),
  started_at: z.string().optional(),
  state: z.union([z.literal('live'), z.literal('scheduled'), z.literal('ended')]),
  subscriber_count: z.number().optional(),
  title: z.string().optional(),
  topics: z
    .array(
      z.object({
        description: z.string().optional(),
        id: z.string(),
        name: z.string(),
      }),
    )
    .optional(),
  updated_at: z.string().optional(),
});

export const searchCountSchema = z.object({
  end: endSchema,
  start: startSchema,
  tweet_count: tweetCountSchema,
});

export const get2TweetsCountsRecentResponseSchema = z.object({
  data: z.array(searchCountSchema).optional(),
  errors: z.array(problemSchema).optional(),
  meta: z
    .object({
      newest_id: newestIdSchema.optional(),
      next_token: nextTokenSchema.optional(),
      oldest_id: oldestIdSchema.optional(),
      total_tweet_count: aggregateSchema.optional(),
    })
    .optional(),
});

export const mentionFieldsSchema = z.object({
  id: userIdSchema.optional(),
  username: userNameSchema,
});

export const photoSchema = mediaSchema.and(
  z.object({
    alt_text: z.string().optional(),
    url: z.string().optional(),
  }),
);

export const placeSchema = z.object({
  contained_within: z.array(placeIdSchema).optional(),
  country: z.string().optional(),
  country_code: countryCodeSchema.optional(),
  full_name: z.string(),
  geo: geoSchema.optional(),
  id: placeIdSchema,
  name: z.string().optional(),
  place_type: placeTypeSchema.optional(),
});

export const pollOptionSchema = z.object({
  label: pollOptionLabelSchema,
  position: z.number(),
  votes: z.number(),
});

export const tweetComplianceDataSchema = z.union([
  tweetDeleteComplianceSchemaSchema,
  tweetWithheldComplianceSchemaSchema,
  tweetDropComplianceSchemaSchema,
  tweetUndropComplianceSchemaSchema,
  tweetEditComplianceSchemaSchema,
]);

export const tweetComplianceStreamResponseSchema = z.union([
  z.object({
    data: tweetComplianceDataSchema,
  }),
  z.object({
    errors: z.array(problemSchema),
  }),
]);

export const tweetLabelDataSchema = z.union([tweetNoticeSchemaSchema, tweetUnviewableSchemaSchema]);

export const tweetLabelStreamResponseSchema = z.union([
  z.object({
    data: tweetLabelDataSchema,
  }),
  z.object({
    errors: z.array(problemSchema),
  }),
]);

export const urlFieldsSchema = z.object({
  description: z.string().optional(),
  display_url: z.string().optional(),
  expanded_url: urlSchema.optional(),
  images: z.array(urlImageSchema).optional(),
  media_key: mediaKeySchema.optional(),
  status: httpStatusCodeSchema.optional(),
  title: z.string().optional(),
  unwound_url: z.string().optional(),
  url: urlSchema,
});

export const urlEntitySchema = entityIndicesInclusiveExclusiveSchema.and(urlFieldsSchema);

export const userProfileModificationComplianceSchemaSchema = z.object({
  user_profile_modification: userProfileModificationObjectSchemaSchema,
});

export const userComplianceDataSchema = z.union([
  userProtectComplianceSchemaSchema,
  userUnprotectComplianceSchemaSchema,
  userDeleteComplianceSchemaSchema,
  userUndeleteComplianceSchemaSchema,
  userSuspendComplianceSchemaSchema,
  userUnsuspendComplianceSchemaSchema,
  userWithheldComplianceSchemaSchema,
  userScrubGeoSchemaSchema,
  userProfileModificationComplianceSchemaSchema,
]);

export const listBatchComplianceJobsResponseSchema = get2ComplianceJobsResponseSchema;

export const createBatchComplianceJobResponseSchema = createComplianceJobResponseSchema;

export const dmConversationIdCreateResponseSchema = createDmEventResponseSchema;

export const getTweetsComplianceStreamResponseSchema = tweetComplianceStreamResponseSchema;

export const get2TweetsCountsAllResponseSchema = z.object({
  data: z.array(searchCountSchema).optional(),
  errors: z.array(problemSchema).optional(),
  meta: z
    .object({
      newest_id: newestIdSchema.optional(),
      next_token: nextTokenSchema.optional(),
      oldest_id: oldestIdSchema.optional(),
      total_tweet_count: aggregateSchema.optional(),
    })
    .optional(),
});

export const tweetCountsRecentSearchResponseSchema = get2TweetsCountsRecentResponseSchema;

export const getTweetsLabelStreamResponseSchema = tweetLabelStreamResponseSchema;

export const getRulesResponseSchema = rulesLookupResponseSchema;

export const addOrDeleteRulesRequestSchema = z.union([addRulesRequestSchema, deleteRulesRequestSchema]);

export const addOrDeleteRulesResponse2Schema = addOrDeleteRulesResponseSchema;

export const userComplianceStreamResponseSchema = z.union([
  z.object({
    data: userComplianceDataSchema,
  }),
  z.object({
    errors: z.array(problemSchema),
  }),
]);

export const usersIdBlockDataSchema = z.object({
  body: blockUserRequestSchema,
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
});

export const postUsersIdBookmarksDataSchema = z.object({
  body: bookmarkAddRequestSchema,
  path: z.object({
    id: userIdMatchesAuthenticatedUserSchema,
  }),
});

export const dmAttachmentsSchema = z.array(dmMediaAttachmentSchema);

export const createTextMessageRequestSchema = z.object({
  attachments: dmAttachmentsSchema.optional(),
  text: z.string(),
});

export const createAttachmentsMessageRequestSchema = z.object({
  attachments: dmAttachmentsSchema,
  text: z.string().optional(),
});

export const pollSchema = z.object({
  duration_minutes: z.number().optional(),
  end_datetime: z.string().optional(),
  id: pollIdSchema,
  options: z.array(pollOptionSchema),
  voting_status: z.union([z.literal('open'), z.literal('closed')]).optional(),
});

export const mentionEntitySchema = entityIndicesInclusiveExclusiveSchema.and(mentionFieldsSchema);

export const fullTextEntitiesSchema = z.object({
  annotations: z
    .array(
      entityIndicesInclusiveInclusiveSchema.and(
        z.object({
          normalized_text: z.string().optional(),
          probability: z.number().optional(),
          type: z.string().optional(),
        }),
      ),
    )
    .optional(),
  cashtags: z.array(cashtagEntitySchema).optional(),
  hashtags: z.array(hashtagEntitySchema).optional(),
  mentions: z.array(mentionEntitySchema).optional(),
  urls: z.array(urlEntitySchema).optional(),
});

export const userSchema = z.object({
  created_at: z.string().optional(),
  description: z.string().optional(),
  entities: z
    .object({
      description: fullTextEntitiesSchema.optional(),
      url: z
        .object({
          urls: z.array(urlEntitySchema).optional(),
        })
        .optional(),
    })
    .optional(),
  id: userIdSchema,
  location: z.string().optional(),
  name: z.string(),
  pinned_tweet_id: tweetIdSchema.optional(),
  profile_image_url: z.string().optional(),
  protected: z.boolean().optional(),
  public_metrics: z
    .object({
      followers_count: z.number(),
      following_count: z.number(),
      listed_count: z.number(),
      tweet_count: z.number(),
    })
    .optional(),
  url: z.string().optional(),
  username: userNameSchema,
  verified: z.boolean().optional(),
  verified_type: z.string().optional(),
  withheld: userWithheldSchema.optional(),
});

export const createMessageRequestSchema = z.union([
  createTextMessageRequestSchema,
  createAttachmentsMessageRequestSchema,
]);

export const dmConversationByIdEventIdCreateDataSchema = z.object({
  body: createMessageRequestSchema.optional(),
  path: z.object({
    dm_conversation_id: z.string(),
  }),
});

export const tweetCountsFullArchiveSearchResponseSchema = get2TweetsCountsAllResponseSchema;

export const addOrDeleteRulesDataSchema = z.object({
  body: addOrDeleteRulesRequestSchema,
  query: z
    .object({
      dry_run: z.boolean().optional(),
    })
    .optional(),
});

export const getUsersComplianceStreamResponseSchema = userComplianceStreamResponseSchema;

export const createDmConversationRequestSchema = z.object({
  conversation_type: z.literal('Group'),
  message: createMessageRequestSchema,
  participant_ids: dmParticipantsSchema,
});

export const tweetSchema = z.object({
  attachments: z
    .object({
      media_keys: z.array(mediaKeySchema).optional(),
      poll_ids: z.array(pollIdSchema).optional(),
    })
    .optional(),
  author_id: userIdSchema.optional(),
  context_annotations: z.array(contextAnnotationSchema).optional(),
  conversation_id: tweetIdSchema.optional(),
  created_at: z.string().optional(),
  edit_controls: z
    .object({
      editable_until: z.string(),
      edits_remaining: z.number(),
      is_edit_eligible: z.boolean(),
    })
    .optional(),
  edit_history_tweet_ids: z.array(tweetIdSchema),
  entities: fullTextEntitiesSchema.optional(),
  geo: z
    .object({
      coordinates: pointSchema.optional(),
      place_id: placeIdSchema.optional(),
    })
    .optional(),
  id: tweetIdSchema,
  in_reply_to_user_id: userIdSchema.optional(),
  lang: z.string().optional(),
  non_public_metrics: z
    .object({
      impression_count: z.number().optional(),
    })
    .optional(),
  organic_metrics: z
    .object({
      impression_count: z.number(),
      like_count: z.number(),
      reply_count: z.number(),
      retweet_count: z.number(),
    })
    .optional(),
  possibly_sensitive: z.boolean().optional(),
  promoted_metrics: z
    .object({
      impression_count: z.number().optional(),
      like_count: z.number().optional(),
      reply_count: z.number().optional(),
      retweet_count: z.number().optional(),
    })
    .optional(),
  public_metrics: z
    .object({
      impression_count: z.number(),
      like_count: z.number(),
      quote_count: z.number().optional(),
      reply_count: z.number(),
      retweet_count: z.number(),
    })
    .optional(),
  referenced_tweets: z
    .array(
      z.object({
        id: tweetIdSchema,
        type: z.union([z.literal('retweeted'), z.literal('quoted'), z.literal('replied_to')]),
      }),
    )
    .optional(),
  reply_settings: replySettingsSchema.optional(),
  source: z.string().optional(),
  text: tweetTextSchema,
  withheld: tweetWithheldSchema.optional(),
});

export const expansionsSchema = z.object({
  media: z.array(mediaSchema).optional(),
  places: z.array(placeSchema).optional(),
  polls: z.array(pollSchema).optional(),
  topics: z.array(topicSchema).optional(),
  tweets: z.array(tweetSchema).optional(),
  users: z.array(userSchema).optional(),
});

export const get2DmConversationsIdDmEventsResponseSchema = z.object({
  data: z.array(dmEventSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2DmConversationsWithParticipantIdDmEventsResponseSchema = z.object({
  data: z.array(dmEventSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2DmEventsResponseSchema = z.object({
  data: z.array(dmEventSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2ListsIdFollowersResponseSchema = z.object({
  data: z.array(userSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2ListsIdMembersResponseSchema = z.object({
  data: z.array(userSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2ListsIdResponseSchema = z.object({
  data: listSchema.optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2ListsIdTweetsResponseSchema = z.object({
  data: z.array(tweetSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2SpacesByCreatorIdsResponseSchema = z.object({
  data: z.array(spaceSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2SpacesIdBuyersResponseSchema = z.object({
  data: z.array(userSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2SpacesIdResponseSchema = z.object({
  data: spaceSchema.optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2SpacesIdTweetsResponseSchema = z.object({
  data: z.array(tweetSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2SpacesResponseSchema = z.object({
  data: z.array(spaceSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2SpacesSearchResponseSchema = z.object({
  data: z.array(spaceSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2TweetsFirehoseStreamResponseSchema = z.object({
  data: tweetSchema.optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2TweetsIdLikingUsersResponseSchema = z.object({
  data: z.array(userSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2TweetsIdQuoteTweetsResponseSchema = z.object({
  data: z.array(tweetSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2TweetsIdResponseSchema = z.object({
  data: tweetSchema.optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2TweetsIdRetweetedByResponseSchema = z.object({
  data: z.array(userSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2TweetsResponseSchema = z.object({
  data: z.array(tweetSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2TweetsSample10StreamResponseSchema = z.object({
  data: tweetSchema.optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2TweetsSampleStreamResponseSchema = z.object({
  data: tweetSchema.optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2TweetsSearchAllResponseSchema = z.object({
  data: z.array(tweetSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      newest_id: newestIdSchema.optional(),
      next_token: nextTokenSchema.optional(),
      oldest_id: oldestIdSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2TweetsSearchRecentResponseSchema = z.object({
  data: z.array(tweetSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      newest_id: newestIdSchema.optional(),
      next_token: nextTokenSchema.optional(),
      oldest_id: oldestIdSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2TweetsSearchStreamResponseSchema = z.object({
  data: tweetSchema.optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2UsersByResponseSchema = z.object({
  data: z.array(userSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2UsersByUsernameUsernameResponseSchema = z.object({
  data: userSchema.optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2UsersIdBlockingResponseSchema = z.object({
  data: z.array(userSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersIdBookmarksResponseSchema = z.object({
  data: z.array(tweetSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersIdFollowedListsResponseSchema = z.object({
  data: z.array(listSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersIdFollowersResponseSchema = z.object({
  data: z.array(userSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersIdFollowingResponseSchema = z.object({
  data: z.array(userSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersIdLikedTweetsResponseSchema = z.object({
  data: z.array(tweetSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersIdListMembershipsResponseSchema = z.object({
  data: z.array(listSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersIdMentionsResponseSchema = z.object({
  data: z.array(tweetSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      newest_id: newestIdSchema.optional(),
      next_token: nextTokenSchema.optional(),
      oldest_id: oldestIdSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersIdMutingResponseSchema = z.object({
  data: z.array(userSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersIdOwnedListsResponseSchema = z.object({
  data: z.array(listSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      next_token: nextTokenSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersIdPinnedListsResponseSchema = z.object({
  data: z.array(listSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersIdResponseSchema = z.object({
  data: userSchema.optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2UsersIdTimelinesReverseChronologicalResponseSchema = z.object({
  data: z.array(tweetSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      newest_id: newestIdSchema.optional(),
      next_token: nextTokenSchema.optional(),
      oldest_id: oldestIdSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersIdTweetsResponseSchema = z.object({
  data: z.array(tweetSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  meta: z
    .object({
      newest_id: newestIdSchema.optional(),
      next_token: nextTokenSchema.optional(),
      oldest_id: oldestIdSchema.optional(),
      previous_token: previousTokenSchema.optional(),
      result_count: resultCountSchema.optional(),
    })
    .optional(),
});

export const get2UsersMeResponseSchema = z.object({
  data: userSchema.optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const get2UsersResponseSchema = z.object({
  data: z.array(userSchema).optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const streamingTweetResponseSchema = z.object({
  data: tweetSchema.optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
});

export const dmConversationIdCreateDataSchema = z.object({
  body: createDmConversationRequestSchema.optional(),
});

export const getDmConversationsWithParticipantIdDmEventsResponseSchema =
  get2DmConversationsWithParticipantIdDmEventsResponseSchema;

export const dmConversationWithUserEventIdCreateDataSchema = z.object({
  body: createMessageRequestSchema.optional(),
  path: z.object({
    participant_id: userIdSchema,
  }),
});

export const getDmConversationsIdDmEventsResponseSchema = get2DmConversationsIdDmEventsResponseSchema;

export const getDmEventsResponseSchema = get2DmEventsResponseSchema;

export const listIdGetResponseSchema = get2ListsIdResponseSchema;

export const listGetFollowersResponseSchema = get2ListsIdFollowersResponseSchema;

export const listGetMembersResponseSchema = get2ListsIdMembersResponseSchema;

export const listsIdTweetsResponseSchema = get2ListsIdTweetsResponseSchema;

export const findSpacesByIdsResponseSchema = get2SpacesResponseSchema;

export const findSpacesByCreatorIdsResponseSchema = get2SpacesByCreatorIdsResponseSchema;

export const searchSpacesResponseSchema = get2SpacesSearchResponseSchema;

export const findSpaceByIdResponseSchema = get2SpacesIdResponseSchema;

export const spaceBuyersResponseSchema = get2SpacesIdBuyersResponseSchema;

export const spaceTweetsResponseSchema = get2SpacesIdTweetsResponseSchema;

export const findTweetsByIdResponseSchema = get2TweetsResponseSchema;

export const getTweetsFirehoseStreamResponseSchema = streamingTweetResponseSchema;

export const sampleStreamResponseSchema = streamingTweetResponseSchema;

export const getTweetsSample10StreamResponseSchema = get2TweetsSample10StreamResponseSchema;

export const tweetsFullarchiveSearchResponseSchema = get2TweetsSearchAllResponseSchema;

export const tweetsRecentSearchResponseSchema = get2TweetsSearchRecentResponseSchema;

export const filteredStreamingTweetResponseSchema = z.object({
  data: tweetSchema.optional(),
  errors: z.array(problemSchema).optional(),
  includes: expansionsSchema.optional(),
  matching_rules: z
    .array(
      z.object({
        id: ruleIdSchema,
        tag: ruleTagSchema.optional(),
      }),
    )
    .optional(),
});

export const findTweetByIdResponseSchema = get2TweetsIdResponseSchema;

export const tweetsIdLikingUsersResponseSchema = get2TweetsIdLikingUsersResponseSchema;

export const findTweetsThatQuoteAtweetResponseSchema = get2TweetsIdQuoteTweetsResponseSchema;

export const tweetsIdRetweetingUsersResponseSchema = get2TweetsIdRetweetedByResponseSchema;

export const findUsersByIdResponseSchema = get2UsersResponseSchema;

export const findUsersByUsernameResponseSchema = get2UsersByResponseSchema;

export const findUserByUsernameResponseSchema = get2UsersByUsernameUsernameResponseSchema;

export const findMyUserResponseSchema = get2UsersMeResponseSchema;

export const findUserByIdResponseSchema = get2UsersIdResponseSchema;

export const usersIdBlockingResponseSchema = get2UsersIdBlockingResponseSchema;

export const getUsersIdBookmarksResponseSchema = get2UsersIdBookmarksResponseSchema;

export const userFollowedListsResponseSchema = get2UsersIdFollowedListsResponseSchema;

export const usersIdFollowersResponseSchema = get2UsersIdFollowersResponseSchema;

export const usersIdFollowingResponseSchema = get2UsersIdFollowingResponseSchema;

export const usersIdLikedTweetsResponseSchema = get2UsersIdLikedTweetsResponseSchema;

export const getUserListMembershipsResponseSchema = get2UsersIdListMembershipsResponseSchema;

export const usersIdMentionsResponseSchema = get2UsersIdMentionsResponseSchema;

export const usersIdMutingResponseSchema = get2UsersIdMutingResponseSchema;

export const listUserOwnedListsResponseSchema = get2UsersIdOwnedListsResponseSchema;

export const listUserPinnedListsResponseSchema = get2UsersIdPinnedListsResponseSchema;

export const usersIdTimelineResponseSchema = get2UsersIdTimelinesReverseChronologicalResponseSchema;

export const usersIdTweetsResponseSchema = get2UsersIdTweetsResponseSchema;

export const searchStreamResponseSchema = filteredStreamingTweetResponseSchema;
