// This file is auto-generated by @hey-api/openapi-ts

export type AddOrDeleteRulesRequest = AddRulesRequest | DeleteRulesRequest;

/**
 * A response from modifying user-specified stream filtering rules.
 */
export type AddOrDeleteRulesResponse = {
  /**
   * All user-specified stream filtering rules that were created.
   */
  data?: Array<Rule>;
  errors?: Array<Problem>;
  meta: RulesResponseMetadata;
};

/**
 * A request to add a user-specified stream filtering rule.
 */
export type AddRulesRequest = {
  add: Array<RuleNoId>;
};

/**
 * The sum of results returned in this response.
 */
export type Aggregate = number;

export type AnimatedGif = Media & {
  preview_image_url?: string;
  variants?: Variants;
};

export type BlockUserMutationResponse = {
  data?: {
    blocking?: boolean;
  };
  errors?: Array<Problem>;
};

export type BlockUserRequest = {
  target_user_id: UserId;
};

export type BookmarkAddRequest = {
  tweet_id: TweetId;
};

export type BookmarkMutationResponse = {
  data?: {
    bookmarked?: boolean;
  };
  errors?: Array<Problem>;
};

export type CashtagEntity = EntityIndicesInclusiveExclusive & CashtagFields;

/**
 * Represent the portion of text recognized as a Cashtag, and its start and end position within the text.
 */
export type CashtagFields = {
  tag: string;
};

/**
 * Your client has gone away.
 */
export type ClientDisconnectedProblem = Problem;

/**
 * A problem that indicates your client is forbidden from making this request.
 */
export type ClientForbiddenProblem = Problem & {
  reason?: 'official-client-forbidden' | 'client-not-enrolled';
  registration_url?: string;
};

export type reason = 'official-client-forbidden' | 'client-not-enrolled';

export type ComplianceJob = {
  created_at: CreatedAt;
  download_expires_at: DownloadExpiration;
  download_url: DownloadUrl;
  id: JobId;
  name?: ComplianceJobName;
  status: ComplianceJobStatus;
  type: ComplianceJobType;
  upload_expires_at: UploadExpiration;
  upload_url: UploadUrl;
};

/**
 * User-provided name for a compliance job.
 */
export type ComplianceJobName = string;

/**
 * Status of a compliance job.
 */
export type ComplianceJobStatus = 'created' | 'in_progress' | 'failed' | 'complete' | 'expired';

/**
 * Type of compliance job to list.
 */
export type ComplianceJobType = 'tweets' | 'users';

/**
 * You cannot create a new job if one is already in progress.
 */
export type ConflictProblem = Problem;

/**
 * A problem that indicates something is wrong with the connection.
 */
export type ConnectionExceptionProblem = Problem & {
  connection_issue?: 'TooManyConnections' | 'ProvisioningSubscription' | 'RuleConfigurationIssue' | 'RulesInvalidIssue';
};

export type connection_issue =
  | 'TooManyConnections'
  | 'ProvisioningSubscription'
  | 'RuleConfigurationIssue'
  | 'RulesInvalidIssue';

/**
 * Annotation inferred from the Tweet text.
 */
export type ContextAnnotation = {
  domain: ContextAnnotationDomainFields;
  entity: ContextAnnotationEntityFields;
};

/**
 * Represents the data for the context annotation domain.
 */
export type ContextAnnotationDomainFields = {
  /**
   * Description of the context annotation domain.
   */
  description?: string;
  /**
   * The unique id for a context annotation domain.
   */
  id: string;
  /**
   * Name of the context annotation domain.
   */
  name?: string;
};

/**
 * Represents the data for the context annotation entity.
 */
export type ContextAnnotationEntityFields = {
  /**
   * Description of the context annotation entity.
   */
  description?: string;
  /**
   * The unique id for a context annotation entity.
   */
  id: string;
  /**
   * Name of the context annotation entity.
   */
  name?: string;
};

/**
 * A two-letter ISO 3166-1 alpha-2 country code.
 */
export type CountryCode = string;

export type CreateAttachmentsMessageRequest = {
  attachments: DmAttachments;
  /**
   * Text of the message.
   */
  text?: string;
};

/**
 * A request to create a new batch compliance job.
 */
export type CreateComplianceJobRequest = {
  name?: ComplianceJobName;
  /**
   * If true, this endpoint will return a pre-signed URL with resumable uploads enabled.
   */
  resumable?: boolean;
  /**
   * Type of compliance job to list.
   */
  type: 'tweets' | 'users';
};

/**
 * Type of compliance job to list.
 */
export type type = 'tweets' | 'users';

export type CreateComplianceJobResponse = {
  data?: ComplianceJob;
  errors?: Array<Problem>;
};

export type CreateDmConversationRequest = {
  /**
   * The conversation type that is being created.
   */
  conversation_type: 'Group';
  message: CreateMessageRequest;
  participant_ids: DmParticipants;
};

/**
 * The conversation type that is being created.
 */
export type conversation_type = 'Group';

export type CreateDmEventResponse = {
  data?: {
    dm_conversation_id: DmConversationId;
    dm_event_id: DmEventId;
  };
  errors?: Array<Problem>;
};

export type CreateMessageRequest = CreateTextMessageRequest | CreateAttachmentsMessageRequest;

export type CreateTextMessageRequest = {
  attachments?: DmAttachments;
  /**
   * Text of the message.
   */
  text: string;
};

/**
 * Creation time of the compliance job.
 */
export type CreatedAt = string;

/**
 * A response from deleting user-specified stream filtering rules.
 */
export type DeleteRulesRequest = {
  /**
   * IDs and values of all deleted user-specified stream filtering rules.
   */
  delete: {
    /**
     * IDs of all deleted user-specified stream filtering rules.
     */
    ids?: Array<RuleId>;
    /**
     * Values of all deleted user-specified stream filtering rules.
     */
    values?: Array<RuleValue>;
  };
};

/**
 * A problem that indicates that the resource requested violates the precepts of this API.
 */
export type DisallowedResourceProblem = Problem & {
  resource_id: string;
  resource_type: 'user' | 'tweet' | 'media' | 'list' | 'space';
  section: 'data' | 'includes';
};

export type resource_type = 'user' | 'tweet' | 'media' | 'list' | 'space';

export type section = 'data' | 'includes';

/**
 * Attachments to a DM Event.
 */
export type DmAttachments = Array<DmMediaAttachment>;

/**
 * Unique identifier of a DM conversation. This can either be a numeric string, or a pair of numeric strings separated by a '-' character in the case of one-on-one DM Conversations.
 */
export type DmConversationId = string;

export type DmEvent = {
  /**
   * Specifies the type of attachments (if any) present in this DM.
   */
  attachments?: {
    /**
     * A list of card IDs (if cards are attached).
     */
    card_ids?: Array<string>;
    /**
     * A list of Media Keys for each one of the media attachments (if media are attached).
     */
    media_keys?: Array<MediaKey>;
  };
  created_at?: string;
  dm_conversation_id?: DmConversationId;
  event_type: string;
  id: DmEventId;
  /**
   * A list of participants for a ParticipantsJoin or ParticipantsLeave event_type.
   */
  participant_ids?: Array<UserId>;
  /**
   * A list of Tweets this DM refers to.
   */
  referenced_tweets?: Array<{
    id: TweetId;
  }>;
  sender_id?: UserId;
  text?: string;
};

/**
 * Unique identifier of a DM Event.
 */
export type DmEventId = string;

export type DmMediaAttachment = {
  media_id: MediaId;
};

/**
 * Participants for the DM Conversation.
 */
export type DmParticipants = Array<UserId>;

/**
 * Expiration time of the download URL.
 */
export type DownloadExpiration = string;

/**
 * URL from which the user will retrieve their compliance results.
 */
export type DownloadUrl = string;

/**
 * The rule you have submitted is a duplicate.
 */
export type DuplicateRuleProblem = Problem & {
  id?: string;
  value?: string;
};

/**
 * The end time of the bucket.
 */
export type End = string;

/**
 * Represent a boundary range (start and end index) for a recognized entity (for example a hashtag or a mention). `start` must be smaller than `end`.  The start index is inclusive, the end index is exclusive.
 */
export type EntityIndicesInclusiveExclusive = {
  /**
   * Index (zero-based) at which position this entity ends.  The index is exclusive.
   */
  end: number;
  /**
   * Index (zero-based) at which position this entity starts.  The index is inclusive.
   */
  start: number;
};

/**
 * Represent a boundary range (start and end index) for a recognized entity (for example a hashtag or a mention). `start` must be smaller than `end`.  The start index is inclusive, the end index is inclusive.
 */
export type EntityIndicesInclusiveInclusive = {
  /**
   * Index (zero-based) at which position this entity ends.  The index is inclusive.
   */
  end: number;
  /**
   * Index (zero-based) at which position this entity starts.  The index is inclusive.
   */
  start: number;
};

export type Error = {
  code: number;
  message: string;
};

export type Expansions = {
  media?: Array<Media>;
  places?: Array<Place>;
  polls?: Array<Poll>;
  topics?: Array<Topic>;
  tweets?: Array<Tweet>;
  users?: Array<User>;
};

/**
 * A problem that indicates that you are not allowed to see a particular field on a Tweet, User, etc.
 */
export type FieldUnauthorizedProblem = Problem & {
  field: string;
  resource_type: 'user' | 'tweet' | 'media' | 'list' | 'space';
  section: 'data' | 'includes';
};

/**
 * A Tweet or error that can be returned by the streaming Tweet API. The values returned with a successful streamed Tweet includes the user provided rules that the Tweet matched.
 */
export type FilteredStreamingTweetResponse = {
  data?: Tweet;
  errors?: Array<Problem>;
  includes?: Expansions;
  /**
   * The list of rules which matched the Tweet
   */
  matching_rules?: Array<{
    id: RuleId;
    tag?: RuleTag;
  }>;
};

export type FullTextEntities = {
  annotations?: Array<
    EntityIndicesInclusiveInclusive & {
      /**
       * Text used to determine annotation.
       */
      normalized_text?: string;
      /**
       * Confidence factor for annotation type.
       */
      probability?: number;
      /**
       * Annotation type.
       */
      type?: string;
    }
  >;
  cashtags?: Array<CashtagEntity>;
  hashtags?: Array<HashtagEntity>;
  mentions?: Array<MentionEntity>;
  urls?: Array<UrlEntity>;
};

/**
 * A generic problem with no additional information beyond that provided by the HTTP status code.
 */
export type GenericProblem = Problem;

export type Geo = {
  bbox: [number, number, number, number];
  geometry?: Point;
  properties: {
    [key: string]: unknown;
  };
  type: 'Feature';
};

export type type2 = 'Feature';

export type Get2ComplianceJobsIdResponse = {
  data?: ComplianceJob;
  errors?: Array<Problem>;
};

export type Get2ComplianceJobsResponse = {
  data?: Array<ComplianceJob>;
  errors?: Array<Problem>;
  meta?: {
    result_count?: ResultCount;
  };
};

export type Get2DmConversationsIdDmEventsResponse = {
  data?: Array<DmEvent>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2DmConversationsWithParticipantIdDmEventsResponse = {
  data?: Array<DmEvent>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2DmEventsResponse = {
  data?: Array<DmEvent>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2ListsIdFollowersResponse = {
  data?: Array<User>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2ListsIdMembersResponse = {
  data?: Array<User>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2ListsIdResponse = {
  data?: List;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2ListsIdTweetsResponse = {
  data?: Array<Tweet>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2SpacesByCreatorIdsResponse = {
  data?: Array<Space>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    result_count?: ResultCount;
  };
};

export type Get2SpacesIdBuyersResponse = {
  data?: Array<User>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2SpacesIdResponse = {
  data?: Space;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2SpacesIdTweetsResponse = {
  data?: Array<Tweet>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2SpacesResponse = {
  data?: Array<Space>;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2SpacesSearchResponse = {
  data?: Array<Space>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    result_count?: ResultCount;
  };
};

export type Get2TweetsCountsAllResponse = {
  data?: Array<SearchCount>;
  errors?: Array<Problem>;
  meta?: {
    newest_id?: NewestId;
    next_token?: NextToken;
    oldest_id?: OldestId;
    total_tweet_count?: Aggregate;
  };
};

export type Get2TweetsCountsRecentResponse = {
  data?: Array<SearchCount>;
  errors?: Array<Problem>;
  meta?: {
    newest_id?: NewestId;
    next_token?: NextToken;
    oldest_id?: OldestId;
    total_tweet_count?: Aggregate;
  };
};

export type Get2TweetsFirehoseStreamResponse = {
  data?: Tweet;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2TweetsIdLikingUsersResponse = {
  data?: Array<User>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2TweetsIdQuoteTweetsResponse = {
  data?: Array<Tweet>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    result_count?: ResultCount;
  };
};

export type Get2TweetsIdResponse = {
  data?: Tweet;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2TweetsIdRetweetedByResponse = {
  data?: Array<User>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2TweetsResponse = {
  data?: Array<Tweet>;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2TweetsSample10StreamResponse = {
  data?: Tweet;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2TweetsSampleStreamResponse = {
  data?: Tweet;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2TweetsSearchAllResponse = {
  data?: Array<Tweet>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    newest_id?: NewestId;
    next_token?: NextToken;
    oldest_id?: OldestId;
    result_count?: ResultCount;
  };
};

export type Get2TweetsSearchRecentResponse = {
  data?: Array<Tweet>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    newest_id?: NewestId;
    next_token?: NextToken;
    oldest_id?: OldestId;
    result_count?: ResultCount;
  };
};

export type Get2TweetsSearchStreamResponse = {
  data?: Tweet;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2UsersByResponse = {
  data?: Array<User>;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2UsersByUsernameUsernameResponse = {
  data?: User;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2UsersIdBlockingResponse = {
  data?: Array<User>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2UsersIdBookmarksResponse = {
  data?: Array<Tweet>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2UsersIdFollowedListsResponse = {
  data?: Array<List>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2UsersIdFollowersResponse = {
  data?: Array<User>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2UsersIdFollowingResponse = {
  data?: Array<User>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2UsersIdLikedTweetsResponse = {
  data?: Array<Tweet>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2UsersIdListMembershipsResponse = {
  data?: Array<List>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2UsersIdMentionsResponse = {
  data?: Array<Tweet>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    newest_id?: NewestId;
    next_token?: NextToken;
    oldest_id?: OldestId;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2UsersIdMutingResponse = {
  data?: Array<User>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2UsersIdOwnedListsResponse = {
  data?: Array<List>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    next_token?: NextToken;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2UsersIdPinnedListsResponse = {
  data?: Array<List>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    result_count?: ResultCount;
  };
};

export type Get2UsersIdResponse = {
  data?: User;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2UsersIdTimelinesReverseChronologicalResponse = {
  data?: Array<Tweet>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    newest_id?: NewestId;
    next_token?: NextToken;
    oldest_id?: OldestId;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2UsersIdTweetsResponse = {
  data?: Array<Tweet>;
  errors?: Array<Problem>;
  includes?: Expansions;
  meta?: {
    newest_id?: NewestId;
    next_token?: NextToken;
    oldest_id?: OldestId;
    previous_token?: PreviousToken;
    result_count?: ResultCount;
  };
};

export type Get2UsersMeResponse = {
  data?: User;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type Get2UsersResponse = {
  data?: Array<User>;
  errors?: Array<Problem>;
  includes?: Expansions;
};

export type HashtagEntity = EntityIndicesInclusiveExclusive & HashtagFields;

/**
 * Represent the portion of text recognized as a Hashtag, and its start and end position within the text.
 */
export type HashtagFields = {
  /**
   * The text of the Hashtag.
   */
  tag: string;
};

/**
 * HTTP Status Code.
 */
export type HttpStatusCode = number;

/**
 * A problem that indicates this request is invalid.
 */
export type InvalidRequestProblem = Problem & {
  errors?: Array<{
    message?: string;
    parameters?: {
      [key: string]: Array<string>;
    };
  }>;
};

/**
 * The rule you have submitted is invalid.
 */
export type InvalidRuleProblem = Problem;

/**
 * Compliance Job ID.
 */
export type JobId = string;

/**
 * A Twitter List is a curated group of accounts.
 */
export type List = {
  created_at?: string;
  description?: string;
  follower_count?: number;
  id: ListId;
  member_count?: number;
  /**
   * The name of this List.
   */
  name: string;
  owner_id?: UserId;
  private?: boolean;
};

export type ListAddUserRequest = {
  user_id: UserId;
};

export type ListCreateRequest = {
  description?: string;
  name: string;
  private?: boolean;
};

export type ListCreateResponse = {
  /**
   * A Twitter List is a curated group of accounts.
   */
  data?: {
    id: ListId;
    /**
     * The name of this List.
     */
    name: string;
  };
  errors?: Array<Problem>;
};

export type ListDeleteResponse = {
  data?: {
    deleted?: boolean;
  };
  errors?: Array<Problem>;
};

export type ListFollowedRequest = {
  list_id: ListId;
};

export type ListFollowedResponse = {
  data?: {
    following?: boolean;
  };
  errors?: Array<Problem>;
};

/**
 * The unique identifier of this List.
 */
export type ListId = string;

export type ListMutateResponse = {
  data?: {
    is_member?: boolean;
  };
  errors?: Array<Problem>;
};

export type ListPinnedRequest = {
  list_id: ListId;
};

export type ListPinnedResponse = {
  data?: {
    pinned?: boolean;
  };
  errors?: Array<Problem>;
};

export type ListUnpinResponse = {
  data?: {
    pinned?: boolean;
  };
  errors?: Array<Problem>;
};

export type ListUpdateRequest = {
  description?: string;
  name?: string;
  private?: boolean;
};

export type ListUpdateResponse = {
  data?: {
    updated?: boolean;
  };
  errors?: Array<Problem>;
};

export type Media = {
  height?: MediaHeight;
  media_key?: MediaKey;
  type: string;
  width?: MediaWidth;
};

/**
 * The height of the media in pixels.
 */
export type MediaHeight = number;

/**
 * The unique identifier of this Media.
 */
export type MediaId = string;

/**
 * The Media Key identifier for this attachment.
 */
export type MediaKey = string;

/**
 * The width of the media in pixels.
 */
export type MediaWidth = number;

export type MentionEntity = EntityIndicesInclusiveExclusive & MentionFields;

/**
 * Represent the portion of text recognized as a User mention, and its start and end position within the text.
 */
export type MentionFields = {
  id?: UserId;
  username: UserName;
};

export type MuteUserMutationResponse = {
  data?: {
    muting?: boolean;
  };
  errors?: Array<Problem>;
};

export type MuteUserRequest = {
  target_user_id: UserId;
};

/**
 * The newest id in this response.
 */
export type NewestId = string;

/**
 * The next token.
 */
export type NextToken = string;

/**
 * A problem that indicates the user's rule set is not compliant.
 */
export type NonCompliantRulesProblem = Problem;

/**
 * A problem that indicates your client application does not have the required OAuth1 permissions for the requested endpoint.
 */
export type Oauth1PermissionsProblem = Problem;

/**
 * The oldest id in this response.
 */
export type OldestId = string;

/**
 * You have been disconnected for operational reasons.
 */
export type OperationalDisconnectProblem = Problem & {
  disconnect_type?:
    | 'OperationalDisconnect'
    | 'UpstreamOperationalDisconnect'
    | 'ForceDisconnect'
    | 'UpstreamUncleanDisconnect'
    | 'SlowReader'
    | 'InternalError'
    | 'ClientApplicationStateDegraded'
    | 'InvalidRules';
};

export type disconnect_type =
  | 'OperationalDisconnect'
  | 'UpstreamOperationalDisconnect'
  | 'ForceDisconnect'
  | 'UpstreamUncleanDisconnect'
  | 'SlowReader'
  | 'InternalError'
  | 'ClientApplicationStateDegraded'
  | 'InvalidRules';

/**
 * A base32 pagination token.
 */
export type PaginationToken32 = string;

/**
 * A base36 pagination token.
 */
export type PaginationToken36 = string;

/**
 * A 'long' pagination token.
 */
export type PaginationTokenLong = string;

export type Photo = Media & {
  alt_text?: string;
  url?: string;
};

export type Place = {
  contained_within?: Array<PlaceId>;
  /**
   * The full name of the county in which this place exists.
   */
  country?: string;
  country_code?: CountryCode;
  /**
   * The full name of this place.
   */
  full_name: string;
  geo?: Geo;
  id: PlaceId;
  /**
   * The human readable name of this place.
   */
  name?: string;
  place_type?: PlaceType;
};

/**
 * The identifier for this place.
 */
export type PlaceId = string;

export type PlaceType = 'poi' | 'neighborhood' | 'city' | 'admin' | 'country' | 'unknown';

/**
 * A [GeoJson Point](https://tools.ietf.org/html/rfc7946#section-3.1.2) geometry object.
 */
export type Point = {
  coordinates: Position;
  type: 'Point';
};

export type type3 = 'Point';

/**
 * Represent a Poll attached to a Tweet.
 */
export type Poll = {
  duration_minutes?: number;
  end_datetime?: string;
  id: PollId;
  options: Array<PollOption>;
  voting_status?: 'open' | 'closed';
};

export type voting_status = 'open' | 'closed';

/**
 * Unique identifier of this poll.
 */
export type PollId = string;

/**
 * Describes a choice in a Poll object.
 */
export type PollOption = {
  label: PollOptionLabel;
  /**
   * Position of this choice in the poll.
   */
  position: number;
  /**
   * Number of users who voted for this choice.
   */
  votes: number;
};

/**
 * The text of a poll choice.
 */
export type PollOptionLabel = string;

/**
 * A [GeoJson Position](https://tools.ietf.org/html/rfc7946#section-3.1.1) in the format `[longitude,latitude]`.
 */
export type Position = [number, number];

/**
 * The previous token.
 */
export type PreviousToken = string;

/**
 * An HTTP Problem Details object, as defined in IETF RFC 7807 (https://tools.ietf.org/html/rfc7807).
 */
export type Problem = {
  detail?: string;
  status?: number;
  title: string;
  type: string;
};

/**
 * Shows who can reply a Tweet. Fields returned are everyone, mentioned_users, and following.
 */
export type ReplySettings = 'everyone' | 'mentionedUsers' | 'following' | 'other';

/**
 * A problem that indicates that a given Tweet, User, etc. does not exist.
 */
export type ResourceNotFoundProblem = Problem & {
  parameter: string;
  resource_id: string;
  resource_type: 'user' | 'tweet' | 'media' | 'list' | 'space';
  /**
   * Value will match the schema of the field.
   */
  value: string;
};

/**
 * A problem that indicates you are not allowed to see a particular Tweet, User, etc.
 */
export type ResourceUnauthorizedProblem = Problem & {
  parameter: string;
  resource_id: string;
  resource_type: 'user' | 'tweet' | 'media' | 'list' | 'space';
  section: 'data' | 'includes';
  value: string;
};

/**
 * A problem that indicates a particular Tweet, User, etc. is not available to you.
 */
export type ResourceUnavailableProblem = Problem & {
  parameter: string;
  resource_id: string;
  resource_type: 'user' | 'tweet' | 'media' | 'list' | 'space';
};

/**
 * The number of results returned in this response.
 */
export type ResultCount = number;

/**
 * A user-provided stream filtering rule.
 */
export type Rule = {
  id?: RuleId;
  tag?: RuleTag;
  value: RuleValue;
};

/**
 * Unique identifier of this rule.
 */
export type RuleId = string;

/**
 * A user-provided stream filtering rule.
 */
export type RuleNoId = {
  tag?: RuleTag;
  value: RuleValue;
};

/**
 * A tag meant for the labeling of user provided rules.
 */
export type RuleTag = string;

/**
 * The filterlang value of the rule.
 */
export type RuleValue = string;

/**
 * You have exceeded the maximum number of rules.
 */
export type RulesCapProblem = Problem;

export type RulesLookupResponse = {
  data?: Array<Rule>;
  meta: RulesResponseMetadata;
};

export type RulesRequestSummary =
  | {
      /**
       * Number of user-specified stream filtering rules that were created.
       */
      created: number;
      /**
       * Number of invalid user-specified stream filtering rules.
       */
      invalid: number;
      /**
       * Number of user-specified stream filtering rules that were not created.
       */
      not_created: number;
      /**
       * Number of valid user-specified stream filtering rules.
       */
      valid: number;
    }
  | {
      /**
       * Number of user-specified stream filtering rules that were deleted.
       */
      deleted: number;
      /**
       * Number of user-specified stream filtering rules that were not deleted.
       */
      not_deleted: number;
    };

export type RulesResponseMetadata = {
  next_token?: NextToken;
  /**
   * Number of Rules in result set.
   */
  result_count?: number;
  sent: string;
  summary?: RulesRequestSummary;
};

/**
 * Represent a Search Count Result.
 */
export type SearchCount = {
  end: End;
  start: Start;
  tweet_count: TweetCount;
};

export type Space = {
  /**
   * Creation time of the Space.
   */
  created_at?: string;
  creator_id?: UserId;
  /**
   * End time of the Space.
   */
  ended_at?: string;
  /**
   * The user ids for the hosts of the Space.
   */
  host_ids?: Array<UserId>;
  id: SpaceId;
  /**
   * An array of user ids for people who were invited to a Space.
   */
  invited_user_ids?: Array<UserId>;
  /**
   * Denotes if the Space is a ticketed Space.
   */
  is_ticketed?: boolean;
  /**
   * The language of the Space.
   */
  lang?: string;
  /**
   * The number of participants in a Space.
   */
  participant_count?: number;
  /**
   * A date time stamp for when a Space is scheduled to begin.
   */
  scheduled_start?: string;
  /**
   * An array of user ids for people who were speakers in a Space.
   */
  speaker_ids?: Array<UserId>;
  /**
   * When the Space was started as a date string.
   */
  started_at?: string;
  /**
   * The current state of the Space.
   */
  state: 'live' | 'scheduled' | 'ended';
  /**
   * The number of people who have either purchased a ticket or set a reminder for this Space.
   */
  subscriber_count?: number;
  /**
   * The title of the Space.
   */
  title?: string;
  /**
   * The topics of a Space, as selected by its creator.
   */
  topics?: Array<{
    /**
     * The description of the given topic.
     */
    description?: string;
    /**
     * An ID suitable for use in the REST API.
     */
    id: string;
    /**
     * The name of the given topic.
     */
    name: string;
  }>;
  /**
   * When the Space was last updated.
   */
  updated_at?: string;
};

/**
 * The current state of the Space.
 */
export type state = 'live' | 'scheduled' | 'ended';

/**
 * The unique identifier of this Space.
 */
export type SpaceId = string;

/**
 * The start time of the bucket.
 */
export type Start = string;

export type StreamingTweetResponse = {
  data?: Tweet;
  errors?: Array<Problem>;
  includes?: Expansions;
};

/**
 * The topic of a Space, as selected by its creator.
 */
export type Topic = {
  /**
   * The description of the given topic.
   */
  description?: string;
  id: TopicId;
  /**
   * The name of the given topic.
   */
  name: string;
};

/**
 * Unique identifier of this Topic.
 */
export type TopicId = string;

export type Tweet = {
  /**
   * Specifies the type of attachments (if any) present in this Tweet.
   */
  attachments?: {
    /**
     * A list of Media Keys for each one of the media attachments (if media are attached).
     */
    media_keys?: Array<MediaKey>;
    /**
     * A list of poll IDs (if polls are attached).
     */
    poll_ids?: Array<PollId>;
  };
  author_id?: UserId;
  context_annotations?: Array<ContextAnnotation>;
  conversation_id?: TweetId;
  /**
   * Creation time of the Tweet.
   */
  created_at?: string;
  edit_controls?: {
    /**
     * Time when Tweet is no longer editable.
     */
    editable_until: string;
    /**
     * Number of times this Tweet can be edited.
     */
    edits_remaining: number;
    /**
     * Indicates if this Tweet is eligible to be edited.
     */
    is_edit_eligible: boolean;
  };
  /**
   * A list of Tweet Ids in this Tweet chain.
   */
  edit_history_tweet_ids: Array<TweetId>;
  entities?: FullTextEntities;
  /**
   * The location tagged on the Tweet, if the user provided one.
   */
  geo?: {
    coordinates?: Point;
    place_id?: PlaceId;
  };
  id: TweetId;
  in_reply_to_user_id?: UserId;
  /**
   * Language of the Tweet, if detected by Twitter. Returned as a BCP47 language tag.
   */
  lang?: string;
  /**
   * Nonpublic engagement metrics for the Tweet at the time of the request.
   */
  non_public_metrics?: {
    /**
     * Number of times this Tweet has been viewed.
     */
    impression_count?: number;
  };
  /**
   * Organic nonpublic engagement metrics for the Tweet at the time of the request.
   */
  organic_metrics?: {
    /**
     * Number of times this Tweet has been viewed.
     */
    impression_count: number;
    /**
     * Number of times this Tweet has been liked.
     */
    like_count: number;
    /**
     * Number of times this Tweet has been replied to.
     */
    reply_count: number;
    /**
     * Number of times this Tweet has been Retweeted.
     */
    retweet_count: number;
  };
  /**
   * Indicates if this Tweet contains URLs marked as sensitive, for example content suitable for mature audiences.
   */
  possibly_sensitive?: boolean;
  /**
   * Promoted nonpublic engagement metrics for the Tweet at the time of the request.
   */
  promoted_metrics?: {
    /**
     * Number of times this Tweet has been viewed.
     */
    impression_count?: number;
    /**
     * Number of times this Tweet has been liked.
     */
    like_count?: number;
    /**
     * Number of times this Tweet has been replied to.
     */
    reply_count?: number;
    /**
     * Number of times this Tweet has been Retweeted.
     */
    retweet_count?: number;
  };
  /**
   * Engagement metrics for the Tweet at the time of the request.
   */
  public_metrics?: {
    /**
     * Number of times this Tweet has been viewed.
     */
    impression_count: number;
    /**
     * Number of times this Tweet has been liked.
     */
    like_count: number;
    /**
     * Number of times this Tweet has been quoted.
     */
    quote_count?: number;
    /**
     * Number of times this Tweet has been replied to.
     */
    reply_count: number;
    /**
     * Number of times this Tweet has been Retweeted.
     */
    retweet_count: number;
  };
  /**
   * A list of Tweets this Tweet refers to. For example, if the parent Tweet is a Retweet, a Quoted Tweet or a Reply, it will include the related Tweet referenced to by its parent.
   */
  referenced_tweets?: Array<{
    id: TweetId;
    type: 'retweeted' | 'quoted' | 'replied_to';
  }>;
  reply_settings?: ReplySettings;
  /**
   * This is deprecated.
   */
  source?: string;
  text: TweetText;
  withheld?: TweetWithheld;
};

/**
 * Tweet compliance data.
 */
export type TweetComplianceData =
  | TweetDeleteComplianceSchema
  | TweetWithheldComplianceSchema
  | TweetDropComplianceSchema
  | TweetUndropComplianceSchema
  | TweetEditComplianceSchema;

export type TweetComplianceSchema = {
  /**
   * Event time.
   */
  event_at: string;
  quote_tweet_id?: TweetId;
  tweet: {
    author_id: UserId;
    id: TweetId;
  };
};

/**
 * Tweet compliance stream events.
 */
export type TweetComplianceStreamResponse =
  | {
      data: TweetComplianceData;
    }
  | {
      errors: Array<Problem>;
    };

/**
 * The count for the bucket.
 */
export type TweetCount = number;

export type TweetCreateRequest = {
  /**
   * Card Uri Parameter. This is mutually exclusive from Quote Tweet Id, Poll, Media, and Direct Message Deep Link.
   */
  card_uri?: string;
  /**
   * Link to take the conversation from the public timeline to a private Direct Message.
   */
  direct_message_deep_link?: string;
  /**
   * Exclusive Tweet for super followers.
   */
  for_super_followers_only?: boolean;
  /**
   * Place ID being attached to the Tweet for geo location.
   */
  geo?: {
    place_id?: string;
  };
  /**
   * Media information being attached to created Tweet. This is mutually exclusive from Quote Tweet Id, Poll, and Card URI.
   */
  media?: {
    /**
     * A list of Media Ids to be attached to a created Tweet.
     */
    media_ids: Array<MediaId>;
    /**
     * A list of User Ids to be tagged in the media for created Tweet.
     */
    tagged_user_ids?: Array<UserId>;
  };
  /**
   * Nullcasted (promoted-only) Tweets do not appear in the public timeline and are not served to followers.
   */
  nullcast?: boolean;
  /**
   * Poll options for a Tweet with a poll. This is mutually exclusive from Media, Quote Tweet Id, and Card URI.
   */
  poll?: {
    /**
     * Duration of the poll in minutes.
     */
    duration_minutes: number;
    options: Array<string>;
    /**
     * Settings to indicate who can reply to the Tweet.
     */
    reply_settings?: 'following' | 'mentionedUsers';
  };
  quote_tweet_id?: TweetId;
  /**
   * Tweet information of the Tweet being replied to.
   */
  reply?: {
    /**
     * A list of User Ids to be excluded from the reply Tweet.
     */
    exclude_reply_user_ids?: Array<UserId>;
    in_reply_to_tweet_id: TweetId;
  };
  /**
   * Settings to indicate who can reply to the Tweet.
   */
  reply_settings?: 'following' | 'mentionedUsers';
  text?: TweetText;
};

/**
 * Settings to indicate who can reply to the Tweet.
 */
export type reply_settings = 'following' | 'mentionedUsers';

export type TweetCreateResponse = {
  data?: {
    id: TweetId;
    text: TweetText;
  };
  errors?: Array<Problem>;
};

export type TweetDeleteComplianceSchema = {
  delete: TweetComplianceSchema;
};

export type TweetDeleteResponse = {
  data?: {
    deleted: boolean;
  };
  errors?: Array<Problem>;
};

export type TweetDropComplianceSchema = {
  drop: TweetComplianceSchema;
};

export type TweetEditComplianceObjectSchema = {
  edit_tweet_ids: Array<TweetId>;
  /**
   * Event time.
   */
  event_at: string;
  initial_tweet_id: TweetId;
  tweet: {
    id: TweetId;
  };
};

export type TweetEditComplianceSchema = {
  tweet_edit: TweetEditComplianceObjectSchema;
};

export type TweetHideRequest = {
  hidden: boolean;
};

export type TweetHideResponse = {
  data?: {
    hidden?: boolean;
  };
};

/**
 * Unique identifier of this Tweet. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.
 */
export type TweetId = string;

/**
 * Tweet label data.
 */
export type TweetLabelData = TweetNoticeSchema | TweetUnviewableSchema;

/**
 * Tweet label stream events.
 */
export type TweetLabelStreamResponse =
  | {
      data: TweetLabelData;
    }
  | {
      errors: Array<Problem>;
    };

export type TweetNotice = {
  /**
   * If the label is being applied or removed. Possible values are ‘apply’ or ‘remove’.
   */
  application: string;
  /**
   * Information shown on the Tweet label
   */
  details?: string;
  /**
   * Event time.
   */
  event_at: string;
  /**
   * The type of label on the Tweet
   */
  event_type: string;
  /**
   * Link to more information about this kind of label
   */
  extended_details_url?: string;
  /**
   * Title/header of the Tweet label
   */
  label_title?: string;
  tweet: {
    author_id: UserId;
    id: TweetId;
  };
};

export type TweetNoticeSchema = {
  public_tweet_notice: TweetNotice;
};

export type TweetTakedownComplianceSchema = {
  /**
   * Event time.
   */
  event_at: string;
  quote_tweet_id?: TweetId;
  tweet: {
    author_id: UserId;
    id: TweetId;
  };
  withheld_in_countries: Array<CountryCode>;
};

/**
 * The content of the Tweet.
 */
export type TweetText = string;

export type TweetUndropComplianceSchema = {
  undrop: TweetComplianceSchema;
};

export type TweetUnviewable = {
  /**
   * If the label is being applied or removed. Possible values are ‘apply’ or ‘remove’.
   */
  application: string;
  /**
   * Event time.
   */
  event_at: string;
  tweet: {
    author_id: UserId;
    id: TweetId;
  };
};

export type TweetUnviewableSchema = {
  public_tweet_unviewable: TweetUnviewable;
};

/**
 * Indicates withholding details for [withheld content](https://help.twitter.com/en/rules-and-policies/tweet-withheld-by-country).
 */
export type TweetWithheld = {
  /**
   * Indicates if the content is being withheld for on the basis of copyright infringement.
   */
  copyright: boolean;
  /**
   * Provides a list of countries where this content is not available.
   */
  country_codes: Array<CountryCode>;
  /**
   * Indicates whether the content being withheld is the `tweet` or a `user`.
   */
  scope?: 'tweet' | 'user';
};

/**
 * Indicates whether the content being withheld is the `tweet` or a `user`.
 */
export type scope = 'tweet' | 'user';

export type TweetWithheldComplianceSchema = {
  withheld: TweetTakedownComplianceSchema;
};

/**
 * A problem that indicates that the authentication used is not supported.
 */
export type UnsupportedAuthenticationProblem = Problem;

/**
 * Expiration time of the upload URL.
 */
export type UploadExpiration = string;

/**
 * URL to which the user will upload their Tweet or user IDs.
 */
export type UploadUrl = string;

/**
 * A validly formatted URL.
 */
export type Url = string;

/**
 * Represent the portion of text recognized as a URL, and its start and end position within the text.
 */
export type UrlEntity = EntityIndicesInclusiveExclusive & UrlFields;

/**
 * Represent the portion of text recognized as a URL.
 */
export type UrlFields = {
  /**
   * Description of the URL landing page.
   */
  description?: string;
  /**
   * The URL as displayed in the Twitter client.
   */
  display_url?: string;
  expanded_url?: Url;
  images?: Array<UrlImage>;
  media_key?: MediaKey;
  status?: HttpStatusCode;
  /**
   * Title of the page the URL points to.
   */
  title?: string;
  /**
   * Fully resolved url.
   */
  unwound_url?: string;
  url: Url;
};

/**
 * Represent the information for the URL image.
 */
export type UrlImage = {
  height?: MediaHeight;
  url?: Url;
  width?: MediaWidth;
};

/**
 * A problem that indicates that a usage cap has been exceeded.
 */
export type UsageCapExceededProblem = Problem & {
  period?: 'Daily' | 'Monthly';
  scope?: 'Account' | 'Product';
};

export type period = 'Daily' | 'Monthly';

export type scope2 = 'Account' | 'Product';

/**
 * The Twitter User object.
 */
export type User = {
  /**
   * Creation time of this User.
   */
  created_at?: string;
  /**
   * The text of this User's profile description (also known as bio), if the User provided one.
   */
  description?: string;
  /**
   * A list of metadata found in the User's profile description.
   */
  entities?: {
    description?: FullTextEntities;
    /**
     * Expanded details for the URL specified in the User's profile, with start and end indices.
     */
    url?: {
      urls?: Array<UrlEntity>;
    };
  };
  id: UserId;
  /**
   * The location specified in the User's profile, if the User provided one. As this is a freeform value, it may not indicate a valid location, but it may be fuzzily evaluated when performing searches with location queries.
   */
  location?: string;
  /**
   * The friendly name of this User, as shown on their profile.
   */
  name: string;
  pinned_tweet_id?: TweetId;
  /**
   * The URL to the profile image for this User.
   */
  profile_image_url?: string;
  /**
   * Indicates if this User has chosen to protect their Tweets (in other words, if this User's Tweets are private).
   */
  protected?: boolean;
  /**
   * A list of metrics for this User.
   */
  public_metrics?: {
    /**
     * Number of Users who are following this User.
     */
    followers_count: number;
    /**
     * Number of Users this User is following.
     */
    following_count: number;
    /**
     * The number of lists that include this User.
     */
    listed_count: number;
    /**
     * The number of Tweets (including Retweets) posted by this User.
     */
    tweet_count: number;
  };
  /**
   * The URL specified in the User's profile.
   */
  url?: string;
  username: UserName;
  /**
   * Indicate if this User is a verified Twitter User.
   */
  verified?: boolean;
  /**
   * The Twitter Blue verified type of the user, eg: blue, government, business or none.
   */
  verified_type?: string;
  withheld?: UserWithheld;
};

/**
 * User compliance data.
 */
export type UserComplianceData =
  | UserProtectComplianceSchema
  | UserUnprotectComplianceSchema
  | UserDeleteComplianceSchema
  | UserUndeleteComplianceSchema
  | UserSuspendComplianceSchema
  | UserUnsuspendComplianceSchema
  | UserWithheldComplianceSchema
  | UserScrubGeoSchema
  | UserProfileModificationComplianceSchema;

export type UserComplianceSchema = {
  /**
   * Event time.
   */
  event_at: string;
  user: {
    id: UserId;
  };
};

/**
 * User compliance stream events.
 */
export type UserComplianceStreamResponse =
  | {
      data: UserComplianceData;
    }
  | {
      errors: Array<Problem>;
    };

export type UserDeleteComplianceSchema = {
  user_delete: UserComplianceSchema;
};

/**
 * Unique identifier of this User. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.
 */
export type UserId = string;

/**
 * Unique identifier of this User. The value must be the same as the authenticated user.
 */
export type UserIdMatchesAuthenticatedUser = string;

/**
 * The Twitter handle (screen name) of this user.
 */
export type UserName = string;

export type UserProfileModificationComplianceSchema = {
  user_profile_modification: UserProfileModificationObjectSchema;
};

export type UserProfileModificationObjectSchema = {
  /**
   * Event time.
   */
  event_at: string;
  new_value: string;
  profile_field: string;
  user: {
    id: UserId;
  };
};

export type UserProtectComplianceSchema = {
  user_protect: UserComplianceSchema;
};

export type UserScrubGeoObjectSchema = {
  /**
   * Event time.
   */
  event_at: string;
  up_to_tweet_id: TweetId;
  user: {
    id: UserId;
  };
};

export type UserScrubGeoSchema = {
  scrub_geo: UserScrubGeoObjectSchema;
};

export type UserSuspendComplianceSchema = {
  user_suspend: UserComplianceSchema;
};

export type UserTakedownComplianceSchema = {
  /**
   * Event time.
   */
  event_at: string;
  user: {
    id: UserId;
  };
  withheld_in_countries: Array<CountryCode>;
};

export type UserUndeleteComplianceSchema = {
  user_undelete: UserComplianceSchema;
};

export type UserUnprotectComplianceSchema = {
  user_unprotect: UserComplianceSchema;
};

export type UserUnsuspendComplianceSchema = {
  user_unsuspend: UserComplianceSchema;
};

/**
 * Indicates withholding details for [withheld content](https://help.twitter.com/en/rules-and-policies/tweet-withheld-by-country).
 */
export type UserWithheld = {
  /**
   * Provides a list of countries where this content is not available.
   */
  country_codes: Array<CountryCode>;
  /**
   * Indicates that the content being withheld is a `user`.
   */
  scope?: 'user';
};

/**
 * Indicates that the content being withheld is a `user`.
 */
export type scope3 = 'user';

export type UserWithheldComplianceSchema = {
  user_withheld: UserTakedownComplianceSchema;
};

export type UsersFollowingCreateRequest = {
  target_user_id: UserId;
};

export type UsersFollowingCreateResponse = {
  data?: {
    following?: boolean;
    pending_follow?: boolean;
  };
  errors?: Array<Problem>;
};

export type UsersFollowingDeleteResponse = {
  data?: {
    following?: boolean;
  };
  errors?: Array<Problem>;
};

export type UsersLikesCreateRequest = {
  tweet_id: TweetId;
};

export type UsersLikesCreateResponse = {
  data?: {
    liked?: boolean;
  };
  errors?: Array<Problem>;
};

export type UsersLikesDeleteResponse = {
  data?: {
    liked?: boolean;
  };
  errors?: Array<Problem>;
};

export type UsersRetweetsCreateRequest = {
  tweet_id: TweetId;
};

export type UsersRetweetsCreateResponse = {
  data?: {
    retweeted?: boolean;
  };
  errors?: Array<Problem>;
};

export type UsersRetweetsDeleteResponse = {
  data?: {
    retweeted?: boolean;
  };
  errors?: Array<Problem>;
};

export type Variant = {
  /**
   * The bit rate of the media.
   */
  bit_rate?: number;
  /**
   * The content type of the media.
   */
  content_type?: string;
  /**
   * The url to the media.
   */
  url?: string;
};

/**
 * An array of all available variants of the media.
 */
export type Variants = Array<Variant>;

export type Video = Media & {
  duration_ms?: number;
  /**
   * Nonpublic engagement metrics for the Media at the time of the request.
   */
  non_public_metrics?: {
    /**
     * Number of users who made it through 0% of the video.
     */
    playback_0_count?: number;
    /**
     * Number of users who made it through 100% of the video.
     */
    playback_100_count?: number;
    /**
     * Number of users who made it through 25% of the video.
     */
    playback_25_count?: number;
    /**
     * Number of users who made it through 50% of the video.
     */
    playback_50_count?: number;
    /**
     * Number of users who made it through 75% of the video.
     */
    playback_75_count?: number;
  };
  /**
   * Organic nonpublic engagement metrics for the Media at the time of the request.
   */
  organic_metrics?: {
    /**
     * Number of users who made it through 0% of the video.
     */
    playback_0_count?: number;
    /**
     * Number of users who made it through 100% of the video.
     */
    playback_100_count?: number;
    /**
     * Number of users who made it through 25% of the video.
     */
    playback_25_count?: number;
    /**
     * Number of users who made it through 50% of the video.
     */
    playback_50_count?: number;
    /**
     * Number of users who made it through 75% of the video.
     */
    playback_75_count?: number;
    /**
     * Number of times this video has been viewed.
     */
    view_count?: number;
  };
  preview_image_url?: string;
  /**
   * Promoted nonpublic engagement metrics for the Media at the time of the request.
   */
  promoted_metrics?: {
    /**
     * Number of users who made it through 0% of the video.
     */
    playback_0_count?: number;
    /**
     * Number of users who made it through 100% of the video.
     */
    playback_100_count?: number;
    /**
     * Number of users who made it through 25% of the video.
     */
    playback_25_count?: number;
    /**
     * Number of users who made it through 50% of the video.
     */
    playback_50_count?: number;
    /**
     * Number of users who made it through 75% of the video.
     */
    playback_75_count?: number;
    /**
     * Number of times this video has been viewed.
     */
    view_count?: number;
  };
  /**
   * Engagement metrics for the Media at the time of the request.
   */
  public_metrics?: {
    /**
     * Number of times this video has been viewed.
     */
    view_count?: number;
  };
  variants?: Variants;
};

/**
 * A comma separated list of ComplianceJob fields to display.
 */
export type ParameterComplianceJobFieldsParameter = Array<
  | 'created_at'
  | 'download_expires_at'
  | 'download_url'
  | 'id'
  | 'name'
  | 'resumable'
  | 'status'
  | 'type'
  | 'upload_expires_at'
  | 'upload_url'
>;

/**
 * A comma separated list of DmConversation fields to display.
 */
export type ParameterDmConversationFieldsParameter = Array<'id'>;

/**
 * A comma separated list of fields to expand.
 */
export type ParameterDmEventExpansionsParameter = Array<
  'attachments.media_keys' | 'participant_ids' | 'referenced_tweets.id' | 'sender_id'
>;

/**
 * A comma separated list of DmEvent fields to display.
 */
export type ParameterDmEventFieldsParameter = Array<
  | 'attachments'
  | 'created_at'
  | 'dm_conversation_id'
  | 'event_type'
  | 'id'
  | 'participant_ids'
  | 'referenced_tweets'
  | 'sender_id'
  | 'text'
>;

/**
 * A comma separated list of fields to expand.
 */
export type ParameterListExpansionsParameter = Array<'owner_id'>;

/**
 * A comma separated list of List fields to display.
 */
export type ParameterListFieldsParameter = Array<
  'created_at' | 'description' | 'follower_count' | 'id' | 'member_count' | 'name' | 'owner_id' | 'private'
>;

/**
 * A comma separated list of Media fields to display.
 */
export type ParameterMediaFieldsParameter = Array<
  | 'alt_text'
  | 'duration_ms'
  | 'height'
  | 'media_key'
  | 'non_public_metrics'
  | 'organic_metrics'
  | 'preview_image_url'
  | 'promoted_metrics'
  | 'public_metrics'
  | 'type'
  | 'url'
  | 'variants'
  | 'width'
>;

/**
 * A comma separated list of Place fields to display.
 */
export type ParameterPlaceFieldsParameter = Array<
  'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
>;

/**
 * A comma separated list of Poll fields to display.
 */
export type ParameterPollFieldsParameter = Array<
  'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'
>;

/**
 * A comma separated list of SearchCount fields to display.
 */
export type ParameterSearchCountFieldsParameter = Array<'end' | 'start' | 'tweet_count'>;

/**
 * A comma separated list of fields to expand.
 */
export type ParameterSpaceExpansionsParameter = Array<
  'creator_id' | 'host_ids' | 'invited_user_ids' | 'speaker_ids' | 'topic_ids'
>;

/**
 * A comma separated list of Space fields to display.
 */
export type ParameterSpaceFieldsParameter = Array<
  | 'created_at'
  | 'creator_id'
  | 'ended_at'
  | 'host_ids'
  | 'id'
  | 'invited_user_ids'
  | 'is_ticketed'
  | 'lang'
  | 'participant_count'
  | 'scheduled_start'
  | 'speaker_ids'
  | 'started_at'
  | 'state'
  | 'subscriber_count'
  | 'title'
  | 'topic_ids'
  | 'updated_at'
>;

/**
 * A comma separated list of Topic fields to display.
 */
export type ParameterTopicFieldsParameter = Array<'description' | 'id' | 'name'>;

/**
 * A comma separated list of fields to expand.
 */
export type ParameterTweetExpansionsParameter = Array<
  | 'attachments.media_keys'
  | 'attachments.poll_ids'
  | 'author_id'
  | 'edit_history_tweet_ids'
  | 'entities.mentions.username'
  | 'geo.place_id'
  | 'in_reply_to_user_id'
  | 'referenced_tweets.id'
  | 'referenced_tweets.id.author_id'
>;

/**
 * A comma separated list of Tweet fields to display.
 */
export type ParameterTweetFieldsParameter = Array<
  | 'attachments'
  | 'author_id'
  | 'context_annotations'
  | 'conversation_id'
  | 'created_at'
  | 'edit_controls'
  | 'edit_history_tweet_ids'
  | 'entities'
  | 'geo'
  | 'id'
  | 'in_reply_to_user_id'
  | 'lang'
  | 'non_public_metrics'
  | 'organic_metrics'
  | 'possibly_sensitive'
  | 'promoted_metrics'
  | 'public_metrics'
  | 'referenced_tweets'
  | 'reply_settings'
  | 'source'
  | 'text'
  | 'withheld'
>;

/**
 * A comma separated list of fields to expand.
 */
export type ParameterUserExpansionsParameter = Array<'pinned_tweet_id'>;

/**
 * A comma separated list of User fields to display.
 */
export type ParameterUserFieldsParameter = Array<
  | 'created_at'
  | 'description'
  | 'entities'
  | 'id'
  | 'location'
  | 'name'
  | 'pinned_tweet_id'
  | 'profile_image_url'
  | 'protected'
  | 'public_metrics'
  | 'url'
  | 'username'
  | 'verified'
  | 'verified_type'
  | 'withheld'
>;

export type ListBatchComplianceJobsData = {
  query: {
    /**
     * A comma separated list of ComplianceJob fields to display.
     */
    'compliance_job.fields'?: Array<
      | 'created_at'
      | 'download_expires_at'
      | 'download_url'
      | 'id'
      | 'name'
      | 'resumable'
      | 'status'
      | 'type'
      | 'upload_expires_at'
      | 'upload_url'
    >;
    /**
     * Status of Compliance Job to list.
     */
    status?: 'created' | 'in_progress' | 'failed' | 'complete';
    /**
     * Type of Compliance Job to list.
     */
    type: 'tweets' | 'users';
  };
};

export type ListBatchComplianceJobsResponse = Get2ComplianceJobsResponse;

export type ListBatchComplianceJobsError = Error;

export type CreateBatchComplianceJobData = {
  body: CreateComplianceJobRequest;
};

export type CreateBatchComplianceJobResponse = CreateComplianceJobResponse;

export type CreateBatchComplianceJobError = Error;

export type GetBatchComplianceJobData = {
  path: {
    /**
     * The ID of the Compliance Job to retrieve.
     */
    id: JobId;
  };
  query?: {
    /**
     * A comma separated list of ComplianceJob fields to display.
     */
    'compliance_job.fields'?: Array<
      | 'created_at'
      | 'download_expires_at'
      | 'download_url'
      | 'id'
      | 'name'
      | 'resumable'
      | 'status'
      | 'type'
      | 'upload_expires_at'
      | 'upload_url'
    >;
  };
};

export type GetBatchComplianceJobResponse = Get2ComplianceJobsIdResponse;

export type GetBatchComplianceJobError = Error;

export type DmConversationIdCreateData = {
  body?: CreateDmConversationRequest;
};

export type DmConversationIdCreateResponse = CreateDmEventResponse;

export type DmConversationIdCreateError = Error;

export type GetDmConversationsWithParticipantIdDmEventsData = {
  path: {
    /**
     * The ID of the participant user for the One to One DM conversation.
     */
    participant_id: UserId;
  };
  query?: {
    /**
     * A comma separated list of DmEvent fields to display.
     */
    'dm_event.fields'?: Array<
      | 'attachments'
      | 'created_at'
      | 'dm_conversation_id'
      | 'event_type'
      | 'id'
      | 'participant_ids'
      | 'referenced_tweets'
      | 'sender_id'
      | 'text'
    >;
    /**
     * The set of event_types to include in the results.
     */
    event_types?: Array<'MessageCreate' | 'ParticipantsJoin' | 'ParticipantsLeave'>;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'attachments.media_keys' | 'participant_ids' | 'referenced_tweets.id' | 'sender_id'>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationToken32;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type GetDmConversationsWithParticipantIdDmEventsResponse = Get2DmConversationsWithParticipantIdDmEventsResponse;

export type GetDmConversationsWithParticipantIdDmEventsError = Error;

export type DmConversationWithUserEventIdCreateData = {
  body?: CreateMessageRequest;
  path: {
    /**
     * The ID of the recipient user that will receive the DM.
     */
    participant_id: UserId;
  };
};

export type DmConversationWithUserEventIdCreateResponse = CreateDmEventResponse;

export type DmConversationWithUserEventIdCreateError = Error;

export type DmConversationByIdEventIdCreateData = {
  body?: CreateMessageRequest;
  path: {
    /**
     * The DM Conversation ID.
     */
    dm_conversation_id: string;
  };
};

export type DmConversationByIdEventIdCreateResponse = CreateDmEventResponse;

export type DmConversationByIdEventIdCreateError = Error;

export type GetDmConversationsIdDmEventsData = {
  path: {
    /**
     * The DM Conversation ID.
     */
    id: DmConversationId;
  };
  query?: {
    /**
     * A comma separated list of DmEvent fields to display.
     */
    'dm_event.fields'?: Array<
      | 'attachments'
      | 'created_at'
      | 'dm_conversation_id'
      | 'event_type'
      | 'id'
      | 'participant_ids'
      | 'referenced_tweets'
      | 'sender_id'
      | 'text'
    >;
    /**
     * The set of event_types to include in the results.
     */
    event_types?: Array<'MessageCreate' | 'ParticipantsJoin' | 'ParticipantsLeave'>;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'attachments.media_keys' | 'participant_ids' | 'referenced_tweets.id' | 'sender_id'>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationToken32;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type GetDmConversationsIdDmEventsResponse = Get2DmConversationsIdDmEventsResponse;

export type GetDmConversationsIdDmEventsError = Error;

export type GetDmEventsData = {
  query?: {
    /**
     * A comma separated list of DmEvent fields to display.
     */
    'dm_event.fields'?: Array<
      | 'attachments'
      | 'created_at'
      | 'dm_conversation_id'
      | 'event_type'
      | 'id'
      | 'participant_ids'
      | 'referenced_tweets'
      | 'sender_id'
      | 'text'
    >;
    /**
     * The set of event_types to include in the results.
     */
    event_types?: Array<'MessageCreate' | 'ParticipantsJoin' | 'ParticipantsLeave'>;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'attachments.media_keys' | 'participant_ids' | 'referenced_tweets.id' | 'sender_id'>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationToken32;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type GetDmEventsResponse = Get2DmEventsResponse;

export type GetDmEventsError = Error;

export type ListIdCreateData = {
  body?: ListCreateRequest;
};

export type ListIdCreateResponse = ListCreateResponse;

export type ListIdCreateError = Error;

export type ListIdDeleteData = {
  path: {
    /**
     * The ID of the List to delete.
     */
    id: ListId;
  };
};

export type ListIdDeleteResponse = ListDeleteResponse;

export type ListIdDeleteError = Error;

export type ListIdGetData = {
  path: {
    /**
     * The ID of the List.
     */
    id: ListId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'owner_id'>;
    /**
     * A comma separated list of List fields to display.
     */
    'list.fields'?: Array<
      'created_at' | 'description' | 'follower_count' | 'id' | 'member_count' | 'name' | 'owner_id' | 'private'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type ListIdGetResponse = Get2ListsIdResponse;

export type ListIdGetError = Error;

export type ListIdUpdateData = {
  body?: ListUpdateRequest;
  path: {
    /**
     * The ID of the List to modify.
     */
    id: ListId;
  };
};

export type ListIdUpdateResponse = ListUpdateResponse;

export type ListIdUpdateError = Error;

export type ListGetFollowersData = {
  path: {
    /**
     * The ID of the List.
     */
    id: ListId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationTokenLong;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type ListGetFollowersResponse = Get2ListsIdFollowersResponse;

export type ListGetFollowersError = Error;

export type ListGetMembersData = {
  path: {
    /**
     * The ID of the List.
     */
    id: ListId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationTokenLong;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type ListGetMembersResponse = Get2ListsIdMembersResponse;

export type ListGetMembersError = Error;

export type ListAddMemberData = {
  body?: ListAddUserRequest;
  path: {
    /**
     * The ID of the List for which to add a member.
     */
    id: ListId;
  };
};

export type ListAddMemberResponse = ListMutateResponse;

export type ListAddMemberError = Error;

export type ListRemoveMemberData = {
  path: {
    /**
     * The ID of the List to remove a member.
     */
    id: ListId;
    /**
     * The ID of User that will be removed from the List.
     */
    user_id: UserId;
  };
};

export type ListRemoveMemberResponse = ListMutateResponse;

export type ListRemoveMemberError = Error;

export type ListsIdTweetsData = {
  path: {
    /**
     * The ID of the List.
     */
    id: ListId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * This parameter is used to get the next 'page' of results.
     */
    pagination_token?: PaginationToken36;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type ListsIdTweetsResponse = Get2ListsIdTweetsResponse;

export type ListsIdTweetsError = Error;

export type GetOpenApiSpecResponse = {
  [key: string]: unknown;
};

export type GetOpenApiSpecError = unknown;

export type FindSpacesByIdsData = {
  query: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'creator_id' | 'host_ids' | 'invited_user_ids' | 'speaker_ids' | 'topic_ids'>;
    /**
     * The list of Space IDs to return.
     */
    ids: Array<string>;
    /**
     * A comma separated list of Space fields to display.
     */
    'space.fields'?: Array<
      | 'created_at'
      | 'creator_id'
      | 'ended_at'
      | 'host_ids'
      | 'id'
      | 'invited_user_ids'
      | 'is_ticketed'
      | 'lang'
      | 'participant_count'
      | 'scheduled_start'
      | 'speaker_ids'
      | 'started_at'
      | 'state'
      | 'subscriber_count'
      | 'title'
      | 'topic_ids'
      | 'updated_at'
    >;
    /**
     * A comma separated list of Topic fields to display.
     */
    'topic.fields'?: Array<'description' | 'id' | 'name'>;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type FindSpacesByIdsResponse = Get2SpacesResponse;

export type FindSpacesByIdsError = Error;

export type FindSpacesByCreatorIdsData = {
  query: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'creator_id' | 'host_ids' | 'invited_user_ids' | 'speaker_ids' | 'topic_ids'>;
    /**
     * A comma separated list of Space fields to display.
     */
    'space.fields'?: Array<
      | 'created_at'
      | 'creator_id'
      | 'ended_at'
      | 'host_ids'
      | 'id'
      | 'invited_user_ids'
      | 'is_ticketed'
      | 'lang'
      | 'participant_count'
      | 'scheduled_start'
      | 'speaker_ids'
      | 'started_at'
      | 'state'
      | 'subscriber_count'
      | 'title'
      | 'topic_ids'
      | 'updated_at'
    >;
    /**
     * A comma separated list of Topic fields to display.
     */
    'topic.fields'?: Array<'description' | 'id' | 'name'>;
    /**
     * The IDs of Users to search through.
     */
    user_ids: Array<UserId>;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type FindSpacesByCreatorIdsResponse = Get2SpacesByCreatorIdsResponse;

export type FindSpacesByCreatorIdsError = Error;

export type SearchSpacesData = {
  query: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'creator_id' | 'host_ids' | 'invited_user_ids' | 'speaker_ids' | 'topic_ids'>;
    /**
     * The number of results to return.
     */
    max_results?: number;
    /**
     * The search query.
     */
    query: string;
    /**
     * A comma separated list of Space fields to display.
     */
    'space.fields'?: Array<
      | 'created_at'
      | 'creator_id'
      | 'ended_at'
      | 'host_ids'
      | 'id'
      | 'invited_user_ids'
      | 'is_ticketed'
      | 'lang'
      | 'participant_count'
      | 'scheduled_start'
      | 'speaker_ids'
      | 'started_at'
      | 'state'
      | 'subscriber_count'
      | 'title'
      | 'topic_ids'
      | 'updated_at'
    >;
    /**
     * The state of Spaces to search for.
     */
    state?: 'live' | 'scheduled' | 'all';
    /**
     * A comma separated list of Topic fields to display.
     */
    'topic.fields'?: Array<'description' | 'id' | 'name'>;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type SearchSpacesResponse = Get2SpacesSearchResponse;

export type SearchSpacesError = Error;

export type FindSpaceByIdData = {
  path: {
    /**
     * The ID of the Space to be retrieved.
     */
    id: string;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'creator_id' | 'host_ids' | 'invited_user_ids' | 'speaker_ids' | 'topic_ids'>;
    /**
     * A comma separated list of Space fields to display.
     */
    'space.fields'?: Array<
      | 'created_at'
      | 'creator_id'
      | 'ended_at'
      | 'host_ids'
      | 'id'
      | 'invited_user_ids'
      | 'is_ticketed'
      | 'lang'
      | 'participant_count'
      | 'scheduled_start'
      | 'speaker_ids'
      | 'started_at'
      | 'state'
      | 'subscriber_count'
      | 'title'
      | 'topic_ids'
      | 'updated_at'
    >;
    /**
     * A comma separated list of Topic fields to display.
     */
    'topic.fields'?: Array<'description' | 'id' | 'name'>;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type FindSpaceByIdResponse = Get2SpacesIdResponse;

export type FindSpaceByIdError = Error;

export type SpaceBuyersData = {
  path: {
    /**
     * The ID of the Space to be retrieved.
     */
    id: string;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationToken32;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type SpaceBuyersResponse = Get2SpacesIdBuyersResponse;

export type SpaceBuyersError = Error;

export type SpaceTweetsData = {
  path: {
    /**
     * The ID of the Space to be retrieved.
     */
    id: string;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * The number of Tweets to fetch from the provided space. If not provided, the value will default to the maximum of 100.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type SpaceTweetsResponse = Get2SpacesIdTweetsResponse;

export type SpaceTweetsError = Error;

export type FindTweetsByIdData = {
  query: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * A comma separated list of Tweet IDs. Up to 100 are allowed in a single request.
     */
    ids: Array<TweetId>;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type FindTweetsByIdResponse = Get2TweetsResponse;

export type FindTweetsByIdError = Error;

export type CreateTweetData = {
  body: TweetCreateRequest;
};

export type CreateTweetResponse = TweetCreateResponse;

export type CreateTweetError = Error;

export type GetTweetsComplianceStreamData = {
  query: {
    /**
     * The number of minutes of backfill requested.
     */
    backfill_minutes?: number;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweet Compliance events will be provided.
     */
    end_time?: string;
    /**
     * The partition number.
     */
    partition: number;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweet Compliance events will be provided.
     */
    start_time?: string;
  };
};

export type GetTweetsComplianceStreamResponse = TweetComplianceStreamResponse;

export type GetTweetsComplianceStreamError = Error;

export type TweetCountsFullArchiveSearchData = {
  query: {
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute).
     */
    end_time?: string;
    /**
     * The granularity for the search counts results.
     */
    granularity?: 'minute' | 'hour' | 'day';
    /**
     * This parameter is used to get the next 'page' of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified.
     */
    next_token?: PaginationToken36;
    /**
     * This parameter is used to get the next 'page' of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified.
     */
    pagination_token?: PaginationToken36;
    /**
     * One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length.
     */
    query: string;
    /**
     * A comma separated list of SearchCount fields to display.
     */
    'search_count.fields'?: Array<'end' | 'start' | 'tweet_count'>;
    /**
     * Returns results with a Tweet ID greater than (that is, more recent than) the specified ID.
     */
    since_id?: TweetId;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute).
     */
    start_time?: string;
    /**
     * Returns results with a Tweet ID less than (that is, older than) the specified ID.
     */
    until_id?: TweetId;
  };
};

export type TweetCountsFullArchiveSearchResponse = Get2TweetsCountsAllResponse;

export type TweetCountsFullArchiveSearchError = Error;

export type TweetCountsRecentSearchData = {
  query: {
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute).
     */
    end_time?: string;
    /**
     * The granularity for the search counts results.
     */
    granularity?: 'minute' | 'hour' | 'day';
    /**
     * This parameter is used to get the next 'page' of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified.
     */
    next_token?: PaginationToken36;
    /**
     * This parameter is used to get the next 'page' of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified.
     */
    pagination_token?: PaginationToken36;
    /**
     * One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length.
     */
    query: string;
    /**
     * A comma separated list of SearchCount fields to display.
     */
    'search_count.fields'?: Array<'end' | 'start' | 'tweet_count'>;
    /**
     * Returns results with a Tweet ID greater than (that is, more recent than) the specified ID.
     */
    since_id?: TweetId;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute).
     */
    start_time?: string;
    /**
     * Returns results with a Tweet ID less than (that is, older than) the specified ID.
     */
    until_id?: TweetId;
  };
};

export type TweetCountsRecentSearchResponse = Get2TweetsCountsRecentResponse;

export type TweetCountsRecentSearchError = Error;

export type GetTweetsFirehoseStreamData = {
  query: {
    /**
     * The number of minutes of backfill requested.
     */
    backfill_minutes?: number;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided.
     */
    end_time?: string;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * The partition number.
     */
    partition: number;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp to which the Tweets will be provided.
     */
    start_time?: string;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type GetTweetsFirehoseStreamResponse = StreamingTweetResponse;

export type GetTweetsFirehoseStreamError = Error;

export type GetTweetsLabelStreamData = {
  query?: {
    /**
     * The number of minutes of backfill requested.
     */
    backfill_minutes?: number;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp from which the Tweet labels will be provided.
     */
    end_time?: string;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweet labels will be provided.
     */
    start_time?: string;
  };
};

export type GetTweetsLabelStreamResponse = TweetLabelStreamResponse;

export type GetTweetsLabelStreamError = Error;

export type SampleStreamData = {
  query?: {
    /**
     * The number of minutes of backfill requested.
     */
    backfill_minutes?: number;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type SampleStreamResponse = StreamingTweetResponse;

export type SampleStreamError = Error;

export type GetTweetsSample10StreamData = {
  query: {
    /**
     * The number of minutes of backfill requested.
     */
    backfill_minutes?: number;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided.
     */
    end_time?: string;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * The partition number.
     */
    partition: number;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp to which the Tweets will be provided.
     */
    start_time?: string;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type GetTweetsSample10StreamResponse = Get2TweetsSample10StreamResponse;

export type GetTweetsSample10StreamError = Error;

export type TweetsFullarchiveSearchData = {
  query: {
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute).
     */
    end_time?: string;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * The maximum number of search results to be returned by a request.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * This parameter is used to get the next 'page' of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified.
     */
    next_token?: PaginationToken36;
    /**
     * This parameter is used to get the next 'page' of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified.
     */
    pagination_token?: PaginationToken36;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length.
     */
    query: string;
    /**
     * Returns results with a Tweet ID greater than (that is, more recent than) the specified ID.
     */
    since_id?: TweetId;
    /**
     * This order in which to return results.
     */
    sort_order?: 'recency' | 'relevancy';
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute).
     */
    start_time?: string;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * Returns results with a Tweet ID less than (that is, older than) the specified ID.
     */
    until_id?: TweetId;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type TweetsFullarchiveSearchResponse = Get2TweetsSearchAllResponse;

export type TweetsFullarchiveSearchError = Error;

export type TweetsRecentSearchData = {
  query: {
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute).
     */
    end_time?: string;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * The maximum number of search results to be returned by a request.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * This parameter is used to get the next 'page' of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified.
     */
    next_token?: PaginationToken36;
    /**
     * This parameter is used to get the next 'page' of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified.
     */
    pagination_token?: PaginationToken36;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length.
     */
    query: string;
    /**
     * Returns results with a Tweet ID greater than (that is, more recent than) the specified ID.
     */
    since_id?: TweetId;
    /**
     * This order in which to return results.
     */
    sort_order?: 'recency' | 'relevancy';
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute).
     */
    start_time?: string;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * Returns results with a Tweet ID less than (that is, older than) the specified ID.
     */
    until_id?: TweetId;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type TweetsRecentSearchResponse = Get2TweetsSearchRecentResponse;

export type TweetsRecentSearchError = Error;

export type SearchStreamData = {
  query?: {
    /**
     * The number of minutes of backfill requested.
     */
    backfill_minutes?: number;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided.
     */
    end_time?: string;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided.
     */
    start_time?: string;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type SearchStreamResponse = FilteredStreamingTweetResponse;

export type SearchStreamError = Error;

export type GetRulesData = {
  query?: {
    /**
     * A comma-separated list of Rule IDs.
     */
    ids?: Array<RuleId>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This value is populated by passing the 'next_token' returned in a request to paginate through results.
     */
    pagination_token?: string;
  };
};

export type GetRulesResponse = RulesLookupResponse;

export type GetRulesError = Error;

export type AddOrDeleteRulesData = {
  body: AddOrDeleteRulesRequest;
  query?: {
    /**
     * Dry Run can be used with both the add and delete action, with the expected result given, but without actually taking any action in the system (meaning the end state will always be as it was when the request was submitted). This is particularly useful to validate rule changes.
     */
    dry_run?: boolean;
  };
};

export type AddOrDeleteRulesResponse2 = AddOrDeleteRulesResponse;

export type AddOrDeleteRulesError = Error;

export type DeleteTweetByIdData = {
  path: {
    /**
     * The ID of the Tweet to be deleted.
     */
    id: TweetId;
  };
};

export type DeleteTweetByIdResponse = TweetDeleteResponse;

export type DeleteTweetByIdError = Error;

export type FindTweetByIdData = {
  path: {
    /**
     * A single Tweet ID.
     */
    id: TweetId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type FindTweetByIdResponse = Get2TweetsIdResponse;

export type FindTweetByIdError = Error;

export type TweetsIdLikingUsersData = {
  path: {
    /**
     * A single Tweet ID.
     */
    id: TweetId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This parameter is used to get the next 'page' of results.
     */
    pagination_token?: PaginationToken36;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type TweetsIdLikingUsersResponse = Get2TweetsIdLikingUsersResponse;

export type TweetsIdLikingUsersError = Error;

export type FindTweetsThatQuoteAtweetData = {
  path: {
    /**
     * A single Tweet ID.
     */
    id: TweetId;
  };
  query?: {
    /**
     * The set of entities to exclude (e.g. 'replies' or 'retweets').
     */
    exclude?: Array<'replies' | 'retweets'>;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * The maximum number of results to be returned.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationToken36;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type FindTweetsThatQuoteAtweetResponse = Get2TweetsIdQuoteTweetsResponse;

export type FindTweetsThatQuoteAtweetError = Error;

export type TweetsIdRetweetingUsersData = {
  path: {
    /**
     * A single Tweet ID.
     */
    id: TweetId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This parameter is used to get the next 'page' of results.
     */
    pagination_token?: PaginationToken36;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type TweetsIdRetweetingUsersResponse = Get2TweetsIdRetweetedByResponse;

export type TweetsIdRetweetingUsersError = Error;

export type HideReplyByIdData = {
  body?: TweetHideRequest;
  path: {
    /**
     * The ID of the reply that you want to hide or unhide.
     */
    tweet_id: TweetId;
  };
};

export type HideReplyByIdResponse = TweetHideResponse;

export type HideReplyByIdError = Error;

export type FindUsersByIdData = {
  query: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * A list of User IDs, comma-separated. You can specify up to 100 IDs.
     */
    ids: Array<UserId>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type FindUsersByIdResponse = Get2UsersResponse;

export type FindUsersByIdError = Error;

export type FindUsersByUsernameData = {
  query: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
    /**
     * A list of usernames, comma-separated.
     */
    usernames: Array<string>;
  };
};

export type FindUsersByUsernameResponse = Get2UsersByResponse;

export type FindUsersByUsernameError = Error;

export type FindUserByUsernameData = {
  path: {
    /**
     * A username.
     */
    username: string;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type FindUserByUsernameResponse = Get2UsersByUsernameUsernameResponse;

export type FindUserByUsernameError = Error;

export type GetUsersComplianceStreamData = {
  query: {
    /**
     * The number of minutes of backfill requested.
     */
    backfill_minutes?: number;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp from which the User Compliance events will be provided.
     */
    end_time?: string;
    /**
     * The partition number.
     */
    partition: number;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the User Compliance events will be provided.
     */
    start_time?: string;
  };
};

export type GetUsersComplianceStreamResponse = UserComplianceStreamResponse;

export type GetUsersComplianceStreamError = Error;

export type FindMyUserData = {
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type FindMyUserResponse = Get2UsersMeResponse;

export type FindMyUserError = Error;

export type FindUserByIdData = {
  path: {
    /**
     * The ID of the User to lookup.
     */
    id: UserId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type FindUserByIdResponse = Get2UsersIdResponse;

export type FindUserByIdError = Error;

export type UsersIdBlockingData = {
  path: {
    /**
     * The ID of the authenticated source User for whom to return results.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationToken32;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type UsersIdBlockingResponse = Get2UsersIdBlockingResponse;

export type UsersIdBlockingError = Error;

export type UsersIdBlockData = {
  body: BlockUserRequest;
  path: {
    /**
     * The ID of the authenticated source User that is requesting to block the target User.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
};

export type UsersIdBlockResponse = BlockUserMutationResponse;

export type UsersIdBlockError = Error;

export type GetUsersIdBookmarksData = {
  path: {
    /**
     * The ID of the authenticated source User for whom to return results.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * This parameter is used to get the next 'page' of results.
     */
    pagination_token?: PaginationToken36;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type GetUsersIdBookmarksResponse = Get2UsersIdBookmarksResponse;

export type GetUsersIdBookmarksError = Error;

export type PostUsersIdBookmarksData = {
  body: BookmarkAddRequest;
  path: {
    /**
     * The ID of the authenticated source User for whom to add bookmarks.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
};

export type PostUsersIdBookmarksResponse = BookmarkMutationResponse;

export type PostUsersIdBookmarksError = Error;

export type UsersIdBookmarksDeleteData = {
  path: {
    /**
     * The ID of the authenticated source User whose bookmark is to be removed.
     */
    id: UserIdMatchesAuthenticatedUser;
    /**
     * The ID of the Tweet that the source User is removing from bookmarks.
     */
    tweet_id: TweetId;
  };
};

export type UsersIdBookmarksDeleteResponse = BookmarkMutationResponse;

export type UsersIdBookmarksDeleteError = Error;

export type UserFollowedListsData = {
  path: {
    /**
     * The ID of the User to lookup.
     */
    id: UserId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'owner_id'>;
    /**
     * A comma separated list of List fields to display.
     */
    'list.fields'?: Array<
      'created_at' | 'description' | 'follower_count' | 'id' | 'member_count' | 'name' | 'owner_id' | 'private'
    >;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationTokenLong;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type UserFollowedListsResponse = Get2UsersIdFollowedListsResponse;

export type UserFollowedListsError = Error;

export type ListUserFollowData = {
  body?: ListFollowedRequest;
  path: {
    /**
     * The ID of the authenticated source User that will follow the List.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
};

export type ListUserFollowResponse = ListFollowedResponse;

export type ListUserFollowError = Error;

export type ListUserUnfollowData = {
  path: {
    /**
     * The ID of the authenticated source User that will unfollow the List.
     */
    id: UserIdMatchesAuthenticatedUser;
    /**
     * The ID of the List to unfollow.
     */
    list_id: ListId;
  };
};

export type ListUserUnfollowResponse = ListFollowedResponse;

export type ListUserUnfollowError = Error;

export type UsersIdFollowersData = {
  path: {
    /**
     * The ID of the User to lookup.
     */
    id: UserId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationToken32;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type UsersIdFollowersResponse = Get2UsersIdFollowersResponse;

export type UsersIdFollowersError = Error;

export type UsersIdFollowingData = {
  path: {
    /**
     * The ID of the User to lookup.
     */
    id: UserId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationToken32;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type UsersIdFollowingResponse = Get2UsersIdFollowingResponse;

export type UsersIdFollowingError = Error;

export type UsersIdFollowData = {
  body?: UsersFollowingCreateRequest;
  path: {
    /**
     * The ID of the authenticated source User that is requesting to follow the target User.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
};

export type UsersIdFollowResponse = UsersFollowingCreateResponse;

export type UsersIdFollowError = Error;

export type UsersIdLikedTweetsData = {
  path: {
    /**
     * The ID of the User to lookup.
     */
    id: UserId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * This parameter is used to get the next 'page' of results.
     */
    pagination_token?: PaginationToken36;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type UsersIdLikedTweetsResponse = Get2UsersIdLikedTweetsResponse;

export type UsersIdLikedTweetsError = Error;

export type UsersIdLikeData = {
  body?: UsersLikesCreateRequest;
  path: {
    /**
     * The ID of the authenticated source User that is requesting to like the Tweet.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
};

export type UsersIdLikeResponse = UsersLikesCreateResponse;

export type UsersIdLikeError = Error;

export type UsersIdUnlikeData = {
  path: {
    /**
     * The ID of the authenticated source User that is requesting to unlike the Tweet.
     */
    id: UserIdMatchesAuthenticatedUser;
    /**
     * The ID of the Tweet that the User is requesting to unlike.
     */
    tweet_id: TweetId;
  };
};

export type UsersIdUnlikeResponse = UsersLikesDeleteResponse;

export type UsersIdUnlikeError = Error;

export type GetUserListMembershipsData = {
  path: {
    /**
     * The ID of the User to lookup.
     */
    id: UserId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'owner_id'>;
    /**
     * A comma separated list of List fields to display.
     */
    'list.fields'?: Array<
      'created_at' | 'description' | 'follower_count' | 'id' | 'member_count' | 'name' | 'owner_id' | 'private'
    >;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationTokenLong;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type GetUserListMembershipsResponse = Get2UsersIdListMembershipsResponse;

export type GetUserListMembershipsError = Error;

export type UsersIdMentionsData = {
  path: {
    /**
     * The ID of the User to lookup.
     */
    id: UserId;
  };
  query?: {
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified.
     */
    end_time?: string;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * This parameter is used to get the next 'page' of results.
     */
    pagination_token?: PaginationToken36;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified.
     */
    since_id?: TweetId;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified.
     */
    start_time?: string;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified.
     */
    until_id?: TweetId;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type UsersIdMentionsResponse = Get2UsersIdMentionsResponse;

export type UsersIdMentionsError = Error;

export type UsersIdMutingData = {
  path: {
    /**
     * The ID of the authenticated source User for whom to return results.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'pinned_tweet_id'>;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This parameter is used to get the next 'page' of results.
     */
    pagination_token?: PaginationTokenLong;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type UsersIdMutingResponse = Get2UsersIdMutingResponse;

export type UsersIdMutingError = Error;

export type UsersIdMuteData = {
  body?: MuteUserRequest;
  path: {
    /**
     * The ID of the authenticated source User that is requesting to mute the target User.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
};

export type UsersIdMuteResponse = MuteUserMutationResponse;

export type UsersIdMuteError = Error;

export type ListUserOwnedListsData = {
  path: {
    /**
     * The ID of the User to lookup.
     */
    id: UserId;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'owner_id'>;
    /**
     * A comma separated list of List fields to display.
     */
    'list.fields'?: Array<
      'created_at' | 'description' | 'follower_count' | 'id' | 'member_count' | 'name' | 'owner_id' | 'private'
    >;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * This parameter is used to get a specified 'page' of results.
     */
    pagination_token?: PaginationTokenLong;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type ListUserOwnedListsResponse = Get2UsersIdOwnedListsResponse;

export type ListUserOwnedListsError = Error;

export type ListUserPinnedListsData = {
  path: {
    /**
     * The ID of the authenticated source User for whom to return results.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
  query?: {
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<'owner_id'>;
    /**
     * A comma separated list of List fields to display.
     */
    'list.fields'?: Array<
      'created_at' | 'description' | 'follower_count' | 'id' | 'member_count' | 'name' | 'owner_id' | 'private'
    >;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type ListUserPinnedListsResponse = Get2UsersIdPinnedListsResponse;

export type ListUserPinnedListsError = Error;

export type ListUserPinData = {
  body: ListPinnedRequest;
  path: {
    /**
     * The ID of the authenticated source User that will pin the List.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
};

export type ListUserPinResponse = ListPinnedResponse;

export type ListUserPinError = Error;

export type ListUserUnpinData = {
  path: {
    /**
     * The ID of the authenticated source User for whom to return results.
     */
    id: UserIdMatchesAuthenticatedUser;
    /**
     * The ID of the List to unpin.
     */
    list_id: ListId;
  };
};

export type ListUserUnpinResponse = ListUnpinResponse;

export type ListUserUnpinError = Error;

export type UsersIdRetweetsData = {
  body?: UsersRetweetsCreateRequest;
  path: {
    /**
     * The ID of the authenticated source User that is requesting to retweet the Tweet.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
};

export type UsersIdRetweetsResponse = UsersRetweetsCreateResponse;

export type UsersIdRetweetsError = Error;

export type UsersIdUnretweetsData = {
  path: {
    /**
     * The ID of the authenticated source User that is requesting to retweet the Tweet.
     */
    id: UserIdMatchesAuthenticatedUser;
    /**
     * The ID of the Tweet that the User is requesting to unretweet.
     */
    source_tweet_id: TweetId;
  };
};

export type UsersIdUnretweetsResponse = UsersRetweetsDeleteResponse;

export type UsersIdUnretweetsError = Error;

export type UsersIdTimelineData = {
  path: {
    /**
     * The ID of the authenticated source User to list Reverse Chronological Timeline Tweets of.
     */
    id: UserIdMatchesAuthenticatedUser;
  };
  query?: {
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified.
     */
    end_time?: string;
    /**
     * The set of entities to exclude (e.g. 'replies' or 'retweets').
     */
    exclude?: Array<'replies' | 'retweets'>;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * This parameter is used to get the next 'page' of results.
     */
    pagination_token?: PaginationToken36;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified.
     */
    since_id?: TweetId;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified.
     */
    start_time?: string;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified.
     */
    until_id?: TweetId;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type UsersIdTimelineResponse = Get2UsersIdTimelinesReverseChronologicalResponse;

export type UsersIdTimelineError = Error;

export type UsersIdTweetsData = {
  path: {
    /**
     * The ID of the User to lookup.
     */
    id: UserId;
  };
  query?: {
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified.
     */
    end_time?: string;
    /**
     * The set of entities to exclude (e.g. 'replies' or 'retweets').
     */
    exclude?: Array<'replies' | 'retweets'>;
    /**
     * A comma separated list of fields to expand.
     */
    expansions?: Array<
      | 'attachments.media_keys'
      | 'attachments.poll_ids'
      | 'author_id'
      | 'edit_history_tweet_ids'
      | 'entities.mentions.username'
      | 'geo.place_id'
      | 'in_reply_to_user_id'
      | 'referenced_tweets.id'
      | 'referenced_tweets.id.author_id'
    >;
    /**
     * The maximum number of results.
     */
    max_results?: number;
    /**
     * A comma separated list of Media fields to display.
     */
    'media.fields'?: Array<
      | 'alt_text'
      | 'duration_ms'
      | 'height'
      | 'media_key'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'preview_image_url'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'type'
      | 'url'
      | 'variants'
      | 'width'
    >;
    /**
     * This parameter is used to get the next 'page' of results.
     */
    pagination_token?: PaginationToken36;
    /**
     * A comma separated list of Place fields to display.
     */
    'place.fields'?: Array<
      'contained_within' | 'country' | 'country_code' | 'full_name' | 'geo' | 'id' | 'name' | 'place_type'
    >;
    /**
     * A comma separated list of Poll fields to display.
     */
    'poll.fields'?: Array<'duration_minutes' | 'end_datetime' | 'id' | 'options' | 'voting_status'>;
    /**
     * The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified.
     */
    since_id?: TweetId;
    /**
     * YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified.
     */
    start_time?: string;
    /**
     * A comma separated list of Tweet fields to display.
     */
    'tweet.fields'?: Array<
      | 'attachments'
      | 'author_id'
      | 'context_annotations'
      | 'conversation_id'
      | 'created_at'
      | 'edit_controls'
      | 'edit_history_tweet_ids'
      | 'entities'
      | 'geo'
      | 'id'
      | 'in_reply_to_user_id'
      | 'lang'
      | 'non_public_metrics'
      | 'organic_metrics'
      | 'possibly_sensitive'
      | 'promoted_metrics'
      | 'public_metrics'
      | 'referenced_tweets'
      | 'reply_settings'
      | 'source'
      | 'text'
      | 'withheld'
    >;
    /**
     * The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified.
     */
    until_id?: TweetId;
    /**
     * A comma separated list of User fields to display.
     */
    'user.fields'?: Array<
      | 'created_at'
      | 'description'
      | 'entities'
      | 'id'
      | 'location'
      | 'name'
      | 'pinned_tweet_id'
      | 'profile_image_url'
      | 'protected'
      | 'public_metrics'
      | 'url'
      | 'username'
      | 'verified'
      | 'verified_type'
      | 'withheld'
    >;
  };
};

export type UsersIdTweetsResponse = Get2UsersIdTweetsResponse;

export type UsersIdTweetsError = Error;

export type UsersIdUnblockData = {
  path: {
    /**
     * The ID of the authenticated source User that is requesting to unblock the target User.
     */
    source_user_id: UserIdMatchesAuthenticatedUser;
    /**
     * The ID of the User that the source User is requesting to unblock.
     */
    target_user_id: UserId;
  };
};

export type UsersIdUnblockResponse = BlockUserMutationResponse;

export type UsersIdUnblockError = Error;

export type UsersIdUnfollowData = {
  path: {
    /**
     * The ID of the authenticated source User that is requesting to unfollow the target User.
     */
    source_user_id: UserIdMatchesAuthenticatedUser;
    /**
     * The ID of the User that the source User is requesting to unfollow.
     */
    target_user_id: UserId;
  };
};

export type UsersIdUnfollowResponse = UsersFollowingDeleteResponse;

export type UsersIdUnfollowError = Error;

export type UsersIdUnmuteData = {
  path: {
    /**
     * The ID of the authenticated source User that is requesting to unmute the target User.
     */
    source_user_id: UserIdMatchesAuthenticatedUser;
    /**
     * The ID of the User that the source User is requesting to unmute.
     */
    target_user_id: UserId;
  };
};

export type UsersIdUnmuteResponse = MuteUserMutationResponse;

export type UsersIdUnmuteError = Error;
