// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  ListBatchComplianceJobsData,
  ListBatchComplianceJobsError,
  ListBatchComplianceJobsResponse,
  CreateBatchComplianceJobData,
  CreateBatchComplianceJobError,
  CreateBatchComplianceJobResponse,
  GetBatchComplianceJobData,
  GetBatchComplianceJobError,
  GetBatchComplianceJobResponse,
  DmConversationIdCreateData,
  DmConversationIdCreateError,
  DmConversationIdCreateResponse,
  GetDmConversationsWithParticipantIdDmEventsData,
  GetDmConversationsWithParticipantIdDmEventsError,
  GetDmConversationsWithParticipantIdDmEventsResponse,
  DmConversationWithUserEventIdCreateData,
  DmConversationWithUserEventIdCreateError,
  DmConversationWithUserEventIdCreateResponse,
  DmConversationByIdEventIdCreateData,
  DmConversationByIdEventIdCreateError,
  DmConversationByIdEventIdCreateResponse,
  GetDmConversationsIdDmEventsData,
  GetDmConversationsIdDmEventsError,
  GetDmConversationsIdDmEventsResponse,
  GetDmEventsData,
  GetDmEventsError,
  GetDmEventsResponse,
  ListIdCreateData,
  ListIdCreateError,
  ListIdCreateResponse,
  ListIdDeleteData,
  ListIdDeleteError,
  ListIdDeleteResponse,
  ListIdGetData,
  ListIdGetError,
  ListIdGetResponse,
  ListIdUpdateData,
  ListIdUpdateError,
  ListIdUpdateResponse,
  ListGetFollowersData,
  ListGetFollowersError,
  ListGetFollowersResponse,
  ListGetMembersData,
  ListGetMembersError,
  ListGetMembersResponse,
  ListAddMemberData,
  ListAddMemberError,
  ListAddMemberResponse,
  ListRemoveMemberData,
  ListRemoveMemberError,
  ListRemoveMemberResponse,
  ListsIdTweetsData,
  ListsIdTweetsError,
  ListsIdTweetsResponse,
  GetOpenApiSpecError,
  GetOpenApiSpecResponse,
  FindSpacesByIdsData,
  FindSpacesByIdsError,
  FindSpacesByIdsResponse,
  FindSpacesByCreatorIdsData,
  FindSpacesByCreatorIdsError,
  FindSpacesByCreatorIdsResponse,
  SearchSpacesData,
  SearchSpacesError,
  SearchSpacesResponse,
  FindSpaceByIdData,
  FindSpaceByIdError,
  FindSpaceByIdResponse,
  SpaceBuyersData,
  SpaceBuyersError,
  SpaceBuyersResponse,
  SpaceTweetsData,
  SpaceTweetsError,
  SpaceTweetsResponse,
  FindTweetsByIdData,
  FindTweetsByIdError,
  FindTweetsByIdResponse,
  CreateTweetData,
  CreateTweetError,
  CreateTweetResponse,
  GetTweetsComplianceStreamData,
  GetTweetsComplianceStreamError,
  GetTweetsComplianceStreamResponse,
  TweetCountsFullArchiveSearchData,
  TweetCountsFullArchiveSearchError,
  TweetCountsFullArchiveSearchResponse,
  TweetCountsRecentSearchData,
  TweetCountsRecentSearchError,
  TweetCountsRecentSearchResponse,
  GetTweetsFirehoseStreamData,
  GetTweetsFirehoseStreamError,
  GetTweetsFirehoseStreamResponse,
  GetTweetsLabelStreamData,
  GetTweetsLabelStreamError,
  GetTweetsLabelStreamResponse,
  SampleStreamData,
  SampleStreamError,
  SampleStreamResponse,
  GetTweetsSample10StreamData,
  GetTweetsSample10StreamError,
  GetTweetsSample10StreamResponse,
  TweetsFullarchiveSearchData,
  TweetsFullarchiveSearchError,
  TweetsFullarchiveSearchResponse,
  TweetsRecentSearchData,
  TweetsRecentSearchError,
  TweetsRecentSearchResponse,
  SearchStreamData,
  SearchStreamError,
  SearchStreamResponse,
  GetRulesData,
  GetRulesError,
  GetRulesResponse,
  AddOrDeleteRulesData,
  AddOrDeleteRulesError,
  AddOrDeleteRulesResponse2,
  DeleteTweetByIdData,
  DeleteTweetByIdError,
  DeleteTweetByIdResponse,
  FindTweetByIdData,
  FindTweetByIdError,
  FindTweetByIdResponse,
  TweetsIdLikingUsersData,
  TweetsIdLikingUsersError,
  TweetsIdLikingUsersResponse,
  FindTweetsThatQuoteAtweetData,
  FindTweetsThatQuoteAtweetError,
  FindTweetsThatQuoteAtweetResponse,
  TweetsIdRetweetingUsersData,
  TweetsIdRetweetingUsersError,
  TweetsIdRetweetingUsersResponse,
  HideReplyByIdData,
  HideReplyByIdError,
  HideReplyByIdResponse,
  FindUsersByIdData,
  FindUsersByIdError,
  FindUsersByIdResponse,
  FindUsersByUsernameData,
  FindUsersByUsernameError,
  FindUsersByUsernameResponse,
  FindUserByUsernameData,
  FindUserByUsernameError,
  FindUserByUsernameResponse,
  GetUsersComplianceStreamData,
  GetUsersComplianceStreamError,
  GetUsersComplianceStreamResponse,
  FindMyUserData,
  FindMyUserError,
  FindMyUserResponse,
  FindUserByIdData,
  FindUserByIdError,
  FindUserByIdResponse,
  UsersIdBlockingData,
  UsersIdBlockingError,
  UsersIdBlockingResponse,
  UsersIdBlockData,
  UsersIdBlockError,
  UsersIdBlockResponse,
  GetUsersIdBookmarksData,
  GetUsersIdBookmarksError,
  GetUsersIdBookmarksResponse,
  PostUsersIdBookmarksData,
  PostUsersIdBookmarksError,
  PostUsersIdBookmarksResponse,
  UsersIdBookmarksDeleteData,
  UsersIdBookmarksDeleteError,
  UsersIdBookmarksDeleteResponse,
  UserFollowedListsData,
  UserFollowedListsError,
  UserFollowedListsResponse,
  ListUserFollowData,
  ListUserFollowError,
  ListUserFollowResponse,
  ListUserUnfollowData,
  ListUserUnfollowError,
  ListUserUnfollowResponse,
  UsersIdFollowersData,
  UsersIdFollowersError,
  UsersIdFollowersResponse,
  UsersIdFollowingData,
  UsersIdFollowingError,
  UsersIdFollowingResponse,
  UsersIdFollowData,
  UsersIdFollowError,
  UsersIdFollowResponse,
  UsersIdLikedTweetsData,
  UsersIdLikedTweetsError,
  UsersIdLikedTweetsResponse,
  UsersIdLikeData,
  UsersIdLikeError,
  UsersIdLikeResponse,
  UsersIdUnlikeData,
  UsersIdUnlikeError,
  UsersIdUnlikeResponse,
  GetUserListMembershipsData,
  GetUserListMembershipsError,
  GetUserListMembershipsResponse,
  UsersIdMentionsData,
  UsersIdMentionsError,
  UsersIdMentionsResponse,
  UsersIdMutingData,
  UsersIdMutingError,
  UsersIdMutingResponse,
  UsersIdMuteData,
  UsersIdMuteError,
  UsersIdMuteResponse,
  ListUserOwnedListsData,
  ListUserOwnedListsError,
  ListUserOwnedListsResponse,
  ListUserPinnedListsData,
  ListUserPinnedListsError,
  ListUserPinnedListsResponse,
  ListUserPinData,
  ListUserPinError,
  ListUserPinResponse,
  ListUserUnpinData,
  ListUserUnpinError,
  ListUserUnpinResponse,
  UsersIdRetweetsData,
  UsersIdRetweetsError,
  UsersIdRetweetsResponse,
  UsersIdUnretweetsData,
  UsersIdUnretweetsError,
  UsersIdUnretweetsResponse,
  UsersIdTimelineData,
  UsersIdTimelineError,
  UsersIdTimelineResponse,
  UsersIdTweetsData,
  UsersIdTweetsError,
  UsersIdTweetsResponse,
  UsersIdUnblockData,
  UsersIdUnblockError,
  UsersIdUnblockResponse,
  UsersIdUnfollowData,
  UsersIdUnfollowError,
  UsersIdUnfollowResponse,
  UsersIdUnmuteData,
  UsersIdUnmuteError,
  UsersIdUnmuteResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * List Compliance Jobs
 * Returns recent Compliance Jobs for a given job type and optional job status
 */
export const listBatchComplianceJobs = <ThrowOnError extends boolean = false>(
  options: Options<ListBatchComplianceJobsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListBatchComplianceJobsResponse, ListBatchComplianceJobsError, ThrowOnError>({
    ...options,
    url: '/2/compliance/jobs',
  });
};

/**
 * Create compliance job
 * Creates a compliance for the given job type
 */
export const createBatchComplianceJob = <ThrowOnError extends boolean = false>(
  options: Options<CreateBatchComplianceJobData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateBatchComplianceJobResponse,
    CreateBatchComplianceJobError,
    ThrowOnError
  >({
    ...options,
    url: '/2/compliance/jobs',
  });
};

/**
 * Get Compliance Job
 * Returns a single Compliance Job by ID
 */
export const getBatchComplianceJob = <ThrowOnError extends boolean = false>(
  options: Options<GetBatchComplianceJobData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBatchComplianceJobResponse, GetBatchComplianceJobError, ThrowOnError>({
    ...options,
    url: '/2/compliance/jobs/{id}',
  });
};

/**
 * Create a new DM Conversation
 * Creates a new DM Conversation.
 */
export const dmConversationIdCreate = <ThrowOnError extends boolean = false>(
  options?: Options<DmConversationIdCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DmConversationIdCreateResponse, DmConversationIdCreateError, ThrowOnError>({
    ...options,
    url: '/2/dm_conversations',
  });
};

/**
 * Get DM Events for a DM Conversation
 * Returns DM Events for a DM Conversation
 */
export const getDmConversationsWithParticipantIdDmEvents = <ThrowOnError extends boolean = false>(
  options: Options<GetDmConversationsWithParticipantIdDmEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetDmConversationsWithParticipantIdDmEventsResponse,
    GetDmConversationsWithParticipantIdDmEventsError,
    ThrowOnError
  >({
    ...options,
    url: '/2/dm_conversations/with/{participant_id}/dm_events',
  });
};

/**
 * Send a new message to a user
 * Creates a new message for a DM Conversation with a participant user by ID
 */
export const dmConversationWithUserEventIdCreate = <ThrowOnError extends boolean = false>(
  options: Options<DmConversationWithUserEventIdCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    DmConversationWithUserEventIdCreateResponse,
    DmConversationWithUserEventIdCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/2/dm_conversations/with/{participant_id}/messages',
  });
};

/**
 * Send a new message to a DM Conversation
 * Creates a new message for a DM Conversation specified by DM Conversation ID
 */
export const dmConversationByIdEventIdCreate = <ThrowOnError extends boolean = false>(
  options: Options<DmConversationByIdEventIdCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    DmConversationByIdEventIdCreateResponse,
    DmConversationByIdEventIdCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/2/dm_conversations/{dm_conversation_id}/messages',
  });
};

/**
 * Get DM Events for a DM Conversation
 * Returns DM Events for a DM Conversation
 */
export const getDmConversationsIdDmEvents = <ThrowOnError extends boolean = false>(
  options: Options<GetDmConversationsIdDmEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetDmConversationsIdDmEventsResponse,
    GetDmConversationsIdDmEventsError,
    ThrowOnError
  >({
    ...options,
    url: '/2/dm_conversations/{id}/dm_events',
  });
};

/**
 * Get recent DM Events
 * Returns recent DM Events across DM conversations
 */
export const getDmEvents = <ThrowOnError extends boolean = false>(options?: Options<GetDmEventsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetDmEventsResponse, GetDmEventsError, ThrowOnError>({
    ...options,
    url: '/2/dm_events',
  });
};

/**
 * Create List
 * Creates a new List.
 */
export const listIdCreate = <ThrowOnError extends boolean = false>(
  options?: Options<ListIdCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ListIdCreateResponse, ListIdCreateError, ThrowOnError>({
    ...options,
    url: '/2/lists',
  });
};

/**
 * Delete List
 * Delete a List that you own.
 */
export const listIdDelete = <ThrowOnError extends boolean = false>(
  options: Options<ListIdDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<ListIdDeleteResponse, ListIdDeleteError, ThrowOnError>({
    ...options,
    url: '/2/lists/{id}',
  });
};

/**
 * List lookup by List ID.
 * Returns a List.
 */
export const listIdGet = <ThrowOnError extends boolean = false>(options: Options<ListIdGetData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListIdGetResponse, ListIdGetError, ThrowOnError>({
    ...options,
    url: '/2/lists/{id}',
  });
};

/**
 * Update List.
 * Update a List that you own.
 */
export const listIdUpdate = <ThrowOnError extends boolean = false>(
  options: Options<ListIdUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<ListIdUpdateResponse, ListIdUpdateError, ThrowOnError>({
    ...options,
    url: '/2/lists/{id}',
  });
};

/**
 * Returns User objects that follow a List by the provided List ID
 * Returns a list of Users that follow a List by the provided List ID
 */
export const listGetFollowers = <ThrowOnError extends boolean = false>(
  options: Options<ListGetFollowersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGetFollowersResponse, ListGetFollowersError, ThrowOnError>({
    ...options,
    url: '/2/lists/{id}/followers',
  });
};

/**
 * Returns User objects that are members of a List by the provided List ID.
 * Returns a list of Users that are members of a List by the provided List ID.
 */
export const listGetMembers = <ThrowOnError extends boolean = false>(
  options: Options<ListGetMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGetMembersResponse, ListGetMembersError, ThrowOnError>({
    ...options,
    url: '/2/lists/{id}/members',
  });
};

/**
 * Add a List member
 * Causes a User to become a member of a List.
 */
export const listAddMember = <ThrowOnError extends boolean = false>(
  options: Options<ListAddMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ListAddMemberResponse, ListAddMemberError, ThrowOnError>({
    ...options,
    url: '/2/lists/{id}/members',
  });
};

/**
 * Remove a List member
 * Causes a User to be removed from the members of a List.
 */
export const listRemoveMember = <ThrowOnError extends boolean = false>(
  options: Options<ListRemoveMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<ListRemoveMemberResponse, ListRemoveMemberError, ThrowOnError>({
    ...options,
    url: '/2/lists/{id}/members/{user_id}',
  });
};

/**
 * List Tweets timeline by List ID.
 * Returns a list of Tweets associated with the provided List ID.
 */
export const listsIdTweets = <ThrowOnError extends boolean = false>(
  options: Options<ListsIdTweetsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListsIdTweetsResponse, ListsIdTweetsError, ThrowOnError>({
    ...options,
    url: '/2/lists/{id}/tweets',
  });
};

/**
 * Returns the OpenAPI Specification document.
 * Full OpenAPI Specification in JSON format. (See https://github.com/OAI/OpenAPI-Specification/blob/master/README.md)
 */
export const getOpenApiSpec = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetOpenApiSpecResponse, GetOpenApiSpecError, ThrowOnError>({
    ...options,
    url: '/2/openapi.json',
  });
};

/**
 * Space lookup up Space IDs
 * Returns a variety of information about the Spaces specified by the requested IDs
 */
export const findSpacesByIds = <ThrowOnError extends boolean = false>(
  options: Options<FindSpacesByIdsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FindSpacesByIdsResponse, FindSpacesByIdsError, ThrowOnError>({
    ...options,
    url: '/2/spaces',
  });
};

/**
 * Space lookup by their creators
 * Returns a variety of information about the Spaces created by the provided User IDs
 */
export const findSpacesByCreatorIds = <ThrowOnError extends boolean = false>(
  options: Options<FindSpacesByCreatorIdsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FindSpacesByCreatorIdsResponse, FindSpacesByCreatorIdsError, ThrowOnError>({
    ...options,
    url: '/2/spaces/by/creator_ids',
  });
};

/**
 * Search for Spaces
 * Returns Spaces that match the provided query.
 */
export const searchSpaces = <ThrowOnError extends boolean = false>(
  options: Options<SearchSpacesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SearchSpacesResponse, SearchSpacesError, ThrowOnError>({
    ...options,
    url: '/2/spaces/search',
  });
};

/**
 * Space lookup by Space ID
 * Returns a variety of information about the Space specified by the requested ID
 */
export const findSpaceById = <ThrowOnError extends boolean = false>(
  options: Options<FindSpaceByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FindSpaceByIdResponse, FindSpaceByIdError, ThrowOnError>({
    ...options,
    url: '/2/spaces/{id}',
  });
};

/**
 * Retrieve the list of Users who purchased a ticket to the given space
 * Retrieves the list of Users who purchased a ticket to the given space
 */
export const spaceBuyers = <ThrowOnError extends boolean = false>(options: Options<SpaceBuyersData, ThrowOnError>) => {
  return (options?.client ?? client).get<SpaceBuyersResponse, SpaceBuyersError, ThrowOnError>({
    ...options,
    url: '/2/spaces/{id}/buyers',
  });
};

/**
 * Retrieve Tweets from a Space.
 * Retrieves Tweets shared in the specified Space.
 */
export const spaceTweets = <ThrowOnError extends boolean = false>(options: Options<SpaceTweetsData, ThrowOnError>) => {
  return (options?.client ?? client).get<SpaceTweetsResponse, SpaceTweetsError, ThrowOnError>({
    ...options,
    url: '/2/spaces/{id}/tweets',
  });
};

/**
 * Tweet lookup by Tweet IDs
 * Returns a variety of information about the Tweet specified by the requested ID.
 */
export const findTweetsById = <ThrowOnError extends boolean = false>(
  options: Options<FindTweetsByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FindTweetsByIdResponse, FindTweetsByIdError, ThrowOnError>({
    ...options,
    url: '/2/tweets',
  });
};

/**
 * Creation of a Tweet
 * Causes the User to create a Tweet under the authorized account.
 */
export const createTweet = <ThrowOnError extends boolean = false>(options: Options<CreateTweetData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateTweetResponse, CreateTweetError, ThrowOnError>({
    ...options,
    url: '/2/tweets',
  });
};

/**
 * Tweets Compliance stream
 * Streams 100% of compliance data for Tweets
 */
export const getTweetsComplianceStream = <ThrowOnError extends boolean = false>(
  options: Options<GetTweetsComplianceStreamData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetTweetsComplianceStreamResponse,
    GetTweetsComplianceStreamError,
    ThrowOnError
  >({
    ...options,
    url: '/2/tweets/compliance/stream',
  });
};

/**
 * Full archive search counts
 * Returns Tweet Counts that match a search query.
 */
export const tweetCountsFullArchiveSearch = <ThrowOnError extends boolean = false>(
  options: Options<TweetCountsFullArchiveSearchData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    TweetCountsFullArchiveSearchResponse,
    TweetCountsFullArchiveSearchError,
    ThrowOnError
  >({
    ...options,
    url: '/2/tweets/counts/all',
  });
};

/**
 * Recent search counts
 * Returns Tweet Counts from the last 7 days that match a search query.
 */
export const tweetCountsRecentSearch = <ThrowOnError extends boolean = false>(
  options: Options<TweetCountsRecentSearchData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TweetCountsRecentSearchResponse, TweetCountsRecentSearchError, ThrowOnError>({
    ...options,
    url: '/2/tweets/counts/recent',
  });
};

/**
 * Firehose stream
 * Streams 100% of public Tweets.
 */
export const getTweetsFirehoseStream = <ThrowOnError extends boolean = false>(
  options: Options<GetTweetsFirehoseStreamData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTweetsFirehoseStreamResponse, GetTweetsFirehoseStreamError, ThrowOnError>({
    ...options,
    url: '/2/tweets/firehose/stream',
  });
};

/**
 * Tweets Label stream
 * Streams 100% of labeling events applied to Tweets
 */
export const getTweetsLabelStream = <ThrowOnError extends boolean = false>(
  options?: Options<GetTweetsLabelStreamData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTweetsLabelStreamResponse, GetTweetsLabelStreamError, ThrowOnError>({
    ...options,
    url: '/2/tweets/label/stream',
  });
};

/**
 * Sample stream
 * Streams a deterministic 1% of public Tweets.
 */
export const sampleStream = <ThrowOnError extends boolean = false>(
  options?: Options<SampleStreamData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SampleStreamResponse, SampleStreamError, ThrowOnError>({
    ...options,
    url: '/2/tweets/sample/stream',
  });
};

/**
 * Sample 10% stream
 * Streams a deterministic 10% of public Tweets.
 */
export const getTweetsSample10Stream = <ThrowOnError extends boolean = false>(
  options: Options<GetTweetsSample10StreamData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTweetsSample10StreamResponse, GetTweetsSample10StreamError, ThrowOnError>({
    ...options,
    url: '/2/tweets/sample10/stream',
  });
};

/**
 * Full-archive search
 * Returns Tweets that match a search query.
 */
export const tweetsFullarchiveSearch = <ThrowOnError extends boolean = false>(
  options: Options<TweetsFullarchiveSearchData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TweetsFullarchiveSearchResponse, TweetsFullarchiveSearchError, ThrowOnError>({
    ...options,
    url: '/2/tweets/search/all',
  });
};

/**
 * Recent search
 * Returns Tweets from the last 7 days that match a search query.
 */
export const tweetsRecentSearch = <ThrowOnError extends boolean = false>(
  options: Options<TweetsRecentSearchData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TweetsRecentSearchResponse, TweetsRecentSearchError, ThrowOnError>({
    ...options,
    url: '/2/tweets/search/recent',
  });
};

/**
 * Filtered stream
 * Streams Tweets matching the stream's active rule set.
 */
export const searchStream = <ThrowOnError extends boolean = false>(
  options?: Options<SearchStreamData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SearchStreamResponse, SearchStreamError, ThrowOnError>({
    ...options,
    url: '/2/tweets/search/stream',
  });
};

/**
 * Rules lookup
 * Returns rules from a User's active rule set. Users can fetch all of their rules or a subset, specified by the provided rule ids.
 */
export const getRules = <ThrowOnError extends boolean = false>(options?: Options<GetRulesData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetRulesResponse, GetRulesError, ThrowOnError>({
    ...options,
    url: '/2/tweets/search/stream/rules',
  });
};

/**
 * Add/Delete rules
 * Add or delete rules from a User's active rule set. Users can provide unique, optionally tagged rules to add. Users can delete their entire rule set or a subset specified by rule ids or values.
 */
export const addOrDeleteRules = <ThrowOnError extends boolean = false>(
  options: Options<AddOrDeleteRulesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddOrDeleteRulesResponse2, AddOrDeleteRulesError, ThrowOnError>({
    ...options,
    url: '/2/tweets/search/stream/rules',
  });
};

/**
 * Tweet delete by Tweet ID
 * Delete specified Tweet (in the path) by ID.
 */
export const deleteTweetById = <ThrowOnError extends boolean = false>(
  options: Options<DeleteTweetByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteTweetByIdResponse, DeleteTweetByIdError, ThrowOnError>({
    ...options,
    url: '/2/tweets/{id}',
  });
};

/**
 * Tweet lookup by Tweet ID
 * Returns a variety of information about the Tweet specified by the requested ID.
 */
export const findTweetById = <ThrowOnError extends boolean = false>(
  options: Options<FindTweetByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FindTweetByIdResponse, FindTweetByIdError, ThrowOnError>({
    ...options,
    url: '/2/tweets/{id}',
  });
};

/**
 * Returns User objects that have liked the provided Tweet ID
 * Returns a list of Users that have liked the provided Tweet ID
 */
export const tweetsIdLikingUsers = <ThrowOnError extends boolean = false>(
  options: Options<TweetsIdLikingUsersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TweetsIdLikingUsersResponse, TweetsIdLikingUsersError, ThrowOnError>({
    ...options,
    url: '/2/tweets/{id}/liking_users',
  });
};

/**
 * Retrieve Tweets that quote a Tweet.
 * Returns a variety of information about each Tweet that quotes the Tweet specified by the requested ID.
 */
export const findTweetsThatQuoteAtweet = <ThrowOnError extends boolean = false>(
  options: Options<FindTweetsThatQuoteAtweetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FindTweetsThatQuoteAtweetResponse,
    FindTweetsThatQuoteAtweetError,
    ThrowOnError
  >({
    ...options,
    url: '/2/tweets/{id}/quote_tweets',
  });
};

/**
 * Returns User objects that have retweeted the provided Tweet ID
 * Returns a list of Users that have retweeted the provided Tweet ID
 */
export const tweetsIdRetweetingUsers = <ThrowOnError extends boolean = false>(
  options: Options<TweetsIdRetweetingUsersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TweetsIdRetweetingUsersResponse, TweetsIdRetweetingUsersError, ThrowOnError>({
    ...options,
    url: '/2/tweets/{id}/retweeted_by',
  });
};

/**
 * Hide replies
 * Hides or unhides a reply to an owned conversation.
 */
export const hideReplyById = <ThrowOnError extends boolean = false>(
  options: Options<HideReplyByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<HideReplyByIdResponse, HideReplyByIdError, ThrowOnError>({
    ...options,
    url: '/2/tweets/{tweet_id}/hidden',
  });
};

/**
 * User lookup by IDs
 * This endpoint returns information about Users. Specify Users by their ID.
 */
export const findUsersById = <ThrowOnError extends boolean = false>(
  options: Options<FindUsersByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FindUsersByIdResponse, FindUsersByIdError, ThrowOnError>({
    ...options,
    url: '/2/users',
  });
};

/**
 * User lookup by usernames
 * This endpoint returns information about Users. Specify Users by their username.
 */
export const findUsersByUsername = <ThrowOnError extends boolean = false>(
  options: Options<FindUsersByUsernameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FindUsersByUsernameResponse, FindUsersByUsernameError, ThrowOnError>({
    ...options,
    url: '/2/users/by',
  });
};

/**
 * User lookup by username
 * This endpoint returns information about a User. Specify User by username.
 */
export const findUserByUsername = <ThrowOnError extends boolean = false>(
  options: Options<FindUserByUsernameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FindUserByUsernameResponse, FindUserByUsernameError, ThrowOnError>({
    ...options,
    url: '/2/users/by/username/{username}',
  });
};

/**
 * Users Compliance stream
 * Streams 100% of compliance data for Users
 */
export const getUsersComplianceStream = <ThrowOnError extends boolean = false>(
  options: Options<GetUsersComplianceStreamData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUsersComplianceStreamResponse, GetUsersComplianceStreamError, ThrowOnError>(
    {
      ...options,
      url: '/2/users/compliance/stream',
    },
  );
};

/**
 * User lookup me
 * This endpoint returns information about the requesting User.
 */
export const findMyUser = <ThrowOnError extends boolean = false>(options?: Options<FindMyUserData, ThrowOnError>) => {
  return (options?.client ?? client).get<FindMyUserResponse, FindMyUserError, ThrowOnError>({
    ...options,
    url: '/2/users/me',
  });
};

/**
 * User lookup by ID
 * This endpoint returns information about a User. Specify User by ID.
 */
export const findUserById = <ThrowOnError extends boolean = false>(
  options: Options<FindUserByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FindUserByIdResponse, FindUserByIdError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}',
  });
};

/**
 * Returns User objects that are blocked by provided User ID
 * Returns a list of Users that are blocked by the provided User ID
 */
export const usersIdBlocking = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdBlockingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UsersIdBlockingResponse, UsersIdBlockingError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/blocking',
  });
};

/**
 * Block User by User ID
 * Causes the User (in the path) to block the target User. The User (in the path) must match the User context authorizing the request
 */
export const usersIdBlock = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdBlockData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UsersIdBlockResponse, UsersIdBlockError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/blocking',
  });
};

/**
 * Bookmarks by User
 * Returns Tweet objects that have been bookmarked by the requesting User
 */
export const getUsersIdBookmarks = <ThrowOnError extends boolean = false>(
  options: Options<GetUsersIdBookmarksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUsersIdBookmarksResponse, GetUsersIdBookmarksError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/bookmarks',
  });
};

/**
 * Add Tweet to Bookmarks
 * Adds a Tweet (ID in the body) to the requesting User's (in the path) bookmarks
 */
export const postUsersIdBookmarks = <ThrowOnError extends boolean = false>(
  options: Options<PostUsersIdBookmarksData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostUsersIdBookmarksResponse, PostUsersIdBookmarksError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/bookmarks',
  });
};

/**
 * Remove a bookmarked Tweet
 * Removes a Tweet from the requesting User's bookmarked Tweets.
 */
export const usersIdBookmarksDelete = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdBookmarksDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UsersIdBookmarksDeleteResponse, UsersIdBookmarksDeleteError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/bookmarks/{tweet_id}',
  });
};

/**
 * Get User's Followed Lists
 * Returns a User's followed Lists.
 */
export const userFollowedLists = <ThrowOnError extends boolean = false>(
  options: Options<UserFollowedListsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UserFollowedListsResponse, UserFollowedListsError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/followed_lists',
  });
};

/**
 * Follow a List
 * Causes a User to follow a List.
 */
export const listUserFollow = <ThrowOnError extends boolean = false>(
  options: Options<ListUserFollowData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ListUserFollowResponse, ListUserFollowError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/followed_lists',
  });
};

/**
 * Unfollow a List
 * Causes a User to unfollow a List.
 */
export const listUserUnfollow = <ThrowOnError extends boolean = false>(
  options: Options<ListUserUnfollowData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<ListUserUnfollowResponse, ListUserUnfollowError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/followed_lists/{list_id}',
  });
};

/**
 * Followers by User ID
 * Returns a list of Users who are followers of the specified User ID.
 */
export const usersIdFollowers = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdFollowersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UsersIdFollowersResponse, UsersIdFollowersError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/followers',
  });
};

/**
 * Following by User ID
 * Returns a list of Users that are being followed by the provided User ID
 */
export const usersIdFollowing = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdFollowingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UsersIdFollowingResponse, UsersIdFollowingError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/following',
  });
};

/**
 * Follow User
 * Causes the User(in the path) to follow, or “request to follow” for protected Users, the target User. The User(in the path) must match the User context authorizing the request
 */
export const usersIdFollow = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdFollowData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UsersIdFollowResponse, UsersIdFollowError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/following',
  });
};

/**
 * Returns Tweet objects liked by the provided User ID
 * Returns a list of Tweets liked by the provided User ID
 */
export const usersIdLikedTweets = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdLikedTweetsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UsersIdLikedTweetsResponse, UsersIdLikedTweetsError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/liked_tweets',
  });
};

/**
 * Causes the User (in the path) to like the specified Tweet
 * Causes the User (in the path) to like the specified Tweet. The User in the path must match the User context authorizing the request.
 */
export const usersIdLike = <ThrowOnError extends boolean = false>(options: Options<UsersIdLikeData, ThrowOnError>) => {
  return (options?.client ?? client).post<UsersIdLikeResponse, UsersIdLikeError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/likes',
  });
};

/**
 * Causes the User (in the path) to unlike the specified Tweet
 * Causes the User (in the path) to unlike the specified Tweet. The User must match the User context authorizing the request
 */
export const usersIdUnlike = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdUnlikeData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UsersIdUnlikeResponse, UsersIdUnlikeError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/likes/{tweet_id}',
  });
};

/**
 * Get a User's List Memberships
 * Get a User's List Memberships.
 */
export const getUserListMemberships = <ThrowOnError extends boolean = false>(
  options: Options<GetUserListMembershipsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUserListMembershipsResponse, GetUserListMembershipsError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/list_memberships',
  });
};

/**
 * User mention timeline by User ID
 * Returns Tweet objects that mention username associated to the provided User ID
 */
export const usersIdMentions = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdMentionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UsersIdMentionsResponse, UsersIdMentionsError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/mentions',
  });
};

/**
 * Returns User objects that are muted by the provided User ID
 * Returns a list of Users that are muted by the provided User ID
 */
export const usersIdMuting = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdMutingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UsersIdMutingResponse, UsersIdMutingError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/muting',
  });
};

/**
 * Mute User by User ID.
 * Causes the User (in the path) to mute the target User. The User (in the path) must match the User context authorizing the request.
 */
export const usersIdMute = <ThrowOnError extends boolean = false>(options: Options<UsersIdMuteData, ThrowOnError>) => {
  return (options?.client ?? client).post<UsersIdMuteResponse, UsersIdMuteError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/muting',
  });
};

/**
 * Get a User's Owned Lists.
 * Get a User's Owned Lists.
 */
export const listUserOwnedLists = <ThrowOnError extends boolean = false>(
  options: Options<ListUserOwnedListsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUserOwnedListsResponse, ListUserOwnedListsError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/owned_lists',
  });
};

/**
 * Get a User's Pinned Lists
 * Get a User's Pinned Lists.
 */
export const listUserPinnedLists = <ThrowOnError extends boolean = false>(
  options: Options<ListUserPinnedListsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUserPinnedListsResponse, ListUserPinnedListsError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/pinned_lists',
  });
};

/**
 * Pin a List
 * Causes a User to pin a List.
 */
export const listUserPin = <ThrowOnError extends boolean = false>(options: Options<ListUserPinData, ThrowOnError>) => {
  return (options?.client ?? client).post<ListUserPinResponse, ListUserPinError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/pinned_lists',
  });
};

/**
 * Unpin a List
 * Causes a User to remove a pinned List.
 */
export const listUserUnpin = <ThrowOnError extends boolean = false>(
  options: Options<ListUserUnpinData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<ListUserUnpinResponse, ListUserUnpinError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/pinned_lists/{list_id}',
  });
};

/**
 * Causes the User (in the path) to retweet the specified Tweet.
 * Causes the User (in the path) to retweet the specified Tweet. The User in the path must match the User context authorizing the request.
 */
export const usersIdRetweets = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdRetweetsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UsersIdRetweetsResponse, UsersIdRetweetsError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/retweets',
  });
};

/**
 * Causes the User (in the path) to unretweet the specified Tweet
 * Causes the User (in the path) to unretweet the specified Tweet. The User must match the User context authorizing the request
 */
export const usersIdUnretweets = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdUnretweetsData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UsersIdUnretweetsResponse, UsersIdUnretweetsError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/retweets/{source_tweet_id}',
  });
};

/**
 * User home timeline by User ID
 * Returns Tweet objects that appears in the provided User ID's home timeline
 */
export const usersIdTimeline = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdTimelineData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UsersIdTimelineResponse, UsersIdTimelineError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/timelines/reverse_chronological',
  });
};

/**
 * User Tweets timeline by User ID
 * Returns a list of Tweets authored by the provided User ID
 */
export const usersIdTweets = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdTweetsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UsersIdTweetsResponse, UsersIdTweetsError, ThrowOnError>({
    ...options,
    url: '/2/users/{id}/tweets',
  });
};

/**
 * Unblock User by User ID
 * Causes the source User to unblock the target User. The source User must match the User context authorizing the request
 */
export const usersIdUnblock = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdUnblockData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UsersIdUnblockResponse, UsersIdUnblockError, ThrowOnError>({
    ...options,
    url: '/2/users/{source_user_id}/blocking/{target_user_id}',
  });
};

/**
 * Unfollow User
 * Causes the source User to unfollow the target User. The source User must match the User context authorizing the request
 */
export const usersIdUnfollow = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdUnfollowData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UsersIdUnfollowResponse, UsersIdUnfollowError, ThrowOnError>({
    ...options,
    url: '/2/users/{source_user_id}/following/{target_user_id}',
  });
};

/**
 * Unmute User by User ID
 * Causes the source User to unmute the target User. The source User must match the User context authorizing the request
 */
export const usersIdUnmute = <ThrowOnError extends boolean = false>(
  options: Options<UsersIdUnmuteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UsersIdUnmuteResponse, UsersIdUnmuteError, ThrowOnError>({
    ...options,
    url: '/2/users/{source_user_id}/muting/{target_user_id}',
  });
};
