// This file is auto-generated by @hey-api/openapi-ts

export const AddOrDeleteRulesRequestSchema = {
  oneOf: [
    {
      $ref: '#/components/schemas/AddRulesRequest',
    },
    {
      $ref: '#/components/schemas/DeleteRulesRequest',
    },
  ],
} as const;

export const AddOrDeleteRulesResponseSchema = {
  description: 'A response from modifying user-specified stream filtering rules.',
  properties: {
    data: {
      description: 'All user-specified stream filtering rules that were created.',
      items: {
        $ref: '#/components/schemas/Rule',
      },
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    meta: {
      $ref: '#/components/schemas/RulesResponseMetadata',
    },
  },
  required: ['meta'],
  type: 'object',
} as const;

export const AddRulesRequestSchema = {
  description: 'A request to add a user-specified stream filtering rule.',
  properties: {
    add: {
      items: {
        $ref: '#/components/schemas/RuleNoId',
      },
      type: 'array',
    },
  },
  required: ['add'],
  type: 'object',
} as const;

export const AggregateSchema = {
  description: 'The sum of results returned in this response.',
  format: 'int32',
  type: 'integer',
} as const;

export const AnimatedGifSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Media',
    },
    {
      properties: {
        preview_image_url: {
          format: 'uri',
          type: 'string',
        },
        variants: {
          $ref: '#/components/schemas/Variants',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const BlockUserMutationResponseSchema = {
  properties: {
    data: {
      properties: {
        blocking: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const BlockUserRequestSchema = {
  properties: {
    target_user_id: {
      $ref: '#/components/schemas/UserId',
    },
  },
  required: ['target_user_id'],
  type: 'object',
} as const;

export const BookmarkAddRequestSchema = {
  properties: {
    tweet_id: {
      $ref: '#/components/schemas/TweetId',
    },
  },
  required: ['tweet_id'],
  type: 'object',
} as const;

export const BookmarkMutationResponseSchema = {
  properties: {
    data: {
      properties: {
        bookmarked: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const CashtagEntitySchema = {
  allOf: [
    {
      $ref: '#/components/schemas/EntityIndicesInclusiveExclusive',
    },
    {
      $ref: '#/components/schemas/CashtagFields',
    },
  ],
} as const;

export const CashtagFieldsSchema = {
  description: 'Represent the portion of text recognized as a Cashtag, and its start and end position within the text.',
  properties: {
    tag: {
      example: 'TWTR',
      type: 'string',
    },
  },
  required: ['tag'],
  type: 'object',
} as const;

export const ClientDisconnectedProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
  ],
  description: 'Your client has gone away.',
} as const;

export const ClientForbiddenProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
    {
      properties: {
        reason: {
          enum: ['official-client-forbidden', 'client-not-enrolled'],
          type: 'string',
        },
        registration_url: {
          format: 'uri',
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
  description: 'A problem that indicates your client is forbidden from making this request.',
} as const;

export const ComplianceJobSchema = {
  properties: {
    created_at: {
      $ref: '#/components/schemas/CreatedAt',
    },
    download_expires_at: {
      $ref: '#/components/schemas/DownloadExpiration',
    },
    download_url: {
      $ref: '#/components/schemas/DownloadUrl',
    },
    id: {
      $ref: '#/components/schemas/JobId',
    },
    name: {
      $ref: '#/components/schemas/ComplianceJobName',
    },
    status: {
      $ref: '#/components/schemas/ComplianceJobStatus',
    },
    type: {
      $ref: '#/components/schemas/ComplianceJobType',
    },
    upload_expires_at: {
      $ref: '#/components/schemas/UploadExpiration',
    },
    upload_url: {
      $ref: '#/components/schemas/UploadUrl',
    },
  },
  required: [
    'id',
    'type',
    'created_at',
    'upload_url',
    'download_url',
    'upload_expires_at',
    'download_expires_at',
    'status',
  ],
  type: 'object',
} as const;

export const ComplianceJobNameSchema = {
  description: 'User-provided name for a compliance job.',
  example: 'my-job',
  maxLength: 64,
  type: 'string',
} as const;

export const ComplianceJobStatusSchema = {
  description: 'Status of a compliance job.',
  enum: ['created', 'in_progress', 'failed', 'complete', 'expired'],
  type: 'string',
} as const;

export const ComplianceJobTypeSchema = {
  description: 'Type of compliance job to list.',
  enum: ['tweets', 'users'],
  type: 'string',
} as const;

export const ConflictProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
  ],
  description: 'You cannot create a new job if one is already in progress.',
} as const;

export const ConnectionExceptionProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
    {
      properties: {
        connection_issue: {
          enum: ['TooManyConnections', 'ProvisioningSubscription', 'RuleConfigurationIssue', 'RulesInvalidIssue'],
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
  description: 'A problem that indicates something is wrong with the connection.',
} as const;

export const ContextAnnotationSchema = {
  description: 'Annotation inferred from the Tweet text.',
  properties: {
    domain: {
      $ref: '#/components/schemas/ContextAnnotationDomainFields',
    },
    entity: {
      $ref: '#/components/schemas/ContextAnnotationEntityFields',
    },
  },
  required: ['domain', 'entity'],
  type: 'object',
} as const;

export const ContextAnnotationDomainFieldsSchema = {
  description: 'Represents the data for the context annotation domain.',
  properties: {
    description: {
      description: 'Description of the context annotation domain.',
      type: 'string',
    },
    id: {
      description: 'The unique id for a context annotation domain.',
      pattern: '^[0-9]{1,19}$',
      type: 'string',
    },
    name: {
      description: 'Name of the context annotation domain.',
      type: 'string',
    },
  },
  required: ['id'],
  type: 'object',
} as const;

export const ContextAnnotationEntityFieldsSchema = {
  description: 'Represents the data for the context annotation entity.',
  properties: {
    description: {
      description: 'Description of the context annotation entity.',
      type: 'string',
    },
    id: {
      description: 'The unique id for a context annotation entity.',
      pattern: '^[0-9]{1,19}$',
      type: 'string',
    },
    name: {
      description: 'Name of the context annotation entity.',
      type: 'string',
    },
  },
  required: ['id'],
  type: 'object',
} as const;

export const CountryCodeSchema = {
  description: 'A two-letter ISO 3166-1 alpha-2 country code.',
  example: 'US',
  pattern: '^[A-Z]{2}$',
  type: 'string',
} as const;

export const CreateAttachmentsMessageRequestSchema = {
  properties: {
    attachments: {
      $ref: '#/components/schemas/DmAttachments',
    },
    text: {
      description: 'Text of the message.',
      minLength: 1,
      type: 'string',
    },
  },
  required: ['attachments'],
  type: 'object',
} as const;

export const CreateComplianceJobRequestSchema = {
  description: 'A request to create a new batch compliance job.',
  properties: {
    name: {
      $ref: '#/components/schemas/ComplianceJobName',
    },
    resumable: {
      description: 'If true, this endpoint will return a pre-signed URL with resumable uploads enabled.',
      type: 'boolean',
    },
    type: {
      description: 'Type of compliance job to list.',
      enum: ['tweets', 'users'],
      type: 'string',
    },
  },
  required: ['type'],
  type: 'object',
} as const;

export const CreateComplianceJobResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/ComplianceJob',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const CreateDmConversationRequestSchema = {
  additionalProperties: false,
  properties: {
    conversation_type: {
      description: 'The conversation type that is being created.',
      enum: ['Group'],
      type: 'string',
    },
    message: {
      $ref: '#/components/schemas/CreateMessageRequest',
    },
    participant_ids: {
      $ref: '#/components/schemas/DmParticipants',
    },
  },
  required: ['conversation_type', 'participant_ids', 'message'],
  type: 'object',
} as const;

export const CreateDmEventResponseSchema = {
  properties: {
    data: {
      properties: {
        dm_conversation_id: {
          $ref: '#/components/schemas/DmConversationId',
        },
        dm_event_id: {
          $ref: '#/components/schemas/DmEventId',
        },
      },
      required: ['dm_conversation_id', 'dm_event_id'],
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const CreateMessageRequestSchema = {
  anyOf: [
    {
      $ref: '#/components/schemas/CreateTextMessageRequest',
    },
    {
      $ref: '#/components/schemas/CreateAttachmentsMessageRequest',
    },
  ],
} as const;

export const CreateTextMessageRequestSchema = {
  properties: {
    attachments: {
      $ref: '#/components/schemas/DmAttachments',
    },
    text: {
      description: 'Text of the message.',
      minLength: 1,
      type: 'string',
    },
  },
  required: ['text'],
  type: 'object',
} as const;

export const CreatedAtSchema = {
  description: 'Creation time of the compliance job.',
  example: '2021-01-06T18:40:40.000Z',
  format: 'date-time',
  type: 'string',
} as const;

export const DeleteRulesRequestSchema = {
  description: 'A response from deleting user-specified stream filtering rules.',
  properties: {
    delete: {
      description: 'IDs and values of all deleted user-specified stream filtering rules.',
      properties: {
        ids: {
          description: 'IDs of all deleted user-specified stream filtering rules.',
          items: {
            $ref: '#/components/schemas/RuleId',
          },
          type: 'array',
        },
        values: {
          description: 'Values of all deleted user-specified stream filtering rules.',
          items: {
            $ref: '#/components/schemas/RuleValue',
          },
          type: 'array',
        },
      },
      type: 'object',
    },
  },
  required: ['delete'],
  type: 'object',
} as const;

export const DisallowedResourceProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
    {
      properties: {
        resource_id: {
          type: 'string',
        },
        resource_type: {
          enum: ['user', 'tweet', 'media', 'list', 'space'],
          type: 'string',
        },
        section: {
          enum: ['data', 'includes'],
          type: 'string',
        },
      },
      required: ['resource_id', 'resource_type', 'section'],
      type: 'object',
    },
  ],
  description: 'A problem that indicates that the resource requested violates the precepts of this API.',
} as const;

export const DmAttachmentsSchema = {
  description: 'Attachments to a DM Event.',
  items: {
    $ref: '#/components/schemas/DmMediaAttachment',
  },
  type: 'array',
} as const;

export const DmConversationIdSchema = {
  description:
    "Unique identifier of a DM conversation. This can either be a numeric string, or a pair of numeric strings separated by a '-' character in the case of one-on-one DM Conversations.",
  example: '123123123-456456456',
  pattern: '^([0-9]{1,19}-[0-9]{1,19}|[0-9]{15,19})$',
  type: 'string',
} as const;

export const DmEventSchema = {
  properties: {
    attachments: {
      description: 'Specifies the type of attachments (if any) present in this DM.',
      properties: {
        card_ids: {
          description: 'A list of card IDs (if cards are attached).',
          items: {
            type: 'string',
          },
          minItems: 1,
          type: 'array',
        },
        media_keys: {
          description: 'A list of Media Keys for each one of the media attachments (if media are attached).',
          items: {
            $ref: '#/components/schemas/MediaKey',
          },
          minItems: 1,
          type: 'array',
        },
      },
      type: 'object',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    dm_conversation_id: {
      $ref: '#/components/schemas/DmConversationId',
    },
    event_type: {
      example: 'MessageCreate',
      type: 'string',
    },
    id: {
      $ref: '#/components/schemas/DmEventId',
    },
    participant_ids: {
      description: 'A list of participants for a ParticipantsJoin or ParticipantsLeave event_type.',
      items: {
        $ref: '#/components/schemas/UserId',
      },
      minItems: 1,
      type: 'array',
    },
    referenced_tweets: {
      description: 'A list of Tweets this DM refers to.',
      items: {
        properties: {
          id: {
            $ref: '#/components/schemas/TweetId',
          },
        },
        required: ['id'],
        type: 'object',
      },
      minItems: 1,
      type: 'array',
    },
    sender_id: {
      $ref: '#/components/schemas/UserId',
    },
    text: {
      type: 'string',
    },
  },
  required: ['id', 'event_type'],
  type: 'object',
} as const;

export const DmEventIdSchema = {
  description: 'Unique identifier of a DM Event.',
  example: '1146654567674912769',
  pattern: '^[0-9]{1,19}$',
  type: 'string',
} as const;

export const DmMediaAttachmentSchema = {
  properties: {
    media_id: {
      $ref: '#/components/schemas/MediaId',
    },
  },
  required: ['media_id'],
  type: 'object',
} as const;

export const DmParticipantsSchema = {
  description: 'Participants for the DM Conversation.',
  items: {
    $ref: '#/components/schemas/UserId',
  },
  maxItems: 49,
  minItems: 2,
  type: 'array',
} as const;

export const DownloadExpirationSchema = {
  description: 'Expiration time of the download URL.',
  example: '2021-01-06T18:40:40.000Z',
  format: 'date-time',
  type: 'string',
} as const;

export const DownloadUrlSchema = {
  description: 'URL from which the user will retrieve their compliance results.',
  format: 'uri',
  type: 'string',
} as const;

export const DuplicateRuleProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
    {
      properties: {
        id: {
          type: 'string',
        },
        value: {
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
  description: 'The rule you have submitted is a duplicate.',
} as const;

export const EndSchema = {
  description: 'The end time of the bucket.',
  format: 'date-time',
  type: 'string',
} as const;

export const EntityIndicesInclusiveExclusiveSchema = {
  description:
    'Represent a boundary range (start and end index) for a recognized entity (for example a hashtag or a mention). `start` must be smaller than `end`.  The start index is inclusive, the end index is exclusive.',
  properties: {
    end: {
      description: 'Index (zero-based) at which position this entity ends.  The index is exclusive.',
      example: 61,
      minimum: 0,
      type: 'integer',
    },
    start: {
      description: 'Index (zero-based) at which position this entity starts.  The index is inclusive.',
      example: 50,
      minimum: 0,
      type: 'integer',
    },
  },
  required: ['start', 'end'],
  type: 'object',
} as const;

export const EntityIndicesInclusiveInclusiveSchema = {
  description:
    'Represent a boundary range (start and end index) for a recognized entity (for example a hashtag or a mention). `start` must be smaller than `end`.  The start index is inclusive, the end index is inclusive.',
  properties: {
    end: {
      description: 'Index (zero-based) at which position this entity ends.  The index is inclusive.',
      example: 61,
      minimum: 0,
      type: 'integer',
    },
    start: {
      description: 'Index (zero-based) at which position this entity starts.  The index is inclusive.',
      example: 50,
      minimum: 0,
      type: 'integer',
    },
  },
  required: ['start', 'end'],
  type: 'object',
} as const;

export const ErrorSchema = {
  properties: {
    code: {
      format: 'int32',
      type: 'integer',
    },
    message: {
      type: 'string',
    },
  },
  required: ['code', 'message'],
  type: 'object',
} as const;

export const ExpansionsSchema = {
  properties: {
    media: {
      items: {
        $ref: '#/components/schemas/Media',
      },
      minItems: 1,
      type: 'array',
    },
    places: {
      items: {
        $ref: '#/components/schemas/Place',
      },
      minItems: 1,
      type: 'array',
    },
    polls: {
      items: {
        $ref: '#/components/schemas/Poll',
      },
      minItems: 1,
      type: 'array',
    },
    topics: {
      items: {
        $ref: '#/components/schemas/Topic',
      },
      minItems: 1,
      type: 'array',
    },
    tweets: {
      items: {
        $ref: '#/components/schemas/Tweet',
      },
      minItems: 1,
      type: 'array',
    },
    users: {
      items: {
        $ref: '#/components/schemas/User',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const FieldUnauthorizedProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
    {
      properties: {
        field: {
          type: 'string',
        },
        resource_type: {
          enum: ['user', 'tweet', 'media', 'list', 'space'],
          type: 'string',
        },
        section: {
          enum: ['data', 'includes'],
          type: 'string',
        },
      },
      required: ['resource_type', 'field', 'section'],
      type: 'object',
    },
  ],
  description: 'A problem that indicates that you are not allowed to see a particular field on a Tweet, User, etc.',
} as const;

export const FilteredStreamingTweetResponseSchema = {
  description:
    'A Tweet or error that can be returned by the streaming Tweet API. The values returned with a successful streamed Tweet includes the user provided rules that the Tweet matched.',
  properties: {
    data: {
      $ref: '#/components/schemas/Tweet',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    matching_rules: {
      description: 'The list of rules which matched the Tweet',
      items: {
        properties: {
          id: {
            $ref: '#/components/schemas/RuleId',
          },
          tag: {
            $ref: '#/components/schemas/RuleTag',
          },
        },
        required: ['id'],
        type: 'object',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const FullTextEntitiesSchema = {
  properties: {
    annotations: {
      items: {
        allOf: [
          {
            $ref: '#/components/schemas/EntityIndicesInclusiveInclusive',
          },
          {
            description: 'Represents the data for the annotation.',
            properties: {
              normalized_text: {
                description: 'Text used to determine annotation.',
                example: 'Barack Obama',
                type: 'string',
              },
              probability: {
                description: 'Confidence factor for annotation type.',
                format: 'double',
                maximum: 1,
                minimum: 0,
                type: 'number',
              },
              type: {
                description: 'Annotation type.',
                example: 'Person',
                type: 'string',
              },
            },
            type: 'object',
          },
        ],
        description: 'Annotation for entities based on the Tweet text.',
      },
      minItems: 1,
      type: 'array',
    },
    cashtags: {
      items: {
        $ref: '#/components/schemas/CashtagEntity',
      },
      minItems: 1,
      type: 'array',
    },
    hashtags: {
      items: {
        $ref: '#/components/schemas/HashtagEntity',
      },
      minItems: 1,
      type: 'array',
    },
    mentions: {
      items: {
        $ref: '#/components/schemas/MentionEntity',
      },
      minItems: 1,
      type: 'array',
    },
    urls: {
      items: {
        $ref: '#/components/schemas/UrlEntity',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const GenericProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
  ],
  description: 'A generic problem with no additional information beyond that provided by the HTTP status code.',
} as const;

export const GeoSchema = {
  properties: {
    bbox: {
      example: [-105.193475, 39.60973, -105.053164, 39.761974],
      items: {
        format: 'double',
        maximum: 180,
        minimum: -180,
        type: 'number',
      },
      maxItems: 4,
      minItems: 4,
      type: 'array',
    },
    geometry: {
      $ref: '#/components/schemas/Point',
    },
    properties: {
      type: 'object',
    },
    type: {
      enum: ['Feature'],
      type: 'string',
    },
  },
  required: ['type', 'bbox', 'properties'],
  type: 'object',
} as const;

export const Get2ComplianceJobsIdResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/ComplianceJob',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const Get2ComplianceJobsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/ComplianceJob',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    meta: {
      properties: {
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2DmConversationsIdDmEventsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/DmEvent',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2DmConversationsWithParticipantIdDmEventsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/DmEvent',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2DmEventsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/DmEvent',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2ListsIdFollowersResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/User',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2ListsIdMembersResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/User',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2ListsIdResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/List',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2ListsIdTweetsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Tweet',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2SpacesByCreatorIdsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Space',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2SpacesIdBuyersResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/User',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2SpacesIdResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/Space',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2SpacesIdTweetsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Tweet',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2SpacesResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Space',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2SpacesSearchResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Space',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsCountsAllResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/SearchCount',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    meta: {
      properties: {
        newest_id: {
          $ref: '#/components/schemas/NewestId',
        },
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        oldest_id: {
          $ref: '#/components/schemas/OldestId',
        },
        total_tweet_count: {
          $ref: '#/components/schemas/Aggregate',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsCountsRecentResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/SearchCount',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    meta: {
      properties: {
        newest_id: {
          $ref: '#/components/schemas/NewestId',
        },
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        oldest_id: {
          $ref: '#/components/schemas/OldestId',
        },
        total_tweet_count: {
          $ref: '#/components/schemas/Aggregate',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsFirehoseStreamResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/Tweet',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsIdLikingUsersResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/User',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsIdQuoteTweetsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Tweet',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsIdResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/Tweet',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsIdRetweetedByResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/User',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Tweet',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsSample10StreamResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/Tweet',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsSampleStreamResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/Tweet',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsSearchAllResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Tweet',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        newest_id: {
          $ref: '#/components/schemas/NewestId',
        },
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        oldest_id: {
          $ref: '#/components/schemas/OldestId',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsSearchRecentResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Tweet',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        newest_id: {
          $ref: '#/components/schemas/NewestId',
        },
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        oldest_id: {
          $ref: '#/components/schemas/OldestId',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2TweetsSearchStreamResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/Tweet',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2UsersByResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/User',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2UsersByUsernameUsernameResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/User',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdBlockingResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/User',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdBookmarksResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Tweet',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdFollowedListsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/List',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdFollowersResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/User',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdFollowingResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/User',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdLikedTweetsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Tweet',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdListMembershipsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/List',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdMentionsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Tweet',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        newest_id: {
          $ref: '#/components/schemas/NewestId',
        },
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        oldest_id: {
          $ref: '#/components/schemas/OldestId',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdMutingResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/User',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdOwnedListsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/List',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdPinnedListsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/List',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/User',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdTimelinesReverseChronologicalResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Tweet',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        newest_id: {
          $ref: '#/components/schemas/NewestId',
        },
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        oldest_id: {
          $ref: '#/components/schemas/OldestId',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersIdTweetsResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Tweet',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
    meta: {
      properties: {
        newest_id: {
          $ref: '#/components/schemas/NewestId',
        },
        next_token: {
          $ref: '#/components/schemas/NextToken',
        },
        oldest_id: {
          $ref: '#/components/schemas/OldestId',
        },
        previous_token: {
          $ref: '#/components/schemas/PreviousToken',
        },
        result_count: {
          $ref: '#/components/schemas/ResultCount',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const Get2UsersMeResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/User',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const Get2UsersResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/User',
      },
      minItems: 1,
      type: 'array',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const HashtagEntitySchema = {
  allOf: [
    {
      $ref: '#/components/schemas/EntityIndicesInclusiveExclusive',
    },
    {
      $ref: '#/components/schemas/HashtagFields',
    },
  ],
} as const;

export const HashtagFieldsSchema = {
  description: 'Represent the portion of text recognized as a Hashtag, and its start and end position within the text.',
  properties: {
    tag: {
      description: 'The text of the Hashtag.',
      example: 'MondayMotivation',
      type: 'string',
    },
  },
  required: ['tag'],
  type: 'object',
} as const;

export const HttpStatusCodeSchema = {
  description: 'HTTP Status Code.',
  maximum: 599,
  minimum: 100,
  type: 'integer',
} as const;

export const InvalidRequestProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
    {
      properties: {
        errors: {
          items: {
            properties: {
              message: {
                type: 'string',
              },
              parameters: {
                additionalProperties: {
                  items: {
                    type: 'string',
                  },
                  type: 'array',
                },
                type: 'object',
              },
            },
            type: 'object',
          },
          minItems: 1,
          type: 'array',
        },
      },
      type: 'object',
    },
  ],
  description: 'A problem that indicates this request is invalid.',
} as const;

export const InvalidRuleProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
  ],
  description: 'The rule you have submitted is invalid.',
} as const;

export const JobIdSchema = {
  description: 'Compliance Job ID.',
  example: '1372966999991541762',
  pattern: '^[0-9]{1,19}$',
  type: 'string',
} as const;

export const ListSchema = {
  description: 'A Twitter List is a curated group of accounts.',
  properties: {
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    description: {
      type: 'string',
    },
    follower_count: {
      type: 'integer',
    },
    id: {
      $ref: '#/components/schemas/ListId',
    },
    member_count: {
      type: 'integer',
    },
    name: {
      description: 'The name of this List.',
      type: 'string',
    },
    owner_id: {
      $ref: '#/components/schemas/UserId',
    },
    private: {
      type: 'boolean',
    },
  },
  required: ['id', 'name'],
  type: 'object',
} as const;

export const ListAddUserRequestSchema = {
  properties: {
    user_id: {
      $ref: '#/components/schemas/UserId',
    },
  },
  required: ['user_id'],
  type: 'object',
} as const;

export const ListCreateRequestSchema = {
  properties: {
    description: {
      maxLength: 100,
      minLength: 0,
      type: 'string',
    },
    name: {
      maxLength: 25,
      minLength: 1,
      type: 'string',
    },
    private: {
      default: false,
      type: 'boolean',
    },
  },
  required: ['name'],
  type: 'object',
} as const;

export const ListCreateResponseSchema = {
  properties: {
    data: {
      description: 'A Twitter List is a curated group of accounts.',
      properties: {
        id: {
          $ref: '#/components/schemas/ListId',
        },
        name: {
          description: 'The name of this List.',
          type: 'string',
        },
      },
      required: ['id', 'name'],
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ListDeleteResponseSchema = {
  properties: {
    data: {
      properties: {
        deleted: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ListFollowedRequestSchema = {
  properties: {
    list_id: {
      $ref: '#/components/schemas/ListId',
    },
  },
  required: ['list_id'],
  type: 'object',
} as const;

export const ListFollowedResponseSchema = {
  properties: {
    data: {
      properties: {
        following: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ListIdSchema = {
  description: 'The unique identifier of this List.',
  example: '1146654567674912769',
  pattern: '^[0-9]{1,19}$',
  type: 'string',
} as const;

export const ListMutateResponseSchema = {
  properties: {
    data: {
      properties: {
        is_member: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ListPinnedRequestSchema = {
  properties: {
    list_id: {
      $ref: '#/components/schemas/ListId',
    },
  },
  required: ['list_id'],
  type: 'object',
} as const;

export const ListPinnedResponseSchema = {
  properties: {
    data: {
      properties: {
        pinned: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ListUnpinResponseSchema = {
  properties: {
    data: {
      properties: {
        pinned: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ListUpdateRequestSchema = {
  properties: {
    description: {
      maxLength: 100,
      minLength: 0,
      type: 'string',
    },
    name: {
      maxLength: 25,
      minLength: 1,
      type: 'string',
    },
    private: {
      type: 'boolean',
    },
  },
  type: 'object',
} as const;

export const ListUpdateResponseSchema = {
  properties: {
    data: {
      properties: {
        updated: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const MediaSchema = {
  discriminator: {
    mapping: {
      animated_gif: '#/components/schemas/AnimatedGif',
      photo: '#/components/schemas/Photo',
      video: '#/components/schemas/Video',
    },
    propertyName: 'type',
  },
  properties: {
    height: {
      $ref: '#/components/schemas/MediaHeight',
    },
    media_key: {
      $ref: '#/components/schemas/MediaKey',
    },
    type: {
      type: 'string',
    },
    width: {
      $ref: '#/components/schemas/MediaWidth',
    },
  },
  required: ['type'],
  type: 'object',
} as const;

export const MediaHeightSchema = {
  description: 'The height of the media in pixels.',
  minimum: 0,
  type: 'integer',
} as const;

export const MediaIdSchema = {
  description: 'The unique identifier of this Media.',
  example: '1146654567674912769',
  pattern: '^[0-9]{1,19}$',
  type: 'string',
} as const;

export const MediaKeySchema = {
  description: 'The Media Key identifier for this attachment.',
  pattern: '^([0-9]+)_([0-9]+)$',
  type: 'string',
} as const;

export const MediaWidthSchema = {
  description: 'The width of the media in pixels.',
  minimum: 0,
  type: 'integer',
} as const;

export const MentionEntitySchema = {
  allOf: [
    {
      $ref: '#/components/schemas/EntityIndicesInclusiveExclusive',
    },
    {
      $ref: '#/components/schemas/MentionFields',
    },
  ],
} as const;

export const MentionFieldsSchema = {
  description:
    'Represent the portion of text recognized as a User mention, and its start and end position within the text.',
  properties: {
    id: {
      $ref: '#/components/schemas/UserId',
    },
    username: {
      $ref: '#/components/schemas/UserName',
    },
  },
  required: ['username'],
  type: 'object',
} as const;

export const MuteUserMutationResponseSchema = {
  properties: {
    data: {
      properties: {
        muting: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const MuteUserRequestSchema = {
  properties: {
    target_user_id: {
      $ref: '#/components/schemas/UserId',
    },
  },
  required: ['target_user_id'],
  type: 'object',
} as const;

export const NewestIdSchema = {
  description: 'The newest id in this response.',
  type: 'string',
} as const;

export const NextTokenSchema = {
  description: 'The next token.',
  minLength: 1,
  type: 'string',
} as const;

export const NonCompliantRulesProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
  ],
  description: "A problem that indicates the user's rule set is not compliant.",
} as const;

export const Oauth1PermissionsProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
  ],
  description:
    'A problem that indicates your client application does not have the required OAuth1 permissions for the requested endpoint.',
} as const;

export const OldestIdSchema = {
  description: 'The oldest id in this response.',
  type: 'string',
} as const;

export const OperationalDisconnectProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
    {
      properties: {
        disconnect_type: {
          enum: [
            'OperationalDisconnect',
            'UpstreamOperationalDisconnect',
            'ForceDisconnect',
            'UpstreamUncleanDisconnect',
            'SlowReader',
            'InternalError',
            'ClientApplicationStateDegraded',
            'InvalidRules',
          ],
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
  description: 'You have been disconnected for operational reasons.',
} as const;

export const PaginationToken32Schema = {
  description: 'A base32 pagination token.',
  minLength: 16,
  type: 'string',
} as const;

export const PaginationToken36Schema = {
  description: 'A base36 pagination token.',
  minLength: 1,
  type: 'string',
} as const;

export const PaginationTokenLongSchema = {
  description: "A 'long' pagination token.",
  maxLength: 19,
  minLength: 1,
  type: 'string',
} as const;

export const PhotoSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Media',
    },
    {
      properties: {
        alt_text: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const PlaceSchema = {
  properties: {
    contained_within: {
      items: {
        $ref: '#/components/schemas/PlaceId',
      },
      minItems: 1,
      type: 'array',
    },
    country: {
      description: 'The full name of the county in which this place exists.',
      example: 'United States',
      type: 'string',
    },
    country_code: {
      $ref: '#/components/schemas/CountryCode',
    },
    full_name: {
      description: 'The full name of this place.',
      example: 'Lakewood, CO',
      type: 'string',
    },
    geo: {
      $ref: '#/components/schemas/Geo',
    },
    id: {
      $ref: '#/components/schemas/PlaceId',
    },
    name: {
      description: 'The human readable name of this place.',
      example: 'Lakewood',
      type: 'string',
    },
    place_type: {
      $ref: '#/components/schemas/PlaceType',
    },
  },
  required: ['id', 'full_name'],
  type: 'object',
} as const;

export const PlaceIdSchema = {
  description: 'The identifier for this place.',
  example: 'f7eb2fa2fea288b1',
  type: 'string',
} as const;

export const PlaceTypeSchema = {
  enum: ['poi', 'neighborhood', 'city', 'admin', 'country', 'unknown'],
  example: 'city',
  type: 'string',
} as const;

export const PointSchema = {
  description: 'A [GeoJson Point](https://tools.ietf.org/html/rfc7946#section-3.1.2) geometry object.',
  properties: {
    coordinates: {
      $ref: '#/components/schemas/Position',
    },
    type: {
      enum: ['Point'],
      example: 'Point',
      type: 'string',
    },
  },
  required: ['type', 'coordinates'],
  type: 'object',
} as const;

export const PollSchema = {
  description: 'Represent a Poll attached to a Tweet.',
  properties: {
    duration_minutes: {
      format: 'int32',
      maximum: 10080,
      minimum: 5,
      type: 'integer',
    },
    end_datetime: {
      format: 'date-time',
      type: 'string',
    },
    id: {
      $ref: '#/components/schemas/PollId',
    },
    options: {
      items: {
        $ref: '#/components/schemas/PollOption',
      },
      maxItems: 4,
      minItems: 2,
      type: 'array',
    },
    voting_status: {
      enum: ['open', 'closed'],
      type: 'string',
    },
  },
  required: ['id', 'options'],
  type: 'object',
} as const;

export const PollIdSchema = {
  description: 'Unique identifier of this poll.',
  example: '1365059861688410112',
  pattern: '^[0-9]{1,19}$',
  type: 'string',
} as const;

export const PollOptionSchema = {
  description: 'Describes a choice in a Poll object.',
  properties: {
    label: {
      $ref: '#/components/schemas/PollOptionLabel',
    },
    position: {
      description: 'Position of this choice in the poll.',
      type: 'integer',
    },
    votes: {
      description: 'Number of users who voted for this choice.',
      type: 'integer',
    },
  },
  required: ['position', 'label', 'votes'],
  type: 'object',
} as const;

export const PollOptionLabelSchema = {
  description: 'The text of a poll choice.',
  maxLength: 25,
  minLength: 1,
  type: 'string',
} as const;

export const PositionSchema = {
  description:
    'A [GeoJson Position](https://tools.ietf.org/html/rfc7946#section-3.1.1) in the format `[longitude,latitude]`.',
  example: [-105.18816086351444, 40.247749999999996],
  items: {
    type: 'number',
  },
  maxItems: 2,
  minItems: 2,
  type: 'array',
} as const;

export const PreviousTokenSchema = {
  description: 'The previous token.',
  minLength: 1,
  type: 'string',
} as const;

export const ProblemSchema = {
  description: 'An HTTP Problem Details object, as defined in IETF RFC 7807 (https://tools.ietf.org/html/rfc7807).',
  discriminator: {
    mapping: {
      'about:blank': '#/components/schemas/GenericProblem',
      'https://api.twitter.com/2/problems/client-disconnected': '#/components/schemas/ClientDisconnectedProblem',
      'https://api.twitter.com/2/problems/client-forbidden': '#/components/schemas/ClientForbiddenProblem',
      'https://api.twitter.com/2/problems/conflict': '#/components/schemas/ConflictProblem',
      'https://api.twitter.com/2/problems/disallowed-resource': '#/components/schemas/DisallowedResourceProblem',
      'https://api.twitter.com/2/problems/duplicate-rules': '#/components/schemas/DuplicateRuleProblem',
      'https://api.twitter.com/2/problems/invalid-request': '#/components/schemas/InvalidRequestProblem',
      'https://api.twitter.com/2/problems/invalid-rules': '#/components/schemas/InvalidRuleProblem',
      'https://api.twitter.com/2/problems/noncompliant-rules': '#/components/schemas/NonCompliantRulesProblem',
      'https://api.twitter.com/2/problems/not-authorized-for-field': '#/components/schemas/FieldUnauthorizedProblem',
      'https://api.twitter.com/2/problems/not-authorized-for-resource':
        '#/components/schemas/ResourceUnauthorizedProblem',
      'https://api.twitter.com/2/problems/oauth1-permissions': '#/components/schemas/Oauth1PermissionsProblem',
      'https://api.twitter.com/2/problems/operational-disconnect': '#/components/schemas/OperationalDisconnectProblem',
      'https://api.twitter.com/2/problems/resource-not-found': '#/components/schemas/ResourceNotFoundProblem',
      'https://api.twitter.com/2/problems/resource-unavailable': '#/components/schemas/ResourceUnavailableProblem',
      'https://api.twitter.com/2/problems/rule-cap': '#/components/schemas/RulesCapProblem',
      'https://api.twitter.com/2/problems/streaming-connection': '#/components/schemas/ConnectionExceptionProblem',
      'https://api.twitter.com/2/problems/unsupported-authentication':
        '#/components/schemas/UnsupportedAuthenticationProblem',
      'https://api.twitter.com/2/problems/usage-capped': '#/components/schemas/UsageCapExceededProblem',
    },
    propertyName: 'type',
  },
  properties: {
    detail: {
      type: 'string',
    },
    status: {
      type: 'integer',
    },
    title: {
      type: 'string',
    },
    type: {
      type: 'string',
    },
  },
  required: ['type', 'title'],
  type: 'object',
} as const;

export const ReplySettingsSchema = {
  description: 'Shows who can reply a Tweet. Fields returned are everyone, mentioned_users, and following.',
  enum: ['everyone', 'mentionedUsers', 'following', 'other'],
  pattern: '^[A-Za-z]{1,12}$',
  type: 'string',
} as const;

export const ResourceNotFoundProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
    {
      properties: {
        parameter: {
          minLength: 1,
          type: 'string',
        },
        resource_id: {
          type: 'string',
        },
        resource_type: {
          enum: ['user', 'tweet', 'media', 'list', 'space'],
          type: 'string',
        },
        value: {
          description: 'Value will match the schema of the field.',
          type: 'string',
        },
      },
      required: ['parameter', 'value', 'resource_id', 'resource_type'],
      type: 'object',
    },
  ],
  description: 'A problem that indicates that a given Tweet, User, etc. does not exist.',
} as const;

export const ResourceUnauthorizedProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
    {
      properties: {
        parameter: {
          type: 'string',
        },
        resource_id: {
          type: 'string',
        },
        resource_type: {
          enum: ['user', 'tweet', 'media', 'list', 'space'],
          type: 'string',
        },
        section: {
          enum: ['data', 'includes'],
          type: 'string',
        },
        value: {
          type: 'string',
        },
      },
      required: ['value', 'resource_id', 'resource_type', 'section', 'parameter'],
      type: 'object',
    },
  ],
  description: 'A problem that indicates you are not allowed to see a particular Tweet, User, etc.',
} as const;

export const ResourceUnavailableProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
    {
      properties: {
        parameter: {
          minLength: 1,
          type: 'string',
        },
        resource_id: {
          type: 'string',
        },
        resource_type: {
          enum: ['user', 'tweet', 'media', 'list', 'space'],
          type: 'string',
        },
      },
      required: ['parameter', 'resource_id', 'resource_type'],
      type: 'object',
    },
  ],
  description: 'A problem that indicates a particular Tweet, User, etc. is not available to you.',
} as const;

export const ResultCountSchema = {
  description: 'The number of results returned in this response.',
  format: 'int32',
  type: 'integer',
} as const;

export const RuleSchema = {
  description: 'A user-provided stream filtering rule.',
  properties: {
    id: {
      $ref: '#/components/schemas/RuleId',
    },
    tag: {
      $ref: '#/components/schemas/RuleTag',
    },
    value: {
      $ref: '#/components/schemas/RuleValue',
    },
  },
  required: ['value'],
  type: 'object',
} as const;

export const RuleIdSchema = {
  description: 'Unique identifier of this rule.',
  example: '120897978112909812',
  pattern: '^[0-9]{1,19}$',
  type: 'string',
} as const;

export const RuleNoIdSchema = {
  description: 'A user-provided stream filtering rule.',
  properties: {
    tag: {
      $ref: '#/components/schemas/RuleTag',
    },
    value: {
      $ref: '#/components/schemas/RuleValue',
    },
  },
  required: ['value'],
  type: 'object',
} as const;

export const RuleTagSchema = {
  description: 'A tag meant for the labeling of user provided rules.',
  example: 'Non-retweeted coffee Tweets',
  type: 'string',
} as const;

export const RuleValueSchema = {
  description: 'The filterlang value of the rule.',
  example: 'coffee -is:retweet',
  type: 'string',
} as const;

export const RulesCapProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
  ],
  description: 'You have exceeded the maximum number of rules.',
} as const;

export const RulesLookupResponseSchema = {
  properties: {
    data: {
      items: {
        $ref: '#/components/schemas/Rule',
      },
      type: 'array',
    },
    meta: {
      $ref: '#/components/schemas/RulesResponseMetadata',
    },
  },
  required: ['meta'],
  type: 'object',
} as const;

export const RulesRequestSummarySchema = {
  oneOf: [
    {
      description: 'A summary of the results of the addition of user-specified stream filtering rules.',
      properties: {
        created: {
          description: 'Number of user-specified stream filtering rules that were created.',
          example: 1,
          format: 'int32',
          type: 'integer',
        },
        invalid: {
          description: 'Number of invalid user-specified stream filtering rules.',
          example: 1,
          format: 'int32',
          type: 'integer',
        },
        not_created: {
          description: 'Number of user-specified stream filtering rules that were not created.',
          example: 1,
          format: 'int32',
          type: 'integer',
        },
        valid: {
          description: 'Number of valid user-specified stream filtering rules.',
          example: 1,
          format: 'int32',
          type: 'integer',
        },
      },
      required: ['created', 'not_created', 'valid', 'invalid'],
      type: 'object',
    },
    {
      properties: {
        deleted: {
          description: 'Number of user-specified stream filtering rules that were deleted.',
          format: 'int32',
          type: 'integer',
        },
        not_deleted: {
          description: 'Number of user-specified stream filtering rules that were not deleted.',
          format: 'int32',
          type: 'integer',
        },
      },
      required: ['deleted', 'not_deleted'],
      type: 'object',
    },
  ],
} as const;

export const RulesResponseMetadataSchema = {
  properties: {
    next_token: {
      $ref: '#/components/schemas/NextToken',
    },
    result_count: {
      description: 'Number of Rules in result set.',
      format: 'int32',
      type: 'integer',
    },
    sent: {
      type: 'string',
    },
    summary: {
      $ref: '#/components/schemas/RulesRequestSummary',
    },
  },
  required: ['sent'],
  type: 'object',
} as const;

export const SearchCountSchema = {
  description: 'Represent a Search Count Result.',
  properties: {
    end: {
      $ref: '#/components/schemas/End',
    },
    start: {
      $ref: '#/components/schemas/Start',
    },
    tweet_count: {
      $ref: '#/components/schemas/TweetCount',
    },
  },
  required: ['end', 'start', 'tweet_count'],
  type: 'object',
} as const;

export const SpaceSchema = {
  description: '',
  properties: {
    created_at: {
      description: 'Creation time of the Space.',
      example: '2021-07-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    creator_id: {
      $ref: '#/components/schemas/UserId',
    },
    ended_at: {
      description: 'End time of the Space.',
      example: '2021-07-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    host_ids: {
      description: 'The user ids for the hosts of the Space.',
      items: {
        $ref: '#/components/schemas/UserId',
      },
      type: 'array',
    },
    id: {
      $ref: '#/components/schemas/SpaceId',
    },
    invited_user_ids: {
      description: 'An array of user ids for people who were invited to a Space.',
      items: {
        $ref: '#/components/schemas/UserId',
      },
      type: 'array',
    },
    is_ticketed: {
      description: 'Denotes if the Space is a ticketed Space.',
      example: 'false',
      type: 'boolean',
    },
    lang: {
      description: 'The language of the Space.',
      example: 'en',
      type: 'string',
    },
    participant_count: {
      description: 'The number of participants in a Space.',
      example: 10,
      format: 'int32',
      type: 'integer',
    },
    scheduled_start: {
      description: 'A date time stamp for when a Space is scheduled to begin.',
      example: '2021-07-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    speaker_ids: {
      description: 'An array of user ids for people who were speakers in a Space.',
      items: {
        $ref: '#/components/schemas/UserId',
      },
      type: 'array',
    },
    started_at: {
      description: 'When the Space was started as a date string.',
      example: '2021-7-14T04:35:55Z',
      format: 'date-time',
      type: 'string',
    },
    state: {
      description: 'The current state of the Space.',
      enum: ['live', 'scheduled', 'ended'],
      example: 'live',
      type: 'string',
    },
    subscriber_count: {
      description: 'The number of people who have either purchased a ticket or set a reminder for this Space.',
      example: 10,
      format: 'int32',
      type: 'integer',
    },
    title: {
      description: 'The title of the Space.',
      example: 'Spaces are Awesome',
      type: 'string',
    },
    topics: {
      description: 'The topics of a Space, as selected by its creator.',
      items: {
        description: 'The Twitter Topic object.',
        example: {
          description: 'All about technology',
          id: '848920371311001600',
          name: 'Technology',
        },
        properties: {
          description: {
            description: 'The description of the given topic.',
            type: 'string',
          },
          id: {
            description: 'An ID suitable for use in the REST API.',
            type: 'string',
          },
          name: {
            description: 'The name of the given topic.',
            type: 'string',
          },
        },
        required: ['id', 'name'],
        type: 'object',
      },
      type: 'array',
    },
    updated_at: {
      description: 'When the Space was last updated.',
      example: '2021-7-14T04:35:55Z',
      format: 'date-time',
      type: 'string',
    },
  },
  required: ['id', 'state'],
  type: 'object',
} as const;

export const SpaceIdSchema = {
  description: 'The unique identifier of this Space.',
  example: '1SLjjRYNejbKM',
  pattern: '^[a-zA-Z0-9]{1,13}$',
  type: 'string',
} as const;

export const StartSchema = {
  description: 'The start time of the bucket.',
  format: 'date-time',
  type: 'string',
} as const;

export const StreamingTweetResponseSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/Tweet',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
    includes: {
      $ref: '#/components/schemas/Expansions',
    },
  },
  type: 'object',
} as const;

export const TopicSchema = {
  description: 'The topic of a Space, as selected by its creator.',
  properties: {
    description: {
      description: 'The description of the given topic.',
      example: 'All about technology',
      type: 'string',
    },
    id: {
      $ref: '#/components/schemas/TopicId',
    },
    name: {
      description: 'The name of the given topic.',
      example: 'Technology',
      type: 'string',
    },
  },
  required: ['id', 'name'],
  type: 'object',
} as const;

export const TopicIdSchema = {
  description: 'Unique identifier of this Topic.',
  type: 'string',
} as const;

export const TweetSchema = {
  example: {
    author_id: '2244994945',
    created_at: 'Wed Jan 06 18:40:40 +0000 2021',
    id: '1346889436626259968',
    text: 'Learn how to use the user Tweet timeline and user mention timeline endpoints in the Twitter API v2 to explore Tweet… https:\\/\\/t.co\\/56a0vZUx7i',
  },
  properties: {
    attachments: {
      description: 'Specifies the type of attachments (if any) present in this Tweet.',
      properties: {
        media_keys: {
          description: 'A list of Media Keys for each one of the media attachments (if media are attached).',
          items: {
            $ref: '#/components/schemas/MediaKey',
          },
          minItems: 1,
          type: 'array',
        },
        poll_ids: {
          description: 'A list of poll IDs (if polls are attached).',
          items: {
            $ref: '#/components/schemas/PollId',
          },
          minItems: 1,
          type: 'array',
        },
      },
      type: 'object',
    },
    author_id: {
      $ref: '#/components/schemas/UserId',
    },
    context_annotations: {
      items: {
        $ref: '#/components/schemas/ContextAnnotation',
      },
      minItems: 1,
      type: 'array',
    },
    conversation_id: {
      $ref: '#/components/schemas/TweetId',
    },
    created_at: {
      description: 'Creation time of the Tweet.',
      example: '2021-01-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    edit_controls: {
      properties: {
        editable_until: {
          description: 'Time when Tweet is no longer editable.',
          example: '2021-01-06T18:40:40.000Z',
          format: 'date-time',
          type: 'string',
        },
        edits_remaining: {
          description: 'Number of times this Tweet can be edited.',
          type: 'integer',
        },
        is_edit_eligible: {
          description: 'Indicates if this Tweet is eligible to be edited.',
          example: false,
          type: 'boolean',
        },
      },
      required: ['is_edit_eligible', 'editable_until', 'edits_remaining'],
      type: 'object',
    },
    edit_history_tweet_ids: {
      description: 'A list of Tweet Ids in this Tweet chain.',
      items: {
        $ref: '#/components/schemas/TweetId',
      },
      minItems: 1,
      type: 'array',
    },
    entities: {
      $ref: '#/components/schemas/FullTextEntities',
    },
    geo: {
      description: 'The location tagged on the Tweet, if the user provided one.',
      properties: {
        coordinates: {
          $ref: '#/components/schemas/Point',
        },
        place_id: {
          $ref: '#/components/schemas/PlaceId',
        },
      },
      type: 'object',
    },
    id: {
      $ref: '#/components/schemas/TweetId',
    },
    in_reply_to_user_id: {
      $ref: '#/components/schemas/UserId',
    },
    lang: {
      description: 'Language of the Tweet, if detected by Twitter. Returned as a BCP47 language tag.',
      example: 'en',
      type: 'string',
    },
    non_public_metrics: {
      description: 'Nonpublic engagement metrics for the Tweet at the time of the request.',
      properties: {
        impression_count: {
          description: 'Number of times this Tweet has been viewed.',
          format: 'int32',
          type: 'integer',
        },
      },
      type: 'object',
    },
    organic_metrics: {
      description: 'Organic nonpublic engagement metrics for the Tweet at the time of the request.',
      properties: {
        impression_count: {
          description: 'Number of times this Tweet has been viewed.',
          type: 'integer',
        },
        like_count: {
          description: 'Number of times this Tweet has been liked.',
          type: 'integer',
        },
        reply_count: {
          description: 'Number of times this Tweet has been replied to.',
          type: 'integer',
        },
        retweet_count: {
          description: 'Number of times this Tweet has been Retweeted.',
          type: 'integer',
        },
      },
      required: ['impression_count', 'retweet_count', 'reply_count', 'like_count'],
      type: 'object',
    },
    possibly_sensitive: {
      description:
        'Indicates if this Tweet contains URLs marked as sensitive, for example content suitable for mature audiences.',
      example: false,
      type: 'boolean',
    },
    promoted_metrics: {
      description: 'Promoted nonpublic engagement metrics for the Tweet at the time of the request.',
      properties: {
        impression_count: {
          description: 'Number of times this Tweet has been viewed.',
          format: 'int32',
          type: 'integer',
        },
        like_count: {
          description: 'Number of times this Tweet has been liked.',
          format: 'int32',
          type: 'integer',
        },
        reply_count: {
          description: 'Number of times this Tweet has been replied to.',
          format: 'int32',
          type: 'integer',
        },
        retweet_count: {
          description: 'Number of times this Tweet has been Retweeted.',
          format: 'int32',
          type: 'integer',
        },
      },
      type: 'object',
    },
    public_metrics: {
      description: 'Engagement metrics for the Tweet at the time of the request.',
      properties: {
        impression_count: {
          description: 'Number of times this Tweet has been viewed.',
          format: 'int32',
          type: 'integer',
        },
        like_count: {
          description: 'Number of times this Tweet has been liked.',
          type: 'integer',
        },
        quote_count: {
          description: 'Number of times this Tweet has been quoted.',
          type: 'integer',
        },
        reply_count: {
          description: 'Number of times this Tweet has been replied to.',
          type: 'integer',
        },
        retweet_count: {
          description: 'Number of times this Tweet has been Retweeted.',
          type: 'integer',
        },
      },
      required: ['retweet_count', 'reply_count', 'like_count', 'impression_count'],
      type: 'object',
    },
    referenced_tweets: {
      description:
        'A list of Tweets this Tweet refers to. For example, if the parent Tweet is a Retweet, a Quoted Tweet or a Reply, it will include the related Tweet referenced to by its parent.',
      items: {
        properties: {
          id: {
            $ref: '#/components/schemas/TweetId',
          },
          type: {
            enum: ['retweeted', 'quoted', 'replied_to'],
            type: 'string',
          },
        },
        required: ['type', 'id'],
        type: 'object',
      },
      minItems: 1,
      type: 'array',
    },
    reply_settings: {
      $ref: '#/components/schemas/ReplySettings',
    },
    source: {
      description: 'This is deprecated.',
      type: 'string',
    },
    text: {
      $ref: '#/components/schemas/TweetText',
    },
    withheld: {
      $ref: '#/components/schemas/TweetWithheld',
    },
  },
  required: ['id', 'text', 'edit_history_tweet_ids'],
  type: 'object',
} as const;

export const TweetComplianceDataSchema = {
  description: 'Tweet compliance data.',
  oneOf: [
    {
      $ref: '#/components/schemas/TweetDeleteComplianceSchema',
    },
    {
      $ref: '#/components/schemas/TweetWithheldComplianceSchema',
    },
    {
      $ref: '#/components/schemas/TweetDropComplianceSchema',
    },
    {
      $ref: '#/components/schemas/TweetUndropComplianceSchema',
    },
    {
      $ref: '#/components/schemas/TweetEditComplianceSchema',
    },
  ],
} as const;

export const TweetComplianceSchemaSchema = {
  properties: {
    event_at: {
      description: 'Event time.',
      example: '2021-07-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    quote_tweet_id: {
      $ref: '#/components/schemas/TweetId',
    },
    tweet: {
      properties: {
        author_id: {
          $ref: '#/components/schemas/UserId',
        },
        id: {
          $ref: '#/components/schemas/TweetId',
        },
      },
      required: ['id', 'author_id'],
      type: 'object',
    },
  },
  required: ['tweet', 'event_at'],
  type: 'object',
} as const;

export const TweetComplianceStreamResponseSchema = {
  description: 'Tweet compliance stream events.',
  oneOf: [
    {
      description: 'Compliance event.',
      properties: {
        data: {
          $ref: '#/components/schemas/TweetComplianceData',
        },
      },
      required: ['data'],
      type: 'object',
    },
    {
      properties: {
        errors: {
          items: {
            $ref: '#/components/schemas/Problem',
          },
          minItems: 1,
          type: 'array',
        },
      },
      required: ['errors'],
      type: 'object',
    },
  ],
} as const;

export const TweetCountSchema = {
  description: 'The count for the bucket.',
  type: 'integer',
} as const;

export const TweetCreateRequestSchema = {
  additionalProperties: false,
  properties: {
    card_uri: {
      description:
        'Card Uri Parameter. This is mutually exclusive from Quote Tweet Id, Poll, Media, and Direct Message Deep Link.',
      type: 'string',
    },
    direct_message_deep_link: {
      description: 'Link to take the conversation from the public timeline to a private Direct Message.',
      type: 'string',
    },
    for_super_followers_only: {
      default: false,
      description: 'Exclusive Tweet for super followers.',
      type: 'boolean',
    },
    geo: {
      additionalProperties: false,
      description: 'Place ID being attached to the Tweet for geo location.',
      properties: {
        place_id: {
          type: 'string',
        },
      },
      type: 'object',
    },
    media: {
      additionalProperties: false,
      description:
        'Media information being attached to created Tweet. This is mutually exclusive from Quote Tweet Id, Poll, and Card URI.',
      properties: {
        media_ids: {
          description: 'A list of Media Ids to be attached to a created Tweet.',
          items: {
            $ref: '#/components/schemas/MediaId',
          },
          maxItems: 4,
          minItems: 1,
          type: 'array',
        },
        tagged_user_ids: {
          description: 'A list of User Ids to be tagged in the media for created Tweet.',
          items: {
            $ref: '#/components/schemas/UserId',
          },
          maxItems: 10,
          minItems: 0,
          type: 'array',
        },
      },
      required: ['media_ids'],
      type: 'object',
    },
    nullcast: {
      default: false,
      description:
        'Nullcasted (promoted-only) Tweets do not appear in the public timeline and are not served to followers.',
      type: 'boolean',
    },
    poll: {
      additionalProperties: false,
      description:
        'Poll options for a Tweet with a poll. This is mutually exclusive from Media, Quote Tweet Id, and Card URI.',
      properties: {
        duration_minutes: {
          description: 'Duration of the poll in minutes.',
          format: 'int32',
          maximum: 10080,
          minimum: 5,
          type: 'integer',
        },
        options: {
          items: {
            description: 'The text of a poll choice.',
            maxLength: 25,
            minLength: 1,
            type: 'string',
          },
          maxItems: 4,
          minItems: 2,
          type: 'array',
        },
        reply_settings: {
          description: 'Settings to indicate who can reply to the Tweet.',
          enum: ['following', 'mentionedUsers'],
          type: 'string',
        },
      },
      required: ['options', 'duration_minutes'],
      type: 'object',
    },
    quote_tweet_id: {
      $ref: '#/components/schemas/TweetId',
    },
    reply: {
      additionalProperties: false,
      description: 'Tweet information of the Tweet being replied to.',
      properties: {
        exclude_reply_user_ids: {
          description: 'A list of User Ids to be excluded from the reply Tweet.',
          items: {
            $ref: '#/components/schemas/UserId',
          },
          type: 'array',
        },
        in_reply_to_tweet_id: {
          $ref: '#/components/schemas/TweetId',
        },
      },
      required: ['in_reply_to_tweet_id'],
      type: 'object',
    },
    reply_settings: {
      description: 'Settings to indicate who can reply to the Tweet.',
      enum: ['following', 'mentionedUsers'],
      type: 'string',
    },
    text: {
      $ref: '#/components/schemas/TweetText',
    },
  },
  type: 'object',
} as const;

export const TweetCreateResponseSchema = {
  properties: {
    data: {
      properties: {
        id: {
          $ref: '#/components/schemas/TweetId',
        },
        text: {
          $ref: '#/components/schemas/TweetText',
        },
      },
      required: ['id', 'text'],
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const TweetDeleteComplianceSchemaSchema = {
  properties: {
    delete: {
      $ref: '#/components/schemas/TweetComplianceSchema',
    },
  },
  required: ['delete'],
  type: 'object',
} as const;

export const TweetDeleteResponseSchema = {
  properties: {
    data: {
      properties: {
        deleted: {
          type: 'boolean',
        },
      },
      required: ['deleted'],
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const TweetDropComplianceSchemaSchema = {
  properties: {
    drop: {
      $ref: '#/components/schemas/TweetComplianceSchema',
    },
  },
  required: ['drop'],
  type: 'object',
} as const;

export const TweetEditComplianceObjectSchemaSchema = {
  properties: {
    edit_tweet_ids: {
      items: {
        $ref: '#/components/schemas/TweetId',
      },
      minItems: 1,
      type: 'array',
    },
    event_at: {
      description: 'Event time.',
      example: '2021-07-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    initial_tweet_id: {
      $ref: '#/components/schemas/TweetId',
    },
    tweet: {
      properties: {
        id: {
          $ref: '#/components/schemas/TweetId',
        },
      },
      required: ['id'],
      type: 'object',
    },
  },
  required: ['tweet', 'event_at', 'initial_tweet_id', 'edit_tweet_ids'],
  type: 'object',
} as const;

export const TweetEditComplianceSchemaSchema = {
  properties: {
    tweet_edit: {
      $ref: '#/components/schemas/TweetEditComplianceObjectSchema',
    },
  },
  required: ['tweet_edit'],
  type: 'object',
} as const;

export const TweetHideRequestSchema = {
  properties: {
    hidden: {
      type: 'boolean',
    },
  },
  required: ['hidden'],
  type: 'object',
} as const;

export const TweetHideResponseSchema = {
  properties: {
    data: {
      properties: {
        hidden: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const TweetIdSchema = {
  description:
    'Unique identifier of this Tweet. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.',
  example: '1346889436626259968',
  pattern: '^[0-9]{1,19}$',
  type: 'string',
} as const;

export const TweetLabelDataSchema = {
  description: 'Tweet label data.',
  oneOf: [
    {
      $ref: '#/components/schemas/TweetNoticeSchema',
    },
    {
      $ref: '#/components/schemas/TweetUnviewableSchema',
    },
  ],
} as const;

export const TweetLabelStreamResponseSchema = {
  description: 'Tweet label stream events.',
  oneOf: [
    {
      description: 'Tweet Label event.',
      properties: {
        data: {
          $ref: '#/components/schemas/TweetLabelData',
        },
      },
      required: ['data'],
      type: 'object',
    },
    {
      properties: {
        errors: {
          items: {
            $ref: '#/components/schemas/Problem',
          },
          minItems: 1,
          type: 'array',
        },
      },
      required: ['errors'],
      type: 'object',
    },
  ],
} as const;

export const TweetNoticeSchema = {
  properties: {
    application: {
      description: 'If the label is being applied or removed. Possible values are ‘apply’ or ‘remove’.',
      example: 'apply',
      type: 'string',
    },
    details: {
      description: 'Information shown on the Tweet label',
      type: 'string',
    },
    event_at: {
      description: 'Event time.',
      example: '2021-07-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    event_type: {
      description: 'The type of label on the Tweet',
      example: 'misleading',
      type: 'string',
    },
    extended_details_url: {
      description: 'Link to more information about this kind of label',
      type: 'string',
    },
    label_title: {
      description: 'Title/header of the Tweet label',
      type: 'string',
    },
    tweet: {
      properties: {
        author_id: {
          $ref: '#/components/schemas/UserId',
        },
        id: {
          $ref: '#/components/schemas/TweetId',
        },
      },
      required: ['id', 'author_id'],
      type: 'object',
    },
  },
  required: ['tweet', 'event_type', 'event_at', 'application'],
  type: 'object',
} as const;

export const TweetNoticeSchemaSchema = {
  properties: {
    public_tweet_notice: {
      $ref: '#/components/schemas/TweetNotice',
    },
  },
  required: ['public_tweet_notice'],
  type: 'object',
} as const;

export const TweetTakedownComplianceSchemaSchema = {
  properties: {
    event_at: {
      description: 'Event time.',
      example: '2021-07-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    quote_tweet_id: {
      $ref: '#/components/schemas/TweetId',
    },
    tweet: {
      properties: {
        author_id: {
          $ref: '#/components/schemas/UserId',
        },
        id: {
          $ref: '#/components/schemas/TweetId',
        },
      },
      required: ['id', 'author_id'],
      type: 'object',
    },
    withheld_in_countries: {
      items: {
        $ref: '#/components/schemas/CountryCode',
      },
      minItems: 1,
      type: 'array',
    },
  },
  required: ['tweet', 'withheld_in_countries', 'event_at'],
  type: 'object',
} as const;

export const TweetTextSchema = {
  description: 'The content of the Tweet.',
  example:
    'Learn how to use the user Tweet timeline and user mention timeline endpoints in the Twitter API v2 to explore Tweet… https:\\/\\/t.co\\/56a0vZUx7i',
  type: 'string',
} as const;

export const TweetUndropComplianceSchemaSchema = {
  properties: {
    undrop: {
      $ref: '#/components/schemas/TweetComplianceSchema',
    },
  },
  required: ['undrop'],
  type: 'object',
} as const;

export const TweetUnviewableSchema = {
  properties: {
    application: {
      description: 'If the label is being applied or removed. Possible values are ‘apply’ or ‘remove’.',
      example: 'apply',
      type: 'string',
    },
    event_at: {
      description: 'Event time.',
      example: '2021-07-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    tweet: {
      properties: {
        author_id: {
          $ref: '#/components/schemas/UserId',
        },
        id: {
          $ref: '#/components/schemas/TweetId',
        },
      },
      required: ['id', 'author_id'],
      type: 'object',
    },
  },
  required: ['tweet', 'event_at', 'application'],
  type: 'object',
} as const;

export const TweetUnviewableSchemaSchema = {
  properties: {
    public_tweet_unviewable: {
      $ref: '#/components/schemas/TweetUnviewable',
    },
  },
  required: ['public_tweet_unviewable'],
  type: 'object',
} as const;

export const TweetWithheldSchema = {
  description:
    'Indicates withholding details for [withheld content](https://help.twitter.com/en/rules-and-policies/tweet-withheld-by-country).',
  properties: {
    copyright: {
      description: 'Indicates if the content is being withheld for on the basis of copyright infringement.',
      type: 'boolean',
    },
    country_codes: {
      description: 'Provides a list of countries where this content is not available.',
      items: {
        $ref: '#/components/schemas/CountryCode',
      },
      minItems: 1,
      type: 'array',
      uniqueItems: true,
    },
    scope: {
      description: 'Indicates whether the content being withheld is the `tweet` or a `user`.',
      enum: ['tweet', 'user'],
      type: 'string',
    },
  },
  required: ['copyright', 'country_codes'],
  type: 'object',
} as const;

export const TweetWithheldComplianceSchemaSchema = {
  properties: {
    withheld: {
      $ref: '#/components/schemas/TweetTakedownComplianceSchema',
    },
  },
  required: ['withheld'],
  type: 'object',
} as const;

export const UnsupportedAuthenticationProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
  ],
  description: 'A problem that indicates that the authentication used is not supported.',
} as const;

export const UploadExpirationSchema = {
  description: 'Expiration time of the upload URL.',
  example: '2021-01-06T18:40:40.000Z',
  format: 'date-time',
  type: 'string',
} as const;

export const UploadUrlSchema = {
  description: 'URL to which the user will upload their Tweet or user IDs.',
  format: 'uri',
  type: 'string',
} as const;

export const UrlSchema = {
  description: 'A validly formatted URL.',
  example: 'https://developer.twitter.com/en/docs/twitter-api',
  format: 'uri',
  type: 'string',
} as const;

export const UrlEntitySchema = {
  allOf: [
    {
      $ref: '#/components/schemas/EntityIndicesInclusiveExclusive',
    },
    {
      $ref: '#/components/schemas/UrlFields',
    },
  ],
  description: 'Represent the portion of text recognized as a URL, and its start and end position within the text.',
} as const;

export const UrlFieldsSchema = {
  description: 'Represent the portion of text recognized as a URL.',
  properties: {
    description: {
      description: 'Description of the URL landing page.',
      example: 'This is a description of the website.',
      type: 'string',
    },
    display_url: {
      description: 'The URL as displayed in the Twitter client.',
      example: 'twittercommunity.com/t/introducing-…',
      type: 'string',
    },
    expanded_url: {
      $ref: '#/components/schemas/Url',
    },
    images: {
      items: {
        $ref: '#/components/schemas/UrlImage',
      },
      minItems: 1,
      type: 'array',
    },
    media_key: {
      $ref: '#/components/schemas/MediaKey',
    },
    status: {
      $ref: '#/components/schemas/HttpStatusCode',
    },
    title: {
      description: 'Title of the page the URL points to.',
      example: 'Introducing the v2 follow lookup endpoints',
      type: 'string',
    },
    unwound_url: {
      description: 'Fully resolved url.',
      example: 'https://twittercommunity.com/t/introducing-the-v2-follow-lookup-endpoints/147118',
      format: 'uri',
      type: 'string',
    },
    url: {
      $ref: '#/components/schemas/Url',
    },
  },
  required: ['url'],
  type: 'object',
} as const;

export const UrlImageSchema = {
  description: 'Represent the information for the URL image.',
  properties: {
    height: {
      $ref: '#/components/schemas/MediaHeight',
    },
    url: {
      $ref: '#/components/schemas/Url',
    },
    width: {
      $ref: '#/components/schemas/MediaWidth',
    },
  },
  type: 'object',
} as const;

export const UsageCapExceededProblemSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Problem',
    },
    {
      properties: {
        period: {
          enum: ['Daily', 'Monthly'],
          type: 'string',
        },
        scope: {
          enum: ['Account', 'Product'],
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
  description: 'A problem that indicates that a usage cap has been exceeded.',
} as const;

export const UserSchema = {
  description: 'The Twitter User object.',
  example: {
    created_at: '2013-12-14T04:35:55Z',
    id: '2244994945',
    name: 'Twitter Dev',
    protected: false,
    username: 'TwitterDev',
  },
  properties: {
    created_at: {
      description: 'Creation time of this User.',
      format: 'date-time',
      type: 'string',
    },
    description: {
      description: "The text of this User's profile description (also known as bio), if the User provided one.",
      type: 'string',
    },
    entities: {
      description: "A list of metadata found in the User's profile description.",
      properties: {
        description: {
          $ref: '#/components/schemas/FullTextEntities',
        },
        url: {
          description: "Expanded details for the URL specified in the User's profile, with start and end indices.",
          properties: {
            urls: {
              items: {
                $ref: '#/components/schemas/UrlEntity',
              },
              minItems: 1,
              type: 'array',
            },
          },
          type: 'object',
        },
      },
      type: 'object',
    },
    id: {
      $ref: '#/components/schemas/UserId',
    },
    location: {
      description:
        "The location specified in the User's profile, if the User provided one. As this is a freeform value, it may not indicate a valid location, but it may be fuzzily evaluated when performing searches with location queries.",
      type: 'string',
    },
    name: {
      description: 'The friendly name of this User, as shown on their profile.',
      type: 'string',
    },
    pinned_tweet_id: {
      $ref: '#/components/schemas/TweetId',
    },
    profile_image_url: {
      description: 'The URL to the profile image for this User.',
      format: 'uri',
      type: 'string',
    },
    protected: {
      description:
        "Indicates if this User has chosen to protect their Tweets (in other words, if this User's Tweets are private).",
      type: 'boolean',
    },
    public_metrics: {
      description: 'A list of metrics for this User.',
      properties: {
        followers_count: {
          description: 'Number of Users who are following this User.',
          type: 'integer',
        },
        following_count: {
          description: 'Number of Users this User is following.',
          type: 'integer',
        },
        listed_count: {
          description: 'The number of lists that include this User.',
          type: 'integer',
        },
        tweet_count: {
          description: 'The number of Tweets (including Retweets) posted by this User.',
          type: 'integer',
        },
      },
      required: ['followers_count', 'following_count', 'tweet_count', 'listed_count'],
      type: 'object',
    },
    url: {
      description: "The URL specified in the User's profile.",
      type: 'string',
    },
    username: {
      $ref: '#/components/schemas/UserName',
    },
    verified: {
      description: 'Indicate if this User is a verified Twitter User.',
      type: 'boolean',
    },
    verified_type: {
      description: 'The Twitter Blue verified type of the user, eg: blue, government, business or none.',
      type: 'string',
    },
    withheld: {
      $ref: '#/components/schemas/UserWithheld',
    },
  },
  required: ['id', 'name', 'username'],
  type: 'object',
} as const;

export const UserComplianceDataSchema = {
  description: 'User compliance data.',
  oneOf: [
    {
      $ref: '#/components/schemas/UserProtectComplianceSchema',
    },
    {
      $ref: '#/components/schemas/UserUnprotectComplianceSchema',
    },
    {
      $ref: '#/components/schemas/UserDeleteComplianceSchema',
    },
    {
      $ref: '#/components/schemas/UserUndeleteComplianceSchema',
    },
    {
      $ref: '#/components/schemas/UserSuspendComplianceSchema',
    },
    {
      $ref: '#/components/schemas/UserUnsuspendComplianceSchema',
    },
    {
      $ref: '#/components/schemas/UserWithheldComplianceSchema',
    },
    {
      $ref: '#/components/schemas/UserScrubGeoSchema',
    },
    {
      $ref: '#/components/schemas/UserProfileModificationComplianceSchema',
    },
  ],
} as const;

export const UserComplianceSchemaSchema = {
  properties: {
    event_at: {
      description: 'Event time.',
      example: '2021-07-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    user: {
      properties: {
        id: {
          $ref: '#/components/schemas/UserId',
        },
      },
      required: ['id'],
      type: 'object',
    },
  },
  required: ['user', 'event_at'],
  type: 'object',
} as const;

export const UserComplianceStreamResponseSchema = {
  description: 'User compliance stream events.',
  oneOf: [
    {
      description: 'User compliance event.',
      properties: {
        data: {
          $ref: '#/components/schemas/UserComplianceData',
        },
      },
      required: ['data'],
      type: 'object',
    },
    {
      properties: {
        errors: {
          items: {
            $ref: '#/components/schemas/Problem',
          },
          minItems: 1,
          type: 'array',
        },
      },
      required: ['errors'],
      type: 'object',
    },
  ],
} as const;

export const UserDeleteComplianceSchemaSchema = {
  properties: {
    user_delete: {
      $ref: '#/components/schemas/UserComplianceSchema',
    },
  },
  required: ['user_delete'],
  type: 'object',
} as const;

export const UserIdSchema = {
  description:
    'Unique identifier of this User. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.',
  example: '2244994945',
  pattern: '^[0-9]{1,19}$',
  type: 'string',
} as const;

export const UserIdMatchesAuthenticatedUserSchema = {
  description: 'Unique identifier of this User. The value must be the same as the authenticated user.',
  example: '2244994945',
  type: 'string',
} as const;

export const UserNameSchema = {
  description: 'The Twitter handle (screen name) of this user.',
  pattern: '^[A-Za-z0-9_]{1,15}$',
  type: 'string',
} as const;

export const UserProfileModificationComplianceSchemaSchema = {
  properties: {
    user_profile_modification: {
      $ref: '#/components/schemas/UserProfileModificationObjectSchema',
    },
  },
  required: ['user_profile_modification'],
  type: 'object',
} as const;

export const UserProfileModificationObjectSchemaSchema = {
  properties: {
    event_at: {
      description: 'Event time.',
      example: '2021-07-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    new_value: {
      type: 'string',
    },
    profile_field: {
      type: 'string',
    },
    user: {
      properties: {
        id: {
          $ref: '#/components/schemas/UserId',
        },
      },
      required: ['id'],
      type: 'object',
    },
  },
  required: ['user', 'profile_field', 'new_value', 'event_at'],
  type: 'object',
} as const;

export const UserProtectComplianceSchemaSchema = {
  properties: {
    user_protect: {
      $ref: '#/components/schemas/UserComplianceSchema',
    },
  },
  required: ['user_protect'],
  type: 'object',
} as const;

export const UserScrubGeoObjectSchemaSchema = {
  properties: {
    event_at: {
      description: 'Event time.',
      example: '2021-07-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    up_to_tweet_id: {
      $ref: '#/components/schemas/TweetId',
    },
    user: {
      properties: {
        id: {
          $ref: '#/components/schemas/UserId',
        },
      },
      required: ['id'],
      type: 'object',
    },
  },
  required: ['user', 'up_to_tweet_id', 'event_at'],
  type: 'object',
} as const;

export const UserScrubGeoSchemaSchema = {
  properties: {
    scrub_geo: {
      $ref: '#/components/schemas/UserScrubGeoObjectSchema',
    },
  },
  required: ['scrub_geo'],
  type: 'object',
} as const;

export const UserSuspendComplianceSchemaSchema = {
  properties: {
    user_suspend: {
      $ref: '#/components/schemas/UserComplianceSchema',
    },
  },
  required: ['user_suspend'],
  type: 'object',
} as const;

export const UserTakedownComplianceSchemaSchema = {
  properties: {
    event_at: {
      description: 'Event time.',
      example: '2021-07-06T18:40:40.000Z',
      format: 'date-time',
      type: 'string',
    },
    user: {
      properties: {
        id: {
          $ref: '#/components/schemas/UserId',
        },
      },
      required: ['id'],
      type: 'object',
    },
    withheld_in_countries: {
      items: {
        $ref: '#/components/schemas/CountryCode',
      },
      minItems: 1,
      type: 'array',
    },
  },
  required: ['user', 'withheld_in_countries', 'event_at'],
  type: 'object',
} as const;

export const UserUndeleteComplianceSchemaSchema = {
  properties: {
    user_undelete: {
      $ref: '#/components/schemas/UserComplianceSchema',
    },
  },
  required: ['user_undelete'],
  type: 'object',
} as const;

export const UserUnprotectComplianceSchemaSchema = {
  properties: {
    user_unprotect: {
      $ref: '#/components/schemas/UserComplianceSchema',
    },
  },
  required: ['user_unprotect'],
  type: 'object',
} as const;

export const UserUnsuspendComplianceSchemaSchema = {
  properties: {
    user_unsuspend: {
      $ref: '#/components/schemas/UserComplianceSchema',
    },
  },
  required: ['user_unsuspend'],
  type: 'object',
} as const;

export const UserWithheldSchema = {
  description:
    'Indicates withholding details for [withheld content](https://help.twitter.com/en/rules-and-policies/tweet-withheld-by-country).',
  properties: {
    country_codes: {
      description: 'Provides a list of countries where this content is not available.',
      items: {
        $ref: '#/components/schemas/CountryCode',
      },
      minItems: 1,
      type: 'array',
      uniqueItems: true,
    },
    scope: {
      description: 'Indicates that the content being withheld is a `user`.',
      enum: ['user'],
      type: 'string',
    },
  },
  required: ['country_codes'],
  type: 'object',
} as const;

export const UserWithheldComplianceSchemaSchema = {
  properties: {
    user_withheld: {
      $ref: '#/components/schemas/UserTakedownComplianceSchema',
    },
  },
  required: ['user_withheld'],
  type: 'object',
} as const;

export const UsersFollowingCreateRequestSchema = {
  properties: {
    target_user_id: {
      $ref: '#/components/schemas/UserId',
    },
  },
  required: ['target_user_id'],
  type: 'object',
} as const;

export const UsersFollowingCreateResponseSchema = {
  properties: {
    data: {
      properties: {
        following: {
          type: 'boolean',
        },
        pending_follow: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const UsersFollowingDeleteResponseSchema = {
  properties: {
    data: {
      properties: {
        following: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const UsersLikesCreateRequestSchema = {
  properties: {
    tweet_id: {
      $ref: '#/components/schemas/TweetId',
    },
  },
  required: ['tweet_id'],
  type: 'object',
} as const;

export const UsersLikesCreateResponseSchema = {
  properties: {
    data: {
      properties: {
        liked: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const UsersLikesDeleteResponseSchema = {
  properties: {
    data: {
      properties: {
        liked: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const UsersRetweetsCreateRequestSchema = {
  properties: {
    tweet_id: {
      $ref: '#/components/schemas/TweetId',
    },
  },
  required: ['tweet_id'],
  type: 'object',
} as const;

export const UsersRetweetsCreateResponseSchema = {
  properties: {
    data: {
      properties: {
        retweeted: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const UsersRetweetsDeleteResponseSchema = {
  properties: {
    data: {
      properties: {
        retweeted: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    errors: {
      items: {
        $ref: '#/components/schemas/Problem',
      },
      minItems: 1,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const VariantSchema = {
  properties: {
    bit_rate: {
      description: 'The bit rate of the media.',
      type: 'integer',
    },
    content_type: {
      description: 'The content type of the media.',
      type: 'string',
    },
    url: {
      description: 'The url to the media.',
      format: 'uri',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const VariantsSchema = {
  description: 'An array of all available variants of the media.',
  items: {
    $ref: '#/components/schemas/Variant',
  },
  type: 'array',
} as const;

export const VideoSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/Media',
    },
    {
      properties: {
        duration_ms: {
          type: 'integer',
        },
        non_public_metrics: {
          description: 'Nonpublic engagement metrics for the Media at the time of the request.',
          properties: {
            playback_0_count: {
              description: 'Number of users who made it through 0% of the video.',
              format: 'int32',
              type: 'integer',
            },
            playback_100_count: {
              description: 'Number of users who made it through 100% of the video.',
              format: 'int32',
              type: 'integer',
            },
            playback_25_count: {
              description: 'Number of users who made it through 25% of the video.',
              format: 'int32',
              type: 'integer',
            },
            playback_50_count: {
              description: 'Number of users who made it through 50% of the video.',
              format: 'int32',
              type: 'integer',
            },
            playback_75_count: {
              description: 'Number of users who made it through 75% of the video.',
              format: 'int32',
              type: 'integer',
            },
          },
          type: 'object',
        },
        organic_metrics: {
          description: 'Organic nonpublic engagement metrics for the Media at the time of the request.',
          properties: {
            playback_0_count: {
              description: 'Number of users who made it through 0% of the video.',
              format: 'int32',
              type: 'integer',
            },
            playback_100_count: {
              description: 'Number of users who made it through 100% of the video.',
              format: 'int32',
              type: 'integer',
            },
            playback_25_count: {
              description: 'Number of users who made it through 25% of the video.',
              format: 'int32',
              type: 'integer',
            },
            playback_50_count: {
              description: 'Number of users who made it through 50% of the video.',
              format: 'int32',
              type: 'integer',
            },
            playback_75_count: {
              description: 'Number of users who made it through 75% of the video.',
              format: 'int32',
              type: 'integer',
            },
            view_count: {
              description: 'Number of times this video has been viewed.',
              format: 'int32',
              type: 'integer',
            },
          },
          type: 'object',
        },
        preview_image_url: {
          format: 'uri',
          type: 'string',
        },
        promoted_metrics: {
          description: 'Promoted nonpublic engagement metrics for the Media at the time of the request.',
          properties: {
            playback_0_count: {
              description: 'Number of users who made it through 0% of the video.',
              format: 'int32',
              type: 'integer',
            },
            playback_100_count: {
              description: 'Number of users who made it through 100% of the video.',
              format: 'int32',
              type: 'integer',
            },
            playback_25_count: {
              description: 'Number of users who made it through 25% of the video.',
              format: 'int32',
              type: 'integer',
            },
            playback_50_count: {
              description: 'Number of users who made it through 50% of the video.',
              format: 'int32',
              type: 'integer',
            },
            playback_75_count: {
              description: 'Number of users who made it through 75% of the video.',
              format: 'int32',
              type: 'integer',
            },
            view_count: {
              description: 'Number of times this video has been viewed.',
              format: 'int32',
              type: 'integer',
            },
          },
          type: 'object',
        },
        public_metrics: {
          description: 'Engagement metrics for the Media at the time of the request.',
          properties: {
            view_count: {
              description: 'Number of times this video has been viewed.',
              format: 'int32',
              type: 'integer',
            },
          },
          type: 'object',
        },
        variants: {
          $ref: '#/components/schemas/Variants',
        },
      },
      type: 'object',
    },
  ],
} as const;
