// Generated by ts-to-zod
import { z } from 'zod';

import { type EdgeConfigItemValue, type FileTree } from './types.gen';

export const aCLActionSchema = z.union([
  z.literal('create'),
  z.literal('delete'),
  z.literal('read'),
  z.literal('update'),
  z.literal('list'),
  z.literal('count'),
]);

export const authTokenSchema = z.object({
  activeAt: z.number(),
  createdAt: z.number(),
  expiresAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  origin: z.string().optional(),
  scopes: z
    .array(
      z.union([
        z.object({
          createdAt: z.number(),
          expiresAt: z.number().optional(),
          origin: z.union([
            z.literal('saml'),
            z.literal('github'),
            z.literal('gitlab'),
            z.literal('bitbucket'),
            z.literal('email'),
            z.literal('manual'),
          ]),
          type: z.literal('user'),
        }),
        z.object({
          createdAt: z.number(),
          expiresAt: z.number().optional(),
          origin: z.union([
            z.literal('saml'),
            z.literal('github'),
            z.literal('gitlab'),
            z.literal('bitbucket'),
            z.literal('email'),
            z.literal('manual'),
          ]),
          teamId: z.string(),
          type: z.literal('team'),
        }),
      ]),
    )
    .optional(),
  type: z.string(),
});

export const authUserSchema = z.object({
  activeDashboardViews: z
    .array(
      z.object({
        scopeId: z.string(),
        viewPreference: z.union([z.literal('cards'), z.literal('list')]),
      }),
    )
    .optional(),
  avatar: z.string().nullable(),
  billing: z
    .object({
      addons: z
        .array(z.union([z.literal('custom-deployment-suffix'), z.literal('live-support')]))
        .optional()
        .nullable(),
      address: z
        .object({
          city: z.string().optional(),
          country: z.string().optional(),
          line1: z.string(),
          line2: z.string().optional(),
          postalCode: z.string().optional(),
          state: z.string().optional(),
        })
        .optional()
        .nullable(),
      cancelation: z.number().optional().nullable(),
      contract: z
        .object({
          end: z.number(),
          start: z.number(),
        })
        .optional()
        .nullable(),
      controls: z
        .object({
          analyticsSampleRateInPercent: z.number().optional().nullable(),
          analyticsSpendLimitInDollars: z.number().optional().nullable(),
        })
        .optional()
        .nullable(),
      currency: z.union([z.literal('usd'), z.literal('eur')]).optional(),
      email: z.string().optional().nullable(),
      invoiceItems: z
        .object({
          analytics: z
            .object({
              createdAt: z.number().optional(),
              disabledAt: z.number().optional().nullable(),
              frequency: z
                .object({
                  interval: z.literal('month'),
                  intervalCount: z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]),
                })
                .optional(),
              hidden: z.boolean(),
              maxQuantity: z.number().optional(),
              name: z.string().optional(),
              price: z.number(),
              quantity: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          analyticsUsage: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          artifacts: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          bandwidth: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          builds: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          concurrentBuilds: z
            .object({
              createdAt: z.number().optional(),
              disabledAt: z.number().optional().nullable(),
              frequency: z
                .object({
                  interval: z.literal('month'),
                  intervalCount: z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]),
                })
                .optional(),
              hidden: z.boolean(),
              maxQuantity: z.number().optional(),
              name: z.string().optional(),
              price: z.number(),
              quantity: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          cronJobInvocation: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          customCerts: z
            .object({
              createdAt: z.number().optional(),
              disabledAt: z.number().optional().nullable(),
              frequency: z
                .object({
                  interval: z.literal('month'),
                  intervalCount: z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]),
                })
                .optional(),
              hidden: z.boolean(),
              maxQuantity: z.number().optional(),
              name: z.string().optional(),
              price: z.number(),
              quantity: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          edgeConfigRead: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          edgeConfigWrite: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          edgeFunctionExecutionUnits: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          edgeMiddlewareInvocations: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          enterprise: z
            .object({
              createdAt: z.number().optional(),
              disabledAt: z.number().optional().nullable(),
              frequency: z
                .object({
                  interval: z.literal('month'),
                  intervalCount: z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]),
                })
                .optional(),
              hidden: z.boolean(),
              maxQuantity: z.number().optional(),
              name: z.string().optional(),
              price: z.number(),
              quantity: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          monitoring: z
            .object({
              createdAt: z.number().optional(),
              disabledAt: z.number().optional().nullable(),
              frequency: z
                .object({
                  interval: z.literal('month'),
                  intervalCount: z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]),
                })
                .optional(),
              hidden: z.boolean(),
              maxQuantity: z.number().optional(),
              name: z.string().optional(),
              price: z.number(),
              quantity: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          monitoringMetric: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          passwordProtection: z
            .object({
              createdAt: z.number().optional(),
              disabledAt: z.number().optional().nullable(),
              frequency: z
                .object({
                  interval: z.literal('month'),
                  intervalCount: z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]),
                })
                .optional(),
              hidden: z.boolean(),
              maxQuantity: z.number().optional(),
              name: z.string().optional(),
              price: z.number(),
              quantity: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          previewDeploymentSuffix: z
            .object({
              createdAt: z.number().optional(),
              disabledAt: z.number().optional().nullable(),
              frequency: z
                .object({
                  interval: z.literal('month'),
                  intervalCount: z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]),
                })
                .optional(),
              hidden: z.boolean(),
              maxQuantity: z.number().optional(),
              name: z.string().optional(),
              price: z.number(),
              quantity: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          pro: z
            .object({
              createdAt: z.number().optional(),
              disabledAt: z.number().optional().nullable(),
              frequency: z
                .object({
                  interval: z.literal('month'),
                  intervalCount: z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]),
                })
                .optional(),
              hidden: z.boolean(),
              maxQuantity: z.number().optional(),
              name: z.string().optional(),
              price: z.number(),
              quantity: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          saml: z
            .object({
              createdAt: z.number().optional(),
              disabledAt: z.number().optional().nullable(),
              frequency: z
                .object({
                  interval: z.literal('month'),
                  intervalCount: z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]),
                })
                .optional(),
              hidden: z.boolean(),
              maxQuantity: z.number().optional(),
              name: z.string().optional(),
              price: z.number(),
              quantity: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          serverlessFunctionExecution: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          sourceImages: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          ssoProtection: z
            .object({
              createdAt: z.number().optional(),
              disabledAt: z.number().optional().nullable(),
              frequency: z
                .object({
                  interval: z.literal('month'),
                  intervalCount: z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]),
                })
                .optional(),
              hidden: z.boolean(),
              maxQuantity: z.number().optional(),
              name: z.string().optional(),
              price: z.number(),
              quantity: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          teamSeats: z
            .object({
              createdAt: z.number().optional(),
              disabledAt: z.number().optional().nullable(),
              frequency: z
                .object({
                  interval: z.literal('month'),
                  intervalCount: z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]),
                })
                .optional(),
              hidden: z.boolean(),
              maxQuantity: z.number().optional(),
              name: z.string().optional(),
              price: z.number(),
              quantity: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          webAnalytics: z
            .object({
              createdAt: z.number().optional(),
              disabledAt: z.number().optional().nullable(),
              frequency: z
                .object({
                  interval: z.literal('month'),
                  intervalCount: z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]),
                })
                .optional(),
              hidden: z.boolean(),
              maxQuantity: z.number().optional(),
              name: z.string().optional(),
              price: z.number(),
              quantity: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
          webAnalyticsEvent: z
            .object({
              batch: z.number(),
              disabledAt: z.number().optional().nullable(),
              hidden: z.boolean(),
              name: z.string().optional(),
              price: z.number(),
              threshold: z.number(),
              tier: z.number().optional(),
            })
            .optional(),
        })
        .optional()
        .nullable(),
      invoiceSettings: z
        .object({
          footer: z.string().optional(),
        })
        .optional(),
      language: z.string().optional().nullable(),
      name: z.string().optional().nullable(),
      orbCustomerId: z.string().optional(),
      overdue: z.boolean().optional().nullable(),
      period: z
        .object({
          end: z.number(),
          start: z.number(),
        })
        .nullable(),
      plan: z.union([z.literal('hobby'), z.literal('enterprise'), z.literal('pro')]),
      platform: z.union([z.literal('stripe'), z.literal('stripeTestMode')]).optional(),
      pricingExperiment: z.literal('august-2022').optional(),
      programType: z.union([z.literal('startup'), z.literal('agency')]).optional(),
      purchaseOrder: z.string().optional().nullable(),
      status: z
        .union([
          z.literal('active'),
          z.literal('canceled'),
          z.literal('trialing'),
          z.literal('overdue'),
          z.literal('expired'),
        ])
        .optional(),
      subscriptions: z
        .array(
          z.object({
            discount: z
              .object({
                coupon: z.object({
                  amountOff: z.number().nullable(),
                  duration: z.union([z.literal('forever'), z.literal('repeating'), z.literal('once')]),
                  durationInMonths: z.number().nullable(),
                  id: z.string(),
                  name: z.string().nullable(),
                  percentageOff: z.number().nullable(),
                }),
                id: z.string(),
              })
              .nullable(),
            frequency: z.object({
              interval: z.union([z.literal('month'), z.literal('day'), z.literal('week'), z.literal('year')]),
              intervalCount: z.number(),
            }),
            id: z.string(),
            items: z.array(
              z.object({
                amount: z.number(),
                id: z.string(),
                priceId: z.string(),
                productId: z.string(),
                quantity: z.number(),
              }),
            ),
            period: z.object({
              end: z.number(),
              start: z.number(),
            }),
            trial: z
              .object({
                end: z.number(),
                start: z.number(),
              })
              .nullable(),
          }),
        )
        .optional()
        .nullable(),
      tax: z
        .object({
          id: z.string(),
          type: z.string(),
        })
        .optional()
        .nullable(),
      trial: z
        .object({
          end: z.number(),
          start: z.number(),
        })
        .optional()
        .nullable(),
    })
    .nullable(),
  createdAt: z.number(),
  dismissedToasts: z
    .array(
      z.object({
        dismissals: z.array(
          z.object({
            createdAt: z.number(),
            scopeId: z.string(),
          }),
        ),
        name: z.string(),
      }),
    )
    .optional(),
  email: z.string(),
  favoriteProjects: z
    .array(
      z.object({
        projectId: z.string(),
        scopeId: z.string(),
        scopeSlug: z.string(),
      }),
    )
    .optional(),
  hasTrialAvailable: z.boolean(),
  id: z.string(),
  importFlowGitNamespace: z.union([z.string(), z.number()]).optional().nullable(),
  importFlowGitNamespaceId: z.union([z.string(), z.number()]).optional().nullable(),
  importFlowGitProvider: z.union([z.literal('github'), z.literal('gitlab'), z.literal('bitbucket')]).optional(),
  name: z.string().nullable(),
  preferredScopesAndGitNamespaces: z
    .array(
      z.object({
        gitNamespaceId: z.union([z.string(), z.number()]).nullable(),
        scopeId: z.string(),
      }),
    )
    .optional(),
  remoteCaching: z
    .object({
      enabled: z.boolean().optional(),
    })
    .optional(),
  resourceConfig: z.object({
    awsAccountIds: z.array(z.string()).optional(),
    awsAccountType: z.string().optional(),
    cfZoneName: z.string().optional(),
    concurrentBuilds: z.number().optional(),
    edgeConfigSize: z.number().optional(),
    edgeConfigs: z.number().optional(),
    nodeType: z.string().optional(),
  }),
  softBlock: z
    .object({
      blockedAt: z.number(),
      reason: z.union([
        z.literal('FAIR_USE_LIMITS_EXCEEDED'),
        z.literal('ENTERPRISE_TRIAL_ENDED'),
        z.literal('BLOCKED_FOR_PLATFORM_ABUSE'),
        z.literal('UNPAID_INVOICE'),
        z.literal('SUBSCRIPTION_EXPIRED'),
        z.literal('SUBSCRIPTION_CANCELED'),
      ]),
    })
    .nullable(),
  stagingPrefix: z.string(),
  username: z.string(),
});

export const currencySchema = z.union([z.literal('usd'), z.literal('eur')]);

export const intervalSchema = z.literal('month');

export const intervalCountSchema = z.union([z.literal(1), z.literal(3), z.literal(2), z.literal(6), z.literal(12)]);

export const planSchema = z.union([z.literal('hobby'), z.literal('enterprise'), z.literal('pro')]);

export const platformSchema = z.union([z.literal('stripe'), z.literal('stripeTestMode')]);

export const pricingExperimentSchema = z.literal('august-2022');

export const programTypeSchema = z.union([z.literal('startup'), z.literal('agency')]);

export const statusSchema = z.union([
  z.literal('active'),
  z.literal('canceled'),
  z.literal('trialing'),
  z.literal('overdue'),
  z.literal('expired'),
]);

export const importFlowGitProviderSchema = z.union([z.literal('github'), z.literal('gitlab'), z.literal('bitbucket')]);

export const reasonSchema = z.union([
  z.literal('FAIR_USE_LIMITS_EXCEEDED'),
  z.literal('ENTERPRISE_TRIAL_ENDED'),
  z.literal('BLOCKED_FOR_PLATFORM_ABUSE'),
  z.literal('UNPAID_INVOICE'),
  z.literal('SUBSCRIPTION_EXPIRED'),
  z.literal('SUBSCRIPTION_CANCELED'),
]);

export const authUserLimitedSchema = z.object({
  avatar: z.string().nullable(),
  email: z.string(),
  id: z.string(),
  limited: z.boolean(),
  name: z.string().nullable(),
  username: z.string(),
});

export const edgeConfigItemValueSchema: z.ZodSchema<EdgeConfigItemValue> = z.lazy(() =>
  z.union([z.string(), z.number(), z.boolean(), z.record(z.unknown()), z.array(edgeConfigItemValueSchema)]).nullable(),
);

export const edgeConfigTokenSchema = z.object({
  createdAt: z.number(),
  edgeConfigId: z.string(),
  id: z.string(),
  label: z.string(),
  token: z.string(),
});

export const fileTreeSchema: z.ZodSchema<FileTree> = z.lazy(() =>
  z.object({
    children: z.array(fileTreeSchema).optional(),
    contentType: z.string().optional(),
    mode: z.number(),
    name: z.string(),
    symlink: z.string().optional(),
    type: z.union([
      z.literal('directory'),
      z.literal('file'),
      z.literal('symlink'),
      z.literal('lambda'),
      z.literal('middleware'),
      z.literal('invalid'),
    ]),
    uid: z.string().optional(),
  }),
);

export const typeSchema = z.union([
  z.literal('directory'),
  z.literal('file'),
  z.literal('symlink'),
  z.literal('lambda'),
  z.literal('middleware'),
  z.literal('invalid'),
]);

export const paginationSchema = z.object({
  count: z.number(),
  next: z.number().nullable(),
  prev: z.number().nullable(),
});

export const teamSchema = z.record(z.unknown());

export const teamLimitedSchema = z.object({
  avatar: z.string().nullable(),
  created: z.string(),
  createdAt: z.number(),
  id: z.string(),
  limited: z.boolean(),
  membership: z.union([
    z.object({
      accessRequestedAt: z.number().optional(),
      confirmed: z.boolean(),
      confirmedAt: z.number(),
      created: z.number(),
      createdAt: z.number(),
      joinedFrom: z
        .object({
          commitId: z.string().optional(),
          dsyncConnectedAt: z.number().optional(),
          dsyncUserId: z.string().optional(),
          gitUserId: z.union([z.string(), z.number()]).optional(),
          gitUserLogin: z.string().optional(),
          idpUserId: z.string().optional(),
          origin: z.union([
            z.literal('import'),
            z.literal('saml'),
            z.literal('mail'),
            z.literal('link'),
            z.literal('teams'),
            z.literal('github'),
            z.literal('gitlab'),
            z.literal('bitbucket'),
            z.literal('dsync'),
            z.literal('feedback'),
            z.literal('organization-teams'),
          ]),
          repoId: z.string().optional(),
          repoPath: z.string().optional(),
          ssoConnectedAt: z.number().optional(),
          ssoUserId: z.string().optional(),
        })
        .optional(),
      role: z.union([
        z.literal('MEMBER'),
        z.literal('OWNER'),
        z.literal('VIEWER'),
        z.literal('DEVELOPER'),
        z.literal('BILLING'),
      ]),
      teamId: z.string().optional(),
      uid: z.string(),
    }),
    z.object({
      accessRequestedAt: z.number(),
      confirmed: z.boolean(),
      confirmedAt: z.number().optional(),
      created: z.number(),
      createdAt: z.number(),
      joinedFrom: z
        .object({
          commitId: z.string().optional(),
          dsyncConnectedAt: z.number().optional(),
          dsyncUserId: z.string().optional(),
          gitUserId: z.union([z.string(), z.number()]).optional(),
          gitUserLogin: z.string().optional(),
          idpUserId: z.string().optional(),
          origin: z.union([
            z.literal('import'),
            z.literal('saml'),
            z.literal('mail'),
            z.literal('link'),
            z.literal('teams'),
            z.literal('github'),
            z.literal('gitlab'),
            z.literal('bitbucket'),
            z.literal('dsync'),
            z.literal('feedback'),
            z.literal('organization-teams'),
          ]),
          repoId: z.string().optional(),
          repoPath: z.string().optional(),
          ssoConnectedAt: z.number().optional(),
          ssoUserId: z.string().optional(),
        })
        .optional(),
      role: z.union([
        z.literal('MEMBER'),
        z.literal('OWNER'),
        z.literal('VIEWER'),
        z.literal('DEVELOPER'),
        z.literal('BILLING'),
      ]),
      teamId: z.string().optional(),
      uid: z.string(),
    }),
  ]),
  name: z.string().nullable(),
  saml: z
    .object({
      connection: z
        .object({
          createdAt: z.number().optional().nullable(),
          creator: z.string(),
          domain: z.string(),
          id: z.string(),
          name: z.string(),
          recordType: z.union([
            z.literal('A'),
            z.literal('AAAA'),
            z.literal('ALIAS'),
            z.literal('CAA'),
            z.literal('CNAME'),
            z.literal('MX'),
            z.literal('SRV'),
            z.literal('TXT'),
            z.literal('NS'),
          ]),
          ttl: z.number().optional(),
          type: z.union([z.literal('record'), z.literal('record-sys')]),
          value: z.string(),
        })
        .optional(),
      directory: z
        .object({
          createdAt: z.number().optional().nullable(),
          creator: z.string(),
          domain: z.string(),
          id: z.string(),
          name: z.string(),
          recordType: z.union([
            z.literal('A'),
            z.literal('AAAA'),
            z.literal('ALIAS'),
            z.literal('CAA'),
            z.literal('CNAME'),
            z.literal('MX'),
            z.literal('SRV'),
            z.literal('TXT'),
            z.literal('NS'),
          ]),
          ttl: z.number().optional(),
          type: z.union([z.literal('record'), z.literal('record-sys')]),
          value: z.string(),
        })
        .optional(),
      enforced: z.boolean(),
    })
    .optional(),
  slug: z.string(),
});

export const originSchema = z.union([
  z.literal('import'),
  z.literal('saml'),
  z.literal('mail'),
  z.literal('link'),
  z.literal('teams'),
  z.literal('github'),
  z.literal('gitlab'),
  z.literal('bitbucket'),
  z.literal('dsync'),
  z.literal('feedback'),
  z.literal('organization-teams'),
]);

export const roleSchema = z.union([
  z.literal('MEMBER'),
  z.literal('OWNER'),
  z.literal('VIEWER'),
  z.literal('DEVELOPER'),
  z.literal('BILLING'),
]);

export const recordTypeSchema = z.union([
  z.literal('A'),
  z.literal('AAAA'),
  z.literal('ALIAS'),
  z.literal('CAA'),
  z.literal('CNAME'),
  z.literal('MX'),
  z.literal('SRV'),
  z.literal('TXT'),
  z.literal('NS'),
]);

export const type2Schema = z.union([z.literal('record'), z.literal('record-sys')]);

export const userEventSchema = z.object({
  createdAt: z.number(),
  entities: z.array(
    z.object({
      end: z.number(),
      start: z.number(),
      type: z.union([
        z.literal('target'),
        z.literal('author'),
        z.literal('bitbucket_login'),
        z.literal('bold'),
        z.literal('deployment_host'),
        z.literal('dns_record'),
        z.literal('git_link'),
        z.literal('github_login'),
        z.literal('gitlab_login'),
        z.literal('hook_name'),
        z.literal('integration'),
        z.literal('edge-config'),
        z.literal('link'),
        z.literal('project_name'),
        z.literal('scaling_rules'),
        z.literal('env_var_name'),
        z.literal('system'),
      ]),
    }),
  ),
  id: z.string(),
  text: z.string(),
  user: z
    .object({
      avatar: z.string(),
      email: z.string(),
      slug: z.string().optional(),
      uid: z.string(),
      username: z.string(),
    })
    .optional(),
  userId: z.string(),
});

export const emailLoginDataSchema = z.object({
  body: z
    .object({
      email: z.string(),
      tokenName: z.string().optional(),
    })
    .optional(),
});

export const emailLoginResponseSchema = z.object({
  securityCode: z.string(),
  token: z.string(),
});

export const emailLoginErrorSchema = z.unknown();

export const verifyTokenDataSchema = z.object({
  query: z.object({
    email: z.string().optional(),
    ssoUserId: z.string().optional(),
    token: z.string(),
    tokenName: z.string().optional(),
  }),
});

export const verifyTokenResponseSchema = z.object({
  email: z.string(),
  teamId: z.string().optional(),
  token: z.string(),
});

export const verifyTokenErrorSchema = z.unknown();

export const getAllChecksDataSchema = z.object({
  path: z.object({
    deploymentId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getAllChecksResponseSchema = z.object({
  checks: z.array(
    z.object({
      completedAt: z.number().optional(),
      conclusion: z
        .union([
          z.literal('canceled'),
          z.literal('failed'),
          z.literal('neutral'),
          z.literal('succeeded'),
          z.literal('skipped'),
          z.literal('stale'),
        ])
        .optional(),
      createdAt: z.number(),
      detailsUrl: z.string().optional(),
      id: z.string(),
      integrationId: z.string(),
      name: z.string(),
      output: z
        .object({
          metrics: z
            .object({
              CLS: z.object({
                previousValue: z.number().optional(),
                source: z.literal('web-vitals'),
                value: z.number().nullable(),
              }),
              FCP: z.object({
                previousValue: z.number().optional(),
                source: z.literal('web-vitals'),
                value: z.number().nullable(),
              }),
              LCP: z.object({
                previousValue: z.number().optional(),
                source: z.literal('web-vitals'),
                value: z.number().nullable(),
              }),
              TBT: z.object({
                previousValue: z.number().optional(),
                source: z.literal('web-vitals'),
                value: z.number().nullable(),
              }),
              virtualExperienceScore: z
                .object({
                  previousValue: z.number().optional(),
                  source: z.literal('web-vitals'),
                  value: z.number().nullable(),
                })
                .optional(),
            })
            .optional(),
        })
        .optional(),
      path: z.string().optional(),
      rerequestable: z.boolean(),
      startedAt: z.number().optional(),
      status: z.union([z.literal('registered'), z.literal('running'), z.literal('completed')]),
      updatedAt: z.number(),
    }),
  ),
});

export const getAllChecksErrorSchema = z.unknown();

export const createCheckDataSchema = z.object({
  body: z
    .object({
      blocking: z.boolean(),
      detailsUrl: z.string().optional(),
      externalId: z.string().optional(),
      name: z.string(),
      path: z.string().optional(),
      rerequestable: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    deploymentId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const createCheckResponseSchema = z.object({
  connectedAt: z.number(),
  lastReceivedWebhookEvent: z.number().optional(),
  state: z.string(),
  status: z.string(),
  type: z.string(),
});

export const createCheckErrorSchema = z.unknown();

export const getCheckDataSchema = z.object({
  path: z.object({
    checkId: z.string(),
    deploymentId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getCheckResponseSchema = z.object({
  createdAt: z.number().optional().nullable(),
  creator: z.string(),
  domain: z.string(),
  id: z.string(),
  name: z.string(),
  recordType: z.union([
    z.literal('A'),
    z.literal('AAAA'),
    z.literal('ALIAS'),
    z.literal('CAA'),
    z.literal('CNAME'),
    z.literal('MX'),
    z.literal('SRV'),
    z.literal('TXT'),
    z.literal('NS'),
  ]),
  ttl: z.number().optional(),
  type: z.union([z.literal('record'), z.literal('record-sys')]),
  value: z.string(),
});

export const getCheckErrorSchema = z.unknown();

export const updateCheckDataSchema = z.object({
  body: z
    .object({
      conclusion: z
        .union([
          z.literal('canceled'),
          z.literal('failed'),
          z.literal('neutral'),
          z.literal('succeeded'),
          z.literal('skipped'),
        ])
        .optional(),
      detailsUrl: z.string().optional(),
      externalId: z.string().optional(),
      name: z.string().optional(),
      output: z
        .object({
          metrics: z
            .object({
              CLS: z.object({
                previousValue: z.number().optional(),
                source: z.literal('web-vitals'),
                value: z.number().nullable(),
              }),
              FCP: z.object({
                previousValue: z.number().optional(),
                source: z.literal('web-vitals'),
                value: z.number().nullable(),
              }),
              LCP: z.object({
                previousValue: z.number().optional(),
                source: z.literal('web-vitals'),
                value: z.number().nullable(),
              }),
              TBT: z.object({
                previousValue: z.number().optional(),
                source: z.literal('web-vitals'),
                value: z.number().nullable(),
              }),
              virtualExperienceScore: z
                .object({
                  previousValue: z.number().optional(),
                  source: z.literal('web-vitals'),
                  value: z.number().nullable(),
                })
                .optional(),
            })
            .optional(),
        })
        .optional(),
      path: z.string().optional(),
      status: z.union([z.literal('running'), z.literal('completed')]).optional(),
    })
    .optional(),
  path: z.object({
    checkId: z.string(),
    deploymentId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const updateCheckResponseSchema = z.object({
  connectedAt: z.number(),
  lastReceivedWebhookEvent: z.number().optional(),
  state: z.string(),
  status: z.string(),
  type: z.string(),
});

export const updateCheckErrorSchema = z.unknown();

export const rerequestCheckDataSchema = z.object({
  path: z.object({
    checkId: z.string(),
    deploymentId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const rerequestCheckResponseSchema = z.record(z.unknown());

export const rerequestCheckErrorSchema = z.unknown();

export const updateRecordDataSchema = z.object({
  body: z
    .object({
      additionalProperties: z.unknown().optional(),
      mxPriority: z.number().optional().nullable(),
      name: z.string().optional().nullable(),
      srv: z
        .object({
          port: z.number().nullable(),
          priority: z.number().nullable(),
          target: z.string().nullable(),
          weight: z.number().nullable(),
        })
        .optional()
        .nullable(),
      ttl: z.number().optional().nullable(),
      type: z
        .union([
          z.literal('A'),
          z.literal('AAAA'),
          z.literal('ALIAS'),
          z.literal('CAA'),
          z.literal('CNAME'),
          z.literal('MX'),
          z.literal('SRV'),
          z.literal('TXT'),
          z.literal('NS'),
        ])
        .optional()
        .nullable(),
      value: z.string().optional().nullable(),
    })
    .optional(),
  path: z.object({
    recordId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const updateRecordResponseSchema = z.object({
  createdAt: z.number().optional().nullable(),
  creator: z.string(),
  domain: z.string(),
  id: z.string(),
  name: z.string(),
  recordType: z.union([
    z.literal('A'),
    z.literal('AAAA'),
    z.literal('ALIAS'),
    z.literal('CAA'),
    z.literal('CNAME'),
    z.literal('MX'),
    z.literal('SRV'),
    z.literal('TXT'),
    z.literal('NS'),
  ]),
  ttl: z.number().optional(),
  type: z.union([z.literal('record'), z.literal('record-sys')]),
  value: z.string(),
});

export const updateRecordErrorSchema = z.unknown();

export const getEdgeConfigsDataSchema = z.object({
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getEdgeConfigsResponseSchema = z.object({
  createdAt: z.number().optional().nullable(),
  creator: z.string().optional(),
  domain: z.string().optional(),
  id: z.string().optional(),
  itemCount: z.number(),
  name: z.string().optional(),
  recordType: z
    .union([
      z.literal('A'),
      z.literal('AAAA'),
      z.literal('ALIAS'),
      z.literal('CAA'),
      z.literal('CNAME'),
      z.literal('MX'),
      z.literal('SRV'),
      z.literal('TXT'),
      z.literal('NS'),
    ])
    .optional(),
  sizeInBytes: z.number(),
  ttl: z.number().optional(),
  type: z.union([z.literal('record'), z.literal('record-sys')]).optional(),
  value: z.string().optional(),
});

export const getEdgeConfigsErrorSchema = z.unknown();

export const createEdgeConfigDataSchema = z.object({
  body: z
    .object({
      items: z
        .record(
          z.union([
            z.union([z.string(), z.number(), z.boolean(), z.record(z.unknown())]).nullable(),
            z.array(z.union([z.string(), z.number(), z.boolean(), z.record(z.unknown())]).nullable()),
          ]),
        )
        .optional(),
      slug: z.string(),
    })
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const createEdgeConfigResponseSchema = z.object({
  connectedAt: z.number().optional(),
  itemCount: z.number(),
  lastReceivedWebhookEvent: z.number().optional(),
  sizeInBytes: z.number(),
  state: z.string().optional(),
  status: z.string().optional(),
  type: z.string().optional(),
});

export const createEdgeConfigErrorSchema = z.unknown();

export const deleteEdgeConfigDataSchema = z.object({
  path: z.object({
    edgeConfigId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const deleteEdgeConfigResponseSchema = z.any();

export const deleteEdgeConfigErrorSchema = z.unknown();

export const getEdgeConfigDataSchema = z.object({
  path: z.object({
    edgeConfigId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getEdgeConfigResponseSchema = z.object({
  createdAt: z.number().optional().nullable(),
  creator: z.string().optional(),
  domain: z.string().optional(),
  id: z.string().optional(),
  itemCount: z.number(),
  name: z.string().optional(),
  recordType: z
    .union([
      z.literal('A'),
      z.literal('AAAA'),
      z.literal('ALIAS'),
      z.literal('CAA'),
      z.literal('CNAME'),
      z.literal('MX'),
      z.literal('SRV'),
      z.literal('TXT'),
      z.literal('NS'),
    ])
    .optional(),
  sizeInBytes: z.number(),
  ttl: z.number().optional(),
  type: z.union([z.literal('record'), z.literal('record-sys')]).optional(),
  value: z.string().optional(),
});

export const getEdgeConfigErrorSchema = z.unknown();

export const updateEdgeConfigDataSchema = z.object({
  body: z
    .object({
      slug: z.string(),
    })
    .optional(),
  path: z.object({
    edgeConfigId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const updateEdgeConfigResponseSchema = z.object({
  connectedAt: z.number().optional(),
  itemCount: z.number(),
  lastReceivedWebhookEvent: z.number().optional(),
  sizeInBytes: z.number(),
  state: z.string().optional(),
  status: z.string().optional(),
  type: z.string().optional(),
});

export const updateEdgeConfigErrorSchema = z.unknown();

export const getEdgeConfigItemDataSchema = z.object({
  path: z.object({
    edgeConfigId: z.string(),
    edgeConfigItemKey: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const edgeConfigItemSchema = z.object({
  createdAt: z.number(),
  edgeConfigId: z.string(),
  key: z.string(),
  updatedAt: z.number(),
  value: edgeConfigItemValueSchema,
});

export const getEdgeConfigItemErrorSchema = z.unknown();

export const getEdgeConfigItemsDataSchema = z.object({
  path: z.object({
    edgeConfigId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getEdgeConfigItemsResponseSchema = edgeConfigItemSchema;

export const getEdgeConfigItemsErrorSchema = z.unknown();

export const patchtEdgeConfigItemsDataSchema = z.object({
  body: z
    .object({
      items: z.array(
        z.union([
          z.object({
            key: z.string(),
            operation: z.union([z.literal('create'), z.literal('update'), z.literal('upsert')]),
            value: z.union([
              z.union([z.string(), z.number(), z.boolean(), z.record(z.unknown())]).nullable(),
              z.array(z.union([z.string(), z.number(), z.boolean(), z.record(z.unknown())]).nullable()),
            ]),
          }),
          z.object({
            key: z.string(),
            operation: z.literal('delete'),
          }),
        ]),
      ),
    })
    .optional(),
  path: z.object({
    edgeConfigId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const patchtEdgeConfigItemsResponseSchema = z.object({
  status: z.string(),
});

export const patchtEdgeConfigItemsErrorSchema = z.unknown();

export const createEdgeConfigTokenDataSchema = z.object({
  body: z
    .object({
      label: z.string(),
    })
    .optional(),
  path: z.object({
    edgeConfigId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const createEdgeConfigTokenResponseSchema = z.object({
  id: z.string(),
  token: z.string(),
});

export const createEdgeConfigTokenErrorSchema = z.unknown();

export const getEdgeConfigTokenDataSchema = z.object({
  path: z.object({
    edgeConfigId: z.string(),
    token: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getEdgeConfigTokenResponseSchema = edgeConfigTokenSchema;

export const getEdgeConfigTokenErrorSchema = z.unknown();

export const deleteEdgeConfigTokensDataSchema = z.object({
  body: z
    .object({
      tokens: z.array(z.string()),
    })
    .optional(),
  path: z.object({
    edgeConfigId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const deleteEdgeConfigTokensResponseSchema = z.any();

export const deleteEdgeConfigTokensErrorSchema = z.unknown();

export const getEdgeConfigTokensDataSchema = z.object({
  path: z.object({
    edgeConfigId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getEdgeConfigTokensResponseSchema = edgeConfigTokenSchema;

export const getEdgeConfigTokensErrorSchema = z.unknown();

export const deleteConfigurationDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const deleteConfigurationResponseSchema = z.any();

export const deleteConfigurationErrorSchema = z.unknown();

export const getConfigurationDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getConfigurationResponseSchema = z.union([
  z.object({
    completedAt: z.number().optional(),
    createdAt: z.number(),
    deletedAt: z.number().optional().nullable(),
    disabledAt: z.number().optional(),
    id: z.string(),
    integrationId: z.string(),
    oauthConfiguration: z.boolean().optional(),
    ownerId: z.string(),
    projects: z.array(z.string()).optional(),
    removedLogDrainsAt: z.number().optional(),
    removedProjectEnvsAt: z.number().optional(),
    removedTokensAt: z.number().optional(),
    removedWebhooksAt: z.number().optional(),
    scopes: z.array(z.string()),
    scopesQueue: z
      .array(
        z.object({
          confirmedAt: z.number().optional(),
          note: z.string(),
          requestedAt: z.number(),
          scopes: z.object({
            added: z.array(
              z.union([
                z.literal('read:integration-configuration'),
                z.literal('read-write:integration-configuration'),
                z.literal('read:deployment'),
                z.literal('read-write:deployment'),
                z.literal('read-write:deployment-check'),
                z.literal('read:project'),
                z.literal('read-write:project'),
                z.literal('read-write:project-env-vars'),
                z.literal('read-write:global-project-env-vars'),
                z.literal('read:team'),
                z.literal('read:user'),
                z.literal('read-write:log-drain'),
                z.literal('read:domain'),
                z.literal('read-write:domain'),
                z.literal('read-write:edge-config'),
                z.literal('read-write:otel-endpoint'),
                z.literal('read:monitoring'),
              ]),
            ),
            upgraded: z.array(
              z.union([
                z.literal('read:integration-configuration'),
                z.literal('read-write:integration-configuration'),
                z.literal('read:deployment'),
                z.literal('read-write:deployment'),
                z.literal('read-write:deployment-check'),
                z.literal('read:project'),
                z.literal('read-write:project'),
                z.literal('read-write:project-env-vars'),
                z.literal('read-write:global-project-env-vars'),
                z.literal('read:team'),
                z.literal('read:user'),
                z.literal('read-write:log-drain'),
                z.literal('read:domain'),
                z.literal('read-write:domain'),
                z.literal('read-write:edge-config'),
                z.literal('read-write:otel-endpoint'),
                z.literal('read:monitoring'),
              ]),
            ),
          }),
        }),
      )
      .optional(),
    slug: z.string(),
    source: z
      .union([z.literal('marketplace'), z.literal('deploy-button'), z.literal('oauth'), z.literal('external')])
      .optional(),
    teamId: z.string().optional().nullable(),
    type: z.literal('integration-configuration'),
    updatedAt: z.number(),
    userId: z.string(),
  }),
  z.object({
    canConfigureOpenTelemetry: z.boolean().optional(),
    completedAt: z.number().optional(),
    createdAt: z.number(),
    disabledAt: z.number().optional(),
    id: z.string(),
    integrationId: z.string(),
    oauthConfiguration: z.boolean().optional(),
    ownerId: z.string(),
    projectSelection: z.union([z.literal('selected'), z.literal('all')]),
    projects: z.array(z.string()).optional(),
    scopes: z.array(z.string()),
    slug: z.string(),
    source: z
      .union([z.literal('marketplace'), z.literal('deploy-button'), z.literal('oauth'), z.literal('external')])
      .optional(),
    teamId: z.string().optional().nullable(),
    updatedAt: z.number(),
    userId: z.string(),
  }),
]);

export const getConfigurationErrorSchema = z.unknown();

export const getConfigurationsDataSchema = z.object({
  query: z.object({
    teamId: z.string().optional(),
    view: z.union([z.literal('account'), z.literal('project')]),
  }),
});

export const getConfigurationsResponseSchema = z.union([
  z.array(
    z.object({
      completedAt: z.number().optional(),
      createdAt: z.number(),
      deletedAt: z.number().optional().nullable(),
      disabledAt: z.number().optional(),
      id: z.string(),
      integrationId: z.string(),
      oauthConfiguration: z.boolean().optional(),
      ownerId: z.string(),
      projects: z.array(z.string()).optional(),
      removedLogDrainsAt: z.number().optional(),
      removedProjectEnvsAt: z.number().optional(),
      removedTokensAt: z.number().optional(),
      removedWebhooksAt: z.number().optional(),
      scopes: z.array(z.string()),
      scopesQueue: z
        .array(
          z.object({
            confirmedAt: z.number().optional(),
            note: z.string(),
            requestedAt: z.number(),
            scopes: z.object({
              added: z.array(
                z.union([
                  z.literal('read:integration-configuration'),
                  z.literal('read-write:integration-configuration'),
                  z.literal('read:deployment'),
                  z.literal('read-write:deployment'),
                  z.literal('read-write:deployment-check'),
                  z.literal('read:project'),
                  z.literal('read-write:project'),
                  z.literal('read-write:project-env-vars'),
                  z.literal('read-write:global-project-env-vars'),
                  z.literal('read:team'),
                  z.literal('read:user'),
                  z.literal('read-write:log-drain'),
                  z.literal('read:domain'),
                  z.literal('read-write:domain'),
                  z.literal('read-write:edge-config'),
                  z.literal('read-write:otel-endpoint'),
                  z.literal('read:monitoring'),
                ]),
              ),
              upgraded: z.array(
                z.union([
                  z.literal('read:integration-configuration'),
                  z.literal('read-write:integration-configuration'),
                  z.literal('read:deployment'),
                  z.literal('read-write:deployment'),
                  z.literal('read-write:deployment-check'),
                  z.literal('read:project'),
                  z.literal('read-write:project'),
                  z.literal('read-write:project-env-vars'),
                  z.literal('read-write:global-project-env-vars'),
                  z.literal('read:team'),
                  z.literal('read:user'),
                  z.literal('read-write:log-drain'),
                  z.literal('read:domain'),
                  z.literal('read-write:domain'),
                  z.literal('read-write:edge-config'),
                  z.literal('read-write:otel-endpoint'),
                  z.literal('read:monitoring'),
                ]),
              ),
            }),
          }),
        )
        .optional(),
      slug: z.string(),
      source: z
        .union([z.literal('marketplace'), z.literal('deploy-button'), z.literal('oauth'), z.literal('external')])
        .optional(),
      teamId: z.string().optional().nullable(),
      type: z.literal('integration-configuration'),
      updatedAt: z.number(),
      userId: z.string(),
    }),
  ),
  z.array(
    z.object({
      completedAt: z.number().optional(),
      createdAt: z.number(),
      deletedAt: z.number().optional().nullable(),
      disabledAt: z.number().optional(),
      id: z.string(),
      integration: z.object({
        assignedBetaLabelAt: z.number().optional(),
        category: z.string(),
        flags: z.array(z.string()).optional(),
        icon: z.string(),
        isLegacy: z.boolean(),
        name: z.string(),
      }),
      integrationId: z.string(),
      oauthConfiguration: z.boolean().optional(),
      ownerId: z.string(),
      projects: z.array(z.string()).optional(),
      removedLogDrainsAt: z.number().optional(),
      removedProjectEnvsAt: z.number().optional(),
      removedTokensAt: z.number().optional(),
      removedWebhooksAt: z.number().optional(),
      scopes: z.array(z.string()),
      scopesQueue: z
        .array(
          z.object({
            confirmedAt: z.number().optional(),
            note: z.string(),
            requestedAt: z.number(),
            scopes: z.object({
              added: z.array(
                z.union([
                  z.literal('read:integration-configuration'),
                  z.literal('read-write:integration-configuration'),
                  z.literal('read:deployment'),
                  z.literal('read-write:deployment'),
                  z.literal('read-write:deployment-check'),
                  z.literal('read:project'),
                  z.literal('read-write:project'),
                  z.literal('read-write:project-env-vars'),
                  z.literal('read-write:global-project-env-vars'),
                  z.literal('read:team'),
                  z.literal('read:user'),
                  z.literal('read-write:log-drain'),
                  z.literal('read:domain'),
                  z.literal('read-write:domain'),
                  z.literal('read-write:edge-config'),
                  z.literal('read-write:otel-endpoint'),
                  z.literal('read:monitoring'),
                ]),
              ),
              upgraded: z.array(
                z.union([
                  z.literal('read:integration-configuration'),
                  z.literal('read-write:integration-configuration'),
                  z.literal('read:deployment'),
                  z.literal('read-write:deployment'),
                  z.literal('read-write:deployment-check'),
                  z.literal('read:project'),
                  z.literal('read-write:project'),
                  z.literal('read-write:project-env-vars'),
                  z.literal('read-write:global-project-env-vars'),
                  z.literal('read:team'),
                  z.literal('read:user'),
                  z.literal('read-write:log-drain'),
                  z.literal('read:domain'),
                  z.literal('read-write:domain'),
                  z.literal('read-write:edge-config'),
                  z.literal('read-write:otel-endpoint'),
                  z.literal('read:monitoring'),
                ]),
              ),
            }),
          }),
        )
        .optional(),
      slug: z.string(),
      source: z
        .union([z.literal('marketplace'), z.literal('deploy-button'), z.literal('oauth'), z.literal('external')])
        .optional(),
      teamId: z.string().optional().nullable(),
      type: z.literal('integration-configuration'),
      updatedAt: z.number(),
      userId: z.string(),
    }),
  ),
]);

export const getConfigurationsErrorSchema = z.unknown();

export const gitNamespacesDataSchema = z.object({
  query: z
    .object({
      provider: z.union([z.literal('github'), z.literal('gitlab'), z.literal('bitbucket')]).optional(),
      teamId: z.string().optional(),
    })
    .optional(),
});

export const gitNamespacesResponseSchema = z.array(
  z.object({
    id: z.union([z.string(), z.number()]),
    name: z.string().optional(),
    ownerType: z.string(),
    provider: z.string(),
    slug: z.string(),
  }),
);

export const gitNamespacesErrorSchema = z.unknown();

export const deleteIntegrationLogDrainDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const deleteIntegrationLogDrainResponseSchema = z.any();

export const deleteIntegrationLogDrainErrorSchema = z.unknown();

export const getV1IntegrationsSearchRepoDataSchema = z.object({
  query: z
    .object({
      installationId: z.string().optional(),
      namespaceId: z.union([z.string(), z.number()]).optional().nullable(),
      provider: z.union([z.literal('github'), z.literal('gitlab'), z.literal('bitbucket')]).optional(),
      query: z.string().optional(),
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getV1IntegrationsSearchRepoResponseSchema = z.object({
  gitAccount: z.object({
    namespaceId: z.union([z.string(), z.number()]).nullable(),
    provider: z.union([z.literal('github'), z.literal('gitlab'), z.literal('bitbucket')]),
  }),
  repos: z.array(
    z.object({
      defaultBranch: z.string(),
      id: z.union([z.string(), z.number()]),
      name: z.string(),
      namespace: z.string(),
      ownerType: z.union([z.literal('team'), z.literal('user')]),
      private: z.boolean(),
      slug: z.string(),
      updatedAt: z.number(),
      url: z.string(),
    }),
  ),
});

export const getV1IntegrationsSearchRepoErrorSchema = z.unknown();

export const getConfigurableLogDrainsDataSchema = z.object({
  query: z
    .object({
      projectId: z.string().optional(),
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getConfigurableLogDrainsResponseSchema = z.array(
  z.object({
    branch: z.string().optional(),
    configurationId: z.string().optional(),
    createdAt: z.number(),
    deliveryFormat: z.union([z.literal('json'), z.literal('ndjson'), z.literal('syslog')]),
    environment: z.union([z.literal('preview'), z.literal('production')]).optional(),
    headers: z.record(z.string()).optional(),
    id: z.string(),
    ownerId: z.string(),
    projectIds: z.array(z.string()).optional(),
    sources: z
      .array(
        z.union([
          z.literal('static'),
          z.literal('lambda'),
          z.literal('build'),
          z.literal('edge'),
          z.literal('external'),
          z.literal('deployment'),
        ]),
      )
      .optional(),
    url: z.string(),
  }),
);

export const getConfigurableLogDrainsErrorSchema = z.unknown();

export const createConfigurableLogDrainDataSchema = z.object({
  body: z
    .object({
      branch: z.string().optional(),
      deliveryFormat: z.union([z.literal('json'), z.literal('ndjson')]),
      environment: z.union([z.literal('preview'), z.literal('production')]).optional(),
      headers: z.record(z.string()).optional(),
      projectIds: z.array(z.string()).optional(),
      sources: z.array(
        z.union([
          z.literal('static'),
          z.literal('lambda'),
          z.literal('build'),
          z.literal('edge'),
          z.literal('external'),
        ]),
      ),
      url: z.string(),
    })
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const createConfigurableLogDrainResponseSchema = z.object({
  branch: z.string().optional(),
  configurationId: z.string().optional(),
  createdAt: z.number(),
  deliveryFormat: z.union([z.literal('json'), z.literal('ndjson'), z.literal('syslog')]),
  environment: z.union([z.literal('preview'), z.literal('production')]).optional(),
  headers: z.record(z.string()).optional(),
  id: z.string(),
  ownerId: z.string(),
  projectIds: z.array(z.string()).optional(),
  secret: z.string().optional(),
  sources: z
    .array(
      z.union([
        z.literal('static'),
        z.literal('lambda'),
        z.literal('build'),
        z.literal('edge'),
        z.literal('external'),
        z.literal('deployment'),
      ]),
    )
    .optional(),
  url: z.string(),
});

export const createConfigurableLogDrainErrorSchema = z.unknown();

export const deleteConfigurableLogDrainDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const deleteConfigurableLogDrainResponseSchema = z.any();

export const deleteConfigurableLogDrainErrorSchema = z.unknown();

export const getConfigurableLogDrainDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getConfigurableLogDrainResponseSchema = z.object({
  branch: z.string().optional(),
  configurationId: z.string().optional(),
  createdAt: z.number(),
  deliveryFormat: z.union([z.literal('json'), z.literal('ndjson'), z.literal('syslog')]),
  environment: z.union([z.literal('preview'), z.literal('production')]).optional(),
  headers: z.record(z.string()).optional(),
  id: z.string(),
  ownerId: z.string(),
  projectIds: z.array(z.string()).optional(),
  sources: z
    .array(
      z.union([
        z.literal('static'),
        z.literal('lambda'),
        z.literal('build'),
        z.literal('edge'),
        z.literal('external'),
        z.literal('deployment'),
      ]),
    )
    .optional(),
  url: z.string(),
});

export const getConfigurableLogDrainErrorSchema = z.unknown();

export const getProjectEnvDataSchema = z.object({
  path: z.object({
    id: z.string(),
    idOrName: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getProjectEnvResponseSchema = z.object({
  configurationId: z.string().optional().nullable(),
  createdAt: z.number().optional(),
  createdBy: z.string().optional().nullable(),
  decrypted: z.boolean().optional(),
  edgeConfigId: z.string().optional().nullable(),
  edgeConfigTokenId: z.string().optional().nullable(),
  gitBranch: z.string().optional(),
  id: z.string().optional(),
  key: z.string(),
  target: z
    .union([
      z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
      z.literal('production'),
      z.literal('preview'),
      z.literal('development'),
    ])
    .optional(),
  type: z.union([
    z.literal('secret'),
    z.literal('system'),
    z.literal('encrypted'),
    z.literal('plain'),
    z.literal('sensitive'),
  ]),
  updatedAt: z.number().optional(),
  updatedBy: z.string().optional().nullable(),
  value: z.string(),
});

export const getProjectEnvErrorSchema = z.unknown();

export const createTeamDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
      slug: z.string(),
    })
    .optional(),
});

export const createTeamResponseSchema = z.object({
  id: z.string(),
});

export const createTeamErrorSchema = z.unknown();

export const deleteTeamDataSchema = z.object({
  body: z
    .object({
      reasons: z
        .array(
          z.object({
            description: z.string(),
            slug: z.string(),
          }),
        )
        .optional(),
    })
    .optional(),
  path: z.object({
    teamId: z.string(),
  }),
});

export const deleteTeamResponseSchema = z.object({
  id: z.string(),
});

export const deleteTeamErrorSchema = z.unknown();

export const deleteTeamInviteCodeDataSchema = z.object({
  path: z.object({
    inviteId: z.string(),
    teamId: z.string(),
  }),
});

export const deleteTeamInviteCodeResponseSchema = z.object({
  id: z.string(),
});

export const deleteTeamInviteCodeErrorSchema = z.unknown();

export const inviteUserToTeamDataSchema = z.object({
  body: z
    .object({
      email: z.string().optional(),
      role: z.unknown().optional(),
      uid: z.string().optional(),
    })
    .optional(),
  path: z.object({
    teamId: z.string(),
  }),
});

export const inviteUserToTeamResponseSchema = z.union([
  z.object({
    email: z.string(),
    role: z.string(),
    uid: z.string(),
    username: z.string(),
  }),
  z.object({
    role: z.string(),
    uid: z.string(),
    username: z.string(),
  }),
]);

export const inviteUserToTeamErrorSchema = z.unknown();

export const joinTeamDataSchema = z.object({
  body: z
    .object({
      inviteCode: z.string().optional(),
      teamId: z.string().optional(),
    })
    .optional(),
  path: z.object({
    teamId: z.string(),
  }),
});

export const joinTeamResponseSchema = z.object({
  from: z.string(),
  name: z.string(),
  slug: z.string(),
  teamId: z.string(),
});

export const joinTeamErrorSchema = z.unknown();

export const removeTeamMemberDataSchema = z.object({
  path: z.object({
    teamId: z.string(),
    uid: z.string(),
  }),
});

export const removeTeamMemberResponseSchema = z.object({
  id: z.string(),
});

export const removeTeamMemberErrorSchema = z.unknown();

export const updateTeamMemberDataSchema = z.object({
  body: z
    .object({
      confirmed: z.boolean().optional(),
      joinedFrom: z
        .object({
          ssoUserId: z.null().optional(),
        })
        .optional(),
      role: z.string().optional(),
    })
    .optional(),
  path: z.object({
    teamId: z.string(),
    uid: z.string(),
  }),
});

export const updateTeamMemberResponseSchema = z.object({
  id: z.string(),
});

export const updateTeamMemberErrorSchema = z.unknown();

export const requestAccessToTeamDataSchema = z.object({
  body: z
    .object({
      joinedFrom: z.object({
        commitId: z.string().optional(),
        gitUserId: z.union([z.string(), z.number()]).optional(),
        gitUserLogin: z.string().optional(),
        origin: z.union([
          z.literal('import'),
          z.literal('teams'),
          z.literal('github'),
          z.literal('gitlab'),
          z.literal('bitbucket'),
          z.literal('feedback'),
          z.literal('organization-teams'),
        ]),
        repoId: z.string().optional(),
        repoPath: z.string().optional(),
      }),
    })
    .optional(),
  path: z.object({
    teamId: z.string(),
  }),
});

export const requestAccessToTeamResponseSchema = z.object({
  accessRequestedAt: z.number().optional(),
  bitbucket: z
    .object({
      login: z.string().optional(),
    })
    .nullable(),
  confirmed: z.boolean().optional(),
  github: z
    .object({
      login: z.string().optional(),
    })
    .nullable(),
  gitlab: z
    .object({
      login: z.string().optional(),
    })
    .nullable(),
  joinedFrom: z
    .object({
      commitId: z.string().optional(),
      dsyncConnectedAt: z.number().optional(),
      dsyncUserId: z.string().optional(),
      gitUserId: z.union([z.string(), z.number()]).optional(),
      gitUserLogin: z.string().optional(),
      idpUserId: z.string().optional(),
      origin: z.union([
        z.literal('import'),
        z.literal('teams'),
        z.literal('github'),
        z.literal('gitlab'),
        z.literal('bitbucket'),
        z.literal('feedback'),
        z.literal('organization-teams'),
        z.literal('mail'),
        z.literal('link'),
        z.literal('saml'),
        z.literal('dsync'),
      ]),
      repoId: z.string().optional(),
      repoPath: z.string().optional(),
      ssoConnectedAt: z.number().optional(),
      ssoUserId: z.string().optional(),
    })
    .optional(),
  teamName: z.string(),
  teamSlug: z.string(),
});

export const requestAccessToTeamErrorSchema = z.unknown();

export const getTeamAccessRequestDataSchema = z.object({
  path: z.object({
    teamId: z.string(),
    userId: z.string(),
  }),
});

export const getTeamAccessRequestResponseSchema = z.object({
  accessRequestedAt: z.number(),
  bitbucket: z
    .object({
      login: z.string().optional(),
    })
    .nullable(),
  confirmed: z.boolean(),
  github: z
    .object({
      login: z.string().optional(),
    })
    .nullable(),
  gitlab: z
    .object({
      login: z.string().optional(),
    })
    .nullable(),
  joinedFrom: z.object({
    commitId: z.string().optional(),
    dsyncConnectedAt: z.number().optional(),
    dsyncUserId: z.string().optional(),
    gitUserId: z.union([z.string(), z.number()]).optional(),
    gitUserLogin: z.string().optional(),
    idpUserId: z.string().optional(),
    origin: z.union([
      z.literal('import'),
      z.literal('mail'),
      z.literal('link'),
      z.literal('teams'),
      z.literal('github'),
      z.literal('gitlab'),
      z.literal('bitbucket'),
      z.literal('saml'),
      z.literal('dsync'),
      z.literal('feedback'),
      z.literal('organization-teams'),
    ]),
    repoId: z.string().optional(),
    repoPath: z.string().optional(),
    ssoConnectedAt: z.number().optional(),
    ssoUserId: z.string().optional(),
  }),
  teamName: z.string(),
  teamSlug: z.string(),
});

export const getTeamAccessRequestErrorSchema = z.unknown();

export const requestDeleteDataSchema = z.object({
  body: z
    .object({
      reasons: z
        .array(
          z.object({
            description: z.string(),
            slug: z.string(),
          }),
        )
        .optional(),
    })
    .optional(),
});

export const requestDeleteResponseSchema = z.object({
  email: z.string(),
  id: z.string(),
  message: z.string(),
});

export const requestDeleteErrorSchema = z.unknown();

export const getWebhooksDataSchema = z.object({
  query: z
    .object({
      projectId: z.string().optional(),
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getWebhooksResponseSchema = z.union([
  z.array(
    z.object({
      createdAt: z.number(),
      events: z.array(
        z.union([
          z.literal('domain.created'),
          z.literal('deployment.created'),
          z.literal('deployment.error'),
          z.literal('deployment.canceled'),
          z.literal('deployment.succeeded'),
          z.literal('deployment.ready'),
          z.literal('deployment.check-rerequested'),
          z.literal('integration-configuration.permission-upgraded'),
          z.literal('integration-configuration.removed'),
          z.literal('integration-configuration.scope-change-confirmed'),
          z.literal('project.created'),
          z.literal('project.removed'),
          z.literal('deployment-checks-completed'),
          z.literal('deployment-ready'),
          z.literal('deployment-prepared'),
          z.literal('deployment-error'),
          z.literal('deployment-check-rerequested'),
          z.literal('deployment-canceled'),
          z.literal('project-created'),
          z.literal('project-removed'),
          z.literal('domain-created'),
          z.literal('deployment'),
          z.literal('integration-configuration-permission-updated'),
          z.literal('integration-configuration-removed'),
          z.literal('integration-configuration-scope-change-confirmed'),
        ]),
      ),
      id: z.string(),
      ownerId: z.string(),
      projectIds: z.array(z.string()).optional(),
      projectsMetadata: z
        .array(
          z.object({
            framework: z
              .union([
                z.literal('blitzjs'),
                z.literal('nextjs'),
                z.literal('gatsby'),
                z.literal('remix'),
                z.literal('astro'),
                z.literal('hexo'),
                z.literal('eleventy'),
                z.literal('docusaurus-2'),
                z.literal('docusaurus'),
                z.literal('preact'),
                z.literal('solidstart'),
                z.literal('dojo'),
                z.literal('ember'),
                z.literal('vue'),
                z.literal('scully'),
                z.literal('ionic-angular'),
                z.literal('angular'),
                z.literal('polymer'),
                z.literal('svelte'),
                z.literal('sveltekit'),
                z.literal('sveltekit-1'),
                z.literal('ionic-react'),
                z.literal('create-react-app'),
                z.literal('gridsome'),
                z.literal('umijs'),
                z.literal('sapper'),
                z.literal('saber'),
                z.literal('stencil'),
                z.literal('nuxtjs'),
                z.literal('redwoodjs'),
                z.literal('hugo'),
                z.literal('jekyll'),
                z.literal('brunch'),
                z.literal('middleman'),
                z.literal('zola'),
                z.literal('hydrogen'),
                z.literal('vite'),
                z.literal('vitepress'),
                z.literal('vuepress'),
                z.literal('parcel'),
                z.literal('sanity'),
              ])
              .optional()
              .nullable(),
            id: z.string(),
            latestDeployment: z.string().optional(),
            name: z.string(),
          }),
        )
        .nullable(),
      updatedAt: z.number(),
      url: z.string(),
    }),
  ),
  z.array(
    z.object({
      createdAt: z.number(),
      events: z.array(
        z.union([
          z.literal('domain.created'),
          z.literal('deployment.created'),
          z.literal('deployment.error'),
          z.literal('deployment.canceled'),
          z.literal('deployment.succeeded'),
          z.literal('deployment.ready'),
          z.literal('deployment.check-rerequested'),
          z.literal('integration-configuration.permission-upgraded'),
          z.literal('integration-configuration.removed'),
          z.literal('integration-configuration.scope-change-confirmed'),
          z.literal('project.created'),
          z.literal('project.removed'),
          z.literal('deployment-checks-completed'),
          z.literal('deployment-ready'),
          z.literal('deployment-prepared'),
          z.literal('deployment-error'),
          z.literal('deployment-check-rerequested'),
          z.literal('deployment-canceled'),
          z.literal('project-created'),
          z.literal('project-removed'),
          z.literal('domain-created'),
          z.literal('deployment'),
          z.literal('integration-configuration-permission-updated'),
          z.literal('integration-configuration-removed'),
          z.literal('integration-configuration-scope-change-confirmed'),
        ]),
      ),
      id: z.string(),
      ownerId: z.string(),
      projectIds: z.array(z.string()).optional(),
      updatedAt: z.number(),
      url: z.string(),
    }),
  ),
]);

export const getWebhooksErrorSchema = z.unknown();

export const createWebhookDataSchema = z.object({
  body: z
    .object({
      events: z.array(
        z.union([
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DomainCreate'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DeploymentCreate'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DeploymentErro'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DeploymentCancele'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DeploymentSucceede'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DeploymentRead'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DeploymentCheckRerequeste'),
          z.literal(
            'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.IntegrationConfigurationPermissionUpgrade',
          ),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.IntegrationConfigurationRemove'),
          z.literal(
            'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.IntegrationConfigurationScopeChangeConfirme',
          ),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.ProjectCreate'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.ProjectRemove'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymentChecksComplete'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymentRead'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymentPrepare'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymentErro'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymentCheckRerequeste'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymentCancele'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyProjectCreate'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyProjectRemove'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDomainCreate'),
          z.literal('mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymen'),
          z.literal(
            'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyIntegrationConfigurationPermissionUpdate',
          ),
          z.literal(
            'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyIntegrationConfigurationRemove',
          ),
          z.literal(
            'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyIntegrationConfigurationScopeChangeConfirme',
          ),
        ]),
      ),
      projectIds: z.array(z.string()).optional(),
      url: z.string(),
    })
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const createWebhookResponseSchema = z.object({
  createdAt: z.number(),
  events: z.array(
    z.union([
      z.literal('domain.created'),
      z.literal('deployment.created'),
      z.literal('deployment.error'),
      z.literal('deployment.canceled'),
      z.literal('deployment.succeeded'),
      z.literal('deployment.ready'),
      z.literal('deployment.check-rerequested'),
      z.literal('integration-configuration.permission-upgraded'),
      z.literal('integration-configuration.removed'),
      z.literal('integration-configuration.scope-change-confirmed'),
      z.literal('project.created'),
      z.literal('project.removed'),
      z.literal('deployment-checks-completed'),
      z.literal('deployment-ready'),
      z.literal('deployment-prepared'),
      z.literal('deployment-error'),
      z.literal('deployment-check-rerequested'),
      z.literal('deployment-canceled'),
      z.literal('project-created'),
      z.literal('project-removed'),
      z.literal('domain-created'),
      z.literal('deployment'),
      z.literal('integration-configuration-permission-updated'),
      z.literal('integration-configuration-removed'),
      z.literal('integration-configuration-scope-change-confirmed'),
    ]),
  ),
  id: z.string(),
  ownerId: z.string(),
  projectIds: z.array(z.string()).optional(),
  secret: z.string(),
  updatedAt: z.number(),
  url: z.string(),
});

export const createWebhookErrorSchema = z.unknown();

export const deleteWebhookDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const deleteWebhookResponseSchema = z.any();

export const deleteWebhookErrorSchema = z.unknown();

export const getWebhookDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getWebhookResponseSchema = z.object({
  createdAt: z.number(),
  events: z.array(
    z.union([
      z.literal('domain.created'),
      z.literal('deployment.created'),
      z.literal('deployment.error'),
      z.literal('deployment.canceled'),
      z.literal('deployment.succeeded'),
      z.literal('deployment.ready'),
      z.literal('deployment.check-rerequested'),
      z.literal('integration-configuration.permission-upgraded'),
      z.literal('integration-configuration.removed'),
      z.literal('integration-configuration.scope-change-confirmed'),
      z.literal('project.created'),
      z.literal('project.removed'),
      z.literal('deployment-checks-completed'),
      z.literal('deployment-ready'),
      z.literal('deployment-prepared'),
      z.literal('deployment-error'),
      z.literal('deployment-check-rerequested'),
      z.literal('deployment-canceled'),
      z.literal('project-created'),
      z.literal('project-removed'),
      z.literal('domain-created'),
      z.literal('deployment'),
      z.literal('integration-configuration-permission-updated'),
      z.literal('integration-configuration-removed'),
      z.literal('integration-configuration-scope-change-confirmed'),
    ]),
  ),
  id: z.string(),
  ownerId: z.string(),
  projectIds: z.array(z.string()).optional(),
  updatedAt: z.number(),
  url: z.string(),
});

export const getWebhookErrorSchema = z.unknown();

export const addProjectDomainDataSchema = z.object({
  body: z
    .object({
      gitBranch: z.string().optional().nullable(),
      name: z.string(),
      redirect: z.string().optional().nullable(),
      redirectStatusCode: z
        .union([z.literal(301), z.literal(302), z.literal(307), z.literal(308)])
        .optional()
        .nullable(),
    })
    .optional(),
  path: z.object({
    idOrName: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const addProjectDomainResponseSchema = z.object({
  apexName: z.string(),
  createdAt: z.number().optional(),
  gitBranch: z.string().optional().nullable(),
  name: z.string(),
  projectId: z.string(),
  redirect: z.string().optional().nullable(),
  redirectStatusCode: z
    .union([z.literal(307), z.literal(301), z.literal(302), z.literal(308)])
    .optional()
    .nullable(),
  updatedAt: z.number().optional(),
  verification: z
    .array(
      z.object({
        domain: z.string(),
        reason: z.string(),
        type: z.string(),
        value: z.string(),
      }),
    )
    .optional(),
  verified: z.boolean(),
});

export const addProjectDomainErrorSchema = z.unknown();

export const createProjectEnvDataSchema = z.object({
  body: z
    .union([
      z.object({
        gitBranch: z.string().optional().nullable(),
        key: z.string(),
        target: z.array(
          z.union([
            z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Productio'),
            z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Previe'),
            z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Developmen'),
          ]),
        ),
        type: z.union([
          z.literal('system'),
          z.literal('secret'),
          z.literal('encrypted'),
          z.literal('plain'),
          z.literal('sensitive'),
        ]),
        value: z.string(),
      }),
      z.array(
        z.object({
          gitBranch: z.string().optional().nullable(),
          key: z.string(),
          target: z.array(
            z.union([
              z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Productio'),
              z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Previe'),
              z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Developmen'),
            ]),
          ),
          type: z.union([
            z.literal('system'),
            z.literal('secret'),
            z.literal('encrypted'),
            z.literal('plain'),
            z.literal('sensitive'),
          ]),
          value: z.string(),
        }),
      ),
    ])
    .optional(),
  path: z.object({
    idOrName: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
      upsert: z.string().optional(),
    })
    .optional(),
});

export const createProjectEnvResponseSchema = z.object({
  created: z.union([
    z.object({
      configurationId: z.string().optional().nullable(),
      createdAt: z.number().optional(),
      createdBy: z.string().optional().nullable(),
      decrypted: z.boolean().optional(),
      edgeConfigId: z.string().optional().nullable(),
      edgeConfigTokenId: z.string().optional().nullable(),
      gitBranch: z.string().optional(),
      id: z.string().optional(),
      key: z.string().optional(),
      system: z.boolean().optional(),
      target: z
        .union([
          z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
          z.literal('production'),
          z.literal('preview'),
          z.literal('development'),
        ])
        .optional(),
      type: z
        .union([
          z.literal('secret'),
          z.literal('system'),
          z.literal('encrypted'),
          z.literal('plain'),
          z.literal('sensitive'),
        ])
        .optional(),
      updatedAt: z.number().optional(),
      updatedBy: z.string().optional().nullable(),
      value: z.string().optional(),
    }),
    z.array(
      z.object({
        configurationId: z.string().optional().nullable(),
        createdAt: z.number().optional(),
        createdBy: z.string().optional().nullable(),
        decrypted: z.boolean().optional(),
        edgeConfigId: z.string().optional().nullable(),
        edgeConfigTokenId: z.string().optional().nullable(),
        gitBranch: z.string().optional(),
        id: z.string().optional(),
        key: z.string().optional(),
        system: z.boolean().optional(),
        target: z
          .union([
            z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
            z.literal('production'),
            z.literal('preview'),
            z.literal('development'),
          ])
          .optional(),
        type: z
          .union([
            z.literal('secret'),
            z.literal('system'),
            z.literal('encrypted'),
            z.literal('plain'),
            z.literal('sensitive'),
          ])
          .optional(),
        updatedAt: z.number().optional(),
        updatedBy: z.string().optional().nullable(),
        value: z.string().optional(),
      }),
    ),
  ]),
  failed: z.array(
    z.object({
      error: z.object({
        action: z.string().optional(),
        code: z.string(),
        envVarId: z.string().optional(),
        envVarKey: z.string().optional(),
        gitBranch: z.string().optional(),
        key: z.string().optional(),
        link: z.string().optional(),
        message: z.string(),
        project: z.string().optional(),
        target: z
          .union([
            z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
            z.literal('production'),
            z.literal('preview'),
            z.literal('development'),
          ])
          .optional(),
        value: z
          .union([
            z.string(),
            z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
          ])
          .optional(),
      }),
    }),
  ),
});

export const createProjectEnvErrorSchema = z.unknown();

export const listDeploymentBuildsDataSchema = z.object({
  path: z.object({
    deploymentId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const listDeploymentBuildsResponseSchema = z.object({
  builds: z.array(
    z.object({
      config: z
        .object({
          distDir: z.string().optional(),
          forceBuildIn: z.string().optional(),
          reuseWorkPathFrom: z.string().optional(),
          zeroConfig: z.boolean().optional(),
        })
        .optional(),
      copiedFrom: z.string().optional(),
      createdAt: z.number().optional(),
      createdIn: z.string().optional(),
      deployedAt: z.number().optional(),
      deploymentId: z.string(),
      entrypoint: z.string(),
      fingerprint: z.string().optional().nullable(),
      id: z.string(),
      output: z.array(
        z.object({
          digest: z.string(),
          edge: z
            .object({
              regions: z.array(z.string()).nullable(),
            })
            .optional()
            .nullable(),
          lambda: z
            .object({
              deployedTo: z.array(z.string()),
              functionName: z.string(),
              layers: z.array(z.string()).optional(),
              memorySize: z.number().optional(),
              timeout: z.number().optional(),
            })
            .optional()
            .nullable(),
          mode: z.number(),
          path: z.string(),
          size: z.number().optional(),
          type: z.union([z.literal('lambda'), z.literal('file'), z.literal('edge')]).optional(),
        }),
      ),
      readyState: z.union([
        z.literal('BUILDING'),
        z.literal('ERROR'),
        z.literal('INITIALIZING'),
        z.literal('QUEUED'),
        z.literal('READY'),
        z.literal('CANCELED'),
        z.literal('UPLOADING'),
        z.literal('DEPLOYING'),
        z.literal('ARCHIVED'),
      ]),
      readyStateAt: z.number().optional(),
      scheduledAt: z.number().optional().nullable(),
      use: z.string().optional(),
    }),
  ),
});

export const listDeploymentBuildsErrorSchema = z.unknown();

export const cancelDeploymentDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const cancelDeploymentResponseSchema = z.object({
  alias: z.array(z.string()),
  aliasAssigned: z.boolean(),
  aliasAssignedAt: z.union([z.number(), z.boolean()]).optional().nullable(),
  aliasError: z
    .object({
      code: z.string(),
      message: z.string(),
    })
    .optional()
    .nullable(),
  aliasFinal: z.string().optional().nullable(),
  aliasWarning: z
    .object({
      action: z.string().optional(),
      code: z.string(),
      link: z.string().optional(),
      message: z.string(),
    })
    .optional()
    .nullable(),
  automaticAliases: z.array(z.string()).optional(),
  bootedAt: z.number(),
  build: z.object({
    env: z.array(z.string()),
  }),
  buildErrorAt: z.number().optional(),
  buildingAt: z.number(),
  builds: z
    .array(
      z.object({
        config: z.record(z.string()).optional(),
        src: z.string().optional(),
        use: z.string(),
      }),
    )
    .optional(),
  canceledAt: z.number().optional(),
  checksConclusion: z
    .union([z.literal('succeeded'), z.literal('failed'), z.literal('skipped'), z.literal('canceled')])
    .optional(),
  checksState: z.union([z.literal('registered'), z.literal('running'), z.literal('completed')]).optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.object({
    uid: z.string(),
    username: z.string().optional(),
  }),
  env: z.array(z.string()),
  errorCode: z.string().optional(),
  errorLink: z.string().optional(),
  errorMessage: z.string().optional().nullable(),
  errorStep: z.string().optional(),
  functions: z
    .record(
      z.object({
        excludeFiles: z.string().optional(),
        includeFiles: z.string().optional(),
        maxDuration: z.number().optional(),
        memory: z.number().optional(),
        runtime: z.string().optional(),
      }),
    )
    .optional()
    .nullable(),
  gitRepo: z
    .union([
      z.object({
        defaultBranch: z.string(),
        name: z.string(),
        namespace: z.string(),
        ownerType: z.union([z.literal('user'), z.literal('team')]),
        path: z.string(),
        private: z.boolean(),
        projectId: z.number(),
        type: z.literal('gitlab'),
        url: z.string(),
      }),
      z.object({
        defaultBranch: z.string(),
        name: z.string(),
        org: z.string(),
        ownerType: z.union([z.literal('user'), z.literal('team')]),
        path: z.string(),
        private: z.boolean(),
        repo: z.string(),
        repoId: z.number(),
        repoOwnerId: z.string(),
        type: z.literal('github'),
      }),
      z.object({
        defaultBranch: z.string(),
        name: z.string(),
        owner: z.string(),
        ownerType: z.union([z.literal('user'), z.literal('team')]),
        path: z.string(),
        private: z.boolean(),
        repoUuid: z.string(),
        slug: z.string(),
        type: z.literal('bitbucket'),
        workspaceUuid: z.string(),
      }),
    ])
    .optional()
    .nullable(),
  gitSource: z
    .union([
      z.object({
        prId: z.number().optional().nullable(),
        ref: z.string().optional().nullable(),
        repoId: z.union([z.string(), z.number()]),
        sha: z.string().optional(),
        type: z.literal('github'),
      }),
      z.object({
        org: z.string(),
        prId: z.number().optional().nullable(),
        ref: z.string().optional().nullable(),
        repo: z.string(),
        sha: z.string().optional(),
        type: z.literal('github'),
      }),
      z.object({
        prId: z.number().optional().nullable(),
        projectId: z.union([z.string(), z.number()]),
        ref: z.string().optional().nullable(),
        sha: z.string().optional(),
        type: z.literal('gitlab'),
      }),
      z.object({
        prId: z.number().optional().nullable(),
        ref: z.string().optional().nullable(),
        repoUuid: z.string(),
        sha: z.string().optional(),
        type: z.literal('bitbucket'),
        workspaceUuid: z.string().optional(),
      }),
      z.object({
        owner: z.string(),
        prId: z.number().optional().nullable(),
        ref: z.string().optional().nullable(),
        sha: z.string().optional(),
        slug: z.string(),
        type: z.literal('bitbucket'),
      }),
      z.object({
        gitUrl: z.string(),
        ref: z.string(),
        sha: z.string(),
        type: z.literal('custom'),
      }),
      z.object({
        org: z.string().optional(),
        ref: z.string(),
        repo: z.string().optional(),
        repoId: z.number(),
        sha: z.string(),
        type: z.literal('github'),
      }),
      z.object({
        projectId: z.number(),
        ref: z.string(),
        sha: z.string(),
        type: z.literal('gitlab'),
      }),
      z.object({
        owner: z.string().optional(),
        ref: z.string(),
        repoUuid: z.string(),
        sha: z.string(),
        slug: z.string().optional(),
        type: z.literal('bitbucket'),
        workspaceUuid: z.string(),
      }),
    ])
    .optional(),
  id: z.string(),
  inspectorUrl: z.string().nullable(),
  isInConcurrentBuildsQueue: z.boolean(),
  lambdas: z
    .array(
      z.object({
        createdAt: z.number().optional(),
        entrypoint: z.string().optional().nullable(),
        id: z.string(),
        output: z.array(
          z.object({
            functionName: z.string(),
            path: z.string(),
          }),
        ),
        readyState: z
          .union([z.literal('INITIALIZING'), z.literal('BUILDING'), z.literal('READY'), z.literal('ERROR')])
          .optional(),
        readyStateAt: z.number().optional(),
      }),
    )
    .optional(),
  meta: z.record(z.string()),
  monorepoManager: z.string().optional().nullable(),
  name: z.string(),
  ownerId: z.string(),
  plan: z.union([z.literal('hobby'), z.literal('enterprise'), z.literal('pro'), z.literal('oss')]),
  previewCommentsEnabled: z.boolean().optional(),
  projectId: z.string(),
  public: z.boolean(),
  readyState: z.union([
    z.literal('INITIALIZING'),
    z.literal('BUILDING'),
    z.literal('READY'),
    z.literal('ERROR'),
    z.literal('QUEUED'),
    z.literal('CANCELED'),
  ]),
  regions: z.array(z.string()),
  routes: z
    .array(
      z.union([
        z.object({
          caseSensitive: z.boolean().optional(),
          check: z.boolean().optional(),
          continue: z.boolean().optional(),
          dest: z.string().optional(),
          has: z
            .array(
              z.union([
                z.object({
                  type: z.literal('host'),
                  value: z.string(),
                }),
                z.object({
                  key: z.string(),
                  type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          headers: z.record(z.string()).optional(),
          important: z.boolean().optional(),
          locale: z
            .object({
              cookie: z.string().optional(),
              redirect: z.record(z.string()).optional(),
            })
            .optional(),
          methods: z.array(z.string()).optional(),
          middleware: z.number().optional(),
          middlewarePath: z.string().optional(),
          middlewareRawSrc: z.array(z.string()).optional(),
          missing: z
            .array(
              z.union([
                z.object({
                  type: z.literal('host'),
                  value: z.string(),
                }),
                z.object({
                  key: z.string(),
                  type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          override: z.boolean().optional(),
          src: z.string(),
          status: z.number().optional(),
        }),
        z.object({
          dest: z.string().optional(),
          handle: z.union([
            z.literal('filesystem'),
            z.literal('hit'),
            z.literal('miss'),
            z.literal('rewrite'),
            z.literal('error'),
            z.literal('resource'),
          ]),
          src: z.string().optional(),
          status: z.number().optional(),
        }),
        z.object({
          continue: z.boolean(),
          middleware: z.literal(0),
          src: z.string(),
        }),
      ]),
    )
    .nullable(),
  source: z
    .union([z.literal('cli'), z.literal('git'), z.literal('import'), z.literal('import/repo'), z.literal('clone/repo')])
    .optional(),
  target: z
    .union([z.literal('staging'), z.literal('production')])
    .optional()
    .nullable(),
  team: z
    .object({
      id: z.string(),
      name: z.string(),
      slug: z.string(),
    })
    .optional(),
  type: z.literal('LAMBDAS'),
  url: z.string(),
  userAliases: z.array(z.string()).optional(),
  version: z.literal(2),
});

export const cancelDeploymentErrorSchema = z.unknown();

export const createDeploymentDataSchema = z.object({
  body: z
    .object({
      $schema: z.string().optional(),
      alias: z.array(z.string()).optional(),
      build: z
        .object({
          env: z.record(z.string()).optional(),
        })
        .optional(),
      buildCommand: z.string().optional().nullable(),
      builds: z
        .array(
          z.object({
            config: z.record(z.unknown()).optional(),
            src: z.string().optional(),
            use: z.string(),
          }),
        )
        .optional(),
      cleanUrls: z.boolean().optional(),
      crons: z
        .array(
          z.object({
            path: z.string(),
            schedule: z.string(),
          }),
        )
        .optional(),
      deploymentId: z.string().optional(),
      devCommand: z.string().optional().nullable(),
      env: z.record(z.string()).optional(),
      files: z
        .array(
          z.union([
            z.object({
              data: z.string(),
              encoding: z.union([z.literal('base64'), z.literal('utf-8')]).optional(),
              file: z.string(),
            }),
            z.object({
              file: z.string(),
              sha: z.string().optional(),
              size: z.number().optional(),
            }),
          ]),
        )
        .optional(),
      framework: z
        .union([
          z.literal('blitzjs'),
          z.literal('nextjs'),
          z.literal('gatsby'),
          z.literal('remix'),
          z.literal('astro'),
          z.literal('hexo'),
          z.literal('eleventy'),
          z.literal('docusaurus-2'),
          z.literal('docusaurus'),
          z.literal('preact'),
          z.literal('solidstart'),
          z.literal('dojo'),
          z.literal('ember'),
          z.literal('vue'),
          z.literal('scully'),
          z.literal('ionic-angular'),
          z.literal('angular'),
          z.literal('polymer'),
          z.literal('svelte'),
          z.literal('sveltekit'),
          z.literal('sveltekit-1'),
          z.literal('ionic-react'),
          z.literal('create-react-app'),
          z.literal('gridsome'),
          z.literal('umijs'),
          z.literal('sapper'),
          z.literal('saber'),
          z.literal('stencil'),
          z.literal('nuxtjs'),
          z.literal('redwoodjs'),
          z.literal('hugo'),
          z.literal('jekyll'),
          z.literal('brunch'),
          z.literal('middleman'),
          z.literal('zola'),
          z.literal('hydrogen'),
          z.literal('vite'),
          z.literal('vitepress'),
          z.literal('vuepress'),
          z.literal('parcel'),
          z.literal('sanity'),
        ])
        .optional()
        .nullable(),
      functions: z
        .record(
          z.object({
            excludeFiles: z.string().optional(),
            includeFiles: z.string().optional(),
            maxDuration: z.number().optional(),
            memory: z.number().optional(),
            runtime: z.string().optional(),
          }),
        )
        .optional(),
      git: z
        .object({
          deploymentEnabled: z.union([z.boolean(), z.record(z.boolean())]).optional(),
        })
        .optional(),
      gitMetadata: z
        .object({
          commitAuthorName: z.string().optional(),
          commitMessage: z.string().optional(),
          commitRef: z.string().optional(),
          commitSha: z.string().optional(),
          dirty: z.boolean().optional(),
          remoteUrl: z.string().optional(),
        })
        .optional(),
      gitSource: z
        .union([
          z.object({
            ref: z.string(),
            repoId: z.union([z.number(), z.string()]),
            sha: z.string().optional(),
            type: z.literal('github'),
          }),
          z.object({
            org: z.string(),
            ref: z.string(),
            repo: z.string(),
            sha: z.string().optional(),
            type: z.literal('github'),
          }),
          z.object({
            projectId: z.union([z.number(), z.string()]),
            ref: z.string(),
            sha: z.string().optional(),
            type: z.literal('gitlab'),
          }),
          z.object({
            ref: z.string(),
            repoUuid: z.string(),
            sha: z.string().optional(),
            type: z.literal('bitbucket'),
            workspaceUuid: z.string().optional(),
          }),
          z.object({
            owner: z.string(),
            ref: z.string(),
            sha: z.string().optional(),
            slug: z.string(),
            type: z.literal('bitbucket'),
          }),
        ])
        .optional(),
      headers: z
        .array(
          z.object({
            has: z
              .array(
                z.union([
                  z.object({
                    type: z.literal('host'),
                    value: z.string(),
                  }),
                  z.object({
                    key: z.string(),
                    type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            headers: z.array(
              z.object({
                key: z.string(),
                value: z.string(),
              }),
            ),
            missing: z
              .array(
                z.union([
                  z.object({
                    type: z.literal('host'),
                    value: z.string(),
                  }),
                  z.object({
                    key: z.string(),
                    type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            source: z.string(),
          }),
        )
        .optional(),
      ignoreCommand: z.string().optional().nullable(),
      images: z
        .object({
          contentDispositionType: z.union([z.literal('inline'), z.literal('attachment')]).optional(),
          contentSecurityPolicy: z.string().optional(),
          dangerouslyAllowSVG: z.boolean().optional(),
          domains: z.array(z.string()).optional(),
          formats: z
            .array(
              z.union([
                z.literal('image/avif'),
                z.literal('image/webp'),
                z.literal('image/jpeg'),
                z.literal('image/png'),
              ]),
            )
            .optional(),
          minimumCacheTTL: z.number().optional(),
          remotePatterns: z
            .array(
              z.object({
                hostname: z.string(),
                pathname: z.string().optional(),
                port: z.string().optional(),
                protocol: z.union([z.literal('http'), z.literal('https')]).optional(),
              }),
            )
            .optional(),
          sizes: z.array(z.number()),
        })
        .optional(),
      installCommand: z.string().optional().nullable(),
      meta: z.record(z.string()).optional(),
      monorepoManager: z.string().optional().nullable(),
      name: z.string(),
      outputDirectory: z.string().optional().nullable(),
      project: z.string().optional(),
      projectSettings: z
        .object({
          buildCommand: z.string().optional().nullable(),
          commandForIgnoringBuildStep: z.string().optional().nullable(),
          devCommand: z.string().optional().nullable(),
          framework: z
            .union([
              z.literal('blitzjs'),
              z.literal('nextjs'),
              z.literal('gatsby'),
              z.literal('remix'),
              z.literal('astro'),
              z.literal('hexo'),
              z.literal('eleventy'),
              z.literal('docusaurus-2'),
              z.literal('docusaurus'),
              z.literal('preact'),
              z.literal('solidstart'),
              z.literal('dojo'),
              z.literal('ember'),
              z.literal('vue'),
              z.literal('scully'),
              z.literal('ionic-angular'),
              z.literal('angular'),
              z.literal('polymer'),
              z.literal('svelte'),
              z.literal('sveltekit'),
              z.literal('sveltekit-1'),
              z.literal('ionic-react'),
              z.literal('create-react-app'),
              z.literal('gridsome'),
              z.literal('umijs'),
              z.literal('sapper'),
              z.literal('saber'),
              z.literal('stencil'),
              z.literal('nuxtjs'),
              z.literal('redwoodjs'),
              z.literal('hugo'),
              z.literal('jekyll'),
              z.literal('brunch'),
              z.literal('middleman'),
              z.literal('zola'),
              z.literal('hydrogen'),
              z.literal('vite'),
              z.literal('vitepress'),
              z.literal('vuepress'),
              z.literal('parcel'),
              z.literal('sanity'),
            ])
            .optional()
            .nullable(),
          installCommand: z.string().optional().nullable(),
          outputDirectory: z.string().optional().nullable(),
          rootDirectory: z.string().optional().nullable(),
          serverlessFunctionRegion: z.string().optional().nullable(),
          skipGitConnectDuringLink: z.boolean().optional(),
          sourceFilesOutsideRootDirectory: z.boolean().optional(),
        })
        .optional(),
      public: z.boolean().optional(),
      redirects: z
        .array(
          z.object({
            destination: z.string(),
            has: z
              .array(
                z.union([
                  z.object({
                    type: z.literal('host'),
                    value: z.string(),
                  }),
                  z.object({
                    key: z.string(),
                    type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            missing: z
              .array(
                z.union([
                  z.object({
                    type: z.literal('host'),
                    value: z.string(),
                  }),
                  z.object({
                    key: z.string(),
                    type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            permanent: z.boolean().optional(),
            source: z.string(),
          }),
        )
        .optional(),
      regions: z.array(z.string()).optional(),
      rewrites: z
        .array(
          z.object({
            destination: z.string(),
            has: z
              .array(
                z.union([
                  z.object({
                    type: z.literal('host'),
                    value: z.string(),
                  }),
                  z.object({
                    key: z.string(),
                    type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            missing: z
              .array(
                z.union([
                  z.object({
                    type: z.literal('host'),
                    value: z.string(),
                  }),
                  z.object({
                    key: z.string(),
                    type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            source: z.string(),
          }),
        )
        .optional(),
      routes: z
        .array(
          z.union([
            z.object({
              caseSensitive: z.boolean().optional(),
              check: z.boolean().optional(),
              continue: z.boolean().optional(),
              dest: z.string().optional(),
              has: z
                .array(
                  z.union([
                    z.object({
                      type: z.literal('host'),
                      value: z.string(),
                    }),
                    z.object({
                      key: z.string(),
                      type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                      value: z.string().optional(),
                    }),
                  ]),
                )
                .optional(),
              headers: z.record(z.string()).optional(),
              important: z.boolean().optional(),
              isInternal: z.boolean().optional(),
              locale: z
                .object({
                  cookie: z.string().optional(),
                  default: z.string().optional(),
                  path: z.string().optional(),
                  redirect: z.record(z.string()).optional(),
                  value: z.string().optional(),
                })
                .optional(),
              methods: z.array(z.string()).optional(),
              middleware: z.number().optional(),
              middlewarePath: z.string().optional(),
              middlewareRawSrc: z.array(z.string()).optional(),
              missing: z
                .array(
                  z.union([
                    z.object({
                      type: z.literal('host'),
                      value: z.string(),
                    }),
                    z.object({
                      key: z.string(),
                      type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                      value: z.string().optional(),
                    }),
                  ]),
                )
                .optional(),
              override: z.boolean().optional(),
              src: z.string(),
              status: z.number().optional(),
              user: z.boolean().optional(),
            }),
            z.object({
              handle: z.union([
                z.literal('error'),
                z.literal('filesystem'),
                z.literal('hit'),
                z.literal('miss'),
                z.literal('resource'),
                z.literal('rewrite'),
              ]),
            }),
          ]),
        )
        .optional(),
      target: z.union([z.literal('staging'), z.literal('production')]).optional(),
      trailingSlash: z.boolean().optional(),
      withLatestCommit: z.boolean().optional(),
    })
    .optional(),
  query: z
    .object({
      forceNew: z.union([z.literal('0'), z.literal('1')]).optional(),
      skipAutoDetectionConfirmation: z.union([z.literal('0'), z.literal('1')]).optional(),
      teamId: z.string().optional(),
    })
    .optional(),
});

export const createDeploymentResponseSchema = z.object({
  alias: z.array(z.string()),
  aliasAssigned: z.boolean(),
  aliasAssignedAt: z.union([z.number(), z.boolean()]).optional().nullable(),
  aliasError: z
    .object({
      code: z.string(),
      message: z.string(),
    })
    .optional()
    .nullable(),
  aliasFinal: z.string().optional().nullable(),
  aliasWarning: z
    .object({
      action: z.string().optional(),
      code: z.string(),
      link: z.string().optional(),
      message: z.string(),
    })
    .optional()
    .nullable(),
  automaticAliases: z.array(z.string()).optional(),
  bootedAt: z.number(),
  build: z.object({
    env: z.array(z.string()),
  }),
  buildErrorAt: z.number().optional(),
  buildingAt: z.number(),
  builds: z.array(z.record(z.unknown())).optional(),
  canceledAt: z.number().optional(),
  checksConclusion: z
    .union([z.literal('succeeded'), z.literal('failed'), z.literal('skipped'), z.literal('canceled')])
    .optional(),
  checksState: z.union([z.literal('registered'), z.literal('running'), z.literal('completed')]).optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.object({
    uid: z.string(),
    username: z.string().optional(),
  }),
  env: z.array(z.string()),
  errorCode: z.string().optional(),
  errorLink: z.string().optional(),
  errorMessage: z.string().optional().nullable(),
  errorStep: z.string().optional(),
  functions: z
    .record(
      z.object({
        excludeFiles: z.string().optional(),
        includeFiles: z.string().optional(),
        maxDuration: z.number().optional(),
        memory: z.number().optional(),
        runtime: z.string().optional(),
      }),
    )
    .optional()
    .nullable(),
  gitRepo: z
    .union([
      z.object({
        defaultBranch: z.string(),
        name: z.string(),
        namespace: z.string(),
        ownerType: z.union([z.literal('team'), z.literal('user')]),
        path: z.string(),
        private: z.boolean(),
        projectId: z.number(),
        type: z.literal('gitlab'),
        url: z.string(),
      }),
      z.object({
        defaultBranch: z.string(),
        name: z.string(),
        org: z.string(),
        ownerType: z.union([z.literal('team'), z.literal('user')]),
        path: z.string(),
        private: z.boolean(),
        repo: z.string(),
        repoId: z.number(),
        repoOwnerId: z.string(),
        type: z.literal('github'),
      }),
      z.object({
        defaultBranch: z.string(),
        name: z.string(),
        owner: z.string(),
        ownerType: z.union([z.literal('team'), z.literal('user')]),
        path: z.string(),
        private: z.boolean(),
        repoUuid: z.string(),
        slug: z.string(),
        type: z.literal('bitbucket'),
        workspaceUuid: z.string(),
      }),
    ])
    .optional()
    .nullable(),
  gitSource: z
    .union([
      z.object({
        prId: z.number().optional().nullable(),
        ref: z.string().optional().nullable(),
        repoId: z.union([z.string(), z.number()]),
        sha: z.string().optional(),
        type: z.literal('github'),
      }),
      z.object({
        org: z.string(),
        prId: z.number().optional().nullable(),
        ref: z.string().optional().nullable(),
        repo: z.string(),
        sha: z.string().optional(),
        type: z.literal('github'),
      }),
      z.object({
        prId: z.number().optional().nullable(),
        projectId: z.union([z.string(), z.number()]),
        ref: z.string().optional().nullable(),
        sha: z.string().optional(),
        type: z.literal('gitlab'),
      }),
      z.object({
        prId: z.number().optional().nullable(),
        ref: z.string().optional().nullable(),
        repoUuid: z.string(),
        sha: z.string().optional(),
        type: z.literal('bitbucket'),
        workspaceUuid: z.string().optional(),
      }),
      z.object({
        owner: z.string(),
        prId: z.number().optional().nullable(),
        ref: z.string().optional().nullable(),
        sha: z.string().optional(),
        slug: z.string(),
        type: z.literal('bitbucket'),
      }),
      z.object({
        gitUrl: z.string(),
        ref: z.string(),
        sha: z.string(),
        type: z.literal('custom'),
      }),
      z.object({
        org: z.string().optional(),
        ref: z.string(),
        repo: z.string().optional(),
        repoId: z.number(),
        sha: z.string(),
        type: z.literal('github'),
      }),
      z.object({
        projectId: z.number(),
        ref: z.string(),
        sha: z.string(),
        type: z.literal('gitlab'),
      }),
      z.object({
        owner: z.string().optional(),
        ref: z.string(),
        repoUuid: z.string(),
        sha: z.string(),
        slug: z.string().optional(),
        type: z.literal('bitbucket'),
        workspaceUuid: z.string(),
      }),
    ])
    .optional(),
  id: z.string(),
  inspectorUrl: z.string().nullable(),
  isInConcurrentBuildsQueue: z.boolean(),
  lambdas: z
    .array(
      z.object({
        createdAt: z.number().optional(),
        entrypoint: z.string().optional().nullable(),
        id: z.string(),
        output: z.array(
          z.object({
            functionName: z.string(),
            path: z.string(),
          }),
        ),
        readyState: z
          .union([z.literal('BUILDING'), z.literal('ERROR'), z.literal('INITIALIZING'), z.literal('READY')])
          .optional(),
        readyStateAt: z.number().optional(),
      }),
    )
    .optional(),
  meta: z.record(z.string()),
  monorepoManager: z.string().optional().nullable(),
  name: z.string(),
  ownerId: z.string(),
  plan: z.union([z.literal('hobby'), z.literal('enterprise'), z.literal('pro'), z.literal('oss')]),
  previewCommentsEnabled: z.boolean().optional(),
  projectId: z.string(),
  public: z.boolean(),
  readyState: z.union([
    z.literal('QUEUED'),
    z.literal('BUILDING'),
    z.literal('ERROR'),
    z.literal('INITIALIZING'),
    z.literal('READY'),
    z.literal('CANCELED'),
  ]),
  regions: z.array(z.string()),
  routes: z
    .array(
      z.union([
        z.object({
          caseSensitive: z.boolean().optional(),
          check: z.boolean().optional(),
          continue: z.boolean().optional(),
          dest: z.string().optional(),
          has: z
            .array(
              z.union([
                z.object({
                  type: z.literal('host'),
                  value: z.string(),
                }),
                z.object({
                  key: z.string(),
                  type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          headers: z.record(z.string()).optional(),
          important: z.boolean().optional(),
          locale: z
            .object({
              cookie: z.string().optional(),
              redirect: z.record(z.string()).optional(),
            })
            .optional(),
          methods: z.array(z.string()).optional(),
          middleware: z.number().optional(),
          middlewarePath: z.string().optional(),
          middlewareRawSrc: z.array(z.string()).optional(),
          missing: z
            .array(
              z.union([
                z.object({
                  type: z.literal('host'),
                  value: z.string(),
                }),
                z.object({
                  key: z.string(),
                  type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          override: z.boolean().optional(),
          src: z.string(),
          status: z.number().optional(),
        }),
        z.object({
          dest: z.string().optional(),
          handle: z.union([
            z.literal('filesystem'),
            z.literal('hit'),
            z.literal('miss'),
            z.literal('rewrite'),
            z.literal('error'),
            z.literal('resource'),
          ]),
          src: z.string().optional(),
          status: z.number().optional(),
        }),
        z.object({
          continue: z.boolean(),
          middleware: z.literal(0),
          src: z.string(),
        }),
      ]),
    )
    .nullable(),
  source: z
    .union([z.literal('cli'), z.literal('git'), z.literal('import'), z.literal('import/repo'), z.literal('clone/repo')])
    .optional(),
  target: z
    .union([z.literal('production'), z.literal('staging')])
    .optional()
    .nullable(),
  team: z
    .object({
      id: z.string(),
      name: z.string(),
      slug: z.string(),
    })
    .optional(),
  type: z.literal('LAMBDAS'),
  url: z.string(),
  userAliases: z.array(z.string()).optional(),
  version: z.literal(2),
});

export const createDeploymentErrorSchema = z.unknown();

export const getDeploymentDataSchema = z.object({
  path: z.object({
    idOrUrl: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
      withGitRepoInfo: z.string().optional(),
    })
    .optional(),
});

export const getDeploymentResponseSchema = z.union([
  z.object({
    alias: z.array(z.string()),
    aliasAssigned: z.boolean(),
    aliasAssignedAt: z.union([z.number(), z.boolean()]).optional().nullable(),
    aliasError: z
      .object({
        code: z.string(),
        message: z.string(),
      })
      .optional()
      .nullable(),
    aliasFinal: z.string().optional().nullable(),
    aliasWarning: z
      .object({
        action: z.string().optional(),
        code: z.string(),
        link: z.string().optional(),
        message: z.string(),
      })
      .optional()
      .nullable(),
    automaticAliases: z.array(z.string()).optional(),
    bootedAt: z.number(),
    build: z.object({
      env: z.array(z.string()),
    }),
    buildErrorAt: z.number().optional(),
    buildingAt: z.number(),
    builds: z.array(z.record(z.unknown())).optional(),
    canceledAt: z.number().optional(),
    checksConclusion: z
      .union([z.literal('succeeded'), z.literal('failed'), z.literal('skipped'), z.literal('canceled')])
      .optional(),
    checksState: z.union([z.literal('registered'), z.literal('running'), z.literal('completed')]).optional(),
    connectConfigurationId: z.string().optional(),
    createdAt: z.number(),
    createdIn: z.string(),
    creator: z.object({
      uid: z.string(),
      username: z.string().optional(),
    }),
    env: z.array(z.string()),
    errorCode: z.string().optional(),
    errorLink: z.string().optional(),
    errorMessage: z.string().optional().nullable(),
    errorStep: z.string().optional(),
    functions: z
      .record(
        z.object({
          excludeFiles: z.string().optional(),
          includeFiles: z.string().optional(),
          maxDuration: z.number().optional(),
          memory: z.number().optional(),
          runtime: z.string().optional(),
        }),
      )
      .optional()
      .nullable(),
    gitRepo: z
      .union([
        z.object({
          defaultBranch: z.string(),
          name: z.string(),
          namespace: z.string(),
          ownerType: z.union([z.literal('team'), z.literal('user')]),
          path: z.string(),
          private: z.boolean(),
          projectId: z.number(),
          type: z.literal('gitlab'),
          url: z.string(),
        }),
        z.object({
          defaultBranch: z.string(),
          name: z.string(),
          org: z.string(),
          ownerType: z.union([z.literal('team'), z.literal('user')]),
          path: z.string(),
          private: z.boolean(),
          repo: z.string(),
          repoId: z.number(),
          repoOwnerId: z.string(),
          type: z.literal('github'),
        }),
        z.object({
          defaultBranch: z.string(),
          name: z.string(),
          owner: z.string(),
          ownerType: z.union([z.literal('team'), z.literal('user')]),
          path: z.string(),
          private: z.boolean(),
          repoUuid: z.string(),
          slug: z.string(),
          type: z.literal('bitbucket'),
          workspaceUuid: z.string(),
        }),
      ])
      .optional()
      .nullable(),
    gitSource: z
      .union([
        z.object({
          prId: z.number().optional().nullable(),
          ref: z.string().optional().nullable(),
          repoId: z.union([z.string(), z.number()]),
          sha: z.string().optional(),
          type: z.literal('github'),
        }),
        z.object({
          org: z.string(),
          prId: z.number().optional().nullable(),
          ref: z.string().optional().nullable(),
          repo: z.string(),
          sha: z.string().optional(),
          type: z.literal('github'),
        }),
        z.object({
          prId: z.number().optional().nullable(),
          projectId: z.union([z.string(), z.number()]),
          ref: z.string().optional().nullable(),
          sha: z.string().optional(),
          type: z.literal('gitlab'),
        }),
        z.object({
          prId: z.number().optional().nullable(),
          ref: z.string().optional().nullable(),
          repoUuid: z.string(),
          sha: z.string().optional(),
          type: z.literal('bitbucket'),
          workspaceUuid: z.string().optional(),
        }),
        z.object({
          owner: z.string(),
          prId: z.number().optional().nullable(),
          ref: z.string().optional().nullable(),
          sha: z.string().optional(),
          slug: z.string(),
          type: z.literal('bitbucket'),
        }),
        z.object({
          gitUrl: z.string(),
          ref: z.string(),
          sha: z.string(),
          type: z.literal('custom'),
        }),
        z.object({
          org: z.string().optional(),
          ref: z.string(),
          repo: z.string().optional(),
          repoId: z.number(),
          sha: z.string(),
          type: z.literal('github'),
        }),
        z.object({
          projectId: z.number(),
          ref: z.string(),
          sha: z.string(),
          type: z.literal('gitlab'),
        }),
        z.object({
          owner: z.string().optional(),
          ref: z.string(),
          repoUuid: z.string(),
          sha: z.string(),
          slug: z.string().optional(),
          type: z.literal('bitbucket'),
          workspaceUuid: z.string(),
        }),
      ])
      .optional(),
    id: z.string(),
    inspectorUrl: z.string().nullable(),
    isInConcurrentBuildsQueue: z.boolean(),
    lambdas: z
      .array(
        z.object({
          createdAt: z.number().optional(),
          entrypoint: z.string().optional().nullable(),
          id: z.string(),
          output: z.array(
            z.object({
              functionName: z.string(),
              path: z.string(),
            }),
          ),
          readyState: z
            .union([z.literal('BUILDING'), z.literal('ERROR'), z.literal('INITIALIZING'), z.literal('READY')])
            .optional(),
          readyStateAt: z.number().optional(),
        }),
      )
      .optional(),
    meta: z.record(z.string()),
    monorepoManager: z.string().optional().nullable(),
    name: z.string(),
    ownerId: z.string(),
    plan: z.union([z.literal('hobby'), z.literal('enterprise'), z.literal('pro'), z.literal('oss')]),
    previewCommentsEnabled: z.boolean().optional(),
    projectId: z.string(),
    public: z.boolean(),
    readyState: z.union([
      z.literal('QUEUED'),
      z.literal('BUILDING'),
      z.literal('ERROR'),
      z.literal('INITIALIZING'),
      z.literal('READY'),
      z.literal('CANCELED'),
    ]),
    regions: z.array(z.string()),
    routes: z
      .array(
        z.union([
          z.object({
            caseSensitive: z.boolean().optional(),
            check: z.boolean().optional(),
            continue: z.boolean().optional(),
            dest: z.string().optional(),
            has: z
              .array(
                z.union([
                  z.object({
                    type: z.literal('host'),
                    value: z.string(),
                  }),
                  z.object({
                    key: z.string(),
                    type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            headers: z.record(z.string()).optional(),
            important: z.boolean().optional(),
            locale: z
              .object({
                cookie: z.string().optional(),
                redirect: z.record(z.string()).optional(),
              })
              .optional(),
            methods: z.array(z.string()).optional(),
            middleware: z.number().optional(),
            middlewarePath: z.string().optional(),
            middlewareRawSrc: z.array(z.string()).optional(),
            missing: z
              .array(
                z.union([
                  z.object({
                    type: z.literal('host'),
                    value: z.string(),
                  }),
                  z.object({
                    key: z.string(),
                    type: z.union([z.literal('header'), z.literal('cookie'), z.literal('query')]),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            override: z.boolean().optional(),
            src: z.string(),
            status: z.number().optional(),
          }),
          z.object({
            dest: z.string().optional(),
            handle: z.union([
              z.literal('filesystem'),
              z.literal('hit'),
              z.literal('miss'),
              z.literal('rewrite'),
              z.literal('error'),
              z.literal('resource'),
            ]),
            src: z.string().optional(),
            status: z.number().optional(),
          }),
          z.object({
            continue: z.boolean(),
            middleware: z.literal(0),
            src: z.string(),
          }),
        ]),
      )
      .nullable(),
    source: z
      .union([
        z.literal('cli'),
        z.literal('git'),
        z.literal('import'),
        z.literal('import/repo'),
        z.literal('clone/repo'),
      ])
      .optional(),
    target: z
      .union([z.literal('production'), z.literal('staging')])
      .optional()
      .nullable(),
    team: z
      .object({
        id: z.string(),
        name: z.string(),
        slug: z.string(),
      })
      .optional(),
    type: z.literal('LAMBDAS'),
    url: z.string(),
    userAliases: z.array(z.string()).optional(),
    version: z.literal(2),
  }),
  z.object({
    alias: z.array(z.string()),
    aliasAssigned: z.boolean(),
    aliasError: z
      .object({
        code: z.string(),
        message: z.string(),
      })
      .optional()
      .nullable(),
    aliasFinal: z.string().optional().nullable(),
    aliasWarning: z
      .object({
        action: z.string().optional(),
        code: z.string(),
        link: z.string().optional(),
        message: z.string(),
      })
      .optional()
      .nullable(),
    automaticAliases: z.array(z.string()).optional(),
    bootedAt: z.number(),
    buildErrorAt: z.number().optional(),
    buildingAt: z.number(),
    canceledAt: z.number().optional(),
    checksConclusion: z
      .union([z.literal('succeeded'), z.literal('failed'), z.literal('skipped'), z.literal('canceled')])
      .optional(),
    checksState: z.union([z.literal('registered'), z.literal('running'), z.literal('completed')]).optional(),
    createdAt: z.number(),
    creator: z.object({
      uid: z.string(),
      username: z.string().optional(),
    }),
    errorCode: z.string().optional(),
    errorLink: z.string().optional(),
    errorMessage: z.string().optional().nullable(),
    errorStep: z.string().optional(),
    gitSource: z
      .union([
        z.object({
          prId: z.number().optional().nullable(),
          ref: z.string().optional().nullable(),
          repoId: z.union([z.string(), z.number()]),
          sha: z.string().optional(),
          type: z.literal('github'),
        }),
        z.object({
          org: z.string(),
          prId: z.number().optional().nullable(),
          ref: z.string().optional().nullable(),
          repo: z.string(),
          sha: z.string().optional(),
          type: z.literal('github'),
        }),
        z.object({
          prId: z.number().optional().nullable(),
          projectId: z.union([z.string(), z.number()]),
          ref: z.string().optional().nullable(),
          sha: z.string().optional(),
          type: z.literal('gitlab'),
        }),
        z.object({
          prId: z.number().optional().nullable(),
          ref: z.string().optional().nullable(),
          repoUuid: z.string(),
          sha: z.string().optional(),
          type: z.literal('bitbucket'),
          workspaceUuid: z.string().optional(),
        }),
        z.object({
          owner: z.string(),
          prId: z.number().optional().nullable(),
          ref: z.string().optional().nullable(),
          sha: z.string().optional(),
          slug: z.string(),
          type: z.literal('bitbucket'),
        }),
        z.object({
          gitUrl: z.string(),
          ref: z.string(),
          sha: z.string(),
          type: z.literal('custom'),
        }),
        z.object({
          org: z.string().optional(),
          ref: z.string(),
          repo: z.string().optional(),
          repoId: z.number(),
          sha: z.string(),
          type: z.literal('github'),
        }),
        z.object({
          projectId: z.number(),
          ref: z.string(),
          sha: z.string(),
          type: z.literal('gitlab'),
        }),
        z.object({
          owner: z.string().optional(),
          ref: z.string(),
          repoUuid: z.string(),
          sha: z.string(),
          slug: z.string().optional(),
          type: z.literal('bitbucket'),
          workspaceUuid: z.string(),
        }),
      ])
      .optional(),
    id: z.string(),
    lambdas: z
      .array(
        z.object({
          createdAt: z.number().optional(),
          entrypoint: z.string().optional().nullable(),
          id: z.string(),
          output: z.array(
            z.object({
              functionName: z.string(),
              path: z.string(),
            }),
          ),
          readyState: z
            .union([z.literal('BUILDING'), z.literal('ERROR'), z.literal('INITIALIZING'), z.literal('READY')])
            .optional(),
          readyStateAt: z.number().optional(),
        }),
      )
      .optional(),
    meta: z.record(z.string()),
    name: z.string(),
    previewCommentsEnabled: z.boolean().optional(),
    public: z.boolean(),
    readyState: z.union([
      z.literal('QUEUED'),
      z.literal('BUILDING'),
      z.literal('ERROR'),
      z.literal('INITIALIZING'),
      z.literal('READY'),
      z.literal('CANCELED'),
    ]),
    regions: z.array(z.string()),
    source: z
      .union([
        z.literal('cli'),
        z.literal('git'),
        z.literal('import'),
        z.literal('import/repo'),
        z.literal('clone/repo'),
      ])
      .optional(),
    target: z
      .union([z.literal('production'), z.literal('staging')])
      .optional()
      .nullable(),
    team: z
      .object({
        id: z.string(),
        name: z.string(),
        slug: z.string(),
      })
      .optional(),
    type: z.literal('LAMBDAS'),
    url: z.string(),
    userAliases: z.array(z.string()).optional(),
    version: z.literal(2),
  }),
]);

export const getDeploymentErrorSchema = z.unknown();

export const deleteDeploymentDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
      url: z.string().optional(),
    })
    .optional(),
});

export const deleteDeploymentResponseSchema = z.object({
  state: z.literal('DELETED'),
  uid: z.string(),
});

export const deleteDeploymentErrorSchema = z.unknown();

export const deleteAliasDataSchema = z.object({
  path: z.object({
    aliasId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const deleteAliasResponseSchema = z.object({
  status: z.literal('SUCCESS'),
});

export const deleteAliasErrorSchema = z.unknown();

export const getDeploymentEventsDataSchema = z.object({
  path: z.object({
    idOrUrl: z.string(),
  }),
  query: z
    .object({
      builds: z.union([z.literal(0), z.literal(1)]).optional(),
      delimiter: z.union([z.literal(0), z.literal(1)]).optional(),
      direction: z.union([z.literal('backward'), z.literal('forward')]).optional(),
      follow: z.union([z.literal(0), z.literal(1)]).optional(),
      limit: z.number().optional(),
      name: z.string().optional(),
      since: z.number().optional(),
      statusCode: z.union([z.number(), z.string()]).optional(),
      teamId: z.string().optional(),
      until: z.number().optional(),
    })
    .optional(),
});

export const getDeploymentEventsResponseSchema = z.array(
  z.union([
    z.object({
      created: z.number(),
      payload: z.object({
        date: z.number(),
        deploymentId: z.string(),
        id: z.string(),
        serial: z.string(),
        text: z.string().optional(),
      }),
      type: z.literal('command'),
    }),
    z.object({
      created: z.number(),
      payload: z.object({
        date: z.number(),
        deploymentId: z.string(),
        id: z.string(),
        info: z.object({
          entrypoint: z.string().optional(),
          name: z.string(),
          path: z.string().optional(),
          step: z.string().optional(),
          type: z.string(),
        }),
        serial: z.string(),
      }),
      type: z.literal('deployment-state'),
    }),
    z.object({
      created: z.number(),
      payload: z.object({
        date: z.number(),
        deploymentId: z.string(),
        id: z.string(),
        info: z.object({
          entrypoint: z.string().optional(),
          name: z.string(),
          path: z.string().optional(),
          step: z.string().optional(),
          type: z.string(),
        }),
        serial: z.string(),
      }),
      type: z.literal('delimiter'),
    }),
    z.object({
      created: z.number(),
      payload: z.object({
        created: z.number(),
        date: z.number(),
        deploymentId: z.string(),
        id: z.string(),
        serial: z.string(),
        text: z.string().optional(),
      }),
      type: z.literal('exit'),
    }),
    z.object({
      created: z.number(),
      payload: z.object({
        date: z.number(),
        deploymentId: z.string(),
        id: z.string(),
        info: z.object({
          entrypoint: z.string().optional(),
          name: z.string(),
          path: z.string().optional(),
          step: z.string().optional(),
          type: z.string(),
        }),
        requestId: z.string().optional(),
        serial: z.string(),
        text: z.string().optional(),
      }),
      type: z.literal('middleware'),
    }),
    z.object({
      created: z.number(),
      payload: z.object({
        date: z.number(),
        deploymentId: z.string(),
        id: z.string(),
        info: z.object({
          entrypoint: z.string().optional(),
          name: z.string(),
          path: z.string().optional(),
          step: z.string().optional(),
          type: z.string(),
        }),
        requestId: z.string().optional(),
        serial: z.string(),
        statusCode: z.number().optional(),
        text: z.string().optional(),
      }),
      type: z.union([
        z.literal('command'),
        z.literal('stdout'),
        z.literal('stderr'),
        z.literal('exit'),
        z.literal('deployment-state'),
        z.literal('delimiter'),
        z.literal('middleware'),
        z.literal('middleware-invocation'),
        z.literal('edge-function-invocation'),
        z.literal('fatal'),
      ]),
    }),
  ]),
);

export const getDeploymentEventsErrorSchema = z.unknown();

export const listDeploymentAliasesDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const listDeploymentAliasesResponseSchema = z.object({
  aliases: z.array(
    z.object({
      alias: z.string(),
      created: z.string(),
      protectionBypass: z.record(z.string()).optional(),
      redirect: z.string().optional().nullable(),
      uid: z.string(),
    }),
  ),
});

export const listDeploymentAliasesErrorSchema = z.unknown();

export const assignAliasDataSchema = z.object({
  body: z
    .object({
      alias: z.string().optional(),
      redirect: z.string().optional().nullable(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const assignAliasResponseSchema = z.object({
  alias: z.string(),
  created: z.string(),
  oldDeploymentId: z.string().optional().nullable(),
  uid: z.string(),
});

export const assignAliasErrorSchema = z.unknown();

export const createRecordDataSchema = z.object({
  body: z
    .union([
      z.object({
        name: z.string(),
        ttl: z.number().optional(),
        type: z.literal('A'),
        value: z.string(),
      }),
      z.object({
        name: z.string(),
        ttl: z.number().optional(),
        type: z.literal('AAAA'),
        value: z.string(),
      }),
      z.object({
        name: z.string(),
        ttl: z.number().optional(),
        type: z.literal('ALIAS'),
        value: z.string(),
      }),
      z.object({
        name: z.string(),
        ttl: z.number().optional(),
        type: z.literal('CAA'),
        value: z.string(),
      }),
      z.object({
        name: z.string(),
        ttl: z.number().optional(),
        type: z.literal('CNAME'),
        value: z.string().optional(),
      }),
      z.object({
        mxPriority: z.number(),
        name: z.string(),
        ttl: z.number().optional(),
        type: z.literal('MX'),
        value: z.string(),
      }),
      z.object({
        name: z.string(),
        srv: z.object({
          port: z.number().nullable(),
          priority: z.number().nullable(),
          target: z.string().optional(),
          weight: z.number().nullable(),
        }),
        ttl: z.number().optional(),
        type: z.literal('SRV'),
      }),
      z.object({
        name: z.string(),
        ttl: z.number().optional(),
        type: z.literal('TXT'),
        value: z.string(),
      }),
      z.object({
        name: z.string(),
        ttl: z.number().optional(),
        type: z.literal('NS'),
        value: z.string().optional(),
      }),
      z.object({
        type: z.union([
          z.literal('A'),
          z.literal('AAAA'),
          z.literal('ALIAS'),
          z.literal('CAA'),
          z.literal('CNAME'),
          z.literal('MX'),
          z.literal('SRV'),
          z.literal('TXT'),
          z.literal('NS'),
        ]),
      }),
    ])
    .optional(),
  path: z.object({
    domain: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const createRecordResponseSchema = z.union([
  z.object({
    uid: z.string(),
    updated: z.number(),
  }),
  z.object({
    uid: z.string(),
  }),
]);

export const createRecordErrorSchema = z.unknown();

export const removeRecordDataSchema = z.object({
  path: z.object({
    domain: z.string(),
    recordId: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const removeRecordResponseSchema = z.record(z.unknown());

export const removeRecordErrorSchema = z.unknown();

export const uploadFileDataSchema = z.object({
  headers: z
    .object({
      'Content-Length': z.number().optional(),
      'x-now-digest': z.string().optional(),
      'x-now-size': z.number().optional(),
      'x-vercel-digest': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const uploadFileResponseSchema = z.union([
  z.object({
    urls: z.array(z.string()),
  }),
  z.record(z.unknown()),
]);

export const uploadFileErrorSchema = z.unknown();

export const getIntegrationLogDrainsDataSchema = z.object({
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getIntegrationLogDrainsResponseSchema = z.array(
  z.object({
    branch: z.string().optional(),
    clientId: z.string().optional(),
    configurationId: z.string().optional(),
    createdAt: z.number(),
    createdFrom: z.union([z.literal('self-served'), z.literal('integration')]).optional(),
    deliveryFormat: z.union([z.literal('json'), z.literal('ndjson'), z.literal('syslog')]).optional(),
    environment: z.union([z.literal('production'), z.literal('preview')]).optional(),
    headers: z.record(z.string()).optional(),
    id: z.string(),
    name: z.string(),
    ownerId: z.string(),
    projectId: z.string().optional().nullable(),
    projectIds: z.array(z.string()).optional(),
    sources: z
      .array(
        z.union([
          z.literal('static'),
          z.literal('lambda'),
          z.literal('build'),
          z.literal('edge'),
          z.literal('external'),
          z.literal('deployment'),
        ]),
      )
      .optional(),
    url: z.string(),
  }),
);

export const getIntegrationLogDrainsErrorSchema = z.unknown();

export const createLogDrainDataSchema = z.object({
  body: z
    .object({
      branch: z.string().optional(),
      deliveryFormat: z.union([z.literal('json'), z.literal('ndjson'), z.literal('syslog')]).optional(),
      environment: z.union([z.literal('preview'), z.literal('production')]).optional(),
      headers: z.record(z.string()).optional(),
      name: z.string(),
      projectIds: z.array(z.string()).optional(),
      secret: z.string().optional(),
      sources: z
        .array(
          z.union([
            z.literal('static'),
            z.literal('lambda'),
            z.literal('build'),
            z.literal('edge'),
            z.literal('external'),
          ]),
        )
        .optional(),
      url: z.string(),
    })
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const createLogDrainResponseSchema = z.object({
  branch: z.string().optional(),
  clientId: z.string().optional(),
  configurationId: z.string().optional(),
  createdAt: z.number(),
  createdFrom: z.union([z.literal('self-served'), z.literal('integration')]).optional(),
  deliveryFormat: z.union([z.literal('json'), z.literal('ndjson'), z.literal('syslog')]).optional(),
  environment: z.union([z.literal('preview'), z.literal('production')]).optional(),
  headers: z.record(z.string()).optional(),
  id: z.string(),
  name: z.string(),
  ownerId: z.string(),
  projectId: z.string().optional().nullable(),
  projectIds: z.array(z.string()).optional(),
  sources: z
    .array(
      z.union([
        z.literal('static'),
        z.literal('lambda'),
        z.literal('build'),
        z.literal('edge'),
        z.literal('external'),
        z.literal('deployment'),
      ]),
    )
    .optional(),
  url: z.string(),
});

export const createLogDrainErrorSchema = z.unknown();

export const deleteSecretDataSchema = z.object({
  path: z.object({
    idOrName: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const deleteSecretResponseSchema = z.object({
  created: z.number(),
  name: z.string(),
  uid: z.string(),
});

export const deleteSecretErrorSchema = z.unknown();

export const renameSecretDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
    })
    .optional(),
  path: z.object({
    name: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const renameSecretResponseSchema = z.object({
  created: z.string(),
  name: z.string(),
  oldName: z.string(),
  uid: z.string(),
});

export const renameSecretErrorSchema = z.unknown();

export const createSecretDataSchema = z.object({
  body: z
    .object({
      decryptable: z.boolean().optional(),
      name: z.string(),
      projectId: z.string().optional(),
      value: z.string(),
    })
    .optional(),
  path: z.object({
    name: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const createSecretResponseSchema = z.object({
  created: z.string(),
  createdAt: z.number().optional(),
  decryptable: z.boolean().optional(),
  name: z.string(),
  projectId: z.string().optional(),
  teamId: z.string().optional().nullable(),
  uid: z.string(),
  userId: z.string().optional(),
  value: z.object({
    data: z.array(z.number()).optional(),
    type: z.literal('Buffer').optional(),
  }),
});

export const createSecretErrorSchema = z.unknown();

export const getTeamsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      since: z.number().optional(),
      until: z.number().optional(),
    })
    .optional(),
});

export const getTeamsResponseSchema = z.object({
  pagination: paginationSchema,
  teams: z.array(z.union([teamSchema, teamLimitedSchema])),
});

export const getTeamsErrorSchema = z.unknown();

export const getTeamDataSchema = z.object({
  path: z.object({
    teamId: z.string(),
  }),
  query: z
    .object({
      slug: z.string().optional(),
    })
    .optional(),
});

export const getTeamResponseSchema = teamSchema;

export const getTeamErrorSchema = z.unknown();

export const patchTeamDataSchema = z.object({
  body: z
    .object({
      avatar: z.string().optional(),
      description: z.string().optional(),
      emailDomain: z.string().optional().nullable(),
      enablePreviewFeedback: z.string().optional(),
      migrateExistingEnvVariablesToSensitive: z.boolean().optional(),
      name: z.string().optional(),
      previewDeploymentSuffix: z.string().optional().nullable(),
      regenerateInviteCode: z.boolean().optional(),
      remoteCaching: z
        .object({
          enabled: z.boolean().optional(),
        })
        .optional(),
      saml: z
        .object({
          enforced: z.boolean().optional(),
          roles: z
            .record(
              z.union([
                z.literal('OWNER'),
                z.literal('MEMBER'),
                z.literal('VIEWER'),
                z.literal('DEVELOPER'),
                z.literal('BILLING'),
              ]),
            )
            .optional(),
        })
        .optional(),
      sensitiveEnvironmentVariablePolicy: z.string().optional(),
      slug: z.string().optional(),
    })
    .optional(),
  path: z.object({
    teamId: z.string(),
  }),
});

export const patchTeamResponseSchema = teamSchema;

export const patchTeamErrorSchema = z.unknown();

export const getTeamMembersDataSchema = z.object({
  path: z.object({
    teamId: z.string(),
  }),
  query: z
    .object({
      excludeProject: z.string().optional(),
      limit: z.number().optional(),
      role: z.union([z.literal('OWNER'), z.literal('MEMBER'), z.literal('DEVELOPER'), z.literal('VIEWER')]).optional(),
      search: z.string().optional(),
      since: z.number().optional(),
      until: z.number().optional(),
    })
    .optional(),
});

export const getTeamMembersResponseSchema = z.object({
  emailInviteCodes: z
    .array(
      z.object({
        createdAt: z.number().optional(),
        email: z.string().optional(),
        id: z.string(),
        isDSyncUser: z.boolean(),
        role: z
          .union([
            z.literal('MEMBER'),
            z.literal('OWNER'),
            z.literal('VIEWER'),
            z.literal('DEVELOPER'),
            z.literal('BILLING'),
          ])
          .optional(),
      }),
    )
    .optional(),
  members: z.array(
    z.object({
      accessRequestedAt: z.number().optional(),
      avatar: z.string().optional(),
      bitbucket: z
        .object({
          accountId: z.string().optional(),
          email: z.string().optional(),
          login: z.string().optional(),
          userId: z.number().optional(),
        })
        .optional(),
      confirmed: z.boolean(),
      createdAt: z.number(),
      email: z.string(),
      github: z
        .object({
          accountId: z.string().optional(),
          email: z.string().optional(),
          login: z.string().optional(),
          userId: z.number().optional(),
        })
        .optional(),
      gitlab: z
        .object({
          accountId: z.string().optional(),
          email: z.string().optional(),
          login: z.string().optional(),
          userId: z.number().optional(),
        })
        .optional(),
      joinedFrom: z
        .object({
          commitId: z.string().optional(),
          dsyncConnectedAt: z.number().optional(),
          dsyncUserId: z.string().optional(),
          gitUserId: z.union([z.string(), z.number()]).optional(),
          gitUserLogin: z.string().optional(),
          idpUserId: z.string().optional(),
          origin: z.union([
            z.literal('import'),
            z.literal('gitlab'),
            z.literal('bitbucket'),
            z.literal('github'),
            z.literal('mail'),
            z.literal('link'),
            z.literal('teams'),
            z.literal('saml'),
            z.literal('dsync'),
            z.literal('feedback'),
            z.literal('organization-teams'),
          ]),
          repoId: z.string().optional(),
          repoPath: z.string().optional(),
          ssoConnectedAt: z.number().optional(),
          ssoUserId: z.string().optional(),
        })
        .optional(),
      name: z.string().optional(),
      role: z.union([
        z.literal('MEMBER'),
        z.literal('OWNER'),
        z.literal('VIEWER'),
        z.literal('DEVELOPER'),
        z.literal('BILLING'),
      ]),
      uid: z.string(),
      username: z.string(),
    }),
  ),
  pagination: z.object({
    count: z.number(),
    hasNext: z.boolean(),
    next: z.number().nullable(),
    prev: z.number().nullable(),
  }),
});

export const getTeamMembersErrorSchema = z.unknown();

export const getAuthUserResponseSchema = z.object({
  user: z.union([authUserSchema, authUserLimitedSchema]),
});

export const getAuthUserErrorSchema = z.unknown();

export const listUserEventsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      since: z.string().optional(),
      teamId: z.string().optional(),
      types: z.string().optional(),
      until: z.string().optional(),
      userId: z.string().optional(),
    })
    .optional(),
});

export const listUserEventsResponseSchema = z.object({
  events: z.array(userEventSchema),
});

export const listUserEventsErrorSchema = z.unknown();

export const getSecretsDataSchema = z.object({
  query: z
    .object({
      id: z.string().optional(),
      projectId: z.string().optional(),
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getSecretsResponseSchema = z.object({
  pagination: paginationSchema,
  secrets: z.array(
    z.object({
      created: z.string(),
      createdAt: z.number().optional(),
      decryptable: z.boolean().optional(),
      name: z.string(),
      projectId: z.string().optional(),
      teamId: z.string().optional().nullable(),
      uid: z.string(),
      userId: z.string().optional(),
      value: z.string().optional(),
    }),
  ),
});

export const getSecretsErrorSchema = z.unknown();

export const getSecretDataSchema = z.object({
  path: z.object({
    idOrName: z.string(),
  }),
  query: z
    .object({
      decrypt: z.union([z.literal('true'), z.literal('false')]).optional(),
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getSecretResponseSchema = z.object({
  created: z.string(),
  createdAt: z.number().optional(),
  decryptable: z.boolean().optional(),
  name: z.string(),
  projectId: z.string().optional(),
  teamId: z.string().optional().nullable(),
  uid: z.string(),
  userId: z.string().optional(),
  value: z.string().optional(),
});

export const getSecretErrorSchema = z.unknown();

export const createAuthTokenDataSchema = z.object({
  body: z
    .union([
      z.object({
        expiresAt: z.number().optional(),
        name: z.string(),
      }),
      z.object({
        clientId: z.string().optional(),
        expiresAt: z.number().optional(),
        installationId: z.string().optional(),
        name: z.string(),
        type: z.literal('oauth2-token'),
      }),
    ])
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const createAuthTokenResponseSchema = z.object({
  bearerToken: z.string(),
  token: authTokenSchema,
});

export const createAuthTokenErrorSchema = z.unknown();

export const deleteAuthTokenDataSchema = z.object({
  path: z.object({
    tokenId: z.string(),
  }),
});

export const deleteAuthTokenResponseSchema = z.object({
  tokenId: z.string(),
});

export const deleteAuthTokenErrorSchema = z.unknown();

export const listAliasesDataSchema = z.object({
  query: z
    .object({
      domain: z.union([z.array(z.unknown()), z.string()]).optional(),
      from: z.number().optional(),
      limit: z.number().optional(),
      projectId: z.string().optional(),
      rollbackDeploymentId: z.string().optional(),
      since: z.number().optional(),
      teamId: z.string().optional(),
      until: z.number().optional(),
    })
    .optional(),
});

export const listAliasesResponseSchema = z.object({
  aliases: z.array(
    z.object({
      alias: z.string(),
      created: z.string(),
      createdAt: z.number().optional(),
      creator: z
        .object({
          email: z.string(),
          uid: z.string(),
          username: z.string(),
        })
        .optional(),
      deletedAt: z.number().optional(),
      deployment: z
        .object({
          id: z.string(),
          meta: z.string().optional(),
          url: z.string(),
        })
        .optional(),
      deploymentId: z.string().nullable(),
      projectId: z.string().nullable(),
      protectionBypass: z.record(z.string()).optional(),
      redirect: z.string().optional().nullable(),
      redirectStatusCode: z
        .union([z.literal(301), z.literal(302), z.literal(307), z.literal(308)])
        .optional()
        .nullable(),
      uid: z.string(),
      updatedAt: z.number().optional(),
    }),
  ),
  pagination: paginationSchema,
});

export const listAliasesErrorSchema = z.unknown();

export const getAliasDataSchema = z.object({
  path: z.object({
    idOrAlias: z.string(),
  }),
  query: z
    .object({
      from: z.number().optional(),
      projectId: z.string().optional(),
      since: z.number().optional(),
      teamId: z.string().optional(),
      until: z.number().optional(),
    })
    .optional(),
});

export const getAliasResponseSchema = z.object({
  alias: z.string(),
  created: z.string(),
  createdAt: z.number().optional(),
  creator: z
    .object({
      email: z.string(),
      uid: z.string(),
      username: z.string(),
    })
    .optional(),
  deletedAt: z.number().optional(),
  deployment: z
    .object({
      id: z.string(),
      meta: z.string().optional(),
      url: z.string(),
    })
    .optional(),
  deploymentId: z.string().nullable(),
  projectId: z.string().nullable(),
  protectionBypass: z.record(z.string()).optional(),
  redirect: z.string().optional().nullable(),
  redirectStatusCode: z
    .union([z.literal(301), z.literal(302), z.literal(307), z.literal(308)])
    .optional()
    .nullable(),
  uid: z.string(),
  updatedAt: z.number().optional(),
});

export const getAliasErrorSchema = z.unknown();

export const buyDomainDataSchema = z.object({
  body: z
    .object({
      expectedPrice: z.number().optional(),
      name: z.string(),
      renew: z.boolean().optional(),
    })
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const buyDomainResponseSchema = z.object({
  domain: z.object({
    created: z.number(),
    ns: z.array(z.string()),
    pending: z.boolean(),
    uid: z.string(),
    verified: z.boolean(),
  }),
});

export const buyDomainErrorSchema = z.unknown();

export const checkDomainPriceDataSchema = z.object({
  query: z.object({
    name: z.string(),
    teamId: z.string().optional(),
    type: z.union([z.literal('new'), z.literal('renewal')]).optional(),
  }),
});

export const checkDomainPriceResponseSchema = z.object({
  period: z.number(),
  price: z.number(),
});

export const checkDomainPriceErrorSchema = z.unknown();

export const checkDomainStatusDataSchema = z.object({
  query: z.object({
    name: z.string(),
    teamId: z.string().optional(),
  }),
});

export const checkDomainStatusResponseSchema = z.object({
  available: z.boolean(),
});

export const checkDomainStatusErrorSchema = z.unknown();

export const getRecordsDataSchema = z.object({
  path: z.object({
    domain: z.string(),
  }),
  query: z
    .object({
      limit: z.string().optional(),
      since: z.string().optional(),
      teamId: z.string().optional(),
      until: z.string().optional(),
    })
    .optional(),
});

export const getRecordsResponseSchema = z.union([
  z.string(),
  z.object({
    records: z.array(
      z.object({
        created: z.number().nullable(),
        createdAt: z.number().nullable(),
        creator: z.string(),
        id: z.string(),
        mxPriority: z.number().optional(),
        name: z.string(),
        priority: z.number().optional(),
        slug: z.string(),
        type: z.union([
          z.literal('A'),
          z.literal('AAAA'),
          z.literal('ALIAS'),
          z.literal('CAA'),
          z.literal('CNAME'),
          z.literal('MX'),
          z.literal('SRV'),
          z.literal('TXT'),
          z.literal('NS'),
        ]),
        updated: z.number().nullable(),
        updatedAt: z.number().nullable(),
        value: z.string(),
      }),
    ),
  }),
  z.object({
    pagination: paginationSchema,
    records: z.array(
      z.object({
        created: z.number().nullable(),
        createdAt: z.number().nullable(),
        creator: z.string(),
        id: z.string(),
        mxPriority: z.number().optional(),
        name: z.string(),
        priority: z.number().optional(),
        slug: z.string(),
        type: z.union([
          z.literal('A'),
          z.literal('AAAA'),
          z.literal('ALIAS'),
          z.literal('CAA'),
          z.literal('CNAME'),
          z.literal('MX'),
          z.literal('SRV'),
          z.literal('TXT'),
          z.literal('NS'),
        ]),
        updated: z.number().nullable(),
        updatedAt: z.number().nullable(),
        value: z.string(),
      }),
    ),
  }),
]);

export const getRecordsErrorSchema = z.unknown();

export const getDomainsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      since: z.number().optional(),
      teamId: z.string().optional(),
      until: z.number().optional(),
    })
    .optional(),
});

export const getDomainsResponseSchema = z.object({
  domains: z.array(
    z.object({
      boughtAt: z.number().nullable(),
      createdAt: z.number(),
      creator: z.object({
        customerId: z.string().optional().nullable(),
        email: z.string(),
        id: z.string(),
        isDomainReseller: z.boolean().optional(),
        username: z.string(),
      }),
      customNameservers: z.array(z.string()).optional(),
      expiresAt: z.number().nullable(),
      id: z.string(),
      intendedNameservers: z.array(z.string()),
      name: z.string(),
      nameservers: z.array(z.string()),
      orderedAt: z.number().optional(),
      renew: z.boolean().optional(),
      serviceType: z.union([z.literal('zeit.world'), z.literal('external'), z.literal('na')]),
      transferStartedAt: z.number().optional(),
      transferredAt: z.number().optional().nullable(),
      verified: z.boolean(),
    }),
  ),
  pagination: paginationSchema,
});

export const getDomainsErrorSchema = z.unknown();

export const createOrTransferDomainDataSchema = z.object({
  body: z
    .union([
      z.object({
        method: z.string(),
        name: z.string(),
        token: z.string().optional(),
      }),
      z.object({
        authCode: z.string().optional(),
        expectedPrice: z.number().optional(),
        method: z.string(),
        name: z.string(),
      }),
      z.object({
        cdnEnabled: z.boolean().optional(),
        method: z.string().optional(),
        name: z.string(),
        zone: z.boolean().optional(),
      }),
    ])
    .and(
      z.object({
        method: z.string().optional(),
      }),
    )
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const createOrTransferDomainResponseSchema = z.object({
  domain: z.object({
    boughtAt: z.number().nullable(),
    createdAt: z.number(),
    creator: z.object({
      customerId: z.string().optional().nullable(),
      email: z.string(),
      id: z.string(),
      isDomainReseller: z.boolean().optional(),
      username: z.string(),
    }),
    customNameservers: z.array(z.string()).optional(),
    expiresAt: z.number().nullable(),
    id: z.string(),
    intendedNameservers: z.array(z.string()),
    name: z.string(),
    nameservers: z.array(z.string()),
    orderedAt: z.number().optional(),
    renew: z.boolean().optional(),
    serviceType: z.union([z.literal('zeit.world'), z.literal('external'), z.literal('na')]),
    transferStartedAt: z.number().optional(),
    transferredAt: z.number().optional().nullable(),
    verified: z.boolean(),
  }),
});

export const createOrTransferDomainErrorSchema = z.unknown();

export const getDomainDataSchema = z.object({
  path: z.object({
    domain: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getDomainResponseSchema = z.object({
  domain: z.object({
    boughtAt: z.number().nullable(),
    createdAt: z.number(),
    creator: z.object({
      customerId: z.string().optional().nullable(),
      email: z.string(),
      id: z.string(),
      isDomainReseller: z.boolean().optional(),
      username: z.string(),
    }),
    customNameservers: z.array(z.string()).optional(),
    expiresAt: z.number().nullable(),
    id: z.string(),
    intendedNameservers: z.array(z.string()),
    name: z.string(),
    nameservers: z.array(z.string()),
    orderedAt: z.number().optional(),
    renew: z.boolean().optional(),
    serviceType: z.union([z.literal('zeit.world'), z.literal('external'), z.literal('na')]),
    suffix: z.boolean(),
    transferStartedAt: z.number().optional(),
    transferredAt: z.number().optional().nullable(),
    verified: z.boolean(),
  }),
});

export const getDomainErrorSchema = z.unknown();

export const listAuthTokensResponseSchema = z.object({
  pagination: paginationSchema,
  testingToken: authTokenSchema.optional(),
  tokens: z.array(authTokenSchema),
});

export const listAuthTokensErrorSchema = z.unknown();

export const getAuthTokenDataSchema = z.object({
  path: z.object({
    tokenId: z.string(),
  }),
});

export const getAuthTokenResponseSchema = z.object({
  token: authTokenSchema,
});

export const getAuthTokenErrorSchema = z.unknown();

export const getDeploymentsDataSchema = z.object({
  query: z
    .object({
      app: z.string().optional(),
      from: z.number().optional(),
      limit: z.number().optional(),
      projectId: z.string().optional(),
      rollbackCandidate: z.boolean().optional(),
      since: z.number().optional(),
      state: z.string().optional(),
      target: z.union([z.literal('production'), z.literal('preview')]).optional(),
      teamId: z.string().optional(),
      to: z.number().optional(),
      until: z.number().optional(),
      users: z.string().optional(),
    })
    .optional(),
});

export const getDeploymentsResponseSchema = z.object({
  deployments: z.array(
    z.object({
      aliasAssigned: z.union([z.number(), z.boolean()]).optional().nullable(),
      aliasError: z
        .object({
          code: z.string(),
          message: z.string(),
        })
        .optional()
        .nullable(),
      buildingAt: z.number().optional(),
      checksConclusion: z
        .union([z.literal('succeeded'), z.literal('failed'), z.literal('skipped'), z.literal('canceled')])
        .optional(),
      checksState: z.union([z.literal('registered'), z.literal('running'), z.literal('completed')]).optional(),
      connectConfigurationId: z.string().optional(),
      created: z.number(),
      createdAt: z.number().optional(),
      creator: z.object({
        email: z.string().optional(),
        githubLogin: z.string().optional(),
        gitlabLogin: z.string().optional(),
        uid: z.string(),
        username: z.string().optional(),
      }),
      inspectorUrl: z.string().nullable(),
      isRollbackCandidate: z.boolean().optional().nullable(),
      meta: z.record(z.string()).optional(),
      name: z.string(),
      projectSettings: z
        .object({
          buildCommand: z.string().optional().nullable(),
          commandForIgnoringBuildStep: z.string().optional().nullable(),
          createdAt: z.number().optional(),
          devCommand: z.string().optional().nullable(),
          framework: z
            .union([
              z.literal('blitzjs'),
              z.literal('nextjs'),
              z.literal('gatsby'),
              z.literal('remix'),
              z.literal('astro'),
              z.literal('hexo'),
              z.literal('eleventy'),
              z.literal('docusaurus-2'),
              z.literal('docusaurus'),
              z.literal('preact'),
              z.literal('solidstart'),
              z.literal('dojo'),
              z.literal('ember'),
              z.literal('vue'),
              z.literal('scully'),
              z.literal('ionic-angular'),
              z.literal('angular'),
              z.literal('polymer'),
              z.literal('svelte'),
              z.literal('sveltekit'),
              z.literal('sveltekit-1'),
              z.literal('ionic-react'),
              z.literal('create-react-app'),
              z.literal('gridsome'),
              z.literal('umijs'),
              z.literal('sapper'),
              z.literal('saber'),
              z.literal('stencil'),
              z.literal('nuxtjs'),
              z.literal('redwoodjs'),
              z.literal('hugo'),
              z.literal('jekyll'),
              z.literal('brunch'),
              z.literal('middleman'),
              z.literal('zola'),
              z.literal('hydrogen'),
              z.literal('vite'),
              z.literal('vitepress'),
              z.literal('vuepress'),
              z.literal('parcel'),
              z.literal('sanity'),
            ])
            .optional()
            .nullable(),
          gitForkProtection: z.boolean().optional(),
          gitLFS: z.boolean().optional(),
          installCommand: z.string().optional().nullable(),
          nodeVersion: z
            .union([z.literal('18.x'), z.literal('16.x'), z.literal('14.x'), z.literal('12.x'), z.literal('10.x')])
            .optional(),
          outputDirectory: z.string().optional().nullable(),
          publicSource: z.boolean().optional().nullable(),
          rootDirectory: z.string().optional().nullable(),
          serverlessFunctionRegion: z.string().optional().nullable(),
          skipGitConnectDuringLink: z.boolean().optional(),
          sourceFilesOutsideRootDirectory: z.boolean().optional(),
        })
        .optional(),
      ready: z.number().optional(),
      source: z
        .union([
          z.literal('cli'),
          z.literal('git'),
          z.literal('import'),
          z.literal('import/repo'),
          z.literal('clone/repo'),
        ])
        .optional(),
      state: z
        .union([
          z.literal('BUILDING'),
          z.literal('ERROR'),
          z.literal('INITIALIZING'),
          z.literal('QUEUED'),
          z.literal('READY'),
          z.literal('CANCELED'),
        ])
        .optional(),
      target: z
        .union([z.literal('production'), z.literal('staging')])
        .optional()
        .nullable(),
      type: z.literal('LAMBDAS'),
      uid: z.string(),
      url: z.string(),
    }),
  ),
  pagination: paginationSchema,
});

export const getDeploymentsErrorSchema = z.unknown();

export const listDeploymentFilesDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const listDeploymentFilesResponseSchema = z.array(fileTreeSchema);

export const listDeploymentFilesErrorSchema = z.unknown();

export const getDeploymentFileContentsDataSchema = z.object({
  path: z.object({
    fileId: z.string(),
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const deleteDomainDataSchema = z.object({
  path: z.object({
    domain: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const deleteDomainResponseSchema = z.object({
  uid: z.string(),
});

export const deleteDomainErrorSchema = z.unknown();

export const getDomainConfigDataSchema = z.object({
  path: z.object({
    domain: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getDomainConfigResponseSchema = z.object({
  acceptedChallenges: z.array(z.union([z.literal('dns-01'), z.literal('http-01')])).optional(),
  configuredBy: z
    .union([z.literal('CNAME'), z.literal('A'), z.literal('http')])
    .optional()
    .nullable(),
  misconfigured: z.boolean(),
});

export const getDomainConfigErrorSchema = z.unknown();

export const issueCertDataSchema = z.object({
  body: z
    .object({
      cns: z.array(z.string()).optional(),
    })
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const issueCertResponseSchema = z.object({
  autoRenew: z.boolean(),
  cns: z.array(z.string()),
  createdAt: z.number(),
  expiresAt: z.number(),
  id: z.string(),
});

export const issueCertErrorSchema = z.unknown();

export const uploadCertDataSchema = z.object({
  body: z
    .object({
      ca: z.string(),
      cert: z.string(),
      key: z.string(),
      skipValidation: z.boolean().optional(),
    })
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const uploadCertResponseSchema = z.object({
  autoRenew: z.boolean(),
  cns: z.array(z.string()),
  createdAt: z.number(),
  expiresAt: z.number(),
  id: z.string(),
});

export const uploadCertErrorSchema = z.unknown();

export const removeCertDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const removeCertResponseSchema = z.record(z.unknown());

export const removeCertErrorSchema = z.unknown();

export const getCertByIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getCertByIdResponseSchema = z.object({
  autoRenew: z.boolean(),
  cns: z.array(z.string()),
  createdAt: z.number(),
  expiresAt: z.number(),
  id: z.string(),
});

export const getCertByIdErrorSchema = z.unknown();

export const artifactQueryDataSchema = z.object({
  body: z
    .object({
      hashes: z.array(z.string()),
    })
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const recordEventsDataSchema = z.object({
  body: z
    .array(
      z.object({
        duration: z.number().optional(),
        event: z.union([z.literal('HIT'), z.literal('MISS')]),
        hash: z.string(),
        sessionId: z.string(),
        source: z.union([z.literal('LOCAL'), z.literal('REMOTE')]),
      }),
    )
    .optional(),
  headers: z
    .object({
      'x-artifact-client-ci': z.string().optional(),
      'x-artifact-client-interactive': z.number().optional(),
    })
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const recordEventsResponseSchema = z.unknown();

export const recordEventsErrorSchema = z.unknown();

export const statusDataSchema = z.object({
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const downloadArtifactDataSchema = z.object({
  headers: z
    .object({
      'x-artifact-client-ci': z.string().optional(),
      'x-artifact-client-interactive': z.number().optional(),
    })
    .optional(),
  path: z.object({
    hash: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const artifactExistsDataSchema = z.object({
  path: z.object({
    hash: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const uploadArtifactDataSchema = z.object({
  body: z.unknown().optional(),
  headers: z.object({
    'Content-Length': z.number(),
    'x-artifact-client-ci': z.string().optional(),
    'x-artifact-client-interactive': z.number().optional(),
    'x-artifact-duration': z.number().optional(),
    'x-artifact-tag': z.string().optional(),
  }),
  path: z.object({
    hash: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getProjectsDataSchema = z.object({
  query: z
    .object({
      edgeConfigId: z.string().optional(),
      edgeConfigTokenId: z.string().optional(),
      excludeRepos: z.string().optional(),
      from: z.string().optional(),
      gitForkProtection: z.union([z.literal('1'), z.literal('0')]).optional(),
      limit: z.string().optional(),
      repo: z.string().optional(),
      repoId: z.string().optional(),
      repoUrl: z.string().optional(),
      search: z.string().optional(),
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getProjectsResponseSchema = z.object({
  pagination: paginationSchema,
  projects: z.array(
    z.object({
      accountId: z.string(),
      analytics: z
        .object({
          canceledAt: z.number().nullable(),
          disabledAt: z.number(),
          enabledAt: z.number(),
          id: z.string(),
          paidAt: z.number().optional(),
          sampleRatePercent: z.number().optional().nullable(),
          spendLimitInDollars: z.number().optional().nullable(),
        })
        .optional(),
      autoExposeSystemEnvs: z.boolean().optional(),
      buildCommand: z.string().optional().nullable(),
      commandForIgnoringBuildStep: z.string().optional().nullable(),
      connectBuildsEnabled: z.boolean().optional(),
      connectConfigurationId: z.string().optional().nullable(),
      createdAt: z.number().optional(),
      devCommand: z.string().optional().nullable(),
      directoryListing: z.boolean(),
      enablePreviewFeedback: z.boolean().optional().nullable(),
      env: z
        .array(
          z.object({
            configurationId: z.string().optional().nullable(),
            createdAt: z.number().optional(),
            createdBy: z.string().optional().nullable(),
            decrypted: z.boolean().optional(),
            edgeConfigId: z.string().optional().nullable(),
            edgeConfigTokenId: z.string().optional().nullable(),
            gitBranch: z.string().optional(),
            id: z.string().optional(),
            key: z.string(),
            target: z
              .union([
                z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
                z.literal('production'),
                z.literal('preview'),
                z.literal('development'),
              ])
              .optional(),
            type: z.union([
              z.literal('secret'),
              z.literal('system'),
              z.literal('encrypted'),
              z.literal('plain'),
              z.literal('sensitive'),
            ]),
            updatedAt: z.number().optional(),
            updatedBy: z.string().optional().nullable(),
            value: z.string(),
          }),
        )
        .optional(),
      framework: z
        .union([
          z.literal('blitzjs'),
          z.literal('nextjs'),
          z.literal('gatsby'),
          z.literal('remix'),
          z.literal('astro'),
          z.literal('hexo'),
          z.literal('eleventy'),
          z.literal('docusaurus-2'),
          z.literal('docusaurus'),
          z.literal('preact'),
          z.literal('solidstart'),
          z.literal('dojo'),
          z.literal('ember'),
          z.literal('vue'),
          z.literal('scully'),
          z.literal('ionic-angular'),
          z.literal('angular'),
          z.literal('polymer'),
          z.literal('svelte'),
          z.literal('sveltekit'),
          z.literal('sveltekit-1'),
          z.literal('ionic-react'),
          z.literal('create-react-app'),
          z.literal('gridsome'),
          z.literal('umijs'),
          z.literal('sapper'),
          z.literal('saber'),
          z.literal('stencil'),
          z.literal('nuxtjs'),
          z.literal('redwoodjs'),
          z.literal('hugo'),
          z.literal('jekyll'),
          z.literal('brunch'),
          z.literal('middleman'),
          z.literal('zola'),
          z.literal('hydrogen'),
          z.literal('vite'),
          z.literal('vitepress'),
          z.literal('vuepress'),
          z.literal('parcel'),
          z.literal('sanity'),
        ])
        .optional()
        .nullable(),
      gitForkProtection: z.boolean().optional(),
      gitLFS: z.boolean().optional(),
      hasActiveBranches: z.boolean().optional(),
      hasFloatingAliases: z.boolean().optional(),
      id: z.string(),
      installCommand: z.string().optional().nullable(),
      lastRollbackTarget: z
        .object({
          fromDeploymentId: z.string(),
          jobStatus: z.union([
            z.literal('succeeded'),
            z.literal('failed'),
            z.literal('skipped'),
            z.literal('pending'),
            z.literal('in-progress'),
          ]),
          requestedAt: z.number(),
          toDeploymentId: z.string(),
        })
        .optional()
        .nullable(),
      latestDeployments: z
        .array(
          z.object({
            alias: z.array(z.string()).optional(),
            aliasAssigned: z.union([z.number(), z.boolean()]).optional().nullable(),
            aliasError: z
              .object({
                code: z.string(),
                message: z.string(),
              })
              .optional()
              .nullable(),
            aliasFinal: z.string().optional().nullable(),
            automaticAliases: z.array(z.string()).optional(),
            buildingAt: z.number().optional(),
            builds: z
              .array(
                z.object({
                  dest: z.string().optional(),
                  src: z.string().optional(),
                  use: z.string(),
                }),
              )
              .optional(),
            checksConclusion: z
              .union([z.literal('succeeded'), z.literal('failed'), z.literal('skipped'), z.literal('canceled')])
              .optional(),
            checksState: z.union([z.literal('registered'), z.literal('running'), z.literal('completed')]).optional(),
            connectConfigurationId: z.string().optional(),
            createdAt: z.number(),
            createdIn: z.string(),
            creator: z
              .object({
                email: z.string(),
                githubLogin: z.string().optional(),
                gitlabLogin: z.string().optional(),
                uid: z.string(),
                username: z.string(),
              })
              .nullable(),
            deploymentHostname: z.string(),
            forced: z.boolean().optional(),
            id: z.string(),
            meta: z.record(z.string()).optional(),
            monorepoManager: z.string().optional().nullable(),
            name: z.string(),
            plan: z.union([z.literal('hobby'), z.literal('enterprise'), z.literal('pro'), z.literal('oss')]),
            previewCommentsEnabled: z.boolean().optional(),
            private: z.boolean(),
            readyAt: z.number().optional(),
            readyState: z.union([
              z.literal('BUILDING'),
              z.literal('ERROR'),
              z.literal('INITIALIZING'),
              z.literal('QUEUED'),
              z.literal('READY'),
              z.literal('CANCELED'),
            ]),
            requestedAt: z.number().optional(),
            target: z.string().optional().nullable(),
            teamId: z.string().optional().nullable(),
            type: z.literal('LAMBDAS'),
            url: z.string(),
            userId: z.string(),
            withCache: z.boolean().optional(),
          }),
        )
        .optional(),
      link: z
        .union([
          z.object({
            createdAt: z.number().optional(),
            deployHooks: z.array(
              z.object({
                createdAt: z.number().optional(),
                id: z.string(),
                name: z.string(),
                ref: z.string(),
                url: z.string(),
              }),
            ),
            gitCredentialId: z.string().optional(),
            org: z.string().optional(),
            productionBranch: z.string().optional(),
            repo: z.string().optional(),
            repoId: z.number().optional(),
            sourceless: z.boolean().optional(),
            type: z.literal('github').optional(),
            updatedAt: z.number().optional(),
          }),
          z.object({
            createdAt: z.number().optional(),
            deployHooks: z.array(
              z.object({
                createdAt: z.number().optional(),
                id: z.string(),
                name: z.string(),
                ref: z.string(),
                url: z.string(),
              }),
            ),
            gitCredentialId: z.string().optional(),
            productionBranch: z.string().optional(),
            projectId: z.string().optional(),
            projectName: z.string().optional(),
            projectNameWithNamespace: z.string().optional(),
            projectNamespace: z.string().optional(),
            projectUrl: z.string().optional(),
            sourceless: z.boolean().optional(),
            type: z.literal('gitlab').optional(),
            updatedAt: z.number().optional(),
          }),
          z.object({
            createdAt: z.number().optional(),
            deployHooks: z.array(
              z.object({
                createdAt: z.number().optional(),
                id: z.string(),
                name: z.string(),
                ref: z.string(),
                url: z.string(),
              }),
            ),
            gitCredentialId: z.string().optional(),
            name: z.string().optional(),
            owner: z.string().optional(),
            productionBranch: z.string().optional(),
            slug: z.string().optional(),
            sourceless: z.boolean().optional(),
            type: z.literal('bitbucket').optional(),
            updatedAt: z.number().optional(),
            uuid: z.string().optional(),
            workspaceUuid: z.string().optional(),
          }),
        ])
        .optional(),
      live: z.boolean().optional(),
      name: z.string(),
      nodeVersion: z.union([
        z.literal('18.x'),
        z.literal('16.x'),
        z.literal('14.x'),
        z.literal('12.x'),
        z.literal('10.x'),
      ]),
      outputDirectory: z.string().optional().nullable(),
      passwordProtection: z
        .object({
          deploymentType: z.union([z.literal('preview'), z.literal('all')]),
        })
        .optional()
        .nullable(),
      permissions: z
        .object({
          Monitoring: z.array(aCLActionSchema).optional(),
          aliasGlobal: z.array(aCLActionSchema).optional(),
          aliasProject: z.array(aCLActionSchema).optional(),
          aliasProtectionBypass: z.array(aCLActionSchema).optional(),
          analytics: z.array(aCLActionSchema).optional(),
          analyticsSampling: z.array(aCLActionSchema).optional(),
          analyticsUsage: z.array(aCLActionSchema).optional(),
          auditLog: z.array(aCLActionSchema).optional(),
          billingAddress: z.array(aCLActionSchema).optional(),
          billingInformation: z.array(aCLActionSchema).optional(),
          billingInvoice: z.array(aCLActionSchema).optional(),
          billingInvoiceEmailRecipient: z.array(aCLActionSchema).optional(),
          billingInvoiceLanguage: z.array(aCLActionSchema).optional(),
          billingPlan: z.array(aCLActionSchema).optional(),
          billingPurchaseOrder: z.array(aCLActionSchema).optional(),
          billingTaxId: z.array(aCLActionSchema).optional(),
          blob: z.array(aCLActionSchema).optional(),
          cacheArtifact: z.array(aCLActionSchema).optional(),
          cacheArtifactUsageEvent: z.array(aCLActionSchema).optional(),
          concurrentBuilds: z.array(aCLActionSchema).optional(),
          connect: z.array(aCLActionSchema).optional(),
          connectConfiguration: z.array(aCLActionSchema).optional(),
          connectConfigurationLink: z.array(aCLActionSchema).optional(),
          deployment: z.array(aCLActionSchema).optional(),
          deploymentCheck: z.array(aCLActionSchema).optional(),
          deploymentCheckPreview: z.array(aCLActionSchema).optional(),
          deploymentCheckReRunFromProductionBranch: z.array(aCLActionSchema).optional(),
          deploymentPreview: z.array(aCLActionSchema).optional(),
          deploymentPrivate: z.array(aCLActionSchema).optional(),
          deploymentProductionGit: z.array(aCLActionSchema).optional(),
          deploymentRollback: z.array(aCLActionSchema).optional(),
          domain: z.array(aCLActionSchema).optional(),
          domainAcceptDelegation: z.array(aCLActionSchema).optional(),
          domainAuthCodes: z.array(aCLActionSchema).optional(),
          domainCertificate: z.array(aCLActionSchema).optional(),
          domainCheckConfig: z.array(aCLActionSchema).optional(),
          domainMove: z.array(aCLActionSchema).optional(),
          domainPurchase: z.array(aCLActionSchema).optional(),
          domainRecord: z.array(aCLActionSchema).optional(),
          domainTransferIn: z.array(aCLActionSchema).optional(),
          edgeConfig: z.array(aCLActionSchema).optional(),
          edgeConfigItem: z.array(aCLActionSchema).optional(),
          edgeConfigToken: z.array(aCLActionSchema).optional(),
          endpointVerification: z.array(aCLActionSchema).optional(),
          event: z.array(aCLActionSchema).optional(),
          fileUpload: z.array(aCLActionSchema).optional(),
          gitRepository: z.array(aCLActionSchema).optional(),
          integration: z.array(aCLActionSchema).optional(),
          integrationConfiguration: z.array(aCLActionSchema).optional(),
          integrationConfigurationProjects: z.array(aCLActionSchema).optional(),
          integrationConfigurationTransfer: z.array(aCLActionSchema).optional(),
          integrationVercelConfigurationOverride: z.array(aCLActionSchema).optional(),
          ipBlocking: z.array(aCLActionSchema).optional(),
          job: z.array(aCLActionSchema).optional(),
          logDrain: z.array(aCLActionSchema).optional(),
          monitoringChart: z.array(aCLActionSchema).optional(),
          monitoringQuery: z.array(aCLActionSchema).optional(),
          notificationDomainConfiguration: z.array(aCLActionSchema).optional(),
          notificationDomainExpire: z.array(aCLActionSchema).optional(),
          notificationDomainMoved: z.array(aCLActionSchema).optional(),
          notificationDomainPurchase: z.array(aCLActionSchema).optional(),
          notificationDomainRenewal: z.array(aCLActionSchema).optional(),
          notificationDomainTransfer: z.array(aCLActionSchema).optional(),
          notificationDomainUnverified: z.array(aCLActionSchema).optional(),
          notificationPaymentFailed: z.array(aCLActionSchema).optional(),
          notificationSpendCap: z.array(aCLActionSchema).optional(),
          notificationUsageAlert: z.array(aCLActionSchema).optional(),
          openTelemetryEndpoint: z.array(aCLActionSchema).optional(),
          passwordProtection: z.array(aCLActionSchema).optional(),
          paymentMethod: z.array(aCLActionSchema).optional(),
          permissions: z.array(aCLActionSchema).optional(),
          postgres: z.array(aCLActionSchema).optional(),
          previewDeploymentSuffix: z.array(aCLActionSchema).optional(),
          proTrialOnboarding: z.array(aCLActionSchema).optional(),
          project: z.array(aCLActionSchema).optional(),
          projectDeploymentHook: z.array(aCLActionSchema).optional(),
          projectDomain: z.array(aCLActionSchema).optional(),
          projectDomainMove: z.array(aCLActionSchema).optional(),
          projectEnvVars: z.array(aCLActionSchema).optional(),
          projectEnvVarsProduction: z.array(aCLActionSchema).optional(),
          projectEnvVarsUnownedByIntegration: z.array(aCLActionSchema).optional(),
          projectIntegrationConfiguration: z.array(aCLActionSchema).optional(),
          projectLink: z.array(aCLActionSchema).optional(),
          projectMember: z.array(aCLActionSchema).optional(),
          projectProductionBranch: z.array(aCLActionSchema).optional(),
          projectProtectionBypass: z.array(aCLActionSchema).optional(),
          projectTransfer: z.array(aCLActionSchema).optional(),
          rateLimit: z.array(aCLActionSchema).optional(),
          redis: z.array(aCLActionSchema).optional(),
          remoteCaching: z.array(aCLActionSchema).optional(),
          samlConfig: z.array(aCLActionSchema).optional(),
          secret: z.array(aCLActionSchema).optional(),
          sensitiveEnvironmentVariablePolicy: z.array(aCLActionSchema).optional(),
          sharedEnvVars: z.array(aCLActionSchema).optional(),
          sharedEnvVarsProduction: z.array(aCLActionSchema).optional(),
          spendCapConfiguration: z.array(aCLActionSchema).optional(),
          spendCapState: z.array(aCLActionSchema).optional(),
          supportCase: z.array(aCLActionSchema).optional(),
          supportCaseComment: z.array(aCLActionSchema).optional(),
          team: z.array(aCLActionSchema).optional(),
          teamAccessRequest: z.array(aCLActionSchema).optional(),
          teamFellowMembership: z.array(aCLActionSchema).optional(),
          teamInvite: z.array(aCLActionSchema).optional(),
          teamInviteCode: z.array(aCLActionSchema).optional(),
          teamJoin: z.array(aCLActionSchema).optional(),
          teamOwnMembership: z.array(aCLActionSchema).optional(),
          teamOwnMembershipDisconnectSAML: z.array(aCLActionSchema).optional(),
          token: z.array(aCLActionSchema).optional(),
          usage: z.array(aCLActionSchema).optional(),
          user: z.array(aCLActionSchema).optional(),
          userConnection: z.array(aCLActionSchema).optional(),
          webAnalytics: z.array(aCLActionSchema).optional(),
          webAnalyticsPlan: z.array(aCLActionSchema).optional(),
          webhook: z.array(aCLActionSchema).optional(),
          'webhook-event': z.array(aCLActionSchema).optional(),
        })
        .optional(),
      protectionBypass: z.record(z.string()).optional(),
      publicSource: z.boolean().optional().nullable(),
      rootDirectory: z.string().optional().nullable(),
      serverlessFunctionRegion: z.string().optional().nullable(),
      skipGitConnectDuringLink: z.boolean().optional(),
      sourceFilesOutsideRootDirectory: z.boolean().optional(),
      ssoProtection: z
        .object({
          deploymentType: z.union([z.literal('preview'), z.literal('all')]),
        })
        .optional()
        .nullable(),
      targets: z.record(z.string()).optional(),
      transferCompletedAt: z.number().optional(),
      transferStartedAt: z.number().optional(),
      transferToAccountId: z.string().optional(),
      transferredFromAccountId: z.string().optional(),
      updatedAt: z.number().optional(),
    }),
  ),
});

export const getProjectsErrorSchema = z.unknown();

export const createProjectDataSchema = z.object({
  body: z
    .object({
      buildCommand: z.string().optional().nullable(),
      commandForIgnoringBuildStep: z.string().optional().nullable(),
      devCommand: z.string().optional().nullable(),
      environmentVariables: z
        .array(
          z.object({
            gitBranch: z.string().optional(),
            key: z.string(),
            target: z.union([
              z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Productio'),
              z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Previe'),
              z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Developmen'),
              z.array(
                z.union([
                  z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Productio'),
                  z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Previe'),
                  z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Developmen'),
                ]),
              ),
            ]),
            type: z
              .union([z.literal('system'), z.literal('secret'), z.literal('encrypted'), z.literal('plain')])
              .optional(),
            value: z.string(),
          }),
        )
        .optional(),
      framework: z
        .union([
          z.literal('blitzjs'),
          z.literal('nextjs'),
          z.literal('gatsby'),
          z.literal('remix'),
          z.literal('astro'),
          z.literal('hexo'),
          z.literal('eleventy'),
          z.literal('docusaurus-2'),
          z.literal('docusaurus'),
          z.literal('preact'),
          z.literal('solidstart'),
          z.literal('dojo'),
          z.literal('ember'),
          z.literal('vue'),
          z.literal('scully'),
          z.literal('ionic-angular'),
          z.literal('angular'),
          z.literal('polymer'),
          z.literal('svelte'),
          z.literal('sveltekit'),
          z.literal('sveltekit-1'),
          z.literal('ionic-react'),
          z.literal('create-react-app'),
          z.literal('gridsome'),
          z.literal('umijs'),
          z.literal('sapper'),
          z.literal('saber'),
          z.literal('stencil'),
          z.literal('nuxtjs'),
          z.literal('redwoodjs'),
          z.literal('hugo'),
          z.literal('jekyll'),
          z.literal('brunch'),
          z.literal('middleman'),
          z.literal('zola'),
          z.literal('hydrogen'),
          z.literal('vite'),
          z.literal('vitepress'),
          z.literal('vuepress'),
          z.literal('parcel'),
          z.literal('sanity'),
        ])
        .optional(),
      gitRepository: z
        .object({
          repo: z.string(),
          type: z.union([z.literal('github'), z.literal('gitlab'), z.literal('bitbucket')]),
        })
        .optional(),
      installCommand: z.string().optional().nullable(),
      name: z.string(),
      outputDirectory: z.string().optional().nullable(),
      publicSource: z.boolean().optional().nullable(),
      rootDirectory: z.string().optional().nullable(),
      serverlessFunctionRegion: z.string().optional().nullable(),
      skipGitConnectDuringLink: z.boolean().optional(),
    })
    .optional(),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const createProjectResponseSchema = z.object({
  accountId: z.string(),
  analytics: z
    .object({
      canceledAt: z.number().nullable(),
      disabledAt: z.number(),
      enabledAt: z.number(),
      id: z.string(),
      paidAt: z.number().optional(),
      sampleRatePercent: z.number().optional().nullable(),
      spendLimitInDollars: z.number().optional().nullable(),
    })
    .optional(),
  autoExposeSystemEnvs: z.boolean().optional(),
  buildCommand: z.string().optional().nullable(),
  commandForIgnoringBuildStep: z.string().optional().nullable(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional().nullable(),
  createdAt: z.number().optional(),
  devCommand: z.string().optional().nullable(),
  directoryListing: z.boolean(),
  enablePreviewFeedback: z.boolean().optional().nullable(),
  env: z
    .array(
      z.object({
        configurationId: z.string().optional().nullable(),
        createdAt: z.number().optional(),
        createdBy: z.string().optional().nullable(),
        decrypted: z.boolean().optional(),
        edgeConfigId: z.string().optional().nullable(),
        edgeConfigTokenId: z.string().optional().nullable(),
        gitBranch: z.string().optional(),
        id: z.string().optional(),
        key: z.string(),
        target: z
          .union([
            z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
            z.literal('production'),
            z.literal('preview'),
            z.literal('development'),
          ])
          .optional(),
        type: z.union([
          z.literal('secret'),
          z.literal('system'),
          z.literal('encrypted'),
          z.literal('plain'),
          z.literal('sensitive'),
        ]),
        updatedAt: z.number().optional(),
        updatedBy: z.string().optional().nullable(),
        value: z.string(),
      }),
    )
    .optional(),
  framework: z
    .union([
      z.literal('blitzjs'),
      z.literal('nextjs'),
      z.literal('gatsby'),
      z.literal('remix'),
      z.literal('astro'),
      z.literal('hexo'),
      z.literal('eleventy'),
      z.literal('docusaurus-2'),
      z.literal('docusaurus'),
      z.literal('preact'),
      z.literal('solidstart'),
      z.literal('dojo'),
      z.literal('ember'),
      z.literal('vue'),
      z.literal('scully'),
      z.literal('ionic-angular'),
      z.literal('angular'),
      z.literal('polymer'),
      z.literal('svelte'),
      z.literal('sveltekit'),
      z.literal('sveltekit-1'),
      z.literal('ionic-react'),
      z.literal('create-react-app'),
      z.literal('gridsome'),
      z.literal('umijs'),
      z.literal('sapper'),
      z.literal('saber'),
      z.literal('stencil'),
      z.literal('nuxtjs'),
      z.literal('redwoodjs'),
      z.literal('hugo'),
      z.literal('jekyll'),
      z.literal('brunch'),
      z.literal('middleman'),
      z.literal('zola'),
      z.literal('hydrogen'),
      z.literal('vite'),
      z.literal('vitepress'),
      z.literal('vuepress'),
      z.literal('parcel'),
      z.literal('sanity'),
    ])
    .optional()
    .nullable(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  hasActiveBranches: z.boolean().optional(),
  hasFloatingAliases: z.boolean().optional(),
  id: z.string(),
  installCommand: z.string().optional().nullable(),
  lastRollbackTarget: z
    .object({
      fromDeploymentId: z.string(),
      jobStatus: z.union([
        z.literal('succeeded'),
        z.literal('failed'),
        z.literal('skipped'),
        z.literal('pending'),
        z.literal('in-progress'),
      ]),
      requestedAt: z.number(),
      toDeploymentId: z.string(),
    })
    .optional()
    .nullable(),
  latestDeployments: z
    .array(
      z.object({
        alias: z.array(z.string()).optional(),
        aliasAssigned: z.union([z.number(), z.boolean()]).optional().nullable(),
        aliasError: z
          .object({
            code: z.string(),
            message: z.string(),
          })
          .optional()
          .nullable(),
        aliasFinal: z.string().optional().nullable(),
        automaticAliases: z.array(z.string()).optional(),
        buildingAt: z.number().optional(),
        builds: z
          .array(
            z.object({
              dest: z.string().optional(),
              src: z.string().optional(),
              use: z.string(),
            }),
          )
          .optional(),
        checksConclusion: z
          .union([z.literal('succeeded'), z.literal('failed'), z.literal('skipped'), z.literal('canceled')])
          .optional(),
        checksState: z.union([z.literal('registered'), z.literal('running'), z.literal('completed')]).optional(),
        connectConfigurationId: z.string().optional(),
        createdAt: z.number(),
        createdIn: z.string(),
        creator: z
          .object({
            email: z.string(),
            githubLogin: z.string().optional(),
            gitlabLogin: z.string().optional(),
            uid: z.string(),
            username: z.string(),
          })
          .nullable(),
        deploymentHostname: z.string(),
        forced: z.boolean().optional(),
        id: z.string(),
        meta: z.record(z.string()).optional(),
        monorepoManager: z.string().optional().nullable(),
        name: z.string(),
        plan: z.union([z.literal('hobby'), z.literal('enterprise'), z.literal('pro'), z.literal('oss')]),
        previewCommentsEnabled: z.boolean().optional(),
        private: z.boolean(),
        readyAt: z.number().optional(),
        readyState: z.union([
          z.literal('BUILDING'),
          z.literal('ERROR'),
          z.literal('INITIALIZING'),
          z.literal('QUEUED'),
          z.literal('READY'),
          z.literal('CANCELED'),
        ]),
        requestedAt: z.number().optional(),
        target: z.string().optional().nullable(),
        teamId: z.string().optional().nullable(),
        type: z.literal('LAMBDAS'),
        url: z.string(),
        userId: z.string(),
        withCache: z.boolean().optional(),
      }),
    )
    .optional(),
  link: z
    .union([
      z.object({
        createdAt: z.number().optional(),
        deployHooks: z.array(
          z.object({
            createdAt: z.number().optional(),
            id: z.string(),
            name: z.string(),
            ref: z.string(),
            url: z.string(),
          }),
        ),
        gitCredentialId: z.string().optional(),
        org: z.string().optional(),
        productionBranch: z.string().optional(),
        repo: z.string().optional(),
        repoId: z.number().optional(),
        sourceless: z.boolean().optional(),
        type: z.literal('github').optional(),
        updatedAt: z.number().optional(),
      }),
      z.object({
        createdAt: z.number().optional(),
        deployHooks: z.array(
          z.object({
            createdAt: z.number().optional(),
            id: z.string(),
            name: z.string(),
            ref: z.string(),
            url: z.string(),
          }),
        ),
        gitCredentialId: z.string().optional(),
        productionBranch: z.string().optional(),
        projectId: z.string().optional(),
        projectName: z.string().optional(),
        projectNameWithNamespace: z.string().optional(),
        projectNamespace: z.string().optional(),
        projectUrl: z.string().optional(),
        sourceless: z.boolean().optional(),
        type: z.literal('gitlab').optional(),
        updatedAt: z.number().optional(),
      }),
      z.object({
        createdAt: z.number().optional(),
        deployHooks: z.array(
          z.object({
            createdAt: z.number().optional(),
            id: z.string(),
            name: z.string(),
            ref: z.string(),
            url: z.string(),
          }),
        ),
        gitCredentialId: z.string().optional(),
        name: z.string().optional(),
        owner: z.string().optional(),
        productionBranch: z.string().optional(),
        slug: z.string().optional(),
        sourceless: z.boolean().optional(),
        type: z.literal('bitbucket').optional(),
        updatedAt: z.number().optional(),
        uuid: z.string().optional(),
        workspaceUuid: z.string().optional(),
      }),
    ])
    .optional(),
  live: z.boolean().optional(),
  name: z.string(),
  nodeVersion: z.union([z.literal('18.x'), z.literal('16.x'), z.literal('14.x'), z.literal('12.x'), z.literal('10.x')]),
  outputDirectory: z.string().optional().nullable(),
  passwordProtection: z
    .object({
      deploymentType: z.union([z.literal('preview'), z.literal('all')]),
    })
    .optional()
    .nullable(),
  permissions: z
    .object({
      Monitoring: z.array(aCLActionSchema).optional(),
      aliasGlobal: z.array(aCLActionSchema).optional(),
      aliasProject: z.array(aCLActionSchema).optional(),
      aliasProtectionBypass: z.array(aCLActionSchema).optional(),
      analytics: z.array(aCLActionSchema).optional(),
      analyticsSampling: z.array(aCLActionSchema).optional(),
      analyticsUsage: z.array(aCLActionSchema).optional(),
      auditLog: z.array(aCLActionSchema).optional(),
      billingAddress: z.array(aCLActionSchema).optional(),
      billingInformation: z.array(aCLActionSchema).optional(),
      billingInvoice: z.array(aCLActionSchema).optional(),
      billingInvoiceEmailRecipient: z.array(aCLActionSchema).optional(),
      billingInvoiceLanguage: z.array(aCLActionSchema).optional(),
      billingPlan: z.array(aCLActionSchema).optional(),
      billingPurchaseOrder: z.array(aCLActionSchema).optional(),
      billingTaxId: z.array(aCLActionSchema).optional(),
      blob: z.array(aCLActionSchema).optional(),
      cacheArtifact: z.array(aCLActionSchema).optional(),
      cacheArtifactUsageEvent: z.array(aCLActionSchema).optional(),
      concurrentBuilds: z.array(aCLActionSchema).optional(),
      connect: z.array(aCLActionSchema).optional(),
      connectConfiguration: z.array(aCLActionSchema).optional(),
      connectConfigurationLink: z.array(aCLActionSchema).optional(),
      deployment: z.array(aCLActionSchema).optional(),
      deploymentCheck: z.array(aCLActionSchema).optional(),
      deploymentCheckPreview: z.array(aCLActionSchema).optional(),
      deploymentCheckReRunFromProductionBranch: z.array(aCLActionSchema).optional(),
      deploymentPreview: z.array(aCLActionSchema).optional(),
      deploymentPrivate: z.array(aCLActionSchema).optional(),
      deploymentProductionGit: z.array(aCLActionSchema).optional(),
      deploymentRollback: z.array(aCLActionSchema).optional(),
      domain: z.array(aCLActionSchema).optional(),
      domainAcceptDelegation: z.array(aCLActionSchema).optional(),
      domainAuthCodes: z.array(aCLActionSchema).optional(),
      domainCertificate: z.array(aCLActionSchema).optional(),
      domainCheckConfig: z.array(aCLActionSchema).optional(),
      domainMove: z.array(aCLActionSchema).optional(),
      domainPurchase: z.array(aCLActionSchema).optional(),
      domainRecord: z.array(aCLActionSchema).optional(),
      domainTransferIn: z.array(aCLActionSchema).optional(),
      edgeConfig: z.array(aCLActionSchema).optional(),
      edgeConfigItem: z.array(aCLActionSchema).optional(),
      edgeConfigToken: z.array(aCLActionSchema).optional(),
      endpointVerification: z.array(aCLActionSchema).optional(),
      event: z.array(aCLActionSchema).optional(),
      fileUpload: z.array(aCLActionSchema).optional(),
      gitRepository: z.array(aCLActionSchema).optional(),
      integration: z.array(aCLActionSchema).optional(),
      integrationConfiguration: z.array(aCLActionSchema).optional(),
      integrationConfigurationProjects: z.array(aCLActionSchema).optional(),
      integrationConfigurationTransfer: z.array(aCLActionSchema).optional(),
      integrationVercelConfigurationOverride: z.array(aCLActionSchema).optional(),
      ipBlocking: z.array(aCLActionSchema).optional(),
      job: z.array(aCLActionSchema).optional(),
      logDrain: z.array(aCLActionSchema).optional(),
      monitoringChart: z.array(aCLActionSchema).optional(),
      monitoringQuery: z.array(aCLActionSchema).optional(),
      notificationDomainConfiguration: z.array(aCLActionSchema).optional(),
      notificationDomainExpire: z.array(aCLActionSchema).optional(),
      notificationDomainMoved: z.array(aCLActionSchema).optional(),
      notificationDomainPurchase: z.array(aCLActionSchema).optional(),
      notificationDomainRenewal: z.array(aCLActionSchema).optional(),
      notificationDomainTransfer: z.array(aCLActionSchema).optional(),
      notificationDomainUnverified: z.array(aCLActionSchema).optional(),
      notificationPaymentFailed: z.array(aCLActionSchema).optional(),
      notificationSpendCap: z.array(aCLActionSchema).optional(),
      notificationUsageAlert: z.array(aCLActionSchema).optional(),
      openTelemetryEndpoint: z.array(aCLActionSchema).optional(),
      passwordProtection: z.array(aCLActionSchema).optional(),
      paymentMethod: z.array(aCLActionSchema).optional(),
      permissions: z.array(aCLActionSchema).optional(),
      postgres: z.array(aCLActionSchema).optional(),
      previewDeploymentSuffix: z.array(aCLActionSchema).optional(),
      proTrialOnboarding: z.array(aCLActionSchema).optional(),
      project: z.array(aCLActionSchema).optional(),
      projectDeploymentHook: z.array(aCLActionSchema).optional(),
      projectDomain: z.array(aCLActionSchema).optional(),
      projectDomainMove: z.array(aCLActionSchema).optional(),
      projectEnvVars: z.array(aCLActionSchema).optional(),
      projectEnvVarsProduction: z.array(aCLActionSchema).optional(),
      projectEnvVarsUnownedByIntegration: z.array(aCLActionSchema).optional(),
      projectIntegrationConfiguration: z.array(aCLActionSchema).optional(),
      projectLink: z.array(aCLActionSchema).optional(),
      projectMember: z.array(aCLActionSchema).optional(),
      projectProductionBranch: z.array(aCLActionSchema).optional(),
      projectProtectionBypass: z.array(aCLActionSchema).optional(),
      projectTransfer: z.array(aCLActionSchema).optional(),
      rateLimit: z.array(aCLActionSchema).optional(),
      redis: z.array(aCLActionSchema).optional(),
      remoteCaching: z.array(aCLActionSchema).optional(),
      samlConfig: z.array(aCLActionSchema).optional(),
      secret: z.array(aCLActionSchema).optional(),
      sensitiveEnvironmentVariablePolicy: z.array(aCLActionSchema).optional(),
      sharedEnvVars: z.array(aCLActionSchema).optional(),
      sharedEnvVarsProduction: z.array(aCLActionSchema).optional(),
      spendCapConfiguration: z.array(aCLActionSchema).optional(),
      spendCapState: z.array(aCLActionSchema).optional(),
      supportCase: z.array(aCLActionSchema).optional(),
      supportCaseComment: z.array(aCLActionSchema).optional(),
      team: z.array(aCLActionSchema).optional(),
      teamAccessRequest: z.array(aCLActionSchema).optional(),
      teamFellowMembership: z.array(aCLActionSchema).optional(),
      teamInvite: z.array(aCLActionSchema).optional(),
      teamInviteCode: z.array(aCLActionSchema).optional(),
      teamJoin: z.array(aCLActionSchema).optional(),
      teamOwnMembership: z.array(aCLActionSchema).optional(),
      teamOwnMembershipDisconnectSAML: z.array(aCLActionSchema).optional(),
      token: z.array(aCLActionSchema).optional(),
      usage: z.array(aCLActionSchema).optional(),
      user: z.array(aCLActionSchema).optional(),
      userConnection: z.array(aCLActionSchema).optional(),
      webAnalytics: z.array(aCLActionSchema).optional(),
      webAnalyticsPlan: z.array(aCLActionSchema).optional(),
      webhook: z.array(aCLActionSchema).optional(),
      'webhook-event': z.array(aCLActionSchema).optional(),
    })
    .optional(),
  protectionBypass: z.record(z.string()).optional(),
  publicSource: z.boolean().optional().nullable(),
  rootDirectory: z.string().optional().nullable(),
  serverlessFunctionRegion: z.string().optional().nullable(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  ssoProtection: z
    .object({
      deploymentType: z.union([z.literal('preview'), z.literal('all')]),
    })
    .optional()
    .nullable(),
  targets: z.record(z.string()).optional(),
  transferCompletedAt: z.number().optional(),
  transferStartedAt: z.number().optional(),
  transferToAccountId: z.string().optional(),
  transferredFromAccountId: z.string().optional(),
  updatedAt: z.number().optional(),
});

export const createProjectErrorSchema = z.unknown();

export const deleteProjectDataSchema = z.object({
  path: z.object({
    idOrName: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const deleteProjectResponseSchema = z.any();

export const deleteProjectErrorSchema = z.unknown();

export const getProjectDataSchema = z.object({
  path: z.object({
    idOrName: z.union([z.string(), z.boolean()]),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getProjectResponseSchema = z.object({
  accountId: z.string(),
  analytics: z
    .object({
      canceledAt: z.number().nullable(),
      disabledAt: z.number(),
      enabledAt: z.number(),
      id: z.string(),
      paidAt: z.number().optional(),
      sampleRatePercent: z.number().optional().nullable(),
      spendLimitInDollars: z.number().optional().nullable(),
    })
    .optional(),
  autoExposeSystemEnvs: z.boolean().optional(),
  buildCommand: z.string().optional().nullable(),
  commandForIgnoringBuildStep: z.string().optional().nullable(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional().nullable(),
  createdAt: z.number().optional(),
  devCommand: z.string().optional().nullable(),
  directoryListing: z.boolean(),
  enablePreviewFeedback: z.boolean().optional().nullable(),
  env: z
    .array(
      z.object({
        configurationId: z.string().optional().nullable(),
        createdAt: z.number().optional(),
        createdBy: z.string().optional().nullable(),
        decrypted: z.boolean().optional(),
        edgeConfigId: z.string().optional().nullable(),
        edgeConfigTokenId: z.string().optional().nullable(),
        gitBranch: z.string().optional(),
        id: z.string().optional(),
        key: z.string(),
        target: z
          .union([
            z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
            z.literal('production'),
            z.literal('preview'),
            z.literal('development'),
          ])
          .optional(),
        type: z.union([
          z.literal('secret'),
          z.literal('system'),
          z.literal('encrypted'),
          z.literal('plain'),
          z.literal('sensitive'),
        ]),
        updatedAt: z.number().optional(),
        updatedBy: z.string().optional().nullable(),
        value: z.string(),
      }),
    )
    .optional(),
  framework: z
    .union([
      z.literal('blitzjs'),
      z.literal('nextjs'),
      z.literal('gatsby'),
      z.literal('remix'),
      z.literal('astro'),
      z.literal('hexo'),
      z.literal('eleventy'),
      z.literal('docusaurus-2'),
      z.literal('docusaurus'),
      z.literal('preact'),
      z.literal('solidstart'),
      z.literal('dojo'),
      z.literal('ember'),
      z.literal('vue'),
      z.literal('scully'),
      z.literal('ionic-angular'),
      z.literal('angular'),
      z.literal('polymer'),
      z.literal('svelte'),
      z.literal('sveltekit'),
      z.literal('sveltekit-1'),
      z.literal('ionic-react'),
      z.literal('create-react-app'),
      z.literal('gridsome'),
      z.literal('umijs'),
      z.literal('sapper'),
      z.literal('saber'),
      z.literal('stencil'),
      z.literal('nuxtjs'),
      z.literal('redwoodjs'),
      z.literal('hugo'),
      z.literal('jekyll'),
      z.literal('brunch'),
      z.literal('middleman'),
      z.literal('zola'),
      z.literal('hydrogen'),
      z.literal('vite'),
      z.literal('vitepress'),
      z.literal('vuepress'),
      z.literal('parcel'),
      z.literal('sanity'),
    ])
    .optional()
    .nullable(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  hasActiveBranches: z.boolean().optional(),
  hasFloatingAliases: z.boolean().optional(),
  id: z.string(),
  installCommand: z.string().optional().nullable(),
  lastRollbackTarget: z
    .object({
      fromDeploymentId: z.string(),
      jobStatus: z.union([
        z.literal('succeeded'),
        z.literal('failed'),
        z.literal('skipped'),
        z.literal('pending'),
        z.literal('in-progress'),
      ]),
      requestedAt: z.number(),
      toDeploymentId: z.string(),
    })
    .optional()
    .nullable(),
  latestDeployments: z
    .array(
      z.object({
        alias: z.array(z.string()).optional(),
        aliasAssigned: z.union([z.number(), z.boolean()]).optional().nullable(),
        aliasError: z
          .object({
            code: z.string(),
            message: z.string(),
          })
          .optional()
          .nullable(),
        aliasFinal: z.string().optional().nullable(),
        automaticAliases: z.array(z.string()).optional(),
        buildingAt: z.number().optional(),
        builds: z
          .array(
            z.object({
              dest: z.string().optional(),
              src: z.string().optional(),
              use: z.string(),
            }),
          )
          .optional(),
        checksConclusion: z
          .union([z.literal('succeeded'), z.literal('failed'), z.literal('skipped'), z.literal('canceled')])
          .optional(),
        checksState: z.union([z.literal('registered'), z.literal('running'), z.literal('completed')]).optional(),
        connectConfigurationId: z.string().optional(),
        createdAt: z.number(),
        createdIn: z.string(),
        creator: z
          .object({
            email: z.string(),
            githubLogin: z.string().optional(),
            gitlabLogin: z.string().optional(),
            uid: z.string(),
            username: z.string(),
          })
          .nullable(),
        deploymentHostname: z.string(),
        forced: z.boolean().optional(),
        id: z.string(),
        meta: z.record(z.string()).optional(),
        monorepoManager: z.string().optional().nullable(),
        name: z.string(),
        plan: z.union([z.literal('hobby'), z.literal('enterprise'), z.literal('pro'), z.literal('oss')]),
        previewCommentsEnabled: z.boolean().optional(),
        private: z.boolean(),
        readyAt: z.number().optional(),
        readyState: z.union([
          z.literal('BUILDING'),
          z.literal('ERROR'),
          z.literal('INITIALIZING'),
          z.literal('QUEUED'),
          z.literal('READY'),
          z.literal('CANCELED'),
        ]),
        requestedAt: z.number().optional(),
        target: z.string().optional().nullable(),
        teamId: z.string().optional().nullable(),
        type: z.literal('LAMBDAS'),
        url: z.string(),
        userId: z.string(),
        withCache: z.boolean().optional(),
      }),
    )
    .optional(),
  link: z
    .union([
      z.object({
        createdAt: z.number().optional(),
        deployHooks: z.array(
          z.object({
            createdAt: z.number().optional(),
            id: z.string(),
            name: z.string(),
            ref: z.string(),
            url: z.string(),
          }),
        ),
        gitCredentialId: z.string().optional(),
        org: z.string().optional(),
        productionBranch: z.string().optional(),
        repo: z.string().optional(),
        repoId: z.number().optional(),
        sourceless: z.boolean().optional(),
        type: z.literal('github').optional(),
        updatedAt: z.number().optional(),
      }),
      z.object({
        createdAt: z.number().optional(),
        deployHooks: z.array(
          z.object({
            createdAt: z.number().optional(),
            id: z.string(),
            name: z.string(),
            ref: z.string(),
            url: z.string(),
          }),
        ),
        gitCredentialId: z.string().optional(),
        productionBranch: z.string().optional(),
        projectId: z.string().optional(),
        projectName: z.string().optional(),
        projectNameWithNamespace: z.string().optional(),
        projectNamespace: z.string().optional(),
        projectUrl: z.string().optional(),
        sourceless: z.boolean().optional(),
        type: z.literal('gitlab').optional(),
        updatedAt: z.number().optional(),
      }),
      z.object({
        createdAt: z.number().optional(),
        deployHooks: z.array(
          z.object({
            createdAt: z.number().optional(),
            id: z.string(),
            name: z.string(),
            ref: z.string(),
            url: z.string(),
          }),
        ),
        gitCredentialId: z.string().optional(),
        name: z.string().optional(),
        owner: z.string().optional(),
        productionBranch: z.string().optional(),
        slug: z.string().optional(),
        sourceless: z.boolean().optional(),
        type: z.literal('bitbucket').optional(),
        updatedAt: z.number().optional(),
        uuid: z.string().optional(),
        workspaceUuid: z.string().optional(),
      }),
    ])
    .optional(),
  live: z.boolean().optional(),
  name: z.string(),
  nodeVersion: z.union([z.literal('18.x'), z.literal('16.x'), z.literal('14.x'), z.literal('12.x'), z.literal('10.x')]),
  outputDirectory: z.string().optional().nullable(),
  passwordProtection: z
    .object({
      deploymentType: z.union([z.literal('preview'), z.literal('all')]),
    })
    .optional()
    .nullable(),
  permissions: z
    .object({
      Monitoring: z.array(aCLActionSchema).optional(),
      aliasGlobal: z.array(aCLActionSchema).optional(),
      aliasProject: z.array(aCLActionSchema).optional(),
      aliasProtectionBypass: z.array(aCLActionSchema).optional(),
      analytics: z.array(aCLActionSchema).optional(),
      analyticsSampling: z.array(aCLActionSchema).optional(),
      analyticsUsage: z.array(aCLActionSchema).optional(),
      auditLog: z.array(aCLActionSchema).optional(),
      billingAddress: z.array(aCLActionSchema).optional(),
      billingInformation: z.array(aCLActionSchema).optional(),
      billingInvoice: z.array(aCLActionSchema).optional(),
      billingInvoiceEmailRecipient: z.array(aCLActionSchema).optional(),
      billingInvoiceLanguage: z.array(aCLActionSchema).optional(),
      billingPlan: z.array(aCLActionSchema).optional(),
      billingPurchaseOrder: z.array(aCLActionSchema).optional(),
      billingTaxId: z.array(aCLActionSchema).optional(),
      blob: z.array(aCLActionSchema).optional(),
      cacheArtifact: z.array(aCLActionSchema).optional(),
      cacheArtifactUsageEvent: z.array(aCLActionSchema).optional(),
      concurrentBuilds: z.array(aCLActionSchema).optional(),
      connect: z.array(aCLActionSchema).optional(),
      connectConfiguration: z.array(aCLActionSchema).optional(),
      connectConfigurationLink: z.array(aCLActionSchema).optional(),
      deployment: z.array(aCLActionSchema).optional(),
      deploymentCheck: z.array(aCLActionSchema).optional(),
      deploymentCheckPreview: z.array(aCLActionSchema).optional(),
      deploymentCheckReRunFromProductionBranch: z.array(aCLActionSchema).optional(),
      deploymentPreview: z.array(aCLActionSchema).optional(),
      deploymentPrivate: z.array(aCLActionSchema).optional(),
      deploymentProductionGit: z.array(aCLActionSchema).optional(),
      deploymentRollback: z.array(aCLActionSchema).optional(),
      domain: z.array(aCLActionSchema).optional(),
      domainAcceptDelegation: z.array(aCLActionSchema).optional(),
      domainAuthCodes: z.array(aCLActionSchema).optional(),
      domainCertificate: z.array(aCLActionSchema).optional(),
      domainCheckConfig: z.array(aCLActionSchema).optional(),
      domainMove: z.array(aCLActionSchema).optional(),
      domainPurchase: z.array(aCLActionSchema).optional(),
      domainRecord: z.array(aCLActionSchema).optional(),
      domainTransferIn: z.array(aCLActionSchema).optional(),
      edgeConfig: z.array(aCLActionSchema).optional(),
      edgeConfigItem: z.array(aCLActionSchema).optional(),
      edgeConfigToken: z.array(aCLActionSchema).optional(),
      endpointVerification: z.array(aCLActionSchema).optional(),
      event: z.array(aCLActionSchema).optional(),
      fileUpload: z.array(aCLActionSchema).optional(),
      gitRepository: z.array(aCLActionSchema).optional(),
      integration: z.array(aCLActionSchema).optional(),
      integrationConfiguration: z.array(aCLActionSchema).optional(),
      integrationConfigurationProjects: z.array(aCLActionSchema).optional(),
      integrationConfigurationTransfer: z.array(aCLActionSchema).optional(),
      integrationVercelConfigurationOverride: z.array(aCLActionSchema).optional(),
      ipBlocking: z.array(aCLActionSchema).optional(),
      job: z.array(aCLActionSchema).optional(),
      logDrain: z.array(aCLActionSchema).optional(),
      monitoringChart: z.array(aCLActionSchema).optional(),
      monitoringQuery: z.array(aCLActionSchema).optional(),
      notificationDomainConfiguration: z.array(aCLActionSchema).optional(),
      notificationDomainExpire: z.array(aCLActionSchema).optional(),
      notificationDomainMoved: z.array(aCLActionSchema).optional(),
      notificationDomainPurchase: z.array(aCLActionSchema).optional(),
      notificationDomainRenewal: z.array(aCLActionSchema).optional(),
      notificationDomainTransfer: z.array(aCLActionSchema).optional(),
      notificationDomainUnverified: z.array(aCLActionSchema).optional(),
      notificationPaymentFailed: z.array(aCLActionSchema).optional(),
      notificationSpendCap: z.array(aCLActionSchema).optional(),
      notificationUsageAlert: z.array(aCLActionSchema).optional(),
      openTelemetryEndpoint: z.array(aCLActionSchema).optional(),
      passwordProtection: z.array(aCLActionSchema).optional(),
      paymentMethod: z.array(aCLActionSchema).optional(),
      permissions: z.array(aCLActionSchema).optional(),
      postgres: z.array(aCLActionSchema).optional(),
      previewDeploymentSuffix: z.array(aCLActionSchema).optional(),
      proTrialOnboarding: z.array(aCLActionSchema).optional(),
      project: z.array(aCLActionSchema).optional(),
      projectDeploymentHook: z.array(aCLActionSchema).optional(),
      projectDomain: z.array(aCLActionSchema).optional(),
      projectDomainMove: z.array(aCLActionSchema).optional(),
      projectEnvVars: z.array(aCLActionSchema).optional(),
      projectEnvVarsProduction: z.array(aCLActionSchema).optional(),
      projectEnvVarsUnownedByIntegration: z.array(aCLActionSchema).optional(),
      projectIntegrationConfiguration: z.array(aCLActionSchema).optional(),
      projectLink: z.array(aCLActionSchema).optional(),
      projectMember: z.array(aCLActionSchema).optional(),
      projectProductionBranch: z.array(aCLActionSchema).optional(),
      projectProtectionBypass: z.array(aCLActionSchema).optional(),
      projectTransfer: z.array(aCLActionSchema).optional(),
      rateLimit: z.array(aCLActionSchema).optional(),
      redis: z.array(aCLActionSchema).optional(),
      remoteCaching: z.array(aCLActionSchema).optional(),
      samlConfig: z.array(aCLActionSchema).optional(),
      secret: z.array(aCLActionSchema).optional(),
      sensitiveEnvironmentVariablePolicy: z.array(aCLActionSchema).optional(),
      sharedEnvVars: z.array(aCLActionSchema).optional(),
      sharedEnvVarsProduction: z.array(aCLActionSchema).optional(),
      spendCapConfiguration: z.array(aCLActionSchema).optional(),
      spendCapState: z.array(aCLActionSchema).optional(),
      supportCase: z.array(aCLActionSchema).optional(),
      supportCaseComment: z.array(aCLActionSchema).optional(),
      team: z.array(aCLActionSchema).optional(),
      teamAccessRequest: z.array(aCLActionSchema).optional(),
      teamFellowMembership: z.array(aCLActionSchema).optional(),
      teamInvite: z.array(aCLActionSchema).optional(),
      teamInviteCode: z.array(aCLActionSchema).optional(),
      teamJoin: z.array(aCLActionSchema).optional(),
      teamOwnMembership: z.array(aCLActionSchema).optional(),
      teamOwnMembershipDisconnectSAML: z.array(aCLActionSchema).optional(),
      token: z.array(aCLActionSchema).optional(),
      usage: z.array(aCLActionSchema).optional(),
      user: z.array(aCLActionSchema).optional(),
      userConnection: z.array(aCLActionSchema).optional(),
      webAnalytics: z.array(aCLActionSchema).optional(),
      webAnalyticsPlan: z.array(aCLActionSchema).optional(),
      webhook: z.array(aCLActionSchema).optional(),
      'webhook-event': z.array(aCLActionSchema).optional(),
    })
    .optional(),
  protectionBypass: z.record(z.string()).optional(),
  publicSource: z.boolean().optional().nullable(),
  rootDirectory: z.string().optional().nullable(),
  serverlessFunctionRegion: z.string().optional().nullable(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  ssoProtection: z
    .object({
      deploymentType: z.union([z.literal('preview'), z.literal('all')]),
    })
    .optional()
    .nullable(),
  targets: z.record(z.string()).optional(),
  transferCompletedAt: z.number().optional(),
  transferStartedAt: z.number().optional(),
  transferToAccountId: z.string().optional(),
  transferredFromAccountId: z.string().optional(),
  updatedAt: z.number().optional(),
});

export const getProjectErrorSchema = z.unknown();

export const updateProjectDataSchema = z.object({
  body: z
    .object({
      autoExposeSystemEnvs: z.boolean().optional(),
      buildCommand: z.string().optional().nullable(),
      commandForIgnoringBuildStep: z.string().optional().nullable(),
      devCommand: z.string().optional().nullable(),
      directoryListing: z.boolean().optional(),
      enablePreviewFeedback: z.boolean().optional().nullable(),
      framework: z
        .union([
          z.literal('blitzjs'),
          z.literal('nextjs'),
          z.literal('gatsby'),
          z.literal('remix'),
          z.literal('astro'),
          z.literal('hexo'),
          z.literal('eleventy'),
          z.literal('docusaurus-2'),
          z.literal('docusaurus'),
          z.literal('preact'),
          z.literal('solidstart'),
          z.literal('dojo'),
          z.literal('ember'),
          z.literal('vue'),
          z.literal('scully'),
          z.literal('ionic-angular'),
          z.literal('angular'),
          z.literal('polymer'),
          z.literal('svelte'),
          z.literal('sveltekit'),
          z.literal('sveltekit-1'),
          z.literal('ionic-react'),
          z.literal('create-react-app'),
          z.literal('gridsome'),
          z.literal('umijs'),
          z.literal('sapper'),
          z.literal('saber'),
          z.literal('stencil'),
          z.literal('nuxtjs'),
          z.literal('redwoodjs'),
          z.literal('hugo'),
          z.literal('jekyll'),
          z.literal('brunch'),
          z.literal('middleman'),
          z.literal('zola'),
          z.literal('hydrogen'),
          z.literal('vite'),
          z.literal('vitepress'),
          z.literal('vuepress'),
          z.literal('parcel'),
          z.literal('sanity'),
        ])
        .optional()
        .nullable(),
      gitForkProtection: z.boolean().optional(),
      gitLFS: z.boolean().optional(),
      installCommand: z.string().optional().nullable(),
      name: z.string().optional(),
      nodeVersion: z
        .union([z.literal('18.x'), z.literal('16.x'), z.literal('14.x'), z.literal('12.x'), z.literal('10.x')])
        .optional(),
      outputDirectory: z.string().optional().nullable(),
      passwordProtection: z
        .object({
          deploymentType: z.union([z.literal('all'), z.literal('preview')]),
          password: z.string().optional().nullable(),
        })
        .optional()
        .nullable(),
      publicSource: z.boolean().optional().nullable(),
      rootDirectory: z.string().optional().nullable(),
      serverlessFunctionRegion: z.string().optional().nullable(),
      skipGitConnectDuringLink: z.boolean().optional(),
      sourceFilesOutsideRootDirectory: z.boolean().optional(),
      ssoProtection: z
        .object({
          deploymentType: z.union([z.literal('all'), z.literal('preview')]),
        })
        .optional()
        .nullable(),
    })
    .optional(),
  path: z.object({
    idOrName: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const updateProjectResponseSchema = z.object({
  accountId: z.string(),
  analytics: z
    .object({
      canceledAt: z.number().nullable(),
      disabledAt: z.number(),
      enabledAt: z.number(),
      id: z.string(),
      paidAt: z.number().optional(),
      sampleRatePercent: z.number().optional().nullable(),
      spendLimitInDollars: z.number().optional().nullable(),
    })
    .optional(),
  autoExposeSystemEnvs: z.boolean().optional(),
  buildCommand: z.string().optional().nullable(),
  commandForIgnoringBuildStep: z.string().optional().nullable(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional().nullable(),
  createdAt: z.number().optional(),
  devCommand: z.string().optional().nullable(),
  directoryListing: z.boolean(),
  enablePreviewFeedback: z.boolean().optional().nullable(),
  env: z
    .array(
      z.object({
        configurationId: z.string().optional().nullable(),
        createdAt: z.number().optional(),
        createdBy: z.string().optional().nullable(),
        decrypted: z.boolean().optional(),
        edgeConfigId: z.string().optional().nullable(),
        edgeConfigTokenId: z.string().optional().nullable(),
        gitBranch: z.string().optional(),
        id: z.string().optional(),
        key: z.string(),
        target: z
          .union([
            z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
            z.literal('production'),
            z.literal('preview'),
            z.literal('development'),
          ])
          .optional(),
        type: z.union([
          z.literal('secret'),
          z.literal('system'),
          z.literal('encrypted'),
          z.literal('plain'),
          z.literal('sensitive'),
        ]),
        updatedAt: z.number().optional(),
        updatedBy: z.string().optional().nullable(),
        value: z.string(),
      }),
    )
    .optional(),
  framework: z
    .union([
      z.literal('blitzjs'),
      z.literal('nextjs'),
      z.literal('gatsby'),
      z.literal('remix'),
      z.literal('astro'),
      z.literal('hexo'),
      z.literal('eleventy'),
      z.literal('docusaurus-2'),
      z.literal('docusaurus'),
      z.literal('preact'),
      z.literal('solidstart'),
      z.literal('dojo'),
      z.literal('ember'),
      z.literal('vue'),
      z.literal('scully'),
      z.literal('ionic-angular'),
      z.literal('angular'),
      z.literal('polymer'),
      z.literal('svelte'),
      z.literal('sveltekit'),
      z.literal('sveltekit-1'),
      z.literal('ionic-react'),
      z.literal('create-react-app'),
      z.literal('gridsome'),
      z.literal('umijs'),
      z.literal('sapper'),
      z.literal('saber'),
      z.literal('stencil'),
      z.literal('nuxtjs'),
      z.literal('redwoodjs'),
      z.literal('hugo'),
      z.literal('jekyll'),
      z.literal('brunch'),
      z.literal('middleman'),
      z.literal('zola'),
      z.literal('hydrogen'),
      z.literal('vite'),
      z.literal('vitepress'),
      z.literal('vuepress'),
      z.literal('parcel'),
      z.literal('sanity'),
    ])
    .optional()
    .nullable(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  hasActiveBranches: z.boolean().optional(),
  hasFloatingAliases: z.boolean().optional(),
  id: z.string(),
  installCommand: z.string().optional().nullable(),
  lastRollbackTarget: z
    .object({
      fromDeploymentId: z.string(),
      jobStatus: z.union([
        z.literal('succeeded'),
        z.literal('failed'),
        z.literal('skipped'),
        z.literal('pending'),
        z.literal('in-progress'),
      ]),
      requestedAt: z.number(),
      toDeploymentId: z.string(),
    })
    .optional()
    .nullable(),
  latestDeployments: z
    .array(
      z.object({
        alias: z.array(z.string()).optional(),
        aliasAssigned: z.union([z.number(), z.boolean()]).optional().nullable(),
        aliasError: z
          .object({
            code: z.string(),
            message: z.string(),
          })
          .optional()
          .nullable(),
        aliasFinal: z.string().optional().nullable(),
        automaticAliases: z.array(z.string()).optional(),
        buildingAt: z.number().optional(),
        builds: z
          .array(
            z.object({
              dest: z.string().optional(),
              src: z.string().optional(),
              use: z.string(),
            }),
          )
          .optional(),
        checksConclusion: z
          .union([z.literal('succeeded'), z.literal('failed'), z.literal('skipped'), z.literal('canceled')])
          .optional(),
        checksState: z.union([z.literal('registered'), z.literal('running'), z.literal('completed')]).optional(),
        connectConfigurationId: z.string().optional(),
        createdAt: z.number(),
        createdIn: z.string(),
        creator: z
          .object({
            email: z.string(),
            githubLogin: z.string().optional(),
            gitlabLogin: z.string().optional(),
            uid: z.string(),
            username: z.string(),
          })
          .nullable(),
        deploymentHostname: z.string(),
        forced: z.boolean().optional(),
        id: z.string(),
        meta: z.record(z.string()).optional(),
        monorepoManager: z.string().optional().nullable(),
        name: z.string(),
        plan: z.union([z.literal('hobby'), z.literal('enterprise'), z.literal('pro'), z.literal('oss')]),
        previewCommentsEnabled: z.boolean().optional(),
        private: z.boolean(),
        readyAt: z.number().optional(),
        readyState: z.union([
          z.literal('BUILDING'),
          z.literal('ERROR'),
          z.literal('INITIALIZING'),
          z.literal('QUEUED'),
          z.literal('READY'),
          z.literal('CANCELED'),
        ]),
        requestedAt: z.number().optional(),
        target: z.string().optional().nullable(),
        teamId: z.string().optional().nullable(),
        type: z.literal('LAMBDAS'),
        url: z.string(),
        userId: z.string(),
        withCache: z.boolean().optional(),
      }),
    )
    .optional(),
  link: z
    .union([
      z.object({
        createdAt: z.number().optional(),
        deployHooks: z.array(
          z.object({
            createdAt: z.number().optional(),
            id: z.string(),
            name: z.string(),
            ref: z.string(),
            url: z.string(),
          }),
        ),
        gitCredentialId: z.string().optional(),
        org: z.string().optional(),
        productionBranch: z.string().optional(),
        repo: z.string().optional(),
        repoId: z.number().optional(),
        sourceless: z.boolean().optional(),
        type: z.literal('github').optional(),
        updatedAt: z.number().optional(),
      }),
      z.object({
        createdAt: z.number().optional(),
        deployHooks: z.array(
          z.object({
            createdAt: z.number().optional(),
            id: z.string(),
            name: z.string(),
            ref: z.string(),
            url: z.string(),
          }),
        ),
        gitCredentialId: z.string().optional(),
        productionBranch: z.string().optional(),
        projectId: z.string().optional(),
        projectName: z.string().optional(),
        projectNameWithNamespace: z.string().optional(),
        projectNamespace: z.string().optional(),
        projectUrl: z.string().optional(),
        sourceless: z.boolean().optional(),
        type: z.literal('gitlab').optional(),
        updatedAt: z.number().optional(),
      }),
      z.object({
        createdAt: z.number().optional(),
        deployHooks: z.array(
          z.object({
            createdAt: z.number().optional(),
            id: z.string(),
            name: z.string(),
            ref: z.string(),
            url: z.string(),
          }),
        ),
        gitCredentialId: z.string().optional(),
        name: z.string().optional(),
        owner: z.string().optional(),
        productionBranch: z.string().optional(),
        slug: z.string().optional(),
        sourceless: z.boolean().optional(),
        type: z.literal('bitbucket').optional(),
        updatedAt: z.number().optional(),
        uuid: z.string().optional(),
        workspaceUuid: z.string().optional(),
      }),
    ])
    .optional(),
  live: z.boolean().optional(),
  name: z.string(),
  nodeVersion: z.union([z.literal('18.x'), z.literal('16.x'), z.literal('14.x'), z.literal('12.x'), z.literal('10.x')]),
  outputDirectory: z.string().optional().nullable(),
  passwordProtection: z
    .object({
      deploymentType: z.union([z.literal('all'), z.literal('preview')]),
    })
    .optional()
    .nullable(),
  permissions: z
    .object({
      Monitoring: z.array(aCLActionSchema).optional(),
      aliasGlobal: z.array(aCLActionSchema).optional(),
      aliasProject: z.array(aCLActionSchema).optional(),
      aliasProtectionBypass: z.array(aCLActionSchema).optional(),
      analytics: z.array(aCLActionSchema).optional(),
      analyticsSampling: z.array(aCLActionSchema).optional(),
      analyticsUsage: z.array(aCLActionSchema).optional(),
      auditLog: z.array(aCLActionSchema).optional(),
      billingAddress: z.array(aCLActionSchema).optional(),
      billingInformation: z.array(aCLActionSchema).optional(),
      billingInvoice: z.array(aCLActionSchema).optional(),
      billingInvoiceEmailRecipient: z.array(aCLActionSchema).optional(),
      billingInvoiceLanguage: z.array(aCLActionSchema).optional(),
      billingPlan: z.array(aCLActionSchema).optional(),
      billingPurchaseOrder: z.array(aCLActionSchema).optional(),
      billingTaxId: z.array(aCLActionSchema).optional(),
      blob: z.array(aCLActionSchema).optional(),
      cacheArtifact: z.array(aCLActionSchema).optional(),
      cacheArtifactUsageEvent: z.array(aCLActionSchema).optional(),
      concurrentBuilds: z.array(aCLActionSchema).optional(),
      connect: z.array(aCLActionSchema).optional(),
      connectConfiguration: z.array(aCLActionSchema).optional(),
      connectConfigurationLink: z.array(aCLActionSchema).optional(),
      deployment: z.array(aCLActionSchema).optional(),
      deploymentCheck: z.array(aCLActionSchema).optional(),
      deploymentCheckPreview: z.array(aCLActionSchema).optional(),
      deploymentCheckReRunFromProductionBranch: z.array(aCLActionSchema).optional(),
      deploymentPreview: z.array(aCLActionSchema).optional(),
      deploymentPrivate: z.array(aCLActionSchema).optional(),
      deploymentProductionGit: z.array(aCLActionSchema).optional(),
      deploymentRollback: z.array(aCLActionSchema).optional(),
      domain: z.array(aCLActionSchema).optional(),
      domainAcceptDelegation: z.array(aCLActionSchema).optional(),
      domainAuthCodes: z.array(aCLActionSchema).optional(),
      domainCertificate: z.array(aCLActionSchema).optional(),
      domainCheckConfig: z.array(aCLActionSchema).optional(),
      domainMove: z.array(aCLActionSchema).optional(),
      domainPurchase: z.array(aCLActionSchema).optional(),
      domainRecord: z.array(aCLActionSchema).optional(),
      domainTransferIn: z.array(aCLActionSchema).optional(),
      edgeConfig: z.array(aCLActionSchema).optional(),
      edgeConfigItem: z.array(aCLActionSchema).optional(),
      edgeConfigToken: z.array(aCLActionSchema).optional(),
      endpointVerification: z.array(aCLActionSchema).optional(),
      event: z.array(aCLActionSchema).optional(),
      fileUpload: z.array(aCLActionSchema).optional(),
      gitRepository: z.array(aCLActionSchema).optional(),
      integration: z.array(aCLActionSchema).optional(),
      integrationConfiguration: z.array(aCLActionSchema).optional(),
      integrationConfigurationProjects: z.array(aCLActionSchema).optional(),
      integrationConfigurationTransfer: z.array(aCLActionSchema).optional(),
      integrationVercelConfigurationOverride: z.array(aCLActionSchema).optional(),
      ipBlocking: z.array(aCLActionSchema).optional(),
      job: z.array(aCLActionSchema).optional(),
      logDrain: z.array(aCLActionSchema).optional(),
      monitoringChart: z.array(aCLActionSchema).optional(),
      monitoringQuery: z.array(aCLActionSchema).optional(),
      notificationDomainConfiguration: z.array(aCLActionSchema).optional(),
      notificationDomainExpire: z.array(aCLActionSchema).optional(),
      notificationDomainMoved: z.array(aCLActionSchema).optional(),
      notificationDomainPurchase: z.array(aCLActionSchema).optional(),
      notificationDomainRenewal: z.array(aCLActionSchema).optional(),
      notificationDomainTransfer: z.array(aCLActionSchema).optional(),
      notificationDomainUnverified: z.array(aCLActionSchema).optional(),
      notificationPaymentFailed: z.array(aCLActionSchema).optional(),
      notificationSpendCap: z.array(aCLActionSchema).optional(),
      notificationUsageAlert: z.array(aCLActionSchema).optional(),
      openTelemetryEndpoint: z.array(aCLActionSchema).optional(),
      passwordProtection: z.array(aCLActionSchema).optional(),
      paymentMethod: z.array(aCLActionSchema).optional(),
      permissions: z.array(aCLActionSchema).optional(),
      postgres: z.array(aCLActionSchema).optional(),
      previewDeploymentSuffix: z.array(aCLActionSchema).optional(),
      proTrialOnboarding: z.array(aCLActionSchema).optional(),
      project: z.array(aCLActionSchema).optional(),
      projectDeploymentHook: z.array(aCLActionSchema).optional(),
      projectDomain: z.array(aCLActionSchema).optional(),
      projectDomainMove: z.array(aCLActionSchema).optional(),
      projectEnvVars: z.array(aCLActionSchema).optional(),
      projectEnvVarsProduction: z.array(aCLActionSchema).optional(),
      projectEnvVarsUnownedByIntegration: z.array(aCLActionSchema).optional(),
      projectIntegrationConfiguration: z.array(aCLActionSchema).optional(),
      projectLink: z.array(aCLActionSchema).optional(),
      projectMember: z.array(aCLActionSchema).optional(),
      projectProductionBranch: z.array(aCLActionSchema).optional(),
      projectProtectionBypass: z.array(aCLActionSchema).optional(),
      projectTransfer: z.array(aCLActionSchema).optional(),
      rateLimit: z.array(aCLActionSchema).optional(),
      redis: z.array(aCLActionSchema).optional(),
      remoteCaching: z.array(aCLActionSchema).optional(),
      samlConfig: z.array(aCLActionSchema).optional(),
      secret: z.array(aCLActionSchema).optional(),
      sensitiveEnvironmentVariablePolicy: z.array(aCLActionSchema).optional(),
      sharedEnvVars: z.array(aCLActionSchema).optional(),
      sharedEnvVarsProduction: z.array(aCLActionSchema).optional(),
      spendCapConfiguration: z.array(aCLActionSchema).optional(),
      spendCapState: z.array(aCLActionSchema).optional(),
      supportCase: z.array(aCLActionSchema).optional(),
      supportCaseComment: z.array(aCLActionSchema).optional(),
      team: z.array(aCLActionSchema).optional(),
      teamAccessRequest: z.array(aCLActionSchema).optional(),
      teamFellowMembership: z.array(aCLActionSchema).optional(),
      teamInvite: z.array(aCLActionSchema).optional(),
      teamInviteCode: z.array(aCLActionSchema).optional(),
      teamJoin: z.array(aCLActionSchema).optional(),
      teamOwnMembership: z.array(aCLActionSchema).optional(),
      teamOwnMembershipDisconnectSAML: z.array(aCLActionSchema).optional(),
      token: z.array(aCLActionSchema).optional(),
      usage: z.array(aCLActionSchema).optional(),
      user: z.array(aCLActionSchema).optional(),
      userConnection: z.array(aCLActionSchema).optional(),
      webAnalytics: z.array(aCLActionSchema).optional(),
      webAnalyticsPlan: z.array(aCLActionSchema).optional(),
      webhook: z.array(aCLActionSchema).optional(),
      'webhook-event': z.array(aCLActionSchema).optional(),
    })
    .optional(),
  protectionBypass: z.record(z.string()).optional(),
  publicSource: z.boolean().optional().nullable(),
  rootDirectory: z.string().optional().nullable(),
  serverlessFunctionRegion: z.string().optional().nullable(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  ssoProtection: z
    .object({
      deploymentType: z.union([z.literal('all'), z.literal('preview')]),
    })
    .optional()
    .nullable(),
  targets: z
    .record(
      z
        .object({
          alias: z.array(z.string()).optional(),
          aliasAssigned: z.union([z.number(), z.boolean()]).optional().nullable(),
          aliasError: z
            .object({
              code: z.string(),
              message: z.string(),
            })
            .optional()
            .nullable(),
          aliasFinal: z.string().optional().nullable(),
          automaticAliases: z.array(z.string()).optional(),
          buildingAt: z.number().optional(),
          builds: z
            .array(
              z.object({
                dest: z.string().optional(),
                src: z.string().optional(),
                use: z.string(),
              }),
            )
            .optional(),
          checksConclusion: z
            .union([z.literal('succeeded'), z.literal('failed'), z.literal('skipped'), z.literal('canceled')])
            .optional(),
          checksState: z.union([z.literal('registered'), z.literal('running'), z.literal('completed')]).optional(),
          connectConfigurationId: z.string().optional(),
          createdAt: z.number(),
          createdIn: z.string(),
          creator: z
            .object({
              email: z.string(),
              githubLogin: z.string().optional(),
              gitlabLogin: z.string().optional(),
              uid: z.string(),
              username: z.string(),
            })
            .nullable(),
          deploymentHostname: z.string(),
          forced: z.boolean().optional(),
          id: z.string(),
          meta: z.record(z.string()).optional(),
          monorepoManager: z.string().optional().nullable(),
          name: z.string(),
          plan: z.union([z.literal('hobby'), z.literal('enterprise'), z.literal('pro'), z.literal('oss')]),
          previewCommentsEnabled: z.boolean().optional(),
          private: z.boolean(),
          readyAt: z.number().optional(),
          readyState: z.union([
            z.literal('BUILDING'),
            z.literal('ERROR'),
            z.literal('INITIALIZING'),
            z.literal('QUEUED'),
            z.literal('READY'),
            z.literal('CANCELED'),
          ]),
          requestedAt: z.number().optional(),
          target: z.string().optional().nullable(),
          teamId: z.string().optional().nullable(),
          type: z.literal('LAMBDAS'),
          url: z.string(),
          userId: z.string(),
          withCache: z.boolean().optional(),
        })
        .nullable(),
    )
    .optional(),
  transferCompletedAt: z.number().optional(),
  transferStartedAt: z.number().optional(),
  transferToAccountId: z.string().optional(),
  transferredFromAccountId: z.string().optional(),
  updatedAt: z.number().optional(),
});

export const updateProjectErrorSchema = z.unknown();

export const getProjectDomainsDataSchema = z.object({
  path: z.object({
    idOrName: z.union([z.string(), z.number()]),
  }),
  query: z
    .object({
      gitBranch: z.string().optional(),
      limit: z.number().optional(),
      order: z.union([z.literal('ASC'), z.literal('DESC')]).optional(),
      production: z.union([z.literal('true'), z.literal('false')]).optional(),
      redirect: z.string().optional(),
      redirects: z.union([z.literal('true'), z.literal('false')]).optional(),
      since: z.number().optional(),
      teamId: z.string().optional(),
      until: z.number().optional(),
      verified: z.union([z.literal('true'), z.literal('false')]).optional(),
    })
    .optional(),
});

export const getProjectDomainsResponseSchema = z.object({
  domains: z.array(
    z.object({
      apexName: z.string(),
      createdAt: z.number().optional(),
      gitBranch: z.string().optional().nullable(),
      name: z.string(),
      projectId: z.string(),
      redirect: z.string().optional().nullable(),
      redirectStatusCode: z
        .union([z.literal(307), z.literal(301), z.literal(302), z.literal(308)])
        .optional()
        .nullable(),
      updatedAt: z.number().optional(),
      verification: z
        .array(
          z.object({
            domain: z.string(),
            reason: z.string(),
            type: z.string(),
            value: z.string(),
          }),
        )
        .optional(),
      verified: z.boolean(),
    }),
  ),
  pagination: paginationSchema,
});

export const getProjectDomainsErrorSchema = z.unknown();

export const removeProjectDomainDataSchema = z.object({
  path: z.object({
    domain: z.string(),
    idOrName: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const removeProjectDomainResponseSchema = z.record(z.unknown());

export const removeProjectDomainErrorSchema = z.unknown();

export const getProjectDomainDataSchema = z.object({
  path: z.object({
    domain: z.string(),
    idOrName: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const getProjectDomainResponseSchema = z.object({
  apexName: z.string(),
  createdAt: z.number().optional(),
  gitBranch: z.string().optional().nullable(),
  name: z.string(),
  projectId: z.string(),
  redirect: z.string().optional().nullable(),
  redirectStatusCode: z
    .union([z.literal(307), z.literal(301), z.literal(302), z.literal(308)])
    .optional()
    .nullable(),
  updatedAt: z.number().optional(),
  verification: z
    .array(
      z.object({
        domain: z.string(),
        reason: z.string(),
        type: z.string(),
        value: z.string(),
      }),
    )
    .optional(),
  verified: z.boolean(),
});

export const getProjectDomainErrorSchema = z.unknown();

export const updateProjectDomainDataSchema = z.object({
  body: z
    .object({
      gitBranch: z.string().optional().nullable(),
      redirect: z.string().optional().nullable(),
      redirectStatusCode: z
        .union([z.literal(301), z.literal(302), z.literal(307), z.literal(308)])
        .optional()
        .nullable(),
    })
    .optional(),
  path: z.object({
    domain: z.string(),
    idOrName: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const updateProjectDomainResponseSchema = z.object({
  apexName: z.string(),
  createdAt: z.number().optional(),
  gitBranch: z.string().optional().nullable(),
  name: z.string(),
  projectId: z.string(),
  redirect: z.string().optional().nullable(),
  redirectStatusCode: z
    .union([z.literal(307), z.literal(301), z.literal(302), z.literal(308)])
    .optional()
    .nullable(),
  updatedAt: z.number().optional(),
  verification: z
    .array(
      z.object({
        domain: z.string(),
        reason: z.string(),
        type: z.string(),
        value: z.string(),
      }),
    )
    .optional(),
  verified: z.boolean(),
});

export const updateProjectDomainErrorSchema = z.unknown();

export const verifyProjectDomainDataSchema = z.object({
  path: z.object({
    domain: z.string(),
    idOrName: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const verifyProjectDomainResponseSchema = z.object({
  apexName: z.string(),
  createdAt: z.number().optional(),
  gitBranch: z.string().optional().nullable(),
  name: z.string(),
  projectId: z.string(),
  redirect: z.string().optional().nullable(),
  redirectStatusCode: z
    .union([z.literal(307), z.literal(301), z.literal(302), z.literal(308)])
    .optional()
    .nullable(),
  updatedAt: z.number().optional(),
  verification: z
    .array(
      z.object({
        domain: z.string(),
        reason: z.string(),
        type: z.string(),
        value: z.string(),
      }),
    )
    .optional(),
  verified: z.boolean(),
});

export const verifyProjectDomainErrorSchema = z.unknown();

export const filterProjectEnvsDataSchema = z.object({
  path: z.object({
    idOrName: z.string(),
  }),
  query: z
    .object({
      decrypt: z.union([z.literal('true'), z.literal('false')]).optional(),
      gitBranch: z.string().optional(),
      source: z.string().optional(),
      teamId: z.string().optional(),
    })
    .optional(),
});

export const filterProjectEnvsResponseSchema = z.union([
  z.object({
    configurationId: z.string().optional().nullable(),
    createdAt: z.number().optional(),
    createdBy: z.string().optional().nullable(),
    decrypted: z.boolean().optional(),
    edgeConfigId: z.string().optional().nullable(),
    edgeConfigTokenId: z.string().optional().nullable(),
    gitBranch: z.string().optional(),
    id: z.string().optional(),
    key: z.string().optional(),
    system: z.boolean().optional(),
    target: z
      .union([
        z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
        z.literal('production'),
        z.literal('preview'),
        z.literal('development'),
      ])
      .optional(),
    type: z
      .union([
        z.literal('secret'),
        z.literal('system'),
        z.literal('encrypted'),
        z.literal('plain'),
        z.literal('sensitive'),
      ])
      .optional(),
    updatedAt: z.number().optional(),
    updatedBy: z.string().optional().nullable(),
    value: z.string().optional(),
  }),
  z.object({
    envs: z.array(
      z.object({
        configurationId: z.string().optional().nullable(),
        createdAt: z.number().optional(),
        createdBy: z.string().optional().nullable(),
        decrypted: z.boolean().optional(),
        edgeConfigId: z.string().optional().nullable(),
        edgeConfigTokenId: z.string().optional().nullable(),
        gitBranch: z.string().optional(),
        id: z.string().optional(),
        key: z.string().optional(),
        system: z.boolean().optional(),
        target: z
          .union([
            z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
            z.literal('production'),
            z.literal('preview'),
            z.literal('development'),
          ])
          .optional(),
        type: z
          .union([
            z.literal('secret'),
            z.literal('system'),
            z.literal('encrypted'),
            z.literal('plain'),
            z.literal('sensitive'),
          ])
          .optional(),
        updatedAt: z.number().optional(),
        updatedBy: z.string().optional().nullable(),
        value: z.string().optional(),
      }),
    ),
    pagination: paginationSchema,
  }),
  z.object({
    envs: z.array(
      z.object({
        configurationId: z.string().optional().nullable(),
        createdAt: z.number().optional(),
        createdBy: z.string().optional().nullable(),
        decrypted: z.boolean().optional(),
        edgeConfigId: z.string().optional().nullable(),
        edgeConfigTokenId: z.string().optional().nullable(),
        gitBranch: z.string().optional(),
        id: z.string().optional(),
        key: z.string().optional(),
        system: z.boolean().optional(),
        target: z
          .union([
            z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
            z.literal('production'),
            z.literal('preview'),
            z.literal('development'),
          ])
          .optional(),
        type: z
          .union([
            z.literal('secret'),
            z.literal('system'),
            z.literal('encrypted'),
            z.literal('plain'),
            z.literal('sensitive'),
          ])
          .optional(),
        updatedAt: z.number().optional(),
        updatedBy: z.string().optional().nullable(),
        value: z.string().optional(),
      }),
    ),
  }),
]);

export const filterProjectEnvsErrorSchema = z.unknown();

export const removeProjectEnvDataSchema = z.object({
  path: z.object({
    id: z.string(),
    idOrName: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const removeProjectEnvResponseSchema = z.union([
  z.array(
    z.object({
      configurationId: z.string().optional().nullable(),
      createdAt: z.number().optional(),
      createdBy: z.string().optional().nullable(),
      decrypted: z.boolean().optional(),
      edgeConfigId: z.string().optional().nullable(),
      edgeConfigTokenId: z.string().optional().nullable(),
      gitBranch: z.string().optional(),
      id: z.string().optional(),
      key: z.string(),
      target: z
        .union([
          z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
          z.literal('production'),
          z.literal('preview'),
          z.literal('development'),
        ])
        .optional(),
      type: z.union([
        z.literal('secret'),
        z.literal('system'),
        z.literal('encrypted'),
        z.literal('plain'),
        z.literal('sensitive'),
      ]),
      updatedAt: z.number().optional(),
      updatedBy: z.string().optional().nullable(),
      value: z.string(),
    }),
  ),
  z.object({
    configurationId: z.string().optional().nullable(),
    createdAt: z.number().optional(),
    createdBy: z.string().optional().nullable(),
    decrypted: z.boolean().optional(),
    edgeConfigId: z.string().optional().nullable(),
    edgeConfigTokenId: z.string().optional().nullable(),
    gitBranch: z.string().optional(),
    id: z.string().optional(),
    key: z.string(),
    system: z.boolean().optional(),
    target: z
      .union([
        z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
        z.literal('production'),
        z.literal('preview'),
        z.literal('development'),
      ])
      .optional(),
    type: z.union([
      z.literal('secret'),
      z.literal('system'),
      z.literal('encrypted'),
      z.literal('plain'),
      z.literal('sensitive'),
    ]),
    updatedAt: z.number().optional(),
    updatedBy: z.string().optional().nullable(),
    value: z.string(),
  }),
  z.object({
    configurationId: z.string().optional().nullable(),
    createdAt: z.number().optional(),
    createdBy: z.string().optional().nullable(),
    decrypted: z.boolean().optional(),
    edgeConfigId: z.string().optional().nullable(),
    edgeConfigTokenId: z.string().optional().nullable(),
    gitBranch: z.string().optional(),
    id: z.string().optional(),
    key: z.string(),
    target: z
      .union([
        z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
        z.literal('production'),
        z.literal('preview'),
        z.literal('development'),
      ])
      .optional(),
    type: z.union([
      z.literal('secret'),
      z.literal('system'),
      z.literal('encrypted'),
      z.literal('plain'),
      z.literal('sensitive'),
    ]),
    updatedAt: z.number().optional(),
    updatedBy: z.string().optional().nullable(),
    value: z.string(),
  }),
]);

export const removeProjectEnvErrorSchema = z.unknown();

export const editProjectEnvDataSchema = z.object({
  body: z
    .object({
      gitBranch: z.string().optional().nullable(),
      key: z.string().optional(),
      target: z
        .array(
          z.union([
            z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Productio'),
            z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Previe'),
            z.literal('mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Developmen'),
          ]),
        )
        .optional(),
      type: z
        .union([
          z.literal('system'),
          z.literal('secret'),
          z.literal('encrypted'),
          z.literal('plain'),
          z.literal('sensitive'),
        ])
        .optional(),
      value: z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
    idOrName: z.string(),
  }),
  query: z
    .object({
      teamId: z.string().optional(),
    })
    .optional(),
});

export const editProjectEnvResponseSchema = z.object({
  configurationId: z.string().optional().nullable(),
  createdAt: z.number().optional(),
  createdBy: z.string().optional().nullable(),
  decrypted: z.boolean().optional(),
  edgeConfigId: z.string().optional().nullable(),
  edgeConfigTokenId: z.string().optional().nullable(),
  gitBranch: z.string().optional(),
  id: z.string().optional(),
  key: z.string(),
  target: z
    .union([
      z.array(z.union([z.literal('production'), z.literal('preview'), z.literal('development')])),
      z.literal('production'),
      z.literal('preview'),
      z.literal('development'),
    ])
    .optional(),
  type: z.union([
    z.literal('system'),
    z.literal('encrypted'),
    z.literal('plain'),
    z.literal('sensitive'),
    z.literal('secret'),
  ]),
  updatedAt: z.number().optional(),
  updatedBy: z.string().optional().nullable(),
  value: z.string(),
});

export const editProjectEnvErrorSchema = z.unknown();

export const getEdgeConfigItemResponseSchema = edgeConfigItemSchema;
