// This file is auto-generated by @hey-api/openapi-ts

/**
 * Enum containing the actions that can be performed against a resource. Group operations are included.
 */
export type ACLAction = 'create' | 'delete' | 'read' | 'update' | 'list' | 'count';

/**
 * Authentication token metadata.
 */
export type AuthToken = {
  /**
   * Timestamp (in milliseconds) of when the token was most recently used.
   */
  activeAt: number;
  /**
   * Timestamp (in milliseconds) of when the token was created.
   */
  createdAt: number;
  /**
   * Timestamp (in milliseconds) of when the token expires.
   */
  expiresAt?: number;
  /**
   * The unique identifier of the token.
   */
  id: string;
  /**
   * The human-readable name of the token.
   */
  name: string;
  /**
   * The origin of how the token was created.
   */
  origin?: string;
  /**
   * The access scopes granted to the token.
   */
  scopes?: Array<
    | {
        createdAt: number;
        expiresAt?: number;
        origin: 'saml' | 'github' | 'gitlab' | 'bitbucket' | 'email' | 'manual';
        type: 'user';
      }
    | {
        createdAt: number;
        expiresAt?: number;
        origin: 'saml' | 'github' | 'gitlab' | 'bitbucket' | 'email' | 'manual';
        teamId: string;
        type: 'team';
      }
  >;
  /**
   * The type of the token.
   */
  type: string;
};

/**
 * Data for the currently authenticated User.
 */
export type AuthUser = {
  /**
   * set of dashboard view preferences (cards or list) per scopeId
   */
  activeDashboardViews?: Array<{
    scopeId: string;
    viewPreference: 'cards' | 'list';
  }>;
  /**
   * SHA1 hash of the avatar for the User account. Can be used in conjuction with the ... endpoint to retrieve the avatar image.
   */
  avatar: string | null;
  /**
   * An object containing billing infomation associated with the User account.
   */
  billing: {
    addons?: Array<'custom-deployment-suffix' | 'live-support'> | null;
    address?: {
      city?: string;
      country?: string;
      line1: string;
      line2?: string;
      postalCode?: string;
      state?: string;
    } | null;
    cancelation?: number | null;
    contract?: {
      end: number;
      start: number;
    } | null;
    controls?: {
      analyticsSampleRateInPercent?: number | null;
      analyticsSpendLimitInDollars?: number | null;
    } | null;
    currency?: 'usd' | 'eur';
    email?: string | null;
    invoiceItems?: {
      /**
       * Will be used to create an invoice item. The price must be in cents: 2000 for $20.
       */
      analytics?: {
        createdAt?: number;
        disabledAt?: number | null;
        frequency?: {
          interval: 'month';
          intervalCount: 1 | 3 | 2 | 6 | 12;
        };
        hidden: boolean;
        maxQuantity?: number;
        name?: string;
        price: number;
        quantity: number;
        tier?: number;
      };
      analyticsUsage?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
      artifacts?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
      bandwidth?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
      builds?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
      /**
       * Will be used to create an invoice item. The price must be in cents: 2000 for $20.
       */
      concurrentBuilds?: {
        createdAt?: number;
        disabledAt?: number | null;
        frequency?: {
          interval: 'month';
          intervalCount: 1 | 3 | 2 | 6 | 12;
        };
        hidden: boolean;
        maxQuantity?: number;
        name?: string;
        price: number;
        quantity: number;
        tier?: number;
      };
      cronJobInvocation?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
      /**
       * Will be used to create an invoice item. The price must be in cents: 2000 for $20.
       */
      customCerts?: {
        createdAt?: number;
        disabledAt?: number | null;
        frequency?: {
          interval: 'month';
          intervalCount: 1 | 3 | 2 | 6 | 12;
        };
        hidden: boolean;
        maxQuantity?: number;
        name?: string;
        price: number;
        quantity: number;
        tier?: number;
      };
      edgeConfigRead?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
      edgeConfigWrite?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
      edgeFunctionExecutionUnits?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
      edgeMiddlewareInvocations?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
      /**
       * Will be used to create an invoice item. The price must be in cents: 2000 for $20.
       */
      enterprise?: {
        createdAt?: number;
        disabledAt?: number | null;
        frequency?: {
          interval: 'month';
          intervalCount: 1 | 3 | 2 | 6 | 12;
        };
        hidden: boolean;
        maxQuantity?: number;
        name?: string;
        price: number;
        quantity: number;
        tier?: number;
      };
      /**
       * Will be used to create an invoice item. The price must be in cents: 2000 for $20.
       */
      monitoring?: {
        createdAt?: number;
        disabledAt?: number | null;
        frequency?: {
          interval: 'month';
          intervalCount: 1 | 3 | 2 | 6 | 12;
        };
        hidden: boolean;
        maxQuantity?: number;
        name?: string;
        price: number;
        quantity: number;
        tier?: number;
      };
      monitoringMetric?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
      /**
       * Will be used to create an invoice item. The price must be in cents: 2000 for $20.
       */
      passwordProtection?: {
        createdAt?: number;
        disabledAt?: number | null;
        frequency?: {
          interval: 'month';
          intervalCount: 1 | 3 | 2 | 6 | 12;
        };
        hidden: boolean;
        maxQuantity?: number;
        name?: string;
        price: number;
        quantity: number;
        tier?: number;
      };
      /**
       * Will be used to create an invoice item. The price must be in cents: 2000 for $20.
       */
      previewDeploymentSuffix?: {
        createdAt?: number;
        disabledAt?: number | null;
        frequency?: {
          interval: 'month';
          intervalCount: 1 | 3 | 2 | 6 | 12;
        };
        hidden: boolean;
        maxQuantity?: number;
        name?: string;
        price: number;
        quantity: number;
        tier?: number;
      };
      /**
       * Will be used to create an invoice item. The price must be in cents: 2000 for $20.
       */
      pro?: {
        createdAt?: number;
        disabledAt?: number | null;
        frequency?: {
          interval: 'month';
          intervalCount: 1 | 3 | 2 | 6 | 12;
        };
        hidden: boolean;
        maxQuantity?: number;
        name?: string;
        price: number;
        quantity: number;
        tier?: number;
      };
      /**
       * Will be used to create an invoice item. The price must be in cents: 2000 for $20.
       */
      saml?: {
        createdAt?: number;
        disabledAt?: number | null;
        frequency?: {
          interval: 'month';
          intervalCount: 1 | 3 | 2 | 6 | 12;
        };
        hidden: boolean;
        maxQuantity?: number;
        name?: string;
        price: number;
        quantity: number;
        tier?: number;
      };
      serverlessFunctionExecution?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
      sourceImages?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
      /**
       * Will be used to create an invoice item. The price must be in cents: 2000 for $20.
       */
      ssoProtection?: {
        createdAt?: number;
        disabledAt?: number | null;
        frequency?: {
          interval: 'month';
          intervalCount: 1 | 3 | 2 | 6 | 12;
        };
        hidden: boolean;
        maxQuantity?: number;
        name?: string;
        price: number;
        quantity: number;
        tier?: number;
      };
      /**
       * Will be used to create an invoice item. The price must be in cents: 2000 for $20.
       */
      teamSeats?: {
        createdAt?: number;
        disabledAt?: number | null;
        frequency?: {
          interval: 'month';
          intervalCount: 1 | 3 | 2 | 6 | 12;
        };
        hidden: boolean;
        maxQuantity?: number;
        name?: string;
        price: number;
        quantity: number;
        tier?: number;
      };
      /**
       * Will be used to create an invoice item. The price must be in cents: 2000 for $20.
       */
      webAnalytics?: {
        createdAt?: number;
        disabledAt?: number | null;
        frequency?: {
          interval: 'month';
          intervalCount: 1 | 3 | 2 | 6 | 12;
        };
        hidden: boolean;
        maxQuantity?: number;
        name?: string;
        price: number;
        quantity: number;
        tier?: number;
      };
      webAnalyticsEvent?: {
        batch: number;
        disabledAt?: number | null;
        hidden: boolean;
        name?: string;
        price: number;
        threshold: number;
        tier?: number;
      };
    } | null;
    invoiceSettings?: {
      footer?: string;
    };
    language?: string | null;
    name?: string | null;
    orbCustomerId?: string;
    overdue?: boolean | null;
    period: {
      end: number;
      start: number;
    } | null;
    plan: 'hobby' | 'enterprise' | 'pro';
    platform?: 'stripe' | 'stripeTestMode';
    pricingExperiment?: 'august-2022';
    programType?: 'startup' | 'agency';
    purchaseOrder?: string | null;
    status?: 'active' | 'canceled' | 'trialing' | 'overdue' | 'expired';
    subscriptions?: Array<{
      discount: {
        coupon: {
          amountOff: number | null;
          duration: 'forever' | 'repeating' | 'once';
          durationInMonths: number | null;
          id: string;
          name: string | null;
          percentageOff: number | null;
        };
        id: string;
      } | null;
      frequency: {
        interval: 'month' | 'day' | 'week' | 'year';
        intervalCount: number;
      };
      id: string;
      items: Array<{
        amount: number;
        id: string;
        priceId: string;
        productId: string;
        quantity: number;
      }>;
      period: {
        end: number;
        start: number;
      };
      trial: {
        end: number;
        start: number;
      } | null;
    }> | null;
    tax?: {
      id: string;
      type: string;
    } | null;
    trial?: {
      end: number;
      start: number;
    } | null;
  } | null;
  /**
   * UNIX timestamp (in milliseconds) when the User account was created.
   */
  createdAt: number;
  /**
   * A record of when, under a certain scopeId, a toast was dismissed
   */
  dismissedToasts?: Array<{
    dismissals: Array<{
      createdAt: number;
      scopeId: string;
    }>;
    name: string;
  }>;
  /**
   * Email address associated with the User account.
   */
  email: string;
  /**
   * A list of projects across teams that a user has marked as a favorite.
   */
  favoriteProjects?: Array<{
    projectId: string;
    scopeId: string;
    scopeSlug: string;
  }>;
  /**
   * Whether the user has a trial available for a paid plan subscription.
   */
  hasTrialAvailable: boolean;
  /**
   * The User's unique identifier.
   */
  id: string;
  importFlowGitNamespace?: (string | number) | null;
  importFlowGitNamespaceId?: (string | number) | null;
  importFlowGitProvider?: 'github' | 'gitlab' | 'bitbucket';
  /**
   * Name associated with the User account, or `null` if none has been provided.
   */
  name: string | null;
  preferredScopesAndGitNamespaces?: Array<{
    gitNamespaceId: (string | number) | null;
    scopeId: string;
  }>;
  /**
   * remote caching settings
   */
  remoteCaching?: {
    enabled?: boolean;
  };
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  resourceConfig: {
    awsAccountIds?: Array<string>;
    awsAccountType?: string;
    cfZoneName?: string;
    concurrentBuilds?: number;
    /**
     * To overwrite the maximum size of an Edge Config per account. Size is in kilobytes, eg 64 leads to 64kB or 64_000 bytes worth of storage
     */
    edgeConfigSize?: number;
    /**
     * To overwrite the number of Edge Configs an account can create.
     */
    edgeConfigs?: number;
    nodeType?: string;
  };
  /**
   * When the User account has been "soft blocked", this property will contain the date when the restriction was enacted, and the identifier for why.
   */
  softBlock: {
    blockedAt: number;
    reason:
      | 'FAIR_USE_LIMITS_EXCEEDED'
      | 'ENTERPRISE_TRIAL_ENDED'
      | 'BLOCKED_FOR_PLATFORM_ABUSE'
      | 'UNPAID_INVOICE'
      | 'SUBSCRIPTION_EXPIRED'
      | 'SUBSCRIPTION_CANCELED';
  } | null;
  /**
   * Prefix that will be used in the URL of "Preview" deployments created by the User account.
   */
  stagingPrefix: string;
  /**
   * Unique username associated with the User account.
   */
  username: string;
};

export type currency = 'usd' | 'eur';

export type interval = 'month';

export type intervalCount = 1 | 3 | 2 | 6 | 12;

export type plan = 'hobby' | 'enterprise' | 'pro';

export type platform = 'stripe' | 'stripeTestMode';

export type pricingExperiment = 'august-2022';

export type programType = 'startup' | 'agency';

export type status = 'active' | 'canceled' | 'trialing' | 'overdue' | 'expired';

export type importFlowGitProvider = 'github' | 'gitlab' | 'bitbucket';

export type reason =
  | 'FAIR_USE_LIMITS_EXCEEDED'
  | 'ENTERPRISE_TRIAL_ENDED'
  | 'BLOCKED_FOR_PLATFORM_ABUSE'
  | 'UNPAID_INVOICE'
  | 'SUBSCRIPTION_EXPIRED'
  | 'SUBSCRIPTION_CANCELED';

/**
 * A limited form of data for the currently authenticated User, due to the authentication token missing privileges to read the full User data.
 */
export type AuthUserLimited = {
  /**
   * SHA1 hash of the avatar for the User account. Can be used in conjuction with the ... endpoint to retrieve the avatar image.
   */
  avatar: string | null;
  /**
   * Email address associated with the User account.
   */
  email: string;
  /**
   * The User's unique identifier.
   */
  id: string;
  /**
   * Property indicating that this User data contains only limited information, due to the authentication token missing privileges to read the full User data. Re-login with email, GitHub, GitLab or Bitbucket in order to upgrade the authentication token with the necessary privileges.
   */
  limited: boolean;
  /**
   * Name associated with the User account, or `null` if none has been provided.
   */
  name: string | null;
  /**
   * Unique username associated with the User account.
   */
  username: string;
};

/**
 * The EdgeConfig.
 */
export type EdgeConfigItem = {
  createdAt: number;
  edgeConfigId: string;
  key: string;
  updatedAt: number;
  value: EdgeConfigItemValue;
};

export type EdgeConfigItemValue =
  | (
      | string
      | number
      | boolean
      | {
          [key: string]: unknown;
        }
      | Array<EdgeConfigItemValue>
    )
  | null;

/**
 * The EdgeConfig.
 */
export type EdgeConfigToken = {
  createdAt: number;
  edgeConfigId: string;
  /**
   * This is not the token itself, but rather an id to identify the token by
   */
  id: string;
  label: string;
  token: string;
};

/**
 * A deployment file tree entry
 */
export type FileTree = {
  /**
   * The list of children files of the directory (only valid for the `directory` type)
   */
  children?: Array<FileTree>;
  /**
   * The content-type of the file (only valid for the `file` type)
   */
  contentType?: string;
  /**
   * The file "mode" indicating file type and permissions.
   */
  mode: number;
  /**
   * The name of the file tree entry
   */
  name: string;
  /**
   * Not currently used. See `file-list-to-tree.ts`.
   */
  symlink?: string;
  /**
   * String indicating the type of file tree entry.
   */
  type: 'directory' | 'file' | 'symlink' | 'lambda' | 'middleware' | 'invalid';
  /**
   * The unique identifier of the file (only valid for the `file` type)
   */
  uid?: string;
};

/**
 * String indicating the type of file tree entry.
 */
export type type = 'directory' | 'file' | 'symlink' | 'lambda' | 'middleware' | 'invalid';

/**
 * This object contains information related to the pagination of the current request, including the necessary parameters to get the next or previous page of data.
 */
export type Pagination = {
  /**
   * Amount of items in the current page.
   */
  count: number;
  /**
   * Timestamp that must be used to request the next page.
   */
  next: number | null;
  /**
   * Timestamp that must be used to request the previous page.
   */
  prev: number | null;
};

/**
 * Data representing a Team.
 */
export type Team = {
  [key: string]: unknown;
};

/**
 * A limited form of data representing a Team, due to the authentication token missing privileges to read the full Team data.
 */
export type TeamLimited = {
  /**
   * The ID of the file used as avatar for this Team.
   */
  avatar: string | null;
  /**
   * Will remain undocumented. Remove in v3 API.
   */
  created: string;
  /**
   * UNIX timestamp (in milliseconds) when the Team was created.
   */
  createdAt: number;
  /**
   * The Team's unique identifier.
   */
  id: string;
  /**
   * Property indicating that this Team data contains only limited information, due to the authentication token missing privileges to read the full Team data. Re-login with the Team's configured SAML Single Sign-On provider in order to upgrade the authentication token with the necessary privileges.
   */
  limited: boolean;
  membership:
    | {
        accessRequestedAt?: number;
        confirmed: boolean;
        confirmedAt: number;
        created: number;
        createdAt: number;
        joinedFrom?: {
          commitId?: string;
          dsyncConnectedAt?: number;
          dsyncUserId?: string;
          gitUserId?: string | number;
          gitUserLogin?: string;
          idpUserId?: string;
          origin:
            | 'import'
            | 'saml'
            | 'mail'
            | 'link'
            | 'teams'
            | 'github'
            | 'gitlab'
            | 'bitbucket'
            | 'dsync'
            | 'feedback'
            | 'organization-teams';
          repoId?: string;
          repoPath?: string;
          ssoConnectedAt?: number;
          ssoUserId?: string;
        };
        role: 'MEMBER' | 'OWNER' | 'VIEWER' | 'DEVELOPER' | 'BILLING';
        teamId?: string;
        uid: string;
      }
    | {
        accessRequestedAt: number;
        confirmed: boolean;
        confirmedAt?: number;
        created: number;
        createdAt: number;
        joinedFrom?: {
          commitId?: string;
          dsyncConnectedAt?: number;
          dsyncUserId?: string;
          gitUserId?: string | number;
          gitUserLogin?: string;
          idpUserId?: string;
          origin:
            | 'import'
            | 'saml'
            | 'mail'
            | 'link'
            | 'teams'
            | 'github'
            | 'gitlab'
            | 'bitbucket'
            | 'dsync'
            | 'feedback'
            | 'organization-teams';
          repoId?: string;
          repoPath?: string;
          ssoConnectedAt?: number;
          ssoUserId?: string;
        };
        role: 'MEMBER' | 'OWNER' | 'VIEWER' | 'DEVELOPER' | 'BILLING';
        teamId?: string;
        uid: string;
      };
  /**
   * Name associated with the Team account, or `null` if none has been provided.
   */
  name: string | null;
  /**
   * When "Single Sign-On (SAML)" is configured, this object contains information that allows the client-side to identify whether or not this Team has SAML enforced.
   */
  saml?: {
    /**
     * From T, pick a set of properties whose keys are in the union K
     */
    connection?: {
      createdAt?: number | null;
      creator: string;
      domain: string;
      id: string;
      name: string;
      recordType: 'A' | 'AAAA' | 'ALIAS' | 'CAA' | 'CNAME' | 'MX' | 'SRV' | 'TXT' | 'NS';
      ttl?: number;
      type: 'record' | 'record-sys';
      value: string;
    };
    /**
     * From T, pick a set of properties whose keys are in the union K
     */
    directory?: {
      createdAt?: number | null;
      creator: string;
      domain: string;
      id: string;
      name: string;
      recordType: 'A' | 'AAAA' | 'ALIAS' | 'CAA' | 'CNAME' | 'MX' | 'SRV' | 'TXT' | 'NS';
      ttl?: number;
      type: 'record' | 'record-sys';
      value: string;
    };
    /**
     * When `true`, interactions with the Team **must** be done with an authentication token that has been authenticated with the Team's SAML Single Sign-On provider.
     */
    enforced: boolean;
  };
  /**
   * The Team's slug, which is unique across the Vercel platform.
   */
  slug: string;
};

export type origin =
  | 'import'
  | 'saml'
  | 'mail'
  | 'link'
  | 'teams'
  | 'github'
  | 'gitlab'
  | 'bitbucket'
  | 'dsync'
  | 'feedback'
  | 'organization-teams';

export type role = 'MEMBER' | 'OWNER' | 'VIEWER' | 'DEVELOPER' | 'BILLING';

export type recordType = 'A' | 'AAAA' | 'ALIAS' | 'CAA' | 'CNAME' | 'MX' | 'SRV' | 'TXT' | 'NS';

export type type2 = 'record' | 'record-sys';

/**
 * Array of events generated by the User.
 */
export type UserEvent = {
  /**
   * Timestamp (in milliseconds) of when the event was generated.
   */
  createdAt: number;
  /**
   * A list of "entities" within the event `text`. Useful for enhancing the displayed text with additional styling and links.
   */
  entities: Array<{
    /**
     * The index of where the entity ends within the `text` (non-inclusive).
     */
    end: number;
    /**
     * The index of where the entity begins within the `text` (inclusive).
     */
    start: number;
    /**
     * The type of entity.
     */
    type:
      | 'target'
      | 'author'
      | 'bitbucket_login'
      | 'bold'
      | 'deployment_host'
      | 'dns_record'
      | 'git_link'
      | 'github_login'
      | 'gitlab_login'
      | 'hook_name'
      | 'integration'
      | 'edge-config'
      | 'link'
      | 'project_name'
      | 'scaling_rules'
      | 'env_var_name'
      | 'system';
  }>;
  /**
   * The unique identifier of the Event.
   */
  id: string;
  /**
   * The human-readable text of the Event.
   */
  text: string;
  /**
   * Metadata for the User who generated the event.
   */
  user?: {
    avatar: string;
    email: string;
    slug?: string;
    uid: string;
    username: string;
  };
  /**
   * The unique identifier of the User who generated the event.
   */
  userId: string;
};

export type EmailLoginData = {
  body?: {
    /**
     * The user email.
     */
    email: string;
    /**
     * The desired name for the token. It will be displayed on the user account details.
     */
    tokenName?: string;
  };
};

export type EmailLoginResponse = {
  /**
   * The code the user is going to receive on the email. **Must** be displayed to the user so they can verify the request is the correct.
   */
  securityCode: string;
  /**
   * The token used to verify the user accepted the login request
   */
  token: string;
};

export type EmailLoginError = unknown;

export type VerifyTokenData = {
  query: {
    /**
     * Email to verify the login.
     */
    email?: string;
    /**
     * The SAML Profile ID, when connecting a SAML Profile to a Team member for the first time.
     */
    ssoUserId?: string;
    /**
     * The token returned when the login was requested.
     */
    token: string;
    /**
     * The desired name for the token. It will be displayed on the user account details.
     */
    tokenName?: string;
  };
};

export type VerifyTokenResponse = {
  /**
   * Email address of the authenticated user.
   */
  email: string;
  /**
   * When completing SAML Single Sign-On authentication, this will be the ID of the Team that was authenticated for.
   */
  teamId?: string;
  /**
   * The user authentication token that can be used to perform API requests.
   */
  token: string;
};

export type VerifyTokenError = unknown;

export type GetAllChecksData = {
  path: {
    /**
     * The deployment to get all checks for
     */
    deploymentId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetAllChecksResponse = {
  checks: Array<{
    completedAt?: number;
    conclusion?: 'canceled' | 'failed' | 'neutral' | 'succeeded' | 'skipped' | 'stale';
    createdAt: number;
    detailsUrl?: string;
    id: string;
    integrationId: string;
    name: string;
    output?: {
      metrics?: {
        CLS: {
          previousValue?: number;
          source: 'web-vitals';
          value: number | null;
        };
        FCP: {
          previousValue?: number;
          source: 'web-vitals';
          value: number | null;
        };
        LCP: {
          previousValue?: number;
          source: 'web-vitals';
          value: number | null;
        };
        TBT: {
          previousValue?: number;
          source: 'web-vitals';
          value: number | null;
        };
        virtualExperienceScore?: {
          previousValue?: number;
          source: 'web-vitals';
          value: number | null;
        };
      };
    };
    path?: string;
    rerequestable: boolean;
    startedAt?: number;
    status: 'registered' | 'running' | 'completed';
    updatedAt: number;
  }>;
};

export type GetAllChecksError = unknown;

export type CreateCheckData = {
  body?: {
    /**
     * Whether the check should block a deployment from succeeding
     */
    blocking: boolean;
    /**
     * URL to display for further details
     */
    detailsUrl?: string;
    /**
     * An identifier that can be used as an external reference
     */
    externalId?: string;
    /**
     * The name of the check being created
     */
    name: string;
    /**
     * Path of the page that is being checked
     */
    path?: string;
    /**
     * Whether a user should be able to request for the check to be rerun if it fails
     */
    rerequestable?: boolean;
  };
  path: {
    /**
     * The deployment to create the check for.
     */
    deploymentId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CreateCheckResponse = {
  /**
   * Timestamp (in milliseconds) of when the configuration was connected.
   */
  connectedAt: number;
  /**
   * Timestamp (in milliseconds) of when the last webhook event was received from WorkOS.
   */
  lastReceivedWebhookEvent?: number;
  /**
   * Current state of the connection.
   */
  state: string;
  /**
   * Current status of the connection.
   */
  status: string;
  /**
   * The Identity Provider "type", for example Okta.
   */
  type: string;
};

export type CreateCheckError = unknown;

export type GetCheckData = {
  path: {
    /**
     * The check to fetch
     */
    checkId: string;
    /**
     * The deployment to get the check for.
     */
    deploymentId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetCheckResponse = {
  createdAt?: number | null;
  creator: string;
  domain: string;
  id: string;
  name: string;
  recordType: 'A' | 'AAAA' | 'ALIAS' | 'CAA' | 'CNAME' | 'MX' | 'SRV' | 'TXT' | 'NS';
  ttl?: number;
  type: 'record' | 'record-sys';
  value: string;
};

export type GetCheckError = unknown;

export type UpdateCheckData = {
  body?: {
    /**
     * The result of the check being run
     */
    conclusion?: 'canceled' | 'failed' | 'neutral' | 'succeeded' | 'skipped';
    /**
     * A URL a user may visit to see more information about the check
     */
    detailsUrl?: string;
    /**
     * An identifier that can be used as an external reference
     */
    externalId?: string;
    /**
     * The name of the check being created
     */
    name?: string;
    /**
     * The results of the check Run
     */
    output?: {
      /**
       * Metrics about the page
       */
      metrics?: {
        CLS: {
          /**
           * Previous Cumulative Layout Shift value to display a delta
           */
          previousValue?: number;
          source: 'web-vitals';
          /**
           * Cumulative Layout Shift value
           */
          value: number | null;
        };
        FCP: {
          /**
           * Previous First Contentful Paint value to display a delta
           */
          previousValue?: number;
          source: 'web-vitals';
          /**
           * First Contentful Paint value
           */
          value: number | null;
        };
        LCP: {
          /**
           * Previous Largest Contentful Paint value to display a delta
           */
          previousValue?: number;
          source: 'web-vitals';
          /**
           * Largest Contentful Paint value
           */
          value: number | null;
        };
        TBT: {
          /**
           * Previous Total Blocking Time value to display a delta
           */
          previousValue?: number;
          source: 'web-vitals';
          /**
           * Total Blocking Time value
           */
          value: number | null;
        };
        virtualExperienceScore?: {
          /**
           * A previous Virtual Experience Score value to display a delta, between 0 and 100
           */
          previousValue?: number;
          source: 'web-vitals';
          /**
           * The calculated Virtual Experience Score value, between 0 and 100
           */
          value: number | null;
        };
      };
    };
    /**
     * Path of the page that is being checked
     */
    path?: string;
    /**
     * The current status of the check
     */
    status?: 'running' | 'completed';
  };
  path: {
    /**
     * The check being updated
     */
    checkId: string;
    /**
     * The deployment to update the check for.
     */
    deploymentId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type UpdateCheckResponse = {
  /**
   * Timestamp (in milliseconds) of when the configuration was connected.
   */
  connectedAt: number;
  /**
   * Timestamp (in milliseconds) of when the last webhook event was received from WorkOS.
   */
  lastReceivedWebhookEvent?: number;
  /**
   * Current state of the connection.
   */
  state: string;
  /**
   * Current status of the connection.
   */
  status: string;
  /**
   * The Identity Provider "type", for example Okta.
   */
  type: string;
};

export type UpdateCheckError = unknown;

export type RerequestCheckData = {
  path: {
    /**
     * The check to rerun
     */
    checkId: string;
    /**
     * The deployment to rerun the check for.
     */
    deploymentId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type RerequestCheckResponse = {
  [key: string]: unknown;
};

export type RerequestCheckError = unknown;

export type UpdateRecordData = {
  body?: {
    additionalProperties?: unknown;
    /**
     * The MX priority value of the DNS record
     */
    mxPriority?: number | null;
    /**
     * The name of the DNS record
     */
    name?: string | null;
    srv?: {
      port: number | null;
      priority: number | null;
      target: string | null;
      weight: number | null;
    } | null;
    /**
     * The Time to live (TTL) value of the DNS record
     */
    ttl?: number | null;
    /**
     * The type of the DNS record
     */
    type?: ('A' | 'AAAA' | 'ALIAS' | 'CAA' | 'CNAME' | 'MX' | 'SRV' | 'TXT' | 'NS') | null;
    /**
     * The value of the DNS record
     */
    value?: string | null;
  };
  path: {
    /**
     * The id of the DNS record
     */
    recordId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type UpdateRecordResponse = {
  createdAt?: number | null;
  creator: string;
  domain: string;
  id: string;
  name: string;
  recordType: 'A' | 'AAAA' | 'ALIAS' | 'CAA' | 'CNAME' | 'MX' | 'SRV' | 'TXT' | 'NS';
  ttl?: number;
  type: 'record' | 'record-sys';
  value: string;
};

export type UpdateRecordError = unknown;

export type GetEdgeConfigsData = {
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetEdgeConfigsResponse = {
  createdAt?: number | null;
  creator?: string;
  domain?: string;
  id?: string;
  itemCount: number;
  name?: string;
  recordType?: 'A' | 'AAAA' | 'ALIAS' | 'CAA' | 'CNAME' | 'MX' | 'SRV' | 'TXT' | 'NS';
  sizeInBytes: number;
  ttl?: number;
  type?: 'record' | 'record-sys';
  value?: string;
};

export type GetEdgeConfigsError = unknown;

export type CreateEdgeConfigData = {
  body?: {
    items?: {
      [key: string]:
        | (
            | string
            | number
            | boolean
            | null
            | {
                [key: string]: unknown;
              }
          )
        | Array<
            | string
            | number
            | boolean
            | null
            | {
                [key: string]: unknown;
              }
          >;
    };
    slug: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CreateEdgeConfigResponse = {
  /**
   * Timestamp (in milliseconds) of when the configuration was connected.
   */
  connectedAt?: number;
  itemCount: number;
  /**
   * Timestamp (in milliseconds) of when the last webhook event was received from WorkOS.
   */
  lastReceivedWebhookEvent?: number;
  sizeInBytes: number;
  /**
   * Current state of the connection.
   */
  state?: string;
  /**
   * Current status of the connection.
   */
  status?: string;
  /**
   * The Identity Provider "type", for example Okta.
   */
  type?: string;
};

export type CreateEdgeConfigError = unknown;

export type DeleteEdgeConfigData = {
  path: {
    edgeConfigId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type DeleteEdgeConfigResponse = any;

export type DeleteEdgeConfigError = unknown;

export type GetEdgeConfigData = {
  path: {
    edgeConfigId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetEdgeConfigResponse = {
  createdAt?: number | null;
  creator?: string;
  domain?: string;
  id?: string;
  itemCount: number;
  name?: string;
  recordType?: 'A' | 'AAAA' | 'ALIAS' | 'CAA' | 'CNAME' | 'MX' | 'SRV' | 'TXT' | 'NS';
  sizeInBytes: number;
  ttl?: number;
  type?: 'record' | 'record-sys';
  value?: string;
};

export type GetEdgeConfigError = unknown;

export type UpdateEdgeConfigData = {
  body?: {
    slug: string;
  };
  path: {
    edgeConfigId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type UpdateEdgeConfigResponse = {
  /**
   * Timestamp (in milliseconds) of when the configuration was connected.
   */
  connectedAt?: number;
  itemCount: number;
  /**
   * Timestamp (in milliseconds) of when the last webhook event was received from WorkOS.
   */
  lastReceivedWebhookEvent?: number;
  sizeInBytes: number;
  /**
   * Current state of the connection.
   */
  state?: string;
  /**
   * Current status of the connection.
   */
  status?: string;
  /**
   * The Identity Provider "type", for example Okta.
   */
  type?: string;
};

export type UpdateEdgeConfigError = unknown;

export type GetEdgeConfigItemData = {
  path: {
    edgeConfigId: string;
    edgeConfigItemKey: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetEdgeConfigItemResponse = EdgeConfigItem;

export type GetEdgeConfigItemError = unknown;

export type GetEdgeConfigItemsData = {
  path: {
    edgeConfigId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetEdgeConfigItemsResponse = EdgeConfigItem;

export type GetEdgeConfigItemsError = unknown;

export type PatchtEdgeConfigItemsData = {
  body?: {
    items: Array<
      | {
          key: string;
          operation: 'create' | 'update' | 'upsert';
          value:
            | (
                | string
                | number
                | boolean
                | null
                | {
                    [key: string]: unknown;
                  }
              )
            | Array<
                | string
                | number
                | boolean
                | null
                | {
                    [key: string]: unknown;
                  }
              >;
        }
      | {
          key: string;
          operation: 'delete';
        }
    >;
  };
  path: {
    edgeConfigId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type PatchtEdgeConfigItemsResponse = {
  status: string;
};

export type PatchtEdgeConfigItemsError = unknown;

export type CreateEdgeConfigTokenData = {
  body?: {
    label: string;
  };
  path: {
    edgeConfigId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CreateEdgeConfigTokenResponse = {
  id: string;
  token: string;
};

export type CreateEdgeConfigTokenError = unknown;

export type GetEdgeConfigTokenData = {
  path: {
    edgeConfigId: string;
    token: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetEdgeConfigTokenResponse = EdgeConfigToken;

export type GetEdgeConfigTokenError = unknown;

export type DeleteEdgeConfigTokensData = {
  body?: {
    tokens: Array<string>;
  };
  path: {
    edgeConfigId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type DeleteEdgeConfigTokensResponse = any;

export type DeleteEdgeConfigTokensError = unknown;

export type GetEdgeConfigTokensData = {
  path: {
    edgeConfigId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetEdgeConfigTokensResponse = EdgeConfigToken;

export type GetEdgeConfigTokensError = unknown;

export type DeleteConfigurationData = {
  path: {
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type DeleteConfigurationResponse = any;

export type DeleteConfigurationError = unknown;

export type GetConfigurationData = {
  path: {
    /**
     * ID of the configuration to check
     */
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetConfigurationResponse =
  | {
      /**
       * A timestamp that tells you when the configuration was installed successfully
       */
      completedAt?: number;
      /**
       * A timestamp that tells you when the configuration was created
       */
      createdAt: number;
      /**
       * A timestamp that tells you when the configuration was updated.
       */
      deletedAt?: number | null;
      /**
       * A timestamp that tells you when the configuration was disabled. Note: Configurations can be disabled when the associated user loses access to a team. They do not function during this time until the configuration is 'transferred', meaning the associated user is changed to one with access to the team.
       */
      disabledAt?: number;
      /**
       * The unique identifier of the configuration
       */
      id: string;
      /**
       * The unique identifier of the app the configuration was created for
       */
      integrationId: string;
      /**
       * Will be truthy in those cases where the configuration was created to authorize a client through the OAuth2 flow.
       */
      oauthConfiguration?: boolean;
      /**
       * The user or team ID that owns the configuration
       */
      ownerId: string;
      /**
       * When a configuration is limited to access certain projects, this will contain each of the project ID it is allowed to access. If it is not defined, the configuration has full access.
       */
      projects?: Array<string>;
      removedLogDrainsAt?: number;
      removedProjectEnvsAt?: number;
      removedTokensAt?: number;
      removedWebhooksAt?: number;
      /**
       * The resources that are allowed to be accessed by the configuration.
       */
      scopes: Array<string>;
      scopesQueue?: Array<{
        confirmedAt?: number;
        note: string;
        requestedAt: number;
        scopes: {
          added: Array<
            | 'read:integration-configuration'
            | 'read-write:integration-configuration'
            | 'read:deployment'
            | 'read-write:deployment'
            | 'read-write:deployment-check'
            | 'read:project'
            | 'read-write:project'
            | 'read-write:project-env-vars'
            | 'read-write:global-project-env-vars'
            | 'read:team'
            | 'read:user'
            | 'read-write:log-drain'
            | 'read:domain'
            | 'read-write:domain'
            | 'read-write:edge-config'
            | 'read-write:otel-endpoint'
            | 'read:monitoring'
          >;
          upgraded: Array<
            | 'read:integration-configuration'
            | 'read-write:integration-configuration'
            | 'read:deployment'
            | 'read-write:deployment'
            | 'read-write:deployment-check'
            | 'read:project'
            | 'read-write:project'
            | 'read-write:project-env-vars'
            | 'read-write:global-project-env-vars'
            | 'read:team'
            | 'read:user'
            | 'read-write:log-drain'
            | 'read:domain'
            | 'read-write:domain'
            | 'read-write:edge-config'
            | 'read-write:otel-endpoint'
            | 'read:monitoring'
          >;
        };
      }>;
      /**
       * The slug of the integration the configuration is created for.
       */
      slug: string;
      /**
       * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
       */
      source?: 'marketplace' | 'deploy-button' | 'oauth' | 'external';
      /**
       * When the configuration was created for a team, this will show the ID of the team.
       */
      teamId?: string | null;
      type: 'integration-configuration';
      /**
       * A timestamp that tells you when the configuration was updated.
       */
      updatedAt: number;
      /**
       * The ID of the user that created the configuration.
       */
      userId: string;
    }
  | {
      canConfigureOpenTelemetry?: boolean;
      /**
       * A timestamp that tells you when the configuration was installed successfully
       */
      completedAt?: number;
      /**
       * A timestamp that tells you when the configuration was created
       */
      createdAt: number;
      /**
       * A timestamp that tells you when the configuration was disabled. Note: Configurations can be disabled when the associated user loses access to a team. They do not function during this time until the configuration is 'transferred', meaning the associated user is changed to one with access to the team.
       */
      disabledAt?: number;
      /**
       * The unique identifier of the configuration
       */
      id: string;
      /**
       * The unique identifier of the app the configuration was created for
       */
      integrationId: string;
      /**
       * Will be truthy in those cases where the configuration was created to authorize a client through the OAuth2 flow.
       */
      oauthConfiguration?: boolean;
      /**
       * The user or team ID that owns the configuration
       */
      ownerId: string;
      /**
       * A string representing the permission for projects. Possible values are `all` or `selected`.
       */
      projectSelection: 'selected' | 'all';
      /**
       * When a configuration is limited to access certain projects, this will contain each of the project ID it is allowed to access. If it is not defined, the configuration has full access.
       */
      projects?: Array<string>;
      /**
       * The resources that are allowed to be accessed by the configuration.
       */
      scopes: Array<string>;
      /**
       * The slug of the integration the configuration is created for.
       */
      slug: string;
      /**
       * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
       */
      source?: 'marketplace' | 'deploy-button' | 'oauth' | 'external';
      /**
       * When the configuration was created for a team, this will show the ID of the team.
       */
      teamId?: string | null;
      /**
       * A timestamp that tells you when the configuration was updated.
       */
      updatedAt: number;
      /**
       * The ID of the user that created the configuration.
       */
      userId: string;
    };

export type GetConfigurationError = unknown;

export type GetConfigurationsData = {
  query: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    view: 'account' | 'project';
  };
};

export type GetConfigurationsResponse =
  | Array<{
      /**
       * A timestamp that tells you when the configuration was installed successfully
       */
      completedAt?: number;
      /**
       * A timestamp that tells you when the configuration was created
       */
      createdAt: number;
      /**
       * A timestamp that tells you when the configuration was updated.
       */
      deletedAt?: number | null;
      /**
       * A timestamp that tells you when the configuration was disabled. Note: Configurations can be disabled when the associated user loses access to a team. They do not function during this time until the configuration is 'transferred', meaning the associated user is changed to one with access to the team.
       */
      disabledAt?: number;
      /**
       * The unique identifier of the configuration
       */
      id: string;
      /**
       * The unique identifier of the app the configuration was created for
       */
      integrationId: string;
      /**
       * Will be truthy in those cases where the configuration was created to authorize a client through the OAuth2 flow.
       */
      oauthConfiguration?: boolean;
      /**
       * The user or team ID that owns the configuration
       */
      ownerId: string;
      /**
       * When a configuration is limited to access certain projects, this will contain each of the project ID it is allowed to access. If it is not defined, the configuration has full access.
       */
      projects?: Array<string>;
      removedLogDrainsAt?: number;
      removedProjectEnvsAt?: number;
      removedTokensAt?: number;
      removedWebhooksAt?: number;
      /**
       * The resources that are allowed to be accessed by the configuration.
       */
      scopes: Array<string>;
      scopesQueue?: Array<{
        confirmedAt?: number;
        note: string;
        requestedAt: number;
        scopes: {
          added: Array<
            | 'read:integration-configuration'
            | 'read-write:integration-configuration'
            | 'read:deployment'
            | 'read-write:deployment'
            | 'read-write:deployment-check'
            | 'read:project'
            | 'read-write:project'
            | 'read-write:project-env-vars'
            | 'read-write:global-project-env-vars'
            | 'read:team'
            | 'read:user'
            | 'read-write:log-drain'
            | 'read:domain'
            | 'read-write:domain'
            | 'read-write:edge-config'
            | 'read-write:otel-endpoint'
            | 'read:monitoring'
          >;
          upgraded: Array<
            | 'read:integration-configuration'
            | 'read-write:integration-configuration'
            | 'read:deployment'
            | 'read-write:deployment'
            | 'read-write:deployment-check'
            | 'read:project'
            | 'read-write:project'
            | 'read-write:project-env-vars'
            | 'read-write:global-project-env-vars'
            | 'read:team'
            | 'read:user'
            | 'read-write:log-drain'
            | 'read:domain'
            | 'read-write:domain'
            | 'read-write:edge-config'
            | 'read-write:otel-endpoint'
            | 'read:monitoring'
          >;
        };
      }>;
      /**
       * The slug of the integration the configuration is created for.
       */
      slug: string;
      /**
       * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
       */
      source?: 'marketplace' | 'deploy-button' | 'oauth' | 'external';
      /**
       * When the configuration was created for a team, this will show the ID of the team.
       */
      teamId?: string | null;
      type: 'integration-configuration';
      /**
       * A timestamp that tells you when the configuration was updated.
       */
      updatedAt: number;
      /**
       * The ID of the user that created the configuration.
       */
      userId: string;
    }>
  | Array<{
      /**
       * A timestamp that tells you when the configuration was installed successfully
       */
      completedAt?: number;
      /**
       * A timestamp that tells you when the configuration was created
       */
      createdAt: number;
      /**
       * A timestamp that tells you when the configuration was updated.
       */
      deletedAt?: number | null;
      /**
       * A timestamp that tells you when the configuration was disabled. Note: Configurations can be disabled when the associated user loses access to a team. They do not function during this time until the configuration is 'transferred', meaning the associated user is changed to one with access to the team.
       */
      disabledAt?: number;
      /**
       * The unique identifier of the configuration
       */
      id: string;
      integration: {
        assignedBetaLabelAt?: number;
        category: string;
        flags?: Array<string>;
        icon: string;
        isLegacy: boolean;
        name: string;
      };
      /**
       * The unique identifier of the app the configuration was created for
       */
      integrationId: string;
      /**
       * Will be truthy in those cases where the configuration was created to authorize a client through the OAuth2 flow.
       */
      oauthConfiguration?: boolean;
      /**
       * The user or team ID that owns the configuration
       */
      ownerId: string;
      /**
       * When a configuration is limited to access certain projects, this will contain each of the project ID it is allowed to access. If it is not defined, the configuration has full access.
       */
      projects?: Array<string>;
      removedLogDrainsAt?: number;
      removedProjectEnvsAt?: number;
      removedTokensAt?: number;
      removedWebhooksAt?: number;
      /**
       * The resources that are allowed to be accessed by the configuration.
       */
      scopes: Array<string>;
      scopesQueue?: Array<{
        confirmedAt?: number;
        note: string;
        requestedAt: number;
        scopes: {
          added: Array<
            | 'read:integration-configuration'
            | 'read-write:integration-configuration'
            | 'read:deployment'
            | 'read-write:deployment'
            | 'read-write:deployment-check'
            | 'read:project'
            | 'read-write:project'
            | 'read-write:project-env-vars'
            | 'read-write:global-project-env-vars'
            | 'read:team'
            | 'read:user'
            | 'read-write:log-drain'
            | 'read:domain'
            | 'read-write:domain'
            | 'read-write:edge-config'
            | 'read-write:otel-endpoint'
            | 'read:monitoring'
          >;
          upgraded: Array<
            | 'read:integration-configuration'
            | 'read-write:integration-configuration'
            | 'read:deployment'
            | 'read-write:deployment'
            | 'read-write:deployment-check'
            | 'read:project'
            | 'read-write:project'
            | 'read-write:project-env-vars'
            | 'read-write:global-project-env-vars'
            | 'read:team'
            | 'read:user'
            | 'read-write:log-drain'
            | 'read:domain'
            | 'read-write:domain'
            | 'read-write:edge-config'
            | 'read-write:otel-endpoint'
            | 'read:monitoring'
          >;
        };
      }>;
      /**
       * The slug of the integration the configuration is created for.
       */
      slug: string;
      /**
       * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
       */
      source?: 'marketplace' | 'deploy-button' | 'oauth' | 'external';
      /**
       * When the configuration was created for a team, this will show the ID of the team.
       */
      teamId?: string | null;
      type: 'integration-configuration';
      /**
       * A timestamp that tells you when the configuration was updated.
       */
      updatedAt: number;
      /**
       * The ID of the user that created the configuration.
       */
      userId: string;
    }>;

export type GetConfigurationsError = unknown;

export type GitNamespacesData = {
  query?: {
    provider?: 'github' | 'gitlab' | 'bitbucket';
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GitNamespacesResponse = Array<{
  id: string | number;
  name?: string;
  ownerType: string;
  provider: string;
  slug: string;
}>;

export type GitNamespacesError = unknown;

export type DeleteIntegrationLogDrainData = {
  path: {
    /**
     * ID of the log drain to be deleted
     */
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type DeleteIntegrationLogDrainResponse = any;

export type DeleteIntegrationLogDrainError = unknown;

export type GetV1IntegrationsSearchRepoData = {
  query?: {
    installationId?: string;
    namespaceId?: (string | number) | null;
    provider?: 'github' | 'gitlab' | 'bitbucket';
    query?: string;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetV1IntegrationsSearchRepoResponse = {
  gitAccount: {
    namespaceId: (string | number) | null;
    provider: 'github' | 'gitlab' | 'bitbucket';
  };
  repos: Array<{
    defaultBranch: string;
    id: string | number;
    name: string;
    namespace: string;
    ownerType: 'team' | 'user';
    private: boolean;
    slug: string;
    updatedAt: number;
    url: string;
  }>;
};

export type GetV1IntegrationsSearchRepoError = unknown;

export type GetConfigurableLogDrainsData = {
  query?: {
    projectId?: string;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetConfigurableLogDrainsResponse = Array<{
  /**
   * The branch to filter logs by
   */
  branch?: string;
  /**
   * The ID of the related integration configuration
   */
  configurationId?: string;
  /**
   * A number containing the date when the log-drain was created in in milliseconds
   */
  createdAt: number;
  /**
   * The log-drain defined delivery format
   */
  deliveryFormat: 'json' | 'ndjson' | 'syslog';
  /**
   * The environment to filter logs by
   */
  environment?: 'preview' | 'production';
  /**
   * Construct a type with a set of properties K of type T
   */
  headers?: {
    [key: string]: string;
  };
  /**
   * The log-drain id
   */
  id: string;
  /**
   * The unique ID of the team the deployment belongs to
   */
  ownerId: string;
  /**
   * The ID of the projects the deployment is associated with
   */
  projectIds?: Array<string>;
  /**
   * The log-drain defined sources
   */
  sources?: Array<'static' | 'lambda' | 'build' | 'edge' | 'external' | 'deployment'>;
  /**
   * A string with the URL of the log-drain
   */
  url: string;
}>;

export type GetConfigurableLogDrainsError = unknown;

export type CreateConfigurableLogDrainData = {
  body?: {
    /**
     * The branch regexp of log drain
     */
    branch?: string;
    /**
     * The delivery log format
     */
    deliveryFormat: 'json' | 'ndjson';
    /**
     * The environment of log drain
     */
    environment?: 'preview' | 'production';
    /**
     * Headers to be sent together with the request
     */
    headers?: {
      [key: string]: string;
    };
    projectIds?: Array<string>;
    sources: Array<'static' | 'lambda' | 'build' | 'edge' | 'external'>;
    /**
     * The log drain url
     */
    url: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CreateConfigurableLogDrainResponse = {
  /**
   * The branch to filter logs by
   */
  branch?: string;
  /**
   * The ID of the related integration configuration
   */
  configurationId?: string;
  /**
   * A number containing the date when the log-drain was created in in milliseconds
   */
  createdAt: number;
  /**
   * The log-drain defined delivery format
   */
  deliveryFormat: 'json' | 'ndjson' | 'syslog';
  /**
   * The environment to filter logs by
   */
  environment?: 'preview' | 'production';
  /**
   * Construct a type with a set of properties K of type T
   */
  headers?: {
    [key: string]: string;
  };
  /**
   * The log-drain id
   */
  id: string;
  /**
   * The unique ID of the team the deployment belongs to
   */
  ownerId: string;
  /**
   * The ID of the projects the deployment is associated with
   */
  projectIds?: Array<string>;
  /**
   * The secret to validate the log-drain payload
   */
  secret?: string;
  /**
   * The log-drain defined sources
   */
  sources?: Array<'static' | 'lambda' | 'build' | 'edge' | 'external' | 'deployment'>;
  /**
   * A string with the URL of the log-drain
   */
  url: string;
};

export type CreateConfigurableLogDrainError = unknown;

export type DeleteConfigurableLogDrainData = {
  path: {
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type DeleteConfigurableLogDrainResponse = any;

export type DeleteConfigurableLogDrainError = unknown;

export type GetConfigurableLogDrainData = {
  path: {
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetConfigurableLogDrainResponse = {
  /**
   * The branch to filter logs by
   */
  branch?: string;
  /**
   * The ID of the related integration configuration
   */
  configurationId?: string;
  /**
   * A number containing the date when the log-drain was created in in milliseconds
   */
  createdAt: number;
  /**
   * The log-drain defined delivery format
   */
  deliveryFormat: 'json' | 'ndjson' | 'syslog';
  /**
   * The environment to filter logs by
   */
  environment?: 'preview' | 'production';
  /**
   * Construct a type with a set of properties K of type T
   */
  headers?: {
    [key: string]: string;
  };
  /**
   * The log-drain id
   */
  id: string;
  /**
   * The unique ID of the team the deployment belongs to
   */
  ownerId: string;
  /**
   * The ID of the projects the deployment is associated with
   */
  projectIds?: Array<string>;
  /**
   * The log-drain defined sources
   */
  sources?: Array<'static' | 'lambda' | 'build' | 'edge' | 'external' | 'deployment'>;
  /**
   * A string with the URL of the log-drain
   */
  url: string;
};

export type GetConfigurableLogDrainError = unknown;

export type GetProjectEnvData = {
  path: {
    /**
     * The unique ID for the environment variable to get the decrypted value.
     */
    id: string;
    /**
     * The unique project identifier or the project name
     */
    idOrName: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetProjectEnvResponse = {
  configurationId?: string | null;
  createdAt?: number;
  createdBy?: string | null;
  /**
   * Whether `value` is decrypted.
   */
  decrypted?: boolean;
  edgeConfigId?: string | null;
  edgeConfigTokenId?: string | null;
  gitBranch?: string;
  id?: string;
  key: string;
  target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
  type: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
  updatedAt?: number;
  updatedBy?: string | null;
  value: string;
};

export type GetProjectEnvError = unknown;

export type CreateTeamData = {
  body?: {
    /**
     * The desired name for the Team. It will be generated from the provided slug if nothing is provided
     */
    name?: string;
    /**
     * The desired slug for the Team
     */
    slug: string;
  };
};

export type CreateTeamResponse = {
  /**
   * Id of the created team
   */
  id: string;
};

export type CreateTeamError = unknown;

export type DeleteTeamData = {
  body?: {
    /**
     * Optional array of objects that describe the reason why the team is being deleted.
     */
    reasons?: Array<{
      /**
       * Description of the reason why the team is being deleted.
       */
      description: string;
      /**
       * Idenitifier slug of the reason why the team is being deleted.
       */
      slug: string;
    }>;
  };
  path: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId: string;
  };
};

export type DeleteTeamResponse = {
  /**
   * The ID of the deleted Team
   */
  id: string;
};

export type DeleteTeamError = unknown;

export type DeleteTeamInviteCodeData = {
  path: {
    /**
     * The Team invite code ID.
     */
    inviteId: string;
    /**
     * Automatically added
     */
    teamId: string;
  };
};

export type DeleteTeamInviteCodeResponse = {
  /**
   * ID of the team.
   */
  id: string;
};

export type DeleteTeamInviteCodeError = unknown;

export type InviteUserToTeamData = {
  body?: {
    /**
     * The email address of the user to invite
     */
    email?: string;
    role?: unknown;
    /**
     * The id of the user to invite
     */
    uid?: string;
  };
  path: {
    /**
     * Automatically added
     */
    teamId: string;
  };
};

export type InviteUserToTeamResponse =
  | {
      /**
       * The email of the invited user. Not included if the user was invited via their UID.
       */
      email: string;
      /**
       * The role used for the invitation
       */
      role: string;
      /**
       * The ID of the invited user
       */
      uid: string;
      /**
       * The username of the invited user
       */
      username: string;
    }
  | {
      role: string;
      uid: string;
      username: string;
    };

export type InviteUserToTeamError = unknown;

export type JoinTeamData = {
  body?: {
    /**
     * The invite code to join the team.
     */
    inviteCode?: string;
    /**
     * The team ID.
     */
    teamId?: string;
  };
  path: {
    /**
     * Automatically added
     */
    teamId: string;
  };
};

export type JoinTeamResponse = {
  /**
   * The origin of how the user joined.
   */
  from: string;
  /**
   * The name of the team the user joined.
   */
  name: string;
  /**
   * The slug of the team the user joined.
   */
  slug: string;
  /**
   * The ID of the team the user joined.
   */
  teamId: string;
};

export type JoinTeamError = unknown;

export type RemoveTeamMemberData = {
  path: {
    /**
     * Automatically added
     */
    teamId: string;
    /**
     * The user ID of the member.
     */
    uid: string;
  };
};

export type RemoveTeamMemberResponse = {
  /**
   * ID of the team.
   */
  id: string;
};

export type RemoveTeamMemberError = unknown;

export type UpdateTeamMemberData = {
  body?: {
    /**
     * Accept a user who requested access to the team.
     */
    confirmed?: boolean;
    joinedFrom?: {
      ssoUserId?: null;
    };
    /**
     * The role in the team of the member.
     */
    role?: string;
  };
  path: {
    /**
     * Automatically added
     */
    teamId: string;
    /**
     * The ID of the member.
     */
    uid: string;
  };
};

export type UpdateTeamMemberResponse = {
  /**
   * ID of the team.
   */
  id: string;
};

export type UpdateTeamMemberError = unknown;

export type RequestAccessToTeamData = {
  body?: {
    joinedFrom: {
      /**
       * The commit sha if the origin is a git provider.
       */
      commitId?: string;
      /**
       * The ID of the Git account of the user who requests access.
       */
      gitUserId?: string | number;
      /**
       * The login name for the Git account of the user who requests access.
       */
      gitUserLogin?: string;
      /**
       * The origin of the request.
       */
      origin: 'import' | 'teams' | 'github' | 'gitlab' | 'bitbucket' | 'feedback' | 'organization-teams';
      /**
       * The ID of the repository for the given Git provider.
       */
      repoId?: string;
      /**
       * The path to the repository for the given Git provider.
       */
      repoPath?: string;
    };
  };
  path: {
    /**
     * Automatically added
     */
    teamId: string;
  };
};

export type RequestAccessToTeamResponse = {
  accessRequestedAt?: number;
  bitbucket: {
    login?: string;
  } | null;
  confirmed?: boolean;
  github: {
    login?: string;
  } | null;
  gitlab: {
    login?: string;
  } | null;
  joinedFrom?: {
    commitId?: string;
    dsyncConnectedAt?: number;
    dsyncUserId?: string;
    gitUserId?: string | number;
    gitUserLogin?: string;
    idpUserId?: string;
    origin:
      | 'import'
      | 'teams'
      | 'github'
      | 'gitlab'
      | 'bitbucket'
      | 'feedback'
      | 'organization-teams'
      | 'mail'
      | 'link'
      | 'saml'
      | 'dsync';
    repoId?: string;
    repoPath?: string;
    ssoConnectedAt?: number;
    ssoUserId?: string;
  };
  teamName: string;
  teamSlug: string;
};

export type RequestAccessToTeamError = unknown;

export type GetTeamAccessRequestData = {
  path: {
    /**
     * Automatically added
     */
    teamId: string;
    userId: string;
  };
};

export type GetTeamAccessRequestResponse = {
  /**
   * Timestamp in milliseconds when the user requested access to the team.
   */
  accessRequestedAt: number;
  /**
   * Map of the connected Bitbucket account.
   */
  bitbucket: {
    login?: string;
  } | null;
  /**
   * Current status of the membership. Will be `true` if confirmed, if pending it'll be `false`.
   */
  confirmed: boolean;
  /**
   * Map of the connected GitHub account.
   */
  github: {
    login?: string;
  } | null;
  /**
   * Map of the connected GitLab account.
   */
  gitlab: {
    login?: string;
  } | null;
  /**
   * A map that describes the origin from where the user joined.
   */
  joinedFrom: {
    commitId?: string;
    dsyncConnectedAt?: number;
    dsyncUserId?: string;
    gitUserId?: string | number;
    gitUserLogin?: string;
    idpUserId?: string;
    origin:
      | 'import'
      | 'mail'
      | 'link'
      | 'teams'
      | 'github'
      | 'gitlab'
      | 'bitbucket'
      | 'saml'
      | 'dsync'
      | 'feedback'
      | 'organization-teams';
    repoId?: string;
    repoPath?: string;
    ssoConnectedAt?: number;
    ssoUserId?: string;
  };
  /**
   * The name of the team.
   */
  teamName: string;
  /**
   * The slug of the team.
   */
  teamSlug: string;
};

export type GetTeamAccessRequestError = unknown;

export type RequestDeleteData = {
  body?: {
    /**
     * Optional array of objects that describe the reason why the User account is being deleted.
     */
    reasons?: Array<{
      /**
       * Description of the reason why the User account is being deleted.
       */
      description: string;
      /**
       * Idenitifier slug of the reason why the User account is being deleted.
       */
      slug: string;
    }>;
  };
};

export type RequestDeleteResponse = {
  /**
   * Email address of the User who has initiated deletion.
   */
  email: string;
  /**
   * Unique identifier of the User who has initiated deletion.
   */
  id: string;
  /**
   * User deletion progress status.
   */
  message: string;
};

export type RequestDeleteError = unknown;

export type GetWebhooksData = {
  query?: {
    projectId?: string;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetWebhooksResponse =
  | Array<{
      /**
       * A number containing the date when the webhook was created in in milliseconds
       */
      createdAt: number;
      /**
       * The webhooks events
       */
      events: Array<
        | 'domain.created'
        | 'deployment.created'
        | 'deployment.error'
        | 'deployment.canceled'
        | 'deployment.succeeded'
        | 'deployment.ready'
        | 'deployment.check-rerequested'
        | 'integration-configuration.permission-upgraded'
        | 'integration-configuration.removed'
        | 'integration-configuration.scope-change-confirmed'
        | 'project.created'
        | 'project.removed'
        | 'deployment-checks-completed'
        | 'deployment-ready'
        | 'deployment-prepared'
        | 'deployment-error'
        | 'deployment-check-rerequested'
        | 'deployment-canceled'
        | 'project-created'
        | 'project-removed'
        | 'domain-created'
        | 'deployment'
        | 'integration-configuration-permission-updated'
        | 'integration-configuration-removed'
        | 'integration-configuration-scope-change-confirmed'
      >;
      /**
       * The webhook id
       */
      id: string;
      /**
       * The unique ID of the team the webhook belongs to
       */
      ownerId: string;
      /**
       * The ID of the projects the webhook is associated with
       */
      projectIds?: Array<string>;
      projectsMetadata: Array<{
        framework?:
          | (
              | 'blitzjs'
              | 'nextjs'
              | 'gatsby'
              | 'remix'
              | 'astro'
              | 'hexo'
              | 'eleventy'
              | 'docusaurus-2'
              | 'docusaurus'
              | 'preact'
              | 'solidstart'
              | 'dojo'
              | 'ember'
              | 'vue'
              | 'scully'
              | 'ionic-angular'
              | 'angular'
              | 'polymer'
              | 'svelte'
              | 'sveltekit'
              | 'sveltekit-1'
              | 'ionic-react'
              | 'create-react-app'
              | 'gridsome'
              | 'umijs'
              | 'sapper'
              | 'saber'
              | 'stencil'
              | 'nuxtjs'
              | 'redwoodjs'
              | 'hugo'
              | 'jekyll'
              | 'brunch'
              | 'middleman'
              | 'zola'
              | 'hydrogen'
              | 'vite'
              | 'vitepress'
              | 'vuepress'
              | 'parcel'
              | 'sanity'
            )
          | null;
        id: string;
        latestDeployment?: string;
        name: string;
      }> | null;
      /**
       * A number containing the date when the webhook was updated in in milliseconds
       */
      updatedAt: number;
      /**
       * A string with the URL of the webhook
       */
      url: string;
    }>
  | Array<{
      /**
       * A number containing the date when the webhook was created in in milliseconds
       */
      createdAt: number;
      /**
       * The webhooks events
       */
      events: Array<
        | 'domain.created'
        | 'deployment.created'
        | 'deployment.error'
        | 'deployment.canceled'
        | 'deployment.succeeded'
        | 'deployment.ready'
        | 'deployment.check-rerequested'
        | 'integration-configuration.permission-upgraded'
        | 'integration-configuration.removed'
        | 'integration-configuration.scope-change-confirmed'
        | 'project.created'
        | 'project.removed'
        | 'deployment-checks-completed'
        | 'deployment-ready'
        | 'deployment-prepared'
        | 'deployment-error'
        | 'deployment-check-rerequested'
        | 'deployment-canceled'
        | 'project-created'
        | 'project-removed'
        | 'domain-created'
        | 'deployment'
        | 'integration-configuration-permission-updated'
        | 'integration-configuration-removed'
        | 'integration-configuration-scope-change-confirmed'
      >;
      /**
       * The webhook id
       */
      id: string;
      /**
       * The unique ID of the team the webhook belongs to
       */
      ownerId: string;
      /**
       * The ID of the projects the webhook is associated with
       */
      projectIds?: Array<string>;
      /**
       * A number containing the date when the webhook was updated in in milliseconds
       */
      updatedAt: number;
      /**
       * A string with the URL of the webhook
       */
      url: string;
    }>;

export type GetWebhooksError = unknown;

export type CreateWebhookData = {
  body?: {
    events: Array<
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DomainCreate'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DeploymentCreate'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DeploymentErro'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DeploymentCancele'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DeploymentSucceede'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DeploymentRead'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.DeploymentCheckRerequeste'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.IntegrationConfigurationPermissionUpgrade'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.IntegrationConfigurationRemove'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.IntegrationConfigurationScopeChangeConfirme'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.ProjectCreate'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.ProjectRemove'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymentChecksComplete'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymentRead'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymentPrepare'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymentErro'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymentCheckRerequeste'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymentCancele'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyProjectCreate'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyProjectRemove'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDomainCreate'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyDeploymen'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyIntegrationConfigurationPermissionUpdate'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyIntegrationConfigurationRemove'
      | 'mport("/vercel/path0/utils/webhooks/webhooks/types").WebhookName.LegacyIntegrationConfigurationScopeChangeConfirme'
    >;
    projectIds?: Array<string>;
    url: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CreateWebhookResponse = {
  /**
   * A number containing the date when the webhook was created in in milliseconds
   */
  createdAt: number;
  /**
   * The webhooks events
   */
  events: Array<
    | 'domain.created'
    | 'deployment.created'
    | 'deployment.error'
    | 'deployment.canceled'
    | 'deployment.succeeded'
    | 'deployment.ready'
    | 'deployment.check-rerequested'
    | 'integration-configuration.permission-upgraded'
    | 'integration-configuration.removed'
    | 'integration-configuration.scope-change-confirmed'
    | 'project.created'
    | 'project.removed'
    | 'deployment-checks-completed'
    | 'deployment-ready'
    | 'deployment-prepared'
    | 'deployment-error'
    | 'deployment-check-rerequested'
    | 'deployment-canceled'
    | 'project-created'
    | 'project-removed'
    | 'domain-created'
    | 'deployment'
    | 'integration-configuration-permission-updated'
    | 'integration-configuration-removed'
    | 'integration-configuration-scope-change-confirmed'
  >;
  /**
   * The webhook id
   */
  id: string;
  /**
   * The unique ID of the team the webhook belongs to
   */
  ownerId: string;
  /**
   * The ID of the projects the webhook is associated with
   */
  projectIds?: Array<string>;
  /**
   * The webhook secret used to sign the payload
   */
  secret: string;
  /**
   * A number containing the date when the webhook was updated in in milliseconds
   */
  updatedAt: number;
  /**
   * A string with the URL of the webhook
   */
  url: string;
};

export type CreateWebhookError = unknown;

export type DeleteWebhookData = {
  path: {
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type DeleteWebhookResponse = any;

export type DeleteWebhookError = unknown;

export type GetWebhookData = {
  path: {
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetWebhookResponse = {
  /**
   * A number containing the date when the webhook was created in in milliseconds
   */
  createdAt: number;
  /**
   * The webhooks events
   */
  events: Array<
    | 'domain.created'
    | 'deployment.created'
    | 'deployment.error'
    | 'deployment.canceled'
    | 'deployment.succeeded'
    | 'deployment.ready'
    | 'deployment.check-rerequested'
    | 'integration-configuration.permission-upgraded'
    | 'integration-configuration.removed'
    | 'integration-configuration.scope-change-confirmed'
    | 'project.created'
    | 'project.removed'
    | 'deployment-checks-completed'
    | 'deployment-ready'
    | 'deployment-prepared'
    | 'deployment-error'
    | 'deployment-check-rerequested'
    | 'deployment-canceled'
    | 'project-created'
    | 'project-removed'
    | 'domain-created'
    | 'deployment'
    | 'integration-configuration-permission-updated'
    | 'integration-configuration-removed'
    | 'integration-configuration-scope-change-confirmed'
  >;
  /**
   * The webhook id
   */
  id: string;
  /**
   * The unique ID of the team the webhook belongs to
   */
  ownerId: string;
  /**
   * The ID of the projects the webhook is associated with
   */
  projectIds?: Array<string>;
  /**
   * A number containing the date when the webhook was updated in in milliseconds
   */
  updatedAt: number;
  /**
   * A string with the URL of the webhook
   */
  url: string;
};

export type GetWebhookError = unknown;

export type AddProjectDomainData = {
  body?: {
    /**
     * Git branch to link the project domain
     */
    gitBranch?: string | null;
    /**
     * The project domain name
     */
    name: string;
    /**
     * Target destination domain for redirect
     */
    redirect?: string | null;
    /**
     * Status code for domain redirect
     */
    redirectStatusCode?: (301 | 302 | 307 | 308) | null;
  };
  path: {
    /**
     * The unique project identifier or the project name
     */
    idOrName: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type AddProjectDomainResponse = {
  apexName: string;
  createdAt?: number;
  gitBranch?: string | null;
  name: string;
  projectId: string;
  redirect?: string | null;
  redirectStatusCode?: (307 | 301 | 302 | 308) | null;
  updatedAt?: number;
  /**
   * A list of verification challenges, one of which must be completed to verify the domain for use on the project. After the challenge is complete `POST /projects/:idOrName/domains/:domain/verify` to verify the domain. Possible challenges: - If `verification.type = TXT` the `verification.domain` will be checked for a TXT record matching `verification.value`.
   */
  verification?: Array<{
    domain: string;
    reason: string;
    type: string;
    value: string;
  }>;
  /**
   * `true` if the domain is verified for use with the project. If `false` it will not be used as an alias on this project until the challenge in `verification` is completed.
   */
  verified: boolean;
};

export type AddProjectDomainError = unknown;

export type CreateProjectEnvData = {
  body?:
    | {
        /**
         * The git branch of the environment variable
         */
        gitBranch?: string | null;
        /**
         * The name of the environment variable
         */
        key: string;
        /**
         * The target environment of the environment variable
         */
        target: Array<
          | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Productio'
          | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Previe'
          | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Developmen'
        >;
        /**
         * The type of environment variable
         */
        type: 'system' | 'secret' | 'encrypted' | 'plain' | 'sensitive';
        /**
         * The value of the environment variable
         */
        value: string;
      }
    | Array<{
        /**
         * The git branch of the environment variable
         */
        gitBranch?: string | null;
        /**
         * The name of the environment variable
         */
        key: string;
        /**
         * The target environment of the environment variable
         */
        target: Array<
          | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Productio'
          | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Previe'
          | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Developmen'
        >;
        /**
         * The type of environment variable
         */
        type: 'system' | 'secret' | 'encrypted' | 'plain' | 'sensitive';
        /**
         * The value of the environment variable
         */
        value: string;
      }>;
  path: {
    /**
     * The unique project identifier or the project name
     */
    idOrName: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    /**
     * Allow override of environment variable if it already exists
     */
    upsert?: string;
  };
};

export type CreateProjectEnvResponse = {
  created:
    | {
        configurationId?: string | null;
        createdAt?: number;
        createdBy?: string | null;
        /**
         * Whether `value` is decrypted.
         */
        decrypted?: boolean;
        edgeConfigId?: string | null;
        edgeConfigTokenId?: string | null;
        gitBranch?: string;
        id?: string;
        key?: string;
        system?: boolean;
        target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
        type?: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
        updatedAt?: number;
        updatedBy?: string | null;
        value?: string;
      }
    | Array<{
        configurationId?: string | null;
        createdAt?: number;
        createdBy?: string | null;
        /**
         * Whether `value` is decrypted.
         */
        decrypted?: boolean;
        edgeConfigId?: string | null;
        edgeConfigTokenId?: string | null;
        gitBranch?: string;
        id?: string;
        key?: string;
        system?: boolean;
        target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
        type?: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
        updatedAt?: number;
        updatedBy?: string | null;
        value?: string;
      }>;
  failed: Array<{
    error: {
      action?: string;
      code: string;
      envVarId?: string;
      envVarKey?: string;
      gitBranch?: string;
      key?: string;
      link?: string;
      message: string;
      project?: string;
      target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
      value?: string | Array<'production' | 'preview' | 'development'>;
    };
  }>;
};

export type CreateProjectEnvError = unknown;

export type ListDeploymentBuildsData = {
  path: {
    /**
     * The deployment unique identifier
     */
    deploymentId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type ListDeploymentBuildsResponse = {
  builds: Array<{
    /**
     * An object that contains the Build's configuration
     */
    config?: {
      distDir?: string;
      forceBuildIn?: string;
      reuseWorkPathFrom?: string;
      zeroConfig?: boolean;
    };
    copiedFrom?: string;
    /**
     * The time at which the Build was created
     */
    createdAt?: number;
    /**
     * The region where the Build was first created
     */
    createdIn?: string;
    /**
     * The time at which the Build was deployed
     */
    deployedAt?: number;
    /**
     * The unique identifier of the deployment
     */
    deploymentId: string;
    /**
     * The entrypoint of the deployment
     */
    entrypoint: string;
    /**
     * If the Build uses the `@vercel/static` Runtime, it contains a hashed string of all outputs
     */
    fingerprint?: string | null;
    /**
     * The unique identifier of the Build
     */
    id: string;
    /**
     * A list of outputs for the Build that can be either Serverless Functions or static files
     */
    output: Array<{
      /**
       * The SHA1 of the file
       */
      digest: string;
      /**
       * Exists if the output is an edge function.
       */
      edge?: {
        /**
         * The regions where the edge function will be invoked. Only exists if the edge function as a regional edge function, see: https://vercel.com/docs/concepts/edge-network/regions#setting-edge-function-regions
         */
        regions: Array<string> | null;
      } | null;
      /**
       * If the output is a Serverless Function, an object containing the name, location and memory size of the function
       */
      lambda?: {
        deployedTo: Array<string>;
        functionName: string;
        layers?: Array<string>;
        memorySize?: number;
        timeout?: number;
      } | null;
      /**
       * The POSIX file permissions
       */
      mode: number;
      /**
       * The absolute path of the file or Serverless Function
       */
      path: string;
      /**
       * The size of the file in bytes
       */
      size?: number;
      /**
       * The type of the output
       */
      type?: 'lambda' | 'file' | 'edge';
    }>;
    /**
     * The state of the deployment depending on the process of deploying, or if it is ready or in an error state
     */
    readyState:
      | 'BUILDING'
      | 'ERROR'
      | 'INITIALIZING'
      | 'QUEUED'
      | 'READY'
      | 'CANCELED'
      | 'UPLOADING'
      | 'DEPLOYING'
      | 'ARCHIVED';
    /**
     * The time at which the Build state was last modified
     */
    readyStateAt?: number;
    /**
     * The time at which the Build was scheduled to be built
     */
    scheduledAt?: number | null;
    /**
     * The Runtime the Build used to generate the output
     */
    use?: string;
  }>;
};

export type ListDeploymentBuildsError = unknown;

export type CancelDeploymentData = {
  path: {
    /**
     * The unique identifier of the deployment.
     */
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CancelDeploymentResponse = {
  /**
   * A list of all the aliases (default aliases, staging aliases and production aliases) that were assigned upon deployment creation
   */
  alias: Array<string>;
  /**
   * A boolean that will be true when the aliases from the alias property were assigned successfully
   */
  aliasAssigned: boolean;
  aliasAssignedAt?: (number | boolean) | null;
  /**
   * An object that will contain a `code` and a `message` when the aliasing fails, otherwise the value will be `null`
   */
  aliasError?: {
    code: string;
    message: string;
  } | null;
  aliasFinal?: string | null;
  aliasWarning?: {
    action?: string;
    code: string;
    link?: string;
    message: string;
  } | null;
  automaticAliases?: Array<string>;
  bootedAt: number;
  build: {
    /**
     * The keys of the environment variables that were assigned during the build phase.
     */
    env: Array<string>;
  };
  buildErrorAt?: number;
  buildingAt: number;
  builds?: Array<{
    /**
     * An object containing the deployment's metadata
     */
    config?: {
      [key: string]: string;
    };
    src?: string;
    use: string;
  }>;
  canceledAt?: number;
  checksConclusion?: 'succeeded' | 'failed' | 'skipped' | 'canceled';
  checksState?: 'registered' | 'running' | 'completed';
  /**
   * The ID of Vercel Connect configuration used for this deployment
   */
  connectConfigurationId?: string;
  /**
   * A number containing the date when the deployment was created in milliseconds
   */
  createdAt: number;
  /**
   * The region where the deployment was first created
   */
  createdIn: string;
  /**
   * Information about the deployment creator
   */
  creator: {
    /**
     * The ID of the user that created the deployment
     */
    uid: string;
    /**
     * The username of the user that created the deployment
     */
    username?: string;
  };
  /**
   * The keys of the environment variables that were assigned during runtime
   */
  env: Array<string>;
  errorCode?: string;
  errorLink?: string;
  errorMessage?: string | null;
  errorStep?: string;
  /**
   * An object used to configure your Serverless Functions
   */
  functions?: {
    [key: string]: {
      excludeFiles?: string;
      includeFiles?: string;
      maxDuration?: number;
      memory?: number;
      runtime?: string;
    };
  } | null;
  gitRepo?:
    | (
        | {
            defaultBranch: string;
            name: string;
            namespace: string;
            ownerType: 'user' | 'team';
            path: string;
            private: boolean;
            projectId: number;
            type: 'gitlab';
            url: string;
          }
        | {
            defaultBranch: string;
            name: string;
            org: string;
            ownerType: 'user' | 'team';
            path: string;
            private: boolean;
            repo: string;
            repoId: number;
            repoOwnerId: string;
            type: 'github';
          }
        | {
            defaultBranch: string;
            name: string;
            owner: string;
            ownerType: 'user' | 'team';
            path: string;
            private: boolean;
            repoUuid: string;
            slug: string;
            type: 'bitbucket';
            workspaceUuid: string;
          }
      )
    | null;
  gitSource?:
    | {
        prId?: number | null;
        ref?: string | null;
        repoId: string | number;
        sha?: string;
        type: 'github';
      }
    | {
        org: string;
        prId?: number | null;
        ref?: string | null;
        repo: string;
        sha?: string;
        type: 'github';
      }
    | {
        prId?: number | null;
        projectId: string | number;
        ref?: string | null;
        sha?: string;
        type: 'gitlab';
      }
    | {
        prId?: number | null;
        ref?: string | null;
        repoUuid: string;
        sha?: string;
        type: 'bitbucket';
        workspaceUuid?: string;
      }
    | {
        owner: string;
        prId?: number | null;
        ref?: string | null;
        sha?: string;
        slug: string;
        type: 'bitbucket';
      }
    | {
        gitUrl: string;
        ref: string;
        sha: string;
        type: 'custom';
      }
    | {
        org?: string;
        ref: string;
        repo?: string;
        repoId: number;
        sha: string;
        type: 'github';
      }
    | {
        projectId: number;
        ref: string;
        sha: string;
        type: 'gitlab';
      }
    | {
        owner?: string;
        ref: string;
        repoUuid: string;
        sha: string;
        slug?: string;
        type: 'bitbucket';
        workspaceUuid: string;
      };
  /**
   * A string holding the unique ID of the deployment
   */
  id: string;
  /**
   * Vercel URL to inspect the deployment.
   */
  inspectorUrl: string | null;
  /**
   * Is the deployment currently queued waiting for a Concurrent Build Slot to be available
   */
  isInConcurrentBuildsQueue: boolean;
  lambdas?: Array<{
    createdAt?: number;
    entrypoint?: string | null;
    id: string;
    output: Array<{
      functionName: string;
      path: string;
    }>;
    readyState?: 'INITIALIZING' | 'BUILDING' | 'READY' | 'ERROR';
    readyStateAt?: number;
  }>;
  /**
   * An object containing the deployment's metadata
   */
  meta: {
    [key: string]: string;
  };
  /**
   * An monorepo manager that was used for the deployment
   */
  monorepoManager?: string | null;
  /**
   * The name of the project associated with the deployment at the time that the deployment was created
   */
  name: string;
  /**
   * The unique ID of the user or team the deployment belongs to
   */
  ownerId: string;
  /**
   * The pricing plan the deployment was made under
   */
  plan: 'hobby' | 'enterprise' | 'pro' | 'oss';
  /**
   * Whether or not preview comments are enabled for the deployment
   */
  previewCommentsEnabled?: boolean;
  /**
   * The ID of the project the deployment is associated with
   */
  projectId: string;
  /**
   * A boolean representing if the deployment is public or not. By default this is `false`
   */
  public: boolean;
  /**
   * The state of the deployment depending on the process of deploying, or if it is ready or in an error state
   */
  readyState: 'INITIALIZING' | 'BUILDING' | 'READY' | 'ERROR' | 'QUEUED' | 'CANCELED';
  /**
   * The regions the deployment exists in
   */
  regions: Array<string>;
  /**
   * A list of routes objects used to rewrite paths to point towards other internal or external paths
   */
  routes: Array<
    | {
        caseSensitive?: boolean;
        check?: boolean;
        continue?: boolean;
        dest?: string;
        has?: Array<
          | {
              type: 'host';
              value: string;
            }
          | {
              key: string;
              type: 'header' | 'cookie' | 'query';
              value?: string;
            }
        >;
        headers?: {
          [key: string]: string;
        };
        important?: boolean;
        locale?: {
          cookie?: string;
          /**
           * Construct a type with a set of properties K of type T
           */
          redirect?: {
            [key: string]: string;
          };
        };
        methods?: Array<string>;
        /**
         * A middleware index in the `middleware` key under the build result
         */
        middleware?: number;
        /**
         * A middleware key within the `output` key under the build result. Overrides a `middleware` definition.
         */
        middlewarePath?: string;
        /**
         * The original middleware matchers.
         */
        middlewareRawSrc?: Array<string>;
        missing?: Array<
          | {
              type: 'host';
              value: string;
            }
          | {
              key: string;
              type: 'header' | 'cookie' | 'query';
              value?: string;
            }
        >;
        override?: boolean;
        src: string;
        status?: number;
      }
    | {
        dest?: string;
        handle: 'filesystem' | 'hit' | 'miss' | 'rewrite' | 'error' | 'resource';
        src?: string;
        status?: number;
      }
    | {
        continue: boolean;
        middleware: 0;
        src: string;
      }
  > | null;
  /**
   * Where was the deployment created from
   */
  source?: 'cli' | 'git' | 'import' | 'import/repo' | 'clone/repo';
  /**
   * If defined, either `staging` if a staging alias in the format `<project>.<team>.now.sh` was assigned upon creation, or `production` if the aliases from `alias` were assigned
   */
  target?: ('staging' | 'production') | null;
  /**
   * The team that owns the deployment if any
   */
  team?: {
    /**
     * The ID of the team owner
     */
    id: string;
    /**
     * The name of the team owner
     */
    name: string;
    /**
     * The slug of the team owner
     */
    slug: string;
  };
  type: 'LAMBDAS';
  /**
   * A string with the unique URL of the deployment
   */
  url: string;
  /**
   * An array of domains that were provided by the user when creating the Deployment.
   */
  userAliases?: Array<string>;
  /**
   * The platform version that was used to create the deployment.
   */
  version: 2;
};

export type CancelDeploymentError = unknown;

export type CreateDeploymentData = {
  body?: {
    /**
     * Ignored. Can be set to get completions, validations and documentation in some editors.
     */
    $schema?: string;
    /**
     * Aliases that will get assigned when the deployment is `READY` and the target is `production`. The client needs to make a `GET` request to its API to ensure the assignment
     */
    alias?: Array<string>;
    /**
     * An object containing another object with information to be passed to the Build Process
     * @deprecated
     */
    build?: {
      /**
       * An object containing the deployment's environment variable names and values to be passed to Builds. Secrets can be referenced by prefixing the value with `@`
       * @deprecated
       */
      env?: {
        [key: string]: string;
      };
    };
    /**
     * The build command for this project. When `null` is used this value will be automatically detected
     */
    buildCommand?: string | null;
    /**
     * A list of build descriptions whose src references valid source files.
     * @deprecated
     */
    builds?: Array<{
      /**
       * Optionally, an object including arbitrary metadata to be passed to the Builder
       */
      config?: {
        [key: string]: unknown;
      };
      /**
       * A glob expression or pathname. If more than one file is resolved, one build will be created per matched file. It can include `*` and `**`
       */
      src?: string;
      /**
       * An npm module to be installed by the build process. It can include a semver compatible version (e.g.: `@org/proj@1`)
       */
      use: string;
    }>;
    /**
     * When set to `true`, all HTML files and Serverless Functions will have their extension removed. When visiting a path that ends with the extension, a 308 response will redirect the client to the extensionless path.
     */
    cleanUrls?: boolean;
    /**
     * An array of cron jobs that should be created for production Deployments.
     */
    crons?: Array<{
      path: string;
      schedule: string;
    }>;
    /**
     * An deployment id for an existing deployment to redeploy
     */
    deploymentId?: string;
    /**
     * The dev command for this project. When `null` is used this value will be automatically detected
     */
    devCommand?: string | null;
    /**
     * An object containing the deployment's environment variable names and values. Secrets can be referenced by prefixing the value with `@`
     * @deprecated
     */
    env?: {
      [key: string]: string;
    };
    /**
     * A list of objects with the files to be deployed
     */
    files?: Array<
      | {
          /**
           * The file content, it could be either a `base64` (useful for images, etc.) of the files or the plain content for source code
           */
          data: string;
          /**
           * The file content encoding, it could be either a base64 (useful for images, etc.) of the files or the plain text for source code.
           */
          encoding?: 'base64' | 'utf-8';
          /**
           * The file name including the whole path
           */
          file: string;
        }
      | {
          /**
           * The file path relative to the project root
           */
          file: string;
          /**
           * The file contents hashed with SHA1, used to check the integrity
           */
          sha?: string;
          /**
           * The file size in bytes
           */
          size?: number;
        }
    >;
    /**
     * The framework that is being used for this project. When `null` is used no framework is selected
     */
    framework?:
      | (
          | 'blitzjs'
          | 'nextjs'
          | 'gatsby'
          | 'remix'
          | 'astro'
          | 'hexo'
          | 'eleventy'
          | 'docusaurus-2'
          | 'docusaurus'
          | 'preact'
          | 'solidstart'
          | 'dojo'
          | 'ember'
          | 'vue'
          | 'scully'
          | 'ionic-angular'
          | 'angular'
          | 'polymer'
          | 'svelte'
          | 'sveltekit'
          | 'sveltekit-1'
          | 'ionic-react'
          | 'create-react-app'
          | 'gridsome'
          | 'umijs'
          | 'sapper'
          | 'saber'
          | 'stencil'
          | 'nuxtjs'
          | 'redwoodjs'
          | 'hugo'
          | 'jekyll'
          | 'brunch'
          | 'middleman'
          | 'zola'
          | 'hydrogen'
          | 'vite'
          | 'vitepress'
          | 'vuepress'
          | 'parcel'
          | 'sanity'
        )
      | null;
    /**
     * An object describing custom options for your Serverless Functions. Each key must be glob pattern that matches the paths of the Serverless Functions you would like to customize (like `api*.js` or `api/test.js`).
     */
    functions?: {
      [key: string]: {
        /**
         * A glob pattern to match files that should be excluded from your Serverless Function. If you’re using a Community Runtime, the behavior might vary.
         */
        excludeFiles?: string;
        /**
         * A glob pattern to match files that should be included in your Serverless Function. If you’re using a Community Runtime, the behavior might vary.
         */
        includeFiles?: string;
        /**
         * An integer defining how long your Serverless Function should be allowed to run on every request in seconds (between 1 and the maximum limit of your plan).
         */
        maxDuration?: number;
        /**
         * An integer defining the memory your Serverless Function should be provided with (between 128 and 3008).
         */
        memory?: number;
        /**
         * The npm package name of a Runtime, including its version
         */
        runtime?: string;
      };
    };
    git?: {
      /**
       * Specifies the branches that will not trigger an auto-deployment when committing to them. Any non specified branch is `true` by default.
       */
      deploymentEnabled?:
        | boolean
        | {
            [key: string]: boolean;
          };
    };
    /**
     * Populates initial git metadata for different git providers.
     */
    gitMetadata?: {
      /**
       * The name of the author of the commit
       */
      commitAuthorName?: string;
      /**
       * The commit message
       */
      commitMessage?: string;
      /**
       * The branch on which the commit was made
       */
      commitRef?: string;
      /**
       * The hash of the commit
       */
      commitSha?: string;
      /**
       * Whether or not there have been modifications to the working tree since the latest commit
       */
      dirty?: boolean;
      /**
       * The git repository's remote origin url
       */
      remoteUrl?: string;
    };
    /**
     * Defines the Git Repository source to be deployed. This property can not be used in combination with `files`.
     */
    gitSource?:
      | {
          ref: string;
          repoId: number | string;
          sha?: string;
          type: 'github';
        }
      | {
          org: string;
          ref: string;
          repo: string;
          sha?: string;
          type: 'github';
        }
      | {
          projectId: number | string;
          ref: string;
          sha?: string;
          type: 'gitlab';
        }
      | {
          ref: string;
          repoUuid: string;
          sha?: string;
          type: 'bitbucket';
          workspaceUuid?: string;
        }
      | {
          owner: string;
          ref: string;
          sha?: string;
          slug: string;
          type: 'bitbucket';
        };
    /**
     * A list of header definitions.
     */
    headers?: Array<{
      /**
       * An array of requirements that are needed to match
       */
      has?: Array<
        | {
            /**
             * The type of request element to check
             */
            type: 'host';
            /**
             * A regular expression used to match the value. Named groups can be used in the destination
             */
            value: string;
          }
        | {
            /**
             * The name of the element contained in the particular type
             */
            key: string;
            /**
             * The type of request element to check
             */
            type: 'header' | 'cookie' | 'query';
            /**
             * A regular expression used to match the value. Named groups can be used in the destination
             */
            value?: string;
          }
      >;
      /**
       * An array of key/value pairs representing each response header.
       */
      headers: Array<{
        key: string;
        value: string;
      }>;
      /**
       * An array of requirements that are needed to match
       */
      missing?: Array<
        | {
            /**
             * The type of request element to check
             */
            type: 'host';
            /**
             * A regular expression used to match the value. Named groups can be used in the destination
             */
            value: string;
          }
        | {
            /**
             * The name of the element contained in the particular type
             */
            key: string;
            /**
             * The type of request element to check
             */
            type: 'header' | 'cookie' | 'query';
            /**
             * A regular expression used to match the value. Named groups can be used in the destination
             */
            value?: string;
          }
      >;
      /**
       * A pattern that matches each incoming pathname (excluding querystring)
       */
      source: string;
    }>;
    ignoreCommand?: string | null;
    images?: {
      contentDispositionType?: 'inline' | 'attachment';
      contentSecurityPolicy?: string;
      dangerouslyAllowSVG?: boolean;
      domains?: Array<string>;
      formats?: Array<'image/avif' | 'image/webp' | 'image/jpeg' | 'image/png'>;
      minimumCacheTTL?: number;
      remotePatterns?: Array<{
        hostname: string;
        pathname?: string;
        port?: string;
        protocol?: 'http' | 'https';
      }>;
      sizes: Array<number>;
    };
    /**
     * The install command for this project. When `null` is used this value will be automatically detected
     */
    installCommand?: string | null;
    /**
     * An object containing the deployment's metadata. Multiple key-value pairs can be attached to a deployment
     */
    meta?: {
      [key: string]: string;
    };
    /**
     * The monorepo manager that is being used for this deployment. When `null` is used no monorepo manager is selected
     */
    monorepoManager?: string | null;
    /**
     * A string with the project name used in the deployment URL
     */
    name: string;
    /**
     * The output directory of the project. When `null` is used this value will be automatically detected
     */
    outputDirectory?: string | null;
    /**
     * The target project identifier in which the deployment will be created. When defined, this parameter overrides name
     */
    project?: string;
    /**
     * Project settings that will be applied to the deployment. It is required for the first deployment of a project and will be saved for any following deployments
     */
    projectSettings?: {
      /**
       * The build command for this project. When `null` is used this value will be automatically detected
       */
      buildCommand?: string | null;
      commandForIgnoringBuildStep?: string | null;
      /**
       * The dev command for this project. When `null` is used this value will be automatically detected
       */
      devCommand?: string | null;
      /**
       * The framework that is being used for this project. When `null` is used no framework is selected
       */
      framework?:
        | (
            | 'blitzjs'
            | 'nextjs'
            | 'gatsby'
            | 'remix'
            | 'astro'
            | 'hexo'
            | 'eleventy'
            | 'docusaurus-2'
            | 'docusaurus'
            | 'preact'
            | 'solidstart'
            | 'dojo'
            | 'ember'
            | 'vue'
            | 'scully'
            | 'ionic-angular'
            | 'angular'
            | 'polymer'
            | 'svelte'
            | 'sveltekit'
            | 'sveltekit-1'
            | 'ionic-react'
            | 'create-react-app'
            | 'gridsome'
            | 'umijs'
            | 'sapper'
            | 'saber'
            | 'stencil'
            | 'nuxtjs'
            | 'redwoodjs'
            | 'hugo'
            | 'jekyll'
            | 'brunch'
            | 'middleman'
            | 'zola'
            | 'hydrogen'
            | 'vite'
            | 'vitepress'
            | 'vuepress'
            | 'parcel'
            | 'sanity'
          )
        | null;
      /**
       * The install command for this project. When `null` is used this value will be automatically detected
       */
      installCommand?: string | null;
      /**
       * The output directory of the project. When `null` is used this value will be automatically detected
       */
      outputDirectory?: string | null;
      /**
       * The name of a directory or relative path to the source code of your project. When `null` is used it will default to the project root
       */
      rootDirectory?: string | null;
      /**
       * The region to deploy Serverless Functions in this project
       */
      serverlessFunctionRegion?: string | null;
      /**
       * Opts-out of the message prompting a CLI user to connect a Git repository in `vercel link`.
       * @deprecated
       */
      skipGitConnectDuringLink?: boolean;
      /**
       * Indicates if there are source files outside of the root directory, typically used for monorepos
       */
      sourceFilesOutsideRootDirectory?: boolean;
    };
    /**
     * Whether a deployment's source and logs are available publicly
     */
    public?: boolean;
    /**
     * A list of redirect definitions.
     */
    redirects?: Array<{
      /**
       * A location destination defined as an absolute pathname or external URL.
       */
      destination: string;
      /**
       * An array of requirements that are needed to match
       */
      has?: Array<
        | {
            /**
             * The type of request element to check
             */
            type: 'host';
            /**
             * A regular expression used to match the value. Named groups can be used in the destination
             */
            value: string;
          }
        | {
            /**
             * The name of the element contained in the particular type
             */
            key: string;
            /**
             * The type of request element to check
             */
            type: 'header' | 'cookie' | 'query';
            /**
             * A regular expression used to match the value. Named groups can be used in the destination
             */
            value?: string;
          }
      >;
      /**
       * An array of requirements that are needed to match
       */
      missing?: Array<
        | {
            /**
             * The type of request element to check
             */
            type: 'host';
            /**
             * A regular expression used to match the value. Named groups can be used in the destination
             */
            value: string;
          }
        | {
            /**
             * The name of the element contained in the particular type
             */
            key: string;
            /**
             * The type of request element to check
             */
            type: 'header' | 'cookie' | 'query';
            /**
             * A regular expression used to match the value. Named groups can be used in the destination
             */
            value?: string;
          }
      >;
      /**
       * A boolean to toggle between permanent and temporary redirect. When `true`, the status code is `308`. When `false` the status code is `307`.
       */
      permanent?: boolean;
      /**
       * A pattern that matches each incoming pathname (excluding querystring).
       */
      source: string;
    }>;
    /**
     * An array of the regions the deployment's Serverless Functions should be deployed to
     */
    regions?: Array<string>;
    /**
     * A list of rewrite definitions.
     */
    rewrites?: Array<{
      /**
       * An absolute pathname to an existing resource or an external URL.
       */
      destination: string;
      /**
       * An array of requirements that are needed to match
       */
      has?: Array<
        | {
            /**
             * The type of request element to check
             */
            type: 'host';
            /**
             * A regular expression used to match the value. Named groups can be used in the destination
             */
            value: string;
          }
        | {
            /**
             * The name of the element contained in the particular type
             */
            key: string;
            /**
             * The type of request element to check
             */
            type: 'header' | 'cookie' | 'query';
            /**
             * A regular expression used to match the value. Named groups can be used in the destination
             */
            value?: string;
          }
      >;
      /**
       * An array of requirements that are needed to match
       */
      missing?: Array<
        | {
            /**
             * The type of request element to check
             */
            type: 'host';
            /**
             * A regular expression used to match the value. Named groups can be used in the destination
             */
            value: string;
          }
        | {
            /**
             * The name of the element contained in the particular type
             */
            key: string;
            /**
             * The type of request element to check
             */
            type: 'header' | 'cookie' | 'query';
            /**
             * A regular expression used to match the value. Named groups can be used in the destination
             */
            value?: string;
          }
      >;
      /**
       * A pattern that matches each incoming pathname (excluding querystring).
       */
      source: string;
    }>;
    /**
     * A list of routes objects used to rewrite paths to point towards other internal or external paths
     * @deprecated
     */
    routes?: Array<
      | {
          caseSensitive?: boolean;
          check?: boolean;
          continue?: boolean;
          dest?: string;
          /**
           * An array of requirements that are needed to match
           */
          has?: Array<
            | {
                /**
                 * The type of request element to check
                 */
                type: 'host';
                /**
                 * A regular expression used to match the value. Named groups can be used in the destination
                 */
                value: string;
              }
            | {
                /**
                 * The name of the element contained in the particular type
                 */
                key: string;
                /**
                 * The type of request element to check
                 */
                type: 'header' | 'cookie' | 'query';
                /**
                 * A regular expression used to match the value. Named groups can be used in the destination
                 */
                value?: string;
              }
          >;
          headers?: {
            [key: string]: string;
          };
          important?: boolean;
          isInternal?: boolean;
          locale?: {
            cookie?: string;
            default?: string;
            path?: string;
            redirect?: {
              [key: string]: string;
            };
            value?: string;
          };
          methods?: Array<string>;
          middleware?: number;
          middlewarePath?: string;
          middlewareRawSrc?: Array<string>;
          /**
           * An array of requirements that are needed to match
           */
          missing?: Array<
            | {
                /**
                 * The type of request element to check
                 */
                type: 'host';
                /**
                 * A regular expression used to match the value. Named groups can be used in the destination
                 */
                value: string;
              }
            | {
                /**
                 * The name of the element contained in the particular type
                 */
                key: string;
                /**
                 * The type of request element to check
                 */
                type: 'header' | 'cookie' | 'query';
                /**
                 * A regular expression used to match the value. Named groups can be used in the destination
                 */
                value?: string;
              }
          >;
          override?: boolean;
          src: string;
          status?: number;
          user?: boolean;
        }
      | {
          handle: 'error' | 'filesystem' | 'hit' | 'miss' | 'resource' | 'rewrite';
        }
    >;
    /**
     * Either not defined, `staging`, or `production`. If `staging`, a staging alias in the format `<project>-<team>.vercel.app` will be assigned. If `production`, any aliases defined in `alias` will be assigned. If omitted, the target will be `preview`
     */
    target?: 'staging' | 'production';
    /**
     * When `false`, visiting a path that ends with a forward slash will respond with a `308` status code and redirect to the path without the trailing slash.
     */
    trailingSlash?: boolean;
    /**
     * When `true` and `deploymentId` is passed in, the sha from the previous deployment's `gitSource` is removed forcing the latest commit to be used.
     */
    withLatestCommit?: boolean;
  };
  query?: {
    /**
     * Forces a new deployment even if there is a previous similar deployment
     */
    forceNew?: '0' | '1';
    /**
     * Allows to skip framework detection so the API would not fail to ask for confirmation
     */
    skipAutoDetectionConfirmation?: '0' | '1';
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CreateDeploymentResponse = {
  /**
   * A list of all the aliases (default aliases, staging aliases and production aliases) that were assigned upon deployment creation
   */
  alias: Array<string>;
  /**
   * A boolean that will be true when the aliases from the alias property were assigned successfully
   */
  aliasAssigned: boolean;
  aliasAssignedAt?: (number | boolean) | null;
  /**
   * An object that will contain a `code` and a `message` when the aliasing fails, otherwise the value will be `null`
   */
  aliasError?: {
    code: string;
    message: string;
  } | null;
  aliasFinal?: string | null;
  aliasWarning?: {
    action?: string;
    code: string;
    link?: string;
    message: string;
  } | null;
  automaticAliases?: Array<string>;
  bootedAt: number;
  build: {
    /**
     * The keys of the environment variables that were assigned during the build phase.
     */
    env: Array<string>;
  };
  buildErrorAt?: number;
  buildingAt: number;
  builds?: Array<{
    [key: string]: unknown;
  }>;
  canceledAt?: number;
  checksConclusion?: 'succeeded' | 'failed' | 'skipped' | 'canceled';
  checksState?: 'registered' | 'running' | 'completed';
  /**
   * The ID of Vercel Connect configuration used for this deployment
   */
  connectConfigurationId?: string;
  /**
   * A number containing the date when the deployment was created in milliseconds
   */
  createdAt: number;
  /**
   * The region where the deployment was first created
   */
  createdIn: string;
  /**
   * Information about the deployment creator
   */
  creator: {
    /**
     * The ID of the user that created the deployment
     */
    uid: string;
    /**
     * The username of the user that created the deployment
     */
    username?: string;
  };
  /**
   * The keys of the environment variables that were assigned during runtime
   */
  env: Array<string>;
  errorCode?: string;
  errorLink?: string;
  errorMessage?: string | null;
  errorStep?: string;
  /**
   * An object used to configure your Serverless Functions
   */
  functions?: {
    [key: string]: {
      excludeFiles?: string;
      includeFiles?: string;
      maxDuration?: number;
      memory?: number;
      runtime?: string;
    };
  } | null;
  gitRepo?:
    | (
        | {
            defaultBranch: string;
            name: string;
            namespace: string;
            ownerType: 'team' | 'user';
            path: string;
            private: boolean;
            projectId: number;
            type: 'gitlab';
            url: string;
          }
        | {
            defaultBranch: string;
            name: string;
            org: string;
            ownerType: 'team' | 'user';
            path: string;
            private: boolean;
            repo: string;
            repoId: number;
            repoOwnerId: string;
            type: 'github';
          }
        | {
            defaultBranch: string;
            name: string;
            owner: string;
            ownerType: 'team' | 'user';
            path: string;
            private: boolean;
            repoUuid: string;
            slug: string;
            type: 'bitbucket';
            workspaceUuid: string;
          }
      )
    | null;
  gitSource?:
    | {
        prId?: number | null;
        ref?: string | null;
        repoId: string | number;
        sha?: string;
        type: 'github';
      }
    | {
        org: string;
        prId?: number | null;
        ref?: string | null;
        repo: string;
        sha?: string;
        type: 'github';
      }
    | {
        prId?: number | null;
        projectId: string | number;
        ref?: string | null;
        sha?: string;
        type: 'gitlab';
      }
    | {
        prId?: number | null;
        ref?: string | null;
        repoUuid: string;
        sha?: string;
        type: 'bitbucket';
        workspaceUuid?: string;
      }
    | {
        owner: string;
        prId?: number | null;
        ref?: string | null;
        sha?: string;
        slug: string;
        type: 'bitbucket';
      }
    | {
        gitUrl: string;
        ref: string;
        sha: string;
        type: 'custom';
      }
    | {
        org?: string;
        ref: string;
        repo?: string;
        repoId: number;
        sha: string;
        type: 'github';
      }
    | {
        projectId: number;
        ref: string;
        sha: string;
        type: 'gitlab';
      }
    | {
        owner?: string;
        ref: string;
        repoUuid: string;
        sha: string;
        slug?: string;
        type: 'bitbucket';
        workspaceUuid: string;
      };
  /**
   * A string holding the unique ID of the deployment
   */
  id: string;
  /**
   * Vercel URL to inspect the deployment.
   */
  inspectorUrl: string | null;
  /**
   * Is the deployment currently queued waiting for a Concurrent Build Slot to be available
   */
  isInConcurrentBuildsQueue: boolean;
  lambdas?: Array<{
    createdAt?: number;
    entrypoint?: string | null;
    id: string;
    output: Array<{
      functionName: string;
      path: string;
    }>;
    readyState?: 'BUILDING' | 'ERROR' | 'INITIALIZING' | 'READY';
    readyStateAt?: number;
  }>;
  /**
   * An object containing the deployment's metadata
   */
  meta: {
    [key: string]: string;
  };
  /**
   * An monorepo manager that was used for the deployment
   */
  monorepoManager?: string | null;
  /**
   * The name of the project associated with the deployment at the time that the deployment was created
   */
  name: string;
  /**
   * The unique ID of the user or team the deployment belongs to
   */
  ownerId: string;
  /**
   * The pricing plan the deployment was made under
   */
  plan: 'hobby' | 'enterprise' | 'pro' | 'oss';
  /**
   * Whether or not preview comments are enabled for the deployment
   */
  previewCommentsEnabled?: boolean;
  /**
   * The ID of the project the deployment is associated with
   */
  projectId: string;
  /**
   * A boolean representing if the deployment is public or not. By default this is `false`
   */
  public: boolean;
  /**
   * The state of the deployment depending on the process of deploying, or if it is ready or in an error state
   */
  readyState: 'QUEUED' | 'BUILDING' | 'ERROR' | 'INITIALIZING' | 'READY' | 'CANCELED';
  /**
   * The regions the deployment exists in
   */
  regions: Array<string>;
  /**
   * A list of routes objects used to rewrite paths to point towards other internal or external paths
   */
  routes: Array<
    | {
        caseSensitive?: boolean;
        check?: boolean;
        continue?: boolean;
        dest?: string;
        has?: Array<
          | {
              type: 'host';
              value: string;
            }
          | {
              key: string;
              type: 'header' | 'cookie' | 'query';
              value?: string;
            }
        >;
        headers?: {
          [key: string]: string;
        };
        important?: boolean;
        locale?: {
          cookie?: string;
          /**
           * Construct a type with a set of properties K of type T
           */
          redirect?: {
            [key: string]: string;
          };
        };
        methods?: Array<string>;
        /**
         * A middleware index in the `middleware` key under the build result
         */
        middleware?: number;
        /**
         * A middleware key within the `output` key under the build result. Overrides a `middleware` definition.
         */
        middlewarePath?: string;
        /**
         * The original middleware matchers.
         */
        middlewareRawSrc?: Array<string>;
        missing?: Array<
          | {
              type: 'host';
              value: string;
            }
          | {
              key: string;
              type: 'header' | 'cookie' | 'query';
              value?: string;
            }
        >;
        override?: boolean;
        src: string;
        status?: number;
      }
    | {
        dest?: string;
        handle: 'filesystem' | 'hit' | 'miss' | 'rewrite' | 'error' | 'resource';
        src?: string;
        status?: number;
      }
    | {
        continue: boolean;
        middleware: 0;
        src: string;
      }
  > | null;
  /**
   * Where was the deployment created from
   */
  source?: 'cli' | 'git' | 'import' | 'import/repo' | 'clone/repo';
  /**
   * If defined, either `staging` if a staging alias in the format `<project>.<team>.now.sh` was assigned upon creation, or `production` if the aliases from `alias` were assigned
   */
  target?: ('production' | 'staging') | null;
  /**
   * The team that owns the deployment if any
   */
  team?: {
    /**
     * The ID of the team owner
     */
    id: string;
    /**
     * The name of the team owner
     */
    name: string;
    /**
     * The slug of the team owner
     */
    slug: string;
  };
  type: 'LAMBDAS';
  /**
   * A string with the unique URL of the deployment
   */
  url: string;
  /**
   * An array of domains that were provided by the user when creating the Deployment.
   */
  userAliases?: Array<string>;
  /**
   * The platform version that was used to create the deployment.
   */
  version: 2;
};

export type CreateDeploymentError = unknown;

export type GetDeploymentData = {
  path: {
    /**
     * The unique identifier or hostname of the deployment.
     */
    idOrUrl: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    /**
     * Whether to add in gitRepo information.
     */
    withGitRepoInfo?: string;
  };
};

export type GetDeploymentResponse =
  | {
      /**
       * A list of all the aliases (default aliases, staging aliases and production aliases) that were assigned upon deployment creation
       */
      alias: Array<string>;
      /**
       * A boolean that will be true when the aliases from the alias property were assigned successfully
       */
      aliasAssigned: boolean;
      aliasAssignedAt?: (number | boolean) | null;
      /**
       * An object that will contain a `code` and a `message` when the aliasing fails, otherwise the value will be `null`
       */
      aliasError?: {
        code: string;
        message: string;
      } | null;
      aliasFinal?: string | null;
      aliasWarning?: {
        action?: string;
        code: string;
        link?: string;
        message: string;
      } | null;
      automaticAliases?: Array<string>;
      bootedAt: number;
      build: {
        /**
         * The keys of the environment variables that were assigned during the build phase.
         */
        env: Array<string>;
      };
      buildErrorAt?: number;
      buildingAt: number;
      builds?: Array<{
        [key: string]: unknown;
      }>;
      canceledAt?: number;
      checksConclusion?: 'succeeded' | 'failed' | 'skipped' | 'canceled';
      checksState?: 'registered' | 'running' | 'completed';
      /**
       * The ID of Vercel Connect configuration used for this deployment
       */
      connectConfigurationId?: string;
      /**
       * A number containing the date when the deployment was created in milliseconds
       */
      createdAt: number;
      /**
       * The region where the deployment was first created
       */
      createdIn: string;
      /**
       * Information about the deployment creator
       */
      creator: {
        /**
         * The ID of the user that created the deployment
         */
        uid: string;
        /**
         * The username of the user that created the deployment
         */
        username?: string;
      };
      /**
       * The keys of the environment variables that were assigned during runtime
       */
      env: Array<string>;
      errorCode?: string;
      errorLink?: string;
      errorMessage?: string | null;
      errorStep?: string;
      /**
       * An object used to configure your Serverless Functions
       */
      functions?: {
        [key: string]: {
          excludeFiles?: string;
          includeFiles?: string;
          maxDuration?: number;
          memory?: number;
          runtime?: string;
        };
      } | null;
      gitRepo?:
        | (
            | {
                defaultBranch: string;
                name: string;
                namespace: string;
                ownerType: 'team' | 'user';
                path: string;
                private: boolean;
                projectId: number;
                type: 'gitlab';
                url: string;
              }
            | {
                defaultBranch: string;
                name: string;
                org: string;
                ownerType: 'team' | 'user';
                path: string;
                private: boolean;
                repo: string;
                repoId: number;
                repoOwnerId: string;
                type: 'github';
              }
            | {
                defaultBranch: string;
                name: string;
                owner: string;
                ownerType: 'team' | 'user';
                path: string;
                private: boolean;
                repoUuid: string;
                slug: string;
                type: 'bitbucket';
                workspaceUuid: string;
              }
          )
        | null;
      gitSource?:
        | {
            prId?: number | null;
            ref?: string | null;
            repoId: string | number;
            sha?: string;
            type: 'github';
          }
        | {
            org: string;
            prId?: number | null;
            ref?: string | null;
            repo: string;
            sha?: string;
            type: 'github';
          }
        | {
            prId?: number | null;
            projectId: string | number;
            ref?: string | null;
            sha?: string;
            type: 'gitlab';
          }
        | {
            prId?: number | null;
            ref?: string | null;
            repoUuid: string;
            sha?: string;
            type: 'bitbucket';
            workspaceUuid?: string;
          }
        | {
            owner: string;
            prId?: number | null;
            ref?: string | null;
            sha?: string;
            slug: string;
            type: 'bitbucket';
          }
        | {
            gitUrl: string;
            ref: string;
            sha: string;
            type: 'custom';
          }
        | {
            org?: string;
            ref: string;
            repo?: string;
            repoId: number;
            sha: string;
            type: 'github';
          }
        | {
            projectId: number;
            ref: string;
            sha: string;
            type: 'gitlab';
          }
        | {
            owner?: string;
            ref: string;
            repoUuid: string;
            sha: string;
            slug?: string;
            type: 'bitbucket';
            workspaceUuid: string;
          };
      /**
       * A string holding the unique ID of the deployment
       */
      id: string;
      /**
       * Vercel URL to inspect the deployment.
       */
      inspectorUrl: string | null;
      /**
       * Is the deployment currently queued waiting for a Concurrent Build Slot to be available
       */
      isInConcurrentBuildsQueue: boolean;
      lambdas?: Array<{
        createdAt?: number;
        entrypoint?: string | null;
        id: string;
        output: Array<{
          functionName: string;
          path: string;
        }>;
        readyState?: 'BUILDING' | 'ERROR' | 'INITIALIZING' | 'READY';
        readyStateAt?: number;
      }>;
      /**
       * An object containing the deployment's metadata
       */
      meta: {
        [key: string]: string;
      };
      /**
       * An monorepo manager that was used for the deployment
       */
      monorepoManager?: string | null;
      /**
       * The name of the project associated with the deployment at the time that the deployment was created
       */
      name: string;
      /**
       * The unique ID of the user or team the deployment belongs to
       */
      ownerId: string;
      /**
       * The pricing plan the deployment was made under
       */
      plan: 'hobby' | 'enterprise' | 'pro' | 'oss';
      /**
       * Whether or not preview comments are enabled for the deployment
       */
      previewCommentsEnabled?: boolean;
      /**
       * The ID of the project the deployment is associated with
       */
      projectId: string;
      /**
       * A boolean representing if the deployment is public or not. By default this is `false`
       */
      public: boolean;
      /**
       * The state of the deployment depending on the process of deploying, or if it is ready or in an error state
       */
      readyState: 'QUEUED' | 'BUILDING' | 'ERROR' | 'INITIALIZING' | 'READY' | 'CANCELED';
      /**
       * The regions the deployment exists in
       */
      regions: Array<string>;
      /**
       * A list of routes objects used to rewrite paths to point towards other internal or external paths
       */
      routes: Array<
        | {
            caseSensitive?: boolean;
            check?: boolean;
            continue?: boolean;
            dest?: string;
            has?: Array<
              | {
                  type: 'host';
                  value: string;
                }
              | {
                  key: string;
                  type: 'header' | 'cookie' | 'query';
                  value?: string;
                }
            >;
            headers?: {
              [key: string]: string;
            };
            important?: boolean;
            locale?: {
              cookie?: string;
              /**
               * Construct a type with a set of properties K of type T
               */
              redirect?: {
                [key: string]: string;
              };
            };
            methods?: Array<string>;
            /**
             * A middleware index in the `middleware` key under the build result
             */
            middleware?: number;
            /**
             * A middleware key within the `output` key under the build result. Overrides a `middleware` definition.
             */
            middlewarePath?: string;
            /**
             * The original middleware matchers.
             */
            middlewareRawSrc?: Array<string>;
            missing?: Array<
              | {
                  type: 'host';
                  value: string;
                }
              | {
                  key: string;
                  type: 'header' | 'cookie' | 'query';
                  value?: string;
                }
            >;
            override?: boolean;
            src: string;
            status?: number;
          }
        | {
            dest?: string;
            handle: 'filesystem' | 'hit' | 'miss' | 'rewrite' | 'error' | 'resource';
            src?: string;
            status?: number;
          }
        | {
            continue: boolean;
            middleware: 0;
            src: string;
          }
      > | null;
      /**
       * Where was the deployment created from
       */
      source?: 'cli' | 'git' | 'import' | 'import/repo' | 'clone/repo';
      /**
       * If defined, either `staging` if a staging alias in the format `<project>.<team>.now.sh` was assigned upon creation, or `production` if the aliases from `alias` were assigned
       */
      target?: ('production' | 'staging') | null;
      /**
       * The team that owns the deployment if any
       */
      team?: {
        /**
         * The ID of the team owner
         */
        id: string;
        /**
         * The name of the team owner
         */
        name: string;
        /**
         * The slug of the team owner
         */
        slug: string;
      };
      type: 'LAMBDAS';
      /**
       * A string with the unique URL of the deployment
       */
      url: string;
      /**
       * An array of domains that were provided by the user when creating the Deployment.
       */
      userAliases?: Array<string>;
      /**
       * The platform version that was used to create the deployment.
       */
      version: 2;
    }
  | {
      /**
       * A list of all the aliases (default aliases, staging aliases and production aliases) that were assigned upon deployment creation
       */
      alias: Array<string>;
      /**
       * A boolean that will be true when the aliases from the alias property were assigned successfully
       */
      aliasAssigned: boolean;
      /**
       * An object that will contain a `code` and a `message` when the aliasing fails, otherwise the value will be `null`
       */
      aliasError?: {
        code: string;
        message: string;
      } | null;
      aliasFinal?: string | null;
      aliasWarning?: {
        action?: string;
        code: string;
        link?: string;
        message: string;
      } | null;
      automaticAliases?: Array<string>;
      bootedAt: number;
      buildErrorAt?: number;
      buildingAt: number;
      canceledAt?: number;
      checksConclusion?: 'succeeded' | 'failed' | 'skipped' | 'canceled';
      checksState?: 'registered' | 'running' | 'completed';
      /**
       * A number containing the date when the deployment was created in milliseconds
       */
      createdAt: number;
      /**
       * Information about the deployment creator
       */
      creator: {
        /**
         * The ID of the user that created the deployment
         */
        uid: string;
        /**
         * The username of the user that created the deployment
         */
        username?: string;
      };
      errorCode?: string;
      errorLink?: string;
      errorMessage?: string | null;
      errorStep?: string;
      gitSource?:
        | {
            prId?: number | null;
            ref?: string | null;
            repoId: string | number;
            sha?: string;
            type: 'github';
          }
        | {
            org: string;
            prId?: number | null;
            ref?: string | null;
            repo: string;
            sha?: string;
            type: 'github';
          }
        | {
            prId?: number | null;
            projectId: string | number;
            ref?: string | null;
            sha?: string;
            type: 'gitlab';
          }
        | {
            prId?: number | null;
            ref?: string | null;
            repoUuid: string;
            sha?: string;
            type: 'bitbucket';
            workspaceUuid?: string;
          }
        | {
            owner: string;
            prId?: number | null;
            ref?: string | null;
            sha?: string;
            slug: string;
            type: 'bitbucket';
          }
        | {
            gitUrl: string;
            ref: string;
            sha: string;
            type: 'custom';
          }
        | {
            org?: string;
            ref: string;
            repo?: string;
            repoId: number;
            sha: string;
            type: 'github';
          }
        | {
            projectId: number;
            ref: string;
            sha: string;
            type: 'gitlab';
          }
        | {
            owner?: string;
            ref: string;
            repoUuid: string;
            sha: string;
            slug?: string;
            type: 'bitbucket';
            workspaceUuid: string;
          };
      /**
       * A string holding the unique ID of the deployment
       */
      id: string;
      lambdas?: Array<{
        createdAt?: number;
        entrypoint?: string | null;
        id: string;
        output: Array<{
          functionName: string;
          path: string;
        }>;
        readyState?: 'BUILDING' | 'ERROR' | 'INITIALIZING' | 'READY';
        readyStateAt?: number;
      }>;
      /**
       * An object containing the deployment's metadata
       */
      meta: {
        [key: string]: string;
      };
      /**
       * The name of the project associated with the deployment at the time that the deployment was created
       */
      name: string;
      /**
       * Whether or not preview comments are enabled for the deployment
       */
      previewCommentsEnabled?: boolean;
      /**
       * A boolean representing if the deployment is public or not. By default this is `false`
       */
      public: boolean;
      /**
       * The state of the deployment depending on the process of deploying, or if it is ready or in an error state
       */
      readyState: 'QUEUED' | 'BUILDING' | 'ERROR' | 'INITIALIZING' | 'READY' | 'CANCELED';
      /**
       * The regions the deployment exists in
       */
      regions: Array<string>;
      /**
       * Where was the deployment created from
       */
      source?: 'cli' | 'git' | 'import' | 'import/repo' | 'clone/repo';
      /**
       * If defined, either `staging` if a staging alias in the format `<project>.<team>.now.sh` was assigned upon creation, or `production` if the aliases from `alias` were assigned
       */
      target?: ('production' | 'staging') | null;
      /**
       * The team that owns the deployment if any
       */
      team?: {
        /**
         * The ID of the team owner
         */
        id: string;
        /**
         * The name of the team owner
         */
        name: string;
        /**
         * The slug of the team owner
         */
        slug: string;
      };
      type: 'LAMBDAS';
      /**
       * A string with the unique URL of the deployment
       */
      url: string;
      /**
       * An array of domains that were provided by the user when creating the Deployment.
       */
      userAliases?: Array<string>;
      /**
       * The platform version that was used to create the deployment.
       */
      version: 2;
    };

export type GetDeploymentError = unknown;

export type DeleteDeploymentData = {
  path: {
    /**
     * The ID of the deployment to be deleted
     */
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    /**
     * A Deployment or Alias URL. In case it is passed, the ID will be ignored
     */
    url?: string;
  };
};

export type DeleteDeploymentResponse = {
  /**
   * A constant with the final state of the deployment.
   */
  state: 'DELETED';
  /**
   * The removed deployment ID.
   */
  uid: string;
};

export type DeleteDeploymentError = unknown;

export type DeleteAliasData = {
  path: {
    /**
     * The ID or alias that will be removed
     */
    aliasId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type DeleteAliasResponse = {
  status: 'SUCCESS';
};

export type DeleteAliasError = unknown;

export type GetDeploymentEventsData = {
  path: {
    /**
     * The unique identifier or hostname of the deployment.
     */
    idOrUrl: string;
  };
  query?: {
    builds?: 0 | 1;
    delimiter?: 0 | 1;
    /**
     * Order of the returned events based on the timestamp.
     */
    direction?: 'backward' | 'forward';
    /**
     * When enabled, this endpoint will return live events as they happen.
     */
    follow?: 0 | 1;
    /**
     * Maximum number of events to return. Provide `-1` to return all available logs.
     */
    limit?: number;
    /**
     * Deployment build ID.
     */
    name?: string;
    /**
     * Timestamp for when build logs should be pulled from.
     */
    since?: number;
    /**
     * HTTP status code range to filter events by.
     */
    statusCode?: number | string;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    /**
     * Timestamp for when the build logs should be pulled up until.
     */
    until?: number;
  };
};

export type GetDeploymentEventsResponse = Array<
  | {
      created: number;
      payload: {
        date: number;
        deploymentId: string;
        id: string;
        serial: string;
        text?: string;
      };
      type: 'command';
    }
  | {
      created: number;
      payload: {
        date: number;
        deploymentId: string;
        id: string;
        info: {
          entrypoint?: string;
          name: string;
          path?: string;
          step?: string;
          type: string;
        };
        serial: string;
      };
      type: 'deployment-state';
    }
  | {
      created: number;
      payload: {
        date: number;
        deploymentId: string;
        id: string;
        info: {
          entrypoint?: string;
          name: string;
          path?: string;
          step?: string;
          type: string;
        };
        serial: string;
      };
      type: 'delimiter';
    }
  | {
      created: number;
      payload: {
        created: number;
        date: number;
        deploymentId: string;
        id: string;
        serial: string;
        text?: string;
      };
      type: 'exit';
    }
  | {
      created: number;
      payload: {
        date: number;
        deploymentId: string;
        id: string;
        info: {
          entrypoint?: string;
          name: string;
          path?: string;
          step?: string;
          type: string;
        };
        requestId?: string;
        serial: string;
        text?: string;
      };
      type: 'middleware';
    }
  | {
      created: number;
      payload: {
        date: number;
        deploymentId: string;
        id: string;
        info: {
          entrypoint?: string;
          name: string;
          path?: string;
          step?: string;
          type: string;
        };
        requestId?: string;
        serial: string;
        statusCode?: number;
        text?: string;
      };
      type:
        | 'command'
        | 'stdout'
        | 'stderr'
        | 'exit'
        | 'deployment-state'
        | 'delimiter'
        | 'middleware'
        | 'middleware-invocation'
        | 'edge-function-invocation'
        | 'fatal';
    }
>;

export type GetDeploymentEventsError = unknown;

export type ListDeploymentAliasesData = {
  path: {
    /**
     * The ID of the deployment the aliases should be listed for
     */
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type ListDeploymentAliasesResponse = {
  /**
   * A list of the aliases assigned to the deployment
   */
  aliases: Array<{
    /**
     * The alias name, it could be a `.vercel.app` subdomain or a custom domain
     */
    alias: string;
    /**
     * The date when the alias was created
     */
    created: string;
    /**
     * Construct a type with a set of properties K of type T
     */
    protectionBypass?: {
      [key: string]: string;
    };
    /**
     * Target destination domain for redirect when the alias is a redirect
     */
    redirect?: string | null;
    /**
     * The unique identifier of the alias
     */
    uid: string;
  }>;
};

export type ListDeploymentAliasesError = unknown;

export type AssignAliasData = {
  body?: {
    /**
     * The alias we want to assign to the deployment defined in the URL
     */
    alias?: string;
    /**
     * The redirect property will take precedence over the deployment id from the URL and consists of a hostname (like test.com) to which the alias should redirect using status code 307
     */
    redirect?: string | null;
  };
  path: {
    /**
     * The ID of the deployment the aliases should be listed for
     */
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type AssignAliasResponse = {
  /**
   * The assigned alias name
   */
  alias: string;
  /**
   * The date when the alias was created
   */
  created: string;
  /**
   * The unique identifier of the previously aliased deployment, only received when the alias was used before
   */
  oldDeploymentId?: string | null;
  /**
   * The unique identifier of the alias
   */
  uid: string;
};

export type AssignAliasError = unknown;

export type CreateRecordData = {
  body?:
    | {
        /**
         * A subdomain name or an empty string for the root domain.
         */
        name: string;
        /**
         * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
         */
        ttl?: number;
        /**
         * Must be of type `A`.
         */
        type: 'A';
        /**
         * The record value must be a valid IPv4 address.
         */
        value: string;
      }
    | {
        /**
         * A subdomain name or an empty string for the root domain.
         */
        name: string;
        /**
         * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
         */
        ttl?: number;
        /**
         * Must be of type `AAAA`.
         */
        type: 'AAAA';
        /**
         * An AAAA record pointing to an IPv6 address.
         */
        value: string;
      }
    | {
        /**
         * A subdomain name or an empty string for the root domain.
         */
        name: string;
        /**
         * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
         */
        ttl?: number;
        /**
         * Must be of type `ALIAS`.
         */
        type: 'ALIAS';
        /**
         * An ALIAS virtual record pointing to a hostname resolved to an A record on server side.
         */
        value: string;
      }
    | {
        /**
         * A subdomain name or an empty string for the root domain.
         */
        name: string;
        /**
         * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
         */
        ttl?: number;
        /**
         * Must be of type `CAA`.
         */
        type: 'CAA';
        /**
         * A CAA record to specify which Certificate Authorities (CAs) are allowed to issue certificates for the domain.
         */
        value: string;
      }
    | {
        /**
         * A subdomain name or an empty string for the root domain.
         */
        name: string;
        /**
         * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
         */
        ttl?: number;
        /**
         * Must be of type `CNAME`.
         */
        type: 'CNAME';
        /**
         * A CNAME record mapping to another domain name.
         */
        value?: string;
      }
    | {
        mxPriority: number;
        /**
         * A subdomain name or an empty string for the root domain.
         */
        name: string;
        /**
         * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
         */
        ttl?: number;
        /**
         * Must be of type `MX`.
         */
        type: 'MX';
        /**
         * An MX record specifying the mail server responsible for accepting messages on behalf of the domain name.
         */
        value: string;
      }
    | {
        /**
         * A subdomain name or an empty string for the root domain.
         */
        name: string;
        srv: {
          port: number | null;
          priority: number | null;
          target?: string;
          weight: number | null;
        };
        /**
         * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
         */
        ttl?: number;
        /**
         * Must be of type `SRV`.
         */
        type: 'SRV';
      }
    | {
        /**
         * A subdomain name or an empty string for the root domain.
         */
        name: string;
        /**
         * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
         */
        ttl?: number;
        /**
         * Must be of type `TXT`.
         */
        type: 'TXT';
        /**
         * A TXT record containing arbitrary text.
         */
        value: string;
      }
    | {
        /**
         * A subdomain name.
         */
        name: string;
        /**
         * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
         */
        ttl?: number;
        /**
         * Must be of type `NS`.
         */
        type: 'NS';
        /**
         * An NS domain value.
         */
        value?: string;
      }
    | {
        /**
         * The type of record, it could be one of the valid DNS records.
         */
        type: 'A' | 'AAAA' | 'ALIAS' | 'CAA' | 'CNAME' | 'MX' | 'SRV' | 'TXT' | 'NS';
      };
  path: {
    /**
     * The domain used to create the DNS record.
     */
    domain: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CreateRecordResponse =
  | {
      uid: string;
      updated: number;
    }
  | {
      /**
       * The id of the newly created DNS record
       */
      uid: string;
    };

export type CreateRecordError = unknown;

export type RemoveRecordData = {
  path: {
    domain: string;
    recordId: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type RemoveRecordResponse = {
  [key: string]: unknown;
};

export type RemoveRecordError = unknown;

export type UploadFileData = {
  headers?: {
    /**
     * The file size in bytes
     */
    'Content-Length'?: number;
    /**
     * The file SHA1 used to check the integrity
     */
    'x-now-digest'?: string;
    /**
     * The file size as an alternative to `Content-Length`
     */
    'x-now-size'?: number;
    /**
     * The file SHA1 used to check the integrity
     */
    'x-vercel-digest'?: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type UploadFileResponse =
  | {
      /**
       * Array of URLs where the file was updated
       */
      urls: Array<string>;
    }
  | {
      [key: string]: unknown;
    };

export type UploadFileError = unknown;

export type GetIntegrationLogDrainsData = {
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetIntegrationLogDrainsResponse = Array<{
  /**
   * The branch regexp of log drain
   */
  branch?: string;
  /**
   * The oauth2 client application id that created this log drain
   */
  clientId?: string;
  /**
   * The client configuration this log drain was created with
   */
  configurationId?: string;
  /**
   * A timestamp that tells you when the log drain was created
   */
  createdAt: number;
  /**
   * Whether the log drain was created by an integration or by a user
   */
  createdFrom?: 'self-served' | 'integration';
  /**
   * The delivery log format
   */
  deliveryFormat?: 'json' | 'ndjson' | 'syslog';
  /**
   * The environment of log drain
   */
  environment?: 'production' | 'preview';
  /**
   * Construct a type with a set of properties K of type T
   */
  headers?: {
    [key: string]: string;
  };
  /**
   * The unique identifier of the log drain. Always prefixed with `ld_`
   */
  id: string;
  /**
   * The name of the log drain
   */
  name: string;
  /**
   * The identifier of the team or user whose events will trigger the log drain
   */
  ownerId: string;
  projectId?: string | null;
  /**
   * The identifier of the projects this log drain is associated with
   */
  projectIds?: Array<string>;
  /**
   * The sources from which logs are currently being delivered to this log drain.
   */
  sources?: Array<'static' | 'lambda' | 'build' | 'edge' | 'external' | 'deployment'>;
  /**
   * The URL to call when logs are generated
   */
  url: string;
}>;

export type GetIntegrationLogDrainsError = unknown;

export type CreateLogDrainData = {
  body?: {
    /**
     * The branch regexp of log drain
     */
    branch?: string;
    /**
     * The delivery log format
     */
    deliveryFormat?: 'json' | 'ndjson' | 'syslog';
    /**
     * The environment of log drain
     */
    environment?: 'preview' | 'production';
    /**
     * Headers to be sent together with the request
     */
    headers?: {
      [key: string]: string;
    };
    /**
     * The name of the log drain
     */
    name: string;
    projectIds?: Array<string>;
    /**
     * A secret to sign log drain notification headers so a consumer can verify their authenticity
     */
    secret?: string;
    sources?: Array<'static' | 'lambda' | 'build' | 'edge' | 'external'>;
    /**
     * The url where you will receive logs. The protocol must be `https://` or `http://` when type is `json` and `ndjson`, and `syslog+tls:` or `syslog:` when the type is `syslog`.
     */
    url: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CreateLogDrainResponse = {
  /**
   * The branch regexp of log drain
   */
  branch?: string;
  /**
   * The oauth2 client application id that created this log drain
   */
  clientId?: string;
  /**
   * The client configuration this log drain was created with
   */
  configurationId?: string;
  /**
   * A timestamp that tells you when the log drain was created
   */
  createdAt: number;
  /**
   * Whether the log drain was created by an integration or by a user
   */
  createdFrom?: 'self-served' | 'integration';
  /**
   * The delivery log format
   */
  deliveryFormat?: 'json' | 'ndjson' | 'syslog';
  /**
   * The environment of log drain
   */
  environment?: 'preview' | 'production';
  /**
   * Construct a type with a set of properties K of type T
   */
  headers?: {
    [key: string]: string;
  };
  /**
   * The unique identifier of the log drain. Always prefixed with `ld_`
   */
  id: string;
  /**
   * The name of the log drain
   */
  name: string;
  /**
   * The identifier of the team or user whose events will trigger the log drain
   */
  ownerId: string;
  projectId?: string | null;
  /**
   * The identifier of the projects this log drain is associated with
   */
  projectIds?: Array<string>;
  /**
   * The sources from which logs are currently being delivered to this log drain.
   */
  sources?: Array<'static' | 'lambda' | 'build' | 'edge' | 'external' | 'deployment'>;
  /**
   * The URL to call when logs are generated
   */
  url: string;
};

export type CreateLogDrainError = unknown;

export type DeleteSecretData = {
  path: {
    /**
     * The name or the unique identifier to which the secret belongs to.
     */
    idOrName: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type DeleteSecretResponse = {
  /**
   * The date when the secret was created.
   */
  created: number;
  /**
   * The name of the deleted secret.
   */
  name: string;
  /**
   * The unique identifier of the deleted secret.
   */
  uid: string;
};

export type DeleteSecretError = unknown;

export type RenameSecretData = {
  body?: {
    /**
     * The name of the new secret.
     */
    name: string;
  };
  path: {
    /**
     * The name of the secret.
     */
    name: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type RenameSecretResponse = {
  /**
   * Enables basic storage and retrieval of dates and times.
   */
  created: string;
  name: string;
  oldName: string;
  uid: string;
};

export type RenameSecretError = unknown;

export type CreateSecretData = {
  body?: {
    /**
     * Whether the secret value can be decrypted after it has been created.
     */
    decryptable?: boolean;
    /**
     * The name of the secret (max 100 characters).
     */
    name: string;
    /**
     * Associate a secret to a project.
     * @deprecated
     */
    projectId?: string;
    /**
     * The value of the new secret.
     */
    value: string;
  };
  path: {
    /**
     * Automatically added
     */
    name: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CreateSecretResponse = {
  /**
   * The date when the secret was created.
   */
  created: string;
  /**
   * Timestamp for when the secret was created.
   */
  createdAt?: number;
  /**
   * Indicates whether the secret value can be decrypted after it has been created.
   */
  decryptable?: boolean;
  /**
   * The name of the secret.
   */
  name: string;
  /**
   * The unique identifier of the project which the secret belongs to.
   */
  projectId?: string;
  /**
   * The unique identifier of the team the secret was created for.
   */
  teamId?: string | null;
  /**
   * The unique identifier of the secret.
   */
  uid: string;
  /**
   * The unique identifier of the user who created the secret.
   */
  userId?: string;
  value: {
    data?: Array<number>;
    type?: 'Buffer';
  };
};

export type CreateSecretError = unknown;

export type GetTeamsData = {
  query?: {
    /**
     * Maximum number of Teams which may be returned.
     */
    limit?: number;
    /**
     * Timestamp (in milliseconds) to only include Teams created since then.
     */
    since?: number;
    /**
     * Timestamp (in milliseconds) to only include Teams created until then.
     */
    until?: number;
  };
};

export type GetTeamsResponse = {
  pagination: Pagination;
  teams: Array<Team | TeamLimited>;
};

export type GetTeamsError = unknown;

export type GetTeamData = {
  path: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId: string;
  };
  query?: {
    slug?: string;
  };
};

export type GetTeamResponse = Team;

export type GetTeamError = unknown;

export type PatchTeamData = {
  body?: {
    /**
     * The hash value of an uploaded image.
     */
    avatar?: string;
    /**
     * A short text that describes the team.
     */
    description?: string;
    emailDomain?: string | null;
    /**
     * Enable preview comments: one of on, off or default.
     */
    enablePreviewFeedback?: string;
    /**
     * Runs a task that migrates all existing environment variables to sensitive environment variables.
     */
    migrateExistingEnvVariablesToSensitive?: boolean;
    /**
     * The name of the team.
     */
    name?: string;
    /**
     * Suffix that will be used for all preview deployments.
     */
    previewDeploymentSuffix?: string | null;
    /**
     * Create a new invite code and replace the current one.
     */
    regenerateInviteCode?: boolean;
    /**
     * Whether or not remote caching is enabled for the team
     */
    remoteCaching?: {
      /**
       * Enable or disable remote caching for the team.
       */
      enabled?: boolean;
    };
    saml?: {
      /**
       * Require that members of the team use SAML Single Sign-On.
       */
      enforced?: boolean;
      roles?: {
        [key: string]: 'OWNER' | 'MEMBER' | 'VIEWER' | 'DEVELOPER' | 'BILLING';
      };
    };
    /**
     * Sensitive environment variable policy: one of on, off or default.
     */
    sensitiveEnvironmentVariablePolicy?: string;
    /**
     * A new slug for the team.
     */
    slug?: string;
  };
  path: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId: string;
  };
};

export type PatchTeamResponse = Team;

export type PatchTeamError = unknown;

export type GetTeamMembersData = {
  path: {
    /**
     * Automatically added
     */
    teamId: string;
  };
  query?: {
    /**
     * Exclude members who belong to the specified project.
     */
    excludeProject?: string;
    /**
     * Limit how many teams should be returned
     */
    limit?: number;
    /**
     * Only return members with the specified team role.
     */
    role?: 'OWNER' | 'MEMBER' | 'DEVELOPER' | 'VIEWER';
    /**
     * Search team members by their name, username, and email.
     */
    search?: string;
    /**
     * Timestamp in milliseconds to only include members added since then.
     */
    since?: number;
    /**
     * Timestamp in milliseconds to only include members added until then.
     */
    until?: number;
  };
};

export type GetTeamMembersResponse = {
  emailInviteCodes?: Array<{
    createdAt?: number;
    email?: string;
    id: string;
    isDSyncUser: boolean;
    role?: 'MEMBER' | 'OWNER' | 'VIEWER' | 'DEVELOPER' | 'BILLING';
  }>;
  members: Array<{
    /**
     * Timestamp in milliseconds for when this team member was accepted by an owner.
     */
    accessRequestedAt?: number;
    /**
     * ID of the file for the Avatar of this member.
     */
    avatar?: string;
    /**
     * Information about the Bitbucket account of this user.
     */
    bitbucket?: {
      accountId?: string;
      email?: string;
      login?: string;
      userId?: number;
    };
    /**
     * Boolean that indicates if this member was confirmed by an owner.
     */
    confirmed: boolean;
    /**
     * Timestamp in milliseconds when this member was added.
     */
    createdAt: number;
    /**
     * The email of this member.
     */
    email: string;
    /**
     * Information about the GitHub account for this user.
     */
    github?: {
      accountId?: string;
      email?: string;
      login?: string;
      userId?: number;
    };
    /**
     * Information about the GitLab account of this user.
     */
    gitlab?: {
      accountId?: string;
      email?: string;
      login?: string;
      userId?: number;
    };
    /**
     * Map with information about the members origin if they joined by requesting access.
     */
    joinedFrom?: {
      commitId?: string;
      dsyncConnectedAt?: number;
      dsyncUserId?: string;
      gitUserId?: string | number;
      gitUserLogin?: string;
      idpUserId?: string;
      origin:
        | 'import'
        | 'gitlab'
        | 'bitbucket'
        | 'github'
        | 'mail'
        | 'link'
        | 'teams'
        | 'saml'
        | 'dsync'
        | 'feedback'
        | 'organization-teams';
      repoId?: string;
      repoPath?: string;
      ssoConnectedAt?: number;
      ssoUserId?: string;
    };
    /**
     * The name of this user.
     */
    name?: string;
    /**
     * Role of this user in the team.
     */
    role: 'MEMBER' | 'OWNER' | 'VIEWER' | 'DEVELOPER' | 'BILLING';
    /**
     * The ID of this user.
     */
    uid: string;
    /**
     * The unique username of this user.
     */
    username: string;
  }>;
  pagination: {
    /**
     * Amount of items in the current page.
     */
    count: number;
    hasNext: boolean;
    /**
     * Timestamp that must be used to request the next page.
     */
    next: number | null;
    /**
     * Timestamp that must be used to request the previous page.
     */
    prev: number | null;
  };
};

export type GetTeamMembersError = unknown;

export type GetAuthUserResponse = {
  user: AuthUser | AuthUserLimited;
};

export type GetAuthUserError = unknown;

export type ListUserEventsData = {
  query?: {
    /**
     * Maximum number of items which may be returned.
     */
    limit?: number;
    /**
     * Timestamp to only include items created since then.
     */
    since?: string;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    /**
     * Comma-delimited list of event \"types\" to filter the results by.
     */
    types?: string;
    /**
     * Timestamp to only include items created until then.
     */
    until?: string;
    /**
     * When retrieving events for a Team, the `userId` parameter may be specified to filter events generated by a specific member of the Team.
     */
    userId?: string;
  };
};

export type ListUserEventsResponse = {
  /**
   * Array of events generated by the User.
   */
  events: Array<UserEvent>;
};

export type ListUserEventsError = unknown;

export type GetSecretsData = {
  query?: {
    /**
     * Filter out secrets based on comma separated secret ids.
     */
    id?: string;
    /**
     * Filter out secrets that belong to a project.
     */
    projectId?: string;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetSecretsResponse = {
  pagination: Pagination;
  secrets: Array<{
    /**
     * The date when the secret was created.
     */
    created: string;
    /**
     * Timestamp for when the secret was created.
     */
    createdAt?: number;
    /**
     * Indicates whether the secret value can be decrypted after it has been created.
     */
    decryptable?: boolean;
    /**
     * The name of the secret.
     */
    name: string;
    /**
     * The unique identifier of the project which the secret belongs to.
     */
    projectId?: string;
    /**
     * The unique identifier of the team the secret was created for.
     */
    teamId?: string | null;
    /**
     * The unique identifier of the secret.
     */
    uid: string;
    /**
     * The unique identifier of the user who created the secret.
     */
    userId?: string;
    /**
     * The value of the secret.
     */
    value?: string;
  }>;
};

export type GetSecretsError = unknown;

export type GetSecretData = {
  path: {
    /**
     * The name or the unique identifier to which the secret belongs to.
     */
    idOrName: string;
  };
  query?: {
    /**
     * Whether to try to decrypt the value of the secret. Only works if `decryptable` has been set to `true` when the secret was created.
     */
    decrypt?: 'true' | 'false';
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetSecretResponse = {
  /**
   * The date when the secret was created.
   */
  created: string;
  /**
   * Timestamp for when the secret was created.
   */
  createdAt?: number;
  /**
   * Indicates whether the secret value can be decrypted after it has been created.
   */
  decryptable?: boolean;
  /**
   * The name of the secret.
   */
  name: string;
  /**
   * The unique identifier of the project which the secret belongs to.
   */
  projectId?: string;
  /**
   * The unique identifier of the team the secret was created for.
   */
  teamId?: string | null;
  /**
   * The unique identifier of the secret.
   */
  uid: string;
  /**
   * The unique identifier of the user who created the secret.
   */
  userId?: string;
  /**
   * The value of the secret.
   */
  value?: string;
};

export type GetSecretError = unknown;

export type CreateAuthTokenData = {
  body?:
    | {
        expiresAt?: number;
        name: string;
      }
    | {
        clientId?: string;
        expiresAt?: number;
        installationId?: string;
        name: string;
        type: 'oauth2-token';
      };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CreateAuthTokenResponse = {
  /**
   * The authentication token's actual value. This token is only provided in this response, and can never be retrieved again in the future. Be sure to save it somewhere safe!
   */
  bearerToken: string;
  token: AuthToken;
};

export type CreateAuthTokenError = unknown;

export type DeleteAuthTokenData = {
  path: {
    /**
     * The identifier of the token to invalidate. The special value \"current\" may be supplied, which invalidates the token that the HTTP request was authenticated with.
     */
    tokenId: string;
  };
};

export type DeleteAuthTokenResponse = {
  /**
   * The unique identifier of the token that was deleted.
   */
  tokenId: string;
};

export type DeleteAuthTokenError = unknown;

export type ListAliasesData = {
  query?: {
    /**
     * Get only aliases of the given domain name
     */
    domain?: unknown[] | string;
    /**
     * Get only aliases created after the provided timestamp
     */
    from?: number;
    /**
     * Maximum number of aliases to list from a request
     */
    limit?: number;
    /**
     * Filter aliases from the given `projectId`
     */
    projectId?: string;
    /**
     * Get aliases that would be rolled back for the given deployment
     */
    rollbackDeploymentId?: string;
    /**
     * Get aliases created after this JavaScript timestamp
     */
    since?: number;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    /**
     * Get aliases created before this JavaScript timestamp
     */
    until?: number;
  };
};

export type ListAliasesResponse = {
  aliases: Array<{
    /**
     * The alias name, it could be a `.vercel.app` subdomain or a custom domain
     */
    alias: string;
    /**
     * The date when the alias was created
     */
    created: string;
    /**
     * The date when the alias was created in milliseconds since the UNIX epoch
     */
    createdAt?: number;
    /**
     * Information of the user who created the alias
     */
    creator?: {
      /**
       * Email of the user who created the alias
       */
      email: string;
      /**
       * ID of the user who created the alias
       */
      uid: string;
      /**
       * Username of the user who created the alias
       */
      username: string;
    };
    /**
     * The date when the alias was deleted in milliseconds since the UNIX epoch
     */
    deletedAt?: number;
    /**
     * A map with the deployment ID, URL and metadata
     */
    deployment?: {
      /**
       * The deployment unique identifier
       */
      id: string;
      /**
       * The deployment metadata
       */
      meta?: string;
      /**
       * The deployment unique URL
       */
      url: string;
    };
    /**
     * The deployment ID
     */
    deploymentId: string | null;
    /**
     * The unique identifier of the project
     */
    projectId: string | null;
    /**
     * Construct a type with a set of properties K of type T
     */
    protectionBypass?: {
      [key: string]: string;
    };
    /**
     * Target destination domain for redirect when the alias is a redirect
     */
    redirect?: string | null;
    /**
     * Status code to be used on redirect
     */
    redirectStatusCode?: (301 | 302 | 307 | 308) | null;
    /**
     * The unique identifier of the alias
     */
    uid: string;
    /**
     * The date when the alias was updated in milliseconds since the UNIX epoch
     */
    updatedAt?: number;
  }>;
  pagination: Pagination;
};

export type ListAliasesError = unknown;

export type GetAliasData = {
  path: {
    /**
     * The alias or alias ID to be retrieved
     */
    idOrAlias: string;
  };
  query?: {
    /**
     * Get the alias only if it was created after the provided timestamp
     */
    from?: number;
    /**
     * Get the alias only if it is assigned to the provided project ID
     */
    projectId?: string;
    /**
     * Get the alias only if it was created after this JavaScript timestamp
     */
    since?: number;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    /**
     * Get the alias only if it was created before this JavaScript timestamp
     */
    until?: number;
  };
};

export type GetAliasResponse = {
  /**
   * The alias name, it could be a `.vercel.app` subdomain or a custom domain
   */
  alias: string;
  /**
   * The date when the alias was created
   */
  created: string;
  /**
   * The date when the alias was created in milliseconds since the UNIX epoch
   */
  createdAt?: number;
  /**
   * Information of the user who created the alias
   */
  creator?: {
    /**
     * Email of the user who created the alias
     */
    email: string;
    /**
     * ID of the user who created the alias
     */
    uid: string;
    /**
     * Username of the user who created the alias
     */
    username: string;
  };
  /**
   * The date when the alias was deleted in milliseconds since the UNIX epoch
   */
  deletedAt?: number;
  /**
   * A map with the deployment ID, URL and metadata
   */
  deployment?: {
    /**
     * The deployment unique identifier
     */
    id: string;
    /**
     * The deployment metadata
     */
    meta?: string;
    /**
     * The deployment unique URL
     */
    url: string;
  };
  /**
   * The deployment ID
   */
  deploymentId: string | null;
  /**
   * The unique identifier of the project
   */
  projectId: string | null;
  /**
   * Construct a type with a set of properties K of type T
   */
  protectionBypass?: {
    [key: string]: string;
  };
  /**
   * Target destination domain for redirect when the alias is a redirect
   */
  redirect?: string | null;
  /**
   * Status code to be used on redirect
   */
  redirectStatusCode?: (301 | 302 | 307 | 308) | null;
  /**
   * The unique identifier of the alias
   */
  uid: string;
  /**
   * The date when the alias was updated in milliseconds since the UNIX epoch
   */
  updatedAt?: number;
};

export type GetAliasError = unknown;

export type BuyDomainData = {
  body?: {
    /**
     * The price you expect to be charged for the purchase.
     */
    expectedPrice?: number;
    /**
     * The domain name to purchase.
     */
    name: string;
    /**
     * Indicates whether the domain should be automatically renewed.
     */
    renew?: boolean;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type BuyDomainResponse = {
  domain: {
    created: number;
    ns: Array<string>;
    pending: boolean;
    uid: string;
    verified: boolean;
  };
};

export type BuyDomainError = unknown;

export type CheckDomainPriceData = {
  query: {
    /**
     * The name of the domain for which the price needs to be checked.
     */
    name: string;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    /**
     * In which status of the domain the price needs to be checked.
     */
    type?: 'new' | 'renewal';
  };
};

export type CheckDomainPriceResponse = {
  /**
   * The number of years the domain could be held before paying again.
   */
  period: number;
  /**
   * The domain price in USD.
   */
  price: number;
};

export type CheckDomainPriceError = unknown;

export type CheckDomainStatusData = {
  query: {
    /**
     * The name of the domain for which we would like to check the status.
     */
    name: string;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CheckDomainStatusResponse = {
  available: boolean;
};

export type CheckDomainStatusError = unknown;

export type GetRecordsData = {
  path: {
    domain: string;
  };
  query?: {
    /**
     * Maximum number of records to list from a request.
     */
    limit?: string;
    /**
     * Get records created after this JavaScript timestamp.
     */
    since?: string;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    /**
     * Get records created before this JavaScript timestamp.
     */
    until?: string;
  };
};

export type GetRecordsResponse =
  | string
  | {
      records: Array<{
        created: number | null;
        createdAt: number | null;
        creator: string;
        id: string;
        mxPriority?: number;
        name: string;
        priority?: number;
        slug: string;
        type: 'A' | 'AAAA' | 'ALIAS' | 'CAA' | 'CNAME' | 'MX' | 'SRV' | 'TXT' | 'NS';
        updated: number | null;
        updatedAt: number | null;
        value: string;
      }>;
    }
  | {
      pagination: Pagination;
      records: Array<{
        created: number | null;
        createdAt: number | null;
        creator: string;
        id: string;
        mxPriority?: number;
        name: string;
        priority?: number;
        slug: string;
        type: 'A' | 'AAAA' | 'ALIAS' | 'CAA' | 'CNAME' | 'MX' | 'SRV' | 'TXT' | 'NS';
        updated: number | null;
        updatedAt: number | null;
        value: string;
      }>;
    };

export type GetRecordsError = unknown;

export type GetDomainsData = {
  query?: {
    /**
     * Maximum number of domains to list from a request.
     */
    limit?: number;
    /**
     * Get domains created after this JavaScript timestamp.
     */
    since?: number;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    /**
     * Get domains created before this JavaScript timestamp.
     */
    until?: number;
  };
};

export type GetDomainsResponse = {
  domains: Array<{
    /**
     * If it was purchased through Vercel, the timestamp in milliseconds when it was purchased.
     */
    boughtAt: number | null;
    /**
     * Timestamp in milliseconds when the domain was created in the registry.
     */
    createdAt: number;
    /**
     * An object containing information of the domain creator, including the user's id, username, and email.
     */
    creator: {
      customerId?: string | null;
      email: string;
      id: string;
      isDomainReseller?: boolean;
      username: string;
    };
    /**
     * A list of custom nameservers for the domain to point to. Only applies to domains purchased with Vercel.
     */
    customNameservers?: Array<string>;
    /**
     * Timestamp in milliseconds at which the domain is set to expire. `null` if not bought with Vercel.
     */
    expiresAt: number | null;
    /**
     * The unique identifier of the domain.
     */
    id: string;
    /**
     * A list of the intended nameservers for the domain to point to Vercel DNS.
     */
    intendedNameservers: Array<string>;
    /**
     * The domain name.
     */
    name: string;
    /**
     * A list of the current nameservers of the domain.
     */
    nameservers: Array<string>;
    /**
     * Timestamp in milliseconds at which the domain was ordered.
     */
    orderedAt?: number;
    /**
     * Indicates whether the domain is set to automatically renew.
     */
    renew?: boolean;
    /**
     * The type of service the domain is handled by. `external` if the DNS is externally handled, `zeit.world` if handled with Vercel, or `na` if the service is not available.
     */
    serviceType: 'zeit.world' | 'external' | 'na';
    /**
     * If transferred into Vercel, timestamp in milliseconds when the domain transfer was initiated.
     */
    transferStartedAt?: number;
    /**
     * Timestamp in milliseconds at which the domain was successfully transferred into Vercel. `null` if the transfer is still processing or was never transferred in.
     */
    transferredAt?: number | null;
    /**
     * If the domain has the ownership verified.
     */
    verified: boolean;
  }>;
  pagination: Pagination;
};

export type GetDomainsError = unknown;

export type CreateOrTransferDomainData = {
  body?: (
    | {
        /**
         * The domain operation to perform.
         */
        method: string;
        /**
         * The domain name you want to add.
         */
        name: string;
        /**
         * The move-in token from Move Requested email.
         */
        token?: string;
      }
    | {
        /**
         * The authorization code assigned to the domain.
         */
        authCode?: string;
        /**
         * The price you expect to be charged for the required 1 year renewal.
         */
        expectedPrice?: number;
        /**
         * The domain operation to perform.
         */
        method: string;
        /**
         * The domain name you want to add.
         */
        name: string;
      }
    | {
        /**
         * Whether the domain has the Vercel Edge Network enabled or not.
         */
        cdnEnabled?: boolean;
        /**
         * The domain operation to perform.
         */
        method?: string;
        /**
         * The domain name you want to add.
         */
        name: string;
        zone?: boolean;
      }
  ) & {
    /**
     * The domain operation to perform. It can be either `add` or `transfer-in`.
     */
    method?: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CreateOrTransferDomainResponse = {
  domain: {
    /**
     * If it was purchased through Vercel, the timestamp in milliseconds when it was purchased.
     */
    boughtAt: number | null;
    /**
     * Timestamp in milliseconds when the domain was created in the registry.
     */
    createdAt: number;
    /**
     * An object containing information of the domain creator, including the user's id, username, and email.
     */
    creator: {
      customerId?: string | null;
      email: string;
      id: string;
      isDomainReseller?: boolean;
      username: string;
    };
    /**
     * A list of custom nameservers for the domain to point to. Only applies to domains purchased with Vercel.
     */
    customNameservers?: Array<string>;
    /**
     * Timestamp in milliseconds at which the domain is set to expire. `null` if not bought with Vercel.
     */
    expiresAt: number | null;
    /**
     * The unique identifier of the domain.
     */
    id: string;
    /**
     * A list of the intended nameservers for the domain to point to Vercel DNS.
     */
    intendedNameservers: Array<string>;
    /**
     * The domain name.
     */
    name: string;
    /**
     * A list of the current nameservers of the domain.
     */
    nameservers: Array<string>;
    /**
     * Timestamp in milliseconds at which the domain was ordered.
     */
    orderedAt?: number;
    /**
     * Indicates whether the domain is set to automatically renew.
     */
    renew?: boolean;
    /**
     * The type of service the domain is handled by. `external` if the DNS is externally handled, `zeit.world` if handled with Vercel, or `na` if the service is not available.
     */
    serviceType: 'zeit.world' | 'external' | 'na';
    /**
     * If transferred into Vercel, timestamp in milliseconds when the domain transfer was initiated.
     */
    transferStartedAt?: number;
    /**
     * Timestamp in milliseconds at which the domain was successfully transferred into Vercel. `null` if the transfer is still processing or was never transferred in.
     */
    transferredAt?: number | null;
    /**
     * If the domain has the ownership verified.
     */
    verified: boolean;
  };
};

export type CreateOrTransferDomainError = unknown;

export type GetDomainData = {
  path: {
    /**
     * The name of the domain.
     */
    domain: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetDomainResponse = {
  domain: {
    /**
     * If it was purchased through Vercel, the timestamp in milliseconds when it was purchased.
     */
    boughtAt: number | null;
    /**
     * Timestamp in milliseconds when the domain was created in the registry.
     */
    createdAt: number;
    /**
     * An object containing information of the domain creator, including the user's id, username, and email.
     */
    creator: {
      customerId?: string | null;
      email: string;
      id: string;
      isDomainReseller?: boolean;
      username: string;
    };
    /**
     * A list of custom nameservers for the domain to point to. Only applies to domains purchased with Vercel.
     */
    customNameservers?: Array<string>;
    /**
     * Timestamp in milliseconds at which the domain is set to expire. `null` if not bought with Vercel.
     */
    expiresAt: number | null;
    /**
     * The unique identifier of the domain.
     */
    id: string;
    /**
     * A list of the intended nameservers for the domain to point to Vercel DNS.
     */
    intendedNameservers: Array<string>;
    /**
     * The domain name.
     */
    name: string;
    /**
     * A list of the current nameservers of the domain.
     */
    nameservers: Array<string>;
    /**
     * Timestamp in milliseconds at which the domain was ordered.
     */
    orderedAt?: number;
    /**
     * Indicates whether the domain is set to automatically renew.
     */
    renew?: boolean;
    /**
     * The type of service the domain is handled by. `external` if the DNS is externally handled, `zeit.world` if handled with Vercel, or `na` if the service is not available.
     */
    serviceType: 'zeit.world' | 'external' | 'na';
    suffix: boolean;
    /**
     * If transferred into Vercel, timestamp in milliseconds when the domain transfer was initiated.
     */
    transferStartedAt?: number;
    /**
     * Timestamp in milliseconds at which the domain was successfully transferred into Vercel. `null` if the transfer is still processing or was never transferred in.
     */
    transferredAt?: number | null;
    /**
     * If the domain has the ownership verified.
     */
    verified: boolean;
  };
};

export type GetDomainError = unknown;

export type ListAuthTokensResponse = {
  pagination: Pagination;
  testingToken?: AuthToken;
  tokens: Array<AuthToken>;
};

export type ListAuthTokensError = unknown;

export type GetAuthTokenData = {
  path: {
    /**
     * The identifier of the token to retrieve. The special value \"current\" may be supplied, which returns the metadata for the token that the current HTTP request is authenticated with.
     */
    tokenId: string;
  };
};

export type GetAuthTokenResponse = {
  token: AuthToken;
};

export type GetAuthTokenError = unknown;

export type GetDeploymentsData = {
  query?: {
    /**
     * Name of the deployment.
     */
    app?: string;
    /**
     * Gets the deployment created after this Date timestamp. (default: current time)
     */
    from?: number;
    /**
     * Maximum number of deployments to list from a request.
     */
    limit?: number;
    /**
     * Filter deployments from the given `projectId`.
     */
    projectId?: string;
    /**
     * Filter deployments based on their rollback candidacy
     */
    rollbackCandidate?: boolean;
    /**
     * Get Deployments created after this JavaScript timestamp.
     */
    since?: number;
    /**
     * Filter deployments based on their state (`BUILDING`, `ERROR`, `INITIALIZING`, `QUEUED`, `READY`, `CANCELED`)
     */
    state?: string;
    /**
     * Filter deployments based on the environment.
     */
    target?: 'production' | 'preview';
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    /**
     * Gets the deployment created before this Date timestamp. (default: current time)
     */
    to?: number;
    /**
     * Get Deployments created before this JavaScript timestamp.
     */
    until?: number;
    /**
     * Filter out deployments based on users who have created the deployment.
     */
    users?: string;
  };
};

export type GetDeploymentsResponse = {
  deployments: Array<{
    aliasAssigned?: (number | boolean) | null;
    /**
     * An error object in case aliasing of the deployment failed.
     */
    aliasError?: {
      code: string;
      message: string;
    } | null;
    /**
     * Timestamp of when the deployment started building at.
     */
    buildingAt?: number;
    /**
     * Conclusion for checks
     */
    checksConclusion?: 'succeeded' | 'failed' | 'skipped' | 'canceled';
    /**
     * State of all registered checks
     */
    checksState?: 'registered' | 'running' | 'completed';
    /**
     * The ID of Vercel Connect configuration used for this deployment
     */
    connectConfigurationId?: string;
    /**
     * Timestamp of when the deployment got created.
     */
    created: number;
    /**
     * Timestamp of when the deployment got created.
     */
    createdAt?: number;
    /**
     * Metadata information of the user who created the deployment.
     */
    creator: {
      /**
       * The email address of the user.
       */
      email?: string;
      /**
       * The GitHub login of the user.
       */
      githubLogin?: string;
      /**
       * The GitLab login of the user.
       */
      gitlabLogin?: string;
      /**
       * The unique identifier of the user.
       */
      uid: string;
      /**
       * The username of the user.
       */
      username?: string;
    };
    /**
     * Vercel URL to inspect the deployment.
     */
    inspectorUrl: string | null;
    /**
     * Deployment can be used for instant rollback
     */
    isRollbackCandidate?: boolean | null;
    /**
     * An object containing the deployment's metadata
     */
    meta?: {
      [key: string]: string;
    };
    /**
     * The name of the deployment.
     */
    name: string;
    /**
     * The project settings which was used for this deployment
     */
    projectSettings?: {
      buildCommand?: string | null;
      commandForIgnoringBuildStep?: string | null;
      createdAt?: number;
      devCommand?: string | null;
      framework?:
        | (
            | 'blitzjs'
            | 'nextjs'
            | 'gatsby'
            | 'remix'
            | 'astro'
            | 'hexo'
            | 'eleventy'
            | 'docusaurus-2'
            | 'docusaurus'
            | 'preact'
            | 'solidstart'
            | 'dojo'
            | 'ember'
            | 'vue'
            | 'scully'
            | 'ionic-angular'
            | 'angular'
            | 'polymer'
            | 'svelte'
            | 'sveltekit'
            | 'sveltekit-1'
            | 'ionic-react'
            | 'create-react-app'
            | 'gridsome'
            | 'umijs'
            | 'sapper'
            | 'saber'
            | 'stencil'
            | 'nuxtjs'
            | 'redwoodjs'
            | 'hugo'
            | 'jekyll'
            | 'brunch'
            | 'middleman'
            | 'zola'
            | 'hydrogen'
            | 'vite'
            | 'vitepress'
            | 'vuepress'
            | 'parcel'
            | 'sanity'
          )
        | null;
      gitForkProtection?: boolean;
      gitLFS?: boolean;
      installCommand?: string | null;
      nodeVersion?: '18.x' | '16.x' | '14.x' | '12.x' | '10.x';
      outputDirectory?: string | null;
      publicSource?: boolean | null;
      rootDirectory?: string | null;
      serverlessFunctionRegion?: string | null;
      skipGitConnectDuringLink?: boolean;
      sourceFilesOutsideRootDirectory?: boolean;
    };
    /**
     * Timestamp of when the deployment got ready.
     */
    ready?: number;
    /**
     * The source of the deployment.
     */
    source?: 'cli' | 'git' | 'import' | 'import/repo' | 'clone/repo';
    /**
     * In which state is the deployment.
     */
    state?: 'BUILDING' | 'ERROR' | 'INITIALIZING' | 'QUEUED' | 'READY' | 'CANCELED';
    /**
     * On which environment has the deployment been deployed to.
     */
    target?: ('production' | 'staging') | null;
    /**
     * The type of the deployment.
     */
    type: 'LAMBDAS';
    /**
     * The unique identifier of the deployment.
     */
    uid: string;
    /**
     * The URL of the deployment.
     */
    url: string;
  }>;
  pagination: Pagination;
};

export type GetDeploymentsError = unknown;

export type ListDeploymentFilesData = {
  path: {
    /**
     * The unique deployment identifier
     */
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type ListDeploymentFilesResponse = Array<FileTree>;

export type ListDeploymentFilesError = unknown;

export type GetDeploymentFileContentsData = {
  path: {
    /**
     * The unique file identifier
     */
    fileId: string;
    /**
     * The unique deployment identifier
     */
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type DeleteDomainData = {
  path: {
    /**
     * The name of the domain.
     */
    domain: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type DeleteDomainResponse = {
  uid: string;
};

export type DeleteDomainError = unknown;

export type GetDomainConfigData = {
  path: {
    /**
     * The name of the domain.
     */
    domain: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetDomainConfigResponse = {
  /**
   * Which challenge types the domain can use for issuing certs.
   */
  acceptedChallenges?: Array<'dns-01' | 'http-01'>;
  /**
   * How we see the domain's configuration. - `CNAME`: Domain has a CNAME pointing to Vercel. - `A`: Domain's A record is resolving to Vercel. - `http`: Domain is resolving to Vercel but may be behind a Proxy. - `null`: Domain is not resolving to Vercel.
   */
  configuredBy?: ('CNAME' | 'A' | 'http') | null;
  /**
   * Whether or not the domain is configured AND we can automatically generate a TLS certificate.
   */
  misconfigured: boolean;
};

export type GetDomainConfigError = unknown;

export type IssueCertData = {
  body?: {
    /**
     * The common names the cert should be issued for
     */
    cns?: Array<string>;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type IssueCertResponse = {
  autoRenew: boolean;
  cns: Array<string>;
  createdAt: number;
  expiresAt: number;
  id: string;
};

export type IssueCertError = unknown;

export type UploadCertData = {
  body?: {
    /**
     * The certificate authority
     */
    ca: string;
    /**
     * The certificate
     */
    cert: string;
    /**
     * The certificate key
     */
    key: string;
    /**
     * Skip validation of the certificate
     */
    skipValidation?: boolean;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type UploadCertResponse = {
  autoRenew: boolean;
  cns: Array<string>;
  createdAt: number;
  expiresAt: number;
  id: string;
};

export type UploadCertError = unknown;

export type RemoveCertData = {
  path: {
    /**
     * The cert id to remove
     */
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type RemoveCertResponse = {
  [key: string]: unknown;
};

export type RemoveCertError = unknown;

export type GetCertByIdData = {
  path: {
    /**
     * The cert id
     */
    id: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetCertByIdResponse = {
  autoRenew: boolean;
  cns: Array<string>;
  createdAt: number;
  expiresAt: number;
  id: string;
};

export type GetCertByIdError = unknown;

export type ArtifactQueryData = {
  body?: {
    /**
     * artifact hashes
     */
    hashes: Array<string>;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type RecordEventsData = {
  body?: Array<{
    /**
     * The time taken to generate the artifact. This should be sent as a body parameter on `HIT` events.
     */
    duration?: number;
    /**
     * One of `HIT` or `MISS`. `HIT` specifies that a cached artifact for `hash` was found in the cache. `MISS` specifies that a cached artifact with `hash` was not found.
     */
    event: 'HIT' | 'MISS';
    /**
     * The artifact hash
     */
    hash: string;
    /**
     * A UUID (universally unique identifer) for the session that generated this event.
     */
    sessionId: string;
    /**
     * One of `LOCAL` or `REMOTE`. `LOCAL` specifies that the cache event was from the user's filesystem cache. `REMOTE` specifies that the cache event is from a remote cache.
     */
    source: 'LOCAL' | 'REMOTE';
  }>;
  headers?: {
    /**
     * The continuous integration or delivery environment where this artifact is downloaded.
     */
    'x-artifact-client-ci'?: string;
    /**
     * 1 if the client is an interactive shell. Otherwise 0
     */
    'x-artifact-client-interactive'?: number;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type RecordEventsResponse = unknown;

export type RecordEventsError = unknown;

export type StatusData = {
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type DownloadArtifactData = {
  headers?: {
    /**
     * The continuous integration or delivery environment where this artifact is downloaded.
     */
    'x-artifact-client-ci'?: string;
    /**
     * 1 if the client is an interactive shell. Otherwise 0
     */
    'x-artifact-client-interactive'?: number;
  };
  path: {
    /**
     * The artifact hash
     */
    hash: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type ArtifactExistsData = {
  path: {
    /**
     * The artifact hash
     */
    hash: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type UploadArtifactData = {
  body?: unknown;
  headers: {
    /**
     * The artifact size in bytes
     */
    'Content-Length': number;
    /**
     * The continuous integration or delivery environment where this artifact was generated.
     */
    'x-artifact-client-ci'?: string;
    /**
     * 1 if the client is an interactive shell. Otherwise 0
     */
    'x-artifact-client-interactive'?: number;
    /**
     * The time taken to generate the uploaded artifact in milliseconds.
     */
    'x-artifact-duration'?: number;
    /**
     * The base64 encoded tag for this artifact. The value is sent back to clients when the artifact is downloaded as the header `x-artifact-tag`
     */
    'x-artifact-tag'?: string;
  };
  path: {
    /**
     * The artifact hash
     */
    hash: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetProjectsData = {
  query?: {
    /**
     * Filter results by connected Edge Config ID
     */
    edgeConfigId?: string;
    /**
     * Filter results by connected Edge Config Token ID
     */
    edgeConfigTokenId?: string;
    /**
     * Filter results by excluding those projects that belong to a repo
     */
    excludeRepos?: string;
    /**
     * Query only projects updated after the given timestamp
     */
    from?: string;
    /**
     * Specifies whether PRs from Git forks should require a team member's authorization before it can be deployed
     */
    gitForkProtection?: '1' | '0';
    /**
     * Limit the number of projects returned
     */
    limit?: string;
    /**
     * Filter results by repo. Also used for project count
     */
    repo?: string;
    /**
     * Filter results by Repository ID.
     */
    repoId?: string;
    /**
     * Filter results by Repository URL.
     */
    repoUrl?: string;
    /**
     * Search projects by the name field
     */
    search?: string;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetProjectsResponse = {
  pagination: Pagination;
  projects: Array<{
    accountId: string;
    analytics?: {
      canceledAt: number | null;
      disabledAt: number;
      enabledAt: number;
      id: string;
      paidAt?: number;
      sampleRatePercent?: number | null;
      spendLimitInDollars?: number | null;
    };
    autoExposeSystemEnvs?: boolean;
    buildCommand?: string | null;
    commandForIgnoringBuildStep?: string | null;
    connectBuildsEnabled?: boolean;
    connectConfigurationId?: string | null;
    createdAt?: number;
    devCommand?: string | null;
    directoryListing: boolean;
    enablePreviewFeedback?: boolean | null;
    env?: Array<{
      configurationId?: string | null;
      createdAt?: number;
      createdBy?: string | null;
      /**
       * Whether `value` is decrypted.
       */
      decrypted?: boolean;
      edgeConfigId?: string | null;
      edgeConfigTokenId?: string | null;
      gitBranch?: string;
      id?: string;
      key: string;
      target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
      type: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
      updatedAt?: number;
      updatedBy?: string | null;
      value: string;
    }>;
    framework?:
      | (
          | 'blitzjs'
          | 'nextjs'
          | 'gatsby'
          | 'remix'
          | 'astro'
          | 'hexo'
          | 'eleventy'
          | 'docusaurus-2'
          | 'docusaurus'
          | 'preact'
          | 'solidstart'
          | 'dojo'
          | 'ember'
          | 'vue'
          | 'scully'
          | 'ionic-angular'
          | 'angular'
          | 'polymer'
          | 'svelte'
          | 'sveltekit'
          | 'sveltekit-1'
          | 'ionic-react'
          | 'create-react-app'
          | 'gridsome'
          | 'umijs'
          | 'sapper'
          | 'saber'
          | 'stencil'
          | 'nuxtjs'
          | 'redwoodjs'
          | 'hugo'
          | 'jekyll'
          | 'brunch'
          | 'middleman'
          | 'zola'
          | 'hydrogen'
          | 'vite'
          | 'vitepress'
          | 'vuepress'
          | 'parcel'
          | 'sanity'
        )
      | null;
    gitForkProtection?: boolean;
    gitLFS?: boolean;
    hasActiveBranches?: boolean;
    hasFloatingAliases?: boolean;
    id: string;
    installCommand?: string | null;
    lastRollbackTarget?: {
      fromDeploymentId: string;
      jobStatus: 'succeeded' | 'failed' | 'skipped' | 'pending' | 'in-progress';
      requestedAt: number;
      toDeploymentId: string;
    } | null;
    latestDeployments?: Array<{
      alias?: Array<string>;
      aliasAssigned?: (number | boolean) | null;
      aliasError?: {
        code: string;
        message: string;
      } | null;
      aliasFinal?: string | null;
      automaticAliases?: Array<string>;
      buildingAt?: number;
      builds?: Array<{
        dest?: string;
        src?: string;
        use: string;
      }>;
      checksConclusion?: 'succeeded' | 'failed' | 'skipped' | 'canceled';
      checksState?: 'registered' | 'running' | 'completed';
      connectConfigurationId?: string;
      createdAt: number;
      createdIn: string;
      creator: {
        email: string;
        githubLogin?: string;
        gitlabLogin?: string;
        uid: string;
        username: string;
      } | null;
      deploymentHostname: string;
      forced?: boolean;
      id: string;
      /**
       * Construct a type with a set of properties K of type T
       */
      meta?: {
        [key: string]: string;
      };
      monorepoManager?: string | null;
      name: string;
      plan: 'hobby' | 'enterprise' | 'pro' | 'oss';
      /**
       * Whether or not preview comments are enabled for the deployment
       */
      previewCommentsEnabled?: boolean;
      private: boolean;
      readyAt?: number;
      readyState: 'BUILDING' | 'ERROR' | 'INITIALIZING' | 'QUEUED' | 'READY' | 'CANCELED';
      requestedAt?: number;
      target?: string | null;
      teamId?: string | null;
      type: 'LAMBDAS';
      url: string;
      userId: string;
      withCache?: boolean;
    }>;
    link?:
      | {
          createdAt?: number;
          deployHooks: Array<{
            createdAt?: number;
            id: string;
            name: string;
            ref: string;
            url: string;
          }>;
          gitCredentialId?: string;
          org?: string;
          productionBranch?: string;
          repo?: string;
          repoId?: number;
          sourceless?: boolean;
          type?: 'github';
          updatedAt?: number;
        }
      | {
          createdAt?: number;
          deployHooks: Array<{
            createdAt?: number;
            id: string;
            name: string;
            ref: string;
            url: string;
          }>;
          gitCredentialId?: string;
          productionBranch?: string;
          projectId?: string;
          projectName?: string;
          projectNameWithNamespace?: string;
          projectNamespace?: string;
          projectUrl?: string;
          sourceless?: boolean;
          type?: 'gitlab';
          updatedAt?: number;
        }
      | {
          createdAt?: number;
          deployHooks: Array<{
            createdAt?: number;
            id: string;
            name: string;
            ref: string;
            url: string;
          }>;
          gitCredentialId?: string;
          name?: string;
          owner?: string;
          productionBranch?: string;
          slug?: string;
          sourceless?: boolean;
          type?: 'bitbucket';
          updatedAt?: number;
          uuid?: string;
          workspaceUuid?: string;
        };
    live?: boolean;
    name: string;
    nodeVersion: '18.x' | '16.x' | '14.x' | '12.x' | '10.x';
    outputDirectory?: string | null;
    passwordProtection?: {
      deploymentType: 'preview' | 'all';
    } | null;
    permissions?: {
      Monitoring?: Array<ACLAction>;
      aliasGlobal?: Array<ACLAction>;
      aliasProject?: Array<ACLAction>;
      aliasProtectionBypass?: Array<ACLAction>;
      analytics?: Array<ACLAction>;
      analyticsSampling?: Array<ACLAction>;
      analyticsUsage?: Array<ACLAction>;
      auditLog?: Array<ACLAction>;
      billingAddress?: Array<ACLAction>;
      billingInformation?: Array<ACLAction>;
      billingInvoice?: Array<ACLAction>;
      billingInvoiceEmailRecipient?: Array<ACLAction>;
      billingInvoiceLanguage?: Array<ACLAction>;
      billingPlan?: Array<ACLAction>;
      billingPurchaseOrder?: Array<ACLAction>;
      billingTaxId?: Array<ACLAction>;
      blob?: Array<ACLAction>;
      cacheArtifact?: Array<ACLAction>;
      cacheArtifactUsageEvent?: Array<ACLAction>;
      concurrentBuilds?: Array<ACLAction>;
      connect?: Array<ACLAction>;
      connectConfiguration?: Array<ACLAction>;
      connectConfigurationLink?: Array<ACLAction>;
      deployment?: Array<ACLAction>;
      deploymentCheck?: Array<ACLAction>;
      deploymentCheckPreview?: Array<ACLAction>;
      deploymentCheckReRunFromProductionBranch?: Array<ACLAction>;
      deploymentPreview?: Array<ACLAction>;
      deploymentPrivate?: Array<ACLAction>;
      deploymentProductionGit?: Array<ACLAction>;
      deploymentRollback?: Array<ACLAction>;
      domain?: Array<ACLAction>;
      domainAcceptDelegation?: Array<ACLAction>;
      domainAuthCodes?: Array<ACLAction>;
      domainCertificate?: Array<ACLAction>;
      domainCheckConfig?: Array<ACLAction>;
      domainMove?: Array<ACLAction>;
      domainPurchase?: Array<ACLAction>;
      domainRecord?: Array<ACLAction>;
      domainTransferIn?: Array<ACLAction>;
      edgeConfig?: Array<ACLAction>;
      edgeConfigItem?: Array<ACLAction>;
      edgeConfigToken?: Array<ACLAction>;
      endpointVerification?: Array<ACLAction>;
      event?: Array<ACLAction>;
      fileUpload?: Array<ACLAction>;
      gitRepository?: Array<ACLAction>;
      integration?: Array<ACLAction>;
      integrationConfiguration?: Array<ACLAction>;
      integrationConfigurationProjects?: Array<ACLAction>;
      integrationConfigurationTransfer?: Array<ACLAction>;
      integrationVercelConfigurationOverride?: Array<ACLAction>;
      ipBlocking?: Array<ACLAction>;
      job?: Array<ACLAction>;
      logDrain?: Array<ACLAction>;
      monitoringChart?: Array<ACLAction>;
      monitoringQuery?: Array<ACLAction>;
      notificationDomainConfiguration?: Array<ACLAction>;
      notificationDomainExpire?: Array<ACLAction>;
      notificationDomainMoved?: Array<ACLAction>;
      notificationDomainPurchase?: Array<ACLAction>;
      notificationDomainRenewal?: Array<ACLAction>;
      notificationDomainTransfer?: Array<ACLAction>;
      notificationDomainUnverified?: Array<ACLAction>;
      notificationPaymentFailed?: Array<ACLAction>;
      notificationSpendCap?: Array<ACLAction>;
      notificationUsageAlert?: Array<ACLAction>;
      openTelemetryEndpoint?: Array<ACLAction>;
      passwordProtection?: Array<ACLAction>;
      paymentMethod?: Array<ACLAction>;
      permissions?: Array<ACLAction>;
      postgres?: Array<ACLAction>;
      previewDeploymentSuffix?: Array<ACLAction>;
      proTrialOnboarding?: Array<ACLAction>;
      project?: Array<ACLAction>;
      projectDeploymentHook?: Array<ACLAction>;
      projectDomain?: Array<ACLAction>;
      projectDomainMove?: Array<ACLAction>;
      projectEnvVars?: Array<ACLAction>;
      projectEnvVarsProduction?: Array<ACLAction>;
      projectEnvVarsUnownedByIntegration?: Array<ACLAction>;
      projectIntegrationConfiguration?: Array<ACLAction>;
      projectLink?: Array<ACLAction>;
      projectMember?: Array<ACLAction>;
      projectProductionBranch?: Array<ACLAction>;
      projectProtectionBypass?: Array<ACLAction>;
      projectTransfer?: Array<ACLAction>;
      rateLimit?: Array<ACLAction>;
      redis?: Array<ACLAction>;
      remoteCaching?: Array<ACLAction>;
      samlConfig?: Array<ACLAction>;
      secret?: Array<ACLAction>;
      sensitiveEnvironmentVariablePolicy?: Array<ACLAction>;
      sharedEnvVars?: Array<ACLAction>;
      sharedEnvVarsProduction?: Array<ACLAction>;
      spendCapConfiguration?: Array<ACLAction>;
      spendCapState?: Array<ACLAction>;
      supportCase?: Array<ACLAction>;
      supportCaseComment?: Array<ACLAction>;
      team?: Array<ACLAction>;
      teamAccessRequest?: Array<ACLAction>;
      teamFellowMembership?: Array<ACLAction>;
      teamInvite?: Array<ACLAction>;
      teamInviteCode?: Array<ACLAction>;
      teamJoin?: Array<ACLAction>;
      teamOwnMembership?: Array<ACLAction>;
      teamOwnMembershipDisconnectSAML?: Array<ACLAction>;
      token?: Array<ACLAction>;
      usage?: Array<ACLAction>;
      user?: Array<ACLAction>;
      userConnection?: Array<ACLAction>;
      webAnalytics?: Array<ACLAction>;
      webAnalyticsPlan?: Array<ACLAction>;
      webhook?: Array<ACLAction>;
      'webhook-event'?: Array<ACLAction>;
    };
    /**
     * Construct a type with a set of properties K of type T
     */
    protectionBypass?: {
      [key: string]: string;
    };
    publicSource?: boolean | null;
    rootDirectory?: string | null;
    serverlessFunctionRegion?: string | null;
    skipGitConnectDuringLink?: boolean;
    sourceFilesOutsideRootDirectory?: boolean;
    ssoProtection?: {
      deploymentType: 'preview' | 'all';
    } | null;
    /**
     * An object containing the deployment's metadata
     */
    targets?: {
      [key: string]: string;
    };
    transferCompletedAt?: number;
    transferStartedAt?: number;
    transferToAccountId?: string;
    transferredFromAccountId?: string;
    updatedAt?: number;
  }>;
};

export type GetProjectsError = unknown;

export type CreateProjectData = {
  body?: {
    /**
     * The build command for this project. When `null` is used this value will be automatically detected
     */
    buildCommand?: string | null;
    commandForIgnoringBuildStep?: string | null;
    /**
     * The dev command for this project. When `null` is used this value will be automatically detected
     */
    devCommand?: string | null;
    /**
     * Collection of ENV Variables the Project will use
     */
    environmentVariables?: Array<{
      /**
       * The git branch of the environment variable
       */
      gitBranch?: string;
      /**
       * Name of the ENV variable
       */
      key: string;
      /**
       * Deployment Target or Targets in which the ENV variable will be used
       */
      target:
        | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Productio'
        | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Previe'
        | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Developmen'
        | Array<
            | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Productio'
            | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Previe'
            | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Developmen'
          >;
      /**
       * Type of the ENV variable
       */
      type?: 'system' | 'secret' | 'encrypted' | 'plain';
      /**
       * Value for the ENV variable
       */
      value: string;
    }>;
    /**
     * The framework that is being used for this project. When `null` is used no framework is selected
     */
    framework?:
      | 'blitzjs'
      | 'nextjs'
      | 'gatsby'
      | 'remix'
      | 'astro'
      | 'hexo'
      | 'eleventy'
      | 'docusaurus-2'
      | 'docusaurus'
      | 'preact'
      | 'solidstart'
      | 'dojo'
      | 'ember'
      | 'vue'
      | 'scully'
      | 'ionic-angular'
      | 'angular'
      | 'polymer'
      | 'svelte'
      | 'sveltekit'
      | 'sveltekit-1'
      | 'ionic-react'
      | 'create-react-app'
      | 'gridsome'
      | 'umijs'
      | 'sapper'
      | 'saber'
      | 'stencil'
      | 'nuxtjs'
      | 'redwoodjs'
      | 'hugo'
      | 'jekyll'
      | 'brunch'
      | 'middleman'
      | 'zola'
      | 'hydrogen'
      | 'vite'
      | 'vitepress'
      | 'vuepress'
      | 'parcel'
      | 'sanity';
    /**
     * The Git Repository that will be connected to the project. When this is defined, any pushes to the specified connected Git Repository will be automatically deployed
     */
    gitRepository?: {
      /**
       * The name of the git repository. For example: \"vercel/next.js\"
       */
      repo: string;
      /**
       * The Git Provider of the repository
       */
      type: 'github' | 'gitlab' | 'bitbucket';
    };
    /**
     * The install command for this project. When `null` is used this value will be automatically detected
     */
    installCommand?: string | null;
    /**
     * The desired name for the project
     */
    name: string;
    /**
     * The output directory of the project. When `null` is used this value will be automatically detected
     */
    outputDirectory?: string | null;
    /**
     * Specifies whether the source code and logs of the deployments for this project should be public or not
     */
    publicSource?: boolean | null;
    /**
     * The name of a directory or relative path to the source code of your project. When `null` is used it will default to the project root
     */
    rootDirectory?: string | null;
    /**
     * The region to deploy Serverless Functions in this project
     */
    serverlessFunctionRegion?: string | null;
    /**
     * Opts-out of the message prompting a CLI user to connect a Git repository in `vercel link`.
     * @deprecated
     */
    skipGitConnectDuringLink?: boolean;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type CreateProjectResponse = {
  accountId: string;
  analytics?: {
    canceledAt: number | null;
    disabledAt: number;
    enabledAt: number;
    id: string;
    paidAt?: number;
    sampleRatePercent?: number | null;
    spendLimitInDollars?: number | null;
  };
  autoExposeSystemEnvs?: boolean;
  buildCommand?: string | null;
  commandForIgnoringBuildStep?: string | null;
  connectBuildsEnabled?: boolean;
  connectConfigurationId?: string | null;
  createdAt?: number;
  devCommand?: string | null;
  directoryListing: boolean;
  enablePreviewFeedback?: boolean | null;
  env?: Array<{
    configurationId?: string | null;
    createdAt?: number;
    createdBy?: string | null;
    /**
     * Whether `value` is decrypted.
     */
    decrypted?: boolean;
    edgeConfigId?: string | null;
    edgeConfigTokenId?: string | null;
    gitBranch?: string;
    id?: string;
    key: string;
    target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
    type: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
    updatedAt?: number;
    updatedBy?: string | null;
    value: string;
  }>;
  framework?:
    | (
        | 'blitzjs'
        | 'nextjs'
        | 'gatsby'
        | 'remix'
        | 'astro'
        | 'hexo'
        | 'eleventy'
        | 'docusaurus-2'
        | 'docusaurus'
        | 'preact'
        | 'solidstart'
        | 'dojo'
        | 'ember'
        | 'vue'
        | 'scully'
        | 'ionic-angular'
        | 'angular'
        | 'polymer'
        | 'svelte'
        | 'sveltekit'
        | 'sveltekit-1'
        | 'ionic-react'
        | 'create-react-app'
        | 'gridsome'
        | 'umijs'
        | 'sapper'
        | 'saber'
        | 'stencil'
        | 'nuxtjs'
        | 'redwoodjs'
        | 'hugo'
        | 'jekyll'
        | 'brunch'
        | 'middleman'
        | 'zola'
        | 'hydrogen'
        | 'vite'
        | 'vitepress'
        | 'vuepress'
        | 'parcel'
        | 'sanity'
      )
    | null;
  gitForkProtection?: boolean;
  gitLFS?: boolean;
  hasActiveBranches?: boolean;
  hasFloatingAliases?: boolean;
  id: string;
  installCommand?: string | null;
  lastRollbackTarget?: {
    fromDeploymentId: string;
    jobStatus: 'succeeded' | 'failed' | 'skipped' | 'pending' | 'in-progress';
    requestedAt: number;
    toDeploymentId: string;
  } | null;
  latestDeployments?: Array<{
    alias?: Array<string>;
    aliasAssigned?: (number | boolean) | null;
    aliasError?: {
      code: string;
      message: string;
    } | null;
    aliasFinal?: string | null;
    automaticAliases?: Array<string>;
    buildingAt?: number;
    builds?: Array<{
      dest?: string;
      src?: string;
      use: string;
    }>;
    checksConclusion?: 'succeeded' | 'failed' | 'skipped' | 'canceled';
    checksState?: 'registered' | 'running' | 'completed';
    connectConfigurationId?: string;
    createdAt: number;
    createdIn: string;
    creator: {
      email: string;
      githubLogin?: string;
      gitlabLogin?: string;
      uid: string;
      username: string;
    } | null;
    deploymentHostname: string;
    forced?: boolean;
    id: string;
    /**
     * Construct a type with a set of properties K of type T
     */
    meta?: {
      [key: string]: string;
    };
    monorepoManager?: string | null;
    name: string;
    plan: 'hobby' | 'enterprise' | 'pro' | 'oss';
    /**
     * Whether or not preview comments are enabled for the deployment
     */
    previewCommentsEnabled?: boolean;
    private: boolean;
    readyAt?: number;
    readyState: 'BUILDING' | 'ERROR' | 'INITIALIZING' | 'QUEUED' | 'READY' | 'CANCELED';
    requestedAt?: number;
    target?: string | null;
    teamId?: string | null;
    type: 'LAMBDAS';
    url: string;
    userId: string;
    withCache?: boolean;
  }>;
  link?:
    | {
        createdAt?: number;
        deployHooks: Array<{
          createdAt?: number;
          id: string;
          name: string;
          ref: string;
          url: string;
        }>;
        gitCredentialId?: string;
        org?: string;
        productionBranch?: string;
        repo?: string;
        repoId?: number;
        sourceless?: boolean;
        type?: 'github';
        updatedAt?: number;
      }
    | {
        createdAt?: number;
        deployHooks: Array<{
          createdAt?: number;
          id: string;
          name: string;
          ref: string;
          url: string;
        }>;
        gitCredentialId?: string;
        productionBranch?: string;
        projectId?: string;
        projectName?: string;
        projectNameWithNamespace?: string;
        projectNamespace?: string;
        projectUrl?: string;
        sourceless?: boolean;
        type?: 'gitlab';
        updatedAt?: number;
      }
    | {
        createdAt?: number;
        deployHooks: Array<{
          createdAt?: number;
          id: string;
          name: string;
          ref: string;
          url: string;
        }>;
        gitCredentialId?: string;
        name?: string;
        owner?: string;
        productionBranch?: string;
        slug?: string;
        sourceless?: boolean;
        type?: 'bitbucket';
        updatedAt?: number;
        uuid?: string;
        workspaceUuid?: string;
      };
  live?: boolean;
  name: string;
  nodeVersion: '18.x' | '16.x' | '14.x' | '12.x' | '10.x';
  outputDirectory?: string | null;
  passwordProtection?: {
    deploymentType: 'preview' | 'all';
  } | null;
  permissions?: {
    Monitoring?: Array<ACLAction>;
    aliasGlobal?: Array<ACLAction>;
    aliasProject?: Array<ACLAction>;
    aliasProtectionBypass?: Array<ACLAction>;
    analytics?: Array<ACLAction>;
    analyticsSampling?: Array<ACLAction>;
    analyticsUsage?: Array<ACLAction>;
    auditLog?: Array<ACLAction>;
    billingAddress?: Array<ACLAction>;
    billingInformation?: Array<ACLAction>;
    billingInvoice?: Array<ACLAction>;
    billingInvoiceEmailRecipient?: Array<ACLAction>;
    billingInvoiceLanguage?: Array<ACLAction>;
    billingPlan?: Array<ACLAction>;
    billingPurchaseOrder?: Array<ACLAction>;
    billingTaxId?: Array<ACLAction>;
    blob?: Array<ACLAction>;
    cacheArtifact?: Array<ACLAction>;
    cacheArtifactUsageEvent?: Array<ACLAction>;
    concurrentBuilds?: Array<ACLAction>;
    connect?: Array<ACLAction>;
    connectConfiguration?: Array<ACLAction>;
    connectConfigurationLink?: Array<ACLAction>;
    deployment?: Array<ACLAction>;
    deploymentCheck?: Array<ACLAction>;
    deploymentCheckPreview?: Array<ACLAction>;
    deploymentCheckReRunFromProductionBranch?: Array<ACLAction>;
    deploymentPreview?: Array<ACLAction>;
    deploymentPrivate?: Array<ACLAction>;
    deploymentProductionGit?: Array<ACLAction>;
    deploymentRollback?: Array<ACLAction>;
    domain?: Array<ACLAction>;
    domainAcceptDelegation?: Array<ACLAction>;
    domainAuthCodes?: Array<ACLAction>;
    domainCertificate?: Array<ACLAction>;
    domainCheckConfig?: Array<ACLAction>;
    domainMove?: Array<ACLAction>;
    domainPurchase?: Array<ACLAction>;
    domainRecord?: Array<ACLAction>;
    domainTransferIn?: Array<ACLAction>;
    edgeConfig?: Array<ACLAction>;
    edgeConfigItem?: Array<ACLAction>;
    edgeConfigToken?: Array<ACLAction>;
    endpointVerification?: Array<ACLAction>;
    event?: Array<ACLAction>;
    fileUpload?: Array<ACLAction>;
    gitRepository?: Array<ACLAction>;
    integration?: Array<ACLAction>;
    integrationConfiguration?: Array<ACLAction>;
    integrationConfigurationProjects?: Array<ACLAction>;
    integrationConfigurationTransfer?: Array<ACLAction>;
    integrationVercelConfigurationOverride?: Array<ACLAction>;
    ipBlocking?: Array<ACLAction>;
    job?: Array<ACLAction>;
    logDrain?: Array<ACLAction>;
    monitoringChart?: Array<ACLAction>;
    monitoringQuery?: Array<ACLAction>;
    notificationDomainConfiguration?: Array<ACLAction>;
    notificationDomainExpire?: Array<ACLAction>;
    notificationDomainMoved?: Array<ACLAction>;
    notificationDomainPurchase?: Array<ACLAction>;
    notificationDomainRenewal?: Array<ACLAction>;
    notificationDomainTransfer?: Array<ACLAction>;
    notificationDomainUnverified?: Array<ACLAction>;
    notificationPaymentFailed?: Array<ACLAction>;
    notificationSpendCap?: Array<ACLAction>;
    notificationUsageAlert?: Array<ACLAction>;
    openTelemetryEndpoint?: Array<ACLAction>;
    passwordProtection?: Array<ACLAction>;
    paymentMethod?: Array<ACLAction>;
    permissions?: Array<ACLAction>;
    postgres?: Array<ACLAction>;
    previewDeploymentSuffix?: Array<ACLAction>;
    proTrialOnboarding?: Array<ACLAction>;
    project?: Array<ACLAction>;
    projectDeploymentHook?: Array<ACLAction>;
    projectDomain?: Array<ACLAction>;
    projectDomainMove?: Array<ACLAction>;
    projectEnvVars?: Array<ACLAction>;
    projectEnvVarsProduction?: Array<ACLAction>;
    projectEnvVarsUnownedByIntegration?: Array<ACLAction>;
    projectIntegrationConfiguration?: Array<ACLAction>;
    projectLink?: Array<ACLAction>;
    projectMember?: Array<ACLAction>;
    projectProductionBranch?: Array<ACLAction>;
    projectProtectionBypass?: Array<ACLAction>;
    projectTransfer?: Array<ACLAction>;
    rateLimit?: Array<ACLAction>;
    redis?: Array<ACLAction>;
    remoteCaching?: Array<ACLAction>;
    samlConfig?: Array<ACLAction>;
    secret?: Array<ACLAction>;
    sensitiveEnvironmentVariablePolicy?: Array<ACLAction>;
    sharedEnvVars?: Array<ACLAction>;
    sharedEnvVarsProduction?: Array<ACLAction>;
    spendCapConfiguration?: Array<ACLAction>;
    spendCapState?: Array<ACLAction>;
    supportCase?: Array<ACLAction>;
    supportCaseComment?: Array<ACLAction>;
    team?: Array<ACLAction>;
    teamAccessRequest?: Array<ACLAction>;
    teamFellowMembership?: Array<ACLAction>;
    teamInvite?: Array<ACLAction>;
    teamInviteCode?: Array<ACLAction>;
    teamJoin?: Array<ACLAction>;
    teamOwnMembership?: Array<ACLAction>;
    teamOwnMembershipDisconnectSAML?: Array<ACLAction>;
    token?: Array<ACLAction>;
    usage?: Array<ACLAction>;
    user?: Array<ACLAction>;
    userConnection?: Array<ACLAction>;
    webAnalytics?: Array<ACLAction>;
    webAnalyticsPlan?: Array<ACLAction>;
    webhook?: Array<ACLAction>;
    'webhook-event'?: Array<ACLAction>;
  };
  /**
   * Construct a type with a set of properties K of type T
   */
  protectionBypass?: {
    [key: string]: string;
  };
  publicSource?: boolean | null;
  rootDirectory?: string | null;
  serverlessFunctionRegion?: string | null;
  skipGitConnectDuringLink?: boolean;
  sourceFilesOutsideRootDirectory?: boolean;
  ssoProtection?: {
    deploymentType: 'preview' | 'all';
  } | null;
  /**
   * An object containing the deployment's metadata
   */
  targets?: {
    [key: string]: string;
  };
  transferCompletedAt?: number;
  transferStartedAt?: number;
  transferToAccountId?: string;
  transferredFromAccountId?: string;
  updatedAt?: number;
};

export type CreateProjectError = unknown;

export type DeleteProjectData = {
  path: {
    /**
     * The unique project identifier or the project name
     */
    idOrName: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type DeleteProjectResponse = any;

export type DeleteProjectError = unknown;

export type GetProjectData = {
  path: {
    /**
     * The unique project identifier or the project name
     */
    idOrName: string | boolean;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetProjectResponse = {
  accountId: string;
  analytics?: {
    canceledAt: number | null;
    disabledAt: number;
    enabledAt: number;
    id: string;
    paidAt?: number;
    sampleRatePercent?: number | null;
    spendLimitInDollars?: number | null;
  };
  autoExposeSystemEnvs?: boolean;
  buildCommand?: string | null;
  commandForIgnoringBuildStep?: string | null;
  connectBuildsEnabled?: boolean;
  connectConfigurationId?: string | null;
  createdAt?: number;
  devCommand?: string | null;
  directoryListing: boolean;
  enablePreviewFeedback?: boolean | null;
  env?: Array<{
    configurationId?: string | null;
    createdAt?: number;
    createdBy?: string | null;
    /**
     * Whether `value` is decrypted.
     */
    decrypted?: boolean;
    edgeConfigId?: string | null;
    edgeConfigTokenId?: string | null;
    gitBranch?: string;
    id?: string;
    key: string;
    target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
    type: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
    updatedAt?: number;
    updatedBy?: string | null;
    value: string;
  }>;
  framework?:
    | (
        | 'blitzjs'
        | 'nextjs'
        | 'gatsby'
        | 'remix'
        | 'astro'
        | 'hexo'
        | 'eleventy'
        | 'docusaurus-2'
        | 'docusaurus'
        | 'preact'
        | 'solidstart'
        | 'dojo'
        | 'ember'
        | 'vue'
        | 'scully'
        | 'ionic-angular'
        | 'angular'
        | 'polymer'
        | 'svelte'
        | 'sveltekit'
        | 'sveltekit-1'
        | 'ionic-react'
        | 'create-react-app'
        | 'gridsome'
        | 'umijs'
        | 'sapper'
        | 'saber'
        | 'stencil'
        | 'nuxtjs'
        | 'redwoodjs'
        | 'hugo'
        | 'jekyll'
        | 'brunch'
        | 'middleman'
        | 'zola'
        | 'hydrogen'
        | 'vite'
        | 'vitepress'
        | 'vuepress'
        | 'parcel'
        | 'sanity'
      )
    | null;
  gitForkProtection?: boolean;
  gitLFS?: boolean;
  hasActiveBranches?: boolean;
  hasFloatingAliases?: boolean;
  id: string;
  installCommand?: string | null;
  lastRollbackTarget?: {
    fromDeploymentId: string;
    jobStatus: 'succeeded' | 'failed' | 'skipped' | 'pending' | 'in-progress';
    requestedAt: number;
    toDeploymentId: string;
  } | null;
  latestDeployments?: Array<{
    alias?: Array<string>;
    aliasAssigned?: (number | boolean) | null;
    aliasError?: {
      code: string;
      message: string;
    } | null;
    aliasFinal?: string | null;
    automaticAliases?: Array<string>;
    buildingAt?: number;
    builds?: Array<{
      dest?: string;
      src?: string;
      use: string;
    }>;
    checksConclusion?: 'succeeded' | 'failed' | 'skipped' | 'canceled';
    checksState?: 'registered' | 'running' | 'completed';
    connectConfigurationId?: string;
    createdAt: number;
    createdIn: string;
    creator: {
      email: string;
      githubLogin?: string;
      gitlabLogin?: string;
      uid: string;
      username: string;
    } | null;
    deploymentHostname: string;
    forced?: boolean;
    id: string;
    /**
     * Construct a type with a set of properties K of type T
     */
    meta?: {
      [key: string]: string;
    };
    monorepoManager?: string | null;
    name: string;
    plan: 'hobby' | 'enterprise' | 'pro' | 'oss';
    /**
     * Whether or not preview comments are enabled for the deployment
     */
    previewCommentsEnabled?: boolean;
    private: boolean;
    readyAt?: number;
    readyState: 'BUILDING' | 'ERROR' | 'INITIALIZING' | 'QUEUED' | 'READY' | 'CANCELED';
    requestedAt?: number;
    target?: string | null;
    teamId?: string | null;
    type: 'LAMBDAS';
    url: string;
    userId: string;
    withCache?: boolean;
  }>;
  link?:
    | {
        createdAt?: number;
        deployHooks: Array<{
          createdAt?: number;
          id: string;
          name: string;
          ref: string;
          url: string;
        }>;
        gitCredentialId?: string;
        org?: string;
        productionBranch?: string;
        repo?: string;
        repoId?: number;
        sourceless?: boolean;
        type?: 'github';
        updatedAt?: number;
      }
    | {
        createdAt?: number;
        deployHooks: Array<{
          createdAt?: number;
          id: string;
          name: string;
          ref: string;
          url: string;
        }>;
        gitCredentialId?: string;
        productionBranch?: string;
        projectId?: string;
        projectName?: string;
        projectNameWithNamespace?: string;
        projectNamespace?: string;
        projectUrl?: string;
        sourceless?: boolean;
        type?: 'gitlab';
        updatedAt?: number;
      }
    | {
        createdAt?: number;
        deployHooks: Array<{
          createdAt?: number;
          id: string;
          name: string;
          ref: string;
          url: string;
        }>;
        gitCredentialId?: string;
        name?: string;
        owner?: string;
        productionBranch?: string;
        slug?: string;
        sourceless?: boolean;
        type?: 'bitbucket';
        updatedAt?: number;
        uuid?: string;
        workspaceUuid?: string;
      };
  live?: boolean;
  name: string;
  nodeVersion: '18.x' | '16.x' | '14.x' | '12.x' | '10.x';
  outputDirectory?: string | null;
  passwordProtection?: {
    deploymentType: 'preview' | 'all';
  } | null;
  permissions?: {
    Monitoring?: Array<ACLAction>;
    aliasGlobal?: Array<ACLAction>;
    aliasProject?: Array<ACLAction>;
    aliasProtectionBypass?: Array<ACLAction>;
    analytics?: Array<ACLAction>;
    analyticsSampling?: Array<ACLAction>;
    analyticsUsage?: Array<ACLAction>;
    auditLog?: Array<ACLAction>;
    billingAddress?: Array<ACLAction>;
    billingInformation?: Array<ACLAction>;
    billingInvoice?: Array<ACLAction>;
    billingInvoiceEmailRecipient?: Array<ACLAction>;
    billingInvoiceLanguage?: Array<ACLAction>;
    billingPlan?: Array<ACLAction>;
    billingPurchaseOrder?: Array<ACLAction>;
    billingTaxId?: Array<ACLAction>;
    blob?: Array<ACLAction>;
    cacheArtifact?: Array<ACLAction>;
    cacheArtifactUsageEvent?: Array<ACLAction>;
    concurrentBuilds?: Array<ACLAction>;
    connect?: Array<ACLAction>;
    connectConfiguration?: Array<ACLAction>;
    connectConfigurationLink?: Array<ACLAction>;
    deployment?: Array<ACLAction>;
    deploymentCheck?: Array<ACLAction>;
    deploymentCheckPreview?: Array<ACLAction>;
    deploymentCheckReRunFromProductionBranch?: Array<ACLAction>;
    deploymentPreview?: Array<ACLAction>;
    deploymentPrivate?: Array<ACLAction>;
    deploymentProductionGit?: Array<ACLAction>;
    deploymentRollback?: Array<ACLAction>;
    domain?: Array<ACLAction>;
    domainAcceptDelegation?: Array<ACLAction>;
    domainAuthCodes?: Array<ACLAction>;
    domainCertificate?: Array<ACLAction>;
    domainCheckConfig?: Array<ACLAction>;
    domainMove?: Array<ACLAction>;
    domainPurchase?: Array<ACLAction>;
    domainRecord?: Array<ACLAction>;
    domainTransferIn?: Array<ACLAction>;
    edgeConfig?: Array<ACLAction>;
    edgeConfigItem?: Array<ACLAction>;
    edgeConfigToken?: Array<ACLAction>;
    endpointVerification?: Array<ACLAction>;
    event?: Array<ACLAction>;
    fileUpload?: Array<ACLAction>;
    gitRepository?: Array<ACLAction>;
    integration?: Array<ACLAction>;
    integrationConfiguration?: Array<ACLAction>;
    integrationConfigurationProjects?: Array<ACLAction>;
    integrationConfigurationTransfer?: Array<ACLAction>;
    integrationVercelConfigurationOverride?: Array<ACLAction>;
    ipBlocking?: Array<ACLAction>;
    job?: Array<ACLAction>;
    logDrain?: Array<ACLAction>;
    monitoringChart?: Array<ACLAction>;
    monitoringQuery?: Array<ACLAction>;
    notificationDomainConfiguration?: Array<ACLAction>;
    notificationDomainExpire?: Array<ACLAction>;
    notificationDomainMoved?: Array<ACLAction>;
    notificationDomainPurchase?: Array<ACLAction>;
    notificationDomainRenewal?: Array<ACLAction>;
    notificationDomainTransfer?: Array<ACLAction>;
    notificationDomainUnverified?: Array<ACLAction>;
    notificationPaymentFailed?: Array<ACLAction>;
    notificationSpendCap?: Array<ACLAction>;
    notificationUsageAlert?: Array<ACLAction>;
    openTelemetryEndpoint?: Array<ACLAction>;
    passwordProtection?: Array<ACLAction>;
    paymentMethod?: Array<ACLAction>;
    permissions?: Array<ACLAction>;
    postgres?: Array<ACLAction>;
    previewDeploymentSuffix?: Array<ACLAction>;
    proTrialOnboarding?: Array<ACLAction>;
    project?: Array<ACLAction>;
    projectDeploymentHook?: Array<ACLAction>;
    projectDomain?: Array<ACLAction>;
    projectDomainMove?: Array<ACLAction>;
    projectEnvVars?: Array<ACLAction>;
    projectEnvVarsProduction?: Array<ACLAction>;
    projectEnvVarsUnownedByIntegration?: Array<ACLAction>;
    projectIntegrationConfiguration?: Array<ACLAction>;
    projectLink?: Array<ACLAction>;
    projectMember?: Array<ACLAction>;
    projectProductionBranch?: Array<ACLAction>;
    projectProtectionBypass?: Array<ACLAction>;
    projectTransfer?: Array<ACLAction>;
    rateLimit?: Array<ACLAction>;
    redis?: Array<ACLAction>;
    remoteCaching?: Array<ACLAction>;
    samlConfig?: Array<ACLAction>;
    secret?: Array<ACLAction>;
    sensitiveEnvironmentVariablePolicy?: Array<ACLAction>;
    sharedEnvVars?: Array<ACLAction>;
    sharedEnvVarsProduction?: Array<ACLAction>;
    spendCapConfiguration?: Array<ACLAction>;
    spendCapState?: Array<ACLAction>;
    supportCase?: Array<ACLAction>;
    supportCaseComment?: Array<ACLAction>;
    team?: Array<ACLAction>;
    teamAccessRequest?: Array<ACLAction>;
    teamFellowMembership?: Array<ACLAction>;
    teamInvite?: Array<ACLAction>;
    teamInviteCode?: Array<ACLAction>;
    teamJoin?: Array<ACLAction>;
    teamOwnMembership?: Array<ACLAction>;
    teamOwnMembershipDisconnectSAML?: Array<ACLAction>;
    token?: Array<ACLAction>;
    usage?: Array<ACLAction>;
    user?: Array<ACLAction>;
    userConnection?: Array<ACLAction>;
    webAnalytics?: Array<ACLAction>;
    webAnalyticsPlan?: Array<ACLAction>;
    webhook?: Array<ACLAction>;
    'webhook-event'?: Array<ACLAction>;
  };
  /**
   * Construct a type with a set of properties K of type T
   */
  protectionBypass?: {
    [key: string]: string;
  };
  publicSource?: boolean | null;
  rootDirectory?: string | null;
  serverlessFunctionRegion?: string | null;
  skipGitConnectDuringLink?: boolean;
  sourceFilesOutsideRootDirectory?: boolean;
  ssoProtection?: {
    deploymentType: 'preview' | 'all';
  } | null;
  /**
   * An object containing the deployment's metadata
   */
  targets?: {
    [key: string]: string;
  };
  transferCompletedAt?: number;
  transferStartedAt?: number;
  transferToAccountId?: string;
  transferredFromAccountId?: string;
  updatedAt?: number;
};

export type GetProjectError = unknown;

export type UpdateProjectData = {
  body?: {
    autoExposeSystemEnvs?: boolean;
    /**
     * The build command for this project. When `null` is used this value will be automatically detected
     */
    buildCommand?: string | null;
    commandForIgnoringBuildStep?: string | null;
    /**
     * The dev command for this project. When `null` is used this value will be automatically detected
     */
    devCommand?: string | null;
    directoryListing?: boolean;
    /**
     * Opt-in to Preview comments on the project level
     */
    enablePreviewFeedback?: boolean | null;
    /**
     * The framework that is being used for this project. When `null` is used no framework is selected
     */
    framework?:
      | (
          | 'blitzjs'
          | 'nextjs'
          | 'gatsby'
          | 'remix'
          | 'astro'
          | 'hexo'
          | 'eleventy'
          | 'docusaurus-2'
          | 'docusaurus'
          | 'preact'
          | 'solidstart'
          | 'dojo'
          | 'ember'
          | 'vue'
          | 'scully'
          | 'ionic-angular'
          | 'angular'
          | 'polymer'
          | 'svelte'
          | 'sveltekit'
          | 'sveltekit-1'
          | 'ionic-react'
          | 'create-react-app'
          | 'gridsome'
          | 'umijs'
          | 'sapper'
          | 'saber'
          | 'stencil'
          | 'nuxtjs'
          | 'redwoodjs'
          | 'hugo'
          | 'jekyll'
          | 'brunch'
          | 'middleman'
          | 'zola'
          | 'hydrogen'
          | 'vite'
          | 'vitepress'
          | 'vuepress'
          | 'parcel'
          | 'sanity'
        )
      | null;
    /**
     * Specifies whether PRs from Git forks should require a team member's authorization before it can be deployed
     */
    gitForkProtection?: boolean;
    /**
     * Specifies whether Git LFS is enabled for this project.
     */
    gitLFS?: boolean;
    /**
     * The install command for this project. When `null` is used this value will be automatically detected
     */
    installCommand?: string | null;
    /**
     * The desired name for the project
     */
    name?: string;
    nodeVersion?: '18.x' | '16.x' | '14.x' | '12.x' | '10.x';
    /**
     * The output directory of the project. When `null` is used this value will be automatically detected
     */
    outputDirectory?: string | null;
    /**
     * Allows to protect project deployments with a password
     */
    passwordProtection?: {
      /**
       * Specify if the password will apply to every Deployment Target or just Preview
       */
      deploymentType: 'all' | 'preview';
      /**
       * The password that will be used to protect Project Deployments
       */
      password?: string | null;
    } | null;
    /**
     * Specifies whether the source code and logs of the deployments for this project should be public or not
     */
    publicSource?: boolean | null;
    /**
     * The name of a directory or relative path to the source code of your project. When `null` is used it will default to the project root
     */
    rootDirectory?: string | null;
    /**
     * The region to deploy Serverless Functions in this project
     */
    serverlessFunctionRegion?: string | null;
    /**
     * Opts-out of the message prompting a CLI user to connect a Git repository in `vercel link`.
     * @deprecated
     */
    skipGitConnectDuringLink?: boolean;
    /**
     * Indicates if there are source files outside of the root directory
     */
    sourceFilesOutsideRootDirectory?: boolean;
    /**
     * Ensures visitors to your Preview Deployments are logged into Vercel and have a minimum of Viewer access on your team
     */
    ssoProtection?: {
      /**
       * Specify if the Vercel Authentication (SSO Protection) will apply to every Deployment Target or just Preview
       */
      deploymentType: 'all' | 'preview';
    } | null;
  };
  path: {
    /**
     * The unique project identifier or the project name
     */
    idOrName: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type UpdateProjectResponse = {
  accountId: string;
  analytics?: {
    canceledAt: number | null;
    disabledAt: number;
    enabledAt: number;
    id: string;
    paidAt?: number;
    sampleRatePercent?: number | null;
    spendLimitInDollars?: number | null;
  };
  autoExposeSystemEnvs?: boolean;
  buildCommand?: string | null;
  commandForIgnoringBuildStep?: string | null;
  connectBuildsEnabled?: boolean;
  connectConfigurationId?: string | null;
  createdAt?: number;
  devCommand?: string | null;
  directoryListing: boolean;
  enablePreviewFeedback?: boolean | null;
  env?: Array<{
    configurationId?: string | null;
    createdAt?: number;
    createdBy?: string | null;
    /**
     * Whether `value` is decrypted.
     */
    decrypted?: boolean;
    edgeConfigId?: string | null;
    edgeConfigTokenId?: string | null;
    gitBranch?: string;
    id?: string;
    key: string;
    target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
    type: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
    updatedAt?: number;
    updatedBy?: string | null;
    value: string;
  }>;
  framework?:
    | (
        | 'blitzjs'
        | 'nextjs'
        | 'gatsby'
        | 'remix'
        | 'astro'
        | 'hexo'
        | 'eleventy'
        | 'docusaurus-2'
        | 'docusaurus'
        | 'preact'
        | 'solidstart'
        | 'dojo'
        | 'ember'
        | 'vue'
        | 'scully'
        | 'ionic-angular'
        | 'angular'
        | 'polymer'
        | 'svelte'
        | 'sveltekit'
        | 'sveltekit-1'
        | 'ionic-react'
        | 'create-react-app'
        | 'gridsome'
        | 'umijs'
        | 'sapper'
        | 'saber'
        | 'stencil'
        | 'nuxtjs'
        | 'redwoodjs'
        | 'hugo'
        | 'jekyll'
        | 'brunch'
        | 'middleman'
        | 'zola'
        | 'hydrogen'
        | 'vite'
        | 'vitepress'
        | 'vuepress'
        | 'parcel'
        | 'sanity'
      )
    | null;
  gitForkProtection?: boolean;
  gitLFS?: boolean;
  hasActiveBranches?: boolean;
  hasFloatingAliases?: boolean;
  id: string;
  installCommand?: string | null;
  lastRollbackTarget?: {
    fromDeploymentId: string;
    jobStatus: 'succeeded' | 'failed' | 'skipped' | 'pending' | 'in-progress';
    requestedAt: number;
    toDeploymentId: string;
  } | null;
  latestDeployments?: Array<{
    alias?: Array<string>;
    aliasAssigned?: (number | boolean) | null;
    aliasError?: {
      code: string;
      message: string;
    } | null;
    aliasFinal?: string | null;
    automaticAliases?: Array<string>;
    buildingAt?: number;
    builds?: Array<{
      dest?: string;
      src?: string;
      use: string;
    }>;
    checksConclusion?: 'succeeded' | 'failed' | 'skipped' | 'canceled';
    checksState?: 'registered' | 'running' | 'completed';
    connectConfigurationId?: string;
    createdAt: number;
    createdIn: string;
    creator: {
      email: string;
      githubLogin?: string;
      gitlabLogin?: string;
      uid: string;
      username: string;
    } | null;
    deploymentHostname: string;
    forced?: boolean;
    id: string;
    /**
     * Construct a type with a set of properties K of type T
     */
    meta?: {
      [key: string]: string;
    };
    monorepoManager?: string | null;
    name: string;
    plan: 'hobby' | 'enterprise' | 'pro' | 'oss';
    /**
     * Whether or not preview comments are enabled for the deployment
     */
    previewCommentsEnabled?: boolean;
    private: boolean;
    readyAt?: number;
    readyState: 'BUILDING' | 'ERROR' | 'INITIALIZING' | 'QUEUED' | 'READY' | 'CANCELED';
    requestedAt?: number;
    target?: string | null;
    teamId?: string | null;
    type: 'LAMBDAS';
    url: string;
    userId: string;
    withCache?: boolean;
  }>;
  link?:
    | {
        createdAt?: number;
        deployHooks: Array<{
          createdAt?: number;
          id: string;
          name: string;
          ref: string;
          url: string;
        }>;
        gitCredentialId?: string;
        org?: string;
        productionBranch?: string;
        repo?: string;
        repoId?: number;
        sourceless?: boolean;
        type?: 'github';
        updatedAt?: number;
      }
    | {
        createdAt?: number;
        deployHooks: Array<{
          createdAt?: number;
          id: string;
          name: string;
          ref: string;
          url: string;
        }>;
        gitCredentialId?: string;
        productionBranch?: string;
        projectId?: string;
        projectName?: string;
        projectNameWithNamespace?: string;
        projectNamespace?: string;
        projectUrl?: string;
        sourceless?: boolean;
        type?: 'gitlab';
        updatedAt?: number;
      }
    | {
        createdAt?: number;
        deployHooks: Array<{
          createdAt?: number;
          id: string;
          name: string;
          ref: string;
          url: string;
        }>;
        gitCredentialId?: string;
        name?: string;
        owner?: string;
        productionBranch?: string;
        slug?: string;
        sourceless?: boolean;
        type?: 'bitbucket';
        updatedAt?: number;
        uuid?: string;
        workspaceUuid?: string;
      };
  live?: boolean;
  name: string;
  nodeVersion: '18.x' | '16.x' | '14.x' | '12.x' | '10.x';
  outputDirectory?: string | null;
  passwordProtection?: {
    deploymentType: 'all' | 'preview';
  } | null;
  permissions?: {
    Monitoring?: Array<ACLAction>;
    aliasGlobal?: Array<ACLAction>;
    aliasProject?: Array<ACLAction>;
    aliasProtectionBypass?: Array<ACLAction>;
    analytics?: Array<ACLAction>;
    analyticsSampling?: Array<ACLAction>;
    analyticsUsage?: Array<ACLAction>;
    auditLog?: Array<ACLAction>;
    billingAddress?: Array<ACLAction>;
    billingInformation?: Array<ACLAction>;
    billingInvoice?: Array<ACLAction>;
    billingInvoiceEmailRecipient?: Array<ACLAction>;
    billingInvoiceLanguage?: Array<ACLAction>;
    billingPlan?: Array<ACLAction>;
    billingPurchaseOrder?: Array<ACLAction>;
    billingTaxId?: Array<ACLAction>;
    blob?: Array<ACLAction>;
    cacheArtifact?: Array<ACLAction>;
    cacheArtifactUsageEvent?: Array<ACLAction>;
    concurrentBuilds?: Array<ACLAction>;
    connect?: Array<ACLAction>;
    connectConfiguration?: Array<ACLAction>;
    connectConfigurationLink?: Array<ACLAction>;
    deployment?: Array<ACLAction>;
    deploymentCheck?: Array<ACLAction>;
    deploymentCheckPreview?: Array<ACLAction>;
    deploymentCheckReRunFromProductionBranch?: Array<ACLAction>;
    deploymentPreview?: Array<ACLAction>;
    deploymentPrivate?: Array<ACLAction>;
    deploymentProductionGit?: Array<ACLAction>;
    deploymentRollback?: Array<ACLAction>;
    domain?: Array<ACLAction>;
    domainAcceptDelegation?: Array<ACLAction>;
    domainAuthCodes?: Array<ACLAction>;
    domainCertificate?: Array<ACLAction>;
    domainCheckConfig?: Array<ACLAction>;
    domainMove?: Array<ACLAction>;
    domainPurchase?: Array<ACLAction>;
    domainRecord?: Array<ACLAction>;
    domainTransferIn?: Array<ACLAction>;
    edgeConfig?: Array<ACLAction>;
    edgeConfigItem?: Array<ACLAction>;
    edgeConfigToken?: Array<ACLAction>;
    endpointVerification?: Array<ACLAction>;
    event?: Array<ACLAction>;
    fileUpload?: Array<ACLAction>;
    gitRepository?: Array<ACLAction>;
    integration?: Array<ACLAction>;
    integrationConfiguration?: Array<ACLAction>;
    integrationConfigurationProjects?: Array<ACLAction>;
    integrationConfigurationTransfer?: Array<ACLAction>;
    integrationVercelConfigurationOverride?: Array<ACLAction>;
    ipBlocking?: Array<ACLAction>;
    job?: Array<ACLAction>;
    logDrain?: Array<ACLAction>;
    monitoringChart?: Array<ACLAction>;
    monitoringQuery?: Array<ACLAction>;
    notificationDomainConfiguration?: Array<ACLAction>;
    notificationDomainExpire?: Array<ACLAction>;
    notificationDomainMoved?: Array<ACLAction>;
    notificationDomainPurchase?: Array<ACLAction>;
    notificationDomainRenewal?: Array<ACLAction>;
    notificationDomainTransfer?: Array<ACLAction>;
    notificationDomainUnverified?: Array<ACLAction>;
    notificationPaymentFailed?: Array<ACLAction>;
    notificationSpendCap?: Array<ACLAction>;
    notificationUsageAlert?: Array<ACLAction>;
    openTelemetryEndpoint?: Array<ACLAction>;
    passwordProtection?: Array<ACLAction>;
    paymentMethod?: Array<ACLAction>;
    permissions?: Array<ACLAction>;
    postgres?: Array<ACLAction>;
    previewDeploymentSuffix?: Array<ACLAction>;
    proTrialOnboarding?: Array<ACLAction>;
    project?: Array<ACLAction>;
    projectDeploymentHook?: Array<ACLAction>;
    projectDomain?: Array<ACLAction>;
    projectDomainMove?: Array<ACLAction>;
    projectEnvVars?: Array<ACLAction>;
    projectEnvVarsProduction?: Array<ACLAction>;
    projectEnvVarsUnownedByIntegration?: Array<ACLAction>;
    projectIntegrationConfiguration?: Array<ACLAction>;
    projectLink?: Array<ACLAction>;
    projectMember?: Array<ACLAction>;
    projectProductionBranch?: Array<ACLAction>;
    projectProtectionBypass?: Array<ACLAction>;
    projectTransfer?: Array<ACLAction>;
    rateLimit?: Array<ACLAction>;
    redis?: Array<ACLAction>;
    remoteCaching?: Array<ACLAction>;
    samlConfig?: Array<ACLAction>;
    secret?: Array<ACLAction>;
    sensitiveEnvironmentVariablePolicy?: Array<ACLAction>;
    sharedEnvVars?: Array<ACLAction>;
    sharedEnvVarsProduction?: Array<ACLAction>;
    spendCapConfiguration?: Array<ACLAction>;
    spendCapState?: Array<ACLAction>;
    supportCase?: Array<ACLAction>;
    supportCaseComment?: Array<ACLAction>;
    team?: Array<ACLAction>;
    teamAccessRequest?: Array<ACLAction>;
    teamFellowMembership?: Array<ACLAction>;
    teamInvite?: Array<ACLAction>;
    teamInviteCode?: Array<ACLAction>;
    teamJoin?: Array<ACLAction>;
    teamOwnMembership?: Array<ACLAction>;
    teamOwnMembershipDisconnectSAML?: Array<ACLAction>;
    token?: Array<ACLAction>;
    usage?: Array<ACLAction>;
    user?: Array<ACLAction>;
    userConnection?: Array<ACLAction>;
    webAnalytics?: Array<ACLAction>;
    webAnalyticsPlan?: Array<ACLAction>;
    webhook?: Array<ACLAction>;
    'webhook-event'?: Array<ACLAction>;
  };
  /**
   * Construct a type with a set of properties K of type T
   */
  protectionBypass?: {
    [key: string]: string;
  };
  publicSource?: boolean | null;
  rootDirectory?: string | null;
  serverlessFunctionRegion?: string | null;
  skipGitConnectDuringLink?: boolean;
  sourceFilesOutsideRootDirectory?: boolean;
  ssoProtection?: {
    deploymentType: 'all' | 'preview';
  } | null;
  targets?: {
    [key: string]: {
      alias?: Array<string>;
      aliasAssigned?: (number | boolean) | null;
      aliasError?: {
        code: string;
        message: string;
      } | null;
      aliasFinal?: string | null;
      automaticAliases?: Array<string>;
      buildingAt?: number;
      builds?: Array<{
        dest?: string;
        src?: string;
        use: string;
      }>;
      checksConclusion?: 'succeeded' | 'failed' | 'skipped' | 'canceled';
      checksState?: 'registered' | 'running' | 'completed';
      connectConfigurationId?: string;
      createdAt: number;
      createdIn: string;
      creator: {
        email: string;
        githubLogin?: string;
        gitlabLogin?: string;
        uid: string;
        username: string;
      } | null;
      deploymentHostname: string;
      forced?: boolean;
      id: string;
      /**
       * Construct a type with a set of properties K of type T
       */
      meta?: {
        [key: string]: string;
      };
      monorepoManager?: string | null;
      name: string;
      plan: 'hobby' | 'enterprise' | 'pro' | 'oss';
      /**
       * Whether or not preview comments are enabled for the deployment
       */
      previewCommentsEnabled?: boolean;
      private: boolean;
      readyAt?: number;
      readyState: 'BUILDING' | 'ERROR' | 'INITIALIZING' | 'QUEUED' | 'READY' | 'CANCELED';
      requestedAt?: number;
      target?: string | null;
      teamId?: string | null;
      type: 'LAMBDAS';
      url: string;
      userId: string;
      withCache?: boolean;
    } | null;
  };
  transferCompletedAt?: number;
  transferStartedAt?: number;
  transferToAccountId?: string;
  transferredFromAccountId?: string;
  updatedAt?: number;
};

export type UpdateProjectError = unknown;

export type GetProjectDomainsData = {
  path: {
    /**
     * The unique project identifier or the project name
     */
    idOrName: string | number;
  };
  query?: {
    /**
     * Filters domains based on specific branch.
     */
    gitBranch?: string;
    /**
     * Maximum number of domains to list from a request (max 100).
     */
    limit?: number;
    /**
     * Domains sort order by createdAt
     */
    order?: 'ASC' | 'DESC';
    /**
     * Filters only production domains when set to `true`.
     */
    production?: 'true' | 'false';
    /**
     * Filters domains based on their redirect target.
     */
    redirect?: string;
    /**
     * Excludes redirect project domains when \"false\". Includes redirect project domains when \"true\" (default).
     */
    redirects?: 'true' | 'false';
    /**
     * Get domains created after this JavaScript timestamp.
     */
    since?: number;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
    /**
     * Get domains created before this JavaScript timestamp.
     */
    until?: number;
    /**
     * Filters domains based on their verification status.
     */
    verified?: 'true' | 'false';
  };
};

export type GetProjectDomainsResponse = {
  domains: Array<{
    apexName: string;
    createdAt?: number;
    gitBranch?: string | null;
    name: string;
    projectId: string;
    redirect?: string | null;
    redirectStatusCode?: (307 | 301 | 302 | 308) | null;
    updatedAt?: number;
    /**
     * A list of verification challenges, one of which must be completed to verify the domain for use on the project. After the challenge is complete `POST /projects/:idOrName/domains/:domain/verify` to verify the domain. Possible challenges: - If `verification.type = TXT` the `verification.domain` will be checked for a TXT record matching `verification.value`.
     */
    verification?: Array<{
      domain: string;
      reason: string;
      type: string;
      value: string;
    }>;
    /**
     * `true` if the domain is verified for use with the project. If `false` it will not be used as an alias on this project until the challenge in `verification` is completed.
     */
    verified: boolean;
  }>;
  pagination: Pagination;
};

export type GetProjectDomainsError = unknown;

export type RemoveProjectDomainData = {
  path: {
    /**
     * The project domain name
     */
    domain: string;
    /**
     * The unique project identifier or the project name
     */
    idOrName: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type RemoveProjectDomainResponse = {
  [key: string]: unknown;
};

export type RemoveProjectDomainError = unknown;

export type GetProjectDomainData = {
  path: {
    /**
     * The project domain name
     */
    domain: string;
    /**
     * The unique project identifier or the project name
     */
    idOrName: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type GetProjectDomainResponse = {
  apexName: string;
  createdAt?: number;
  gitBranch?: string | null;
  name: string;
  projectId: string;
  redirect?: string | null;
  redirectStatusCode?: (307 | 301 | 302 | 308) | null;
  updatedAt?: number;
  /**
   * A list of verification challenges, one of which must be completed to verify the domain for use on the project. After the challenge is complete `POST /projects/:idOrName/domains/:domain/verify` to verify the domain. Possible challenges: - If `verification.type = TXT` the `verification.domain` will be checked for a TXT record matching `verification.value`.
   */
  verification?: Array<{
    domain: string;
    reason: string;
    type: string;
    value: string;
  }>;
  /**
   * `true` if the domain is verified for use with the project. If `false` it will not be used as an alias on this project until the challenge in `verification` is completed.
   */
  verified: boolean;
};

export type GetProjectDomainError = unknown;

export type UpdateProjectDomainData = {
  body?: {
    /**
     * Git branch to link the project domain
     */
    gitBranch?: string | null;
    /**
     * Target destination domain for redirect
     */
    redirect?: string | null;
    /**
     * Status code for domain redirect
     */
    redirectStatusCode?: (301 | 302 | 307 | 308) | null;
  };
  path: {
    /**
     * The project domain name
     */
    domain: string;
    /**
     * The unique project identifier or the project name
     */
    idOrName: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type UpdateProjectDomainResponse = {
  apexName: string;
  createdAt?: number;
  gitBranch?: string | null;
  name: string;
  projectId: string;
  redirect?: string | null;
  redirectStatusCode?: (307 | 301 | 302 | 308) | null;
  updatedAt?: number;
  /**
   * A list of verification challenges, one of which must be completed to verify the domain for use on the project. After the challenge is complete `POST /projects/:idOrName/domains/:domain/verify` to verify the domain. Possible challenges: - If `verification.type = TXT` the `verification.domain` will be checked for a TXT record matching `verification.value`.
   */
  verification?: Array<{
    domain: string;
    reason: string;
    type: string;
    value: string;
  }>;
  /**
   * `true` if the domain is verified for use with the project. If `false` it will not be used as an alias on this project until the challenge in `verification` is completed.
   */
  verified: boolean;
};

export type UpdateProjectDomainError = unknown;

export type VerifyProjectDomainData = {
  path: {
    /**
     * The domain name you want to verify
     */
    domain: string;
    /**
     * The unique project identifier or the project name
     */
    idOrName: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type VerifyProjectDomainResponse = {
  apexName: string;
  createdAt?: number;
  gitBranch?: string | null;
  name: string;
  projectId: string;
  redirect?: string | null;
  redirectStatusCode?: (307 | 301 | 302 | 308) | null;
  updatedAt?: number;
  /**
   * A list of verification challenges, one of which must be completed to verify the domain for use on the project. After the challenge is complete `POST /projects/:idOrName/domains/:domain/verify` to verify the domain. Possible challenges: - If `verification.type = TXT` the `verification.domain` will be checked for a TXT record matching `verification.value`.
   */
  verification?: Array<{
    domain: string;
    reason: string;
    type: string;
    value: string;
  }>;
  /**
   * `true` if the domain is verified for use with the project. If `false` it will not be used as an alias on this project until the challenge in `verification` is completed.
   */
  verified: boolean;
};

export type VerifyProjectDomainError = unknown;

export type FilterProjectEnvsData = {
  path: {
    /**
     * The unique project identifier or the project name
     */
    idOrName: string;
  };
  query?: {
    /**
     * If true, the environment variable value will be decrypted
     */
    decrypt?: 'true' | 'false';
    /**
     * If defined, the git branch of the environment variable to filter the results
     */
    gitBranch?: string;
    /**
     * The source that is calling the endpoint.
     */
    source?: string;
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type FilterProjectEnvsResponse =
  | {
      configurationId?: string | null;
      createdAt?: number;
      createdBy?: string | null;
      /**
       * Whether `value` is decrypted.
       */
      decrypted?: boolean;
      edgeConfigId?: string | null;
      edgeConfigTokenId?: string | null;
      gitBranch?: string;
      id?: string;
      key?: string;
      system?: boolean;
      target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
      type?: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
      updatedAt?: number;
      updatedBy?: string | null;
      value?: string;
    }
  | {
      envs: Array<{
        configurationId?: string | null;
        createdAt?: number;
        createdBy?: string | null;
        /**
         * Whether `value` is decrypted.
         */
        decrypted?: boolean;
        edgeConfigId?: string | null;
        edgeConfigTokenId?: string | null;
        gitBranch?: string;
        id?: string;
        key?: string;
        system?: boolean;
        target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
        type?: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
        updatedAt?: number;
        updatedBy?: string | null;
        value?: string;
      }>;
      pagination: Pagination;
    }
  | {
      envs: Array<{
        configurationId?: string | null;
        createdAt?: number;
        createdBy?: string | null;
        /**
         * Whether `value` is decrypted.
         */
        decrypted?: boolean;
        edgeConfigId?: string | null;
        edgeConfigTokenId?: string | null;
        gitBranch?: string;
        id?: string;
        key?: string;
        system?: boolean;
        target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
        type?: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
        updatedAt?: number;
        updatedBy?: string | null;
        value?: string;
      }>;
    };

export type FilterProjectEnvsError = unknown;

export type RemoveProjectEnvData = {
  path: {
    /**
     * The unique environment variable identifier
     */
    id: string;
    /**
     * The unique project identifier or the project name
     */
    idOrName: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type RemoveProjectEnvResponse =
  | Array<{
      configurationId?: string | null;
      createdAt?: number;
      createdBy?: string | null;
      /**
       * Whether `value` is decrypted.
       */
      decrypted?: boolean;
      edgeConfigId?: string | null;
      edgeConfigTokenId?: string | null;
      gitBranch?: string;
      id?: string;
      key: string;
      target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
      type: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
      updatedAt?: number;
      updatedBy?: string | null;
      value: string;
    }>
  | {
      configurationId?: string | null;
      createdAt?: number;
      createdBy?: string | null;
      /**
       * Whether `value` is decrypted.
       */
      decrypted?: boolean;
      edgeConfigId?: string | null;
      edgeConfigTokenId?: string | null;
      gitBranch?: string;
      id?: string;
      key: string;
      system?: boolean;
      target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
      type: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
      updatedAt?: number;
      updatedBy?: string | null;
      value: string;
    }
  | {
      configurationId?: string | null;
      createdAt?: number;
      createdBy?: string | null;
      /**
       * Whether `value` is decrypted.
       */
      decrypted?: boolean;
      edgeConfigId?: string | null;
      edgeConfigTokenId?: string | null;
      gitBranch?: string;
      id?: string;
      key: string;
      target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
      type: 'secret' | 'system' | 'encrypted' | 'plain' | 'sensitive';
      updatedAt?: number;
      updatedBy?: string | null;
      value: string;
    };

export type RemoveProjectEnvError = unknown;

export type EditProjectEnvData = {
  body?: {
    /**
     * The git branch of the environment variable
     */
    gitBranch?: string | null;
    /**
     * The name of the environment variable
     */
    key?: string;
    /**
     * The target environment of the environment variable
     */
    target?: Array<
      | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Productio'
      | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Previe'
      | 'mport("/vercel/path0/utils/env-variable-util/types").EnvTarget.Developmen'
    >;
    /**
     * The type of environment variable
     */
    type?: 'system' | 'secret' | 'encrypted' | 'plain' | 'sensitive';
    /**
     * The value of the environment variable
     */
    value?: string;
  };
  path: {
    /**
     * The unique environment variable identifier
     */
    id: string;
    /**
     * The unique project identifier or the project name
     */
    idOrName: string;
  };
  query?: {
    /**
     * The Team identifier or slug to perform the request on behalf of.
     */
    teamId?: string;
  };
};

export type EditProjectEnvResponse = {
  configurationId?: string | null;
  createdAt?: number;
  createdBy?: string | null;
  /**
   * Whether `value` is decrypted.
   */
  decrypted?: boolean;
  edgeConfigId?: string | null;
  edgeConfigTokenId?: string | null;
  gitBranch?: string;
  id?: string;
  key: string;
  target?: Array<'production' | 'preview' | 'development'> | 'production' | 'preview' | 'development';
  type: 'system' | 'encrypted' | 'plain' | 'sensitive' | 'secret';
  updatedAt?: number;
  updatedBy?: string | null;
  value: string;
};

export type EditProjectEnvError = unknown;
