// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  EmailLoginData,
  EmailLoginError,
  EmailLoginResponse,
  VerifyTokenData,
  VerifyTokenError,
  VerifyTokenResponse,
  GetAllChecksData,
  GetAllChecksError,
  GetAllChecksResponse,
  CreateCheckData,
  CreateCheckError,
  CreateCheckResponse,
  GetCheckData,
  GetCheckError,
  GetCheckResponse,
  UpdateCheckData,
  UpdateCheckError,
  UpdateCheckResponse,
  RerequestCheckData,
  RerequestCheckError,
  RerequestCheckResponse,
  UpdateRecordData,
  UpdateRecordError,
  UpdateRecordResponse,
  GetEdgeConfigsData,
  GetEdgeConfigsError,
  GetEdgeConfigsResponse,
  CreateEdgeConfigData,
  CreateEdgeConfigError,
  CreateEdgeConfigResponse,
  DeleteEdgeConfigData,
  DeleteEdgeConfigError,
  DeleteEdgeConfigResponse,
  GetEdgeConfigData,
  GetEdgeConfigError,
  GetEdgeConfigResponse,
  UpdateEdgeConfigData,
  UpdateEdgeConfigError,
  UpdateEdgeConfigResponse,
  GetEdgeConfigItemData,
  GetEdgeConfigItemError,
  GetEdgeConfigItemResponse,
  GetEdgeConfigItemsData,
  GetEdgeConfigItemsError,
  GetEdgeConfigItemsResponse,
  PatchtEdgeConfigItemsData,
  PatchtEdgeConfigItemsError,
  PatchtEdgeConfigItemsResponse,
  CreateEdgeConfigTokenData,
  CreateEdgeConfigTokenError,
  CreateEdgeConfigTokenResponse,
  GetEdgeConfigTokenData,
  GetEdgeConfigTokenError,
  GetEdgeConfigTokenResponse,
  DeleteEdgeConfigTokensData,
  DeleteEdgeConfigTokensError,
  DeleteEdgeConfigTokensResponse,
  GetEdgeConfigTokensData,
  GetEdgeConfigTokensError,
  GetEdgeConfigTokensResponse,
  DeleteConfigurationData,
  DeleteConfigurationError,
  DeleteConfigurationResponse,
  GetConfigurationData,
  GetConfigurationError,
  GetConfigurationResponse,
  GetConfigurationsData,
  GetConfigurationsError,
  GetConfigurationsResponse,
  GitNamespacesData,
  GitNamespacesError,
  GitNamespacesResponse,
  DeleteIntegrationLogDrainData,
  DeleteIntegrationLogDrainError,
  DeleteIntegrationLogDrainResponse,
  GetV1IntegrationsSearchRepoData,
  GetV1IntegrationsSearchRepoError,
  GetV1IntegrationsSearchRepoResponse,
  GetConfigurableLogDrainsData,
  GetConfigurableLogDrainsError,
  GetConfigurableLogDrainsResponse,
  CreateConfigurableLogDrainData,
  CreateConfigurableLogDrainError,
  CreateConfigurableLogDrainResponse,
  DeleteConfigurableLogDrainData,
  DeleteConfigurableLogDrainError,
  DeleteConfigurableLogDrainResponse,
  GetConfigurableLogDrainData,
  GetConfigurableLogDrainError,
  GetConfigurableLogDrainResponse,
  GetProjectEnvData,
  GetProjectEnvError,
  GetProjectEnvResponse,
  CreateTeamData,
  CreateTeamError,
  CreateTeamResponse,
  DeleteTeamData,
  DeleteTeamError,
  DeleteTeamResponse,
  DeleteTeamInviteCodeData,
  DeleteTeamInviteCodeError,
  DeleteTeamInviteCodeResponse,
  InviteUserToTeamData,
  InviteUserToTeamError,
  InviteUserToTeamResponse,
  JoinTeamData,
  JoinTeamError,
  JoinTeamResponse,
  RemoveTeamMemberData,
  RemoveTeamMemberError,
  RemoveTeamMemberResponse,
  UpdateTeamMemberData,
  UpdateTeamMemberError,
  UpdateTeamMemberResponse,
  RequestAccessToTeamData,
  RequestAccessToTeamError,
  RequestAccessToTeamResponse,
  GetTeamAccessRequestData,
  GetTeamAccessRequestError,
  GetTeamAccessRequestResponse,
  RequestDeleteData,
  RequestDeleteError,
  RequestDeleteResponse,
  GetWebhooksData,
  GetWebhooksError,
  GetWebhooksResponse,
  CreateWebhookData,
  CreateWebhookError,
  CreateWebhookResponse,
  DeleteWebhookData,
  DeleteWebhookError,
  DeleteWebhookResponse,
  GetWebhookData,
  GetWebhookError,
  GetWebhookResponse,
  AddProjectDomainData,
  AddProjectDomainError,
  AddProjectDomainResponse,
  CreateProjectEnvData,
  CreateProjectEnvError,
  CreateProjectEnvResponse,
  ListDeploymentBuildsData,
  ListDeploymentBuildsError,
  ListDeploymentBuildsResponse,
  CancelDeploymentData,
  CancelDeploymentError,
  CancelDeploymentResponse,
  CreateDeploymentData,
  CreateDeploymentError,
  CreateDeploymentResponse,
  GetDeploymentData,
  GetDeploymentError,
  GetDeploymentResponse,
  DeleteDeploymentData,
  DeleteDeploymentError,
  DeleteDeploymentResponse,
  DeleteAliasData,
  DeleteAliasError,
  DeleteAliasResponse,
  GetDeploymentEventsData,
  GetDeploymentEventsError,
  GetDeploymentEventsResponse,
  ListDeploymentAliasesData,
  ListDeploymentAliasesError,
  ListDeploymentAliasesResponse,
  AssignAliasData,
  AssignAliasError,
  AssignAliasResponse,
  CreateRecordData,
  CreateRecordError,
  CreateRecordResponse,
  RemoveRecordData,
  RemoveRecordError,
  RemoveRecordResponse,
  UploadFileData,
  UploadFileError,
  UploadFileResponse,
  GetIntegrationLogDrainsData,
  GetIntegrationLogDrainsError,
  GetIntegrationLogDrainsResponse,
  CreateLogDrainData,
  CreateLogDrainError,
  CreateLogDrainResponse,
  DeleteSecretData,
  DeleteSecretError,
  DeleteSecretResponse,
  RenameSecretData,
  RenameSecretError,
  RenameSecretResponse,
  CreateSecretData,
  CreateSecretError,
  CreateSecretResponse,
  GetTeamsData,
  GetTeamsError,
  GetTeamsResponse,
  GetTeamData,
  GetTeamError,
  GetTeamResponse,
  PatchTeamData,
  PatchTeamError,
  PatchTeamResponse,
  GetTeamMembersData,
  GetTeamMembersError,
  GetTeamMembersResponse,
  GetAuthUserError,
  GetAuthUserResponse,
  ListUserEventsData,
  ListUserEventsError,
  ListUserEventsResponse,
  GetSecretsData,
  GetSecretsError,
  GetSecretsResponse,
  GetSecretData,
  GetSecretError,
  GetSecretResponse,
  CreateAuthTokenData,
  CreateAuthTokenError,
  CreateAuthTokenResponse,
  DeleteAuthTokenData,
  DeleteAuthTokenError,
  DeleteAuthTokenResponse,
  ListAliasesData,
  ListAliasesError,
  ListAliasesResponse,
  GetAliasData,
  GetAliasError,
  GetAliasResponse,
  BuyDomainData,
  BuyDomainError,
  BuyDomainResponse,
  CheckDomainPriceData,
  CheckDomainPriceError,
  CheckDomainPriceResponse,
  CheckDomainStatusData,
  CheckDomainStatusError,
  CheckDomainStatusResponse,
  GetRecordsData,
  GetRecordsError,
  GetRecordsResponse,
  GetDomainsData,
  GetDomainsError,
  GetDomainsResponse,
  CreateOrTransferDomainData,
  CreateOrTransferDomainError,
  CreateOrTransferDomainResponse,
  GetDomainData,
  GetDomainError,
  GetDomainResponse,
  ListAuthTokensError,
  ListAuthTokensResponse,
  GetAuthTokenData,
  GetAuthTokenError,
  GetAuthTokenResponse,
  GetDeploymentsData,
  GetDeploymentsError,
  GetDeploymentsResponse,
  ListDeploymentFilesData,
  ListDeploymentFilesError,
  ListDeploymentFilesResponse,
  GetDeploymentFileContentsData,
  DeleteDomainData,
  DeleteDomainError,
  DeleteDomainResponse,
  GetDomainConfigData,
  GetDomainConfigError,
  GetDomainConfigResponse,
  IssueCertData,
  IssueCertError,
  IssueCertResponse,
  UploadCertData,
  UploadCertError,
  UploadCertResponse,
  RemoveCertData,
  RemoveCertError,
  RemoveCertResponse,
  GetCertByIdData,
  GetCertByIdError,
  GetCertByIdResponse,
  ArtifactQueryData,
  RecordEventsData,
  RecordEventsError,
  RecordEventsResponse,
  StatusData,
  DownloadArtifactData,
  ArtifactExistsData,
  UploadArtifactData,
  GetProjectsData,
  GetProjectsError,
  GetProjectsResponse,
  CreateProjectData,
  CreateProjectError,
  CreateProjectResponse,
  DeleteProjectData,
  DeleteProjectError,
  DeleteProjectResponse,
  GetProjectData,
  GetProjectError,
  GetProjectResponse,
  UpdateProjectData,
  UpdateProjectError,
  UpdateProjectResponse,
  GetProjectDomainsData,
  GetProjectDomainsError,
  GetProjectDomainsResponse,
  RemoveProjectDomainData,
  RemoveProjectDomainError,
  RemoveProjectDomainResponse,
  GetProjectDomainData,
  GetProjectDomainError,
  GetProjectDomainResponse,
  UpdateProjectDomainData,
  UpdateProjectDomainError,
  UpdateProjectDomainResponse,
  VerifyProjectDomainData,
  VerifyProjectDomainError,
  VerifyProjectDomainResponse,
  FilterProjectEnvsData,
  FilterProjectEnvsError,
  FilterProjectEnvsResponse,
  RemoveProjectEnvData,
  RemoveProjectEnvError,
  RemoveProjectEnvResponse,
  EditProjectEnvData,
  EditProjectEnvError,
  EditProjectEnvResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Login with email
 * Request a new login for a user to get a token. This will respond with a verification token and send an email to confirm the request. Once confirmed you can use the verification token to get an authentication token.
 */
export const emailLogin = <ThrowOnError extends boolean = false>(options?: Options<EmailLoginData, ThrowOnError>) => {
  return (options?.client ?? client).post<EmailLoginResponse, EmailLoginError, ThrowOnError>({
    ...options,
    url: '/registration',
  });
};

/**
 * Verify a login request to get an authentication token
 * Verify the user accepted the login request and get a authentication token. The user email address and the token received after requesting the login must be added to the URL as a query string with the names `email` and `token`.
 */
export const verifyToken = <ThrowOnError extends boolean = false>(options: Options<VerifyTokenData, ThrowOnError>) => {
  return (options?.client ?? client).get<VerifyTokenResponse, VerifyTokenError, ThrowOnError>({
    ...options,
    url: '/registration/verify',
  });
};

/**
 * Retrieve a list of all checks
 * List all of the checks created for a deployment.
 */
export const getAllChecks = <ThrowOnError extends boolean = false>(
  options: Options<GetAllChecksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAllChecksResponse, GetAllChecksError, ThrowOnError>({
    ...options,
    url: '/v1/deployments/{deploymentId}/checks',
  });
};

/**
 * Creates a new Check
 * Creates a new check. This endpoint must be called with an OAuth2 or it will produce a 400 error.
 */
export const createCheck = <ThrowOnError extends boolean = false>(options: Options<CreateCheckData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateCheckResponse, CreateCheckError, ThrowOnError>({
    ...options,
    url: '/v1/deployments/{deploymentId}/checks',
  });
};

/**
 * Get a single check
 * Return a detailed response for a single check.
 */
export const getCheck = <ThrowOnError extends boolean = false>(options: Options<GetCheckData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetCheckResponse, GetCheckError, ThrowOnError>({
    ...options,
    url: '/v1/deployments/{deploymentId}/checks/{checkId}',
  });
};

/**
 * Update a check
 * Update an existing check. This endpoint must be called with an OAuth2 or it will produce a 400 error.
 */
export const updateCheck = <ThrowOnError extends boolean = false>(options: Options<UpdateCheckData, ThrowOnError>) => {
  return (options?.client ?? client).patch<UpdateCheckResponse, UpdateCheckError, ThrowOnError>({
    ...options,
    url: '/v1/deployments/{deploymentId}/checks/{checkId}',
  });
};

/**
 * Rerequest a check
 * Rerequest a selected check that has failed.
 */
export const rerequestCheck = <ThrowOnError extends boolean = false>(
  options: Options<RerequestCheckData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RerequestCheckResponse, RerequestCheckError, ThrowOnError>({
    ...options,
    url: '/v1/deployments/{deploymentId}/checks/{checkId}/rerequest',
  });
};

/**
 * Update an existing DNS record
 * Updates an existing DNS record for a domain name.
 */
export const updateRecord = <ThrowOnError extends boolean = false>(
  options: Options<UpdateRecordData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateRecordResponse, UpdateRecordError, ThrowOnError>({
    ...options,
    url: '/v1/domains/records/{recordId}',
  });
};

/**
 * Get Edge Configs
 * Returns all Edge Configs.
 */
export const getEdgeConfigs = <ThrowOnError extends boolean = false>(
  options?: Options<GetEdgeConfigsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetEdgeConfigsResponse, GetEdgeConfigsError, ThrowOnError>({
    ...options,
    url: '/v1/edge-config',
  });
};

/**
 * Create an Edge Config
 * Creates an Edge Config.
 */
export const createEdgeConfig = <ThrowOnError extends boolean = false>(
  options?: Options<CreateEdgeConfigData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateEdgeConfigResponse, CreateEdgeConfigError, ThrowOnError>({
    ...options,
    url: '/v1/edge-config',
  });
};

/**
 * Delete an Edge Config
 * Delete an Edge Config by id.
 */
export const deleteEdgeConfig = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEdgeConfigData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteEdgeConfigResponse, DeleteEdgeConfigError, ThrowOnError>({
    ...options,
    url: '/v1/edge-config/{edgeConfigId}',
  });
};

/**
 * Get an Edge Config
 * Returns an Edge Config.
 */
export const getEdgeConfig = <ThrowOnError extends boolean = false>(
  options: Options<GetEdgeConfigData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetEdgeConfigResponse, GetEdgeConfigError, ThrowOnError>({
    ...options,
    url: '/v1/edge-config/{edgeConfigId}',
  });
};

/**
 * Update an Edge Config
 * Updates an Edge Config.
 */
export const updateEdgeConfig = <ThrowOnError extends boolean = false>(
  options: Options<UpdateEdgeConfigData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateEdgeConfigResponse, UpdateEdgeConfigError, ThrowOnError>({
    ...options,
    url: '/v1/edge-config/{edgeConfigId}',
  });
};

/**
 * Get an Edge Config item
 * Returns a specific Edge Config Item.
 */
export const getEdgeConfigItem = <ThrowOnError extends boolean = false>(
  options: Options<GetEdgeConfigItemData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetEdgeConfigItemResponse, GetEdgeConfigItemError, ThrowOnError>({
    ...options,
    url: '/v1/edge-config/{edgeConfigId}/item/{edgeConfigItemKey}',
  });
};

/**
 * Get Edge Config items
 * Returns all items of an Edge Config.
 */
export const getEdgeConfigItems = <ThrowOnError extends boolean = false>(
  options: Options<GetEdgeConfigItemsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetEdgeConfigItemsResponse, GetEdgeConfigItemsError, ThrowOnError>({
    ...options,
    url: '/v1/edge-config/{edgeConfigId}/items',
  });
};

/**
 * Update Edge Config items in batch
 * Update multiple Edge Config Items in batch.
 */
export const patchtEdgeConfigItems = <ThrowOnError extends boolean = false>(
  options: Options<PatchtEdgeConfigItemsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchtEdgeConfigItemsResponse, PatchtEdgeConfigItemsError, ThrowOnError>({
    ...options,
    url: '/v1/edge-config/{edgeConfigId}/items',
  });
};

/**
 * Create an Edge Config token
 * Adds a token to an existing Edge Config.
 */
export const createEdgeConfigToken = <ThrowOnError extends boolean = false>(
  options: Options<CreateEdgeConfigTokenData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateEdgeConfigTokenResponse, CreateEdgeConfigTokenError, ThrowOnError>({
    ...options,
    url: '/v1/edge-config/{edgeConfigId}/token',
  });
};

/**
 * Get Edge Config token meta data
 * Return meta data about an Edge Config token.
 */
export const getEdgeConfigToken = <ThrowOnError extends boolean = false>(
  options: Options<GetEdgeConfigTokenData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetEdgeConfigTokenResponse, GetEdgeConfigTokenError, ThrowOnError>({
    ...options,
    url: '/v1/edge-config/{edgeConfigId}/token/{token}',
  });
};

/**
 * Delete one or more Edge Config tokens
 * Deletes one or more tokens of an existing Edge Config.
 */
export const deleteEdgeConfigTokens = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEdgeConfigTokensData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteEdgeConfigTokensResponse, DeleteEdgeConfigTokensError, ThrowOnError>({
    ...options,
    url: '/v1/edge-config/{edgeConfigId}/tokens',
  });
};

/**
 * Get all tokens of an Edge Config
 * Returns all tokens of an Edge Config.
 */
export const getEdgeConfigTokens = <ThrowOnError extends boolean = false>(
  options: Options<GetEdgeConfigTokensData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetEdgeConfigTokensResponse, GetEdgeConfigTokensError, ThrowOnError>({
    ...options,
    url: '/v1/edge-config/{edgeConfigId}/tokens',
  });
};

/**
 * Delete an integration configuration
 * Allows to remove the configuration with the `id` provided in the parameters. The configuration and all of its resources will be removed. This includes Webhooks, LogDrains and Project Env variables.
 */
export const deleteConfiguration = <ThrowOnError extends boolean = false>(
  options: Options<DeleteConfigurationData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteConfigurationResponse, DeleteConfigurationError, ThrowOnError>({
    ...options,
    url: '/v1/integrations/configuration/{id}',
  });
};

/**
 * Retrieve an integration configuration
 * Allows to retrieve a the configuration with the provided id in case it exists. The authenticated user or team must be the owner of the config in order to access it.
 */
export const getConfiguration = <ThrowOnError extends boolean = false>(
  options: Options<GetConfigurationData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetConfigurationResponse, GetConfigurationError, ThrowOnError>({
    ...options,
    url: '/v1/integrations/configuration/{id}',
  });
};

/**
 * Get configurations for the authenticated user or team
 * Allows to retrieve all configurations for an authenticated integration. When the `project` view is used, configurations generated for the authorization flow will be filtered out of the results.
 */
export const getConfigurations = <ThrowOnError extends boolean = false>(
  options: Options<GetConfigurationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetConfigurationsResponse, GetConfigurationsError, ThrowOnError>({
    ...options,
    url: '/v1/integrations/configurations',
  });
};

/**
 * List git namespaces by provider
 * Lists git namespaces for a supported provider. Supported providers are `github`, `gitlab` and `bitbucket`. If the provider is not provided, it will try to obtain it from the user that authenticated the request.
 */
export const gitNamespaces = <ThrowOnError extends boolean = false>(
  options?: Options<GitNamespacesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GitNamespacesResponse, GitNamespacesError, ThrowOnError>({
    ...options,
    url: '/v1/integrations/git-namespaces',
  });
};

/**
 * Deletes the Integration log drain with the provided `id`
 * Deletes the Integration log drain with the provided `id`. When using an OAuth2 Token, the log drain can be deleted only if the integration owns it.
 */
export const deleteIntegrationLogDrain = <ThrowOnError extends boolean = false>(
  options: Options<DeleteIntegrationLogDrainData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteIntegrationLogDrainResponse,
    DeleteIntegrationLogDrainError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/integrations/log-drains/{id}',
  });
};

/**
 * List git repositories linked to namespace by provider
 * Lists git repositories linked to a namespace `id` for a supported provider. A specific namespace `id` can be obtained via the `git-namespaces`  endpoint. Supported providers are `github`, `gitlab` and `bitbucket`. If the provider or namespace is not provided, it will try to obtain it from the user that authenticated the request.
 */
export const getV1IntegrationsSearchRepo = <ThrowOnError extends boolean = false>(
  options?: Options<GetV1IntegrationsSearchRepoData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1IntegrationsSearchRepoResponse,
    GetV1IntegrationsSearchRepoError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/integrations/search-repo',
  });
};

/**
 * Retrieves a list of Configurable Log Drains
 * Retrieves a list of Configurable Log Drains. This endpoint must be called with a team AccessToken (integration OAuth2 clients are not allowed). Only log drains owned by the authenticated team can be accessed.
 */
export const getConfigurableLogDrains = <ThrowOnError extends boolean = false>(
  options?: Options<GetConfigurableLogDrainsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetConfigurableLogDrainsResponse, GetConfigurableLogDrainsError, ThrowOnError>(
    {
      ...options,
      url: '/v1/log-drains',
    },
  );
};

/**
 * Creates a Configurable Log Drain
 * Creates a configurable log drain. This endpoint must be called with a team AccessToken (integration OAuth2 clients are not allowed)
 */
export const createConfigurableLogDrain = <ThrowOnError extends boolean = false>(
  options?: Options<CreateConfigurableLogDrainData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateConfigurableLogDrainResponse,
    CreateConfigurableLogDrainError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/log-drains',
  });
};

/**
 * Deletes a Configurable Log Drain
 * Deletes a Configurable Log Drain. This endpoint must be called with a team AccessToken (integration OAuth2 clients are not allowed). Only log drains owned by the authenticated team can be deleted.
 */
export const deleteConfigurableLogDrain = <ThrowOnError extends boolean = false>(
  options: Options<DeleteConfigurableLogDrainData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteConfigurableLogDrainResponse,
    DeleteConfigurableLogDrainError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/log-drains/{id}',
  });
};

/**
 * Retrieves a Configurable Log Drain
 * Retrieves a Configurable Log Drain. This endpoint must be called with a team AccessToken (integration OAuth2 clients are not allowed). Only log drains owned by the authenticated team can be accessed.
 */
export const getConfigurableLogDrain = <ThrowOnError extends boolean = false>(
  options: Options<GetConfigurableLogDrainData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetConfigurableLogDrainResponse, GetConfigurableLogDrainError, ThrowOnError>({
    ...options,
    url: '/v1/log-drains/{id}',
  });
};

/**
 * Retrieve the decrypted value of an environment variable of a project by id
 * Retrieve the environment variable for a given project.
 */
export const getProjectEnv = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectEnvData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetProjectEnvResponse, GetProjectEnvError, ThrowOnError>({
    ...options,
    url: '/v1/projects/{idOrName}/env/{id}',
  });
};

/**
 * Create a Team
 * Create a new Team under your account. You need to send a POST request with the desired Team slug, and optionally the Team name.
 */
export const createTeam = <ThrowOnError extends boolean = false>(options?: Options<CreateTeamData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateTeamResponse, CreateTeamError, ThrowOnError>({
    ...options,
    url: '/v1/teams',
  });
};

/**
 * Delete a Team
 * Delete a team under your account. You need to send a `DELETE` request with the desired team `id`. An optional array of reasons for deletion may also be sent.
 */
export const deleteTeam = <ThrowOnError extends boolean = false>(options: Options<DeleteTeamData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteTeamResponse, DeleteTeamError, ThrowOnError>({
    ...options,
    url: '/v1/teams/{teamId}',
  });
};

/**
 * Delete a Team invite code
 * Delete an active Team invite code.
 */
export const deleteTeamInviteCode = <ThrowOnError extends boolean = false>(
  options: Options<DeleteTeamInviteCodeData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteTeamInviteCodeResponse, DeleteTeamInviteCodeError, ThrowOnError>({
    ...options,
    url: '/v1/teams/{teamId}/invites/{inviteId}',
  });
};

/**
 * Invite a user
 * Invite a user to join the team specified in the URL. The authenticated user needs to be an `OWNER` in order to successfully invoke this endpoint. The user can be specified with an email or an ID. If both email and ID are provided, ID will take priority.
 */
export const inviteUserToTeam = <ThrowOnError extends boolean = false>(
  options: Options<InviteUserToTeamData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<InviteUserToTeamResponse, InviteUserToTeamError, ThrowOnError>({
    ...options,
    url: '/v1/teams/{teamId}/members',
  });
};

/**
 * Join a team
 * Join a team with a provided invite code or team ID.
 */
export const joinTeam = <ThrowOnError extends boolean = false>(options: Options<JoinTeamData, ThrowOnError>) => {
  return (options?.client ?? client).post<JoinTeamResponse, JoinTeamError, ThrowOnError>({
    ...options,
    url: '/v1/teams/{teamId}/members/teams/join',
  });
};

/**
 * Remove a Team Member
 * Remove a Team Member from the Team, or dismiss a user that requested access, or leave a team.
 */
export const removeTeamMember = <ThrowOnError extends boolean = false>(
  options: Options<RemoveTeamMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RemoveTeamMemberResponse, RemoveTeamMemberError, ThrowOnError>({
    ...options,
    url: '/v1/teams/{teamId}/members/{uid}',
  });
};

/**
 * Update a Team Member
 * Update the membership of a Team Member on the Team specified by `teamId`, such as changing the _role_ of the member, or confirming a request to join the Team for an unconfirmed member. The authenticated user must be an `OWNER` of the Team.
 */
export const updateTeamMember = <ThrowOnError extends boolean = false>(
  options: Options<UpdateTeamMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateTeamMemberResponse, UpdateTeamMemberError, ThrowOnError>({
    ...options,
    url: '/v1/teams/{teamId}/members/{uid}',
  });
};

/**
 * Request access to a team
 * Request access to a team as a member. An owner has to approve the request. Only 10 users can request access to a team at the same time.
 */
export const requestAccessToTeam = <ThrowOnError extends boolean = false>(
  options: Options<RequestAccessToTeamData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RequestAccessToTeamResponse, RequestAccessToTeamError, ThrowOnError>({
    ...options,
    url: '/v1/teams/{teamId}/request',
  });
};

/**
 * Get access request status
 * Check the status of a join request. It'll respond with a 404 if the request has been declined. If no `userId` path segment was provided, this endpoint will instead return the status of the authenticated user.
 */
export const getTeamAccessRequest = <ThrowOnError extends boolean = false>(
  options: Options<GetTeamAccessRequestData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTeamAccessRequestResponse, GetTeamAccessRequestError, ThrowOnError>({
    ...options,
    url: '/v1/teams/{teamId}/request/{userId}',
  });
};

/**
 * Delete User Account
 * Initiates the deletion process for the currently authenticated User, by sending a deletion confirmation email. The email contains a link that the user needs to visit in order to proceed with the deletion process.
 */
export const requestDelete = <ThrowOnError extends boolean = false>(
  options?: Options<RequestDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RequestDeleteResponse, RequestDeleteError, ThrowOnError>({
    ...options,
    url: '/v1/user',
  });
};

/**
 * Get a list of webhooks
 * Get a list of webhooks
 */
export const getWebhooks = <ThrowOnError extends boolean = false>(options?: Options<GetWebhooksData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetWebhooksResponse, GetWebhooksError, ThrowOnError>({
    ...options,
    url: '/v1/webhooks',
  });
};

/**
 * Creates a webhook
 * Creates a webhook
 */
export const createWebhook = <ThrowOnError extends boolean = false>(
  options?: Options<CreateWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateWebhookResponse, CreateWebhookError, ThrowOnError>({
    ...options,
    url: '/v1/webhooks',
  });
};

/**
 * Deletes a webhook
 * Deletes a webhook
 */
export const deleteWebhook = <ThrowOnError extends boolean = false>(
  options: Options<DeleteWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteWebhookResponse, DeleteWebhookError, ThrowOnError>({
    ...options,
    url: '/v1/webhooks/{id}',
  });
};

/**
 * Get a webhook
 * Get a webhook
 */
export const getWebhook = <ThrowOnError extends boolean = false>(options: Options<GetWebhookData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetWebhookResponse, GetWebhookError, ThrowOnError>({
    ...options,
    url: '/v1/webhooks/{id}',
  });
};

/**
 * Add a domain to a project
 * Add a domain to the project by passing its domain name and by specifying the project by either passing the project `id` or `name` in the URL. If the domain is not yet verified to be used on this project, the request will return `verified = false`, and the domain will need to be verified according to the `verification` challenge via `POST /projects/:idOrName/domains/:domain/verify`. If the domain already exists on the project, the request will fail with a `400` status code.
 */
export const addProjectDomain = <ThrowOnError extends boolean = false>(
  options: Options<AddProjectDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddProjectDomainResponse, AddProjectDomainError, ThrowOnError>({
    ...options,
    url: '/v10/projects/{idOrName}/domains',
  });
};

/**
 * Create one or more environment variables
 * Create one ore more environment variables for a project by passing its `key`, `value`, `type` and `target` and by specifying the project by either passing the project `id` or `name` in the URL.
 */
export const createProjectEnv = <ThrowOnError extends boolean = false>(
  options: Options<CreateProjectEnvData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateProjectEnvResponse, CreateProjectEnvError, ThrowOnError>({
    ...options,
    url: '/v10/projects/{idOrName}/env',
  });
};

/**
 * List Deployment Builds
 * Retrieves the list of builds given their deployment's unique identifier.
 */
export const listDeploymentBuilds = <ThrowOnError extends boolean = false>(
  options: Options<ListDeploymentBuildsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListDeploymentBuildsResponse, ListDeploymentBuildsError, ThrowOnError>({
    ...options,
    url: '/v11/deployments/{deploymentId}/builds',
  });
};

/**
 * Cancel a deployment
 * This endpoint allows you to cancel a deployment which is currently building, by supplying its `id` in the URL.
 */
export const cancelDeployment = <ThrowOnError extends boolean = false>(
  options: Options<CancelDeploymentData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<CancelDeploymentResponse, CancelDeploymentError, ThrowOnError>({
    ...options,
    url: '/v12/deployments/{id}/cancel',
  });
};

/**
 * Create a new deployment
 * Create a new deployment with all the required and intended data. If the deployment is not a git deployment, all files must be provided with the request, either referenced or inlined. Additionally, a deployment id can be specified to redeploy a previous deployment.
 */
export const createDeployment = <ThrowOnError extends boolean = false>(
  options?: Options<CreateDeploymentData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateDeploymentResponse, CreateDeploymentError, ThrowOnError>({
    ...options,
    url: '/v13/deployments',
  });
};

/**
 * Get a deployment by ID or URL
 * Retrieves information for a deployment either by supplying its ID (`id` property) or Hostname (`url` property). Additional details will be included when the authenticated user is an owner of the deployment.
 */
export const getDeployment = <ThrowOnError extends boolean = false>(
  options: Options<GetDeploymentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetDeploymentResponse, GetDeploymentError, ThrowOnError>({
    ...options,
    url: '/v13/deployments/{idOrUrl}',
  });
};

/**
 * Delete a Deployment
 * This API allows you to delete a deployment, either by supplying its `id` in the URL or the `url` of the deployment as a query parameter. You can obtain the ID, for example, by listing all deployments.
 */
export const deleteDeployment = <ThrowOnError extends boolean = false>(
  options: Options<DeleteDeploymentData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteDeploymentResponse, DeleteDeploymentError, ThrowOnError>({
    ...options,
    url: '/v13/deployments/{id}',
  });
};

/**
 * Delete an Alias
 * Delete an Alias with the specified ID.
 */
export const deleteAlias = <ThrowOnError extends boolean = false>(options: Options<DeleteAliasData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteAliasResponse, DeleteAliasError, ThrowOnError>({
    ...options,
    url: '/v2/aliases/{aliasId}',
  });
};

/**
 * Get deployment events
 * Get the build logs of a deployment by deployment ID and build ID. It can work as an infinite stream of logs or as a JSON endpoint depending on the input parameters.
 */
export const getDeploymentEvents = <ThrowOnError extends boolean = false>(
  options: Options<GetDeploymentEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetDeploymentEventsResponse, GetDeploymentEventsError, ThrowOnError>({
    ...options,
    url: '/v2/deployments/{idOrUrl}/events',
  });
};

/**
 * List Deployment Aliases
 * Retrieves all Aliases for the Deployment with the given ID. The authenticated User must own the deployment.
 */
export const listDeploymentAliases = <ThrowOnError extends boolean = false>(
  options: Options<ListDeploymentAliasesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListDeploymentAliasesResponse, ListDeploymentAliasesError, ThrowOnError>({
    ...options,
    url: '/v2/deployments/{id}/aliases',
  });
};

/**
 * Assign an Alias
 * Creates a new alias for the deployment with the given deployment ID. The authenticated user must own this deployment. If the desired alias is already assigned to another deployment, then it will be removed from the old deployment and assigned to the new one.
 */
export const assignAlias = <ThrowOnError extends boolean = false>(options: Options<AssignAliasData, ThrowOnError>) => {
  return (options?.client ?? client).post<AssignAliasResponse, AssignAliasError, ThrowOnError>({
    ...options,
    url: '/v2/deployments/{id}/aliases',
  });
};

/**
 * Create a DNS record
 * Creates a DNS record for a domain.
 */
export const createRecord = <ThrowOnError extends boolean = false>(
  options: Options<CreateRecordData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateRecordResponse, CreateRecordError, ThrowOnError>({
    ...options,
    url: '/v2/domains/{domain}/records',
  });
};

/**
 * Delete a DNS record
 * Removes an existing DNS record from a domain name.
 */
export const removeRecord = <ThrowOnError extends boolean = false>(
  options: Options<RemoveRecordData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RemoveRecordResponse, RemoveRecordError, ThrowOnError>({
    ...options,
    url: '/v2/domains/{domain}/records/{recordId}',
  });
};

/**
 * Upload Deployment Files
 * Before you create a deployment you need to upload the required files for that deployment. To do it, you need to first upload each file to this endpoint. Once that's completed, you can create a new deployment with the uploaded files. The file content must be placed inside the body of the request. In the case of a successful response you'll receive a status code 200 with an empty body.
 */
export const uploadFile = <ThrowOnError extends boolean = false>(options?: Options<UploadFileData, ThrowOnError>) => {
  return (options?.client ?? client).post<UploadFileResponse, UploadFileError, ThrowOnError>({
    ...options,
    url: '/v2/files',
  });
};

/**
 * Retrieves a list of Integration log drains
 * Retrieves a list of all Integration log drains that are defined for the authorized account. When using an OAuth2 token, the list is limited to log drains created by the authenticated integration.
 */
export const getIntegrationLogDrains = <ThrowOnError extends boolean = false>(
  options?: Options<GetIntegrationLogDrainsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetIntegrationLogDrainsResponse, GetIntegrationLogDrainsError, ThrowOnError>({
    ...options,
    url: '/v2/integrations/log-drains',
  });
};

/**
 * Creates a new Integration Log Drain
 * Creates an Integration log drain. This endpoint must be called with an OAuth2 client (integration), since log drains are tied to integrations. If it is called with a different token type it will produce a 400 error.
 */
export const createLogDrain = <ThrowOnError extends boolean = false>(
  options?: Options<CreateLogDrainData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateLogDrainResponse, CreateLogDrainError, ThrowOnError>({
    ...options,
    url: '/v2/integrations/log-drains',
  });
};

/**
 * Delete a secret
 * This deletes the user's secret defined in the URL.
 */
export const deleteSecret = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSecretData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteSecretResponse, DeleteSecretError, ThrowOnError>({
    ...options,
    url: '/v2/secrets/{idOrName}',
  });
};

/**
 * Change secret name
 * Enables to edit the name of a user's secret. The name has to be unique to that user's secrets.
 */
export const renameSecret = <ThrowOnError extends boolean = false>(
  options: Options<RenameSecretData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<RenameSecretResponse, RenameSecretError, ThrowOnError>({
    ...options,
    url: '/v2/secrets/{name}',
  });
};

/**
 * Create a new secret
 * Allows to create a new secret.
 */
export const createSecret = <ThrowOnError extends boolean = false>(
  options: Options<CreateSecretData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateSecretResponse, CreateSecretError, ThrowOnError>({
    ...options,
    url: '/v2/secrets/{name}',
  });
};

/**
 * List all teams
 * Get a paginated list of all the Teams the authenticated User is a member of.
 */
export const getTeams = <ThrowOnError extends boolean = false>(options?: Options<GetTeamsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetTeamsResponse, GetTeamsError, ThrowOnError>({
    ...options,
    url: '/v2/teams',
  });
};

/**
 * Get a Team
 * Get information for the Team specified by the `teamId` parameter.
 */
export const getTeam = <ThrowOnError extends boolean = false>(options: Options<GetTeamData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetTeamResponse, GetTeamError, ThrowOnError>({
    ...options,
    url: '/v2/teams/{teamId}',
  });
};

/**
 * Update a Team
 * Update the information of a Team specified by the `teamId` parameter. The request body should contain the information that will be updated on the Team.
 */
export const patchTeam = <ThrowOnError extends boolean = false>(options: Options<PatchTeamData, ThrowOnError>) => {
  return (options?.client ?? client).patch<PatchTeamResponse, PatchTeamError, ThrowOnError>({
    ...options,
    url: '/v2/teams/{teamId}',
  });
};

/**
 * List team members
 * Get a paginated list of team members for the provided team.
 */
export const getTeamMembers = <ThrowOnError extends boolean = false>(
  options: Options<GetTeamMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTeamMembersResponse, GetTeamMembersError, ThrowOnError>({
    ...options,
    url: '/v2/teams/{teamId}/members',
  });
};

/**
 * Get the User
 * Retrieves information related to the currently authenticated User.
 */
export const getAuthUser = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetAuthUserResponse, GetAuthUserError, ThrowOnError>({
    ...options,
    url: '/v2/user',
  });
};

/**
 * List User Events
 * Retrieves a list of "events" generated by the User on Vercel. Events are generated when the User performs a particular action, such as logging in, creating a deployment, and joining a Team (just to name a few). When the `teamId` parameter is supplied, then the events that are returned will be in relation to the Team that was specified.
 */
export const listUserEvents = <ThrowOnError extends boolean = false>(
  options?: Options<ListUserEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUserEventsResponse, ListUserEventsError, ThrowOnError>({
    ...options,
    url: '/v3/events',
  });
};

/**
 * List secrets
 * Retrieves the active Vercel secrets for the authenticated user. By default it returns 20 secrets. The rest can be retrieved using the pagination options. The body will contain an entry for each secret.
 */
export const getSecrets = <ThrowOnError extends boolean = false>(options?: Options<GetSecretsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetSecretsResponse, GetSecretsError, ThrowOnError>({
    ...options,
    url: '/v3/secrets',
  });
};

/**
 * Get a single secret
 * Retrieves the information for a specific secret by passing either the secret id or name in the URL.
 */
export const getSecret = <ThrowOnError extends boolean = false>(options: Options<GetSecretData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetSecretResponse, GetSecretError, ThrowOnError>({
    ...options,
    url: '/v3/secrets/{idOrName}',
  });
};

/**
 * Create an Auth Token
 * Creates and returns a new authentication token for the currently authenticated User. The `bearerToken` property is only provided once, in the response body, so be sure to save it on the client for use with API requests.
 */
export const createAuthToken = <ThrowOnError extends boolean = false>(
  options?: Options<CreateAuthTokenData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateAuthTokenResponse, CreateAuthTokenError, ThrowOnError>({
    ...options,
    url: '/v3/user/tokens',
  });
};

/**
 * Delete an authentication token
 * Invalidate an authentication token, such that it will no longer be valid for future HTTP requests.
 */
export const deleteAuthToken = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAuthTokenData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAuthTokenResponse, DeleteAuthTokenError, ThrowOnError>({
    ...options,
    url: '/v3/user/tokens/{tokenId}',
  });
};

/**
 * List aliases
 * Retrieves a list of aliases for the authenticated User or Team. When `domain` is provided, only aliases for that domain will be returned. When `projectId` is provided, it will only return the given project aliases.
 */
export const listAliases = <ThrowOnError extends boolean = false>(options?: Options<ListAliasesData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListAliasesResponse, ListAliasesError, ThrowOnError>({
    ...options,
    url: '/v4/aliases',
  });
};

/**
 * Get an Alias
 * Retrieves an Alias for the given host name or alias ID.
 */
export const getAlias = <ThrowOnError extends boolean = false>(options: Options<GetAliasData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetAliasResponse, GetAliasError, ThrowOnError>({
    ...options,
    url: '/v4/aliases/{idOrAlias}',
  });
};

/**
 * Purchase a domain
 * Allows to purchase the specified domain.
 */
export const buyDomain = <ThrowOnError extends boolean = false>(options?: Options<BuyDomainData, ThrowOnError>) => {
  return (options?.client ?? client).post<BuyDomainResponse, BuyDomainError, ThrowOnError>({
    ...options,
    url: '/v4/domains/buy',
  });
};

/**
 * Check the price for a domain
 * Check the price to purchase a domain and how long a single purchase period is.
 */
export const checkDomainPrice = <ThrowOnError extends boolean = false>(
  options: Options<CheckDomainPriceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CheckDomainPriceResponse, CheckDomainPriceError, ThrowOnError>({
    ...options,
    url: '/v4/domains/price',
  });
};

/**
 * Check a Domain Availability
 * Check if a domain name is available for purchase.
 */
export const checkDomainStatus = <ThrowOnError extends boolean = false>(
  options: Options<CheckDomainStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CheckDomainStatusResponse, CheckDomainStatusError, ThrowOnError>({
    ...options,
    url: '/v4/domains/status',
  });
};

/**
 * List existing DNS records
 * Retrieves a list of DNS records created for a domain name. By default it returns 20 records if no limit is provided. The rest can be retrieved using the pagination options.
 */
export const getRecords = <ThrowOnError extends boolean = false>(options: Options<GetRecordsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetRecordsResponse, GetRecordsError, ThrowOnError>({
    ...options,
    url: '/v4/domains/{domain}/records',
  });
};

/**
 * List all the domains
 * Retrieves a list of domains registered for the authenticating user. By default it returns the last 20 domains if no limit is provided.
 */
export const getDomains = <ThrowOnError extends boolean = false>(options?: Options<GetDomainsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetDomainsResponse, GetDomainsError, ThrowOnError>({
    ...options,
    url: '/v5/domains',
  });
};

/**
 * Register or transfer-in a new Domain
 * This endpoint is used for registering a new domain name with Vercel for the authenticating user, and also for initiating a domain transfer request from an external Registrar to Vercel.
 */
export const createOrTransferDomain = <ThrowOnError extends boolean = false>(
  options?: Options<CreateOrTransferDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateOrTransferDomainResponse, CreateOrTransferDomainError, ThrowOnError>({
    ...options,
    url: '/v5/domains',
  });
};

/**
 * Get Information for a Single Domain
 * Get information for a single domain in an account or team.
 */
export const getDomain = <ThrowOnError extends boolean = false>(options: Options<GetDomainData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetDomainResponse, GetDomainError, ThrowOnError>({
    ...options,
    url: '/v5/domains/{domain}',
  });
};

/**
 * List Auth Tokens
 * Retrieve a list of the current User's authentication tokens.
 */
export const listAuthTokens = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<ListAuthTokensResponse, ListAuthTokensError, ThrowOnError>({
    ...options,
    url: '/v5/user/tokens',
  });
};

/**
 * Get Auth Token Metadata
 * Retrieve metadata about an authentication token belonging to the currently authenticated User.
 */
export const getAuthToken = <ThrowOnError extends boolean = false>(
  options: Options<GetAuthTokenData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAuthTokenResponse, GetAuthTokenError, ThrowOnError>({
    ...options,
    url: '/v5/user/tokens/{tokenId}',
  });
};

/**
 * List deployments
 * List deployments under the account corresponding to the API token. If a deployment hasn't finished uploading (is incomplete), the `url` property will have a value of `null`.
 */
export const getDeployments = <ThrowOnError extends boolean = false>(
  options?: Options<GetDeploymentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetDeploymentsResponse, GetDeploymentsError, ThrowOnError>({
    ...options,
    url: '/v6/deployments',
  });
};

/**
 * List Deployment Files
 * Allows to retrieve the file structure of a deployment by supplying the deployment unique identifier.
 */
export const listDeploymentFiles = <ThrowOnError extends boolean = false>(
  options: Options<ListDeploymentFilesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListDeploymentFilesResponse, ListDeploymentFilesError, ThrowOnError>({
    ...options,
    url: '/v6/deployments/{id}/files',
  });
};

/**
 * Get Deployment File Contents
 * Allows to retrieve the content of a file by supplying the file identifier and the deployment unique identifier. The response body will contain the raw content of the file.
 */
export const getDeploymentFileContents = <ThrowOnError extends boolean = false>(
  options: Options<GetDeploymentFileContentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<void, unknown, ThrowOnError>({
    ...options,
    url: '/v6/deployments/{id}/files/{fileId}',
  });
};

/**
 * Remove a domain by name
 * Delete a previously registered domain name from Vercel. Deleting a domain will automatically remove any associated aliases.
 */
export const deleteDomain = <ThrowOnError extends boolean = false>(
  options: Options<DeleteDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteDomainResponse, DeleteDomainError, ThrowOnError>({
    ...options,
    url: '/v6/domains/{domain}',
  });
};

/**
 * Get a Domain's configuration
 * Get a Domain's configuration.
 */
export const getDomainConfig = <ThrowOnError extends boolean = false>(
  options: Options<GetDomainConfigData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetDomainConfigResponse, GetDomainConfigError, ThrowOnError>({
    ...options,
    url: '/v6/domains/{domain}/config',
  });
};

/**
 * Issue a new cert
 * Issue a new cert
 */
export const issueCert = <ThrowOnError extends boolean = false>(options?: Options<IssueCertData, ThrowOnError>) => {
  return (options?.client ?? client).post<IssueCertResponse, IssueCertError, ThrowOnError>({
    ...options,
    url: '/v7/certs',
  });
};

/**
 * Upload a cert
 * Upload a cert
 */
export const uploadCert = <ThrowOnError extends boolean = false>(options?: Options<UploadCertData, ThrowOnError>) => {
  return (options?.client ?? client).put<UploadCertResponse, UploadCertError, ThrowOnError>({
    ...options,
    url: '/v7/certs',
  });
};

/**
 * Remove cert
 * Remove cert
 */
export const removeCert = <ThrowOnError extends boolean = false>(options: Options<RemoveCertData, ThrowOnError>) => {
  return (options?.client ?? client).delete<RemoveCertResponse, RemoveCertError, ThrowOnError>({
    ...options,
    url: '/v7/certs/{id}',
  });
};

/**
 * Get cert by id
 * Get cert by id
 */
export const getCertById = <ThrowOnError extends boolean = false>(options: Options<GetCertByIdData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetCertByIdResponse, GetCertByIdError, ThrowOnError>({
    ...options,
    url: '/v7/certs/{id}',
  });
};

/**
 * Query information about an artifact
 * Query information about an array of artifacts.
 */
export const artifactQuery = <ThrowOnError extends boolean = false>(
  options?: Options<ArtifactQueryData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<void, unknown, ThrowOnError>({
    ...options,
    url: '/v8/artifacts',
  });
};

/**
 * Record an artifacts cache usage event
 * Records an artifacts cache usage event. The body of this request is an array of cache usage events. The supported event types are `HIT` and `MISS`. The source is either `LOCAL` the cache event was on the users filesystem cache or `REMOTE` if the cache event is for a remote cache. When the event is a `HIT` the request also accepts a number `duration` which is the time taken to generate the artifact in the cache.
 */
export const recordEvents = <ThrowOnError extends boolean = false>(
  options?: Options<RecordEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RecordEventsResponse, RecordEventsError, ThrowOnError>({
    ...options,
    url: '/v8/artifacts/events',
  });
};

/**
 * Get status of Remote Caching for this principal
 * Check the status of Remote Caching for this principal. Returns a JSON-encoded status indicating if Remote Caching is enabled, disabled, or disabled due to usage limits.
 */
export const status = <ThrowOnError extends boolean = false>(options?: Options<StatusData, ThrowOnError>) => {
  return (options?.client ?? client).get<void, unknown, ThrowOnError>({
    ...options,
    url: '/v8/artifacts/status',
  });
};

/**
 * Download a cache artifact
 * Downloads a cache artifact indentified by its `hash` specified on the request path. The artifact is downloaded as an octet-stream. The client should verify the content-length header and response body.
 */
export const downloadArtifact = <ThrowOnError extends boolean = false>(
  options: Options<DownloadArtifactData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<void, unknown, ThrowOnError>({
    ...options,
    url: '/v8/artifacts/{hash}',
  });
};

/**
 * Check if a cache artifact exists
 * Check that a cache artifact with the given `hash` exists. This request returns response headers only and is equivalent to a `GET` request to this endpoint where the response contains no body.
 */
export const artifactExists = <ThrowOnError extends boolean = false>(
  options: Options<ArtifactExistsData, ThrowOnError>,
) => {
  return (options?.client ?? client).head<void, unknown, ThrowOnError>({
    ...options,
    url: '/v8/artifacts/{hash}',
  });
};

/**
 * Upload a cache artifact
 * Uploads a cache artifact identified by the `hash` specified on the path. The cache artifact can then be downloaded with the provided `hash`.
 */
export const uploadArtifact = <ThrowOnError extends boolean = false>({
  body,
  ...options
}: Options<UploadArtifactData, ThrowOnError>) => {
  return (options?.client ?? client).put<void, unknown, ThrowOnError>({
    ...options,
    url: '/v8/artifacts/{hash}',
  });
};

/**
 * Retrieve a list of projects
 * Allows to retrieve the list of projects of the authenticated user. The list will be paginated and the provided query parameters allow filtering the returned projects.
 */
export const getProjects = <ThrowOnError extends boolean = false>(options?: Options<GetProjectsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetProjectsResponse, GetProjectsError, ThrowOnError>({
    ...options,
    url: '/v9/projects',
  });
};

/**
 * Create a new project
 * Allows to create a new project with the provided configuration. It only requires the project `name` but more configuration can be provided to override the defaults.
 */
export const createProject = <ThrowOnError extends boolean = false>(
  options?: Options<CreateProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateProjectResponse, CreateProjectError, ThrowOnError>({
    ...options,
    url: '/v9/projects',
  });
};

/**
 * Delete a Project
 * Delete a specific project by passing either the project `id` or `name` in the URL.
 */
export const deleteProject = <ThrowOnError extends boolean = false>(
  options: Options<DeleteProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteProjectResponse, DeleteProjectError, ThrowOnError>({
    ...options,
    url: '/v9/projects/{idOrName}',
  });
};

/**
 * Find a project by id or name
 * Get the information for a specific project by passing either the project `id` or `name` in the URL.
 */
export const getProject = <ThrowOnError extends boolean = false>(options: Options<GetProjectData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetProjectResponse, GetProjectError, ThrowOnError>({
    ...options,
    url: '/v9/projects/{idOrName}',
  });
};

/**
 * Update an existing project
 * Update the fields of a project using either its `name` or `id`.
 */
export const updateProject = <ThrowOnError extends boolean = false>(
  options: Options<UpdateProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateProjectResponse, UpdateProjectError, ThrowOnError>({
    ...options,
    url: '/v9/projects/{idOrName}',
  });
};

/**
 * Retrieve project domains by project by id or name
 * Retrieve the domains associated with a given project by passing either the project `id` or `name` in the URL.
 */
export const getProjectDomains = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectDomainsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetProjectDomainsResponse, GetProjectDomainsError, ThrowOnError>({
    ...options,
    url: '/v9/projects/{idOrName}/domains',
  });
};

/**
 * Remove a domain from a project
 * Remove a domain from a project by passing the domain name and by specifying the project by either passing the project `id` or `name` in the URL.
 */
export const removeProjectDomain = <ThrowOnError extends boolean = false>(
  options: Options<RemoveProjectDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RemoveProjectDomainResponse, RemoveProjectDomainError, ThrowOnError>({
    ...options,
    url: '/v9/projects/{idOrName}/domains/{domain}',
  });
};

/**
 * Get a project domain
 * Get project domain by project id/name and domain name.
 */
export const getProjectDomain = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetProjectDomainResponse, GetProjectDomainError, ThrowOnError>({
    ...options,
    url: '/v9/projects/{idOrName}/domains/{domain}',
  });
};

/**
 * Update a project domain
 * Update a project domain's configuration, including the name, git branch and redirect of the domain.
 */
export const updateProjectDomain = <ThrowOnError extends boolean = false>(
  options: Options<UpdateProjectDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateProjectDomainResponse, UpdateProjectDomainError, ThrowOnError>({
    ...options,
    url: '/v9/projects/{idOrName}/domains/{domain}',
  });
};

/**
 * Verify project domain
 * Attempts to verify a project domain with `verified = false` by checking the correctness of the project domain's `verification` challenge.
 */
export const verifyProjectDomain = <ThrowOnError extends boolean = false>(
  options: Options<VerifyProjectDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<VerifyProjectDomainResponse, VerifyProjectDomainError, ThrowOnError>({
    ...options,
    url: '/v9/projects/{idOrName}/domains/{domain}/verify',
  });
};

/**
 * Retrieve the environment variables of a project by id or name
 * Retrieve the environment variables for a given project by passing either the project `id` or `name` in the URL.
 */
export const filterProjectEnvs = <ThrowOnError extends boolean = false>(
  options: Options<FilterProjectEnvsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FilterProjectEnvsResponse, FilterProjectEnvsError, ThrowOnError>({
    ...options,
    url: '/v9/projects/{idOrName}/env',
  });
};

/**
 * Remove an environment variable
 * Delete a specific environment variable for a given project by passing the environment variable identifier and either passing the project `id` or `name` in the URL.
 */
export const removeProjectEnv = <ThrowOnError extends boolean = false>(
  options: Options<RemoveProjectEnvData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RemoveProjectEnvResponse, RemoveProjectEnvError, ThrowOnError>({
    ...options,
    url: '/v9/projects/{idOrName}/env/{id}',
  });
};

/**
 * Edit an environment variable
 * Edit a specific environment variable for a given project by passing the environment variable identifier and either passing the project `id` or `name` in the URL.
 */
export const editProjectEnv = <ThrowOnError extends boolean = false>(
  options: Options<EditProjectEnvData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<EditProjectEnvResponse, EditProjectEnvError, ThrowOnError>({
    ...options,
    url: '/v9/projects/{idOrName}/env/{id}',
  });
};
