// Generated by ts-to-zod
import { z } from 'zod';

export const externalUrlObjectSchema = z.object({
  spotify: z.string().optional(),
});

export const trackRestrictionObjectSchema = z.object({
  reason: z.string().optional(),
});

export const albumRestrictionObjectSchema = z.object({
  reason: z.union([z.literal('market'), z.literal('product'), z.literal('explicit')]).optional(),
});

export const reasonSchema = z.union([z.literal('market'), z.literal('product'), z.literal('explicit')]);

export const episodeRestrictionObjectSchema = z.object({
  reason: z.string().optional(),
});

export const chapterRestrictionObjectSchema = z.object({
  reason: z.string().optional(),
});

export const followersObjectSchema = z.object({
  href: z.string().optional().nullable(),
  total: z.number().optional(),
});

export const imageObjectSchema = z.object({
  url: z.string(),
  height: z.number().nullable(),
  width: z.number().nullable(),
});

export const typeSchema = z.literal('artist');

export const simplifiedArtistObjectSchema = z.object({
  external_urls: externalUrlObjectSchema.optional(),
  href: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  type: z.literal('artist').optional(),
  uri: z.string().optional(),
});

export const contextObjectSchema = z.object({
  type: z.string().optional(),
  href: z.string().optional(),
  external_urls: externalUrlObjectSchema.optional(),
  uri: z.string().optional(),
});

export const playlistUserObjectSchema = z.object({
  external_urls: externalUrlObjectSchema.optional(),
  followers: followersObjectSchema.optional(),
  href: z.string().optional(),
  id: z.string().optional(),
  type: z.literal('user').optional(),
  uri: z.string().optional(),
});

export const deviceObjectSchema = z.object({
  id: z.string().optional().nullable(),
  is_active: z.boolean().optional(),
  is_private_session: z.boolean().optional(),
  is_restricted: z.boolean().optional(),
  name: z.string().optional(),
  type: z.string().optional(),
  volume_percent: z.number().optional().nullable(),
  supports_volume: z.boolean().optional(),
});

export const disallowsObjectSchema = z.object({
  interrupting_playback: z.boolean().optional(),
  pausing: z.boolean().optional(),
  resuming: z.boolean().optional(),
  seeking: z.boolean().optional(),
  skipping_next: z.boolean().optional(),
  skipping_prev: z.boolean().optional(),
  toggling_repeat_context: z.boolean().optional(),
  toggling_shuffle: z.boolean().optional(),
  toggling_repeat_track: z.boolean().optional(),
  transferring_playback: z.boolean().optional(),
});

export const errorObjectSchema = z.object({
  status: z.number(),
  message: z.string(),
});

export const explicitContentSettingsObjectSchema = z.object({
  filter_enabled: z.boolean().optional(),
  filter_locked: z.boolean().optional(),
});

export const publicUserObjectSchema = z.object({
  display_name: z.string().optional().nullable(),
  external_urls: externalUrlObjectSchema.optional(),
  followers: followersObjectSchema.optional(),
  href: z.string().optional(),
  id: z.string().optional(),
  images: z.array(imageObjectSchema).optional(),
  type: z.literal('user').optional(),
  uri: z.string().optional(),
});

export const type2Schema = z.literal('user');

export const loudnessSchema = z.number();

export const tempoSchema = z.number();

export const timeSignatureSchema = z.number();

export const keySchema = z.number();

export const modeSchema = z.number();

export const timeIntervalObjectSchema = z.object({
  start: z.number().optional(),
  duration: z.number().optional(),
  confidence: z.number().optional(),
});

export const sectionObjectSchema = z.object({
  start: z.number().optional(),
  duration: z.number().optional(),
  confidence: z.number().optional(),
  loudness: z.number().optional(),
  tempo: z.number().optional(),
  tempo_confidence: z.number().optional(),
  key: z.number().optional(),
  key_confidence: z.number().optional(),
  mode: z.union([z.literal(-1), z.literal(0), z.literal(1)]).optional(),
  mode_confidence: z.number().optional(),
  time_signature: timeSignatureSchema.optional(),
  time_signature_confidence: z.number().optional(),
});

export const segmentObjectSchema = z.object({
  start: z.number().optional(),
  duration: z.number().optional(),
  confidence: z.number().optional(),
  loudness_start: z.number().optional(),
  loudness_max: z.number().optional(),
  loudness_max_time: z.number().optional(),
  loudness_end: z.number().optional(),
  pitches: z.array(z.number()).optional(),
  timbre: z.array(z.number()).optional(),
});

export const audioFeaturesObjectSchema = z.object({
  acousticness: z.number().optional(),
  analysis_url: z.string().optional(),
  danceability: z.number().optional(),
  duration_ms: z.number().optional(),
  energy: z.number().optional(),
  id: z.string().optional(),
  instrumentalness: z.number().optional(),
  key: keySchema.optional(),
  liveness: z.number().optional(),
  loudness: loudnessSchema.optional(),
  mode: modeSchema.optional(),
  speechiness: z.number().optional(),
  tempo: tempoSchema.optional(),
  time_signature: timeSignatureSchema.optional(),
  track_href: z.string().optional(),
  type: z.literal('audio_features').optional(),
  uri: z.string().optional(),
  valence: z.number().optional(),
});

export const type3Schema = z.literal('audio_features');

export const linkedTrackObjectSchema = z.object({
  external_urls: externalUrlObjectSchema.optional(),
  href: z.string().optional(),
  id: z.string().optional(),
  type: z.string().optional(),
  uri: z.string().optional(),
});

export const cursorObjectSchema = z.object({
  after: z.string().optional(),
  before: z.string().optional(),
});

export const cursorPagingObjectSchema = z.object({
  href: z.string().optional(),
  limit: z.number().optional(),
  next: z.string().optional(),
  cursors: cursorObjectSchema.optional(),
  total: z.number().optional(),
});

export const artistObjectSchema = z.object({
  external_urls: externalUrlObjectSchema.optional(),
  followers: followersObjectSchema.optional(),
  genres: z.array(z.string()).optional(),
  href: z.string().optional(),
  id: z.string().optional(),
  images: z.array(imageObjectSchema).optional(),
  name: z.string().optional(),
  popularity: z.number().optional(),
  type: z.literal('artist').optional(),
  uri: z.string().optional(),
});

export const pagingObjectSchema = z.object({
  href: z.string(),
  limit: z.number(),
  next: z.string().nullable(),
  offset: z.number(),
  previous: z.string().nullable(),
  total: z.number(),
});

export const simplifiedTrackObjectSchema = z.object({
  artists: z.array(simplifiedArtistObjectSchema).optional(),
  available_markets: z.array(z.string()).optional(),
  disc_number: z.number().optional(),
  duration_ms: z.number().optional(),
  explicit: z.boolean().optional(),
  external_urls: externalUrlObjectSchema.optional(),
  href: z.string().optional(),
  id: z.string().optional(),
  is_playable: z.boolean().optional(),
  linked_from: linkedTrackObjectSchema.optional(),
  restrictions: trackRestrictionObjectSchema.optional(),
  name: z.string().optional(),
  preview_url: z.string().optional().nullable(),
  track_number: z.number().optional(),
  type: z.string().optional(),
  uri: z.string().optional(),
  is_local: z.boolean().optional(),
});

export const pagingArtistObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(artistObjectSchema).optional(),
  }),
);

export const recommendationSeedObjectSchema = z.object({
  afterFilteringSize: z.number().optional(),
  afterRelinkingSize: z.number().optional(),
  href: z.string().optional(),
  id: z.string().optional(),
  initialPoolSize: z.number().optional(),
  type: z.string().optional(),
});

export const playlistOwnerObjectSchema = playlistUserObjectSchema.and(
  z.object({
    display_name: z.string().optional().nullable(),
  }),
);

export const playlistTracksRefObjectSchema = z.object({
  href: z.string().optional(),
  total: z.number().optional(),
});

export const categoryObjectSchema = z.object({
  href: z.string(),
  icons: z.array(imageObjectSchema),
  id: z.string(),
  name: z.string(),
});

export const externalIdObjectSchema = z.object({
  isrc: z.string().optional(),
  ean: z.string().optional(),
  upc: z.string().optional(),
});

export const type4Schema = z.literal('track');

export const resumePointObjectSchema = z.object({
  fully_played: z.boolean().optional(),
  resume_position_ms: z.number().optional(),
});

export const releaseDatePrecisionSchema = z.union([z.literal('year'), z.literal('month'), z.literal('day')]);

export const type5Schema = z.literal('episode');

export const copyrightObjectSchema = z.object({
  text: z.string().optional(),
  type: z.string().optional(),
});

export const type6Schema = z.literal('show');

export const showBaseSchema = z.object({
  available_markets: z.array(z.string()),
  copyrights: z.array(copyrightObjectSchema),
  description: z.string(),
  html_description: z.string(),
  explicit: z.boolean(),
  external_urls: externalUrlObjectSchema,
  href: z.string(),
  id: z.string(),
  images: z.array(imageObjectSchema),
  is_externally_hosted: z.boolean(),
  languages: z.array(z.string()),
  media_type: z.string(),
  name: z.string(),
  publisher: z.string(),
  type: z.literal('show'),
  uri: z.string(),
  total_episodes: z.number(),
});

export const simplifiedShowObjectSchema = showBaseSchema.and(z.record(z.unknown()));

export const authorObjectSchema = z.object({
  name: z.string().optional(),
});

export const narratorObjectSchema = z.object({
  name: z.string().optional(),
});

export const type7Schema = z.literal('audiobook');

export const audiobookBaseSchema = z.object({
  authors: z.array(authorObjectSchema),
  available_markets: z.array(z.string()),
  copyrights: z.array(copyrightObjectSchema),
  description: z.string(),
  html_description: z.string(),
  edition: z.string().optional(),
  explicit: z.boolean(),
  external_urls: externalUrlObjectSchema,
  href: z.string(),
  id: z.string(),
  images: z.array(imageObjectSchema),
  languages: z.array(z.string()),
  media_type: z.string(),
  name: z.string(),
  narrators: z.array(narratorObjectSchema),
  publisher: z.string(),
  type: z.literal('audiobook'),
  uri: z.string(),
  total_chapters: z.number(),
});

export const simplifiedAudiobookObjectSchema = audiobookBaseSchema.and(z.record(z.unknown()));

export const albumBaseSchema = z.object({
  album_type: z.union([z.literal('album'), z.literal('single'), z.literal('compilation')]),
  total_tracks: z.number(),
  available_markets: z.array(z.string()),
  external_urls: externalUrlObjectSchema,
  href: z.string(),
  id: z.string(),
  images: z.array(imageObjectSchema),
  name: z.string(),
  release_date: z.string(),
  release_date_precision: z.union([z.literal('year'), z.literal('month'), z.literal('day')]),
  restrictions: albumRestrictionObjectSchema.optional(),
  type: z.literal('album'),
  uri: z.string(),
});

export const albumTypeSchema = z.union([z.literal('album'), z.literal('single'), z.literal('compilation')]);

export const type8Schema = z.literal('album');

export const simplifiedAlbumObjectSchema = albumBaseSchema.and(
  z.object({
    artists: z.array(simplifiedArtistObjectSchema),
  }),
);

export const artistDiscographyAlbumObjectSchema = simplifiedAlbumObjectSchema.and(
  z.object({
    album_group: z.union([z.literal('album'), z.literal('single'), z.literal('compilation'), z.literal('appears_on')]),
  }),
);

export const albumGroupSchema = z.union([
  z.literal('album'),
  z.literal('single'),
  z.literal('compilation'),
  z.literal('appears_on'),
]);

export const chapterBaseSchema = z.object({
  audio_preview_url: z.string().nullable(),
  available_markets: z.array(z.string()).optional(),
  chapter_number: z.number(),
  description: z.string(),
  html_description: z.string(),
  duration_ms: z.number(),
  explicit: z.boolean(),
  external_urls: externalUrlObjectSchema,
  href: z.string(),
  id: z.string(),
  images: z.array(imageObjectSchema),
  is_playable: z.boolean(),
  languages: z.array(z.string()),
  name: z.string(),
  release_date: z.string(),
  release_date_precision: z.union([z.literal('year'), z.literal('month'), z.literal('day')]),
  resume_point: resumePointObjectSchema.optional(),
  type: z.literal('episode'),
  uri: z.string(),
  restrictions: chapterRestrictionObjectSchema.optional(),
});

export const simplifiedChapterObjectSchema = chapterBaseSchema.and(z.record(z.unknown()));

export const pagingSimplifiedTrackObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(simplifiedTrackObjectSchema).optional(),
  }),
);

export const parameterPathAlbumIdSchema = z.string();

export const parameterPathPlaylistIdSchema = z.string();

export const parameterQueryMarketSchema = z.string();

export const parameterQueryLimitSchema = z.number();

export const parameterQueryOffsetSchema = z.number();

export const parameterQueryAdditionalTypesSchema = z.string();

export const parameterQueryAlbumIdsSchema = z.string();

export const parameterPathArtistIdSchema = z.string();

export const parameterPathShowIdSchema = z.string();

export const parameterPathAudiobookIdSchema = z.string();

export const parameterQueryAudiobookIdsSchema = z.string();

export const parameterPathChapterIdSchema = z.string();

export const parameterQueryChapterIdsSchema = z.string();

export const parameterQueryTrackIdsSchema = z.string();

export const parameterQueryIncludeGroupsSchema = z.string();

export const parameterQueryShowIdsSchema = z.string();

export const parameterPathUserIdSchema = z.string();

export const getAnAlbumDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      market: z.string().optional(),
    })
    .optional(),
});

export const albumObjectSchema = albumBaseSchema
  .and(
    z.object({
      artists: z.array(simplifiedArtistObjectSchema).optional(),
      tracks: pagingSimplifiedTrackObjectSchema.optional(),
      copyrights: z.array(copyrightObjectSchema).optional(),
      external_ids: externalIdObjectSchema.optional(),
      genres: z.array(z.string()).optional(),
      label: z.string().optional(),
      popularity: z.number().optional(),
    }),
  )
  .and(
    z.object({
      artists: z.array(simplifiedArtistObjectSchema),
      tracks: pagingSimplifiedTrackObjectSchema,
      copyrights: z.array(copyrightObjectSchema),
      external_ids: externalIdObjectSchema,
      genres: z.array(z.string()),
      label: z.string(),
      popularity: z.number(),
    }),
  );

export const getAnAlbumErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getMultipleAlbumsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
    market: z.string().optional(),
  }),
});

export const getMultipleAlbumsResponseSchema = z.object({
  albums: z.array(albumObjectSchema),
});

export const getMultipleAlbumsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAnAlbumsTracksDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      market: z.string().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getAnAlbumsTracksResponseSchema = pagingSimplifiedTrackObjectSchema;

export const getAnAlbumsTracksErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAnArtistDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getAnArtistResponseSchema = artistObjectSchema;

export const getAnArtistErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getMultipleArtistsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const getMultipleArtistsResponseSchema = z.object({
  artists: z.array(artistObjectSchema),
});

export const getMultipleArtistsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAnArtistsAlbumsDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      include_groups: z.string().optional(),
      limit: z.number().optional(),
      market: z.string().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const pagingArtistDiscographyAlbumObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(artistDiscographyAlbumObjectSchema).optional(),
  }),
);

export const getAnArtistsAlbumsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAnArtistsTopTracksDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      market: z.string().optional(),
    })
    .optional(),
});

export const trackObjectSchema = z.object({
  album: simplifiedAlbumObjectSchema.optional(),
  artists: z.array(simplifiedArtistObjectSchema).optional(),
  available_markets: z.array(z.string()).optional(),
  disc_number: z.number().optional(),
  duration_ms: z.number().optional(),
  explicit: z.boolean().optional(),
  external_ids: externalIdObjectSchema.optional(),
  external_urls: externalUrlObjectSchema.optional(),
  href: z.string().optional(),
  id: z.string().optional(),
  is_playable: z.boolean().optional(),
  linked_from: z.record(z.unknown()).optional(),
  restrictions: trackRestrictionObjectSchema.optional(),
  name: z.string().optional(),
  popularity: z.number().optional(),
  preview_url: z.string().optional().nullable(),
  track_number: z.number().optional(),
  type: z.literal('track').optional(),
  uri: z.string().optional(),
  is_local: z.boolean().optional(),
});

export const getAnArtistsTopTracksErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAnArtistsRelatedArtistsDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getAnArtistsRelatedArtistsResponseSchema = z.object({
  artists: z.array(artistObjectSchema),
});

export const getAnArtistsRelatedArtistsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAshowDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      market: z.string().optional(),
    })
    .optional(),
});

export const getAshowErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getMultipleShowsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
    market: z.string().optional(),
  }),
});

export const getMultipleShowsResponseSchema = z.object({
  shows: z.array(simplifiedShowObjectSchema),
});

export const getMultipleShowsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAshowsEpisodesDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      market: z.string().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getAshowsEpisodesErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAnEpisodeDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      market: z.string().optional(),
    })
    .optional(),
});

export const getAnEpisodeErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getMultipleEpisodesDataSchema = z.object({
  query: z.object({
    ids: z.string(),
    market: z.string().optional(),
  }),
});

export const getMultipleEpisodesErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAnAudiobookDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      market: z.string().optional(),
    })
    .optional(),
});

export const getAnAudiobookErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getMultipleAudiobooksDataSchema = z.object({
  query: z.object({
    ids: z.string(),
    market: z.string().optional(),
  }),
});

export const getMultipleAudiobooksErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAudiobookChaptersDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      market: z.string().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const pagingSimplifiedChapterObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(simplifiedChapterObjectSchema).optional(),
  }),
);

export const getAudiobookChaptersErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getUsersSavedAudiobooksDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const pagingSimplifiedAudiobookObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(simplifiedAudiobookObjectSchema).optional(),
  }),
);

export const getUsersSavedAudiobooksErrorSchema = z.object({
  error: errorObjectSchema,
});

export const saveAudiobooksUserDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const saveAudiobooksUserResponseSchema = z.unknown();

export const saveAudiobooksUserErrorSchema = z.object({
  error: errorObjectSchema,
});

export const removeAudiobooksUserDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const removeAudiobooksUserResponseSchema = z.unknown();

export const removeAudiobooksUserErrorSchema = z.object({
  error: errorObjectSchema,
});

export const checkUsersSavedAudiobooksDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const checkUsersSavedAudiobooksResponseSchema = z.array(z.boolean());

export const checkUsersSavedAudiobooksErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAchapterDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      market: z.string().optional(),
    })
    .optional(),
});

export const chapterObjectSchema = chapterBaseSchema.and(
  z.object({
    audiobook: simplifiedAudiobookObjectSchema,
  }),
);

export const getAchapterErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getSeveralChaptersDataSchema = z.object({
  query: z.object({
    ids: z.string(),
    market: z.string().optional(),
  }),
});

export const getSeveralChaptersResponseSchema = z.object({
  chapters: z.array(chapterObjectSchema),
});

export const getSeveralChaptersErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getTrackDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      market: z.string().optional(),
    })
    .optional(),
});

export const getTrackResponseSchema = trackObjectSchema;

export const getTrackErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getSeveralTracksDataSchema = z.object({
  query: z.object({
    ids: z.string(),
    market: z.string().optional(),
  }),
});

export const getSeveralTracksResponseSchema = z.object({
  tracks: z.array(trackObjectSchema),
});

export const getSeveralTracksErrorSchema = z.object({
  error: errorObjectSchema,
});

export const searchDataSchema = z.object({
  query: z.object({
    include_external: z.literal('audio').optional(),
    limit: z.number().optional(),
    market: z.string().optional(),
    offset: z.number().optional(),
    q: z.string(),
    type: z.array(
      z.union([
        z.literal('album'),
        z.literal('artist'),
        z.literal('playlist'),
        z.literal('track'),
        z.literal('show'),
        z.literal('episode'),
        z.literal('audiobook'),
      ]),
    ),
  }),
});

export const pagingTrackObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(trackObjectSchema).optional(),
  }),
);

export const pagingSimplifiedAlbumObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(simplifiedAlbumObjectSchema).optional(),
  }),
);

export const pagingSimplifiedShowObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(simplifiedShowObjectSchema).optional(),
  }),
);

export const searchErrorSchema = z.object({
  error: errorObjectSchema,
});

export const privateUserObjectSchema = z.object({
  country: z.string().optional(),
  display_name: z.string().optional(),
  email: z.string().optional(),
  explicit_content: explicitContentSettingsObjectSchema.optional(),
  external_urls: externalUrlObjectSchema.optional(),
  followers: followersObjectSchema.optional(),
  href: z.string().optional(),
  id: z.string().optional(),
  images: z.array(imageObjectSchema).optional(),
  product: z.string().optional(),
  type: z.string().optional(),
  uri: z.string().optional(),
});

export const getCurrentUsersProfileErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getPlaylistDataSchema = z.object({
  path: z.object({
    playlist_id: z.string(),
  }),
  query: z
    .object({
      additional_types: z.string().optional(),
      fields: z.string().optional(),
      market: z.string().optional(),
    })
    .optional(),
});

export const getPlaylistErrorSchema = z.object({
  error: errorObjectSchema,
});

export const changePlaylistDetailsDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string(), z.boolean()]))
    .and(
      z.object({
        name: z.string().optional(),
        public: z.boolean().optional(),
        collaborative: z.boolean().optional(),
        description: z.string().optional(),
      }),
    )
    .optional(),
  path: z.object({
    playlist_id: z.string(),
  }),
});

export const changePlaylistDetailsResponseSchema = z.unknown();

export const changePlaylistDetailsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getPlaylistsTracksDataSchema = z.object({
  path: z.object({
    playlist_id: z.string(),
  }),
  query: z
    .object({
      additional_types: z.string().optional(),
      fields: z.string().optional(),
      limit: z.number().optional(),
      market: z.string().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getPlaylistsTracksErrorSchema = z.object({
  error: errorObjectSchema,
});

export const addTracksToPlaylistDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string(), z.number()]))
    .and(
      z.object({
        uris: z.array(z.string()).optional(),
        position: z.number().optional(),
      }),
    )
    .optional(),
  path: z.object({
    playlist_id: z.string(),
  }),
  query: z
    .object({
      position: z.number().optional(),
      uris: z.string().optional(),
    })
    .optional(),
});

export const addTracksToPlaylistResponseSchema = z.object({
  snapshot_id: z.string().optional(),
});

export const addTracksToPlaylistErrorSchema = z.object({
  error: errorObjectSchema,
});

export const reorderOrReplacePlaylistsTracksDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string(), z.number()]))
    .and(
      z.object({
        uris: z.array(z.string()).optional(),
        range_start: z.number().optional(),
        insert_before: z.number().optional(),
        range_length: z.number().optional(),
        snapshot_id: z.string().optional(),
      }),
    )
    .optional(),
  path: z.object({
    playlist_id: z.string(),
  }),
  query: z
    .object({
      uris: z.string().optional(),
    })
    .optional(),
});

export const reorderOrReplacePlaylistsTracksResponseSchema = z.object({
  snapshot_id: z.string().optional(),
});

export const reorderOrReplacePlaylistsTracksErrorSchema = z.object({
  error: errorObjectSchema,
});

export const removeTracksPlaylistDataSchema = z.object({
  body: z
    .object({
      tracks: z.array(
        z.object({
          uri: z.string().optional(),
        }),
      ),
      snapshot_id: z.string().optional(),
    })
    .optional(),
  path: z.object({
    playlist_id: z.string(),
  }),
});

export const removeTracksPlaylistResponseSchema = z.object({
  snapshot_id: z.string().optional(),
});

export const removeTracksPlaylistErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAlistOfCurrentUsersPlaylistsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getAlistOfCurrentUsersPlaylistsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getUsersSavedAlbumsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      market: z.string().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getUsersSavedAlbumsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const saveAlbumsUserDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string()]))
    .and(
      z.object({
        ids: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  query: z.object({
    ids: z.string(),
  }),
});

export const saveAlbumsUserResponseSchema = z.unknown();

export const saveAlbumsUserErrorSchema = z.object({
  error: errorObjectSchema,
});

export const removeAlbumsUserDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string()]))
    .and(
      z.object({
        ids: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  query: z.object({
    ids: z.string(),
  }),
});

export const removeAlbumsUserResponseSchema = z.unknown();

export const removeAlbumsUserErrorSchema = z.object({
  error: errorObjectSchema,
});

export const checkUsersSavedAlbumsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const checkUsersSavedAlbumsResponseSchema = z.array(z.boolean());

export const checkUsersSavedAlbumsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getUsersSavedTracksDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      market: z.string().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getUsersSavedTracksErrorSchema = z.object({
  error: errorObjectSchema,
});

export const saveTracksUserDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string()]))
    .and(
      z.object({
        ids: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  query: z.object({
    ids: z.string(),
  }),
});

export const saveTracksUserResponseSchema = z.unknown();

export const saveTracksUserErrorSchema = z.object({
  error: errorObjectSchema,
});

export const removeTracksUserDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string()]))
    .and(
      z.object({
        ids: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  query: z.object({
    ids: z.string(),
  }),
});

export const removeTracksUserResponseSchema = z.unknown();

export const removeTracksUserErrorSchema = z.object({
  error: errorObjectSchema,
});

export const checkUsersSavedTracksDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const checkUsersSavedTracksResponseSchema = z.array(z.boolean());

export const checkUsersSavedTracksErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getUsersSavedEpisodesDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      market: z.string().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getUsersSavedEpisodesErrorSchema = z.object({
  error: errorObjectSchema,
});

export const saveEpisodesUserDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string()]))
    .and(
      z.object({
        ids: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  query: z.object({
    ids: z.string(),
  }),
});

export const saveEpisodesUserResponseSchema = z.unknown();

export const saveEpisodesUserErrorSchema = z.object({
  error: errorObjectSchema,
});

export const removeEpisodesUserDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string()]))
    .and(
      z.object({
        ids: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  query: z.object({
    ids: z.string(),
  }),
});

export const removeEpisodesUserResponseSchema = z.unknown();

export const removeEpisodesUserErrorSchema = z.object({
  error: errorObjectSchema,
});

export const checkUsersSavedEpisodesDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const checkUsersSavedEpisodesResponseSchema = z.array(z.boolean());

export const checkUsersSavedEpisodesErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getUsersSavedShowsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getUsersSavedShowsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const saveShowsUserDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const saveShowsUserResponseSchema = z.unknown();

export const saveShowsUserErrorSchema = z.object({
  error: errorObjectSchema,
});

export const removeShowsUserDataSchema = z.object({
  query: z.object({
    ids: z.string(),
    market: z.string().optional(),
  }),
});

export const removeShowsUserResponseSchema = z.unknown();

export const removeShowsUserErrorSchema = z.object({
  error: errorObjectSchema,
});

export const checkUsersSavedShowsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const checkUsersSavedShowsResponseSchema = z.array(z.boolean());

export const checkUsersSavedShowsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getUsersTopArtistsAndTracksDataSchema = z.object({
  path: z.object({
    type: z.union([z.literal('artists'), z.literal('tracks')]),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
      time_range: z.string().optional(),
    })
    .optional(),
});

export const getUsersTopArtistsAndTracksResponseSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(z.union([artistObjectSchema, trackObjectSchema])).optional(),
  }),
);

export const getUsersTopArtistsAndTracksErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getUsersProfileDataSchema = z.object({
  path: z.object({
    user_id: z.string(),
  }),
});

export const getUsersProfileResponseSchema = publicUserObjectSchema;

export const getUsersProfileErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getListUsersPlaylistsDataSchema = z.object({
  path: z.object({
    user_id: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getListUsersPlaylistsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const createPlaylistDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string(), z.boolean()]))
    .and(
      z.object({
        name: z.string(),
        public: z.boolean().optional(),
        collaborative: z.boolean().optional(),
        description: z.string().optional(),
      }),
    )
    .optional(),
  path: z.object({
    user_id: z.string(),
  }),
});

export const createPlaylistErrorSchema = z.object({
  error: errorObjectSchema,
});

export const followPlaylistDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.boolean()]))
    .and(
      z.object({
        public: z.boolean().optional(),
      }),
    )
    .optional(),
  path: z.object({
    playlist_id: z.string(),
  }),
});

export const followPlaylistResponseSchema = z.unknown();

export const followPlaylistErrorSchema = z.object({
  error: errorObjectSchema,
});

export const unfollowPlaylistDataSchema = z.object({
  path: z.object({
    playlist_id: z.string(),
  }),
});

export const unfollowPlaylistResponseSchema = z.unknown();

export const unfollowPlaylistErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getFeaturedPlaylistsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      locale: z.string().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getFeaturedPlaylistsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getCategoriesDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      locale: z.string().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getCategoriesResponseSchema = z.object({
  categories: pagingObjectSchema.and(
    z.object({
      items: z.array(categoryObjectSchema).optional(),
    }),
  ),
});

export const getCategoriesErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAcategoryDataSchema = z.object({
  path: z.object({
    category_id: z.string(),
  }),
  query: z
    .object({
      locale: z.string().optional(),
    })
    .optional(),
});

export const getAcategoryResponseSchema = categoryObjectSchema;

export const getAcategoryErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAcategoriesPlaylistsDataSchema = z.object({
  path: z.object({
    category_id: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getAcategoriesPlaylistsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getPlaylistCoverDataSchema = z.object({
  path: z.object({
    playlist_id: z.string(),
  }),
});

export const getPlaylistCoverResponseSchema = z.array(imageObjectSchema);

export const getPlaylistCoverErrorSchema = z.object({
  error: errorObjectSchema,
});

export const uploadCustomPlaylistCoverDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    playlist_id: z.string(),
  }),
});

export const uploadCustomPlaylistCoverResponseSchema = z.unknown();

export const uploadCustomPlaylistCoverErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getNewReleasesDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getNewReleasesResponseSchema = z.object({
  albums: pagingSimplifiedAlbumObjectSchema,
});

export const getNewReleasesErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getFollowedDataSchema = z.object({
  query: z.object({
    after: z.string().optional(),
    limit: z.number().optional(),
    type: z.literal('artist'),
  }),
});

export const cursorPagingSimplifiedArtistObjectSchema = cursorPagingObjectSchema.and(
  z.object({
    items: z.array(artistObjectSchema).optional(),
  }),
);

export const getFollowedErrorSchema = z.object({
  error: errorObjectSchema,
});

export const followArtistsUsersDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string()]))
    .and(
      z.object({
        ids: z.array(z.string()),
      }),
    )
    .optional(),
  query: z.object({
    ids: z.string(),
    type: z.union([z.literal('artist'), z.literal('user')]),
  }),
});

export const followArtistsUsersResponseSchema = z.void();

export const followArtistsUsersErrorSchema = z.object({
  error: errorObjectSchema,
});

export const unfollowArtistsUsersDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string()]))
    .and(
      z.object({
        ids: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  query: z.object({
    ids: z.string(),
    type: z.union([z.literal('artist'), z.literal('user')]),
  }),
});

export const unfollowArtistsUsersResponseSchema = z.unknown();

export const unfollowArtistsUsersErrorSchema = z.object({
  error: errorObjectSchema,
});

export const checkCurrentUserFollowsDataSchema = z.object({
  query: z.object({
    ids: z.string(),
    type: z.union([z.literal('artist'), z.literal('user')]),
  }),
});

export const checkCurrentUserFollowsResponseSchema = z.array(z.boolean());

export const checkCurrentUserFollowsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const checkIfUserFollowsPlaylistDataSchema = z.object({
  path: z.object({
    playlist_id: z.string(),
  }),
  query: z
    .object({
      ids: z.string().optional(),
    })
    .optional(),
});

export const checkIfUserFollowsPlaylistResponseSchema = z.array(z.boolean());

export const checkIfUserFollowsPlaylistErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getSeveralAudioFeaturesDataSchema = z.object({
  query: z.object({
    ids: z.string(),
  }),
});

export const getSeveralAudioFeaturesResponseSchema = z.object({
  audio_features: z.array(audioFeaturesObjectSchema),
});

export const getSeveralAudioFeaturesErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAudioFeaturesDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getAudioFeaturesResponseSchema = audioFeaturesObjectSchema;

export const getAudioFeaturesErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAudioAnalysisDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const audioAnalysisObjectSchema = z.object({
  meta: z
    .object({
      analyzer_version: z.string().optional(),
      platform: z.string().optional(),
      detailed_status: z.string().optional(),
      status_code: z.number().optional(),
      timestamp: z.number().optional(),
      analysis_time: z.number().optional(),
      input_process: z.string().optional(),
    })
    .optional(),
  track: z
    .object({
      num_samples: z.number().optional(),
      duration: z.number().optional(),
      sample_md5: z.string().optional(),
      offset_seconds: z.number().optional(),
      window_seconds: z.number().optional(),
      analysis_sample_rate: z.number().optional(),
      analysis_channels: z.number().optional(),
      end_of_fade_in: z.number().optional(),
      start_of_fade_out: z.number().optional(),
      loudness: loudnessSchema.optional(),
      tempo: tempoSchema.optional(),
      tempo_confidence: z.number().optional(),
      time_signature: timeSignatureSchema.optional(),
      time_signature_confidence: z.number().optional(),
      key: keySchema.optional(),
      key_confidence: z.number().optional(),
      mode: modeSchema.optional(),
      mode_confidence: z.number().optional(),
      codestring: z.string().optional(),
      code_version: z.number().optional(),
      echoprintstring: z.string().optional(),
      echoprint_version: z.number().optional(),
      synchstring: z.string().optional(),
      synch_version: z.number().optional(),
      rhythmstring: z.string().optional(),
      rhythm_version: z.number().optional(),
    })
    .optional(),
  bars: z.array(timeIntervalObjectSchema).optional(),
  beats: z.array(timeIntervalObjectSchema).optional(),
  sections: z.array(sectionObjectSchema).optional(),
  segments: z.array(segmentObjectSchema).optional(),
  tatums: z.array(timeIntervalObjectSchema).optional(),
});

export const getAudioAnalysisErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getRecommendationsDataSchema = z.object({
  query: z.object({
    limit: z.number().optional(),
    market: z.string().optional(),
    max_acousticness: z.number().optional(),
    max_danceability: z.number().optional(),
    max_duration_ms: z.number().optional(),
    max_energy: z.number().optional(),
    max_instrumentalness: z.number().optional(),
    max_key: z.number().optional(),
    max_liveness: z.number().optional(),
    max_loudness: z.number().optional(),
    max_mode: z.number().optional(),
    max_popularity: z.number().optional(),
    max_speechiness: z.number().optional(),
    max_tempo: z.number().optional(),
    max_time_signature: z.number().optional(),
    max_valence: z.number().optional(),
    min_acousticness: z.number().optional(),
    min_danceability: z.number().optional(),
    min_duration_ms: z.number().optional(),
    min_energy: z.number().optional(),
    min_instrumentalness: z.number().optional(),
    min_key: z.number().optional(),
    min_liveness: z.number().optional(),
    min_loudness: z.number().optional(),
    min_mode: z.number().optional(),
    min_popularity: z.number().optional(),
    min_speechiness: z.number().optional(),
    min_tempo: z.number().optional(),
    min_time_signature: z.number().optional(),
    min_valence: z.number().optional(),
    seed_artists: z.string(),
    seed_genres: z.string(),
    seed_tracks: z.string(),
    target_acousticness: z.number().optional(),
    target_danceability: z.number().optional(),
    target_duration_ms: z.number().optional(),
    target_energy: z.number().optional(),
    target_instrumentalness: z.number().optional(),
    target_key: z.number().optional(),
    target_liveness: z.number().optional(),
    target_loudness: z.number().optional(),
    target_mode: z.number().optional(),
    target_popularity: z.number().optional(),
    target_speechiness: z.number().optional(),
    target_tempo: z.number().optional(),
    target_time_signature: z.number().optional(),
    target_valence: z.number().optional(),
  }),
});

export const recommendationsObjectSchema = z.object({
  seeds: z.array(recommendationSeedObjectSchema),
  tracks: z.array(trackObjectSchema),
});

export const getRecommendationsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getRecommendationGenresResponseSchema = z.object({
  genres: z.array(z.string()),
});

export const getRecommendationGenresErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getInformationAboutTheUsersCurrentPlaybackDataSchema = z.object({
  query: z
    .object({
      additional_types: z.string().optional(),
      market: z.string().optional(),
    })
    .optional(),
});

export const getInformationAboutTheUsersCurrentPlaybackErrorSchema = z.object({
  error: errorObjectSchema,
});

export const transferAusersPlaybackDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string()]))
    .and(
      z.object({
        device_ids: z.array(z.string()),
        play: z.record(z.unknown()).optional(),
      }),
    )
    .optional(),
});

export const transferAusersPlaybackResponseSchema = z.void();

export const transferAusersPlaybackErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAusersAvailableDevicesResponseSchema = z.object({
  devices: z.array(deviceObjectSchema),
});

export const getAusersAvailableDevicesErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getTheUsersCurrentlyPlayingTrackDataSchema = z.object({
  query: z
    .object({
      additional_types: z.string().optional(),
      market: z.string().optional(),
    })
    .optional(),
});

export const getTheUsersCurrentlyPlayingTrackErrorSchema = z.object({
  error: errorObjectSchema,
});

export const startAusersPlaybackDataSchema = z.object({
  body: z
    .record(z.union([z.unknown(), z.string()]))
    .and(
      z.object({
        context_uri: z.record(z.unknown()).optional(),
        uris: z.array(z.string()).optional(),
        offset: z.record(z.unknown()).optional(),
        position_ms: z.record(z.unknown()).optional(),
      }),
    )
    .optional(),
  query: z
    .object({
      device_id: z.string().optional(),
    })
    .optional(),
});

export const startAusersPlaybackResponseSchema = z.void();

export const startAusersPlaybackErrorSchema = z.object({
  error: errorObjectSchema,
});

export const pauseAusersPlaybackDataSchema = z.object({
  query: z
    .object({
      device_id: z.string().optional(),
    })
    .optional(),
});

export const pauseAusersPlaybackResponseSchema = z.void();

export const pauseAusersPlaybackErrorSchema = z.object({
  error: errorObjectSchema,
});

export const skipUsersPlaybackToNextTrackDataSchema = z.object({
  query: z
    .object({
      device_id: z.string().optional(),
    })
    .optional(),
});

export const skipUsersPlaybackToNextTrackResponseSchema = z.void();

export const skipUsersPlaybackToNextTrackErrorSchema = z.object({
  error: errorObjectSchema,
});

export const skipUsersPlaybackToPreviousTrackDataSchema = z.object({
  query: z
    .object({
      device_id: z.string().optional(),
    })
    .optional(),
});

export const skipUsersPlaybackToPreviousTrackResponseSchema = z.void();

export const skipUsersPlaybackToPreviousTrackErrorSchema = z.object({
  error: errorObjectSchema,
});

export const seekToPositionInCurrentlyPlayingTrackDataSchema = z.object({
  query: z.object({
    device_id: z.string().optional(),
    position_ms: z.number(),
  }),
});

export const seekToPositionInCurrentlyPlayingTrackResponseSchema = z.void();

export const seekToPositionInCurrentlyPlayingTrackErrorSchema = z.object({
  error: errorObjectSchema,
});

export const setRepeatModeOnUsersPlaybackDataSchema = z.object({
  query: z.object({
    device_id: z.string().optional(),
    state: z.string(),
  }),
});

export const setRepeatModeOnUsersPlaybackResponseSchema = z.void();

export const setRepeatModeOnUsersPlaybackErrorSchema = z.object({
  error: errorObjectSchema,
});

export const setVolumeForUsersPlaybackDataSchema = z.object({
  query: z.object({
    device_id: z.string().optional(),
    volume_percent: z.number(),
  }),
});

export const setVolumeForUsersPlaybackResponseSchema = z.void();

export const setVolumeForUsersPlaybackErrorSchema = z.object({
  error: errorObjectSchema,
});

export const toggleShuffleForUsersPlaybackDataSchema = z.object({
  query: z.object({
    device_id: z.string().optional(),
    state: z.boolean(),
  }),
});

export const toggleShuffleForUsersPlaybackResponseSchema = z.void();

export const toggleShuffleForUsersPlaybackErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getRecentlyPlayedDataSchema = z.object({
  query: z
    .object({
      after: z.number().optional(),
      before: z.number().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const getRecentlyPlayedErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getQueueErrorSchema = z.object({
  error: errorObjectSchema,
});

export const addToQueueDataSchema = z.object({
  query: z.object({
    device_id: z.string().optional(),
    uri: z.string(),
  }),
});

export const addToQueueResponseSchema = z.void();

export const addToQueueErrorSchema = z.object({
  error: errorObjectSchema,
});

export const getAvailableMarketsResponseSchema = z.object({
  markets: z.array(z.string()).optional(),
});

export const getAvailableMarketsErrorSchema = z.object({
  error: errorObjectSchema,
});

export const playHistoryObjectSchema = z.object({
  track: trackObjectSchema.optional(),
  played_at: z.string().optional(),
  context: contextObjectSchema.optional(),
});

export const cursorPagingPlayHistoryObjectSchema = cursorPagingObjectSchema.and(
  z.object({
    items: z.array(playHistoryObjectSchema).optional(),
  }),
);

export const simplifiedPlaylistObjectSchema = z.object({
  collaborative: z.boolean().optional(),
  description: z.string().optional(),
  external_urls: externalUrlObjectSchema.optional(),
  href: z.string().optional(),
  id: z.string().optional(),
  images: z.array(imageObjectSchema).optional(),
  name: z.string().optional(),
  owner: playlistOwnerObjectSchema.optional(),
  public: z.boolean().optional(),
  snapshot_id: z.string().optional(),
  tracks: playlistTracksRefObjectSchema.optional(),
  type: z.string().optional(),
  uri: z.string().optional(),
});

export const pagingPlaylistObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(simplifiedPlaylistObjectSchema).optional(),
  }),
);

export const savedAlbumObjectSchema = z.object({
  added_at: z.string().optional(),
  album: albumObjectSchema.optional(),
});

export const savedTrackObjectSchema = z.object({
  added_at: z.string().optional(),
  track: trackObjectSchema.optional(),
});

export const savedShowObjectSchema = z.object({
  added_at: z.string().optional(),
  show: simplifiedShowObjectSchema.optional(),
});

export const episodeBaseSchema = z.object({
  audio_preview_url: z.string().nullable(),
  description: z.string(),
  html_description: z.string(),
  duration_ms: z.number(),
  explicit: z.boolean(),
  external_urls: externalUrlObjectSchema,
  href: z.string(),
  id: z.string(),
  images: z.array(imageObjectSchema),
  is_externally_hosted: z.boolean(),
  is_playable: z.boolean(),
  language: z.string().optional(),
  languages: z.array(z.string()),
  name: z.string(),
  release_date: z.string(),
  release_date_precision: z.union([z.literal('year'), z.literal('month'), z.literal('day')]),
  resume_point: resumePointObjectSchema.optional(),
  type: z.literal('episode'),
  uri: z.string(),
  restrictions: episodeRestrictionObjectSchema.optional(),
});

export const simplifiedEpisodeObjectSchema = episodeBaseSchema.and(z.record(z.unknown()));

export const pagingSimplifiedEpisodeObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(simplifiedEpisodeObjectSchema).optional(),
  }),
);

export const audiobookObjectSchema = audiobookBaseSchema.and(
  z.object({
    chapters: pagingSimplifiedChapterObjectSchema,
  }),
);

export const getAnAlbumResponseSchema = albumObjectSchema;

export const getAnArtistsAlbumsResponseSchema = pagingArtistDiscographyAlbumObjectSchema;

export const getAnArtistsTopTracksResponseSchema = z.object({
  tracks: z.array(trackObjectSchema),
});

export const showObjectSchema = showBaseSchema.and(
  z.object({
    episodes: pagingSimplifiedEpisodeObjectSchema,
  }),
);

export const getAshowsEpisodesResponseSchema = pagingSimplifiedEpisodeObjectSchema;

export const episodeObjectSchema = episodeBaseSchema.and(
  z.object({
    show: simplifiedShowObjectSchema,
  }),
);

export const getMultipleEpisodesResponseSchema = z.object({
  episodes: z.array(episodeObjectSchema),
});

export const getAnAudiobookResponseSchema = audiobookObjectSchema;

export const getMultipleAudiobooksResponseSchema = z.object({
  audiobooks: z.array(audiobookObjectSchema),
});

export const getAudiobookChaptersResponseSchema = pagingSimplifiedChapterObjectSchema;

export const getUsersSavedAudiobooksResponseSchema = pagingSimplifiedAudiobookObjectSchema;

export const getAchapterResponseSchema = chapterObjectSchema;

export const searchResponseSchema = z.object({
  tracks: pagingTrackObjectSchema.optional(),
  artists: pagingArtistObjectSchema.optional(),
  albums: pagingSimplifiedAlbumObjectSchema.optional(),
  playlists: pagingPlaylistObjectSchema.optional(),
  shows: pagingSimplifiedShowObjectSchema.optional(),
  episodes: pagingSimplifiedEpisodeObjectSchema.optional(),
  audiobooks: pagingSimplifiedAudiobookObjectSchema.optional(),
});

export const getCurrentUsersProfileResponseSchema = privateUserObjectSchema;

export const getAlistOfCurrentUsersPlaylistsResponseSchema = pagingPlaylistObjectSchema;

export const pagingSavedAlbumObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(savedAlbumObjectSchema).optional(),
  }),
);

export const pagingSavedTrackObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(savedTrackObjectSchema).optional(),
  }),
);

export const pagingSavedShowObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(savedShowObjectSchema).optional(),
  }),
);

export const getListUsersPlaylistsResponseSchema = pagingPlaylistObjectSchema;

export const pagingFeaturedPlaylistObjectSchema = z.object({
  message: z.string().optional(),
  playlists: pagingPlaylistObjectSchema.optional(),
});

export const getAcategoriesPlaylistsResponseSchema = pagingFeaturedPlaylistObjectSchema;

export const getFollowedResponseSchema = z.object({
  artists: cursorPagingSimplifiedArtistObjectSchema,
});

export const getAudioAnalysisResponseSchema = audioAnalysisObjectSchema;

export const getRecommendationsResponseSchema = recommendationsObjectSchema;

export const currentlyPlayingContextObjectSchema = z.object({
  device: deviceObjectSchema.optional(),
  repeat_state: z.string().optional(),
  shuffle_state: z.boolean().optional(),
  context: contextObjectSchema.optional(),
  timestamp: z.number().optional(),
  progress_ms: z.number().optional(),
  is_playing: z.boolean().optional(),
  item: z.union([trackObjectSchema, episodeObjectSchema]).optional(),
  currently_playing_type: z.string().optional(),
  actions: disallowsObjectSchema.optional(),
});

export const getTheUsersCurrentlyPlayingTrackResponseSchema = currentlyPlayingContextObjectSchema;

export const getRecentlyPlayedResponseSchema = cursorPagingPlayHistoryObjectSchema;

export const queueObjectSchema = z.object({
  currently_playing: z.union([trackObjectSchema, episodeObjectSchema]).optional(),
  queue: z.array(z.union([trackObjectSchema, episodeObjectSchema])).optional(),
});

export const playlistTrackObjectSchema = z.object({
  added_at: z.string().optional(),
  added_by: playlistUserObjectSchema.optional(),
  is_local: z.boolean().optional(),
  track: z.union([trackObjectSchema, episodeObjectSchema]).optional(),
});

export const pagingPlaylistTrackObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(playlistTrackObjectSchema).optional(),
  }),
);

export const savedEpisodeObjectSchema = z.object({
  added_at: z.string().optional(),
  episode: episodeObjectSchema.optional(),
});

export const playlistObjectSchema = z.object({
  collaborative: z.boolean().optional(),
  description: z.string().optional().nullable(),
  external_urls: externalUrlObjectSchema.optional(),
  followers: followersObjectSchema.optional(),
  href: z.string().optional(),
  id: z.string().optional(),
  images: z.array(imageObjectSchema).optional(),
  name: z.string().optional(),
  owner: playlistOwnerObjectSchema.optional(),
  public: z.boolean().optional(),
  snapshot_id: z.string().optional(),
  tracks: pagingPlaylistTrackObjectSchema.optional(),
  type: z.string().optional(),
  uri: z.string().optional(),
});

export const getAshowResponseSchema = showObjectSchema;

export const getAnEpisodeResponseSchema = episodeObjectSchema;

export const getPlaylistResponseSchema = playlistObjectSchema;

export const getPlaylistsTracksResponseSchema = pagingPlaylistTrackObjectSchema;

export const getUsersSavedAlbumsResponseSchema = pagingSavedAlbumObjectSchema;

export const getUsersSavedTracksResponseSchema = pagingSavedTrackObjectSchema;

export const pagingSavedEpisodeObjectSchema = pagingObjectSchema.and(
  z.object({
    items: z.array(savedEpisodeObjectSchema).optional(),
  }),
);

export const getUsersSavedShowsResponseSchema = pagingSavedShowObjectSchema;

export const createPlaylistResponseSchema = playlistObjectSchema;

export const getFeaturedPlaylistsResponseSchema = pagingFeaturedPlaylistObjectSchema;

export const getInformationAboutTheUsersCurrentPlaybackResponseSchema = z.union([
  currentlyPlayingContextObjectSchema,
  z.void(),
]);

export const getQueueResponseSchema = queueObjectSchema;

export const getUsersSavedEpisodesResponseSchema = pagingSavedEpisodeObjectSchema;
