// This file is auto-generated by @hey-api/openapi-ts

export type LinkedTrackObject = {
  /**
   * Known external URLs for this track.
   *
   */
  external_urls?: ExternalUrlObject;
  /**
   * A link to the Web API endpoint providing full details of the track.
   *
   */
  href?: string;
  /**
   * The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the track.
   *
   */
  id?: string;
  /**
   * The object type: "track".
   *
   */
  type?: string;
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the track.
   *
   */
  uri?: string;
};

export type TrackRestrictionObject = {
  /**
   * The reason for the restriction. Supported values:
   * - `market` - The content item is not available in the given market.
   * - `product` - The content item is not available for the user's subscription type.
   * - `explicit` - The content item is explicit and the user's account is set to not play explicit content.
   *
   * Additional reasons may be added in the future.
   * **Note**: If you use this field, make sure that your application safely handles unknown values.
   *
   */
  reason?: string;
};

export type AlbumRestrictionObject = {
  /**
   * The reason for the restriction. Albums may be restricted if the content is not available in a given market, to the user's subscription type, or when the user's account is set to not play explicit content.
   * Additional reasons may be added in the future.
   *
   */
  reason?: 'market' | 'product' | 'explicit';
};

/**
 * The reason for the restriction. Albums may be restricted if the content is not available in a given market, to the user's subscription type, or when the user's account is set to not play explicit content.
 * Additional reasons may be added in the future.
 *
 */
export type reason = 'market' | 'product' | 'explicit';

export type EpisodeRestrictionObject = {
  /**
   * The reason for the restriction. Supported values:
   * - `market` - The content item is not available in the given market.
   * - `product` - The content item is not available for the user's subscription type.
   * - `explicit` - The content item is explicit and the user's account is set to not play explicit content.
   *
   * Additional reasons may be added in the future.
   * **Note**: If you use this field, make sure that your application safely handles unknown values.
   *
   */
  reason?: string;
};

export type ChapterRestrictionObject = {
  /**
   * The reason for the restriction. Supported values:
   * - `market` - The content item is not available in the given market.
   * - `product` - The content item is not available for the user's subscription type.
   * - `explicit` - The content item is explicit and the user's account is set to not play explicit content.
   * - `payment_required` - Payment is required to play the content item.
   *
   * Additional reasons may be added in the future.
   * **Note**: If you use this field, make sure that your application safely handles unknown values.
   *
   */
  reason?: string;
};

export type ArtistObject = {
  /**
   * Known external URLs for this artist.
   *
   */
  external_urls?: ExternalUrlObject;
  /**
   * Information about the followers of the artist.
   *
   */
  followers?: FollowersObject;
  /**
   * A list of the genres the artist is associated with. If not yet classified, the array is empty.
   *
   */
  genres?: Array<string>;
  /**
   * A link to the Web API endpoint providing full details of the artist.
   *
   */
  href?: string;
  /**
   * The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the artist.
   *
   */
  id?: string;
  /**
   * Images of the artist in various sizes, widest first.
   *
   */
  images?: Array<ImageObject>;
  /**
   * The name of the artist.
   *
   */
  name?: string;
  /**
   * The popularity of the artist. The value will be between 0 and 100, with 100 being the most popular. The artist's popularity is calculated from the popularity of all the artist's tracks.
   *
   */
  popularity?: number;
  /**
   * The object type.
   *
   */
  type?: 'artist';
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the artist.
   *
   */
  uri?: string;
};

/**
 * The object type.
 *
 */
export type type = 'artist';

export type SimplifiedArtistObject = {
  /**
   * Known external URLs for this artist.
   *
   */
  external_urls?: ExternalUrlObject;
  /**
   * A link to the Web API endpoint providing full details of the artist.
   *
   */
  href?: string;
  /**
   * The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the artist.
   *
   */
  id?: string;
  /**
   * The name of the artist.
   *
   */
  name?: string;
  /**
   * The object type.
   *
   */
  type?: 'artist';
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the artist.
   *
   */
  uri?: string;
};

export type PlayHistoryObject = {
  /**
   * The track the user listened to.
   */
  track?: TrackObject;
  /**
   * The date and time the track was played.
   */
  played_at?: string;
  /**
   * The context the track was played from.
   */
  context?: ContextObject;
};

export type PlaylistTrackObject = {
  /**
   * The date and time the track or episode was added. _**Note**: some very old playlists may return `null` in this field._
   *
   */
  added_at?: string;
  /**
   * The Spotify user who added the track or episode. _**Note**: some very old playlists may return `null` in this field._
   *
   */
  added_by?: PlaylistUserObject;
  /**
   * Whether this track or episode is a [local file](/documentation/web-api/concepts/playlists/#local-files) or not.
   *
   */
  is_local?: boolean;
  /**
   * Information about the track or episode.
   */
  track?: TrackObject | EpisodeObject;
};

export type QueueObject = {
  /**
   * The currently playing track or episode. Can be `null`.
   */
  currently_playing?: TrackObject | EpisodeObject;
  /**
   * The tracks or episodes in the queue. Can be empty.
   */
  queue?: Array<TrackObject | EpisodeObject>;
};

export type CurrentlyPlayingContextObject = {
  /**
   * The device that is currently active.
   *
   */
  device?: DeviceObject;
  /**
   * off, track, context
   */
  repeat_state?: string;
  /**
   * If shuffle is on or off.
   */
  shuffle_state?: boolean;
  /**
   * A Context Object. Can be `null`.
   */
  context?: ContextObject;
  /**
   * Unix Millisecond Timestamp when playback state was last changed (play, pause, skip, scrub, new song, etc.).
   */
  timestamp?: number;
  /**
   * Progress into the currently playing track or episode. Can be `null`.
   */
  progress_ms?: number;
  /**
   * If something is currently playing, return `true`.
   */
  is_playing?: boolean;
  /**
   * The currently playing track or episode. Can be `null`.
   */
  item?: TrackObject | EpisodeObject;
  /**
   * The object type of the currently playing item. Can be one of `track`, `episode`, `ad` or `unknown`.
   *
   */
  currently_playing_type?: string;
  /**
   * Allows to update the user interface based on which playback actions are available within the current context.
   *
   */
  actions?: DisallowsObject;
};

export type DisallowsObject = {
  /**
   * Interrupting playback. Optional field.
   */
  interrupting_playback?: boolean;
  /**
   * Pausing. Optional field.
   */
  pausing?: boolean;
  /**
   * Resuming. Optional field.
   */
  resuming?: boolean;
  /**
   * Seeking playback location. Optional field.
   */
  seeking?: boolean;
  /**
   * Skipping to the next context. Optional field.
   */
  skipping_next?: boolean;
  /**
   * Skipping to the previous context. Optional field.
   */
  skipping_prev?: boolean;
  /**
   * Toggling repeat context flag. Optional field.
   */
  toggling_repeat_context?: boolean;
  /**
   * Toggling shuffle flag. Optional field.
   */
  toggling_shuffle?: boolean;
  /**
   * Toggling repeat track flag. Optional field.
   */
  toggling_repeat_track?: boolean;
  /**
   * Transfering playback between devices. Optional field.
   */
  transferring_playback?: boolean;
};

export type ErrorObject = {
  /**
   * The HTTP status code (also returned in the response header; see [Response Status Codes](/documentation/web-api/concepts/api-calls#response-status-codes) for more information).
   *
   */
  status: number;
  /**
   * A short description of the cause of the error.
   *
   */
  message: string;
};

export type PrivateUserObject = {
  /**
   * The country of the user, as set in the user's account profile. An [ISO 3166-1 alpha-2 country code](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). _This field is only available when the current user has granted access to the [user-read-private](/documentation/web-api/concepts/scopes/#list-of-scopes) scope._
   *
   */
  country?: string;
  /**
   * The name displayed on the user's profile. `null` if not available.
   *
   */
  display_name?: string;
  /**
   * The user's email address, as entered by the user when creating their account. _**Important!** This email address is unverified; there is no proof that it actually belongs to the user._ _This field is only available when the current user has granted access to the [user-read-email](/documentation/web-api/concepts/scopes/#list-of-scopes) scope._
   *
   */
  email?: string;
  /**
   * The user's explicit content settings. _This field is only available when the current user has granted access to the [user-read-private](/documentation/web-api/concepts/scopes/#list-of-scopes) scope._
   *
   */
  explicit_content?: ExplicitContentSettingsObject;
  /**
   * Known external URLs for this user.
   */
  external_urls?: ExternalUrlObject;
  /**
   * Information about the followers of the user.
   */
  followers?: FollowersObject;
  /**
   * A link to the Web API endpoint for this user.
   *
   */
  href?: string;
  /**
   * The [Spotify user ID](/documentation/web-api/concepts/spotify-uris-ids) for the user.
   *
   */
  id?: string;
  /**
   * The user's profile image.
   */
  images?: Array<ImageObject>;
  /**
   * The user's Spotify subscription level: "premium", "free", etc. (The subscription level "open" can be considered the same as "free".) _This field is only available when the current user has granted access to the [user-read-private](/documentation/web-api/concepts/scopes/#list-of-scopes) scope._
   *
   */
  product?: string;
  /**
   * The object type: "user"
   *
   */
  type?: string;
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the user.
   *
   */
  uri?: string;
};

export type PublicUserObject = {
  /**
   * The name displayed on the user's profile. `null` if not available.
   *
   */
  display_name?: string | null;
  /**
   * Known public external URLs for this user.
   *
   */
  external_urls?: ExternalUrlObject;
  /**
   * Information about the followers of this user.
   *
   */
  followers?: FollowersObject;
  /**
   * A link to the Web API endpoint for this user.
   *
   */
  href?: string;
  /**
   * The [Spotify user ID](/documentation/web-api/concepts/spotify-uris-ids) for this user.
   *
   */
  id?: string;
  /**
   * The user's profile image.
   *
   */
  images?: Array<ImageObject>;
  /**
   * The object type.
   *
   */
  type?: 'user';
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for this user.
   *
   */
  uri?: string;
};

/**
 * The object type.
 *
 */
export type type2 = 'user';

export type AudioAnalysisObject = {
  meta?: {
    /**
     * The version of the Analyzer used to analyze this track.
     */
    analyzer_version?: string;
    /**
     * The platform used to read the track's audio data.
     */
    platform?: string;
    /**
     * A detailed status code for this track. If analysis data is missing, this code may explain why.
     */
    detailed_status?: string;
    /**
     * The return code of the analyzer process. 0 if successful, 1 if any errors occurred.
     */
    status_code?: number;
    /**
     * The Unix timestamp (in seconds) at which this track was analyzed.
     */
    timestamp?: number;
    /**
     * The amount of time taken to analyze this track.
     */
    analysis_time?: number;
    /**
     * The method used to read the track's audio data.
     */
    input_process?: string;
  };
  track?: {
    /**
     * The exact number of audio samples analyzed from this track. See also `analysis_sample_rate`.
     */
    num_samples?: number;
    /**
     * Length of the track in seconds.
     */
    duration?: number;
    /**
     * This field will always contain the empty string.
     */
    sample_md5?: string;
    /**
     * An offset to the start of the region of the track that was analyzed. (As the entire track is analyzed, this should always be 0.)
     */
    offset_seconds?: number;
    /**
     * The length of the region of the track was analyzed, if a subset of the track was analyzed. (As the entire track is analyzed, this should always be 0.)
     */
    window_seconds?: number;
    /**
     * The sample rate used to decode and analyze this track. May differ from the actual sample rate of this track available on Spotify.
     */
    analysis_sample_rate?: number;
    /**
     * The number of channels used for analysis. If 1, all channels are summed together to mono before analysis.
     */
    analysis_channels?: number;
    /**
     * The time, in seconds, at which the track's fade-in period ends. If the track has no fade-in, this will be 0.0.
     */
    end_of_fade_in?: number;
    /**
     * The time, in seconds, at which the track's fade-out period starts. If the track has no fade-out, this should match the track's length.
     */
    start_of_fade_out?: number;
    loudness?: Loudness;
    tempo?: Tempo;
    /**
     * The confidence, from 0.0 to 1.0, of the reliability of the `tempo`.
     */
    tempo_confidence?: number;
    time_signature?: TimeSignature;
    /**
     * The confidence, from 0.0 to 1.0, of the reliability of the `time_signature`.
     */
    time_signature_confidence?: number;
    key?: Key;
    /**
     * The confidence, from 0.0 to 1.0, of the reliability of the `key`.
     */
    key_confidence?: number;
    mode?: Mode;
    /**
     * The confidence, from 0.0 to 1.0, of the reliability of the `mode`.
     */
    mode_confidence?: number;
    /**
     * An [Echo Nest Musical Fingerprint (ENMFP)](https://academiccommons.columbia.edu/doi/10.7916/D8Q248M4) codestring for this track.
     */
    codestring?: string;
    /**
     * A version number for the Echo Nest Musical Fingerprint format used in the codestring field.
     */
    code_version?: number;
    /**
     * An [EchoPrint](https://github.com/spotify/echoprint-codegen) codestring for this track.
     */
    echoprintstring?: string;
    /**
     * A version number for the EchoPrint format used in the echoprintstring field.
     */
    echoprint_version?: number;
    /**
     * A [Synchstring](https://github.com/echonest/synchdata) for this track.
     */
    synchstring?: string;
    /**
     * A version number for the Synchstring used in the synchstring field.
     */
    synch_version?: number;
    /**
     * A Rhythmstring for this track. The format of this string is similar to the Synchstring.
     */
    rhythmstring?: string;
    /**
     * A version number for the Rhythmstring used in the rhythmstring field.
     */
    rhythm_version?: number;
  };
  /**
   * The time intervals of the bars throughout the track. A bar (or measure) is a segment of time defined as a given number of beats.
   */
  bars?: Array<TimeIntervalObject>;
  /**
   * The time intervals of beats throughout the track. A beat is the basic time unit of a piece of music; for example, each tick of a metronome. Beats are typically multiples of tatums.
   */
  beats?: Array<TimeIntervalObject>;
  /**
   * Sections are defined by large variations in rhythm or timbre, e.g. chorus, verse, bridge, guitar solo, etc. Each section contains its own descriptions of tempo, key, mode, time_signature, and loudness.
   */
  sections?: Array<SectionObject>;
  /**
   * Each segment contains a roughly conisistent sound throughout its duration.
   */
  segments?: Array<SegmentObject>;
  /**
   * A tatum represents the lowest regular pulse train that a listener intuitively infers from the timing of perceived musical events (segments).
   */
  tatums?: Array<TimeIntervalObject>;
};

export type TimeIntervalObject = {
  /**
   * The starting point (in seconds) of the time interval.
   */
  start?: number;
  /**
   * The duration (in seconds) of the time interval.
   */
  duration?: number;
  /**
   * The confidence, from 0.0 to 1.0, of the reliability of the interval.
   */
  confidence?: number;
};

export type SectionObject = {
  /**
   * The starting point (in seconds) of the section.
   */
  start?: number;
  /**
   * The duration (in seconds) of the section.
   */
  duration?: number;
  /**
   * The confidence, from 0.0 to 1.0, of the reliability of the section's "designation".
   */
  confidence?: number;
  /**
   * The overall loudness of the section in decibels (dB). Loudness values are useful for comparing relative loudness of sections within tracks.
   */
  loudness?: number;
  /**
   * The overall estimated tempo of the section in beats per minute (BPM). In musical terminology, tempo is the speed or pace of a given piece and derives directly from the average beat duration.
   */
  tempo?: number;
  /**
   * The confidence, from 0.0 to 1.0, of the reliability of the tempo. Some tracks contain tempo changes or sounds which don't contain tempo (like pure speech) which would correspond to a low value in this field.
   */
  tempo_confidence?: number;
  /**
   * The estimated overall key of the section. The values in this field ranging from 0 to 11 mapping to pitches using standard Pitch Class notation (E.g. 0 = C, 1 = C♯/D♭, 2 = D, and so on). If no key was detected, the value is -1.
   */
  key?: number;
  /**
   * The confidence, from 0.0 to 1.0, of the reliability of the key. Songs with many key changes may correspond to low values in this field.
   */
  key_confidence?: number;
  /**
   * Indicates the modality (major or minor) of a section, the type of scale from which its melodic content is derived. This field will contain a 0 for "minor", a 1 for "major", or a -1 for no result. Note that the major key (e.g. C major) could more likely be confused with the minor key at 3 semitones lower (e.g. A minor) as both keys carry the same pitches.
   */
  mode?: -1 | 0 | 1;
  /**
   * The confidence, from 0.0 to 1.0, of the reliability of the `mode`.
   */
  mode_confidence?: number;
  time_signature?: TimeSignature;
  /**
   * The confidence, from 0.0 to 1.0, of the reliability of the `time_signature`. Sections with time signature changes may correspond to low values in this field.
   */
  time_signature_confidence?: number;
};

/**
 * Indicates the modality (major or minor) of a section, the type of scale from which its melodic content is derived. This field will contain a 0 for "minor", a 1 for "major", or a -1 for no result. Note that the major key (e.g. C major) could more likely be confused with the minor key at 3 semitones lower (e.g. A minor) as both keys carry the same pitches.
 */
export type mode = -1 | 0 | 1;

export type SegmentObject = {
  /**
   * The starting point (in seconds) of the segment.
   */
  start?: number;
  /**
   * The duration (in seconds) of the segment.
   */
  duration?: number;
  /**
   * The confidence, from 0.0 to 1.0, of the reliability of the segmentation. Segments of the song which are difficult to logically segment (e.g: noise) may correspond to low values in this field.
   *
   */
  confidence?: number;
  /**
   * The onset loudness of the segment in decibels (dB). Combined with `loudness_max` and `loudness_max_time`, these components can be used to describe the "attack" of the segment.
   */
  loudness_start?: number;
  /**
   * The peak loudness of the segment in decibels (dB). Combined with `loudness_start` and `loudness_max_time`, these components can be used to describe the "attack" of the segment.
   */
  loudness_max?: number;
  /**
   * The segment-relative offset of the segment peak loudness in seconds. Combined with `loudness_start` and `loudness_max`, these components can be used to desctibe the "attack" of the segment.
   */
  loudness_max_time?: number;
  /**
   * The offset loudness of the segment in decibels (dB). This value should be equivalent to the loudness_start of the following segment.
   */
  loudness_end?: number;
  /**
   * Pitch content is given by a “chroma” vector, corresponding to the 12 pitch classes C, C#, D to B, with values ranging from 0 to 1 that describe the relative dominance of every pitch in the chromatic scale. For example a C Major chord would likely be represented by large values of C, E and G (i.e. classes 0, 4, and 7).
   *
   * Vectors are normalized to 1 by their strongest dimension, therefore noisy sounds are likely represented by values that are all close to 1, while pure tones are described by one value at 1 (the pitch) and others near 0.
   * As can be seen below, the 12 vector indices are a combination of low-power spectrum values at their respective pitch frequencies.
   * ![pitch vector](https://developer.spotify.com/assets/audio/Pitch_vector.png)
   *
   */
  pitches?: Array<number>;
  /**
   * Timbre is the quality of a musical note or sound that distinguishes different types of musical instruments, or voices. It is a complex notion also referred to as sound color, texture, or tone quality, and is derived from the shape of a segment’s spectro-temporal surface, independently of pitch and loudness. The timbre feature is a vector that includes 12 unbounded values roughly centered around 0. Those values are high level abstractions of the spectral surface, ordered by degree of importance.
   *
   * For completeness however, the first dimension represents the average loudness of the segment; second emphasizes brightness; third is more closely correlated to the flatness of a sound; fourth to sounds with a stronger attack; etc. See an image below representing the 12 basis functions (i.e. template segments).
   * ![timbre basis functions](https://developer.spotify.com/assets/audio/Timbre_basis_functions.png)
   *
   * The actual timbre of the segment is best described as a linear combination of these 12 basis functions weighted by the coefficient values: timbre = c1 x b1 + c2 x b2 + ... + c12 x b12, where c1 to c12 represent the 12 coefficients and b1 to b12 the 12 basis functions as displayed below. Timbre vectors are best used in comparison with each other.
   *
   */
  timbre?: Array<number>;
};

/**
 * An estimated time signature. The time signature (meter) is a notational convention to specify how many beats are in each bar (or measure). The time signature ranges from 3 to 7 indicating time signatures of "3/4", to "7/4".
 */
export type TimeSignature = number;

/**
 * The overall estimated tempo of a track in beats per minute (BPM). In musical terminology, tempo is the speed or pace of a given piece and derives directly from the average beat duration.
 *
 */
export type Tempo = number;

/**
 * The overall loudness of a track in decibels (dB). Loudness values are averaged across the entire track and are useful for comparing relative loudness of tracks. Loudness is the quality of a sound that is the primary psychological correlate of physical strength (amplitude). Values typically range between -60 and 0 db.
 *
 */
export type Loudness = number;

/**
 * The key the track is in. Integers map to pitches using standard [Pitch Class notation](https://en.wikipedia.org/wiki/Pitch_class). E.g. 0 = C, 1 = C♯/D♭, 2 = D, and so on. If no key was detected, the value is -1.
 *
 */
export type Key = number;

/**
 * Mode indicates the modality (major or minor) of a track, the type of scale from which its melodic content is derived. Major is represented by 1 and minor is 0.
 *
 */
export type Mode = number;

export type AudioFeaturesObject = {
  /**
   * A confidence measure from 0.0 to 1.0 of whether the track is acoustic. 1.0 represents high confidence the track is acoustic.
   *
   */
  acousticness?: number;
  /**
   * A URL to access the full audio analysis of this track. An access token is required to access this data.
   *
   */
  analysis_url?: string;
  /**
   * Danceability describes how suitable a track is for dancing based on a combination of musical elements including tempo, rhythm stability, beat strength, and overall regularity. A value of 0.0 is least danceable and 1.0 is most danceable.
   *
   */
  danceability?: number;
  /**
   * The duration of the track in milliseconds.
   *
   */
  duration_ms?: number;
  /**
   * Energy is a measure from 0.0 to 1.0 and represents a perceptual measure of intensity and activity. Typically, energetic tracks feel fast, loud, and noisy. For example, death metal has high energy, while a Bach prelude scores low on the scale. Perceptual features contributing to this attribute include dynamic range, perceived loudness, timbre, onset rate, and general entropy.
   *
   */
  energy?: number;
  /**
   * The Spotify ID for the track.
   *
   */
  id?: string;
  /**
   * Predicts whether a track contains no vocals. "Ooh" and "aah" sounds are treated as instrumental in this context. Rap or spoken word tracks are clearly "vocal". The closer the instrumentalness value is to 1.0, the greater likelihood the track contains no vocal content. Values above 0.5 are intended to represent instrumental tracks, but confidence is higher as the value approaches 1.0.
   *
   */
  instrumentalness?: number;
  key?: Key;
  /**
   * Detects the presence of an audience in the recording. Higher liveness values represent an increased probability that the track was performed live. A value above 0.8 provides strong likelihood that the track is live.
   *
   */
  liveness?: number;
  loudness?: Loudness;
  mode?: Mode;
  /**
   * Speechiness detects the presence of spoken words in a track. The more exclusively speech-like the recording (e.g. talk show, audio book, poetry), the closer to 1.0 the attribute value. Values above 0.66 describe tracks that are probably made entirely of spoken words. Values between 0.33 and 0.66 describe tracks that may contain both music and speech, either in sections or layered, including such cases as rap music. Values below 0.33 most likely represent music and other non-speech-like tracks.
   *
   */
  speechiness?: number;
  tempo?: Tempo;
  time_signature?: TimeSignature;
  /**
   * A link to the Web API endpoint providing full details of the track.
   *
   */
  track_href?: string;
  /**
   * The object type.
   *
   */
  type?: 'audio_features';
  /**
   * The Spotify URI for the track.
   *
   */
  uri?: string;
  /**
   * A measure from 0.0 to 1.0 describing the musical positiveness conveyed by a track. Tracks with high valence sound more positive (e.g. happy, cheerful, euphoric), while tracks with low valence sound more negative (e.g. sad, depressed, angry).
   *
   */
  valence?: number;
};

/**
 * The object type.
 *
 */
export type type3 = 'audio_features';

export type SimplifiedTrackObject = {
  /**
   * The artists who performed the track. Each artist object includes a link in `href` to more detailed information about the artist.
   */
  artists?: Array<SimplifiedArtistObject>;
  /**
   * A list of the countries in which the track can be played, identified by their [ISO 3166-1 alpha-2](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code.
   *
   */
  available_markets?: Array<string>;
  /**
   * The disc number (usually `1` unless the album consists of more than one disc).
   */
  disc_number?: number;
  /**
   * The track length in milliseconds.
   */
  duration_ms?: number;
  /**
   * Whether or not the track has explicit lyrics ( `true` = yes it does; `false` = no it does not OR unknown).
   */
  explicit?: boolean;
  /**
   * External URLs for this track.
   *
   */
  external_urls?: ExternalUrlObject;
  /**
   * A link to the Web API endpoint providing full details of the track.
   */
  href?: string;
  /**
   * The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the track.
   *
   */
  id?: string;
  /**
   * Part of the response when [Track Relinking](/documentation/web-api/concepts/track-relinking/) is applied. If `true`, the track is playable in the given market. Otherwise `false`.
   *
   */
  is_playable?: boolean;
  /**
   * Part of the response when [Track Relinking](/documentation/web-api/concepts/track-relinking/) is applied and is only part of the response if the track linking, in fact, exists. The requested track has been replaced with a different track. The track in the `linked_from` object contains information about the originally requested track.
   */
  linked_from?: LinkedTrackObject;
  /**
   * Included in the response when a content restriction is applied.
   *
   */
  restrictions?: TrackRestrictionObject;
  /**
   * The name of the track.
   */
  name?: string;
  /**
   * A URL to a 30 second preview (MP3 format) of the track.
   *
   */
  preview_url?: string | null;
  /**
   * The number of the track. If an album has several discs, the track number is the number on the specified disc.
   *
   */
  track_number?: number;
  /**
   * The object type: "track".
   *
   */
  type?: string;
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the track.
   *
   */
  uri?: string;
  /**
   * Whether or not the track is from a local file.
   *
   */
  is_local?: boolean;
};

export type DeviceObject = {
  /**
   * The device ID. This ID is unique and persistent to some extent. However, this is not guaranteed and any cached `device_id` should periodically be cleared out and refetched as necessary.
   */
  id?: string | null;
  /**
   * If this device is the currently active device.
   */
  is_active?: boolean;
  /**
   * If this device is currently in a private session.
   */
  is_private_session?: boolean;
  /**
   * Whether controlling this device is restricted. At present if this is "true" then no Web API commands will be accepted by this device.
   */
  is_restricted?: boolean;
  /**
   * A human-readable name for the device. Some devices have a name that the user can configure (e.g. \"Loudest speaker\") and some devices have a generic name associated with the manufacturer or device model.
   */
  name?: string;
  /**
   * Device type, such as "computer", "smartphone" or "speaker".
   */
  type?: string;
  /**
   * The current volume in percent.
   */
  volume_percent?: number | null;
  /**
   * If this device can be used to set the volume.
   */
  supports_volume?: boolean;
};

export type CursorObject = {
  /**
   * The cursor to use as key to find the next page of items.
   */
  after?: string;
  /**
   * The cursor to use as key to find the previous page of items.
   */
  before?: string;
};

export type CursorPagingObject = {
  /**
   * A link to the Web API endpoint returning the full result of the request.
   */
  href?: string;
  /**
   * The maximum number of items in the response (as set in the query or by default).
   */
  limit?: number;
  /**
   * URL to the next page of items. ( `null` if none)
   */
  next?: string;
  /**
   * The cursors used to find the next set of items.
   */
  cursors?: CursorObject;
  /**
   * The total number of items available to return.
   */
  total?: number;
};

export type CursorPagingPlayHistoryObject = CursorPagingObject & {
  items?: Array<PlayHistoryObject>;
};

export type CursorPagingSimplifiedArtistObject = CursorPagingObject & {
  items?: Array<ArtistObject>;
};

export type PagingObject = {
  /**
   * A link to the Web API endpoint returning the full result of the request
   *
   */
  href: string;
  /**
   * The maximum number of items in the response (as set in the query or by default).
   *
   */
  limit: number;
  /**
   * URL to the next page of items. ( `null` if none)
   *
   */
  next: string | null;
  /**
   * The offset of the items returned (as set in the query or by default)
   *
   */
  offset: number;
  /**
   * URL to the previous page of items. ( `null` if none)
   *
   */
  previous: string | null;
  /**
   * The total number of items available to return.
   *
   */
  total: number;
};

export type PagingPlaylistObject = PagingObject & {
  items?: Array<SimplifiedPlaylistObject>;
};

export type PagingFeaturedPlaylistObject = {
  /**
   * The localized message of a playlist.
   *
   */
  message?: string;
  playlists?: PagingPlaylistObject;
};

export type PagingArtistDiscographyAlbumObject = PagingObject & {
  items?: Array<ArtistDiscographyAlbumObject>;
};

export type PagingSimplifiedAlbumObject = PagingObject & {
  items?: Array<SimplifiedAlbumObject>;
};

export type PagingSavedAlbumObject = PagingObject & {
  items?: Array<SavedAlbumObject>;
};

export type PagingSimplifiedTrackObject = PagingObject & {
  items?: Array<SimplifiedTrackObject>;
};

export type PagingSavedTrackObject = PagingObject & {
  items?: Array<SavedTrackObject>;
};

export type PagingTrackObject = PagingObject & {
  items?: Array<TrackObject>;
};

export type PagingPlaylistTrackObject = PagingObject & {
  items?: Array<PlaylistTrackObject>;
};

export type PagingSimplifiedShowObject = PagingObject & {
  items?: Array<SimplifiedShowObject>;
};

export type PagingSavedShowObject = PagingObject & {
  items?: Array<SavedShowObject>;
};

export type PagingSimplifiedEpisodeObject = PagingObject & {
  items?: Array<SimplifiedEpisodeObject>;
};

export type PagingSavedEpisodeObject = PagingObject & {
  items?: Array<SavedEpisodeObject>;
};

export type PagingSimplifiedAudiobookObject = PagingObject & {
  items?: Array<SimplifiedAudiobookObject>;
};

export type PagingArtistObject = PagingObject & {
  items?: Array<ArtistObject>;
};

export type PagingSimplifiedChapterObject = PagingObject & {
  items?: Array<SimplifiedChapterObject>;
};

export type RecommendationsObject = {
  /**
   * An array of recommendation seed objects.
   *
   */
  seeds: Array<RecommendationSeedObject>;
  /**
   * An array of track object (simplified) ordered according to the parameters supplied.
   *
   */
  tracks: Array<TrackObject>;
};

export type RecommendationSeedObject = {
  /**
   * The number of tracks available after min\_\* and max\_\* filters have been applied.
   *
   */
  afterFilteringSize?: number;
  /**
   * The number of tracks available after relinking for regional availability.
   *
   */
  afterRelinkingSize?: number;
  /**
   * A link to the full track or artist data for this seed. For tracks this will be a link to a Track Object. For artists a link to an Artist Object. For genre seeds, this value will be `null`.
   *
   */
  href?: string;
  /**
   * The id used to select this seed. This will be the same as the string used in the `seed_artists`, `seed_tracks` or `seed_genres` parameter.
   *
   */
  id?: string;
  /**
   * The number of recommended tracks available for this seed.
   *
   */
  initialPoolSize?: number;
  /**
   * The entity type of this seed. One of `artist`, `track` or `genre`.
   *
   */
  type?: string;
};

export type SavedAlbumObject = {
  /**
   * The date and time the album was saved
   * Timestamps are returned in ISO 8601 format as Coordinated Universal Time (UTC) with a zero offset: YYYY-MM-DDTHH:MM:SSZ.
   * If the time is imprecise (for example, the date/time of an album release), an additional field indicates the precision; see for example, release_date in an album object.
   *
   */
  added_at?: string;
  /**
   * Information about the album.
   */
  album?: AlbumObject;
};

export type SavedTrackObject = {
  /**
   * The date and time the track was saved.
   * Timestamps are returned in ISO 8601 format as Coordinated Universal Time (UTC) with a zero offset: YYYY-MM-DDTHH:MM:SSZ.
   * If the time is imprecise (for example, the date/time of an album release), an additional field indicates the precision; see for example, release_date in an album object.
   *
   */
  added_at?: string;
  /**
   * Information about the track.
   */
  track?: TrackObject;
};

export type SavedEpisodeObject = {
  /**
   * The date and time the episode was saved.
   * Timestamps are returned in ISO 8601 format as Coordinated Universal Time (UTC) with a zero offset: YYYY-MM-DDTHH:MM:SSZ.
   *
   */
  added_at?: string;
  /**
   * Information about the episode.
   */
  episode?: EpisodeObject;
};

export type SavedShowObject = {
  /**
   * The date and time the show was saved.
   * Timestamps are returned in ISO 8601 format as Coordinated Universal Time (UTC) with a zero offset: YYYY-MM-DDTHH:MM:SSZ.
   * If the time is imprecise (for example, the date/time of an album release), an additional field indicates the precision; see for example, release_date in an album object.
   *
   */
  added_at?: string;
  /**
   * Information about the show.
   */
  show?: SimplifiedShowObject;
};

export type PlaylistObject = {
  /**
   * `true` if the owner allows other users to modify the playlist.
   *
   */
  collaborative?: boolean;
  /**
   * The playlist description. _Only returned for modified, verified playlists, otherwise_ `null`.
   *
   */
  description?: string | null;
  /**
   * Known external URLs for this playlist.
   *
   */
  external_urls?: ExternalUrlObject;
  /**
   * Information about the followers of the playlist.
   */
  followers?: FollowersObject;
  /**
   * A link to the Web API endpoint providing full details of the playlist.
   *
   */
  href?: string;
  /**
   * The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the playlist.
   *
   */
  id?: string;
  /**
   * Images for the playlist. The array may be empty or contain up to three images. The images are returned by size in descending order. See [Working with Playlists](/documentation/web-api/concepts/playlists). _**Note**: If returned, the source URL for the image (`url`) is temporary and will expire in less than a day._
   *
   */
  images?: Array<ImageObject>;
  /**
   * The name of the playlist.
   *
   */
  name?: string;
  /**
   * The user who owns the playlist
   *
   */
  owner?: PlaylistOwnerObject;
  /**
   * The playlist's public/private status (if it is added to the user's profile): `true` the playlist is public, `false` the playlist is private, `null` the playlist status is not relevant. For more about public/private status, see [Working with Playlists](/documentation/web-api/concepts/playlists)
   *
   */
  public?: boolean;
  /**
   * The version identifier for the current playlist. Can be supplied in other requests to target a specific playlist version
   *
   */
  snapshot_id?: string;
  /**
   * The tracks of the playlist.
   *
   */
  tracks?: PagingPlaylistTrackObject;
  /**
   * The object type: "playlist"
   *
   */
  type?: string;
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the playlist.
   *
   */
  uri?: string;
};

export type SimplifiedPlaylistObject = {
  /**
   * `true` if the owner allows other users to modify the playlist.
   *
   */
  collaborative?: boolean;
  /**
   * The playlist description. _Only returned for modified, verified playlists, otherwise_ `null`.
   *
   */
  description?: string;
  /**
   * Known external URLs for this playlist.
   *
   */
  external_urls?: ExternalUrlObject;
  /**
   * A link to the Web API endpoint providing full details of the playlist.
   *
   */
  href?: string;
  /**
   * The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the playlist.
   *
   */
  id?: string;
  /**
   * Images for the playlist. The array may be empty or contain up to three images. The images are returned by size in descending order. See [Working with Playlists](/documentation/web-api/concepts/playlists). _**Note**: If returned, the source URL for the image (`url`) is temporary and will expire in less than a day._
   *
   */
  images?: Array<ImageObject>;
  /**
   * The name of the playlist.
   *
   */
  name?: string;
  /**
   * The user who owns the playlist
   *
   */
  owner?: PlaylistOwnerObject;
  /**
   * The playlist's public/private status (if it is added to the user's profile): `true` the playlist is public, `false` the playlist is private, `null` the playlist status is not relevant. For more about public/private status, see [Working with Playlists](/documentation/web-api/concepts/playlists)
   *
   */
  public?: boolean;
  /**
   * The version identifier for the current playlist. Can be supplied in other requests to target a specific playlist version
   *
   */
  snapshot_id?: string;
  /**
   * A collection containing a link ( `href` ) to the Web API endpoint where full details of the playlist's tracks can be retrieved, along with the `total` number of tracks in the playlist. Note, a track object may be `null`. This can happen if a track is no longer available.
   *
   */
  tracks?: PlaylistTracksRefObject;
  /**
   * The object type: "playlist"
   *
   */
  type?: string;
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the playlist.
   *
   */
  uri?: string;
};

export type PlaylistTracksRefObject = {
  /**
   * A link to the Web API endpoint where full details of the playlist's tracks can be retrieved.
   *
   */
  href?: string;
  /**
   * Number of tracks in the playlist.
   *
   */
  total?: number;
};

export type PlaylistUserObject = {
  /**
   * Known public external URLs for this user.
   *
   */
  external_urls?: ExternalUrlObject;
  /**
   * Information about the followers of this user.
   *
   */
  followers?: FollowersObject;
  /**
   * A link to the Web API endpoint for this user.
   *
   */
  href?: string;
  /**
   * The [Spotify user ID](/documentation/web-api/concepts/spotify-uris-ids) for this user.
   *
   */
  id?: string;
  /**
   * The object type.
   *
   */
  type?: 'user';
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for this user.
   *
   */
  uri?: string;
};

export type PlaylistOwnerObject = PlaylistUserObject & {
  /**
   * The name displayed on the user's profile. `null` if not available.
   *
   */
  display_name?: string | null;
};

export type CategoryObject = {
  /**
   * A link to the Web API endpoint returning full details of the category.
   *
   */
  href: string;
  /**
   * The category icon, in various sizes.
   *
   */
  icons: Array<ImageObject>;
  /**
   * The [Spotify category ID](/documentation/web-api/concepts/spotify-uris-ids) of the category.
   *
   */
  id: string;
  /**
   * The name of the category.
   *
   */
  name: string;
};

export type TrackObject = {
  /**
   * The album on which the track appears. The album object includes a link in `href` to full information about the album.
   *
   */
  album?: SimplifiedAlbumObject;
  /**
   * The artists who performed the track. Each artist object includes a link in `href` to more detailed information about the artist.
   *
   */
  artists?: Array<SimplifiedArtistObject>;
  /**
   * A list of the countries in which the track can be played, identified by their [ISO 3166-1 alpha-2](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code.
   *
   */
  available_markets?: Array<string>;
  /**
   * The disc number (usually `1` unless the album consists of more than one disc).
   *
   */
  disc_number?: number;
  /**
   * The track length in milliseconds.
   *
   */
  duration_ms?: number;
  /**
   * Whether or not the track has explicit lyrics ( `true` = yes it does; `false` = no it does not OR unknown).
   *
   */
  explicit?: boolean;
  /**
   * Known external IDs for the track.
   *
   */
  external_ids?: ExternalIdObject;
  /**
   * Known external URLs for this track.
   *
   */
  external_urls?: ExternalUrlObject;
  /**
   * A link to the Web API endpoint providing full details of the track.
   *
   */
  href?: string;
  /**
   * The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the track.
   *
   */
  id?: string;
  /**
   * Part of the response when [Track Relinking](/documentation/web-api/concepts/track-relinking) is applied. If `true`, the track is playable in the given market. Otherwise `false`.
   *
   */
  is_playable?: boolean;
  /**
   * Part of the response when [Track Relinking](/documentation/web-api/concepts/track-relinking) is applied, and the requested track has been replaced with different track. The track in the `linked_from` object contains information about the originally requested track.
   *
   */
  linked_from?: {
    [key: string]: unknown;
  };
  /**
   * Included in the response when a content restriction is applied.
   *
   */
  restrictions?: TrackRestrictionObject;
  /**
   * The name of the track.
   *
   */
  name?: string;
  /**
   * The popularity of the track. The value will be between 0 and 100, with 100 being the most popular.<br/>The popularity of a track is a value between 0 and 100, with 100 being the most popular. The popularity is calculated by algorithm and is based, in the most part, on the total number of plays the track has had and how recent those plays are.<br/>Generally speaking, songs that are being played a lot now will have a higher popularity than songs that were played a lot in the past. Duplicate tracks (e.g. the same track from a single and an album) are rated independently. Artist and album popularity is derived mathematically from track popularity. _**Note**: the popularity value may lag actual popularity by a few days: the value is not updated in real time._
   *
   */
  popularity?: number;
  /**
   * A link to a 30 second preview (MP3 format) of the track. Can be `null`
   *
   */
  preview_url?: string | null;
  /**
   * The number of the track. If an album has several discs, the track number is the number on the specified disc.
   *
   */
  track_number?: number;
  /**
   * The object type: "track".
   *
   */
  type?: 'track';
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the track.
   *
   */
  uri?: string;
  /**
   * Whether or not the track is from a local file.
   *
   */
  is_local?: boolean;
};

/**
 * The object type: "track".
 *
 */
export type type4 = 'track';

export type EpisodeObject = EpisodeBase & {
  /**
   * The show on which the episode belongs.
   *
   */
  show: SimplifiedShowObject;
};

export type SimplifiedEpisodeObject = EpisodeBase & {
  [key: string]: unknown;
};

export type EpisodeBase = {
  /**
   * A URL to a 30 second preview (MP3 format) of the episode. `null` if not available.
   *
   */
  audio_preview_url: string | null;
  /**
   * A description of the episode. HTML tags are stripped away from this field, use `html_description` field in case HTML tags are needed.
   *
   */
  description: string;
  /**
   * A description of the episode. This field may contain HTML tags.
   *
   */
  html_description: string;
  /**
   * The episode length in milliseconds.
   *
   */
  duration_ms: number;
  /**
   * Whether or not the episode has explicit content (true = yes it does; false = no it does not OR unknown).
   *
   */
  explicit: boolean;
  /**
   * External URLs for this episode.
   *
   */
  external_urls: ExternalUrlObject;
  /**
   * A link to the Web API endpoint providing full details of the episode.
   *
   */
  href: string;
  /**
   * The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the episode.
   *
   */
  id: string;
  /**
   * The cover art for the episode in various sizes, widest first.
   *
   */
  images: Array<ImageObject>;
  /**
   * True if the episode is hosted outside of Spotify's CDN.
   *
   */
  is_externally_hosted: boolean;
  /**
   * True if the episode is playable in the given market. Otherwise false.
   *
   */
  is_playable: boolean;
  /**
   * The language used in the episode, identified by a [ISO 639](https://en.wikipedia.org/wiki/ISO_639) code. This field is deprecated and might be removed in the future. Please use the `languages` field instead.
   *
   * @deprecated
   */
  language?: string;
  /**
   * A list of the languages used in the episode, identified by their [ISO 639-1](https://en.wikipedia.org/wiki/ISO_639) code.
   *
   */
  languages: Array<string>;
  /**
   * The name of the episode.
   *
   */
  name: string;
  /**
   * The date the episode was first released, for example `"1981-12-15"`. Depending on the precision, it might be shown as `"1981"` or `"1981-12"`.
   *
   */
  release_date: string;
  /**
   * The precision with which `release_date` value is known.
   *
   */
  release_date_precision: 'year' | 'month' | 'day';
  /**
   * The user's most recent position in the episode. Set if the supplied access token is a user token and has the scope 'user-read-playback-position'.
   *
   */
  resume_point?: ResumePointObject;
  /**
   * The object type.
   *
   */
  type: 'episode';
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the episode.
   *
   */
  uri: string;
  /**
   * Included in the response when a content restriction is applied.
   *
   */
  restrictions?: EpisodeRestrictionObject;
};

/**
 * The precision with which `release_date` value is known.
 *
 */
export type release_date_precision = 'year' | 'month' | 'day';

/**
 * The object type.
 *
 */
export type type5 = 'episode';

export type ResumePointObject = {
  /**
   * Whether or not the episode has been fully played by the user.
   *
   */
  fully_played?: boolean;
  /**
   * The user's most recent position in the episode in milliseconds.
   *
   */
  resume_position_ms?: number;
};

export type ShowBase = {
  /**
   * A list of the countries in which the show can be played, identified by their [ISO 3166-1 alpha-2](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code.
   *
   */
  available_markets: Array<string>;
  /**
   * The copyright statements of the show.
   *
   */
  copyrights: Array<CopyrightObject>;
  /**
   * A description of the show. HTML tags are stripped away from this field, use `html_description` field in case HTML tags are needed.
   *
   */
  description: string;
  /**
   * A description of the show. This field may contain HTML tags.
   *
   */
  html_description: string;
  /**
   * Whether or not the show has explicit content (true = yes it does; false = no it does not OR unknown).
   *
   */
  explicit: boolean;
  /**
   * External URLs for this show.
   *
   */
  external_urls: ExternalUrlObject;
  /**
   * A link to the Web API endpoint providing full details of the show.
   *
   */
  href: string;
  /**
   * The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the show.
   *
   */
  id: string;
  /**
   * The cover art for the show in various sizes, widest first.
   *
   */
  images: Array<ImageObject>;
  /**
   * True if all of the shows episodes are hosted outside of Spotify's CDN. This field might be `null` in some cases.
   *
   */
  is_externally_hosted: boolean;
  /**
   * A list of the languages used in the show, identified by their [ISO 639](https://en.wikipedia.org/wiki/ISO_639) code.
   *
   */
  languages: Array<string>;
  /**
   * The media type of the show.
   *
   */
  media_type: string;
  /**
   * The name of the episode.
   *
   */
  name: string;
  /**
   * The publisher of the show.
   *
   */
  publisher: string;
  /**
   * The object type.
   *
   */
  type: 'show';
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the show.
   *
   */
  uri: string;
  /**
   * The total number of episodes in the show.
   *
   */
  total_episodes: number;
};

/**
 * The object type.
 *
 */
export type type6 = 'show';

export type ShowObject = ShowBase & {
  /**
   * The episodes of the show.
   *
   */
  episodes: PagingSimplifiedEpisodeObject;
};

export type SimplifiedShowObject = ShowBase & {
  [key: string]: unknown;
};

export type AudiobookBase = {
  /**
   * The author(s) for the audiobook.
   *
   */
  authors: Array<AuthorObject>;
  /**
   * A list of the countries in which the audiobook can be played, identified by their [ISO 3166-1 alpha-2](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code.
   *
   */
  available_markets: Array<string>;
  /**
   * The copyright statements of the audiobook.
   *
   */
  copyrights: Array<CopyrightObject>;
  /**
   * A description of the audiobook. HTML tags are stripped away from this field, use `html_description` field in case HTML tags are needed.
   *
   */
  description: string;
  /**
   * A description of the audiobook. This field may contain HTML tags.
   *
   */
  html_description: string;
  /**
   * The edition of the audiobook.
   *
   */
  edition?: string;
  /**
   * Whether or not the audiobook has explicit content (true = yes it does; false = no it does not OR unknown).
   *
   */
  explicit: boolean;
  /**
   * External URLs for this audiobook.
   *
   */
  external_urls: ExternalUrlObject;
  /**
   * A link to the Web API endpoint providing full details of the audiobook.
   *
   */
  href: string;
  /**
   * The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the audiobook.
   *
   */
  id: string;
  /**
   * The cover art for the audiobook in various sizes, widest first.
   *
   */
  images: Array<ImageObject>;
  /**
   * A list of the languages used in the audiobook, identified by their [ISO 639](https://en.wikipedia.org/wiki/ISO_639) code.
   *
   */
  languages: Array<string>;
  /**
   * The media type of the audiobook.
   *
   */
  media_type: string;
  /**
   * The name of the audiobook.
   *
   */
  name: string;
  /**
   * The narrator(s) for the audiobook.
   *
   */
  narrators: Array<NarratorObject>;
  /**
   * The publisher of the audiobook.
   *
   */
  publisher: string;
  /**
   * The object type.
   *
   */
  type: 'audiobook';
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the audiobook.
   *
   */
  uri: string;
  /**
   * The number of chapters in this audiobook.
   *
   */
  total_chapters: number;
};

/**
 * The object type.
 *
 */
export type type7 = 'audiobook';

export type AudiobookObject = AudiobookBase & {
  /**
   * The chapters of the audiobook.
   *
   */
  chapters: PagingSimplifiedChapterObject;
};

export type SimplifiedAudiobookObject = AudiobookBase & {
  [key: string]: unknown;
};

export type AlbumBase = {
  /**
   * The type of the album.
   *
   */
  album_type: 'album' | 'single' | 'compilation';
  /**
   * The number of tracks in the album.
   */
  total_tracks: number;
  /**
   * The markets in which the album is available: [ISO 3166-1 alpha-2 country codes](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). _**NOTE**: an album is considered available in a market when at least 1 of its tracks is available in that market._
   *
   */
  available_markets: Array<string>;
  /**
   * Known external URLs for this album.
   *
   */
  external_urls: ExternalUrlObject;
  /**
   * A link to the Web API endpoint providing full details of the album.
   *
   */
  href: string;
  /**
   * The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the album.
   *
   */
  id: string;
  /**
   * The cover art for the album in various sizes, widest first.
   *
   */
  images: Array<ImageObject>;
  /**
   * The name of the album. In case of an album takedown, the value may be an empty string.
   *
   */
  name: string;
  /**
   * The date the album was first released.
   *
   */
  release_date: string;
  /**
   * The precision with which `release_date` value is known.
   *
   */
  release_date_precision: 'year' | 'month' | 'day';
  /**
   * Included in the response when a content restriction is applied.
   *
   */
  restrictions?: AlbumRestrictionObject;
  /**
   * The object type.
   *
   */
  type: 'album';
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the album.
   *
   */
  uri: string;
};

/**
 * The type of the album.
 *
 */
export type album_type = 'album' | 'single' | 'compilation';

/**
 * The object type.
 *
 */
export type type8 = 'album';

export type SimplifiedAlbumObject = AlbumBase & {
  /**
   * The artists of the album. Each artist object includes a link in `href` to more detailed information about the artist.
   *
   */
  artists: Array<SimplifiedArtistObject>;
};

export type ArtistDiscographyAlbumObject = SimplifiedAlbumObject & {
  /**
   * This field describes the relationship between the artist and the album.
   *
   */
  album_group: 'album' | 'single' | 'compilation' | 'appears_on';
};

/**
 * This field describes the relationship between the artist and the album.
 *
 */
export type album_group = 'album' | 'single' | 'compilation' | 'appears_on';

export type ChapterObject = ChapterBase & {
  /**
   * The audiobook for which the chapter belongs.
   *
   */
  audiobook: SimplifiedAudiobookObject;
};

export type SimplifiedChapterObject = ChapterBase & {
  [key: string]: unknown;
};

export type ChapterBase = {
  /**
   * A URL to a 30 second preview (MP3 format) of the chapter. `null` if not available.
   *
   */
  audio_preview_url: string | null;
  /**
   * A list of the countries in which the chapter can be played, identified by their [ISO 3166-1 alpha-2](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code.
   *
   */
  available_markets?: Array<string>;
  /**
   * The number of the chapter
   *
   */
  chapter_number: number;
  /**
   * A description of the chapter. HTML tags are stripped away from this field, use `html_description` field in case HTML tags are needed.
   *
   */
  description: string;
  /**
   * A description of the chapter. This field may contain HTML tags.
   *
   */
  html_description: string;
  /**
   * The chapter length in milliseconds.
   *
   */
  duration_ms: number;
  /**
   * Whether or not the chapter has explicit content (true = yes it does; false = no it does not OR unknown).
   *
   */
  explicit: boolean;
  /**
   * External URLs for this chapter.
   *
   */
  external_urls: ExternalUrlObject;
  /**
   * A link to the Web API endpoint providing full details of the chapter.
   *
   */
  href: string;
  /**
   * The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the chapter.
   *
   */
  id: string;
  /**
   * The cover art for the chapter in various sizes, widest first.
   *
   */
  images: Array<ImageObject>;
  /**
   * True if the chapter is playable in the given market. Otherwise false.
   *
   */
  is_playable: boolean;
  /**
   * A list of the languages used in the chapter, identified by their [ISO 639-1](https://en.wikipedia.org/wiki/ISO_639) code.
   *
   */
  languages: Array<string>;
  /**
   * The name of the chapter.
   *
   */
  name: string;
  /**
   * The date the chapter was first released, for example `"1981-12-15"`. Depending on the precision, it might be shown as `"1981"` or `"1981-12"`.
   *
   */
  release_date: string;
  /**
   * The precision with which `release_date` value is known.
   *
   */
  release_date_precision: 'year' | 'month' | 'day';
  /**
   * The user's most recent position in the chapter. Set if the supplied access token is a user token and has the scope 'user-read-playback-position'.
   *
   */
  resume_point?: ResumePointObject;
  /**
   * The object type.
   *
   */
  type: 'episode';
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the chapter.
   *
   */
  uri: string;
  /**
   * Included in the response when a content restriction is applied.
   *
   */
  restrictions?: ChapterRestrictionObject;
};

export type AlbumObject = AlbumBase & {
  /**
   * The artists of the album. Each artist object includes a link in `href` to more detailed information about the artist.
   *
   */
  artists?: Array<SimplifiedArtistObject>;
  /**
   * The tracks of the album.
   *
   */
  tracks?: PagingSimplifiedTrackObject;
  /**
   * The copyright statements of the album.
   *
   */
  copyrights?: Array<CopyrightObject>;
  /**
   * Known external IDs for the album.
   *
   */
  external_ids?: ExternalIdObject;
  /**
   * A list of the genres the album is associated with. If not yet classified, the array is empty.
   *
   */
  genres?: Array<string>;
  /**
   * The label associated with the album.
   *
   */
  label?: string;
  /**
   * The popularity of the album. The value will be between 0 and 100, with 100 being the most popular.
   *
   */
  popularity?: number;
} & {
  /**
   * The artists of the album. Each artist object includes a link in `href` to more detailed information about the artist.
   *
   */
  artists: Array<SimplifiedArtistObject>;
  /**
   * The tracks of the album.
   *
   */
  tracks: PagingSimplifiedTrackObject;
  /**
   * The copyright statements of the album.
   *
   */
  copyrights: Array<CopyrightObject>;
  /**
   * Known external IDs for the album.
   *
   */
  external_ids: ExternalIdObject;
  /**
   * A list of the genres the album is associated with. If not yet classified, the array is empty.
   *
   */
  genres: Array<string>;
  /**
   * The label associated with the album.
   *
   */
  label: string;
  /**
   * The popularity of the album. The value will be between 0 and 100, with 100 being the most popular.
   *
   */
  popularity: number;
};

export type ContextObject = {
  /**
   * The object type, e.g. "artist", "playlist", "album", "show".
   *
   */
  type?: string;
  /**
   * A link to the Web API endpoint providing full details of the track.
   */
  href?: string;
  /**
   * External URLs for this context.
   */
  external_urls?: ExternalUrlObject;
  /**
   * The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the context.
   *
   */
  uri?: string;
};

export type CopyrightObject = {
  /**
   * The copyright text for this content.
   *
   */
  text?: string;
  /**
   * The type of copyright: `C` = the copyright, `P` = the sound recording (performance) copyright.
   *
   */
  type?: string;
};

export type AuthorObject = {
  /**
   * The name of the author.
   *
   */
  name?: string;
};

export type NarratorObject = {
  /**
   * The name of the Narrator.
   *
   */
  name?: string;
};

export type ExternalIdObject = {
  /**
   * [International Standard Recording Code](http://en.wikipedia.org/wiki/International_Standard_Recording_Code)
   *
   */
  isrc?: string;
  /**
   * [International Article Number](http://en.wikipedia.org/wiki/International_Article_Number_%28EAN%29)
   *
   */
  ean?: string;
  /**
   * [Universal Product Code](http://en.wikipedia.org/wiki/Universal_Product_Code)
   *
   */
  upc?: string;
};

export type ExternalUrlObject = {
  /**
   * The [Spotify URL](/documentation/web-api/concepts/spotify-uris-ids) for the object.
   *
   */
  spotify?: string;
};

export type FollowersObject = {
  /**
   * This will always be set to null, as the Web API does not support it at the moment.
   *
   */
  href?: string | null;
  /**
   * The total number of followers.
   *
   */
  total?: number;
};

export type ImageObject = {
  /**
   * The source URL of the image.
   *
   */
  url: string;
  /**
   * The image height in pixels.
   *
   */
  height: number | null;
  /**
   * The image width in pixels.
   *
   */
  width: number | null;
};

export type ExplicitContentSettingsObject = {
  /**
   * When `true`, indicates that explicit content should not be played.
   *
   */
  filter_enabled?: boolean;
  /**
   * When `true`, indicates that the explicit content setting is locked and can't be changed by the user.
   *
   */
  filter_locked?: boolean;
};

export type ParameterPathAlbumId = string;

export type ParameterPathPlaylistId = string;

export type ParameterQueryMarket = string;

export type ParameterQueryLimit = number;

export type ParameterQueryOffset = number;

export type ParameterQueryAdditionalTypes = string;

export type ParameterQueryAlbumIds = string;

export type ParameterPathArtistId = string;

export type ParameterPathShowId = string;

export type ParameterPathAudiobookId = string;

export type ParameterQueryAudiobookIds = string;

export type ParameterPathChapterId = string;

export type ParameterQueryChapterIds = string;

export type ParameterQueryTrackIds = string;

export type ParameterQueryIncludeGroups = string;

export type ParameterQueryShowIds = string;

export type ParameterPathUserId = string;

export type GetAnAlbumData = {
  path: {
    id: string;
  };
  query?: {
    market?: string;
  };
};

export type GetAnAlbumResponse = AlbumObject;

export type GetAnAlbumError = {
  error: ErrorObject;
};

export type GetMultipleAlbumsData = {
  query: {
    ids: string;
    market?: string;
  };
};

export type GetMultipleAlbumsResponse = {
  albums: Array<AlbumObject>;
};

export type GetMultipleAlbumsError = {
  error: ErrorObject;
};

export type GetAnAlbumsTracksData = {
  path: {
    id: string;
  };
  query?: {
    limit?: number;
    market?: string;
    offset?: number;
  };
};

export type GetAnAlbumsTracksResponse = PagingSimplifiedTrackObject;

export type GetAnAlbumsTracksError = {
  error: ErrorObject;
};

export type GetAnArtistData = {
  path: {
    id: string;
  };
};

export type GetAnArtistResponse = ArtistObject;

export type GetAnArtistError = {
  error: ErrorObject;
};

export type GetMultipleArtistsData = {
  query: {
    ids: string;
  };
};

export type GetMultipleArtistsResponse = {
  artists: Array<ArtistObject>;
};

export type GetMultipleArtistsError = {
  error: ErrorObject;
};

export type GetAnArtistsAlbumsData = {
  path: {
    id: string;
  };
  query?: {
    include_groups?: string;
    limit?: number;
    market?: string;
    offset?: number;
  };
};

export type GetAnArtistsAlbumsResponse = PagingArtistDiscographyAlbumObject;

export type GetAnArtistsAlbumsError = {
  error: ErrorObject;
};

export type GetAnArtistsTopTracksData = {
  path: {
    id: string;
  };
  query?: {
    market?: string;
  };
};

export type GetAnArtistsTopTracksResponse = {
  tracks: Array<TrackObject>;
};

export type GetAnArtistsTopTracksError = {
  error: ErrorObject;
};

export type GetAnArtistsRelatedArtistsData = {
  path: {
    id: string;
  };
};

export type GetAnArtistsRelatedArtistsResponse = {
  artists: Array<ArtistObject>;
};

export type GetAnArtistsRelatedArtistsError = {
  error: ErrorObject;
};

export type GetAshowData = {
  path: {
    id: string;
  };
  query?: {
    market?: string;
  };
};

export type GetAshowResponse = ShowObject;

export type GetAshowError = {
  error: ErrorObject;
};

export type GetMultipleShowsData = {
  query: {
    ids: string;
    market?: string;
  };
};

export type GetMultipleShowsResponse = {
  shows: Array<SimplifiedShowObject>;
};

export type GetMultipleShowsError = {
  error: ErrorObject;
};

export type GetAshowsEpisodesData = {
  path: {
    id: string;
  };
  query?: {
    limit?: number;
    market?: string;
    offset?: number;
  };
};

export type GetAshowsEpisodesResponse = PagingSimplifiedEpisodeObject;

export type GetAshowsEpisodesError = {
  error: ErrorObject;
};

export type GetAnEpisodeData = {
  path: {
    id: string;
  };
  query?: {
    market?: string;
  };
};

export type GetAnEpisodeResponse = EpisodeObject;

export type GetAnEpisodeError = {
  error: ErrorObject;
};

export type GetMultipleEpisodesData = {
  query: {
    ids: string;
    market?: string;
  };
};

export type GetMultipleEpisodesResponse = {
  episodes: Array<EpisodeObject>;
};

export type GetMultipleEpisodesError = {
  error: ErrorObject;
};

export type GetAnAudiobookData = {
  path: {
    id: string;
  };
  query?: {
    market?: string;
  };
};

export type GetAnAudiobookResponse = AudiobookObject;

export type GetAnAudiobookError = {
  error: ErrorObject;
};

export type GetMultipleAudiobooksData = {
  query: {
    ids: string;
    market?: string;
  };
};

export type GetMultipleAudiobooksResponse = {
  audiobooks: Array<AudiobookObject>;
};

export type GetMultipleAudiobooksError = {
  error: ErrorObject;
};

export type GetAudiobookChaptersData = {
  path: {
    id: string;
  };
  query?: {
    limit?: number;
    market?: string;
    offset?: number;
  };
};

export type GetAudiobookChaptersResponse = PagingSimplifiedChapterObject;

export type GetAudiobookChaptersError = {
  error: ErrorObject;
};

export type GetUsersSavedAudiobooksData = {
  query?: {
    limit?: number;
    offset?: number;
  };
};

export type GetUsersSavedAudiobooksResponse = PagingSimplifiedAudiobookObject;

export type GetUsersSavedAudiobooksError = {
  error: ErrorObject;
};

export type SaveAudiobooksUserData = {
  query: {
    ids: string;
  };
};

export type SaveAudiobooksUserResponse = unknown;

export type SaveAudiobooksUserError = {
  error: ErrorObject;
};

export type RemoveAudiobooksUserData = {
  query: {
    ids: string;
  };
};

export type RemoveAudiobooksUserResponse = unknown;

export type RemoveAudiobooksUserError = {
  error: ErrorObject;
};

export type CheckUsersSavedAudiobooksData = {
  query: {
    ids: string;
  };
};

export type CheckUsersSavedAudiobooksResponse = Array<boolean>;

export type CheckUsersSavedAudiobooksError = {
  error: ErrorObject;
};

export type GetAchapterData = {
  path: {
    id: string;
  };
  query?: {
    market?: string;
  };
};

export type GetAchapterResponse = ChapterObject;

export type GetAchapterError = {
  error: ErrorObject;
};

export type GetSeveralChaptersData = {
  query: {
    ids: string;
    market?: string;
  };
};

export type GetSeveralChaptersResponse = {
  chapters: Array<ChapterObject>;
};

export type GetSeveralChaptersError = {
  error: ErrorObject;
};

export type GetTrackData = {
  path: {
    id: string;
  };
  query?: {
    market?: string;
  };
};

export type GetTrackResponse = TrackObject;

export type GetTrackError = {
  error: ErrorObject;
};

export type GetSeveralTracksData = {
  query: {
    ids: string;
    market?: string;
  };
};

export type GetSeveralTracksResponse = {
  tracks: Array<TrackObject>;
};

export type GetSeveralTracksError = {
  error: ErrorObject;
};

export type SearchData = {
  query: {
    include_external?: 'audio';
    limit?: number;
    market?: string;
    offset?: number;
    q: string;
    type: Array<'album' | 'artist' | 'playlist' | 'track' | 'show' | 'episode' | 'audiobook'>;
  };
};

export type SearchResponse = {
  tracks?: PagingTrackObject;
  artists?: PagingArtistObject;
  albums?: PagingSimplifiedAlbumObject;
  playlists?: PagingPlaylistObject;
  shows?: PagingSimplifiedShowObject;
  episodes?: PagingSimplifiedEpisodeObject;
  audiobooks?: PagingSimplifiedAudiobookObject;
};

export type SearchError = {
  error: ErrorObject;
};

export type GetCurrentUsersProfileResponse = PrivateUserObject;

export type GetCurrentUsersProfileError = {
  error: ErrorObject;
};

export type GetPlaylistData = {
  path: {
    playlist_id: string;
  };
  query?: {
    additional_types?: string;
    fields?: string;
    market?: string;
  };
};

export type GetPlaylistResponse = PlaylistObject;

export type GetPlaylistError = {
  error: ErrorObject;
};

export type ChangePlaylistDetailsData = {
  body?: {
    /**
     * The new name for the playlist, for example `"My New Playlist Title"`
     *
     */
    name?: string;
    /**
     * The playlist's public/private status (if it should be added to the user's profile or not): `true` the playlist will be public, `false` the playlist will be private, `null` the playlist status is not relevant. For more about public/private status, see [Working with Playlists](/documentation/web-api/concepts/playlists)
     *
     */
    public?: boolean;
    /**
     * If `true`, the playlist will become collaborative and other users will be able to modify the playlist in their Spotify client. <br/>
     * _**Note**: You can only set `collaborative` to `true` on non-public playlists._
     *
     */
    collaborative?: boolean;
    /**
     * Value for playlist description as displayed in Spotify Clients and in the Web API.
     *
     */
    description?: string;
    [key: string]: unknown | string | boolean;
  };
  path: {
    playlist_id: string;
  };
};

export type ChangePlaylistDetailsResponse = unknown;

export type ChangePlaylistDetailsError = {
  error: ErrorObject;
};

export type GetPlaylistsTracksData = {
  path: {
    playlist_id: string;
  };
  query?: {
    additional_types?: string;
    fields?: string;
    limit?: number;
    market?: string;
    offset?: number;
  };
};

export type GetPlaylistsTracksResponse = PagingPlaylistTrackObject;

export type GetPlaylistsTracksError = {
  error: ErrorObject;
};

export type AddTracksToPlaylistData = {
  body?: {
    /**
     * A JSON array of the [Spotify URIs](/documentation/web-api/concepts/spotify-uris-ids) to add. For example: `{"uris": ["spotify:track:4iV5W9uYEdYUVa79Axb7Rh","spotify:track:1301WleyT98MSxVHPZCA6M", "spotify:episode:512ojhOuo1ktJprKbVcKyQ"]}`<br/>A maximum of 100 items can be added in one request. _**Note**: if the `uris` parameter is present in the query string, any URIs listed here in the body will be ignored._
     *
     */
    uris?: Array<string>;
    /**
     * The position to insert the items, a zero-based index. For example, to insert the items in the first position: `position=0` ; to insert the items in the third position: `position=2`. If omitted, the items will be appended to the playlist. Items are added in the order they appear in the uris array. For example: `{"uris": ["spotify:track:4iV5W9uYEdYUVa79Axb7Rh","spotify:track:1301WleyT98MSxVHPZCA6M"], "position": 3}`
     *
     */
    position?: number;
    [key: string]: unknown | string | number;
  };
  path: {
    playlist_id: string;
  };
  query?: {
    position?: number;
    uris?: string;
  };
};

export type AddTracksToPlaylistResponse = {
  snapshot_id?: string;
};

export type AddTracksToPlaylistError = {
  error: ErrorObject;
};

export type ReorderOrReplacePlaylistsTracksData = {
  body?: {
    uris?: Array<string>;
    /**
     * The position of the first item to be reordered.
     *
     */
    range_start?: number;
    /**
     * The position where the items should be inserted.<br/>To reorder the items to the end of the playlist, simply set _insert_before_ to the position after the last item.<br/>Examples:<br/>To reorder the first item to the last position in a playlist with 10 items, set _range_start_ to 0, and _insert_before_ to 10.<br/>To reorder the last item in a playlist with 10 items to the start of the playlist, set _range_start_ to 9, and _insert_before_ to 0.
     *
     */
    insert_before?: number;
    /**
     * The amount of items to be reordered. Defaults to 1 if not set.<br/>The range of items to be reordered begins from the _range_start_ position, and includes the _range_length_ subsequent items.<br/>Example:<br/>To move the items at index 9-10 to the start of the playlist, _range_start_ is set to 9, and _range_length_ is set to 2.
     *
     */
    range_length?: number;
    /**
     * The playlist's snapshot ID against which you want to make the changes.
     *
     */
    snapshot_id?: string;
    [key: string]: unknown | string | number;
  };
  path: {
    playlist_id: string;
  };
  query?: {
    uris?: string;
  };
};

export type ReorderOrReplacePlaylistsTracksResponse = {
  snapshot_id?: string;
};

export type ReorderOrReplacePlaylistsTracksError = {
  error: ErrorObject;
};

export type RemoveTracksPlaylistData = {
  body?: {
    /**
     * An array of objects containing [Spotify URIs](/documentation/web-api/concepts/spotify-uris-ids) of the tracks or episodes to remove.
     * For example: `{ "tracks": [{ "uri": "spotify:track:4iV5W9uYEdYUVa79Axb7Rh" },{ "uri": "spotify:track:1301WleyT98MSxVHPZCA6M" }] }`. A maximum of 100 objects can be sent at once.
     *
     */
    tracks: Array<{
      /**
       * Spotify URI
       */
      uri?: string;
    }>;
    /**
     * The playlist's snapshot ID against which you want to make the changes.
     * The API will validate that the specified items exist and in the specified positions and make the changes,
     * even if more recent changes have been made to the playlist.
     *
     */
    snapshot_id?: string;
  };
  path: {
    playlist_id: string;
  };
};

export type RemoveTracksPlaylistResponse = {
  snapshot_id?: string;
};

export type RemoveTracksPlaylistError = {
  error: ErrorObject;
};

export type GetAlistOfCurrentUsersPlaylistsData = {
  query?: {
    limit?: number;
    offset?: number;
  };
};

export type GetAlistOfCurrentUsersPlaylistsResponse = PagingPlaylistObject;

export type GetAlistOfCurrentUsersPlaylistsError = {
  error: ErrorObject;
};

export type GetUsersSavedAlbumsData = {
  query?: {
    limit?: number;
    market?: string;
    offset?: number;
  };
};

export type GetUsersSavedAlbumsResponse = PagingSavedAlbumObject;

export type GetUsersSavedAlbumsError = {
  error: ErrorObject;
};

export type SaveAlbumsUserData = {
  body?: {
    /**
     * A JSON array of the [Spotify IDs](/documentation/web-api/concepts/spotify-uris-ids). For example: `["4iV5W9uYEdYUVa79Axb7Rh", "1301WleyT98MSxVHPZCA6M"]`<br/>A maximum of 50 items can be specified in one request. _**Note**: if the `ids` parameter is present in the query string, any IDs listed here in the body will be ignored._
     *
     */
    ids?: Array<string>;
    [key: string]: unknown | string;
  };
  query: {
    ids: string;
  };
};

export type SaveAlbumsUserResponse = unknown;

export type SaveAlbumsUserError = {
  error: ErrorObject;
};

export type RemoveAlbumsUserData = {
  body?: {
    /**
     * A JSON array of the [Spotify IDs](/documentation/web-api/concepts/spotify-uris-ids). For example: `["4iV5W9uYEdYUVa79Axb7Rh", "1301WleyT98MSxVHPZCA6M"]`<br/>A maximum of 50 items can be specified in one request. _**Note**: if the `ids` parameter is present in the query string, any IDs listed here in the body will be ignored._
     *
     */
    ids?: Array<string>;
    [key: string]: unknown | string;
  };
  query: {
    ids: string;
  };
};

export type RemoveAlbumsUserResponse = unknown;

export type RemoveAlbumsUserError = {
  error: ErrorObject;
};

export type CheckUsersSavedAlbumsData = {
  query: {
    ids: string;
  };
};

export type CheckUsersSavedAlbumsResponse = Array<boolean>;

export type CheckUsersSavedAlbumsError = {
  error: ErrorObject;
};

export type GetUsersSavedTracksData = {
  query?: {
    limit?: number;
    market?: string;
    offset?: number;
  };
};

export type GetUsersSavedTracksResponse = PagingSavedTrackObject;

export type GetUsersSavedTracksError = {
  error: ErrorObject;
};

export type SaveTracksUserData = {
  body?: {
    /**
     * A JSON array of the [Spotify IDs](/documentation/web-api/concepts/spotify-uris-ids). For example: `["4iV5W9uYEdYUVa79Axb7Rh", "1301WleyT98MSxVHPZCA6M"]`<br/>A maximum of 50 items can be specified in one request. _**Note**: if the `ids` parameter is present in the query string, any IDs listed here in the body will be ignored._
     *
     */
    ids?: Array<string>;
    [key: string]: unknown | string;
  };
  query: {
    ids: string;
  };
};

export type SaveTracksUserResponse = unknown;

export type SaveTracksUserError = {
  error: ErrorObject;
};

export type RemoveTracksUserData = {
  body?: {
    /**
     * A JSON array of the [Spotify IDs](/documentation/web-api/concepts/spotify-uris-ids). For example: `["4iV5W9uYEdYUVa79Axb7Rh", "1301WleyT98MSxVHPZCA6M"]`<br/>A maximum of 50 items can be specified in one request. _**Note**: if the `ids` parameter is present in the query string, any IDs listed here in the body will be ignored._
     *
     */
    ids?: Array<string>;
    [key: string]: unknown | string;
  };
  query: {
    ids: string;
  };
};

export type RemoveTracksUserResponse = unknown;

export type RemoveTracksUserError = {
  error: ErrorObject;
};

export type CheckUsersSavedTracksData = {
  query: {
    ids: string;
  };
};

export type CheckUsersSavedTracksResponse = Array<boolean>;

export type CheckUsersSavedTracksError = {
  error: ErrorObject;
};

export type GetUsersSavedEpisodesData = {
  query?: {
    limit?: number;
    market?: string;
    offset?: number;
  };
};

export type GetUsersSavedEpisodesResponse = PagingSavedEpisodeObject;

export type GetUsersSavedEpisodesError = {
  error: ErrorObject;
};

export type SaveEpisodesUserData = {
  body?: {
    /**
     * A JSON array of the [Spotify IDs](/documentation/web-api/concepts/spotify-uris-ids). <br/>A maximum of 50 items can be specified in one request. _**Note**: if the `ids` parameter is present in the query string, any IDs listed here in the body will be ignored._
     *
     */
    ids?: Array<string>;
    [key: string]: unknown | string;
  };
  query: {
    ids: string;
  };
};

export type SaveEpisodesUserResponse = unknown;

export type SaveEpisodesUserError = {
  error: ErrorObject;
};

export type RemoveEpisodesUserData = {
  body?: {
    /**
     * A JSON array of the [Spotify IDs](/documentation/web-api/concepts/spotify-uris-ids). <br/>A maximum of 50 items can be specified in one request. _**Note**: if the `ids` parameter is present in the query string, any IDs listed here in the body will be ignored._
     *
     */
    ids?: Array<string>;
    [key: string]: unknown | string;
  };
  query: {
    ids: string;
  };
};

export type RemoveEpisodesUserResponse = unknown;

export type RemoveEpisodesUserError = {
  error: ErrorObject;
};

export type CheckUsersSavedEpisodesData = {
  query: {
    ids: string;
  };
};

export type CheckUsersSavedEpisodesResponse = Array<boolean>;

export type CheckUsersSavedEpisodesError = {
  error: ErrorObject;
};

export type GetUsersSavedShowsData = {
  query?: {
    limit?: number;
    offset?: number;
  };
};

export type GetUsersSavedShowsResponse = PagingSavedShowObject;

export type GetUsersSavedShowsError = {
  error: ErrorObject;
};

export type SaveShowsUserData = {
  query: {
    ids: string;
  };
};

export type SaveShowsUserResponse = unknown;

export type SaveShowsUserError = {
  error: ErrorObject;
};

export type RemoveShowsUserData = {
  query: {
    ids: string;
    market?: string;
  };
};

export type RemoveShowsUserResponse = unknown;

export type RemoveShowsUserError = {
  error: ErrorObject;
};

export type CheckUsersSavedShowsData = {
  query: {
    ids: string;
  };
};

export type CheckUsersSavedShowsResponse = Array<boolean>;

export type CheckUsersSavedShowsError = {
  error: ErrorObject;
};

export type GetUsersTopArtistsAndTracksData = {
  path: {
    type: 'artists' | 'tracks';
  };
  query?: {
    limit?: number;
    offset?: number;
    time_range?: string;
  };
};

export type GetUsersTopArtistsAndTracksResponse = PagingObject & {
  items?: Array<ArtistObject | TrackObject>;
};

export type GetUsersTopArtistsAndTracksError = {
  error: ErrorObject;
};

export type GetUsersProfileData = {
  path: {
    user_id: string;
  };
};

export type GetUsersProfileResponse = PublicUserObject;

export type GetUsersProfileError = {
  error: ErrorObject;
};

export type GetListUsersPlaylistsData = {
  path: {
    user_id: string;
  };
  query?: {
    limit?: number;
    offset?: number;
  };
};

export type GetListUsersPlaylistsResponse = PagingPlaylistObject;

export type GetListUsersPlaylistsError = {
  error: ErrorObject;
};

export type CreatePlaylistData = {
  body?: {
    /**
     * The name for the new playlist, for example `"Your Coolest Playlist"`. This name does not need to be unique; a user may have several playlists with the same name.
     *
     */
    name: string;
    /**
     * Defaults to `true`. The playlist's public/private status (if it should be added to the user's profile or not): `true` the playlist will be public, `false` the playlist will be private. To be able to create private playlists, the user must have granted the `playlist-modify-private` [scope](/documentation/web-api/concepts/scopes/#list-of-scopes). For more about public/private status, see [Working with Playlists](/documentation/web-api/concepts/playlists)
     *
     */
    public?: boolean;
    /**
     * Defaults to `false`. If `true` the playlist will be collaborative. _**Note**: to create a collaborative playlist you must also set `public` to `false`. To create collaborative playlists you must have granted `playlist-modify-private` and `playlist-modify-public` [scopes](/documentation/web-api/concepts/scopes/#list-of-scopes)._
     *
     */
    collaborative?: boolean;
    /**
     * value for playlist description as displayed in Spotify Clients and in the Web API.
     *
     */
    description?: string;
    [key: string]: unknown | string | boolean;
  };
  path: {
    user_id: string;
  };
};

export type CreatePlaylistResponse = PlaylistObject;

export type CreatePlaylistError = {
  error: ErrorObject;
};

export type FollowPlaylistData = {
  body?: {
    /**
     * Defaults to `true`. If `true` the playlist will be included in user's public playlists (added to profile), if `false` it will remain private. For more about public/private status, see [Working with Playlists](/documentation/web-api/concepts/playlists)
     *
     */
    public?: boolean;
    [key: string]: unknown | boolean;
  };
  path: {
    playlist_id: string;
  };
};

export type FollowPlaylistResponse = unknown;

export type FollowPlaylistError = {
  error: ErrorObject;
};

export type UnfollowPlaylistData = {
  path: {
    playlist_id: string;
  };
};

export type UnfollowPlaylistResponse = unknown;

export type UnfollowPlaylistError = {
  error: ErrorObject;
};

export type GetFeaturedPlaylistsData = {
  query?: {
    limit?: number;
    locale?: string;
    offset?: number;
  };
};

export type GetFeaturedPlaylistsResponse = PagingFeaturedPlaylistObject;

export type GetFeaturedPlaylistsError = {
  error: ErrorObject;
};

export type GetCategoriesData = {
  query?: {
    limit?: number;
    locale?: string;
    offset?: number;
  };
};

export type GetCategoriesResponse = {
  categories: PagingObject & {
    items?: Array<CategoryObject>;
  };
};

export type GetCategoriesError = {
  error: ErrorObject;
};

export type GetAcategoryData = {
  path: {
    category_id: string;
  };
  query?: {
    locale?: string;
  };
};

export type GetAcategoryResponse = CategoryObject;

export type GetAcategoryError = {
  error: ErrorObject;
};

export type GetAcategoriesPlaylistsData = {
  path: {
    category_id: string;
  };
  query?: {
    limit?: number;
    offset?: number;
  };
};

export type GetAcategoriesPlaylistsResponse = PagingFeaturedPlaylistObject;

export type GetAcategoriesPlaylistsError = {
  error: ErrorObject;
};

export type GetPlaylistCoverData = {
  path: {
    playlist_id: string;
  };
};

export type GetPlaylistCoverResponse = Array<ImageObject>;

export type GetPlaylistCoverError = {
  error: ErrorObject;
};

export type UploadCustomPlaylistCoverData = {
  body?: string;
  path: {
    playlist_id: string;
  };
};

export type UploadCustomPlaylistCoverResponse = unknown;

export type UploadCustomPlaylistCoverError = {
  error: ErrorObject;
};

export type GetNewReleasesData = {
  query?: {
    limit?: number;
    offset?: number;
  };
};

export type GetNewReleasesResponse = {
  albums: PagingSimplifiedAlbumObject;
};

export type GetNewReleasesError = {
  error: ErrorObject;
};

export type GetFollowedData = {
  query: {
    after?: string;
    limit?: number;
    type: 'artist';
  };
};

export type GetFollowedResponse = {
  artists: CursorPagingSimplifiedArtistObject;
};

export type GetFollowedError = {
  error: ErrorObject;
};

export type FollowArtistsUsersData = {
  body?: {
    /**
     * A JSON array of the artist or user [Spotify IDs](/documentation/web-api/concepts/spotify-uris-ids).
     * For example: `{ids:["74ASZWbe4lXaubB36ztrGX", "08td7MxkoHQkXnWAYD8d6Q"]}`. A maximum of 50 IDs can be sent in one request. _**Note**: if the `ids` parameter is present in the query string, any IDs listed here in the body will be ignored._
     *
     */
    ids: Array<string>;
    [key: string]: unknown | string;
  };
  query: {
    ids: string;
    type: 'artist' | 'user';
  };
};

export type FollowArtistsUsersResponse = void;

export type FollowArtistsUsersError = {
  error: ErrorObject;
};

export type UnfollowArtistsUsersData = {
  body?: {
    /**
     * A JSON array of the artist or user [Spotify IDs](/documentation/web-api/concepts/spotify-uris-ids). For example: `{ids:["74ASZWbe4lXaubB36ztrGX", "08td7MxkoHQkXnWAYD8d6Q"]}`. A maximum of 50 IDs can be sent in one request. _**Note**: if the `ids` parameter is present in the query string, any IDs listed here in the body will be ignored._
     *
     */
    ids?: Array<string>;
    [key: string]: unknown | string;
  };
  query: {
    ids: string;
    type: 'artist' | 'user';
  };
};

export type UnfollowArtistsUsersResponse = unknown;

export type UnfollowArtistsUsersError = {
  error: ErrorObject;
};

export type CheckCurrentUserFollowsData = {
  query: {
    ids: string;
    type: 'artist' | 'user';
  };
};

export type CheckCurrentUserFollowsResponse = Array<boolean>;

export type CheckCurrentUserFollowsError = {
  error: ErrorObject;
};

export type CheckIfUserFollowsPlaylistData = {
  path: {
    playlist_id: string;
  };
  query?: {
    ids?: string;
  };
};

export type CheckIfUserFollowsPlaylistResponse = Array<boolean>;

export type CheckIfUserFollowsPlaylistError = {
  error: ErrorObject;
};

export type GetSeveralAudioFeaturesData = {
  query: {
    ids: string;
  };
};

export type GetSeveralAudioFeaturesResponse = {
  audio_features: Array<AudioFeaturesObject>;
};

export type GetSeveralAudioFeaturesError = {
  error: ErrorObject;
};

export type GetAudioFeaturesData = {
  path: {
    id: string;
  };
};

export type GetAudioFeaturesResponse = AudioFeaturesObject;

export type GetAudioFeaturesError = {
  error: ErrorObject;
};

export type GetAudioAnalysisData = {
  path: {
    id: string;
  };
};

export type GetAudioAnalysisResponse = AudioAnalysisObject;

export type GetAudioAnalysisError = {
  error: ErrorObject;
};

export type GetRecommendationsData = {
  query: {
    limit?: number;
    market?: string;
    max_acousticness?: number;
    max_danceability?: number;
    max_duration_ms?: number;
    max_energy?: number;
    max_instrumentalness?: number;
    max_key?: number;
    max_liveness?: number;
    max_loudness?: number;
    max_mode?: number;
    max_popularity?: number;
    max_speechiness?: number;
    max_tempo?: number;
    max_time_signature?: number;
    max_valence?: number;
    min_acousticness?: number;
    min_danceability?: number;
    min_duration_ms?: number;
    min_energy?: number;
    min_instrumentalness?: number;
    min_key?: number;
    min_liveness?: number;
    min_loudness?: number;
    min_mode?: number;
    min_popularity?: number;
    min_speechiness?: number;
    min_tempo?: number;
    min_time_signature?: number;
    min_valence?: number;
    seed_artists: string;
    seed_genres: string;
    seed_tracks: string;
    target_acousticness?: number;
    target_danceability?: number;
    target_duration_ms?: number;
    target_energy?: number;
    target_instrumentalness?: number;
    target_key?: number;
    target_liveness?: number;
    target_loudness?: number;
    target_mode?: number;
    target_popularity?: number;
    target_speechiness?: number;
    target_tempo?: number;
    target_time_signature?: number;
    target_valence?: number;
  };
};

export type GetRecommendationsResponse = RecommendationsObject;

export type GetRecommendationsError = {
  error: ErrorObject;
};

export type GetRecommendationGenresResponse = {
  genres: Array<string>;
};

export type GetRecommendationGenresError = {
  error: ErrorObject;
};

export type GetInformationAboutTheUsersCurrentPlaybackData = {
  query?: {
    additional_types?: string;
    market?: string;
  };
};

export type GetInformationAboutTheUsersCurrentPlaybackResponse = CurrentlyPlayingContextObject | void;

export type GetInformationAboutTheUsersCurrentPlaybackError = {
  error: ErrorObject;
};

export type TransferAusersPlaybackData = {
  body?: {
    /**
     * A JSON array containing the ID of the device on which playback should be started/transferred.<br/>For example:`{device_ids:["74ASZWbe4lXaubB36ztrGX"]}`<br/>_**Note**: Although an array is accepted, only a single device_id is currently supported. Supplying more than one will return `400 Bad Request`_
     *
     */
    device_ids: Array<string>;
    /**
     * **true**: ensure playback happens on new device.<br/>**false** or not provided: keep the current playback state.
     *
     */
    play?: {
      [key: string]: unknown;
    };
    [key: string]: unknown | string;
  };
};

export type TransferAusersPlaybackResponse = void;

export type TransferAusersPlaybackError = {
  error: ErrorObject;
};

export type GetAusersAvailableDevicesResponse = {
  devices: Array<DeviceObject>;
};

export type GetAusersAvailableDevicesError = {
  error: ErrorObject;
};

export type GetTheUsersCurrentlyPlayingTrackData = {
  query?: {
    additional_types?: string;
    market?: string;
  };
};

export type GetTheUsersCurrentlyPlayingTrackResponse = CurrentlyPlayingContextObject;

export type GetTheUsersCurrentlyPlayingTrackError = {
  error: ErrorObject;
};

export type StartAusersPlaybackData = {
  body?: {
    /**
     * Optional. Spotify URI of the context to play.
     * Valid contexts are albums, artists & playlists.
     * `{context_uri:"spotify:album:1Je1IMUlBXcx1Fz0WE7oPT"}`
     *
     */
    context_uri?: {
      [key: string]: unknown;
    };
    /**
     * Optional. A JSON array of the Spotify track URIs to play.
     * For example: `{"uris": ["spotify:track:4iV5W9uYEdYUVa79Axb7Rh", "spotify:track:1301WleyT98MSxVHPZCA6M"]}`
     *
     */
    uris?: Array<string>;
    /**
     * Optional. Indicates from where in the context playback should start. Only available when context_uri corresponds to an album or playlist object
     * "position" is zero based and can’t be negative. Example: `"offset": {"position": 5}`
     * "uri" is a string representing the uri of the item to start at. Example: `"offset": {"uri": "spotify:track:1301WleyT98MSxVHPZCA6M"}`
     *
     */
    offset?: {
      [key: string]: unknown;
    };
    /**
     * integer
     */
    position_ms?: {
      [key: string]: unknown;
    };
    [key: string]: unknown | string;
  };
  query?: {
    device_id?: string;
  };
};

export type StartAusersPlaybackResponse = void;

export type StartAusersPlaybackError = {
  error: ErrorObject;
};

export type PauseAusersPlaybackData = {
  query?: {
    device_id?: string;
  };
};

export type PauseAusersPlaybackResponse = void;

export type PauseAusersPlaybackError = {
  error: ErrorObject;
};

export type SkipUsersPlaybackToNextTrackData = {
  query?: {
    device_id?: string;
  };
};

export type SkipUsersPlaybackToNextTrackResponse = void;

export type SkipUsersPlaybackToNextTrackError = {
  error: ErrorObject;
};

export type SkipUsersPlaybackToPreviousTrackData = {
  query?: {
    device_id?: string;
  };
};

export type SkipUsersPlaybackToPreviousTrackResponse = void;

export type SkipUsersPlaybackToPreviousTrackError = {
  error: ErrorObject;
};

export type SeekToPositionInCurrentlyPlayingTrackData = {
  query: {
    device_id?: string;
    position_ms: number;
  };
};

export type SeekToPositionInCurrentlyPlayingTrackResponse = void;

export type SeekToPositionInCurrentlyPlayingTrackError = {
  error: ErrorObject;
};

export type SetRepeatModeOnUsersPlaybackData = {
  query: {
    device_id?: string;
    state: string;
  };
};

export type SetRepeatModeOnUsersPlaybackResponse = void;

export type SetRepeatModeOnUsersPlaybackError = {
  error: ErrorObject;
};

export type SetVolumeForUsersPlaybackData = {
  query: {
    device_id?: string;
    volume_percent: number;
  };
};

export type SetVolumeForUsersPlaybackResponse = void;

export type SetVolumeForUsersPlaybackError = {
  error: ErrorObject;
};

export type ToggleShuffleForUsersPlaybackData = {
  query: {
    device_id?: string;
    state: boolean;
  };
};

export type ToggleShuffleForUsersPlaybackResponse = void;

export type ToggleShuffleForUsersPlaybackError = {
  error: ErrorObject;
};

export type GetRecentlyPlayedData = {
  query?: {
    after?: number;
    before?: number;
    limit?: number;
  };
};

export type GetRecentlyPlayedResponse = CursorPagingPlayHistoryObject;

export type GetRecentlyPlayedError = {
  error: ErrorObject;
};

export type GetQueueResponse = QueueObject;

export type GetQueueError = {
  error: ErrorObject;
};

export type AddToQueueData = {
  query: {
    device_id?: string;
    uri: string;
  };
};

export type AddToQueueResponse = void;

export type AddToQueueError = {
  error: ErrorObject;
};

export type GetAvailableMarketsResponse = {
  markets?: Array<string>;
};

export type GetAvailableMarketsError = {
  error: ErrorObject;
};
