// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  GetAnAlbumData,
  GetAnAlbumError,
  GetAnAlbumResponse,
  GetMultipleAlbumsData,
  GetMultipleAlbumsError,
  GetMultipleAlbumsResponse,
  GetAnAlbumsTracksData,
  GetAnAlbumsTracksError,
  GetAnAlbumsTracksResponse,
  GetAnArtistData,
  GetAnArtistError,
  GetAnArtistResponse,
  GetMultipleArtistsData,
  GetMultipleArtistsError,
  GetMultipleArtistsResponse,
  GetAnArtistsAlbumsData,
  GetAnArtistsAlbumsError,
  GetAnArtistsAlbumsResponse,
  GetAnArtistsTopTracksData,
  GetAnArtistsTopTracksError,
  GetAnArtistsTopTracksResponse,
  GetAnArtistsRelatedArtistsData,
  GetAnArtistsRelatedArtistsError,
  GetAnArtistsRelatedArtistsResponse,
  GetAshowData,
  GetAshowError,
  GetAshowResponse,
  GetMultipleShowsData,
  GetMultipleShowsError,
  GetMultipleShowsResponse,
  GetAshowsEpisodesData,
  GetAshowsEpisodesError,
  GetAshowsEpisodesResponse,
  GetAnEpisodeData,
  GetAnEpisodeError,
  GetAnEpisodeResponse,
  GetMultipleEpisodesData,
  GetMultipleEpisodesError,
  GetMultipleEpisodesResponse,
  GetAnAudiobookData,
  GetAnAudiobookError,
  GetAnAudiobookResponse,
  GetMultipleAudiobooksData,
  GetMultipleAudiobooksError,
  GetMultipleAudiobooksResponse,
  GetAudiobookChaptersData,
  GetAudiobookChaptersError,
  GetAudiobookChaptersResponse,
  GetUsersSavedAudiobooksData,
  GetUsersSavedAudiobooksError,
  GetUsersSavedAudiobooksResponse,
  SaveAudiobooksUserData,
  SaveAudiobooksUserError,
  SaveAudiobooksUserResponse,
  RemoveAudiobooksUserData,
  RemoveAudiobooksUserError,
  RemoveAudiobooksUserResponse,
  CheckUsersSavedAudiobooksData,
  CheckUsersSavedAudiobooksError,
  CheckUsersSavedAudiobooksResponse,
  GetAchapterData,
  GetAchapterError,
  GetAchapterResponse,
  GetSeveralChaptersData,
  GetSeveralChaptersError,
  GetSeveralChaptersResponse,
  GetTrackData,
  GetTrackError,
  GetTrackResponse,
  GetSeveralTracksData,
  GetSeveralTracksError,
  GetSeveralTracksResponse,
  SearchData,
  SearchError,
  SearchResponse,
  GetCurrentUsersProfileError,
  GetCurrentUsersProfileResponse,
  GetPlaylistData,
  GetPlaylistError,
  GetPlaylistResponse,
  ChangePlaylistDetailsData,
  ChangePlaylistDetailsError,
  ChangePlaylistDetailsResponse,
  GetPlaylistsTracksData,
  GetPlaylistsTracksError,
  GetPlaylistsTracksResponse,
  AddTracksToPlaylistData,
  AddTracksToPlaylistError,
  AddTracksToPlaylistResponse,
  ReorderOrReplacePlaylistsTracksData,
  ReorderOrReplacePlaylistsTracksError,
  ReorderOrReplacePlaylistsTracksResponse,
  RemoveTracksPlaylistData,
  RemoveTracksPlaylistError,
  RemoveTracksPlaylistResponse,
  GetAlistOfCurrentUsersPlaylistsData,
  GetAlistOfCurrentUsersPlaylistsError,
  GetAlistOfCurrentUsersPlaylistsResponse,
  GetUsersSavedAlbumsData,
  GetUsersSavedAlbumsError,
  GetUsersSavedAlbumsResponse,
  SaveAlbumsUserData,
  SaveAlbumsUserError,
  SaveAlbumsUserResponse,
  RemoveAlbumsUserData,
  RemoveAlbumsUserError,
  RemoveAlbumsUserResponse,
  CheckUsersSavedAlbumsData,
  CheckUsersSavedAlbumsError,
  CheckUsersSavedAlbumsResponse,
  GetUsersSavedTracksData,
  GetUsersSavedTracksError,
  GetUsersSavedTracksResponse,
  SaveTracksUserData,
  SaveTracksUserError,
  SaveTracksUserResponse,
  RemoveTracksUserData,
  RemoveTracksUserError,
  RemoveTracksUserResponse,
  CheckUsersSavedTracksData,
  CheckUsersSavedTracksError,
  CheckUsersSavedTracksResponse,
  GetUsersSavedEpisodesData,
  GetUsersSavedEpisodesError,
  GetUsersSavedEpisodesResponse,
  SaveEpisodesUserData,
  SaveEpisodesUserError,
  SaveEpisodesUserResponse,
  RemoveEpisodesUserData,
  RemoveEpisodesUserError,
  RemoveEpisodesUserResponse,
  CheckUsersSavedEpisodesData,
  CheckUsersSavedEpisodesError,
  CheckUsersSavedEpisodesResponse,
  GetUsersSavedShowsData,
  GetUsersSavedShowsError,
  GetUsersSavedShowsResponse,
  SaveShowsUserData,
  SaveShowsUserError,
  SaveShowsUserResponse,
  RemoveShowsUserData,
  RemoveShowsUserError,
  RemoveShowsUserResponse,
  CheckUsersSavedShowsData,
  CheckUsersSavedShowsError,
  CheckUsersSavedShowsResponse,
  GetUsersTopArtistsAndTracksData,
  GetUsersTopArtistsAndTracksError,
  GetUsersTopArtistsAndTracksResponse,
  GetUsersProfileData,
  GetUsersProfileError,
  GetUsersProfileResponse,
  GetListUsersPlaylistsData,
  GetListUsersPlaylistsError,
  GetListUsersPlaylistsResponse,
  CreatePlaylistData,
  CreatePlaylistError,
  CreatePlaylistResponse,
  FollowPlaylistData,
  FollowPlaylistError,
  FollowPlaylistResponse,
  UnfollowPlaylistData,
  UnfollowPlaylistError,
  UnfollowPlaylistResponse,
  GetFeaturedPlaylistsData,
  GetFeaturedPlaylistsError,
  GetFeaturedPlaylistsResponse,
  GetCategoriesData,
  GetCategoriesError,
  GetCategoriesResponse,
  GetAcategoryData,
  GetAcategoryError,
  GetAcategoryResponse,
  GetAcategoriesPlaylistsData,
  GetAcategoriesPlaylistsError,
  GetAcategoriesPlaylistsResponse,
  GetPlaylistCoverData,
  GetPlaylistCoverError,
  GetPlaylistCoverResponse,
  UploadCustomPlaylistCoverData,
  UploadCustomPlaylistCoverError,
  UploadCustomPlaylistCoverResponse,
  GetNewReleasesData,
  GetNewReleasesError,
  GetNewReleasesResponse,
  GetFollowedData,
  GetFollowedError,
  GetFollowedResponse,
  FollowArtistsUsersData,
  FollowArtistsUsersError,
  FollowArtistsUsersResponse,
  UnfollowArtistsUsersData,
  UnfollowArtistsUsersError,
  UnfollowArtistsUsersResponse,
  CheckCurrentUserFollowsData,
  CheckCurrentUserFollowsError,
  CheckCurrentUserFollowsResponse,
  CheckIfUserFollowsPlaylistData,
  CheckIfUserFollowsPlaylistError,
  CheckIfUserFollowsPlaylistResponse,
  GetSeveralAudioFeaturesData,
  GetSeveralAudioFeaturesError,
  GetSeveralAudioFeaturesResponse,
  GetAudioFeaturesData,
  GetAudioFeaturesError,
  GetAudioFeaturesResponse,
  GetAudioAnalysisData,
  GetAudioAnalysisError,
  GetAudioAnalysisResponse,
  GetRecommendationsData,
  GetRecommendationsError,
  GetRecommendationsResponse,
  GetRecommendationGenresError,
  GetRecommendationGenresResponse,
  GetInformationAboutTheUsersCurrentPlaybackData,
  GetInformationAboutTheUsersCurrentPlaybackError,
  GetInformationAboutTheUsersCurrentPlaybackResponse,
  TransferAusersPlaybackData,
  TransferAusersPlaybackError,
  TransferAusersPlaybackResponse,
  GetAusersAvailableDevicesError,
  GetAusersAvailableDevicesResponse,
  GetTheUsersCurrentlyPlayingTrackData,
  GetTheUsersCurrentlyPlayingTrackError,
  GetTheUsersCurrentlyPlayingTrackResponse,
  StartAusersPlaybackData,
  StartAusersPlaybackError,
  StartAusersPlaybackResponse,
  PauseAusersPlaybackData,
  PauseAusersPlaybackError,
  PauseAusersPlaybackResponse,
  SkipUsersPlaybackToNextTrackData,
  SkipUsersPlaybackToNextTrackError,
  SkipUsersPlaybackToNextTrackResponse,
  SkipUsersPlaybackToPreviousTrackData,
  SkipUsersPlaybackToPreviousTrackError,
  SkipUsersPlaybackToPreviousTrackResponse,
  SeekToPositionInCurrentlyPlayingTrackData,
  SeekToPositionInCurrentlyPlayingTrackError,
  SeekToPositionInCurrentlyPlayingTrackResponse,
  SetRepeatModeOnUsersPlaybackData,
  SetRepeatModeOnUsersPlaybackError,
  SetRepeatModeOnUsersPlaybackResponse,
  SetVolumeForUsersPlaybackData,
  SetVolumeForUsersPlaybackError,
  SetVolumeForUsersPlaybackResponse,
  ToggleShuffleForUsersPlaybackData,
  ToggleShuffleForUsersPlaybackError,
  ToggleShuffleForUsersPlaybackResponse,
  GetRecentlyPlayedData,
  GetRecentlyPlayedError,
  GetRecentlyPlayedResponse,
  GetQueueError,
  GetQueueResponse,
  AddToQueueData,
  AddToQueueError,
  AddToQueueResponse,
  GetAvailableMarketsError,
  GetAvailableMarketsResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Get Album
 *
 * Get Spotify catalog information for a single album.
 *
 */
export const getAnAlbum = <ThrowOnError extends boolean = false>(options: Options<GetAnAlbumData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetAnAlbumResponse, GetAnAlbumError, ThrowOnError>({
    ...options,
    url: '/albums/{id}',
  });
};

/**
 * Get Several Albums
 *
 * Get Spotify catalog information for multiple albums identified by their Spotify IDs.
 *
 */
export const getMultipleAlbums = <ThrowOnError extends boolean = false>(
  options: Options<GetMultipleAlbumsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetMultipleAlbumsResponse, GetMultipleAlbumsError, ThrowOnError>({
    ...options,
    url: '/albums',
  });
};

/**
 * Get Album Tracks
 *
 * Get Spotify catalog information about an album’s tracks.
 * Optional parameters can be used to limit the number of tracks returned.
 *
 */
export const getAnAlbumsTracks = <ThrowOnError extends boolean = false>(
  options: Options<GetAnAlbumsTracksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAnAlbumsTracksResponse, GetAnAlbumsTracksError, ThrowOnError>({
    ...options,
    url: '/albums/{id}/tracks',
  });
};

/**
 * Get Artist
 *
 * Get Spotify catalog information for a single artist identified by their unique Spotify ID.
 *
 */
export const getAnArtist = <ThrowOnError extends boolean = false>(options: Options<GetAnArtistData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetAnArtistResponse, GetAnArtistError, ThrowOnError>({
    ...options,
    url: '/artists/{id}',
  });
};

/**
 * Get Several Artists
 *
 * Get Spotify catalog information for several artists based on their Spotify IDs.
 *
 */
export const getMultipleArtists = <ThrowOnError extends boolean = false>(
  options: Options<GetMultipleArtistsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetMultipleArtistsResponse, GetMultipleArtistsError, ThrowOnError>({
    ...options,
    url: '/artists',
  });
};

/**
 * Get Artist's Albums
 *
 * Get Spotify catalog information about an artist's albums.
 *
 */
export const getAnArtistsAlbums = <ThrowOnError extends boolean = false>(
  options: Options<GetAnArtistsAlbumsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAnArtistsAlbumsResponse, GetAnArtistsAlbumsError, ThrowOnError>({
    ...options,
    url: '/artists/{id}/albums',
  });
};

/**
 * Get Artist's Top Tracks
 *
 * Get Spotify catalog information about an artist's top tracks by country.
 *
 */
export const getAnArtistsTopTracks = <ThrowOnError extends boolean = false>(
  options: Options<GetAnArtistsTopTracksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAnArtistsTopTracksResponse, GetAnArtistsTopTracksError, ThrowOnError>({
    ...options,
    url: '/artists/{id}/top-tracks',
  });
};

/**
 * Get Artist's Related Artists
 *
 * Get Spotify catalog information about artists similar to a given artist. Similarity is based on analysis of the Spotify community's listening history.
 *
 */
export const getAnArtistsRelatedArtists = <ThrowOnError extends boolean = false>(
  options: Options<GetAnArtistsRelatedArtistsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetAnArtistsRelatedArtistsResponse,
    GetAnArtistsRelatedArtistsError,
    ThrowOnError
  >({
    ...options,
    url: '/artists/{id}/related-artists',
  });
};

/**
 * Get Show
 *
 * Get Spotify catalog information for a single show identified by its
 * unique Spotify ID.
 *
 */
export const getAShow = <ThrowOnError extends boolean = false>(options: Options<GetAshowData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetAshowResponse, GetAshowError, ThrowOnError>({
    ...options,
    url: '/shows/{id}',
  });
};

/**
 * Get Several Shows
 *
 * Get Spotify catalog information for several shows based on their Spotify IDs.
 *
 */
export const getMultipleShows = <ThrowOnError extends boolean = false>(
  options: Options<GetMultipleShowsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetMultipleShowsResponse, GetMultipleShowsError, ThrowOnError>({
    ...options,
    url: '/shows',
  });
};

/**
 * Get Show Episodes
 *
 * Get Spotify catalog information about an show’s episodes. Optional parameters can be used to limit the number of episodes returned.
 *
 */
export const getAShowsEpisodes = <ThrowOnError extends boolean = false>(
  options: Options<GetAshowsEpisodesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAshowsEpisodesResponse, GetAshowsEpisodesError, ThrowOnError>({
    ...options,
    url: '/shows/{id}/episodes',
  });
};

/**
 * Get Episode
 *
 * Get Spotify catalog information for a single episode identified by its
 * unique Spotify ID.
 *
 */
export const getAnEpisode = <ThrowOnError extends boolean = false>(
  options: Options<GetAnEpisodeData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAnEpisodeResponse, GetAnEpisodeError, ThrowOnError>({
    ...options,
    url: '/episodes/{id}',
  });
};

/**
 * Get Several Episodes
 *
 * Get Spotify catalog information for several episodes based on their Spotify IDs.
 *
 */
export const getMultipleEpisodes = <ThrowOnError extends boolean = false>(
  options: Options<GetMultipleEpisodesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetMultipleEpisodesResponse, GetMultipleEpisodesError, ThrowOnError>({
    ...options,
    url: '/episodes',
  });
};

/**
 * Get an Audiobook
 *
 * Get Spotify catalog information for a single audiobook. Audiobooks are only available within the US, UK, Canada, Ireland, New Zealand and Australia markets.
 *
 */
export const getAnAudiobook = <ThrowOnError extends boolean = false>(
  options: Options<GetAnAudiobookData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAnAudiobookResponse, GetAnAudiobookError, ThrowOnError>({
    ...options,
    url: '/audiobooks/{id}',
  });
};

/**
 * Get Several Audiobooks
 *
 * Get Spotify catalog information for several audiobooks identified by their Spotify IDs. Audiobooks are only available within the US, UK, Canada, Ireland, New Zealand and Australia markets.
 *
 */
export const getMultipleAudiobooks = <ThrowOnError extends boolean = false>(
  options: Options<GetMultipleAudiobooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetMultipleAudiobooksResponse, GetMultipleAudiobooksError, ThrowOnError>({
    ...options,
    url: '/audiobooks',
  });
};

/**
 * Get Audiobook Chapters
 *
 * Get Spotify catalog information about an audiobook's chapters. Audiobooks are only available within the US, UK, Canada, Ireland, New Zealand and Australia markets.
 *
 */
export const getAudiobookChapters = <ThrowOnError extends boolean = false>(
  options: Options<GetAudiobookChaptersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAudiobookChaptersResponse, GetAudiobookChaptersError, ThrowOnError>({
    ...options,
    url: '/audiobooks/{id}/chapters',
  });
};

/**
 * Get User's Saved Audiobooks
 *
 * Get a list of the audiobooks saved in the current Spotify user's 'Your Music' library.
 *
 */
export const getUsersSavedAudiobooks = <ThrowOnError extends boolean = false>(
  options?: Options<GetUsersSavedAudiobooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUsersSavedAudiobooksResponse, GetUsersSavedAudiobooksError, ThrowOnError>({
    ...options,
    url: '/me/audiobooks',
  });
};

/**
 * Save Audiobooks for Current User
 *
 * Save one or more audiobooks to the current Spotify user's library.
 *
 */
export const saveAudiobooksUser = <ThrowOnError extends boolean = false>(
  options: Options<SaveAudiobooksUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<SaveAudiobooksUserResponse, SaveAudiobooksUserError, ThrowOnError>({
    ...options,
    url: '/me/audiobooks',
  });
};

/**
 * Remove User's Saved Audiobooks
 *
 * Remove one or more audiobooks from the Spotify user's library.
 *
 */
export const removeAudiobooksUser = <ThrowOnError extends boolean = false>(
  options: Options<RemoveAudiobooksUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RemoveAudiobooksUserResponse, RemoveAudiobooksUserError, ThrowOnError>({
    ...options,
    url: '/me/audiobooks',
  });
};

/**
 * Check User's Saved Audiobooks
 *
 * Check if one or more audiobooks are already saved in the current Spotify user's library.
 *
 */
export const checkUsersSavedAudiobooks = <ThrowOnError extends boolean = false>(
  options: Options<CheckUsersSavedAudiobooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    CheckUsersSavedAudiobooksResponse,
    CheckUsersSavedAudiobooksError,
    ThrowOnError
  >({
    ...options,
    url: '/me/audiobooks/contains',
  });
};

/**
 * Get a Chapter
 *
 * Get Spotify catalog information for a single audiobook chapter. Chapters are only available within the US, UK, Canada, Ireland, New Zealand and Australia markets.
 *
 */
export const getAChapter = <ThrowOnError extends boolean = false>(options: Options<GetAchapterData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetAchapterResponse, GetAchapterError, ThrowOnError>({
    ...options,
    url: '/chapters/{id}',
  });
};

/**
 * Get Several Chapters
 *
 * Get Spotify catalog information for several audiobook chapters identified by their Spotify IDs. Chapters are only available within the US, UK, Canada, Ireland, New Zealand and Australia markets.
 *
 */
export const getSeveralChapters = <ThrowOnError extends boolean = false>(
  options: Options<GetSeveralChaptersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetSeveralChaptersResponse, GetSeveralChaptersError, ThrowOnError>({
    ...options,
    url: '/chapters',
  });
};

/**
 * Get Track
 *
 * Get Spotify catalog information for a single track identified by its
 * unique Spotify ID.
 *
 */
export const getTrack = <ThrowOnError extends boolean = false>(options: Options<GetTrackData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetTrackResponse, GetTrackError, ThrowOnError>({
    ...options,
    url: '/tracks/{id}',
  });
};

/**
 * Get Several Tracks
 *
 * Get Spotify catalog information for multiple tracks based on their Spotify IDs.
 *
 */
export const getSeveralTracks = <ThrowOnError extends boolean = false>(
  options: Options<GetSeveralTracksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetSeveralTracksResponse, GetSeveralTracksError, ThrowOnError>({
    ...options,
    url: '/tracks',
  });
};

/**
 * Search for Item
 *
 * Get Spotify catalog information about albums, artists, playlists, tracks, shows, episodes or audiobooks
 * that match a keyword string. Audiobooks are only available within the US, UK, Canada, Ireland, New Zealand and Australia markets.
 *
 */
export const search = <ThrowOnError extends boolean = false>(options: Options<SearchData, ThrowOnError>) => {
  return (options?.client ?? client).get<SearchResponse, SearchError, ThrowOnError>({
    ...options,
    url: '/search',
  });
};

/**
 * Get Current User's Profile
 *
 * Get detailed profile information about the current user (including the
 * current user's username).
 *
 */
export const getCurrentUsersProfile = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCurrentUsersProfileResponse, GetCurrentUsersProfileError, ThrowOnError>({
    ...options,
    url: '/me',
  });
};

/**
 * Get Playlist
 *
 * Get a playlist owned by a Spotify user.
 *
 */
export const getPlaylist = <ThrowOnError extends boolean = false>(options: Options<GetPlaylistData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetPlaylistResponse, GetPlaylistError, ThrowOnError>({
    ...options,
    url: '/playlists/{playlist_id}',
  });
};

/**
 * Change Playlist Details
 *
 * Change a playlist's name and public/private state. (The user must, of
 * course, own the playlist.)
 *
 */
export const changePlaylistDetails = <ThrowOnError extends boolean = false>(
  options: Options<ChangePlaylistDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<ChangePlaylistDetailsResponse, ChangePlaylistDetailsError, ThrowOnError>({
    ...options,
    url: '/playlists/{playlist_id}',
  });
};

/**
 * Get Playlist Items
 *
 * Get full details of the items of a playlist owned by a Spotify user.
 *
 */
export const getPlaylistsTracks = <ThrowOnError extends boolean = false>(
  options: Options<GetPlaylistsTracksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPlaylistsTracksResponse, GetPlaylistsTracksError, ThrowOnError>({
    ...options,
    url: '/playlists/{playlist_id}/tracks',
  });
};

/**
 * Add Items to Playlist
 *
 * Add one or more items to a user's playlist.
 *
 */
export const addTracksToPlaylist = <ThrowOnError extends boolean = false>(
  options: Options<AddTracksToPlaylistData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddTracksToPlaylistResponse, AddTracksToPlaylistError, ThrowOnError>({
    ...options,
    url: '/playlists/{playlist_id}/tracks',
  });
};

/**
 * Update Playlist Items
 *
 * Either reorder or replace items in a playlist depending on the request's parameters.
 * To reorder items, include `range_start`, `insert_before`, `range_length` and `snapshot_id` in the request's body.
 * To replace items, include `uris` as either a query parameter or in the request's body.
 * Replacing items in a playlist will overwrite its existing items. This operation can be used for replacing or clearing items in a playlist.
 * <br/>
 * **Note**: Replace and reorder are mutually exclusive operations which share the same endpoint, but have different parameters.
 * These operations can't be applied together in a single request.
 *
 */
export const reorderOrReplacePlaylistsTracks = <ThrowOnError extends boolean = false>(
  options: Options<ReorderOrReplacePlaylistsTracksData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    ReorderOrReplacePlaylistsTracksResponse,
    ReorderOrReplacePlaylistsTracksError,
    ThrowOnError
  >({
    ...options,
    url: '/playlists/{playlist_id}/tracks',
  });
};

/**
 * Remove Playlist Items
 *
 * Remove one or more items from a user's playlist.
 *
 */
export const removeTracksPlaylist = <ThrowOnError extends boolean = false>(
  options: Options<RemoveTracksPlaylistData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RemoveTracksPlaylistResponse, RemoveTracksPlaylistError, ThrowOnError>({
    ...options,
    url: '/playlists/{playlist_id}/tracks',
  });
};

/**
 * Get Current User's Playlists
 *
 * Get a list of the playlists owned or followed by the current Spotify
 * user.
 *
 */
export const getAListOfCurrentUsersPlaylists = <ThrowOnError extends boolean = false>(
  options?: Options<GetAlistOfCurrentUsersPlaylistsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetAlistOfCurrentUsersPlaylistsResponse,
    GetAlistOfCurrentUsersPlaylistsError,
    ThrowOnError
  >({
    ...options,
    url: '/me/playlists',
  });
};

/**
 * Get User's Saved Albums
 *
 * Get a list of the albums saved in the current Spotify user's 'Your Music' library.
 *
 */
export const getUsersSavedAlbums = <ThrowOnError extends boolean = false>(
  options?: Options<GetUsersSavedAlbumsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUsersSavedAlbumsResponse, GetUsersSavedAlbumsError, ThrowOnError>({
    ...options,
    url: '/me/albums',
  });
};

/**
 * Save Albums for Current User
 *
 * Save one or more albums to the current user's 'Your Music' library.
 *
 */
export const saveAlbumsUser = <ThrowOnError extends boolean = false>(
  options: Options<SaveAlbumsUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<SaveAlbumsUserResponse, SaveAlbumsUserError, ThrowOnError>({
    ...options,
    url: '/me/albums',
  });
};

/**
 * Remove Users' Saved Albums
 *
 * Remove one or more albums from the current user's 'Your Music' library.
 *
 */
export const removeAlbumsUser = <ThrowOnError extends boolean = false>(
  options: Options<RemoveAlbumsUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RemoveAlbumsUserResponse, RemoveAlbumsUserError, ThrowOnError>({
    ...options,
    url: '/me/albums',
  });
};

/**
 * Check User's Saved Albums
 *
 * Check if one or more albums is already saved in the current Spotify user's 'Your Music' library.
 *
 */
export const checkUsersSavedAlbums = <ThrowOnError extends boolean = false>(
  options: Options<CheckUsersSavedAlbumsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CheckUsersSavedAlbumsResponse, CheckUsersSavedAlbumsError, ThrowOnError>({
    ...options,
    url: '/me/albums/contains',
  });
};

/**
 * Get User's Saved Tracks
 *
 * Get a list of the songs saved in the current Spotify user's 'Your Music' library.
 *
 */
export const getUsersSavedTracks = <ThrowOnError extends boolean = false>(
  options?: Options<GetUsersSavedTracksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUsersSavedTracksResponse, GetUsersSavedTracksError, ThrowOnError>({
    ...options,
    url: '/me/tracks',
  });
};

/**
 * Save Tracks for Current User
 *
 * Save one or more tracks to the current user's 'Your Music' library.
 *
 */
export const saveTracksUser = <ThrowOnError extends boolean = false>(
  options: Options<SaveTracksUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<SaveTracksUserResponse, SaveTracksUserError, ThrowOnError>({
    ...options,
    url: '/me/tracks',
  });
};

/**
 * Remove User's Saved Tracks
 *
 * Remove one or more tracks from the current user's 'Your Music' library.
 *
 */
export const removeTracksUser = <ThrowOnError extends boolean = false>(
  options: Options<RemoveTracksUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RemoveTracksUserResponse, RemoveTracksUserError, ThrowOnError>({
    ...options,
    url: '/me/tracks',
  });
};

/**
 * Check User's Saved Tracks
 *
 * Check if one or more tracks is already saved in the current Spotify user's 'Your Music' library.
 *
 */
export const checkUsersSavedTracks = <ThrowOnError extends boolean = false>(
  options: Options<CheckUsersSavedTracksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CheckUsersSavedTracksResponse, CheckUsersSavedTracksError, ThrowOnError>({
    ...options,
    url: '/me/tracks/contains',
  });
};

/**
 * Get User's Saved Episodes
 *
 * Get a list of the episodes saved in the current Spotify user's library.<br/>
 * This API endpoint is in __beta__ and could change without warning. Please share any feedback that you have, or issues that you discover, in our [developer community forum](https://community.spotify.com/t5/Spotify-for-Developers/bd-p/Spotify_Developer).
 *
 */
export const getUsersSavedEpisodes = <ThrowOnError extends boolean = false>(
  options?: Options<GetUsersSavedEpisodesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUsersSavedEpisodesResponse, GetUsersSavedEpisodesError, ThrowOnError>({
    ...options,
    url: '/me/episodes',
  });
};

/**
 * Save Episodes for Current User
 *
 * Save one or more episodes to the current user's library.<br/>
 * This API endpoint is in __beta__ and could change without warning. Please share any feedback that you have, or issues that you discover, in our [developer community forum](https://community.spotify.com/t5/Spotify-for-Developers/bd-p/Spotify_Developer).
 *
 */
export const saveEpisodesUser = <ThrowOnError extends boolean = false>(
  options: Options<SaveEpisodesUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<SaveEpisodesUserResponse, SaveEpisodesUserError, ThrowOnError>({
    ...options,
    url: '/me/episodes',
  });
};

/**
 * Remove User's Saved Episodes
 *
 * Remove one or more episodes from the current user's library.<br/>
 * This API endpoint is in __beta__ and could change without warning. Please share any feedback that you have, or issues that you discover, in our [developer community forum](https://community.spotify.com/t5/Spotify-for-Developers/bd-p/Spotify_Developer).
 *
 */
export const removeEpisodesUser = <ThrowOnError extends boolean = false>(
  options: Options<RemoveEpisodesUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RemoveEpisodesUserResponse, RemoveEpisodesUserError, ThrowOnError>({
    ...options,
    url: '/me/episodes',
  });
};

/**
 * Check User's Saved Episodes
 *
 * Check if one or more episodes is already saved in the current Spotify user's 'Your Episodes' library.<br/>
 * This API endpoint is in __beta__ and could change without warning. Please share any feedback that you have, or issues that you discover, in our [developer community forum](https://community.spotify.com/t5/Spotify-for-Developers/bd-p/Spotify_Developer)..
 *
 */
export const checkUsersSavedEpisodes = <ThrowOnError extends boolean = false>(
  options: Options<CheckUsersSavedEpisodesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CheckUsersSavedEpisodesResponse, CheckUsersSavedEpisodesError, ThrowOnError>({
    ...options,
    url: '/me/episodes/contains',
  });
};

/**
 * Get User's Saved Shows
 *
 * Get a list of shows saved in the current Spotify user's library. Optional parameters can be used to limit the number of shows returned.
 *
 */
export const getUsersSavedShows = <ThrowOnError extends boolean = false>(
  options?: Options<GetUsersSavedShowsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUsersSavedShowsResponse, GetUsersSavedShowsError, ThrowOnError>({
    ...options,
    url: '/me/shows',
  });
};

/**
 * Save Shows for Current User
 *
 * Save one or more shows to current Spotify user's library.
 *
 */
export const saveShowsUser = <ThrowOnError extends boolean = false>(
  options: Options<SaveShowsUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<SaveShowsUserResponse, SaveShowsUserError, ThrowOnError>({
    ...options,
    url: '/me/shows',
  });
};

/**
 * Remove User's Saved Shows
 *
 * Delete one or more shows from current Spotify user's library.
 *
 */
export const removeShowsUser = <ThrowOnError extends boolean = false>(
  options: Options<RemoveShowsUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RemoveShowsUserResponse, RemoveShowsUserError, ThrowOnError>({
    ...options,
    url: '/me/shows',
  });
};

/**
 * Check User's Saved Shows
 *
 * Check if one or more shows is already saved in the current Spotify user's library.
 *
 */
export const checkUsersSavedShows = <ThrowOnError extends boolean = false>(
  options: Options<CheckUsersSavedShowsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CheckUsersSavedShowsResponse, CheckUsersSavedShowsError, ThrowOnError>({
    ...options,
    url: '/me/shows/contains',
  });
};

/**
 * Get User's Top Items
 *
 * Get the current user's top artists or tracks based on calculated affinity.
 *
 */
export const getUsersTopArtistsAndTracks = <ThrowOnError extends boolean = false>(
  options: Options<GetUsersTopArtistsAndTracksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetUsersTopArtistsAndTracksResponse,
    GetUsersTopArtistsAndTracksError,
    ThrowOnError
  >({
    ...options,
    url: '/me/top/{type}',
  });
};

/**
 * Get User's Profile
 *
 * Get public profile information about a Spotify user.
 *
 */
export const getUsersProfile = <ThrowOnError extends boolean = false>(
  options: Options<GetUsersProfileData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUsersProfileResponse, GetUsersProfileError, ThrowOnError>({
    ...options,
    url: '/users/{user_id}',
  });
};

/**
 * Get User's Playlists
 *
 * Get a list of the playlists owned or followed by a Spotify user.
 *
 */
export const getListUsersPlaylists = <ThrowOnError extends boolean = false>(
  options: Options<GetListUsersPlaylistsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListUsersPlaylistsResponse, GetListUsersPlaylistsError, ThrowOnError>({
    ...options,
    url: '/users/{user_id}/playlists',
  });
};

/**
 * Create Playlist
 *
 * Create a playlist for a Spotify user. (The playlist will be empty until
 * you [add tracks](/documentation/web-api/reference/add-tracks-to-playlist).)
 * Each user is generally limited to a maximum of 11000 playlists.
 *
 */
export const createPlaylist = <ThrowOnError extends boolean = false>(
  options: Options<CreatePlaylistData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreatePlaylistResponse, CreatePlaylistError, ThrowOnError>({
    ...options,
    url: '/users/{user_id}/playlists',
  });
};

/**
 * Follow Playlist
 *
 * Add the current user as a follower of a playlist.
 *
 */
export const followPlaylist = <ThrowOnError extends boolean = false>(
  options: Options<FollowPlaylistData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<FollowPlaylistResponse, FollowPlaylistError, ThrowOnError>({
    ...options,
    url: '/playlists/{playlist_id}/followers',
  });
};

/**
 * Unfollow Playlist
 *
 * Remove the current user as a follower of a playlist.
 *
 */
export const unfollowPlaylist = <ThrowOnError extends boolean = false>(
  options: Options<UnfollowPlaylistData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UnfollowPlaylistResponse, UnfollowPlaylistError, ThrowOnError>({
    ...options,
    url: '/playlists/{playlist_id}/followers',
  });
};

/**
 * Get Featured Playlists
 *
 * Get a list of Spotify featured playlists (shown, for example, on a Spotify player's 'Browse' tab).
 *
 */
export const getFeaturedPlaylists = <ThrowOnError extends boolean = false>(
  options?: Options<GetFeaturedPlaylistsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetFeaturedPlaylistsResponse, GetFeaturedPlaylistsError, ThrowOnError>({
    ...options,
    url: '/browse/featured-playlists',
  });
};

/**
 * Get Several Browse Categories
 *
 * Get a list of categories used to tag items in Spotify (on, for example, the Spotify player’s “Browse” tab).
 *
 */
export const getCategories = <ThrowOnError extends boolean = false>(
  options?: Options<GetCategoriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCategoriesResponse, GetCategoriesError, ThrowOnError>({
    ...options,
    url: '/browse/categories',
  });
};

/**
 * Get Single Browse Category
 *
 * Get a single category used to tag items in Spotify (on, for example, the Spotify player’s “Browse” tab).
 *
 */
export const getACategory = <ThrowOnError extends boolean = false>(
  options: Options<GetAcategoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAcategoryResponse, GetAcategoryError, ThrowOnError>({
    ...options,
    url: '/browse/categories/{category_id}',
  });
};

/**
 * Get Category's Playlists
 *
 * Get a list of Spotify playlists tagged with a particular category.
 *
 */
export const getACategoriesPlaylists = <ThrowOnError extends boolean = false>(
  options: Options<GetAcategoriesPlaylistsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAcategoriesPlaylistsResponse, GetAcategoriesPlaylistsError, ThrowOnError>({
    ...options,
    url: '/browse/categories/{category_id}/playlists',
  });
};

/**
 * Get Playlist Cover Image
 *
 * Get the current image associated with a specific playlist.
 *
 */
export const getPlaylistCover = <ThrowOnError extends boolean = false>(
  options: Options<GetPlaylistCoverData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPlaylistCoverResponse, GetPlaylistCoverError, ThrowOnError>({
    ...options,
    url: '/playlists/{playlist_id}/images',
  });
};

/**
 * Add Custom Playlist Cover Image
 *
 * Replace the image used to represent a specific playlist.
 *
 */
export const uploadCustomPlaylistCover = <ThrowOnError extends boolean = false>(
  options: Options<UploadCustomPlaylistCoverData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    UploadCustomPlaylistCoverResponse,
    UploadCustomPlaylistCoverError,
    ThrowOnError
  >({
    ...options,
    url: '/playlists/{playlist_id}/images',
  });
};

/**
 * Get New Releases
 *
 * Get a list of new album releases featured in Spotify (shown, for example, on a Spotify player’s “Browse” tab).
 *
 */
export const getNewReleases = <ThrowOnError extends boolean = false>(
  options?: Options<GetNewReleasesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetNewReleasesResponse, GetNewReleasesError, ThrowOnError>({
    ...options,
    url: '/browse/new-releases',
  });
};

/**
 * Get Followed Artists
 *
 * Get the current user's followed artists.
 *
 */
export const getFollowed = <ThrowOnError extends boolean = false>(options: Options<GetFollowedData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetFollowedResponse, GetFollowedError, ThrowOnError>({
    ...options,
    url: '/me/following',
  });
};

/**
 * Follow Artists or Users
 *
 * Add the current user as a follower of one or more artists or other Spotify users.
 *
 */
export const followArtistsUsers = <ThrowOnError extends boolean = false>(
  options: Options<FollowArtistsUsersData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<FollowArtistsUsersResponse, FollowArtistsUsersError, ThrowOnError>({
    ...options,
    url: '/me/following',
  });
};

/**
 * Unfollow Artists or Users
 *
 * Remove the current user as a follower of one or more artists or other Spotify users.
 *
 */
export const unfollowArtistsUsers = <ThrowOnError extends boolean = false>(
  options: Options<UnfollowArtistsUsersData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UnfollowArtistsUsersResponse, UnfollowArtistsUsersError, ThrowOnError>({
    ...options,
    url: '/me/following',
  });
};

/**
 * Check If User Follows Artists or Users
 *
 * Check to see if the current user is following one or more artists or other Spotify users.
 *
 */
export const checkCurrentUserFollows = <ThrowOnError extends boolean = false>(
  options: Options<CheckCurrentUserFollowsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CheckCurrentUserFollowsResponse, CheckCurrentUserFollowsError, ThrowOnError>({
    ...options,
    url: '/me/following/contains',
  });
};

/**
 * Check if Current User Follows Playlist
 *
 * Check to see if the current user is following a specified playlist.
 *
 */
export const checkIfUserFollowsPlaylist = <ThrowOnError extends boolean = false>(
  options: Options<CheckIfUserFollowsPlaylistData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    CheckIfUserFollowsPlaylistResponse,
    CheckIfUserFollowsPlaylistError,
    ThrowOnError
  >({
    ...options,
    url: '/playlists/{playlist_id}/followers/contains',
  });
};

/**
 * Get Several Tracks' Audio Features
 *
 * Get audio features for multiple tracks based on their Spotify IDs.
 *
 */
export const getSeveralAudioFeatures = <ThrowOnError extends boolean = false>(
  options: Options<GetSeveralAudioFeaturesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetSeveralAudioFeaturesResponse, GetSeveralAudioFeaturesError, ThrowOnError>({
    ...options,
    url: '/audio-features',
  });
};

/**
 * Get Track's Audio Features
 *
 * Get audio feature information for a single track identified by its unique
 * Spotify ID.
 *
 */
export const getAudioFeatures = <ThrowOnError extends boolean = false>(
  options: Options<GetAudioFeaturesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAudioFeaturesResponse, GetAudioFeaturesError, ThrowOnError>({
    ...options,
    url: '/audio-features/{id}',
  });
};

/**
 * Get Track's Audio Analysis
 *
 * Get a low-level audio analysis for a track in the Spotify catalog. The audio analysis describes the track’s structure and musical content, including rhythm, pitch, and timbre.
 *
 */
export const getAudioAnalysis = <ThrowOnError extends boolean = false>(
  options: Options<GetAudioAnalysisData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAudioAnalysisResponse, GetAudioAnalysisError, ThrowOnError>({
    ...options,
    url: '/audio-analysis/{id}',
  });
};

/**
 * Get Recommendations
 *
 * Recommendations are generated based on the available information for a given seed entity and matched against similar artists and tracks. If there is sufficient information about the provided seeds, a list of tracks will be returned together with pool size details.
 *
 * For artists and tracks that are very new or obscure there might not be enough data to generate a list of tracks.
 *
 */
export const getRecommendations = <ThrowOnError extends boolean = false>(
  options: Options<GetRecommendationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetRecommendationsResponse, GetRecommendationsError, ThrowOnError>({
    ...options,
    url: '/recommendations',
  });
};

/**
 * Get Available Genre Seeds
 *
 * Retrieve a list of available genres seed parameter values for [recommendations](/documentation/web-api/reference/get-recommendations).
 *
 */
export const getRecommendationGenres = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetRecommendationGenresResponse, GetRecommendationGenresError, ThrowOnError>({
    ...options,
    url: '/recommendations/available-genre-seeds',
  });
};

/**
 * Get Playback State
 *
 * Get information about the user’s current playback state, including track or episode, progress, and active device.
 *
 */
export const getInformationAboutTheUsersCurrentPlayback = <ThrowOnError extends boolean = false>(
  options?: Options<GetInformationAboutTheUsersCurrentPlaybackData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetInformationAboutTheUsersCurrentPlaybackResponse,
    GetInformationAboutTheUsersCurrentPlaybackError,
    ThrowOnError
  >({
    ...options,
    url: '/me/player',
  });
};

/**
 * Transfer Playback
 *
 * Transfer playback to a new device and optionally begin playback. This API only works for users who have Spotify Premium. The order of execution is not guaranteed when you use this API with other Player API endpoints.
 *
 */
export const transferAUsersPlayback = <ThrowOnError extends boolean = false>(
  options?: Options<TransferAusersPlaybackData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<TransferAusersPlaybackResponse, TransferAusersPlaybackError, ThrowOnError>({
    ...options,
    url: '/me/player',
  });
};

/**
 * Get Available Devices
 *
 * Get information about a user’s available Spotify Connect devices. Some device models are not supported and will not be listed in the API response.
 *
 */
export const getAUsersAvailableDevices = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetAusersAvailableDevicesResponse,
    GetAusersAvailableDevicesError,
    ThrowOnError
  >({
    ...options,
    url: '/me/player/devices',
  });
};

/**
 * Get Currently Playing Track
 *
 * Get the object currently being played on the user's Spotify account.
 *
 */
export const getTheUsersCurrentlyPlayingTrack = <ThrowOnError extends boolean = false>(
  options?: Options<GetTheUsersCurrentlyPlayingTrackData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetTheUsersCurrentlyPlayingTrackResponse,
    GetTheUsersCurrentlyPlayingTrackError,
    ThrowOnError
  >({
    ...options,
    url: '/me/player/currently-playing',
  });
};

/**
 * Start/Resume Playback
 *
 * Start a new context or resume current playback on the user's active device. This API only works for users who have Spotify Premium. The order of execution is not guaranteed when you use this API with other Player API endpoints.
 *
 */
export const startAUsersPlayback = <ThrowOnError extends boolean = false>(
  options?: Options<StartAusersPlaybackData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<StartAusersPlaybackResponse, StartAusersPlaybackError, ThrowOnError>({
    ...options,
    url: '/me/player/play',
  });
};

/**
 * Pause Playback
 *
 * Pause playback on the user's account. This API only works for users who have Spotify Premium. The order of execution is not guaranteed when you use this API with other Player API endpoints.
 *
 */
export const pauseAUsersPlayback = <ThrowOnError extends boolean = false>(
  options?: Options<PauseAusersPlaybackData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PauseAusersPlaybackResponse, PauseAusersPlaybackError, ThrowOnError>({
    ...options,
    url: '/me/player/pause',
  });
};

/**
 * Skip To Next
 *
 * Skips to next track in the user’s queue. This API only works for users who have Spotify Premium. The order of execution is not guaranteed when you use this API with other Player API endpoints.
 *
 */
export const skipUsersPlaybackToNextTrack = <ThrowOnError extends boolean = false>(
  options?: Options<SkipUsersPlaybackToNextTrackData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SkipUsersPlaybackToNextTrackResponse,
    SkipUsersPlaybackToNextTrackError,
    ThrowOnError
  >({
    ...options,
    url: '/me/player/next',
  });
};

/**
 * Skip To Previous
 *
 * Skips to previous track in the user’s queue. This API only works for users who have Spotify Premium. The order of execution is not guaranteed when you use this API with other Player API endpoints.
 *
 */
export const skipUsersPlaybackToPreviousTrack = <ThrowOnError extends boolean = false>(
  options?: Options<SkipUsersPlaybackToPreviousTrackData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SkipUsersPlaybackToPreviousTrackResponse,
    SkipUsersPlaybackToPreviousTrackError,
    ThrowOnError
  >({
    ...options,
    url: '/me/player/previous',
  });
};

/**
 * Seek To Position
 *
 * Seeks to the given position in the user’s currently playing track. This API only works for users who have Spotify Premium. The order of execution is not guaranteed when you use this API with other Player API endpoints.
 *
 */
export const seekToPositionInCurrentlyPlayingTrack = <ThrowOnError extends boolean = false>(
  options: Options<SeekToPositionInCurrentlyPlayingTrackData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    SeekToPositionInCurrentlyPlayingTrackResponse,
    SeekToPositionInCurrentlyPlayingTrackError,
    ThrowOnError
  >({
    ...options,
    url: '/me/player/seek',
  });
};

/**
 * Set Repeat Mode
 *
 * Set the repeat mode for the user's playback. This API only works for users who have Spotify Premium. The order of execution is not guaranteed when you use this API with other Player API endpoints.
 *
 */
export const setRepeatModeOnUsersPlayback = <ThrowOnError extends boolean = false>(
  options: Options<SetRepeatModeOnUsersPlaybackData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    SetRepeatModeOnUsersPlaybackResponse,
    SetRepeatModeOnUsersPlaybackError,
    ThrowOnError
  >({
    ...options,
    url: '/me/player/repeat',
  });
};

/**
 * Set Playback Volume
 *
 * Set the volume for the user’s current playback device. This API only works for users who have Spotify Premium. The order of execution is not guaranteed when you use this API with other Player API endpoints.
 *
 */
export const setVolumeForUsersPlayback = <ThrowOnError extends boolean = false>(
  options: Options<SetVolumeForUsersPlaybackData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    SetVolumeForUsersPlaybackResponse,
    SetVolumeForUsersPlaybackError,
    ThrowOnError
  >({
    ...options,
    url: '/me/player/volume',
  });
};

/**
 * Toggle Playback Shuffle
 *
 * Toggle shuffle on or off for user’s playback. This API only works for users who have Spotify Premium. The order of execution is not guaranteed when you use this API with other Player API endpoints.
 *
 */
export const toggleShuffleForUsersPlayback = <ThrowOnError extends boolean = false>(
  options: Options<ToggleShuffleForUsersPlaybackData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    ToggleShuffleForUsersPlaybackResponse,
    ToggleShuffleForUsersPlaybackError,
    ThrowOnError
  >({
    ...options,
    url: '/me/player/shuffle',
  });
};

/**
 * Get Recently Played Tracks
 *
 * Get tracks from the current user's recently played tracks.
 * _**Note**: Currently doesn't support podcast episodes._
 *
 */
export const getRecentlyPlayed = <ThrowOnError extends boolean = false>(
  options?: Options<GetRecentlyPlayedData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetRecentlyPlayedResponse, GetRecentlyPlayedError, ThrowOnError>({
    ...options,
    url: '/me/player/recently-played',
  });
};

/**
 * Get the User's Queue
 *
 * Get the list of objects that make up the user's queue.
 *
 */
export const getQueue = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetQueueResponse, GetQueueError, ThrowOnError>({
    ...options,
    url: '/me/player/queue',
  });
};

/**
 * Add Item to Playback Queue
 *
 * Add an item to the end of the user's current playback queue. This API only works for users who have Spotify Premium. The order of execution is not guaranteed when you use this API with other Player API endpoints.
 *
 */
export const addToQueue = <ThrowOnError extends boolean = false>(options: Options<AddToQueueData, ThrowOnError>) => {
  return (options?.client ?? client).post<AddToQueueResponse, AddToQueueError, ThrowOnError>({
    ...options,
    url: '/me/player/queue',
  });
};

/**
 * Get Available Markets
 *
 * Get the list of markets where Spotify is available.
 *
 */
export const getAvailableMarkets = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetAvailableMarketsResponse, GetAvailableMarketsError, ThrowOnError>({
    ...options,
    url: '/markets',
  });
};
