// This file is auto-generated by @hey-api/openapi-ts

export const LinkedTrackObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'LinkedTrackObject',
  properties: {
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `Known external URLs for this track.
`,
    },
    href: {
      type: 'string',
      description: `A link to the Web API endpoint providing full details of the track.
`,
    },
    id: {
      type: 'string',
      description: `The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the track.
`,
    },
    type: {
      type: 'string',
      description: `The object type: "track".
`,
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the track.
`,
    },
  },
} as const;

export const TrackRestrictionObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'TrackRestrictionObject',
  properties: {
    reason: {
      type: 'string',
      description: `The reason for the restriction. Supported values:
- \`market\` - The content item is not available in the given market.
- \`product\` - The content item is not available for the user's subscription type.
- \`explicit\` - The content item is explicit and the user's account is set to not play explicit content.

Additional reasons may be added in the future.
**Note**: If you use this field, make sure that your application safely handles unknown values.
`,
    },
  },
} as const;

export const AlbumRestrictionObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'AlbumRestrictionObject',
  properties: {
    reason: {
      type: 'string',
      enum: ['market', 'product', 'explicit'],
      description: `The reason for the restriction. Albums may be restricted if the content is not available in a given market, to the user's subscription type, or when the user's account is set to not play explicit content.
Additional reasons may be added in the future.
`,
    },
  },
} as const;

export const EpisodeRestrictionObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'EpisodeRestrictionObject',
  properties: {
    reason: {
      type: 'string',
      description: `The reason for the restriction. Supported values:
- \`market\` - The content item is not available in the given market.
- \`product\` - The content item is not available for the user's subscription type.
- \`explicit\` - The content item is explicit and the user's account is set to not play explicit content.

Additional reasons may be added in the future.
**Note**: If you use this field, make sure that your application safely handles unknown values.
`,
    },
  },
} as const;

export const ChapterRestrictionObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'ChapterRestrictionObject',
  properties: {
    reason: {
      type: 'string',
      description: `The reason for the restriction. Supported values:
- \`market\` - The content item is not available in the given market.
- \`product\` - The content item is not available for the user's subscription type.
- \`explicit\` - The content item is explicit and the user's account is set to not play explicit content.
- \`payment_required\` - Payment is required to play the content item.

Additional reasons may be added in the future.
**Note**: If you use this field, make sure that your application safely handles unknown values.
`,
    },
  },
} as const;

export const ArtistObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'ArtistObject',
  properties: {
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `Known external URLs for this artist.
`,
    },
    followers: {
      allOf: [
        {
          $ref: '#/components/schemas/FollowersObject',
        },
      ],
      description: `Information about the followers of the artist.
`,
    },
    genres: {
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['Prog rock', 'Grunge'],
      description: `A list of the genres the artist is associated with. If not yet classified, the array is empty.
`,
    },
    href: {
      type: 'string',
      description: `A link to the Web API endpoint providing full details of the artist.
`,
    },
    id: {
      type: 'string',
      description: `The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the artist.
`,
    },
    images: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ImageObject',
      },
      description: `Images of the artist in various sizes, widest first.
`,
    },
    name: {
      type: 'string',
      description: `The name of the artist.
`,
    },
    popularity: {
      type: 'integer',
      description: `The popularity of the artist. The value will be between 0 and 100, with 100 being the most popular. The artist's popularity is calculated from the popularity of all the artist's tracks.
`,
    },
    type: {
      type: 'string',
      enum: ['artist'],
      description: `The object type.
`,
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the artist.
`,
    },
  },
} as const;

export const SimplifiedArtistObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'SimplifiedArtistObject',
  properties: {
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `Known external URLs for this artist.
`,
    },
    href: {
      type: 'string',
      description: `A link to the Web API endpoint providing full details of the artist.
`,
    },
    id: {
      type: 'string',
      description: `The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the artist.
`,
    },
    name: {
      type: 'string',
      description: `The name of the artist.
`,
    },
    type: {
      type: 'string',
      enum: ['artist'],
      description: `The object type.
`,
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the artist.
`,
    },
  },
} as const;

export const PlayHistoryObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PlayHistoryObject',
  properties: {
    track: {
      allOf: [
        {
          $ref: '#/components/schemas/TrackObject',
        },
      ],
      description: 'The track the user listened to.',
    },
    played_at: {
      type: 'string',
      format: 'date-time',
      'x-spotify-docs-type': 'Timestamp',
      description: 'The date and time the track was played.',
    },
    context: {
      allOf: [
        {
          $ref: '#/components/schemas/ContextObject',
        },
      ],
      description: 'The context the track was played from.',
    },
  },
} as const;

export const PlaylistTrackObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PlaylistTrackObject',
  properties: {
    added_at: {
      type: 'string',
      format: 'date-time',
      'x-spotify-docs-type': 'Timestamp',
      description: `The date and time the track or episode was added. _**Note**: some very old playlists may return \`null\` in this field._
`,
    },
    added_by: {
      allOf: [
        {
          $ref: '#/components/schemas/PlaylistUserObject',
        },
      ],
      description: `The Spotify user who added the track or episode. _**Note**: some very old playlists may return \`null\` in this field._
`,
    },
    is_local: {
      type: 'boolean',
      description: `Whether this track or episode is a [local file](/documentation/web-api/concepts/playlists/#local-files) or not.
`,
    },
    track: {
      oneOf: [
        {
          $ref: '#/components/schemas/TrackObject',
        },
        {
          $ref: '#/components/schemas/EpisodeObject',
        },
      ],
      'x-spotify-docs-type': 'TrackObject | EpisodeObject',
      description: 'Information about the track or episode.',
      discriminator: {
        propertyName: 'type',
      },
    },
  },
} as const;

export const QueueObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'QueueObject',
  properties: {
    currently_playing: {
      oneOf: [
        {
          $ref: '#/components/schemas/TrackObject',
        },
        {
          $ref: '#/components/schemas/EpisodeObject',
        },
      ],
      discriminator: {
        propertyName: 'type',
      },
      'x-spotify-docs-type': 'TrackObject | EpisodeObject',
      description: 'The currently playing track or episode. Can be `null`.',
    },
    queue: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/TrackObject',
          },
          {
            $ref: '#/components/schemas/EpisodeObject',
          },
        ],
        discriminator: {
          propertyName: 'type',
        },
        'x-spotify-docs-type': 'TrackObject | EpisodeObject',
      },
      description: 'The tracks or episodes in the queue. Can be empty.',
    },
  },
} as const;

export const CurrentlyPlayingContextObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'CurrentlyPlayingContextObject',
  properties: {
    device: {
      allOf: [
        {
          $ref: '#/components/schemas/DeviceObject',
        },
      ],
      description: `The device that is currently active.
`,
    },
    repeat_state: {
      type: 'string',
      description: 'off, track, context',
    },
    shuffle_state: {
      type: 'boolean',
      description: 'If shuffle is on or off.',
    },
    context: {
      allOf: [
        {
          $ref: '#/components/schemas/ContextObject',
        },
      ],
      description: 'A Context Object. Can be `null`.',
    },
    timestamp: {
      type: 'integer',
      description:
        'Unix Millisecond Timestamp when playback state was last changed (play, pause, skip, scrub, new song, etc.).',
    },
    progress_ms: {
      type: 'integer',
      description: 'Progress into the currently playing track or episode. Can be `null`.',
    },
    is_playing: {
      type: 'boolean',
      description: 'If something is currently playing, return `true`.',
    },
    item: {
      oneOf: [
        {
          $ref: '#/components/schemas/TrackObject',
        },
        {
          $ref: '#/components/schemas/EpisodeObject',
        },
      ],
      discriminator: {
        propertyName: 'type',
      },
      'x-spotify-docs-type': 'TrackObject | EpisodeObject',
      description: 'The currently playing track or episode. Can be `null`.',
    },
    currently_playing_type: {
      type: 'string',
      description: `The object type of the currently playing item. Can be one of \`track\`, \`episode\`, \`ad\` or \`unknown\`.
`,
    },
    actions: {
      allOf: [
        {
          $ref: '#/components/schemas/DisallowsObject',
        },
      ],
      description: `Allows to update the user interface based on which playback actions are available within the current context.
`,
    },
  },
} as const;

export const DisallowsObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'DisallowsObject',
  properties: {
    interrupting_playback: {
      type: 'boolean',
      description: 'Interrupting playback. Optional field.',
    },
    pausing: {
      type: 'boolean',
      description: 'Pausing. Optional field.',
    },
    resuming: {
      type: 'boolean',
      description: 'Resuming. Optional field.',
    },
    seeking: {
      type: 'boolean',
      description: 'Seeking playback location. Optional field.',
    },
    skipping_next: {
      type: 'boolean',
      description: 'Skipping to the next context. Optional field.',
    },
    skipping_prev: {
      type: 'boolean',
      description: 'Skipping to the previous context. Optional field.',
    },
    toggling_repeat_context: {
      type: 'boolean',
      description: 'Toggling repeat context flag. Optional field.',
    },
    toggling_shuffle: {
      type: 'boolean',
      description: 'Toggling shuffle flag. Optional field.',
    },
    toggling_repeat_track: {
      type: 'boolean',
      description: 'Toggling repeat track flag. Optional field.',
    },
    transferring_playback: {
      type: 'boolean',
      description: 'Transfering playback between devices. Optional field.',
    },
  },
} as const;

export const ErrorObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'ErrorObject',
  required: ['status', 'message'],
  properties: {
    status: {
      type: 'integer',
      minimum: 400,
      maximum: 599,
      description: `The HTTP status code (also returned in the response header; see [Response Status Codes](/documentation/web-api/concepts/api-calls#response-status-codes) for more information).
`,
    },
    message: {
      type: 'string',
      description: `A short description of the cause of the error.
`,
    },
  },
} as const;

export const PrivateUserObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PrivateUserObject',
  properties: {
    country: {
      type: 'string',
      description: `The country of the user, as set in the user's account profile. An [ISO 3166-1 alpha-2 country code](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). _This field is only available when the current user has granted access to the [user-read-private](/documentation/web-api/concepts/scopes/#list-of-scopes) scope._
`,
    },
    display_name: {
      type: 'string',
      description: `The name displayed on the user's profile. \`null\` if not available.
`,
    },
    email: {
      type: 'string',
      description: `The user's email address, as entered by the user when creating their account. _**Important!** This email address is unverified; there is no proof that it actually belongs to the user._ _This field is only available when the current user has granted access to the [user-read-email](/documentation/web-api/concepts/scopes/#list-of-scopes) scope._
`,
    },
    explicit_content: {
      allOf: [
        {
          $ref: '#/components/schemas/ExplicitContentSettingsObject',
        },
      ],
      description: `The user's explicit content settings. _This field is only available when the current user has granted access to the [user-read-private](/documentation/web-api/concepts/scopes/#list-of-scopes) scope._
`,
    },
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: 'Known external URLs for this user.',
    },
    followers: {
      allOf: [
        {
          $ref: '#/components/schemas/FollowersObject',
        },
      ],
      description: 'Information about the followers of the user.',
    },
    href: {
      type: 'string',
      description: `A link to the Web API endpoint for this user.
`,
    },
    id: {
      type: 'string',
      description: `The [Spotify user ID](/documentation/web-api/concepts/spotify-uris-ids) for the user.
`,
    },
    images: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ImageObject',
      },
      description: "The user's profile image.",
    },
    product: {
      type: 'string',
      description: `The user's Spotify subscription level: "premium", "free", etc. (The subscription level "open" can be considered the same as "free".) _This field is only available when the current user has granted access to the [user-read-private](/documentation/web-api/concepts/scopes/#list-of-scopes) scope._
`,
    },
    type: {
      type: 'string',
      description: `The object type: "user"
`,
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the user.
`,
    },
  },
} as const;

export const PublicUserObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PublicUserObject',
  properties: {
    display_name: {
      type: 'string',
      nullable: true,
      description: `The name displayed on the user's profile. \`null\` if not available.
`,
    },
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `Known public external URLs for this user.
`,
    },
    followers: {
      allOf: [
        {
          $ref: '#/components/schemas/FollowersObject',
        },
      ],
      description: `Information about the followers of this user.
`,
    },
    href: {
      type: 'string',
      description: `A link to the Web API endpoint for this user.
`,
    },
    id: {
      type: 'string',
      description: `The [Spotify user ID](/documentation/web-api/concepts/spotify-uris-ids) for this user.
`,
    },
    images: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ImageObject',
      },
      description: `The user's profile image.
`,
    },
    type: {
      type: 'string',
      enum: ['user'],
      description: `The object type.
`,
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for this user.
`,
    },
  },
} as const;

export const AudioAnalysisObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'AudioAnalysisObject',
  properties: {
    meta: {
      type: 'object',
      properties: {
        analyzer_version: {
          type: 'string',
          example: '4.0.0',
          description: 'The version of the Analyzer used to analyze this track.',
        },
        platform: {
          type: 'string',
          example: 'Linux',
          description: "The platform used to read the track's audio data.",
        },
        detailed_status: {
          type: 'string',
          example: 'OK',
          description: 'A detailed status code for this track. If analysis data is missing, this code may explain why.',
        },
        status_code: {
          type: 'integer',
          example: 0,
          description: 'The return code of the analyzer process. 0 if successful, 1 if any errors occurred.',
        },
        timestamp: {
          type: 'integer',
          example: 1495193577,
          description: 'The Unix timestamp (in seconds) at which this track was analyzed.',
        },
        analysis_time: {
          type: 'number',
          example: 6.93906,
          description: 'The amount of time taken to analyze this track.',
        },
        input_process: {
          type: 'string',
          example: 'libvorbisfile L+R 44100->22050',
          description: "The method used to read the track's audio data.",
        },
      },
    },
    track: {
      type: 'object',
      properties: {
        num_samples: {
          type: 'integer',
          example: 4585515,
          description: 'The exact number of audio samples analyzed from this track. See also `analysis_sample_rate`.',
        },
        duration: {
          type: 'number',
          description: 'Length of the track in seconds.',
          example: 207.95985,
        },
        sample_md5: {
          type: 'string',
          description: 'This field will always contain the empty string.',
        },
        offset_seconds: {
          type: 'integer',
          example: 0,
          description:
            'An offset to the start of the region of the track that was analyzed. (As the entire track is analyzed, this should always be 0.)',
        },
        window_seconds: {
          type: 'integer',
          example: 0,
          description:
            'The length of the region of the track was analyzed, if a subset of the track was analyzed. (As the entire track is analyzed, this should always be 0.)',
        },
        analysis_sample_rate: {
          type: 'integer',
          example: 22050,
          description:
            'The sample rate used to decode and analyze this track. May differ from the actual sample rate of this track available on Spotify.',
        },
        analysis_channels: {
          type: 'integer',
          example: 1,
          description:
            'The number of channels used for analysis. If 1, all channels are summed together to mono before analysis.',
        },
        end_of_fade_in: {
          type: 'number',
          example: 0,
          description:
            "The time, in seconds, at which the track's fade-in period ends. If the track has no fade-in, this will be 0.0.",
        },
        start_of_fade_out: {
          type: 'number',
          example: 201.13705,
          description:
            "The time, in seconds, at which the track's fade-out period starts. If the track has no fade-out, this should match the track's length.",
        },
        loudness: {
          $ref: '#/components/schemas/Loudness',
        },
        tempo: {
          $ref: '#/components/schemas/Tempo',
        },
        tempo_confidence: {
          type: 'number',
          example: 0.73,
          minimum: 0,
          maximum: 1,
          description: 'The confidence, from 0.0 to 1.0, of the reliability of the `tempo`.',
        },
        time_signature: {
          $ref: '#/components/schemas/TimeSignature',
        },
        time_signature_confidence: {
          type: 'number',
          example: 0.994,
          minimum: 0,
          maximum: 1,
          description: 'The confidence, from 0.0 to 1.0, of the reliability of the `time_signature`.',
        },
        key: {
          $ref: '#/components/schemas/Key',
        },
        key_confidence: {
          type: 'number',
          example: 0.408,
          minimum: 0,
          maximum: 1,
          description: 'The confidence, from 0.0 to 1.0, of the reliability of the `key`.',
        },
        mode: {
          $ref: '#/components/schemas/Mode',
        },
        mode_confidence: {
          type: 'number',
          example: 0.485,
          minimum: 0,
          maximum: 1,
          description: 'The confidence, from 0.0 to 1.0, of the reliability of the `mode`.',
        },
        codestring: {
          type: 'string',
          description:
            'An [Echo Nest Musical Fingerprint (ENMFP)](https://academiccommons.columbia.edu/doi/10.7916/D8Q248M4) codestring for this track.',
        },
        code_version: {
          type: 'number',
          example: 3.15,
          description: 'A version number for the Echo Nest Musical Fingerprint format used in the codestring field.',
        },
        echoprintstring: {
          type: 'string',
          description: 'An [EchoPrint](https://github.com/spotify/echoprint-codegen) codestring for this track.',
        },
        echoprint_version: {
          type: 'number',
          example: 4.15,
          description: 'A version number for the EchoPrint format used in the echoprintstring field.',
        },
        synchstring: {
          type: 'string',
          description: 'A [Synchstring](https://github.com/echonest/synchdata) for this track.',
        },
        synch_version: {
          type: 'number',
          example: 1,
          description: 'A version number for the Synchstring used in the synchstring field.',
        },
        rhythmstring: {
          type: 'string',
          description: 'A Rhythmstring for this track. The format of this string is similar to the Synchstring.',
        },
        rhythm_version: {
          type: 'number',
          example: 1,
          description: 'A version number for the Rhythmstring used in the rhythmstring field.',
        },
      },
    },
    bars: {
      type: 'array',
      description:
        'The time intervals of the bars throughout the track. A bar (or measure) is a segment of time defined as a given number of beats.',
      items: {
        $ref: '#/components/schemas/TimeIntervalObject',
      },
    },
    beats: {
      type: 'array',
      description:
        'The time intervals of beats throughout the track. A beat is the basic time unit of a piece of music; for example, each tick of a metronome. Beats are typically multiples of tatums.',
      items: {
        $ref: '#/components/schemas/TimeIntervalObject',
      },
    },
    sections: {
      type: 'array',
      description:
        'Sections are defined by large variations in rhythm or timbre, e.g. chorus, verse, bridge, guitar solo, etc. Each section contains its own descriptions of tempo, key, mode, time_signature, and loudness.',
      items: {
        $ref: '#/components/schemas/SectionObject',
      },
    },
    segments: {
      type: 'array',
      description: 'Each segment contains a roughly conisistent sound throughout its duration.',
      items: {
        $ref: '#/components/schemas/SegmentObject',
      },
    },
    tatums: {
      type: 'array',
      description:
        'A tatum represents the lowest regular pulse train that a listener intuitively infers from the timing of perceived musical events (segments).',
      items: {
        $ref: '#/components/schemas/TimeIntervalObject',
      },
    },
  },
} as const;

export const TimeIntervalObjectSchema = {
  type: 'object',
  properties: {
    start: {
      type: 'number',
      description: 'The starting point (in seconds) of the time interval.',
      example: 0.49567,
    },
    duration: {
      type: 'number',
      description: 'The duration (in seconds) of the time interval.',
      example: 2.18749,
    },
    confidence: {
      type: 'number',
      description: 'The confidence, from 0.0 to 1.0, of the reliability of the interval.',
      example: 0.925,
      minimum: 0,
      maximum: 1,
    },
  },
} as const;

export const SectionObjectSchema = {
  type: 'object',
  properties: {
    start: {
      type: 'number',
      description: 'The starting point (in seconds) of the section.',
      example: 0,
    },
    duration: {
      type: 'number',
      description: 'The duration (in seconds) of the section.',
      example: 6.97092,
    },
    confidence: {
      type: 'number',
      description: `The confidence, from 0.0 to 1.0, of the reliability of the section's "designation".`,
      example: 1,
      minimum: 0,
      maximum: 1,
    },
    loudness: {
      type: 'number',
      description:
        'The overall loudness of the section in decibels (dB). Loudness values are useful for comparing relative loudness of sections within tracks.',
      example: -14.938,
    },
    tempo: {
      type: 'number',
      description:
        'The overall estimated tempo of the section in beats per minute (BPM). In musical terminology, tempo is the speed or pace of a given piece and derives directly from the average beat duration.',
      example: 113.178,
    },
    tempo_confidence: {
      type: 'number',
      description:
        "The confidence, from 0.0 to 1.0, of the reliability of the tempo. Some tracks contain tempo changes or sounds which don't contain tempo (like pure speech) which would correspond to a low value in this field.",
      example: 0.647,
      minimum: 0,
      maximum: 1,
    },
    key: {
      type: 'integer',
      description:
        'The estimated overall key of the section. The values in this field ranging from 0 to 11 mapping to pitches using standard Pitch Class notation (E.g. 0 = C, 1 = C♯/D♭, 2 = D, and so on). If no key was detected, the value is -1.',
      example: 9,
    },
    key_confidence: {
      type: 'number',
      description:
        'The confidence, from 0.0 to 1.0, of the reliability of the key. Songs with many key changes may correspond to low values in this field.',
      example: 0.297,
      minimum: 0,
      maximum: 1,
    },
    mode: {
      type: 'number',
      description:
        'Indicates the modality (major or minor) of a section, the type of scale from which its melodic content is derived. This field will contain a 0 for "minor", a 1 for "major", or a -1 for no result. Note that the major key (e.g. C major) could more likely be confused with the minor key at 3 semitones lower (e.g. A minor) as both keys carry the same pitches.',
      enum: [-1, 0, 1],
    },
    mode_confidence: {
      type: 'number',
      description: 'The confidence, from 0.0 to 1.0, of the reliability of the `mode`.',
      example: 0.471,
      minimum: 0,
      maximum: 1,
    },
    time_signature: {
      $ref: '#/components/schemas/TimeSignature',
    },
    time_signature_confidence: {
      type: 'number',
      description:
        'The confidence, from 0.0 to 1.0, of the reliability of the `time_signature`. Sections with time signature changes may correspond to low values in this field.',
      example: 1,
      minimum: 0,
      maximum: 1,
    },
  },
} as const;

export const SegmentObjectSchema = {
  type: 'object',
  properties: {
    start: {
      type: 'number',
      description: 'The starting point (in seconds) of the segment.',
      example: 0.70154,
    },
    duration: {
      type: 'number',
      description: 'The duration (in seconds) of the segment.',
      example: 0.19891,
    },
    confidence: {
      type: 'number',
      example: 0.435,
      minimum: 0,
      maximum: 1,
      description: `The confidence, from 0.0 to 1.0, of the reliability of the segmentation. Segments of the song which are difficult to logically segment (e.g: noise) may correspond to low values in this field.
`,
    },
    loudness_start: {
      type: 'number',
      description:
        'The onset loudness of the segment in decibels (dB). Combined with `loudness_max` and `loudness_max_time`, these components can be used to describe the "attack" of the segment.',
      example: -23.053,
    },
    loudness_max: {
      type: 'number',
      description:
        'The peak loudness of the segment in decibels (dB). Combined with `loudness_start` and `loudness_max_time`, these components can be used to describe the "attack" of the segment.',
      example: -14.25,
    },
    loudness_max_time: {
      type: 'number',
      description:
        'The segment-relative offset of the segment peak loudness in seconds. Combined with `loudness_start` and `loudness_max`, these components can be used to desctibe the "attack" of the segment.',
      example: 0.07305,
    },
    loudness_end: {
      type: 'number',
      description:
        'The offset loudness of the segment in decibels (dB). This value should be equivalent to the loudness_start of the following segment.',
      example: 0,
    },
    pitches: {
      type: 'array',
      description: `Pitch content is given by a “chroma” vector, corresponding to the 12 pitch classes C, C#, D to B, with values ranging from 0 to 1 that describe the relative dominance of every pitch in the chromatic scale. For example a C Major chord would likely be represented by large values of C, E and G (i.e. classes 0, 4, and 7).

Vectors are normalized to 1 by their strongest dimension, therefore noisy sounds are likely represented by values that are all close to 1, while pure tones are described by one value at 1 (the pitch) and others near 0.
As can be seen below, the 12 vector indices are a combination of low-power spectrum values at their respective pitch frequencies.
![pitch vector](https://developer.spotify.com/assets/audio/Pitch_vector.png)
`,
      items: {
        type: 'number',
        minimum: 0,
        maximum: 1,
      },
      example: [0.212, 0.141, 0.294],
    },
    timbre: {
      type: 'array',
      description: `Timbre is the quality of a musical note or sound that distinguishes different types of musical instruments, or voices. It is a complex notion also referred to as sound color, texture, or tone quality, and is derived from the shape of a segment’s spectro-temporal surface, independently of pitch and loudness. The timbre feature is a vector that includes 12 unbounded values roughly centered around 0. Those values are high level abstractions of the spectral surface, ordered by degree of importance.

For completeness however, the first dimension represents the average loudness of the segment; second emphasizes brightness; third is more closely correlated to the flatness of a sound; fourth to sounds with a stronger attack; etc. See an image below representing the 12 basis functions (i.e. template segments).
![timbre basis functions](https://developer.spotify.com/assets/audio/Timbre_basis_functions.png)

The actual timbre of the segment is best described as a linear combination of these 12 basis functions weighted by the coefficient values: timbre = c1 x b1 + c2 x b2 + ... + c12 x b12, where c1 to c12 represent the 12 coefficients and b1 to b12 the 12 basis functions as displayed below. Timbre vectors are best used in comparison with each other.
`,
      items: {
        type: 'number',
      },
      example: [42.115, 64.373, -0.233],
    },
  },
} as const;

export const TimeSignatureSchema = {
  type: 'integer',
  description:
    'An estimated time signature. The time signature (meter) is a notational convention to specify how many beats are in each bar (or measure). The time signature ranges from 3 to 7 indicating time signatures of "3/4", to "7/4".',
  example: 4,
  minimum: 3,
  maximum: 7,
} as const;

export const TempoSchema = {
  type: 'number',
  example: 118.211,
  format: 'float',
  'x-spotify-docs-type': 'Float',
  description: `The overall estimated tempo of a track in beats per minute (BPM). In musical terminology, tempo is the speed or pace of a given piece and derives directly from the average beat duration.
`,
} as const;

export const LoudnessSchema = {
  type: 'number',
  example: -5.883,
  format: 'float',
  'x-spotify-docs-type': 'Float',
  description: `The overall loudness of a track in decibels (dB). Loudness values are averaged across the entire track and are useful for comparing relative loudness of tracks. Loudness is the quality of a sound that is the primary psychological correlate of physical strength (amplitude). Values typically range between -60 and 0 db.
`,
} as const;

export const KeySchema = {
  type: 'integer',
  example: 9,
  minimum: -1,
  maximum: 11,
  description: `The key the track is in. Integers map to pitches using standard [Pitch Class notation](https://en.wikipedia.org/wiki/Pitch_class). E.g. 0 = C, 1 = C♯/D♭, 2 = D, and so on. If no key was detected, the value is -1.
`,
} as const;

export const ModeSchema = {
  type: 'integer',
  example: 0,
  description: `Mode indicates the modality (major or minor) of a track, the type of scale from which its melodic content is derived. Major is represented by 1 and minor is 0.
`,
} as const;

export const AudioFeaturesObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'AudioFeaturesObject',
  properties: {
    acousticness: {
      type: 'number',
      format: 'float',
      example: 0.00242,
      minimum: 0,
      maximum: 1,
      'x-spotify-docs-type': 'Float',
      description: `A confidence measure from 0.0 to 1.0 of whether the track is acoustic. 1.0 represents high confidence the track is acoustic.
`,
    },
    analysis_url: {
      type: 'string',
      example: `https://api.spotify.com/v1/audio-analysis/2takcwOaAZWiXQijPHIx7B
`,
      description: `A URL to access the full audio analysis of this track. An access token is required to access this data.
`,
    },
    danceability: {
      type: 'number',
      example: 0.585,
      format: 'float',
      'x-spotify-docs-type': 'Float',
      description: `Danceability describes how suitable a track is for dancing based on a combination of musical elements including tempo, rhythm stability, beat strength, and overall regularity. A value of 0.0 is least danceable and 1.0 is most danceable.
`,
    },
    duration_ms: {
      type: 'integer',
      example: 237040,
      description: `The duration of the track in milliseconds.
`,
    },
    energy: {
      type: 'number',
      example: 0.842,
      format: 'float',
      'x-spotify-docs-type': 'Float',
      description: `Energy is a measure from 0.0 to 1.0 and represents a perceptual measure of intensity and activity. Typically, energetic tracks feel fast, loud, and noisy. For example, death metal has high energy, while a Bach prelude scores low on the scale. Perceptual features contributing to this attribute include dynamic range, perceived loudness, timbre, onset rate, and general entropy.
`,
    },
    id: {
      type: 'string',
      example: '2takcwOaAZWiXQijPHIx7B',
      description: `The Spotify ID for the track.
`,
    },
    instrumentalness: {
      type: 'number',
      example: 0.00686,
      format: 'float',
      'x-spotify-docs-type': 'Float',
      description: `Predicts whether a track contains no vocals. "Ooh" and "aah" sounds are treated as instrumental in this context. Rap or spoken word tracks are clearly "vocal". The closer the instrumentalness value is to 1.0, the greater likelihood the track contains no vocal content. Values above 0.5 are intended to represent instrumental tracks, but confidence is higher as the value approaches 1.0.
`,
    },
    key: {
      $ref: '#/components/schemas/Key',
    },
    liveness: {
      type: 'number',
      example: 0.0866,
      format: 'float',
      'x-spotify-docs-type': 'Float',
      description: `Detects the presence of an audience in the recording. Higher liveness values represent an increased probability that the track was performed live. A value above 0.8 provides strong likelihood that the track is live.
`,
    },
    loudness: {
      $ref: '#/components/schemas/Loudness',
    },
    mode: {
      $ref: '#/components/schemas/Mode',
    },
    speechiness: {
      type: 'number',
      example: 0.0556,
      format: 'float',
      'x-spotify-docs-type': 'Float',
      description: `Speechiness detects the presence of spoken words in a track. The more exclusively speech-like the recording (e.g. talk show, audio book, poetry), the closer to 1.0 the attribute value. Values above 0.66 describe tracks that are probably made entirely of spoken words. Values between 0.33 and 0.66 describe tracks that may contain both music and speech, either in sections or layered, including such cases as rap music. Values below 0.33 most likely represent music and other non-speech-like tracks.
`,
    },
    tempo: {
      $ref: '#/components/schemas/Tempo',
    },
    time_signature: {
      $ref: '#/components/schemas/TimeSignature',
    },
    track_href: {
      type: 'string',
      example: `https://api.spotify.com/v1/tracks/2takcwOaAZWiXQijPHIx7B
`,
      description: `A link to the Web API endpoint providing full details of the track.
`,
    },
    type: {
      type: 'string',
      enum: ['audio_features'],
      description: `The object type.
`,
    },
    uri: {
      type: 'string',
      example: 'spotify:track:2takcwOaAZWiXQijPHIx7B',
      description: `The Spotify URI for the track.
`,
    },
    valence: {
      type: 'number',
      example: 0.428,
      minimum: 0,
      maximum: 1,
      format: 'float',
      'x-spotify-docs-type': 'Float',
      description: `A measure from 0.0 to 1.0 describing the musical positiveness conveyed by a track. Tracks with high valence sound more positive (e.g. happy, cheerful, euphoric), while tracks with low valence sound more negative (e.g. sad, depressed, angry).
`,
    },
  },
} as const;

export const SimplifiedTrackObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'SimplifiedTrackObject',
  properties: {
    artists: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SimplifiedArtistObject',
      },
      description:
        'The artists who performed the track. Each artist object includes a link in `href` to more detailed information about the artist.',
    },
    available_markets: {
      type: 'array',
      items: {
        type: 'string',
      },
      description: `A list of the countries in which the track can be played, identified by their [ISO 3166-1 alpha-2](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code.
`,
    },
    disc_number: {
      type: 'integer',
      description: 'The disc number (usually `1` unless the album consists of more than one disc).',
    },
    duration_ms: {
      type: 'integer',
      description: 'The track length in milliseconds.',
    },
    explicit: {
      type: 'boolean',
      description:
        'Whether or not the track has explicit lyrics ( `true` = yes it does; `false` = no it does not OR unknown).',
    },
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `External URLs for this track.
`,
    },
    href: {
      type: 'string',
      description: 'A link to the Web API endpoint providing full details of the track.',
    },
    id: {
      type: 'string',
      description: `The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the track.
`,
    },
    is_playable: {
      type: 'boolean',
      description: `Part of the response when [Track Relinking](/documentation/web-api/concepts/track-relinking/) is applied. If \`true\`, the track is playable in the given market. Otherwise \`false\`.
`,
    },
    linked_from: {
      allOf: [
        {
          $ref: '#/components/schemas/LinkedTrackObject',
        },
      ],
      description:
        'Part of the response when [Track Relinking](/documentation/web-api/concepts/track-relinking/) is applied and is only part of the response if the track linking, in fact, exists. The requested track has been replaced with a different track. The track in the `linked_from` object contains information about the originally requested track.',
    },
    restrictions: {
      allOf: [
        {
          $ref: '#/components/schemas/TrackRestrictionObject',
        },
      ],
      description: `Included in the response when a content restriction is applied.
`,
    },
    name: {
      type: 'string',
      description: 'The name of the track.',
    },
    preview_url: {
      type: 'string',
      nullable: true,
      description: `A URL to a 30 second preview (MP3 format) of the track.
`,
      'x-spotify-policy-list': [
        {
          $ref: '#/components/x-spotify-policy/policies/StandalonePreview',
        },
      ],
    },
    track_number: {
      type: 'integer',
      description: `The number of the track. If an album has several discs, the track number is the number on the specified disc.
`,
    },
    type: {
      type: 'string',
      description: `The object type: "track".
`,
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the track.
`,
    },
    is_local: {
      type: 'boolean',
      description: `Whether or not the track is from a local file.
`,
    },
  },
} as const;

export const DeviceObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'DeviceObject',
  properties: {
    id: {
      type: 'string',
      nullable: true,
      description:
        'The device ID. This ID is unique and persistent to some extent. However, this is not guaranteed and any cached `device_id` should periodically be cleared out and refetched as necessary.',
    },
    is_active: {
      type: 'boolean',
      description: 'If this device is the currently active device.',
    },
    is_private_session: {
      type: 'boolean',
      description: 'If this device is currently in a private session.',
    },
    is_restricted: {
      type: 'boolean',
      description:
        'Whether controlling this device is restricted. At present if this is "true" then no Web API commands will be accepted by this device.',
    },
    name: {
      type: 'string',
      example: 'Kitchen speaker',
      description:
        'A human-readable name for the device. Some devices have a name that the user can configure (e.g. \\"Loudest speaker\\") and some devices have a generic name associated with the manufacturer or device model.',
    },
    type: {
      type: 'string',
      example: 'computer',
      description: 'Device type, such as "computer", "smartphone" or "speaker".',
    },
    volume_percent: {
      type: 'integer',
      minimum: 0,
      example: 59,
      maximum: 100,
      nullable: true,
      description: 'The current volume in percent.',
    },
    supports_volume: {
      type: 'boolean',
      description: 'If this device can be used to set the volume.',
    },
  },
} as const;

export const CursorObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'CursorObject',
  properties: {
    after: {
      type: 'string',
      description: 'The cursor to use as key to find the next page of items.',
    },
    before: {
      type: 'string',
      description: 'The cursor to use as key to find the previous page of items.',
    },
  },
} as const;

export const CursorPagingObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'CursorPagingObject',
  properties: {
    href: {
      type: 'string',
      description: 'A link to the Web API endpoint returning the full result of the request.',
    },
    limit: {
      type: 'integer',
      description: 'The maximum number of items in the response (as set in the query or by default).',
    },
    next: {
      type: 'string',
      description: 'URL to the next page of items. ( `null` if none)',
    },
    cursors: {
      allOf: [
        {
          $ref: '#/components/schemas/CursorObject',
        },
      ],
      description: 'The cursors used to find the next set of items.',
    },
    total: {
      type: 'integer',
      description: 'The total number of items available to return.',
    },
  },
} as const;

export const CursorPagingPlayHistoryObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingTrackObject',
  allOf: [
    {
      $ref: '#/components/schemas/CursorPagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/PlayHistoryObject',
          },
        },
      },
    },
  ],
} as const;

export const CursorPagingSimplifiedArtistObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingArtistObject',
  allOf: [
    {
      $ref: '#/components/schemas/CursorPagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/ArtistObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingObject',
  required: ['href', 'items', 'limit', 'next', 'offset', 'previous', 'total'],
  properties: {
    href: {
      type: 'string',
      example: `https://api.spotify.com/v1/me/shows?offset=0&limit=20
`,
      description: `A link to the Web API endpoint returning the full result of the request
`,
    },
    limit: {
      type: 'integer',
      example: 20,
      description: `The maximum number of items in the response (as set in the query or by default).
`,
    },
    next: {
      type: 'string',
      example: 'https://api.spotify.com/v1/me/shows?offset=1&limit=1',
      nullable: true,
      description: `URL to the next page of items. ( \`null\` if none)
`,
    },
    offset: {
      type: 'integer',
      example: 0,
      description: `The offset of the items returned (as set in the query or by default)
`,
    },
    previous: {
      type: 'string',
      example: 'https://api.spotify.com/v1/me/shows?offset=1&limit=1',
      nullable: true,
      description: `URL to the previous page of items. ( \`null\` if none)
`,
    },
    total: {
      type: 'integer',
      example: 4,
      description: `The total number of items available to return.
`,
    },
  },
} as const;

export const PagingPlaylistObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingPlaylistObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SimplifiedPlaylistObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingFeaturedPlaylistObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingFeaturedPlaylistObject',
  properties: {
    message: {
      type: 'string',
      description: `The localized message of a playlist.
`,
      example: 'Popular Playlists',
    },
    playlists: {
      $ref: '#/components/schemas/PagingPlaylistObject',
    },
  },
} as const;

export const PagingArtistDiscographyAlbumObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingArtistDiscographyAlbumObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/ArtistDiscographyAlbumObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingSimplifiedAlbumObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingAlbumObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SimplifiedAlbumObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingSavedAlbumObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingSavedAlbumObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SavedAlbumObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingSimplifiedTrackObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingTrackObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SimplifiedTrackObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingSavedTrackObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingTrackObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SavedTrackObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingTrackObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingTrackObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/TrackObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingPlaylistTrackObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingPlaylistTrackObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/PlaylistTrackObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingSimplifiedShowObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingShowObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SimplifiedShowObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingSavedShowObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingShowObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SavedShowObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingSimplifiedEpisodeObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingEpisodeObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SimplifiedEpisodeObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingSavedEpisodeObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingEpisodeObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SavedEpisodeObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingSimplifiedAudiobookObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingAudiobookObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SimplifiedAudiobookObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingArtistObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingArtistObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/ArtistObject',
          },
        },
      },
    },
  ],
} as const;

export const PagingSimplifiedChapterObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PagingSimplifiedChapterObject',
  allOf: [
    {
      $ref: '#/components/schemas/PagingObject',
    },
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SimplifiedChapterObject',
          },
        },
      },
    },
  ],
} as const;

export const RecommendationsObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'RecommendationsObject',
  required: ['seeds', 'tracks'],
  properties: {
    seeds: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/RecommendationSeedObject',
      },
      description: `An array of recommendation seed objects.
`,
    },
    tracks: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TrackObject',
      },
      description: `An array of track object (simplified) ordered according to the parameters supplied.
`,
    },
  },
} as const;

export const RecommendationSeedObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'RecommendationSeedObject',
  properties: {
    afterFilteringSize: {
      type: 'integer',
      description: `The number of tracks available after min\_\* and max\_\* filters have been applied.
`,
    },
    afterRelinkingSize: {
      type: 'integer',
      description: `The number of tracks available after relinking for regional availability.
`,
    },
    href: {
      type: 'string',
      description: `A link to the full track or artist data for this seed. For tracks this will be a link to a Track Object. For artists a link to an Artist Object. For genre seeds, this value will be \`null\`.
`,
    },
    id: {
      type: 'string',
      description: `The id used to select this seed. This will be the same as the string used in the \`seed_artists\`, \`seed_tracks\` or \`seed_genres\` parameter.
`,
    },
    initialPoolSize: {
      type: 'integer',
      description: `The number of recommended tracks available for this seed.
`,
    },
    type: {
      type: 'string',
      description: `The entity type of this seed. One of \`artist\`, \`track\` or \`genre\`.
`,
    },
  },
} as const;

export const SavedAlbumObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'SavedAlbumObject',
  properties: {
    added_at: {
      type: 'string',
      format: 'date-time',
      'x-spotify-docs-type': 'Timestamp',
      description: `The date and time the album was saved
Timestamps are returned in ISO 8601 format as Coordinated Universal Time (UTC) with a zero offset: YYYY-MM-DDTHH:MM:SSZ.
If the time is imprecise (for example, the date/time of an album release), an additional field indicates the precision; see for example, release_date in an album object.
`,
    },
    album: {
      allOf: [
        {
          $ref: '#/components/schemas/AlbumObject',
        },
      ],
      description: 'Information about the album.',
    },
  },
} as const;

export const SavedTrackObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'SavedTrackObject',
  properties: {
    added_at: {
      type: 'string',
      format: 'date-time',
      'x-spotify-docs-type': 'Timestamp',
      description: `The date and time the track was saved.
Timestamps are returned in ISO 8601 format as Coordinated Universal Time (UTC) with a zero offset: YYYY-MM-DDTHH:MM:SSZ.
If the time is imprecise (for example, the date/time of an album release), an additional field indicates the precision; see for example, release_date in an album object.
`,
    },
    track: {
      allOf: [
        {
          $ref: '#/components/schemas/TrackObject',
        },
      ],
      description: 'Information about the track.',
    },
  },
} as const;

export const SavedEpisodeObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'SavedEpisodeObject',
  properties: {
    added_at: {
      type: 'string',
      format: 'date-time',
      'x-spotify-docs-type': 'Timestamp',
      description: `The date and time the episode was saved.
Timestamps are returned in ISO 8601 format as Coordinated Universal Time (UTC) with a zero offset: YYYY-MM-DDTHH:MM:SSZ.
`,
    },
    episode: {
      allOf: [
        {
          $ref: '#/components/schemas/EpisodeObject',
        },
      ],
      description: 'Information about the episode.',
    },
  },
} as const;

export const SavedShowObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'SavedShowObject',
  properties: {
    added_at: {
      type: 'string',
      format: 'date-time',
      'x-spotify-docs-type': 'Timestamp',
      description: `The date and time the show was saved.
Timestamps are returned in ISO 8601 format as Coordinated Universal Time (UTC) with a zero offset: YYYY-MM-DDTHH:MM:SSZ.
If the time is imprecise (for example, the date/time of an album release), an additional field indicates the precision; see for example, release_date in an album object.
`,
    },
    show: {
      allOf: [
        {
          $ref: '#/components/schemas/SimplifiedShowObject',
        },
      ],
      description: 'Information about the show.',
    },
  },
} as const;

export const PlaylistObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PlaylistObject',
  properties: {
    collaborative: {
      type: 'boolean',
      description: `\`true\` if the owner allows other users to modify the playlist.
`,
    },
    description: {
      type: 'string',
      nullable: true,
      description: `The playlist description. _Only returned for modified, verified playlists, otherwise_ \`null\`.
`,
    },
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `Known external URLs for this playlist.
`,
    },
    followers: {
      allOf: [
        {
          $ref: '#/components/schemas/FollowersObject',
        },
      ],
      description: 'Information about the followers of the playlist.',
    },
    href: {
      type: 'string',
      description: `A link to the Web API endpoint providing full details of the playlist.
`,
    },
    id: {
      type: 'string',
      description: `The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the playlist.
`,
    },
    images: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ImageObject',
      },
      description: `Images for the playlist. The array may be empty or contain up to three images. The images are returned by size in descending order. See [Working with Playlists](/documentation/web-api/concepts/playlists). _**Note**: If returned, the source URL for the image (\`url\`) is temporary and will expire in less than a day._
`,
    },
    name: {
      type: 'string',
      description: `The name of the playlist.
`,
    },
    owner: {
      allOf: [
        {
          $ref: '#/components/schemas/PlaylistOwnerObject',
        },
      ],
      description: `The user who owns the playlist
`,
    },
    public: {
      type: 'boolean',
      description: `The playlist's public/private status (if it is added to the user's profile): \`true\` the playlist is public, \`false\` the playlist is private, \`null\` the playlist status is not relevant. For more about public/private status, see [Working with Playlists](/documentation/web-api/concepts/playlists)
`,
    },
    snapshot_id: {
      type: 'string',
      description: `The version identifier for the current playlist. Can be supplied in other requests to target a specific playlist version
`,
    },
    tracks: {
      type: 'object',
      allOf: [
        {
          $ref: '#/components/schemas/PagingPlaylistTrackObject',
        },
      ],
      description: `The tracks of the playlist.
`,
    },
    type: {
      type: 'string',
      description: `The object type: "playlist"
`,
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the playlist.
`,
    },
  },
} as const;

export const SimplifiedPlaylistObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'SimplifiedPlaylistObject',
  properties: {
    collaborative: {
      type: 'boolean',
      description: `\`true\` if the owner allows other users to modify the playlist.
`,
    },
    description: {
      type: 'string',
      description: `The playlist description. _Only returned for modified, verified playlists, otherwise_ \`null\`.
`,
    },
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `Known external URLs for this playlist.
`,
    },
    href: {
      type: 'string',
      description: `A link to the Web API endpoint providing full details of the playlist.
`,
    },
    id: {
      type: 'string',
      description: `The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the playlist.
`,
    },
    images: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ImageObject',
      },
      description: `Images for the playlist. The array may be empty or contain up to three images. The images are returned by size in descending order. See [Working with Playlists](/documentation/web-api/concepts/playlists). _**Note**: If returned, the source URL for the image (\`url\`) is temporary and will expire in less than a day._
`,
    },
    name: {
      type: 'string',
      description: `The name of the playlist.
`,
    },
    owner: {
      allOf: [
        {
          $ref: '#/components/schemas/PlaylistOwnerObject',
        },
      ],
      description: `The user who owns the playlist
`,
    },
    public: {
      type: 'boolean',
      description: `The playlist's public/private status (if it is added to the user's profile): \`true\` the playlist is public, \`false\` the playlist is private, \`null\` the playlist status is not relevant. For more about public/private status, see [Working with Playlists](/documentation/web-api/concepts/playlists)
`,
    },
    snapshot_id: {
      type: 'string',
      description: `The version identifier for the current playlist. Can be supplied in other requests to target a specific playlist version
`,
    },
    tracks: {
      allOf: [
        {
          $ref: '#/components/schemas/PlaylistTracksRefObject',
        },
      ],
      description: `A collection containing a link ( \`href\` ) to the Web API endpoint where full details of the playlist's tracks can be retrieved, along with the \`total\` number of tracks in the playlist. Note, a track object may be \`null\`. This can happen if a track is no longer available.
`,
    },
    type: {
      type: 'string',
      description: `The object type: "playlist"
`,
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the playlist.
`,
    },
  },
} as const;

export const PlaylistTracksRefObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PlaylistTracksRefObject',
  properties: {
    href: {
      type: 'string',
      description: `A link to the Web API endpoint where full details of the playlist's tracks can be retrieved.
`,
    },
    total: {
      type: 'integer',
      description: `Number of tracks in the playlist.
`,
    },
  },
} as const;

export const PlaylistUserObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'PlaylistUserObject',
  properties: {
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `Known public external URLs for this user.
`,
    },
    followers: {
      allOf: [
        {
          $ref: '#/components/schemas/FollowersObject',
        },
      ],
      description: `Information about the followers of this user.
`,
    },
    href: {
      type: 'string',
      description: `A link to the Web API endpoint for this user.
`,
    },
    id: {
      type: 'string',
      description: `The [Spotify user ID](/documentation/web-api/concepts/spotify-uris-ids) for this user.
`,
    },
    type: {
      type: 'string',
      enum: ['user'],
      description: `The object type.
`,
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for this user.
`,
    },
  },
} as const;

export const PlaylistOwnerObjectSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/PlaylistUserObject',
    },
    {
      type: 'object',
      properties: {
        display_name: {
          type: 'string',
          nullable: true,
          description: `The name displayed on the user's profile. \`null\` if not available.
`,
        },
      },
    },
  ],
} as const;

export const CategoryObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'CategoryObject',
  required: ['href', 'icons', 'id', 'name'],
  properties: {
    href: {
      type: 'string',
      description: `A link to the Web API endpoint returning full details of the category.
`,
    },
    icons: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ImageObject',
      },
      description: `The category icon, in various sizes.
`,
    },
    id: {
      type: 'string',
      example: 'equal',
      description: `The [Spotify category ID](/documentation/web-api/concepts/spotify-uris-ids) of the category.
`,
    },
    name: {
      type: 'string',
      example: 'EQUAL',
      description: `The name of the category.
`,
    },
  },
} as const;

export const TrackObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'TrackObject',
  properties: {
    album: {
      allOf: [
        {
          $ref: '#/components/schemas/SimplifiedAlbumObject',
        },
      ],
      description: `The album on which the track appears. The album object includes a link in \`href\` to full information about the album.
`,
    },
    artists: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SimplifiedArtistObject',
      },
      description: `The artists who performed the track. Each artist object includes a link in \`href\` to more detailed information about the artist.
`,
    },
    available_markets: {
      type: 'array',
      items: {
        type: 'string',
      },
      description: `A list of the countries in which the track can be played, identified by their [ISO 3166-1 alpha-2](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code.
`,
    },
    disc_number: {
      type: 'integer',
      description: `The disc number (usually \`1\` unless the album consists of more than one disc).
`,
    },
    duration_ms: {
      type: 'integer',
      description: `The track length in milliseconds.
`,
    },
    explicit: {
      type: 'boolean',
      description: `Whether or not the track has explicit lyrics ( \`true\` = yes it does; \`false\` = no it does not OR unknown).
`,
    },
    external_ids: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalIdObject',
        },
      ],
      description: `Known external IDs for the track.
`,
    },
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `Known external URLs for this track.
`,
    },
    href: {
      type: 'string',
      description: `A link to the Web API endpoint providing full details of the track.
`,
    },
    id: {
      type: 'string',
      description: `The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the track.
`,
    },
    is_playable: {
      type: 'boolean',
      description: `Part of the response when [Track Relinking](/documentation/web-api/concepts/track-relinking) is applied. If \`true\`, the track is playable in the given market. Otherwise \`false\`.
`,
    },
    linked_from: {
      type: 'object',
      description: `Part of the response when [Track Relinking](/documentation/web-api/concepts/track-relinking) is applied, and the requested track has been replaced with different track. The track in the \`linked_from\` object contains information about the originally requested track.
`,
    },
    restrictions: {
      allOf: [
        {
          $ref: '#/components/schemas/TrackRestrictionObject',
        },
      ],
      description: `Included in the response when a content restriction is applied.
`,
    },
    name: {
      type: 'string',
      description: `The name of the track.
`,
    },
    popularity: {
      type: 'integer',
      description: `The popularity of the track. The value will be between 0 and 100, with 100 being the most popular.<br/>The popularity of a track is a value between 0 and 100, with 100 being the most popular. The popularity is calculated by algorithm and is based, in the most part, on the total number of plays the track has had and how recent those plays are.<br/>Generally speaking, songs that are being played a lot now will have a higher popularity than songs that were played a lot in the past. Duplicate tracks (e.g. the same track from a single and an album) are rated independently. Artist and album popularity is derived mathematically from track popularity. _**Note**: the popularity value may lag actual popularity by a few days: the value is not updated in real time._
`,
    },
    preview_url: {
      type: 'string',
      nullable: true,
      description: `A link to a 30 second preview (MP3 format) of the track. Can be \`null\`
`,
      'x-spotify-policy-list': [
        {
          $ref: '#/components/x-spotify-policy/policies/StandalonePreview',
        },
      ],
    },
    track_number: {
      type: 'integer',
      description: `The number of the track. If an album has several discs, the track number is the number on the specified disc.
`,
    },
    type: {
      type: 'string',
      description: `The object type: "track".
`,
      enum: ['track'],
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the track.
`,
    },
    is_local: {
      type: 'boolean',
      description: `Whether or not the track is from a local file.
`,
    },
  },
} as const;

export const EpisodeObjectSchema = {
  'x-spotify-docs-type': 'EpisodeObject',
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/EpisodeBase',
    },
    {
      type: 'object',
      required: ['show'],
      properties: {
        show: {
          allOf: [
            {
              $ref: '#/components/schemas/SimplifiedShowObject',
            },
          ],
          description: `The show on which the episode belongs.
`,
        },
      },
    },
  ],
} as const;

export const SimplifiedEpisodeObjectSchema = {
  'x-spotify-docs-type': 'SimplifiedEpisodeObject',
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/EpisodeBase',
    },
    {
      type: 'object',
    },
  ],
} as const;

export const EpisodeBaseSchema = {
  type: 'object',
  required: [
    'audio_preview_url',
    'description',
    'html_description',
    'duration_ms',
    'explicit',
    'external_urls',
    'href',
    'id',
    'images',
    'is_externally_hosted',
    'is_playable',
    'languages',
    'name',
    'release_date',
    'release_date_precision',
    'type',
    'uri',
  ],
  properties: {
    audio_preview_url: {
      type: 'string',
      nullable: true,
      example: 'https://p.scdn.co/mp3-preview/2f37da1d4221f40b9d1a98cd191f4d6f1646ad17',
      description: `A URL to a 30 second preview (MP3 format) of the episode. \`null\` if not available.
`,
      'x-spotify-policy-list': [
        {
          $ref: '#/components/x-spotify-policy/policies/StandalonePreview',
        },
      ],
    },
    description: {
      type: 'string',
      example: `A Spotify podcast sharing fresh insights on important topics of the moment—in a way only Spotify can. You’ll hear from experts in the music, podcast and tech industries as we discover and uncover stories about our work and the world around us.
`,
      description: `A description of the episode. HTML tags are stripped away from this field, use \`html_description\` field in case HTML tags are needed.
`,
    },
    html_description: {
      type: 'string',
      example: `<p>A Spotify podcast sharing fresh insights on important topics of the moment—in a way only Spotify can. You’ll hear from experts in the music, podcast and tech industries as we discover and uncover stories about our work and the world around us.</p>
`,
      description: `A description of the episode. This field may contain HTML tags.
`,
    },
    duration_ms: {
      type: 'integer',
      example: 1686230,
      description: `The episode length in milliseconds.
`,
    },
    explicit: {
      type: 'boolean',
      description: `Whether or not the episode has explicit content (true = yes it does; false = no it does not OR unknown).
`,
    },
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `External URLs for this episode.
`,
    },
    href: {
      type: 'string',
      example: 'https://api.spotify.com/v1/episodes/5Xt5DXGzch68nYYamXrNxZ',
      description: `A link to the Web API endpoint providing full details of the episode.
`,
    },
    id: {
      type: 'string',
      example: '5Xt5DXGzch68nYYamXrNxZ',
      description: `The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the episode.
`,
    },
    images: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ImageObject',
      },
      description: `The cover art for the episode in various sizes, widest first.
`,
    },
    is_externally_hosted: {
      type: 'boolean',
      description: `True if the episode is hosted outside of Spotify's CDN.
`,
    },
    is_playable: {
      type: 'boolean',
      description: `True if the episode is playable in the given market. Otherwise false.
`,
    },
    language: {
      type: 'string',
      deprecated: true,
      example: 'en',
      description: `The language used in the episode, identified by a [ISO 639](https://en.wikipedia.org/wiki/ISO_639) code. This field is deprecated and might be removed in the future. Please use the \`languages\` field instead.
`,
    },
    languages: {
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['fr', 'en'],
      description: `A list of the languages used in the episode, identified by their [ISO 639-1](https://en.wikipedia.org/wiki/ISO_639) code.
`,
    },
    name: {
      type: 'string',
      example: `Starting Your Own Podcast: Tips, Tricks, and Advice From Anchor Creators
`,
      description: `The name of the episode.
`,
    },
    release_date: {
      type: 'string',
      example: '1981-12-15',
      description: `The date the episode was first released, for example \`"1981-12-15"\`. Depending on the precision, it might be shown as \`"1981"\` or \`"1981-12"\`.
`,
    },
    release_date_precision: {
      type: 'string',
      example: 'day',
      enum: ['year', 'month', 'day'],
      description: `The precision with which \`release_date\` value is known.
`,
    },
    resume_point: {
      allOf: [
        {
          $ref: '#/components/schemas/ResumePointObject',
        },
      ],
      description: `The user's most recent position in the episode. Set if the supplied access token is a user token and has the scope 'user-read-playback-position'.
`,
    },
    type: {
      type: 'string',
      enum: ['episode'],
      description: `The object type.
`,
    },
    uri: {
      type: 'string',
      example: 'spotify:episode:0zLhl3WsOCQHbe1BPTiHgr',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the episode.
`,
    },
    restrictions: {
      allOf: [
        {
          $ref: '#/components/schemas/EpisodeRestrictionObject',
        },
      ],
      description: `Included in the response when a content restriction is applied.
`,
    },
  },
} as const;

export const ResumePointObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'ResumePointObject',
  properties: {
    fully_played: {
      type: 'boolean',
      description: `Whether or not the episode has been fully played by the user.
`,
    },
    resume_position_ms: {
      type: 'integer',
      description: `The user's most recent position in the episode in milliseconds.
`,
    },
  },
} as const;

export const ShowBaseSchema = {
  type: 'object',
  required: [
    'available_markets',
    'copyrights',
    'description',
    'explicit',
    'external_urls',
    'href',
    'html_description',
    'id',
    'images',
    'is_externally_hosted',
    'languages',
    'media_type',
    'name',
    'publisher',
    'total_episodes',
    'type',
    'uri',
  ],
  properties: {
    available_markets: {
      type: 'array',
      items: {
        type: 'string',
      },
      description: `A list of the countries in which the show can be played, identified by their [ISO 3166-1 alpha-2](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code.
`,
    },
    copyrights: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CopyrightObject',
      },
      description: `The copyright statements of the show.
`,
    },
    description: {
      type: 'string',
      description: `A description of the show. HTML tags are stripped away from this field, use \`html_description\` field in case HTML tags are needed.
`,
    },
    html_description: {
      type: 'string',
      description: `A description of the show. This field may contain HTML tags.
`,
    },
    explicit: {
      type: 'boolean',
      description: `Whether or not the show has explicit content (true = yes it does; false = no it does not OR unknown).
`,
    },
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `External URLs for this show.
`,
    },
    href: {
      type: 'string',
      description: `A link to the Web API endpoint providing full details of the show.
`,
    },
    id: {
      type: 'string',
      description: `The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the show.
`,
    },
    images: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ImageObject',
      },
      description: `The cover art for the show in various sizes, widest first.
`,
    },
    is_externally_hosted: {
      type: 'boolean',
      description: `True if all of the shows episodes are hosted outside of Spotify's CDN. This field might be \`null\` in some cases.
`,
    },
    languages: {
      type: 'array',
      items: {
        type: 'string',
      },
      description: `A list of the languages used in the show, identified by their [ISO 639](https://en.wikipedia.org/wiki/ISO_639) code.
`,
    },
    media_type: {
      type: 'string',
      description: `The media type of the show.
`,
    },
    name: {
      type: 'string',
      description: `The name of the episode.
`,
    },
    publisher: {
      type: 'string',
      description: `The publisher of the show.
`,
    },
    type: {
      type: 'string',
      enum: ['show'],
      description: `The object type.
`,
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the show.
`,
    },
    total_episodes: {
      type: 'integer',
      description: `The total number of episodes in the show.
`,
    },
  },
} as const;

export const ShowObjectSchema = {
  'x-spotify-docs-type': 'ShowObject',
  allOf: [
    {
      $ref: '#/components/schemas/ShowBase',
    },
    {
      type: 'object',
      required: ['episodes'],
      properties: {
        episodes: {
          type: 'object',
          allOf: [
            {
              $ref: '#/components/schemas/PagingSimplifiedEpisodeObject',
            },
          ],
          description: `The episodes of the show.
`,
        },
      },
    },
  ],
} as const;

export const SimplifiedShowObjectSchema = {
  'x-spotify-docs-type': 'SimplifiedShowObject',
  allOf: [
    {
      $ref: '#/components/schemas/ShowBase',
    },
    {
      type: 'object',
    },
  ],
} as const;

export const AudiobookBaseSchema = {
  type: 'object',
  required: [
    'authors',
    'available_markets',
    'copyrights',
    'description',
    'explicit',
    'external_urls',
    'href',
    'html_description',
    'id',
    'images',
    'languages',
    'media_type',
    'name',
    'narrators',
    'publisher',
    'total_chapters',
    'type',
    'uri',
  ],
  properties: {
    authors: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AuthorObject',
      },
      description: `The author(s) for the audiobook.
`,
    },
    available_markets: {
      type: 'array',
      items: {
        type: 'string',
      },
      description: `A list of the countries in which the audiobook can be played, identified by their [ISO 3166-1 alpha-2](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code.
`,
    },
    copyrights: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CopyrightObject',
      },
      description: `The copyright statements of the audiobook.
`,
    },
    description: {
      type: 'string',
      description: `A description of the audiobook. HTML tags are stripped away from this field, use \`html_description\` field in case HTML tags are needed.
`,
    },
    html_description: {
      type: 'string',
      description: `A description of the audiobook. This field may contain HTML tags.
`,
    },
    edition: {
      type: 'string',
      description: `The edition of the audiobook.
`,
      example: 'Unabridged',
    },
    explicit: {
      type: 'boolean',
      description: `Whether or not the audiobook has explicit content (true = yes it does; false = no it does not OR unknown).
`,
    },
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `External URLs for this audiobook.
`,
    },
    href: {
      type: 'string',
      description: `A link to the Web API endpoint providing full details of the audiobook.
`,
    },
    id: {
      type: 'string',
      description: `The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the audiobook.
`,
    },
    images: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ImageObject',
      },
      description: `The cover art for the audiobook in various sizes, widest first.
`,
    },
    languages: {
      type: 'array',
      items: {
        type: 'string',
      },
      description: `A list of the languages used in the audiobook, identified by their [ISO 639](https://en.wikipedia.org/wiki/ISO_639) code.
`,
    },
    media_type: {
      type: 'string',
      description: `The media type of the audiobook.
`,
    },
    name: {
      type: 'string',
      description: `The name of the audiobook.
`,
    },
    narrators: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/NarratorObject',
      },
      description: `The narrator(s) for the audiobook.
`,
    },
    publisher: {
      type: 'string',
      description: `The publisher of the audiobook.
`,
    },
    type: {
      type: 'string',
      enum: ['audiobook'],
      description: `The object type.
`,
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the audiobook.
`,
    },
    total_chapters: {
      type: 'integer',
      description: `The number of chapters in this audiobook.
`,
    },
  },
} as const;

export const AudiobookObjectSchema = {
  'x-spotify-docs-type': 'AudiobookObject',
  allOf: [
    {
      $ref: '#/components/schemas/AudiobookBase',
    },
    {
      type: 'object',
      required: ['chapters'],
      properties: {
        chapters: {
          type: 'object',
          allOf: [
            {
              $ref: '#/components/schemas/PagingSimplifiedChapterObject',
            },
          ],
          description: `The chapters of the audiobook.
`,
        },
      },
    },
  ],
} as const;

export const SimplifiedAudiobookObjectSchema = {
  'x-spotify-docs-type': 'SimplifiedAudiobookObject',
  allOf: [
    {
      $ref: '#/components/schemas/AudiobookBase',
    },
    {
      type: 'object',
    },
  ],
} as const;

export const AlbumBaseSchema = {
  type: 'object',
  required: [
    'album_type',
    'total_tracks',
    'available_markets',
    'external_urls',
    'href',
    'id',
    'images',
    'name',
    'release_date',
    'release_date_precision',
    'type',
    'uri',
  ],
  properties: {
    album_type: {
      type: 'string',
      description: `The type of the album.
`,
      enum: ['album', 'single', 'compilation'],
      example: 'compilation',
    },
    total_tracks: {
      type: 'integer',
      description: 'The number of tracks in the album.',
      example: 9,
    },
    available_markets: {
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['CA', 'BR', 'IT'],
      description: `The markets in which the album is available: [ISO 3166-1 alpha-2 country codes](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). _**NOTE**: an album is considered available in a market when at least 1 of its tracks is available in that market._
`,
    },
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `Known external URLs for this album.
`,
    },
    href: {
      type: 'string',
      description: `A link to the Web API endpoint providing full details of the album.
`,
    },
    id: {
      type: 'string',
      description: `The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the album.
`,
      example: '2up3OPMp9Tb4dAKM2erWXQ',
    },
    images: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ImageObject',
      },
      description: `The cover art for the album in various sizes, widest first.
`,
    },
    name: {
      type: 'string',
      description: `The name of the album. In case of an album takedown, the value may be an empty string.
`,
    },
    release_date: {
      type: 'string',
      example: '1981-12',
      description: `The date the album was first released.
`,
    },
    release_date_precision: {
      type: 'string',
      enum: ['year', 'month', 'day'],
      example: 'year',
      description: `The precision with which \`release_date\` value is known.
`,
    },
    restrictions: {
      allOf: [
        {
          $ref: '#/components/schemas/AlbumRestrictionObject',
        },
      ],
      description: `Included in the response when a content restriction is applied.
`,
    },
    type: {
      type: 'string',
      enum: ['album'],
      description: `The object type.
`,
    },
    uri: {
      type: 'string',
      example: 'spotify:album:2up3OPMp9Tb4dAKM2erWXQ',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the album.
`,
    },
  },
} as const;

export const SimplifiedAlbumObjectSchema = {
  'x-spotify-docs-type': 'SimplifiedAlbumObject',
  allOf: [
    {
      $ref: '#/components/schemas/AlbumBase',
    },
    {
      type: 'object',
      required: ['artists'],
      properties: {
        artists: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SimplifiedArtistObject',
          },
          description: `The artists of the album. Each artist object includes a link in \`href\` to more detailed information about the artist.
`,
        },
      },
    },
  ],
} as const;

export const ArtistDiscographyAlbumObjectSchema = {
  'x-spotify-docs-type': 'ArtistDiscographyAlbumObject',
  allOf: [
    {
      $ref: '#/components/schemas/SimplifiedAlbumObject',
    },
    {
      type: 'object',
      required: ['album_group'],
      properties: {
        album_group: {
          type: 'string',
          enum: ['album', 'single', 'compilation', 'appears_on'],
          example: 'compilation',
          description: `This field describes the relationship between the artist and the album.
`,
        },
      },
    },
  ],
} as const;

export const ChapterObjectSchema = {
  'x-spotify-docs-type': 'ChapterObject',
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/ChapterBase',
    },
    {
      type: 'object',
      required: ['audiobook'],
      properties: {
        audiobook: {
          allOf: [
            {
              $ref: '#/components/schemas/SimplifiedAudiobookObject',
            },
          ],
          description: `The audiobook for which the chapter belongs.
`,
        },
      },
    },
  ],
} as const;

export const SimplifiedChapterObjectSchema = {
  'x-spotify-docs-type': 'SimplifiedChapterObject',
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/ChapterBase',
    },
    {
      type: 'object',
    },
  ],
} as const;

export const ChapterBaseSchema = {
  type: 'object',
  required: [
    'audio_preview_url',
    'chapter_number',
    'description',
    'html_description',
    'duration_ms',
    'explicit',
    'external_urls',
    'href',
    'id',
    'images',
    'is_playable',
    'languages',
    'name',
    'release_date',
    'release_date_precision',
    'type',
    'uri',
  ],
  properties: {
    audio_preview_url: {
      type: 'string',
      nullable: true,
      example: 'https://p.scdn.co/mp3-preview/2f37da1d4221f40b9d1a98cd191f4d6f1646ad17',
      description: `A URL to a 30 second preview (MP3 format) of the chapter. \`null\` if not available.
`,
      'x-spotify-policy-list': [
        {
          $ref: '#/components/x-spotify-policy/policies/StandalonePreview',
        },
      ],
    },
    available_markets: {
      type: 'array',
      items: {
        type: 'string',
      },
      description: `A list of the countries in which the chapter can be played, identified by their [ISO 3166-1 alpha-2](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code.
`,
    },
    chapter_number: {
      type: 'integer',
      example: 1,
      description: `The number of the chapter
`,
    },
    description: {
      type: 'string',
      example: `We kept on ascending, with occasional periods of quick descent, but in the main always ascending. Suddenly, I became conscious of the fact that the driver was in the act of pulling up the horses in the courtyard of a vast ruined castle, from whose tall black windows came no ray of light, and whose broken battlements showed a jagged line against the moonlit sky.
`,
      description: `A description of the chapter. HTML tags are stripped away from this field, use \`html_description\` field in case HTML tags are needed.
`,
    },
    html_description: {
      type: 'string',
      example: `<p>We kept on ascending, with occasional periods of quick descent, but in the main always ascending. Suddenly, I became conscious of the fact that the driver was in the act of pulling up the horses in the courtyard of a vast ruined castle, from whose tall black windows came no ray of light, and whose broken battlements showed a jagged line against the moonlit sky.</p>
`,
      description: `A description of the chapter. This field may contain HTML tags.
`,
    },
    duration_ms: {
      type: 'integer',
      example: 1686230,
      description: `The chapter length in milliseconds.
`,
    },
    explicit: {
      type: 'boolean',
      description: `Whether or not the chapter has explicit content (true = yes it does; false = no it does not OR unknown).
`,
    },
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: `External URLs for this chapter.
`,
    },
    href: {
      type: 'string',
      example: 'https://api.spotify.com/v1/episodes/5Xt5DXGzch68nYYamXrNxZ',
      description: `A link to the Web API endpoint providing full details of the chapter.
`,
    },
    id: {
      type: 'string',
      example: '5Xt5DXGzch68nYYamXrNxZ',
      description: `The [Spotify ID](/documentation/web-api/concepts/spotify-uris-ids) for the chapter.
`,
    },
    images: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ImageObject',
      },
      description: `The cover art for the chapter in various sizes, widest first.
`,
    },
    is_playable: {
      type: 'boolean',
      description: `True if the chapter is playable in the given market. Otherwise false.
`,
    },
    languages: {
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['fr', 'en'],
      description: `A list of the languages used in the chapter, identified by their [ISO 639-1](https://en.wikipedia.org/wiki/ISO_639) code.
`,
    },
    name: {
      type: 'string',
      example: `Starting Your Own Podcast: Tips, Tricks, and Advice From Anchor Creators
`,
      description: `The name of the chapter.
`,
    },
    release_date: {
      type: 'string',
      example: '1981-12-15',
      description: `The date the chapter was first released, for example \`"1981-12-15"\`. Depending on the precision, it might be shown as \`"1981"\` or \`"1981-12"\`.
`,
    },
    release_date_precision: {
      type: 'string',
      example: 'day',
      enum: ['year', 'month', 'day'],
      description: `The precision with which \`release_date\` value is known.
`,
    },
    resume_point: {
      allOf: [
        {
          $ref: '#/components/schemas/ResumePointObject',
        },
      ],
      description: `The user's most recent position in the chapter. Set if the supplied access token is a user token and has the scope 'user-read-playback-position'.
`,
    },
    type: {
      type: 'string',
      enum: ['episode'],
      description: `The object type.
`,
    },
    uri: {
      type: 'string',
      example: 'spotify:episode:0zLhl3WsOCQHbe1BPTiHgr',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the chapter.
`,
    },
    restrictions: {
      allOf: [
        {
          $ref: '#/components/schemas/ChapterRestrictionObject',
        },
      ],
      description: `Included in the response when a content restriction is applied.
`,
    },
  },
} as const;

export const AlbumObjectSchema = {
  'x-spotify-docs-type': 'AlbumObject',
  required: ['artists', 'tracks', 'copyrights', 'external_ids', 'genres', 'label', 'popularity'],
  allOf: [
    {
      $ref: '#/components/schemas/AlbumBase',
    },
    {
      type: 'object',
      properties: {
        artists: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/SimplifiedArtistObject',
          },
          description: `The artists of the album. Each artist object includes a link in \`href\` to more detailed information about the artist.
`,
        },
        tracks: {
          allOf: [
            {
              $ref: '#/components/schemas/PagingSimplifiedTrackObject',
            },
          ],
          description: `The tracks of the album.
`,
        },
        copyrights: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/CopyrightObject',
          },
          description: `The copyright statements of the album.
`,
        },
        external_ids: {
          allOf: [
            {
              $ref: '#/components/schemas/ExternalIdObject',
            },
          ],
          description: `Known external IDs for the album.
`,
        },
        genres: {
          type: 'array',
          items: {
            type: 'string',
          },
          example: ['Egg punk', 'Noise rock'],
          description: `A list of the genres the album is associated with. If not yet classified, the array is empty.
`,
        },
        label: {
          type: 'string',
          description: `The label associated with the album.
`,
        },
        popularity: {
          type: 'integer',
          description: `The popularity of the album. The value will be between 0 and 100, with 100 being the most popular.
`,
        },
      },
    },
  ],
} as const;

export const ContextObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'ContextObject',
  properties: {
    type: {
      type: 'string',
      description: `The object type, e.g. "artist", "playlist", "album", "show".
`,
    },
    href: {
      type: 'string',
      description: 'A link to the Web API endpoint providing full details of the track.',
    },
    external_urls: {
      allOf: [
        {
          $ref: '#/components/schemas/ExternalUrlObject',
        },
      ],
      description: 'External URLs for this context.',
    },
    uri: {
      type: 'string',
      description: `The [Spotify URI](/documentation/web-api/concepts/spotify-uris-ids) for the context.
`,
    },
  },
} as const;

export const CopyrightObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'CopyrightObject',
  properties: {
    text: {
      type: 'string',
      description: `The copyright text for this content.
`,
    },
    type: {
      type: 'string',
      description: `The type of copyright: \`C\` = the copyright, \`P\` = the sound recording (performance) copyright.
`,
    },
  },
} as const;

export const AuthorObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'AuthorObject',
  properties: {
    name: {
      type: 'string',
      description: `The name of the author.
`,
    },
  },
} as const;

export const NarratorObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'NarratorObject',
  properties: {
    name: {
      type: 'string',
      description: `The name of the Narrator.
`,
    },
  },
} as const;

export const ExternalIdObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'ExternalIdObject',
  properties: {
    isrc: {
      type: 'string',
      description: `[International Standard Recording Code](http://en.wikipedia.org/wiki/International_Standard_Recording_Code)
`,
    },
    ean: {
      type: 'string',
      description: `[International Article Number](http://en.wikipedia.org/wiki/International_Article_Number_%28EAN%29)
`,
    },
    upc: {
      type: 'string',
      description: `[Universal Product Code](http://en.wikipedia.org/wiki/Universal_Product_Code)
`,
    },
  },
} as const;

export const ExternalUrlObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'ExternalUrlObject',
  properties: {
    spotify: {
      type: 'string',
      description: `The [Spotify URL](/documentation/web-api/concepts/spotify-uris-ids) for the object.
`,
    },
  },
} as const;

export const FollowersObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'FollowersObject',
  properties: {
    href: {
      type: 'string',
      nullable: true,
      description: `This will always be set to null, as the Web API does not support it at the moment.
`,
    },
    total: {
      type: 'integer',
      description: `The total number of followers.
`,
    },
  },
} as const;

export const ImageObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'ImageObject',
  required: ['url', 'height', 'width'],
  properties: {
    url: {
      type: 'string',
      example: `https://i.scdn.co/image/ab67616d00001e02ff9ca10b55ce82ae553c8228
`,
      description: `The source URL of the image.
`,
    },
    height: {
      type: 'integer',
      example: 300,
      nullable: true,
      description: `The image height in pixels.
`,
    },
    width: {
      type: 'integer',
      example: 300,
      nullable: true,
      description: `The image width in pixels.
`,
    },
  },
} as const;

export const ExplicitContentSettingsObjectSchema = {
  type: 'object',
  'x-spotify-docs-type': 'ExplicitContentSettingsObject',
  properties: {
    filter_enabled: {
      type: 'boolean',
      description: `When \`true\`, indicates that explicit content should not be played.
`,
    },
    filter_locked: {
      type: 'boolean',
      description: `When \`true\`, indicates that the explicit content setting is locked and can't be changed by the user.
`,
    },
  },
} as const;
