// Generated by ts-to-zod
import { z } from 'zod';

export const blocksSchema = z.array(
  z.record(z.union([z.unknown(), z.string()])).and(
    z.object({
      type: z.string(),
    }),
  ),
);

export const defsAppIdSchema = z.string();

export const defsBotIdSchema = z.string();

export const defsChannelSchema = z.string();

export const defsChannelIdSchema = z.string();

export const defsChannelNameSchema = z.string();

export const defsCommentIdSchema = z.string();

export const defsDmIdSchema = z.string();

export const defsEnterpriseIdSchema = z.string();

export const defsEnterpriseNameSchema = z.string();

export const defsEnterpriseUserIdSchema = z.string();

export const defsFileIdSchema = z.string();

export const defsGroupIdSchema = z.string();

export const defsOkFalseSchema = z.boolean();

export const defsOkTrueSchema = z.boolean();

export const defsOptionalAppIdSchema = z.string();

export const defsPinnedInfoSchema = z.record(z.unknown());

export const defsReminderIdSchema = z.string();

export const defsSubteamIdSchema = z.string();

export const defsTeamSchema = z.string();

export const defsTopicPurposeCreatorSchema = z.string();

export const defsTsSchema = z.string();

export const defsUserIdSchema = z.string();

export const defsWorkspaceIdSchema = z.string();

export const objsBotProfileSchema = z.object({
  app_id: defsAppIdSchema,
  deleted: z.boolean(),
  icons: z.object({
    image_36: z.string(),
    image_48: z.string(),
    image_72: z.string(),
  }),
  id: defsBotIdSchema,
  name: z.string(),
  team_id: defsTeamSchema,
  updated: z.number(),
});

export const objsChannelSchema = z.object({
  accepted_user: defsUserIdSchema.optional(),
  created: z.number(),
  creator: defsUserIdSchema,
  id: defsChannelIdSchema,
  is_archived: z.boolean().optional(),
  is_channel: z.boolean(),
  is_frozen: z.boolean().optional(),
  is_general: z.boolean().optional(),
  is_member: z.boolean().optional(),
  is_moved: z.number().optional(),
  is_mpim: z.boolean(),
  is_non_threadable: z.boolean().optional(),
  is_org_shared: z.boolean(),
  is_pending_ext_shared: z.boolean().optional(),
  is_private: z.boolean(),
  is_read_only: z.boolean().optional(),
  is_shared: z.boolean(),
  is_thread_only: z.boolean().optional(),
  last_read: defsTsSchema.optional(),
  latest: z.unknown().optional(),
  members: z.array(defsUserIdSchema),
  name: z.string(),
  name_normalized: z.string(),
  num_members: z.number().optional(),
  pending_shared: z.array(defsTeamSchema).optional(),
  previous_names: z.array(defsChannelNameSchema).optional(),
  priority: z.number().optional(),
  purpose: z.object({
    creator: defsTopicPurposeCreatorSchema,
    last_set: z.number(),
    value: z.string(),
  }),
  topic: z.object({
    creator: defsTopicPurposeCreatorSchema,
    last_set: z.number(),
    value: z.string(),
  }),
  unlinked: z.number().optional(),
  unread_count: z.number().optional(),
  unread_count_display: z.number().optional(),
});

export const objsReactionSchema = z.record(z.union([z.unknown(), z.number(), z.string(), defsUserIdSchema])).and(
  z.object({
    count: z.number(),
    name: z.string(),
    users: z.array(defsUserIdSchema),
  }),
);

export const objsCommentsSchema = z.array(z.unknown());

export const objsConversationSchema = z.unknown();

export const objsEnterpriseUserSchema = z.object({
  enterprise_id: defsEnterpriseIdSchema,
  enterprise_name: defsEnterpriseNameSchema,
  id: defsEnterpriseUserIdSchema,
  is_admin: z.boolean(),
  is_owner: z.boolean(),
  teams: z.array(defsTeamSchema),
});

export const objsExternalOrgMigrationsSchema = z.object({
  current: z.array(
    z.object({
      date_started: z.number(),
      team_id: z.string(),
    }),
  ),
  date_updated: z.number(),
});

export const objsFileSchema = z.object({
  channels: z.array(defsChannelIdSchema).optional(),
  comments_count: z.number().optional(),
  created: z.number().optional(),
  date_delete: z.number().optional(),
  display_as_bot: z.boolean().optional(),
  editable: z.boolean().optional(),
  editor: defsUserIdSchema.optional(),
  external_id: z.string().optional(),
  external_type: z.string().optional(),
  external_url: z.string().optional(),
  filetype: z.string().optional(),
  groups: z.array(defsGroupIdSchema).optional(),
  has_rich_preview: z.boolean().optional(),
  id: defsFileIdSchema.optional(),
  image_exif_rotation: z.number().optional(),
  ims: z.array(defsDmIdSchema).optional(),
  is_external: z.boolean().optional(),
  is_public: z.boolean().optional(),
  is_starred: z.boolean().optional(),
  is_tombstoned: z.boolean().optional(),
  last_editor: defsUserIdSchema.optional(),
  mimetype: z.string().optional(),
  mode: z.string().optional(),
  name: z.string().optional(),
  non_owner_editable: z.boolean().optional(),
  num_stars: z.number().optional(),
  original_h: z.number().optional(),
  original_w: z.number().optional(),
  permalink: z.string().optional(),
  permalink_public: z.string().optional(),
  pinned_info: defsPinnedInfoSchema.optional(),
  pinned_to: z.array(defsChannelSchema).optional(),
  pretty_type: z.string().optional(),
  preview: z.string().optional(),
  public_url_shared: z.boolean().optional(),
  reactions: z.array(objsReactionSchema).optional(),
  shares: z
    .object({
      private: z.unknown().optional(),
      public: z.unknown().optional(),
    })
    .optional(),
  size: z.number().optional(),
  source_team: defsTeamSchema.optional(),
  state: z.string().optional(),
  thumb_1024: z.string().optional(),
  thumb_1024_h: z.number().optional(),
  thumb_1024_w: z.number().optional(),
  thumb_160: z.string().optional(),
  thumb_360: z.string().optional(),
  thumb_360_h: z.number().optional(),
  thumb_360_w: z.number().optional(),
  thumb_480: z.string().optional(),
  thumb_480_h: z.number().optional(),
  thumb_480_w: z.number().optional(),
  thumb_64: z.string().optional(),
  thumb_720: z.string().optional(),
  thumb_720_h: z.number().optional(),
  thumb_720_w: z.number().optional(),
  thumb_80: z.string().optional(),
  thumb_800: z.string().optional(),
  thumb_800_h: z.number().optional(),
  thumb_800_w: z.number().optional(),
  thumb_960: z.string().optional(),
  thumb_960_h: z.number().optional(),
  thumb_960_w: z.number().optional(),
  thumb_tiny: z.string().optional(),
  timestamp: z.number().optional(),
  title: z.string().optional(),
  updated: z.number().optional(),
  url_private: z.string().optional(),
  url_private_download: z.string().optional(),
  user: z.string().optional(),
  user_team: defsTeamSchema.optional(),
  username: z.string().optional(),
});

export const objsIconSchema = z.object({
  image_102: z.string().optional(),
  image_132: z.string().optional(),
  image_230: z.string().optional(),
  image_34: z.string().optional(),
  image_44: z.string().optional(),
  image_68: z.string().optional(),
  image_88: z.string().optional(),
  image_default: z.boolean().optional(),
});

export const objsCommentSchema = z.object({
  comment: z.string(),
  created: z.number(),
  id: defsCommentIdSchema,
  is_intro: z.boolean(),
  is_starred: z.boolean().optional(),
  num_stars: z.number().optional(),
  pinned_info: defsPinnedInfoSchema.optional(),
  pinned_to: z.array(defsChannelSchema).optional(),
  reactions: z.array(objsReactionSchema).optional(),
  timestamp: z.number(),
  user: defsUserIdSchema,
});

export const objsUserProfileShortSchema = z.object({
  avatar_hash: z.string(),
  display_name: z.string(),
  display_name_normalized: z.string().optional(),
  first_name: z.string().nullable(),
  image_72: z.string(),
  is_restricted: z.boolean(),
  is_ultra_restricted: z.boolean(),
  name: z.string(),
  real_name: z.string(),
  real_name_normalized: z.string().optional(),
  team: defsWorkspaceIdSchema,
});

export const objsPagingSchema = z.object({
  count: z.number().optional(),
  page: z.number(),
  pages: z.number().optional(),
  per_page: z.number().optional(),
  spill: z.number().optional(),
  total: z.number(),
});

export const objsPrimaryOwnerSchema = z.object({
  email: z.string(),
  id: z.string(),
});

export const objsReminderSchema = z.object({
  complete_ts: z.number().optional(),
  creator: defsUserIdSchema,
  id: defsReminderIdSchema,
  recurring: z.boolean(),
  text: z.string(),
  time: z.number().optional(),
  user: defsUserIdSchema,
});

export const objsResourcesSchema = z.object({
  excluded_ids: z.array(z.unknown()).optional(),
  ids: z.array(z.unknown()),
  wildcard: z.boolean().optional(),
});

export const objsResponseMetadataSchema = z.unknown();

export const objsScopesSchema = z.array(z.string());

export const objsSubteamSchema = z.object({
  auto_provision: z.boolean(),
  auto_type: z.unknown(),
  channel_count: z.number().optional(),
  created_by: defsUserIdSchema,
  date_create: z.number(),
  date_delete: z.number(),
  date_update: z.number(),
  deleted_by: z.unknown(),
  description: z.string(),
  enterprise_subteam_id: z.string(),
  handle: z.string(),
  id: defsSubteamIdSchema,
  is_external: z.boolean(),
  is_subteam: z.boolean(),
  is_usergroup: z.boolean(),
  name: z.string(),
  prefs: z.object({
    channels: z.array(defsChannelIdSchema),
    groups: z.array(defsGroupIdSchema),
  }),
  team_id: defsTeamSchema,
  updated_by: defsUserIdSchema,
  user_count: z.number().optional(),
  users: z.array(defsUserIdSchema).optional(),
});

export const objsTeamSchema = z.object({
  archived: z.boolean().optional(),
  avatar_base_url: z.string().optional(),
  created: z.number().optional(),
  date_create: z.number().optional(),
  deleted: z.boolean().optional(),
  description: z.string().optional().nullable(),
  discoverable: z.unknown().optional(),
  domain: z.string(),
  email_domain: z.string(),
  enterprise_id: defsEnterpriseIdSchema.optional(),
  enterprise_name: defsEnterpriseNameSchema.optional(),
  external_org_migrations: objsExternalOrgMigrationsSchema.optional(),
  has_compliance_export: z.boolean().optional(),
  icon: objsIconSchema,
  id: defsWorkspaceIdSchema,
  is_assigned: z.boolean().optional(),
  is_enterprise: z.number().optional(),
  is_over_storage_limit: z.boolean().optional(),
  limit_ts: z.number().optional(),
  locale: z.string().optional(),
  messages_count: z.number().optional(),
  msg_edit_window_mins: z.number().optional(),
  name: z.string(),
  over_integrations_limit: z.boolean().optional(),
  over_storage_limit: z.boolean().optional(),
  pay_prod_cur: z.string().optional(),
  plan: z
    .union([z.literal(''), z.literal('std'), z.literal('plus'), z.literal('compliance'), z.literal('enterprise')])
    .optional(),
  primary_owner: objsPrimaryOwnerSchema.optional(),
  sso_provider: z
    .object({
      label: z.string().optional(),
      name: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const planSchema = z.union([
  z.literal(''),
  z.literal('std'),
  z.literal('plus'),
  z.literal('compliance'),
  z.literal('enterprise'),
]);

export const objsTeamProfileFieldSchema = z.object({
  field_name: z.string().optional().nullable(),
  hint: z.string(),
  id: z.string(),
  is_hidden: z.boolean().optional(),
  label: z.string(),
  options: z.unknown().optional(),
  ordering: z.number(),
  possible_values: z.array(z.string()).optional().nullable(),
  type: z.union([
    z.literal('text'),
    z.literal('date'),
    z.literal('link'),
    z.literal('mailto'),
    z.literal('options_list'),
    z.literal('user'),
  ]),
});

export const typeSchema = z.union([
  z.literal('text'),
  z.literal('date'),
  z.literal('link'),
  z.literal('mailto'),
  z.literal('options_list'),
  z.literal('user'),
]);

export const objsTeamProfileFieldOptionSchema = z.object({
  is_custom: z.boolean().optional().nullable(),
  is_multiple_entry: z.boolean().optional().nullable(),
  is_protected: z.boolean().optional().nullable(),
  is_scim: z.boolean().optional().nullable(),
});

export const objsUserSchema = z.unknown();

export const objsUserProfileSchema = z.object({
  always_active: z.boolean().optional(),
  api_app_id: defsOptionalAppIdSchema.optional(),
  avatar_hash: z.string(),
  bot_id: defsBotIdSchema.optional(),
  display_name: z.string(),
  display_name_normalized: z.string(),
  email: z.string().optional().nullable(),
  fields: z.union([z.record(z.unknown()), z.array(z.unknown())]).nullable(),
  first_name: z.string().optional().nullable(),
  guest_expiration_ts: z.number().optional().nullable(),
  guest_invited_by: z.string().optional().nullable(),
  image_1024: z.string().optional().nullable(),
  image_192: z.string().optional().nullable(),
  image_24: z.string().optional().nullable(),
  image_32: z.string().optional().nullable(),
  image_48: z.string().optional().nullable(),
  image_512: z.string().optional().nullable(),
  image_72: z.string().optional().nullable(),
  image_original: z.string().optional().nullable(),
  is_app_user: z.boolean().optional(),
  is_custom_image: z.boolean().optional(),
  is_restricted: z.boolean().optional().nullable(),
  is_ultra_restricted: z.boolean().optional().nullable(),
  last_avatar_image_hash: z.string().optional(),
  last_name: z.string().optional().nullable(),
  memberships_count: z.number().optional(),
  name: z.string().optional().nullable(),
  phone: z.string(),
  pronouns: z.string().optional(),
  real_name: z.string(),
  real_name_normalized: z.string(),
  skype: z.string(),
  status_default_emoji: z.string().optional(),
  status_default_text: z.string().optional(),
  status_default_text_canonical: z.string().optional().nullable(),
  status_emoji: z.string(),
  status_expiration: z.number().optional(),
  status_text: z.string(),
  status_text_canonical: z.string().optional().nullable(),
  team: defsWorkspaceIdSchema.optional(),
  title: z.string(),
  updated: z.number().optional(),
  user_id: z.string().optional(),
  username: z.string().optional().nullable(),
});

export const adminAppsApproveDataSchema = z.object({
  body: z
    .object({
      app_id: z.string().optional(),
      request_id: z.string().optional(),
      team_id: z.string().optional(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminAppsApproveResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminAppsApproveErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminAppsApprovedListDataSchema = z.object({
  query: z.object({
    cursor: z.string().optional(),
    enterprise_id: z.string().optional(),
    limit: z.number().optional(),
    team_id: z.string().optional(),
    token: z.string(),
  }),
});

export const adminAppsApprovedListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminAppsApprovedListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminAppsRequestsListDataSchema = z.object({
  query: z.object({
    cursor: z.string().optional(),
    limit: z.number().optional(),
    team_id: z.string().optional(),
    token: z.string(),
  }),
});

export const adminAppsRequestsListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminAppsRequestsListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminAppsRestrictDataSchema = z.object({
  body: z
    .object({
      app_id: z.string().optional(),
      request_id: z.string().optional(),
      team_id: z.string().optional(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminAppsRestrictResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminAppsRestrictErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminAppsRestrictedListDataSchema = z.object({
  query: z.object({
    cursor: z.string().optional(),
    enterprise_id: z.string().optional(),
    limit: z.number().optional(),
    team_id: z.string().optional(),
    token: z.string(),
  }),
});

export const adminAppsRestrictedListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminAppsRestrictedListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminConversationsArchiveDataSchema = z.object({
  body: z.object({
    channel_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminConversationsArchiveResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const adminConversationsArchiveErrorSchema = z.object({
  error: z.union([
    z.literal('feature_not_enabled'),
    z.literal('channel_not_found'),
    z.literal('channel_type_not_supported'),
    z.literal('default_org_wide_channel'),
    z.literal('already_archived'),
    z.literal('cant_archive_general'),
    z.literal('restricted_action'),
    z.literal('could_not_archive_channel'),
  ]),
  ok: defsOkFalseSchema,
});

export const adminConversationsConvertToPrivateDataSchema = z.object({
  body: z.object({
    channel_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminConversationsConvertToPrivateResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const adminConversationsConvertToPrivateErrorSchema = z.object({
  error: z.union([
    z.literal('feature_not_enabled'),
    z.literal('restricted_action'),
    z.literal('name_taken'),
    z.literal('channel_not_found'),
    z.literal('channel_type_not_supported'),
    z.literal('default_org_wide_channel'),
    z.literal('method_not_supported_for_channel_type'),
    z.literal('could_not_convert_channel'),
    z.literal('external_channel_migrating'),
  ]),
  ok: defsOkFalseSchema,
});

export const adminConversationsCreateDataSchema = z.object({
  body: z.object({
    description: z.string().optional(),
    is_private: z.boolean(),
    name: z.string(),
    org_wide: z.boolean().optional(),
    team_id: z.string().optional(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminConversationsCreateResponseSchema = z.object({
  channel_id: defsChannelIdSchema.optional(),
  ok: defsOkTrueSchema,
});

export const adminConversationsCreateErrorSchema = z.object({
  error: z.union([
    z.literal('feature_not_enabled'),
    z.literal('name_taken'),
    z.literal('restricted_action'),
    z.literal('team_not_found'),
    z.literal('invalid_team'),
    z.literal('invalid_name'),
    z.literal('could_not_create_channel'),
    z.literal('team_id_or_org_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const adminConversationsDeleteDataSchema = z.object({
  body: z.object({
    channel_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminConversationsDeleteResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const adminConversationsDeleteErrorSchema = z.object({
  error: z.union([
    z.literal('feature_not_enabled'),
    z.literal('not_an_admin'),
    z.literal('channel_not_found'),
    z.literal('channel_type_not_supported'),
    z.literal('default_org_wide_channel'),
    z.literal('restricted_action'),
    z.literal('could_not_delete_channel'),
    z.literal('missing_scope'),
  ]),
  ok: defsOkFalseSchema,
});

export const adminConversationsDisconnectSharedDataSchema = z.object({
  body: z.object({
    channel_id: z.string(),
    leaving_team_ids: z.string().optional(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminConversationsDisconnectSharedResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const adminConversationsDisconnectSharedErrorSchema = z.object({
  error: z.union([
    z.literal('feature_not_enabled'),
    z.literal('not_an_admin'),
    z.literal('not_an_enterprise'),
    z.literal('channel_not_found'),
    z.literal('not_supported'),
    z.literal('team_not_found'),
    z.literal('restricted_action'),
    z.literal('missing_scope'),
    z.literal('leaving_team_not_in_channel'),
    z.literal('no_teams_to_disconnect'),
    z.literal('leaving_team_required'),
    z.literal('cannot_kick_team'),
    z.literal('cannot_kick_home_team'),
  ]),
  ok: defsOkFalseSchema,
});

export const adminConversationsEkmListOriginalConnectedChannelInfoDataSchema = z.object({
  query: z.object({
    channel_ids: z.string().optional(),
    cursor: z.string().optional(),
    limit: z.number().optional(),
    team_ids: z.string().optional(),
    token: z.string(),
  }),
});

export const adminConversationsEkmListOriginalConnectedChannelInfoResponseSchema = z
  .record(z.union([z.unknown(), defsOkTrueSchema]))
  .and(
    z.object({
      ok: defsOkTrueSchema,
    }),
  );

export const adminConversationsEkmListOriginalConnectedChannelInfoErrorSchema = z
  .record(z.union([z.unknown(), defsOkFalseSchema]))
  .and(
    z.object({
      ok: defsOkFalseSchema,
    }),
  );

export const adminConversationsGetConversationPrefsDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    channel_id: z.string(),
  }),
});

export const adminConversationsGetConversationPrefsResponseSchema = z.object({
  ok: defsOkTrueSchema,
  prefs: z
    .object({
      can_thread: z
        .object({
          type: z.array(z.string()).optional(),
          user: z.array(z.string()).optional(),
        })
        .optional(),
      who_can_post: z
        .object({
          type: z.array(z.string()).optional(),
          user: z.array(z.string()).optional(),
        })
        .optional(),
    })
    .optional(),
});

export const adminConversationsGetConversationPrefsErrorSchema = z.object({
  error: z.union([
    z.literal('feature_not_enabled'),
    z.literal('not_an_admin'),
    z.literal('not_an_enterprise'),
    z.literal('restricted_action'),
    z.literal('missing_scope'),
    z.literal('channel_not_found'),
    z.literal('channel_type_not_supported'),
    z.literal('could_not_get_conversation_prefs'),
  ]),
  ok: defsOkFalseSchema,
});

export const adminConversationsGetTeamsDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    channel_id: z.string(),
    cursor: z.string().optional(),
    limit: z.number().optional(),
  }),
});

export const adminConversationsGetTeamsResponseSchema = z.object({
  ok: defsOkTrueSchema,
  response_metadata: z
    .object({
      next_cursor: z.string(),
    })
    .optional(),
  team_ids: z.array(defsTeamSchema),
});

export const adminConversationsGetTeamsErrorSchema = z.object({
  error: z.union([
    z.literal('feature_not_enabled'),
    z.literal('channel_not_found'),
    z.literal('channel_type_not_supported'),
    z.literal('unsupported_team_type'),
    z.literal('restricted_action'),
    z.literal('could_not_get_teams'),
    z.literal('invalid_cursor'),
    z.literal('invalid_limit'),
  ]),
  ok: defsOkFalseSchema,
});

export const adminConversationsInviteDataSchema = z.object({
  body: z.object({
    channel_id: z.string(),
    user_ids: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminConversationsInviteResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const adminConversationsInviteErrorSchema = z.record(z.union([z.unknown(), z.string(), defsOkFalseSchema])).and(
  z.object({
    error: z.union([
      z.literal('feature_not_enabled'),
      z.literal('channel_not_found'),
      z.literal('channel_type_not_supported'),
      z.literal('default_org_wide_channel'),
      z.literal('restricted_action'),
      z.literal('user_must_be_admin'),
      z.literal('failed_for_some_users'),
    ]),
    ok: defsOkFalseSchema,
  }),
);

export const adminConversationsRenameDataSchema = z.object({
  body: z.object({
    channel_id: z.string(),
    name: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminConversationsRenameResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const adminConversationsRenameErrorSchema = z.object({
  error: z.union([
    z.literal('feature_not_enabled'),
    z.literal('channel_not_found'),
    z.literal('channel_type_not_supported'),
    z.literal('restricted_action'),
    z.literal('could_not_rename_channel'),
    z.literal('default_org_wide_channel'),
    z.literal('name_taken'),
  ]),
  ok: defsOkFalseSchema,
});

export const adminConversationsRestrictAccessAddGroupDataSchema = z.object({
  body: z.object({
    channel_id: z.string(),
    group_id: z.string(),
    team_id: z.string().optional(),
    token: z.string(),
  }),
});

export const adminConversationsRestrictAccessAddGroupResponseSchema = z
  .record(z.union([z.unknown(), defsOkTrueSchema]))
  .and(
    z.object({
      ok: defsOkTrueSchema,
    }),
  );

export const adminConversationsRestrictAccessAddGroupErrorSchema = z
  .record(z.union([z.unknown(), defsOkFalseSchema]))
  .and(
    z.object({
      ok: defsOkFalseSchema,
    }),
  );

export const adminConversationsRestrictAccessListGroupsDataSchema = z.object({
  query: z.object({
    channel_id: z.string(),
    team_id: z.string().optional(),
    token: z.string(),
  }),
});

export const adminConversationsRestrictAccessListGroupsResponseSchema = z
  .record(z.union([z.unknown(), defsOkTrueSchema]))
  .and(
    z.object({
      ok: defsOkTrueSchema,
    }),
  );

export const adminConversationsRestrictAccessListGroupsErrorSchema = z
  .record(z.union([z.unknown(), defsOkFalseSchema]))
  .and(
    z.object({
      ok: defsOkFalseSchema,
    }),
  );

export const adminConversationsRestrictAccessRemoveGroupDataSchema = z.object({
  body: z.object({
    channel_id: z.string(),
    group_id: z.string(),
    team_id: z.string(),
    token: z.string(),
  }),
});

export const adminConversationsRestrictAccessRemoveGroupResponseSchema = z
  .record(z.union([z.unknown(), defsOkTrueSchema]))
  .and(
    z.object({
      ok: defsOkTrueSchema,
    }),
  );

export const adminConversationsRestrictAccessRemoveGroupErrorSchema = z
  .record(z.union([z.unknown(), defsOkFalseSchema]))
  .and(
    z.object({
      ok: defsOkFalseSchema,
    }),
  );

export const adminConversationsSearchDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z
    .object({
      cursor: z.string().optional(),
      limit: z.number().optional(),
      query: z.string().optional(),
      search_channel_types: z.string().optional(),
      sort: z.string().optional(),
      sort_dir: z.string().optional(),
      team_ids: z.string().optional(),
    })
    .optional(),
});

export const adminConversationsSearchResponseSchema = z.object({
  channels: z.array(objsChannelSchema),
  next_cursor: z.string(),
});

export const adminConversationsSearchErrorSchema = z.object({
  error: z.union([
    z.literal('feature_not_enabled'),
    z.literal('not_an_admin'),
    z.literal('not_an_enterprise'),
    z.literal('team_not_found'),
    z.literal('not_allowed'),
    z.literal('invalid_auth'),
    z.literal('invalid_cursor'),
    z.literal('invalid_search_channel_type'),
    z.literal('invalid_sort'),
    z.literal('invalid_sort_dir'),
  ]),
  ok: defsOkFalseSchema,
});

export const adminConversationsSetConversationPrefsDataSchema = z.object({
  body: z.object({
    channel_id: z.string(),
    prefs: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminConversationsSetConversationPrefsResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const adminConversationsSetConversationPrefsErrorSchema = z.object({
  error: z.union([
    z.literal('feature_not_enabled'),
    z.literal('not_an_admin'),
    z.literal('channel_not_found'),
    z.literal('channel_type_not_supported'),
    z.literal('restricted_action'),
    z.literal('missing_scope'),
    z.literal('could_not_set_channel_pref'),
    z.literal('default_org_wide_channel'),
  ]),
  ok: defsOkFalseSchema,
});

export const adminConversationsSetTeamsDataSchema = z.object({
  body: z.object({
    channel_id: z.string(),
    org_channel: z.boolean().optional(),
    target_team_ids: z.string().optional(),
    team_id: z.string().optional(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminConversationsSetTeamsResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminConversationsSetTeamsErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminConversationsUnarchiveDataSchema = z.object({
  body: z.object({
    channel_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminConversationsUnarchiveResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const adminConversationsUnarchiveErrorSchema = z.object({
  error: z.union([
    z.literal('feature_not_enabled'),
    z.literal('channel_not_found'),
    z.literal('channel_not_archived'),
    z.literal('channel_type_not_supported'),
    z.literal('restricted_action'),
    z.literal('could_not_unarchive_channel'),
    z.literal('default_org_wide_channel'),
    z.literal('missing_scope'),
  ]),
  ok: defsOkFalseSchema,
});

export const adminEmojiAddDataSchema = z.object({
  body: z.object({
    name: z.string(),
    token: z.string(),
    url: z.string(),
  }),
});

export const adminEmojiAddResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminEmojiAddErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminEmojiAddAliasDataSchema = z.object({
  body: z.object({
    alias_for: z.string(),
    name: z.string(),
    token: z.string(),
  }),
});

export const adminEmojiAddAliasResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminEmojiAddAliasErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminEmojiListDataSchema = z.object({
  query: z.object({
    cursor: z.string().optional(),
    limit: z.number().optional(),
    token: z.string(),
  }),
});

export const adminEmojiListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminEmojiListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminEmojiRemoveDataSchema = z.object({
  body: z.object({
    name: z.string(),
    token: z.string(),
  }),
});

export const adminEmojiRemoveResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminEmojiRemoveErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminEmojiRenameDataSchema = z.object({
  body: z.object({
    name: z.string(),
    new_name: z.string(),
    token: z.string(),
  }),
});

export const adminEmojiRenameResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminEmojiRenameErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminInviteRequestsApproveDataSchema = z.object({
  body: z
    .object({
      invite_request_id: z.string(),
      team_id: z.string().optional(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminInviteRequestsApproveResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminInviteRequestsApproveErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminInviteRequestsApprovedListDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z
    .object({
      cursor: z.string().optional(),
      limit: z.number().optional(),
      team_id: z.string().optional(),
    })
    .optional(),
});

export const adminInviteRequestsApprovedListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminInviteRequestsApprovedListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminInviteRequestsDeniedListDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z
    .object({
      cursor: z.string().optional(),
      limit: z.number().optional(),
      team_id: z.string().optional(),
    })
    .optional(),
});

export const adminInviteRequestsDeniedListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminInviteRequestsDeniedListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminInviteRequestsDenyDataSchema = z.object({
  body: z
    .object({
      invite_request_id: z.string(),
      team_id: z.string().optional(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminInviteRequestsDenyResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminInviteRequestsDenyErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminInviteRequestsListDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z
    .object({
      cursor: z.string().optional(),
      limit: z.number().optional(),
      team_id: z.string().optional(),
    })
    .optional(),
});

export const adminInviteRequestsListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminInviteRequestsListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminTeamsAdminsListDataSchema = z.object({
  query: z.object({
    cursor: z.string().optional(),
    limit: z.number().optional(),
    team_id: z.string(),
    token: z.string(),
  }),
});

export const adminTeamsAdminsListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminTeamsAdminsListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminTeamsCreateDataSchema = z.object({
  body: z.object({
    team_description: z.string().optional(),
    team_discoverability: z.string().optional(),
    team_domain: z.string(),
    team_name: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminTeamsCreateResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminTeamsCreateErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminTeamsListDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z
    .object({
      cursor: z.string().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const adminTeamsListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminTeamsListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminTeamsOwnersListDataSchema = z.object({
  query: z.object({
    cursor: z.string().optional(),
    limit: z.number().optional(),
    team_id: z.string(),
    token: z.string(),
  }),
});

export const adminTeamsOwnersListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminTeamsOwnersListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminTeamsSettingsInfoDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    team_id: z.string(),
  }),
});

export const adminTeamsSettingsInfoResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminTeamsSettingsInfoErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminTeamsSettingsSetDefaultChannelsDataSchema = z.object({
  body: z.object({
    channel_ids: z.string(),
    team_id: z.string(),
    token: z.string(),
  }),
});

export const adminTeamsSettingsSetDefaultChannelsResponseSchema = z
  .record(z.union([z.unknown(), defsOkTrueSchema]))
  .and(
    z.object({
      ok: defsOkTrueSchema,
    }),
  );

export const adminTeamsSettingsSetDefaultChannelsErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminTeamsSettingsSetDescriptionDataSchema = z.object({
  body: z.object({
    description: z.string(),
    team_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminTeamsSettingsSetDescriptionResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminTeamsSettingsSetDescriptionErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminTeamsSettingsSetDiscoverabilityDataSchema = z.object({
  body: z.object({
    discoverability: z.string(),
    team_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminTeamsSettingsSetDiscoverabilityResponseSchema = z
  .record(z.union([z.unknown(), defsOkTrueSchema]))
  .and(
    z.object({
      ok: defsOkTrueSchema,
    }),
  );

export const adminTeamsSettingsSetDiscoverabilityErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminTeamsSettingsSetIconDataSchema = z.object({
  body: z.object({
    image_url: z.string(),
    team_id: z.string(),
    token: z.string(),
  }),
});

export const adminTeamsSettingsSetIconResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminTeamsSettingsSetIconErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminTeamsSettingsSetNameDataSchema = z.object({
  body: z.object({
    name: z.string(),
    team_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminTeamsSettingsSetNameResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminTeamsSettingsSetNameErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsergroupsAddChannelsDataSchema = z.object({
  body: z.object({
    channel_ids: z.string(),
    team_id: z.string().optional(),
    usergroup_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminUsergroupsAddChannelsResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsergroupsAddChannelsErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsergroupsAddTeamsDataSchema = z.object({
  body: z.object({
    auto_provision: z.boolean().optional(),
    team_ids: z.string(),
    usergroup_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminUsergroupsAddTeamsResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsergroupsAddTeamsErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsergroupsListChannelsDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    include_num_members: z.boolean().optional(),
    team_id: z.string().optional(),
    usergroup_id: z.string(),
  }),
});

export const adminUsergroupsListChannelsResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsergroupsListChannelsErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsergroupsRemoveChannelsDataSchema = z.object({
  body: z.object({
    channel_ids: z.string(),
    usergroup_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminUsergroupsRemoveChannelsResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsergroupsRemoveChannelsErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsersAssignDataSchema = z.object({
  body: z.object({
    channel_ids: z.string().optional(),
    is_restricted: z.boolean().optional(),
    is_ultra_restricted: z.boolean().optional(),
    team_id: z.string(),
    user_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminUsersAssignResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsersAssignErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsersInviteDataSchema = z.object({
  body: z.object({
    channel_ids: z.string(),
    custom_message: z.string().optional(),
    email: z.string(),
    guest_expiration_ts: z.string().optional(),
    is_restricted: z.boolean().optional(),
    is_ultra_restricted: z.boolean().optional(),
    real_name: z.string().optional(),
    resend: z.boolean().optional(),
    team_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminUsersInviteResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsersInviteErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsersListDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    cursor: z.string().optional(),
    limit: z.number().optional(),
    team_id: z.string(),
  }),
});

export const adminUsersListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsersListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsersRemoveDataSchema = z.object({
  body: z.object({
    team_id: z.string(),
    user_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminUsersRemoveResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsersRemoveErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsersSessionInvalidateDataSchema = z.object({
  body: z.object({
    session_id: z.number(),
    team_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminUsersSessionInvalidateResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsersSessionInvalidateErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsersSessionResetDataSchema = z.object({
  body: z.object({
    mobile_only: z.boolean().optional(),
    user_id: z.string(),
    web_only: z.boolean().optional(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminUsersSessionResetResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsersSessionResetErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsersSetAdminDataSchema = z.object({
  body: z.object({
    team_id: z.string(),
    user_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminUsersSetAdminResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsersSetAdminErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsersSetExpirationDataSchema = z.object({
  body: z.object({
    expiration_ts: z.number(),
    team_id: z.string(),
    user_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminUsersSetExpirationResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsersSetExpirationErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsersSetOwnerDataSchema = z.object({
  body: z.object({
    team_id: z.string(),
    user_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminUsersSetOwnerResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsersSetOwnerErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const adminUsersSetRegularDataSchema = z.object({
  body: z.object({
    team_id: z.string(),
    user_id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const adminUsersSetRegularResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const adminUsersSetRegularErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const apiTestDataSchema = z.object({
  query: z
    .object({
      error: z.string().optional(),
      foo: z.string().optional(),
    })
    .optional(),
});

export const apiTestResponseSchema = z.record(z.union([z.union([z.unknown(), defsOkTrueSchema]), z.undefined()])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const apiTestErrorSchema = z
  .record(z.union([z.union([z.unknown(), z.string(), defsOkFalseSchema]), z.undefined()]))
  .and(
    z.object({
      error: z.string(),
      ok: defsOkFalseSchema,
    }),
  );

export const appsEventAuthorizationsListDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    cursor: z.string().optional(),
    event_context: z.string(),
    limit: z.number().optional(),
  }),
});

export const appsEventAuthorizationsListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const appsEventAuthorizationsListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const appsPermissionsInfoDataSchema = z.object({
  query: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const appsPermissionsInfoResponseSchema = z.object({
  info: z.object({
    app_home: z.object({
      resources: objsResourcesSchema.optional(),
      scopes: objsScopesSchema.optional(),
    }),
    channel: z.object({
      resources: objsResourcesSchema.optional(),
      scopes: objsScopesSchema.optional(),
    }),
    group: z.object({
      resources: objsResourcesSchema.optional(),
      scopes: objsScopesSchema.optional(),
    }),
    im: z.object({
      resources: objsResourcesSchema.optional(),
      scopes: objsScopesSchema.optional(),
    }),
    mpim: z.object({
      resources: objsResourcesSchema.optional(),
      scopes: objsScopesSchema.optional(),
    }),
    team: z.object({
      resources: objsResourcesSchema,
      scopes: objsScopesSchema,
    }),
  }),
  ok: defsOkTrueSchema,
});

export const appsPermissionsInfoErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const appsPermissionsRequestDataSchema = z.object({
  query: z.object({
    scopes: z.string(),
    token: z.string(),
    trigger_id: z.string(),
  }),
});

export const appsPermissionsRequestResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const appsPermissionsRequestErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('invalid_trigger'),
    z.literal('trigger_exchanged'),
    z.literal('invalid_scope'),
    z.literal('invalid_user'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const appsPermissionsResourcesListDataSchema = z.object({
  query: z.object({
    cursor: z.string().optional(),
    limit: z.number().optional(),
    token: z.string(),
  }),
});

export const appsPermissionsResourcesListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
    resources: z.array(
      z.object({
        id: z.string().optional(),
        type: z.string().optional(),
      }),
    ),
    response_metadata: z
      .object({
        next_cursor: z.string(),
      })
      .optional(),
  }),
);

export const appsPermissionsResourcesListErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('invalid_cursor'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const appsPermissionsScopesListDataSchema = z.object({
  query: z.object({
    token: z.string(),
  }),
});

export const appsPermissionsScopesListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
    scopes: z.record(z.union([z.unknown(), objsScopesSchema])).and(
      z.object({
        app_home: objsScopesSchema.optional(),
        channel: objsScopesSchema.optional(),
        group: objsScopesSchema.optional(),
        im: objsScopesSchema.optional(),
        mpim: objsScopesSchema.optional(),
        team: objsScopesSchema.optional(),
        user: objsScopesSchema.optional(),
      }),
    ),
  }),
);

export const appsPermissionsScopesListErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const appsPermissionsUsersListDataSchema = z.object({
  query: z.object({
    cursor: z.string().optional(),
    limit: z.number().optional(),
    token: z.string(),
  }),
});

export const appsPermissionsUsersListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const appsPermissionsUsersListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const appsPermissionsUsersRequestDataSchema = z.object({
  query: z.object({
    scopes: z.string(),
    token: z.string(),
    trigger_id: z.string(),
    user: z.string(),
  }),
});

export const appsPermissionsUsersRequestResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const appsPermissionsUsersRequestErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const appsUninstallDataSchema = z.object({
  query: z
    .object({
      client_id: z.string().optional(),
      client_secret: z.string().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const appsUninstallResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const appsUninstallErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('invalid_client_id'),
    z.literal('bad_client_secret'),
    z.literal('client_id_token_mismatch'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const authRevokeDataSchema = z.object({
  query: z.object({
    test: z.boolean().optional(),
    token: z.string(),
  }),
});

export const authRevokeResponseSchema = z.object({
  ok: defsOkTrueSchema,
  revoked: z.boolean(),
});

export const authRevokeErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const authTestDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
});

export const authTestResponseSchema = z.object({
  bot_id: defsBotIdSchema.optional(),
  is_enterprise_install: z.boolean().optional(),
  ok: defsOkTrueSchema,
  team: z.string(),
  team_id: defsTeamSchema,
  url: z.string(),
  user: z.string(),
  user_id: defsUserIdSchema,
});

export const authTestErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('token_revoked'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const botsInfoDataSchema = z.object({
  query: z.object({
    bot: z.string().optional(),
    token: z.string(),
  }),
});

export const botsInfoResponseSchema = z.object({
  bot: z.object({
    app_id: defsAppIdSchema,
    deleted: z.boolean(),
    icons: z.object({
      image_36: z.string(),
      image_48: z.string(),
      image_72: z.string(),
    }),
    id: defsBotIdSchema,
    name: z.string(),
    updated: z.number(),
    user_id: defsUserIdSchema.optional(),
  }),
  ok: defsOkTrueSchema,
});

export const botsInfoErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('bot_not_found'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const callsAddDataSchema = z.object({
  body: z.object({
    created_by: z.string().optional(),
    date_start: z.number().optional(),
    desktop_app_join_url: z.string().optional(),
    external_display_id: z.string().optional(),
    external_unique_id: z.string(),
    join_url: z.string(),
    title: z.string().optional(),
    users: z.string().optional(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const callsAddResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const callsAddErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const callsEndDataSchema = z.object({
  body: z.object({
    duration: z.number().optional(),
    id: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const callsEndResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const callsEndErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const callsInfoDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    id: z.string(),
  }),
});

export const callsInfoResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const callsInfoErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const callsParticipantsAddDataSchema = z.object({
  body: z.object({
    id: z.string(),
    users: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const callsParticipantsAddResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const callsParticipantsAddErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const callsParticipantsRemoveDataSchema = z.object({
  body: z.object({
    id: z.string(),
    users: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const callsParticipantsRemoveResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const callsParticipantsRemoveErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const callsUpdateDataSchema = z.object({
  body: z.object({
    desktop_app_join_url: z.string().optional(),
    id: z.string(),
    join_url: z.string().optional(),
    title: z.string().optional(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const callsUpdateResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const callsUpdateErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const chatDeleteDataSchema = z.object({
  body: z
    .object({
      as_user: z.boolean().optional(),
      channel: z.string().optional(),
      ts: z.number().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const chatDeleteResponseSchema = z.object({
  channel: defsChannelSchema,
  ok: defsOkTrueSchema,
  ts: defsTsSchema,
});

export const chatDeleteErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('message_not_found'),
    z.literal('channel_not_found'),
    z.literal('cant_delete_message'),
    z.literal('compliance_exports_prevent_deletion'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const chatDeleteScheduledMessageDataSchema = z.object({
  body: z
    .object({
      as_user: z.boolean().optional(),
      channel: z.string(),
      scheduled_message_id: z.string(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const chatDeleteScheduledMessageResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const chatDeleteScheduledMessageErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('invalid_scheduled_message_id'),
    z.literal('channel_not_found'),
    z.literal('bad_token'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('ekm_access_denied'),
    z.literal('missing_scope'),
    z.literal('invalid_arguments'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const chatGetPermalinkDataSchema = z.object({
  query: z.object({
    channel: z.string(),
    message_ts: z.string(),
    token: z.string(),
  }),
});

export const chatGetPermalinkResponseSchema = z.object({
  channel: defsChannelSchema,
  ok: defsOkTrueSchema,
  permalink: z.string(),
});

export const chatGetPermalinkErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('channel_not_found'),
    z.literal('message_not_found'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const chatMeMessageDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
      text: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const chatMeMessageResponseSchema = z.object({
  channel: defsChannelSchema.optional(),
  ok: defsOkTrueSchema,
  ts: defsTsSchema.optional(),
});

export const chatMeMessageErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('channel_not_found'),
    z.literal('not_in_channel'),
    z.literal('is_archived'),
    z.literal('msg_too_long'),
    z.literal('no_text'),
    z.literal('rate_limited'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const chatPostEphemeralDataSchema = z.object({
  body: z
    .object({
      as_user: z.boolean().optional(),
      attachments: z.string().optional(),
      blocks: z.string().optional(),
      channel: z.string(),
      icon_emoji: z.string().optional(),
      icon_url: z.string().optional(),
      link_names: z.boolean().optional(),
      parse: z.string().optional(),
      text: z.string().optional(),
      thread_ts: z.string().optional(),
      user: z.string(),
      username: z.string().optional(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const chatPostEphemeralResponseSchema = z.object({
  message_ts: defsTsSchema,
  ok: defsOkTrueSchema,
});

export const chatPostEphemeralErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('channel_not_found'),
    z.literal('is_archived'),
    z.literal('msg_too_long'),
    z.literal('no_text'),
    z.literal('restricted_action'),
    z.literal('too_many_attachments'),
    z.literal('user_not_in_channel'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const chatPostMessageDataSchema = z.object({
  body: z
    .object({
      as_user: z.string().optional(),
      attachments: z.string().optional(),
      blocks: z.string().optional(),
      channel: z.string(),
      icon_emoji: z.string().optional(),
      icon_url: z.string().optional(),
      link_names: z.boolean().optional(),
      mrkdwn: z.boolean().optional(),
      parse: z.string().optional(),
      reply_broadcast: z.boolean().optional(),
      text: z.string().optional(),
      thread_ts: z.string().optional(),
      unfurl_links: z.boolean().optional(),
      unfurl_media: z.boolean().optional(),
      username: z.string().optional(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const objsMessageSchema = z.object({
  attachments: z
    .array(
      z.object({
        fallback: z.string().optional(),
        id: z.number(),
        image_bytes: z.number().optional(),
        image_height: z.number().optional(),
        image_url: z.string().optional(),
        image_width: z.number().optional(),
      }),
    )
    .optional(),
  blocks: blocksSchema.optional(),
  bot_id: z.unknown().optional(),
  bot_profile: objsBotProfileSchema.optional(),
  client_msg_id: z.string().optional(),
  comment: objsCommentSchema.optional(),
  display_as_bot: z.boolean().optional(),
  file: objsFileSchema.optional(),
  files: z.array(objsFileSchema).optional(),
  icons: z
    .object({
      emoji: z.string().optional(),
      image_64: z.string().optional(),
    })
    .optional(),
  inviter: defsUserIdSchema.optional(),
  is_delayed_message: z.boolean().optional(),
  is_intro: z.boolean().optional(),
  is_starred: z.boolean().optional(),
  last_read: defsTsSchema.optional(),
  latest_reply: defsTsSchema.optional(),
  name: z.string().optional(),
  old_name: z.string().optional(),
  parent_user_id: defsUserIdSchema.optional(),
  permalink: z.string().optional(),
  pinned_to: z.array(defsChannelSchema).optional(),
  purpose: z.string().optional(),
  reactions: z.array(objsReactionSchema).optional(),
  reply_count: z.number().optional(),
  reply_users: z.array(defsUserIdSchema).optional(),
  reply_users_count: z.number().optional(),
  source_team: defsWorkspaceIdSchema.optional(),
  subscribed: z.boolean().optional(),
  subtype: z.string().optional(),
  team: defsWorkspaceIdSchema.optional(),
  text: z.string(),
  thread_ts: defsTsSchema.optional(),
  topic: z.string().optional(),
  ts: defsTsSchema,
  type: z.string(),
  unread_count: z.number().optional(),
  upload: z.boolean().optional(),
  user: defsUserIdSchema.optional(),
  user_profile: objsUserProfileShortSchema.optional(),
  user_team: defsWorkspaceIdSchema.optional(),
  username: z.string().optional(),
});

export const chatPostMessageErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('channel_not_found'),
    z.literal('not_in_channel'),
    z.literal('is_archived'),
    z.literal('msg_too_long'),
    z.literal('no_text'),
    z.literal('too_many_attachments'),
    z.literal('rate_limited'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
  ]),
  ok: defsOkFalseSchema,
});

export const chatScheduleMessageDataSchema = z.object({
  body: z
    .object({
      as_user: z.boolean().optional(),
      attachments: z.string().optional(),
      blocks: z.string().optional(),
      channel: z.string().optional(),
      link_names: z.boolean().optional(),
      parse: z.string().optional(),
      post_at: z.string().optional(),
      reply_broadcast: z.boolean().optional(),
      text: z.string().optional(),
      thread_ts: z.number().optional(),
      unfurl_links: z.boolean().optional(),
      unfurl_media: z.boolean().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const chatScheduleMessageResponseSchema = z.object({
  channel: defsChannelSchema,
  message: z.object({
    bot_id: defsBotIdSchema,
    bot_profile: objsBotProfileSchema.optional(),
    team: defsTeamSchema,
    text: z.string(),
    type: z.string(),
    user: defsUserIdSchema,
    username: z.string().optional(),
  }),
  ok: defsOkTrueSchema,
  post_at: z.number(),
  scheduled_message_id: z.string(),
});

export const chatScheduleMessageErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('invalid_time'),
    z.literal('time_in_past'),
    z.literal('time_too_far'),
    z.literal('channel_not_found'),
    z.literal('not_in_channel'),
    z.literal('is_archived'),
    z.literal('msg_too_long'),
    z.literal('no_text'),
    z.literal('restricted_action'),
    z.literal('restricted_action_read_only_channel'),
    z.literal('restricted_action_thread_only_channel'),
    z.literal('restricted_action_non_threadable_channel'),
    z.literal('too_many_attachments'),
    z.literal('rate_limited'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('ekm_access_denied'),
    z.literal('missing_scope'),
    z.literal('invalid_arguments'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const chatScheduledMessagesListDataSchema = z.object({
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      channel: z.string().optional(),
      cursor: z.string().optional(),
      latest: z.number().optional(),
      limit: z.number().optional(),
      oldest: z.number().optional(),
    })
    .optional(),
});

export const chatScheduledMessagesListResponseSchema = z.object({
  ok: defsOkTrueSchema,
  response_metadata: z.object({
    next_cursor: z.string(),
  }),
  scheduled_messages: z.array(
    z.object({
      channel_id: defsChannelIdSchema,
      date_created: z.number(),
      id: z.string(),
      post_at: z.number(),
      text: z.string().optional(),
    }),
  ),
});

export const chatScheduledMessagesListErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('invalid_channel'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('ekm_access_denied'),
    z.literal('missing_scope'),
    z.literal('invalid_arguments'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const chatUnfurlDataSchema = z.object({
  body: z.object({
    channel: z.string(),
    ts: z.string(),
    unfurls: z.string().optional(),
    user_auth_message: z.string().optional(),
    user_auth_required: z.boolean().optional(),
    user_auth_url: z.string().optional(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const chatUnfurlResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const chatUnfurlErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('cannot_unfurl_url'),
    z.literal('cannot_find_service'),
    z.literal('missing_unfurls'),
    z.literal('cannot_prompt'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const chatUpdateDataSchema = z.object({
  body: z
    .object({
      as_user: z.string().optional(),
      attachments: z.string().optional(),
      blocks: z.string().optional(),
      channel: z.string(),
      link_names: z.string().optional(),
      parse: z.string().optional(),
      text: z.string().optional(),
      ts: z.string(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const chatUpdateResponseSchema = z.object({
  channel: z.string(),
  message: z.object({
    attachments: z.array(z.record(z.unknown())).optional(),
    blocks: z.record(z.unknown()).optional(),
    text: z.string(),
  }),
  ok: defsOkTrueSchema,
  text: z.string(),
  ts: z.string(),
});

export const chatUpdateErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('message_not_found'),
    z.literal('cant_update_message'),
    z.literal('channel_not_found'),
    z.literal('edit_window_closed'),
    z.literal('msg_too_long'),
    z.literal('too_many_attachments'),
    z.literal('rate_limited'),
    z.literal('no_text'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('request_timeout'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
    z.literal('is_inactive'),
  ]),
  ok: defsOkFalseSchema,
});

export const conversationsArchiveDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsArchiveResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const conversationsArchiveErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('method_not_supported_for_channel_type'),
    z.literal('missing_scope'),
    z.literal('not_supported'),
    z.literal('channel_not_found'),
    z.literal('already_archived'),
    z.literal('cant_archive_general'),
    z.literal('restricted_action'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('user_is_ultra_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('team_added_to_org'),
    z.literal('missing_charset'),
    z.literal('superfluous_charset'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsCloseDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsCloseResponseSchema = z.object({
  already_closed: z.boolean().optional(),
  no_op: z.boolean().optional(),
  ok: defsOkTrueSchema,
});

export const conversationsCloseErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('method_not_supported_for_channel_type'),
    z.literal('channel_not_found'),
    z.literal('user_does_not_own_channel'),
    z.literal('missing_scope'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsCreateDataSchema = z.object({
  body: z
    .object({
      is_private: z.boolean().optional(),
      name: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsCreateResponseSchema = z.object({
  channel: objsConversationSchema,
  ok: defsOkTrueSchema,
});

export const conversationsCreateErrorSchema = z.object({
  callstack: z.string().optional(),
  detail: z.string().optional(),
  error: z.union([
    z.literal('method_not_supported_for_channel_type'),
    z.literal('missing_scope'),
    z.literal('name_taken'),
    z.literal('restricted_action'),
    z.literal('no_channel'),
    z.literal('invalid_name_required'),
    z.literal('invalid_name_punctuation'),
    z.literal('invalid_name_maxlength'),
    z.literal('invalid_name_specials'),
    z.literal('invalid_name'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsHistoryDataSchema = z.object({
  query: z
    .object({
      channel: z.string().optional(),
      cursor: z.string().optional(),
      inclusive: z.boolean().optional(),
      latest: z.number().optional(),
      limit: z.number().optional(),
      oldest: z.number().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsHistoryResponseSchema = z.object({
  channel_actions_count: z.number(),
  channel_actions_ts: z.unknown(),
  has_more: z.boolean(),
  messages: z.array(objsMessageSchema),
  ok: defsOkTrueSchema,
  pin_count: z.number(),
});

export const conversationsHistoryErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('missing_scope'),
    z.literal('channel_not_found'),
    z.literal('invalid_ts_latest'),
    z.literal('invalid_ts_oldest'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsInfoDataSchema = z.object({
  query: z
    .object({
      channel: z.string().optional(),
      include_locale: z.boolean().optional(),
      include_num_members: z.boolean().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsInfoResponseSchema = z.object({
  channel: objsConversationSchema,
  ok: defsOkTrueSchema,
});

export const conversationsInfoErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('missing_scope'),
    z.literal('channel_not_found'),
    z.literal('team_added_to_org'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsInviteDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
      users: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsInviteResponseSchema = z.object({
  channel: objsConversationSchema,
  ok: defsOkTrueSchema,
});

export const conversationsInviteErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z
    .union([
      z.literal('method_not_supported_for_channel_type'),
      z.literal('missing_scope'),
      z.literal('channel_not_found'),
      z.literal('user_not_found'),
      z.literal('no_user'),
      z.literal('cant_invite_self'),
      z.literal('not_in_channel'),
      z.literal('already_in_channel'),
      z.literal('is_archived'),
      z.literal('cant_invite'),
      z.literal('too_many_users'),
      z.literal('ura_max_channels'),
      z.literal('not_authed'),
      z.literal('invalid_auth'),
      z.literal('account_inactive'),
      z.literal('user_is_bot'),
      z.literal('user_is_restricted'),
      z.literal('user_is_ultra_restricted'),
      z.literal('invalid_arg_name'),
      z.literal('invalid_array_arg'),
      z.literal('invalid_charset'),
      z.literal('invalid_form_data'),
      z.literal('invalid_post_type'),
      z.literal('missing_post_type'),
      z.literal('invalid_json'),
      z.literal('json_not_object'),
      z.literal('request_timeout'),
      z.literal('upgrade_required'),
      z.literal('team_added_to_org'),
      z.literal('missing_charset'),
      z.literal('superfluous_charset'),
    ])
    .optional(),
  errors: z
    .array(
      z.object({
        error: z.union([
          z.literal('method_not_supported_for_channel_type'),
          z.literal('missing_scope'),
          z.literal('channel_not_found'),
          z.literal('user_not_found'),
          z.literal('no_user'),
          z.literal('cant_invite_self'),
          z.literal('not_in_channel'),
          z.literal('already_in_channel'),
          z.literal('is_archived'),
          z.literal('cant_invite'),
          z.literal('too_many_users'),
          z.literal('ura_max_channels'),
          z.literal('not_authed'),
          z.literal('invalid_auth'),
          z.literal('account_inactive'),
          z.literal('user_is_bot'),
          z.literal('user_is_restricted'),
          z.literal('user_is_ultra_restricted'),
          z.literal('invalid_arg_name'),
          z.literal('invalid_array_arg'),
          z.literal('invalid_charset'),
          z.literal('invalid_form_data'),
          z.literal('invalid_post_type'),
          z.literal('missing_post_type'),
          z.literal('invalid_json'),
          z.literal('json_not_object'),
          z.literal('request_timeout'),
          z.literal('upgrade_required'),
          z.literal('team_added_to_org'),
          z.literal('missing_charset'),
          z.literal('superfluous_charset'),
        ]),
        ok: defsOkFalseSchema,
        user: defsUserIdSchema.optional(),
      }),
    )
    .optional(),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsJoinDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsJoinResponseSchema = z.object({
  channel: objsConversationSchema,
  ok: defsOkTrueSchema,
  response_metadata: z
    .object({
      warnings: z.array(z.string()).optional(),
    })
    .optional(),
  warning: z.string().optional(),
});

export const conversationsJoinErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('method_not_supported_for_channel_type'),
    z.literal('missing_scope'),
    z.literal('channel_not_found'),
    z.literal('is_archived'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('user_is_ultra_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('team_added_to_org'),
    z.literal('missing_charset'),
    z.literal('superfluous_charset'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsKickDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
      user: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsKickResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const conversationsKickErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('method_not_supported_for_channel_type'),
    z.literal('missing_scope'),
    z.literal('channel_not_found'),
    z.literal('user_not_found'),
    z.literal('cant_kick_self'),
    z.literal('not_in_channel'),
    z.literal('cant_kick_from_general'),
    z.literal('restricted_action'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsLeaveDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsLeaveResponseSchema = z.object({
  not_in_channel: z.boolean().optional(),
  ok: defsOkTrueSchema,
});

export const conversationsLeaveErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('method_not_supported_for_channel_type'),
    z.literal('last_member'),
    z.literal('missing_scope'),
    z.literal('channel_not_found'),
    z.literal('is_archived'),
    z.literal('cant_leave_general'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('user_is_ultra_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('team_added_to_org'),
    z.literal('missing_charset'),
    z.literal('superfluous_charset'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsListDataSchema = z.object({
  query: z
    .object({
      cursor: z.string().optional(),
      exclude_archived: z.boolean().optional(),
      limit: z.number().optional(),
      token: z.string().optional(),
      types: z.string().optional(),
    })
    .optional(),
});

export const conversationsListResponseSchema = z.object({
  channels: z.array(objsConversationSchema),
  ok: defsOkTrueSchema,
  response_metadata: z
    .object({
      next_cursor: z.string(),
    })
    .optional(),
});

export const conversationsListErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('missing_scope'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsMarkDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
      ts: z.number().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsMarkResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const conversationsMarkErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('method_not_supported_for_channel_type'),
    z.literal('missing_scope'),
    z.literal('channel_not_found'),
    z.literal('invalid_timestamp'),
    z.literal('not_in_channel'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('not_allowed_token_type'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsMembersDataSchema = z.object({
  query: z
    .object({
      channel: z.string().optional(),
      cursor: z.string().optional(),
      limit: z.number().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsMembersResponseSchema = z.object({
  members: z.array(defsUserIdSchema),
  ok: defsOkTrueSchema,
  response_metadata: z.object({
    next_cursor: z.string(),
  }),
});

export const conversationsMembersErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('channel_not_found'),
    z.literal('invalid_limit'),
    z.literal('invalid_cursor'),
    z.literal('fetch_members_failed'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const conversationsOpenDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
      return_im: z.boolean().optional(),
      users: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsOpenResponseSchema = z.object({
  already_open: z.boolean().optional(),
  channel: z.unknown(),
  no_op: z.boolean().optional(),
  ok: defsOkTrueSchema,
});

export const conversationsOpenErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('method_not_supported_for_channel_type'),
    z.literal('user_not_found'),
    z.literal('user_not_visible'),
    z.literal('user_disabled'),
    z.literal('users_list_not_supplied'),
    z.literal('not_enough_users'),
    z.literal('too_many_users'),
    z.literal('invalid_user_combination'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('channel_not_found'),
  ]),
  ok: defsOkFalseSchema,
});

export const conversationsRenameDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsRenameResponseSchema = z.object({
  channel: objsConversationSchema,
  ok: defsOkTrueSchema,
});

export const conversationsRenameErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('user_is_restricted'),
    z.literal('method_not_supported_for_channel_type'),
    z.literal('missing_scope'),
    z.literal('channel_not_found'),
    z.literal('not_in_channel'),
    z.literal('not_authorized'),
    z.literal('invalid_name'),
    z.literal('name_taken'),
    z.literal('invalid_name_required'),
    z.literal('invalid_name_punctuation'),
    z.literal('invalid_name_maxlength'),
    z.literal('invalid_name_specials'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsRepliesDataSchema = z.object({
  query: z
    .object({
      channel: z.string().optional(),
      cursor: z.string().optional(),
      inclusive: z.boolean().optional(),
      latest: z.number().optional(),
      limit: z.number().optional(),
      oldest: z.number().optional(),
      token: z.string().optional(),
      ts: z.number().optional(),
    })
    .optional(),
});

export const conversationsRepliesResponseSchema = z.object({
  has_more: z.boolean().optional(),
  messages: z.array(z.unknown()),
  ok: defsOkTrueSchema,
});

export const conversationsRepliesErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('missing_scope'),
    z.literal('channel_not_found'),
    z.literal('thread_not_found'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsSetPurposeDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
      purpose: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsSetPurposeResponseSchema = z.object({
  channel: objsConversationSchema,
  ok: defsOkTrueSchema,
});

export const conversationsSetPurposeErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('method_not_supported_for_channel_type'),
    z.literal('missing_scope'),
    z.literal('channel_not_found'),
    z.literal('not_in_channel'),
    z.literal('is_archived'),
    z.literal('too_long'),
    z.literal('user_is_restricted'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsSetTopicDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
      topic: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsSetTopicResponseSchema = z.object({
  channel: objsConversationSchema,
  ok: defsOkTrueSchema,
});

export const conversationsSetTopicErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('method_not_supported_for_channel_type'),
    z.literal('missing_scope'),
    z.literal('channel_not_found'),
    z.literal('not_in_channel'),
    z.literal('is_archived'),
    z.literal('too_long'),
    z.literal('user_is_restricted'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const conversationsUnarchiveDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const conversationsUnarchiveResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const conversationsUnarchiveErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('method_not_supported_for_channel_type'),
    z.literal('missing_scope'),
    z.literal('channel_not_found'),
    z.literal('not_archived'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('user_is_ultra_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('team_added_to_org'),
    z.literal('missing_charset'),
    z.literal('superfluous_charset'),
  ]),
  needed: z.string().optional(),
  ok: defsOkFalseSchema,
  provided: z.string().optional(),
});

export const dialogOpenDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    dialog: z.string(),
    trigger_id: z.string(),
  }),
});

export const dialogOpenResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const dialogOpenErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('validation_errors'),
    z.literal('missing_trigger'),
    z.literal('missing_dialog'),
    z.literal('trigger_exchanged'),
    z.literal('trigger_expired'),
    z.literal('invalid_trigger'),
    z.literal('app_missing_action_url'),
    z.literal('cannot_create_dialog'),
    z.literal('failed_sending_dialog'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const dndEndDndDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
});

export const dndEndDndResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const dndEndDndErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('unknown_error'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const dndEndSnoozeDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
});

export const dndEndSnoozeResponseSchema = z.object({
  dnd_enabled: z.boolean(),
  next_dnd_end_ts: z.number(),
  next_dnd_start_ts: z.number(),
  ok: defsOkTrueSchema,
  snooze_enabled: z.boolean(),
});

export const dndEndSnoozeErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('snooze_not_active'),
    z.literal('snooze_end_failed'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const dndInfoDataSchema = z.object({
  query: z
    .object({
      token: z.string().optional(),
      user: z.string().optional(),
    })
    .optional(),
});

export const dndInfoResponseSchema = z.object({
  dnd_enabled: z.boolean(),
  next_dnd_end_ts: z.number(),
  next_dnd_start_ts: z.number(),
  ok: defsOkTrueSchema,
  snooze_enabled: z.boolean().optional(),
  snooze_endtime: z.number().optional(),
  snooze_remaining: z.number().optional(),
});

export const dndInfoErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('user_not_found'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const dndSetSnoozeDataSchema = z.object({
  body: z.object({
    num_minutes: z.string(),
    token: z.string(),
  }),
});

export const dndSetSnoozeResponseSchema = z.object({
  ok: defsOkTrueSchema,
  snooze_enabled: z.boolean(),
  snooze_endtime: z.number(),
  snooze_remaining: z.number(),
});

export const dndSetSnoozeErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('missing_duration'),
    z.literal('snooze_failed'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('too_long'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const dndTeamInfoDataSchema = z.object({
  query: z
    .object({
      token: z.string().optional(),
      users: z.string().optional(),
    })
    .optional(),
});

export const dndTeamInfoResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const dndTeamInfoErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const emojiListDataSchema = z.object({
  query: z.object({
    token: z.string(),
  }),
});

export const emojiListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const emojiListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const filesCommentsDeleteDataSchema = z.object({
  body: z
    .object({
      file: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const filesCommentsDeleteResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const filesCommentsDeleteErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('cant_delete'),
    z.literal('comment_not_found'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const filesDeleteDataSchema = z.object({
  body: z
    .object({
      file: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const filesDeleteResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const filesDeleteErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('file_not_found'),
    z.literal('file_deleted'),
    z.literal('cant_delete_file'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const filesInfoDataSchema = z.object({
  query: z
    .object({
      count: z.string().optional(),
      cursor: z.string().optional(),
      file: z.string().optional(),
      limit: z.number().optional(),
      page: z.string().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const filesInfoResponseSchema = z.object({
  comments: objsCommentsSchema,
  content_html: z.unknown().optional(),
  editor: defsUserIdSchema.optional(),
  file: objsFileSchema,
  ok: defsOkTrueSchema,
  paging: objsPagingSchema.optional(),
  response_metadata: objsResponseMetadataSchema.optional(),
});

export const filesInfoErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('file_not_found'),
    z.literal('file_deleted'),
    z.literal('timezone_count_failed'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const filesListDataSchema = z.object({
  query: z
    .object({
      channel: z.string().optional(),
      count: z.string().optional(),
      page: z.string().optional(),
      show_files_hidden_by_limit: z.boolean().optional(),
      token: z.string().optional(),
      ts_from: z.number().optional(),
      ts_to: z.number().optional(),
      types: z.string().optional(),
      user: z.string().optional(),
    })
    .optional(),
});

export const filesListResponseSchema = z.object({
  files: z.array(objsFileSchema),
  ok: defsOkTrueSchema,
  paging: objsPagingSchema,
});

export const filesListErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('user_not_found'),
    z.literal('unknown_type'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const filesRemoteAddDataSchema = z.object({
  body: z
    .object({
      external_id: z.string().optional(),
      external_url: z.string().optional(),
      filetype: z.string().optional(),
      indexable_file_contents: z.string().optional(),
      preview_image: z.string().optional(),
      title: z.string().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const filesRemoteAddResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const filesRemoteAddErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const filesRemoteInfoDataSchema = z.object({
  query: z
    .object({
      external_id: z.string().optional(),
      file: z.string().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const filesRemoteInfoResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const filesRemoteInfoErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const filesRemoteListDataSchema = z.object({
  query: z
    .object({
      channel: z.string().optional(),
      cursor: z.string().optional(),
      limit: z.number().optional(),
      token: z.string().optional(),
      ts_from: z.number().optional(),
      ts_to: z.number().optional(),
    })
    .optional(),
});

export const filesRemoteListResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const filesRemoteListErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const filesRemoteRemoveDataSchema = z.object({
  body: z
    .object({
      external_id: z.string().optional(),
      file: z.string().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const filesRemoteRemoveResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const filesRemoteRemoveErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const filesRemoteShareDataSchema = z.object({
  query: z
    .object({
      channels: z.string().optional(),
      external_id: z.string().optional(),
      file: z.string().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const filesRemoteShareResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const filesRemoteShareErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const filesRemoteUpdateDataSchema = z.object({
  body: z
    .object({
      external_id: z.string().optional(),
      external_url: z.string().optional(),
      file: z.string().optional(),
      filetype: z.string().optional(),
      indexable_file_contents: z.string().optional(),
      preview_image: z.string().optional(),
      title: z.string().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const filesRemoteUpdateResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const filesRemoteUpdateErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const filesRevokePublicUrlDataSchema = z.object({
  body: z
    .object({
      file: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const filesRevokePublicUrlResponseSchema = z.object({
  file: objsFileSchema,
  ok: defsOkTrueSchema,
});

export const filesRevokePublicUrlErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('file_not_found'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const filesSharedPublicUrlDataSchema = z.object({
  body: z
    .object({
      file: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const filesSharedPublicUrlResponseSchema = z.object({
  file: objsFileSchema,
  ok: defsOkTrueSchema,
});

export const filesSharedPublicUrlErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('file_not_found'),
    z.literal('not_allowed'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const filesUploadDataSchema = z.object({
  body: z
    .object({
      channels: z.string().optional(),
      content: z.string().optional(),
      file: z.string().optional(),
      filename: z.string().optional(),
      filetype: z.string().optional(),
      initial_comment: z.string().optional(),
      thread_ts: z.number().optional(),
      title: z.string().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const filesUploadResponseSchema = z.object({
  file: objsFileSchema,
  ok: defsOkTrueSchema,
});

export const filesUploadErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('posting_to_general_channel_denied'),
    z.literal('invalid_channel'),
    z.literal('file_uploads_disabled'),
    z.literal('file_uploads_except_images_disabled'),
    z.literal('storage_limit_reached'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const migrationExchangeDataSchema = z.object({
  query: z.object({
    team_id: z.string().optional(),
    to_old: z.boolean().optional(),
    token: z.string(),
    users: z.string(),
  }),
});

export const migrationExchangeResponseSchema = z
  .record(z.union([z.unknown(), z.string(), defsOkTrueSchema, defsTeamSchema]))
  .and(
    z.object({
      enterprise_id: z.string(),
      invalid_user_ids: z.array(z.string()).optional(),
      ok: defsOkTrueSchema,
      team_id: defsTeamSchema,
      user_id_map: z.record(z.unknown()).optional(),
    }),
  );

export const migrationExchangeErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_enterprise_team'),
    z.literal('too_many_users'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const oauthAccessDataSchema = z.object({
  query: z
    .object({
      client_id: z.string().optional(),
      client_secret: z.string().optional(),
      code: z.string().optional(),
      redirect_uri: z.string().optional(),
      single_channel: z.boolean().optional(),
    })
    .optional(),
});

export const oauthAccessResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const oauthAccessErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const oauthTokenDataSchema = z.object({
  query: z
    .object({
      client_id: z.string().optional(),
      client_secret: z.string().optional(),
      code: z.string().optional(),
      redirect_uri: z.string().optional(),
      single_channel: z.boolean().optional(),
    })
    .optional(),
});

export const oauthTokenResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const oauthTokenErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const oauthV2AccessDataSchema = z.object({
  query: z.object({
    client_id: z.string().optional(),
    client_secret: z.string().optional(),
    code: z.string(),
    redirect_uri: z.string().optional(),
  }),
});

export const oauthV2AccessResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const oauthV2AccessErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const pinsAddDataSchema = z.object({
  body: z.object({
    channel: z.string(),
    timestamp: z.string().optional(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const pinsAddResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const pinsAddErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('bad_timestamp'),
    z.literal('message_not_found'),
    z.literal('channel_not_found'),
    z.literal('no_item_specified'),
    z.literal('already_pinned'),
    z.literal('permission_denied'),
    z.literal('file_not_shared'),
    z.literal('not_pinnable'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const pinsListDataSchema = z.object({
  query: z.object({
    channel: z.string(),
    token: z.string(),
  }),
});

export const pinsListResponseSchema = z.unknown();

export const pinsListErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('channel_not_found'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const pinsRemoveDataSchema = z.object({
  body: z.object({
    channel: z.string(),
    timestamp: z.string().optional(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const pinsRemoveResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const pinsRemoveErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('bad_timestamp'),
    z.literal('file_not_found'),
    z.literal('file_comment_not_found'),
    z.literal('message_not_found'),
    z.literal('no_item_specified'),
    z.literal('not_pinned'),
    z.literal('permission_denied'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_typ'),
    z.literal('missing_post_typ'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeou'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const reactionsAddDataSchema = z.object({
  body: z.object({
    channel: z.string(),
    name: z.string(),
    timestamp: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const reactionsAddResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const reactionsAddErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('bad_timestamp'),
    z.literal('message_not_found'),
    z.literal('no_item_specified'),
    z.literal('invalid_name'),
    z.literal('already_reacted'),
    z.literal('too_many_emoji'),
    z.literal('too_many_reactions'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const reactionsGetDataSchema = z.object({
  query: z.object({
    channel: z.string().optional(),
    file: z.string().optional(),
    file_comment: z.string().optional(),
    full: z.boolean().optional(),
    timestamp: z.string().optional(),
    token: z.string(),
  }),
});

export const reactionsGetResponseSchema = z.record(z.unknown());

export const reactionsGetErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('bad_timestamp'),
    z.literal('file_not_found'),
    z.literal('file_comment_not_found'),
    z.literal('message_not_found'),
    z.literal('no_item_specified'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const reactionsListDataSchema = z.object({
  query: z.object({
    count: z.number().optional(),
    cursor: z.string().optional(),
    full: z.boolean().optional(),
    limit: z.number().optional(),
    page: z.number().optional(),
    token: z.string(),
    user: z.string().optional(),
  }),
});

export const reactionsListResponseSchema = z.object({
  items: z.array(z.unknown()),
  ok: defsOkTrueSchema,
  paging: objsPagingSchema.optional(),
  response_metadata: objsResponseMetadataSchema.optional(),
});

export const reactionsListErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('user_not_found'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactiv'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const reactionsRemoveDataSchema = z.object({
  body: z.object({
    channel: z.string().optional(),
    file: z.string().optional(),
    file_comment: z.string().optional(),
    name: z.string(),
    timestamp: z.string().optional(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const reactionsRemoveResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const reactionsRemoveErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('bad_timestamp'),
    z.literal('file_not_found'),
    z.literal('file_comment_not_found'),
    z.literal('message_not_found'),
    z.literal('no_item_specified'),
    z.literal('invalid_name'),
    z.literal('no_reaction'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const remindersAddDataSchema = z.object({
  body: z.object({
    text: z.string(),
    time: z.string(),
    user: z.string().optional(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const remindersAddResponseSchema = z.object({
  ok: defsOkTrueSchema,
  reminder: objsReminderSchema,
});

export const remindersAddErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('cannot_parse'),
    z.literal('user_not_found'),
    z.literal('cannot_add_bot'),
    z.literal('cannot_add_slackbot'),
    z.literal('cannot_add_others'),
    z.literal('cannot_add_others_recurring'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const remindersCompleteDataSchema = z.object({
  body: z
    .object({
      reminder: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const remindersCompleteResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const remindersCompleteErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_found'),
    z.literal('cannot_complete_recurring'),
    z.literal('cannot_complete_others'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const remindersDeleteDataSchema = z.object({
  body: z
    .object({
      reminder: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const remindersDeleteResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const remindersDeleteErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_found'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const remindersInfoDataSchema = z.object({
  query: z
    .object({
      reminder: z.string().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const remindersInfoResponseSchema = z.object({
  ok: defsOkTrueSchema,
  reminder: objsReminderSchema,
});

export const remindersInfoErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_found'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const remindersListDataSchema = z.object({
  query: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const remindersListResponseSchema = z.object({
  ok: defsOkTrueSchema,
  reminders: z.array(objsReminderSchema),
});

export const remindersListErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const rtmConnectDataSchema = z.object({
  query: z.object({
    batch_presence_aware: z.boolean().optional(),
    presence_sub: z.boolean().optional(),
    token: z.string(),
  }),
});

export const rtmConnectResponseSchema = z.object({
  ok: defsOkTrueSchema,
  self: z.object({
    id: defsUserIdSchema,
    name: z.string(),
  }),
  team: z.object({
    domain: z.string(),
    id: defsTeamSchema,
    name: z.string(),
  }),
  url: z.string(),
});

export const rtmConnectErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const searchMessagesDataSchema = z.object({
  query: z.object({
    count: z.number().optional(),
    highlight: z.boolean().optional(),
    page: z.number().optional(),
    query: z.string(),
    sort: z.string().optional(),
    sort_dir: z.string().optional(),
    token: z.string(),
  }),
});

export const searchMessagesResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const searchMessagesErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const starsAddDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
      file: z.string().optional(),
      file_comment: z.string().optional(),
      timestamp: z.string().optional(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const starsAddResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const starsAddErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('bad_timestamp'),
    z.literal('message_not_found'),
    z.literal('file_not_found'),
    z.literal('file_comment_not_found'),
    z.literal('channel_not_found'),
    z.literal('no_item_specified'),
    z.literal('already_starred'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const starsListDataSchema = z.object({
  query: z
    .object({
      count: z.string().optional(),
      cursor: z.string().optional(),
      limit: z.number().optional(),
      page: z.string().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const starsListResponseSchema = z.object({
  items: z.array(z.unknown()),
  ok: defsOkTrueSchema,
  paging: objsPagingSchema.optional(),
});

export const starsListErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const starsRemoveDataSchema = z.object({
  body: z
    .object({
      channel: z.string().optional(),
      file: z.string().optional(),
      file_comment: z.string().optional(),
      timestamp: z.string().optional(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const starsRemoveResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const starsRemoveErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('bad_timestamp'),
    z.literal('message_not_found'),
    z.literal('file_not_found'),
    z.literal('file_comment_not_found'),
    z.literal('channel_not_found'),
    z.literal('no_item_specified'),
    z.literal('not_starred'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const teamAccessLogsDataSchema = z.object({
  query: z.object({
    before: z.string().optional(),
    count: z.string().optional(),
    page: z.string().optional(),
    token: z.string(),
  }),
});

export const teamAccessLogsResponseSchema = z.object({
  logins: z.array(
    z.object({
      count: z.number(),
      country: z.string().nullable(),
      date_first: z.number(),
      date_last: z.number(),
      ip: z.string().nullable(),
      isp: z.string().nullable(),
      region: z.string().nullable(),
      user_agent: z.string(),
      user_id: defsUserIdSchema,
      username: z.string(),
    }),
  ),
  ok: defsOkTrueSchema,
  paging: objsPagingSchema,
});

export const teamAccessLogsErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('paid_only'),
    z.literal('over_pagination_limit'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const teamBillableInfoDataSchema = z.object({
  query: z.object({
    token: z.string(),
    user: z.string().optional(),
  }),
});

export const teamBillableInfoResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const teamBillableInfoErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const teamInfoDataSchema = z.object({
  query: z.object({
    team: z.string().optional(),
    token: z.string(),
  }),
});

export const teamInfoResponseSchema = z.object({
  ok: defsOkTrueSchema,
  team: objsTeamSchema,
});

export const teamInfoErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const teamIntegrationLogsDataSchema = z.object({
  query: z.object({
    app_id: z.string().optional(),
    change_type: z.string().optional(),
    count: z.string().optional(),
    page: z.string().optional(),
    service_id: z.string().optional(),
    token: z.string(),
    user: z.string().optional(),
  }),
});

export const teamIntegrationLogsResponseSchema = z.object({
  logs: z.array(
    z.object({
      admin_app_id: defsAppIdSchema.optional(),
      app_id: defsAppIdSchema,
      app_type: z.string(),
      change_type: z.string(),
      channel: defsChannelSchema.optional(),
      date: z.string(),
      scope: z.string(),
      service_id: z.string().optional(),
      service_type: z.string().optional(),
      user_id: defsUserIdSchema,
      user_name: z.string(),
    }),
  ),
  ok: defsOkTrueSchema,
  paging: objsPagingSchema,
});

export const teamIntegrationLogsErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const teamProfileGetDataSchema = z.object({
  query: z.object({
    token: z.string(),
    visibility: z.string().optional(),
  }),
});

export const teamProfileGetResponseSchema = z.object({
  ok: defsOkTrueSchema,
  profile: z.object({
    fields: z.array(objsTeamProfileFieldSchema),
  }),
});

export const teamProfileGetErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_typ'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeou'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const usergroupsCreateDataSchema = z.object({
  body: z
    .object({
      channels: z.string().optional(),
      description: z.string().optional(),
      handle: z.string().optional(),
      include_count: z.boolean().optional(),
      name: z.string(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const usergroupsCreateResponseSchema = z.object({
  ok: defsOkTrueSchema,
  usergroup: objsSubteamSchema,
});

export const usergroupsCreateErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('permission_denied'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const usergroupsDisableDataSchema = z.object({
  body: z
    .object({
      include_count: z.boolean().optional(),
      usergroup: z.string(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const usergroupsDisableResponseSchema = z.object({
  ok: defsOkTrueSchema,
  usergroup: objsSubteamSchema,
});

export const usergroupsDisableErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('permission_denied'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const usergroupsEnableDataSchema = z.object({
  body: z
    .object({
      include_count: z.boolean().optional(),
      usergroup: z.string(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const usergroupsEnableResponseSchema = z.object({
  ok: defsOkTrueSchema,
  usergroup: objsSubteamSchema,
});

export const usergroupsEnableErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_require'),
    z.literal('fatal_error'),
    z.literal('missing_charset'),
    z.literal('superfluous_charset'),
  ]),
  ok: defsOkFalseSchema,
});

export const usergroupsListDataSchema = z.object({
  query: z.object({
    include_count: z.boolean().optional(),
    include_disabled: z.boolean().optional(),
    include_users: z.boolean().optional(),
    token: z.string(),
  }),
});

export const usergroupsListResponseSchema = z.object({
  ok: defsOkTrueSchema,
  usergroups: z.array(objsSubteamSchema),
});

export const usergroupsListErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_require'),
    z.literal('fatal_error'),
    z.literal('missing_charset'),
    z.literal('superfluous_charset'),
  ]),
  ok: defsOkFalseSchema,
});

export const usergroupsUpdateDataSchema = z.object({
  body: z
    .object({
      channels: z.string().optional(),
      description: z.string().optional(),
      handle: z.string().optional(),
      include_count: z.boolean().optional(),
      name: z.string().optional(),
      usergroup: z.string(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const usergroupsUpdateResponseSchema = z.object({
  ok: defsOkTrueSchema,
  usergroup: objsSubteamSchema,
});

export const usergroupsUpdateErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('permission_denied'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_require'),
    z.literal('fatal_error'),
    z.literal('missing_charset'),
    z.literal('superfluous_charset'),
  ]),
  ok: defsOkFalseSchema,
});

export const usergroupsUsersListDataSchema = z.object({
  query: z.object({
    include_disabled: z.boolean().optional(),
    token: z.string(),
    usergroup: z.string(),
  }),
});

export const usergroupsUsersListResponseSchema = z.object({
  ok: defsOkTrueSchema,
  users: z.array(defsUserIdSchema),
});

export const usergroupsUsersListErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_require'),
    z.literal('fatal_error'),
    z.literal('missing_charset'),
    z.literal('superfluous_charset'),
  ]),
  ok: defsOkFalseSchema,
});

export const usergroupsUsersUpdateDataSchema = z.object({
  body: z
    .object({
      include_count: z.boolean().optional(),
      usergroup: z.string(),
      users: z.string(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const usergroupsUsersUpdateResponseSchema = z.object({
  ok: defsOkTrueSchema,
  usergroup: objsSubteamSchema,
});

export const usergroupsUsersUpdateErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('permission_denied'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('user_is_restricted'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_require'),
    z.literal('fatal_error'),
    z.literal('missing_charset'),
    z.literal('superfluous_charset'),
  ]),
  ok: defsOkFalseSchema,
});

export const usersConversationsDataSchema = z.object({
  query: z
    .object({
      cursor: z.string().optional(),
      exclude_archived: z.boolean().optional(),
      limit: z.number().optional(),
      token: z.string().optional(),
      types: z.string().optional(),
      user: z.string().optional(),
    })
    .optional(),
});

export const usersConversationsResponseSchema = z
  .record(z.union([z.unknown(), objsConversationSchema, defsOkTrueSchema]))
  .and(
    z.object({
      channels: z.array(objsConversationSchema),
      ok: defsOkTrueSchema,
      response_metadata: z
        .object({
          next_cursor: z.string(),
        })
        .optional(),
    }),
  );

export const usersConversationsErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('method_not_supported_for_channel_type'),
    z.literal('missing_scope'),
    z.literal('invalid_types'),
    z.literal('invalid_cursor'),
    z.literal('invalid_limit'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const usersDeletePhotoDataSchema = z.object({
  body: z.object({
    token: z.string(),
  }),
});

export const usersDeletePhotoResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const usersDeletePhotoErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const usersGetPresenceDataSchema = z.object({
  query: z.object({
    token: z.string(),
    user: z.string().optional(),
  }),
});

export const usersGetPresenceResponseSchema = z
  .record(z.union([z.unknown(), z.boolean(), z.number(), defsOkTrueSchema, z.string()]))
  .and(
    z.object({
      auto_away: z.boolean().optional(),
      connection_count: z.number().optional(),
      last_activity: z.number().optional(),
      manual_away: z.boolean().optional(),
      ok: defsOkTrueSchema,
      online: z.boolean().optional(),
      presence: z.string(),
    }),
  );

export const usersGetPresenceErrorSchema = z
  .record(z.union([z.union([z.unknown(), z.string(), defsOkFalseSchema]), z.undefined()]))
  .and(
    z.object({
      error: z.string(),
      ok: defsOkFalseSchema,
    }),
  );

export const usersIdentityDataSchema = z.object({
  query: z
    .object({
      token: z.string().optional(),
    })
    .optional(),
});

export const usersIdentityResponseSchema = z.unknown();

export const usersIdentityErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const usersInfoDataSchema = z.object({
  query: z.object({
    include_locale: z.boolean().optional(),
    token: z.string(),
    user: z.string().optional(),
  }),
});

export const usersInfoResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema, objsUserSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
    user: objsUserSchema,
  }),
);

export const usersInfoErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('user_not_found'),
    z.literal('user_not_visible'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
  ]),
  ok: defsOkFalseSchema,
});

export const usersListDataSchema = z.object({
  query: z
    .object({
      cursor: z.string().optional(),
      include_locale: z.boolean().optional(),
      limit: z.number().optional(),
      token: z.string().optional(),
    })
    .optional(),
});

export const usersListResponseSchema = z.object({
  cache_ts: z.number(),
  members: z.array(objsUserSchema),
  ok: defsOkTrueSchema,
  response_metadata: objsResponseMetadataSchema.optional(),
});

export const usersListErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('limit_required'),
    z.literal('invalid_cursor'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const usersLookupByEmailDataSchema = z.object({
  query: z.object({
    email: z.string(),
    token: z.string(),
  }),
});

export const usersLookupByEmailResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema, objsUserSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
    user: objsUserSchema,
  }),
);

export const usersLookupByEmailErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('users_not_found'),
    z.literal('enterprise_is_restricted'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('no_permission'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const usersProfileGetDataSchema = z.object({
  query: z.object({
    include_labels: z.boolean().optional(),
    token: z.string(),
    user: z.string().optional(),
  }),
});

export const usersProfileGetResponseSchema = z.object({
  ok: defsOkTrueSchema,
  profile: objsUserProfileSchema,
});

export const usersProfileGetErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('user_not_found'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const usersProfileSetDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
      profile: z.string().optional(),
      user: z.string().optional(),
      value: z.string().optional(),
    })
    .optional(),
  headers: z.object({
    token: z.string(),
  }),
});

export const usersProfileSetResponseSchema = z.object({
  email_pending: z.string().optional(),
  ok: defsOkTrueSchema,
  profile: objsUserProfileSchema,
  username: z.string(),
});

export const usersProfileSetErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('reserved_name'),
    z.literal('invalid_profile'),
    z.literal('profile_set_failed'),
    z.literal('not_admin'),
    z.literal('not_app_admin'),
    z.literal('cannot_update_admin_user'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const usersSetActiveDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
});

export const usersSetActiveResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const usersSetActiveErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('ekm_access_denied'),
    z.literal('missing_scope'),
    z.literal('invalid_arguments'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('request_timeout'),
    z.literal('fatal_error'),
    z.literal('internal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const usersSetPhotoDataSchema = z.object({
  body: z.object({
    crop_w: z.string().optional(),
    crop_x: z.string().optional(),
    crop_y: z.string().optional(),
    image: z.string().optional(),
    token: z.string(),
  }),
});

export const usersSetPhotoResponseSchema = z.object({
  ok: defsOkTrueSchema,
  profile: z.object({
    avatar_hash: z.string(),
    image_1024: z.string(),
    image_192: z.string(),
    image_24: z.string(),
    image_32: z.string(),
    image_48: z.string(),
    image_512: z.string(),
    image_72: z.string(),
    image_original: z.string(),
  }),
});

export const usersSetPhotoErrorSchema = z.object({
  callstack: z.string().optional(),
  debug_step: z.string().optional(),
  dims: z.string().optional(),
  error: z.union([
    z.literal('bad_image'),
    z.literal('too_large'),
    z.literal('too_many_frames'),
    z.literal('not_found'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('user_is_bot'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
  time_ident: z.number().optional(),
});

export const usersSetPresenceDataSchema = z.object({
  body: z.object({
    presence: z.string(),
  }),
  headers: z.object({
    token: z.string(),
  }),
});

export const usersSetPresenceResponseSchema = z.object({
  ok: defsOkTrueSchema,
});

export const usersSetPresenceErrorSchema = z.object({
  callstack: z.string().optional(),
  error: z.union([
    z.literal('invalid_presence'),
    z.literal('not_authed'),
    z.literal('invalid_auth'),
    z.literal('account_inactive'),
    z.literal('token_revoked'),
    z.literal('no_permission'),
    z.literal('org_login_required'),
    z.literal('invalid_arg_name'),
    z.literal('invalid_array_arg'),
    z.literal('invalid_charset'),
    z.literal('invalid_form_data'),
    z.literal('invalid_post_type'),
    z.literal('missing_post_type'),
    z.literal('team_added_to_org'),
    z.literal('invalid_json'),
    z.literal('json_not_object'),
    z.literal('request_timeout'),
    z.literal('upgrade_required'),
    z.literal('fatal_error'),
  ]),
  ok: defsOkFalseSchema,
});

export const viewsOpenDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    trigger_id: z.string(),
    view: z.string(),
  }),
});

export const viewsOpenResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const viewsOpenErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const viewsPublishDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    hash: z.string().optional(),
    user_id: z.string(),
    view: z.string(),
  }),
});

export const viewsPublishResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const viewsPublishErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const viewsPushDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    trigger_id: z.string(),
    view: z.string(),
  }),
});

export const viewsPushResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const viewsPushErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const viewsUpdateDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z
    .object({
      external_id: z.string().optional(),
      hash: z.string().optional(),
      view: z.string().optional(),
      view_id: z.string().optional(),
    })
    .optional(),
});

export const viewsUpdateResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const viewsUpdateErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const workflowsStepCompletedDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    outputs: z.string().optional(),
    workflow_step_execute_id: z.string(),
  }),
});

export const workflowsStepCompletedResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const workflowsStepCompletedErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const workflowsStepFailedDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    error: z.string(),
    workflow_step_execute_id: z.string(),
  }),
});

export const workflowsStepFailedResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const workflowsStepFailedErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const workflowsUpdateStepDataSchema = z.object({
  headers: z.object({
    token: z.string(),
  }),
  query: z.object({
    inputs: z.string().optional(),
    outputs: z.string().optional(),
    step_image_url: z.string().optional(),
    step_name: z.string().optional(),
    workflow_step_edit_id: z.string(),
  }),
});

export const workflowsUpdateStepResponseSchema = z.record(z.union([z.unknown(), defsOkTrueSchema])).and(
  z.object({
    ok: defsOkTrueSchema,
  }),
);

export const workflowsUpdateStepErrorSchema = z.record(z.union([z.unknown(), defsOkFalseSchema])).and(
  z.object({
    ok: defsOkFalseSchema,
  }),
);

export const chatPostMessageResponseSchema = z.object({
  channel: defsChannelSchema,
  message: objsMessageSchema,
  ok: defsOkTrueSchema,
  ts: defsTsSchema,
});
