// This file is auto-generated by @hey-api/openapi-ts

/**
 * This is a very loose definition, in the future, we'll populate this with deeper schema in this definition namespace.
 */
export type blocks = Array<{
  type: string;
  [key: string]: unknown | string;
}>;

export type defs_app_id = string;

export type defs_bot_id = string;

export type defs_channel = string;

export type defs_channel_id = string;

export type defs_channel_name = string;

export type defs_comment_id = string;

export type defs_dm_id = string;

export type defs_enterprise_id = string;

export type defs_enterprise_name = string;

export type defs_enterprise_user_id = string;

export type defs_file_id = string;

export type defs_group_id = string;

export type defs_ok_false = boolean;

export type defs_ok_true = boolean;

export type defs_optional_app_id = string;

export type defs_pinned_info = {
  [key: string]: unknown;
};

export type defs_reminder_id = string;

export type defs_subteam_id = string;

export type defs_team = string;

export type defs_topic_purpose_creator = string;

export type defs_ts = string;

export type defs_user_id = string;

export type defs_workspace_id = string;

export type objs_bot_profile = {
  app_id: defs_app_id;
  deleted: boolean;
  icons: {
    image_36: string;
    image_48: string;
    image_72: string;
  };
  id: defs_bot_id;
  name: string;
  team_id: defs_team;
  updated: number;
};

export type objs_channel = {
  accepted_user?: defs_user_id;
  created: number;
  creator: defs_user_id;
  id: defs_channel_id;
  is_archived?: boolean;
  is_channel: boolean;
  is_frozen?: boolean;
  is_general?: boolean;
  is_member?: boolean;
  is_moved?: number;
  is_mpim: boolean;
  is_non_threadable?: boolean;
  is_org_shared: boolean;
  is_pending_ext_shared?: boolean;
  is_private: boolean;
  is_read_only?: boolean;
  is_shared: boolean;
  is_thread_only?: boolean;
  last_read?: defs_ts;
  latest?: unknown;
  members: Array<defs_user_id>;
  name: string;
  name_normalized: string;
  num_members?: number;
  pending_shared?: Array<defs_team>;
  previous_names?: Array<defs_channel_name>;
  priority?: number;
  purpose: {
    creator: defs_topic_purpose_creator;
    last_set: number;
    value: string;
  };
  topic: {
    creator: defs_topic_purpose_creator;
    last_set: number;
    value: string;
  };
  unlinked?: number;
  unread_count?: number;
  unread_count_display?: number;
};

export type objs_comment = {
  comment: string;
  created: number;
  id: defs_comment_id;
  is_intro: boolean;
  is_starred?: boolean;
  num_stars?: number;
  pinned_info?: defs_pinned_info;
  pinned_to?: Array<defs_channel>;
  reactions?: Array<objs_reaction>;
  timestamp: number;
  user: defs_user_id;
};

export type objs_comments = Array<unknown>;

export type objs_conversation = unknown;

export type objs_enterprise_user = {
  enterprise_id: defs_enterprise_id;
  enterprise_name: defs_enterprise_name;
  id: defs_enterprise_user_id;
  is_admin: boolean;
  is_owner: boolean;
  teams: Array<defs_team>;
};

export type objs_external_org_migrations = {
  current: Array<{
    date_started: number;
    team_id: string;
  }>;
  date_updated: number;
};

export type objs_file = {
  channels?: Array<defs_channel_id>;
  comments_count?: number;
  created?: number;
  date_delete?: number;
  display_as_bot?: boolean;
  editable?: boolean;
  editor?: defs_user_id;
  external_id?: string;
  external_type?: string;
  external_url?: string;
  filetype?: string;
  groups?: Array<defs_group_id>;
  has_rich_preview?: boolean;
  id?: defs_file_id;
  image_exif_rotation?: number;
  ims?: Array<defs_dm_id>;
  is_external?: boolean;
  is_public?: boolean;
  is_starred?: boolean;
  is_tombstoned?: boolean;
  last_editor?: defs_user_id;
  mimetype?: string;
  mode?: string;
  name?: string;
  non_owner_editable?: boolean;
  num_stars?: number;
  original_h?: number;
  original_w?: number;
  permalink?: string;
  permalink_public?: string;
  pinned_info?: defs_pinned_info;
  pinned_to?: Array<defs_channel>;
  pretty_type?: string;
  preview?: string;
  public_url_shared?: boolean;
  reactions?: Array<objs_reaction>;
  shares?: {
    private?: unknown;
    public?: unknown;
  };
  size?: number;
  source_team?: defs_team;
  state?: string;
  thumb_1024?: string;
  thumb_1024_h?: number;
  thumb_1024_w?: number;
  thumb_160?: string;
  thumb_360?: string;
  thumb_360_h?: number;
  thumb_360_w?: number;
  thumb_480?: string;
  thumb_480_h?: number;
  thumb_480_w?: number;
  thumb_64?: string;
  thumb_720?: string;
  thumb_720_h?: number;
  thumb_720_w?: number;
  thumb_80?: string;
  thumb_800?: string;
  thumb_800_h?: number;
  thumb_800_w?: number;
  thumb_960?: string;
  thumb_960_h?: number;
  thumb_960_w?: number;
  thumb_tiny?: string;
  timestamp?: number;
  title?: string;
  updated?: number;
  url_private?: string;
  url_private_download?: string;
  user?: string;
  user_team?: defs_team;
  username?: string;
};

export type objs_icon = {
  image_102?: string;
  image_132?: string;
  image_230?: string;
  image_34?: string;
  image_44?: string;
  image_68?: string;
  image_88?: string;
  image_default?: boolean;
};

export type objs_message = {
  attachments?: Array<{
    fallback?: string;
    id: number;
    image_bytes?: number;
    image_height?: number;
    image_url?: string;
    image_width?: number;
  }>;
  blocks?: blocks;
  bot_id?: unknown;
  bot_profile?: objs_bot_profile;
  client_msg_id?: string;
  comment?: objs_comment;
  display_as_bot?: boolean;
  file?: objs_file;
  files?: Array<objs_file>;
  icons?: {
    emoji?: string;
    image_64?: string;
  };
  inviter?: defs_user_id;
  is_delayed_message?: boolean;
  is_intro?: boolean;
  is_starred?: boolean;
  last_read?: defs_ts;
  latest_reply?: defs_ts;
  name?: string;
  old_name?: string;
  parent_user_id?: defs_user_id;
  permalink?: string;
  pinned_to?: Array<defs_channel>;
  purpose?: string;
  reactions?: Array<objs_reaction>;
  reply_count?: number;
  reply_users?: Array<defs_user_id>;
  reply_users_count?: number;
  source_team?: defs_workspace_id;
  subscribed?: boolean;
  subtype?: string;
  team?: defs_workspace_id;
  text: string;
  thread_ts?: defs_ts;
  topic?: string;
  ts: defs_ts;
  type: string;
  unread_count?: number;
  upload?: boolean;
  user?: defs_user_id;
  user_profile?: objs_user_profile_short;
  user_team?: defs_workspace_id;
  username?: string;
};

export type objs_paging = {
  count?: number;
  page: number;
  pages?: number;
  per_page?: number;
  spill?: number;
  total: number;
};

export type objs_primary_owner = {
  email: string;
  id: string;
};

export type objs_reaction = {
  count: number;
  name: string;
  users: Array<defs_user_id>;
  [key: string]: unknown | number | string | defs_user_id;
};

export type objs_reminder = {
  complete_ts?: number;
  creator: defs_user_id;
  id: defs_reminder_id;
  recurring: boolean;
  text: string;
  time?: number;
  user: defs_user_id;
};

export type objs_resources = {
  excluded_ids?: Array<unknown>;
  ids: Array<unknown>;
  wildcard?: boolean;
};

export type objs_response_metadata = unknown;

export type objs_scopes = Array<string>;

export type objs_subteam = {
  auto_provision: boolean;
  auto_type: unknown;
  channel_count?: number;
  created_by: defs_user_id;
  date_create: number;
  date_delete: number;
  date_update: number;
  deleted_by: unknown;
  description: string;
  enterprise_subteam_id: string;
  handle: string;
  id: defs_subteam_id;
  is_external: boolean;
  is_subteam: boolean;
  is_usergroup: boolean;
  name: string;
  prefs: {
    channels: Array<defs_channel_id>;
    groups: Array<defs_group_id>;
  };
  team_id: defs_team;
  updated_by: defs_user_id;
  user_count?: number;
  users?: Array<defs_user_id>;
};

export type objs_team = {
  archived?: boolean;
  avatar_base_url?: string;
  created?: number;
  date_create?: number;
  deleted?: boolean;
  description?: string | null;
  discoverable?: unknown;
  domain: string;
  email_domain: string;
  enterprise_id?: defs_enterprise_id;
  enterprise_name?: defs_enterprise_name;
  external_org_migrations?: objs_external_org_migrations;
  has_compliance_export?: boolean;
  icon: objs_icon;
  id: defs_workspace_id;
  is_assigned?: boolean;
  is_enterprise?: number;
  is_over_storage_limit?: boolean;
  limit_ts?: number;
  locale?: string;
  messages_count?: number;
  msg_edit_window_mins?: number;
  name: string;
  over_integrations_limit?: boolean;
  over_storage_limit?: boolean;
  pay_prod_cur?: string;
  plan?: '' | 'std' | 'plus' | 'compliance' | 'enterprise';
  primary_owner?: objs_primary_owner;
  sso_provider?: {
    label?: string;
    name?: string;
    type?: string;
  };
};

export type plan = '' | 'std' | 'plus' | 'compliance' | 'enterprise';

export type objs_team_profile_field = {
  field_name?: string | null;
  hint: string;
  id: string;
  is_hidden?: boolean;
  label: string;
  options?: unknown;
  ordering: number;
  possible_values?: Array<string> | null;
  type: 'text' | 'date' | 'link' | 'mailto' | 'options_list' | 'user';
};

export type type = 'text' | 'date' | 'link' | 'mailto' | 'options_list' | 'user';

export type objs_team_profile_field_option = {
  is_custom?: boolean | null;
  is_multiple_entry?: boolean | null;
  is_protected?: boolean | null;
  is_scim?: boolean | null;
};

export type objs_user = unknown;

export type objs_user_profile = {
  always_active?: boolean;
  api_app_id?: defs_optional_app_id;
  avatar_hash: string;
  bot_id?: defs_bot_id;
  display_name: string;
  display_name_normalized: string;
  email?: string | null;
  fields:
    | (
        | {
            [key: string]: unknown;
          }
        | Array<unknown>
      )
    | null;
  first_name?: string | null;
  guest_expiration_ts?: number | null;
  guest_invited_by?: string | null;
  image_1024?: string | null;
  image_192?: string | null;
  image_24?: string | null;
  image_32?: string | null;
  image_48?: string | null;
  image_512?: string | null;
  image_72?: string | null;
  image_original?: string | null;
  is_app_user?: boolean;
  is_custom_image?: boolean;
  is_restricted?: boolean | null;
  is_ultra_restricted?: boolean | null;
  last_avatar_image_hash?: string;
  last_name?: string | null;
  memberships_count?: number;
  name?: string | null;
  phone: string;
  pronouns?: string;
  real_name: string;
  real_name_normalized: string;
  skype: string;
  status_default_emoji?: string;
  status_default_text?: string;
  status_default_text_canonical?: string | null;
  status_emoji: string;
  status_expiration?: number;
  status_text: string;
  status_text_canonical?: string | null;
  team?: defs_workspace_id;
  title: string;
  updated?: number;
  user_id?: string;
  username?: string | null;
};

export type objs_user_profile_short = {
  avatar_hash: string;
  display_name: string;
  display_name_normalized?: string;
  first_name: string | null;
  image_72: string;
  is_restricted: boolean;
  is_ultra_restricted: boolean;
  name: string;
  real_name: string;
  real_name_normalized?: string;
  team: defs_workspace_id;
};

export type AdminAppsApproveData = {
  body?: {
    /**
     * The id of the app to approve.
     */
    app_id?: string;
    /**
     * The id of the request to approve.
     */
    request_id?: string;
    team_id?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.apps:write`
     */
    token: string;
  };
};

export type AdminAppsApproveResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminAppsApproveError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminAppsApprovedListData = {
  query: {
    /**
     * Set `cursor` to `next_cursor` returned by the previous call to list items in the next page
     */
    cursor?: string;
    enterprise_id?: string;
    /**
     * The maximum number of items to return. Must be between 1 - 1000 both inclusive.
     */
    limit?: number;
    team_id?: string;
    /**
     * Authentication token. Requires scope: `admin.apps:read`
     */
    token: string;
  };
};

export type AdminAppsApprovedListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminAppsApprovedListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminAppsRequestsListData = {
  query: {
    /**
     * Set `cursor` to `next_cursor` returned by the previous call to list items in the next page
     */
    cursor?: string;
    /**
     * The maximum number of items to return. Must be between 1 - 1000 both inclusive.
     */
    limit?: number;
    team_id?: string;
    /**
     * Authentication token. Requires scope: `admin.apps:read`
     */
    token: string;
  };
};

export type AdminAppsRequestsListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminAppsRequestsListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminAppsRestrictData = {
  body?: {
    /**
     * The id of the app to restrict.
     */
    app_id?: string;
    /**
     * The id of the request to restrict.
     */
    request_id?: string;
    team_id?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.apps:write`
     */
    token: string;
  };
};

export type AdminAppsRestrictResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminAppsRestrictError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminAppsRestrictedListData = {
  query: {
    /**
     * Set `cursor` to `next_cursor` returned by the previous call to list items in the next page
     */
    cursor?: string;
    enterprise_id?: string;
    /**
     * The maximum number of items to return. Must be between 1 - 1000 both inclusive.
     */
    limit?: number;
    team_id?: string;
    /**
     * Authentication token. Requires scope: `admin.apps:read`
     */
    token: string;
  };
};

export type AdminAppsRestrictedListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminAppsRestrictedListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminConversationsArchiveData = {
  body: {
    /**
     * The channel to archive.
     */
    channel_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:write`
     */
    token: string;
  };
};

export type AdminConversationsArchiveResponse = {
  ok: defs_ok_true;
};

export type AdminConversationsArchiveError = {
  error:
    | 'feature_not_enabled'
    | 'channel_not_found'
    | 'channel_type_not_supported'
    | 'default_org_wide_channel'
    | 'already_archived'
    | 'cant_archive_general'
    | 'restricted_action'
    | 'could_not_archive_channel';
  ok: defs_ok_false;
};

export type AdminConversationsConvertToPrivateData = {
  body: {
    /**
     * The channel to convert to private.
     */
    channel_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:write`
     */
    token: string;
  };
};

export type AdminConversationsConvertToPrivateResponse = {
  ok: defs_ok_true;
};

export type AdminConversationsConvertToPrivateError = {
  error:
    | 'feature_not_enabled'
    | 'restricted_action'
    | 'name_taken'
    | 'channel_not_found'
    | 'channel_type_not_supported'
    | 'default_org_wide_channel'
    | 'method_not_supported_for_channel_type'
    | 'could_not_convert_channel'
    | 'external_channel_migrating';
  ok: defs_ok_false;
};

export type AdminConversationsCreateData = {
  body: {
    /**
     * Description of the public or private channel to create.
     */
    description?: string;
    /**
     * When `true`, creates a private channel instead of a public channel
     */
    is_private: boolean;
    /**
     * Name of the public or private channel to create.
     */
    name: string;
    /**
     * When `true`, the channel will be available org-wide. Note: if the channel is not `org_wide=true`, you must specify a `team_id` for this channel
     */
    org_wide?: boolean;
    /**
     * The workspace to create the channel in. Note: this argument is required unless you set `org_wide=true`.
     */
    team_id?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:write`
     */
    token: string;
  };
};

export type AdminConversationsCreateResponse = {
  channel_id?: defs_channel_id;
  ok: defs_ok_true;
};

export type AdminConversationsCreateError = {
  error:
    | 'feature_not_enabled'
    | 'name_taken'
    | 'restricted_action'
    | 'team_not_found'
    | 'invalid_team'
    | 'invalid_name'
    | 'could_not_create_channel'
    | 'team_id_or_org_required';
  ok: defs_ok_false;
};

export type AdminConversationsDeleteData = {
  body: {
    /**
     * The channel to delete.
     */
    channel_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:write`
     */
    token: string;
  };
};

export type AdminConversationsDeleteResponse = {
  ok: defs_ok_true;
};

export type AdminConversationsDeleteError = {
  error:
    | 'feature_not_enabled'
    | 'not_an_admin'
    | 'channel_not_found'
    | 'channel_type_not_supported'
    | 'default_org_wide_channel'
    | 'restricted_action'
    | 'could_not_delete_channel'
    | 'missing_scope';
  ok: defs_ok_false;
};

export type AdminConversationsDisconnectSharedData = {
  body: {
    /**
     * The channel to be disconnected from some workspaces.
     */
    channel_id: string;
    /**
     * The team to be removed from the channel. Currently only a single team id can be specified.
     */
    leaving_team_ids?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:write`
     */
    token: string;
  };
};

export type AdminConversationsDisconnectSharedResponse = {
  ok: defs_ok_true;
};

export type AdminConversationsDisconnectSharedError = {
  error:
    | 'feature_not_enabled'
    | 'not_an_admin'
    | 'not_an_enterprise'
    | 'channel_not_found'
    | 'not_supported'
    | 'team_not_found'
    | 'restricted_action'
    | 'missing_scope'
    | 'leaving_team_not_in_channel'
    | 'no_teams_to_disconnect'
    | 'leaving_team_required'
    | 'cannot_kick_team'
    | 'cannot_kick_home_team';
  ok: defs_ok_false;
};

export type AdminConversationsEkmListOriginalConnectedChannelInfoData = {
  query: {
    /**
     * A comma-separated list of channels to filter to.
     */
    channel_ids?: string;
    /**
     * Set `cursor` to `next_cursor` returned by the previous call to list items in the next page.
     */
    cursor?: string;
    /**
     * The maximum number of items to return. Must be between 1 - 1000 both inclusive.
     */
    limit?: number;
    /**
     * A comma-separated list of the workspaces to which the channels you would like returned belong.
     */
    team_ids?: string;
    /**
     * Authentication token. Requires scope: `admin.conversations:read`
     */
    token: string;
  };
};

export type AdminConversationsEkmListOriginalConnectedChannelInfoResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminConversationsEkmListOriginalConnectedChannelInfoError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminConversationsGetConversationPrefsData = {
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:read`
     */
    token: string;
  };
  query: {
    /**
     * The channel to get preferences for.
     */
    channel_id: string;
  };
};

export type AdminConversationsGetConversationPrefsResponse = {
  ok: defs_ok_true;
  prefs?: {
    can_thread?: {
      type?: Array<string>;
      user?: Array<string>;
    };
    who_can_post?: {
      type?: Array<string>;
      user?: Array<string>;
    };
  };
};

export type AdminConversationsGetConversationPrefsError = {
  error:
    | 'feature_not_enabled'
    | 'not_an_admin'
    | 'not_an_enterprise'
    | 'restricted_action'
    | 'missing_scope'
    | 'channel_not_found'
    | 'channel_type_not_supported'
    | 'could_not_get_conversation_prefs';
  ok: defs_ok_false;
};

export type AdminConversationsGetTeamsData = {
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:read`
     */
    token: string;
  };
  query: {
    /**
     * The channel to determine connected workspaces within the organization for.
     */
    channel_id: string;
    /**
     * Set `cursor` to `next_cursor` returned by the previous call to list items in the next page
     */
    cursor?: string;
    /**
     * The maximum number of items to return. Must be between 1 - 1000 both inclusive.
     */
    limit?: number;
  };
};

export type AdminConversationsGetTeamsResponse = {
  ok: defs_ok_true;
  response_metadata?: {
    next_cursor: string;
  };
  team_ids: Array<defs_team>;
};

export type AdminConversationsGetTeamsError = {
  error:
    | 'feature_not_enabled'
    | 'channel_not_found'
    | 'channel_type_not_supported'
    | 'unsupported_team_type'
    | 'restricted_action'
    | 'could_not_get_teams'
    | 'invalid_cursor'
    | 'invalid_limit';
  ok: defs_ok_false;
};

export type AdminConversationsInviteData = {
  body: {
    /**
     * The channel that the users will be invited to.
     */
    channel_id: string;
    /**
     * The users to invite.
     */
    user_ids: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:write`
     */
    token: string;
  };
};

export type AdminConversationsInviteResponse = {
  ok: defs_ok_true;
};

export type AdminConversationsInviteError = {
  error:
    | 'feature_not_enabled'
    | 'channel_not_found'
    | 'channel_type_not_supported'
    | 'default_org_wide_channel'
    | 'restricted_action'
    | 'user_must_be_admin'
    | 'failed_for_some_users';
  ok: defs_ok_false;
  [key: string]: unknown | string | defs_ok_false;
};

export type AdminConversationsRenameData = {
  body: {
    /**
     * The channel to rename.
     */
    channel_id: string;
    name: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:write`
     */
    token: string;
  };
};

export type AdminConversationsRenameResponse = {
  ok: defs_ok_true;
};

export type AdminConversationsRenameError = {
  error:
    | 'feature_not_enabled'
    | 'channel_not_found'
    | 'channel_type_not_supported'
    | 'restricted_action'
    | 'could_not_rename_channel'
    | 'default_org_wide_channel'
    | 'name_taken';
  ok: defs_ok_false;
};

export type AdminConversationsRestrictAccessAddGroupData = {
  body: {
    /**
     * The channel to link this group to.
     */
    channel_id: string;
    /**
     * The [IDP Group](https://slack.com/help/articles/115001435788-Connect-identity-provider-groups-to-your-Enterprise-Grid-org) ID to be an allowlist for the private channel.
     */
    group_id: string;
    /**
     * The workspace where the channel exists. This argument is required for channels only tied to one workspace, and optional for channels that are shared across an organization.
     */
    team_id?: string;
    /**
     * Authentication token. Requires scope: `admin.conversations:write`
     */
    token: string;
  };
};

export type AdminConversationsRestrictAccessAddGroupResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminConversationsRestrictAccessAddGroupError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminConversationsRestrictAccessListGroupsData = {
  query: {
    channel_id: string;
    /**
     * The workspace where the channel exists. This argument is required for channels only tied to one workspace, and optional for channels that are shared across an organization.
     */
    team_id?: string;
    /**
     * Authentication token. Requires scope: `admin.conversations:read`
     */
    token: string;
  };
};

export type AdminConversationsRestrictAccessListGroupsResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminConversationsRestrictAccessListGroupsError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminConversationsRestrictAccessRemoveGroupData = {
  body: {
    /**
     * The channel to remove the linked group from.
     */
    channel_id: string;
    /**
     * The [IDP Group](https://slack.com/help/articles/115001435788-Connect-identity-provider-groups-to-your-Enterprise-Grid-org) ID to remove from the private channel.
     */
    group_id: string;
    /**
     * The workspace where the channel exists. This argument is required for channels only tied to one workspace, and optional for channels that are shared across an organization.
     */
    team_id: string;
    /**
     * Authentication token. Requires scope: `admin.conversations:write`
     */
    token: string;
  };
};

export type AdminConversationsRestrictAccessRemoveGroupResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminConversationsRestrictAccessRemoveGroupError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminConversationsSearchData = {
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:read`
     */
    token: string;
  };
  query?: {
    /**
     * Set `cursor` to `next_cursor` returned by the previous call to list items in the next page.
     */
    cursor?: string;
    /**
     * Maximum number of items to be returned. Must be between 1 - 20 both inclusive. Default is 10.
     */
    limit?: number;
    /**
     * Name of the the channel to query by.
     */
    query?: string;
    /**
     * The type of channel to include or exclude in the search. For example `private` will search private channels, while `private_exclude` will exclude them. For a full list of types, check the [Types section](#types).
     */
    search_channel_types?: string;
    /**
     * Possible values are `relevant` (search ranking based on what we think is closest), `name` (alphabetical), `member_count` (number of users in the channel), and `created` (date channel was created). You can optionally pair this with the `sort_dir` arg to change how it is sorted
     */
    sort?: string;
    /**
     * Sort direction. Possible values are `asc` for ascending order like (1, 2, 3) or (a, b, c), and `desc` for descending order like (3, 2, 1) or (c, b, a)
     */
    sort_dir?: string;
    /**
     * Comma separated string of team IDs, signifying the workspaces to search through.
     */
    team_ids?: string;
  };
};

export type AdminConversationsSearchResponse = {
  channels: Array<objs_channel>;
  next_cursor: string;
};

export type AdminConversationsSearchError = {
  error:
    | 'feature_not_enabled'
    | 'not_an_admin'
    | 'not_an_enterprise'
    | 'team_not_found'
    | 'not_allowed'
    | 'invalid_auth'
    | 'invalid_cursor'
    | 'invalid_search_channel_type'
    | 'invalid_sort'
    | 'invalid_sort_dir';
  ok: defs_ok_false;
};

export type AdminConversationsSetConversationPrefsData = {
  body: {
    /**
     * The channel to set the prefs for
     */
    channel_id: string;
    /**
     * The prefs for this channel in a stringified JSON format.
     */
    prefs: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:write`
     */
    token: string;
  };
};

export type AdminConversationsSetConversationPrefsResponse = {
  ok: defs_ok_true;
};

export type AdminConversationsSetConversationPrefsError = {
  error:
    | 'feature_not_enabled'
    | 'not_an_admin'
    | 'channel_not_found'
    | 'channel_type_not_supported'
    | 'restricted_action'
    | 'missing_scope'
    | 'could_not_set_channel_pref'
    | 'default_org_wide_channel';
  ok: defs_ok_false;
};

export type AdminConversationsSetTeamsData = {
  body: {
    /**
     * The encoded `channel_id` to add or remove to workspaces.
     */
    channel_id: string;
    /**
     * True if channel has to be converted to an org channel
     */
    org_channel?: boolean;
    /**
     * A comma-separated list of workspaces to which the channel should be shared. Not required if the channel is being shared org-wide.
     */
    target_team_ids?: string;
    /**
     * The workspace to which the channel belongs. Omit this argument if the channel is a cross-workspace shared channel.
     */
    team_id?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:write`
     */
    token: string;
  };
};

export type AdminConversationsSetTeamsResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminConversationsSetTeamsError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminConversationsUnarchiveData = {
  body: {
    /**
     * The channel to unarchive.
     */
    channel_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.conversations:write`
     */
    token: string;
  };
};

export type AdminConversationsUnarchiveResponse = {
  ok: defs_ok_true;
};

export type AdminConversationsUnarchiveError = {
  error:
    | 'feature_not_enabled'
    | 'channel_not_found'
    | 'channel_not_archived'
    | 'channel_type_not_supported'
    | 'restricted_action'
    | 'could_not_unarchive_channel'
    | 'default_org_wide_channel'
    | 'missing_scope';
  ok: defs_ok_false;
};

export type AdminEmojiAddData = {
  body: {
    /**
     * The name of the emoji to be removed. Colons (`:myemoji:`) around the value are not required, although they may be included.
     */
    name: string;
    /**
     * Authentication token. Requires scope: `admin.teams:write`
     */
    token: string;
    /**
     * The URL of a file to use as an image for the emoji. Square images under 128KB and with transparent backgrounds work best.
     */
    url: string;
  };
};

export type AdminEmojiAddResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminEmojiAddError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminEmojiAddAliasData = {
  body: {
    /**
     * The alias of the emoji.
     */
    alias_for: string;
    /**
     * The name of the emoji to be aliased. Colons (`:myemoji:`) around the value are not required, although they may be included.
     */
    name: string;
    /**
     * Authentication token. Requires scope: `admin.teams:write`
     */
    token: string;
  };
};

export type AdminEmojiAddAliasResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminEmojiAddAliasError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminEmojiListData = {
  query: {
    /**
     * Set `cursor` to `next_cursor` returned by the previous call to list items in the next page
     */
    cursor?: string;
    /**
     * The maximum number of items to return. Must be between 1 - 1000 both inclusive.
     */
    limit?: number;
    /**
     * Authentication token. Requires scope: `admin.teams:read`
     */
    token: string;
  };
};

export type AdminEmojiListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminEmojiListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminEmojiRemoveData = {
  body: {
    /**
     * The name of the emoji to be removed. Colons (`:myemoji:`) around the value are not required, although they may be included.
     */
    name: string;
    /**
     * Authentication token. Requires scope: `admin.teams:write`
     */
    token: string;
  };
};

export type AdminEmojiRemoveResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminEmojiRemoveError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminEmojiRenameData = {
  body: {
    /**
     * The name of the emoji to be renamed. Colons (`:myemoji:`) around the value are not required, although they may be included.
     */
    name: string;
    /**
     * The new name of the emoji.
     */
    new_name: string;
    /**
     * Authentication token. Requires scope: `admin.teams:write`
     */
    token: string;
  };
};

export type AdminEmojiRenameResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminEmojiRenameError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminInviteRequestsApproveData = {
  body?: {
    /**
     * ID of the request to invite.
     */
    invite_request_id: string;
    /**
     * ID for the workspace where the invite request was made.
     */
    team_id?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.invites:write`
     */
    token: string;
  };
};

export type AdminInviteRequestsApproveResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminInviteRequestsApproveError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminInviteRequestsApprovedListData = {
  headers: {
    /**
     * Authentication token. Requires scope: `admin.invites:read`
     */
    token: string;
  };
  query?: {
    /**
     * Value of the `next_cursor` field sent as part of the previous API response
     */
    cursor?: string;
    /**
     * The number of results that will be returned by the API on each invocation. Must be between 1 - 1000, both inclusive
     */
    limit?: number;
    /**
     * ID for the workspace where the invite requests were made.
     */
    team_id?: string;
  };
};

export type AdminInviteRequestsApprovedListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminInviteRequestsApprovedListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminInviteRequestsDeniedListData = {
  headers: {
    /**
     * Authentication token. Requires scope: `admin.invites:read`
     */
    token: string;
  };
  query?: {
    /**
     * Value of the `next_cursor` field sent as part of the previous api response
     */
    cursor?: string;
    /**
     * The number of results that will be returned by the API on each invocation. Must be between 1 - 1000 both inclusive
     */
    limit?: number;
    /**
     * ID for the workspace where the invite requests were made.
     */
    team_id?: string;
  };
};

export type AdminInviteRequestsDeniedListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminInviteRequestsDeniedListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminInviteRequestsDenyData = {
  body?: {
    /**
     * ID of the request to invite.
     */
    invite_request_id: string;
    /**
     * ID for the workspace where the invite request was made.
     */
    team_id?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.invites:write`
     */
    token: string;
  };
};

export type AdminInviteRequestsDenyResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminInviteRequestsDenyError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminInviteRequestsListData = {
  headers: {
    /**
     * Authentication token. Requires scope: `admin.invites:read`
     */
    token: string;
  };
  query?: {
    /**
     * Value of the `next_cursor` field sent as part of the previous API response
     */
    cursor?: string;
    /**
     * The number of results that will be returned by the API on each invocation. Must be between 1 - 1000, both inclusive
     */
    limit?: number;
    /**
     * ID for the workspace where the invite requests were made.
     */
    team_id?: string;
  };
};

export type AdminInviteRequestsListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminInviteRequestsListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminTeamsAdminsListData = {
  query: {
    /**
     * Set `cursor` to `next_cursor` returned by the previous call to list items in the next page.
     */
    cursor?: string;
    /**
     * The maximum number of items to return.
     */
    limit?: number;
    team_id: string;
    /**
     * Authentication token. Requires scope: `admin.teams:read`
     */
    token: string;
  };
};

export type AdminTeamsAdminsListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminTeamsAdminsListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminTeamsCreateData = {
  body: {
    /**
     * Description for the team.
     */
    team_description?: string;
    /**
     * Who can join the team. A team's discoverability can be `open`, `closed`, `invite_only`, or `unlisted`.
     */
    team_discoverability?: string;
    /**
     * Team domain (for example, slacksoftballteam).
     */
    team_domain: string;
    /**
     * Team name (for example, Slack Softball Team).
     */
    team_name: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.teams:write`
     */
    token: string;
  };
};

export type AdminTeamsCreateResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminTeamsCreateError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminTeamsListData = {
  headers: {
    /**
     * Authentication token. Requires scope: `admin.teams:read`
     */
    token: string;
  };
  query?: {
    /**
     * Set `cursor` to `next_cursor` returned by the previous call to list items in the next page.
     */
    cursor?: string;
    /**
     * The maximum number of items to return. Must be between 1 - 100 both inclusive.
     */
    limit?: number;
  };
};

export type AdminTeamsListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminTeamsListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminTeamsOwnersListData = {
  query: {
    /**
     * Set `cursor` to `next_cursor` returned by the previous call to list items in the next page.
     */
    cursor?: string;
    /**
     * The maximum number of items to return. Must be between 1 - 1000 both inclusive.
     */
    limit?: number;
    team_id: string;
    /**
     * Authentication token. Requires scope: `admin.teams:read`
     */
    token: string;
  };
};

export type AdminTeamsOwnersListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminTeamsOwnersListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminTeamsSettingsInfoData = {
  headers: {
    /**
     * Authentication token. Requires scope: `admin.teams:read`
     */
    token: string;
  };
  query: {
    team_id: string;
  };
};

export type AdminTeamsSettingsInfoResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminTeamsSettingsInfoError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminTeamsSettingsSetDefaultChannelsData = {
  body: {
    /**
     * An array of channel IDs.
     */
    channel_ids: string;
    /**
     * ID for the workspace to set the default channel for.
     */
    team_id: string;
    /**
     * Authentication token. Requires scope: `admin.teams:write`
     */
    token: string;
  };
};

export type AdminTeamsSettingsSetDefaultChannelsResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminTeamsSettingsSetDefaultChannelsError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminTeamsSettingsSetDescriptionData = {
  body: {
    /**
     * The new description for the workspace.
     */
    description: string;
    /**
     * ID for the workspace to set the description for.
     */
    team_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.teams:write`
     */
    token: string;
  };
};

export type AdminTeamsSettingsSetDescriptionResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminTeamsSettingsSetDescriptionError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminTeamsSettingsSetDiscoverabilityData = {
  body: {
    /**
     * This workspace's discovery setting. It must be set to one of `open`, `invite_only`, `closed`, or `unlisted`.
     */
    discoverability: string;
    /**
     * The ID of the workspace to set discoverability on.
     */
    team_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.teams:write`
     */
    token: string;
  };
};

export type AdminTeamsSettingsSetDiscoverabilityResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminTeamsSettingsSetDiscoverabilityError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminTeamsSettingsSetIconData = {
  body: {
    /**
     * Image URL for the icon
     */
    image_url: string;
    /**
     * ID for the workspace to set the icon for.
     */
    team_id: string;
    /**
     * Authentication token. Requires scope: `admin.teams:write`
     */
    token: string;
  };
};

export type AdminTeamsSettingsSetIconResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminTeamsSettingsSetIconError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminTeamsSettingsSetNameData = {
  body: {
    /**
     * The new name of the workspace.
     */
    name: string;
    /**
     * ID for the workspace to set the name for.
     */
    team_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.teams:write`
     */
    token: string;
  };
};

export type AdminTeamsSettingsSetNameResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminTeamsSettingsSetNameError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsergroupsAddChannelsData = {
  body: {
    /**
     * Comma separated string of channel IDs.
     */
    channel_ids: string;
    /**
     * The workspace to add default channels in.
     */
    team_id?: string;
    /**
     * ID of the IDP group to add default channels for.
     */
    usergroup_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.usergroups:write`
     */
    token: string;
  };
};

export type AdminUsergroupsAddChannelsResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsergroupsAddChannelsError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsergroupsAddTeamsData = {
  body: {
    /**
     * When `true`, this method automatically creates new workspace accounts for the IDP group members.
     */
    auto_provision?: boolean;
    /**
     * A comma separated list of encoded team (workspace) IDs. Each workspace *MUST* belong to the organization associated with the token.
     */
    team_ids: string;
    /**
     * An encoded usergroup (IDP Group) ID.
     */
    usergroup_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.teams:write`
     */
    token: string;
  };
};

export type AdminUsergroupsAddTeamsResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsergroupsAddTeamsError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsergroupsListChannelsData = {
  headers: {
    /**
     * Authentication token. Requires scope: `admin.usergroups:read`
     */
    token: string;
  };
  query: {
    /**
     * Flag to include or exclude the count of members per channel.
     */
    include_num_members?: boolean;
    /**
     * ID of the the workspace.
     */
    team_id?: string;
    /**
     * ID of the IDP group to list default channels for.
     */
    usergroup_id: string;
  };
};

export type AdminUsergroupsListChannelsResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsergroupsListChannelsError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsergroupsRemoveChannelsData = {
  body: {
    /**
     * Comma-separated string of channel IDs
     */
    channel_ids: string;
    /**
     * ID of the IDP Group
     */
    usergroup_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.usergroups:write`
     */
    token: string;
  };
};

export type AdminUsergroupsRemoveChannelsResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsergroupsRemoveChannelsError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsersAssignData = {
  body: {
    /**
     * Comma separated values of channel IDs to add user in the new workspace.
     */
    channel_ids?: string;
    /**
     * True if user should be added to the workspace as a guest.
     */
    is_restricted?: boolean;
    /**
     * True if user should be added to the workspace as a single-channel guest.
     */
    is_ultra_restricted?: boolean;
    /**
     * The ID (`T1234`) of the workspace.
     */
    team_id: string;
    /**
     * The ID of the user to add to the workspace.
     */
    user_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.users:write`
     */
    token: string;
  };
};

export type AdminUsersAssignResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsersAssignError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsersInviteData = {
  body: {
    /**
     * A comma-separated list of `channel_id`s for this user to join. At least one channel is required.
     */
    channel_ids: string;
    /**
     * An optional message to send to the user in the invite email.
     */
    custom_message?: string;
    /**
     * The email address of the person to invite.
     */
    email: string;
    /**
     * Timestamp when guest account should be disabled. Only include this timestamp if you are inviting a guest user and you want their account to expire on a certain date.
     */
    guest_expiration_ts?: string;
    /**
     * Is this user a multi-channel guest user? (default: false)
     */
    is_restricted?: boolean;
    /**
     * Is this user a single channel guest user? (default: false)
     */
    is_ultra_restricted?: boolean;
    /**
     * Full name of the user.
     */
    real_name?: string;
    /**
     * Allow this invite to be resent in the future if a user has not signed up yet. (default: false)
     */
    resend?: boolean;
    /**
     * The ID (`T1234`) of the workspace.
     */
    team_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.users:write`
     */
    token: string;
  };
};

export type AdminUsersInviteResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsersInviteError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsersListData = {
  headers: {
    /**
     * Authentication token. Requires scope: `admin.users:read`
     */
    token: string;
  };
  query: {
    /**
     * Set `cursor` to `next_cursor` returned by the previous call to list items in the next page.
     */
    cursor?: string;
    /**
     * Limit for how many users to be retrieved per page
     */
    limit?: number;
    /**
     * The ID (`T1234`) of the workspace.
     */
    team_id: string;
  };
};

export type AdminUsersListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsersListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsersRemoveData = {
  body: {
    /**
     * The ID (`T1234`) of the workspace.
     */
    team_id: string;
    /**
     * The ID of the user to remove.
     */
    user_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.users:write`
     */
    token: string;
  };
};

export type AdminUsersRemoveResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsersRemoveError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsersSessionInvalidateData = {
  body: {
    session_id: number;
    /**
     * ID of the team that the session belongs to
     */
    team_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.users:write`
     */
    token: string;
  };
};

export type AdminUsersSessionInvalidateResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsersSessionInvalidateError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsersSessionResetData = {
  body: {
    /**
     * Only expire mobile sessions (default: false)
     */
    mobile_only?: boolean;
    /**
     * The ID of the user to wipe sessions for
     */
    user_id: string;
    /**
     * Only expire web sessions (default: false)
     */
    web_only?: boolean;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.users:write`
     */
    token: string;
  };
};

export type AdminUsersSessionResetResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsersSessionResetError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsersSetAdminData = {
  body: {
    /**
     * The ID (`T1234`) of the workspace.
     */
    team_id: string;
    /**
     * The ID of the user to designate as an admin.
     */
    user_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.users:write`
     */
    token: string;
  };
};

export type AdminUsersSetAdminResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsersSetAdminError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsersSetExpirationData = {
  body: {
    /**
     * Timestamp when guest account should be disabled.
     */
    expiration_ts: number;
    /**
     * The ID (`T1234`) of the workspace.
     */
    team_id: string;
    /**
     * The ID of the user to set an expiration for.
     */
    user_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.users:write`
     */
    token: string;
  };
};

export type AdminUsersSetExpirationResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsersSetExpirationError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsersSetOwnerData = {
  body: {
    /**
     * The ID (`T1234`) of the workspace.
     */
    team_id: string;
    /**
     * Id of the user to promote to owner.
     */
    user_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.users:write`
     */
    token: string;
  };
};

export type AdminUsersSetOwnerResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsersSetOwnerError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AdminUsersSetRegularData = {
  body: {
    /**
     * The ID (`T1234`) of the workspace.
     */
    team_id: string;
    /**
     * The ID of the user to designate as a regular user.
     */
    user_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `admin.users:write`
     */
    token: string;
  };
};

export type AdminUsersSetRegularResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AdminUsersSetRegularError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type ApiTestData = {
  query?: {
    /**
     * Error response to return
     */
    error?: string;
    /**
     * example property to return
     */
    foo?: string;
  };
};

export type ApiTestResponse = {
  ok: defs_ok_true;
  [key: string]: (unknown | defs_ok_true) | undefined;
};

export type ApiTestError = {
  error: string;
  ok: defs_ok_false;
  [key: string]: (unknown | string | defs_ok_false) | undefined;
};

export type AppsEventAuthorizationsListData = {
  headers: {
    /**
     * Authentication token. Requires scope: `authorizations:read`
     */
    token: string;
  };
  query: {
    cursor?: string;
    event_context: string;
    limit?: number;
  };
};

export type AppsEventAuthorizationsListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AppsEventAuthorizationsListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AppsPermissionsInfoData = {
  query?: {
    /**
     * Authentication token. Requires scope: `none`
     */
    token?: string;
  };
};

export type AppsPermissionsInfoResponse = {
  info: {
    app_home: {
      resources?: objs_resources;
      scopes?: objs_scopes;
    };
    channel: {
      resources?: objs_resources;
      scopes?: objs_scopes;
    };
    group: {
      resources?: objs_resources;
      scopes?: objs_scopes;
    };
    im: {
      resources?: objs_resources;
      scopes?: objs_scopes;
    };
    mpim: {
      resources?: objs_resources;
      scopes?: objs_scopes;
    };
    team: {
      resources: objs_resources;
      scopes: objs_scopes;
    };
  };
  ok: defs_ok_true;
};

export type AppsPermissionsInfoError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type AppsPermissionsRequestData = {
  query: {
    /**
     * A comma separated list of scopes to request for
     */
    scopes: string;
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
    /**
     * Token used to trigger the permissions API
     */
    trigger_id: string;
  };
};

export type AppsPermissionsRequestResponse = {
  ok: defs_ok_true;
};

export type AppsPermissionsRequestError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'invalid_trigger'
    | 'trigger_exchanged'
    | 'invalid_scope'
    | 'invalid_user'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type AppsPermissionsResourcesListData = {
  query: {
    /**
     * Paginate through collections of data by setting the `cursor` parameter to a `next_cursor` attribute returned by a previous request's `response_metadata`. Default value fetches the first "page" of the collection. See [pagination](/docs/pagination) for more detail.
     */
    cursor?: string;
    /**
     * The maximum number of items to return.
     */
    limit?: number;
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
  };
};

export type AppsPermissionsResourcesListResponse = {
  ok: defs_ok_true;
  resources: Array<{
    id?: string;
    type?: string;
  }>;
  response_metadata?: {
    next_cursor: string;
  };
  [key: string]: unknown | defs_ok_true;
};

export type AppsPermissionsResourcesListError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'invalid_cursor'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type AppsPermissionsScopesListData = {
  query: {
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
  };
};

export type AppsPermissionsScopesListResponse = {
  ok: defs_ok_true;
  scopes: {
    app_home?: objs_scopes;
    channel?: objs_scopes;
    group?: objs_scopes;
    im?: objs_scopes;
    mpim?: objs_scopes;
    team?: objs_scopes;
    user?: objs_scopes;
    [key: string]: unknown | objs_scopes;
  };
  [key: string]: unknown | defs_ok_true;
};

export type AppsPermissionsScopesListError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type AppsPermissionsUsersListData = {
  query: {
    /**
     * Paginate through collections of data by setting the `cursor` parameter to a `next_cursor` attribute returned by a previous request's `response_metadata`. Default value fetches the first "page" of the collection. See [pagination](/docs/pagination) for more detail.
     */
    cursor?: string;
    /**
     * The maximum number of items to return.
     */
    limit?: number;
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
  };
};

export type AppsPermissionsUsersListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AppsPermissionsUsersListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AppsPermissionsUsersRequestData = {
  query: {
    /**
     * A comma separated list of user scopes to request for
     */
    scopes: string;
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
    /**
     * Token used to trigger the request
     */
    trigger_id: string;
    /**
     * The user this scope is being requested for
     */
    user: string;
  };
};

export type AppsPermissionsUsersRequestResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type AppsPermissionsUsersRequestError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type AppsUninstallData = {
  query?: {
    /**
     * Issued when you created your application.
     */
    client_id?: string;
    /**
     * Issued when you created your application.
     */
    client_secret?: string;
    /**
     * Authentication token. Requires scope: `none`
     */
    token?: string;
  };
};

export type AppsUninstallResponse = {
  ok: defs_ok_true;
};

export type AppsUninstallError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'invalid_client_id'
    | 'bad_client_secret'
    | 'client_id_token_mismatch'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type AuthRevokeData = {
  query: {
    /**
     * Setting this parameter to `1` triggers a _testing mode_ where the specified token will not actually be revoked.
     */
    test?: boolean;
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
  };
};

export type AuthRevokeResponse = {
  ok: defs_ok_true;
  revoked: boolean;
};

export type AuthRevokeError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type AuthTestData = {
  headers: {
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
  };
};

export type AuthTestResponse = {
  bot_id?: defs_bot_id;
  is_enterprise_install?: boolean;
  ok: defs_ok_true;
  team: string;
  team_id: defs_team;
  url: string;
  user: string;
  user_id: defs_user_id;
};

export type AuthTestError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'token_revoked'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type BotsInfoData = {
  query: {
    /**
     * Bot user to get info on
     */
    bot?: string;
    /**
     * Authentication token. Requires scope: `users:read`
     */
    token: string;
  };
};

export type BotsInfoResponse = {
  bot: {
    app_id: defs_app_id;
    deleted: boolean;
    icons: {
      image_36: string;
      image_48: string;
      image_72: string;
    };
    id: defs_bot_id;
    name: string;
    updated: number;
    user_id?: defs_user_id;
  };
  ok: defs_ok_true;
};

export type BotsInfoError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'bot_not_found'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type CallsAddData = {
  body: {
    /**
     * The valid Slack user ID of the user who created this Call. When this method is called with a user token, the `created_by` field is optional and defaults to the authed user of the token. Otherwise, the field is required.
     */
    created_by?: string;
    /**
     * Call start time in UTC UNIX timestamp format
     */
    date_start?: number;
    /**
     * When supplied, available Slack clients will attempt to directly launch the 3rd-party Call with this URL.
     */
    desktop_app_join_url?: string;
    /**
     * An optional, human-readable ID supplied by the 3rd-party Call provider. If supplied, this ID will be displayed in the Call object.
     */
    external_display_id?: string;
    /**
     * An ID supplied by the 3rd-party Call provider. It must be unique across all Calls from that service.
     */
    external_unique_id: string;
    /**
     * The URL required for a client to join the Call.
     */
    join_url: string;
    /**
     * The name of the Call.
     */
    title?: string;
    /**
     * The list of users to register as participants in the Call. [Read more on how to specify users here](/apis/calls#users).
     */
    users?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `calls:write`
     */
    token: string;
  };
};

export type CallsAddResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type CallsAddError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type CallsEndData = {
  body: {
    /**
     * Call duration in seconds
     */
    duration?: number;
    /**
     * `id` returned when registering the call using the [`calls.add`](/methods/calls.add) method.
     */
    id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `calls:write`
     */
    token: string;
  };
};

export type CallsEndResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type CallsEndError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type CallsInfoData = {
  headers: {
    /**
     * Authentication token. Requires scope: `calls:read`
     */
    token: string;
  };
  query: {
    /**
     * `id` of the Call returned by the [`calls.add`](/methods/calls.add) method.
     */
    id: string;
  };
};

export type CallsInfoResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type CallsInfoError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type CallsParticipantsAddData = {
  body: {
    /**
     * `id` returned by the [`calls.add`](/methods/calls.add) method.
     */
    id: string;
    /**
     * The list of users to add as participants in the Call. [Read more on how to specify users here](/apis/calls#users).
     */
    users: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `calls:write`
     */
    token: string;
  };
};

export type CallsParticipantsAddResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type CallsParticipantsAddError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type CallsParticipantsRemoveData = {
  body: {
    /**
     * `id` returned by the [`calls.add`](/methods/calls.add) method.
     */
    id: string;
    /**
     * The list of users to remove as participants in the Call. [Read more on how to specify users here](/apis/calls#users).
     */
    users: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `calls:write`
     */
    token: string;
  };
};

export type CallsParticipantsRemoveResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type CallsParticipantsRemoveError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type CallsUpdateData = {
  body: {
    /**
     * When supplied, available Slack clients will attempt to directly launch the 3rd-party Call with this URL.
     */
    desktop_app_join_url?: string;
    /**
     * `id` returned by the [`calls.add`](/methods/calls.add) method.
     */
    id: string;
    /**
     * The URL required for a client to join the Call.
     */
    join_url?: string;
    /**
     * The name of the Call.
     */
    title?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `calls:write`
     */
    token: string;
  };
};

export type CallsUpdateResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type CallsUpdateError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type ChatDeleteData = {
  body?: {
    /**
     * Pass true to delete the message as the authed user with `chat:write:user` scope. [Bot users](/bot-users) in this context are considered authed users. If unused or false, the message will be deleted with `chat:write:bot` scope.
     */
    as_user?: boolean;
    /**
     * Channel containing the message to be deleted.
     */
    channel?: string;
    /**
     * Timestamp of the message to be deleted.
     */
    ts?: number;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `chat:write`
     */
    token?: string;
  };
};

export type ChatDeleteResponse = {
  channel: defs_channel;
  ok: defs_ok_true;
  ts: defs_ts;
};

export type ChatDeleteError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'message_not_found'
    | 'channel_not_found'
    | 'cant_delete_message'
    | 'compliance_exports_prevent_deletion'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type ChatDeleteScheduledMessageData = {
  body?: {
    /**
     * Pass true to delete the message as the authed user with `chat:write:user` scope. [Bot users](/bot-users) in this context are considered authed users. If unused or false, the message will be deleted with `chat:write:bot` scope.
     */
    as_user?: boolean;
    /**
     * The channel the scheduled_message is posting to
     */
    channel: string;
    /**
     * `scheduled_message_id` returned from call to chat.scheduleMessage
     */
    scheduled_message_id: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `chat:write`
     */
    token: string;
  };
};

export type ChatDeleteScheduledMessageResponse = {
  ok: defs_ok_true;
};

export type ChatDeleteScheduledMessageError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'invalid_scheduled_message_id'
    | 'channel_not_found'
    | 'bad_token'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'ekm_access_denied'
    | 'missing_scope'
    | 'invalid_arguments'
    | 'invalid_arg_name'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type ChatGetPermalinkData = {
  query: {
    /**
     * The ID of the conversation or channel containing the message
     */
    channel: string;
    /**
     * A message's `ts` value, uniquely identifying it within a channel
     */
    message_ts: string;
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
  };
};

export type ChatGetPermalinkResponse = {
  channel: defs_channel;
  ok: defs_ok_true;
  permalink: string;
};

export type ChatGetPermalinkError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'channel_not_found'
    | 'message_not_found'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type ChatMeMessageData = {
  body?: {
    /**
     * Channel to send message to. Can be a public channel, private group or IM channel. Can be an encoded ID, or a name.
     */
    channel?: string;
    /**
     * Text of the message to send.
     */
    text?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `chat:write`
     */
    token?: string;
  };
};

export type ChatMeMessageResponse = {
  channel?: defs_channel;
  ok: defs_ok_true;
  ts?: defs_ts;
};

export type ChatMeMessageError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'channel_not_found'
    | 'not_in_channel'
    | 'is_archived'
    | 'msg_too_long'
    | 'no_text'
    | 'rate_limited'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type ChatPostEphemeralData = {
  body?: {
    /**
     * Pass true to post the message as the authed user. Defaults to true if the chat:write:bot scope is not included. Otherwise, defaults to false.
     */
    as_user?: boolean;
    /**
     * A JSON-based array of structured attachments, presented as a URL-encoded string.
     */
    attachments?: string;
    /**
     * A JSON-based array of structured blocks, presented as a URL-encoded string.
     */
    blocks?: string;
    /**
     * Channel, private group, or IM channel to send message to. Can be an encoded ID, or a name.
     */
    channel: string;
    /**
     * Emoji to use as the icon for this message. Overrides `icon_url`. Must be used in conjunction with `as_user` set to `false`, otherwise ignored. See [authorship](#authorship) below.
     */
    icon_emoji?: string;
    /**
     * URL to an image to use as the icon for this message. Must be used in conjunction with `as_user` set to false, otherwise ignored. See [authorship](#authorship) below.
     */
    icon_url?: string;
    /**
     * Find and link channel names and usernames.
     */
    link_names?: boolean;
    /**
     * Change how messages are treated. Defaults to `none`. See [below](#formatting).
     */
    parse?: string;
    /**
     * How this field works and whether it is required depends on other fields you use in your API call. [See below](#text_usage) for more detail.
     */
    text?: string;
    /**
     * Provide another message's `ts` value to post this message in a thread. Avoid using a reply's `ts` value; use its parent's value instead. Ephemeral messages in threads are only shown if there is already an active thread.
     */
    thread_ts?: string;
    /**
     * `id` of the user who will receive the ephemeral message. The user should be in the channel specified by the `channel` argument.
     */
    user: string;
    /**
     * Set your bot's user name. Must be used in conjunction with `as_user` set to false, otherwise ignored. See [authorship](#authorship) below.
     */
    username?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `chat:write`
     */
    token: string;
  };
};

export type ChatPostEphemeralResponse = {
  message_ts: defs_ts;
  ok: defs_ok_true;
};

export type ChatPostEphemeralError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'channel_not_found'
    | 'is_archived'
    | 'msg_too_long'
    | 'no_text'
    | 'restricted_action'
    | 'too_many_attachments'
    | 'user_not_in_channel'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type ChatPostMessageData = {
  body?: {
    /**
     * Pass true to post the message as the authed user, instead of as a bot. Defaults to false. See [authorship](#authorship) below.
     */
    as_user?: string;
    /**
     * A JSON-based array of structured attachments, presented as a URL-encoded string.
     */
    attachments?: string;
    /**
     * A JSON-based array of structured blocks, presented as a URL-encoded string.
     */
    blocks?: string;
    /**
     * Channel, private group, or IM channel to send message to. Can be an encoded ID, or a name. See [below](#channels) for more details.
     */
    channel: string;
    /**
     * Emoji to use as the icon for this message. Overrides `icon_url`. Must be used in conjunction with `as_user` set to `false`, otherwise ignored. See [authorship](#authorship) below.
     */
    icon_emoji?: string;
    /**
     * URL to an image to use as the icon for this message. Must be used in conjunction with `as_user` set to false, otherwise ignored. See [authorship](#authorship) below.
     */
    icon_url?: string;
    /**
     * Find and link channel names and usernames.
     */
    link_names?: boolean;
    /**
     * Disable Slack markup parsing by setting to `false`. Enabled by default.
     */
    mrkdwn?: boolean;
    /**
     * Change how messages are treated. Defaults to `none`. See [below](#formatting).
     */
    parse?: string;
    /**
     * Used in conjunction with `thread_ts` and indicates whether reply should be made visible to everyone in the channel or conversation. Defaults to `false`.
     */
    reply_broadcast?: boolean;
    /**
     * How this field works and whether it is required depends on other fields you use in your API call. [See below](#text_usage) for more detail.
     */
    text?: string;
    /**
     * Provide another message's `ts` value to make this message a reply. Avoid using a reply's `ts` value; use its parent instead.
     */
    thread_ts?: string;
    /**
     * Pass true to enable unfurling of primarily text-based content.
     */
    unfurl_links?: boolean;
    /**
     * Pass false to disable unfurling of media content.
     */
    unfurl_media?: boolean;
    /**
     * Set your bot's user name. Must be used in conjunction with `as_user` set to false, otherwise ignored. See [authorship](#authorship) below.
     */
    username?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `chat:write`
     */
    token: string;
  };
};

export type ChatPostMessageResponse = {
  channel: defs_channel;
  message: objs_message;
  ok: defs_ok_true;
  ts: defs_ts;
};

export type ChatPostMessageError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'channel_not_found'
    | 'not_in_channel'
    | 'is_archived'
    | 'msg_too_long'
    | 'no_text'
    | 'too_many_attachments'
    | 'rate_limited'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type';
  ok: defs_ok_false;
};

export type ChatScheduleMessageData = {
  body?: {
    /**
     * Pass true to post the message as the authed user, instead of as a bot. Defaults to false. See [chat.postMessage](chat.postMessage#authorship).
     */
    as_user?: boolean;
    /**
     * A JSON-based array of structured attachments, presented as a URL-encoded string.
     */
    attachments?: string;
    /**
     * A JSON-based array of structured blocks, presented as a URL-encoded string.
     */
    blocks?: string;
    /**
     * Channel, private group, or DM channel to send message to. Can be an encoded ID, or a name. See [below](#channels) for more details.
     */
    channel?: string;
    /**
     * Find and link channel names and usernames.
     */
    link_names?: boolean;
    /**
     * Change how messages are treated. Defaults to `none`. See [chat.postMessage](chat.postMessage#formatting).
     */
    parse?: string;
    /**
     * Unix EPOCH timestamp of time in future to send the message.
     */
    post_at?: string;
    /**
     * Used in conjunction with `thread_ts` and indicates whether reply should be made visible to everyone in the channel or conversation. Defaults to `false`.
     */
    reply_broadcast?: boolean;
    /**
     * How this field works and whether it is required depends on other fields you use in your API call. [See below](#text_usage) for more detail.
     */
    text?: string;
    /**
     * Provide another message's `ts` value to make this message a reply. Avoid using a reply's `ts` value; use its parent instead.
     */
    thread_ts?: number;
    /**
     * Pass true to enable unfurling of primarily text-based content.
     */
    unfurl_links?: boolean;
    /**
     * Pass false to disable unfurling of media content.
     */
    unfurl_media?: boolean;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `chat:write`
     */
    token?: string;
  };
};

export type ChatScheduleMessageResponse = {
  channel: defs_channel;
  message: {
    bot_id: defs_bot_id;
    bot_profile?: objs_bot_profile;
    team: defs_team;
    text: string;
    type: string;
    user: defs_user_id;
    username?: string;
  };
  ok: defs_ok_true;
  post_at: number;
  scheduled_message_id: string;
};

export type ChatScheduleMessageError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'invalid_time'
    | 'time_in_past'
    | 'time_too_far'
    | 'channel_not_found'
    | 'not_in_channel'
    | 'is_archived'
    | 'msg_too_long'
    | 'no_text'
    | 'restricted_action'
    | 'restricted_action_read_only_channel'
    | 'restricted_action_thread_only_channel'
    | 'restricted_action_non_threadable_channel'
    | 'too_many_attachments'
    | 'rate_limited'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'ekm_access_denied'
    | 'missing_scope'
    | 'invalid_arguments'
    | 'invalid_arg_name'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type ChatScheduledMessagesListData = {
  headers?: {
    /**
     * Authentication token. Requires scope: `none`
     */
    token?: string;
  };
  query?: {
    /**
     * The channel of the scheduled messages
     */
    channel?: string;
    /**
     * For pagination purposes, this is the `cursor` value returned from a previous call to `chat.scheduledmessages.list` indicating where you want to start this call from.
     */
    cursor?: string;
    /**
     * A UNIX timestamp of the latest value in the time range
     */
    latest?: number;
    /**
     * Maximum number of original entries to return.
     */
    limit?: number;
    /**
     * A UNIX timestamp of the oldest value in the time range
     */
    oldest?: number;
  };
};

export type ChatScheduledMessagesListResponse = {
  ok: defs_ok_true;
  response_metadata: {
    next_cursor: string;
  };
  scheduled_messages: Array<{
    channel_id: defs_channel_id;
    date_created: number;
    id: string;
    post_at: number;
    text?: string;
  }>;
};

export type ChatScheduledMessagesListError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'invalid_channel'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'ekm_access_denied'
    | 'missing_scope'
    | 'invalid_arguments'
    | 'invalid_arg_name'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type ChatUnfurlData = {
  body: {
    /**
     * Channel ID of the message
     */
    channel: string;
    /**
     * Timestamp of the message to add unfurl behavior to.
     */
    ts: string;
    /**
     * URL-encoded JSON map with keys set to URLs featured in the the message, pointing to their unfurl blocks or message attachments.
     */
    unfurls?: string;
    /**
     * Provide a simply-formatted string to send as an ephemeral message to the user as invitation to authenticate further and enable full unfurling behavior
     */
    user_auth_message?: string;
    /**
     * Set to `true` or `1` to indicate the user must install your Slack app to trigger unfurls for this domain
     */
    user_auth_required?: boolean;
    /**
     * Send users to this custom URL where they will complete authentication in your app to fully trigger unfurling. Value should be properly URL-encoded.
     */
    user_auth_url?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `links:write`
     */
    token: string;
  };
};

export type ChatUnfurlResponse = {
  ok: defs_ok_true;
};

export type ChatUnfurlError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'cannot_unfurl_url'
    | 'cannot_find_service'
    | 'missing_unfurls'
    | 'cannot_prompt'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type ChatUpdateData = {
  body?: {
    /**
     * Pass true to update the message as the authed user. [Bot users](/bot-users) in this context are considered authed users.
     */
    as_user?: string;
    /**
     * A JSON-based array of structured attachments, presented as a URL-encoded string. This field is required when not presenting `text`. If you don't include this field, the message's previous `attachments` will be retained. To remove previous `attachments`, include an empty array for this field.
     */
    attachments?: string;
    /**
     * A JSON-based array of [structured blocks](/block-kit/building), presented as a URL-encoded string. If you don't include this field, the message's previous `blocks` will be retained. To remove previous `blocks`, include an empty array for this field.
     */
    blocks?: string;
    /**
     * Channel containing the message to be updated.
     */
    channel: string;
    /**
     * Find and link channel names and usernames. Defaults to `none`. If you do not specify a value for this field, the original value set for the message will be overwritten with the default, `none`.
     */
    link_names?: string;
    /**
     * Change how messages are treated. Defaults to `client`, unlike `chat.postMessage`. Accepts either `none` or `full`. If you do not specify a value for this field, the original value set for the message will be overwritten with the default, `client`.
     */
    parse?: string;
    /**
     * New text for the message, using the [default formatting rules](/reference/surfaces/formatting). It's not required when presenting `blocks` or `attachments`.
     */
    text?: string;
    /**
     * Timestamp of the message to be updated.
     */
    ts: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `chat:write`
     */
    token: string;
  };
};

export type ChatUpdateResponse = {
  channel: string;
  message: {
    attachments?: Array<{
      [key: string]: unknown;
    }>;
    blocks?: {
      [key: string]: unknown;
    };
    text: string;
  };
  ok: defs_ok_true;
  text: string;
  ts: string;
};

export type ChatUpdateError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'message_not_found'
    | 'cant_update_message'
    | 'channel_not_found'
    | 'edit_window_closed'
    | 'msg_too_long'
    | 'too_many_attachments'
    | 'rate_limited'
    | 'no_text'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'request_timeout'
    | 'invalid_json'
    | 'json_not_object'
    | 'upgrade_required'
    | 'fatal_error'
    | 'is_inactive';
  ok: defs_ok_false;
};

export type ConversationsArchiveData = {
  body?: {
    /**
     * ID of conversation to archive
     */
    channel?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `conversations:write`
     */
    token?: string;
  };
};

export type ConversationsArchiveResponse = {
  ok: defs_ok_true;
};

export type ConversationsArchiveError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'method_not_supported_for_channel_type'
    | 'missing_scope'
    | 'not_supported'
    | 'channel_not_found'
    | 'already_archived'
    | 'cant_archive_general'
    | 'restricted_action'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'user_is_ultra_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'team_added_to_org'
    | 'missing_charset'
    | 'superfluous_charset';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsCloseData = {
  body?: {
    /**
     * Conversation to close.
     */
    channel?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `conversations:write`
     */
    token?: string;
  };
};

export type ConversationsCloseResponse = {
  already_closed?: boolean;
  no_op?: boolean;
  ok: defs_ok_true;
};

export type ConversationsCloseError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'method_not_supported_for_channel_type'
    | 'channel_not_found'
    | 'user_does_not_own_channel'
    | 'missing_scope'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsCreateData = {
  body?: {
    /**
     * Create a private channel instead of a public one
     */
    is_private?: boolean;
    /**
     * Name of the public or private channel to create
     */
    name?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `conversations:write`
     */
    token?: string;
  };
};

export type ConversationsCreateResponse = {
  channel: objs_conversation;
  ok: defs_ok_true;
};

export type ConversationsCreateError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  detail?: string;
  error:
    | 'method_not_supported_for_channel_type'
    | 'missing_scope'
    | 'name_taken'
    | 'restricted_action'
    | 'no_channel'
    | 'invalid_name_required'
    | 'invalid_name_punctuation'
    | 'invalid_name_maxlength'
    | 'invalid_name_specials'
    | 'invalid_name'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsHistoryData = {
  query?: {
    /**
     * Conversation ID to fetch history for.
     */
    channel?: string;
    /**
     * Paginate through collections of data by setting the `cursor` parameter to a `next_cursor` attribute returned by a previous request's `response_metadata`. Default value fetches the first "page" of the collection. See [pagination](/docs/pagination) for more detail.
     */
    cursor?: string;
    /**
     * Include messages with latest or oldest timestamp in results only when either timestamp is specified.
     */
    inclusive?: boolean;
    /**
     * End of time range of messages to include in results.
     */
    latest?: number;
    /**
     * The maximum number of items to return. Fewer than the requested number of items may be returned, even if the end of the users list hasn't been reached.
     */
    limit?: number;
    /**
     * Start of time range of messages to include in results.
     */
    oldest?: number;
    /**
     * Authentication token. Requires scope: `conversations:history`
     */
    token?: string;
  };
};

export type ConversationsHistoryResponse = {
  channel_actions_count: number;
  channel_actions_ts: unknown;
  has_more: boolean;
  messages: Array<objs_message>;
  ok: defs_ok_true;
  pin_count: number;
};

export type ConversationsHistoryError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'missing_scope'
    | 'channel_not_found'
    | 'invalid_ts_latest'
    | 'invalid_ts_oldest'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsInfoData = {
  query?: {
    /**
     * Conversation ID to learn more about
     */
    channel?: string;
    /**
     * Set this to `true` to receive the locale for this conversation. Defaults to `false`
     */
    include_locale?: boolean;
    /**
     * Set to `true` to include the member count for the specified conversation. Defaults to `false`
     */
    include_num_members?: boolean;
    /**
     * Authentication token. Requires scope: `conversations:read`
     */
    token?: string;
  };
};

export type ConversationsInfoResponse = {
  channel: objs_conversation;
  ok: defs_ok_true;
};

export type ConversationsInfoError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'missing_scope'
    | 'channel_not_found'
    | 'team_added_to_org'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsInviteData = {
  body?: {
    /**
     * The ID of the public or private channel to invite user(s) to.
     */
    channel?: string;
    /**
     * A comma separated list of user IDs. Up to 1000 users may be listed.
     */
    users?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `conversations:write`
     */
    token?: string;
  };
};

export type ConversationsInviteResponse = {
  channel: objs_conversation;
  ok: defs_ok_true;
};

export type ConversationsInviteError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error?:
    | 'method_not_supported_for_channel_type'
    | 'missing_scope'
    | 'channel_not_found'
    | 'user_not_found'
    | 'no_user'
    | 'cant_invite_self'
    | 'not_in_channel'
    | 'already_in_channel'
    | 'is_archived'
    | 'cant_invite'
    | 'too_many_users'
    | 'ura_max_channels'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'user_is_ultra_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'team_added_to_org'
    | 'missing_charset'
    | 'superfluous_charset';
  errors?: Array<{
    error:
      | 'method_not_supported_for_channel_type'
      | 'missing_scope'
      | 'channel_not_found'
      | 'user_not_found'
      | 'no_user'
      | 'cant_invite_self'
      | 'not_in_channel'
      | 'already_in_channel'
      | 'is_archived'
      | 'cant_invite'
      | 'too_many_users'
      | 'ura_max_channels'
      | 'not_authed'
      | 'invalid_auth'
      | 'account_inactive'
      | 'user_is_bot'
      | 'user_is_restricted'
      | 'user_is_ultra_restricted'
      | 'invalid_arg_name'
      | 'invalid_array_arg'
      | 'invalid_charset'
      | 'invalid_form_data'
      | 'invalid_post_type'
      | 'missing_post_type'
      | 'invalid_json'
      | 'json_not_object'
      | 'request_timeout'
      | 'upgrade_required'
      | 'team_added_to_org'
      | 'missing_charset'
      | 'superfluous_charset';
    ok: defs_ok_false;
    user?: defs_user_id;
  }>;
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsJoinData = {
  body?: {
    /**
     * ID of conversation to join
     */
    channel?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `channels:write`
     */
    token?: string;
  };
};

export type ConversationsJoinResponse = {
  channel: objs_conversation;
  ok: defs_ok_true;
  response_metadata?: {
    warnings?: Array<string>;
  };
  warning?: string;
};

export type ConversationsJoinError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'method_not_supported_for_channel_type'
    | 'missing_scope'
    | 'channel_not_found'
    | 'is_archived'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'user_is_ultra_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'team_added_to_org'
    | 'missing_charset'
    | 'superfluous_charset';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsKickData = {
  body?: {
    /**
     * ID of conversation to remove user from.
     */
    channel?: string;
    /**
     * User ID to be removed.
     */
    user?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `conversations:write`
     */
    token?: string;
  };
};

export type ConversationsKickResponse = {
  ok: defs_ok_true;
};

export type ConversationsKickError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'method_not_supported_for_channel_type'
    | 'missing_scope'
    | 'channel_not_found'
    | 'user_not_found'
    | 'cant_kick_self'
    | 'not_in_channel'
    | 'cant_kick_from_general'
    | 'restricted_action'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsLeaveData = {
  body?: {
    /**
     * Conversation to leave
     */
    channel?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `conversations:write`
     */
    token?: string;
  };
};

export type ConversationsLeaveResponse = {
  not_in_channel?: boolean;
  ok: defs_ok_true;
};

export type ConversationsLeaveError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'method_not_supported_for_channel_type'
    | 'last_member'
    | 'missing_scope'
    | 'channel_not_found'
    | 'is_archived'
    | 'cant_leave_general'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'user_is_ultra_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'team_added_to_org'
    | 'missing_charset'
    | 'superfluous_charset';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsListData = {
  query?: {
    /**
     * Paginate through collections of data by setting the `cursor` parameter to a `next_cursor` attribute returned by a previous request's `response_metadata`. Default value fetches the first "page" of the collection. See [pagination](/docs/pagination) for more detail.
     */
    cursor?: string;
    /**
     * Set to `true` to exclude archived channels from the list
     */
    exclude_archived?: boolean;
    /**
     * The maximum number of items to return. Fewer than the requested number of items may be returned, even if the end of the list hasn't been reached. Must be an integer no larger than 1000.
     */
    limit?: number;
    /**
     * Authentication token. Requires scope: `conversations:read`
     */
    token?: string;
    /**
     * Mix and match channel types by providing a comma-separated list of any combination of `public_channel`, `private_channel`, `mpim`, `im`
     */
    types?: string;
  };
};

export type ConversationsListResponse = {
  channels: Array<objs_conversation>;
  ok: defs_ok_true;
  response_metadata?: {
    next_cursor: string;
  };
};

export type ConversationsListError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'missing_scope'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsMarkData = {
  body?: {
    /**
     * Channel or conversation to set the read cursor for.
     */
    channel?: string;
    /**
     * Unique identifier of message you want marked as most recently seen in this conversation.
     */
    ts?: number;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `conversations:write`
     */
    token?: string;
  };
};

export type ConversationsMarkResponse = {
  ok: defs_ok_true;
};

export type ConversationsMarkError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'method_not_supported_for_channel_type'
    | 'missing_scope'
    | 'channel_not_found'
    | 'invalid_timestamp'
    | 'not_in_channel'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'not_allowed_token_type';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsMembersData = {
  query?: {
    /**
     * ID of the conversation to retrieve members for
     */
    channel?: string;
    /**
     * Paginate through collections of data by setting the `cursor` parameter to a `next_cursor` attribute returned by a previous request's `response_metadata`. Default value fetches the first "page" of the collection. See [pagination](/docs/pagination) for more detail.
     */
    cursor?: string;
    /**
     * The maximum number of items to return. Fewer than the requested number of items may be returned, even if the end of the users list hasn't been reached.
     */
    limit?: number;
    /**
     * Authentication token. Requires scope: `conversations:read`
     */
    token?: string;
  };
};

export type ConversationsMembersResponse = {
  members: Array<defs_user_id>;
  ok: defs_ok_true;
  response_metadata: {
    next_cursor: string;
  };
};

export type ConversationsMembersError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'channel_not_found'
    | 'invalid_limit'
    | 'invalid_cursor'
    | 'fetch_members_failed'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type ConversationsOpenData = {
  body?: {
    /**
     * Resume a conversation by supplying an `im` or `mpim`'s ID. Or provide the `users` field instead.
     */
    channel?: string;
    /**
     * Boolean, indicates you want the full IM channel definition in the response.
     */
    return_im?: boolean;
    /**
     * Comma separated lists of users. If only one user is included, this creates a 1:1 DM.  The ordering of the users is preserved whenever a multi-person direct message is returned. Supply a `channel` when not supplying `users`.
     */
    users?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `conversations:write`
     */
    token?: string;
  };
};

export type ConversationsOpenResponse = {
  already_open?: boolean;
  channel: unknown;
  no_op?: boolean;
  ok: defs_ok_true;
};

export type ConversationsOpenError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'method_not_supported_for_channel_type'
    | 'user_not_found'
    | 'user_not_visible'
    | 'user_disabled'
    | 'users_list_not_supplied'
    | 'not_enough_users'
    | 'too_many_users'
    | 'invalid_user_combination'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'channel_not_found';
  ok: defs_ok_false;
};

export type ConversationsRenameData = {
  body?: {
    /**
     * ID of conversation to rename
     */
    channel?: string;
    /**
     * New name for conversation.
     */
    name?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `conversations:write`
     */
    token?: string;
  };
};

export type ConversationsRenameResponse = {
  channel: objs_conversation;
  ok: defs_ok_true;
};

export type ConversationsRenameError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'user_is_restricted'
    | 'method_not_supported_for_channel_type'
    | 'missing_scope'
    | 'channel_not_found'
    | 'not_in_channel'
    | 'not_authorized'
    | 'invalid_name'
    | 'name_taken'
    | 'invalid_name_required'
    | 'invalid_name_punctuation'
    | 'invalid_name_maxlength'
    | 'invalid_name_specials'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsRepliesData = {
  query?: {
    /**
     * Conversation ID to fetch thread from.
     */
    channel?: string;
    /**
     * Paginate through collections of data by setting the `cursor` parameter to a `next_cursor` attribute returned by a previous request's `response_metadata`. Default value fetches the first "page" of the collection. See [pagination](/docs/pagination) for more detail.
     */
    cursor?: string;
    /**
     * Include messages with latest or oldest timestamp in results only when either timestamp is specified.
     */
    inclusive?: boolean;
    /**
     * End of time range of messages to include in results.
     */
    latest?: number;
    /**
     * The maximum number of items to return. Fewer than the requested number of items may be returned, even if the end of the users list hasn't been reached.
     */
    limit?: number;
    /**
     * Start of time range of messages to include in results.
     */
    oldest?: number;
    /**
     * Authentication token. Requires scope: `conversations:history`
     */
    token?: string;
    /**
     * Unique identifier of a thread's parent message. `ts` must be the timestamp of an existing message with 0 or more replies. If there are no replies then just the single message referenced by `ts` will return - it is just an ordinary, unthreaded message.
     */
    ts?: number;
  };
};

export type ConversationsRepliesResponse = {
  has_more?: boolean;
  messages: Array<unknown>;
  ok: defs_ok_true;
};

export type ConversationsRepliesError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'missing_scope'
    | 'channel_not_found'
    | 'thread_not_found'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsSetPurposeData = {
  body?: {
    /**
     * Conversation to set the purpose of
     */
    channel?: string;
    /**
     * A new, specialer purpose
     */
    purpose?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `conversations:write`
     */
    token?: string;
  };
};

export type ConversationsSetPurposeResponse = {
  channel: objs_conversation;
  ok: defs_ok_true;
};

export type ConversationsSetPurposeError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'method_not_supported_for_channel_type'
    | 'missing_scope'
    | 'channel_not_found'
    | 'not_in_channel'
    | 'is_archived'
    | 'too_long'
    | 'user_is_restricted'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsSetTopicData = {
  body?: {
    /**
     * Conversation to set the topic of
     */
    channel?: string;
    /**
     * The new topic string. Does not support formatting or linkification.
     */
    topic?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `conversations:write`
     */
    token?: string;
  };
};

export type ConversationsSetTopicResponse = {
  channel: objs_conversation;
  ok: defs_ok_true;
};

export type ConversationsSetTopicError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'method_not_supported_for_channel_type'
    | 'missing_scope'
    | 'channel_not_found'
    | 'not_in_channel'
    | 'is_archived'
    | 'too_long'
    | 'user_is_restricted'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type ConversationsUnarchiveData = {
  body?: {
    /**
     * ID of conversation to unarchive
     */
    channel?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `conversations:write`
     */
    token?: string;
  };
};

export type ConversationsUnarchiveResponse = {
  ok: defs_ok_true;
};

export type ConversationsUnarchiveError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'method_not_supported_for_channel_type'
    | 'missing_scope'
    | 'channel_not_found'
    | 'not_archived'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'user_is_ultra_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'team_added_to_org'
    | 'missing_charset'
    | 'superfluous_charset';
  needed?: string;
  ok: defs_ok_false;
  provided?: string;
};

export type DialogOpenData = {
  headers: {
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
  };
  query: {
    /**
     * The dialog definition. This must be a JSON-encoded string.
     */
    dialog: string;
    /**
     * Exchange a trigger to post to the user.
     */
    trigger_id: string;
  };
};

export type DialogOpenResponse = {
  ok: defs_ok_true;
};

export type DialogOpenError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'validation_errors'
    | 'missing_trigger'
    | 'missing_dialog'
    | 'trigger_exchanged'
    | 'trigger_expired'
    | 'invalid_trigger'
    | 'app_missing_action_url'
    | 'cannot_create_dialog'
    | 'failed_sending_dialog'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type DndEndDndData = {
  headers: {
    /**
     * Authentication token. Requires scope: `dnd:write`
     */
    token: string;
  };
};

export type DndEndDndResponse = {
  ok: defs_ok_true;
};

export type DndEndDndError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'unknown_error'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type DndEndSnoozeData = {
  headers: {
    /**
     * Authentication token. Requires scope: `dnd:write`
     */
    token: string;
  };
};

export type DndEndSnoozeResponse = {
  dnd_enabled: boolean;
  next_dnd_end_ts: number;
  next_dnd_start_ts: number;
  ok: defs_ok_true;
  snooze_enabled: boolean;
};

export type DndEndSnoozeError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'snooze_not_active'
    | 'snooze_end_failed'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type DndInfoData = {
  query?: {
    /**
     * Authentication token. Requires scope: `dnd:read`
     */
    token?: string;
    /**
     * User to fetch status for (defaults to current user)
     */
    user?: string;
  };
};

export type DndInfoResponse = {
  dnd_enabled: boolean;
  next_dnd_end_ts: number;
  next_dnd_start_ts: number;
  ok: defs_ok_true;
  snooze_enabled?: boolean;
  snooze_endtime?: number;
  snooze_remaining?: number;
};

export type DndInfoError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'user_not_found'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type DndSetSnoozeData = {
  body: {
    /**
     * Number of minutes, from now, to snooze until.
     */
    num_minutes: string;
    /**
     * Authentication token. Requires scope: `dnd:write`
     */
    token: string;
  };
};

export type DndSetSnoozeResponse = {
  ok: defs_ok_true;
  snooze_enabled: boolean;
  snooze_endtime: number;
  snooze_remaining: number;
};

export type DndSetSnoozeError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'missing_duration'
    | 'snooze_failed'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'too_long'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type DndTeamInfoData = {
  query?: {
    /**
     * Authentication token. Requires scope: `dnd:read`
     */
    token?: string;
    /**
     * Comma-separated list of users to fetch Do Not Disturb status for
     */
    users?: string;
  };
};

export type DndTeamInfoResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type DndTeamInfoError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type EmojiListData = {
  query: {
    /**
     * Authentication token. Requires scope: `emoji:read`
     */
    token: string;
  };
};

export type EmojiListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type EmojiListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type FilesCommentsDeleteData = {
  body?: {
    /**
     * File to delete a comment from.
     */
    file?: string;
    /**
     * The comment to delete.
     */
    id?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `files:write:user`
     */
    token?: string;
  };
};

export type FilesCommentsDeleteResponse = {
  ok: defs_ok_true;
};

export type FilesCommentsDeleteError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'cant_delete'
    | 'comment_not_found'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type FilesDeleteData = {
  body?: {
    /**
     * ID of file to delete.
     */
    file?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `files:write:user`
     */
    token?: string;
  };
};

export type FilesDeleteResponse = {
  ok: defs_ok_true;
};

export type FilesDeleteError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'file_not_found'
    | 'file_deleted'
    | 'cant_delete_file'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type FilesInfoData = {
  query?: {
    count?: string;
    /**
     * Parameter for pagination. File comments are paginated for a single file. Set `cursor` equal to the `next_cursor` attribute returned by the previous request's `response_metadata`. This parameter is optional, but pagination is mandatory: the default value simply fetches the first "page" of the collection of comments. See [pagination](/docs/pagination) for more details.
     */
    cursor?: string;
    /**
     * Specify a file by providing its ID.
     */
    file?: string;
    /**
     * The maximum number of items to return. Fewer than the requested number of items may be returned, even if the end of the list hasn't been reached.
     */
    limit?: number;
    page?: string;
    /**
     * Authentication token. Requires scope: `files:read`
     */
    token?: string;
  };
};

export type FilesInfoResponse = {
  comments: objs_comments;
  content_html?: unknown;
  editor?: defs_user_id;
  file: objs_file;
  ok: defs_ok_true;
  paging?: objs_paging;
  response_metadata?: objs_response_metadata;
};

export type FilesInfoError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'file_not_found'
    | 'file_deleted'
    | 'timezone_count_failed'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type FilesListData = {
  query?: {
    /**
     * Filter files appearing in a specific channel, indicated by its ID.
     */
    channel?: string;
    count?: string;
    page?: string;
    /**
     * Show truncated file info for files hidden due to being too old, and the team who owns the file being over the file limit.
     */
    show_files_hidden_by_limit?: boolean;
    /**
     * Authentication token. Requires scope: `files:read`
     */
    token?: string;
    /**
     * Filter files created after this timestamp (inclusive).
     */
    ts_from?: number;
    /**
     * Filter files created before this timestamp (inclusive).
     */
    ts_to?: number;
    /**
     * Filter files by type ([see below](#file_types)). You can pass multiple values in the types argument, like `types=spaces,snippets`.The default value is `all`, which does not filter the list.
     */
    types?: string;
    /**
     * Filter files created by a single user.
     */
    user?: string;
  };
};

export type FilesListResponse = {
  files: Array<objs_file>;
  ok: defs_ok_true;
  paging: objs_paging;
};

export type FilesListError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'user_not_found'
    | 'unknown_type'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type FilesRemoteAddData = {
  body?: {
    /**
     * Creator defined GUID for the file.
     */
    external_id?: string;
    /**
     * URL of the remote file.
     */
    external_url?: string;
    /**
     * type of file
     */
    filetype?: string;
    /**
     * A text file (txt, pdf, doc, etc.) containing textual search terms that are used to improve discovery of the remote file.
     */
    indexable_file_contents?: string;
    /**
     * Preview of the document via `multipart/form-data`.
     */
    preview_image?: string;
    /**
     * Title of the file being shared.
     */
    title?: string;
    /**
     * Authentication token. Requires scope: `remote_files:write`
     */
    token?: string;
  };
};

export type FilesRemoteAddResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type FilesRemoteAddError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type FilesRemoteInfoData = {
  query?: {
    /**
     * Creator defined GUID for the file.
     */
    external_id?: string;
    /**
     * Specify a file by providing its ID.
     */
    file?: string;
    /**
     * Authentication token. Requires scope: `remote_files:read`
     */
    token?: string;
  };
};

export type FilesRemoteInfoResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type FilesRemoteInfoError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type FilesRemoteListData = {
  query?: {
    /**
     * Filter files appearing in a specific channel, indicated by its ID.
     */
    channel?: string;
    /**
     * Paginate through collections of data by setting the `cursor` parameter to a `next_cursor` attribute returned by a previous request's `response_metadata`. Default value fetches the first "page" of the collection. See [pagination](/docs/pagination) for more detail.
     */
    cursor?: string;
    /**
     * The maximum number of items to return.
     */
    limit?: number;
    /**
     * Authentication token. Requires scope: `remote_files:read`
     */
    token?: string;
    /**
     * Filter files created after this timestamp (inclusive).
     */
    ts_from?: number;
    /**
     * Filter files created before this timestamp (inclusive).
     */
    ts_to?: number;
  };
};

export type FilesRemoteListResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type FilesRemoteListError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type FilesRemoteRemoveData = {
  body?: {
    /**
     * Creator defined GUID for the file.
     */
    external_id?: string;
    /**
     * Specify a file by providing its ID.
     */
    file?: string;
    /**
     * Authentication token. Requires scope: `remote_files:write`
     */
    token?: string;
  };
};

export type FilesRemoteRemoveResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type FilesRemoteRemoveError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type FilesRemoteShareData = {
  query?: {
    /**
     * Comma-separated list of channel IDs where the file will be shared.
     */
    channels?: string;
    /**
     * The globally unique identifier (GUID) for the file, as set by the app registering the file with Slack.  Either this field or `file` or both are required.
     */
    external_id?: string;
    /**
     * Specify a file registered with Slack by providing its ID. Either this field or `external_id` or both are required.
     */
    file?: string;
    /**
     * Authentication token. Requires scope: `remote_files:share`
     */
    token?: string;
  };
};

export type FilesRemoteShareResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type FilesRemoteShareError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type FilesRemoteUpdateData = {
  body?: {
    /**
     * Creator defined GUID for the file.
     */
    external_id?: string;
    /**
     * URL of the remote file.
     */
    external_url?: string;
    /**
     * Specify a file by providing its ID.
     */
    file?: string;
    /**
     * type of file
     */
    filetype?: string;
    /**
     * File containing contents that can be used to improve searchability for the remote file.
     */
    indexable_file_contents?: string;
    /**
     * Preview of the document via `multipart/form-data`.
     */
    preview_image?: string;
    /**
     * Title of the file being shared.
     */
    title?: string;
    /**
     * Authentication token. Requires scope: `remote_files:write`
     */
    token?: string;
  };
};

export type FilesRemoteUpdateResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type FilesRemoteUpdateError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type FilesRevokePublicUrlData = {
  body?: {
    /**
     * File to revoke
     */
    file?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `files:write:user`
     */
    token?: string;
  };
};

export type FilesRevokePublicUrlResponse = {
  file: objs_file;
  ok: defs_ok_true;
};

export type FilesRevokePublicUrlError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'file_not_found'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type FilesSharedPublicUrlData = {
  body?: {
    /**
     * File to share
     */
    file?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `files:write:user`
     */
    token?: string;
  };
};

export type FilesSharedPublicUrlResponse = {
  file: objs_file;
  ok: defs_ok_true;
};

export type FilesSharedPublicUrlError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'file_not_found'
    | 'not_allowed'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type FilesUploadData = {
  body?: {
    /**
     * Comma-separated list of channel names or IDs where the file will be shared.
     */
    channels?: string;
    /**
     * File contents via a POST variable. If omitting this parameter, you must provide a `file`.
     */
    content?: string;
    /**
     * File contents via `multipart/form-data`. If omitting this parameter, you must submit `content`.
     */
    file?: string;
    /**
     * Filename of file.
     */
    filename?: string;
    /**
     * A [file type](/types/file#file_types) identifier.
     */
    filetype?: string;
    /**
     * The message text introducing the file in specified `channels`.
     */
    initial_comment?: string;
    /**
     * Provide another message's `ts` value to upload this file as a reply. Never use a reply's `ts` value; use its parent instead.
     */
    thread_ts?: number;
    /**
     * Title of file.
     */
    title?: string;
    /**
     * Authentication token. Requires scope: `files:write:user`
     */
    token?: string;
  };
};

export type FilesUploadResponse = {
  file: objs_file;
  ok: defs_ok_true;
};

export type FilesUploadError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'posting_to_general_channel_denied'
    | 'invalid_channel'
    | 'file_uploads_disabled'
    | 'file_uploads_except_images_disabled'
    | 'storage_limit_reached'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type MigrationExchangeData = {
  query: {
    /**
     * Specify team_id starts with `T` in case of Org Token
     */
    team_id?: string;
    /**
     * Specify `true` to convert `W` global user IDs to workspace-specific `U` IDs. Defaults to `false`.
     */
    to_old?: boolean;
    /**
     * Authentication token. Requires scope: `tokens.basic`
     */
    token: string;
    /**
     * A comma-separated list of user ids, up to 400 per request
     */
    users: string;
  };
};

export type MigrationExchangeResponse = {
  enterprise_id: string;
  invalid_user_ids?: Array<string>;
  ok: defs_ok_true;
  team_id: defs_team;
  user_id_map?: {
    [key: string]: unknown;
  };
  [key: string]: unknown | string | defs_ok_true | defs_team;
};

export type MigrationExchangeError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_enterprise_team'
    | 'too_many_users'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type OauthAccessData = {
  query?: {
    /**
     * Issued when you created your application.
     */
    client_id?: string;
    /**
     * Issued when you created your application.
     */
    client_secret?: string;
    /**
     * The `code` param returned via the OAuth callback.
     */
    code?: string;
    /**
     * This must match the originally submitted URI (if one was sent).
     */
    redirect_uri?: string;
    /**
     * Request the user to add your app only to a single channel. Only valid with a [legacy workspace app](https://api.slack.com/legacy-workspace-apps).
     */
    single_channel?: boolean;
  };
};

export type OauthAccessResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type OauthAccessError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type OauthTokenData = {
  query?: {
    /**
     * Issued when you created your application.
     */
    client_id?: string;
    /**
     * Issued when you created your application.
     */
    client_secret?: string;
    /**
     * The `code` param returned via the OAuth callback.
     */
    code?: string;
    /**
     * This must match the originally submitted URI (if one was sent).
     */
    redirect_uri?: string;
    /**
     * Request the user to add your app only to a single channel.
     */
    single_channel?: boolean;
  };
};

export type OauthTokenResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type OauthTokenError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type OauthV2AccessData = {
  query: {
    /**
     * Issued when you created your application.
     */
    client_id?: string;
    /**
     * Issued when you created your application.
     */
    client_secret?: string;
    /**
     * The `code` param returned via the OAuth callback.
     */
    code: string;
    /**
     * This must match the originally submitted URI (if one was sent).
     */
    redirect_uri?: string;
  };
};

export type OauthV2AccessResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type OauthV2AccessError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type PinsAddData = {
  body: {
    /**
     * Channel to pin the item in.
     */
    channel: string;
    /**
     * Timestamp of the message to pin.
     */
    timestamp?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `pins:write`
     */
    token: string;
  };
};

export type PinsAddResponse = {
  ok: defs_ok_true;
};

export type PinsAddError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'bad_timestamp'
    | 'message_not_found'
    | 'channel_not_found'
    | 'no_item_specified'
    | 'already_pinned'
    | 'permission_denied'
    | 'file_not_shared'
    | 'not_pinnable'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type PinsListData = {
  query: {
    /**
     * Channel to get pinned items for.
     */
    channel: string;
    /**
     * Authentication token. Requires scope: `pins:read`
     */
    token: string;
  };
};

export type PinsListResponse = unknown;

export type PinsListError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'channel_not_found'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type PinsRemoveData = {
  body: {
    /**
     * Channel where the item is pinned to.
     */
    channel: string;
    /**
     * Timestamp of the message to un-pin.
     */
    timestamp?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `pins:write`
     */
    token: string;
  };
};

export type PinsRemoveResponse = {
  ok: defs_ok_true;
};

export type PinsRemoveError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'bad_timestamp'
    | 'file_not_found'
    | 'file_comment_not_found'
    | 'message_not_found'
    | 'no_item_specified'
    | 'not_pinned'
    | 'permission_denied'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_typ'
    | 'missing_post_typ'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeou'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type ReactionsAddData = {
  body: {
    /**
     * Channel where the message to add reaction to was posted.
     */
    channel: string;
    /**
     * Reaction (emoji) name.
     */
    name: string;
    /**
     * Timestamp of the message to add reaction to.
     */
    timestamp: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `reactions:write`
     */
    token: string;
  };
};

export type ReactionsAddResponse = {
  ok: defs_ok_true;
};

export type ReactionsAddError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'bad_timestamp'
    | 'message_not_found'
    | 'no_item_specified'
    | 'invalid_name'
    | 'already_reacted'
    | 'too_many_emoji'
    | 'too_many_reactions'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type ReactionsGetData = {
  query: {
    /**
     * Channel where the message to get reactions for was posted.
     */
    channel?: string;
    /**
     * File to get reactions for.
     */
    file?: string;
    /**
     * File comment to get reactions for.
     */
    file_comment?: string;
    /**
     * If true always return the complete reaction list.
     */
    full?: boolean;
    /**
     * Timestamp of the message to get reactions for.
     */
    timestamp?: string;
    /**
     * Authentication token. Requires scope: `reactions:read`
     */
    token: string;
  };
};

export type ReactionsGetResponse = {
  [key: string]: unknown;
};

export type ReactionsGetError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'bad_timestamp'
    | 'file_not_found'
    | 'file_comment_not_found'
    | 'message_not_found'
    | 'no_item_specified'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type ReactionsListData = {
  query: {
    count?: number;
    /**
     * Parameter for pagination. Set `cursor` equal to the `next_cursor` attribute returned by the previous request's `response_metadata`. This parameter is optional, but pagination is mandatory: the default value simply fetches the first "page" of the collection. See [pagination](/docs/pagination) for more details.
     */
    cursor?: string;
    /**
     * If true always return the complete reaction list.
     */
    full?: boolean;
    /**
     * The maximum number of items to return. Fewer than the requested number of items may be returned, even if the end of the list hasn't been reached.
     */
    limit?: number;
    page?: number;
    /**
     * Authentication token. Requires scope: `reactions:read`
     */
    token: string;
    /**
     * Show reactions made by this user. Defaults to the authed user.
     */
    user?: string;
  };
};

export type ReactionsListResponse = {
  items: Array<unknown>;
  ok: defs_ok_true;
  paging?: objs_paging;
  response_metadata?: objs_response_metadata;
};

export type ReactionsListError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'user_not_found'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactiv'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type ReactionsRemoveData = {
  body: {
    /**
     * Channel where the message to remove reaction from was posted.
     */
    channel?: string;
    /**
     * File to remove reaction from.
     */
    file?: string;
    /**
     * File comment to remove reaction from.
     */
    file_comment?: string;
    /**
     * Reaction (emoji) name.
     */
    name: string;
    /**
     * Timestamp of the message to remove reaction from.
     */
    timestamp?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `reactions:write`
     */
    token: string;
  };
};

export type ReactionsRemoveResponse = {
  ok: defs_ok_true;
};

export type ReactionsRemoveError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'bad_timestamp'
    | 'file_not_found'
    | 'file_comment_not_found'
    | 'message_not_found'
    | 'no_item_specified'
    | 'invalid_name'
    | 'no_reaction'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type RemindersAddData = {
  body: {
    /**
     * The content of the reminder
     */
    text: string;
    /**
     * When this reminder should happen: the Unix timestamp (up to five years from now), the number of seconds until the reminder (if within 24 hours), or a natural language description (Ex. "in 15 minutes," or "every Thursday")
     */
    time: string;
    /**
     * The user who will receive the reminder. If no user is specified, the reminder will go to user who created it.
     */
    user?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `reminders:write`
     */
    token: string;
  };
};

export type RemindersAddResponse = {
  ok: defs_ok_true;
  reminder: objs_reminder;
};

export type RemindersAddError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'cannot_parse'
    | 'user_not_found'
    | 'cannot_add_bot'
    | 'cannot_add_slackbot'
    | 'cannot_add_others'
    | 'cannot_add_others_recurring'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type RemindersCompleteData = {
  body?: {
    /**
     * The ID of the reminder to be marked as complete
     */
    reminder?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `reminders:write`
     */
    token?: string;
  };
};

export type RemindersCompleteResponse = {
  ok: defs_ok_true;
};

export type RemindersCompleteError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_found'
    | 'cannot_complete_recurring'
    | 'cannot_complete_others'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type RemindersDeleteData = {
  body?: {
    /**
     * The ID of the reminder
     */
    reminder?: string;
  };
  headers?: {
    /**
     * Authentication token. Requires scope: `reminders:write`
     */
    token?: string;
  };
};

export type RemindersDeleteResponse = {
  ok: defs_ok_true;
};

export type RemindersDeleteError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_found'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type RemindersInfoData = {
  query?: {
    /**
     * The ID of the reminder
     */
    reminder?: string;
    /**
     * Authentication token. Requires scope: `reminders:read`
     */
    token?: string;
  };
};

export type RemindersInfoResponse = {
  ok: defs_ok_true;
  reminder: objs_reminder;
};

export type RemindersInfoError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_found'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type RemindersListData = {
  query?: {
    /**
     * Authentication token. Requires scope: `reminders:read`
     */
    token?: string;
  };
};

export type RemindersListResponse = {
  ok: defs_ok_true;
  reminders: Array<objs_reminder>;
};

export type RemindersListError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type RtmConnectData = {
  query: {
    /**
     * Batch presence deliveries via subscription. Enabling changes the shape of `presence_change` events. See [batch presence](/docs/presence-and-status#batching).
     */
    batch_presence_aware?: boolean;
    /**
     * Only deliver presence events when requested by subscription. See [presence subscriptions](/docs/presence-and-status#subscriptions).
     */
    presence_sub?: boolean;
    /**
     * Authentication token. Requires scope: `rtm:stream`
     */
    token: string;
  };
};

export type RtmConnectResponse = {
  ok: defs_ok_true;
  self: {
    id: defs_user_id;
    name: string;
  };
  team: {
    domain: string;
    id: defs_team;
    name: string;
  };
  url: string;
};

export type RtmConnectError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type SearchMessagesData = {
  query: {
    /**
     * Pass the number of results you want per "page". Maximum of `100`.
     */
    count?: number;
    /**
     * Pass a value of `true` to enable query highlight markers (see below).
     */
    highlight?: boolean;
    page?: number;
    /**
     * Search query.
     */
    query: string;
    /**
     * Return matches sorted by either `score` or `timestamp`.
     */
    sort?: string;
    /**
     * Change sort direction to ascending (`asc`) or descending (`desc`).
     */
    sort_dir?: string;
    /**
     * Authentication token. Requires scope: `search:read`
     */
    token: string;
  };
};

export type SearchMessagesResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type SearchMessagesError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type StarsAddData = {
  body?: {
    /**
     * Channel to add star to, or channel where the message to add star to was posted (used with `timestamp`).
     */
    channel?: string;
    /**
     * File to add star to.
     */
    file?: string;
    /**
     * File comment to add star to.
     */
    file_comment?: string;
    /**
     * Timestamp of the message to add star to.
     */
    timestamp?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `stars:write`
     */
    token: string;
  };
};

export type StarsAddResponse = {
  ok: defs_ok_true;
};

export type StarsAddError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'bad_timestamp'
    | 'message_not_found'
    | 'file_not_found'
    | 'file_comment_not_found'
    | 'channel_not_found'
    | 'no_item_specified'
    | 'already_starred'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type StarsListData = {
  query?: {
    count?: string;
    /**
     * Parameter for pagination. Set `cursor` equal to the `next_cursor` attribute returned by the previous request's `response_metadata`. This parameter is optional, but pagination is mandatory: the default value simply fetches the first "page" of the collection. See [pagination](/docs/pagination) for more details.
     */
    cursor?: string;
    /**
     * The maximum number of items to return. Fewer than the requested number of items may be returned, even if the end of the list hasn't been reached.
     */
    limit?: number;
    page?: string;
    /**
     * Authentication token. Requires scope: `stars:read`
     */
    token?: string;
  };
};

export type StarsListResponse = {
  items: Array<unknown>;
  ok: defs_ok_true;
  paging?: objs_paging;
};

export type StarsListError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type StarsRemoveData = {
  body?: {
    /**
     * Channel to remove star from, or channel where the message to remove star from was posted (used with `timestamp`).
     */
    channel?: string;
    /**
     * File to remove star from.
     */
    file?: string;
    /**
     * File comment to remove star from.
     */
    file_comment?: string;
    /**
     * Timestamp of the message to remove star from.
     */
    timestamp?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `stars:write`
     */
    token: string;
  };
};

export type StarsRemoveResponse = {
  ok: defs_ok_true;
};

export type StarsRemoveError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'bad_timestamp'
    | 'message_not_found'
    | 'file_not_found'
    | 'file_comment_not_found'
    | 'channel_not_found'
    | 'no_item_specified'
    | 'not_starred'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type TeamAccessLogsData = {
  query: {
    /**
     * End of time range of logs to include in results (inclusive).
     */
    before?: string;
    count?: string;
    page?: string;
    /**
     * Authentication token. Requires scope: `admin`
     */
    token: string;
  };
};

export type TeamAccessLogsResponse = {
  logins: Array<{
    count: number;
    country: string | null;
    date_first: number;
    date_last: number;
    ip: string | null;
    isp: string | null;
    region: string | null;
    user_agent: string;
    user_id: defs_user_id;
    username: string;
  }>;
  ok: defs_ok_true;
  paging: objs_paging;
};

export type TeamAccessLogsError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'paid_only'
    | 'over_pagination_limit'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type TeamBillableInfoData = {
  query: {
    /**
     * Authentication token. Requires scope: `admin`
     */
    token: string;
    /**
     * A user to retrieve the billable information for. Defaults to all users.
     */
    user?: string;
  };
};

export type TeamBillableInfoResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type TeamBillableInfoError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type TeamInfoData = {
  query: {
    /**
     * Team to get info on, if omitted, will return information about the current team. Will only return team that the authenticated token is allowed to see through external shared channels
     */
    team?: string;
    /**
     * Authentication token. Requires scope: `team:read`
     */
    token: string;
  };
};

export type TeamInfoResponse = {
  ok: defs_ok_true;
  team: objs_team;
};

export type TeamInfoError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type TeamIntegrationLogsData = {
  query: {
    /**
     * Filter logs to this Slack app. Defaults to all logs.
     */
    app_id?: string;
    /**
     * Filter logs with this change type. Defaults to all logs.
     */
    change_type?: string;
    count?: string;
    page?: string;
    /**
     * Filter logs to this service. Defaults to all logs.
     */
    service_id?: string;
    /**
     * Authentication token. Requires scope: `admin`
     */
    token: string;
    /**
     * Filter logs generated by this user’s actions. Defaults to all logs.
     */
    user?: string;
  };
};

export type TeamIntegrationLogsResponse = {
  logs: Array<{
    admin_app_id?: defs_app_id;
    app_id: defs_app_id;
    app_type: string;
    change_type: string;
    channel?: defs_channel;
    date: string;
    scope: string;
    service_id?: string;
    service_type?: string;
    user_id: defs_user_id;
    user_name: string;
  }>;
  ok: defs_ok_true;
  paging: objs_paging;
};

export type TeamIntegrationLogsError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type TeamProfileGetData = {
  query: {
    /**
     * Authentication token. Requires scope: `users.profile:read`
     */
    token: string;
    /**
     * Filter by visibility.
     */
    visibility?: string;
  };
};

export type TeamProfileGetResponse = {
  ok: defs_ok_true;
  profile: {
    fields: Array<objs_team_profile_field>;
  };
};

export type TeamProfileGetError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_typ'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeou'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type UsergroupsCreateData = {
  body?: {
    /**
     * A comma separated string of encoded channel IDs for which the User Group uses as a default.
     */
    channels?: string;
    /**
     * A short description of the User Group.
     */
    description?: string;
    /**
     * A mention handle. Must be unique among channels, users and User Groups.
     */
    handle?: string;
    /**
     * Include the number of users in each User Group.
     */
    include_count?: boolean;
    /**
     * A name for the User Group. Must be unique among User Groups.
     */
    name: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `usergroups:write`
     */
    token: string;
  };
};

export type UsergroupsCreateResponse = {
  ok: defs_ok_true;
  usergroup: objs_subteam;
};

export type UsergroupsCreateError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'permission_denied'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type UsergroupsDisableData = {
  body?: {
    /**
     * Include the number of users in the User Group.
     */
    include_count?: boolean;
    /**
     * The encoded ID of the User Group to disable.
     */
    usergroup: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `usergroups:write`
     */
    token: string;
  };
};

export type UsergroupsDisableResponse = {
  ok: defs_ok_true;
  usergroup: objs_subteam;
};

export type UsergroupsDisableError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'permission_denied'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type UsergroupsEnableData = {
  body?: {
    /**
     * Include the number of users in the User Group.
     */
    include_count?: boolean;
    /**
     * The encoded ID of the User Group to enable.
     */
    usergroup: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `usergroups:write`
     */
    token: string;
  };
};

export type UsergroupsEnableResponse = {
  ok: defs_ok_true;
  usergroup: objs_subteam;
};

export type UsergroupsEnableError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_require'
    | 'fatal_error'
    | 'missing_charset'
    | 'superfluous_charset';
  ok: defs_ok_false;
};

export type UsergroupsListData = {
  query: {
    /**
     * Include the number of users in each User Group.
     */
    include_count?: boolean;
    /**
     * Include disabled User Groups.
     */
    include_disabled?: boolean;
    /**
     * Include the list of users for each User Group.
     */
    include_users?: boolean;
    /**
     * Authentication token. Requires scope: `usergroups:read`
     */
    token: string;
  };
};

export type UsergroupsListResponse = {
  ok: defs_ok_true;
  usergroups: Array<objs_subteam>;
};

export type UsergroupsListError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_require'
    | 'fatal_error'
    | 'missing_charset'
    | 'superfluous_charset';
  ok: defs_ok_false;
};

export type UsergroupsUpdateData = {
  body?: {
    /**
     * A comma separated string of encoded channel IDs for which the User Group uses as a default.
     */
    channels?: string;
    /**
     * A short description of the User Group.
     */
    description?: string;
    /**
     * A mention handle. Must be unique among channels, users and User Groups.
     */
    handle?: string;
    /**
     * Include the number of users in the User Group.
     */
    include_count?: boolean;
    /**
     * A name for the User Group. Must be unique among User Groups.
     */
    name?: string;
    /**
     * The encoded ID of the User Group to update.
     */
    usergroup: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `usergroups:write`
     */
    token: string;
  };
};

export type UsergroupsUpdateResponse = {
  ok: defs_ok_true;
  usergroup: objs_subteam;
};

export type UsergroupsUpdateError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'permission_denied'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_require'
    | 'fatal_error'
    | 'missing_charset'
    | 'superfluous_charset';
  ok: defs_ok_false;
};

export type UsergroupsUsersListData = {
  query: {
    /**
     * Allow results that involve disabled User Groups.
     */
    include_disabled?: boolean;
    /**
     * Authentication token. Requires scope: `usergroups:read`
     */
    token: string;
    /**
     * The encoded ID of the User Group to update.
     */
    usergroup: string;
  };
};

export type UsergroupsUsersListResponse = {
  ok: defs_ok_true;
  users: Array<defs_user_id>;
};

export type UsergroupsUsersListError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_require'
    | 'fatal_error'
    | 'missing_charset'
    | 'superfluous_charset';
  ok: defs_ok_false;
};

export type UsergroupsUsersUpdateData = {
  body?: {
    /**
     * Include the number of users in the User Group.
     */
    include_count?: boolean;
    /**
     * The encoded ID of the User Group to update.
     */
    usergroup: string;
    /**
     * A comma separated string of encoded user IDs that represent the entire list of users for the User Group.
     */
    users: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `usergroups:write`
     */
    token: string;
  };
};

export type UsergroupsUsersUpdateResponse = {
  ok: defs_ok_true;
  usergroup: objs_subteam;
};

export type UsergroupsUsersUpdateError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'permission_denied'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'user_is_restricted'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_require'
    | 'fatal_error'
    | 'missing_charset'
    | 'superfluous_charset';
  ok: defs_ok_false;
};

export type UsersConversationsData = {
  query?: {
    /**
     * Paginate through collections of data by setting the `cursor` parameter to a `next_cursor` attribute returned by a previous request's `response_metadata`. Default value fetches the first "page" of the collection. See [pagination](/docs/pagination) for more detail.
     */
    cursor?: string;
    /**
     * Set to `true` to exclude archived channels from the list
     */
    exclude_archived?: boolean;
    /**
     * The maximum number of items to return. Fewer than the requested number of items may be returned, even if the end of the list hasn't been reached. Must be an integer no larger than 1000.
     */
    limit?: number;
    /**
     * Authentication token. Requires scope: `conversations:read`
     */
    token?: string;
    /**
     * Mix and match channel types by providing a comma-separated list of any combination of `public_channel`, `private_channel`, `mpim`, `im`
     */
    types?: string;
    /**
     * Browse conversations by a specific user ID's membership. Non-public channels are restricted to those where the calling user shares membership.
     */
    user?: string;
  };
};

export type UsersConversationsResponse = {
  channels: Array<objs_conversation>;
  ok: defs_ok_true;
  response_metadata?: {
    next_cursor: string;
  };
  [key: string]: unknown | objs_conversation | defs_ok_true;
};

export type UsersConversationsError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'method_not_supported_for_channel_type'
    | 'missing_scope'
    | 'invalid_types'
    | 'invalid_cursor'
    | 'invalid_limit'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type UsersDeletePhotoData = {
  body: {
    /**
     * Authentication token. Requires scope: `users.profile:write`
     */
    token: string;
  };
};

export type UsersDeletePhotoResponse = {
  ok: defs_ok_true;
};

export type UsersDeletePhotoError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type UsersGetPresenceData = {
  query: {
    /**
     * Authentication token. Requires scope: `users:read`
     */
    token: string;
    /**
     * User to get presence info on. Defaults to the authed user.
     */
    user?: string;
  };
};

export type UsersGetPresenceResponse = {
  auto_away?: boolean;
  connection_count?: number;
  last_activity?: number;
  manual_away?: boolean;
  ok: defs_ok_true;
  online?: boolean;
  presence: string;
  [key: string]: unknown | boolean | number | defs_ok_true | string;
};

export type UsersGetPresenceError = {
  error: string;
  ok: defs_ok_false;
  [key: string]: (unknown | string | defs_ok_false) | undefined;
};

export type UsersIdentityData = {
  query?: {
    /**
     * Authentication token. Requires scope: `identity.basic`
     */
    token?: string;
  };
};

export type UsersIdentityResponse = unknown;

export type UsersIdentityError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type UsersInfoData = {
  query: {
    /**
     * Set this to `true` to receive the locale for this user. Defaults to `false`
     */
    include_locale?: boolean;
    /**
     * Authentication token. Requires scope: `users:read`
     */
    token: string;
    /**
     * User to get info on
     */
    user?: string;
  };
};

export type UsersInfoResponse = {
  ok: defs_ok_true;
  user: objs_user;
  [key: string]: unknown | defs_ok_true | objs_user;
};

export type UsersInfoError = {
  callstack?: string;
  error:
    | 'user_not_found'
    | 'user_not_visible'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required';
  ok: defs_ok_false;
};

export type UsersListData = {
  query?: {
    /**
     * Paginate through collections of data by setting the `cursor` parameter to a `next_cursor` attribute returned by a previous request's `response_metadata`. Default value fetches the first "page" of the collection. See [pagination](/docs/pagination) for more detail.
     */
    cursor?: string;
    /**
     * Set this to `true` to receive the locale for users. Defaults to `false`
     */
    include_locale?: boolean;
    /**
     * The maximum number of items to return. Fewer than the requested number of items may be returned, even if the end of the users list hasn't been reached. Providing no `limit` value will result in Slack attempting to deliver you the entire result set. If the collection is too large you may experience `limit_required` or HTTP 500 errors.
     */
    limit?: number;
    /**
     * Authentication token. Requires scope: `users:read`
     */
    token?: string;
  };
};

export type UsersListResponse = {
  cache_ts: number;
  members: Array<objs_user>;
  ok: defs_ok_true;
  response_metadata?: objs_response_metadata;
};

export type UsersListError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'limit_required'
    | 'invalid_cursor'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type UsersLookupByEmailData = {
  query: {
    /**
     * An email address belonging to a user in the workspace
     */
    email: string;
    /**
     * Authentication token. Requires scope: `users:read.email`
     */
    token: string;
  };
};

export type UsersLookupByEmailResponse = {
  ok: defs_ok_true;
  user: objs_user;
  [key: string]: unknown | defs_ok_true | objs_user;
};

export type UsersLookupByEmailError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'users_not_found'
    | 'enterprise_is_restricted'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'no_permission'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type UsersProfileGetData = {
  query: {
    /**
     * Include labels for each ID in custom profile fields
     */
    include_labels?: boolean;
    /**
     * Authentication token. Requires scope: `users.profile:read`
     */
    token: string;
    /**
     * User to retrieve profile info for
     */
    user?: string;
  };
};

export type UsersProfileGetResponse = {
  ok: defs_ok_true;
  profile: objs_user_profile;
};

export type UsersProfileGetError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'user_not_found'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type UsersProfileSetData = {
  body?: {
    /**
     * Name of a single key to set. Usable only if `profile` is not passed.
     */
    name?: string;
    /**
     * Collection of key:value pairs presented as a URL-encoded JSON hash. At most 50 fields may be set. Each field name is limited to 255 characters.
     */
    profile?: string;
    /**
     * ID of user to change. This argument may only be specified by team admins on paid teams.
     */
    user?: string;
    /**
     * Value to set a single key to. Usable only if `profile` is not passed.
     */
    value?: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `users.profile:write`
     */
    token: string;
  };
};

export type UsersProfileSetResponse = {
  email_pending?: string;
  ok: defs_ok_true;
  profile: objs_user_profile;
  username: string;
};

export type UsersProfileSetError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'reserved_name'
    | 'invalid_profile'
    | 'profile_set_failed'
    | 'not_admin'
    | 'not_app_admin'
    | 'cannot_update_admin_user'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type UsersSetActiveData = {
  headers: {
    /**
     * Authentication token. Requires scope: `users:write`
     */
    token: string;
  };
};

export type UsersSetActiveResponse = {
  ok: defs_ok_true;
};

export type UsersSetActiveError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'ekm_access_denied'
    | 'missing_scope'
    | 'invalid_arguments'
    | 'invalid_arg_name'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'request_timeout'
    | 'fatal_error'
    | 'internal_error';
  ok: defs_ok_false;
};

export type UsersSetPhotoData = {
  body: {
    /**
     * Width/height of crop box (always square)
     */
    crop_w?: string;
    /**
     * X coordinate of top-left corner of crop box
     */
    crop_x?: string;
    /**
     * Y coordinate of top-left corner of crop box
     */
    crop_y?: string;
    /**
     * File contents via `multipart/form-data`.
     */
    image?: string;
    /**
     * Authentication token. Requires scope: `users.profile:write`
     */
    token: string;
  };
};

export type UsersSetPhotoResponse = {
  ok: defs_ok_true;
  profile: {
    avatar_hash: string;
    image_1024: string;
    image_192: string;
    image_24: string;
    image_32: string;
    image_48: string;
    image_512: string;
    image_72: string;
    image_original: string;
  };
};

export type UsersSetPhotoError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  /**
   * possibly DEV/QA only
   */
  debug_step?: string;
  /**
   * possibly DEV/QA only
   */
  dims?: string;
  error:
    | 'bad_image'
    | 'too_large'
    | 'too_many_frames'
    | 'not_found'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'user_is_bot'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
  /**
   * possibly DEV/QA only
   */
  time_ident?: number;
};

export type UsersSetPresenceData = {
  body: {
    /**
     * Either `auto` or `away`
     */
    presence: string;
  };
  headers: {
    /**
     * Authentication token. Requires scope: `users:write`
     */
    token: string;
  };
};

export type UsersSetPresenceResponse = {
  ok: defs_ok_true;
};

export type UsersSetPresenceError = {
  /**
   * Note: PHP callstack is only visible in dev/qa
   */
  callstack?: string;
  error:
    | 'invalid_presence'
    | 'not_authed'
    | 'invalid_auth'
    | 'account_inactive'
    | 'token_revoked'
    | 'no_permission'
    | 'org_login_required'
    | 'invalid_arg_name'
    | 'invalid_array_arg'
    | 'invalid_charset'
    | 'invalid_form_data'
    | 'invalid_post_type'
    | 'missing_post_type'
    | 'team_added_to_org'
    | 'invalid_json'
    | 'json_not_object'
    | 'request_timeout'
    | 'upgrade_required'
    | 'fatal_error';
  ok: defs_ok_false;
};

export type ViewsOpenData = {
  headers: {
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
  };
  query: {
    /**
     * Exchange a trigger to post to the user.
     */
    trigger_id: string;
    /**
     * A [view payload](/reference/surfaces/views). This must be a JSON-encoded string.
     */
    view: string;
  };
};

export type ViewsOpenResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type ViewsOpenError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type ViewsPublishData = {
  headers: {
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
  };
  query: {
    /**
     * A string that represents view state to protect against possible race conditions.
     */
    hash?: string;
    /**
     * `id` of the user you want publish a view to.
     */
    user_id: string;
    /**
     * A [view payload](/reference/surfaces/views). This must be a JSON-encoded string.
     */
    view: string;
  };
};

export type ViewsPublishResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type ViewsPublishError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type ViewsPushData = {
  headers: {
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
  };
  query: {
    /**
     * Exchange a trigger to post to the user.
     */
    trigger_id: string;
    /**
     * A [view payload](/reference/surfaces/views). This must be a JSON-encoded string.
     */
    view: string;
  };
};

export type ViewsPushResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type ViewsPushError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type ViewsUpdateData = {
  headers: {
    /**
     * Authentication token. Requires scope: `none`
     */
    token: string;
  };
  query?: {
    /**
     * A unique identifier of the view set by the developer. Must be unique for all views on a team. Max length of 255 characters. Either `view_id` or `external_id` is required.
     */
    external_id?: string;
    /**
     * A string that represents view state to protect against possible race conditions.
     */
    hash?: string;
    /**
     * A [view object](/reference/surfaces/views). This must be a JSON-encoded string.
     */
    view?: string;
    /**
     * A unique identifier of the view to be updated. Either `view_id` or `external_id` is required.
     */
    view_id?: string;
  };
};

export type ViewsUpdateResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type ViewsUpdateError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type WorkflowsStepCompletedData = {
  headers: {
    /**
     * Authentication token. Requires scope: `workflow.steps:execute`
     */
    token: string;
  };
  query: {
    /**
     * Key-value object of outputs from your step. Keys of this object reflect the configured `key` properties of your [`outputs`](/reference/workflows/workflow_step#output) array from your `workflow_step` object.
     */
    outputs?: string;
    /**
     * Context identifier that maps to the correct workflow step execution.
     */
    workflow_step_execute_id: string;
  };
};

export type WorkflowsStepCompletedResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type WorkflowsStepCompletedError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type WorkflowsStepFailedData = {
  headers: {
    /**
     * Authentication token. Requires scope: `workflow.steps:execute`
     */
    token: string;
  };
  query: {
    /**
     * A JSON-based object with a `message` property that should contain a human readable error message.
     */
    error: string;
    /**
     * Context identifier that maps to the correct workflow step execution.
     */
    workflow_step_execute_id: string;
  };
};

export type WorkflowsStepFailedResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type WorkflowsStepFailedError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};

export type WorkflowsUpdateStepData = {
  headers: {
    /**
     * Authentication token. Requires scope: `workflow.steps:execute`
     */
    token: string;
  };
  query: {
    /**
     * A JSON key-value map of inputs required from a user during configuration. This is the data your app expects to receive when the workflow step starts. **Please note**: the embedded variable format is set and replaced by the workflow system. You cannot create custom variables that will be replaced at runtime. [Read more about variables in workflow steps here](/workflows/steps#variables).
     */
    inputs?: string;
    /**
     * An JSON array of output objects used during step execution. This is the data your app agrees to provide when your workflow step was executed.
     */
    outputs?: string;
    /**
     * An optional field that can be used to override app image that is shown in the Workflow Builder.
     */
    step_image_url?: string;
    /**
     * An optional field that can be used to override the step name that is shown in the Workflow Builder.
     */
    step_name?: string;
    /**
     * A context identifier provided with `view_submission` payloads used to call back to `workflows.updateStep`.
     */
    workflow_step_edit_id: string;
  };
};

export type WorkflowsUpdateStepResponse = {
  ok: defs_ok_true;
  [key: string]: unknown | defs_ok_true;
};

export type WorkflowsUpdateStepError = {
  ok: defs_ok_false;
  [key: string]: unknown | defs_ok_false;
};
