// This file is auto-generated by @hey-api/openapi-ts

export const blocksSchema = {
  description:
    "This is a very loose definition, in the future, we'll populate this with deeper schema in this definition namespace.",
  items: {
    additionalProperties: true,
    properties: {
      type: {
        type: 'string',
      },
    },
    required: ['type'],
    type: 'object',
  },
  title: 'Block Kit blocks',
  type: 'array',
} as const;

export const defs_app_idSchema = {
  pattern: '^A[A-Z0-9]{1,}$',
  title: 'App ID',
  type: 'string',
} as const;

export const defs_bot_idSchema = {
  pattern: '^B[A-Z0-9]{8,}$',
  title: 'Bot User ID',
  type: 'string',
} as const;

export const defs_channelSchema = {
  pattern: '^[CGD][A-Z0-9]{8,}$',
  title: 'Channel-like conversation ID',
  type: 'string',
} as const;

export const defs_channel_idSchema = {
  pattern: '^[C][A-Z0-9]{2,}$',
  title: 'Channel ID',
  type: 'string',
} as const;

export const defs_channel_nameSchema = {
  title: 'Name of a channel',
  type: 'string',
} as const;

export const defs_comment_idSchema = {
  pattern: '^Fc[A-Z0-9]{8,}$',
  title: 'File Comment ID',
  type: 'string',
} as const;

export const defs_dm_idSchema = {
  pattern: '^[D][A-Z0-9]{8,}$',
  title: 'Direct Message Channel ID',
  type: 'string',
} as const;

export const defs_enterprise_idSchema = {
  pattern: '^[E][A-Z0-9]{8,}$',
  title: 'Enterprise ID',
  type: 'string',
} as const;

export const defs_enterprise_nameSchema = {
  title: 'Name of the enterprise org',
  type: 'string',
} as const;

export const defs_enterprise_user_idSchema = {
  pattern: '^[WU][A-Z0-9]{8,}$',
  title: 'Enterprise User ID',
  type: 'string',
} as const;

export const defs_file_idSchema = {
  pattern: '^[F][A-Z0-9]{8,}$',
  title: 'File ID',
  type: 'string',
} as const;

export const defs_group_idSchema = {
  pattern: '^[G][A-Z0-9]{8,}$',
  title: 'Private Channel ID',
  type: 'string',
} as const;

export const defs_ok_falseSchema = {
  enum: [false],
  title: 'default failure response',
  type: 'boolean',
} as const;

export const defs_ok_trueSchema = {
  enum: [true],
  title: 'default success response',
  type: 'boolean',
} as const;

export const defs_optional_app_idSchema = {
  pattern: '^(A[A-Z0-9]{1,})?$',
  title: 'App ID or empty string',
  type: 'string',
} as const;

export const defs_pinned_infoSchema = {
  additionalProperties: false,
  title: 'Info for a pinned item',
  type: 'object',
} as const;

export const defs_reminder_idSchema = {
  pattern: '^Rm[A-Z0-9]{8,}$',
  title: 'Reminder ID',
  type: 'string',
} as const;

export const defs_subteam_idSchema = {
  pattern: '^S[A-Z0-9]{2,}$',
  title: 'Subteam ID',
  type: 'string',
} as const;

export const defs_teamSchema = {
  pattern: '^[T][A-Z0-9]{2,}$',
  title: 'Team ID',
  type: 'string',
} as const;

export const defs_topic_purpose_creatorSchema = {
  pattern: '^[UW][A-Z0-9]{8,}$|^$',
  title: 'User ID or empty string, used for topic and purpose creation',
  type: 'string',
} as const;

export const defs_tsSchema = {
  pattern: '^\\d{10}\\.\\d{6}$',
  title: 'Timestamp in format 0123456789.012345',
  type: 'string',
} as const;

export const defs_user_idSchema = {
  pattern: '^[UW][A-Z0-9]{2,}$',
  title: 'User ID',
  type: 'string',
} as const;

export const defs_workspace_idSchema = {
  pattern: '^[TE][A-Z0-9]{8,}$',
  title: 'Team or Enterprise ID',
  type: 'string',
} as const;

export const objs_bot_profileSchema = {
  additionalProperties: false,
  properties: {
    app_id: {
      $ref: '#/components/schemas/defs_app_id',
    },
    deleted: {
      type: 'boolean',
    },
    icons: {
      additionalProperties: false,
      properties: {
        image_36: {
          format: 'uri',
          type: 'string',
        },
        image_48: {
          format: 'uri',
          type: 'string',
        },
        image_72: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['image_36', 'image_48', 'image_72'],
      type: 'object',
    },
    id: {
      $ref: '#/components/schemas/defs_bot_id',
    },
    name: {
      type: 'string',
    },
    team_id: {
      $ref: '#/components/schemas/defs_team',
    },
    updated: {
      type: 'integer',
    },
  },
  required: ['id', 'deleted', 'name', 'updated', 'app_id', 'icons', 'team_id'],
  title: 'Bot Profile Object',
  type: 'object',
} as const;

export const objs_channelSchema = {
  additionalProperties: false,
  properties: {
    accepted_user: {
      $ref: '#/components/schemas/defs_user_id',
    },
    created: {
      type: 'integer',
    },
    creator: {
      $ref: '#/components/schemas/defs_user_id',
    },
    id: {
      $ref: '#/components/schemas/defs_channel_id',
    },
    is_archived: {
      type: 'boolean',
    },
    is_channel: {
      type: 'boolean',
    },
    is_frozen: {
      type: 'boolean',
    },
    is_general: {
      type: 'boolean',
    },
    is_member: {
      type: 'boolean',
    },
    is_moved: {
      type: 'integer',
    },
    is_mpim: {
      type: 'boolean',
    },
    is_non_threadable: {
      type: 'boolean',
    },
    is_org_shared: {
      type: 'boolean',
    },
    is_pending_ext_shared: {
      type: 'boolean',
    },
    is_private: {
      type: 'boolean',
    },
    is_read_only: {
      type: 'boolean',
    },
    is_shared: {
      type: 'boolean',
    },
    is_thread_only: {
      type: 'boolean',
    },
    last_read: {
      $ref: '#/components/schemas/defs_ts',
    },
    latest: {
      items: {
        anyOf: [
          {
            $ref: '#/components/schemas/objs_message',
          },
          {
            nullable: true,
          },
        ],
      },
    },
    members: {
      items: {
        $ref: '#/components/schemas/defs_user_id',
      },
      minItems: 0,
      type: 'array',
      uniqueItems: true,
    },
    name: {
      type: 'string',
    },
    name_normalized: {
      type: 'string',
    },
    num_members: {
      type: 'integer',
    },
    pending_shared: {
      items: {
        $ref: '#/components/schemas/defs_team',
      },
      minItems: 0,
      type: 'array',
      uniqueItems: true,
    },
    previous_names: {
      items: {
        $ref: '#/components/schemas/defs_channel_name',
      },
      minItems: 0,
      type: 'array',
      uniqueItems: true,
    },
    priority: {
      type: 'number',
    },
    purpose: {
      additionalProperties: false,
      properties: {
        creator: {
          $ref: '#/components/schemas/defs_topic_purpose_creator',
        },
        last_set: {
          type: 'integer',
        },
        value: {
          type: 'string',
        },
      },
      required: ['value', 'creator', 'last_set'],
      type: 'object',
    },
    topic: {
      additionalProperties: false,
      properties: {
        creator: {
          $ref: '#/components/schemas/defs_topic_purpose_creator',
        },
        last_set: {
          type: 'integer',
        },
        value: {
          type: 'string',
        },
      },
      required: ['value', 'creator', 'last_set'],
      type: 'object',
    },
    unlinked: {
      title: 'Field to determine whether a channel has ever been shared/disconnected in the past',
      type: 'integer',
    },
    unread_count: {
      type: 'integer',
    },
    unread_count_display: {
      type: 'integer',
    },
  },
  required: [
    'id',
    'name',
    'created',
    'creator',
    'is_channel',
    'is_org_shared',
    'is_private',
    'is_mpim',
    'is_shared',
    'name_normalized',
    'members',
    'topic',
    'purpose',
  ],
  title: 'Channel Object',
  type: 'object',
} as const;

export const objs_commentSchema = {
  additionalProperties: false,
  properties: {
    comment: {
      type: 'string',
    },
    created: {
      type: 'integer',
    },
    id: {
      $ref: '#/components/schemas/defs_comment_id',
    },
    is_intro: {
      type: 'boolean',
    },
    is_starred: {
      type: 'boolean',
    },
    num_stars: {
      type: 'integer',
    },
    pinned_info: {
      $ref: '#/components/schemas/defs_pinned_info',
    },
    pinned_to: {
      items: {
        $ref: '#/components/schemas/defs_channel',
      },
      type: 'array',
    },
    reactions: {
      items: {
        $ref: '#/components/schemas/objs_reaction',
      },
      type: 'array',
    },
    timestamp: {
      type: 'integer',
    },
    user: {
      $ref: '#/components/schemas/defs_user_id',
    },
  },
  required: ['id', 'created', 'timestamp', 'user', 'is_intro', 'comment'],
  title: 'File Comment Object',
  type: 'object',
} as const;

export const objs_commentsSchema = {
  items: {},
  title: 'file comments object',
  type: 'array',
} as const;

export const objs_conversationSchema = {
  items: {
    anyOf: [
      {
        additionalProperties: false,
        properties: {
          accepted_user: {
            $ref: '#/components/schemas/defs_user_id',
          },
          connected_team_ids: {
            items: {
              $ref: '#/components/schemas/defs_workspace_id',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          conversation_host_id: {
            $ref: '#/components/schemas/defs_workspace_id',
          },
          created: {
            type: 'integer',
          },
          creator: {
            $ref: '#/components/schemas/defs_user_id',
          },
          display_counts: {
            additionalProperties: false,
            properties: {
              display_counts: {
                type: 'integer',
              },
              guest_counts: {
                type: 'integer',
              },
            },
            required: ['display_counts', 'guest_counts'],
            type: 'object',
          },
          enterprise_id: {
            $ref: '#/components/schemas/defs_enterprise_id',
          },
          has_pins: {
            type: 'boolean',
          },
          id: {
            $ref: '#/components/schemas/defs_channel',
          },
          internal_team_ids: {
            items: {
              $ref: '#/components/schemas/defs_team',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          is_archived: {
            type: 'boolean',
          },
          is_channel: {
            type: 'boolean',
          },
          is_ext_shared: {
            type: 'boolean',
          },
          is_frozen: {
            type: 'boolean',
          },
          is_general: {
            type: 'boolean',
          },
          is_global_shared: {
            type: 'boolean',
          },
          is_group: {
            type: 'boolean',
          },
          is_im: {
            type: 'boolean',
          },
          is_member: {
            type: 'boolean',
          },
          is_moved: {
            type: 'integer',
          },
          is_mpim: {
            enum: [false],
            type: 'boolean',
          },
          is_non_threadable: {
            type: 'boolean',
          },
          is_open: {
            type: 'boolean',
          },
          is_org_default: {
            type: 'boolean',
          },
          is_org_mandatory: {
            type: 'boolean',
          },
          is_org_shared: {
            type: 'boolean',
          },
          is_pending_ext_shared: {
            type: 'boolean',
          },
          is_private: {
            type: 'boolean',
          },
          is_read_only: {
            type: 'boolean',
          },
          is_shared: {
            type: 'boolean',
          },
          is_starred: {
            type: 'boolean',
          },
          is_thread_only: {
            type: 'boolean',
          },
          last_read: {
            $ref: '#/components/schemas/defs_ts',
          },
          latest: {
            items: {
              anyOf: [
                {
                  $ref: '#/components/schemas/objs_message',
                },
                {
                  nullable: true,
                },
              ],
            },
          },
          members: {
            items: {
              $ref: '#/components/schemas/defs_user_id',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          name: {
            type: 'string',
          },
          name_normalized: {
            type: 'string',
          },
          num_members: {
            type: 'integer',
          },
          parent_conversation: {
            items: {
              anyOf: [
                {
                  $ref: '#/components/schemas/defs_channel',
                },
                {
                  nullable: true,
                },
              ],
            },
          },
          pending_connected_team_ids: {
            items: {
              $ref: '#/components/schemas/defs_team',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          pending_shared: {
            items: {
              $ref: '#/components/schemas/defs_team',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          pin_count: {
            type: 'integer',
          },
          previous_names: {
            items: {
              $ref: '#/components/schemas/defs_channel_name',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          priority: {
            type: 'number',
          },
          purpose: {
            additionalProperties: false,
            properties: {
              creator: {
                $ref: '#/components/schemas/defs_topic_purpose_creator',
              },
              last_set: {
                type: 'integer',
              },
              value: {
                type: 'string',
              },
            },
            required: ['value', 'creator', 'last_set'],
            type: 'object',
          },
          shared_team_ids: {
            items: {
              $ref: '#/components/schemas/defs_team',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          shares: {
            items: {
              additionalProperties: false,
              properties: {
                accepted_user: {
                  $ref: '#/components/schemas/defs_user_id',
                },
                is_active: {
                  type: 'boolean',
                },
                team: {
                  $ref: '#/components/schemas/objs_team',
                },
                user: {
                  $ref: '#/components/schemas/defs_user_id',
                },
              },
              required: ['team', 'user', 'is_active'],
              type: 'object',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          timezone_count: {
            type: 'integer',
          },
          topic: {
            additionalProperties: false,
            properties: {
              creator: {
                $ref: '#/components/schemas/defs_topic_purpose_creator',
              },
              last_set: {
                type: 'integer',
              },
              value: {
                type: 'string',
              },
            },
            required: ['value', 'creator', 'last_set'],
            type: 'object',
          },
          unlinked: {
            title: 'Field to determine whether a channel has ever been shared/disconnected in the past',
            type: 'integer',
          },
          unread_count: {
            type: 'integer',
          },
          unread_count_display: {
            type: 'integer',
          },
          use_case: {
            type: 'string',
          },
          user: {
            $ref: '#/components/schemas/defs_user_id',
          },
          version: {
            type: 'integer',
          },
        },
        required: [
          'id',
          'name',
          'created',
          'creator',
          'is_archived',
          'is_channel',
          'is_general',
          'is_mpim',
          'is_group',
          'is_org_shared',
          'is_im',
          'is_shared',
          'is_private',
          'name_normalized',
          'topic',
          'purpose',
        ],
        title: 'Conversation object',
        type: 'object',
      },
      {
        additionalProperties: false,
        properties: {
          accepted_user: {
            $ref: '#/components/schemas/defs_user_id',
          },
          connected_team_ids: {
            items: {
              $ref: '#/components/schemas/defs_team',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          conversation_host_id: {
            $ref: '#/components/schemas/defs_workspace_id',
          },
          created: {
            type: 'integer',
          },
          creator: {
            $ref: '#/components/schemas/defs_user_id',
          },
          display_counts: {
            additionalProperties: false,
            properties: {
              display_counts: {
                type: 'integer',
              },
              guest_counts: {
                type: 'integer',
              },
            },
            required: ['display_counts', 'guest_counts'],
            type: 'object',
          },
          id: {
            $ref: '#/components/schemas/defs_channel',
          },
          internal_team_ids: {
            items: {
              $ref: '#/components/schemas/defs_team',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          is_archived: {
            type: 'boolean',
          },
          is_channel: {
            type: 'boolean',
          },
          is_ext_shared: {
            type: 'boolean',
          },
          is_frozen: {
            type: 'boolean',
          },
          is_general: {
            type: 'boolean',
          },
          is_group: {
            type: 'boolean',
          },
          is_im: {
            type: 'boolean',
          },
          is_member: {
            type: 'boolean',
          },
          is_moved: {
            type: 'integer',
          },
          is_mpim: {
            enum: [true],
            type: 'boolean',
          },
          is_non_threadable: {
            type: 'boolean',
          },
          is_open: {
            type: 'boolean',
          },
          is_org_shared: {
            type: 'boolean',
          },
          is_pending_ext_shared: {
            type: 'boolean',
          },
          is_private: {
            type: 'boolean',
          },
          is_read_only: {
            type: 'boolean',
          },
          is_shared: {
            type: 'boolean',
          },
          is_starred: {
            type: 'boolean',
          },
          is_thread_only: {
            type: 'boolean',
          },
          last_read: {
            $ref: '#/components/schemas/defs_ts',
          },
          latest: {
            items: {
              anyOf: [
                {
                  $ref: '#/components/schemas/objs_message',
                },
                {
                  nullable: true,
                },
              ],
            },
          },
          members: {
            items: {
              $ref: '#/components/schemas/defs_user_id',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          name: {
            type: 'string',
          },
          name_normalized: {
            type: 'string',
          },
          num_members: {
            type: 'integer',
          },
          parent_conversation: {
            items: {
              anyOf: [
                {
                  $ref: '#/components/schemas/defs_channel',
                },
                {
                  nullable: true,
                },
              ],
            },
          },
          pending_connected_team_ids: {
            items: {
              $ref: '#/components/schemas/defs_team',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          pending_shared: {
            items: {
              $ref: '#/components/schemas/defs_team',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          pin_count: {
            type: 'integer',
          },
          previous_names: {
            items: {
              $ref: '#/components/schemas/defs_channel_name',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          priority: {
            type: 'number',
          },
          purpose: {
            additionalProperties: false,
            properties: {
              creator: {
                $ref: '#/components/schemas/defs_topic_purpose_creator',
              },
              last_set: {
                type: 'integer',
              },
              value: {
                type: 'string',
              },
            },
            required: ['value', 'creator', 'last_set'],
            type: 'object',
          },
          shared_team_ids: {
            items: {
              $ref: '#/components/schemas/defs_team',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          shares: {
            items: {
              additionalProperties: false,
              properties: {
                accepted_user: {
                  $ref: '#/components/schemas/defs_user_id',
                },
                is_active: {
                  type: 'boolean',
                },
                team: {
                  $ref: '#/components/schemas/objs_team',
                },
                user: {
                  $ref: '#/components/schemas/defs_user_id',
                },
              },
              required: ['team', 'user', 'is_active'],
              type: 'object',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          timezone_count: {
            type: 'integer',
          },
          topic: {
            additionalProperties: false,
            properties: {
              creator: {
                $ref: '#/components/schemas/defs_topic_purpose_creator',
              },
              last_set: {
                type: 'integer',
              },
              value: {
                type: 'string',
              },
            },
            required: ['value', 'creator', 'last_set'],
            type: 'object',
          },
          unlinked: {
            title: 'Field to determine whether a channel has ever been shared/disconnected in the past',
            type: 'integer',
          },
          unread_count: {
            type: 'integer',
          },
          unread_count_display: {
            type: 'integer',
          },
          user: {
            $ref: '#/components/schemas/defs_user_id',
          },
          version: {
            type: 'integer',
          },
        },
        required: [
          'id',
          'name',
          'created',
          'creator',
          'is_archived',
          'is_channel',
          'is_general',
          'is_mpim',
          'is_group',
          'is_org_shared',
          'is_im',
          'is_shared',
          'is_private',
          'name_normalized',
          'topic',
          'purpose',
        ],
        title: 'Conversation MPIM Object',
        type: 'object',
      },
      {
        additionalProperties: false,
        properties: {
          created: {
            type: 'integer',
          },
          has_pins: {
            type: 'boolean',
          },
          id: {
            $ref: '#/components/schemas/defs_dm_id',
          },
          is_archived: {
            type: 'boolean',
          },
          is_ext_shared: {
            type: 'boolean',
          },
          is_frozen: {
            type: 'boolean',
          },
          is_im: {
            type: 'boolean',
          },
          is_open: {
            type: 'boolean',
          },
          is_org_shared: {
            type: 'boolean',
          },
          is_shared: {
            type: 'boolean',
          },
          is_starred: {
            type: 'boolean',
          },
          is_user_deleted: {
            type: 'boolean',
          },
          last_read: {
            $ref: '#/components/schemas/defs_ts',
          },
          latest: {
            items: {
              anyOf: [
                {
                  $ref: '#/components/schemas/objs_message',
                },
                {
                  nullable: true,
                },
              ],
            },
          },
          parent_conversation: {
            items: {
              anyOf: [
                {
                  $ref: '#/components/schemas/defs_channel',
                },
                {
                  nullable: true,
                },
              ],
            },
          },
          pin_count: {
            type: 'integer',
          },
          priority: {
            type: 'number',
          },
          shares: {
            items: {
              additionalProperties: false,
              properties: {
                date_create: {
                  type: 'integer',
                },
                id: {
                  $ref: '#/components/schemas/defs_team',
                },
                is_active: {
                  type: 'boolean',
                },
                name: {
                  type: 'string',
                },
                team: {
                  $ref: '#/components/schemas/objs_team',
                },
              },
              required: ['id', 'name', 'team', 'date_create', 'is_active'],
              type: 'object',
            },
            minItems: 0,
            type: 'array',
            uniqueItems: true,
          },
          unread_count: {
            type: 'integer',
          },
          unread_count_display: {
            type: 'integer',
          },
          user: {
            $ref: '#/components/schemas/defs_user_id',
          },
          version: {
            type: 'integer',
          },
        },
        required: ['id', 'created', 'is_im', 'is_org_shared', 'user', 'priority'],
        title: 'Conversation IM Channel Object from conversations.* methods',
        type: 'object',
      },
    ],
  },
} as const;

export const objs_enterprise_userSchema = {
  additionalProperties: false,
  properties: {
    enterprise_id: {
      $ref: '#/components/schemas/defs_enterprise_id',
    },
    enterprise_name: {
      $ref: '#/components/schemas/defs_enterprise_name',
    },
    id: {
      $ref: '#/components/schemas/defs_enterprise_user_id',
    },
    is_admin: {
      type: 'boolean',
    },
    is_owner: {
      type: 'boolean',
    },
    teams: {
      items: {
        $ref: '#/components/schemas/defs_team',
      },
      type: 'array',
      uniqueItems: true,
    },
  },
  required: ['id', 'enterprise_id', 'enterprise_name', 'is_admin', 'is_owner', 'teams'],
  type: 'object',
} as const;

export const objs_external_org_migrationsSchema = {
  properties: {
    current: {
      items: {
        properties: {
          date_started: {
            type: 'integer',
          },
          team_id: {
            type: 'string',
          },
        },
        required: ['team_id', 'date_started'],
        type: 'object',
      },
      type: 'array',
    },
    date_updated: {
      type: 'integer',
    },
  },
  required: ['date_updated', 'current'],
  title: 'External Org Migrations',
  type: 'object',
} as const;

export const objs_fileSchema = {
  additionalProperties: false,
  properties: {
    channels: {
      items: {
        $ref: '#/components/schemas/defs_channel_id',
      },
      type: 'array',
      uniqueItems: true,
    },
    comments_count: {
      type: 'integer',
    },
    created: {
      type: 'integer',
    },
    date_delete: {
      type: 'integer',
    },
    display_as_bot: {
      type: 'boolean',
    },
    editable: {
      type: 'boolean',
    },
    editor: {
      $ref: '#/components/schemas/defs_user_id',
    },
    external_id: {
      type: 'string',
    },
    external_type: {
      type: 'string',
    },
    external_url: {
      format: 'uri',
      type: 'string',
    },
    filetype: {
      type: 'string',
    },
    groups: {
      items: {
        $ref: '#/components/schemas/defs_group_id',
      },
      type: 'array',
      uniqueItems: true,
    },
    has_rich_preview: {
      type: 'boolean',
    },
    id: {
      $ref: '#/components/schemas/defs_file_id',
    },
    image_exif_rotation: {
      type: 'integer',
    },
    ims: {
      items: {
        $ref: '#/components/schemas/defs_dm_id',
      },
      type: 'array',
      uniqueItems: true,
    },
    is_external: {
      type: 'boolean',
    },
    is_public: {
      type: 'boolean',
    },
    is_starred: {
      type: 'boolean',
    },
    is_tombstoned: {
      type: 'boolean',
    },
    last_editor: {
      $ref: '#/components/schemas/defs_user_id',
    },
    mimetype: {
      type: 'string',
    },
    mode: {
      type: 'string',
    },
    name: {
      type: 'string',
    },
    non_owner_editable: {
      type: 'boolean',
    },
    num_stars: {
      type: 'integer',
    },
    original_h: {
      type: 'integer',
    },
    original_w: {
      type: 'integer',
    },
    permalink: {
      format: 'uri',
      type: 'string',
    },
    permalink_public: {
      format: 'uri',
      type: 'string',
    },
    pinned_info: {
      $ref: '#/components/schemas/defs_pinned_info',
    },
    pinned_to: {
      items: {
        $ref: '#/components/schemas/defs_channel',
      },
      type: 'array',
    },
    pretty_type: {
      type: 'string',
    },
    preview: {
      type: 'string',
    },
    public_url_shared: {
      type: 'boolean',
    },
    reactions: {
      items: {
        $ref: '#/components/schemas/objs_reaction',
      },
      type: 'array',
    },
    shares: {
      additionalProperties: false,
      properties: {
        private: {
          additionalProperties: false,
        },
        public: {
          additionalProperties: false,
        },
      },
      type: 'object',
    },
    size: {
      type: 'integer',
    },
    source_team: {
      $ref: '#/components/schemas/defs_team',
    },
    state: {
      type: 'string',
    },
    thumb_1024: {
      format: 'uri',
      type: 'string',
    },
    thumb_1024_h: {
      type: 'integer',
    },
    thumb_1024_w: {
      type: 'integer',
    },
    thumb_160: {
      format: 'uri',
      type: 'string',
    },
    thumb_360: {
      format: 'uri',
      type: 'string',
    },
    thumb_360_h: {
      type: 'integer',
    },
    thumb_360_w: {
      type: 'integer',
    },
    thumb_480: {
      format: 'uri',
      type: 'string',
    },
    thumb_480_h: {
      type: 'integer',
    },
    thumb_480_w: {
      type: 'integer',
    },
    thumb_64: {
      format: 'uri',
      type: 'string',
    },
    thumb_720: {
      format: 'uri',
      type: 'string',
    },
    thumb_720_h: {
      type: 'integer',
    },
    thumb_720_w: {
      type: 'integer',
    },
    thumb_80: {
      format: 'uri',
      type: 'string',
    },
    thumb_800: {
      format: 'uri',
      type: 'string',
    },
    thumb_800_h: {
      type: 'integer',
    },
    thumb_800_w: {
      type: 'integer',
    },
    thumb_960: {
      format: 'uri',
      type: 'string',
    },
    thumb_960_h: {
      type: 'integer',
    },
    thumb_960_w: {
      type: 'integer',
    },
    thumb_tiny: {
      type: 'string',
    },
    timestamp: {
      type: 'integer',
    },
    title: {
      type: 'string',
    },
    updated: {
      type: 'integer',
    },
    url_private: {
      format: 'uri',
      type: 'string',
    },
    url_private_download: {
      format: 'uri',
      type: 'string',
    },
    user: {
      type: 'string',
    },
    user_team: {
      $ref: '#/components/schemas/defs_team',
    },
    username: {
      type: 'string',
    },
  },
  title: 'file object',
  type: 'object',
} as const;

export const objs_iconSchema = {
  properties: {
    image_102: {
      type: 'string',
    },
    image_132: {
      type: 'string',
    },
    image_230: {
      type: 'string',
    },
    image_34: {
      type: 'string',
    },
    image_44: {
      type: 'string',
    },
    image_68: {
      type: 'string',
    },
    image_88: {
      type: 'string',
    },
    image_default: {
      type: 'boolean',
    },
  },
  type: 'object',
} as const;

export const objs_messageSchema = {
  additionalProperties: false,
  properties: {
    attachments: {
      items: {
        additionalProperties: false,
        properties: {
          fallback: {
            type: 'string',
          },
          id: {
            type: 'integer',
          },
          image_bytes: {
            type: 'integer',
          },
          image_height: {
            type: 'integer',
          },
          image_url: {
            type: 'string',
          },
          image_width: {
            type: 'integer',
          },
        },
        required: ['id'],
        type: 'object',
      },
      minItems: 1,
      type: 'array',
      uniqueItems: true,
    },
    blocks: {
      $ref: '#/components/schemas/blocks',
    },
    bot_id: {
      items: {
        anyOf: [
          {
            $ref: '#/components/schemas/defs_bot_id',
          },
          {
            nullable: true,
            title: 'Nil bot_id set when display_as_bot is false',
          },
        ],
      },
    },
    bot_profile: {
      $ref: '#/components/schemas/objs_bot_profile',
    },
    client_msg_id: {
      type: 'string',
    },
    comment: {
      $ref: '#/components/schemas/objs_comment',
    },
    display_as_bot: {
      type: 'boolean',
    },
    file: {
      $ref: '#/components/schemas/objs_file',
    },
    files: {
      items: {
        $ref: '#/components/schemas/objs_file',
      },
      minItems: 1,
      type: 'array',
      uniqueItems: true,
    },
    icons: {
      additionalProperties: false,
      properties: {
        emoji: {
          type: 'string',
        },
        image_64: {
          format: 'uri',
          type: 'string',
        },
      },
      type: 'object',
    },
    inviter: {
      $ref: '#/components/schemas/defs_user_id',
    },
    is_delayed_message: {
      type: 'boolean',
    },
    is_intro: {
      type: 'boolean',
    },
    is_starred: {
      type: 'boolean',
    },
    last_read: {
      $ref: '#/components/schemas/defs_ts',
    },
    latest_reply: {
      $ref: '#/components/schemas/defs_ts',
    },
    name: {
      type: 'string',
    },
    old_name: {
      type: 'string',
    },
    parent_user_id: {
      $ref: '#/components/schemas/defs_user_id',
    },
    permalink: {
      format: 'uri',
      type: 'string',
    },
    pinned_to: {
      items: {
        $ref: '#/components/schemas/defs_channel',
      },
      type: 'array',
    },
    purpose: {
      type: 'string',
    },
    reactions: {
      items: {
        $ref: '#/components/schemas/objs_reaction',
      },
      type: 'array',
    },
    reply_count: {
      type: 'integer',
    },
    reply_users: {
      items: {
        $ref: '#/components/schemas/defs_user_id',
      },
      minItems: 1,
      type: 'array',
      uniqueItems: true,
    },
    reply_users_count: {
      type: 'integer',
    },
    source_team: {
      $ref: '#/components/schemas/defs_workspace_id',
    },
    subscribed: {
      type: 'boolean',
    },
    subtype: {
      type: 'string',
    },
    team: {
      $ref: '#/components/schemas/defs_workspace_id',
    },
    text: {
      type: 'string',
    },
    thread_ts: {
      $ref: '#/components/schemas/defs_ts',
    },
    topic: {
      type: 'string',
    },
    ts: {
      $ref: '#/components/schemas/defs_ts',
    },
    type: {
      type: 'string',
    },
    unread_count: {
      type: 'integer',
    },
    upload: {
      type: 'boolean',
    },
    user: {
      $ref: '#/components/schemas/defs_user_id',
    },
    user_profile: {
      $ref: '#/components/schemas/objs_user_profile_short',
    },
    user_team: {
      $ref: '#/components/schemas/defs_workspace_id',
    },
    username: {
      type: 'string',
    },
  },
  required: ['text', 'type', 'ts'],
  title: 'Message object',
  type: 'object',
} as const;

export const objs_pagingSchema = {
  additionalProperties: false,
  properties: {
    count: {
      type: 'integer',
    },
    page: {
      type: 'integer',
    },
    pages: {
      type: 'integer',
    },
    per_page: {
      type: 'integer',
    },
    spill: {
      type: 'integer',
    },
    total: {
      type: 'integer',
    },
  },
  required: ['page', 'total'],
  title: 'paging object',
  type: 'object',
} as const;

export const objs_primary_ownerSchema = {
  properties: {
    email: {
      type: 'string',
    },
    id: {
      type: 'string',
    },
  },
  required: ['id', 'email'],
  type: 'object',
} as const;

export const objs_reactionSchema = {
  additionalProperties: true,
  properties: {
    count: {
      type: 'integer',
    },
    name: {
      type: 'string',
    },
    users: {
      items: {
        $ref: '#/components/schemas/defs_user_id',
      },
      type: 'array',
    },
  },
  required: ['name', 'users', 'count'],
  title: 'Reaction object',
  type: 'object',
} as const;

export const objs_reminderSchema = {
  additionalProperties: false,
  properties: {
    complete_ts: {
      type: 'integer',
    },
    creator: {
      $ref: '#/components/schemas/defs_user_id',
    },
    id: {
      $ref: '#/components/schemas/defs_reminder_id',
    },
    recurring: {
      type: 'boolean',
    },
    text: {
      type: 'string',
    },
    time: {
      type: 'integer',
    },
    user: {
      $ref: '#/components/schemas/defs_user_id',
    },
  },
  required: ['id', 'creator', 'user', 'text', 'recurring'],
  type: 'object',
} as const;

export const objs_resourcesSchema = {
  additionalProperties: false,
  properties: {
    excluded_ids: {
      items: {
        items: {
          anyOf: [
            {
              $ref: '#/components/schemas/defs_channel',
            },
            {
              $ref: '#/components/schemas/defs_team',
            },
          ],
        },
      },
      type: 'array',
    },
    ids: {
      items: {
        items: {
          anyOf: [
            {
              $ref: '#/components/schemas/defs_channel',
            },
            {
              $ref: '#/components/schemas/defs_team',
            },
          ],
        },
      },
      type: 'array',
    },
    wildcard: {
      type: 'boolean',
    },
  },
  required: ['ids'],
  title: 'resources in info from apps.permissions.info',
  type: 'object',
} as const;

export const objs_response_metadataSchema = {
  items: {
    anyOf: [
      {
        additionalProperties: false,
        properties: {
          next_cursor: {
            type: 'string',
          },
        },
        required: ['next_cursor'],
        title: 'new paging style',
        type: 'object',
      },
      {
        additionalProperties: false,
        properties: {
          messages: {
            items: {
              type: 'string',
            },
            type: 'array',
          },
          warnings: {
            items: {
              enum: ['method_deprecated'],
              type: 'string',
            },
            type: 'array',
          },
        },
        required: ['messages', 'warnings'],
        title: 'deprecation_warning',
        type: 'object',
      },
      {
        additionalProperties: false,
        properties: {
          messages: {
            items: {
              type: 'string',
            },
            type: 'array',
          },
          next_cursor: {
            type: 'string',
          },
          warnings: {
            items: {
              enum: ['method_deprecated'],
              type: 'string',
            },
            type: 'array',
          },
        },
        required: ['messages', 'warnings', 'next_cursor'],
        title: 'deprecation_warning and paging style together',
        type: 'object',
      },
    ],
  },
} as const;

export const objs_scopesSchema = {
  items: {
    title: 'Named OAuth scopes',
    type: 'string',
    'x-examples': ['chat:write', 'im:history', 'im:read'],
  },
  type: 'array',
} as const;

export const objs_subteamSchema = {
  additionalProperties: false,
  properties: {
    auto_provision: {
      type: 'boolean',
    },
    auto_type: {
      items: {
        anyOf: [
          {
            nullable: true,
          },
          {
            enum: ['owner', 'admin'],
            type: 'string',
          },
        ],
      },
    },
    channel_count: {
      type: 'integer',
    },
    created_by: {
      $ref: '#/components/schemas/defs_user_id',
    },
    date_create: {
      type: 'integer',
    },
    date_delete: {
      type: 'integer',
    },
    date_update: {
      type: 'integer',
    },
    deleted_by: {
      items: {
        anyOf: [
          {
            nullable: true,
          },
          {
            $ref: '#/components/schemas/defs_user_id',
          },
        ],
      },
    },
    description: {
      type: 'string',
    },
    enterprise_subteam_id: {
      type: 'string',
    },
    handle: {
      type: 'string',
    },
    id: {
      $ref: '#/components/schemas/defs_subteam_id',
    },
    is_external: {
      type: 'boolean',
    },
    is_subteam: {
      type: 'boolean',
    },
    is_usergroup: {
      type: 'boolean',
    },
    name: {
      type: 'string',
    },
    prefs: {
      additionalProperties: false,
      properties: {
        channels: {
          items: {
            $ref: '#/components/schemas/defs_channel_id',
          },
          type: 'array',
        },
        groups: {
          items: {
            $ref: '#/components/schemas/defs_group_id',
          },
          type: 'array',
        },
      },
      required: ['channels', 'groups'],
      type: 'object',
    },
    team_id: {
      $ref: '#/components/schemas/defs_team',
    },
    updated_by: {
      $ref: '#/components/schemas/defs_user_id',
    },
    user_count: {
      type: 'integer',
    },
    users: {
      items: {
        $ref: '#/components/schemas/defs_user_id',
      },
      type: 'array',
    },
  },
  required: [
    'id',
    'team_id',
    'is_usergroup',
    'is_subteam',
    'name',
    'description',
    'handle',
    'is_external',
    'date_create',
    'date_update',
    'date_delete',
    'auto_type',
    'auto_provision',
    'enterprise_subteam_id',
    'created_by',
    'updated_by',
    'deleted_by',
    'prefs',
  ],
  title: 'Subteam/Usergroup Object',
  type: 'object',
} as const;

export const objs_teamSchema = {
  additionalProperties: false,
  properties: {
    archived: {
      type: 'boolean',
    },
    avatar_base_url: {
      format: 'uri',
      type: 'string',
    },
    created: {
      type: 'integer',
    },
    date_create: {
      type: 'integer',
    },
    deleted: {
      type: 'boolean',
    },
    description: {
      nullable: true,
      type: 'string',
    },
    discoverable: {
      items: {
        anyOf: [
          {
            nullable: true,
          },
          {
            type: 'string',
          },
        ],
      },
    },
    domain: {
      type: 'string',
    },
    email_domain: {
      type: 'string',
    },
    enterprise_id: {
      $ref: '#/components/schemas/defs_enterprise_id',
    },
    enterprise_name: {
      $ref: '#/components/schemas/defs_enterprise_name',
    },
    external_org_migrations: {
      $ref: '#/components/schemas/objs_external_org_migrations',
    },
    has_compliance_export: {
      type: 'boolean',
    },
    icon: {
      $ref: '#/components/schemas/objs_icon',
    },
    id: {
      $ref: '#/components/schemas/defs_workspace_id',
    },
    is_assigned: {
      type: 'boolean',
    },
    is_enterprise: {
      type: 'integer',
    },
    is_over_storage_limit: {
      type: 'boolean',
    },
    limit_ts: {
      type: 'integer',
    },
    locale: {
      type: 'string',
    },
    messages_count: {
      type: 'integer',
    },
    msg_edit_window_mins: {
      type: 'integer',
    },
    name: {
      type: 'string',
    },
    over_integrations_limit: {
      type: 'boolean',
    },
    over_storage_limit: {
      type: 'boolean',
    },
    pay_prod_cur: {
      type: 'string',
    },
    plan: {
      enum: ['', 'std', 'plus', 'compliance', 'enterprise'],
      type: 'string',
    },
    primary_owner: {
      $ref: '#/components/schemas/objs_primary_owner',
    },
    sso_provider: {
      properties: {
        label: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        type: {
          type: 'string',
        },
      },
      type: 'object',
    },
  },
  required: ['id', 'name', 'domain', 'email_domain', 'icon'],
  title: 'Team Object',
  type: 'object',
} as const;

export const objs_team_profile_fieldSchema = {
  additionalProperties: false,
  properties: {
    field_name: {
      nullable: true,
      type: 'string',
    },
    hint: {
      type: 'string',
    },
    id: {
      pattern: '^X[a-zA-Z0-9]{9,}$',
      type: 'string',
    },
    is_hidden: {
      type: 'boolean',
    },
    label: {
      type: 'string',
    },
    options: {
      items: {
        anyOf: [
          {
            nullable: true,
          },
          {
            $ref: '#/components/schemas/objs_team_profile_field_option',
          },
        ],
      },
    },
    ordering: {
      type: 'number',
    },
    possible_values: {
      items: {
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    type: {
      enum: ['text', 'date', 'link', 'mailto', 'options_list', 'user'],
      type: 'string',
    },
  },
  required: ['id', 'ordering', 'label', 'hint', 'type'],
  type: 'object',
} as const;

export const objs_team_profile_field_optionSchema = {
  additionalProperties: false,
  properties: {
    is_custom: {
      nullable: true,
      type: 'boolean',
    },
    is_multiple_entry: {
      nullable: true,
      type: 'boolean',
    },
    is_protected: {
      nullable: true,
      type: 'boolean',
    },
    is_scim: {
      nullable: true,
      type: 'boolean',
    },
  },
  type: 'object',
} as const;

export const objs_userSchema = {
  items: {
    anyOf: [
      {
        additionalProperties: false,
        description: 'user object for non enterprise type',
        properties: {
          color: {
            pattern: '^[a-fA-F0-9]{6}$',
            type: 'string',
          },
          deleted: {
            type: 'boolean',
          },
          enterprise_user: {
            $ref: '#/components/schemas/objs_enterprise_user',
          },
          has_2fa: {
            type: 'boolean',
          },
          id: {
            $ref: '#/components/schemas/defs_user_id',
          },
          is_admin: {
            type: 'boolean',
          },
          is_app_user: {
            type: 'boolean',
          },
          is_bot: {
            type: 'boolean',
          },
          is_external: {
            type: 'boolean',
          },
          is_forgotten: {
            type: 'boolean',
          },
          is_invited_user: {
            type: 'boolean',
          },
          is_owner: {
            type: 'boolean',
          },
          is_primary_owner: {
            type: 'boolean',
          },
          is_restricted: {
            type: 'boolean',
          },
          is_stranger: {
            type: 'boolean',
          },
          is_ultra_restricted: {
            type: 'boolean',
          },
          locale: {
            type: 'string',
          },
          name: {
            type: 'string',
          },
          presence: {
            type: 'string',
          },
          profile: {
            $ref: '#/components/schemas/objs_user_profile',
          },
          real_name: {
            type: 'string',
          },
          team: {
            $ref: '#/components/schemas/defs_workspace_id',
          },
          team_id: {
            $ref: '#/components/schemas/defs_workspace_id',
          },
          team_profile: {
            additionalProperties: false,
            properties: {
              fields: {
                items: {
                  $ref: '#/components/schemas/objs_team_profile_field',
                },
                minItems: 1,
                type: 'array',
                uniqueItems: true,
              },
            },
            required: ['fields'],
            type: 'object',
          },
          two_factor_type: {
            type: 'string',
          },
          tz: {
            items: {
              anyOf: [
                {
                  nullable: true,
                },
                {
                  type: 'string',
                },
              ],
            },
          },
          tz_label: {
            type: 'string',
          },
          tz_offset: {
            type: 'number',
          },
          updated: {
            type: 'number',
          },
        },
        required: ['id', 'name', 'profile', 'is_bot', 'updated', 'is_app_user'],
        type: 'object',
      },
      {
        additionalProperties: false,
        description: 'enterprise user',
        properties: {
          color: {
            description: 'refercing to bug: https://jira.tinyspeck.com/browse/EVALUE-1559',
            pattern: '^([a-fA-F0-9]{6})?$',
            type: 'string',
          },
          deleted: {
            type: 'boolean',
          },
          enterprise_user: {
            $ref: '#/components/schemas/objs_enterprise_user',
          },
          has_2fa: {
            type: 'boolean',
          },
          id: {
            $ref: '#/components/schemas/defs_user_id',
          },
          is_admin: {
            type: 'boolean',
          },
          is_app_user: {
            type: 'boolean',
          },
          is_bot: {
            type: 'boolean',
          },
          is_external: {
            type: 'boolean',
          },
          is_forgotten: {
            type: 'boolean',
          },
          is_owner: {
            type: 'boolean',
          },
          is_primary_owner: {
            type: 'boolean',
          },
          is_restricted: {
            type: 'boolean',
          },
          is_stranger: {
            type: 'boolean',
          },
          is_ultra_restricted: {
            type: 'boolean',
          },
          locale: {
            type: 'string',
          },
          name: {
            type: 'string',
          },
          presence: {
            type: 'string',
          },
          profile: {
            $ref: '#/components/schemas/objs_user_profile',
          },
          real_name: {
            type: 'string',
          },
          team_id: {
            $ref: '#/components/schemas/defs_workspace_id',
          },
          team_profile: {
            additionalProperties: false,
            properties: {
              fields: {
                items: {
                  $ref: '#/components/schemas/objs_team_profile_field',
                },
                minItems: 1,
                type: 'array',
                uniqueItems: true,
              },
            },
            required: ['fields'],
            type: 'object',
          },
          teams: {
            items: {
              $ref: '#/components/schemas/defs_workspace_id',
            },
            minItems: 1,
            type: 'array',
            uniqueItems: true,
          },
          two_factor_type: {
            type: 'string',
          },
          tz: {
            items: {
              anyOf: [
                {
                  nullable: true,
                },
                {
                  type: 'string',
                },
              ],
            },
          },
          tz_label: {
            type: 'string',
          },
          tz_offset: {
            type: 'number',
          },
          updated: {
            type: 'number',
          },
        },
        required: ['id', 'name', 'profile', 'is_bot', 'updated', 'is_app_user'],
        type: 'object',
      },
    ],
  },
} as const;

export const objs_user_profileSchema = {
  additionalProperties: false,
  properties: {
    always_active: {
      type: 'boolean',
    },
    api_app_id: {
      $ref: '#/components/schemas/defs_optional_app_id',
    },
    avatar_hash: {
      type: 'string',
    },
    bot_id: {
      $ref: '#/components/schemas/defs_bot_id',
    },
    display_name: {
      type: 'string',
    },
    display_name_normalized: {
      type: 'string',
    },
    email: {
      format: 'email',
      nullable: true,
      type: 'string',
    },
    fields: {
      items: {
        type: 'object',
      },
      nullable: true,
      oneOf: [
        {
          type: 'object',
        },
        {
          items: {},
          type: 'array',
        },
      ],
    },
    first_name: {
      nullable: true,
      type: 'string',
    },
    guest_expiration_ts: {
      nullable: true,
      type: 'integer',
    },
    guest_invited_by: {
      nullable: true,
      type: 'string',
    },
    image_1024: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    image_192: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    image_24: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    image_32: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    image_48: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    image_512: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    image_72: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    image_original: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    is_app_user: {
      type: 'boolean',
    },
    is_custom_image: {
      type: 'boolean',
    },
    is_restricted: {
      nullable: true,
      type: 'boolean',
    },
    is_ultra_restricted: {
      nullable: true,
      type: 'boolean',
    },
    last_avatar_image_hash: {
      type: 'string',
    },
    last_name: {
      nullable: true,
      type: 'string',
    },
    memberships_count: {
      type: 'integer',
    },
    name: {
      nullable: true,
      type: 'string',
    },
    phone: {
      type: 'string',
    },
    pronouns: {
      type: 'string',
    },
    real_name: {
      type: 'string',
    },
    real_name_normalized: {
      type: 'string',
    },
    skype: {
      type: 'string',
    },
    status_default_emoji: {
      type: 'string',
    },
    status_default_text: {
      type: 'string',
    },
    status_default_text_canonical: {
      nullable: true,
      type: 'string',
    },
    status_emoji: {
      type: 'string',
    },
    status_expiration: {
      type: 'integer',
    },
    status_text: {
      type: 'string',
    },
    status_text_canonical: {
      nullable: true,
      type: 'string',
    },
    team: {
      $ref: '#/components/schemas/defs_workspace_id',
    },
    title: {
      type: 'string',
    },
    updated: {
      type: 'integer',
    },
    user_id: {
      type: 'string',
    },
    username: {
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'real_name',
    'display_name',
    'avatar_hash',
    'real_name_normalized',
    'display_name_normalized',
    'title',
    'phone',
    'skype',
    'status_text',
    'status_emoji',
    'fields',
  ],
  title: 'User profile object',
  type: 'object',
} as const;

export const objs_user_profile_shortSchema = {
  additionalProperties: false,
  properties: {
    avatar_hash: {
      type: 'string',
    },
    display_name: {
      type: 'string',
    },
    display_name_normalized: {
      type: 'string',
    },
    first_name: {
      nullable: true,
      type: 'string',
    },
    image_72: {
      format: 'uri',
      type: 'string',
    },
    is_restricted: {
      type: 'boolean',
    },
    is_ultra_restricted: {
      type: 'boolean',
    },
    name: {
      type: 'string',
    },
    real_name: {
      type: 'string',
    },
    real_name_normalized: {
      type: 'string',
    },
    team: {
      $ref: '#/components/schemas/defs_workspace_id',
    },
  },
  required: [
    'avatar_hash',
    'image_72',
    'first_name',
    'real_name',
    'display_name',
    'team',
    'name',
    'is_restricted',
    'is_ultra_restricted',
  ],
  type: 'object',
} as const;
