// @ts-nocheck
export type TPaths = {
  '/admin/oauth/access_scopes.json': {
    get: {
      summary: 'Retrieves a list of access scopes associated to the access token.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/accessscope#index-2020-10';
      parameters: [];
      tags: ['access', 'accessscope', 'access/accessscope', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_admin_oauth_access_scopes';
    };
  };
  '/admin/api/2020-01/storefront_access_tokens.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  storefront_access_token: {
                    title: 'Test';
                  };
                };
                summary: 'Create a new storefront access token';
              };
              example2: {
                value: {
                  storefront_access_token: {
                    title: 'Test';
                  };
                };
                summary: 'Generating a token for an app that lacks required unauthenticated scopes fails';
              };
              example3: {
                value: {
                  storefront_access_token: {
                    title: 'Token';
                  };
                };
                summary: 'Creating a token after exceeding the limit fails';
              };
            };
          };
        };
      };
      summary: 'Creates a new storefront access token';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#create-2020-01';
      parameters: [];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_storefront_access_tokens';
    };
    get: {
      summary: 'Retrieves a list of storefront access tokens that have been issued';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#index-2020-01';
      parameters: [];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_storefront_access_tokens';
    };
  };
  '/admin/api/2020-01/storefront_access_tokens/{storefront_access_token_id}.json': {
    delete: {
      summary: 'Deletes an existing storefront access token';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'storefront_access_token_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'storefront_access_token_id';
        },
      ];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_storefront_access_tokens_param_storefront_access_token_id';
    };
  };
  '/admin/api/2020-04/storefront_access_tokens.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  storefront_access_token: {
                    title: 'Test';
                  };
                };
                summary: 'Create a new storefront access token';
              };
              example2: {
                value: {
                  storefront_access_token: {
                    title: 'Test';
                  };
                };
                summary: 'Generating a token for an app that lacks required unauthenticated scopes fails';
              };
              example3: {
                value: {
                  storefront_access_token: {
                    title: 'Token';
                  };
                };
                summary: 'Creating a token after exceeding the limit fails';
              };
            };
          };
        };
      };
      summary: 'Creates a new storefront access token';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#create-2020-04';
      parameters: [];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_storefront_access_tokens';
    };
    get: {
      summary: 'Retrieves a list of storefront access tokens that have been issued';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#index-2020-04';
      parameters: [];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_storefront_access_tokens';
    };
  };
  '/admin/api/2020-04/storefront_access_tokens/{storefront_access_token_id}.json': {
    delete: {
      summary: 'Deletes an existing storefront access token';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'storefront_access_token_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'storefront_access_token_id';
        },
      ];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_storefront_access_tokens_param_storefront_access_token_id';
    };
  };
  '/admin/api/2020-07/storefront_access_tokens.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  storefront_access_token: {
                    title: 'Test';
                  };
                };
                summary: 'Create a new storefront access token';
              };
              example2: {
                value: {
                  storefront_access_token: {
                    title: 'Test';
                  };
                };
                summary: 'Generating a token for an app that lacks required unauthenticated scopes fails';
              };
              example3: {
                value: {
                  storefront_access_token: {
                    title: 'Token';
                  };
                };
                summary: 'Creating a token after exceeding the limit fails';
              };
            };
          };
        };
      };
      summary: 'Creates a new storefront access token';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#create-2020-07';
      parameters: [];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_storefront_access_tokens';
    };
    get: {
      summary: 'Retrieves a list of storefront access tokens that have been issued';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#index-2020-07';
      parameters: [];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_storefront_access_tokens';
    };
  };
  '/admin/api/2020-07/storefront_access_tokens/{storefront_access_token_id}.json': {
    delete: {
      summary: 'Deletes an existing storefront access token';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'storefront_access_token_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'storefront_access_token_id';
        },
      ];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_storefront_access_tokens_param_storefront_access_token_id';
    };
  };
  '/admin/api/2020-10/storefront_access_tokens.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  storefront_access_token: {
                    title: 'Test';
                  };
                };
                summary: 'Create a new storefront access token';
              };
              example2: {
                value: {
                  storefront_access_token: {
                    title: 'Test';
                  };
                };
                summary: 'Generating a token for an app that lacks required unauthenticated scopes fails';
              };
              example3: {
                value: {
                  storefront_access_token: {
                    title: 'Token';
                  };
                };
                summary: 'Creating a token after exceeding the limit fails';
              };
            };
          };
        };
      };
      summary: 'Creates a new storefront access token';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#create-2020-10';
      parameters: [];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_storefront_access_tokens';
    };
    get: {
      summary: 'Retrieves a list of storefront access tokens that have been issued';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#index-2020-10';
      parameters: [];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_storefront_access_tokens';
    };
  };
  '/admin/api/2020-10/storefront_access_tokens/{storefront_access_token_id}.json': {
    delete: {
      summary: 'Deletes an existing storefront access token';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'storefront_access_token_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'storefront_access_token_id';
        },
      ];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_storefront_access_tokens_param_storefront_access_token_id';
    };
  };
  '/admin/api/2021-01/storefront_access_tokens.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  storefront_access_token: {
                    title: 'Test';
                  };
                };
                summary: 'Create a new storefront access token';
              };
              example2: {
                value: {
                  storefront_access_token: {
                    title: 'Test';
                  };
                };
                summary: 'Generating a token for an app that lacks required unauthenticated scopes fails';
              };
              example3: {
                value: {
                  storefront_access_token: {
                    title: 'Token';
                  };
                };
                summary: 'Creating a token after exceeding the limit fails';
              };
            };
          };
        };
      };
      summary: 'Creates a new storefront access token';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#create-2021-01';
      parameters: [];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_storefront_access_tokens';
    };
    get: {
      summary: 'Retrieves a list of storefront access tokens that have been issued';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#index-2021-01';
      parameters: [];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_storefront_access_tokens';
    };
  };
  '/admin/api/2021-01/storefront_access_tokens/{storefront_access_token_id}.json': {
    delete: {
      summary: 'Deletes an existing storefront access token';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'storefront_access_token_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'storefront_access_token_id';
        },
      ];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_storefront_access_tokens_param_storefront_access_token_id';
    };
  };
  '/admin/api/unstable/storefront_access_tokens.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  storefront_access_token: {
                    title: 'Test';
                  };
                };
                summary: 'Create a new storefront access token';
              };
              example2: {
                value: {
                  storefront_access_token: {
                    title: 'Test';
                  };
                };
                summary: 'Generating a token for an app that lacks required unauthenticated scopes fails';
              };
              example3: {
                value: {
                  storefront_access_token: {
                    title: 'Token';
                  };
                };
                summary: 'Creating a token after exceeding the limit fails';
              };
            };
          };
        };
      };
      summary: 'Creates a new storefront access token';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#create-unstable';
      parameters: [];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_storefront_access_tokens';
    };
    get: {
      summary: 'Retrieves a list of storefront access tokens that have been issued';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#index-unstable';
      parameters: [];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_storefront_access_tokens';
    };
  };
  '/admin/api/unstable/storefront_access_tokens/{storefront_access_token_id}.json': {
    delete: {
      summary: 'Deletes an existing storefront access token';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/access/storefrontaccesstoken#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'storefront_access_token_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'storefront_access_token_id';
        },
      ];
      tags: ['access', 'storefrontaccesstoken', 'access/storefrontaccesstoken'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_storefront_access_tokens_param_storefront_access_token_id';
    };
  };
  '/admin/api/2020-01/reports.json': {
    get: {
      summary: 'Retrieves a list of reports. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'ids';
          description: 'A comma-separated list of report IDs.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The amount of results to return.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show reports last updated after date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show reports last updated before date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_reports';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  report: {
                    name: 'A new app report';
                    shopify_ql: 'SHOW total_sales BY order_id FROM sales SINCE -1m UNTIL today ORDER BY total_sales';
                  };
                };
                summary: 'Create a new report';
              };
            };
          };
        };
      };
      summary: 'Creates a new report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#create-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'name';
          description: 'The name of the report. Maximum length: 255 characters.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'shopify_ql';
          description: 'The ShopifyQL the report will query.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_reports';
    };
  };
  '/admin/api/2020-01/reports/{report_id}.json': {
    get: {
      summary: 'Retrieves a single report created by your app';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_reports_param_report_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  report: {
                    id: 517154478;
                    name: 'Changed Report Name';
                    shopify_ql: 'SHOW total_sales BY order_id FROM sales SINCE -12m UNTIL today ORDER BY total_sales';
                  };
                };
                summary: 'Update an existing report';
              };
            };
          };
        };
      };
      summary: 'Updates a report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_reports_param_report_id';
    };
    delete: {
      summary: 'Deletes a report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_reports_param_report_id';
    };
  };
  '/admin/api/2020-04/reports.json': {
    get: {
      summary: 'Retrieves a list of reports. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'ids';
          description: 'A comma-separated list of report IDs.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The amount of results to return.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show reports last updated after date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show reports last updated before date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_reports';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  report: {
                    name: 'A new app report';
                    shopify_ql: 'SHOW total_sales BY order_id FROM sales SINCE -1m UNTIL today ORDER BY total_sales';
                  };
                };
                summary: 'Create a new report';
              };
            };
          };
        };
      };
      summary: 'Creates a new report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#create-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'name';
          description: 'The name of the report. Maximum length: 255 characters.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'shopify_ql';
          description: 'The ShopifyQL the report will query.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_reports';
    };
  };
  '/admin/api/2020-04/reports/{report_id}.json': {
    get: {
      summary: 'Retrieves a single report created by your app';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_reports_param_report_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  report: {
                    id: 517154478;
                    name: 'Changed Report Name';
                    shopify_ql: 'SHOW total_sales BY order_id FROM sales SINCE -12m UNTIL today ORDER BY total_sales';
                  };
                };
                summary: 'Update an existing report';
              };
            };
          };
        };
      };
      summary: 'Updates a report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_reports_param_report_id';
    };
    delete: {
      summary: 'Deletes a report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_reports_param_report_id';
    };
  };
  '/admin/api/2020-07/reports.json': {
    get: {
      summary: 'Retrieves a list of reports. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'ids';
          description: 'A comma-separated list of report IDs.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The amount of results to return.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show reports last updated after date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show reports last updated before date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_reports';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  report: {
                    name: 'A new app report';
                    shopify_ql: 'SHOW total_sales BY order_id FROM sales SINCE -1m UNTIL today ORDER BY total_sales';
                  };
                };
                summary: 'Create a new report';
              };
            };
          };
        };
      };
      summary: 'Creates a new report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#create-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'name';
          description: 'The name of the report. Maximum length: 255 characters.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'shopify_ql';
          description: 'The ShopifyQL the report will query.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_reports';
    };
  };
  '/admin/api/2020-07/reports/{report_id}.json': {
    get: {
      summary: 'Retrieves a single report created by your app';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_reports_param_report_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  report: {
                    id: 517154478;
                    name: 'Changed Report Name';
                    shopify_ql: 'SHOW total_sales BY order_id FROM sales SINCE -12m UNTIL today ORDER BY total_sales';
                  };
                };
                summary: 'Update an existing report';
              };
            };
          };
        };
      };
      summary: 'Updates a report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_reports_param_report_id';
    };
    delete: {
      summary: 'Deletes a report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_reports_param_report_id';
    };
  };
  '/admin/api/2020-10/reports.json': {
    get: {
      summary: 'Retrieves a list of reports. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'ids';
          description: 'A comma-separated list of report IDs.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The amount of results to return.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show reports last updated after date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show reports last updated before date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_reports';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  report: {
                    name: 'A new app report';
                    shopify_ql: 'SHOW total_sales BY order_id FROM sales SINCE -1m UNTIL today ORDER BY total_sales';
                  };
                };
                summary: 'Create a new report';
              };
            };
          };
        };
      };
      summary: 'Creates a new report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#create-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'name';
          description: 'The name of the report. Maximum length: 255 characters.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'shopify_ql';
          description: 'The ShopifyQL the report will query.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_reports';
    };
  };
  '/admin/api/2020-10/reports/{report_id}.json': {
    get: {
      summary: 'Retrieves a single report created by your app';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_reports_param_report_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  report: {
                    id: 517154478;
                    name: 'Changed Report Name';
                    shopify_ql: 'SHOW total_sales BY order_id FROM sales SINCE -12m UNTIL today ORDER BY total_sales';
                  };
                };
                summary: 'Update an existing report';
              };
            };
          };
        };
      };
      summary: 'Updates a report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#update-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
      ];
      tags: ['analytics', 'report', 'analytics/report', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_reports_param_report_id';
    };
    delete: {
      summary: 'Deletes a report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
      ];
      tags: ['analytics', 'report', 'analytics/report', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_reports_param_report_id';
    };
  };
  '/admin/api/2021-01/reports.json': {
    get: {
      summary: 'Retrieves a list of reports. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'ids';
          description: 'A comma-separated list of report IDs.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The amount of results to return.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show reports last updated after date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show reports last updated before date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_reports';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  report: {
                    name: 'A new app report';
                    shopify_ql: 'SHOW total_sales BY order_id FROM sales SINCE -1m UNTIL today ORDER BY total_sales';
                  };
                };
                summary: 'Create a new report';
              };
            };
          };
        };
      };
      summary: 'Creates a new report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#create-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'name';
          description: 'The name of the report. Maximum length: 255 characters.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'shopify_ql';
          description: 'The ShopifyQL the report will query.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_reports';
    };
  };
  '/admin/api/2021-01/reports/{report_id}.json': {
    get: {
      summary: 'Retrieves a single report created by your app';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_reports_param_report_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  report: {
                    id: 517154478;
                    name: 'Changed Report Name';
                    shopify_ql: 'SHOW total_sales BY order_id FROM sales SINCE -12m UNTIL today ORDER BY total_sales';
                  };
                };
                summary: 'Update an existing report';
              };
            };
          };
        };
      };
      summary: 'Updates a report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#update-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_reports_param_report_id';
    };
    delete: {
      summary: 'Deletes a report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_reports_param_report_id';
    };
  };
  '/admin/api/unstable/reports.json': {
    get: {
      summary: 'Retrieves a list of reports. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'ids';
          description: 'A comma-separated list of report IDs.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The amount of results to return.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show reports last updated after date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show reports last updated before date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_reports';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  report: {
                    name: 'A new app report';
                    shopify_ql: 'SHOW total_sales BY order_id FROM sales SINCE -1m UNTIL today ORDER BY total_sales';
                  };
                };
                summary: 'Create a new report';
              };
            };
          };
        };
      };
      summary: 'Creates a new report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#create-unstable';
      parameters: [
        {
          in: 'query';
          name: 'name';
          description: 'The name of the report. Maximum length: 255 characters.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'shopify_ql';
          description: 'The ShopifyQL the report will query.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_reports';
    };
  };
  '/admin/api/unstable/reports/{report_id}.json': {
    get: {
      summary: 'Retrieves a single report created by your app';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_reports_param_report_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  report: {
                    id: 517154478;
                    name: 'Changed Report Name';
                    shopify_ql: 'SHOW total_sales BY order_id FROM sales SINCE -12m UNTIL today ORDER BY total_sales';
                  };
                };
                summary: 'Update an existing report';
              };
            };
          };
        };
      };
      summary: 'Updates a report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#update-unstable';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_reports_param_report_id';
    };
    delete: {
      summary: 'Deletes a report';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/analytics/report#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'report_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'report_id';
        },
      ];
      tags: ['analytics', 'report', 'analytics/report'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_reports_param_report_id';
    };
  };
  '/admin/api/2020-01/application_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 100;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Create an application charge';
              };
              example2: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 100;
                    return_url: 'http://super-duper.shopifyapps.com';
                    test: true;
                  };
                };
                summary: 'Create a test charge that will not cause a credit card to be charged';
              };
              example3: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 0.4;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Trying to create a charge with a price less than 0.50 will return an error';
              };
              example4: {
                value: {
                  application_charge: {
                    name: '';
                  };
                };
                summary: 'Trying to create a charge without a price or name will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates an application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#create-2020-01';
      parameters: [];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_application_charges';
    };
    get: {
      summary: 'Retrieves a list of application charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_application_charges';
    };
  };
  '/admin/api/2020-01/application_charges/{application_charge_id}.json': {
    get: {
      summary: 'Retrieves an application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_application_charges_param_application_charge_id';
    };
  };
  '/admin/api/2020-01/application_charges/{application_charge_id}/activate.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_charge: {
                    id: 675931192;
                    name: 'iPod Cleaning';
                    api_client_id: 755357713;
                    price: '5.00';
                    status: 'accepted';
                    return_url: 'http://google.com';
                    test: null;
                    created_at: '2020-12-07T15:53:44-05:00';
                    updated_at: '2020-12-07T15:53:44-05:00';
                    charge_type: null;
                    decorated_return_url: 'http://google.com?charge_id=675931192';
                  };
                };
                summary: 'Activate an application charge';
              };
            };
          };
        };
      };
      summary: 'Caution\n  This endpoint is no longer required and is deprecated as of\n  API version 2021-01.\n\n"Activates an accepted application charge. One-time charges are now immediately activated\nwhen approved by a merchant.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#activate-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_charge_id';
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_application_charges_param_application_charge_id_activate';
    };
  };
  '/admin/api/2020-04/application_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 100;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Create an application charge';
              };
              example2: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 100;
                    return_url: 'http://super-duper.shopifyapps.com';
                    test: true;
                  };
                };
                summary: 'Create a test charge that will not cause a credit card to be charged';
              };
              example3: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 0.4;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Trying to create a charge with a price less than 0.50 will return an error';
              };
              example4: {
                value: {
                  application_charge: {
                    name: '';
                  };
                };
                summary: 'Trying to create a charge without a price or name will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates an application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#create-2020-04';
      parameters: [];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_application_charges';
    };
    get: {
      summary: 'Retrieves a list of application charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_application_charges';
    };
  };
  '/admin/api/2020-04/application_charges/{application_charge_id}.json': {
    get: {
      summary: 'Retrieves an application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_application_charges_param_application_charge_id';
    };
  };
  '/admin/api/2020-04/application_charges/{application_charge_id}/activate.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_charge: {
                    id: 675931192;
                    name: 'iPod Cleaning';
                    api_client_id: 755357713;
                    price: '5.00';
                    status: 'accepted';
                    return_url: 'http://google.com';
                    test: null;
                    created_at: '2020-12-07T15:53:44-05:00';
                    updated_at: '2020-12-07T15:53:44-05:00';
                    charge_type: null;
                    decorated_return_url: 'http://google.com?charge_id=675931192';
                  };
                };
                summary: 'Activate an application charge';
              };
            };
          };
        };
      };
      summary: 'Caution\n  This endpoint is no longer required and is deprecated as of\n  API version 2021-01.\n\n"Activates an accepted application charge. One-time charges are now immediately activated\nwhen approved by a merchant.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#activate-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_charge_id';
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_application_charges_param_application_charge_id_activate';
    };
  };
  '/admin/api/2020-07/application_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 100;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Create an application charge';
              };
              example2: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 100;
                    return_url: 'http://super-duper.shopifyapps.com';
                    test: true;
                  };
                };
                summary: 'Create a test charge that will not cause a credit card to be charged';
              };
              example3: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 0.4;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Trying to create a charge with a price less than 0.50 will return an error';
              };
              example4: {
                value: {
                  application_charge: {
                    name: '';
                  };
                };
                summary: 'Trying to create a charge without a price or name will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates an application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#create-2020-07';
      parameters: [];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_application_charges';
    };
    get: {
      summary: 'Retrieves a list of application charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_application_charges';
    };
  };
  '/admin/api/2020-07/application_charges/{application_charge_id}.json': {
    get: {
      summary: 'Retrieves an application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_application_charges_param_application_charge_id';
    };
  };
  '/admin/api/2020-07/application_charges/{application_charge_id}/activate.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_charge: {
                    id: 675931192;
                    name: 'iPod Cleaning';
                    api_client_id: 755357713;
                    price: '5.00';
                    status: 'accepted';
                    return_url: 'http://google.com';
                    test: null;
                    created_at: '2020-12-07T15:53:44-05:00';
                    updated_at: '2020-12-07T15:53:44-05:00';
                    charge_type: null;
                    decorated_return_url: 'http://google.com?charge_id=675931192';
                  };
                };
                summary: 'Activate an application charge';
              };
            };
          };
        };
      };
      summary: 'Caution\n  This endpoint is no longer required and is deprecated as of\n  API version 2021-01.\n\n"Activates an accepted application charge. One-time charges are now immediately activated\nwhen approved by a merchant.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#activate-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_charge_id';
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_application_charges_param_application_charge_id_activate';
    };
  };
  '/admin/api/2020-10/application_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 100;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Create an application charge';
              };
              example2: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 100;
                    return_url: 'http://super-duper.shopifyapps.com';
                    test: true;
                  };
                };
                summary: 'Create a test charge that will not cause a credit card to be charged';
              };
              example3: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 0.4;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Trying to create a charge with a price less than 0.50 will return an error';
              };
              example4: {
                value: {
                  application_charge: {
                    name: '';
                  };
                };
                summary: 'Trying to create a charge without a price or name will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates an application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#create-2020-10';
      parameters: [];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_application_charges';
    };
    get: {
      summary: 'Retrieves a list of application charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_application_charges';
    };
  };
  '/admin/api/2020-10/application_charges/{application_charge_id}.json': {
    get: {
      summary: 'Retrieves an application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_application_charges_param_application_charge_id';
    };
  };
  '/admin/api/2020-10/application_charges/{application_charge_id}/activate.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_charge: {
                    id: 675931192;
                    name: 'iPod Cleaning';
                    api_client_id: 755357713;
                    price: '5.00';
                    status: 'accepted';
                    return_url: 'http://google.com';
                    test: null;
                    created_at: '2020-12-07T15:53:44-05:00';
                    updated_at: '2020-12-07T15:53:44-05:00';
                    charge_type: null;
                    decorated_return_url: 'http://google.com?charge_id=675931192';
                  };
                };
                summary: 'Activate an application charge';
              };
            };
          };
        };
      };
      summary: 'Caution\n  This endpoint is no longer required and is deprecated as of\n  API version 2021-01.\n\n"Activates an accepted application charge. One-time charges are now immediately activated\nwhen approved by a merchant.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#activate-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_charge_id';
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_application_charges_param_application_charge_id_activate';
    };
  };
  '/admin/api/2021-01/application_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 100;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Create an application charge';
              };
              example2: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 100;
                    return_url: 'http://super-duper.shopifyapps.com';
                    test: true;
                  };
                };
                summary: 'Create a test charge that will not cause a credit card to be charged';
              };
              example3: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 0.4;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Trying to create a charge with a price less than 0.50 will return an error';
              };
              example4: {
                value: {
                  application_charge: {
                    name: '';
                  };
                };
                summary: 'Trying to create a charge without a price or name will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates an application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#create-2021-01';
      parameters: [];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_application_charges';
    };
    get: {
      summary: 'Retrieves a list of application charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_application_charges';
    };
  };
  '/admin/api/2021-01/application_charges/{application_charge_id}.json': {
    get: {
      summary: 'Retrieves an application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_application_charges_param_application_charge_id';
    };
  };
  '/admin/api/unstable/application_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 100;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Create an application charge';
              };
              example2: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 100;
                    return_url: 'http://super-duper.shopifyapps.com';
                    test: true;
                  };
                };
                summary: 'Create a test charge that will not cause a credit card to be charged';
              };
              example3: {
                value: {
                  application_charge: {
                    name: 'Super Duper Expensive action';
                    price: 0.4;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Trying to create a charge with a price less than 0.50 will return an error';
              };
              example4: {
                value: {
                  application_charge: {
                    name: '';
                  };
                };
                summary: 'Trying to create a charge without a price or name will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates an application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#create-unstable';
      parameters: [];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_application_charges';
    };
    get: {
      summary: 'Retrieves a list of application charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_application_charges';
    };
  };
  '/admin/api/unstable/application_charges/{application_charge_id}.json': {
    get: {
      summary: 'Retrieves an application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcharge#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcharge', 'billing/applicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_application_charges_param_application_charge_id';
    };
  };
  '/admin/api/2020-01/application_credits.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Create a new credit';
              };
              example2: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                    test: true;
                  };
                };
                summary: 'Create a test application credit that will not issue a credit to the merchant';
              };
              example3: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Creating a credit amount that exceeds shop owner purchases over last 30 days will return an error';
              };
              example4: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Applying a credit to a shop without a previous app purchase will return an error';
              };
              example5: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Creating a credit amount that exceeds the total pending payouts for the app will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates an application credit';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#create-2020-01';
      parameters: [];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_application_credits';
    };
    get: {
      summary: 'Retrieves all application credits';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_application_credits';
    };
  };
  '/admin/api/2020-01/application_credits/{application_credit_id}.json': {
    get: {
      summary: 'Retrieves a single application credit';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'application_credit_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_credit_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_application_credits_param_application_credit_id';
    };
  };
  '/admin/api/2020-04/application_credits.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Create a new credit';
              };
              example2: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                    test: true;
                  };
                };
                summary: 'Create a test application credit that will not issue a credit to the merchant';
              };
              example3: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Creating a credit amount that exceeds shop owner purchases over last 30 days will return an error';
              };
              example4: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Applying a credit to a shop without a previous app purchase will return an error';
              };
              example5: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Creating a credit amount that exceeds the total pending payouts for the app will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates an application credit';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#create-2020-04';
      parameters: [];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_application_credits';
    };
    get: {
      summary: 'Retrieves all application credits';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_application_credits';
    };
  };
  '/admin/api/2020-04/application_credits/{application_credit_id}.json': {
    get: {
      summary: 'Retrieves a single application credit';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'application_credit_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_credit_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_application_credits_param_application_credit_id';
    };
  };
  '/admin/api/2020-07/application_credits.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Create a new credit';
              };
              example2: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                    test: true;
                  };
                };
                summary: 'Create a test application credit that will not issue a credit to the merchant';
              };
              example3: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Creating a credit amount that exceeds shop owner purchases over last 30 days will return an error';
              };
              example4: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Applying a credit to a shop without a previous app purchase will return an error';
              };
              example5: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Creating a credit amount that exceeds the total pending payouts for the app will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates an application credit';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#create-2020-07';
      parameters: [];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_application_credits';
    };
    get: {
      summary: 'Retrieves all application credits';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_application_credits';
    };
  };
  '/admin/api/2020-07/application_credits/{application_credit_id}.json': {
    get: {
      summary: 'Retrieves a single application credit';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'application_credit_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_credit_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_application_credits_param_application_credit_id';
    };
  };
  '/admin/api/2020-10/application_credits.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Create a new credit';
              };
              example2: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                    test: true;
                  };
                };
                summary: 'Create a test application credit that will not issue a credit to the merchant';
              };
              example3: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Creating a credit amount that exceeds shop owner purchases over last 30 days will return an error';
              };
              example4: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Applying a credit to a shop without a previous app purchase will return an error';
              };
              example5: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Creating a credit amount that exceeds the total pending payouts for the app will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates an application credit';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#create-2020-10';
      parameters: [];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_application_credits';
    };
    get: {
      summary: 'Retrieves all application credits';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_application_credits';
    };
  };
  '/admin/api/2020-10/application_credits/{application_credit_id}.json': {
    get: {
      summary: 'Retrieves a single application credit';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'application_credit_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_credit_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_application_credits_param_application_credit_id';
    };
  };
  '/admin/api/2021-01/application_credits.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Create a new credit';
              };
              example2: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                    test: true;
                  };
                };
                summary: 'Create a test application credit that will not issue a credit to the merchant';
              };
              example3: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Creating a credit amount that exceeds shop owner purchases over last 30 days will return an error';
              };
              example4: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Applying a credit to a shop without a previous app purchase will return an error';
              };
              example5: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Creating a credit amount that exceeds the total pending payouts for the app will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates an application credit';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#create-2021-01';
      parameters: [];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_application_credits';
    };
    get: {
      summary: 'Retrieves all application credits';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_application_credits';
    };
  };
  '/admin/api/2021-01/application_credits/{application_credit_id}.json': {
    get: {
      summary: 'Retrieves a single application credit';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'application_credit_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_credit_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_application_credits_param_application_credit_id';
    };
  };
  '/admin/api/unstable/application_credits.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Create a new credit';
              };
              example2: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                    test: true;
                  };
                };
                summary: 'Create a test application credit that will not issue a credit to the merchant';
              };
              example3: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Creating a credit amount that exceeds shop owner purchases over last 30 days will return an error';
              };
              example4: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Applying a credit to a shop without a previous app purchase will return an error';
              };
              example5: {
                value: {
                  application_credit: {
                    description: 'application credit for refund';
                    amount: 5;
                  };
                };
                summary: 'Creating a credit amount that exceeds the total pending payouts for the app will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates an application credit';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#create-unstable';
      parameters: [];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_application_credits';
    };
    get: {
      summary: 'Retrieves all application credits';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_application_credits';
    };
  };
  '/admin/api/unstable/application_credits/{application_credit_id}.json': {
    get: {
      summary: 'Retrieves a single application credit';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/applicationcredit#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'application_credit_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'application_credit_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'applicationcredit', 'billing/applicationcredit'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_application_credits_param_application_credit_id';
    };
  };
  '/admin/api/2020-01/recurring_application_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Create a recurring application charge';
              };
              example2: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    capped_amount: 100;
                    terms: '$1 for 1000 emails';
                  };
                };
                summary: 'Create a new charge with terms and a capped amount';
              };
              example3: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    trial_days: 5;
                  };
                };
                summary: 'Create a new charge with a trial period. The trial period will go into effect at the time the recurring charge is activated.';
              };
              example4: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    test: true;
                  };
                };
                summary: 'Create a recurring test charge that will not cause a credit card to be charged';
              };
              example5: {
                value: {
                  recurring_application_charge: {
                    name: '';
                  };
                };
                summary: 'Trying to create a charge without a price and name will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#create-2020-01';
      parameters: [];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_recurring_application_charges';
    };
    get: {
      summary: 'Retrieves a list of recurring application charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_recurring_application_charges';
    };
  };
  '/admin/api/2020-01/recurring_application_charges/{recurring_application_charge_id}.json': {
    get: {
      summary: 'Retrieves a single charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_recurring_application_charges_param_recurring_application_charge_id';
    };
    delete: {
      summary: 'Cancels a recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_recurring_application_charges_param_recurring_application_charge_id';
    };
  };
  '/admin/api/2020-01/recurring_application_charges/{recurring_application_charge_id}/activate.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  recurring_application_charge: {
                    id: 455696195;
                    name: 'Super Mega Plan';
                    api_client_id: 755357713;
                    price: '15.00';
                    status: 'accepted';
                    return_url: 'http://yourapp.com';
                    billing_on: '2020-12-07';
                    created_at: '2020-12-07T15:53:44-05:00';
                    updated_at: '2020-12-06T19:00:00-05:00';
                    test: null;
                    activated_on: null;
                    cancelled_on: null;
                    trial_days: 0;
                    trial_ends_on: null;
                    decorated_return_url: 'http://yourapp.com?charge_id=455696195';
                  };
                };
                summary: 'Activate a recurring application charge';
              };
            };
          };
        };
      };
      summary: 'Caution\n  This endpoint is no longer required and is deprecated as of\n  API version 2021-01.\n\nActivates a previously accepted recurring application charge. Recurring charges are now\nimmediately activated when approved by a merchant.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#activate-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_recurring_application_charges_param_recurring_application_charge_id_activate';
    };
  };
  '/admin/api/2020-01/recurring_application_charges/{recurring_application_charge_id}/customize.json': {
    put: {
      summary: 'Updates the capped amount of an active recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#customize-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'recurring_application_charge[capped_amount]';
          schema: {
            type: 'integer';
          };
          description: 'recurring_application_charge[capped_amount]';
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_recurring_application_charges_param_recurring_application_charge_id_customize';
    };
  };
  '/admin/api/2020-04/recurring_application_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Create a recurring application charge';
              };
              example2: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    capped_amount: 100;
                    terms: '$1 for 1000 emails';
                  };
                };
                summary: 'Create a new charge with terms and a capped amount';
              };
              example3: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    trial_days: 5;
                  };
                };
                summary: 'Create a new charge with a trial period. The trial period will go into effect at the time the recurring charge is activated.';
              };
              example4: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    test: true;
                  };
                };
                summary: 'Create a recurring test charge that will not cause a credit card to be charged';
              };
              example5: {
                value: {
                  recurring_application_charge: {
                    name: '';
                  };
                };
                summary: 'Trying to create a charge without a price and name will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#create-2020-04';
      parameters: [];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_recurring_application_charges';
    };
    get: {
      summary: 'Retrieves a list of recurring application charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_recurring_application_charges';
    };
  };
  '/admin/api/2020-04/recurring_application_charges/{recurring_application_charge_id}.json': {
    get: {
      summary: 'Retrieves a single charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_recurring_application_charges_param_recurring_application_charge_id';
    };
    delete: {
      summary: 'Cancels a recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_recurring_application_charges_param_recurring_application_charge_id';
    };
  };
  '/admin/api/2020-04/recurring_application_charges/{recurring_application_charge_id}/activate.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  recurring_application_charge: {
                    id: 455696195;
                    name: 'Super Mega Plan';
                    api_client_id: 755357713;
                    price: '15.00';
                    status: 'accepted';
                    return_url: 'http://yourapp.com';
                    billing_on: '2020-12-07';
                    created_at: '2020-12-07T15:53:44-05:00';
                    updated_at: '2020-12-06T19:00:00-05:00';
                    test: null;
                    activated_on: null;
                    cancelled_on: null;
                    trial_days: 0;
                    trial_ends_on: null;
                    decorated_return_url: 'http://yourapp.com?charge_id=455696195';
                  };
                };
                summary: 'Activate a recurring application charge';
              };
            };
          };
        };
      };
      summary: 'Caution\n  This endpoint is no longer required and is deprecated as of\n  API version 2021-01.\n\nActivates a previously accepted recurring application charge. Recurring charges are now\nimmediately activated when approved by a merchant.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#activate-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_recurring_application_charges_param_recurring_application_charge_id_activate';
    };
  };
  '/admin/api/2020-04/recurring_application_charges/{recurring_application_charge_id}/customize.json': {
    put: {
      summary: 'Updates the capped amount of an active recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#customize-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'recurring_application_charge[capped_amount]';
          schema: {
            type: 'integer';
          };
          description: 'recurring_application_charge[capped_amount]';
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_recurring_application_charges_param_recurring_application_charge_id_customize';
    };
  };
  '/admin/api/2020-07/recurring_application_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Create a recurring application charge';
              };
              example2: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    capped_amount: 100;
                    terms: '$1 for 1000 emails';
                  };
                };
                summary: 'Create a new charge with terms and a capped amount';
              };
              example3: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    trial_days: 5;
                  };
                };
                summary: 'Create a new charge with a trial period. The trial period will go into effect at the time the recurring charge is activated.';
              };
              example4: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    test: true;
                  };
                };
                summary: 'Create a recurring test charge that will not cause a credit card to be charged';
              };
              example5: {
                value: {
                  recurring_application_charge: {
                    name: '';
                  };
                };
                summary: 'Trying to create a charge without a price and name will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#create-2020-07';
      parameters: [];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_recurring_application_charges';
    };
    get: {
      summary: 'Retrieves a list of recurring application charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_recurring_application_charges';
    };
  };
  '/admin/api/2020-07/recurring_application_charges/{recurring_application_charge_id}.json': {
    get: {
      summary: 'Retrieves a single charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_recurring_application_charges_param_recurring_application_charge_id';
    };
    delete: {
      summary: 'Cancels a recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_recurring_application_charges_param_recurring_application_charge_id';
    };
  };
  '/admin/api/2020-07/recurring_application_charges/{recurring_application_charge_id}/activate.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  recurring_application_charge: {
                    id: 455696195;
                    name: 'Super Mega Plan';
                    api_client_id: 755357713;
                    price: '15.00';
                    status: 'accepted';
                    return_url: 'http://yourapp.com';
                    billing_on: '2020-12-07';
                    created_at: '2020-12-07T15:53:44-05:00';
                    updated_at: '2020-12-06T19:00:00-05:00';
                    test: null;
                    activated_on: null;
                    cancelled_on: null;
                    trial_days: 0;
                    trial_ends_on: null;
                    decorated_return_url: 'http://yourapp.com?charge_id=455696195';
                  };
                };
                summary: 'Activate a recurring application charge';
              };
            };
          };
        };
      };
      summary: 'Caution\n  This endpoint is no longer required and is deprecated as of\n  API version 2021-01.\n\nActivates a previously accepted recurring application charge. Recurring charges are now\nimmediately activated when approved by a merchant.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#activate-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_recurring_application_charges_param_recurring_application_charge_id_activate';
    };
  };
  '/admin/api/2020-07/recurring_application_charges/{recurring_application_charge_id}/customize.json': {
    put: {
      summary: 'Updates the capped amount of an active recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#customize-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'recurring_application_charge[capped_amount]';
          schema: {
            type: 'integer';
          };
          description: 'recurring_application_charge[capped_amount]';
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_recurring_application_charges_param_recurring_application_charge_id_customize';
    };
  };
  '/admin/api/2020-10/recurring_application_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Create a recurring application charge';
              };
              example2: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    capped_amount: 100;
                    terms: '$1 for 1000 emails';
                  };
                };
                summary: 'Create a new charge with terms and a capped amount';
              };
              example3: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    trial_days: 5;
                  };
                };
                summary: 'Create a new charge with a trial period. The trial period will go into effect at the time the recurring charge is activated.';
              };
              example4: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    test: true;
                  };
                };
                summary: 'Create a recurring test charge that will not cause a credit card to be charged';
              };
              example5: {
                value: {
                  recurring_application_charge: {
                    name: '';
                  };
                };
                summary: 'Trying to create a charge without a price and name will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#create-2020-10';
      parameters: [];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_recurring_application_charges';
    };
    get: {
      summary: 'Retrieves a list of recurring application charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_recurring_application_charges';
    };
  };
  '/admin/api/2020-10/recurring_application_charges/{recurring_application_charge_id}.json': {
    get: {
      summary: 'Retrieves a single charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_recurring_application_charges_param_recurring_application_charge_id';
    };
    delete: {
      summary: 'Cancels a recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_recurring_application_charges_param_recurring_application_charge_id';
    };
  };
  '/admin/api/2020-10/recurring_application_charges/{recurring_application_charge_id}/activate.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  recurring_application_charge: {
                    id: 455696195;
                    name: 'Super Mega Plan';
                    api_client_id: 755357713;
                    price: '15.00';
                    status: 'accepted';
                    return_url: 'http://yourapp.com';
                    billing_on: '2020-12-07';
                    created_at: '2020-12-07T15:53:44-05:00';
                    updated_at: '2020-12-06T19:00:00-05:00';
                    test: null;
                    activated_on: null;
                    cancelled_on: null;
                    trial_days: 0;
                    trial_ends_on: null;
                    decorated_return_url: 'http://yourapp.com?charge_id=455696195';
                  };
                };
                summary: 'Activate a recurring application charge';
              };
            };
          };
        };
      };
      summary: 'Caution\n  This endpoint is no longer required and is deprecated as of\n  API version 2021-01.\n\nActivates a previously accepted recurring application charge. Recurring charges are now\nimmediately activated when approved by a merchant.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#activate-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_recurring_application_charges_param_recurring_application_charge_id_activate';
    };
  };
  '/admin/api/2020-10/recurring_application_charges/{recurring_application_charge_id}/customize.json': {
    put: {
      summary: 'Updates the capped amount of an active recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#customize-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'recurring_application_charge[capped_amount]';
          schema: {
            type: 'integer';
          };
          description: 'recurring_application_charge[capped_amount]';
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_recurring_application_charges_param_recurring_application_charge_id_customize';
    };
  };
  '/admin/api/2021-01/recurring_application_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Create a recurring application charge';
              };
              example2: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    capped_amount: 100;
                    terms: '$1 for 1000 emails';
                  };
                };
                summary: 'Create a new charge with terms and a capped amount';
              };
              example3: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    trial_days: 5;
                  };
                };
                summary: 'Create a new charge with a trial period. The trial period will go into effect at the time the recurring charge is activated.';
              };
              example4: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    test: true;
                  };
                };
                summary: 'Create a recurring test charge that will not cause a credit card to be charged';
              };
              example5: {
                value: {
                  recurring_application_charge: {
                    name: '';
                  };
                };
                summary: 'Trying to create a charge without a price and name will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#create-2021-01';
      parameters: [];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_recurring_application_charges';
    };
    get: {
      summary: 'Retrieves a list of recurring application charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_recurring_application_charges';
    };
  };
  '/admin/api/2021-01/recurring_application_charges/{recurring_application_charge_id}.json': {
    get: {
      summary: 'Retrieves a single charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_recurring_application_charges_param_recurring_application_charge_id';
    };
    delete: {
      summary: 'Cancels a recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_recurring_application_charges_param_recurring_application_charge_id';
    };
  };
  '/admin/api/2021-01/recurring_application_charges/{recurring_application_charge_id}/customize.json': {
    put: {
      summary: 'Updates the capped amount of an active recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#customize-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'recurring_application_charge[capped_amount]';
          schema: {
            type: 'integer';
          };
          description: 'recurring_application_charge[capped_amount]';
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_recurring_application_charges_param_recurring_application_charge_id_customize';
    };
  };
  '/admin/api/unstable/recurring_application_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                  };
                };
                summary: 'Create a recurring application charge';
              };
              example2: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    capped_amount: 100;
                    terms: '$1 for 1000 emails';
                  };
                };
                summary: 'Create a new charge with terms and a capped amount';
              };
              example3: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    trial_days: 5;
                  };
                };
                summary: 'Create a new charge with a trial period. The trial period will go into effect at the time the recurring charge is activated.';
              };
              example4: {
                value: {
                  recurring_application_charge: {
                    name: 'Super Duper Plan';
                    price: 10;
                    return_url: 'http://super-duper.shopifyapps.com';
                    test: true;
                  };
                };
                summary: 'Create a recurring test charge that will not cause a credit card to be charged';
              };
              example5: {
                value: {
                  recurring_application_charge: {
                    name: '';
                  };
                };
                summary: 'Trying to create a charge without a price and name will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#create-unstable';
      parameters: [];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_recurring_application_charges';
    };
    get: {
      summary: 'Retrieves a list of recurring application charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_recurring_application_charges';
    };
  };
  '/admin/api/unstable/recurring_application_charges/{recurring_application_charge_id}.json': {
    get: {
      summary: 'Retrieves a single charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_recurring_application_charges_param_recurring_application_charge_id';
    };
    delete: {
      summary: 'Cancels a recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_recurring_application_charges_param_recurring_application_charge_id';
    };
  };
  '/admin/api/unstable/recurring_application_charges/{recurring_application_charge_id}/customize.json': {
    put: {
      summary: 'Updates the capped amount of an active recurring application charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/recurringapplicationcharge#customize-unstable';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'recurring_application_charge[capped_amount]';
          schema: {
            type: 'integer';
          };
          description: 'recurring_application_charge[capped_amount]';
          required: false;
        },
      ];
      tags: ['billing', 'recurringapplicationcharge', 'billing/recurringapplicationcharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_recurring_application_charges_param_recurring_application_charge_id_customize';
    };
  };
  '/admin/api/2020-01/recurring_application_charges/{recurring_application_charge_id}/usage_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  usage_charge: {
                    description: 'Super Mega Plan 1000 emails';
                    price: 1;
                  };
                };
                summary: 'Create a new usage charge';
              };
              example2: {
                value: {
                  usage_charge: {
                    description: '';
                  };
                };
                summary: 'Trying to create a charge without a price and description will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a usage charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#create-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_recurring_application_charges_param_recurring_application_charge_id_usage_charges';
    };
    get: {
      summary: 'Retrieves a list of usage charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#index-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_recurring_application_charges_param_recurring_application_charge_id_usage_charges';
    };
  };
  '/admin/api/2020-01/recurring_application_charges/{recurring_application_charge_id}/usage_charges/{usage_charge_id}.json': {
    get: {
      summary: 'Retrieves a single charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'path';
          name: 'usage_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'usage_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_recurring_application_charges_param_recurring_application_charge_id_usage_charges_param_usage_charge_id';
    };
  };
  '/admin/api/2020-04/recurring_application_charges/{recurring_application_charge_id}/usage_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  usage_charge: {
                    description: 'Super Mega Plan 1000 emails';
                    price: 1;
                  };
                };
                summary: 'Create a new usage charge';
              };
              example2: {
                value: {
                  usage_charge: {
                    description: '';
                  };
                };
                summary: 'Trying to create a charge without a price and description will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a usage charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#create-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_recurring_application_charges_param_recurring_application_charge_id_usage_charges';
    };
    get: {
      summary: 'Retrieves a list of usage charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#index-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_recurring_application_charges_param_recurring_application_charge_id_usage_charges';
    };
  };
  '/admin/api/2020-04/recurring_application_charges/{recurring_application_charge_id}/usage_charges/{usage_charge_id}.json': {
    get: {
      summary: 'Retrieves a single charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'path';
          name: 'usage_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'usage_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_recurring_application_charges_param_recurring_application_charge_id_usage_charges_param_usage_charge_id';
    };
  };
  '/admin/api/2020-07/recurring_application_charges/{recurring_application_charge_id}/usage_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  usage_charge: {
                    description: 'Super Mega Plan 1000 emails';
                    price: 1;
                  };
                };
                summary: 'Create a new usage charge';
              };
              example2: {
                value: {
                  usage_charge: {
                    description: '';
                  };
                };
                summary: 'Trying to create a charge without a price and description will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a usage charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#create-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_recurring_application_charges_param_recurring_application_charge_id_usage_charges';
    };
    get: {
      summary: 'Retrieves a list of usage charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#index-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_recurring_application_charges_param_recurring_application_charge_id_usage_charges';
    };
  };
  '/admin/api/2020-07/recurring_application_charges/{recurring_application_charge_id}/usage_charges/{usage_charge_id}.json': {
    get: {
      summary: 'Retrieves a single charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'path';
          name: 'usage_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'usage_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_recurring_application_charges_param_recurring_application_charge_id_usage_charges_param_usage_charge_id';
    };
  };
  '/admin/api/2020-10/recurring_application_charges/{recurring_application_charge_id}/usage_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  usage_charge: {
                    description: 'Super Mega Plan 1000 emails';
                    price: 1;
                  };
                };
                summary: 'Create a new usage charge';
              };
              example2: {
                value: {
                  usage_charge: {
                    description: '';
                  };
                };
                summary: 'Trying to create a charge without a price and description will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a usage charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#create-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_recurring_application_charges_param_recurring_application_charge_id_usage_charges';
    };
    get: {
      summary: 'Retrieves a list of usage charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#index-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_recurring_application_charges_param_recurring_application_charge_id_usage_charges';
    };
  };
  '/admin/api/2020-10/recurring_application_charges/{recurring_application_charge_id}/usage_charges/{usage_charge_id}.json': {
    get: {
      summary: 'Retrieves a single charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'path';
          name: 'usage_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'usage_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_recurring_application_charges_param_recurring_application_charge_id_usage_charges_param_usage_charge_id';
    };
  };
  '/admin/api/2021-01/recurring_application_charges/{recurring_application_charge_id}/usage_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  usage_charge: {
                    description: 'Super Mega Plan 1000 emails';
                    price: 1;
                  };
                };
                summary: 'Create a new usage charge';
              };
              example2: {
                value: {
                  usage_charge: {
                    description: '';
                  };
                };
                summary: 'Trying to create a charge without a price and description will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a usage charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#create-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_recurring_application_charges_param_recurring_application_charge_id_usage_charges';
    };
    get: {
      summary: 'Retrieves a list of usage charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#index-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_recurring_application_charges_param_recurring_application_charge_id_usage_charges';
    };
  };
  '/admin/api/2021-01/recurring_application_charges/{recurring_application_charge_id}/usage_charges/{usage_charge_id}.json': {
    get: {
      summary: 'Retrieves a single charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'path';
          name: 'usage_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'usage_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_recurring_application_charges_param_recurring_application_charge_id_usage_charges_param_usage_charge_id';
    };
  };
  '/admin/api/unstable/recurring_application_charges/{recurring_application_charge_id}/usage_charges.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  usage_charge: {
                    description: 'Super Mega Plan 1000 emails';
                    price: 1;
                  };
                };
                summary: 'Create a new usage charge';
              };
              example2: {
                value: {
                  usage_charge: {
                    description: '';
                  };
                };
                summary: 'Trying to create a charge without a price and description will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a usage charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#create-unstable';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_recurring_application_charges_param_recurring_application_charge_id_usage_charges';
    };
    get: {
      summary: 'Retrieves a list of usage charges';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#index-unstable';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_recurring_application_charges_param_recurring_application_charge_id_usage_charges';
    };
  };
  '/admin/api/unstable/recurring_application_charges/{recurring_application_charge_id}/usage_charges/{usage_charge_id}.json': {
    get: {
      summary: 'Retrieves a single charge';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/billing/usagecharge#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'recurring_application_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'recurring_application_charge_id';
        },
        {
          in: 'path';
          name: 'usage_charge_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'usage_charge_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['billing', 'usagecharge', 'billing/usagecharge'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_recurring_application_charges_param_recurring_application_charge_id_usage_charges_param_usage_charge_id';
    };
  };
  '/admin/api/2020-01/customers.json': {
    get: {
      summary: 'Retrieves a list of customers. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'ids';
          description: 'Restrict results to customers specified by a comma-separated list of IDs.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to those after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show customers created after a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show customers created before a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show customers last updated after a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show customers last updated before a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_customers';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                  };
                };
                summary: 'Create a new customer record';
              };
              example2: {
                value: {
                  customer: {
                    email: null;
                    first_name: null;
                    last_name: null;
                  };
                };
                summary: 'Creating a customer without an email or name fails and returns an error';
              };
              example3: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create a customer with a metafield';
              };
              example4: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    send_email_invite: true;
                  };
                };
                summary: 'Create a customer with send_email_invite';
              };
              example5: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    password: 'newpass';
                    password_confirmation: 'newpass';
                    send_email_welcome: false;
                  };
                };
                summary: 'Create a customer with password and password_confirmation and skip sending the welcome email';
              };
            };
          };
        };
      };
      summary: 'Creates a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#create-2020-01';
      parameters: [];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_customers';
    };
  };
  '/admin/api/2020-01/customers/search.json': {
    get: {
      summary: 'Searches for customers that match a supplied query. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#search-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'order';
          description: 'Set the field and direction by which to order results.\n                  (default: last_order_date DESC)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'query';
          description: "Text to search for in the shop's customer data.";
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_customers_search';
    };
  };
  '/admin/api/2020-01/customers/{customer_id}.json': {
    get: {
      summary: 'Retrieves a single customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_customers_param_customer_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer: {
                    id: 207119551;
                    email: 'changed@email.address.com';
                    note: 'Customer is a great guy';
                  };
                };
                summary: 'Update details for a customer';
              };
              example2: {
                value: {
                  customer: {
                    id: 207119551;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add metafield to an existing customer';
              };
              example3: {
                value: {
                  customer: {
                    id: 207119551;
                    tags: 'New Customer, Repeat Customer';
                  };
                };
                summary: "Update a customer's tags";
              };
              example4: {
                value: {
                  customer: {
                    id: 207119551;
                    accepts_marketing: true;
                    accepts_marketing_updated_at: '2020-11-01T16:46:41-05:00';
                    marketing_opt_in_level: 'confirmed_opt_in';
                  };
                };
                summary: "Update a customer's marketing opt-in state";
              };
            };
          };
        };
      };
      summary: 'Updates a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_customers_param_customer_id';
    };
    delete: {
      summary: "Deletes a customer. A customer can't be deleted if they have existing orders.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_customers_param_customer_id';
    };
  };
  '/admin/api/2020-01/customers/{customer_id}/account_activation_url.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {};
                summary: 'Creating an account activation URL for an enabled customer fails and returns an error';
              };
              example2: {
                value: {};
                summary: 'Create an account activation URL for an invited or disabled customer';
              };
            };
          };
        };
      };
      summary: "Generate an account activation URL for a customer whose account is not yet enabled. This is useful when you've imported a large number of customers and want to send them activation emails all at once. Using this approach, you'll need to generate and send the activation emails yourself.\n            The account activation URL generated by this endpoint is for one-time use and will expire after 30 days. If you make a new POST request to this endpoint, then a new URL will be generated. The new URL will be again valid for 30 days, but the previous URL will no longer be valid.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#account_activation_url-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_customers_param_customer_id_account_activation_url';
    };
  };
  '/admin/api/2020-01/customers/{customer_id}/send_invite.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_invite: {};
                };
                summary: 'Send the default invite';
              };
              example2: {
                value: {
                  customer_invite: {
                    to: 'new_test_email@shopify.com';
                    from: 'noaccesssteve@jobs.com';
                    bcc: ['noaccesssteve@jobs.com'];
                    subject: 'Welcome to my new shop';
                    custom_message: 'My awesome new store';
                  };
                };
                summary: 'Send a customized invite';
              };
            };
          };
        };
      };
      summary: 'Sends an account invite to a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#send_invite-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_customers_param_customer_id_send_invite';
    };
  };
  '/admin/api/2020-01/customers/count.json': {
    get: {
      summary: 'Retrieves a count of all customers.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#count-2020-01';
      parameters: [];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_customers_count';
    };
  };
  '/admin/api/2020-01/customers/{customer_id}/orders.json': {
    get: {
      summary: 'Retrieves all orders belonging to a customer. The query string parameters that are available to the  Order resource are also available to this endpoint.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#orders-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_customers_param_customer_id_orders';
    };
  };
  '/admin/api/2020-04/customers.json': {
    get: {
      summary: 'Retrieves a list of customers. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'ids';
          description: 'Restrict results to customers specified by a comma-separated list of IDs.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to those after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show customers created after a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show customers created before a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show customers last updated after a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show customers last updated before a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_customers';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                  };
                };
                summary: 'Create a new customer record';
              };
              example2: {
                value: {
                  customer: {
                    email: null;
                    first_name: null;
                    last_name: null;
                  };
                };
                summary: 'Creating a customer without an email or name fails and returns an error';
              };
              example3: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create a customer with a metafield';
              };
              example4: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    send_email_invite: true;
                  };
                };
                summary: 'Create a customer with send_email_invite';
              };
              example5: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    password: 'newpass';
                    password_confirmation: 'newpass';
                    send_email_welcome: false;
                  };
                };
                summary: 'Create a customer with password and password_confirmation and skip sending the welcome email';
              };
            };
          };
        };
      };
      summary: 'Creates a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#create-2020-04';
      parameters: [];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_customers';
    };
  };
  '/admin/api/2020-04/customers/search.json': {
    get: {
      summary: 'Searches for customers that match a supplied query. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#search-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'order';
          description: 'Set the field and direction by which to order results.\n                  (default: last_order_date DESC)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'query';
          description: "Text to search for in the shop's customer data.";
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_customers_search';
    };
  };
  '/admin/api/2020-04/customers/{customer_id}.json': {
    get: {
      summary: 'Retrieves a single customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_customers_param_customer_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer: {
                    id: 207119551;
                    email: 'changed@email.address.com';
                    note: 'Customer is a great guy';
                  };
                };
                summary: 'Update details for a customer';
              };
              example2: {
                value: {
                  customer: {
                    id: 207119551;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add metafield to an existing customer';
              };
              example3: {
                value: {
                  customer: {
                    id: 207119551;
                    tags: 'New Customer, Repeat Customer';
                  };
                };
                summary: "Update a customer's tags";
              };
              example4: {
                value: {
                  customer: {
                    id: 207119551;
                    accepts_marketing: true;
                    accepts_marketing_updated_at: '2020-11-01T16:46:41-05:00';
                    marketing_opt_in_level: 'confirmed_opt_in';
                  };
                };
                summary: "Update a customer's marketing opt-in state";
              };
            };
          };
        };
      };
      summary: 'Updates a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_customers_param_customer_id';
    };
    delete: {
      summary: "Deletes a customer. A customer can't be deleted if they have existing orders.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_customers_param_customer_id';
    };
  };
  '/admin/api/2020-04/customers/{customer_id}/account_activation_url.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {};
                summary: 'Creating an account activation URL for an enabled customer fails and returns an error';
              };
              example2: {
                value: {};
                summary: 'Create an account activation URL for an invited or disabled customer';
              };
            };
          };
        };
      };
      summary: "Generate an account activation URL for a customer whose account is not yet enabled. This is useful when you've imported a large number of customers and want to send them activation emails all at once. Using this approach, you'll need to generate and send the activation emails yourself.\n            The account activation URL generated by this endpoint is for one-time use and will expire after 30 days. If you make a new POST request to this endpoint, then a new URL will be generated. The new URL will be again valid for 30 days, but the previous URL will no longer be valid.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#account_activation_url-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_customers_param_customer_id_account_activation_url';
    };
  };
  '/admin/api/2020-04/customers/{customer_id}/send_invite.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_invite: {};
                };
                summary: 'Send the default invite';
              };
              example2: {
                value: {
                  customer_invite: {
                    to: 'new_test_email@shopify.com';
                    from: 'noaccesssteve@jobs.com';
                    bcc: ['noaccesssteve@jobs.com'];
                    subject: 'Welcome to my new shop';
                    custom_message: 'My awesome new store';
                  };
                };
                summary: 'Send a customized invite';
              };
            };
          };
        };
      };
      summary: 'Sends an account invite to a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#send_invite-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_customers_param_customer_id_send_invite';
    };
  };
  '/admin/api/2020-04/customers/count.json': {
    get: {
      summary: 'Retrieves a count of all customers.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#count-2020-04';
      parameters: [];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_customers_count';
    };
  };
  '/admin/api/2020-04/customers/{customer_id}/orders.json': {
    get: {
      summary: 'Retrieves all orders belonging to a customer. The query string parameters that are available to the  Order resource are also available to this endpoint.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#orders-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_customers_param_customer_id_orders';
    };
  };
  '/admin/api/2020-07/customers.json': {
    get: {
      summary: 'Retrieves a list of customers. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'ids';
          description: 'Restrict results to customers specified by a comma-separated list of IDs.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to those after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show customers created after a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show customers created before a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show customers last updated after a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show customers last updated before a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_customers';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                  };
                };
                summary: 'Create a new customer record';
              };
              example2: {
                value: {
                  customer: {
                    email: null;
                    first_name: null;
                    last_name: null;
                  };
                };
                summary: 'Creating a customer without an email or name fails and returns an error';
              };
              example3: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create a customer with a metafield';
              };
              example4: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    send_email_invite: true;
                  };
                };
                summary: 'Create a customer with send_email_invite';
              };
              example5: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    password: 'newpass';
                    password_confirmation: 'newpass';
                    send_email_welcome: false;
                  };
                };
                summary: 'Create a customer with password and password_confirmation and skip sending the welcome email';
              };
            };
          };
        };
      };
      summary: 'Creates a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#create-2020-07';
      parameters: [];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_customers';
    };
  };
  '/admin/api/2020-07/customers/search.json': {
    get: {
      summary: 'Searches for customers that match a supplied query. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#search-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'order';
          description: 'Set the field and direction by which to order results.\n                  (default: last_order_date DESC)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'query';
          description: "Text to search for in the shop's customer data.";
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_customers_search';
    };
  };
  '/admin/api/2020-07/customers/{customer_id}.json': {
    get: {
      summary: 'Retrieves a single customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_customers_param_customer_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer: {
                    id: 207119551;
                    email: 'changed@email.address.com';
                    note: 'Customer is a great guy';
                  };
                };
                summary: 'Update details for a customer';
              };
              example2: {
                value: {
                  customer: {
                    id: 207119551;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add metafield to an existing customer';
              };
              example3: {
                value: {
                  customer: {
                    id: 207119551;
                    tags: 'New Customer, Repeat Customer';
                  };
                };
                summary: "Update a customer's tags";
              };
              example4: {
                value: {
                  customer: {
                    id: 207119551;
                    accepts_marketing: true;
                    accepts_marketing_updated_at: '2020-11-01T16:46:41-05:00';
                    marketing_opt_in_level: 'confirmed_opt_in';
                  };
                };
                summary: "Update a customer's marketing opt-in state";
              };
            };
          };
        };
      };
      summary: 'Updates a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_customers_param_customer_id';
    };
    delete: {
      summary: "Deletes a customer. A customer can't be deleted if they have existing orders.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_customers_param_customer_id';
    };
  };
  '/admin/api/2020-07/customers/{customer_id}/account_activation_url.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {};
                summary: 'Creating an account activation URL for an enabled customer fails and returns an error';
              };
              example2: {
                value: {};
                summary: 'Create an account activation URL for an invited or disabled customer';
              };
            };
          };
        };
      };
      summary: "Generate an account activation URL for a customer whose account is not yet enabled. This is useful when you've imported a large number of customers and want to send them activation emails all at once. Using this approach, you'll need to generate and send the activation emails yourself.\n            The account activation URL generated by this endpoint is for one-time use and will expire after 30 days. If you make a new POST request to this endpoint, then a new URL will be generated. The new URL will be again valid for 30 days, but the previous URL will no longer be valid.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#account_activation_url-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_customers_param_customer_id_account_activation_url';
    };
  };
  '/admin/api/2020-07/customers/{customer_id}/send_invite.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_invite: {};
                };
                summary: 'Send the default invite';
              };
              example2: {
                value: {
                  customer_invite: {
                    to: 'new_test_email@shopify.com';
                    from: 'noaccesssteve@jobs.com';
                    bcc: ['noaccesssteve@jobs.com'];
                    subject: 'Welcome to my new shop';
                    custom_message: 'My awesome new store';
                  };
                };
                summary: 'Send a customized invite';
              };
            };
          };
        };
      };
      summary: 'Sends an account invite to a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#send_invite-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_customers_param_customer_id_send_invite';
    };
  };
  '/admin/api/2020-07/customers/count.json': {
    get: {
      summary: 'Retrieves a count of all customers.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#count-2020-07';
      parameters: [];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_customers_count';
    };
  };
  '/admin/api/2020-07/customers/{customer_id}/orders.json': {
    get: {
      summary: 'Retrieves all orders belonging to a customer. The query string parameters that are available to the  Order resource are also available to this endpoint.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#orders-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_customers_param_customer_id_orders';
    };
  };
  '/admin/api/2020-10/customers.json': {
    get: {
      summary: 'Retrieves a list of customers. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'ids';
          description: 'Restrict results to customers specified by a comma-separated list of IDs.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to those after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show customers created after a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show customers created before a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show customers last updated after a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show customers last updated before a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_customers';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                  };
                };
                summary: 'Create a new customer record';
              };
              example2: {
                value: {
                  customer: {
                    email: null;
                    first_name: null;
                    last_name: null;
                  };
                };
                summary: 'Creating a customer without an email or name fails and returns an error';
              };
              example3: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create a customer with a metafield';
              };
              example4: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    send_email_invite: true;
                  };
                };
                summary: 'Create a customer with send_email_invite';
              };
              example5: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    password: 'newpass';
                    password_confirmation: 'newpass';
                    send_email_welcome: false;
                  };
                };
                summary: 'Create a customer with password and password_confirmation and skip sending the welcome email';
              };
            };
          };
        };
      };
      summary: 'Creates a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#create-2020-10';
      parameters: [];
      tags: ['customers', 'customer', 'customers/customer', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_customers';
    };
  };
  '/admin/api/2020-10/customers/search.json': {
    get: {
      summary: 'Searches for customers that match a supplied query. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#search-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'order';
          description: 'Set the field and direction by which to order results.\n                  (default: last_order_date DESC)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'query';
          description: "Text to search for in the shop's customer data.";
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_customers_search';
    };
  };
  '/admin/api/2020-10/customers/{customer_id}.json': {
    get: {
      summary: 'Retrieves a single customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_customers_param_customer_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer: {
                    id: 207119551;
                    email: 'changed@email.address.com';
                    note: 'Customer is a great guy';
                  };
                };
                summary: 'Update details for a customer';
              };
              example2: {
                value: {
                  customer: {
                    id: 207119551;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add metafield to an existing customer';
              };
              example3: {
                value: {
                  customer: {
                    id: 207119551;
                    tags: 'New Customer, Repeat Customer';
                  };
                };
                summary: "Update a customer's tags";
              };
              example4: {
                value: {
                  customer: {
                    id: 207119551;
                    accepts_marketing: true;
                    accepts_marketing_updated_at: '2020-11-01T16:46:41-05:00';
                    marketing_opt_in_level: 'confirmed_opt_in';
                  };
                };
                summary: "Update a customer's marketing opt-in state";
              };
            };
          };
        };
      };
      summary: 'Updates a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#update-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_customers_param_customer_id';
    };
    delete: {
      summary: "Deletes a customer. A customer can't be deleted if they have existing orders.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_customers_param_customer_id';
    };
  };
  '/admin/api/2020-10/customers/{customer_id}/account_activation_url.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {};
                summary: 'Creating an account activation URL for an enabled customer fails and returns an error';
              };
              example2: {
                value: {};
                summary: 'Create an account activation URL for an invited or disabled customer';
              };
            };
          };
        };
      };
      summary: "Generate an account activation URL for a customer whose account is not yet enabled. This is useful when you've imported a large number of customers and want to send them activation emails all at once. Using this approach, you'll need to generate and send the activation emails yourself.\n            The account activation URL generated by this endpoint is for one-time use and will expire after 30 days. If you make a new POST request to this endpoint, then a new URL will be generated. The new URL will be again valid for 30 days, but the previous URL will no longer be valid.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#account_activation_url-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_customers_param_customer_id_account_activation_url';
    };
  };
  '/admin/api/2020-10/customers/{customer_id}/send_invite.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_invite: {};
                };
                summary: 'Send the default invite';
              };
              example2: {
                value: {
                  customer_invite: {
                    to: 'new_test_email@shopify.com';
                    from: 'noaccesssteve@jobs.com';
                    bcc: ['noaccesssteve@jobs.com'];
                    subject: 'Welcome to my new shop';
                    custom_message: 'My awesome new store';
                  };
                };
                summary: 'Send a customized invite';
              };
            };
          };
        };
      };
      summary: 'Sends an account invite to a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#send_invite-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_customers_param_customer_id_send_invite';
    };
  };
  '/admin/api/2020-10/customers/count.json': {
    get: {
      summary: 'Retrieves a count of all customers.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#count-2020-10';
      parameters: [];
      tags: ['customers', 'customer', 'customers/customer', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_customers_count';
    };
  };
  '/admin/api/2020-10/customers/{customer_id}/orders.json': {
    get: {
      summary: 'Retrieves all orders belonging to a customer. The query string parameters that are available to the  Order resource are also available to this endpoint.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#orders-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_customers_param_customer_id_orders';
    };
  };
  '/admin/api/2021-01/customers.json': {
    get: {
      summary: 'Retrieves a list of customers. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'ids';
          description: 'Restrict results to customers specified by a comma-separated list of IDs.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to those after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show customers created after a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show customers created before a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show customers last updated after a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show customers last updated before a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_customers';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                  };
                };
                summary: 'Create a new customer record';
              };
              example2: {
                value: {
                  customer: {
                    email: null;
                    first_name: null;
                    last_name: null;
                  };
                };
                summary: 'Creating a customer without an email or name fails and returns an error';
              };
              example3: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create a customer with a metafield';
              };
              example4: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    send_email_invite: true;
                  };
                };
                summary: 'Create a customer with send_email_invite';
              };
              example5: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    password: 'newpass';
                    password_confirmation: 'newpass';
                    send_email_welcome: false;
                  };
                };
                summary: 'Create a customer with password and password_confirmation and skip sending the welcome email';
              };
            };
          };
        };
      };
      summary: 'Creates a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#create-2021-01';
      parameters: [];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_customers';
    };
  };
  '/admin/api/2021-01/customers/search.json': {
    get: {
      summary: 'Searches for customers that match a supplied query. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#search-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'order';
          description: 'Set the field and direction by which to order results.\n                  (default: last_order_date DESC)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'query';
          description: "Text to search for in the shop's customer data.";
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_customers_search';
    };
  };
  '/admin/api/2021-01/customers/{customer_id}.json': {
    get: {
      summary: 'Retrieves a single customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_customers_param_customer_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer: {
                    id: 207119551;
                    email: 'changed@email.address.com';
                    note: 'Customer is a great guy';
                  };
                };
                summary: 'Update details for a customer';
              };
              example2: {
                value: {
                  customer: {
                    id: 207119551;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add metafield to an existing customer';
              };
              example3: {
                value: {
                  customer: {
                    id: 207119551;
                    tags: 'New Customer, Repeat Customer';
                  };
                };
                summary: "Update a customer's tags";
              };
              example4: {
                value: {
                  customer: {
                    id: 207119551;
                    accepts_marketing: true;
                    accepts_marketing_updated_at: '2020-11-01T16:46:41-05:00';
                    marketing_opt_in_level: 'confirmed_opt_in';
                  };
                };
                summary: "Update a customer's marketing opt-in state";
              };
            };
          };
        };
      };
      summary: 'Updates a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#update-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_customers_param_customer_id';
    };
    delete: {
      summary: "Deletes a customer. A customer can't be deleted if they have existing orders.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_customers_param_customer_id';
    };
  };
  '/admin/api/2021-01/customers/{customer_id}/account_activation_url.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {};
                summary: 'Creating an account activation URL for an enabled customer fails and returns an error';
              };
              example2: {
                value: {};
                summary: 'Create an account activation URL for an invited or disabled customer';
              };
            };
          };
        };
      };
      summary: "Generate an account activation URL for a customer whose account is not yet enabled. This is useful when you've imported a large number of customers and want to send them activation emails all at once. Using this approach, you'll need to generate and send the activation emails yourself.\n            The account activation URL generated by this endpoint is for one-time use and will expire after 30 days. If you make a new POST request to this endpoint, then a new URL will be generated. The new URL will be again valid for 30 days, but the previous URL will no longer be valid.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#account_activation_url-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_customers_param_customer_id_account_activation_url';
    };
  };
  '/admin/api/2021-01/customers/{customer_id}/send_invite.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_invite: {};
                };
                summary: 'Send the default invite';
              };
              example2: {
                value: {
                  customer_invite: {
                    to: 'new_test_email@shopify.com';
                    from: 'noaccesssteve@jobs.com';
                    bcc: ['noaccesssteve@jobs.com'];
                    subject: 'Welcome to my new shop';
                    custom_message: 'My awesome new store';
                  };
                };
                summary: 'Send a customized invite';
              };
            };
          };
        };
      };
      summary: 'Sends an account invite to a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#send_invite-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_customers_param_customer_id_send_invite';
    };
  };
  '/admin/api/2021-01/customers/count.json': {
    get: {
      summary: 'Retrieves a count of all customers.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#count-2021-01';
      parameters: [];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_customers_count';
    };
  };
  '/admin/api/2021-01/customers/{customer_id}/orders.json': {
    get: {
      summary: 'Retrieves all orders belonging to a customer. The query string parameters that are available to the  Order resource are also available to this endpoint.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#orders-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_customers_param_customer_id_orders';
    };
  };
  '/admin/api/unstable/customers.json': {
    get: {
      summary: 'Retrieves a list of customers. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'ids';
          description: 'Restrict results to customers specified by a comma-separated list of IDs.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to those after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show customers created after a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show customers created before a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show customers last updated after a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show customers last updated before a specified date.(format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_customers';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                  };
                };
                summary: 'Create a new customer record';
              };
              example2: {
                value: {
                  customer: {
                    email: null;
                    first_name: null;
                    last_name: null;
                  };
                };
                summary: 'Creating a customer without an email or name fails and returns an error';
              };
              example3: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create a customer with a metafield';
              };
              example4: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    send_email_invite: true;
                  };
                };
                summary: 'Create a customer with send_email_invite';
              };
              example5: {
                value: {
                  customer: {
                    first_name: 'Steve';
                    last_name: 'Lastnameson';
                    email: 'steve.lastnameson@example.com';
                    phone: '+15142546011';
                    verified_email: true;
                    addresses: [
                      {
                        address1: '123 Oak St';
                        city: 'Ottawa';
                        province: 'ON';
                        phone: '555-1212';
                        zip: '123 ABC';
                        last_name: 'Lastnameson';
                        first_name: 'Mother';
                        country: 'CA';
                      },
                    ];
                    password: 'newpass';
                    password_confirmation: 'newpass';
                    send_email_welcome: false;
                  };
                };
                summary: 'Create a customer with password and password_confirmation and skip sending the welcome email';
              };
            };
          };
        };
      };
      summary: 'Creates a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#create-unstable';
      parameters: [];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_customers';
    };
  };
  '/admin/api/unstable/customers/search.json': {
    get: {
      summary: 'Searches for customers that match a supplied query. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#search-unstable';
      parameters: [
        {
          in: 'query';
          name: 'order';
          description: 'Set the field and direction by which to order results.\n                  (default: last_order_date DESC)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'query';
          description: "Text to search for in the shop's customer data.";
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_customers_search';
    };
  };
  '/admin/api/unstable/customers/{customer_id}.json': {
    get: {
      summary: 'Retrieves a single customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_customers_param_customer_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer: {
                    id: 207119551;
                    email: 'changed@email.address.com';
                    note: 'Customer is a great guy';
                  };
                };
                summary: 'Update details for a customer';
              };
              example2: {
                value: {
                  customer: {
                    id: 207119551;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add metafield to an existing customer';
              };
              example3: {
                value: {
                  customer: {
                    id: 207119551;
                    tags: 'New Customer, Repeat Customer';
                  };
                };
                summary: "Update a customer's tags";
              };
              example4: {
                value: {
                  customer: {
                    id: 207119551;
                    accepts_marketing: true;
                    accepts_marketing_updated_at: '2020-11-01T16:46:41-05:00';
                    marketing_opt_in_level: 'confirmed_opt_in';
                  };
                };
                summary: "Update a customer's marketing opt-in state";
              };
            };
          };
        };
      };
      summary: 'Updates a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#update-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_customers_param_customer_id';
    };
    delete: {
      summary: "Deletes a customer. A customer can't be deleted if they have existing orders.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_customers_param_customer_id';
    };
  };
  '/admin/api/unstable/customers/{customer_id}/account_activation_url.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {};
                summary: 'Creating an account activation URL for an enabled customer fails and returns an error';
              };
              example2: {
                value: {};
                summary: 'Create an account activation URL for an invited or disabled customer';
              };
            };
          };
        };
      };
      summary: "Generate an account activation URL for a customer whose account is not yet enabled. This is useful when you've imported a large number of customers and want to send them activation emails all at once. Using this approach, you'll need to generate and send the activation emails yourself.\n            The account activation URL generated by this endpoint is for one-time use and will expire after 30 days. If you make a new POST request to this endpoint, then a new URL will be generated. The new URL will be again valid for 30 days, but the previous URL will no longer be valid.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#account_activation_url-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_customers_param_customer_id_account_activation_url';
    };
  };
  '/admin/api/unstable/customers/{customer_id}/send_invite.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_invite: {};
                };
                summary: 'Send the default invite';
              };
              example2: {
                value: {
                  customer_invite: {
                    to: 'new_test_email@shopify.com';
                    from: 'noaccesssteve@jobs.com';
                    bcc: ['noaccesssteve@jobs.com'];
                    subject: 'Welcome to my new shop';
                    custom_message: 'My awesome new store';
                  };
                };
                summary: 'Send a customized invite';
              };
            };
          };
        };
      };
      summary: 'Sends an account invite to a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#send_invite-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_customers_param_customer_id_send_invite';
    };
  };
  '/admin/api/unstable/customers/count.json': {
    get: {
      summary: 'Retrieves a count of all customers.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#count-unstable';
      parameters: [];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_customers_count';
    };
  };
  '/admin/api/unstable/customers/{customer_id}/orders.json': {
    get: {
      summary: 'Retrieves all orders belonging to a customer. The query string parameters that are available to the  Order resource are also available to this endpoint.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer#orders-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer', 'customers/customer'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_customers_param_customer_id_orders';
    };
  };
  '/admin/api/2020-01/customers/{customer_id}/addresses.json': {
    get: {
      summary: 'Retrieves a list of addresses for a customer. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#index-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_customers_param_customer_id_addresses';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  address: {
                    address1: '1 Rue des Carrieres';
                    address2: 'Suite 1234';
                    city: 'Montreal';
                    company: 'Fancy Co.';
                    first_name: 'Samuel';
                    last_name: 'de Champlain';
                    phone: '819-555-5555';
                    province: 'Quebec';
                    country: 'Canada';
                    zip: 'G1R 4P5';
                    name: 'Samuel de Champlain';
                    province_code: 'QC';
                    country_code: 'CA';
                    country_name: 'Canada';
                  };
                };
                summary: 'Create a new address for a customer';
              };
            };
          };
        };
      };
      summary: 'Creates a new address for a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#create-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_customers_param_customer_id_addresses';
    };
  };
  '/admin/api/2020-01/customers/{customer_id}/addresses/{address_id}.json': {
    get: {
      summary: 'Retrieves details a single customer address.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_customers_param_customer_id_addresses_param_address_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  address: {
                    id: 207119551;
                    zip: '90210';
                  };
                };
                summary: 'Update the postal code of a customer address';
              };
            };
          };
        };
      };
      summary: 'Updates an existing customer address.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_customers_param_customer_id_addresses_param_address_id';
    };
    delete: {
      summary: 'Removes an address from a customer’s address list.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_customers_param_customer_id_addresses_param_address_id';
    };
  };
  '/admin/api/2020-01/customers/{customer_id}/addresses/set.json': {
    put: {
      summary: 'Performs bulk operations for multiple customer addresses.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#set-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'query';
          name: 'address_ids[]';
          schema: {
            type: 'integer';
          };
          description: 'address_ids[]';
          required: false;
        },
        {
          in: 'query';
          name: 'operation';
          schema: {
            type: 'string';
          };
          description: 'operation';
          required: false;
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_customers_param_customer_id_addresses_set';
    };
  };
  '/admin/api/2020-01/customers/{customer_id}/addresses/{address_id}/default.json': {
    put: {
      summary: 'Sets the default address for a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#default-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_customers_param_customer_id_addresses_param_address_id_default';
    };
  };
  '/admin/api/2020-04/customers/{customer_id}/addresses.json': {
    get: {
      summary: 'Retrieves a list of addresses for a customer. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#index-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_customers_param_customer_id_addresses';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  address: {
                    address1: '1 Rue des Carrieres';
                    address2: 'Suite 1234';
                    city: 'Montreal';
                    company: 'Fancy Co.';
                    first_name: 'Samuel';
                    last_name: 'de Champlain';
                    phone: '819-555-5555';
                    province: 'Quebec';
                    country: 'Canada';
                    zip: 'G1R 4P5';
                    name: 'Samuel de Champlain';
                    province_code: 'QC';
                    country_code: 'CA';
                    country_name: 'Canada';
                  };
                };
                summary: 'Create a new address for a customer';
              };
            };
          };
        };
      };
      summary: 'Creates a new address for a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#create-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_customers_param_customer_id_addresses';
    };
  };
  '/admin/api/2020-04/customers/{customer_id}/addresses/{address_id}.json': {
    get: {
      summary: 'Retrieves details a single customer address.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_customers_param_customer_id_addresses_param_address_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  address: {
                    id: 207119551;
                    zip: '90210';
                  };
                };
                summary: 'Update the postal code of a customer address';
              };
            };
          };
        };
      };
      summary: 'Updates an existing customer address.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_customers_param_customer_id_addresses_param_address_id';
    };
    delete: {
      summary: 'Removes an address from a customer’s address list.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_customers_param_customer_id_addresses_param_address_id';
    };
  };
  '/admin/api/2020-04/customers/{customer_id}/addresses/set.json': {
    put: {
      summary: 'Performs bulk operations for multiple customer addresses.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#set-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'query';
          name: 'address_ids[]';
          schema: {
            type: 'integer';
          };
          description: 'address_ids[]';
          required: false;
        },
        {
          in: 'query';
          name: 'operation';
          schema: {
            type: 'string';
          };
          description: 'operation';
          required: false;
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_customers_param_customer_id_addresses_set';
    };
  };
  '/admin/api/2020-04/customers/{customer_id}/addresses/{address_id}/default.json': {
    put: {
      summary: 'Sets the default address for a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#default-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_customers_param_customer_id_addresses_param_address_id_default';
    };
  };
  '/admin/api/2020-07/customers/{customer_id}/addresses.json': {
    get: {
      summary: 'Retrieves a list of addresses for a customer. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#index-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_customers_param_customer_id_addresses';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  address: {
                    address1: '1 Rue des Carrieres';
                    address2: 'Suite 1234';
                    city: 'Montreal';
                    company: 'Fancy Co.';
                    first_name: 'Samuel';
                    last_name: 'de Champlain';
                    phone: '819-555-5555';
                    province: 'Quebec';
                    country: 'Canada';
                    zip: 'G1R 4P5';
                    name: 'Samuel de Champlain';
                    province_code: 'QC';
                    country_code: 'CA';
                    country_name: 'Canada';
                  };
                };
                summary: 'Create a new address for a customer';
              };
            };
          };
        };
      };
      summary: 'Creates a new address for a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#create-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_customers_param_customer_id_addresses';
    };
  };
  '/admin/api/2020-07/customers/{customer_id}/addresses/{address_id}.json': {
    get: {
      summary: 'Retrieves details a single customer address.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_customers_param_customer_id_addresses_param_address_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  address: {
                    id: 207119551;
                    zip: '90210';
                  };
                };
                summary: 'Update the postal code of a customer address';
              };
            };
          };
        };
      };
      summary: 'Updates an existing customer address.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_customers_param_customer_id_addresses_param_address_id';
    };
    delete: {
      summary: 'Removes an address from a customer’s address list.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_customers_param_customer_id_addresses_param_address_id';
    };
  };
  '/admin/api/2020-07/customers/{customer_id}/addresses/set.json': {
    put: {
      summary: 'Performs bulk operations for multiple customer addresses.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#set-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'query';
          name: 'address_ids[]';
          schema: {
            type: 'integer';
          };
          description: 'address_ids[]';
          required: false;
        },
        {
          in: 'query';
          name: 'operation';
          schema: {
            type: 'string';
          };
          description: 'operation';
          required: false;
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_customers_param_customer_id_addresses_set';
    };
  };
  '/admin/api/2020-07/customers/{customer_id}/addresses/{address_id}/default.json': {
    put: {
      summary: 'Sets the default address for a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#default-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_customers_param_customer_id_addresses_param_address_id_default';
    };
  };
  '/admin/api/2020-10/customers/{customer_id}/addresses.json': {
    get: {
      summary: 'Retrieves a list of addresses for a customer. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#index-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_customers_param_customer_id_addresses';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  address: {
                    address1: '1 Rue des Carrieres';
                    address2: 'Suite 1234';
                    city: 'Montreal';
                    company: 'Fancy Co.';
                    first_name: 'Samuel';
                    last_name: 'de Champlain';
                    phone: '819-555-5555';
                    province: 'Quebec';
                    country: 'Canada';
                    zip: 'G1R 4P5';
                    name: 'Samuel de Champlain';
                    province_code: 'QC';
                    country_code: 'CA';
                    country_name: 'Canada';
                  };
                };
                summary: 'Create a new address for a customer';
              };
            };
          };
        };
      };
      summary: 'Creates a new address for a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#create-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_customers_param_customer_id_addresses';
    };
  };
  '/admin/api/2020-10/customers/{customer_id}/addresses/{address_id}.json': {
    get: {
      summary: 'Retrieves details a single customer address.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_customers_param_customer_id_addresses_param_address_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  address: {
                    id: 207119551;
                    zip: '90210';
                  };
                };
                summary: 'Update the postal code of a customer address';
              };
            };
          };
        };
      };
      summary: 'Updates an existing customer address.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#update-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_customers_param_customer_id_addresses_param_address_id';
    };
    delete: {
      summary: 'Removes an address from a customer’s address list.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_customers_param_customer_id_addresses_param_address_id';
    };
  };
  '/admin/api/2020-10/customers/{customer_id}/addresses/set.json': {
    put: {
      summary: 'Performs bulk operations for multiple customer addresses.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#set-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'query';
          name: 'address_ids[]';
          schema: {
            type: 'integer';
          };
          description: 'address_ids[]';
          required: false;
        },
        {
          in: 'query';
          name: 'operation';
          schema: {
            type: 'string';
          };
          description: 'operation';
          required: false;
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_customers_param_customer_id_addresses_set';
    };
  };
  '/admin/api/2020-10/customers/{customer_id}/addresses/{address_id}/default.json': {
    put: {
      summary: 'Sets the default address for a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#default-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_customers_param_customer_id_addresses_param_address_id_default';
    };
  };
  '/admin/api/2021-01/customers/{customer_id}/addresses.json': {
    get: {
      summary: 'Retrieves a list of addresses for a customer. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#index-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_customers_param_customer_id_addresses';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  address: {
                    address1: '1 Rue des Carrieres';
                    address2: 'Suite 1234';
                    city: 'Montreal';
                    company: 'Fancy Co.';
                    first_name: 'Samuel';
                    last_name: 'de Champlain';
                    phone: '819-555-5555';
                    province: 'Quebec';
                    country: 'Canada';
                    zip: 'G1R 4P5';
                    name: 'Samuel de Champlain';
                    province_code: 'QC';
                    country_code: 'CA';
                    country_name: 'Canada';
                  };
                };
                summary: 'Create a new address for a customer';
              };
            };
          };
        };
      };
      summary: 'Creates a new address for a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#create-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_customers_param_customer_id_addresses';
    };
  };
  '/admin/api/2021-01/customers/{customer_id}/addresses/{address_id}.json': {
    get: {
      summary: 'Retrieves details a single customer address.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_customers_param_customer_id_addresses_param_address_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  address: {
                    id: 207119551;
                    zip: '90210';
                  };
                };
                summary: 'Update the postal code of a customer address';
              };
            };
          };
        };
      };
      summary: 'Updates an existing customer address.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#update-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_customers_param_customer_id_addresses_param_address_id';
    };
    delete: {
      summary: 'Removes an address from a customer’s address list.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_customers_param_customer_id_addresses_param_address_id';
    };
  };
  '/admin/api/2021-01/customers/{customer_id}/addresses/set.json': {
    put: {
      summary: 'Performs bulk operations for multiple customer addresses.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#set-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'query';
          name: 'address_ids[]';
          schema: {
            type: 'integer';
          };
          description: 'address_ids[]';
          required: false;
        },
        {
          in: 'query';
          name: 'operation';
          schema: {
            type: 'string';
          };
          description: 'operation';
          required: false;
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_customers_param_customer_id_addresses_set';
    };
  };
  '/admin/api/2021-01/customers/{customer_id}/addresses/{address_id}/default.json': {
    put: {
      summary: 'Sets the default address for a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#default-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_customers_param_customer_id_addresses_param_address_id_default';
    };
  };
  '/admin/api/unstable/customers/{customer_id}/addresses.json': {
    get: {
      summary: 'Retrieves a list of addresses for a customer. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#index-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_customers_param_customer_id_addresses';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  address: {
                    address1: '1 Rue des Carrieres';
                    address2: 'Suite 1234';
                    city: 'Montreal';
                    company: 'Fancy Co.';
                    first_name: 'Samuel';
                    last_name: 'de Champlain';
                    phone: '819-555-5555';
                    province: 'Quebec';
                    country: 'Canada';
                    zip: 'G1R 4P5';
                    name: 'Samuel de Champlain';
                    province_code: 'QC';
                    country_code: 'CA';
                    country_name: 'Canada';
                  };
                };
                summary: 'Create a new address for a customer';
              };
            };
          };
        };
      };
      summary: 'Creates a new address for a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#create-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_customers_param_customer_id_addresses';
    };
  };
  '/admin/api/unstable/customers/{customer_id}/addresses/{address_id}.json': {
    get: {
      summary: 'Retrieves details a single customer address.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_customers_param_customer_id_addresses_param_address_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  address: {
                    id: 207119551;
                    zip: '90210';
                  };
                };
                summary: 'Update the postal code of a customer address';
              };
            };
          };
        };
      };
      summary: 'Updates an existing customer address.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#update-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_customers_param_customer_id_addresses_param_address_id';
    };
    delete: {
      summary: 'Removes an address from a customer’s address list.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_customers_param_customer_id_addresses_param_address_id';
    };
  };
  '/admin/api/unstable/customers/{customer_id}/addresses/set.json': {
    put: {
      summary: 'Performs bulk operations for multiple customer addresses.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#set-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'query';
          name: 'address_ids[]';
          schema: {
            type: 'integer';
          };
          description: 'address_ids[]';
          required: false;
        },
        {
          in: 'query';
          name: 'operation';
          schema: {
            type: 'string';
          };
          description: 'operation';
          required: false;
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_customers_param_customer_id_addresses_set';
    };
  };
  '/admin/api/unstable/customers/{customer_id}/addresses/{address_id}/default.json': {
    put: {
      summary: 'Sets the default address for a customer.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customer-address#default-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_id';
        },
        {
          in: 'path';
          name: 'address_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'address_id';
        },
      ];
      tags: ['customers', 'customer-address', 'customers/customer-address'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_customers_param_customer_id_addresses_param_address_id_default';
    };
  };
  '/admin/api/2020-01/customer_saved_searches.json': {
    get: {
      summary: 'Retrieves a list of customer saved searches. Note: As of version 2019-07, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_customer_saved_searches';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_saved_search: {
                    name: 'Spent more than $50';
                    query: 'total_spent:>50';
                  };
                };
                summary: 'Create a customer saved search';
              };
              example2: {
                value: {
                  customer_saved_search: {
                    name: 'Spent more than $50 and after 2013';
                    query: 'total_spent:>50 order_date:>=2013-01-01';
                  };
                };
                summary: 'Create a customer saved search with multiple terms';
              };
              example3: {
                value: {
                  customer_saved_search: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a customer saved search without a name fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#create-2020-01';
      parameters: [];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_customer_saved_searches';
    };
  };
  '/admin/api/2020-01/customer_saved_searches/count.json': {
    get: {
      summary: 'Retrieves a count of all customer saved searches.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#count-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_customer_saved_searches_count';
    };
  };
  '/admin/api/2020-01/customer_saved_searches/{customer_saved_search_id}.json': {
    get: {
      summary: 'Retrieves a single customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_customer_saved_searches_param_customer_saved_search_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_saved_search: {
                    id: 789629109;
                    name: 'This Name Has Been Changed';
                  };
                };
                summary: 'Update an existing customer saved search';
              };
            };
          };
        };
      };
      summary: 'Updates a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_customer_saved_searches_param_customer_saved_search_id';
    };
    delete: {
      summary: 'Deletes a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_customer_saved_searches_param_customer_saved_search_id';
    };
  };
  '/admin/api/2020-01/customer_saved_searches/{customer_saved_search_id}/customers.json': {
    get: {
      summary: 'Retrieves all customers returned by a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#other-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
        {
          in: 'query';
          name: 'order';
          description: 'Set the field and direction by which to order results.\n                  (default: last_order_date DESC)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_customer_saved_searches_param_customer_saved_search_id_customers';
    };
  };
  '/admin/api/2020-04/customer_saved_searches.json': {
    get: {
      summary: 'Retrieves a list of customer saved searches. Note: As of version 2019-07, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_customer_saved_searches';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_saved_search: {
                    name: 'Spent more than $50';
                    query: 'total_spent:>50';
                  };
                };
                summary: 'Create a customer saved search';
              };
              example2: {
                value: {
                  customer_saved_search: {
                    name: 'Spent more than $50 and after 2013';
                    query: 'total_spent:>50 order_date:>=2013-01-01';
                  };
                };
                summary: 'Create a customer saved search with multiple terms';
              };
              example3: {
                value: {
                  customer_saved_search: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a customer saved search without a name fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#create-2020-04';
      parameters: [];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_customer_saved_searches';
    };
  };
  '/admin/api/2020-04/customer_saved_searches/count.json': {
    get: {
      summary: 'Retrieves a count of all customer saved searches.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#count-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_customer_saved_searches_count';
    };
  };
  '/admin/api/2020-04/customer_saved_searches/{customer_saved_search_id}.json': {
    get: {
      summary: 'Retrieves a single customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_customer_saved_searches_param_customer_saved_search_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_saved_search: {
                    id: 789629109;
                    name: 'This Name Has Been Changed';
                  };
                };
                summary: 'Update an existing customer saved search';
              };
            };
          };
        };
      };
      summary: 'Updates a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_customer_saved_searches_param_customer_saved_search_id';
    };
    delete: {
      summary: 'Deletes a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_customer_saved_searches_param_customer_saved_search_id';
    };
  };
  '/admin/api/2020-04/customer_saved_searches/{customer_saved_search_id}/customers.json': {
    get: {
      summary: 'Retrieves all customers returned by a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#other-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
        {
          in: 'query';
          name: 'order';
          description: 'Set the field and direction by which to order results.\n                  (default: last_order_date DESC)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_customer_saved_searches_param_customer_saved_search_id_customers';
    };
  };
  '/admin/api/2020-07/customer_saved_searches.json': {
    get: {
      summary: 'Retrieves a list of customer saved searches. Note: As of version 2019-07, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_customer_saved_searches';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_saved_search: {
                    name: 'Spent more than $50';
                    query: 'total_spent:>50';
                  };
                };
                summary: 'Create a customer saved search';
              };
              example2: {
                value: {
                  customer_saved_search: {
                    name: 'Spent more than $50 and after 2013';
                    query: 'total_spent:>50 order_date:>=2013-01-01';
                  };
                };
                summary: 'Create a customer saved search with multiple terms';
              };
              example3: {
                value: {
                  customer_saved_search: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a customer saved search without a name fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#create-2020-07';
      parameters: [];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_customer_saved_searches';
    };
  };
  '/admin/api/2020-07/customer_saved_searches/count.json': {
    get: {
      summary: 'Retrieves a count of all customer saved searches.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#count-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_customer_saved_searches_count';
    };
  };
  '/admin/api/2020-07/customer_saved_searches/{customer_saved_search_id}.json': {
    get: {
      summary: 'Retrieves a single customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_customer_saved_searches_param_customer_saved_search_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_saved_search: {
                    id: 789629109;
                    name: 'This Name Has Been Changed';
                  };
                };
                summary: 'Update an existing customer saved search';
              };
            };
          };
        };
      };
      summary: 'Updates a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_customer_saved_searches_param_customer_saved_search_id';
    };
    delete: {
      summary: 'Deletes a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_customer_saved_searches_param_customer_saved_search_id';
    };
  };
  '/admin/api/2020-07/customer_saved_searches/{customer_saved_search_id}/customers.json': {
    get: {
      summary: 'Retrieves all customers returned by a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#other-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
        {
          in: 'query';
          name: 'order';
          description: 'Set the field and direction by which to order results.\n                  (default: last_order_date DESC)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_customer_saved_searches_param_customer_saved_search_id_customers';
    };
  };
  '/admin/api/2020-10/customer_saved_searches.json': {
    get: {
      summary: 'Retrieves a list of customer saved searches. Note: As of version 2019-07, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_customer_saved_searches';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_saved_search: {
                    name: 'Spent more than $50';
                    query: 'total_spent:>50';
                  };
                };
                summary: 'Create a customer saved search';
              };
              example2: {
                value: {
                  customer_saved_search: {
                    name: 'Spent more than $50 and after 2013';
                    query: 'total_spent:>50 order_date:>=2013-01-01';
                  };
                };
                summary: 'Create a customer saved search with multiple terms';
              };
              example3: {
                value: {
                  customer_saved_search: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a customer saved search without a name fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#create-2020-10';
      parameters: [];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_customer_saved_searches';
    };
  };
  '/admin/api/2020-10/customer_saved_searches/count.json': {
    get: {
      summary: 'Retrieves a count of all customer saved searches.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#count-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_customer_saved_searches_count';
    };
  };
  '/admin/api/2020-10/customer_saved_searches/{customer_saved_search_id}.json': {
    get: {
      summary: 'Retrieves a single customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_customer_saved_searches_param_customer_saved_search_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_saved_search: {
                    id: 789629109;
                    name: 'This Name Has Been Changed';
                  };
                };
                summary: 'Update an existing customer saved search';
              };
            };
          };
        };
      };
      summary: 'Updates a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#update-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_customer_saved_searches_param_customer_saved_search_id';
    };
    delete: {
      summary: 'Deletes a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_customer_saved_searches_param_customer_saved_search_id';
    };
  };
  '/admin/api/2020-10/customer_saved_searches/{customer_saved_search_id}/customers.json': {
    get: {
      summary: 'Retrieves all customers returned by a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#other-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
        {
          in: 'query';
          name: 'order';
          description: 'Set the field and direction by which to order results.\n                  (default: last_order_date DESC)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_customer_saved_searches_param_customer_saved_search_id_customers';
    };
  };
  '/admin/api/2021-01/customer_saved_searches.json': {
    get: {
      summary: 'Retrieves a list of customer saved searches. Note: As of version 2019-07, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_customer_saved_searches';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_saved_search: {
                    name: 'Spent more than $50';
                    query: 'total_spent:>50';
                  };
                };
                summary: 'Create a customer saved search';
              };
              example2: {
                value: {
                  customer_saved_search: {
                    name: 'Spent more than $50 and after 2013';
                    query: 'total_spent:>50 order_date:>=2013-01-01';
                  };
                };
                summary: 'Create a customer saved search with multiple terms';
              };
              example3: {
                value: {
                  customer_saved_search: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a customer saved search without a name fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#create-2021-01';
      parameters: [];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_customer_saved_searches';
    };
  };
  '/admin/api/2021-01/customer_saved_searches/count.json': {
    get: {
      summary: 'Retrieves a count of all customer saved searches.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#count-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_customer_saved_searches_count';
    };
  };
  '/admin/api/2021-01/customer_saved_searches/{customer_saved_search_id}.json': {
    get: {
      summary: 'Retrieves a single customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_customer_saved_searches_param_customer_saved_search_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_saved_search: {
                    id: 789629109;
                    name: 'This Name Has Been Changed';
                  };
                };
                summary: 'Update an existing customer saved search';
              };
            };
          };
        };
      };
      summary: 'Updates a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#update-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_customer_saved_searches_param_customer_saved_search_id';
    };
    delete: {
      summary: 'Deletes a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_customer_saved_searches_param_customer_saved_search_id';
    };
  };
  '/admin/api/2021-01/customer_saved_searches/{customer_saved_search_id}/customers.json': {
    get: {
      summary: 'Retrieves all customers returned by a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#other-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
        {
          in: 'query';
          name: 'order';
          description: 'Set the field and direction by which to order results.\n                  (default: last_order_date DESC)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_customer_saved_searches_param_customer_saved_search_id_customers';
    };
  };
  '/admin/api/unstable/customer_saved_searches.json': {
    get: {
      summary: 'Retrieves a list of customer saved searches. Note: As of version 2019-07, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_customer_saved_searches';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_saved_search: {
                    name: 'Spent more than $50';
                    query: 'total_spent:>50';
                  };
                };
                summary: 'Create a customer saved search';
              };
              example2: {
                value: {
                  customer_saved_search: {
                    name: 'Spent more than $50 and after 2013';
                    query: 'total_spent:>50 order_date:>=2013-01-01';
                  };
                };
                summary: 'Create a customer saved search with multiple terms';
              };
              example3: {
                value: {
                  customer_saved_search: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a customer saved search without a name fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#create-unstable';
      parameters: [];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_customer_saved_searches';
    };
  };
  '/admin/api/unstable/customer_saved_searches/count.json': {
    get: {
      summary: 'Retrieves a count of all customer saved searches.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#count-unstable';
      parameters: [
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_customer_saved_searches_count';
    };
  };
  '/admin/api/unstable/customer_saved_searches/{customer_saved_search_id}.json': {
    get: {
      summary: 'Retrieves a single customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_customer_saved_searches_param_customer_saved_search_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  customer_saved_search: {
                    id: 789629109;
                    name: 'This Name Has Been Changed';
                  };
                };
                summary: 'Update an existing customer saved search';
              };
            };
          };
        };
      };
      summary: 'Updates a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#update-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_customer_saved_searches_param_customer_saved_search_id';
    };
    delete: {
      summary: 'Deletes a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_customer_saved_searches_param_customer_saved_search_id';
    };
  };
  '/admin/api/unstable/customer_saved_searches/{customer_saved_search_id}/customers.json': {
    get: {
      summary: 'Retrieves all customers returned by a customer saved search.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/customers/customersavedsearch#other-unstable';
      parameters: [
        {
          in: 'path';
          name: 'customer_saved_search_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'customer_saved_search_id';
        },
        {
          in: 'query';
          name: 'order';
          description: 'Set the field and direction by which to order results.\n                  (default: last_order_date DESC)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['customers', 'customersavedsearch', 'customers/customersavedsearch'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_customer_saved_searches_param_customer_saved_search_id_customers';
    };
  };
  '/admin/api/2021-01/deprecated_api_calls.json': {
    get: {
      summary: 'Retrieves a list of deprecated API calls made by the authenticated private app in the past 30 days.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/deprecated_api_calls#index-2021-01';
      parameters: [];
      tags: ['deprecated_api_calls'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_deprecated_api_calls';
    };
  };
  '/admin/api/unstable/deprecated_api_calls.json': {
    get: {
      summary: 'Retrieves a list of deprecated API calls made by the authenticated private app in the past 30 days.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/deprecated_api_calls#index-unstable';
      parameters: [];
      tags: ['deprecated_api_calls'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_deprecated_api_calls';
    };
  };
  '/admin/api/2020-01/price_rules/{price_rule_id}/discount_codes.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_code: {
                    code: 'SUMMERSALE10OFF';
                  };
                };
                summary: 'Create a discount code';
              };
            };
          };
        };
      };
      summary: 'Creates a discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#create-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_price_rules_param_price_rule_id_discount_codes';
    };
    get: {
      summary: 'Retrieve a list of discount codes. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#index-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_price_rules_param_price_rule_id_discount_codes';
    };
  };
  '/admin/api/2020-01/price_rules/{price_rule_id}/discount_codes/{discount_code_id}.json': {
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_code: {
                    id: 507328175;
                    code: 'WINTERSALE20OFF';
                    usage_count: 0;
                    created_at: '2020-11-04T16:46:58-05:00';
                    updated_at: '2020-11-04T16:46:58-05:00';
                  };
                };
                summary: 'Update the code for a discount';
              };
            };
          };
        };
      };
      summary: 'Updates an existing discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
    get: {
      summary: 'Retrieves a single discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
    delete: {
      summary: 'Deletes a discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
  };
  '/admin/api/2020-01/discount_codes/lookup.json': {
    get: {
      summary: "Retrieves the location of a discount code.\n          The discount code's location is returned in the location header, not in the DiscountCode object itself.\n            Depending on your HTTP client, the location of the discount code might follow the location header automatically.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#lookup-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'code';
          schema: {
            type: 'integer';
          };
          description: 'code';
          required: false;
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_discount_codes_lookup';
    };
  };
  '/admin/api/2020-01/price_rules/{price_rule_id}/batch.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_codes: [
                    {
                      code: 'SUMMER1';
                    },
                    {
                      code: 'SUMMER2';
                    },
                    {
                      code: 'SUMMER3';
                    },
                  ];
                };
                summary: 'Create a discount code creation job';
              };
            };
          };
        };
      };
      summary: 'Creates a discount code creation job.\n          The batch endpoint can be used to asynchronously create up to 100 discount codes in a single request. It\n          enqueues and returns a discount_code_creation object that can be monitored for completion.\n          Response fields that are specific to the batch endpoint include:\n          \n            status: The state of the discount code creation job. Possible values are:\n              \n                queued: The job is acknowledged, but not started.\n                running: The job is in process.\n                completed: The job has finished.\n              \n            codes_count: The number of discount codes to create.\n            imported_count: The number of discount codes created successfully.\n            failed_count: The number of discount codes that were not created successfully. Unsuccessful attempts will retry up to three times.\n            logs: A report that specifies when no discount codes were created because the provided data was invalid. Example responses:\n              \n                "Price rule target selection can\'t be blank"\n                "Price rule allocation method can\'t be blank"';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_create-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_price_rules_param_price_rule_id_batch';
    };
  };
  '/admin/api/2020-01/price_rules/{price_rule_id}/batch/{batch_id}.json': {
    get: {
      summary: 'Retrieves a discount code creation job';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'batch_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'batch_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_price_rules_param_price_rule_id_batch_param_batch_id';
    };
  };
  '/admin/api/2020-01/price_rules/{price_rule_id}/batch/{batch_id}/discount_codes.json': {
    get: {
      summary: 'Retrieves a list of discount codes for a discount code creation job.\n          Discount codes that have been successfully created include a populated id field. Discount codes that\n          encountered errors during the creation process include a populated errors field.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_discount_codes_index-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'batch_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'batch_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_price_rules_param_price_rule_id_batch_param_batch_id_discount_codes';
    };
  };
  '/admin/api/2020-04/price_rules/{price_rule_id}/discount_codes.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_code: {
                    code: 'SUMMERSALE10OFF';
                  };
                };
                summary: 'Create a discount code';
              };
            };
          };
        };
      };
      summary: 'Creates a discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#create-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_price_rules_param_price_rule_id_discount_codes';
    };
    get: {
      summary: 'Retrieve a list of discount codes. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#index-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_price_rules_param_price_rule_id_discount_codes';
    };
  };
  '/admin/api/2020-04/price_rules/{price_rule_id}/discount_codes/{discount_code_id}.json': {
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_code: {
                    id: 507328175;
                    code: 'WINTERSALE20OFF';
                    usage_count: 0;
                    created_at: '2020-11-04T16:46:58-05:00';
                    updated_at: '2020-11-04T16:46:58-05:00';
                  };
                };
                summary: 'Update the code for a discount';
              };
            };
          };
        };
      };
      summary: 'Updates an existing discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
    get: {
      summary: 'Retrieves a single discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
    delete: {
      summary: 'Deletes a discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
  };
  '/admin/api/2020-04/discount_codes/lookup.json': {
    get: {
      summary: "Retrieves the location of a discount code.\n          The discount code's location is returned in the location header, not in the DiscountCode object itself.\n            Depending on your HTTP client, the location of the discount code might follow the location header automatically.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#lookup-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'code';
          schema: {
            type: 'integer';
          };
          description: 'code';
          required: false;
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_discount_codes_lookup';
    };
  };
  '/admin/api/2020-04/price_rules/{price_rule_id}/batch.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_codes: [
                    {
                      code: 'SUMMER1';
                    },
                    {
                      code: 'SUMMER2';
                    },
                    {
                      code: 'SUMMER3';
                    },
                  ];
                };
                summary: 'Create a discount code creation job';
              };
            };
          };
        };
      };
      summary: 'Creates a discount code creation job.\n          The batch endpoint can be used to asynchronously create up to 100 discount codes in a single request. It\n          enqueues and returns a discount_code_creation object that can be monitored for completion.\n          Response fields that are specific to the batch endpoint include:\n          \n            status: The state of the discount code creation job. Possible values are:\n              \n                queued: The job is acknowledged, but not started.\n                running: The job is in process.\n                completed: The job has finished.\n              \n            codes_count: The number of discount codes to create.\n            imported_count: The number of discount codes created successfully.\n            failed_count: The number of discount codes that were not created successfully. Unsuccessful attempts will retry up to three times.\n            logs: A report that specifies when no discount codes were created because the provided data was invalid. Example responses:\n              \n                "Price rule target selection can\'t be blank"\n                "Price rule allocation method can\'t be blank"';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_create-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_price_rules_param_price_rule_id_batch';
    };
  };
  '/admin/api/2020-04/price_rules/{price_rule_id}/batch/{batch_id}.json': {
    get: {
      summary: 'Retrieves a discount code creation job';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'batch_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'batch_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_price_rules_param_price_rule_id_batch_param_batch_id';
    };
  };
  '/admin/api/2020-04/price_rules/{price_rule_id}/batch/{batch_id}/discount_codes.json': {
    get: {
      summary: 'Retrieves a list of discount codes for a discount code creation job.\n          Discount codes that have been successfully created include a populated id field. Discount codes that\n          encountered errors during the creation process include a populated errors field.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_discount_codes_index-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'batch_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'batch_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_price_rules_param_price_rule_id_batch_param_batch_id_discount_codes';
    };
  };
  '/admin/api/2020-07/price_rules/{price_rule_id}/discount_codes.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_code: {
                    code: 'SUMMERSALE10OFF';
                  };
                };
                summary: 'Create a discount code';
              };
            };
          };
        };
      };
      summary: 'Creates a discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#create-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_price_rules_param_price_rule_id_discount_codes';
    };
    get: {
      summary: 'Retrieve a list of discount codes. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#index-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_price_rules_param_price_rule_id_discount_codes';
    };
  };
  '/admin/api/2020-07/price_rules/{price_rule_id}/discount_codes/{discount_code_id}.json': {
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_code: {
                    id: 507328175;
                    code: 'WINTERSALE20OFF';
                    usage_count: 0;
                    created_at: '2020-11-04T16:46:58-05:00';
                    updated_at: '2020-11-04T16:46:58-05:00';
                  };
                };
                summary: 'Update the code for a discount';
              };
            };
          };
        };
      };
      summary: 'Updates an existing discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
    get: {
      summary: 'Retrieves a single discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
    delete: {
      summary: 'Deletes a discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
  };
  '/admin/api/2020-07/discount_codes/lookup.json': {
    get: {
      summary: "Retrieves the location of a discount code.\n          The discount code's location is returned in the location header, not in the DiscountCode object itself.\n            Depending on your HTTP client, the location of the discount code might follow the location header automatically.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#lookup-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'code';
          schema: {
            type: 'integer';
          };
          description: 'code';
          required: false;
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_discount_codes_lookup';
    };
  };
  '/admin/api/2020-07/price_rules/{price_rule_id}/batch.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_codes: [
                    {
                      code: 'SUMMER1';
                    },
                    {
                      code: 'SUMMER2';
                    },
                    {
                      code: 'SUMMER3';
                    },
                  ];
                };
                summary: 'Create a discount code creation job';
              };
            };
          };
        };
      };
      summary: 'Creates a discount code creation job.\n          The batch endpoint can be used to asynchronously create up to 100 discount codes in a single request. It\n          enqueues and returns a discount_code_creation object that can be monitored for completion.\n          Response fields that are specific to the batch endpoint include:\n          \n            status: The state of the discount code creation job. Possible values are:\n              \n                queued: The job is acknowledged, but not started.\n                running: The job is in process.\n                completed: The job has finished.\n              \n            codes_count: The number of discount codes to create.\n            imported_count: The number of discount codes created successfully.\n            failed_count: The number of discount codes that were not created successfully. Unsuccessful attempts will retry up to three times.\n            logs: A report that specifies when no discount codes were created because the provided data was invalid. Example responses:\n              \n                "Price rule target selection can\'t be blank"\n                "Price rule allocation method can\'t be blank"';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_create-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_price_rules_param_price_rule_id_batch';
    };
  };
  '/admin/api/2020-07/price_rules/{price_rule_id}/batch/{batch_id}.json': {
    get: {
      summary: 'Retrieves a discount code creation job';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'batch_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'batch_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_price_rules_param_price_rule_id_batch_param_batch_id';
    };
  };
  '/admin/api/2020-07/price_rules/{price_rule_id}/batch/{batch_id}/discount_codes.json': {
    get: {
      summary: 'Retrieves a list of discount codes for a discount code creation job.\n          Discount codes that have been successfully created include a populated id field. Discount codes that\n          encountered errors during the creation process include a populated errors field.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_discount_codes_index-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'batch_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'batch_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_price_rules_param_price_rule_id_batch_param_batch_id_discount_codes';
    };
  };
  '/admin/api/2020-10/price_rules/{price_rule_id}/discount_codes.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_code: {
                    code: 'SUMMERSALE10OFF';
                  };
                };
                summary: 'Create a discount code';
              };
            };
          };
        };
      };
      summary: 'Creates a discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#create-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_price_rules_param_price_rule_id_discount_codes';
    };
    get: {
      summary: 'Retrieve a list of discount codes. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#index-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_price_rules_param_price_rule_id_discount_codes';
    };
  };
  '/admin/api/2020-10/price_rules/{price_rule_id}/discount_codes/{discount_code_id}.json': {
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_code: {
                    id: 507328175;
                    code: 'WINTERSALE20OFF';
                    usage_count: 0;
                    created_at: '2020-11-04T16:46:58-05:00';
                    updated_at: '2020-11-04T16:46:58-05:00';
                  };
                };
                summary: 'Update the code for a discount';
              };
            };
          };
        };
      };
      summary: 'Updates an existing discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#update-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
    get: {
      summary: 'Retrieves a single discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
    delete: {
      summary: 'Deletes a discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
  };
  '/admin/api/2020-10/discount_codes/lookup.json': {
    get: {
      summary: "Retrieves the location of a discount code.\n          The discount code's location is returned in the location header, not in the DiscountCode object itself.\n            Depending on your HTTP client, the location of the discount code might follow the location header automatically.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#lookup-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'code';
          schema: {
            type: 'integer';
          };
          description: 'code';
          required: false;
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_discount_codes_lookup';
    };
  };
  '/admin/api/2020-10/price_rules/{price_rule_id}/batch.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_codes: [
                    {
                      code: 'SUMMER1';
                    },
                    {
                      code: 'SUMMER2';
                    },
                    {
                      code: 'SUMMER3';
                    },
                  ];
                };
                summary: 'Create a discount code creation job';
              };
            };
          };
        };
      };
      summary: 'Creates a discount code creation job.\n          The batch endpoint can be used to asynchronously create up to 100 discount codes in a single request. It\n          enqueues and returns a discount_code_creation object that can be monitored for completion.\n          Response fields that are specific to the batch endpoint include:\n          \n            status: The state of the discount code creation job. Possible values are:\n              \n                queued: The job is acknowledged, but not started.\n                running: The job is in process.\n                completed: The job has finished.\n              \n            codes_count: The number of discount codes to create.\n            imported_count: The number of discount codes created successfully.\n            failed_count: The number of discount codes that were not created successfully. Unsuccessful attempts will retry up to three times.\n            logs: A report that specifies when no discount codes were created because the provided data was invalid. Example responses:\n              \n                "Price rule target selection can\'t be blank"\n                "Price rule allocation method can\'t be blank"';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_create-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_price_rules_param_price_rule_id_batch';
    };
  };
  '/admin/api/2020-10/price_rules/{price_rule_id}/batch/{batch_id}.json': {
    get: {
      summary: 'Retrieves a discount code creation job';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'batch_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'batch_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_price_rules_param_price_rule_id_batch_param_batch_id';
    };
  };
  '/admin/api/2020-10/price_rules/{price_rule_id}/batch/{batch_id}/discount_codes.json': {
    get: {
      summary: 'Retrieves a list of discount codes for a discount code creation job.\n          Discount codes that have been successfully created include a populated id field. Discount codes that\n          encountered errors during the creation process include a populated errors field.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_discount_codes_index-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'batch_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'batch_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_price_rules_param_price_rule_id_batch_param_batch_id_discount_codes';
    };
  };
  '/admin/api/2021-01/price_rules/{price_rule_id}/discount_codes.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_code: {
                    code: 'SUMMERSALE10OFF';
                  };
                };
                summary: 'Create a discount code';
              };
            };
          };
        };
      };
      summary: 'Creates a discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#create-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_price_rules_param_price_rule_id_discount_codes';
    };
    get: {
      summary: 'Retrieve a list of discount codes. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#index-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_price_rules_param_price_rule_id_discount_codes';
    };
  };
  '/admin/api/2021-01/price_rules/{price_rule_id}/discount_codes/{discount_code_id}.json': {
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_code: {
                    id: 507328175;
                    code: 'WINTERSALE20OFF';
                    usage_count: 0;
                    created_at: '2020-11-04T16:46:58-05:00';
                    updated_at: '2020-11-04T16:46:58-05:00';
                  };
                };
                summary: 'Update the code for a discount';
              };
            };
          };
        };
      };
      summary: 'Updates an existing discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#update-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
    get: {
      summary: 'Retrieves a single discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
    delete: {
      summary: 'Deletes a discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
  };
  '/admin/api/2021-01/discount_codes/lookup.json': {
    get: {
      summary: "Retrieves the location of a discount code.\n          The discount code's location is returned in the location header, not in the DiscountCode object itself.\n            Depending on your HTTP client, the location of the discount code might follow the location header automatically.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#lookup-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'code';
          schema: {
            type: 'integer';
          };
          description: 'code';
          required: false;
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_discount_codes_lookup';
    };
  };
  '/admin/api/2021-01/price_rules/{price_rule_id}/batch.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_codes: [
                    {
                      code: 'SUMMER1';
                    },
                    {
                      code: 'SUMMER2';
                    },
                    {
                      code: 'SUMMER3';
                    },
                  ];
                };
                summary: 'Create a discount code creation job';
              };
            };
          };
        };
      };
      summary: 'Creates a discount code creation job.\n          The batch endpoint can be used to asynchronously create up to 100 discount codes in a single request. It\n          enqueues and returns a discount_code_creation object that can be monitored for completion.\n          Response fields that are specific to the batch endpoint include:\n          \n            status: The state of the discount code creation job. Possible values are:\n              \n                queued: The job is acknowledged, but not started.\n                running: The job is in process.\n                completed: The job has finished.\n              \n            codes_count: The number of discount codes to create.\n            imported_count: The number of discount codes created successfully.\n            failed_count: The number of discount codes that were not created successfully. Unsuccessful attempts will retry up to three times.\n            logs: A report that specifies when no discount codes were created because the provided data was invalid. Example responses:\n              \n                "Price rule target selection can\'t be blank"\n                "Price rule allocation method can\'t be blank"';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_create-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_price_rules_param_price_rule_id_batch';
    };
  };
  '/admin/api/2021-01/price_rules/{price_rule_id}/batch/{batch_id}.json': {
    get: {
      summary: 'Retrieves a discount code creation job';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'batch_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'batch_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_price_rules_param_price_rule_id_batch_param_batch_id';
    };
  };
  '/admin/api/2021-01/price_rules/{price_rule_id}/batch/{batch_id}/discount_codes.json': {
    get: {
      summary: 'Retrieves a list of discount codes for a discount code creation job.\n          Discount codes that have been successfully created include a populated id field. Discount codes that\n          encountered errors during the creation process include a populated errors field.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_discount_codes_index-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'batch_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'batch_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_price_rules_param_price_rule_id_batch_param_batch_id_discount_codes';
    };
  };
  '/admin/api/unstable/price_rules/{price_rule_id}/discount_codes.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_code: {
                    code: 'SUMMERSALE10OFF';
                  };
                };
                summary: 'Create a discount code';
              };
            };
          };
        };
      };
      summary: 'Creates a discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#create-unstable';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_price_rules_param_price_rule_id_discount_codes';
    };
    get: {
      summary: 'Retrieve a list of discount codes. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#index-unstable';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_price_rules_param_price_rule_id_discount_codes';
    };
  };
  '/admin/api/unstable/price_rules/{price_rule_id}/discount_codes/{discount_code_id}.json': {
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_code: {
                    id: 507328175;
                    code: 'WINTERSALE20OFF';
                    usage_count: 0;
                    created_at: '2020-11-04T16:46:58-05:00';
                    updated_at: '2020-11-04T16:46:58-05:00';
                  };
                };
                summary: 'Update the code for a discount';
              };
            };
          };
        };
      };
      summary: 'Updates an existing discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#update-unstable';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
    get: {
      summary: 'Retrieves a single discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
    delete: {
      summary: 'Deletes a discount code';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'discount_code_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'discount_code_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_price_rules_param_price_rule_id_discount_codes_param_discount_code_id';
    };
  };
  '/admin/api/unstable/discount_codes/lookup.json': {
    get: {
      summary: "Retrieves the location of a discount code.\n          The discount code's location is returned in the location header, not in the DiscountCode object itself.\n            Depending on your HTTP client, the location of the discount code might follow the location header automatically.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#lookup-unstable';
      parameters: [
        {
          in: 'query';
          name: 'code';
          schema: {
            type: 'integer';
          };
          description: 'code';
          required: false;
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_discount_codes_lookup';
    };
  };
  '/admin/api/unstable/price_rules/{price_rule_id}/batch.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  discount_codes: [
                    {
                      code: 'SUMMER1';
                    },
                    {
                      code: 'SUMMER2';
                    },
                    {
                      code: 'SUMMER3';
                    },
                  ];
                };
                summary: 'Create a discount code creation job';
              };
            };
          };
        };
      };
      summary: 'Creates a discount code creation job.\n          The batch endpoint can be used to asynchronously create up to 100 discount codes in a single request. It\n          enqueues and returns a discount_code_creation object that can be monitored for completion.\n          Response fields that are specific to the batch endpoint include:\n          \n            status: The state of the discount code creation job. Possible values are:\n              \n                queued: The job is acknowledged, but not started.\n                running: The job is in process.\n                completed: The job has finished.\n              \n            codes_count: The number of discount codes to create.\n            imported_count: The number of discount codes created successfully.\n            failed_count: The number of discount codes that were not created successfully. Unsuccessful attempts will retry up to three times.\n            logs: A report that specifies when no discount codes were created because the provided data was invalid. Example responses:\n              \n                "Price rule target selection can\'t be blank"\n                "Price rule allocation method can\'t be blank"';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_create-unstable';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_price_rules_param_price_rule_id_batch';
    };
  };
  '/admin/api/unstable/price_rules/{price_rule_id}/batch/{batch_id}.json': {
    get: {
      summary: 'Retrieves a discount code creation job';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'batch_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'batch_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_price_rules_param_price_rule_id_batch_param_batch_id';
    };
  };
  '/admin/api/unstable/price_rules/{price_rule_id}/batch/{batch_id}/discount_codes.json': {
    get: {
      summary: 'Retrieves a list of discount codes for a discount code creation job.\n          Discount codes that have been successfully created include a populated id field. Discount codes that\n          encountered errors during the creation process include a populated errors field.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/discounts/discountcode#batch_discount_codes_index-unstable';
      parameters: [
        {
          in: 'path';
          name: 'price_rule_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'price_rule_id';
        },
        {
          in: 'path';
          name: 'batch_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'batch_id';
        },
      ];
      tags: ['discounts', 'discountcode', 'discounts/discountcode'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_price_rules_param_price_rule_id_batch_param_batch_id_discount_codes';
    };
  };
  '/admin/api/2020-01/events.json': {
    get: {
      summary: 'Retrieves a list of events. Note: As of version 2019-07, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Show only results after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show events created at or after this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show events created at or before this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'filter';
          description: 'Show events specified in this filter.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'verb';
          description: 'Show events of a certain type.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_events';
    };
  };
  '/admin/api/2020-01/events/{event_id}.json': {
    get: {
      summary: 'Retrieves a single event by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'event_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'event_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_events_param_event_id';
    };
  };
  '/admin/api/2020-01/events/count.json': {
    get: {
      summary: 'Retrieves a count of events';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#count-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count only events created at or after this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count only events created at or before this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_events_count';
    };
  };
  '/admin/api/2020-04/events.json': {
    get: {
      summary: 'Retrieves a list of events. Note: As of version 2019-07, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Show only results after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show events created at or after this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show events created at or before this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'filter';
          description: 'Show events specified in this filter.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'verb';
          description: 'Show events of a certain type.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_events';
    };
  };
  '/admin/api/2020-04/events/{event_id}.json': {
    get: {
      summary: 'Retrieves a single event by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'event_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'event_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_events_param_event_id';
    };
  };
  '/admin/api/2020-04/events/count.json': {
    get: {
      summary: 'Retrieves a count of events';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#count-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count only events created at or after this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count only events created at or before this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_events_count';
    };
  };
  '/admin/api/2020-07/events.json': {
    get: {
      summary: 'Retrieves a list of events. Note: As of version 2019-07, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Show only results after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show events created at or after this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show events created at or before this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'filter';
          description: 'Show events specified in this filter.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'verb';
          description: 'Show events of a certain type.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_events';
    };
  };
  '/admin/api/2020-07/events/{event_id}.json': {
    get: {
      summary: 'Retrieves a single event by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'event_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'event_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_events_param_event_id';
    };
  };
  '/admin/api/2020-07/events/count.json': {
    get: {
      summary: 'Retrieves a count of events';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#count-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count only events created at or after this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count only events created at or before this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_events_count';
    };
  };
  '/admin/api/2020-10/events.json': {
    get: {
      summary: 'Retrieves a list of events. Note: As of version 2019-07, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Show only results after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show events created at or after this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show events created at or before this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'filter';
          description: 'Show events specified in this filter.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'verb';
          description: 'Show events of a certain type.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_events';
    };
  };
  '/admin/api/2020-10/events/{event_id}.json': {
    get: {
      summary: 'Retrieves a single event by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'event_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'event_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_events_param_event_id';
    };
  };
  '/admin/api/2020-10/events/count.json': {
    get: {
      summary: 'Retrieves a count of events';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#count-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count only events created at or after this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count only events created at or before this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_events_count';
    };
  };
  '/admin/api/2021-01/events.json': {
    get: {
      summary: 'Retrieves a list of events. Note: As of version 2019-07, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Show only results after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show events created at or after this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show events created at or before this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'filter';
          description: 'Show events specified in this filter.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'verb';
          description: 'Show events of a certain type.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_events';
    };
  };
  '/admin/api/2021-01/events/{event_id}.json': {
    get: {
      summary: 'Retrieves a single event by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'event_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'event_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_events_param_event_id';
    };
  };
  '/admin/api/2021-01/events/count.json': {
    get: {
      summary: 'Retrieves a count of events';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#count-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count only events created at or after this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count only events created at or before this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_events_count';
    };
  };
  '/admin/api/unstable/events.json': {
    get: {
      summary: 'Retrieves a list of events. Note: As of version 2019-07, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Show only results after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show events created at or after this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show events created at or before this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'filter';
          description: 'Show events specified in this filter.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'verb';
          description: 'Show events of a certain type.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_events';
    };
  };
  '/admin/api/unstable/events/{event_id}.json': {
    get: {
      summary: 'Retrieves a single event by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'event_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'event_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_events_param_event_id';
    };
  };
  '/admin/api/unstable/events/count.json': {
    get: {
      summary: 'Retrieves a count of events';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/event#count-unstable';
      parameters: [
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count only events created at or after this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count only events created at or before this date and time. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'event', 'events/event'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_events_count';
    };
  };
  '/admin/api/2020-01/webhooks.json': {
    get: {
      summary: 'Retrieves a list of webhooks. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'address';
          description: 'Retrieve webhook subscriptions that send the POST request to this URI.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Retrieve webhook subscriptions that were created before a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Retrieve webhook subscriptions that were created after a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Comma-separated list of the properties you want returned for each item in the result list. Use this parameter to restrict the returned list of items to only those properties you specify.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'Maximum number of webhook subscriptions that should be returned. Setting this parameter outside the maximum range will return an error.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict the returned list to webhook subscriptions whose id is greater than the specified since_id.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'topic';
          description: 'Show webhook subscriptions with a given topic.\nFor a list of valid values, refer to the topic property.>';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Retrieve webhooks that were updated before a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Retrieve webhooks that were updated after a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_webhooks';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  webhook: {
                    topic: 'orders/create';
                    address: 'https://whatever.hostname.com/';
                    format: 'json';
                  };
                };
                summary: 'Subscribe to order creation webhooks';
              };
              example2: {
                value: {
                  webhook: {
                    body: 'foobar';
                  };
                };
                summary: 'Trying to create a webhook subscription without an address and topic will return a 422 - Unprocessable Entity error';
              };
            };
          };
        };
      };
      summary: 'Create a new webhook subscription by specifying both an address and a topic';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#create-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'format';
          description: 'Use this parameter to select the data format for the payload. Valid values are json and xml.\n                  (default: json)';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_webhooks';
    };
  };
  '/admin/api/2020-01/webhooks/count.json': {
    get: {
      summary: 'Retrieves a count of existing webhook subscriptions';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#count-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'address';
          description: 'Retrieve webhook subscriptions that send the POST request to this URI.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'topic';
          description: 'Show webhook subscriptions with a given topic.\nFor a list of valid values, refer to the topic property.>';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_webhooks_count';
    };
  };
  '/admin/api/2020-01/webhooks/{webhook_id}.json': {
    get: {
      summary: 'Retrieves a single webhook subscription';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Comma-separated list of the properties you want returned for each item in the result list. Use this parameter to restrict the returned list of items to only those properties you specify.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_webhooks_param_webhook_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  webhook: {
                    id: 4759306;
                    address: 'https://somewhere-else.com/';
                  };
                };
                summary: 'Update a webhook subscription so that it POSTs to a different address';
              };
            };
          };
        };
      };
      summary: "Update a webhook subscription's topic or address URIs";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_webhooks_param_webhook_id';
    };
    delete: {
      summary: 'Delete a webhook subscription';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_webhooks_param_webhook_id';
    };
  };
  '/admin/api/2020-04/webhooks.json': {
    get: {
      summary: 'Retrieves a list of webhooks. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'address';
          description: 'Retrieve webhook subscriptions that send the POST request to this URI.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Retrieve webhook subscriptions that were created before a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Retrieve webhook subscriptions that were created after a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Comma-separated list of the properties you want returned for each item in the result list. Use this parameter to restrict the returned list of items to only those properties you specify.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'Maximum number of webhook subscriptions that should be returned. Setting this parameter outside the maximum range will return an error.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict the returned list to webhook subscriptions whose id is greater than the specified since_id.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'topic';
          description: 'Show webhook subscriptions with a given topic.\nFor a list of valid values, refer to the topic property.>';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Retrieve webhooks that were updated before a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Retrieve webhooks that were updated after a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_webhooks';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  webhook: {
                    topic: 'orders/create';
                    address: 'https://whatever.hostname.com/';
                    format: 'json';
                  };
                };
                summary: 'Subscribe to order creation webhooks';
              };
              example2: {
                value: {
                  webhook: {
                    body: 'foobar';
                  };
                };
                summary: 'Trying to create a webhook subscription without an address and topic will return a 422 - Unprocessable Entity error';
              };
            };
          };
        };
      };
      summary: 'Create a new webhook subscription by specifying both an address and a topic';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#create-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'format';
          description: 'Use this parameter to select the data format for the payload. Valid values are json and xml.\n                  (default: json)';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_webhooks';
    };
  };
  '/admin/api/2020-04/webhooks/count.json': {
    get: {
      summary: 'Retrieves a count of existing webhook subscriptions';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#count-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'address';
          description: 'Retrieve webhook subscriptions that send the POST request to this URI.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'topic';
          description: 'Show webhook subscriptions with a given topic.\nFor a list of valid values, refer to the topic property.>';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_webhooks_count';
    };
  };
  '/admin/api/2020-04/webhooks/{webhook_id}.json': {
    get: {
      summary: 'Retrieves a single webhook subscription';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Comma-separated list of the properties you want returned for each item in the result list. Use this parameter to restrict the returned list of items to only those properties you specify.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_webhooks_param_webhook_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  webhook: {
                    id: 4759306;
                    address: 'https://somewhere-else.com/';
                  };
                };
                summary: 'Update a webhook subscription so that it POSTs to a different address';
              };
            };
          };
        };
      };
      summary: "Update a webhook subscription's topic or address URIs";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_webhooks_param_webhook_id';
    };
    delete: {
      summary: 'Delete a webhook subscription';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_webhooks_param_webhook_id';
    };
  };
  '/admin/api/2020-07/webhooks.json': {
    get: {
      summary: 'Retrieves a list of webhooks. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'address';
          description: 'Retrieve webhook subscriptions that send the POST request to this URI.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Retrieve webhook subscriptions that were created before a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Retrieve webhook subscriptions that were created after a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Comma-separated list of the properties you want returned for each item in the result list. Use this parameter to restrict the returned list of items to only those properties you specify.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'Maximum number of webhook subscriptions that should be returned. Setting this parameter outside the maximum range will return an error.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict the returned list to webhook subscriptions whose id is greater than the specified since_id.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'topic';
          description: 'Show webhook subscriptions with a given topic.\nFor a list of valid values, refer to the topic property.>';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Retrieve webhooks that were updated before a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Retrieve webhooks that were updated after a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_webhooks';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  webhook: {
                    topic: 'orders/create';
                    address: 'https://whatever.hostname.com/';
                    format: 'json';
                  };
                };
                summary: 'Subscribe to order creation webhooks';
              };
              example2: {
                value: {
                  webhook: {
                    body: 'foobar';
                  };
                };
                summary: 'Trying to create a webhook subscription without an address and topic will return a 422 - Unprocessable Entity error';
              };
            };
          };
        };
      };
      summary: 'Create a new webhook subscription by specifying both an address and a topic';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#create-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'format';
          description: 'Use this parameter to select the data format for the payload. Valid values are json and xml.\n                  (default: json)';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_webhooks';
    };
  };
  '/admin/api/2020-07/webhooks/count.json': {
    get: {
      summary: 'Retrieves a count of existing webhook subscriptions';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#count-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'address';
          description: 'Retrieve webhook subscriptions that send the POST request to this URI.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'topic';
          description: 'Show webhook subscriptions with a given topic.\nFor a list of valid values, refer to the topic property.>';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_webhooks_count';
    };
  };
  '/admin/api/2020-07/webhooks/{webhook_id}.json': {
    get: {
      summary: 'Retrieves a single webhook subscription';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Comma-separated list of the properties you want returned for each item in the result list. Use this parameter to restrict the returned list of items to only those properties you specify.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_webhooks_param_webhook_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  webhook: {
                    id: 4759306;
                    address: 'https://somewhere-else.com/';
                  };
                };
                summary: 'Update a webhook subscription so that it POSTs to a different address';
              };
            };
          };
        };
      };
      summary: "Update a webhook subscription's topic or address URIs";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_webhooks_param_webhook_id';
    };
    delete: {
      summary: 'Delete a webhook subscription';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_webhooks_param_webhook_id';
    };
  };
  '/admin/api/2020-10/webhooks.json': {
    get: {
      summary: 'Retrieves a list of webhooks. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'address';
          description: 'Retrieve webhook subscriptions that send the POST request to this URI.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Retrieve webhook subscriptions that were created before a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Retrieve webhook subscriptions that were created after a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Comma-separated list of the properties you want returned for each item in the result list. Use this parameter to restrict the returned list of items to only those properties you specify.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'Maximum number of webhook subscriptions that should be returned. Setting this parameter outside the maximum range will return an error.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict the returned list to webhook subscriptions whose id is greater than the specified since_id.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'topic';
          description: 'Show webhook subscriptions with a given topic.\nFor a list of valid values, refer to the topic property.>';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Retrieve webhooks that were updated before a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Retrieve webhooks that were updated after a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_webhooks';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  webhook: {
                    topic: 'orders/create';
                    address: 'https://whatever.hostname.com/';
                    format: 'json';
                  };
                };
                summary: 'Subscribe to order creation webhooks';
              };
              example2: {
                value: {
                  webhook: {
                    body: 'foobar';
                  };
                };
                summary: 'Trying to create a webhook subscription without an address and topic will return a 422 - Unprocessable Entity error';
              };
            };
          };
        };
      };
      summary: 'Create a new webhook subscription by specifying both an address and a topic';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#create-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'format';
          description: 'Use this parameter to select the data format for the payload. Valid values are json and xml.\n                  (default: json)';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_webhooks';
    };
  };
  '/admin/api/2020-10/webhooks/count.json': {
    get: {
      summary: 'Retrieves a count of existing webhook subscriptions';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#count-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'address';
          description: 'Retrieve webhook subscriptions that send the POST request to this URI.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'topic';
          description: 'Show webhook subscriptions with a given topic.\nFor a list of valid values, refer to the topic property.>';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_webhooks_count';
    };
  };
  '/admin/api/2020-10/webhooks/{webhook_id}.json': {
    get: {
      summary: 'Retrieves a single webhook subscription';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Comma-separated list of the properties you want returned for each item in the result list. Use this parameter to restrict the returned list of items to only those properties you specify.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_webhooks_param_webhook_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  webhook: {
                    id: 4759306;
                    address: 'https://somewhere-else.com/';
                  };
                };
                summary: 'Update a webhook subscription so that it POSTs to a different address';
              };
            };
          };
        };
      };
      summary: "Update a webhook subscription's topic or address URIs";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#update-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
      ];
      tags: ['events', 'webhook', 'events/webhook', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_webhooks_param_webhook_id';
    };
    delete: {
      summary: 'Delete a webhook subscription';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
      ];
      tags: ['events', 'webhook', 'events/webhook', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_webhooks_param_webhook_id';
    };
  };
  '/admin/api/2021-01/webhooks.json': {
    get: {
      summary: 'Retrieves a list of webhooks. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'address';
          description: 'Retrieve webhook subscriptions that send the POST request to this URI.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Retrieve webhook subscriptions that were created before a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Retrieve webhook subscriptions that were created after a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Comma-separated list of the properties you want returned for each item in the result list. Use this parameter to restrict the returned list of items to only those properties you specify.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'Maximum number of webhook subscriptions that should be returned. Setting this parameter outside the maximum range will return an error.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict the returned list to webhook subscriptions whose id is greater than the specified since_id.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'topic';
          description: 'Show webhook subscriptions with a given topic.\nFor a list of valid values, refer to the topic property.>';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Retrieve webhooks that were updated before a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Retrieve webhooks that were updated after a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_webhooks';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  webhook: {
                    topic: 'orders/create';
                    address: 'https://whatever.hostname.com/';
                    format: 'json';
                  };
                };
                summary: 'Subscribe to order creation webhooks';
              };
              example2: {
                value: {
                  webhook: {
                    body: 'foobar';
                  };
                };
                summary: 'Trying to create a webhook subscription without an address and topic will return a 422 - Unprocessable Entity error';
              };
            };
          };
        };
      };
      summary: 'Create a new webhook subscription by specifying both an address and a topic';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#create-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'format';
          description: 'Use this parameter to select the data format for the payload. Valid values are json and xml.\n                  (default: json)';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_webhooks';
    };
  };
  '/admin/api/2021-01/webhooks/count.json': {
    get: {
      summary: 'Retrieves a count of existing webhook subscriptions';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#count-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'address';
          description: 'Retrieve webhook subscriptions that send the POST request to this URI.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'topic';
          description: 'Show webhook subscriptions with a given topic.\nFor a list of valid values, refer to the topic property.>';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_webhooks_count';
    };
  };
  '/admin/api/2021-01/webhooks/{webhook_id}.json': {
    get: {
      summary: 'Retrieves a single webhook subscription';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Comma-separated list of the properties you want returned for each item in the result list. Use this parameter to restrict the returned list of items to only those properties you specify.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_webhooks_param_webhook_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  webhook: {
                    id: 4759306;
                    address: 'https://somewhere-else.com/';
                  };
                };
                summary: 'Update a webhook subscription so that it POSTs to a different address';
              };
            };
          };
        };
      };
      summary: "Update a webhook subscription's topic or address URIs";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#update-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_webhooks_param_webhook_id';
    };
    delete: {
      summary: 'Delete a webhook subscription';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_webhooks_param_webhook_id';
    };
  };
  '/admin/api/unstable/webhooks.json': {
    get: {
      summary: 'Retrieves a list of webhooks. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'address';
          description: 'Retrieve webhook subscriptions that send the POST request to this URI.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Retrieve webhook subscriptions that were created before a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Retrieve webhook subscriptions that were created after a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Comma-separated list of the properties you want returned for each item in the result list. Use this parameter to restrict the returned list of items to only those properties you specify.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'Maximum number of webhook subscriptions that should be returned. Setting this parameter outside the maximum range will return an error.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict the returned list to webhook subscriptions whose id is greater than the specified since_id.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'topic';
          description: 'Show webhook subscriptions with a given topic.\nFor a list of valid values, refer to the topic property.>';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Retrieve webhooks that were updated before a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Retrieve webhooks that were updated after a given date and time (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_webhooks';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  webhook: {
                    topic: 'orders/create';
                    address: 'https://whatever.hostname.com/';
                    format: 'json';
                  };
                };
                summary: 'Subscribe to order creation webhooks';
              };
              example2: {
                value: {
                  webhook: {
                    body: 'foobar';
                  };
                };
                summary: 'Trying to create a webhook subscription without an address and topic will return a 422 - Unprocessable Entity error';
              };
            };
          };
        };
      };
      summary: 'Create a new webhook subscription by specifying both an address and a topic';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#create-unstable';
      parameters: [
        {
          in: 'query';
          name: 'format';
          description: 'Use this parameter to select the data format for the payload. Valid values are json and xml.\n                  (default: json)';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_webhooks';
    };
  };
  '/admin/api/unstable/webhooks/count.json': {
    get: {
      summary: 'Retrieves a count of existing webhook subscriptions';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#count-unstable';
      parameters: [
        {
          in: 'query';
          name: 'address';
          description: 'Retrieve webhook subscriptions that send the POST request to this URI.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'topic';
          description: 'Show webhook subscriptions with a given topic.\nFor a list of valid values, refer to the topic property.>';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_webhooks_count';
    };
  };
  '/admin/api/unstable/webhooks/{webhook_id}.json': {
    get: {
      summary: 'Retrieves a single webhook subscription';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Comma-separated list of the properties you want returned for each item in the result list. Use this parameter to restrict the returned list of items to only those properties you specify.';
          schema: {};
          required: false;
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_webhooks_param_webhook_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  webhook: {
                    id: 4759306;
                    address: 'https://somewhere-else.com/';
                  };
                };
                summary: 'Update a webhook subscription so that it POSTs to a different address';
              };
            };
          };
        };
      };
      summary: "Update a webhook subscription's topic or address URIs";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#update-unstable';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_webhooks_param_webhook_id';
    };
    delete: {
      summary: 'Delete a webhook subscription';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/events/webhook#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'webhook_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'webhook_id';
        },
      ];
      tags: ['events', 'webhook', 'events/webhook'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_webhooks_param_webhook_id';
    };
  };
  '/admin/api/2020-01/inventory_items.json': {
    get: {
      summary: 'Retrieves a list of inventory items. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'ids\n                  required';
          description: 'Show only inventory items specified by a comma-separated list of IDs.\n                  (maximum: 100)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'ids';
          schema: {
            type: 'integer';
          };
          description: 'ids';
          required: false;
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_inventory_items';
    };
  };
  '/admin/api/2020-01/inventory_items/{inventory_item_id}.json': {
    get: {
      summary: 'Retrieves a single inventory item by ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'inventory_item_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'inventory_item_id';
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_inventory_items_param_inventory_item_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  inventory_item: {
                    id: 808950810;
                    sku: 'new sku';
                  };
                };
                summary: "Update an inventory item's SKU";
              };
              example2: {
                value: {
                  inventory_item: {
                    id: 808950810;
                    cost: '25.00';
                  };
                };
                summary: "Update an inventory item's unit cost";
              };
            };
          };
        };
      };
      summary: 'Updates an existing inventory item';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'inventory_item_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'inventory_item_id';
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_inventory_items_param_inventory_item_id';
    };
  };
  '/admin/api/2020-04/inventory_items.json': {
    get: {
      summary: 'Retrieves a list of inventory items. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'ids\n                  required';
          description: 'Show only inventory items specified by a comma-separated list of IDs.\n                  (maximum: 100)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'ids';
          schema: {
            type: 'integer';
          };
          description: 'ids';
          required: false;
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_inventory_items';
    };
  };
  '/admin/api/2020-04/inventory_items/{inventory_item_id}.json': {
    get: {
      summary: 'Retrieves a single inventory item by ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'inventory_item_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'inventory_item_id';
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_inventory_items_param_inventory_item_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  inventory_item: {
                    id: 808950810;
                    sku: 'new sku';
                  };
                };
                summary: "Update an inventory item's SKU";
              };
              example2: {
                value: {
                  inventory_item: {
                    id: 808950810;
                    cost: '25.00';
                  };
                };
                summary: "Update an inventory item's unit cost";
              };
            };
          };
        };
      };
      summary: 'Updates an existing inventory item';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'inventory_item_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'inventory_item_id';
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_inventory_items_param_inventory_item_id';
    };
  };
  '/admin/api/2020-07/inventory_items.json': {
    get: {
      summary: 'Retrieves a list of inventory items. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'ids\n                  required';
          description: 'Show only inventory items specified by a comma-separated list of IDs.\n                  (maximum: 100)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'ids';
          schema: {
            type: 'integer';
          };
          description: 'ids';
          required: false;
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_inventory_items';
    };
  };
  '/admin/api/2020-07/inventory_items/{inventory_item_id}.json': {
    get: {
      summary: 'Retrieves a single inventory item by ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'inventory_item_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'inventory_item_id';
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_inventory_items_param_inventory_item_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  inventory_item: {
                    id: 808950810;
                    sku: 'new sku';
                  };
                };
                summary: "Update an inventory item's SKU";
              };
              example2: {
                value: {
                  inventory_item: {
                    id: 808950810;
                    cost: '25.00';
                  };
                };
                summary: "Update an inventory item's unit cost";
              };
            };
          };
        };
      };
      summary: 'Updates an existing inventory item';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'inventory_item_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'inventory_item_id';
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_inventory_items_param_inventory_item_id';
    };
  };
  '/admin/api/2020-10/inventory_items.json': {
    get: {
      summary: 'Retrieves a list of inventory items. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'ids\n                  required';
          description: 'Show only inventory items specified by a comma-separated list of IDs.\n                  (maximum: 100)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'ids';
          schema: {
            type: 'integer';
          };
          description: 'ids';
          required: false;
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_inventory_items';
    };
  };
  '/admin/api/2020-10/inventory_items/{inventory_item_id}.json': {
    get: {
      summary: 'Retrieves a single inventory item by ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'inventory_item_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'inventory_item_id';
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_inventory_items_param_inventory_item_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  inventory_item: {
                    id: 808950810;
                    sku: 'new sku';
                  };
                };
                summary: "Update an inventory item's SKU";
              };
              example2: {
                value: {
                  inventory_item: {
                    id: 808950810;
                    cost: '25.00';
                  };
                };
                summary: "Update an inventory item's unit cost";
              };
            };
          };
        };
      };
      summary: 'Updates an existing inventory item';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#update-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'inventory_item_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'inventory_item_id';
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_inventory_items_param_inventory_item_id';
    };
  };
  '/admin/api/2021-01/inventory_items.json': {
    get: {
      summary: 'Retrieves a list of inventory items. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'ids\n                  required';
          description: 'Show only inventory items specified by a comma-separated list of IDs.\n                  (maximum: 100)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'ids';
          schema: {
            type: 'integer';
          };
          description: 'ids';
          required: false;
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_inventory_items';
    };
  };
  '/admin/api/2021-01/inventory_items/{inventory_item_id}.json': {
    get: {
      summary: 'Retrieves a single inventory item by ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'inventory_item_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'inventory_item_id';
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_inventory_items_param_inventory_item_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  inventory_item: {
                    id: 808950810;
                    sku: 'new sku';
                  };
                };
                summary: "Update an inventory item's SKU";
              };
              example2: {
                value: {
                  inventory_item: {
                    id: 808950810;
                    cost: '25.00';
                  };
                };
                summary: "Update an inventory item's unit cost";
              };
            };
          };
        };
      };
      summary: 'Updates an existing inventory item';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#update-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'inventory_item_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'inventory_item_id';
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_inventory_items_param_inventory_item_id';
    };
  };
  '/admin/api/unstable/inventory_items.json': {
    get: {
      summary: 'Retrieves a list of inventory items. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'ids\n                  required';
          description: 'Show only inventory items specified by a comma-separated list of IDs.\n                  (maximum: 100)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'ids';
          schema: {
            type: 'integer';
          };
          description: 'ids';
          required: false;
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_inventory_items';
    };
  };
  '/admin/api/unstable/inventory_items/{inventory_item_id}.json': {
    get: {
      summary: 'Retrieves a single inventory item by ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'inventory_item_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'inventory_item_id';
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_inventory_items_param_inventory_item_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  inventory_item: {
                    id: 808950810;
                    sku: 'new sku';
                  };
                };
                summary: "Update an inventory item's SKU";
              };
              example2: {
                value: {
                  inventory_item: {
                    id: 808950810;
                    cost: '25.00';
                  };
                };
                summary: "Update an inventory item's unit cost";
              };
            };
          };
        };
      };
      summary: 'Updates an existing inventory item';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventoryitem#update-unstable';
      parameters: [
        {
          in: 'path';
          name: 'inventory_item_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'inventory_item_id';
        },
      ];
      tags: ['inventory', 'inventoryitem', 'inventory/inventoryitem'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_inventory_items_param_inventory_item_id';
    };
  };
  '/admin/api/2020-01/inventory_levels.json': {
    get: {
      summary: 'Retrieves a list of inventory levels.\n          You must include inventory_item_ids, location_ids, or both as filter parameters.\n          Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_ids';
          description: 'A comma-separated list of inventory item IDs.\n                  (maximum: 50)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_ids';
          description: 'A comma-separated list of location IDs. To find the ID of a location, use the Location resource.\n                  (maximum: 50)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show inventory levels updated at or after date (format: 2019-03-19T01:21:44-04:00).';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_inventory_levels';
    };
    delete: {
      summary: 'Deletes an inventory level of an inventory item at a location.\n          Deleting an inventory level for an inventory item removes that item from the specified location.\n          Every inventory item must have at least one inventory level. To move inventory to another location,\n          first connect the inventory item to another location, and then delete the previous inventory level.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#destroy-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID for the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'inventory_item_id';
          schema: {
            type: 'integer';
          };
          description: 'inventory_item_id';
          required: false;
        },
        {
          in: 'query';
          name: 'location_id';
          schema: {
            type: 'integer';
          };
          description: 'location_id';
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_inventory_levels';
    };
  };
  '/admin/api/2020-01/inventory_levels/adjust.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjust the available quantity of an inventory item by 5 at a single location';
              };
              example2: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjusting inventory levels at a non-existent location fails and returns an error';
              };
              example3: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjusting inventory levels for an inventory item that is untracked fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Adjusts the inventory level of an inventory item at a single location';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#adjust-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID of the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'available_adjustment\n                  required';
          description: 'The amount to adjust the available inventory quantity. Send negative values to subtract from the current available quantity. For example, "available_adjustment": 2 increases the current available quantity by 2, and "available_adjustment": -3decreases the current available quantity by 3.';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_inventory_levels_adjust';
    };
  };
  '/admin/api/2020-01/inventory_levels/connect.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 192722535;
                  inventory_item_id: 457924702;
                };
                summary: 'Connect an inventory item to a location';
              };
              example2: {
                value: {
                  location_id: 123;
                  inventory_item_id: 457924702;
                };
                summary: 'Connecting an inventory item to a non-existent location fails and returns an error';
              };
              example3: {
                value: {
                  location_id: 48752903;
                  inventory_item_id: 808950810;
                };
                summary: 'Connecting an inventory item to a fulfillment service location without "relocate_if_necessary": true fails with a 422 error';
              };
              example4: {
                value: {
                  location_id: 192722535;
                  inventory_item_id: 457924702;
                };
                summary: "Connecting an inventory item to a location when the store hasn't enabled multiple locations fails with a 403 error";
              };
            };
          };
        };
      };
      summary: "Connects an inventory item to a location by creating an inventory level at that location.\n        When connecting inventory items to locations, it's important to understand the rules around\n        fulfillment service locations.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#connect-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID of the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'relocate_if_necessary';
          description: 'Whether inventory for any previously connected locations will be relocated. This property is ignored when no fulfillment service location is involved. For more information, see Inventory levels and fulfillment service locations.\n                  (default: false)';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_inventory_levels_connect';
    };
  };
  '/admin/api/2020-01/inventory_levels/set.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available: 42;
                };
                summary: 'Set the available inventory at a location';
              };
              example2: {
                value: {
                  location_id: 61629186;
                  inventory_item_id: 808950810;
                  available: 42;
                };
                summary: 'Setting an inventory item to a fulfillment service without "disconnect_if_necessary": true fails with a 422 error';
              };
            };
          };
        };
      };
      summary: "Sets the inventory level for an inventory item at a location.\n          If the specified location is not connected, it will be automatically connected first.\n          When connecting inventory items to locations, it's important to understand the rules around\n          fulfillment service locations.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#set-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID for the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'available\n                  required';
          description: 'Sets the available inventory quantity.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'disconnect_if_necessary';
          description: 'Whether inventory for any previously connected locations will be set to 0 and the locations disconnected. This property is ignored when no fulfillment service  is involved. For more information, see Inventory levels and fulfillment service locations.\n                  (default: false)';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_inventory_levels_set';
    };
  };
  '/admin/api/2020-04/inventory_levels.json': {
    get: {
      summary: 'Retrieves a list of inventory levels.\n          You must include inventory_item_ids, location_ids, or both as filter parameters.\n          Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_ids';
          description: 'A comma-separated list of inventory item IDs.\n                  (maximum: 50)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_ids';
          description: 'A comma-separated list of location IDs. To find the ID of a location, use the Location resource.\n                  (maximum: 50)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show inventory levels updated at or after date (format: 2019-03-19T01:21:44-04:00).';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_inventory_levels';
    };
    delete: {
      summary: 'Deletes an inventory level of an inventory item at a location.\n          Deleting an inventory level for an inventory item removes that item from the specified location.\n          Every inventory item must have at least one inventory level. To move inventory to another location,\n          first connect the inventory item to another location, and then delete the previous inventory level.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#destroy-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID for the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'inventory_item_id';
          schema: {
            type: 'integer';
          };
          description: 'inventory_item_id';
          required: false;
        },
        {
          in: 'query';
          name: 'location_id';
          schema: {
            type: 'integer';
          };
          description: 'location_id';
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_inventory_levels';
    };
  };
  '/admin/api/2020-04/inventory_levels/adjust.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjust the available quantity of an inventory item by 5 at a single location';
              };
              example2: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjusting inventory levels at a non-existent location fails and returns an error';
              };
              example3: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjusting inventory levels for an inventory item that is untracked fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Adjusts the inventory level of an inventory item at a single location';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#adjust-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID of the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'available_adjustment\n                  required';
          description: 'The amount to adjust the available inventory quantity. Send negative values to subtract from the current available quantity. For example, "available_adjustment": 2 increases the current available quantity by 2, and "available_adjustment": -3decreases the current available quantity by 3.';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_inventory_levels_adjust';
    };
  };
  '/admin/api/2020-04/inventory_levels/connect.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 192722535;
                  inventory_item_id: 457924702;
                };
                summary: 'Connect an inventory item to a location';
              };
              example2: {
                value: {
                  location_id: 123;
                  inventory_item_id: 457924702;
                };
                summary: 'Connecting an inventory item to a non-existent location fails and returns an error';
              };
              example3: {
                value: {
                  location_id: 48752903;
                  inventory_item_id: 808950810;
                };
                summary: 'Connecting an inventory item to a fulfillment service location without "relocate_if_necessary": true fails with a 422 error';
              };
              example4: {
                value: {
                  location_id: 192722535;
                  inventory_item_id: 457924702;
                };
                summary: "Connecting an inventory item to a location when the store hasn't enabled multiple locations fails with a 403 error";
              };
            };
          };
        };
      };
      summary: "Connects an inventory item to a location by creating an inventory level at that location.\n        When connecting inventory items to locations, it's important to understand the rules around\n        fulfillment service locations.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#connect-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID of the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'relocate_if_necessary';
          description: 'Whether inventory for any previously connected locations will be relocated. This property is ignored when no fulfillment service location is involved. For more information, see Inventory levels and fulfillment service locations.\n                  (default: false)';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_inventory_levels_connect';
    };
  };
  '/admin/api/2020-04/inventory_levels/set.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available: 42;
                };
                summary: 'Set the available inventory at a location';
              };
              example2: {
                value: {
                  location_id: 61629186;
                  inventory_item_id: 808950810;
                  available: 42;
                };
                summary: 'Setting an inventory item to a fulfillment service without "disconnect_if_necessary": true fails with a 422 error';
              };
            };
          };
        };
      };
      summary: "Sets the inventory level for an inventory item at a location.\n          If the specified location is not connected, it will be automatically connected first.\n          When connecting inventory items to locations, it's important to understand the rules around\n          fulfillment service locations.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#set-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID for the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'available\n                  required';
          description: 'Sets the available inventory quantity.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'disconnect_if_necessary';
          description: 'Whether inventory for any previously connected locations will be set to 0 and the locations disconnected. This property is ignored when no fulfillment service  is involved. For more information, see Inventory levels and fulfillment service locations.\n                  (default: false)';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_inventory_levels_set';
    };
  };
  '/admin/api/2020-07/inventory_levels.json': {
    get: {
      summary: 'Retrieves a list of inventory levels.\n          You must include inventory_item_ids, location_ids, or both as filter parameters.\n          Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_ids';
          description: 'A comma-separated list of inventory item IDs.\n                  (maximum: 50)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_ids';
          description: 'A comma-separated list of location IDs. To find the ID of a location, use the Location resource.\n                  (maximum: 50)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show inventory levels updated at or after date (format: 2019-03-19T01:21:44-04:00).';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_inventory_levels';
    };
    delete: {
      summary: 'Deletes an inventory level of an inventory item at a location.\n          Deleting an inventory level for an inventory item removes that item from the specified location.\n          Every inventory item must have at least one inventory level. To move inventory to another location,\n          first connect the inventory item to another location, and then delete the previous inventory level.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#destroy-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID for the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'inventory_item_id';
          schema: {
            type: 'integer';
          };
          description: 'inventory_item_id';
          required: false;
        },
        {
          in: 'query';
          name: 'location_id';
          schema: {
            type: 'integer';
          };
          description: 'location_id';
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_inventory_levels';
    };
  };
  '/admin/api/2020-07/inventory_levels/adjust.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjust the available quantity of an inventory item by 5 at a single location';
              };
              example2: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjusting inventory levels at a non-existent location fails and returns an error';
              };
              example3: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjusting inventory levels for an inventory item that is untracked fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Adjusts the inventory level of an inventory item at a single location';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#adjust-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID of the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'available_adjustment\n                  required';
          description: 'The amount to adjust the available inventory quantity. Send negative values to subtract from the current available quantity. For example, "available_adjustment": 2 increases the current available quantity by 2, and "available_adjustment": -3decreases the current available quantity by 3.';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_inventory_levels_adjust';
    };
  };
  '/admin/api/2020-07/inventory_levels/connect.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 192722535;
                  inventory_item_id: 457924702;
                };
                summary: 'Connect an inventory item to a location';
              };
              example2: {
                value: {
                  location_id: 123;
                  inventory_item_id: 457924702;
                };
                summary: 'Connecting an inventory item to a non-existent location fails and returns an error';
              };
              example3: {
                value: {
                  location_id: 48752903;
                  inventory_item_id: 808950810;
                };
                summary: 'Connecting an inventory item to a fulfillment service location without "relocate_if_necessary": true fails with a 422 error';
              };
              example4: {
                value: {
                  location_id: 192722535;
                  inventory_item_id: 457924702;
                };
                summary: "Connecting an inventory item to a location when the store hasn't enabled multiple locations fails with a 403 error";
              };
            };
          };
        };
      };
      summary: "Connects an inventory item to a location by creating an inventory level at that location.\n        When connecting inventory items to locations, it's important to understand the rules around\n        fulfillment service locations.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#connect-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID of the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'relocate_if_necessary';
          description: 'Whether inventory for any previously connected locations will be relocated. This property is ignored when no fulfillment service location is involved. For more information, see Inventory levels and fulfillment service locations.\n                  (default: false)';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_inventory_levels_connect';
    };
  };
  '/admin/api/2020-07/inventory_levels/set.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available: 42;
                };
                summary: 'Set the available inventory at a location';
              };
              example2: {
                value: {
                  location_id: 61629186;
                  inventory_item_id: 808950810;
                  available: 42;
                };
                summary: 'Setting an inventory item to a fulfillment service without "disconnect_if_necessary": true fails with a 422 error';
              };
            };
          };
        };
      };
      summary: "Sets the inventory level for an inventory item at a location.\n          If the specified location is not connected, it will be automatically connected first.\n          When connecting inventory items to locations, it's important to understand the rules around\n          fulfillment service locations.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#set-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID for the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'available\n                  required';
          description: 'Sets the available inventory quantity.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'disconnect_if_necessary';
          description: 'Whether inventory for any previously connected locations will be set to 0 and the locations disconnected. This property is ignored when no fulfillment service  is involved. For more information, see Inventory levels and fulfillment service locations.\n                  (default: false)';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_inventory_levels_set';
    };
  };
  '/admin/api/2020-10/inventory_levels.json': {
    get: {
      summary: 'Retrieves a list of inventory levels.\n          You must include inventory_item_ids, location_ids, or both as filter parameters.\n          Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_ids';
          description: 'A comma-separated list of inventory item IDs.\n                  (maximum: 50)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_ids';
          description: 'A comma-separated list of location IDs. To find the ID of a location, use the Location resource.\n                  (maximum: 50)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show inventory levels updated at or after date (format: 2019-03-19T01:21:44-04:00).';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_inventory_levels';
    };
    delete: {
      summary: 'Deletes an inventory level of an inventory item at a location.\n          Deleting an inventory level for an inventory item removes that item from the specified location.\n          Every inventory item must have at least one inventory level. To move inventory to another location,\n          first connect the inventory item to another location, and then delete the previous inventory level.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#destroy-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID for the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'inventory_item_id';
          schema: {
            type: 'integer';
          };
          description: 'inventory_item_id';
          required: false;
        },
        {
          in: 'query';
          name: 'location_id';
          schema: {
            type: 'integer';
          };
          description: 'location_id';
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_inventory_levels';
    };
  };
  '/admin/api/2020-10/inventory_levels/adjust.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjust the available quantity of an inventory item by 5 at a single location';
              };
              example2: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjusting inventory levels at a non-existent location fails and returns an error';
              };
              example3: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjusting inventory levels for an inventory item that is untracked fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Adjusts the inventory level of an inventory item at a single location';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#adjust-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID of the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'available_adjustment\n                  required';
          description: 'The amount to adjust the available inventory quantity. Send negative values to subtract from the current available quantity. For example, "available_adjustment": 2 increases the current available quantity by 2, and "available_adjustment": -3decreases the current available quantity by 3.';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_inventory_levels_adjust';
    };
  };
  '/admin/api/2020-10/inventory_levels/connect.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 192722535;
                  inventory_item_id: 457924702;
                };
                summary: 'Connect an inventory item to a location';
              };
              example2: {
                value: {
                  location_id: 123;
                  inventory_item_id: 457924702;
                };
                summary: 'Connecting an inventory item to a non-existent location fails and returns an error';
              };
              example3: {
                value: {
                  location_id: 48752903;
                  inventory_item_id: 808950810;
                };
                summary: 'Connecting an inventory item to a fulfillment service location without "relocate_if_necessary": true fails with a 422 error';
              };
              example4: {
                value: {
                  location_id: 192722535;
                  inventory_item_id: 457924702;
                };
                summary: "Connecting an inventory item to a location when the store hasn't enabled multiple locations fails with a 403 error";
              };
            };
          };
        };
      };
      summary: "Connects an inventory item to a location by creating an inventory level at that location.\n        When connecting inventory items to locations, it's important to understand the rules around\n        fulfillment service locations.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#connect-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID of the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'relocate_if_necessary';
          description: 'Whether inventory for any previously connected locations will be relocated. This property is ignored when no fulfillment service location is involved. For more information, see Inventory levels and fulfillment service locations.\n                  (default: false)';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_inventory_levels_connect';
    };
  };
  '/admin/api/2020-10/inventory_levels/set.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available: 42;
                };
                summary: 'Set the available inventory at a location';
              };
              example2: {
                value: {
                  location_id: 61629186;
                  inventory_item_id: 808950810;
                  available: 42;
                };
                summary: 'Setting an inventory item to a fulfillment service without "disconnect_if_necessary": true fails with a 422 error';
              };
            };
          };
        };
      };
      summary: "Sets the inventory level for an inventory item at a location.\n          If the specified location is not connected, it will be automatically connected first.\n          When connecting inventory items to locations, it's important to understand the rules around\n          fulfillment service locations.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#set-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID for the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'available\n                  required';
          description: 'Sets the available inventory quantity.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'disconnect_if_necessary';
          description: 'Whether inventory for any previously connected locations will be set to 0 and the locations disconnected. This property is ignored when no fulfillment service  is involved. For more information, see Inventory levels and fulfillment service locations.\n                  (default: false)';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_inventory_levels_set';
    };
  };
  '/admin/api/2021-01/inventory_levels.json': {
    get: {
      summary: 'Retrieves a list of inventory levels.\n          You must include inventory_item_ids, location_ids, or both as filter parameters.\n          Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_ids';
          description: 'A comma-separated list of inventory item IDs.\n                  (maximum: 50)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_ids';
          description: 'A comma-separated list of location IDs. To find the ID of a location, use the Location resource.\n                  (maximum: 50)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show inventory levels updated at or after date (format: 2019-03-19T01:21:44-04:00).';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_inventory_levels';
    };
    delete: {
      summary: 'Deletes an inventory level of an inventory item at a location.\n          Deleting an inventory level for an inventory item removes that item from the specified location.\n          Every inventory item must have at least one inventory level. To move inventory to another location,\n          first connect the inventory item to another location, and then delete the previous inventory level.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#destroy-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID for the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'inventory_item_id';
          schema: {
            type: 'integer';
          };
          description: 'inventory_item_id';
          required: false;
        },
        {
          in: 'query';
          name: 'location_id';
          schema: {
            type: 'integer';
          };
          description: 'location_id';
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_inventory_levels';
    };
  };
  '/admin/api/2021-01/inventory_levels/adjust.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjust the available quantity of an inventory item by 5 at a single location';
              };
              example2: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjusting inventory levels at a non-existent location fails and returns an error';
              };
              example3: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjusting inventory levels for an inventory item that is untracked fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Adjusts the inventory level of an inventory item at a single location';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#adjust-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID of the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'available_adjustment\n                  required';
          description: 'The amount to adjust the available inventory quantity. Send negative values to subtract from the current available quantity. For example, "available_adjustment": 2 increases the current available quantity by 2, and "available_adjustment": -3decreases the current available quantity by 3.';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_inventory_levels_adjust';
    };
  };
  '/admin/api/2021-01/inventory_levels/connect.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 192722535;
                  inventory_item_id: 457924702;
                };
                summary: 'Connect an inventory item to a location';
              };
              example2: {
                value: {
                  location_id: 123;
                  inventory_item_id: 457924702;
                };
                summary: 'Connecting an inventory item to a non-existent location fails and returns an error';
              };
              example3: {
                value: {
                  location_id: 48752903;
                  inventory_item_id: 808950810;
                };
                summary: 'Connecting an inventory item to a fulfillment service location without "relocate_if_necessary": true fails with a 422 error';
              };
              example4: {
                value: {
                  location_id: 192722535;
                  inventory_item_id: 457924702;
                };
                summary: "Connecting an inventory item to a location when the store hasn't enabled multiple locations fails with a 403 error";
              };
            };
          };
        };
      };
      summary: "Connects an inventory item to a location by creating an inventory level at that location.\n        When connecting inventory items to locations, it's important to understand the rules around\n        fulfillment service locations.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#connect-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID of the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'relocate_if_necessary';
          description: 'Whether inventory for any previously connected locations will be relocated. This property is ignored when no fulfillment service location is involved. For more information, see Inventory levels and fulfillment service locations.\n                  (default: false)';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_inventory_levels_connect';
    };
  };
  '/admin/api/2021-01/inventory_levels/set.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available: 42;
                };
                summary: 'Set the available inventory at a location';
              };
              example2: {
                value: {
                  location_id: 61629186;
                  inventory_item_id: 808950810;
                  available: 42;
                };
                summary: 'Setting an inventory item to a fulfillment service without "disconnect_if_necessary": true fails with a 422 error';
              };
            };
          };
        };
      };
      summary: "Sets the inventory level for an inventory item at a location.\n          If the specified location is not connected, it will be automatically connected first.\n          When connecting inventory items to locations, it's important to understand the rules around\n          fulfillment service locations.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#set-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID for the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'available\n                  required';
          description: 'Sets the available inventory quantity.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'disconnect_if_necessary';
          description: 'Whether inventory for any previously connected locations will be set to 0 and the locations disconnected. This property is ignored when no fulfillment service  is involved. For more information, see Inventory levels and fulfillment service locations.\n                  (default: false)';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_inventory_levels_set';
    };
  };
  '/admin/api/unstable/inventory_levels.json': {
    get: {
      summary: 'Retrieves a list of inventory levels.\n          You must include inventory_item_ids, location_ids, or both as filter parameters.\n          Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_ids';
          description: 'A comma-separated list of inventory item IDs.\n                  (maximum: 50)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_ids';
          description: 'A comma-separated list of location IDs. To find the ID of a location, use the Location resource.\n                  (maximum: 50)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show inventory levels updated at or after date (format: 2019-03-19T01:21:44-04:00).';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_inventory_levels';
    };
    delete: {
      summary: 'Deletes an inventory level of an inventory item at a location.\n          Deleting an inventory level for an inventory item removes that item from the specified location.\n          Every inventory item must have at least one inventory level. To move inventory to another location,\n          first connect the inventory item to another location, and then delete the previous inventory level.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#destroy-unstable';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID for the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'inventory_item_id';
          schema: {
            type: 'integer';
          };
          description: 'inventory_item_id';
          required: false;
        },
        {
          in: 'query';
          name: 'location_id';
          schema: {
            type: 'integer';
          };
          description: 'location_id';
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_inventory_levels';
    };
  };
  '/admin/api/unstable/inventory_levels/adjust.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjust the available quantity of an inventory item by 5 at a single location';
              };
              example2: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjusting inventory levels at a non-existent location fails and returns an error';
              };
              example3: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available_adjustment: 5;
                };
                summary: 'Adjusting inventory levels for an inventory item that is untracked fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Adjusts the inventory level of an inventory item at a single location';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#adjust-unstable';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID of the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'available_adjustment\n                  required';
          description: 'The amount to adjust the available inventory quantity. Send negative values to subtract from the current available quantity. For example, "available_adjustment": 2 increases the current available quantity by 2, and "available_adjustment": -3decreases the current available quantity by 3.';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_inventory_levels_adjust';
    };
  };
  '/admin/api/unstable/inventory_levels/connect.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 192722535;
                  inventory_item_id: 457924702;
                };
                summary: 'Connect an inventory item to a location';
              };
              example2: {
                value: {
                  location_id: 123;
                  inventory_item_id: 457924702;
                };
                summary: 'Connecting an inventory item to a non-existent location fails and returns an error';
              };
              example3: {
                value: {
                  location_id: 48752903;
                  inventory_item_id: 808950810;
                };
                summary: 'Connecting an inventory item to a fulfillment service location without "relocate_if_necessary": true fails with a 422 error';
              };
              example4: {
                value: {
                  location_id: 192722535;
                  inventory_item_id: 457924702;
                };
                summary: "Connecting an inventory item to a location when the store hasn't enabled multiple locations fails with a 403 error";
              };
            };
          };
        };
      };
      summary: "Connects an inventory item to a location by creating an inventory level at that location.\n        When connecting inventory items to locations, it's important to understand the rules around\n        fulfillment service locations.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#connect-unstable';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID of the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'relocate_if_necessary';
          description: 'Whether inventory for any previously connected locations will be relocated. This property is ignored when no fulfillment service location is involved. For more information, see Inventory levels and fulfillment service locations.\n                  (default: false)';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_inventory_levels_connect';
    };
  };
  '/admin/api/unstable/inventory_levels/set.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  location_id: 905684977;
                  inventory_item_id: 808950810;
                  available: 42;
                };
                summary: 'Set the available inventory at a location';
              };
              example2: {
                value: {
                  location_id: 61629186;
                  inventory_item_id: 808950810;
                  available: 42;
                };
                summary: 'Setting an inventory item to a fulfillment service without "disconnect_if_necessary": true fails with a 422 error';
              };
            };
          };
        };
      };
      summary: "Sets the inventory level for an inventory item at a location.\n          If the specified location is not connected, it will be automatically connected first.\n          When connecting inventory items to locations, it's important to understand the rules around\n          fulfillment service locations.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/inventorylevel#set-unstable';
      parameters: [
        {
          in: 'query';
          name: 'inventory_item_id\n                  required';
          description: 'The ID for the inventory item.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'location_id\n                  required';
          description: 'The ID of the location that the inventory level belongs to. To find the ID of the location, use the Location resource.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'available\n                  required';
          description: 'Sets the available inventory quantity.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'disconnect_if_necessary';
          description: 'Whether inventory for any previously connected locations will be set to 0 and the locations disconnected. This property is ignored when no fulfillment service  is involved. For more information, see Inventory levels and fulfillment service locations.\n                  (default: false)';
          schema: {};
          required: false;
        },
      ];
      tags: ['inventory', 'inventorylevel', 'inventory/inventorylevel'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_inventory_levels_set';
    };
  };
  '/admin/api/2020-01/locations.json': {
    get: {
      summary: 'Retrieves a list of locations';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#index-2020-01';
      parameters: [];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_locations';
    };
  };
  '/admin/api/2020-01/locations/{location_id}.json': {
    get: {
      summary: 'Retrieves a single location by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'location_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'location_id';
        },
      ];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_locations_param_location_id';
    };
  };
  '/admin/api/2020-01/locations/count.json': {
    get: {
      summary: 'Retrieves a count of locations';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#count-2020-01';
      parameters: [];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_locations_count';
    };
  };
  '/admin/api/2020-01/locations/{location_id}/inventory_levels.json': {
    get: {
      summary: 'Retrieves a list of inventory levels for a location. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#inventory_levels-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'location_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'location_id';
        },
      ];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_locations_param_location_id_inventory_levels';
    };
  };
  '/admin/api/2020-04/locations.json': {
    get: {
      summary: 'Retrieves a list of locations';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#index-2020-04';
      parameters: [];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_locations';
    };
  };
  '/admin/api/2020-04/locations/{location_id}.json': {
    get: {
      summary: 'Retrieves a single location by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'location_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'location_id';
        },
      ];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_locations_param_location_id';
    };
  };
  '/admin/api/2020-04/locations/count.json': {
    get: {
      summary: 'Retrieves a count of locations';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#count-2020-04';
      parameters: [];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_locations_count';
    };
  };
  '/admin/api/2020-04/locations/{location_id}/inventory_levels.json': {
    get: {
      summary: 'Retrieves a list of inventory levels for a location. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#inventory_levels-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'location_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'location_id';
        },
      ];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_locations_param_location_id_inventory_levels';
    };
  };
  '/admin/api/2020-07/locations.json': {
    get: {
      summary: 'Retrieves a list of locations';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#index-2020-07';
      parameters: [];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_locations';
    };
  };
  '/admin/api/2020-07/locations/{location_id}.json': {
    get: {
      summary: 'Retrieves a single location by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'location_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'location_id';
        },
      ];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_locations_param_location_id';
    };
  };
  '/admin/api/2020-07/locations/count.json': {
    get: {
      summary: 'Retrieves a count of locations';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#count-2020-07';
      parameters: [];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_locations_count';
    };
  };
  '/admin/api/2020-07/locations/{location_id}/inventory_levels.json': {
    get: {
      summary: 'Retrieves a list of inventory levels for a location. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#inventory_levels-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'location_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'location_id';
        },
      ];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_locations_param_location_id_inventory_levels';
    };
  };
  '/admin/api/2020-10/locations.json': {
    get: {
      summary: 'Retrieves a list of locations';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#index-2020-10';
      parameters: [];
      tags: ['inventory', 'location', 'inventory/location', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_locations';
    };
  };
  '/admin/api/2020-10/locations/{location_id}.json': {
    get: {
      summary: 'Retrieves a single location by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'location_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'location_id';
        },
      ];
      tags: ['inventory', 'location', 'inventory/location', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_locations_param_location_id';
    };
  };
  '/admin/api/2020-10/locations/count.json': {
    get: {
      summary: 'Retrieves a count of locations';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#count-2020-10';
      parameters: [];
      tags: ['inventory', 'location', 'inventory/location', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_locations_count';
    };
  };
  '/admin/api/2020-10/locations/{location_id}/inventory_levels.json': {
    get: {
      summary: 'Retrieves a list of inventory levels for a location. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#inventory_levels-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'location_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'location_id';
        },
      ];
      tags: ['inventory', 'location', 'inventory/location', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_locations_param_location_id_inventory_levels';
    };
  };
  '/admin/api/2021-01/locations.json': {
    get: {
      summary: 'Retrieves a list of locations';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#index-2021-01';
      parameters: [];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_locations';
    };
  };
  '/admin/api/2021-01/locations/{location_id}.json': {
    get: {
      summary: 'Retrieves a single location by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'location_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'location_id';
        },
      ];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_locations_param_location_id';
    };
  };
  '/admin/api/2021-01/locations/count.json': {
    get: {
      summary: 'Retrieves a count of locations';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#count-2021-01';
      parameters: [];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_locations_count';
    };
  };
  '/admin/api/2021-01/locations/{location_id}/inventory_levels.json': {
    get: {
      summary: 'Retrieves a list of inventory levels for a location. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#inventory_levels-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'location_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'location_id';
        },
      ];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_locations_param_location_id_inventory_levels';
    };
  };
  '/admin/api/unstable/locations.json': {
    get: {
      summary: 'Retrieves a list of locations';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#index-unstable';
      parameters: [];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_locations';
    };
  };
  '/admin/api/unstable/locations/{location_id}.json': {
    get: {
      summary: 'Retrieves a single location by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'location_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'location_id';
        },
      ];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_locations_param_location_id';
    };
  };
  '/admin/api/unstable/locations/count.json': {
    get: {
      summary: 'Retrieves a count of locations';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#count-unstable';
      parameters: [];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_locations_count';
    };
  };
  '/admin/api/unstable/locations/{location_id}/inventory_levels.json': {
    get: {
      summary: 'Retrieves a list of inventory levels for a location. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/inventory/location#inventory_levels-unstable';
      parameters: [
        {
          in: 'path';
          name: 'location_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'location_id';
        },
      ];
      tags: ['inventory', 'location', 'inventory/location'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_locations_param_location_id_inventory_levels';
    };
  };
  '/admin/api/2020-01/metafields.json': {
    get: {
      summary: 'Retrieves a list of metafields that belong to a Product Image resource.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'metafield[owner_id]';
          schema: {
            type: 'integer';
          };
          description: 'metafield[owner_id]';
          required: false;
        },
        {
          in: 'query';
          name: 'metafield[owner_resource]';
          schema: {
            type: 'string';
          };
          description: 'metafield[owner_resource]';
          required: false;
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_metafields';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  metafield: {
                    namespace: 'inventory';
                    key: 'warehouse';
                    value: 25;
                    value_type: 'integer';
                  };
                };
                summary: 'Create a new metafield for a Shop resource';
              };
              example2: {
                value: {
                  metafield: {
                    namespace: 'inventory';
                    key: 'warehouse';
                    value: 25;
                    value_type: 'integer';
                  };
                };
                summary: 'Create a new metafield for a Product resource';
              };
              example3: {
                value: {
                  metafield: {
                    key: null;
                  };
                };
                summary: 'Creating a metafield without a key will fail and return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a new metafield for a resource.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#create-2020-01';
      parameters: [];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_metafields';
    };
  };
  '/admin/api/2020-01/metafields/count.json': {
    get: {
      summary: "Retrieves a count of a resource's metafields.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#count-2020-01';
      parameters: [];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_metafields_count';
    };
  };
  '/admin/api/2020-01/metafields/{metafield_id}.json': {
    get: {
      summary: 'Retrieves a single metafield from a resource by its ID.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_metafields_param_metafield_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  metafield: {
                    id: 721389482;
                    value: 'something new';
                    value_type: 'string';
                  };
                };
                summary: "Update a metafield. The namespace and key of an existing metafield can't be changed.";
              };
              example2: {
                value: {
                  metafield: {
                    id: 845366454;
                    value: 'titre';
                    value_type: 'string';
                  };
                };
                summary: "Update a metafield. The namespace and key of an existing metafield can't be changed.";
              };
            };
          };
        };
      };
      summary: 'Updates a metafield.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_metafields_param_metafield_id';
    };
    delete: {
      summary: 'Deletes a metafield by its ID.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_metafields_param_metafield_id';
    };
  };
  '/admin/api/2020-04/metafields.json': {
    get: {
      summary: 'Retrieves a list of metafields that belong to a Product Image resource.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'metafield[owner_id]';
          schema: {
            type: 'integer';
          };
          description: 'metafield[owner_id]';
          required: false;
        },
        {
          in: 'query';
          name: 'metafield[owner_resource]';
          schema: {
            type: 'string';
          };
          description: 'metafield[owner_resource]';
          required: false;
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_metafields';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  metafield: {
                    namespace: 'inventory';
                    key: 'warehouse';
                    value: 25;
                    value_type: 'integer';
                  };
                };
                summary: 'Create a new metafield for a Shop resource';
              };
              example2: {
                value: {
                  metafield: {
                    namespace: 'inventory';
                    key: 'warehouse';
                    value: 25;
                    value_type: 'integer';
                  };
                };
                summary: 'Create a new metafield for a Product resource';
              };
              example3: {
                value: {
                  metafield: {
                    key: null;
                  };
                };
                summary: 'Creating a metafield without a key will fail and return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a new metafield for a resource.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#create-2020-04';
      parameters: [];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_metafields';
    };
  };
  '/admin/api/2020-04/metafields/count.json': {
    get: {
      summary: "Retrieves a count of a resource's metafields.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#count-2020-04';
      parameters: [];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_metafields_count';
    };
  };
  '/admin/api/2020-04/metafields/{metafield_id}.json': {
    get: {
      summary: 'Retrieves a single metafield from a resource by its ID.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_metafields_param_metafield_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  metafield: {
                    id: 721389482;
                    value: 'something new';
                    value_type: 'string';
                  };
                };
                summary: "Update a metafield. The namespace and key of an existing metafield can't be changed.";
              };
              example2: {
                value: {
                  metafield: {
                    id: 845366454;
                    value: 'titre';
                    value_type: 'string';
                  };
                };
                summary: "Update a metafield. The namespace and key of an existing metafield can't be changed.";
              };
            };
          };
        };
      };
      summary: 'Updates a metafield.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_metafields_param_metafield_id';
    };
    delete: {
      summary: 'Deletes a metafield by its ID.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_metafields_param_metafield_id';
    };
  };
  '/admin/api/2020-07/metafields.json': {
    get: {
      summary: 'Retrieves a list of metafields that belong to a Product Image resource.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'metafield[owner_id]';
          schema: {
            type: 'integer';
          };
          description: 'metafield[owner_id]';
          required: false;
        },
        {
          in: 'query';
          name: 'metafield[owner_resource]';
          schema: {
            type: 'string';
          };
          description: 'metafield[owner_resource]';
          required: false;
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_metafields';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  metafield: {
                    namespace: 'inventory';
                    key: 'warehouse';
                    value: 25;
                    value_type: 'integer';
                  };
                };
                summary: 'Create a new metafield for a Shop resource';
              };
              example2: {
                value: {
                  metafield: {
                    namespace: 'inventory';
                    key: 'warehouse';
                    value: 25;
                    value_type: 'integer';
                  };
                };
                summary: 'Create a new metafield for a Product resource';
              };
              example3: {
                value: {
                  metafield: {
                    key: null;
                  };
                };
                summary: 'Creating a metafield without a key will fail and return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a new metafield for a resource.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#create-2020-07';
      parameters: [];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_metafields';
    };
  };
  '/admin/api/2020-07/metafields/count.json': {
    get: {
      summary: "Retrieves a count of a resource's metafields.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#count-2020-07';
      parameters: [];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_metafields_count';
    };
  };
  '/admin/api/2020-07/metafields/{metafield_id}.json': {
    get: {
      summary: 'Retrieves a single metafield from a resource by its ID.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_metafields_param_metafield_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  metafield: {
                    id: 721389482;
                    value: 'something new';
                    value_type: 'string';
                  };
                };
                summary: "Update a metafield. The namespace and key of an existing metafield can't be changed.";
              };
              example2: {
                value: {
                  metafield: {
                    id: 845366454;
                    value: 'titre';
                    value_type: 'string';
                  };
                };
                summary: "Update a metafield. The namespace and key of an existing metafield can't be changed.";
              };
            };
          };
        };
      };
      summary: 'Updates a metafield.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_metafields_param_metafield_id';
    };
    delete: {
      summary: 'Deletes a metafield by its ID.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_metafields_param_metafield_id';
    };
  };
  '/admin/api/2020-10/metafields.json': {
    get: {
      summary: 'Retrieves a list of metafields that belong to a Product Image resource.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'metafield[owner_id]';
          schema: {
            type: 'integer';
          };
          description: 'metafield[owner_id]';
          required: false;
        },
        {
          in: 'query';
          name: 'metafield[owner_resource]';
          schema: {
            type: 'string';
          };
          description: 'metafield[owner_resource]';
          required: false;
        },
      ];
      tags: ['metafield', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_metafields';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  metafield: {
                    namespace: 'inventory';
                    key: 'warehouse';
                    value: 25;
                    value_type: 'integer';
                  };
                };
                summary: 'Create a new metafield for a Shop resource';
              };
              example2: {
                value: {
                  metafield: {
                    namespace: 'inventory';
                    key: 'warehouse';
                    value: 25;
                    value_type: 'integer';
                  };
                };
                summary: 'Create a new metafield for a Product resource';
              };
              example3: {
                value: {
                  metafield: {
                    key: null;
                  };
                };
                summary: 'Creating a metafield without a key will fail and return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a new metafield for a resource.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#create-2020-10';
      parameters: [];
      tags: ['metafield', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_metafields';
    };
  };
  '/admin/api/2020-10/metafields/count.json': {
    get: {
      summary: "Retrieves a count of a resource's metafields.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#count-2020-10';
      parameters: [];
      tags: ['metafield', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_metafields_count';
    };
  };
  '/admin/api/2020-10/metafields/{metafield_id}.json': {
    get: {
      summary: 'Retrieves a single metafield from a resource by its ID.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['metafield', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_metafields_param_metafield_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  metafield: {
                    id: 721389482;
                    value: 'something new';
                    value_type: 'string';
                  };
                };
                summary: "Update a metafield. The namespace and key of an existing metafield can't be changed.";
              };
              example2: {
                value: {
                  metafield: {
                    id: 845366454;
                    value: 'titre';
                    value_type: 'string';
                  };
                };
                summary: "Update a metafield. The namespace and key of an existing metafield can't be changed.";
              };
            };
          };
        };
      };
      summary: 'Updates a metafield.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#update-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
      ];
      tags: ['metafield', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_metafields_param_metafield_id';
    };
    delete: {
      summary: 'Deletes a metafield by its ID.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
      ];
      tags: ['metafield', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_metafields_param_metafield_id';
    };
  };
  '/admin/api/2021-01/metafields.json': {
    get: {
      summary: 'Retrieves a list of metafields that belong to a Product Image resource.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'metafield[owner_id]';
          schema: {
            type: 'integer';
          };
          description: 'metafield[owner_id]';
          required: false;
        },
        {
          in: 'query';
          name: 'metafield[owner_resource]';
          schema: {
            type: 'string';
          };
          description: 'metafield[owner_resource]';
          required: false;
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_metafields';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  metafield: {
                    namespace: 'inventory';
                    key: 'warehouse';
                    value: 25;
                    value_type: 'integer';
                  };
                };
                summary: 'Create a new metafield for a Shop resource';
              };
              example2: {
                value: {
                  metafield: {
                    namespace: 'inventory';
                    key: 'warehouse';
                    value: 25;
                    value_type: 'integer';
                  };
                };
                summary: 'Create a new metafield for a Product resource';
              };
              example3: {
                value: {
                  metafield: {
                    key: null;
                  };
                };
                summary: 'Creating a metafield without a key will fail and return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a new metafield for a resource.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#create-2021-01';
      parameters: [];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_metafields';
    };
  };
  '/admin/api/2021-01/metafields/count.json': {
    get: {
      summary: "Retrieves a count of a resource's metafields.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#count-2021-01';
      parameters: [];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_metafields_count';
    };
  };
  '/admin/api/2021-01/metafields/{metafield_id}.json': {
    get: {
      summary: 'Retrieves a single metafield from a resource by its ID.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_metafields_param_metafield_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  metafield: {
                    id: 721389482;
                    value: 'something new';
                    value_type: 'string';
                  };
                };
                summary: "Update a metafield. The namespace and key of an existing metafield can't be changed.";
              };
              example2: {
                value: {
                  metafield: {
                    id: 845366454;
                    value: 'titre';
                    value_type: 'string';
                  };
                };
                summary: "Update a metafield. The namespace and key of an existing metafield can't be changed.";
              };
            };
          };
        };
      };
      summary: 'Updates a metafield.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#update-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_metafields_param_metafield_id';
    };
    delete: {
      summary: 'Deletes a metafield by its ID.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_metafields_param_metafield_id';
    };
  };
  '/admin/api/unstable/metafields.json': {
    get: {
      summary: 'Retrieves a list of metafields that belong to a Product Image resource.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'metafield[owner_id]';
          schema: {
            type: 'integer';
          };
          description: 'metafield[owner_id]';
          required: false;
        },
        {
          in: 'query';
          name: 'metafield[owner_resource]';
          schema: {
            type: 'string';
          };
          description: 'metafield[owner_resource]';
          required: false;
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_metafields';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  metafield: {
                    namespace: 'inventory';
                    key: 'warehouse';
                    value: 25;
                    value_type: 'integer';
                  };
                };
                summary: 'Create a new metafield for a Shop resource';
              };
              example2: {
                value: {
                  metafield: {
                    namespace: 'inventory';
                    key: 'warehouse';
                    value: 25;
                    value_type: 'integer';
                  };
                };
                summary: 'Create a new metafield for a Product resource';
              };
              example3: {
                value: {
                  metafield: {
                    key: null;
                  };
                };
                summary: 'Creating a metafield without a key will fail and return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a new metafield for a resource.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#create-unstable';
      parameters: [];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_metafields';
    };
  };
  '/admin/api/unstable/metafields/count.json': {
    get: {
      summary: "Retrieves a count of a resource's metafields.";
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#count-unstable';
      parameters: [];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_metafields_count';
    };
  };
  '/admin/api/unstable/metafields/{metafield_id}.json': {
    get: {
      summary: 'Retrieves a single metafield from a resource by its ID.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_metafields_param_metafield_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  metafield: {
                    id: 721389482;
                    value: 'something new';
                    value_type: 'string';
                  };
                };
                summary: "Update a metafield. The namespace and key of an existing metafield can't be changed.";
              };
              example2: {
                value: {
                  metafield: {
                    id: 845366454;
                    value: 'titre';
                    value_type: 'string';
                  };
                };
                summary: "Update a metafield. The namespace and key of an existing metafield can't be changed.";
              };
            };
          };
        };
      };
      summary: 'Updates a metafield.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#update-unstable';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_metafields_param_metafield_id';
    };
    delete: {
      summary: 'Deletes a metafield by its ID.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/metafield#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'metafield_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'metafield_id';
        },
      ];
      tags: ['metafield'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_metafields_param_metafield_id';
    };
  };
  '/admin/api/2020-01/blogs/{blog_id}/articles.json': {
    get: {
      summary: 'Retrieves a list of all articles from a blog. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#index-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to retrieve.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show articles created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show articles created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show articles last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show articles last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Show articles published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Show articles published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Retrieve results based on their published status.\n                  (default: any)\n                    \n                        published: Show only published articles.\n                        unpublished: Show only unpublished articles.\n                        any: Show articles of any published status.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'handle';
          description: 'Retrieve an article with a specific handle.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'tag';
          description: 'Filter articles with a specific tag.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'author';
          description: 'Filter articles by article author.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_blogs_param_blog_id_articles';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                  };
                };
                summary: 'Create an article with HTML markup for a blog';
              };
              example2: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published: false;
                  };
                };
                summary: 'Create an unpublished article for a blog';
              };
              example3: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      attachment: 'R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\n';
                    };
                  };
                };
                summary: 'Create an article with a base64 encoded image';
              };
              example4: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      src: 'http://example.com/rails_logo.gif';
                      alt: 'Rails logo';
                    };
                  };
                };
                summary: 'Create an article with an image, which will be downloaded by Shopify';
              };
              example5: {
                value: {
                  article: {
                    body: 'something';
                  };
                };
                summary: 'Creating an article without a title fails and returns an error';
              };
              example6: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create an article with a metafield';
              };
            };
          };
        };
      };
      summary: 'Creates an article for a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#create-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_blogs_param_blog_id_articles';
    };
  };
  '/admin/api/2020-01/blogs/{blog_id}/articles/count.json': {
    get: {
      summary: 'Retrieves a count of all articles from a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#count-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count articles created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count articles created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Count articles last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Count articles last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Count articles published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Count articles published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Count articles with a given published status.\n                  (default: any)\n                    \n                        published: Count only published articles.\n                        unpublished: Count only unpublished articles.\n                        any: Count all articles.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_blogs_param_blog_id_articles_count';
    };
  };
  '/admin/api/2020-01/blogs/{blog_id}/articles/{article_id}.json': {
    get: {
      summary: 'Retrieves a single article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specifed by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_blogs_param_blog_id_articles_param_article_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                  };
                };
                summary: 'Update an existing article of a blog';
              };
              example2: {
                value: {
                  article: {
                    id: 134645308;
                    published: true;
                  };
                };
                summary: 'Publish a hidden article';
              };
              example3: {
                value: {
                  article: {
                    id: 134645308;
                    published: false;
                  };
                };
                summary: 'Hide a published article';
              };
              example4: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      attachment: 'R0lGODlhbgCMAPf/APbr48VySrxTO7IgKt2qmKQdJeK8lsFjROG5p/nz7Zg3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\n4qNe+bonfvCfVXvly1762beOOdLBd+Q7PCAAOw==\n';
                    };
                  };
                };
                summary: "Update an article's image";
              };
              example5: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      alt: 'Rails logo';
                    };
                  };
                };
                summary: 'Update the alt text for an article image';
              };
              example6: {
                value: {
                  article: {
                    id: 134645308;
                    image: '';
                  };
                };
                summary: 'Remove the image from an article';
              };
              example7: {
                value: {
                  article: {
                    id: 134645308;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add a metafield to an existing article';
              };
            };
          };
        };
      };
      summary: 'Updates an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_blogs_param_blog_id_articles_param_article_id';
    };
    delete: {
      summary: 'Deletes an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_blogs_param_blog_id_articles_param_article_id';
    };
  };
  '/admin/api/2020-01/articles/authors.json': {
    get: {
      summary: 'Retrieves a list all of article authors';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#authors-2020-01';
      parameters: [];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_articles_authors';
    };
  };
  '/admin/api/2020-01/articles/tags.json': {
    get: {
      summary: 'Retrieves a list of all the tags';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#tags-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of tags to retrieve.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'popular';
          description: 'A flag for ordering retrieved tags. If present in the request, then the results will be ordered by popularity, starting with the most popular tag.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_articles_tags';
    };
  };
  '/admin/api/2020-04/blogs/{blog_id}/articles.json': {
    get: {
      summary: 'Retrieves a list of all articles from a blog. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#index-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to retrieve.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show articles created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show articles created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show articles last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show articles last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Show articles published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Show articles published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Retrieve results based on their published status.\n                  (default: any)\n                    \n                        published: Show only published articles.\n                        unpublished: Show only unpublished articles.\n                        any: Show articles of any published status.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'handle';
          description: 'Retrieve an article with a specific handle.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'tag';
          description: 'Filter articles with a specific tag.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'author';
          description: 'Filter articles by article author.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_blogs_param_blog_id_articles';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                  };
                };
                summary: 'Create an article with HTML markup for a blog';
              };
              example2: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published: false;
                  };
                };
                summary: 'Create an unpublished article for a blog';
              };
              example3: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      attachment: 'R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\n';
                    };
                  };
                };
                summary: 'Create an article with a base64 encoded image';
              };
              example4: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      src: 'http://example.com/rails_logo.gif';
                      alt: 'Rails logo';
                    };
                  };
                };
                summary: 'Create an article with an image, which will be downloaded by Shopify';
              };
              example5: {
                value: {
                  article: {
                    body: 'something';
                  };
                };
                summary: 'Creating an article without a title fails and returns an error';
              };
              example6: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create an article with a metafield';
              };
            };
          };
        };
      };
      summary: 'Creates an article for a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#create-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_blogs_param_blog_id_articles';
    };
  };
  '/admin/api/2020-04/blogs/{blog_id}/articles/count.json': {
    get: {
      summary: 'Retrieves a count of all articles from a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#count-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count articles created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count articles created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Count articles last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Count articles last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Count articles published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Count articles published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Count articles with a given published status.\n                  (default: any)\n                    \n                        published: Count only published articles.\n                        unpublished: Count only unpublished articles.\n                        any: Count all articles.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_blogs_param_blog_id_articles_count';
    };
  };
  '/admin/api/2020-04/blogs/{blog_id}/articles/{article_id}.json': {
    get: {
      summary: 'Retrieves a single article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specifed by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_blogs_param_blog_id_articles_param_article_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                  };
                };
                summary: 'Update an existing article of a blog';
              };
              example2: {
                value: {
                  article: {
                    id: 134645308;
                    published: true;
                  };
                };
                summary: 'Publish a hidden article';
              };
              example3: {
                value: {
                  article: {
                    id: 134645308;
                    published: false;
                  };
                };
                summary: 'Hide a published article';
              };
              example4: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      attachment: 'R0lGODlhbgCMAPf/APbr48VySrxTO7IgKt2qmKQdJeK8lsFjROG5p/nz7Zg3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\n4qNe+bonfvCfVXvly1762beOOdLBd+Q7PCAAOw==\n';
                    };
                  };
                };
                summary: "Update an article's image";
              };
              example5: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      alt: 'Rails logo';
                    };
                  };
                };
                summary: 'Update the alt text for an article image';
              };
              example6: {
                value: {
                  article: {
                    id: 134645308;
                    image: '';
                  };
                };
                summary: 'Remove the image from an article';
              };
              example7: {
                value: {
                  article: {
                    id: 134645308;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add a metafield to an existing article';
              };
            };
          };
        };
      };
      summary: 'Updates an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_blogs_param_blog_id_articles_param_article_id';
    };
    delete: {
      summary: 'Deletes an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_blogs_param_blog_id_articles_param_article_id';
    };
  };
  '/admin/api/2020-04/articles/authors.json': {
    get: {
      summary: 'Retrieves a list all of article authors';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#authors-2020-04';
      parameters: [];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_articles_authors';
    };
  };
  '/admin/api/2020-04/articles/tags.json': {
    get: {
      summary: 'Retrieves a list of all the tags';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#tags-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of tags to retrieve.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'popular';
          description: 'A flag for ordering retrieved tags. If present in the request, then the results will be ordered by popularity, starting with the most popular tag.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_articles_tags';
    };
  };
  '/admin/api/2020-07/blogs/{blog_id}/articles.json': {
    get: {
      summary: 'Retrieves a list of all articles from a blog. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#index-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to retrieve.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show articles created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show articles created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show articles last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show articles last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Show articles published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Show articles published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Retrieve results based on their published status.\n                  (default: any)\n                    \n                        published: Show only published articles.\n                        unpublished: Show only unpublished articles.\n                        any: Show articles of any published status.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'handle';
          description: 'Retrieve an article with a specific handle.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'tag';
          description: 'Filter articles with a specific tag.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'author';
          description: 'Filter articles by article author.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_blogs_param_blog_id_articles';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                  };
                };
                summary: 'Create an article with HTML markup for a blog';
              };
              example2: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published: false;
                  };
                };
                summary: 'Create an unpublished article for a blog';
              };
              example3: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      attachment: 'R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\n';
                    };
                  };
                };
                summary: 'Create an article with a base64 encoded image';
              };
              example4: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      src: 'http://example.com/rails_logo.gif';
                      alt: 'Rails logo';
                    };
                  };
                };
                summary: 'Create an article with an image, which will be downloaded by Shopify';
              };
              example5: {
                value: {
                  article: {
                    body: 'something';
                  };
                };
                summary: 'Creating an article without a title fails and returns an error';
              };
              example6: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create an article with a metafield';
              };
            };
          };
        };
      };
      summary: 'Creates an article for a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#create-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_blogs_param_blog_id_articles';
    };
  };
  '/admin/api/2020-07/blogs/{blog_id}/articles/count.json': {
    get: {
      summary: 'Retrieves a count of all articles from a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#count-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count articles created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count articles created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Count articles last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Count articles last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Count articles published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Count articles published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Count articles with a given published status.\n                  (default: any)\n                    \n                        published: Count only published articles.\n                        unpublished: Count only unpublished articles.\n                        any: Count all articles.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_blogs_param_blog_id_articles_count';
    };
  };
  '/admin/api/2020-07/blogs/{blog_id}/articles/{article_id}.json': {
    get: {
      summary: 'Retrieves a single article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specifed by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_blogs_param_blog_id_articles_param_article_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                  };
                };
                summary: 'Update an existing article of a blog';
              };
              example2: {
                value: {
                  article: {
                    id: 134645308;
                    published: true;
                  };
                };
                summary: 'Publish a hidden article';
              };
              example3: {
                value: {
                  article: {
                    id: 134645308;
                    published: false;
                  };
                };
                summary: 'Hide a published article';
              };
              example4: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      attachment: 'R0lGODlhbgCMAPf/APbr48VySrxTO7IgKt2qmKQdJeK8lsFjROG5p/nz7Zg3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\n4qNe+bonfvCfVXvly1762beOOdLBd+Q7PCAAOw==\n';
                    };
                  };
                };
                summary: "Update an article's image";
              };
              example5: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      alt: 'Rails logo';
                    };
                  };
                };
                summary: 'Update the alt text for an article image';
              };
              example6: {
                value: {
                  article: {
                    id: 134645308;
                    image: '';
                  };
                };
                summary: 'Remove the image from an article';
              };
              example7: {
                value: {
                  article: {
                    id: 134645308;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add a metafield to an existing article';
              };
            };
          };
        };
      };
      summary: 'Updates an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_blogs_param_blog_id_articles_param_article_id';
    };
    delete: {
      summary: 'Deletes an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_blogs_param_blog_id_articles_param_article_id';
    };
  };
  '/admin/api/2020-07/articles/authors.json': {
    get: {
      summary: 'Retrieves a list all of article authors';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#authors-2020-07';
      parameters: [];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_articles_authors';
    };
  };
  '/admin/api/2020-07/articles/tags.json': {
    get: {
      summary: 'Retrieves a list of all the tags';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#tags-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of tags to retrieve.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'popular';
          description: 'A flag for ordering retrieved tags. If present in the request, then the results will be ordered by popularity, starting with the most popular tag.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_articles_tags';
    };
  };
  '/admin/api/2020-10/blogs/{blog_id}/articles.json': {
    get: {
      summary: 'Retrieves a list of all articles from a blog. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#index-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to retrieve.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show articles created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show articles created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show articles last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show articles last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Show articles published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Show articles published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Retrieve results based on their published status.\n                  (default: any)\n                    \n                        published: Show only published articles.\n                        unpublished: Show only unpublished articles.\n                        any: Show articles of any published status.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'handle';
          description: 'Retrieve an article with a specific handle.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'tag';
          description: 'Filter articles with a specific tag.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'author';
          description: 'Filter articles by article author.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_blogs_param_blog_id_articles';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                  };
                };
                summary: 'Create an article with HTML markup for a blog';
              };
              example2: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published: false;
                  };
                };
                summary: 'Create an unpublished article for a blog';
              };
              example3: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      attachment: 'R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\n';
                    };
                  };
                };
                summary: 'Create an article with a base64 encoded image';
              };
              example4: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      src: 'http://example.com/rails_logo.gif';
                      alt: 'Rails logo';
                    };
                  };
                };
                summary: 'Create an article with an image, which will be downloaded by Shopify';
              };
              example5: {
                value: {
                  article: {
                    body: 'something';
                  };
                };
                summary: 'Creating an article without a title fails and returns an error';
              };
              example6: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create an article with a metafield';
              };
            };
          };
        };
      };
      summary: 'Creates an article for a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#create-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_blogs_param_blog_id_articles';
    };
  };
  '/admin/api/2020-10/blogs/{blog_id}/articles/count.json': {
    get: {
      summary: 'Retrieves a count of all articles from a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#count-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count articles created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count articles created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Count articles last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Count articles last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Count articles published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Count articles published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Count articles with a given published status.\n                  (default: any)\n                    \n                        published: Count only published articles.\n                        unpublished: Count only unpublished articles.\n                        any: Count all articles.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_blogs_param_blog_id_articles_count';
    };
  };
  '/admin/api/2020-10/blogs/{blog_id}/articles/{article_id}.json': {
    get: {
      summary: 'Retrieves a single article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specifed by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_blogs_param_blog_id_articles_param_article_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                  };
                };
                summary: 'Update an existing article of a blog';
              };
              example2: {
                value: {
                  article: {
                    id: 134645308;
                    published: true;
                  };
                };
                summary: 'Publish a hidden article';
              };
              example3: {
                value: {
                  article: {
                    id: 134645308;
                    published: false;
                  };
                };
                summary: 'Hide a published article';
              };
              example4: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      attachment: 'R0lGODlhbgCMAPf/APbr48VySrxTO7IgKt2qmKQdJeK8lsFjROG5p/nz7Zg3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\n4qNe+bonfvCfVXvly1762beOOdLBd+Q7PCAAOw==\n';
                    };
                  };
                };
                summary: "Update an article's image";
              };
              example5: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      alt: 'Rails logo';
                    };
                  };
                };
                summary: 'Update the alt text for an article image';
              };
              example6: {
                value: {
                  article: {
                    id: 134645308;
                    image: '';
                  };
                };
                summary: 'Remove the image from an article';
              };
              example7: {
                value: {
                  article: {
                    id: 134645308;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add a metafield to an existing article';
              };
            };
          };
        };
      };
      summary: 'Updates an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#update-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_blogs_param_blog_id_articles_param_article_id';
    };
    delete: {
      summary: 'Deletes an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_blogs_param_blog_id_articles_param_article_id';
    };
  };
  '/admin/api/2020-10/articles/authors.json': {
    get: {
      summary: 'Retrieves a list all of article authors';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#authors-2020-10';
      parameters: [];
      tags: ['online-store', 'article', 'online-store/article', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_articles_authors';
    };
  };
  '/admin/api/2020-10/articles/tags.json': {
    get: {
      summary: 'Retrieves a list of all the tags';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#tags-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of tags to retrieve.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'popular';
          description: 'A flag for ordering retrieved tags. If present in the request, then the results will be ordered by popularity, starting with the most popular tag.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_articles_tags';
    };
  };
  '/admin/api/2021-01/blogs/{blog_id}/articles.json': {
    get: {
      summary: 'Retrieves a list of all articles from a blog. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#index-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to retrieve.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show articles created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show articles created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show articles last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show articles last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Show articles published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Show articles published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Retrieve results based on their published status.\n                  (default: any)\n                    \n                        published: Show only published articles.\n                        unpublished: Show only unpublished articles.\n                        any: Show articles of any published status.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'handle';
          description: 'Retrieve an article with a specific handle.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'tag';
          description: 'Filter articles with a specific tag.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'author';
          description: 'Filter articles by article author.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_blogs_param_blog_id_articles';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                  };
                };
                summary: 'Create an article with HTML markup for a blog';
              };
              example2: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published: false;
                  };
                };
                summary: 'Create an unpublished article for a blog';
              };
              example3: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      attachment: 'R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\n';
                    };
                  };
                };
                summary: 'Create an article with a base64 encoded image';
              };
              example4: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      src: 'http://example.com/rails_logo.gif';
                      alt: 'Rails logo';
                    };
                  };
                };
                summary: 'Create an article with an image, which will be downloaded by Shopify';
              };
              example5: {
                value: {
                  article: {
                    body: 'something';
                  };
                };
                summary: 'Creating an article without a title fails and returns an error';
              };
              example6: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create an article with a metafield';
              };
            };
          };
        };
      };
      summary: 'Creates an article for a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#create-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_blogs_param_blog_id_articles';
    };
  };
  '/admin/api/2021-01/blogs/{blog_id}/articles/count.json': {
    get: {
      summary: 'Retrieves a count of all articles from a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#count-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count articles created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count articles created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Count articles last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Count articles last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Count articles published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Count articles published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Count articles with a given published status.\n                  (default: any)\n                    \n                        published: Count only published articles.\n                        unpublished: Count only unpublished articles.\n                        any: Count all articles.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_blogs_param_blog_id_articles_count';
    };
  };
  '/admin/api/2021-01/blogs/{blog_id}/articles/{article_id}.json': {
    get: {
      summary: 'Retrieves a single article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specifed by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_blogs_param_blog_id_articles_param_article_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                  };
                };
                summary: 'Update an existing article of a blog';
              };
              example2: {
                value: {
                  article: {
                    id: 134645308;
                    published: true;
                  };
                };
                summary: 'Publish a hidden article';
              };
              example3: {
                value: {
                  article: {
                    id: 134645308;
                    published: false;
                  };
                };
                summary: 'Hide a published article';
              };
              example4: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      attachment: 'R0lGODlhbgCMAPf/APbr48VySrxTO7IgKt2qmKQdJeK8lsFjROG5p/nz7Zg3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\n4qNe+bonfvCfVXvly1762beOOdLBd+Q7PCAAOw==\n';
                    };
                  };
                };
                summary: "Update an article's image";
              };
              example5: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      alt: 'Rails logo';
                    };
                  };
                };
                summary: 'Update the alt text for an article image';
              };
              example6: {
                value: {
                  article: {
                    id: 134645308;
                    image: '';
                  };
                };
                summary: 'Remove the image from an article';
              };
              example7: {
                value: {
                  article: {
                    id: 134645308;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add a metafield to an existing article';
              };
            };
          };
        };
      };
      summary: 'Updates an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#update-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_blogs_param_blog_id_articles_param_article_id';
    };
    delete: {
      summary: 'Deletes an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_blogs_param_blog_id_articles_param_article_id';
    };
  };
  '/admin/api/2021-01/articles/authors.json': {
    get: {
      summary: 'Retrieves a list all of article authors';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#authors-2021-01';
      parameters: [];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_articles_authors';
    };
  };
  '/admin/api/2021-01/articles/tags.json': {
    get: {
      summary: 'Retrieves a list of all the tags';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#tags-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of tags to retrieve.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'popular';
          description: 'A flag for ordering retrieved tags. If present in the request, then the results will be ordered by popularity, starting with the most popular tag.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_articles_tags';
    };
  };
  '/admin/api/unstable/blogs/{blog_id}/articles.json': {
    get: {
      summary: 'Retrieves a list of all articles from a blog. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#index-unstable';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to retrieve.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show articles created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show articles created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show articles last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show articles last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Show articles published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Show articles published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Retrieve results based on their published status.\n                  (default: any)\n                    \n                        published: Show only published articles.\n                        unpublished: Show only unpublished articles.\n                        any: Show articles of any published status.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'handle';
          description: 'Retrieve an article with a specific handle.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'tag';
          description: 'Filter articles with a specific tag.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'author';
          description: 'Filter articles by article author.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_blogs_param_blog_id_articles';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                  };
                };
                summary: 'Create an article with HTML markup for a blog';
              };
              example2: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published: false;
                  };
                };
                summary: 'Create an unpublished article for a blog';
              };
              example3: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      attachment: 'R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\n';
                    };
                  };
                };
                summary: 'Create an article with a base64 encoded image';
              };
              example4: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      src: 'http://example.com/rails_logo.gif';
                      alt: 'Rails logo';
                    };
                  };
                };
                summary: 'Create an article with an image, which will be downloaded by Shopify';
              };
              example5: {
                value: {
                  article: {
                    body: 'something';
                  };
                };
                summary: 'Creating an article without a title fails and returns an error';
              };
              example6: {
                value: {
                  article: {
                    title: 'My new Article title';
                    author: 'John Smith';
                    tags: 'This Post, Has Been Tagged';
                    body_html: '<h1>I like articles</h1>\n<p><strong>Yea</strong>, I like posting them through <span class="caps">REST</span>.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create an article with a metafield';
              };
            };
          };
        };
      };
      summary: 'Creates an article for a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#create-unstable';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_blogs_param_blog_id_articles';
    };
  };
  '/admin/api/unstable/blogs/{blog_id}/articles/count.json': {
    get: {
      summary: 'Retrieves a count of all articles from a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#count-unstable';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count articles created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count articles created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Count articles last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Count articles last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Count articles published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Count articles published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Count articles with a given published status.\n                  (default: any)\n                    \n                        published: Count only published articles.\n                        unpublished: Count only unpublished articles.\n                        any: Count all articles.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_blogs_param_blog_id_articles_count';
    };
  };
  '/admin/api/unstable/blogs/{blog_id}/articles/{article_id}.json': {
    get: {
      summary: 'Retrieves a single article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specifed by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_blogs_param_blog_id_articles_param_article_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                  };
                };
                summary: 'Update an existing article of a blog';
              };
              example2: {
                value: {
                  article: {
                    id: 134645308;
                    published: true;
                  };
                };
                summary: 'Publish a hidden article';
              };
              example3: {
                value: {
                  article: {
                    id: 134645308;
                    published: false;
                  };
                };
                summary: 'Hide a published article';
              };
              example4: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      attachment: 'R0lGODlhbgCMAPf/APbr48VySrxTO7IgKt2qmKQdJeK8lsFjROG5p/nz7Zg3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\n4qNe+bonfvCfVXvly1762beOOdLBd+Q7PCAAOw==\n';
                    };
                  };
                };
                summary: "Update an article's image";
              };
              example5: {
                value: {
                  article: {
                    id: 134645308;
                    title: 'My new Title';
                    author: 'Your name';
                    tags: 'Tags, Will Be, Updated';
                    body_html: '<p>Look, I can even update through a web service.</p>';
                    published_at: 'Thu Mar 24 15:45:47 UTC 2011';
                    image: {
                      alt: 'Rails logo';
                    };
                  };
                };
                summary: 'Update the alt text for an article image';
              };
              example6: {
                value: {
                  article: {
                    id: 134645308;
                    image: '';
                  };
                };
                summary: 'Remove the image from an article';
              };
              example7: {
                value: {
                  article: {
                    id: 134645308;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add a metafield to an existing article';
              };
            };
          };
        };
      };
      summary: 'Updates an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#update-unstable';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_blogs_param_blog_id_articles_param_article_id';
    };
    delete: {
      summary: 'Deletes an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'path';
          name: 'article_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'article_id';
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_blogs_param_blog_id_articles_param_article_id';
    };
  };
  '/admin/api/unstable/articles/authors.json': {
    get: {
      summary: 'Retrieves a list all of article authors';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#authors-unstable';
      parameters: [];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_articles_authors';
    };
  };
  '/admin/api/unstable/articles/tags.json': {
    get: {
      summary: 'Retrieves a list of all the tags';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/article#tags-unstable';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of tags to retrieve.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'popular';
          description: 'A flag for ordering retrieved tags. If present in the request, then the results will be ordered by popularity, starting with the most popular tag.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'article', 'online-store/article'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_articles_tags';
    };
  };
  '/admin/api/2020-01/themes/{theme_id}/assets.json': {
    get: {
      summary: 'Retrieves a single asset for a theme by its key.\n          To retrieve a single asset, include asset[key]=#{asset_key} as a request parameter. For example, to retrieve the asset with a key of templates/index.liquid, the request might be /admin/themes/828155753/assets.json?asset[key]=templates/index.liquid.\n          For more information on the key property, see Asset properties.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'asset[key]';
          schema: {
            type: 'string';
          };
          description: 'asset[key]';
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_themes_param_theme_id_assets';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  asset: {
                    key: 'templates/index.liquid';
                    value: "<img src='backsoon-postit.png'><p>We are busy updating the store for you and will be back within the hour.</p>";
                  };
                };
                summary: "Change an existing Liquid template's value";
              };
              example2: {
                value: {
                  asset: {
                    key: 'assets/empty.gif';
                    attachment: 'R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==\n';
                  };
                };
                summary: 'Create an image asset by providing a base64-encoded attachment';
              };
              example3: {
                value: {
                  asset: {
                    key: 'assets/bg-body.gif';
                    src: 'http://apple.com/new_bg.gif';
                  };
                };
                summary: 'Create an image asset by providing a source URL from which to upload the image';
              };
              example4: {
                value: {
                  asset: {
                    key: 'layout/alternate.liquid';
                    source_key: 'layout/theme.liquid';
                  };
                };
                summary: 'Duplicate an existing asset by providing a source key';
              };
            };
          };
        };
      };
      summary: 'Creates or updates an asset for a theme.\n          In the PUT request, you can include the src or source_key property to create the asset from an existing file.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'src';
          description: 'The source URL of an image. Include in the body of the PUT request to upload the image to Shopify.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'source_key';
          description: 'The path within the theme to an existing asset. Include in the body of the PUT request to create a duplicate asset.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_themes_param_theme_id_assets';
    };
    delete: {
      summary: 'Deletes an asset from a theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'asset[key]';
          schema: {
            type: 'string';
          };
          description: 'asset[key]';
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_themes_param_theme_id_assets';
    };
  };
  '/admin/api/2020-04/themes/{theme_id}/assets.json': {
    get: {
      summary: 'Retrieves a single asset for a theme by its key.\n          To retrieve a single asset, include asset[key]=#{asset_key} as a request parameter. For example, to retrieve the asset with a key of templates/index.liquid, the request might be /admin/themes/828155753/assets.json?asset[key]=templates/index.liquid.\n          For more information on the key property, see Asset properties.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'asset[key]';
          schema: {
            type: 'string';
          };
          description: 'asset[key]';
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_themes_param_theme_id_assets';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  asset: {
                    key: 'templates/index.liquid';
                    value: "<img src='backsoon-postit.png'><p>We are busy updating the store for you and will be back within the hour.</p>";
                  };
                };
                summary: "Change an existing Liquid template's value";
              };
              example2: {
                value: {
                  asset: {
                    key: 'assets/empty.gif';
                    attachment: 'R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==\n';
                  };
                };
                summary: 'Create an image asset by providing a base64-encoded attachment';
              };
              example3: {
                value: {
                  asset: {
                    key: 'assets/bg-body.gif';
                    src: 'http://apple.com/new_bg.gif';
                  };
                };
                summary: 'Create an image asset by providing a source URL from which to upload the image';
              };
              example4: {
                value: {
                  asset: {
                    key: 'layout/alternate.liquid';
                    source_key: 'layout/theme.liquid';
                  };
                };
                summary: 'Duplicate an existing asset by providing a source key';
              };
            };
          };
        };
      };
      summary: 'Creates or updates an asset for a theme.\n          In the PUT request, you can include the src or source_key property to create the asset from an existing file.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'src';
          description: 'The source URL of an image. Include in the body of the PUT request to upload the image to Shopify.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'source_key';
          description: 'The path within the theme to an existing asset. Include in the body of the PUT request to create a duplicate asset.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_themes_param_theme_id_assets';
    };
    delete: {
      summary: 'Deletes an asset from a theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'asset[key]';
          schema: {
            type: 'string';
          };
          description: 'asset[key]';
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_themes_param_theme_id_assets';
    };
  };
  '/admin/api/2020-07/themes/{theme_id}/assets.json': {
    get: {
      summary: 'Retrieves a single asset for a theme by its key.\n          To retrieve a single asset, include asset[key]=#{asset_key} as a request parameter. For example, to retrieve the asset with a key of templates/index.liquid, the request might be /admin/themes/828155753/assets.json?asset[key]=templates/index.liquid.\n          For more information on the key property, see Asset properties.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'asset[key]';
          schema: {
            type: 'string';
          };
          description: 'asset[key]';
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_themes_param_theme_id_assets';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  asset: {
                    key: 'templates/index.liquid';
                    value: "<img src='backsoon-postit.png'><p>We are busy updating the store for you and will be back within the hour.</p>";
                  };
                };
                summary: "Change an existing Liquid template's value";
              };
              example2: {
                value: {
                  asset: {
                    key: 'assets/empty.gif';
                    attachment: 'R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==\n';
                  };
                };
                summary: 'Create an image asset by providing a base64-encoded attachment';
              };
              example3: {
                value: {
                  asset: {
                    key: 'assets/bg-body.gif';
                    src: 'http://apple.com/new_bg.gif';
                  };
                };
                summary: 'Create an image asset by providing a source URL from which to upload the image';
              };
              example4: {
                value: {
                  asset: {
                    key: 'layout/alternate.liquid';
                    source_key: 'layout/theme.liquid';
                  };
                };
                summary: 'Duplicate an existing asset by providing a source key';
              };
            };
          };
        };
      };
      summary: 'Creates or updates an asset for a theme.\n          In the PUT request, you can include the src or source_key property to create the asset from an existing file.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'src';
          description: 'The source URL of an image. Include in the body of the PUT request to upload the image to Shopify.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'source_key';
          description: 'The path within the theme to an existing asset. Include in the body of the PUT request to create a duplicate asset.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_themes_param_theme_id_assets';
    };
    delete: {
      summary: 'Deletes an asset from a theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'asset[key]';
          schema: {
            type: 'string';
          };
          description: 'asset[key]';
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_themes_param_theme_id_assets';
    };
  };
  '/admin/api/2020-10/themes/{theme_id}/assets.json': {
    get: {
      summary: 'Retrieves a single asset for a theme by its key.\n          To retrieve a single asset, include asset[key]=#{asset_key} as a request parameter. For example, to retrieve the asset with a key of templates/index.liquid, the request might be /admin/themes/828155753/assets.json?asset[key]=templates/index.liquid.\n          For more information on the key property, see Asset properties.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'asset[key]';
          schema: {
            type: 'string';
          };
          description: 'asset[key]';
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_themes_param_theme_id_assets';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  asset: {
                    key: 'templates/index.liquid';
                    value: "<img src='backsoon-postit.png'><p>We are busy updating the store for you and will be back within the hour.</p>";
                  };
                };
                summary: "Change an existing Liquid template's value";
              };
              example2: {
                value: {
                  asset: {
                    key: 'assets/empty.gif';
                    attachment: 'R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==\n';
                  };
                };
                summary: 'Create an image asset by providing a base64-encoded attachment';
              };
              example3: {
                value: {
                  asset: {
                    key: 'assets/bg-body.gif';
                    src: 'http://apple.com/new_bg.gif';
                  };
                };
                summary: 'Create an image asset by providing a source URL from which to upload the image';
              };
              example4: {
                value: {
                  asset: {
                    key: 'layout/alternate.liquid';
                    source_key: 'layout/theme.liquid';
                  };
                };
                summary: 'Duplicate an existing asset by providing a source key';
              };
            };
          };
        };
      };
      summary: 'Creates or updates an asset for a theme.\n          In the PUT request, you can include the src or source_key property to create the asset from an existing file.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#update-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'src';
          description: 'The source URL of an image. Include in the body of the PUT request to upload the image to Shopify.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'source_key';
          description: 'The path within the theme to an existing asset. Include in the body of the PUT request to create a duplicate asset.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_themes_param_theme_id_assets';
    };
    delete: {
      summary: 'Deletes an asset from a theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'asset[key]';
          schema: {
            type: 'string';
          };
          description: 'asset[key]';
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_themes_param_theme_id_assets';
    };
  };
  '/admin/api/2021-01/themes/{theme_id}/assets.json': {
    get: {
      summary: 'Retrieves a single asset for a theme by its key.\n          To retrieve a single asset, include asset[key]=#{asset_key} as a request parameter. For example, to retrieve the asset with a key of templates/index.liquid, the request might be /admin/themes/828155753/assets.json?asset[key]=templates/index.liquid.\n          For more information on the key property, see Asset properties.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'asset[key]';
          schema: {
            type: 'string';
          };
          description: 'asset[key]';
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_themes_param_theme_id_assets';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  asset: {
                    key: 'templates/index.liquid';
                    value: "<img src='backsoon-postit.png'><p>We are busy updating the store for you and will be back within the hour.</p>";
                  };
                };
                summary: "Change an existing Liquid template's value";
              };
              example2: {
                value: {
                  asset: {
                    key: 'assets/empty.gif';
                    attachment: 'R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==\n';
                  };
                };
                summary: 'Create an image asset by providing a base64-encoded attachment';
              };
              example3: {
                value: {
                  asset: {
                    key: 'assets/bg-body.gif';
                    src: 'http://apple.com/new_bg.gif';
                  };
                };
                summary: 'Create an image asset by providing a source URL from which to upload the image';
              };
              example4: {
                value: {
                  asset: {
                    key: 'layout/alternate.liquid';
                    source_key: 'layout/theme.liquid';
                  };
                };
                summary: 'Duplicate an existing asset by providing a source key';
              };
            };
          };
        };
      };
      summary: 'Creates or updates an asset for a theme.\n          In the PUT request, you can include the src or source_key property to create the asset from an existing file.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#update-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'src';
          description: 'The source URL of an image. Include in the body of the PUT request to upload the image to Shopify.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'source_key';
          description: 'The path within the theme to an existing asset. Include in the body of the PUT request to create a duplicate asset.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_themes_param_theme_id_assets';
    };
    delete: {
      summary: 'Deletes an asset from a theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'asset[key]';
          schema: {
            type: 'string';
          };
          description: 'asset[key]';
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_themes_param_theme_id_assets';
    };
  };
  '/admin/api/unstable/themes/{theme_id}/assets.json': {
    get: {
      summary: 'Retrieves a single asset for a theme by its key.\n          To retrieve a single asset, include asset[key]=#{asset_key} as a request parameter. For example, to retrieve the asset with a key of templates/index.liquid, the request might be /admin/themes/828155753/assets.json?asset[key]=templates/index.liquid.\n          For more information on the key property, see Asset properties.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'asset[key]';
          schema: {
            type: 'string';
          };
          description: 'asset[key]';
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_themes_param_theme_id_assets';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  asset: {
                    key: 'templates/index.liquid';
                    value: "<img src='backsoon-postit.png'><p>We are busy updating the store for you and will be back within the hour.</p>";
                  };
                };
                summary: "Change an existing Liquid template's value";
              };
              example2: {
                value: {
                  asset: {
                    key: 'assets/empty.gif';
                    attachment: 'R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==\n';
                  };
                };
                summary: 'Create an image asset by providing a base64-encoded attachment';
              };
              example3: {
                value: {
                  asset: {
                    key: 'assets/bg-body.gif';
                    src: 'http://apple.com/new_bg.gif';
                  };
                };
                summary: 'Create an image asset by providing a source URL from which to upload the image';
              };
              example4: {
                value: {
                  asset: {
                    key: 'layout/alternate.liquid';
                    source_key: 'layout/theme.liquid';
                  };
                };
                summary: 'Duplicate an existing asset by providing a source key';
              };
            };
          };
        };
      };
      summary: 'Creates or updates an asset for a theme.\n          In the PUT request, you can include the src or source_key property to create the asset from an existing file.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#update-unstable';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'src';
          description: 'The source URL of an image. Include in the body of the PUT request to upload the image to Shopify.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'source_key';
          description: 'The path within the theme to an existing asset. Include in the body of the PUT request to create a duplicate asset.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_themes_param_theme_id_assets';
    };
    delete: {
      summary: 'Deletes an asset from a theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/asset#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'asset[key]';
          schema: {
            type: 'string';
          };
          description: 'asset[key]';
          required: false;
        },
      ];
      tags: ['online-store', 'asset', 'online-store/asset'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_themes_param_theme_id_assets';
    };
  };
  '/admin/api/2020-01/blogs.json': {
    get: {
      summary: 'Retrieve a list of all blogs. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/blog#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to retrieve.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'handle';
          description: 'Filter by blog handle';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'comma-separated list of fields to include in the response';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'blog', 'online-store/blog'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_blogs';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  blog: {
                    title: 'Apple main blog';
                  };
                };
                summary: 'Create a new empty blog';
              };
              example2: {
                value: {
                  blog: {
                    body: 'foobar';
                  };
                };
                summary: 'Trying to create a blog without a title will return an error';
              };
              example3: {
                value: {
                  blog: {
                    title: 'Apple main blog';
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Create a new empty blog with a metafield';
              };
            };
          };
        };
      };
      summary: 'Create a new blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/blog#create-2020-01';
      parameters: [];
      tags: ['online-store', 'blog', 'online-store/blog'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_blogs';
    };
  };
  '/admin/api/2020-01/blogs/count.json': {
    get: {
      summary: 'Get a count of all blogs';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/blog#count-2020-01';
      parameters: [];
      tags: ['online-store', 'blog', 'online-store/blog'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_blogs_count';
    };
  };
  '/admin/api/2020-01/blogs/{blog_id}.json': {
    get: {
      summary: 'Get a single blog by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/blog#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'comma-separated list of fields to include in the response';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'blog', 'online-store/blog'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_blogs_param_blog_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  blog: {
                    id: 241253187;
                    title: 'IPod Updates';
                  };
                };
                summary: 'Update an existing blog title';
              };
              example2: {
                value: {
                  blog: {
                    id: 241253187;
                    title: 'IPod Updates';
                    handle: 'ipod-updates';
                    commentable: 'moderate';
                  };
                };
                summary: 'Update an existing blog title and handle and also activate comments';
              };
              example3: {
                value: {
                  blog: {
                    id: 241253187;
                    metafields: [
                      {
                        key: 'new';
                        value: 'newvalue';
                        value_type: 'string';
                        namespace: 'global';
                      },
                    ];
                  };
                };
                summary: 'Add a metafield to an existing blog';
              };
            };
          };
        };
      };
      summary: 'Update a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/blog#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
      ];
      tags: ['online-store', 'blog', 'online-store/blog'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_blogs_param_blog_id';
    };
    delete: {
      summary: 'Delete a blog';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/blog#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'blog_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'blog_id';
        },
      ];
      tags: ['online-store', 'blog', 'online-store/blog'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_blogs_param_blog_id';
    };
  };
  '/admin/api/2020-01/comments.json': {
    get: {
      summary: 'Retrieves a list of comments. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/comment#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to retrieve.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show comments created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show comments created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show comments last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show comments last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Show comments published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Show comments published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Filter results by their published status.\n                  (default: any)\n                    \n                        published: Show only published comments.\n                        unpublished: Show only unpublished comments.\n                        any: Show comments of any published status.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'status';
          description: 'Filter results by their status.\n                    \n                        pending: Show only pending comments.\n                        published: Show only published comments.\n                        unapproved: Show only unapproved comments.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'article_id';
          schema: {
            type: 'integer';
          };
          description: 'article_id';
          required: false;
        },
        {
          in: 'query';
          name: 'blog_id';
          schema: {
            type: 'integer';
          };
          description: 'blog_id';
          required: false;
        },
      ];
      tags: ['online-store', 'comment', 'online-store/comment'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_comments';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  comment: {
                    body: 'I like comments\nAnd I like posting them *RESTfully*.';
                    author: 'Your name';
                    email: 'your@email.com';
                    ip: '107.20.160.121';
                    blog_id: 241253187;
                    article_id: 134645308;
                  };
                };
                summary: 'Create a comment for an article of a blog using basic Textile markup';
              };
              example2: {
                value: {
                  comment: {
                    article_id: 134645308;
                  };
                };
                summary: 'Creating a comment without a body, author, and email fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a comment for an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/comment#create-2020-01';
      parameters: [];
      tags: ['online-store', 'comment', 'online-store/comment'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_comments';
    };
  };
  '/admin/api/2020-01/comments/count.json': {
    get: {
      summary: 'Retrieves a count of comments';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/comment#count-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Count comments created after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Count comments created before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Count comments last updated after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Count comments last updated before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_min';
          description: 'Count comments published after date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_at_max';
          description: 'Count comments published before date (format: 2014-04-25T16:15:47-04:00).';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'published_status';
          description: 'Retrieve a count of comments with a given published status.\n                  (default: any)\n                    \n                        published: Count only published comments.\n                        unpublished: Count only unpublished comments.\n                        any: Count comments of any published status.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'status';
          description: 'Retrieve a count of comments with a given status.\n                    \n                        pending: Count pending comments.\n                        published: Count published comments.\n                        unapproved: Count unapproved comments.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'article_id';
          schema: {
            type: 'integer';
          };
          description: 'article_id';
          required: false;
        },
        {
          in: 'query';
          name: 'blog_id';
          schema: {
            type: 'integer';
          };
          description: 'blog_id';
          required: false;
        },
      ];
      tags: ['online-store', 'comment', 'online-store/comment'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_comments_count';
    };
  };
  '/admin/api/2020-01/comments/{comment_id}.json': {
    get: {
      summary: 'Retrieves a single comment by its ID';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/comment#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'comment_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'comment_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'comment', 'online-store/comment'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_comments_param_comment_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  comment: {
                    id: 118373535;
                    body: 'You can even update through a web service.';
                    author: 'Your new name';
                    email: 'your@updated-email.com';
                    published_at: '2020-11-05T00:48:11.132Z';
                  };
                };
                summary: 'Update the body of an existing comment';
              };
            };
          };
        };
      };
      summary: 'Updates a comment of an article';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/comment#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'comment_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'comment_id';
        },
      ];
      tags: ['online-store', 'comment', 'online-store/comment'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_comments_param_comment_id';
    };
  };
  '/admin/api/2020-01/comments/{comment_id}/spam.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {};
                summary: 'Mark a comment as spam';
              };
            };
          };
        };
      };
      summary: 'Marks a comment as spam';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/comment#spam-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'comment_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'comment_id';
        },
      ];
      tags: ['online-store', 'comment', 'online-store/comment'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_comments_param_comment_id_spam';
    };
  };
  '/admin/api/2020-01/comments/{comment_id}/not_spam.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {};
                summary: 'Mark a comment as not spam, restoring it to an unapproved or published state';
              };
            };
          };
        };
      };
      summary: 'Marks a comment as not spam';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/comment#not_spam-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'comment_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'comment_id';
        },
      ];
      tags: ['online-store', 'comment', 'online-store/comment'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_comments_param_comment_id_not_spam';
    };
  };
  '/admin/api/2020-01/comments/{comment_id}/approve.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {};
                summary: 'Approve a comment and publish it to the blog';
              };
            };
          };
        };
      };
      summary: 'Approves a comment';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/comment#approve-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'comment_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'comment_id';
        },
      ];
      tags: ['online-store', 'comment', 'online-store/comment'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_comments_param_comment_id_approve';
    };
  };
  '/admin/api/2020-01/comments/{comment_id}/remove.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {};
                summary: 'Remove a comment';
              };
            };
          };
        };
      };
      summary: 'Removes a comment';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/comment#remove-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'comment_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'comment_id';
        },
      ];
      tags: ['online-store', 'comment', 'online-store/comment'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_comments_param_comment_id_remove';
    };
  };
  '/admin/api/2020-01/comments/{comment_id}/restore.json': {
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {};
                summary: 'Restore a removed comment';
              };
            };
          };
        };
      };
      summary: 'Restores a previously removed comment';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/comment#restore-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'comment_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'comment_id';
        },
      ];
      tags: ['online-store', 'comment', 'online-store/comment'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_comments_param_comment_id_restore';
    };
  };
  '/admin/api/2020-01/redirects.json': {
    get: {
      summary: 'Retrieves a list of URL redirects. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'path';
          description: 'Show redirects with a given path.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'target';
          description: 'Show redirects with a given target.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_redirects';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  redirect: {
                    path: '/ipod';
                    target: '/pages/itunes';
                  };
                };
                summary: 'Create a redirect';
              };
              example2: {
                value: {
                  redirect: {
                    path: 'http://www.apple.com/forums';
                    target: 'http://forums.apple.com';
                  };
                };
                summary: 'Create a redirect using a full URL for the path, which will be saved as an absolute path without a domain';
              };
              example3: {
                value: {
                  redirect: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a redirect without a path or target fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a redirect. When you provide a full URL as the value of the path property, it will be saved as an absolute path without the domain.\n          For example, "path": "http://www.johns-apparel.com/springwear" will be saved as "path": "springwear".';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#create-2020-01';
      parameters: [];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_redirects';
    };
  };
  '/admin/api/2020-01/redirects/count.json': {
    get: {
      summary: 'Retrieves a count of URL redirects';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#count-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'path';
          description: 'Count redirects with given path.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'target';
          description: 'Count redirects with given target.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_redirects_count';
    };
  };
  '/admin/api/2020-01/redirects/{redirect_id}.json': {
    get: {
      summary: 'Retrieves a single redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_redirects_param_redirect_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  redirect: {
                    id: 668809255;
                    path: '/tiger';
                  };
                };
                summary: 'Update the path URI of a redirect';
              };
              example2: {
                value: {
                  redirect: {
                    id: 950115854;
                    path: '/powermac';
                    target: '/pages/macpro';
                  };
                };
                summary: 'Update both the path and target URIs of a redirect';
              };
            };
          };
        };
      };
      summary: 'Updates an existing redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_redirects_param_redirect_id';
    };
    delete: {
      summary: 'Deletes a redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_redirects_param_redirect_id';
    };
  };
  '/admin/api/2020-04/redirects.json': {
    get: {
      summary: 'Retrieves a list of URL redirects. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'path';
          description: 'Show redirects with a given path.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'target';
          description: 'Show redirects with a given target.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_redirects';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  redirect: {
                    path: '/ipod';
                    target: '/pages/itunes';
                  };
                };
                summary: 'Create a redirect';
              };
              example2: {
                value: {
                  redirect: {
                    path: 'http://www.apple.com/forums';
                    target: 'http://forums.apple.com';
                  };
                };
                summary: 'Create a redirect using a full URL for the path, which will be saved as an absolute path without a domain';
              };
              example3: {
                value: {
                  redirect: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a redirect without a path or target fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a redirect. When you provide a full URL as the value of the path property, it will be saved as an absolute path without the domain.\n          For example, "path": "http://www.johns-apparel.com/springwear" will be saved as "path": "springwear".';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#create-2020-04';
      parameters: [];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_redirects';
    };
  };
  '/admin/api/2020-04/redirects/count.json': {
    get: {
      summary: 'Retrieves a count of URL redirects';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#count-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'path';
          description: 'Count redirects with given path.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'target';
          description: 'Count redirects with given target.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_redirects_count';
    };
  };
  '/admin/api/2020-04/redirects/{redirect_id}.json': {
    get: {
      summary: 'Retrieves a single redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_redirects_param_redirect_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  redirect: {
                    id: 668809255;
                    path: '/tiger';
                  };
                };
                summary: 'Update the path URI of a redirect';
              };
              example2: {
                value: {
                  redirect: {
                    id: 950115854;
                    path: '/powermac';
                    target: '/pages/macpro';
                  };
                };
                summary: 'Update both the path and target URIs of a redirect';
              };
            };
          };
        };
      };
      summary: 'Updates an existing redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_redirects_param_redirect_id';
    };
    delete: {
      summary: 'Deletes a redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_redirects_param_redirect_id';
    };
  };
  '/admin/api/2020-07/redirects.json': {
    get: {
      summary: 'Retrieves a list of URL redirects. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'path';
          description: 'Show redirects with a given path.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'target';
          description: 'Show redirects with a given target.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_redirects';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  redirect: {
                    path: '/ipod';
                    target: '/pages/itunes';
                  };
                };
                summary: 'Create a redirect';
              };
              example2: {
                value: {
                  redirect: {
                    path: 'http://www.apple.com/forums';
                    target: 'http://forums.apple.com';
                  };
                };
                summary: 'Create a redirect using a full URL for the path, which will be saved as an absolute path without a domain';
              };
              example3: {
                value: {
                  redirect: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a redirect without a path or target fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a redirect. When you provide a full URL as the value of the path property, it will be saved as an absolute path without the domain.\n          For example, "path": "http://www.johns-apparel.com/springwear" will be saved as "path": "springwear".';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#create-2020-07';
      parameters: [];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_redirects';
    };
  };
  '/admin/api/2020-07/redirects/count.json': {
    get: {
      summary: 'Retrieves a count of URL redirects';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#count-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'path';
          description: 'Count redirects with given path.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'target';
          description: 'Count redirects with given target.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_redirects_count';
    };
  };
  '/admin/api/2020-07/redirects/{redirect_id}.json': {
    get: {
      summary: 'Retrieves a single redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_redirects_param_redirect_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  redirect: {
                    id: 668809255;
                    path: '/tiger';
                  };
                };
                summary: 'Update the path URI of a redirect';
              };
              example2: {
                value: {
                  redirect: {
                    id: 950115854;
                    path: '/powermac';
                    target: '/pages/macpro';
                  };
                };
                summary: 'Update both the path and target URIs of a redirect';
              };
            };
          };
        };
      };
      summary: 'Updates an existing redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_redirects_param_redirect_id';
    };
    delete: {
      summary: 'Deletes a redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_redirects_param_redirect_id';
    };
  };
  '/admin/api/2020-10/redirects.json': {
    get: {
      summary: 'Retrieves a list of URL redirects. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'path';
          description: 'Show redirects with a given path.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'target';
          description: 'Show redirects with a given target.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_redirects';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  redirect: {
                    path: '/ipod';
                    target: '/pages/itunes';
                  };
                };
                summary: 'Create a redirect';
              };
              example2: {
                value: {
                  redirect: {
                    path: 'http://www.apple.com/forums';
                    target: 'http://forums.apple.com';
                  };
                };
                summary: 'Create a redirect using a full URL for the path, which will be saved as an absolute path without a domain';
              };
              example3: {
                value: {
                  redirect: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a redirect without a path or target fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a redirect. When you provide a full URL as the value of the path property, it will be saved as an absolute path without the domain.\n          For example, "path": "http://www.johns-apparel.com/springwear" will be saved as "path": "springwear".';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#create-2020-10';
      parameters: [];
      tags: ['online-store', 'redirect', 'online-store/redirect', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_redirects';
    };
  };
  '/admin/api/2020-10/redirects/count.json': {
    get: {
      summary: 'Retrieves a count of URL redirects';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#count-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'path';
          description: 'Count redirects with given path.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'target';
          description: 'Count redirects with given target.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_redirects_count';
    };
  };
  '/admin/api/2020-10/redirects/{redirect_id}.json': {
    get: {
      summary: 'Retrieves a single redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_redirects_param_redirect_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  redirect: {
                    id: 668809255;
                    path: '/tiger';
                  };
                };
                summary: 'Update the path URI of a redirect';
              };
              example2: {
                value: {
                  redirect: {
                    id: 950115854;
                    path: '/powermac';
                    target: '/pages/macpro';
                  };
                };
                summary: 'Update both the path and target URIs of a redirect';
              };
            };
          };
        };
      };
      summary: 'Updates an existing redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#update-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_redirects_param_redirect_id';
    };
    delete: {
      summary: 'Deletes a redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_redirects_param_redirect_id';
    };
  };
  '/admin/api/2021-01/redirects.json': {
    get: {
      summary: 'Retrieves a list of URL redirects. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'path';
          description: 'Show redirects with a given path.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'target';
          description: 'Show redirects with a given target.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_redirects';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  redirect: {
                    path: '/ipod';
                    target: '/pages/itunes';
                  };
                };
                summary: 'Create a redirect';
              };
              example2: {
                value: {
                  redirect: {
                    path: 'http://www.apple.com/forums';
                    target: 'http://forums.apple.com';
                  };
                };
                summary: 'Create a redirect using a full URL for the path, which will be saved as an absolute path without a domain';
              };
              example3: {
                value: {
                  redirect: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a redirect without a path or target fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a redirect. When you provide a full URL as the value of the path property, it will be saved as an absolute path without the domain.\n          For example, "path": "http://www.johns-apparel.com/springwear" will be saved as "path": "springwear".';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#create-2021-01';
      parameters: [];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_redirects';
    };
  };
  '/admin/api/2021-01/redirects/count.json': {
    get: {
      summary: 'Retrieves a count of URL redirects';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#count-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'path';
          description: 'Count redirects with given path.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'target';
          description: 'Count redirects with given target.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_redirects_count';
    };
  };
  '/admin/api/2021-01/redirects/{redirect_id}.json': {
    get: {
      summary: 'Retrieves a single redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_redirects_param_redirect_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  redirect: {
                    id: 668809255;
                    path: '/tiger';
                  };
                };
                summary: 'Update the path URI of a redirect';
              };
              example2: {
                value: {
                  redirect: {
                    id: 950115854;
                    path: '/powermac';
                    target: '/pages/macpro';
                  };
                };
                summary: 'Update both the path and target URIs of a redirect';
              };
            };
          };
        };
      };
      summary: 'Updates an existing redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#update-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_redirects_param_redirect_id';
    };
    delete: {
      summary: 'Deletes a redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_redirects_param_redirect_id';
    };
  };
  '/admin/api/unstable/redirects.json': {
    get: {
      summary: 'Retrieves a list of URL redirects. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The maximum number of results to show.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'path';
          description: 'Show redirects with a given path.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'target';
          description: 'Show redirects with a given target.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_redirects';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  redirect: {
                    path: '/ipod';
                    target: '/pages/itunes';
                  };
                };
                summary: 'Create a redirect';
              };
              example2: {
                value: {
                  redirect: {
                    path: 'http://www.apple.com/forums';
                    target: 'http://forums.apple.com';
                  };
                };
                summary: 'Create a redirect using a full URL for the path, which will be saved as an absolute path without a domain';
              };
              example3: {
                value: {
                  redirect: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a redirect without a path or target fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a redirect. When you provide a full URL as the value of the path property, it will be saved as an absolute path without the domain.\n          For example, "path": "http://www.johns-apparel.com/springwear" will be saved as "path": "springwear".';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#create-unstable';
      parameters: [];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_redirects';
    };
  };
  '/admin/api/unstable/redirects/count.json': {
    get: {
      summary: 'Retrieves a count of URL redirects';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#count-unstable';
      parameters: [
        {
          in: 'query';
          name: 'path';
          description: 'Count redirects with given path.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'target';
          description: 'Count redirects with given target.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_redirects_count';
    };
  };
  '/admin/api/unstable/redirects/{redirect_id}.json': {
    get: {
      summary: 'Retrieves a single redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_redirects_param_redirect_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  redirect: {
                    id: 668809255;
                    path: '/tiger';
                  };
                };
                summary: 'Update the path URI of a redirect';
              };
              example2: {
                value: {
                  redirect: {
                    id: 950115854;
                    path: '/powermac';
                    target: '/pages/macpro';
                  };
                };
                summary: 'Update both the path and target URIs of a redirect';
              };
            };
          };
        };
      };
      summary: 'Updates an existing redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#update-unstable';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_redirects_param_redirect_id';
    };
    delete: {
      summary: 'Deletes a redirect';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/redirect#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'redirect_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'redirect_id';
        },
      ];
      tags: ['online-store', 'redirect', 'online-store/redirect'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_redirects_param_redirect_id';
    };
  };
  '/admin/api/2020-01/script_tags.json': {
    get: {
      summary: 'Retrieves a list of all script tags. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The number of results to return.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show script tags created after this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show script tags created before this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show script tags last updated after this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show script tags last updated before this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'src';
          description: 'Show script tags with this URL.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_script_tags';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  script_tag: {
                    event: 'onload';
                    src: 'https://djavaskripped.org/fancy.js';
                  };
                };
                summary: 'Create a new script tag';
              };
              example2: {
                value: {
                  script_tag: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a script tag without a src and event will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a new script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#create-2020-01';
      parameters: [];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_script_tags';
    };
  };
  '/admin/api/2020-01/script_tags/count.json': {
    get: {
      summary: 'Retrieves a count of all script tags';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#count-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'src';
          description: 'Count only script tags with a given URL.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_script_tags_count';
    };
  };
  '/admin/api/2020-01/script_tags/{script_tag_id}.json': {
    get: {
      summary: 'Retrieves a single script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_script_tags_param_script_tag_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  script_tag: {
                    id: 596726825;
                    src: 'https://somewhere-else.com/another.js';
                  };
                };
                summary: "Update a script tag's URL";
              };
            };
          };
        };
      };
      summary: 'Updates a script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_script_tags_param_script_tag_id';
    };
    delete: {
      summary: 'Deletes a script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_script_tags_param_script_tag_id';
    };
  };
  '/admin/api/2020-04/script_tags.json': {
    get: {
      summary: 'Retrieves a list of all script tags. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The number of results to return.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show script tags created after this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show script tags created before this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show script tags last updated after this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show script tags last updated before this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'src';
          description: 'Show script tags with this URL.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_script_tags';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  script_tag: {
                    event: 'onload';
                    src: 'https://djavaskripped.org/fancy.js';
                  };
                };
                summary: 'Create a new script tag';
              };
              example2: {
                value: {
                  script_tag: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a script tag without a src and event will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a new script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#create-2020-04';
      parameters: [];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_script_tags';
    };
  };
  '/admin/api/2020-04/script_tags/count.json': {
    get: {
      summary: 'Retrieves a count of all script tags';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#count-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'src';
          description: 'Count only script tags with a given URL.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_script_tags_count';
    };
  };
  '/admin/api/2020-04/script_tags/{script_tag_id}.json': {
    get: {
      summary: 'Retrieves a single script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_script_tags_param_script_tag_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  script_tag: {
                    id: 596726825;
                    src: 'https://somewhere-else.com/another.js';
                  };
                };
                summary: "Update a script tag's URL";
              };
            };
          };
        };
      };
      summary: 'Updates a script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_script_tags_param_script_tag_id';
    };
    delete: {
      summary: 'Deletes a script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_script_tags_param_script_tag_id';
    };
  };
  '/admin/api/2020-07/script_tags.json': {
    get: {
      summary: 'Retrieves a list of all script tags. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The number of results to return.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show script tags created after this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show script tags created before this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show script tags last updated after this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show script tags last updated before this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'src';
          description: 'Show script tags with this URL.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_script_tags';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  script_tag: {
                    event: 'onload';
                    src: 'https://djavaskripped.org/fancy.js';
                  };
                };
                summary: 'Create a new script tag';
              };
              example2: {
                value: {
                  script_tag: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a script tag without a src and event will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a new script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#create-2020-07';
      parameters: [];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_script_tags';
    };
  };
  '/admin/api/2020-07/script_tags/count.json': {
    get: {
      summary: 'Retrieves a count of all script tags';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#count-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'src';
          description: 'Count only script tags with a given URL.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_script_tags_count';
    };
  };
  '/admin/api/2020-07/script_tags/{script_tag_id}.json': {
    get: {
      summary: 'Retrieves a single script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_script_tags_param_script_tag_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  script_tag: {
                    id: 596726825;
                    src: 'https://somewhere-else.com/another.js';
                  };
                };
                summary: "Update a script tag's URL";
              };
            };
          };
        };
      };
      summary: 'Updates a script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_script_tags_param_script_tag_id';
    };
    delete: {
      summary: 'Deletes a script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_script_tags_param_script_tag_id';
    };
  };
  '/admin/api/2020-10/script_tags.json': {
    get: {
      summary: 'Retrieves a list of all script tags. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The number of results to return.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show script tags created after this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show script tags created before this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show script tags last updated after this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show script tags last updated before this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'src';
          description: 'Show script tags with this URL.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_script_tags';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  script_tag: {
                    event: 'onload';
                    src: 'https://djavaskripped.org/fancy.js';
                  };
                };
                summary: 'Create a new script tag';
              };
              example2: {
                value: {
                  script_tag: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a script tag without a src and event will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a new script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#create-2020-10';
      parameters: [];
      tags: ['online-store', 'scripttag', 'online-store/scripttag', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_script_tags';
    };
  };
  '/admin/api/2020-10/script_tags/count.json': {
    get: {
      summary: 'Retrieves a count of all script tags';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#count-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'src';
          description: 'Count only script tags with a given URL.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_script_tags_count';
    };
  };
  '/admin/api/2020-10/script_tags/{script_tag_id}.json': {
    get: {
      summary: 'Retrieves a single script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#show-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_script_tags_param_script_tag_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  script_tag: {
                    id: 596726825;
                    src: 'https://somewhere-else.com/another.js';
                  };
                };
                summary: "Update a script tag's URL";
              };
            };
          };
        };
      };
      summary: 'Updates a script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#update-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'update_script_tags_param_script_tag_id';
    };
    delete: {
      summary: 'Deletes a script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#destroy-2020-10';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'delete_script_tags_param_script_tag_id';
    };
  };
  '/admin/api/2021-01/script_tags.json': {
    get: {
      summary: 'Retrieves a list of all script tags. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#index-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The number of results to return.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show script tags created after this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show script tags created before this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show script tags last updated after this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show script tags last updated before this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'src';
          description: 'Show script tags with this URL.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_script_tags';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  script_tag: {
                    event: 'onload';
                    src: 'https://djavaskripped.org/fancy.js';
                  };
                };
                summary: 'Create a new script tag';
              };
              example2: {
                value: {
                  script_tag: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a script tag without a src and event will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a new script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#create-2021-01';
      parameters: [];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_create_script_tags';
    };
  };
  '/admin/api/2021-01/script_tags/count.json': {
    get: {
      summary: 'Retrieves a count of all script tags';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#count-2021-01';
      parameters: [
        {
          in: 'query';
          name: 'src';
          description: 'Count only script tags with a given URL.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_script_tags_count';
    };
  };
  '/admin/api/2021-01/script_tags/{script_tag_id}.json': {
    get: {
      summary: 'Retrieves a single script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#show-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_get_script_tags_param_script_tag_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  script_tag: {
                    id: 596726825;
                    src: 'https://somewhere-else.com/another.js';
                  };
                };
                summary: "Update a script tag's URL";
              };
            };
          };
        };
      };
      summary: 'Updates a script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#update-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_update_script_tags_param_script_tag_id';
    };
    delete: {
      summary: 'Deletes a script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#destroy-2021-01';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202101_delete_script_tags_param_script_tag_id';
    };
  };
  '/admin/api/unstable/script_tags.json': {
    get: {
      summary: 'Retrieves a list of all script tags. Note: As of version 2019-10, this endpoint implements pagination by using links that are provided in the response header. Sending the page parameter will return an error. To learn more, see Making requests to paginated REST Admin API endpoints.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#index-unstable';
      parameters: [
        {
          in: 'query';
          name: 'limit';
          description: 'The number of results to return.\n                  (default: 50, maximum: 250)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'since_id';
          description: 'Restrict results to after the specified ID.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_min';
          description: 'Show script tags created after this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'created_at_max';
          description: 'Show script tags created before this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_min';
          description: 'Show script tags last updated after this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'updated_at_max';
          description: 'Show script tags last updated before this date. (format: 2014-04-25T16:15:47-04:00)';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'src';
          description: 'Show script tags with this URL.';
          schema: {};
          required: false;
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_script_tags';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  script_tag: {
                    event: 'onload';
                    src: 'https://djavaskripped.org/fancy.js';
                  };
                };
                summary: 'Create a new script tag';
              };
              example2: {
                value: {
                  script_tag: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a script tag without a src and event will return an error';
              };
            };
          };
        };
      };
      summary: 'Creates a new script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#create-unstable';
      parameters: [];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_create_script_tags';
    };
  };
  '/admin/api/unstable/script_tags/count.json': {
    get: {
      summary: 'Retrieves a count of all script tags';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#count-unstable';
      parameters: [
        {
          in: 'query';
          name: 'src';
          description: 'Count only script tags with a given URL.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_script_tags_count';
    };
  };
  '/admin/api/unstable/script_tags/{script_tag_id}.json': {
    get: {
      summary: 'Retrieves a single script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#show-unstable';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'A comma-separated list of fields to include in the response.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_get_script_tags_param_script_tag_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  script_tag: {
                    id: 596726825;
                    src: 'https://somewhere-else.com/another.js';
                  };
                };
                summary: "Update a script tag's URL";
              };
            };
          };
        };
      };
      summary: 'Updates a script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#update-unstable';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_update_script_tags_param_script_tag_id';
    };
    delete: {
      summary: 'Deletes a script tag';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/scripttag#destroy-unstable';
      parameters: [
        {
          in: 'path';
          name: 'script_tag_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'script_tag_id';
        },
      ];
      tags: ['online-store', 'scripttag', 'online-store/scripttag'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_unstable_delete_script_tags_param_script_tag_id';
    };
  };
  '/admin/api/2020-01/themes.json': {
    get: {
      summary: 'Retrieves a list of themes.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#index-2020-01';
      parameters: [
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_themes';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  theme: {
                    name: 'Lemongrass';
                    src: 'http://themes.shopify.com/theme.zip';
                    role: 'main';
                  };
                };
                summary: 'Create a theme that has a custom name and is published';
              };
              example2: {
                value: {
                  theme: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a theme without a name fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a theme by providing the public URL of a ZIP file that contains the theme.\n          A new theme is always unpublished by default. To publish a theme when you create it, include\n          "role": "main" in the POST request. The theme will be published only after all\n          of its files have been extracted and stored by Shopify, which might take a couple of minutes.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#create-2020-01';
      parameters: [];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_create_themes';
    };
  };
  '/admin/api/2020-01/themes/{theme_id}.json': {
    get: {
      summary: 'Retrieves a single theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#show-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_get_themes_param_theme_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  theme: {
                    id: 752253240;
                    name: 'Experimental';
                  };
                };
                summary: "Update a theme's name";
              };
              example2: {
                value: {
                  theme: {
                    id: 752253240;
                    role: 'main';
                  };
                };
                summary: 'Publish an unpublished theme';
              };
            };
          };
        };
      };
      summary: 'Updates an existing theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#update-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_update_themes_param_theme_id';
    };
    delete: {
      summary: 'Deletes a theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#destroy-2020-01';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202001_delete_themes_param_theme_id';
    };
  };
  '/admin/api/2020-04/themes.json': {
    get: {
      summary: 'Retrieves a list of themes.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#index-2020-04';
      parameters: [
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_themes';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  theme: {
                    name: 'Lemongrass';
                    src: 'http://themes.shopify.com/theme.zip';
                    role: 'main';
                  };
                };
                summary: 'Create a theme that has a custom name and is published';
              };
              example2: {
                value: {
                  theme: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a theme without a name fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a theme by providing the public URL of a ZIP file that contains the theme.\n          A new theme is always unpublished by default. To publish a theme when you create it, include\n          "role": "main" in the POST request. The theme will be published only after all\n          of its files have been extracted and stored by Shopify, which might take a couple of minutes.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#create-2020-04';
      parameters: [];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_create_themes';
    };
  };
  '/admin/api/2020-04/themes/{theme_id}.json': {
    get: {
      summary: 'Retrieves a single theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#show-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_get_themes_param_theme_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  theme: {
                    id: 752253240;
                    name: 'Experimental';
                  };
                };
                summary: "Update a theme's name";
              };
              example2: {
                value: {
                  theme: {
                    id: 752253240;
                    role: 'main';
                  };
                };
                summary: 'Publish an unpublished theme';
              };
            };
          };
        };
      };
      summary: 'Updates an existing theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#update-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_update_themes_param_theme_id';
    };
    delete: {
      summary: 'Deletes a theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#destroy-2020-04';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202004_delete_themes_param_theme_id';
    };
  };
  '/admin/api/2020-07/themes.json': {
    get: {
      summary: 'Retrieves a list of themes.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#index-2020-07';
      parameters: [
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_themes';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  theme: {
                    name: 'Lemongrass';
                    src: 'http://themes.shopify.com/theme.zip';
                    role: 'main';
                  };
                };
                summary: 'Create a theme that has a custom name and is published';
              };
              example2: {
                value: {
                  theme: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a theme without a name fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a theme by providing the public URL of a ZIP file that contains the theme.\n          A new theme is always unpublished by default. To publish a theme when you create it, include\n          "role": "main" in the POST request. The theme will be published only after all\n          of its files have been extracted and stored by Shopify, which might take a couple of minutes.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#create-2020-07';
      parameters: [];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_create_themes';
    };
  };
  '/admin/api/2020-07/themes/{theme_id}.json': {
    get: {
      summary: 'Retrieves a single theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#show-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_get_themes_param_theme_id';
    };
    put: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  theme: {
                    id: 752253240;
                    name: 'Experimental';
                  };
                };
                summary: "Update a theme's name";
              };
              example2: {
                value: {
                  theme: {
                    id: 752253240;
                    role: 'main';
                  };
                };
                summary: 'Publish an unpublished theme';
              };
            };
          };
        };
      };
      summary: 'Updates an existing theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#update-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_update_themes_param_theme_id';
    };
    delete: {
      summary: 'Deletes a theme.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#destroy-2020-07';
      parameters: [
        {
          in: 'path';
          name: 'theme_id';
          required: true;
          schema: {
            type: 'string';
          };
          description: 'theme_id';
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'deprecated_202007_delete_themes_param_theme_id';
    };
  };
  '/admin/api/2020-10/themes.json': {
    get: {
      summary: 'Retrieves a list of themes.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#index-2020-10';
      parameters: [
        {
          in: 'query';
          name: 'fields';
          description: 'Show only certain fields, specified by a comma-separated list of field names.';
          schema: {};
          required: false;
        },
      ];
      tags: ['online-store', 'theme', 'online-store/theme', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'get_themes';
    };
    post: {
      requestBody: {
        content: {
          'application/json': {
            schema: {};
            examples: {
              example1: {
                value: {
                  theme: {
                    name: 'Lemongrass';
                    src: 'http://themes.shopify.com/theme.zip';
                    role: 'main';
                  };
                };
                summary: 'Create a theme that has a custom name and is published';
              };
              example2: {
                value: {
                  theme: {
                    body: 'foobar';
                  };
                };
                summary: 'Creating a theme without a name fails and returns an error';
              };
            };
          };
        };
      };
      summary: 'Creates a theme by providing the public URL of a ZIP file that contains the theme.\n          A new theme is always unpublished by default. To publish a theme when you create it, include\n          "role": "main" in the POST request. The theme will be published only after all\n          of its files have been extracted and stored by Shopify, which might take a couple of minutes.';
      description: 'https://shopify.dev/docs/admin-api/rest/reference/online-store/theme#create-2020-10';
      parameters: [];
      tags: ['online-store', 'theme', 'online-store/theme', 'latest_api_version'];
      responses: {
        '200': {
          description: '';
        };
      };
      operationId: 'create_themes';
    };
  };
  '/admin/api/2020-10/themes/{theme_id}.json':