// Generated by ts-to-zod
import { z } from 'zod';

export const embeddedResourceSchema = z.object({
  _href: z.string().optional(),
  id: z.number().optional(),
});

export const embeddedAccountCountsSchema = z.object({
  people: z.number().optional(),
});

export const accountStageSchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  order: z.number().optional(),
  updated_at: z.string().optional(),
});

export const accountTierSchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  order: z.number().optional(),
  updated_at: z.string().optional(),
});

export const accountSchema = z.object({
  account_tier: embeddedResourceSchema.optional(),
  archived_at: z.string().optional(),
  city: z.string().optional(),
  company_stage: embeddedResourceSchema.optional(),
  company_type: z.string().optional(),
  conversational_name: z.string().optional(),
  country: z.string().optional(),
  counts: embeddedAccountCountsSchema.optional(),
  created_at: z.string().optional(),
  creator: embeddedResourceSchema.optional(),
  crm_id: z.string().optional(),
  crm_object_type: z.string().optional(),
  crm_url: z.string().optional(),
  custom_fields: z.record(z.unknown()).optional(),
  description: z.string().optional(),
  do_not_contact: z.boolean().optional(),
  domain: z.string().optional(),
  founded: z.string().optional(),
  id: z.number().optional(),
  industry: z.string().optional(),
  last_contacted_at: z.string().optional(),
  last_contacted_by: embeddedResourceSchema.optional(),
  last_contacted_person: embeddedResourceSchema.optional(),
  last_contacted_type: z.string().optional(),
  linkedin_url: z.string().optional(),
  locale: z.string().optional(),
  name: z.string().optional(),
  owner: embeddedResourceSchema.optional(),
  owner_crm_id: z.string().optional(),
  phone: z.string().optional(),
  postal_code: z.string().optional(),
  revenue_range: z.string().optional(),
  size: z.string().optional(),
  state: z.string().optional(),
  street: z.string().optional(),
  tags: z.array(z.string()).optional(),
  twitter_handle: z.string().optional(),
  updated_at: z.string().optional(),
  user_relationships: z.record(z.unknown()).optional(),
  website: z.string().optional(),
});

export const actionSchema = z.object({
  action_details: embeddedResourceSchema.optional(),
  cadence: embeddedResourceSchema.optional(),
  created_at: z.string().optional(),
  due: z.boolean().optional(),
  due_on: z.string().optional(),
  id: z.number().optional(),
  multitouch_group_id: z.number().optional(),
  person: embeddedResourceSchema.optional(),
  status: z.string().optional(),
  step: embeddedResourceSchema.optional(),
  type: z.string().optional(),
  updated_at: z.string().optional(),
  user: embeddedResourceSchema.optional(),
});

export const activitySchema = z.object({
  updated_at: z.string().optional(),
});

export const activityHistorySchema = z.object({
  created_at: z.string().optional(),
  dynamic_data: z.record(z.unknown()).optional(),
  failed_dynamic_resources: z.record(z.unknown()).optional(),
  id: z.number().optional(),
  occurred_at: z.string().optional(),
  pinned_at: z.string().optional(),
  resource_id: z.number().optional(),
  resource_type: z.number().optional(),
  static_data: z.record(z.unknown()).optional(),
  type: z.string().optional(),
  updated_at: z.string().optional(),
  user_guid: z.string().optional(),
});

export const bulkJobSchema = z.object({
  created_at: z.string().optional(),
  errors: z.number().optional(),
  finished_at: z.string().optional(),
  id: z.number().optional(),
  marked_ready_at: z.string().optional(),
  name: z.string().optional(),
  processed: z.number().optional(),
  ready_to_execute: z.boolean().optional(),
  scopes: z.array(z.unknown()).optional(),
  started_at: z.string().optional(),
  state: z.string().optional(),
  total: z.number().optional(),
  type: z.string().optional(),
  updated_at: z.string().optional(),
});

export const bulkJobResultSchema = z.object({
  error: z.string().optional(),
  id: z.number().optional(),
  record: z.record(z.unknown()).optional(),
  resource: z.record(z.unknown()).optional(),
  status: z.string().optional(),
});

export const cadenceCountsSchema = z.object({
  cadence_people: z.number().optional(),
  meetings_booked: z.number().optional(),
  opportunities_created: z.number().optional(),
  people_acted_on_count: z.number().optional(),
  target_daily_people: z.number().optional(),
});

export const cadenceExportSchema = z.object({
  cadence_content: z.record(z.unknown()).optional(),
});

export const cadenceImportSchema = z.object({
  cadence: embeddedResourceSchema.optional(),
});

export const cadenceMembershipCountsSchema = z.object({
  bounces: z.number().optional(),
  calls: z.number().optional(),
  clicks: z.number().optional(),
  replies: z.number().optional(),
  sent_emails: z.number().optional(),
  views: z.number().optional(),
});

export const calendarEventSchema = z.object({
  all_day: z.boolean().optional(),
  attendees: z.array(z.unknown()).optional(),
  body_html: z.string().optional(),
  busy: z.boolean().optional(),
  calendar_id: z.string().optional(),
  canceled_at: z.string().optional(),
  conference_data: z.record(z.unknown()).optional(),
  created_at: z.string().optional(),
  creator: z.string().optional(),
  description: z.string().optional(),
  end_time: z.string().optional(),
  extended_properties: z.record(z.unknown()).optional(),
  html_link: z.string().optional(),
  i_cal_uid: z.string().optional(),
  id: z.string().optional(),
  location: z.string().optional(),
  organizer: z.string().optional(),
  provider: z.string().optional(),
  recurring: z.boolean().optional(),
  start_time: z.string().optional(),
  status: z.string().optional(),
  tenant_id: z.number().optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
  user_guid: z.string().optional(),
});

export const embeddedRecordingResourceSchema = z.object({
  recording_status: z.string().optional(),
  status: z.string().optional(),
  url: z.string().optional(),
});

export const callDataRecordSchema = z.object({
  call: embeddedResourceSchema.optional(),
  call_type: z.string().optional(),
  call_uuid: z.string().optional(),
  called_person: embeddedResourceSchema.optional(),
  created_at: z.string().optional(),
  direction: z.string().optional(),
  duration: z.number().optional(),
  from: z.string().optional(),
  id: z.number().optional(),
  recording: embeddedRecordingResourceSchema.optional(),
  status: z.string().optional(),
  to: z.string().optional(),
  updated_at: z.string().optional(),
  user: embeddedResourceSchema.optional(),
});

export const callDispositionSchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  updated_at: z.string().optional(),
});

export const callInstructionSchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  instructions: z.string().optional(),
  updated_at: z.string().optional(),
});

export const callSentimentSchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  updated_at: z.string().optional(),
});

export const callerIdSchema = z.object({
  account_name: z.string().optional(),
  display_name: z.string().optional(),
  person: embeddedResourceSchema.optional(),
  title: z.string().optional(),
});

export const conversationsCallSchema = z.object({
  call_created_at: z.string().optional(),
  direction: z.string().optional(),
  duration: z.number().optional(),
  from: z.string().optional(),
  recording: z.record(z.unknown()).optional(),
  to: z.string().optional(),
  user_guid: z.string().optional(),
});

export const crmActivitySchema = z.object({
  activity_type: z.string().optional(),
  created_at: z.string().optional(),
  crm_id: z.string().optional(),
  custom_crm_fields: z.record(z.unknown()).optional(),
  description: z.string().optional(),
  error: z.string().optional(),
  id: z.number().optional(),
  person: embeddedResourceSchema.optional(),
  subject: z.string().optional(),
  updated_at: z.string().optional(),
  user: embeddedResourceSchema.optional(),
});

export const crmActivityFieldSchema = z.object({
  created_at: z.string().optional(),
  crm_object_type: z.string().optional(),
  field: z.string().optional(),
  field_type: z.string().optional(),
  id: z.number().optional(),
  picklist_values: z.record(z.unknown()).optional(),
  salesforce_object_type: z.string().optional(),
  source: z.string().optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
  value: z.string().optional(),
});

export const crmUserSchema = z.object({
  created_at: z.string().optional(),
  crm_id: z.string().optional(),
  id: z.number().optional(),
  updated_at: z.string().optional(),
  user: embeddedResourceSchema.optional(),
});

export const customFieldSchema = z.object({
  created_at: z.string().optional(),
  field_type: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  updated_at: z.string().optional(),
  value_type: z.string().optional(),
});

export const customRoleSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
});

export const emailCountsSchema = z.object({
  attachments: z.number().optional(),
  clicks: z.number().optional(),
  replies: z.number().optional(),
  unique_devices: z.number().optional(),
  unique_locations: z.number().optional(),
  views: z.number().optional(),
});

export const emailTemplateCountsSchema = z.object({
  bounces: z.number().optional(),
  clicks: z.number().optional(),
  replies: z.number().optional(),
  sent_emails: z.number().optional(),
  views: z.number().optional(),
});

export const emailTemplateAttachmentSchema = z.object({
  attachment_content_type: z.string().optional(),
  attachment_file_size: z.number().optional(),
  attachment_fingerprint: z.number().optional(),
  attachment_id: z.number().optional(),
  download_url: z.string().optional(),
  email_template: embeddedResourceSchema.optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  scanned: z.boolean().optional(),
});

export const embeddedAttendeeResourceSchema = z.object({
  deleted_at: z.string().optional(),
  email: z.string().optional(),
  name: z.string().optional(),
  organizer: z.boolean().optional(),
  status: z.string().optional(),
  status_changed: z.boolean().optional(),
});

export const eventMeetingSettingSchema = z.object({
  email_address: z.string().optional(),
});

export const externalEmailSchema = z.object({
  message_id: z.string().optional(),
});

export const groupSchema = z.object({
  accessible_groups: z.array(embeddedResourceSchema).optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  parent_id: z.number().optional(),
});

export const importSchema = z.object({
  created_at: z.string().optional(),
  current_people_count: z.number().optional(),
  id: z.number().optional(),
  imported_people_count: z.number().optional(),
  name: z.string().optional(),
  updated_at: z.string().optional(),
});

export const jobDataSchema = z.object({
  bulk_job: z.record(z.unknown()).optional(),
  created_at: z.string().optional(),
  error: z.string().optional(),
  finished_at: z.string().optional(),
  id: z.number().optional(),
  record: z.record(z.unknown()).optional(),
  resource: z.record(z.unknown()).optional(),
  started_at: z.string().optional(),
  status: z.string().optional(),
});

export const jobDataCreationResultSchema = z.object({
  records: z.number().optional(),
});

export const liveFeedItemSchema = z.object({
  alert_metadata: z.record(z.unknown()).optional(),
  event_occurred_at: z.string().optional(),
  event_type: z.string().optional(),
  id: z.number().optional(),
  message: z.string().optional(),
  metadata: z.record(z.unknown()).optional(),
  path: z.string().optional(),
  rollup_key: z.string().optional(),
  title: z.string().optional(),
  user_guid: z.string().optional(),
});

export const liveWebsiteTrackingParameterSchema = z.object({
  parameters: z.array(z.record(z.unknown())).optional(),
});

export const meetingSchema = z.object({
  account_id: z.string().optional(),
  all_day: z.boolean().optional(),
  attendees: z.array(embeddedAttendeeResourceSchema).optional(),
  booked_by_meetings_settings: eventMeetingSettingSchema.optional(),
  booked_by_user: embeddedResourceSchema.optional(),
  cadence: embeddedResourceSchema.optional(),
  calendar_id: z.string().optional(),
  calendar_type: z.string().optional(),
  canceled_at: z.string().optional(),
  created_at: z.string().optional(),
  crm_custom_fields: z.record(z.unknown()).optional(),
  crm_references: z.record(z.unknown()).optional(),
  description: z.string().optional(),
  end_time: z.string().optional(),
  event_id: z.string().optional(),
  event_source: z.string().optional(),
  guests: z.array(z.string()).optional(),
  i_cal_uid: z.string().optional(),
  id: z.number().optional(),
  location: z.string().optional(),
  meeting_type: z.string().optional(),
  no_show: z.boolean().optional(),
  owned_by_meetings_settings: eventMeetingSettingSchema.optional(),
  person: embeddedResourceSchema.optional(),
  recipient_email: z.string().optional(),
  recipient_name: z.string().optional(),
  reschedule_status: z.string().optional(),
  start_time: z.string().optional(),
  status: z.string().optional(),
  step: embeddedResourceSchema.optional(),
  strict_attribution: z.boolean().optional(),
  task_id: z.string().optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
});

export const meetingUrlSchema = z.object({
  created_at: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const mimeEmailPayloadSchema = z.object({
  id: z.number().optional(),
  mailbox: z.string().optional(),
  message_id: z.string().optional(),
  raw: z.string().optional(),
});

export const noteSchema = z.object({
  associated_type: z.string().optional(),
  associated_with: embeddedResourceSchema.optional(),
  call: embeddedResourceSchema.optional(),
  content: z.string().optional(),
  created_at: z.string().optional(),
  id: z.number().optional(),
  updated_at: z.string().optional(),
  user: embeddedResourceSchema.optional(),
});

export const pendingEmailSchema = z.object({
  id: z.number().optional(),
  mailbox: z.string().optional(),
  mime_email_payload: embeddedResourceSchema.optional(),
});

export const personCountsSchema = z.object({
  calls: z.number().optional(),
  emails_bounced: z.number().optional(),
  emails_clicked: z.number().optional(),
  emails_replied_to: z.number().optional(),
  emails_sent: z.number().optional(),
  emails_viewed: z.number().optional(),
});

export const personStageSchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  order: z.number().optional(),
  updated_at: z.string().optional(),
});

export const personSchema = z.object({
  account: embeddedResourceSchema.optional(),
  bouncing: z.boolean().optional(),
  cadences: z.array(embeddedResourceSchema).optional(),
  city: z.string().optional(),
  contact_restrictions: z.array(z.string()).optional(),
  country: z.string().optional(),
  counts: personCountsSchema.optional(),
  created_at: z.string().optional(),
  crm_id: z.string().optional(),
  crm_object_type: z.string().optional(),
  crm_url: z.string().optional(),
  custom_fields: z.record(z.unknown()).optional(),
  display_name: z.string().optional(),
  do_not_contact: z.boolean().optional(),
  email_address: z.string().optional(),
  eu_resident: z.boolean().optional(),
  first_name: z.string().optional(),
  full_email_address: z.string().optional(),
  home_phone: z.string().optional(),
  id: z.number().optional(),
  import: embeddedResourceSchema.optional(),
  job_seniority: z.string().optional(),
  last_completed_step: embeddedResourceSchema.optional(),
  last_completed_step_cadence: embeddedResourceSchema.optional(),
  last_contacted_at: z.string().optional(),
  last_contacted_by: embeddedResourceSchema.optional(),
  last_contacted_type: z.string().optional(),
  last_name: z.string().optional(),
  last_replied_at: z.string().optional(),
  linkedin_url: z.string().optional(),
  locale: z.string().optional(),
  locale_utc_offset: z.number().optional(),
  mobile_phone: z.string().optional(),
  most_recent_cadence: embeddedResourceSchema.optional(),
  owner: embeddedResourceSchema.optional(),
  owner_crm_id: z.string().optional(),
  person_company_industry: z.string().optional(),
  person_company_name: z.string().optional(),
  person_company_website: z.string().optional(),
  person_stage: embeddedResourceSchema.optional(),
  personal_email_address: z.string().optional(),
  personal_website: z.string().optional(),
  phone: z.string().optional(),
  phone_extension: z.string().optional(),
  secondary_email_address: z.string().optional(),
  starred: z.boolean().optional(),
  state: z.string().optional(),
  success_count: z.number().optional(),
  tags: z.array(z.string()).optional(),
  title: z.string().optional(),
  twitter_handle: z.string().optional(),
  untouched: z.boolean().optional(),
  updated_at: z.string().optional(),
  work_city: z.string().optional(),
  work_country: z.string().optional(),
  work_state: z.string().optional(),
});

export const phoneNumberAssignmentSchema = z.object({
  id: z.number().optional(),
  number: z.string().optional(),
  user: embeddedResourceSchema.optional(),
});

export const recordingSettingSchema = z.object({
  recording_default: z.boolean().optional(),
});

export const savedListViewSchema = z.object({
  id: z.number().optional(),
  is_default: z.boolean().optional(),
  name: z.string().optional(),
  view: z.string().optional(),
  view_params: z.record(z.unknown()).optional(),
});

export const stepSchema = z.object({
  cadence: embeddedResourceSchema.optional(),
  created_at: z.string().optional(),
  day: z.number().optional(),
  details: embeddedResourceSchema.optional(),
  disabled: z.boolean().optional(),
  display_name: z.string().optional(),
  id: z.number().optional(),
  multitouch_enabled: z.boolean().optional(),
  name: z.string().optional(),
  step_number: z.number().optional(),
  type: z.string().optional(),
  updated_at: z.string().optional(),
});

export const subscriptionSchema = z.object({
  callback_token: z.string().optional(),
  callback_url: z.string().optional(),
  enabled: z.boolean().optional(),
  event_type: z.string().optional(),
  id: z.number().optional(),
  tenant_id: z.number().optional(),
  user_guid: z.string().optional(),
});

export const successCountsSchema = z.object({
  total_calls: z.number().optional(),
  total_emails: z.number().optional(),
  total_other_touches: z.number().optional(),
});

export const tagSchema = z.object({
  id: z.number().optional(),
  name: z.string().optional(),
});

export const taskSchema = z.object({
  completed_at: z.string().optional(),
  completed_by: embeddedResourceSchema.optional(),
  created_at: z.string().optional(),
  created_by_user: embeddedResourceSchema.optional(),
  current_state: z.string().optional(),
  description: z.string().optional(),
  due_at: z.string().optional(),
  due_date: z.string().optional(),
  id: z.number().optional(),
  person: embeddedResourceSchema.optional(),
  remind_at: z.string().optional(),
  subject: z.string().optional(),
  task_type: z.string().optional(),
  updated_at: z.string().optional(),
  user: embeddedResourceSchema.optional(),
});

export const teamSchema = z.object({
  _private_fields: z.record(z.unknown()).optional(),
  allow_automated_email_steps: z.boolean().optional(),
  call_recording_disabled: z.boolean().optional(),
  click_tracking_default: z.boolean().optional(),
  created_at: z.string().optional(),
  custom_tracking_domain: z.string().optional(),
  deactivated: z.boolean().optional(),
  dispositions_required: z.boolean().optional(),
  email_daily_limit: z.number().optional(),
  group_privacy_setting: z.string().optional(),
  id: z.number().optional(),
  license_limit: z.number().optional(),
  local_dial_enabled: z.boolean().optional(),
  name: z.string().optional(),
  plan: z.string().optional(),
  plan_features: z.record(z.unknown()).optional(),
  record_by_default: z.boolean().optional(),
  sentiments_required: z.boolean().optional(),
  team_visibility_default: z.string().optional(),
  updated_at: z.string().optional(),
});

export const teamTemplateCountsSchema = z.object({
  bounces: z.number().optional(),
  clicks: z.number().optional(),
  replies: z.number().optional(),
  sent_emails: z.number().optional(),
  views: z.number().optional(),
});

export const teamTemplateAttachmentSchema = z.object({
  attachment_file_size: z.number().optional(),
  attachment_id: z.number().optional(),
  download_url: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  team_template: embeddedResourceSchema.optional(),
});

export const userSchema = z.object({
  _private_fields: z.record(z.unknown()).optional(),
  active: z.boolean().optional(),
  bcc_email_address: z.string().optional(),
  click_to_call_enabled: z.boolean().optional(),
  created_at: z.string().optional(),
  crm_connected: z.boolean().optional(),
  email: z.string().optional(),
  email_client_configured: z.boolean().optional(),
  email_client_email_address: z.string().optional(),
  email_signature: z.string().optional(),
  email_signature_click_tracking_disabled: z.boolean().optional(),
  email_signature_type: z.string().optional(),
  external_feature_flags: z.record(z.unknown()).optional(),
  first_name: z.string().optional(),
  from_address: z.string().optional(),
  full_email_address: z.string().optional(),
  group: embeddedResourceSchema.optional(),
  guid: z.string().optional(),
  id: z.number().optional(),
  job_role: z.string().optional(),
  last_name: z.string().optional(),
  local_dial_enabled: z.boolean().optional(),
  name: z.string().optional(),
  phone_client: embeddedResourceSchema.optional(),
  phone_number_assignment: embeddedResourceSchema.optional(),
  role: embeddedResourceSchema.optional(),
  sending_email_address: z.string().optional(),
  slack_username: z.string().optional(),
  team: embeddedResourceSchema.optional(),
  team_admin: z.boolean().optional(),
  time_zone: z.string().optional(),
  twitter_handle: z.string().optional(),
  updated_at: z.string().optional(),
  work_country: z.string().optional(),
});

export const getV2AccountStagesJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      updated_at: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getV2AccountStagesJsonResponseSchema = z.array(accountStageSchema);

export const getV2AccountStagesJsonErrorSchema = z.unknown();

export const getV2AccountStagesByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2AccountStagesByIdJsonResponseSchema = accountStageSchema;

export const getV2AccountStagesByIdJsonErrorSchema = z.unknown();

export const getV2AccountTiersJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      name: z.array(z.string()).optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
    })
    .optional(),
});

export const getV2AccountTiersJsonResponseSchema = z.array(accountTierSchema);

export const getV2AccountTiersJsonErrorSchema = z.unknown();

export const getV2AccountTiersByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2AccountTiersByIdJsonResponseSchema = accountTierSchema;

export const getV2AccountTiersByIdJsonErrorSchema = z.unknown();

export const postV2AccountUpsertsJsonDataSchema = z.object({
  body: z
    .object({
      account_tier_id: z.number().optional(),
      city: z.string().optional(),
      company_stage_id: z.number().optional(),
      company_type: z.string().optional(),
      conversational_name: z.string().optional(),
      country: z.string().optional(),
      crm_id: z.string().optional(),
      crm_id_type: z.string().optional(),
      custom_fields: z.array(z.record(z.unknown())).optional(),
      description: z.string().optional(),
      do_not_contact: z.boolean().optional(),
      domain: z.string(),
      founded: z.string().optional(),
      id: z.number().optional(),
      industry: z.string().optional(),
      linkedin_url: z.string().optional(),
      locale: z.string().optional(),
      name: z.string(),
      owner_id: z.number().optional(),
      phone: z.string().optional(),
      postal_code: z.string().optional(),
      revenue_range: z.string().optional(),
      size: z.string().optional(),
      state: z.string().optional(),
      street: z.string().optional(),
      tags: z.array(z.string()).optional(),
      twitter_handle: z.string().optional(),
      upsert_key: z.string().optional(),
      website: z.string().optional(),
    })
    .optional(),
});

export const accountUpsertSchema = z.object({
  account: accountSchema.optional(),
  upsert_type: z.string().optional(),
});

export const postV2AccountUpsertsJsonErrorSchema = z.unknown();

export const getV2AccountsJsonDataSchema = z.object({
  query: z
    .object({
      account_stage_id: z.array(z.number()).optional(),
      account_tier_id: z.array(z.number()).optional(),
      archived: z.boolean().optional(),
      city: z.array(z.string()).optional(),
      country: z.array(z.string()).optional(),
      created_at: z.array(z.string()).optional(),
      crm_id: z.array(z.string()).optional(),
      custom_fields: z.record(z.unknown()).optional(),
      domain: z.string().optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      industry: z.array(z.string()).optional(),
      last_contacted: z.record(z.unknown()).optional(),
      limit_paging_counts: z.boolean().optional(),
      locales: z.array(z.string()).optional(),
      name: z.array(z.string()).optional(),
      owner_crm_id: z.array(z.string()).optional(),
      owner_id: z.array(z.string()).optional(),
      owner_is_active: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      state: z.array(z.string()).optional(),
      tag: z.array(z.string()).optional(),
      tag_id: z.array(z.number()).optional(),
      updated_at: z.array(z.string()).optional(),
      user_relationships: z.record(z.unknown()).optional(),
      website: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getV2AccountsJsonResponseSchema = z.array(accountSchema);

export const getV2AccountsJsonErrorSchema = z.unknown();

export const postV2AccountsJsonDataSchema = z.object({
  body: z.object({
    account_tier_id: z.number().optional(),
    city: z.string().optional(),
    company_stage_id: z.number().optional(),
    company_type: z.string().optional(),
    conversational_name: z.string().optional(),
    country: z.string().optional(),
    crm_id: z.string().optional(),
    crm_id_type: z.string().optional(),
    custom_fields: z.array(z.record(z.unknown())).optional(),
    description: z.string().optional(),
    do_not_contact: z.boolean().optional(),
    domain: z.string(),
    founded: z.string().optional(),
    industry: z.string().optional(),
    linkedin_url: z.string().optional(),
    locale: z.string().optional(),
    name: z.string(),
    owner_id: z.number().optional(),
    phone: z.string().optional(),
    postal_code: z.string().optional(),
    revenue_range: z.string().optional(),
    size: z.string().optional(),
    state: z.string().optional(),
    street: z.string().optional(),
    tags: z.array(z.string()).optional(),
    twitter_handle: z.string().optional(),
    website: z.string().optional(),
  }),
});

export const postV2AccountsJsonResponseSchema = accountSchema;

export const postV2AccountsJsonErrorSchema = z.unknown();

export const deleteV2AccountsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteV2AccountsByIdJsonResponseSchema = z.any();

export const deleteV2AccountsByIdJsonErrorSchema = z.unknown();

export const getV2AccountsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2AccountsByIdJsonResponseSchema = accountSchema;

export const getV2AccountsByIdJsonErrorSchema = z.unknown();

export const putV2AccountsByIdJsonDataSchema = z.object({
  body: z.object({
    account_tier_id: z.number().optional(),
    archived: z.boolean().optional(),
    city: z.string().optional(),
    company_stage_id: z.number().optional(),
    company_type: z.string().optional(),
    conversational_name: z.string().optional(),
    country: z.string().optional(),
    crm_id: z.string().optional(),
    crm_id_type: z.string().optional(),
    custom_fields: z.array(z.record(z.unknown())).optional(),
    description: z.string().optional(),
    do_not_contact: z.boolean().optional(),
    domain: z.string(),
    founded: z.string().optional(),
    industry: z.string().optional(),
    linkedin_url: z.string().optional(),
    locale: z.string().optional(),
    name: z.string(),
    owner_id: z.number().optional(),
    phone: z.string().optional(),
    postal_code: z.string().optional(),
    revenue_range: z.string().optional(),
    size: z.string().optional(),
    state: z.string().optional(),
    street: z.string().optional(),
    tags: z.array(z.string()).optional(),
    twitter_handle: z.string().optional(),
    website: z.string().optional(),
  }),
  path: z.object({
    id: z.string(),
  }),
});

export const putV2AccountsByIdJsonResponseSchema = accountSchema;

export const putV2AccountsByIdJsonErrorSchema = z.unknown();

export const getV2ActionDetailsCallInstructionsJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
    })
    .optional(),
});

export const getV2ActionDetailsCallInstructionsJsonResponseSchema = z.array(callInstructionSchema);

export const getV2ActionDetailsCallInstructionsJsonErrorSchema = z.unknown();

export const getV2ActionDetailsCallInstructionsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2ActionDetailsCallInstructionsByIdJsonResponseSchema = callInstructionSchema;

export const getV2ActionDetailsCallInstructionsByIdJsonErrorSchema = z.unknown();

export const getV2ActionsJsonDataSchema = z.object({
  query: z
    .object({
      cadence_id: z.array(z.number()).optional(),
      due_on: z.array(z.string()).optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      multitouch_group_id: z.array(z.number()).optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      person_id: z.array(z.number()).optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      step_id: z.number().optional(),
      type: z.string().optional(),
      updated_at: z.array(z.string()).optional(),
      user_guid: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getV2ActionsJsonResponseSchema = z.array(actionSchema);

export const getV2ActionsJsonErrorSchema = z.unknown();

export const getV2ActionsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2ActionsByIdJsonResponseSchema = actionSchema;

export const getV2ActionsByIdJsonErrorSchema = z.unknown();

export const postV2ActivitiesJsonDataSchema = z.object({
  body: z
    .object({
      action_id: z.number().optional(),
      task_id: z.number().optional(),
    })
    .optional(),
});

export const postV2ActivitiesJsonResponseSchema = activitySchema;

export const postV2ActivitiesJsonErrorSchema = z.unknown();

export const getV2ActivitiesCallsJsonDataSchema = z.object({
  query: z
    .object({
      created_at: z.array(z.string()).optional(),
      disposition: z.array(z.string()).optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      person_id: z.array(z.number()).optional(),
      sentiment: z.array(z.string()).optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      updated_at: z.array(z.string()).optional(),
      user_guid: z.array(z.string()).optional(),
    })
    .optional(),
});

export const callSchema = z.object({
  action: embeddedResourceSchema.optional(),
  cadence: embeddedResourceSchema.optional(),
  called_person: embeddedResourceSchema.optional(),
  created_at: z.string().optional(),
  crm_activity: embeddedResourceSchema.optional(),
  disposition: z.string().optional(),
  duration: z.number().optional(),
  id: z.number().optional(),
  note: embeddedResourceSchema.optional(),
  recordings: z.array(embeddedRecordingResourceSchema).optional(),
  sentiment: z.string().optional(),
  step: embeddedResourceSchema.optional(),
  to: z.string().optional(),
  updated_at: z.string().optional(),
  user: embeddedResourceSchema.optional(),
});

export const getV2ActivitiesCallsJsonErrorSchema = z.unknown();

export const postV2ActivitiesCallsJsonDataSchema = z.object({
  body: z.object({
    action_id: z.number().optional(),
    crm_params: z.record(z.unknown()).optional(),
    disposition: z.string().optional(),
    duration: z.number().optional(),
    linked_call_data_record_ids: z.array(z.number()).optional(),
    notes: z.string().optional(),
    person_id: z.number(),
    sentiment: z.string().optional(),
    to: z.string().optional(),
    user_guid: z.string().optional(),
  }),
});

export const postV2ActivitiesCallsJsonResponseSchema = callSchema;

export const postV2ActivitiesCallsJsonErrorSchema = z.unknown();

export const getV2ActivitiesCallsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2ActivitiesCallsByIdJsonResponseSchema = callSchema;

export const getV2ActivitiesCallsByIdJsonErrorSchema = z.unknown();

export const getV2ActivitiesEmailsJsonDataSchema = z.object({
  query: z
    .object({
      action_id: z.array(z.number()).optional(),
      bounced: z.boolean().optional(),
      cadence_id: z.array(z.number()).optional(),
      crm_activity_id: z.array(z.number()).optional(),
      email_addresses: z.array(z.string()).optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      one_off: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      person_id: z.array(z.number()).optional(),
      personalization: z.array(z.string()).optional(),
      scoped_fields: z.array(z.string()).optional(),
      sent_at: z.array(z.string()).optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      status: z.array(z.string()).optional(),
      step_id: z.array(z.number()).optional(),
      updated_at: z.array(z.string()).optional(),
      user_id: z.array(z.number()).optional(),
    })
    .optional(),
});

export const emailSchema = z.object({
  action: embeddedResourceSchema.optional(),
  bounced: z.boolean().optional(),
  cadence: embeddedResourceSchema.optional(),
  click_tracking: z.boolean().optional(),
  counts: emailCountsSchema.optional(),
  created_at: z.string().optional(),
  crm_activity: embeddedResourceSchema.optional(),
  email_template: embeddedResourceSchema.optional(),
  error_message: z.string().optional(),
  headers: z.record(z.unknown()).optional(),
  id: z.number().optional(),
  mailing: embeddedResourceSchema.optional(),
  personalization: z.string().optional(),
  recipient: embeddedResourceSchema.optional(),
  recipient_email_address: z.string().optional(),
  send_after: z.string().optional(),
  sent_at: z.string().optional(),
  status: z.string().optional(),
  step: embeddedResourceSchema.optional(),
  subject: z.string().optional(),
  task: embeddedResourceSchema.optional(),
  updated_at: z.string().optional(),
  user: embeddedResourceSchema.optional(),
  view_tracking: z.boolean().optional(),
});

export const getV2ActivitiesEmailsJsonErrorSchema = z.unknown();

export const getV2ActivitiesEmailsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2ActivitiesEmailsByIdJsonResponseSchema = emailSchema;

export const getV2ActivitiesEmailsByIdJsonErrorSchema = z.unknown();

export const getV2ActivityHistoriesDataSchema = z.object({
  query: z
    .object({
      _resource: z.string().optional(),
      include_paging_counts: z.boolean().optional(),
      occurred_at: z.record(z.unknown()).optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      pinned: z.boolean().optional(),
      resource_id: z.array(z.string()).optional(),
      resource_type: z.string().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      type: z.string().optional(),
      updated_at: z.record(z.unknown()).optional(),
      user_guid: z.string().optional(),
    })
    .optional(),
});

export const getV2ActivityHistoriesResponseSchema = activityHistorySchema;

export const getV2ActivityHistoriesErrorSchema = z.unknown();

export const getV2BulkJobsDataSchema = z.object({
  query: z
    .object({
      id: z.record(z.unknown()).optional(),
      per_page: z.number().optional(),
      state: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getV2BulkJobsResponseSchema = z.array(bulkJobSchema);

export const getV2BulkJobsErrorSchema = z.unknown();

export const postV2BulkJobsDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
      type: z.string(),
    })
    .optional(),
});

export const postV2BulkJobsResponseSchema = bulkJobSchema;

export const postV2BulkJobsErrorSchema = z.unknown();

export const getV2BulkJobsByBulkJobsIdJobDataDataSchema = z.object({
  path: z.object({
    bulk_jobs_id: z.number(),
  }),
  query: z
    .object({
      id: z.record(z.unknown()).optional(),
      per_page: z.number().optional(),
      status: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getV2BulkJobsByBulkJobsIdJobDataResponseSchema = z.array(bulkJobResultSchema);

export const getV2BulkJobsByBulkJobsIdJobDataErrorSchema = z.unknown();

export const postV2BulkJobsByBulkJobsIdJobDataDataSchema = z.object({
  body: z.object({
    data: z.array(z.string()),
  }),
  path: z.object({
    bulk_jobs_id: z.number(),
  }),
});

export const postV2BulkJobsByBulkJobsIdJobDataResponseSchema = jobDataCreationResultSchema;

export const postV2BulkJobsByBulkJobsIdJobDataErrorSchema = z.unknown();

export const getV2BulkJobsByBulkJobsIdResultsDataSchema = z.object({
  path: z.object({
    bulk_jobs_id: z.number(),
  }),
  query: z
    .object({
      id: z.record(z.unknown()).optional(),
      per_page: z.number().optional(),
      status: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getV2BulkJobsByBulkJobsIdResultsResponseSchema = z.array(bulkJobResultSchema);

export const getV2BulkJobsByBulkJobsIdResultsErrorSchema = z.unknown();

export const getV2BulkJobsByIdDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const getV2BulkJobsByIdResponseSchema = bulkJobSchema;

export const getV2BulkJobsByIdErrorSchema = z.unknown();

export const putV2BulkJobsByIdDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
      ready_to_execute: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const putV2BulkJobsByIdResponseSchema = bulkJobSchema;

export const putV2BulkJobsByIdErrorSchema = z.unknown();

export const getV2CadenceExportsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2CadenceExportsByIdJsonResponseSchema = cadenceExportSchema;

export const getV2CadenceExportsByIdJsonErrorSchema = z.unknown();

export const postV2CadenceImportsJsonDataSchema = z.object({
  body: z
    .object({
      cadence_content: z.record(z.unknown()).optional(),
      settings: z.record(z.unknown()).optional(),
      sharing_settings: z.record(z.unknown()).optional(),
    })
    .optional(),
});

export const postV2CadenceImportsJsonResponseSchema = cadenceImportSchema;

export const postV2CadenceImportsJsonErrorSchema = z.unknown();

export const getV2CadenceMembershipsJsonDataSchema = z.object({
  query: z
    .object({
      cadence_id: z.number().optional(),
      currently_on_cadence: z.boolean().optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      person_id: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      updated_at: z.array(z.string()).optional(),
    })
    .optional(),
});

export const cadenceMembershipSchema = z.object({
  added_at: z.string().optional(),
  cadence: embeddedResourceSchema.optional(),
  counts: cadenceMembershipCountsSchema.optional(),
  created_at: z.string().optional(),
  current_state: z.string().optional(),
  currently_on_cadence: z.boolean().optional(),
  id: z.number().optional(),
  latest_action: embeddedResourceSchema.optional(),
  person: embeddedResourceSchema.optional(),
  person_deleted: z.boolean().optional(),
  updated_at: z.string().optional(),
  user: embeddedResourceSchema.optional(),
});

export const getV2CadenceMembershipsJsonErrorSchema = z.unknown();

export const postV2CadenceMembershipsJsonDataSchema = z.object({
  query: z.object({
    cadence_id: z.number(),
    person_id: z.number(),
    step_id: z.number().optional(),
    user_id: z.number().optional(),
  }),
});

export const postV2CadenceMembershipsJsonResponseSchema = cadenceMembershipSchema;

export const postV2CadenceMembershipsJsonErrorSchema = z.unknown();

export const deleteV2CadenceMembershipsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteV2CadenceMembershipsByIdJsonResponseSchema = z.any();

export const deleteV2CadenceMembershipsByIdJsonErrorSchema = z.unknown();

export const getV2CadenceMembershipsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2CadenceMembershipsByIdJsonResponseSchema = cadenceMembershipSchema;

export const getV2CadenceMembershipsByIdJsonErrorSchema = z.unknown();

export const getV2CadencesJsonDataSchema = z.object({
  query: z
    .object({
      archived: z.boolean().optional(),
      group_ids: z.string().optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      name: z.array(z.string()).optional(),
      owned_by_guid: z.array(z.string()).optional(),
      page: z.number().optional(),
      people_addable: z.boolean().optional(),
      per_page: z.number().optional(),
      shared: z.boolean().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      team_cadence: z.boolean().optional(),
      updated_at: z.array(z.string()).optional(),
    })
    .optional(),
});

export const cadenceSchema = z.object({
  added_stage: embeddedResourceSchema.optional(),
  archived_at: z.string().optional(),
  bounced_stage: embeddedResourceSchema.optional(),
  cadence_framework_id: z.number().optional(),
  cadence_function: z.string().optional(),
  cadence_priority: embeddedResourceSchema.optional(),
  counts: cadenceCountsSchema.optional(),
  created_at: z.string().optional(),
  creator: embeddedResourceSchema.optional(),
  draft: z.boolean().optional(),
  external_identifier: z.string().optional(),
  finished_stage: embeddedResourceSchema.optional(),
  groups: z.array(embeddedResourceSchema).optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  opt_out_link_included: z.boolean().optional(),
  owner: embeddedResourceSchema.optional(),
  remove_bounces_enabled: z.boolean().optional(),
  remove_replies_enabled: z.boolean().optional(),
  replied_stage: embeddedResourceSchema.optional(),
  shared: z.boolean().optional(),
  tags: z.array(z.string()).optional(),
  team_cadence: z.boolean().optional(),
  updated_at: z.string().optional(),
});

export const getV2CadencesJsonErrorSchema = z.unknown();

export const getV2CadencesByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2CadencesByIdJsonResponseSchema = cadenceSchema;

export const getV2CadencesByIdJsonErrorSchema = z.unknown();

export const getV2CalendarEventsDataSchema = z.object({
  query: z
    .object({
      calendar_id: z.string().optional(),
      end_time: z.string().optional(),
      include_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      start_time: z.string().optional(),
      user_guid: z.string().optional(),
    })
    .optional(),
});

export const getV2CalendarEventsResponseSchema = z.array(calendarEventSchema);

export const getV2CalendarEventsErrorSchema = z.unknown();

export const postV2CalendarEventsUpsertDataSchema = z.object({
  body: z.object({
    all_day: z.boolean().optional(),
    attendees: z.record(z.unknown()).optional(),
    calendar_id: z.string(),
    canceled_at: z.string().optional(),
    description: z.string().optional(),
    end_time: z.string(),
    i_cal_uid: z.string(),
    id: z.string(),
    location: z.string().optional(),
    organizer: z.string().optional(),
    recurring: z.boolean().optional(),
    start_time: z.string(),
    status: z.string().optional(),
    title: z.string().optional(),
    updated_at: z.string().optional(),
  }),
});

export const postV2CalendarEventsUpsertResponseSchema = calendarEventSchema;

export const postV2CalendarEventsUpsertErrorSchema = z.unknown();

export const getV2CallDataRecordsJsonDataSchema = z.object({
  query: z
    .object({
      created_at: z.array(z.string()).optional(),
      has_call: z.boolean().optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      person_id: z.array(z.number()).optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      updated_at: z.array(z.string()).optional(),
      user_guid: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getV2CallDataRecordsJsonResponseSchema = z.array(callDataRecordSchema);

export const getV2CallDataRecordsJsonErrorSchema = z.unknown();

export const getV2CallDataRecordsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2CallDataRecordsByIdJsonResponseSchema = callDataRecordSchema;

export const getV2CallDataRecordsByIdJsonErrorSchema = z.unknown();

export const getV2CallDispositionsJsonDataSchema = z.object({
  query: z
    .object({
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
    })
    .optional(),
});

export const getV2CallDispositionsJsonResponseSchema = z.array(callDispositionSchema);

export const getV2CallDispositionsJsonErrorSchema = z.unknown();

export const getV2CallSentimentsJsonDataSchema = z.object({
  query: z
    .object({
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      name: z.string().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
    })
    .optional(),
});

export const getV2CallSentimentsJsonResponseSchema = z.array(callSentimentSchema);

export const getV2CallSentimentsJsonErrorSchema = z.unknown();

export const postV2ConversationsCallsDataSchema = z.object({
  body: z.object({
    call_created_at: z.string().optional(),
    direction: z.string().optional(),
    duration: z.number(),
    from: z.string(),
    recording: z.record(z.unknown()),
    to: z.string(),
    user_guid: z.string().optional(),
  }),
});

export const postV2ConversationsCallsResponseSchema = conversationsCallSchema;

export const postV2ConversationsCallsErrorSchema = z.unknown();

export const getV2CrmActivitiesJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      updated_at: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getV2CrmActivitiesJsonResponseSchema = z.array(crmActivitySchema);

export const getV2CrmActivitiesJsonErrorSchema = z.unknown();

export const getV2CrmActivitiesByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2CrmActivitiesByIdJsonResponseSchema = crmActivitySchema;

export const getV2CrmActivitiesByIdJsonErrorSchema = z.unknown();

export const getV2CrmActivityFieldsJsonDataSchema = z.object({
  query: z
    .object({
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      source: z.string().optional(),
    })
    .optional(),
});

export const getV2CrmActivityFieldsJsonResponseSchema = z.array(crmActivityFieldSchema);

export const getV2CrmActivityFieldsJsonErrorSchema = z.unknown();

export const getV2CrmUsersJsonDataSchema = z.object({
  query: z
    .object({
      crm_id: z.array(z.string()).optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      user_guid: z.array(z.string()).optional(),
      user_id: z.array(z.number()).optional(),
    })
    .optional(),
});

export const getV2CrmUsersJsonResponseSchema = z.array(crmUserSchema);

export const getV2CrmUsersJsonErrorSchema = z.unknown();

export const getV2CustomFieldsJsonDataSchema = z.object({
  query: z
    .object({
      field_type: z.string().optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
    })
    .optional(),
});

export const getV2CustomFieldsJsonResponseSchema = z.array(customFieldSchema);

export const getV2CustomFieldsJsonErrorSchema = z.unknown();

export const postV2CustomFieldsJsonDataSchema = z.object({
  body: z.object({
    field_type: z.string().optional(),
    name: z.string(),
  }),
});

export const postV2CustomFieldsJsonResponseSchema = customFieldSchema;

export const postV2CustomFieldsJsonErrorSchema = z.unknown();

export const deleteV2CustomFieldsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteV2CustomFieldsByIdJsonResponseSchema = z.any();

export const deleteV2CustomFieldsByIdJsonErrorSchema = z.unknown();

export const getV2CustomFieldsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2CustomFieldsByIdJsonResponseSchema = customFieldSchema;

export const getV2CustomFieldsByIdJsonErrorSchema = z.unknown();

export const putV2CustomFieldsByIdJsonDataSchema = z.object({
  body: z
    .object({
      field_type: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const putV2CustomFieldsByIdJsonResponseSchema = customFieldSchema;

export const putV2CustomFieldsByIdJsonErrorSchema = z.unknown();

export const getV2CustomRolesJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.string()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
    })
    .optional(),
});

export const getV2CustomRolesJsonResponseSchema = z.array(customRoleSchema);

export const getV2CustomRolesJsonErrorSchema = z.unknown();

export const getV2CustomRolesByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2CustomRolesByIdJsonResponseSchema = customRoleSchema;

export const getV2CustomRolesByIdJsonErrorSchema = z.unknown();

export const getV2EmailTemplateAttachmentsJsonDataSchema = z.object({
  query: z
    .object({
      email_template_id: z.array(z.number()).optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
    })
    .optional(),
});

export const getV2EmailTemplateAttachmentsJsonResponseSchema = z.array(emailTemplateAttachmentSchema);

export const getV2EmailTemplateAttachmentsJsonErrorSchema = z.unknown();

export const getV2EmailTemplatesJsonDataSchema = z.object({
  query: z
    .object({
      cadence_id: z.array(z.number()).optional(),
      filter_by_owner: z.boolean().optional(),
      group_id: z.array(z.number()).optional(),
      ids: z.array(z.number()).optional(),
      include_archived_templates: z.boolean().optional(),
      include_cadence_templates: z.boolean().optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      linked_to_team_template: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      search: z.string().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      tag: z.array(z.string()).optional(),
      tag_ids: z.array(z.number()).optional(),
      updated_at: z.array(z.string()).optional(),
    })
    .optional(),
});

export const emailTemplateSchema = z.object({
  _links: z.record(z.unknown()).optional(),
  archived_at: z.string().optional(),
  body: z.string().optional(),
  body_preview: z.string().optional(),
  cadence_template: z.boolean().optional(),
  click_tracking_enabled: z.boolean().optional(),
  counts: emailTemplateCountsSchema.optional(),
  created_at: z.string().optional(),
  groups: z.array(embeddedResourceSchema).optional(),
  id: z.number().optional(),
  last_used_at: z.string().optional(),
  open_tracking_enabled: z.boolean().optional(),
  shared: z.boolean().optional(),
  subject: z.string().optional(),
  tags: z.array(z.string()).optional(),
  team_template: embeddedResourceSchema.optional(),
  template_owner: embeddedResourceSchema.optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
});

export const getV2EmailTemplatesJsonErrorSchema = z.unknown();

export const getV2EmailTemplatesByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      include_signature: z.boolean().optional(),
    })
    .optional(),
});

export const getV2EmailTemplatesByIdJsonResponseSchema = emailTemplateSchema;

export const getV2EmailTemplatesByIdJsonErrorSchema = z.unknown();

export const postV2ExternalEmailsJsonDataSchema = z.object({
  body: z.object({
    mailbox: z.string(),
    raw: z.string(),
  }),
});

export const postV2ExternalEmailsJsonResponseSchema = externalEmailSchema;

export const postV2ExternalEmailsJsonErrorSchema = z.unknown();

export const getV2GroupsJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
    })
    .optional(),
});

export const getV2GroupsJsonResponseSchema = z.array(groupSchema);

export const getV2GroupsJsonErrorSchema = z.unknown();

export const getV2GroupsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2GroupsByIdJsonResponseSchema = groupSchema;

export const getV2GroupsByIdJsonErrorSchema = z.unknown();

export const getV2ImportsJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      user_ids: z.array(z.number()).optional(),
    })
    .optional(),
});

export const getV2ImportsJsonResponseSchema = z.array(importSchema);

export const getV2ImportsJsonErrorSchema = z.unknown();

export const postV2ImportsJsonDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
      user_id: z.number().optional(),
    })
    .optional(),
});

export const postV2ImportsJsonResponseSchema = importSchema;

export const postV2ImportsJsonErrorSchema = z.unknown();

export const deleteV2ImportsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      undo: z.string().optional(),
    })
    .optional(),
});

export const deleteV2ImportsByIdJsonResponseSchema = z.any();

export const deleteV2ImportsByIdJsonErrorSchema = z.unknown();

export const getV2ImportsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2ImportsByIdJsonResponseSchema = importSchema;

export const getV2ImportsByIdJsonErrorSchema = z.unknown();

export const putV2ImportsByIdJsonDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
      user_id: z.number().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const putV2ImportsByIdJsonResponseSchema = importSchema;

export const putV2ImportsByIdJsonErrorSchema = z.unknown();

export const postV2LiveWebsiteTrackingParametersJsonDataSchema = z.object({
  body: z.object({
    person_id: z.number(),
  }),
});

export const postV2LiveWebsiteTrackingParametersJsonResponseSchema = liveWebsiteTrackingParameterSchema;

export const postV2LiveWebsiteTrackingParametersJsonErrorSchema = z.unknown();

export const getV2MeJsonResponseSchema = userSchema;

export const getV2MeJsonErrorSchema = z.unknown();

export const getV2MeetingsJsonDataSchema = z.object({
  query: z
    .object({
      account_id: z.string().optional(),
      created_at: z.array(z.string()).optional(),
      event_ids: z.array(z.string()).optional(),
      i_cal_uids: z.array(z.string()).optional(),
      ids: z.array(z.number()).optional(),
      include_meetings_settings: z.boolean().optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      person_id: z.string().optional(),
      person_ids: z.array(z.number()).optional(),
      show_deleted: z.boolean().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      start_time: z.array(z.string()).optional(),
      status: z.string().optional(),
      task_ids: z.array(z.number()).optional(),
      user_guids: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getV2MeetingsJsonResponseSchema = z.array(meetingSchema);

export const getV2MeetingsJsonErrorSchema = z.unknown();

export const postV2MeetingsSettingsSearchesJsonDataSchema = z.object({
  query: z
    .object({
      calendar_type: z.string().optional(),
      include_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      updated_at: z.array(z.string()).optional(),
      user_guids: z.array(z.string()).optional(),
    })
    .optional(),
});

export const meetingSettingSchema = z.object({
  active_meeting_url: meetingUrlSchema.optional(),
  allow_booking_on_behalf: z.boolean().optional(),
  allow_booking_overtime: z.boolean().optional(),
  allow_event_overlap: z.boolean().optional(),
  availability_limit: z.number().optional(),
  availability_limit_enabled: z.boolean().optional(),
  buffer_time_duration: z.number().optional(),
  calendar_type: z.string().optional(),
  created_at: z.string().optional(),
  default_meeting_length: z.number().optional(),
  description: z.string().optional(),
  email_address: z.string().optional(),
  enable_calendar_sync: z.boolean().optional(),
  enable_dynamic_location: z.boolean().optional(),
  id: z.number().optional(),
  location: z.string().optional(),
  primary_calendar_connection_failed: z.boolean().optional(),
  primary_calendar_id: z.string().optional(),
  primary_calendar_name: z.string().optional(),
  reschedule_meetings_enabled: z.boolean().optional(),
  schedule_buffer_enabled: z.boolean().optional(),
  schedule_delay: z.number().optional(),
  share_event_detail: z.boolean().optional(),
  time_zone: z.string().optional(),
  times_available: z.record(z.unknown()).optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
  user: embeddedResourceSchema.optional(),
  user_details: z.record(z.unknown()).optional(),
  user_slug: z.string().optional(),
});

export const postV2MeetingsSettingsSearchesJsonErrorSchema = z.unknown();

export const putV2MeetingsSettingsByIdJsonDataSchema = z.object({
  body: z
    .object({
      allow_booking_on_behalf: z.boolean().optional(),
      allow_booking_overtime: z.boolean().optional(),
      allow_event_overlap: z.boolean().optional(),
      availability_limit: z.number().optional(),
      availability_limit_enabled: z.boolean().optional(),
      buffer_time_duration: z.number().optional(),
      calendar_type: z.string().optional(),
      default_meeting_length: z.number().optional(),
      description: z.string().optional(),
      enable_calendar_sync: z.boolean().optional(),
      enable_dynamic_location: z.boolean().optional(),
      location: z.string().optional(),
      primary_calendar_connection_failed: z.boolean().optional(),
      primary_calendar_id: z.string().optional(),
      primary_calendar_name: z.string().optional(),
      reschedule_meetings_enabled: z.boolean().optional(),
      schedule_buffer_enabled: z.boolean().optional(),
      schedule_delay: z.number().optional(),
      share_event_detail: z.boolean().optional(),
      time_zone: z.string().optional(),
      times_available: z.record(z.unknown()).optional(),
      title: z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const putV2MeetingsSettingsByIdJsonResponseSchema = meetingSettingSchema;

export const putV2MeetingsSettingsByIdJsonErrorSchema = z.unknown();

export const putV2MeetingsByIdJsonDataSchema = z.object({
  body: z
    .object({
      event_id: z.string().optional(),
      i_cal_uid: z.string().optional(),
      no_show: z.boolean().optional(),
      reschedule_status: z.string().optional(),
      status: z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const putV2MeetingsByIdJsonResponseSchema = meetingSchema;

export const putV2MeetingsByIdJsonErrorSchema = z.unknown();

export const getV2MimeEmailPayloadsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2MimeEmailPayloadsByIdJsonResponseSchema = mimeEmailPayloadSchema;

export const getV2MimeEmailPayloadsByIdJsonErrorSchema = z.unknown();

export const getV2NotesJsonDataSchema = z.object({
  query: z
    .object({
      associated_with_id: z.number().optional(),
      associated_with_type: z.string().optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      updated_at: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getV2NotesJsonResponseSchema = z.array(noteSchema);

export const getV2NotesJsonErrorSchema = z.unknown();

export const postV2NotesJsonDataSchema = z.object({
  body: z.object({
    associated_with_id: z.number(),
    associated_with_type: z.string(),
    call_id: z.number().optional(),
    content: z.string(),
    skip_crm_sync: z.boolean().optional(),
    subject: z.string().optional(),
    user_guid: z.string().optional(),
  }),
});

export const postV2NotesJsonResponseSchema = noteSchema;

export const postV2NotesJsonErrorSchema = z.unknown();

export const deleteV2NotesByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteV2NotesByIdJsonResponseSchema = z.any();

export const deleteV2NotesByIdJsonErrorSchema = z.unknown();

export const getV2NotesByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2NotesByIdJsonResponseSchema = noteSchema;

export const getV2NotesByIdJsonErrorSchema = z.unknown();

export const putV2NotesByIdJsonDataSchema = z.object({
  body: z.object({
    call_id: z.number().optional(),
    content: z.string(),
  }),
  path: z.object({
    id: z.string(),
  }),
});

export const putV2NotesByIdJsonResponseSchema = personSchema;

export const putV2NotesByIdJsonErrorSchema = z.unknown();

export const postV2OngoingActionsJsonDataSchema = z.object({
  body: z
    .object({
      action_id: z.number().optional(),
    })
    .optional(),
});

export const postV2OngoingActionsJsonResponseSchema = actionSchema;

export const postV2OngoingActionsJsonErrorSchema = z.unknown();

export const getV2PendingEmailsJsonDataSchema = z.object({
  query: z
    .object({
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
    })
    .optional(),
});

export const getV2PendingEmailsJsonResponseSchema = z.array(pendingEmailSchema);

export const getV2PendingEmailsJsonErrorSchema = z.unknown();

export const putV2PendingEmailsByIdJsonDataSchema = z.object({
  body: z.object({
    error_message: z.string().optional(),
    message_id: z.string(),
    sent_at: z.string().optional(),
    status: z.string(),
  }),
  path: z.object({
    id: z.string(),
  }),
});

export const putV2PendingEmailsByIdJsonResponseSchema = pendingEmailSchema;

export const putV2PendingEmailsByIdJsonErrorSchema = z.unknown();

export const getV2PeopleJsonDataSchema = z.object({
  query: z
    .object({
      _query: z.string().optional(),
      account_id: z.array(z.number()).optional(),
      bounced: z.boolean().optional(),
      cadence_id: z.array(z.number()).optional(),
      can_call: z.boolean().optional(),
      can_email: z.boolean().optional(),
      can_text: z.boolean().optional(),
      city: z.array(z.string()).optional(),
      country: z.array(z.string()).optional(),
      created_at: z.record(z.unknown()).optional(),
      crm_id: z.array(z.string()).optional(),
      custom_fields: z.record(z.unknown()).optional(),
      do_not_contact: z.boolean().optional(),
      email_addresses: z.array(z.string()).optional(),
      eu_resident: z.boolean().optional(),
      ids: z.array(z.number()).optional(),
      import_id: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      job_seniority: z.array(z.string()).optional(),
      last_contacted: z.record(z.unknown()).optional(),
      limit_paging_counts: z.boolean().optional(),
      locales: z.array(z.string()).optional(),
      new: z.boolean().optional(),
      owned_by_guid: z.array(z.string()).optional(),
      owner_crm_id: z.array(z.string()).optional(),
      owner_id: z.array(z.number()).optional(),
      owner_is_active: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      person_stage_id: z.array(z.number()).optional(),
      phone_number: z.boolean().optional(),
      replied: z.boolean().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      starred_by_guid: z.array(z.string()).optional(),
      state: z.array(z.string()).optional(),
      success: z.boolean().optional(),
      tag_id: z.array(z.number()).optional(),
      title: z.array(z.string()).optional(),
      updated_at: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getV2PeopleJsonResponseSchema = z.array(personSchema);

export const getV2PeopleJsonErrorSchema = z.unknown();

export const postV2PeopleJsonDataSchema = z.object({
  body: z
    .object({
      account_id: z.number().optional(),
      autotag_date: z.boolean().optional(),
      city: z.string().optional(),
      contact_restrictions: z.array(z.string()).optional(),
      country: z.string().optional(),
      crm_id: z.string().optional(),
      crm_id_type: z.string().optional(),
      custom_fields: z.record(z.unknown()).optional(),
      do_not_contact: z.boolean().optional(),
      email_address: z.string().optional(),
      first_name: z.string().optional(),
      home_phone: z.string().optional(),
      import_id: z.number().optional(),
      job_seniority: z.string().optional(),
      last_name: z.string().optional(),
      linkedin_url: z.string().optional(),
      locale: z.string().optional(),
      mobile_phone: z.string().optional(),
      owner_id: z.number().optional(),
      person_company_industry: z.string().optional(),
      person_company_name: z.string().optional(),
      person_company_website: z.string().optional(),
      person_stage_id: z.number().optional(),
      personal_email_address: z.string().optional(),
      personal_website: z.string().optional(),
      phone: z.string().optional(),
      phone_extension: z.string().optional(),
      secondary_email_address: z.string().optional(),
      state: z.string().optional(),
      tags: z.array(z.string()).optional(),
      title: z.string().optional(),
      twitter_handle: z.string().optional(),
      work_city: z.string().optional(),
      work_country: z.string().optional(),
      work_state: z.string().optional(),
    })
    .optional(),
});

export const postV2PeopleJsonResponseSchema = personSchema;

export const postV2PeopleJsonErrorSchema = z.unknown();

export const deleteV2PeopleByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteV2PeopleByIdJsonResponseSchema = z.any();

export const deleteV2PeopleByIdJsonErrorSchema = z.unknown();

export const getV2PeopleByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2PeopleByIdJsonResponseSchema = personSchema;

export const getV2PeopleByIdJsonErrorSchema = z.unknown();

export const putV2PeopleByIdJsonDataSchema = z.object({
  body: z
    .object({
      account_id: z.number().optional(),
      city: z.string().optional(),
      contact_restrictions: z.array(z.string()).optional(),
      country: z.string().optional(),
      crm_id: z.string().optional(),
      crm_id_type: z.string().optional(),
      custom_fields: z.record(z.unknown()).optional(),
      do_not_contact: z.boolean().optional(),
      email_address: z.string().optional(),
      first_name: z.string().optional(),
      home_phone: z.string().optional(),
      import_id: z.number().optional(),
      job_seniority: z.string().optional(),
      last_name: z.string().optional(),
      linkedin_url: z.string().optional(),
      locale: z.string().optional(),
      mobile_phone: z.string().optional(),
      owner_id: z.number().optional(),
      person_company_industry: z.string().optional(),
      person_company_name: z.string().optional(),
      person_company_website: z.string().optional(),
      person_stage_id: z.number().optional(),
      personal_email_address: z.string().optional(),
      personal_website: z.string().optional(),
      phone: z.string().optional(),
      phone_extension: z.string().optional(),
      secondary_email_address: z.string().optional(),
      state: z.string().optional(),
      tags: z.array(z.string()).optional(),
      title: z.string().optional(),
      twitter_handle: z.string().optional(),
      work_city: z.string().optional(),
      work_country: z.string().optional(),
      work_state: z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const putV2PeopleByIdJsonResponseSchema = personSchema;

export const putV2PeopleByIdJsonErrorSchema = z.unknown();

export const getV2PersonStagesJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
    })
    .optional(),
});

export const getV2PersonStagesJsonResponseSchema = z.array(personStageSchema);

export const getV2PersonStagesJsonErrorSchema = z.unknown();

export const postV2PersonStagesJsonDataSchema = z.object({
  body: z.object({
    name: z.string(),
  }),
});

export const postV2PersonStagesJsonResponseSchema = personStageSchema;

export const postV2PersonStagesJsonErrorSchema = z.unknown();

export const deleteV2PersonStagesByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteV2PersonStagesByIdJsonResponseSchema = z.any();

export const deleteV2PersonStagesByIdJsonErrorSchema = z.unknown();

export const getV2PersonStagesByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2PersonStagesByIdJsonResponseSchema = personStageSchema;

export const getV2PersonStagesByIdJsonErrorSchema = z.unknown();

export const putV2PersonStagesByIdJsonDataSchema = z.object({
  body: z.object({
    name: z.string(),
  }),
  path: z.object({
    id: z.string(),
  }),
});

export const putV2PersonStagesByIdJsonResponseSchema = personStageSchema;

export const putV2PersonStagesByIdJsonErrorSchema = z.unknown();

export const postV2PersonUpsertsJsonDataSchema = z.object({
  body: z
    .object({
      account_id: z.number().optional(),
      city: z.string().optional(),
      contact_restrictions: z.array(z.string()).optional(),
      country: z.string().optional(),
      crm_id: z.string().optional(),
      crm_id_type: z.string().optional(),
      custom_fields: z.record(z.unknown()).optional(),
      do_not_contact: z.boolean().optional(),
      email_address: z.string().optional(),
      first_name: z.string().optional(),
      home_phone: z.string().optional(),
      id: z.number().optional(),
      import_id: z.number().optional(),
      job_seniority: z.string().optional(),
      last_name: z.string().optional(),
      linkedin_url: z.string().optional(),
      locale: z.string().optional(),
      mobile_phone: z.string().optional(),
      owner_id: z.number().optional(),
      person_company_industry: z.string().optional(),
      person_company_name: z.string().optional(),
      person_company_website: z.string().optional(),
      person_stage_id: z.number().optional(),
      personal_email_address: z.string().optional(),
      personal_website: z.string().optional(),
      phone: z.string().optional(),
      phone_extension: z.string().optional(),
      secondary_email_address: z.string().optional(),
      state: z.string().optional(),
      tags: z.array(z.string()).optional(),
      title: z.string().optional(),
      twitter_handle: z.string().optional(),
      upsert_key: z.string().optional(),
      work_city: z.string().optional(),
      work_country: z.string().optional(),
      work_state: z.string().optional(),
    })
    .optional(),
});

export const personUpsertSchema = z.object({
  person: personSchema.optional(),
  upsert_type: z.string().optional(),
});

export const postV2PersonUpsertsJsonErrorSchema = z.unknown();

export const getV2PhoneNumberAssignmentsJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
    })
    .optional(),
});

export const getV2PhoneNumberAssignmentsJsonResponseSchema = z.array(phoneNumberAssignmentSchema);

export const getV2PhoneNumberAssignmentsJsonErrorSchema = z.unknown();

export const getV2PhoneNumberAssignmentsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2PhoneNumberAssignmentsByIdJsonResponseSchema = phoneNumberAssignmentSchema;

export const getV2PhoneNumberAssignmentsByIdJsonErrorSchema = z.unknown();

export const getV2PhoneNumbersCallerIdsJsonDataSchema = z.object({
  query: z.object({
    phone_number: z.string(),
  }),
});

export const getV2PhoneNumbersCallerIdsJsonResponseSchema = z.array(callerIdSchema);

export const getV2PhoneNumbersCallerIdsJsonErrorSchema = z.unknown();

export const getV2PhoneNumbersRecordingSettingsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2PhoneNumbersRecordingSettingsByIdJsonResponseSchema = recordingSettingSchema;

export const getV2PhoneNumbersRecordingSettingsByIdJsonErrorSchema = z.unknown();

export const getV2SavedListViewsJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      view: z.string().optional(),
    })
    .optional(),
});

export const getV2SavedListViewsJsonResponseSchema = z.array(savedListViewSchema);

export const getV2SavedListViewsJsonErrorSchema = z.unknown();

export const postV2SavedListViewsJsonDataSchema = z.object({
  body: z.object({
    is_default: z.boolean().optional(),
    name: z.string(),
    view: z.string(),
    view_params: z.string().optional(),
  }),
});

export const postV2SavedListViewsJsonResponseSchema = savedListViewSchema;

export const postV2SavedListViewsJsonErrorSchema = z.unknown();

export const deleteV2SavedListViewsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteV2SavedListViewsByIdJsonResponseSchema = z.any();

export const deleteV2SavedListViewsByIdJsonErrorSchema = z.unknown();

export const getV2SavedListViewsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2SavedListViewsByIdJsonResponseSchema = savedListViewSchema;

export const getV2SavedListViewsByIdJsonErrorSchema = z.unknown();

export const putV2SavedListViewsByIdJsonDataSchema = z.object({
  body: z
    .object({
      is_default: z.boolean().optional(),
      name: z.string().optional(),
      view_params: z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const putV2SavedListViewsByIdJsonResponseSchema = savedListViewSchema;

export const putV2SavedListViewsByIdJsonErrorSchema = z.unknown();

export const getV2StepsJsonDataSchema = z.object({
  query: z
    .object({
      cadence_id: z.number().optional(),
      has_due_actions: z.boolean().optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const getV2StepsJsonResponseSchema = z.array(stepSchema);

export const getV2StepsJsonErrorSchema = z.unknown();

export const getV2StepsByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2StepsByIdJsonResponseSchema = stepSchema;

export const getV2StepsByIdJsonErrorSchema = z.unknown();

export const getV2SuccessesJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      person_id: z.array(z.number()).optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      updated_at: z.array(z.string()).optional(),
    })
    .optional(),
});

export const successSchema = z.object({
  counts: successCountsSchema.optional(),
  created_at: z.string().optional(),
  id: z.number().optional(),
  latest_action: embeddedResourceSchema.optional(),
  latest_cadence: embeddedResourceSchema.optional(),
  latest_call: embeddedResourceSchema.optional(),
  latest_email: embeddedResourceSchema.optional(),
  latest_step: embeddedResourceSchema.optional(),
  person: embeddedResourceSchema.optional(),
  succeeded_at: z.string().optional(),
  success_window_started_at: z.string().optional(),
  updated_at: z.string().optional(),
  user: embeddedResourceSchema.optional(),
});

export const getV2SuccessesJsonErrorSchema = z.unknown();

export const getV2TagsJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      search: z.string().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
    })
    .optional(),
});

export const getV2TagsJsonResponseSchema = z.array(tagSchema);

export const getV2TagsJsonErrorSchema = z.unknown();

export const getV2TasksJsonDataSchema = z.object({
  query: z
    .object({
      account_id: z.array(z.number()).optional(),
      current_state: z.array(z.string()).optional(),
      idempotency_key: z.string().optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      locale: z.array(z.string()).optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      person_id: z.array(z.number()).optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      task_type: z.array(z.string()).optional(),
      time_interval_filter: z.string().optional(),
      user_id: z.array(z.number()).optional(),
    })
    .optional(),
});

export const getV2TasksJsonResponseSchema = z.array(taskSchema);

export const getV2TasksJsonErrorSchema = z.unknown();

export const postV2TasksJsonDataSchema = z.object({
  body: z.object({
    current_state: z.string(),
    description: z.string().optional(),
    due_date: z.string(),
    idempotency_key: z.string().optional(),
    person_id: z.string(),
    remind_at: z.string().optional(),
    subject: z.string(),
    task_type: z.string(),
    user_id: z.number(),
  }),
});

export const postV2TasksJsonResponseSchema = taskSchema;

export const postV2TasksJsonErrorSchema = z.unknown();

export const getV2TasksByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2TasksByIdJsonResponseSchema = stepSchema;

export const getV2TasksByIdJsonErrorSchema = z.unknown();

export const putV2TasksByIdJsonDataSchema = z.object({
  body: z
    .object({
      current_state: z.string().optional(),
      description: z.string().optional(),
      due_date: z.string().optional(),
      is_logged: z.boolean().optional(),
      remind_at: z.string().optional(),
      subject: z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const putV2TasksByIdJsonResponseSchema = taskSchema;

export const putV2TasksByIdJsonErrorSchema = z.unknown();

export const getV2TeamJsonResponseSchema = teamSchema;

export const getV2TeamJsonErrorSchema = z.unknown();

export const getV2TeamTemplateAttachmentsJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      team_template_id: z.array(z.number()).optional(),
    })
    .optional(),
});

export const getV2TeamTemplateAttachmentsJsonResponseSchema = z.array(teamTemplateAttachmentSchema);

export const getV2TeamTemplateAttachmentsJsonErrorSchema = z.unknown();

export const getV2TeamTemplatesJsonDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.string()).optional(),
      include_archived_templates: z.boolean().optional(),
      include_paging_counts: z.boolean().optional(),
      limit_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      search: z.string().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      tag: z.array(z.string()).optional(),
      tag_ids: z.array(z.number()).optional(),
      updated_at: z.array(z.string()).optional(),
    })
    .optional(),
});

export const teamTemplateSchema = z.object({
  _links: z.record(z.unknown()).optional(),
  archived_at: z.string().optional(),
  body: z.string().optional(),
  body_preview: z.string().optional(),
  click_tracking_enabled: z.boolean().optional(),
  counts: teamTemplateCountsSchema.optional(),
  created_at: z.string().optional(),
  id: z.string().optional(),
  last_modified_at: z.string().optional(),
  last_modified_user: embeddedResourceSchema.optional(),
  last_used_at: z.string().optional(),
  open_tracking_enabled: z.boolean().optional(),
  subject: z.string().optional(),
  tags: z.array(z.string()).optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
});

export const getV2TeamTemplatesJsonErrorSchema = z.unknown();

export const getV2TeamTemplatesByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      include_signature: z.boolean().optional(),
    })
    .optional(),
});

export const getV2TeamTemplatesByIdJsonResponseSchema = teamTemplateSchema;

export const getV2TeamTemplatesByIdJsonErrorSchema = z.unknown();

export const postV2ThirdPartyLiveFeedItemsDataSchema = z.object({
  body: z.object({
    event_occurred_at: z.string(),
    idempotency_key: z.string(),
    message: z.string(),
    subject_id: z.number(),
    subject_type: z.string(),
    user_guid: z.string(),
  }),
});

export const postV2ThirdPartyLiveFeedItemsResponseSchema = z.array(liveFeedItemSchema);

export const postV2ThirdPartyLiveFeedItemsErrorSchema = z.unknown();

export const getV2UsersJsonDataSchema = z.object({
  query: z
    .object({
      active: z.boolean().optional(),
      group_id: z.array(z.string()).optional(),
      guid: z.array(z.string()).optional(),
      has_crm_user: z.boolean().optional(),
      ids: z.array(z.number()).optional(),
      include_paging_counts: z.boolean().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      role_id: z.array(z.string()).optional(),
      search: z.string().optional(),
      sort_by: z.string().optional(),
      sort_direction: z.string().optional(),
      visible_only: z.boolean().optional(),
      work_country: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getV2UsersJsonResponseSchema = z.array(userSchema);

export const getV2UsersJsonErrorSchema = z.unknown();

export const getV2UsersByIdJsonDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getV2UsersByIdJsonResponseSchema = userSchema;

export const getV2UsersByIdJsonErrorSchema = z.unknown();

export const putV2UsersByIdJsonDataSchema = z.object({
  body: z
    .object({
      active: z.boolean().optional(),
      group_id: z.number().optional(),
      role_id: z.string().optional(),
      work_country: z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const putV2UsersByIdJsonResponseSchema = userSchema;

export const putV2UsersByIdJsonErrorSchema = z.unknown();

export const getV2WebhookSubscriptionsDataSchema = z.object({
  query: z
    .object({
      enabled: z.boolean().optional(),
    })
    .optional(),
});

export const getV2WebhookSubscriptionsResponseSchema = z.array(subscriptionSchema);

export const getV2WebhookSubscriptionsErrorSchema = z.unknown();

export const postV2WebhookSubscriptionsDataSchema = z.object({
  body: z.object({
    callback_token: z.string(),
    callback_url: z.string(),
    event_type: z.string(),
  }),
});

export const postV2WebhookSubscriptionsResponseSchema = subscriptionSchema;

export const postV2WebhookSubscriptionsErrorSchema = z.unknown();

export const deleteV2WebhookSubscriptionsByIdDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const deleteV2WebhookSubscriptionsByIdResponseSchema = z.any();

export const deleteV2WebhookSubscriptionsByIdErrorSchema = z.unknown();

export const getV2WebhookSubscriptionsByIdDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const getV2WebhookSubscriptionsByIdResponseSchema = subscriptionSchema;

export const getV2WebhookSubscriptionsByIdErrorSchema = z.unknown();

export const putV2WebhookSubscriptionsByIdDataSchema = z.object({
  body: z
    .object({
      enabled: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const putV2WebhookSubscriptionsByIdResponseSchema = subscriptionSchema;

export const putV2WebhookSubscriptionsByIdErrorSchema = z.unknown();

export const postV2AccountUpsertsJsonResponseSchema = accountUpsertSchema;

export const getV2ActivitiesCallsJsonResponseSchema = z.array(callSchema);

export const getV2ActivitiesEmailsJsonResponseSchema = z.array(emailSchema);

export const getV2CadenceMembershipsJsonResponseSchema = z.array(cadenceMembershipSchema);

export const getV2CadencesJsonResponseSchema = z.array(cadenceSchema);

export const getV2EmailTemplatesJsonResponseSchema = z.array(emailTemplateSchema);

export const postV2MeetingsSettingsSearchesJsonResponseSchema = z.array(meetingSettingSchema);

export const postV2PersonUpsertsJsonResponseSchema = personUpsertSchema;

export const getV2SuccessesJsonResponseSchema = z.array(successSchema);

export const getV2TeamTemplatesJsonResponseSchema = z.array(teamTemplateSchema);
