// This file is auto-generated by @hey-api/openapi-ts

export type Account = {
  account_tier?: EmbeddedResource;
  /**
   * Datetime of when the Account was archived, if archived
   */
  archived_at?: string;
  /**
   * City
   */
  city?: string;
  company_stage?: EmbeddedResource;
  /**
   * Type of the Account's company
   */
  company_type?: string;
  /**
   * Conversational name of the Account
   */
  conversational_name?: string;
  /**
   * Country
   */
  country?: string;
  counts?: EmbeddedAccountCounts;
  /**
   * Datetime of when the Account was created
   */
  created_at?: string;
  creator?: EmbeddedResource;
  /**
   * CRM ID
   */
  crm_id?: string;
  /**
   * CRM object type
   */
  crm_object_type?: string;
  /**
   * CRM url
   */
  crm_url?: string;
  /**
   * Custom fields are defined by the user's team. Only fields with values are presented in the API.
   */
  custom_fields?: {
    [key: string]: unknown;
  };
  /**
   * Description
   */
  description?: string;
  /**
   * Whether this company has opted out of communications. Do not contact someone at this company when this is set to true
   */
  do_not_contact?: boolean;
  /**
   * Website domain, not a fully qualified URI
   */
  domain?: string;
  /**
   * Date or year of founding
   */
  founded?: string;
  /**
   * ID of Account
   */
  id?: number;
  /**
   * Industry
   */
  industry?: string;
  /**
   * Datetime this Account was last contacted
   */
  last_contacted_at?: string;
  last_contacted_by?: EmbeddedResource;
  last_contacted_person?: EmbeddedResource;
  /**
   * The type of the last touch to this Account. Can be call, email, other
   */
  last_contacted_type?: string;
  /**
   * Full LinkedIn url
   */
  linkedin_url?: string;
  /**
   * Time locale
   */
  locale?: string;
  /**
   * Account Full Name
   */
  name?: string;
  owner?: EmbeddedResource;
  /**
   * Mapped owner field from the CRM
   */
  owner_crm_id?: string;
  /**
   * Phone number without formatting
   */
  phone?: string;
  /**
   * Postal code
   */
  postal_code?: string;
  /**
   * Estimated revenue range
   */
  revenue_range?: string;
  /**
   * Estimated number of people in employment
   */
  size?: string;
  /**
   * State
   */
  state?: string;
  /**
   * Street name and number
   */
  street?: string;
  /**
   * All tags applied to this Account
   */
  tags?: Array<string>;
  /**
   * Twitter handle, with @
   */
  twitter_handle?: string;
  /**
   * Datetime of when the Account was last updated
   */
  updated_at?: string;
  /**
   * Filters by accounts matching all given user relationship fields, _is_null or _unmapped can be passed to filter accounts with null or unmapped user relationship values
   */
  user_relationships?: {
    [key: string]: unknown;
  };
  /**
   * Website
   */
  website?: string;
};

export type AccountStage = {
  /**
   * Datetime of when the Account Stage was created
   */
  created_at?: string;
  /**
   * ID of Account Stage
   */
  id?: number;
  /**
   * Name of Account Stage
   */
  name?: string;
  /**
   * Order of Account Stage
   */
  order?: number;
  /**
   * Datetime of when the Account Stage was last updated
   */
  updated_at?: string;
};

export type AccountTier = {
  /**
   * Datetime of when the Account Tier was created
   */
  created_at?: string;
  /**
   * ID of Account Tier
   */
  id?: number;
  /**
   * Name of the Account Tier
   */
  name?: string;
  /**
   * The order of the account tier
   */
  order?: number;
  /**
   * Datetime of when the Account Tier was last updated
   */
  updated_at?: string;
};

export type AccountUpsert = {
  account?: Account;
  /**
   * The type of upsert. One of: create, update
   */
  upsert_type?: string;
};

export type Action = {
  action_details?: EmbeddedResource;
  cadence?: EmbeddedResource;
  /**
   * Datetime of when the Action was created
   */
  created_at?: string;
  /**
   * Whether this step is due
   */
  due?: boolean;
  /**
   * When action is due
   */
  due_on?: string;
  /**
   * ID of Action
   */
  id?: number;
  /**
   * ID of the multitouch group
   */
  multitouch_group_id?: number;
  person?: EmbeddedResource;
  /**
   * The current state of the person on the cadence. Possible values are:
   *
   * in_progress: this action has not been completed
   *
   * pending_activity: this action has been acted upon, but the action has not been completed.
   * (i.e. the email is scheduled to send, but has not been delivered yet)
   *
   */
  status?: string;
  step?: EmbeddedResource;
  /**
   * The type of this action. Valid types are: email, phone, other. New types may be added in the future.
   *
   */
  type?: string;
  /**
   * Datetime of when the Action was last updated
   */
  updated_at?: string;
  user?: EmbeddedResource;
};

export type Activity = {
  /**
   * Datetime of when the Activity was last updated
   */
  updated_at?: string;
};

export type ActivityHistory = {
  /**
   * When this record was created
   */
  created_at?: string;
  /**
   * Attributes from associated records. This is specific to the type of activity and may change over time. Not returned for create requests
   */
  dynamic_data?: {
    [key: string]: unknown;
  };
  /**
   * A list of remote resource names that failed to load. This is specific to the type of activity and may change over time. Not returned for create requests
   */
  failed_dynamic_resources?: {
    [key: string]: unknown;
  };
  /**
   * ID of this activity
   */
  id?: number;
  /**
   * When this activity occurred
   */
  occurred_at?: string;
  /**
   * When this record was pinned
   */
  pinned_at?: string;
  /**
   * ID of the resource this activity is for. It will be a string for the following resource types: crm_opportunity
   */
  resource_id?: number;
  /**
   * Type of the resource this activity is for. One of: account, person
   */
  resource_type?: number;
  /**
   * The static data for this activity
   */
  static_data?: {
    [key: string]: unknown;
  };
  /**
   * The type of activity
   */
  type?: string;
  /**
   * When this record was updated
   */
  updated_at?: string;
  /**
   * UUID of the user this activity is for
   */
  user_guid?: string;
};

export type BulkJob = {
  /**
   * When this bulk job was created
   */
  created_at?: string;
  /**
   * Number of errored records at the time of request for this Bulk Job
   */
  errors?: number;
  /**
   * When this bulk job finished processing
   */
  finished_at?: string;
  /**
   * ID of this Bulk Job
   */
  id?: number;
  /**
   * When this bulk job was marked as ready to execute
   */
  marked_ready_at?: string;
  /**
   * Name of this Bulk Job
   */
  name?: string;
  /**
   * Number of processed records at the time of request for this Bulk Job
   */
  processed?: number;
  /**
   * Whether the Bulk Job is ready to be executed
   */
  ready_to_execute?: boolean;
  /**
   * Scopes
   */
  scopes?: Array<unknown>;
  /**
   * When this bulk job started processing. null until bulk job is done
   */
  started_at?: string;
  /**
   * State of the Bulk Job.  Must be one of: open, executing, done.
   */
  state?: string;
  /**
   * Number of total records for this Bulk Job
   */
  total?: number;
  /**
   * Type of the Bulk Job.
   */
  type?: string;
  /**
   * When this bulk job was updated
   */
  updated_at?: string;
};

export type BulkJobResult = {
  /**
   * Error message for the record that was processed. Will be null if there was no error.
   */
  error?: string;
  /**
   * ID of the record that was processed
   */
  id?: number;
  /**
   * The data that was used to process the operation
   */
  record?: {
    [key: string]: unknown;
  };
  /**
   * The object containing the resulting resource from performing the bulk action on this record
   */
  resource?: {
    [key: string]: unknown;
  };
  /**
   * Status of the record that was processed. Will be one of: success, error
   */
  status?: string;
};

export type Cadence = {
  added_stage?: EmbeddedResource;
  /**
   * Datetime of when the cadence was archived, if archived
   */
  archived_at?: string;
  bounced_stage?: EmbeddedResource;
  /**
   * ID of the cadence framework used to create steps for the cadence
   */
  cadence_framework_id?: number;
  /**
   * The use case of the cadence. Possible values are:
   *
   * outbound: Denotes an outbound cadence, typically for sales purposes
   *
   * inbound: Denotes an inbound sales cadence
   *
   * event: Denotes a cadence used for an upcoming event
   *
   * other: Denotes a cadence outside of the standard process
   *
   */
  cadence_function?: string;
  cadence_priority?: EmbeddedResource;
  counts?: CadenceCounts;
  /**
   * Datetime of when the cadence was created
   */
  created_at?: string;
  creator?: EmbeddedResource;
  /**
   * Whether this cadence is in draft mode
   */
  draft?: boolean;
  /**
   * Cadence External ID
   */
  external_identifier?: string;
  finished_stage?: EmbeddedResource;
  /**
   * Groups to which this cadence is assigned, if any
   */
  groups?: Array<EmbeddedResource>;
  /**
   * ID of cadence
   */
  id?: number;
  /**
   * Cadence name
   */
  name?: string;
  /**
   * Whether this cadence is configured to include an opt-out link by default
   */
  opt_out_link_included?: boolean;
  owner?: EmbeddedResource;
  /**
   * Whether this cadence is configured to automatically remove people who have bounced
   */
  remove_bounces_enabled?: boolean;
  /**
   * Whether this cadence is configured to automatically remove people who have replied
   */
  remove_replies_enabled?: boolean;
  replied_stage?: EmbeddedResource;
  /**
   * Whether this cadence is visible to team members (shared)
   */
  shared?: boolean;
  /**
   * All tags applied to this cadence
   */
  tags?: Array<string>;
  /**
   * Whether this cadence is a team cadence.  A team cadence is created by an admin and can be run by all users
   */
  team_cadence?: boolean;
  /**
   * Datetime of when the cadence was last updated
   */
  updated_at?: string;
};

export type CadenceCounts = {
  /**
   * The number of people that have ever been added to the cadence
   */
  cadence_people?: number;
  /**
   * The number of meetings booked and attributed to the cadence
   */
  meetings_booked?: number;
  /**
   * The number of opportunities created and attributed to the cadence
   */
  opportunities_created?: number;
  /**
   * The number of people that have been skipped, scheduled, or advanced in a cadence
   */
  people_acted_on_count?: number;
  /**
   * The user defined target for number of people to add to the cadence each day
   */
  target_daily_people?: number;
};

export type CadenceExport = {
  /**
   * The content of the cadence
   */
  cadence_content?: {
    [key: string]: unknown;
  };
};

export type CadenceImport = {
  cadence?: EmbeddedResource;
};

export type CadenceMembership = {
  /**
   * Datetime of when the person was last added to this cadence
   */
  added_at?: string;
  cadence?: EmbeddedResource;
  counts?: CadenceMembershipCounts;
  /**
   * Datetime of when the person was first added to this cadence
   */
  created_at?: string;
  /**
   * The current state of the person on the cadence. Possible values are:
   *
   * processing: The person is being processed on a cadence. Cadence-related changes cannot be made at this time
   *
   * staged: The person is waiting for the first step in the cadence to occur
   *
   * active: The cadence has begun processing this person and is still in the process, but idle
   *
   * scheduled: The cadence has begun processing this person and is still in the process, with an activity scheduled to occur
   *
   * completed: The cadence has been completed for this person
   *
   * removed: The person was manually or automatically removed from the cadence
   *
   * removed_no_action: The person was removed from the cadence before any action occurred
   *
   * reassigned: The person's cadence execution was transferred to a different user, ending this user's interaction
   *
   */
  current_state?: string;
  /**
   * Whether the person is currently on the cadence
   */
  currently_on_cadence?: boolean;
  /**
   * Cadence membership ID
   */
  id?: number;
  latest_action?: EmbeddedResource;
  person?: EmbeddedResource;
  /**
   * Whether the associated person has since been deleted
   */
  person_deleted?: boolean;
  /**
   * Datetime of when the record was last updated
   */
  updated_at?: string;
  user?: EmbeddedResource;
};

export type CadenceMembershipCounts = {
  /**
   * The number of times emails sent from the cadence to the person bounced
   */
  bounces?: number;
  /**
   * The number of times a call was logged from the cadence to the person
   */
  calls?: number;
  /**
   * The number of times emails sent from the cadence to the person were clicked
   */
  clicks?: number;
  /**
   * The number of times emails sent from the cadence to the person were replied to
   */
  replies?: number;
  /**
   * The number of times emails were sent from the cadence to the person
   */
  sent_emails?: number;
  /**
   * The number of times emails sent from the cadence to the person were opened
   */
  views?: number;
};

export type CalendarEvent = {
  /**
   * Whether the calendar event is an all-day event.
   */
  all_day?: boolean;
  /**
   * The attendees of the calendar event.
   */
  attendees?: Array<unknown>;
  /**
   * Raw body content from Microsoft calendar events
   */
  body_html?: string;
  /**
   * Busy/free status of the calendar event
   */
  busy?: boolean;
  /**
   * Calendar ID of the user calendar.
   */
  calendar_id?: string;
  /**
   * The canceled date of the calendar event.
   */
  canceled_at?: string;
  /**
   * The conference-related information, such as details of a Google Meet conference.
   */
  conference_data?: {
    [key: string]: unknown;
  };
  /**
   * Creation time of the calendar event.
   */
  created_at?: string;
  /**
   * The creator email of the calendar event.
   */
  creator?: string;
  /**
   * Description of the calendar event
   */
  description?: string;
  /**
   * The (exclusive) end time of the calendar event.
   */
  end_time?: string;
  /**
   * Extended properties of the calendar event.
   */
  extended_properties?: {
    [key: string]: unknown;
  };
  /**
   * An absolute link to this calendar event in the Google Calendar Web UI.
   */
  html_link?: string;
  /**
   * Calendar event unique identifier (iCalUID)
   */
  i_cal_uid?: string;
  /**
   * The calendar event original ID from calendar provider
   */
  id?: string;
  /**
   * Location of the calendar event
   */
  location?: string;
  /**
   * The organizer email of the calendar event.
   */
  organizer?: string;
  /**
   * The provider of the calendar event.
   */
  provider?: string;
  /**
   * Whether the calendar event is a recurring event.
   */
  recurring?: boolean;
  /**
   * The (inclusive) start time of the calendar event.
   */
  start_time?: string;
  /**
   * The status of the calendar event. It can be empty for non-google events.
   */
  status?: string;
  /**
   * Tenant ID of the user calendar
   */
  tenant_id?: number;
  /**
   * Title of the calendar event
   */
  title?: string;
  /**
   * Last modification time of the calendar event.
   */
  updated_at?: string;
  /**
   * User GUID of the user calendar.
   */
  user_guid?: string;
};

export type Call = {
  action?: EmbeddedResource;
  cadence?: EmbeddedResource;
  called_person?: EmbeddedResource;
  /**
   * Datetime of when the call was created
   */
  created_at?: string;
  crm_activity?: EmbeddedResource;
  /**
   * Result of the call
   */
  disposition?: string;
  /**
   * Length of the call in seconds
   */
  duration?: number;
  /**
   * ID of Call
   */
  id?: number;
  note?: EmbeddedResource;
  /**
   * The recordings for this this call and their status
   */
  recordings?: Array<EmbeddedRecordingResource>;
  /**
   * Outcome of the conversation
   */
  sentiment?: string;
  step?: EmbeddedResource;
  /**
   * Phone number that received the call
   */
  to?: string;
  /**
   * Datetime of when the call was last updated
   */
  updated_at?: string;
  user?: EmbeddedResource;
};

export type CallDataRecord = {
  call?: EmbeddedResource;
  /**
   * Type of the call. Can be one of: call, bridge, collaboration. Though exact values may change over time
   */
  call_type?: string;
  /**
   * UUID of the call. Legs of the same call will have the same call_uuid.
   */
  call_uuid?: string;
  called_person?: EmbeddedResource;
  /**
   * Datetime of when the call was created
   */
  created_at?: string;
  /**
   * Direction of the call. Can be one of: inbound, outbound
   */
  direction?: string;
  /**
   * Length of the call in seconds
   */
  duration?: number;
  /**
   * Phone number that placed the call
   */
  from?: string;
  /**
   * ID of CallDataRecord
   */
  id?: number;
  recording?: EmbeddedRecordingResource;
  /**
   * The outcome of the call. Can be one of: queued, initiated, ringing, in-progress, completed, busy, no-answer, canceled, failed
   */
  status?: string;
  /**
   * Phone number that received the call
   */
  to?: string;
  /**
   * Datetime of when the call was last updated
   */
  updated_at?: string;
  user?: EmbeddedResource;
};

export type CallDisposition = {
  /**
   * Datetime of when the call disposition was created
   */
  created_at?: string;
  /**
   * ID of CallDisposition
   */
  id?: number;
  /**
   * An available call disposition text
   */
  name?: string;
  /**
   * Datetime of when the call disposition was last updated
   */
  updated_at?: string;
};

export type CallInstruction = {
  /**
   * Datetime of when the call instructions were created
   */
  created_at?: string;
  /**
   * ID of call instructions
   */
  id?: number;
  /**
   * The instructions
   */
  instructions?: string;
  /**
   * Datetime of when the call instructions were last updated
   */
  updated_at?: string;
};

export type CallSentiment = {
  /**
   * Datetime of when the call sentiment was created
   */
  created_at?: string;
  /**
   * ID of CallSentiment
   */
  id?: number;
  /**
   * An available call sentiment text
   */
  name?: string;
  /**
   * Datetime of when the call sentiment was last updated
   */
  updated_at?: string;
};

export type CallerId = {
  /**
   * The account of the person calling
   */
  account_name?: string;
  /**
   * The name of the person calling
   */
  display_name?: string;
  person?: EmbeddedResource;
  /**
   * The title of the person calling
   */
  title?: string;
};

export type ConversationsCall = {
  /**
   * Timestamp for when the call started. If not provided, will default to the time the request was received
   */
  call_created_at?: string;
  /**
   * Call direction
   */
  direction?: string;
  /**
   * Duration of call in seconds
   */
  duration?: number;
  /**
   * Phone number that call was made from
   */
  from?: string;
  /**
   * Object containing recording info including the audio file (.mp3, .wav, .ogg, .m4a)
   */
  recording?: {
    [key: string]: unknown;
  };
  /**
   * Phone number that was called
   */
  to?: string;
  /**
   * Guid of the Salesloft User to assign the call to. If not provided, will default to the user within the authentication token
   */
  user_guid?: string;
};

export type CrmActivity = {
  /**
   * The type of activity that is being recorded, if available. The values can change over time, but could be one of: email, phone, email reminder, inmail
   */
  activity_type?: string;
  /**
   * Datetime of when the crm activity was created
   */
  created_at?: string;
  /**
   * The ID of the activity in your CRM, if written to your CRM
   */
  crm_id?: string;
  /**
   * Additional fields that are logged to your CRM, if mapped by the team at the time of writing to your CRM
   */
  custom_crm_fields?: {
    [key: string]: unknown;
  };
  /**
   * The description field of the activity in your CRM
   */
  description?: string;
  /**
   * Information about why this crm activity failed to sync, if it did fail to sync. Failed activities will be automatically retried and may become successful in the future
   */
  error?: string;
  /**
   * CrmActivity ID
   */
  id?: number;
  person?: EmbeddedResource;
  /**
   * The subject field of the activity in your CRM
   */
  subject?: string;
  /**
   * Datetime of when the crm activity was last updated
   */
  updated_at?: string;
  user?: EmbeddedResource;
};

export type CrmActivityField = {
  /**
   * Datetime of when the CrmActivityField was created
   */
  created_at?: string;
  /**
   * The CRM object type that this field maps to. Valid object types are CRM dependent: Task, Phonecall, Email.
   *
   */
  crm_object_type?: string;
  /**
   * The CRM field name
   */
  field?: string;
  /**
   * The type of this field in your CRM. Certain field types can only accept structured input.
   */
  field_type?: string;
  /**
   * ID of CrmActivityField
   */
  id?: number;
  /**
   * Valid picklist values, if present for this field. The format is {label => value}. If present, only
   * values in the picklist structure can be used as a crm param.
   *
   */
  picklist_values?: {
    [key: string]: unknown;
  };
  /**
   * The Salesforce object type that this field maps to. Valid object types are: Task.
   * More object types may be added in the future.
   *
   */
  salesforce_object_type?: string;
  /**
   * SalesLoft object that this field is mapped for. Valid sources are: email, phone
   */
  source?: string;
  /**
   * A human friendly title for this field
   */
  title?: string;
  /**
   * Datetime of when the CrmActivityField was last updated
   */
  updated_at?: string;
  /**
   * A value to always be written. This value does not need to be sent to other endpoints' crm params,
   * but must be the exact value if sent. Email source fields will always have a value present.
   *
   */
  value?: string;
};

export type CrmUser = {
  /**
   * Datetime of when the crm user was created
   */
  created_at?: string;
  /**
   * CRM ID
   */
  crm_id?: string;
  /**
   * Crm User ID
   */
  id?: number;
  /**
   * Datetime of when the crm user was last updated
   */
  updated_at?: string;
  user?: EmbeddedResource;
};

export type CustomField = {
  /**
   * Datetime of when the Custom Field was created
   */
  created_at?: string;
  /**
   * Type of the Custom Field. Value must be one of: person, company, opportunity.
   */
  field_type?: string;
  /**
   * ID of Custom Field
   */
  id?: number;
  /**
   * Name of the Custom Field
   */
  name?: string;
  /**
   * Datetime of when the Custom Field was last updated
   */
  updated_at?: string;
  /**
   * Value Type of the Custom Field. Value must be one of: text, date.
   */
  value_type?: string;
};

export type CustomRole = {
  /**
   * ID of the custom role
   */
  id?: string;
  /**
   * Name of the custom role
   */
  name?: string;
};

export type Email = {
  action?: EmbeddedResource;
  /**
   * Whether this email bounced
   */
  bounced?: boolean;
  cadence?: EmbeddedResource;
  /**
   * Whether this email had click tracking enabled
   */
  click_tracking?: boolean;
  counts?: EmailCounts;
  /**
   * Datetime of when the email was created
   */
  created_at?: string;
  crm_activity?: EmbeddedResource;
  email_template?: EmbeddedResource;
  /**
   * Error message of the email. This field has been determined sensitive and requires a specific scope to access it.
   */
  error_message?: string;
  /**
   * Selected headers that are included if this email used them. Available keys are: cc, bcc
   */
  headers?: {
    [key: string]: unknown;
  };
  /**
   * ID of Email
   */
  id?: number;
  mailing?: EmbeddedResource;
  /**
   * Percentage of this email that has been personalized
   */
  personalization?: string;
  recipient?: EmbeddedResource;
  /**
   * Email address of the recipient
   */
  recipient_email_address?: string;
  /**
   * When this email will be sent, or null if already sent
   */
  send_after?: string;
  /**
   * When this email was sent, or null if it was not sent
   */
  sent_at?: string;
  /**
   * Status of this email through the sending process. Possible values are: sent, sent_from_gmail, sent_from_external, pending, pending_reply_check, scheduled, sending, delivering, failed, cancelled, pending_through_gmail, pending_through_external
   */
  status?: string;
  step?: EmbeddedResource;
  /**
   * Subject of the email. This field has been determined sensitive and requires a specific scope to access it.
   */
  subject?: string;
  task?: EmbeddedResource;
  /**
   * Datetime of when the email was last updated
   */
  updated_at?: string;
  user?: EmbeddedResource;
  /**
   * Whether this email had view tracking enabled
   */
  view_tracking?: boolean;
};

export type EmailCounts = {
  /**
   * The number of attachments on the email
   */
  attachments?: number;
  /**
   * The number of times links in the email were clicked
   */
  clicks?: number;
  /**
   * The number of replies the email received
   */
  replies?: number;
  /**
   * The number of unique devices that opened the email
   */
  unique_devices?: number;
  /**
   * The number of unique locations that opened the email
   */
  unique_locations?: number;
  /**
   * The number of times the email was opened
   */
  views?: number;
};

export type EmailTemplate = {
  /**
   * Links to attachments and tags resources for this email template.
   */
  _links?: {
    [key: string]: unknown;
  };
  /**
   * Datetime of when the email template was archived, if archived
   */
  archived_at?: string;
  /**
   * Sanitized body of the email template without email signature
   */
  body?: string;
  /**
   * A plain text version of the first 100 characters of the body of the email template
   */
  body_preview?: string;
  /**
   * Whether this email template is only used on a cadence step. These templates are not visible in the SalesLoft application template list. If false, this email template is visible in the SalesLoft application, and may be used when composing an email or creating a cadence step.
   */
  cadence_template?: boolean;
  /**
   * Whether click tracking is enabled for this email template
   */
  click_tracking_enabled?: boolean;
  counts?: EmailTemplateCounts;
  /**
   * Datetime of when the email template was created
   */
  created_at?: string;
  /**
   * Groups to which this template is assigned, if any
   */
  groups?: Array<EmbeddedResource>;
  /**
   * ID of email template
   */
  id?: number;
  /**
   * Datetime of when the email template was last used
   */
  last_used_at?: string;
  /**
   * Whether open tracking is enabled for this email template
   */
  open_tracking_enabled?: boolean;
  /**
   * Whether this email template is visible to team members (shared)
   */
  shared?: boolean;
  /**
   * Subject of the email template
   */
  subject?: string;
  /**
   * All tags applied to this email template
   */
  tags?: Array<string>;
  team_template?: EmbeddedResource;
  template_owner?: EmbeddedResource;
  /**
   * Title of the email template
   */
  title?: string;
  /**
   * Datetime of when the email template was last updated
   */
  updated_at?: string;
};

export type EmailTemplateAttachment = {
  /**
   * Content type of the attachment
   */
  attachment_content_type?: string;
  /**
   * The size of the attachment
   */
  attachment_file_size?: number;
  /**
   * Unique attachment Identifier
   */
  attachment_fingerprint?: number;
  /**
   * ID of the email template attachment
   */
  attachment_id?: number;
  /**
   * Download url of the attachment
   */
  download_url?: string;
  email_template?: EmbeddedResource;
  /**
   * ID of email template attachment association
   */
  id?: number;
  /**
   * Name of the attachment
   */
  name?: string;
  /**
   * Checks if attachment has been scanned
   */
  scanned?: boolean;
};

export type EmailTemplateCounts = {
  /**
   * The number of bounces the email template received
   */
  bounces?: number;
  /**
   * The number of times links in the email template were clicked
   */
  clicks?: number;
  /**
   * The number of replies the email template received
   */
  replies?: number;
  /**
   * The number of times the email template was sent out
   */
  sent_emails?: number;
  /**
   * The number of times the email template was opened
   */
  views?: number;
};

export type EmbeddedAccountCounts = {
  /**
   * Number of people in SalesLoft associated with this Account
   */
  people?: number;
};

export type EmbeddedAttendeeResource = {
  /**
   * Datetime of when the attendee was deleted
   */
  deleted_at?: string;
  /**
   * Email of the attendee
   */
  email?: string;
  /**
   * Name of the attendee
   */
  name?: string;
  /**
   * Whether the attendee is the organizer of the event.
   */
  organizer?: boolean;
  /**
   * The attendee's response status. Possible values are: needsAction, accepted, tentative, declined
   */
  status?: string;
  /**
   * Whether the attendee changed response status
   */
  status_changed?: boolean;
};

export type EmbeddedRecordingResource = {
  /**
   * The processing status of the recording. Possible values are (but not limited to):
   *
   * not_recorded: there is no recording available, and there will not be one becoming available
   *
   * pending: the recording is currently being processed by the system
   *
   * processing: the recording is currently being processed by the system
   *
   * completed: the recording processing has been completed
   *
   */
  recording_status?: string;
  /**
   * The status of the call that produced this recording. Possible values are (but not limited to):
   *
   * no-answer: The call was not answered
   *
   * failed: The call was not able to be placed
   *
   * busy: The call was busy
   *
   * ringing: The call is ringing
   *
   * in-progress: The call is ongoing
   *
   * completed: The call is finished
   *
   */
  status?: string;
  /**
   * The url of the recording
   */
  url?: string;
};

export type EmbeddedResource = {
  /**
   * Resource URL, pointed at your API version, present if this resource is available in the API
   */
  _href?: string;
  /**
   * ID of the resource
   */
  id?: number;
};

export type EventMeetingSetting = {
  /**
   * Calendar owner's email address
   */
  email_address?: string;
};

export type ExternalEmail = {
  /**
   * Message id present in the External Email header
   */
  message_id?: string;
};

export type Group = {
  /**
   * Groups accessible if any
   */
  accessible_groups?: Array<EmbeddedResource>;
  /**
   * ID of the Group
   */
  id?: number;
  /**
   * Name of the Group
   */
  name?: string;
  /**
   * ID of the parent Group
   */
  parent_id?: number;
};

export type Import = {
  /**
   * Datetime of when the import was created
   */
  created_at?: string;
  /**
   * Count of People that have not been deleted
   */
  current_people_count?: number;
  /**
   * Import ID
   */
  id?: number;
  /**
   * Count of People that have ever been on this Import
   */
  imported_people_count?: number;
  /**
   * Name of Import
   */
  name?: string;
  /**
   * Datetime of when the import was last updated, ignoring relationship changes
   */
  updated_at?: string;
};

export type JobData = {
  /**
   * Associated bulk job
   */
  bulk_job?: {
    [key: string]: unknown;
  };
  /**
   * When this job data record was created
   */
  created_at?: string;
  /**
   * Error associated with this record
   */
  error?: string;
  /**
   * When this job data record finished processing
   */
  finished_at?: string;
  /**
   * ID of this Job Data
   */
  id?: number;
  /**
   * The data that was used to process the operation
   */
  record?: {
    [key: string]: unknown;
  };
  /**
   * The object containing the resulting resource from performing the bulk action on this record
   */
  resource?: {
    [key: string]: unknown;
  };
  /**
   * When this job data record started processing
   */
  started_at?: string;
  /**
   * Status of this job data. Must be one of: pending, success, error, retrying
   */
  status?: string;
};

export type JobDataCreationResult = {
  /**
   * Number of records created
   */
  records?: number;
};

export type LiveFeedItem = {
  /**
   * Information about whether this event should trigger an alert
   */
  alert_metadata?: {
    [key: string]: unknown;
  };
  /**
   * When this event occurred
   */
  event_occurred_at?: string;
  /**
   * The type of event
   */
  event_type?: string;
  /**
   * ID of this item
   */
  id?: number;
  /**
   * A plaintext message for this event
   */
  message?: string;
  /**
   * The metadata created for this event
   */
  metadata?: {
    [key: string]: unknown;
  };
  /**
   * The path to the application that should be followed
   */
  path?: string;
  /**
   * The key that should be used to rollup events client side. null or empty values should not be rolled up
   */
  rollup_key?: string;
  /**
   * A plaintext title for this event
   */
  title?: string;
  /**
   * UUID of the user this item is for
   */
  user_guid?: string;
};

export type LiveWebsiteTrackingParameter = {
  /**
   * A SalesLoft identifier
   */
  parameters?: Array<{
    [key: string]: unknown;
  }>;
};

export type Meeting = {
  /**
   * ID of the account the recipient associated to
   */
  account_id?: string;
  /**
   * Whether the meeting is an all-day meeting
   */
  all_day?: boolean;
  /**
   * The attendees of the meeting. Each attendee includes the following fields: status, email, name, organizer
   */
  attendees?: Array<EmbeddedAttendeeResource>;
  booked_by_meetings_settings?: EventMeetingSetting;
  booked_by_user?: EmbeddedResource;
  cadence?: EmbeddedResource;
  /**
   * Calendar ID of the meeting owner
   */
  calendar_id?: string;
  /**
   * Calendar type of the meeting owner. Possible values are: gmail, azure, nylas, linkedin_azure, cerebro, external
   */
  calendar_type?: string;
  /**
   * Datetime of when the meeting was canceled
   */
  canceled_at?: string;
  /**
   * Datetime of when the meeting was created
   */
  created_at?: string;
  /**
   * List of crm custom fields which will be logged to SFDC
   */
  crm_custom_fields?: {
    [key: string]: unknown;
  };
  /**
   * List of crm references associated with the meeting
   */
  crm_references?: {
    [key: string]: unknown;
  };
  /**
   * Description of the meeting
   */
  description?: string;
  /**
   * End time of the meeting
   */
  end_time?: string;
  /**
   * ID of the meeting created by target calendar
   */
  event_id?: string;
  /**
   * Source of the meeting. Possible values are: 'external' - The event was synced to Salesloft platform via Calendar Sync, 'internal' - The event was created via Salesloft platform
   */
  event_source?: string;
  /**
   * The list of attendees emails of the meeting
   */
  guests?: Array<string>;
  /**
   * UID of the meeting provided by target calendar provider
   */
  i_cal_uid?: string;
  /**
   * ID of the meeting
   */
  id?: number;
  /**
   * Location of the meeting
   */
  location?: string;
  /**
   * Meeting type
   */
  meeting_type?: string;
  /**
   * Whether the meeting is a No Show meeting
   */
  no_show?: boolean;
  owned_by_meetings_settings?: EventMeetingSetting;
  person?: EmbeddedResource;
  /**
   * Email of the meeting invite recipient
   */
  recipient_email?: string;
  /**
   * Name of the meeting invite recipient
   */
  recipient_name?: string;
  /**
   * Status of the meeting rescheduling progress. Possible values are: pending, booked, failed, retry
   */
  reschedule_status?: string;
  /**
   * Start time of the meeting
   */
  start_time?: string;
  /**
   * Status of the meeting. Possible values are: pending, booked, failed, retry
   */
  status?: string;
  step?: EmbeddedResource;
  /**
   * Strict attribution means that we 100% sure which cadence generate the meeting
   */
  strict_attribution?: boolean;
  /**
   * ID of the created task
   */
  task_id?: string;
  /**
   * Title of the meeting
   */
  title?: string;
  /**
   * Datetime of when the meeting was last updated
   */
  updated_at?: string;
};

export type MeetingSetting = {
  active_meeting_url?: MeetingUrl;
  /**
   * Allow other team members to schedule on you behalf.
   */
  allow_booking_on_behalf?: boolean;
  /**
   * Allow team members to insert available time outside your working hours.
   */
  allow_booking_overtime?: boolean;
  /**
   * Allow team members to double book events on your calendar.
   */
  allow_event_overlap?: boolean;
  /**
   * The number of days out the user allows a prospect to schedule a meeting
   */
  availability_limit?: number;
  /**
   * If Availability Limits have been turned on
   */
  availability_limit_enabled?: boolean;
  /**
   * Default buffer duration in minutes set by a user
   */
  buffer_time_duration?: number;
  /**
   * Calendar type
   */
  calendar_type?: string;
  /**
   * Datetime of when the MeetingSetting was created
   */
  created_at?: string;
  /**
   * Default meeting length in minutes set by the user
   */
  default_meeting_length?: number;
  /**
   * Default description of the meeting
   */
  description?: string;
  /**
   * Calendar owner's email address
   */
  email_address?: string;
  /**
   * Determines if a user enabled Calendar Sync feature
   */
  enable_calendar_sync?: boolean;
  /**
   * Determines if location will be filled via third-party service (Zoom, GoToMeeting, etc.)
   */
  enable_dynamic_location?: boolean;
  /**
   * ID of the MeetingSetting
   */
  id?: number;
  /**
   * Default location of the meeting
   */
  location?: string;
  /**
   * Gets true when any issue with fetching calendar occurs
   */
  primary_calendar_connection_failed?: boolean;
  /**
   * ID of the primary calendar
   */
  primary_calendar_id?: string;
  /**
   * Display name of the primary calendar
   */
  primary_calendar_name?: string;
  /**
   * Determines if a user enabled reschedule meetings feature
   */
  reschedule_meetings_enabled?: boolean;
  /**
   * Determines if meetings are scheduled with a 15 minute buffer between them
   */
  schedule_buffer_enabled?: boolean;
  /**
   * The number of hours in advance a user requires someone to a book a meeting with them
   */
  schedule_delay?: number;
  /**
   * Allow team members to see the details of events on your calendar.
   */
  share_event_detail?: boolean;
  /**
   * Time zone for current calendar
   */
  time_zone?: string;
  /**
   * Times available set by a user that can be used to book meetings
   */
  times_available?: {
    [key: string]: unknown;
  };
  /**
   * Default title of the meeting
   */
  title?: string;
  /**
   * Datetime of when the MeetingSetting was last updated
   */
  updated_at?: string;
  user?: EmbeddedResource;
  /**
   * User details
   */
  user_details?: {
    [key: string]: unknown;
  };
  /**
   * User slug generated with a full name of the user
   */
  user_slug?: string;
};

export type MeetingUrl = {
  /**
   * Datetime of when MeetingUrl was created
   */
  created_at?: string;
  /**
   * Datetime of when MeetingUrl was last updated
   */
  updated_at?: string;
  /**
   * Full url of the meeting
   */
  url?: string;
};

export type MimeEmailPayload = {
  /**
   * Email ID
   */
  id?: number;
  /**
   * Email Address of Sender's mailbox
   */
  mailbox?: string;
  /**
   * Unique Message ID
   */
  message_id?: string;
  /**
   * Base64 encoded MIME email content
   */
  raw?: string;
};

export type Note = {
  /**
   * Type of associated resource ('person' or 'account')
   */
  associated_type?: string;
  associated_with?: EmbeddedResource;
  call?: EmbeddedResource;
  /**
   * The content of the note
   */
  content?: string;
  /**
   * Datetime of when the note was created
   */
  created_at?: string;
  /**
   * Note ID
   */
  id?: number;
  /**
   * Datetime of when the note was last updated
   */
  updated_at?: string;
  user?: EmbeddedResource;
};

export type PendingEmail = {
  /**
   * ID of the email
   */
  id?: number;
  /**
   * Email Address of the pending email
   */
  mailbox?: string;
  mime_email_payload?: EmbeddedResource;
};

export type Person = {
  account?: EmbeddedResource;
  /**
   * Whether this person's current email address has bounced
   */
  bouncing?: boolean;
  /**
   * The list of active cadences person is added to
   */
  cadences?: Array<EmbeddedResource>;
  /**
   * City
   */
  city?: string;
  /**
   * Specific methods of communication to prevent for this person. This will prevent individual execution of these communication types as well as automatically skip cadence steps of this communication type for this person in SalesLoft. Values currently accepted: call, email, message
   */
  contact_restrictions?: Array<string>;
  /**
   * Country
   */
  country?: string;
  counts?: PersonCounts;
  /**
   * Datetime of when the person was created
   */
  created_at?: string;
  /**
   * CRM ID
   */
  crm_id?: string;
  /**
   * CRM object type
   */
  crm_object_type?: string;
  /**
   * CRM url
   */
  crm_url?: string;
  /**
   * Custom fields are defined by the user's team. Only fields with values are presented in the API.
   */
  custom_fields?: {
    [key: string]: unknown;
  };
  /**
   * Either the full name or the email address. Use this when showing a person's name
   */
  display_name?: string;
  /**
   * Whether or not this person has opted out of all communication. Setting this value to true prevents this person from being called, emailed, or added to a cadence in SalesLoft. If this person is currently in a cadence, they will be removed.
   */
  do_not_contact?: boolean;
  /**
   * Email address
   */
  email_address?: string;
  /**
   * Whether this person is marked as a European Union Resident or not
   */
  eu_resident?: boolean;
  /**
   * First name
   */
  first_name?: string;
  /**
   * Full email address with name
   */
  full_email_address?: string;
  /**
   * Home phone without formatting
   */
  home_phone?: string;
  /**
   * Person ID
   */
  id?: number;
  import?: EmbeddedResource;
  /**
   * The Job Seniority of a Person, must be one of director, executive, individual_contributor, manager, vice_president, unknown
   */
  job_seniority?: string;
  last_completed_step?: EmbeddedResource;
  last_completed_step_cadence?: EmbeddedResource;
  /**
   * Last datetime this person was contacted
   */
  last_contacted_at?: string;
  last_contacted_by?: EmbeddedResource;
  /**
   * The type of the last touch to this person. Can be call, email, other
   */
  last_contacted_type?: string;
  /**
   * Last name
   */
  last_name?: string;
  /**
   * Last datetime this person replied to an email
   */
  last_replied_at?: string;
  /**
   * Linkedin URL
   */
  linkedin_url?: string;
  /**
   * Time locale of the person
   */
  locale?: string;
  /**
   * The locale's timezone offset from UTC in minutes
   */
  locale_utc_offset?: number;
  /**
   * Mobile phone without formatting
   */
  mobile_phone?: string;
  most_recent_cadence?: EmbeddedResource;
  owner?: EmbeddedResource;
  /**
   * Mapped owner field from your CRM
   */
  owner_crm_id?: string;
  /**
   * Company industry. This property is specific to this person, unrelated to the company object. Updating the company object associated with this person is recommended
   */
  person_company_industry?: string;
  /**
   * Company name. This property is specific to this person, unrelated to the company object. Updating the company object associated with this person is recommended
   */
  person_company_name?: string;
  /**
   * Company website. This property is specific to this person, unrelated to the company object. Updating the company object associated with this person is recommended
   */
  person_company_website?: string;
  person_stage?: EmbeddedResource;
  /**
   * Personal email address
   */
  personal_email_address?: string;
  /**
   * The website of this person
   */
  personal_website?: string;
  /**
   * Phone without formatting
   */
  phone?: string;
  /**
   * Phone extension without formatting
   */
  phone_extension?: string;
  /**
   * Alternate email address
   */
  secondary_email_address?: string;
  /**
   * Whether this person is starred by the current user
   */
  starred?: boolean;
  /**
   * State
   */
  state?: string;
  /**
   * The person's success count. 1 if person has any active successes, 0 otherwise.
   */
  success_count?: number;
  /**
   * All tags applied to this person
   */
  tags?: Array<string>;
  /**
   * Job title
   */
  title?: string;
  /**
   * The twitter handle of this person
   */
  twitter_handle?: string;
  /**
   * The person's untouched status
   */
  untouched?: boolean;
  /**
   * Datetime of when the person was last updated
   */
  updated_at?: string;
  /**
   * Work location - city
   */
  work_city?: string;
  /**
   * Work location - country
   */
  work_country?: string;
  /**
   * Work location - state
   */
  work_state?: string;
};

export type PersonCounts = {
  /**
   * The number of calls logged to this person
   */
  calls?: number;
  /**
   * The number of unique emails sent to this person that bounced
   */
  emails_bounced?: number;
  /**
   * The number of unique emails clicked by this person
   */
  emails_clicked?: number;
  /**
   * The number of unique emails replied to by this person
   */
  emails_replied_to?: number;
  /**
   * The number of emails sent to this person
   */
  emails_sent?: number;
  /**
   * The number of unique emails viewed by this person
   */
  emails_viewed?: number;
};

export type PersonStage = {
  /**
   * Datetime of when the Person Stage was created
   */
  created_at?: string;
  /**
   * ID of Person Stage
   */
  id?: number;
  /**
   * Name of Person Stage
   */
  name?: string;
  /**
   * Sortable value of Person Stage order
   */
  order?: number;
  /**
   * Datetime of when the Person Stage was last updated
   */
  updated_at?: string;
};

export type PersonUpsert = {
  person?: Person;
  /**
   * The type of upsert. One of: create, update
   */
  upsert_type?: string;
};

export type PhoneNumberAssignment = {
  /**
   * PhoneNumberAssignment ID
   */
  id?: number;
  /**
   * The phone number associated with this assignment
   */
  number?: string;
  user?: EmbeddedResource;
};

export type RecordingSetting = {
  /**
   * Whether this phone number should record by default
   */
  recording_default?: boolean;
};

export type SavedListView = {
  /**
   * ID of Ssaved list view
   */
  id?: number;
  /**
   * Whether the saved list view is the default view
   */
  is_default?: boolean;
  /**
   * Name of saved list view
   */
  name?: string;
  /**
   * Type of saved list view
   */
  view?: string;
  /**
   * List of set filters in saved list view
   */
  view_params?: {
    [key: string]: unknown;
  };
};

export type Step = {
  cadence?: EmbeddedResource;
  /**
   * Datetime of when the Step was created
   */
  created_at?: string;
  /**
   * Day this step is associated with up
   */
  day?: number;
  details?: EmbeddedResource;
  /**
   * Whether this step is currently active
   */
  disabled?: boolean;
  /**
   * Display name of the step
   */
  display_name?: string;
  /**
   * ID of Step
   */
  id?: number;
  /**
   * Whether this step is a multitouch cadence step
   */
  multitouch_enabled?: boolean;
  /**
   * Name of the step
   */
  name?: string;
  /**
   * The number of the step for this day
   */
  step_number?: number;
  /**
   * The type of the action scheduled by this step. Valid types are: email, phone, integration, other. New types may be added in the future.
   *
   */
  type?: string;
  /**
   * Datetime of when the Step was last updated
   */
  updated_at?: string;
};

export type Subscription = {
  /**
   * SalesLoft will include this token in the webhook event payload when calling your callback_url. It is strongly encouraged for your handler to verify this value in order to ensure the request came from SalesLoft.
   */
  callback_token?: string;
  /**
   * URL for your callback handler
   */
  callback_url?: string;
  /**
   * Is the Webhook Subscription enabled or not
   */
  enabled?: boolean;
  /**
   * Type of event the subscription is for
   */
  event_type?: string;
  /**
   * ID for the Webhook Subscription
   */
  id?: number;
  /**
   * ID for the tenant to which user is assigned
   */
  tenant_id?: number;
  /**
   * UUID of the user the token is associated with
   */
  user_guid?: string;
};

export type Success = {
  counts?: SuccessCounts;
  /**
   * Datetime of when the success was created
   */
  created_at?: string;
  /**
   * ID of success
   */
  id?: number;
  latest_action?: EmbeddedResource;
  latest_cadence?: EmbeddedResource;
  latest_call?: EmbeddedResource;
  latest_email?: EmbeddedResource;
  latest_step?: EmbeddedResource;
  person?: EmbeddedResource;
  /**
   * Datetime of when the success was recorded
   */
  succeeded_at?: string;
  /**
   * Datetime of when this person was first worked, leading up to the success
   */
  success_window_started_at?: string;
  /**
   * Datetime of when the success was last updated
   */
  updated_at?: string;
  user?: EmbeddedResource;
};

export type SuccessCounts = {
  /**
   * The total number of calls made in this success window
   */
  total_calls?: number;
  /**
   * The total number of emails made in this success window
   */
  total_emails?: number;
  /**
   * The total number of other touches made in this success window
   */
  total_other_touches?: number;
};

export type Tag = {
  /**
   * ID of Tag
   */
  id?: number;
  /**
   * Name of the tag
   */
  name?: string;
};

export type Task = {
  /**
   * Datetime of when the task was completed, ISO-8601 datetime format required
   */
  completed_at?: string;
  completed_by?: EmbeddedResource;
  /**
   * Datetime of when the Task was created
   */
  created_at?: string;
  created_by_user?: EmbeddedResource;
  /**
   * The state of the task. Valid states are: scheduled, completed
   */
  current_state?: string;
  /**
   * A description of the task recorded for person at completion time
   */
  description?: string;
  /**
   * Datetime of when the Task is due, can be null.  ISO-8601 datetime format required
   */
  due_at?: string;
  /**
   * Date of when the Task is due, ISO-8601 date format required
   */
  due_date?: string;
  /**
   * ID of Task
   */
  id?: number;
  person?: EmbeddedResource;
  /**
   * Datetime of when the user will be reminded of the task, ISO-8601 datetime format required
   */
  remind_at?: string;
  /**
   * Subject line of the task
   */
  subject?: string;
  /**
   * The type of the task.  Valid types are: call, email, general
   */
  task_type?: string;
  /**
   * Datetime of when the Task was last updated
   */
  updated_at?: string;
  user?: EmbeddedResource;
};

export type Team = {
  /**
   * For internal use only. This field does not comply with our backwards compatability policies.
   */
  _private_fields?: {
    [key: string]: unknown;
  };
  /**
   * Whether team members are allowed to have automated email steps
   */
  allow_automated_email_steps?: boolean;
  /**
   * Whether all call recording is disabled
   */
  call_recording_disabled?: boolean;
  /**
   * The team default for click tracking when composing emails
   */
  click_tracking_default?: boolean;
  /**
   * Datetime of when the team was created
   */
  created_at?: string;
  /**
   * The domain click and open tracking will be proxied through
   */
  custom_tracking_domain?: string;
  /**
   * Indicates if the team has been deactivated
   */
  deactivated?: boolean;
  /**
   * Whether team members are required to mark disposition at the end of calls
   */
  dispositions_required?: boolean;
  /**
   * Daily email limit for each member on the team
   */
  email_daily_limit?: number;
  /**
   * Visibility setting for resources across the team. Possible values are: group_public, all_public.
   * When the value is group_public, certain resources will only be visible to members of the same group.
   * When the value is all_public, all resources are visible to all users on this team.
   *
   */
  group_privacy_setting?: string;
  /**
   * Team ID
   */
  id?: number;
  /**
   * Count of seats that this team has licensed
   */
  license_limit?: number;
  /**
   * Whether this team has local dial enabled
   */
  local_dial_enabled?: boolean;
  /**
   * Team name
   */
  name?: string;
  /**
   * Plan type of the team, Possible values are: group, professional, enterprise
   */
  plan?: string;
  /**
   * Add on features for this team
   */
  plan_features?: {
    [key: string]: unknown;
  };
  /**
   * Whether calls will record by default
   */
  record_by_default?: boolean;
  /**
   * Whether team members are required to log sentiments
   */
  sentiments_required?: boolean;
  /**
   * The default visibility of resources on the team, in the UI only. The API does not utilize this default.
   * Possible values are: public, private.
   *
   */
  team_visibility_default?: string;
  /**
   * Datetime of when the team was last updated
   */
  updated_at?: string;
};

export type TeamTemplate = {
  /**
   * Links to attachments resource for this template
   */
  _links?: {
    [key: string]: unknown;
  };
  /**
   * Datetime of when the team template was archived, if archived
   */
  archived_at?: string;
  /**
   * Body of the team template
   */
  body?: string;
  /**
   * A plain text version of the first 100 characters of the body of the team template
   */
  body_preview?: string;
  /**
   * Whether click tracking is enabled for this team template
   */
  click_tracking_enabled?: boolean;
  counts?: TeamTemplateCounts;
  /**
   * Datetime of when the team template was created
   */
  created_at?: string;
  /**
   * ID of team template
   */
  id?: string;
  /**
   * Datetime of when the team template was last modified
   */
  last_modified_at?: string;
  last_modified_user?: EmbeddedResource;
  /**
   * Datetime of when the team template was last used
   */
  last_used_at?: string;
  /**
   * Whether open tracking is enabled for this team template
   */
  open_tracking_enabled?: boolean;
  /**
   * Subject of the team template
   */
  subject?: string;
  /**
   * All tags applied to this team template
   */
  tags?: Array<string>;
  /**
   * Title of the team template
   */
  title?: string;
  /**
   * Datetime of when the team template was last updated
   */
  updated_at?: string;
};

export type TeamTemplateAttachment = {
  /**
   * The size of the attachment
   */
  attachment_file_size?: number;
  /**
   * ID of the team template attachment
   */
  attachment_id?: number;
  /**
   * Download url of the attachment
   */
  download_url?: string;
  /**
   * ID of team template attachment association
   */
  id?: number;
  /**
   * Name of the attachment
   */
  name?: string;
  team_template?: EmbeddedResource;
};

export type TeamTemplateCounts = {
  /**
   * The number of bounces the team template received
   */
  bounces?: number;
  /**
   * The number of times links in the team template were clicked
   */
  clicks?: number;
  /**
   * The number of replies the team template received
   */
  replies?: number;
  /**
   * The number of times the team template was sent out
   */
  sent_emails?: number;
  /**
   * The number of times the team template was opened
   */
  views?: number;
};

export type User = {
  /**
   * For internal use only. This field does not comply with our backwards compatability policies.
   */
  _private_fields?: {
    [key: string]: unknown;
  };
  /**
   * Whether an user is currently active in SalesLoft
   */
  active?: boolean;
  /**
   * Address that will be BBC'd on all emails from this user
   */
  bcc_email_address?: string;
  /**
   * Whether this user has click to call enabled
   */
  click_to_call_enabled?: boolean;
  /**
   * Datetime of when the user was created
   */
  created_at?: string;
  /**
   * Whether the user has a crm connected
   */
  crm_connected?: boolean;
  /**
   * Email address provided to accounts.salesloft.com
   */
  email?: string;
  /**
   * Whether this user has a email client configured
   */
  email_client_configured?: boolean;
  /**
   * Email address associated with the email client of the user
   */
  email_client_email_address?: string;
  /**
   * Email signature
   */
  email_signature?: string;
  /**
   * Whether this user has click tracking disabled in email signature
   */
  email_signature_click_tracking_disabled?: boolean;
  /**
   * Email signature type
   */
  email_signature_type?: string;
  /**
   * Feature flags that are for this user. New flags may appear or disappear at any time
   */
  external_feature_flags?: {
    [key: string]: unknown;
  };
  /**
   * First name of user
   */
  first_name?: string;
  /**
   * The from address of this user
   */
  from_address?: string;
  /**
   * RFC 5322 compliant email address
   */
  full_email_address?: string;
  group?: EmbeddedResource;
  /**
   * Globally unique user ID. New endpoints will explicitly accept this over id
   */
  guid?: string;
  /**
   * User ID
   */
  id?: number;
  /**
   * Job role of user
   */
  job_role?: string;
  /**
   * Last name of user
   */
  last_name?: string;
  /**
   * Whether this user has Local Dial enabled
   */
  local_dial_enabled?: boolean;
  /**
   * Display name of user
   */
  name?: string;
  phone_client?: EmbeddedResource;
  phone_number_assignment?: EmbeddedResource;
  role?: EmbeddedResource;
  /**
   * The email address that email of the user will be sent from, resolved in the following resolution order: from_user, email_client_email_address, email
   */
  sending_email_address?: string;
  /**
   * Slack username
   */
  slack_username?: string;
  team?: EmbeddedResource;
  /**
   * Team Admin
   */
  team_admin?: boolean;
  /**
   * User Time Zone
   */
  time_zone?: string;
  /**
   * Twitter handle
   */
  twitter_handle?: string;
  /**
   * Datetime of when the user was last updated
   */
  updated_at?: string;
  /**
   * Work Country
   */
  work_country?: string;
};

export type GetV2AccountStagesJsonData = {
  query?: {
    /**
     * IDs of account stages to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: created_at, updated_at, order. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
  };
};

export type GetV2AccountStagesJsonResponse = Array<AccountStage>;

export type GetV2AccountStagesJsonError = unknown;

export type GetV2AccountStagesByIdJsonData = {
  path: {
    /**
     * Account Stage ID
     */
    id: string;
  };
};

export type GetV2AccountStagesByIdJsonResponse = AccountStage;

export type GetV2AccountStagesByIdJsonError = unknown;

export type GetV2AccountTiersJsonData = {
  query?: {
    /**
     * IDs of Account Tiers to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * Filters Account Tiers by name. Multiple names can be applied
     */
    name?: Array<string>;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: created_at, updated_at, order. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
  };
};

export type GetV2AccountTiersJsonResponse = Array<AccountTier>;

export type GetV2AccountTiersJsonError = unknown;

export type GetV2AccountTiersByIdJsonData = {
  path: {
    /**
     * Account Tier ID
     */
    id: string;
  };
};

export type GetV2AccountTiersByIdJsonResponse = AccountTier;

export type GetV2AccountTiersByIdJsonError = unknown;

export type PostV2AccountUpsertsJsonData = {
  body?: {
    /**
     * ID of the Account Tier for this Account
     */
    account_tier_id?: number;
    /**
     * City
     */
    city?: string;
    /**
     * ID of the CompanyStage assigned to this Account
     */
    company_stage_id?: number;
    /**
     * Type of the Account's company
     */
    company_type?: string;
    /**
     * Conversational name of the Account
     */
    conversational_name?: string;
    /**
     * Country
     */
    country?: string;
    /**
     * Requires Salesforce.
     *
     * ID of the person in your external CRM. You must provide a crm_id_type if this is included.
     *
     * Validations will be applied to the crm_id depending on the crm_id_type. A "salesforce" ID must be exactly 18 characters. A "salesforce" ID must be either an Account (001) object. The type will be validated using the 18 character ID.
     *
     * This field can only be used if your application or API key has the "account:set_crm_id" scope.
     *
     *
     */
    crm_id?: string;
    /**
     * The CRM that the provided crm_id is for. Must be one of: salesforce
     */
    crm_id_type?: string;
    /**
     * Custom fields are defined by the user's team. Only fields with values are presented in the API.
     */
    custom_fields?: Array<{
      [key: string]: unknown;
    }>;
    /**
     * Description
     */
    description?: string;
    /**
     * Whether this company can not be contacted. Values are either true or false. Setting this to true will remove all associated people from all active communications
     */
    do_not_contact?: boolean;
    /**
     * Website domain, not a fully qualified URI
     */
    domain: string;
    /**
     * Date or year of founding
     */
    founded?: string;
    /**
     * ID of the account to update. Used if the upsert_key=id. When id and another upsert_key are provided,
     * the request will fail if the upsert record id and id parameter don't match.
     *
     */
    id?: number;
    /**
     * Industry
     */
    industry?: string;
    /**
     * Full LinkedIn url
     */
    linkedin_url?: string;
    /**
     * Time locale
     */
    locale?: string;
    /**
     * Account Full Name
     */
    name: string;
    /**
     * ID of the User that owns this Account
     */
    owner_id?: number;
    /**
     * Phone number without formatting
     */
    phone?: string;
    /**
     * Postal code
     */
    postal_code?: string;
    /**
     * Estimated revenue range
     */
    revenue_range?: string;
    /**
     * Estimated number of people in employment
     */
    size?: string;
    /**
     * State
     */
    state?: string;
    /**
     * Street name and number
     */
    street?: string;
    /**
     * All tags applied to this Account
     */
    tags?: Array<string>;
    /**
     * Twitter handle, with @
     */
    twitter_handle?: string;
    /**
     * Name of the parameter to upsert on. The field must be provided in the input parameters, or the request will fail.
     * The request will also fail if there are multiple records matched by the upsert field.
     *
     * If upsert_key is not provided, this endpoint will not update an existing record.
     *
     * Valid options are: id, crm_id, domain. If crm_id is provided, then a valid crm_id_type must be provided, as documented
     * for the account create and update endpoints.
     *
     */
    upsert_key?: string;
    /**
     * Website
     */
    website?: string;
  };
};

export type PostV2AccountUpsertsJsonResponse = AccountUpsert;

export type PostV2AccountUpsertsJsonError = unknown;

export type GetV2AccountsJsonData = {
  query?: {
    /**
     * Filters accounts by account_stage_id. Multiple account_stage_ids can be applied. An additional value of "_is_null" can be passed to filter accounts that do not have account_stage_id
     */
    account_stage_id?: Array<number>;
    /**
     * Filters accounts by account_tier_id. Multiple account tier ids can be applied
     */
    account_tier_id?: Array<number>;
    /**
     * Filters accounts by archived_at status. Returns only accounts where archived_at is not null if this field is true. Returns only accounts where archived_at is null if this field is false. Do not pass this parameter to return both archived and unarchived accounts. This filter is not applied if any value other than "true" or "false" is passed.
     */
    archived?: boolean;
    /**
     * Filters accounts by city by exact match. Supports partial matching
     */
    city?: Array<string>;
    /**
     * Filters accounts by country by exact match. Supports partial matching
     */
    country?: Array<string>;
    /**
     * Equality filters that are applied to the created_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    created_at?: Array<string>;
    /**
     * Filters accounts by crm_id. Multiple crm ids can be applied
     */
    crm_id?: Array<string>;
    /**
     * Filters by accounts matching all given custom fields. The custom field names are case-sensitive, but the provided values are case-insensitive. Example: v2/accounts?custom_fields[custom_field_name]=custom_field_value
     */
    custom_fields?: {
      [key: string]: unknown;
    };
    /**
     * Domain of the accounts to fetch. Domains are unique and lowercase
     */
    domain?: string;
    /**
     * IDs of accounts to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Filters accounts by industry by exact match. Supports partial matching
     */
    industry?: Array<string>;
    /**
     * Equality filters that are applied to the last_contacted field. A single filter can be used by itself or combined with other filters to create a range.
     * Additional values of "_is_null" or "_is_not_null" can be passed to filter records that either have no timestamp value or any timestamp value.
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    last_contacted?: {
      [key: string]: unknown;
    };
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * Filters accounts by locale. Multiple locales are allowed
     */
    locales?: Array<string>;
    /**
     * Names of accounts to fetch. Name matches are exact and case sensitive. Multiple names can be fetched.
     */
    name?: Array<string>;
    /**
     * Filters accounts by owner_crm_id. Multiple owner_crm_ids can be applied. An additional value of "_is_null" can be passed to filter accounts that are unowned. A "_not_in" modifier can be used to exclude specific owner_crm_ids. Example: v2/accounts?owner_crm_id[_not_in]=id
     */
    owner_crm_id?: Array<string>;
    /**
     * Filters accounts by owner_id. Multiple owner_ids can be applied. An additional value of "_is_null" can be passed to filter accounts that are unowned
     */
    owner_id?: Array<string>;
    /**
     * Filters accounts by whether the owner is active or not.
     */
    owner_is_active?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: created_at, updated_at, last_contacted_at, account_stage, account_stage_name, account_tier, account_tier_name, name, counts_people. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Filters accounts by state by exact match. Supports partial matching
     */
    state?: Array<string>;
    /**
     * Filters accounts by the tags applied to the account. Multiple tags can be applied
     */
    tag?: Array<string>;
    /**
     * Filters accounts by the tag id's applied to the account. Multiple tag id's can be applied
     */
    tag_id?: Array<number>;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
    /**
     * Filters by accounts matching all given user relationship fields, _is_null or _unmapped can be passed to filter accounts with null or unmapped user relationship values. Example: v2/accounts?user_relationships[name]=value
     */
    user_relationships?: {
      [key: string]: unknown;
    };
    /**
     * Filters accounts by website. Multiple websites can be applied. An additional value of "_is_null" can be passed to filter accounts that do not have a website.
     */
    website?: Array<string>;
  };
};

export type GetV2AccountsJsonResponse = Array<Account>;

export type GetV2AccountsJsonError = unknown;

export type PostV2AccountsJsonData = {
  body: {
    /**
     * ID of the Account Tier for this Account
     */
    account_tier_id?: number;
    /**
     * City
     */
    city?: string;
    /**
     * ID of the CompanyStage assigned to this Account
     */
    company_stage_id?: number;
    /**
     * Type of the Account's company
     */
    company_type?: string;
    /**
     * Conversational name of the Account
     */
    conversational_name?: string;
    /**
     * Country
     */
    country?: string;
    /**
     * Requires Salesforce.
     *
     * ID of the person in your external CRM. You must provide a crm_id_type if this is included.
     *
     * Validations will be applied to the crm_id depending on the crm_id_type. A "salesforce" ID must be exactly 18 characters. A "salesforce" ID must be either an Account (001) object. The type will be validated using the 18 character ID.
     *
     * This field can only be used if your application or API key has the "account:set_crm_id" scope.
     *
     *
     */
    crm_id?: string;
    /**
     * The CRM that the provided crm_id is for. Must be one of: salesforce
     */
    crm_id_type?: string;
    /**
     * Custom fields are defined by the user's team. Only fields with values are presented in the API.
     */
    custom_fields?: Array<{
      [key: string]: unknown;
    }>;
    /**
     * Description
     */
    description?: string;
    /**
     * Whether this company can not be contacted. Values are either true or false. Setting this to true will remove all associated people from all active communications
     */
    do_not_contact?: boolean;
    /**
     * Website domain, not a fully qualified URI
     */
    domain: string;
    /**
     * Date or year of founding
     */
    founded?: string;
    /**
     * Industry
     */
    industry?: string;
    /**
     * Full LinkedIn url
     */
    linkedin_url?: string;
    /**
     * Time locale
     */
    locale?: string;
    /**
     * Account Full Name
     */
    name: string;
    /**
     * ID of the User that owns this Account
     */
    owner_id?: number;
    /**
     * Phone number without formatting
     */
    phone?: string;
    /**
     * Postal code
     */
    postal_code?: string;
    /**
     * Estimated revenue range
     */
    revenue_range?: string;
    /**
     * Estimated number of people in employment
     */
    size?: string;
    /**
     * State
     */
    state?: string;
    /**
     * Street name and number
     */
    street?: string;
    /**
     * All tags applied to this Account
     */
    tags?: Array<string>;
    /**
     * Twitter handle, with @
     */
    twitter_handle?: string;
    /**
     * Website
     */
    website?: string;
  };
};

export type PostV2AccountsJsonResponse = Account;

export type PostV2AccountsJsonError = unknown;

export type DeleteV2AccountsByIdJsonData = {
  path: {
    /**
     * Account ID
     */
    id: string;
  };
};

export type DeleteV2AccountsByIdJsonResponse = any;

export type DeleteV2AccountsByIdJsonError = unknown;

export type GetV2AccountsByIdJsonData = {
  path: {
    /**
     * Account ID
     */
    id: string;
  };
};

export type GetV2AccountsByIdJsonResponse = Account;

export type GetV2AccountsByIdJsonError = unknown;

export type PutV2AccountsByIdJsonData = {
  body: {
    /**
     * ID of the Account Tier for this Account
     */
    account_tier_id?: number;
    /**
     * Whether this Account should be archived or not. Setting this to true sets archived_at to the current time if it's not already set. Setting this to false will set archived_at to null
     */
    archived?: boolean;
    /**
     * City
     */
    city?: string;
    /**
     * ID of the CompanyStage assigned to this Account
     */
    company_stage_id?: number;
    /**
     * Type of the Account's company
     */
    company_type?: string;
    /**
     * Conversational name of the Account
     */
    conversational_name?: string;
    /**
     * Country
     */
    country?: string;
    /**
     * Requires Salesforce.
     *
     * ID of the person in your external CRM. You must provide a crm_id_type if this is included.
     *
     * Validations will be applied to the crm_id depending on the crm_id_type. A "salesforce" ID must be exactly 18 characters. A "salesforce" ID must be either an Account (001) object. The type will be validated using the 18 character ID.
     *
     * This field can only be used if your application or API key has the "account:set_crm_id" scope.
     *
     *
     */
    crm_id?: string;
    /**
     * The CRM that the provided crm_id is for. Must be one of: salesforce
     */
    crm_id_type?: string;
    /**
     * Custom fields are defined by the user's team. Only fields with values are presented in the API.
     */
    custom_fields?: Array<{
      [key: string]: unknown;
    }>;
    /**
     * Description
     */
    description?: string;
    /**
     * Whether this company can not be contacted. Values are either true or false. Setting this to true will remove all associated people from all active communications
     */
    do_not_contact?: boolean;
    /**
     * Website domain, not a fully qualified URI
     */
    domain: string;
    /**
     * Date or year of founding
     */
    founded?: string;
    /**
     * Industry
     */
    industry?: string;
    /**
     * Full LinkedIn url
     */
    linkedin_url?: string;
    /**
     * Time locale
     */
    locale?: string;
    /**
     * Account Full Name
     */
    name: string;
    /**
     * ID of the User that owns this Account
     */
    owner_id?: number;
    /**
     * Phone number without formatting
     */
    phone?: string;
    /**
     * Postal code
     */
    postal_code?: string;
    /**
     * Estimated revenue range
     */
    revenue_range?: string;
    /**
     * Estimated number of people in employment
     */
    size?: string;
    /**
     * State
     */
    state?: string;
    /**
     * Street name and number
     */
    street?: string;
    /**
     * All tags applied to this Account
     */
    tags?: Array<string>;
    /**
     * Twitter handle, with @
     */
    twitter_handle?: string;
    /**
     * Website
     */
    website?: string;
  };
  path: {
    /**
     * Account ID
     */
    id: string;
  };
};

export type PutV2AccountsByIdJsonResponse = Account;

export type PutV2AccountsByIdJsonError = unknown;

export type GetV2ActionDetailsCallInstructionsJsonData = {
  query?: {
    /**
     * IDs of call instructions to fetch.
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: created_at, updated_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
  };
};

export type GetV2ActionDetailsCallInstructionsJsonResponse = Array<CallInstruction>;

export type GetV2ActionDetailsCallInstructionsJsonError = unknown;

export type GetV2ActionDetailsCallInstructionsByIdJsonData = {
  path: {
    /**
     * Call instructions ID
     */
    id: string;
  };
};

export type GetV2ActionDetailsCallInstructionsByIdJsonResponse = CallInstruction;

export type GetV2ActionDetailsCallInstructionsByIdJsonError = unknown;

export type GetV2ActionsJsonData = {
  query?: {
    /**
     * Filters actions by cadence_id. Multiple cadence ids can be applied
     */
    cadence_id?: Array<number>;
    /**
     * Equality filters that are applied to the due_on field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    due_on?: Array<string>;
    /**
     * IDs of actions to fetch.
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * Filters actions by multitouch_group_id. Multiple multitouch group ids can be applied
     */
    multitouch_group_id?: Array<number>;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filters actions by person_id. Multiple person ids can be applied
     */
    person_id?: Array<number>;
    /**
     * Key to sort on, must be one of: created_at, updated_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Fetch actions by step ID
     */
    step_id?: number;
    /**
     * Filter actions by type
     */
    type?: string;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
    /**
     * Filters actions by the user's guid. Multiple user guids can be applied. The user must be a team admin to filter other users' actions
     */
    user_guid?: Array<string>;
  };
};

export type GetV2ActionsJsonResponse = Array<Action>;

export type GetV2ActionsJsonError = unknown;

export type GetV2ActionsByIdJsonData = {
  path: {
    /**
     * Action ID
     */
    id: string;
  };
};

export type GetV2ActionsByIdJsonResponse = Action;

export type GetV2ActionsByIdJsonError = unknown;

export type PostV2ActivitiesJsonData = {
  body?: {
    /**
     * Action that is being completed. This will validate that the action is still
     * valid before completed it. The same action can never be successfully passed twice to this endpoint.
     * The action must have a type of 'integration'.
     *
     */
    action_id?: number;
    /**
     * Task that is being completed. This will validate that the task is still
     * valid before completed it. The same action can never be successfully passed twice to this endpoint.
     * The task must have a type of 'integration'.
     *
     */
    task_id?: number;
  };
};

export type PostV2ActivitiesJsonResponse = Activity;

export type PostV2ActivitiesJsonError = unknown;

export type GetV2ActivitiesCallsJsonData = {
  query?: {
    /**
     * Equality filters that are applied to the created_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    created_at?: Array<string>;
    /**
     * Filters calls by disposition. Disposition matches are exact and case sensitive. Multiple dispositions are allowed.
     */
    disposition?: Array<string>;
    /**
     * IDs of calls to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filters calls by person_id. Multiple person ids can be applied
     */
    person_id?: Array<number>;
    /**
     * Filters calls by sentiment. Sentiment matches are exact and case sensitive. Multiple sentiments are allowed.
     */
    sentiment?: Array<string>;
    /**
     * Key to sort on, must be one of: created_at, updated_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
    /**
     * Filters list to only include guids
     */
    user_guid?: Array<string>;
  };
};

export type GetV2ActivitiesCallsJsonResponse = Array<Call>;

export type GetV2ActivitiesCallsJsonError = unknown;

export type PostV2ActivitiesCallsJsonData = {
  body: {
    /**
     * Action that this call is being logged for. This will validate that the action is still
     * valid before completing it. The same action can never be successfully passed twice to this endpoint. The
     * action must have a type of 'phone'.
     *
     */
    action_id?: number;
    /**
     * CRM specific parameters. Some parameters are required on a per-team basis. Consume the
     * CrmActivityFields endpoint to receive a list of valid parameters. The "field" property
     * is passed as the key of this object, and the value of this object is the value that you
     * would like to set.
     *
     * If CrmActivityField has a non-null value, then that value must be submitted, or excluded
     * from API calls, as these values are automatically applied.
     *
     */
    crm_params?: {
      [key: string]: unknown;
    };
    /**
     * The disposition of the call. Can be required on a per-team basis. Must be present in the disposition list.
     */
    disposition?: string;
    /**
     * The length of the call, in seconds
     */
    duration?: number;
    /**
     * CallDataRecord associations that will become linked to the created call. It is possible to pass
     * multiple CallDataRecord ids in this field; this can be used to represent multiple phone calls
     * that made up a single call.
     *
     * Any call data record that is used must not already be linked to a call. It is not possible
     * to link a call data record to multiple calls, and it is not possible to re-assign a call data
     * record to a different call.
     *
     */
    linked_call_data_record_ids?: Array<number>;
    /**
     * Notes to log for the call. This is similar to the notes endpoint, but ensures that the notes get synced to the user's CRM
     */
    notes?: string;
    /**
     * The ID of the person whom this call will be logged for
     */
    person_id: number;
    /**
     * The sentiment of the call. Can be required on a per-team basis. Must be present in the sentiment list.
     */
    sentiment?: string;
    /**
     * The phone number that was called
     */
    to?: string;
    /**
     * Guid of the user whom this call should be logged for. Defaults to the authenticated user. Only team admins can pass another user's guid
     */
    user_guid?: string;
  };
};

export type PostV2ActivitiesCallsJsonResponse = Call;

export type PostV2ActivitiesCallsJsonError = unknown;

export type GetV2ActivitiesCallsByIdJsonData = {
  path: {
    /**
     * Call ID
     */
    id: string;
  };
};

export type GetV2ActivitiesCallsByIdJsonResponse = Call;

export type GetV2ActivitiesCallsByIdJsonError = unknown;

export type GetV2ActivitiesEmailsJsonData = {
  query?: {
    /**
     * Filters emails by action_id. Multiple action ids can be applied
     */
    action_id?: Array<number>;
    /**
     * Filters emails by whether they have bounced or not
     */
    bounced?: boolean;
    /**
     * Filters emails by cadence. Multiple cadence ids can be applied
     */
    cadence_id?: Array<number>;
    /**
     * Filters emails by crm_activity_id. Multiple crm activty ids can be applied
     */
    crm_activity_id?: Array<number>;
    /**
     * Filters emails by recipient email address. Multiple emails can be applied.
     */
    email_addresses?: Array<string>;
    /**
     * IDs of emails to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * Filters emails by one-off only
     */
    one_off?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filters emails by person_id. Multiple person ids can be applied
     */
    person_id?: Array<number>;
    /**
     * Filters emails by personalization score
     */
    personalization?: Array<string>;
    /**
     * Specify explicit scoped fields desired on the Email Resource.
     */
    scoped_fields?: Array<string>;
    /**
     * Equality filters that are applied to the sent_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    sent_at?: Array<string>;
    /**
     * Key to sort on, must be one of: updated_at, send_time. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Filters emails by status. Multiple status can be applied, possible values are sent, sent_from_gmail, sent_from_external, pending, pending_reply_check, scheduled, sending, delivering, failed, cancelled, pending_through_gmail, pending_through_external
     */
    status?: Array<string>;
    /**
     * Filters emails by step. Multiple step ids can be applied
     */
    step_id?: Array<number>;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
    /**
     * Filters emails by user_id. Multiple User ids can be applied
     */
    user_id?: Array<number>;
  };
};

export type GetV2ActivitiesEmailsJsonResponse = Array<Email>;

export type GetV2ActivitiesEmailsJsonError = unknown;

export type GetV2ActivitiesEmailsByIdJsonData = {
  path: {
    /**
     * Email ID
     */
    id: string;
  };
};

export type GetV2ActivitiesEmailsByIdJsonResponse = Email;

export type GetV2ActivitiesEmailsByIdJsonError = unknown;

export type GetV2ActivityHistoriesData = {
  query?: {
    /**
     * For internal use only. This field does not comply with our backwards compatibility policies. This filter is for authenticated users of Salesloft only and will not work for OAuth Applications. Filter by the {resource_type, resource_id} of activity. Provide this in the format resource[]=person,1234
     */
    _resource?: string;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Equality filters that are applied to the occurred_at field. A single filter can be used by itself or combined with other filters to create a range.
     * ---CUSTOM---
     * {"keys":[{"description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision.","name":"gt","type":"iso8601 string"},{"description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision.","name":"gte","type":"iso8601 string"},{"description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision.","name":"lt","type":"iso8601 string"},{"description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision.","name":"lte","type":"iso8601 string"}],"type":"object"}
     *
     */
    occurred_at?: {
      [key: string]: unknown;
    };
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filter by the pinned status of activity. Must be 'true' or 'false'
     */
    pinned?: boolean;
    /**
     * Filter by the resource id. "resource_type" filter is required to use this filter.
     */
    resource_id?: Array<string>;
    /**
     * Filter by the resource type. A resource is a Salesloft object that the activity is attributed to. A valid resource types must be one of person, account, crm_opportunity. Can be provided as an array
     */
    resource_type?: string;
    /**
     * Key to sort on, must be one of: occurred_at, updated_at. Defaults to occurred_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Filter by the type of activity. Must be one of: added_to_cadence, completed_action, call, requested_email, sent_email, received_email, email_reply, note, success, dnc_event, residency_change, meeting, meeting_held, message_conversation, task, voicemail, opportunity_stage_change, opportunity_amount_change, opportunity_close_date_change. Can be provided as an array, or as an object of type[resource_type][]=type
     */
    type?: string;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     * ---CUSTOM---
     * {"keys":[{"description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision.","name":"gt","type":"iso8601 string"},{"description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision.","name":"gte","type":"iso8601 string"},{"description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision.","name":"lt","type":"iso8601 string"},{"description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision.","name":"lte","type":"iso8601 string"}],"type":"object"}
     *
     */
    updated_at?: {
      [key: string]: unknown;
    };
    /**
     * Filter activities by a user's guid.
     */
    user_guid?: string;
  };
};

export type GetV2ActivityHistoriesResponse = ActivityHistory;

export type GetV2ActivityHistoriesError = unknown;

export type GetV2BulkJobsData = {
  query?: {
    /**
     * Filter by id using comparison operators. Only supports greater than (gt) comparison (i.e. id[gt]=123)
     */
    id?: {
      [key: string]: unknown;
    };
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * The state of the bulk job. Accepts multiple states. Each state must be one of: open, executing, done
     */
    state?: Array<string>;
  };
};

export type GetV2BulkJobsResponse = Array<BulkJob>;

export type GetV2BulkJobsError = unknown;

export type PostV2BulkJobsData = {
  body?: {
    /**
     * Name for your bulk job
     */
    name?: string;
    /**
     * Type of bulk job. Must be a valid type. Follow link to the bulk job details page above to view supported types.
     */
    type: string;
  };
};

export type PostV2BulkJobsResponse = BulkJob;

export type PostV2BulkJobsError = unknown;

export type GetV2BulkJobsByBulkJobsIdJobDataData = {
  path: {
    /**
     * The id for the bulk job to which the job data relates
     */
    bulk_jobs_id: number;
  };
  query?: {
    /**
     * Filter by id using comparison operators. Only supports greater than (gt) comparison (i.e. id[gt]=123)
     */
    id?: {
      [key: string]: unknown;
    };
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filter by result status. Accepts multiple statuses. Each status must be one of pending, success, error, retrying
     */
    status?: Array<string>;
  };
};

export type GetV2BulkJobsByBulkJobsIdJobDataResponse = Array<BulkJobResult>;

export type GetV2BulkJobsByBulkJobsIdJobDataError = unknown;

export type PostV2BulkJobsByBulkJobsIdJobDataData = {
  body: {
    /**
     * Array of objects containing parameters to be used to execute an instance of each. Array must be 5,000 records or less.
     */
    data: Array<string>;
  };
  path: {
    /**
     * The id for the bulk job to which the job data relates
     */
    bulk_jobs_id: number;
  };
};

export type PostV2BulkJobsByBulkJobsIdJobDataResponse = JobDataCreationResult;

export type PostV2BulkJobsByBulkJobsIdJobDataError = unknown;

export type GetV2BulkJobsByBulkJobsIdResultsData = {
  path: {
    /**
     * The id for the Bulk Job
     */
    bulk_jobs_id: number;
  };
  query?: {
    /**
     * Filter by id using comparison operators. Only supports greater than (gt) comparison (i.e. id[gt]=123)
     */
    id?: {
      [key: string]: unknown;
    };
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filter by result status. Accepts multiple statuses. Each status must be one of pending, success, error, retrying
     */
    status?: Array<string>;
  };
};

export type GetV2BulkJobsByBulkJobsIdResultsResponse = Array<BulkJobResult>;

export type GetV2BulkJobsByBulkJobsIdResultsError = unknown;

export type GetV2BulkJobsByIdData = {
  path: {
    /**
     * The id for the Bulk Job
     */
    id: number;
  };
};

export type GetV2BulkJobsByIdResponse = BulkJob;

export type GetV2BulkJobsByIdError = unknown;

export type PutV2BulkJobsByIdData = {
  body?: {
    /**
     * Name for your bulk job
     */
    name?: string;
    /**
     * Whether the job is ready to be executed. Must be true or false.
     */
    ready_to_execute?: boolean;
  };
  path: {
    /**
     * The id for the bulk job to which the job data relates
     */
    id: number;
  };
};

export type PutV2BulkJobsByIdResponse = BulkJob;

export type PutV2BulkJobsByIdError = unknown;

export type GetV2CadenceExportsByIdJsonData = {
  path: {
    /**
     * Cadence ID
     */
    id: string;
  };
};

export type GetV2CadenceExportsByIdJsonResponse = CadenceExport;

export type GetV2CadenceExportsByIdJsonError = unknown;

export type PostV2CadenceImportsJsonData = {
  body?: {
    /**
     * Import data for cadence
     */
    cadence_content?: {
      [key: string]: unknown;
    };
    /**
     * Settings for a cadence
     */
    settings?: {
      [key: string]: unknown;
    };
    /**
     * The shared settings for a cadence
     */
    sharing_settings?: {
      [key: string]: unknown;
    };
  };
};

export type PostV2CadenceImportsJsonResponse = CadenceImport;

export type PostV2CadenceImportsJsonError = unknown;

export type GetV2CadenceMembershipsJsonData = {
  query?: {
    /**
     * ID of the cadence to find cadence memberships for
     */
    cadence_id?: number;
    /**
     * If true, return only cadence memberships for people currently on cadences.  If false, return cadence memberships for people who have been removed from or have completed a cadence.
     */
    currently_on_cadence?: boolean;
    /**
     * IDs of cadence memberships to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * ID of the person to find cadence memberships for
     */
    person_id?: number;
    /**
     * Key to sort on, must be one of: added_at, updated_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
  };
};

export type GetV2CadenceMembershipsJsonResponse = Array<CadenceMembership>;

export type GetV2CadenceMembershipsJsonError = unknown;

export type PostV2CadenceMembershipsJsonData = {
  query: {
    /**
     * ID of the cadence to create a cadence membership for
     */
    cadence_id: number;
    /**
     * ID of the person to create a cadence membership for
     */
    person_id: number;
    /**
     * ID of the step on which the person should start the cadence. Start on first step is the default behavior without this parameter.
     */
    step_id?: number;
    /**
     * ID of the user to create a cadence membership for. The associated cadence must be owned by the user, or it must be a team cadence
     */
    user_id?: number;
  };
};

export type PostV2CadenceMembershipsJsonResponse = CadenceMembership;

export type PostV2CadenceMembershipsJsonError = unknown;

export type DeleteV2CadenceMembershipsByIdJsonData = {
  path: {
    /**
     * CadenceMembership ID
     */
    id: string;
  };
};

export type DeleteV2CadenceMembershipsByIdJsonResponse = any;

export type DeleteV2CadenceMembershipsByIdJsonError = unknown;

export type GetV2CadenceMembershipsByIdJsonData = {
  path: {
    /**
     * CadenceMembership ID
     */
    id: string;
  };
};

export type GetV2CadenceMembershipsByIdJsonResponse = CadenceMembership;

export type GetV2CadenceMembershipsByIdJsonError = unknown;

export type GetV2CadencesJsonData = {
  query?: {
    /**
     * Filters by whether the Cadences have been archived. Excluding this field will result in both archived and unarchived Cadences to return.
     */
    archived?: boolean;
    /**
     * Filters by group ids. Also supports group ids passed in as a JSON array string
     */
    group_ids?: string;
    /**
     * IDs of cadences to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * Filters cadences by name
     */
    name?: Array<string>;
    /**
     * Filters cadences by the owner's guid. Multiple owner guids can be applied
     */
    owned_by_guid?: Array<string>;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * Filters cadences by whether they are able to have people added to them
     */
    people_addable?: boolean;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filters cadences by whether they are shared
     */
    shared?: boolean;
    /**
     * Key to sort on, must be one of: created_at, updated_at, name. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Filters cadences by whether they are a team cadence or not
     */
    team_cadence?: boolean;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
  };
};

export type GetV2CadencesJsonResponse = Array<Cadence>;

export type GetV2CadencesJsonError = unknown;

export type GetV2CadencesByIdJsonData = {
  path: {
    /**
     * Cadence ID
     */
    id: string;
  };
};

export type GetV2CadencesByIdJsonResponse = Cadence;

export type GetV2CadencesByIdJsonError = unknown;

export type GetV2CalendarEventsData = {
  query?: {
    /**
     * calendar_id of the user who created or included as a guest to the event.
     *
     */
    calendar_id?: string;
    /**
     * Upper bound (exclusive) for a calendar event's start time to filter by.
     * Must be in ISO 8601 format.
     *
     * Example: `2022-02-14T10:12:59+00:00`.
     *
     */
    end_time?: string;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: start_time. Defaults to start_time
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Lower bound (inclusive) for a calendar event's end time to filter by.
     * Must be in ISO 8601 format.
     *
     * Example: `2022-02-14T10:12:59+00:00`.
     *
     */
    start_time?: string;
    /**
     * user_guid of the user who created or included as a guest to the event.
     *
     */
    user_guid?: string;
  };
};

export type GetV2CalendarEventsResponse = Array<CalendarEvent>;

export type GetV2CalendarEventsError = unknown;

export type PostV2CalendarEventsUpsertData = {
  body: {
    /**
     * Should be set to `true` for all day calendar events.
     */
    all_day?: boolean;
    /**
     *   List of attendees of the calendar event.
     * Example:
     * ```
     * {
     * ...
     * "attendees": [
     * {
     * "name": "Alice",
     * "email": "alice@example.com",
     * "status": "accepted",
     * "organizer": true
     * },
     * {
     * "name": "Bob",
     * "email": "bob@example.com",
     * "status": "needsAction",
     * "organizer": false
     * }
     * ]
     * }
     * ```
     * `name`: full name of the attendee
     *
     * `email`: email address of the attendee
     *
     * `status`: one of the following - needsAction, accepted, tentative, declined
     *
     * `organizer`: whether the attendee is the organizer of the calendar event
     *
     */
    attendees?: {
      [key: string]: unknown;
    };
    /**
     *   Calendar ID of the calendar event owner.
     * For the External Calendar connection use `external_{salesloft_user_guid}` format.
     * Example: `external_00210d1a-df8a-459f-af75-89b953b618b0`.
     *
     */
    calendar_id: string;
    /**
     *   Cancellation time of the calendar event, as a combined date-time value in the ISO 8601 format with a time zone offset.
     * Example: `2022-02-14T10:12:59+00:00`.
     *
     */
    canceled_at?: string;
    /**
     * Description of the calendar event
     */
    description?: string;
    /**
     *   End time of the calendar event, as a combined date-time value in the ISO 8601 format with a time zone offset.
     * Example: `2022-02-14T10:12:59+00:00`.
     *
     */
    end_time: string;
    /**
     *   icalUID of the calendar event. Unique identifier for a calendar event across calendars.
     *
     * Used as an upsert key.
     *
     */
    i_cal_uid: string;
    /**
     *   Id of the calendar event, different for each occurrence in a recurring series.
     *
     * Used as an upsert key.
     *
     */
    id: string;
    /**
     * Location of the calendar event as free-form text.
     */
    location?: string;
    /**
     *   Email address of the organizer
     *
     */
    organizer?: string;
    /**
     * Should be set to `true` if this is one of recurring series calendar event.
     */
    recurring?: boolean;
    /**
     *   Start time of the calendar event, as a combined date-time value in the ISO 8601 format with a time zone offset.
     * Example: `2022-02-14T10:12:59+00:00`.
     *
     */
    start_time: string;
    /**
     *   Status of the calendar event. Depending on the status, the calendar event will or will not impact user's availability.
     * Possible values: `confirmed`, `tentative`, `cancelled`.
     * Example: `confirmed`.
     *
     */
    status?: string;
    /**
     * Title of the calendar event
     */
    title?: string;
    /**
     *   Last modification time of the event in the ISO 8601 format with a time zone offset. The event will not be updated if the 'updated_at' timestamp from the payload is earlier than the one in the database.
     * Example: `2022-02-14T10:12:59+00:00`.
     *
     */
    updated_at?: string;
  };
};

export type PostV2CalendarEventsUpsertResponse = CalendarEvent;

export type PostV2CalendarEventsUpsertError = unknown;

export type GetV2CallDataRecordsJsonData = {
  query?: {
    /**
     * Equality filters that are applied to the created_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    created_at?: Array<string>;
    /**
     * Return only call data records which have or do not have a call logged for them
     */
    has_call?: boolean;
    /**
     * IDs of call data records to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filters list by person_id. Multiple person ids can be applied
     */
    person_id?: Array<number>;
    /**
     * Key to sort on, must be one of: created_at, updated_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
    /**
     * Filters list to only include guids
     */
    user_guid?: Array<string>;
  };
};

export type GetV2CallDataRecordsJsonResponse = Array<CallDataRecord>;

export type GetV2CallDataRecordsJsonError = unknown;

export type GetV2CallDataRecordsByIdJsonData = {
  path: {
    /**
     * CallDataRecord ID
     */
    id: string;
  };
};

export type GetV2CallDataRecordsByIdJsonResponse = CallDataRecord;

export type GetV2CallDataRecordsByIdJsonError = unknown;

export type GetV2CallDispositionsJsonData = {
  query?: {
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: name, updated_at. Defaults to name
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to ASC
     */
    sort_direction?: string;
  };
};

export type GetV2CallDispositionsJsonResponse = Array<CallDisposition>;

export type GetV2CallDispositionsJsonError = unknown;

export type GetV2CallSentimentsJsonData = {
  query?: {
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * Filters call sentiments by name
     */
    name?: string;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: name, updated_at. Defaults to name
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to ASC
     */
    sort_direction?: string;
  };
};

export type GetV2CallSentimentsJsonResponse = Array<CallSentiment>;

export type GetV2CallSentimentsJsonError = unknown;

export type PostV2ConversationsCallsData = {
  body: {
    /**
     * Timestamp for when the call started. If not provided, will default to the time the request was received
     */
    call_created_at?: string;
    /**
     * Call direction
     */
    direction?: string;
    /**
     * Duration of call in seconds
     */
    duration: number;
    /**
     * Phone number that call was made from
     */
    from: string;
    /**
     * Object containing recording info including the audio file (.mp3, .wav, .ogg, .m4a)
     */
    recording: {
      [key: string]: unknown;
    };
    /**
     *  Phone number that was called
     */
    to: string;
    /**
     * Guid of the Salesloft User to assign the call to. If not provided, will default to the user within the authentication token
     */
    user_guid?: string;
  };
};

export type PostV2ConversationsCallsResponse = ConversationsCall;

export type PostV2ConversationsCallsError = unknown;

export type GetV2CrmActivitiesJsonData = {
  query?: {
    /**
     * IDs of crm activities to fetch.
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: created_at, updated_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
  };
};

export type GetV2CrmActivitiesJsonResponse = Array<CrmActivity>;

export type GetV2CrmActivitiesJsonError = unknown;

export type GetV2CrmActivitiesByIdJsonData = {
  path: {
    /**
     * Crm activity ID
     */
    id: string;
  };
};

export type GetV2CrmActivitiesByIdJsonResponse = CrmActivity;

export type GetV2CrmActivitiesByIdJsonError = unknown;

export type GetV2CrmActivityFieldsJsonData = {
  query?: {
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: title, updated_at. Defaults to title
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to ASC
     */
    sort_direction?: string;
    /**
     * Return only records with this source
     */
    source?: string;
  };
};

export type GetV2CrmActivityFieldsJsonResponse = Array<CrmActivityField>;

export type GetV2CrmActivityFieldsJsonError = unknown;

export type GetV2CrmUsersJsonData = {
  query?: {
    /**
     * Filters crm users by crm_ids
     */
    crm_id?: Array<string>;
    /**
     * IDs of crm users to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: id, updated_at. Defaults to id
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Filters crm users by user guids
     */
    user_guid?: Array<string>;
    /**
     * Filters crm users by user_ids
     */
    user_id?: Array<number>;
  };
};

export type GetV2CrmUsersJsonResponse = Array<CrmUser>;

export type GetV2CrmUsersJsonError = unknown;

export type GetV2CustomFieldsJsonData = {
  query?: {
    /**
     * Type of field to fetch. Value must be one of: person, company, opportunity
     */
    field_type?: string;
    /**
     * IDs of custom fields to fetch.
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: created_at, updated_at, name. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
  };
};

export type GetV2CustomFieldsJsonResponse = Array<CustomField>;

export type GetV2CustomFieldsJsonError = unknown;

export type PostV2CustomFieldsJsonData = {
  body: {
    /**
     * The field type of the custom field. Value must be one of: person, company, opportunity
     */
    field_type?: string;
    /**
     * The name of the custom field
     */
    name: string;
  };
};

export type PostV2CustomFieldsJsonResponse = CustomField;

export type PostV2CustomFieldsJsonError = unknown;

export type DeleteV2CustomFieldsByIdJsonData = {
  path: {
    /**
     * Custom Field ID
     */
    id: string;
  };
};

export type DeleteV2CustomFieldsByIdJsonResponse = any;

export type DeleteV2CustomFieldsByIdJsonError = unknown;

export type GetV2CustomFieldsByIdJsonData = {
  path: {
    /**
     * Custom Field ID
     */
    id: string;
  };
};

export type GetV2CustomFieldsByIdJsonResponse = CustomField;

export type GetV2CustomFieldsByIdJsonError = unknown;

export type PutV2CustomFieldsByIdJsonData = {
  body?: {
    /**
     * The field type of the custom field. Value must be one of: person, company, opportunity
     */
    field_type?: string;
    /**
     * The name of the custom field
     */
    name?: string;
  };
  path: {
    /**
     * Custom Field ID
     */
    id: string;
  };
};

export type PutV2CustomFieldsByIdJsonResponse = CustomField;

export type PutV2CustomFieldsByIdJsonError = unknown;

export type GetV2CustomRolesJsonData = {
  query?: {
    /**
     * IDs of roles to fetch.
     */
    ids?: Array<string>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: id, name. Defaults to id
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
  };
};

export type GetV2CustomRolesJsonResponse = Array<CustomRole>;

export type GetV2CustomRolesJsonError = unknown;

export type GetV2CustomRolesByIdJsonData = {
  path: {
    /**
     * Custom Role ID
     */
    id: string;
  };
};

export type GetV2CustomRolesByIdJsonResponse = CustomRole;

export type GetV2CustomRolesByIdJsonError = unknown;

export type GetV2EmailTemplateAttachmentsJsonData = {
  query?: {
    /**
     * Filters email template attachments by email template IDs
     */
    email_template_id?: Array<number>;
    /**
     * IDs of email template attachments to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
  };
};

export type GetV2EmailTemplateAttachmentsJsonResponse = Array<EmailTemplateAttachment>;

export type GetV2EmailTemplateAttachmentsJsonError = unknown;

export type GetV2EmailTemplatesJsonData = {
  query?: {
    /**
     * Filters email templates to those belonging to the cadence. Not to exceed 100 IDs. If a record can't be found, that record won't be returned and your request will be successful
     */
    cadence_id?: Array<number>;
    /**
     * Filters email templates by current authenticated user
     */
    filter_by_owner?: boolean;
    /**
     * Filters email templates by groups applied to the template by group ID. Not to exceed 500 IDs. Returns templates that are assigned to any of the group ids.
     */
    group_id?: Array<number>;
    /**
     * IDs of email templates to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Filters email templates to include archived templates or not
     */
    include_archived_templates?: boolean;
    /**
     * Filters email templates based on whether or not the template has been used on a cadence
     */
    include_cadence_templates?: boolean;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * Filters email templates by whether they are linked to a team template or not
     */
    linked_to_team_template?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filters email templates by title or subject
     */
    search?: string;
    /**
     * Key to sort on, must be one of: created_at, updated_at, last_used_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Filters email templates by tags applied to the template, not to exceed 100 tags
     */
    tag?: Array<string>;
    /**
     * Filters email templates by tags applied to the template by tag ID, not to exceed 100 IDs
     */
    tag_ids?: Array<number>;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
  };
};

export type GetV2EmailTemplatesJsonResponse = Array<EmailTemplate>;

export type GetV2EmailTemplatesJsonError = unknown;

export type GetV2EmailTemplatesByIdJsonData = {
  path: {
    /**
     * EmailTemplate ID
     */
    id: string;
  };
  query?: {
    /**
     * Optionally will return the templates with the current user's email signature
     */
    include_signature?: boolean;
  };
};

export type GetV2EmailTemplatesByIdJsonResponse = EmailTemplate;

export type GetV2EmailTemplatesByIdJsonError = unknown;

export type PostV2ExternalEmailsJsonData = {
  body: {
    /**
     * Email address of mailbox email was sent to
     */
    mailbox: string;
    /**
     * Base64 encoded MIME email content
     */
    raw: string;
  };
};

export type PostV2ExternalEmailsJsonResponse = ExternalEmail;

export type PostV2ExternalEmailsJsonError = unknown;

export type GetV2GroupsJsonData = {
  query?: {
    /**
     * IDs of groups to fetch.
     */
    ids?: Array<number>;
    /**
     * Key to sort on, must be one of: created_at, updated_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
  };
};

export type GetV2GroupsJsonResponse = Array<Group>;

export type GetV2GroupsJsonError = unknown;

export type GetV2GroupsByIdJsonData = {
  path: {
    /**
     * Group ID
     */
    id: string;
  };
};

export type GetV2GroupsByIdJsonResponse = Group;

export type GetV2GroupsByIdJsonError = unknown;

export type GetV2ImportsJsonData = {
  query?: {
    /**
     * IDs of imports to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: created_at, updated_at. Defaults to created_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * ID of users to fetch imports for. Using this filter will return an empty array for non-admin users who request other user's imports
     */
    user_ids?: Array<number>;
  };
};

export type GetV2ImportsJsonResponse = Array<Import>;

export type GetV2ImportsJsonError = unknown;

export type PostV2ImportsJsonData = {
  body?: {
    /**
     * Name, recommended to be easily identifiable to a user
     */
    name?: string;
    /**
     * ID of the User that owns this Import
     */
    user_id?: number;
  };
};

export type PostV2ImportsJsonResponse = Import;

export type PostV2ImportsJsonError = unknown;

export type DeleteV2ImportsByIdJsonData = {
  path: {
    /**
     * Import ID
     */
    id: string;
  };
  query?: {
    /**
     * Whether to delete people on this Import. Possible values are: [not present], all, single.
     *
     * 'single' will delete people who are only present in this Import.
     * 'all' will delete people even if they are present in other Imports.
     * Not specifying this parameter will not delete any people
     *
     */
    undo?: string;
  };
};

export type DeleteV2ImportsByIdJsonResponse = any;

export type DeleteV2ImportsByIdJsonError = unknown;

export type GetV2ImportsByIdJsonData = {
  path: {
    /**
     * Import ID
     */
    id: string;
  };
};

export type GetV2ImportsByIdJsonResponse = Import;

export type GetV2ImportsByIdJsonError = unknown;

export type PutV2ImportsByIdJsonData = {
  body?: {
    /**
     * Name, recommended to be easily identifiable to a user
     */
    name?: string;
    /**
     * ID of the User that owns this Import
     */
    user_id?: number;
  };
  path: {
    /**
     * Import ID
     */
    id: string;
  };
};

export type PutV2ImportsByIdJsonResponse = Import;

export type PutV2ImportsByIdJsonError = unknown;

export type PostV2LiveWebsiteTrackingParametersJsonData = {
  body: {
    /**
     * The person to create the LiveWebsiteTrackingParameter for
     */
    person_id: number;
  };
};

export type PostV2LiveWebsiteTrackingParametersJsonResponse = LiveWebsiteTrackingParameter;

export type PostV2LiveWebsiteTrackingParametersJsonError = unknown;

export type GetV2MeJsonResponse = User;

export type GetV2MeJsonError = unknown;

export type GetV2MeetingsJsonData = {
  query?: {
    /**
     * Filters meetings by account_id. Multiple account ids can be applied
     */
    account_id?: string;
    /**
     * Equality filters that are applied to the created_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    created_at?: Array<string>;
    /**
     * List of event IDs. If both event_ids and i_cal_uids params are passed, this filters will be ORed. If a record can't be found, that record won't be returned and your request will be successful
     */
    event_ids?: Array<string>;
    /**
     * List of UIDs provided by calendar provider. If both event_ids and i_cal_uids params are passed, this filters will be ORed. If a record can't be found, that record won't be returned and your request will be successful
     */
    i_cal_uids?: Array<string>;
    /**
     * IDs of meetings to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Flag to indicate whether to include owned_by_meetings_settings and booked_by_meetings_settings objects
     */
    include_meetings_settings?: boolean;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filters meetings by person_id. Multiple person ids can be applied
     */
    person_id?: string;
    /**
     * Filters meetings by person_id. Multiple person ids can be applied
     */
    person_ids?: Array<number>;
    /**
     * Whether to include deleted events in the result
     */
    show_deleted?: boolean;
    /**
     * Key to sort on, must be one of: start_time, created_at, updated_at. Defaults to start_time
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Equality filters that are applied to the start_time field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    start_time?: Array<string>;
    /**
     * Filters meetings by status. Possible values are: pending, booked, failed, retry
     */
    status?: string;
    /**
     * Filters meetings by task_id. Multiple task ids can be applied
     */
    task_ids?: Array<number>;
    /**
     * Filters meetings by user_guid. Multiple user guids can be applied
     */
    user_guids?: Array<string>;
  };
};

export type GetV2MeetingsJsonResponse = Array<Meeting>;

export type GetV2MeetingsJsonError = unknown;

export type PostV2MeetingsSettingsSearchesJsonData = {
  query?: {
    /**
     * Filters meeting settings by calendar type
     */
    calendar_type?: string;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
    /**
     * Filters meeting settings by array of user_guids
     */
    user_guids?: Array<string>;
  };
};

export type PostV2MeetingsSettingsSearchesJsonResponse = Array<MeetingSetting>;

export type PostV2MeetingsSettingsSearchesJsonError = unknown;

export type PutV2MeetingsSettingsByIdJsonData = {
  body?: {
    /**
     * Allow other team members to schedule on you behalf.
     */
    allow_booking_on_behalf?: boolean;
    /**
     * Allow team members to insert available time outside your working hours.
     */
    allow_booking_overtime?: boolean;
    /**
     * Allow team members to double book events on your calendar.
     */
    allow_event_overlap?: boolean;
    /**
     * The number of days out the user allows a prospect to schedule a meeting
     */
    availability_limit?: number;
    /**
     * If Availability Limits have been turned on
     */
    availability_limit_enabled?: boolean;
    /**
     * Default buffer duration in minutes set by a user
     */
    buffer_time_duration?: number;
    /**
     * Calendar type
     */
    calendar_type?: string;
    /**
     * Default meeting length in minutes set by the user
     */
    default_meeting_length?: number;
    /**
     * Default description of the meeting
     */
    description?: string;
    /**
     * Determines if a user enabled Calendar Sync feature
     */
    enable_calendar_sync?: boolean;
    /**
     * Determines if location will be filled via third-party service (Zoom, GoToMeeting, etc.)
     */
    enable_dynamic_location?: boolean;
    /**
     * Default location of the meeting
     */
    location?: string;
    /**
     * Determines if the user lost calendar connection
     */
    primary_calendar_connection_failed?: boolean;
    /**
     * ID of the primary calendar
     */
    primary_calendar_id?: string;
    /**
     * Display name of the primary calendar
     */
    primary_calendar_name?: string;
    /**
     * Determines if a user enabled reschedule meetings feature
     */
    reschedule_meetings_enabled?: boolean;
    /**
     * Determines if meetings are scheduled with a 15 minute buffer between them
     */
    schedule_buffer_enabled?: boolean;
    /**
     * The number of hours in advance a user requires someone to a book a meeting with them
     */
    schedule_delay?: number;
    /**
     * Allow team members to see the details of events on your calendar.
     */
    share_event_detail?: boolean;
    /**
     * Time zone for current calendar
     */
    time_zone?: string;
    /**
     * Times available set by a user that can be used to book meetings
     */
    times_available?: {
      [key: string]: unknown;
    };
    /**
     * Default title of the meeting
     */
    title?: string;
  };
  path: {
    /**
     * MeetingSetting ID
     */
    id: string;
  };
};

export type PutV2MeetingsSettingsByIdJsonResponse = MeetingSetting;

export type PutV2MeetingsSettingsByIdJsonError = unknown;

export type PutV2MeetingsByIdJsonData = {
  body?: {
    /**
     * Meeting ID from the calendar provider
     */
    event_id?: string;
    /**
     * Meeting unique identifier (iCalUID)
     */
    i_cal_uid?: string;
    /**
     * Whether the meeting is a No Show meeting
     */
    no_show?: boolean;
    /**
     * Status of the meeting rescheduling progress. Possible values are: pending, booked, failed, retry
     */
    reschedule_status?: string;
    /**
     * Status of the meeting creation progress. Possible values are: pending, booked, failed, retry
     */
    status?: string;
  };
  path: {
    /**
     * Meeting ID
     */
    id: string;
  };
};

export type PutV2MeetingsByIdJsonResponse = Meeting;

export type PutV2MeetingsByIdJsonError = unknown;

export type GetV2MimeEmailPayloadsByIdJsonData = {
  path: {
    /**
     * ID of Email
     */
    id: string;
  };
};

export type GetV2MimeEmailPayloadsByIdJsonResponse = MimeEmailPayload;

export type GetV2MimeEmailPayloadsByIdJsonError = unknown;

export type GetV2NotesJsonData = {
  query?: {
    /**
     * ID of the item with which the note is associated.  The associated_with_type must also be present if this parameter is used
     */
    associated_with_id?: number;
    /**
     * Case insensitive type of item with which the note is associated.  Value must be one of: person, account
     */
    associated_with_type?: string;
    /**
     * IDs of notes to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: created_at, updated_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
  };
};

export type GetV2NotesJsonResponse = Array<Note>;

export type GetV2NotesJsonError = unknown;

export type PostV2NotesJsonData = {
  body: {
    /**
     * ID of the item with which the note is associated
     */
    associated_with_id: number;
    /**
     * Case insensitive type of item with which the note is associated.  Value must be one of: person, account
     */
    associated_with_type: string;
    /**
     * ID of the call with which the note is associated. The call cannot already have a note
     */
    call_id?: number;
    /**
     * The content of the note
     */
    content: string;
    /**
     * Boolean indicating if the CRM sync should be skipped.  No syncing will occur if true
     */
    skip_crm_sync?: boolean;
    /**
     * The subject of the note's crm activity, defaults to 'Note'
     */
    subject?: string;
    /**
     * The user to create the note for. Only team admins may create notes on behalf of other users. Defaults to the requesting user
     */
    user_guid?: string;
  };
};

export type PostV2NotesJsonResponse = Note;

export type PostV2NotesJsonError = unknown;

export type DeleteV2NotesByIdJsonData = {
  path: {
    /**
     * Note ID
     */
    id: string;
  };
};

export type DeleteV2NotesByIdJsonResponse = any;

export type DeleteV2NotesByIdJsonError = unknown;

export type GetV2NotesByIdJsonData = {
  path: {
    /**
     * Note ID
     */
    id: string;
  };
};

export type GetV2NotesByIdJsonResponse = Note;

export type GetV2NotesByIdJsonError = unknown;

export type PutV2NotesByIdJsonData = {
  body: {
    /**
     * ID of the call with which the note is associated. The call cannot already have a note. If the note is associated to a call already, it will become associated to the requested call
     */
    call_id?: number;
    /**
     * The content of the note
     */
    content: string;
  };
  path: {
    /**
     * Note ID
     */
    id: string;
  };
};

export type PutV2NotesByIdJsonResponse = Person;

export type PutV2NotesByIdJsonError = unknown;

export type PostV2OngoingActionsJsonData = {
  body?: {
    /**
     * Action that is being marked ongoing. This will validate that the action is still
     * valid before modifying it. Ongoing actions can not be marked ongoing.
     *
     */
    action_id?: number;
  };
};

export type PostV2OngoingActionsJsonResponse = Action;

export type PostV2OngoingActionsJsonError = unknown;

export type GetV2PendingEmailsJsonData = {
  query?: {
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
  };
};

export type GetV2PendingEmailsJsonResponse = Array<PendingEmail>;

export type GetV2PendingEmailsJsonError = unknown;

export type PutV2PendingEmailsByIdJsonData = {
  body: {
    /**
     * The error message indicating why the email failed to send
     */
    error_message?: string;
    /**
     * The message id of the email that was sent
     */
    message_id: string;
    /**
     * The time that the email was actually sent in iso8601 format
     */
    sent_at?: string;
    /**
     * Delivery status of the email.  Valid statuses are 'sent' and 'failed'
     */
    status: string;
  };
  path: {
    /**
     * Email ID
     */
    id: string;
  };
};

export type PutV2PendingEmailsByIdJsonResponse = PendingEmail;

export type PutV2PendingEmailsByIdJsonError = unknown;

export type GetV2PeopleJsonData = {
  query?: {
    /**
     * For internal use only. This field does not comply with our backwards compatibility policies. This filter is for authenticated users of Salesloft only and will not work for OAuth Applications. Filters people by the string provided. Can search and filter by name, title, industry, email_address and linked account name.
     */
    _query?: string;
    /**
     * Filters people by the account they are linked to. Multiple account ids can be applied
     */
    account_id?: Array<number>;
    /**
     * Filters people by whether an email that was sent to them bounced or not.
     */
    bounced?: boolean;
    /**
     * Filters people by the cadence that they are currently on. Multiple cadence_ids can be applied. An additional value of "_is_null" can be passed to filter people that are not on a cadence.
     */
    cadence_id?: Array<number>;
    /**
     * Includes people that can be called given do_not_contact and contact_restrictions property
     */
    can_call?: boolean;
    /**
     * Includes people that can be emailed given do_not_contact and contact_restrictions property
     */
    can_email?: boolean;
    /**
     * Includes people that can be sent a text message given do_not_contact and contact_restrictions property
     */
    can_text?: boolean;
    /**
     * Filters people by their city by exact match. Supports partial matching
     */
    city?: Array<string>;
    /**
     * Filters people by their country by exact match. Supports partial matching
     */
    country?: Array<string>;
    /**
     * Equality filters that are applied to the last_contacted field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    created_at?: {
      [key: string]: unknown;
    };
    /**
     * Filters people by crm_id. Multiple crm ids can be applied
     */
    crm_id?: Array<string>;
    /**
     * Filters by people matching all given custom fields. The custom field names are case-sensitive, but the provided values are case-insensitive. Example: v2/people?custom_fields[custom_field_name]=custom_field_value
     */
    custom_fields?: {
      [key: string]: unknown;
    };
    /**
     * Includes people that have a given do_not_contact property
     */
    do_not_contact?: boolean;
    /**
     * Filters people by email address. Multiple emails can be applied. An additional value of "_is_null" can be passed to filter people that do not have an email address.
     */
    email_addresses?: Array<string>;
    /**
     * Filters people by whether or not they are marked as an European Union Resident or not.
     */
    eu_resident?: boolean;
    /**
     * IDs of people to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Filters people that were imported by the given import ids. Multiple import ids can be applied. An additional value of "_is_null" can be passed to filter people that were not imported.
     */
    import_id?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Filters people by job seniorty. Multiple job seniorities can be applied. An additional value of "_is_null" can be passed to filter people do not have a job_seniority.
     */
    job_seniority?: Array<string>;
    /**
     * Equality filters that are applied to the last_contacted field. A single filter can be used by itself or combined with other filters to create a range.
     * Additional values of "_is_null" or "_is_not_null" can be passed to filter records that either have no timestamp value or any timestamp value.
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    last_contacted?: {
      [key: string]: unknown;
    };
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * Filters people by locales. Multiple locales can be applied. An additional value of "Null" can be passed to filter people that do not have a locale.
     */
    locales?: Array<string>;
    /**
     * Filters people by whether or not that person is on a cadence or if they have been contacted in any way.
     */
    new?: boolean;
    /**
     * Filters people by the owner's guid. Multiple owner guids can be applied
     */
    owned_by_guid?: Array<string>;
    /**
     * Filters people by owner_crm_id. Multiple owner_crm_ids can be applied. An additional value of "_is_null" can be passed to filter people that are unowned. A "_not_in" modifier can be used to exclude specific owner_crm_ids. Example: v2/people?owner_crm_id[_not_in]=id
     */
    owner_crm_id?: Array<string>;
    /**
     * Filters people by owner_id. Multiple owner_ids can be applied.
     */
    owner_id?: Array<number>;
    /**
     * Filters people by whether the owner is active or not.
     */
    owner_is_active?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Includes people that have a given person_stage. Multiple person stage ids can be applied. An additional value of "_is_null" can be passed to filter people that do not have a stage set.
     */
    person_stage_id?: Array<number>;
    /**
     * Filter people by whether or not they have a phone number or not
     */
    phone_number?: boolean;
    /**
     * Filters people by whether or not they have replied to an email or not.
     */
    replied?: boolean;
    /**
     * Key to sort on, must be one of: created_at, updated_at, last_contacted_at, name, title, job_seniority, call_count, sent_emails, clicked_emails, replied_emails, viewed_emails, account, cadence_stage_name. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Filters people who have been starred by the user guids given.
     */
    starred_by_guid?: Array<string>;
    /**
     * Filters people by their state by exact match. Supports partial matching
     */
    state?: Array<string>;
    /**
     * Filters people by whether or not they have been marked as a success or not.
     */
    success?: boolean;
    /**
     * Filters people by the tag ids applied to the person. Multiple tag ids can be applied.
     */
    tag_id?: Array<number>;
    /**
     * Filters people by their title by exact match. Supports partial matching
     */
    title?: Array<string>;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
  };
};

export type GetV2PeopleJsonResponse = Array<Person>;

export type GetV2PeopleJsonError = unknown;

export type PostV2PeopleJsonData = {
  body?: {
    /**
     * ID of the Account to link this person to
     */
    account_id?: number;
    /**
     * Whether the date should be added to this person as a tag. Default is false. The tag will be Y-m-d format.
     */
    autotag_date?: boolean;
    /**
     * City
     */
    city?: string;
    /**
     * Specific methods of communication to prevent for this person. This will prevent individual execution of these communication types as well as automatically skip cadence steps of this communication type for this person in SalesLoft. Values currently accepted: call, email, message
     */
    contact_restrictions?: Array<string>;
    /**
     * Country
     */
    country?: string;
    /**
     * Requires Salesforce.
     *
     * ID of the person in your external CRM. You must provide a crm_id_type if this is included.
     *
     * Validations will be applied to the crm_id depending on the crm_id_type. A "salesforce" ID must be exactly 18 characters. A "salesforce" ID must be either a Lead (00Q) or Contact (003) object. The type will be validated using the 18 character ID.
     *
     * This field can only be used if your application or API key has the "person:set_crm_id" scope.
     *
     *
     */
    crm_id?: string;
    /**
     * The CRM that the provided crm_id is for. Must be one of: salesforce
     */
    crm_id_type?: string;
    /**
     * Custom fields are defined by the user's team. Only fields with values are presented in the API.
     */
    custom_fields?: {
      [key: string]: unknown;
    };
    /**
     * Whether or not this person has opted out of all communication. Setting this value to true prevents this person from being called, emailed, or added to a cadence in SalesLoft. If this person is currently in a cadence, they will be removed.
     */
    do_not_contact?: boolean;
    /**
     * Email address
     */
    email_address?: string;
    /**
     * First name
     */
    first_name?: string;
    /**
     * Home phone without formatting
     */
    home_phone?: string;
    /**
     * ID of the Import this person is a part of. A person can be part of multiple imports, but this ID will always be the most recent Import
     */
    import_id?: number;
    /**
     * The Job Seniority of a Person, must be one of director, executive, individual_contributor, manager, vice_president, unknown
     */
    job_seniority?: string;
    /**
     * Last name
     */
    last_name?: string;
    /**
     * Linkedin URL
     */
    linkedin_url?: string;
    /**
     * Time locale of the person
     */
    locale?: string;
    /**
     * Mobile phone without formatting
     */
    mobile_phone?: string;
    /**
     * ID of the User that owns this person
     */
    owner_id?: number;
    /**
     * Company industry. This property is specific to this person, unrelated to the company object. Updating the company object associated with this person is recommended
     */
    person_company_industry?: string;
    /**
     * Company name. This property is specific to this person, unrelated to the company object. Updating the company object associated with this person is recommended
     */
    person_company_name?: string;
    /**
     * Company website. This property is specific to this person, unrelated to the company object. Updating the company object associated with this person is recommended
     */
    person_company_website?: string;
    /**
     * ID of the PersonStage of this person
     */
    person_stage_id?: number;
    /**
     * Personal email address
     */
    personal_email_address?: string;
    /**
     * The website of this person
     */
    personal_website?: string;
    /**
     * Phone without formatting
     */
    phone?: string;
    /**
     * Phone extension without formatting
     */
    phone_extension?: string;
    /**
     * Alternate email address
     */
    secondary_email_address?: string;
    /**
     * State
     */
    state?: string;
    /**
     * All tags applied to this person
     */
    tags?: Array<string>;
    /**
     * Job title
     */
    title?: string;
    /**
     * The twitter handle of this person
     */
    twitter_handle?: string;
    /**
     * Work location - city
     */
    work_city?: string;
    /**
     * Work location - country
     */
    work_country?: string;
    /**
     * Work location - state
     */
    work_state?: string;
  };
};

export type PostV2PeopleJsonResponse = Person;

export type PostV2PeopleJsonError = unknown;

export type DeleteV2PeopleByIdJsonData = {
  path: {
    /**
     * Person id
     */
    id: string;
  };
};

export type DeleteV2PeopleByIdJsonResponse = any;

export type DeleteV2PeopleByIdJsonError = unknown;

export type GetV2PeopleByIdJsonData = {
  path: {
    /**
     * Person ID
     */
    id: string;
  };
};

export type GetV2PeopleByIdJsonResponse = Person;

export type GetV2PeopleByIdJsonError = unknown;

export type PutV2PeopleByIdJsonData = {
  body?: {
    /**
     * ID of the Account to link this person to
     */
    account_id?: number;
    /**
     * City
     */
    city?: string;
    /**
     * Specific methods of communication to prevent for this person. This will prevent individual execution of these communication types as well as automatically skip cadence steps of this communication type for this person in SalesLoft. Values currently accepted: call, email, message
     */
    contact_restrictions?: Array<string>;
    /**
     * Country
     */
    country?: string;
    /**
     * Requires Salesforce.
     *
     * ID of the person in your external CRM. You must provide a crm_id_type if this is included.
     *
     * Validations will be applied to the crm_id depending on the crm_id_type. A "salesforce" ID must be exactly 18 characters. A "salesforce" ID must be either a Lead (00Q) or Contact (003) object. The type will be validated using the 18 character ID.
     *
     * This field can only be used if your application or API key has the "person:set_crm_id" scope.
     *
     *
     */
    crm_id?: string;
    /**
     * The CRM that the provided crm_id is for. Must be one of: salesforce
     */
    crm_id_type?: string;
    /**
     * Custom fields are defined by the user's team. Only fields with values are presented in the API.
     */
    custom_fields?: {
      [key: string]: unknown;
    };
    /**
     * Whether or not this person has opted out of all communication. Setting this value to true prevents this person from being called, emailed, or added to a cadence in SalesLoft. If this person is currently in a cadence, they will be removed.
     */
    do_not_contact?: boolean;
    /**
     * Email address
     */
    email_address?: string;
    /**
     * First name
     */
    first_name?: string;
    /**
     * Home phone without formatting
     */
    home_phone?: string;
    /**
     * ID of the Import this person is a part of. A person can be part of multiple imports, but this ID will always be the most recent Import
     */
    import_id?: number;
    /**
     * The Job Seniority of a Person, must be one of director, executive, individual_contributor, manager, vice_president, unknown
     */
    job_seniority?: string;
    /**
     * Last name
     */
    last_name?: string;
    /**
     * Linkedin URL
     */
    linkedin_url?: string;
    /**
     * Time locale of the person
     */
    locale?: string;
    /**
     * Mobile phone without formatting
     */
    mobile_phone?: string;
    /**
     * ID of the User that owns this person
     */
    owner_id?: number;
    /**
     * Company industry. This property is specific to this person, unrelated to the company object. Updating the company object associated with this person is recommended
     */
    person_company_industry?: string;
    /**
     * Company name. This property is specific to this person, unrelated to the company object. Updating the company object associated with this person is recommended
     */
    person_company_name?: string;
    /**
     * Company website. This property is specific to this person, unrelated to the company object. Updating the company object associated with this person is recommended
     */
    person_company_website?: string;
    /**
     * ID of the PersonStage of this person
     */
    person_stage_id?: number;
    /**
     * Personal email address
     */
    personal_email_address?: string;
    /**
     * The website of this person
     */
    personal_website?: string;
    /**
     * Phone without formatting
     */
    phone?: string;
    /**
     * Phone extension without formatting
     */
    phone_extension?: string;
    /**
     * Alternate email address
     */
    secondary_email_address?: string;
    /**
     * State
     */
    state?: string;
    /**
     * All tags applied to this person
     */
    tags?: Array<string>;
    /**
     * Job title
     */
    title?: string;
    /**
     * The twitter handle of this person
     */
    twitter_handle?: string;
    /**
     * Work location - city
     */
    work_city?: string;
    /**
     * Work location - country
     */
    work_country?: string;
    /**
     * Work location - state
     */
    work_state?: string;
  };
  path: {
    /**
     * Person id
     */
    id: string;
  };
};

export type PutV2PeopleByIdJsonResponse = Person;

export type PutV2PeopleByIdJsonError = unknown;

export type GetV2PersonStagesJsonData = {
  query?: {
    /**
     * IDs of person stages to fetch.
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: created_at, updated_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
  };
};

export type GetV2PersonStagesJsonResponse = Array<PersonStage>;

export type GetV2PersonStagesJsonError = unknown;

export type PostV2PersonStagesJsonData = {
  body: {
    /**
     * The name of the new stage
     */
    name: string;
  };
};

export type PostV2PersonStagesJsonResponse = PersonStage;

export type PostV2PersonStagesJsonError = unknown;

export type DeleteV2PersonStagesByIdJsonData = {
  path: {
    /**
     * Stage ID
     */
    id: string;
  };
};

export type DeleteV2PersonStagesByIdJsonResponse = any;

export type DeleteV2PersonStagesByIdJsonError = unknown;

export type GetV2PersonStagesByIdJsonData = {
  path: {
    /**
     * Stage ID
     */
    id: string;
  };
};

export type GetV2PersonStagesByIdJsonResponse = PersonStage;

export type GetV2PersonStagesByIdJsonError = unknown;

export type PutV2PersonStagesByIdJsonData = {
  body: {
    /**
     * The name of the stage.
     */
    name: string;
  };
  path: {
    /**
     * Stage ID
     */
    id: string;
  };
};

export type PutV2PersonStagesByIdJsonResponse = PersonStage;

export type PutV2PersonStagesByIdJsonError = unknown;

export type PostV2PersonUpsertsJsonData = {
  body?: {
    /**
     * ID of the Account to link this person to
     */
    account_id?: number;
    /**
     * City
     */
    city?: string;
    /**
     * Specific methods of communication to prevent for this person. This will prevent individual execution of these communication types as well as automatically skip cadence steps of this communication type for this person in SalesLoft. Values currently accepted: call, email, message
     */
    contact_restrictions?: Array<string>;
    /**
     * Country
     */
    country?: string;
    /**
     * Requires Salesforce.
     *
     * ID of the person in your external CRM. You must provide a crm_id_type if this is included.
     *
     * Validations will be applied to the crm_id depending on the crm_id_type. A "salesforce" ID must be exactly 18 characters. A "salesforce" ID must be either a Lead (00Q) or Contact (003) object. The type will be validated using the 18 character ID.
     *
     * This field can only be used if your application or API key has the "person:set_crm_id" scope.
     *
     *
     */
    crm_id?: string;
    /**
     * The CRM that the provided crm_id is for. Must be one of: salesforce
     */
    crm_id_type?: string;
    /**
     * Custom fields are defined by the user's team. Only fields with values are presented in the API.
     */
    custom_fields?: {
      [key: string]: unknown;
    };
    /**
     * Whether or not this person has opted out of all communication. Setting this value to true prevents this person from being called, emailed, or added to a cadence in SalesLoft. If this person is currently in a cadence, they will be removed.
     */
    do_not_contact?: boolean;
    /**
     * Email address
     */
    email_address?: string;
    /**
     * First name
     */
    first_name?: string;
    /**
     * Home phone without formatting
     */
    home_phone?: string;
    /**
     * ID of the person to update. Used if the upsert_key=id. When id and another upsert_key are provided,
     * the request will fail if the upsert record id and id parameter don't match.
     *
     */
    id?: number;
    /**
     * ID of the Import this person is a part of. A person can be part of multiple imports, but this ID will always be the most recent Import
     */
    import_id?: number;
    /**
     * The Job Seniority of a Person, must be one of director, executive, individual_contributor, manager, vice_president, unknown
     */
    job_seniority?: string;
    /**
     * Last name
     */
    last_name?: string;
    /**
     * Linkedin URL
     */
    linkedin_url?: string;
    /**
     * Time locale of the person
     */
    locale?: string;
    /**
     * Mobile phone without formatting
     */
    mobile_phone?: string;
    /**
     * ID of the User that owns this person
     */
    owner_id?: number;
    /**
     * Company industry. This property is specific to this person, unrelated to the company object. Updating the company object associated with this person is recommended
     */
    person_company_industry?: string;
    /**
     * Company name. This property is specific to this person, unrelated to the company object. Updating the company object associated with this person is recommended
     */
    person_company_name?: string;
    /**
     * Company website. This property is specific to this person, unrelated to the company object. Updating the company object associated with this person is recommended
     */
    person_company_website?: string;
    /**
     * ID of the PersonStage of this person
     */
    person_stage_id?: number;
    /**
     * Personal email address
     */
    personal_email_address?: string;
    /**
     * The website of this person
     */
    personal_website?: string;
    /**
     * Phone without formatting
     */
    phone?: string;
    /**
     * Phone extension without formatting
     */
    phone_extension?: string;
    /**
     * Alternate email address
     */
    secondary_email_address?: string;
    /**
     * State
     */
    state?: string;
    /**
     * All tags applied to this person
     */
    tags?: Array<string>;
    /**
     * Job title
     */
    title?: string;
    /**
     * The twitter handle of this person
     */
    twitter_handle?: string;
    /**
     * Name of the parameter to upsert on. The field must be provided in the input parameters, or the request will fail.
     * The request will also fail if there are multiple records matched by the upsert field. This can occur if intentional duplicates
     * by email address is enabled.
     *
     * If upsert_key is not provided, this endpoint will not update an existing record.
     *
     * Valid options are: id, crm_id, email_address. If crm_id is provided, then a valid crm_id_type must be provided, as documented
     * for the person create and update endpoints.
     *
     */
    upsert_key?: string;
    /**
     * Work location - city
     */
    work_city?: string;
    /**
     * Work location - country
     */
    work_country?: string;
    /**
     * Work location - state
     */
    work_state?: string;
  };
};

export type PostV2PersonUpsertsJsonResponse = PersonUpsert;

export type PostV2PersonUpsertsJsonError = unknown;

export type GetV2PhoneNumberAssignmentsJsonData = {
  query?: {
    /**
     * IDs of phone number assignments to fetch
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: created_at, updated_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
  };
};

export type GetV2PhoneNumberAssignmentsJsonResponse = Array<PhoneNumberAssignment>;

export type GetV2PhoneNumberAssignmentsJsonError = unknown;

export type GetV2PhoneNumberAssignmentsByIdJsonData = {
  path: {
    /**
     * PhoneNumberAssignment ID
     */
    id: string;
  };
};

export type GetV2PhoneNumberAssignmentsByIdJsonResponse = PhoneNumberAssignment;

export type GetV2PhoneNumberAssignmentsByIdJsonError = unknown;

export type GetV2PhoneNumbersCallerIdsJsonData = {
  query: {
    /**
     * E.164 Phone Number
     */
    phone_number: string;
  };
};

export type GetV2PhoneNumbersCallerIdsJsonResponse = Array<CallerId>;

export type GetV2PhoneNumbersCallerIdsJsonError = unknown;

export type GetV2PhoneNumbersRecordingSettingsByIdJsonData = {
  path: {
    /**
     * E.164 Phone Number
     */
    id: string;
  };
};

export type GetV2PhoneNumbersRecordingSettingsByIdJsonResponse = RecordingSetting;

export type GetV2PhoneNumbersRecordingSettingsByIdJsonError = unknown;

export type GetV2SavedListViewsJsonData = {
  query?: {
    /**
     * IDs of saved list views to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: name. Defaults to name
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Type of saved list views to fetch.
     */
    view?: string;
  };
};

export type GetV2SavedListViewsJsonResponse = Array<SavedListView>;

export type GetV2SavedListViewsJsonError = unknown;

export type PostV2SavedListViewsJsonData = {
  body: {
    /**
     * Whether the saved list view is the default
     */
    is_default?: boolean;
    /**
     * The name of the saved list view
     */
    name: string;
    /**
     * The type of objects in the saved list view.  Value must be one of: people, companies, or recordings
     */
    view: string;
    /**
     * JSON object of list view parameters
     */
    view_params?: string;
  };
};

export type PostV2SavedListViewsJsonResponse = SavedListView;

export type PostV2SavedListViewsJsonError = unknown;

export type DeleteV2SavedListViewsByIdJsonData = {
  path: {
    /**
     * Saved List View ID
     */
    id: string;
  };
};

export type DeleteV2SavedListViewsByIdJsonResponse = any;

export type DeleteV2SavedListViewsByIdJsonError = unknown;

export type GetV2SavedListViewsByIdJsonData = {
  path: {
    /**
     * Saved List View ID
     */
    id: string;
  };
};

export type GetV2SavedListViewsByIdJsonResponse = SavedListView;

export type GetV2SavedListViewsByIdJsonError = unknown;

export type PutV2SavedListViewsByIdJsonData = {
  body?: {
    /**
     * Whether the saved list view is the default
     */
    is_default?: boolean;
    /**
     * The name of the saved list view
     */
    name?: string;
    /**
     * JSON object of list view parameters
     */
    view_params?: string;
  };
  path: {
    /**
     * Saved List View ID
     */
    id: string;
  };
};

export type PutV2SavedListViewsByIdJsonResponse = SavedListView;

export type PutV2SavedListViewsByIdJsonError = unknown;

export type GetV2StepsJsonData = {
  query?: {
    /**
     * Filter by cadence ID
     */
    cadence_id?: number;
    /**
     * Filter by whether a step has due actions
     */
    has_due_actions?: boolean;
    /**
     * IDs of steps to fetch.
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Key to sort on, must be one of: created_at, updated_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Filter by step type
     */
    type?: string;
  };
};

export type GetV2StepsJsonResponse = Array<Step>;

export type GetV2StepsJsonError = unknown;

export type GetV2StepsByIdJsonData = {
  path: {
    /**
     * Step ID
     */
    id: string;
  };
};

export type GetV2StepsByIdJsonResponse = Step;

export type GetV2StepsByIdJsonError = unknown;

export type GetV2SuccessesJsonData = {
  query?: {
    /**
     * IDs of successes to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filters successes by person_id. Multiple person ids can be applied
     */
    person_id?: Array<number>;
    /**
     * Key to sort on, must be one of: created_at, updated_at, succeeded_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
  };
};

export type GetV2SuccessesJsonResponse = Array<Success>;

export type GetV2SuccessesJsonError = unknown;

export type GetV2TagsJsonData = {
  query?: {
    /**
     * Filters tags by their IDs
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filters tags by name
     */
    search?: string;
    /**
     * Key to sort on, must be one of: name. Defaults to name
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
  };
};

export type GetV2TagsJsonResponse = Array<Tag>;

export type GetV2TagsJsonError = unknown;

export type GetV2TasksJsonData = {
  query?: {
    /**
     * Filters tasks by the account to which they are associated.
     */
    account_id?: Array<number>;
    /**
     * Filters tasks by their current state. Valid current_states include: ['scheduled', 'completed'].
     */
    current_state?: Array<string>;
    /**
     * Filters tasks by idempotency key.
     */
    idempotency_key?: string;
    /**
     * IDs of tasks to fetch.
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * Filters tasks by locale of the person to which they are associated.
     */
    locale?: Array<string>;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filters tasks by the person to which they are associated.
     */
    person_id?: Array<number>;
    /**
     * Key to sort on, must be one of: due_date, due_at. Defaults to due_date
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to ASC
     */
    sort_direction?: string;
    /**
     * Filters tasks by their task type. Valid task_types include: ['call', 'email', 'general'].
     */
    task_type?: Array<string>;
    /**
     * Filters tasks by time interval. Valid time_intervals include: ['overdue', 'today', 'tomorrow', 'this_week', 'next_week'].
     */
    time_interval_filter?: string;
    /**
     * Filters tasks by the user to which they are assigned.
     */
    user_id?: Array<number>;
  };
};

export type GetV2TasksJsonResponse = Array<Task>;

export type GetV2TasksJsonError = unknown;

export type PostV2TasksJsonData = {
  body: {
    /**
     * Current state of the task, valid options are: scheduled
     */
    current_state: string;
    /**
     * A description of the task recorded for person at completion time
     */
    description?: string;
    /**
     * Date of when the Task is due, ISO-8601 date format required
     */
    due_date: string;
    /**
     * Establishes a unique identifier to prevent duplicates from being created
     */
    idempotency_key?: string;
    /**
     * ID of the person to be contacted
     */
    person_id: string;
    /**
     * Datetime of when the user will be reminded of the task, ISO-8601 datetime format required
     */
    remind_at?: string;
    /**
     * Subject line of the task.
     */
    subject: string;
    /**
     * Task type, valid options are: call, email, general
     */
    task_type: string;
    /**
     * ID of the user linked to the task
     */
    user_id: number;
  };
};

export type PostV2TasksJsonResponse = Task;

export type PostV2TasksJsonError = unknown;

export type GetV2TasksByIdJsonData = {
  path: {
    /**
     * Task ID
     */
    id: string;
  };
};

export type GetV2TasksByIdJsonResponse = Step;

export type GetV2TasksByIdJsonError = unknown;

export type PutV2TasksByIdJsonData = {
  body?: {
    /**
     * Current state of the task, valid options are: completed
     */
    current_state?: string;
    /**
     * A description of the task recorded for person at completion time
     */
    description?: string;
    /**
     * Date of when the Task is due, ISO-8601 date format required
     */
    due_date?: string;
    /**
     * A flag to indicate that the task should only be logged
     */
    is_logged?: boolean;
    /**
     * Datetime of when the user will be reminded of the task, ISO-8601 datetime format required
     */
    remind_at?: string;
    /**
     * Subject line of the task
     */
    subject?: string;
  };
  path: {
    /**
     * Task ID
     */
    id: string;
  };
};

export type PutV2TasksByIdJsonResponse = Task;

export type PutV2TasksByIdJsonError = unknown;

export type GetV2TeamJsonResponse = Team;

export type GetV2TeamJsonError = unknown;

export type GetV2TeamTemplateAttachmentsJsonData = {
  query?: {
    /**
     * IDs of team template attachments to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filters template attachments by team template IDs
     */
    team_template_id?: Array<number>;
  };
};

export type GetV2TeamTemplateAttachmentsJsonResponse = Array<TeamTemplateAttachment>;

export type GetV2TeamTemplateAttachmentsJsonError = unknown;

export type GetV2TeamTemplatesJsonData = {
  query?: {
    /**
     * IDs of team templates to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<string>;
    /**
     * Filters email templates to include archived templates or not
     */
    include_archived_templates?: boolean;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * Specifies whether the max limit of 10k records should be applied to pagination counts. Affects the total_count and total_pages data
     */
    limit_paging_counts?: boolean;
    /**
     * The current page to fetch results from. Defaults to 1
     */
    page?: number;
    /**
     * How many records to show per page in the range [1, 100]. Defaults to 25
     */
    per_page?: number;
    /**
     * Filters email templates by title or subject
     */
    search?: string;
    /**
     * Key to sort on, must be one of: created_at, updated_at, last_used_at. Defaults to updated_at
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Filters team templates by tags applied to the template, not to exceed 100 tags
     */
    tag?: Array<string>;
    /**
     * Filters email templates by tags applied to the template by tag ID, not to exceed 100 IDs
     */
    tag_ids?: Array<number>;
    /**
     * Equality filters that are applied to the updated_at field. A single filter can be used by itself or combined with other filters to create a range.
     *
     * ---CUSTOM---
     * {"type":"object","keys":[{"name":"gt","type":"iso8601 string","description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"gte","type":"iso8601 string","description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lt","type":"iso8601 string","description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision."},{"name":"lte","type":"iso8601 string","description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision."}]}
     *
     */
    updated_at?: Array<string>;
  };
};

export type GetV2TeamTemplatesJsonResponse = Array<TeamTemplate>;

export type GetV2TeamTemplatesJsonError = unknown;

export type GetV2TeamTemplatesByIdJsonData = {
  path: {
    /**
     * Team Template ID
     */
    id: string;
  };
  query?: {
    /**
     * Optionally will return the templates with the current user's email signature
     */
    include_signature?: boolean;
  };
};

export type GetV2TeamTemplatesByIdJsonResponse = TeamTemplate;

export type GetV2TeamTemplatesByIdJsonError = unknown;

export type PostV2ThirdPartyLiveFeedItemsData = {
  body: {
    /**
     * Equality filters that are applied to the event_occurred_at field. A single filter can be used by itself or combined with other filters to create a range.
     * ---CUSTOM---
     * {"keys":[{"description":"Returns all matching records that are greater than the provided iso8601 timestamp. The comparison is done using microsecond precision.","name":"gt","type":"iso8601 string"},{"description":"Returns all matching records that are greater than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision.","name":"gte","type":"iso8601 string"},{"description":"Returns all matching records that are less than the provided iso8601 timestamp. The comparison is done using microsecond precision.","name":"lt","type":"iso8601 string"},{"description":"Returns all matching records that are less than or equal to the provided iso8601 timestamp. The comparison is done using microsecond precision.","name":"lte","type":"iso8601 string"}],"type":"object"}
     *
     */
    event_occurred_at: string;
    /**
     * Uniquely provided string specific to this event. This should be a value which can't be duplicated between external systems, meaning that an id is not sufficient.
     */
    idempotency_key: string;
    /**
     * The message that relates to the subject. This message should start with a lower-case past-tense verb and end with a period (e.g. "received a package."). When live feed items are displayed to users, the subject's name is concatenated with the message and a joining space. Only <a> HTML tags with an "href" attribute are allowed. Other attributes and tags will be stripped.
     */
    message: string;
    /**
     * The ID of the subject of the live feed item (i.e. the "person" id).
     */
    subject_id: number;
    /**
     * The type of the subject of the live feed item. Currently only "person" is supported.
     */
    subject_type: string;
    /**
     * The guid for the user that this live feed item should be shown to.
     */
    user_guid: string;
  };
};

export type PostV2ThirdPartyLiveFeedItemsResponse = Array<LiveFeedItem>;

export type PostV2ThirdPartyLiveFeedItemsError = unknown;

export type GetV2UsersJsonData = {
  query?: {
    /**
     * Filters users based on active attribute. Defaults to not applied
     */
    active?: boolean;
    /**
     * Filters users by group_id.  An additional value of "_is_null" can be passed to filter users that are not in a group
     */
    group_id?: Array<string>;
    /**
     * Filters list to only include guids
     */
    guid?: Array<string>;
    /**
     * Filters users based on if they have a crm user mapped or not.
     */
    has_crm_user?: boolean;
    /**
     * IDs of users to fetch. If a record can't be found, that record won't be returned and your request will be successful
     */
    ids?: Array<number>;
    /**
     * Whether to include total_pages and total_count in the metadata. Defaults to false
     */
    include_paging_counts?: boolean;
    /**
     * The current page to fetch users from. Defaults to returning all users
     */
    page?: number;
    /**
     * How many users to show per page in the range [1, 100]. Defaults to 25.  Results are only paginated if the page parameter is defined
     */
    per_page?: number;
    /**
     * Filters users by role_id
     */
    role_id?: Array<string>;
    /**
     * Space-separated list of keywords used to find case-insensitive substring matches against First Name, Last Name, or Email
     */
    search?: string;
    /**
     * Key to sort on, must be one of: id, email, name, group, role. Defaults to id
     */
    sort_by?: string;
    /**
     * Direction to sort in, must be one of: ASC, DESC. Defaults to DESC
     */
    sort_direction?: string;
    /**
     * Defaults to true.
     *
     * When true, only shows users that are actionable based on the team's privacy settings.
     * When false, shows all users on the team, even if you can't take action on that user. Deactivated users are also included when false.
     *
     */
    visible_only?: boolean;
    /**
     * Filters users based on assigned work_country.
     */
    work_country?: Array<string>;
  };
};

export type GetV2UsersJsonResponse = Array<User>;

export type GetV2UsersJsonError = unknown;

export type GetV2UsersByIdJsonData = {
  path: {
    /**
     * User ID
     */
    id: string;
  };
};

export type GetV2UsersByIdJsonResponse = User;

export type GetV2UsersByIdJsonError = unknown;

export type PutV2UsersByIdJsonData = {
  body?: {
    /**
     * Active status of the user's account
     */
    active?: boolean;
    /**
     * Group assigned to the user
     */
    group_id?: number;
    /**
     * Role assigned to the user. Must be one of: Admin, User, or a custom role ID
     */
    role_id?: string;
    /**
     * The user's work country (alpha-2 code)
     */
    work_country?: string;
  };
  path: {
    /**
     * User ID
     */
    id: string;
  };
};

export type PutV2UsersByIdJsonResponse = User;

export type PutV2UsersByIdJsonError = unknown;

export type GetV2WebhookSubscriptionsData = {
  query?: {
    /**
     * Filters webhook subscriptions by whether is enabled or not.
     */
    enabled?: boolean;
  };
};

export type GetV2WebhookSubscriptionsResponse = Array<Subscription>;

export type GetV2WebhookSubscriptionsError = unknown;

export type PostV2WebhookSubscriptionsData = {
  body: {
    /**
     * Any string to be used as a shared secret when subscription events are published. SalesLoft will send the value of this callback_token in the payload of each event so the receiver may verify it matches the original value. This ensures webhook events are being delivered by SalesLoft.
     */
    callback_token: string;
    /**
     * URL for your callback handler
     */
    callback_url: string;
    /**
     * Type of event the subscription is for. Visit the "Event Types" section of the webhooks page to find a list of supported event types.
     */
    event_type: string;
  };
};

export type PostV2WebhookSubscriptionsResponse = Subscription;

export type PostV2WebhookSubscriptionsError = unknown;

export type DeleteV2WebhookSubscriptionsByIdData = {
  path: {
    /**
     * The id of the Webhook Subscription to delete
     */
    id: number;
  };
};

export type DeleteV2WebhookSubscriptionsByIdResponse = any;

export type DeleteV2WebhookSubscriptionsByIdError = unknown;

export type GetV2WebhookSubscriptionsByIdData = {
  path: {
    /**
     * The id for the Webhook Subscription
     */
    id: number;
  };
};

export type GetV2WebhookSubscriptionsByIdResponse = Subscription;

export type GetV2WebhookSubscriptionsByIdError = unknown;

export type PutV2WebhookSubscriptionsByIdData = {
  body?: {
    /**
     * Enable or disable the webhook subscription
     */
    enabled?: boolean;
  };
  path: {
    /**
     * The Webhook Suscription id to update
     */
    id: number;
  };
};

export type PutV2WebhookSubscriptionsByIdResponse = Subscription;

export type PutV2WebhookSubscriptionsByIdError = unknown;
