// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options, urlSearchParamsBodySerializer } from '@hey-api/client-fetch';

import type {
  GetV2AccountStagesJsonData,
  GetV2AccountStagesJsonError,
  GetV2AccountStagesJsonResponse,
  GetV2AccountStagesByIdJsonData,
  GetV2AccountStagesByIdJsonError,
  GetV2AccountStagesByIdJsonResponse,
  GetV2AccountTiersJsonData,
  GetV2AccountTiersJsonError,
  GetV2AccountTiersJsonResponse,
  GetV2AccountTiersByIdJsonData,
  GetV2AccountTiersByIdJsonError,
  GetV2AccountTiersByIdJsonResponse,
  PostV2AccountUpsertsJsonData,
  PostV2AccountUpsertsJsonError,
  PostV2AccountUpsertsJsonResponse,
  GetV2AccountsJsonData,
  GetV2AccountsJsonError,
  GetV2AccountsJsonResponse,
  PostV2AccountsJsonData,
  PostV2AccountsJsonError,
  PostV2AccountsJsonResponse,
  DeleteV2AccountsByIdJsonData,
  DeleteV2AccountsByIdJsonError,
  DeleteV2AccountsByIdJsonResponse,
  GetV2AccountsByIdJsonData,
  GetV2AccountsByIdJsonError,
  GetV2AccountsByIdJsonResponse,
  PutV2AccountsByIdJsonData,
  PutV2AccountsByIdJsonError,
  PutV2AccountsByIdJsonResponse,
  GetV2ActionDetailsCallInstructionsJsonData,
  GetV2ActionDetailsCallInstructionsJsonError,
  GetV2ActionDetailsCallInstructionsJsonResponse,
  GetV2ActionDetailsCallInstructionsByIdJsonData,
  GetV2ActionDetailsCallInstructionsByIdJsonError,
  GetV2ActionDetailsCallInstructionsByIdJsonResponse,
  GetV2ActionsJsonData,
  GetV2ActionsJsonError,
  GetV2ActionsJsonResponse,
  GetV2ActionsByIdJsonData,
  GetV2ActionsByIdJsonError,
  GetV2ActionsByIdJsonResponse,
  PostV2ActivitiesJsonData,
  PostV2ActivitiesJsonError,
  PostV2ActivitiesJsonResponse,
  GetV2ActivitiesCallsJsonData,
  GetV2ActivitiesCallsJsonError,
  GetV2ActivitiesCallsJsonResponse,
  PostV2ActivitiesCallsJsonData,
  PostV2ActivitiesCallsJsonError,
  PostV2ActivitiesCallsJsonResponse,
  GetV2ActivitiesCallsByIdJsonData,
  GetV2ActivitiesCallsByIdJsonError,
  GetV2ActivitiesCallsByIdJsonResponse,
  GetV2ActivitiesEmailsJsonData,
  GetV2ActivitiesEmailsJsonError,
  GetV2ActivitiesEmailsJsonResponse,
  GetV2ActivitiesEmailsByIdJsonData,
  GetV2ActivitiesEmailsByIdJsonError,
  GetV2ActivitiesEmailsByIdJsonResponse,
  GetV2ActivityHistoriesData,
  GetV2ActivityHistoriesError,
  GetV2ActivityHistoriesResponse,
  GetV2BulkJobsData,
  GetV2BulkJobsError,
  GetV2BulkJobsResponse,
  PostV2BulkJobsData,
  PostV2BulkJobsError,
  PostV2BulkJobsResponse,
  GetV2BulkJobsByBulkJobsIdJobDataData,
  GetV2BulkJobsByBulkJobsIdJobDataError,
  GetV2BulkJobsByBulkJobsIdJobDataResponse,
  PostV2BulkJobsByBulkJobsIdJobDataData,
  PostV2BulkJobsByBulkJobsIdJobDataError,
  PostV2BulkJobsByBulkJobsIdJobDataResponse,
  GetV2BulkJobsByBulkJobsIdResultsData,
  GetV2BulkJobsByBulkJobsIdResultsError,
  GetV2BulkJobsByBulkJobsIdResultsResponse,
  GetV2BulkJobsByIdData,
  GetV2BulkJobsByIdError,
  GetV2BulkJobsByIdResponse,
  PutV2BulkJobsByIdData,
  PutV2BulkJobsByIdError,
  PutV2BulkJobsByIdResponse,
  GetV2CadenceExportsByIdJsonData,
  GetV2CadenceExportsByIdJsonError,
  GetV2CadenceExportsByIdJsonResponse,
  PostV2CadenceImportsJsonData,
  PostV2CadenceImportsJsonError,
  PostV2CadenceImportsJsonResponse,
  GetV2CadenceMembershipsJsonData,
  GetV2CadenceMembershipsJsonError,
  GetV2CadenceMembershipsJsonResponse,
  PostV2CadenceMembershipsJsonData,
  PostV2CadenceMembershipsJsonError,
  PostV2CadenceMembershipsJsonResponse,
  DeleteV2CadenceMembershipsByIdJsonData,
  DeleteV2CadenceMembershipsByIdJsonError,
  DeleteV2CadenceMembershipsByIdJsonResponse,
  GetV2CadenceMembershipsByIdJsonData,
  GetV2CadenceMembershipsByIdJsonError,
  GetV2CadenceMembershipsByIdJsonResponse,
  GetV2CadencesJsonData,
  GetV2CadencesJsonError,
  GetV2CadencesJsonResponse,
  GetV2CadencesByIdJsonData,
  GetV2CadencesByIdJsonError,
  GetV2CadencesByIdJsonResponse,
  GetV2CalendarEventsData,
  GetV2CalendarEventsError,
  GetV2CalendarEventsResponse,
  PostV2CalendarEventsUpsertData,
  PostV2CalendarEventsUpsertError,
  PostV2CalendarEventsUpsertResponse,
  GetV2CallDataRecordsJsonData,
  GetV2CallDataRecordsJsonError,
  GetV2CallDataRecordsJsonResponse,
  GetV2CallDataRecordsByIdJsonData,
  GetV2CallDataRecordsByIdJsonError,
  GetV2CallDataRecordsByIdJsonResponse,
  GetV2CallDispositionsJsonData,
  GetV2CallDispositionsJsonError,
  GetV2CallDispositionsJsonResponse,
  GetV2CallSentimentsJsonData,
  GetV2CallSentimentsJsonError,
  GetV2CallSentimentsJsonResponse,
  PostV2ConversationsCallsData,
  PostV2ConversationsCallsError,
  PostV2ConversationsCallsResponse,
  GetV2CrmActivitiesJsonData,
  GetV2CrmActivitiesJsonError,
  GetV2CrmActivitiesJsonResponse,
  GetV2CrmActivitiesByIdJsonData,
  GetV2CrmActivitiesByIdJsonError,
  GetV2CrmActivitiesByIdJsonResponse,
  GetV2CrmActivityFieldsJsonData,
  GetV2CrmActivityFieldsJsonError,
  GetV2CrmActivityFieldsJsonResponse,
  GetV2CrmUsersJsonData,
  GetV2CrmUsersJsonError,
  GetV2CrmUsersJsonResponse,
  GetV2CustomFieldsJsonData,
  GetV2CustomFieldsJsonError,
  GetV2CustomFieldsJsonResponse,
  PostV2CustomFieldsJsonData,
  PostV2CustomFieldsJsonError,
  PostV2CustomFieldsJsonResponse,
  DeleteV2CustomFieldsByIdJsonData,
  DeleteV2CustomFieldsByIdJsonError,
  DeleteV2CustomFieldsByIdJsonResponse,
  GetV2CustomFieldsByIdJsonData,
  GetV2CustomFieldsByIdJsonError,
  GetV2CustomFieldsByIdJsonResponse,
  PutV2CustomFieldsByIdJsonData,
  PutV2CustomFieldsByIdJsonError,
  PutV2CustomFieldsByIdJsonResponse,
  GetV2CustomRolesJsonData,
  GetV2CustomRolesJsonError,
  GetV2CustomRolesJsonResponse,
  GetV2CustomRolesByIdJsonData,
  GetV2CustomRolesByIdJsonError,
  GetV2CustomRolesByIdJsonResponse,
  GetV2EmailTemplateAttachmentsJsonData,
  GetV2EmailTemplateAttachmentsJsonError,
  GetV2EmailTemplateAttachmentsJsonResponse,
  GetV2EmailTemplatesJsonData,
  GetV2EmailTemplatesJsonError,
  GetV2EmailTemplatesJsonResponse,
  GetV2EmailTemplatesByIdJsonData,
  GetV2EmailTemplatesByIdJsonError,
  GetV2EmailTemplatesByIdJsonResponse,
  PostV2ExternalEmailsJsonData,
  PostV2ExternalEmailsJsonError,
  PostV2ExternalEmailsJsonResponse,
  GetV2GroupsJsonData,
  GetV2GroupsJsonError,
  GetV2GroupsJsonResponse,
  GetV2GroupsByIdJsonData,
  GetV2GroupsByIdJsonError,
  GetV2GroupsByIdJsonResponse,
  GetV2ImportsJsonData,
  GetV2ImportsJsonError,
  GetV2ImportsJsonResponse,
  PostV2ImportsJsonData,
  PostV2ImportsJsonError,
  PostV2ImportsJsonResponse,
  DeleteV2ImportsByIdJsonData,
  DeleteV2ImportsByIdJsonError,
  DeleteV2ImportsByIdJsonResponse,
  GetV2ImportsByIdJsonData,
  GetV2ImportsByIdJsonError,
  GetV2ImportsByIdJsonResponse,
  PutV2ImportsByIdJsonData,
  PutV2ImportsByIdJsonError,
  PutV2ImportsByIdJsonResponse,
  PostV2LiveWebsiteTrackingParametersJsonData,
  PostV2LiveWebsiteTrackingParametersJsonError,
  PostV2LiveWebsiteTrackingParametersJsonResponse,
  GetV2MeJsonError,
  GetV2MeJsonResponse,
  GetV2MeetingsJsonData,
  GetV2MeetingsJsonError,
  GetV2MeetingsJsonResponse,
  PostV2MeetingsSettingsSearchesJsonData,
  PostV2MeetingsSettingsSearchesJsonError,
  PostV2MeetingsSettingsSearchesJsonResponse,
  PutV2MeetingsSettingsByIdJsonData,
  PutV2MeetingsSettingsByIdJsonError,
  PutV2MeetingsSettingsByIdJsonResponse,
  PutV2MeetingsByIdJsonData,
  PutV2MeetingsByIdJsonError,
  PutV2MeetingsByIdJsonResponse,
  GetV2MimeEmailPayloadsByIdJsonData,
  GetV2MimeEmailPayloadsByIdJsonError,
  GetV2MimeEmailPayloadsByIdJsonResponse,
  GetV2NotesJsonData,
  GetV2NotesJsonError,
  GetV2NotesJsonResponse,
  PostV2NotesJsonData,
  PostV2NotesJsonError,
  PostV2NotesJsonResponse,
  DeleteV2NotesByIdJsonData,
  DeleteV2NotesByIdJsonError,
  DeleteV2NotesByIdJsonResponse,
  GetV2NotesByIdJsonData,
  GetV2NotesByIdJsonError,
  GetV2NotesByIdJsonResponse,
  PutV2NotesByIdJsonData,
  PutV2NotesByIdJsonError,
  PutV2NotesByIdJsonResponse,
  PostV2OngoingActionsJsonData,
  PostV2OngoingActionsJsonError,
  PostV2OngoingActionsJsonResponse,
  GetV2PendingEmailsJsonData,
  GetV2PendingEmailsJsonError,
  GetV2PendingEmailsJsonResponse,
  PutV2PendingEmailsByIdJsonData,
  PutV2PendingEmailsByIdJsonError,
  PutV2PendingEmailsByIdJsonResponse,
  GetV2PeopleJsonData,
  GetV2PeopleJsonError,
  GetV2PeopleJsonResponse,
  PostV2PeopleJsonData,
  PostV2PeopleJsonError,
  PostV2PeopleJsonResponse,
  DeleteV2PeopleByIdJsonData,
  DeleteV2PeopleByIdJsonError,
  DeleteV2PeopleByIdJsonResponse,
  GetV2PeopleByIdJsonData,
  GetV2PeopleByIdJsonError,
  GetV2PeopleByIdJsonResponse,
  PutV2PeopleByIdJsonData,
  PutV2PeopleByIdJsonError,
  PutV2PeopleByIdJsonResponse,
  GetV2PersonStagesJsonData,
  GetV2PersonStagesJsonError,
  GetV2PersonStagesJsonResponse,
  PostV2PersonStagesJsonData,
  PostV2PersonStagesJsonError,
  PostV2PersonStagesJsonResponse,
  DeleteV2PersonStagesByIdJsonData,
  DeleteV2PersonStagesByIdJsonError,
  DeleteV2PersonStagesByIdJsonResponse,
  GetV2PersonStagesByIdJsonData,
  GetV2PersonStagesByIdJsonError,
  GetV2PersonStagesByIdJsonResponse,
  PutV2PersonStagesByIdJsonData,
  PutV2PersonStagesByIdJsonError,
  PutV2PersonStagesByIdJsonResponse,
  PostV2PersonUpsertsJsonData,
  PostV2PersonUpsertsJsonError,
  PostV2PersonUpsertsJsonResponse,
  GetV2PhoneNumberAssignmentsJsonData,
  GetV2PhoneNumberAssignmentsJsonError,
  GetV2PhoneNumberAssignmentsJsonResponse,
  GetV2PhoneNumberAssignmentsByIdJsonData,
  GetV2PhoneNumberAssignmentsByIdJsonError,
  GetV2PhoneNumberAssignmentsByIdJsonResponse,
  GetV2PhoneNumbersCallerIdsJsonData,
  GetV2PhoneNumbersCallerIdsJsonError,
  GetV2PhoneNumbersCallerIdsJsonResponse,
  GetV2PhoneNumbersRecordingSettingsByIdJsonData,
  GetV2PhoneNumbersRecordingSettingsByIdJsonError,
  GetV2PhoneNumbersRecordingSettingsByIdJsonResponse,
  GetV2SavedListViewsJsonData,
  GetV2SavedListViewsJsonError,
  GetV2SavedListViewsJsonResponse,
  PostV2SavedListViewsJsonData,
  PostV2SavedListViewsJsonError,
  PostV2SavedListViewsJsonResponse,
  DeleteV2SavedListViewsByIdJsonData,
  DeleteV2SavedListViewsByIdJsonError,
  DeleteV2SavedListViewsByIdJsonResponse,
  GetV2SavedListViewsByIdJsonData,
  GetV2SavedListViewsByIdJsonError,
  GetV2SavedListViewsByIdJsonResponse,
  PutV2SavedListViewsByIdJsonData,
  PutV2SavedListViewsByIdJsonError,
  PutV2SavedListViewsByIdJsonResponse,
  GetV2StepsJsonData,
  GetV2StepsJsonError,
  GetV2StepsJsonResponse,
  GetV2StepsByIdJsonData,
  GetV2StepsByIdJsonError,
  GetV2StepsByIdJsonResponse,
  GetV2SuccessesJsonData,
  GetV2SuccessesJsonError,
  GetV2SuccessesJsonResponse,
  GetV2TagsJsonData,
  GetV2TagsJsonError,
  GetV2TagsJsonResponse,
  GetV2TasksJsonData,
  GetV2TasksJsonError,
  GetV2TasksJsonResponse,
  PostV2TasksJsonData,
  PostV2TasksJsonError,
  PostV2TasksJsonResponse,
  GetV2TasksByIdJsonData,
  GetV2TasksByIdJsonError,
  GetV2TasksByIdJsonResponse,
  PutV2TasksByIdJsonData,
  PutV2TasksByIdJsonError,
  PutV2TasksByIdJsonResponse,
  GetV2TeamJsonError,
  GetV2TeamJsonResponse,
  GetV2TeamTemplateAttachmentsJsonData,
  GetV2TeamTemplateAttachmentsJsonError,
  GetV2TeamTemplateAttachmentsJsonResponse,
  GetV2TeamTemplatesJsonData,
  GetV2TeamTemplatesJsonError,
  GetV2TeamTemplatesJsonResponse,
  GetV2TeamTemplatesByIdJsonData,
  GetV2TeamTemplatesByIdJsonError,
  GetV2TeamTemplatesByIdJsonResponse,
  PostV2ThirdPartyLiveFeedItemsData,
  PostV2ThirdPartyLiveFeedItemsError,
  PostV2ThirdPartyLiveFeedItemsResponse,
  GetV2UsersJsonData,
  GetV2UsersJsonError,
  GetV2UsersJsonResponse,
  GetV2UsersByIdJsonData,
  GetV2UsersByIdJsonError,
  GetV2UsersByIdJsonResponse,
  PutV2UsersByIdJsonData,
  PutV2UsersByIdJsonError,
  PutV2UsersByIdJsonResponse,
  GetV2WebhookSubscriptionsData,
  GetV2WebhookSubscriptionsError,
  GetV2WebhookSubscriptionsResponse,
  PostV2WebhookSubscriptionsData,
  PostV2WebhookSubscriptionsError,
  PostV2WebhookSubscriptionsResponse,
  DeleteV2WebhookSubscriptionsByIdData,
  DeleteV2WebhookSubscriptionsByIdError,
  DeleteV2WebhookSubscriptionsByIdResponse,
  GetV2WebhookSubscriptionsByIdData,
  GetV2WebhookSubscriptionsByIdError,
  GetV2WebhookSubscriptionsByIdResponse,
  PutV2WebhookSubscriptionsByIdData,
  PutV2WebhookSubscriptionsByIdError,
  PutV2WebhookSubscriptionsByIdResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * List account stages
 * Fetches multiple account stage records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2AccountStagesJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2AccountStagesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2AccountStagesJsonResponse, GetV2AccountStagesJsonError, ThrowOnError>({
    ...options,
    url: '/v2/account_stages.json',
  });
};

/**
 * Fetch an account stage
 * Fetches an account stage, by ID only.
 *
 */
export const getV2AccountStagesByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2AccountStagesByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2AccountStagesByIdJsonResponse,
    GetV2AccountStagesByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/account_stages/{id}.json',
  });
};

/**
 * List Account Tiers
 * Fetches multiple account tier records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2AccountTiersJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2AccountTiersJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2AccountTiersJsonResponse, GetV2AccountTiersJsonError, ThrowOnError>({
    ...options,
    url: '/v2/account_tiers.json',
  });
};

/**
 * Fetch an account tier
 * Fetches an account tier, by ID only.
 *
 */
export const getV2AccountTiersByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2AccountTiersByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2AccountTiersByIdJsonResponse,
    GetV2AccountTiersByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/account_tiers/{id}.json',
  });
};

/**
 * Upsert an account
 * Upserts an account record. The upsert_key dictates how the upsert will be performed. The create and update behavior
 * is exactly the same as the individual create and update endpoints.
 *
 */
export const postV2AccountUpsertsJson = <ThrowOnError extends boolean = false>(
  options?: Options<PostV2AccountUpsertsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2AccountUpsertsJsonResponse,
    PostV2AccountUpsertsJsonError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/account_upserts.json',
  });
};

/**
 * List accounts
 * Fetches multiple account records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2AccountsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2AccountsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2AccountsJsonResponse, GetV2AccountsJsonError, ThrowOnError>({
    ...options,
    url: '/v2/accounts.json',
  });
};

/**
 * Create an account
 * Creates an account.
 *
 * "domain" must be unique on the current team.
 *
 */
export const postV2AccountsJson = <ThrowOnError extends boolean = false>(
  options: Options<PostV2AccountsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2AccountsJsonResponse, PostV2AccountsJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/accounts.json',
  });
};

/**
 * Delete an account
 * Deletes an account. This operation is not reversible without contacting support.
 * This operation can be called multiple times successfully.
 *
 * Deleting an account will remove all connected people from that account.
 *
 */
export const deleteV2AccountsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2AccountsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV2AccountsByIdJsonResponse,
    DeleteV2AccountsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/accounts/{id}.json',
  });
};

/**
 * Fetch an account
 * Fetches an account, by ID only.
 *
 */
export const getV2AccountsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2AccountsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2AccountsByIdJsonResponse, GetV2AccountsByIdJsonError, ThrowOnError>({
    ...options,
    url: '/v2/accounts/{id}.json',
  });
};

/**
 * Update an existing Account
 * Updates an account.
 *
 * "domain" must be unique on the current team.
 *
 */
export const putV2AccountsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<PutV2AccountsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV2AccountsByIdJsonResponse, PutV2AccountsByIdJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/accounts/{id}.json',
  });
};

/**
 * List call instructions
 * Fetches multiple call instruction records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2ActionDetailsCallInstructionsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2ActionDetailsCallInstructionsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ActionDetailsCallInstructionsJsonResponse,
    GetV2ActionDetailsCallInstructionsJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/action_details/call_instructions.json',
  });
};

/**
 * Fetch a call instructions
 * Fetches a call instruction, by ID only.
 *
 */
export const getV2ActionDetailsCallInstructionsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ActionDetailsCallInstructionsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ActionDetailsCallInstructionsByIdJsonResponse,
    GetV2ActionDetailsCallInstructionsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/action_details/call_instructions/{id}.json',
  });
};

/**
 * List actions
 * Fetches multiple action records. The records can be filtered, paged, and sorted according to
 * the respective parameters. Only actions that are currently "in_progess" will be returned by
 * this endpoint.
 *
 * If the requester is not an admin, this endpoint will only return actions belonging to the requester.
 * If the request is an admin, this endpoint will return actions for the entire team. Additionaly, an admin
 * may use the user_guid parameter to request actions that belong to specific users on the team.
 *
 */
export const getV2ActionsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2ActionsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2ActionsJsonResponse, GetV2ActionsJsonError, ThrowOnError>({
    ...options,
    url: '/v2/actions.json',
  });
};

/**
 * Fetch an action
 * Fetches an action, by ID only.
 * This endpoint will only return actions that are in_progress or pending_activity.
 * Once an action is complete, the request for that action will return a 404 status code.
 *
 */
export const getV2ActionsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ActionsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2ActionsByIdJsonResponse, GetV2ActionsByIdJsonError, ThrowOnError>({
    ...options,
    url: '/v2/actions/{id}.json',
  });
};

/**
 * Create an activity
 * Creates an activity. An activity will mark the associated action as completed. Currently,
 * only certain action types can have an activity explicitly created for them.
 *
 */
export const postV2ActivitiesJson = <ThrowOnError extends boolean = false>(
  options?: Options<PostV2ActivitiesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2ActivitiesJsonResponse, PostV2ActivitiesJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/activities.json',
  });
};

/**
 * List calls
 * Fetches multiple call records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2ActivitiesCallsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2ActivitiesCallsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2ActivitiesCallsJsonResponse, GetV2ActivitiesCallsJsonError, ThrowOnError>(
    {
      ...options,
      url: '/v2/activities/calls.json',
    },
  );
};

/**
 * Create a call
 * Creates a call. The parameters of this endpoint can be used to create an action
 * and ensure that the CRM Task is mapped correctly.
 *
 */
export const postV2ActivitiesCallsJson = <ThrowOnError extends boolean = false>(
  options: Options<PostV2ActivitiesCallsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2ActivitiesCallsJsonResponse,
    PostV2ActivitiesCallsJsonError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/activities/calls.json',
  });
};

/**
 * Fetch a call
 * Fetches a call, by ID only.
 *
 */
export const getV2ActivitiesCallsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ActivitiesCallsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ActivitiesCallsByIdJsonResponse,
    GetV2ActivitiesCallsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/activities/calls/{id}.json',
  });
};

/**
 * List emails
 * Fetches multiple email records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2ActivitiesEmailsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2ActivitiesEmailsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ActivitiesEmailsJsonResponse,
    GetV2ActivitiesEmailsJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/activities/emails.json',
  });
};

/**
 * Fetch an email
 * Fetches an email, by ID only.
 *
 */
export const getV2ActivitiesEmailsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ActivitiesEmailsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ActivitiesEmailsByIdJsonResponse,
    GetV2ActivitiesEmailsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/activities/emails/{id}.json',
  });
};

/**
 * List Past Activities
 * Fetches all of the customer's past activities for your application. Returns all the Activities that are found on the Salesloft Activity Feed. <a href="/activity-history.html" target="_blank" rel="noopener noreferrer">Visit here for more details</a>.
 */
export const getV2ActivityHistories = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2ActivityHistoriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2ActivityHistoriesResponse, GetV2ActivityHistoriesError, ThrowOnError>({
    ...options,
    url: '/v2/activity_histories',
  });
};

/**
 * List bulk jobs
 * Fetches multiple bulk job records. The records can be filtered, paged, and sorted according to the respective parameters.
 */
export const getV2BulkJobs = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2BulkJobsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2BulkJobsResponse, GetV2BulkJobsError, ThrowOnError>({
    ...options,
    url: '/v2/bulk_jobs',
  });
};

/**
 * Create a bulk job
 * Creates a bulk job. The type of the bulk job must be included when created.
 *
 * For additional information on creating bulk jobs, the types of supported bulk jobs, and examples of the bulk job flow, visit the <a href="/bulk.html" target="_blank" rel="noopener noreferrer">bulk job details page</a>.
 *
 */
export const postV2BulkJobs = <ThrowOnError extends boolean = false>(
  options?: Options<PostV2BulkJobsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2BulkJobsResponse, PostV2BulkJobsError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/bulk_jobs',
  });
};

/**
 * List job data for a bulk job
 * Fetches multiple job data records for a given bulk job. Pagination is not supported, but cursor based polling is via use of the `id[gt]` filter. Pass the last id seen (i.e. `id[gt]=1234`) in order to get the next batch of records.
 */
export const getV2BulkJobsByBulkJobsIdJobData = <ThrowOnError extends boolean = false>(
  options: Options<GetV2BulkJobsByBulkJobsIdJobDataData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2BulkJobsByBulkJobsIdJobDataResponse,
    GetV2BulkJobsByBulkJobsIdJobDataError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/bulk_jobs/{bulk_jobs_id}/job_data',
  });
};

/**
 * Create job data for a bulk job
 * Upload job data for the specified bulk job. Upload an array of objects, where element contains the parameters necessary to execute the individual calls. Each call to this endpoint can handle up to 5,000 records at a time. There is no limit to how many times you can create job data for a given bulk job.
 *
 * For additional information on creating bulk jobs, the types of supported bulk jobs, and examples of the bulk job flow, visit the <a href="/bulk.html" target="_blank" rel="noopener noreferrer">bulk job details page</a>.
 *
 */
export const postV2BulkJobsByBulkJobsIdJobData = <ThrowOnError extends boolean = false>(
  options: Options<PostV2BulkJobsByBulkJobsIdJobDataData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2BulkJobsByBulkJobsIdJobDataResponse,
    PostV2BulkJobsByBulkJobsIdJobDataError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/bulk_jobs/{bulk_jobs_id}/job_data',
  });
};

/**
 * List job data for a completed bulk job.
 * Fetches multiple job data records for a completed bulk job. Note that until a bulk job's state is set to `done` the returned `data` will be an empty array. Pagination is not supported, but cursor based polling is via use of the `id[gt]` filter. Pass the last id seen (i.e. `id[gt]=1234`) in order to get the next batch of records.
 */
export const getV2BulkJobsByBulkJobsIdResults = <ThrowOnError extends boolean = false>(
  options: Options<GetV2BulkJobsByBulkJobsIdResultsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2BulkJobsByBulkJobsIdResultsResponse,
    GetV2BulkJobsByBulkJobsIdResultsError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/bulk_jobs/{bulk_jobs_id}/results',
  });
};

/**
 * Fetch a bulk job
 * Fetches a bulk job, by ID only.
 */
export const getV2BulkJobsById = <ThrowOnError extends boolean = false>(
  options: Options<GetV2BulkJobsByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2BulkJobsByIdResponse, GetV2BulkJobsByIdError, ThrowOnError>({
    ...options,
    url: '/v2/bulk_jobs/{id}',
  });
};

/**
 * Update a bulk job
 * Updates a bulk job's name and / or marks a bulk job as 'ready_to_execute'.  May only be updated if the bulk job is still in an "open" state.
 *
 * For additional information on creating bulk jobs, the types of supported bulk jobs, and examples of the bulk job flow, visit the <a href="/bulk.html" target="_blank" rel="noopener noreferrer">bulk job details page</a>.
 *
 */
export const putV2BulkJobsById = <ThrowOnError extends boolean = false>(
  options: Options<PutV2BulkJobsByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV2BulkJobsByIdResponse, PutV2BulkJobsByIdError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/bulk_jobs/{id}',
  });
};

/**
 * Export a cadence
 * Exports a cadence as JSON.
 *
 */
export const getV2CadenceExportsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2CadenceExportsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2CadenceExportsByIdJsonResponse,
    GetV2CadenceExportsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/cadence_exports/{id}.json',
  });
};

/**
 * Import cadences from JSON
 * New cadences can be created or steps can be imported onto existing cadences which do not have steps.
 * <a href="/cadence-imports.html" target="_blank" rel="noopener noreferrer">Visit here for more details</a>.
 *
 */
export const postV2CadenceImportsJson = <ThrowOnError extends boolean = false>(
  options?: Options<PostV2CadenceImportsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2CadenceImportsJsonResponse,
    PostV2CadenceImportsJsonError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/cadence_imports.json',
  });
};

/**
 * List cadence memberships
 * Fetches multiple cadence membership records. The records can be filtered, paged, and sorted according to
 * the respective parameters. A cadence membership is the association between a person and their current and
 * historical time on a cadence. Cadence membership records are mutable and change over time. If a person is
 * added to a cadence and re-added to the same cadence in the future, there is a single membership record.
 *
 */
export const getV2CadenceMembershipsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2CadenceMembershipsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2CadenceMembershipsJsonResponse,
    GetV2CadenceMembershipsJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/cadence_memberships.json',
  });
};

/**
 * Create a cadence membership
 * Adds a person to a cadence. person_id and cadence_id are required, and must be visible to the authenticated user. user_id will
 * default to the authenticated user, but can be set to any visible user on the authenticated team.
 *
 * A person cannot be added to a cadence on behalf of a teammate unless the cadence is a team cadence, the cadence is owned by
 * the teammate, or the teammate has the Personal Cadence Admin permission.
 *
 */
export const postV2CadenceMembershipsJson = <ThrowOnError extends boolean = false>(
  options: Options<PostV2CadenceMembershipsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2CadenceMembershipsJsonResponse,
    PostV2CadenceMembershipsJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/cadence_memberships.json',
  });
};

/**
 * Delete a cadence membership
 * Cadence Membership
 *
 */
export const deleteV2CadenceMembershipsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2CadenceMembershipsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV2CadenceMembershipsByIdJsonResponse,
    DeleteV2CadenceMembershipsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/cadence_memberships/{id}.json',
  });
};

/**
 * Fetch a cadence membership
 * Fetches a cadence membership, by ID only.
 *
 */
export const getV2CadenceMembershipsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2CadenceMembershipsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2CadenceMembershipsByIdJsonResponse,
    GetV2CadenceMembershipsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/cadence_memberships/{id}.json',
  });
};

/**
 * List cadences
 * Fetches multiple cadence records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2CadencesJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2CadencesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2CadencesJsonResponse, GetV2CadencesJsonError, ThrowOnError>({
    ...options,
    url: '/v2/cadences.json',
  });
};

/**
 * Fetch a cadence
 * Fetches a cadence, by ID only.
 *
 */
export const getV2CadencesByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2CadencesByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2CadencesByIdJsonResponse, GetV2CadencesByIdJsonError, ThrowOnError>({
    ...options,
    url: '/v2/cadences/{id}.json',
  });
};

/**
 * List calendar events
 * Returns all calendar events, paginated and filtered by the date.
 */
export const getV2CalendarEvents = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2CalendarEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2CalendarEventsResponse, GetV2CalendarEventsError, ThrowOnError>({
    ...options,
    url: '/v2/calendar/events',
  });
};

/**
 * Upsert a calendar event
 *   Upserts a calendar event object.
 * Upsert key is a combination of `id` and `i_cal_uid` scoped to the given `calendar_id`.
 * Bulk operations:
 * This endpoint is used for bulk operations, see https://developers.salesloft.com/bulk.html for integration instructions.
 * Use `calendar/events/upsert` as an event type, and this spec as a data spec.
 * This endpoint should be used directly for the time sensitive calendar event updates.
 *
 */
export const postV2CalendarEventsUpsert = <ThrowOnError extends boolean = false>(
  options: Options<PostV2CalendarEventsUpsertData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2CalendarEventsUpsertResponse,
    PostV2CalendarEventsUpsertError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/calendar/events/upsert',
  });
};

/**
 * List call data records
 * Fetches multiple call data records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 * Call data records are records of all inbound and outbound calls through Salesloft. A call data record may
 * be associated with a call, but does not have to be.
 *
 */
export const getV2CallDataRecordsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2CallDataRecordsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2CallDataRecordsJsonResponse, GetV2CallDataRecordsJsonError, ThrowOnError>(
    {
      ...options,
      url: '/v2/call_data_records.json',
    },
  );
};

/**
 * Fetch a call data record
 * Fetches a call data record, by ID only.
 *
 */
export const getV2CallDataRecordsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2CallDataRecordsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2CallDataRecordsByIdJsonResponse,
    GetV2CallDataRecordsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/call_data_records/{id}.json',
  });
};

/**
 * List call dispositions
 * Fetches multiple call disposition records. The records can be sorted according to
 * the respective parameters. Call dispositions must be configured in application. This will
 * change in the future, but please contact us if you have a pressing use case.
 *
 */
export const getV2CallDispositionsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2CallDispositionsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2CallDispositionsJsonResponse,
    GetV2CallDispositionsJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/call_dispositions.json',
  });
};

/**
 * List call sentiments
 * Fetches multiple call sentiment records. The records can be sorted according to
 * the respective parameters. Call sentiments must be configured in application. This will
 * change in the future, but please contact us if you have a pressing use case.
 *
 */
export const getV2CallSentimentsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2CallSentimentsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2CallSentimentsJsonResponse, GetV2CallSentimentsJsonError, ThrowOnError>({
    ...options,
    url: '/v2/call_sentiments.json',
  });
};

/**
 * Create Conversations Call
 * Enqueue a Conversations Call for processing
 */
export const postV2ConversationsCalls = <ThrowOnError extends boolean = false>(
  options: Options<PostV2ConversationsCallsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2ConversationsCallsResponse,
    PostV2ConversationsCallsError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/conversations/calls',
  });
};

/**
 * List crm activities
 * Fetches multiple crm activity records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2CrmActivitiesJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2CrmActivitiesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2CrmActivitiesJsonResponse, GetV2CrmActivitiesJsonError, ThrowOnError>({
    ...options,
    url: '/v2/crm_activities.json',
  });
};

/**
 * Fetch a crm activity
 * Fetches a crm activity, by ID only.
 *
 */
export const getV2CrmActivitiesByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2CrmActivitiesByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2CrmActivitiesByIdJsonResponse,
    GetV2CrmActivitiesByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/crm_activities/{id}.json',
  });
};

/**
 * List crm activity fields
 * Fetches multiple crm activity field records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2CrmActivityFieldsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2CrmActivityFieldsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2CrmActivityFieldsJsonResponse,
    GetV2CrmActivityFieldsJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/crm_activity_fields.json',
  });
};

/**
 * List crm users
 * Crm Users
 *
 */
export const getV2CrmUsersJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2CrmUsersJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2CrmUsersJsonResponse, GetV2CrmUsersJsonError, ThrowOnError>({
    ...options,
    url: '/v2/crm_users.json',
  });
};

/**
 * List custom fields
 * Fetches multiple custom field records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2CustomFieldsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2CustomFieldsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2CustomFieldsJsonResponse, GetV2CustomFieldsJsonError, ThrowOnError>({
    ...options,
    url: '/v2/custom_fields.json',
  });
};

/**
 * Create a custom field
 * Creates a custom field.
 *
 */
export const postV2CustomFieldsJson = <ThrowOnError extends boolean = false>(
  options: Options<PostV2CustomFieldsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2CustomFieldsJsonResponse, PostV2CustomFieldsJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/custom_fields.json',
  });
};

/**
 * Delete a custom field
 * Deletes a custom field.
 *
 */
export const deleteV2CustomFieldsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2CustomFieldsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV2CustomFieldsByIdJsonResponse,
    DeleteV2CustomFieldsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/custom_fields/{id}.json',
  });
};

/**
 * Fetch a custom field
 * Fetches a custom field, by ID only.
 *
 */
export const getV2CustomFieldsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2CustomFieldsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2CustomFieldsByIdJsonResponse,
    GetV2CustomFieldsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/custom_fields/{id}.json',
  });
};

/**
 * Update a custom field
 * Update a custom field.
 *
 */
export const putV2CustomFieldsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<PutV2CustomFieldsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV2CustomFieldsByIdJsonResponse,
    PutV2CustomFieldsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/custom_fields/{id}.json',
  });
};

/**
 * List custom roles
 * Fetches multiple custom role records. The records can be filtered, and sorted according to
 * the respective parameters. A custom role is any role that is not Admin or User.
 *
 */
export const getV2CustomRolesJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2CustomRolesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2CustomRolesJsonResponse, GetV2CustomRolesJsonError, ThrowOnError>({
    ...options,
    url: '/v2/custom_roles.json',
  });
};

/**
 * Fetch a custom role
 * Fetches a custom role, by ID only.
 *
 */
export const getV2CustomRolesByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2CustomRolesByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2CustomRolesByIdJsonResponse, GetV2CustomRolesByIdJsonError, ThrowOnError>(
    {
      ...options,
      url: '/v2/custom_roles/{id}.json',
    },
  );
};

/**
 * List email template attachments
 * Fetches multiple email template attachment records. The records can be filtered and paged according to
 * the respective parameters.
 *
 */
export const getV2EmailTemplateAttachmentsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2EmailTemplateAttachmentsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2EmailTemplateAttachmentsJsonResponse,
    GetV2EmailTemplateAttachmentsJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/email_template_attachments.json',
  });
};

/**
 * List email templates
 * Fetches multiple email template records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2EmailTemplatesJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2EmailTemplatesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2EmailTemplatesJsonResponse, GetV2EmailTemplatesJsonError, ThrowOnError>({
    ...options,
    url: '/v2/email_templates.json',
  });
};

/**
 * Fetch an email template
 * Fetches an email template, by ID only.
 *
 */
export const getV2EmailTemplatesByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2EmailTemplatesByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2EmailTemplatesByIdJsonResponse,
    GetV2EmailTemplatesByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/email_templates/{id}.json',
  });
};

/**
 * Create an External Email
 * Creates an external email object.
 *
 */
export const postV2ExternalEmailsJson = <ThrowOnError extends boolean = false>(
  options: Options<PostV2ExternalEmailsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2ExternalEmailsJsonResponse,
    PostV2ExternalEmailsJsonError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/external_emails.json',
  });
};

/**
 * List groups
 * Fetches multiple group records. The records can be filtered, and sorted according to
 * the respective parameters.
 *
 */
export const getV2GroupsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2GroupsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2GroupsJsonResponse, GetV2GroupsJsonError, ThrowOnError>({
    ...options,
    url: '/v2/groups.json',
  });
};

/**
 * Fetch a group
 * Fetches a group, by ID only.
 *
 */
export const getV2GroupsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2GroupsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2GroupsByIdJsonResponse, GetV2GroupsByIdJsonError, ThrowOnError>({
    ...options,
    url: '/v2/groups/{id}.json',
  });
};

/**
 * List imports
 * Fetches multiple imports.
 *
 */
export const getV2ImportsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2ImportsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2ImportsJsonResponse, GetV2ImportsJsonError, ThrowOnError>({
    ...options,
    url: '/v2/imports.json',
  });
};

/**
 * Create an import
 * Creates an import.
 *
 */
export const postV2ImportsJson = <ThrowOnError extends boolean = false>(
  options?: Options<PostV2ImportsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2ImportsJsonResponse, PostV2ImportsJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/imports.json',
  });
};

/**
 * Delete an import
 * Deletes an import, by ID only. The associated people can be deleted as part of the deletion process.
 *
 * Admin users can access imports for the entire team, but non-admin users can only access their own imports.
 *
 */
export const deleteV2ImportsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2ImportsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV2ImportsByIdJsonResponse,
    DeleteV2ImportsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/imports/{id}.json',
  });
};

/**
 * Fetch an import
 * Fetches an import, by ID only.
 *
 * Admin users can access imports for the entire team, but non-admin users can only access their own imports.
 *
 */
export const getV2ImportsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ImportsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2ImportsByIdJsonResponse, GetV2ImportsByIdJsonError, ThrowOnError>({
    ...options,
    url: '/v2/imports/{id}.json',
  });
};

/**
 * Update an import
 * Updates an import, by ID only.
 *
 * Admin users can access imports for the entire team, but non-admin users can only access their own imports.
 *
 */
export const putV2ImportsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<PutV2ImportsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV2ImportsByIdJsonResponse, PutV2ImportsByIdJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/imports/{id}.json',
  });
};

/**
 * Create an Live Website Tracking Parameter
 * Creates a Live Website Tracking parameter to identify a person
 *
 */
export const postV2LiveWebsiteTrackingParametersJson = <ThrowOnError extends boolean = false>(
  options: Options<PostV2LiveWebsiteTrackingParametersJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2LiveWebsiteTrackingParametersJsonResponse,
    PostV2LiveWebsiteTrackingParametersJsonError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/live_website_tracking_parameters.json',
  });
};

/**
 * Fetch current user
 * Authenticated user information. This endpoint does not accept any parameters as it is
 * represents your authenticated user. The "Users" resource provides user information
 * for other users on the team.
 *
 */
export const getV2MeJson = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetV2MeJsonResponse, GetV2MeJsonError, ThrowOnError>({
    ...options,
    url: '/v2/me.json',
  });
};

/**
 * List meetings
 * Fetches multiple meeting records. The records can be filtered, paged, and sorted according to the respective parameters.
 * Meetings resource is responsible for events created via the Salesloft platform using calendaring features.
 * These events can relate to cadences, people, and accounts.
 *
 */
export const getV2MeetingsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2MeetingsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2MeetingsJsonResponse, GetV2MeetingsJsonError, ThrowOnError>({
    ...options,
    url: '/v2/meetings.json',
  });
};

/**
 * List meeting settings
 * Fetches multiple meeting setting records. The records can be filtered, paged, and sorted according to the respective parameters.
 *
 */
export const postV2MeetingsSettingsSearchesJson = <ThrowOnError extends boolean = false>(
  options?: Options<PostV2MeetingsSettingsSearchesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2MeetingsSettingsSearchesJsonResponse,
    PostV2MeetingsSettingsSearchesJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/meetings/settings/searches.json',
  });
};

/**
 * Update a meeting setting
 * Updates a meeting setting, by ID only.
 *
 */
export const putV2MeetingsSettingsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<PutV2MeetingsSettingsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV2MeetingsSettingsByIdJsonResponse,
    PutV2MeetingsSettingsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/meetings/settings/{id}.json',
  });
};

/**
 * Update a meeting
 * Updates a meeting, by ID only.
 *
 */
export const putV2MeetingsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<PutV2MeetingsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV2MeetingsByIdJsonResponse, PutV2MeetingsByIdJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/meetings/{id}.json',
  });
};

/**
 * Fetch the MIME content for email
 * Fetch the MIME content for email.
 *
 */
export const getV2MimeEmailPayloadsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2MimeEmailPayloadsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2MimeEmailPayloadsByIdJsonResponse,
    GetV2MimeEmailPayloadsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/mime_email_payloads/{id}.json',
  });
};

/**
 * List notes
 * Fetches multiple note records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2NotesJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2NotesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2NotesJsonResponse, GetV2NotesJsonError, ThrowOnError>({
    ...options,
    url: '/v2/notes.json',
  });
};

/**
 * Create a note
 * Creates a note.
 *
 */
export const postV2NotesJson = <ThrowOnError extends boolean = false>(
  options: Options<PostV2NotesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2NotesJsonResponse, PostV2NotesJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/notes.json',
  });
};

/**
 * Delete a note
 * Deletes a note owned by authorized account.
 * This operation is not reversible without contacting support.
 * This operation can be called multiple times successfully.
 *
 */
export const deleteV2NotesByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2NotesByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteV2NotesByIdJsonResponse, DeleteV2NotesByIdJsonError, ThrowOnError>({
    ...options,
    url: '/v2/notes/{id}.json',
  });
};

/**
 * Fetch a note
 * Fetches a note, by ID only.
 *
 */
export const getV2NotesByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2NotesByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2NotesByIdJsonResponse, GetV2NotesByIdJsonError, ThrowOnError>({
    ...options,
    url: '/v2/notes/{id}.json',
  });
};

/**
 * Update a note
 * Updates a note. Any changes to the note or associated records will not reflect in your CRM.
 *
 */
export const putV2NotesByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<PutV2NotesByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV2NotesByIdJsonResponse, PutV2NotesByIdJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/notes/{id}.json',
  });
};

/**
 * Create an ongoing action
 * Creates an ongoing action. An ongoing action is an action that is not yet completed,
 * but progress has been made towards the completion. The user should not need to do
 * anything for an ongoing action to be completed. An ongoing action can be later completed
 * by creating an activity.
 *
 * Ongoing actions are marked as status=pending_activity.
 *
 */
export const postV2OngoingActionsJson = <ThrowOnError extends boolean = false>(
  options?: Options<PostV2OngoingActionsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2OngoingActionsJsonResponse,
    PostV2OngoingActionsJsonError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/ongoing_actions.json',
  });
};

/**
 * Fetches a list of emails ready to be sent by an external email service. Only emails sent with an External Email Client will appear here.
 * Fetches a list of emails ready to be sent by an external email service.
 *
 */
export const getV2PendingEmailsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2PendingEmailsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2PendingEmailsJsonResponse, GetV2PendingEmailsJsonError, ThrowOnError>({
    ...options,
    url: '/v2/pending_emails.json',
  });
};

/**
 * Updates the status of an email sent by an External Email Client
 * Updates the status of an email sent by an External Email Client. Does not affect lofted emails.
 *
 */
export const putV2PendingEmailsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<PutV2PendingEmailsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV2PendingEmailsByIdJsonResponse,
    PutV2PendingEmailsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/pending_emails/{id}.json',
  });
};

/**
 * List people
 * Fetches multiple person records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2PeopleJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2PeopleJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2PeopleJsonResponse, GetV2PeopleJsonError, ThrowOnError>({
    ...options,
    url: '/v2/people.json',
  });
};

/**
 * Create a person
 * Creates a person. Either email_address or phone/last_name must be provided as a unique lookup
 * on the team.
 *
 */
export const postV2PeopleJson = <ThrowOnError extends boolean = false>(
  options?: Options<PostV2PeopleJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2PeopleJsonResponse, PostV2PeopleJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/people.json',
  });
};

/**
 * Delete a person
 * Deletes a person. This operation is not reversible without contacting support.
 * This operation can be called multiple times successfully.
 *
 */
export const deleteV2PeopleByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2PeopleByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteV2PeopleByIdJsonResponse, DeleteV2PeopleByIdJsonError, ThrowOnError>({
    ...options,
    url: '/v2/people/{id}.json',
  });
};

/**
 * Fetch a person
 * Fetches a person, by ID only.
 *
 */
export const getV2PeopleByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2PeopleByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2PeopleByIdJsonResponse, GetV2PeopleByIdJsonError, ThrowOnError>({
    ...options,
    url: '/v2/people/{id}.json',
  });
};

/**
 * Update a person
 * Updates a person.
 *
 */
export const putV2PeopleByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<PutV2PeopleByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV2PeopleByIdJsonResponse, PutV2PeopleByIdJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/people/{id}.json',
  });
};

/**
 * List person stages
 * Fetches multiple person stage records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2PersonStagesJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2PersonStagesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2PersonStagesJsonResponse, GetV2PersonStagesJsonError, ThrowOnError>({
    ...options,
    url: '/v2/person_stages.json',
  });
};

/**
 * Create a person stage
 * Creates a person stage.
 *
 */
export const postV2PersonStagesJson = <ThrowOnError extends boolean = false>(
  options: Options<PostV2PersonStagesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2PersonStagesJsonResponse, PostV2PersonStagesJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/person_stages.json',
  });
};

/**
 * Delete an person stage
 * Deletes a person stage. This operation is not reversible without contacting support.
 * This operation can be called multiple times successfully.
 *
 */
export const deleteV2PersonStagesByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2PersonStagesByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV2PersonStagesByIdJsonResponse,
    DeleteV2PersonStagesByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/person_stages/{id}.json',
  });
};

/**
 * Fetch a person stage
 * Fetches a person stage, by ID only.
 *
 */
export const getV2PersonStagesByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2PersonStagesByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2PersonStagesByIdJsonResponse,
    GetV2PersonStagesByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/person_stages/{id}.json',
  });
};

/**
 * Update a person stage
 * Updates a person stage.
 *
 */
export const putV2PersonStagesByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<PutV2PersonStagesByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV2PersonStagesByIdJsonResponse,
    PutV2PersonStagesByIdJsonError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/person_stages/{id}.json',
  });
};

/**
 * Upsert a person
 * Upserts a person record. The upsert_key dictates how the upsert will be performed. The create and update behavior
 * is exactly the same as the individual create and update endpoints.
 *
 */
export const postV2PersonUpsertsJson = <ThrowOnError extends boolean = false>(
  options?: Options<PostV2PersonUpsertsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2PersonUpsertsJsonResponse, PostV2PersonUpsertsJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/person_upserts.json',
  });
};

/**
 * List phone number assignments
 * Fetches multiple phone number assignment records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2PhoneNumberAssignmentsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2PhoneNumberAssignmentsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2PhoneNumberAssignmentsJsonResponse,
    GetV2PhoneNumberAssignmentsJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/phone_number_assignments.json',
  });
};

/**
 * Fetch a phone number assignment
 * Fetches a phone number assignment, by ID only.
 *
 */
export const getV2PhoneNumberAssignmentsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2PhoneNumberAssignmentsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2PhoneNumberAssignmentsByIdJsonResponse,
    GetV2PhoneNumberAssignmentsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/phone_number_assignments/{id}.json',
  });
};

/**
 * List caller ids
 * Each entry is a possible caller ID match for the number. Multiple
 * entries may be returned if the phone number is present on more than one
 * person in the system.  Phone number should be in E.164 format.
 *
 */
export const getV2PhoneNumbersCallerIdsJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2PhoneNumbersCallerIdsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2PhoneNumbersCallerIdsJsonResponse,
    GetV2PhoneNumbersCallerIdsJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/phone_numbers/caller_ids.json',
  });
};

/**
 * Fetch recording setting
 * Fetches the recording status for a given phone number, based on Do Not Record and Recording Governance for your team.
 * Phone number should be in E.164 format.
 *
 */
export const getV2PhoneNumbersRecordingSettingsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2PhoneNumbersRecordingSettingsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2PhoneNumbersRecordingSettingsByIdJsonResponse,
    GetV2PhoneNumbersRecordingSettingsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/phone_numbers/recording_settings/{id}.json',
  });
};

/**
 * List saved list views
 * Fetches multiple saved list view records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2SavedListViewsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2SavedListViewsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2SavedListViewsJsonResponse, GetV2SavedListViewsJsonError, ThrowOnError>({
    ...options,
    url: '/v2/saved_list_views.json',
  });
};

/**
 * Create a saved list view
 * Creates a saved list view.
 *
 */
export const postV2SavedListViewsJson = <ThrowOnError extends boolean = false>(
  options: Options<PostV2SavedListViewsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2SavedListViewsJsonResponse,
    PostV2SavedListViewsJsonError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/saved_list_views.json',
  });
};

/**
 * Delete a saved list view
 * Deletes a saved list view. This operation is not reversible without contacting support.
 * This operation can be called multiple times successfully.
 *
 */
export const deleteV2SavedListViewsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2SavedListViewsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV2SavedListViewsByIdJsonResponse,
    DeleteV2SavedListViewsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/saved_list_views/{id}.json',
  });
};

/**
 * Fetch a saved list view
 * Fetches a saved list view, by ID only.
 *
 */
export const getV2SavedListViewsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2SavedListViewsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2SavedListViewsByIdJsonResponse,
    GetV2SavedListViewsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/saved_list_views/{id}.json',
  });
};

/**
 * Update a saved list view
 * Updates a saved list view.
 *
 */
export const putV2SavedListViewsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<PutV2SavedListViewsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV2SavedListViewsByIdJsonResponse,
    PutV2SavedListViewsByIdJsonError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/saved_list_views/{id}.json',
  });
};

/**
 * List steps
 * Fetches multiple step records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2StepsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2StepsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2StepsJsonResponse, GetV2StepsJsonError, ThrowOnError>({
    ...options,
    url: '/v2/steps.json',
  });
};

/**
 * Fetch a step
 * Fetches a step, by ID only.
 *
 */
export const getV2StepsByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2StepsByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2StepsByIdJsonResponse, GetV2StepsByIdJsonError, ThrowOnError>({
    ...options,
    url: '/v2/steps/{id}.json',
  });
};

/**
 * List successes
 * Fetches multiple success records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2SuccessesJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2SuccessesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2SuccessesJsonResponse, GetV2SuccessesJsonError, ThrowOnError>({
    ...options,
    url: '/v2/successes.json',
  });
};

/**
 * List team tags
 * Fetches a list of the tags used for a team. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 * Tags can be applied to mulitple resource types.
 *
 */
export const getV2TagsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2TagsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2TagsJsonResponse, GetV2TagsJsonError, ThrowOnError>({
    ...options,
    url: '/v2/tags.json',
  });
};

/**
 * List tasks
 * Fetches multiple task records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 */
export const getV2TasksJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2TasksJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2TasksJsonResponse, GetV2TasksJsonError, ThrowOnError>({
    ...options,
    url: '/v2/tasks.json',
  });
};

/**
 * Create a Task
 * Creates a task.
 *
 */
export const postV2TasksJson = <ThrowOnError extends boolean = false>(
  options: Options<PostV2TasksJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2TasksJsonResponse, PostV2TasksJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/tasks.json',
  });
};

/**
 * Fetch a task
 * Fetches a task, by ID only.
 *
 */
export const getV2TasksByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2TasksByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2TasksByIdJsonResponse, GetV2TasksByIdJsonError, ThrowOnError>({
    ...options,
    url: '/v2/tasks/{id}.json',
  });
};

/**
 * Update a Task
 * Updates a task.
 *
 */
export const putV2TasksByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<PutV2TasksByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV2TasksByIdJsonResponse, PutV2TasksByIdJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/tasks/{id}.json',
  });
};

/**
 * Fetch current team
 * Fetches the team of the authenticated user.
 *
 */
export const getV2TeamJson = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetV2TeamJsonResponse, GetV2TeamJsonError, ThrowOnError>({
    ...options,
    url: '/v2/team.json',
  });
};

/**
 * List team template attachments
 * Fetches multiple team template attachment records. The records can be filtered and paged according to
 * the respective parameters.
 *
 */
export const getV2TeamTemplateAttachmentsJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2TeamTemplateAttachmentsJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2TeamTemplateAttachmentsJsonResponse,
    GetV2TeamTemplateAttachmentsJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/team_template_attachments.json',
  });
};

/**
 * List team templates
 * Fetches multiple team template records. The records can be filtered, paged, and sorted according to
 * the respective parameters.
 *
 * Team templates are templates that are available team-wide. Admins may use
 * team templates to create original content for the entire team, monitor version control to ensure templates are always up to date,
 * and track template performance across the entire organization. All metrics on a team template reflect usage across the team; individual metrics can be found with the email_templates API endpoint.
 *
 */
export const getV2TeamTemplatesJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2TeamTemplatesJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2TeamTemplatesJsonResponse, GetV2TeamTemplatesJsonError, ThrowOnError>({
    ...options,
    url: '/v2/team_templates.json',
  });
};

/**
 * Fetch a team template
 * Fetches a team template, by ID only.
 *
 */
export const getV2TeamTemplatesByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2TeamTemplatesByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2TeamTemplatesByIdJsonResponse,
    GetV2TeamTemplatesByIdJsonError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/team_templates/{id}.json',
  });
};

/**
 * Create a live feed item
 * Creates a live feed item that can be sent to users. May only be used by whitelisted Frontend Integrations. Reference the Salesloft App Directory and Frontend Integrations sections for additional details.
 */
export const postV2ThirdPartyLiveFeedItems = <ThrowOnError extends boolean = false>(
  options: Options<PostV2ThirdPartyLiveFeedItemsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2ThirdPartyLiveFeedItemsResponse,
    PostV2ThirdPartyLiveFeedItemsError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/third_party_live_feed_items',
  });
};

/**
 * List users
 * Non Admin: Lists only your user, or all on team depending on group visibility policy
 * Team Admin: Lists users associated with your team
 *
 */
export const getV2UsersJson = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2UsersJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2UsersJsonResponse, GetV2UsersJsonError, ThrowOnError>({
    ...options,
    url: '/v2/users.json',
  });
};

/**
 * Fetch a user
 * Fetches a user, by ID only.
 *
 */
export const getV2UsersByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<GetV2UsersByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2UsersByIdJsonResponse, GetV2UsersByIdJsonError, ThrowOnError>({
    ...options,
    url: '/v2/users/{id}.json',
  });
};

/**
 * Update a user
 * Updates a user.
 *
 */
export const putV2UsersByIdJson = <ThrowOnError extends boolean = false>(
  options: Options<PutV2UsersByIdJsonData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV2UsersByIdJsonResponse, PutV2UsersByIdJsonError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/users/{id}.json',
  });
};

/**
 * List webhook subscriptions
 * Fetches all of the customer's webhook subscriptions for your application.
 */
export const getV2WebhookSubscriptions = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2WebhookSubscriptionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2WebhookSubscriptionsResponse,
    GetV2WebhookSubscriptionsError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/webhook_subscriptions',
  });
};

/**
 * Create a webhook subscription
 * Creates a webhook subscription. Visit the <a href="/webhooks.html" target="_blank" rel="noopener noreferrer">webhooks page</a> for additional details and a list of available webhooks.
 * Request must be made with a valid Oauth token or API key.
 */
export const postV2WebhookSubscriptions = <ThrowOnError extends boolean = false>(
  options: Options<PostV2WebhookSubscriptionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2WebhookSubscriptionsResponse,
    PostV2WebhookSubscriptionsError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/webhook_subscriptions',
  });
};

/**
 * Delete a webhook subscription
 * Deletes a webhook subscription. This operation is not reversible without contacting support. This operation can be called multiple times successfully.
 */
export const deleteV2WebhookSubscriptionsById = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2WebhookSubscriptionsByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV2WebhookSubscriptionsByIdResponse,
    DeleteV2WebhookSubscriptionsByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/webhook_subscriptions/{id}',
  });
};

/**
 * Fetch a webhook subscription
 * Fetches a webhook subscription, by ID only.
 */
export const getV2WebhookSubscriptionsById = <ThrowOnError extends boolean = false>(
  options: Options<GetV2WebhookSubscriptionsByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2WebhookSubscriptionsByIdResponse,
    GetV2WebhookSubscriptionsByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/webhook_subscriptions/{id}',
  });
};

/**
 * Update a webhook subscription
 * Updates a webhook subscription.
 * Request must be made with a valid Oauth token or API key.
 */
export const putV2WebhookSubscriptionsById = <ThrowOnError extends boolean = false>(
  options: Options<PutV2WebhookSubscriptionsByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV2WebhookSubscriptionsByIdResponse,
    PutV2WebhookSubscriptionsByIdError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/webhook_subscriptions/{id}',
  });
};
