// Generated by ts-to-zod
import { z } from 'zod';

export const planDataSchema = z.object({
  amount: z.number().optional(),
  plan: z
    .union([
      z.literal('STARTER'),
      z.literal('SFDC_1M_EDITION'),
      z.literal('BRONZE'),
      z.literal('SILVER'),
      z.literal('GOLD'),
      z.literal('DATASET_DOWNLOAD'),
    ])
    .optional(),
  source: z
    .union([
      z.literal('SALESFORCE'),
      z.literal('HEROKU'),
      z.literal('SF_AUTO_PROVISION'),
      z.literal('SF_AUTO_PROVISION_BOUND'),
    ])
    .optional(),
});

export const apiUsageSchema = z.object({
  endsAt: z.string().optional(),
  id: z.string().optional(),
  licenseId: z.string().optional(),
  object: z.string().optional(),
  organizationId: z.string().optional(),
  planData: z.array(planDataSchema).optional(),
  predictionsMax: z.number().optional(),
  predictionsUsed: z.number().optional(),
  startsAt: z.string().optional(),
});

export const cellLocationSchema = z.object({
  colIndex: z.number().optional(),
  rowIndex: z.number().optional(),
});

export const boundingBoxSchema = z.object({
  maxX: z.number().optional(),
  maxY: z.number().optional(),
  minX: z.number().optional(),
  minY: z.number().optional(),
});

export const deletionResponseSchema = z.object({
  deletedObjectId: z.string().optional(),
  id: z.string().optional(),
  message: z.string().optional(),
  object: z.string().optional(),
  organizationId: z.string().optional(),
  progress: z.number().optional(),
  status: z
    .union([
      z.literal('QUEUED'),
      z.literal('RUNNING'),
      z.literal('SUCCEEDED_WAITING_FOR_CACHE_REMOVAL'),
      z.literal('SUCCEEDED'),
      z.literal('KILLED'),
      z.literal('FAILED'),
      z.literal('RETRY'),
    ])
    .optional(),
  type: z.union([z.literal('DATASET'), z.literal('MODEL')]).optional(),
});

export const statusSchema = z.union([
  z.literal('QUEUED'),
  z.literal('RUNNING'),
  z.literal('SUCCEEDED_WAITING_FOR_CACHE_REMOVAL'),
  z.literal('SUCCEEDED'),
  z.literal('KILLED'),
  z.literal('FAILED'),
  z.literal('RETRY'),
]);

export const typeSchema = z.union([z.literal('DATASET'), z.literal('MODEL')]);

export const detectionResultSchema = z.object({
  boundingBox: boundingBoxSchema.optional(),
  label: z.string().optional(),
  probability: z.number().optional(),
});

export const entityObjectSchema = z.object({
  boundingBox: boundingBoxSchema.optional(),
  entity: z.string().optional(),
  text: z.string().optional(),
});

export const labelSchema = z.object({
  datasetId: z.number(),
  id: z.number().optional(),
  name: z.string(),
  numExamples: z.number().optional(),
});

export const exampleSchema = z.object({
  createdAt: z.string().optional(),
  id: z.number(),
  label: labelSchema.optional(),
  location: z.string().optional(),
  name: z.string(),
  object: z.string().optional(),
});

export const generateAccessTokenResponseSchema = z.object({
  access_token: z.string().optional(),
  expires_in: z.string().optional(),
  refresh_token: z.string().optional(),
  token_type: z.string().optional(),
});

export const imageClassificationRequestSchema = z.object({
  modelId: z.string(),
  numResults: z.number().optional(),
  sampleBase64Content: z.string().optional(),
  sampleId: z.string().optional(),
  sampleLocation: z.string().optional(),
});

export const labelResultSchema = z.object({
  label: z.string().optional(),
  probability: z.number().optional(),
});

export const intentPredictRequestSchema = z.object({
  document: z.string(),
  modelId: z.string(),
  numResults: z.number().optional(),
  sampleId: z.string().optional(),
});

export const intentPredictResponseSchema = z.object({
  object: z.string().optional(),
  probabilities: z.array(labelResultSchema).optional(),
  sampleId: z.string().optional(),
});

export const labelSummarySchema = z.object({
  labels: z.array(labelSchema).optional(),
});

export const learningCurveSchema = z.object({
  epoch: z.record(z.unknown()).optional(),
  epochResults: z.record(z.unknown()).optional(),
  metricsData: z.record(z.unknown()).optional(),
  object: z.string().optional(),
});

export const learningCurveListSchema = z.object({
  data: z.array(learningCurveSchema).optional(),
  object: z.string().optional(),
});

export const metricsSchema = z.object({
  algorithm: z.string().optional(),
  createdAt: z.string().optional(),
  id: z.string().optional(),
  language: z.string().optional(),
  metricsData: z.record(z.unknown()).optional(),
  object: z.string().optional(),
});

export const modelSchema = z.object({
  algorithm: z.string().optional(),
  createdAt: z.string().optional(),
  datasetId: z.number(),
  datasetVersionId: z.number(),
  failureMsg: z.string().optional(),
  language: z.string().optional(),
  modelId: z.string(),
  modelType: z.string().optional(),
  name: z.string(),
  object: z.string().optional(),
  progress: z.number(),
  status: z.union([
    z.literal('QUEUED'),
    z.literal('RUNNING'),
    z.literal('SUCCEEDED'),
    z.literal('FAILED'),
    z.literal('KILLED'),
    z.literal('FAILED_WITH_RETRIES'),
  ]),
  updatedAt: z.string().optional(),
});

export const status2Schema = z.union([
  z.literal('QUEUED'),
  z.literal('RUNNING'),
  z.literal('SUCCEEDED'),
  z.literal('FAILED'),
  z.literal('KILLED'),
  z.literal('FAILED_WITH_RETRIES'),
]);

export const modelListSchema = z.object({
  data: z.array(modelSchema).optional(),
  object: z.string().optional(),
});

export const attributesSchema = z.object({
  cellLocation: cellLocationSchema.optional(),
  language: z.string().optional(),
  pageNumber: z.string().optional(),
  tag: z.string().optional(),
  value: entityObjectSchema.optional(),
});

export const objectDetectionRequestSchema = z.object({
  modelId: z.string(),
  sampleBase64Content: z.string().optional(),
  sampleId: z.string().optional(),
  sampleLocation: z.string().optional(),
});

export const objectDetectionResponseSchema = z.object({
  object: z.string().optional(),
  probabilities: z.array(detectionResultSchema).optional(),
  sampleId: z.string().optional(),
});

export const planSchema = z.union([
  z.literal('STARTER'),
  z.literal('SFDC_1M_EDITION'),
  z.literal('BRONZE'),
  z.literal('SILVER'),
  z.literal('GOLD'),
  z.literal('DATASET_DOWNLOAD'),
]);

export const sourceSchema = z.union([
  z.literal('SALESFORCE'),
  z.literal('HEROKU'),
  z.literal('SF_AUTO_PROVISION'),
  z.literal('SF_AUTO_PROVISION_BOUND'),
]);

export const predictionErrorResponseSchema = z.object({
  message: z.string().optional(),
  object: z.string().optional(),
});

export const sentimentPredictRequestSchema = z.object({
  document: z.string(),
  modelId: z.string(),
  numResults: z.number().optional(),
  sampleId: z.string().optional(),
});

export const sentimentPredictResponseSchema = z.object({
  object: z.string().optional(),
  probabilities: z.array(labelResultSchema).optional(),
  sampleId: z.string().optional(),
});

export const trainResponseSchema = z.object({
  algorithm: z.string().optional(),
  createdAt: z.string().optional(),
  datasetId: z.number(),
  datasetVersionId: z.number(),
  epochs: z.number().optional(),
  failureMsg: z.string().optional(),
  language: z.string(),
  learningRate: z.number().optional(),
  modelId: z.string(),
  modelType: z.string().optional(),
  name: z.string(),
  object: z.string().optional(),
  progress: z.number(),
  queuePosition: z.number().optional(),
  status: z.union([
    z.literal('QUEUED'),
    z.literal('RUNNING'),
    z.literal('SUCCEEDED'),
    z.literal('FAILED'),
    z.literal('KILLED'),
    z.literal('FAILED_WITH_RETRIES'),
  ]),
  trainParams: z.string().optional(),
  trainStats: z.string().optional(),
  updatedAt: z.string().optional(),
});

export const v2LanguageTrainParamsSchema = z.object({
  trainSplitRatio: z.number().optional(),
  withFeedback: z.boolean().optional(),
  withGlobalDatasetId: z.number().optional(),
});

export const v2VisionTrainParamsSchema = z.object({
  trainSplitRatio: z.number().optional(),
  withFeedback: z.boolean().optional(),
  withGlobalDatasetId: z.number().optional(),
});

export const apiUsageListSchema = z.object({
  data: z.array(apiUsageSchema).optional(),
  object: z.string().optional(),
});

export const getApiUsagePlansV2ErrorSchema = z.unknown();

export const listDatasetsDataSchema = z.object({
  query: z
    .object({
      count: z.string().optional(),
      global: z.boolean().optional(),
      offset: z.string().optional(),
    })
    .optional(),
});

export const listDatasetsErrorSchema = z.unknown();

export const uploadDatasetAsyncDataSchema = z.object({
  body: z
    .object({
      data: z.string().optional(),
      name: z.string().optional(),
      path: z.string().optional(),
      type: z.union([z.literal('text-intent'), z.literal('text-sentiment')]).optional(),
    })
    .optional(),
});

export const datasetSchema = z.object({
  available: z.boolean().optional(),
  createdAt: z.string().optional(),
  id: z.number(),
  labelSummary: labelSummarySchema.optional(),
  language: z.string().optional(),
  name: z.string(),
  numOfDuplicates: z.number().optional(),
  object: z.string().optional(),
  statusMsg: z.string().optional(),
  totalExamples: z.number().optional(),
  totalLabels: z.number().optional(),
  type: z.string().optional(),
  updatedAt: z.string().optional(),
});

export const uploadDatasetAsyncErrorSchema = z.unknown();

export const uploadDatasetSyncDataSchema = z.object({
  body: z
    .object({
      data: z.string().optional(),
      name: z.string().optional(),
      path: z.string().optional(),
      type: z.union([z.literal('text-intent'), z.literal('text-sentiment')]).optional(),
    })
    .optional(),
});

export const uploadDatasetSyncResponseSchema = datasetSchema;

export const uploadDatasetSyncErrorSchema = z.unknown();

export const deleteDatasetDataSchema = z.object({
  path: z.object({
    datasetId: z.string(),
  }),
});

export const deleteDatasetResponseSchema = deletionResponseSchema;

export const deleteDatasetErrorSchema = z.unknown();

export const getDatasetDataSchema = z.object({
  path: z.object({
    datasetId: z.string(),
  }),
});

export const getDatasetResponseSchema = datasetSchema;

export const getDatasetErrorSchema = z.unknown();

export const getExamplesDataSchema = z.object({
  path: z.object({
    datasetId: z.string(),
  }),
  query: z
    .object({
      count: z.string().optional(),
      offset: z.string().optional(),
      source: z.union([z.literal('all'), z.literal('feedback'), z.literal('upload')]).optional(),
    })
    .optional(),
});

export const exampleListSchema = z.object({
  data: z.array(exampleSchema).optional(),
  object: z.string().optional(),
});

export const getExamplesErrorSchema = z.unknown();

export const getTrainedModelsDataSchema = z.object({
  path: z.object({
    datasetId: z.string(),
  }),
  query: z
    .object({
      count: z.string().optional(),
      offset: z.string().optional(),
    })
    .optional(),
});

export const getTrainedModelsResponseSchema = modelListSchema;

export const getTrainedModelsErrorSchema = z.unknown();

export const updateDatasetAsyncDataSchema = z.object({
  body: z
    .object({
      data: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
  path: z.object({
    datasetId: z.string(),
  }),
});

export const updateDatasetAsyncResponseSchema = datasetSchema;

export const updateDatasetAsyncErrorSchema = z.unknown();

export const getDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getResponseSchema = deletionResponseSchema;

export const getErrorSchema = z.unknown();

export const getExamplesByLabelDataSchema = z.object({
  query: z
    .object({
      count: z.string().optional(),
      labelId: z.string().optional(),
      offset: z.string().optional(),
    })
    .optional(),
});

export const getExamplesByLabelResponseSchema = exampleListSchema;

export const getExamplesByLabelErrorSchema = z.unknown();

export const provideFeedbackDataSchema = z.object({
  body: z
    .object({
      document: z.string().optional(),
      expectedLabel: z.string().optional(),
      modelId: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
});

export const provideFeedbackResponseSchema = exampleSchema;

export const provideFeedbackErrorSchema = z.unknown();

export const intentMultipartDataSchema = z.object({
  body: intentPredictRequestSchema.optional(),
});

export const intentMultipartResponseSchema = intentPredictResponseSchema;

export const intentMultipartErrorSchema = predictionErrorResponseSchema;

export const deleteModelDataSchema = z.object({
  path: z.object({
    modelId: z.string(),
  }),
});

export const deleteModelResponseSchema = deletionResponseSchema;

export const deleteModelErrorSchema = z.unknown();

export const getTrainedModelMetricsDataSchema = z.object({
  path: z.object({
    modelId: z.string(),
  }),
});

export const getTrainedModelMetricsResponseSchema = metricsSchema;

export const getTrainedModelMetricsErrorSchema = z.unknown();

export const getTrainedModelLearningCurveDataSchema = z.object({
  path: z.object({
    modelId: z.string(),
  }),
  query: z
    .object({
      count: z.string().optional(),
      offset: z.string().optional(),
    })
    .optional(),
});

export const getTrainedModelLearningCurveResponseSchema = learningCurveListSchema;

export const getTrainedModelLearningCurveErrorSchema = z.unknown();

export const retrainDataSchema = z.object({
  body: z
    .object({
      algorithm: z.string().optional(),
      epochs: z.number().optional(),
      learningRate: z.number().optional(),
      modelId: z.string().optional(),
      trainParams: v2LanguageTrainParamsSchema.optional(),
    })
    .optional(),
});

export const retrainResponseSchema = trainResponseSchema;

export const retrainErrorSchema = z.unknown();

export const sentimentMultipartDataSchema = z.object({
  body: sentimentPredictRequestSchema.optional(),
});

export const sentimentMultipartResponseSchema = sentimentPredictResponseSchema;

export const sentimentMultipartErrorSchema = z.unknown();

export const trainDataSchema = z.object({
  body: z
    .object({
      algorithm: z.string().optional(),
      datasetId: z.number().optional(),
      epochs: z.number().optional(),
      learningRate: z.number().optional(),
      name: z.string().optional(),
      trainParams: v2LanguageTrainParamsSchema.optional(),
    })
    .optional(),
});

export const trainResponse2Schema = trainResponseSchema;

export const trainErrorSchema = z.unknown();

export const getTrainStatusAndProgressDataSchema = z.object({
  path: z.object({
    modelId: z.string(),
  }),
});

export const getTrainStatusAndProgressResponseSchema = trainResponseSchema;

export const getTrainStatusAndProgressErrorSchema = z.unknown();

export const generateTokenV2DataSchema = z.object({
  body: z
    .object({
      assertion: z.string().optional(),
      grant_type: z
        .union([z.literal('urn:ietf:params:oauth:grant-type:jwt-bearer'), z.literal('refresh_token')])
        .optional(),
      refresh_token: z.string().optional(),
      scope: z.string().optional(),
      valid_for: z.number().optional(),
    })
    .optional(),
});

export const generateTokenV2ResponseSchema = generateAccessTokenResponseSchema;

export const generateTokenV2ErrorSchema = z.unknown();

export const revokeRefreshTokenV2DataSchema = z.object({
  path: z.object({
    token: z.string(),
  }),
});

export const revokeRefreshTokenV2ResponseSchema = z.any();

export const revokeRefreshTokenV2ErrorSchema = z.unknown();

export const updateDatasetAsync1DataSchema = z.object({
  body: z
    .object({
      data: z.string().optional(),
      modelId: z.string().optional(),
    })
    .optional(),
});

export const updateDatasetAsync1ResponseSchema = datasetSchema;

export const updateDatasetAsync1ErrorSchema = z.unknown();

export const listDatasets1DataSchema = z.object({
  query: z
    .object({
      count: z.string().optional(),
      global: z.boolean().optional(),
      offset: z.string().optional(),
    })
    .optional(),
});

export const datasetListSchema = z.object({
  data: z.array(datasetSchema).optional(),
  object: z.string().optional(),
});

export const listDatasets1ErrorSchema = z.unknown();

export const createDatasetDataSchema = z.object({
  body: z
    .object({
      labels: z.string().optional(),
      name: z.string().optional(),
      type: z.union([z.literal('image'), z.literal('image-multi-label')]).optional(),
    })
    .optional(),
});

export const createDatasetResponseSchema = datasetSchema;

export const createDatasetErrorSchema = z.unknown();

export const uploadDatasetAsync1DataSchema = z.object({
  body: z
    .object({
      data: z.string().optional(),
      name: z.string().optional(),
      path: z.string().optional(),
      type: z.union([z.literal('image'), z.literal('image-detection'), z.literal('image-multi-label')]).optional(),
    })
    .optional(),
});

export const uploadDatasetAsync1ResponseSchema = datasetSchema;

export const uploadDatasetAsync1ErrorSchema = z.unknown();

export const uploadDatasetSync1DataSchema = z.object({
  body: z
    .object({
      data: z.string().optional(),
      name: z.string().optional(),
      path: z.string().optional(),
      type: z.union([z.literal('image'), z.literal('image-detection'), z.literal('image-multi-label')]).optional(),
    })
    .optional(),
});

export const uploadDatasetSync1ResponseSchema = datasetSchema;

export const uploadDatasetSync1ErrorSchema = z.unknown();

export const deleteDataset1DataSchema = z.object({
  path: z.object({
    datasetId: z.string(),
  }),
});

export const deleteDataset1ResponseSchema = deletionResponseSchema;

export const deleteDataset1ErrorSchema = z.unknown();

export const getDataset1DataSchema = z.object({
  path: z.object({
    datasetId: z.string(),
  }),
});

export const getDataset1ResponseSchema = datasetSchema;

export const getDataset1ErrorSchema = z.unknown();

export const getExamples1DataSchema = z.object({
  path: z.object({
    datasetId: z.string(),
  }),
  query: z
    .object({
      count: z.string().optional(),
      offset: z.string().optional(),
      source: z.union([z.literal('all'), z.literal('feedback'), z.literal('upload')]).optional(),
    })
    .optional(),
});

export const getExamples1ResponseSchema = exampleListSchema;

export const getExamples1ErrorSchema = z.unknown();

export const addExampleDataSchema = z.object({
  body: z
    .object({
      data: z.string().optional(),
      labelId: z.number().optional(),
      name: z.string().optional(),
    })
    .optional(),
  path: z.object({
    datasetId: z.string(),
  }),
});

export const addExampleResponseSchema = exampleSchema;

export const addExampleErrorSchema = z.unknown();

export const getTrainedModels1DataSchema = z.object({
  path: z.object({
    datasetId: z.string(),
  }),
  query: z
    .object({
      count: z.string().optional(),
      offset: z.string().optional(),
    })
    .optional(),
});

export const getTrainedModels1ResponseSchema = modelListSchema;

export const getTrainedModels1ErrorSchema = z.unknown();

export const updateDatasetAsync2DataSchema = z.object({
  body: z
    .object({
      data: z.string().optional(),
      path: z.string().optional(),
    })
    .optional(),
  path: z.object({
    datasetId: z.string(),
  }),
});

export const updateDatasetAsync2ResponseSchema = datasetSchema;

export const updateDatasetAsync2ErrorSchema = z.unknown();

export const get1DataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const get1ResponseSchema = deletionResponseSchema;

export const get1ErrorSchema = z.unknown();

export const detectMultipartDataSchema = z.object({
  body: objectDetectionRequestSchema.optional(),
});

export const detectMultipartResponseSchema = objectDetectionResponseSchema;

export const detectMultipartErrorSchema = z.unknown();

export const getExamplesByLabel1DataSchema = z.object({
  query: z
    .object({
      count: z.string().optional(),
      labelId: z.string().optional(),
      offset: z.string().optional(),
    })
    .optional(),
});

export const getExamplesByLabel1ResponseSchema = exampleListSchema;

export const getExamplesByLabel1ErrorSchema = z.unknown();

export const provideFeedback1DataSchema = z.object({
  body: z
    .object({
      data: z.string().optional(),
      expectedLabel: z.string().optional(),
      modelId: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
});

export const provideFeedback1ResponseSchema = exampleSchema;

export const provideFeedback1ErrorSchema = z.unknown();

export const deleteModel1DataSchema = z.object({
  path: z.object({
    modelId: z.string(),
  }),
});

export const deleteModel1ResponseSchema = deletionResponseSchema;

export const deleteModel1ErrorSchema = z.unknown();

export const getTrainedModelMetrics1DataSchema = z.object({
  path: z.object({
    modelId: z.string(),
  }),
});

export const getTrainedModelMetrics1ResponseSchema = metricsSchema;

export const getTrainedModelMetrics1ErrorSchema = z.unknown();

export const getTrainedModelLearningCurve1DataSchema = z.object({
  path: z.object({
    modelId: z.string(),
  }),
  query: z
    .object({
      count: z.string().optional(),
      offset: z.string().optional(),
    })
    .optional(),
});

export const getTrainedModelLearningCurve1ResponseSchema = learningCurveListSchema;

export const getTrainedModelLearningCurve1ErrorSchema = z.unknown();

export const ocrMultipartErrorSchema = z.unknown();

export const predictMultipartDataSchema = z.object({
  body: imageClassificationRequestSchema.optional(),
});

export const imageClassificationResponseSchema = z.object({
  object: z.string().optional(),
  probabilities: z.array(labelResultSchema).optional(),
  sampleId: z.string().optional(),
});

export const predictMultipartErrorSchema = z.unknown();

export const retrain1DataSchema = z.object({
  body: z
    .object({
      algorithm: z.string().optional(),
      epochs: z.number().optional(),
      learningRate: z.number().optional(),
      modelId: z.string().optional(),
      trainParams: v2VisionTrainParamsSchema.optional(),
    })
    .optional(),
});

export const retrain1ResponseSchema = trainResponseSchema;

export const retrain1ErrorSchema = z.unknown();

export const train1DataSchema = z.object({
  body: z
    .object({
      algorithm: z.string().optional(),
      datasetId: z.number().optional(),
      epochs: z.number().optional(),
      learningRate: z.number().optional(),
      name: z.string().optional(),
      trainParams: v2VisionTrainParamsSchema.optional(),
    })
    .optional(),
});

export const train1ResponseSchema = trainResponseSchema;

export const train1ErrorSchema = z.unknown();

export const getTrainStatusAndProgress1DataSchema = z.object({
  path: z.object({
    modelId: z.string(),
  }),
});

export const getTrainStatusAndProgress1ResponseSchema = trainResponseSchema;

export const getTrainStatusAndProgress1ErrorSchema = z.unknown();

export const oCRResultSchema = z.object({
  attributes: attributesSchema.optional(),
  boundingBox: boundingBoxSchema.optional(),
  label: z.string().optional(),
  probability: z.number().optional(),
});

export const getApiUsagePlansV2ResponseSchema = apiUsageListSchema;

export const listDatasetsResponseSchema = datasetListSchema;

export const uploadDatasetAsyncResponseSchema = datasetSchema;

export const getExamplesResponseSchema = exampleListSchema;

export const listDatasets1ResponseSchema = datasetListSchema;

export const oCRPredictResponseSchema = z.object({
  object: z.string().optional(),
  probabilities: z.array(oCRResultSchema).optional(),
  sampleId: z.string().optional(),
  task: z.string().optional(),
});

export const predictMultipartResponseSchema = imageClassificationResponseSchema;

export const ocrMultipartResponseSchema = oCRPredictResponseSchema;
