// This file is auto-generated by @hey-api/openapi-ts

export type ApiUsage = {
  endsAt?: string;
  id?: string;
  licenseId?: string;
  object?: string;
  organizationId?: string;
  planData?: Array<PlanData>;
  predictionsMax?: number;
  predictionsUsed?: number;
  startsAt?: string;
};

export type ApiUsageList = {
  data?: Array<ApiUsage>;
  object?: string;
};

/**
 * Contains additional attributes related to the task parameter. If the task parameter is table, the row and column IDs for the detected text are returned. If the task parameter is contact, the detected entity tags will be returned.
 */
export type Attributes = {
  cellLocation?: CellLocation;
  language?: string;
  pageNumber?: string;
  tag?: string;
  value?: EntityObject;
};

export type BoundingBox = {
  /**
   * X-coordinate of the left side of the bounding box. The origin of the coordinate system is the top-left of the image. Number of pixels from the left edge of the image.
   */
  maxX?: number;
  /**
   * Y-coordinate of the top of the bounding box. Number of pixels from the top edge of the image.
   */
  maxY?: number;
  /**
   * X-coordinate of the right side of the bounding box. Number of pixels from the left edge of the image.
   */
  minX?: number;
  /**
   * Y-coordinate of the bottom of the bounding box. Number of pixels from the top edge of the image.
   */
  minY?: number;
};

export type CellLocation = {
  /**
   * Index of the column that contains the detected text.
   */
  colIndex?: number;
  /**
   * Index of the row that contains the detected text.
   */
  rowIndex?: number;
};

export type Dataset = {
  available?: boolean;
  /**
   * Date and time that the dataset was created.
   */
  createdAt?: string;
  id: number;
  labelSummary?: LabelSummary;
  /**
   * Dataset language.
   */
  language?: string;
  name: string;
  /**
   * Number of duplicate images. This number includes duplicates in the .zip file from which the dataset was created plus the number of duplicate images from subsequent PUT calls to add images to the dataset.
   */
  numOfDuplicates?: number;
  /**
   * Object returned; in this case, dataset.
   */
  object?: string;
  statusMsg?: string;
  /**
   * Total number of examples in the dataset.
   */
  totalExamples?: number;
  /**
   * Total number of labels in the dataset.
   */
  totalLabels?: number;
  type?: string;
  updatedAt?: string;
};

export type DatasetList = {
  data?: Array<Dataset>;
  object?: string;
};

export type DeletionResponse = {
  deletedObjectId?: string;
  id?: string;
  message?: string;
  object?: string;
  organizationId?: string;
  progress?: number;
  status?: 'QUEUED' | 'RUNNING' | 'SUCCEEDED_WAITING_FOR_CACHE_REMOVAL' | 'SUCCEEDED' | 'KILLED' | 'FAILED' | 'RETRY';
  type?: 'DATASET' | 'MODEL';
};

export type status =
  | 'QUEUED'
  | 'RUNNING'
  | 'SUCCEEDED_WAITING_FOR_CACHE_REMOVAL'
  | 'SUCCEEDED'
  | 'KILLED'
  | 'FAILED'
  | 'RETRY';

export type type = 'DATASET' | 'MODEL';

/**
 * label
 */
export type DetectionResult = {
  boundingBox?: BoundingBox;
  /**
   * Probability lable for the input.
   */
  label?: string;
  /**
   * Probability value for the input. Values are between 0�1.
   */
  probability?: number;
};

export type EntityObject = {
  boundingBox?: BoundingBox;
  entity?: string;
  text?: string;
};

export type Example = {
  /**
   * Date and time that the example was created.
   */
  createdAt?: string;
  /**
   * ID of the example.
   */
  id: number;
  label?: Label;
  /**
   * URL of the image in the dataset. This is a temporary URL that expires in 30 minutes. This URL can be used to display images that were uploaded to a dataset in a UI.
   */
  location?: string;
  /**
   * Name of the example.
   */
  name: string;
  /**
   * Object returned; in this case, example.
   */
  object?: string;
};

export type ExampleList = {
  data?: Array<Example>;
  object?: string;
};

export type GenerateAccessTokenResponse = {
  access_token?: string;
  expires_in?: string;
  refresh_token?: string;
  token_type?: string;
};

export type ImageClassificationRequest = {
  /**
   * ID of the model that makes the prediction.
   */
  modelId: string;
  /**
   * Number of probabilities to return.
   */
  numResults?: number;
  /**
   * The image contained in a base64 string.
   */
  sampleBase64Content?: string;
  /**
   * String that you can pass in to tag the prediction. Optional. Can be any value, and is returned in the response.
   */
  sampleId?: string;
  /**
   * URL of the image file.
   */
  sampleLocation?: string;
};

export type ImageClassificationResponse = {
  object?: string;
  probabilities?: Array<LabelResult>;
  /**
   * Value passed in when the prediction call was made. Returned only if the sampleId request parameter is provided.
   */
  sampleId?: string;
};

export type IntentPredictRequest = {
  /**
   * Text for which you want to return an intent prediction.
   */
  document: string;
  /**
   * ID of the model that makes the prediction. The model must have been created from a dataset with a type of text-sentiment.
   */
  modelId: string;
  /**
   * Number of probabilities to return.
   */
  numResults?: number;
  /**
   * String that you can pass in to tag the prediction. Optional. Can be any value, and is returned in the response.
   */
  sampleId?: string;
};

export type IntentPredictResponse = {
  object?: string;
  probabilities?: Array<LabelResult>;
  /**
   * Value passed in when the prediction call was made. Returned only if the sampleId request parameter is provided.
   */
  sampleId?: string;
};

/**
 * Contains information about the label with which the example is associated.
 */
export type Label = {
  /**
   * ID of the dataset that the label belongs to.
   */
  datasetId: number;
  /**
   * ID of the label.
   */
  id?: number;
  /**
   * Name of the label.
   */
  name: string;
  /**
   * Number of examples that have the label.
   */
  numExamples?: number;
};

/**
 * label
 */
export type LabelResult = {
  /**
   * Probability lable for the input.
   */
  label?: string;
  /**
   * Probability value for the input. Values are between 0�1.
   */
  probability?: number;
};

/**
 * Contains the labels array that contains all the labels for the dataset.
 */
export type LabelSummary = {
  labels?: Array<Label>;
};

export type LearningCurve = {
  /**
   * Epoch to which the metrics correspond.
   */
  epoch?: {
    [key: string]: unknown;
  };
  /**
   * Prediction results for the set of data used to test the model during training.
   */
  epochResults?: {
    [key: string]: unknown;
  };
  /**
   * Model metrics values.
   */
  metricsData?: {
    [key: string]: unknown;
  };
  /**
   * Object returned; in this case, learningcurve.
   */
  object?: string;
};

export type LearningCurveList = {
  data?: Array<LearningCurve>;
  object?: string;
};

export type Metrics = {
  algorithm?: string;
  /**
   * Date and time that the model was created.
   */
  createdAt?: string;
  /**
   * Model Id
   */
  id?: string;
  language?: string;
  /**
   * Model metrics values.
   */
  metricsData?: {
    [key: string]: unknown;
  };
  object?: string;
};

export type Model = {
  /**
   * Algorithm used to create the model. Returned only when the modelType is image-detection.
   */
  algorithm?: string;
  /**
   * Date and time that the model was created.
   */
  createdAt?: string;
  /**
   * ID of the dataset trained to create the model.
   */
  datasetId: number;
  /**
   * Not available yet
   */
  datasetVersionId: number;
  /**
   * Reason the dataset training failed. Returned only if the training status is FAILED.
   */
  failureMsg?: string;
  /**
   * Model language inherited from the dataset language. For image datasets, default is N/A. For text datasets, default is en_US.
   */
  language?: string;
  /**
   * ID of the model. Contains letters and numbers.
   */
  modelId: string;
  /**
   * Type of data from which the model was created.
   */
  modelType?: string;
  /**
   * Name of the model.
   */
  name: string;
  /**
   * Object returned; in this case, model.
   */
  object?: string;
  /**
   * How far the dataset training has progressed. Values are between 0�1.
   */
  progress: number;
  /**
   * Status of the model.
   */
  status: 'QUEUED' | 'RUNNING' | 'SUCCEEDED' | 'FAILED' | 'KILLED' | 'FAILED_WITH_RETRIES';
  /**
   * Date and time that the model was last updated.
   */
  updatedAt?: string;
};

/**
 * Status of the model.
 */
export type status2 = 'QUEUED' | 'RUNNING' | 'SUCCEEDED' | 'FAILED' | 'KILLED' | 'FAILED_WITH_RETRIES';

export type ModelList = {
  data?: Array<Model>;
  object?: string;
};

export type OCRPredictResponse = {
  object?: string;
  probabilities?: Array<OCRResult>;
  /**
   * Same value as request parameter. Returned only if the sampleId request parameter is provided.
   */
  sampleId?: string;
  /**
   * Same value as request parameter. Returns text if the request parameter isn't supplied.
   */
  task?: string;
};

/**
 * Array of probabilities for the prediction.
 */
export type OCRResult = {
  attributes?: Attributes;
  boundingBox?: BoundingBox;
  /**
   * Content of the detected text.
   */
  label?: string;
  /**
   * Probability value for the input. Values are between 0�1.
   */
  probability?: number;
};

export type ObjectDetectionRequest = {
  /**
   * ID of the model that makes the detection.
   */
  modelId: string;
  /**
   * The image contained in a base64 string.
   */
  sampleBase64Content?: string;
  /**
   * String that you can pass in to tag the prediction. Optional. Can be any value, and is returned in the response.
   */
  sampleId?: string;
  /**
   * URL of the image file.
   */
  sampleLocation?: string;
};

export type ObjectDetectionResponse = {
  object?: string;
  probabilities?: Array<DetectionResult>;
  /**
   * Value passed in when the prediction call was made. Returned only if the sampleId request parameter is provided.
   */
  sampleId?: string;
};

export type PlanData = {
  amount?: number;
  plan?: 'STARTER' | 'SFDC_1M_EDITION' | 'BRONZE' | 'SILVER' | 'GOLD' | 'DATASET_DOWNLOAD';
  source?: 'SALESFORCE' | 'HEROKU' | 'SF_AUTO_PROVISION' | 'SF_AUTO_PROVISION_BOUND';
};

export type plan = 'STARTER' | 'SFDC_1M_EDITION' | 'BRONZE' | 'SILVER' | 'GOLD' | 'DATASET_DOWNLOAD';

export type source = 'SALESFORCE' | 'HEROKU' | 'SF_AUTO_PROVISION' | 'SF_AUTO_PROVISION_BOUND';

export type PredictionErrorResponse = {
  message?: string;
  object?: string;
};

export type SentimentPredictRequest = {
  /**
   * Text for which you want to return a sentiment prediction.
   */
  document: string;
  /**
   * ID of the model that makes the prediction. The model must have been created from a dataset with a type of text-sentiment.
   */
  modelId: string;
  /**
   * Number of probabilities to return.
   */
  numResults?: number;
  /**
   * String that you can pass in to tag the prediction. Optional. Can be any value, and is returned in the response.
   */
  sampleId?: string;
};

export type SentimentPredictResponse = {
  object?: string;
  probabilities?: Array<LabelResult>;
  /**
   * Value passed in when the prediction call was made. Returned only if the sampleId request parameter is provided.
   */
  sampleId?: string;
};

export type TrainResponse = {
  /**
   * Algorithm used to create the model. Returned only when the modelType is image-detection.
   */
  algorithm?: string;
  /**
   * Date and time that the model was created.
   */
  createdAt?: string;
  /**
   * ID of the dataset trained to create the model.
   */
  datasetId: number;
  /**
   * Not available yet
   */
  datasetVersionId: number;
  /**
   * Number of epochs used during training.
   */
  epochs?: number;
  /**
   * Reason the dataset training failed. Returned only if the training status is FAILED.
   */
  failureMsg?: string;
  /**
   * Model language inherited from the dataset language. For image datasets, default is N/A. For text datasets, default is en_US.
   */
  language: string;
  /**
   * Learning rate used during training.
   */
  learningRate?: number;
  /**
   * ID of the model. Contains letters and numbers.
   */
  modelId: string;
  /**
   * Type of data from which the model was created.
   */
  modelType?: string;
  /**
   * Name of the model.
   */
  name: string;
  /**
   * Object returned; in this case, training.
   */
  object?: string;
  /**
   * How far the dataset training has progressed. Values are between 0�1.
   */
  progress: number;
  /**
   * Where the training job is in the queue. This field appears in the response only if the status is QUEUED.
   */
  queuePosition?: number;
  /**
   * Status of the model.
   */
  status: 'QUEUED' | 'RUNNING' | 'SUCCEEDED' | 'FAILED' | 'KILLED' | 'FAILED_WITH_RETRIES';
  /**
   * Training parameters passed into the request.
   */
  trainParams?: string;
  /**
   * Returns null when you train a dataset. Training statistics are returned when the status is SUCCEEDED or FAILED.
   */
  trainStats?: string;
  /**
   * Date and time that the model was last updated.
   */
  updatedAt?: string;
};

/**
 * JSON that contains parameters that specify how the model is created
 */
export type V2LanguageTrainParams = {
  /**
   * Lets you specify the ratio of data used to train the dataset and the data used to test the model.
   */
  trainSplitRatio?: number;
  /**
   * Lets you specify that feedback examples are included in the data to be trained to create the model.
   */
  withFeedback?: boolean;
  /**
   * Lets you specify that a global dataset is used in addition to the specified dataset to create the model.
   */
  withGlobalDatasetId?: number;
};

/**
 * JSON that contains parameters that specify how the model is created
 */
export type V2VisionTrainParams = {
  /**
   * Lets you specify the ratio of data used to train the dataset and the data used to test the model.
   */
  trainSplitRatio?: number;
  /**
   * Lets you specify that feedback examples are included in the data to be trained to create the model.
   */
  withFeedback?: boolean;
  /**
   * Lets you specify that a global dataset is used in addition to the specified dataset to create the model.
   */
  withGlobalDatasetId?: number;
};

export type GetApiUsagePlansV2Response = ApiUsageList;

export type GetApiUsagePlansV2Error = unknown;

export type ListDatasetsData = {
  query?: {
    /**
     * Number of datsets to return. Maximum valid value is 25. If you specify a number greater than 25, the call returns 25 datasets.
     */
    count?: string;
    /**
     * If true, returns all global datasets. Global datasets are public datasets that Salesforce provides.
     */
    global?: boolean;
    /**
     * Index of the dataset from which you want to start paging
     */
    offset?: string;
  };
};

export type ListDatasetsResponse = DatasetList;

export type ListDatasetsError = unknown;

export type UploadDatasetAsyncData = {
  body?: {
    /**
     * Path to the .csv, .tsv, or .json file on the local drive (FilePart).
     */
    data?: string;
    /**
     * Name of the dataset. Optional. If this parameter is omitted, the dataset name is derived from the file name.
     */
    name?: string;
    /**
     * URL of the .csv, .tsv, or .json file.
     */
    path?: string;
    /**
     * Type of dataset data.
     */
    type?: 'text-intent' | 'text-sentiment';
  };
};

export type UploadDatasetAsyncResponse = Dataset;

export type UploadDatasetAsyncError = unknown;

export type UploadDatasetSyncData = {
  body?: {
    /**
     * Path to the .csv, .tsv, or .json file on the local drive (FilePart).
     */
    data?: string;
    /**
     * Name of the dataset. Optional. If this parameter is omitted, the dataset name is derived from the file name.
     */
    name?: string;
    /**
     * URL of the .csv, .tsv, or .json file.
     */
    path?: string;
    /**
     * Type of dataset data.
     */
    type?: 'text-intent' | 'text-sentiment';
  };
};

export type UploadDatasetSyncResponse = Dataset;

export type UploadDatasetSyncError = unknown;

export type DeleteDatasetData = {
  path: {
    /**
     * Dataset Id
     */
    datasetId: string;
  };
};

export type DeleteDatasetResponse = DeletionResponse;

export type DeleteDatasetError = unknown;

export type GetDatasetData = {
  path: {
    /**
     * Dataset Id
     */
    datasetId: string;
  };
};

export type GetDatasetResponse = Dataset;

export type GetDatasetError = unknown;

export type GetExamplesData = {
  path: {
    /**
     * Dataset Id
     */
    datasetId: string;
  };
  query?: {
    /**
     * Number of examples to return.
     */
    count?: string;
    /**
     * Index of the example from which you want to start paging.
     */
    offset?: string;
    /**
     * return examples that were created in the dataset as feedback
     */
    source?: 'all' | 'feedback' | 'upload';
  };
};

export type GetExamplesResponse = ExampleList;

export type GetExamplesError = unknown;

export type GetTrainedModelsData = {
  path: {
    /**
     * Dataset Id
     */
    datasetId: string;
  };
  query?: {
    /**
     * Number of models to return.
     */
    count?: string;
    /**
     * Index of the model from which you want to start paging.
     */
    offset?: string;
  };
};

export type GetTrainedModelsResponse = ModelList;

export type GetTrainedModelsError = unknown;

export type UpdateDatasetAsyncData = {
  body?: {
    /**
     * Path to the .csv, .tsv, or .json file on a local drive.
     */
    data?: string;
    /**
     * URL of the .csv, .tsv, or .json file.
     */
    type?: string;
  };
  path: {
    /**
     * Dataset Id
     */
    datasetId: string;
  };
};

export type UpdateDatasetAsyncResponse = Dataset;

export type UpdateDatasetAsyncError = unknown;

export type GetData = {
  path: {
    /**
     * Deletion Id
     */
    id: string;
  };
};

export type GetResponse = DeletionResponse;

export type GetError = unknown;

export type GetExamplesByLabelData = {
  query?: {
    /**
     * Number of examples to return.
     */
    count?: string;
    /**
     * Label Id
     */
    labelId?: string;
    /**
     * Index of the example from which you want to start paging.
     */
    offset?: string;
  };
};

export type GetExamplesByLabelResponse = ExampleList;

export type GetExamplesByLabelError = unknown;

export type ProvideFeedbackData = {
  body?: {
    /**
     * Intent or sentiment string to add to the dataset.
     */
    document?: string;
    /**
     * Correct label for the example. Must be a label that exists in the dataset.
     */
    expectedLabel?: string;
    /**
     * ID of the model that misclassified the image. The feedback example is added to the dataset associated with this model.
     */
    modelId?: string;
    /**
     * Name of the example. Optional. Maximum length is 180 characters.
     */
    name?: string;
  };
};

export type ProvideFeedbackResponse = Example;

export type ProvideFeedbackError = unknown;

export type IntentMultipartData = {
  body?: IntentPredictRequest;
};

export type IntentMultipartResponse = IntentPredictResponse;

export type IntentMultipartError = PredictionErrorResponse;

export type DeleteModelData = {
  path: {
    /**
     * Model Id
     */
    modelId: string;
  };
};

export type DeleteModelResponse = DeletionResponse;

export type DeleteModelError = unknown;

export type GetTrainedModelMetricsData = {
  path: {
    /**
     * Model Id
     */
    modelId: string;
  };
};

export type GetTrainedModelMetricsResponse = Metrics;

export type GetTrainedModelMetricsError = unknown;

export type GetTrainedModelLearningCurveData = {
  path: {
    /**
     * Model Id
     */
    modelId: string;
  };
  query?: {
    /**
     * Number of epoch to return. Maximum valid value is 25.
     */
    count?: string;
    /**
     * Index of the epoch from which you want to start paging
     */
    offset?: string;
  };
};

export type GetTrainedModelLearningCurveResponse = LearningCurveList;

export type GetTrainedModelLearningCurveError = unknown;

export type RetrainData = {
  body?: {
    /**
     * Algorithm used for train
     */
    algorithm?: string;
    /**
     * Number of training iterations for the neural network. Optional.
     */
    epochs?: number;
    /**
     * N/A for intent or sentiment models.
     */
    learningRate?: number;
    /**
     * ID of the model to be updated from the training.
     */
    modelId?: string;
    trainParams?: V2LanguageTrainParams;
  };
};

export type RetrainResponse = TrainResponse;

export type RetrainError = unknown;

export type SentimentMultipartData = {
  body?: SentimentPredictRequest;
};

export type SentimentMultipartResponse = SentimentPredictResponse;

export type SentimentMultipartError = unknown;

export type TrainData = {
  body?: {
    /**
     * Algorithm used for train
     */
    algorithm?: string;
    /**
     * ID of the dataset to train.
     */
    datasetId?: number;
    /**
     * Number of training iterations for the neural network. Optional.
     */
    epochs?: number;
    /**
     * N/A for intent or sentiment models.
     */
    learningRate?: number;
    /**
     * Name of the model. Maximum length is 180 characters.
     */
    name?: string;
    trainParams?: V2LanguageTrainParams;
  };
};

export type TrainResponse2 = TrainResponse;

export type TrainError = unknown;

export type GetTrainStatusAndProgressData = {
  path: {
    /**
     * Model Id
     */
    modelId: string;
  };
};

export type GetTrainStatusAndProgressResponse = TrainResponse;

export type GetTrainStatusAndProgressError = unknown;

export type GenerateTokenV2Data = {
  body?: {
    /**
     * encrypted payload to identify yourself
     */
    assertion?: string;
    /**
     * specify the authentication method desired
     */
    grant_type?: 'urn:ietf:params:oauth:grant-type:jwt-bearer' | 'refresh_token';
    /**
     * The refresh token you created previously.
     */
    refresh_token?: string;
    /**
     * set to `offline` to generate a refresh token
     */
    scope?: string;
    /**
     * Number of seconds until the access token expires. Default is 60 seconds. Maximum value is 30 days
     */
    valid_for?: number;
  };
};

export type GenerateTokenV2Response = GenerateAccessTokenResponse;

export type GenerateTokenV2Error = unknown;

export type RevokeRefreshTokenV2Data = {
  path: {
    /**
     * the token to revoke
     */
    token: string;
  };
};

export type RevokeRefreshTokenV2Response = any;

export type RevokeRefreshTokenV2Error = unknown;

export type UpdateDatasetAsync1Data = {
  body?: {
    /**
     * Local .zip file to upload. The maximum .zip file size you can upload from a local drive is 50 MB.
     */
    data?: string;
    /**
     * ID of the model that misclassified the images. The feedback examples are added to the dataset associated with this model.
     */
    modelId?: string;
  };
};

export type UpdateDatasetAsync1Response = Dataset;

export type UpdateDatasetAsync1Error = unknown;

export type ListDatasets1Data = {
  query?: {
    /**
     * Number of datsets to return. Maximum valid value is 25. If you specify a number greater than 25, the call returns 25 datasets.
     */
    count?: string;
    /**
     * If true, returns all global datasets. Global datasets are public datasets that Salesforce provides.
     */
    global?: boolean;
    /**
     * Index of the dataset from which you want to start paging
     */
    offset?: string;
  };
};

export type ListDatasets1Response = DatasetList;

export type ListDatasets1Error = unknown;

export type CreateDatasetData = {
  body?: {
    /**
     * Optional comma-separated list of labels. If specified, creates the labels in the dataset. Maximum number of labels per dataset is 250.
     */
    labels?: string;
    /**
     * Name of the dataset. Maximum length is 180 characters.
     */
    name?: string;
    /**
     * Type of dataset data
     */
    type?: 'image' | 'image-multi-label';
  };
};

export type CreateDatasetResponse = Dataset;

export type CreateDatasetError = unknown;

export type UploadDatasetAsync1Data = {
  body?: {
    /**
     * Path to the .zip file on the local drive (FilePart).
     */
    data?: string;
    /**
     * Name of the dataset. Optional. If this parameter is omitted, the dataset name is derived from the .zip file name.
     */
    name?: string;
    /**
     * URL of the .zip file.
     */
    path?: string;
    /**
     * Type of dataset data.
     */
    type?: 'image' | 'image-detection' | 'image-multi-label';
  };
};

export type UploadDatasetAsync1Response = Dataset;

export type UploadDatasetAsync1Error = unknown;

export type UploadDatasetSync1Data = {
  body?: {
    /**
     * Path to the .zip file on the local drive (FilePart).
     */
    data?: string;
    /**
     * Name of the dataset. Optional. If this parameter is omitted, the dataset name is derived from the .zip file name.
     */
    name?: string;
    /**
     * URL of the .zip file.
     */
    path?: string;
    /**
     * Type of dataset data.
     */
    type?: 'image' | 'image-detection' | 'image-multi-label';
  };
};

export type UploadDatasetSync1Response = Dataset;

export type UploadDatasetSync1Error = unknown;

export type DeleteDataset1Data = {
  path: {
    /**
     * Dataset Id
     */
    datasetId: string;
  };
};

export type DeleteDataset1Response = DeletionResponse;

export type DeleteDataset1Error = unknown;

export type GetDataset1Data = {
  path: {
    /**
     * Dataset Id
     */
    datasetId: string;
  };
};

export type GetDataset1Response = Dataset;

export type GetDataset1Error = unknown;

export type GetExamples1Data = {
  path: {
    /**
     * Dataset Id
     */
    datasetId: string;
  };
  query?: {
    /**
     * Number of examples to return.
     */
    count?: string;
    /**
     * Index of the example from which you want to start paging.
     */
    offset?: string;
    /**
     * return examples that were created in the dataset as feedback
     */
    source?: 'all' | 'feedback' | 'upload';
  };
};

export type GetExamples1Response = ExampleList;

export type GetExamples1Error = unknown;

export type AddExampleData = {
  body?: {
    /**
     * Location of the local image file to upload.
     */
    data?: string;
    /**
     * ID of the label to add to the example.
     */
    labelId?: number;
    /**
     * Name of the example. Maximum length is 180 characters.
     */
    name?: string;
  };
  path: {
    /**
     * Dataset Id
     */
    datasetId: string;
  };
};

export type AddExampleResponse = Example;

export type AddExampleError = unknown;

export type GetTrainedModels1Data = {
  path: {
    /**
     * Dataset Id
     */
    datasetId: string;
  };
  query?: {
    /**
     * Number of models to return.
     */
    count?: string;
    /**
     * Index of the model from which you want to start paging.
     */
    offset?: string;
  };
};

export type GetTrainedModels1Response = ModelList;

export type GetTrainedModels1Error = unknown;

export type UpdateDatasetAsync2Data = {
  body?: {
    /**
     * Location of the local image file to upload.
     */
    data?: string;
    /**
     * URL of the .zip file.
     */
    path?: string;
  };
  path: {
    /**
     * Dataset Id
     */
    datasetId: string;
  };
};

export type UpdateDatasetAsync2Response = Dataset;

export type UpdateDatasetAsync2Error = unknown;

export type Get1Data = {
  path: {
    /**
     * Deletion Id
     */
    id: string;
  };
};

export type Get1Response = DeletionResponse;

export type Get1Error = unknown;

export type DetectMultipartData = {
  body?: ObjectDetectionRequest;
};

export type DetectMultipartResponse = ObjectDetectionResponse;

export type DetectMultipartError = unknown;

export type GetExamplesByLabel1Data = {
  query?: {
    /**
     * Number of examples to return.
     */
    count?: string;
    /**
     * Label Id
     */
    labelId?: string;
    /**
     * Index of the example from which you want to start paging.
     */
    offset?: string;
  };
};

export type GetExamplesByLabel1Response = ExampleList;

export type GetExamplesByLabel1Error = unknown;

export type ProvideFeedback1Data = {
  body?: {
    /**
     * Local image file to upload.
     */
    data?: string;
    /**
     * Correct label for the example. Must be a label that exists in the dataset.
     */
    expectedLabel?: string;
    /**
     * ID of the model that misclassified the image. The feedback example is added to the dataset associated with this model.
     */
    modelId?: string;
    /**
     * Name of the example. Optional. Maximum length is 180 characters.
     */
    name?: string;
  };
};

export type ProvideFeedback1Response = Example;

export type ProvideFeedback1Error = unknown;

export type DeleteModel1Data = {
  path: {
    modelId: string;
  };
};

export type DeleteModel1Response = DeletionResponse;

export type DeleteModel1Error = unknown;

export type GetTrainedModelMetrics1Data = {
  path: {
    modelId: string;
  };
};

export type GetTrainedModelMetrics1Response = Metrics;

export type GetTrainedModelMetrics1Error = unknown;

export type GetTrainedModelLearningCurve1Data = {
  path: {
    modelId: string;
  };
  query?: {
    /**
     * Number of epoch to return. Maximum valid value is 25.
     */
    count?: string;
    /**
     * Index of the epoch from which you want to start paging
     */
    offset?: string;
  };
};

export type GetTrainedModelLearningCurve1Response = LearningCurveList;

export type GetTrainedModelLearningCurve1Error = unknown;

export type OcrMultipartData = {
  body?: {
    /**
     * ID of the model that makes the prediction. Valid values are OCRModel and tabulatev2.
     */
    modelId?: string;
    /**
     * Binary content of image file uploaded as multipart/form-data. Optional.
     */
    sampleContent?: Blob | File;
    /**
     * String that you can pass in to tag the prediction. Optional. Can be any value, and is returned in the response.
     */
    sampleId?: string;
    /**
     * URL of the image file. Use this parameter when sending in a file from a web location. Optional.
     */
    sampleLocation?: string;
    /**
     * Optional. Designates the type of data in the image. Default is text. Valid values: contact, table, and text.
     */
    task?: string;
  };
};

export type OcrMultipartResponse = OCRPredictResponse;

export type OcrMultipartError = unknown;

export type PredictMultipartData = {
  body?: ImageClassificationRequest;
};

export type PredictMultipartResponse = ImageClassificationResponse;

export type PredictMultipartError = unknown;

export type Retrain1Data = {
  body?: {
    /**
     * Specifies the algorithm used to train the dataset. Optional. Use this parameter only when training a dataset with a type of image-detection. Valid values are object-detection-v1 and retail-execution.
     */
    algorithm?: string;
    /**
     * Number of training iterations for the neural network. Optional.
     */
    epochs?: number;
    /**
     * Specifies how much the gradient affects the optimization of the model at each time step. Optional.
     */
    learningRate?: number;
    /**
     * ID of the model to be updated from the training.
     */
    modelId?: string;
    trainParams?: V2VisionTrainParams;
  };
};

export type Retrain1Response = TrainResponse;

export type Retrain1Error = unknown;

export type Train1Data = {
  body?: {
    /**
     * Specifies the algorithm used to train the dataset. Optional. Use this parameter only when training a dataset with a type of image-detection. Valid values are object-detection-v1 and retail-execution.
     */
    algorithm?: string;
    /**
     * ID of the dataset to train.
     */
    datasetId?: number;
    /**
     * Number of training iterations for the neural network. Optional.
     */
    epochs?: number;
    /**
     * Specifies how much the gradient affects the optimization of the model at each time step. Optional.
     */
    learningRate?: number;
    /**
     * Name of the model. Maximum length is 180 characters.
     */
    name?: string;
    trainParams?: V2VisionTrainParams;
  };
};

export type Train1Response = TrainResponse;

export type Train1Error = unknown;

export type GetTrainStatusAndProgress1Data = {
  path: {
    modelId: string;
  };
};

export type GetTrainStatusAndProgress1Response = TrainResponse;

export type GetTrainStatusAndProgress1Error = unknown;
