// This file is auto-generated by @hey-api/openapi-ts
import {
  createClient,
  createConfig,
  type Options,
  formDataBodySerializer,
  urlSearchParamsBodySerializer,
} from '@hey-api/client-fetch';

import type {
  GetApiUsagePlansV2Error,
  GetApiUsagePlansV2Response,
  ListDatasetsData,
  ListDatasetsError,
  ListDatasetsResponse,
  UploadDatasetAsyncData,
  UploadDatasetAsyncError,
  UploadDatasetAsyncResponse,
  UploadDatasetSyncData,
  UploadDatasetSyncError,
  UploadDatasetSyncResponse,
  DeleteDatasetData,
  DeleteDatasetError,
  DeleteDatasetResponse,
  GetDatasetData,
  GetDatasetError,
  GetDatasetResponse,
  GetExamplesData,
  GetExamplesError,
  GetExamplesResponse,
  GetTrainedModelsData,
  GetTrainedModelsError,
  GetTrainedModelsResponse,
  UpdateDatasetAsyncData,
  UpdateDatasetAsyncError,
  UpdateDatasetAsyncResponse,
  GetData,
  GetError,
  GetResponse,
  GetExamplesByLabelData,
  GetExamplesByLabelError,
  GetExamplesByLabelResponse,
  ProvideFeedbackData,
  ProvideFeedbackError,
  ProvideFeedbackResponse,
  IntentMultipartData,
  IntentMultipartError,
  IntentMultipartResponse,
  DeleteModelData,
  DeleteModelError,
  DeleteModelResponse,
  GetTrainedModelMetricsData,
  GetTrainedModelMetricsError,
  GetTrainedModelMetricsResponse,
  GetTrainedModelLearningCurveData,
  GetTrainedModelLearningCurveError,
  GetTrainedModelLearningCurveResponse,
  RetrainData,
  RetrainError,
  RetrainResponse,
  SentimentMultipartData,
  SentimentMultipartError,
  SentimentMultipartResponse,
  TrainData,
  TrainError,
  TrainResponse2,
  GetTrainStatusAndProgressData,
  GetTrainStatusAndProgressError,
  GetTrainStatusAndProgressResponse,
  GenerateTokenV2Data,
  GenerateTokenV2Error,
  GenerateTokenV2Response,
  RevokeRefreshTokenV2Data,
  RevokeRefreshTokenV2Error,
  RevokeRefreshTokenV2Response,
  UpdateDatasetAsync1Data,
  UpdateDatasetAsync1Error,
  UpdateDatasetAsync1Response,
  ListDatasets1Data,
  ListDatasets1Error,
  ListDatasets1Response,
  CreateDatasetData,
  CreateDatasetError,
  CreateDatasetResponse,
  UploadDatasetAsync1Data,
  UploadDatasetAsync1Error,
  UploadDatasetAsync1Response,
  UploadDatasetSync1Data,
  UploadDatasetSync1Error,
  UploadDatasetSync1Response,
  DeleteDataset1Data,
  DeleteDataset1Error,
  DeleteDataset1Response,
  GetDataset1Data,
  GetDataset1Error,
  GetDataset1Response,
  GetExamples1Data,
  GetExamples1Error,
  GetExamples1Response,
  AddExampleData,
  AddExampleError,
  AddExampleResponse,
  GetTrainedModels1Data,
  GetTrainedModels1Error,
  GetTrainedModels1Response,
  UpdateDatasetAsync2Data,
  UpdateDatasetAsync2Error,
  UpdateDatasetAsync2Response,
  Get1Data,
  Get1Error,
  Get1Response,
  DetectMultipartData,
  DetectMultipartError,
  DetectMultipartResponse,
  GetExamplesByLabel1Data,
  GetExamplesByLabel1Error,
  GetExamplesByLabel1Response,
  ProvideFeedback1Data,
  ProvideFeedback1Error,
  ProvideFeedback1Response,
  DeleteModel1Data,
  DeleteModel1Error,
  DeleteModel1Response,
  GetTrainedModelMetrics1Data,
  GetTrainedModelMetrics1Error,
  GetTrainedModelMetrics1Response,
  GetTrainedModelLearningCurve1Data,
  GetTrainedModelLearningCurve1Error,
  GetTrainedModelLearningCurve1Response,
  OcrMultipartData,
  OcrMultipartError,
  OcrMultipartResponse,
  PredictMultipartData,
  PredictMultipartError,
  PredictMultipartResponse,
  Retrain1Data,
  Retrain1Error,
  Retrain1Response,
  Train1Data,
  Train1Error,
  Train1Response,
  GetTrainStatusAndProgress1Data,
  GetTrainStatusAndProgress1Error,
  GetTrainStatusAndProgress1Response,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Get API Isage
 * Returns prediction usage on a monthly basis for the current calendar month and future months. Each apiusage object in the response corresponds to a calendar month in your plan.
 */
export const getApiUsagePlansV2 = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetApiUsagePlansV2Response, GetApiUsagePlansV2Error, ThrowOnError>({
    ...options,
    url: '/v2/apiusage',
  });
};

/**
 * Get All Datasets
 * Returns a list of datasets and their labels that were created by the current user. The response is sorted by dataset ID.
 */
export const listDatasets = <ThrowOnError extends boolean = false>(
  options?: Options<ListDatasetsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListDatasetsResponse, ListDatasetsError, ThrowOnError>({
    ...options,
    url: '/v2/language/datasets',
  });
};

/**
 * Create a Dataset From a File Asynchronously
 * Creates a dataset, labels, and examples from the specified .csv, .tsv, or .json file. The call returns immediately and continues to upload data in the background.
 */
export const uploadDatasetAsync = <ThrowOnError extends boolean = false>(
  options?: Options<UploadDatasetAsyncData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UploadDatasetAsyncResponse, UploadDatasetAsyncError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/language/datasets/upload',
  });
};

/**
 * Create a Dataset From a File Synchronously
 * Creates a dataset, labels, and examples from the specified .csv, .tsv, or .json file. The call returns after the dataset is created and all of the data is uploaded.
 */
export const uploadDatasetSync = <ThrowOnError extends boolean = false>(
  options?: Options<UploadDatasetSyncData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UploadDatasetSyncResponse, UploadDatasetSyncError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/language/datasets/upload/sync',
  });
};

/**
 * Delete a Dataset
 * Deletes the specified dataset and associated labels and examples.
 */
export const deleteDataset = <ThrowOnError extends boolean = false>(
  options: Options<DeleteDatasetData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteDatasetResponse, DeleteDatasetError, ThrowOnError>({
    ...options,
    url: '/v2/language/datasets/{datasetId}',
  });
};

/**
 * Get a Dataset
 * Returns a single dataset.
 */
export const getDataset = <ThrowOnError extends boolean = false>(options: Options<GetDatasetData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetDatasetResponse, GetDatasetError, ThrowOnError>({
    ...options,
    url: '/v2/language/datasets/{datasetId}',
  });
};

/**
 * Get All Examples
 * Returns all the examples for the specified dataset,
 */
export const getExamples = <ThrowOnError extends boolean = false>(options: Options<GetExamplesData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetExamplesResponse, GetExamplesError, ThrowOnError>({
    ...options,
    url: '/v2/language/datasets/{datasetId}/examples',
  });
};

/**
 * Get All Models
 * Returns all models for the specified dataset.
 */
export const getTrainedModels = <ThrowOnError extends boolean = false>(
  options: Options<GetTrainedModelsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTrainedModelsResponse, GetTrainedModelsError, ThrowOnError>({
    ...options,
    url: '/v2/language/datasets/{datasetId}/models',
  });
};

/**
 * Create Examples From a File
 * Adds examples from a .csv, .tsv, or .json file to a dataset.
 */
export const updateDatasetAsync = <ThrowOnError extends boolean = false>(
  options: Options<UpdateDatasetAsyncData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateDatasetAsyncResponse, UpdateDatasetAsyncError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/language/datasets/{datasetId}/upload',
  });
};

/**
 * Get Deletion Status
 * Returns the status of a language dataset or model deletion. When you delete a dataset or model, the deletion may not occur immediately. Use this call to find out when the deletion is complete.
 */
export const get = <ThrowOnError extends boolean = false>(options: Options<GetData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetResponse, GetError, ThrowOnError>({
    ...options,
    url: '/v2/language/deletion/{id}',
  });
};

/**
 * Get All Examples for Label
 * Returns all the examples for the specified label. Returns both uploaded examples and feedback examples.
 */
export const getExamplesByLabel = <ThrowOnError extends boolean = false>(
  options?: Options<GetExamplesByLabelData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetExamplesByLabelResponse, GetExamplesByLabelError, ThrowOnError>({
    ...options,
    url: '/v2/language/examples',
  });
};

/**
 * Create a Feedback Example
 * Adds a feedback example to the dataset associated with the specified model.
 */
export const provideFeedback = <ThrowOnError extends boolean = false>(
  options?: Options<ProvideFeedbackData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ProvideFeedbackResponse, ProvideFeedbackError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/language/feedback',
  });
};

/**
 * Prediction for Intent
 * Returns an intent prediction for the given string.
 */
export const intentMultipart = <ThrowOnError extends boolean = false>(
  options?: Options<IntentMultipartData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<IntentMultipartResponse, IntentMultipartError, ThrowOnError>({
    ...options,
    url: '/v2/language/intent',
  });
};

/**
 * Delete a Model
 * Deletes the specified model.
 */
export const deleteModel = <ThrowOnError extends boolean = false>(options: Options<DeleteModelData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteModelResponse, DeleteModelError, ThrowOnError>({
    ...options,
    url: '/v2/language/models/{modelId}',
  });
};

/**
 * Get Model Metrics
 * Returns the metrics for a model
 */
export const getTrainedModelMetrics = <ThrowOnError extends boolean = false>(
  options: Options<GetTrainedModelMetricsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTrainedModelMetricsResponse, GetTrainedModelMetricsError, ThrowOnError>({
    ...options,
    url: '/v2/language/models/{modelId}',
  });
};

/**
 * Get Model Learning Curve
 * Returns the metrics for each epoch in a model.
 */
export const getTrainedModelLearningCurve = <ThrowOnError extends boolean = false>(
  options: Options<GetTrainedModelLearningCurveData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetTrainedModelLearningCurveResponse,
    GetTrainedModelLearningCurveError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/language/models/{modelId}/lc',
  });
};

/**
 * Retrain a Dataset
 * Retrains a dataset and updates a model. Use this API call when you want to update a model and keep the model ID instead of creating a new model.
 */
export const retrain = <ThrowOnError extends boolean = false>(options?: Options<RetrainData, ThrowOnError>) => {
  return (options?.client ?? client).post<RetrainResponse, RetrainError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/language/retrain',
  });
};

/**
 * Prediction for Sentiment
 * Returns a sentiment prediction for the given string.
 */
export const sentimentMultipart = <ThrowOnError extends boolean = false>(
  options?: Options<SentimentMultipartData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<SentimentMultipartResponse, SentimentMultipartError, ThrowOnError>({
    ...options,
    url: '/v2/language/sentiment',
  });
};

/**
 * Train a Dataset
 * Trains a dataset and creates a model.
 */
export const train = <ThrowOnError extends boolean = false>(options?: Options<TrainData, ThrowOnError>) => {
  return (options?.client ?? client).post<TrainResponse2, TrainError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/language/train',
  });
};

/**
 * Get Training Status
 * Returns the status of a model's training process. Use the progress field to determine how far the training has progressed. When training completes successfully, the status is SUCCEEDED and the progress is 1.
 */
export const getTrainStatusAndProgress = <ThrowOnError extends boolean = false>(
  options: Options<GetTrainStatusAndProgressData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetTrainStatusAndProgressResponse,
    GetTrainStatusAndProgressError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/language/train/{modelId}',
  });
};

/**
 * Generate an OAuth Token
 * Returns an OAuth access token or a refresh token. You must pass a valid access token in the header of each API call.
 */
export const generateTokenV2 = <ThrowOnError extends boolean = false>(
  options?: Options<GenerateTokenV2Data, ThrowOnError>,
) => {
  return (options?.client ?? client).post<GenerateTokenV2Response, GenerateTokenV2Error, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/v2/oauth2/token',
  });
};

/**
 * Delete a Refresh Token
 */
export const revokeRefreshTokenV2 = <ThrowOnError extends boolean = false>(
  options: Options<RevokeRefreshTokenV2Data, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<RevokeRefreshTokenV2Response, RevokeRefreshTokenV2Error, ThrowOnError>({
    ...options,
    url: '/v2/oauth2/tokens/{token}',
  });
};

/**
 * Create Feedback Examples From a Zip File
 * Adds feedback examples to the dataset associated with the specified object detection model.
 */
export const updateDatasetAsync1 = <ThrowOnError extends boolean = false>(
  options?: Options<UpdateDatasetAsync1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateDatasetAsync1Response, UpdateDatasetAsync1Error, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/vision/bulkfeedback',
  });
};

/**
 * Get All Datasets
 * Returns a list of datasets and their labels that were created by the current user. The response is sorted by dataset ID.
 */
export const listDatasets1 = <ThrowOnError extends boolean = false>(
  options?: Options<ListDatasets1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListDatasets1Response, ListDatasets1Error, ThrowOnError>({
    ...options,
    url: '/v2/vision/datasets',
  });
};

/**
 * Create a Dataset
 * Creates a dataset and labels, if they're specified.
 */
export const createDataset = <ThrowOnError extends boolean = false>(
  options?: Options<CreateDatasetData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateDatasetResponse, CreateDatasetError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/vision/datasets',
  });
};

/**
 * Create a Dataset From a Zip File Asynchronously
 * Creates a dataset, labels, and examples from the specified .zip file. The call returns immediately and continues to upload the images in the background.
 */
export const uploadDatasetAsync1 = <ThrowOnError extends boolean = false>(
  options?: Options<UploadDatasetAsync1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UploadDatasetAsync1Response, UploadDatasetAsync1Error, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/vision/datasets/upload',
  });
};

/**
 * Create a Dataset From a Zip File Synchronously
 * Creates a dataset, labels, and examples from the specified .zip file. The call returns after the dataset is created and all of the images are uploaded.
 */
export const uploadDatasetSync1 = <ThrowOnError extends boolean = false>(
  options?: Options<UploadDatasetSync1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UploadDatasetSync1Response, UploadDatasetSync1Error, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/vision/datasets/upload/sync',
  });
};

/**
 * Delete a Dataset
 * Deletes the specified dataset and associated labels and examples.
 */
export const deleteDataset1 = <ThrowOnError extends boolean = false>(
  options: Options<DeleteDataset1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteDataset1Response, DeleteDataset1Error, ThrowOnError>({
    ...options,
    url: '/v2/vision/datasets/{datasetId}',
  });
};

/**
 * Get a Dataset
 * Returns a single dataset.
 */
export const getDataset1 = <ThrowOnError extends boolean = false>(options: Options<GetDataset1Data, ThrowOnError>) => {
  return (options?.client ?? client).get<GetDataset1Response, GetDataset1Error, ThrowOnError>({
    ...options,
    url: '/v2/vision/datasets/{datasetId}',
  });
};

/**
 * Get All Examples
 * Returns all the examples for the specified dataset. By default, returns examples created by uploading them from a .zip file.
 */
export const getExamples1 = <ThrowOnError extends boolean = false>(
  options: Options<GetExamples1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetExamples1Response, GetExamples1Error, ThrowOnError>({
    ...options,
    url: '/v2/vision/datasets/{datasetId}/examples',
  });
};

/**
 * Create an Example
 * Adds an example with the specified label to a dataset.
 */
export const addExample = <ThrowOnError extends boolean = false>(options: Options<AddExampleData, ThrowOnError>) => {
  return (options?.client ?? client).post<AddExampleResponse, AddExampleError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/vision/datasets/{datasetId}/examples',
  });
};

/**
 * Get All Models
 * Returns all models for the specified dataset.
 */
export const getTrainedModels1 = <ThrowOnError extends boolean = false>(
  options: Options<GetTrainedModels1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTrainedModels1Response, GetTrainedModels1Error, ThrowOnError>({
    ...options,
    url: '/v2/vision/datasets/{datasetId}/models',
  });
};

/**
 * Create Examples From a Zip File
 * Adds examples from a .zip file to a dataset. You can use this call only with a dataset that was created from a .zip file.
 */
export const updateDatasetAsync2 = <ThrowOnError extends boolean = false>(
  options: Options<UpdateDatasetAsync2Data, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateDatasetAsync2Response, UpdateDatasetAsync2Error, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/vision/datasets/{datasetId}/upload',
  });
};

/**
 * Get Deletion Status
 * Returns the status of an image dataset or model deletion. When you delete a dataset or model, the deletion may not occur immediately. Use this call to find out when the deletion is complete.
 */
export const get1 = <ThrowOnError extends boolean = false>(options: Options<Get1Data, ThrowOnError>) => {
  return (options?.client ?? client).get<Get1Response, Get1Error, ThrowOnError>({
    ...options,
    url: '/v2/vision/deletion/{id}',
  });
};

/**
 * Detection with Image File
 * Returns labels, probabilities, and bounding box coordinates for items detected in the specified local image file.
 */
export const detectMultipart = <ThrowOnError extends boolean = false>(
  options?: Options<DetectMultipartData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DetectMultipartResponse, DetectMultipartError, ThrowOnError>({
    ...options,
    url: '/v2/vision/detect',
  });
};

/**
 * Get All Examples for Label
 * Returns all the examples for the specified label. Returns both uploaded examples and feedback examples.
 */
export const getExamplesByLabel1 = <ThrowOnError extends boolean = false>(
  options?: Options<GetExamplesByLabel1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetExamplesByLabel1Response, GetExamplesByLabel1Error, ThrowOnError>({
    ...options,
    url: '/v2/vision/examples',
  });
};

/**
 * Create a Feedback Example
 * Adds a feedback example to the dataset associated with the specified model.
 */
export const provideFeedback1 = <ThrowOnError extends boolean = false>(
  options?: Options<ProvideFeedback1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ProvideFeedback1Response, ProvideFeedback1Error, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/vision/feedback',
  });
};

/**
 * Delete a Model
 * Deletes the specified model.
 */
export const deleteModel1 = <ThrowOnError extends boolean = false>(
  options: Options<DeleteModel1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteModel1Response, DeleteModel1Error, ThrowOnError>({
    ...options,
    url: '/v2/vision/models/{modelId}',
  });
};

/**
 * Get Model Metrics
 * Returns the metrics for a model
 */
export const getTrainedModelMetrics1 = <ThrowOnError extends boolean = false>(
  options: Options<GetTrainedModelMetrics1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTrainedModelMetrics1Response, GetTrainedModelMetrics1Error, ThrowOnError>({
    ...options,
    url: '/v2/vision/models/{modelId}',
  });
};

/**
 * Get Model Learning Curve
 * Returns the metrics for each epoch in a model.
 */
export const getTrainedModelLearningCurve1 = <ThrowOnError extends boolean = false>(
  options: Options<GetTrainedModelLearningCurve1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetTrainedModelLearningCurve1Response,
    GetTrainedModelLearningCurve1Error,
    ThrowOnError
  >({
    ...options,
    url: '/v2/vision/models/{modelId}/lc',
  });
};

/**
 * Detect Text
 * Returns a prediction from an OCR model for the specified image URL or local image file.
 */
export const ocrMultipart = <ThrowOnError extends boolean = false>(
  options?: Options<OcrMultipartData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<OcrMultipartResponse, OcrMultipartError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/vision/ocr',
  });
};

/**
 * Make Prediction
 * Returns a prediction from an image or multi-label model for the specified image.
 */
export const predictMultipart = <ThrowOnError extends boolean = false>(
  options?: Options<PredictMultipartData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PredictMultipartResponse, PredictMultipartError, ThrowOnError>({
    ...options,
    url: '/v2/vision/predict',
  });
};

/**
 * Retrain a Dataset
 * Retrains a dataset and updates a model. Use this API call when you want to update a model and keep the model ID instead of creating a new model.
 */
export const retrain1 = <ThrowOnError extends boolean = false>(options?: Options<Retrain1Data, ThrowOnError>) => {
  return (options?.client ?? client).post<Retrain1Response, Retrain1Error, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/vision/retrain',
  });
};

/**
 * Train a Dataset
 * Trains a dataset and creates a model.
 */
export const train1 = <ThrowOnError extends boolean = false>(options?: Options<Train1Data, ThrowOnError>) => {
  return (options?.client ?? client).post<Train1Response, Train1Error, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v2/vision/train',
  });
};

/**
 * Get Training Status
 * Returns the status of a model's training process. Use the progress field to determine how far the training has progressed. When training completes successfully, the status is SUCCEEDED and the progress is 1.
 */
export const getTrainStatusAndProgress1 = <ThrowOnError extends boolean = false>(
  options: Options<GetTrainStatusAndProgress1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetTrainStatusAndProgress1Response,
    GetTrainStatusAndProgress1Error,
    ThrowOnError
  >({
    ...options,
    url: '/v2/vision/train/{modelId}',
  });
};
