// @ts-nocheck
import { GraphQLClient, RequestOptions } from 'graphql-request';
import { gql } from 'graphql-request';

export type Maybe<T> = T | null;
export type InputMaybe<T> = Maybe<T>;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
export type MakeEmpty<T extends { [key: string]: unknown }, K extends keyof T> = { [_ in K]?: never };
export type Incremental<T> = T | { [P in keyof T]?: P extends ' $fragmentName' | '__typename' ? T[P] : never };
type GraphQLClientRequestHeaders = RequestOptions['requestHeaders'];
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: { input: string; output: string };
  String: { input: string; output: string };
  Boolean: { input: boolean; output: boolean };
  Int: { input: number; output: number };
  Float: { input: number; output: number };
  BigInt: { input: any; output: any };
  Date: { input: any; output: any };
  DateTime: { input: any; output: any };
  Html: { input: any; output: any };
  Json: { input: any; output: any };
  Url: { input: any; output: any };
};

/** An action item attached to a video */
export type ActionItem = Node & {
  __typename?: 'ActionItem';
  /** Identifies the date and time when the object was created. */
  createdAt: Scalars['DateTime']['output'];
  /** The global ID for the action item. */
  id: Scalars['ID']['output'];
  /** Identifies the date and time when the object was last updated. */
  updatedAt: Scalars['DateTime']['output'];
};

/** An entity, such as a user, who has taken an action on a channel. */
export type Actor = {
  /** A URL for the actor's uploaded avatar image, if present. */
  avatarUrl?: Maybe<Scalars['Url']['output']>;
  /** The name to display when representing this actor. */
  displayName: Scalars['String']['output'];
  /** The ID for the underlying concrete object. */
  id: Scalars['ID']['output'];
};

/** Autogenerated input type of AddCommentToHighlight */
export type AddCommentToHighlightInput = {
  /** The text content of the comment in HTML format. */
  body: Scalars['String']['input'];
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID of the highlight this is a reply to. */
  highlightId: Scalars['ID']['input'];
};

/** Autogenerated return type of AddCommentToHighlight. */
export type AddCommentToHighlightPayload = {
  __typename?: 'AddCommentToHighlightPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The comment that was created. */
  comment?: Maybe<Comment>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who created the comment. */
  viewer: Viewer;
};

/** Autogenerated input type of AddCommentToVideo */
export type AddCommentToVideoInput = {
  /** The text content of the comment in HTML format. */
  body: Scalars['String']['input'];
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The timestamp of video where this comment ends as an offset from zero in milliseconds. (Ignored when a parent comment is given.) */
  endTimestamp?: InputMaybe<Scalars['Int']['input']>;
  /** The ID of the comment this is a reply to. If omitted, this will create a new comment thread. */
  parentCommentId?: InputMaybe<Scalars['ID']['input']>;
  /** The timestamp of video where this comment starts as an offset from zero in milliseconds. (Ignored when a parent comment is given.) */
  timestamp?: InputMaybe<Scalars['Int']['input']>;
  /** The ID value of the video to comment on. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of AddCommentToVideo. */
export type AddCommentToVideoPayload = {
  __typename?: 'AddCommentToVideoPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The comment that was created. */
  comment?: Maybe<Comment>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who created the comment. */
  viewer: Viewer;
};

/** Autogenerated input type of AddFavoriteCollection */
export type AddFavoriteCollectionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the collection to favorite. */
  collectionId: Scalars['ID']['input'];
};

/** Autogenerated return type of AddFavoriteCollection. */
export type AddFavoriteCollectionPayload = {
  __typename?: 'AddFavoriteCollectionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The collection that was favorited. */
  collection?: Maybe<Collection>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who favorited the collection. */
  viewer: Viewer;
};

/** Autogenerated input type of AddHighlightToVideo */
export type AddHighlightToVideoInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The timestamp of video where this highlight ends as an offset from zero in milliseconds. */
  endTimestamp: Scalars['Int']['input'];
  /** The timestamp of video where this highlight starts as an offset from zero in milliseconds. */
  timestamp: Scalars['Int']['input'];
  /** The title for the highlight. */
  title?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the video to add the highlight to. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of AddHighlightToVideo. */
export type AddHighlightToVideoPayload = {
  __typename?: 'AddHighlightToVideoPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The highlight that was created. */
  highlight?: Maybe<Highlight>;
  /** The viewer who created the highlight. */
  viewer: Viewer;
};

/** Autogenerated input type of AddToQueue */
export type AddToQueueInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the video. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of AddToQueue. */
export type AddToQueuePayload = {
  __typename?: 'AddToQueuePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The video that was added to the queue. */
  video?: Maybe<Video>;
  /** The viewer who added a video to their queue. */
  viewer: Viewer;
};

/** Autogenerated input type of AddToWatchlist */
export type AddToWatchlistInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the video. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of AddToWatchlist. */
export type AddToWatchlistPayload = {
  __typename?: 'AddToWatchlistPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The video that was added to a watchlist. */
  video?: Maybe<Video>;
  /** The viewer who added a video to their watchlist. */
  viewer: Viewer;
};

/** Autogenerated input type of AddUsersToVideo */
export type AddUsersToVideoInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A list of users ids. */
  userIds: Array<Scalars['ID']['input']>;
  /** The id of the video. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of AddUsersToVideo. */
export type AddUsersToVideoPayload = {
  __typename?: 'AddUsersToVideoPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The updated video. */
  video?: Maybe<Video>;
  /** The authenticated viewer. */
  viewer: Viewer;
};

/** Autogenerated input type of AddVideoToCollections */
export type AddVideoToCollectionsInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A list of collection ids. */
  collectionIds: Array<Scalars['ID']['input']>;
  /** The id of the video to tag users on. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of AddVideoToCollections. */
export type AddVideoToCollectionsPayload = {
  __typename?: 'AddVideoToCollectionsPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The updated video. */
  video?: Maybe<Video>;
  /** The authenticated viewer. */
  viewer: Viewer;
};

export enum AnalyticsTimeframe {
  /** Analytics from all time. */
  All = 'ALL',
  /** Analytics from the past month. */
  Month = 'MONTH',
  /** Analytics from the past year. */
  Year = 'YEAR',
}

/** Your channel of videos and collections on Rewatch. */
export type Channel = {
  __typename?: 'Channel';
  /** All collections on this channel that are visible to the current viewer. */
  collections?: Maybe<CollectionConnection>;
  /** Collections on this channel that are contributable by the current viewer. */
  contributableCollections?: Maybe<CollectionConnection>;
  /** Identifies the date and time when the object was created. */
  createdAt: Scalars['DateTime']['output'];
  /** A short description of the channel. */
  description?: Maybe<Scalars['String']['output']>;
  /** The groups from this channel. */
  groups: GroupConnection;
  /** The URL for the channel's header image. */
  headerImageUrl?: Maybe<Scalars['Url']['output']>;
  /** The URL for the channel's logo. */
  logoUrl?: Maybe<Scalars['Url']['output']>;
  /** The channel's name. */
  name: Scalars['String']['output'];
  /** The pinned collections on this channel that are visible to the current viewer. */
  pinnedCollections?: Maybe<CollectionConnection>;
  /** The pinned videos from this channel that are visible to the current viewer. */
  pinnedVideos?: Maybe<VideoConnection>;
  /** All public videos from this channel newest to oldest. */
  publicVideos?: Maybe<VideoConnection>;
  /** The recent highlights from this channel */
  recentHighlights?: Maybe<HighlightConnection>;
  /** The channel search results for a query. */
  search?: Maybe<ChannelSearchConnection>;
  /** This feature is in private beta. Returns the Slack Block Kit JSON data needed to create Slack video embeds for a list of Rewatch video URLs. See https://api.slack.com/reference/block-kit/blocks#video. */
  slackVideoEmbedBlocks?: Maybe<Array<Maybe<Scalars['Json']['output']>>>;
  /** The URL subdomain for viewing the channel on https://rewatch.com. */
  subdomain: Scalars['String']['output'];
  /** A list of tags that have been created on this channel ranked by tagging count. */
  tags?: Maybe<TagConnection>;
  /** The top-level collections on this channel that are visible to the current viewer. */
  topLevelCollections?: Maybe<CollectionConnection>;
  /** Identifies the date and time when the object was last updated. */
  updatedAt: Scalars['DateTime']['output'];
  /** The URL for the channel on Rewatch. */
  url: Scalars['Url']['output'];
  /** A user from this channel. */
  user?: Maybe<User>;
  /** The users from this channel. */
  users: UserConnection;
  /** The videos from this channel that are visible to the current viewer. */
  videos?: Maybe<VideoConnection>;
  /** The configured webhooks on this channel. Note that only channel admins can see or alter webhooks. */
  webhooks?: Maybe<WebhookConnection>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelCollectionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['ID']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelContributableCollectionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['ID']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelGroupsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelPinnedCollectionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelPinnedVideosArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelPublicVideosArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelRecentHighlightsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelSearchArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  collectionVisibility?: InputMaybe<CollectionVisibility>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  query: Scalars['String']['input'];
  shouldMatchAll?: InputMaybe<Scalars['Boolean']['input']>;
  type: Search;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelSlackVideoEmbedBlocksArgs = {
  expireAfterDays: Scalars['Int']['input'];
  videoUrls: Array<Scalars['Url']['input']>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelTagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelTopLevelCollectionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelUserArgs = {
  id: Scalars['ID']['input'];
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelUsersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelVideosArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['ID']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  orderBy?: InputMaybe<VideosOrder>;
};

/** Your channel of videos and collections on Rewatch. */
export type ChannelWebhooksArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  enabled?: InputMaybe<Scalars['Boolean']['input']>;
  event?: InputMaybe<WebhookEvent>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['ID']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  orderBy?: InputMaybe<WebhooksOrder>;
};

/** The channel role of a user. */
export enum ChannelRole {
  /** This user has administrative access. */
  Admin = 'ADMIN',
  /** This user has guest access. */
  Guest = 'GUEST',
  /** This user has standard member access. */
  Member = 'MEMBER',
  /** This user has owner access. */
  Owner = 'OWNER',
}

/** The connection type for ChannelSearchItem. */
export type ChannelSearchConnection = {
  __typename?: 'ChannelSearchConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<ChannelSearchEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<ChannelSearchItem>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type ChannelSearchEdge = {
  __typename?: 'ChannelSearchEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<ChannelSearchItem>;
};

/** An item in a channel search result set. */
export type ChannelSearchItem = Collection | Group | Tag | User | Video;

/** A chapter in a video. */
export type Chapter = Node & {
  __typename?: 'Chapter';
  /** Identifies the date and time when the object was created. */
  createdAt: Scalars['DateTime']['output'];
  /** The global ID for the chapter. */
  id: Scalars['ID']['output'];
  /** The start time of the chapter as an offset in milliseconds. */
  time: Scalars['Int']['output'];
  /** The title for the chapter. */
  title: Scalars['String']['output'];
  /** Identifies the date and time when the object was last updated. */
  updatedAt: Scalars['DateTime']['output'];
  /** The url for the chapter. */
  url: Scalars['Url']['output'];
  /** The video the chapter is on. */
  video: Video;
};

/** The connection type for Chapter. */
export type ChapterConnection = {
  __typename?: 'ChapterConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<ChapterEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<Chapter>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type ChapterEdge = {
  __typename?: 'ChapterEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Chapter>;
};

export enum ClipStatus {
  /** The clipper is not allowed to clip the parent video. */
  ClippingDisabled = 'CLIPPING_DISABLED',
  /** A clip from a parent video that has been deleted. */
  ParentDeleted = 'PARENT_DELETED',
  /** A clip that is visible to the viewer. */
  Valid = 'VALID',
}

/** A collection of videos on your Rewatch channel. */
export type Collection = Node &
  Subscribable & {
    __typename?: 'Collection';
    /** The collections that are the ancestors of this one, if any. */
    ancestors?: Maybe<CollectionConnection>;
    /** True when new videos added to this collection notify all channel members. */
    broadcastUpdates: Scalars['Boolean']['output'];
    /** The collections that are immediate children of this one, if any. */
    children?: Maybe<CollectionConnection>;
    /** Identifies the date and time when the object was created. */
    createdAt: Scalars['DateTime']['output'];
    /** A short description of the channel. */
    description?: Maybe<Scalars['String']['output']>;
    /** The global ID for the collection. */
    id: Scalars['ID']['output'];
    /** True if this collection is a secret collection. */
    isSecret: Scalars['Boolean']['output'];
    /** The collection's name. */
    name: Scalars['String']['output'];
    /** Identifies the date and time when the object was last updated. */
    updatedAt: Scalars['DateTime']['output'];
    /** The URL for the collection on Rewatch. */
    url: Scalars['Url']['output'];
    /** The videos from this collection that are visible to the current viewer. */
    videos?: Maybe<VideoConnection>;
    /** True if the viewer has access to contribute to this collection. */
    viewerCanContribute: Scalars['Boolean']['output'];
    /** True if the viewer has favorited this collection. */
    viewerHasFavorited: Scalars['Boolean']['output'];
    /** True if the viewer is subscribed to this object. */
    viewerIsSubscribed: Scalars['Boolean']['output'];
  };

/** A collection of videos on your Rewatch channel. */
export type CollectionAncestorsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A collection of videos on your Rewatch channel. */
export type CollectionChildrenArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A collection of videos on your Rewatch channel. */
export type CollectionVideosArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['ID']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  pinned?: InputMaybe<Scalars['Boolean']['input']>;
};

/** The connection type for Collection. */
export type CollectionConnection = {
  __typename?: 'CollectionConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<CollectionEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<Collection>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type CollectionEdge = {
  __typename?: 'CollectionEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Collection>;
};

export enum CollectionVisibility {
  /** All members on a channel can see this collection. */
  Public = 'PUBLIC',
  /** Only members added to the collection can see this collection. */
  Secret = 'SECRET',
}

/** A comment left on a video on your channel. Comments may have child comments in a thread. */
export type Comment = Node & {
  __typename?: 'Comment';
  /** The user who left the comment. */
  author: Actor;
  /** The text content of the comment. */
  body: Scalars['String']['output'];
  /** Identifies the date and time when the object was created. */
  createdAt: Scalars['DateTime']['output'];
  /** The transcript cues that were commented. */
  cues?: Maybe<Array<Maybe<TranscriptCue>>>;
  /** The parent highlight for this comment. Empty if no highlight. */
  highlight?: Maybe<Highlight>;
  /** The global ID for the comment. */
  id: Scalars['ID']['output'];
  /** Can the viewer delete this comment. */
  isDeletableByViewer: Scalars['Boolean']['output'];
  /** Can the viewer edit this comment. */
  isEditableByViewer: Scalars['Boolean']['output'];
  /** Whether or not this comment has been edited by its author or a channel admin. */
  isEdited: Scalars['Boolean']['output'];
  /** Whether or not this comment has been removed by its author or a channel admin. */
  isRemoved: Scalars['Boolean']['output'];
  /** The parent for this comment. Empty if is parent. */
  parentComment?: Maybe<Comment>;
  /** The point in the video and transcript where the comment ends as an offset in milliseconds. */
  rangeEnd: Scalars['Int']['output'];
  /** The point in the video and transcript where the comment begins as an offset in milliseconds. */
  rangeStart: Scalars['Int']['output'];
  /** The comment replies to this comment, if any. */
  replies?: Maybe<CommentConnection>;
  /** The users subscribed to this thread. */
  subscribers?: Maybe<UserConnection>;
  /** Identifies the date and time when the object was last updated. */
  updatedAt: Scalars['DateTime']['output'];
  /** The url for the comment. */
  url: Scalars['Url']['output'];
  /** The video the comment is on. */
  video: Video;
  /** True if the current viewer is subscribed to this thread. */
  viewerIsSubscribed: Scalars['Boolean']['output'];
};

/** A comment left on a video on your channel. Comments may have child comments in a thread. */
export type CommentRepliesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  includeRemoved?: InputMaybe<Scalars['Boolean']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A comment left on a video on your channel. Comments may have child comments in a thread. */
export type CommentSubscribersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** The connection type for Comment. */
export type CommentConnection = {
  __typename?: 'CommentConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<CommentEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<Comment>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type CommentEdge = {
  __typename?: 'CommentEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Comment>;
};

/** Autogenerated input type of CreateTag */
export type CreateTagInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The name for the new tag. */
  name: Scalars['String']['input'];
};

/** Autogenerated return type of CreateTag. */
export type CreateTagPayload = {
  __typename?: 'CreateTagPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The tag that was created. */
  tag?: Maybe<Tag>;
  /** The viewer who created the tag. */
  viewer: Viewer;
};

/** Autogenerated input type of CreateVideoFromDirectUpload */
export type CreateVideoFromDirectUploadInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ids of any collections to add the video to. */
  collectionIds?: InputMaybe<Array<Scalars['ID']['input']>>;
  /** The summary of the video. */
  description?: InputMaybe<Scalars['String']['input']>;
  /** The duration of the video in milliseconds (only for hls uploads). */
  durationMs?: InputMaybe<Scalars['BigInt']['input']>;
  /** The ids of users and groups that can access this video. Ignored if visibility isn't private. */
  shareRecipientIds?: InputMaybe<Array<Scalars['ID']['input']>>;
  /** True if the uploader the only speaker in the video. */
  singleSpeaker?: InputMaybe<Scalars['Boolean']['input']>;
  /** The title of the video. */
  title?: InputMaybe<Scalars['String']['input']>;
  /** The uploaded file id returned from the initiateDirectVideoUpload mutation. */
  uploadId: Scalars['String']['input'];
  /** The url attachements to add to the video. */
  urlAttachments?: InputMaybe<Array<UrlAttachment>>;
  /** The ids of any users to tag on the video. */
  userIds?: InputMaybe<Array<Scalars['ID']['input']>>;
  /** The users and groups that can access this video. */
  videoShareRecipients?: InputMaybe<Array<VideoShareInfo>>;
  /** The visibility for the video after creating. If null, an appropriate visibility will be selected automatically. Currently this will be unpublished for paid accounts and public for free accounts. */
  visibility?: InputMaybe<VideoVisibility>;
};

/** Autogenerated return type of CreateVideoFromDirectUpload. */
export type CreateVideoFromDirectUploadPayload = {
  __typename?: 'CreateVideoFromDirectUploadPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The video that was created. */
  video?: Maybe<Video>;
  /** The viewer who is creating a video. */
  viewer: Viewer;
};

/** Autogenerated input type of CreateWebhook */
export type CreateWebhookInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A short description of the webhook. */
  description?: InputMaybe<Scalars['String']['input']>;
  /** Whether to deliver events to this webhook, defaults to true. */
  enabled?: InputMaybe<Scalars['Boolean']['input']>;
  /** The events to subscribe this webhook to. */
  events: Array<WebhookEvent>;
  /** The number of retries to attempt if an event delivery fails. Defaults to 0, maximum allowed is 5. */
  retries?: InputMaybe<Scalars['Int']['input']>;
  /** The secret tokens that Rewatch will pass as a comma-separated list via the Rewatch-Hook-Secrets HTTP header. */
  secrets: Array<Scalars['String']['input']>;
  /** The HTTPS URL to deliver the webhook to. */
  url: Scalars['Url']['input'];
};

/** Autogenerated return type of CreateWebhook. */
export type CreateWebhookPayload = {
  __typename?: 'CreateWebhookPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The authenticated viewer. */
  viewer: Viewer;
  /** The newly created webhook. */
  webhook?: Maybe<Webhook>;
};

/** Autogenerated input type of DeactivateUsers */
export type DeactivateUsersInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The email of the user to deactivate. */
  emails?: InputMaybe<Array<Scalars['String']['input']>>;
  /** The ID value of the user to deactivate. */
  userIds?: InputMaybe<Array<Scalars['ID']['input']>>;
};

/** Autogenerated return type of DeactivateUsers. */
export type DeactivateUsersPayload = {
  __typename?: 'DeactivateUsersPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who deactivated the user. */
  viewer: Viewer;
};

/** Autogenerated input type of DeleteWebhook */
export type DeleteWebhookInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The global ID of a webhook. */
  webhookId: Scalars['ID']['input'];
};

/** Autogenerated return type of DeleteWebhook. */
export type DeleteWebhookPayload = {
  __typename?: 'DeleteWebhookPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The authenticated viewer. */
  viewer: Viewer;
};

/** An instance of a possibly recurring meeting on an external calendar. */
export type ExternalMeetingInstance = {
  __typename?: 'ExternalMeetingInstance';
  /** The id of the meeting instance in the external calendar source. */
  externalMeetingId: Scalars['String']['output'];
  /** The id of a recurring meeting in the external calendar source if this is an instance of one. */
  externalRecurringMeetingId: Scalars['String']['output'];
};

/** A group from a Rewatch channel. */
export type Group = Node & {
  __typename?: 'Group';
  /** Identifies the date and time when the object was created. */
  createdAt: Scalars['DateTime']['output'];
  /** The group's description. */
  description?: Maybe<Scalars['String']['output']>;
  /** The global ID for the group. */
  id: Scalars['ID']['output'];
  /** The group's name. */
  name: Scalars['String']['output'];
  /** Identifies the date and time when the object was last updated. */
  updatedAt: Scalars['DateTime']['output'];
};

/** The connection type for Group. */
export type GroupConnection = {
  __typename?: 'GroupConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<GroupEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<Group>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type GroupEdge = {
  __typename?: 'GroupEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Group>;
};

/** A highlight left on a video on your channel. Highlights may have child comments in a thread. */
export type Highlight = Node & {
  __typename?: 'Highlight';
  /** The user who created the highlight. */
  author: Actor;
  /** The comments on this highlight, if any. */
  comments?: Maybe<CommentConnection>;
  /** Identifies the date and time when the object was created. */
  createdAt: Scalars['DateTime']['output'];
  /** The transcript cues that were highlighted. */
  cues?: Maybe<Array<Maybe<TranscriptCue>>>;
  /** The global ID for the highlight. */
  id: Scalars['ID']['output'];
  /** Whether or not this highlight has been removed by its author or a channel admin. */
  isRemoved: Scalars['Boolean']['output'];
  /** The next more recent highlight */
  newerHighlight?: Maybe<Highlight>;
  /** The next less recent highlight */
  olderHighlight?: Maybe<Highlight>;
  /** The point in the video and transcript where the highlight ends as an offset in milliseconds. */
  rangeEnd: Scalars['Int']['output'];
  /** The point in the video and transcript where the highlight begins as an offset in milliseconds. */
  rangeStart: Scalars['Int']['output'];
  /** The users subscribed to this thread. */
  subscribers?: Maybe<UserConnection>;
  /** The title of the highlight. */
  title?: Maybe<Scalars['String']['output']>;
  /** Identifies the date and time when the object was last updated. */
  updatedAt: Scalars['DateTime']['output'];
  /** The url for the highlight. */
  url: Scalars['Url']['output'];
  /** The video the highlight is on. */
  video: Video;
};

/** A highlight left on a video on your channel. Highlights may have child comments in a thread. */
export type HighlightCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  includeRemoved?: InputMaybe<Scalars['Boolean']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A highlight left on a video on your channel. Highlights may have child comments in a thread. */
export type HighlightSubscribersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** The connection type for Highlight. */
export type HighlightConnection = {
  __typename?: 'HighlightConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<HighlightEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<Highlight>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type HighlightEdge = {
  __typename?: 'HighlightEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Highlight>;
};

/** Autogenerated input type of InitiateDirectVideoUpload */
export type InitiateDirectVideoUploadInput = {
  /** The byte size of the file. */
  byteSize: Scalars['Int']['input'];
  /** The base64 encoded checksum of the file in MD5 digest format. */
  checksum: Scalars['String']['input'];
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The content type of the file (i.e., video/mp4). */
  contentType: Scalars['String']['input'];
  /** The name of the file to upload. */
  filename: Scalars['String']['input'];
};

/** Autogenerated return type of InitiateDirectVideoUpload. */
export type InitiateDirectVideoUploadPayload = {
  __typename?: 'InitiateDirectVideoUploadPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The headers to include with the upload request to the URL. */
  uploadHeaders?: Maybe<Scalars['Json']['output']>;
  /** The id of the uploaded file for use with the createVideoFromDirectUpload mutation once the upload request has completed. */
  uploadId?: Maybe<Scalars['String']['output']>;
  /** The URL to upload the video file to via a PUT request. */
  uploadUrl?: Maybe<Scalars['String']['output']>;
  /** The authenticated viewer. */
  viewer: Viewer;
};

/** Autogenerated input type of InviteUsers */
export type InviteUsersInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The email and roles of the user that will be invited into the channel */
  users: Array<UserInviteInfo>;
};

/** Autogenerated return type of InviteUsers. */
export type InviteUsersPayload = {
  __typename?: 'InviteUsersPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The user that was invited. */
  users?: Maybe<Array<User>>;
  /** The viewer who is inviting a user. */
  viewer: Viewer;
};

/** Autogenerated input type of LikeVideo */
export type LikeVideoInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the video. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of LikeVideo. */
export type LikeVideoPayload = {
  __typename?: 'LikeVideoPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The video that was liked. */
  video?: Maybe<Video>;
  /** The viewer who liked a video. */
  viewer: Viewer;
};

/** The mutations available in the Rewatch API. */
export type Mutation = {
  __typename?: 'Mutation';
  /** Add a new comment to a video highlight. */
  addCommentToHighlight?: Maybe<AddCommentToHighlightPayload>;
  /** Add a new comment, or reply to an existing comment, to a video. */
  addCommentToVideo?: Maybe<AddCommentToVideoPayload>;
  /** Add a collection to favorites. */
  addFavoriteCollection?: Maybe<AddFavoriteCollectionPayload>;
  /** Add a new highlight to a video. */
  addHighlightToVideo?: Maybe<AddHighlightToVideoPayload>;
  /** Deprecated: use saveForLater instead. */
  addToQueue?: Maybe<AddToQueuePayload>;
  /** Deprecated: use saveForLater instead. */
  addToWatchlist?: Maybe<AddToWatchlistPayload>;
  /** Add users to a video. Existing added users will remain. */
  addUsersToVideo?: Maybe<AddUsersToVideoPayload>;
  /** Add a video to a list of collections. Existing video collections will remain. */
  addVideoToCollections?: Maybe<AddVideoToCollectionsPayload>;
  /** Create a new tag on the channel. */
  createTag?: Maybe<CreateTagPayload>;
  /** Create a new video on the channel from an uploaded file. */
  createVideoFromDirectUpload?: Maybe<CreateVideoFromDirectUploadPayload>;
  /** Create a webhook to receive channel activity events. Only channel admins may view or modify webhooks. */
  createWebhook?: Maybe<CreateWebhookPayload>;
  /** Removes users' access from the current channel. */
  deactivateUsers?: Maybe<DeactivateUsersPayload>;
  /** Delete a webhook from the channel. Only channel admins may view or modify webhooks. */
  deleteWebhook?: Maybe<DeleteWebhookPayload>;
  /** Create a file upload placeholder and receive a signed direct upload URL and request headers for it. */
  initiateDirectVideoUpload?: Maybe<InitiateDirectVideoUploadPayload>;
  /** Invites users to the channel with a given role via their email address. */
  inviteUsers?: Maybe<InviteUsersPayload>;
  /** Likes a video for the current viewer. */
  likeVideo?: Maybe<LikeVideoPayload>;
  /** Removes a chapter from a video. */
  removeChapter?: Maybe<RemoveChapterPayload>;
  /** Remove a comment from a video. */
  removeComment?: Maybe<RemoveCommentPayload>;
  /** Remove a collection from favorites. */
  removeFavoriteCollection?: Maybe<RemoveFavoriteCollectionPayload>;
  /** Deprecated: use unsaveForLater instead. */
  removeFromQueue?: Maybe<RemoveFromQueuePayload>;
  /** Deprecated: use unsaveForLater instead. */
  removeFromWatchlist?: Maybe<RemoveFromWatchlistPayload>;
  /** Remove a highlight from a video. */
  removeHighlight?: Maybe<RemoveHighlightPayload>;
  /** Remove users from a video. Other added users will remain. */
  removeUsersFromVideo?: Maybe<RemoveUsersFromVideoPayload>;
  /** Remove a video from a list of collections. */
  removeVideoFromCollections?: Maybe<RemoveVideoFromCollectionsPayload>;
  /** Adds a video to the viewer's saved for later list. */
  saveForLater?: Maybe<SaveForLaterPayload>;
  /** Subscribes viewer to the collection. */
  subscribeToCollection?: Maybe<SubscribeToCollectionPayload>;
  /** Subscribe to a comment thread. */
  subscribeToCommentThread?: Maybe<SubscribeToCommentThreadPayload>;
  /** Subscribe to a highlight's comment thread. */
  subscribeToHighlightThread?: Maybe<SubscribeToHighlightThreadPayload>;
  /** Subscribe to a subscribable object. */
  subscribeToSubscribable?: Maybe<SubscribeToSubscribablePayload>;
  /** Deprecated: Use addUsersToVideo instead. */
  tagUsersOnVideo?: Maybe<TagUsersOnVideoPayload>;
  /** Unlikes a video for the current viewer. */
  unlikeVideo?: Maybe<UnlikeVideoPayload>;
  /** Removes a video from the viewer's saved for later list. */
  unsaveForLater?: Maybe<UnsaveForLaterPayload>;
  /** Unsubscribes viewer from the collection. */
  unsubscribeFromCollection?: Maybe<UnsubscribeFromCollectionPayload>;
  /** Unsubscribe from a comment thread. */
  unsubscribeFromCommentThread?: Maybe<UnsubscribeFromCommentThreadPayload>;
  /** Unsubscribe from a highlight's comment thread. */
  unsubscribeFromHighlightThread?: Maybe<UnsubscribeFromHighlightThreadPayload>;
  /** Unsubscribe from a subscribable object. */
  unsubscribeFromSubscribable?: Maybe<UnsubscribeFromSubscribablePayload>;
  /** Deprecated: Use removeUsersFromVideo instead. */
  untagUsersOnVideo?: Maybe<UntagUsersOnVideoPayload>;
  /** Update the details of the channel. Only channel admins may modify channel details. */
  updateChannelDetails?: Maybe<UpdateChannelDetailsPayload>;
  /** Update an existing chapter. */
  updateChapter?: Maybe<UpdateChapterPayload>;
  /** Update a highlight on a video. */
  updateHighlight?: Maybe<UpdateHighlightPayload>;
  /** Update the details of a video. Only the uploader or channel admins may modify a video's details. */
  updateVideoDetails?: Maybe<UpdateVideoDetailsPayload>;
  /** Update the configuration of a webhook on the channel. Only channel admins may view or modify webhooks. */
  updateWebhook?: Maybe<UpdateWebhookPayload>;
  /** Add a new video to a series from an uploaded file. */
  uploadVideoToSeries?: Maybe<UploadVideoToSeriesPayload>;
};

/** The mutations available in the Rewatch API. */
export type MutationAddCommentToHighlightArgs = {
  input: AddCommentToHighlightInput;
};

/** The mutations available in the Rewatch API. */
export type MutationAddCommentToVideoArgs = {
  input: AddCommentToVideoInput;
};

/** The mutations available in the Rewatch API. */
export type MutationAddFavoriteCollectionArgs = {
  input: AddFavoriteCollectionInput;
};

/** The mutations available in the Rewatch API. */
export type MutationAddHighlightToVideoArgs = {
  input: AddHighlightToVideoInput;
};

/** The mutations available in the Rewatch API. */
export type MutationAddToQueueArgs = {
  input: AddToQueueInput;
};

/** The mutations available in the Rewatch API. */
export type MutationAddToWatchlistArgs = {
  input: AddToWatchlistInput;
};

/** The mutations available in the Rewatch API. */
export type MutationAddUsersToVideoArgs = {
  input: AddUsersToVideoInput;
};

/** The mutations available in the Rewatch API. */
export type MutationAddVideoToCollectionsArgs = {
  input: AddVideoToCollectionsInput;
};

/** The mutations available in the Rewatch API. */
export type MutationCreateTagArgs = {
  input: CreateTagInput;
};

/** The mutations available in the Rewatch API. */
export type MutationCreateVideoFromDirectUploadArgs = {
  input: CreateVideoFromDirectUploadInput;
};

/** The mutations available in the Rewatch API. */
export type MutationCreateWebhookArgs = {
  input: CreateWebhookInput;
};

/** The mutations available in the Rewatch API. */
export type MutationDeactivateUsersArgs = {
  input: DeactivateUsersInput;
};

/** The mutations available in the Rewatch API. */
export type MutationDeleteWebhookArgs = {
  input: DeleteWebhookInput;
};

/** The mutations available in the Rewatch API. */
export type MutationInitiateDirectVideoUploadArgs = {
  input: InitiateDirectVideoUploadInput;
};

/** The mutations available in the Rewatch API. */
export type MutationInviteUsersArgs = {
  input: InviteUsersInput;
};

/** The mutations available in the Rewatch API. */
export type MutationLikeVideoArgs = {
  input: LikeVideoInput;
};

/** The mutations available in the Rewatch API. */
export type MutationRemoveChapterArgs = {
  input: RemoveChapterInput;
};

/** The mutations available in the Rewatch API. */
export type MutationRemoveCommentArgs = {
  input: RemoveCommentInput;
};

/** The mutations available in the Rewatch API. */
export type MutationRemoveFavoriteCollectionArgs = {
  input: RemoveFavoriteCollectionInput;
};

/** The mutations available in the Rewatch API. */
export type MutationRemoveFromQueueArgs = {
  input: RemoveFromQueueInput;
};

/** The mutations available in the Rewatch API. */
export type MutationRemoveFromWatchlistArgs = {
  input: RemoveFromWatchlistInput;
};

/** The mutations available in the Rewatch API. */
export type MutationRemoveHighlightArgs = {
  input: RemoveHighlightInput;
};

/** The mutations available in the Rewatch API. */
export type MutationRemoveUsersFromVideoArgs = {
  input: RemoveUsersFromVideoInput;
};

/** The mutations available in the Rewatch API. */
export type MutationRemoveVideoFromCollectionsArgs = {
  input: RemoveVideoFromCollectionsInput;
};

/** The mutations available in the Rewatch API. */
export type MutationSaveForLaterArgs = {
  input: SaveForLaterInput;
};

/** The mutations available in the Rewatch API. */
export type MutationSubscribeToCollectionArgs = {
  input: SubscribeToCollectionInput;
};

/** The mutations available in the Rewatch API. */
export type MutationSubscribeToCommentThreadArgs = {
  input: SubscribeToCommentThreadInput;
};

/** The mutations available in the Rewatch API. */
export type MutationSubscribeToHighlightThreadArgs = {
  input: SubscribeToHighlightThreadInput;
};

/** The mutations available in the Rewatch API. */
export type MutationSubscribeToSubscribableArgs = {
  input: SubscribeToSubscribableInput;
};

/** The mutations available in the Rewatch API. */
export type MutationTagUsersOnVideoArgs = {
  input: TagUsersOnVideoInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUnlikeVideoArgs = {
  input: UnlikeVideoInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUnsaveForLaterArgs = {
  input: UnsaveForLaterInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUnsubscribeFromCollectionArgs = {
  input: UnsubscribeFromCollectionInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUnsubscribeFromCommentThreadArgs = {
  input: UnsubscribeFromCommentThreadInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUnsubscribeFromHighlightThreadArgs = {
  input: UnsubscribeFromHighlightThreadInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUnsubscribeFromSubscribableArgs = {
  input: UnsubscribeFromSubscribableInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUntagUsersOnVideoArgs = {
  input: UntagUsersOnVideoInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUpdateChannelDetailsArgs = {
  input: UpdateChannelDetailsInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUpdateChapterArgs = {
  input: UpdateChapterInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUpdateHighlightArgs = {
  input: UpdateHighlightInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUpdateVideoDetailsArgs = {
  input: UpdateVideoDetailsInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUpdateWebhookArgs = {
  input: UpdateWebhookInput;
};

/** The mutations available in the Rewatch API. */
export type MutationUploadVideoToSeriesArgs = {
  input: UploadVideoToSeriesInput;
};

/** An object with an ID. */
export type Node = {
  /** ID of the object. */
  id: Scalars['ID']['output'];
};

/** An error resulting from a missing resource. */
export type NotFoundError = UserError & {
  __typename?: 'NotFoundError';
  /** A human-readable description of the error. */
  message: Scalars['String']['output'];
  /** The input value this error came from, if any. */
  path?: Maybe<Array<Scalars['String']['output']>>;
};

/** Possible directions in which to order a list of items when provided an `orderBy` argument. */
export enum OrderDirection {
  /** Specifies an ascending order for a given `orderBy` argument. */
  Asc = 'ASC',
  /** Specifies a descending order for a given `orderBy` argument. */
  Desc = 'DESC',
}

/** Information about pagination in a connection. */
export type PageInfo = {
  __typename?: 'PageInfo';
  /** When paginating forwards, the cursor to continue. */
  endCursor?: Maybe<Scalars['String']['output']>;
  /** When paginating forwards, are there more items? */
  hasNextPage: Scalars['Boolean']['output'];
  /** When paginating backwards, are there more items? */
  hasPreviousPage: Scalars['Boolean']['output'];
  /** When paginating backwards, the cursor to continue. */
  startCursor?: Maybe<Scalars['String']['output']>;
};

/** An error resulting from a user taking an unauthorized action. */
export type PermissionError = UserError & {
  __typename?: 'PermissionError';
  /** A human-readable description of the error. */
  message: Scalars['String']['output'];
  /** The input value this error came from, if any. */
  path?: Maybe<Array<Scalars['String']['output']>>;
};

/** The top-level fields available in the Rewatch API. */
export type Query = {
  __typename?: 'Query';
  /** Your channel on Rewatch! */
  channel: Channel;
  /** Fetches an object given its ID. */
  node?: Maybe<Node>;
  /** Fetches a list of objects given a list of IDs. */
  nodes: Array<Maybe<Node>>;
  /** The authenticated viewer. */
  viewer: Viewer;
};

/** The top-level fields available in the Rewatch API. */
export type QueryNodeArgs = {
  id: Scalars['ID']['input'];
};

/** The top-level fields available in the Rewatch API. */
export type QueryNodesArgs = {
  ids: Array<Scalars['ID']['input']>;
};

export type QueueItem = Node & {
  __typename?: 'QueueItem';
  /** The global ID for the queue item. */
  id: Scalars['ID']['output'];
  /** The date the video was added to the queue. */
  queuedAt: Scalars['DateTime']['output'];
  /** The queued video. */
  video: Video;
};

/** The connection type for QueueItem. */
export type QueueItemConnection = {
  __typename?: 'QueueItemConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<QueueItemEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<QueueItem>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type QueueItemEdge = {
  __typename?: 'QueueItemEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<QueueItem>;
};

/** Ordering options for queue connections. */
export type QueueOrder = {
  /** The ordering direction. */
  direction: OrderDirection;
  /** The field by which to order the queue. */
  field: QueueOrderField;
};

/** Properties by which queue connections can be ordered. */
export enum QueueOrderField {
  /** Order queue by when they were added to the queue. */
  CreatedAt = 'CREATED_AT',
}

/** Autogenerated input type of RemoveChapter */
export type RemoveChapterInput = {
  /** The ID value of the chapter to remove. */
  chapterId: Scalars['ID']['input'];
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
};

/** Autogenerated return type of RemoveChapter. */
export type RemoveChapterPayload = {
  __typename?: 'RemoveChapterPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who removed the chapter. */
  viewer: Viewer;
};

/** Autogenerated input type of RemoveComment */
export type RemoveCommentInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the comment to remove. */
  commentId: Scalars['ID']['input'];
};

/** Autogenerated return type of RemoveComment. */
export type RemoveCommentPayload = {
  __typename?: 'RemoveCommentPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who removed the comment. */
  viewer: Viewer;
};

/** Autogenerated input type of RemoveFavoriteCollection */
export type RemoveFavoriteCollectionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the collection to remove from favorites. */
  collectionId: Scalars['ID']['input'];
};

/** Autogenerated return type of RemoveFavoriteCollection. */
export type RemoveFavoriteCollectionPayload = {
  __typename?: 'RemoveFavoriteCollectionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The collection that was removed from favorites. */
  collection?: Maybe<Collection>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who removed the collection. */
  viewer: Viewer;
};

/** Autogenerated input type of RemoveFromQueue */
export type RemoveFromQueueInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the video. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of RemoveFromQueue. */
export type RemoveFromQueuePayload = {
  __typename?: 'RemoveFromQueuePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The video that was removed from the queue. */
  video?: Maybe<Video>;
  /** The viewer who removed a video from their queue. */
  viewer: Viewer;
};

/** Autogenerated input type of RemoveFromWatchlist */
export type RemoveFromWatchlistInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the video. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of RemoveFromWatchlist. */
export type RemoveFromWatchlistPayload = {
  __typename?: 'RemoveFromWatchlistPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The video that was removed from the watchlist. */
  video?: Maybe<Video>;
  /** The viewer who removed a video from their watchlist. */
  viewer: Viewer;
};

/** Autogenerated input type of RemoveHighlight */
export type RemoveHighlightInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the highlight to remove. */
  highlightId: Scalars['ID']['input'];
};

/** Autogenerated return type of RemoveHighlight. */
export type RemoveHighlightPayload = {
  __typename?: 'RemoveHighlightPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who removed the highlight. */
  viewer: Viewer;
};

/** Autogenerated input type of RemoveUsersFromVideo */
export type RemoveUsersFromVideoInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A list of users ids. */
  userIds: Array<Scalars['ID']['input']>;
  /** The id of the video. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of RemoveUsersFromVideo. */
export type RemoveUsersFromVideoPayload = {
  __typename?: 'RemoveUsersFromVideoPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The updated video. */
  video?: Maybe<Video>;
  /** The authenticated viewer. */
  viewer: Viewer;
};

/** Autogenerated input type of RemoveVideoFromCollections */
export type RemoveVideoFromCollectionsInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A list of collection ids. */
  collectionIds: Array<Scalars['ID']['input']>;
  /** The id of the video to tag users on. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of RemoveVideoFromCollections. */
export type RemoveVideoFromCollectionsPayload = {
  __typename?: 'RemoveVideoFromCollectionsPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The updated video. */
  video?: Maybe<Video>;
  /** The authenticated viewer. */
  viewer: Viewer;
};

/** Autogenerated input type of SaveForLater */
export type SaveForLaterInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the video. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of SaveForLater. */
export type SaveForLaterPayload = {
  __typename?: 'SaveForLaterPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The video that was added to the list. */
  video?: Maybe<Video>;
  /** The viewer who added a video to save for later. */
  viewer: Viewer;
};

export enum Search {
  /** Search for collections. */
  Collection = 'COLLECTION',
  /** Search for groups. */
  Group = 'GROUP',
  /** Search for tags. */
  Tag = 'TAG',
  /** Search for users. */
  User = 'USER',
  /** Search for videos. */
  Video = 'VIDEO',
}

/** An edge in a connection. */
export type SharedVideoEdge = {
  __typename?: 'SharedVideoEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Video>;
  /** The recipient of this shared video. */
  recipient?: Maybe<SharedVideoRecipient>;
  /** The user who shared this video. */
  sharer?: Maybe<User>;
};

/** A recipient of a shared video. */
export type SharedVideoRecipient = Group | User;

/** The connection type for SharedVideoRecipient. */
export type SharedVideoRecipientConnection = {
  __typename?: 'SharedVideoRecipientConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<SharedVideoRecipientEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<SharedVideoRecipient>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
};

/** An edge in a connection. */
export type SharedVideoRecipientEdge = {
  __typename?: 'SharedVideoRecipientEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<SharedVideoRecipient>;
};

/** The connection type for Video. */
export type SharedVideosConnection = {
  __typename?: 'SharedVideosConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<SharedVideoEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<Video>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An object that can be subscribed to. */
export type Subscribable = {
  /** True if the viewer is subscribed to this object. */
  viewerIsSubscribed: Scalars['Boolean']['output'];
};

/** An object that can be subscribed to. */
export type SubscribableItem = Tag | User;

/** Autogenerated input type of SubscribeToCollection */
export type SubscribeToCollectionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the collection. */
  collectionId: Scalars['ID']['input'];
};

/** Autogenerated return type of SubscribeToCollection. */
export type SubscribeToCollectionPayload = {
  __typename?: 'SubscribeToCollectionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The collection that was subscribed to. */
  collection?: Maybe<Collection>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who subscribed to the collection. */
  viewer: Viewer;
};

/** Autogenerated input type of SubscribeToCommentThread */
export type SubscribeToCommentThreadInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID of the comment to subscribe to. */
  commentId: Scalars['ID']['input'];
};

/** Autogenerated return type of SubscribeToCommentThread. */
export type SubscribeToCommentThreadPayload = {
  __typename?: 'SubscribeToCommentThreadPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The comment that was subscribed to. */
  comment?: Maybe<Comment>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who was subscribed. */
  viewer: Viewer;
};

/** Autogenerated input type of SubscribeToHighlightThread */
export type SubscribeToHighlightThreadInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID of the highlight thread to subscribe to. */
  highlightId: Scalars['ID']['input'];
};

/** Autogenerated return type of SubscribeToHighlightThread. */
export type SubscribeToHighlightThreadPayload = {
  __typename?: 'SubscribeToHighlightThreadPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The highlight that was subscribed to. */
  highlight?: Maybe<Highlight>;
  /** The viewer who was subscribed. */
  viewer: Viewer;
};

/** Autogenerated input type of SubscribeToSubscribable */
export type SubscribeToSubscribableInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID of the subscribable object. */
  subscribableId: Scalars['ID']['input'];
};

/** Autogenerated return type of SubscribeToSubscribable. */
export type SubscribeToSubscribablePayload = {
  __typename?: 'SubscribeToSubscribablePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The object to subscribe to. */
  subscribable?: Maybe<SubscribableItem>;
  /** The viewer who was subscribed. */
  viewer: Viewer;
};

/** A tag. */
export type Tag = Node &
  Subscribable & {
    __typename?: 'Tag';
    /** Identifies the date and time when the object was created. */
    createdAt: Scalars['DateTime']['output'];
    /** The global ID for the tag. */
    id: Scalars['ID']['output'];
    /** The name of the tag. */
    name: Scalars['String']['output'];
    /** A list of taggings that belong to videos without channel-wide visibility that the user can view. */
    privateTaggings?: Maybe<TaggingConnection>;
    /** A list of taggings that belong to videos that have channel-wide visibility. */
    publicTaggings: TaggingConnection;
    /** Identifies the date and time when the object was last updated. */
    updatedAt: Scalars['DateTime']['output'];
    /** The url for the tag. */
    url: Scalars['Url']['output'];
    /** True if the viewer is subscribed to this object. */
    viewerIsSubscribed: Scalars['Boolean']['output'];
  };

/** A tag. */
export type TagPrivateTaggingsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A tag. */
export type TagPublicTaggingsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** The connection type for Tag. */
export type TagConnection = {
  __typename?: 'TagConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<TagEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<Tag>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type TagEdge = {
  __typename?: 'TagEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Tag>;
};

/** Autogenerated input type of TagUsersOnVideo */
export type TagUsersOnVideoInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A list of users ids. */
  userIds: Array<Scalars['ID']['input']>;
  /** The id of the video. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of TagUsersOnVideo. */
export type TagUsersOnVideoPayload = {
  __typename?: 'TagUsersOnVideoPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The updated video. */
  video?: Maybe<Video>;
  /** The authenticated viewer. */
  viewer: Viewer;
};

/** An item that can be tagged. */
export type TaggableItem = Comment | Video;

/** A tagged object. */
export type Tagging = Node & {
  __typename?: 'Tagging';
  /** Identifies the date and time when the object was created. */
  createdAt: Scalars['DateTime']['output'];
  /** The global ID for the tagging. */
  id: Scalars['ID']['output'];
  /** The tag that the tagging belongs to. */
  tag: Tag;
  /** The taggable object. */
  taggable?: Maybe<TaggableItem>;
  /** Identifies the date and time when the object was last updated. */
  updatedAt: Scalars['DateTime']['output'];
  /** The user that created the tagging. */
  user?: Maybe<User>;
  /** The video that the tagging belongs to. */
  video: Video;
};

/** The connection type for Tagging. */
export type TaggingConnection = {
  __typename?: 'TaggingConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<TaggingEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<Tagging>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type TaggingEdge = {
  __typename?: 'TaggingEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Tagging>;
};

/** A videos transcript. */
export type Transcript = {
  __typename?: 'Transcript';
  /** The sections of a transcript */
  sections?: Maybe<Array<Maybe<TranscriptSection>>>;
  /** The AI generated summary for this transcript */
  summary?: Maybe<TranscriptSummary>;
  /** The video the transcript is on. */
  video: Video;
};

/** A cue for a line of transcript. */
export type TranscriptCue = {
  __typename?: 'TranscriptCue';
  /** The end time of the cue in milliseconds. */
  endTime: Scalars['Int']['output'];
  /** The name of the person who spoke the cue. */
  speakerName?: Maybe<Scalars['String']['output']>;
  /** The start time of the cue in milliseconds. */
  startTime: Scalars['Int']['output'];
  /** The text for this cue. */
  text?: Maybe<Scalars['String']['output']>;
};

/** A line of a transcript. */
export type TranscriptSection = {
  __typename?: 'TranscriptSection';
  /** Speaker cues for the transcript. */
  cues?: Maybe<Array<Maybe<TranscriptCue>>>;
  /** The end time of the line in milliseconds. */
  endTime: Scalars['Int']['output'];
  /** The start time of the line in milliseconds. */
  startTime: Scalars['Int']['output'];
};

/** An AI generated summary of a transcript. */
export type TranscriptSummary = {
  __typename?: 'TranscriptSummary';
  /** A list of action items, if any have been generated */
  actionItems?: Maybe<Array<TranscriptSummaryItem>>;
  /** A list of chapter markers, if any have been generated */
  chapterMarkers?: Maybe<Array<TranscriptSummaryChapterMarker>>;
  /** A plain-text recap of the entire transcript */
  recap?: Maybe<Scalars['String']['output']>;
  /** A list of prompts, if any have been generated */
  sections?: Maybe<Array<TranscriptSummaryPrompt>>;
  /** A list of summary items, if any have been generated */
  summaryItems?: Maybe<Array<TranscriptSummaryItem>>;
};

/** A chapter in a transcript summary that has a title and array of sub-items */
export type TranscriptSummaryChapterMarker = {
  __typename?: 'TranscriptSummaryChapterMarker';
  /** The items for this chapter */
  items?: Maybe<Array<TranscriptSummaryItem>>;
  /** A title for this chapter */
  title: Scalars['String']['output'];
};

/** An item in a transcript summary, either an action item or list item. */
export type TranscriptSummaryItem = {
  __typename?: 'TranscriptSummaryItem';
  /** For action items, completed will contain the status of the item. For normal list items, this will be null. */
  completed?: Maybe<Scalars['Boolean']['output']>;
  /** The main content for this item */
  content: Scalars['String']['output'];
  /** A name this item refers to, if provided */
  name?: Maybe<Scalars['String']['output']>;
  /** The start time of the line in milliseconds. */
  timestamp: Scalars['Int']['output'];
};

/** A prompt section in the transcript summary */
export type TranscriptSummaryPrompt = {
  __typename?: 'TranscriptSummaryPrompt';
  /** Result as prompt items, if provided */
  items?: Maybe<Array<TranscriptSummaryItem>>;
  /** Result as plain paragraph, if provided */
  text?: Maybe<Scalars['String']['output']>;
  /** A title this item refers to, if provided */
  title: Scalars['String']['output'];
};

/** A placeholder for an actor that is redacted or missing. */
export type UnknownUser = Actor &
  Node & {
    __typename?: 'UnknownUser';
    /** A URL for the actor's uploaded avatar image, if present. */
    avatarUrl?: Maybe<Scalars['Url']['output']>;
    /** The name to display when representing this actor. */
    displayName: Scalars['String']['output'];
    /** The global ID for the unknown user. */
    id: Scalars['ID']['output'];
  };

/** Autogenerated input type of UnlikeVideo */
export type UnlikeVideoInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the video. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of UnlikeVideo. */
export type UnlikeVideoPayload = {
  __typename?: 'UnlikeVideoPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The video that was unliked. */
  video?: Maybe<Video>;
  /** The viewer who unliked a video. */
  viewer: Viewer;
};

/** Autogenerated input type of UnsaveForLater */
export type UnsaveForLaterInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the video. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of UnsaveForLater. */
export type UnsaveForLaterPayload = {
  __typename?: 'UnsaveForLaterPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The video that was removed from the list. */
  video?: Maybe<Video>;
  /** The viewer who unsaved a video for later. */
  viewer: Viewer;
};

/** Autogenerated input type of UnsubscribeFromCollection */
export type UnsubscribeFromCollectionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the collection. */
  collectionId: Scalars['ID']['input'];
};

/** Autogenerated return type of UnsubscribeFromCollection. */
export type UnsubscribeFromCollectionPayload = {
  __typename?: 'UnsubscribeFromCollectionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who unsubscribed from the collection. */
  viewer: Viewer;
};

/** Autogenerated input type of UnsubscribeFromCommentThread */
export type UnsubscribeFromCommentThreadInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID of the comment thread to unsubscribe from. */
  commentId: Scalars['ID']['input'];
};

/** Autogenerated return type of UnsubscribeFromCommentThread. */
export type UnsubscribeFromCommentThreadPayload = {
  __typename?: 'UnsubscribeFromCommentThreadPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The comment thread that was unsubscribed from. */
  comment: Comment;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who was unsubscribed. */
  viewer: Viewer;
};

/** Autogenerated input type of UnsubscribeFromHighlightThread */
export type UnsubscribeFromHighlightThreadInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID of the highlight thread to unsubscribe from. */
  highlightId: Scalars['ID']['input'];
};

/** Autogenerated return type of UnsubscribeFromHighlightThread. */
export type UnsubscribeFromHighlightThreadPayload = {
  __typename?: 'UnsubscribeFromHighlightThreadPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The highlight thread that was unsubscribed from. */
  highlight: Highlight;
  /** The viewer who was unsubscribed. */
  viewer: Viewer;
};

/** Autogenerated input type of UnsubscribeFromSubscribable */
export type UnsubscribeFromSubscribableInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID of the subscribable object. */
  subscribableId: Scalars['ID']['input'];
};

/** Autogenerated return type of UnsubscribeFromSubscribable. */
export type UnsubscribeFromSubscribablePayload = {
  __typename?: 'UnsubscribeFromSubscribablePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The object that was unsubscribed from. */
  subscribable: SubscribableItem;
  /** The viewer who was unsubscribed. */
  viewer: Viewer;
};

/** Autogenerated input type of UntagUsersOnVideo */
export type UntagUsersOnVideoInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A list of users ids. */
  userIds: Array<Scalars['ID']['input']>;
  /** The id of the video. */
  videoId: Scalars['ID']['input'];
};

/** Autogenerated return type of UntagUsersOnVideo. */
export type UntagUsersOnVideoPayload = {
  __typename?: 'UntagUsersOnVideoPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The updated video. */
  video?: Maybe<Video>;
  /** The authenticated viewer. */
  viewer: Viewer;
};

/** Autogenerated input type of UpdateChannelDetails */
export type UpdateChannelDetailsInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A short description of the video. */
  description?: InputMaybe<Scalars['String']['input']>;
  /** The channel's name. */
  name?: InputMaybe<Scalars['String']['input']>;
  /** The URL subdomain for viewing the channel on https://rewatch.com. */
  subdomain?: InputMaybe<Scalars['String']['input']>;
};

/** Autogenerated return type of UpdateChannelDetails. */
export type UpdateChannelDetailsPayload = {
  __typename?: 'UpdateChannelDetailsPayload';
  /** The channel to be updated. */
  channel?: Maybe<Channel>;
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The authenticated viewer. */
  viewer: Viewer;
};

/** Autogenerated input type of UpdateChapter */
export type UpdateChapterInput = {
  /** The ID value of the chapter to update. */
  chapterId: Scalars['ID']['input'];
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The new title of the chapter. */
  title: Scalars['String']['input'];
};

/** Autogenerated return type of UpdateChapter. */
export type UpdateChapterPayload = {
  __typename?: 'UpdateChapterPayload';
  /** The chapter that was updated. */
  chapter?: Maybe<Chapter>;
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The viewer who updated the chapter. */
  viewer: Viewer;
};

/** Autogenerated input type of UpdateHighlight */
export type UpdateHighlightInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID value of the highlight to update. */
  highlightId: Scalars['ID']['input'];
  /** The updated title for the highlight. */
  title?: InputMaybe<Scalars['String']['input']>;
};

/** Autogenerated return type of UpdateHighlight. */
export type UpdateHighlightPayload = {
  __typename?: 'UpdateHighlightPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The highlight that was updated. */
  highlight?: Maybe<Highlight>;
  /** The viewer who updated the highlight. */
  viewer: Viewer;
};

/** Autogenerated input type of UpdateVideoDetails */
export type UpdateVideoDetailsInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ids of any collections to add the video to. */
  collectionIds?: InputMaybe<Array<Scalars['ID']['input']>>;
  /** The date this video was created or presented. Defaults to its upload time. */
  date?: InputMaybe<Scalars['Date']['input']>;
  /** A short description of the video. */
  description?: InputMaybe<Scalars['String']['input']>;
  /** If true enables the video to be shared externally */
  externalSharingEnabled?: InputMaybe<Scalars['Boolean']['input']>;
  /** The ids of users and groups that can access this video. Ignored if visibility isn't private. */
  shareRecipientIds?: InputMaybe<Array<Scalars['ID']['input']>>;
  /** If true and external sharing is enabled, then comments will be visible to anyone with the link. Otherwise, comments will only be visible to channel members. */
  showCommentsToExternalViewers?: InputMaybe<Scalars['Boolean']['input']>;
  /** The title of the video. */
  title?: InputMaybe<Scalars['String']['input']>;
  /** The ids of any users to tag on the video. */
  userIds?: InputMaybe<Array<Scalars['ID']['input']>>;
  /** The ID value of the video. */
  videoId: Scalars['ID']['input'];
  /** The users and groups that can access this video. */
  videoShareRecipients?: InputMaybe<Array<VideoShareInfo>>;
  /** The visibility of this video on the channel. */
  visibility?: InputMaybe<VideoVisibility>;
};

/** Autogenerated return type of UpdateVideoDetails. */
export type UpdateVideoDetailsPayload = {
  __typename?: 'UpdateVideoDetailsPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The video to be updated. */
  video?: Maybe<Video>;
  /** The authenticated viewer. */
  viewer: Viewer;
};

/** Autogenerated input type of UpdateWebhook */
export type UpdateWebhookInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A short description of the webhook. */
  description?: InputMaybe<Scalars['String']['input']>;
  /** Whether to deliver events to this webhook, defaults to true. */
  enabled?: InputMaybe<Scalars['Boolean']['input']>;
  /** The events to subscribe this webhook to. */
  events?: InputMaybe<Array<WebhookEvent>>;
  /** The number of retries to attempt if an event delivery fails. Defaults to 0, maximum allowed is 5. */
  retries?: InputMaybe<Scalars['Int']['input']>;
  /** The secret tokens that Rewatch will pass as a comma-separated list via the Rewatch-Hook-Secrets HTTP header. */
  secrets?: InputMaybe<Array<Scalars['String']['input']>>;
  /** The HTTPS URL to deliver the webhook to. */
  url?: InputMaybe<Scalars['Url']['input']>;
  /** The global ID of a webhook. */
  webhookId: Scalars['ID']['input'];
};

/** Autogenerated return type of UpdateWebhook. */
export type UpdateWebhookPayload = {
  __typename?: 'UpdateWebhookPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The authenticated viewer. */
  viewer: Viewer;
  /** The updated webhook. */
  webhook?: Maybe<Webhook>;
};

/** Autogenerated input type of UploadVideoToSeries */
export type UploadVideoToSeriesInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The duration of the video being uploaded (required for hls uploads). */
  durationMs?: InputMaybe<Scalars['BigInt']['input']>;
  /** The id of the series the video is being added to. */
  seriesId: Scalars['ID']['input'];
  /** True if the uploader the only speaker in the video. */
  singleSpeaker?: InputMaybe<Scalars['Boolean']['input']>;
  /** The uploaded file id returned from the initiateDirectVideoUpload mutation. */
  uploadId: Scalars['String']['input'];
};

/** Autogenerated return type of UploadVideoToSeries. */
export type UploadVideoToSeriesPayload = {
  __typename?: 'UploadVideoToSeriesPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Any errors encountered while running this mutation. */
  errors: Array<UserError>;
  /** The video that was created. */
  video?: Maybe<Video>;
  /** The viewer who is creating a video. */
  viewer: Viewer;
};

/** The URL and title of an attachement. */
export type UrlAttachment = {
  /** The title of the webpage. */
  title: Scalars['String']['input'];
  /** The URL of the webpage. */
  url: Scalars['Url']['input'];
};

/** A member of a Rewatch channel. */
export type User = Actor &
  Node &
  Subscribable &
  Viewer & {
    __typename?: 'User';
    /** The color hexadecimal (#FFFFFF) for the user avatar background. */
    avatarColor?: Maybe<Scalars['String']['output']>;
    /** A URL for the user's uploaded avatar image, if present. */
    avatarUrl?: Maybe<Scalars['Url']['output']>;
    /** Whether or not the user can upload videos to this channel. Null if the user is not the viewer. */
    canUploadVideos?: Maybe<Scalars['Boolean']['output']>;
    /** The access level for the user. */
    channelRole: ChannelRole;
    /** Identifies the date and time when the object was created. */
    createdAt: Scalars['DateTime']['output'];
    /** The name to display when representing this user as an Actor. */
    displayName: Scalars['String']['output'];
    /** The draft videos the current user has uploaded. This will be null when the user is not the viewer. */
    draftVideos?: Maybe<VideoConnection>;
    /** The user's email address. */
    email: Scalars['String']['output'];
    /** The collections the user as favorited. This will be null when the user is not the viewer. */
    favoriteCollections?: Maybe<CollectionConnection>;
    /** The global ID for the user. */
    id: Scalars['ID']['output'];
    /** Whether or not the user is the viewer. */
    isViewer: Scalars['Boolean']['output'];
    /** The videos the user has liked. */
    liked?: Maybe<VideoConnection>;
    /** Deprecated: use savedForLaterItems instead */
    queueItems?: Maybe<QueueItemConnection>;
    /** The videos in the current user's saved for later list. This will be null when the user is not the viewer. */
    savedForLaterVideos?: Maybe<VideoConnection>;
    /** All series videos the current user has uploaded. This will be null when the user is not the viewer. */
    seriesVideos?: Maybe<VideoConnection>;
    /** The videos that have been shared with the user directly or through a group they are a member of. */
    sharedWithMeVideos?: Maybe<SharedVideosConnection>;
    /** The videos the user is tagged in. */
    tagged?: Maybe<VideoConnection>;
    /** Identifies the date and time when the object was last updated. */
    updatedAt: Scalars['DateTime']['output'];
    /** All non-draft videos the current user has uploaded. This will be null when the user is not the viewer. */
    uploadedVideos?: Maybe<VideoConnection>;
    /** The url for the user. */
    url: Scalars['Url']['output'];
    /** The channel-visible videos the user has uploaded. */
    videos?: Maybe<VideoConnection>;
    /** True if the viewer is subscribed to this object. */
    viewerIsSubscribed: Scalars['Boolean']['output'];
    /** The videos the current user has watched. This will be empty when the user is not the viewer. */
    viewerRecentlyWatchedVideos: VideoConnection;
    /** Deprecated: use queueItems instead. */
    watchlist?: Maybe<VideoConnection>;
  };

/** A member of a Rewatch channel. */
export type UserAvatarUrlArgs = {
  size?: InputMaybe<Scalars['Int']['input']>;
};

/** A member of a Rewatch channel. */
export type UserDraftVideosArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A member of a Rewatch channel. */
export type UserFavoriteCollectionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A member of a Rewatch channel. */
export type UserLikedArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A member of a Rewatch channel. */
export type UserQueueItemsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  orderBy?: InputMaybe<QueueOrder>;
};

/** A member of a Rewatch channel. */
export type UserSavedForLaterVideosArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A member of a Rewatch channel. */
export type UserSeriesVideosArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A member of a Rewatch channel. */
export type UserSharedWithMeVideosArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A member of a Rewatch channel. */
export type UserTaggedArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A member of a Rewatch channel. */
export type UserUploadedVideosArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A member of a Rewatch channel. */
export type UserVideosArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A member of a Rewatch channel. */
export type UserViewerRecentlyWatchedVideosArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A member of a Rewatch channel. */
export type UserWatchlistArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** The connection type for User. */
export type UserConnection = {
  __typename?: 'UserConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<UserEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<User>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type UserEdge = {
  __typename?: 'UserEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<User>;
};

/** An error returned from a mutation resulting from a user action. */
export type UserError = {
  /** A human-readable description of the error. */
  message: Scalars['String']['output'];
  /** The input value this error came from, if any. */
  path?: Maybe<Array<Scalars['String']['output']>>;
};

/** Information needed to invite a user. */
export type UserInviteInfo = {
  /** The email of a user to invite. */
  email: Scalars['String']['input'];
  /** A list of collection ids to add the user. A minimum of 1 collection required for the guest role */
  guestCollectionIds?: InputMaybe<Array<Scalars['ID']['input']>>;
  /** The channel role for the user. */
  role: ChannelRole;
};

/** An error resulting from invalid user-supplied input. */
export type ValidationError = UserError & {
  __typename?: 'ValidationError';
  /** A human-readable description of the error. */
  message: Scalars['String']['output'];
  /** The input value this error came from, if any. */
  path?: Maybe<Array<Scalars['String']['output']>>;
};

/** A video uploaded to your channel. */
export type Video = Node & {
  __typename?: 'Video';
  /** All channel members that have been added on the video. */
  addedUsers?: Maybe<UserConnection>;
  /** The analytics for this video. */
  analytics?: Maybe<VideoAnalytics>;
  /** The video's attachments. */
  attachments?: Maybe<VideoAttachmentConnection>;
  /** List of attendees with name and email each */
  attendeesInfo: Array<Scalars['Json']['output']>;
  /** The video file size in bytes. */
  bytes: Scalars['Int']['output'];
  /** The video's chapters, if any have been set. */
  chapters?: Maybe<ChapterConnection>;
  /** Returns the value of a clips status. */
  clipStatus?: Maybe<ClipStatus>;
  /** Clips on the video the viewer can access */
  clips?: Maybe<VideoConnection>;
  /** All collections the video belongs to that are visible to the current viewer. */
  collections?: Maybe<CollectionConnection>;
  /** The video's comments, or null if this video has comments disabled. */
  commentThreads?: Maybe<CommentConnection>;
  /** Identifies the date and time when the object was created. */
  createdAt: Scalars['DateTime']['output'];
  /** The date this video was created or presented. Defaults to its upload time. */
  date: Scalars['Date']['output'];
  /** The video's description. */
  description?: Maybe<Scalars['String']['output']>;
  /** The video's duration in milliseconds, once processed. */
  duration?: Maybe<Scalars['Int']['output']>;
  /** The iframe embed markup for including the video on another site. */
  embedIframe?: Maybe<Scalars['Html']['output']>;
  /** The percentage completion for encoding this video expressed as a float value from 0.0 to 100.0. */
  encodingProgress: Scalars['Float']['output'];
  /** An instance of a possibly recurring meeting on an external calendar that this video is a recording of. */
  externalMeetingInstance?: Maybe<ExternalMeetingInstance>;
  /** If true, the video is shared externally and can be viewed by anyone with the link. */
  externalSharingEnabled: Scalars['Boolean']['output'];
  /** The video's highlights. */
  highlights?: Maybe<HighlightConnection>;
  /** The global ID for the video. */
  id: Scalars['ID']['output'];
  /** True if the video is a clip. */
  isClip: Scalars['Boolean']['output'];
  /** True if this video has been encoded successfully after upload. */
  isEncoded: Scalars['Boolean']['output'];
  /** True if the video has been liked by the current viewer. */
  isLiked: Scalars['Boolean']['output'];
  /** Deprecated: use savedForLater instead. */
  isQueued: Scalars['Boolean']['output'];
  /** Deprecated: use savedForLater instead. */
  isSavedToWatchlist: Scalars['Boolean']['output'];
  /** The users that have liked this video. */
  likedUsers?: Maybe<UserConnection>;
  /** The parent video of a clip */
  parentVideo?: Maybe<Video>;
  /** A URL for the video's main playlist. */
  playlistUrl?: Maybe<Scalars['Url']['output']>;
  /** The date time this video was presented. Defaults to its upload time. */
  presentedAt: Scalars['DateTime']['output'];
  /** True if the video is saved for later by the current viewer */
  savedForLater: Scalars['Boolean']['output'];
  /** The users and groups that have been directly granted access to this video. Will be null if viewer does not have edit access to video. */
  shareRecipients?: Maybe<SharedVideoRecipientConnection>;
  /** If true and the video is shared externally, then comments will be visible to anyone with the link. If false, comments will be hidden from non-members. */
  showCommentsToExternalViewers: Scalars['Boolean']['output'];
  /** Deprecated: use addedUsers instead. */
  taggedUsers?: Maybe<UserConnection>;
  /** A URL for the video's thumbnail image, if available. */
  thumbnailUrl?: Maybe<Scalars['Url']['output']>;
  /** The video's title. */
  title: Scalars['String']['output'];
  /** The video's transcript. */
  transcript?: Maybe<Transcript>;
  /** Identifies the date and time when the object was last updated. */
  updatedAt: Scalars['DateTime']['output'];
  /** The actor who uploaded the video. */
  uploader: Actor;
  /** The URL for the video on Rewatch. */
  url: Scalars['Url']['output'];
  /** If the viewer can edit this video. */
  viewerCanEdit: Scalars['Boolean']['output'];
  /** If the viewer has watched the video or not. */
  viewerHasWatched: Scalars['Boolean']['output'];
  /** The visibility of this video on the channel. */
  visibility: VideoVisibility;
  /** The video's zoom chats. */
  zoomChats?: Maybe<ZoomChatConnection>;
};

/** A video uploaded to your channel. */
export type VideoAddedUsersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A video uploaded to your channel. */
export type VideoAnalyticsArgs = {
  timeframe?: InputMaybe<AnalyticsTimeframe>;
};

/** A video uploaded to your channel. */
export type VideoAttachmentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A video uploaded to your channel. */
export type VideoChaptersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A video uploaded to your channel. */
export type VideoClipsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A video uploaded to your channel. */
export type VideoCollectionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['ID']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A video uploaded to your channel. */
export type VideoCommentThreadsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  includeRemoved?: InputMaybe<Scalars['Boolean']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A video uploaded to your channel. */
export type VideoHighlightsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A video uploaded to your channel. */
export type VideoLikedUsersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A video uploaded to your channel. */
export type VideoShareRecipientsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A video uploaded to your channel. */
export type VideoTaggedUsersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A video uploaded to your channel. */
export type VideoZoomChatsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** A video's analytics. */
export type VideoAnalytics = {
  __typename?: 'VideoAnalytics';
  /** The average time some watched the video for in seconds. */
  averageWatchTime?: Maybe<Scalars['Float']['output']>;
  /** How many people saw the video. */
  impressions?: Maybe<Scalars['Int']['output']>;
  /** The total number of plays including rewatches & embeds. */
  totalPlays?: Maybe<Scalars['Int']['output']>;
  /** A list of members who have pressed play. */
  uniquePlays?: Maybe<UserConnection>;
};

/** A video's analytics. */
export type VideoAnalyticsUniquePlaysArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** An attachment on a video. Either a directly uploaded file or an external link to another service. */
export type VideoAttachment = Node & {
  __typename?: 'VideoAttachment';
  /** The byte size for a directly uploaded file. Will be null for an external link. */
  byteSize?: Maybe<Scalars['Int']['output']>;
  /** Identifies the date and time when the object was created. */
  createdAt: Scalars['DateTime']['output'];
  /** The name of the file. */
  filename: Scalars['String']['output'];
  /** The global ID for the attachment. */
  id: Scalars['ID']['output'];
  /** Identifies the date and time when the object was last updated. */
  updatedAt: Scalars['DateTime']['output'];
  /** The URL to the file or the service. */
  url: Scalars['Url']['output'];
};

/** The connection type for VideoAttachment. */
export type VideoAttachmentConnection = {
  __typename?: 'VideoAttachmentConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<VideoAttachmentEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<VideoAttachment>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type VideoAttachmentEdge = {
  __typename?: 'VideoAttachmentEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<VideoAttachment>;
};

/** The connection type for Video. */
export type VideoConnection = {
  __typename?: 'VideoConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<VideoEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<Video>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type VideoEdge = {
  __typename?: 'VideoEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Video>;
};

/** The video access role granted to a user. */
export enum VideoGrantRole {
  /** This user has editor access. */
  Editor = 'EDITOR',
  /** This user viewer access. */
  Viewer = 'VIEWER',
}

/** Properties by which video connections can be ordered. */
export enum VideoOrderField {
  /** Order videos by when they were created. */
  CreatedAt = 'CREATED_AT',
  /** Order videos by when they were presented. */
  PresentedAt = 'PRESENTED_AT',
  /** Order videos by when they were updated. */
  UpdatedAt = 'UPDATED_AT',
}

/** Video access granted for recipient */
export type VideoShareInfo = {
  /** A recipient of a shared video. */
  recipientId: Scalars['ID']['input'];
  /** The video access role for the user. */
  role: VideoGrantRole;
};

export enum VideoVisibility {
  /** An unpublished video only visible to the uploader. */
  Draft = 'DRAFT',
  /** Only viewable for channel members with the share link. */
  LinkOnly = 'LINK_ONLY',
  /** All members are able to view it on the channel. */
  OnChannel = 'ON_CHANNEL',
  /** Only visible to channel admins and members of any secret collection the video has been added to. */
  Private = 'PRIVATE',
}

/** Ordering options for videos connections. */
export type VideosOrder = {
  /** The ordering direction. */
  direction: OrderDirection;
  /** The field by which to order videos. */
  field: VideoOrderField;
};

/** An entity, such as a user, querying the GraphQL API. */
export type Viewer = {
  /** The ID for the underlying concrete object. */
  id: Scalars['ID']['output'];
};

/** A webhook configured for your channel. */
export type Webhook = Node & {
  __typename?: 'Webhook';
  /** Identifies the date and time when the object was created. */
  createdAt: Scalars['DateTime']['output'];
  /** The actor who initially created this webhook. */
  creator: Actor;
  /** The deliveries for this webhook corresponding to the subscribed-to events occuring on the channel. */
  deliveries?: Maybe<WebhookDeliveryConnection>;
  /** A short description of the webhook. */
  description?: Maybe<Scalars['String']['output']>;
  /** A reason this webhook is disabled, if it is. */
  disabledReason?: Maybe<WebhookDisabledReason>;
  /** Whether or not deliveries will be sent for this webhook. */
  enabled: Scalars['Boolean']['output'];
  /** The events this webhook is subscribed to. */
  events: Array<WebhookEvent>;
  /** The global ID for the webhook. */
  id: Scalars['ID']['output'];
  /** The number of times this webhook will be retried if delivery fails. */
  retries: Scalars['Int']['output'];
  /** Identifies the date and time when the object was last updated. */
  updatedAt: Scalars['DateTime']['output'];
  /** The URL to deliver the webhook to. */
  url: Scalars['Url']['output'];
};

/** A webhook configured for your channel. */
export type WebhookDeliveriesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  nonces?: InputMaybe<Array<Scalars['String']['input']>>;
  orderBy?: InputMaybe<WebhookDeliveriesOrder>;
};

/** The connection type for Webhook. */
export type WebhookConnection = {
  __typename?: 'WebhookConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<WebhookEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<Webhook>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** Ordering options for webhook deliveries connections. */
export type WebhookDeliveriesOrder = {
  /** The ordering direction. */
  direction: OrderDirection;
  /** The field by which to order webhook deliveries. */
  field: WebhookDeliveryOrderField;
};

/** An event payload delivery for a webhook configured on your channel. */
export type WebhookDelivery = {
  __typename?: 'WebhookDelivery';
  /** A list of HTTP request attempt outcomes for this delivery. */
  attempts: Array<WebhookDeliveryAttempt>;
  /** The event that triggered this webhook delivery. */
  event: WebhookDeliveryEvent;
  /** A random unique value that may be used to deduplicate this delivery. */
  nonce: Scalars['String']['output'];
  /** The number of times this webhook delivery could be retried if delivery has failed. */
  retries: Scalars['Int']['output'];
  /** The outcome of the webhook delivery attempt. */
  status: WebhookDeliveryStatus;
  /** The URL the webhook was delivered to. */
  url: Scalars['Url']['output'];
};

/** The result of an event payload delivery attempt for a webhook configured on your channel. */
export type WebhookDeliveryAttempt = {
  __typename?: 'WebhookDeliveryAttempt';
  /** The date time this attempt was made. */
  at?: Maybe<Scalars['DateTime']['output']>;
  /** The HTTP response code returned by the remote server, if any. */
  code?: Maybe<Scalars['Int']['output']>;
  /** Further detail about the attempt, if present. */
  message?: Maybe<Scalars['String']['output']>;
  /** The outcome of the webhook delivery attempt. */
  result: WebhookDeliveryAttemptResult;
};

export enum WebhookDeliveryAttemptResult {
  /** Could not connect to the remote server or the connection was lost. */
  ConnectionError = 'CONNECTION_ERROR',
  /** The remote server responded with an HTTP error code. */
  RequestFailure = 'REQUEST_FAILURE',
  /** The delivery request timed out before the remote server responded. */
  RequestTimeout = 'REQUEST_TIMEOUT',
  /** The remote server responded with an HTTP success code. */
  Success = 'SUCCESS',
  /** The result of the delivery attempt is unknown. */
  Unknown = 'UNKNOWN',
}

/** The connection type for WebhookDelivery. */
export type WebhookDeliveryConnection = {
  __typename?: 'WebhookDeliveryConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<WebhookDeliveryEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<WebhookDelivery>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type WebhookDeliveryEdge = {
  __typename?: 'WebhookDeliveryEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<WebhookDelivery>;
};

export enum WebhookDeliveryEvent {
  /** A collection was created on the channel. */
  CollectionCreated = 'COLLECTION_CREATED',
  /** A collection on the channel was deleted. */
  CollectionDeleted = 'COLLECTION_DELETED',
  /** A collection's details or memberships were updated. */
  CollectionUpdated = 'COLLECTION_UPDATED',
  /** A video was added to the channel from draft state. */
  VideoAddedToChannel = 'VIDEO_ADDED_TO_CHANNEL',
  /** A video was removed from the channel. */
  VideoDeleted = 'VIDEO_DELETED',
  /** A video's collections, user taggings, or details were changed. */
  VideoUpdated = 'VIDEO_UPDATED',
}

/** Properties by which webhook delivery connections can be ordered. */
export enum WebhookDeliveryOrderField {
  /** Order webhook deliveries by when they were created. */
  CreatedAt = 'CREATED_AT',
}

export enum WebhookDeliveryStatus {
  /** The webhook delivery was attempted and failed and will not be retried further. */
  Failed = 'FAILED',
  /** The webhook delivery hasn't been attempted yet. */
  Pending = 'PENDING',
  /** The webhook delivery was attempted and failed and will be retried. */
  Retrying = 'RETRYING',
  /** The webhook delivery was attempted and the remote server responded with a successful status. */
  Succeeded = 'SUCCEEDED',
}

export enum WebhookDisabledReason {
  /** The webhook was disabled automatically due to an account status change. */
  AccountStatus = 'ACCOUNT_STATUS',
  /** The webhook was disabled automatically after delivery attempts failed for 30 days. */
  Failing = 'FAILING',
  /** The webhook was manually disabled by a channel admin. */
  Manual = 'MANUAL',
}

/** An edge in a connection. */
export type WebhookEdge = {
  __typename?: 'WebhookEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Webhook>;
};

export enum WebhookEvent {
  /** A collection was created, updated, or deleted. */
  Collection = 'COLLECTION',
  /** A comment was created, or removed. */
  Comment = 'COMMENT',
  /** A group was created, updated, or deleted. */
  Group = 'GROUP',
  /** A highlight was created, or deleted. */
  Highlight = 'HIGHLIGHT',
  /** A member was invited to the channel, joined, or deactivated. */
  Member = 'MEMBER',
  /** A video was added to the channel from draft state, its details were updated, or it was deleted. */
  Video = 'VIDEO',
}

/** Properties by which webhook connections can be ordered. */
export enum WebhookOrderField {
  /** Order webhooks by when they were created. */
  CreatedAt = 'CREATED_AT',
}

/** Ordering options for webhooks connections. */
export type WebhooksOrder = {
  /** The ordering direction. */
  direction: OrderDirection;
  /** The field by which to order webhooks. */
  field: WebhookOrderField;
};

/** A zoom chat comment left on a video. */
export type ZoomChat = Node & {
  __typename?: 'ZoomChat';
  /** The associated user who left the comment. */
  author?: Maybe<Actor>;
  /** The color hexadecimal (#FFFFFF) for the speaker avatar background. */
  avatarColor?: Maybe<Scalars['String']['output']>;
  /** The text content of the comment. */
  body: Scalars['String']['output'];
  /** Identifies the date and time when the object was created. */
  createdAt: Scalars['DateTime']['output'];
  /** The global ID for the chat. */
  id: Scalars['ID']['output'];
  /** The name of the author of this comment if no associated user. */
  speakerName: Scalars['String']['output'];
  /** The point in the video and transcript where the comment begins as an offset in milliseconds. */
  startTime: Scalars['Int']['output'];
  /** Identifies the date and time when the object was last updated. */
  updatedAt: Scalars['DateTime']['output'];
  /** The video the comment is on. */
  video: Video;
};

/** The connection type for ZoomChat. */
export type ZoomChatConnection = {
  __typename?: 'ZoomChatConnection';
  /** A list of edges. */
  edges?: Maybe<Array<Maybe<ZoomChatEdge>>>;
  /** A list of nodes. */
  nodes?: Maybe<Array<Maybe<ZoomChat>>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total unpaginated count of selected nodes. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type ZoomChatEdge = {
  __typename?: 'ZoomChatEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<ZoomChat>;
};

/** A zoom video that is available to import. */
export type ZoomVideo = Node & {
  __typename?: 'ZoomVideo';
  /** Identifies the date and time when the object was created. */
  createdAt: Scalars['DateTime']['output'];
  /** The global ID for the zoom video. */
  id: Scalars['ID']['output'];
  /** Identifies the date and time when the object was last updated. */
  updatedAt: Scalars['DateTime']['output'];
  /** The url to import the zoom video. */
  url: Scalars['Url']['output'];
  /** The user who is the host of the zoom meeting. */
  user: User;
};

export type SubscribeMutationVariables = Exact<{
  input: CreateWebhookInput;
}>;

export type SubscribeMutation = {
  __typename?: 'Mutation';
  createWebhook?: {
    __typename?: 'CreateWebhookPayload';
    viewer: { __typename?: 'User'; id: string };
    webhook?: { __typename?: 'Webhook'; id: string; enabled: boolean } | null;
    errors: Array<
      | { __typename?: 'NotFoundError'; message: string; path?: Array<string> | null }
      | { __typename?: 'PermissionError'; message: string; path?: Array<string> | null }
      | { __typename?: 'ValidationError'; message: string; path?: Array<string> | null }
    >;
  } | null;
};

export type UnsubscribeMutationVariables = Exact<{
  input: DeleteWebhookInput;
}>;

export type UnsubscribeMutation = {
  __typename?: 'Mutation';
  deleteWebhook?: {
    __typename?: 'DeleteWebhookPayload';
    viewer: { __typename?: 'User'; id: string };
    errors: Array<
      | { __typename?: 'NotFoundError'; message: string; path?: Array<string> | null }
      | { __typename?: 'PermissionError'; message: string; path?: Array<string> | null }
      | { __typename?: 'ValidationError'; message: string; path?: Array<string> | null }
    >;
  } | null;
};

export type CurrentChannelQueryVariables = Exact<{
  id: Scalars['ID']['input'];
}>;

export type CurrentChannelQuery = {
  __typename?: 'Query';
  channel: {
    __typename?: 'Channel';
    subdomain: string;
    user?: { __typename?: 'User'; id: string; channelRole: ChannelRole } | null;
  };
};

export type VideoQueryVariables = Exact<{
  id: Scalars['ID']['input'];
}>;

export type VideoQuery = {
  __typename?: 'Query';
  node?:
    | { __typename: 'ActionItem' }
    | { __typename: 'Chapter' }
    | { __typename: 'Collection' }
    | { __typename: 'Comment' }
    | { __typename: 'Group' }
    | { __typename: 'Highlight' }
    | { __typename: 'QueueItem' }
    | { __typename: 'Tag' }
    | { __typename: 'Tagging' }
    | { __typename: 'UnknownUser' }
    | { __typename: 'User' }
    | {
        __typename: 'Video';
        id: string;
        title: string;
        description?: string | null;
        presentedAt: any;
        duration?: number | null;
        url: any;
        thumbnailUrl?: any | null;
        attendeesInfo: Array<any>;
      }
    | { __typename: 'VideoAttachment' }
    | { __typename: 'Webhook' }
    | { __typename: 'ZoomChat' }
    | { __typename: 'ZoomVideo' }
    | null;
};

export type CurrentViewerQueryVariables = Exact<{ [key: string]: never }>;

export type CurrentViewerQuery = { __typename?: 'Query'; viewer: { __typename?: 'User'; id: string } };

export type WebhookQueryVariables = Exact<{
  id: Scalars['ID']['input'];
}>;

export type WebhookQuery = {
  __typename?: 'Query';
  node?:
    | { __typename?: 'ActionItem' }
    | { __typename?: 'Chapter' }
    | { __typename?: 'Collection' }
    | { __typename?: 'Comment' }
    | { __typename?: 'Group' }
    | { __typename?: 'Highlight' }
    | { __typename?: 'QueueItem' }
    | { __typename?: 'Tag' }
    | { __typename?: 'Tagging' }
    | { __typename?: 'UnknownUser' }
    | { __typename?: 'User' }
    | { __typename?: 'Video' }
    | { __typename?: 'VideoAttachment' }
    | { __typename: 'Webhook'; id: string; enabled: boolean; disabledReason?: WebhookDisabledReason | null }
    | { __typename?: 'ZoomChat' }
    | { __typename?: 'ZoomVideo' }
    | null;
};

export const SubscribeDocument = gql`
  mutation Subscribe($input: CreateWebhookInput!) {
    createWebhook(input: $input) {
      viewer {
        id
      }
      webhook {
        id
        enabled
      }
      errors {
        message
        path
      }
    }
  }
`;
export const UnsubscribeDocument = gql`
  mutation Unsubscribe($input: DeleteWebhookInput!) {
    deleteWebhook(input: $input) {
      viewer {
        id
      }
      errors {
        message
        path
      }
    }
  }
`;
export const CurrentChannelDocument = gql`
  query CurrentChannel($id: ID!) {
    channel {
      subdomain
      user(id: $id) {
        id
        channelRole
      }
    }
  }
`;
export const VideoDocument = gql`
  query Video($id: ID!) {
    node(id: $id) {
      __typename
      ... on Video {
        id
        title
        description
        presentedAt
        duration
        url
        thumbnailUrl
        attendeesInfo
      }
    }
  }
`;
export const CurrentViewerDocument = gql`
  query CurrentViewer {
    viewer {
      id
    }
  }
`;
export const WebhookDocument = gql`
  query Webhook($id: ID!) {
    node(id: $id) {
      ... on Webhook {
        __typename
        id
        enabled
        disabledReason
      }
    }
  }
`;

export type SdkFunctionWrapper = <T>(
  action: (requestHeaders?: Record<string, string>) => Promise<T>,
  operationName: string,
  operationType?: string,
  variables?: any,
) => Promise<T>;

const defaultWrapper: SdkFunctionWrapper = (action, _operationName, _operationType, _variables) => action();

export function getSdk(client: GraphQLClient, withWrapper: SdkFunctionWrapper = defaultWrapper) {
  return {
    Subscribe(
      variables: SubscribeMutationVariables,
      requestHeaders?: GraphQLClientRequestHeaders,
    ): Promise<SubscribeMutation> {
      return withWrapper(
        wrappedRequestHeaders =>
          client.request<SubscribeMutation>(SubscribeDocument, variables, {
            ...requestHeaders,
            ...wrappedRequestHeaders,
          }),
        'Subscribe',
        'mutation',
        variables,
      );
    },
    Unsubscribe(
      variables: UnsubscribeMutationVariables,
      requestHeaders?: GraphQLClientRequestHeaders,
    ): Promise<UnsubscribeMutation> {
      return withWrapper(
        wrappedRequestHeaders =>
          client.request<UnsubscribeMutation>(UnsubscribeDocument, variables, {
            ...requestHeaders,
            ...wrappedRequestHeaders,
          }),
        'Unsubscribe',
        'mutation',
        variables,
      );
    },
    CurrentChannel(
      variables: CurrentChannelQueryVariables,
      requestHeaders?: GraphQLClientRequestHeaders,
    ): Promise<CurrentChannelQuery> {
      return withWrapper(
        wrappedRequestHeaders =>
          client.request<CurrentChannelQuery>(CurrentChannelDocument, variables, {
            ...requestHeaders,
            ...wrappedRequestHeaders,
          }),
        'CurrentChannel',
        'query',
        variables,
      );
    },
    Video(variables: VideoQueryVariables, requestHeaders?: GraphQLClientRequestHeaders): Promise<VideoQuery> {
      return withWrapper(
        wrappedRequestHeaders =>
          client.request<VideoQuery>(VideoDocument, variables, { ...requestHeaders, ...wrappedRequestHeaders }),
        'Video',
        'query',
        variables,
      );
    },
    CurrentViewer(
      variables?: CurrentViewerQueryVariables,
      requestHeaders?: GraphQLClientRequestHeaders,
    ): Promise<CurrentViewerQuery> {
      return withWrapper(
        wrappedRequestHeaders =>
          client.request<CurrentViewerQuery>(CurrentViewerDocument, variables, {
            ...requestHeaders,
            ...wrappedRequestHeaders,
          }),
        'CurrentViewer',
        'query',
        variables,
      );
    },
    Webhook(variables: WebhookQueryVariables, requestHeaders?: GraphQLClientRequestHeaders): Promise<WebhookQuery> {
      return withWrapper(
        wrappedRequestHeaders =>
          client.request<WebhookQuery>(WebhookDocument, variables, { ...requestHeaders, ...wrappedRequestHeaders }),
        'Webhook',
        'query',
        variables,
      );
    },
  };
}
export type Sdk = ReturnType<typeof getSdk>;
