// Generated by ts-to-zod
import { z } from 'zod';

export const entityNameSchema = z.union([
  z.literal('Account'),
  z.literal('Purchase'),
  z.literal('JournalEntry'),
  z.literal('Invoice'),
  z.literal('Payment'),
  z.literal('Bill'),
  z.literal('BillPayment'),
  z.literal('CreditMemo'),
  z.literal('Deposit'),
  z.literal('Transfer'),
  z.literal('Vendor'),
  z.literal('Customer'),
  z.literal('Item'),
  z.literal('CompanyInfo'),
]);

export const accountSchema = z.object({
  Id: z.string(),
  domain: z.string(),
  status: z.literal('deleted').optional(),
  Metadata: z.object({
    CreateTime: z.string(),
    LastUpdatedTime: z.string(),
  }),
  AccountSubType: z.string(),
  AccountType: z.string(),
  Active: z.boolean(),
  Classification: z.union([
    z.literal('Asset'),
    z.literal('Equity'),
    z.literal('Expense'),
    z.literal('Liability'),
    z.literal('Revenue'),
  ]),
  CurrencyRef: z.object({
    name: z.string(),
    value: z.string(),
  }),
  CurrentBalance: z.number(),
  CurrentBalanceWithSubAccounts: z.number(),
  FullyQualifiedName: z.string(),
  Name: z.string(),
  SubAccount: z.boolean(),
  SyncToken: z.string(),
  sparse: z.boolean(),
});

export const statusSchema = z.literal('deleted');

export const purchaseSchema = z.object({
  Id: z.string(),
  domain: z.string(),
  status: z.literal('deleted').optional(),
  Metadata: z.object({
    CreateTime: z.string(),
    LastUpdatedTime: z.string(),
  }),
  AccountRef: z.object({
    value: z.string(),
    name: z.string(),
  }),
  PaymentMethodRef: z
    .object({
      value: z.string(),
    })
    .optional(),
  PaymentType: z.string(),
  EntityRef: z
    .object({
      value: z.string(),
      name: z.string(),
      type: z.string().optional(),
    })
    .optional(),
  Credit: z.boolean().optional(),
  TotalAmt: z.number(),
  PurchaseEx: z.object({
    any: z.array(
      z.object({
        name: z.string(),
        declaredType: z.string(),
        scope: z.string(),
        value: z.object({
          Name: z.string(),
          Value: z.string(),
        }),
        nil: z.boolean(),
        globalScope: z.boolean(),
        typeSubstituted: z.boolean(),
      }),
    ),
  }),
  sparse: z.boolean(),
  SyncToken: z.string(),
  TxnDate: z.string(),
  CurrencyRef: z.object({
    name: z.string(),
    value: z.string(),
  }),
  PrivateNote: z.string(),
  Line: z.array(
    z.object({
      Id: z.string(),
      Description: z.string(),
      Amount: z.number(),
      DetailType: z.string(),
      AccountBasedExpenseLineDetail: z
        .object({
          AccountRef: z.object({
            value: z.string(),
            name: z.string(),
          }),
          BillableStatus: z.string(),
          TaxCodeRef: z.object({
            value: z.string(),
          }),
          CustomerRef: z
            .object({
              value: z.string(),
              name: z.string(),
            })
            .optional(),
        })
        .optional(),
    }),
  ),
  DocNumber: z.string().optional(),
});

export const journalEntrySchema = z.object({
  Id: z.string(),
  domain: z.string(),
  status: z.literal('deleted').optional(),
  Metadata: z.object({
    CreateTime: z.string(),
    LastUpdatedTime: z.string(),
  }),
  Adjustment: z.boolean(),
  sparse: z.boolean(),
  SyncToken: z.string(),
  DocNumber: z.string(),
  TxnDate: z.string(),
  CurrencyRef: z.object({
    name: z.string(),
    value: z.string(),
  }),
  PrivateNote: z.string().optional(),
  Line: z.array(
    z.object({
      Id: z.string(),
      Description: z.string(),
      Amount: z.number(),
      DetailType: z.string(),
      JournalEntryLineDetail: z.object({
        PostingType: z.union([z.literal('Debit'), z.literal('Credit')]),
        Entity: z
          .object({
            Type: z.string(),
            EntityRef: z.object({
              value: z.string(),
              name: z.string(),
              type: z.string().optional(),
            }),
          })
          .optional(),
        AccountRef: z.object({
          value: z.string(),
          name: z.string(),
        }),
      }),
    }),
  ),
});

export const invoiceSchema = z.object({
  Id: z.string(),
  domain: z.string(),
  status: z.literal('deleted').optional(),
  Metadata: z.object({
    CreateTime: z.string(),
    LastUpdatedTime: z.string(),
  }),
  AllowIPNPayment: z.boolean(),
  AllowOnlineACHPayment: z.boolean(),
  AllowOnlineCreditCardPayment: z.boolean(),
  AllowOnlinePayment: z.boolean(),
  ApplyTaxAfterDiscount: z.boolean(),
  Balance: z.number(),
  CurrencyRef: z.object({
    name: z.string(),
    value: z.string(),
  }),
  CustomField: z.array(z.unknown()),
  CustomerRef: z.object({
    value: z.string(),
    name: z.string(),
  }),
  Deposit: z.number(),
  DocNumber: z.string(),
  DueDate: z.string(),
  EmailStatus: z.string(),
  Line: z.array(
    z.object({
      Amount: z.number(),
      Description: z.string().optional(),
      DetailType: z.string(),
      Id: z.string().optional(),
      LineNum: z.number().optional(),
      SalesItemLineDetail: z
        .object({
          ItemRef: z.object({
            name: z.string(),
            value: z.string(),
          }),
          Qty: z.number(),
          TaxCodeRef: z.object({
            value: z.string(),
          }),
        })
        .optional(),
      SubTotalLineDetail: z.record(z.unknown()).optional(),
      DiscountLineDetail: z
        .object({
          DiscountAccountRef: z.object({
            name: z.string(),
            value: z.string(),
          }),
        })
        .optional(),
    }),
  ),
  LinkedTxn: z.array(
    z.object({
      TxnId: z.string(),
      TxnType: z.string(),
    }),
  ),
  PrintStatus: z.string(),
  PrivateNote: z.string(),
  SyncToken: z.string(),
  TotalAmt: z.number(),
  TxnDate: z.string(),
  sparse: z.boolean(),
});

export const paymentSchema = z.object({
  Id: z.string(),
  domain: z.string(),
  status: z.literal('deleted').optional(),
  Metadata: z.object({
    CreateTime: z.string(),
    LastUpdatedTime: z.string(),
  }),
  CurrencyRef: z.object({
    name: z.string(),
    value: z.string(),
  }),
  CustomerRef: z.object({
    value: z.string(),
    name: z.string(),
  }),
  DepositToAccountRef: z
    .object({
      value: z.string(),
    })
    .optional(),
  Line: z.array(
    z.object({
      Amount: z.number(),
      LineEx: z.object({
        any: z.array(
          z.object({
            declaredType: z.string(),
            globalScope: z.boolean(),
            name: z.string(),
            nil: z.boolean(),
            scope: z.string(),
            typeSubstituted: z.boolean(),
            value: z.object({
              Name: z.string(),
              Value: z.string(),
            }),
          }),
        ),
      }),
      LinkedTxn: z.array(
        z.object({
          TxnId: z.string(),
          TxnType: z.string(),
        }),
      ),
    }),
  ),
  PrivateNote: z.string(),
  ProcessPayment: z.boolean(),
  SyncToken: z.string(),
  TotalAmt: z.number(),
  TxnDate: z.string(),
  UnappliedAmt: z.number(),
  sparse: z.boolean(),
});

export const depositSchema = z.object({
  Id: z.string(),
  domain: z.string(),
  status: z.literal('deleted').optional(),
  Metadata: z.object({
    CreateTime: z.string(),
    LastUpdatedTime: z.string(),
  }),
  CurrencyRef: z.object({
    name: z.string(),
    value: z.string(),
  }),
  DepositToAccountRef: z.object({
    name: z.string(),
    value: z.string(),
  }),
  Line: z.array(
    z.object({
      Amount: z.number(),
      DepositLineDetail: z
        .object({
          AccountRef: z
            .object({
              value: z.string(),
              name: z.string(),
            })
            .optional(),
          Entity: z
            .object({
              Type: z.string(),
              EntityRef: z.object({
                value: z.string(),
                name: z.string(),
                type: z.string().optional(),
              }),
            })
            .optional(),
        })
        .optional(),
      Description: z.string(),
      DetailType: z.string(),
      Id: z.string(),
      LineNum: z.number(),
    }),
  ),
  PrivateNote: z.string(),
  SyncToken: z.string(),
  TotalAmt: z.number(),
  TxnDate: z.string(),
  sparse: z.boolean(),
});

export const vendorSchema = z.object({
  Id: z.string(),
  domain: z.string(),
  status: z.literal('deleted').optional(),
  Metadata: z.object({
    CreateTime: z.string(),
    LastUpdatedTime: z.string(),
  }),
  DisplayName: z.string(),
  PrintOnCheckName: z.string().optional(),
});

export const companyInfoSchema = z.object({
  CompanyName: z.string(),
  LegalName: z.string(),
  CompanyAddr: z.object({
    Id: z.string(),
    Line1: z.string(),
    City: z.string(),
    Country: z.string(),
    CountrySubDivisionCode: z.string(),
    PostalCode: z.string(),
  }),
  CustomerCommunicationAddr: z.object({
    Id: z.string(),
    Line1: z.string(),
    City: z.string(),
    Country: z.string(),
    CountrySubDivisionCode: z.string(),
    PostalCode: z.string(),
  }),
  LegalAddr: z.object({
    Id: z.string(),
    Line1: z.string(),
    City: z.string(),
    Country: z.string(),
    CountrySubDivisionCode: z.string(),
    PostalCode: z.string(),
  }),
  PrimaryPhone: z.object({
    FreeFormNumber: z.string(),
  }),
  CompanyStartDate: z.string(),
  FiscalYearStartMonth: z.string(),
  Country: z.string(),
  Email: z.object({
    Address: z.string(),
  }),
  WebAddr: z.record(z.unknown()),
  SupportedLanguages: z.string(),
  NameValue: z.array(
    z.object({
      Name: z.string(),
      Value: z.string(),
    }),
  ),
  domain: z.string(),
  sparse: z.boolean(),
  Id: z.string(),
  SyncToken: z.string(),
  MetaData: z.object({
    CreateTime: z.string(),
    LastUpdatedTime: z.string(),
  }),
});

export const queryResponseSchema = z.object({
  CompanyInfo: z.array(companyInfoSchema).optional(),
  Account: z.array(accountSchema).optional(),
  JournalEntry: z.array(journalEntrySchema).optional(),
  Purchase: z.array(purchaseSchema).optional(),
  Deposit: z.array(depositSchema).optional(),
  Payment: z.array(paymentSchema).optional(),
  Invoice: z.array(invoiceSchema).optional(),
  Vendor: z.array(vendorSchema).optional(),
  Bill: z.array(z.unknown()).optional(),
  BillPayment: z.array(z.unknown()).optional(),
  CreditMemo: z.array(z.unknown()).optional(),
  Transfer: z.array(z.unknown()).optional(),
  Customer: z.array(z.unknown()).optional(),
  Item: z.array(z.unknown()).optional(),
  maxResults: z.number(),
  startPosition: z.number(),
  totalCount: z.number().optional(),
});

export const reportSchema = z.object({
  Header: z.object({
    Time: z.string(),
    ReportName: z.string(),
    DateMacro: z.string(),
    StartPeriod: z.string(),
    EndPeriod: z.string(),
    Currency: z.string(),
    Option: z.array(
      z.object({
        Name: z.string(),
        Value: z.string(),
      }),
    ),
  }),
  Columns: z.object({
    Column: z.array(
      z.object({
        ColTitle: z.string(),
        ColType: z.string(),
      }),
    ),
  }),
  Rows: z.array(
    z.object({
      Row: z.array(
        z.object({
          ColData: z.array(
            z.object({
              value: z.string(),
              id: z.string().optional(),
            }),
          ),
          type: z.string(),
        }),
      ),
    }),
  ),
});

export const cDCPayloadSchema = z.object({
  CDCResponse: z.array(
    z.object({
      QueryResponse: z.array(queryResponseSchema),
    }),
  ),
  time: z.string(),
});

export const getAccountDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getAccountResponseSchema = z.object({
  Account: accountSchema,
  time: z.string(),
});

export const getAccountErrorSchema = z.unknown();

export const getPurchaseDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getPurchaseResponseSchema = z.object({
  Purchase: purchaseSchema,
  time: z.string(),
});

export const getPurchaseErrorSchema = z.unknown();

export const getJournalEntryDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getJournalEntryResponseSchema = z.object({
  JournalEntry: journalEntrySchema,
  time: z.string(),
});

export const getJournalEntryErrorSchema = z.unknown();

export const getInvoiceDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getInvoiceResponseSchema = z.object({
  Invoice: invoiceSchema,
  time: z.string(),
});

export const getInvoiceErrorSchema = z.unknown();

export const getPaymentDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getPaymentResponseSchema = z.object({
  Payment: paymentSchema,
  time: z.string(),
});

export const getPaymentErrorSchema = z.unknown();

export const getBillDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getBillResponseSchema = z.object({
  Bill: z.unknown().optional(),
  time: z.string(),
});

export const getBillErrorSchema = z.unknown();

export const getBillPaymentDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getBillPaymentResponseSchema = z.object({
  BillPayment: z.unknown().optional(),
  time: z.string(),
});

export const getBillPaymentErrorSchema = z.unknown();

export const getCreditMemoDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getCreditMemoResponseSchema = z.object({
  CreditMemo: z.unknown().optional(),
  time: z.string(),
});

export const getCreditMemoErrorSchema = z.unknown();

export const getDepositDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getDepositResponseSchema = z.object({
  Deposit: depositSchema,
  time: z.string(),
});

export const getDepositErrorSchema = z.unknown();

export const getTransferDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getTransferResponseSchema = z.object({
  Transfer: z.unknown().optional(),
  time: z.string(),
});

export const getTransferErrorSchema = z.unknown();

export const getVendorDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getVendorResponseSchema = z.object({
  Vendor: vendorSchema,
  time: z.string(),
});

export const getVendorErrorSchema = z.unknown();

export const getCustomerDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getCustomerResponseSchema = z.object({
  Customer: z.unknown().optional(),
  time: z.string(),
});

export const getCustomerErrorSchema = z.unknown();

export const getItemDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getItemResponseSchema = z.object({
  Item: z.unknown().optional(),
  time: z.string(),
});

export const getItemErrorSchema = z.unknown();

export const getCompanyInfoDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getCompanyInfoResponseSchema = z.object({
  CompanyInfo: companyInfoSchema,
  time: z.string(),
});

export const getCompanyInfoErrorSchema = z.unknown();

export const queryDataSchema = z.object({
  query: z.object({
    query: z.string(),
  }),
});

export const queryResponse2Schema = z.object({
  QueryResponse: queryResponseSchema,
  time: z.string(),
});

export const queryErrorSchema = z.unknown();

export const getPreferencesDataSchema = z.unknown();

export const getPreferencesResponseSchema = z.unknown();

export const getPreferencesErrorSchema = z.unknown();

export const getTransactionListDataSchema = z.unknown();

export const getTransactionListResponseSchema = reportSchema;

export const getTransactionListErrorSchema = z.unknown();

export const cdcDataSchema = z.object({
  query: z.object({
    changedSince: z.string(),
    entities: z.string(),
  }),
});

export const cdcResponseSchema = cDCPayloadSchema;

export const cdcErrorSchema = z.unknown();
