// This file is auto-generated by @hey-api/openapi-ts

export type EntityName =
  | 'Account'
  | 'Purchase'
  | 'JournalEntry'
  | 'Invoice'
  | 'Payment'
  | 'Bill'
  | 'BillPayment'
  | 'CreditMemo'
  | 'Deposit'
  | 'Transfer'
  | 'Vendor'
  | 'Customer'
  | 'Item'
  | 'CompanyInfo';

export type Account = {
  Id: string;
  domain: string;
  status?: 'deleted';
  Metadata: {
    CreateTime: string;
    LastUpdatedTime: string;
  };
  AccountSubType: string;
  AccountType: string;
  Active: boolean;
  Classification: 'Asset' | 'Equity' | 'Expense' | 'Liability' | 'Revenue';
  CurrencyRef: {
    name: string;
    value: string;
  };
  CurrentBalance: number;
  CurrentBalanceWithSubAccounts: number;
  FullyQualifiedName: string;
  Name: string;
  SubAccount: boolean;
  SyncToken: string;
  sparse: boolean;
};

export type status = 'deleted';

export type Purchase = {
  Id: string;
  domain: string;
  status?: 'deleted';
  Metadata: {
    CreateTime: string;
    LastUpdatedTime: string;
  };
  AccountRef: {
    value: string;
    name: string;
  };
  PaymentMethodRef?: {
    value: string;
  };
  PaymentType: string;
  EntityRef?: {
    value: string;
    name: string;
    type?: string;
  };
  Credit?: boolean;
  TotalAmt: number;
  PurchaseEx: {
    any: Array<{
      name: string;
      declaredType: string;
      scope: string;
      value: {
        Name: string;
        Value: string;
      };
      nil: boolean;
      globalScope: boolean;
      typeSubstituted: boolean;
    }>;
  };
  sparse: boolean;
  SyncToken: string;
  TxnDate: string;
  CurrencyRef: {
    name: string;
    value: string;
  };
  PrivateNote: string;
  Line: Array<{
    Id: string;
    Description: string;
    Amount: number;
    DetailType: string;
    AccountBasedExpenseLineDetail?: {
      AccountRef: {
        value: string;
        name: string;
      };
      BillableStatus: string;
      TaxCodeRef: {
        value: string;
      };
      CustomerRef?: {
        value: string;
        name: string;
      };
    };
  }>;
  DocNumber?: string;
};

export type JournalEntry = {
  Id: string;
  domain: string;
  status?: 'deleted';
  Metadata: {
    CreateTime: string;
    LastUpdatedTime: string;
  };
  Adjustment: boolean;
  sparse: boolean;
  SyncToken: string;
  DocNumber: string;
  TxnDate: string;
  CurrencyRef: {
    name: string;
    value: string;
  };
  PrivateNote?: string;
  Line: Array<{
    Id: string;
    Description: string;
    Amount: number;
    DetailType: string;
    JournalEntryLineDetail: {
      PostingType: 'Debit' | 'Credit';
      Entity?: {
        Type: string;
        EntityRef: {
          value: string;
          name: string;
          type?: string;
        };
      };
      AccountRef: {
        value: string;
        name: string;
      };
    };
  }>;
};

export type Invoice = {
  Id: string;
  domain: string;
  status?: 'deleted';
  Metadata: {
    CreateTime: string;
    LastUpdatedTime: string;
  };
  AllowIPNPayment: boolean;
  AllowOnlineACHPayment: boolean;
  AllowOnlineCreditCardPayment: boolean;
  AllowOnlinePayment: boolean;
  ApplyTaxAfterDiscount: boolean;
  Balance: number;
  CurrencyRef: {
    name: string;
    value: string;
  };
  CustomField: Array<unknown>;
  CustomerRef: {
    value: string;
    name: string;
  };
  Deposit: number;
  DocNumber: string;
  DueDate: string;
  EmailStatus: string;
  Line: Array<{
    Amount: number;
    Description?: string;
    DetailType: string;
    Id?: string;
    LineNum?: number;
    SalesItemLineDetail?: {
      ItemRef: {
        name: string;
        value: string;
      };
      Qty: number;
      TaxCodeRef: {
        value: string;
      };
    };
    SubTotalLineDetail?: {
      [key: string]: unknown;
    };
    DiscountLineDetail?: {
      DiscountAccountRef: {
        name: string;
        value: string;
      };
    };
  }>;
  LinkedTxn: Array<{
    TxnId: string;
    TxnType: string;
  }>;
  PrintStatus: string;
  PrivateNote: string;
  SyncToken: string;
  TotalAmt: number;
  TxnDate: string;
  sparse: boolean;
};

export type Payment = {
  Id: string;
  domain: string;
  status?: 'deleted';
  Metadata: {
    CreateTime: string;
    LastUpdatedTime: string;
  };
  CurrencyRef: {
    name: string;
    value: string;
  };
  CustomerRef: {
    value: string;
    name: string;
  };
  DepositToAccountRef?: {
    value: string;
  };
  Line: Array<{
    Amount: number;
    LineEx: {
      any: Array<{
        declaredType: string;
        globalScope: boolean;
        name: string;
        nil: boolean;
        scope: string;
        typeSubstituted: boolean;
        value: {
          Name: string;
          Value: string;
        };
      }>;
    };
    LinkedTxn: Array<{
      TxnId: string;
      TxnType: string;
    }>;
  }>;
  PrivateNote: string;
  ProcessPayment: boolean;
  SyncToken: string;
  TotalAmt: number;
  TxnDate: string;
  UnappliedAmt: number;
  sparse: boolean;
};

export type Deposit = {
  Id: string;
  domain: string;
  status?: 'deleted';
  Metadata: {
    CreateTime: string;
    LastUpdatedTime: string;
  };
  CurrencyRef: {
    name: string;
    value: string;
  };
  DepositToAccountRef: {
    name: string;
    value: string;
  };
  Line: Array<{
    Amount: number;
    DepositLineDetail?: {
      AccountRef?: {
        value: string;
        name: string;
      };
      Entity?: {
        Type: string;
        EntityRef: {
          value: string;
          name: string;
          type?: string;
        };
      };
    };
    Description: string;
    DetailType: string;
    Id: string;
    LineNum: number;
  }>;
  PrivateNote: string;
  SyncToken: string;
  TotalAmt: number;
  TxnDate: string;
  sparse: boolean;
};

export type Vendor = {
  Id: string;
  domain: string;
  status?: 'deleted';
  Metadata: {
    CreateTime: string;
    LastUpdatedTime: string;
  };
  DisplayName: string;
  PrintOnCheckName?: string;
};

export type CompanyInfo = {
  CompanyName: string;
  LegalName: string;
  CompanyAddr: {
    Id: string;
    Line1: string;
    City: string;
    Country: string;
    CountrySubDivisionCode: string;
    PostalCode: string;
  };
  CustomerCommunicationAddr: {
    Id: string;
    Line1: string;
    City: string;
    Country: string;
    CountrySubDivisionCode: string;
    PostalCode: string;
  };
  LegalAddr: {
    Id: string;
    Line1: string;
    City: string;
    Country: string;
    CountrySubDivisionCode: string;
    PostalCode: string;
  };
  PrimaryPhone: {
    FreeFormNumber: string;
  };
  CompanyStartDate: string;
  FiscalYearStartMonth: string;
  Country: string;
  Email: {
    Address: string;
  };
  WebAddr: {
    [key: string]: unknown;
  };
  SupportedLanguages: string;
  NameValue: Array<{
    Name: string;
    Value: string;
  }>;
  domain: string;
  sparse: boolean;
  Id: string;
  SyncToken: string;
  MetaData: {
    CreateTime: string;
    LastUpdatedTime: string;
  };
};

export type QueryResponse = {
  CompanyInfo?: Array<CompanyInfo>;
  Account?: Array<Account>;
  JournalEntry?: Array<JournalEntry>;
  Purchase?: Array<Purchase>;
  Deposit?: Array<Deposit>;
  Payment?: Array<Payment>;
  Invoice?: Array<Invoice>;
  Vendor?: Array<Vendor>;
  Bill?: Array<unknown>;
  BillPayment?: Array<unknown>;
  CreditMemo?: Array<unknown>;
  Transfer?: Array<unknown>;
  Customer?: Array<unknown>;
  Item?: Array<unknown>;
  maxResults: number;
  startPosition: number;
  totalCount?: number;
};

export type Report = {
  Header: {
    Time: string;
    ReportName: string;
    DateMacro: string;
    StartPeriod: string;
    EndPeriod: string;
    Currency: string;
    Option: Array<{
      Name: string;
      Value: string;
    }>;
  };
  Columns: {
    Column: Array<{
      ColTitle: string;
      ColType: string;
    }>;
  };
  Rows: Array<{
    Row: Array<{
      ColData: Array<{
        value: string;
        id?: string;
      }>;
      type: string;
    }>;
  }>;
};

export type CDCPayload = {
  CDCResponse: Array<{
    QueryResponse: Array<QueryResponse>;
  }>;
  time: string;
};

export type GetAccountData = {
  path: {
    id: string;
  };
};

export type GetAccountResponse = {
  Account: Account;
  time: string;
};

export type GetAccountError = unknown;

export type GetPurchaseData = {
  path: {
    id: string;
  };
};

export type GetPurchaseResponse = {
  Purchase: Purchase;
  time: string;
};

export type GetPurchaseError = unknown;

export type GetJournalEntryData = {
  path: {
    id: string;
  };
};

export type GetJournalEntryResponse = {
  JournalEntry: JournalEntry;
  time: string;
};

export type GetJournalEntryError = unknown;

export type GetInvoiceData = {
  path: {
    id: string;
  };
};

export type GetInvoiceResponse = {
  Invoice: Invoice;
  time: string;
};

export type GetInvoiceError = unknown;

export type GetPaymentData = {
  path: {
    id: string;
  };
};

export type GetPaymentResponse = {
  Payment: Payment;
  time: string;
};

export type GetPaymentError = unknown;

export type GetBillData = {
  path: {
    id: string;
  };
};

export type GetBillResponse = {
  Bill?: unknown;
  time: string;
};

export type GetBillError = unknown;

export type GetBillPaymentData = {
  path: {
    id: string;
  };
};

export type GetBillPaymentResponse = {
  BillPayment?: unknown;
  time: string;
};

export type GetBillPaymentError = unknown;

export type GetCreditMemoData = {
  path: {
    id: string;
  };
};

export type GetCreditMemoResponse = {
  CreditMemo?: unknown;
  time: string;
};

export type GetCreditMemoError = unknown;

export type GetDepositData = {
  path: {
    id: string;
  };
};

export type GetDepositResponse = {
  Deposit: Deposit;
  time: string;
};

export type GetDepositError = unknown;

export type GetTransferData = {
  path: {
    id: string;
  };
};

export type GetTransferResponse = {
  Transfer?: unknown;
  time: string;
};

export type GetTransferError = unknown;

export type GetVendorData = {
  path: {
    id: string;
  };
};

export type GetVendorResponse = {
  Vendor: Vendor;
  time: string;
};

export type GetVendorError = unknown;

export type GetCustomerData = {
  path: {
    id: string;
  };
};

export type GetCustomerResponse = {
  Customer?: unknown;
  time: string;
};

export type GetCustomerError = unknown;

export type GetItemData = {
  path: {
    id: string;
  };
};

export type GetItemResponse = {
  Item?: unknown;
  time: string;
};

export type GetItemError = unknown;

export type GetCompanyInfoData = {
  path: {
    id: string;
  };
};

export type GetCompanyInfoResponse = {
  CompanyInfo: CompanyInfo;
  time: string;
};

export type GetCompanyInfoError = unknown;

export type QueryData = {
  query: {
    query: string;
  };
};

export type QueryResponse2 = {
  QueryResponse: QueryResponse;
  time: string;
};

export type QueryError = unknown;

export type GetPreferencesData = unknown;

export type GetPreferencesResponse = unknown;

export type GetPreferencesError = unknown;

export type GetTransactionListData = unknown;

export type GetTransactionListResponse = Report;

export type GetTransactionListError = unknown;

export type CdcData = {
  query: {
    changedSince: string;
    entities: string;
  };
};

export type CdcResponse = CDCPayload;

export type CdcError = unknown;
