// Generated by ts-to-zod
import { z } from 'zod';

export const accountSchema = z.object({
  account_type: z.union([z.literal('PINNER'), z.literal('BUSINESS')]).optional(),
  id: z.string().optional(),
  profile_image: z.string().optional(),
  website_url: z.string().optional(),
  username: z.string().optional(),
  about: z.string().optional(),
  business_name: z.string().optional().nullable(),
  board_count: z.number().optional().nullable(),
  pin_count: z.number().optional().nullable(),
  follower_count: z.number().optional().nullable(),
  following_count: z.number().optional().nullable(),
  monthly_views: z.number().optional().nullable(),
});

export const accountTypeSchema = z.union([z.literal('PINNER'), z.literal('BUSINESS')]);

export const actionTypeSchema = z.union([
  z.literal('CLICKTHROUGH'),
  z.literal('IMPRESSION'),
  z.literal('VIDEO_V_50_MRC'),
]);

export const countrySchema = z.union([
  z.literal('AD'),
  z.literal('AE'),
  z.literal('AF'),
  z.literal('AG'),
  z.literal('AI'),
  z.literal('AL'),
  z.literal('AM'),
  z.literal('AO'),
  z.literal('AQ'),
  z.literal('AR'),
  z.literal('AS'),
  z.literal('AT'),
  z.literal('AU'),
  z.literal('AW'),
  z.literal('AX'),
  z.literal('AZ'),
  z.literal('BA'),
  z.literal('BB'),
  z.literal('BD'),
  z.literal('BE'),
  z.literal('BF'),
  z.literal('BG'),
  z.literal('BH'),
  z.literal('BI'),
  z.literal('BJ'),
  z.literal('BL'),
  z.literal('BM'),
  z.literal('BN'),
  z.literal('BO'),
  z.literal('BQ'),
  z.literal('BR'),
  z.literal('BS'),
  z.literal('BT'),
  z.literal('BV'),
  z.literal('BW'),
  z.literal('BY'),
  z.literal('BZ'),
  z.literal('CA'),
  z.literal('CC'),
  z.literal('CD'),
  z.literal('CF'),
  z.literal('CG'),
  z.literal('CH'),
  z.literal('CI'),
  z.literal('CK'),
  z.literal('CL'),
  z.literal('CM'),
  z.literal('CN'),
  z.literal('CO'),
  z.literal('CR'),
  z.literal('CU'),
  z.literal('CV'),
  z.literal('CW'),
  z.literal('CX'),
  z.literal('CY'),
  z.literal('CZ'),
  z.literal('DE'),
  z.literal('DJ'),
  z.literal('DK'),
  z.literal('DM'),
  z.literal('DO'),
  z.literal('DZ'),
  z.literal('EC'),
  z.literal('EE'),
  z.literal('EG'),
  z.literal('EH'),
  z.literal('ER'),
  z.literal('ES'),
  z.literal('ET'),
  z.literal('FI'),
  z.literal('FJ'),
  z.literal('FK'),
  z.literal('FM'),
  z.literal('FO'),
  z.literal('FR'),
  z.literal('GA'),
  z.literal('GB'),
  z.literal('GD'),
  z.literal('GE'),
  z.literal('GF'),
  z.literal('GG'),
  z.literal('GH'),
  z.literal('GI'),
  z.literal('GL'),
  z.literal('GM'),
  z.literal('GN'),
  z.literal('GP'),
  z.literal('GQ'),
  z.literal('GR'),
  z.literal('GS'),
  z.literal('GT'),
  z.literal('GU'),
  z.literal('GW'),
  z.literal('GY'),
  z.literal('HK'),
  z.literal('HM'),
  z.literal('HN'),
  z.literal('HR'),
  z.literal('HT'),
  z.literal('HU'),
  z.literal('ID'),
  z.literal('IE'),
  z.literal('IL'),
  z.literal('IM'),
  z.literal('IN'),
  z.literal('IO'),
  z.literal('IQ'),
  z.literal('IR'),
  z.literal('IS'),
  z.literal('IT'),
  z.literal('JE'),
  z.literal('JM'),
  z.literal('JO'),
  z.literal('JP'),
  z.literal('KE'),
  z.literal('KG'),
  z.literal('KH'),
  z.literal('KI'),
  z.literal('KM'),
  z.literal('KN'),
  z.literal('KR'),
  z.literal('KW'),
  z.literal('KY'),
  z.literal('KZ'),
  z.literal('LA'),
  z.literal('LB'),
  z.literal('LC'),
  z.literal('LI'),
  z.literal('LK'),
  z.literal('LR'),
  z.literal('LS'),
  z.literal('LT'),
  z.literal('LU'),
  z.literal('LV'),
  z.literal('LY'),
  z.literal('MA'),
  z.literal('MC'),
  z.literal('MD'),
  z.literal('ME'),
  z.literal('MF'),
  z.literal('MG'),
  z.literal('MH'),
  z.literal('MK'),
  z.literal('ML'),
  z.literal('MM'),
  z.literal('MN'),
  z.literal('MO'),
  z.literal('MP'),
  z.literal('MQ'),
  z.literal('MR'),
  z.literal('MS'),
  z.literal('MT'),
  z.literal('MU'),
  z.literal('MV'),
  z.literal('MW'),
  z.literal('MX'),
  z.literal('MY'),
  z.literal('MZ'),
  z.literal('NA'),
  z.literal('NC'),
  z.literal('NE'),
  z.literal('NF'),
  z.literal('NG'),
  z.literal('NI'),
  z.literal('NL'),
  z.literal('NO'),
  z.literal('NP'),
  z.literal('NR'),
  z.literal('NU'),
  z.literal('NZ'),
  z.literal('OM'),
  z.literal('PA'),
  z.literal('PE'),
  z.literal('PF'),
  z.literal('PG'),
  z.literal('PH'),
  z.literal('PK'),
  z.literal('PL'),
  z.literal('PM'),
  z.literal('PN'),
  z.literal('PR'),
  z.literal('PS'),
  z.literal('PT'),
  z.literal('PW'),
  z.literal('PY'),
  z.literal('QA'),
  z.literal('RE'),
  z.literal('RO'),
  z.literal('RS'),
  z.literal('RU'),
  z.literal('RW'),
  z.literal('SA'),
  z.literal('SB'),
  z.literal('SC'),
  z.literal('SD'),
  z.literal('SE'),
  z.literal('SG'),
  z.literal('SH'),
  z.literal('SI'),
  z.literal('SJ'),
  z.literal('SK'),
  z.literal('SL'),
  z.literal('SM'),
  z.literal('SN'),
  z.literal('SO'),
  z.literal('SR'),
  z.literal('SS'),
  z.literal('ST'),
  z.literal('SV'),
  z.literal('SX'),
  z.literal('SY'),
  z.literal('SZ'),
  z.literal('TC'),
  z.literal('TD'),
  z.literal('TF'),
  z.literal('TG'),
  z.literal('TH'),
  z.literal('TJ'),
  z.literal('TK'),
  z.literal('TL'),
  z.literal('TM'),
  z.literal('TN'),
  z.literal('TO'),
  z.literal('TR'),
  z.literal('TT'),
  z.literal('TV'),
  z.literal('TW'),
  z.literal('TZ'),
  z.literal('UA'),
  z.literal('UG'),
  z.literal('UM'),
  z.literal('US'),
  z.literal('UY'),
  z.literal('UZ'),
  z.literal('VA'),
  z.literal('VC'),
  z.literal('VE'),
  z.literal('VG'),
  z.literal('VI'),
  z.literal('VN'),
  z.literal('VU'),
  z.literal('WF'),
  z.literal('WS'),
  z.literal('YE'),
  z.literal('YT'),
  z.literal('ZA'),
  z.literal('ZM'),
  z.literal('ZW'),
]);

export const currencySchema = z.union([
  z.literal('UNK'),
  z.literal('USD'),
  z.literal('GBP'),
  z.literal('CAD'),
  z.literal('EUR'),
  z.literal('AUD'),
  z.literal('NZD'),
  z.literal('SEK'),
  z.literal('ILS'),
  z.literal('CHF'),
  z.literal('HKD'),
  z.literal('JPY'),
  z.literal('SGD'),
  z.literal('KRW'),
  z.literal('NOK'),
  z.literal('DKK'),
  z.literal('PLN'),
  z.literal('RON'),
  z.literal('HUF'),
  z.literal('CZK'),
  z.literal('BRL'),
  z.literal('MXN'),
  z.literal('ARS'),
  z.literal('CLP'),
  z.literal('COP'),
  z.literal('INR'),
  z.literal('TRY'),
]);

export const businessAccessRoleSchema = z.union([
  z.literal('OWNER'),
  z.literal('ADMIN'),
  z.literal('ANALYST'),
  z.literal('SOS_READER'),
  z.literal('FINANCE_MANAGER'),
  z.literal('AUDIENCE_MANAGER'),
  z.literal('CAMPAIGN_MANAGER'),
  z.literal('CATALOGS_MANAGER'),
  z.literal('RESTRICTED_OWNER'),
  z.literal('PROFILE_MANAGER'),
  z.literal('PROFILE_PUBLISHER'),
  z.literal('RESOURCE_PINNER_LIST_OWNER'),
  z.literal('RESOURCE_PINNER_LIST_READER'),
  z.literal('BIZ_PINNER_LIST_SHARER'),
  z.literal('RESOURCE_CONVERSION_TAGS_READER'),
]);

export const adAccountAnalyticsResponseSchema = z.array(
  z.record(z.union([z.unknown(), z.string()])).and(
    z.object({
      AD_ACCOUNT_ID: z.string(),
      DATE: z.string().optional(),
    }),
  ),
);

export const adAccountCreateRequestSchema = z.object({
  country: countrySchema.optional(),
  name: z.string().optional(),
  owner_user_id: z.string().optional(),
});

export const adAccountCreateSubscriptionRequestSchema = z.object({
  webhook_url: z.string(),
  lead_form_id: z.string().optional(),
  partner_access_token: z.string().optional(),
  partner_refresh_token: z.string().optional(),
  partner_metadata: z
    .object({
      subscriber_key: z.string().optional(),
    })
    .optional(),
});

export const adAccountCreateSubscriptionResponseSchema = z.object({
  id: z.string().optional(),
  cryptographic_key: z.string().optional().nullable(),
  cryptographic_algorithm: z.string().optional().nullable(),
  created_time: z.number().optional(),
});

export const adAccountGetSubscriptionResponseSchema = z
  .object({
    lead_form_id: z.string().optional().nullable(),
    webhook_url: z.string().optional(),
  })
  .and(
    z.object({
      id: z.string().optional(),
      user_account_id: z.string().optional(),
      ad_account_id: z.string().optional(),
      api_version: z.string().optional(),
      cryptographic_key: z.string().optional().nullable(),
      cryptographic_algorithm: z.string().optional().nullable(),
      created_time: z.number().optional(),
    }),
  );

export const adCountrySchema = z.union([
  z.literal('AD'),
  z.literal('AE'),
  z.literal('AF'),
  z.literal('AG'),
  z.literal('AI'),
  z.literal('AL'),
  z.literal('AM'),
  z.literal('AO'),
  z.literal('AQ'),
  z.literal('AR'),
  z.literal('AS'),
  z.literal('AT'),
  z.literal('AU'),
  z.literal('AW'),
  z.literal('AX'),
  z.literal('AZ'),
  z.literal('BA'),
  z.literal('BB'),
  z.literal('BD'),
  z.literal('BE'),
  z.literal('BF'),
  z.literal('BG'),
  z.literal('BH'),
  z.literal('BI'),
  z.literal('BJ'),
  z.literal('BL'),
  z.literal('BM'),
  z.literal('BN'),
  z.literal('BO'),
  z.literal('BQ'),
  z.literal('BR'),
  z.literal('BS'),
  z.literal('BT'),
  z.literal('BV'),
  z.literal('BW'),
  z.literal('BY'),
  z.literal('BZ'),
  z.literal('CA'),
  z.literal('CC'),
  z.literal('CD'),
  z.literal('CF'),
  z.literal('CG'),
  z.literal('CH'),
  z.literal('CI'),
  z.literal('CK'),
  z.literal('CL'),
  z.literal('CM'),
  z.literal('CN'),
  z.literal('CO'),
  z.literal('CR'),
  z.literal('CU'),
  z.literal('CV'),
  z.literal('CW'),
  z.literal('CX'),
  z.literal('CY'),
  z.literal('CZ'),
  z.literal('DE'),
  z.literal('DJ'),
  z.literal('DK'),
  z.literal('DM'),
  z.literal('DO'),
  z.literal('DZ'),
  z.literal('EC'),
  z.literal('EE'),
  z.literal('EG'),
  z.literal('EH'),
  z.literal('ER'),
  z.literal('ES'),
  z.literal('ET'),
  z.literal('FI'),
  z.literal('FJ'),
  z.literal('FK'),
  z.literal('FM'),
  z.literal('FO'),
  z.literal('FR'),
  z.literal('GA'),
  z.literal('GB'),
  z.literal('GD'),
  z.literal('GE'),
  z.literal('GF'),
  z.literal('GG'),
  z.literal('GH'),
  z.literal('GI'),
  z.literal('GL'),
  z.literal('GM'),
  z.literal('GN'),
  z.literal('GP'),
  z.literal('GQ'),
  z.literal('GR'),
  z.literal('GS'),
  z.literal('GT'),
  z.literal('GU'),
  z.literal('GW'),
  z.literal('GY'),
  z.literal('HK'),
  z.literal('HM'),
  z.literal('HN'),
  z.literal('HR'),
  z.literal('HT'),
  z.literal('HU'),
  z.literal('ID'),
  z.literal('IE'),
  z.literal('IL'),
  z.literal('IM'),
  z.literal('IN'),
  z.literal('IO'),
  z.literal('IQ'),
  z.literal('IR'),
  z.literal('IS'),
  z.literal('IT'),
  z.literal('JE'),
  z.literal('JM'),
  z.literal('JO'),
  z.literal('JP'),
  z.literal('KE'),
  z.literal('KG'),
  z.literal('KH'),
  z.literal('KI'),
  z.literal('KM'),
  z.literal('KN'),
  z.literal('KR'),
  z.literal('KW'),
  z.literal('KY'),
  z.literal('KZ'),
  z.literal('LA'),
  z.literal('LB'),
  z.literal('LC'),
  z.literal('LI'),
  z.literal('LK'),
  z.literal('LR'),
  z.literal('LS'),
  z.literal('LT'),
  z.literal('LU'),
  z.literal('LV'),
  z.literal('LY'),
  z.literal('MA'),
  z.literal('MC'),
  z.literal('MD'),
  z.literal('ME'),
  z.literal('MF'),
  z.literal('MG'),
  z.literal('MH'),
  z.literal('MK'),
  z.literal('ML'),
  z.literal('MM'),
  z.literal('MN'),
  z.literal('MO'),
  z.literal('MP'),
  z.literal('MQ'),
  z.literal('MR'),
  z.literal('MS'),
  z.literal('MT'),
  z.literal('MU'),
  z.literal('MV'),
  z.literal('MW'),
  z.literal('MX'),
  z.literal('MY'),
  z.literal('MZ'),
  z.literal('NA'),
  z.literal('NC'),
  z.literal('NE'),
  z.literal('NF'),
  z.literal('NG'),
  z.literal('NI'),
  z.literal('NL'),
  z.literal('NO'),
  z.literal('NP'),
  z.literal('NR'),
  z.literal('NU'),
  z.literal('NZ'),
  z.literal('OM'),
  z.literal('PA'),
  z.literal('PE'),
  z.literal('PF'),
  z.literal('PG'),
  z.literal('PH'),
  z.literal('PK'),
  z.literal('PL'),
  z.literal('PM'),
  z.literal('PN'),
  z.literal('PR'),
  z.literal('PS'),
  z.literal('PT'),
  z.literal('PW'),
  z.literal('PY'),
  z.literal('QA'),
  z.literal('RE'),
  z.literal('RO'),
  z.literal('RS'),
  z.literal('RU'),
  z.literal('RW'),
  z.literal('SA'),
  z.literal('SB'),
  z.literal('SC'),
  z.literal('SD'),
  z.literal('SE'),
  z.literal('SG'),
  z.literal('SH'),
  z.literal('SI'),
  z.literal('SJ'),
  z.literal('SK'),
  z.literal('SL'),
  z.literal('SM'),
  z.literal('SN'),
  z.literal('SO'),
  z.literal('SR'),
  z.literal('SS'),
  z.literal('ST'),
  z.literal('SV'),
  z.literal('SX'),
  z.literal('SY'),
  z.literal('SZ'),
  z.literal('TC'),
  z.literal('TD'),
  z.literal('TF'),
  z.literal('TG'),
  z.literal('TH'),
  z.literal('TJ'),
  z.literal('TK'),
  z.literal('TL'),
  z.literal('TM'),
  z.literal('TN'),
  z.literal('TO'),
  z.literal('TR'),
  z.literal('TT'),
  z.literal('TV'),
  z.literal('TW'),
  z.literal('TZ'),
  z.literal('UA'),
  z.literal('UG'),
  z.literal('UM'),
  z.literal('US'),
  z.literal('UY'),
  z.literal('UZ'),
  z.literal('VA'),
  z.literal('VC'),
  z.literal('VE'),
  z.literal('VG'),
  z.literal('VI'),
  z.literal('VN'),
  z.literal('VU'),
  z.literal('WF'),
  z.literal('WS'),
  z.literal('YE'),
  z.literal('YT'),
  z.literal('ZA'),
  z.literal('ZM'),
  z.literal('ZW'),
]);

export const exceptionSchema = z.object({
  code: z.number().optional(),
  message: z.string().optional(),
});

export const creativeTypeSchema = z.union([
  z.literal('REGULAR'),
  z.literal('VIDEO'),
  z.literal('SHOPPING'),
  z.literal('CAROUSEL'),
  z.literal('MAX_VIDEO'),
  z.literal('SHOP_THE_PIN'),
  z.literal('COLLECTION'),
  z.literal('IDEA'),
  z.literal('SHOWCASE'),
  z.literal('QUIZ'),
]);

export const entityStatusSchema = z.union([
  z.literal('ACTIVE'),
  z.literal('PAUSED'),
  z.literal('ARCHIVED'),
  z.literal('DRAFT'),
  z.literal('DELETED_DRAFT'),
]);

export const trackingUrlsSchema = z
  .object({
    impression: z.array(z.string()).optional(),
    click: z.array(z.string()).optional(),
    engagement: z.array(z.string()).optional(),
    buyable_button: z.array(z.string()).optional(),
    audience_verification: z.array(z.string()).optional(),
  })
  .nullable();

export const gridClickTypeSchema = z.union([z.literal('CLOSEUP'), z.literal('DIRECT_TO_DESTINATION')]);

export const customizableCtaTypeSchema = z.union([
  z.literal('GET_OFFER'),
  z.literal('LEARN_MORE'),
  z.literal('ORDER_NOW'),
  z.literal('SHOP_NOW'),
  z.literal('SIGN_UP'),
  z.literal('SUBSCRIBE'),
  z.literal('BUY_NOW'),
  z.literal('CONTACT_US'),
  z.literal('GET_QUOTE'),
  z.literal('VISIT_SITE'),
  z.literal('APPLY_NOW'),
  z.literal('BOOK_NOW'),
  z.literal('REQUEST_DEMO'),
  z.literal('REGISTER_NOW'),
  z.literal('FIND_A_DEALER'),
  z.literal('ADD_TO_CART'),
  z.literal('WATCH_NOW'),
  z.literal('READ_MORE'),
]);

export const adPinIdSchema = z.object({
  pin_id: z.string().optional(),
});

export const advancedAuctionOperationSchema = z.union([z.literal('UPSERT'), z.literal('DELETE')]);

export const updateMaskBidOptionFieldSchema = z.union([
  z.literal('BID'),
  z.literal('APP_TYPE_BID_MULTIPLIER_SET'),
  z.literal('PLACEMENT_BID_MULTIPLIER_SET'),
]);

export const advancedAuctionOperationErrorSchema = z.object({
  code: z.number().optional(),
  message: z.string().optional(),
});

export const languageSchema = z.union([
  z.literal('AM'),
  z.literal('AR'),
  z.literal('AZ'),
  z.literal('BG'),
  z.literal('BN'),
  z.literal('BS'),
  z.literal('CA'),
  z.literal('CS'),
  z.literal('DA'),
  z.literal('DV'),
  z.literal('DZ'),
  z.literal('DE'),
  z.literal('EL'),
  z.literal('EN'),
  z.literal('ES'),
  z.literal('ET'),
  z.literal('FA'),
  z.literal('FI'),
  z.literal('FR'),
  z.literal('HE'),
  z.literal('HI'),
  z.literal('HR'),
  z.literal('HU'),
  z.literal('HY'),
  z.literal('ID'),
  z.literal('IN'),
  z.literal('IS'),
  z.literal('IT'),
  z.literal('IW'),
  z.literal('JA'),
  z.literal('KA'),
  z.literal('KM'),
  z.literal('KO'),
  z.literal('LO'),
  z.literal('LT'),
  z.literal('LV'),
  z.literal('MK'),
  z.literal('MN'),
  z.literal('MS'),
  z.literal('MY'),
  z.literal('NB'),
  z.literal('NE'),
  z.literal('NL'),
  z.literal('NO'),
  z.literal('PL'),
  z.literal('PT'),
  z.literal('RO'),
  z.literal('RU'),
  z.literal('SK'),
  z.literal('SL'),
  z.literal('SQ'),
  z.literal('SR'),
  z.literal('SV'),
  z.literal('TL'),
  z.literal('UK'),
  z.literal('VI'),
  z.literal('TE'),
  z.literal('TH'),
  z.literal('TR'),
  z.literal('XX'),
  z.literal('ZH'),
]);

export const bidInMicroCurrencySchema = z.number().nullable();

export const placementMultipliersSchema = z
  .record(z.union([z.union([z.number(), z.string()]), z.undefined()]))
  .and(
    z.object({
      PLACEMENT: z.union([z.literal('SEARCH'), z.literal('BROWSE')]).optional(),
    }),
  )
  .nullable();

export const targetingSpecAppTypeSchema = z.union([
  z.literal('android_mobile'),
  z.literal('android_tablet'),
  z.literal('ipad'),
  z.literal('iphone'),
  z.literal('web'),
  z.literal('web_mobile'),
]);

export const placementSchema = z.union([z.literal('SEARCH'), z.literal('BROWSE')]);

export const optimizationGoalMetadataSchema = z.object({
  conversion_tag_v3_goal_metadata: z
    .object({
      attribution_windows: z
        .object({
          click_window_days: z.number().optional(),
          engagement_window_days: z.number().optional(),
          view_window_days: z.number().optional(),
        })
        .optional(),
      conversion_event: z
        .union([
          z.literal('PAGE_VISIT'),
          z.literal('SIGNUP'),
          z.literal('CHECKOUT'),
          z.literal('CUSTOM'),
          z.literal('VIEW_CATEGORY'),
          z.literal('SEARCH'),
          z.literal('ADD_TO_CART'),
          z.literal('WATCH_VIDEO'),
          z.literal('LEAD'),
          z.literal('APP_INSTALL'),
        ])
        .optional(),
      conversion_tag_id: z.string().optional(),
      cpa_goal_value_in_micro_currency: z.string().optional(),
      is_roas_optimized: z.boolean().optional().nullable(),
      learning_mode_type: z
        .union([z.literal('NOT_ACTIVE'), z.literal('ACTIVE')])
        .optional()
        .nullable(),
    })
    .optional(),
  frequency_goal_metadata: z
    .object({
      frequency: z.number().optional(),
      timerange: z
        .union([
          z.literal('THIRTY_DAY'),
          z.literal('DAY'),
          z.literal('SEVEN_DAY'),
          z.literal('TWENTY_MINUTE'),
          z.literal('TEN_MINUTE'),
          z.literal('TWENTY_FOUR_HOUR'),
        ])
        .optional(),
    })
    .optional(),
  scrollup_goal_metadata: z
    .object({
      scrollup_goal_value_in_micro_currency: z.string().optional().nullable(),
    })
    .optional(),
});

export const budgetTypeSchema = z.union([z.literal('DAILY'), z.literal('LIFETIME'), z.literal('CBO_ADGROUP')]);

export const targetingSpecSchema = z.object({
  AGE_BUCKET: z
    .array(
      z.union([
        z.literal('18-24'),
        z.literal('21+'),
        z.literal('25-34'),
        z.literal('35-44'),
        z.literal('45-49'),
        z.literal('50-54'),
        z.literal('55-64'),
        z.literal('65+'),
      ]),
    )
    .optional()
    .nullable(),
  APPTYPE: z
    .array(
      z.union([
        z.literal('android_mobile'),
        z.literal('android_tablet'),
        z.literal('ipad'),
        z.literal('iphone'),
        z.literal('web'),
        z.literal('web_mobile'),
      ]),
    )
    .optional()
    .nullable(),
  AUDIENCE_EXCLUDE: z.array(z.string()).optional().nullable(),
  AUDIENCE_INCLUDE: z.array(z.string()).optional().nullable(),
  GENDER: z
    .array(z.union([z.literal('unknown'), z.literal('male'), z.literal('female')]))
    .optional()
    .nullable(),
  GEO: z.array(z.string()).optional().nullable(),
  INTEREST: z.array(z.string()).optional(),
  LOCALE: z.array(z.string()).optional().nullable(),
  LOCATION: z.array(z.string()).optional().nullable(),
  SHOPPING_RETARGETING: z
    .array(
      z.object({
        lookback_window: z.number().optional(),
        tag_types: z.array(z.number()).optional(),
        exclusion_window: z.number().optional(),
      }),
    )
    .optional()
    .nullable(),
  TARGETING_STRATEGY: z
    .array(z.union([z.literal('CHOOSE_YOUR_OWN'), z.literal('FIND_NEW_CUSTOMERS'), z.literal('RECONNECT_WITH_USERS')]))
    .optional()
    .nullable(),
});

export const placementGroupTypeSchema = z.union([
  z.literal('ALL'),
  z.literal('SEARCH'),
  z.literal('BROWSE'),
  z.literal('OTHER'),
]);

export const pacingDeliveryTypeSchema = z.union([z.literal('STANDARD'), z.literal('ACCELERATED')]);

export const bidStrategyTypeSchema = z.union([
  z.literal('AUTOMATIC_BID'),
  z.literal('MAX_BID'),
  z.literal('TARGET_AVG'),
]);

export const adGroupCommonSchema = z.object({
  name: z.string().optional(),
  status: entityStatusSchema.optional(),
  budget_in_micro_currency: z.number().optional().nullable(),
  bid_in_micro_currency: z.number().optional().nullable(),
  optimization_goal_metadata: optimizationGoalMetadataSchema.optional().nullable(),
  budget_type: budgetTypeSchema.optional(),
  start_time: z.number().optional().nullable(),
  end_time: z.number().optional().nullable(),
  targeting_spec: targetingSpecSchema.optional(),
  lifetime_frequency_cap: z.number().optional(),
  tracking_urls: trackingUrlsSchema.optional().nullable(),
  auto_targeting_enabled: z.boolean().optional().nullable(),
  placement_group: placementGroupTypeSchema.optional(),
  pacing_delivery_type: pacingDeliveryTypeSchema.optional(),
  campaign_id: z.string().optional(),
  billable_event: actionTypeSchema.optional(),
  bid_strategy_type: z
    .union([z.literal('AUTOMATIC_BID'), z.literal('MAX_BID'), z.literal('TARGET_AVG')])
    .optional()
    .nullable(),
  targeting_template_ids: z.array(z.string()).optional().nullable(),
});

export const adGroupSummaryStatusSchema = z.union([
  z.literal('RUNNING'),
  z.literal('PAUSED'),
  z.literal('NOT_STARTED'),
  z.literal('COMPLETED'),
  z.literal('ADVERTISER_DISABLED'),
  z.literal('ARCHIVED'),
  z.literal('DRAFT'),
  z.literal('DELETED_DRAFT'),
]);

export const conversionLearningModeTypeSchema = z.union([z.literal('NOT_ACTIVE'), z.literal('ACTIVE')]);

export const adGroupUpdateRequestSchema = adGroupCommonSchema.and(
  z.object({
    id: z.string(),
  }),
);

export const adGroupsAnalyticsResponseSchema = z.array(
  z.record(z.union([z.unknown(), z.string()])).and(
    z.object({
      AD_GROUP_ID: z.string(),
      DATE: z.string().optional(),
    }),
  ),
);

export const matchTypeResponseSchema = z.union([
  z.literal('BROAD'),
  z.literal('PHRASE'),
  z.literal('EXACT'),
  z.literal('EXACT_NEGATIVE'),
  z.literal('PHRASE_NEGATIVE'),
]);

export const adGroupAudienceSizingResponseSchema = z.object({
  audience_size_lower_bound: z.number().optional(),
  audience_size_upper_bound: z.number().optional(),
});

export const adPreviewRequestSchema = z.union([
  z.object({
    image_url: z.string(),
    title: z.string(),
  }),
  z.object({
    pin_id: z.string(),
  }),
]);

export const adPreviewURLResponseSchema = z.object({
  url: z.string().optional(),
});

export const pinPromotionSummaryStatusSchema = z.union([
  z.literal('APPROVED'),
  z.literal('PAUSED'),
  z.literal('PENDING'),
  z.literal('REJECTED'),
  z.literal('ADVERTISER_DISABLED'),
  z.literal('ARCHIVED'),
  z.literal('DRAFT'),
  z.literal('DELETED_DRAFT'),
]);

export const reviewStatusSchema = z.union([
  z.literal('OTHER'),
  z.literal('PENDING'),
  z.literal('REJECTED'),
  z.literal('APPROVED'),
]);

export const adsAnalyticsAdTargetingTypeSchema = z.union([
  z.literal('KEYWORD'),
  z.literal('APPTYPE'),
  z.literal('GENDER'),
  z.literal('LOCATION'),
  z.literal('PLACEMENT'),
  z.literal('COUNTRY'),
  z.literal('TARGETED_INTEREST'),
  z.literal('PINNER_INTEREST'),
  z.literal('AUDIENCE_INCLUDE'),
  z.literal('GEO'),
  z.literal('AGE_BUCKET'),
  z.literal('REGION'),
  z.literal('QUIZ_RESULT'),
  z.literal('AGE_BUCKET_AND_GENDER'),
]);

export const adsAnalyticsCampaignTargetingTypeSchema = z.union([
  z.literal('KEYWORD'),
  z.literal('APPTYPE'),
  z.literal('GENDER'),
  z.literal('LOCATION'),
  z.literal('PLACEMENT'),
  z.literal('COUNTRY'),
  z.literal('TARGETED_INTEREST'),
  z.literal('PINNER_INTEREST'),
  z.literal('AUDIENCE_INCLUDE'),
  z.literal('GEO'),
  z.literal('AGE_BUCKET'),
  z.literal('REGION'),
  z.literal('CREATIVE_TYPE'),
  z.literal('AGE_BUCKET_AND_GENDER'),
]);

export const granularitySchema = z.union([
  z.literal('TOTAL'),
  z.literal('DAY'),
  z.literal('HOUR'),
  z.literal('WEEK'),
  z.literal('MONTH'),
]);

export const conversionAttributionWindowDaysSchema = z.union([
  z.literal(0),
  z.literal(1),
  z.literal(7),
  z.literal(14),
  z.literal(30),
  z.literal(60),
]);

export const conversionReportTimeTypeSchema = z.union([
  z.literal('TIME_OF_AD_ACTION'),
  z.literal('TIME_OF_CONVERSION'),
]);

export const conversionReportAttributionTypeSchema = z.union([z.literal('INDIVIDUAL'), z.literal('HOUSEHOLD')]);

export const campaignSummaryStatusSchema = z.union([
  z.literal('RUNNING'),
  z.literal('PAUSED'),
  z.literal('NOT_STARTED'),
  z.literal('COMPLETED'),
  z.literal('ADVERTISER_DISABLED'),
  z.literal('ARCHIVED'),
  z.literal('DRAFT'),
  z.literal('DELETED_DRAFT'),
]);

export const objectiveTypeSchema = z.union([
  z.literal('AWARENESS'),
  z.literal('CONSIDERATION'),
  z.literal('VIDEO_VIEW'),
  z.literal('WEB_CONVERSION'),
  z.literal('CATALOG_SALES'),
  z.literal('WEB_SESSIONS'),
  z.literal('VIDEO_COMPLETION'),
]);

export const productGroupSummaryStatusSchema = z.union([
  z.literal('RUNNING'),
  z.literal('PAUSED'),
  z.literal('EXCLUDED'),
  z.literal('ARCHIVED'),
]);

export const reportingColumnAsyncSchema = z.union([
  z.literal('SPEND_IN_MICRO_DOLLAR'),
  z.literal('PAID_IMPRESSION'),
  z.literal('SPEND_IN_DOLLAR'),
  z.literal('CPC_IN_MICRO_DOLLAR'),
  z.literal('ECPC_IN_MICRO_DOLLAR'),
  z.literal('ECPC_IN_DOLLAR'),
  z.literal('CTR'),
  z.literal('ECTR'),
  z.literal('OUTBOUND_CTR'),
  z.literal('COST_PER_OUTBOUND_CLICK'),
  z.literal('CAMPAIGN_NAME'),
  z.literal('CAMPAIGN_STATUS'),
  z.literal('PIN_PROMOTION_STATUS'),
  z.literal('AD_STATUS'),
  z.literal('PIN_ID'),
  z.literal('TOTAL_ENGAGEMENT'),
  z.literal('ENGAGEMENT_1'),
  z.literal('ENGAGEMENT_2'),
  z.literal('ECPE_IN_DOLLAR'),
  z.literal('ENGAGEMENT_RATE'),
  z.literal('EENGAGEMENT_RATE'),
  z.literal('ECPM_IN_MICRO_DOLLAR'),
  z.literal('REPIN_RATE'),
  z.literal('CTR_2'),
  z.literal('CAMPAIGN_ID'),
  z.literal('ADVERTISER_ID'),
  z.literal('AD_ACCOUNT_ID'),
  z.literal('PIN_PROMOTION_ID'),
  z.literal('AD_ID'),
  z.literal('AD_GROUP_ID'),
  z.literal('CAMPAIGN_ENTITY_STATUS'),
  z.literal('CAMPAIGN_MANAGED_STATUS'),
  z.literal('CAMPAIGN_OBJECTIVE_TYPE'),
  z.literal('CPM_IN_MICRO_DOLLAR'),
  z.literal('CPM_IN_DOLLAR'),
  z.literal('AD_GROUP_NAME'),
  z.literal('AD_GROUP_STATUS'),
  z.literal('AD_GROUP_ENTITY_STATUS'),
  z.literal('PRODUCT_GROUP_ID'),
  z.literal('PRODUCT_GROUP_STATUS'),
  z.literal('ORDER_LINE_ID'),
  z.literal('ORDER_LINE_NAME'),
  z.literal('CLICKTHROUGH_1'),
  z.literal('REPIN_1'),
  z.literal('IMPRESSION_1'),
  z.literal('IMPRESSION_1_GROSS'),
  z.literal('CLICKTHROUGH_1_GROSS'),
  z.literal('OUTBOUND_CLICK_1'),
  z.literal('CLICKTHROUGH_2'),
  z.literal('REPIN_2'),
  z.literal('IMPRESSION_2'),
  z.literal('OUTBOUND_CLICK_2'),
  z.literal('TOTAL_CLICKTHROUGH'),
  z.literal('TOTAL_IMPRESSION'),
  z.literal('TOTAL_IMPRESSION_USER'),
  z.literal('TOTAL_IMPRESSION_FREQUENCY'),
  z.literal('COST_PER_OUTBOUND_CLICK_IN_DOLLAR'),
  z.literal('TOTAL_ENGAGEMENT_PAGE_VISIT'),
  z.literal('TOTAL_ENGAGEMENT_SIGNUP'),
  z.literal('TOTAL_ENGAGEMENT_CHECKOUT'),
  z.literal('TOTAL_ENGAGEMENT_CUSTOM'),
  z.literal('TOTAL_ENGAGEMENT_ADD_TO_CART'),
  z.literal('TOTAL_ENGAGEMENT_LEAD'),
  z.literal('TOTAL_ENGAGEMENT_SEARCH'),
  z.literal('TOTAL_ENGAGEMENT_WATCH_VIDEO'),
  z.literal('TOTAL_ENGAGEMENT_VIEW_CATEGORY'),
  z.literal('TOTAL_ENGAGEMENT_APP_INSTALL'),
  z.literal('TOTAL_ENGAGEMENT_UNKNOWN'),
  z.literal('TOTAL_CLICK_PAGE_VISIT'),
  z.literal('TOTAL_CLICK_SIGNUP'),
  z.literal('TOTAL_CLICK_CHECKOUT'),
  z.literal('TOTAL_CLICK_CUSTOM'),
  z.literal('TOTAL_CLICK_ADD_TO_CART'),
  z.literal('TOTAL_CLICK_LEAD'),
  z.literal('TOTAL_CLICK_SEARCH'),
  z.literal('TOTAL_CLICK_WATCH_VIDEO'),
  z.literal('TOTAL_CLICK_VIEW_CATEGORY'),
  z.literal('TOTAL_CLICK_APP_INSTALL'),
  z.literal('TOTAL_CLICK_UNKNOWN'),
  z.literal('TOTAL_VIEW_PAGE_VISIT'),
  z.literal('TOTAL_VIEW_SIGNUP'),
  z.literal('TOTAL_VIEW_CHECKOUT'),
  z.literal('TOTAL_VIEW_CUSTOM'),
  z.literal('TOTAL_VIEW_ADD_TO_CART'),
  z.literal('TOTAL_VIEW_LEAD'),
  z.literal('TOTAL_VIEW_SEARCH'),
  z.literal('TOTAL_VIEW_WATCH_VIDEO'),
  z.literal('TOTAL_VIEW_VIEW_CATEGORY'),
  z.literal('TOTAL_VIEW_APP_INSTALL'),
  z.literal('TOTAL_VIEW_UNKNOWN'),
  z.literal('TOTAL_CONVERSIONS'),
  z.literal('TOTAL_ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CONVERSIONS_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_ENGAGEMENT_PAGE_VISIT_QUANTITY'),
  z.literal('TOTAL_ENGAGEMENT_SIGNUP_QUANTITY'),
  z.literal('TOTAL_ENGAGEMENT_CHECKOUT_QUANTITY'),
  z.literal('TOTAL_ENGAGEMENT_CUSTOM_QUANTITY'),
  z.literal('TOTAL_ENGAGEMENT_ADD_TO_CART_QUANTITY'),
  z.literal('TOTAL_ENGAGEMENT_LEAD_QUANTITY'),
  z.literal('TOTAL_ENGAGEMENT_SEARCH_QUANTITY'),
  z.literal('TOTAL_ENGAGEMENT_WATCH_VIDEO_QUANTITY'),
  z.literal('TOTAL_ENGAGEMENT_VIEW_CATEGORY_QUANTITY'),
  z.literal('TOTAL_ENGAGEMENT_UNKNOWN_QUANTITY'),
  z.literal('TOTAL_CLICK_PAGE_VISIT_QUANTITY'),
  z.literal('TOTAL_CLICK_SIGNUP_QUANTITY'),
  z.literal('TOTAL_CLICK_CHECKOUT_QUANTITY'),
  z.literal('TOTAL_CLICK_CUSTOM_QUANTITY'),
  z.literal('TOTAL_CLICK_ADD_TO_CART_QUANTITY'),
  z.literal('TOTAL_CLICK_LEAD_QUANTITY'),
  z.literal('TOTAL_CLICK_SEARCH_QUANTITY'),
  z.literal('TOTAL_CLICK_WATCH_VIDEO_QUANTITY'),
  z.literal('TOTAL_CLICK_VIEW_CATEGORY_QUANTITY'),
  z.literal('TOTAL_CLICK_UNKNOWN_QUANTITY'),
  z.literal('TOTAL_VIEW_PAGE_VISIT_QUANTITY'),
  z.literal('TOTAL_VIEW_SIGNUP_QUANTITY'),
  z.literal('TOTAL_VIEW_CHECKOUT_QUANTITY'),
  z.literal('TOTAL_VIEW_CUSTOM_QUANTITY'),
  z.literal('TOTAL_VIEW_ADD_TO_CART_QUANTITY'),
  z.literal('TOTAL_VIEW_LEAD_QUANTITY'),
  z.literal('TOTAL_VIEW_SEARCH_QUANTITY'),
  z.literal('TOTAL_VIEW_WATCH_VIDEO_QUANTITY'),
  z.literal('TOTAL_VIEW_VIEW_CATEGORY_QUANTITY'),
  z.literal('TOTAL_VIEW_UNKNOWN_QUANTITY'),
  z.literal('TOTAL_CONVERSIONS_QUANTITY'),
  z.literal('TOTAL_WEB_SESSIONS'),
  z.literal('WEB_SESSIONS_1'),
  z.literal('WEB_SESSIONS_2'),
  z.literal('ONSITE_CHECKOUTS_1'),
  z.literal('PIN_PROMOTION_NAME'),
  z.literal('AD_NAME'),
  z.literal('CAMPAIGN_LIFETIME_SPEND_CAP'),
  z.literal('CAMPAIGN_DAILY_SPEND_CAP'),
  z.literal('TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_PAGE_VISIT_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_PAGE_VISIT_TABLET_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_PAGE_VISIT_TABLET_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_SIGNUP_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_SIGNUP_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_SIGNUP_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_SIGNUP_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_SIGNUP_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_SIGNUP_MOBILE_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_SIGNUP_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_SIGNUP_TABLET_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_SIGNUP_TABLET_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_CHECKOUT_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_CHECKOUT_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_CHECKOUT_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_CHECKOUT_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_CHECKOUT_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_CHECKOUT_MOBILE_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_CHECKOUT_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_CHECKOUT_TABLET_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_CHECKOUT_TABLET_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_CUSTOM_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_CUSTOM_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_CUSTOM_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_CUSTOM_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_CUSTOM_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_CUSTOM_MOBILE_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_CUSTOM_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_CUSTOM_TABLET_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_CUSTOM_TABLET_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_ADD_TO_CART_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_ADD_TO_CART_TABLET_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_ADD_TO_CART_TABLET_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_LEAD_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_LEAD_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_LEAD_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_LEAD_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_LEAD_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_LEAD_MOBILE_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_LEAD_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_LEAD_TABLET_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_LEAD_TABLET_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_SEARCH_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_SEARCH_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_SEARCH_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_SEARCH_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_SEARCH_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_SEARCH_MOBILE_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_SEARCH_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_SEARCH_TABLET_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_SEARCH_TABLET_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_APP_INSTALL_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_APP_INSTALL_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_APP_INSTALL_MOBILE_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_APP_INSTALL_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_APP_INSTALL_TABLET_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_APP_INSTALL_TABLET_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_UNKNOWN_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_UNKNOWN_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_UNKNOWN_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_UNKNOWN_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_UNKNOWN_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_UNKNOWN_MOBILE_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_UNKNOWN_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
  z.literal('TOTAL_UNKNOWN_TABLET_ACTION_TO_MOBILE_CONVERSION'),
  z.literal('TOTAL_UNKNOWN_TABLET_ACTION_TO_TABLET_CONVERSION'),
  z.literal('TOTAL_PAGE_VISIT'),
  z.literal('TOTAL_SIGNUP'),
  z.literal('TOTAL_CHECKOUT'),
  z.literal('TOTAL_CUSTOM'),
  z.literal('TOTAL_ADD_TO_CART'),
  z.literal('TOTAL_LEAD'),
  z.literal('TOTAL_SEARCH'),
  z.literal('TOTAL_WATCH_VIDEO'),
  z.literal('TOTAL_VIEW_CATEGORY'),
  z.literal('TOTAL_APP_INSTALL'),
  z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_LEAD_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_SEARCH_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_CHECKOUT_QUANTITY'),
  z.literal('PAGE_VISIT_COST_PER_ACTION'),
  z.literal('APP_INSTALL_COST_PER_ACTION'),
  z.literal('PAGE_VISIT_ROAS'),
  z.literal('CHECKOUT_ROAS'),
  z.literal('CUSTOM_ROAS'),
  z.literal('VIDEO_3SEC_VIEWS_1'),
  z.literal('VIDEO_P100_COMPLETE_1'),
  z.literal('VIDEO_P0_COMBINED_1'),
  z.literal('VIDEO_P25_COMBINED_1'),
  z.literal('VIDEO_P50_COMBINED_1'),
  z.literal('VIDEO_P75_COMBINED_1'),
  z.literal('VIDEO_P95_COMBINED_1'),
  z.literal('VIDEO_MRC_VIEWS_1'),
  z.literal('VIDEO_3SEC_VIEWS_2'),
  z.literal('VIDEO_P100_COMPLETE_2'),
  z.literal('VIDEO_P0_COMBINED_2'),
  z.literal('VIDEO_P25_COMBINED_2'),
  z.literal('VIDEO_P50_COMBINED_2'),
  z.literal('VIDEO_P75_COMBINED_2'),
  z.literal('VIDEO_P95_COMBINED_2'),
  z.literal('VIDEO_MRC_VIEWS_2'),
  z.literal('PAID_VIDEO_VIEWABLE_RATE'),
  z.literal('VIDEO_LENGTH'),
  z.literal('CPV_IN_MICRO_DOLLAR'),
  z.literal('ECPV_IN_DOLLAR'),
  z.literal('CPCV_IN_MICRO_DOLLAR'),
  z.literal('ECPCV_IN_DOLLAR'),
  z.literal('CPCV_P95_IN_MICRO_DOLLAR'),
  z.literal('ECPCV_P95_IN_DOLLAR'),
  z.literal('TOTAL_VIDEO_3SEC_VIEWS'),
  z.literal('TOTAL_VIDEO_P100_COMPLETE'),
  z.literal('TOTAL_VIDEO_P0_COMBINED'),
  z.literal('TOTAL_VIDEO_P25_COMBINED'),
  z.literal('TOTAL_VIDEO_P50_COMBINED'),
  z.literal('TOTAL_VIDEO_P75_COMBINED'),
  z.literal('TOTAL_VIDEO_P95_COMBINED'),
  z.literal('TOTAL_VIDEO_MRC_VIEWS'),
  z.literal('VIDEO_AVG_WATCHTIME_IN_SECOND_1'),
  z.literal('VIDEO_AVG_WATCHTIME_IN_SECOND_2'),
  z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'),
  z.literal('TOTAL_DESTINATION_VIEWS'),
  z.literal('TOTAL_REPIN_RATE'),
  z.literal('WEB_CHECKOUT_COST_PER_ACTION'),
  z.literal('WEB_CHECKOUT_ROAS'),
  z.literal('TOTAL_WEB_CHECKOUT'),
  z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_CLICK_CHECKOUT'),
  z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT'),
  z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_VIEW_CHECKOUT'),
  z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('INAPP_CHECKOUT_COST_PER_ACTION'),
  z.literal('INAPP_CHECKOUT_ROAS'),
  z.literal('TOTAL_INAPP_CHECKOUT'),
  z.literal('TOTAL_INAPP_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_CLICK_CHECKOUT'),
  z.literal('TOTAL_INAPP_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_ENGAGEMENT_CHECKOUT'),
  z.literal('TOTAL_INAPP_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_VIEW_CHECKOUT'),
  z.literal('TOTAL_INAPP_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('OFFLINE_CHECKOUT_COST_PER_ACTION'),
  z.literal('OFFLINE_CHECKOUT_ROAS'),
  z.literal('TOTAL_OFFLINE_CHECKOUT'),
  z.literal('TOTAL_OFFLINE_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_CLICK_CHECKOUT'),
  z.literal('TOTAL_OFFLINE_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT'),
  z.literal('TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_VIEW_CHECKOUT'),
  z.literal('TOTAL_OFFLINE_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('PINTEREST_CHECKOUT_COST_PER_ACTION'),
  z.literal('PINTEREST_CHECKOUT_ROAS'),
  z.literal('TOTAL_PINTEREST_CHECKOUT'),
  z.literal('TOTAL_PINTEREST_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('WEB_ADD_TO_CART_COST_PER_ACTION'),
  z.literal('WEB_ADD_TO_CART_ROAS'),
  z.literal('TOTAL_WEB_ADD_TO_CART'),
  z.literal('TOTAL_WEB_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_CLICK_ADD_TO_CART'),
  z.literal('TOTAL_WEB_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_ENGAGEMENT_ADD_TO_CART'),
  z.literal('TOTAL_WEB_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_VIEW_ADD_TO_CART'),
  z.literal('TOTAL_WEB_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
  z.literal('INAPP_ADD_TO_CART_COST_PER_ACTION'),
  z.literal('INAPP_ADD_TO_CART_ROAS'),
  z.literal('TOTAL_INAPP_ADD_TO_CART'),
  z.literal('TOTAL_INAPP_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_CLICK_ADD_TO_CART'),
  z.literal('TOTAL_INAPP_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART'),
  z.literal('TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_VIEW_ADD_TO_CART'),
  z.literal('TOTAL_INAPP_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
  z.literal('WEB_PAGE_VISIT_COST_PER_ACTION'),
  z.literal('WEB_PAGE_VISIT_ROAS'),
  z.literal('TOTAL_WEB_PAGE_VISIT'),
  z.literal('TOTAL_WEB_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_CLICK_PAGE_VISIT'),
  z.literal('TOTAL_WEB_CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_ENGAGEMENT_PAGE_VISIT'),
  z.literal('TOTAL_WEB_ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_VIEW_PAGE_VISIT'),
  z.literal('TOTAL_WEB_VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
  z.literal('WEB_SIGNUP_COST_PER_ACTION'),
  z.literal('WEB_SIGNUP_ROAS'),
  z.literal('TOTAL_WEB_SIGNUP'),
  z.literal('TOTAL_WEB_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_CLICK_SIGNUP'),
  z.literal('TOTAL_WEB_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_ENGAGEMENT_SIGNUP'),
  z.literal('TOTAL_WEB_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_VIEW_SIGNUP'),
  z.literal('TOTAL_WEB_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('INAPP_SIGNUP_COST_PER_ACTION'),
  z.literal('INAPP_SIGNUP_ROAS'),
  z.literal('TOTAL_INAPP_SIGNUP'),
  z.literal('TOTAL_INAPP_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_CLICK_SIGNUP'),
  z.literal('TOTAL_INAPP_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_ENGAGEMENT_SIGNUP'),
  z.literal('TOTAL_INAPP_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_VIEW_SIGNUP'),
  z.literal('TOTAL_INAPP_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('OFFLINE_SIGNUP_COST_PER_ACTION'),
  z.literal('OFFLINE_SIGNUP_ROAS'),
  z.literal('TOTAL_OFFLINE_SIGNUP'),
  z.literal('TOTAL_OFFLINE_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_CLICK_SIGNUP'),
  z.literal('TOTAL_OFFLINE_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_ENGAGEMENT_SIGNUP'),
  z.literal('TOTAL_OFFLINE_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_VIEW_SIGNUP'),
  z.literal('TOTAL_OFFLINE_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
  z.literal('WEB_WATCH_VIDEO_COST_PER_ACTION'),
  z.literal('WEB_WATCH_VIDEO_ROAS'),
  z.literal('TOTAL_WEB_WATCH_VIDEO'),
  z.literal('TOTAL_WEB_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_CLICK_WATCH_VIDEO'),
  z.literal('TOTAL_WEB_CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO'),
  z.literal('TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_VIEW_WATCH_VIDEO'),
  z.literal('TOTAL_WEB_VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
  z.literal('WEB_LEAD_COST_PER_ACTION'),
  z.literal('WEB_LEAD_ROAS'),
  z.literal('TOTAL_WEB_LEAD'),
  z.literal('TOTAL_WEB_LEAD_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_CLICK_LEAD'),
  z.literal('TOTAL_WEB_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_ENGAGEMENT_LEAD'),
  z.literal('TOTAL_WEB_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_VIEW_LEAD'),
  z.literal('TOTAL_WEB_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR'),
  z.literal('OFFLINE_LEAD_COST_PER_ACTION'),
  z.literal('OFFLINE_LEAD_ROAS'),
  z.literal('TOTAL_OFFLINE_LEAD'),
  z.literal('TOTAL_OFFLINE_LEAD_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_CLICK_LEAD'),
  z.literal('TOTAL_OFFLINE_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_ENGAGEMENT_LEAD'),
  z.literal('TOTAL_OFFLINE_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_VIEW_LEAD'),
  z.literal('TOTAL_OFFLINE_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR'),
  z.literal('WEB_SEARCH_COST_PER_ACTION'),
  z.literal('WEB_SEARCH_ROAS'),
  z.literal('TOTAL_WEB_SEARCH'),
  z.literal('TOTAL_WEB_SEARCH_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_CLICK_SEARCH'),
  z.literal('TOTAL_WEB_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_ENGAGEMENT_SEARCH'),
  z.literal('TOTAL_WEB_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_VIEW_SEARCH'),
  z.literal('TOTAL_WEB_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR'),
  z.literal('INAPP_SEARCH_COST_PER_ACTION'),
  z.literal('INAPP_SEARCH_ROAS'),
  z.literal('TOTAL_INAPP_SEARCH'),
  z.literal('TOTAL_INAPP_SEARCH_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_CLICK_SEARCH'),
  z.literal('TOTAL_INAPP_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_ENGAGEMENT_SEARCH'),
  z.literal('TOTAL_INAPP_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_VIEW_SEARCH'),
  z.literal('TOTAL_INAPP_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR'),
  z.literal('WEB_VIEW_CATEGORY_COST_PER_ACTION'),
  z.literal('WEB_VIEW_CATEGORY_ROAS'),
  z.literal('TOTAL_WEB_VIEW_CATEGORY'),
  z.literal('TOTAL_WEB_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_CLICK_VIEW_CATEGORY'),
  z.literal('TOTAL_WEB_CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY'),
  z.literal('TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_VIEW_VIEW_CATEGORY'),
  z.literal('TOTAL_WEB_VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
  z.literal('WEB_CUSTOM_COST_PER_ACTION'),
  z.literal('WEB_CUSTOM_ROAS'),
  z.literal('TOTAL_WEB_CUSTOM'),
  z.literal('TOTAL_WEB_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_CLICK_CUSTOM'),
  z.literal('TOTAL_WEB_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_ENGAGEMENT_CUSTOM'),
  z.literal('TOTAL_WEB_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_VIEW_CUSTOM'),
  z.literal('TOTAL_WEB_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
  z.literal('OFFLINE_CUSTOM_COST_PER_ACTION'),
  z.literal('OFFLINE_CUSTOM_ROAS'),
  z.literal('TOTAL_OFFLINE_CUSTOM'),
  z.literal('TOTAL_OFFLINE_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_CLICK_CUSTOM'),
  z.literal('TOTAL_OFFLINE_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_ENGAGEMENT_CUSTOM'),
  z.literal('TOTAL_OFFLINE_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_VIEW_CUSTOM'),
  z.literal('TOTAL_OFFLINE_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
  z.literal('WEB_UNKNOWN_COST_PER_ACTION'),
  z.literal('WEB_UNKNOWN_ROAS'),
  z.literal('TOTAL_WEB_UNKNOWN'),
  z.literal('TOTAL_WEB_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_CLICK_UNKNOWN'),
  z.literal('TOTAL_WEB_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_ENGAGEMENT_UNKNOWN'),
  z.literal('TOTAL_WEB_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_WEB_VIEW_UNKNOWN'),
  z.literal('TOTAL_WEB_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('INAPP_UNKNOWN_COST_PER_ACTION'),
  z.literal('INAPP_UNKNOWN_ROAS'),
  z.literal('TOTAL_INAPP_UNKNOWN'),
  z.literal('TOTAL_INAPP_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_CLICK_UNKNOWN'),
  z.literal('TOTAL_INAPP_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_ENGAGEMENT_UNKNOWN'),
  z.literal('TOTAL_INAPP_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_VIEW_UNKNOWN'),
  z.literal('TOTAL_INAPP_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('OFFLINE_UNKNOWN_COST_PER_ACTION'),
  z.literal('OFFLINE_UNKNOWN_ROAS'),
  z.literal('TOTAL_OFFLINE_UNKNOWN'),
  z.literal('TOTAL_OFFLINE_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_CLICK_UNKNOWN'),
  z.literal('TOTAL_OFFLINE_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN'),
  z.literal('TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_OFFLINE_VIEW_UNKNOWN'),
  z.literal('TOTAL_OFFLINE_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
  z.literal('INAPP_APP_INSTALL_COST_PER_ACTION'),
  z.literal('INAPP_APP_INSTALL_ROAS'),
  z.literal('TOTAL_INAPP_APP_INSTALL'),
  z.literal('TOTAL_INAPP_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_CLICK_APP_INSTALL'),
  z.literal('TOTAL_INAPP_CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_ENGAGEMENT_APP_INSTALL'),
  z.literal('TOTAL_INAPP_ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
  z.literal('TOTAL_INAPP_VIEW_APP_INSTALL'),
  z.literal('TOTAL_INAPP_VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
  z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_1'),
  z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_2'),
  z.literal('TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'),
  z.literal('LEADS'),
  z.literal('COST_PER_LEAD'),
  z.literal('QUIZ_COMPLETED'),
  z.literal('QUIZ_COMPLETION_RATE'),
  z.literal('SHOWCASE_PIN_CLICKTHROUGH'),
  z.literal('SHOWCASE_SUBPAGE_CLICKTHROUGH'),
  z.literal('SHOWCASE_SUBPIN_CLICKTHROUGH'),
  z.literal('SHOWCASE_SUBPAGE_IMPRESSION'),
  z.literal('SHOWCASE_SUBPIN_IMPRESSION'),
  z.literal('SHOWCASE_SUBPAGE_SWIPE_LEFT'),
  z.literal('SHOWCASE_SUBPAGE_SWIPE_RIGHT'),
  z.literal('SHOWCASE_SUBPIN_SWIPE_LEFT'),
  z.literal('SHOWCASE_SUBPIN_SWIPE_RIGHT'),
  z.literal('SHOWCASE_SUBPAGE_REPIN'),
  z.literal('SHOWCASE_SUBPIN_REPIN'),
  z.literal('SHOWCASE_SUBPAGE_CLOSEUP'),
  z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'),
  z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'),
  z.literal('SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'),
  z.literal('TOTAL_CHECKOUT_CONVERSION_RATE'),
  z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_RATE'),
  z.literal('TOTAL_ADD_TO_CART_CONVERSION_RATE'),
  z.literal('TOTAL_SIGNUP_CONVERSION_RATE'),
  z.literal('TOTAL_PAGE_VISIT_CONVERSION_RATE'),
  z.literal('TOTAL_LEAD_CONVERSION_RATE'),
  z.literal('TOTAL_SEARCH_CONVERSION_RATE'),
  z.literal('TOTAL_WATCH_VIDEO_CONVERSION_RATE'),
  z.literal('TOTAL_UNKNOWN_CONVERSION_RATE'),
  z.literal('TOTAL_CUSTOM_CONVERSION_RATE'),
  z.literal('STANDARD_AD_FEED_ITEM_ID'),
]);

export const metricsReportingLevelSchema = z.union([
  z.literal('ADVERTISER'),
  z.literal('ADVERTISER_TARGETING'),
  z.literal('CAMPAIGN'),
  z.literal('CAMPAIGN_TARGETING'),
  z.literal('AD_GROUP'),
  z.literal('AD_GROUP_TARGETING'),
  z.literal('PIN_PROMOTION'),
  z.literal('PIN_PROMOTION_TARGETING'),
  z.literal('KEYWORD'),
  z.literal('PRODUCT_GROUP'),
  z.literal('PRODUCT_GROUP_TARGETING'),
  z.literal('PRODUCT_ITEM'),
  z.literal('PRODUCT_ITEM_TARGETING'),
]);

export const dataOutputFormatSchema = z.union([z.literal('JSON'), z.literal('CSV')]);

export const bulkReportingJobStatusSchema = z.union([
  z.literal('DOES_NOT_EXIST'),
  z.literal('FINISHED'),
  z.literal('IN_PROGRESS'),
  z.literal('EXPIRED'),
  z.literal('FAILED'),
  z.literal('CANCELLED'),
]);

export const adsAnalyticsFilterColumnSchema = z.union([z.literal('SPEND_IN_DOLLAR'), z.literal('TOTAL_IMPRESSION')]);

export const adsAnalyticsFilterOperatorSchema = z.union([z.literal('LESS_THAN'), z.literal('GREATER_THAN')]);

export const adsAnalyticsGetAsyncResponseSchema = z.object({
  report_status: bulkReportingJobStatusSchema.optional(),
  url: z.string().optional().nullable(),
  size: z.number().optional().nullable(),
});

export const adsAnalyticsMetricsFilterSchema = z.object({
  field: adsAnalyticsFilterColumnSchema,
  operator: adsAnalyticsFilterOperatorSchema,
  values: z.array(z.number()),
});

export const adsAnalyticsResponseSchema = z.array(
  z.record(z.union([z.unknown(), z.string()])).and(
    z.object({
      AD_ID: z.string(),
      DATE: z.string().optional(),
    }),
  ),
);

export const adsAnalyticsTargetingTypeSchema = z.union([
  z.literal('KEYWORD'),
  z.literal('APPTYPE'),
  z.literal('GENDER'),
  z.literal('LOCATION'),
  z.literal('PLACEMENT'),
  z.literal('COUNTRY'),
  z.literal('TARGETED_INTEREST'),
  z.literal('PINNER_INTEREST'),
  z.literal('AUDIENCE_INCLUDE'),
  z.literal('GEO'),
  z.literal('AGE_BUCKET'),
  z.literal('REGION'),
  z.literal('AGE_BUCKET_AND_GENDER'),
]);

export const adsCreditDiscountsResponseSchema = z.object({
  active: z.boolean().optional(),
  advertiser_id: z.string().optional(),
  discountType: z
    .union([
      z.literal('COUPON'),
      z.literal('CREDIT'),
      z.literal('COUPON_APPLIED'),
      z.literal('CREDIT_APPLIED'),
      z.literal('MARKETING_OFFER_CREDIT'),
      z.literal('MARKETING_OFFER_CREDIT_APPLIED'),
      z.literal('GOODWILL_CREDIT'),
      z.literal('GOODWILL_CREDIT_APPLIED'),
      z.literal('INTERNAL_CREDIT'),
      z.literal('INTERNAL_CREDIT_APPLIED'),
      z.literal('PREPAID_CREDIT'),
      z.literal('PREPAID_CREDIT_APPLIED'),
      z.literal('SALES_INCENTIVE_CREDIT'),
      z.literal('SALES_INCENTIVE_CREDIT_APPLIED'),
      z.literal('CREDIT_EXPIRED'),
      z.literal('FUTURE_CREDIT'),
      z.literal('REFERRAL_CREDIT'),
      z.literal('INVOICE_SALES_INCENTIVE_CREDIT'),
      z.literal('INVOICE_SALES_INCENTIVE_CREDIT_APPLIED'),
      z.literal('PREPAID_CREDIT_REFUND'),
    ])
    .optional()
    .nullable(),
  discountInMicroCurrency: z.number().optional().nullable(),
  discountCurrency: z.string().optional().nullable(),
  title: z.string().optional().nullable(),
  remainingDiscountInMicroCurrency: z.number().optional().nullable(),
});

export const discountTypeSchema = z.union([
  z.literal('COUPON'),
  z.literal('CREDIT'),
  z.literal('COUPON_APPLIED'),
  z.literal('CREDIT_APPLIED'),
  z.literal('MARKETING_OFFER_CREDIT'),
  z.literal('MARKETING_OFFER_CREDIT_APPLIED'),
  z.literal('GOODWILL_CREDIT'),
  z.literal('GOODWILL_CREDIT_APPLIED'),
  z.literal('INTERNAL_CREDIT'),
  z.literal('INTERNAL_CREDIT_APPLIED'),
  z.literal('PREPAID_CREDIT'),
  z.literal('PREPAID_CREDIT_APPLIED'),
  z.literal('SALES_INCENTIVE_CREDIT'),
  z.literal('SALES_INCENTIVE_CREDIT_APPLIED'),
  z.literal('CREDIT_EXPIRED'),
  z.literal('FUTURE_CREDIT'),
  z.literal('REFERRAL_CREDIT'),
  z.literal('INVOICE_SALES_INCENTIVE_CREDIT'),
  z.literal('INVOICE_SALES_INCENTIVE_CREDIT_APPLIED'),
  z.literal('PREPAID_CREDIT_REFUND'),
]);

export const adsCreditRedeemRequestSchema = z.object({
  offerCodeHash: z.string(),
  validateOnly: z.boolean(),
});

export const adsCreditRedeemResponseSchema = z.object({
  success: z.boolean().optional(),
  errorCode: z.number().optional().nullable(),
  errorMessage: z.string().optional().nullable(),
});

export const ageBucketListSchema = z.array(
  z.union([
    z.literal('18-24'),
    z.literal('25-34'),
    z.literal('35-44'),
    z.literal('45-49'),
    z.literal('50-54'),
    z.literal('55-64'),
    z.literal('65+'),
  ]),
);

export const dataStatusSchema = z.union([
  z.literal('PROCESSING'),
  z.literal('READY'),
  z.literal('ESTIMATE'),
  z.literal('BEFORE_BUSINESS_CREATED'),
  z.literal('BEFORE_DATA_RETENTION_PERIOD'),
  z.literal('BEFORE_PIN_DATA_RETENTION_PERIOD'),
  z.literal('BEFORE_METRIC_START_DATE'),
  z.literal('BEFORE_CORE_METRIC_START_DATE'),
  z.literal('BEFORE_PIN_FORMAT_METRIC_START_DATE'),
  z.literal('BEFORE_AUDIENCE_METRIC_START_DATE'),
  z.literal('BEFORE_AUDIENCE_MONTHLY_METRIC_START_DATE'),
  z.literal('BEFORE_VIDEO_METRIC_START_DATE'),
  z.literal('BEFORE_CONVERSION_METRIC_START_DATE'),
  z.literal('PURCHASERS_METRIC_SMALLER_THAN_THRESHOLD'),
  z.literal('IN_BAD_TAG_DATE'),
  z.literal('BEFORE_PUBLISHED_METRIC_START_DATE'),
  z.literal('BEFORE_ASSIST_METRIC_START_DATE'),
  z.literal('BEFORE_PIN_CREATED'),
  z.literal('BEFORE_ACCOUNT_CLAIMED'),
  z.literal('BEFORE_DEMOGRAPHIC_FILTERS_START_DATE'),
  z.literal('AUDIENCE_SEGMENT_SMALLER_THAN_THRESHOLD'),
  z.literal('AUDIENCE_TOTAL_SMALLER_THAN_THRESHOLD'),
  z.literal('BEFORE_PRODUCT_GROUP_FILTER_START_DATE'),
]);

export const metricsSchema = z.record(z.number());

export const analyticsDailyMetricsSchema = z.object({
  data_status: dataStatusSchema.optional(),
  date: z.string().optional(),
  metrics: metricsSchema.optional(),
});

export const assetTypeResponseSchema = z.string();

export const permissionsResponseSchema = z.array(z.string());

export const audienceRuleSchema = z.object({
  country: z.string().optional(),
  customer_list_id: z.string().optional(),
  engagement_domain: z.array(z.string()).optional(),
  engagement_type: z.string().optional(),
  event: z.string().optional(),
  event_data: z
    .object({
      currency: currencySchema.optional(),
      lead_type: z.string().optional(),
      line_items: z
        .object({
          product_brand: z.string().optional(),
          product_category: z.string().optional(),
          product_id: z.number().optional(),
          product_name: z.string().optional(),
          product_price: z.string().optional(),
          product_quantity: z.number().optional(),
          product_variant: z.string().optional(),
          product_variant_id: z.string().optional(),
        })
        .optional(),
      order_id: z.string().optional(),
      order_quantity: z.number().optional(),
      page_name: z.string().optional(),
      promo_code: z.string().optional(),
      property: z.string().optional(),
      search_query: z.string().optional(),
      value: z.string().optional(),
      video_title: z.string().optional(),
    })
    .optional(),
  percentage: z.number().optional(),
  pin_id: z.array(z.string()).optional(),
  prefill: z.boolean().optional(),
  retention_days: z.number().optional(),
  seed_id: z.array(z.string()).optional(),
  url: z.array(z.string()).optional(),
  visitor_source_id: z.string().optional(),
  event_source: z.record(z.unknown()).optional(),
  ingestion_source: z.record(z.unknown()).optional(),
  engager_type: z.number().optional(),
  campaign_id: z.array(z.string()).optional(),
  ad_id: z.array(z.string()).optional(),
  objective_type: z.array(objectiveTypeSchema).optional(),
  ad_account_id: z.string().optional(),
});

export const audienceCategorySchema = z.object({
  key: z.string().optional(),
  name: z.string().optional(),
  ratio: z.number().optional(),
  index: z.number().optional(),
  id: z.string().optional(),
  subcategories: z
    .array(
      z.object({
        key: z.string().optional(),
        name: z.string().optional(),
        ratio: z.number().optional(),
        index: z.number().optional(),
        id: z.string().optional(),
      }),
    )
    .optional(),
});

export const audienceCommonSchema = z.object({
  ad_account_id: z.string().optional(),
  name: z.string().optional(),
  rule: audienceRuleSchema.optional(),
});

export const audienceSharingTypeSchema = z.union([z.literal('CUSTOM'), z.literal('SYNDICATED')]);

export const audienceDataPartySchema = z.union([z.literal('1p'), z.literal('3p')]);

export const audienceDescriptionSchema = z.string();

export const audienceTypeSchema = z.union([
  z.literal('CUSTOMER_LIST'),
  z.literal('VISITOR'),
  z.literal('ENGAGEMENT'),
  z.literal('ACTALIKE'),
  z.literal('PERSONA'),
]);

export const audienceDefinitionTypeSchema = z.object({
  scope: z.union([z.literal('IMPRESSION_PLUS_ENGAGEMENT'), z.literal('ENGAGEMENT')]).optional(),
});

export const audienceDefinitionScopeSchema = z.object({
  scope: z.union([z.literal('PARTNER'), z.literal('PINTEREST')]).optional(),
});

export const audienceDefinitionSchema = z.object({
  date: z.string().optional().nullable(),
  type: audienceDefinitionTypeSchema.optional(),
  scope: audienceDefinitionScopeSchema.optional(),
});

export const scopeSchema = z.union([z.literal('PARTNER'), z.literal('PINTEREST')]);

export const scope2Schema = z.union([z.literal('IMPRESSION_PLUS_ENGAGEMENT'), z.literal('ENGAGEMENT')]);

export const audienceDemographicValueSchema = z.object({
  key: z.string().optional(),
  name: z.string().optional(),
  ratio: z.number().optional(),
});

export const audienceDemographicsSchema = z.object({
  ages: z.array(audienceDemographicValueSchema).optional(),
  genders: z.array(audienceDemographicValueSchema).optional(),
  devices: z.array(audienceDemographicValueSchema).optional(),
  metros: z.array(audienceDemographicValueSchema).optional(),
  countries: z.array(audienceDemographicValueSchema).optional(),
});

export const audienceInsightCategoryCommonSchema = z.object({
  key: z.string().optional(),
  name: z.string().optional(),
  ratio: z.number().optional(),
  index: z.number().optional(),
  id: z.string().optional(),
});

export const audienceInsightTypeSchema = z.union([
  z.literal('YOUR_TOTAL_AUDIENCE'),
  z.literal('YOUR_ENGAGED_AUDIENCE'),
  z.literal('PINTEREST_TOTAL_AUDIENCE'),
]);

export const audienceInsightsResponseSchema = z.object({
  categories: z.array(audienceCategorySchema).optional(),
  demographics: audienceDemographicsSchema.optional(),
  type: audienceInsightTypeSchema.optional(),
  date: z.string().optional().nullable(),
  size: z.number().optional(),
  size_is_upper_bound: z.boolean().optional(),
});

export const audienceShareTypeSchema = z.union([z.literal('SHARED'), z.literal('RECEIVED')]);

export const audienceAccountTypeSchema = z.union([z.literal('AD_ACCOUNT'), z.literal('BUSINESS_ACCOUNT')]);

export const audienceUpdateOperationTypeSchema = z.union([z.literal('UPDATE'), z.literal('REMOVE')]);

export const audienceUpdateRequestSchema = audienceCommonSchema.and(
  z.object({
    description: audienceDescriptionSchema.optional(),
    operation_type: audienceUpdateOperationTypeSchema.optional(),
  }),
);

export const catalogsProductGroupMultipleStringCriteriaSchema = z.object({
  values: z.array(z.string()),
  negated: z.boolean().optional(),
});

export const businessAccessUserSummarySchema = z.object({
  email: z.string().optional().nullable(),
  id: z.string().optional().nullable(),
  username: z.string().optional().nullable(),
});

export const batchOperationSchema = z.union([
  z.literal('UPDATE'),
  z.literal('UPSERT'),
  z.literal('CREATE'),
  z.literal('DELETE_DISCONTINUED'),
  z.literal('DELETE'),
]);

export const batchOperationStatusSchema = z.union([
  z.literal('PROCESSING'),
  z.literal('COMPLETED'),
  z.literal('FAILED'),
]);

export const bidFloorSchema = z.object({
  bid_floors: z.array(z.number()).optional(),
  type: z.string().optional(),
});

export const bidFloorRequestSchema = z.object({
  bid_floor_specs: z.array(
    z.object({
      countries: z.array(countrySchema).optional(),
      currency: currencySchema,
      objective_type: objectiveTypeSchema.optional(),
      billable_event: actionTypeSchema,
      optimization_goal_metadata: optimizationGoalMetadataSchema.optional(),
      creative_type: creativeTypeSchema.optional(),
    }),
  ),
  targeting_spec: targetingSpecSchema.optional(),
});

export const billingProfilesResponseSchema = z.object({
  id: z.string().optional(),
  card_type: z
    .union([
      z.literal('UNKNOWN'),
      z.literal('VISA'),
      z.literal('MASTERCARD'),
      z.literal('AMERICAN_EXPRESS'),
      z.literal('DISCOVER'),
      z.literal('ELO'),
    ])
    .optional(),
  status: z
    .union([
      z.literal('UNSPECIFIED'),
      z.literal('VALID'),
      z.literal('INVALID'),
      z.literal('PENDING'),
      z.literal('DELETED'),
      z.literal('SECONDARY'),
      z.literal('PENDING_SECONDARY'),
    ])
    .optional(),
  advertiser_id: z.string().optional(),
  payment_method_brand: z
    .union([
      z.literal('UNKNOWN'),
      z.literal('VISA'),
      z.literal('MASTERCARD'),
      z.literal('AMERICAN_EXPRESS'),
      z.literal('DISCOVER'),
      z.literal('SOFORT'),
      z.literal('DINERS_CLUB'),
      z.literal('ELO'),
      z.literal('CARTE_BANCAIRE'),
    ])
    .optional(),
});

export const cardTypeSchema = z.union([
  z.literal('UNKNOWN'),
  z.literal('VISA'),
  z.literal('MASTERCARD'),
  z.literal('AMERICAN_EXPRESS'),
  z.literal('DISCOVER'),
  z.literal('ELO'),
]);

export const statusSchema = z.union([
  z.literal('UNSPECIFIED'),
  z.literal('VALID'),
  z.literal('INVALID'),
  z.literal('PENDING'),
  z.literal('DELETED'),
  z.literal('SECONDARY'),
  z.literal('PENDING_SECONDARY'),
]);

export const paymentMethodBrandSchema = z.union([
  z.literal('UNKNOWN'),
  z.literal('VISA'),
  z.literal('MASTERCARD'),
  z.literal('AMERICAN_EXPRESS'),
  z.literal('DISCOVER'),
  z.literal('SOFORT'),
  z.literal('DINERS_CLUB'),
  z.literal('ELO'),
  z.literal('CARTE_BANCAIRE'),
]);

export const boardOwnerSchema = z.object({
  username: z.string().optional(),
});

export const privacySchema = z.union([z.literal('PUBLIC'), z.literal('PROTECTED'), z.literal('SECRET')]);

export const boardSectionSchema = z.object({
  id: z.string().optional(),
  name: z.string(),
});

export const boardUpdateSchema = z.object({
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  privacy: z.union([z.literal('PUBLIC'), z.literal('SECRET')]).optional(),
});

export const privacy2Schema = z.union([z.literal('PUBLIC'), z.literal('SECRET')]);

export const bookClosedResponseSchema = z.object({
  conversion_metrics_ready: z.boolean().optional(),
  non_conversion_metrics_ready: z.boolean().optional(),
});

export const brandFilterSchema = z.object({
  BRAND: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const bulkEntityTypeSchema = z.union([
  z.literal('CAMPAIGN'),
  z.literal('AD_GROUP'),
  z.literal('PRODUCT_GROUP'),
  z.literal('AD'),
  z.literal('KEYWORD'),
]);

export const bulkOutputFormatSchema = z.union([z.literal('CSV'), z.literal('JSON')]);

export const bulkDownloadResponseSchema = z.object({
  request_id: z.string().optional(),
});

export const adGroupCreateRequestSchema = adGroupCommonSchema.and(
  z.object({
    pacing_delivery_type: pacingDeliveryTypeSchema.optional(),
    auto_targeting_enabled: z.boolean().optional(),
    budget_type: budgetTypeSchema.optional(),
  }),
);

export const keywordUpdateSchema = z.object({
  id: z.string(),
  archived: z.boolean().optional(),
  bid: z.number().optional().nullable(),
});

export const bulkUpsertResponseSchema = z.object({
  request_id: z.string().optional(),
});

export const bulkUpsertStatusSchema = z.union([z.literal('RUNNING'), z.literal('SUCCEEDED'), z.literal('FAILED')]);

export const bulkUpsertStatusResponseSchema = z.object({
  status: bulkUpsertStatusSchema.optional(),
  result_url: z.string().optional(),
});

export const businessAccessErrorSchema = z
  .object({
    code: z.number(),
    message: z.string(),
  })
  .nullable();

export const businessMemberAssetsSummarySchema = z
  .object({
    ad_accounts: z
      .array(
        z.object({
          id: z.string().optional(),
          permissions: permissionsResponseSchema.optional(),
        }),
      )
      .optional(),
    profiles: z
      .array(
        z.object({
          id: z.string().optional(),
          permissions: permissionsResponseSchema.optional(),
        }),
      )
      .optional(),
  })
  .nullable();

export const businessRoleCheckModeSchema = z.union([z.literal('INTERNAL'), z.literal('EXTERNAL')]);

export const businessRoleSchema = z.union([z.literal('EMPLOYEE'), z.literal('BIZ_ADMIN'), z.literal('PARTNER')]);

export const businessRoleForMembersSchema = z.union([z.literal('EMPLOYEE'), z.literal('BIZ_ADMIN')]);

export const businessRoleResponseSchema = z.string();

export const permissionsSchema = z.union([
  z.literal('ADMIN'),
  z.literal('ANALYST'),
  z.literal('FINANCE_MANAGER'),
  z.literal('AUDIENCE_MANAGER'),
  z.literal('CAMPAIGN_MANAGER'),
  z.literal('CATALOGS_MANAGER'),
  z.literal('PROFILE_PUBLISHER'),
]);

export const deletePartnerAssetAccessBodySchema = z.object({
  accesses: z.array(
    z.object({
      partner_id: z.string(),
      asset_id: z.string(),
      partner_type: z.union([z.literal('INTERNAL'), z.literal('EXTERNAL')]).optional(),
    }),
  ),
});

export const deletePartnerAssetsResultSchema = z.object({
  asset_id: z.string().optional(),
  asset_type: assetTypeResponseSchema.optional(),
  permissions: permissionsResponseSchema.optional(),
  is_shared_partner: z.boolean().optional(),
  partner_id: z.string().optional(),
});

export const deletePartnerAssetsResultsResponseArraySchema = z.object({
  items: z.array(deletePartnerAssetsResultSchema).optional(),
});

export const updateMemberResultSchema = z.object({
  business_role: z.string().optional(),
  member_id: z.string().optional(),
});

export const updateMemberResultsResponseArraySchema = z.object({
  items: z.array(updateMemberResultSchema).optional(),
});

export const updateMemberBusinessRoleBodySchema = z.object({
  business_role: businessRoleForMembersSchema,
  member_id: z.string(),
});

export const updateMemberAssetAccessBodySchema = z.object({
  accesses: z.array(
    z.object({
      asset_id: z.string(),
      member_id: z.string(),
      permissions: z.array(permissionsSchema),
    }),
  ),
});

export const campaignIsFlexibleDailyBudgetsSchema = z.boolean().nullable();

export const campaignCommonSchema = z.object({
  ad_account_id: z.string().optional(),
  name: z.string().optional(),
  status: entityStatusSchema.optional(),
  lifetime_spend_cap: z.number().optional().nullable(),
  daily_spend_cap: z.number().optional().nullable(),
  order_line_id: z.string().optional().nullable(),
  tracking_urls: trackingUrlsSchema.optional().nullable(),
  start_time: z.number().optional().nullable(),
  end_time: z.number().optional().nullable(),
  is_flexible_daily_budgets: campaignIsFlexibleDailyBudgetsSchema.optional(),
});

export const campaignIsAutomatedCampaignSchema = z.boolean().nullable();

export const campaignCreateCommonSchema = campaignCommonSchema.and(
  z.object({
    default_ad_group_budget_in_micro_currency: z.number().optional().nullable(),
    is_automated_campaign: campaignIsAutomatedCampaignSchema.optional(),
  }),
);

export const campaignIdSchema = z.object({
  id: z.string().optional(),
});

export const campaignIsCampaignBudgetOptimizationSchema = z.boolean().nullable();

export const campaignResponseSchema = campaignIdSchema.and(campaignCommonSchema).and(
  z.object({
    objective_type: objectiveTypeSchema.optional(),
    created_time: z.number().optional(),
    updated_time: z.number().optional(),
    type: z.string().optional(),
    is_campaign_budget_optimization: campaignIsCampaignBudgetOptimizationSchema.optional(),
    summary_status: campaignSummaryStatusSchema.optional(),
  }),
);

export const campaignUpdateRequestSchema = campaignIdSchema.and(campaignCreateCommonSchema).and(
  z.object({
    is_campaign_budget_optimization: campaignIsCampaignBudgetOptimizationSchema.optional(),
    objective_type: objectiveTypeSchema.optional().nullable(),
  }),
);

export const campaignsAnalyticsResponseSchema = z.array(
  z.record(z.union([z.unknown(), z.string()])).and(
    z.object({
      CAMPAIGN_ID: z.string(),
      DATE: z.string().optional(),
    }),
  ),
);

export const cancelInvitesBodySchema = z.object({
  invite_ids: z.array(z.string()),
});

export const catalogsDbItemSchema = z.object({
  created_at: z.string(),
  id: z.string(),
  updated_at: z.string(),
});

export const catalogsTypeSchema = z.union([z.literal('RETAIL'), z.literal('HOTEL'), z.literal('CREATIVE_ASSETS')]);

export const catalogsCreateRequestSchema = z.object({
  catalog_type: z.literal('HOTEL'),
  name: z.string(),
});

export const catalogTypeSchema = z.literal('HOTEL');

export const catalogsCreateReportResponseSchema = z.object({
  token: z.string().optional(),
});

export const catalogsReportSchema = z.object({
  report_status: z.union([z.literal('FINISHED'), z.literal('IN_PROGRESS')]).optional(),
  url: z.string().optional().nullable(),
  size: z.number().optional().nullable(),
});

export const reportStatusSchema = z.union([z.literal('FINISHED'), z.literal('IN_PROGRESS')]);

export const catalogsReportFeedIngestionStatsSchema = z.object({
  report_type: z.literal('FEED_INGESTION_ISSUES').optional(),
  catalog_id: z.string().optional(),
  code: z.number().optional(),
  code_label: z.string().optional(),
  message: z.string().optional(),
  occurrences: z.number().optional(),
  severity: z.union([z.literal('WARN'), z.literal('ERROR')]).optional(),
});

export const catalogsReportDistributionStatsSchema = z.object({
  report_type: z.literal('DISTRIBUTION_ISSUES').optional(),
  catalog_id: z.string().optional(),
  code: z.number().optional(),
  code_label: z.string().optional(),
  message: z.string().optional(),
  occurrences: z.number().optional(),
  ineligible_for_ads: z.boolean().optional(),
  ineligible_for_organic: z.boolean().optional(),
});

export const reportTypeSchema = z.union([z.literal('FEED_INGESTION_ISSUES'), z.literal('DISTRIBUTION_ISSUES')]);

export const severitySchema = z.union([z.literal('WARN'), z.literal('ERROR')]);

export const catalogsReportFeedIngestionFilterSchema = z.object({
  report_type: z.literal('FEED_INGESTION_ISSUES'),
  feed_id: z.string(),
  processing_result_id: z.string().optional(),
});

export const catalogsReportDistributionIssueFilterSchema = z.object({
  report_type: z.literal('DISTRIBUTION_ISSUES'),
  catalog_id: z.string().optional(),
});

export const catalogsRetailReportParametersSchema = z.object({
  catalog_type: z.literal('RETAIL'),
  report: z.union([catalogsReportFeedIngestionFilterSchema, catalogsReportDistributionIssueFilterSchema]).and(
    z.object({
      report_type: z.union([z.literal('FEED_INGESTION_ISSUES'), z.literal('DISTRIBUTION_ISSUES')]).optional(),
    }),
  ),
});

export const reportType2Schema = z.literal('FEED_INGESTION_ISSUES');

export const reportType3Schema = z.literal('DISTRIBUTION_ISSUES');

export const catalogsDeleteHotelItemSchema = z.object({
  hotel_id: z.string(),
  operation: z.literal('DELETE'),
});

export const catalogsFormatSchema = z.union([z.literal('TSV'), z.literal('CSV'), z.literal('XML')]);

export const catalogsFeedCredentialsSchema = z
  .object({
    password: z.string(),
    username: z.string(),
  })
  .nullable();

export const catalogsFeedProcessingScheduleSchema = z
  .object({
    time: z.string(),
    timezone: z
      .union([
        z.literal('Africa/Abidjan'),
        z.literal('Africa/Accra'),
        z.literal('Africa/Algiers'),
        z.literal('Africa/Bissau'),
        z.literal('Africa/Cairo'),
        z.literal('Africa/Casablanca'),
        z.literal('Africa/Ceuta'),
        z.literal('Africa/El_Aaiun'),
        z.literal('Africa/Johannesburg'),
        z.literal('Africa/Juba'),
        z.literal('Africa/Khartoum'),
        z.literal('Africa/Lagos'),
        z.literal('Africa/Maputo'),
        z.literal('Africa/Monrovia'),
        z.literal('Africa/Nairobi'),
        z.literal('Africa/Ndjamena'),
        z.literal('Africa/Sao_Tome'),
        z.literal('Africa/Tripoli'),
        z.literal('Africa/Tunis'),
        z.literal('Africa/Windhoek'),
        z.literal('America/Adak'),
        z.literal('America/Anchorage'),
        z.literal('America/Araguaina'),
        z.literal('America/Argentina/Buenos_Aires'),
        z.literal('America/Argentina/Catamarca'),
        z.literal('America/Argentina/Cordoba'),
        z.literal('America/Argentina/Jujuy'),
        z.literal('America/Argentina/La_Rioja'),
        z.literal('America/Argentina/Mendoza'),
        z.literal('America/Argentina/Rio_Gallegos'),
        z.literal('America/Argentina/Salta'),
        z.literal('America/Argentina/San_Juan'),
        z.literal('America/Argentina/San_Luis'),
        z.literal('America/Argentina/Tucuman'),
        z.literal('America/Argentina/Ushuaia'),
        z.literal('America/Asuncion'),
        z.literal('America/Atikokan'),
        z.literal('America/Bahia'),
        z.literal('America/Bahia_Banderas'),
        z.literal('America/Barbados'),
        z.literal('America/Belem'),
        z.literal('America/Belize'),
        z.literal('America/Blanc-Sablon'),
        z.literal('America/Boa_Vista'),
        z.literal('America/Bogota'),
        z.literal('America/Boise'),
        z.literal('America/Cambridge_Bay'),
        z.literal('America/Campo_Grande'),
        z.literal('America/Cancun'),
        z.literal('America/Caracas'),
        z.literal('America/Cayenne'),
        z.literal('America/Chicago'),
        z.literal('America/Chihuahua'),
        z.literal('America/Costa_Rica'),
        z.literal('America/Creston'),
        z.literal('America/Cuiaba'),
        z.literal('America/Curacao'),
        z.literal('America/Danmarkshavn'),
        z.literal('America/Dawson'),
        z.literal('America/Dawson_Creek'),
        z.literal('America/Denver'),
        z.literal('America/Detroit'),
        z.literal('America/Edmonton'),
        z.literal('America/Eirunepe'),
        z.literal('America/El_Salvador'),
        z.literal('America/Fort_Nelson'),
        z.literal('America/Fortaleza'),
        z.literal('America/Glace_Bay'),
        z.literal('America/Goose_Bay'),
        z.literal('America/Grand_Turk'),
        z.literal('America/Guatemala'),
        z.literal('America/Guayaquil'),
        z.literal('America/Guyana'),
        z.literal('America/Halifax'),
        z.literal('America/Havana'),
        z.literal('America/Hermosillo'),
        z.literal('America/Indiana/Indianapolis'),
        z.literal('America/Indiana/Knox'),
        z.literal('America/Indiana/Marengo'),
        z.literal('America/Indiana/Petersburg'),
        z.literal('America/Indiana/Tell_City'),
        z.literal('America/Indiana/Vevay'),
        z.literal('America/Indiana/Vincennes'),
        z.literal('America/Indiana/Winamac'),
        z.literal('America/Inuvik'),
        z.literal('America/Iqaluit'),
        z.literal('America/Jamaica'),
        z.literal('America/Juneau'),
        z.literal('America/Kentucky/Louisville'),
        z.literal('America/Kentucky/Monticello'),
        z.literal('America/La_Paz'),
        z.literal('America/Lima'),
        z.literal('America/Los_Angeles'),
        z.literal('America/Maceio'),
        z.literal('America/Managua'),
        z.literal('America/Manaus'),
        z.literal('America/Martinique'),
        z.literal('America/Matamoros'),
        z.literal('America/Mazatlan'),
        z.literal('America/Menominee'),
        z.literal('America/Merida'),
        z.literal('America/Metlakatla'),
        z.literal('America/Mexico_City'),
        z.literal('America/Miquelon'),
        z.literal('America/Moncton'),
        z.literal('America/Monterrey'),
        z.literal('America/Montevideo'),
        z.literal('America/Nassau'),
        z.literal('America/New_York'),
        z.literal('America/Nipigon'),
        z.literal('America/Nome'),
        z.literal('America/Noronha'),
        z.literal('America/North_Dakota/Beulah'),
        z.literal('America/North_Dakota/Center'),
        z.literal('America/North_Dakota/New_Salem'),
        z.literal('America/Nuuk'),
        z.literal('America/Ojinaga'),
        z.literal('America/Panama'),
        z.literal('America/Pangnirtung'),
        z.literal('America/Paramaribo'),
        z.literal('America/Phoenix'),
        z.literal('America/Port-au-Prince'),
        z.literal('America/Port_of_Spain'),
        z.literal('America/Porto_Velho'),
        z.literal('America/Puerto_Rico'),
        z.literal('America/Punta_Arenas'),
        z.literal('America/Rainy_River'),
        z.literal('America/Rankin_Inlet'),
        z.literal('America/Recife'),
        z.literal('America/Regina'),
        z.literal('America/Resolute'),
        z.literal('America/Rio_Branco'),
        z.literal('America/Santarem'),
        z.literal('America/Santiago'),
        z.literal('America/Santo_Domingo'),
        z.literal('America/Sao_Paulo'),
        z.literal('America/Scoresbysund'),
        z.literal('America/Sitka'),
        z.literal('America/St_Johns'),
        z.literal('America/Swift_Current'),
        z.literal('America/Tegucigalpa'),
        z.literal('America/Thule'),
        z.literal('America/Thunder_Bay'),
        z.literal('America/Tijuana'),
        z.literal('America/Toronto'),
        z.literal('America/Vancouver'),
        z.literal('America/Whitehorse'),
        z.literal('America/Winnipeg'),
        z.literal('America/Yakutat'),
        z.literal('America/Yellowknife'),
        z.literal('Antarctica/Casey'),
        z.literal('Antarctica/Davis'),
        z.literal('Antarctica/DumontDUrville'),
        z.literal('Antarctica/Macquarie'),
        z.literal('Antarctica/Mawson'),
        z.literal('Antarctica/Palmer'),
        z.literal('Antarctica/Rothera'),
        z.literal('Antarctica/Syowa'),
        z.literal('Antarctica/Troll'),
        z.literal('Antarctica/Vostok'),
        z.literal('Asia/Almaty'),
        z.literal('Asia/Amman'),
        z.literal('Asia/Anadyr'),
        z.literal('Asia/Aqtau'),
        z.literal('Asia/Aqtobe'),
        z.literal('Asia/Ashgabat'),
        z.literal('Asia/Atyrau'),
        z.literal('Asia/Baghdad'),
        z.literal('Asia/Baku'),
        z.literal('Asia/Bangkok'),
        z.literal('Asia/Barnaul'),
        z.literal('Asia/Beirut'),
        z.literal('Asia/Bishkek'),
        z.literal('Asia/Brunei'),
        z.literal('Asia/Chita'),
        z.literal('Asia/Choibalsan'),
        z.literal('Asia/Colombo'),
        z.literal('Asia/Damascus'),
        z.literal('Asia/Dhaka'),
        z.literal('Asia/Dili'),
        z.literal('Asia/Dubai'),
        z.literal('Asia/Dushanbe'),
        z.literal('Asia/Famagusta'),
        z.literal('Asia/Gaza'),
        z.literal('Asia/Hebron'),
        z.literal('Asia/Ho_Chi_Minh'),
        z.literal('Asia/Hong_Kong'),
        z.literal('Asia/Hovd'),
        z.literal('Asia/Irkutsk'),
        z.literal('Asia/Jakarta'),
        z.literal('Asia/Jayapura'),
        z.literal('Asia/Jerusalem'),
        z.literal('Asia/Kabul'),
        z.literal('Asia/Kamchatka'),
        z.literal('Asia/Karachi'),
        z.literal('Asia/Kathmandu'),
        z.literal('Asia/Khandyga'),
        z.literal('Asia/Kolkata'),
        z.literal('Asia/Krasnoyarsk'),
        z.literal('Asia/Kuala_Lumpur'),
        z.literal('Asia/Kuching'),
        z.literal('Asia/Macau'),
        z.literal('Asia/Magadan'),
        z.literal('Asia/Makassar'),
        z.literal('Asia/Manila'),
        z.literal('Asia/Nicosia'),
        z.literal('Asia/Novokuznetsk'),
        z.literal('Asia/Novosibirsk'),
        z.literal('Asia/Omsk'),
        z.literal('Asia/Oral'),
        z.literal('Asia/Pontianak'),
        z.literal('Asia/Pyongyang'),
        z.literal('Asia/Qatar'),
        z.literal('Asia/Qostanay'),
        z.literal('Asia/Qyzylorda'),
        z.literal('Asia/Riyadh'),
        z.literal('Asia/Sakhalin'),
        z.literal('Asia/Samarkand'),
        z.literal('Asia/Seoul'),
        z.literal('Asia/Shanghai'),
        z.literal('Asia/Singapore'),
        z.literal('Asia/Srednekolymsk'),
        z.literal('Asia/Taipei'),
        z.literal('Asia/Tashkent'),
        z.literal('Asia/Tbilisi'),
        z.literal('Asia/Tehran'),
        z.literal('Asia/Thimphu'),
        z.literal('Asia/Tokyo'),
        z.literal('Asia/Tomsk'),
        z.literal('Asia/Ulaanbaatar'),
        z.literal('Asia/Urumqi'),
        z.literal('Asia/Ust-Nera'),
        z.literal('Asia/Vladivostok'),
        z.literal('Asia/Yakutsk'),
        z.literal('Asia/Yangon'),
        z.literal('Asia/Yekaterinburg'),
        z.literal('Asia/Yerevan'),
        z.literal('Atlantic/Azores'),
        z.literal('Atlantic/Bermuda'),
        z.literal('Atlantic/Canary'),
        z.literal('Atlantic/Cape_Verde'),
        z.literal('Atlantic/Faroe'),
        z.literal('Atlantic/Madeira'),
        z.literal('Atlantic/Reykjavik'),
        z.literal('Atlantic/South_Georgia'),
        z.literal('Atlantic/Stanley'),
        z.literal('Australia/Adelaide'),
        z.literal('Australia/Brisbane'),
        z.literal('Australia/Broken_Hill'),
        z.literal('Australia/Currie'),
        z.literal('Australia/Darwin'),
        z.literal('Australia/Eucla'),
        z.literal('Australia/Hobart'),
        z.literal('Australia/Lindeman'),
        z.literal('Australia/Lord_Howe'),
        z.literal('Australia/Melbourne'),
        z.literal('Australia/Perth'),
        z.literal('Australia/Sydney'),
        z.literal('CET'),
        z.literal('CST6CDT'),
        z.literal('EET'),
        z.literal('EST'),
        z.literal('EST5EDT'),
        z.literal('Etc/GMT'),
        z.literal('Etc/GMT+1'),
        z.literal('Etc/GMT+10'),
        z.literal('Etc/GMT+11'),
        z.literal('Etc/GMT+12'),
        z.literal('Etc/GMT+2'),
        z.literal('Etc/GMT+3'),
        z.literal('Etc/GMT+4'),
        z.literal('Etc/GMT+5'),
        z.literal('Etc/GMT+6'),
        z.literal('Etc/GMT+7'),
        z.literal('Etc/GMT+8'),
        z.literal('Etc/GMT+9'),
        z.literal('Etc/GMT-1'),
        z.literal('Etc/GMT-10'),
        z.literal('Etc/GMT-11'),
        z.literal('Etc/GMT-12'),
        z.literal('Etc/GMT-13'),
        z.literal('Etc/GMT-14'),
        z.literal('Etc/GMT-2'),
        z.literal('Etc/GMT-3'),
        z.literal('Etc/GMT-4'),
        z.literal('Etc/GMT-5'),
        z.literal('Etc/GMT-6'),
        z.literal('Etc/GMT-7'),
        z.literal('Etc/GMT-8'),
        z.literal('Etc/GMT-9'),
        z.literal('Etc/UTC'),
        z.literal('Europe/Amsterdam'),
        z.literal('Europe/Andorra'),
        z.literal('Europe/Astrakhan'),
        z.literal('Europe/Athens'),
        z.literal('Europe/Belgrade'),
        z.literal('Europe/Berlin'),
        z.literal('Europe/Brussels'),
        z.literal('Europe/Bucharest'),
        z.literal('Europe/Budapest'),
        z.literal('Europe/Chisinau'),
        z.literal('Europe/Copenhagen'),
        z.literal('Europe/Dublin'),
        z.literal('Europe/Gibraltar'),
        z.literal('Europe/Helsinki'),
        z.literal('Europe/Istanbul'),
        z.literal('Europe/Kaliningrad'),
        z.literal('Europe/Kiev'),
        z.literal('Europe/Kirov'),
        z.literal('Europe/Lisbon'),
        z.literal('Europe/London'),
        z.literal('Europe/Luxembourg'),
        z.literal('Europe/Madrid'),
        z.literal('Europe/Malta'),
        z.literal('Europe/Minsk'),
        z.literal('Europe/Monaco'),
        z.literal('Europe/Moscow'),
        z.literal('Europe/Oslo'),
        z.literal('Europe/Paris'),
        z.literal('Europe/Prague'),
        z.literal('Europe/Riga'),
        z.literal('Europe/Rome'),
        z.literal('Europe/Samara'),
        z.literal('Europe/Saratov'),
        z.literal('Europe/Simferopol'),
        z.literal('Europe/Sofia'),
        z.literal('Europe/Stockholm'),
        z.literal('Europe/Tallinn'),
        z.literal('Europe/Tirane'),
        z.literal('Europe/Ulyanovsk'),
        z.literal('Europe/Uzhgorod'),
        z.literal('Europe/Vienna'),
        z.literal('Europe/Vilnius'),
        z.literal('Europe/Volgograd'),
        z.literal('Europe/Warsaw'),
        z.literal('Europe/Zaporozhye'),
        z.literal('Europe/Zurich'),
        z.literal('HST'),
        z.literal('Indian/Chagos'),
        z.literal('Indian/Christmas'),
        z.literal('Indian/Cocos'),
        z.literal('Indian/Kerguelen'),
        z.literal('Indian/Mahe'),
        z.literal('Indian/Maldives'),
        z.literal('Indian/Mauritius'),
        z.literal('Indian/Reunion'),
        z.literal('MET'),
        z.literal('MST'),
        z.literal('MST7MDT'),
        z.literal('PST8PDT'),
        z.literal('Pacific/Apia'),
        z.literal('Pacific/Auckland'),
        z.literal('Pacific/Bougainville'),
        z.literal('Pacific/Chatham'),
        z.literal('Pacific/Chuuk'),
        z.literal('Pacific/Easter'),
        z.literal('Pacific/Efate'),
        z.literal('Pacific/Enderbury'),
        z.literal('Pacific/Fakaofo'),
        z.literal('Pacific/Fiji'),
        z.literal('Pacific/Funafuti'),
        z.literal('Pacific/Galapagos'),
        z.literal('Pacific/Gambier'),
        z.literal('Pacific/Guadalcanal'),
        z.literal('Pacific/Guam'),
        z.literal('Pacific/Honolulu'),
        z.literal('Pacific/Kiritimati'),
        z.literal('Pacific/Kosrae'),
        z.literal('Pacific/Kwajalein'),
        z.literal('Pacific/Majuro'),
        z.literal('Pacific/Marquesas'),
        z.literal('Pacific/Nauru'),
        z.literal('Pacific/Niue'),
        z.literal('Pacific/Norfolk'),
        z.literal('Pacific/Noumea'),
        z.literal('Pacific/Pago_Pago'),
        z.literal('Pacific/Palau'),
        z.literal('Pacific/Pitcairn'),
        z.literal('Pacific/Pohnpei'),
        z.literal('Pacific/Port_Moresby'),
        z.literal('Pacific/Rarotonga'),
        z.literal('Pacific/Tahiti'),
        z.literal('Pacific/Tarawa'),
        z.literal('Pacific/Tongatapu'),
        z.literal('Pacific/Wake'),
        z.literal('Pacific/Wallis'),
        z.literal('WET'),
      ])
      .nullable(),
  })
  .nullable();

export const catalogsStatusSchema = z.union([z.literal('ACTIVE'), z.literal('INACTIVE')]);

export const nullableCurrencySchema = z.union([
  z.literal('AED'),
  z.literal('AFN'),
  z.literal('ALL'),
  z.literal('AMD'),
  z.literal('ANG'),
  z.literal('AOA'),
  z.literal('ARS'),
  z.literal('AUD'),
  z.literal('AWG'),
  z.literal('AZN'),
  z.literal('BAM'),
  z.literal('BBD'),
  z.literal('BDT'),
  z.literal('BGN'),
  z.literal('BHD'),
  z.literal('BIF'),
  z.literal('BMD'),
  z.literal('BND'),
  z.literal('BOB'),
  z.literal('BRL'),
  z.literal('BSD'),
  z.literal('BTN'),
  z.literal('BWP'),
  z.literal('BYN'),
  z.literal('BYR'),
  z.literal('BZD'),
  z.literal('CAD'),
  z.literal('CDF'),
  z.literal('CHF'),
  z.literal('CLP'),
  z.literal('CNY'),
  z.literal('COP'),
  z.literal('CRC'),
  z.literal('CUC'),
  z.literal('CUP'),
  z.literal('CVE'),
  z.literal('CZK'),
  z.literal('DJF'),
  z.literal('DKK'),
  z.literal('DOP'),
  z.literal('DZD'),
  z.literal('EGP'),
  z.literal('ERN'),
  z.literal('ETB'),
  z.literal('EUR'),
  z.literal('FJD'),
  z.literal('FKP'),
  z.literal('GBP'),
  z.literal('GEL'),
  z.literal('GGP'),
  z.literal('GHS'),
  z.literal('GIP'),
  z.literal('GMD'),
  z.literal('GNF'),
  z.literal('GTQ'),
  z.literal('GYD'),
  z.literal('HKD'),
  z.literal('HNL'),
  z.literal('HRK'),
  z.literal('HTG'),
  z.literal('HUF'),
  z.literal('IDR'),
  z.literal('ILS'),
  z.literal('IMP'),
  z.literal('INR'),
  z.literal('IQD'),
  z.literal('IRR'),
  z.literal('ISK'),
  z.literal('JEP'),
  z.literal('JMD'),
  z.literal('JOD'),
  z.literal('JPY'),
  z.literal('KES'),
  z.literal('KGS'),
  z.literal('KHR'),
  z.literal('KMF'),
  z.literal('KPW'),
  z.literal('KRW'),
  z.literal('KWD'),
  z.literal('KYD'),
  z.literal('KZT'),
  z.literal('LAK'),
  z.literal('LBP'),
  z.literal('LKR'),
  z.literal('LRD'),
  z.literal('LSL'),
  z.literal('LYD'),
  z.literal('MAD'),
  z.literal('MDL'),
  z.literal('MGA'),
  z.literal('MKD'),
  z.literal('MMK'),
  z.literal('MNT'),
  z.literal('MOP'),
  z.literal('MRO'),
  z.literal('MUR'),
  z.literal('MVR'),
  z.literal('MWK'),
  z.literal('MXN'),
  z.literal('MYR'),
  z.literal('MZN'),
  z.literal('NAD'),
  z.literal('NGN'),
  z.literal('NIO'),
  z.literal('NOK'),
  z.literal('NPR'),
  z.literal('NZD'),
  z.literal('OMR'),
  z.literal('PAB'),
  z.literal('PEN'),
  z.literal('PGK'),
  z.literal('PHP'),
  z.literal('PKR'),
  z.literal('PLN'),
  z.literal('PYG'),
  z.literal('QAR'),
  z.literal('RON'),
  z.literal('RSD'),
  z.literal('RUB'),
  z.literal('RWF'),
  z.literal('SAR'),
  z.literal('SBD'),
  z.literal('SCR'),
  z.literal('SDG'),
  z.literal('SEK'),
  z.literal('SGD'),
  z.literal('SHP'),
  z.literal('SLL'),
  z.literal('SOS'),
  z.literal('SPL'),
  z.literal('SRD'),
  z.literal('STD'),
  z.literal('SVC'),
  z.literal('SYP'),
  z.literal('SZL'),
  z.literal('THB'),
  z.literal('TJS'),
  z.literal('TMT'),
  z.literal('TND'),
  z.literal('TOP'),
  z.literal('TRY'),
  z.literal('TTD'),
  z.literal('TVD'),
  z.literal('TWD'),
  z.literal('TZS'),
  z.literal('UAH'),
  z.literal('UGX'),
  z.literal('USD'),
  z.literal('UYU'),
  z.literal('UZS'),
  z.literal('VEF'),
  z.literal('VND'),
  z.literal('VUV'),
  z.literal('WST'),
  z.literal('XAF'),
  z.literal('XCD'),
  z.literal('XDR'),
  z.literal('XOF'),
  z.literal('XPF'),
  z.literal('YER'),
  z.literal('ZAR'),
  z.literal('ZMW'),
  z.literal('ZWD'),
]);

export const catalogsHotelFeedSchema = catalogsDbItemSchema.and(
  z.object({
    name: z.string().nullable(),
    format: catalogsFormatSchema,
    catalog_type: catalogsTypeSchema,
    credentials: catalogsFeedCredentialsSchema,
    location: z.string(),
    preferred_processing_schedule: catalogsFeedProcessingScheduleSchema,
    status: catalogsStatusSchema,
    default_currency: nullableCurrencySchema,
    default_locale: z.string(),
    catalog_id: z.string().nullable(),
  }),
);

export const productAvailabilityTypeSchema = z.union([
  z.literal('IN_STOCK'),
  z.literal('OUT_OF_STOCK'),
  z.literal('PREORDER'),
]);

export const catalogsFeedIngestionErrorsSchema = z.object({
  LINE_LEVEL_INTERNAL_ERROR: z.number().optional(),
  LARGE_PRODUCT_COUNT_DECREASE: z.literal(1).optional(),
  ACCOUNT_FLAGGED: z.number().optional(),
  IMAGE_LEVEL_INTERNAL_ERROR: z.number().optional(),
  IMAGE_FILE_NOT_ACCESSIBLE: z.number().optional(),
  IMAGE_MALFORMED_URL: z.number().optional(),
  IMAGE_FILE_NOT_FOUND: z.number().optional(),
  IMAGE_INVALID_FILE: z.number().optional(),
});

export const catalogsFeedIngestionInfoSchema = z.object({
  IN_STOCK: z.number().optional(),
  OUT_OF_STOCK: z.number().optional(),
  PREORDER: z.number().optional(),
});

export const catalogsFeedIngestionWarningsSchema = z.object({
  ADDITIONAL_IMAGE_LEVEL_INTERNAL_ERROR: z.number().optional(),
  ADDITIONAL_IMAGE_FILE_NOT_ACCESSIBLE: z.number().optional(),
  ADDITIONAL_IMAGE_MALFORMED_URL: z.number().optional(),
  ADDITIONAL_IMAGE_FILE_NOT_FOUND: z.number().optional(),
  ADDITIONAL_IMAGE_INVALID_FILE: z.number().optional(),
  HOTEL_PRICE_HEADER_IS_PRESENT: z.number().optional(),
});

export const largeProductCountDecreaseSchema = z.literal(1);

export const catalogsFeedProcessingStatusSchema = z.union([
  z.literal('COMPLETED'),
  z.literal('FAILED'),
  z.literal('PROCESSING'),
]);

export const catalogsFeedIngestionDetailsSchema = z.object({
  errors: catalogsFeedIngestionErrorsSchema,
  info: catalogsFeedIngestionInfoSchema,
  warnings: catalogsFeedIngestionWarningsSchema,
});

export const catalogsFeedProductCountsSchema = z
  .object({
    original: z.number().optional(),
    ingested: z.number().optional(),
  })
  .nullable();

export const timezoneSchema = z.union([
  z.literal('Africa/Abidjan'),
  z.literal('Africa/Accra'),
  z.literal('Africa/Algiers'),
  z.literal('Africa/Bissau'),
  z.literal('Africa/Cairo'),
  z.literal('Africa/Casablanca'),
  z.literal('Africa/Ceuta'),
  z.literal('Africa/El_Aaiun'),
  z.literal('Africa/Johannesburg'),
  z.literal('Africa/Juba'),
  z.literal('Africa/Khartoum'),
  z.literal('Africa/Lagos'),
  z.literal('Africa/Maputo'),
  z.literal('Africa/Monrovia'),
  z.literal('Africa/Nairobi'),
  z.literal('Africa/Ndjamena'),
  z.literal('Africa/Sao_Tome'),
  z.literal('Africa/Tripoli'),
  z.literal('Africa/Tunis'),
  z.literal('Africa/Windhoek'),
  z.literal('America/Adak'),
  z.literal('America/Anchorage'),
  z.literal('America/Araguaina'),
  z.literal('America/Argentina/Buenos_Aires'),
  z.literal('America/Argentina/Catamarca'),
  z.literal('America/Argentina/Cordoba'),
  z.literal('America/Argentina/Jujuy'),
  z.literal('America/Argentina/La_Rioja'),
  z.literal('America/Argentina/Mendoza'),
  z.literal('America/Argentina/Rio_Gallegos'),
  z.literal('America/Argentina/Salta'),
  z.literal('America/Argentina/San_Juan'),
  z.literal('America/Argentina/San_Luis'),
  z.literal('America/Argentina/Tucuman'),
  z.literal('America/Argentina/Ushuaia'),
  z.literal('America/Asuncion'),
  z.literal('America/Atikokan'),
  z.literal('America/Bahia'),
  z.literal('America/Bahia_Banderas'),
  z.literal('America/Barbados'),
  z.literal('America/Belem'),
  z.literal('America/Belize'),
  z.literal('America/Blanc-Sablon'),
  z.literal('America/Boa_Vista'),
  z.literal('America/Bogota'),
  z.literal('America/Boise'),
  z.literal('America/Cambridge_Bay'),
  z.literal('America/Campo_Grande'),
  z.literal('America/Cancun'),
  z.literal('America/Caracas'),
  z.literal('America/Cayenne'),
  z.literal('America/Chicago'),
  z.literal('America/Chihuahua'),
  z.literal('America/Costa_Rica'),
  z.literal('America/Creston'),
  z.literal('America/Cuiaba'),
  z.literal('America/Curacao'),
  z.literal('America/Danmarkshavn'),
  z.literal('America/Dawson'),
  z.literal('America/Dawson_Creek'),
  z.literal('America/Denver'),
  z.literal('America/Detroit'),
  z.literal('America/Edmonton'),
  z.literal('America/Eirunepe'),
  z.literal('America/El_Salvador'),
  z.literal('America/Fort_Nelson'),
  z.literal('America/Fortaleza'),
  z.literal('America/Glace_Bay'),
  z.literal('America/Goose_Bay'),
  z.literal('America/Grand_Turk'),
  z.literal('America/Guatemala'),
  z.literal('America/Guayaquil'),
  z.literal('America/Guyana'),
  z.literal('America/Halifax'),
  z.literal('America/Havana'),
  z.literal('America/Hermosillo'),
  z.literal('America/Indiana/Indianapolis'),
  z.literal('America/Indiana/Knox'),
  z.literal('America/Indiana/Marengo'),
  z.literal('America/Indiana/Petersburg'),
  z.literal('America/Indiana/Tell_City'),
  z.literal('America/Indiana/Vevay'),
  z.literal('America/Indiana/Vincennes'),
  z.literal('America/Indiana/Winamac'),
  z.literal('America/Inuvik'),
  z.literal('America/Iqaluit'),
  z.literal('America/Jamaica'),
  z.literal('America/Juneau'),
  z.literal('America/Kentucky/Louisville'),
  z.literal('America/Kentucky/Monticello'),
  z.literal('America/La_Paz'),
  z.literal('America/Lima'),
  z.literal('America/Los_Angeles'),
  z.literal('America/Maceio'),
  z.literal('America/Managua'),
  z.literal('America/Manaus'),
  z.literal('America/Martinique'),
  z.literal('America/Matamoros'),
  z.literal('America/Mazatlan'),
  z.literal('America/Menominee'),
  z.literal('America/Merida'),
  z.literal('America/Metlakatla'),
  z.literal('America/Mexico_City'),
  z.literal('America/Miquelon'),
  z.literal('America/Moncton'),
  z.literal('America/Monterrey'),
  z.literal('America/Montevideo'),
  z.literal('America/Nassau'),
  z.literal('America/New_York'),
  z.literal('America/Nipigon'),
  z.literal('America/Nome'),
  z.literal('America/Noronha'),
  z.literal('America/North_Dakota/Beulah'),
  z.literal('America/North_Dakota/Center'),
  z.literal('America/North_Dakota/New_Salem'),
  z.literal('America/Nuuk'),
  z.literal('America/Ojinaga'),
  z.literal('America/Panama'),
  z.literal('America/Pangnirtung'),
  z.literal('America/Paramaribo'),
  z.literal('America/Phoenix'),
  z.literal('America/Port-au-Prince'),
  z.literal('America/Port_of_Spain'),
  z.literal('America/Porto_Velho'),
  z.literal('America/Puerto_Rico'),
  z.literal('America/Punta_Arenas'),
  z.literal('America/Rainy_River'),
  z.literal('America/Rankin_Inlet'),
  z.literal('America/Recife'),
  z.literal('America/Regina'),
  z.literal('America/Resolute'),
  z.literal('America/Rio_Branco'),
  z.literal('America/Santarem'),
  z.literal('America/Santiago'),
  z.literal('America/Santo_Domingo'),
  z.literal('America/Sao_Paulo'),
  z.literal('America/Scoresbysund'),
  z.literal('America/Sitka'),
  z.literal('America/St_Johns'),
  z.literal('America/Swift_Current'),
  z.literal('America/Tegucigalpa'),
  z.literal('America/Thule'),
  z.literal('America/Thunder_Bay'),
  z.literal('America/Tijuana'),
  z.literal('America/Toronto'),
  z.literal('America/Vancouver'),
  z.literal('America/Whitehorse'),
  z.literal('America/Winnipeg'),
  z.literal('America/Yakutat'),
  z.literal('America/Yellowknife'),
  z.literal('Antarctica/Casey'),
  z.literal('Antarctica/Davis'),
  z.literal('Antarctica/DumontDUrville'),
  z.literal('Antarctica/Macquarie'),
  z.literal('Antarctica/Mawson'),
  z.literal('Antarctica/Palmer'),
  z.literal('Antarctica/Rothera'),
  z.literal('Antarctica/Syowa'),
  z.literal('Antarctica/Troll'),
  z.literal('Antarctica/Vostok'),
  z.literal('Asia/Almaty'),
  z.literal('Asia/Amman'),
  z.literal('Asia/Anadyr'),
  z.literal('Asia/Aqtau'),
  z.literal('Asia/Aqtobe'),
  z.literal('Asia/Ashgabat'),
  z.literal('Asia/Atyrau'),
  z.literal('Asia/Baghdad'),
  z.literal('Asia/Baku'),
  z.literal('Asia/Bangkok'),
  z.literal('Asia/Barnaul'),
  z.literal('Asia/Beirut'),
  z.literal('Asia/Bishkek'),
  z.literal('Asia/Brunei'),
  z.literal('Asia/Chita'),
  z.literal('Asia/Choibalsan'),
  z.literal('Asia/Colombo'),
  z.literal('Asia/Damascus'),
  z.literal('Asia/Dhaka'),
  z.literal('Asia/Dili'),
  z.literal('Asia/Dubai'),
  z.literal('Asia/Dushanbe'),
  z.literal('Asia/Famagusta'),
  z.literal('Asia/Gaza'),
  z.literal('Asia/Hebron'),
  z.literal('Asia/Ho_Chi_Minh'),
  z.literal('Asia/Hong_Kong'),
  z.literal('Asia/Hovd'),
  z.literal('Asia/Irkutsk'),
  z.literal('Asia/Jakarta'),
  z.literal('Asia/Jayapura'),
  z.literal('Asia/Jerusalem'),
  z.literal('Asia/Kabul'),
  z.literal('Asia/Kamchatka'),
  z.literal('Asia/Karachi'),
  z.literal('Asia/Kathmandu'),
  z.literal('Asia/Khandyga'),
  z.literal('Asia/Kolkata'),
  z.literal('Asia/Krasnoyarsk'),
  z.literal('Asia/Kuala_Lumpur'),
  z.literal('Asia/Kuching'),
  z.literal('Asia/Macau'),
  z.literal('Asia/Magadan'),
  z.literal('Asia/Makassar'),
  z.literal('Asia/Manila'),
  z.literal('Asia/Nicosia'),
  z.literal('Asia/Novokuznetsk'),
  z.literal('Asia/Novosibirsk'),
  z.literal('Asia/Omsk'),
  z.literal('Asia/Oral'),
  z.literal('Asia/Pontianak'),
  z.literal('Asia/Pyongyang'),
  z.literal('Asia/Qatar'),
  z.literal('Asia/Qostanay'),
  z.literal('Asia/Qyzylorda'),
  z.literal('Asia/Riyadh'),
  z.literal('Asia/Sakhalin'),
  z.literal('Asia/Samarkand'),
  z.literal('Asia/Seoul'),
  z.literal('Asia/Shanghai'),
  z.literal('Asia/Singapore'),
  z.literal('Asia/Srednekolymsk'),
  z.literal('Asia/Taipei'),
  z.literal('Asia/Tashkent'),
  z.literal('Asia/Tbilisi'),
  z.literal('Asia/Tehran'),
  z.literal('Asia/Thimphu'),
  z.literal('Asia/Tokyo'),
  z.literal('Asia/Tomsk'),
  z.literal('Asia/Ulaanbaatar'),
  z.literal('Asia/Urumqi'),
  z.literal('Asia/Ust-Nera'),
  z.literal('Asia/Vladivostok'),
  z.literal('Asia/Yakutsk'),
  z.literal('Asia/Yangon'),
  z.literal('Asia/Yekaterinburg'),
  z.literal('Asia/Yerevan'),
  z.literal('Atlantic/Azores'),
  z.literal('Atlantic/Bermuda'),
  z.literal('Atlantic/Canary'),
  z.literal('Atlantic/Cape_Verde'),
  z.literal('Atlantic/Faroe'),
  z.literal('Atlantic/Madeira'),
  z.literal('Atlantic/Reykjavik'),
  z.literal('Atlantic/South_Georgia'),
  z.literal('Atlantic/Stanley'),
  z.literal('Australia/Adelaide'),
  z.literal('Australia/Brisbane'),
  z.literal('Australia/Broken_Hill'),
  z.literal('Australia/Currie'),
  z.literal('Australia/Darwin'),
  z.literal('Australia/Eucla'),
  z.literal('Australia/Hobart'),
  z.literal('Australia/Lindeman'),
  z.literal('Australia/Lord_Howe'),
  z.literal('Australia/Melbourne'),
  z.literal('Australia/Perth'),
  z.literal('Australia/Sydney'),
  z.literal('CET'),
  z.literal('CST6CDT'),
  z.literal('EET'),
  z.literal('EST'),
  z.literal('EST5EDT'),
  z.literal('Etc/GMT'),
  z.literal('Etc/GMT+1'),
  z.literal('Etc/GMT+10'),
  z.literal('Etc/GMT+11'),
  z.literal('Etc/GMT+12'),
  z.literal('Etc/GMT+2'),
  z.literal('Etc/GMT+3'),
  z.literal('Etc/GMT+4'),
  z.literal('Etc/GMT+5'),
  z.literal('Etc/GMT+6'),
  z.literal('Etc/GMT+7'),
  z.literal('Etc/GMT+8'),
  z.literal('Etc/GMT+9'),
  z.literal('Etc/GMT-1'),
  z.literal('Etc/GMT-10'),
  z.literal('Etc/GMT-11'),
  z.literal('Etc/GMT-12'),
  z.literal('Etc/GMT-13'),
  z.literal('Etc/GMT-14'),
  z.literal('Etc/GMT-2'),
  z.literal('Etc/GMT-3'),
  z.literal('Etc/GMT-4'),
  z.literal('Etc/GMT-5'),
  z.literal('Etc/GMT-6'),
  z.literal('Etc/GMT-7'),
  z.literal('Etc/GMT-8'),
  z.literal('Etc/GMT-9'),
  z.literal('Etc/UTC'),
  z.literal('Europe/Amsterdam'),
  z.literal('Europe/Andorra'),
  z.literal('Europe/Astrakhan'),
  z.literal('Europe/Athens'),
  z.literal('Europe/Belgrade'),
  z.literal('Europe/Berlin'),
  z.literal('Europe/Brussels'),
  z.literal('Europe/Bucharest'),
  z.literal('Europe/Budapest'),
  z.literal('Europe/Chisinau'),
  z.literal('Europe/Copenhagen'),
  z.literal('Europe/Dublin'),
  z.literal('Europe/Gibraltar'),
  z.literal('Europe/Helsinki'),
  z.literal('Europe/Istanbul'),
  z.literal('Europe/Kaliningrad'),
  z.literal('Europe/Kiev'),
  z.literal('Europe/Kirov'),
  z.literal('Europe/Lisbon'),
  z.literal('Europe/London'),
  z.literal('Europe/Luxembourg'),
  z.literal('Europe/Madrid'),
  z.literal('Europe/Malta'),
  z.literal('Europe/Minsk'),
  z.literal('Europe/Monaco'),
  z.literal('Europe/Moscow'),
  z.literal('Europe/Oslo'),
  z.literal('Europe/Paris'),
  z.literal('Europe/Prague'),
  z.literal('Europe/Riga'),
  z.literal('Europe/Rome'),
  z.literal('Europe/Samara'),
  z.literal('Europe/Saratov'),
  z.literal('Europe/Simferopol'),
  z.literal('Europe/Sofia'),
  z.literal('Europe/Stockholm'),
  z.literal('Europe/Tallinn'),
  z.literal('Europe/Tirane'),
  z.literal('Europe/Ulyanovsk'),
  z.literal('Europe/Uzhgorod'),
  z.literal('Europe/Vienna'),
  z.literal('Europe/Vilnius'),
  z.literal('Europe/Volgograd'),
  z.literal('Europe/Warsaw'),
  z.literal('Europe/Zaporozhye'),
  z.literal('Europe/Zurich'),
  z.literal('HST'),
  z.literal('Indian/Chagos'),
  z.literal('Indian/Christmas'),
  z.literal('Indian/Cocos'),
  z.literal('Indian/Kerguelen'),
  z.literal('Indian/Mahe'),
  z.literal('Indian/Maldives'),
  z.literal('Indian/Mauritius'),
  z.literal('Indian/Reunion'),
  z.literal('MET'),
  z.literal('MST'),
  z.literal('MST7MDT'),
  z.literal('PST8PDT'),
  z.literal('Pacific/Apia'),
  z.literal('Pacific/Auckland'),
  z.literal('Pacific/Bougainville'),
  z.literal('Pacific/Chatham'),
  z.literal('Pacific/Chuuk'),
  z.literal('Pacific/Easter'),
  z.literal('Pacific/Efate'),
  z.literal('Pacific/Enderbury'),
  z.literal('Pacific/Fakaofo'),
  z.literal('Pacific/Fiji'),
  z.literal('Pacific/Funafuti'),
  z.literal('Pacific/Galapagos'),
  z.literal('Pacific/Gambier'),
  z.literal('Pacific/Guadalcanal'),
  z.literal('Pacific/Guam'),
  z.literal('Pacific/Honolulu'),
  z.literal('Pacific/Kiritimati'),
  z.literal('Pacific/Kosrae'),
  z.literal('Pacific/Kwajalein'),
  z.literal('Pacific/Majuro'),
  z.literal('Pacific/Marquesas'),
  z.literal('Pacific/Nauru'),
  z.literal('Pacific/Niue'),
  z.literal('Pacific/Norfolk'),
  z.literal('Pacific/Noumea'),
  z.literal('Pacific/Pago_Pago'),
  z.literal('Pacific/Palau'),
  z.literal('Pacific/Pitcairn'),
  z.literal('Pacific/Pohnpei'),
  z.literal('Pacific/Port_Moresby'),
  z.literal('Pacific/Rarotonga'),
  z.literal('Pacific/Tahiti'),
  z.literal('Pacific/Tarawa'),
  z.literal('Pacific/Tongatapu'),
  z.literal('Pacific/Wake'),
  z.literal('Pacific/Wallis'),
  z.literal('WET'),
]);

export const catalogsFeedValidationErrorsSchema = z.object({
  FETCH_ERROR: z.number().optional(),
  FETCH_INACTIVE_FEED_ERROR: z.number().optional(),
  ENCODING_ERROR: z.number().optional(),
  DELIMITER_ERROR: z.number().optional(),
  REQUIRED_COLUMNS_MISSING: z.number().optional(),
  DUPLICATE_PRODUCTS: z.number().optional(),
  IMAGE_LINK_INVALID: z.number().optional(),
  ITEMID_MISSING: z.number().optional(),
  TITLE_MISSING: z.number().optional(),
  DESCRIPTION_MISSING: z.number().optional(),
  PRODUCT_LINK_MISSING: z.number().optional(),
  IMAGE_LINK_MISSING: z.number().optional(),
  AVAILABILITY_INVALID: z.number().optional(),
  PRODUCT_PRICE_INVALID: z.number().optional(),
  LINK_FORMAT_INVALID: z.number().optional(),
  PARSE_LINE_ERROR: z.number().optional(),
  ADWORDS_FORMAT_INVALID: z.number().optional(),
  INTERNAL_SERVICE_ERROR: z.number().optional(),
  NO_VERIFIED_DOMAIN: z.number().optional(),
  ADULT_INVALID: z.number().optional(),
  IMAGE_LINK_LENGTH_TOO_LONG: z.number().optional(),
  INVALID_DOMAIN: z.number().optional(),
  FEED_LENGTH_TOO_LONG: z.number().optional(),
  LINK_LENGTH_TOO_LONG: z.number().optional(),
  MALFORMED_XML: z.number().optional(),
  PRICE_MISSING: z.number().optional(),
  FEED_TOO_SMALL: z.number().optional(),
  MAX_ITEMS_PER_ITEM_GROUP_EXCEEDED: z.number().optional(),
  ITEM_MAIN_IMAGE_DOWNLOAD_FAILURE: z.number().optional(),
  PINJOIN_CONTENT_UNSAFE: z.number().optional(),
  BLOCKLISTED_IMAGE_SIGNATURE: z.number().optional(),
  LIST_PRICE_INVALID: z.number().optional(),
  PRICE_CANNOT_BE_DETERMINED: z.number().optional(),
});

export const catalogsFeedValidationWarningsSchema = z.object({
  AD_LINK_FORMAT_WARNING: z.number().optional(),
  AD_LINK_SAME_AS_LINK: z.number().optional(),
  TITLE_LENGTH_TOO_LONG: z.number().optional(),
  DESCRIPTION_LENGTH_TOO_LONG: z.number().optional(),
  GENDER_INVALID: z.number().optional(),
  AGE_GROUP_INVALID: z.number().optional(),
  SIZE_TYPE_INVALID: z.number().optional(),
  SIZE_SYSTEM_INVALID: z.number().optional(),
  LINK_FORMAT_WARNING: z.number().optional(),
  SALES_PRICE_INVALID: z.number().optional(),
  PRODUCT_CATEGORY_DEPTH_WARNING: z.number().optional(),
  ADWORDS_FORMAT_WARNING: z.number().optional(),
  ADWORDS_SAME_AS_LINK: z.number().optional(),
  DUPLICATE_HEADERS: z.number().optional(),
  FETCH_SAME_SIGNATURE: z.literal(1).optional(),
  ADDITIONAL_IMAGE_LINK_LENGTH_TOO_LONG: z.number().optional(),
  ADDITIONAL_IMAGE_LINK_WARNING: z.number().optional(),
  IMAGE_LINK_WARNING: z.number().optional(),
  SHIPPING_INVALID: z.number().optional(),
  TAX_INVALID: z.number().optional(),
  SHIPPING_WEIGHT_INVALID: z.number().optional(),
  EXPIRATION_DATE_INVALID: z.number().optional(),
  AVAILABILITY_DATE_INVALID: z.number().optional(),
  SALE_DATE_INVALID: z.number().optional(),
  WEIGHT_UNIT_INVALID: z.number().optional(),
  IS_BUNDLE_INVALID: z.number().optional(),
  UPDATED_TIME_INVALID: z.number().optional(),
  CUSTOM_LABEL_LENGTH_TOO_LONG: z.number().optional(),
  PRODUCT_TYPE_LENGTH_TOO_LONG: z.number().optional(),
  TOO_MANY_ADDITIONAL_IMAGE_LINKS: z.number().optional(),
  MULTIPACK_INVALID: z.number().optional(),
  INDEXED_PRODUCT_COUNT_LARGE_DELTA: z.number().optional(),
  ITEM_ADDITIONAL_IMAGE_DOWNLOAD_FAILURE: z.number().optional(),
  OPTIONAL_PRODUCT_CATEGORY_MISSING: z.number().optional(),
  OPTIONAL_PRODUCT_CATEGORY_INVALID: z.number().optional(),
  OPTIONAL_CONDITION_MISSING: z.number().optional(),
  OPTIONAL_CONDITION_INVALID: z.number().optional(),
  IOS_DEEP_LINK_INVALID: z.number().optional(),
  ANDROID_DEEP_LINK_INVALID: z.number().optional(),
  UTM_SOURCE_AUTO_CORRECTED: z.number().optional(),
  COUNTRY_DOES_NOT_MAP_TO_CURRENCY: z.number().optional(),
  MIN_AD_PRICE_INVALID: z.number().optional(),
  GTIN_INVALID: z.number().optional(),
  INCONSISTENT_CURRENCY_VALUES: z.number().optional(),
  SALES_PRICE_TOO_LOW: z.number().optional(),
  SHIPPING_WIDTH_INVALID: z.number().optional(),
  SHIPPING_HEIGHT_INVALID: z.number().optional(),
  SALES_PRICE_TOO_HIGH: z.number().optional(),
  MPN_INVALID: z.number().optional(),
});

export const fetchSameSignatureSchema = z.literal(1);

export const catalogsLocaleSchema = z.union([
  z.literal('af-ZA'),
  z.literal('ar-SA'),
  z.literal('bg-BG'),
  z.literal('bn-IN'),
  z.literal('cs-CZ'),
  z.literal('da-DK'),
  z.literal('de'),
  z.literal('el-GR'),
  z.literal('en-AU'),
  z.literal('en-CA'),
  z.literal('en-GB'),
  z.literal('en-IN'),
  z.literal('en-US'),
  z.literal('es-419'),
  z.literal('es-AR'),
  z.literal('es-ES'),
  z.literal('es-MX'),
  z.literal('fi-FI'),
  z.literal('fr'),
  z.literal('fr-CA'),
  z.literal('he-IL'),
  z.literal('hi-IN'),
  z.literal('hr-HR'),
  z.literal('hu-HU'),
  z.literal('id-ID'),
  z.literal('it'),
  z.literal('ja'),
  z.literal('ko-KR'),
  z.literal('ms-MY'),
  z.literal('nb-NO'),
  z.literal('nl'),
  z.literal('pl-PL'),
  z.literal('pt-BR'),
  z.literal('pt-PT'),
  z.literal('ro-RO'),
  z.literal('ru-RU'),
  z.literal('sk-SK'),
  z.literal('sv-SE'),
  z.literal('te-IN'),
  z.literal('th-TH'),
  z.literal('tl-PH'),
  z.literal('tr'),
  z.literal('uk-UA'),
  z.literal('vi-VN'),
  z.literal('zh-CN'),
  z.literal('zh-TW'),
]);

export const catalogsRetailFeedsCreateRequestSchema = z.object({
  default_currency: nullableCurrencySchema.optional(),
  name: z.string(),
  format: catalogsFormatSchema,
  default_locale: z.union([catalogsLocaleSchema, z.string()]),
  credentials: catalogsFeedCredentialsSchema.optional(),
  location: z.string(),
  preferred_processing_schedule: catalogsFeedProcessingScheduleSchema.optional(),
  catalog_type: z.literal('RETAIL'),
  default_country: countrySchema,
  default_availability: productAvailabilityTypeSchema.optional(),
  status: catalogsStatusSchema.and(z.unknown()).optional(),
});

export const catalogsRetailItemsFilterSchema = z.object({
  catalog_type: z.literal('RETAIL'),
  item_ids: z.array(z.string()),
  catalog_id: z.string().optional(),
});

export const catalogsRetailItemsPostFilterSchema = z.object({
  catalog_type: z.literal('RETAIL'),
  item_ids: z.array(z.string()),
  catalog_id: z.string().optional(),
});

export const catalogsHotelFeedsCreateRequestSchema = z.object({
  default_currency: nullableCurrencySchema.optional(),
  name: z.string(),
  format: catalogsFormatSchema,
  default_locale: z.union([catalogsLocaleSchema, z.string()]),
  credentials: catalogsFeedCredentialsSchema.optional(),
  location: z.string(),
  preferred_processing_schedule: catalogsFeedProcessingScheduleSchema.optional(),
  catalog_type: z.literal('HOTEL'),
  catalog_id: z.string().optional().nullable(),
  status: catalogsStatusSchema.and(z.unknown()).optional(),
});

export const catalogsHotelItemsFilterSchema = z.object({
  catalog_type: z.literal('HOTEL'),
  hotel_ids: z.array(z.string()),
  catalog_id: z.string().optional(),
});

export const catalogsHotelItemsPostFilterSchema = z.object({
  catalog_type: z.literal('HOTEL'),
  hotel_ids: z.array(z.string()),
  catalog_id: z.string().optional(),
});

export const catalogsCreativeAssetsItemsFilterSchema = z.object({
  catalog_type: z.literal('CREATIVE_ASSETS'),
  creative_assets_ids: z.array(z.string()),
  catalog_id: z.string().optional(),
});

export const catalogsCreativeAssetsItemsPostFilterSchema = z.object({
  catalog_type: z.literal('CREATIVE_ASSETS'),
  creative_assets_ids: z.array(z.string()),
  catalog_id: z.string().optional(),
});

export const catalogsCreativeAssetsFeedsCreateRequestSchema = z.object({
  default_currency: nullableCurrencySchema.optional(),
  name: z.string(),
  format: catalogsFormatSchema,
  default_locale: z.union([catalogsLocaleSchema, z.string()]),
  default_country: countrySchema,
  credentials: catalogsFeedCredentialsSchema.optional(),
  location: z.string(),
  preferred_processing_schedule: catalogsFeedProcessingScheduleSchema.optional(),
  catalog_type: z.literal('CREATIVE_ASSETS'),
  catalog_id: z.string().optional().nullable(),
  status: catalogsStatusSchema.and(z.unknown()).optional(),
});

export const catalogsVerticalFeedsCreateRequestSchema = z.union([
  catalogsRetailFeedsCreateRequestSchema,
  catalogsHotelFeedsCreateRequestSchema,
  catalogsCreativeAssetsFeedsCreateRequestSchema,
]);

export const catalogsCreativeAssetsFeedsUpdateRequestSchema = z.object({
  default_currency: nullableCurrencySchema.optional(),
  name: z.string().optional(),
  format: catalogsFormatSchema.optional(),
  credentials: catalogsFeedCredentialsSchema.optional(),
  location: z.string().optional(),
  preferred_processing_schedule: catalogsFeedProcessingScheduleSchema.optional(),
  status: catalogsStatusSchema.optional(),
  catalog_type: z.literal('CREATIVE_ASSETS'),
});

export const catalogsRetailFeedsUpdateRequestSchema = z.object({
  default_currency: nullableCurrencySchema.optional(),
  name: z.string().optional(),
  format: catalogsFormatSchema.optional(),
  credentials: catalogsFeedCredentialsSchema.optional(),
  location: z.string().optional(),
  preferred_processing_schedule: catalogsFeedProcessingScheduleSchema.optional(),
  status: catalogsStatusSchema.optional(),
  catalog_type: z.literal('RETAIL'),
  default_availability: productAvailabilityTypeSchema.optional(),
});

export const catalogsHotelFeedsUpdateRequestSchema = z.object({
  default_currency: nullableCurrencySchema.optional(),
  name: z.string().optional(),
  format: catalogsFormatSchema.optional(),
  credentials: catalogsFeedCredentialsSchema.optional(),
  location: z.string().optional(),
  preferred_processing_schedule: catalogsFeedProcessingScheduleSchema.optional(),
  status: catalogsStatusSchema.optional(),
  catalog_type: z.literal('HOTEL'),
});

export const catalogsVerticalFeedsUpdateRequestSchema = z.union([
  catalogsRetailFeedsUpdateRequestSchema,
  catalogsHotelFeedsUpdateRequestSchema,
  catalogsCreativeAssetsFeedsUpdateRequestSchema,
]);

export const catalogsFeedsUpdateRequestSchema = z.object({
  default_availability: productAvailabilityTypeSchema.optional(),
  default_currency: nullableCurrencySchema.optional(),
  name: z.string().optional(),
  format: catalogsFormatSchema.optional(),
  credentials: catalogsFeedCredentialsSchema.optional(),
  location: z.string().optional(),
  preferred_processing_schedule: catalogsFeedProcessingScheduleSchema.optional(),
  status: catalogsStatusSchema.optional(),
});

export const nullableCatalogsItemFieldTypeSchema = z.union([
  z.literal('ITEM_ID'),
  z.literal('ITEM_GROUP_ID'),
  z.literal('TITLE'),
  z.literal('DESCRIPTION'),
  z.literal('ITEM_LINK'),
  z.literal('ORGANIC_LINK'),
  z.literal('IMAGE_LINK'),
  z.literal('ADWORDS_REDIRECT_LINK'),
  z.literal('AD_LINK'),
  z.literal('SIZE'),
  z.literal('GOOGLE_PRODUCT_CATEGORY'),
  z.literal('PRODUCT_CATEGORY'),
  z.literal('CONDITION'),
  z.literal('AVAILABILITY'),
  z.literal('GENDER'),
  z.literal('AGE_GROUP'),
  z.literal('SIZE_TYPE'),
  z.literal('SIZE_SYSTEM'),
  z.literal('ADULT'),
  z.literal('SHIPPING'),
  z.literal('SHIPPING_WEIGHT'),
  z.literal('TAX'),
  z.literal('MULTIPACK'),
  z.literal('ADDITIONAL_IMAGE_LINK'),
  z.literal('PRICE'),
  z.literal('SALE_PRICE'),
  z.literal('IS_BUNDLE'),
  z.literal('EXPIRATION_DATE'),
  z.literal('SALE_PRICE_EFFECTIVE_DATE'),
  z.literal('AVAILABILITY_DATE'),
  z.literal('WEIGHT_UNIT'),
  z.literal('PRODUCT_TYPE'),
  z.literal('CUSTOM_LABEL_0'),
  z.literal('CUSTOM_LABEL_1'),
  z.literal('CUSTOM_LABEL_2'),
  z.literal('CUSTOM_LABEL_3'),
  z.literal('CUSTOM_LABEL_4'),
  z.literal('MATERIAL'),
  z.literal('PATTERN'),
  z.literal('COLOR'),
  z.literal('BRAND'),
  z.literal('GTIN'),
  z.literal('MPN'),
  z.literal('IOS_DEEP_LINK'),
  z.literal('ANDROID_DEEP_LINK'),
  z.literal('FREE_SHIPPING_LABEL'),
  z.literal('FREE_SHIPPING_LIMIT'),
  z.literal('AVG_REVIEW_RATING'),
  z.literal('NUM_RATINGS'),
  z.literal('NUM_REVIEWS'),
  z.literal('ALT_TEXT'),
  z.literal('VARIANT_NAMES'),
  z.literal('VARIANT_VALUES'),
  z.literal('MIN_AD_PRICE'),
  z.literal('SHIPPING_WIDTH'),
  z.literal('SHIPPING_HEIGHT'),
]);

export const catalogsItemValidationDetailsSchema = z.object({
  attribute_name: nullableCatalogsItemFieldTypeSchema,
  provided_value: z.string().nullable(),
});

export const catalogsItemValidationIssueSchema = z.union([
  z.literal('AD_LINK_FORMAT_WARNING'),
  z.literal('AD_LINK_SAME_AS_LINK'),
  z.literal('ADDITIONAL_IMAGE_LINK_LENGTH_TOO_LONG'),
  z.literal('ADDITIONAL_IMAGE_LINK_WARNING'),
  z.literal('ADULT_INVALID'),
  z.literal('ADWORDS_FORMAT_INVALID'),
  z.literal('ADWORDS_FORMAT_WARNING'),
  z.literal('ADWORDS_SAME_AS_LINK'),
  z.literal('AGE_GROUP_INVALID'),
  z.literal('ANDROID_DEEP_LINK_INVALID'),
  z.literal('AVAILABILITY_DATE_INVALID'),
  z.literal('AVAILABILITY_INVALID'),
  z.literal('BLOCKLISTED_IMAGE_SIGNATURE'),
  z.literal('COUNTRY_DOES_NOT_MAP_TO_CURRENCY'),
  z.literal('CUSTOM_LABEL_LENGTH_TOO_LONG'),
  z.literal('DESCRIPTION_LENGTH_TOO_LONG'),
  z.literal('DESCRIPTION_MISSING'),
  z.literal('DUPLICATE_PRODUCTS'),
  z.literal('EXPIRATION_DATE_INVALID'),
  z.literal('GENDER_INVALID'),
  z.literal('GTIN_INVALID'),
  z.literal('IMAGE_LINK_INVALID'),
  z.literal('IMAGE_LINK_LENGTH_TOO_LONG'),
  z.literal('IMAGE_LINK_MISSING'),
  z.literal('IMAGE_LINK_WARNING'),
  z.literal('INVALID_DOMAIN'),
  z.literal('IOS_DEEP_LINK_INVALID'),
  z.literal('IS_BUNDLE_INVALID'),
  z.literal('ITEM_ADDITIONAL_IMAGE_DOWNLOAD_FAILURE'),
  z.literal('ITEM_MAIN_IMAGE_DOWNLOAD_FAILURE'),
  z.literal('ITEMID_MISSING'),
  z.literal('LINK_FORMAT_INVALID'),
  z.literal('LINK_FORMAT_WARNING'),
  z.literal('LINK_LENGTH_TOO_LONG'),
  z.literal('LIST_PRICE_INVALID'),
  z.literal('MAX_ITEMS_PER_ITEM_GROUP_EXCEEDED'),
  z.literal('MIN_AD_PRICE_INVALID'),
  z.literal('MPN_INVALID'),
  z.literal('MULTIPACK_INVALID'),
  z.literal('OPTIONAL_CONDITION_INVALID'),
  z.literal('OPTIONAL_CONDITION_MISSING'),
  z.literal('OPTIONAL_PRODUCT_CATEGORY_INVALID'),
  z.literal('OPTIONAL_PRODUCT_CATEGORY_MISSING'),
  z.literal('PARSE_LINE_ERROR'),
  z.literal('PINJOIN_CONTENT_UNSAFE'),
  z.literal('PRICE_CANNOT_BE_DETERMINED'),
  z.literal('PRICE_MISSING'),
  z.literal('PRODUCT_CATEGORY_DEPTH_WARNING'),
  z.literal('PRODUCT_LINK_MISSING'),
  z.literal('PRODUCT_PRICE_INVALID'),
  z.literal('PRODUCT_TYPE_LENGTH_TOO_LONG'),
  z.literal('SALE_DATE_INVALID'),
  z.literal('SALES_PRICE_INVALID'),
  z.literal('SALES_PRICE_TOO_HIGH'),
  z.literal('SALES_PRICE_TOO_LOW'),
  z.literal('SHIPPING_INVALID'),
  z.literal('SHIPPING_HEIGHT_INVALID'),
  z.literal('SHIPPING_WEIGHT_INVALID'),
  z.literal('SHIPPING_WIDTH_INVALID'),
  z.literal('SIZE_SYSTEM_INVALID'),
  z.literal('SIZE_TYPE_INVALID'),
  z.literal('TAX_INVALID'),
  z.literal('TITLE_LENGTH_TOO_LONG'),
  z.literal('TITLE_MISSING'),
  z.literal('TOO_MANY_ADDITIONAL_IMAGE_LINKS'),
  z.literal('UTM_SOURCE_AUTO_CORRECTED'),
  z.literal('WEIGHT_UNIT_INVALID'),
]);

export const catalogsItemValidationErrorsSchema = z.object({
  ADULT_INVALID: catalogsItemValidationDetailsSchema.optional(),
  ADWORDS_FORMAT_INVALID: catalogsItemValidationDetailsSchema.optional(),
  AVAILABILITY_INVALID: catalogsItemValidationDetailsSchema.optional(),
  BLOCKLISTED_IMAGE_SIGNATURE: catalogsItemValidationDetailsSchema.optional(),
  DESCRIPTION_MISSING: catalogsItemValidationDetailsSchema.optional(),
  DUPLICATE_PRODUCTS: catalogsItemValidationDetailsSchema.optional(),
  IMAGE_LINK_INVALID: catalogsItemValidationDetailsSchema.optional(),
  IMAGE_LINK_LENGTH_TOO_LONG: catalogsItemValidationDetailsSchema.optional(),
  IMAGE_LINK_MISSING: catalogsItemValidationDetailsSchema.optional(),
  INVALID_DOMAIN: catalogsItemValidationDetailsSchema.optional(),
  ITEMID_MISSING: catalogsItemValidationDetailsSchema.optional(),
  ITEM_MAIN_IMAGE_DOWNLOAD_FAILURE: catalogsItemValidationDetailsSchema.optional(),
  LINK_FORMAT_INVALID: catalogsItemValidationDetailsSchema.optional(),
  LINK_LENGTH_TOO_LONG: catalogsItemValidationDetailsSchema.optional(),
  LIST_PRICE_INVALID: catalogsItemValidationDetailsSchema.optional(),
  MAX_ITEMS_PER_ITEM_GROUP_EXCEEDED: catalogsItemValidationDetailsSchema.optional(),
  PARSE_LINE_ERROR: catalogsItemValidationDetailsSchema.optional(),
  PINJOIN_CONTENT_UNSAFE: catalogsItemValidationDetailsSchema.optional(),
  PRICE_CANNOT_BE_DETERMINED: catalogsItemValidationDetailsSchema.optional(),
  PRICE_MISSING: catalogsItemValidationDetailsSchema.optional(),
  PRODUCT_LINK_MISSING: catalogsItemValidationDetailsSchema.optional(),
  PRODUCT_PRICE_INVALID: catalogsItemValidationDetailsSchema.optional(),
  TITLE_MISSING: catalogsItemValidationDetailsSchema.optional(),
});

export const catalogsItemValidationWarningsSchema = z.object({
  AD_LINK_FORMAT_WARNING: catalogsItemValidationDetailsSchema.optional(),
  AD_LINK_SAME_AS_LINK: catalogsItemValidationDetailsSchema.optional(),
  ADDITIONAL_IMAGE_LINK_LENGTH_TOO_LONG: catalogsItemValidationDetailsSchema.optional(),
  ADDITIONAL_IMAGE_LINK_WARNING: catalogsItemValidationDetailsSchema.optional(),
  ADWORDS_FORMAT_WARNING: catalogsItemValidationDetailsSchema.optional(),
  ADWORDS_SAME_AS_LINK: catalogsItemValidationDetailsSchema.optional(),
  AGE_GROUP_INVALID: catalogsItemValidationDetailsSchema.optional(),
  SIZE_SYSTEM_INVALID: catalogsItemValidationDetailsSchema.optional(),
  ANDROID_DEEP_LINK_INVALID: catalogsItemValidationDetailsSchema.optional(),
  AVAILABILITY_DATE_INVALID: catalogsItemValidationDetailsSchema.optional(),
  COUNTRY_DOES_NOT_MAP_TO_CURRENCY: catalogsItemValidationDetailsSchema.optional(),
  CUSTOM_LABEL_LENGTH_TOO_LONG: catalogsItemValidationDetailsSchema.optional(),
  DESCRIPTION_LENGTH_TOO_LONG: catalogsItemValidationDetailsSchema.optional(),
  EXPIRATION_DATE_INVALID: catalogsItemValidationDetailsSchema.optional(),
  GENDER_INVALID: catalogsItemValidationDetailsSchema.optional(),
  GTIN_INVALID: catalogsItemValidationDetailsSchema.optional(),
  IMAGE_LINK_WARNING: catalogsItemValidationDetailsSchema.optional(),
  IOS_DEEP_LINK_INVALID: catalogsItemValidationDetailsSchema.optional(),
  IS_BUNDLE_INVALID: catalogsItemValidationDetailsSchema.optional(),
  ITEM_ADDITIONAL_IMAGE_DOWNLOAD_FAILURE: catalogsItemValidationDetailsSchema.optional(),
  LINK_FORMAT_WARNING: catalogsItemValidationDetailsSchema.optional(),
  MIN_AD_PRICE_INVALID: catalogsItemValidationDetailsSchema.optional(),
  MPN_INVALID: catalogsItemValidationDetailsSchema.optional(),
  MULTIPACK_INVALID: catalogsItemValidationDetailsSchema.optional(),
  OPTIONAL_CONDITION_INVALID: catalogsItemValidationDetailsSchema.optional(),
  OPTIONAL_CONDITION_MISSING: catalogsItemValidationDetailsSchema.optional(),
  OPTIONAL_PRODUCT_CATEGORY_INVALID: catalogsItemValidationDetailsSchema.optional(),
  OPTIONAL_PRODUCT_CATEGORY_MISSING: catalogsItemValidationDetailsSchema.optional(),
  PRODUCT_CATEGORY_DEPTH_WARNING: catalogsItemValidationDetailsSchema.optional(),
  PRODUCT_TYPE_LENGTH_TOO_LONG: catalogsItemValidationDetailsSchema.optional(),
  SALES_PRICE_INVALID: catalogsItemValidationDetailsSchema.optional(),
  SALES_PRICE_TOO_LOW: catalogsItemValidationDetailsSchema.optional(),
  SALES_PRICE_TOO_HIGH: catalogsItemValidationDetailsSchema.optional(),
  SALE_DATE_INVALID: catalogsItemValidationDetailsSchema.optional(),
  SHIPPING_INVALID: catalogsItemValidationDetailsSchema.optional(),
  SHIPPING_HEIGHT_INVALID: catalogsItemValidationDetailsSchema.optional(),
  SHIPPING_WEIGHT_INVALID: catalogsItemValidationDetailsSchema.optional(),
  SHIPPING_WIDTH_INVALID: catalogsItemValidationDetailsSchema.optional(),
  SIZE_TYPE_INVALID: catalogsItemValidationDetailsSchema.optional(),
  TAX_INVALID: catalogsItemValidationDetailsSchema.optional(),
  TITLE_LENGTH_TOO_LONG: catalogsItemValidationDetailsSchema.optional(),
  TOO_MANY_ADDITIONAL_IMAGE_LINKS: catalogsItemValidationDetailsSchema.optional(),
  UTM_SOURCE_AUTO_CORRECTED: catalogsItemValidationDetailsSchema.optional(),
  WEIGHT_UNIT_INVALID: catalogsItemValidationDetailsSchema.optional(),
});

export const catalogsItemsFiltersSchema = z
  .union([catalogsRetailItemsFilterSchema, catalogsHotelItemsFilterSchema, catalogsCreativeAssetsItemsFilterSchema])
  .and(
    z.object({
      catalog_type: catalogsTypeSchema,
    }),
  );

export const catalogsItemsPostFiltersSchema = z
  .union([
    catalogsRetailItemsPostFilterSchema,
    catalogsHotelItemsPostFilterSchema,
    catalogsCreativeAssetsItemsPostFilterSchema,
  ])
  .and(
    z.object({
      catalog_type: catalogsTypeSchema,
    }),
  );

export const catalogsItemsRequestSchema = z.object({
  country: countrySchema,
  language: z.union([catalogsLocaleSchema, languageSchema]),
  filters: catalogsItemsPostFiltersSchema,
});

export const itemDeleteBatchRecordSchema = z.object({
  item_id: z.string().optional(),
});

export const itemDeleteDiscontinuedBatchRecordSchema = z.object({
  item_id: z.string().optional(),
});

export const creativeAssetsIdFilterSchema = z.object({
  CREATIVE_ASSETS_ID: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const customLabel0FilterSchema = z.object({
  CUSTOM_LABEL_0: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const customLabel1FilterSchema = z.object({
  CUSTOM_LABEL_1: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const customLabel2FilterSchema = z.object({
  CUSTOM_LABEL_2: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const customLabel3FilterSchema = z.object({
  CUSTOM_LABEL_3: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const customLabel4FilterSchema = z.object({
  CUSTOM_LABEL_4: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const hotelIdFilterSchema = z.object({
  HOTEL_ID: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const catalogsProductGroupTypeSchema = z.union([
  z.literal('MERCHANT_CREATED'),
  z.literal('ALL_PRODUCTS'),
  z.literal('BEST_DEALS'),
  z.literal('PINNER_FAVORITES'),
  z.literal('TOP_SELLERS'),
  z.literal('BACK_IN_STOCK'),
  z.literal('NEW_ARRIVALS'),
  z.literal('SHOPIFY_COLLECTIONS'),
  z.literal('I2PC'),
]);

export const catalogsProductGroupStatusSchema = z.union([z.literal('ACTIVE'), z.literal('INACTIVE')]);

export const nonNullableCatalogsCurrencySchema = z.union([
  z.literal('AED'),
  z.literal('AFN'),
  z.literal('ALL'),
  z.literal('AMD'),
  z.literal('ANG'),
  z.literal('AOA'),
  z.literal('ARS'),
  z.literal('AUD'),
  z.literal('AWG'),
  z.literal('AZN'),
  z.literal('BAM'),
  z.literal('BBD'),
  z.literal('BDT'),
  z.literal('BGN'),
  z.literal('BHD'),
  z.literal('BIF'),
  z.literal('BMD'),
  z.literal('BND'),
  z.literal('BOB'),
  z.literal('BRL'),
  z.literal('BSD'),
  z.literal('BTN'),
  z.literal('BWP'),
  z.literal('BYN'),
  z.literal('BYR'),
  z.literal('BZD'),
  z.literal('CAD'),
  z.literal('CDF'),
  z.literal('CHF'),
  z.literal('CLP'),
  z.literal('CNY'),
  z.literal('COP'),
  z.literal('CRC'),
  z.literal('CUC'),
  z.literal('CUP'),
  z.literal('CVE'),
  z.literal('CZK'),
  z.literal('DJF'),
  z.literal('DKK'),
  z.literal('DOP'),
  z.literal('DZD'),
  z.literal('EGP'),
  z.literal('ERN'),
  z.literal('ETB'),
  z.literal('EUR'),
  z.literal('FJD'),
  z.literal('FKP'),
  z.literal('GBP'),
  z.literal('GEL'),
  z.literal('GGP'),
  z.literal('GHS'),
  z.literal('GIP'),
  z.literal('GMD'),
  z.literal('GNF'),
  z.literal('GTQ'),
  z.literal('GYD'),
  z.literal('HKD'),
  z.literal('HNL'),
  z.literal('HRK'),
  z.literal('HTG'),
  z.literal('HUF'),
  z.literal('IDR'),
  z.literal('ILS'),
  z.literal('IMP'),
  z.literal('INR'),
  z.literal('IQD'),
  z.literal('IRR'),
  z.literal('ISK'),
  z.literal('JEP'),
  z.literal('JMD'),
  z.literal('JOD'),
  z.literal('JPY'),
  z.literal('KES'),
  z.literal('KGS'),
  z.literal('KHR'),
  z.literal('KMF'),
  z.literal('KPW'),
  z.literal('KRW'),
  z.literal('KWD'),
  z.literal('KYD'),
  z.literal('KZT'),
  z.literal('LAK'),
  z.literal('LBP'),
  z.literal('LKR'),
  z.literal('LRD'),
  z.literal('LSL'),
  z.literal('LYD'),
  z.literal('MAD'),
  z.literal('MDL'),
  z.literal('MGA'),
  z.literal('MKD'),
  z.literal('MMK'),
  z.literal('MNT'),
  z.literal('MOP'),
  z.literal('MRO'),
  z.literal('MUR'),
  z.literal('MVR'),
  z.literal('MWK'),
  z.literal('MXN'),
  z.literal('MYR'),
  z.literal('MZN'),
  z.literal('NAD'),
  z.literal('NGN'),
  z.literal('NIO'),
  z.literal('NOK'),
  z.literal('NPR'),
  z.literal('NZD'),
  z.literal('OMR'),
  z.literal('PAB'),
  z.literal('PEN'),
  z.literal('PGK'),
  z.literal('PHP'),
  z.literal('PKR'),
  z.literal('PLN'),
  z.literal('PYG'),
  z.literal('QAR'),
  z.literal('RON'),
  z.literal('RSD'),
  z.literal('RUB'),
  z.literal('RWF'),
  z.literal('SAR'),
  z.literal('SBD'),
  z.literal('SCR'),
  z.literal('SDG'),
  z.literal('SEK'),
  z.literal('SGD'),
  z.literal('SHP'),
  z.literal('SLL'),
  z.literal('SOS'),
  z.literal('SPL'),
  z.literal('SRD'),
  z.literal('STD'),
  z.literal('SVC'),
  z.literal('SYP'),
  z.literal('SZL'),
  z.literal('THB'),
  z.literal('TJS'),
  z.literal('TMT'),
  z.literal('TND'),
  z.literal('TOP'),
  z.literal('TRY'),
  z.literal('TTD'),
  z.literal('TVD'),
  z.literal('TWD'),
  z.literal('TZS'),
  z.literal('UAH'),
  z.literal('UGX'),
  z.literal('USD'),
  z.literal('UYU'),
  z.literal('UZS'),
  z.literal('VEF'),
  z.literal('VND'),
  z.literal('VUV'),
  z.literal('WST'),
  z.literal('XAF'),
  z.literal('XCD'),
  z.literal('XDR'),
  z.literal('XOF'),
  z.literal('XPF'),
  z.literal('YER'),
  z.literal('ZAR'),
  z.literal('ZMW'),
  z.literal('ZWD'),
]);

export const itemIdFilterSchema = z.object({
  ITEM_ID: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const availabilityFilterSchema = z.object({
  AVAILABILITY: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const conditionFilterSchema = z.object({
  CONDITION: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const itemGroupIdFilterSchema = z.object({
  ITEM_GROUP_ID: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const productGroupReferenceFilterSchema = z.object({
  PRODUCT_GROUP: catalogsProductGroupMultipleStringCriteriaSchema,
});

export const catalogsProductGroupMultipleCountriesCriteriaSchema = z.object({
  values: z.array(countrySchema),
  negated: z.boolean().optional(),
});

export const genderSchema = z.union([z.literal('FEMALE'), z.literal('MALE'), z.literal('UNISEX')]);

export const mediaTypeSchema = z.union([z.literal('IMAGE'), z.literal('VIDEO')]);

export const catalogsProductGroupMultipleStringListCriteriaSchema = z.object({
  values: z.array(z.array(z.string())),
  negated: z.boolean().optional(),
});

export const catalogsProductGroupPricingCriteriaSchema = z.object({
  inclusion: z.boolean().optional(),
  values: z.number(),
  negated: z.boolean().optional(),
});

export const catalogsRetailProductGroupProductCountsSchema = z.object({
  catalog_type: z.literal('RETAIL'),
  in_stock: z.number(),
  out_of_stock: z.number(),
  preorder: z.number(),
  total: z.number(),
  videos: z.number().optional(),
});

export const catalogsHotelProductGroupProductCountsSchema = z.object({
  catalog_type: z.literal('HOTEL'),
  total: z.number(),
});

export const catalogsCreativeAssetsProductGroupProductCountsSchema = z.object({
  catalog_type: z.literal('CREATIVE_ASSETS'),
  total: z.number(),
  videos: z.number(),
});

export const nonNullableProductAvailabilityTypeSchema = z.union([
  z.literal('IN_STOCK'),
  z.literal('OUT_OF_STOCK'),
  z.literal('PREORDER'),
]);

export const catalogsHotelGuestRatingsSchema = z.object({
  score: z.number().optional(),
  number_of_reviewers: z.number().optional(),
  max_score: z.number().optional(),
  rating_system: z.string().optional(),
});

export const itemValidationEventSchema = z.object({
  attribute: z.string().optional(),
  code: z.number().optional(),
  message: z.string().optional(),
});

export const catalogsCreativeAssetsItemErrorResponseSchema = z.object({
  catalog_type: catalogsTypeSchema,
  creative_assets_id: z.string().optional(),
  errors: z.array(itemValidationEventSchema).optional(),
});

export const itemProcessingStatusSchema = z.union([
  z.literal('SUCCESS'),
  z.literal('FAILURE'),
  z.literal('PROCESSING'),
]);

export const catalogsDeleteRetailItemSchema = z.object({
  item_id: z.string(),
  operation: z.literal('DELETE'),
});

export const catalogsRetailItemErrorResponseSchema = z.object({
  catalog_type: catalogsTypeSchema,
  item_id: z.string().optional(),
  errors: z.array(itemValidationEventSchema).optional(),
});

export const operationSchema = z.literal('CREATE');

export const updatableItemAttributesSchema = z.object({
  ad_link: z.string().optional().nullable(),
  adult: z.boolean().optional().nullable(),
  age_group: z.string().optional().nullable(),
  availability: z.string().optional(),
  average_review_rating: z.number().optional().nullable(),
  brand: z.string().optional().nullable(),
  checkout_enabled: z.boolean().optional().nullable(),
  color: z.string().optional().nullable(),
  condition: z.string().optional().nullable(),
  custom_label_0: z.string().optional().nullable(),
  custom_label_1: z.string().optional().nullable(),
  custom_label_2: z.string().optional().nullable(),
  custom_label_3: z.string().optional().nullable(),
  custom_label_4: z.string().optional().nullable(),
  description: z.string().optional(),
  free_shipping_label: z.boolean().optional().nullable(),
  free_shipping_limit: z.string().optional().nullable(),
  gender: z.string().optional().nullable(),
  google_product_category: z.string().optional().nullable(),
  gtin: z.number().optional().nullable(),
  id: z.string().optional(),
  item_group_id: z.string().optional().nullable(),
  last_updated_time: z.number().optional().nullable(),
  link: z.string().optional(),
  material: z.string().optional().nullable(),
  min_ad_price: z.string().optional().nullable(),
  mobile_link: z.string().optional().nullable(),
  mpn: z.string().optional().nullable(),
  number_of_ratings: z.number().optional().nullable(),
  number_of_reviews: z.number().optional().nullable(),
  pattern: z.string().optional().nullable(),
  price: z.string().optional(),
  product_type: z.string().optional().nullable(),
  sale_price: z.string().optional().nullable(),
  shipping: z.string().optional().nullable(),
  shipping_height: z.string().optional().nullable(),
  shipping_weight: z.string().optional().nullable(),
  shipping_width: z.string().optional().nullable(),
  size: z.string().optional().nullable(),
  size_system: z.string().optional().nullable(),
  size_type: z.string().optional().nullable(),
  tax: z.string().optional().nullable(),
  title: z.string().optional(),
  variant_names: z.array(z.string()).optional().nullable(),
  variant_values: z.array(z.string()).optional().nullable(),
});

export const updateMaskFieldTypeSchema = z.union([
  z.literal('ad_link'),
  z.literal('adult'),
  z.literal('age_group'),
  z.literal('availability'),
  z.literal('average_review_rating'),
  z.literal('brand'),
  z.literal('checkout_enabled'),
  z.literal('color'),
  z.literal('condition'),
  z.literal('custom_label_0'),
  z.literal('custom_label_1'),
  z.literal('custom_label_2'),
  z.literal('custom_label_3'),
  z.literal('custom_label_4'),
  z.literal('description'),
  z.literal('free_shipping_label'),
  z.literal('free_shipping_limit'),
  z.literal('gender'),
  z.literal('google_product_category'),
  z.literal('gtin'),
  z.literal('item_group_id'),
  z.literal('last_updated_time'),
  z.literal('link'),
  z.literal('material'),
  z.literal('min_ad_price'),
  z.literal('mpn'),
  z.literal('number_of_ratings'),
  z.literal('number_of_reviews'),
  z.literal('pattern'),
  z.literal('price'),
  z.literal('product_type'),
  z.literal('sale_price'),
  z.literal('shipping'),
  z.literal('shipping_height'),
  z.literal('shipping_weight'),
  z.literal('shipping_width'),
  z.literal('size'),
  z.literal('size_system'),
  z.literal('size_type'),
  z.literal('tax'),
  z.literal('title'),
  z.literal('variant_names'),
  z.literal('variant_values'),
]);

export const operation2Schema = z.literal('UPDATE');

export const itemAttributesRequestSchema = z
  .object({
    additional_image_link: z.array(z.string()).optional().nullable(),
    image_link: z.union([z.array(z.string()), z.string()]).optional(),
    video_link: z.string().optional().nullable(),
  })
  .and(updatableItemAttributesSchema);

export const operation3Schema = z.literal('UPSERT');

export const operation4Schema = z.literal('DELETE');

export const catalogsHotelAddressSchema = z.object({
  addr1: z.string().optional(),
  city: z.string().optional(),
  region: z.string().optional(),
  country: z.string().optional(),
  postal_code: z.string().optional(),
});

export const catalogsHotelProductMetadataSchema = z.object({
  hotel_id: z.string(),
});

export const catalogsUpdatableHotelAttributesSchema = z.object({
  name: z.string().optional().nullable(),
  link: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  brand: z.string().optional().nullable(),
  latitude: z.number().optional(),
  longitude: z.number().optional().nullable(),
  neighborhood: z.array(z.string()).optional().nullable(),
  address: catalogsHotelAddressSchema.optional(),
  custom_label_0: z.string().optional().nullable(),
  custom_label_1: z.string().optional().nullable(),
  custom_label_2: z.string().optional().nullable(),
  custom_label_3: z.string().optional().nullable(),
  custom_label_4: z.string().optional().nullable(),
  category: z.string().optional().nullable(),
  base_price: z.string().optional().nullable(),
  sale_price: z.string().optional().nullable(),
  guest_ratings: catalogsHotelGuestRatingsSchema.optional(),
});

export const creativeAssetsVisibilityTypeSchema = z.union([z.literal('VISIBLE'), z.literal('HIDDEN')]);

export const catalogsCreativeAssetsProductMetadataSchema = z.object({
  creative_assets_id: z.string(),
  visibility: creativeAssetsVisibilityTypeSchema,
});

export const catalogsDeleteCreativeAssetsItemSchema = z.object({
  creative_assets_id: z.string(),
  operation: z.literal('DELETE'),
});

export const catalogsUpdatableCreativeAssetsAttributesSchema = z.object({
  title: z.string().optional(),
  description: z.string().optional(),
  link: z.string().optional(),
  ios_deep_link: z.string().optional().nullable(),
  android_deep_link: z.string().optional().nullable(),
  google_product_category: z.string().optional().nullable(),
  custom_label_0: z.string().optional().nullable(),
  custom_label_1: z.string().optional().nullable(),
  custom_label_2: z.string().optional().nullable(),
  custom_label_3: z.string().optional().nullable(),
  custom_label_4: z.string().optional().nullable(),
  visibility: z.string().optional().nullable(),
});

export const catalogsCreativeAssetsAttributesSchema = z
  .object({
    image_link: z.string().optional(),
    video_link: z.string().optional(),
  })
  .and(catalogsUpdatableCreativeAssetsAttributesSchema);

export const conversionApiResponseSchema = z.object({
  num_events_received: z.number(),
  num_events_processed: z.number(),
  events: z.array(
    z.object({
      status: z.union([z.literal('failed'), z.literal('processed')]),
      error_message: z.string().optional().nullable(),
      warning_message: z.string().optional().nullable(),
    }),
  ),
});

export const conversionTagTypeSchema = z.union([
  z.literal('PAGE_LOAD'),
  z.literal('UNKNOWN'),
  z.literal('INITIALIZED'),
  z.literal('PAGE_VISIT'),
  z.literal('SIGNUP'),
  z.literal('CHECKOUT'),
  z.literal('CUSTOM'),
  z.literal('VIEW_CATEGORY'),
  z.literal('SEARCH'),
  z.literal('ADD_TO_CART'),
  z.literal('WATCH_VIDEO'),
  z.literal('LEAD'),
  z.literal('APP_INSTALL'),
  z.literal('WEB_SESSION'),
  z.literal('EXTERNAL_MEASUREMENT'),
]);

export const conversionEventsUserDataSchema = z.union([
  z.object({
    em: z.array(z.string()),
    hashed_maids: z.array(z.string()).optional(),
    client_ip_address: z.string().optional(),
    client_user_agent: z.string().optional(),
  }),
  z.object({
    em: z.array(z.string()).optional(),
    hashed_maids: z.array(z.string()),
    client_ip_address: z.string().optional(),
    client_user_agent: z.string().optional(),
  }),
  z.object({
    em: z.array(z.string()).optional(),
    hashed_maids: z.array(z.string()).optional(),
    client_ip_address: z.string(),
    client_user_agent: z.string(),
  }),
  z.object({
    ph: z.array(z.string()).optional(),
    ge: z.array(z.string()).optional(),
    db: z.array(z.string()).optional(),
    ln: z.array(z.string()).optional(),
    fn: z.array(z.string()).optional(),
    ct: z.array(z.string()).optional(),
    st: z.array(z.string()).optional(),
    zp: z.array(z.string()).optional(),
    country: z.array(z.string()).optional(),
    external_id: z.array(z.string()).optional(),
    click_id: z.string().optional().nullable(),
    partner_id: z.string().optional().nullable(),
  }),
]);

export const enhancedMatchStatusTypeSchema = z.union([
  z.literal('UNKNOWN'),
  z.literal('NOT_VALIDATED'),
  z.literal('VALIDATING_IN_PROGRESS'),
  z.literal('VALIDATION_COMPLETE'),
]);

export const conversionTagConfigsSchema = z.object({
  aem_enabled: z.boolean().optional().nullable(),
  md_frequency: z.number().optional().nullable(),
  aem_fnln_enabled: z.boolean().optional().nullable(),
  aem_ph_enabled: z.boolean().optional().nullable(),
  aem_ge_enabled: z.boolean().optional().nullable(),
  aem_db_enabled: z.boolean().optional().nullable(),
  aem_loc_enabled: z.boolean().optional().nullable(),
});

export const conversionTagCreateSchema = conversionTagConfigsSchema.and(
  z.object({
    name: z.string(),
  }),
);

export const conversionTagCommonSchema = z.object({
  ad_account_id: z.string().optional(),
  code_snippet: z.string().optional(),
  enhanced_match_status: enhancedMatchStatusTypeSchema.optional(),
  id: z.string().optional(),
  last_fired_time_ms: z.number().optional().nullable(),
  name: z.string().optional(),
  status: entityStatusSchema.optional(),
  version: z.string().optional(),
  configs: conversionTagConfigsSchema.optional(),
});

export const countryFilterSchema = z.object({
  COUNTRY: catalogsProductGroupMultipleCountriesCriteriaSchema,
});

export const assetIdToPermissionsSchema = z.record(z.array(permissionsSchema));

export const createAssetAccessRequestErrorMessageSchema = z
  .array(
    z.object({
      code: z.number().optional(),
      messages: z.array(z.string()).optional(),
    }),
  )
  .nullable();

export const createAssetAccessRequestResponseSchema = z.object({
  exceptions: createAssetAccessRequestErrorMessageSchema.optional(),
  invites: z.record(z.string()).optional().nullable(),
});

export const assetGroupBindingSchema = z.object({
  id: z.string().optional(),
  asset_group_name: z.string().optional().nullable(),
  asset_group_description: z.string().optional().nullable(),
  asset_group_types: z.array(z.string()).optional(),
  ad_accounts_ids: z.array(z.string()).optional().nullable(),
  profiles_ids: z.array(z.string()).optional().nullable(),
  created_time: z.number().optional().nullable(),
  updated_time: z.number().optional().nullable(),
  owner: businessAccessUserSummarySchema.optional().nullable(),
  created_by: businessAccessUserSummarySchema.optional().nullable(),
});

export const inviteExceptionResponseSchema = z
  .object({
    invite_or_request_id: z.string().optional().nullable(),
    code: z.number().optional(),
    message: z.string().optional(),
    users_or_partner_ids: z.array(z.string()).optional().nullable(),
  })
  .nullable();

export const inviteTypeSchema = z.union([
  z.literal('MEMBER_INVITE'),
  z.literal('PARTNER_INVITE'),
  z.literal('PARTNER_REQUEST'),
]);

export const targetingAdvertiserCountrySchema = z.union([
  z.literal('US'),
  z.literal('GB'),
  z.literal('CA'),
  z.literal('IE'),
  z.literal('AU'),
  z.literal('NZ'),
  z.literal('FR'),
  z.literal('SE'),
  z.literal('IL'),
  z.literal('DE'),
  z.literal('AT'),
  z.literal('IT'),
  z.literal('ES'),
  z.literal('NL'),
  z.literal('BE'),
  z.literal('PT'),
  z.literal('CH'),
  z.literal('HK'),
  z.literal('JP'),
  z.literal('KR'),
  z.literal('SG'),
  z.literal('NO'),
  z.literal('DK'),
  z.literal('FI'),
  z.literal('CY'),
  z.literal('LU'),
  z.literal('MT'),
  z.literal('PL'),
  z.literal('RO'),
  z.literal('HU'),
  z.literal('CZ'),
  z.literal('GR'),
  z.literal('SK'),
  z.literal('BR'),
  z.literal('MX'),
  z.literal('AR'),
  z.literal('CL'),
  z.literal('CO'),
]);

export const mMMReportingTargetingTypeSchema = z.union([
  z.literal('APPTYPE'),
  z.literal('COUNTRY'),
  z.literal('CREATIVE_TYPE'),
  z.literal('GENDER'),
  z.literal('LOCATION'),
]);

export const mMMReportingColumnSchema = z.union([
  z.literal('SPEND_IN_DOLLAR'),
  z.literal('SPEND_IN_MICRO_DOLLAR'),
  z.literal('ECPC_IN_DOLLAR'),
  z.literal('ECTR'),
  z.literal('CAMPAIGN_NAME'),
  z.literal('TOTAL_ENGAGEMENT'),
  z.literal('EENGAGEMENT_RATE'),
  z.literal('ECPM_IN_DOLLAR'),
  z.literal('CAMPAIGN_ID'),
  z.literal('ADVERTISER_ID'),
  z.literal('AD_GROUP_ID'),
  z.literal('AD_GROUP_NAME'),
  z.literal('CLICKTHROUGH_1'),
  z.literal('IMPRESSION_1'),
  z.literal('CLICKTHROUGH_2'),
  z.literal('IMPRESSION_2'),
  z.literal('TOTAL_CLICKTHROUGH'),
  z.literal('TOTAL_IMPRESSION'),
  z.literal('ADVERTISER_NAME'),
  z.literal('SPEND_ORDER_LINE_PAID_TYPE'),
]);

export const levelSchema = z.union([z.literal('CAMPAIGN_TARGETING'), z.literal('AD_GROUP_TARGETING')]);

export const createMMMReportResponseSchema = z.object({
  code: z.number().optional(),
  data: z
    .object({
      report_status: bulkReportingJobStatusSchema.optional(),
      token: z.string().optional(),
      message: z.string().optional().nullable(),
      status: z.string().optional(),
    })
    .optional(),
});

export const catalogsProductGroupCurrencyCriteriaSchema = z.object({
  values: nonNullableCatalogsCurrencySchema,
  negated: z.boolean().optional(),
});

export const customColumnIdSchema = z.string();

export const customerListSchema = z.object({
  ad_account_id: z.string().optional(),
  created_time: z.number().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  num_batches: z.number().optional(),
  num_removed_user_records: z.number().optional(),
  num_uploaded_user_records: z.number().optional(),
  status: z
    .union([z.literal('PROCESSING'), z.literal('READY'), z.literal('TOO_SMALL'), z.literal('UPLOADING')])
    .optional(),
  type: z.string().optional(),
  updated_time: z.number().optional(),
  exceptions: z.record(z.unknown()).optional(),
});

export const status2Schema = z.union([
  z.literal('PROCESSING'),
  z.literal('READY'),
  z.literal('TOO_SMALL'),
  z.literal('UPLOADING'),
]);

export const userListTypeSchema = z.union([
  z.literal('EMAIL'),
  z.literal('IDFA'),
  z.literal('MAID'),
  z.literal('LR_ID'),
  z.literal('DLX_ID'),
  z.literal('HASHED_PINNER_ID'),
]);

export const userListOperationTypeSchema = z.union([z.literal('ADD'), z.literal('REMOVE')]);

export const deleteMemberAccessResultSchema = z.object({
  asset_id: z.string().optional(),
  member_id: z.string().optional(),
});

export const deleteMemberAccessResultsResponseArraySchema = z.object({
  items: z.array(deleteMemberAccessResultSchema).optional(),
});

export const deletedMembersResponseSchema = z.object({
  deleted_members: z.array(z.string()).optional(),
});

export const deletePartnersRequestSchema = z.object({
  partner_ids: z.array(z.string()),
  partner_type: z
    .union([z.string(), z.null().and(businessRoleCheckModeSchema)])
    .optional()
    .nullable(),
});

export const deletePartnersResponseSchema = z.object({
  deleted_partners: z.array(z.string()).optional(),
});

export const deliveryMetricsResponseSchema = z.object({
  items: z
    .array(
      z.object({
        name: z.string().optional(),
        category: z.union([z.literal('ADS'), z.literal('ORGANIC')]).optional(),
        definition: z.string().optional(),
        display_name: z.string().optional(),
      }),
    )
    .optional(),
});

export const detailedErrorSchema = z.object({
  code: z.number(),
  message: z.string(),
  details: z.record(z.unknown()),
});

export const pinMediaSchema = z.object({
  media_type: z.string().optional(),
});

export const errorSchema = z.object({
  code: z.number(),
  message: z.string(),
});

export const followUserRequestSchema = z.object({
  auto_follow: z.boolean().optional(),
});

export const catalogsProductGroupMultipleGenderCriteriaSchema = z.object({
  values: z.array(genderSchema),
  negated: z.boolean().optional(),
});

export const catalogsProductGroupMultipleMediaTypesCriteriaSchema = z.object({
  values: z.array(mediaTypeSchema),
  negated: z.boolean().optional(),
});

export const genderListSchema = z.array(z.union([z.literal('female'), z.literal('male'), z.literal('unknown')]));

export const getAudiencesOrderBySchema = z.union([
  z.literal('NONE'),
  z.literal('ID'),
  z.literal('SIZE'),
  z.literal('CREATION_DATE'),
  z.literal('UPDATED_TIME'),
  z.literal('NAME'),
  z.literal('STATUS'),
  z.literal('TYPE'),
]);

export const getBusinessAssetsResponseSchema = z.object({
  asset_id: z.string().optional(),
  asset_type: assetTypeResponseSchema.optional(),
  asset_group_info: assetGroupBindingSchema.optional().nullable(),
});

export const getBusinessAssetTypeResponseSchema = z.union([
  z.literal('AD_ACCOUNT'),
  z.literal('PROFILE'),
  z.literal('ASSET_GROUP'),
  z.literal('CONVERSION_TAG'),
]);

export const getMMMReportResponseSchema = z.object({
  code: z.number().optional(),
  data: z
    .object({
      report_status: z
        .union([
          z.literal('DOES_NOT_EXIST'),
          z.literal('FINISHED'),
          z.literal('IN_PROGRESS'),
          z.literal('EXPIRED'),
          z.literal('FAILED'),
          z.literal('CANCELLED'),
        ])
        .optional(),
      url: z.string().optional().nullable(),
      size: z.number().optional().nullable(),
    })
    .optional(),
  message: z.string().optional(),
  status: z.string().optional(),
});

export const reportStatus2Schema = z.union([
  z.literal('DOES_NOT_EXIST'),
  z.literal('FINISHED'),
  z.literal('IN_PROGRESS'),
  z.literal('EXPIRED'),
  z.literal('FAILED'),
  z.literal('CANCELLED'),
]);

export const getPartnerAssetsResponseSchema = z.object({
  asset_id: z.string().optional(),
  asset_type: assetTypeResponseSchema.optional(),
  permissions: z.array(z.string()).optional(),
  asset_group_info: assetGroupBindingSchema.optional().nullable(),
});

export const googleProductCategory0FilterSchema = z.object({
  GOOGLE_PRODUCT_CATEGORY_0: catalogsProductGroupMultipleStringListCriteriaSchema,
});

export const googleProductCategory1FilterSchema = z.object({
  GOOGLE_PRODUCT_CATEGORY_1: catalogsProductGroupMultipleStringListCriteriaSchema,
});

export const googleProductCategory2FilterSchema = z.object({
  GOOGLE_PRODUCT_CATEGORY_2: catalogsProductGroupMultipleStringListCriteriaSchema,
});

export const googleProductCategory3FilterSchema = z.object({
  GOOGLE_PRODUCT_CATEGORY_3: catalogsProductGroupMultipleStringListCriteriaSchema,
});

export const googleProductCategory4FilterSchema = z.object({
  GOOGLE_PRODUCT_CATEGORY_4: catalogsProductGroupMultipleStringListCriteriaSchema,
});

export const googleProductCategory5FilterSchema = z.object({
  GOOGLE_PRODUCT_CATEGORY_5: catalogsProductGroupMultipleStringListCriteriaSchema,
});

export const googleProductCategory6FilterSchema = z.object({
  GOOGLE_PRODUCT_CATEGORY_6: catalogsProductGroupMultipleStringListCriteriaSchema,
});

export const hotelProcessingRecordSchema = z.object({
  hotel_id: z.string().optional(),
  errors: z.array(itemValidationEventSchema).optional(),
  warnings: z.array(itemValidationEventSchema).optional(),
  status: itemProcessingStatusSchema.optional(),
});

export const imageDetailsSchema = z.object({
  width: z.number(),
  height: z.number().nullable(),
  url: z.string(),
});

export const imageMetadataSchema = z.object({
  item_type: z.string().optional(),
  title: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  link: z.string().optional().nullable(),
  images: z
    .object({
      '150x150': imageDetailsSchema.optional(),
      '400x300': imageDetailsSchema.optional(),
      '600x': imageDetailsSchema.optional(),
      '1200x': imageDetailsSchema.optional(),
    })
    .optional(),
});

export const integrationLogClientErrorSchema = z.object({
  cause: z.string().optional(),
  column_number: z.number().optional(),
  file_name: z.string().optional(),
  line_number: z.number().optional(),
  message: z.string().optional(),
  message_detail: z.string().optional(),
  name: z.string().optional(),
  number: z.number().optional(),
  stack_trace: z.string().optional(),
});

export const integrationLogClientRequestSchema = z.object({
  method: z.union([
    z.literal('GET'),
    z.literal('HEAD'),
    z.literal('POST'),
    z.literal('PUT'),
    z.literal('DELETE'),
    z.literal('CONNECT'),
    z.literal('OPTIONS'),
    z.literal('TRACE'),
    z.literal('PATCH'),
  ]),
  host: z.string(),
  path: z.string(),
  request_headers: z.record(z.string()).optional(),
  response_headers: z.record(z.string()).optional(),
  response_status_code: z.number().optional(),
});

export const eventTypeSchema = z.union([z.literal('APP'), z.literal('API')]);

export const logLevelSchema = z.union([z.literal('INFO'), z.literal('WARN'), z.literal('ERROR')]);

export const methodSchema = z.union([
  z.literal('GET'),
  z.literal('HEAD'),
  z.literal('POST'),
  z.literal('PUT'),
  z.literal('DELETE'),
  z.literal('CONNECT'),
  z.literal('OPTIONS'),
  z.literal('TRACE'),
  z.literal('PATCH'),
]);

export const integrationLogsInvalidLogResponseSchema = z.object({
  rejected_logs: z
    .array(
      z.object({
        log_index: z.number().optional(),
        field: z.string(),
        value: z.string(),
        reason: z.string(),
      }),
    )
    .optional(),
});

export const integrationLogSchema = z.object({
  client_timestamp: z.number(),
  event_type: z.union([z.literal('APP'), z.literal('API')]),
  log_level: z.union([z.literal('INFO'), z.literal('WARN'), z.literal('ERROR')]),
  external_business_id: z.string().optional().nullable(),
  advertiser_id: z.string().optional().nullable(),
  merchant_id: z.string().optional().nullable(),
  tag_id: z.string().optional().nullable(),
  feed_profile_id: z.string().optional().nullable(),
  message: z.string().optional(),
  app_version_number: z.string().optional(),
  platform_version_number: z.string().optional(),
  error: integrationLogClientErrorSchema.optional(),
  request: integrationLogClientRequestSchema.optional(),
});

export const integrationLogsSuccessResponseSchema = z.object({
  message: z.string().optional(),
});

export const integrationMetadataSchema = z.object({
  id: z.string().optional(),
  external_business_id: z.string().optional(),
  connected_merchant_id: z.string().optional(),
  connected_user_id: z.string().optional(),
  connected_advertiser_id: z.string().optional(),
  connected_lba_id: z.string().optional(),
  connected_tag_id: z.string().optional(),
  partner_access_token_expiry: z.number().optional(),
  partner_refresh_token_expiry: z.number().optional(),
  scopes: z.string().optional(),
  created_timestamp: z.number().optional(),
  updated_timestamp: z.number().optional(),
  additional_id_1: z.string().optional(),
  partner_metadata: z.string().optional(),
});

export const integrationRequestSchema = z.object({
  external_business_id: z.string().optional().nullable(),
  connected_merchant_id: z.string().optional(),
  connected_advertiser_id: z.string().optional(),
  connected_lba_id: z.string().optional(),
  connected_tag_id: z.string().optional(),
  partner_access_token: z.string().optional(),
  partner_refresh_token: z.string().optional(),
  partner_primary_email: z.string().optional(),
  partner_access_token_expiry: z.number().optional(),
  partner_refresh_token_expiry: z.number().optional(),
  scopes: z.string().optional(),
  additional_id_1: z.string().optional(),
  partner_metadata: z.string().optional(),
});

export const integrationRequestPatchSchema = z.object({
  connected_merchant_id: z.string().optional(),
  connected_advertiser_id: z.string().optional(),
  connected_lba_id: z.string().optional(),
  connected_tag_id: z.string().optional(),
  partner_access_token: z.string().optional(),
  partner_refresh_token: z.string().optional(),
  partner_primary_email: z.string().optional(),
  partner_access_token_expiry: z.number().optional(),
  partner_refresh_token_expiry: z.number().optional(),
  scopes: z.string().optional(),
  additional_id_1: z.string().optional(),
  partner_metadata: z.string().optional(),
});

export const integrationRecordSchema = z.object({
  id: z.string().optional(),
  external_business_id: z.string().optional().nullable(),
  connected_merchant_id: z.string().optional().nullable(),
  connected_user_id: z.string().optional(),
  connected_advertiser_id: z.string().optional().nullable(),
  connected_lba_id: z.string().optional().nullable(),
  connected_tag_id: z.string().optional().nullable(),
  partner_access_token: z.string().optional().nullable(),
  partner_refresh_token: z.string().optional().nullable(),
  partner_primary_email: z.string().optional().nullable(),
  partner_access_token_expiry: z.number().optional().nullable(),
  partner_refresh_token_expiry: z.number().optional().nullable(),
  scopes: z.string().optional().nullable(),
  partner_metadata: z.string().optional().nullable(),
  additional_id_1: z.string().optional().nullable(),
  created_time: z.number().optional(),
  updated_time: z.number().optional(),
});

export const interestSchema = z.object({
  canonical_url: z.string().optional(),
  id: z.string().optional(),
  key: z.string().optional(),
  name: z.string().optional(),
});

export const inviteAssetsSummarySchema = z
  .object({
    ad_accounts: z
      .array(
        z.object({
          id: z.string().optional(),
          permissions: permissionsResponseSchema.optional(),
        }),
      )
      .optional(),
    profiles: z
      .array(
        z.object({
          id: z.string().optional(),
          permissions: permissionsResponseSchema.optional(),
        }),
      )
      .optional(),
  })
  .nullable();

export const baseInviteDataResponseSchema = z
  .object({
    id: z.string().optional(),
    invite_data: z
      .object({
        invite_expiration: z.number().optional(),
        invite_status: z.string().optional(),
        invite_type: z.string().optional(),
        last_updated_time: z.number().optional(),
        sent_at: z.number().optional(),
      })
      .optional(),
    is_received_invite: z.boolean().optional(),
    user: businessAccessUserSummarySchema.optional(),
  })
  .nullable();

export const inviteResponseSchema = baseInviteDataResponseSchema.and(
  z.object({
    assets_summary: inviteAssetsSummarySchema.optional(),
    business_roles: z.array(businessRoleResponseSchema).optional(),
    created_by_business: businessAccessUserSummarySchema.optional().nullable(),
    created_by_user: businessAccessUserSummarySchema.optional().nullable(),
    created_time: z.number().optional(),
  }),
);

export const inviteStatusSchema = z.union([
  z.literal('PENDING'),
  z.literal('ACCEPTED'),
  z.literal('DECLINED'),
  z.literal('CANCELLED'),
  z.literal('EXPIRED'),
]);

export const assetGroupTypeSchema = z.union([
  z.literal('BRAND'),
  z.literal('LOCATION_OR_LANGUAGE'),
  z.literal('PRODUCT_LINE'),
  z.literal('OTHER'),
]);

export const assetGroupTypesSchema = z.array(assetGroupTypeSchema);

export const itemAttributesSchema = z
  .object({
    additional_image_link: z.array(z.string()).optional().nullable(),
    image_link: z.array(z.string()).optional(),
    video_link: z.string().optional().nullable(),
  })
  .and(updatableItemAttributesSchema);

export const itemCreateBatchRecordSchema = z.object({
  item_id: z.string().optional(),
  attributes: itemAttributesRequestSchema.optional(),
});

export const itemUpdateBatchRecordSchema = z.object({
  item_id: z.string().optional(),
  attributes: updatableItemAttributesSchema.optional(),
  update_mask: z.array(updateMaskFieldTypeSchema).optional().nullable(),
});

export const itemUpsertBatchRecordSchema = z.object({
  item_id: z.string().optional(),
  attributes: itemAttributesRequestSchema.optional(),
});

export const itemProcessingRecordSchema = z.object({
  item_id: z.string().optional(),
  errors: z.array(itemValidationEventSchema).optional(),
  warnings: z.array(itemValidationEventSchema).optional(),
  status: itemProcessingStatusSchema.optional(),
});

export const catalogsHotelItemErrorResponseSchema = z.object({
  catalog_type: catalogsTypeSchema,
  hotel_id: z.string().optional(),
  errors: z.array(itemValidationEventSchema).optional(),
});

export const keywordsCommonSchema = z.object({
  bid: z.number().optional().nullable(),
  match_type: matchTypeResponseSchema,
  value: z.string(),
});

export const keywordSchema = keywordsCommonSchema.and(
  z.object({
    archived: z.boolean().optional(),
    id: z.string().optional(),
    parent_id: z.string().optional(),
    parent_type: z.string().optional(),
    type: z.string().optional(),
  }),
);

export const keywordListSchema = z.array(z.string());

export const keywordMetricsSchema = z.object({
  avg_cpc_in_micro_currency: z.number().optional(),
  keyword_query_volume: z.string().optional(),
});

export const keywordMetricsResponseSchema = z.object({
  keyword: z.string().optional(),
  metrics: keywordMetricsSchema.optional(),
});

export const keywordUpdateBodySchema = z.object({
  keywords: z.array(keywordUpdateSchema),
});

export const keywordsMetricsArrayResponseSchema = z.object({
  data: z.array(keywordMetricsResponseSchema).optional(),
});

export const keywordsRequestSchema = z.object({
  keywords: z.array(keywordsCommonSchema),
  parent_id: z.string(),
});

export const keywordErrorSchema = z.object({
  data: keywordSchema.optional(),
  error_messages: z.array(z.string()).optional(),
});

export const l1InterestListSchema = z.array(
  z.union([
    z.literal('animals'),
    z.literal('architecture'),
    z.literal('art'),
    z.literal('beauty'),
    z.literal('childrens_fashion'),
    z.literal('design'),
    z.literal('diy_and_crafts'),
    z.literal('education'),
    z.literal('electronics'),
    z.literal('entertainment'),
    z.literal('event_planning'),
    z.literal('finance'),
    z.literal('food_and_drinks'),
    z.literal('gardening'),
    z.literal('health'),
    z.literal('home_decor'),
    z.literal('mens_fashion'),
    z.literal('parenting'),
    z.literal('quotes'),
    z.literal('sport'),
    z.literal('travel'),
    z.literal('vehicles'),
    z.literal('wedding'),
    z.literal('womens_fashion'),
  ]),
);

export const leadFormStatusSchema = z.union([z.literal('DRAFT'), z.literal('ACTIVE')]);

export const leadFormQuestionTypeSchema = z.union([
  z.literal('CUSTOM'),
  z.literal('FULL_NAME'),
  z.literal('FIRST_NAME'),
  z.literal('LAST_NAME'),
  z.literal('EMAIL'),
  z.literal('PHONE_NUMBER'),
  z.literal('ZIP_CODE'),
  z.literal('GENDER'),
  z.literal('CITY'),
  z.literal('COUNTRY'),
  z.literal('STATE_PROVINCE'),
  z.literal('ADDRESS'),
  z.literal('DATE_OF_BIRTH'),
  z.literal('AGE'),
]);

export const leadFormQuestionFieldTypeSchema = z.union([
  z.literal('TEXT_FIELD'),
  z.literal('TEXT_AREA'),
  z.literal('RADIO_LIST'),
  z.literal('CHECKBOX'),
]);

export const leadFormTestRequestSchema = z.object({
  answers: z.array(z.string()),
});

export const leadFormTestResponseSchema = z.object({
  subscription_id: z.string().optional(),
});

export const leadsExportCreateRequestSchema = z.object({
  start_date: z.string(),
  end_date: z.string(),
  ad_id: z.string(),
});

export const leadsExportCreateResponseSchema = z.object({
  leads_export_id: z.string().optional(),
});

export const leadsExportStatusSchema = z.union([z.literal('IN_PROGRESS'), z.literal('FINISHED'), z.literal('FAILED')]);

export const leadsExportResponseDataSchema = z.object({
  export_status: leadsExportStatusSchema.optional(),
  download_url: z.string().optional().nullable(),
});

export const linkedBusinessSchema = z.object({
  username: z.string().optional(),
  image_small_url: z.string().optional(),
  image_medium_url: z.string().optional(),
  image_large_url: z.string().optional(),
  image_xlarge_url: z.string().optional(),
});

export const memberBusinessRoleSchema = z.union([z.literal('EMPLOYEE'), z.literal('BIZ_ADMIN')]);

export const matchTypeSchema = z.union([
  z.literal('BROAD'),
  z.literal('PHRASE'),
  z.literal('EXACT'),
  z.literal('EXACT_NEGATIVE'),
  z.literal('PHRASE_NEGATIVE'),
]);

export const maxPriceFilterSchema = z.object({
  MAX_PRICE: catalogsProductGroupPricingCriteriaSchema,
});

export const mediaUploadTypeSchema = z.literal('video');

export const mediaUploadStatusSchema = z.union([
  z.literal('registered'),
  z.literal('processing'),
  z.literal('succeeded'),
  z.literal('failed'),
]);

export const mediaUploadRequestSchema = z.object({
  media_type: mediaUploadTypeSchema,
});

export const membersToDeleteBodySchema = z.object({
  members: z.array(
    z.object({
      member_id: z.string(),
      business_role: businessRoleForMembersSchema,
    }),
  ),
});

export const metricsResponseSchema = z.object({
  data: z.array(z.record(z.unknown())).optional(),
});

export const priceFilterSchema = z.object({
  PRICE: z.object({
    operator: z.union([
      z.literal('GREATER_THAN'),
      z.literal('GREATER_THAN_OR_EQUALS'),
      z.literal('LESS_THAN'),
      z.literal('LESS_THAN_OR_EQUALS'),
    ]),
    value: z.number(),
    currency: nonNullableCatalogsCurrencySchema,
    negated: z.boolean().optional(),
  }),
});

export const operatorSchema = z.union([
  z.literal('GREATER_THAN'),
  z.literal('GREATER_THAN_OR_EQUALS'),
  z.literal('LESS_THAN'),
  z.literal('LESS_THAN_OR_EQUALS'),
]);

export const minPriceFilterSchema = z.object({
  MIN_PRICE: catalogsProductGroupPricingCriteriaSchema,
});

export const oauthAccessTokenRequestSchema = z.object({
  grant_type: z.union([z.literal('authorization_code'), z.literal('refresh_token'), z.literal('client_credentials')]),
});

export const grantTypeSchema = z.union([
  z.literal('authorization_code'),
  z.literal('refresh_token'),
  z.literal('client_credentials'),
]);

export const oauthAccessTokenRequestCodeSchema = z
  .object({
    code: z.string(),
    redirect_uri: z.string(),
  })
  .and(
    z.object({
      grant_type: z.union([
        z.literal('authorization_code'),
        z.literal('refresh_token'),
        z.literal('client_credentials'),
      ]),
    }),
  );

export const oauthAccessTokenRequestRefreshSchema = z
  .object({
    refresh_token: z.string(),
    scope: z.string().optional(),
    refresh_on: z.boolean().optional(),
  })
  .and(
    z.object({
      grant_type: z.union([
        z.literal('authorization_code'),
        z.literal('refresh_token'),
        z.literal('client_credentials'),
      ]),
    }),
  );

export const oauthAccessTokenRequestClientCredentialsSchema = z
  .object({
    scope: z.string(),
  })
  .and(
    z.object({
      grant_type: z.union([
        z.literal('authorization_code'),
        z.literal('refresh_token'),
        z.literal('client_credentials'),
      ]),
    }),
  );

export const oauthAccessTokenResponseSchema = z.object({
  response_type: z
    .union([z.literal('authorization_code'), z.literal('refresh_token'), z.literal('client_credentials')])
    .optional(),
  access_token: z.string(),
  token_type: z.string(),
  expires_in: z.number(),
  scope: z.string(),
});

export const responseTypeSchema = z.union([
  z.literal('authorization_code'),
  z.literal('refresh_token'),
  z.literal('client_credentials'),
]);

export const oauthAccessTokenResponseCodeSchema = z
  .object({
    refresh_token: z.string(),
    refresh_token_expires_in: z.number(),
  })
  .and(
    z.object({
      response_type: z
        .union([z.literal('authorization_code'), z.literal('refresh_token'), z.literal('client_credentials')])
        .optional(),
      access_token: z.string(),
      token_type: z.string(),
      expires_in: z.number(),
      scope: z.string(),
    }),
  );

export const oauthAccessTokenResponseEverlastingRefreshSchema = z
  .object({
    refresh_token: z.string(),
    refresh_token_expires_in: z.number(),
    refresh_token_expires_at: z.number(),
  })
  .and(
    z.object({
      response_type: z
        .union([z.literal('authorization_code'), z.literal('refresh_token'), z.literal('client_credentials')])
        .optional(),
      access_token: z.string(),
      token_type: z.string(),
      expires_in: z.number(),
      scope: z.string(),
    }),
  );

export const oauthAccessTokenResponseIntegrationRefreshSchema = z
  .object({
    refresh_token: z.string(),
    refresh_token_expires_in: z.number(),
  })
  .and(
    z.object({
      response_type: z
        .union([z.literal('authorization_code'), z.literal('refresh_token'), z.literal('client_credentials')])
        .optional(),
      access_token: z.string(),
      token_type: z.string(),
      expires_in: z.number(),
      scope: z.string(),
    }),
  );

export const oauthAccessTokenResponseRefreshSchema = z.object({
  response_type: z
    .union([z.literal('authorization_code'), z.literal('refresh_token'), z.literal('client_credentials')])
    .optional(),
  access_token: z.string(),
  token_type: z.string(),
  expires_in: z.number(),
  scope: z.string(),
});

export const oauthAccessTokenResponseClientCredentialsSchema = z.object({
  response_type: z
    .union([z.literal('authorization_code'), z.literal('refresh_token'), z.literal('client_credentials')])
    .optional(),
  access_token: z.string(),
  token_type: z.string(),
  expires_in: z.number(),
  scope: z.string(),
});

export const conversionEventSchema = z.union([
  z.literal('PAGE_VISIT'),
  z.literal('SIGNUP'),
  z.literal('CHECKOUT'),
  z.literal('CUSTOM'),
  z.literal('VIEW_CATEGORY'),
  z.literal('SEARCH'),
  z.literal('ADD_TO_CART'),
  z.literal('WATCH_VIDEO'),
  z.literal('LEAD'),
  z.literal('APP_INSTALL'),
]);

export const learningModeTypeSchema = z.union([z.literal('NOT_ACTIVE'), z.literal('ACTIVE')]);

export const timerangeSchema = z.union([
  z.literal('THIRTY_DAY'),
  z.literal('DAY'),
  z.literal('SEVEN_DAY'),
  z.literal('TWENTY_MINUTE'),
  z.literal('TEN_MINUTE'),
  z.literal('TWENTY_FOUR_HOUR'),
]);

export const orderLinePaidTypeSchema = z.union([
  z.literal('PAID'),
  z.literal('BONUS'),
  z.literal('MAKE_GOOD'),
  z.literal('TEST'),
]);

export const orderLineStatusSchema = z.union([z.literal('ACTIVE'), z.literal('PAUSED'), z.literal('DELETED')]);

export const orderLinesSchema = z.object({
  id: z.string().optional(),
  type: z.string().optional(),
  ad_account_id: z.string().optional(),
  purchase_order_id: z.string().optional().nullable(),
  start_time: z.number().optional(),
  end_time: z.number().optional().nullable(),
  budget: z.number().optional().nullable(),
  paid_budget: z.number().optional().nullable(),
  status: orderLineStatusSchema.optional(),
  name: z.string().optional().nullable(),
  paid_type: orderLinePaidTypeSchema.optional().nullable(),
});

export const orderLinesArrayResponseSchema = z.object({
  items: z.array(orderLinesSchema).optional(),
});

export const paginatedSchema = z.object({
  items: z.array(z.record(z.unknown())),
  bookmark: z.string().optional().nullable(),
});

export const permissionsWithOwnerSchema = z.union([
  z.literal('ADMIN'),
  z.literal('ANALYST'),
  z.literal('FINANCE_MANAGER'),
  z.literal('AUDIENCE_MANAGER'),
  z.literal('CAMPAIGN_MANAGER'),
  z.literal('CATALOGS_MANAGER'),
  z.literal('CATALOGS_VIEWER'),
  z.literal('PROFILE_PUBLISHER'),
  z.literal('OWNER'),
]);

export const pinAnalyticsMetricsResponseSchema = z.object({
  lifetime_metrics: z.record(z.number()).optional(),
  daily_metrics: z
    .array(
      z.object({
        data_status: dataStatusSchema.optional(),
        date: z.string().optional(),
        metrics: z.record(z.number()).optional(),
      }),
    )
    .optional(),
  summary_metrics: z.record(z.number()).optional(),
});

export const pinAnalyticsResponseSchema = z.record(pinAnalyticsMetricsResponseSchema);

export const bulkPinAnalyticsResponseSchema = z.record(pinAnalyticsResponseSchema);

export const videoMetadataSchema = z.object({
  item_type: z.string().optional(),
  cover_image_url: z.string().optional(),
  video_url: z.string().optional().nullable(),
  duration: z.number().optional(),
  height: z.number().optional(),
  width: z.number().optional(),
});

export const pinMediaSourceImageBase64Schema = z.object({
  source_type: z.literal('image_base64'),
  content_type: z.union([z.literal('image/jpeg'), z.literal('image/png')]),
  data: z.string(),
  is_standard: z.boolean().optional(),
});

export const pinMediaSourceImageURLSchema = z.object({
  source_type: z.literal('image_url'),
  url: z.string(),
  is_standard: z.boolean().optional(),
});

export const pinMediaSourceVideoIDSchema = z.object({
  source_type: z.literal('video_id'),
  cover_image_url: z.string().optional(),
  cover_image_content_type: z.union([z.literal('image/jpeg'), z.literal('image/png')]).optional(),
  cover_image_data: z.string().optional(),
  media_id: z.string(),
  is_standard: z.boolean().optional(),
});

export const pinMediaSourceImagesBase64Schema = z.object({
  source_type: z.literal('multiple_image_base64').optional(),
  items: z.array(
    z.object({
      title: z.string().optional(),
      description: z.string().optional(),
      link: z.string().optional(),
      content_type: z.union([z.literal('image/jpeg'), z.literal('image/png')]),
      data: z.string(),
    }),
  ),
  index: z.number().optional(),
});

export const pinMediaSourceImagesURLSchema = z.object({
  source_type: z.literal('multiple_image_urls').optional(),
  items: z.array(
    z.object({
      title: z.string().optional(),
      description: z.string().optional(),
      link: z.string().optional(),
      url: z.string(),
    }),
  ),
  index: z.number().optional(),
});

export const pinMediaSourcePinURLSchema = z.object({
  source_type: z.literal('pin_url'),
  is_affiliate_link: z.boolean().optional(),
});

export const contentTypeSchema = z.union([z.literal('image/jpeg'), z.literal('image/png')]);

export const coverImageContentTypeSchema = z.union([z.literal('image/jpeg'), z.literal('image/png')]);

export const pinMediaWithImageSchema = z
  .object({
    images: z
      .object({
        '150x150': imageDetailsSchema.optional(),
        '400x300': imageDetailsSchema.optional(),
        '600x': imageDetailsSchema.optional(),
        '1200x': imageDetailsSchema.optional(),
      })
      .optional(),
  })
  .and(pinMediaSchema);

export const pinMediaMetadataSchema = z.union([imageMetadataSchema, videoMetadataSchema]);

export const pinMediaWithImagesSchema = z
  .object({
    items: z.array(imageMetadataSchema).optional(),
  })
  .and(pinMediaSchema);

export const pinMediaWithVideoSchema = z
  .object({
    images: z
      .object({
        '150x150': imageDetailsSchema.optional(),
        '400x300': imageDetailsSchema.optional(),
        '600x': imageDetailsSchema.optional(),
        '1200x': imageDetailsSchema.optional(),
      })
      .optional(),
    cover_image_url: z.string().optional(),
    video_url: z.string().optional().nullable(),
    duration: z.number().optional(),
    height: z.number().optional(),
    width: z.number().optional(),
  })
  .and(pinMediaSchema);

export const pinMediaWithVideosSchema = z
  .object({
    items: z.array(videoMetadataSchema).optional(),
  })
  .and(pinMediaSchema);

export const pinUpdateSchema = z
  .object({
    alt_text: z.string().optional().nullable(),
    board_id: z.string().optional().nullable(),
    board_section_id: z.string().optional().nullable(),
    description: z.string().optional().nullable(),
    link: z.string().optional().nullable(),
    title: z.string().optional().nullable(),
    carousel_slots: z
      .array(
        z.object({
          title: z.string().optional(),
          description: z.string().optional(),
          link: z.string().optional(),
        }),
      )
      .optional(),
    note: z.string().optional().nullable(),
  })
  .nullable();

export const productGroupAnalyticsResponseSchema = z.array(
  z.record(z.union([z.unknown(), z.string()])).and(
    z.object({
      PRODUCT_GROUP_ID: z.string(),
      DATE: z.string().optional(),
    }),
  ),
);

export const productGroupPromotionSchema = z.object({
  id: z.string().optional(),
  ad_group_id: z.string().optional(),
  bid_in_micro_currency: z.number().optional().nullable(),
  included: z.boolean().optional().nullable(),
  definition: z.string().optional().nullable(),
  relative_definition: z.string().optional().nullable(),
  parent_id: z.string().optional().nullable(),
  slideshow_collections_title: z.string().optional().nullable(),
  slideshow_collections_description: z.string().optional().nullable(),
  is_mdl: z.boolean().optional().nullable(),
  status: entityStatusSchema.optional(),
  tracking_url: z.string().optional().nullable(),
  catalog_product_group_id: z.string().optional().nullable(),
  catalog_product_group_name: z.string().optional().nullable(),
  collections_hero_pin_id: z.string().optional().nullable(),
  collections_hero_destination_url: z.string().optional().nullable(),
  grid_click_type: gridClickTypeSchema.optional(),
});

export const productGroupPromotionCreateRequestElementSchema = productGroupPromotionSchema.and(
  z.object({
    creative_type: creativeTypeSchema.optional(),
  }),
);

export const productGroupPromotionResponseElementSchema = productGroupPromotionSchema.and(
  z.object({
    creative_type: creativeTypeSchema.optional(),
  }),
);

export const productGroupPromotionResponseItemSchema = z.object({
  data: productGroupPromotionResponseElementSchema.optional(),
  exceptions: z.unknown().optional(),
});

export const productGroupPromotionUpdateRequestSchema = z.object({
  ad_group_id: z.string(),
  product_group_promotion: z.array(productGroupPromotionSchema),
});

export const productType0FilterSchema = z.object({
  PRODUCT_TYPE_0: catalogsProductGroupMultipleStringListCriteriaSchema,
});

export const productType1FilterSchema = z.object({
  PRODUCT_TYPE_1: catalogsProductGroupMultipleStringListCriteriaSchema,
});

export const productType2FilterSchema = z.object({
  PRODUCT_TYPE_2: catalogsProductGroupMultipleStringListCriteriaSchema,
});

export const productType3FilterSchema = z.object({
  PRODUCT_TYPE_3: catalogsProductGroupMultipleStringListCriteriaSchema,
});

export const productType4FilterSchema = z.object({
  PRODUCT_TYPE_4: catalogsProductGroupMultipleStringListCriteriaSchema,
});

export const quizPinResultSchema = z
  .object({
    organic_pin_id: z.string().optional(),
    android_deep_link: z.string().optional(),
    ios_deep_link: z.string().optional(),
    destination_url: z.string().optional(),
    result_id: z.number().optional(),
  })
  .nullable();

export const tieBreakerTypeSchema = z.union([z.literal('RANDOM'), z.literal('CUSTOM')]);

export const quizPinOptionSchema = z
  .object({
    id: z.number().optional(),
    text: z.string().optional(),
  })
  .nullable();

export const quizPinQuestionSchema = z
  .object({
    question_id: z.number().optional(),
    question_text: z.string().optional(),
    options: z.array(quizPinOptionSchema).optional(),
  })
  .nullable();

export const relatedTermsSchema = z.object({
  id: z.string().optional(),
  related_term_count: z.number().optional(),
  related_terms_list: z
    .array(
      z.object({
        term: z.string().optional(),
        related_terms: z.array(z.string()).optional(),
      }),
    )
    .optional(),
});

export const resourceIdToRolesSchema = z.string();

export const respondToInvitesResponseArraySchema = z.object({
  items: z
    .array(
      z.object({
        exception: inviteExceptionResponseSchema.optional(),
        invite: baseInviteDataResponseSchema.optional(),
      }),
    )
    .optional(),
});

export const roleSchema = z.union([
  z.literal('UNKNOWN'),
  z.literal('OWNER'),
  z.literal('ADMIN'),
  z.literal('ANALYST'),
  z.literal('SOS_READER'),
  z.literal('FINANCE_MANAGER'),
  z.literal('AUDIENCE_MANAGER'),
  z.literal('CAMPAIGN_MANAGER'),
  z.literal('CATALOGS_MANAGER'),
  z.literal('RESTRICTED_OWNER'),
  z.literal('PROFILE_MANAGER'),
  z.literal('PROFILE_PUBLISHER'),
  z.literal('RESOURCE_PINNER_LIST_OWNER'),
  z.literal('RESOURCE_PINNER_LIST_READER'),
  z.literal('BIZ_PINNER_LIST_SHARER'),
  z.literal('RESOURCE_CONVERSION_TAGS_READER'),
]);

export const sSIOAccountAddressSchema = z.object({
  display: z.string().optional(),
  purpose: z.string().optional(),
  address_id: z.string().optional(),
  order_legal_entity: z.string().optional(),
});

export const sSIOAccountItemSchema = z.object({
  id: z.string().optional(),
  io_terms_id: z.string().optional(),
  io_terms: z.string().optional(),
  us_terms_id: z.string().optional(),
  us_terms: z.string().optional(),
  row_terms_id: z.string().optional(),
  row_terms: z.string().optional(),
  io_type: z.string().optional(),
  addresses: z.array(sSIOAccountAddressSchema).optional(),
});

export const sSIOAccountPMPNameSchema = z.object({
  name: z.string().optional(),
  id: z.string().optional(),
});

export const sSIOAccountResponseSchema = z.object({
  eligible: z.boolean().optional(),
  can_edit: z.boolean().optional(),
  billto_infos: z.array(sSIOAccountItemSchema).optional(),
  currency: z.string().optional(),
  pmp_names: z.array(sSIOAccountPMPNameSchema).optional(),
  error: z.string().optional(),
});

export const sSIOInsertionOrderCommonSchema = z.object({
  start_date: z.string().optional(),
  end_date: z.string().optional(),
  po_number: z.string().optional(),
  budget_amount: z.number().optional(),
  billing_contact_firstname: z.string().optional(),
  billing_contact_lastname: z.string().optional(),
  billing_contact_email: z.string().optional(),
  media_contact_firstname: z.string().optional(),
  media_contact_lastname: z.string().optional(),
  media_contact_email: z.string().optional(),
  agency_link: z.string().optional(),
  user_email: z.string().optional(),
});

export const orderLineTypeSchema = z.union([z.literal('BUDGET'), z.literal('PERPETUALS')]);

export const sSIOCreateInsertionOrderResponseSchema = z.object({
  pin_order_id: z.string().optional(),
});

export const sSIOEditInsertionOrderRequestSchema = sSIOInsertionOrderCommonSchema.and(
  z.object({
    oracle_line_id: z.string().optional(),
    salesforce_order_id: z.string().optional(),
    salesforce_order_line_id: z.string().optional(),
    ads_manager_order_line_id: z.string().optional(),
  }),
);

export const sSIOEditInsertionOrderResponseSchema = z.object({
  pin_order_id: z.string().optional(),
});

export const sSIOInsertionOrderStatusSchema = z.object({
  pin_order_id: z.string().optional(),
  status: z.string().optional(),
  creation_time: z.string().optional().nullable(),
});

export const sSIOInsertionOrderStatusResponseSchema = sSIOInsertionOrderStatusSchema.and(z.record(z.unknown()));

export const sSIOOrderLineSchema = z.object({
  salesforce_order_line_id: z.string().optional().nullable(),
  ads_manager_order_line_id: z.string().optional().nullable(),
  pin_order_id: z.string().optional().nullable(),
  last_modified_date_time: z.string().optional().nullable(),
  start_date: z.string().optional().nullable(),
  end_date: z.string().optional().nullable(),
  bill_to_company_name: z.string().optional().nullable(),
  billing_contact_firstname: z.string().optional().nullable(),
  billing_contact_lastname: z.string().optional().nullable(),
  billing_contact_email: z.string().optional().nullable(),
  media_contact_email: z.string().optional().nullable(),
  media_contact_firstname: z.string().optional().nullable(),
  media_contact_lastname: z.string().optional().nullable(),
  currency_info: currencySchema.optional().nullable(),
  agency_link: z.string().optional().nullable(),
  po_number: z.string().optional().nullable(),
  order_name: z.string().optional().nullable(),
  pmp_name: z.string().optional().nullable(),
  accepted_terms_id: z.string().optional().nullable(),
  accepted_terms_time: z.string().optional().nullable(),
  budget_amount: z.number().optional().nullable(),
  estimated_monthly_spend: z.number().optional().nullable(),
});

export const sharedAudienceAccountSchema = z.object({
  account_id: z.string(),
  account_name: z.string(),
  account_type: z.union([z.literal('AD_ACCOUNT'), z.literal('BUSINESS_ACCOUNT')]),
  shared_on_timestamp: z.number(),
});

export const accountType2Schema = z.union([z.literal('AD_ACCOUNT'), z.literal('BUSINESS_ACCOUNT')]);

export const singleInterestTargetingOptionResponseSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  child_interests: z.array(z.string()).optional(),
  level: z.number().optional(),
});

export const targetingOptionResponseSchema = z.array(z.record(z.unknown())).nullable();

export const targetingTemplateAudienceSizingSchema = z
  .object({
    reach_estimate: z
      .object({
        estimate: z.number().optional(),
        lower_bound: z.number().optional(),
        upper_bound: z.number().optional(),
      })
      .optional(),
  })
  .nullable();

export const targetingTemplateKeywordSchema = z.object({
  match_type: matchTypeSchema.optional(),
  value: z.string().optional(),
});

export const targetingTemplateCommonSchema = z.object({
  name: z.string().optional(),
  auto_targeting_enabled: z.boolean().optional(),
  targeting_attributes: targetingSpecSchema.optional(),
  placement_group: placementGroupTypeSchema.optional(),
  keywords: z.array(targetingTemplateKeywordSchema).optional(),
  tracking_urls: trackingUrlsSchema.optional(),
});

export const targetingTemplateResponseDataSchema = targetingTemplateCommonSchema.and(
  z.object({
    id: z.string().optional(),
    created_time: z.number().optional(),
    updated_time: z.number().optional(),
    ad_account_id: z.string().optional(),
    status: z.union([z.literal('ACTIVE'), z.literal('DELETED')]).optional(),
    sizing: targetingTemplateAudienceSizingSchema.optional(),
  }),
);

export const targetingTemplateUpdateRequestSchema = z.object({
  operation_type: z.literal('REMOVE'),
  id: z.string(),
});

export const operationTypeSchema = z.union([z.literal('SHARE'), z.literal('REVOKE')]);

export const targetingTypeFilterSchema = z.object({
  targeting_types: z.array(adsAnalyticsTargetingTypeSchema).optional(),
});

export const templateResponseSchema = z.object({
  id: z.string().optional(),
  ad_account_id: z.string().optional(),
  ad_account_ids: z.array(z.string()).optional(),
  user_id: z.string().optional(),
  name: z.string().optional().nullable(),
  report_start_relative_days_in_past: z.number().optional(),
  report_end_relative_days_in_past: z.number().optional(),
  date_range: z
    .object({
      dynamic_date_range: z
        .object({
          type: z.string().optional(),
          range: z
            .union([
              z.literal('YEAR_TO_DATE'),
              z.literal('QUARTER_TO_DATE'),
              z.literal('MONTH_TO_DATE'),
              z.literal('LAST_MONTH'),
            ])
            .optional(),
        })
        .optional()
        .nullable(),
      relative_date_range: z
        .object({
          type: z.string().optional(),
          start_days_in_past: z.number().optional(),
          end_days_in_past: z.number().optional(),
        })
        .optional()
        .nullable(),
      absolute_date_range: z
        .object({
          type: z.string().optional(),
          start_date: z.number().optional(),
          end_date: z.number().optional(),
        })
        .optional()
        .nullable(),
    })
    .optional(),
  report_level: metricsReportingLevelSchema.optional(),
  report_format: dataOutputFormatSchema.optional(),
  columns: z
    .array(
      z.union([
        z.literal('SPEND_IN_MICRO_DOLLAR'),
        z.literal('SPEND_IN_MICRO_US_DOLLAR'),
        z.literal('BONUS_SPEND_IN_MICRO_DOLLAR'),
        z.literal('BONUS_SPEND_IN_DOLLAR'),
        z.literal('PAID_IMPRESSION'),
        z.literal('PAID_CLICKTHROUGH'),
        z.literal('SPEND_IN_DOLLAR'),
        z.literal('SPEND_IN_US_DOLLAR'),
        z.literal('CPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_MICRO_DOLLAR'),
        z.literal('CPC_IN_DOLLAR'),
        z.literal('ECPC_IN_DOLLAR'),
        z.literal('CTR'),
        z.literal('ECTR'),
        z.literal('OUTBOUND_CTR'),
        z.literal('CPC_IN_MICRO_CURRENCY'),
        z.literal('CPW_IN_MICRO_DOLLAR'),
        z.literal('CPW_IN_DOLLAR'),
        z.literal('COST_PER_OUTBOUND_CLICK'),
        z.literal('AD_ONLY_PIN'),
        z.literal('CAMPAIGN_NAME'),
        z.literal('CAMPAIGN_STATUS'),
        z.literal('IS_CAMPAIGN_LEARNING_PHASE'),
        z.literal('DATE'),
        z.literal('DATE_AS_TIMESTAMP'),
        z.literal('BUDGET_IN_DOLLAR'),
        z.literal('AVAILABLE_BUDGET_IN_DOLLAR'),
        z.literal('TARGETING_TYPE'),
        z.literal('TARGETING_VALUE'),
        z.literal('TARGETING_VALUE_NAME'),
        z.literal('PAID_EVENTS'),
        z.literal('BONUS_EVENTS'),
        z.literal('INSERTION'),
        z.literal('LEGACY_CAMPAIGN_ID'),
        z.literal('HBASE_ID'),
        z.literal('PIN_DESCRIPTION'),
        z.literal('CAMPAIGN_END_DATE'),
        z.literal('PIN_PROMOTION_STATUS'),
        z.literal('AD_STATUS'),
        z.literal('PIN_ID'),
        z.literal('CROSS_DEVICE_TYPE'),
        z.literal('INGESTION_SOURCE'),
        z.literal('SOURCE_PLATFORM'),
        z.literal('PIN_PROMOTION_IS_RUNNING'),
        z.literal('TOTAL_ENGAGEMENT'),
        z.literal('ENGAGEMENT_1'),
        z.literal('ENGAGEMENT_2'),
        z.literal('CPE_IN_MICRO_DOLLAR'),
        z.literal('ECPE_IN_MICRO_DOLLAR'),
        z.literal('CPE_IN_DOLLAR'),
        z.literal('ECPE_IN_DOLLAR'),
        z.literal('ENGAGEMENT_RATE'),
        z.literal('EENGAGEMENT_RATE'),
        z.literal('INTERNAL_ECPE_IN_MICRO_DOLLAR'),
        z.literal('INTERNAL_ECPE_IN_DOLLAR'),
        z.literal('ECPM_IN_MICRO_DOLLAR'),
        z.literal('ECPM_IN_DOLLAR'),
        z.literal('REPIN_RATE'),
        z.literal('REPIN_RATE_2'),
        z.literal('CTR_2'),
        z.literal('CAMPAIGN_ID'),
        z.literal('ADVERTISER_ID'),
        z.literal('AD_ACCOUNT_ID'),
        z.literal('ADVERTISER_OWNER_USER_ID'),
        z.literal('ADVERTISER_OWNER_USER_NAME'),
        z.literal('PIN_PROMOTION_ID'),
        z.literal('AD_ID'),
        z.literal('AD_GROUP_ID'),
        z.literal('KEYWORD_ID'),
        z.literal('KEYWORD_IS_DELETED'),
        z.literal('BRAND_SFDC_ACCOUNT_ID'),
        z.literal('CAMPAIGN_ACTION_TYPE'),
        z.literal('CAMPAIGN_BID_TYPE'),
        z.literal('CAMPAIGN_ENTITY_STATUS'),
        z.literal('CAMPAIGN_MANAGED_STATUS'),
        z.literal('CAMPAIGN_OBJECTIVE_TYPE'),
        z.literal('CPM_IN_MICRO_DOLLAR'),
        z.literal('CPM_IN_DOLLAR'),
        z.literal('BUDGET_TYPE'),
        z.literal('BUDGET_IN_LOCAL_CURRENCY'),
        z.literal('AD_GROUP_NAME'),
        z.literal('AD_GROUP_STATUS'),
        z.literal('AD_GROUP_END_DATE'),
        z.literal('AD_GROUP_BUDGET_TYPE'),
        z.literal('AD_GROUP_BUDGET_IN_LOCAL_CURRENCY'),
        z.literal('AD_GROUP_SUGGESTED_BUDGET_IN_LOCAL_CURRENCY'),
        z.literal('AD_GROUP_SUGGESTED_BONUS_BUDGET_IN_LOCAL_CURRENCY'),
        z.literal('AD_GROUP_ENTITY_STATUS'),
        z.literal('AD_GROUP_ACTION_TYPE'),
        z.literal('AD_GROUP_CONVERSION_LEARNING_MODE_TYPE'),
        z.literal('AD_GROUP_TARGET_CPA'),
        z.literal('AD_GROUP_BID_STRATEGY_TYPE'),
        z.literal('AD_GROUP_EXPERIMENT_NAME'),
        z.literal('AD_GROUP_EXPERIMENT_CELL'),
        z.literal('CAMPAIGN_WEB_CLOSEUP_WHITELISTED'),
        z.literal('PRODUCT_GROUP_ID'),
        z.literal('PRODUCT_GROUP_DEFINITION'),
        z.literal('PARENT_PRODUCT_GROUP_ID'),
        z.literal('PRODUCT_GROUP_TYPE'),
        z.literal('PRODUCT_GROUP_BID_IN_MICRO_CURRENCY'),
        z.literal('PRODUCT_GROUP_STATUS'),
        z.literal('PRODUCT_GROUP_ENTITY_STATUS'),
        z.literal('PRODUCT_GROUP_INCLUSION'),
        z.literal('PRODUCT_GROUP_CREATIVE_TYPE'),
        z.literal('ITEM_ID'),
        z.literal('PRODUCT_ITEM_ID'),
        z.literal('INTERNAL_PRODUCT_ITEM_ID'),
        z.literal('INTERNAL_PRODUCT_ITEM_ID_STR'),
        z.literal('PRODUCT_ITEM_NAME'),
        z.literal('PRODUCT_ITEM_IMAGE_URL'),
        z.literal('PRODUCT_ITEM_PRICE'),
        z.literal('ORDER_LINE_ID'),
        z.literal('ORDER_LINE_NAME'),
        z.literal('ORDER_LINE_PIN_REV_SHARE'),
        z.literal('ORDER_LINE_PAID_TYPE'),
        z.literal('SPEND_ORDER_LINE_ID'),
        z.literal('SPEND_ORDER_LINE_PAID_TYPE'),
        z.literal('CONVERSION_PRODUCT_ID'),
        z.literal('CONVERSION_PRODUCT_NAME'),
        z.literal('CONVERSION_PRODUCT_BRAND'),
        z.literal('CONVERSION_PRODUCT_CATEGORY'),
        z.literal('CLICKTHROUGH_1'),
        z.literal('REPIN_1'),
        z.literal('IMPRESSION_1'),
        z.literal('LIKE_1'),
        z.literal('SEND_1'),
        z.literal('FLAG_1'),
        z.literal('HIDE_1'),
        z.literal('INSERTION_1'),
        z.literal('IMPRESSION_1_GROSS'),
        z.literal('CLICKTHROUGH_1_GROSS'),
        z.literal('OUTBOUND_CLICK_1'),
        z.literal('CLICKTHROUGH_USER_1'),
        z.literal('REPIN_USER_1'),
        z.literal('IMPRESSION_USER_1'),
        z.literal('LIKE_USER_1'),
        z.literal('SEND_USER_1'),
        z.literal('FLAG_USER_1'),
        z.literal('HIDE_USER_1'),
        z.literal('INSERTION_USER_1'),
        z.literal('CLICKTHROUGH_2'),
        z.literal('REPIN_2'),
        z.literal('IMPRESSION_2'),
        z.literal('LIKE_2'),
        z.literal('SEND_2'),
        z.literal('FLAG_2'),
        z.literal('OUTBOUND_CLICK_2'),
        z.literal('CLICKTHROUGH_USER_2'),
        z.literal('REPIN_USER_2'),
        z.literal('IMPRESSION_USER_2'),
        z.literal('LIKE_USER_2'),
        z.literal('SEND_USER_2'),
        z.literal('FLAG_USER_2'),
        z.literal('TOTAL_CLICKTHROUGH'),
        z.literal('TOTAL_REPIN'),
        z.literal('TOTAL_IMPRESSION'),
        z.literal('TOTAL_LIKE'),
        z.literal('TOTAL_SEND'),
        z.literal('TOTAL_FLAG'),
        z.literal('TOTAL_IMPRESSION_USER'),
        z.literal('TOTAL_IMPRESSION_USER_HLL'),
        z.literal('TOTAL_IMPRESSION_FREQUENCY'),
        z.literal('TOTAL_IMPRESSION_FREQUENCY_HLL'),
        z.literal('TOTAL_OUTBOUND_CLICK'),
        z.literal('COST_PER_OUTBOUND_CLICK_IN_DOLLAR'),
        z.literal('ENGAGEMENT_PAGE_VISIT_1'),
        z.literal('ENGAGEMENT_SIGNUP_1'),
        z.literal('ENGAGEMENT_CHECKOUT_1'),
        z.literal('ENGAGEMENT_CUSTOM_1'),
        z.literal('ENGAGEMENT_ADD_TO_CART_1'),
        z.literal('ENGAGEMENT_LEAD_1'),
        z.literal('ENGAGEMENT_SEARCH_1'),
        z.literal('ENGAGEMENT_WATCH_VIDEO_1'),
        z.literal('ENGAGEMENT_VIEW_CATEGORY_1'),
        z.literal('ENGAGEMENT_APP_INSTALL_1'),
        z.literal('ENGAGEMENT_UNKNOWN_1'),
        z.literal('CLICK_PAGE_VISIT_1'),
        z.literal('CLICK_SIGNUP_1'),
        z.literal('CLICK_CHECKOUT_1'),
        z.literal('CLICK_CUSTOM_1'),
        z.literal('CLICK_ADD_TO_CART_1'),
        z.literal('CLICK_LEAD_1'),
        z.literal('CLICK_SEARCH_1'),
        z.literal('CLICK_WATCH_VIDEO_1'),
        z.literal('CLICK_VIEW_CATEGORY_1'),
        z.literal('CLICK_APP_INSTALL_1'),
        z.literal('CLICK_UNKNOWN_1'),
        z.literal('VIEW_PAGE_VISIT_1'),
        z.literal('VIEW_SIGNUP_1'),
        z.literal('VIEW_CHECKOUT_1'),
        z.literal('VIEW_CUSTOM_1'),
        z.literal('VIEW_ADD_TO_CART_1'),
        z.literal('VIEW_LEAD_1'),
        z.literal('VIEW_SEARCH_1'),
        z.literal('VIEW_WATCH_VIDEO_1'),
        z.literal('VIEW_VIEW_CATEGORY_1'),
        z.literal('VIEW_APP_INSTALL_1'),
        z.literal('VIEW_UNKNOWN_1'),
        z.literal('CONVERSIONS_1'),
        z.literal('ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('CLICK_LEAD_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('VIEW_LEAD_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('CONVERSIONS_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('ENGAGEMENT_PAGE_VISIT_QUANTITY_1'),
        z.literal('ENGAGEMENT_SIGNUP_QUANTITY_1'),
        z.literal('ENGAGEMENT_CHECKOUT_QUANTITY_1'),
        z.literal('ENGAGEMENT_CUSTOM_QUANTITY_1'),
        z.literal('ENGAGEMENT_ADD_TO_CART_QUANTITY_1'),
        z.literal('ENGAGEMENT_LEAD_QUANTITY_1'),
        z.literal('ENGAGEMENT_SEARCH_QUANTITY_1'),
        z.literal('ENGAGEMENT_WATCH_VIDEO_QUANTITY_1'),
        z.literal('ENGAGEMENT_VIEW_CATEGORY_QUANTITY_1'),
        z.literal('ENGAGEMENT_APP_INSTALL_QUANTITY_1'),
        z.literal('ENGAGEMENT_UNKNOWN_QUANTITY_1'),
        z.literal('CLICK_PAGE_VISIT_QUANTITY_1'),
        z.literal('CLICK_SIGNUP_QUANTITY_1'),
        z.literal('CLICK_CHECKOUT_QUANTITY_1'),
        z.literal('CLICK_CUSTOM_QUANTITY_1'),
        z.literal('CLICK_ADD_TO_CART_QUANTITY_1'),
        z.literal('CLICK_LEAD_QUANTITY_1'),
        z.literal('CLICK_SEARCH_QUANTITY_1'),
        z.literal('CLICK_WATCH_VIDEO_QUANTITY_1'),
        z.literal('CLICK_VIEW_CATEGORY_QUANTITY_1'),
        z.literal('CLICK_APP_INSTALL_QUANTITY_1'),
        z.literal('CLICK_UNKNOWN_QUANTITY_1'),
        z.literal('VIEW_PAGE_VISIT_QUANTITY_1'),
        z.literal('VIEW_SIGNUP_QUANTITY_1'),
        z.literal('VIEW_CHECKOUT_QUANTITY_1'),
        z.literal('VIEW_CUSTOM_QUANTITY_1'),
        z.literal('VIEW_ADD_TO_CART_QUANTITY_1'),
        z.literal('VIEW_LEAD_QUANTITY_1'),
        z.literal('VIEW_SEARCH_QUANTITY_1'),
        z.literal('VIEW_WATCH_VIDEO_QUANTITY_1'),
        z.literal('VIEW_VIEW_CATEGORY_QUANTITY_1'),
        z.literal('VIEW_APP_INSTALL_QUANTITY_1'),
        z.literal('VIEW_UNKNOWN_QUANTITY_1'),
        z.literal('CONVERSIONS_QUANTITY_1'),
        z.literal('ENGAGEMENT_PAGE_VISIT_2'),
        z.literal('ENGAGEMENT_SIGNUP_2'),
        z.literal('ENGAGEMENT_CHECKOUT_2'),
        z.literal('ENGAGEMENT_CUSTOM_2'),
        z.literal('ENGAGEMENT_ADD_TO_CART_2'),
        z.literal('ENGAGEMENT_LEAD_2'),
        z.literal('ENGAGEMENT_SEARCH_2'),
        z.literal('ENGAGEMENT_WATCH_VIDEO_2'),
        z.literal('ENGAGEMENT_VIEW_CATEGORY_2'),
        z.literal('ENGAGEMENT_APP_INSTALL_2'),
        z.literal('ENGAGEMENT_UNKNOWN_2'),
        z.literal('CLICK_PAGE_VISIT_2'),
        z.literal('CLICK_SIGNUP_2'),
        z.literal('CLICK_CHECKOUT_2'),
        z.literal('CLICK_CUSTOM_2'),
        z.literal('CLICK_ADD_TO_CART_2'),
        z.literal('CLICK_LEAD_2'),
        z.literal('CLICK_SEARCH_2'),
        z.literal('CLICK_WATCH_VIDEO_2'),
        z.literal('CLICK_VIEW_CATEGORY_2'),
        z.literal('CLICK_APP_INSTALL_2'),
        z.literal('CLICK_UNKNOWN_2'),
        z.literal('VIEW_PAGE_VISIT_2'),
        z.literal('VIEW_SIGNUP_2'),
        z.literal('VIEW_CHECKOUT_2'),
        z.literal('VIEW_CUSTOM_2'),
        z.literal('VIEW_ADD_TO_CART_2'),
        z.literal('VIEW_LEAD_2'),
        z.literal('VIEW_SEARCH_2'),
        z.literal('VIEW_WATCH_VIDEO_2'),
        z.literal('VIEW_VIEW_CATEGORY_2'),
        z.literal('VIEW_APP_INSTALL_2'),
        z.literal('VIEW_UNKNOWN_2'),
        z.literal('CONVERSIONS_2'),
        z.literal('ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CLICK_LEAD_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('VIEW_LEAD_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CONVERSIONS_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('ENGAGEMENT_PAGE_VISIT_QUANTITY_2'),
        z.literal('ENGAGEMENT_SIGNUP_QUANTITY_2'),
        z.literal('ENGAGEMENT_CHECKOUT_QUANTITY_2'),
        z.literal('ENGAGEMENT_CUSTOM_QUANTITY_2'),
        z.literal('ENGAGEMENT_ADD_TO_CART_QUANTITY_2'),
        z.literal('ENGAGEMENT_LEAD_QUANTITY_2'),
        z.literal('ENGAGEMENT_SEARCH_QUANTITY_2'),
        z.literal('ENGAGEMENT_WATCH_VIDEO_QUANTITY_2'),
        z.literal('ENGAGEMENT_VIEW_CATEGORY_QUANTITY_2'),
        z.literal('ENGAGEMENT_APP_INSTALL_QUANTITY_2'),
        z.literal('ENGAGEMENT_UNKNOWN_QUANTITY_2'),
        z.literal('CLICK_PAGE_VISIT_QUANTITY_2'),
        z.literal('CLICK_SIGNUP_QUANTITY_2'),
        z.literal('CLICK_CHECKOUT_QUANTITY_2'),
        z.literal('CLICK_CUSTOM_QUANTITY_2'),
        z.literal('CLICK_ADD_TO_CART_QUANTITY_2'),
        z.literal('CLICK_LEAD_QUANTITY_2'),
        z.literal('CLICK_SEARCH_QUANTITY_2'),
        z.literal('CLICK_WATCH_VIDEO_QUANTITY_2'),
        z.literal('CLICK_VIEW_CATEGORY_QUANTITY_2'),
        z.literal('CLICK_APP_INSTALL_QUANTITY_2'),
        z.literal('CLICK_UNKNOWN_QUANTITY_2'),
        z.literal('VIEW_PAGE_VISIT_QUANTITY_2'),
        z.literal('VIEW_SIGNUP_QUANTITY_2'),
        z.literal('VIEW_CHECKOUT_QUANTITY_2'),
        z.literal('VIEW_CUSTOM_QUANTITY_2'),
        z.literal('VIEW_ADD_TO_CART_QUANTITY_2'),
        z.literal('VIEW_LEAD_QUANTITY_2'),
        z.literal('VIEW_SEARCH_QUANTITY_2'),
        z.literal('VIEW_WATCH_VIDEO_QUANTITY_2'),
        z.literal('VIEW_VIEW_CATEGORY_QUANTITY_2'),
        z.literal('VIEW_APP_INSTALL_QUANTITY_2'),
        z.literal('VIEW_UNKNOWN_QUANTITY_2'),
        z.literal('CONVERSIONS_QUANTITY_2'),
        z.literal('TOTAL_ENGAGEMENT_PAGE_VISIT'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_ENGAGEMENT_CUSTOM'),
        z.literal('TOTAL_ENGAGEMENT_ADD_TO_CART'),
        z.literal('TOTAL_ENGAGEMENT_LEAD'),
        z.literal('TOTAL_ENGAGEMENT_SEARCH'),
        z.literal('TOTAL_ENGAGEMENT_WATCH_VIDEO'),
        z.literal('TOTAL_ENGAGEMENT_VIEW_CATEGORY'),
        z.literal('TOTAL_ENGAGEMENT_APP_INSTALL'),
        z.literal('TOTAL_ENGAGEMENT_UNKNOWN'),
        z.literal('TOTAL_CLICK_PAGE_VISIT'),
        z.literal('TOTAL_CLICK_SIGNUP'),
        z.literal('TOTAL_CLICK_CHECKOUT'),
        z.literal('TOTAL_CLICK_CUSTOM'),
        z.literal('TOTAL_CLICK_ADD_TO_CART'),
        z.literal('TOTAL_CLICK_LEAD'),
        z.literal('TOTAL_CLICK_SEARCH'),
        z.literal('TOTAL_CLICK_WATCH_VIDEO'),
        z.literal('TOTAL_CLICK_VIEW_CATEGORY'),
        z.literal('TOTAL_CLICK_APP_INSTALL'),
        z.literal('TOTAL_CLICK_UNKNOWN'),
        z.literal('TOTAL_VIEW_PAGE_VISIT'),
        z.literal('TOTAL_VIEW_SIGNUP'),
        z.literal('TOTAL_VIEW_CHECKOUT'),
        z.literal('TOTAL_VIEW_CUSTOM'),
        z.literal('TOTAL_VIEW_ADD_TO_CART'),
        z.literal('TOTAL_VIEW_LEAD'),
        z.literal('TOTAL_VIEW_SEARCH'),
        z.literal('TOTAL_VIEW_WATCH_VIDEO'),
        z.literal('TOTAL_VIEW_VIEW_CATEGORY'),
        z.literal('TOTAL_VIEW_APP_INSTALL'),
        z.literal('TOTAL_VIEW_UNKNOWN'),
        z.literal('TOTAL_CONVERSIONS'),
        z.literal('TOTAL_WEB_CONVERSIONS'),
        z.literal('TOTAL_INAPP_CONVERSIONS'),
        z.literal('TOTAL_OFFLINE_CONVERSIONS'),
        z.literal('TOTAL_ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_PAGE_VISIT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CUSTOM_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_ADD_TO_CART_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_LEAD_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SEARCH_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_PAGE_VISIT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_CUSTOM_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_ADD_TO_CART_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_LEAD_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_SEARCH_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_WATCH_VIDEO_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_VIEW_CATEGORY_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_PAGE_VISIT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_CUSTOM_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_ADD_TO_CART_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_LEAD_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_SEARCH_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_WATCH_VIDEO_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_VIEW_CATEGORY_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CONVERSIONS_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CONVERSIONS_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_PAGE_VISIT_QUANTITY'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP_QUANTITY'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT_QUANTITY'),
        z.literal('TOTAL_ENGAGEMENT_CUSTOM_QUANTITY'),
        z.literal('TOTAL_ENGAGEMENT_ADD_TO_CART_QUANTITY'),
        z.literal('TOTAL_ENGAGEMENT_LEAD_QUANTITY'),
        z.literal('TOTAL_ENGAGEMENT_SEARCH_QUANTITY'),
        z.literal('TOTAL_ENGAGEMENT_WATCH_VIDEO_QUANTITY'),
        z.literal('TOTAL_ENGAGEMENT_VIEW_CATEGORY_QUANTITY'),
        z.literal('TOTAL_ENGAGEMENT_APP_INSTALL_QUANTITY'),
        z.literal('TOTAL_ENGAGEMENT_UNKNOWN_QUANTITY'),
        z.literal('TOTAL_CLICK_PAGE_VISIT_QUANTITY'),
        z.literal('TOTAL_CLICK_SIGNUP_QUANTITY'),
        z.literal('TOTAL_CLICK_CHECKOUT_QUANTITY'),
        z.literal('TOTAL_CLICK_CUSTOM_QUANTITY'),
        z.literal('TOTAL_CLICK_ADD_TO_CART_QUANTITY'),
        z.literal('TOTAL_CLICK_LEAD_QUANTITY'),
        z.literal('TOTAL_CLICK_SEARCH_QUANTITY'),
        z.literal('TOTAL_CLICK_WATCH_VIDEO_QUANTITY'),
        z.literal('TOTAL_CLICK_VIEW_CATEGORY_QUANTITY'),
        z.literal('TOTAL_CLICK_APP_INSTALL_QUANTITY'),
        z.literal('TOTAL_CLICK_UNKNOWN_QUANTITY'),
        z.literal('TOTAL_VIEW_PAGE_VISIT_QUANTITY'),
        z.literal('TOTAL_VIEW_SIGNUP_QUANTITY'),
        z.literal('TOTAL_VIEW_CHECKOUT_QUANTITY'),
        z.literal('TOTAL_VIEW_CUSTOM_QUANTITY'),
        z.literal('TOTAL_VIEW_ADD_TO_CART_QUANTITY'),
        z.literal('TOTAL_VIEW_LEAD_QUANTITY'),
        z.literal('TOTAL_VIEW_SEARCH_QUANTITY'),
        z.literal('TOTAL_VIEW_WATCH_VIDEO_QUANTITY'),
        z.literal('TOTAL_VIEW_VIEW_CATEGORY_QUANTITY'),
        z.literal('TOTAL_VIEW_APP_INSTALL_QUANTITY'),
        z.literal('TOTAL_VIEW_UNKNOWN_QUANTITY'),
        z.literal('TOTAL_CONVERSIONS_QUANTITY'),
        z.literal('COST_PER_CONVERSION_IN_DOLLAR'),
        z.literal('TOTAL_WEB_SESSIONS'),
        z.literal('WEB_SESSIONS_1'),
        z.literal('WEB_SESSIONS_2'),
        z.literal('APP_INSTALLS_CPA_BILLABLE'),
        z.literal('APP_INSTALLS_CLICK'),
        z.literal('APP_INSTALLS_CLOSEUPREPIN'),
        z.literal('APP_INSTALLS_VIEW'),
        z.literal('APP_INSTALLS'),
        z.literal('APP_INSTALLS_ENGAGEMENT'),
        z.literal('APP_INSTALLS_CLICK_1'),
        z.literal('APP_INSTALLS_CLICK_2'),
        z.literal('APP_INSTALLS_VIEW_1'),
        z.literal('APP_INSTALLS_VIEW_2'),
        z.literal('APP_INSTALLS_ENGAGEMENT_1'),
        z.literal('APP_INSTALLS_ENGAGEMENT_2'),
        z.literal('APP_INSTALLS_1'),
        z.literal('APP_INSTALLS_2'),
        z.literal('CPI_IN_MICRO_DOLLAR'),
        z.literal('ECPI_IN_MICRO_DOLLAR'),
        z.literal('CPI_IN_DOLLAR'),
        z.literal('ECPI_IN_DOLLAR'),
        z.literal('ONSITE_CHECKOUTS_CPA_BILLABLE_1'),
        z.literal('ONSITE_CHECKOUTS_CPA_BILLABLE_2'),
        z.literal('ONSITE_CHECKOUTS_CPA_BILLABLE'),
        z.literal('ONSITE_CHECKOUTS_VALUE_1'),
        z.literal('ONSITE_CHECKOUTS_VALUE_2'),
        z.literal('ONSITE_CHECKOUTS_VALUE'),
        z.literal('ONSITE_CHECKOUTS_1'),
        z.literal('ONSITE_CHECKOUTS_2'),
        z.literal('ONSITE_CHECKOUTS'),
        z.literal('ONSITE_CHECKOUTS_VALUE_IN_MICRO_DOLLAR_1'),
        z.literal('ONSITE_CHECKOUTS_VALUE_IN_MICRO_DOLLAR_2'),
        z.literal('CONVERSION_RATE'),
        z.literal('AVERAGE_CHECKOUT_VALUE'),
        z.literal('RETURN_ON_ADVERTISER_SPEND'),
        z.literal('BUY_BUTTON_CLICKS_1'),
        z.literal('BUY_BUTTON_CLICKS_2'),
        z.literal('TOTAL_BUY_BUTTON_CLICKS'),
        z.literal('ORDER_DROPOFF_RATE'),
        z.literal('ONSITE_CHECKOUTS_VALUE_IN_MICRO_DOLLAR'),
        z.literal('ONSITE_CHECKOUTS_VALUE_IN_DOLLAR'),
        z.literal('PIN_PROMOTION_NAME'),
        z.literal('AD_NAME'),
        z.literal('LIFETIME_IMPRESSION_USER_1'),
        z.literal('PIN_PROMOTION_CAMPAIGN_ID'),
        z.literal('PIN_PROMOTION_CAMPAIGN_NAME'),
        z.literal('PIN_PROMOTION_CAMPAIGN_ACTION_TYPE'),
        z.literal('TOTAL_LIFETIME_IMPRESSION_USER'),
        z.literal('PIN_PROMOTION_CAMPAIGN_STATUS'),
        z.literal('PIN_PROMOTION_CAMPAIGN_MANAGED_STATUS'),
        z.literal('PIN_PROMOTION_CAMPAIGN_ENTITY_STATUS'),
        z.literal('PIN_PROMOTION_AD_GROUP_ID'),
        z.literal('PIN_PROMOTION_AD_GROUP_NAME'),
        z.literal('PIN_PROMOTION_AD_GROUP_STATUS'),
        z.literal('PIN_PROMOTION_AD_GROUP_ENTITY_STATUS'),
        z.literal('PIN_PROMOTION_CREATIVE_TYPE'),
        z.literal('PIN_PROMOTION_ENTITY_STATUS'),
        z.literal('PIN_PROMOTION_CREATIVE_TYPE_V2'),
        z.literal('PIN_PROMOTION_REVIEW_STATUS'),
        z.literal('AD_GROUP_CAMPAIGN_ACTION_TYPE'),
        z.literal('AD_GROUP_CAMPAIGN_ID'),
        z.literal('AD_GROUP_CAMPAIGN_NAME'),
        z.literal('AD_GROUP_CAMPAIGN_STATUS'),
        z.literal('AD_GROUP_CREATIVE_TYPE'),
        z.literal('AD_GROUP_CAMPAIGN_MANAGED_STATUS'),
        z.literal('AD_GROUP_CAMPAIGN_ENTITY_STATUS'),
        z.literal('AD_GROUP_START_DATE'),
        z.literal('CAMPAIGN_LIFETIME_SPEND_CAP'),
        z.literal('AD_GROUP_BID_IN_MICRO_CURRENCY'),
        z.literal('CAMPAIGN_AD_GROUP_START_DATE'),
        z.literal('CAMPAIGN_AD_GROUP_END_DATE'),
        z.literal('CAMPAIGN_NUMBER_OF_AD_GROUPS'),
        z.literal('AD_GROUP_NUMBER_OF_PIN_PROMOTIONS'),
        z.literal('TODAY_SPEND_IN_LOCAL_CURRENCY'),
        z.literal('TOTAL_LIFETIME_SPEND_IN_LOCAL_CURRENCY'),
        z.literal('BUDGET_UTILIZATION'),
        z.literal('AD_GROUP_OPTIMIZATION'),
        z.literal('INSERTION_ORDER'),
        z.literal('AD_GROUP_BONUS_BUDGET'),
        z.literal('FREQUENCY'),
        z.literal('CAMPAIGN_DAILY_SPEND_CAP'),
        z.literal('CAMPAIGN_CREATIVE_TYPE'),
        z.literal('AD_GROUP_PLACEMENT_GROUP_TYPE'),
        z.literal('AD_GROUP_IS_PREFETCH_ENABLED'),
        z.literal('CAMPAIGN_BUDGET_OPTIMIZATION'),
        z.literal('CAMPAIGN_START_DATE'),
        z.literal('IS_AUTOMATED_CAMPAIGN'),
        z.literal('IS_PREMIERE_CAMPAIGN'),
        z.literal('FLEXIBLE_DAILY_BUDGETS'),
        z.literal('IS_PERFORMANCE_PLUS_CAMPAIGN'),
        z.literal('IS_DCO_FORMAT_ENHANCMENT'),
        z.literal('PERCENT_CROSS_DEVICE_CONVERSIONS'),
        z.literal('PAGE_VISIT_PERCENT_CROSS_DEVICE_CONVERSIONS'),
        z.literal('SIGNUP_PERCENT_CROSS_DEVICE_CONVERSIONS'),
        z.literal('CHECKOUT_PERCENT_CROSS_DEVICE_CONVERSIONS'),
        z.literal('CUSTOM_PERCENT_CROSS_DEVICE_CONVERSIONS'),
        z.literal('ADD_TO_CART_PERCENT_CROSS_DEVICE_CONVERSIONS'),
        z.literal('LEAD_PERCENT_CROSS_DEVICE_CONVERSIONS'),
        z.literal('SEARCH_PERCENT_CROSS_DEVICE_CONVERSIONS'),
        z.literal('WATCH_VIDEO_PERCENT_CROSS_DEVICE_CONVERSIONS'),
        z.literal('VIEW_CATEGORY_PERCENT_CROSS_DEVICE_CONVERSIONS'),
        z.literal('APP_INSTALL_PERCENT_CROSS_DEVICE_CONVERSIONS'),
        z.literal('UNKNOWN_PERCENT_CROSS_DEVICE_CONVERSIONS'),
        z.literal('TOTAL_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_MOBILE_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_TABLET_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_TABLET_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_PAGE_VISIT_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_PAGE_VISIT_TABLET_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_PAGE_VISIT_TABLET_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_SIGNUP_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_SIGNUP_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_SIGNUP_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_SIGNUP_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_SIGNUP_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_SIGNUP_MOBILE_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_SIGNUP_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_SIGNUP_TABLET_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_SIGNUP_TABLET_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_CHECKOUT_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_CHECKOUT_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_CHECKOUT_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_CHECKOUT_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_CHECKOUT_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_CHECKOUT_MOBILE_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_CHECKOUT_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_CHECKOUT_TABLET_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_CHECKOUT_TABLET_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_CUSTOM_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_CUSTOM_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_CUSTOM_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_CUSTOM_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_CUSTOM_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_CUSTOM_MOBILE_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_CUSTOM_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_CUSTOM_TABLET_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_CUSTOM_TABLET_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_ADD_TO_CART_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_ADD_TO_CART_TABLET_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_ADD_TO_CART_TABLET_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_LEAD_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_LEAD_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_LEAD_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_LEAD_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_LEAD_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_LEAD_MOBILE_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_LEAD_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_LEAD_TABLET_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_LEAD_TABLET_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_SEARCH_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_SEARCH_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_SEARCH_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_SEARCH_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_SEARCH_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_SEARCH_MOBILE_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_SEARCH_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_SEARCH_TABLET_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_SEARCH_TABLET_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_APP_INSTALL_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_APP_INSTALL_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_APP_INSTALL_MOBILE_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_APP_INSTALL_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_APP_INSTALL_TABLET_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_APP_INSTALL_TABLET_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_UNKNOWN_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_UNKNOWN_DESKTOP_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_UNKNOWN_DESKTOP_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_UNKNOWN_MOBILE_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_UNKNOWN_MOBILE_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_UNKNOWN_MOBILE_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_UNKNOWN_TABLET_ACTION_TO_DESKTOP_CONVERSION'),
        z.literal('TOTAL_UNKNOWN_TABLET_ACTION_TO_MOBILE_CONVERSION'),
        z.literal('TOTAL_UNKNOWN_TABLET_ACTION_TO_TABLET_CONVERSION'),
        z.literal('TOTAL_PAGE_VISIT'),
        z.literal('TOTAL_SIGNUP'),
        z.literal('TOTAL_CHECKOUT'),
        z.literal('TOTAL_CUSTOM'),
        z.literal('TOTAL_ADD_TO_CART'),
        z.literal('TOTAL_LEAD'),
        z.literal('TOTAL_SEARCH'),
        z.literal('TOTAL_WATCH_VIDEO'),
        z.literal('TOTAL_VIEW_CATEGORY'),
        z.literal('TOTAL_APP_INSTALL'),
        z.literal('TOTAL_UNKNOWN'),
        z.literal('TOTAL_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('AVERAGE_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('AVERAGE_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('AVERAGE_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('AVERAGE_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('AVERAGE_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('AVERAGE_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('AVERAGE_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('AVERAGE_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
        z.literal('AVERAGE_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
        z.literal('AVERAGE_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('AVERAGE_PAGE_VISIT_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('AVERAGE_SIGNUP_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('AVERAGE_CHECKOUT_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('AVERAGE_CUSTOM_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('AVERAGE_ADD_TO_CART_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('AVERAGE_LEAD_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('AVERAGE_SEARCH_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('AVERAGE_WATCH_VIDEO_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('AVERAGE_VIEW_CATEGORY_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('AVERAGE_UNKNOWN_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('TOTAL_PAGE_VISIT_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('TOTAL_ADD_TO_CART_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('TOTAL_LEAD_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('TOTAL_SEARCH_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('TOTAL_WATCH_VIDEO_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('TOTAL_VIEW_CATEGORY_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('TOTAL_UNKNOWN_VALUE_IN_MICRO_US_DOLLAR'),
        z.literal('TOTAL_PAGE_VISIT_QUANTITY'),
        z.literal('TOTAL_SIGNUP_QUANTITY'),
        z.literal('TOTAL_CHECKOUT_QUANTITY'),
        z.literal('TOTAL_CUSTOM_QUANTITY'),
        z.literal('TOTAL_ADD_TO_CART_QUANTITY'),
        z.literal('TOTAL_LEAD_QUANTITY'),
        z.literal('TOTAL_SEARCH_QUANTITY'),
        z.literal('TOTAL_WATCH_VIDEO_QUANTITY'),
        z.literal('TOTAL_VIEW_CATEGORY_QUANTITY'),
        z.literal('TOTAL_APP_INSTALL_QUANTITY'),
        z.literal('TOTAL_UNKNOWN_QUANTITY'),
        z.literal('TOTAL_PAGE_VISIT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_CUSTOM_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_ADD_TO_CART_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_LEAD_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_SEARCH_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WATCH_VIDEO_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_VIEW_CATEGORY_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_APP_INSTALL_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('PAGE_VISIT_COST_PER_ACTION'),
        z.literal('SIGNUP_COST_PER_ACTION'),
        z.literal('CHECKOUT_COST_PER_ACTION'),
        z.literal('CUSTOM_COST_PER_ACTION'),
        z.literal('ADD_TO_CART_COST_PER_ACTION'),
        z.literal('LEAD_COST_PER_ACTION'),
        z.literal('SEARCH_COST_PER_ACTION'),
        z.literal('WATCH_VIDEO_COST_PER_ACTION'),
        z.literal('VIEW_CATEGORY_COST_PER_ACTION'),
        z.literal('APP_INSTALL_COST_PER_ACTION'),
        z.literal('UNKNOWN_COST_PER_ACTION'),
        z.literal('AD_GROUP_CPA_IN_MICRO_CURRENCY'),
        z.literal('PAGE_VISIT_COST_PER_ACTION_IN_US_DOLLAR'),
        z.literal('SIGNUP_COST_PER_ACTION_IN_US_DOLLAR'),
        z.literal('CHECKOUT_COST_PER_ACTION_IN_US_DOLLAR'),
        z.literal('CUSTOM_COST_PER_ACTION_IN_US_DOLLAR'),
        z.literal('ADD_TO_CART_COST_PER_ACTION_IN_US_DOLLAR'),
        z.literal('LEAD_COST_PER_ACTION_IN_US_DOLLAR'),
        z.literal('SEARCH_COST_PER_ACTION_IN_US_DOLLAR'),
        z.literal('WATCH_VIDEO_COST_PER_ACTION_IN_US_DOLLAR'),
        z.literal('VIEW_CATEGORY_COST_PER_ACTION_IN_US_DOLLAR'),
        z.literal('UNKNOWN_COST_PER_ACTION_IN_US_DOLLAR'),
        z.literal('PAGE_VISIT_ROAS'),
        z.literal('SIGNUP_ROAS'),
        z.literal('CHECKOUT_ROAS'),
        z.literal('CUSTOM_ROAS'),
        z.literal('ADD_TO_CART_ROAS'),
        z.literal('LEAD_ROAS'),
        z.literal('SEARCH_ROAS'),
        z.literal('WATCH_VIDEO_ROAS'),
        z.literal('VIEW_CATEGORY_ROAS'),
        z.literal('APP_INSTALL_ROAS'),
        z.literal('UNKNOWN_ROAS'),
        z.literal('ROAS'),
        z.literal('CLICK_ROAS'),
        z.literal('ENGAGEMENT_ROAS'),
        z.literal('VIEW_ROAS'),
        z.literal('HOUR'),
        z.literal('BOARD_ENGAGEMENT'),
        z.literal('BOARD_INSERTION'),
        z.literal('BOARD_IMPRESSION'),
        z.literal('BOARD_FOLLOW'),
        z.literal('BOARD_SEND'),
        z.literal('BOARD_HIDE'),
        z.literal('PRODUCT_GROUP_CAMPAIGN_ID'),
        z.literal('PRODUCT_GROUP_CAMPAIGN_NAME'),
        z.literal('PRODUCT_GROUP_CAMPAIGN_ACTION_TYPE'),
        z.literal('PRODUCT_GROUP_CAMPAIGN_STATUS'),
        z.literal('PRODUCT_GROUP_CAMPAIGN_MANAGED_STATUS'),
        z.literal('PRODUCT_GROUP_AD_GROUP_ID'),
        z.literal('PRODUCT_GROUP_AD_GROUP_NAME'),
        z.literal('PRODUCT_GROUP_AD_GROUP_STATUS'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_REFERENCE_ID'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_REFERENCE_NAME'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_ID'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_BID_IN_MICRO_CURRENCY'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_STATUS'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_ENTITY_STATUS'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_ID'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_NAME'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_ACTION_TYPE'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_STATUS'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_MANAGED_STATUS'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_AD_GROUP_ID'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_AD_GROUP_NAME'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_AD_GROUP_STATUS'),
        z.literal('PROMOTED_CATALOG_PRODUCT_GROUP_TRACKING_TEMPLATE_URL'),
        z.literal('VIDEO_3SEC_VIEWS_1'),
        z.literal('VIDEO_P0_COMPLETE_1'),
        z.literal('VIDEO_P25_COMPLETE_1'),
        z.literal('VIDEO_P50_COMPLETE_1'),
        z.literal('VIDEO_P75_COMPLETE_1'),
        z.literal('VIDEO_P95_COMPLETE_1'),
        z.literal('VIDEO_P97_COMPLETE_1'),
        z.literal('VIDEO_P100_COMPLETE_1'),
        z.literal('VIDEO_P0_COMBINED_1'),
        z.literal('VIDEO_P25_COMBINED_1'),
        z.literal('VIDEO_P50_COMBINED_1'),
        z.literal('VIDEO_P75_COMBINED_1'),
        z.literal('VIDEO_P95_COMBINED_1'),
        z.literal('VIDEO_P97_COMBINED_1'),
        z.literal('VIDEO_P100_COMBINED_1'),
        z.literal('VIDEO_AVG_WATCHTIME_1'),
        z.literal('VIDEO_MRC_VIEWS_1'),
        z.literal('VIDEO_VIEW_RATE_1'),
        z.literal('VIDEO_3SEC_VIEWS_2'),
        z.literal('VIDEO_P0_COMPLETE_2'),
        z.literal('VIDEO_P25_COMPLETE_2'),
        z.literal('VIDEO_P50_COMPLETE_2'),
        z.literal('VIDEO_P75_COMPLETE_2'),
        z.literal('VIDEO_P95_COMPLETE_2'),
        z.literal('VIDEO_P97_COMPLETE_2'),
        z.literal('VIDEO_P100_COMPLETE_2'),
        z.literal('VIDEO_P0_COMBINED_2'),
        z.literal('VIDEO_P25_COMBINED_2'),
        z.literal('VIDEO_P50_COMBINED_2'),
        z.literal('VIDEO_P75_COMBINED_2'),
        z.literal('VIDEO_P95_COMBINED_2'),
        z.literal('VIDEO_P97_COMBINED_2'),
        z.literal('VIDEO_P100_COMBINED_2'),
        z.literal('VIDEO_AVG_WATCHTIME_2'),
        z.literal('VIDEO_MRC_VIEWS_2'),
        z.literal('VIDEO_VIEW_RATE_2'),
        z.literal('PAID_VIDEO_VIEW'),
        z.literal('PAID_VIDEO_IMPRESSION'),
        z.literal('PAID_VIDEO_VIEWABLE_RATE'),
        z.literal('VIDEO_LENGTH'),
        z.literal('CPV_IN_MICRO_DOLLAR'),
        z.literal('CPV_IN_DOLLAR'),
        z.literal('CP3SV_IN_MICRO_DOLLAR'),
        z.literal('CP3SV_IN_DOLLAR'),
        z.literal('ECPV_IN_MICRO_DOLLAR'),
        z.literal('ECPV_IN_DOLLAR'),
        z.literal('ECP3SV_IN_MICRO_DOLLAR'),
        z.literal('ECP3SV_IN_DOLLAR'),
        z.literal('CPCV_IN_DOLLAR'),
        z.literal('CPCV_IN_MICRO_DOLLAR'),
        z.literal('ECPCV_IN_DOLLAR'),
        z.literal('ECPCV_IN_MICRO_DOLLAR'),
        z.literal('CPCV_P95_IN_DOLLAR'),
        z.literal('CPCV_P95_IN_MICRO_DOLLAR'),
        z.literal('ECPCV_P95_IN_DOLLAR'),
        z.literal('ECPCV_P95_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIDEO_3SEC_VIEWS'),
        z.literal('TOTAL_VIDEO_P0_COMPLETE'),
        z.literal('TOTAL_VIDEO_P25_COMPLETE'),
        z.literal('TOTAL_VIDEO_P50_COMPLETE'),
        z.literal('TOTAL_VIDEO_P75_COMPLETE'),
        z.literal('TOTAL_VIDEO_P95_COMPLETE'),
        z.literal('TOTAL_VIDEO_P97_COMPLETE'),
        z.literal('TOTAL_VIDEO_P100_COMPLETE'),
        z.literal('TOTAL_VIDEO_P0_COMBINED'),
        z.literal('TOTAL_VIDEO_P25_COMBINED'),
        z.literal('TOTAL_VIDEO_P50_COMBINED'),
        z.literal('TOTAL_VIDEO_P75_COMBINED'),
        z.literal('TOTAL_VIDEO_P95_COMBINED'),
        z.literal('TOTAL_VIDEO_P97_COMBINED'),
        z.literal('TOTAL_VIDEO_P100_COMBINED'),
        z.literal('TOTAL_VIDEO_AVG_WATCHTIME'),
        z.literal('TOTAL_VIDEO_MRC_VIEWS'),
        z.literal('TOTAL_VIDEO_VIEW_RATE'),
        z.literal('VIDEO_V50_WATCHTIME_1'),
        z.literal('VIDEO_V50_WATCHTIME_2'),
        z.literal('TOTAL_VIDEO_V50_WATCHTIME'),
        z.literal('VIDEO_SUM_V50_WATCHTIME_IN_MILLISECOND_1'),
        z.literal('VIDEO_SUM_V50_WATCHTIME_IN_MILLISECOND_2'),
        z.literal('TOTAL_VIDEO_SUM_V50_WATCHTIME_IN_MILLISECOND'),
        z.literal('VIDEO_SUM_V50_WATCHTIME_IN_SECOND_1'),
        z.literal('VIDEO_SUM_V50_WATCHTIME_IN_SECOND_2'),
        z.literal('TOTAL_VIDEO_SUM_V50_WATCHTIME_IN_SECOND'),
        z.literal('VIDEO_AVG_WATCHTIME_IN_MILLISECOND_1'),
        z.literal('VIDEO_AVG_WATCHTIME_IN_MILLISECOND_2'),
        z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_MILLISECOND'),
        z.literal('VIDEO_AVG_WATCHTIME_IN_SECOND_1'),
        z.literal('VIDEO_AVG_WATCHTIME_IN_SECOND_2'),
        z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'),
        z.literal('DELIVERY_STATUS_NO_FANOUT'),
        z.literal('DELIVERY_STATUS_WITH_FANOUT'),
        z.literal('KEYWORD_COMPETITION_BAND'),
        z.literal('KEYWORD_QUERY_VOLUME'),
        z.literal('KEYWORD_VALUE'),
        z.literal('KEYWORD_MATCH_TYPE'),
        z.literal('KEYWORD_BID_IN_MICRO_CURRENCY'),
        z.literal('KEYWORD_USER_QUERY'),
        z.literal('KEYWORD_SQR_KEYWORD_VALUE'),
        z.literal('KEYWORD_AD_GROUP_ID'),
        z.literal('KEYWORD_AD_GROUP_NAME'),
        z.literal('KEYWORD_CAMPAIGN_ID'),
        z.literal('KEYWORD_CAMPAIGN_NAME'),
        z.literal('KEYWORD_SEARCH_TERM_AD_GROUP_ID'),
        z.literal('KEYWORD_SEARCH_TERM_AD_GROUP_NAME'),
        z.literal('KEYWORD_SEARCH_TERM_CAMPAIGN_ID'),
        z.literal('KEYWORD_SEARCH_TERM_CAMPAIGN_NAME'),
        z.literal('NEGATIVE_KEYWORD_AD_GROUP_ID'),
        z.literal('NEGATIVE_KEYWORD_AD_GROUP_NAME'),
        z.literal('NEGATIVE_KEYWORD_CAMPAIGN_ID'),
        z.literal('NEGATIVE_KEYWORD_CAMPAIGN_NAME'),
        z.literal('ONE_TAP_V2_WEBSITE_VIEW_1'),
        z.literal('ONE_TAP_V2_WEBSITE_VIEW_2'),
        z.literal('TOTAL_ONE_TAP_V2_WEBSITE_VIEW'),
        z.literal('ONE_TAP_V2_WEBSITE_VIEW_USER_1'),
        z.literal('ONE_TAP_V2_WEBSITE_VIEW_USER_2'),
        z.literal('TOTAL_LANDING_PAGE_VIEWS'),
        z.literal('LANDING_PAGE_VIEWS_1'),
        z.literal('LANDING_PAGE_VIEWS_2'),
        z.literal('COST_PER_LANDING_PAGE_VIEW'),
        z.literal('LANDING_PAGE_VIEW_RATE'),
        z.literal('TOTAL_DESTINATION_VIEWS'),
        z.literal('DESTINATION_VIEWS_1'),
        z.literal('DESTINATION_VIEWS_2'),
        z.literal('COST_PER_DESTINATION_VIEW_IN_DOLLAR'),
        z.literal('COST_PER_DESTINATION_VIEW_IN_MICRO_DOLLAR'),
        z.literal('DESTINATION_VIEW_RATE'),
        z.literal('CAROUSEL_SLOT_INDEX'),
        z.literal('CAROUSEL_ID'),
        z.literal('CAROUSEL_SLOT_PROMOTION_ID'),
        z.literal('CAROUSEL_SLOT_IMPRESSION_1'),
        z.literal('CAROUSEL_SLOT_IMPRESSION_2'),
        z.literal('TOTAL_CAROUSEL_SLOT_IMPRESSION'),
        z.literal('CAROUSEL_SLOT_IMPRESSION_USER_1'),
        z.literal('CAROUSEL_SLOT_IMPRESSION_USER_2'),
        z.literal('CAROUSEL_SLOT_CLICKTHROUGH_1'),
        z.literal('CAROUSEL_SLOT_CLICKTHROUGH_2'),
        z.literal('TOTAL_CAROUSEL_SLOT_CLICKTHROUGH'),
        z.literal('CAROUSEL_SLOT_CLICKTHROUGH_USER_1'),
        z.literal('CAROUSEL_SLOT_CLICKTHROUGH_USER_2'),
        z.literal('CAROUSEL_SLOT_SIDESWIPE_1'),
        z.literal('CAROUSEL_SLOT_SIDESWIPE_2'),
        z.literal('TOTAL_CAROUSEL_SLOT_SIDESWIPE'),
        z.literal('CAROUSEL_SLOT_SIDESWIPE_USER_1'),
        z.literal('CAROUSEL_SLOT_SIDESWIPE_USER_2'),
        z.literal('CAROUSEL_SLOT_VIEW_WEBSITE_1'),
        z.literal('CAROUSEL_SLOT_VIEW_WEBSITE_2'),
        z.literal('TOTAL_CAROUSEL_SLOT_VIEW_WEBSITE'),
        z.literal('CAROUSEL_SLOT_VIEW_WEBSITE_USER_1'),
        z.literal('CAROUSEL_SLOT_VIEW_WEBSITE_USER_2'),
        z.literal('COLLECTION_PIN_ITEM_IMPRESSION_1'),
        z.literal('COLLECTION_PIN_ITEM_IMPRESSION_2'),
        z.literal('TOTAL_COLLECTION_PIN_ITEM_IMPRESSION'),
        z.literal('COLLECTION_PIN_ITEM_CLICKTHROUGH_1'),
        z.literal('COLLECTION_PIN_ITEM_CLICKTHROUGH_2'),
        z.literal('TOTAL_COLLECTION_PIN_ITEM_CLICKTHROUGH'),
        z.literal('HOLDOUT_EXPERIMENT'),
        z.literal('AD_GROUP_HOLDOUT_EXPERIMENT'),
        z.literal('PIN_PROMOTION_HOLDOUT_EXPERIMENT'),
        z.literal('MULTI_OBJECTIVE_RESULT'),
        z.literal('MULTI_OBJECTIVE_COST'),
        z.literal('MULTI_OBJECTIVE_RESULT_DESCRIPTION'),
        z.literal('MULTI_OBJECTIVE_COST_DESCRIPTION'),
        z.literal('DATE_RANGE'),
        z.literal('DATE_RANGE_START'),
        z.literal('DATE_RANGE_END'),
        z.literal('REPORT_DATE_START'),
        z.literal('REPORT_DATE_END'),
        z.literal('PINNER_LIST_NAME'),
        z.literal('PINNER_LIST_TYPE'),
        z.literal('ORDER_VALUE'),
        z.literal('ORDER_QUANTITY'),
        z.literal('ADVERTISER_NAME'),
        z.literal('ADVERTISER_CURRENCY'),
        z.literal('TOTAL_REPIN_RATE'),
        z.literal('SPEND_YESTERDAY_IN_DOLLAR'),
        z.literal('PIN_PROMOTION_REJECTION_LABELS'),
        z.literal('PIN_PROMOTION_DESTINATION_URL'),
        z.literal('VIDEO_COMPLETION_RATE'),
        z.literal('CAMPAIGN_BOOKING_REFERENCE'),
        z.literal('WEB_CHECKOUT_COST_PER_ACTION'),
        z.literal('WEB_CHECKOUT_ROAS'),
        z.literal('TOTAL_WEB_CHECKOUT'),
        z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('INAPP_CHECKOUT_COST_PER_ACTION'),
        z.literal('INAPP_CHECKOUT_ROAS'),
        z.literal('TOTAL_INAPP_CHECKOUT'),
        z.literal('TOTAL_INAPP_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_CLICK_CHECKOUT'),
        z.literal('TOTAL_INAPP_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_CLICK_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_VIEW_CHECKOUT'),
        z.literal('TOTAL_INAPP_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_VIEW_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('OFFLINE_CHECKOUT_COST_PER_ACTION'),
        z.literal('OFFLINE_CHECKOUT_ROAS'),
        z.literal('TOTAL_OFFLINE_CHECKOUT'),
        z.literal('TOTAL_OFFLINE_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_CLICK_CHECKOUT'),
        z.literal('TOTAL_OFFLINE_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_CLICK_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_VIEW_CHECKOUT'),
        z.literal('TOTAL_OFFLINE_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_VIEW_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('PINTEREST_CHECKOUT_COST_PER_ACTION'),
        z.literal('PINTEREST_CHECKOUT_ROAS'),
        z.literal('TOTAL_PINTEREST_CHECKOUT'),
        z.literal('TOTAL_PINTEREST_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_PINTEREST_CHECKOUT_VALUE_IN_DOLLAR'),
        z.literal('WEB_ADD_TO_CART_COST_PER_ACTION'),
        z.literal('WEB_ADD_TO_CART_ROAS'),
        z.literal('TOTAL_WEB_ADD_TO_CART'),
        z.literal('TOTAL_WEB_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ADD_TO_CART_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_ADD_TO_CART'),
        z.literal('TOTAL_WEB_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_ADD_TO_CART_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_ADD_TO_CART'),
        z.literal('TOTAL_WEB_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_ADD_TO_CART'),
        z.literal('TOTAL_WEB_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_ADD_TO_CART_VALUE_IN_DOLLAR'),
        z.literal('INAPP_ADD_TO_CART_COST_PER_ACTION'),
        z.literal('INAPP_ADD_TO_CART_ROAS'),
        z.literal('TOTAL_INAPP_ADD_TO_CART'),
        z.literal('TOTAL_INAPP_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_ADD_TO_CART_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_CLICK_ADD_TO_CART'),
        z.literal('TOTAL_INAPP_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_CLICK_ADD_TO_CART_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_VIEW_ADD_TO_CART'),
        z.literal('TOTAL_INAPP_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_VIEW_ADD_TO_CART_VALUE_IN_DOLLAR'),
        z.literal('WEB_PAGE_VISIT_COST_PER_ACTION'),
        z.literal('WEB_PAGE_VISIT_ROAS'),
        z.literal('TOTAL_WEB_PAGE_VISIT'),
        z.literal('TOTAL_WEB_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_PAGE_VISIT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_PAGE_VISIT'),
        z.literal('TOTAL_WEB_CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_PAGE_VISIT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_PAGE_VISIT'),
        z.literal('TOTAL_WEB_ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_PAGE_VISIT_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_PAGE_VISIT'),
        z.literal('TOTAL_WEB_VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_PAGE_VISIT_VALUE_IN_DOLLAR'),
        z.literal('WEB_SIGNUP_COST_PER_ACTION'),
        z.literal('WEB_SIGNUP_ROAS'),
        z.literal('TOTAL_WEB_SIGNUP'),
        z.literal('TOTAL_WEB_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_SIGNUP'),
        z.literal('TOTAL_WEB_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_WEB_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_SIGNUP'),
        z.literal('TOTAL_WEB_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('INAPP_SIGNUP_COST_PER_ACTION'),
        z.literal('INAPP_SIGNUP_ROAS'),
        z.literal('TOTAL_INAPP_SIGNUP'),
        z.literal('TOTAL_INAPP_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_CLICK_SIGNUP'),
        z.literal('TOTAL_INAPP_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_CLICK_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_VIEW_SIGNUP'),
        z.literal('TOTAL_INAPP_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_VIEW_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('OFFLINE_SIGNUP_COST_PER_ACTION'),
        z.literal('OFFLINE_SIGNUP_ROAS'),
        z.literal('TOTAL_OFFLINE_SIGNUP'),
        z.literal('TOTAL_OFFLINE_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_CLICK_SIGNUP'),
        z.literal('TOTAL_OFFLINE_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_CLICK_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_VIEW_SIGNUP'),
        z.literal('TOTAL_OFFLINE_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_VIEW_SIGNUP_VALUE_IN_DOLLAR'),
        z.literal('WEB_WATCH_VIDEO_COST_PER_ACTION'),
        z.literal('WEB_WATCH_VIDEO_ROAS'),
        z.literal('TOTAL_WEB_WATCH_VIDEO'),
        z.literal('TOTAL_WEB_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_WATCH_VIDEO_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_WATCH_VIDEO'),
        z.literal('TOTAL_WEB_CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_WATCH_VIDEO_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO'),
        z.literal('TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_WATCH_VIDEO'),
        z.literal('TOTAL_WEB_VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_WATCH_VIDEO_VALUE_IN_DOLLAR'),
        z.literal('WEB_LEAD_COST_PER_ACTION'),
        z.literal('WEB_LEAD_ROAS'),
        z.literal('TOTAL_WEB_LEAD'),
        z.literal('TOTAL_WEB_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_LEAD_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_LEAD'),
        z.literal('TOTAL_WEB_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_LEAD_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_LEAD'),
        z.literal('TOTAL_WEB_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_LEAD_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_LEAD'),
        z.literal('TOTAL_WEB_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_LEAD_VALUE_IN_DOLLAR'),
        z.literal('OFFLINE_LEAD_COST_PER_ACTION'),
        z.literal('OFFLINE_LEAD_ROAS'),
        z.literal('TOTAL_OFFLINE_LEAD'),
        z.literal('TOTAL_OFFLINE_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_LEAD_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_CLICK_LEAD'),
        z.literal('TOTAL_OFFLINE_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_CLICK_LEAD_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_LEAD'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_LEAD_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_VIEW_LEAD'),
        z.literal('TOTAL_OFFLINE_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_VIEW_LEAD_VALUE_IN_DOLLAR'),
        z.literal('WEB_SEARCH_COST_PER_ACTION'),
        z.literal('WEB_SEARCH_ROAS'),
        z.literal('TOTAL_WEB_SEARCH'),
        z.literal('TOTAL_WEB_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_SEARCH_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_SEARCH'),
        z.literal('TOTAL_WEB_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_SEARCH_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_SEARCH'),
        z.literal('TOTAL_WEB_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_SEARCH_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_SEARCH'),
        z.literal('TOTAL_WEB_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_SEARCH_VALUE_IN_DOLLAR'),
        z.literal('INAPP_SEARCH_COST_PER_ACTION'),
        z.literal('INAPP_SEARCH_ROAS'),
        z.literal('TOTAL_INAPP_SEARCH'),
        z.literal('TOTAL_INAPP_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_SEARCH_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_CLICK_SEARCH'),
        z.literal('TOTAL_INAPP_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_CLICK_SEARCH_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_SEARCH'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_SEARCH_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_VIEW_SEARCH'),
        z.literal('TOTAL_INAPP_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_VIEW_SEARCH_VALUE_IN_DOLLAR'),
        z.literal('WEB_VIEW_CATEGORY_COST_PER_ACTION'),
        z.literal('WEB_VIEW_CATEGORY_ROAS'),
        z.literal('TOTAL_WEB_VIEW_CATEGORY'),
        z.literal('TOTAL_WEB_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CATEGORY_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_VIEW_CATEGORY'),
        z.literal('TOTAL_WEB_CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_VIEW_CATEGORY_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY'),
        z.literal('TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_VIEW_CATEGORY'),
        z.literal('TOTAL_WEB_VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_VIEW_CATEGORY_VALUE_IN_DOLLAR'),
        z.literal('WEB_CUSTOM_COST_PER_ACTION'),
        z.literal('WEB_CUSTOM_ROAS'),
        z.literal('TOTAL_WEB_CUSTOM'),
        z.literal('TOTAL_WEB_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CUSTOM_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CUSTOM'),
        z.literal('TOTAL_WEB_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CUSTOM_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CUSTOM'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CUSTOM_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CUSTOM'),
        z.literal('TOTAL_WEB_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CUSTOM_VALUE_IN_DOLLAR'),
        z.literal('OFFLINE_CUSTOM_COST_PER_ACTION'),
        z.literal('OFFLINE_CUSTOM_ROAS'),
        z.literal('TOTAL_OFFLINE_CUSTOM'),
        z.literal('TOTAL_OFFLINE_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_CUSTOM_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_CLICK_CUSTOM'),
        z.literal('TOTAL_OFFLINE_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_CLICK_CUSTOM_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_CUSTOM'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_CUSTOM_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_VIEW_CUSTOM'),
        z.literal('TOTAL_OFFLINE_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_VIEW_CUSTOM_VALUE_IN_DOLLAR'),
        z.literal('WEB_UNKNOWN_COST_PER_ACTION'),
        z.literal('WEB_UNKNOWN_ROAS'),
        z.literal('TOTAL_WEB_UNKNOWN'),
        z.literal('TOTAL_WEB_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_UNKNOWN'),
        z.literal('TOTAL_WEB_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_UNKNOWN'),
        z.literal('TOTAL_WEB_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_UNKNOWN'),
        z.literal('TOTAL_WEB_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('INAPP_UNKNOWN_COST_PER_ACTION'),
        z.literal('INAPP_UNKNOWN_ROAS'),
        z.literal('TOTAL_INAPP_UNKNOWN'),
        z.literal('TOTAL_INAPP_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_CLICK_UNKNOWN'),
        z.literal('TOTAL_INAPP_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_CLICK_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_UNKNOWN'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_VIEW_UNKNOWN'),
        z.literal('TOTAL_INAPP_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_VIEW_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('OFFLINE_UNKNOWN_COST_PER_ACTION'),
        z.literal('OFFLINE_UNKNOWN_ROAS'),
        z.literal('TOTAL_OFFLINE_UNKNOWN'),
        z.literal('TOTAL_OFFLINE_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_CLICK_UNKNOWN'),
        z.literal('TOTAL_OFFLINE_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_CLICK_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_OFFLINE_VIEW_UNKNOWN'),
        z.literal('TOTAL_OFFLINE_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_OFFLINE_VIEW_UNKNOWN_VALUE_IN_DOLLAR'),
        z.literal('INAPP_APP_INSTALL_COST_PER_ACTION'),
        z.literal('INAPP_APP_INSTALL_ROAS'),
        z.literal('TOTAL_INAPP_APP_INSTALL'),
        z.literal('TOTAL_INAPP_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_APP_INSTALL_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_CLICK_APP_INSTALL'),
        z.literal('TOTAL_INAPP_CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_CLICK_APP_INSTALL_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_APP_INSTALL'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_ENGAGEMENT_APP_INSTALL_VALUE_IN_DOLLAR'),
        z.literal('TOTAL_INAPP_VIEW_APP_INSTALL'),
        z.literal('TOTAL_INAPP_VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_INAPP_VIEW_APP_INSTALL_VALUE_IN_DOLLAR'),
        z.literal('IDEA_PIN_PAGE_FORWARD_1'),
        z.literal('IDEA_PIN_PAGE_FORWARD_2'),
        z.literal('IDEA_PIN_PAGE_BACKWARD_1'),
        z.literal('IDEA_PIN_PAGE_BACKWARD_2'),
        z.literal('TOTAL_IDEA_PIN_PAGE_FORWARD'),
        z.literal('TOTAL_IDEA_PIN_PAGE_BACKWARD'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_1'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_2'),
        z.literal('TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'),
        z.literal('CPM_IN_US_DOLLAR'),
        z.literal('ECPC_IN_US_DOLLAR'),
        z.literal('LEADS'),
        z.literal('COST_PER_LEAD'),
        z.literal('QUIZ_STARTED'),
        z.literal('QUIZ_COMPLETED'),
        z.literal('QUIZ_PIN_RESULT_OPEN'),
        z.literal('QUIZ_COMPLETION_RATE'),
        z.literal('SHOWCASE_PIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_IMPRESSION'),
        z.literal('SHOWCASE_SUBPIN_IMPRESSION'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPAGE_REPIN'),
        z.literal('SHOWCASE_SUBPIN_REPIN'),
        z.literal('SHOWCASE_SUBPAGE_CLOSEUP'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'),
        z.literal('_SHOWCASE_SUBPAGE_CLOSEUP_INTERNAL'),
        z.literal('SHOWCASE_CARD_LANDING'),
        z.literal('SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_RATE'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_RATE'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_RATE'),
        z.literal('TOTAL_SIGNUP_CONVERSION_RATE'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_RATE'),
        z.literal('TOTAL_LEAD_CONVERSION_RATE'),
        z.literal('TOTAL_SEARCH_CONVERSION_RATE'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_RATE'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_RATE'),
        z.literal('TOTAL_CUSTOM_CONVERSION_RATE'),
        z.literal('STANDARD_AD_FEED_ITEM_ID'),
        z.literal('IS_STANDARD_FEED_AD'),
        z.literal('TARGETING_GENDER'),
        z.literal('TARGETING_CREATIVE_TYPE'),
        z.literal('TARGETING_COUNTRY'),
        z.literal('TARGETING_LOCATION'),
        z.literal('TARGETING_APPTYPE'),
        z.literal('TARGETING_LOCATION_CODE'),
        z.literal('TARGETING_MEDIA_TYPE'),
        z.literal('TOTAL_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_WEB_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_INAPP_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_OFFLINE_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_WEB_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_INAPP_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_OFFLINE_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_WEB_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_INAPP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_OFFLINE_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_WEB_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_INAPP_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_OFFLINE_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_WEB_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_INAPP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_OFFLINE_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_SIGNUP_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_SIGNUP_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_LEAD_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_LEAD_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_LEAD_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_WEB_LEAD_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_WEB_LEAD_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_WEB_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_WEB_LEAD_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_WEB_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_SEARCH_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_SEARCH_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_SEARCH_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_CUSTOM_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_CUSTOM_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_QUANTITY'),
        z.literal('TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_VALUE'),
        z.literal('TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'),
        z.literal('TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_USD'),
        z.literal('TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_SIGNUP_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_LEAD_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_WEB_LEAD_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_SEARCH_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_CUSTOM_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_COUNT_UNIQUE'),
        z.literal('TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_COUNT_UNIQUE'),
      ]),
    )
    .optional(),
  granularity: granularitySchema.optional(),
  view_window_days: z.number().optional(),
  click_window_days: z.number().optional(),
  engagement_window_days: z.number().optional(),
  conversion_report_time_type: z.union([z.literal('TIME_OF_AD_ACTION'), z.literal('TIME_OF_CONVERSION')]).optional(),
  filters_json: z.string().optional().nullable(),
  is_owned_by_user: z.boolean().optional(),
  is_scheduled: z.boolean().optional(),
  creation_source: z
    .union([z.literal('ADS_API'), z.literal('ADS_MANAGER_REPORTING_PAGE'), z.literal('ADS_MANAGER_REPORT_BUILDER')])
    .optional(),
  is_deleted: z.boolean().optional().nullable(),
  updated_time: z.number().optional(),
  custom_column_ids: z.array(customColumnIdSchema).optional().nullable(),
  type: z.union([z.literal('UNSPECIFIED'), z.literal('BULK'), z.literal('OVERVIEW'), z.literal('TABLE')]).optional(),
  ingestion_sources: z
    .array(
      z.union([
        z.literal('TAG'),
        z.literal('MMP'),
        z.literal('FILE_UPLOAD'),
        z.literal('CONVERSIONS_API'),
        z.literal('NATIVE'),
      ]),
    )
    .optional()
    .nullable(),
});

export const rangeSchema = z.union([
  z.literal('YEAR_TO_DATE'),
  z.literal('QUARTER_TO_DATE'),
  z.literal('MONTH_TO_DATE'),
  z.literal('LAST_MONTH'),
]);

export const creationSourceSchema = z.union([
  z.literal('ADS_API'),
  z.literal('ADS_MANAGER_REPORTING_PAGE'),
  z.literal('ADS_MANAGER_REPORT_BUILDER'),
]);

export const termsOfServiceSchema = z.object({
  id: z.string().optional(),
  html: z.string().optional().nullable(),
  has_accepted: z.boolean().optional(),
  ad_account_id: z.string().optional(),
});

export const termsSuggestedResponseSchema = z.array(z.string());

export const topPinsAnalyticsResponseSchema = z.object({
  date_availability: z
    .object({
      latest_available_timestamp: z.number().optional(),
      is_realtime: z.boolean().optional(),
    })
    .optional(),
  pins: z
    .array(
      z.object({
        metrics: metricsSchema.optional(),
        data_status: z.record(dataStatusSchema).optional(),
        pin_id: z.string().optional(),
      }),
    )
    .optional(),
  sort_by: z
    .union([
      z.literal('ENGAGEMENT'),
      z.literal('SAVE'),
      z.literal('IMPRESSION'),
      z.literal('OUTBOUND_CLICK'),
      z.literal('PIN_CLICK'),
    ])
    .optional(),
});

export const sortBySchema = z.union([
  z.literal('ENGAGEMENT'),
  z.literal('SAVE'),
  z.literal('IMPRESSION'),
  z.literal('OUTBOUND_CLICK'),
  z.literal('PIN_CLICK'),
]);

export const topVideoPinsAnalyticsResponseSchema = z.object({
  date_availability: z
    .object({
      latest_available_timestamp: z.number().optional(),
      is_realtime: z.boolean().optional(),
    })
    .optional(),
  pins: z
    .array(
      z.object({
        metrics: z.record(z.number()).optional(),
        data_status: z.record(dataStatusSchema).optional(),
        pin_id: z.string().optional(),
      }),
    )
    .optional(),
  sort_by: z
    .union([
      z.literal('SAVE'),
      z.literal('IMPRESSION'),
      z.literal('OUTBOUND_CLICK'),
      z.literal('VIDEO_MRC_VIEW'),
      z.literal('VIDEO_AVG_WATCH_TIME'),
      z.literal('VIDEO_V50_WATCH_TIME'),
      z.literal('QUARTILE_95_PERCENT_VIEW'),
      z.literal('VIDEO_10S_VIEW'),
      z.literal('VIDEO_START'),
    ])
    .optional(),
});

export const sortBy2Schema = z.union([
  z.literal('SAVE'),
  z.literal('IMPRESSION'),
  z.literal('OUTBOUND_CLICK'),
  z.literal('VIDEO_MRC_VIEW'),
  z.literal('VIDEO_AVG_WATCH_TIME'),
  z.literal('VIDEO_V50_WATCH_TIME'),
  z.literal('QUARTILE_95_PERCENT_VIEW'),
  z.literal('VIDEO_10S_VIEW'),
  z.literal('VIDEO_START'),
]);

export const trendTypeSchema = z.union([
  z.literal('growing'),
  z.literal('monthly'),
  z.literal('yearly'),
  z.literal('seasonal'),
]);

export const trendingKeywordsResponseSchema = z.object({
  trends: z
    .array(
      z.object({
        keyword: z.string().optional(),
        pct_growth_wow: z.number().optional(),
        pct_growth_mom: z.number().optional(),
        pct_growth_yoy: z.number().optional(),
        time_series: z
          .record(z.union([z.union([z.number(), z.string()]), z.undefined()]))
          .and(
            z.object({
              date: z.string().optional(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
});

export const trendsSupportedRegionSchema = z.union([
  z.literal('US'),
  z.literal('CA'),
  z.literal('DE'),
  z.literal('FR'),
  z.literal('ES'),
  z.literal('IT'),
  z.literal('DE+AT+CH'),
  z.literal('GB+IE'),
  z.literal('IT+ES+PT+GR+MT'),
  z.literal('PL+RO+HU+SK+CZ'),
  z.literal('SE+DK+FI+NO'),
  z.literal('NL+BE+LU'),
  z.literal('AR'),
  z.literal('BR'),
  z.literal('CO'),
  z.literal('MX'),
  z.literal('MX+AR+CO+CL'),
  z.literal('AU+NZ'),
]);

export const userBusinessRoleBindingSchema = z.object({
  assets_summary: businessMemberAssetsSummarySchema.optional().nullable(),
  business_roles: z.array(businessRoleResponseSchema).optional(),
  created_by_business: businessAccessUserSummarySchema.optional().nullable(),
  created_by_user: businessAccessUserSummarySchema.optional().nullable(),
  created_time: z.number().optional().nullable(),
  id: z.string().optional(),
  is_shared_partner: z.boolean().optional(),
  user: businessAccessUserSummarySchema.optional().nullable(),
});

export const createAssetInvitesRequestItemSchema = z.object({
  invite_id: z.string(),
  invite_type: inviteTypeSchema,
  asset_id_to_permissions: assetIdToPermissionsSchema,
});

export const createAssetInvitesRequestSchema = z.object({
  invites: z.array(createAssetInvitesRequestItemSchema),
});

export const updateAssetGroupBodySchema = z.object({
  asset_groups_to_update: z
    .array(
      z.object({
        asset_group_id: z.string(),
        name: z.string().optional(),
        description: z.string().optional(),
        asset_group_types: assetGroupTypesSchema.optional(),
        assets_to_add: z.array(z.string()).optional(),
        assets_to_remove: z.array(z.string()).optional(),
      }),
    )
    .optional(),
});

export const updateAssetGroupResponseSchema = z.object({
  updated_asset_groups: z.array(assetGroupBindingSchema).optional(),
  exceptions: z
    .array(
      z.object({
        code: z.number().optional(),
        message: z.string().optional(),
        asset_group_id: z.string().optional(),
      }),
    )
    .optional()
    .nullable(),
});

export const deleteAssetGroupBodySchema = z.object({
  asset_groups_to_delete: z.array(z.string()),
});

export const deleteAssetGroupResponseSchema = z.object({
  deleted_asset_groups: z.array(z.string()).optional(),
  exceptions: z
    .array(
      z.object({
        code: z.number().optional(),
        message: z.string().optional(),
        asset_group_id: z.string().optional(),
      }),
    )
    .optional()
    .nullable(),
});

export const inviteBusinessRoleBindingSchema = baseInviteDataResponseSchema
  .and(
    z.object({
      created_by_business_id: z.string().optional(),
      created_by_user_id: z.string().optional(),
      user: businessAccessUserSummarySchema.optional(),
    }),
  )
  .nullable();

export const deleteInvitesResultsResponseArraySchema = z.object({
  items: z
    .array(
      z.object({
        exception: z
          .object({
            invite_id: z.string().optional(),
            message: z.string().optional(),
          })
          .optional()
          .nullable(),
        invite: baseInviteDataResponseSchema.optional(),
      }),
    )
    .optional(),
});

export const usersForIndividualAssetResponseSchema = z.object({
  asset_id: z.string().optional(),
  member_id: z.string().optional(),
  permissions: permissionsResponseSchema.optional(),
});

export const updatePartnerResultsResponseArraySchema = z.object({
  items: z
    .array(
      z.object({
        exception: businessAccessErrorSchema.optional(),
        member_or_partner_id: z.string().optional().nullable(),
      }),
    )
    .optional(),
});

export const userFollowingFeedTypeSchema = z.union([
  z.literal('ALL'),
  z.literal('RANKED'),
  z.literal('CREATOR_ONLY'),
  z.literal('RANKED_CREATOR_ONLY'),
]);

export const userSingleAssetBindingSchema = z.object({
  permissions: permissionsResponseSchema.optional(),
  user: businessAccessUserSummarySchema.optional(),
});

export const userSummarySchema = z.object({
  username: z.string().optional(),
  type: z.string().optional(),
});

export const userWebsiteSummarySchema = z.object({
  website: z.string().optional(),
  status: z.string().optional(),
  verified_at: z.string().optional(),
});

export const userWebsiteVerificationCodeSchema = z.object({
  verification_code: z.string().optional(),
  dns_txt_record: z.string().optional(),
  metatag: z.string().optional(),
  filename: z.string().optional(),
  file_content: z.string().optional(),
});

export const userWebsiteVerifyRequestSchema = z.object({
  website: z.string().optional(),
  verification_method: z.union([z.literal('FILENAME'), z.literal('METATAG'), z.literal('DNSTXT')]).optional(),
});

export const verificationMethodSchema = z.union([z.literal('FILENAME'), z.literal('METATAG'), z.literal('DNSTXT')]);

export const partnerTypeSchema = z.union([z.literal('INTERNAL'), z.literal('EXTERNAL')]);

export const updatePartnerAssetsResultSchema = z.object({
  asset_id: z.string().optional(),
  asset_type: assetTypeResponseSchema.optional(),
  partner_id: z.string().optional(),
  permissions: permissionsResponseSchema.optional(),
});

export const updatePartnerAssetsResultsResponseArraySchema = z.object({
  items: z.array(updatePartnerAssetsResultSchema).optional(),
});

export const sharedAudienceCommonSchema = z.object({
  audience_id: z.string().optional(),
  operation_type: operationTypeSchema.optional(),
});

export const sharedAudienceSchema = sharedAudienceCommonSchema.and(
  z.object({
    recipient_account_ids: z.array(z.string()),
  }),
);

export const businessSharedAudienceSchema = sharedAudienceCommonSchema.and(
  z.object({
    recipient_business_ids: z.array(z.string()),
  }),
);

export const sharedAudienceResponseCommonSchema = z
  .object({
    audience_id: z.string().optional(),
    permissions: z.array(roleSchema).optional(),
  })
  .nullable();

export const sharedAudienceResponseSchema = sharedAudienceResponseCommonSchema
  .and(
    z.object({
      recipient_account_ids: z.array(z.string()).optional(),
    }),
  )
  .nullable();

export const businessSharedAudienceResponseSchema = sharedAudienceResponseCommonSchema
  .and(
    z.object({
      recipient_business_ids: z.array(z.string()).optional(),
    }),
  )
  .nullable();

export const parameterresultLimitSchema = z.number();

export const parameterpathAdAccountIdSchema = z.string();

export const parameterpathAdGroupIdSchema = z.string();

export const parameterpathAdIdSchema = z.string();

export const parameterpathAssetIdSchema = z.string();

export const parameterpathLeadFormIdSchema = z.string();

export const parameterpathAggregatedPinDataSchema = z.string();

export const parameterpathAudienceIdSchema = z.string();

export const parameterpathBoardIdSchema = z.string();

export const parameterpathBoardSectionIdSchema = z.string();

export const parameterpathBulkRequestIdSchema = z.string();

export const parameterincludeDetailsSchema = z.boolean();

export const parameterpathBusinessIdSchema = z.string();

export const parameterpathBusinessUserSchema = z.string();

export const parameterpathBusinessPartnerUserSchema = z.string();

export const parameterpathBusinessMemberUserSchema = z.string();

export const parameterpathCampaignIdSchema = z.string();

export const parameterpathCatalogsFeedIdSchema = z.string();

export const parameterpathCatalogsItemsBatchIdSchema = z.string();

export const parameterpathCatalogsProcessingResultIdSchema = z.string();

export const parameterpathCatalogsProductGroupIdSchema = z.string();

export const parameterpathCategoryIdSchema = z.string();

export const parameterpathConversionTagIdSchema = z.string();

export const parameterpathCustomerListIdSchema = z.string();

export const parameterpathExternalBusinessIdSchema = z.string();

export const parameterpathInterestIdSchema = z.string();

export const parameterpathMediaIdSchema = z.string();

export const parameterpathMemberIdSchema = z.string();

export const parameterpathOrderLineIdSchema = z.string();

export const parameterpathPinIdSchema = z.string();

export const parameterpathPinOrderIdSchema = z.string();

export const parameterpathProductGroupPromotionIdSchema = z.string();

export const parameterpathScopeSchema = audienceDefinitionScopeSchema;

export const parameterpathSubscriptionIdSchema = z.string();

export const parameterpathTargetingTypeSchema = z.union([
  z.literal('APPTYPE'),
  z.literal('GENDER'),
  z.literal('LOCALE'),
  z.literal('AGE_BUCKET'),
  z.literal('LOCATION'),
  z.literal('GEO'),
  z.literal('INTEREST'),
  z.literal('KEYWORD'),
  z.literal('AUDIENCE_INCLUDE'),
  z.literal('AUDIENCE_EXCLUDE'),
]);

export const parameterpathTemplateIdSchema = z.string();

export const parameterpathTrendRegionSchema = trendsSupportedRegionSchema;

export const parameterpathTrendTypeSchema = trendTypeSchema;

export const parameterpathTypeSchema = audienceDefinitionTypeSchema;

export const parameterpathUsernameSchema = z.string();

export const parameterqueryAdAccountIdSchema = z.string();

export const parameterqueryAdGroupIdSchema = z.string();

export const parameterqueryAdGroupIdsSchema = z.array(z.string());

export const parameterqueryAdGroupIdsRequiredSchema = z.array(z.string());

export const parameterqueryAdIdsSchema = z.array(z.string());

export const parameterqueryAdIdsRequiredSchema = z.array(z.string());

export const parameterqueryAdTargetingTypesSchema = z.array(adsAnalyticsAdTargetingTypeSchema);

export const parameterqueryAgeBucketListSchema = ageBucketListSchema;

export const parameterqueryAppTypesSchema = z.union([
  z.literal('ALL'),
  z.literal('MOBILE'),
  z.literal('TABLET'),
  z.literal('WEB'),
]);

export const parameterqueryAssetsSummarySchema = z.boolean();

export const parameterqueryAttributionTypesSchema = conversionReportAttributionTypeSchema;

export const parameterqueryAudienceIdSchema = z.string();

export const parameterqueryAudienceIdsSchema = z.array(z.string());

export const parameterqueryAudienceInsightTypeSchema = audienceInsightTypeSchema;

export const parameterqueryAudienceTypeSchema = z.string();

export const parameterqueryAudienceTypesSchema = z.array(audienceTypeSchema);

export const parameterqueryBookmarkSchema = z.string();

export const parameterqueryCampaignIdSchema = z.string();

export const parameterqueryCampaignIdsSchema = z.array(z.string());

export const parameterqueryCampaignIdsRequiredSchema = z.array(z.string());

export const parameterqueryCampaignTargetingTypesSchema = z.array(adsAnalyticsCampaignTargetingTypeSchema);

export const parameterqueryCatalogsCatalogIdSchema = z.string();

export const parameterqueryCatalogsFeedIdSchema = z.string();

export const parameterqueryCatalogsItemNumbersSchema = z.array(z.number());

export const parameterqueryCatalogsItemValidationIssueSchema = catalogsItemValidationIssueSchema;

export const parameterqueryCatalogsItemsSchema = z.array(z.string());

export const parameterqueryCatalogsItemsCountrySchema = z.string();

export const parameterqueryCatalogsItemsFiltersSchema = catalogsItemsFiltersSchema;

export const parameterqueryCatalogsItemsLanguageSchema = z.string();

export const parameterqueryCatalogsReportTokenSchema = z.string();

export const parameterqueryCatalogsProductGroupIdsSchema = z.array(z.number());

export const parameterqueryCatalogsProductGroupIdsRequiredSchema = z.array(z.number());

export const parameterqueryClientIdSchema = z.string();

export const parameterqueryColumnsSchema = z.array(
  z.union([
    z.literal('SPEND_IN_MICRO_DOLLAR'),
    z.literal('PAID_IMPRESSION'),
    z.literal('SPEND_IN_DOLLAR'),
    z.literal('CPC_IN_MICRO_DOLLAR'),
    z.literal('ECPC_IN_MICRO_DOLLAR'),
    z.literal('ECPC_IN_DOLLAR'),
    z.literal('CTR'),
    z.literal('ECTR'),
    z.literal('CAMPAIGN_NAME'),
    z.literal('PIN_ID'),
    z.literal('TOTAL_ENGAGEMENT'),
    z.literal('ENGAGEMENT_1'),
    z.literal('ENGAGEMENT_2'),
    z.literal('ECPE_IN_DOLLAR'),
    z.literal('ENGAGEMENT_RATE'),
    z.literal('EENGAGEMENT_RATE'),
    z.literal('ECPM_IN_MICRO_DOLLAR'),
    z.literal('REPIN_RATE'),
    z.literal('CTR_2'),
    z.literal('CAMPAIGN_ID'),
    z.literal('ADVERTISER_ID'),
    z.literal('AD_ACCOUNT_ID'),
    z.literal('PIN_PROMOTION_ID'),
    z.literal('AD_ID'),
    z.literal('AD_GROUP_ID'),
    z.literal('CAMPAIGN_ENTITY_STATUS'),
    z.literal('CAMPAIGN_OBJECTIVE_TYPE'),
    z.literal('CPM_IN_MICRO_DOLLAR'),
    z.literal('CPM_IN_DOLLAR'),
    z.literal('AD_GROUP_ENTITY_STATUS'),
    z.literal('ORDER_LINE_ID'),
    z.literal('ORDER_LINE_NAME'),
    z.literal('CLICKTHROUGH_1'),
    z.literal('REPIN_1'),
    z.literal('IMPRESSION_1'),
    z.literal('IMPRESSION_1_GROSS'),
    z.literal('CLICKTHROUGH_1_GROSS'),
    z.literal('OUTBOUND_CLICK_1'),
    z.literal('CLICKTHROUGH_2'),
    z.literal('REPIN_2'),
    z.literal('IMPRESSION_2'),
    z.literal('OUTBOUND_CLICK_2'),
    z.literal('TOTAL_CLICKTHROUGH'),
    z.literal('TOTAL_IMPRESSION'),
    z.literal('TOTAL_IMPRESSION_USER'),
    z.literal('TOTAL_IMPRESSION_FREQUENCY'),
    z.literal('COST_PER_OUTBOUND_CLICK_IN_DOLLAR'),
    z.literal('TOTAL_ENGAGEMENT_SIGNUP'),
    z.literal('TOTAL_ENGAGEMENT_CHECKOUT'),
    z.literal('TOTAL_ENGAGEMENT_LEAD'),
    z.literal('TOTAL_CLICK_SIGNUP'),
    z.literal('TOTAL_CLICK_CHECKOUT'),
    z.literal('TOTAL_CLICK_ADD_TO_CART'),
    z.literal('TOTAL_CLICK_LEAD'),
    z.literal('TOTAL_VIEW_SIGNUP'),
    z.literal('TOTAL_VIEW_CHECKOUT'),
    z.literal('TOTAL_VIEW_ADD_TO_CART'),
    z.literal('TOTAL_VIEW_LEAD'),
    z.literal('TOTAL_CONVERSIONS'),
    z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
    z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
    z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
    z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
    z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
    z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
    z.literal('TOTAL_WEB_SESSIONS'),
    z.literal('WEB_SESSIONS_1'),
    z.literal('WEB_SESSIONS_2'),
    z.literal('CAMPAIGN_LIFETIME_SPEND_CAP'),
    z.literal('CAMPAIGN_DAILY_SPEND_CAP'),
    z.literal('TOTAL_PAGE_VISIT'),
    z.literal('TOTAL_SIGNUP'),
    z.literal('TOTAL_CHECKOUT'),
    z.literal('TOTAL_CUSTOM'),
    z.literal('TOTAL_LEAD'),
    z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
    z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
    z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
    z.literal('PAGE_VISIT_COST_PER_ACTION'),
    z.literal('PAGE_VISIT_ROAS'),
    z.literal('CHECKOUT_ROAS'),
    z.literal('CUSTOM_ROAS'),
    z.literal('VIDEO_MRC_VIEWS_1'),
    z.literal('VIDEO_3SEC_VIEWS_2'),
    z.literal('VIDEO_P100_COMPLETE_2'),
    z.literal('VIDEO_P0_COMBINED_2'),
    z.literal('VIDEO_P25_COMBINED_2'),
    z.literal('VIDEO_P50_COMBINED_2'),
    z.literal('VIDEO_P75_COMBINED_2'),
    z.literal('VIDEO_P95_COMBINED_2'),
    z.literal('VIDEO_MRC_VIEWS_2'),
    z.literal('PAID_VIDEO_VIEWABLE_RATE'),
    z.literal('VIDEO_LENGTH'),
    z.literal('ECPV_IN_DOLLAR'),
    z.literal('ECPCV_IN_DOLLAR'),
    z.literal('ECPCV_P95_IN_DOLLAR'),
    z.literal('TOTAL_VIDEO_3SEC_VIEWS'),
    z.literal('TOTAL_VIDEO_P100_COMPLETE'),
    z.literal('TOTAL_VIDEO_P0_COMBINED'),
    z.literal('TOTAL_VIDEO_P25_COMBINED'),
    z.literal('TOTAL_VIDEO_P50_COMBINED'),
    z.literal('TOTAL_VIDEO_P75_COMBINED'),
    z.literal('TOTAL_VIDEO_P95_COMBINED'),
    z.literal('TOTAL_VIDEO_MRC_VIEWS'),
    z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'),
    z.literal('TOTAL_REPIN_RATE'),
    z.literal('WEB_CHECKOUT_COST_PER_ACTION'),
    z.literal('WEB_CHECKOUT_ROAS'),
    z.literal('TOTAL_WEB_CHECKOUT'),
    z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
    z.literal('TOTAL_WEB_CLICK_CHECKOUT'),
    z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
    z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT'),
    z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
    z.literal('TOTAL_WEB_VIEW_CHECKOUT'),
    z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
    z.literal('INAPP_CHECKOUT_COST_PER_ACTION'),
    z.literal('TOTAL_OFFLINE_CHECKOUT'),
    z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_1'),
    z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_2'),
    z.literal('TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'),
    z.literal('LEADS'),
    z.literal('COST_PER_LEAD'),
    z.literal('QUIZ_COMPLETED'),
    z.literal('QUIZ_PIN_RESULT_OPEN'),
    z.literal('QUIZ_COMPLETION_RATE'),
    z.literal('SHOWCASE_PIN_CLICKTHROUGH'),
    z.literal('SHOWCASE_SUBPAGE_CLICKTHROUGH'),
    z.literal('SHOWCASE_SUBPIN_CLICKTHROUGH'),
    z.literal('SHOWCASE_SUBPAGE_IMPRESSION'),
    z.literal('SHOWCASE_SUBPIN_IMPRESSION'),
    z.literal('SHOWCASE_SUBPAGE_SWIPE_LEFT'),
    z.literal('SHOWCASE_SUBPAGE_SWIPE_RIGHT'),
    z.literal('SHOWCASE_SUBPIN_SWIPE_LEFT'),
    z.literal('SHOWCASE_SUBPIN_SWIPE_RIGHT'),
    z.literal('SHOWCASE_SUBPAGE_REPIN'),
    z.literal('SHOWCASE_SUBPIN_REPIN'),
    z.literal('SHOWCASE_SUBPAGE_CLOSEUP'),
    z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'),
    z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'),
    z.literal('SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'),
    z.literal('TOTAL_CHECKOUT_CONVERSION_RATE'),
    z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_RATE'),
    z.literal('TOTAL_ADD_TO_CART_CONVERSION_RATE'),
    z.literal('TOTAL_SIGNUP_CONVERSION_RATE'),
    z.literal('TOTAL_PAGE_VISIT_CONVERSION_RATE'),
    z.literal('TOTAL_LEAD_CONVERSION_RATE'),
    z.literal('TOTAL_SEARCH_CONVERSION_RATE'),
    z.literal('TOTAL_WATCH_VIDEO_CONVERSION_RATE'),
    z.literal('TOTAL_UNKNOWN_CONVERSION_RATE'),
    z.literal('TOTAL_CUSTOM_CONVERSION_RATE'),
  ]),
);

export const parameterqueryCommentFeedTypeSchema = z.union([z.literal('ranked'), z.literal('recent')]);

export const parameterqueryContentTypeSchema = z.union([z.literal('ALL'), z.literal('PAID'), z.literal('ORGANIC')]);

export const parameterqueryConversionAttributionClickWindowDaysSchema = z.union([
  z.literal(0),
  z.literal(1),
  z.literal(7),
  z.literal(14),
  z.literal(30),
  z.literal(60),
]);

export const parameterqueryConversionAttributionConversionReportTimeSchema = z.union([
  z.literal('TIME_OF_AD_ACTION'),
  z.literal('TIME_OF_CONVERSION'),
]);

export const parameterqueryConversionAttributionEngagementWindowDaysSchema = z.union([
  z.literal(0),
  z.literal(1),
  z.literal(7),
  z.literal(14),
  z.literal(30),
  z.literal(60),
]);

export const parameterqueryConversionAttributionViewWindowDaysSchema = z.union([
  z.literal(0),
  z.literal(1),
  z.literal(7),
  z.literal(14),
  z.literal(30),
  z.literal(60),
]);

export const parameterqueryCountryCodeSchema = z.string();

export const parameterqueryCreatedInLastNDaysSchema = z.literal(30);

export const parameterqueryCreativeTypesSchema = z.array(
  z.union([
    z.literal('REGULAR'),
    z.literal('VIDEO'),
    z.literal('SHOPPING'),
    z.literal('CAROUSEL'),
    z.literal('MAX_VIDEO'),
    z.literal('SHOP_THE_PIN'),
    z.literal('COLLECTION'),
    z.literal('IDEA'),
  ]),
);

export const parameterqueryEndDateSchema = z.string();

export const parameterqueryEndDateAsyncSchema = z.string();

export const parameterqueryEntityStatusesSchema = z.array(
  z.union([
    z.literal('ACTIVE'),
    z.literal('PAUSED'),
    z.literal('ARCHIVED'),
    z.literal('DRAFT'),
    z.literal('DELETED_DRAFT'),
  ]),
);

export const parameterqueryExplicitFollowingSchema = z.boolean();

export const parameterqueryFilterDeletedSchema = z.boolean();

export const parameterqueryFlattenRuleSchema = z.boolean();

export const parameterqueryFromClaimedContentSchema = z.union([
  z.literal('OTHER'),
  z.literal('CLAIMED'),
  z.literal('BOTH'),
]);

export const parameterqueryGenderListSchema = genderListSchema;

export const parameterqueryGranularitySchema = granularitySchema;

export const parameterqueryGranularityAsyncSchema = granularitySchema;

export const parameterqueryIncludeHtmlSchema = z.boolean();

export const parameterqueryIncludeProtectedPinsSchema = z.boolean();

export const parameterqueryIncludeSharedAccountsSchema = z.boolean();

export const parameterqueryInputTermSchema = z.string();

export const parameterqueryInterestListSchema = l1InterestListSchema;

export const parameterqueryIsMemberSchema = z.boolean();

export const parameterqueryKeywordsSchema = z.array(z.string());

export const parameterqueryPinMetricsSchema = z.boolean();

export const parameterqueryListInputTermsSchema = z.array(z.string());

export const parameterqueryMatchTypesSchema = z.array(matchTypeSchema);

export const parameterqueryMembersSchema = z.string();

export const parameterqueryPartnersSchema = z.string();

export const parameterqueryMetricTypesSchema = z.array(
  z.union([
    z.literal('ENGAGEMENT'),
    z.literal('ENGAGEMENT_RATE'),
    z.literal('IMPRESSION'),
    z.literal('OUTBOUND_CLICK'),
    z.literal('OUTBOUND_CLICK_RATE'),
    z.literal('PIN_CLICK'),
    z.literal('PIN_CLICK_RATE'),
    z.literal('SAVE'),
    z.literal('SAVE_RATE'),
  ]),
);

export const parameterqueryNormalizeAgainstGroupSchema = z.boolean();

export const parameterqueryNumOfPinsSchema = z.number();

export const parameterqueryOauthSignatureSchema = z.string();

export const parameterqueryOrderSchema = z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]);

export const parameterqueryOrderBySchema = getAudiencesOrderBySchema;

export const parameterqueryPageSizeSchema = z.number();

export const parameterqueryPinAnalyticsMetricTypesSchema = z.array(
  z.union([
    z.literal('IMPRESSION'),
    z.literal('OUTBOUND_CLICK'),
    z.literal('PIN_CLICK'),
    z.literal('SAVE'),
    z.literal('SAVE_RATE'),
    z.literal('TOTAL_COMMENTS'),
    z.literal('TOTAL_REACTIONS'),
    z.literal('USER_FOLLOW'),
    z.literal('PROFILE_VISIT'),
    z.literal('IMPRESSION'),
    z.literal('OUTBOUND_CLICK'),
    z.literal('PIN_CLICK'),
    z.literal('SAVE'),
    z.literal('SAVE_RATE'),
    z.literal('VIDEO_MRC_VIEW'),
    z.literal('VIDEO_10S_VIEW'),
    z.literal('QUARTILE_95_PERCENT_VIEW'),
    z.literal('VIDEO_V50_WATCH_TIME'),
    z.literal('VIDEO_START'),
    z.literal('VIDEO_AVG_WATCH_TIME'),
    z.literal('TOTAL_COMMENTS'),
    z.literal('TOTAL_REACTIONS'),
  ]),
);

export const parameterqueryPinFilterSchema = z.union([
  z.literal('exclude_native'),
  z.literal('exclude_repins'),
  z.literal('has_been_promoted'),
]);

export const parameterqueryPinFormatSchema = z.union([
  z.literal('ALL'),
  z.literal('ORGANIC_IMAGE'),
  z.literal('ORGANIC_PRODUCT'),
  z.literal('ORGANIC_VIDEO'),
  z.literal('ADS_STANDARD'),
  z.literal('ADS_PRODUCT'),
  z.literal('ADS_VIDEO'),
  z.literal('ADS_IDEA'),
]);

export const parameterqueryPinOrderIdSchema = z.string();

export const parameterqueryPinTypeSchema = z.literal('PRIVATE');

export const parameterqueryProductGroupIdsRequiredSchema = z.array(z.string());

export const parameterqueryProductGroupPromotionIdsSchema = z.array(z.string());

export const parameterqueryQuerySchema = z.string();

export const parameterqueryAccountTypeSchema = audienceAccountTypeSchema;

export const parameterqueryReportTypeSchema = z.union([z.literal('SYNC'), z.literal('ASYNC')]);

export const parameterqueryRequiredPinIdsSchema = z.array(z.string());

export const parameterqueryRequiredSearchQuerySchema = z.string();

export const parameterqueryResourceTypeSchema = z.union([
  z.literal('AD_ACCOUNT'),
  z.literal('PROFILE'),
  z.literal('ASSET_GROUP'),
]);

export const parameterquerySearchQuerySchema = z.string();

export const parameterquerySortSchema = z.literal('RATIO');

export const parameterquerySortBySchema = z.union([
  z.literal('ENGAGEMENT'),
  z.literal('IMPRESSION'),
  z.literal('OUTBOUND_CLICK'),
  z.literal('PIN_CLICK'),
  z.literal('SAVE'),
]);

export const parameterquerySourceSchema = z.union([z.literal('ALL'), z.literal('YOUR_PINS'), z.literal('OTHER_PINS')]);

export const parameterquerySplitFieldPinsSchema = z.union([z.literal('NO_SPLIT'), z.literal('APP_TYPE')]);

export const parameterquerySplitFieldUserAccountSchema = z.union([
  z.literal('NO_SPLIT'),
  z.literal('APP_TYPE'),
  z.literal('OWNED_CONTENT'),
  z.literal('SOURCE'),
  z.literal('PIN_FORMAT'),
]);

export const parameterqueryStartDateSchema = z.string();

export const parameterqueryStartDateAsyncSchema = z.string();

export const parameterqueryStartIndexSchema = z.string();

export const parameterqueryBusinessAccessStartIndexSchema = z.number();

export const parameterqueryBusinessPartnerTypeSchema = partnerTypeSchema;

export const parameterqueryTargetingTypesSchema = z.array(adsAnalyticsTargetingTypeSchema);

export const parameterqueryTermLimitSchema = z.number();

export const parameterqueryTimestampSchema = z.string();

export const parameterqueryTokenRequiredSchema = z.string();

export const parameterqueryTosTypeSchema = z.string();

export const parameterqueryTranslateInterestsToNamesSchema = z.boolean();

export const parameterqueryTrendingKeywordLimitSchema = z.number();

export const parameterqueryUserFollowingFeedTypeSchema = userFollowingFeedTypeSchema;

export const parameterqueryUsernameSchema = z.string();

export const parameterqueryVideoPinMetricTypesSchema = z.array(
  z.union([
    z.literal('IMPRESSION'),
    z.literal('SAVE'),
    z.literal('VIDEO_MRC_VIEW'),
    z.literal('VIDEO_AVG_WATCH_TIME'),
    z.literal('VIDEO_V50_WATCH_TIME'),
    z.literal('QUARTILE_95_PERCENT_VIEW'),
    z.literal('VIDEO_10S_VIEW'),
    z.literal('VIDEO_START'),
    z.literal('OUTBOUND_CLICK'),
  ]),
);

export const parameterqueryVideoPinSortBySchema = z.union([
  z.literal('IMPRESSION'),
  z.literal('SAVE'),
  z.literal('OUTBOUND_CLICK'),
  z.literal('VIDEO_MRC_VIEW'),
  z.literal('VIDEO_AVG_WATCH_TIME'),
  z.literal('VIDEO_V50_WATCH_TIME'),
  z.literal('QUARTILE_95_PERCENT_VIEW'),
  z.literal('VIDEO_10S_VIEW'),
  z.literal('VIDEO_START'),
]);

export const parameterqueryWebsiteSchema = z.string();

export const parameterqueryInviteStatusSchema = z.array(z.union([z.literal('PENDING'), z.literal('EXPIRED')]));

export const parameterqueryInviteTypeSchema = inviteTypeSchema;

export const adAccountsListDataSchema = z.object({
  query: z
    .object({
      bookmark: z.string().optional(),
      include_shared_accounts: z.boolean().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const adAccountsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.unknown().optional(),
  }),
);

export const adAccountsListErrorSchema = errorSchema;

export const adAccountsCreateDataSchema = z.object({
  body: adAccountCreateRequestSchema,
});

export const adAccountSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  owner: z
    .object({
      username: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  country: countrySchema.optional(),
  currency: currencySchema.optional(),
  permissions: z.array(businessAccessRoleSchema).optional(),
  created_time: z.number().optional().nullable(),
  updated_time: z.number().optional().nullable(),
});

export const adAccountsCreateErrorSchema = errorSchema;

export const adAccountsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const adAccountsGetResponseSchema = adAccountSchema;

export const adAccountsGetErrorSchema = errorSchema;

export const adGroupsListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      ad_group_ids: z.array(z.string()).optional(),
      bookmark: z.string().optional(),
      campaign_ids: z.array(z.string()).optional(),
      entity_statuses: z
        .array(
          z.union([
            z.literal('ACTIVE'),
            z.literal('PAUSED'),
            z.literal('ARCHIVED'),
            z.literal('DRAFT'),
            z.literal('DELETED_DRAFT'),
          ]),
        )
        .optional(),
      order: z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
      page_size: z.number().optional(),
      translate_interests_to_names: z.boolean().optional(),
    })
    .optional(),
});

export const adGroupsListErrorSchema = errorSchema;

export const adGroupsCreateDataSchema = z.object({
  body: z.array(adGroupCreateRequestSchema),
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const adGroupsCreateErrorSchema = errorSchema;

export const adGroupsUpdateDataSchema = z.object({
  body: z.array(adGroupUpdateRequestSchema),
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const adGroupsUpdateErrorSchema = errorSchema;

export const adGroupsAnalyticsDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    ad_group_ids: z.array(z.string()),
    click_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    columns: z.array(
      z.union([
        z.literal('SPEND_IN_MICRO_DOLLAR'),
        z.literal('PAID_IMPRESSION'),
        z.literal('SPEND_IN_DOLLAR'),
        z.literal('CPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_DOLLAR'),
        z.literal('CTR'),
        z.literal('ECTR'),
        z.literal('CAMPAIGN_NAME'),
        z.literal('PIN_ID'),
        z.literal('TOTAL_ENGAGEMENT'),
        z.literal('ENGAGEMENT_1'),
        z.literal('ENGAGEMENT_2'),
        z.literal('ECPE_IN_DOLLAR'),
        z.literal('ENGAGEMENT_RATE'),
        z.literal('EENGAGEMENT_RATE'),
        z.literal('ECPM_IN_MICRO_DOLLAR'),
        z.literal('REPIN_RATE'),
        z.literal('CTR_2'),
        z.literal('CAMPAIGN_ID'),
        z.literal('ADVERTISER_ID'),
        z.literal('AD_ACCOUNT_ID'),
        z.literal('PIN_PROMOTION_ID'),
        z.literal('AD_ID'),
        z.literal('AD_GROUP_ID'),
        z.literal('CAMPAIGN_ENTITY_STATUS'),
        z.literal('CAMPAIGN_OBJECTIVE_TYPE'),
        z.literal('CPM_IN_MICRO_DOLLAR'),
        z.literal('CPM_IN_DOLLAR'),
        z.literal('AD_GROUP_ENTITY_STATUS'),
        z.literal('ORDER_LINE_ID'),
        z.literal('ORDER_LINE_NAME'),
        z.literal('CLICKTHROUGH_1'),
        z.literal('REPIN_1'),
        z.literal('IMPRESSION_1'),
        z.literal('IMPRESSION_1_GROSS'),
        z.literal('CLICKTHROUGH_1_GROSS'),
        z.literal('OUTBOUND_CLICK_1'),
        z.literal('CLICKTHROUGH_2'),
        z.literal('REPIN_2'),
        z.literal('IMPRESSION_2'),
        z.literal('OUTBOUND_CLICK_2'),
        z.literal('TOTAL_CLICKTHROUGH'),
        z.literal('TOTAL_IMPRESSION'),
        z.literal('TOTAL_IMPRESSION_USER'),
        z.literal('TOTAL_IMPRESSION_FREQUENCY'),
        z.literal('COST_PER_OUTBOUND_CLICK_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_ENGAGEMENT_LEAD'),
        z.literal('TOTAL_CLICK_SIGNUP'),
        z.literal('TOTAL_CLICK_CHECKOUT'),
        z.literal('TOTAL_CLICK_ADD_TO_CART'),
        z.literal('TOTAL_CLICK_LEAD'),
        z.literal('TOTAL_VIEW_SIGNUP'),
        z.literal('TOTAL_VIEW_CHECKOUT'),
        z.literal('TOTAL_VIEW_ADD_TO_CART'),
        z.literal('TOTAL_VIEW_LEAD'),
        z.literal('TOTAL_CONVERSIONS'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_SESSIONS'),
        z.literal('WEB_SESSIONS_1'),
        z.literal('WEB_SESSIONS_2'),
        z.literal('CAMPAIGN_LIFETIME_SPEND_CAP'),
        z.literal('CAMPAIGN_DAILY_SPEND_CAP'),
        z.literal('TOTAL_PAGE_VISIT'),
        z.literal('TOTAL_SIGNUP'),
        z.literal('TOTAL_CHECKOUT'),
        z.literal('TOTAL_CUSTOM'),
        z.literal('TOTAL_LEAD'),
        z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('PAGE_VISIT_COST_PER_ACTION'),
        z.literal('PAGE_VISIT_ROAS'),
        z.literal('CHECKOUT_ROAS'),
        z.literal('CUSTOM_ROAS'),
        z.literal('VIDEO_MRC_VIEWS_1'),
        z.literal('VIDEO_3SEC_VIEWS_2'),
        z.literal('VIDEO_P100_COMPLETE_2'),
        z.literal('VIDEO_P0_COMBINED_2'),
        z.literal('VIDEO_P25_COMBINED_2'),
        z.literal('VIDEO_P50_COMBINED_2'),
        z.literal('VIDEO_P75_COMBINED_2'),
        z.literal('VIDEO_P95_COMBINED_2'),
        z.literal('VIDEO_MRC_VIEWS_2'),
        z.literal('PAID_VIDEO_VIEWABLE_RATE'),
        z.literal('VIDEO_LENGTH'),
        z.literal('ECPV_IN_DOLLAR'),
        z.literal('ECPCV_IN_DOLLAR'),
        z.literal('ECPCV_P95_IN_DOLLAR'),
        z.literal('TOTAL_VIDEO_3SEC_VIEWS'),
        z.literal('TOTAL_VIDEO_P100_COMPLETE'),
        z.literal('TOTAL_VIDEO_P0_COMBINED'),
        z.literal('TOTAL_VIDEO_P25_COMBINED'),
        z.literal('TOTAL_VIDEO_P50_COMBINED'),
        z.literal('TOTAL_VIDEO_P75_COMBINED'),
        z.literal('TOTAL_VIDEO_P95_COMBINED'),
        z.literal('TOTAL_VIDEO_MRC_VIEWS'),
        z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'),
        z.literal('TOTAL_REPIN_RATE'),
        z.literal('WEB_CHECKOUT_COST_PER_ACTION'),
        z.literal('WEB_CHECKOUT_ROAS'),
        z.literal('TOTAL_WEB_CHECKOUT'),
        z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('INAPP_CHECKOUT_COST_PER_ACTION'),
        z.literal('TOTAL_OFFLINE_CHECKOUT'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_1'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_2'),
        z.literal('TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'),
        z.literal('LEADS'),
        z.literal('COST_PER_LEAD'),
        z.literal('QUIZ_COMPLETED'),
        z.literal('QUIZ_PIN_RESULT_OPEN'),
        z.literal('QUIZ_COMPLETION_RATE'),
        z.literal('SHOWCASE_PIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_IMPRESSION'),
        z.literal('SHOWCASE_SUBPIN_IMPRESSION'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPAGE_REPIN'),
        z.literal('SHOWCASE_SUBPIN_REPIN'),
        z.literal('SHOWCASE_SUBPAGE_CLOSEUP'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'),
        z.literal('SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_RATE'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_RATE'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_RATE'),
        z.literal('TOTAL_SIGNUP_CONVERSION_RATE'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_RATE'),
        z.literal('TOTAL_LEAD_CONVERSION_RATE'),
        z.literal('TOTAL_SEARCH_CONVERSION_RATE'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_RATE'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_RATE'),
        z.literal('TOTAL_CUSTOM_CONVERSION_RATE'),
      ]),
    ),
    conversion_report_time: z.union([z.literal('TIME_OF_AD_ACTION'), z.literal('TIME_OF_CONVERSION')]).optional(),
    end_date: z.string(),
    engagement_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    granularity: granularitySchema,
    start_date: z.string(),
    view_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
  }),
});

export const adGroupsAnalyticsResponse2Schema = adGroupsAnalyticsResponseSchema;

export const adGroupsAnalyticsErrorSchema = errorSchema;

export const adGroupsTargetingAnalyticsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    ad_group_ids: z.array(z.string()),
    attribution_types: conversionReportAttributionTypeSchema.optional(),
    click_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    columns: z.array(
      z.union([
        z.literal('SPEND_IN_MICRO_DOLLAR'),
        z.literal('PAID_IMPRESSION'),
        z.literal('SPEND_IN_DOLLAR'),
        z.literal('CPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_DOLLAR'),
        z.literal('CTR'),
        z.literal('ECTR'),
        z.literal('CAMPAIGN_NAME'),
        z.literal('PIN_ID'),
        z.literal('TOTAL_ENGAGEMENT'),
        z.literal('ENGAGEMENT_1'),
        z.literal('ENGAGEMENT_2'),
        z.literal('ECPE_IN_DOLLAR'),
        z.literal('ENGAGEMENT_RATE'),
        z.literal('EENGAGEMENT_RATE'),
        z.literal('ECPM_IN_MICRO_DOLLAR'),
        z.literal('REPIN_RATE'),
        z.literal('CTR_2'),
        z.literal('CAMPAIGN_ID'),
        z.literal('ADVERTISER_ID'),
        z.literal('AD_ACCOUNT_ID'),
        z.literal('PIN_PROMOTION_ID'),
        z.literal('AD_ID'),
        z.literal('AD_GROUP_ID'),
        z.literal('CAMPAIGN_ENTITY_STATUS'),
        z.literal('CAMPAIGN_OBJECTIVE_TYPE'),
        z.literal('CPM_IN_MICRO_DOLLAR'),
        z.literal('CPM_IN_DOLLAR'),
        z.literal('AD_GROUP_ENTITY_STATUS'),
        z.literal('ORDER_LINE_ID'),
        z.literal('ORDER_LINE_NAME'),
        z.literal('CLICKTHROUGH_1'),
        z.literal('REPIN_1'),
        z.literal('IMPRESSION_1'),
        z.literal('IMPRESSION_1_GROSS'),
        z.literal('CLICKTHROUGH_1_GROSS'),
        z.literal('OUTBOUND_CLICK_1'),
        z.literal('CLICKTHROUGH_2'),
        z.literal('REPIN_2'),
        z.literal('IMPRESSION_2'),
        z.literal('OUTBOUND_CLICK_2'),
        z.literal('TOTAL_CLICKTHROUGH'),
        z.literal('TOTAL_IMPRESSION'),
        z.literal('TOTAL_IMPRESSION_USER'),
        z.literal('TOTAL_IMPRESSION_FREQUENCY'),
        z.literal('COST_PER_OUTBOUND_CLICK_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_ENGAGEMENT_LEAD'),
        z.literal('TOTAL_CLICK_SIGNUP'),
        z.literal('TOTAL_CLICK_CHECKOUT'),
        z.literal('TOTAL_CLICK_ADD_TO_CART'),
        z.literal('TOTAL_CLICK_LEAD'),
        z.literal('TOTAL_VIEW_SIGNUP'),
        z.literal('TOTAL_VIEW_CHECKOUT'),
        z.literal('TOTAL_VIEW_ADD_TO_CART'),
        z.literal('TOTAL_VIEW_LEAD'),
        z.literal('TOTAL_CONVERSIONS'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_SESSIONS'),
        z.literal('WEB_SESSIONS_1'),
        z.literal('WEB_SESSIONS_2'),
        z.literal('CAMPAIGN_LIFETIME_SPEND_CAP'),
        z.literal('CAMPAIGN_DAILY_SPEND_CAP'),
        z.literal('TOTAL_PAGE_VISIT'),
        z.literal('TOTAL_SIGNUP'),
        z.literal('TOTAL_CHECKOUT'),
        z.literal('TOTAL_CUSTOM'),
        z.literal('TOTAL_LEAD'),
        z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('PAGE_VISIT_COST_PER_ACTION'),
        z.literal('PAGE_VISIT_ROAS'),
        z.literal('CHECKOUT_ROAS'),
        z.literal('CUSTOM_ROAS'),
        z.literal('VIDEO_MRC_VIEWS_1'),
        z.literal('VIDEO_3SEC_VIEWS_2'),
        z.literal('VIDEO_P100_COMPLETE_2'),
        z.literal('VIDEO_P0_COMBINED_2'),
        z.literal('VIDEO_P25_COMBINED_2'),
        z.literal('VIDEO_P50_COMBINED_2'),
        z.literal('VIDEO_P75_COMBINED_2'),
        z.literal('VIDEO_P95_COMBINED_2'),
        z.literal('VIDEO_MRC_VIEWS_2'),
        z.literal('PAID_VIDEO_VIEWABLE_RATE'),
        z.literal('VIDEO_LENGTH'),
        z.literal('ECPV_IN_DOLLAR'),
        z.literal('ECPCV_IN_DOLLAR'),
        z.literal('ECPCV_P95_IN_DOLLAR'),
        z.literal('TOTAL_VIDEO_3SEC_VIEWS'),
        z.literal('TOTAL_VIDEO_P100_COMPLETE'),
        z.literal('TOTAL_VIDEO_P0_COMBINED'),
        z.literal('TOTAL_VIDEO_P25_COMBINED'),
        z.literal('TOTAL_VIDEO_P50_COMBINED'),
        z.literal('TOTAL_VIDEO_P75_COMBINED'),
        z.literal('TOTAL_VIDEO_P95_COMBINED'),
        z.literal('TOTAL_VIDEO_MRC_VIEWS'),
        z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'),
        z.literal('TOTAL_REPIN_RATE'),
        z.literal('WEB_CHECKOUT_COST_PER_ACTION'),
        z.literal('WEB_CHECKOUT_ROAS'),
        z.literal('TOTAL_WEB_CHECKOUT'),
        z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('INAPP_CHECKOUT_COST_PER_ACTION'),
        z.literal('TOTAL_OFFLINE_CHECKOUT'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_1'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_2'),
        z.literal('TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'),
        z.literal('LEADS'),
        z.literal('COST_PER_LEAD'),
        z.literal('QUIZ_COMPLETED'),
        z.literal('QUIZ_PIN_RESULT_OPEN'),
        z.literal('QUIZ_COMPLETION_RATE'),
        z.literal('SHOWCASE_PIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_IMPRESSION'),
        z.literal('SHOWCASE_SUBPIN_IMPRESSION'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPAGE_REPIN'),
        z.literal('SHOWCASE_SUBPIN_REPIN'),
        z.literal('SHOWCASE_SUBPAGE_CLOSEUP'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'),
        z.literal('SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_RATE'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_RATE'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_RATE'),
        z.literal('TOTAL_SIGNUP_CONVERSION_RATE'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_RATE'),
        z.literal('TOTAL_LEAD_CONVERSION_RATE'),
        z.literal('TOTAL_SEARCH_CONVERSION_RATE'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_RATE'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_RATE'),
        z.literal('TOTAL_CUSTOM_CONVERSION_RATE'),
      ]),
    ),
    conversion_report_time: z.union([z.literal('TIME_OF_AD_ACTION'), z.literal('TIME_OF_CONVERSION')]).optional(),
    end_date: z.string(),
    engagement_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    granularity: granularitySchema,
    start_date: z.string(),
    targeting_types: z.array(adsAnalyticsTargetingTypeSchema),
    view_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
  }),
});

export const adGroupsTargetingAnalyticsGetResponseSchema = metricsResponseSchema;

export const adGroupsTargetingAnalyticsGetErrorSchema = errorSchema;

export const adGroupAudienceSizingRequestSchema = z.object({
  auto_targeting_enabled: z.boolean().optional(),
  placement_group: placementGroupTypeSchema.optional(),
  creative_types: z
    .array(
      z.union([
        z.literal('REGULAR'),
        z.literal('VIDEO'),
        z.literal('SHOPPING'),
        z.literal('CAROUSEL'),
        z.literal('MAX_VIDEO'),
        z.literal('SHOP_THE_PIN'),
        z.literal('COLLECTION'),
        z.literal('IDEA'),
      ]),
    )
    .optional()
    .nullable(),
  targeting_spec: targetingSpecSchema.optional(),
  product_group_ids: z.array(z.string()).optional().nullable(),
  keywords: z
    .array(
      z.object({
        match_type: matchTypeResponseSchema,
        value: z.string(),
      }),
    )
    .optional()
    .nullable(),
});

export const adGroupsAudienceSizingResponseSchema = adGroupAudienceSizingResponseSchema;

export const adGroupsAudienceSizingErrorSchema = errorSchema;

export const adGroupsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    ad_group_id: z.string(),
  }),
});

export const adGroupResponseSchema = adGroupCommonSchema.and(
  z.object({
    id: z.string().optional(),
    ad_account_id: z.string().optional(),
    created_time: z.number().optional(),
    updated_time: z.number().optional(),
    type: z.string().optional(),
    conversion_learning_mode_type: z
      .union([z.literal('NOT_ACTIVE'), z.literal('ACTIVE')])
      .optional()
      .nullable(),
    summary_status: adGroupSummaryStatusSchema.optional(),
    feed_profile_id: z.string().optional(),
    dca_assets: z.unknown().optional(),
  }),
);

export const adGroupsGetErrorSchema = errorSchema;

export const adPreviewsCreateDataSchema = z.object({
  body: adPreviewRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const adPreviewsCreateResponseSchema = adPreviewURLResponseSchema;

export const adPreviewsCreateErrorSchema = errorSchema;

export const adsListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      ad_group_ids: z.array(z.string()).optional(),
      ad_ids: z.array(z.string()).optional(),
      bookmark: z.string().optional(),
      campaign_ids: z.array(z.string()).optional(),
      entity_statuses: z
        .array(
          z.union([
            z.literal('ACTIVE'),
            z.literal('PAUSED'),
            z.literal('ARCHIVED'),
            z.literal('DRAFT'),
            z.literal('DELETED_DRAFT'),
          ]),
        )
        .optional(),
      order: z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const adsListErrorSchema = errorSchema;

export const adsCreateErrorSchema = errorSchema;

export const adsUpdateErrorSchema = errorSchema;

export const adsAnalyticsDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    ad_ids: z.array(z.string()).optional(),
    campaign_ids: z.array(z.string()).optional(),
    click_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    columns: z.array(
      z.union([
        z.literal('SPEND_IN_MICRO_DOLLAR'),
        z.literal('PAID_IMPRESSION'),
        z.literal('SPEND_IN_DOLLAR'),
        z.literal('CPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_DOLLAR'),
        z.literal('CTR'),
        z.literal('ECTR'),
        z.literal('CAMPAIGN_NAME'),
        z.literal('PIN_ID'),
        z.literal('TOTAL_ENGAGEMENT'),
        z.literal('ENGAGEMENT_1'),
        z.literal('ENGAGEMENT_2'),
        z.literal('ECPE_IN_DOLLAR'),
        z.literal('ENGAGEMENT_RATE'),
        z.literal('EENGAGEMENT_RATE'),
        z.literal('ECPM_IN_MICRO_DOLLAR'),
        z.literal('REPIN_RATE'),
        z.literal('CTR_2'),
        z.literal('CAMPAIGN_ID'),
        z.literal('ADVERTISER_ID'),
        z.literal('AD_ACCOUNT_ID'),
        z.literal('PIN_PROMOTION_ID'),
        z.literal('AD_ID'),
        z.literal('AD_GROUP_ID'),
        z.literal('CAMPAIGN_ENTITY_STATUS'),
        z.literal('CAMPAIGN_OBJECTIVE_TYPE'),
        z.literal('CPM_IN_MICRO_DOLLAR'),
        z.literal('CPM_IN_DOLLAR'),
        z.literal('AD_GROUP_ENTITY_STATUS'),
        z.literal('ORDER_LINE_ID'),
        z.literal('ORDER_LINE_NAME'),
        z.literal('CLICKTHROUGH_1'),
        z.literal('REPIN_1'),
        z.literal('IMPRESSION_1'),
        z.literal('IMPRESSION_1_GROSS'),
        z.literal('CLICKTHROUGH_1_GROSS'),
        z.literal('OUTBOUND_CLICK_1'),
        z.literal('CLICKTHROUGH_2'),
        z.literal('REPIN_2'),
        z.literal('IMPRESSION_2'),
        z.literal('OUTBOUND_CLICK_2'),
        z.literal('TOTAL_CLICKTHROUGH'),
        z.literal('TOTAL_IMPRESSION'),
        z.literal('TOTAL_IMPRESSION_USER'),
        z.literal('TOTAL_IMPRESSION_FREQUENCY'),
        z.literal('COST_PER_OUTBOUND_CLICK_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_ENGAGEMENT_LEAD'),
        z.literal('TOTAL_CLICK_SIGNUP'),
        z.literal('TOTAL_CLICK_CHECKOUT'),
        z.literal('TOTAL_CLICK_ADD_TO_CART'),
        z.literal('TOTAL_CLICK_LEAD'),
        z.literal('TOTAL_VIEW_SIGNUP'),
        z.literal('TOTAL_VIEW_CHECKOUT'),
        z.literal('TOTAL_VIEW_ADD_TO_CART'),
        z.literal('TOTAL_VIEW_LEAD'),
        z.literal('TOTAL_CONVERSIONS'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_SESSIONS'),
        z.literal('WEB_SESSIONS_1'),
        z.literal('WEB_SESSIONS_2'),
        z.literal('CAMPAIGN_LIFETIME_SPEND_CAP'),
        z.literal('CAMPAIGN_DAILY_SPEND_CAP'),
        z.literal('TOTAL_PAGE_VISIT'),
        z.literal('TOTAL_SIGNUP'),
        z.literal('TOTAL_CHECKOUT'),
        z.literal('TOTAL_CUSTOM'),
        z.literal('TOTAL_LEAD'),
        z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('PAGE_VISIT_COST_PER_ACTION'),
        z.literal('PAGE_VISIT_ROAS'),
        z.literal('CHECKOUT_ROAS'),
        z.literal('CUSTOM_ROAS'),
        z.literal('VIDEO_MRC_VIEWS_1'),
        z.literal('VIDEO_3SEC_VIEWS_2'),
        z.literal('VIDEO_P100_COMPLETE_2'),
        z.literal('VIDEO_P0_COMBINED_2'),
        z.literal('VIDEO_P25_COMBINED_2'),
        z.literal('VIDEO_P50_COMBINED_2'),
        z.literal('VIDEO_P75_COMBINED_2'),
        z.literal('VIDEO_P95_COMBINED_2'),
        z.literal('VIDEO_MRC_VIEWS_2'),
        z.literal('PAID_VIDEO_VIEWABLE_RATE'),
        z.literal('VIDEO_LENGTH'),
        z.literal('ECPV_IN_DOLLAR'),
        z.literal('ECPCV_IN_DOLLAR'),
        z.literal('ECPCV_P95_IN_DOLLAR'),
        z.literal('TOTAL_VIDEO_3SEC_VIEWS'),
        z.literal('TOTAL_VIDEO_P100_COMPLETE'),
        z.literal('TOTAL_VIDEO_P0_COMBINED'),
        z.literal('TOTAL_VIDEO_P25_COMBINED'),
        z.literal('TOTAL_VIDEO_P50_COMBINED'),
        z.literal('TOTAL_VIDEO_P75_COMBINED'),
        z.literal('TOTAL_VIDEO_P95_COMBINED'),
        z.literal('TOTAL_VIDEO_MRC_VIEWS'),
        z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'),
        z.literal('TOTAL_REPIN_RATE'),
        z.literal('WEB_CHECKOUT_COST_PER_ACTION'),
        z.literal('WEB_CHECKOUT_ROAS'),
        z.literal('TOTAL_WEB_CHECKOUT'),
        z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('INAPP_CHECKOUT_COST_PER_ACTION'),
        z.literal('TOTAL_OFFLINE_CHECKOUT'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_1'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_2'),
        z.literal('TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'),
        z.literal('LEADS'),
        z.literal('COST_PER_LEAD'),
        z.literal('QUIZ_COMPLETED'),
        z.literal('QUIZ_PIN_RESULT_OPEN'),
        z.literal('QUIZ_COMPLETION_RATE'),
        z.literal('SHOWCASE_PIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_IMPRESSION'),
        z.literal('SHOWCASE_SUBPIN_IMPRESSION'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPAGE_REPIN'),
        z.literal('SHOWCASE_SUBPIN_REPIN'),
        z.literal('SHOWCASE_SUBPAGE_CLOSEUP'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'),
        z.literal('SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_RATE'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_RATE'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_RATE'),
        z.literal('TOTAL_SIGNUP_CONVERSION_RATE'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_RATE'),
        z.literal('TOTAL_LEAD_CONVERSION_RATE'),
        z.literal('TOTAL_SEARCH_CONVERSION_RATE'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_RATE'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_RATE'),
        z.literal('TOTAL_CUSTOM_CONVERSION_RATE'),
      ]),
    ),
    conversion_report_time: z.union([z.literal('TIME_OF_AD_ACTION'), z.literal('TIME_OF_CONVERSION')]).optional(),
    end_date: z.string(),
    engagement_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    granularity: granularitySchema,
    pin_ids: z.array(z.string()).optional(),
    start_date: z.string(),
    view_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
  }),
});

export const adsAnalyticsResponse2Schema = adsAnalyticsResponseSchema;

export const adsAnalyticsErrorSchema = errorSchema;

export const adsCreditsDiscountsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const adsCreditsDiscountsGetResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(adsCreditDiscountsResponseSchema).optional(),
  }),
);

export const adsCreditsDiscountsGetErrorSchema = errorSchema;

export const adsCreditRedeemDataSchema = z.object({
  body: adsCreditRedeemRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const adsCreditRedeemResponse2Schema = adsCreditRedeemResponseSchema;

export const adsCreditRedeemErrorSchema = errorSchema;

export const adTargetingAnalyticsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    ad_ids: z.array(z.string()),
    attribution_types: conversionReportAttributionTypeSchema.optional(),
    click_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    columns: z.array(
      z.union([
        z.literal('SPEND_IN_MICRO_DOLLAR'),
        z.literal('PAID_IMPRESSION'),
        z.literal('SPEND_IN_DOLLAR'),
        z.literal('CPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_DOLLAR'),
        z.literal('CTR'),
        z.literal('ECTR'),
        z.literal('CAMPAIGN_NAME'),
        z.literal('PIN_ID'),
        z.literal('TOTAL_ENGAGEMENT'),
        z.literal('ENGAGEMENT_1'),
        z.literal('ENGAGEMENT_2'),
        z.literal('ECPE_IN_DOLLAR'),
        z.literal('ENGAGEMENT_RATE'),
        z.literal('EENGAGEMENT_RATE'),
        z.literal('ECPM_IN_MICRO_DOLLAR'),
        z.literal('REPIN_RATE'),
        z.literal('CTR_2'),
        z.literal('CAMPAIGN_ID'),
        z.literal('ADVERTISER_ID'),
        z.literal('AD_ACCOUNT_ID'),
        z.literal('PIN_PROMOTION_ID'),
        z.literal('AD_ID'),
        z.literal('AD_GROUP_ID'),
        z.literal('CAMPAIGN_ENTITY_STATUS'),
        z.literal('CAMPAIGN_OBJECTIVE_TYPE'),
        z.literal('CPM_IN_MICRO_DOLLAR'),
        z.literal('CPM_IN_DOLLAR'),
        z.literal('AD_GROUP_ENTITY_STATUS'),
        z.literal('ORDER_LINE_ID'),
        z.literal('ORDER_LINE_NAME'),
        z.literal('CLICKTHROUGH_1'),
        z.literal('REPIN_1'),
        z.literal('IMPRESSION_1'),
        z.literal('IMPRESSION_1_GROSS'),
        z.literal('CLICKTHROUGH_1_GROSS'),
        z.literal('OUTBOUND_CLICK_1'),
        z.literal('CLICKTHROUGH_2'),
        z.literal('REPIN_2'),
        z.literal('IMPRESSION_2'),
        z.literal('OUTBOUND_CLICK_2'),
        z.literal('TOTAL_CLICKTHROUGH'),
        z.literal('TOTAL_IMPRESSION'),
        z.literal('TOTAL_IMPRESSION_USER'),
        z.literal('TOTAL_IMPRESSION_FREQUENCY'),
        z.literal('COST_PER_OUTBOUND_CLICK_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_ENGAGEMENT_LEAD'),
        z.literal('TOTAL_CLICK_SIGNUP'),
        z.literal('TOTAL_CLICK_CHECKOUT'),
        z.literal('TOTAL_CLICK_ADD_TO_CART'),
        z.literal('TOTAL_CLICK_LEAD'),
        z.literal('TOTAL_VIEW_SIGNUP'),
        z.literal('TOTAL_VIEW_CHECKOUT'),
        z.literal('TOTAL_VIEW_ADD_TO_CART'),
        z.literal('TOTAL_VIEW_LEAD'),
        z.literal('TOTAL_CONVERSIONS'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_SESSIONS'),
        z.literal('WEB_SESSIONS_1'),
        z.literal('WEB_SESSIONS_2'),
        z.literal('CAMPAIGN_LIFETIME_SPEND_CAP'),
        z.literal('CAMPAIGN_DAILY_SPEND_CAP'),
        z.literal('TOTAL_PAGE_VISIT'),
        z.literal('TOTAL_SIGNUP'),
        z.literal('TOTAL_CHECKOUT'),
        z.literal('TOTAL_CUSTOM'),
        z.literal('TOTAL_LEAD'),
        z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('PAGE_VISIT_COST_PER_ACTION'),
        z.literal('PAGE_VISIT_ROAS'),
        z.literal('CHECKOUT_ROAS'),
        z.literal('CUSTOM_ROAS'),
        z.literal('VIDEO_MRC_VIEWS_1'),
        z.literal('VIDEO_3SEC_VIEWS_2'),
        z.literal('VIDEO_P100_COMPLETE_2'),
        z.literal('VIDEO_P0_COMBINED_2'),
        z.literal('VIDEO_P25_COMBINED_2'),
        z.literal('VIDEO_P50_COMBINED_2'),
        z.literal('VIDEO_P75_COMBINED_2'),
        z.literal('VIDEO_P95_COMBINED_2'),
        z.literal('VIDEO_MRC_VIEWS_2'),
        z.literal('PAID_VIDEO_VIEWABLE_RATE'),
        z.literal('VIDEO_LENGTH'),
        z.literal('ECPV_IN_DOLLAR'),
        z.literal('ECPCV_IN_DOLLAR'),
        z.literal('ECPCV_P95_IN_DOLLAR'),
        z.literal('TOTAL_VIDEO_3SEC_VIEWS'),
        z.literal('TOTAL_VIDEO_P100_COMPLETE'),
        z.literal('TOTAL_VIDEO_P0_COMBINED'),
        z.literal('TOTAL_VIDEO_P25_COMBINED'),
        z.literal('TOTAL_VIDEO_P50_COMBINED'),
        z.literal('TOTAL_VIDEO_P75_COMBINED'),
        z.literal('TOTAL_VIDEO_P95_COMBINED'),
        z.literal('TOTAL_VIDEO_MRC_VIEWS'),
        z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'),
        z.literal('TOTAL_REPIN_RATE'),
        z.literal('WEB_CHECKOUT_COST_PER_ACTION'),
        z.literal('WEB_CHECKOUT_ROAS'),
        z.literal('TOTAL_WEB_CHECKOUT'),
        z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('INAPP_CHECKOUT_COST_PER_ACTION'),
        z.literal('TOTAL_OFFLINE_CHECKOUT'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_1'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_2'),
        z.literal('TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'),
        z.literal('LEADS'),
        z.literal('COST_PER_LEAD'),
        z.literal('QUIZ_COMPLETED'),
        z.literal('QUIZ_PIN_RESULT_OPEN'),
        z.literal('QUIZ_COMPLETION_RATE'),
        z.literal('SHOWCASE_PIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_IMPRESSION'),
        z.literal('SHOWCASE_SUBPIN_IMPRESSION'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPAGE_REPIN'),
        z.literal('SHOWCASE_SUBPIN_REPIN'),
        z.literal('SHOWCASE_SUBPAGE_CLOSEUP'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'),
        z.literal('SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_RATE'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_RATE'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_RATE'),
        z.literal('TOTAL_SIGNUP_CONVERSION_RATE'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_RATE'),
        z.literal('TOTAL_LEAD_CONVERSION_RATE'),
        z.literal('TOTAL_SEARCH_CONVERSION_RATE'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_RATE'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_RATE'),
        z.literal('TOTAL_CUSTOM_CONVERSION_RATE'),
      ]),
    ),
    conversion_report_time: z.union([z.literal('TIME_OF_AD_ACTION'), z.literal('TIME_OF_CONVERSION')]).optional(),
    end_date: z.string(),
    engagement_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    granularity: granularitySchema,
    start_date: z.string(),
    targeting_types: z.array(adsAnalyticsAdTargetingTypeSchema),
    view_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
  }),
});

export const adTargetingAnalyticsGetResponseSchema = metricsResponseSchema;

export const adTargetingAnalyticsGetErrorSchema = errorSchema;

export const adsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    ad_id: z.string(),
  }),
});

export const adsGetErrorSchema = errorSchema;

export const adAccountAnalyticsDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    click_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    columns: z.array(
      z.union([
        z.literal('SPEND_IN_MICRO_DOLLAR'),
        z.literal('PAID_IMPRESSION'),
        z.literal('SPEND_IN_DOLLAR'),
        z.literal('CPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_DOLLAR'),
        z.literal('CTR'),
        z.literal('ECTR'),
        z.literal('CAMPAIGN_NAME'),
        z.literal('PIN_ID'),
        z.literal('TOTAL_ENGAGEMENT'),
        z.literal('ENGAGEMENT_1'),
        z.literal('ENGAGEMENT_2'),
        z.literal('ECPE_IN_DOLLAR'),
        z.literal('ENGAGEMENT_RATE'),
        z.literal('EENGAGEMENT_RATE'),
        z.literal('ECPM_IN_MICRO_DOLLAR'),
        z.literal('REPIN_RATE'),
        z.literal('CTR_2'),
        z.literal('CAMPAIGN_ID'),
        z.literal('ADVERTISER_ID'),
        z.literal('AD_ACCOUNT_ID'),
        z.literal('PIN_PROMOTION_ID'),
        z.literal('AD_ID'),
        z.literal('AD_GROUP_ID'),
        z.literal('CAMPAIGN_ENTITY_STATUS'),
        z.literal('CAMPAIGN_OBJECTIVE_TYPE'),
        z.literal('CPM_IN_MICRO_DOLLAR'),
        z.literal('CPM_IN_DOLLAR'),
        z.literal('AD_GROUP_ENTITY_STATUS'),
        z.literal('ORDER_LINE_ID'),
        z.literal('ORDER_LINE_NAME'),
        z.literal('CLICKTHROUGH_1'),
        z.literal('REPIN_1'),
        z.literal('IMPRESSION_1'),
        z.literal('IMPRESSION_1_GROSS'),
        z.literal('CLICKTHROUGH_1_GROSS'),
        z.literal('OUTBOUND_CLICK_1'),
        z.literal('CLICKTHROUGH_2'),
        z.literal('REPIN_2'),
        z.literal('IMPRESSION_2'),
        z.literal('OUTBOUND_CLICK_2'),
        z.literal('TOTAL_CLICKTHROUGH'),
        z.literal('TOTAL_IMPRESSION'),
        z.literal('TOTAL_IMPRESSION_USER'),
        z.literal('TOTAL_IMPRESSION_FREQUENCY'),
        z.literal('COST_PER_OUTBOUND_CLICK_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_ENGAGEMENT_LEAD'),
        z.literal('TOTAL_CLICK_SIGNUP'),
        z.literal('TOTAL_CLICK_CHECKOUT'),
        z.literal('TOTAL_CLICK_ADD_TO_CART'),
        z.literal('TOTAL_CLICK_LEAD'),
        z.literal('TOTAL_VIEW_SIGNUP'),
        z.literal('TOTAL_VIEW_CHECKOUT'),
        z.literal('TOTAL_VIEW_ADD_TO_CART'),
        z.literal('TOTAL_VIEW_LEAD'),
        z.literal('TOTAL_CONVERSIONS'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_SESSIONS'),
        z.literal('WEB_SESSIONS_1'),
        z.literal('WEB_SESSIONS_2'),
        z.literal('CAMPAIGN_LIFETIME_SPEND_CAP'),
        z.literal('CAMPAIGN_DAILY_SPEND_CAP'),
        z.literal('TOTAL_PAGE_VISIT'),
        z.literal('TOTAL_SIGNUP'),
        z.literal('TOTAL_CHECKOUT'),
        z.literal('TOTAL_CUSTOM'),
        z.literal('TOTAL_LEAD'),
        z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('PAGE_VISIT_COST_PER_ACTION'),
        z.literal('PAGE_VISIT_ROAS'),
        z.literal('CHECKOUT_ROAS'),
        z.literal('CUSTOM_ROAS'),
        z.literal('VIDEO_MRC_VIEWS_1'),
        z.literal('VIDEO_3SEC_VIEWS_2'),
        z.literal('VIDEO_P100_COMPLETE_2'),
        z.literal('VIDEO_P0_COMBINED_2'),
        z.literal('VIDEO_P25_COMBINED_2'),
        z.literal('VIDEO_P50_COMBINED_2'),
        z.literal('VIDEO_P75_COMBINED_2'),
        z.literal('VIDEO_P95_COMBINED_2'),
        z.literal('VIDEO_MRC_VIEWS_2'),
        z.literal('PAID_VIDEO_VIEWABLE_RATE'),
        z.literal('VIDEO_LENGTH'),
        z.literal('ECPV_IN_DOLLAR'),
        z.literal('ECPCV_IN_DOLLAR'),
        z.literal('ECPCV_P95_IN_DOLLAR'),
        z.literal('TOTAL_VIDEO_3SEC_VIEWS'),
        z.literal('TOTAL_VIDEO_P100_COMPLETE'),
        z.literal('TOTAL_VIDEO_P0_COMBINED'),
        z.literal('TOTAL_VIDEO_P25_COMBINED'),
        z.literal('TOTAL_VIDEO_P50_COMBINED'),
        z.literal('TOTAL_VIDEO_P75_COMBINED'),
        z.literal('TOTAL_VIDEO_P95_COMBINED'),
        z.literal('TOTAL_VIDEO_MRC_VIEWS'),
        z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'),
        z.literal('TOTAL_REPIN_RATE'),
        z.literal('WEB_CHECKOUT_COST_PER_ACTION'),
        z.literal('WEB_CHECKOUT_ROAS'),
        z.literal('TOTAL_WEB_CHECKOUT'),
        z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('INAPP_CHECKOUT_COST_PER_ACTION'),
        z.literal('TOTAL_OFFLINE_CHECKOUT'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_1'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_2'),
        z.literal('TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'),
        z.literal('LEADS'),
        z.literal('COST_PER_LEAD'),
        z.literal('QUIZ_COMPLETED'),
        z.literal('QUIZ_PIN_RESULT_OPEN'),
        z.literal('QUIZ_COMPLETION_RATE'),
        z.literal('SHOWCASE_PIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_IMPRESSION'),
        z.literal('SHOWCASE_SUBPIN_IMPRESSION'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPAGE_REPIN'),
        z.literal('SHOWCASE_SUBPIN_REPIN'),
        z.literal('SHOWCASE_SUBPAGE_CLOSEUP'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'),
        z.literal('SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_RATE'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_RATE'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_RATE'),
        z.literal('TOTAL_SIGNUP_CONVERSION_RATE'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_RATE'),
        z.literal('TOTAL_LEAD_CONVERSION_RATE'),
        z.literal('TOTAL_SEARCH_CONVERSION_RATE'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_RATE'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_RATE'),
        z.literal('TOTAL_CUSTOM_CONVERSION_RATE'),
      ]),
    ),
    conversion_report_time: z.union([z.literal('TIME_OF_AD_ACTION'), z.literal('TIME_OF_CONVERSION')]).optional(),
    end_date: z.string(),
    engagement_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    granularity: granularitySchema,
    start_date: z.string(),
    view_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
  }),
});

export const adAccountAnalyticsResponse2Schema = adAccountAnalyticsResponseSchema;

export const adAccountAnalyticsErrorSchema = errorSchema;

export const audienceInsightsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    audience_insight_type: audienceInsightTypeSchema,
  }),
});

export const audienceInsightsGetResponseSchema = audienceInsightsResponseSchema;

export const audienceInsightsGetErrorSchema = errorSchema;

export const audiencesListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      order: z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
      ownership_type: z.union([z.literal('OWNED'), z.literal('RECEIVED')]).optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const audiencesListErrorSchema = errorSchema;

export const audienceCreateRequestSchema = audienceCommonSchema.and(
  z.object({
    description: audienceDescriptionSchema.optional(),
    audience_type: audienceTypeSchema.and(z.unknown()),
  }),
);

export const audienceSchema = z.object({
  ad_account_id: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  audience_type: z.string().optional(),
  description: z.string().optional().nullable(),
  rule: audienceRuleSchema.optional(),
  size: z.number().optional().nullable(),
  status: z.string().optional(),
  type: z.string().optional(),
  created_timestamp: z.number().optional().nullable(),
  updated_timestamp: z.number().optional().nullable(),
});

export const audiencesCreateErrorSchema = errorSchema;

export const audiencesGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    audience_id: z.string(),
  }),
});

export const audiencesGetResponseSchema = audienceSchema;

export const audiencesGetErrorSchema = errorSchema;

export const audiencesUpdateDataSchema = z.object({
  body: audienceUpdateRequestSchema.optional(),
  path: z.object({
    ad_account_id: z.string(),
    audience_id: z.string(),
  }),
});

export const audiencesUpdateResponseSchema = audienceSchema;

export const audiencesUpdateErrorSchema = errorSchema;

export const audienceCreateCustomRequestSchema = audienceCommonSchema.and(
  z.object({
    sharing_type: audienceSharingTypeSchema,
    data_party: audienceDataPartySchema,
    category: z.string().optional(),
  }),
);

export const audiencesCreateCustomResponseSchema = audienceSchema;

export const audiencesCreateCustomErrorSchema = errorSchema;

export const adAccountsAudiencesSharedAccountsListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    account_type: audienceAccountTypeSchema,
    audience_id: z.string(),
    bookmark: z.string().optional(),
    page_size: z.number().optional(),
  }),
});

export const adAccountsAudiencesSharedAccountsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(sharedAudienceAccountSchema).optional(),
  }),
);

export const adAccountsAudiencesSharedAccountsListErrorSchema = errorSchema;

export const updateAdAccountToAdAccountSharedAudienceDataSchema = z.object({
  body: sharedAudienceSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const updateAdAccountToAdAccountSharedAudienceResponseSchema = sharedAudienceResponseSchema;

export const updateAdAccountToAdAccountSharedAudienceErrorSchema = errorSchema;

export const updateAdAccountToBusinessSharedAudienceDataSchema = z.object({
  body: businessSharedAudienceSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const updateAdAccountToBusinessSharedAudienceResponseSchema = businessSharedAudienceResponseSchema;

export const updateAdAccountToBusinessSharedAudienceErrorSchema = errorSchema;

export const adGroupsBidFloorGetDataSchema = z.object({
  body: bidFloorRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const adGroupsBidFloorGetResponseSchema = bidFloorSchema;

export const adGroupsBidFloorGetErrorSchema = errorSchema;

export const billingProfilesGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    bookmark: z.string().optional(),
    is_active: z.boolean(),
    page_size: z.number().optional(),
  }),
});

export const billingProfilesGetResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(billingProfilesResponseSchema).optional(),
  }),
);

export const billingProfilesGetErrorSchema = errorSchema;

export const bulkDownloadRequestSchema = z.object({
  entity_types: z.array(bulkEntityTypeSchema).optional(),
  entity_ids: z.array(z.string()).optional(),
  updated_since: z.string().optional(),
  campaign_filter: z
    .object({
      start_time: z.string().optional(),
      end_time: z.string().optional(),
      name: z.string().optional(),
      campaign_status: z.array(campaignSummaryStatusSchema).optional(),
      objective_type: z.array(objectiveTypeSchema).optional(),
    })
    .optional(),
  output_format: bulkOutputFormatSchema.optional(),
});

export const bulkDownloadCreateResponseSchema = bulkDownloadResponseSchema;

export const bulkDownloadCreateErrorSchema = errorSchema;

export const bulkUpsertCreateResponseSchema = bulkUpsertResponseSchema;

export const bulkUpsertCreateErrorSchema = errorSchema;

export const bulkRequestGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    bulk_request_id: z.string(),
  }),
  query: z
    .object({
      include_details: z.boolean().optional(),
    })
    .optional(),
});

export const bulkRequestGetResponseSchema = bulkUpsertStatusResponseSchema;

export const bulkRequestGetErrorSchema = errorSchema;

export const campaignsListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      campaign_ids: z.array(z.string()).optional(),
      entity_statuses: z
        .array(
          z.union([
            z.literal('ACTIVE'),
            z.literal('PAUSED'),
            z.literal('ARCHIVED'),
            z.literal('DRAFT'),
            z.literal('DELETED_DRAFT'),
          ]),
        )
        .optional(),
      order: z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const campaignsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(campaignResponseSchema).optional(),
  }),
);

export const campaignsListErrorSchema = errorSchema;

export const campaignCreateRequestSchema = campaignCreateCommonSchema.and(
  z.object({
    is_flexible_daily_budgets: campaignIsFlexibleDailyBudgetsSchema.optional(),
    is_automated_campaign: campaignIsAutomatedCampaignSchema.optional(),
    status: entityStatusSchema.optional(),
    objective_type: objectiveTypeSchema,
  }),
);

export const campaignsCreateErrorSchema = errorSchema;

export const campaignsUpdateDataSchema = z.object({
  body: z.array(campaignUpdateRequestSchema),
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const campaignsUpdateErrorSchema = errorSchema;

export const campaignsAnalyticsDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    campaign_ids: z.array(z.string()),
    click_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    columns: z.array(
      z.union([
        z.literal('SPEND_IN_MICRO_DOLLAR'),
        z.literal('PAID_IMPRESSION'),
        z.literal('SPEND_IN_DOLLAR'),
        z.literal('CPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_DOLLAR'),
        z.literal('CTR'),
        z.literal('ECTR'),
        z.literal('CAMPAIGN_NAME'),
        z.literal('PIN_ID'),
        z.literal('TOTAL_ENGAGEMENT'),
        z.literal('ENGAGEMENT_1'),
        z.literal('ENGAGEMENT_2'),
        z.literal('ECPE_IN_DOLLAR'),
        z.literal('ENGAGEMENT_RATE'),
        z.literal('EENGAGEMENT_RATE'),
        z.literal('ECPM_IN_MICRO_DOLLAR'),
        z.literal('REPIN_RATE'),
        z.literal('CTR_2'),
        z.literal('CAMPAIGN_ID'),
        z.literal('ADVERTISER_ID'),
        z.literal('AD_ACCOUNT_ID'),
        z.literal('PIN_PROMOTION_ID'),
        z.literal('AD_ID'),
        z.literal('AD_GROUP_ID'),
        z.literal('CAMPAIGN_ENTITY_STATUS'),
        z.literal('CAMPAIGN_OBJECTIVE_TYPE'),
        z.literal('CPM_IN_MICRO_DOLLAR'),
        z.literal('CPM_IN_DOLLAR'),
        z.literal('AD_GROUP_ENTITY_STATUS'),
        z.literal('ORDER_LINE_ID'),
        z.literal('ORDER_LINE_NAME'),
        z.literal('CLICKTHROUGH_1'),
        z.literal('REPIN_1'),
        z.literal('IMPRESSION_1'),
        z.literal('IMPRESSION_1_GROSS'),
        z.literal('CLICKTHROUGH_1_GROSS'),
        z.literal('OUTBOUND_CLICK_1'),
        z.literal('CLICKTHROUGH_2'),
        z.literal('REPIN_2'),
        z.literal('IMPRESSION_2'),
        z.literal('OUTBOUND_CLICK_2'),
        z.literal('TOTAL_CLICKTHROUGH'),
        z.literal('TOTAL_IMPRESSION'),
        z.literal('TOTAL_IMPRESSION_USER'),
        z.literal('TOTAL_IMPRESSION_FREQUENCY'),
        z.literal('COST_PER_OUTBOUND_CLICK_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_ENGAGEMENT_LEAD'),
        z.literal('TOTAL_CLICK_SIGNUP'),
        z.literal('TOTAL_CLICK_CHECKOUT'),
        z.literal('TOTAL_CLICK_ADD_TO_CART'),
        z.literal('TOTAL_CLICK_LEAD'),
        z.literal('TOTAL_VIEW_SIGNUP'),
        z.literal('TOTAL_VIEW_CHECKOUT'),
        z.literal('TOTAL_VIEW_ADD_TO_CART'),
        z.literal('TOTAL_VIEW_LEAD'),
        z.literal('TOTAL_CONVERSIONS'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_SESSIONS'),
        z.literal('WEB_SESSIONS_1'),
        z.literal('WEB_SESSIONS_2'),
        z.literal('CAMPAIGN_LIFETIME_SPEND_CAP'),
        z.literal('CAMPAIGN_DAILY_SPEND_CAP'),
        z.literal('TOTAL_PAGE_VISIT'),
        z.literal('TOTAL_SIGNUP'),
        z.literal('TOTAL_CHECKOUT'),
        z.literal('TOTAL_CUSTOM'),
        z.literal('TOTAL_LEAD'),
        z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('PAGE_VISIT_COST_PER_ACTION'),
        z.literal('PAGE_VISIT_ROAS'),
        z.literal('CHECKOUT_ROAS'),
        z.literal('CUSTOM_ROAS'),
        z.literal('VIDEO_MRC_VIEWS_1'),
        z.literal('VIDEO_3SEC_VIEWS_2'),
        z.literal('VIDEO_P100_COMPLETE_2'),
        z.literal('VIDEO_P0_COMBINED_2'),
        z.literal('VIDEO_P25_COMBINED_2'),
        z.literal('VIDEO_P50_COMBINED_2'),
        z.literal('VIDEO_P75_COMBINED_2'),
        z.literal('VIDEO_P95_COMBINED_2'),
        z.literal('VIDEO_MRC_VIEWS_2'),
        z.literal('PAID_VIDEO_VIEWABLE_RATE'),
        z.literal('VIDEO_LENGTH'),
        z.literal('ECPV_IN_DOLLAR'),
        z.literal('ECPCV_IN_DOLLAR'),
        z.literal('ECPCV_P95_IN_DOLLAR'),
        z.literal('TOTAL_VIDEO_3SEC_VIEWS'),
        z.literal('TOTAL_VIDEO_P100_COMPLETE'),
        z.literal('TOTAL_VIDEO_P0_COMBINED'),
        z.literal('TOTAL_VIDEO_P25_COMBINED'),
        z.literal('TOTAL_VIDEO_P50_COMBINED'),
        z.literal('TOTAL_VIDEO_P75_COMBINED'),
        z.literal('TOTAL_VIDEO_P95_COMBINED'),
        z.literal('TOTAL_VIDEO_MRC_VIEWS'),
        z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'),
        z.literal('TOTAL_REPIN_RATE'),
        z.literal('WEB_CHECKOUT_COST_PER_ACTION'),
        z.literal('WEB_CHECKOUT_ROAS'),
        z.literal('TOTAL_WEB_CHECKOUT'),
        z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('INAPP_CHECKOUT_COST_PER_ACTION'),
        z.literal('TOTAL_OFFLINE_CHECKOUT'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_1'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_2'),
        z.literal('TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'),
        z.literal('LEADS'),
        z.literal('COST_PER_LEAD'),
        z.literal('QUIZ_COMPLETED'),
        z.literal('QUIZ_PIN_RESULT_OPEN'),
        z.literal('QUIZ_COMPLETION_RATE'),
        z.literal('SHOWCASE_PIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_IMPRESSION'),
        z.literal('SHOWCASE_SUBPIN_IMPRESSION'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPAGE_REPIN'),
        z.literal('SHOWCASE_SUBPIN_REPIN'),
        z.literal('SHOWCASE_SUBPAGE_CLOSEUP'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'),
        z.literal('SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_RATE'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_RATE'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_RATE'),
        z.literal('TOTAL_SIGNUP_CONVERSION_RATE'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_RATE'),
        z.literal('TOTAL_LEAD_CONVERSION_RATE'),
        z.literal('TOTAL_SEARCH_CONVERSION_RATE'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_RATE'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_RATE'),
        z.literal('TOTAL_CUSTOM_CONVERSION_RATE'),
      ]),
    ),
    conversion_report_time: z.union([z.literal('TIME_OF_AD_ACTION'), z.literal('TIME_OF_CONVERSION')]).optional(),
    end_date: z.string(),
    engagement_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    granularity: granularitySchema,
    start_date: z.string(),
    view_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
  }),
});

export const campaignsAnalyticsResponse2Schema = campaignsAnalyticsResponseSchema;

export const campaignsAnalyticsErrorSchema = errorSchema;

export const campaignTargetingAnalyticsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    attribution_types: conversionReportAttributionTypeSchema.optional(),
    campaign_ids: z.array(z.string()),
    click_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    columns: z.array(
      z.union([
        z.literal('SPEND_IN_MICRO_DOLLAR'),
        z.literal('PAID_IMPRESSION'),
        z.literal('SPEND_IN_DOLLAR'),
        z.literal('CPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_DOLLAR'),
        z.literal('CTR'),
        z.literal('ECTR'),
        z.literal('CAMPAIGN_NAME'),
        z.literal('PIN_ID'),
        z.literal('TOTAL_ENGAGEMENT'),
        z.literal('ENGAGEMENT_1'),
        z.literal('ENGAGEMENT_2'),
        z.literal('ECPE_IN_DOLLAR'),
        z.literal('ENGAGEMENT_RATE'),
        z.literal('EENGAGEMENT_RATE'),
        z.literal('ECPM_IN_MICRO_DOLLAR'),
        z.literal('REPIN_RATE'),
        z.literal('CTR_2'),
        z.literal('CAMPAIGN_ID'),
        z.literal('ADVERTISER_ID'),
        z.literal('AD_ACCOUNT_ID'),
        z.literal('PIN_PROMOTION_ID'),
        z.literal('AD_ID'),
        z.literal('AD_GROUP_ID'),
        z.literal('CAMPAIGN_ENTITY_STATUS'),
        z.literal('CAMPAIGN_OBJECTIVE_TYPE'),
        z.literal('CPM_IN_MICRO_DOLLAR'),
        z.literal('CPM_IN_DOLLAR'),
        z.literal('AD_GROUP_ENTITY_STATUS'),
        z.literal('ORDER_LINE_ID'),
        z.literal('ORDER_LINE_NAME'),
        z.literal('CLICKTHROUGH_1'),
        z.literal('REPIN_1'),
        z.literal('IMPRESSION_1'),
        z.literal('IMPRESSION_1_GROSS'),
        z.literal('CLICKTHROUGH_1_GROSS'),
        z.literal('OUTBOUND_CLICK_1'),
        z.literal('CLICKTHROUGH_2'),
        z.literal('REPIN_2'),
        z.literal('IMPRESSION_2'),
        z.literal('OUTBOUND_CLICK_2'),
        z.literal('TOTAL_CLICKTHROUGH'),
        z.literal('TOTAL_IMPRESSION'),
        z.literal('TOTAL_IMPRESSION_USER'),
        z.literal('TOTAL_IMPRESSION_FREQUENCY'),
        z.literal('COST_PER_OUTBOUND_CLICK_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_ENGAGEMENT_LEAD'),
        z.literal('TOTAL_CLICK_SIGNUP'),
        z.literal('TOTAL_CLICK_CHECKOUT'),
        z.literal('TOTAL_CLICK_ADD_TO_CART'),
        z.literal('TOTAL_CLICK_LEAD'),
        z.literal('TOTAL_VIEW_SIGNUP'),
        z.literal('TOTAL_VIEW_CHECKOUT'),
        z.literal('TOTAL_VIEW_ADD_TO_CART'),
        z.literal('TOTAL_VIEW_LEAD'),
        z.literal('TOTAL_CONVERSIONS'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_SESSIONS'),
        z.literal('WEB_SESSIONS_1'),
        z.literal('WEB_SESSIONS_2'),
        z.literal('CAMPAIGN_LIFETIME_SPEND_CAP'),
        z.literal('CAMPAIGN_DAILY_SPEND_CAP'),
        z.literal('TOTAL_PAGE_VISIT'),
        z.literal('TOTAL_SIGNUP'),
        z.literal('TOTAL_CHECKOUT'),
        z.literal('TOTAL_CUSTOM'),
        z.literal('TOTAL_LEAD'),
        z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('PAGE_VISIT_COST_PER_ACTION'),
        z.literal('PAGE_VISIT_ROAS'),
        z.literal('CHECKOUT_ROAS'),
        z.literal('CUSTOM_ROAS'),
        z.literal('VIDEO_MRC_VIEWS_1'),
        z.literal('VIDEO_3SEC_VIEWS_2'),
        z.literal('VIDEO_P100_COMPLETE_2'),
        z.literal('VIDEO_P0_COMBINED_2'),
        z.literal('VIDEO_P25_COMBINED_2'),
        z.literal('VIDEO_P50_COMBINED_2'),
        z.literal('VIDEO_P75_COMBINED_2'),
        z.literal('VIDEO_P95_COMBINED_2'),
        z.literal('VIDEO_MRC_VIEWS_2'),
        z.literal('PAID_VIDEO_VIEWABLE_RATE'),
        z.literal('VIDEO_LENGTH'),
        z.literal('ECPV_IN_DOLLAR'),
        z.literal('ECPCV_IN_DOLLAR'),
        z.literal('ECPCV_P95_IN_DOLLAR'),
        z.literal('TOTAL_VIDEO_3SEC_VIEWS'),
        z.literal('TOTAL_VIDEO_P100_COMPLETE'),
        z.literal('TOTAL_VIDEO_P0_COMBINED'),
        z.literal('TOTAL_VIDEO_P25_COMBINED'),
        z.literal('TOTAL_VIDEO_P50_COMBINED'),
        z.literal('TOTAL_VIDEO_P75_COMBINED'),
        z.literal('TOTAL_VIDEO_P95_COMBINED'),
        z.literal('TOTAL_VIDEO_MRC_VIEWS'),
        z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'),
        z.literal('TOTAL_REPIN_RATE'),
        z.literal('WEB_CHECKOUT_COST_PER_ACTION'),
        z.literal('WEB_CHECKOUT_ROAS'),
        z.literal('TOTAL_WEB_CHECKOUT'),
        z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('INAPP_CHECKOUT_COST_PER_ACTION'),
        z.literal('TOTAL_OFFLINE_CHECKOUT'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_1'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_2'),
        z.literal('TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'),
        z.literal('LEADS'),
        z.literal('COST_PER_LEAD'),
        z.literal('QUIZ_COMPLETED'),
        z.literal('QUIZ_PIN_RESULT_OPEN'),
        z.literal('QUIZ_COMPLETION_RATE'),
        z.literal('SHOWCASE_PIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_IMPRESSION'),
        z.literal('SHOWCASE_SUBPIN_IMPRESSION'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPAGE_REPIN'),
        z.literal('SHOWCASE_SUBPIN_REPIN'),
        z.literal('SHOWCASE_SUBPAGE_CLOSEUP'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'),
        z.literal('SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_RATE'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_RATE'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_RATE'),
        z.literal('TOTAL_SIGNUP_CONVERSION_RATE'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_RATE'),
        z.literal('TOTAL_LEAD_CONVERSION_RATE'),
        z.literal('TOTAL_SEARCH_CONVERSION_RATE'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_RATE'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_RATE'),
        z.literal('TOTAL_CUSTOM_CONVERSION_RATE'),
      ]),
    ),
    conversion_report_time: z.union([z.literal('TIME_OF_AD_ACTION'), z.literal('TIME_OF_CONVERSION')]).optional(),
    end_date: z.string(),
    engagement_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    granularity: granularitySchema,
    start_date: z.string(),
    targeting_types: z.array(adsAnalyticsCampaignTargetingTypeSchema),
    view_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
  }),
});

export const campaignTargetingAnalyticsGetResponseSchema = metricsResponseSchema;

export const campaignTargetingAnalyticsGetErrorSchema = errorSchema;

export const campaignsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    campaign_id: z.string(),
  }),
});

export const campaignsGetResponseSchema = campaignResponseSchema;

export const campaignsGetErrorSchema = errorSchema;

export const conversionTagsListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      filter_deleted: z.boolean().optional(),
    })
    .optional(),
});

export const conversionTagsListErrorSchema = errorSchema;

export const conversionTagsCreateDataSchema = z.object({
  body: conversionTagCreateSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const conversionTagResponseSchema = conversionTagCommonSchema;

export const conversionTagsCreateErrorSchema = errorSchema;

export const ocpmEligibleConversionTagsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const ocpmEligibleConversionTagsGetErrorSchema = errorSchema;

export const pageVisitConversionTagsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      order: z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const pageVisitConversionTagsGetErrorSchema = errorSchema;

export const conversionTagsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    conversion_tag_id: z.string(),
  }),
});

export const conversionTagsGetResponseSchema = conversionTagResponseSchema;

export const conversionTagsGetErrorSchema = errorSchema;

export const customerListRequestSchema = z.object({
  name: z.string(),
  records: z.string(),
  list_type: userListTypeSchema.optional(),
  exceptions: z.record(z.unknown()).optional(),
});

export const customerListsCreateResponseSchema = customerListSchema;

export const customerListsCreateErrorSchema = errorSchema;

export const customerListsListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      order: z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const customerListsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(customerListSchema).optional(),
  }),
);

export const customerListsListErrorSchema = errorSchema;

export const customerListsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    customer_list_id: z.string(),
  }),
});

export const customerListsGetResponseSchema = customerListSchema;

export const customerListsGetErrorSchema = errorSchema;

export const customerListUpdateRequestSchema = z.object({
  records: z.string(),
  operation_type: userListOperationTypeSchema,
  exceptions: exceptionSchema.optional(),
});

export const customerListsUpdateResponseSchema = customerListSchema;

export const customerListsUpdateErrorSchema = errorSchema;

export const conversionEventsSchema = z.object({
  data: z.array(
    z.object({
      event_name: z.string(),
      action_source: z.string(),
      event_time: z.number(),
      event_id: z.string(),
      event_source_url: z.string().optional().nullable(),
      opt_out: z.boolean().optional(),
      partner_name: z.string().optional().nullable(),
      user_data: conversionEventsUserDataSchema,
      custom_data: z
        .object({
          currency: z.string().optional().nullable(),
          value: z.string().optional().nullable(),
          content_ids: z.array(z.string()).optional(),
          content_name: z.string().optional().nullable(),
          content_category: z.string().optional().nullable(),
          content_brand: z.string().optional().nullable(),
          contents: z
            .array(
              z.object({
                id: z.string().optional(),
                item_price: z.string().optional(),
                quantity: z.number().optional(),
                item_name: z.string().optional(),
                item_category: z.string().optional(),
                item_brand: z.string().optional(),
              }),
            )
            .optional(),
          num_items: z.number().optional(),
          order_id: z.string().optional().nullable(),
          search_string: z.string().optional().nullable(),
          opt_out_type: z.string().optional().nullable(),
          np: z.string().optional().nullable(),
        })
        .optional(),
      app_id: z.string().optional().nullable(),
      app_name: z.string().optional().nullable(),
      app_version: z.string().optional().nullable(),
      device_brand: z.string().optional().nullable(),
      device_carrier: z.string().optional().nullable(),
      device_model: z.string().optional().nullable(),
      device_type: z.string().optional().nullable(),
      os_version: z.string().optional().nullable(),
      wifi: z.boolean().optional(),
      language: z.string().optional().nullable(),
    }),
  ),
});

export const eventsCreateResponseSchema = conversionApiResponseSchema;

export const eventsCreateErrorSchema = z.union([errorSchema, detailedErrorSchema]);

export const audienceInsightsScopeAndTypeGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const audienceDefinitionResponseSchema = z.object({
  items: z.array(audienceDefinitionSchema).optional(),
});

export const audienceInsightsScopeAndTypeGetErrorSchema = errorSchema;

export const keywordsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      ad_group_id: z.string().optional(),
      bookmark: z.string().optional(),
      campaign_id: z.string().optional(),
      match_types: z.array(matchTypeSchema).optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const keywordsGetResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(keywordSchema).optional(),
  }),
);

export const keywordsGetErrorSchema = errorSchema;

export const keywordsCreateDataSchema = z.object({
  body: keywordsRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const keywordsResponseSchema = z.object({
  errors: z.array(keywordErrorSchema).optional(),
  keywords: z.array(keywordSchema).optional(),
});

export const keywordsCreateErrorSchema = errorSchema;

export const keywordsUpdateDataSchema = z.object({
  body: keywordUpdateBodySchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const keywordsUpdateResponseSchema = keywordsResponseSchema;

export const keywordsUpdateErrorSchema = errorSchema;

export const countryKeywordsMetricsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    country_code: z.string(),
    keywords: z.array(z.string()),
  }),
});

export const countryKeywordsMetricsGetResponseSchema = keywordsMetricsArrayResponseSchema;

export const countryKeywordsMetricsGetErrorSchema = errorSchema;

export const leadFormsListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      order: z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const leadFormsListErrorSchema = errorSchema;

export const leadFormsCreateErrorSchema = errorSchema;

export const leadFormsUpdateErrorSchema = errorSchema;

export const leadFormGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    lead_form_id: z.string(),
  }),
});

export const leadFormGetErrorSchema = errorSchema;

export const leadFormTestCreateDataSchema = z.object({
  body: leadFormTestRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
    lead_form_id: z.string(),
  }),
});

export const leadFormTestCreateResponseSchema = leadFormTestResponseSchema;

export const leadFormTestCreateErrorSchema = errorSchema;

export const adAccountsSubscriptionsPostDataSchema = z.object({
  body: adAccountCreateSubscriptionRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const adAccountsSubscriptionsPostResponseSchema = adAccountCreateSubscriptionResponseSchema;

export const adAccountsSubscriptionsPostErrorSchema = errorSchema;

export const adAccountsSubscriptionsGetListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const adAccountsSubscriptionsGetListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(adAccountGetSubscriptionResponseSchema).optional(),
  }),
);

export const adAccountsSubscriptionsGetListErrorSchema = errorSchema;

export const adAccountsSubscriptionsGetByIdDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    subscription_id: z.string(),
  }),
});

export const adAccountsSubscriptionsGetByIdResponseSchema = adAccountGetSubscriptionResponseSchema;

export const adAccountsSubscriptionsGetByIdErrorSchema = errorSchema;

export const adAccountsSubscriptionsDelByIdDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    subscription_id: z.string(),
  }),
});

export const adAccountsSubscriptionsDelByIdResponseSchema = z.any();

export const adAccountsSubscriptionsDelByIdErrorSchema = errorSchema;

export const leadsExportCreateDataSchema = z.object({
  body: leadsExportCreateRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const leadsExportCreateResponse2Schema = leadsExportCreateResponseSchema;

export const leadsExportCreateErrorSchema = errorSchema;

export const leadsExportGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    leads_export_id: z.string(),
  }),
});

export const leadsExportGetResponseSchema = leadsExportResponseDataSchema;

export const leadsExportGetErrorSchema = errorSchema;

export const analyticsGetMmmReportDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    token: z.string(),
  }),
});

export const analyticsGetMmmReportResponseSchema = getMMMReportResponseSchema;

export const analyticsGetMmmReportErrorSchema = errorSchema;

export const createMMMReportRequestSchema = z
  .object({
    countries: z.array(targetingAdvertiserCountrySchema).optional(),
  })
  .and(
    z.object({
      report_name: z.string(),
      start_date: z.string(),
      end_date: z.string(),
      granularity: z.union([z.literal('DAY'), z.literal('WEEK')]),
      level: z.union([z.literal('CAMPAIGN_TARGETING'), z.literal('AD_GROUP_TARGETING')]),
      targeting_types: z.array(mMMReportingTargetingTypeSchema),
      columns: z.array(mMMReportingColumnSchema),
    }),
  );

export const analyticsCreateMmmReportResponseSchema = createMMMReportResponseSchema;

export const analyticsCreateMmmReportErrorSchema = errorSchema;

export const orderLinesListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      order: z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const orderLinesListErrorSchema = errorSchema;

export const orderLinesGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    order_line_id: z.string(),
  }),
});

export const orderLineSchema = orderLinesSchema.and(
  z.object({
    campaign_ids: z.array(z.string()),
  }),
);

export const orderLinesGetErrorSchema = errorSchema;

export const productGroupPromotionCreateRequestSchema = z.object({
  ad_group_id: z.string(),
  product_group_promotion: z.array(productGroupPromotionCreateRequestElementSchema),
});

export const productGroupPromotionResponseSchema = z.object({
  items: z.array(productGroupPromotionResponseItemSchema).optional(),
});

export const productGroupPromotionsCreateErrorSchema = errorSchema;

export const productGroupPromotionsUpdateDataSchema = z.object({
  body: productGroupPromotionUpdateRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const productGroupPromotionsUpdateResponseSchema = productGroupPromotionResponseSchema;

export const productGroupPromotionsUpdateErrorSchema = errorSchema;

export const productGroupPromotionsListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      ad_group_id: z.string().optional(),
      bookmark: z.string().optional(),
      entity_statuses: z
        .array(
          z.union([
            z.literal('ACTIVE'),
            z.literal('PAUSED'),
            z.literal('ARCHIVED'),
            z.literal('DRAFT'),
            z.literal('DELETED_DRAFT'),
          ]),
        )
        .optional(),
      order: z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
      page_size: z.number().optional(),
      product_group_promotion_ids: z.array(z.string()).optional(),
    })
    .optional(),
});

export const productGroupPromotionsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(productGroupPromotionResponseItemSchema).optional(),
  }),
);

export const productGroupPromotionsListErrorSchema = errorSchema;

export const productGroupPromotionsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    product_group_promotion_id: z.string(),
  }),
});

export const productGroupPromotionsGetResponseSchema = productGroupPromotionResponseSchema;

export const productGroupPromotionsGetErrorSchema = errorSchema;

export const productGroupsAnalyticsDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    click_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    columns: z.array(
      z.union([
        z.literal('SPEND_IN_MICRO_DOLLAR'),
        z.literal('PAID_IMPRESSION'),
        z.literal('SPEND_IN_DOLLAR'),
        z.literal('CPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_DOLLAR'),
        z.literal('CTR'),
        z.literal('ECTR'),
        z.literal('CAMPAIGN_NAME'),
        z.literal('PIN_ID'),
        z.literal('TOTAL_ENGAGEMENT'),
        z.literal('ENGAGEMENT_1'),
        z.literal('ENGAGEMENT_2'),
        z.literal('ECPE_IN_DOLLAR'),
        z.literal('ENGAGEMENT_RATE'),
        z.literal('EENGAGEMENT_RATE'),
        z.literal('ECPM_IN_MICRO_DOLLAR'),
        z.literal('REPIN_RATE'),
        z.literal('CTR_2'),
        z.literal('CAMPAIGN_ID'),
        z.literal('ADVERTISER_ID'),
        z.literal('AD_ACCOUNT_ID'),
        z.literal('PIN_PROMOTION_ID'),
        z.literal('AD_ID'),
        z.literal('AD_GROUP_ID'),
        z.literal('CAMPAIGN_ENTITY_STATUS'),
        z.literal('CAMPAIGN_OBJECTIVE_TYPE'),
        z.literal('CPM_IN_MICRO_DOLLAR'),
        z.literal('CPM_IN_DOLLAR'),
        z.literal('AD_GROUP_ENTITY_STATUS'),
        z.literal('ORDER_LINE_ID'),
        z.literal('ORDER_LINE_NAME'),
        z.literal('CLICKTHROUGH_1'),
        z.literal('REPIN_1'),
        z.literal('IMPRESSION_1'),
        z.literal('IMPRESSION_1_GROSS'),
        z.literal('CLICKTHROUGH_1_GROSS'),
        z.literal('OUTBOUND_CLICK_1'),
        z.literal('CLICKTHROUGH_2'),
        z.literal('REPIN_2'),
        z.literal('IMPRESSION_2'),
        z.literal('OUTBOUND_CLICK_2'),
        z.literal('TOTAL_CLICKTHROUGH'),
        z.literal('TOTAL_IMPRESSION'),
        z.literal('TOTAL_IMPRESSION_USER'),
        z.literal('TOTAL_IMPRESSION_FREQUENCY'),
        z.literal('COST_PER_OUTBOUND_CLICK_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_ENGAGEMENT_LEAD'),
        z.literal('TOTAL_CLICK_SIGNUP'),
        z.literal('TOTAL_CLICK_CHECKOUT'),
        z.literal('TOTAL_CLICK_ADD_TO_CART'),
        z.literal('TOTAL_CLICK_LEAD'),
        z.literal('TOTAL_VIEW_SIGNUP'),
        z.literal('TOTAL_VIEW_CHECKOUT'),
        z.literal('TOTAL_VIEW_ADD_TO_CART'),
        z.literal('TOTAL_VIEW_LEAD'),
        z.literal('TOTAL_CONVERSIONS'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_SESSIONS'),
        z.literal('WEB_SESSIONS_1'),
        z.literal('WEB_SESSIONS_2'),
        z.literal('CAMPAIGN_LIFETIME_SPEND_CAP'),
        z.literal('CAMPAIGN_DAILY_SPEND_CAP'),
        z.literal('TOTAL_PAGE_VISIT'),
        z.literal('TOTAL_SIGNUP'),
        z.literal('TOTAL_CHECKOUT'),
        z.literal('TOTAL_CUSTOM'),
        z.literal('TOTAL_LEAD'),
        z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('PAGE_VISIT_COST_PER_ACTION'),
        z.literal('PAGE_VISIT_ROAS'),
        z.literal('CHECKOUT_ROAS'),
        z.literal('CUSTOM_ROAS'),
        z.literal('VIDEO_MRC_VIEWS_1'),
        z.literal('VIDEO_3SEC_VIEWS_2'),
        z.literal('VIDEO_P100_COMPLETE_2'),
        z.literal('VIDEO_P0_COMBINED_2'),
        z.literal('VIDEO_P25_COMBINED_2'),
        z.literal('VIDEO_P50_COMBINED_2'),
        z.literal('VIDEO_P75_COMBINED_2'),
        z.literal('VIDEO_P95_COMBINED_2'),
        z.literal('VIDEO_MRC_VIEWS_2'),
        z.literal('PAID_VIDEO_VIEWABLE_RATE'),
        z.literal('VIDEO_LENGTH'),
        z.literal('ECPV_IN_DOLLAR'),
        z.literal('ECPCV_IN_DOLLAR'),
        z.literal('ECPCV_P95_IN_DOLLAR'),
        z.literal('TOTAL_VIDEO_3SEC_VIEWS'),
        z.literal('TOTAL_VIDEO_P100_COMPLETE'),
        z.literal('TOTAL_VIDEO_P0_COMBINED'),
        z.literal('TOTAL_VIDEO_P25_COMBINED'),
        z.literal('TOTAL_VIDEO_P50_COMBINED'),
        z.literal('TOTAL_VIDEO_P75_COMBINED'),
        z.literal('TOTAL_VIDEO_P95_COMBINED'),
        z.literal('TOTAL_VIDEO_MRC_VIEWS'),
        z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'),
        z.literal('TOTAL_REPIN_RATE'),
        z.literal('WEB_CHECKOUT_COST_PER_ACTION'),
        z.literal('WEB_CHECKOUT_ROAS'),
        z.literal('TOTAL_WEB_CHECKOUT'),
        z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('INAPP_CHECKOUT_COST_PER_ACTION'),
        z.literal('TOTAL_OFFLINE_CHECKOUT'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_1'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_2'),
        z.literal('TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'),
        z.literal('LEADS'),
        z.literal('COST_PER_LEAD'),
        z.literal('QUIZ_COMPLETED'),
        z.literal('QUIZ_PIN_RESULT_OPEN'),
        z.literal('QUIZ_COMPLETION_RATE'),
        z.literal('SHOWCASE_PIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_IMPRESSION'),
        z.literal('SHOWCASE_SUBPIN_IMPRESSION'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPAGE_REPIN'),
        z.literal('SHOWCASE_SUBPIN_REPIN'),
        z.literal('SHOWCASE_SUBPAGE_CLOSEUP'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'),
        z.literal('SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_RATE'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_RATE'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_RATE'),
        z.literal('TOTAL_SIGNUP_CONVERSION_RATE'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_RATE'),
        z.literal('TOTAL_LEAD_CONVERSION_RATE'),
        z.literal('TOTAL_SEARCH_CONVERSION_RATE'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_RATE'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_RATE'),
        z.literal('TOTAL_CUSTOM_CONVERSION_RATE'),
      ]),
    ),
    conversion_report_time: z.union([z.literal('TIME_OF_AD_ACTION'), z.literal('TIME_OF_CONVERSION')]).optional(),
    end_date: z.string(),
    engagement_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    granularity: granularitySchema,
    product_group_ids: z.array(z.string()),
    start_date: z.string(),
    view_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
  }),
});

export const productGroupsAnalyticsResponseSchema = productGroupAnalyticsResponseSchema;

export const productGroupsAnalyticsErrorSchema = errorSchema;

export const analyticsGetReportDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    token: z.string(),
  }),
});

export const analyticsGetReportResponseSchema = adsAnalyticsGetAsyncResponseSchema;

export const analyticsGetReportErrorSchema = errorSchema;

export const adsAnalyticsCreateAsyncRequestSchema = z
  .object({
    start_date: z.string(),
    end_date: z.string(),
    granularity: granularitySchema,
    click_window_days: conversionAttributionWindowDaysSchema.optional(),
    engagement_window_days: conversionAttributionWindowDaysSchema.optional(),
    view_window_days: conversionAttributionWindowDaysSchema.optional(),
    conversion_report_time: conversionReportTimeTypeSchema.optional(),
    attribution_types: z.array(conversionReportAttributionTypeSchema).optional(),
  })
  .and(
    z
      .object({
        campaign_ids: z.array(z.string()).optional(),
      })
      .and(
        z.object({
          campaign_statuses: z.array(campaignSummaryStatusSchema).optional(),
        }),
      )
      .and(
        z.object({
          campaign_objective_types: z.array(objectiveTypeSchema).optional(),
        }),
      )
      .and(
        z.object({
          ad_group_ids: z.array(z.string()).optional(),
        }),
      )
      .and(
        z.object({
          ad_group_statuses: z.array(adGroupSummaryStatusSchema).optional(),
        }),
      )
      .and(
        z.object({
          ad_ids: z.array(z.string()).optional(),
        }),
      )
      .and(
        z.object({
          ad_statuses: z.array(pinPromotionSummaryStatusSchema).optional(),
        }),
      )
      .and(
        z.object({
          product_group_ids: z.array(z.string()).optional(),
        }),
      )
      .and(
        z.object({
          product_group_statuses: z.array(productGroupSummaryStatusSchema).optional(),
        }),
      )
      .and(
        z.object({
          product_item_ids: z.array(z.string()).optional(),
        }),
      )
      .and(targetingTypeFilterSchema)
      .and(
        z.object({
          metrics_filters: z.array(adsAnalyticsMetricsFilterSchema).optional(),
        }),
      ),
  )
  .and(
    z.object({
      columns: z.array(reportingColumnAsyncSchema),
      level: metricsReportingLevelSchema,
      report_format: dataOutputFormatSchema.optional(),
      primary_sort: z.union([z.literal('BY_ID'), z.literal('BY_DATE')]).optional(),
      start_hour: z.number().optional(),
      end_hour: z.number().optional(),
    }),
  );

export const adsAnalyticsCreateAsyncResponseSchema = z.object({
  report_status: bulkReportingJobStatusSchema.optional(),
  token: z.string().optional(),
  message: z.string().optional().nullable(),
});

export const analyticsCreateReportErrorSchema = errorSchema;

export const sandboxDeleteDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const sandboxDeleteResponseSchema = z.string();

export const sandboxDeleteErrorSchema = errorSchema;

export const ssioAccountsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const ssioAccountsGetResponseSchema = sSIOAccountResponseSchema;

export const ssioAccountsGetErrorSchema = errorSchema;

export const sSIOCreateInsertionOrderRequestSchema = sSIOInsertionOrderCommonSchema.and(
  z.object({
    accepted_terms_time: z.number().optional(),
    pmp_id: z.string(),
    order_name: z.string(),
    order_line_type: z.union([z.literal('BUDGET'), z.literal('PERPETUALS')]),
    accepted_terms_id: z.string(),
    billto_company_id: z.string(),
    billto_business_address_id: z.string(),
    billto_billing_address_id: z.string(),
    estimated_monthly_spend: z.number().optional(),
    currency_info: currencySchema,
  }),
);

export const ssioInsertionOrderCreateResponseSchema = sSIOCreateInsertionOrderResponseSchema;

export const ssioInsertionOrderCreateErrorSchema = errorSchema;

export const ssioInsertionOrderEditDataSchema = z.object({
  body: sSIOEditInsertionOrderRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const ssioInsertionOrderEditResponseSchema = sSIOEditInsertionOrderResponseSchema;

export const ssioInsertionOrderEditErrorSchema = errorSchema;

export const ssioInsertionOrdersStatusGetByAdAccountDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const ssioInsertionOrdersStatusGetByAdAccountResponseSchema = paginatedSchema.and(
  z.object({
    items: z.unknown().optional(),
  }),
);

export const ssioInsertionOrdersStatusGetByAdAccountErrorSchema = errorSchema;

export const ssioInsertionOrdersStatusGetByPinOrderIdDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    pin_order_id: z.string(),
  }),
});

export const ssioInsertionOrdersStatusGetByPinOrderIdResponseSchema = sSIOInsertionOrderStatusResponseSchema;

export const ssioInsertionOrdersStatusGetByPinOrderIdErrorSchema = errorSchema;

export const ssioOrderLinesGetByAdAccountDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
      pin_order_id: z.string().optional(),
    })
    .optional(),
});

export const ssioOrderLinesGetByAdAccountResponseSchema = paginatedSchema.and(
  z.object({
    items: z.unknown().optional(),
  }),
);

export const ssioOrderLinesGetByAdAccountErrorSchema = errorSchema;

export const adAccountTargetingAnalyticsGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z.object({
    attribution_types: conversionReportAttributionTypeSchema.optional(),
    click_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    columns: z.array(
      z.union([
        z.literal('SPEND_IN_MICRO_DOLLAR'),
        z.literal('PAID_IMPRESSION'),
        z.literal('SPEND_IN_DOLLAR'),
        z.literal('CPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_MICRO_DOLLAR'),
        z.literal('ECPC_IN_DOLLAR'),
        z.literal('CTR'),
        z.literal('ECTR'),
        z.literal('CAMPAIGN_NAME'),
        z.literal('PIN_ID'),
        z.literal('TOTAL_ENGAGEMENT'),
        z.literal('ENGAGEMENT_1'),
        z.literal('ENGAGEMENT_2'),
        z.literal('ECPE_IN_DOLLAR'),
        z.literal('ENGAGEMENT_RATE'),
        z.literal('EENGAGEMENT_RATE'),
        z.literal('ECPM_IN_MICRO_DOLLAR'),
        z.literal('REPIN_RATE'),
        z.literal('CTR_2'),
        z.literal('CAMPAIGN_ID'),
        z.literal('ADVERTISER_ID'),
        z.literal('AD_ACCOUNT_ID'),
        z.literal('PIN_PROMOTION_ID'),
        z.literal('AD_ID'),
        z.literal('AD_GROUP_ID'),
        z.literal('CAMPAIGN_ENTITY_STATUS'),
        z.literal('CAMPAIGN_OBJECTIVE_TYPE'),
        z.literal('CPM_IN_MICRO_DOLLAR'),
        z.literal('CPM_IN_DOLLAR'),
        z.literal('AD_GROUP_ENTITY_STATUS'),
        z.literal('ORDER_LINE_ID'),
        z.literal('ORDER_LINE_NAME'),
        z.literal('CLICKTHROUGH_1'),
        z.literal('REPIN_1'),
        z.literal('IMPRESSION_1'),
        z.literal('IMPRESSION_1_GROSS'),
        z.literal('CLICKTHROUGH_1_GROSS'),
        z.literal('OUTBOUND_CLICK_1'),
        z.literal('CLICKTHROUGH_2'),
        z.literal('REPIN_2'),
        z.literal('IMPRESSION_2'),
        z.literal('OUTBOUND_CLICK_2'),
        z.literal('TOTAL_CLICKTHROUGH'),
        z.literal('TOTAL_IMPRESSION'),
        z.literal('TOTAL_IMPRESSION_USER'),
        z.literal('TOTAL_IMPRESSION_FREQUENCY'),
        z.literal('COST_PER_OUTBOUND_CLICK_IN_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_ENGAGEMENT_LEAD'),
        z.literal('TOTAL_CLICK_SIGNUP'),
        z.literal('TOTAL_CLICK_CHECKOUT'),
        z.literal('TOTAL_CLICK_ADD_TO_CART'),
        z.literal('TOTAL_CLICK_LEAD'),
        z.literal('TOTAL_VIEW_SIGNUP'),
        z.literal('TOTAL_VIEW_CHECKOUT'),
        z.literal('TOTAL_VIEW_ADD_TO_CART'),
        z.literal('TOTAL_VIEW_LEAD'),
        z.literal('TOTAL_CONVERSIONS'),
        z.literal('TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_SESSIONS'),
        z.literal('WEB_SESSIONS_1'),
        z.literal('WEB_SESSIONS_2'),
        z.literal('CAMPAIGN_LIFETIME_SPEND_CAP'),
        z.literal('CAMPAIGN_DAILY_SPEND_CAP'),
        z.literal('TOTAL_PAGE_VISIT'),
        z.literal('TOTAL_SIGNUP'),
        z.literal('TOTAL_CHECKOUT'),
        z.literal('TOTAL_CUSTOM'),
        z.literal('TOTAL_LEAD'),
        z.literal('TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'),
        z.literal('PAGE_VISIT_COST_PER_ACTION'),
        z.literal('PAGE_VISIT_ROAS'),
        z.literal('CHECKOUT_ROAS'),
        z.literal('CUSTOM_ROAS'),
        z.literal('VIDEO_MRC_VIEWS_1'),
        z.literal('VIDEO_3SEC_VIEWS_2'),
        z.literal('VIDEO_P100_COMPLETE_2'),
        z.literal('VIDEO_P0_COMBINED_2'),
        z.literal('VIDEO_P25_COMBINED_2'),
        z.literal('VIDEO_P50_COMBINED_2'),
        z.literal('VIDEO_P75_COMBINED_2'),
        z.literal('VIDEO_P95_COMBINED_2'),
        z.literal('VIDEO_MRC_VIEWS_2'),
        z.literal('PAID_VIDEO_VIEWABLE_RATE'),
        z.literal('VIDEO_LENGTH'),
        z.literal('ECPV_IN_DOLLAR'),
        z.literal('ECPCV_IN_DOLLAR'),
        z.literal('ECPCV_P95_IN_DOLLAR'),
        z.literal('TOTAL_VIDEO_3SEC_VIEWS'),
        z.literal('TOTAL_VIDEO_P100_COMPLETE'),
        z.literal('TOTAL_VIDEO_P0_COMBINED'),
        z.literal('TOTAL_VIDEO_P25_COMBINED'),
        z.literal('TOTAL_VIDEO_P50_COMBINED'),
        z.literal('TOTAL_VIDEO_P75_COMBINED'),
        z.literal('TOTAL_VIDEO_P95_COMBINED'),
        z.literal('TOTAL_VIDEO_MRC_VIEWS'),
        z.literal('TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'),
        z.literal('TOTAL_REPIN_RATE'),
        z.literal('WEB_CHECKOUT_COST_PER_ACTION'),
        z.literal('WEB_CHECKOUT_ROAS'),
        z.literal('TOTAL_WEB_CHECKOUT'),
        z.literal('TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT'),
        z.literal('TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT'),
        z.literal('TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT'),
        z.literal('TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'),
        z.literal('INAPP_CHECKOUT_COST_PER_ACTION'),
        z.literal('TOTAL_OFFLINE_CHECKOUT'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_1'),
        z.literal('IDEA_PIN_PRODUCT_TAG_VISIT_2'),
        z.literal('TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'),
        z.literal('LEADS'),
        z.literal('COST_PER_LEAD'),
        z.literal('QUIZ_COMPLETED'),
        z.literal('QUIZ_PIN_RESULT_OPEN'),
        z.literal('QUIZ_COMPLETION_RATE'),
        z.literal('SHOWCASE_PIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPIN_CLICKTHROUGH'),
        z.literal('SHOWCASE_SUBPAGE_IMPRESSION'),
        z.literal('SHOWCASE_SUBPIN_IMPRESSION'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPAGE_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_LEFT'),
        z.literal('SHOWCASE_SUBPIN_SWIPE_RIGHT'),
        z.literal('SHOWCASE_SUBPAGE_REPIN'),
        z.literal('SHOWCASE_SUBPIN_REPIN'),
        z.literal('SHOWCASE_SUBPAGE_CLOSEUP'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'),
        z.literal('SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'),
        z.literal('SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'),
        z.literal('TOTAL_CHECKOUT_CONVERSION_RATE'),
        z.literal('TOTAL_VIEW_CATEGORY_CONVERSION_RATE'),
        z.literal('TOTAL_ADD_TO_CART_CONVERSION_RATE'),
        z.literal('TOTAL_SIGNUP_CONVERSION_RATE'),
        z.literal('TOTAL_PAGE_VISIT_CONVERSION_RATE'),
        z.literal('TOTAL_LEAD_CONVERSION_RATE'),
        z.literal('TOTAL_SEARCH_CONVERSION_RATE'),
        z.literal('TOTAL_WATCH_VIDEO_CONVERSION_RATE'),
        z.literal('TOTAL_UNKNOWN_CONVERSION_RATE'),
        z.literal('TOTAL_CUSTOM_CONVERSION_RATE'),
      ]),
    ),
    conversion_report_time: z.union([z.literal('TIME_OF_AD_ACTION'), z.literal('TIME_OF_CONVERSION')]).optional(),
    end_date: z.string(),
    engagement_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
    granularity: granularitySchema,
    start_date: z.string(),
    targeting_types: z.array(adsAnalyticsTargetingTypeSchema),
    view_window_days: z
      .union([z.literal(0), z.literal(1), z.literal(7), z.literal(14), z.literal(30), z.literal(60)])
      .optional(),
  }),
});

export const adAccountTargetingAnalyticsGetResponseSchema = metricsResponseSchema;

export const adAccountTargetingAnalyticsGetErrorSchema = errorSchema;

export const targetingTemplateListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      include_sizing: z.boolean().optional(),
      order: z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
      page_size: z.number().optional(),
      search_query: z.string().optional(),
    })
    .optional(),
});

export const targetingTemplateListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(targetingTemplateResponseDataSchema).optional(),
  }),
);

export const targetingTemplateListErrorSchema = errorSchema;

export const targetingTemplateCreateSchema = targetingTemplateCommonSchema.and(
  z.object({
    name: z.string(),
    targeting_attributes: targetingSpecSchema,
  }),
);

export const targetingTemplateGetResponseDataSchema = targetingTemplateResponseDataSchema.and(
  z.object({
    valid: z.boolean().optional().nullable(),
  }),
);

export const targetingTemplateCreateErrorSchema = errorSchema;

export const targetingTemplateUpdateDataSchema = z.object({
  body: targetingTemplateUpdateRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const targetingTemplateUpdateResponseSchema = z.unknown();

export const targetingTemplateUpdateErrorSchema = errorSchema;

export const templatesListDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      order: z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const templatesListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(templateResponseSchema).optional(),
  }),
);

export const templatesListErrorSchema = errorSchema;

export const analyticsCreateTemplateReportDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
    template_id: z.string(),
  }),
  query: z
    .object({
      end_date: z.string().optional(),
      granularity: granularitySchema.optional(),
      start_date: z.string().optional(),
    })
    .optional(),
});

export const analyticsCreateTemplateReportResponseSchema = adsAnalyticsCreateAsyncResponseSchema;

export const analyticsCreateTemplateReportErrorSchema = errorSchema;

export const termsOfServiceGetDataSchema = z.object({
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      include_html: z.boolean().optional(),
      tos_type: z.string().optional(),
    })
    .optional(),
});

export const termsOfServiceGetResponseSchema = termsOfServiceSchema;

export const termsOfServiceGetErrorSchema = errorSchema;

export const advancedAuctionItemsGetPostErrorSchema = errorSchema;

export const advancedAuctionItemsSubmitPostErrorSchema = errorSchema;

export const boardsListDataSchema = z.object({
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
      privacy: z
        .union([
          z.literal('ALL'),
          z.literal('PROTECTED'),
          z.literal('PUBLIC'),
          z.literal('SECRET'),
          z.literal('PUBLIC_AND_SECRET'),
        ])
        .optional(),
    })
    .optional(),
});

export const boardsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.unknown().optional(),
  }),
);

export const boardsListErrorSchema = errorSchema;

export const boardSchema = z.object({
  id: z.string().optional(),
  created_at: z.string().optional(),
  board_pins_modified_at: z.string().optional(),
  name: z.string(),
  description: z.string().optional().nullable(),
  collaborator_count: z.number().optional(),
  pin_count: z.number().optional(),
  follower_count: z.number().optional(),
  media: z
    .object({
      image_cover_url: z.string().optional().nullable(),
      pin_thumbnail_urls: z.array(z.string()).optional(),
    })
    .optional(),
  owner: boardOwnerSchema.optional(),
  privacy: z.union([z.literal('PUBLIC'), z.literal('PROTECTED'), z.literal('SECRET')]).optional(),
});

export const boardsCreateResponseSchema = boardSchema;

export const boardsCreateErrorSchema = errorSchema;

export const boardsGetDataSchema = z.object({
  path: z.object({
    board_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const boardsGetResponseSchema = boardSchema;

export const boardsGetErrorSchema = errorSchema;

export const boardsUpdateDataSchema = z.object({
  body: boardUpdateSchema,
  path: z.object({
    board_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const boardsUpdateResponseSchema = boardSchema;

export const boardsUpdateErrorSchema = errorSchema;

export const boardsDeleteDataSchema = z.object({
  path: z.object({
    board_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const boardsDeleteResponseSchema = z.any();

export const boardsDeleteErrorSchema = errorSchema;

export const boardsListPinsDataSchema = z.object({
  path: z.object({
    board_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      creative_types: z
        .array(
          z.union([
            z.literal('REGULAR'),
            z.literal('VIDEO'),
            z.literal('SHOPPING'),
            z.literal('CAROUSEL'),
            z.literal('MAX_VIDEO'),
            z.literal('SHOP_THE_PIN'),
            z.literal('COLLECTION'),
            z.literal('IDEA'),
          ]),
        )
        .optional(),
      page_size: z.number().optional(),
      pin_metrics: z.boolean().optional(),
    })
    .optional(),
});

export const boardsListPinsResponseSchema = paginatedSchema.and(
  z.object({
    items: z.unknown().optional(),
  }),
);

export const boardsListPinsErrorSchema = errorSchema;

export const boardSectionsListDataSchema = z.object({
  path: z.object({
    board_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const boardSectionsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.unknown().optional(),
  }),
);

export const boardSectionsListErrorSchema = errorSchema;

export const boardSectionsCreateDataSchema = z.object({
  body: boardSectionSchema,
  path: z.object({
    board_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const boardSectionsCreateResponseSchema = boardSectionSchema;

export const boardSectionsCreateErrorSchema = errorSchema;

export const boardSectionsUpdateDataSchema = z.object({
  body: boardSectionSchema,
  path: z.object({
    board_id: z.string(),
    section_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const boardSectionsUpdateResponseSchema = boardSectionSchema;

export const boardSectionsUpdateErrorSchema = errorSchema;

export const boardSectionsDeleteDataSchema = z.object({
  path: z.object({
    board_id: z.string(),
    section_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const boardSectionsDeleteResponseSchema = z.any();

export const boardSectionsDeleteErrorSchema = errorSchema;

export const boardSectionsListPinsDataSchema = z.object({
  path: z.object({
    board_id: z.string(),
    section_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const boardSectionsListPinsResponseSchema = paginatedSchema.and(
  z.object({
    items: z.unknown().optional(),
  }),
);

export const boardSectionsListPinsErrorSchema = errorSchema;

export const getBusinessEmployersDataSchema = z.object({
  query: z
    .object({
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const getBusinessEmployersResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(userBusinessRoleBindingSchema).optional(),
  }),
);

export const getBusinessEmployersErrorSchema = errorSchema;

export const authRespondInvitesBodySchema = z.object({
  invites: z.array(
    z.object({
      action: z.object({
        accept_invite: z.boolean(),
        asset_id_to_permissions: assetIdToPermissionsSchema.optional(),
      }),
      invite_id: z.string(),
    }),
  ),
});

export const respondBusinessAccessInvitesResponseSchema = respondToInvitesResponseArraySchema;

export const respondBusinessAccessInvitesErrorSchema = errorSchema;

export const businessAssetMembersGetDataSchema = z.object({
  path: z.object({
    asset_id: z.string(),
    business_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
      start_index: z.number().optional(),
    })
    .optional(),
});

export const businessAssetMembersGetResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(userSingleAssetBindingSchema).optional(),
  }),
);

export const businessAssetMembersGetErrorSchema = errorSchema;

export const businessAssetPartnersGetDataSchema = z.object({
  path: z.object({
    asset_id: z.string(),
    business_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
      start_index: z.number().optional(),
    })
    .optional(),
});

export const businessAssetPartnersGetResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(userSingleAssetBindingSchema).optional(),
  }),
);

export const businessAssetPartnersGetErrorSchema = errorSchema;

export const createAssetInvitesDataSchema = z.object({
  body: createAssetInvitesRequestSchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const updateInvitesResultsResponseArraySchema = z.object({
  items: z
    .array(
      z.object({
        exception: inviteExceptionResponseSchema.optional(),
        invite: inviteBusinessRoleBindingSchema.optional(),
      }),
    )
    .optional(),
});

export const createAssetInvitesErrorSchema = errorSchema;

export const createAssetAccessRequestBodySchema = z.object({
  asset_requests: z.array(
    z.object({
      partner_id: z.string(),
      asset_id_to_permissions: assetIdToPermissionsSchema,
    }),
  ),
});

export const assetAccessRequestsCreateResponseSchema = createAssetAccessRequestResponseSchema;

export const assetAccessRequestsCreateErrorSchema = errorSchema;

export const getBusinessMembersDataSchema = z.object({
  path: z.object({
    business_id: z.string(),
  }),
  query: z
    .object({
      assets_summary: z.boolean().optional(),
      bookmark: z.string().optional(),
      business_roles: z.array(memberBusinessRoleSchema).optional(),
      member_ids: z.string().optional(),
      page_size: z.number().optional(),
      start_index: z.number().optional(),
    })
    .optional(),
});

export const getBusinessMembersResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(userBusinessRoleBindingSchema).optional(),
  }),
);

export const getBusinessMembersErrorSchema = errorSchema;

export const updateBusinessMembershipsDataSchema = z.object({
  body: z.array(updateMemberBusinessRoleBodySchema),
  path: z.object({
    business_id: z.string(),
  }),
});

export const updateBusinessMembershipsResponseSchema = updateMemberResultsResponseArraySchema;

export const updateBusinessMembershipsErrorSchema = errorSchema;

export const deleteBusinessMembershipDataSchema = z.object({
  body: membersToDeleteBodySchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const deleteBusinessMembershipResponseSchema = deletedMembersResponseSchema;

export const deleteBusinessMembershipErrorSchema = errorSchema;

export const businessAssetsGetDataSchema = z.object({
  path: z.object({
    business_id: z.string(),
  }),
  query: z
    .object({
      asset_group_id: z.string().optional(),
      asset_type: z.union([z.literal('AD_ACCOUNT'), z.literal('PROFILE'), z.literal('ASSET_GROUP')]).optional(),
      bookmark: z.string().optional(),
      child_asset_id: z.string().optional(),
      page_size: z.number().optional(),
      permissions: z.array(permissionsWithOwnerSchema).optional(),
      start_index: z.number().optional(),
    })
    .optional(),
});

export const businessAssetsGetResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(getBusinessAssetsResponseSchema).optional(),
  }),
);

export const businessAssetsGetErrorSchema = errorSchema;

export const businessMemberAssetsGetDataSchema = z.object({
  path: z.object({
    business_id: z.string(),
    member_id: z.string(),
  }),
  query: z
    .object({
      asset_type: z.union([z.literal('AD_ACCOUNT'), z.literal('PROFILE'), z.literal('ASSET_GROUP')]).optional(),
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
      start_index: z.number().optional(),
    })
    .optional(),
});

export const businessMemberAssetsGetErrorSchema = errorSchema;

export const businessMembersAssetAccessUpdateDataSchema = z.object({
  body: updateMemberAssetAccessBodySchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const updateMemberAssetsResultsResponseArraySchema = z.object({
  items: z
    .array(
      z.object({
        response: usersForIndividualAssetResponseSchema.optional(),
      }),
    )
    .optional(),
});

export const businessMembersAssetAccessUpdateErrorSchema = errorSchema;

export const businessMembersAssetAccessDeleteDataSchema = z.object({
  body: z.object({
    accesses: z.array(
      z.object({
        asset_id: z.string(),
        member_id: z.string(),
      }),
    ),
  }),
  path: z.object({
    business_id: z.string(),
  }),
});

export const businessMembersAssetAccessDeleteResponseSchema = deleteMemberAccessResultsResponseArraySchema;

export const businessMembersAssetAccessDeleteErrorSchema = errorSchema;

export const getInvitesDataSchema = z.object({
  path: z.object({
    business_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      invite_status: z.array(z.union([z.literal('PENDING'), z.literal('EXPIRED')])).optional(),
      invite_type: inviteTypeSchema.optional(),
      is_member: z.boolean().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const getInvitesResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(inviteResponseSchema).optional(),
  }),
);

export const getInvitesErrorSchema = errorSchema;

export const createMembershipOrPartnershipInvitesBodySchema = z.object({
  business_role: z.union([z.literal('EMPLOYEE'), z.literal('BIZ_ADMIN'), z.literal('PARTNER')]),
  invite_type: inviteTypeSchema,
  members: z.array(z.string()).optional(),
  partners: z.array(z.string()).optional(),
});

export const createInvitesResultsResponseArraySchema = z.object({
  items: z
    .array(
      z.object({
        exception: inviteExceptionResponseSchema.optional(),
        invite: z
          .object({
            id: z.string().optional(),
            user: businessAccessUserSummarySchema.optional(),
          })
          .optional()
          .nullable(),
      }),
    )
    .optional(),
});

export const createMembershipOrPartnershipInvitesErrorSchema = errorSchema;

export const cancelInvitesOrRequestsDataSchema = z.object({
  body: cancelInvitesBodySchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const cancelInvitesOrRequestsResponseSchema = deleteInvitesResultsResponseArraySchema;

export const cancelInvitesOrRequestsErrorSchema = errorSchema;

export const updatePartnerAssetAccessBodySchema = z.object({
  accesses: z.array(
    z.object({
      partner_id: z.string(),
      asset_id: z.string(),
      permissions: z.array(permissionsSchema),
    }),
  ),
});

export const updatePartnerAssetAccessHandlerImplResponseSchema = updatePartnerAssetsResultsResponseArraySchema;

export const updatePartnerAssetAccessHandlerImplErrorSchema = errorSchema;

export const deletePartnerAssetAccessHandlerImplDataSchema = z.object({
  body: deletePartnerAssetAccessBodySchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const deletePartnerAssetAccessHandlerImplResponseSchema = deletePartnerAssetsResultsResponseArraySchema;

export const deletePartnerAssetAccessHandlerImplErrorSchema = errorSchema;

export const businessPartnerAssetAccessGetDataSchema = z.object({
  path: z.object({
    business_id: z.string(),
    partner_id: z.string(),
  }),
  query: z
    .object({
      asset_type: z.union([z.literal('AD_ACCOUNT'), z.literal('PROFILE'), z.literal('ASSET_GROUP')]).optional(),
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
      partner_type: partnerTypeSchema.and(z.unknown()).optional(),
      start_index: z.number().optional(),
    })
    .optional(),
});

export const businessPartnerAssetAccessGetResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(getPartnerAssetsResponseSchema).optional(),
  }),
);

export const businessPartnerAssetAccessGetErrorSchema = errorSchema;

export const getBusinessPartnersDataSchema = z.object({
  path: z.object({
    business_id: z.string(),
  }),
  query: z
    .object({
      assets_summary: z.boolean().optional(),
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
      partner_ids: z.string().optional(),
      partner_type: partnerTypeSchema.optional(),
      start_index: z.number().optional(),
    })
    .optional(),
});

export const getBusinessPartnersResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(userBusinessRoleBindingSchema).optional(),
  }),
);

export const getBusinessPartnersErrorSchema = errorSchema;

export const deleteBusinessPartnersDataSchema = z.object({
  body: deletePartnersRequestSchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const deleteBusinessPartnersResponseSchema = deletePartnersResponseSchema;

export const deleteBusinessPartnersErrorSchema = errorSchema;

export const sharedAudiencesForBusinessListDataSchema = z.object({
  path: z.object({
    business_id: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      order: z.union([z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const sharedAudiencesForBusinessListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(audienceSchema).optional(),
  }),
);

export const sharedAudiencesForBusinessListErrorSchema = errorSchema;

export const businessAccountAudiencesSharedAccountsListDataSchema = z.object({
  path: z.object({
    business_id: z.string(),
  }),
  query: z.object({
    account_type: audienceAccountTypeSchema,
    audience_id: z.string(),
    bookmark: z.string().optional(),
    page_size: z.number().optional(),
  }),
});

export const businessAccountAudiencesSharedAccountsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(sharedAudienceAccountSchema).optional(),
  }),
);

export const businessAccountAudiencesSharedAccountsListErrorSchema = errorSchema;

export const updateBusinessToAdAccountSharedAudienceDataSchema = z.object({
  body: sharedAudienceSchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const updateBusinessToAdAccountSharedAudienceResponseSchema = sharedAudienceResponseSchema;

export const updateBusinessToAdAccountSharedAudienceErrorSchema = errorSchema;

export const updateBusinessToBusinessSharedAudienceDataSchema = z.object({
  body: businessSharedAudienceSchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const updateBusinessToBusinessSharedAudienceResponseSchema = businessSharedAudienceResponseSchema;

export const updateBusinessToBusinessSharedAudienceErrorSchema = errorSchema;

export const createAssetGroupBodySchema = z.object({
  asset_group_name: z.string(),
  asset_group_description: z.string(),
  asset_group_types: assetGroupTypesSchema,
});

export const createAssetGroupResponseSchema = z.object({
  asset_group: assetGroupBindingSchema.optional(),
});

export const assetGroupCreateErrorSchema = errorSchema;

export const assetGroupUpdateDataSchema = z.object({
  body: updateAssetGroupBodySchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const assetGroupUpdateResponseSchema = updateAssetGroupResponseSchema;

export const assetGroupUpdateErrorSchema = errorSchema;

export const assetGroupDeleteDataSchema = z.object({
  body: deleteAssetGroupBodySchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const assetGroupDeleteResponseSchema = deleteAssetGroupResponseSchema;

export const assetGroupDeleteErrorSchema = errorSchema;

export const catalogsListDataSchema = z.object({
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const catalogsListErrorSchema = errorSchema;

export const catalogsCreateDataSchema = z.object({
  body: catalogsCreateRequestSchema,
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const catalogSchema = catalogsDbItemSchema.and(
  z.object({
    id: z.string(),
    name: z.string().nullable(),
    catalog_type: catalogsTypeSchema,
  }),
);

export const catalogsCreateErrorSchema = errorSchema;

export const feedsListDataSchema = z.object({
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      catalog_id: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const feedsListErrorSchema = errorSchema;

export const catalogsFeedsCreateRequestSchema = z.object({
  default_currency: nullableCurrencySchema.optional(),
  name: z.string(),
  format: catalogsFormatSchema,
  default_locale: z.union([catalogsLocaleSchema, z.string()]).optional(),
  credentials: catalogsFeedCredentialsSchema.optional(),
  location: z.string(),
  preferred_processing_schedule: catalogsFeedProcessingScheduleSchema.optional(),
  default_country: countrySchema.optional(),
  default_availability: productAvailabilityTypeSchema.optional(),
  status: catalogsStatusSchema.and(z.unknown()).optional(),
});

export const feedsCreateErrorSchema = errorSchema;

export const feedsGetDataSchema = z.object({
  path: z.object({
    feed_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const feedsGetErrorSchema = errorSchema;

export const feedsUpdateDataSchema = z.object({
  body: z.union([catalogsVerticalFeedsUpdateRequestSchema, catalogsFeedsUpdateRequestSchema]),
  path: z.object({
    feed_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const feedsUpdateErrorSchema = errorSchema;

export const feedsDeleteDataSchema = z.object({
  path: z.object({
    feed_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const feedsDeleteResponseSchema = z.any();

export const feedsDeleteErrorSchema = errorSchema;

export const feedsIngestDataSchema = z.object({
  path: z.object({
    feed_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const catalogsFeedIngestionSchema = z.object({
  id: z.string(),
  feed_id: z.string(),
  created_at: z.string(),
  status: catalogsFeedProcessingStatusSchema,
});

export const feedsIngestErrorSchema = errorSchema;

export const feedProcessingResultsListDataSchema = z.object({
  path: z.object({
    feed_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const feedProcessingResultsListErrorSchema = errorSchema;

export const itemsIssuesListDataSchema = z.object({
  path: z.object({
    processing_result_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      item_numbers: z.array(z.number()).optional(),
      item_validation_issue: catalogsItemValidationIssueSchema.optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const itemsIssuesListErrorSchema = errorSchema;

export const itemsGetDataSchema = z.object({
  query: z.object({
    ad_account_id: z.string().optional(),
    country: z.string(),
    filters: catalogsItemsFiltersSchema.optional(),
    item_ids: z.array(z.string()).optional(),
    language: z.string(),
  }),
});

export const itemsGetErrorSchema = errorSchema;

export const itemsPostDataSchema = z.object({
  body: catalogsItemsRequestSchema,
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const itemsPostErrorSchema = errorSchema;

export const itemsBatchPostErrorSchema = errorSchema;

export const itemsBatchGetDataSchema = z.object({
  path: z.object({
    batch_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const itemsBatchGetErrorSchema = errorSchema;

export const catalogsProductGroupsDeleteManyDataSchema = z.object({
  query: z.object({
    ad_account_id: z.string().optional(),
    id: z.array(z.number()),
  }),
});

export const catalogsProductGroupsDeleteManyResponseSchema = z.any();

export const catalogsProductGroupsDeleteManyErrorSchema = errorSchema;

export const catalogsProductGroupsCreateManyResponseSchema = z.array(z.string());

export const catalogsProductGroupsCreateManyErrorSchema = errorSchema;

export const catalogsProductGroupsListDataSchema = z.object({
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      catalog_id: z.string().optional(),
      feed_id: z.string().optional(),
      id: z.array(z.number()).optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const catalogsProductGroupsListErrorSchema = errorSchema;

export const catalogsProductGroupsCreateErrorSchema = errorSchema;

export const catalogsProductGroupsGetDataSchema = z.object({
  path: z.object({
    product_group_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const catalogsProductGroupsGetErrorSchema = errorSchema;

export const catalogsProductGroupsDeleteDataSchema = z.object({
  path: z.object({
    product_group_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const catalogsProductGroupsDeleteResponseSchema = z.any();

export const catalogsProductGroupsDeleteErrorSchema = errorSchema;

export const catalogsProductGroupsUpdateErrorSchema = errorSchema;

export const catalogsProductGroupsProductCountsGetDataSchema = z.object({
  path: z.object({
    product_group_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const catalogsProductGroupProductCountsVerticalSchema = z
  .union([
    catalogsRetailProductGroupProductCountsSchema,
    catalogsHotelProductGroupProductCountsSchema,
    catalogsCreativeAssetsProductGroupProductCountsSchema,
  ])
  .and(
    z.object({
      catalog_type: catalogsTypeSchema,
    }),
  );

export const catalogsProductGroupsProductCountsGetErrorSchema = errorSchema;

export const catalogsProductGroupPinsListDataSchema = z.object({
  path: z.object({
    product_group_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
      pin_metrics: z.boolean().optional(),
    })
    .optional(),
});

export const catalogsProductGroupPinsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.unknown().optional(),
  }),
);

export const catalogsProductGroupPinsListErrorSchema = errorSchema;

export const productsByProductGroupFilterListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.unknown().optional(),
  }),
);

export const productsByProductGroupFilterListErrorSchema = errorSchema;

export const reportsCreateResponseSchema = catalogsCreateReportResponseSchema;

export const reportsCreateErrorSchema = errorSchema;

export const reportsGetDataSchema = z.object({
  query: z.object({
    ad_account_id: z.string().optional(),
    token: z.string(),
  }),
});

export const reportsGetResponseSchema = catalogsReportSchema;

export const reportsGetErrorSchema = errorSchema;

export const reportsStatsErrorSchema = errorSchema;

export const integrationsCommercePostDataSchema = z.object({
  body: integrationRequestSchema.optional(),
});

export const integrationsCommercePostResponseSchema = integrationMetadataSchema;

export const integrationsCommercePostErrorSchema = errorSchema;

export const integrationsCommerceGetDataSchema = z.object({
  path: z.object({
    external_business_id: z.string(),
  }),
});

export const integrationsCommerceGetResponseSchema = integrationMetadataSchema;

export const integrationsCommerceGetErrorSchema = errorSchema;

export const integrationsCommercePatchDataSchema = z.object({
  body: integrationRequestPatchSchema.optional(),
  path: z.object({
    external_business_id: z.string(),
  }),
});

export const integrationsCommercePatchResponseSchema = integrationMetadataSchema;

export const integrationsCommercePatchErrorSchema = errorSchema;

export const integrationsCommerceDelDataSchema = z.object({
  path: z.object({
    external_business_id: z.string(),
  }),
});

export const integrationsCommerceDelResponseSchema = z.any();

export const integrationsCommerceDelErrorSchema = errorSchema;

export const integrationLogsRequestSchema = z.object({
  logs: z.array(integrationLogSchema),
});

export const integrationsLogsPostResponseSchema = integrationLogsSuccessResponseSchema;

export const integrationsLogsPostErrorSchema = z.union([detailedErrorSchema, errorSchema]);

export const integrationsGetListDataSchema = z.object({
  query: z
    .object({
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const integrationsGetListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(integrationRecordSchema).optional(),
  }),
);

export const integrationsGetListErrorSchema = errorSchema;

export const integrationsGetByIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const integrationsGetByIdResponseSchema = integrationRecordSchema;

export const integrationsGetByIdErrorSchema = errorSchema;

export const mediaListDataSchema = z.object({
  query: z
    .object({
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const mediaListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.unknown().optional(),
  }),
);

export const mediaListErrorSchema = errorSchema;

export const mediaCreateDataSchema = z.object({
  body: mediaUploadRequestSchema,
});

export const mediaUploadSchema = z.object({
  media_id: z.string().optional(),
  media_type: mediaUploadTypeSchema.optional(),
  upload_url: z.string().optional(),
  upload_parameters: z
    .object({
      'x-amz-date': z.string().optional(),
      'x-amz-signature': z.string().optional(),
      'x-amz-security-token': z.string().optional(),
      'x-amz-algorithm': z.string().optional(),
      key: z.string().optional(),
      policy: z.string().optional(),
      'x-amz-credential': z.string().optional(),
      'Content-Type': z.string().optional(),
    })
    .optional(),
});

export const mediaCreateErrorSchema = errorSchema;

export const mediaGetDataSchema = z.object({
  path: z.object({
    media_id: z.string(),
  }),
});

export const mediaUploadDetailsSchema = z.object({
  media_id: z.string().optional(),
  media_type: mediaUploadTypeSchema.optional(),
  status: mediaUploadStatusSchema.optional(),
});

export const mediaGetErrorSchema = errorSchema;

export const oauthTokenDataSchema = z.object({
  body: oauthAccessTokenRequestSchema,
});

export const oauthTokenResponseSchema = oauthAccessTokenResponseSchema;

export const oauthTokenErrorSchema = errorSchema;

export const pinsListDataSchema = z.object({
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      creative_types: z
        .array(
          z.union([
            z.literal('REGULAR'),
            z.literal('VIDEO'),
            z.literal('SHOPPING'),
            z.literal('CAROUSEL'),
            z.literal('MAX_VIDEO'),
            z.literal('SHOP_THE_PIN'),
            z.literal('COLLECTION'),
            z.literal('IDEA'),
          ]),
        )
        .optional(),
      include_protected_pins: z.boolean().optional(),
      page_size: z.number().optional(),
      pin_filter: z
        .union([z.literal('exclude_native'), z.literal('exclude_repins'), z.literal('has_been_promoted')])
        .optional(),
      pin_metrics: z.boolean().optional(),
      pin_type: z.literal('PRIVATE').optional(),
    })
    .optional(),
});

export const pinsListErrorSchema = errorSchema;

export const pinsCreateErrorSchema = errorSchema;

export const pinsGetDataSchema = z.object({
  path: z.object({
    pin_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
      pin_metrics: z.boolean().optional(),
    })
    .optional(),
});

export const pinsGetErrorSchema = errorSchema;

export const pinsDeleteDataSchema = z.object({
  path: z.object({
    pin_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const pinsDeleteResponseSchema = z.any();

export const pinsDeleteErrorSchema = errorSchema;

export const pinsUpdateDataSchema = z.object({
  body: pinUpdateSchema,
  path: z.object({
    pin_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const pinsUpdateErrorSchema = errorSchema;

export const pinsAnalyticsDataSchema = z.object({
  path: z.object({
    pin_id: z.string(),
  }),
  query: z.object({
    ad_account_id: z.string().optional(),
    app_types: z.union([z.literal('ALL'), z.literal('MOBILE'), z.literal('TABLET'), z.literal('WEB')]).optional(),
    end_date: z.string(),
    metric_types: z.array(
      z.union([
        z.literal('IMPRESSION'),
        z.literal('OUTBOUND_CLICK'),
        z.literal('PIN_CLICK'),
        z.literal('SAVE'),
        z.literal('SAVE_RATE'),
        z.literal('TOTAL_COMMENTS'),
        z.literal('TOTAL_REACTIONS'),
        z.literal('USER_FOLLOW'),
        z.literal('PROFILE_VISIT'),
        z.literal('IMPRESSION'),
        z.literal('OUTBOUND_CLICK'),
        z.literal('PIN_CLICK'),
        z.literal('SAVE'),
        z.literal('SAVE_RATE'),
        z.literal('VIDEO_MRC_VIEW'),
        z.literal('VIDEO_10S_VIEW'),
        z.literal('QUARTILE_95_PERCENT_VIEW'),
        z.literal('VIDEO_V50_WATCH_TIME'),
        z.literal('VIDEO_START'),
        z.literal('VIDEO_AVG_WATCH_TIME'),
        z.literal('TOTAL_COMMENTS'),
        z.literal('TOTAL_REACTIONS'),
      ]),
    ),
    split_field: z.union([z.literal('NO_SPLIT'), z.literal('APP_TYPE')]).optional(),
    start_date: z.string(),
  }),
});

export const pinsAnalyticsResponseSchema = pinAnalyticsResponseSchema;

export const pinsAnalyticsErrorSchema = errorSchema;

export const multiPinsAnalyticsDataSchema = z.object({
  query: z.object({
    ad_account_id: z.string().optional(),
    app_types: z.union([z.literal('ALL'), z.literal('MOBILE'), z.literal('TABLET'), z.literal('WEB')]).optional(),
    end_date: z.string(),
    metric_types: z.array(
      z.union([
        z.literal('IMPRESSION'),
        z.literal('OUTBOUND_CLICK'),
        z.literal('PIN_CLICK'),
        z.literal('SAVE'),
        z.literal('SAVE_RATE'),
        z.literal('TOTAL_COMMENTS'),
        z.literal('TOTAL_REACTIONS'),
        z.literal('USER_FOLLOW'),
        z.literal('PROFILE_VISIT'),
        z.literal('IMPRESSION'),
        z.literal('OUTBOUND_CLICK'),
        z.literal('PIN_CLICK'),
        z.literal('SAVE'),
        z.literal('SAVE_RATE'),
        z.literal('VIDEO_MRC_VIEW'),
        z.literal('VIDEO_10S_VIEW'),
        z.literal('QUARTILE_95_PERCENT_VIEW'),
        z.literal('VIDEO_V50_WATCH_TIME'),
        z.literal('VIDEO_START'),
        z.literal('VIDEO_AVG_WATCH_TIME'),
        z.literal('TOTAL_COMMENTS'),
        z.literal('TOTAL_REACTIONS'),
      ]),
    ),
    pin_ids: z.array(z.string()),
    start_date: z.string(),
  }),
});

export const multiPinsAnalyticsResponseSchema = bulkPinAnalyticsResponseSchema;

export const multiPinsAnalyticsErrorSchema = errorSchema;

export const pinsSaveDataSchema = z.object({
  body: z.object({
    board_id: z.string().optional().nullable(),
    board_section_id: z.string().optional().nullable(),
  }),
  path: z.object({
    pin_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const pinsSaveErrorSchema = errorSchema;

export const adAccountCountriesGetErrorSchema = errorSchema;

export const deliveryMetricsGetDataSchema = z.object({
  query: z
    .object({
      report_type: z.union([z.literal('SYNC'), z.literal('ASYNC')]).optional(),
    })
    .optional(),
});

export const deliveryMetricsGetResponseSchema = deliveryMetricsResponseSchema;

export const deliveryMetricsGetErrorSchema = errorSchema;

export const leadFormQuestionsGetResponseSchema = z.unknown();

export const leadFormQuestionsGetErrorSchema = errorSchema;

export const metricsReadyStateGetDataSchema = z.object({
  query: z.object({
    date: z.string(),
  }),
});

export const metricsReadyStateGetResponseSchema = bookClosedResponseSchema;

export const metricsReadyStateGetErrorSchema = errorSchema;

export const interestTargetingOptionsGetDataSchema = z.object({
  path: z.object({
    interest_id: z.string(),
  }),
});

export const interestTargetingOptionsGetResponseSchema = singleInterestTargetingOptionResponseSchema;

export const interestTargetingOptionsGetErrorSchema = errorSchema;

export const targetingOptionsGetDataSchema = z.object({
  path: z.object({
    targeting_type: z.union([
      z.literal('APPTYPE'),
      z.literal('GENDER'),
      z.literal('LOCALE'),
      z.literal('AGE_BUCKET'),
      z.literal('LOCATION'),
      z.literal('GEO'),
      z.literal('INTEREST'),
      z.literal('KEYWORD'),
      z.literal('AUDIENCE_INCLUDE'),
      z.literal('AUDIENCE_EXCLUDE'),
    ]),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
      client_id: z.string().optional(),
      oauth_signature: z.string().optional(),
      timestamp: z.string().optional(),
    })
    .optional(),
});

export const targetingOptionsGetResponseSchema = targetingOptionResponseSchema;

export const targetingOptionsGetErrorSchema = errorSchema;

export const searchUserBoardsGetDataSchema = z.object({
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
      query: z.string().optional(),
    })
    .optional(),
});

export const searchUserBoardsGetResponseSchema = paginatedSchema.and(
  z.object({
    items: z.unknown().optional(),
  }),
);

export const searchUserBoardsGetErrorSchema = errorSchema;

export const searchUserPinsListDataSchema = z.object({
  query: z.object({
    ad_account_id: z.string().optional(),
    bookmark: z.string().optional(),
    query: z.string(),
  }),
});

export const searchUserPinsListErrorSchema = errorSchema;

export const searchPartnerPinsDataSchema = z.object({
  query: z.object({
    bookmark: z.string().optional(),
    country_code: z.string(),
    limit: z.number().optional(),
    locale: z.string().optional(),
    term: z.string(),
  }),
});

export const searchPartnerPinsErrorSchema = errorSchema;

export const termsRelatedListDataSchema = z.object({
  query: z.object({
    terms: z.array(z.string()),
  }),
});

export const termsRelatedListResponseSchema = relatedTermsSchema;

export const termsRelatedListErrorSchema = errorSchema;

export const termsSuggestedListDataSchema = z.object({
  query: z.object({
    limit: z.number().optional(),
    term: z.string(),
  }),
});

export const termsSuggestedListResponseSchema = termsSuggestedResponseSchema;

export const termsSuggestedListErrorSchema = errorSchema;

export const trendingKeywordsListDataSchema = z.object({
  path: z.object({
    region: trendsSupportedRegionSchema,
    trend_type: trendTypeSchema,
  }),
  query: z
    .object({
      ages: ageBucketListSchema.optional(),
      genders: genderListSchema.optional(),
      include_keywords: keywordListSchema.optional(),
      interests: l1InterestListSchema.optional(),
      limit: z.number().optional(),
      normalize_against_group: z.boolean().optional(),
    })
    .optional(),
});

export const trendingKeywordsListResponseSchema = trendingKeywordsResponseSchema;

export const trendingKeywordsListErrorSchema = errorSchema;

export const userAccountGetDataSchema = z.object({
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const userAccountGetResponseSchema = accountSchema;

export const userAccountGetErrorSchema = errorSchema;

export const userAccountAnalyticsDataSchema = z.object({
  query: z.object({
    ad_account_id: z.string().optional(),
    app_types: z.union([z.literal('ALL'), z.literal('MOBILE'), z.literal('TABLET'), z.literal('WEB')]).optional(),
    content_type: z.union([z.literal('ALL'), z.literal('PAID'), z.literal('ORGANIC')]).optional(),
    end_date: z.string(),
    from_claimed_content: z.union([z.literal('OTHER'), z.literal('CLAIMED'), z.literal('BOTH')]).optional(),
    metric_types: z
      .array(
        z.union([
          z.literal('ENGAGEMENT'),
          z.literal('ENGAGEMENT_RATE'),
          z.literal('IMPRESSION'),
          z.literal('OUTBOUND_CLICK'),
          z.literal('OUTBOUND_CLICK_RATE'),
          z.literal('PIN_CLICK'),
          z.literal('PIN_CLICK_RATE'),
          z.literal('SAVE'),
          z.literal('SAVE_RATE'),
        ]),
      )
      .optional(),
    pin_format: z
      .union([
        z.literal('ALL'),
        z.literal('ORGANIC_IMAGE'),
        z.literal('ORGANIC_PRODUCT'),
        z.literal('ORGANIC_VIDEO'),
        z.literal('ADS_STANDARD'),
        z.literal('ADS_PRODUCT'),
        z.literal('ADS_VIDEO'),
        z.literal('ADS_IDEA'),
      ])
      .optional(),
    source: z.union([z.literal('ALL'), z.literal('YOUR_PINS'), z.literal('OTHER_PINS')]).optional(),
    split_field: z
      .union([
        z.literal('NO_SPLIT'),
        z.literal('APP_TYPE'),
        z.literal('OWNED_CONTENT'),
        z.literal('SOURCE'),
        z.literal('PIN_FORMAT'),
      ])
      .optional(),
    start_date: z.string(),
  }),
});

export const userAccountAnalyticsErrorSchema = errorSchema;

export const userAccountAnalyticsTopPinsDataSchema = z.object({
  query: z.object({
    ad_account_id: z.string().optional(),
    app_types: z.union([z.literal('ALL'), z.literal('MOBILE'), z.literal('TABLET'), z.literal('WEB')]).optional(),
    content_type: z.union([z.literal('ALL'), z.literal('PAID'), z.literal('ORGANIC')]).optional(),
    created_in_last_n_days: z.literal(30).optional(),
    end_date: z.string(),
    from_claimed_content: z.union([z.literal('OTHER'), z.literal('CLAIMED'), z.literal('BOTH')]).optional(),
    metric_types: z
      .array(
        z.union([
          z.literal('ENGAGEMENT'),
          z.literal('ENGAGEMENT_RATE'),
          z.literal('IMPRESSION'),
          z.literal('OUTBOUND_CLICK'),
          z.literal('OUTBOUND_CLICK_RATE'),
          z.literal('PIN_CLICK'),
          z.literal('PIN_CLICK_RATE'),
          z.literal('SAVE'),
          z.literal('SAVE_RATE'),
        ]),
      )
      .optional(),
    num_of_pins: z.number().optional(),
    pin_format: z
      .union([
        z.literal('ALL'),
        z.literal('ORGANIC_IMAGE'),
        z.literal('ORGANIC_PRODUCT'),
        z.literal('ORGANIC_VIDEO'),
        z.literal('ADS_STANDARD'),
        z.literal('ADS_PRODUCT'),
        z.literal('ADS_VIDEO'),
        z.literal('ADS_IDEA'),
      ])
      .optional(),
    sort_by: z.union([
      z.literal('ENGAGEMENT'),
      z.literal('IMPRESSION'),
      z.literal('OUTBOUND_CLICK'),
      z.literal('PIN_CLICK'),
      z.literal('SAVE'),
    ]),
    source: z.union([z.literal('ALL'), z.literal('YOUR_PINS'), z.literal('OTHER_PINS')]).optional(),
    start_date: z.string(),
  }),
});

export const userAccountAnalyticsTopPinsResponseSchema = topPinsAnalyticsResponseSchema;

export const userAccountAnalyticsTopPinsErrorSchema = errorSchema;

export const userAccountAnalyticsTopVideoPinsDataSchema = z.object({
  query: z.object({
    ad_account_id: z.string().optional(),
    app_types: z.union([z.literal('ALL'), z.literal('MOBILE'), z.literal('TABLET'), z.literal('WEB')]).optional(),
    content_type: z.union([z.literal('ALL'), z.literal('PAID'), z.literal('ORGANIC')]).optional(),
    created_in_last_n_days: z.literal(30).optional(),
    end_date: z.string(),
    from_claimed_content: z.union([z.literal('OTHER'), z.literal('CLAIMED'), z.literal('BOTH')]).optional(),
    metric_types: z
      .array(
        z.union([
          z.literal('IMPRESSION'),
          z.literal('SAVE'),
          z.literal('VIDEO_MRC_VIEW'),
          z.literal('VIDEO_AVG_WATCH_TIME'),
          z.literal('VIDEO_V50_WATCH_TIME'),
          z.literal('QUARTILE_95_PERCENT_VIEW'),
          z.literal('VIDEO_10S_VIEW'),
          z.literal('VIDEO_START'),
          z.literal('OUTBOUND_CLICK'),
        ]),
      )
      .optional(),
    num_of_pins: z.number().optional(),
    pin_format: z
      .union([
        z.literal('ALL'),
        z.literal('ORGANIC_IMAGE'),
        z.literal('ORGANIC_PRODUCT'),
        z.literal('ORGANIC_VIDEO'),
        z.literal('ADS_STANDARD'),
        z.literal('ADS_PRODUCT'),
        z.literal('ADS_VIDEO'),
        z.literal('ADS_IDEA'),
      ])
      .optional(),
    sort_by: z.union([
      z.literal('IMPRESSION'),
      z.literal('SAVE'),
      z.literal('OUTBOUND_CLICK'),
      z.literal('VIDEO_MRC_VIEW'),
      z.literal('VIDEO_AVG_WATCH_TIME'),
      z.literal('VIDEO_V50_WATCH_TIME'),
      z.literal('QUARTILE_95_PERCENT_VIEW'),
      z.literal('VIDEO_10S_VIEW'),
      z.literal('VIDEO_START'),
    ]),
    source: z.union([z.literal('ALL'), z.literal('YOUR_PINS'), z.literal('OTHER_PINS')]).optional(),
    start_date: z.string(),
  }),
});

export const userAccountAnalyticsTopVideoPinsResponseSchema = topVideoPinsAnalyticsResponseSchema;

export const userAccountAnalyticsTopVideoPinsErrorSchema = errorSchema;

export const linkedBusinessAccountsGetResponseSchema = z.array(linkedBusinessSchema);

export const linkedBusinessAccountsGetErrorSchema = errorSchema;

export const followersListDataSchema = z.object({
  query: z
    .object({
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const followersListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(userSummarySchema).optional(),
  }),
);

export const followersListErrorSchema = errorSchema;

export const userFollowingGetDataSchema = z.object({
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      explicit_following: z.boolean().optional(),
      feed_type: userFollowingFeedTypeSchema.optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const userFollowingGetResponseSchema = paginatedSchema.and(
  z.object({
    items: z.unknown().optional(),
  }),
);

export const userFollowingGetErrorSchema = errorSchema;

export const boardsUserFollowsListDataSchema = z.object({
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      explicit_following: z.boolean().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const boardsUserFollowsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(boardSchema).optional(),
  }),
);

export const boardsUserFollowsListErrorSchema = errorSchema;

export const followUserUpdateDataSchema = z.object({
  body: followUserRequestSchema,
  path: z.object({
    username: z.string(),
  }),
});

export const followUserUpdateResponseSchema = userSummarySchema;

export const followUserUpdateErrorSchema = errorSchema;

export const verifyWebsiteUpdateDataSchema = z.object({
  body: userWebsiteVerifyRequestSchema,
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const verifyWebsiteUpdateResponseSchema = userWebsiteSummarySchema;

export const verifyWebsiteUpdateErrorSchema = errorSchema;

export const userWebsitesGetDataSchema = z.object({
  query: z
    .object({
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const userWebsitesGetResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(userWebsiteSummarySchema).optional(),
  }),
);

export const userWebsitesGetErrorSchema = errorSchema;

export const unverifyWebsiteDeleteDataSchema = z.object({
  query: z.object({
    website: z.string(),
  }),
});

export const unverifyWebsiteDeleteResponseSchema = z.any();

export const unverifyWebsiteDeleteErrorSchema = errorSchema;

export const websiteVerificationGetDataSchema = z.object({
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const websiteVerificationGetResponseSchema = userWebsiteVerificationCodeSchema;

export const websiteVerificationGetErrorSchema = errorSchema;

export const userAccountFollowedInterestsDataSchema = z.object({
  path: z.object({
    username: z.string(),
  }),
  query: z
    .object({
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const userAccountFollowedInterestsResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(interestSchema).optional(),
  }),
);

export const userAccountFollowedInterestsErrorSchema = errorSchema;

export const adAccountsCountryResponseDataSchema = z.object({
  code: adCountrySchema.optional(),
  currency: z.string().optional(),
  index: z.number().optional(),
  name: z.string().optional(),
});

export const quizPinDataSchema = z
  .object({
    questions: z.array(quizPinQuestionSchema).optional(),
    results: z.array(quizPinResultSchema).optional(),
    tie_breaker_type: z.union([z.literal('RANDOM'), z.literal('CUSTOM')]).optional(),
    tie_breaker_custom_result: quizPinResultSchema.optional(),
  })
  .nullable();

export const adCommonSchema = z.object({
  ad_group_id: z.string().optional(),
  android_deep_link: z.string().optional().nullable(),
  carousel_android_deep_links: z.array(z.string()).optional().nullable(),
  carousel_destination_urls: z.array(z.string()).optional().nullable(),
  carousel_ios_deep_links: z.array(z.string()).optional().nullable(),
  click_tracking_url: z.string().optional().nullable(),
  creative_type: creativeTypeSchema.optional(),
  destination_url: z.string().optional().nullable(),
  ios_deep_link: z.string().optional().nullable(),
  is_pin_deleted: z.boolean().optional(),
  is_removable: z.boolean().optional(),
  name: z.string().optional().nullable(),
  status: entityStatusSchema.optional(),
  tracking_urls: trackingUrlsSchema.optional().nullable(),
  view_tracking_url: z.string().optional().nullable(),
  lead_form_id: z.string().optional().nullable(),
  grid_click_type: gridClickTypeSchema.optional(),
  customizable_cta_type: z
    .union([
      z.literal('GET_OFFER'),
      z.literal('LEARN_MORE'),
      z.literal('ORDER_NOW'),
      z.literal('SHOP_NOW'),
      z.literal('SIGN_UP'),
      z.literal('SUBSCRIBE'),
      z.literal('BUY_NOW'),
      z.literal('CONTACT_US'),
      z.literal('GET_QUOTE'),
      z.literal('VISIT_SITE'),
      z.literal('APPLY_NOW'),
      z.literal('BOOK_NOW'),
      z.literal('REQUEST_DEMO'),
      z.literal('REGISTER_NOW'),
      z.literal('FIND_A_DEALER'),
      z.literal('ADD_TO_CART'),
      z.literal('WATCH_NOW'),
      z.literal('READ_MORE'),
    ])
    .optional()
    .nullable(),
  quiz_pin_data: quizPinDataSchema.optional().nullable(),
});

export const advancedAuctionKeySchema = z.object({
  item_id: z.string(),
  country: countrySchema,
  language: languageSchema,
});

export const advancedAuctionItemsSubmitDeleteRecordSchema = advancedAuctionKeySchema;

export const appTypeMultipliersSchema = z
  .record(z.union([z.union([z.number(), targetingSpecAppTypeSchema]), z.undefined()]))
  .and(
    z.object({
      APP_TYPE: targetingSpecAppTypeSchema.optional(),
    }),
  )
  .nullable();

export const adGroupArrayResponseElementSchema = z.object({
  data: adGroupResponseSchema.optional(),
  exceptions: z.array(exceptionSchema).optional(),
});

export const adResponseSchema = adCommonSchema.and(adPinIdSchema).and(
  z.object({
    ad_account_id: z.string().optional(),
    campaign_id: z.string().optional(),
    collection_items_destination_url_template: z.string().optional().nullable(),
    created_time: z.number().optional(),
    id: z.string().optional(),
    rejected_reasons: z
      .array(
        z.union([
          z.literal('HASHTAGS'),
          z.literal('PROMOTIONS_AND_PRICES'),
          z.literal('TARGETING'),
          z.literal('LANDING_PAGE'),
          z.literal('CAPS_AND_SYMBOLS'),
          z.literal('SHOCKING'),
          z.literal('WEIGHT_LOSS'),
          z.literal('PROHIBITED_PRODUCT'),
          z.literal('AUTHENTICITY'),
          z.literal('NUDITY'),
          z.literal('CONFUSING_DESIGN'),
          z.literal('URGENCY'),
          z.literal('RATINGS'),
          z.literal('APP'),
          z.literal('ALCOHOL'),
          z.literal('CONTESTS'),
          z.literal('POLITICAL'),
          z.literal('OTHER'),
          z.literal('IMAGE'),
          z.literal('NAR'),
          z.literal('INCONSISTENT'),
          z.literal('CLICKBAIT'),
          z.literal('NO_DESCRIPTION'),
          z.literal('LOW_QUALITY'),
          z.literal('EXAGGERATED_CLAIMS'),
          z.literal('PINTEREST_BRAND'),
          z.literal('ALCOHOL_NO_SALE'),
          z.literal('LANDING_PAGE_SPEED'),
          z.literal('LANDING_PAGE_HARDWALL'),
          z.literal('LANDING_PAGE_BROKEN'),
          z.literal('LANDING_PAGE_QUALITY'),
          z.literal('OUT_OF_STOCK'),
          z.literal('IMAGE_LOW_QUALITY'),
          z.literal('IMAGE_BUSY'),
          z.literal('IMAGE_POORLY_EDITED'),
          z.literal('IMAGE_BEFORE_AFTER'),
          z.literal('UGC'),
          z.literal('FAKE_BUTTONS'),
          z.literal('WEAPONS'),
          z.literal('SENSITIVE'),
          z.literal('UNACCEPTABLE_BUSINESS'),
          z.literal('SUSPICIOUS_CLAIMS'),
          z.literal('PHARMA'),
          z.literal('SUSPICIOUS_SUPPLEMENTS'),
          z.literal('ILLEGAL_RECREATIONAL_DRUG'),
          z.literal('LOW_QUALITY_LANDING_PAGE'),
          z.literal('RESTRICTED_HEALTHCARE'),
          z.literal('INCONSISTENT_LANG_FR'),
        ]),
      )
      .optional(),
    rejection_labels: z.array(z.string()).optional(),
    review_status: z
      .union([z.literal('OTHER'), z.literal('PENDING'), z.literal('REJECTED'), z.literal('APPROVED')])
      .optional(),
    type: z.string().optional(),
    updated_time: z.number().optional(),
    summary_status: pinPromotionSummaryStatusSchema.optional(),
  }),
);

export const adUpdateRequestSchema = adCommonSchema.and(
  z.object({
    id: z.string(),
    pin_id: z.string().optional().nullable(),
  }),
);

export const analyticsMetricsResponseSchema = z.object({
  summary_metrics: z.record(z.number()).optional(),
  daily_metrics: z.array(analyticsDailyMetricsSchema).optional(),
});

export const analyticsResponseSchema = z.record(analyticsMetricsResponseSchema);

export const assetIdPermissionsSchema = z.object({
  asset_id: z.string().optional(),
  asset_type: assetTypeResponseSchema.optional(),
  permissions: permissionsResponseSchema.optional(),
  asset_group_info: assetGroupBindingSchema.optional().nullable(),
});

export const audienceInsightCategoryArrayResponseSchema = z.object({
  items: z.array(audienceInsightCategoryCommonSchema).optional(),
});

export const bulkUpsertRequestUpdateSchema = z.object({
  campaigns: z.array(campaignUpdateRequestSchema).optional(),
  ad_groups: z.array(adGroupUpdateRequestSchema).optional(),
  ads: z.array(adUpdateRequestSchema).optional(),
  product_groups: z.array(productGroupPromotionUpdateRequestSchema).optional(),
  keywords: z.array(keywordUpdateSchema).optional(),
});

export const adCreateRequestSchema = adCommonSchema.and(adPinIdSchema).and(z.record(z.unknown()));

export const campaignCreateResponseDataSchema = campaignCreateCommonSchema.and(campaignResponseSchema).and(
  z.object({
    objective_type: objectiveTypeSchema.optional(),
  }),
);

export const campaignCreateResponseItemSchema = z.object({
  data: campaignCreateResponseDataSchema.optional(),
  exceptions: z.array(exceptionSchema).optional(),
});

export const campaignCreateResponseSchema = z.object({
  items: z.array(campaignCreateResponseItemSchema).optional(),
});

export const catalogsReportStatsSchema = z
  .union([catalogsReportFeedIngestionStatsSchema, catalogsReportDistributionStatsSchema])
  .and(
    z.object({
      report_type: z.union([z.literal('FEED_INGESTION_ISSUES'), z.literal('DISTRIBUTION_ISSUES')]),
    }),
  );

export const catalogsHotelReportParametersSchema = z.object({
  catalog_type: z.literal('HOTEL'),
  report: z.union([catalogsReportFeedIngestionFilterSchema, catalogsReportDistributionIssueFilterSchema]).and(
    z.object({
      report_type: z.union([z.literal('FEED_INGESTION_ISSUES'), z.literal('DISTRIBUTION_ISSUES')]).optional(),
    }),
  ),
});

export const catalogsUpdateHotelItemSchema = z.object({
  hotel_id: z.string(),
  operation: z.literal('UPDATE'),
  attributes: catalogsUpdatableHotelAttributesSchema,
});

export const catalogsRetailFeedSchema = catalogsDbItemSchema.and(
  z.object({
    name: z.string().nullable(),
    format: catalogsFormatSchema,
    catalog_type: catalogsTypeSchema,
    credentials: catalogsFeedCredentialsSchema,
    location: z.string(),
    preferred_processing_schedule: catalogsFeedProcessingScheduleSchema,
    status: catalogsStatusSchema,
    default_currency: nullableCurrencySchema,
    default_locale: z.string(),
    default_country: countrySchema,
    default_availability: productAvailabilityTypeSchema,
  }),
);

export const catalogsCreativeAssetsFeedSchema = catalogsDbItemSchema.and(
  z.object({
    name: z.string().nullable(),
    format: catalogsFormatSchema,
    catalog_type: catalogsTypeSchema,
    credentials: catalogsFeedCredentialsSchema,
    location: z.string(),
    preferred_processing_schedule: catalogsFeedProcessingScheduleSchema,
    status: catalogsStatusSchema,
    default_currency: nullableCurrencySchema,
    default_locale: z.string(),
    default_country: countrySchema,
    catalog_id: z.string().nullable(),
  }),
);

export const catalogsFeedValidationDetailsSchema = z.object({
  errors: catalogsFeedValidationErrorsSchema,
  warnings: catalogsFeedValidationWarningsSchema,
});

export const catalogsHotelAttributesSchema = z
  .object({
    main_image: z
      .object({
        link: z.string().optional(),
        tag: z.array(z.string()).optional().nullable(),
      })
      .optional(),
    additional_image_link: z.array(z.string()).optional().nullable(),
  })
  .and(catalogsUpdatableHotelAttributesSchema);

export const catalogsItemValidationIssuesSchema = z.object({
  item_number: z.number(),
  item_id: z.string().nullable(),
  errors: catalogsItemValidationErrorsSchema,
  warnings: catalogsItemValidationWarningsSchema,
});

export const catalogsRetailItemsBatchSchema = z.object({
  batch_id: z.string().optional(),
  created_time: z.string().optional(),
  completed_time: z.string().optional().nullable(),
  status: batchOperationStatusSchema.optional(),
  catalog_type: z.literal('RETAIL'),
  items: z.array(itemProcessingRecordSchema).optional(),
});

export const catalogsHotelItemsBatchSchema = z.object({
  batch_id: z.string().optional(),
  created_time: z.string().optional(),
  completed_time: z.string().optional().nullable(),
  status: batchOperationStatusSchema.optional(),
  catalog_type: z.literal('HOTEL'),
  items: z.array(hotelProcessingRecordSchema).optional(),
});

export const creativeAssetsProcessingRecordSchema = z.object({
  creative_assets_id: z.string().optional(),
  errors: z.array(itemValidationEventSchema).optional(),
  warnings: z.array(itemValidationEventSchema).optional(),
  status: itemProcessingStatusSchema.optional(),
});

export const catalogsItemsUpdateBatchRequestSchema = z.object({
  country: countrySchema,
  language: z.union([catalogsLocaleSchema, languageSchema]),
  operation: z.literal('UPDATE'),
  items: z.array(itemUpdateBatchRecordSchema),
});

export const catalogsItemsUpsertBatchRequestSchema = z.object({
  country: countrySchema,
  language: z.union([catalogsLocaleSchema, languageSchema]),
  operation: z.literal('UPSERT'),
  items: z.array(itemUpsertBatchRecordSchema),
});

export const catalogsItemsCreateBatchRequestSchema = z.object({
  country: countrySchema,
  language: z.union([catalogsLocaleSchema, languageSchema]),
  operation: z.literal('CREATE'),
  items: z.array(itemCreateBatchRecordSchema),
});

export const catalogsItemsDeleteDiscontinuedBatchRequestSchema = z.object({
  country: countrySchema,
  language: z.union([catalogsLocaleSchema, languageSchema]),
  operation: z.literal('DELETE_DISCONTINUED'),
  items: z.array(itemDeleteDiscontinuedBatchRecordSchema),
});

export const catalogsItemsDeleteBatchRequestSchema = z.object({
  country: countrySchema,
  language: z.union([catalogsLocaleSchema, languageSchema]),
  operation: z.literal('DELETE'),
  items: z.array(itemDeleteBatchRecordSchema),
});

export const mediaTypeFilterSchema = z.object({
  MEDIA_TYPE: catalogsProductGroupMultipleMediaTypesCriteriaSchema,
});

export const catalogsHotelProductGroupFilterKeysSchema = z.union([
  priceFilterSchema,
  hotelIdFilterSchema,
  brandFilterSchema,
  customLabel0FilterSchema,
  customLabel1FilterSchema,
  customLabel2FilterSchema,
  customLabel3FilterSchema,
  customLabel4FilterSchema,
  countryFilterSchema,
]);

export const catalogsHotelProductGroupFiltersAnyOfSchema = z.object({
  any_of: z.array(catalogsHotelProductGroupFilterKeysSchema),
});

export const catalogsHotelProductGroupFiltersAllOfSchema = z.object({
  all_of: z.array(catalogsHotelProductGroupFilterKeysSchema),
});

export const catalogsHotelProductGroupFiltersSchema = z.union([
  catalogsHotelProductGroupFiltersAnyOfSchema,
  catalogsHotelProductGroupFiltersAllOfSchema,
]);

export const catalogsHotelProductGroupUpdateRequestSchema = z.object({
  catalog_type: z.literal('HOTEL').optional(),
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  filters: catalogsHotelProductGroupFiltersSchema.optional(),
});

export const currencyFilterSchema = z.object({
  CURRENCY: catalogsProductGroupCurrencyCriteriaSchema,
});

export const genderFilterSchema = z.object({
  GENDER: catalogsProductGroupMultipleGenderCriteriaSchema,
});

export const catalogsProductGroupFilterKeysSchema = z.union([
  minPriceFilterSchema,
  maxPriceFilterSchema,
  currencyFilterSchema,
  itemIdFilterSchema,
  availabilityFilterSchema,
  brandFilterSchema,
  conditionFilterSchema,
  customLabel0FilterSchema,
  customLabel1FilterSchema,
  customLabel2FilterSchema,
  customLabel3FilterSchema,
  customLabel4FilterSchema,
  itemGroupIdFilterSchema,
  genderFilterSchema,
  mediaTypeFilterSchema,
  productType4FilterSchema,
  productType3FilterSchema,
  productType2FilterSchema,
  productType1FilterSchema,
  productType0FilterSchema,
  googleProductCategory6FilterSchema,
  googleProductCategory5FilterSchema,
  googleProductCategory4FilterSchema,
  googleProductCategory3FilterSchema,
  googleProductCategory2FilterSchema,
  googleProductCategory1FilterSchema,
  googleProductCategory0FilterSchema,
  productGroupReferenceFilterSchema,
]);

export const catalogsProductGroupFiltersRequestSchema = z.union([
  z.object({
    any_of: z.array(catalogsProductGroupFilterKeysSchema),
  }),
  z.object({
    all_of: z.array(catalogsProductGroupFilterKeysSchema),
  }),
]);

export const catalogsProductGroupFiltersAnyOfSchema = z.object({
  any_of: z.array(catalogsProductGroupFilterKeysSchema),
});

export const catalogsProductGroupUpdateRequestSchema = z.object({
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  is_featured: z.boolean().optional(),
  filters: catalogsProductGroupFiltersRequestSchema.optional(),
});

export const catalogsRetailProductMetadataSchema = z.object({
  item_id: z.string(),
  item_group_id: z.string().nullable(),
  availability: nonNullableProductAvailabilityTypeSchema,
  price: z.number(),
  sale_price: z.number().nullable(),
  currency: nonNullableCatalogsCurrencySchema,
});

export const catalogsCreateRetailItemSchema = z.object({
  item_id: z.string(),
  operation: z.literal('CREATE'),
  attributes: itemAttributesRequestSchema,
});

export const catalogsUpdateRetailItemSchema = z.object({
  item_id: z.string(),
  operation: z.literal('UPDATE'),
  attributes: updatableItemAttributesSchema,
  update_mask: z.array(updateMaskFieldTypeSchema).optional().nullable(),
});

export const catalogsUpsertRetailItemSchema = z.object({
  item_id: z.string(),
  operation: z.literal('UPSERT'),
  attributes: itemAttributesRequestSchema,
});

export const catalogsCreateHotelItemSchema = z.object({
  hotel_id: z.string(),
  operation: z.literal('CREATE'),
  attributes: catalogsHotelAttributesSchema,
});

export const catalogsUpsertHotelItemSchema = z.object({
  hotel_id: z.string(),
  operation: z.literal('UPSERT'),
  attributes: catalogsHotelAttributesSchema,
});

export const catalogsCreateCreativeAssetsItemSchema = z.object({
  creative_assets_id: z.string(),
  operation: z.literal('CREATE'),
  attributes: catalogsCreativeAssetsAttributesSchema,
});

export const catalogsUpsertCreativeAssetsItemSchema = z.object({
  creative_assets_id: z.string(),
  operation: z.literal('UPSERT'),
  attributes: catalogsCreativeAssetsAttributesSchema,
});

export const catalogsUpdateCreativeAssetsItemSchema = z.object({
  creative_assets_id: z.string(),
  operation: z.literal('UPDATE'),
  attributes: catalogsUpdatableCreativeAssetsAttributesSchema,
});

export const catalogsRetailProductGroupCreateRequestSchema = z.object({
  catalog_type: z.literal('RETAIL'),
  name: z.string(),
  description: z.string().optional().nullable(),
  filters: catalogsProductGroupFiltersRequestSchema,
  catalog_id: z.string(),
  country: countrySchema,
  locale: catalogsLocaleSchema,
});

export const catalogsHotelProductGroupCreateRequestSchema = z.object({
  catalog_type: z.literal('HOTEL'),
  name: z.string(),
  description: z.string().optional().nullable(),
  filters: catalogsHotelProductGroupFiltersSchema,
  catalog_id: z.string(),
});

export const catalogsRetailProductGroupUpdateRequestSchema = z.object({
  catalog_type: z.literal('RETAIL').optional(),
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  filters: catalogsProductGroupFiltersRequestSchema.optional(),
  country: countrySchema.optional(),
  locale: catalogsLocaleSchema.optional(),
});

export const conversionEventResponseSchema = z.object({
  conversion_event: conversionTagTypeSchema.optional(),
  conversion_tag_id: z.string().optional(),
  ad_account_id: z.string().optional(),
  created_time: z.number().optional(),
});

export const conversionTagListResponseSchema = z.object({
  items: z.array(conversionTagResponseSchema).optional(),
});

export const conversionTagsOcpmEligibleResponseSchema = z.record(z.array(conversionEventResponseSchema));

export const summaryPinSchema = z.object({
  media: pinMediaSchema.optional(),
  alt_text: z.string().optional().nullable(),
  link: z.string().optional().nullable(),
  title: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
});

export const itemBatchRecordSchema = z.union([
  itemCreateBatchRecordSchema,
  itemDeleteDiscontinuedBatchRecordSchema,
  itemUpdateBatchRecordSchema,
  itemUpsertBatchRecordSchema,
  itemDeleteBatchRecordSchema,
]);

export const leadFormQuestionSchema = z.object({
  question_type: leadFormQuestionTypeSchema.optional(),
  custom_question_field_type: leadFormQuestionFieldTypeSchema.optional(),
  custom_question_label: z.string().optional().nullable(),
  custom_question_options: z.array(z.string()).optional().nullable(),
});

export const leadFormCommonSchema = z.object({
  name: z.string().optional().nullable(),
  privacy_policy_link: z.string().optional().nullable(),
  has_accepted_terms: z.boolean().optional(),
  completion_message: z.string().optional().nullable(),
  status: leadFormStatusSchema.optional(),
  disclosure_language: z.string().optional().nullable(),
  questions: z.array(leadFormQuestionSchema).optional(),
  policy_links: z
    .array(
      z.object({
        label: z.string().optional(),
        link: z.string().optional(),
      }),
    )
    .optional(),
});

export const leadFormResponseSchema = leadFormCommonSchema.and(
  z.object({
    id: z.string().optional(),
    ad_account_id: z.string().optional(),
    created_time: z.number().optional(),
    updated_time: z.number().optional(),
  }),
);

export const leadFormCreateRequestSchema = leadFormCommonSchema.and(z.unknown());

export const leadFormUpdateRequestSchema = z
  .record(z.unknown())
  .and(leadFormCommonSchema)
  .and(
    z.object({
      id: z.string(),
    }),
  );

export const orderLineErrorSchema = z.object({
  data: orderLineSchema.optional(),
  error_messages: z.array(z.string()).optional(),
});

export const orderLineResponseSchema = z.object({
  errors: z.array(orderLineErrorSchema).optional(),
  order_line: z.array(orderLineSchema).optional(),
});

export const orderLineSingleResponseSchema = z.object({
  data: orderLineResponseSchema.optional(),
});

export const pinMediaSourceSchema = z.union([
  pinMediaSourceImageBase64Schema,
  pinMediaSourceImageURLSchema,
  pinMediaSourceVideoIDSchema,
  pinMediaSourceImagesBase64Schema,
  pinMediaSourceImagesURLSchema,
  pinMediaSourcePinURLSchema,
]);

export const pinCreateSchema = z
  .object({
    id: z.string().optional(),
    created_at: z.string().optional(),
    link: z.string().optional().nullable(),
    title: z.string().optional().nullable(),
    description: z.string().optional().nullable(),
    dominant_color: z.string().optional().nullable(),
    alt_text: z.string().optional().nullable(),
    board_id: z.string().optional(),
    board_section_id: z.string().optional().nullable(),
    board_owner: boardOwnerSchema.optional(),
    media: pinMediaSchema.optional(),
    media_source: pinMediaSourceSchema.optional(),
    parent_pin_id: z.string().optional().nullable(),
    note: z.string().optional().nullable(),
  })
  .nullable();

export const pinMediaWithImageAndVideoSchema = z
  .object({
    items: z.array(pinMediaMetadataSchema).optional(),
  })
  .and(pinMediaSchema);

export const catalogsReportParametersSchema = z
  .union([catalogsRetailReportParametersSchema, catalogsHotelReportParametersSchema])
  .and(
    z.object({
      catalog_type: catalogsTypeSchema,
    }),
  );

export const adAccountsCreateResponseSchema = adAccountSchema;

export const adGroupsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(adGroupResponseSchema).optional(),
  }),
);

export const adGroupArrayResponseSchema = z.object({
  items: z.array(adGroupArrayResponseElementSchema).optional(),
});

export const adGroupsUpdateResponseSchema = adGroupArrayResponseSchema;

export const adGroupsAudienceSizingDataSchema = z.object({
  body: adGroupAudienceSizingRequestSchema.optional(),
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const adGroupsGetResponseSchema = adGroupResponseSchema;

export const adsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(adResponseSchema).optional(),
  }),
);

export const adsCreateDataSchema = z.object({
  body: z.array(adCreateRequestSchema),
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const adsUpdateDataSchema = z.object({
  body: z.array(adUpdateRequestSchema),
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const adsGetResponseSchema = adResponseSchema;

export const audiencesListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(audienceSchema).optional(),
  }),
);

export const audiencesCreateDataSchema = z.object({
  body: audienceCreateRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const audiencesCreateResponseSchema = audienceSchema;

export const audiencesCreateCustomDataSchema = z.object({
  body: audienceCreateCustomRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const bulkDownloadCreateDataSchema = z.object({
  body: bulkDownloadRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const campaignsCreateDataSchema = z.object({
  body: z.array(campaignCreateRequestSchema),
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const campaignsCreateResponseSchema = campaignCreateResponseSchema;

export const campaignUpdateResponseSchema = campaignCreateResponseSchema;

export const conversionTagsListResponseSchema = conversionTagListResponseSchema;

export const conversionTagsCreateResponseSchema = conversionTagResponseSchema;

export const ocpmEligibleConversionTagsGetResponseSchema = conversionTagsOcpmEligibleResponseSchema;

export const pageVisitConversionTagsGetResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(conversionEventResponseSchema).optional(),
  }),
);

export const customerListsCreateDataSchema = z.object({
  body: customerListRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const customerListsUpdateDataSchema = z.object({
  body: customerListUpdateRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
    customer_list_id: z.string(),
  }),
});

export const eventsCreateDataSchema = z.object({
  body: conversionEventsSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
  query: z
    .object({
      test: z.boolean().optional(),
    })
    .optional(),
});

export const audienceInsightsScopeAndTypeGetResponseSchema = audienceDefinitionResponseSchema;

export const keywordsCreateResponseSchema = keywordsResponseSchema;

export const leadFormsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(leadFormResponseSchema).optional(),
  }),
);

export const leadFormsCreateDataSchema = z.object({
  body: z.array(leadFormCreateRequestSchema),
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const leadFormArrayResponseSchema = z.object({
  items: z
    .array(
      z.object({
        data: leadFormResponseSchema.optional(),
        exceptions: z.array(exceptionSchema).optional(),
      }),
    )
    .optional(),
});

export const leadFormsUpdateDataSchema = z.object({
  body: z.array(leadFormUpdateRequestSchema),
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const leadFormsUpdateResponseSchema = leadFormArrayResponseSchema;

export const leadFormGetResponseSchema = leadFormResponseSchema;

export const analyticsCreateMmmReportDataSchema = z.object({
  body: createMMMReportRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const orderLinesListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(orderLineSchema).optional(),
  }),
);

export const orderLinesGetResponseSchema = orderLineSchema;

export const productGroupPromotionsCreateDataSchema = z.object({
  body: productGroupPromotionCreateRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const productGroupPromotionsCreateResponseSchema = productGroupPromotionResponseSchema;

export const analyticsCreateReportDataSchema = z.object({
  body: adsAnalyticsCreateAsyncRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const analyticsCreateReportResponseSchema = adsAnalyticsCreateAsyncResponseSchema;

export const ssioInsertionOrderCreateDataSchema = z.object({
  body: sSIOCreateInsertionOrderRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const targetingTemplateCreateDataSchema = z.object({
  body: targetingTemplateCreateSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const targetingTemplateCreateResponseSchema = targetingTemplateGetResponseDataSchema;

export const boardsCreateDataSchema = z.object({
  body: boardSchema,
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const respondBusinessAccessInvitesDataSchema = z.object({
  body: authRespondInvitesBodySchema,
});

export const createAssetInvitesResponseSchema = updateInvitesResultsResponseArraySchema;

export const assetAccessRequestsCreateDataSchema = z.object({
  body: createAssetAccessRequestBodySchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const businessMemberAssetsGetResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(assetIdPermissionsSchema).optional(),
  }),
);

export const businessMembersAssetAccessUpdateResponseSchema = updateMemberAssetsResultsResponseArraySchema;

export const createMembershipOrPartnershipInvitesDataSchema = z.object({
  body: createMembershipOrPartnershipInvitesBodySchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const createMembershipOrPartnershipInvitesResponseSchema = createInvitesResultsResponseArraySchema;

export const updatePartnerAssetAccessHandlerImplDataSchema = z.object({
  body: updatePartnerAssetAccessBodySchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const assetGroupCreateDataSchema = z.object({
  body: createAssetGroupBodySchema,
  path: z.object({
    business_id: z.string(),
  }),
});

export const assetGroupCreateResponseSchema = createAssetGroupResponseSchema;

export const catalogsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(catalogSchema).optional(),
  }),
);

export const catalogsCreateResponseSchema = catalogSchema;

export const feedsCreateDataSchema = z.object({
  body: z.union([catalogsVerticalFeedsCreateRequestSchema, catalogsFeedsCreateRequestSchema]),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const catalogsFeedSchema = z.union([
  catalogsRetailFeedSchema,
  catalogsHotelFeedSchema,
  catalogsCreativeAssetsFeedSchema,
]);

export const feedsGetResponseSchema = catalogsFeedSchema;

export const feedsUpdateResponseSchema = catalogsFeedSchema;

export const feedsIngestResponseSchema = catalogsFeedIngestionSchema;

export const itemsIssuesListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(catalogsItemValidationIssuesSchema).optional(),
  }),
);

export const catalogsItemsBatchRequestSchema = z.union([
  catalogsItemsUpdateBatchRequestSchema,
  catalogsItemsUpsertBatchRequestSchema,
  catalogsItemsCreateBatchRequestSchema,
  catalogsItemsDeleteDiscontinuedBatchRequestSchema,
  catalogsItemsDeleteBatchRequestSchema,
]);

export const catalogsProductGroupCreateRequestSchema = z.object({
  name: z.string(),
  description: z.string().optional().nullable(),
  is_featured: z.boolean().optional(),
  filters: catalogsProductGroupFiltersRequestSchema,
  feed_id: z.string(),
});

export const catalogsProductGroupsProductCountsGetResponseSchema = catalogsProductGroupProductCountsVerticalSchema;

export const reportsCreateDataSchema = z.object({
  body: catalogsReportParametersSchema,
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const reportsStatsDataSchema = z.object({
  query: z.object({
    ad_account_id: z.string().optional(),
    bookmark: z.string().optional(),
    page_size: z.number().optional(),
    parameters: catalogsReportParametersSchema,
  }),
});

export const reportsStatsResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(catalogsReportStatsSchema).optional(),
  }),
);

export const integrationsLogsPostDataSchema = z.object({
  body: integrationLogsRequestSchema,
});

export const mediaCreateResponseSchema = mediaUploadSchema;

export const mediaGetResponseSchema = mediaUploadDetailsSchema;

export const pinsCreateDataSchema = z.object({
  body: pinCreateSchema,
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const pinSchema = z
  .object({
    id: z.string().optional(),
    created_at: z.string().optional(),
    link: z.string().optional().nullable(),
    title: z.string().optional().nullable(),
    description: z.string().optional().nullable(),
    dominant_color: z.string().optional().nullable(),
    alt_text: z.string().optional().nullable(),
    creative_type: creativeTypeSchema.optional().nullable(),
    board_id: z.string().optional(),
    board_section_id: z.string().optional().nullable(),
    board_owner: boardOwnerSchema.optional(),
    is_owner: z.boolean().optional(),
    media: pinMediaSchema.optional(),
    media_source: pinMediaSourceSchema.optional(),
    parent_pin_id: z.string().optional().nullable(),
    is_standard: z.boolean().optional(),
    has_been_promoted: z.boolean().optional(),
    note: z.string().optional().nullable(),
    pin_metrics: z.record(z.unknown()).optional().nullable(),
  })
  .nullable();

export const pinsGetResponseSchema = pinSchema;

export const pinsUpdateResponseSchema = pinSchema;

export const pinsSaveResponseSchema = pinSchema;

export const adAccountsCountryResponseSchema = z.object({
  items: z.array(adAccountsCountryResponseDataSchema).optional(),
});

export const searchUserPinsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(pinSchema).optional(),
  }),
);

export const searchPartnerPinsResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(summaryPinSchema).optional(),
  }),
);

export const userAccountAnalyticsResponseSchema = analyticsResponseSchema;

export const adArrayResponseElementSchema = z.object({
  data: adResponseSchema.optional(),
  exceptions: exceptionSchema.optional(),
});

export const advancedAuctionItemsGetRecordSchema = advancedAuctionKeySchema;

export const advancedAuctionBidOptionsSchema = z.object({
  bid_in_micro_currency: bidInMicroCurrencySchema.optional(),
  app_type_multipliers: appTypeMultipliersSchema.optional(),
  placement_multipliers: placementMultipliersSchema.optional(),
});

export const bulkUpsertRequestCreateSchema = z.object({
  campaigns: z.array(campaignCreateRequestSchema).optional(),
  ad_groups: z.array(adGroupCreateRequestSchema).optional(),
  ads: z.array(adCreateRequestSchema).optional(),
  product_groups: z.array(productGroupPromotionCreateRequestSchema).optional(),
  keywords: z.array(keywordsRequestSchema).optional(),
});

export const catalogsHotelBatchItemSchema = z.union([
  catalogsCreateHotelItemSchema,
  catalogsUpsertHotelItemSchema,
  catalogsUpdateHotelItemSchema,
  catalogsDeleteHotelItemSchema,
]);

export const catalogsFeedProcessingResultSchema = catalogsDbItemSchema.and(
  z.object({
    ingestion_details: catalogsFeedIngestionDetailsSchema,
    status: catalogsFeedProcessingStatusSchema,
    product_counts: catalogsFeedProductCountsSchema,
    validation_details: catalogsFeedValidationDetailsSchema,
  }),
);

export const catalogsCreativeAssetsItemsBatchSchema = z.object({
  batch_id: z.string().optional(),
  created_time: z.string().optional(),
  completed_time: z.string().optional().nullable(),
  status: batchOperationStatusSchema.optional(),
  catalog_type: z.literal('CREATIVE_ASSETS'),
  items: z.array(creativeAssetsProcessingRecordSchema).optional(),
});

export const catalogsHotelListProductsByCatalogBasedFilterRequestSchema = z.object({
  catalog_type: z.literal('HOTEL'),
  catalog_id: z.string(),
  filters: catalogsHotelProductGroupFiltersSchema,
});

export const catalogsRetailProductSchema = z.object({
  catalog_type: z.literal('RETAIL'),
  metadata: catalogsRetailProductMetadataSchema,
  pin: pinSchema,
});

export const catalogsHotelProductSchema = z.object({
  catalog_type: z.literal('HOTEL'),
  metadata: catalogsHotelProductMetadataSchema,
  pin: pinSchema,
});

export const catalogsCreativeAssetsProductSchema = z.object({
  catalog_type: z.literal('CREATIVE_ASSETS'),
  metadata: catalogsCreativeAssetsProductMetadataSchema,
  pin: pinSchema,
});

export const catalogsHotelProductGroupSchema = z.object({
  catalog_type: z.literal('HOTEL'),
  id: z.string(),
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  filters: catalogsHotelProductGroupFiltersSchema,
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  catalog_id: z.string(),
});

export const catalogsCreativeAssetsProductGroupFilterKeysSchema = z.union([
  creativeAssetsIdFilterSchema,
  customLabel0FilterSchema,
  customLabel1FilterSchema,
  customLabel2FilterSchema,
  customLabel3FilterSchema,
  customLabel4FilterSchema,
  googleProductCategory6FilterSchema,
  googleProductCategory5FilterSchema,
  googleProductCategory4FilterSchema,
  googleProductCategory3FilterSchema,
  googleProductCategory2FilterSchema,
  googleProductCategory1FilterSchema,
  googleProductCategory0FilterSchema,
  mediaTypeFilterSchema,
]);

export const catalogsCreativeAssetsProductGroupFiltersAnyOfSchema = z.object({
  any_of: z.array(catalogsCreativeAssetsProductGroupFilterKeysSchema),
});

export const catalogsProductGroupFiltersAllOfSchema = z.object({
  all_of: z.array(catalogsProductGroupFilterKeysSchema),
});

export const catalogsRetailBatchRequestSchema = z.object({
  catalog_type: z.literal('RETAIL'),
  country: countrySchema,
  language: z.union([catalogsLocaleSchema, languageSchema]),
  items: z.array(
    z.union([
      catalogsCreateRetailItemSchema,
      catalogsUpdateRetailItemSchema,
      catalogsUpsertRetailItemSchema,
      catalogsDeleteRetailItemSchema,
    ]),
  ),
});

export const catalogsHotelBatchRequestSchema = z.object({
  catalog_type: z.literal('HOTEL'),
  country: countrySchema,
  language: z.union([catalogsLocaleSchema, languageSchema]),
  items: z.array(catalogsHotelBatchItemSchema),
  catalog_id: z.string().optional(),
});

export const catalogsHotelItemResponseSchema = z.object({
  catalog_type: catalogsTypeSchema,
  hotel_id: z.string().optional(),
  pins: z.array(pinSchema).optional().nullable(),
  attributes: catalogsHotelAttributesSchema.optional(),
});

export const catalogsCreativeAssetsItemResponseSchema = z.object({
  catalog_type: catalogsTypeSchema,
  creative_assets_id: z.string().optional(),
  pins: z.array(pinSchema).optional().nullable(),
  attributes: catalogsCreativeAssetsAttributesSchema.optional(),
});

export const catalogsRetailItemResponseSchema = z.object({
  catalog_type: catalogsTypeSchema,
  item_id: z.string().optional(),
  pins: z.array(pinSchema).optional().nullable(),
  attributes: itemAttributesSchema.optional(),
});

export const catalogsCreativeAssetsBatchItemSchema = z.union([
  catalogsCreateCreativeAssetsItemSchema,
  catalogsUpsertCreativeAssetsItemSchema,
  catalogsUpdateCreativeAssetsItemSchema,
  catalogsDeleteCreativeAssetsItemSchema,
]);

export const itemResponseSchema = z.union([
  z
    .union([
      catalogsRetailItemResponseSchema,
      catalogsHotelItemResponseSchema,
      catalogsCreativeAssetsItemResponseSchema,
    ])
    .and(
      z.object({
        catalog_type: catalogsTypeSchema,
      }),
    ),
  z
    .union([
      catalogsRetailItemErrorResponseSchema,
      catalogsHotelItemErrorResponseSchema,
      catalogsCreativeAssetsItemErrorResponseSchema,
    ])
    .and(
      z.object({
        catalog_type: catalogsTypeSchema,
      }),
    ),
]);

export const parameterqueryCatalogsReportStatsParametersSchema = catalogsReportParametersSchema;

export const adGroupsCreateResponseSchema = adGroupArrayResponseSchema;

export const adArrayResponseSchema = z.object({
  items: z.array(adArrayResponseElementSchema).optional(),
});

export const adsUpdateResponseSchema = adArrayResponseSchema;

export const bulkUpsertRequestSchema = z.object({
  create: bulkUpsertRequestCreateSchema.optional(),
  update: bulkUpsertRequestUpdateSchema.optional(),
});

export const campaignsUpdateResponseSchema = campaignUpdateResponseSchema;

export const leadFormsCreateResponseSchema = leadFormArrayResponseSchema;

export const advancedAuctionItemsGetRequestSchema = z.object({
  catalog_id: z.string(),
  items: z.array(advancedAuctionItemsGetRecordSchema),
});

export const feedsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(catalogsFeedSchema).optional(),
  }),
);

export const feedsCreateResponseSchema = catalogsFeedSchema;

export const feedProcessingResultsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(catalogsFeedProcessingResultSchema).optional(),
  }),
);

export const catalogsItemsSchema = z.object({
  items: z.array(itemResponseSchema).optional(),
});

export const itemsPostResponseSchema = catalogsItemsSchema;

export const catalogsItemsBatchSchema = z
  .union([catalogsRetailItemsBatchSchema, catalogsHotelItemsBatchSchema, catalogsCreativeAssetsItemsBatchSchema])
  .and(
    z.object({
      catalog_type: catalogsTypeSchema,
    }),
  );

export const itemsBatchGetResponseSchema = catalogsItemsBatchSchema;

export const pinsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(pinSchema).optional(),
  }),
);

export const pinsCreateResponseSchema = pinSchema;

export const adAccountCountriesGetResponseSchema = adAccountsCountryResponseSchema;

export const advancedAuctionItemSchema = advancedAuctionKeySchema.and(
  z.object({
    bid_options: advancedAuctionBidOptionsSchema,
  }),
);

export const advancedAuctionItemsSubmitUpsertRecordSchema = advancedAuctionItemSchema.and(
  z.object({
    update_mask: z.array(updateMaskBidOptionFieldSchema).nullable(),
  }),
);

export const advancedAuctionItemsSubmitRecordSchema = z
  .union([advancedAuctionItemsSubmitUpsertRecordSchema, advancedAuctionItemsSubmitDeleteRecordSchema])
  .and(
    z.object({
      operation: advancedAuctionOperationSchema,
    }),
  );

export const catalogsProductGroupFiltersSchema = z.union([
  catalogsProductGroupFiltersAnyOfSchema,
  catalogsProductGroupFiltersAllOfSchema,
]);

export const catalogsRetailListProductsByCatalogBasedFilterRequestSchema = z.object({
  catalog_type: z.literal('RETAIL'),
  catalog_id: z.string(),
  filters: catalogsProductGroupFiltersSchema,
  country: countrySchema,
  locale: catalogsLocaleSchema,
});

export const catalogsProductSchema = z
  .union([catalogsRetailProductSchema, catalogsHotelProductSchema, catalogsCreativeAssetsProductSchema])
  .and(
    z.object({
      catalog_type: catalogsTypeSchema,
    }),
  );

export const catalogsRetailProductGroupSchema = z.object({
  catalog_type: z.literal('RETAIL'),
  id: z.string(),
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  filters: catalogsProductGroupFiltersSchema,
  is_featured: z.boolean().optional(),
  type: catalogsProductGroupTypeSchema.optional(),
  status: catalogsProductGroupStatusSchema.optional(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  catalog_id: z.string(),
  feed_id: z.string().nullable(),
  country: z.string().optional().nullable(),
  locale: z.string().optional().nullable(),
});

export const catalogsCreativeAssetsProductGroupFiltersAllOfSchema = z.object({
  all_of: z.array(catalogsCreativeAssetsProductGroupFilterKeysSchema),
});

export const catalogsCreativeAssetsProductGroupFiltersSchema = z.union([
  catalogsCreativeAssetsProductGroupFiltersAnyOfSchema,
  catalogsCreativeAssetsProductGroupFiltersAllOfSchema,
]);

export const catalogsCreativeAssetsProductGroupUpdateRequestSchema = z.object({
  catalog_type: z.literal('CREATIVE_ASSETS').optional(),
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  filters: catalogsCreativeAssetsProductGroupFiltersSchema.optional(),
});

export const catalogsCreativeAssetsBatchRequestSchema = z.object({
  catalog_type: z.literal('CREATIVE_ASSETS'),
  country: countrySchema,
  language: z.union([catalogsLocaleSchema, languageSchema]),
  items: z.array(catalogsCreativeAssetsBatchItemSchema),
  catalog_id: z.string().optional(),
});

export const catalogsCreativeAssetsProductGroupCreateRequestSchema = z.object({
  catalog_type: z.literal('CREATIVE_ASSETS'),
  name: z.string(),
  description: z.string().optional().nullable(),
  filters: catalogsCreativeAssetsProductGroupFiltersSchema,
  catalog_id: z.string(),
});

export const catalogsVerticalProductGroupUpdateRequestSchema = z.union([
  catalogsRetailProductGroupUpdateRequestSchema,
  catalogsHotelProductGroupUpdateRequestSchema,
  catalogsCreativeAssetsProductGroupUpdateRequestSchema,
]);

export const adsCreateResponseSchema = adArrayResponseSchema;

export const bulkUpsertCreateDataSchema = z.object({
  body: bulkUpsertRequestSchema,
  path: z.object({
    ad_account_id: z.string(),
  }),
});

export const advancedAuctionItemsGetPostDataSchema = z.object({
  body: advancedAuctionItemsGetRequestSchema,
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const advancedAuctionItemsSchema = z.object({
  catalog_id: z.string().optional(),
  items: z.array(advancedAuctionItemSchema).optional(),
});

export const advancedAuctionItemsSubmitRequestSchema = z.object({
  catalog_id: z.string(),
  items: z.array(advancedAuctionItemsSubmitRecordSchema),
});

export const itemsGetResponseSchema = catalogsItemsSchema;

export const catalogsVerticalBatchRequestSchema = z.union([
  catalogsRetailBatchRequestSchema,
  catalogsHotelBatchRequestSchema,
  catalogsCreativeAssetsBatchRequestSchema,
]);

export const itemsBatchPostResponseSchema = catalogsItemsBatchSchema;

export const catalogsVerticalProductGroupCreateRequestSchema = z.union([
  catalogsRetailProductGroupCreateRequestSchema,
  catalogsHotelProductGroupCreateRequestSchema,
  catalogsCreativeAssetsProductGroupCreateRequestSchema,
]);

export const catalogsProductGroupsCreateDataSchema = z.object({
  body: z.union([catalogsProductGroupCreateRequestSchema, catalogsVerticalProductGroupCreateRequestSchema]),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const catalogsProductGroupsUpdateDataSchema = z.object({
  body: z.union([catalogsProductGroupUpdateRequestSchema, catalogsVerticalProductGroupUpdateRequestSchema]),
  path: z.object({
    product_group_id: z.string(),
  }),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const advancedAuctionProcessedItemSchema = advancedAuctionItemsSubmitRecordSchema.and(
  z.object({
    errors: z.array(advancedAuctionOperationErrorSchema).optional(),
  }),
);

export const catalogsListProductsByFeedBasedFilterSchema = z.object({
  feed_id: z.string(),
  filters: catalogsProductGroupFiltersSchema,
});

export const catalogsCreativeAssetsListProductsByCatalogBasedFilterRequestSchema = z.object({
  catalog_type: z.literal('CREATIVE_ASSETS'),
  catalog_id: z.string(),
  filters: catalogsCreativeAssetsProductGroupFiltersSchema,
});

export const catalogsCreativeAssetsProductGroupSchema = z.object({
  catalog_type: z.literal('CREATIVE_ASSETS'),
  id: z.string(),
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  filters: catalogsCreativeAssetsProductGroupFiltersSchema,
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  catalog_id: z.string(),
});

export const advancedAuctionItemsGetPostResponseSchema = advancedAuctionItemsSchema;

export const advancedAuctionItemsSubmitPostDataSchema = z.object({
  body: advancedAuctionItemsSubmitRequestSchema,
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const advancedAuctionProcessedItemsSchema = z.object({
  catalog_id: z.string().optional(),
  items: z.array(advancedAuctionProcessedItemSchema).optional(),
});

export const itemsBatchPostDataSchema = z.object({
  body: z.union([catalogsVerticalBatchRequestSchema, catalogsItemsBatchRequestSchema]),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const catalogsProductGroupsCreateManyDataSchema = z.object({
  body: z.array(z.union([catalogsProductGroupCreateRequestSchema, catalogsVerticalProductGroupCreateRequestSchema])),
  query: z
    .object({
      ad_account_id: z.string().optional(),
    })
    .optional(),
});

export const catalogsVerticalProductGroupSchema = z.union([
  catalogsRetailProductGroupSchema,
  catalogsHotelProductGroupSchema,
  catalogsCreativeAssetsProductGroupSchema,
]);

export const catalogsProductGroupsGetResponseSchema = catalogsVerticalProductGroupSchema;

export const catalogsProductGroupsUpdateResponseSchema = catalogsVerticalProductGroupSchema;

export const catalogsVerticalsListProductsByCatalogBasedFilterRequestSchema = z.union([
  catalogsRetailListProductsByCatalogBasedFilterRequestSchema,
  catalogsHotelListProductsByCatalogBasedFilterRequestSchema,
  catalogsCreativeAssetsListProductsByCatalogBasedFilterRequestSchema,
]);

export const advancedAuctionItemsSubmitPostResponseSchema = advancedAuctionProcessedItemsSchema;

export const catalogsProductGroupsListResponseSchema = paginatedSchema.and(
  z.object({
    items: z.array(catalogsVerticalProductGroupSchema).optional(),
  }),
);

export const catalogsProductGroupsCreateResponseSchema = catalogsVerticalProductGroupSchema;

export const catalogsListProductsByFilterRequestSchema = z.union([
  catalogsListProductsByFeedBasedFilterSchema,
  catalogsVerticalsListProductsByCatalogBasedFilterRequestSchema,
]);

export const productsByProductGroupFilterListDataSchema = z.object({
  body: catalogsListProductsByFilterRequestSchema,
  query: z
    .object({
      ad_account_id: z.string().optional(),
      bookmark: z.string().optional(),
      page_size: z.number().optional(),
      pin_metrics: z.boolean().optional(),
    })
    .optional(),
});
